%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinspiral
Version: 1.7.5
Release: 1%{?dist}
Summary: LSC Algorithm Inspiral Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: gsl-devel
BuildRequires: libmetaio-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.16.1
BuildRequires: lal-python >= 6.16.1
BuildRequires: lal-octave >= 6.16.1
BuildRequires: lalframe-devel >= 1.4.1
BuildRequires: lalframe-python >= 1.4.1
BuildRequires: lalframe-octave >= 1.4.1
BuildRequires: lalmetaio-devel >= 1.2.8
BuildRequires: lalmetaio-python >= 1.2.8
BuildRequires: lalmetaio-octave >= 1.2.8
BuildRequires: lalsimulation-devel >= 1.6.0
BuildRequires: lalsimulation-python >= 1.6.0
BuildRequires: lalsimulation-octave >= 1.6.0
Requires: gsl
Requires: libframe
Requires: libmetaio
Requires: lal >= 6.16.1
Requires: lalframe >= 1.4.1
Requires: lalmetaio >= 1.2.8
Requires: lalsimulation >= 1.6.0
Prefix: %{_prefix}

%description
The LSC Algorithm Inspiral Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inspiral library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inspiral
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: libframe-devel
Requires: libmetaio-devel
Requires: lal-devel >= 6.16.1
Requires: lalframe-devel >= 1.4.1
Requires: lalmetaio-devel >= 1.2.8
Requires: lalsimulation-devel >= 1.6.0
%description devel
The LSC Algorithm Inspiral Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inspiral
library.

%package python
Summary: Python bindings for LALInspiral
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.16.1
Requires: lalframe-python >= 1.4.1
Requires: lalmetaio-python >= 1.2.8
Requires: lalsimulation-python >= 1.6.0
%description python
This package provides the Python bindings for LALInspiral.

%package octave
Summary: Octave bindings for LALInspiral
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.16.1
Requires: lalframe-octave >= 1.4.1
Requires: lalmetaio-octave >= 1.2.8
Requires: lalsimulation-octave >= 1.6.0
%description octave
This package provides the Octave bindings for LALInspiral.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalinspiral/*.py
%{_libdir}/python*/site-packages/lalinspiral/*.pyc
%{_libdir}/python*/site-packages/lalinspiral/_lalinspiral.so*
%{_libdir}/python*/site-packages/lalinspiral/sbank/*.py
%{_libdir}/python*/site-packages/lalinspiral/sbank/*.pyc
%exclude %{_libdir}/python*/site-packages/lalinspiral/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinspiral/sbank/*.pyo

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalinspiral.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.5-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.4-1
- Pre O2 packaging test release
