%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinspiral
Version: 1.7.6
Release: 1%{?dist}
Summary: LSC Algorithm Inspiral Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: gsl-devel
BuildRequires: libmetaio-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.17.0
BuildRequires: lal-python >= 6.17.0
BuildRequires: lal-octave >= 6.17.0
BuildRequires: lalframe-devel >= 1.4.2
BuildRequires: lalframe-python >= 1.4.2
BuildRequires: lalframe-octave >= 1.4.2
BuildRequires: lalmetaio-devel >= 1.3.0
BuildRequires: lalmetaio-python >= 1.3.0
BuildRequires: lalmetaio-octave >= 1.3.0
BuildRequires: lalsimulation-devel >= 1.6.1
BuildRequires: lalsimulation-python >= 1.6.1
BuildRequires: lalsimulation-octave >= 1.6.1
Requires: gsl
Requires: libframe
Requires: libmetaio
Requires: lal >= 6.17.0
Requires: lalframe >= 1.4.2
Requires: lalmetaio >= 1.3.0
Requires: lalsimulation >= 1.6.1
Prefix: %{_prefix}

%description
The LSC Algorithm Inspiral Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inspiral library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inspiral
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: libframe-devel
Requires: libmetaio-devel
Requires: lal-devel >= 6.17.0
Requires: lalframe-devel >= 1.4.2
Requires: lalmetaio-devel >= 1.3.0
Requires: lalsimulation-devel >= 1.6.1
%description devel
The LSC Algorithm Inspiral Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inspiral
library.

%package python
Summary: Python bindings for LALInspiral
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.17.0
Requires: lalframe-python >= 1.4.2
Requires: lalmetaio-python >= 1.3.0
Requires: lalsimulation-python >= 1.6.1
%description python
This package provides the Python bindings for LALInspiral.

%package octave
Summary: Octave bindings for LALInspiral
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.17.0
Requires: lalframe-octave >= 1.4.2
Requires: lalmetaio-octave >= 1.3.0
Requires: lalsimulation-octave >= 1.6.1
%description octave
This package provides the Octave bindings for LALInspiral.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalinspiral.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.6-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.5-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.4-1
- Pre O2 packaging test release
