/* Automatically generated from ./remote/remote_protocol.x by gendispatch.pl.
 * Do not edit this file.  Any changes you make will be lost.
 */
#include <config.h>
#include "access/viraccessapicheck.h"
#include "access/viraccessmanager.h"
#include "datatypes.h"
#include "virerror.h"

#define VIR_FROM_THIS VIR_FROM_ACCESS

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectBaselineCPUEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectBaselineHypervisorCPUEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectCompareCPUEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectCompareHypervisorCPUEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainEventCallbackDeregisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainEventCallbackRegisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectDomainEventCallbackRegisterAnyCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainEventDeregisterEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainEventDeregisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainEventRegisterEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectDomainEventRegisterCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainEventRegisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectDomainEventRegisterAnyCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainXMLFromNativeEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectDomainXMLToNativeEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectFindStoragePoolSourcesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_DETECT_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetAllDomainStatsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectGetAllDomainStatsCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetCapabilitiesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetCPUModelNamesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetDomainCapabilitiesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetHostnameEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetLibVersionEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetMaxVcpusEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetStoragePoolCapabilitiesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetSysinfoEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetTypeEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetURIEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectGetVersionEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllDomainsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllDomainsCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllInterfacesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_INTERFACES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllInterfacesCheckACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllNetworksEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NETWORKS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllNetworksCheckACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllNodeDevicesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NODE_DEVICES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllNodeDevicesCheckACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllNWFilterBindingsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NWFILTER_BINDINGS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllNWFilterBindingsCheckACL(virConnectPtr conn, virNWFilterBindingDefPtr binding)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNWFilterBinding(mgr, conn->driver->name, binding, VIR_ACCESS_PERM_NWFILTER_BINDING_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllNWFiltersEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NWFILTERS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllNWFiltersCheckACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllSecretsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_SECRETS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllSecretsCheckACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListAllStoragePoolsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListAllStoragePoolsCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListDefinedDomainsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListDefinedDomainsCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListDefinedInterfacesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_INTERFACES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListDefinedInterfacesCheckACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListDefinedNetworksEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NETWORKS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListDefinedNetworksCheckACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListDefinedStoragePoolsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListDefinedStoragePoolsCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListDomainsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListDomainsCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListInterfacesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_INTERFACES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListInterfacesCheckACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListNetworksEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NETWORKS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListNetworksCheckACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListNWFiltersEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NWFILTERS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListNWFiltersCheckACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListSecretsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_SECRETS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListSecretsCheckACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectListStoragePoolsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectListStoragePoolsCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNetworkEventDeregisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNetworkEventRegisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NETWORKS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNetworkEventRegisterAnyCheckACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNodeDeviceEventDeregisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNodeDeviceEventRegisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NODE_DEVICES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNodeDeviceEventRegisterAnyCheckACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfDefinedDomainsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfDefinedDomainsCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfDefinedInterfacesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_INTERFACES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfDefinedInterfacesCheckACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfDefinedNetworksEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NETWORKS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfDefinedNetworksCheckACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfDefinedStoragePoolsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfDefinedStoragePoolsCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfDomainsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_DOMAINS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfDomainsCheckACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfInterfacesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_INTERFACES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfInterfacesCheckACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfNetworksEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NETWORKS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfNetworksCheckACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfNWFiltersEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NWFILTERS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfNWFiltersCheckACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfSecretsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_SECRETS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfSecretsCheckACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectNumOfStoragePoolsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectNumOfStoragePoolsCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectOpenEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectRegisterCloseCallbackEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectSecretEventDeregisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectSecretEventRegisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_SECRETS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectSecretEventRegisterAnyCheckACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectSetIdentityEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectStoragePoolEventDeregisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectStoragePoolEventRegisterAnyEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_STORAGE_POOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virConnectStoragePoolEventRegisterAnyCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectSupportsFeatureEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virConnectUnregisterCloseCallbackEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainAbortJobEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainAddIOThreadEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainAttachDeviceEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainAttachDeviceFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockCommitEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_BLOCK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockCopyEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_BLOCK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockJobAbortEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockJobSetSpeedEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockPeekEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_BLOCK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockPullEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_BLOCK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockRebaseEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_BLOCK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockResizeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_BLOCK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockStatsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainBlockStatsFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCheckpointCreateXMLEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_CHECKPOINT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_CHECKPOINT_CREATE_QUIESCE)) == (VIR_DOMAIN_CHECKPOINT_CREATE_QUIESCE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_FS_FREEZE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCheckpointDeleteEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_CHECKPOINT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCheckpointGetParentEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCheckpointGetXMLDescEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_CHECKPOINT_XML_SECURE)) == (VIR_DOMAIN_CHECKPOINT_XML_SECURE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ_SECURE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCheckpointListAllChildrenEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCheckpointLookupByNameEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCoreDumpEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_CORE_DUMP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCoreDumpWithFormatEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_CORE_DUMP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCreateEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCreateWithFilesEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCreateWithFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCreateXMLEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainCreateXMLWithFilesEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDefineXMLEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDefineXMLFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDelIOThreadEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDestroyEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_STOP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDestroyFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_STOP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDetachDeviceEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDetachDeviceAliasEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainDetachDeviceFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainFSFreezeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_FS_FREEZE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainFSThawEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_FS_FREEZE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainFSTrimEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_FS_TRIM)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetAutostartEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetBlkioParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetBlockInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetBlockIoTuneEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetBlockJobInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetControlInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetCPUStatsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetDiskErrorsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetEmulatorPinInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetFSInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_FS_FREEZE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetGuestInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetGuestVcpusEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetHostnameEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetInterfaceParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetIOThreadInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetJobInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetJobStatsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetLaunchSecurityInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetMaxMemoryEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetMaxVcpusEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetMemoryParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetMetadataEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetNumaParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetOSTypeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetPerfEventsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetSchedulerParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetSchedulerParametersFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetSchedulerTypeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetSecurityLabelEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetSecurityLabelListEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetStateEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetTimeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetVcpuPinInfoEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetVcpusEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetVcpusFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_VCPU_GUEST)) == (VIR_DOMAIN_VCPU_GUEST)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainGetXMLDescEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_XML_SECURE)) == (VIR_DOMAIN_XML_SECURE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ_SECURE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_XML_MIGRATABLE)) == (VIR_DOMAIN_XML_MIGRATABLE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ_SECURE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainHasCurrentSnapshotEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainHasManagedSaveImageEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainInjectNMIEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_INJECT_NMI)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainInterfaceAddressesEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainInterfaceStatsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainIsActiveEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainIsPersistentEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainIsUpdatedEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainListAllCheckpointsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainListAllSnapshotsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainLookupByIDEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainLookupByNameEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainLookupByUUIDEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainManagedSaveEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_HIBERNATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainManagedSaveDefineXMLEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_HIBERNATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainManagedSaveGetXMLDescEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_SAVE_IMAGE_XML_SECURE)) == (VIR_DOMAIN_SAVE_IMAGE_XML_SECURE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ_SECURE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainManagedSaveRemoveEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_HIBERNATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMemoryPeekEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MEM_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMemoryStatsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateBegin3EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateBegin3ParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateConfirm3EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateConfirm3ParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateFinishEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateFinish2EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateFinish3EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateFinish3ParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateGetCompressionCacheEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateGetMaxDowntimeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateGetMaxSpeedEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePerformEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePerform3EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePerform3ParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepareEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepare2EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepare3EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepare3ParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepareTunnelEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepareTunnel3EnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigratePrepareTunnel3ParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateSetCompressionCacheEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateSetMaxDowntimeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateSetMaxSpeedEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainMigrateStartPostCopyEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_MIGRATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainOpenChannelEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_OPEN_DEVICE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainOpenConsoleEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_OPEN_DEVICE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainOpenGraphicsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_OPEN_GRAPHICS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainOpenGraphicsFdEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_OPEN_GRAPHICS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainPinEmulatorEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainPinIOThreadEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainPinVcpuEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainPinVcpuFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainPMSuspendForDurationEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_PM_CONTROL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainPMWakeupEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_PM_CONTROL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainRebootEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_INIT_CONTROL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_REBOOT_GUEST_AGENT)) == (VIR_DOMAIN_REBOOT_GUEST_AGENT)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainRenameEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainResetEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_RESET)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainRestoreEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainRestoreFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainResumeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SUSPEND)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainRevertToSnapshotEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SNAPSHOT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSaveEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_HIBERNATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSaveFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_HIBERNATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSaveImageDefineXMLEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_HIBERNATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSaveImageGetXMLDescEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainScreenshotEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SCREENSHOT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSendKeyEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SEND_INPUT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSendProcessSignalEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SEND_SIGNAL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetAutostartEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetBlkioParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetBlockIoTuneEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetBlockThresholdEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetGuestVcpusEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetInterfaceParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetIOThreadParamsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetLifecycleActionEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetMaxMemoryEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetMemoryEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetMemoryFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetMemoryParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetMemoryStatsPeriodEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetMetadataEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetNumaParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetPerfEventsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetSchedulerParametersEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetSchedulerParametersFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetTimeEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SET_TIME)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetUserPasswordEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SET_PASSWORD)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetVcpuEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetVcpusEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSetVcpusFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_VCPU_GUEST)) == (VIR_DOMAIN_VCPU_GUEST)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainShutdownEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_INIT_CONTROL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainShutdownFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_INIT_CONTROL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_SHUTDOWN_GUEST_AGENT)) == (VIR_DOMAIN_SHUTDOWN_GUEST_AGENT)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotCreateXMLEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SNAPSHOT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_SNAPSHOT_CREATE_QUIESCE)) == (VIR_DOMAIN_SNAPSHOT_CREATE_QUIESCE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_FS_FREEZE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotCurrentEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotDeleteEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SNAPSHOT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotGetParentEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotGetXMLDescEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_SNAPSHOT_XML_SECURE)) == (VIR_DOMAIN_SNAPSHOT_XML_SECURE)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ_SECURE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotHasMetadataEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotIsCurrentEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotListAllChildrenEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotListChildrenNamesEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotListNamesEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotLookupByNameEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotNumEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSnapshotNumChildrenEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainSuspendEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SUSPEND)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainUndefineEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainUndefineFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virDomainUpdateDeviceFlagsEnsureACL(virConnectPtr conn, virDomainDefPtr domain, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG|VIR_DOMAIN_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_DOMAIN_AFFECT_CONFIG)) == (VIR_DOMAIN_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckDomain(mgr, conn->driver->name, domain, VIR_ACCESS_PERM_DOMAIN_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceChangeBeginEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_INTERFACE_TRANSACTION)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceChangeCommitEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_INTERFACE_TRANSACTION)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceChangeRollbackEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_INTERFACE_TRANSACTION)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceCreateEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceDefineXMLEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceDestroyEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_STOP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceGetXMLDescEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceIsActiveEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceLookupByMACStringEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceLookupByNameEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virInterfaceUndefineEnsureACL(virConnectPtr conn, virInterfaceDefPtr iface)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckInterface(mgr, conn->driver->name, iface, VIR_ACCESS_PERM_INTERFACE_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkCreateEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkCreateXMLEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkDefineXMLEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkDestroyEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_STOP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkGetAutostartEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkGetBridgeNameEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkGetDHCPLeasesEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkGetXMLDescEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkIsActiveEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkIsPersistentEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkListAllPortsEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_SEARCH_PORTS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virNetworkListAllPortsCheckACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkLookupByNameEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkLookupByUUIDEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkPortCreateXMLEnsureACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_CREATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkPortDeleteEnsureACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkPortGetParametersEnsureACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkPortGetXMLDescEnsureACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkPortLookupByUUIDEnsureACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkPortSetParametersEnsureACL(virConnectPtr conn, virNetworkDefPtr net, virNetworkPortDefPtr port)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetworkPort(mgr, conn->driver->name, net, port, VIR_ACCESS_PERM_NETWORK_PORT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkSetAutostartEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkUndefineEnsureACL(virConnectPtr conn, virNetworkDefPtr network)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNetworkUpdateEnsureACL(virConnectPtr conn, virNetworkDefPtr network, unsigned int flags)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_NETWORK_UPDATE_AFFECT_CONFIG|VIR_NETWORK_UPDATE_AFFECT_LIVE)) == 0) &&
        (rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if (((flags & (VIR_NETWORK_UPDATE_AFFECT_CONFIG)) == (VIR_NETWORK_UPDATE_AFFECT_CONFIG)) &&
        (rv = virAccessManagerCheckNetwork(mgr, conn->driver->name, network, VIR_ACCESS_PERM_NETWORK_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeAllocPagesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceCreateXMLEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceDestroyEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_STOP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceDetachFlagsEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_DETACH)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceDettachEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_DETACH)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceGetParentEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceGetXMLDescEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceListCapsEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceLookupByNameEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceLookupSCSIHostByWWNEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceNumOfCapsEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceReAttachEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_DETACH)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeDeviceResetEnsureACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_DETACH)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetCellsFreeMemoryEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetCPUMapEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetCPUStatsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetFreeMemoryEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetFreePagesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetInfoEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetMemoryParametersEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetMemoryStatsEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetSecurityModelEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeGetSevInfoEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeListDevicesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NODE_DEVICES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virNodeListDevicesCheckACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeNumOfDevicesEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_SEARCH_NODE_DEVICES)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virNodeNumOfDevicesCheckACL(virConnectPtr conn, virNodeDeviceDefPtr device)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckNodeDevice(mgr, conn->driver->name, device, VIR_ACCESS_PERM_NODE_DEVICE_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeSetMemoryParametersEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNodeSuspendForDurationEnsureACL(virConnectPtr conn)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckConnect(mgr, conn->driver->name, VIR_ACCESS_PERM_CONNECT_PM_CONTROL)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterBindingCreateXMLEnsureACL(virConnectPtr conn, virNWFilterBindingDefPtr binding)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilterBinding(mgr, conn->driver->name, binding, VIR_ACCESS_PERM_NWFILTER_BINDING_CREATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterBindingDeleteEnsureACL(virConnectPtr conn, virNWFilterBindingDefPtr binding)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilterBinding(mgr, conn->driver->name, binding, VIR_ACCESS_PERM_NWFILTER_BINDING_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterBindingGetXMLDescEnsureACL(virConnectPtr conn, virNWFilterBindingDefPtr binding)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilterBinding(mgr, conn->driver->name, binding, VIR_ACCESS_PERM_NWFILTER_BINDING_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterBindingLookupByPortDevEnsureACL(virConnectPtr conn, virNWFilterBindingDefPtr binding)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilterBinding(mgr, conn->driver->name, binding, VIR_ACCESS_PERM_NWFILTER_BINDING_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterDefineXMLEnsureACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterGetXMLDescEnsureACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterLookupByNameEnsureACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterLookupByUUIDEnsureACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virNWFilterUndefineEnsureACL(virConnectPtr conn, virNWFilterDefPtr nwfilter)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckNWFilter(mgr, conn->driver->name, nwfilter, VIR_ACCESS_PERM_NWFILTER_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretDefineXMLEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretGetValueEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_READ_SECURE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretGetXMLDescEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretLookupByUsageEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretLookupByUUIDEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretSetValueEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virSecretUndefineEnsureACL(virConnectPtr conn, virSecretDefPtr secret)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckSecret(mgr, conn->driver->name, secret, VIR_ACCESS_PERM_SECRET_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolBuildEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_FORMAT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolCreateEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolCreateXMLEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_START)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolDefineXMLEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_SAVE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolDeleteEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_FORMAT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolDestroyEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_STOP)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolGetAutostartEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolGetInfoEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolGetXMLDescEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolIsActiveEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolIsPersistentEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolListAllVolumesEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_SEARCH_STORAGE_VOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virStoragePoolListAllVolumesCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolListVolumesEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_SEARCH_STORAGE_VOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virStoragePoolListVolumesCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolLookupByNameEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolLookupByTargetPathEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolLookupByUUIDEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolLookupByVolumeEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolNumOfVolumesEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_SEARCH_STORAGE_VOLS)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: false on error/denied, true on allowed */
bool virStoragePoolNumOfVolumesCheckACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        virResetLastError();
        return false;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        virResetLastError();
        return false;
    }
    virObjectUnref(mgr);
    return true;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolRefreshEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_REFRESH)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolSetAutostartEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStoragePoolUndefineEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStoragePool(mgr, conn->driver->name, pool, VIR_ACCESS_PERM_STORAGE_POOL_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolCreateXMLEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_CREATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolCreateXMLFromEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_CREATE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolDeleteEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_DELETE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolDownloadEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_DATA_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolGetInfoEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolGetInfoFlagsEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolGetPathEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolGetXMLDescEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_READ)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolLookupByKeyEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolLookupByNameEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolLookupByPathEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_GETATTR)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolResizeEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_RESIZE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolUploadEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_DATA_WRITE)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolWipeEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_FORMAT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

/* Returns: -1 on error/denied, 0 on allowed */
int virStorageVolWipePatternEnsureACL(virConnectPtr conn, virStoragePoolDefPtr pool, virStorageVolDefPtr vol)
{
    virAccessManagerPtr mgr;
    int rv;

    if (!(mgr = virAccessManagerGetDefault())) {
        return -1;
    }

    if ((rv = virAccessManagerCheckStorageVol(mgr, conn->driver->name, pool, vol, VIR_ACCESS_PERM_STORAGE_VOL_FORMAT)) <= 0) {
        virObjectUnref(mgr);
        if (rv == 0)
            virReportError(VIR_ERR_ACCESS_DENIED,
                            _("'%s' denied access"), conn->driver->name);
        return -1;
    }
    virObjectUnref(mgr);
    return 0;
}

