!RUN: %flang_fc1 -emit-hlfir %s -o - | FileCheck %s

!CHECK-LABEL: func.func @_QPpath_only
!CHECK-SAME:    %[[dummyPath:.*]]: !fir.boxchar<1> {fir.bindc_name = "path"}) {
subroutine path_only(path)
    CHARACTER(len=*) :: path
    !CHECK-DAG:    %[[scope:.*]] = fir.dummy_scope : !fir.dscope
    !CHECK-DAG:    %[[unbox_path:.*]]:2 = fir.unboxchar %[[dummyPath]] : (!fir.boxchar<1>) -> (!fir.ref<!fir.char<1,?>>, index)
    !CHECK-DAG:    %[[path_decl:.*]]:2 = hlfir.declare %[[unbox_path]]#0 typeparams %[[unbox_path]]#1 dummy_scope %[[scope]] {uniq_name = "_QFpath_onlyEpath"} : (!fir.ref<!fir.char<1,?>>, index, !fir.dscope) -> (!fir.boxchar<1>, !fir.ref<!fir.char<1,?>>)
    !CHECK-DAG:    %[[src_path_addr:.*]] = fir.address_of(@_{{.*}}) : !fir.ref<!fir.char<1,{{.*}}>>
    !CHECK-DAG:    %[[line_value:.*]] = arith.constant {{.*}} : i64
    !CHECK-DAG:    %[[path:.*]] = fir.convert %[[path_decl]]#1 : (!fir.ref<!fir.char<1,?>>) -> !fir.ref<i8>
    !CHECK-DAG:    %[[path_len:.*]] = fir.convert %[[unbox_path]]#1 : (index) -> i64
    !CHECK-DAG:    %[[src_path:.*]] = fir.convert %[[src_path_addr]] : (!fir.ref<!fir.char<1,{{.*}}>) -> !fir.ref<i8>
    !CHECK-DAG:    %[[line:.*]] = fir.convert %[[line_value]] : (i64) -> i32
    !CHECK:        fir.call @_FortranAUnlink(%[[path]], %[[path_len]], %[[src_path]], %[[line]])
    !CHECK-SAME:   : (!fir.ref<i8>, i64, !fir.ref<i8>, i32)
    !CHECK-SAME:   -> i32
    call unlink(path)
    !CHECK:        return
end subroutine path_only
    !CHECK:         }

    !CHECK-LABEL: func.func @_QPall_arguments
    !CHECK-SAME:    %[[dummyPath:.*]]: !fir.boxchar<1> {fir.bindc_name = "path"}
    !CHECK-SAME:    %[[dummyStat:.*]]: !fir.ref<i32> {fir.bindc_name = "status"}
    !CHECK-SAME:    ) {
subroutine all_arguments(path, status)
    CHARACTER(len=*) :: path
    INTEGER :: status
    !CHECK-DAG:    %[[scope:.*]] = fir.dummy_scope : !fir.dscope
    !CHECK-DAG:    %[[unbox_path:.*]]:2 = fir.unboxchar %[[dummyPath]] : (!fir.boxchar<1>) -> (!fir.ref<!fir.char<1,?>>, index)
    !CHECK-DAG:    %[[path_decl:.*]]:2 = hlfir.declare %[[unbox_path]]#0 typeparams %[[unbox_path]]#1 dummy_scope %[[scope]] {uniq_name = "_QFall_argumentsEpath"} : (!fir.ref<!fir.char<1,?>>, index, !fir.dscope) -> (!fir.boxchar<1>, !fir.ref<!fir.char<1,?>>)
    !CHECK-DAG:    %[[status_decl:.*]]:2 = hlfir.declare %[[dummyStat]] dummy_scope %[[scope]] {uniq_name = "_QFall_argumentsEstatus"} : (!fir.ref<i32>, !fir.dscope) -> (!fir.ref<i32>, !fir.ref<i32>)
    !CHECK-DAG:    %[[src_path_addr:.*]] = fir.address_of(@_{{.*}}) : !fir.ref<!fir.char<1,{{.*}}>>
    !CHECK-DAG:    %[[line_value:.*]] = arith.constant {{.*}} : i64
    !CHECK-DAG:    %[[path:.*]] = fir.convert %[[path_decl]]#1 : (!fir.ref<!fir.char<1,?>>) -> !fir.ref<i8>
    !CHECK-DAG:    %[[path_len:.*]] = fir.convert %[[unbox_path]]#1 : (index) -> i64
    !CHECK-DAG:    %[[src_path:.*]] = fir.convert %[[src_path_addr]] : (!fir.ref<!fir.char<1,{{.*}}>) -> !fir.ref<i8>
    !CHECK-DAG:    %[[line:.*]] = fir.convert %[[line_value]] : (i64) -> i32
    !CHECK:        %[[unlink_result:.*]] = fir.call @_FortranAUnlink(%[[path]], %[[path_len]], %[[src_path]], %[[line]])
    !CHECK-SAME:   : (!fir.ref<i8>, i64, !fir.ref<i8>, i32)
    !CHECK-SAME:   -> i32
  
    !CHECK-DAG:    %[[status_i64:.*]] = fir.convert %[[status_decl]]#0 : (!fir.ref<i32>) -> i64
    !CHECK-DAG:    %[[c_null:.*]] = arith.constant 0 : i64
    !CHECK-DAG:    %[[cmp_result:.*]] = arith.cmpi ne, %[[status_i64]], %[[c_null]] : i64
    !CHECK:        fir.if %[[cmp_result]] {
    !CHECK-NEXT:   fir.store %[[unlink_result]] to %[[status_decl]]#0 : !fir.ref<i32>
    !CHECK-NEXT:   }
    call unlink(path, status)
    !CHECK:        return
end subroutine all_arguments
    !CHECK:        }
