#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ADDED_CERT_TYPE(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XECT_EXTENSION_V1: ADDED_CERT_TYPE = ADDED_CERT_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XECT_EXTENSION_V2: ADDED_CERT_TYPE = ADDED_CERT_TYPE(2u32);
impl ::core::marker::Copy for ADDED_CERT_TYPE {}
impl ::core::clone::Clone for ADDED_CERT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ADDED_CERT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ADDED_CERT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for ADDED_CERT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ADDED_CERT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AlgorithmFlags(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const AlgorithmFlagsNone: AlgorithmFlags = AlgorithmFlags(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const AlgorithmFlagsWrap: AlgorithmFlags = AlgorithmFlags(1i32);
impl ::core::marker::Copy for AlgorithmFlags {}
impl ::core::clone::Clone for AlgorithmFlags {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AlgorithmFlags {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AlgorithmFlags {
    type Abi = Self;
}
impl ::core::fmt::Debug for AlgorithmFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AlgorithmFlags").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AlgorithmOperationFlags(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_NO_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_CIPHER_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_HASH_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_SECRET_AGREEMENT_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_SIGNATURE_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(16i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_RNG_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(32i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_KEY_DERIVATION_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(64i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_ANY_ASYMMETRIC_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(28i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_PREFER_SIGNATURE_ONLY_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(2097152i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_PREFER_NON_SIGNATURE_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(4194304i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_EXACT_MATCH_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(8388608i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_NCRYPT_PREFERENCE_MASK_OPERATION: AlgorithmOperationFlags = AlgorithmOperationFlags(14680064i32);
impl ::core::marker::Copy for AlgorithmOperationFlags {}
impl ::core::clone::Clone for AlgorithmOperationFlags {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AlgorithmOperationFlags {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AlgorithmOperationFlags {
    type Abi = Self;
}
impl ::core::fmt::Debug for AlgorithmOperationFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AlgorithmOperationFlags").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AlgorithmType(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_UNKNOWN_INTERFACE: AlgorithmType = AlgorithmType(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_CIPHER_INTERFACE: AlgorithmType = AlgorithmType(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_HASH_INTERFACE: AlgorithmType = AlgorithmType(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE: AlgorithmType = AlgorithmType(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_SIGNATURE_INTERFACE: AlgorithmType = AlgorithmType(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_SECRET_AGREEMENT_INTERFACE: AlgorithmType = AlgorithmType(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_RNG_INTERFACE: AlgorithmType = AlgorithmType(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_BCRYPT_KEY_DERIVATION_INTERFACE: AlgorithmType = AlgorithmType(7i32);
impl ::core::marker::Copy for AlgorithmType {}
impl ::core::clone::Clone for AlgorithmType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AlgorithmType {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AlgorithmType {
    type Abi = Self;
}
impl ::core::fmt::Debug for AlgorithmType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AlgorithmType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AlternativeNameType(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_UNKNOWN: AlternativeNameType = AlternativeNameType(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_OTHER_NAME: AlternativeNameType = AlternativeNameType(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_RFC822_NAME: AlternativeNameType = AlternativeNameType(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_DNS_NAME: AlternativeNameType = AlternativeNameType(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_X400_ADDRESS: AlternativeNameType = AlternativeNameType(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_DIRECTORY_NAME: AlternativeNameType = AlternativeNameType(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_EDI_PARTY_NAME: AlternativeNameType = AlternativeNameType(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_URL: AlternativeNameType = AlternativeNameType(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_IP_ADDRESS: AlternativeNameType = AlternativeNameType(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_REGISTERED_ID: AlternativeNameType = AlternativeNameType(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_GUID: AlternativeNameType = AlternativeNameType(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ALT_NAME_USER_PRINCIPLE_NAME: AlternativeNameType = AlternativeNameType(11i32);
impl ::core::marker::Copy for AlternativeNameType {}
impl ::core::clone::Clone for AlternativeNameType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AlternativeNameType {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AlternativeNameType {
    type Abi = Self;
}
impl ::core::fmt::Debug for AlternativeNameType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AlternativeNameType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAIF_DSENTRY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAIF_LOCAL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAIF_REGISTRY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAIF_REGISTRYPARENT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAIF_SHAREDFOLDERENTRY: u32 = 2u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub struct CAINFO {
    pub cbSize: u32,
    pub CAType: ENUM_CATYPES,
    pub cCASignatureCerts: u32,
    pub cCAExchangeCerts: u32,
    pub cExitModules: u32,
    pub lPropIdMax: i32,
    pub lRoleSeparationEnabled: i32,
    pub cKRACertUsedCount: u32,
    pub cKRACertCount: u32,
    pub fAdvancedServer: u32,
}
impl ::core::marker::Copy for CAINFO {}
impl ::core::clone::Clone for CAINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CAINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CAINFO")
            .field("cbSize", &self.cbSize)
            .field("CAType", &self.CAType)
            .field("cCASignatureCerts", &self.cCASignatureCerts)
            .field("cCAExchangeCerts", &self.cCAExchangeCerts)
            .field("cExitModules", &self.cExitModules)
            .field("lPropIdMax", &self.lPropIdMax)
            .field("lRoleSeparationEnabled", &self.lRoleSeparationEnabled)
            .field("cKRACertUsedCount", &self.cKRACertUsedCount)
            .field("cKRACertCount", &self.cKRACertCount)
            .field("fAdvancedServer", &self.fAdvancedServer)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for CAINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CAINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CAINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CAINFO {}
impl ::core::default::Default for CAINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPATHLENGTH_INFINITE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_MASKROLES: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_CRL_BASE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_CRL_DELTA: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_CRL_REPUBLISH: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_DISP_ERROR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_DISP_INCOMPLETE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_DISP_INVALID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_DISP_REVOKED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_DISP_UNDER_SUBMISSION: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_DISP_VALID: u32 = 3u32;
pub const CAlternativeName: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2013_217d_11da_b2a4_000e7bbb2b09);
pub const CAlternativeNames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2014_217d_11da_b2a4_000e7bbb2b09);
pub const CBinaryConverter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2002_217d_11da_b2a4_000e7bbb2b09);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CCLOCKSKEWMINUTESDEFAULT: u32 = 10u32;
pub const CCertAdmin: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x37eabaf0_7fb6_11d0_8817_00a0c903b83c);
pub const CCertConfig: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x372fce38_4324_11d0_8810_00a0c903b83c);
pub const CCertEncodeAltName: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1cfc4cda_1271_11d1_9bd4_00c04fb683fa);
pub const CCertEncodeBitString: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6d6b3cd8_1278_11d1_9bd4_00c04fb683fa);
pub const CCertEncodeCRLDistInfo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x01fa60a0_bbff_11d0_8825_00a0c903b83c);
pub const CCertEncodeDateArray: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x301f77b0_a470_11d0_8821_00a0c903b83c);
pub const CCertEncodeLongArray: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4e0680a0_a0a2_11d0_8821_00a0c903b83c);
pub const CCertEncodeStringArray: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x19a76fe0_7494_11d0_8816_00a0c903b83c);
pub const CCertGetConfig: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6cc49b0_ce17_11d0_8833_00a0c903b83c);
pub const CCertProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e202f_217d_11da_b2a4_000e7bbb2b09);
pub const CCertProperty: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e202e_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyArchived: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2037_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyArchivedKeyHash: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e203b_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyAutoEnroll: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2032_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyBackedUp: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2038_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyDescription: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2031_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyEnrollment: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2039_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyEnrollmentPolicyServer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e204c_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyFriendlyName: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2030_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyKeyProvInfo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2036_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyRenewal: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e203a_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertyRequestOriginator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2033_217d_11da_b2a4_000e7bbb2b09);
pub const CCertPropertySHA1Hash: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2034_217d_11da_b2a4_000e7bbb2b09);
pub const CCertRequest: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x98aff3f0_5524_11d0_8812_00a0c903b83c);
pub const CCertServerExit: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4c4a5e40_732c_11d0_8816_00a0c903b83c);
pub const CCertServerPolicy: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaa000926_ffbe_11cf_8800_00a0c903b83c);
pub const CCertView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa12d0f7a_1e84_11d1_9bd6_00c04fb683fa);
pub const CCertificateAttestationChallenge: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1362ada1_eb60_456a_b6e1_118050db741b);
pub const CCertificatePolicies: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e201f_217d_11da_b2a4_000e7bbb2b09);
pub const CCertificatePolicy: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e201e_217d_11da_b2a4_000e7bbb2b09);
pub const CCryptAttribute: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e202c_217d_11da_b2a4_000e7bbb2b09);
pub const CCryptAttributes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e202d_217d_11da_b2a4_000e7bbb2b09);
pub const CCspInformation: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2007_217d_11da_b2a4_000e7bbb2b09);
pub const CCspInformations: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2008_217d_11da_b2a4_000e7bbb2b09);
pub const CCspStatus: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2009_217d_11da_b2a4_000e7bbb2b09);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERTADMIN_GET_ROLES_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_ADMIN: CERTADMIN_GET_ROLES_FLAGS = CERTADMIN_GET_ROLES_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_AUDITOR: CERTADMIN_GET_ROLES_FLAGS = CERTADMIN_GET_ROLES_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_ENROLL: CERTADMIN_GET_ROLES_FLAGS = CERTADMIN_GET_ROLES_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_OFFICER: CERTADMIN_GET_ROLES_FLAGS = CERTADMIN_GET_ROLES_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_OPERATOR: CERTADMIN_GET_ROLES_FLAGS = CERTADMIN_GET_ROLES_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CA_ACCESS_READ: CERTADMIN_GET_ROLES_FLAGS = CERTADMIN_GET_ROLES_FLAGS(256u32);
impl ::core::marker::Copy for CERTADMIN_GET_ROLES_FLAGS {}
impl ::core::clone::Clone for CERTADMIN_GET_ROLES_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERTADMIN_GET_ROLES_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERTADMIN_GET_ROLES_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERTADMIN_GET_ROLES_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERTADMIN_GET_ROLES_FLAGS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for CERTADMIN_GET_ROLES_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERTADMIN_GET_ROLES_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERTADMIN_GET_ROLES_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERTADMIN_GET_ROLES_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERTADMIN_GET_ROLES_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERTENROLL_INDEX_BASE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERTENROLL_OBJECTID(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NONE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_ENCRYPT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_3: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_4: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_5: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_6: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_8: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_9: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_10: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(14i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(15i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(16i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MD2RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(17i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MD4RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(18i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MD5RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(19i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SHA1RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(20i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SETOAEP_RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(21i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_DH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(22i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_data: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(23i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_signedData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(24i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_envelopedData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(25i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_signEnvData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(26i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_digestedData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(27i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_hashedData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(28i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_encryptedData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(29i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_emailAddr: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(30i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_unstructName: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(31i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_contentType: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(32i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_messageDigest: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(33i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_signingTime: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(34i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_counterSign: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(35i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_challengePwd: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(36i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_unstructAddr: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(37i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_extCertAttrs: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(38i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_certExtensions: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(39i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SMIMECapabilities: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(40i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_preferSignedData: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(41i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SMIMEalg: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(42i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SMIMEalgESDH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(43i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SMIMEalgCMS3DESwrap: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(44i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SMIMEalgCMSRC2wrap: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(45i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MD2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(46i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MD4: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(47i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MD5: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(48i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_RC2CBC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(49i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_RC4: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(50i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_DES_EDE3_CBC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(51i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_RC5_CBCPad: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(52i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ANSI_X942: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(53i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ANSI_X942_DH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(54i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_X957: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(55i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_X957_DSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(56i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_X957_SHA1DSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(57i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(58i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DSALG: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(59i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DSALG_CRPT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(60i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DSALG_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(61i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DSALG_SIGN: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(62i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DSALG_RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(63i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIW: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(64i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(65i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_md4RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(66i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_md5RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(67i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_md4RSA2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(68i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_desECB: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(69i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_desCBC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(70i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_desOFB: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(71i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_desCFB: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(72i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_desMAC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(73i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_rsaSign: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(74i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_dsa: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(75i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_shaDSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(76i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_mdc2RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(77i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_shaRSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(78i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_dhCommMod: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(79i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_desEDE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(80i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_sha: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(81i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_mdc2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(82i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_dsaComm: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(83i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_dsaCommSHA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(84i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_rsaXchg: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(85i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_keyHashSeal: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(86i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_md2RSASign: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(87i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_md5RSASign: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(88i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_sha1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(89i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_dsaSHA1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(90i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_dsaCommSHA1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(91i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWSEC_sha1RSASign: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(92i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWDIR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(93i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWDIR_CRPT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(94i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWDIR_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(95i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWDIR_SIGN: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(96i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWDIR_md2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(97i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OIWDIR_md2RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(98i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(99i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_sdnsSignature: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(100i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicSignature: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(101i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_sdnsConfidentiality: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(102i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicConfidentiality: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(103i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_sdnsIntegrity: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(104i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicIntegrity: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(105i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_sdnsTokenProtection: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(106i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicTokenProtection: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(107i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_sdnsKeyManagement: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(108i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicKeyManagement: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(109i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_sdnsKMandSig: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(110i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicKMandSig: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(111i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_SuiteASignature: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(112i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_SuiteAConfidentiality: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(113i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_SuiteAIntegrity: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(114i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_SuiteATokenProtection: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(115i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_SuiteAKeyManagement: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(116i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_SuiteAKMandSig: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(117i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicUpdatedSig: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(118i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicKMandUpdSig: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(119i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INFOSEC_mosaicUpdatedInteg: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(120i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_COMMON_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(121i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUR_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(122i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DEVICE_SERIAL_NUMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(123i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_COUNTRY_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(124i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LOCALITY_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(125i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_STATE_OR_PROVINCE_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(126i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_STREET_ADDRESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(127i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ORGANIZATION_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(128i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ORGANIZATIONAL_UNIT_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(129i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_TITLE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(130i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DESCRIPTION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(131i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SEARCH_GUIDE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(132i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_BUSINESS_CATEGORY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(133i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_POSTAL_ADDRESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(134i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_POSTAL_CODE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(135i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_POST_OFFICE_BOX: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(136i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PHYSICAL_DELIVERY_OFFICE_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(137i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_TELEPHONE_NUMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(138i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_TELEX_NUMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(139i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_TELETEXT_TERMINAL_IDENTIFIER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(140i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_FACSIMILE_TELEPHONE_NUMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(141i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_X21_ADDRESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(142i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INTERNATIONAL_ISDN_NUMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(143i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_REGISTERED_ADDRESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(144i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DESTINATION_INDICATOR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(145i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PREFERRED_DELIVERY_METHOD: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(146i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PRESENTATION_ADDRESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(147i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUPPORTED_APPLICATION_CONTEXT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(148i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_MEMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(149i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OWNER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(150i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ROLE_OCCUPANT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(151i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SEE_ALSO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(152i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_USER_PASSWORD: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(153i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_USER_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(154i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CA_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(155i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_AUTHORITY_REVOCATION_LIST: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(156i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERTIFICATE_REVOCATION_LIST: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(157i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CROSS_CERTIFICATE_PAIR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(158i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_GIVEN_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(159i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INITIALS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(160i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DN_QUALIFIER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(161i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DOMAIN_COMPONENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(162i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_FRIENDLY_NAME_ATTR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(163i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_LOCAL_KEY_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(164i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_KEY_PROVIDER_NAME_ATTR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(165i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LOCAL_MACHINE_KEYSET: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(166i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_EXTENDED_ATTRIBUTES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(167i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KEYID_RDN: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(168i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_AUTHORITY_KEY_IDENTIFIER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(169i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KEY_ATTRIBUTES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(170i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_POLICIES_95: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(171i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KEY_USAGE_RESTRICTION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(172i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUBJECT_ALT_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(173i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ISSUER_ALT_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(174i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_BASIC_CONSTRAINTS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(175i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KEY_USAGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(176i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PRIVATEKEY_USAGE_PERIOD: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(177i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_BASIC_CONSTRAINTS2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(178i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_POLICIES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(179i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ANY_CERT_POLICY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(180i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_AUTHORITY_KEY_IDENTIFIER2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(181i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUBJECT_KEY_IDENTIFIER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(182i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUBJECT_ALT_NAME2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(183i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ISSUER_ALT_NAME2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(184i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CRL_REASON_CODE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(185i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_REASON_CODE_HOLD: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(186i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CRL_DIST_POINTS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(187i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENHANCED_KEY_USAGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(188i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CRL_NUMBER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(189i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DELTA_CRL_INDICATOR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(190i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ISSUING_DIST_POINT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(191i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_FRESHEST_CRL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(192i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NAME_CONSTRAINTS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(193i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_POLICY_MAPPINGS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(194i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LEGACY_POLICY_MAPPINGS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(195i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_POLICY_CONSTRAINTS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(196i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RENEWAL_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(197i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLLMENT_NAME_VALUE_PAIR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(198i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLLMENT_CSP_PROVIDER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(199i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OS_VERSION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(200i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLLMENT_AGENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(201i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(202i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_PE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(203i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_AUTHORITY_INFO_ACCESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(204i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_BIOMETRIC_EXT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(205i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LOGOTYPE_EXT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(206i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_EXTENSIONS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(207i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NEXT_UPDATE_LOCATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(208i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_REMOVE_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(209i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CROSS_CERT_DIST_POINTS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(210i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CTL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(211i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SORTED_CTL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(212i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SERIALIZED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(213i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NT_PRINCIPAL_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(214i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PRODUCT_UPDATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(215i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ANY_APPLICATION_POLICY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(216i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_AUTO_ENROLL_CTL_USAGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(217i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_CERTTYPE_EXTENSION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(218i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_MANIFOLD: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(219i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERTSRV_CA_VERSION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(220i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERTSRV_PREVIOUS_CERT_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(221i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CRL_VIRTUAL_BASE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(222i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CRL_NEXT_PUBLISH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(223i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_CA_EXCHANGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(224i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_KEY_RECOVERY_AGENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(225i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERTIFICATE_TEMPLATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(226i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENTERPRISE_OID_ROOT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(227i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RDN_DUMMY_SIGNER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(228i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_APPLICATION_CERT_POLICIES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(229i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_APPLICATION_POLICY_MAPPINGS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(230i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_APPLICATION_POLICY_CONSTRAINTS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(231i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ARCHIVED_KEY_ATTR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(232i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CRL_SELF_CDP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(233i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_REQUIRE_CERT_CHAIN_POLICY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(234i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ARCHIVED_KEY_CERT_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(235i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ISSUED_CERT_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(236i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DS_EMAIL_REPLICATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(237i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_REQUEST_CLIENT_INFO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(238i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENCRYPTED_KEY_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(239i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERTSRV_CROSSCA_VERSION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(240i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NTDS_REPLICATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(241i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUBJECT_DIR_ATTRS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(242i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(243i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_SERVER_AUTH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(244i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_CLIENT_AUTH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(245i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_CODE_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(246i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_EMAIL_PROTECTION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(247i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_IPSEC_END_SYSTEM: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(248i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_IPSEC_TUNNEL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(249i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_IPSEC_USER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(250i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_TIMESTAMP_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(251i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_KP_OCSP_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(252i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_OCSP_NOCHECK: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(253i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_IPSEC_KP_IKE_INTERMEDIATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(254i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_CTL_USAGE_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(255i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_TIME_STAMP_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(256i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SERVER_GATED_CRYPTO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(257i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SGC_NETSCAPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(258i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_EFS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(259i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_EFS_RECOVERY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(260i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_WHQL_CRYPTO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(261i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NT5_CRYPTO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(262i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_OEM_WHQL_CRYPTO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(263i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_EMBEDDED_NT_CRYPTO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(264i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ROOT_LIST_SIGNER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(265i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_QUALIFIED_SUBORDINATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(266i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_KEY_RECOVERY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(267i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_DOCUMENT_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(268i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_LIFETIME_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(269i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_MOBILE_DEVICE_SOFTWARE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(270i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_SMART_DISPLAY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(271i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_CSP_SIGNATURE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(272i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DRM: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(273i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DRM_INDIVIDUALIZATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(274i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LICENSES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(275i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LICENSE_SERVER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(276i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_SMARTCARD_LOGON: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(277i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_YESNO_TRUST_ATTR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(278i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_POLICY_QUALIFIER_CPS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(279i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_POLICY_QUALIFIER_USERNOTICE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(280i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_POLICIES_95_QUALIFIER1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(281i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_ACC_DESCR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(282i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_OCSP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(283i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_CA_ISSUERS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(284i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_VERISIGN_PRIVATE_6_9: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(285i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_VERISIGN_ONSITE_JURISDICTION_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(286i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_VERISIGN_BITSTRING_6_13: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(287i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_VERISIGN_ISS_STRONG_CRYPTO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(288i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(289i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_CERT_EXTENSION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(290i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_CERT_TYPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(291i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_BASE_URL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(292i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_REVOCATION_URL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(293i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_CA_REVOCATION_URL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(294i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_CERT_RENEWAL_URL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(295i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_CA_POLICY_URL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(296i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_SSL_SERVER_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(297i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_COMMENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(298i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_DATA_TYPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(299i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NETSCAPE_CERT_SEQUENCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(300i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CT_PKI_DATA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(301i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CT_PKI_RESPONSE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(302i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_NO_SIGNATURE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(303i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(304i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_STATUS_INFO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(305i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_IDENTIFICATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(306i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_IDENTITY_PROOF: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(307i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_DATA_RETURN: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(308i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_TRANSACTION_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(309i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_SENDER_NONCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(310i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_RECIPIENT_NONCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(311i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_ADD_EXTENSIONS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(312i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_ENCRYPTED_POP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(313i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_DECRYPTED_POP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(314i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_LRA_POP_WITNESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(315i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_GET_CERT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(316i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_GET_CRL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(317i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_REVOKE_REQUEST: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(318i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_REG_INFO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(319i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_RESPONSE_INFO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(320i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_QUERY_PENDING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(321i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_ID_POP_LINK_RANDOM: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(322i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_ID_POP_LINK_WITNESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(323i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_ID_CONFIRM_CERT_ACCEPTANCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(324i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CMC_ADD_ATTRIBUTES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(325i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_LOYALTY_OTHER_LOGOTYPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(326i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_BACKGROUND_OTHER_LOGOTYPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(327i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_OCSP_BASIC_SIGNED_RESPONSE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(328i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7_DATA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(329i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7_SIGNED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(330i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7_ENVELOPED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(331i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7_SIGNEDANDENVELOPED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(332i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7_DIGESTED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(333i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_7_ENCRYPTED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(334i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_9_CONTENT_TYPE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(335i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_9_MESSAGE_DIGEST: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(336i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_PROP_ID_PREFIX: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(337i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_KEY_IDENTIFIER_PROP_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(338i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(339i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(340i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_MD5_HASH_PROP_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(341i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SHA256RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(342i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SHA384RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(343i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SHA512RSA: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(344i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_sha256: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(345i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_sha384: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(346i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_sha512: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(347i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_MGF1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(348i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECC_PUBLIC_KEY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(349i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECDSA_SHA1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(350i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECDSA_SPECIFIED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(351i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ANY_ENHANCED_KEY_USAGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(352i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_SSA_PSS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(353i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ATTR_SUPPORTED_ALGORITHMS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(355i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ATTR_TPM_SECURITY_ASSERTIONS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(356i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ATTR_TPM_SPECIFICATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(357i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_DISALLOWED_FILETIME_PROP_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(358i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_SIGNATURE_HASH_PROP_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(359i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_STRONG_KEY_OS_1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(360i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_STRONG_KEY_OS_CURRENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(361i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_STRONG_KEY_OS_PREFIX: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(362i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_STRONG_SIGN_OS_1: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(363i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_STRONG_SIGN_OS_CURRENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(364i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_CERT_STRONG_SIGN_OS_PREFIX: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(365i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DH_SINGLE_PASS_STDDH_SHA1_KDF: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(366i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DH_SINGLE_PASS_STDDH_SHA256_KDF: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(367i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DH_SINGLE_PASS_STDDH_SHA384_KDF: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(368i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DISALLOWED_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(369i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_DISALLOWED_LIST: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(370i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECC_CURVE_P256: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(371i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECC_CURVE_P384: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(372i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECC_CURVE_P521: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(373i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECDSA_SHA256: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(374i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECDSA_SHA384: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(375i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ECDSA_SHA512: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(376i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_CAXCHGCERT_HASH: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(377i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_EK_INFO: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(378i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_EKPUB_CHALLENGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(379i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_EKVERIFYCERT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(380i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_EKVERIFYCREDS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(381i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_EKVERIFYKEY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(382i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_EV_RDN_COUNTRY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(383i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_EV_RDN_LOCALE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(384i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_EV_RDN_STATE_OR_PROVINCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(385i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INHIBIT_ANY_POLICY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(386i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_INTERNATIONALIZED_EMAIL_ADDRESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(387i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_KERNEL_MODE_CODE_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(388i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_KERNEL_MODE_HAL_EXTENSION_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(389i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_KERNEL_MODE_TRUSTED_BOOT_SIGNING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(390i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_TPM_AIK_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(391i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_TPM_EK_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(392i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_KP_TPM_PLATFORM_CERTIFICATE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(393i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_AES128_CBC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(394i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_AES128_WRAP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(395i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_AES192_CBC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(396i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_AES192_WRAP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(397i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_AES256_CBC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(398i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_NIST_AES256_WRAP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(399i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_PbeIds: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(400i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_pbeWithSHA1And128BitRC2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(401i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_pbeWithSHA1And128BitRC4: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(402i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_pbeWithSHA1And2KeyTripleDES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(403i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_pbeWithSHA1And3KeyTripleDES: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(404i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_pbeWithSHA1And40BitRC2: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(405i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_pbeWithSHA1And40BitRC4: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(406i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKCS_12_PROTECTED_PASSWORD_SECRET_BAG_TYPE_ID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(407i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKINIT_KP_KDC: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(408i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_CA_REPOSITORY: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(409i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_OCSP_NONCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(410i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_PKIX_TIME_STAMPING: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(411i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_QC_EU_COMPLIANCE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(412i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_QC_SSCD: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(413i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_QC_STATEMENTS_EXT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(414i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RDN_TPM_MANUFACTURER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(415i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RDN_TPM_MODEL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(416i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RDN_TPM_VERSION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(417i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_REVOKED_LIST_SIGNER: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(418i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RFC3161_counterSign: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(419i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(420i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(421i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ROOT_PROGRAM_FLAGS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(422i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ROOT_PROGRAM_NO_OCSP_FAILOVER_TO_CRL: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(423i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSA_PSPECIFIED: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(424i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_RSAES_OAEP: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(425i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_SUBJECT_INFO_ACCESS: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(426i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_TIMESTAMP_TOKEN: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(427i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_SCEP_ERROR: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(428i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OIDVerisign_MessageType: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(429i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OIDVerisign_PkiStatus: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(430i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OIDVerisign_FailInfo: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(431i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OIDVerisign_SenderNonce: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(432i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OIDVerisign_RecipientNonce: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(433i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OIDVerisign_TransactionID: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(434i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_ATTESTATION_CHALLENGE: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(435i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_ATTESTATION_STATEMENT: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(436i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_ENCRYPTION_ALGORITHM: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(437i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_OID_ENROLL_KSP_NAME: CERTENROLL_OBJECTID = CERTENROLL_OBJECTID(438i32);
impl ::core::marker::Copy for CERTENROLL_OBJECTID {}
impl ::core::clone::Clone for CERTENROLL_OBJECTID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERTENROLL_OBJECTID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERTENROLL_OBJECTID {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERTENROLL_OBJECTID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERTENROLL_OBJECTID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERTENROLL_PROPERTYID(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_PROPERTYID_NONE: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_PROV_HANDLE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_PROV_INFO_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SHA1_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_MD5_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_CONTEXT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_SPEC_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_IE30_RESERVED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_PUBKEY_HASH_RESERVED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ENHKEY_USAGE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CTL_USAGE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NEXT_UPDATE_LOCATION_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_FRIENDLY_NAME_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_PVK_FILE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_DESCRIPTION_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ACCESS_STATE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(14i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SIGNATURE_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(15i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SMART_CARD_DATA_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(16i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_EFS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(17i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_FORTEZZA_DATA_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(18i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ARCHIVED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(19i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_IDENTIFIER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(20i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_AUTO_ENROLL_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(21i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_PUBKEY_ALG_PARA_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(22i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CROSS_CERT_DIST_POINTS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(23i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(24i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(25i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ENROLLMENT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(26i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_DATE_STAMP_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(27i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(28i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(29i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_EXTENDED_ERROR_INFO_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(30i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_RENEWAL_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(64i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ARCHIVED_KEY_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(65i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_AUTO_ENROLL_RETRY_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(66i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_AIA_URL_RETRIEVED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(67i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_AUTHORITY_INFO_ACCESS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(68i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_BACKED_UP_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(69i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_OCSP_RESPONSE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(70i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_REQUEST_ORIGINATOR_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(71i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SOURCE_LOCATION_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(72i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SOURCE_URL_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(73i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NEW_KEY_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(74i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_OCSP_CACHE_PREFIX_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(75i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SMART_CARD_ROOT_INFO_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(76i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NO_AUTO_EXPIRE_CHECK_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(77i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NCRYPT_KEY_HANDLE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(78i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_HCRYPTPROV_OR_NCRYPT_KEY_HANDLE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(79i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SUBJECT_INFO_ACCESS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(80i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CA_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(81i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CA_DISABLE_CRL_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(82i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(83i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ROOT_PROGRAM_NAME_CONSTRAINTS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(84i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SUBJECT_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(85i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SUBJECT_DISABLE_CRL_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(86i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CEP_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(87i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SIGN_HASH_CNG_ALG_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(89i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCARD_PIN_ID_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(90i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCARD_PIN_INFO_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(91i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SUBJECT_PUB_KEY_BIT_LENGTH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(92i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(93i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ISSUER_PUB_KEY_BIT_LENGTH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(94i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ISSUER_CHAIN_SIGN_HASH_CNG_ALG_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(95i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ISSUER_CHAIN_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(96i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NO_EXPIRE_NOTIFICATION_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(97i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_AUTH_ROOT_SHA256_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(98i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NCRYPT_KEY_HANDLE_TRANSFER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(99i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_HCRYPTPROV_TRANSFER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(100i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SMART_CARD_READER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(101i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SEND_AS_TRUSTED_ISSUER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(102i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_REPAIR_ATTEMPTED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(103i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_DISALLOWED_FILETIME_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(104i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ROOT_PROGRAM_CHAIN_POLICIES_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(105i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SMART_CARD_READER_NON_REMOVABLE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(106i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SHA256_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(107i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_SERVER_CERTS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(108i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_RA_SIGNATURE_CERT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(109i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_RA_ENCRYPTION_CERT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(110i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_CA_CERT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(111i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_SIGNER_CERT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(112i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_NONCE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(113i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_ENCRYPT_HASH_CNG_ALG_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(114i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_FLAGS_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(115i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SCEP_GUID_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(116i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SERIALIZABLE_KEY_CONTEXT_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(117i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_ISOLATED_KEY_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(118i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_SERIAL_CHAIN_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(119i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_KEY_CLASSIFICATION_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(120i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_DISALLOWED_ENHKEY_USAGE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(122i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NONCOMPLIANT_ROOT_URL_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(123i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_PIN_SHA256_HASH_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(124i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CLR_DELETE_KEY_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(125i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_NOT_BEFORE_FILETIME_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(126i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_CERT_NOT_BEFORE_ENHKEY_USAGE_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(127i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_FIRST_RESERVED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(128i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_LAST_RESERVED_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(32767i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_FIRST_USER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(32768i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_LAST_USER_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(65535i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CERT_STORE_LOCALIZED_NAME_PROP_ID: CERTENROLL_PROPERTYID = CERTENROLL_PROPERTYID(4096i32);
impl ::core::marker::Copy for CERTENROLL_PROPERTYID {}
impl ::core::clone::Clone for CERTENROLL_PROPERTYID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERTENROLL_PROPERTYID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERTENROLL_PROPERTYID {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERTENROLL_PROPERTYID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERTENROLL_PROPERTYID").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub struct CERTTRANSBLOB {
    pub cb: u32,
    pub pb: *mut u8,
}
impl ::core::marker::Copy for CERTTRANSBLOB {}
impl ::core::clone::Clone for CERTTRANSBLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CERTTRANSBLOB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CERTTRANSBLOB").field("cb", &self.cb).field("pb", &self.pb).finish()
    }
}
unsafe impl ::windows::core::Abi for CERTTRANSBLOB {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CERTTRANSBLOB {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CERTTRANSBLOB>()) == 0 }
    }
}
impl ::core::cmp::Eq for CERTTRANSBLOB {}
impl ::core::default::Default for CERTTRANSBLOB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub struct CERTVIEWRESTRICTION {
    pub ColumnIndex: u32,
    pub SeekOperator: i32,
    pub SortOrder: i32,
    pub pbValue: *mut u8,
    pub cbValue: u32,
}
impl ::core::marker::Copy for CERTVIEWRESTRICTION {}
impl ::core::clone::Clone for CERTVIEWRESTRICTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CERTVIEWRESTRICTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CERTVIEWRESTRICTION").field("ColumnIndex", &self.ColumnIndex).field("SeekOperator", &self.SeekOperator).field("SortOrder", &self.SortOrder).field("pbValue", &self.pbValue).field("cbValue", &self.cbValue).finish()
    }
}
unsafe impl ::windows::core::Abi for CERTVIEWRESTRICTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CERTVIEWRESTRICTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CERTVIEWRESTRICTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for CERTVIEWRESTRICTION {}
impl ::core::default::Default for CERTVIEWRESTRICTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_ALT_NAME(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_RFC822_NAME: CERT_ALT_NAME = CERT_ALT_NAME(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_DNS_NAME: CERT_ALT_NAME = CERT_ALT_NAME(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_URL: CERT_ALT_NAME = CERT_ALT_NAME(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_REGISTERED_ID: CERT_ALT_NAME = CERT_ALT_NAME(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_DIRECTORY_NAME: CERT_ALT_NAME = CERT_ALT_NAME(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_IP_ADDRESS: CERT_ALT_NAME = CERT_ALT_NAME(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CERT_ALT_NAME_OTHER_NAME: CERT_ALT_NAME = CERT_ALT_NAME(1u32);
impl ::core::marker::Copy for CERT_ALT_NAME {}
impl ::core::clone::Clone for CERT_ALT_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_ALT_NAME {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_ALT_NAME {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_ALT_NAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_ALT_NAME").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_CREATE_REQUEST_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XECR_CMC: CERT_CREATE_REQUEST_FLAGS = CERT_CREATE_REQUEST_FLAGS(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XECR_PKCS10_V1_5: CERT_CREATE_REQUEST_FLAGS = CERT_CREATE_REQUEST_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XECR_PKCS10_V2_0: CERT_CREATE_REQUEST_FLAGS = CERT_CREATE_REQUEST_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XECR_PKCS7: CERT_CREATE_REQUEST_FLAGS = CERT_CREATE_REQUEST_FLAGS(2u32);
impl ::core::marker::Copy for CERT_CREATE_REQUEST_FLAGS {}
impl ::core::clone::Clone for CERT_CREATE_REQUEST_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_CREATE_REQUEST_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_CREATE_REQUEST_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_CREATE_REQUEST_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_CREATE_REQUEST_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_DELETE_ROW_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CDR_EXPIRED: CERT_DELETE_ROW_FLAGS = CERT_DELETE_ROW_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CDR_REQUEST_LAST_CHANGED: CERT_DELETE_ROW_FLAGS = CERT_DELETE_ROW_FLAGS(2u32);
impl ::core::marker::Copy for CERT_DELETE_ROW_FLAGS {}
impl ::core::clone::Clone for CERT_DELETE_ROW_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_DELETE_ROW_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_DELETE_ROW_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_DELETE_ROW_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_DELETE_ROW_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_EXIT_EVENT_MASK(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CERTDENIED: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CERTISSUED: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CERTPENDING: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CERTRETRIEVEPENDING: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CERTREVOKED: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CRLISSUED: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_SHUTDOWN: CERT_EXIT_EVENT_MASK = CERT_EXIT_EVENT_MASK(64u32);
impl ::core::marker::Copy for CERT_EXIT_EVENT_MASK {}
impl ::core::clone::Clone for CERT_EXIT_EVENT_MASK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_EXIT_EVENT_MASK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_EXIT_EVENT_MASK {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_EXIT_EVENT_MASK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_EXIT_EVENT_MASK").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for CERT_EXIT_EVENT_MASK {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_EXIT_EVENT_MASK {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_EXIT_EVENT_MASK {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_EXIT_EVENT_MASK {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_EXIT_EVENT_MASK {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_GET_CONFIG_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CC_DEFAULTCONFIG: CERT_GET_CONFIG_FLAGS = CERT_GET_CONFIG_FLAGS(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CC_FIRSTCONFIG: CERT_GET_CONFIG_FLAGS = CERT_GET_CONFIG_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CC_LOCALACTIVECONFIG: CERT_GET_CONFIG_FLAGS = CERT_GET_CONFIG_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CC_LOCALCONFIG: CERT_GET_CONFIG_FLAGS = CERT_GET_CONFIG_FLAGS(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CC_UIPICKCONFIG: CERT_GET_CONFIG_FLAGS = CERT_GET_CONFIG_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CC_UIPICKCONFIGSKIPLOCALCA: CERT_GET_CONFIG_FLAGS = CERT_GET_CONFIG_FLAGS(5u32);
impl ::core::marker::Copy for CERT_GET_CONFIG_FLAGS {}
impl ::core::clone::Clone for CERT_GET_CONFIG_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_GET_CONFIG_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_GET_CONFIG_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_GET_CONFIG_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_GET_CONFIG_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_IMPORT_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_BASE64HEADER: CERT_IMPORT_FLAGS = CERT_IMPORT_FLAGS(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_BASE64: CERT_IMPORT_FLAGS = CERT_IMPORT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_BINARY: CERT_IMPORT_FLAGS = CERT_IMPORT_FLAGS(2u32);
impl ::core::marker::Copy for CERT_IMPORT_FLAGS {}
impl ::core::clone::Clone for CERT_IMPORT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_IMPORT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_IMPORT_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_IMPORT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_IMPORT_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_PROPERTY_TYPE(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const PROPTYPE_BINARY: CERT_PROPERTY_TYPE = CERT_PROPERTY_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const PROPTYPE_DATE: CERT_PROPERTY_TYPE = CERT_PROPERTY_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const PROPTYPE_LONG: CERT_PROPERTY_TYPE = CERT_PROPERTY_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const PROPTYPE_STRING: CERT_PROPERTY_TYPE = CERT_PROPERTY_TYPE(4u32);
impl ::core::marker::Copy for CERT_PROPERTY_TYPE {}
impl ::core::clone::Clone for CERT_PROPERTY_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_PROPERTY_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_PROPERTY_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_PROPERTY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_PROPERTY_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_REQUEST_OUT_TYPE(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_BASE64HEADER: CERT_REQUEST_OUT_TYPE = CERT_REQUEST_OUT_TYPE(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_BASE64: CERT_REQUEST_OUT_TYPE = CERT_REQUEST_OUT_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_BINARY: CERT_REQUEST_OUT_TYPE = CERT_REQUEST_OUT_TYPE(2u32);
impl ::core::marker::Copy for CERT_REQUEST_OUT_TYPE {}
impl ::core::clone::Clone for CERT_REQUEST_OUT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_REQUEST_OUT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_REQUEST_OUT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_REQUEST_OUT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_REQUEST_OUT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_VIEW_COLUMN_INDEX(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_LOG_DEFAULT: CERT_VIEW_COLUMN_INDEX = CERT_VIEW_COLUMN_INDEX(-2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_LOG_FAILED_DEFAULT: CERT_VIEW_COLUMN_INDEX = CERT_VIEW_COLUMN_INDEX(-3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_QUEUE_DEFAULT: CERT_VIEW_COLUMN_INDEX = CERT_VIEW_COLUMN_INDEX(-1i32);
impl ::core::marker::Copy for CERT_VIEW_COLUMN_INDEX {}
impl ::core::clone::Clone for CERT_VIEW_COLUMN_INDEX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_VIEW_COLUMN_INDEX {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_VIEW_COLUMN_INDEX {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_VIEW_COLUMN_INDEX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_VIEW_COLUMN_INDEX").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_VIEW_SEEK_OPERATOR_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_EQ: CERT_VIEW_SEEK_OPERATOR_FLAGS = CERT_VIEW_SEEK_OPERATOR_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_LE: CERT_VIEW_SEEK_OPERATOR_FLAGS = CERT_VIEW_SEEK_OPERATOR_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_LT: CERT_VIEW_SEEK_OPERATOR_FLAGS = CERT_VIEW_SEEK_OPERATOR_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_GE: CERT_VIEW_SEEK_OPERATOR_FLAGS = CERT_VIEW_SEEK_OPERATOR_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_GT: CERT_VIEW_SEEK_OPERATOR_FLAGS = CERT_VIEW_SEEK_OPERATOR_FLAGS(16u32);
impl ::core::marker::Copy for CERT_VIEW_SEEK_OPERATOR_FLAGS {}
impl ::core::clone::Clone for CERT_VIEW_SEEK_OPERATOR_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_VIEW_SEEK_OPERATOR_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CERT_VIEW_SEEK_OPERATOR_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CERT_VIEW_SEEK_OPERATOR_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_VIEW_SEEK_OPERATOR_FLAGS").field(&self.0).finish()
    }
}
pub const CEnroll: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x43f8f289_7a20_11d0_8f06_00c04fc295e1);
pub const CEnroll2: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x127698e4_e730_4e5c_a2b1_21490a70c8a1);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CMM_READONLY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CMM_REFRESHONLY: u32 = 1u32;
pub const CObjectId: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2000_217d_11da_b2a4_000e7bbb2b09);
pub const CObjectIds: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2001_217d_11da_b2a4_000e7bbb2b09);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_BADURL_ERROR: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_BASE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_CASTORE_ERROR: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_COMPLETE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_DELTA: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_FILE_ERROR: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_FTP_ERROR: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_HTTP_ERROR: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_LDAP_ERROR: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_MANUAL: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_POSTPONED_BASE_FILE_ERROR: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_POSTPONED_BASE_LDAP_ERROR: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_SHADOW: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CPF_SIGNATURE_ERROR: u32 = 128u32;
pub const CPolicyQualifier: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e201c_217d_11da_b2a4_000e7bbb2b09);
pub const CPolicyQualifiers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e201d_217d_11da_b2a4_000e7bbb2b09);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_ALLOW_REQUEST_ATTRIBUTE_SUBJECT: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_BUILD_ROOTCA_CRLENTRIES_BASEDONKEY: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_CRLNUMBER_CRITICAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_DELETE_EXPIRED_CRLS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_DELTA_USE_OLDEST_UNEXPIRED_BASE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_DISABLE_CHAIN_VERIFICATION: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_DISABLE_RDN_REORDER: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_DISABLE_ROOT_CROSS_CERTS: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_ENFORCE_ENROLLMENT_AGENT: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_IGNORE_CROSS_CERT_TRUST_ERROR: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_IGNORE_INVALID_POLICIES: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_IGNORE_UNKNOWN_CMC_ATTRIBUTES: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_LOG_FULL_RESPONSE: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_PRESERVE_EXPIRED_CA_CERTS: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_PRESERVE_REVOKED_CA_CERTS: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_PUBLISH_EXPIRED_CERT_CRLS: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_REBUILD_MODIFIED_SUBJECT_ONLY: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_REVCHECK_IGNORE_NOREVCHECK: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_REVCHECK_IGNORE_OFFLINE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_SAVE_FAILED_CERTS: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_USE_CROSS_CERT_TEMPLATE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRLF_USE_XCHG_CERT_TEMPLATE: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRLRevocationReason(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_UNSPECIFIED: CRLRevocationReason = CRLRevocationReason(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_KEY_COMPROMISE: CRLRevocationReason = CRLRevocationReason(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_CA_COMPROMISE: CRLRevocationReason = CRLRevocationReason(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_AFFILIATION_CHANGED: CRLRevocationReason = CRLRevocationReason(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_SUPERSEDED: CRLRevocationReason = CRLRevocationReason(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_CESSATION_OF_OPERATION: CRLRevocationReason = CRLRevocationReason(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_CERTIFICATE_HOLD: CRLRevocationReason = CRLRevocationReason(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_REMOVE_FROM_CRL: CRLRevocationReason = CRLRevocationReason(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_PRIVILEGE_WITHDRAWN: CRLRevocationReason = CRLRevocationReason(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRL_REASON_AA_COMPROMISE: CRLRevocationReason = CRLRevocationReason(10i32);
impl ::core::marker::Copy for CRLRevocationReason {}
impl ::core::clone::Clone for CRLRevocationReason {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRLRevocationReason {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CRLRevocationReason {
    type Abi = Self;
}
impl ::core::fmt::Debug for CRLRevocationReason {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRLRevocationReason").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CRYPT_ENUM_ALL_PROVIDERS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CR_DISP(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_DENIED: CR_DISP = CR_DISP(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_ERROR: CR_DISP = CR_DISP(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_INCOMPLETE: CR_DISP = CR_DISP(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_ISSUED: CR_DISP = CR_DISP(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_ISSUED_OUT_OF_BAND: CR_DISP = CR_DISP(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_UNDER_SUBMISSION: CR_DISP = CR_DISP(5u32);
impl ::core::marker::Copy for CR_DISP {}
impl ::core::clone::Clone for CR_DISP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CR_DISP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CR_DISP {
    type Abi = Self;
}
impl ::core::fmt::Debug for CR_DISP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CR_DISP").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_DISP_REVOKED: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_CACROSSCERT: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_CAXCHGCERT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_CHALLENGEPENDING: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_CHALLENGESATISFIED: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_DEFINEDCACERT: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_ENFORCEUTF8: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_ENROLLONBEHALFOF: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_FORCETELETEX: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_FORCEUTF8: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_PUBLISHERROR: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_RENEWAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_SUBJECTUNMODIFIED: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_TRUSTEKCERT: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_TRUSTEKKEY: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_TRUSTONUSE: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_FLG_VALIDENCRYPTEDKEYHASH: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_GEMT_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_GEMT_HRESULT_STRING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_GEMT_HTTP_ERROR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_CERTIFICATETRANSPARENCY: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_CHALLENGERESPONSE: u32 = 1280u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_CLIENTIDNONE: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_CMC: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_CONNECTONLY: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_CRLS: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_ENCODEANY: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_ENCODEMASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_FORMATANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_FORMATMASK: u32 = 65280u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_FULLRESPONSE: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_HTTP: u32 = 196608u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_KEYGEN: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_MACHINE: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_PKCS10: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_PKCS7: u32 = 768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_RETURNCHALLENGE: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_ROBO: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_RPC: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_SCEP: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_SCEPPOST: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_IN_SIGNEDCERTIFICATETIMESTAMPLIST: u32 = 1536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_BASE64REQUESTHEADER: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_BASE64X509CRLHEADER: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_CHAIN: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_CRLS: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_ENCODEMASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_HEX: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_HEXADDR: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_HEXASCII: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_HEXASCIIADDR: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_HEXRAW: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_NOCR: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_OUT_NOCRLF: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_ADVANCEDSERVER: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_BASECRL: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_BASECRLPUBLISHSTATUS: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CABACKWARDCROSSCERT: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CABACKWARDCROSSCERTSTATE: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CACERTSTATE: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CACERTSTATUSCODE: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CACERTVERSION: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAFORWARDCROSSCERT: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAFORWARDCROSSCERTSTATE: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CANAME: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAPROPIDMAX: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CASIGCERT: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CASIGCERTCHAIN: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CASIGCERTCOUNT: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CASIGCERTCRLCHAIN: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CATYPE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAXCHGCERT: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAXCHGCERTCHAIN: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAXCHGCERTCOUNT: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CAXCHGCERTCRLCHAIN: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CERTAIAOCSPURLS: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CERTAIAURLS: u32 = 42u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CERTCDPURLS: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_CRLSTATE: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_DELTACRL: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_DELTACRLPUBLISHSTATUS: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_DNSNAME: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_EXITCOUNT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_EXITDESCRIPTION: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_FILEVERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_KRACERT: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_KRACERTCOUNT: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_KRACERTSTATE: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_KRACERTUSEDCOUNT: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_LOCALENAME: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_PARENTCA: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_POLICYDESCRIPTION: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_PRODUCTVERSION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_ROLESEPARATIONENABLED: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SANITIZEDCANAME: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SANITIZEDCASHORTNAME: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SCEPMAX: u32 = 1002u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SCEPMIN: u32 = 1000u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SCEPSERVERCAPABILITIES: u32 = 1001u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SCEPSERVERCERTS: u32 = 1000u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SCEPSERVERCERTSCHAIN: u32 = 1002u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SHAREDFOLDER: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_SUBJECTTEMPLATE_OIDS: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CR_PROP_TEMPLATES: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBACKUP_DISABLE_INCREMENTAL: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CSBACKUP_TYPE(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBACKUP_TYPE_FULL: CSBACKUP_TYPE = CSBACKUP_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBACKUP_TYPE_LOGS_ONLY: CSBACKUP_TYPE = CSBACKUP_TYPE(2u32);
impl ::core::marker::Copy for CSBACKUP_TYPE {}
impl ::core::clone::Clone for CSBACKUP_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CSBACKUP_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CSBACKUP_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CSBACKUP_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CSBACKUP_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBACKUP_TYPE_MASK: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBFT_DATABASE_DIRECTORY: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBFT_DIRECTORY: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSBFT_LOG_DIRECTORY: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSCONTROL_RESTART: u64 = 3u64;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSCONTROL_SHUTDOWN: u64 = 1u64;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSCONTROL_SUSPEND: u64 = 2u64;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub struct CSEDB_RSTMAPW {
    pub pwszDatabaseName: ::windows::core::PWSTR,
    pub pwszNewDatabaseName: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for CSEDB_RSTMAPW {}
impl ::core::clone::Clone for CSEDB_RSTMAPW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CSEDB_RSTMAPW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CSEDB_RSTMAPW").field("pwszDatabaseName", &self.pwszDatabaseName).field("pwszNewDatabaseName", &self.pwszNewDatabaseName).finish()
    }
}
unsafe impl ::windows::core::Abi for CSEDB_RSTMAPW {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CSEDB_RSTMAPW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CSEDB_RSTMAPW>()) == 0 }
    }
}
impl ::core::cmp::Eq for CSEDB_RSTMAPW {}
impl ::core::default::Default for CSEDB_RSTMAPW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSRESTORE_TYPE_CATCHUP: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSRESTORE_TYPE_FULL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSRESTORE_TYPE_MASK: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSRESTORE_TYPE_ONLINE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_ADDTOCERTCDP: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_ADDTOCERTOCSP: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_ADDTOCRLCDP: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_ADDTOFRESHESTCRL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_ADDTOIDP: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_PUBLISHRETRY: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_SERVERPUBLISH: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSURL_SERVERPUBLISHDELTA: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_LONGHORN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_THRESHOLD: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_WHISTLER: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_WIN2K: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_WIN7: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_WIN8: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MAJOR_WINBLUE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_LONGHORN_BETA1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_THRESHOLD: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_WHISTLER_BETA2: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_WHISTLER_BETA3: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_WIN2K: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_WIN7: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_WIN8: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CSVER_MINOR_WINBLUE: u32 = 1u32;
pub const CSignerCertificate: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e203d_217d_11da_b2a4_000e7bbb2b09);
pub const CSmimeCapabilities: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e201a_217d_11da_b2a4_000e7bbb2b09);
pub const CSmimeCapability: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2019_217d_11da_b2a4_000e7bbb2b09);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVIEWAGEMINUTESDEFAULT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CVRC_COLUMN(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_COLUMN_SCHEMA: CVRC_COLUMN = CVRC_COLUMN(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_COLUMN_RESULT: CVRC_COLUMN = CVRC_COLUMN(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_COLUMN_VALUE: CVRC_COLUMN = CVRC_COLUMN(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_COLUMN_MASK: CVRC_COLUMN = CVRC_COLUMN(4095u32);
impl ::core::marker::Copy for CVRC_COLUMN {}
impl ::core::clone::Clone for CVRC_COLUMN {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CVRC_COLUMN {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CVRC_COLUMN {
    type Abi = Self;
}
impl ::core::fmt::Debug for CVRC_COLUMN {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CVRC_COLUMN").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CVRC_TABLE(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_TABLE_ATTRIBUTES: CVRC_TABLE = CVRC_TABLE(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_TABLE_CRL: CVRC_TABLE = CVRC_TABLE(20480u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_TABLE_EXTENSIONS: CVRC_TABLE = CVRC_TABLE(12288u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_TABLE_REQCERT: CVRC_TABLE = CVRC_TABLE(0u32);
impl ::core::marker::Copy for CVRC_TABLE {}
impl ::core::clone::Clone for CVRC_TABLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CVRC_TABLE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CVRC_TABLE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CVRC_TABLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CVRC_TABLE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_TABLE_MASK: u32 = 61440u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVRC_TABLE_SHIFT: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_MASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_NODELTA: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SEEK_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SORT_ASCEND: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SORT_DESCEND: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CVR_SORT_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_ATTRIBUTE_DEFAULT: i32 = -5i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_CRL_DEFAULT: i32 = -6i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_EXTENSION_DEFAULT: i32 = -4i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_COLUMN_LOG_REVOKED_DEFAULT: i32 = -7i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_ENCODEMASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_HEXRAW: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_NOCR: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_NOCRLF: u32 = 1073741824u32;
pub const CX500DistinguishedName: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2003_217d_11da_b2a4_000e7bbb2b09);
pub const CX509Attribute: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2022_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeArchiveKey: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2027_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeArchiveKeyHash: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2028_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeClientId: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2025_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeCspProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e202b_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeExtensions: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2024_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeOSVersion: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e202a_217d_11da_b2a4_000e7bbb2b09);
pub const CX509AttributeRenewalCertificate: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2026_217d_11da_b2a4_000e7bbb2b09);
pub const CX509Attributes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2023_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRequestCertificate: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2043_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRequestCmc: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2045_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRequestPkcs10: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2042_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRequestPkcs7: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2044_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRevocationList: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2060_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRevocationListEntries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e205f_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateRevocationListEntry: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e205e_217d_11da_b2a4_000e7bbb2b09);
pub const CX509CertificateTemplateADWritable: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8336e323_2e6a_4a04_937c_548f681839b3);
pub const CX509EndorsementKey: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x11a25a1d_b9a3_4edd_af83_3b59adbed361);
pub const CX509Enrollment: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2046_217d_11da_b2a4_000e7bbb2b09);
pub const CX509EnrollmentHelper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2050_217d_11da_b2a4_000e7bbb2b09);
pub const CX509EnrollmentPolicyActiveDirectory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91f39027_217f_11da_b2a4_000e7bbb2b09);
pub const CX509EnrollmentPolicyWebService: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91f39028_217f_11da_b2a4_000e7bbb2b09);
pub const CX509EnrollmentWebClassFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2049_217d_11da_b2a4_000e7bbb2b09);
pub const CX509Extension: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e200d_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionAlternativeNames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2015_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionAuthorityKeyIdentifier: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2018_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionBasicConstraints: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2016_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionCertificatePolicies: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2020_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionEnhancedKeyUsage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2010_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionKeyUsage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e200f_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionMSApplicationPolicies: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2021_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionSmimeCapabilities: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e201b_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionSubjectKeyIdentifier: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2017_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionTemplate: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2012_217d_11da_b2a4_000e7bbb2b09);
pub const CX509ExtensionTemplateName: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2011_217d_11da_b2a4_000e7bbb2b09);
pub const CX509Extensions: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e200e_217d_11da_b2a4_000e7bbb2b09);
pub const CX509MachineEnrollmentFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2051_217d_11da_b2a4_000e7bbb2b09);
pub const CX509NameValuePair: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e203f_217d_11da_b2a4_000e7bbb2b09);
pub const CX509PolicyServerListManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91f39029_217f_11da_b2a4_000e7bbb2b09);
pub const CX509PolicyServerUrl: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91f3902a_217f_11da_b2a4_000e7bbb2b09);
pub const CX509PrivateKey: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e200c_217d_11da_b2a4_000e7bbb2b09);
pub const CX509PublicKey: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e200b_217d_11da_b2a4_000e7bbb2b09);
pub const CX509SCEPEnrollment: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2061_217d_11da_b2a4_000e7bbb2b09);
pub const CX509SCEPEnrollmentHelper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x884e2062_217d_11da_b2a4_000e7bbb2b09);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupClose(hbc: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupClose(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    CertSrvBackupClose(::core::mem::transmute(hbc)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupEnd(hbc: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupEnd(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    CertSrvBackupEnd(::core::mem::transmute(hbc)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupFree(pv: *mut ::core::ffi::c_void) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupFree(pv: *mut ::core::ffi::c_void);
    }
    CertSrvBackupFree(::core::mem::transmute(pv))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupGetBackupLogsW(hbc: *const ::core::ffi::c_void, ppwszzbackuplogfiles: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupGetBackupLogsW(hbc: *const ::core::ffi::c_void, ppwszzbackuplogfiles: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::HRESULT;
    }
    CertSrvBackupGetBackupLogsW(::core::mem::transmute(hbc), ::core::mem::transmute(ppwszzbackuplogfiles), ::core::mem::transmute(pcbsize)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupGetDatabaseNamesW(hbc: *const ::core::ffi::c_void, ppwszzattachmentinformation: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupGetDatabaseNamesW(hbc: *const ::core::ffi::c_void, ppwszzattachmentinformation: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::HRESULT;
    }
    CertSrvBackupGetDatabaseNamesW(::core::mem::transmute(hbc), ::core::mem::transmute(ppwszzattachmentinformation), ::core::mem::transmute(pcbsize)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupGetDynamicFileListW(hbc: *const ::core::ffi::c_void, ppwszzfilelist: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupGetDynamicFileListW(hbc: *const ::core::ffi::c_void, ppwszzfilelist: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::HRESULT;
    }
    CertSrvBackupGetDynamicFileListW(::core::mem::transmute(hbc), ::core::mem::transmute(ppwszzfilelist), ::core::mem::transmute(pcbsize)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupOpenFileW<'a, P0>(hbc: *mut ::core::ffi::c_void, pwszattachmentname: P0, cbreadhintsize: u32, plifilesize: *mut i64) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupOpenFileW(hbc: *mut ::core::ffi::c_void, pwszattachmentname: ::windows::core::PCWSTR, cbreadhintsize: u32, plifilesize: *mut i64) -> ::windows::core::HRESULT;
    }
    CertSrvBackupOpenFileW(::core::mem::transmute(hbc), pwszattachmentname.into(), cbreadhintsize, ::core::mem::transmute(plifilesize)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupPrepareW<'a, P0>(pwszservername: P0, grbitjet: u32, dwbackupflags: CSBACKUP_TYPE, phbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupPrepareW(pwszservername: ::windows::core::PCWSTR, grbitjet: u32, dwbackupflags: CSBACKUP_TYPE, phbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    CertSrvBackupPrepareW(pwszservername.into(), grbitjet, dwbackupflags, ::core::mem::transmute(phbc)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupRead(hbc: *mut ::core::ffi::c_void, pvbuffer: *mut ::core::ffi::c_void, cbbuffer: u32, pcbread: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupRead(hbc: *mut ::core::ffi::c_void, pvbuffer: *mut ::core::ffi::c_void, cbbuffer: u32, pcbread: *mut u32) -> ::windows::core::HRESULT;
    }
    CertSrvBackupRead(::core::mem::transmute(hbc), ::core::mem::transmute(pvbuffer), cbbuffer, ::core::mem::transmute(pcbread)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvBackupTruncateLogs(hbc: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvBackupTruncateLogs(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    CertSrvBackupTruncateLogs(::core::mem::transmute(hbc)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSrvIsServerOnlineW<'a, P0>(pwszservername: P0, pfserveronline: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvIsServerOnlineW(pwszservername: ::windows::core::PCWSTR, pfserveronline: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT;
    }
    CertSrvIsServerOnlineW(pwszservername.into(), ::core::mem::transmute(pfserveronline)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvRestoreEnd(hbc: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvRestoreEnd(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    CertSrvRestoreEnd(::core::mem::transmute(hbc)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvRestoreGetDatabaseLocationsW(hbc: *const ::core::ffi::c_void, ppwszzdatabaselocationlist: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvRestoreGetDatabaseLocationsW(hbc: *const ::core::ffi::c_void, ppwszzdatabaselocationlist: *mut ::windows::core::PWSTR, pcbsize: *mut u32) -> ::windows::core::HRESULT;
    }
    CertSrvRestoreGetDatabaseLocationsW(::core::mem::transmute(hbc), ::core::mem::transmute(ppwszzdatabaselocationlist), ::core::mem::transmute(pcbsize)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvRestorePrepareW<'a, P0>(pwszservername: P0, dwrestoreflags: u32, phbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvRestorePrepareW(pwszservername: ::windows::core::PCWSTR, dwrestoreflags: u32, phbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    CertSrvRestorePrepareW(pwszservername.into(), dwrestoreflags, ::core::mem::transmute(phbc)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvRestoreRegisterComplete(hbc: *mut ::core::ffi::c_void, hrrestorestate: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvRestoreRegisterComplete(hbc: *mut ::core::ffi::c_void, hrrestorestate: ::windows::core::HRESULT) -> ::windows::core::HRESULT;
    }
    CertSrvRestoreRegisterComplete(::core::mem::transmute(hbc), hrrestorestate).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvRestoreRegisterThroughFile<'a, P0, P1, P2>(hbc: *mut ::core::ffi::c_void, pwszcheckpointfilepath: P0, pwszlogpath: P1, rgrstmap: *mut CSEDB_RSTMAPW, crstmap: i32, pwszbackuplogpath: P2, genlow: u32, genhigh: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvRestoreRegisterThroughFile(hbc: *mut ::core::ffi::c_void, pwszcheckpointfilepath: ::windows::core::PCWSTR, pwszlogpath: ::windows::core::PCWSTR, rgrstmap: *mut CSEDB_RSTMAPW, crstmap: i32, pwszbackuplogpath: ::windows::core::PCWSTR, genlow: u32, genhigh: u32) -> ::windows::core::HRESULT;
    }
    CertSrvRestoreRegisterThroughFile(::core::mem::transmute(hbc), pwszcheckpointfilepath.into(), pwszlogpath.into(), ::core::mem::transmute(rgrstmap), crstmap, pwszbackuplogpath.into(), genlow, genhigh).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvRestoreRegisterW<'a, P0, P1, P2>(hbc: *mut ::core::ffi::c_void, pwszcheckpointfilepath: P0, pwszlogpath: P1, rgrstmap: *mut CSEDB_RSTMAPW, crstmap: i32, pwszbackuplogpath: P2, genlow: u32, genhigh: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvRestoreRegisterW(hbc: *mut ::core::ffi::c_void, pwszcheckpointfilepath: ::windows::core::PCWSTR, pwszlogpath: ::windows::core::PCWSTR, rgrstmap: *mut CSEDB_RSTMAPW, crstmap: i32, pwszbackuplogpath: ::windows::core::PCWSTR, genlow: u32, genhigh: u32) -> ::windows::core::HRESULT;
    }
    CertSrvRestoreRegisterW(::core::mem::transmute(hbc), pwszcheckpointfilepath.into(), pwszlogpath.into(), ::core::mem::transmute(rgrstmap), crstmap, pwszbackuplogpath.into(), genlow, genhigh).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[inline]
pub unsafe fn CertSrvServerControlW<'a, P0>(pwszservername: P0, dwcontrolflags: u32, pcbout: *mut u32, ppbout: *mut *mut u8) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CertSrvServerControlW(pwszservername: ::windows::core::PCWSTR, dwcontrolflags: u32, pcbout: *mut u32, ppbout: *mut *mut u8) -> ::windows::core::HRESULT;
    }
    CertSrvServerControlW(pwszservername.into(), dwcontrolflags, ::core::mem::transmute(pcbout), ::core::mem::transmute(ppbout)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CommitTemplateFlags(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CommitFlagSaveTemplateGenerateOID: CommitTemplateFlags = CommitTemplateFlags(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CommitFlagSaveTemplateUseCurrentOID: CommitTemplateFlags = CommitTemplateFlags(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CommitFlagSaveTemplateOverwrite: CommitTemplateFlags = CommitTemplateFlags(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CommitFlagDeleteTemplate: CommitTemplateFlags = CommitTemplateFlags(4i32);
impl ::core::marker::Copy for CommitTemplateFlags {}
impl ::core::clone::Clone for CommitTemplateFlags {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CommitTemplateFlags {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CommitTemplateFlags {
    type Abi = Self;
}
impl ::core::fmt::Debug for CommitTemplateFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CommitTemplateFlags").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_CHECKPOINTDEPTH60MB: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_CIRCULARLOGGING: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_CREATEIFNEEDED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_DISABLESNAPSHOTBACKUP: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_ENABLEVOLATILEREQUESTS: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_LAZYFLUSH: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_LOGBUFFERSHUGE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_LOGBUFFERSLARGE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_LOGFILESIZE16MB: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_MAXCACHESIZEX100: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_MULTITHREADTRANSACTIONS: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBFLAGS_READONLY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBG_CERTSRV: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DBSESSIONCOUNTDEFAULT: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_ACTIVE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_CA_CERT: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_CA_CERT_CHAIN: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_DENIED: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_ERROR: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_FOREIGN: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_ISSUED: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_KRA_CERT: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_LOG_FAILED_MIN: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_LOG_MIN: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_PENDING: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_QUEUE_MAX: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DB_DISP_REVOKED: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DelayRetryAction(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DelayRetryUnknown: DelayRetryAction = DelayRetryAction(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DelayRetryNone: DelayRetryAction = DelayRetryAction(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DelayRetryShort: DelayRetryAction = DelayRetryAction(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DelayRetryLong: DelayRetryAction = DelayRetryAction(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DelayRetrySuccess: DelayRetryAction = DelayRetryAction(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DelayRetryPastSuccess: DelayRetryAction = DelayRetryAction(5i32);
impl ::core::marker::Copy for DelayRetryAction {}
impl ::core::clone::Clone for DelayRetryAction {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DelayRetryAction {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DelayRetryAction {
    type Abi = Self;
}
impl ::core::fmt::Debug for DelayRetryAction {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DelayRetryAction").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EANR_SUPPRESS_IA5CONVERSION: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EAN_NAMEOBJECTID: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ADDOLDCERTTYPE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ADDOLDKEYUSAGE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ATTRIBUTECA: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ATTRIBUTEEKU: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ATTRIBUTEENDDATE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ATTRIBUTESUBJECTALTNAME2: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_AUDITCERTTEMPLATELOAD: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_BASICCONSTRAINTSCA: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_BASICCONSTRAINTSCRITICAL: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_DISABLEEXTENSIONLIST: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_DISABLELDAPPACKAGELIST: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_DISABLEOLDOSCNUPN: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_EMAILOPTIONAL: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEAKICRITICAL: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEAKIISSUERNAME: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEAKIISSUERSERIAL: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEAKIKEYID: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLECHASECLIENTDC: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEDEFAULTSMIME: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEKEYENCIPHERMENTCACERT: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLELDAPREFERRALS: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEOCSPREVNOCHECK: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLERENEWONBEHALFOF: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEREQUESTEXTENSIONS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_ENABLEUPNMAP: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_IGNOREREQUESTERGROUP: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_REQUESTEXTENSIONLIST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EDITF_SERVERUPGRADED: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ENUMEXT_OBJECTID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ENUM_CATYPES(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ENUM_ENTERPRISE_ROOTCA: ENUM_CATYPES = ENUM_CATYPES(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ENUM_ENTERPRISE_SUBCA: ENUM_CATYPES = ENUM_CATYPES(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ENUM_STANDALONE_ROOTCA: ENUM_CATYPES = ENUM_CATYPES(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ENUM_STANDALONE_SUBCA: ENUM_CATYPES = ENUM_CATYPES(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ENUM_UNKNOWN_CA: ENUM_CATYPES = ENUM_CATYPES(5i32);
impl ::core::marker::Copy for ENUM_CATYPES {}
impl ::core::clone::Clone for ENUM_CATYPES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ENUM_CATYPES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ENUM_CATYPES {
    type Abi = Self;
}
impl ::core::fmt::Debug for ENUM_CATYPES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ENUM_CATYPES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ENUM_CERT_COLUMN_VALUE_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_BASE64: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_BASE64HEADER: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_BASE64REQUESTHEADER: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_BASE64X509CRLHEADER: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_BINARY: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_HEX: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_HEXADDR: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(10u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_HEXASCII: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CV_OUT_HEXASCIIADDR: ENUM_CERT_COLUMN_VALUE_FLAGS = ENUM_CERT_COLUMN_VALUE_FLAGS(11u32);
impl ::core::marker::Copy for ENUM_CERT_COLUMN_VALUE_FLAGS {}
impl ::core::clone::Clone for ENUM_CERT_COLUMN_VALUE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ENUM_CERT_COLUMN_VALUE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ENUM_CERT_COLUMN_VALUE_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for ENUM_CERT_COLUMN_VALUE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ENUM_CERT_COLUMN_VALUE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_CERTIMPORTED: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_INVALID: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITEVENT_STARTUP: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITPUB_ACTIVEDIRECTORY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITPUB_DEFAULT_ENTERPRISE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITPUB_DEFAULT_STANDALONE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITPUB_FILE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXITPUB_REMOVEOLDCERTS: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_CRITICAL_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_DELETE_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_DISABLE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_ADMIN: u32 = 196608u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_CACERT: u32 = 589824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_CMC: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_IMPORTEDCERT: u32 = 393216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_MASK: u32 = 983040u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_PKCS7: u32 = 458752u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_POLICY: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_RENEWALCERT: u32 = 327680u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_REQUEST: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_ORIGIN_SERVER: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EXTENSION_POLICY_MASK: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EncodingType(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BASE64HEADER: EncodingType = EncodingType(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BASE64: EncodingType = EncodingType(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BINARY: EncodingType = EncodingType(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BASE64REQUESTHEADER: EncodingType = EncodingType(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HEX: EncodingType = EncodingType(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HEXASCII: EncodingType = EncodingType(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BASE64_ANY: EncodingType = EncodingType(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_ANY: EncodingType = EncodingType(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HEX_ANY: EncodingType = EncodingType(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BASE64X509CRLHEADER: EncodingType = EncodingType(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HEXADDR: EncodingType = EncodingType(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HEXASCIIADDR: EncodingType = EncodingType(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HEXRAW: EncodingType = EncodingType(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_BASE64URI: EncodingType = EncodingType(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_ENCODEMASK: EncodingType = EncodingType(255i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_CHAIN: EncodingType = EncodingType(256i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_TEXT: EncodingType = EncodingType(512i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_PERCENTESCAPE: EncodingType = EncodingType(134217728i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_HASHDATA: EncodingType = EncodingType(268435456i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_STRICT: EncodingType = EncodingType(536870912i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_NOCRLF: EncodingType = EncodingType(1073741824i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const XCN_CRYPT_STRING_NOCR: EncodingType = EncodingType(-2147483648i32);
impl ::core::marker::Copy for EncodingType {}
impl ::core::clone::Clone for EncodingType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EncodingType {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EncodingType {
    type Abi = Self;
}
impl ::core::fmt::Debug for EncodingType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EncodingType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentCAProperty(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropCommonName: EnrollmentCAProperty = EnrollmentCAProperty(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropDistinguishedName: EnrollmentCAProperty = EnrollmentCAProperty(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropSanitizedName: EnrollmentCAProperty = EnrollmentCAProperty(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropSanitizedShortName: EnrollmentCAProperty = EnrollmentCAProperty(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropDNSName: EnrollmentCAProperty = EnrollmentCAProperty(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropCertificateTypes: EnrollmentCAProperty = EnrollmentCAProperty(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropCertificate: EnrollmentCAProperty = EnrollmentCAProperty(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropDescription: EnrollmentCAProperty = EnrollmentCAProperty(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropWebServers: EnrollmentCAProperty = EnrollmentCAProperty(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropSiteName: EnrollmentCAProperty = EnrollmentCAProperty(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropSecurity: EnrollmentCAProperty = EnrollmentCAProperty(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const CAPropRenewalOnly: EnrollmentCAProperty = EnrollmentCAProperty(12i32);
impl ::core::marker::Copy for EnrollmentCAProperty {}
impl ::core::clone::Clone for EnrollmentCAProperty {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentCAProperty {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentCAProperty {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentCAProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentCAProperty").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentDisplayStatus(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DisplayNo: EnrollmentDisplayStatus = EnrollmentDisplayStatus(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DisplayYes: EnrollmentDisplayStatus = EnrollmentDisplayStatus(1i32);
impl ::core::marker::Copy for EnrollmentDisplayStatus {}
impl ::core::clone::Clone for EnrollmentDisplayStatus {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentDisplayStatus {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentDisplayStatus {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentDisplayStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentDisplayStatus").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentEnrollStatus(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const Enrolled: EnrollmentEnrollStatus = EnrollmentEnrollStatus(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EnrollPended: EnrollmentEnrollStatus = EnrollmentEnrollStatus(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EnrollUIDeferredEnrollmentRequired: EnrollmentEnrollStatus = EnrollmentEnrollStatus(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EnrollError: EnrollmentEnrollStatus = EnrollmentEnrollStatus(16i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EnrollUnknown: EnrollmentEnrollStatus = EnrollmentEnrollStatus(32i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EnrollSkipped: EnrollmentEnrollStatus = EnrollmentEnrollStatus(64i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const EnrollDenied: EnrollmentEnrollStatus = EnrollmentEnrollStatus(256i32);
impl ::core::marker::Copy for EnrollmentEnrollStatus {}
impl ::core::clone::Clone for EnrollmentEnrollStatus {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentEnrollStatus {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentEnrollStatus {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentEnrollStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentEnrollStatus").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentPolicyFlags(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DisableGroupPolicyList: EnrollmentPolicyFlags = EnrollmentPolicyFlags(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DisableUserServerList: EnrollmentPolicyFlags = EnrollmentPolicyFlags(4i32);
impl ::core::marker::Copy for EnrollmentPolicyFlags {}
impl ::core::clone::Clone for EnrollmentPolicyFlags {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentPolicyFlags {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentPolicyFlags {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentPolicyFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentPolicyFlags").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentPolicyServerPropertyFlags(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DefaultNone: EnrollmentPolicyServerPropertyFlags = EnrollmentPolicyServerPropertyFlags(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const DefaultPolicyServer: EnrollmentPolicyServerPropertyFlags = EnrollmentPolicyServerPropertyFlags(1i32);
impl ::core::marker::Copy for EnrollmentPolicyServerPropertyFlags {}
impl ::core::clone::Clone for EnrollmentPolicyServerPropertyFlags {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentPolicyServerPropertyFlags {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentPolicyServerPropertyFlags {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentPolicyServerPropertyFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentPolicyServerPropertyFlags").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentSelectionStatus(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const SelectedNo: EnrollmentSelectionStatus = EnrollmentSelectionStatus(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const SelectedYes: EnrollmentSelectionStatus = EnrollmentSelectionStatus(1i32);
impl ::core::marker::Copy for EnrollmentSelectionStatus {}
impl ::core::clone::Clone for EnrollmentSelectionStatus {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentSelectionStatus {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentSelectionStatus {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentSelectionStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentSelectionStatus").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EnrollmentTemplateProperty(pub i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropCommonName: EnrollmentTemplateProperty = EnrollmentTemplateProperty(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropFriendlyName: EnrollmentTemplateProperty = EnrollmentTemplateProperty(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropEKUs: EnrollmentTemplateProperty = EnrollmentTemplateProperty(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropCryptoProviders: EnrollmentTemplateProperty = EnrollmentTemplateProperty(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropMajorRevision: EnrollmentTemplateProperty = EnrollmentTemplateProperty(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropDescription: EnrollmentTemplateProperty = EnrollmentTemplateProperty(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropKeySpec: EnrollmentTemplateProperty = EnrollmentTemplateProperty(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropSchemaVersion: EnrollmentTemplateProperty = EnrollmentTemplateProperty(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropMinorRevision: EnrollmentTemplateProperty = EnrollmentTemplateProperty(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropRASignatureCount: EnrollmentTemplateProperty = EnrollmentTemplateProperty(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropMinimumKeySize: EnrollmentTemplateProperty = EnrollmentTemplateProperty(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropOID: EnrollmentTemplateProperty = EnrollmentTemplateProperty(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropSupersede: EnrollmentTemplateProperty = EnrollmentTemplateProperty(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropRACertificatePolicies: EnrollmentTemplateProperty = EnrollmentTemplateProperty(14i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropRAEKUs: EnrollmentTemplateProperty = EnrollmentTemplateProperty(15i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropCertificatePolicies: EnrollmentTemplateProperty = EnrollmentTemplateProperty(16i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropV1ApplicationPolicy: EnrollmentTemplateProperty = EnrollmentTemplateProperty(17i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropAsymmetricAlgorithm: EnrollmentTemplateProperty = EnrollmentTemplateProperty(18i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropKeySecurityDescriptor: EnrollmentTemplateProperty = EnrollmentTemplateProperty(19i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropSymmetricAlgorithm: EnrollmentTemplateProperty = EnrollmentTemplateProperty(20i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropSymmetricKeyLength: EnrollmentTemplateProperty = EnrollmentTemplateProperty(21i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropHashAlgorithm: EnrollmentTemplateProperty = EnrollmentTemplateProperty(22i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropKeyUsage: EnrollmentTemplateProperty = EnrollmentTemplateProperty(23i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropEnrollmentFlags: EnrollmentTemplateProperty = EnrollmentTemplateProperty(24i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropSubjectNameFlags: EnrollmentTemplateProperty = EnrollmentTemplateProperty(25i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropPrivateKeyFlags: EnrollmentTemplateProperty = EnrollmentTemplateProperty(26i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropGeneralFlags: EnrollmentTemplateProperty = EnrollmentTemplateProperty(27i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropSecurityDescriptor: EnrollmentTemplateProperty = EnrollmentTemplateProperty(28i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropExtensions: EnrollmentTemplateProperty = EnrollmentTemplateProperty(29i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropValidityPeriod: EnrollmentTemplateProperty = EnrollmentTemplateProperty(30i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const TemplatePropRenewalPeriod: EnrollmentTemplateProperty = EnrollmentTemplateProperty(31i32);
impl ::core::marker::Copy for EnrollmentTemplateProperty {}
impl ::core::clone::Clone for EnrollmentTemplateProperty {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EnrollmentTemplateProperty {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EnrollmentTemplateProperty {
    type Abi = Self;
}
impl ::core::fmt::Debug for EnrollmentTemplateProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EnrollmentTemplateProperty").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPCLOSE = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPEND = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPFREE = ::core::option::Option<unsafe extern "system" fn(pv: *mut ::core::ffi::c_void)>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPGETBACKUPLOGSW = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, ppwszzbackuplogfiles: *mut *mut u16, pcbsize: *mut u32) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPGETDATABASENAMESW = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, ppwszzattachmentinformation: *mut *mut u16, pcbsize: *mut u32) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPGETDYNAMICFILELISTW = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, ppwszzfilelist: *mut *mut u16, pcbsize: *mut u32) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPOPENFILEW = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, pwszattachmentname: ::windows::core::PCWSTR, cbreadhintsize: u32, plifilesize: *mut i64) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPPREPAREW = ::core::option::Option<unsafe extern "system" fn(pwszservername: ::windows::core::PCWSTR, grbitjet: u32, dwbackupflags: u32, phbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPREAD = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, pvbuffer: *mut ::core::ffi::c_void, cbbuffer: u32, pcbread: *mut u32) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVBACKUPTRUNCATELOGS = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub type FNCERTSRVISSERVERONLINEW = ::core::option::Option<unsafe extern "system" fn(pwszservername: ::windows::core::PCWSTR, pfserveronline: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVRESTOREEND = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVRESTOREGETDATABASELOCATIONSW = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, ppwszzdatabaselocationlist: *mut *mut u16, pcbsize: *mut u32) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVRESTOREPREPAREW = ::core::option::Option<unsafe extern "system" fn(pwszservername: ::windows::core::PCWSTR, dwrestoreflags: u32, phbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVRESTOREREGISTERCOMPLETE = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, hrrestorestate: ::windows::core::HRESULT) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVRESTOREREGISTERW = ::core::option::Option<unsafe extern "system" fn(hbc: *mut ::core::ffi::c_void, pwszcheckpointfilepath: ::windows::core::PCWSTR, pwszlogpath: ::windows::core::PCWSTR, rgrstmap: *mut CSEDB_RSTMAPW, crstmap: i32, pwszbackuplogpath: ::windows::core::PCWSTR, genlow: u32, genhigh: u32) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub type FNCERTSRVSERVERCONTROLW = ::core::option::Option<unsafe extern "system" fn(pwszservername: ::windows::core::PCWSTR, dwcontrolflags: u32, pcbout: *mut u32, ppbout: *mut *mut u8) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub type FNIMPORTPFXTOPROVIDER = ::core::option::Option<unsafe extern "system" fn(hwndparent: super::super::super::Foundation::HWND, pbpfx: *const u8, cbpfx: u32, importflags: ImportPFXFlags, pwszpassword: ::windows::core::PCWSTR, pwszprovidername: ::windows::core::PCWSTR, pwszreadername: ::windows::core::PCWSTR, pwszcontainernameprefix: ::windows::core::PCWSTR, pwszpin: ::windows::core::PCWSTR, pwszfriendlyname: ::windows::core::PCWSTR, pccertout: *mut u32, prgpcertout: *mut *mut *mut super::CERT_CONTEXT) -> ::windows::core::HRESULT>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub type FNIMPORTPFXTOPROVIDERFREEDATA = ::core::option::Option<unsafe extern "system" fn(ccert: u32, rgpcert: *const *const super::CERT_CONTEXT)>;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_CLAIMCHALLENGE: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FULL_RESPONSE_PROPERTY_ID(pub u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_NONE: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_FULLRESPONSE: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_STATUSINFOCOUNT: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_BODYPARTSTRING: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_STATUS: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_STATUSSTRING: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_OTHERINFOCHOICE: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_FAILINFO: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_PENDINFOTOKEN: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_PENDINFOTIME: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ISSUEDCERTIFICATEHASH: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(10u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ISSUEDCERTIFICATE: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(11u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ISSUEDCERTIFICATECHAIN: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(12u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ISSUEDCERTIFICATECRLCHAIN: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(13u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ENCRYPTEDKEYHASH: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(14u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_FULLRESPONSENOPKCS7: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(15u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_CAEXCHANGECERTIFICATEHASH: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_CAEXCHANGECERTIFICATE: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(17u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_CAEXCHANGECERTIFICATECHAIN: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(18u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_CAEXCHANGECERTIFICATECRLCHAIN: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(19u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ATTESTATIONCHALLENGE: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(20u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const FR_PROP_ATTESTATIONPROVIDERNAME: FULL_RESPONSE_PROPERTY_ID = FULL_RESPONSE_PROPERTY_ID(21u32);
impl ::core::marker::Copy for FULL_RESPONSE_PROPERTY_ID {}
impl ::core::clone::Clone for FULL_RESPONSE_PROPERTY_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FULL_RESPONSE_PROPERTY_ID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FULL_RESPONSE_PROPERTY_ID {
    type Abi = Self;
}
impl ::core::fmt::Debug for FULL_RESPONSE_PROPERTY_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FULL_RESPONSE_PROPERTY_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAlternativeName(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAlternativeName {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromString<'a, P0>(&self, r#type: AlternativeNameType, strvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromString)(::windows::core::Interface::as_raw(self), r#type, strvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromRawData<'a, P0>(&self, r#type: AlternativeNameType, encoding: EncodingType, strrawdata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromRawData)(::windows::core::Interface::as_raw(self), r#type, encoding, strrawdata.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn InitializeFromOtherName<'a, P0, P1>(&self, pobjectid: P0, encoding: EncodingType, strrawdata: P1, tobewrapped: i16) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromOtherName)(::windows::core::Interface::as_raw(self), pobjectid.into().abi(), encoding, strrawdata.into().abi(), tobewrapped).ok()
    }
    pub unsafe fn Type(&self) -> ::windows::core::Result<AlternativeNameType> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<AlternativeNameType>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StrValue(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).StrValue)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ObjectId(&self) -> ::windows::core::Result<IObjectId> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ObjectId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IObjectId>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAlternativeName> for ::windows::core::IUnknown {
    fn from(value: IAlternativeName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IAlternativeName> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAlternativeName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAlternativeName> for ::windows::core::IUnknown {
    fn from(value: &IAlternativeName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAlternativeName> for super::super::super::System::Com::IDispatch {
    fn from(value: IAlternativeName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IAlternativeName> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a IAlternativeName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAlternativeName> for super::super::super::System::Com::IDispatch {
    fn from(value: &IAlternativeName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAlternativeName {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAlternativeName {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAlternativeName {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAlternativeName {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlternativeName").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for IAlternativeName {
    type Vtable = IAlternativeName_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab313_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAlternativeName_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeFromString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, r#type: AlternativeNameType, strvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeFromString: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeFromRawData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, r#type: AlternativeNameType, encoding: EncodingType, strrawdata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeFromRawData: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub InitializeFromOtherName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobjectid: *mut ::core::ffi::c_void, encoding: EncodingType, strrawdata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, tobewrapped: i16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    InitializeFromOtherName: usize,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut AlternativeNameType) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub StrValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    StrValue: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ObjectId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ObjectId: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub get_RawData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_RawData: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAlternativeNames(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAlternativeNames {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<IAlternativeName> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IAlternativeName>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IAlternativeName>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAlternativeNames> for ::windows::core::IUnknown {
    fn from(value: IAlternativeNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IAlternativeNames> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAlternativeNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAlternativeNames> for ::windows::core::IUnknown {
    fn from(value: &IAlternativeNames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IAlternativeNames> for super::super::super::System::Com::IDispatch {
    fn from(value: IAlternativeNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IAlternativeNames> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a IAlternativeNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IAlternativeNames> for super::super::super::System::Com::IDispatch {
    fn from(value: &IAlternativeNames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAlternativeNames {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAlternativeNames {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAlternativeNames {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAlternativeNames {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlternativeNames").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for IAlternativeNames {
    type Vtable = IAlternativeNames_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab314_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAlternativeNames_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IBinaryConverter(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IBinaryConverter {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StringToString<'a, P0>(&self, strencodedin: P0, encodingin: EncodingType, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).StringToString)(::windows::core::Interface::as_raw(self), strencodedin.into().abi(), encodingin, encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn VariantByteArrayToString(&self, pvarbytearray: *const super::super::super::System::Com::VARIANT, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).VariantByteArrayToString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarbytearray), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn StringToVariantByteArray<'a, P0>(&self, strencoded: P0, encoding: EncodingType) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).StringToVariantByteArray)(::windows::core::Interface::as_raw(self), strencoded.into().abi(), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IBinaryConverter> for ::windows::core::IUnknown {
    fn from(value: IBinaryConverter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IBinaryConverter> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBinaryConverter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IBinaryConverter> for ::windows::core::IUnknown {
    fn from(value: &IBinaryConverter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IBinaryConverter> for super::super::super::System::Com::IDispatch {
    fn from(value: IBinaryConverter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IBinaryConverter> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a IBinaryConverter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IBinaryConverter> for super::super::super::System::Com::IDispatch {
    fn from(value: &IBinaryConverter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IBinaryConverter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IBinaryConverter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IBinaryConverter {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IBinaryConverter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBinaryConverter").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for IBinaryConverter {
    type Vtable = IBinaryConverter_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab302_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IBinaryConverter_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub StringToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodedin: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encodingin: EncodingType, encoding: EncodingType, pstrencoded: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    StringToString: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub VariantByteArrayToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarbytearray: *const super::super::super::System::Com::VARIANT, encoding: EncodingType, pstrencoded: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    VariantByteArrayToString: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub StringToVariantByteArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencoded: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType, pvarbytearray: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    StringToVariantByteArray: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IBinaryConverter2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IBinaryConverter2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StringToString<'a, P0>(&self, strencodedin: P0, encodingin: EncodingType, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.StringToString)(::windows::core::Interface::as_raw(self), strencodedin.into().abi(), encodingin, encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn VariantByteArrayToString(&self, pvarbytearray: *const super::super::super::System::Com::VARIANT, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.VariantByteArrayToString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarbytearray), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn StringToVariantByteArray<'a, P0>(&self, strencoded: P0, encoding: EncodingType) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.StringToVariantByteArray)(::windows::core::Interface::as_raw(self), strencoded.into().abi(), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn StringArrayToVariantArray(&self, pvarstringarray: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).StringArrayToVariantArray)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarstringarray), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn VariantArrayToStringArray(&self, pvarvariantarray: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).VariantArrayToStringArray)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarvariantarray), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IBinaryConverter2> for ::windows::core::IUnknown {
    fn from(value: IBinaryConverter2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IBinaryConverter2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBinaryConverter2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IBinaryConverter2> for ::windows::core::IUnknown {
    fn from(value: &IBinaryConverter2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IBinaryConverter2> for super::super::super::System::Com::IDispatch {
    fn from(value: IBinaryConverter2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IBinaryConverter2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a IBinaryConverter2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IBinaryConverter2> for super::super::super::System::Com::IDispatch {
    fn from(value: &IBinaryConverter2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<IBinaryConverter2> for IBinaryConverter {
    fn from(value: IBinaryConverter2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a IBinaryConverter2> for &'a IBinaryConverter {
    fn from(value: &'a IBinaryConverter2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&IBinaryConverter2> for IBinaryConverter {
    fn from(value: &IBinaryConverter2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IBinaryConverter2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IBinaryConverter2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IBinaryConverter2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IBinaryConverter2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBinaryConverter2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for IBinaryConverter2 {
    type Vtable = IBinaryConverter2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8d7928b4_4e17_428d_9a17_728df00d1b2b);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IBinaryConverter2_Vtbl {
    pub base__: IBinaryConverter_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub StringArrayToVariantArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarstringarray: *const super::super::super::System::Com::VARIANT, pvarvariantarray: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    StringArrayToVariantArray: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub VariantArrayToStringArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarvariantarray: *const super::super::super::System::Com::VARIANT, pvarstringarray: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    VariantArrayToStringArray: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICEnroll(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICEnroll {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createFilePKCS10<'a, P0, P1, P2>(&self, dnname: P0, usage: P1, wszpkcs10filename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).createFilePKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), wszpkcs10filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptFilePKCS7<'a, P0>(&self, wszpkcs7filename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).acceptFilePKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createPKCS10<'a, P0, P1>(&self, dnname: P0, usage: P1) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).createPKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptPKCS7<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).acceptPKCS7)(::windows::core::Interface::as_raw(self), pkcs7.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertFromPKCS7<'a, P0>(&self, wszpkcs7: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).getCertFromPKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumProviders(&self, dwindex: i32, dwflags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).enumProviders)(::windows::core::Interface::as_raw(self), dwindex, dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumContainers(&self, dwindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).enumContainers)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn freeRequestInfo<'a, P0>(&self, pkcs7orpkcs10: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).freeRequestInfo)(::windows::core::Interface::as_raw(self), pkcs7orpkcs10.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).MyStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetMyStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).MyStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetMyStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn MyStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).MyStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetMyStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMyStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CAStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCAStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CAStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCAStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn CAStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CAStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetCAStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCAStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RootStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetRootStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RootStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetRootStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RootStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RootStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRootStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRootStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RequestStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetRequestStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RequestStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetRequestStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RequestStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RequestStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRequestStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRequestStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContainerName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ContainerName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetContainerName<'a, P0>(&self, bstrcontainer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetContainerName)(::windows::core::Interface::as_raw(self), bstrcontainer.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ProviderName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ProviderName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProviderName<'a, P0>(&self, bstrprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetProviderName)(::windows::core::Interface::as_raw(self), bstrprovider.into().abi()).ok()
    }
    pub unsafe fn ProviderType(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ProviderType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderType(&self, dwtype: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProviderType)(::windows::core::Interface::as_raw(self), dwtype).ok()
    }
    pub unsafe fn KeySpec(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetKeySpec(&self, dw: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetKeySpec)(::windows::core::Interface::as_raw(self), dw).ok()
    }
    pub unsafe fn ProviderFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ProviderFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProviderFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseExistingKeySet(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).UseExistingKeySet)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseExistingKeySet<'a, P0>(&self, fuseexistingkeys: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetUseExistingKeySet)(::windows::core::Interface::as_raw(self), fuseexistingkeys.into()).ok()
    }
    pub unsafe fn GenKeyFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GenKeyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetGenKeyFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetGenKeyFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRequestCert(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).DeleteRequestCert)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDeleteRequestCert<'a, P0>(&self, fdelete: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetDeleteRequestCert)(::windows::core::Interface::as_raw(self), fdelete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToCSP(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).WriteCertToCSP)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToCSP<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetWriteCertToCSP)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SPCFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).SPCFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSPCFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetSPCFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PVKFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).PVKFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPVKFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetPVKFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HashAlgorithm(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).HashAlgorithm)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHashAlgorithm<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetHashAlgorithm)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll> for ::windows::core::IUnknown {
    fn from(value: ICEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll> for ::windows::core::IUnknown {
    fn from(value: &ICEnroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll> for super::super::super::System::Com::IDispatch {
    fn from(value: ICEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICEnroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICEnroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICEnroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICEnroll {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICEnroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICEnroll").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICEnroll {
    type Vtable = ICEnroll_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x43f8f288_7a20_11d0_8f06_00c04fc295e1);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICEnroll_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub createFilePKCS10: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dnname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, usage: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, wszpkcs10filename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    createFilePKCS10: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub acceptFilePKCS7: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszpkcs7filename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    acceptFilePKCS7: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub createPKCS10: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dnname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, usage: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, ppkcs10: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    createPKCS10: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub acceptPKCS7: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkcs7: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    acceptPKCS7: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub getCertFromPKCS7: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszpkcs7: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pbstrcert: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    getCertFromPKCS7: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub enumProviders: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: i32, dwflags: i32, pbstrprovname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    enumProviders: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub enumContainers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: i32, pbstr: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    enumContainers: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub freeRequestInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkcs7orpkcs10: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    freeRequestInfo: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub MyStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    MyStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetMyStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetMyStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub MyStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtype: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    MyStoreType: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetMyStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrtype: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetMyStoreType: usize,
    pub MyStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetMyStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CAStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CAStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCAStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCAStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub CAStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtype: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CAStoreType: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCAStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrtype: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCAStoreType: usize,
    pub CAStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetCAStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RootStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RootStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRootStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRootStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RootStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtype: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RootStoreType: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRootStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrtype: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRootStoreType: usize,
    pub RootStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetRootStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RequestStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RequestStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRequestStoreName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRequestStoreName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RequestStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtype: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RequestStoreType: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRequestStoreType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrtype: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRequestStoreType: usize,
    pub RequestStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetRequestStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ContainerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontainer: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ContainerName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetContainerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcontainer: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetContainerName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ProviderName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrprovider: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ProviderName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetProviderName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrprovider: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetProviderName: usize,
    pub ProviderType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwtype: *mut i32) -> ::windows::core::HRESULT,
    pub SetProviderType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtype: i32) -> ::windows::core::HRESULT,
    pub KeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdw: *mut i32) -> ::windows::core::HRESULT,
    pub SetKeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dw: i32) -> ::windows::core::HRESULT,
    pub ProviderFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetProviderFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UseExistingKeySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fuseexistingkeys: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UseExistingKeySet: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetUseExistingKeySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fuseexistingkeys: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetUseExistingKeySet: usize,
    pub GenKeyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetGenKeyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub DeleteRequestCert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdelete: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DeleteRequestCert: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDeleteRequestCert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdelete: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDeleteRequestCert: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub WriteCertToCSP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WriteCertToCSP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetWriteCertToCSP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetWriteCertToCSP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SPCFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstr: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SPCFileName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSPCFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstr: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSPCFileName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub PVKFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstr: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PVKFileName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetPVKFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstr: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetPVKFileName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub HashAlgorithm: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstr: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HashAlgorithm: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetHashAlgorithm: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstr: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetHashAlgorithm: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICEnroll2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICEnroll2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createFilePKCS10<'a, P0, P1, P2>(&self, dnname: P0, usage: P1, wszpkcs10filename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.createFilePKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), wszpkcs10filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptFilePKCS7<'a, P0>(&self, wszpkcs7filename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.acceptFilePKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createPKCS10<'a, P0, P1>(&self, dnname: P0, usage: P1) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.createPKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptPKCS7<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.acceptPKCS7)(::windows::core::Interface::as_raw(self), pkcs7.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertFromPKCS7<'a, P0>(&self, wszpkcs7: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.getCertFromPKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumProviders(&self, dwindex: i32, dwflags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.enumProviders)(::windows::core::Interface::as_raw(self), dwindex, dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumContainers(&self, dwindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.enumContainers)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn freeRequestInfo<'a, P0>(&self, pkcs7orpkcs10: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.freeRequestInfo)(::windows::core::Interface::as_raw(self), pkcs7orpkcs10.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.MyStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetMyStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.MyStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetMyStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn MyStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.MyStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetMyStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetMyStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.CAStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCAStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.CAStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCAStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn CAStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.CAStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetCAStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetCAStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RootStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRootStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RootStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRootStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RootStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RootStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRootStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRootStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RequestStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRequestStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RequestStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRequestStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RequestStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RequestStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRequestStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRequestStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContainerName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ContainerName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetContainerName<'a, P0>(&self, bstrcontainer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetContainerName)(::windows::core::Interface::as_raw(self), bstrcontainer.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ProviderName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ProviderName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProviderName<'a, P0>(&self, bstrprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetProviderName)(::windows::core::Interface::as_raw(self), bstrprovider.into().abi()).ok()
    }
    pub unsafe fn ProviderType(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ProviderType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderType(&self, dwtype: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetProviderType)(::windows::core::Interface::as_raw(self), dwtype).ok()
    }
    pub unsafe fn KeySpec(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetKeySpec(&self, dw: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetKeySpec)(::windows::core::Interface::as_raw(self), dw).ok()
    }
    pub unsafe fn ProviderFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ProviderFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetProviderFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseExistingKeySet(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.UseExistingKeySet)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseExistingKeySet<'a, P0>(&self, fuseexistingkeys: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetUseExistingKeySet)(::windows::core::Interface::as_raw(self), fuseexistingkeys.into()).ok()
    }
    pub unsafe fn GenKeyFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GenKeyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetGenKeyFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetGenKeyFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRequestCert(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.DeleteRequestCert)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDeleteRequestCert<'a, P0>(&self, fdelete: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetDeleteRequestCert)(::windows::core::Interface::as_raw(self), fdelete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToCSP(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.WriteCertToCSP)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToCSP<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetWriteCertToCSP)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SPCFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.SPCFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSPCFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetSPCFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PVKFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PVKFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPVKFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetPVKFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HashAlgorithm(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.HashAlgorithm)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHashAlgorithm<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetHashAlgorithm)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addCertTypeToRequest<'a, P0>(&self, certtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).addCertTypeToRequest)(::windows::core::Interface::as_raw(self), certtype.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addNameValuePairToSignature<'a, P0, P1>(&self, name: P0, value: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).addNameValuePairToSignature)(::windows::core::Interface::as_raw(self), name.into().abi(), value.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToUserDS(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).WriteCertToUserDS)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToUserDS<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetWriteCertToUserDS)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableT61DNEncoding(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnableT61DNEncoding)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableT61DNEncoding<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetEnableT61DNEncoding)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll2> for ::windows::core::IUnknown {
    fn from(value: ICEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll2> for ::windows::core::IUnknown {
    fn from(value: &ICEnroll2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICEnroll2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll2> for ICEnroll {
    fn from(value: ICEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll2> for &'a ICEnroll {
    fn from(value: &'a ICEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll2> for ICEnroll {
    fn from(value: &ICEnroll2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICEnroll2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICEnroll2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICEnroll2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICEnroll2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICEnroll2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICEnroll2 {
    type Vtable = ICEnroll2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x704ca730_c90b_11d1_9bec_00c04fc295e1);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICEnroll2_Vtbl {
    pub base__: ICEnroll_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub addCertTypeToRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, certtype: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addCertTypeToRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub addNameValuePairToSignature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, value: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addNameValuePairToSignature: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub WriteCertToUserDS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WriteCertToUserDS: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetWriteCertToUserDS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetWriteCertToUserDS: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableT61DNEncoding: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableT61DNEncoding: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableT61DNEncoding: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableT61DNEncoding: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICEnroll3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICEnroll3 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createFilePKCS10<'a, P0, P1, P2>(&self, dnname: P0, usage: P1, wszpkcs10filename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.createFilePKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), wszpkcs10filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptFilePKCS7<'a, P0>(&self, wszpkcs7filename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.acceptFilePKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createPKCS10<'a, P0, P1>(&self, dnname: P0, usage: P1) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.createPKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptPKCS7<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.acceptPKCS7)(::windows::core::Interface::as_raw(self), pkcs7.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertFromPKCS7<'a, P0>(&self, wszpkcs7: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.getCertFromPKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumProviders(&self, dwindex: i32, dwflags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.enumProviders)(::windows::core::Interface::as_raw(self), dwindex, dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumContainers(&self, dwindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.enumContainers)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn freeRequestInfo<'a, P0>(&self, pkcs7orpkcs10: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.freeRequestInfo)(::windows::core::Interface::as_raw(self), pkcs7orpkcs10.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.MyStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetMyStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.MyStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetMyStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn MyStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.MyStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetMyStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetMyStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.CAStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetCAStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.CAStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetCAStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn CAStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.CAStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetCAStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetCAStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RootStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetRootStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RootStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetRootStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RootStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RootStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRootStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetRootStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RequestStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetRequestStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RequestStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetRequestStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RequestStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RequestStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRequestStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetRequestStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContainerName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.ContainerName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetContainerName<'a, P0>(&self, bstrcontainer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetContainerName)(::windows::core::Interface::as_raw(self), bstrcontainer.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ProviderName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.ProviderName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProviderName<'a, P0>(&self, bstrprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetProviderName)(::windows::core::Interface::as_raw(self), bstrprovider.into().abi()).ok()
    }
    pub unsafe fn ProviderType(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.ProviderType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderType(&self, dwtype: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetProviderType)(::windows::core::Interface::as_raw(self), dwtype).ok()
    }
    pub unsafe fn KeySpec(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetKeySpec(&self, dw: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetKeySpec)(::windows::core::Interface::as_raw(self), dw).ok()
    }
    pub unsafe fn ProviderFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.ProviderFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetProviderFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseExistingKeySet(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.UseExistingKeySet)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseExistingKeySet<'a, P0>(&self, fuseexistingkeys: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetUseExistingKeySet)(::windows::core::Interface::as_raw(self), fuseexistingkeys.into()).ok()
    }
    pub unsafe fn GenKeyFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GenKeyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetGenKeyFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetGenKeyFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRequestCert(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.DeleteRequestCert)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDeleteRequestCert<'a, P0>(&self, fdelete: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetDeleteRequestCert)(::windows::core::Interface::as_raw(self), fdelete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToCSP(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.WriteCertToCSP)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToCSP<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetWriteCertToCSP)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SPCFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.SPCFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSPCFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetSPCFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PVKFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.PVKFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPVKFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetPVKFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HashAlgorithm(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.HashAlgorithm)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHashAlgorithm<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetHashAlgorithm)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addCertTypeToRequest<'a, P0>(&self, certtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.addCertTypeToRequest)(::windows::core::Interface::as_raw(self), certtype.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addNameValuePairToSignature<'a, P0, P1>(&self, name: P0, value: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.addNameValuePairToSignature)(::windows::core::Interface::as_raw(self), name.into().abi(), value.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToUserDS(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.WriteCertToUserDS)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToUserDS<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetWriteCertToUserDS)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableT61DNEncoding(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.EnableT61DNEncoding)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableT61DNEncoding<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetEnableT61DNEncoding)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InstallPKCS7<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InstallPKCS7)(::windows::core::Interface::as_raw(self), pkcs7.into().abi()).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetSupportedKeySpec(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetSupportedKeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKeyLen<'a, P0, P1>(&self, fmin: P0, fexchange: P1) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetKeyLen)(::windows::core::Interface::as_raw(self), fmin.into(), fexchange.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn EnumAlgs(&self, dwindex: i32, algclass: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumAlgs)(::windows::core::Interface::as_raw(self), dwindex, algclass, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAlgName(&self, algid: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAlgName)(::windows::core::Interface::as_raw(self), algid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetReuseHardwareKeyIfUnableToGenNew<'a, P0>(&self, freusehardwarekeyifunabletogennew: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetReuseHardwareKeyIfUnableToGenNew)(::windows::core::Interface::as_raw(self), freusehardwarekeyifunabletogennew.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReuseHardwareKeyIfUnableToGenNew(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ReuseHardwareKeyIfUnableToGenNew)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetHashAlgID(&self, hashalgid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetHashAlgID)(::windows::core::Interface::as_raw(self), hashalgid).ok()
    }
    pub unsafe fn HashAlgID(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).HashAlgID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLimitExchangeKeyToEncipherment<'a, P0>(&self, flimitexchangekeytoencipherment: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetLimitExchangeKeyToEncipherment)(::windows::core::Interface::as_raw(self), flimitexchangekeytoencipherment.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LimitExchangeKeyToEncipherment(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).LimitExchangeKeyToEncipherment)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSMIMECapabilities<'a, P0>(&self, fenablesmimecapabilities: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetEnableSMIMECapabilities)(::windows::core::Interface::as_raw(self), fenablesmimecapabilities.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableSMIMECapabilities(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnableSMIMECapabilities)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll3> for ::windows::core::IUnknown {
    fn from(value: ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll3> for ::windows::core::IUnknown {
    fn from(value: &ICEnroll3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll3> for super::super::super::System::Com::IDispatch {
    fn from(value: ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll3> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll3> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICEnroll3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll3> for ICEnroll {
    fn from(value: ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll3> for &'a ICEnroll {
    fn from(value: &'a ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll3> for ICEnroll {
    fn from(value: &ICEnroll3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll3> for ICEnroll2 {
    fn from(value: ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll3> for &'a ICEnroll2 {
    fn from(value: &'a ICEnroll3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll3> for ICEnroll2 {
    fn from(value: &ICEnroll3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICEnroll3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICEnroll3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICEnroll3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICEnroll3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICEnroll3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICEnroll3 {
    type Vtable = ICEnroll3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc28c2d95_b7de_11d2_a421_00c04f79fe8e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICEnroll3_Vtbl {
    pub base__: ICEnroll2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub InstallPKCS7: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkcs7: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InstallPKCS7: usize,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSupportedKeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwkeyspec: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetKeyLen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fmin: super::super::super::Foundation::BOOL, fexchange: super::super::super::Foundation::BOOL, pdwkeysize: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetKeyLen: usize,
    pub EnumAlgs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: i32, algclass: i32, pdwalgid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetAlgName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, algid: i32, pbstr: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetAlgName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetReuseHardwareKeyIfUnableToGenNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, freusehardwarekeyifunabletogennew: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetReuseHardwareKeyIfUnableToGenNew: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ReuseHardwareKeyIfUnableToGenNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, freusehardwarekeyifunabletogennew: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ReuseHardwareKeyIfUnableToGenNew: usize,
    pub SetHashAlgID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hashalgid: i32) -> ::windows::core::HRESULT,
    pub HashAlgID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hashalgid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetLimitExchangeKeyToEncipherment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flimitexchangekeytoencipherment: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetLimitExchangeKeyToEncipherment: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub LimitExchangeKeyToEncipherment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flimitexchangekeytoencipherment: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LimitExchangeKeyToEncipherment: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableSMIMECapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenablesmimecapabilities: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableSMIMECapabilities: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableSMIMECapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenablesmimecapabilities: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableSMIMECapabilities: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICEnroll4(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICEnroll4 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createFilePKCS10<'a, P0, P1, P2>(&self, dnname: P0, usage: P1, wszpkcs10filename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.createFilePKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), wszpkcs10filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptFilePKCS7<'a, P0>(&self, wszpkcs7filename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.acceptFilePKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7filename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createPKCS10<'a, P0, P1>(&self, dnname: P0, usage: P1) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.createPKCS10)(::windows::core::Interface::as_raw(self), dnname.into().abi(), usage.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptPKCS7<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.acceptPKCS7)(::windows::core::Interface::as_raw(self), pkcs7.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertFromPKCS7<'a, P0>(&self, wszpkcs7: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.getCertFromPKCS7)(::windows::core::Interface::as_raw(self), wszpkcs7.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumProviders(&self, dwindex: i32, dwflags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.enumProviders)(::windows::core::Interface::as_raw(self), dwindex, dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn enumContainers(&self, dwindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.enumContainers)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn freeRequestInfo<'a, P0>(&self, pkcs7orpkcs10: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.freeRequestInfo)(::windows::core::Interface::as_raw(self), pkcs7orpkcs10.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.MyStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetMyStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MyStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.MyStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMyStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetMyStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn MyStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.MyStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetMyStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetMyStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.CAStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetCAStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.CAStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCAStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetCAStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn CAStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.CAStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetCAStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetCAStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.RootStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetRootStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RootStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.RootStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRootStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetRootStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RootStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.RootStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRootStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetRootStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.RequestStoreName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreName<'a, P0>(&self, bstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetRequestStoreName)(::windows::core::Interface::as_raw(self), bstrname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestStoreType(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.RequestStoreType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestStoreType<'a, P0>(&self, bstrtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetRequestStoreType)(::windows::core::Interface::as_raw(self), bstrtype.into().abi()).ok()
    }
    pub unsafe fn RequestStoreFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.RequestStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetRequestStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetRequestStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ContainerName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.ContainerName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetContainerName<'a, P0>(&self, bstrcontainer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetContainerName)(::windows::core::Interface::as_raw(self), bstrcontainer.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ProviderName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.ProviderName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProviderName<'a, P0>(&self, bstrprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetProviderName)(::windows::core::Interface::as_raw(self), bstrprovider.into().abi()).ok()
    }
    pub unsafe fn ProviderType(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.ProviderType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderType(&self, dwtype: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetProviderType)(::windows::core::Interface::as_raw(self), dwtype).ok()
    }
    pub unsafe fn KeySpec(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetKeySpec(&self, dw: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetKeySpec)(::windows::core::Interface::as_raw(self), dw).ok()
    }
    pub unsafe fn ProviderFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.ProviderFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetProviderFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetProviderFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseExistingKeySet(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.UseExistingKeySet)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseExistingKeySet<'a, P0>(&self, fuseexistingkeys: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetUseExistingKeySet)(::windows::core::Interface::as_raw(self), fuseexistingkeys.into()).ok()
    }
    pub unsafe fn GenKeyFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GenKeyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetGenKeyFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetGenKeyFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRequestCert(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.DeleteRequestCert)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDeleteRequestCert<'a, P0>(&self, fdelete: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetDeleteRequestCert)(::windows::core::Interface::as_raw(self), fdelete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToCSP(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.WriteCertToCSP)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToCSP<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetWriteCertToCSP)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SPCFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.SPCFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSPCFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetSPCFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PVKFileName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.PVKFileName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPVKFileName<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetPVKFileName)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HashAlgorithm(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.HashAlgorithm)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHashAlgorithm<'a, P0>(&self, bstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetHashAlgorithm)(::windows::core::Interface::as_raw(self), bstr.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addCertTypeToRequest<'a, P0>(&self, certtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.addCertTypeToRequest)(::windows::core::Interface::as_raw(self), certtype.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addNameValuePairToSignature<'a, P0, P1>(&self, name: P0, value: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.addNameValuePairToSignature)(::windows::core::Interface::as_raw(self), name.into().abi(), value.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToUserDS(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.WriteCertToUserDS)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToUserDS<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetWriteCertToUserDS)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableT61DNEncoding(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.EnableT61DNEncoding)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableT61DNEncoding<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetEnableT61DNEncoding)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InstallPKCS7<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InstallPKCS7)(::windows::core::Interface::as_raw(self), pkcs7.into().abi()).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetSupportedKeySpec(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetSupportedKeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKeyLen<'a, P0, P1>(&self, fmin: P0, fexchange: P1) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetKeyLen)(::windows::core::Interface::as_raw(self), fmin.into(), fexchange.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn EnumAlgs(&self, dwindex: i32, algclass: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.EnumAlgs)(::windows::core::Interface::as_raw(self), dwindex, algclass, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAlgName(&self, algid: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetAlgName)(::windows::core::Interface::as_raw(self), algid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetReuseHardwareKeyIfUnableToGenNew<'a, P0>(&self, freusehardwarekeyifunabletogennew: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetReuseHardwareKeyIfUnableToGenNew)(::windows::core::Interface::as_raw(self), freusehardwarekeyifunabletogennew.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReuseHardwareKeyIfUnableToGenNew(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ReuseHardwareKeyIfUnableToGenNew)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetHashAlgID(&self, hashalgid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetHashAlgID)(::windows::core::Interface::as_raw(self), hashalgid).ok()
    }
    pub unsafe fn HashAlgID(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.HashAlgID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLimitExchangeKeyToEncipherment<'a, P0>(&self, flimitexchangekeytoencipherment: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetLimitExchangeKeyToEncipherment)(::windows::core::Interface::as_raw(self), flimitexchangekeytoencipherment.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LimitExchangeKeyToEncipherment(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.LimitExchangeKeyToEncipherment)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSMIMECapabilities<'a, P0>(&self, fenablesmimecapabilities: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetEnableSMIMECapabilities)(::windows::core::Interface::as_raw(self), fenablesmimecapabilities.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableSMIMECapabilities(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.EnableSMIMECapabilities)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPrivateKeyArchiveCertificate<'a, P0>(&self, bstrcert: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetPrivateKeyArchiveCertificate)(::windows::core::Interface::as_raw(self), bstrcert.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PrivateKeyArchiveCertificate(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).PrivateKeyArchiveCertificate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetThumbPrint<'a, P0>(&self, bstrthumbprint: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetThumbPrint)(::windows::core::Interface::as_raw(self), bstrthumbprint.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ThumbPrint(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ThumbPrint)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn binaryToString<'a, P0>(&self, flags: i32, strbinary: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).binaryToString)(::windows::core::Interface::as_raw(self), flags, strbinary.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn stringToBinary<'a, P0>(&self, flags: i32, strencoded: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).stringToBinary)(::windows::core::Interface::as_raw(self), flags, strencoded.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addExtensionToRequest<'a, P0, P1>(&self, flags: i32, strname: P0, strvalue: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).addExtensionToRequest)(::windows::core::Interface::as_raw(self), flags, strname.into().abi(), strvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addAttributeToRequest<'a, P0, P1>(&self, flags: i32, strname: P0, strvalue: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).addAttributeToRequest)(::windows::core::Interface::as_raw(self), flags, strname.into().abi(), strvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addNameValuePairToRequest<'a, P0, P1>(&self, flags: i32, strname: P0, strvalue: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).addNameValuePairToRequest)(::windows::core::Interface::as_raw(self), flags, strname.into().abi(), strvalue.into().abi()).ok()
    }
    pub unsafe fn resetExtensions(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).resetExtensions)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn resetAttributes(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).resetAttributes)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createRequest<'a, P0, P1>(&self, flags: CERT_CREATE_REQUEST_FLAGS, strdnname: P0, usage: P1) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).createRequest)(::windows::core::Interface::as_raw(self), flags, strdnname.into().abi(), usage.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createFileRequest<'a, P0, P1, P2>(&self, flags: CERT_CREATE_REQUEST_FLAGS, strdnname: P0, strusage: P1, strrequestfilename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).createFileRequest)(::windows::core::Interface::as_raw(self), flags, strdnname.into().abi(), strusage.into().abi(), strrequestfilename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptResponse<'a, P0>(&self, strresponse: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).acceptResponse)(::windows::core::Interface::as_raw(self), strresponse.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn acceptFileResponse<'a, P0>(&self, strresponsefilename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).acceptFileResponse)(::windows::core::Interface::as_raw(self), strresponsefilename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertFromResponse<'a, P0>(&self, strresponse: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).getCertFromResponse)(::windows::core::Interface::as_raw(self), strresponse.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertFromFileResponse<'a, P0>(&self, strresponsefilename: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).getCertFromFileResponse)(::windows::core::Interface::as_raw(self), strresponsefilename.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createPFX<'a, P0>(&self, strpassword: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).createPFX)(::windows::core::Interface::as_raw(self), strpassword.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn createFilePFX<'a, P0, P1>(&self, strpassword: P0, strpfxfilename: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).createFilePFX)(::windows::core::Interface::as_raw(self), strpassword.into().abi(), strpfxfilename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn setPendingRequestInfo<'a, P0, P1, P2>(&self, lrequestid: i32, strcadns: P0, strcaname: P1, strfriendlyname: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).setPendingRequestInfo)(::windows::core::Interface::as_raw(self), lrequestid, strcadns.into().abi(), strcaname.into().abi(), strfriendlyname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn enumPendingRequest(&self, lindex: i32, ldesiredproperty: PENDING_REQUEST_DESIRED_PROPERTY) -> ::windows::core::Result<super::super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).enumPendingRequest)(::windows::core::Interface::as_raw(self), lindex, ldesiredproperty, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn removePendingRequest<'a, P0>(&self, strthumbprint: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).removePendingRequest)(::windows::core::Interface::as_raw(self), strthumbprint.into().abi()).ok()
    }
    pub unsafe fn GetKeyLenEx(&self, lsizespec: XEKL_KEYSIZE, lkeyspec: XEKL_KEYSPEC) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetKeyLenEx)(::windows::core::Interface::as_raw(self), lsizespec, lkeyspec, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InstallPKCS7Ex<'a, P0>(&self, pkcs7: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).InstallPKCS7Ex)(::windows::core::Interface::as_raw(self), pkcs7.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addCertTypeToRequestEx<'a, P0, P1>(&self, ltype: ADDED_CERT_TYPE, bstroidorname: P0, lmajorversion: i32, fminorversion: P1, lminorversion: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).addCertTypeToRequestEx)(::windows::core::Interface::as_raw(self), ltype, bstroidorname.into().abi(), lmajorversion, fminorversion.into(), lminorversion).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getProviderType<'a, P0>(&self, strprovname: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).getProviderType)(::windows::core::Interface::as_raw(self), strprovname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSignerCertificate<'a, P0>(&self, bstrcert: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetSignerCertificate)(::windows::core::Interface::as_raw(self), bstrcert.into().abi()).ok()
    }
    pub unsafe fn SetClientId(&self, lclientid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetClientId)(::windows::core::Interface::as_raw(self), lclientid).ok()
    }
    pub unsafe fn ClientId(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ClientId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn addBlobPropertyToCertificate<'a, P0>(&self, lpropertyid: i32, lreserved: i32, bstrproperty: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).addBlobPropertyToCertificate)(::windows::core::Interface::as_raw(self), lpropertyid, lreserved, bstrproperty.into().abi()).ok()
    }
    pub unsafe fn resetBlobProperties(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).resetBlobProperties)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIncludeSubjectKeyID<'a, P0>(&self, finclude: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetIncludeSubjectKeyID)(::windows::core::Interface::as_raw(self), finclude.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludeSubjectKeyID(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IncludeSubjectKeyID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BOOL>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll4> for ::windows::core::IUnknown {
    fn from(value: ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll4> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll4> for ::windows::core::IUnknown {
    fn from(value: &ICEnroll4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll4> for super::super::super::System::Com::IDispatch {
    fn from(value: ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll4> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll4> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICEnroll4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll4> for ICEnroll {
    fn from(value: ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll4> for &'a ICEnroll {
    fn from(value: &'a ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll4> for ICEnroll {
    fn from(value: &ICEnroll4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll4> for ICEnroll2 {
    fn from(value: ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll4> for &'a ICEnroll2 {
    fn from(value: &'a ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll4> for ICEnroll2 {
    fn from(value: &ICEnroll4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICEnroll4> for ICEnroll3 {
    fn from(value: ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICEnroll4> for &'a ICEnroll3 {
    fn from(value: &'a ICEnroll4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICEnroll4> for ICEnroll3 {
    fn from(value: &ICEnroll4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICEnroll4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICEnroll4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICEnroll4 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICEnroll4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICEnroll4").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICEnroll4 {
    type Vtable = ICEnroll4_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc1f1188a_2eb5_4a80_841b_7e729a356d90);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICEnroll4_Vtbl {
    pub base__: ICEnroll3_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetPrivateKeyArchiveCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcert: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetPrivateKeyArchiveCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub PrivateKeyArchiveCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcert: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PrivateKeyArchiveCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetThumbPrint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrthumbprint: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetThumbPrint: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ThumbPrint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrthumbprint: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ThumbPrint: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub binaryToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrencoded: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    binaryToString: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub stringToBinary: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, strencoded: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    stringToBinary: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub addExtensionToRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addExtensionToRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub addAttributeToRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addAttributeToRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub addNameValuePairToRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addNameValuePairToRequest: usize,
    pub resetExtensions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub resetAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub createRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: CERT_CREATE_REQUEST_FLAGS, strdnname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, usage: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrrequest: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    createRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub createFileRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: CERT_CREATE_REQUEST_FLAGS, strdnname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strusage: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strrequestfilename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    createFileRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub acceptResponse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strresponse: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    acceptResponse: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub acceptFileResponse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strresponsefilename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    acceptFileResponse: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub getCertFromResponse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strresponse: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrcert: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    getCertFromResponse: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub getCertFromFileResponse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strresponsefilename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrcert: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    getCertFromFileResponse: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub createPFX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpassword: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrpfx: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    createPFX: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub createFilePFX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpassword: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strpfxfilename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    createFilePFX: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub setPendingRequestInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lrequestid: i32, strcadns: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strcaname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strfriendlyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    setPendingRequestInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub enumPendingRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, ldesiredproperty: PENDING_REQUEST_DESIRED_PROPERTY, pvarproperty: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    enumPendingRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub removePendingRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strthumbprint: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    removePendingRequest: usize,
    pub GetKeyLenEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsizespec: XEKL_KEYSIZE, lkeyspec: XEKL_KEYSPEC, pdwkeysize: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub InstallPKCS7Ex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkcs7: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, plcertinstalled: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InstallPKCS7Ex: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub addCertTypeToRequestEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ltype: ADDED_CERT_TYPE, bstroidorname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, lmajorversion: i32, fminorversion: super::super::super::Foundation::BOOL, lminorversion: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addCertTypeToRequestEx: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub getProviderType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strprovname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, plprovtype: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    getProviderType: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSignerCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcert: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSignerCertificate: usize,
    pub SetClientId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lclientid: i32) -> ::windows::core::HRESULT,
    pub ClientId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plclientid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub addBlobPropertyToCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpropertyid: i32, lreserved: i32, bstrproperty: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    addBlobPropertyToCertificate: usize,
    pub resetBlobProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetIncludeSubjectKeyID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, finclude: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetIncludeSubjectKeyID: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IncludeSubjectKeyID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfinclude: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IncludeSubjectKeyID: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ICF_ALLOWFOREIGN: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
pub const ICF_EXISTINGROW: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertAdmin(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertAdmin {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsValidCertificate<'a, P0, P1>(&self, strconfig: P0, strserialnumber: P1) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsValidCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strserialnumber.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetRevocationReason(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRevocationReason)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RevokeCertificate<'a, P0, P1>(&self, strconfig: P0, strserialnumber: P1, reason: i32, date: f64) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).RevokeCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strserialnumber.into().abi(), reason, date).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestAttributes<'a, P0, P1>(&self, strconfig: P0, requestid: i32, strattributes: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetRequestAttributes)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strattributes.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetCertificateExtension<'a, P0, P1>(&self, strconfig: P0, requestid: i32, strextensionname: P1, r#type: CERT_PROPERTY_TYPE, flags: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCertificateExtension)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strextensionname.into().abi(), r#type, flags, ::core::mem::transmute(pvarvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DenyRequest<'a, P0>(&self, strconfig: P0, requestid: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DenyRequest)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ResubmitRequest<'a, P0>(&self, strconfig: P0, requestid: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ResubmitRequest)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PublishCRL<'a, P0>(&self, strconfig: P0, date: f64) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).PublishCRL)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), date).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCRL<'a, P0>(&self, strconfig: P0, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCRL)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ImportCertificate<'a, P0, P1>(&self, strconfig: P0, strcertificate: P1, flags: CERT_IMPORT_FLAGS) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ImportCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strcertificate.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertAdmin> for ::windows::core::IUnknown {
    fn from(value: ICertAdmin) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertAdmin> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertAdmin) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertAdmin> for ::windows::core::IUnknown {
    fn from(value: &ICertAdmin) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertAdmin> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertAdmin) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertAdmin> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertAdmin) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertAdmin> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertAdmin) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertAdmin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertAdmin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertAdmin {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertAdmin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertAdmin").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertAdmin {
    type Vtable = ICertAdmin_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x34df6950_7fb6_11d0_8817_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertAdmin_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub IsValidCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strserialnumber: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pdisposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsValidCertificate: usize,
    pub GetRevocationReason: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, preason: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RevokeCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strserialnumber: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, reason: i32, date: f64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RevokeCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRequestAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32, strattributes: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRequestAttributes: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetCertificateExtension: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32, strextensionname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, r#type: CERT_PROPERTY_TYPE, flags: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetCertificateExtension: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DenyRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DenyRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ResubmitRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32, pdisposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ResubmitRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub PublishCRL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, date: f64) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PublishCRL: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCRL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: i32, pstrcrl: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCRL: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ImportCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strcertificate: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: CERT_IMPORT_FLAGS, prequestid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ImportCertificate: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertAdmin2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertAdmin2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsValidCertificate<'a, P0, P1>(&self, strconfig: P0, strserialnumber: P1) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsValidCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strserialnumber.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetRevocationReason(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetRevocationReason)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RevokeCertificate<'a, P0, P1>(&self, strconfig: P0, strserialnumber: P1, reason: i32, date: f64) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RevokeCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strserialnumber.into().abi(), reason, date).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRequestAttributes<'a, P0, P1>(&self, strconfig: P0, requestid: i32, strattributes: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRequestAttributes)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strattributes.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetCertificateExtension<'a, P0, P1>(&self, strconfig: P0, requestid: i32, strextensionname: P1, r#type: CERT_PROPERTY_TYPE, flags: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCertificateExtension)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strextensionname.into().abi(), r#type, flags, ::core::mem::transmute(pvarvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DenyRequest<'a, P0>(&self, strconfig: P0, requestid: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.DenyRequest)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ResubmitRequest<'a, P0>(&self, strconfig: P0, requestid: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ResubmitRequest)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PublishCRL<'a, P0>(&self, strconfig: P0, date: f64) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.PublishCRL)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), date).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCRL<'a, P0>(&self, strconfig: P0, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCRL)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ImportCertificate<'a, P0, P1>(&self, strconfig: P0, strcertificate: P1, flags: CERT_IMPORT_FLAGS) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ImportCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strcertificate.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PublishCRLs<'a, P0>(&self, strconfig: P0, date: f64, crlflags: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).PublishCRLs)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), date, crlflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCAProperty<'a, P0>(&self, strconfig: P0, propid: i32, propindex: i32, proptype: i32, flags: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAProperty)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, propindex, proptype, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetCAProperty<'a, P0>(&self, strconfig: P0, propid: i32, propindex: i32, proptype: CERT_PROPERTY_TYPE, pvarpropertyvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCAProperty)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, propindex, proptype, ::core::mem::transmute(pvarpropertyvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCAPropertyFlags<'a, P0>(&self, strconfig: P0, propid: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAPropertyFlags)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCAPropertyDisplayName<'a, P0>(&self, strconfig: P0, propid: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAPropertyDisplayName)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetArchivedKey<'a, P0>(&self, strconfig: P0, requestid: i32, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetArchivedKey)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetConfigEntry<'a, P0, P1, P2>(&self, strconfig: P0, strnodepath: P1, strentryname: P2) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetConfigEntry)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strnodepath.into().abi(), strentryname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetConfigEntry<'a, P0, P1, P2>(&self, strconfig: P0, strnodepath: P1, strentryname: P2, pvarentry: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetConfigEntry)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strnodepath.into().abi(), strentryname.into().abi(), ::core::mem::transmute(pvarentry)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ImportKey<'a, P0, P1, P2>(&self, strconfig: P0, requestid: i32, strcerthash: P1, flags: CERT_IMPORT_FLAGS, strkey: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).ImportKey)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strcerthash.into().abi(), flags, strkey.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMyRoles<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<CERTADMIN_GET_ROLES_FLAGS>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetMyRoles)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTADMIN_GET_ROLES_FLAGS>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRow<'a, P0>(&self, strconfig: P0, flags: CERT_DELETE_ROW_FLAGS, date: f64, table: CVRC_TABLE, rowid: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).DeleteRow)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), flags, date, table, rowid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertAdmin2> for ::windows::core::IUnknown {
    fn from(value: ICertAdmin2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertAdmin2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertAdmin2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertAdmin2> for ::windows::core::IUnknown {
    fn from(value: &ICertAdmin2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertAdmin2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertAdmin2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertAdmin2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertAdmin2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertAdmin2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertAdmin2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertAdmin2> for ICertAdmin {
    fn from(value: ICertAdmin2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertAdmin2> for &'a ICertAdmin {
    fn from(value: &'a ICertAdmin2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertAdmin2> for ICertAdmin {
    fn from(value: &ICertAdmin2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertAdmin2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertAdmin2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertAdmin2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertAdmin2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertAdmin2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertAdmin2 {
    type Vtable = ICertAdmin2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf7c3ac41_b8ce_4fb4_aa58_3d1dc0e36b39);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertAdmin2_Vtbl {
    pub base__: ICertAdmin_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub PublishCRLs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, date: f64, crlflags: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PublishCRLs: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCAProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, propindex: i32, proptype: i32, flags: i32, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCAProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetCAProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, propindex: i32, proptype: CERT_PROPERTY_TYPE, pvarpropertyvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetCAProperty: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCAPropertyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, ppropflags: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCAPropertyFlags: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCAPropertyDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, pstrdisplayname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCAPropertyDisplayName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetArchivedKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32, flags: i32, pstrarchivedkey: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetArchivedKey: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetConfigEntry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strnodepath: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strentryname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pvarentry: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetConfigEntry: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetConfigEntry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strnodepath: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strentryname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pvarentry: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetConfigEntry: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ImportKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32, strcerthash: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: CERT_IMPORT_FLAGS, strkey: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ImportKey: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetMyRoles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, proles: *mut CERTADMIN_GET_ROLES_FLAGS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetMyRoles: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DeleteRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: CERT_DELETE_ROW_FLAGS, date: f64, table: CVRC_TABLE, rowid: i32, pcdeleted: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DeleteRow: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertConfig(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertConfig {
    pub unsafe fn Reset(&self, index: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Next(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Next)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetField<'a, P0>(&self, strfieldname: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetField)(::windows::core::Interface::as_raw(self), strfieldname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetConfig(&self, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetConfig)(::windows::core::Interface::as_raw(self), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertConfig> for ::windows::core::IUnknown {
    fn from(value: ICertConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertConfig> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertConfig> for ::windows::core::IUnknown {
    fn from(value: &ICertConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertConfig> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertConfig> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertConfig> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertConfig {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertConfig").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertConfig {
    type Vtable = ICertConfig_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x372fce34_4324_11d0_8810_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertConfig_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pcount: *mut i32) -> ::windows::core::HRESULT,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetField: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strfieldname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrout: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetField: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetConfig: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, pstrout: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetConfig: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertConfig2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertConfig2 {
    pub unsafe fn Reset(&self, index: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Next(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Next)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetField<'a, P0>(&self, strfieldname: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetField)(::windows::core::Interface::as_raw(self), strfieldname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetConfig(&self, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetConfig)(::windows::core::Interface::as_raw(self), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSharedFolder<'a, P0>(&self, strsharedfolder: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetSharedFolder)(::windows::core::Interface::as_raw(self), strsharedfolder.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertConfig2> for ::windows::core::IUnknown {
    fn from(value: ICertConfig2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertConfig2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertConfig2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertConfig2> for ::windows::core::IUnknown {
    fn from(value: &ICertConfig2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertConfig2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertConfig2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertConfig2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertConfig2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertConfig2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertConfig2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertConfig2> for ICertConfig {
    fn from(value: ICertConfig2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertConfig2> for &'a ICertConfig {
    fn from(value: &'a ICertConfig2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertConfig2> for ICertConfig {
    fn from(value: &ICertConfig2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertConfig2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertConfig2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertConfig2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertConfig2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertConfig2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertConfig2 {
    type Vtable = ICertConfig2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7a18edde_7e78_4163_8ded_78e2c9cee924);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertConfig2_Vtbl {
    pub base__: ICertConfig_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSharedFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strsharedfolder: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSharedFolder: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeAltName(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeAltName {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetNameCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNameCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetNameChoice(&self, nameindex: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNameChoice)(::windows::core::Interface::as_raw(self), nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self, nameindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Reset(&self, namecount: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self), namecount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNameEntry<'a, P0>(&self, nameindex: i32, namechoice: CERT_ALT_NAME, strname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetNameEntry)(::windows::core::Interface::as_raw(self), nameindex, namechoice, strname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeAltName> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeAltName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeAltName> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeAltName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeAltName> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeAltName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeAltName> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeAltName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeAltName> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeAltName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeAltName> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeAltName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeAltName {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeAltName {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeAltName {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeAltName {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeAltName").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeAltName {
    type Vtable = ICertEncodeAltName_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c9a8c70_1271_11d1_9bd4_00c04fb683fa);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeAltName_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Decode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Decode: usize,
    pub GetNameCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnamecount: *mut i32) -> ::windows::core::HRESULT,
    pub GetNameChoice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nameindex: i32, pnamechoice: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nameindex: i32, pstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetName: usize,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, namecount: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetNameEntry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nameindex: i32, namechoice: CERT_ALT_NAME, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetNameEntry: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Encode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Encode: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeAltName2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeAltName2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetNameCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetNameCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetNameChoice(&self, nameindex: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetNameChoice)(::windows::core::Interface::as_raw(self), nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self, nameindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetName)(::windows::core::Interface::as_raw(self), nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Reset(&self, namecount: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self), namecount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNameEntry<'a, P0>(&self, nameindex: i32, namechoice: CERT_ALT_NAME, strname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetNameEntry)(::windows::core::Interface::as_raw(self), nameindex, namechoice, strname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeBlob<'a, P0>(&self, strencodeddata: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DecodeBlob)(::windows::core::Interface::as_raw(self), strencodeddata.into().abi(), encoding).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeBlob(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EncodeBlob)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetNameBlob(&self, nameindex: i32, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNameBlob)(::windows::core::Interface::as_raw(self), nameindex, encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNameEntryBlob<'a, P0>(&self, nameindex: i32, namechoice: i32, strname: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetNameEntryBlob)(::windows::core::Interface::as_raw(self), nameindex, namechoice, strname.into().abi(), encoding).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeAltName2> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeAltName2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeAltName2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeAltName2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeAltName2> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeAltName2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeAltName2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeAltName2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeAltName2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeAltName2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeAltName2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeAltName2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeAltName2> for ICertEncodeAltName {
    fn from(value: ICertEncodeAltName2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeAltName2> for &'a ICertEncodeAltName {
    fn from(value: &'a ICertEncodeAltName2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeAltName2> for ICertEncodeAltName {
    fn from(value: &ICertEncodeAltName2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeAltName2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeAltName2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeAltName2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeAltName2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeAltName2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeAltName2 {
    type Vtable = ICertEncodeAltName2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf67fe177_5ef1_4535_b4ce_29df15e2e0c3);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeAltName2_Vtbl {
    pub base__: ICertEncodeAltName_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DecodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EncodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrencodeddata: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EncodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetNameBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nameindex: i32, encoding: EncodingType, pstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetNameBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetNameEntryBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nameindex: i32, namechoice: i32, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetNameEntryBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeBitString(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeBitString {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetBitCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBitCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBitString(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBitString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode<'a, P0>(&self, bitcount: i32, strbitstring: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Encode)(::windows::core::Interface::as_raw(self), bitcount, strbitstring.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeBitString> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeBitString) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeBitString> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeBitString) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeBitString> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeBitString) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeBitString> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeBitString) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeBitString> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeBitString) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeBitString> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeBitString) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeBitString {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeBitString {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeBitString {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeBitString {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeBitString").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeBitString {
    type Vtable = ICertEncodeBitString_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6db525be_1278_11d1_9bd4_00c04fb683fa);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeBitString_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Decode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Decode: usize,
    pub GetBitCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbitcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetBitString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrbitstring: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetBitString: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Encode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitcount: i32, strbitstring: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Encode: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeBitString2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeBitString2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetBitCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetBitCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBitString(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetBitString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode<'a, P0>(&self, bitcount: i32, strbitstring: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Encode)(::windows::core::Interface::as_raw(self), bitcount, strbitstring.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeBlob<'a, P0>(&self, strencodeddata: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DecodeBlob)(::windows::core::Interface::as_raw(self), strencodeddata.into().abi(), encoding).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeBlob<'a, P0>(&self, bitcount: i32, strbitstring: P0, encodingin: EncodingType, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EncodeBlob)(::windows::core::Interface::as_raw(self), bitcount, strbitstring.into().abi(), encodingin, encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBitStringBlob(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBitStringBlob)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeBitString2> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeBitString2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeBitString2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeBitString2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeBitString2> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeBitString2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeBitString2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeBitString2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeBitString2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeBitString2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeBitString2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeBitString2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeBitString2> for ICertEncodeBitString {
    fn from(value: ICertEncodeBitString2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeBitString2> for &'a ICertEncodeBitString {
    fn from(value: &'a ICertEncodeBitString2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeBitString2> for ICertEncodeBitString {
    fn from(value: &ICertEncodeBitString2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeBitString2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeBitString2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeBitString2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeBitString2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeBitString2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeBitString2 {
    type Vtable = ICertEncodeBitString2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe070d6e7_23ef_4dd2_8242_ebd9c928cb30);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeBitString2_Vtbl {
    pub base__: ICertEncodeBitString_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DecodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EncodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitcount: i32, strbitstring: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encodingin: EncodingType, encoding: EncodingType, pstrencodeddata: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EncodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetBitStringBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrbitstring: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetBitStringBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeCRLDistInfo(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeCRLDistInfo {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetDistPointCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDistPointCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetNameCount(&self, distpointindex: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNameCount)(::windows::core::Interface::as_raw(self), distpointindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetNameChoice(&self, distpointindex: i32, nameindex: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNameChoice)(::windows::core::Interface::as_raw(self), distpointindex, nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self, distpointindex: i32, nameindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), distpointindex, nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Reset(&self, distpointcount: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self), distpointcount).ok()
    }
    pub unsafe fn SetNameCount(&self, distpointindex: i32, namecount: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNameCount)(::windows::core::Interface::as_raw(self), distpointindex, namecount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNameEntry<'a, P0>(&self, distpointindex: i32, nameindex: i32, namechoice: CERT_ALT_NAME, strname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetNameEntry)(::windows::core::Interface::as_raw(self), distpointindex, nameindex, namechoice, strname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeCRLDistInfo> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeCRLDistInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeCRLDistInfo> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeCRLDistInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeCRLDistInfo> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeCRLDistInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeCRLDistInfo> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeCRLDistInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeCRLDistInfo> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeCRLDistInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeCRLDistInfo> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeCRLDistInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeCRLDistInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeCRLDistInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeCRLDistInfo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeCRLDistInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeCRLDistInfo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeCRLDistInfo {
    type Vtable = ICertEncodeCRLDistInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x01958640_bbff_11d0_8825_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeCRLDistInfo_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Decode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Decode: usize,
    pub GetDistPointCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdistpointcount: *mut i32) -> ::windows::core::HRESULT,
    pub GetNameCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, distpointindex: i32, pnamecount: *mut i32) -> ::windows::core::HRESULT,
    pub GetNameChoice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, distpointindex: i32, nameindex: i32, pnamechoice: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, distpointindex: i32, nameindex: i32, pstrname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetName: usize,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, distpointcount: i32) -> ::windows::core::HRESULT,
    pub SetNameCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, distpointindex: i32, namecount: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetNameEntry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, distpointindex: i32, nameindex: i32, namechoice: CERT_ALT_NAME, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetNameEntry: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Encode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Encode: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeCRLDistInfo2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeCRLDistInfo2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetDistPointCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetDistPointCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetNameCount(&self, distpointindex: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetNameCount)(::windows::core::Interface::as_raw(self), distpointindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetNameChoice(&self, distpointindex: i32, nameindex: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetNameChoice)(::windows::core::Interface::as_raw(self), distpointindex, nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self, distpointindex: i32, nameindex: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetName)(::windows::core::Interface::as_raw(self), distpointindex, nameindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Reset(&self, distpointcount: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self), distpointcount).ok()
    }
    pub unsafe fn SetNameCount(&self, distpointindex: i32, namecount: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetNameCount)(::windows::core::Interface::as_raw(self), distpointindex, namecount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNameEntry<'a, P0>(&self, distpointindex: i32, nameindex: i32, namechoice: CERT_ALT_NAME, strname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetNameEntry)(::windows::core::Interface::as_raw(self), distpointindex, nameindex, namechoice, strname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeBlob<'a, P0>(&self, strencodeddata: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DecodeBlob)(::windows::core::Interface::as_raw(self), strencodeddata.into().abi(), encoding).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeBlob(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EncodeBlob)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeCRLDistInfo2> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeCRLDistInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeCRLDistInfo2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeCRLDistInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeCRLDistInfo2> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeCRLDistInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeCRLDistInfo2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeCRLDistInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeCRLDistInfo2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeCRLDistInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeCRLDistInfo2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeCRLDistInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeCRLDistInfo2> for ICertEncodeCRLDistInfo {
    fn from(value: ICertEncodeCRLDistInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeCRLDistInfo2> for &'a ICertEncodeCRLDistInfo {
    fn from(value: &'a ICertEncodeCRLDistInfo2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeCRLDistInfo2> for ICertEncodeCRLDistInfo {
    fn from(value: &ICertEncodeCRLDistInfo2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeCRLDistInfo2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeCRLDistInfo2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeCRLDistInfo2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeCRLDistInfo2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeCRLDistInfo2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeCRLDistInfo2 {
    type Vtable = ICertEncodeCRLDistInfo2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4275d4b_3e30_446f_ad36_09d03120b078);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeCRLDistInfo2_Vtbl {
    pub base__: ICertEncodeCRLDistInfo_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DecodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EncodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrencodeddata: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EncodeBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeDateArray(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeDateArray {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetValue(&self, index: i32) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetValue)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
    pub unsafe fn Reset(&self, count: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn SetValue(&self, index: i32, value: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetValue)(::windows::core::Interface::as_raw(self), index, value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeDateArray> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeDateArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeDateArray> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeDateArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeDateArray> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeDateArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeDateArray> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeDateArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeDateArray> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeDateArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeDateArray> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeDateArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeDateArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeDateArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeDateArray {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeDateArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeDateArray").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeDateArray {
    type Vtable = ICertEncodeDateArray_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2f9469a0_a470_11d0_8821_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeDateArray_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Decode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Decode: usize,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *mut i32) -> ::windows::core::HRESULT,
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pvalue: *mut f64) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: i32) -> ::windows::core::HRESULT,
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, value: f64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Encode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Encode: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeDateArray2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeDateArray2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetValue(&self, index: i32) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetValue)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
    pub unsafe fn Reset(&self, count: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn SetValue(&self, index: i32, value: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetValue)(::windows::core::Interface::as_raw(self), index, value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeBlob<'a, P0>(&self, strencodeddata: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DecodeBlob)(::windows::core::Interface::as_raw(self), strencodeddata.into().abi(), encoding).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeBlob(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EncodeBlob)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeDateArray2> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeDateArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeDateArray2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeDateArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeDateArray2> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeDateArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeDateArray2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeDateArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeDateArray2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeDateArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeDateArray2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeDateArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeDateArray2> for ICertEncodeDateArray {
    fn from(value: ICertEncodeDateArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeDateArray2> for &'a ICertEncodeDateArray {
    fn from(value: &'a ICertEncodeDateArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeDateArray2> for ICertEncodeDateArray {
    fn from(value: &ICertEncodeDateArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeDateArray2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeDateArray2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeDateArray2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeDateArray2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeDateArray2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeDateArray2 {
    type Vtable = ICertEncodeDateArray2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x99a4edb5_2b8e_448d_bf95_bba8d7789dc8);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeDateArray2_Vtbl {
    pub base__: ICertEncodeDateArray_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DecodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EncodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrencodeddata: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EncodeBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeLongArray(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeLongArray {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetValue(&self, index: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetValue)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Reset(&self, count: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn SetValue(&self, index: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetValue)(::windows::core::Interface::as_raw(self), index, value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeLongArray> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeLongArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeLongArray> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeLongArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeLongArray> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeLongArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeLongArray> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeLongArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeLongArray> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeLongArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeLongArray> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeLongArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeLongArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeLongArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeLongArray {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeLongArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeLongArray").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeLongArray {
    type Vtable = ICertEncodeLongArray_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x15e2f230_a0a2_11d0_8821_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeLongArray_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Decode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Decode: usize,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *mut i32) -> ::windows::core::HRESULT,
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: i32) -> ::windows::core::HRESULT,
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, value: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Encode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Encode: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeLongArray2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeLongArray2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetValue(&self, index: i32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetValue)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Reset(&self, count: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn SetValue(&self, index: i32, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetValue)(::windows::core::Interface::as_raw(self), index, value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeBlob<'a, P0>(&self, strencodeddata: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DecodeBlob)(::windows::core::Interface::as_raw(self), strencodeddata.into().abi(), encoding).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeBlob(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EncodeBlob)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeLongArray2> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeLongArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeLongArray2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeLongArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeLongArray2> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeLongArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeLongArray2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeLongArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeLongArray2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeLongArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeLongArray2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeLongArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeLongArray2> for ICertEncodeLongArray {
    fn from(value: ICertEncodeLongArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeLongArray2> for &'a ICertEncodeLongArray {
    fn from(value: &'a ICertEncodeLongArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeLongArray2> for ICertEncodeLongArray {
    fn from(value: &ICertEncodeLongArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeLongArray2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeLongArray2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeLongArray2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeLongArray2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeLongArray2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeLongArray2 {
    type Vtable = ICertEncodeLongArray2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4efde84a_bd9b_4fc2_a108_c347d478840f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeLongArray2_Vtbl {
    pub base__: ICertEncodeLongArray_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DecodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EncodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrencodeddata: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EncodeBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeStringArray(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeStringArray {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetStringType(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetStringType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValue(&self, index: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetValue)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Reset(&self, count: i32, stringtype: super::CERT_RDN_ATTR_VALUE_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self), count, stringtype).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValue<'a, P0>(&self, index: i32, str: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetValue)(::windows::core::Interface::as_raw(self), index, str.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeStringArray> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeStringArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeStringArray> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeStringArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeStringArray> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeStringArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeStringArray> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeStringArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeStringArray> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeStringArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeStringArray> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeStringArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeStringArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeStringArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeStringArray {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeStringArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeStringArray").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeStringArray {
    type Vtable = ICertEncodeStringArray_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12a88820_7494_11d0_8816_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeStringArray_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Decode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strbinary: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Decode: usize,
    pub GetStringType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstringtype: *mut i32) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pstr: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetValue: usize,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: i32, stringtype: super::CERT_RDN_ATTR_VALUE_TYPE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, str: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetValue: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Encode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrbinary: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Encode: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertEncodeStringArray2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertEncodeStringArray2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Decode<'a, P0>(&self, strbinary: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Decode)(::windows::core::Interface::as_raw(self), strbinary.into().abi()).ok()
    }
    pub unsafe fn GetStringType(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetStringType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetValue(&self, index: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetValue)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Reset(&self, count: i32, stringtype: super::CERT_RDN_ATTR_VALUE_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Reset)(::windows::core::Interface::as_raw(self), count, stringtype).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValue<'a, P0>(&self, index: i32, str: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValue)(::windows::core::Interface::as_raw(self), index, str.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Encode(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Encode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecodeBlob<'a, P0>(&self, strencodeddata: P0, encoding: EncodingType) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).DecodeBlob)(::windows::core::Interface::as_raw(self), strencodeddata.into().abi(), encoding).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EncodeBlob(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EncodeBlob)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeStringArray2> for ::windows::core::IUnknown {
    fn from(value: ICertEncodeStringArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeStringArray2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertEncodeStringArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeStringArray2> for ::windows::core::IUnknown {
    fn from(value: &ICertEncodeStringArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeStringArray2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertEncodeStringArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeStringArray2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertEncodeStringArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeStringArray2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertEncodeStringArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertEncodeStringArray2> for ICertEncodeStringArray {
    fn from(value: ICertEncodeStringArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertEncodeStringArray2> for &'a ICertEncodeStringArray {
    fn from(value: &'a ICertEncodeStringArray2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertEncodeStringArray2> for ICertEncodeStringArray {
    fn from(value: &ICertEncodeStringArray2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertEncodeStringArray2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertEncodeStringArray2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertEncodeStringArray2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertEncodeStringArray2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertEncodeStringArray2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertEncodeStringArray2 {
    type Vtable = ICertEncodeStringArray2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9c680d93_9b7d_4e95_9018_4ffe10ba5ada);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertEncodeStringArray2_Vtbl {
    pub base__: ICertEncodeStringArray_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DecodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, encoding: EncodingType) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecodeBlob: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EncodeBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrencodeddata: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EncodeBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertExit(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertExit {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<CERT_EXIT_EVENT_MASK>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERT_EXIT_EVENT_MASK>(result__)
    }
    pub unsafe fn Notify(&self, exitevent: i32, context: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Notify)(::windows::core::Interface::as_raw(self), exitevent, context).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertExit> for ::windows::core::IUnknown {
    fn from(value: ICertExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertExit> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertExit> for ::windows::core::IUnknown {
    fn from(value: &ICertExit) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertExit> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertExit> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertExit> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertExit) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertExit {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertExit {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertExit {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertExit {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertExit").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertExit {
    type Vtable = ICertExit_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe19ae1a0_7364_11d0_8816_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertExit_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, peventmask: *mut CERT_EXIT_EVENT_MASK) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, exitevent: i32, context: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrdescription: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDescription: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertExit2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertExit2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<CERT_EXIT_EVENT_MASK>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Initialize)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERT_EXIT_EVENT_MASK>(result__)
    }
    pub unsafe fn Notify(&self, exitevent: i32, context: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Notify)(::windows::core::Interface::as_raw(self), exitevent, context).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetManageModule(&self) -> ::windows::core::Result<ICertManageModule> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetManageModule)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICertManageModule>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertExit2> for ::windows::core::IUnknown {
    fn from(value: ICertExit2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertExit2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertExit2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertExit2> for ::windows::core::IUnknown {
    fn from(value: &ICertExit2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertExit2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertExit2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertExit2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertExit2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertExit2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertExit2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertExit2> for ICertExit {
    fn from(value: ICertExit2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertExit2> for &'a ICertExit {
    fn from(value: &'a ICertExit2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertExit2> for ICertExit {
    fn from(value: &ICertExit2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertExit2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertExit2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertExit2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertExit2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertExit2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertExit2 {
    type Vtable = ICertExit2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0abf484b_d049_464d_a7ed_552e7529b0ff);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertExit2_Vtbl {
    pub base__: ICertExit_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetManageModule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmanagemodule: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetManageModule: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertGetConfig(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertGetConfig {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetConfig(&self, flags: CERT_GET_CONFIG_FLAGS) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetConfig)(::windows::core::Interface::as_raw(self), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertGetConfig> for ::windows::core::IUnknown {
    fn from(value: ICertGetConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertGetConfig> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertGetConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertGetConfig> for ::windows::core::IUnknown {
    fn from(value: &ICertGetConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertGetConfig> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertGetConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertGetConfig> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertGetConfig) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertGetConfig> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertGetConfig) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertGetConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertGetConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertGetConfig {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertGetConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertGetConfig").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertGetConfig {
    type Vtable = ICertGetConfig_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7ea09c0_ce17_11d0_8833_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertGetConfig_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetConfig: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: CERT_GET_CONFIG_FLAGS, pstrout: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetConfig: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertManageModule(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertManageModule {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperty<'a, P0, P1, P2>(&self, strconfig: P0, strstoragelocation: P1, strpropertyname: P2, flags: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetProperty)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strstoragelocation.into().abi(), strpropertyname.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperty<'a, P0, P1, P2>(&self, strconfig: P0, strstoragelocation: P1, strpropertyname: P2, flags: i32, pvarproperty: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetProperty)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strstoragelocation.into().abi(), strpropertyname.into().abi(), flags, ::core::mem::transmute(pvarproperty)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Configure<'a, P0, P1>(&self, strconfig: P0, strstoragelocation: P1, flags: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Configure)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strstoragelocation.into().abi(), flags).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertManageModule> for ::windows::core::IUnknown {
    fn from(value: ICertManageModule) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertManageModule> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertManageModule) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertManageModule> for ::windows::core::IUnknown {
    fn from(value: &ICertManageModule) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertManageModule> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertManageModule) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertManageModule> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertManageModule) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertManageModule> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertManageModule) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertManageModule {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertManageModule {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertManageModule {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertManageModule {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertManageModule").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertManageModule {
    type Vtable = ICertManageModule_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe7d7ad42_bd3d_11d1_9a4d_00c04fc297eb);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertManageModule_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strstoragelocation: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: i32, pvarproperty: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strstoragelocation: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: i32, pvarproperty: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperty: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Configure: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strstoragelocation: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Configure: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPolicy(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPolicy {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), strconfig.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VerifyRequest<'a, P0>(&self, strconfig: P0, context: i32, bnewrequest: i32, flags: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).VerifyRequest)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), context, bnewrequest, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn ShutDown(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ShutDown)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPolicy> for ::windows::core::IUnknown {
    fn from(value: ICertPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPolicy> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPolicy> for ::windows::core::IUnknown {
    fn from(value: &ICertPolicy) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPolicy> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPolicy> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPolicy> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPolicy) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPolicy {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPolicy {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPolicy {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPolicy {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPolicy").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPolicy {
    type Vtable = ICertPolicy_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x38bb5a00_7636_11d0_b413_00a0c91bbf8c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPolicy_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub VerifyRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, context: i32, bnewrequest: i32, flags: i32, pdisposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    VerifyRequest: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrdescription: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDescription: usize,
    pub ShutDown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPolicy2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPolicy2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Initialize)(::windows::core::Interface::as_raw(self), strconfig.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VerifyRequest<'a, P0>(&self, strconfig: P0, context: i32, bnewrequest: i32, flags: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.VerifyRequest)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), context, bnewrequest, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn ShutDown(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ShutDown)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetManageModule(&self) -> ::windows::core::Result<ICertManageModule> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetManageModule)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICertManageModule>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPolicy2> for ::windows::core::IUnknown {
    fn from(value: ICertPolicy2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPolicy2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPolicy2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPolicy2> for ::windows::core::IUnknown {
    fn from(value: &ICertPolicy2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPolicy2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPolicy2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPolicy2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPolicy2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPolicy2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPolicy2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPolicy2> for ICertPolicy {
    fn from(value: ICertPolicy2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPolicy2> for &'a ICertPolicy {
    fn from(value: &'a ICertPolicy2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPolicy2> for ICertPolicy {
    fn from(value: &ICertPolicy2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPolicy2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPolicy2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPolicy2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPolicy2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPolicy2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPolicy2 {
    type Vtable = ICertPolicy2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3db4910e_8001_4bf1_aa1b_f43a808317a0);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPolicy2_Vtbl {
    pub base__: ICertPolicy_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetManageModule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmanagemodule: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetManageModule: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertProperties(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertProperties {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICertProperty> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICertProperty>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICertProperty>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertProperties> for ::windows::core::IUnknown {
    fn from(value: ICertProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertProperties> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertProperties> for ::windows::core::IUnknown {
    fn from(value: &ICertProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertProperties> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertProperties> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertProperties> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertProperties {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertProperties").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertProperties {
    type Vtable = ICertProperties_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab32f_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertProperties_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeFromCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, machinecontext: i16, encoding: EncodingType, strcertificate: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeFromCertificate: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertProperty(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertProperty {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertProperty> for ::windows::core::IUnknown {
    fn from(value: ICertProperty) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertProperty> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertProperty) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertProperty> for ::windows::core::IUnknown {
    fn from(value: &ICertProperty) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertProperty> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertProperty) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertProperty> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertProperty) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertProperty> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertProperty) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertProperty {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertProperty {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertProperty {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertProperty").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertProperty {
    type Vtable = ICertProperty_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab32e_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertProperty_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeFromCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, machinecontext: i16, encoding: EncodingType, strcertificate: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeFromCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeDecode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, strencodeddata: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeDecode: usize,
    pub PropertyId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut CERTENROLL_PROPERTYID) -> ::windows::core::HRESULT,
    pub SetPropertyId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: CERTENROLL_PROPERTYID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub get_RawData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_RawData: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RemoveFromCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, machinecontext: i16, encoding: EncodingType, strcertificate: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RemoveFromCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetValueOnCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, machinecontext: i16, encoding: EncodingType, strcertificate: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetValueOnCertificate: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyArchived(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyArchived {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    pub unsafe fn Initialize(&self, archivedvalue: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), archivedvalue).ok()
    }
    pub unsafe fn Archived(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Archived)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyArchived> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyArchived) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyArchived> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyArchived) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyArchived> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyArchived) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyArchived> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyArchived) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyArchived> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyArchived) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyArchived> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyArchived) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyArchived> for ICertProperty {
    fn from(value: ICertPropertyArchived) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyArchived> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyArchived) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyArchived> for ICertProperty {
    fn from(value: &ICertPropertyArchived) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyArchived {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyArchived {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyArchived {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyArchived {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyArchived").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyArchived {
    type Vtable = ICertPropertyArchived_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab337_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyArchived_Vtbl {
    pub base__: ICertProperty_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, archivedvalue: i16) -> ::windows::core::HRESULT,
    pub Archived: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyArchivedKeyHash(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyArchivedKeyHash {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, encoding: EncodingType, strarchivedkeyhashvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), encoding, strarchivedkeyhashvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_ArchivedKeyHash(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ArchivedKeyHash)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyArchivedKeyHash> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyArchivedKeyHash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyArchivedKeyHash> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyArchivedKeyHash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyArchivedKeyHash> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyArchivedKeyHash) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyArchivedKeyHash> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyArchivedKeyHash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyArchivedKeyHash> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyArchivedKeyHash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyArchivedKeyHash> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyArchivedKeyHash) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyArchivedKeyHash> for ICertProperty {
    fn from(value: ICertPropertyArchivedKeyHash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyArchivedKeyHash> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyArchivedKeyHash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyArchivedKeyHash> for ICertProperty {
    fn from(value: &ICertPropertyArchivedKeyHash) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyArchivedKeyHash {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyArchivedKeyHash {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyArchivedKeyHash {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyArchivedKeyHash {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyArchivedKeyHash").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyArchivedKeyHash {
    type Vtable = ICertPropertyArchivedKeyHash_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab33b_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyArchivedKeyHash_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, strarchivedkeyhashvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub get_ArchivedKeyHash: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_ArchivedKeyHash: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyAutoEnroll(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyAutoEnroll {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strtemplatename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), strtemplatename.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn TemplateName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).TemplateName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyAutoEnroll> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyAutoEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyAutoEnroll> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyAutoEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyAutoEnroll> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyAutoEnroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyAutoEnroll> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyAutoEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyAutoEnroll> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyAutoEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyAutoEnroll> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyAutoEnroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyAutoEnroll> for ICertProperty {
    fn from(value: ICertPropertyAutoEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyAutoEnroll> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyAutoEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyAutoEnroll> for ICertProperty {
    fn from(value: &ICertPropertyAutoEnroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyAutoEnroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyAutoEnroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyAutoEnroll {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyAutoEnroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyAutoEnroll").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyAutoEnroll {
    type Vtable = ICertPropertyAutoEnroll_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab332_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyAutoEnroll_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strtemplatename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub TemplateName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    TemplateName: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyBackedUp(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyBackedUp {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    pub unsafe fn InitializeFromCurrentTime(&self, backedupvalue: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeFromCurrentTime)(::windows::core::Interface::as_raw(self), backedupvalue).ok()
    }
    pub unsafe fn Initialize(&self, backedupvalue: i16, date: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), backedupvalue, date).ok()
    }
    pub unsafe fn BackedUpValue(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).BackedUpValue)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn BackedUpTime(&self) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).BackedUpTime)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyBackedUp> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyBackedUp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyBackedUp> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyBackedUp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyBackedUp> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyBackedUp) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyBackedUp> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyBackedUp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyBackedUp> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyBackedUp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyBackedUp> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyBackedUp) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyBackedUp> for ICertProperty {
    fn from(value: ICertPropertyBackedUp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyBackedUp> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyBackedUp) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyBackedUp> for ICertProperty {
    fn from(value: &ICertPropertyBackedUp) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyBackedUp {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyBackedUp {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyBackedUp {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyBackedUp {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyBackedUp").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyBackedUp {
    type Vtable = ICertPropertyBackedUp_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab338_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyBackedUp_Vtbl {
    pub base__: ICertProperty_Vtbl,
    pub InitializeFromCurrentTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, backedupvalue: i16) -> ::windows::core::HRESULT,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, backedupvalue: i16, date: f64) -> ::windows::core::HRESULT,
    pub BackedUpValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub BackedUpTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdate: *mut f64) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyDescription(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyDescription {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strdescription: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), strdescription.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Description(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Description)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyDescription> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyDescription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyDescription> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyDescription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyDescription> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyDescription) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyDescription> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyDescription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyDescription> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyDescription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyDescription> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyDescription) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyDescription> for ICertProperty {
    fn from(value: ICertPropertyDescription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyDescription> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyDescription) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyDescription> for ICertProperty {
    fn from(value: &ICertPropertyDescription) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyDescription {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyDescription {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyDescription {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyDescription {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyDescription").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyDescription {
    type Vtable = ICertPropertyDescription_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab331_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyDescription_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strdescription: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Description: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Description: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyEnrollment(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyEnrollment {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0, P1, P2>(&self, requestid: i32, strcadnsname: P0, strcaname: P1, strfriendlyname: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), requestid, strcadnsname.into().abi(), strcaname.into().abi(), strfriendlyname.into().abi()).ok()
    }
    pub unsafe fn RequestId(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RequestId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CADnsName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CADnsName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CAName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CAName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FriendlyName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).FriendlyName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyEnrollment> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyEnrollment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyEnrollment> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyEnrollment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyEnrollment> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyEnrollment) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyEnrollment> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyEnrollment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyEnrollment> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyEnrollment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyEnrollment> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyEnrollment) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyEnrollment> for ICertProperty {
    fn from(value: ICertPropertyEnrollment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyEnrollment> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyEnrollment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyEnrollment> for ICertProperty {
    fn from(value: &ICertPropertyEnrollment) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyEnrollment {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyEnrollment {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyEnrollment {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyEnrollment {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyEnrollment").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyEnrollment {
    type Vtable = ICertPropertyEnrollment_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab339_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyEnrollment_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, requestid: i32, strcadnsname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strcaname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strfriendlyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    pub RequestId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CADnsName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CADnsName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub CAName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CAName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FriendlyName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    FriendlyName: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyEnrollmentPolicyServer(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyEnrollmentPolicyServer {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0, P1, P2, P3>(&self, propertyflags: EnrollmentPolicyServerPropertyFlags, authflags: X509EnrollmentAuthFlags, enrollmentserverauthflags: X509EnrollmentAuthFlags, urlflags: PolicyServerUrlFlags, strrequestid: P0, strurl: P1, strid: P2, strenrollmentserverurl: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), propertyflags, authflags, enrollmentserverauthflags, urlflags, strrequestid.into().abi(), strurl.into().abi(), strid.into().abi(), strenrollmentserverurl.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPolicyServerUrl(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetPolicyServerUrl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPolicyServerId(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetPolicyServerId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetEnrollmentServerUrl(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetEnrollmentServerUrl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRequestIdString(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestIdString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn GetPropertyFlags(&self) -> ::windows::core::Result<EnrollmentPolicyServerPropertyFlags> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetPropertyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<EnrollmentPolicyServerPropertyFlags>(result__)
    }
    pub unsafe fn GetUrlFlags(&self) -> ::windows::core::Result<PolicyServerUrlFlags> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetUrlFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<PolicyServerUrlFlags>(result__)
    }
    pub unsafe fn GetAuthentication(&self) -> ::windows::core::Result<X509EnrollmentAuthFlags> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAuthentication)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<X509EnrollmentAuthFlags>(result__)
    }
    pub unsafe fn GetEnrollmentServerAuthentication(&self) -> ::windows::core::Result<X509EnrollmentAuthFlags> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetEnrollmentServerAuthentication)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<X509EnrollmentAuthFlags>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyEnrollmentPolicyServer> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyEnrollmentPolicyServer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyEnrollmentPolicyServer> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyEnrollmentPolicyServer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyEnrollmentPolicyServer> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyEnrollmentPolicyServer) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyEnrollmentPolicyServer> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyEnrollmentPolicyServer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyEnrollmentPolicyServer> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyEnrollmentPolicyServer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyEnrollmentPolicyServer> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyEnrollmentPolicyServer) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyEnrollmentPolicyServer> for ICertProperty {
    fn from(value: ICertPropertyEnrollmentPolicyServer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyEnrollmentPolicyServer> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyEnrollmentPolicyServer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyEnrollmentPolicyServer> for ICertProperty {
    fn from(value: &ICertPropertyEnrollmentPolicyServer) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyEnrollmentPolicyServer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyEnrollmentPolicyServer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyEnrollmentPolicyServer {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyEnrollmentPolicyServer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyEnrollmentPolicyServer").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyEnrollmentPolicyServer {
    type Vtable = ICertPropertyEnrollmentPolicyServer_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab34a_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyEnrollmentPolicyServer_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyflags: EnrollmentPolicyServerPropertyFlags, authflags: X509EnrollmentAuthFlags, enrollmentserverauthflags: X509EnrollmentAuthFlags, urlflags: PolicyServerUrlFlags, strrequestid: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strurl: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strid: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strenrollmentserverurl: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetPolicyServerUrl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetPolicyServerUrl: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetPolicyServerId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetPolicyServerId: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetEnrollmentServerUrl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetEnrollmentServerUrl: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetRequestIdString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetRequestIdString: usize,
    pub GetPropertyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut EnrollmentPolicyServerPropertyFlags) -> ::windows::core::HRESULT,
    pub GetUrlFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut PolicyServerUrlFlags) -> ::windows::core::HRESULT,
    pub GetAuthentication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut X509EnrollmentAuthFlags) -> ::windows::core::HRESULT,
    pub GetEnrollmentServerAuthentication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut X509EnrollmentAuthFlags) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyFriendlyName(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyFriendlyName {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strfriendlyname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), strfriendlyname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FriendlyName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).FriendlyName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyFriendlyName> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyFriendlyName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyFriendlyName> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyFriendlyName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyFriendlyName> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyFriendlyName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyFriendlyName> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyFriendlyName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyFriendlyName> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyFriendlyName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyFriendlyName> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyFriendlyName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyFriendlyName> for ICertProperty {
    fn from(value: ICertPropertyFriendlyName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyFriendlyName> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyFriendlyName) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyFriendlyName> for ICertProperty {
    fn from(value: &ICertPropertyFriendlyName) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyFriendlyName {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyFriendlyName {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyFriendlyName {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyFriendlyName {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyFriendlyName").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyFriendlyName {
    type Vtable = ICertPropertyFriendlyName_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab330_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyFriendlyName_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strfriendlyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FriendlyName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    FriendlyName: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyKeyProvInfo(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyKeyProvInfo {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Initialize<'a, P0>(&self, pvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IX509PrivateKey>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), pvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateKey(&self) -> ::windows::core::Result<IX509PrivateKey> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).PrivateKey)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IX509PrivateKey>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyKeyProvInfo> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyKeyProvInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyKeyProvInfo> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyKeyProvInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyKeyProvInfo> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyKeyProvInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyKeyProvInfo> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyKeyProvInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyKeyProvInfo> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyKeyProvInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyKeyProvInfo> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyKeyProvInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyKeyProvInfo> for ICertProperty {
    fn from(value: ICertPropertyKeyProvInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyKeyProvInfo> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyKeyProvInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyKeyProvInfo> for ICertProperty {
    fn from(value: &ICertPropertyKeyProvInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyKeyProvInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyKeyProvInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyKeyProvInfo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyKeyProvInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyKeyProvInfo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyKeyProvInfo {
    type Vtable = ICertPropertyKeyProvInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab336_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyKeyProvInfo_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Initialize: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateKey: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyRenewal(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyRenewal {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, encoding: EncodingType, strrenewalvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), encoding, strrenewalvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificateHash<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromCertificateHash)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_Renewal(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_Renewal)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyRenewal> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyRenewal) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyRenewal> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyRenewal) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyRenewal> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyRenewal) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyRenewal> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyRenewal) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyRenewal> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyRenewal) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyRenewal> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyRenewal) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyRenewal> for ICertProperty {
    fn from(value: ICertPropertyRenewal) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyRenewal> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyRenewal) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyRenewal> for ICertProperty {
    fn from(value: &ICertPropertyRenewal) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyRenewal {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyRenewal {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyRenewal {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyRenewal {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyRenewal").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyRenewal {
    type Vtable = ICertPropertyRenewal_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab33a_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyRenewal_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, strrenewalvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeFromCertificateHash: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, machinecontext: i16, encoding: EncodingType, strcertificate: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeFromCertificateHash: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub get_Renewal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_Renewal: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertyRequestOriginator(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertyRequestOriginator {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, strrequestoriginator: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), strrequestoriginator.into().abi()).ok()
    }
    pub unsafe fn InitializeFromLocalRequestOriginator(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeFromLocalRequestOriginator)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestOriginator(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RequestOriginator)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyRequestOriginator> for ::windows::core::IUnknown {
    fn from(value: ICertPropertyRequestOriginator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyRequestOriginator> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertyRequestOriginator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyRequestOriginator> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertyRequestOriginator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyRequestOriginator> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertyRequestOriginator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyRequestOriginator> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertyRequestOriginator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyRequestOriginator> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertyRequestOriginator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertyRequestOriginator> for ICertProperty {
    fn from(value: ICertPropertyRequestOriginator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertyRequestOriginator> for &'a ICertProperty {
    fn from(value: &'a ICertPropertyRequestOriginator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertyRequestOriginator> for ICertProperty {
    fn from(value: &ICertPropertyRequestOriginator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertyRequestOriginator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertyRequestOriginator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertyRequestOriginator {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertyRequestOriginator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertyRequestOriginator").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertyRequestOriginator {
    type Vtable = ICertPropertyRequestOriginator_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab333_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertyRequestOriginator_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strrequestoriginator: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    pub InitializeFromLocalRequestOriginator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RequestOriginator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RequestOriginator: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertPropertySHA1Hash(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertPropertySHA1Hash {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDecode<'a, P0>(&self, encoding: EncodingType, strencodeddata: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeDecode)(::windows::core::Interface::as_raw(self), encoding, strencodeddata.into().abi()).ok()
    }
    pub unsafe fn PropertyId(&self) -> ::windows::core::Result<CERTENROLL_PROPERTYID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.PropertyId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTENROLL_PROPERTYID>(result__)
    }
    pub unsafe fn SetPropertyId(&self, value: CERTENROLL_PROPERTYID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetPropertyId)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_RawData(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.get_RawData)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RemoveFromCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.RemoveFromCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValueOnCertificate<'a, P0>(&self, machinecontext: i16, encoding: EncodingType, strcertificate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetValueOnCertificate)(::windows::core::Interface::as_raw(self), machinecontext, encoding, strcertificate.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, encoding: EncodingType, strrenewalvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), encoding, strrenewalvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_SHA1Hash(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_SHA1Hash)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertySHA1Hash> for ::windows::core::IUnknown {
    fn from(value: ICertPropertySHA1Hash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertySHA1Hash> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertPropertySHA1Hash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertySHA1Hash> for ::windows::core::IUnknown {
    fn from(value: &ICertPropertySHA1Hash) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertySHA1Hash> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertPropertySHA1Hash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertySHA1Hash> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertPropertySHA1Hash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertySHA1Hash> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertPropertySHA1Hash) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertPropertySHA1Hash> for ICertProperty {
    fn from(value: ICertPropertySHA1Hash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertPropertySHA1Hash> for &'a ICertProperty {
    fn from(value: &'a ICertPropertySHA1Hash) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertPropertySHA1Hash> for ICertProperty {
    fn from(value: &ICertPropertySHA1Hash) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertPropertySHA1Hash {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertPropertySHA1Hash {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertPropertySHA1Hash {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertPropertySHA1Hash {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertPropertySHA1Hash").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertPropertySHA1Hash {
    type Vtable = ICertPropertySHA1Hash_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab334_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertPropertySHA1Hash_Vtbl {
    pub base__: ICertProperty_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, strrenewalvalue: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub get_SHA1Hash: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_SHA1Hash: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertRequest(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertRequest {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Submit<'a, P0, P1, P2>(&self, flags: i32, strrequest: P0, strattributes: P1, strconfig: P2) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Submit)(::windows::core::Interface::as_raw(self), flags, strrequest.into().abi(), strattributes.into().abi(), strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RetrievePending<'a, P0>(&self, requestid: i32, strconfig: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RetrievePending)(::windows::core::Interface::as_raw(self), requestid, strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetLastStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetLastStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetRequestId(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDispositionMessage(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDispositionMessage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCACertificate<'a, P0>(&self, fexchangecertificate: i32, strconfig: P0, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCACertificate)(::windows::core::Interface::as_raw(self), fexchangecertificate, strconfig.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCertificate(&self, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificate)(::windows::core::Interface::as_raw(self), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest> for ::windows::core::IUnknown {
    fn from(value: ICertRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest> for ::windows::core::IUnknown {
    fn from(value: &ICertRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertRequest {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertRequest {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertRequest {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertRequest {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertRequest").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertRequest {
    type Vtable = ICertRequest_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x014e4840_5523_11d0_8812_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertRequest_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Submit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, strrequest: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strattributes: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pdisposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Submit: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RetrievePending: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, requestid: i32, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pdisposition: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RetrievePending: usize,
    pub GetLastStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatus: *mut i32) -> ::windows::core::HRESULT,
    pub GetRequestId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prequestid: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDispositionMessage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrdispositionmessage: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDispositionMessage: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCACertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fexchangecertificate: i32, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, flags: i32, pstrcertificate: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCACertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32, pstrcertificate: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCertificate: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertRequest2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertRequest2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Submit<'a, P0, P1, P2>(&self, flags: i32, strrequest: P0, strattributes: P1, strconfig: P2) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Submit)(::windows::core::Interface::as_raw(self), flags, strrequest.into().abi(), strattributes.into().abi(), strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RetrievePending<'a, P0>(&self, requestid: i32, strconfig: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RetrievePending)(::windows::core::Interface::as_raw(self), requestid, strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetLastStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetLastStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetRequestId(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetRequestId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDispositionMessage(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetDispositionMessage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCACertificate<'a, P0>(&self, fexchangecertificate: i32, strconfig: P0, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCACertificate)(::windows::core::Interface::as_raw(self), fexchangecertificate, strconfig.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCertificate(&self, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCertificate)(::windows::core::Interface::as_raw(self), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIssuedCertificate<'a, P0, P1>(&self, strconfig: P0, requestid: i32, strserialnumber: P1) -> ::windows::core::Result<CR_DISP>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetIssuedCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strserialnumber.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CR_DISP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetErrorMessageText(&self, hrmessage: i32, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetErrorMessageText)(::windows::core::Interface::as_raw(self), hrmessage, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCAProperty<'a, P0>(&self, strconfig: P0, propid: i32, propindex: i32, proptype: i32, flags: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAProperty)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, propindex, proptype, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCAPropertyFlags<'a, P0>(&self, strconfig: P0, propid: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAPropertyFlags)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCAPropertyDisplayName<'a, P0>(&self, strconfig: P0, propid: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAPropertyDisplayName)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetFullResponseProperty(&self, propid: FULL_RESPONSE_PROPERTY_ID, propindex: i32, proptype: CERT_PROPERTY_TYPE, flags: CERT_REQUEST_OUT_TYPE) -> ::windows::core::Result<super::super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFullResponseProperty)(::windows::core::Interface::as_raw(self), propid, propindex, proptype, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest2> for ::windows::core::IUnknown {
    fn from(value: ICertRequest2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertRequest2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest2> for ::windows::core::IUnknown {
    fn from(value: &ICertRequest2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertRequest2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertRequest2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertRequest2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest2> for ICertRequest {
    fn from(value: ICertRequest2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest2> for &'a ICertRequest {
    fn from(value: &'a ICertRequest2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest2> for ICertRequest {
    fn from(value: &ICertRequest2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertRequest2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertRequest2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertRequest2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertRequest2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertRequest2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertRequest2 {
    type Vtable = ICertRequest2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa4772988_4a85_4fa9_824e_b5cf5c16405a);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertRequest2_Vtbl {
    pub base__: ICertRequest_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetIssuedCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, requestid: i32, strserialnumber: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pdisposition: *mut CR_DISP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetIssuedCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetErrorMessageText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrmessage: i32, flags: i32, pstrerrormessagetext: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetErrorMessageText: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCAProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, propindex: i32, proptype: i32, flags: i32, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCAProperty: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCAPropertyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, ppropflags: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCAPropertyFlags: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCAPropertyDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propid: i32, pstrdisplayname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCAPropertyDisplayName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetFullResponseProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propid: FULL_RESPONSE_PROPERTY_ID, propindex: i32, proptype: CERT_PROPERTY_TYPE, flags: CERT_REQUEST_OUT_TYPE, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetFullResponseProperty: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertRequest3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertRequest3 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Submit<'a, P0, P1, P2>(&self, flags: i32, strrequest: P0, strattributes: P1, strconfig: P2) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Submit)(::windows::core::Interface::as_raw(self), flags, strrequest.into().abi(), strattributes.into().abi(), strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RetrievePending<'a, P0>(&self, requestid: i32, strconfig: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.RetrievePending)(::windows::core::Interface::as_raw(self), requestid, strconfig.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetLastStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetLastStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn GetRequestId(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetRequestId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDispositionMessage(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetDispositionMessage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCACertificate<'a, P0>(&self, fexchangecertificate: i32, strconfig: P0, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetCACertificate)(::windows::core::Interface::as_raw(self), fexchangecertificate, strconfig.into().abi(), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCertificate(&self, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetCertificate)(::windows::core::Interface::as_raw(self), flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIssuedCertificate<'a, P0, P1>(&self, strconfig: P0, requestid: i32, strserialnumber: P1) -> ::windows::core::Result<CR_DISP>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetIssuedCertificate)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), requestid, strserialnumber.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CR_DISP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetErrorMessageText(&self, hrmessage: i32, flags: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetErrorMessageText)(::windows::core::Interface::as_raw(self), hrmessage, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCAProperty<'a, P0>(&self, strconfig: P0, propid: i32, propindex: i32, proptype: i32, flags: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCAProperty)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, propindex, proptype, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCAPropertyFlags<'a, P0>(&self, strconfig: P0, propid: i32) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCAPropertyFlags)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCAPropertyDisplayName<'a, P0>(&self, strconfig: P0, propid: i32) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCAPropertyDisplayName)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), propid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetFullResponseProperty(&self, propid: FULL_RESPONSE_PROPERTY_ID, propindex: i32, proptype: CERT_PROPERTY_TYPE, flags: CERT_REQUEST_OUT_TYPE) -> ::windows::core::Result<super::super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetFullResponseProperty)(::windows::core::Interface::as_raw(self), propid, propindex, proptype, flags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCredential<'a, P0, P1>(&self, hwnd: i32, authtype: X509EnrollmentAuthFlags, strcredential: P0, strpassword: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCredential)(::windows::core::Interface::as_raw(self), hwnd, authtype, strcredential.into().abi(), strpassword.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRequestIdString(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestIdString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIssuedCertificate2<'a, P0, P1, P2>(&self, strconfig: P0, strrequestid: P1, strserialnumber: P2) -> ::windows::core::Result<CR_DISP>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetIssuedCertificate2)(::windows::core::Interface::as_raw(self), strconfig.into().abi(), strrequestid.into().abi(), strserialnumber.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CR_DISP>(result__)
    }
    pub unsafe fn GetRefreshPolicy(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRefreshPolicy)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest3> for ::windows::core::IUnknown {
    fn from(value: ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest3> for ::windows::core::IUnknown {
    fn from(value: &ICertRequest3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest3> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest3> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest3> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertRequest3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest3> for ICertRequest {
    fn from(value: ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest3> for &'a ICertRequest {
    fn from(value: &'a ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest3> for ICertRequest {
    fn from(value: &ICertRequest3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertRequest3> for ICertRequest2 {
    fn from(value: ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertRequest3> for &'a ICertRequest2 {
    fn from(value: &'a ICertRequest3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertRequest3> for ICertRequest2 {
    fn from(value: &ICertRequest3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertRequest3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertRequest3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertRequest3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertRequest3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertRequest3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertRequest3 {
    type Vtable = ICertRequest3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xafc8f92b_33a2_4861_bf36_2933b7cd67b3);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertRequest3_Vtbl {
    pub base__: ICertRequest2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCredential: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: i32, authtype: X509EnrollmentAuthFlags, strcredential: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strpassword: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCredential: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetRequestIdString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrrequestid: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetRequestIdString: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetIssuedCertificate2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strrequestid: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, strserialnumber: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pdisposition: *mut CR_DISP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetIssuedCertificate2: usize,
    pub GetRefreshPolicy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
pub struct ICertRequestD(::windows::core::IUnknown);
impl ICertRequestD {
    pub unsafe fn Request<'a, P0, P1>(&self, dwflags: u32, pwszauthority: P0, pdwrequestid: *mut u32, pdwdisposition: *mut u32, pwszattributes: P1, pctbrequest: *const CERTTRANSBLOB, pctbcertchain: *mut CERTTRANSBLOB, pctbencodedcert: *mut CERTTRANSBLOB, pctbdispositionmessage: *mut CERTTRANSBLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Request)(::windows::core::Interface::as_raw(self), dwflags, pwszauthority.into(), ::core::mem::transmute(pdwrequestid), ::core::mem::transmute(pdwdisposition), pwszattributes.into(), ::core::mem::transmute(pctbrequest), ::core::mem::transmute(pctbcertchain), ::core::mem::transmute(pctbencodedcert), ::core::mem::transmute(pctbdispositionmessage)).ok()
    }
    pub unsafe fn GetCACert<'a, P0>(&self, fchain: u32, pwszauthority: P0) -> ::windows::core::Result<CERTTRANSBLOB>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCACert)(::windows::core::Interface::as_raw(self), fchain, pwszauthority.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTTRANSBLOB>(result__)
    }
    pub unsafe fn Ping<'a, P0>(&self, pwszauthority: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Ping)(::windows::core::Interface::as_raw(self), pwszauthority.into()).ok()
    }
}
impl ::core::convert::From<ICertRequestD> for ::windows::core::IUnknown {
    fn from(value: ICertRequestD) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICertRequestD> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertRequestD) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICertRequestD> for ::windows::core::IUnknown {
    fn from(value: &ICertRequestD) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICertRequestD {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICertRequestD {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICertRequestD {}
impl ::core::fmt::Debug for ICertRequestD {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertRequestD").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICertRequestD {
    type Vtable = ICertRequestD_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd99e6e70_fc88_11d0_b498_00a0c90312f3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICertRequestD_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Request: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, pwszauthority: ::windows::core::PCWSTR, pdwrequestid: *mut u32, pdwdisposition: *mut u32, pwszattributes: ::windows::core::PCWSTR, pctbrequest: *const CERTTRANSBLOB, pctbcertchain: *mut CERTTRANSBLOB, pctbencodedcert: *mut CERTTRANSBLOB, pctbdispositionmessage: *mut CERTTRANSBLOB) -> ::windows::core::HRESULT,
    pub GetCACert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fchain: u32, pwszauthority: ::windows::core::PCWSTR, pctbout: *mut CERTTRANSBLOB) -> ::windows::core::HRESULT,
    pub Ping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszauthority: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
pub struct ICertRequestD2(::windows::core::IUnknown);
impl ICertRequestD2 {
    pub unsafe fn Request<'a, P0, P1>(&self, dwflags: u32, pwszauthority: P0, pdwrequestid: *mut u32, pdwdisposition: *mut u32, pwszattributes: P1, pctbrequest: *const CERTTRANSBLOB, pctbcertchain: *mut CERTTRANSBLOB, pctbencodedcert: *mut CERTTRANSBLOB, pctbdispositionmessage: *mut CERTTRANSBLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.Request)(::windows::core::Interface::as_raw(self), dwflags, pwszauthority.into(), ::core::mem::transmute(pdwrequestid), ::core::mem::transmute(pdwdisposition), pwszattributes.into(), ::core::mem::transmute(pctbrequest), ::core::mem::transmute(pctbcertchain), ::core::mem::transmute(pctbencodedcert), ::core::mem::transmute(pctbdispositionmessage)).ok()
    }
    pub unsafe fn GetCACert<'a, P0>(&self, fchain: u32, pwszauthority: P0) -> ::windows::core::Result<CERTTRANSBLOB>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetCACert)(::windows::core::Interface::as_raw(self), fchain, pwszauthority.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTTRANSBLOB>(result__)
    }
    pub unsafe fn Ping<'a, P0>(&self, pwszauthority: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.Ping)(::windows::core::Interface::as_raw(self), pwszauthority.into()).ok()
    }
    pub unsafe fn Request2<'a, P0, P1, P2>(&self, pwszauthority: P0, dwflags: u32, pwszserialnumber: P1, pdwrequestid: *mut u32, pdwdisposition: *mut u32, pwszattributes: P2, pctbrequest: *const CERTTRANSBLOB, pctbfullresponse: *mut CERTTRANSBLOB, pctbencodedcert: *mut CERTTRANSBLOB, pctbdispositionmessage: *mut CERTTRANSBLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Request2)(::windows::core::Interface::as_raw(self), pwszauthority.into(), dwflags, pwszserialnumber.into(), ::core::mem::transmute(pdwrequestid), ::core::mem::transmute(pdwdisposition), pwszattributes.into(), ::core::mem::transmute(pctbrequest), ::core::mem::transmute(pctbfullresponse), ::core::mem::transmute(pctbencodedcert), ::core::mem::transmute(pctbdispositionmessage)).ok()
    }
    pub unsafe fn GetCAProperty<'a, P0>(&self, pwszauthority: P0, propid: i32, propindex: i32, proptype: i32) -> ::windows::core::Result<CERTTRANSBLOB>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCAProperty)(::windows::core::Interface::as_raw(self), pwszauthority.into(), propid, propindex, proptype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CERTTRANSBLOB>(result__)
    }
    pub unsafe fn GetCAPropertyInfo<'a, P0>(&self, pwszauthority: P0, pcproperty: *mut i32, pctbpropinfo: *mut CERTTRANSBLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetCAPropertyInfo)(::windows::core::Interface::as_raw(self), pwszauthority.into(), ::core::mem::transmute(pcproperty), ::core::mem::transmute(pctbpropinfo)).ok()
    }
    pub unsafe fn Ping2<'a, P0>(&self, pwszauthority: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Ping2)(::windows::core::Interface::as_raw(self), pwszauthority.into()).ok()
    }
}
impl ::core::convert::From<ICertRequestD2> for ::windows::core::IUnknown {
    fn from(value: ICertRequestD2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICertRequestD2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertRequestD2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICertRequestD2> for ::windows::core::IUnknown {
    fn from(value: &ICertRequestD2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICertRequestD2> for ICertRequestD {
    fn from(value: ICertRequestD2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICertRequestD2> for &'a ICertRequestD {
    fn from(value: &'a ICertRequestD2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICertRequestD2> for ICertRequestD {
    fn from(value: &ICertRequestD2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICertRequestD2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICertRequestD2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICertRequestD2 {}
impl ::core::fmt::Debug for ICertRequestD2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertRequestD2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICertRequestD2 {
    type Vtable = ICertRequestD2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5422fd3a_d4b8_4cef_a12e_e87d4ca22e90);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICertRequestD2_Vtbl {
    pub base__: ICertRequestD_Vtbl,
    pub Request2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszauthority: ::windows::core::PCWSTR, dwflags: u32, pwszserialnumber: ::windows::core::PCWSTR, pdwrequestid: *mut u32, pdwdisposition: *mut u32, pwszattributes: ::windows::core::PCWSTR, pctbrequest: *const CERTTRANSBLOB, pctbfullresponse: *mut CERTTRANSBLOB, pctbencodedcert: *mut CERTTRANSBLOB, pctbdispositionmessage: *mut CERTTRANSBLOB) -> ::windows::core::HRESULT,
    pub GetCAProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszauthority: ::windows::core::PCWSTR, propid: i32, propindex: i32, proptype: i32, pctbpropertyvalue: *mut CERTTRANSBLOB) -> ::windows::core::HRESULT,
    pub GetCAPropertyInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszauthority: ::windows::core::PCWSTR, pcproperty: *mut i32, pctbpropinfo: *mut CERTTRANSBLOB) -> ::windows::core::HRESULT,
    pub Ping2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszauthority: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertServerExit(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertServerExit {
    pub unsafe fn SetContext(&self, context: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetContext)(::windows::core::Interface::as_raw(self), context).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRequestProperty<'a, P0>(&self, strpropertyname: P0, propertytype: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestProperty)(::windows::core::Interface::as_raw(self), strpropertyname.into().abi(), propertytype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRequestAttribute<'a, P0>(&self, strattributename: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestAttribute)(::windows::core::Interface::as_raw(self), strattributename.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCertificateProperty<'a, P0>(&self, strpropertyname: P0, propertytype: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificateProperty)(::windows::core::Interface::as_raw(self), strpropertyname.into().abi(), propertytype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCertificateExtension<'a, P0>(&self, strextensionname: P0, r#type: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificateExtension)(::windows::core::Interface::as_raw(self), strextensionname.into().abi(), r#type, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    pub unsafe fn GetCertificateExtensionFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificateExtensionFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn EnumerateExtensionsSetup(&self, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateExtensionsSetup)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumerateExtensions(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumerateExtensions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn EnumerateExtensionsClose(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateExtensionsClose)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumerateAttributesSetup(&self, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateAttributesSetup)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumerateAttributes(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumerateAttributes)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn EnumerateAttributesClose(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateAttributesClose)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertServerExit> for ::windows::core::IUnknown {
    fn from(value: ICertServerExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertServerExit> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertServerExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertServerExit> for ::windows::core::IUnknown {
    fn from(value: &ICertServerExit) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertServerExit> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertServerExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertServerExit> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertServerExit) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertServerExit> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertServerExit) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertServerExit {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertServerExit {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertServerExit {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertServerExit {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertServerExit").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertServerExit {
    type Vtable = ICertServerExit_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4ba9eb90_732c_11d0_8816_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertServerExit_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub SetContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: i32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetRequestProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propertytype: i32, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetRequestProperty: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetRequestAttribute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strattributename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrattributevalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetRequestAttribute: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCertificateProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propertytype: i32, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCertificateProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCertificateExtension: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strextensionname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, r#type: i32, pvarvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCertificateExtension: usize,
    pub GetCertificateExtensionFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pextflags: *mut i32) -> ::windows::core::HRESULT,
    pub EnumerateExtensionsSetup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub EnumerateExtensions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrextensionname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnumerateExtensions: usize,
    pub EnumerateExtensionsClose: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateAttributesSetup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub EnumerateAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrattributename: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnumerateAttributes: usize,
    pub EnumerateAttributesClose: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertServerPolicy(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertServerPolicy {
    pub unsafe fn SetContext(&self, context: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetContext)(::windows::core::Interface::as_raw(self), context).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRequestProperty<'a, P0>(&self, strpropertyname: P0, propertytype: i32) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestProperty)(::windows::core::Interface::as_raw(self), strpropertyname.into().abi(), propertytype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRequestAttribute<'a, P0>(&self, strattributename: P0) -> ::windows::core::Result<super::super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetRequestAttribute)(::windows::core::Interface::as_raw(self), strattributename.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCertificateProperty<'a, P0>(&self, strpropertyname: P0, propertytype: CERT_PROPERTY_TYPE) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificateProperty)(::windows::core::Interface::as_raw(self), strpropertyname.into().abi(), propertytype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetCertificateProperty<'a, P0>(&self, strpropertyname: P0, propertytype: i32, pvarpropertyvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCertificateProperty)(::windows::core::Interface::as_raw(self), strpropertyname.into().abi(), propertytype, ::core::mem::transmute(pvarpropertyvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCertificateExtension<'a, P0>(&self, strextensionname: P0, r#type: CERT_PROPERTY_TYPE) -> ::windows::core::Result<super::super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificateExtension)(::windows::core::Interface::as_raw(self), strextensionname.into().abi(), r#type, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
    pub unsafe fn GetCertificateExtensionFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCertificateExtensionFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetCertificateExtension<'a, P0>(&self, strextensionname: P0, r#type: i32, extflags: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetCertificateExtension)(::windows::core::Interface::as_raw(self), strextensionname.into().abi(), r#type, extflags, ::core::mem::transmute(pvarvalue)).ok()
    }
    pub unsafe fn EnumerateExtensionsSetup(&self, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateExtensionsSetup)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumerateExtensions(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumerateExtensions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn EnumerateExtensionsClose(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateExtensionsClose)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumerateAttributesSetup(&self, flags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateAttributesSetup)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumerateAttributes(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumerateAttributes)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn EnumerateAttributesClose(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumerateAttributesClose)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertServerPolicy> for ::windows::core::IUnknown {
    fn from(value: ICertServerPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertServerPolicy> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertServerPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertServerPolicy> for ::windows::core::IUnknown {
    fn from(value: &ICertServerPolicy) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertServerPolicy> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertServerPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertServerPolicy> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertServerPolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertServerPolicy> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertServerPolicy) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertServerPolicy {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertServerPolicy {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertServerPolicy {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertServerPolicy {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertServerPolicy").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertServerPolicy {
    type Vtable = ICertServerPolicy_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaa000922_ffbe_11cf_8800_00a0c903b83c);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertServerPolicy_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub SetContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: i32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetRequestProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propertytype: i32, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetRequestProperty: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetRequestAttribute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strattributename: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pstrattributevalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetRequestAttribute: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCertificateProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propertytype: CERT_PROPERTY_TYPE, pvarpropertyvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCertificateProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetCertificateProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpropertyname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, propertytype: i32, pvarpropertyvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetCertificateProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCertificateExtension: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strextensionname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, r#type: CERT_PROPERTY_TYPE, pvarvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCertificateExtension: usize,
    pub GetCertificateExtensionFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pextflags: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetCertificateExtension: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strextensionname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, r#type: i32, extflags: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetCertificateExtension: usize,
    pub EnumerateExtensionsSetup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub EnumerateExtensions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrextensionname: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnumerateExtensions: usize,
    pub EnumerateExtensionsClose: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateAttributesSetup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub EnumerateAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrattributename: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnumerateAttributes: usize,
    pub EnumerateAttributesClose: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertView(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertView {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenConnection<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).OpenConnection)(::windows::core::Interface::as_raw(self), strconfig.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCertViewColumn(&self, fresultcolumn: CVRC_COLUMN) -> ::windows::core::Result<IEnumCERTVIEWCOLUMN> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumCertViewColumn)(::windows::core::Interface::as_raw(self), fresultcolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumCERTVIEWCOLUMN>(result__)
    }
    pub unsafe fn GetColumnCount(&self, fresultcolumn: CVRC_COLUMN, pccolumn: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumnCount)(::windows::core::Interface::as_raw(self), fresultcolumn, ::core::mem::transmute(pccolumn)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetColumnIndex<'a, P0>(&self, fresultcolumn: CVRC_COLUMN, strcolumnname: P0, pcolumnindex: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).GetColumnIndex)(::windows::core::Interface::as_raw(self), fresultcolumn, strcolumnname.into().abi(), ::core::mem::transmute(pcolumnindex)).ok()
    }
    pub unsafe fn SetResultColumnCount(&self, cresultcolumn: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetResultColumnCount)(::windows::core::Interface::as_raw(self), cresultcolumn).ok()
    }
    pub unsafe fn SetResultColumn(&self, columnindex: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetResultColumn)(::windows::core::Interface::as_raw(self), columnindex).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetRestriction(&self, columnindex: CERT_VIEW_COLUMN_INDEX, seekoperator: CERT_VIEW_SEEK_OPERATOR_FLAGS, sortorder: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRestriction)(::windows::core::Interface::as_raw(self), columnindex, seekoperator, sortorder, ::core::mem::transmute(pvarvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OpenView(&self) -> ::windows::core::Result<IEnumCERTVIEWROW> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).OpenView)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumCERTVIEWROW>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertView> for ::windows::core::IUnknown {
    fn from(value: ICertView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertView> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertView> for ::windows::core::IUnknown {
    fn from(value: &ICertView) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertView> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertView> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertView> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertView) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertView {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertView {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertView {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertView {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertView").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertView {
    type Vtable = ICertView_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc3fac344_1e84_11d1_9bd6_00c04fb683fa);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertView_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OpenConnection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strconfig: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OpenConnection: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumCertViewColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fresultcolumn: CVRC_COLUMN, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumCertViewColumn: usize,
    pub GetColumnCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fresultcolumn: CVRC_COLUMN, pccolumn: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetColumnIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fresultcolumn: CVRC_COLUMN, strcolumnname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, pcolumnindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetColumnIndex: usize,
    pub SetResultColumnCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cresultcolumn: i32) -> ::windows::core::HRESULT,
    pub SetResultColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columnindex: i32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetRestriction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columnindex: CERT_VIEW_COLUMN_INDEX, seekoperator: CERT_VIEW_SEEK_OPERATOR_FLAGS, sortorder: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetRestriction: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub OpenView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OpenView: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertView2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertView2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenConnection<'a, P0>(&self, strconfig: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.OpenConnection)(::windows::core::Interface::as_raw(self), strconfig.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCertViewColumn(&self, fresultcolumn: CVRC_COLUMN) -> ::windows::core::Result<IEnumCERTVIEWCOLUMN> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.EnumCertViewColumn)(::windows::core::Interface::as_raw(self), fresultcolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumCERTVIEWCOLUMN>(result__)
    }
    pub unsafe fn GetColumnCount(&self, fresultcolumn: CVRC_COLUMN, pccolumn: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetColumnCount)(::windows::core::Interface::as_raw(self), fresultcolumn, ::core::mem::transmute(pccolumn)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetColumnIndex<'a, P0>(&self, fresultcolumn: CVRC_COLUMN, strcolumnname: P0, pcolumnindex: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.GetColumnIndex)(::windows::core::Interface::as_raw(self), fresultcolumn, strcolumnname.into().abi(), ::core::mem::transmute(pcolumnindex)).ok()
    }
    pub unsafe fn SetResultColumnCount(&self, cresultcolumn: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetResultColumnCount)(::windows::core::Interface::as_raw(self), cresultcolumn).ok()
    }
    pub unsafe fn SetResultColumn(&self, columnindex: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetResultColumn)(::windows::core::Interface::as_raw(self), columnindex).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetRestriction(&self, columnindex: CERT_VIEW_COLUMN_INDEX, seekoperator: CERT_VIEW_SEEK_OPERATOR_FLAGS, sortorder: i32, pvarvalue: *const super::super::super::System::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRestriction)(::windows::core::Interface::as_raw(self), columnindex, seekoperator, sortorder, ::core::mem::transmute(pvarvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OpenView(&self) -> ::windows::core::Result<IEnumCERTVIEWROW> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.OpenView)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumCERTVIEWROW>(result__)
    }
    pub unsafe fn SetTable(&self, table: CVRC_TABLE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTable)(::windows::core::Interface::as_raw(self), table).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertView2> for ::windows::core::IUnknown {
    fn from(value: ICertView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertView2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertView2> for ::windows::core::IUnknown {
    fn from(value: &ICertView2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertView2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertView2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertView2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertView2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertView2> for ICertView {
    fn from(value: ICertView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertView2> for &'a ICertView {
    fn from(value: &'a ICertView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertView2> for ICertView {
    fn from(value: &ICertView2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertView2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertView2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertView2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertView2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertView2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertView2 {
    type Vtable = ICertView2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd594b282_8851_4b61_9c66_3edadf848863);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertView2_Vtbl {
    pub base__: ICertView_Vtbl,
    pub SetTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, table: CVRC_TABLE) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificateAttestationChallenge(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificateAttestationChallenge {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, encoding: EncodingType, strpendingfullcmcresponsewithchallenge: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), encoding, strpendingfullcmcresponsewithchallenge.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecryptChallenge(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).DecryptChallenge)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestID(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).RequestID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificateAttestationChallenge> for ::windows::core::IUnknown {
    fn from(value: ICertificateAttestationChallenge) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificateAttestationChallenge> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertificateAttestationChallenge) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificateAttestationChallenge> for ::windows::core::IUnknown {
    fn from(value: &ICertificateAttestationChallenge) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificateAttestationChallenge> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertificateAttestationChallenge) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificateAttestationChallenge> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertificateAttestationChallenge) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificateAttestationChallenge> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertificateAttestationChallenge) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificateAttestationChallenge {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificateAttestationChallenge {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificateAttestationChallenge {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificateAttestationChallenge {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificateAttestationChallenge").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertificateAttestationChallenge {
    type Vtable = ICertificateAttestationChallenge_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6f175a7c_4a3a_40ae_9dba_592fd6bbf9b8);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificateAttestationChallenge_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, strpendingfullcmcresponsewithchallenge: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DecryptChallenge: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, pstrenvelopedpkcs7reencryptedtoca: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DecryptChallenge: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RequestID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrrequestid: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RequestID: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificateAttestationChallenge2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificateAttestationChallenge2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, P0>(&self, encoding: EncodingType, strpendingfullcmcresponsewithchallenge: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.Initialize)(::windows::core::Interface::as_raw(self), encoding, strpendingfullcmcresponsewithchallenge.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecryptChallenge(&self, encoding: EncodingType) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.DecryptChallenge)(::windows::core::Interface::as_raw(self), encoding, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestID(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.RequestID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetKeyContainerName<'a, P0>(&self, value: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetKeyContainerName)(::windows::core::Interface::as_raw(self), value.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn put_KeyBlob<'a, P0>(&self, encoding: EncodingType, value: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).put_KeyBlob)(::windows::core::Interface::as_raw(self), encoding, value.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificateAttestationChallenge2> for ::windows::core::IUnknown {
    fn from(value: ICertificateAttestationChallenge2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificateAttestationChallenge2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertificateAttestationChallenge2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificateAttestationChallenge2> for ::windows::core::IUnknown {
    fn from(value: &ICertificateAttestationChallenge2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificateAttestationChallenge2> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertificateAttestationChallenge2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificateAttestationChallenge2> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertificateAttestationChallenge2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificateAttestationChallenge2> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertificateAttestationChallenge2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificateAttestationChallenge2> for ICertificateAttestationChallenge {
    fn from(value: ICertificateAttestationChallenge2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificateAttestationChallenge2> for &'a ICertificateAttestationChallenge {
    fn from(value: &'a ICertificateAttestationChallenge2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificateAttestationChallenge2> for ICertificateAttestationChallenge {
    fn from(value: &ICertificateAttestationChallenge2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificateAttestationChallenge2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificateAttestationChallenge2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificateAttestationChallenge2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificateAttestationChallenge2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificateAttestationChallenge2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertificateAttestationChallenge2 {
    type Vtable = ICertificateAttestationChallenge2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4631334d_e266_47d6_bd79_be53cb2e2753);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificateAttestationChallenge2_Vtbl {
    pub base__: ICertificateAttestationChallenge_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetKeyContainerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetKeyContainerName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub put_KeyBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, encoding: EncodingType, value: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    put_KeyBlob: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificatePolicies(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificatePolicies {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICertificatePolicy> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICertificatePolicy>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICertificatePolicy>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificatePolicies> for ::windows::core::IUnknown {
    fn from(value: ICertificatePolicies) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificatePolicies> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertificatePolicies) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificatePolicies> for ::windows::core::IUnknown {
    fn from(value: &ICertificatePolicies) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificatePolicies> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertificatePolicies) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificatePolicies> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertificatePolicies) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificatePolicies> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertificatePolicies) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificatePolicies {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificatePolicies {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificatePolicies {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificatePolicies {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificatePolicies").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertificatePolicies {
    type Vtable = ICertificatePolicies_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab31f_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificatePolicies_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificatePolicy(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificatePolicy {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Initialize<'a, P0>(&self, pvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), pvalue.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ObjectId(&self) -> ::windows::core::Result<IObjectId> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ObjectId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IObjectId>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PolicyQualifiers(&self) -> ::windows::core::Result<IPolicyQualifiers> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).PolicyQualifiers)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IPolicyQualifiers>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificatePolicy> for ::windows::core::IUnknown {
    fn from(value: ICertificatePolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificatePolicy> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertificatePolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificatePolicy> for ::windows::core::IUnknown {
    fn from(value: &ICertificatePolicy) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificatePolicy> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertificatePolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificatePolicy> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertificatePolicy) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificatePolicy> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertificatePolicy) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificatePolicy {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificatePolicy {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificatePolicy {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificatePolicy {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificatePolicy").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertificatePolicy {
    type Vtable = ICertificatePolicy_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab31e_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificatePolicy_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Initialize: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ObjectId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ObjectId: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PolicyQualifiers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PolicyQualifiers: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificationAuthorities(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificationAuthorities {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICertificationAuthority> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICertificationAuthority>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICertificationAuthority>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ComputeSiteCosts(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ComputeSiteCosts)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn get_ItemByName<'a, P0>(&self, strname: P0) -> ::windows::core::Result<ICertificationAuthority>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByName)(::windows::core::Interface::as_raw(self), strname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICertificationAuthority>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificationAuthorities> for ::windows::core::IUnknown {
    fn from(value: ICertificationAuthorities) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificationAuthorities> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertificationAuthorities) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificationAuthorities> for ::windows::core::IUnknown {
    fn from(value: &ICertificationAuthorities) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificationAuthorities> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertificationAuthorities) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificationAuthorities> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertificationAuthorities) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificationAuthorities> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertificationAuthorities) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificationAuthorities {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificationAuthorities {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificationAuthorities {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificationAuthorities {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificationAuthorities").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertificationAuthorities {
    type Vtable = ICertificationAuthorities_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x13b79005_2181_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificationAuthorities_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ComputeSiteCosts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub get_ItemByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    get_ItemByName: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificationAuthority(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificationAuthority {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn get_Property(&self, property: EnrollmentCAProperty) -> ::windows::core::Result<super::super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_Property)(::windows::core::Interface::as_raw(self), property, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificationAuthority> for ::windows::core::IUnknown {
    fn from(value: ICertificationAuthority) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificationAuthority> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICertificationAuthority) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificationAuthority> for ::windows::core::IUnknown {
    fn from(value: &ICertificationAuthority) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICertificationAuthority> for super::super::super::System::Com::IDispatch {
    fn from(value: ICertificationAuthority) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICertificationAuthority> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICertificationAuthority) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICertificationAuthority> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICertificationAuthority) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificationAuthority {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificationAuthority {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificationAuthority {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificationAuthority {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificationAuthority").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICertificationAuthority {
    type Vtable = ICertificationAuthority_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x835d1f61_1e95_4bc8_b4d3_976c42b968f7);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificationAuthority_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub get_Property: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: EnrollmentCAProperty, pvalue: *mut super::super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    get_Property: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICryptAttribute(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICryptAttribute {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InitializeFromObjectId<'a, P0>(&self, pobjectid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromObjectId)(::windows::core::Interface::as_raw(self), pobjectid.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InitializeFromValues<'a, P0>(&self, pattributes: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IX509Attributes>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromValues)(::windows::core::Interface::as_raw(self), pattributes.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ObjectId(&self) -> ::windows::core::Result<IObjectId> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ObjectId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IObjectId>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Values(&self) -> ::windows::core::Result<IX509Attributes> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Values)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IX509Attributes>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICryptAttribute> for ::windows::core::IUnknown {
    fn from(value: ICryptAttribute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICryptAttribute> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICryptAttribute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICryptAttribute> for ::windows::core::IUnknown {
    fn from(value: &ICryptAttribute) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICryptAttribute> for super::super::super::System::Com::IDispatch {
    fn from(value: ICryptAttribute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICryptAttribute> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICryptAttribute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICryptAttribute> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICryptAttribute) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICryptAttribute {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICryptAttribute {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICryptAttribute {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICryptAttribute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICryptAttribute").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICryptAttribute {
    type Vtable = ICryptAttribute_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab32c_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICryptAttribute_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub InitializeFromObjectId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobjectid: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InitializeFromObjectId: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub InitializeFromValues: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pattributes: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InitializeFromValues: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ObjectId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ObjectId: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Values: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Values: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICryptAttributes(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICryptAttributes {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICryptAttribute> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICryptAttribute>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICryptAttribute>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_IndexByObjectId<'a, P0>(&self, pobjectid: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_IndexByObjectId)(::windows::core::Interface::as_raw(self), pobjectid.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddRange<'a, P0>(&self, pvalue: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICryptAttributes>>,
    {
        (::windows::core::Interface::vtable(self).AddRange)(::windows::core::Interface::as_raw(self), pvalue.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICryptAttributes> for ::windows::core::IUnknown {
    fn from(value: ICryptAttributes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICryptAttributes> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICryptAttributes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICryptAttributes> for ::windows::core::IUnknown {
    fn from(value: &ICryptAttributes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICryptAttributes> for super::super::super::System::Com::IDispatch {
    fn from(value: ICryptAttributes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICryptAttributes> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICryptAttributes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICryptAttributes> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICryptAttributes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICryptAttributes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICryptAttributes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICryptAttributes {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICryptAttributes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICryptAttributes").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICryptAttributes {
    type Vtable = ICryptAttributes_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab32d_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICryptAttributes_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub get_IndexByObjectId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobjectid: *mut ::core::ffi::c_void, pindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_IndexByObjectId: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AddRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddRange: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICspAlgorithm(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICspAlgorithm {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetAlgorithmOid(&self, length: i32, algflags: AlgorithmFlags) -> ::windows::core::Result<IObjectId> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAlgorithmOid)(::windows::core::Interface::as_raw(self), length, algflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IObjectId>(result__)
    }
    pub unsafe fn DefaultLength(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).DefaultLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn IncrementLength(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IncrementLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LongName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).LongName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Valid(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Valid)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn MaxLength(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).MaxLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn MinLength(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).MinLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Type(&self) -> ::windows::core::Result<AlgorithmType> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<AlgorithmType>(result__)
    }
    pub unsafe fn Operations(&self) -> ::windows::core::Result<AlgorithmOperationFlags> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Operations)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<AlgorithmOperationFlags>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspAlgorithm> for ::windows::core::IUnknown {
    fn from(value: ICspAlgorithm) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspAlgorithm> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICspAlgorithm) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspAlgorithm> for ::windows::core::IUnknown {
    fn from(value: &ICspAlgorithm) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspAlgorithm> for super::super::super::System::Com::IDispatch {
    fn from(value: ICspAlgorithm) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspAlgorithm> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICspAlgorithm) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspAlgorithm> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICspAlgorithm) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICspAlgorithm {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICspAlgorithm {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICspAlgorithm {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICspAlgorithm {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICspAlgorithm").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICspAlgorithm {
    type Vtable = ICspAlgorithm_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab305_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICspAlgorithm_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetAlgorithmOid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, length: i32, algflags: AlgorithmFlags, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetAlgorithmOid: usize,
    pub DefaultLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub IncrementLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub LongName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LongName: usize,
    pub Valid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub MaxLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub MinLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut AlgorithmType) -> ::windows::core::HRESULT,
    pub Operations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut AlgorithmOperationFlags) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICspAlgorithms(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICspAlgorithms {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICspAlgorithm> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspAlgorithm>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspAlgorithm>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn get_ItemByName<'a, P0>(&self, strname: P0) -> ::windows::core::Result<ICspAlgorithm>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByName)(::windows::core::Interface::as_raw(self), strname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspAlgorithm>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_IndexByObjectId<'a, P0>(&self, pobjectid: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_IndexByObjectId)(::windows::core::Interface::as_raw(self), pobjectid.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspAlgorithms> for ::windows::core::IUnknown {
    fn from(value: ICspAlgorithms) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspAlgorithms> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICspAlgorithms) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspAlgorithms> for ::windows::core::IUnknown {
    fn from(value: &ICspAlgorithms) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspAlgorithms> for super::super::super::System::Com::IDispatch {
    fn from(value: ICspAlgorithms) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspAlgorithms> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICspAlgorithms) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspAlgorithms> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICspAlgorithms) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICspAlgorithms {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICspAlgorithms {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICspAlgorithms {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICspAlgorithms {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICspAlgorithms").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICspAlgorithms {
    type Vtable = ICspAlgorithms_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab306_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICspAlgorithms_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub get_ItemByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    get_ItemByName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub get_IndexByObjectId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobjectid: *mut ::core::ffi::c_void, pindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_IndexByObjectId: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICspInformation(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICspInformation {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeFromName<'a, P0>(&self, strname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromName)(::windows::core::Interface::as_raw(self), strname.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InitializeFromType<'a, P0>(&self, r#type: X509ProviderType, palgorithm: P0, machinecontext: i16) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
    {
        (::windows::core::Interface::vtable(self).InitializeFromType)(::windows::core::Interface::as_raw(self), r#type, palgorithm.into().abi(), machinecontext).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CspAlgorithms(&self) -> ::windows::core::Result<ICspAlgorithms> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CspAlgorithms)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspAlgorithms>(result__)
    }
    pub unsafe fn HasHardwareRandomNumberGenerator(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).HasHardwareRandomNumberGenerator)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsHardwareDevice(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsHardwareDevice)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsRemovable(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsRemovable)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsSoftwareDevice(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsSoftwareDevice)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn Valid(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Valid)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn MaxKeyContainerNameLength(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).MaxKeyContainerNameLength)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Type(&self) -> ::windows::core::Result<X509ProviderType> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<X509ProviderType>(result__)
    }
    pub unsafe fn Version(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Version)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn KeySpec(&self) -> ::windows::core::Result<X509KeySpec> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<X509KeySpec>(result__)
    }
    pub unsafe fn IsSmartCard(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsSmartCard)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultSecurityDescriptor(&self, machinecontext: i16) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDefaultSecurityDescriptor)(::windows::core::Interface::as_raw(self), machinecontext, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn LegacyCsp(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).LegacyCsp)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetCspStatusFromOperations<'a, P0>(&self, palgorithm: P0, operations: AlgorithmOperationFlags) -> ::windows::core::Result<ICspStatus>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IObjectId>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCspStatusFromOperations)(::windows::core::Interface::as_raw(self), palgorithm.into().abi(), operations, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspInformation> for ::windows::core::IUnknown {
    fn from(value: ICspInformation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspInformation> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICspInformation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspInformation> for ::windows::core::IUnknown {
    fn from(value: &ICspInformation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspInformation> for super::super::super::System::Com::IDispatch {
    fn from(value: ICspInformation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspInformation> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICspInformation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspInformation> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICspInformation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICspInformation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICspInformation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICspInformation {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICspInformation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICspInformation").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICspInformation {
    type Vtable = ICspInformation_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab307_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICspInformation_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeFromName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeFromName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub InitializeFromType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, r#type: X509ProviderType, palgorithm: *mut ::core::ffi::c_void, machinecontext: i16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InitializeFromType: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CspAlgorithms: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CspAlgorithms: usize,
    pub HasHardwareRandomNumberGenerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub IsHardwareDevice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub IsRemovable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub IsSoftwareDevice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub Valid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    pub MaxKeyContainerNameLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut X509ProviderType) -> ::windows::core::HRESULT,
    pub Version: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub KeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut X509KeySpec) -> ::windows::core::HRESULT,
    pub IsSmartCard: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDefaultSecurityDescriptor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, machinecontext: i16, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDefaultSecurityDescriptor: usize,
    pub LegacyCsp: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetCspStatusFromOperations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, palgorithm: *mut ::core::ffi::c_void, operations: AlgorithmOperationFlags, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetCspStatusFromOperations: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICspInformations(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICspInformations {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICspInformation> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspInformation>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspInformation>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AddAvailableCsps(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddAvailableCsps)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn get_ItemByName<'a, P0>(&self, strname: P0) -> ::windows::core::Result<ICspInformation>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByName)(::windows::core::Interface::as_raw(self), strname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspInformation>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetCspStatusFromProviderName<'a, P0>(&self, strprovidername: P0, legacykeyspec: X509KeySpec) -> ::windows::core::Result<ICspStatus>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCspStatusFromProviderName)(::windows::core::Interface::as_raw(self), strprovidername.into().abi(), legacykeyspec, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetCspStatusesFromOperations<'a, P0>(&self, operations: AlgorithmOperationFlags, pcspinformation: P0) -> ::windows::core::Result<ICspStatuses>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspInformation>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCspStatusesFromOperations)(::windows::core::Interface::as_raw(self), operations, pcspinformation.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatuses>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetEncryptionCspAlgorithms<'a, P0>(&self, pcspinformation: P0) -> ::windows::core::Result<ICspAlgorithms>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspInformation>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetEncryptionCspAlgorithms)(::windows::core::Interface::as_raw(self), pcspinformation.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspAlgorithms>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetHashAlgorithms<'a, P0>(&self, pcspinformation: P0) -> ::windows::core::Result<IObjectIds>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspInformation>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetHashAlgorithms)(::windows::core::Interface::as_raw(self), pcspinformation.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IObjectIds>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspInformations> for ::windows::core::IUnknown {
    fn from(value: ICspInformations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspInformations> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICspInformations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspInformations> for ::windows::core::IUnknown {
    fn from(value: &ICspInformations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspInformations> for super::super::super::System::Com::IDispatch {
    fn from(value: ICspInformations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspInformations> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICspInformations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspInformations> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICspInformations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICspInformations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICspInformations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICspInformations {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICspInformations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICspInformations").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICspInformations {
    type Vtable = ICspInformations_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab308_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICspInformations_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AddAvailableCsps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub get_ItemByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, ppcspinformation: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    get_ItemByName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub GetCspStatusFromProviderName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strprovidername: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, legacykeyspec: X509KeySpec, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    GetCspStatusFromProviderName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetCspStatusesFromOperations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, operations: AlgorithmOperationFlags, pcspinformation: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetCspStatusesFromOperations: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetEncryptionCspAlgorithms: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcspinformation: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetEncryptionCspAlgorithms: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetHashAlgorithms: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcspinformation: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetHashAlgorithms: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICspStatus(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICspStatus {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Initialize<'a, P0, P1>(&self, pcsp: P0, palgorithm: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspInformation>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ICspAlgorithm>>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), pcsp.into().abi(), palgorithm.into().abi()).ok()
    }
    pub unsafe fn Ordinal(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Ordinal)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn SetOrdinal(&self, value: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOrdinal)(::windows::core::Interface::as_raw(self), value).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CspAlgorithm(&self) -> ::windows::core::Result<ICspAlgorithm> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CspAlgorithm)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspAlgorithm>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CspInformation(&self) -> ::windows::core::Result<ICspInformation> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CspInformation)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspInformation>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnrollmentStatus(&self) -> ::windows::core::Result<IX509EnrollmentStatus> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnrollmentStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IX509EnrollmentStatus>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<super::super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).DisplayName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspStatus> for ::windows::core::IUnknown {
    fn from(value: ICspStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspStatus> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICspStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspStatus> for ::windows::core::IUnknown {
    fn from(value: &ICspStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspStatus> for super::super::super::System::Com::IDispatch {
    fn from(value: ICspStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspStatus> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICspStatus) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspStatus> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICspStatus) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICspStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICspStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICspStatus {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICspStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICspStatus").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICspStatus {
    type Vtable = ICspStatus_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab309_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICspStatus_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsp: *mut ::core::ffi::c_void, palgorithm: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Initialize: usize,
    pub Ordinal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows::core::HRESULT,
    pub SetOrdinal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub CspAlgorithm: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CspAlgorithm: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CspInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CspInformation: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnrollmentStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnrollmentStatus: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut super::super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DisplayName: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICspStatuses(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICspStatuses {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByIndex(&self, index: i32) -> ::windows::core::Result<ICspStatus> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByIndex)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<'a, P0>(&self, pval: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspStatus>>,
    {
        (::windows::core::Interface::vtable(self).Add)(::windows::core::Interface::as_raw(self), pval.into().abi()).ok()
    }
    pub unsafe fn Remove(&self, index: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self), index).ok()
    }
    pub unsafe fn Clear(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn get_ItemByName<'a, P0, P1>(&self, strcspname: P0, stralgorithmname: P1) -> ::windows::core::Result<ICspStatus>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByName)(::windows::core::Interface::as_raw(self), strcspname.into().abi(), stralgorithmname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByOrdinal(&self, ordinal: i32) -> ::windows::core::Result<ICspStatus> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByOrdinal)(::windows::core::Interface::as_raw(self), ordinal, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn get_ItemByOperations<'a, P0, P1>(&self, strcspname: P0, stralgorithmname: P1, operations: AlgorithmOperationFlags) -> ::windows::core::Result<ICspStatus>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByOperations)(::windows::core::Interface::as_raw(self), strcspname.into().abi(), stralgorithmname.into().abi(), operations, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn get_ItemByProvider<'a, P0>(&self, pcspstatus: P0) -> ::windows::core::Result<ICspStatus>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICspStatus>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).get_ItemByProvider)(::windows::core::Interface::as_raw(self), pcspstatus.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICspStatus>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspStatuses> for ::windows::core::IUnknown {
    fn from(value: ICspStatuses) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspStatuses> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICspStatuses) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspStatuses> for ::windows::core::IUnknown {
    fn from(value: &ICspStatuses) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ICspStatuses> for super::super::super::System::Com::IDispatch {
    fn from(value: ICspStatuses) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a ICspStatuses> for &'a super::super::super::System::Com::IDispatch {
    fn from(value: &'a ICspStatuses) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ICspStatuses> for super::super::super::System::Com::IDispatch {
    fn from(value: &ICspStatuses) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICspStatuses {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICspStatuses {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICspStatuses {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICspStatuses {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICspStatuses").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICspStatuses {
    type Vtable = ICspStatuses_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x728ab30a_217d_11da_b2a4_000e7bbb2b09);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICspStatuses_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByIndex: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32) -> ::windows::core::HRESULT,
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub get_ItemByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strcspname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, stralgorithmname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    get_ItemByName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByOrdinal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ordinal: i32, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByOrdinal: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub get_ItemByOperations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strcspname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, stralgorithmname: ::core::mem::ManuallyDrop<super::super::super::Foundation::BSTR>, operations: AlgorithmOperationFlags, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    get_ItemByOperations: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub get_ItemByProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcspstatus: *mut ::core::ffi::c_void, ppvalue: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    get_ItemByProvider: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
pub struct IEnroll(::windows::core::IUnknown);
impl IEnroll {
    pub unsafe fn createFilePKCS10WStr<'a, P0, P1, P2>(&self, dnname: P0, usage: P1, wszpkcs10filename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).createFilePKCS10WStr)(::windows::core::Interface::as_raw(self), dnname.into(), usage.into(), wszpkcs10filename.into()).ok()
    }
    pub unsafe fn acceptFilePKCS7WStr<'a, P0>(&self, wszpkcs7filename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).acceptFilePKCS7WStr)(::windows::core::Interface::as_raw(self), wszpkcs7filename.into()).ok()
    }
    pub unsafe fn createPKCS10WStr<'a, P0, P1>(&self, dnname: P0, usage: P1, ppkcs10blob: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).createPKCS10WStr)(::windows::core::Interface::as_raw(self), dnname.into(), usage.into(), ::core::mem::transmute(ppkcs10blob)).ok()
    }
    pub unsafe fn acceptPKCS7Blob(&self, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).acceptPKCS7Blob)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pblobpkcs7)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertContextFromPKCS7(&self, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> *mut super::CERT_CONTEXT {
        (::windows::core::Interface::vtable(self).getCertContextFromPKCS7)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pblobpkcs7))
    }
    pub unsafe fn getMyStore(&self) -> super::HCERTSTORE {
        (::windows::core::Interface::vtable(self).getMyStore)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn getCAStore(&self) -> super::HCERTSTORE {
        (::windows::core::Interface::vtable(self).getCAStore)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn getROOTHStore(&self) -> super::HCERTSTORE {
        (::windows::core::Interface::vtable(self).getROOTHStore)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn enumProvidersWStr(&self, dwindex: i32, dwflags: i32, pbstrprovname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).enumProvidersWStr)(::windows::core::Interface::as_raw(self), dwindex, dwflags, ::core::mem::transmute(pbstrprovname)).ok()
    }
    pub unsafe fn enumContainersWStr(&self, dwindex: i32, pbstr: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).enumContainersWStr)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(pbstr)).ok()
    }
    pub unsafe fn freeRequestInfoBlob(&self, pkcs7orpkcs10: super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).freeRequestInfoBlob)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pkcs7orpkcs10)).ok()
    }
    pub unsafe fn MyStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MyStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetMyStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetMyStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn MyStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MyStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetMyStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetMyStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn MyStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MyStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetMyStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMyStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn CAStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CAStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetCAStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCAStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn CAStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CAStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetCAStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCAStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn CAStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CAStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetCAStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCAStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn RootStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RootStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetRootStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetRootStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn RootStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RootStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetRootStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetRootStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn RootStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RootStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetRootStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRootStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn RequestStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RequestStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetRequestStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetRequestStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn RequestStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RequestStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetRequestStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetRequestStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn RequestStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RequestStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetRequestStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRequestStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn ContainerNameWStr(&self, szwcontainer: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ContainerNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwcontainer)).ok()
    }
    pub unsafe fn SetContainerNameWStr<'a, P0>(&self, szwcontainer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetContainerNameWStr)(::windows::core::Interface::as_raw(self), szwcontainer.into()).ok()
    }
    pub unsafe fn ProviderNameWStr(&self, szwprovider: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ProviderNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwprovider)).ok()
    }
    pub unsafe fn SetProviderNameWStr<'a, P0>(&self, szwprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetProviderNameWStr)(::windows::core::Interface::as_raw(self), szwprovider.into()).ok()
    }
    pub unsafe fn ProviderType(&self, pdwtype: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ProviderType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwtype)).ok()
    }
    pub unsafe fn SetProviderType(&self, dwtype: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProviderType)(::windows::core::Interface::as_raw(self), dwtype).ok()
    }
    pub unsafe fn KeySpec(&self, pdw: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdw)).ok()
    }
    pub unsafe fn SetKeySpec(&self, dw: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetKeySpec)(::windows::core::Interface::as_raw(self), dw).ok()
    }
    pub unsafe fn ProviderFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ProviderFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetProviderFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProviderFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseExistingKeySet(&self, fuseexistingkeys: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UseExistingKeySet)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fuseexistingkeys)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseExistingKeySet<'a, P0>(&self, fuseexistingkeys: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetUseExistingKeySet)(::windows::core::Interface::as_raw(self), fuseexistingkeys.into()).ok()
    }
    pub unsafe fn GenKeyFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GenKeyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetGenKeyFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetGenKeyFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRequestCert(&self, fdelete: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteRequestCert)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fdelete)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDeleteRequestCert<'a, P0>(&self, fdelete: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetDeleteRequestCert)(::windows::core::Interface::as_raw(self), fdelete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToUserDS(&self, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WriteCertToUserDS)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fbool)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToUserDS<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetWriteCertToUserDS)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableT61DNEncoding(&self, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnableT61DNEncoding)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fbool)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableT61DNEncoding<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetEnableT61DNEncoding)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToCSP(&self, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WriteCertToCSP)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fbool)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToCSP<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetWriteCertToCSP)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    pub unsafe fn SPCFileNameWStr(&self, szw: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SPCFileNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szw)).ok()
    }
    pub unsafe fn SetSPCFileNameWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetSPCFileNameWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    pub unsafe fn PVKFileNameWStr(&self, szw: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PVKFileNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szw)).ok()
    }
    pub unsafe fn SetPVKFileNameWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetPVKFileNameWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    pub unsafe fn HashAlgorithmWStr(&self, szw: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).HashAlgorithmWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szw)).ok()
    }
    pub unsafe fn SetHashAlgorithmWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetHashAlgorithmWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RenewalCertificate(&self, ppcertcontext: *mut *mut super::CERT_CONTEXT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RenewalCertificate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppcertcontext)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRenewalCertificate(&self, pcertcontext: *const super::CERT_CONTEXT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetRenewalCertificate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcertcontext)).ok()
    }
    pub unsafe fn AddCertTypeToRequestWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddCertTypeToRequestWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    pub unsafe fn AddNameValuePairToSignatureWStr<'a, P0, P1>(&self, name: P0, value: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddNameValuePairToSignatureWStr)(::windows::core::Interface::as_raw(self), name.into(), value.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddExtensionsToRequest(&self, pcertextensions: *mut super::CERT_EXTENSIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddExtensionsToRequest)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcertextensions)).ok()
    }
    pub unsafe fn AddAuthenticatedAttributesToPKCS7Request(&self, pattributes: *mut super::CRYPT_ATTRIBUTES) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddAuthenticatedAttributesToPKCS7Request)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pattributes)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreatePKCS7RequestFromRequest(&self, prequest: *mut super::CRYPTOAPI_BLOB, psigningcertcontext: *const super::CERT_CONTEXT, ppkcs7blob: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreatePKCS7RequestFromRequest)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(prequest), ::core::mem::transmute(psigningcertcontext), ::core::mem::transmute(ppkcs7blob)).ok()
    }
}
impl ::core::convert::From<IEnroll> for ::windows::core::IUnknown {
    fn from(value: IEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IEnroll> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IEnroll) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnroll> for ::windows::core::IUnknown {
    fn from(value: &IEnroll) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IEnroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnroll {}
impl ::core::fmt::Debug for IEnroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnroll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnroll {
    type Vtable = IEnroll_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xacaa7838_4585_11d1_ab57_00c04fc295e1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnroll_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub createFilePKCS10WStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dnname: ::windows::core::PCWSTR, usage: ::windows::core::PCWSTR, wszpkcs10filename: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub acceptFilePKCS7WStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszpkcs7filename: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub createPKCS10WStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dnname: ::windows::core::PCWSTR, usage: ::windows::core::PCWSTR, ppkcs10blob: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::HRESULT,
    pub acceptPKCS7Blob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub getCertContextFromPKCS7: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> *mut super::CERT_CONTEXT,
    #[cfg(not(feature = "Win32_Foundation"))]
    getCertContextFromPKCS7: usize,
    pub getMyStore: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::HCERTSTORE,
    pub getCAStore: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::HCERTSTORE,
    pub getROOTHStore: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::HCERTSTORE,
    pub enumProvidersWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: i32, dwflags: i32, pbstrprovname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub enumContainersWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: i32, pbstr: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub freeRequestInfoBlob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkcs7orpkcs10: super::CRYPTOAPI_BLOB) -> ::windows::core::HRESULT,
    pub MyStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetMyStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub MyStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetMyStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub MyStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetMyStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    pub CAStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetCAStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CAStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetCAStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CAStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetCAStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    pub RootStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetRootStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RootStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetRootStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RootStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetRootStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    pub RequestStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetRequestStoreNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RequestStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetRequestStoreTypeWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwtype: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RequestStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetRequestStoreFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    pub ContainerNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwcontainer: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetContainerNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwcontainer: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ProviderNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwprovider: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetProviderNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szwprovider: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ProviderType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwtype: *mut i32) -> ::windows::core::HRESULT,
    pub SetProviderType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtype: i32) -> ::windows::core::HRESULT,
    pub KeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdw: *mut i32) -> ::windows::core::HRESULT,
    pub SetKeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dw: i32) -> ::windows::core::HRESULT,
    pub ProviderFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetProviderFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UseExistingKeySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fuseexistingkeys: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UseExistingKeySet: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetUseExistingKeySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fuseexistingkeys: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetUseExistingKeySet: usize,
    pub GenKeyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut i32) -> ::windows::core::HRESULT,
    pub SetGenKeyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub DeleteRequestCert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdelete: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DeleteRequestCert: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDeleteRequestCert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdelete: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDeleteRequestCert: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub WriteCertToUserDS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WriteCertToUserDS: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetWriteCertToUserDS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetWriteCertToUserDS: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableT61DNEncoding: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableT61DNEncoding: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableT61DNEncoding: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableT61DNEncoding: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub WriteCertToCSP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WriteCertToCSP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetWriteCertToCSP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fbool: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetWriteCertToCSP: usize,
    pub SPCFileNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetSPCFileNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub PVKFileNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetPVKFileNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub HashAlgorithmWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetHashAlgorithmWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RenewalCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcertcontext: *mut *mut super::CERT_CONTEXT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RenewalCertificate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRenewalCertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcertcontext: *const super::CERT_CONTEXT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRenewalCertificate: usize,
    pub AddCertTypeToRequestWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szw: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddNameValuePairToSignatureWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: ::windows::core::PCWSTR, value: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub AddExtensionsToRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcertextensions: *mut super::CERT_EXTENSIONS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddExtensionsToRequest: usize,
    pub AddAuthenticatedAttributesToPKCS7Request: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pattributes: *mut super::CRYPT_ATTRIBUTES) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CreatePKCS7RequestFromRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prequest: *mut super::CRYPTOAPI_BLOB, psigningcertcontext: *const super::CERT_CONTEXT, ppkcs7blob: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreatePKCS7RequestFromRequest: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography_Certificates\"`*"]
#[repr(transparent)]
pub struct IEnroll2(::windows::core::IUnknown);
impl IEnroll2 {
    pub unsafe fn createFilePKCS10WStr<'a, P0, P1, P2>(&self, dnname: P0, usage: P1, wszpkcs10filename: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.createFilePKCS10WStr)(::windows::core::Interface::as_raw(self), dnname.into(), usage.into(), wszpkcs10filename.into()).ok()
    }
    pub unsafe fn acceptFilePKCS7WStr<'a, P0>(&self, wszpkcs7filename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.acceptFilePKCS7WStr)(::windows::core::Interface::as_raw(self), wszpkcs7filename.into()).ok()
    }
    pub unsafe fn createPKCS10WStr<'a, P0, P1>(&self, dnname: P0, usage: P1, ppkcs10blob: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.createPKCS10WStr)(::windows::core::Interface::as_raw(self), dnname.into(), usage.into(), ::core::mem::transmute(ppkcs10blob)).ok()
    }
    pub unsafe fn acceptPKCS7Blob(&self, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.acceptPKCS7Blob)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pblobpkcs7)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn getCertContextFromPKCS7(&self, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> *mut super::CERT_CONTEXT {
        (::windows::core::Interface::vtable(self).base__.getCertContextFromPKCS7)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pblobpkcs7))
    }
    pub unsafe fn getMyStore(&self) -> super::HCERTSTORE {
        (::windows::core::Interface::vtable(self).base__.getMyStore)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn getCAStore(&self) -> super::HCERTSTORE {
        (::windows::core::Interface::vtable(self).base__.getCAStore)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn getROOTHStore(&self) -> super::HCERTSTORE {
        (::windows::core::Interface::vtable(self).base__.getROOTHStore)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn enumProvidersWStr(&self, dwindex: i32, dwflags: i32, pbstrprovname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.enumProvidersWStr)(::windows::core::Interface::as_raw(self), dwindex, dwflags, ::core::mem::transmute(pbstrprovname)).ok()
    }
    pub unsafe fn enumContainersWStr(&self, dwindex: i32, pbstr: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.enumContainersWStr)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(pbstr)).ok()
    }
    pub unsafe fn freeRequestInfoBlob(&self, pkcs7orpkcs10: super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.freeRequestInfoBlob)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pkcs7orpkcs10)).ok()
    }
    pub unsafe fn MyStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.MyStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetMyStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetMyStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn MyStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.MyStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetMyStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetMyStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn MyStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.MyStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetMyStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetMyStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn CAStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CAStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetCAStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCAStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn CAStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CAStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetCAStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCAStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn CAStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CAStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetCAStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetCAStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn RootStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RootStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetRootStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRootStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn RootStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RootStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetRootStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRootStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn RootStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RootStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetRootStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRootStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn RequestStoreNameWStr(&self, szwname: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RequestStoreNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwname)).ok()
    }
    pub unsafe fn SetRequestStoreNameWStr<'a, P0>(&self, szwname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRequestStoreNameWStr)(::windows::core::Interface::as_raw(self), szwname.into()).ok()
    }
    pub unsafe fn RequestStoreTypeWStr(&self, szwtype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RequestStoreTypeWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwtype)).ok()
    }
    pub unsafe fn SetRequestStoreTypeWStr<'a, P0>(&self, szwtype: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetRequestStoreTypeWStr)(::windows::core::Interface::as_raw(self), szwtype.into()).ok()
    }
    pub unsafe fn RequestStoreFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RequestStoreFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetRequestStoreFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRequestStoreFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn ContainerNameWStr(&self, szwcontainer: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ContainerNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwcontainer)).ok()
    }
    pub unsafe fn SetContainerNameWStr<'a, P0>(&self, szwcontainer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetContainerNameWStr)(::windows::core::Interface::as_raw(self), szwcontainer.into()).ok()
    }
    pub unsafe fn ProviderNameWStr(&self, szwprovider: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ProviderNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szwprovider)).ok()
    }
    pub unsafe fn SetProviderNameWStr<'a, P0>(&self, szwprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetProviderNameWStr)(::windows::core::Interface::as_raw(self), szwprovider.into()).ok()
    }
    pub unsafe fn ProviderType(&self, pdwtype: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ProviderType)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwtype)).ok()
    }
    pub unsafe fn SetProviderType(&self, dwtype: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetProviderType)(::windows::core::Interface::as_raw(self), dwtype).ok()
    }
    pub unsafe fn KeySpec(&self, pdw: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.KeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdw)).ok()
    }
    pub unsafe fn SetKeySpec(&self, dw: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetKeySpec)(::windows::core::Interface::as_raw(self), dw).ok()
    }
    pub unsafe fn ProviderFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ProviderFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetProviderFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetProviderFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseExistingKeySet(&self, fuseexistingkeys: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UseExistingKeySet)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fuseexistingkeys)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseExistingKeySet<'a, P0>(&self, fuseexistingkeys: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetUseExistingKeySet)(::windows::core::Interface::as_raw(self), fuseexistingkeys.into()).ok()
    }
    pub unsafe fn GenKeyFlags(&self, pdwflags: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GenKeyFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags)).ok()
    }
    pub unsafe fn SetGenKeyFlags(&self, dwflags: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetGenKeyFlags)(::windows::core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteRequestCert(&self, fdelete: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.DeleteRequestCert)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fdelete)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDeleteRequestCert<'a, P0>(&self, fdelete: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetDeleteRequestCert)(::windows::core::Interface::as_raw(self), fdelete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToUserDS(&self, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.WriteCertToUserDS)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fbool)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToUserDS<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetWriteCertToUserDS)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableT61DNEncoding(&self, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.EnableT61DNEncoding)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fbool)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableT61DNEncoding<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetEnableT61DNEncoding)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WriteCertToCSP(&self, fbool: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.WriteCertToCSP)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fbool)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWriteCertToCSP<'a, P0>(&self, fbool: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetWriteCertToCSP)(::windows::core::Interface::as_raw(self), fbool.into()).ok()
    }
    pub unsafe fn SPCFileNameWStr(&self, szw: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SPCFileNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szw)).ok()
    }
    pub unsafe fn SetSPCFileNameWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetSPCFileNameWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    pub unsafe fn PVKFileNameWStr(&self, szw: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.PVKFileNameWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szw)).ok()
    }
    pub unsafe fn SetPVKFileNameWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetPVKFileNameWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    pub unsafe fn HashAlgorithmWStr(&self, szw: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.HashAlgorithmWStr)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(szw)).ok()
    }
    pub unsafe fn SetHashAlgorithmWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetHashAlgorithmWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RenewalCertificate(&self, ppcertcontext: *mut *mut super::CERT_CONTEXT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.RenewalCertificate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppcertcontext)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRenewalCertificate(&self, pcertcontext: *const super::CERT_CONTEXT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetRenewalCertificate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcertcontext)).ok()
    }
    pub unsafe fn AddCertTypeToRequestWStr<'a, P0>(&self, szw: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.AddCertTypeToRequestWStr)(::windows::core::Interface::as_raw(self), szw.into()).ok()
    }
    pub unsafe fn AddNameValuePairToSignatureWStr<'a, P0, P1>(&self, name: P0, value: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.AddNameValuePairToSignatureWStr)(::windows::core::Interface::as_raw(self), name.into(), value.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddExtensionsToRequest(&self, pcertextensions: *mut super::CERT_EXTENSIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.AddExtensionsToRequest)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcertextensions)).ok()
    }
    pub unsafe fn AddAuthenticatedAttributesToPKCS7Request(&self, pattributes: *mut super::CRYPT_ATTRIBUTES) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.AddAuthenticatedAttributesToPKCS7Request)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pattributes)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreatePKCS7RequestFromRequest(&self, prequest: *mut super::CRYPTOAPI_BLOB, psigningcertcontext: *const super::CERT_CONTEXT, ppkcs7blob: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CreatePKCS7RequestFromRequest)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(prequest), ::core::mem::transmute(psigningcertcontext), ::core::mem::transmute(ppkcs7blob)).ok()
    }
    pub unsafe fn InstallPKCS7Blob(&self, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InstallPKCS7Blob)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pblobpkcs7)).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetSupportedKeySpec(&self, pdwkeyspec: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSupportedKeySpec)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwkeyspec)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKeyLen<'a, P0, P1>(&self, fmin: P0, fexchange: P1, pdwkeysize: *mut i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).GetKeyLen)(::windows::core::Interface::as_raw(self), fmin.into(), fexchange.into(), ::core::mem::transmute(pdwkeysize)).ok()
    }
    pub unsafe fn EnumAlgs(&self, dwindex: i32, algclass: i32, pdwalgid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnumAlgs)(::windows::core::Interface::as_raw(self), dwindex, algclass, ::core::mem::transmute(pdwalgid)).ok()
    }
    pub unsafe fn GetAlgNameWStr(&self, algid: i32, ppwsz: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAlgNameWStr)(::windows::core::Interface::as_raw(self), algid, ::core::mem::transmute(ppwsz)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetReuseHardwareKeyIfUnableToGenNew<'a, P0>(&self, freusehardwarekeyifunabletogennew: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetReuseHardwareKeyIfUnableToGenNew)(::windows::core::Interface::as_raw(self), freusehardwarekeyifunabletogennew.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReuseHardwareKeyIfUnableToGenNew(&self, freusehardwarekeyifunabletogennew: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReuseHardwareKeyIfUnableToGenNew)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(freusehardwarekeyifunabletogennew)).ok()
    }
    pub unsafe fn SetHashAlgID(&self, hashalgid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetHashAlgID)(::windows::core::Interface::as_raw(self), hashalgid).ok()
    }
    pub unsafe fn HashAlgID(&self, hashalgid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).HashAlgID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(hashalgid)).ok()
    }
    pub unsafe fn SetHStoreMy<'a, P0>(&self, hstore: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::HCERTSTORE>,
    {
        (::windows::core::Interface::vtable(self).SetHStoreMy)(::windows::core::Interface::as_raw(self), hstore.into()).ok()
    }
    pub unsafe fn SetHStoreCA<'a, P0>(&self, hstore: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::HCERTSTORE>,
    {
        (::windows::core::Interface::vtable(self).SetHStoreCA)(::windows::core::Interface::as_raw(self), hstore.into()).ok()
    }
    pub unsafe fn SetHStoreROOT<'a, P0>(&self, hstore: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::HCERTSTORE>,
    {
        (::windows::core::Interface::vtable(self).SetHStoreROOT)(::windows::core::Interface::as_raw(self), hstore.into()).ok()
    }
    pub unsafe fn SetHStoreRequest<'a, P0>(&self, hstore: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::HCERTSTORE>,
    {
        (::windows::core::Interface::vtable(self).SetHStoreRequest)(::windows::core::Interface::as_raw(self), hstore.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLimitExchangeKeyToEncipherment<'a, P0>(&self, flimitexchangekeytoencipherment: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetLimitExchangeKeyToEncipherment)(::windows::core::Interface::as_raw(self), flimitexchangekeytoencipherment.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LimitExchangeKeyToEncipherment(&self, flimitexchangekeytoencipherment: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LimitExchangeKeyToEncipherment)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(flimitexchangekeytoencipherment)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSMIMECapabilities<'a, P0>(&self, fenablesmimecapabilities: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetEnableSMIMECapabilities)(::windows::core::Interface::as_raw(self), fenablesmimecapabilities.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableSMIMECapabilities(&self, fenablesmimecapabilities: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EnableSMIMECapabilities)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(fenablesmimecapabilities)).ok()
    }
}
impl ::core::convert::From<IEnroll2> for ::windows::core::IUnknown {
    fn from(value: IEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IEnroll2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnroll2> for ::windows::core::IUnknown {
    fn from(value: &IEnroll2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IEnroll2> for IEnroll {
    fn from(value: IEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IEnroll2> for &'a IEnroll {
    fn from(value: &'a IEnroll2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IEnroll2> for IEnroll {
    fn from(value: &IEnroll2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IEnroll2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnroll2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnroll2 {}
impl ::core::fmt::Debug for IEnroll2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnroll2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IEnroll2 {
    type Vtable = IEnroll2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc080e199_b7df_11d2_a421_00c04f79fe8e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnroll2_Vtbl {
    pub base__: IEnroll_Vtbl,
    pub InstallPKCS7Blob: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pblobpkcs7: *mut super::CRYPTOAPI_BLOB) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSupportedKeySpec: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwkeyspec: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetKeyLen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fmin: super::super::super::Foundation::BOOL, fexchange: super::super::super::Foundation::BOOL, pdwkeysize: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetKeyLen: usize,
    pub EnumAlgs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: i32, algclass: i32, pdwalgid: *mut i32) -> ::windows::core::HRESULT,
    pub GetAlgNameWStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, algid: i32, ppwsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetReuseHardwareKeyIfUnableToGenNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, freusehardwarekeyifunabletogennew: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetReuseHardwareKeyIfUnableToGenNew: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ReuseHardwareKeyIfUnableToGenNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, freusehardwarekeyifunabletogennew: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ReuseHardwareKeyIfUnableToGenNew: usize,
    pub SetHashAlgID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hashalgid: i32) -> ::windows::core::HRESULT,
    pub HashAlgID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hashalgid: *mut i32) -> ::windows::core::HRESULT,
    pub SetHStoreMy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hstore: super::HCERTSTORE) -> ::windows::core::HRESULT,
    pub SetHStoreCA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hstore: super::HCERTSTORE) -> ::windows::core::HRESULT,
    pub SetHStoreROOT: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hstore: super::HCERTSTORE) -> ::windows::core::HRESULT,
    pub SetHStoreRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hstore: super::HCERTSTORE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetLimitExchangeKeyToEncipherment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flimitexchangekeytoencipherment: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetLimitExchangeKeyToEncipherment: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub LimitExchangeKeyToEncipherment: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flimitexchangekeytoencipherment: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LimitExchangeKeyToEncipherment: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableSMIMECapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenablesmimecapabilities: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableSMIMECapabilities: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableSMIMECapabilities: unsafe extern "system" fn(th