#[cfg(feature = "Win32_UI_Shell_Common")]
pub mod Common;
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
pub mod PropertiesSystem;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct AASHELLMENUFILENAME {
    pub cbTotal: i16,
    pub rgbReserved: [u8; 12],
    pub szFileName: [u16; 1],
}
impl ::core::marker::Copy for AASHELLMENUFILENAME {}
impl ::core::clone::Clone for AASHELLMENUFILENAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AASHELLMENUFILENAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AASHELLMENUFILENAME").field("cbTotal", &self.cbTotal).field("rgbReserved", &self.rgbReserved).field("szFileName", &self.szFileName).finish()
    }
}
unsafe impl ::windows::core::Abi for AASHELLMENUFILENAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AASHELLMENUFILENAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AASHELLMENUFILENAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for AASHELLMENUFILENAME {}
impl ::core::default::Default for AASHELLMENUFILENAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct AASHELLMENUITEM {
    pub lpReserved1: *mut ::core::ffi::c_void,
    pub iReserved: i32,
    pub uiReserved: u32,
    pub lpName: *mut AASHELLMENUFILENAME,
    pub psz: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for AASHELLMENUITEM {}
impl ::core::clone::Clone for AASHELLMENUITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AASHELLMENUITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AASHELLMENUITEM").field("lpReserved1", &self.lpReserved1).field("iReserved", &self.iReserved).field("uiReserved", &self.uiReserved).field("lpName", &self.lpName).field("psz", &self.psz).finish()
    }
}
unsafe impl ::windows::core::Abi for AASHELLMENUITEM {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AASHELLMENUITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AASHELLMENUITEM>()) == 0 }
    }
}
impl ::core::cmp::Eq for AASHELLMENUITEM {}
impl ::core::default::Default for AASHELLMENUITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABE_BOTTOM: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABE_LEFT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABE_RIGHT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABE_TOP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_ACTIVATE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_GETAUTOHIDEBAR: u32 = 7u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_GETAUTOHIDEBAREX: u32 = 11u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_GETSTATE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_GETTASKBARPOS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_NEW: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_QUERYPOS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_REMOVE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_SETAUTOHIDEBAR: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_SETAUTOHIDEBAREX: u32 = 12u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_SETPOS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_SETSTATE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABM_WINDOWPOSCHANGED: u32 = 9u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABN_FULLSCREENAPP: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABN_POSCHANGED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABN_STATECHANGE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABN_WINDOWARRANGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABS_ALWAYSONTOP: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ABS_AUTOHIDE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACDD_VISIBLE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ACENUMOPTION(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACEO_NONE: ACENUMOPTION = ACENUMOPTION(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACEO_MOSTRECENTFIRST: ACENUMOPTION = ACENUMOPTION(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACEO_FIRSTUNUSED: ACENUMOPTION = ACENUMOPTION(65536i32);
impl ::core::marker::Copy for ACENUMOPTION {}
impl ::core::clone::Clone for ACENUMOPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ACENUMOPTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ACENUMOPTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for ACENUMOPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ACENUMOPTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ACTIVATEOPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AO_NONE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AO_DESIGNMODE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AO_NOERRORUI: ACTIVATEOPTIONS = ACTIVATEOPTIONS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AO_NOSPLASHSCREEN: ACTIVATEOPTIONS = ACTIVATEOPTIONS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AO_PRELAUNCH: ACTIVATEOPTIONS = ACTIVATEOPTIONS(33554432i32);
impl ::core::marker::Copy for ACTIVATEOPTIONS {}
impl ::core::clone::Clone for ACTIVATEOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ACTIVATEOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ACTIVATEOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for ACTIVATEOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ACTIVATEOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ADDURL_SILENT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ADJACENT_DISPLAY_EDGES(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ADE_NONE: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ADE_LEFT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ADE_RIGHT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(2i32);
impl ::core::marker::Copy for ADJACENT_DISPLAY_EDGES {}
impl ::core::clone::Clone for ADJACENT_DISPLAY_EDGES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ADJACENT_DISPLAY_EDGES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ADJACENT_DISPLAY_EDGES {
    type Abi = Self;
}
impl ::core::fmt::Debug for ADJACENT_DISPLAY_EDGES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ADJACENT_DISPLAY_EDGES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_APPLY_BUFFERED_REFRESH: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_APPLY_DYNAMICREFRESH: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_APPLY_FORCE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_APPLY_HTMLGEN: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_APPLY_REFRESH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_APPLY_SAVE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_GETWP_BMP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_GETWP_IMAGE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AD_GETWP_LAST_APPLIED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AHE_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHE_DESKTOP: AHE_TYPE = AHE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHE_IMMERSIVE: AHE_TYPE = AHE_TYPE(1i32);
impl ::core::marker::Copy for AHE_TYPE {}
impl ::core::clone::Clone for AHE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AHE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AHE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for AHE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AHE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AHTYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_UNDEFINED: AHTYPE = AHTYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_USER_APPLICATION: AHTYPE = AHTYPE(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_ANY_APPLICATION: AHTYPE = AHTYPE(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_MACHINEDEFAULT: AHTYPE = AHTYPE(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_PROGID: AHTYPE = AHTYPE(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_APPLICATION: AHTYPE = AHTYPE(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_CLASS_APPLICATION: AHTYPE = AHTYPE(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AHTYPE_ANY_PROGID: AHTYPE = AHTYPE(512i32);
impl ::core::marker::Copy for AHTYPE {}
impl ::core::clone::Clone for AHTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AHTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AHTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for AHTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AHTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPACTIONFLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_INSTALL: APPACTIONFLAGS = APPACTIONFLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_UNINSTALL: APPACTIONFLAGS = APPACTIONFLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_MODIFY: APPACTIONFLAGS = APPACTIONFLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_REPAIR: APPACTIONFLAGS = APPACTIONFLAGS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_UPGRADE: APPACTIONFLAGS = APPACTIONFLAGS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_CANGETSIZE: APPACTIONFLAGS = APPACTIONFLAGS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_MODIFYREMOVE: APPACTIONFLAGS = APPACTIONFLAGS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_ADDLATER: APPACTIONFLAGS = APPACTIONFLAGS(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPACTION_UNSCHEDULE: APPACTIONFLAGS = APPACTIONFLAGS(512i32);
impl ::core::marker::Copy for APPACTIONFLAGS {}
impl ::core::clone::Clone for APPACTIONFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPACTIONFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPACTIONFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPACTIONFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPACTIONFLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPBARDATA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPBARDATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPBARDATA {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPBARDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPBARDATA>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPBARDATA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPBARDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPBARDATA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPBARDATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPBARDATA {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPBARDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPBARDATA>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPBARDATA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPBARDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct APPCATEGORYINFO {
    pub Locale: u32,
    pub pszDescription: ::windows::core::PWSTR,
    pub AppCategoryId: ::windows::core::GUID,
}
impl ::core::marker::Copy for APPCATEGORYINFO {}
impl ::core::clone::Clone for APPCATEGORYINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for APPCATEGORYINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("APPCATEGORYINFO").field("Locale", &self.Locale).field("pszDescription", &self.pszDescription).field("AppCategoryId", &self.AppCategoryId).finish()
    }
}
unsafe impl ::windows::core::Abi for APPCATEGORYINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for APPCATEGORYINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPCATEGORYINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for APPCATEGORYINFO {}
impl ::core::default::Default for APPCATEGORYINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct APPCATEGORYINFOLIST {
    pub cCategory: u32,
    pub pCategoryInfo: *mut APPCATEGORYINFO,
}
impl ::core::marker::Copy for APPCATEGORYINFOLIST {}
impl ::core::clone::Clone for APPCATEGORYINFOLIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for APPCATEGORYINFOLIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("APPCATEGORYINFOLIST").field("cCategory", &self.cCategory).field("pCategoryInfo", &self.pCategoryInfo).finish()
    }
}
unsafe impl ::windows::core::Abi for APPCATEGORYINFOLIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for APPCATEGORYINFOLIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPCATEGORYINFOLIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for APPCATEGORYINFOLIST {}
impl ::core::default::Default for APPCATEGORYINFOLIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPDOCLISTTYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ADLT_RECENT: APPDOCLISTTYPE = APPDOCLISTTYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ADLT_FREQUENT: APPDOCLISTTYPE = APPDOCLISTTYPE(1i32);
impl ::core::marker::Copy for APPDOCLISTTYPE {}
impl ::core::clone::Clone for APPDOCLISTTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPDOCLISTTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPDOCLISTTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPDOCLISTTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPDOCLISTTYPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct APPINFODATA {
    pub cbSize: u32,
    pub dwMask: u32,
    pub pszDisplayName: ::windows::core::PWSTR,
    pub pszVersion: ::windows::core::PWSTR,
    pub pszPublisher: ::windows::core::PWSTR,
    pub pszProductID: ::windows::core::PWSTR,
    pub pszRegisteredOwner: ::windows::core::PWSTR,
    pub pszRegisteredCompany: ::windows::core::PWSTR,
    pub pszLanguage: ::windows::core::PWSTR,
    pub pszSupportUrl: ::windows::core::PWSTR,
    pub pszSupportTelephone: ::windows::core::PWSTR,
    pub pszHelpLink: ::windows::core::PWSTR,
    pub pszInstallLocation: ::windows::core::PWSTR,
    pub pszInstallSource: ::windows::core::PWSTR,
    pub pszInstallDate: ::windows::core::PWSTR,
    pub pszContact: ::windows::core::PWSTR,
    pub pszComments: ::windows::core::PWSTR,
    pub pszImage: ::windows::core::PWSTR,
    pub pszReadmeUrl: ::windows::core::PWSTR,
    pub pszUpdateInfoUrl: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for APPINFODATA {}
impl ::core::clone::Clone for APPINFODATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for APPINFODATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("APPINFODATA")
            .field("cbSize", &self.cbSize)
            .field("dwMask", &self.dwMask)
            .field("pszDisplayName", &self.pszDisplayName)
            .field("pszVersion", &self.pszVersion)
            .field("pszPublisher", &self.pszPublisher)
            .field("pszProductID", &self.pszProductID)
            .field("pszRegisteredOwner", &self.pszRegisteredOwner)
            .field("pszRegisteredCompany", &self.pszRegisteredCompany)
            .field("pszLanguage", &self.pszLanguage)
            .field("pszSupportUrl", &self.pszSupportUrl)
            .field("pszSupportTelephone", &self.pszSupportTelephone)
            .field("pszHelpLink", &self.pszHelpLink)
            .field("pszInstallLocation", &self.pszInstallLocation)
            .field("pszInstallSource", &self.pszInstallSource)
            .field("pszInstallDate", &self.pszInstallDate)
            .field("pszContact", &self.pszContact)
            .field("pszComments", &self.pszComments)
            .field("pszImage", &self.pszImage)
            .field("pszReadmeUrl", &self.pszReadmeUrl)
            .field("pszUpdateInfoUrl", &self.pszUpdateInfoUrl)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for APPINFODATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for APPINFODATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPINFODATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for APPINFODATA {}
impl ::core::default::Default for APPINFODATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPINFODATAFLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_DISPLAYNAME: APPINFODATAFLAGS = APPINFODATAFLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_VERSION: APPINFODATAFLAGS = APPINFODATAFLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_PUBLISHER: APPINFODATAFLAGS = APPINFODATAFLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_PRODUCTID: APPINFODATAFLAGS = APPINFODATAFLAGS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_REGISTEREDOWNER: APPINFODATAFLAGS = APPINFODATAFLAGS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_REGISTEREDCOMPANY: APPINFODATAFLAGS = APPINFODATAFLAGS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_LANGUAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_SUPPORTURL: APPINFODATAFLAGS = APPINFODATAFLAGS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_SUPPORTTELEPHONE: APPINFODATAFLAGS = APPINFODATAFLAGS(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_HELPLINK: APPINFODATAFLAGS = APPINFODATAFLAGS(512i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_INSTALLLOCATION: APPINFODATAFLAGS = APPINFODATAFLAGS(1024i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_INSTALLSOURCE: APPINFODATAFLAGS = APPINFODATAFLAGS(2048i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_INSTALLDATE: APPINFODATAFLAGS = APPINFODATAFLAGS(4096i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_CONTACT: APPINFODATAFLAGS = APPINFODATAFLAGS(16384i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_COMMENTS: APPINFODATAFLAGS = APPINFODATAFLAGS(32768i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_IMAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(131072i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_READMEURL: APPINFODATAFLAGS = APPINFODATAFLAGS(262144i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AIM_UPDATEINFOURL: APPINFODATAFLAGS = APPINFODATAFLAGS(524288i32);
impl ::core::marker::Copy for APPINFODATAFLAGS {}
impl ::core::clone::Clone for APPINFODATAFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPINFODATAFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPINFODATAFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPINFODATAFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPINFODATAFLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub type APPLET_PROC = ::core::option::Option<unsafe extern "system" fn(hwndcpl: super::super::Foundation::HWND, msg: u32, lparam1: super::super::Foundation::LPARAM, lparam2: super::super::Foundation::LPARAM) -> i32>;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPLICATION_VIEW_MIN_WIDTH(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVMW_DEFAULT: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVMW_320: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVMW_500: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(2i32);
impl ::core::marker::Copy for APPLICATION_VIEW_MIN_WIDTH {}
impl ::core::clone::Clone for APPLICATION_VIEW_MIN_WIDTH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_MIN_WIDTH {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_MIN_WIDTH {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_MIN_WIDTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_MIN_WIDTH").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPLICATION_VIEW_ORIENTATION(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVO_LANDSCAPE: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVO_PORTRAIT: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(1i32);
impl ::core::marker::Copy for APPLICATION_VIEW_ORIENTATION {}
impl ::core::clone::Clone for APPLICATION_VIEW_ORIENTATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_ORIENTATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_ORIENTATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_ORIENTATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_ORIENTATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPLICATION_VIEW_SIZE_PREFERENCE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_DEFAULT: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_USE_LESS: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_USE_HALF: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_USE_MORE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_USE_MINIMUM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_USE_NONE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVSP_CUSTOM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(6i32);
impl ::core::marker::Copy for APPLICATION_VIEW_SIZE_PREFERENCE {}
impl ::core::clone::Clone for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_SIZE_PREFERENCE {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_SIZE_PREFERENCE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct APPLICATION_VIEW_STATE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVS_FULLSCREEN_LANDSCAPE: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVS_FILLED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVS_SNAPPED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AVS_FULLSCREEN_PORTRAIT: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(3i32);
impl ::core::marker::Copy for APPLICATION_VIEW_STATE {}
impl ::core::clone::Clone for APPLICATION_VIEW_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const APPNAMEBUFFERLEN: u32 = 40u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_AUDIOCD: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_AUTOPLAYMUSIC: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_AUTOPLAYPIX: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_AUTOPLAYVIDEO: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_AUTORUNINF: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_BLANKBD: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_BLANKCD: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_BLANKDVD: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_BLURAY: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_CAMERASTORAGE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_CUSTOMEVENT: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_DVDAUDIO: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_DVDMOVIE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_MASK: u32 = 131070u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_PHASE_FINAL: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_PHASE_MASK: u32 = 1879048192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_PHASE_PRESNIFF: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_PHASE_SNIFFING: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_PHASE_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_SVCD: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_UNKNOWNCONTENT: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ARCONTENT_VCD: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCCLASS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_SHELL_KEY: ASSOCCLASS = ASSOCCLASS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_PROGID_KEY: ASSOCCLASS = ASSOCCLASS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_PROGID_STR: ASSOCCLASS = ASSOCCLASS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_CLSID_KEY: ASSOCCLASS = ASSOCCLASS(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_CLSID_STR: ASSOCCLASS = ASSOCCLASS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_APP_KEY: ASSOCCLASS = ASSOCCLASS(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_APP_STR: ASSOCCLASS = ASSOCCLASS(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_SYSTEM_STR: ASSOCCLASS = ASSOCCLASS(7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_FOLDER: ASSOCCLASS = ASSOCCLASS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_STAR: ASSOCCLASS = ASSOCCLASS(9i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_FIXED_PROGID_STR: ASSOCCLASS = ASSOCCLASS(10i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCCLASS_PROTOCOL_STR: ASSOCCLASS = ASSOCCLASS(11i32);
impl ::core::marker::Copy for ASSOCCLASS {}
impl ::core::clone::Clone for ASSOCCLASS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCCLASS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCCLASS {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCCLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCCLASS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCDATA(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_MSIDESCRIPTOR: ASSOCDATA = ASSOCDATA(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_NOACTIVATEHANDLER: ASSOCDATA = ASSOCDATA(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_UNUSED1: ASSOCDATA = ASSOCDATA(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_HASPERUSERASSOC: ASSOCDATA = ASSOCDATA(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_EDITFLAGS: ASSOCDATA = ASSOCDATA(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_VALUE: ASSOCDATA = ASSOCDATA(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCDATA_MAX: ASSOCDATA = ASSOCDATA(7i32);
impl ::core::marker::Copy for ASSOCDATA {}
impl ::core::clone::Clone for ASSOCDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCDATA {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCDATA {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCDATA").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCENUM(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCENUM_NONE: ASSOCENUM = ASSOCENUM(0i32);
impl ::core::marker::Copy for ASSOCENUM {}
impl ::core::clone::Clone for ASSOCENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_APP_TO_APP: i32 = 65536i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_IGNOREBASECLASS: i32 = 512i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_BYEXENAME: i32 = 2i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_DEFAULTTOFOLDER: i32 = 8i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_DEFAULTTOSTAR: i32 = 4i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_FIXED_PROGID: i32 = 2048i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_FOR_FILE: i32 = 8192i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_IGNOREUNKNOWN: i32 = 1024i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_INIT_NOREMAPCLSID: i32 = 1i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_IS_FULL_URI: i32 = 16384i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_IS_PROTOCOL: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_NOFIXUPS: i32 = 256i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_NONE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_NOTRUNCATE: i32 = 32i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_NOUSERSETTINGS: i32 = 16i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_OPEN_BYEXENAME: i32 = 2i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_PER_MACHINE_ONLY: i32 = 32768i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_REMAPRUNDLL: i32 = 128i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCF_VERIFY: i32 = 64i32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: ::windows::core::PCWSTR,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::marker::Copy for ASSOCIATIONELEMENT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::clone::Clone for ASSOCIATIONELEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
unsafe impl ::windows::core::Abi for ASSOCIATIONELEMENT {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::cmp::PartialEq for ASSOCIATIONELEMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ASSOCIATIONELEMENT>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::cmp::Eq for ASSOCIATIONELEMENT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::default::Default for ASSOCIATIONELEMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: ::windows::core::PCWSTR,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::marker::Copy for ASSOCIATIONELEMENT {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::clone::Clone for ASSOCIATIONELEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
unsafe impl ::windows::core::Abi for ASSOCIATIONELEMENT {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::cmp::PartialEq for ASSOCIATIONELEMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ASSOCIATIONELEMENT>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::cmp::Eq for ASSOCIATIONELEMENT {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
impl ::core::default::Default for ASSOCIATIONELEMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCIATIONLEVEL(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AL_MACHINE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AL_EFFECTIVE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AL_USER: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(2i32);
impl ::core::marker::Copy for ASSOCIATIONLEVEL {}
impl ::core::clone::Clone for ASSOCIATIONLEVEL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCIATIONLEVEL {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCIATIONLEVEL {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCIATIONLEVEL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCIATIONLEVEL").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCIATIONTYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AT_FILEEXTENSION: ASSOCIATIONTYPE = ASSOCIATIONTYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AT_URLPROTOCOL: ASSOCIATIONTYPE = ASSOCIATIONTYPE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AT_STARTMENUCLIENT: ASSOCIATIONTYPE = ASSOCIATIONTYPE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const AT_MIMETYPE: ASSOCIATIONTYPE = ASSOCIATIONTYPE(3i32);
impl ::core::marker::Copy for ASSOCIATIONTYPE {}
impl ::core::clone::Clone for ASSOCIATIONTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCIATIONTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCIATIONTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCIATIONTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCIATIONTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCKEY(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCKEY_SHELLEXECCLASS: ASSOCKEY = ASSOCKEY(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCKEY_APP: ASSOCKEY = ASSOCKEY(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCKEY_CLASS: ASSOCKEY = ASSOCKEY(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCKEY_BASECLASS: ASSOCKEY = ASSOCKEY(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCKEY_MAX: ASSOCKEY = ASSOCKEY(5i32);
impl ::core::marker::Copy for ASSOCKEY {}
impl ::core::clone::Clone for ASSOCKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCKEY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCKEY {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCKEY").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOCSTR(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_COMMAND: ASSOCSTR = ASSOCSTR(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_EXECUTABLE: ASSOCSTR = ASSOCSTR(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_FRIENDLYDOCNAME: ASSOCSTR = ASSOCSTR(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_FRIENDLYAPPNAME: ASSOCSTR = ASSOCSTR(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_NOOPEN: ASSOCSTR = ASSOCSTR(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_SHELLNEWVALUE: ASSOCSTR = ASSOCSTR(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DDECOMMAND: ASSOCSTR = ASSOCSTR(7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DDEIFEXEC: ASSOCSTR = ASSOCSTR(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DDEAPPLICATION: ASSOCSTR = ASSOCSTR(9i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DDETOPIC: ASSOCSTR = ASSOCSTR(10i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_INFOTIP: ASSOCSTR = ASSOCSTR(11i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_QUICKTIP: ASSOCSTR = ASSOCSTR(12i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_TILEINFO: ASSOCSTR = ASSOCSTR(13i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_CONTENTTYPE: ASSOCSTR = ASSOCSTR(14i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DEFAULTICON: ASSOCSTR = ASSOCSTR(15i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_SHELLEXTENSION: ASSOCSTR = ASSOCSTR(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DROPTARGET: ASSOCSTR = ASSOCSTR(17i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_DELEGATEEXECUTE: ASSOCSTR = ASSOCSTR(18i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_SUPPORTED_URI_PROTOCOLS: ASSOCSTR = ASSOCSTR(19i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_PROGID: ASSOCSTR = ASSOCSTR(20i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_APPID: ASSOCSTR = ASSOCSTR(21i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_APPPUBLISHER: ASSOCSTR = ASSOCSTR(22i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_APPICONREFERENCE: ASSOCSTR = ASSOCSTR(23i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOCSTR_MAX: ASSOCSTR = ASSOCSTR(24i32);
impl ::core::marker::Copy for ASSOCSTR {}
impl ::core::clone::Clone for ASSOCSTR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCSTR {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCSTR {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCSTR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCSTR").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ASSOC_FILTER(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOC_FILTER_NONE: ASSOC_FILTER = ASSOC_FILTER(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ASSOC_FILTER_RECOMMENDED: ASSOC_FILTER = ASSOC_FILTER(1i32);
impl ::core::marker::Copy for ASSOC_FILTER {}
impl ::core::clone::Clone for ASSOC_FILTER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOC_FILTER {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOC_FILTER {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOC_FILTER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOC_FILTER").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ATTACHMENT_ACTION(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_ACTION_CANCEL: ATTACHMENT_ACTION = ATTACHMENT_ACTION(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_ACTION_SAVE: ATTACHMENT_ACTION = ATTACHMENT_ACTION(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_ACTION_EXEC: ATTACHMENT_ACTION = ATTACHMENT_ACTION(2i32);
impl ::core::marker::Copy for ATTACHMENT_ACTION {}
impl ::core::clone::Clone for ATTACHMENT_ACTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ATTACHMENT_ACTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ATTACHMENT_ACTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for ATTACHMENT_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ATTACHMENT_ACTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ATTACHMENT_PROMPT(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_PROMPT_NONE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_PROMPT_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_PROMPT_EXEC: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ATTACHMENT_PROMPT_EXEC_OR_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(3i32);
impl ::core::marker::Copy for ATTACHMENT_PROMPT {}
impl ::core::clone::Clone for ATTACHMENT_PROMPT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ATTACHMENT_PROMPT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ATTACHMENT_PROMPT {
    type Abi = Self;
}
impl ::core::fmt::Debug for ATTACHMENT_PROMPT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ATTACHMENT_PROMPT").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AUTOCOMPLETELISTOPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_NONE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_CURRENTDIR: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_MYCOMPUTER: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_DESKTOP: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_FAVORITES: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_FILESYSONLY: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_FILESYSDIRS: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACLO_VIRTUALNAMESPACE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(64i32);
impl ::core::marker::Copy for AUTOCOMPLETELISTOPTIONS {}
impl ::core::clone::Clone for AUTOCOMPLETELISTOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AUTOCOMPLETELISTOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AUTOCOMPLETELISTOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for AUTOCOMPLETELISTOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AUTOCOMPLETELISTOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AUTOCOMPLETEOPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_NONE: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_AUTOSUGGEST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_AUTOAPPEND: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_SEARCH: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_FILTERPREFIXES: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_USETAB: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_UPDOWNKEYDROPSLIST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_RTLREADING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_WORD_FILTER: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ACO_NOPREFIXFILTERING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(256i32);
impl ::core::marker::Copy for AUTOCOMPLETEOPTIONS {}
impl ::core::clone::Clone for AUTOCOMPLETEOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AUTOCOMPLETEOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AUTOCOMPLETEOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for AUTOCOMPLETEOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AUTOCOMPLETEOPTIONS").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AUTO_SCROLL_DATA {
    pub iNextSample: i32,
    pub dwLastScroll: u32,
    pub bFull: super::super::Foundation::BOOL,
    pub pts: [super::super::Foundation::POINT; 3],
    pub dwTimes: [u32; 3],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AUTO_SCROLL_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AUTO_SCROLL_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AUTO_SCROLL_DATA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AUTO_SCROLL_DATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AUTO_SCROLL_DATA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AUTO_SCROLL_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AUTO_SCROLL_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const AccessibilityDockingService: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x29ce1d46_b481_4aa0_a08a_d3ebc8aca402);
pub const AlphabeticalCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c2654c6_7372_4f6b_b310_55d6128f49d2);
pub const AppShellVerbHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4ed3a719_cea8_4bd9_910d_e252f997afc2);
pub const AppStartupLink: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x273eb5e7_88b0_4843_bfef_e2c81d43aae5);
pub const AppVisibility: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7e5fe3d9_985f_4908_91f9_ee19f9fd1514);
pub const ApplicationActivationManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x45ba127d_10a8_46ea_8ab7_56ea9078943c);
pub const ApplicationAssociationRegistration: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x591209c7_767b_42b2_9fba_44ee4615f2c7);
pub const ApplicationAssociationRegistrationUI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1968106d_f3b5_44cf_890e_116fcb9ecef1);
pub const ApplicationDesignModeSettings: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x958a6fb5_dcb2_4faf_aafd_7fb054ad1a3b);
pub const ApplicationDestinations: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x86c14003_4d6b_4ef3_a7b4_0506663b2e68);
pub const ApplicationDocumentLists: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x86bec222_30f2_47e0_9f25_60d11cd75c28);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn AssocCreate(clsid: ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocCreate(clsid: ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    AssocCreate(::core::mem::transmute(clsid), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocCreateForClasses<T>(rgclasses: &[ASSOCIATIONELEMENT]) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocCreateForClasses(rgclasses: *const ASSOCIATIONELEMENT, cclasses: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    AssocCreateForClasses(::core::mem::transmute(::windows::core::as_ptr_or_null(rgclasses)), rgclasses.len() as _, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
#[inline]
pub unsafe fn AssocGetDetailsOfPropKey<'a, P0>(psf: P0, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut super::super::System::Com::VARIANT, pffoundpropkey: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocGetDetailsOfPropKey(psf: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut super::super::System::Com::VARIANT, pffoundpropkey: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT;
    }
    AssocGetDetailsOfPropKey(psf.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(pkey), ::core::mem::transmute(pv), ::core::mem::transmute(pffoundpropkey)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn AssocGetPerceivedType<'a, P0>(pszext: P0, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocGetPerceivedType(pszext: ::windows::core::PCWSTR, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    AssocGetPerceivedType(pszext.into(), ::core::mem::transmute(ptype), ::core::mem::transmute(pflag), ::core::mem::transmute(ppsztype)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AssocIsDangerous<'a, P0>(pszassoc: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocIsDangerous(pszassoc: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    AssocIsDangerous(pszassoc.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyA<'a, P0, P1>(flags: u32, key: ASSOCKEY, pszassoc: P0, pszextra: P1) -> ::windows::core::Result<super::super::System::Registry::HKEY>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryKeyA(flags: u32, key: ASSOCKEY, pszassoc: ::windows::core::PCSTR, pszextra: ::windows::core::PCSTR, phkeyout: *mut super::super::System::Registry::HKEY) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    AssocQueryKeyA(flags, key, pszassoc.into(), pszextra.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Registry::HKEY>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyW<'a, P0, P1>(flags: u32, key: ASSOCKEY, pszassoc: P0, pszextra: P1) -> ::windows::core::Result<super::super::System::Registry::HKEY>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryKeyW(flags: u32, key: ASSOCKEY, pszassoc: ::windows::core::PCWSTR, pszextra: ::windows::core::PCWSTR, phkeyout: *mut super::super::System::Registry::HKEY) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    AssocQueryKeyW(flags, key, pszassoc.into(), pszextra.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Registry::HKEY>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn AssocQueryStringA<'a, P0, P1>(flags: u32, str: ASSOCSTR, pszassoc: P0, pszextra: P1, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringA(flags: u32, str: ASSOCSTR, pszassoc: ::windows::core::PCSTR, pszextra: ::windows::core::PCSTR, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringA(flags, str, pszassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyA<'a, P0, P1>(flags: u32, str: ASSOCSTR, hkassoc: P0, pszextra: P1, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringByKeyA(flags: u32, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: ::windows::core::PCSTR, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringByKeyA(flags, str, hkassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyW<'a, P0, P1>(flags: u32, str: ASSOCSTR, hkassoc: P0, pszextra: P1, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringByKeyW(flags: u32, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: ::windows::core::PCWSTR, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringByKeyW(flags, str, hkassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn AssocQueryStringW<'a, P0, P1>(flags: u32, str: ASSOCSTR, pszassoc: P0, pszextra: P1, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringW(flags: u32, str: ASSOCSTR, pszassoc: ::windows::core::PCWSTR, pszextra: ::windows::core::PCWSTR, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringW(flags, str, pszassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
pub const AttachmentServices: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4125dd96_e03a_4103_8f70_e0597d803b9c);
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
pub struct BANDINFOSFB {
    pub dwMask: u32,
    pub dwStateMask: u32,
    pub dwState: u32,
    pub crBkgnd: u32,
    pub crBtnLt: u32,
    pub crBtnDk: u32,
    pub wViewMode: u16,
    pub wAlign: u16,
    pub psf: ::core::option::Option<IShellFolder>,
    pub pidl: *mut Common::ITEMIDLIST,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::clone::Clone for BANDINFOSFB {
    fn clone(&self) -> Self {
        Self {
            dwMask: self.dwMask,
            dwStateMask: self.dwStateMask,
            dwState: self.dwState,
            crBkgnd: self.crBkgnd,
            crBtnLt: self.crBtnLt,
            crBtnDk: self.crBtnDk,
            wViewMode: self.wViewMode,
            wAlign: self.wAlign,
            psf: self.psf.clone(),
            pidl: self.pidl,
        }
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::fmt::Debug for BANDINFOSFB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BANDINFOSFB").field("dwMask", &self.dwMask).field("dwStateMask", &self.dwStateMask).field("dwState", &self.dwState).field("crBkgnd", &self.crBkgnd).field("crBtnLt", &self.crBtnLt).field("crBtnDk", &self.crBtnDk).field("wViewMode", &self.wViewMode).field("wAlign", &self.wAlign).field("psf", &self.psf).field("pidl", &self.pidl).finish()
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
unsafe impl ::windows::core::Abi for BANDINFOSFB {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::cmp::PartialEq for BANDINFOSFB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMask == other.dwMask && self.dwStateMask == other.dwStateMask && self.dwState == other.dwState && self.crBkgnd == other.crBkgnd && self.crBtnLt == other.crBtnLt && self.crBtnDk == other.crBtnDk && self.wViewMode == other.wViewMode && self.wAlign == other.wAlign && self.psf == other.psf && self.pidl == other.pidl
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::cmp::Eq for BANDINFOSFB {}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::default::Default for BANDINFOSFB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BANDSITECID(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSID_BANDADDED: BANDSITECID = BANDSITECID(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSID_BANDREMOVED: BANDSITECID = BANDSITECID(1i32);
impl ::core::marker::Copy for BANDSITECID {}
impl ::core::clone::Clone for BANDSITECID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BANDSITECID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BANDSITECID {
    type Abi = Self;
}
impl ::core::fmt::Debug for BANDSITECID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BANDSITECID").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct BANDSITEINFO {
    pub dwMask: u32,
    pub dwState: u32,
    pub dwStyle: u32,
}
impl ::core::marker::Copy for BANDSITEINFO {}
impl ::core::clone::Clone for BANDSITEINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BANDSITEINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BANDSITEINFO").field("dwMask", &self.dwMask).field("dwState", &self.dwState).field("dwStyle", &self.dwStyle).finish()
    }
}
unsafe impl ::windows::core::Abi for BANDSITEINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BANDSITEINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BANDSITEINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for BANDSITEINFO {}
impl ::core::default::Default for BANDSITEINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct BANNER_NOTIFICATION {
    pub event: BANNER_NOTIFICATION_EVENT,
    pub providerIdentity: ::windows::core::PCWSTR,
    pub contentId: ::windows::core::PCWSTR,
}
impl ::core::marker::Copy for BANNER_NOTIFICATION {}
impl ::core::clone::Clone for BANNER_NOTIFICATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BANNER_NOTIFICATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BANNER_NOTIFICATION").field("event", &self.event).field("providerIdentity", &self.providerIdentity).field("contentId", &self.contentId).finish()
    }
}
unsafe impl ::windows::core::Abi for BANNER_NOTIFICATION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BANNER_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BANNER_NOTIFICATION>()) == 0 }
    }
}
impl ::core::cmp::Eq for BANNER_NOTIFICATION {}
impl ::core::default::Default for BANNER_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BANNER_NOTIFICATION_EVENT(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNE_Rendered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNE_Hovered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNE_Closed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNE_Dismissed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNE_Button1Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNE_Button2Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(5i32);
impl ::core::marker::Copy for BANNER_NOTIFICATION_EVENT {}
impl ::core::clone::Clone for BANNER_NOTIFICATION_EVENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BANNER_NOTIFICATION_EVENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BANNER_NOTIFICATION_EVENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for BANNER_NOTIFICATION_EVENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BANNER_NOTIFICATION_EVENT").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub struct BASEBROWSERDATALH {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: ::core::option::Option<ITravelLog>,
    pub _phlf: ::core::option::Option<IHlinkFrame>,
    pub _pautoWB2: ::core::option::Option<IWebBrowser2>,
    pub _pautoEDS: ::core::option::Option<IExpDispSupport>,
    pub _pautoSS: ::core::option::Option<IShellService>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut Common::ITEMIDLIST,
    pub _pctView: ::core::option::Option<super::super::System::Ole::IOleCommandTarget>,
    pub _pidlCur: *mut Common::ITEMIDLIST,
    pub _psv: ::core::option::Option<IShellView>,
    pub _psf: ::core::option::Option<IShellFolder>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: ::windows::core::PWSTR,
    pub _pidlPending: *mut Common::ITEMIDLIST,
    pub _psvPending: ::core::option::Option<IShellView>,
    pub _psfPending: ::core::option::Option<IShellFolder>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: ::windows::core::PWSTR,
    pub _fIsViewMSHTML: super::super::Foundation::BOOL,
    pub _fPrivacyImpacted: super::super::Foundation::BOOL,
    pub _clsidView: ::windows::core::GUID,
    pub _clsidViewPending: ::windows::core::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
    pub _lPhishingFilterStatus: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BASEBROWSERDATALH {
    fn clone(&self) -> Self {
        Self {
            _hwnd: self._hwnd,
            _ptl: self._ptl.clone(),
            _phlf: self._phlf.clone(),
            _pautoWB2: self._pautoWB2.clone(),
            _pautoEDS: self._pautoEDS.clone(),
            _pautoSS: self._pautoSS.clone(),
            _eSecureLockIcon: self._eSecureLockIcon,
            _bitfield: self._bitfield,
            _uActivateState: self._uActivateState,
            _pidlViewState: self._pidlViewState,
            _pctView: self._pctView.clone(),
            _pidlCur: self._pidlCur,
            _psv: self._psv.clone(),
            _psf: self._psf.clone(),
            _hwndView: self._hwndView,
            _pszTitleCur: self._pszTitleCur,
            _pidlPending: self._pidlPending,
            _psvPending: self._psvPending.clone(),
            _psfPending: self._psfPending.clone(),
            _hwndViewPending: self._hwndViewPending,
            _pszTitlePending: self._pszTitlePending,
            _fIsViewMSHTML: self._fIsViewMSHTML,
            _fPrivacyImpacted: self._fPrivacyImpacted,
            _clsidView: self._clsidView,
            _clsidViewPending: self._clsidViewPending,
            _hwndFrame: self._hwndFrame,
            _lPhishingFilterStatus: self._lPhishingFilterStatus,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BASEBROWSERDATALH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BASEBROWSERDATALH")
            .field("_hwnd", &self._hwnd)
            .field("_ptl", &self._ptl)
            .field("_phlf", &self._phlf)
            .field("_pautoWB2", &self._pautoWB2)
            .field("_pautoEDS", &self._pautoEDS)
            .field("_pautoSS", &self._pautoSS)
            .field("_eSecureLockIcon", &self._eSecureLockIcon)
            .field("_bitfield", &self._bitfield)
            .field("_uActivateState", &self._uActivateState)
            .field("_pidlViewState", &self._pidlViewState)
            .field("_pctView", &self._pctView)
            .field("_pidlCur", &self._pidlCur)
            .field("_psv", &self._psv)
            .field("_psf", &self._psf)
            .field("_hwndView", &self._hwndView)
            .field("_pszTitleCur", &self._pszTitleCur)
            .field("_pidlPending", &self._pidlPending)
            .field("_psvPending", &self._psvPending)
            .field("_psfPending", &self._psfPending)
            .field("_hwndViewPending", &self._hwndViewPending)
            .field("_pszTitlePending", &self._pszTitlePending)
            .field("_fIsViewMSHTML", &self._fIsViewMSHTML)
            .field("_fPrivacyImpacted", &self._fPrivacyImpacted)
            .field("_clsidView", &self._clsidView)
            .field("_clsidViewPending", &self._clsidViewPending)
            .field("_hwndFrame", &self._hwndFrame)
            .field("_lPhishingFilterStatus", &self._lPhishingFilterStatus)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BASEBROWSERDATALH {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BASEBROWSERDATALH {
    fn eq(&self, other: &Self) -> bool {
        self._hwnd == other._hwnd
            && self._ptl == other._ptl
            && self._phlf == other._phlf
            && self._pautoWB2 == other._pautoWB2
            && self._pautoEDS == other._pautoEDS
            && self._pautoSS == other._pautoSS
            && self._eSecureLockIcon == other._eSecureLockIcon
            && self._bitfield == other._bitfield
            && self._uActivateState == other._uActivateState
            && self._pidlViewState == other._pidlViewState
            && self._pctView == other._pctView
            && self._pidlCur == other._pidlCur
            && self._psv == other._psv
            && self._psf == other._psf
            && self._hwndView == other._hwndView
            && self._pszTitleCur == other._pszTitleCur
            && self._pidlPending == other._pidlPending
            && self._psvPending == other._psvPending
            && self._psfPending == other._psfPending
            && self._hwndViewPending == other._hwndViewPending
            && self._pszTitlePending == other._pszTitlePending
            && self._fIsViewMSHTML == other._fIsViewMSHTML
            && self._fPrivacyImpacted == other._fPrivacyImpacted
            && self._clsidView == other._clsidView
            && self._clsidViewPending == other._clsidViewPending
            && self._hwndFrame == other._hwndFrame
            && self._lPhishingFilterStatus == other._lPhishingFilterStatus
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BASEBROWSERDATALH {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BASEBROWSERDATALH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub struct BASEBROWSERDATAXP {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: ::core::option::Option<ITravelLog>,
    pub _phlf: ::core::option::Option<IHlinkFrame>,
    pub _pautoWB2: ::core::option::Option<IWebBrowser2>,
    pub _pautoEDS: ::core::option::Option<IExpDispSupportXP>,
    pub _pautoSS: ::core::option::Option<IShellService>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut Common::ITEMIDLIST,
    pub _pctView: ::core::option::Option<super::super::System::Ole::IOleCommandTarget>,
    pub _pidlCur: *mut Common::ITEMIDLIST,
    pub _psv: ::core::option::Option<IShellView>,
    pub _psf: ::core::option::Option<IShellFolder>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: ::windows::core::PWSTR,
    pub _pidlPending: *mut Common::ITEMIDLIST,
    pub _psvPending: ::core::option::Option<IShellView>,
    pub _psfPending: ::core::option::Option<IShellFolder>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: ::windows::core::PWSTR,
    pub _fIsViewMSHTML: super::super::Foundation::BOOL,
    pub _fPrivacyImpacted: super::super::Foundation::BOOL,
    pub _clsidView: ::windows::core::GUID,
    pub _clsidViewPending: ::windows::core::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BASEBROWSERDATAXP {
    fn clone(&self) -> Self {
        Self {
            _hwnd: self._hwnd,
            _ptl: self._ptl.clone(),
            _phlf: self._phlf.clone(),
            _pautoWB2: self._pautoWB2.clone(),
            _pautoEDS: self._pautoEDS.clone(),
            _pautoSS: self._pautoSS.clone(),
            _eSecureLockIcon: self._eSecureLockIcon,
            _bitfield: self._bitfield,
            _uActivateState: self._uActivateState,
            _pidlViewState: self._pidlViewState,
            _pctView: self._pctView.clone(),
            _pidlCur: self._pidlCur,
            _psv: self._psv.clone(),
            _psf: self._psf.clone(),
            _hwndView: self._hwndView,
            _pszTitleCur: self._pszTitleCur,
            _pidlPending: self._pidlPending,
            _psvPending: self._psvPending.clone(),
            _psfPending: self._psfPending.clone(),
            _hwndViewPending: self._hwndViewPending,
            _pszTitlePending: self._pszTitlePending,
            _fIsViewMSHTML: self._fIsViewMSHTML,
            _fPrivacyImpacted: self._fPrivacyImpacted,
            _clsidView: self._clsidView,
            _clsidViewPending: self._clsidViewPending,
            _hwndFrame: self._hwndFrame,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BASEBROWSERDATAXP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BASEBROWSERDATAXP")
            .field("_hwnd", &self._hwnd)
            .field("_ptl", &self._ptl)
            .field("_phlf", &self._phlf)
            .field("_pautoWB2", &self._pautoWB2)
            .field("_pautoEDS", &self._pautoEDS)
            .field("_pautoSS", &self._pautoSS)
            .field("_eSecureLockIcon", &self._eSecureLockIcon)
            .field("_bitfield", &self._bitfield)
            .field("_uActivateState", &self._uActivateState)
            .field("_pidlViewState", &self._pidlViewState)
            .field("_pctView", &self._pctView)
            .field("_pidlCur", &self._pidlCur)
            .field("_psv", &self._psv)
            .field("_psf", &self._psf)
            .field("_hwndView", &self._hwndView)
            .field("_pszTitleCur", &self._pszTitleCur)
            .field("_pidlPending", &self._pidlPending)
            .field("_psvPending", &self._psvPending)
            .field("_psfPending", &self._psfPending)
            .field("_hwndViewPending", &self._hwndViewPending)
            .field("_pszTitlePending", &self._pszTitlePending)
            .field("_fIsViewMSHTML", &self._fIsViewMSHTML)
            .field("_fPrivacyImpacted", &self._fPrivacyImpacted)
            .field("_clsidView", &self._clsidView)
            .field("_clsidViewPending", &self._clsidViewPending)
            .field("_hwndFrame", &self._hwndFrame)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BASEBROWSERDATAXP {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BASEBROWSERDATAXP {
    fn eq(&self, other: &Self) -> bool {
        self._hwnd == other._hwnd
            && self._ptl == other._ptl
            && self._phlf == other._phlf
            && self._pautoWB2 == other._pautoWB2
            && self._pautoEDS == other._pautoEDS
            && self._pautoSS == other._pautoSS
            && self._eSecureLockIcon == other._eSecureLockIcon
            && self._bitfield == other._bitfield
            && self._uActivateState == other._uActivateState
            && self._pidlViewState == other._pidlViewState
            && self._pctView == other._pctView
            && self._pidlCur == other._pidlCur
            && self._psv == other._psv
            && self._psf == other._psf
            && self._hwndView == other._hwndView
            && self._pszTitleCur == other._pszTitleCur
            && self._pidlPending == other._pidlPending
            && self._psvPending == other._psvPending
            && self._psfPending == other._psfPending
            && self._hwndViewPending == other._hwndViewPending
            && self._pszTitlePending == other._pszTitlePending
            && self._fIsViewMSHTML == other._fIsViewMSHTML
            && self._fPrivacyImpacted == other._fPrivacyImpacted
            && self._clsidView == other._clsidView
            && self._clsidViewPending == other._clsidViewPending
            && self._hwndFrame == other._hwndFrame
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BASEBROWSERDATAXP {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BASEBROWSERDATAXP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub type BFFCALLBACK = ::core::option::Option<unsafe extern "system" fn(hwnd: super::super::Foundation::HWND, umsg: u32, lparam: super::super::Foundation::LPARAM, lpdata: super::super::Foundation::LPARAM) -> i32>;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_ENABLEOK: u32 = 1125u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_INITIALIZED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_IUNKNOWN: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SELCHANGED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETEXPANDED: u32 = 1130u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETOKTEXT: u32 = 1129u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETSELECTION: u32 = 1127u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETSELECTIONA: u32 = 1126u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETSELECTIONW: u32 = 1127u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETSTATUSTEXT: u32 = 1128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETSTATUSTEXTA: u32 = 1124u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_SETSTATUSTEXTW: u32 = 1128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_VALIDATEFAILED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_VALIDATEFAILEDA: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BFFM_VALIDATEFAILEDW: u32 = 4u32;
pub const BHID_AssociationArray: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbea9ef17_82f1_4f60_9284_4f8db75c3be9);
pub const BHID_DataObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8c0bd9f_ed24_455c_83e6_d5390c4fe8c4);
pub const BHID_EnumAssocHandlers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8ab0b9c_c2ec_4f7a_918d_314900e6280a);
pub const BHID_EnumItems: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94f60519_2850_4924_aa5a_d15e84868039);
pub const BHID_FilePlaceholder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8677dceb_aae0_4005_8d3d_547fa852f825);
pub const BHID_Filter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x38d08778_f557_4690_9ebf_ba54706ad8f7);
pub const BHID_LinkTargetItem: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e228_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_PropertyStore: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0384e1a4_1523_439c_a4c8_ab911052f586);
pub const BHID_RandomAccessStream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf16fc93b_77ae_4cfe_bda7_a866eea6878d);
pub const BHID_SFObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e224_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_SFUIObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e225_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_SFViewObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e226_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_Storage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e227_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_StorageEnum: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4621a4e3_f0d6_4773_8a9c_46e77b174840);
pub const BHID_StorageItem: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x404e2109_77d2_4699_a5a0_4fdf10db9837);
pub const BHID_Stream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1cebb3ab_7c10_499a_a417_92ca16c4cb83);
pub const BHID_ThumbnailHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b2e650a_8e20_4f4a_b09e_6597afc72fb0);
pub const BHID_Transfer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd5e346a1_f753_4932_b403_4574800e2498);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_BROWSEFILEJUNCTIONS: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_BROWSEFORCOMPUTER: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_BROWSEFORPRINTER: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_BROWSEINCLUDEFILES: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_BROWSEINCLUDEURLS: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_DONTGOBELOWDOMAIN: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_EDITBOX: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_NEWDIALOGSTYLE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_NONEWFOLDERBUTTON: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_NOTRANSLATETARGETS: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_RETURNFSANCESTORS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_RETURNONLYFSDIRS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_SHAREABLE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_STATUSTEXT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_UAHINT: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIF_VALIDATE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BIND_INTERRUPTABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BMICON_LARGE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BMICON_SMALL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BNSTATE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNS_NORMAL: BNSTATE = BNSTATE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNS_BEGIN_NAVIGATE: BNSTATE = BNSTATE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BNS_NAVIGATE: BNSTATE = BNSTATE(2i32);
impl ::core::marker::Copy for BNSTATE {}
impl ::core::clone::Clone for BNSTATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BNSTATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BNSTATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for BNSTATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BNSTATE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
pub struct BROWSEINFOA {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut Common::ITEMIDLIST,
    pub pszDisplayName: ::windows::core::PSTR,
    pub lpszTitle: ::windows::core::PCSTR,
    pub ulFlags: u32,
    pub lpfn: BFFCALLBACK,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::marker::Copy for BROWSEINFOA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BROWSEINFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BROWSEINFOA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BROWSEINFOA").field("hwndOwner", &self.hwndOwner).field("pidlRoot", &self.pidlRoot).field("pszDisplayName", &self.pszDisplayName).field("lpszTitle", &self.lpszTitle).field("ulFlags", &self.ulFlags).field("lpfn", &self.lpfn.map(|f| f as usize)).field("lParam", &self.lParam).field("iImage", &self.iImage).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BROWSEINFOA {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BROWSEINFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BROWSEINFOA>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BROWSEINFOA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BROWSEINFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
pub struct BROWSEINFOW {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut Common::ITEMIDLIST,
    pub pszDisplayName: ::windows::core::PWSTR,
    pub lpszTitle: ::windows::core::PCWSTR,
    pub ulFlags: u32,
    pub lpfn: BFFCALLBACK,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::marker::Copy for BROWSEINFOW {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BROWSEINFOW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BROWSEINFOW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BROWSEINFOW").field("hwndOwner", &self.hwndOwner).field("pidlRoot", &self.pidlRoot).field("pszDisplayName", &self.pszDisplayName).field("lpszTitle", &self.lpszTitle).field("ulFlags", &self.ulFlags).field("lpfn", &self.lpfn.map(|f| f as usize)).field("lParam", &self.lParam).field("iImage", &self.iImage).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BROWSEINFOW {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BROWSEINFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BROWSEINFOW>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BROWSEINFOW {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BROWSEINFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_CANMAXIMIZE: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_DELEGATEDNAVIGATION: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_DONTSHOWNAVCANCELPAGE: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_FEEDNAVIGATION: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_FEEDSUBSCRIBED: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_HTMLNAVCANCELED: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_MERGEDMENUS: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_NAVNOHISTORY: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_NOLOCALFILEWARNING: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_REGISTERASDROPTARGET: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_RESIZABLE: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_SETNAVIGATABLECODEPAGE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_THEATERMODE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_TOPBROWSER: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_TRUSTEDFORACTIVEX: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSF_UISETBYAUTOMATION: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIM_STATE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIM_STYLE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_ALWAYSGRIPPER: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_AUTOGRIPPER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_FIXEDORDER: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_LEFTALIGN: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_LOCKED: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_NOCAPTION: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_NOCONTEXTMENU: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_NODROPTARGET: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_NOGRIPPER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_PREFERNOLINEBREAK: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_PRESERVEORDERDURINGLAYOUT: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSIS_SINGLECLICK: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSSF_NOTITLE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSSF_UNDELETEABLE: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BSSF_VISIBLE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const BUFFLEN: u32 = 255u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BrowserNavConstants(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navOpenInNewWindow: BrowserNavConstants = BrowserNavConstants(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navNoHistory: BrowserNavConstants = BrowserNavConstants(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navNoReadFromCache: BrowserNavConstants = BrowserNavConstants(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navNoWriteToCache: BrowserNavConstants = BrowserNavConstants(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navAllowAutosearch: BrowserNavConstants = BrowserNavConstants(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navBrowserBar: BrowserNavConstants = BrowserNavConstants(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navHyperlink: BrowserNavConstants = BrowserNavConstants(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navEnforceRestricted: BrowserNavConstants = BrowserNavConstants(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navNewWindowsManaged: BrowserNavConstants = BrowserNavConstants(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navUntrustedForDownload: BrowserNavConstants = BrowserNavConstants(512i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navTrustedForActiveX: BrowserNavConstants = BrowserNavConstants(1024i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navOpenInNewTab: BrowserNavConstants = BrowserNavConstants(2048i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navOpenInBackgroundTab: BrowserNavConstants = BrowserNavConstants(4096i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navKeepWordWheelText: BrowserNavConstants = BrowserNavConstants(8192i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navVirtualTab: BrowserNavConstants = BrowserNavConstants(16384i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navBlockRedirectsXDomain: BrowserNavConstants = BrowserNavConstants(32768i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navOpenNewForegroundTab: BrowserNavConstants = BrowserNavConstants(65536i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navTravelLogScreenshot: BrowserNavConstants = BrowserNavConstants(131072i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navDeferUnload: BrowserNavConstants = BrowserNavConstants(262144i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navSpeculative: BrowserNavConstants = BrowserNavConstants(524288i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navSuggestNewWindow: BrowserNavConstants = BrowserNavConstants(1048576i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navSuggestNewTab: BrowserNavConstants = BrowserNavConstants(2097152i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved1: BrowserNavConstants = BrowserNavConstants(4194304i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navHomepageNavigate: BrowserNavConstants = BrowserNavConstants(8388608i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navRefresh: BrowserNavConstants = BrowserNavConstants(16777216i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navHostNavigation: BrowserNavConstants = BrowserNavConstants(33554432i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved2: BrowserNavConstants = BrowserNavConstants(67108864i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved3: BrowserNavConstants = BrowserNavConstants(134217728i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved4: BrowserNavConstants = BrowserNavConstants(268435456i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved5: BrowserNavConstants = BrowserNavConstants(536870912i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved6: BrowserNavConstants = BrowserNavConstants(1073741824i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const navReserved7: BrowserNavConstants = BrowserNavConstants(-2147483648i32);
impl ::core::marker::Copy for BrowserNavConstants {}
impl ::core::clone::Clone for BrowserNavConstants {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BrowserNavConstants {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BrowserNavConstants {
    type Abi = Self;
}
impl ::core::fmt::Debug for BrowserNavConstants {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BrowserNavConstants").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CABINETSTATE {
    pub cLength: u16,
    pub nVersion: u16,
    pub _bitfield: i32,
    pub fMenuEnumFilter: u32,
}
impl ::core::marker::Copy for CABINETSTATE {}
impl ::core::clone::Clone for CABINETSTATE {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CABINETSTATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CABINETSTATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CABINETSTATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for CABINETSTATE {}
impl ::core::default::Default for CABINETSTATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CABINETSTATE_VERSION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CAMERAROLL_E_NO_DOWNSAMPLING_REQUIRED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927456i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CATEGORYINFO_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_NORMAL: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_COLLAPSED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_HIDDEN: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_EXPANDED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_NOHEADER: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_NOTCOLLAPSIBLE: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_NOHEADERCOUNT: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_SUBSETTED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_SEPARATE_IMAGES: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATINFO_SHOWEMPTY: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(256i32);
impl ::core::marker::Copy for CATEGORYINFO_FLAGS {}
impl ::core::clone::Clone for CATEGORYINFO_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CATEGORYINFO_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CATEGORYINFO_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CATEGORYINFO_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CATEGORYINFO_FLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CATEGORY_INFO {
    pub cif: CATEGORYINFO_FLAGS,
    pub wszName: [u16; 260],
}
impl ::core::marker::Copy for CATEGORY_INFO {}
impl ::core::clone::Clone for CATEGORY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CATEGORY_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CATEGORY_INFO").field("cif", &self.cif).field("wszName", &self.wszName).finish()
    }
}
unsafe impl ::windows::core::Abi for CATEGORY_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CATEGORY_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORY_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CATEGORY_INFO {}
impl ::core::default::Default for CATEGORY_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const CATID_BrowsableShellExt: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021490_0000_0000_c000_000000000046);
pub const CATID_BrowseInPlace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021491_0000_0000_c000_000000000046);
pub const CATID_CommBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021494_0000_0000_c000_000000000046);
pub const CATID_DeskBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021492_0000_0000_c000_000000000046);
pub const CATID_FilePlaceholderMergeHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e9c9a51_d4aa_4870_b47c_7424b491f1cc);
pub const CATID_InfoBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021493_0000_0000_c000_000000000046);
pub const CATID_LocationFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x965c4d51_8b76_4e57_80b7_564d2ea4b55e);
pub const CATID_LocationProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b3ca474_2614_414b_b813_1aceca3e3dd8);
pub const CATID_SearchableApplication: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x366c292a_d9b3_4dbf_bb70_e62ec3d0bbbf);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CATSORT_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATSORT_DEFAULT: CATSORT_FLAGS = CATSORT_FLAGS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CATSORT_NAME: CATSORT_FLAGS = CATSORT_FLAGS(1i32);
impl ::core::marker::Copy for CATSORT_FLAGS {}
impl ::core::clone::Clone for CATSORT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CATSORT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CATSORT_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CATSORT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CATSORT_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_ADDSHIELD: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_ALLOWPREVIEWPANE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_ISFILESAVE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_ISFOLDERPICKER: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_NOINCLUDEITEM: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_NOSELECTVERB: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2GVF_SHOWALLFILES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2N_CONTEXTMENU_DONE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDB2N_CONTEXTMENU_START: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBOSC_KILLFOCUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBOSC_RENAME: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBOSC_SELCHANGE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBOSC_SETFOCUS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBOSC_STATECHANGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CDBURNINGEXTENSIONRET(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBE_RET_DEFAULT: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBE_RET_DONTRUNOTHEREXTS: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDBE_RET_STOPWIZARD: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(2i32);
impl ::core::marker::Copy for CDBURNINGEXTENSIONRET {}
impl ::core::clone::Clone for CDBURNINGEXTENSIONRET {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CDBURNINGEXTENSIONRET {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CDBURNINGEXTENSIONRET {
    type Abi = Self;
}
impl ::core::fmt::Debug for CDBURNINGEXTENSIONRET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CDBURNINGEXTENSIONRET").field(&self.0).finish()
    }
}
pub const CDBurn: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfbeb8a05_beee_4442_804e_409d6c4515e9);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CDCONTROLSTATEF(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDCS_INACTIVE: CDCONTROLSTATEF = CDCONTROLSTATEF(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDCS_ENABLED: CDCONTROLSTATEF = CDCONTROLSTATEF(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDCS_VISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CDCS_ENABLEDVISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(3i32);
impl ::core::marker::Copy for CDCONTROLSTATEF {}
impl ::core::clone::Clone for CDCONTROLSTATEF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CDCONTROLSTATEF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CDCONTROLSTATEF {
    type Abi = Self;
}
impl ::core::fmt::Debug for CDCONTROLSTATEF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CDCONTROLSTATEF").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CDefFolderMenu_Create2<'a, P0, P1>(pidlfolder: *const Common::ITEMIDLIST, hwnd: P0, apidl: &[*const Common::ITEMIDLIST], psf: P1, pfn: LPFNDFMCALLBACK, ahkeys: &[super::super::System::Registry::HKEY]) -> ::windows::core::Result<IContextMenu>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CDefFolderMenu_Create2(pidlfolder: *const Common::ITEMIDLIST, hwnd: super::super::Foundation::HWND, cidl: u32, apidl: *const *const Common::ITEMIDLIST, psf: *mut ::core::ffi::c_void, pfn: *mut ::core::ffi::c_void, nkeys: u32, ahkeys: *const super::super::System::Registry::HKEY, ppcm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    CDefFolderMenu_Create2(::core::mem::transmute(pidlfolder), hwnd.into(), apidl.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(apidl)), psf.into().abi(), ::core::mem::transmute(pfn), ahkeys.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(ahkeys)), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IContextMenu>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_AUTOPLAY_SHELLIDLISTS: &str = "Autoplay Enumerated IDList Array";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_DROPDESCRIPTION: &str = "DropDescription";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILECONTENTS: &str = "FileContents";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILEDESCRIPTOR: &str = "FileGroupDescriptorW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILEDESCRIPTORA: &str = "FileGroupDescriptor";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILEDESCRIPTORW: &str = "FileGroupDescriptorW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILENAME: &str = "FileNameW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILENAMEA: &str = "FileName";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILENAMEMAP: &str = "FileNameMapW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILENAMEMAPA: &str = "FileNameMap";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILENAMEMAPW: &str = "FileNameMapW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILENAMEW: &str = "FileNameW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_FILE_ATTRIBUTES_ARRAY: &str = "File Attributes Array";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_INDRAGLOOP: &str = "InShellDragLoop";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_INETURL: &str = "UniformResourceLocatorW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_INETURLA: &str = "UniformResourceLocator";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_INETURLW: &str = "UniformResourceLocatorW";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_INVOKECOMMAND_DROPPARAM: &str = "InvokeCommand DropParam";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_LOGICALPERFORMEDDROPEFFECT: &str = "Logical Performed DropEffect";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_MOUNTEDVOLUME: &str = "MountedVolume";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_NETRESOURCES: &str = "Net Resource";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_PASTESUCCEEDED: &str = "Paste Succeeded";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_PERFORMEDDROPEFFECT: &str = "Performed DropEffect";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_PERSISTEDDATAOBJECT: &str = "PersistedDataObject";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_PREFERREDDROPEFFECT: &str = "Preferred DropEffect";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_PRINTERGROUP: &str = "PrinterFriendlyName";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_SHELLDROPHANDLER: &str = "DropHandlerCLSID";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_SHELLIDLIST: &str = "Shell IDList Array";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_SHELLIDLISTOFFSET: &str = "Shell Object Offsets";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_SHELLURL: &str = "UniformResourceLocator";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_TARGETCLSID: &str = "TargetCLSID";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_UNTRUSTEDDRAGDROP: &str = "UntrustedDragDrop";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CFSTR_ZONEIDENTIFIER: &str = "ZoneIdentifier";
pub const CGID_DefView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4af07f10_d231_11d0_b942_00a0c90312e1);
pub const CGID_Explorer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d0_0000_0000_c000_000000000046);
pub const CGID_ExplorerBarDoc: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d3_0000_0000_c000_000000000046);
pub const CGID_MENUDESKBAR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5c9f0a12_959e_11d0_a3a4_00a0c9082636);
pub const CGID_ShellDocView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d1_0000_0000_c000_000000000046);
pub const CGID_ShellServiceObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d2_0000_0000_c000_000000000046);
pub const CGID_ShortCut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x93a68750_951a_11d1_946f_000000000000);
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CIDA {
    pub cidl: u32,
    pub aoffset: [u32; 1],
}
impl ::core::marker::Copy for CIDA {}
impl ::core::clone::Clone for CIDA {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CIDA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CIDA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CIDA>()) == 0 }
    }
}
impl ::core::cmp::Eq for CIDA {}
impl ::core::default::Default for CIDA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, apidl: &[*const Common::ITEMIDLIST]) -> ::windows::core::Result<super::super::System::Com::IDataObject> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, cidl: u32, apidl: *const *const Common::ITEMIDLIST, ppdtobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    CIDLData_CreateFromIDArray(::core::mem::transmute(pidlfolder), apidl.len() as _, ::core::mem::transmute(::windows::core::as_ptr_or_null(apidl)), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDataObject>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct CIE4ConnectionPoint(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl CIE4ConnectionPoint {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionInterface(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetConnectionInterface)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionPointContainer(&self) -> ::windows::core::Result<super::super::System::Com::IConnectionPointContainer> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetConnectionPointContainer)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IConnectionPointContainer>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Advise<'a, P0>(&self, punksink: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Advise)(::windows::core::Interface::as_raw(self), punksink.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Unadvise)(::windows::core::Interface::as_raw(self), dwcookie).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumConnections(&self) -> ::windows::core::Result<super::super::System::Com::IEnumConnections> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.EnumConnections)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IEnumConnections>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DoInvokeIE4(&self, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut ::core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DoInvokeIE4)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pf), ::core::mem::transmute(ppv), dispid, ::core::mem::transmute(pdispparams)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn DoInvokePIDLIE4<'a, P0>(&self, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).DoInvokePIDLIE4)(::windows::core::Interface::as_raw(self), dispid, ::core::mem::transmute(pidl), fcancancel.into()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<CIE4ConnectionPoint> for ::windows::core::IUnknown {
    fn from(value: CIE4ConnectionPoint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a CIE4ConnectionPoint> for &'a ::windows::core::IUnknown {
    fn from(value: &'a CIE4ConnectionPoint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&CIE4ConnectionPoint> for ::windows::core::IUnknown {
    fn from(value: &CIE4ConnectionPoint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<CIE4ConnectionPoint> for super::super::System::Com::IConnectionPoint {
    fn from(value: CIE4ConnectionPoint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a CIE4ConnectionPoint> for &'a super::super::System::Com::IConnectionPoint {
    fn from(value: &'a CIE4ConnectionPoint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&CIE4ConnectionPoint> for super::super::System::Com::IConnectionPoint {
    fn from(value: &CIE4ConnectionPoint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for CIE4ConnectionPoint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for CIE4ConnectionPoint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for CIE4ConnectionPoint {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for CIE4ConnectionPoint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CIE4ConnectionPoint").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for CIE4ConnectionPoint {
    type Vtable = CIE4ConnectionPoint_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct CIE4ConnectionPoint_Vtbl {
    pub base__: super::super::System::Com::IConnectionPoint_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DoInvokeIE4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut ::core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DoInvokeIE4: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub DoInvokePIDLIE4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    DoInvokePIDLIE4: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CLOSEPROPS_DISCARD: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CLOSEPROPS_NONE: u32 = 0u32;
pub const CLSID_ACLCustomMRU: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6935db93_21e8_4ccc_beb9_9fe3c77a297a);
pub const CLSID_ACLHistory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2764_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_ACLMRU: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6756a641_de71_11d0_831b_00aa005b4383);
pub const CLSID_ACLMulti: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2765_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_ACListISF: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x03c036f1_a186_11d0_824a_00aa005b4383);
pub const CLSID_ActiveDesktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x75048700_ef1f_11d0_9888_006097deacf9);
pub const CLSID_AutoComplete: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2763_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_CAnchorBrowsePropertyPage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3050f3bb_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CDocBrowsePropertyPage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3050f3b4_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CFSIconOverlayManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63b51f81_c868_11d0_999c_00c04fd655e1);
pub const CLSID_CImageBrowsePropertyPage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3050f3b3_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CURLSearchHook: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcfbfae00_17a6_11d0_99cb_00c04fd64497);
pub const CLSID_CUrlHistory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c374a40_bae4_11cf_bf7d_00aa006946ee);
pub const CLSID_ControlPanel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x21ec2020_3aea_1069_a2dd_08002b30309d);
pub const CLSID_DarwinAppPublisher: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcfccc7a0_a282_11d1_9082_006008059382);
pub const CLSID_DocHostUIHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7057e952_bd1b_11d1_8919_00c04fc2c836);
pub const CLSID_DragDropHelper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4657278a_411b_11d2_839a_00c04fd918d0);
pub const CLSID_FileTypes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb091e540_83e3_11cf_a713_0020afd79762);
pub const CLSID_FolderItemsMultiLevel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x53c74826_ab99_4d33_aca4_3117f51d3788);
pub const CLSID_FolderShortcut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0afaced1_e828_11d1_9187_b532f1e9575d);
pub const CLSID_HWShellExecute: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xffb8655f_81b9_4fce_b89c_9a6ba76d13e7);
pub const CLSID_ISFBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd82be2b0_5764_11d0_a96e_00c04fd705a2);
pub const CLSID_Internet: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x871c5380_42a0_1069_a2ea_08002b30309d);
pub const CLSID_InternetButtons: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1e796980_9cc5_11d1_a83f_00c04fc99d61);
pub const CLSID_InternetShortcut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfbf23b40_e3f0_101b_8488_00aa003e56f8);
pub const CLSID_LinkColumnProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24f14f02_7b1c_11d1_838f_0000f80461cf);
pub const CLSID_MSOButtons: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x178f34b8_a282_11d2_86c5_00c04f8eea99);
pub const CLSID_MenuBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5b4dae26_b807_11d0_9815_00c04fd91972);
pub const CLSID_MenuBandSite: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe13ef4e4_d2f2_11d0_9816_00c04fd91972);
pub const CLSID_MenuToolbarBase: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x40b96610_b522_11d1_b3b4_00aa006efde7);
pub const CLSID_MyComputer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x20d04fe0_3aea_1069_a2d8_08002b30309d);
pub const CLSID_MyDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x450d8fba_ad25_11d0_98a8_0800361b1103);
pub const CLSID_NetworkDomain: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x46e06680_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NetworkServer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0542a90_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NetworkShare: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x54a754c0_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NewMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd969a300_e7ff_11d0_a93b_00a0c90f2719);
pub const CLSID_Printers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2227a280_3aea_1069_a2de_08002b30309d);
pub const CLSID_ProgressDialog: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf8383852_fcd3_11d1_a6b9_006097df5bd4);
pub const CLSID_QueryAssociations: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07034fd_6caa_4954_ac3f_97a27216f98a);
pub const CLSID_QuickLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0e5cbf21_d15f_11d0_8301_00aa005b4383);
pub const CLSID_RecycleBin: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x645ff040_5081_101b_9f08_00aa002f954e);
pub const CLSID_ShellFldSetExt: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6d5313c0_8c62_11d1_b2cd_006097df8c11);
pub const CLSID_ShellThumbnailDiskCache: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1ebdcf80_a200_11d0_a3a4_00c04fd706ec);
pub const CLSID_ToolbarExtButtons: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2ce4b5d8_a28f_11d2_86c5_00c04f8eea99);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDID_INTSHORTCUTCREATE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_NEWFOLDER: &str = "NewFolder";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_NEWFOLDERA: &str = "NewFolder";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_NEWFOLDERW: &str = "NewFolder";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_VIEWDETAILS: &str = "ViewDetails";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_VIEWDETAILSA: &str = "ViewDetails";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_VIEWDETAILSW: &str = "ViewDetails";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_VIEWLIST: &str = "ViewList";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_VIEWLISTA: &str = "ViewList";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMDSTR_VIEWLISTW: &str = "ViewList";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_ASYNCVERBSTATE: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_CANRENAME: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_DEFAULTONLY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_DISABLEDVERBS: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_DONOTPICKDEFAULT: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_EXPLORE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_EXTENDEDVERBS: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_INCLUDESTATIC: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_ITEMMENU: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_NODEFAULT: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_NORMAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_NOVERBS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_OPTIMIZEFORINVOKE: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_RESERVED: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_SYNCCASCADEMENU: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMF_VERBSONLY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMIC_MASK_CONTROL_DOWN: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMIC_MASK_PTINVOKE: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CMIC_MASK_SHIFT_DOWN: u32 = 268435456u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFO {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: ::windows::core::PCSTR,
    pub lpParameters: ::windows::core::PCSTR,
    pub lpDirectory: ::windows::core::PCSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CMINVOKECOMMANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CMINVOKECOMMANDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CMINVOKECOMMANDINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CMINVOKECOMMANDINFO").field("cbSize", &self.cbSize).field("fMask", &self.fMask).field("hwnd", &self.hwnd).field("lpVerb", &self.lpVerb).field("lpParameters", &self.lpParameters).field("lpDirectory", &self.lpDirectory).field("nShow", &self.nShow).field("dwHotKey", &self.dwHotKey).field("hIcon", &self.hIcon).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CMINVOKECOMMANDINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CMINVOKECOMMANDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CMINVOKECOMMANDINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CMINVOKECOMMANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CMINVOKECOMMANDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFOEX {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: ::windows::core::PCSTR,
    pub lpParameters: ::windows::core::PCSTR,
    pub lpDirectory: ::windows::core::PCSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
    pub lpTitle: ::windows::core::PCSTR,
    pub lpVerbW: ::windows::core::PCWSTR,
    pub lpParametersW: ::windows::core::PCWSTR,
    pub lpDirectoryW: ::windows::core::PCWSTR,
    pub lpTitleW: ::windows::core::PCWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CMINVOKECOMMANDINFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CMINVOKECOMMANDINFOEX {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CMINVOKECOMMANDINFOEX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CMINVOKECOMMANDINFOEX")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerb", &self.lpVerb)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("hIcon", &self.hIcon)
            .field("lpTitle", &self.lpTitle)
            .field("lpVerbW", &self.lpVerbW)
            .field("lpParametersW", &self.lpParametersW)
            .field("lpDirectoryW", &self.lpDirectoryW)
            .field("lpTitleW", &self.lpTitleW)
            .field("ptInvoke", &self.ptInvoke)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CMINVOKECOMMANDINFOEX {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CMINVOKECOMMANDINFOEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CMINVOKECOMMANDINFOEX>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CMINVOKECOMMANDINFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CMINVOKECOMMANDINFOEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFOEX_REMOTE {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerbString: ::windows::core::PCSTR,
    pub lpParameters: ::windows::core::PCSTR,
    pub lpDirectory: ::windows::core::PCSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub lpTitle: ::windows::core::PCSTR,
    pub lpVerbWString: ::windows::core::PCWSTR,
    pub lpParametersW: ::windows::core::PCWSTR,
    pub lpDirectoryW: ::windows::core::PCWSTR,
    pub lpTitleW: ::windows::core::PCWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
    pub lpVerbInt: u32,
    pub lpVerbWInt: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CMINVOKECOMMANDINFOEX_REMOTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CMINVOKECOMMANDINFOEX_REMOTE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CMINVOKECOMMANDINFOEX_REMOTE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CMINVOKECOMMANDINFOEX_REMOTE")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerbString", &self.lpVerbString)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("lpTitle", &self.lpTitle)
            .field("lpVerbWString", &self.lpVerbWString)
            .field("lpParametersW", &self.lpParametersW)
            .field("lpDirectoryW", &self.lpDirectoryW)
            .field("lpTitleW", &self.lpTitleW)
            .field("ptInvoke", &self.ptInvoke)
            .field("lpVerbInt", &self.lpVerbInt)
            .field("lpVerbWInt", &self.lpVerbWInt)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CMINVOKECOMMANDINFOEX_REMOTE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CMINVOKECOMMANDINFOEX_REMOTE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CMINVOKECOMMANDINFOEX_REMOTE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CMINVOKECOMMANDINFOEX_REMOTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CMINVOKECOMMANDINFOEX_REMOTE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CM_COLUMNINFO {
    pub cbSize: u32,
    pub dwMask: u32,
    pub dwState: u32,
    pub uWidth: u32,
    pub uDefaultWidth: u32,
    pub uIdealWidth: u32,
    pub wszName: [u16; 80],
}
impl ::core::marker::Copy for CM_COLUMNINFO {}
impl ::core::clone::Clone for CM_COLUMNINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CM_COLUMNINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CM_COLUMNINFO").field("cbSize", &self.cbSize).field("dwMask", &self.dwMask).field("dwState", &self.dwState).field("uWidth", &self.uWidth).field("uDefaultWidth", &self.uDefaultWidth).field("uIdealWidth", &self.uIdealWidth).field("wszName", &self.wszName).finish()
    }
}
unsafe impl ::windows::core::Abi for CM_COLUMNINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CM_COLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CM_COLUMNINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CM_COLUMNINFO {}
impl ::core::default::Default for CM_COLUMNINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CM_ENUM_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_ENUM_ALL: CM_ENUM_FLAGS = CM_ENUM_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_ENUM_VISIBLE: CM_ENUM_FLAGS = CM_ENUM_FLAGS(2i32);
impl ::core::marker::Copy for CM_ENUM_FLAGS {}
impl ::core::clone::Clone for CM_ENUM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_ENUM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_ENUM_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_ENUM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_ENUM_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CM_MASK(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_MASK_WIDTH: CM_MASK = CM_MASK(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_MASK_DEFAULTWIDTH: CM_MASK = CM_MASK(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_MASK_IDEALWIDTH: CM_MASK = CM_MASK(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_MASK_NAME: CM_MASK = CM_MASK(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_MASK_STATE: CM_MASK = CM_MASK(16i32);
impl ::core::marker::Copy for CM_MASK {}
impl ::core::clone::Clone for CM_MASK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_MASK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_MASK {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_MASK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_MASK").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CM_SET_WIDTH_VALUE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_WIDTH_USEDEFAULT: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_WIDTH_AUTOSIZE: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-2i32);
impl ::core::marker::Copy for CM_SET_WIDTH_VALUE {}
impl ::core::clone::Clone for CM_SET_WIDTH_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_SET_WIDTH_VALUE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_SET_WIDTH_VALUE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_SET_WIDTH_VALUE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_SET_WIDTH_VALUE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CM_STATE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_STATE_NONE: CM_STATE = CM_STATE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_STATE_VISIBLE: CM_STATE = CM_STATE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_STATE_FIXEDWIDTH: CM_STATE = CM_STATE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_STATE_NOSORTBYFOLDERNESS: CM_STATE = CM_STATE(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CM_STATE_ALWAYSVISIBLE: CM_STATE = CM_STATE(8i32);
impl ::core::marker::Copy for CM_STATE {}
impl ::core::clone::Clone for CM_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMPONENT_DEFAULT_LEFT: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMPONENT_DEFAULT_TOP: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMPONENT_TOP: u32 = 1073741823u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_CHECKED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_CURITEMSTATE: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_DIRTY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_FRIENDLYNAME: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_NOSCROLL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_ORIGINAL_CSI: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_POS_LEFT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_POS_TOP: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_POS_ZINDEX: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_RESTORED_CSI: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_SIZE_HEIGHT: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_SIZE_WIDTH: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_SOURCE: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_SUBSCRIBEDURL: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_ELEM_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_TYPE_CFHTML: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_TYPE_CONTROL: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_TYPE_HTMLDOC: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_TYPE_MAX: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_TYPE_PICTURE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COMP_TYPE_WEBSITE: u32 = 2u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CONFIRM_CONFLICT_ITEM {
    pub pShellItem: ::core::option::Option<IShellItem2>,
    pub pszOriginalName: ::windows::core::PWSTR,
    pub pszAlternateName: ::windows::core::PWSTR,
    pub pszLocationShort: ::windows::core::PWSTR,
    pub pszLocationFull: ::windows::core::PWSTR,
    pub nType: SYNCMGR_CONFLICT_ITEM_TYPE,
}
impl ::core::clone::Clone for CONFIRM_CONFLICT_ITEM {
    fn clone(&self) -> Self {
        Self {
            pShellItem: self.pShellItem.clone(),
            pszOriginalName: self.pszOriginalName,
            pszAlternateName: self.pszAlternateName,
            pszLocationShort: self.pszLocationShort,
            pszLocationFull: self.pszLocationFull,
            nType: self.nType,
        }
    }
}
impl ::core::fmt::Debug for CONFIRM_CONFLICT_ITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CONFIRM_CONFLICT_ITEM").field("pShellItem", &self.pShellItem).field("pszOriginalName", &self.pszOriginalName).field("pszAlternateName", &self.pszAlternateName).field("pszLocationShort", &self.pszLocationShort).field("pszLocationFull", &self.pszLocationFull).field("nType", &self.nType).finish()
    }
}
unsafe impl ::windows::core::Abi for CONFIRM_CONFLICT_ITEM {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
impl ::core::cmp::PartialEq for CONFIRM_CONFLICT_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.pShellItem == other.pShellItem && self.pszOriginalName == other.pszOriginalName && self.pszAlternateName == other.pszAlternateName && self.pszLocationShort == other.pszLocationShort && self.pszLocationFull == other.pszLocationFull && self.nType == other.nType
    }
}
impl ::core::cmp::Eq for CONFIRM_CONFLICT_ITEM {}
impl ::core::default::Default for CONFIRM_CONFLICT_ITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CONFIRM_CONFLICT_RESULT_INFO {
    pub pszNewName: ::windows::core::PWSTR,
    pub iItemIndex: u32,
}
impl ::core::marker::Copy for CONFIRM_CONFLICT_RESULT_INFO {}
impl ::core::clone::Clone for CONFIRM_CONFLICT_RESULT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CONFIRM_CONFLICT_RESULT_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CONFIRM_CONFLICT_RESULT_INFO").field("pszNewName", &self.pszNewName).field("iItemIndex", &self.iItemIndex).finish()
    }
}
unsafe impl ::windows::core::Abi for CONFIRM_CONFLICT_RESULT_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CONFIRM_CONFLICT_RESULT_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CONFIRM_CONFLICT_RESULT_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CONFIRM_CONFLICT_RESULT_INFO {}
impl ::core::default::Default for CONFIRM_CONFLICT_RESULT_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CONFLICT_RESOLUTION_CLSID_KEY: &str = "ConflictResolutionCLSID";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ACCESSDENIED_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927681i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ACCESS_DENIED_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927710i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ACCESS_DENIED_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927711i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ALREADY_EXISTS_FOLDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927700i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ALREADY_EXISTS_NORMAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927703i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ALREADY_EXISTS_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927702i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ALREADY_EXISTS_SYSTEM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927701i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_BLOCKED_BY_DLP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927666i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927670i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_BLOCKED_BY_EDP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927672i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_CANCELLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927743i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_CANNOT_MOVE_FROM_RECYCLE_BIN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927677i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_CANNOT_MOVE_SHARED_FOLDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927676i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_CANT_REACH_SOURCE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927691i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_IS_RO_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927729i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_IS_RO_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927726i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_IS_RW_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927728i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_IS_RW_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927725i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_IS_R_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927727i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_IS_R_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927724i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_SAME_TREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927734i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DEST_SUBTREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927735i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DIFF_DIR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927740i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DIR_NOT_EMPTY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927683i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DISK_FULL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927694i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_DISK_FULL_CLEAN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927693i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_EA_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927698i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_EA_NOT_SUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927692i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ENCRYPTION_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927695i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_FAT_MAX_IN_ROOT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927682i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_FILE_IS_FLD_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927732i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_FILE_TOO_LARGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927731i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_FLD_IS_FILE_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927733i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927675i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_PAUSED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927674i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_INTERNET_ITEM_UNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927678i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_INVALID_FILES_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927716i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_INVALID_FILES_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927717i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_MANY_SRC_1_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927739i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_NET_DISCONNECT_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927706i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_NET_DISCONNECT_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927707i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_NEWFILE_NAME_TOO_LONG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927685i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_NEWFOLDER_NAME_TOO_LONG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927684i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_PATH_NOT_FOUND_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927708i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_PATH_NOT_FOUND_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927709i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_PATH_TOO_DEEP_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927714i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_PATH_TOO_DEEP_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927715i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_PROPERTIES_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927696i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_PROPERTY_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927697i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RECYCLE_BIN_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927686i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RECYCLE_FORCE_NUKE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927690i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RECYCLE_PATH_TOO_LONG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927688i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RECYCLE_SIZE_TOO_BIG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927689i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RECYCLE_UNKNOWN_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927691i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_REDIRECTED_TO_WEBPAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927680i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_REMOVABLE_FULL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927730i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927673i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927671i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_REQUIRES_ELEVATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927742i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RMS_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927668i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_RMS_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927669i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ROOT_DIR_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927712i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_ROOT_DIR_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927713i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SAME_FILE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927741i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SERVER_BAD_FILE_TYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927679i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SHARING_VIOLATION_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927704i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SHARING_VIOLATION_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927705i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SILENT_FAIL_BY_DLP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927665i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SRC_IS_RO_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927723i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SRC_IS_RO_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927720i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SRC_IS_RW_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927722i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SRC_IS_RW_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927719i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SRC_IS_R_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927721i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_SRC_IS_R_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927718i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_STREAM_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927699i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_USER_CANCELLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927744i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_E_WARNED_BY_DLP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927667i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_ALREADY_DONE: ::windows::core::HRESULT = ::windows::core::HRESULT(2555914i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_CLOSE_PROGRAM: ::windows::core::HRESULT = ::windows::core::HRESULT(2555917i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_COLLISIONRESOLVED: ::windows::core::HRESULT = ::windows::core::HRESULT(2555918i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_DONT_PROCESS_CHILDREN: ::windows::core::HRESULT = ::windows::core::HRESULT(2555912i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_KEEP_BOTH: ::windows::core::HRESULT = ::windows::core::HRESULT(2555916i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_MERGE: ::windows::core::HRESULT = ::windows::core::HRESULT(2555910i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_NOT_HANDLED: ::windows::core::HRESULT = ::windows::core::HRESULT(2555907i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_PENDING: ::windows::core::HRESULT = ::windows::core::HRESULT(2555915i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_PROGRESS_PAUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(2555919i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_USER_IGNORED: ::windows::core::HRESULT = ::windows::core::HRESULT(2555909i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_USER_RETRY: ::windows::core::HRESULT = ::windows::core::HRESULT(2555908i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const COPYENGINE_S_YES: ::windows::core::HRESULT = ::windows::core::HRESULT(2555905i32);
pub const CPFG_CREDENTIAL_PROVIDER_LABEL: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x286bbff3_bad4_438f_b007_79b7267c3d48);
pub const CPFG_CREDENTIAL_PROVIDER_LOGO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2d837775_f6cd_464e_a745_482fd0b47493);
pub const CPFG_LOGON_PASSWORD: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x60624cfa_a477_47b1_8a8e_3a4a19981827);
pub const CPFG_LOGON_USERNAME: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xda15bbe8_954d_4fd3_b0f4_1fb5b90b174b);
pub const CPFG_SMARTCARD_PIN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4fe5263b_9181_46c1_b0a4_9dedd4db7dea);
pub const CPFG_SMARTCARD_USERNAME: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e1ecf69_568c_4d96_9d59_46444174e2d6);
pub const CPFG_STANDALONE_SUBMIT_BUTTON: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b7b0ad8_cc36_4d59_802b_82f714fa7022);
pub const CPFG_STYLE_LINK_AS_BUTTON: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x088fa508_94a6_4430_a4cb_6fc6e3c0b9e2);
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CPLINFO {
    pub idIcon: i32,
    pub idName: i32,
    pub idInfo: i32,
    pub lData: isize,
}
impl ::core::marker::Copy for CPLINFO {}
impl ::core::clone::Clone for CPLINFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CPLINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CPLINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CPLINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CPLINFO {}
impl ::core::default::Default for CPLINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPLPAGE_DISPLAY_BACKGROUND: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPLPAGE_KEYBOARD_SPEED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPLPAGE_MOUSE_BUTTONS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPLPAGE_MOUSE_PTRMOTION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPLPAGE_MOUSE_WHEEL: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_DBLCLK: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_DYNAMIC_RES: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_EXIT: u32 = 7u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_GETCOUNT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_INIT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_INQUIRE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_NEWINQUIRE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_SELECT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_SETUP: u32 = 200u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_STARTWPARMS: u32 = 10u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_STARTWPARMSA: u32 = 9u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_STARTWPARMSW: u32 = 10u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPL_STOP: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CPVIEW(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPVIEW_CLASSIC: CPVIEW = CPVIEW(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPVIEW_ALLITEMS: CPVIEW = CPVIEW(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPVIEW_CATEGORY: CPVIEW = CPVIEW(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPVIEW_HOME: CPVIEW = CPVIEW(1i32);
impl ::core::marker::Copy for CPVIEW {}
impl ::core::clone::Clone for CPVIEW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CPVIEW {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CPVIEW {
    type Abi = Self;
}
impl ::core::fmt::Debug for CPVIEW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CPVIEW").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPAO_NONE: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPAO_EMPTY_LOCAL: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPAO_EMPTY_CONNECTED: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(2i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPCFO_NONE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPCFO_ENABLE_PASSWORD_REVEAL: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPCFO_IS_EMAIL_ADDRESS: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPCFO_ENABLE_TOUCH_KEYBOARD_AUTO_INVOKE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPCFO_NUMBERS_ONLY: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPCFO_SHOW_ENGLISH_KEYBOARD: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(16i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    pub ulAuthenticationPackage: u32,
    pub clsidCredentialProvider: ::windows::core::GUID,
    pub cbSerialization: u32,
    pub rgbSerialization: *mut u8,
}
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION").field("ulAuthenticationPackage", &self.ulAuthenticationPackage).field("clsidCredentialProvider", &self.clsidCredentialProvider).field("cbSerialization", &self.cbSerialization).field("rgbSerialization", &self.rgbSerialization).finish()
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION>()) == 0 }
    }
}
impl ::core::cmp::Eq for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {}
impl ::core::default::Default for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    pub dwFieldID: u32,
    pub cpft: CREDENTIAL_PROVIDER_FIELD_TYPE,
    pub pszLabel: ::windows::core::PWSTR,
    pub guidFieldType: ::windows::core::GUID,
}
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR").field("dwFieldID", &self.dwFieldID).field("cpft", &self.cpft).field("pszLabel", &self.pszLabel).field("guidFieldType", &self.guidFieldType).finish()
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR>()) == 0 }
    }
}
impl ::core::cmp::Eq for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFIS_NONE: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFIS_READONLY: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFIS_DISABLED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFIS_FOCUSED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_FIELD_STATE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFS_HIDDEN: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFS_DISPLAY_IN_SELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFS_DISPLAY_IN_DESELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFS_DISPLAY_IN_BOTH: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_STATE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_FIELD_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_FIELD_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_INVALID: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_LARGE_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_SMALL_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_COMMAND_LINK: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_EDIT_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_PASSWORD_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_TILE_IMAGE: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_CHECKBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_COMBOBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPFT_SUBMIT_BUTTON: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(9i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_TYPE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_FIELD_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPGSR_NO_CREDENTIAL_NOT_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPGSR_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPGSR_RETURN_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPGSR_RETURN_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CREDENTIAL_PROVIDER_NO_DEFAULT: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_STATUS_ICON(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPSI_NONE: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPSI_ERROR: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPSI_WARNING: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPSI_SUCCESS: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_STATUS_ICON {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_STATUS_ICON {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_STATUS_ICON").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CREDENTIAL_PROVIDER_USAGE_SCENARIO(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPUS_INVALID: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPUS_LOGON: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPUS_UNLOCK_WORKSTATION: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPUS_CHANGE_PASSWORD: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPUS_CREDUI: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CPUS_PLAP: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(5i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_USAGE_SCENARIO {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_USAGE_SCENARIO").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub struct CSFV {
    pub cbSize: u32,
    pub pshf: ::core::option::Option<IShellFolder>,
    pub psvOuter: ::core::option::Option<IShellView>,
    pub pidl: *mut Common::ITEMIDLIST,
    pub lEvents: i32,
    pub pfnCallback: LPFNVIEWCALLBACK,
    pub fvm: FOLDERVIEWMODE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for CSFV {
    fn clone(&self) -> Self {
        Self {
            cbSize: self.cbSize,
            pshf: self.pshf.clone(),
            psvOuter: self.psvOuter.clone(),
            pidl: self.pidl,
            lEvents: self.lEvents,
            pfnCallback: self.pfnCallback,
            fvm: self.fvm,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for CSFV {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CSFV").field("cbSize", &self.cbSize).field("pshf", &self.pshf).field("psvOuter", &self.psvOuter).field("pidl", &self.pidl).field("lEvents", &self.lEvents).field("pfnCallback", &self.pfnCallback.map(|f| f as usize)).field("fvm", &self.fvm).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for CSFV {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for CSFV {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pshf == other.pshf && self.psvOuter == other.psvOuter && self.pidl == other.pidl && self.lEvents == other.lEvents && self.pfnCallback.map(|f| f as usize) == other.pfnCallback.map(|f| f as usize) && self.fvm == other.fvm
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for CSFV {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for CSFV {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_ADMINTOOLS: u32 = 48u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_ALTSTARTUP: u32 = 29u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_APPDATA: u32 = 26u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_BITBUCKET: u32 = 10u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_CDBURN_AREA: u32 = 59u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_ADMINTOOLS: u32 = 47u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_ALTSTARTUP: u32 = 30u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_APPDATA: u32 = 35u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_DESKTOPDIRECTORY: u32 = 25u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_DOCUMENTS: u32 = 46u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_FAVORITES: u32 = 31u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_MUSIC: u32 = 53u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_OEM_LINKS: u32 = 58u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_PICTURES: u32 = 54u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_PROGRAMS: u32 = 23u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_STARTMENU: u32 = 22u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_STARTUP: u32 = 24u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_TEMPLATES: u32 = 45u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMMON_VIDEO: u32 = 55u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COMPUTERSNEARME: u32 = 61u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_CONNECTIONS: u32 = 49u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_CONTROLS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_COOKIES: u32 = 33u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_DESKTOP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_DESKTOPDIRECTORY: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_DRIVES: u32 = 17u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FAVORITES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_CREATE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_DONT_UNEXPAND: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_DONT_VERIFY: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_MASK: u32 = 65280u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_NO_ALIAS: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_PER_USER_INIT: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FLAG_PFTI_TRACKTARGET: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_FONTS: u32 = 20u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_HISTORY: u32 = 34u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_INTERNET: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_INTERNET_CACHE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_LOCAL_APPDATA: u32 = 28u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_MYDOCUMENTS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_MYMUSIC: u32 = 13u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_MYPICTURES: u32 = 39u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_MYVIDEO: u32 = 14u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_NETHOOD: u32 = 19u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_NETWORK: u32 = 18u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PERSONAL: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PRINTERS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PRINTHOOD: u32 = 27u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PROFILE: u32 = 40u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PROGRAMS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PROGRAM_FILES: u32 = 38u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PROGRAM_FILESX86: u32 = 42u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PROGRAM_FILES_COMMON: u32 = 43u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_PROGRAM_FILES_COMMONX86: u32 = 44u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_RECENT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_RESOURCES: u32 = 56u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_RESOURCES_LOCALIZED: u32 = 57u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_SENDTO: u32 = 9u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_STARTMENU: u32 = 11u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_STARTUP: u32 = 7u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_SYSTEM: u32 = 37u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_SYSTEMX86: u32 = 41u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_TEMPLATES: u32 = 21u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSIDL_WINDOWS: u32 = 36u32;
pub const CScriptErrorList: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefd01300_160f_11d2_bb2e_00805ff7efca);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_COINIT: i32 = 8i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_COINIT_MTA: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_COINIT_STA: i32 = 8i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_FREELIBANDEXIT: i32 = 16i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_INHERITWOW64: i32 = 256i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_INSIST: i32 = 1i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_KEYBOARD_LOCALE: i32 = 1024i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_NOADDREFLIB: i32 = 8192i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_OLEINITIALIZE: i32 = 2048i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_PROCESS_REF: i32 = 4i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_REF_COUNTED: i32 = 32i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_THREAD_REF: i32 = 2i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_UNUSED: i32 = 128i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_WAIT_ALLOWCOM: i32 = 64i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CTF_WAIT_NO_REENTRANCY: i32 = 512i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
    }
    ChrCmpIA(w1, w2)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
    }
    ChrCmpIW(w1, w2)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ColorAdjustLuma<'a, P0>(clrrgb: u32, n: i32, fscale: P0) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ColorAdjustLuma(clrrgb: u32, n: i32, fscale: super::super::Foundation::BOOL) -> u32;
    }
    ColorAdjustLuma(clrrgb, n, fscale.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> u32;
    }
    ColorHLSToRGB(whue, wluminance, wsaturation)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn ColorRGBToHLS(clrrgb: u32, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ColorRGBToHLS(clrrgb: u32, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16);
    }
    ColorRGBToHLS(clrrgb, ::core::mem::transmute(pwhue), ::core::mem::transmute(pwluminance), ::core::mem::transmute(pwsaturation))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn CommandLineToArgvW<'a, P0>(lpcmdline: P0, pnumargs: *mut i32) -> *mut ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CommandLineToArgvW(lpcmdline: ::windows::core::PCWSTR, pnumargs: *mut i32) -> *mut ::windows::core::PWSTR;
    }
    CommandLineToArgvW(lpcmdline.into(), ::core::mem::transmute(pnumargs))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CommandStateChangeConstants(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSC_UPDATECOMMANDS: CommandStateChangeConstants = CommandStateChangeConstants(-1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSC_NAVIGATEFORWARD: CommandStateChangeConstants = CommandStateChangeConstants(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const CSC_NAVIGATEBACK: CommandStateChangeConstants = CommandStateChangeConstants(2i32);
impl ::core::marker::Copy for CommandStateChangeConstants {}
impl ::core::clone::Clone for CommandStateChangeConstants {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CommandStateChangeConstants {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CommandStateChangeConstants {
    type Abi = Self;
}
impl ::core::fmt::Debug for CommandStateChangeConstants {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CommandStateChangeConstants").field(&self.0).finish()
    }
}
pub const ConflictFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x289978ac_a101_4341_a817_21eba7fd046d);
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn ConnectToConnectionPoint<'a, P0, P1, P2>(punk: P0, riidevent: *const ::windows::core::GUID, fconnect: P1, punktarget: P2, pdwcookie: *mut u32, ppcpout: *mut ::core::option::Option<super::super::System::Com::IConnectionPoint>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ConnectToConnectionPoint(punk: *mut ::core::ffi::c_void, riidevent: *const ::windows::core::GUID, fconnect: super::super::Foundation::BOOL, punktarget: *mut ::core::ffi::c_void, pdwcookie: *mut u32, ppcpout: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    ConnectToConnectionPoint(punk.into().abi(), ::core::mem::transmute(riidevent), fconnect.into(), punktarget.into().abi(), ::core::mem::transmute(pdwcookie), ::core::mem::transmute(ppcpout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn CreateProfile<'a, P0, P1>(pszusersid: P0, pszusername: P1, pszprofilepath: &mut [u16]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CreateProfile(pszusersid: ::windows::core::PCWSTR, pszusername: ::windows::core::PCWSTR, pszprofilepath: ::windows::core::PWSTR, cchprofilepath: u32) -> ::windows::core::HRESULT;
    }
    CreateProfile(pszusersid.into(), pszusername.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszprofilepath)), pszprofilepath.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_AutoScroll<'a, P0>(hwnd: P0, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_AutoScroll(hwnd: super::super::Foundation::HWND, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_AutoScroll(hwnd.into(), ::core::mem::transmute(pad), ::core::mem::transmute(pptnow))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragEnterEx<'a, P0>(hwndtarget: P0, ptstart: super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragEnterEx(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_DragEnterEx(hwndtarget.into(), ::core::mem::transmute(ptstart))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn DAD_DragEnterEx2<'a, P0, P1>(hwndtarget: P0, ptstart: super::super::Foundation::POINT, pdtobject: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragEnterEx2(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT, pdtobject: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    DAD_DragEnterEx2(hwndtarget.into(), ::core::mem::transmute(ptstart), pdtobject.into().abi())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragLeave() -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragLeave() -> super::super::Foundation::BOOL;
    }
    DAD_DragLeave()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_DragMove(::core::mem::transmute(pt))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
#[inline]
pub unsafe fn DAD_SetDragImage<'a, P0>(him: P0, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::Controls::HIMAGELIST>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_SetDragImage(him: super::Controls::HIMAGELIST, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_SetDragImage(him.into(), ::core::mem::transmute(pptoffset))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_ShowDragImage<'a, P0>(fshow: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_ShowDragImage(fshow: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    DAD_ShowDragImage(fshow.into())
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct DATABLOCK_HEADER {
    pub cbSize: u32,
    pub dwSignature: u32,
}
impl ::core::marker::Copy for DATABLOCK_HEADER {}
impl ::core::clone::Clone for DATABLOCK_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DATABLOCK_HEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DATABLOCK_HEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DATABLOCK_HEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for DATABLOCK_HEADER {}
impl ::core::default::Default for DATABLOCK_HEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DATAOBJ_GET_ITEM_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DOGIF_DEFAULT: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DOGIF_TRAVERSE_LINK: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DOGIF_NO_HDROP: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DOGIF_NO_URL: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DOGIF_ONLY_IF_ONE: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(8i32);
impl ::core::marker::Copy for DATAOBJ_GET_ITEM_FLAGS {}
impl ::core::clone::Clone for DATAOBJ_GET_ITEM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DATAOBJ_GET_ITEM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DATAOBJ_GET_ITEM_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DATAOBJ_GET_ITEM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DATAOBJ_GET_ITEM_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBCID_CLSIDOFBAR: i32 = 2i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBCID_EMPTY: i32 = 0i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBCID_GETBAR: i32 = 4i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBCID_ONDRAG: i32 = 1i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBCID_RESIZE: i32 = 3i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBCID_UPDATESIZE: i32 = 5i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBC_GS_IDEAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBC_GS_SIZEDOWN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBC_HIDE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBC_SHOW: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBC_SHOWOBSCURE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIF_VIEWMODE_FLOATING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIF_VIEWMODE_NORMAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIF_VIEWMODE_TRANSPARENT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIF_VIEWMODE_VERTICAL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_ADDTOFRONT: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_ALWAYSGRIPPER: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_BKCOLOR: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_BREAK: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_DEBOSSED: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_FIXED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_FIXEDBMP: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_NOGRIPPER: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_NOMARGINS: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_NORMAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_TOPALIGN: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_UNDELETEABLE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_USECHEVRON: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIMF_VARIABLEHEIGHT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_ACTUAL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_BKCOLOR: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_INTEGRAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_MAXSIZE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_MINSIZE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_MODEFLAGS: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBIM_TITLE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBPC_SELECTFIRST: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DEFAULTSAVEFOLDERTYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSFT_DETECT: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSFT_PRIVATE: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSFT_PUBLIC: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(3i32);
impl ::core::marker::Copy for DEFAULTSAVEFOLDERTYPE {}
impl ::core::clone::Clone for DEFAULTSAVEFOLDERTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DEFAULTSAVEFOLDERTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DEFAULTSAVEFOLDERTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DEFAULTSAVEFOLDERTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEFAULTSAVEFOLDERTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DEFAULT_FOLDER_MENU_RESTRICTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_DEFAULT: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_NO_STATIC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_STATIC_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_NO_RESOURCE_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_OPTIN_HANDLERS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_RESOURCE_AND_FOLDER_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_USE_SPECIFIED_HANDLERS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_USE_SPECIFIED_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(512i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_NO_ASYNC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(1024i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_NO_NATIVECPU_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(2048i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFMR_NO_NONWOW_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(4096i32);
impl ::core::marker::Copy for DEFAULT_FOLDER_MENU_RESTRICTIONS {}
impl ::core::clone::Clone for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEFAULT_FOLDER_MENU_RESTRICTIONS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
pub struct DEFCONTEXTMENU {
    pub hwnd: super::super::Foundation::HWND,
    pub pcmcb: ::core::option::Option<IContextMenuCB>,
    pub pidlFolder: *mut Common::ITEMIDLIST,
    pub psf: ::core::option::Option<IShellFolder>,
    pub cidl: u32,
    pub apidl: *mut *mut Common::ITEMIDLIST,
    pub punkAssociationInfo: ::core::option::Option<::windows::core::IUnknown>,
    pub cKeys: u32,
    pub aKeys: *const super::super::System::Registry::HKEY,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for DEFCONTEXTMENU {
    fn clone(&self) -> Self {
        Self {
            hwnd: self.hwnd,
            pcmcb: self.pcmcb.clone(),
            pidlFolder: self.pidlFolder,
            psf: self.psf.clone(),
            cidl: self.cidl,
            apidl: self.apidl,
            punkAssociationInfo: self.punkAssociationInfo.clone(),
            cKeys: self.cKeys,
            aKeys: self.aKeys,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for DEFCONTEXTMENU {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DEFCONTEXTMENU").field("hwnd", &self.hwnd).field("pcmcb", &self.pcmcb).field("pidlFolder", &self.pidlFolder).field("psf", &self.psf).field("cidl", &self.cidl).field("apidl", &self.apidl).field("punkAssociationInfo", &self.punkAssociationInfo).field("cKeys", &self.cKeys).field("aKeys", &self.aKeys).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for DEFCONTEXTMENU {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for DEFCONTEXTMENU {
    fn eq(&self, other: &Self) -> bool {
        self.hwnd == other.hwnd && self.pcmcb == other.pcmcb && self.pidlFolder == other.pidlFolder && self.psf == other.psf && self.cidl == other.cidl && self.apidl == other.apidl && self.punkAssociationInfo == other.punkAssociationInfo && self.cKeys == other.cKeys && self.aKeys == other.aKeys
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for DEFCONTEXTMENU {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for DEFCONTEXTMENU {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DEF_SHARE_ID(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DEFSHAREID_USERS: DEF_SHARE_ID = DEF_SHARE_ID(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DEFSHAREID_PUBLIC: DEF_SHARE_ID = DEF_SHARE_ID(2i32);
impl ::core::marker::Copy for DEF_SHARE_ID {}
impl ::core::clone::Clone for DEF_SHARE_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DEF_SHARE_ID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DEF_SHARE_ID {
    type Abi = Self;
}
impl ::core::fmt::Debug for DEF_SHARE_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEF_SHARE_ID").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct DELEGATEITEMID {
    pub cbSize: u16,
    pub wOuter: u16,
    pub cbInner: u16,
    pub rgb: [u8; 1],
}
impl ::core::marker::Copy for DELEGATEITEMID {}
impl ::core::clone::Clone for DELEGATEITEMID {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DELEGATEITEMID {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DELEGATEITEMID {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DELEGATEITEMID>()) == 0 }
    }
}
impl ::core::cmp::Eq for DELEGATEITEMID {}
impl ::core::default::Default for DELEGATEITEMID {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DESKBANDCID(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_BANDINFOCHANGED: DESKBANDCID = DESKBANDCID(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_SHOWONLY: DESKBANDCID = DESKBANDCID(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_MAXIMIZEBAND: DESKBANDCID = DESKBANDCID(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_PUSHCHEVRON: DESKBANDCID = DESKBANDCID(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_DELAYINIT: DESKBANDCID = DESKBANDCID(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_FINISHINIT: DESKBANDCID = DESKBANDCID(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_SETWINDOWTHEME: DESKBANDCID = DESKBANDCID(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DBID_PERMITAUTOHIDE: DESKBANDCID = DESKBANDCID(7i32);
impl ::core::marker::Copy for DESKBANDCID {}
impl ::core::clone::Clone for DESKBANDCID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKBANDCID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKBANDCID {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKBANDCID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKBANDCID").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DESKBANDINFO {
    pub dwMask: u32,
    pub ptMinSize: super::super::Foundation::POINTL,
    pub ptMaxSize: super::super::Foundation::POINTL,
    pub ptIntegral: super::super::Foundation::POINTL,
    pub ptActual: super::super::Foundation::POINTL,
    pub wszTitle: [u16; 256],
    pub dwModeFlags: u32,
    pub crBkgnd: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DESKBANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DESKBANDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DESKBANDINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DESKBANDINFO").field("dwMask", &self.dwMask).field("ptMinSize", &self.ptMinSize).field("ptMaxSize", &self.ptMaxSize).field("ptIntegral", &self.ptIntegral).field("ptActual", &self.ptActual).field("wszTitle", &self.wszTitle).field("dwModeFlags", &self.dwModeFlags).field("crBkgnd", &self.crBkgnd).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DESKBANDINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DESKBANDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DESKBANDINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DESKBANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DESKBANDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DESKTOP_SLIDESHOW_DIRECTION(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSD_FORWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSD_BACKWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(1i32);
impl ::core::marker::Copy for DESKTOP_SLIDESHOW_DIRECTION {}
impl ::core::clone::Clone for DESKTOP_SLIDESHOW_DIRECTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_SLIDESHOW_DIRECTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_SLIDESHOW_DIRECTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_SLIDESHOW_DIRECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_SLIDESHOW_DIRECTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DESKTOP_SLIDESHOW_OPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSO_SHUFFLEIMAGES: DESKTOP_SLIDESHOW_OPTIONS = DESKTOP_SLIDESHOW_OPTIONS(1i32);
impl ::core::marker::Copy for DESKTOP_SLIDESHOW_OPTIONS {}
impl ::core::clone::Clone for DESKTOP_SLIDESHOW_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_SLIDESHOW_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_SLIDESHOW_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_SLIDESHOW_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_SLIDESHOW_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DESKTOP_SLIDESHOW_STATE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSS_ENABLED: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSS_SLIDESHOW: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSS_DISABLED_BY_REMOTE_SESSION: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(4i32);
impl ::core::marker::Copy for DESKTOP_SLIDESHOW_STATE {}
impl ::core::clone::Clone for DESKTOP_SLIDESHOW_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_SLIDESHOW_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_SLIDESHOW_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_SLIDESHOW_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_SLIDESHOW_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DESKTOP_WALLPAPER_POSITION(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWPOS_CENTER: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWPOS_TILE: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWPOS_STRETCH: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWPOS_FIT: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWPOS_FILL: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWPOS_SPAN: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(5i32);
impl ::core::marker::Copy for DESKTOP_WALLPAPER_POSITION {}
impl ::core::clone::Clone for DESKTOP_WALLPAPER_POSITION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_WALLPAPER_POSITION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_WALLPAPER_POSITION {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_WALLPAPER_POSITION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_WALLPAPER_POSITION").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
pub struct DETAILSINFO {
    pub pidl: *mut Common::ITEMIDLIST,
    pub fmt: i32,
    pub cxChar: i32,
    pub str: Common::STRRET,
    pub iImage: i32,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::marker::Copy for DETAILSINFO {}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::clone::Clone for DETAILSINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
unsafe impl ::windows::core::Abi for DETAILSINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::cmp::PartialEq for DETAILSINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DETAILSINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::cmp::Eq for DETAILSINFO {}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::default::Default for DETAILSINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DFConstraint(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DFConstraint {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Value(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Value)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DFConstraint> for ::windows::core::IUnknown {
    fn from(value: DFConstraint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DFConstraint> for &'a ::windows::core::IUnknown {
    fn from(value: &'a DFConstraint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DFConstraint> for ::windows::core::IUnknown {
    fn from(value: &DFConstraint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DFConstraint> for super::super::System::Com::IDispatch {
    fn from(value: DFConstraint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DFConstraint> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a DFConstraint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DFConstraint> for super::super::System::Com::IDispatch {
    fn from(value: &DFConstraint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DFConstraint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DFConstraint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DFConstraint {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DFConstraint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFConstraint").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DFConstraint {
    type Vtable = DFConstraint_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4a3df050_23bd_11d2_939f_00a0c91eedba);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DFConstraint_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Value: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pv: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Value: usize,
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DFMICS {
    pub cbSize: u32,
    pub fMask: u32,
    pub lParam: super::super::Foundation::LPARAM,
    pub idCmdFirst: u32,
    pub idDefMax: u32,
    pub pici: *mut CMINVOKECOMMANDINFO,
    pub punkSite: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DFMICS {
    fn clone(&self) -> Self {
        Self {
            cbSize: self.cbSize,
            fMask: self.fMask,
            lParam: self.lParam,
            idCmdFirst: self.idCmdFirst,
            idDefMax: self.idDefMax,
            pici: self.pici,
            punkSite: self.punkSite.clone(),
        }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DFMICS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DFMICS").field("cbSize", &self.cbSize).field("fMask", &self.fMask).field("lParam", &self.lParam).field("idCmdFirst", &self.idCmdFirst).field("idDefMax", &self.idDefMax).field("pici", &self.pici).field("punkSite", &self.punkSite).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DFMICS {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DFMICS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.fMask == other.fMask && self.lParam == other.lParam && self.idCmdFirst == other.idCmdFirst && self.idDefMax == other.idDefMax && self.pici == other.pici && self.punkSite == other.punkSite
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DFMICS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DFMICS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DFM_CMD(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_DELETE: DFM_CMD = DFM_CMD(-1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_MOVE: DFM_CMD = DFM_CMD(-2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_COPY: DFM_CMD = DFM_CMD(-3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_LINK: DFM_CMD = DFM_CMD(-4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_PROPERTIES: DFM_CMD = DFM_CMD(-5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_NEWFOLDER: DFM_CMD = DFM_CMD(-6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_PASTE: DFM_CMD = DFM_CMD(-7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_VIEWLIST: DFM_CMD = DFM_CMD(-8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_VIEWDETAILS: DFM_CMD = DFM_CMD(-9i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_PASTELINK: DFM_CMD = DFM_CMD(-10i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_PASTESPECIAL: DFM_CMD = DFM_CMD(-11i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_MODALPROP: DFM_CMD = DFM_CMD(-12i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_CMD_RENAME: DFM_CMD = DFM_CMD(-13i32);
impl ::core::marker::Copy for DFM_CMD {}
impl ::core::clone::Clone for DFM_CMD {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DFM_CMD {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DFM_CMD {
    type Abi = Self;
}
impl ::core::fmt::Debug for DFM_CMD {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFM_CMD").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DFM_MESSAGE_ID(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_MERGECONTEXTMENU: DFM_MESSAGE_ID = DFM_MESSAGE_ID(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_INVOKECOMMAND: DFM_MESSAGE_ID = DFM_MESSAGE_ID(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_GETHELPTEXT: DFM_MESSAGE_ID = DFM_MESSAGE_ID(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_WM_MEASUREITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_WM_DRAWITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_WM_INITMENUPOPUP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_VALIDATECMD: DFM_MESSAGE_ID = DFM_MESSAGE_ID(9i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_MERGECONTEXTMENU_TOP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(10i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_GETHELPTEXTW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(11i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_INVOKECOMMANDEX: DFM_MESSAGE_ID = DFM_MESSAGE_ID(12i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_MAPCOMMANDNAME: DFM_MESSAGE_ID = DFM_MESSAGE_ID(13i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_GETDEFSTATICID: DFM_MESSAGE_ID = DFM_MESSAGE_ID(14i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_GETVERBW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(15i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_GETVERBA: DFM_MESSAGE_ID = DFM_MESSAGE_ID(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_MERGECONTEXTMENU_BOTTOM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(17i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DFM_MODIFYQCMFLAGS: DFM_MESSAGE_ID = DFM_MESSAGE_ID(18i32);
impl ::core::marker::Copy for DFM_MESSAGE_ID {}
impl ::core::clone::Clone for DFM_MESSAGE_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DFM_MESSAGE_ID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DFM_MESSAGE_ID {
    type Abi = Self;
}
impl ::core::fmt::Debug for DFM_MESSAGE_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFM_MESSAGE_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_BEGINDRAG: u32 = 204u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_CHECKSTATECHANGED: u32 = 209u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_COLUMNSCHANGED: u32 = 212u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_CONTENTSCHANGED: u32 = 207u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_CTRLMOUSEWHEEL: u32 = 213u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_DEFAULTVERBINVOKED: u32 = 203u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_ENTERPRESSED: u32 = 200u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_ENTERPRISEIDCHANGED: u32 = 224u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_EXPLORERWINDOWREADY: u32 = 221u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_FILELISTENUMDONE: u32 = 201u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_FILTERINVOKED: u32 = 218u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_FOCUSCHANGED: u32 = 208u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_FOLDERCHANGED: u32 = 217u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_DEFAULTCAT: u32 = 262u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_DIRTY: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_FORCEX86: u32 = 259u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_ONDOMAIN: u32 = 261u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_PUBCAT: u32 = 257u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_SHOWPOSTSETUP: u32 = 260u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_IADCCTL_SORT: u32 = 258u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_ICONSIZECHANGED: u32 = 215u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_INITIALENUMERATIONDONE: u32 = 223u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_NOITEMSTATE_CHANGED: u32 = 206u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_ORDERCHANGED: u32 = 210u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_ABORT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_COMPLETE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_ERROR: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_PROGRESSTEXT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_RESTORE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_START: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SEARCHCOMMAND_UPDATE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SELECTEDITEMCHANGED: u32 = 220u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SELECTIONCHANGED: u32 = 200u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_SORTDONE: u32 = 214u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_UPDATEIMAGE: u32 = 222u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_VERBINVOKED: u32 = 202u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_VIEWMODECHANGED: u32 = 205u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_VIEWPAINTDONE: u32 = 211u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DISPID_WORDWHEELEDITED: u32 = 219u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DISPLAY_DEVICE_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DEVICE_PRIMARY: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DEVICE_IMMERSIVE: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(1i32);
impl ::core::marker::Copy for DISPLAY_DEVICE_TYPE {}
impl ::core::clone::Clone for DISPLAY_DEVICE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DISPLAY_DEVICE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DISPLAY_DEVICE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DISPLAY_DEVICE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DISPLAY_DEVICE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DI_GETDRAGIMAGE: &str = "ShellGetDragImage";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLG_SCRNSAVECONFIGURE: u32 = 2003u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub type DLLGETVERSIONPROC = ::core::option::Option<unsafe extern "system" fn(param0: *mut DLLVERSIONINFO) -> ::windows::core::HRESULT>;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct DLLVERSIONINFO {
    pub cbSize: u32,
    pub dwMajorVersion: u32,
    pub dwMinorVersion: u32,
    pub dwBuildNumber: u32,
    pub dwPlatformID: u32,
}
impl ::core::marker::Copy for DLLVERSIONINFO {}
impl ::core::clone::Clone for DLLVERSIONINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DLLVERSIONINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DLLVERSIONINFO").field("cbSize", &self.cbSize).field("dwMajorVersion", &self.dwMajorVersion).field("dwMinorVersion", &self.dwMinorVersion).field("dwBuildNumber", &self.dwBuildNumber).field("dwPlatformID", &self.dwPlatformID).finish()
    }
}
unsafe impl ::windows::core::Abi for DLLVERSIONINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DLLVERSIONINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DLLVERSIONINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for DLLVERSIONINFO {}
impl ::core::default::Default for DLLVERSIONINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct DLLVERSIONINFO2 {
    pub info1: DLLVERSIONINFO,
    pub dwFlags: u32,
    pub ullVersion: u64,
}
impl ::core::marker::Copy for DLLVERSIONINFO2 {}
impl ::core::clone::Clone for DLLVERSIONINFO2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DLLVERSIONINFO2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DLLVERSIONINFO2").field("info1", &self.info1).field("dwFlags", &self.dwFlags).field("ullVersion", &self.ullVersion).finish()
    }
}
unsafe impl ::windows::core::Abi for DLLVERSIONINFO2 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DLLVERSIONINFO2 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DLLVERSIONINFO2>()) == 0 }
    }
}
impl ::core::cmp::Eq for DLLVERSIONINFO2 {}
impl ::core::default::Default for DLLVERSIONINFO2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLLVER_BUILD_MASK: u64 = 4294901760u64;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLLVER_MAJOR_MASK: u64 = 18446462598732840960u64;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLLVER_MINOR_MASK: u64 = 281470681743360u64;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLLVER_PLATFORM_NT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLLVER_PLATFORM_WINDOWS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DLLVER_QFE_MASK: u64 = 65535u64;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: ::windows::core::PSTR,
    pub grfKeyState: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOA {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOA>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: ::windows::core::PSTR,
    pub grfKeyState: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOA {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOA>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: ::windows::core::PWSTR,
    pub grfKeyState: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOW {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOW {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOW>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOW {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: ::windows::core::PWSTR,
    pub grfKeyState: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOW {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOW {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOW>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOW {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct DROPDESCRIPTION {
    pub r#type: DROPIMAGETYPE,
    pub szMessage: [u16; 260],
    pub szInsert: [u16; 260],
}
impl ::core::marker::Copy for DROPDESCRIPTION {}
impl ::core::clone::Clone for DROPDESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DROPDESCRIPTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DROPDESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DROPDESCRIPTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for DROPDESCRIPTION {}
impl ::core::default::Default for DROPDESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DROPFILES {
    pub pFiles: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub fWide: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DROPFILES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DROPFILES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DROPFILES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DROPFILES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DROPFILES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DROPFILES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DROPFILES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DROPIMAGETYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_INVALID: DROPIMAGETYPE = DROPIMAGETYPE(-1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_NONE: DROPIMAGETYPE = DROPIMAGETYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_COPY: DROPIMAGETYPE = DROPIMAGETYPE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_MOVE: DROPIMAGETYPE = DROPIMAGETYPE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_LINK: DROPIMAGETYPE = DROPIMAGETYPE(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_LABEL: DROPIMAGETYPE = DROPIMAGETYPE(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_WARNING: DROPIMAGETYPE = DROPIMAGETYPE(7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DROPIMAGE_NOIMAGE: DROPIMAGETYPE = DROPIMAGETYPE(8i32);
impl ::core::marker::Copy for DROPIMAGETYPE {}
impl ::core::clone::Clone for DROPIMAGETYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DROPIMAGETYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DROPIMAGETYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DROPIMAGETYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DROPIMAGETYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DSH_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DSH_ALLOWDROPDESCRIPTIONTEXT: DSH_FLAGS = DSH_FLAGS(1i32);
impl ::core::marker::Copy for DSH_FLAGS {}
impl ::core::clone::Clone for DSH_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DSH_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DSH_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DSH_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DSH_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellFolderViewEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellFolderViewEvents> for ::windows::core::IUnknown {
    fn from(value: DShellFolderViewEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DShellFolderViewEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a DShellFolderViewEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellFolderViewEvents> for ::windows::core::IUnknown {
    fn from(value: &DShellFolderViewEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellFolderViewEvents> for super::super::System::Com::IDispatch {
    fn from(value: DShellFolderViewEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DShellFolderViewEvents> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a DShellFolderViewEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellFolderViewEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DShellFolderViewEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellFolderViewEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellFolderViewEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellFolderViewEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellFolderViewEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellFolderViewEvents {
    type Vtable = DShellFolderViewEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62112aa2_ebe4_11cf_a5fb_0020afe7292d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellFolderViewEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellNameSpaceEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellNameSpaceEvents> for ::windows::core::IUnknown {
    fn from(value: DShellNameSpaceEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DShellNameSpaceEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a DShellNameSpaceEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellNameSpaceEvents> for ::windows::core::IUnknown {
    fn from(value: &DShellNameSpaceEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellNameSpaceEvents> for super::super::System::Com::IDispatch {
    fn from(value: DShellNameSpaceEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DShellNameSpaceEvents> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a DShellNameSpaceEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellNameSpaceEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DShellNameSpaceEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellNameSpaceEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellNameSpaceEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellNameSpaceEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellNameSpaceEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellNameSpaceEvents {
    type Vtable = DShellNameSpaceEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55136806_b2de_11d1_b9f2_00a0c98bc547);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellNameSpaceEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellWindowsEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellWindowsEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellWindowsEvents> for ::windows::core::IUnknown {
    fn from(value: DShellWindowsEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DShellWindowsEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a DShellWindowsEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellWindowsEvents> for ::windows::core::IUnknown {
    fn from(value: &DShellWindowsEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellWindowsEvents> for super::super::System::Com::IDispatch {
    fn from(value: DShellWindowsEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DShellWindowsEvents> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a DShellWindowsEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellWindowsEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DShellWindowsEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellWindowsEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellWindowsEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellWindowsEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellWindowsEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellWindowsEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellWindowsEvents {
    type Vtable = DShellWindowsEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfe4106e0_399a_11d0_a48c_00a0c90a8f39);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellWindowsEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DVASPECT_COPY: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DVASPECT_LINK: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DVASPECT_SHORTNAME: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWFAF_AUTOHIDE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWFAF_GROUP1: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWFAF_GROUP2: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWFAF_HIDDEN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWFRF_DELETECONFIGDATA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const DWFRF_NORMAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DWebBrowserEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents> for ::windows::core::IUnknown {
    fn from(value: DWebBrowserEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DWebBrowserEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a DWebBrowserEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents> for ::windows::core::IUnknown {
    fn from(value: &DWebBrowserEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents> for super::super::System::Com::IDispatch {
    fn from(value: DWebBrowserEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DWebBrowserEvents> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a DWebBrowserEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DWebBrowserEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DWebBrowserEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DWebBrowserEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DWebBrowserEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DWebBrowserEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DWebBrowserEvents {
    type Vtable = DWebBrowserEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeab22ac2_30c1_11cf_a7eb_0000c05bae0b);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DWebBrowserEvents2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents2> for ::windows::core::IUnknown {
    fn from(value: DWebBrowserEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DWebBrowserEvents2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a DWebBrowserEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents2> for ::windows::core::IUnknown {
    fn from(value: &DWebBrowserEvents2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents2> for super::super::System::Com::IDispatch {
    fn from(value: DWebBrowserEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a DWebBrowserEvents2> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a DWebBrowserEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents2> for super::super::System::Com::IDispatch {
    fn from(value: &DWebBrowserEvents2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DWebBrowserEvents2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DWebBrowserEvents2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DWebBrowserEvents2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DWebBrowserEvents2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DWebBrowserEvents2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DWebBrowserEvents2 {
    type Vtable = DWebBrowserEvents2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x34a715a0_6587_11d0_924a_0020afc7ac4d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
pub const DefFolderMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc63382be_7933_48d0_9ac8_85fb46be2fdd);
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DefSubclassProc<'a, P0, P1, P2>(hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
    P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DefSubclassProc(hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    }
    DefSubclassProc(hwnd.into(), umsg, wparam.into(), lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DeleteProfileA<'a, P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DeleteProfileA(lpsidstring: ::windows::core::PCSTR, lpprofilepath: ::windows::core::PCSTR, lpcomputername: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    DeleteProfileA(lpsidstring.into(), lpprofilepath.into(), lpcomputername.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DeleteProfileW<'a, P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DeleteProfileW(lpsidstring: ::windows::core::PCWSTR, lpprofilepath: ::windows::core::PCWSTR, lpcomputername: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    DeleteProfileW(lpsidstring.into(), lpprofilepath.into(), lpcomputername.into())
}
pub const DesktopGadget: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x924ccc1b_6562_4c85_8657_d177925222b6);
pub const DesktopWallpaper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc2cf3110_460e_4fc1_b9d0_8a1c0c9cc4bd);
pub const DestinationList: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x77f10cf0_3db5_4966_b520_b7c54fd35ed6);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DoEnvironmentSubstA(pszsrc: &mut [u8]) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DoEnvironmentSubstA(pszsrc: ::windows::core::PSTR, cchsrc: u32) -> u32;
    }
    DoEnvironmentSubstA(::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszsrc)), pszsrc.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DoEnvironmentSubstW(pszsrc: &mut [u16]) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DoEnvironmentSubstW(pszsrc: ::windows::core::PWSTR, cchsrc: u32) -> u32;
    }
    DoEnvironmentSubstW(::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszsrc)), pszsrc.len() as _)
}
pub const DocPropShellExtension: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x883373c3_bf89_11d1_be35_080036b11a03);
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragAcceptFiles<'a, P0, P1>(hwnd: P0, faccept: P1)
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragAcceptFiles(hwnd: super::super::Foundation::HWND, faccept: super::super::Foundation::BOOL);
    }
    DragAcceptFiles(hwnd.into(), faccept.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DragFinish<'a, P0>(hdrop: P0)
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragFinish(hdrop: HDROP);
    }
    DragFinish(hdrop.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DragQueryFileA<'a, P0>(hdrop: P0, ifile: u32, lpszfile: &mut [u8]) -> u32
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragQueryFileA(hdrop: HDROP, ifile: u32, lpszfile: ::windows::core::PSTR, cch: u32) -> u32;
    }
    DragQueryFileA(hdrop.into(), ifile, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(lpszfile)), lpszfile.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DragQueryFileW<'a, P0>(hdrop: P0, ifile: u32, lpszfile: &mut [u16]) -> u32
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragQueryFileW(hdrop: HDROP, ifile: u32, lpszfile: ::windows::core::PWSTR, cch: u32) -> u32;
    }
    DragQueryFileW(hdrop.into(), ifile, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(lpszfile)), lpszfile.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragQueryPoint<'a, P0>(hdrop: P0, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragQueryPoint(hdrop: HDROP, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DragQueryPoint(hdrop.into(), ::core::mem::transmute(ppt))
}
pub const DriveSizeCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94357b53_ca29_4b78_83ae_e8fe7409134f);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DriveType(idrive: i32) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DriveType(idrive: i32) -> i32;
    }
    DriveType(idrive)
}
pub const DriveTypeCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb0a8f3cf_4333_4bab_8873_1ccb1cada48b);
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn DuplicateIcon<'a, P0, P1>(hinst: P0, hicon: P1) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<super::WindowsAndMessaging::HICON>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DuplicateIcon(hinst: super::super::Foundation::HINSTANCE, hicon: super::WindowsAndMessaging::HICON) -> super::WindowsAndMessaging::HICON;
    }
    DuplicateIcon(hinst.into(), hicon.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EC_HOST_UI_MODE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ECHUIM_DESKTOP: EC_HOST_UI_MODE = EC_HOST_UI_MODE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ECHUIM_IMMERSIVE: EC_HOST_UI_MODE = EC_HOST_UI_MODE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ECHUIM_SYSTEM_LAUNCHER: EC_HOST_UI_MODE = EC_HOST_UI_MODE(2i32);
impl ::core::marker::Copy for EC_HOST_UI_MODE {}
impl ::core::clone::Clone for EC_HOST_UI_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EC_HOST_UI_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EC_HOST_UI_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for EC_HOST_UI_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EC_HOST_UI_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EDGE_GESTURE_KIND(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EGK_TOUCH: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EGK_KEYBOARD: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EGK_MOUSE: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(2i32);
impl ::core::marker::Copy for EDGE_GESTURE_KIND {}
impl ::core::clone::Clone for EDGE_GESTURE_KIND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EDGE_GESTURE_KIND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EDGE_GESTURE_KIND {
    type Abi = Self;
}
impl ::core::fmt::Debug for EDGE_GESTURE_KIND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EDGE_GESTURE_KIND").field(&self.0).finish()
    }
}
pub const EP_AdvQueryPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4e9db8b_34ba_4c39_b5cc_16a1bd2c411c);
pub const EP_Commands: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd9745868_ca5f_4a76_91cd_f5a129fbb076);
pub const EP_Commands_Organize: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x72e81700_e3ec_4660_bf24_3c3b7b648806);
pub const EP_Commands_View: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x21f7c32d_eeaa_439b_bb51_37b96fd6a943);
pub const EP_DetailsPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x43abf98b_89b8_472d_b9ce_e69b8229f019);
pub const EP_NavPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcb316b22_25f7_42b8_8a09_540d23a43c2f);
pub const EP_PreviewPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x893c63d1_45c8_4d17_be19_223be71be365);
pub const EP_QueryPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x65bcde4f_4f07_4f27_83a7_1afca4df7ddd);
pub const EP_Ribbon: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd27524a8_c9f2_4834_a106_df8889fd4f37);
pub const EP_StatusBar: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x65fe56ce_5cfe_4bc4_ad8a_7ae3fe7e8f7c);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EXECUTE_E_LAUNCH_APPLICATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927487i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EXPLORER_BROWSER_FILL_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBF_NONE: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBF_SELECTFROMDATAOBJECT: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBF_NODROPTARGET: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(512i32);
impl ::core::marker::Copy for EXPLORER_BROWSER_FILL_FLAGS {}
impl ::core::clone::Clone for EXPLORER_BROWSER_FILL_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EXPLORER_BROWSER_FILL_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EXPLORER_BROWSER_FILL_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for EXPLORER_BROWSER_FILL_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EXPLORER_BROWSER_FILL_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct EXPLORER_BROWSER_OPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_NONE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_NAVIGATEONCE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_SHOWFRAMES: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_ALWAYSNAVIGATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_NOTRAVELLOG: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_NOWRAPPERWINDOW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_HTMLSHAREPOINTVIEW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_NOBORDER: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EBO_NOPERSISTVIEWSTATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(128i32);
impl ::core::marker::Copy for EXPLORER_BROWSER_OPTIONS {}
impl ::core::clone::Clone for EXPLORER_BROWSER_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EXPLORER_BROWSER_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EXPLORER_BROWSER_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for EXPLORER_BROWSER_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EXPLORER_BROWSER_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EXP_DARWIN_ID_SIG: u32 = 2684354566u32;
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct EXP_DARWIN_LINK {
    pub dbh: DATABLOCK_HEADER,
    pub szDarwinID: [super::super::Foundation::CHAR; 260],
    pub szwDarwinID: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for EXP_DARWIN_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for EXP_DARWIN_LINK {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXP_DARWIN_LINK {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXP_DARWIN_LINK {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_DARWIN_LINK>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXP_DARWIN_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXP_DARWIN_LINK {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct EXP_PROPERTYSTORAGE {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub abPropertyStorage: [u8; 1],
}
impl ::core::marker::Copy for EXP_PROPERTYSTORAGE {}
impl ::core::clone::Clone for EXP_PROPERTYSTORAGE {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for EXP_PROPERTYSTORAGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EXP_PROPERTYSTORAGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_PROPERTYSTORAGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for EXP_PROPERTYSTORAGE {}
impl ::core::default::Default for EXP_PROPERTYSTORAGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EXP_PROPERTYSTORAGE_SIG: u32 = 2684354569u32;
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct EXP_SPECIAL_FOLDER {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub idSpecialFolder: u32,
    pub cbOffset: u32,
}
impl ::core::marker::Copy for EXP_SPECIAL_FOLDER {}
impl ::core::clone::Clone for EXP_SPECIAL_FOLDER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for EXP_SPECIAL_FOLDER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EXP_SPECIAL_FOLDER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_SPECIAL_FOLDER>()) == 0 }
    }
}
impl ::core::cmp::Eq for EXP_SPECIAL_FOLDER {}
impl ::core::default::Default for EXP_SPECIAL_FOLDER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EXP_SPECIAL_FOLDER_SIG: u32 = 2684354565u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EXP_SZ_ICON_SIG: u32 = 2684354567u32;
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct EXP_SZ_LINK {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub szTarget: [super::super::Foundation::CHAR; 260],
    pub swzTarget: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for EXP_SZ_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for EXP_SZ_LINK {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXP_SZ_LINK {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXP_SZ_LINK {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_SZ_LINK>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXP_SZ_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXP_SZ_LINK {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const EXP_SZ_LINK_SIG: u32 = 2684354561u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct EXTRASEARCH {
    pub guidSearch: ::windows::core::GUID,
    pub wszFriendlyName: [u16; 80],
    pub wszUrl: [u16; 2084],
}
impl ::core::marker::Copy for EXTRASEARCH {}
impl ::core::clone::Clone for EXTRASEARCH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for EXTRASEARCH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("EXTRASEARCH").field("guidSearch", &self.guidSearch).field("wszFriendlyName", &self.wszFriendlyName).field("wszUrl", &self.wszUrl).finish()
    }
}
unsafe impl ::windows::core::Abi for EXTRASEARCH {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EXTRASEARCH {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXTRASEARCH>()) == 0 }
    }
}
impl ::core::cmp::Eq for EXTRASEARCH {}
impl ::core::default::Default for EXTRASEARCH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_ACTIVATIONDENIED_SHELLERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927439i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_ACTIVATIONDENIED_SHELLNOTREADY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927436i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_ACTIVATIONDENIED_SHELLRESTART: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927438i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_ACTIVATIONDENIED_UNEXPECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927437i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_ACTIVATIONDENIED_USERCLOSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927440i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_FILE_PLACEHOLDER_NOT_INITIALIZED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927472i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_FILE_PLACEHOLDER_SERVER_TIMED_OUT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927470i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_FILE_PLACEHOLDER_STORAGEPROVIDER_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927469i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_FILE_PLACEHOLDER_VERSION_MISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927471i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_FLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217408i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_IMAGEFEED_CHANGEDISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144926960i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_NOTVALIDFORANIMATEDIMAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147221503i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_PREVIEWHANDLER_CORRUPT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494972i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_PREVIEWHANDLER_DRM_FAIL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494975i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_PREVIEWHANDLER_NOAUTH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494974i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_PREVIEWHANDLER_NOTFOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494973i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_SHELL_EXTENSION_BLOCKED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144926975i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_TILE_NOTIFICATIONS_PLATFORM_FAILURE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927159i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_USERTILE_CHANGEDISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927215i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_USERTILE_FILESIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927212i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_USERTILE_LARGEORDYNAMIC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927214i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_USERTILE_UNSUPPORTEDFILETYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927216i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const E_USERTILE_VIDEOFRAMESIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927213i32);
pub const EnumerableObjectCollection: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2d3468c1_36a7_43b6_ac24_d3f02fd9607a);
pub const ExecuteFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x11dbb47c_a525_400b_9e80_a54615a090c0);
pub const ExecuteUnknown: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe44e9428_bdbc_4987_a099_40dc8fd255e7);
pub const ExplorerBrowser: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71f96385_ddd6_48d3_a0c1_ae06e8b055fb);
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconA<'a, P0>(hinst: P0, psziconpath: &mut [u8; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconA(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PSTR, piicon: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconA(hinst.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(psziconpath)), ::core::mem::transmute(piicon))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconExA<'a, P0>(hinst: P0, psziconpath: &mut [u8; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconExA(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PSTR, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconExA(hinst.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(psziconpath)), ::core::mem::transmute(piiconindex), ::core::mem::transmute(piiconid))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconExW<'a, P0>(hinst: P0, psziconpath: &mut [u16; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconExW(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PWSTR, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconExW(hinst.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(psziconpath)), ::core::mem::transmute(piiconindex), ::core::mem::transmute(piiconid))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconW<'a, P0>(hinst: P0, psziconpath: &mut [u16; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconW(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PWSTR, piicon: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconW(hinst.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(psziconpath)), ::core::mem::transmute(piicon))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconA<'a, P0, P1>(hinst: P0, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconA(hinst: super::super::Foundation::HINSTANCE, pszexefilename: ::windows::core::PCSTR, niconindex: u32) -> super::WindowsAndMessaging::HICON;
    }
    ExtractIconA(hinst.into(), pszexefilename.into(), niconindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExA<'a, P0>(lpszfile: P0, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconExA(lpszfile: ::windows::core::PCSTR, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32;
    }
    ExtractIconExA(lpszfile.into(), niconindex, ::core::mem::transmute(phiconlarge), ::core::mem::transmute(phiconsmall), ::core::mem::transmute(nicons))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExW<'a, P0>(lpszfile: P0, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconExW(lpszfile: ::windows::core::PCWSTR, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32;
    }
    ExtractIconExW(lpszfile.into(), niconindex, ::core::mem::transmute(phiconlarge), ::core::mem::transmute(phiconsmall), ::core::mem::transmute(nicons))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconW<'a, P0, P1>(hinst: P0, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconW(hinst: super::super::Foundation::HINSTANCE, pszexefilename: ::windows::core::PCWSTR, niconindex: u32) -> super::WindowsAndMessaging::HICON;
    }
    ExtractIconW(hinst.into(), pszexefilename.into(), niconindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_BROWSERFIRST: u32 = 40960u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_BROWSERLAST: u32 = 48896u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_GLOBALFIRST: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_GLOBALLAST: u32 = 40959u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_EDIT: u32 = 32832u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_EXPLORE: u32 = 33104u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_FAVORITES: u32 = 33136u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_FILE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_FIND: u32 = 33088u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_HELP: u32 = 33024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_TOOLS: u32 = 32960u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_TOOLS_SEP_GOTO: u32 = 32961u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_VIEW: u32 = 32896u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_MENU_VIEW_SEP_OPTIONS: u32 = 32897u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_SHVIEWFIRST: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_SHVIEWLAST: u32 = 32767u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_STATUS: u32 = 40961u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCIDM_TOOLBAR: u32 = 40960u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_CLSID: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_FLAGS: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_ICONFILE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_INFOTIP: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_LOGO: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_VIEWID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCSM_WEBVIEWTEMPLATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCS_FLAG_DRAGDROP: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCS_FORCEWRITE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCS_READ: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCT_ADDTOEND: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCT_CONFIGABLE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCT_MERGE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCW_INTERNETBAR: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCW_PROGRESS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCW_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCW_TOOLBAR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FCW_TREE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FDAP(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDAP_BOTTOM: FDAP = FDAP(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDAP_TOP: FDAP = FDAP(1i32);
impl ::core::marker::Copy for FDAP {}
impl ::core::clone::Clone for FDAP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FDAP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FDAP {
    type Abi = Self;
}
impl ::core::fmt::Debug for FDAP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FDAP").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FDE_OVERWRITE_RESPONSE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDEOR_DEFAULT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDEOR_ACCEPT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDEOR_REFUSE: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(2i32);
impl ::core::marker::Copy for FDE_OVERWRITE_RESPONSE {}
impl ::core::clone::Clone for FDE_OVERWRITE_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FDE_OVERWRITE_RESPONSE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FDE_OVERWRITE_RESPONSE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FDE_OVERWRITE_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FDE_OVERWRITE_RESPONSE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FDE_SHAREVIOLATION_RESPONSE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDESVR_DEFAULT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDESVR_ACCEPT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDESVR_REFUSE: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(2i32);
impl ::core::marker::Copy for FDE_SHAREVIOLATION_RESPONSE {}
impl ::core::clone::Clone for FDE_SHAREVIOLATION_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FDE_SHAREVIOLATION_RESPONSE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FDE_SHAREVIOLATION_RESPONSE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FDE_SHAREVIOLATION_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FDE_SHAREVIOLATION_RESPONSE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_LONGDATE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_LONGTIME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_LTRDATE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_NOAUTOREADINGORDER: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_RELATIVE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_RTLDATE: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_SHORTDATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FDTF_SHORTTIME: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FD_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_CLSID: FD_FLAGS = FD_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_SIZEPOINT: FD_FLAGS = FD_FLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_ATTRIBUTES: FD_FLAGS = FD_FLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_CREATETIME: FD_FLAGS = FD_FLAGS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_ACCESSTIME: FD_FLAGS = FD_FLAGS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_WRITESTIME: FD_FLAGS = FD_FLAGS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_FILESIZE: FD_FLAGS = FD_FLAGS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_PROGRESSUI: FD_FLAGS = FD_FLAGS(16384i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_LINKUI: FD_FLAGS = FD_FLAGS(32768i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FD_UNICODE: FD_FLAGS = FD_FLAGS(-2147483648i32);
impl ::core::marker::Copy for FD_FLAGS {}
impl ::core::clone::Clone for FD_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FD_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FD_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FD_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FD_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FFFP_MODE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FFFP_EXACTMATCH: FFFP_MODE = FFFP_MODE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FFFP_NEARESTPARENTMATCH: FFFP_MODE = FFFP_MODE(1i32);
impl ::core::marker::Copy for FFFP_MODE {}
impl ::core::clone::Clone for FFFP_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FFFP_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FFFP_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FFFP_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FFFP_MODE").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEDESCRIPTORA {
    pub dwFlags: u32,
    pub clsid: ::windows::core::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [super::super::Foundation::CHAR; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEDESCRIPTORA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEDESCRIPTORA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEDESCRIPTORA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEDESCRIPTORA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEDESCRIPTORA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEDESCRIPTORW {
    pub dwFlags: u32,
    pub clsid: ::windows::core::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEDESCRIPTORW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEDESCRIPTORW {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEDESCRIPTORW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEDESCRIPTORW>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEDESCRIPTORW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEGROUPDESCRIPTORA {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORA; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEGROUPDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEGROUPDESCRIPTORA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEGROUPDESCRIPTORA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEGROUPDESCRIPTORA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEGROUPDESCRIPTORA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEGROUPDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEGROUPDESCRIPTORA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEGROUPDESCRIPTORW {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORW; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEGROUPDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEGROUPDESCRIPTORW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEGROUPDESCRIPTORW {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEGROUPDESCRIPTORW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEGROUPDESCRIPTORW>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEGROUPDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEGROUPDESCRIPTORW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FILEOPENDIALOGOPTIONS(pub u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_OVERWRITEPROMPT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_STRICTFILETYPES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(4u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_NOCHANGEDIR: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(8u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_PICKFOLDERS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(32u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_FORCEFILESYSTEM: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(64u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_ALLNONSTORAGEITEMS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(128u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_NOVALIDATE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(256u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_ALLOWMULTISELECT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(512u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_PATHMUSTEXIST: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2048u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_FILEMUSTEXIST: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(4096u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_CREATEPROMPT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(8192u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_SHAREAWARE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(16384u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_NOREADONLYRETURN: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(32768u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_NOTESTFILECREATE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(65536u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_HIDEMRUPLACES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(131072u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_HIDEPINNEDPLACES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(262144u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_NODEREFERENCELINKS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(1048576u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_OKBUTTONNEEDSINTERACTION: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2097152u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_DONTADDTORECENT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(33554432u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_FORCESHOWHIDDEN: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(268435456u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_DEFAULTNOMINIMODE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(536870912u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_FORCEPREVIEWPANEON: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(1073741824u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOS_SUPPORTSTREAMABLEITEMS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2147483648u32);
impl ::core::marker::Copy for FILEOPENDIALOGOPTIONS {}
impl ::core::clone::Clone for FILEOPENDIALOGOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILEOPENDIALOGOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILEOPENDIALOGOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILEOPENDIALOGOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILEOPENDIALOGOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FILETYPEATTRIBUTEFLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_None: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_Exclude: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_Show: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_HasExtension: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEdit: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoRemove: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoNewVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoRemoveVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditDesc: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditIcon: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(512i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditDflt: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1024i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditVerbCmd: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2048i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditVerbExe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4096i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoDDE: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8192i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoEditMIME: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32768i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_OpenIsSafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(65536i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_AlwaysUnsafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(131072i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_NoRecentDocs: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1048576i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_SafeForElevation: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2097152i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FTA_AlwaysUseDirectInvoke: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4194304i32);
impl ::core::marker::Copy for FILETYPEATTRIBUTEFLAGS {}
impl ::core::clone::Clone for FILETYPEATTRIBUTEFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILETYPEATTRIBUTEFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILETYPEATTRIBUTEFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILETYPEATTRIBUTEFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILETYPEATTRIBUTEFLAGS").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct FILE_ATTRIBUTES_ARRAY {
    pub cItems: u32,
    pub dwSumFileAttributes: u32,
    pub dwProductFileAttributes: u32,
    pub rgdwFileAttributes: [u32; 1],
}
impl ::core::marker::Copy for FILE_ATTRIBUTES_ARRAY {}
impl ::core::clone::Clone for FILE_ATTRIBUTES_ARRAY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for FILE_ATTRIBUTES_ARRAY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FILE_ATTRIBUTES_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILE_ATTRIBUTES_ARRAY>()) == 0 }
    }
}
impl ::core::cmp::Eq for FILE_ATTRIBUTES_ARRAY {}
impl ::core::default::Default for FILE_ATTRIBUTES_ARRAY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FILE_OPERATION_FLAGS2(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF2_NONE: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF2_MERGEFOLDERSONCOLLISION: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(1i32);
impl ::core::marker::Copy for FILE_OPERATION_FLAGS2 {}
impl ::core::clone::Clone for FILE_OPERATION_FLAGS2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILE_OPERATION_FLAGS2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILE_OPERATION_FLAGS2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILE_OPERATION_FLAGS2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILE_OPERATION_FLAGS2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FILE_USAGE_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FUT_PLAYING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FUT_EDITING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FUT_GENERIC: FILE_USAGE_TYPE = FILE_USAGE_TYPE(2i32);
impl ::core::marker::Copy for FILE_USAGE_TYPE {}
impl ::core::clone::Clone for FILE_USAGE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILE_USAGE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILE_USAGE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILE_USAGE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILE_USAGE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FLYOUT_PLACEMENT(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FP_DEFAULT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FP_ABOVE: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FP_BELOW: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FP_LEFT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FP_RIGHT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(4i32);
impl ::core::marker::Copy for FLYOUT_PLACEMENT {}
impl ::core::clone::Clone for FLYOUT_PLACEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FLYOUT_PLACEMENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FLYOUT_PLACEMENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for FLYOUT_PLACEMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FLYOUT_PLACEMENT").field(&self.0).finish()
    }
}
pub const FMTID_Briefcase: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x328d8b21_7729_4bfc_954c_902b329d56b0);
pub const FMTID_CustomImageProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ecd8b0e_c136_4a9b_9411_4ebd6673ccc3);
pub const FMTID_DRM: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaeac19e4_89ae_4508_b9b7_bb867abee2ed);
pub const FMTID_Displaced: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b174b33_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_ImageProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x14b81da1_0135_4d31_96d9_6cbfc9671a99);
pub const FMTID_InternetSite: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214a1_0000_0000_c000_000000000046);
pub const FMTID_Intshcut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214a0_0000_0000_c000_000000000046);
pub const FMTID_LibraryProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5d76b67f_9b3d_44bb_b6ae_25da4f638a67);
pub const FMTID_MUSIC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56a3372e_ce9c_11d2_9f0e_006097c686f6);
pub const FMTID_Misc: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b174b34_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_Query: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49691c90_7e17_101a_a91c_08002b2ecda9);
pub const FMTID_ShellDetails: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28636aa6_953d_11d2_b5d6_00c04fd918d0);
pub const FMTID_Storage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb725f130_47ef_101a_a5f1_02608c9eebac);
pub const FMTID_Volume: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b174b35_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_WebView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2275480_f782_4291_bd94_f13693513aec);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_ADDUNDORECORD: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_COPYASDOWNLOAD: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_DONTDISPLAYDESTPATH: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_DONTDISPLAYLOCATIONS: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_DONTDISPLAYSOURCEPATH: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_EARLYFAILURE: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_KEEPNEWERFILE: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_MOVEACLSACROSSVOLUMES: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_NOCOPYHOOKS: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_NOMINIMIZEBOX: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_NOSKIPJUNCTIONS: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_PREFERHARDLINK: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_PRESERVEFILEEXTENSIONS: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_RECYCLEONDELETE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_REQUIREELEVATION: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOFX_SHOWELEVATIONPROMPT: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_ALLOWUNDO: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_CONFIRMMOUSE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_FILESONLY: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_MULTIDESTFILES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NOCONFIRMATION: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NOCONFIRMMKDIR: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NOCOPYSECURITYATTRIBS: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NOERRORUI: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NORECURSEREPARSE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NORECURSION: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_NO_CONNECTED_ELEMENTS: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_RENAMEONCOLLISION: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_SILENT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_SIMPLEPROGRESS: u32 = 256u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_WANTMAPPINGHANDLE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FOF_WANTNUKEWARNING: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FOLDERFLAGS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NONE: FOLDERFLAGS = FOLDERFLAGS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_AUTOARRANGE: FOLDERFLAGS = FOLDERFLAGS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_ABBREVIATEDNAMES: FOLDERFLAGS = FOLDERFLAGS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_SNAPTOGRID: FOLDERFLAGS = FOLDERFLAGS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_OWNERDATA: FOLDERFLAGS = FOLDERFLAGS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_BESTFITWINDOW: FOLDERFLAGS = FOLDERFLAGS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_DESKTOP: FOLDERFLAGS = FOLDERFLAGS(32i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_SINGLESEL: FOLDERFLAGS = FOLDERFLAGS(64i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOSUBFOLDERS: FOLDERFLAGS = FOLDERFLAGS(128i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_TRANSPARENT: FOLDERFLAGS = FOLDERFLAGS(256i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOCLIENTEDGE: FOLDERFLAGS = FOLDERFLAGS(512i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOSCROLL: FOLDERFLAGS = FOLDERFLAGS(1024i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_ALIGNLEFT: FOLDERFLAGS = FOLDERFLAGS(2048i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOICONS: FOLDERFLAGS = FOLDERFLAGS(4096i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_SHOWSELALWAYS: FOLDERFLAGS = FOLDERFLAGS(8192i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOVISIBLE: FOLDERFLAGS = FOLDERFLAGS(16384i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_SINGLECLICKACTIVATE: FOLDERFLAGS = FOLDERFLAGS(32768i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOWEBVIEW: FOLDERFLAGS = FOLDERFLAGS(65536i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_HIDEFILENAMES: FOLDERFLAGS = FOLDERFLAGS(131072i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_CHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(262144i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOENUMREFRESH: FOLDERFLAGS = FOLDERFLAGS(524288i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOGROUPING: FOLDERFLAGS = FOLDERFLAGS(1048576i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_FULLROWSELECT: FOLDERFLAGS = FOLDERFLAGS(2097152i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOFILTERS: FOLDERFLAGS = FOLDERFLAGS(4194304i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOCOLUMNHEADER: FOLDERFLAGS = FOLDERFLAGS(8388608i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOHEADERINALLVIEWS: FOLDERFLAGS = FOLDERFLAGS(16777216i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_EXTENDEDTILES: FOLDERFLAGS = FOLDERFLAGS(33554432i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_TRICHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(67108864i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_AUTOCHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(134217728i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_NOBROWSERVIEWSTATE: FOLDERFLAGS = FOLDERFLAGS(268435456i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_SUBSETGROUPS: FOLDERFLAGS = FOLDERFLAGS(536870912i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_USESEARCHFOLDER: FOLDERFLAGS = FOLDERFLAGS(1073741824i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FWF_ALLOWRTLREADING: FOLDERFLAGS = FOLDERFLAGS(-2147483648i32);
impl ::core::marker::Copy for FOLDERFLAGS {}
impl ::core::clone::Clone for FOLDERFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERFLAGS").field(&self.0).finish()
    }
}
pub const FOLDERID_AccountPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x008ca0b1_55b4_4c56_b8a8_4de4b299d3be);
pub const FOLDERID_AddNewPrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde61d971_5ebc_4f02_a3a9_6c82895e5c04);
pub const FOLDERID_AdminTools: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x724ef170_a42d_4fef_9f26_b60e846fba4f);
pub const FOLDERID_AllAppMods: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ad67899_66af_43ba_9156_6aad42e6c596);
pub const FOLDERID_AppCaptures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedc0fe71_98d8_4f4a_b920_c8dc133cb165);
pub const FOLDERID_AppDataDesktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2c5e279_7add_439f_b28c_c41fe1bbf672);
pub const FOLDERID_AppDataDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7be16610_1f7f_44ac_bff0_83e15f2ffca1);
pub const FOLDERID_AppDataFavorites: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7cfbefbc_de1f_45aa_b843_a542ac536cc9);
pub const FOLDERID_AppDataProgramData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x559d40a3_a036_40fa_af61_84cb430a4d34);
pub const FOLDERID_AppUpdates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa305ce99_f527_492b_8b1a_7e76fa98d6e4);
pub const FOLDERID_ApplicationShortcuts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3918781_e5f2_4890_b3d9_a7e54332328c);
pub const FOLDERID_AppsFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1e87508d_89c2_42f0_8a7e_645a0f50ca58);
pub const FOLDERID_CDBurning: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e52ab10_f80d_49df_acb8_4330f5687855);
pub const FOLDERID_CameraRoll: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab5fb87b_7ce2_4f83_915d_550846c9537b);
pub const FOLDERID_CameraRollLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2b20df75_1eda_4039_8097_38798227d5b7);
pub const FOLDERID_ChangeRemovePrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdf7266ac_9274_4867_8d55_3bd661de872d);
pub const FOLDERID_CommonAdminTools: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd0384e7d_bac3_4797_8f14_cba229b392b5);
pub const FOLDERID_CommonOEMLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc1bae2d0_10df_4334_bedd_7aa20b227a9d);
pub const FOLDERID_CommonPrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0139d44e_6afe_49f2_8690_3dafcae6ffb8);
pub const FOLDERID_CommonStartMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa4115719_d62e_491d_aa7c_e74b8be3b067);
pub const FOLDERID_CommonStartMenuPlaces: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa440879f_87a0_4f7d_b700_0207b966194a);
pub const FOLDERID_CommonStartup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82a5ea35_d9cd_47c5_9629_e15d2f714e6e);
pub const FOLDERID_CommonTemplates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb94237e7_57ac_4347_9151_b08c6c32d1f7);
pub const FOLDERID_ComputerFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ac0837c_bbf8_452a_850d_79d08e667ca7);
pub const FOLDERID_ConflictFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4bfefb45_347d_4006_a5be_ac0cb0567192);
pub const FOLDERID_ConnectionsFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6f0cd92b_2e97_45d1_88ff_b0d186b8dedd);
pub const FOLDERID_Contacts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56784854_c6cb_462b_8169_88e350acb882);
pub const FOLDERID_ControlPanelFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82a74aeb_aeb4_465c_a014_d097ee346d63);
pub const FOLDERID_Cookies: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2b0f765d_c0e9_4171_908e_08a611b84ff6);
pub const FOLDERID_CurrentAppMods: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3db40b20_2a30_4dbe_917e_771dd21dd099);
pub const FOLDERID_Desktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4bfcc3a_db2c_424c_b029_7fe99a87c641);
pub const FOLDERID_DevelopmentFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdbe8e08e_3053_4bbc_b183_2a7b2b191e59);
pub const FOLDERID_Device: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c2ac1dc_4358_4b6c_9733_af21156576f0);
pub const FOLDERID_DeviceMetadataStore: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5ce4a5e9_e4eb_479d_b89f_130c02886155);
pub const FOLDERID_Documents: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfdd39ad0_238f_46af_adb4_6c85480369c7);
pub const FOLDERID_DocumentsLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b0db17d_9cd2_4a93_9733_46cc89022e7c);
pub const FOLDERID_Downloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x374de290_123f_4565_9164_39c4925e467b);
pub const FOLDERID_Favorites: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1777f761_68ad_4d8a_87bd_30b759fa33dd);
pub const FOLDERID_Fonts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfd228cb7_ae11_4ae3_864c_16f3910ab8fe);
pub const FOLDERID_GameTasks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x054fae61_4dd8_4787_80b6_090220c4b700);
pub const FOLDERID_Games: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcac52c1a_b53d_4edc_92d7_6b2e8ac19434);
pub const FOLDERID_History: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd9dc8a3b_b784_432e_a781_5a1130a75963);
pub const FOLDERID_HomeGroup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x52528a6b_b9e3_4add_b60d_588c2dba842d);
pub const FOLDERID_HomeGroupCurrentUser: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b74b6a3_0dfd_4f11_9e78_5f7800f2e772);
pub const FOLDERID_ImplicitAppShortcuts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcb5256f_79f6_4cee_b725_dc34e402fd46);
pub const FOLDERID_InternetCache: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x352481e8_33be_4251_ba85_6007caedcf9d);
pub const FOLDERID_InternetFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4d9f7874_4e0c_4904_967b_40b0d20c3e4b);
pub const FOLDERID_Libraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b3ea5dc_b587_4786_b4ef_bd1dc332aeae);
pub const FOLDERID_Links: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbfb9d5e0_c6a9_404c_b2b2_ae6db6af4968);
pub const FOLDERID_LocalAppData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf1b32785_6fba_4fcf_9d55_7b8e7f157091);
pub const FOLDERID_LocalAppDataLow: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa520a1a4_1780_4ff6_bd18_167343c5af16);
pub const FOLDERID_LocalDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf42ee2d3_909f_4907_8871_4c22fc0bf756);
pub const FOLDERID_LocalDownloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d83ee9b_2244_4e70_b1f5_5393042af1e4);
pub const FOLDERID_LocalMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa0c69a99_21c8_4671_8703_7934162fcf1d);
pub const FOLDERID_LocalPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ddd015d_b06c_45d5_8c4c_f59713854639);
pub const FOLDERID_LocalStorage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb3eb08d3_a1f3_496b_865a_42b536cda0ec);
pub const FOLDERID_LocalVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x35286a68_3c57_41a1_bbb1_0eae73d76c95);
pub const FOLDERID_LocalizedResourcesDir: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a00375e_224c_49de_b8d1_440df7ef3ddc);
pub const FOLDERID_Music: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4bd8d571_6d19_48d3_be97_422220080e43);
pub const FOLDERID_MusicLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2112ab0a_c86a_4ffe_a368_0de96e47012e);
pub const FOLDERID_NetHood: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc5abbf53_e17f_4121_8900_86626fc2c973);
pub const FOLDERID_NetworkFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd20beec4_5ca8_4905_ae3b_bf251ea09b53);
pub const FOLDERID_Objects3D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x31c0dd25_9439_4f12_bf41_7ff4eda38722);
pub const FOLDERID_OneDrive: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa52bba46_e9e1_435f_b3d9_28daa648c0f6);
pub const FOLDERID_OriginalImages: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2c36c0aa_5812_4b87_bfd0_4cd0dfb19b39);
pub const FOLDERID_PhotoAlbums: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x69d2cf90_fc33_4fb7_9a0c_ebb0f0fcb43c);
pub const FOLDERID_Pictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x33e28130_4e1e_4676_835a_98395c3bc3bb);
pub const FOLDERID_PicturesLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa990ae9f_a03b_4e80_94bc_9912d7504104);
pub const FOLDERID_Playlists: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde92c1c7_837f_4f69_a3bb_86e631204a23);
pub const FOLDERID_PrintHood: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9274bd8d_cfd1_41c3_b35e_b13f55a758f4);
pub const FOLDERID_PrintersFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x76fc4e2d_d6ad_4519_a663_37bd56068185);
pub const FOLDERID_Profile: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5e6c858f_0e22_4760_9afe_ea3317b67173);
pub const FOLDERID_ProgramData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62ab5d82_fdc1_4dc3_a9dd_070d1d495d97);
pub const FOLDERID_ProgramFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x905e63b6_c1bf_494e_b29c_65b732d3d21a);
pub const FOLDERID_ProgramFilesCommon: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf7f1ed05_9f6d_47a2_aaae_29d317c6f066);
pub const FOLDERID_ProgramFilesCommonX64: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6365d5a7_0f0d_45e5_87f6_0da56b6a4f7d);
pub const FOLDERID_ProgramFilesCommonX86: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde974d24_d9c6_4d3e_bf91_f4455120b917);
pub const FOLDERID_ProgramFilesX64: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6d809377_6af0_444b_8957_a3773f02200e);
pub const FOLDERID_ProgramFilesX86: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c5a40ef_a0fb_4bfc_874a_c0f2e0b9fa8e);
pub const FOLDERID_Programs: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa77f5d77_2e2b_44c3_a6a2_aba601054a51);
pub const FOLDERID_Public: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdfdf76a2_c82a_4d63_906a_5644ac457385);
pub const FOLDERID_PublicDesktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4aa340d_f20f_4863_afef_f87ef2e6ba25);
pub const FOLDERID_PublicDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xed4824af_dce4_45a8_81e2_fc7965083634);
pub const FOLDERID_PublicDownloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d644c9b_1fb8_4f30_9b45_f670235f79c0);
pub const FOLDERID_PublicGameTasks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdebf2536_e1a8_4c59_b6a2_414586476aea);
pub const FOLDERID_PublicLibraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x48daf80b_e6cf_4f4e_b800_0e69d84ee384);
pub const FOLDERID_PublicMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3214fab5_9757_4298_bb61_92a9deaa44ff);
pub const FOLDERID_PublicPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb6ebfb86_6907_413c_9af7_4fc2abf07cc5);
pub const FOLDERID_PublicRingtones: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe555ab60_153b_4d17_9f04_a5fe99fc15ec);
pub const FOLDERID_PublicUserTiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0482af6c_08f1_4c34_8c90_e17ec98b1e17);
pub const FOLDERID_PublicVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2400183a_6185_49fb_a2d8_4a392a602ba3);
pub const FOLDERID_QuickLaunch: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x52a4f021_7b75_48a9_9f6b_4b87a210bc8f);
pub const FOLDERID_Recent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xae50c081_ebd2_438a_8655_8a092e34987a);
pub const FOLDERID_RecordedCalls: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2f8b40c2_83ed_48ee_b383_a1f157ec6f9a);
pub const FOLDERID_RecordedTVLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1a6fdba2_f42d_4358_a798_b74d745926c5);
pub const FOLDERID_RecycleBinFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb7534046_3ecb_4c18_be4e_64cd4cb7d6ac);
pub const FOLDERID_ResourceDir: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8ad10c31_2adb_4296_a8f7_e4701232c972);
pub const FOLDERID_RetailDemo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12d4c69e_24ad_4923_be19_31321c43a767);
pub const FOLDERID_Ringtones: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc870044b_f49e_4126_a9c3_b52a1ff411e8);
pub const FOLDERID_RoamedTileImages: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaaa8d5a5_f1d6_4259_baa8_78e7ef60835e);
pub const FOLDERID_RoamingAppData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3eb685db_65f9_4cf6_a03a_e3ef65729f3d);
pub const FOLDERID_RoamingTiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bcfc5a_ed94_4e48_96a1_3f6217f21990);
pub const FOLDERID_SEARCH_CSC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xee32e446_31ca_4aba_814f_a5ebd2fd6d5e);
pub const FOLDERID_SEARCH_MAPI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x98ec0e18_2098_4d44_8644_66979315a281);
pub const FOLDERID_SampleMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb250c668_f57d_4ee1_a63c_290ee7d1aa1f);
pub const FOLDERID_SamplePictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4900540_2379_4c75_844b_64e6faf8716b);
pub const FOLDERID_SamplePlaylists: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x15ca69b3_30ee_49c1_ace1_6b5ec372afb5);
pub const FOLDERID_SampleVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x859ead94_2e85_48ad_a71a_0969cb56a6cd);
pub const FOLDERID_SavedGames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4c5c32ff_bb9d_43b0_b5b4_2d72e54eaaa4);
pub const FOLDERID_SavedPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b193882_d3ad_4eab_965a_69829d1fb59f);
pub const FOLDERID_SavedPicturesLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe25b5812_be88_4bd9_94b0_29233477b6c3);
pub const FOLDERID_SavedSearches: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d1d3a04_debb_4115_95cf_2f29da2920da);
pub const FOLDERID_Screenshots: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb7bede81_df94_4682_a7d8_57a52620b86f);
pub const FOLDERID_SearchHistory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0d4c3db6_03a3_462f_a0e6_08924c41b5d4);
pub const FOLDERID_SearchHome: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x190337d1_b8ca_4121_a639_6d472d16972a);
pub const FOLDERID_SearchTemplates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7e636bfe_dfa9_4d5e_b456_d7b39851d8a9);
pub const FOLDERID_SendTo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8983036c_27c0_404b_8f08_102d10dcfd74);
pub const FOLDERID_SidebarDefaultParts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b396e54_9ec5_4300_be0a_2482ebae1a26);
pub const FOLDERID_SidebarParts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa75d362e_50fc_4fb7_ac2c_a8beaa314493);
pub const FOLDERID_SkyDrive: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa52bba46_e9e1_435f_b3d9_28daa648c0f6);
pub const FOLDERID_SkyDriveCameraRoll: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x767e6811_49cb_4273_87c2_20f355e1085b);
pub const FOLDERID_SkyDriveDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24d89e24_2f19_4534_9dde_6a6671fbb8fe);
pub const FOLDERID_SkyDriveMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc3f2459e_80d6_45dc_bfef_1f769f2be730);
pub const FOLDERID_SkyDrivePictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x339719b5_8c47_4894_94c2_d8f77add44a6);
pub const FOLDERID_StartMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x625b53c3_ab48_4ec1_ba1f_a1ef4146fc19);
pub const FOLDERID_StartMenuAllPrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf26305ef_6948_40b9_b255_81453d09c785);
pub const FOLDERID_Startup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb97d20bb_f46a_4c97_ba10_5e3608430854);
pub const FOLDERID_SyncManagerFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x43668bf8_c14e_49b2_97c9_747784d784b7);
pub const FOLDERID_SyncResultsFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x289a9a43_be44_4057_a41b_587a76d7e7f9);
pub const FOLDERID_SyncSetupFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0f214138_b1d3_4a90_bba9_27cbc0c5389a);
pub const FOLDERID_System: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1ac14e77_02e7_4e5d_b744_2eb1ae5198b7);
pub const FOLDERID_SystemX86: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd65231b0_b2f1_4857_a4ce_a8e7c6ea7d27);
pub const FOLDERID_Templates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa63293e8_664e_48db_a079_df759e0509f7);
pub const FOLDERID_UserPinned: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e3995ab_1f9c_4f13_b827_48b24b6c7174);
pub const FOLDERID_UserProfiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0762d272_c50a_4bb0_a382_697dcd729b80);
pub const FOLDERID_UserProgramFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cd7aee2_2219_4a67_b85d_6c9ce15660cb);
pub const FOLDERID_UserProgramFilesCommon: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcbd3057_ca5c_4622_b42d_bc56db0ae516);
pub const FOLDERID_UsersFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf3ce0f7c_4901_4acc_8648_d5d44b04ef8f);
pub const FOLDERID_UsersLibraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa302545d_deff_464b_abe8_61c8648d939b);
pub const FOLDERID_Videos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x18989b1d_99b5_455b_841c_ab7c74e4ddfc);
pub const FOLDERID_VideosLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x491e922f_5643_4af4_a7eb_4e7a138d8174);
pub const FOLDERID_Windows: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf38bf404_1d43_42f2_9305_67de0b28fc23);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FOLDERLOGICALVIEWMODE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_UNSPECIFIED: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(-1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_FIRST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_DETAILS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_TILES: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_ICONS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_LIST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_CONTENT: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FLVM_LAST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
impl ::core::marker::Copy for FOLDERLOGICALVIEWMODE {}
impl ::core::clone::Clone for FOLDERLOGICALVIEWMODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERLOGICALVIEWMODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERLOGICALVIEWMODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERLOGICALVIEWMODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERLOGICALVIEWMODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct FOLDERSETDATA {
    pub _fs: FOLDERSETTINGS,
    pub _vidRestore: ::windows::core::GUID,
    pub _dwViewPriority: u32,
}
impl ::core::marker::Copy for FOLDERSETDATA {}
impl ::core::clone::Clone for FOLDERSETDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FOLDERSETDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FOLDERSETDATA").field("_fs", &self._fs).field("_vidRestore", &self._vidRestore).field("_dwViewPriority", &self._dwViewPriority).finish()
    }
}
unsafe impl ::windows::core::Abi for FOLDERSETDATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FOLDERSETDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FOLDERSETDATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for FOLDERSETDATA {}
impl ::core::default::Default for FOLDERSETDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct FOLDERSETTINGS {
    pub ViewMode: u32,
    pub fFlags: u32,
}
impl ::core::marker::Copy for FOLDERSETTINGS {}
impl ::core::clone::Clone for FOLDERSETTINGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FOLDERSETTINGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FOLDERSETTINGS").field("ViewMode", &self.ViewMode).field("fFlags", &self.fFlags).finish()
    }
}
unsafe impl ::windows::core::Abi for FOLDERSETTINGS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FOLDERSETTINGS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FOLDERSETTINGS>()) == 0 }
    }
}
impl ::core::cmp::Eq for FOLDERSETTINGS {}
impl ::core::default::Default for FOLDERSETTINGS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const FOLDERTYPEID_AccountPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdb2a5d8f_06e6_4007_aba6_af877d526ea6);
pub const FOLDERTYPEID_Communications: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91475fe5_586b_4eba_8d75_d17434b8cdf6);
pub const FOLDERTYPEID_CompressedFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x80213e82_bcfd_4c4f_8817_bb27601267a9);
pub const FOLDERTYPEID_Contacts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde2b70ec_9bf7_4a93_bd3d_243f7881d492);
pub const FOLDERTYPEID_ControlPanelCategory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde4f0660_fa10_4b8f_a494_068b20b22307);
pub const FOLDERTYPEID_ControlPanelClassic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c3794f3_b545_43aa_a329_c37430c58d2a);
pub const FOLDERTYPEID_Documents: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d49d726_3c21_4f05_99aa_fdc2c9474656);
pub const FOLDERTYPEID_Downloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x885a186e_a440_4ada_812b_db871b942259);
pub const FOLDERTYPEID_Games: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb689b0d0_76d3_4cbb_87f7_585d0e0ce070);
pub const FOLDERTYPEID_Generic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5c4f28b5_f869_4e84_8e60_f11db97c5cc7);
pub const FOLDERTYPEID_GenericLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5f4eab9a_6833_4f61_899d_31cf46979d49);
pub const FOLDERTYPEID_GenericSearchResults: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7fde1a1e_8b31_49a5_93b8_6be14cfa4943);
pub const FOLDERTYPEID_Invalid: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x57807898_8c4f_4462_bb63_71042380b109);
pub const FOLDERTYPEID_Music: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94d6ddcc_4a68_4175_a374_bd584a510b78);
pub const FOLDERTYPEID_NetworkExplorer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x25cc242b_9a7c_4f51_80e0_7a2928febe42);
pub const FOLDERTYPEID_OpenSearch: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8faf9629_1980_46ff_8023_9dceab9c3ee3);
pub const FOLDERTYPEID_OtherUsers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb337fd00_9dd5_4635_a6d4_da33fd102b7a);
pub const FOLDERTYPEID_Pictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb3690e58_e961_423b_b687_386ebfd83239);
pub const FOLDERTYPEID_Printers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2c7bbec6_c844_4a0a_91fa_cef6f59cfda1);
pub const FOLDERTYPEID_PublishedItems: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7f2f5b96_ff74_41da_afd8_1c78a5f3aea2);
pub const FOLDERTYPEID_RecordedTV: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5557a28f_5da6_4f83_8809_c2c98a11a6fa);
pub const FOLDERTYPEID_RecycleBin: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6d9e004_cd87_442b_9d57_5e0aeb4f6f72);
pub const FOLDERTYPEID_SavedGames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd0363307_28cb_4106_9f23_2956e3e5e0e7);
pub const FOLDERTYPEID_SearchConnector: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x982725ee_6f47_479e_b447_812bfa7d2e8f);
pub const FOLDERTYPEID_SearchHome: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x834d8a44_0974_4ed6_866e_f203d80b3810);
pub const FOLDERTYPEID_Searches: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b0ba2e3_405f_415e_a6ee_cad625207853);
pub const FOLDERTYPEID_SoftwareExplorer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd674391b_52d9_4e07_834e_67c98610f39d);
pub const FOLDERTYPEID_StartMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xef87b4cb_f2ce_4785_8658_4ca6c63e38c6);
pub const FOLDERTYPEID_StorageProviderDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdd61bd66_70e8_48dd_9655_65c5e1aac2d1);
pub const FOLDERTYPEID_StorageProviderGeneric: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4f01ebc5_2385_41f2_a28e_2c5c91fb56e0);
pub const FOLDERTYPEID_StorageProviderMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x672ecd7e_af04_4399_875c_0290845b6247);
pub const FOLDERTYPEID_StorageProviderPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71d642a9_f2b1_42cd_ad92_eb9300c7cc0a);
pub const FOLDERTYPEID_StorageProviderVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51294da1_d7b1_485b_9e9a_17cffe33e187);
pub const FOLDERTYPEID_UserFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcd0fc69b_71e2_46e5_9690_5bcd9f57aab3);
pub const FOLDERTYPEID_UsersLibraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4d98f09_6124_4fe0_9942_826416082da9);
pub const FOLDERTYPEID_Videos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5fa96407_7e77_483c_ac93_691d05850de8);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FOLDERVIEWMODE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_AUTO: FOLDERVIEWMODE = FOLDERVIEWMODE(-1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_FIRST: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_ICON: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_SMALLICON: FOLDERVIEWMODE = FOLDERVIEWMODE(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_LIST: FOLDERVIEWMODE = FOLDERVIEWMODE(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_DETAILS: FOLDERVIEWMODE = FOLDERVIEWMODE(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_THUMBNAIL: FOLDERVIEWMODE = FOLDERVIEWMODE(5i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_TILE: FOLDERVIEWMODE = FOLDERVIEWMODE(6i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_THUMBSTRIP: FOLDERVIEWMODE = FOLDERVIEWMODE(7i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_CONTENT: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVM_LAST: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
impl ::core::marker::Copy for FOLDERVIEWMODE {}
impl ::core::clone::Clone for FOLDERVIEWMODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERVIEWMODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERVIEWMODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERVIEWMODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERVIEWMODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FOLDERVIEWOPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_DEFAULT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_VISTALAYOUT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_CUSTOMPOSITION: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_CUSTOMORDERING: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_SUPPORTHYPERLINKS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_NOANIMATIONS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(16i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVO_NOSCROLLTIPS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(32i32);
impl ::core::marker::Copy for FOLDERVIEWOPTIONS {}
impl ::core::clone::Clone for FOLDERVIEWOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERVIEWOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERVIEWOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERVIEWOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERVIEWOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FOLDER_ENUM_MODE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FEM_VIEWRESULT: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FEM_NAVIGATION: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(1i32);
impl ::core::marker::Copy for FOLDER_ENUM_MODE {}
impl ::core::clone::Clone for FOLDER_ENUM_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDER_ENUM_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDER_ENUM_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDER_ENUM_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDER_ENUM_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FO_COPY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FO_DELETE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FO_MOVE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FO_RENAME: u32 = 4u32;
pub const FSCopyHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd197380a_0a79_4dc8_a033_ed882c2fa14b);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVSIF_CANVIEWIT: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVSIF_NEWFAILED: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVSIF_NEWFILE: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVSIF_PINNED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVSIF_RECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct FVTEXTTYPE(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const FVST_EMPTYTEXT: FVTEXTTYPE = FVTEXTTYPE(0i32);
impl ::core::marker::Copy for FVTEXTTYPE {}
impl ::core::clone::Clone for FVTEXTTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FVTEXTTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FVTEXTTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FVTEXTTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FVTEXTTYPE").field(&self.0).finish()
    }
}
pub const FileOpenDialog: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdc1c5a9c_e88a_4dde_a5a1_60f82a20aef7);
pub const FileOperation: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3ad05575_8857_4850_9277_11b85bdb8e09);
pub const FileSaveDialog: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0b4e2f3_ba21_4773_8dba_335ec946eb8b);
pub const FileSearchBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4ee31f3_4768_11d2_be5c_00a0c9a83da1);
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableA<'a, P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u8; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn FindExecutableA(lpfile: ::windows::core::PCSTR, lpdirectory: ::windows::core::PCSTR, lpresult: ::windows::core::PSTR) -> super::super::Foundation::HINSTANCE;
    }
    FindExecutableA(lpfile.into(), lpdirectory.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(lpresult)))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableW<'a, P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u16; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn FindExecutableW(lpfile: ::windows::core::PCWSTR, lpdirectory: ::windows::core::PCWSTR, lpresult: ::windows::core::PWSTR) -> super::super::Foundation::HINSTANCE;
    }
    FindExecutableW(lpfile.into(), lpdirectory.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(lpresult)))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Title)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ParentFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Items)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseName<'a, P0>(&self, bname: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ParseName)(::windows::core::Interface::as_raw(self), bname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, P0, P1>(&self, bname: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).NewFolder)(::windows::core::Interface::as_raw(self), bname.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).MoveHere)(::windows::core::Interface::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).CopyHere)(::windows::core::Interface::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, P0>(&self, vitem: P0, icolumn: i32) -> ::windows::core::Result<super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDetailsOf)(::windows::core::Interface::as_raw(self), vitem.into().abi(), icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder> for ::windows::core::IUnknown {
    fn from(value: Folder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder> for &'a ::windows::core::IUnknown {
    fn from(value: &'a Folder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder> for ::windows::core::IUnknown {
    fn from(value: &Folder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder> for super::super::System::Com::IDispatch {
    fn from(value: Folder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a Folder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder> for super::super::System::Com::IDispatch {
    fn from(value: &Folder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder {
    type Vtable = Folder_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbbcbde60_c3ff_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Title: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Title: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ParentFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsf: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParentFolder: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Items: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Items: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub ParseName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    ParseName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub NewFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    NewFolder: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub MoveHere: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    MoveHere: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CopyHere: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CopyHere: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetDetailsOf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, icolumn: i32, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetDetailsOf: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Title)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ParentFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Items)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseName<'a, P0>(&self, bname: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ParseName)(::windows::core::Interface::as_raw(self), bname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, P0, P1>(&self, bname: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.NewFolder)(::windows::core::Interface::as_raw(self), bname.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.MoveHere)(::windows::core::Interface::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.CopyHere)(::windows::core::Interface::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, P0>(&self, vitem: P0, icolumn: i32) -> ::windows::core::Result<super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetDetailsOf)(::windows::core::Interface::as_raw(self), vitem.into().abi(), icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Self_)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn OfflineStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).OfflineStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Synchronize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Synchronize)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).HaveToShowWebViewBarricade)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DismissedWebViewBarricade)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder2> for ::windows::core::IUnknown {
    fn from(value: Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder2> for ::windows::core::IUnknown {
    fn from(value: &Folder2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder2> for super::super::System::Com::IDispatch {
    fn from(value: Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder2> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder2> for super::super::System::Com::IDispatch {
    fn from(value: &Folder2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder2> for Folder {
    fn from(value: Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder2> for &'a Folder {
    fn from(value: &'a Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder2> for Folder {
    fn from(value: &Folder2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder2 {
    type Vtable = Folder2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf0d2d8ef_3890_11d2_bf8b_00c04fb93661);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder2_Vtbl {
    pub base__: Folder_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Self_: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfi: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Self_: usize,
    pub OfflineStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pul: *mut i32) -> ::windows::core::HRESULT,
    pub Synchronize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub HaveToShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbhavetoshowwebviewbarricade: *mut i16) -> ::windows::core::HRESULT,
    pub DismissedWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder3 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Title)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.ParentFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Items)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseName<'a, P0>(&self, bname: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.ParseName)(::windows::core::Interface::as_raw(self), bname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, P0, P1>(&self, bname: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.NewFolder)(::windows::core::Interface::as_raw(self), bname.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.MoveHere)(::windows::core::Interface::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.CopyHere)(::windows::core::Interface::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, P0>(&self, vitem: P0, icolumn: i32) -> ::windows::core::Result<super::super::Foundation::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetDetailsOf)(::windows::core::Interface::as_raw(self), vitem.into().abi(), icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Self_)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn OfflineStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.OfflineStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Synchronize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Synchronize)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.HaveToShowWebViewBarricade)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.DismissedWebViewBarricade)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ShowWebViewBarricade)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn SetShowWebViewBarricade(&self, bshowwebviewbarricade: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetShowWebViewBarricade)(::windows::core::Interface::as_raw(self), bshowwebviewbarricade).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for ::windows::core::IUnknown {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for ::windows::core::IUnknown {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for super::super::System::Com::IDispatch {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder3> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for super::super::System::Com::IDispatch {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for Folder {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder3> for &'a Folder {
    fn from(value: &'a Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for Folder {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for Folder2 {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a Folder3> for &'a Folder2 {
    fn from(value: &'a Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for Folder2 {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder3 {
    type Vtable = Folder3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7ae5f64_c4d7_4d7f_9307_4d24ee54b841);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder3_Vtbl {
    pub base__: Folder2_Vtbl,
    pub ShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbshowwebviewbarricade: *mut i16) -> ::windows::core::HRESULT,
    pub SetShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bshowwebviewbarricade: i16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItem(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, P0>(&self, bs: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).SetName)(::windows::core::Interface::as_raw(self), bs.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Path(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Path)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetLink)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn IsLink(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsLink)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFolder(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFileSystem(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsFileSystem)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsBrowsable(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsBrowsable)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn ModifyDate(&self) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ModifyDate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetModifyDate)(::windows::core::Interface::as_raw(self), dt).ok()
    }
    pub unsafe fn Size(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Size)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Type(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Verbs)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerbs>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerb<'a, P0>(&self, vverb: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).InvokeVerb)(::windows::core::Interface::as_raw(self), vverb.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem> for ::windows::core::IUnknown {
    fn from(value: FolderItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItem> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem> for ::windows::core::IUnknown {
    fn from(value: &FolderItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem> for super::super::System::Com::IDispatch {
    fn from(value: FolderItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItem> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItem {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItem").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItem {
    type Vtable = FolderItem_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfac32c80_cbe4_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bs: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Path: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Path: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetLink: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFolder: usize,
    pub IsLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsFileSystem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsBrowsable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub ModifyDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdt: *mut f64) -> ::windows::core::HRESULT,
    pub SetModifyDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dt: f64) -> ::windows::core::HRESULT,
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pul: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Type: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfic: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerb: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerb: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItem2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem2 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Name)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, P0>(&self, bs: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetName)(::windows::core::Interface::as_raw(self), bs.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Path(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Path)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetLink)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn IsLink(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsLink)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFolder(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsFolder)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFileSystem(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsFileSystem)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsBrowsable(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsBrowsable)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn ModifyDate(&self) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ModifyDate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetModifyDate)(::windows::core::Interface::as_raw(self), dt).ok()
    }
    pub unsafe fn Size(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Size)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Type(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Type)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Verbs)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerbs>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerb<'a, P0>(&self, vverb: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.InvokeVerb)(::windows::core::Interface::as_raw(self), vverb.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, P0, P1>(&self, vverb: P0, vargs: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).InvokeVerbEx)(::windows::core::Interface::as_raw(self), vverb.into().abi(), vargs.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ExtendedProperty<'a, P0>(&self, bstrpropname: P0) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ExtendedProperty)(::windows::core::Interface::as_raw(self), bstrpropname.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem2> for ::windows::core::IUnknown {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItem2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem2> for ::windows::core::IUnknown {
    fn from(value: &FolderItem2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem2> for super::super::System::Com::IDispatch {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItem2> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem2> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItem2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem2> for FolderItem {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItem2> for &'a FolderItem {
    fn from(value: &'a FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem2> for FolderItem {
    fn from(value: &FolderItem2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItem2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItem2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItem2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItem2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItem2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItem2 {
    type Vtable = FolderItem2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedc817aa_92b8_11d1_b075_00c04fc33aa5);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem2_Vtbl {
    pub base__: FolderItem_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerbEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, vargs: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerbEx: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ExtendedProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrpropname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pvret: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ExtendedProperty: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItemVerb(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerb {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn DoIt(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DoIt)(::windows::core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerb> for ::windows::core::IUnknown {
    fn from(value: FolderItemVerb) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItemVerb> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItemVerb) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerb> for ::windows::core::IUnknown {
    fn from(value: &FolderItemVerb) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerb> for super::super::System::Com::IDispatch {
    fn from(value: FolderItemVerb) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItemVerb> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItemVerb) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerb> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItemVerb) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItemVerb {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItemVerb {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItemVerb {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItemVerb {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItemVerb").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItemVerb {
    type Vtable = FolderItemVerb_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x08ec3e00_50b0_11cf_960c_0080c7f4ee85);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerb_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub DoIt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItemVerbs(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerbs {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItemVerb>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::windows::core::Interface::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerb>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerbs> for ::windows::core::IUnknown {
    fn from(value: FolderItemVerbs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItemVerbs> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItemVerbs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerbs> for ::windows::core::IUnknown {
    fn from(value: &FolderItemVerbs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerbs> for super::super::System::Com::IDispatch {
    fn from(value: FolderItemVerbs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItemVerbs> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItemVerbs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerbs> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItemVerbs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItemVerbs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItemVerbs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItemVerbs {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItemVerbs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItemVerbs").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItemVerbs {
    type Vtable = FolderItemVerbs_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1f8352c0_50b0_11cf_960c_0080c7f4ee85);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerbs_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::windows::core::Interface::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems> for ::windows::core::IUnknown {
    fn from(value: FolderItems) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItems) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems> for ::windows::core::IUnknown {
    fn from(value: &FolderItems) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems> for super::super::System::Com::IDispatch {
    fn from(value: FolderItems) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItems) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItems) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems {
    type Vtable = FolderItems_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x744129e0_cbe5_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems2 {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.Item)(::windows::core::Interface::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, P0, P1>(&self, vverb: P0, vargs: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).InvokeVerbEx)(::windows::core::Interface::as_raw(self), vverb.into().abi(), vargs.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems2> for ::windows::core::IUnknown {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems2> for ::windows::core::IUnknown {
    fn from(value: &FolderItems2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems2> for super::super::System::Com::IDispatch {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems2> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems2> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItems2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems2> for FolderItems {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems2> for &'a FolderItems {
    fn from(value: &'a FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems2> for FolderItems {
    fn from(value: &FolderItems2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems2 {
    type Vtable = FolderItems2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc94f0ad0_f363_11d2_a327_00c04f8eec7f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems2_Vtbl {
    pub base__: FolderItems_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerbEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, vargs: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerbEx: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems3 {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Count)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Application)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Parent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.Item)(::windows::core::Interface::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__._NewEnum)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, P0, P1>(&self, vverb: P0, vargs: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Interface::vtable(self).base__.InvokeVerbEx)(::windows::core::Interface::as_raw(self), vverb.into().abi(), vargs.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Filter<'a, P0>(&self, grfflags: i32, bstrfilespec: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Foundation::BSTR>>,
    {
        (::windows::core::Interface::vtable(self).Filter)(::windows::core::Interface::as_raw(self), grfflags, bstrfilespec.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Verbs)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerbs>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for ::windows::core::IUnknown {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for ::windows::core::IUnknown {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for super::super::System::Com::IDispatch {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems3> for &'a super::super::System::Com::IDispatch {
    fn from(value: &'a FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for FolderItems {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems3> for &'a FolderItems {
    fn from(value: &'a FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for FolderItems {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for FolderItems2 {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::core::convert::From<&'a FolderItems3> for &'a FolderItems2 {
    fn from(value: &'a FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for FolderItems2 {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems3 {
    type Vtable = FolderItems3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeaa7c309_bbec_49d5_821d_64d966cb667f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems3_Vtbl {
    pub base__: FolderItems2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Filter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, grfflags: i32, bstrfilespec: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Filter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfic: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
}
pub const FolderViewHost: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x20b1cb23_6968_4eb9_b7d4_a66d00d07cee);
pub const FrameworkInputPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd5120aa3_46ba_44c5_822d_ca8092c1fc72);
pub const FreeSpaceCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb5607793_24ac_44c7_82e2_831726aa6cb7);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GADOF_DIRTY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_HELPTEXT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_HELPTEXTA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_HELPTEXTW: u32 = 5u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_UNICODE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VALIDATE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VALIDATEA: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VALIDATEW: u32 = 6u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VERB: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VERBA: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VERBICONW: u32 = 20u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCS_VERBW: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCT_INVALID: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCT_LFNCHAR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCT_SEPARATOR: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCT_SHORTCHAR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GCT_WILD: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GETPROPS_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_ASYNC: u32 = 32u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_CHECKSHIELD: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_DEFAULTICON: u32 = 64u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_DONTCACHE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_FORCENOSHIELD: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_FORSHELL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_FORSHORTCUT: u32 = 128u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_NOTFILENAME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_OPENICON: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_PERCLASS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_PERINSTANCE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_SHIELD: u32 = 512u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GIL_SIMULATEDOC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GPFIDL_ALTNAME: i32 = 1i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GPFIDL_DEFAULT: i32 = 0i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const GPFIDL_UNCPRINTER: i32 = 2i32;
pub const GenericCredentialProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x25cbb996_92ed_457e_b28c_4774084bd562);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetAcceptLanguagesA(pszlanguages: ::windows::core::PSTR, pcchlanguages: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAcceptLanguagesA(pszlanguages: ::windows::core::PSTR, pcchlanguages: *mut u32) -> ::windows::core::HRESULT;
    }
    GetAcceptLanguagesA(::core::mem::transmute(pszlanguages), ::core::mem::transmute(pcchlanguages)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetAcceptLanguagesW(pszlanguages: ::windows::core::PWSTR, pcchlanguages: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAcceptLanguagesW(pszlanguages: ::windows::core::PWSTR, pcchlanguages: *mut u32) -> ::windows::core::HRESULT;
    }
    GetAcceptLanguagesW(::core::mem::transmute(pszlanguages), ::core::mem::transmute(pcchlanguages)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAllUsersProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetAllUsersProfileDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAllUsersProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetAllUsersProfileDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetCurrentProcessExplicitAppUserModelID() -> ::windows::core::Result<::windows::core::PWSTR> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetCurrentProcessExplicitAppUserModelID(appid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    GetCurrentProcessExplicitAppUserModelID(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetDefaultUserProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetDefaultUserProfileDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetDefaultUserProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetDefaultUserProfileDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32;
    }
    GetDpiForShellUIComponent(param0)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileNameFromBrowse<'a, P0, P1, P2, P3, P4>(hwnd: P0, pszfilepath: &mut [u16], pszworkingdir: P1, pszdefext: P2, pszfilters: P3, psztitle: P4) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetFileNameFromBrowse(hwnd: super::super::Foundation::HWND, pszfilepath: ::windows::core::PWSTR, cchfilepath: u32, pszworkingdir: ::windows::core::PCWSTR, pszdefext: ::windows::core::PCWSTR, pszfilters: ::windows::core::PCWSTR, psztitle: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    GetFileNameFromBrowse(hwnd.into(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszfilepath)), pszfilepath.len() as _, pszworkingdir.into(), pszdefext.into(), pszfilters.into(), psztitle.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuContextHelpId<'a, P0>(param0: P0) -> u32
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU) -> u32;
    }
    GetMenuContextHelpId(param0.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuPosFromID<'a, P0>(hmenu: P0, id: u32) -> i32
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetMenuPosFromID(hmenu: super::WindowsAndMessaging::HMENU, id: u32) -> i32;
    }
    GetMenuPosFromID(hmenu.into(), id)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetProfileType(::core::mem::transmute(dwflags))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfilesDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetProfilesDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetProfilesDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfilesDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetProfilesDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetProfilesDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR;
    }
    GetScaleFactorForDevice(devicetype)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn GetScaleFactorForMonitor<'a, P0>(hmon: P0) -> ::windows::core::Result<Common::DEVICE_SCALE_FACTOR>
where
    P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetScaleFactorForMonitor(hmon: super::super::Graphics::Gdi::HMONITOR, pscale: *mut Common::DEVICE_SCALE_FACTOR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    GetScaleFactorForMonitor(hmon.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Common::DEVICE_SCALE_FACTOR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserProfileDirectoryA<'a, P0>(htoken: P0, lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetUserProfileDirectoryA(htoken: super::super::Foundation::HANDLE, lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetUserProfileDirectoryA(htoken.into(), ::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserProfileDirectoryW<'a, P0>(htoken: P0, lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetUserProfileDirectoryW(htoken: super::super::Foundation::HANDLE, lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetUserProfileDirectoryW(htoken.into(), ::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetWindowContextHelpId<'a, P0>(param0: P0) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetWindowContextHelpId(param0: super::super::Foundation::HWND) -> u32;
    }
    GetWindowContextHelpId(param0.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetWindowSubclass<'a, P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, pdwrefdata: *mut usize) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: *mut ::core::ffi::c_void, uidsubclass: usize, pdwrefdata: *mut usize) -> super::super::Foundation::BOOL;
    }
    GetWindowSubclass(hwnd.into(), ::core::mem::transmute(pfnsubclass), uidsubclass, ::core::mem::transmute(pdwrefdata))
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HDROP(pub isize);
impl HDROP {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 || self.0 == 0
    }
}
impl ::core::default::Default for HDROP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HDROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HDROP {}
impl ::core::fmt::Debug for HDROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HDROP").field(&self.0).finish()
    }
}
impl ::core::convert::From<::core::option::Option<HDROP>> for HDROP {
    fn from(optional: ::core::option::Option<HDROP>) -> HDROP {
        optional.unwrap_or_default()
    }
}
unsafe impl ::windows::core::Abi for HDROP {
    type Abi = Self;
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HELPINFO {
    pub cbSize: u32,
    pub iContextType: i32,
    pub iCtrlId: i32,
    pub hItemHandle: super::super::Foundation::HANDLE,
    pub dwContextId: usize,
    pub MousePos: super::super::Foundation::POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HELPINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HELPINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HELPINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HELPINFO").field("cbSize", &self.cbSize).field("iContextType", &self.iContextType).field("iCtrlId", &self.iCtrlId).field("hItemHandle", &self.hItemHandle).field("dwContextId", &self.dwContextId).field("MousePos", &self.MousePos).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HELPINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HELPINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HELPINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HELPINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HELPINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HELPWININFOA {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [super::super::Foundation::CHAR; 2],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HELPWININFOA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HELPWININFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HELPWININFOA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HELPWININFOA").field("wStructSize", &self.wStructSize).field("x", &self.x).field("y", &self.y).field("dx", &self.dx).field("dy", &self.dy).field("wMax", &self.wMax).field("rgchMember", &self.rgchMember).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HELPWININFOA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HELPWININFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HELPWININFOA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HELPWININFOA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HELPWININFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct HELPWININFOW {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [u16; 2],
}
impl ::core::marker::Copy for HELPWININFOW {}
impl ::core::clone::Clone for HELPWININFOW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for HELPWININFOW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HELPWININFOW").field("wStructSize", &self.wStructSize).field("x", &self.x).field("y", &self.y).field("dx", &self.dx).field("dy", &self.dy).field("wMax", &self.wMax).field("rgchMember", &self.rgchMember).finish()
    }
}
unsafe impl ::windows::core::Abi for HELPWININFOW {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for HELPWININFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HELPWININFOW>()) == 0 }
    }
}
impl ::core::cmp::Eq for HELPWININFOW {}
impl ::core::default::Default for HELPWININFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLBWIF_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLBWIF_HASFRAMEWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLBWIF_HASDOCWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLBWIF_FRAMEWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLBWIF_DOCWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLBWIF_HASWEBTOOLBARINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLBWIF_WEBTOOLBARHIDDEN: HLBWIF_FLAGS = HLBWIF_FLAGS(32u32);
impl ::core::marker::Copy for HLBWIF_FLAGS {}
impl ::core::clone::Clone for HLBWIF_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLBWIF_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLBWIF_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLBWIF_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLBWIF_FLAGS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for HLBWIF_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for HLBWIF_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for HLBWIF_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for HLBWIF_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for HLBWIF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HLBWINFO {
    pub cbSize: u32,
    pub grfHLBWIF: u32,
    pub rcFramePos: super::super::Foundation::RECT,
    pub rcDocPos: super::super::Foundation::RECT,
    pub hltbinfo: HLTBINFO,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HLBWINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HLBWINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HLBWINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HLBWINFO").field("cbSize", &self.cbSize).field("grfHLBWIF", &self.grfHLBWIF).field("rcFramePos", &self.rcFramePos).field("rcDocPos", &self.rcDocPos).field("hltbinfo", &self.hltbinfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HLBWINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HLBWINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HLBWINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HLBWINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HLBWINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLFNAMEF(pub u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLFNAMEF_DEFAULT: HLFNAMEF = HLFNAMEF(0u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLFNAMEF_TRYCACHE: HLFNAMEF = HLFNAMEF(1u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLFNAMEF_TRYPRETTYTARGET: HLFNAMEF = HLFNAMEF(2u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLFNAMEF_TRYFULLTARGET: HLFNAMEF = HLFNAMEF(4u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLFNAMEF_TRYWIN95SHORTCUT: HLFNAMEF = HLFNAMEF(8u32);
impl ::core::marker::Copy for HLFNAMEF {}
impl ::core::clone::Clone for HLFNAMEF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLFNAMEF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLFNAMEF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLFNAMEF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLFNAMEF").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for HLFNAMEF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for HLFNAMEF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for HLFNAMEF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for HLFNAMEF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for HLFNAMEF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLID_INFO(pub u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLID_INVALID: HLID_INFO = HLID_INFO(0u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLID_PREVIOUS: HLID_INFO = HLID_INFO(4294967295u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLID_NEXT: HLID_INFO = HLID_INFO(4294967294u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLID_CURRENT: HLID_INFO = HLID_INFO(4294967293u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLID_STACKBOTTOM: HLID_INFO = HLID_INFO(4294967292u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLID_STACKTOP: HLID_INFO = HLID_INFO(4294967291u32);
impl ::core::marker::Copy for HLID_INFO {}
impl ::core::clone::Clone for HLID_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLID_INFO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLID_INFO {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLID_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLID_INFO").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLINKGETREF(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKGETREF_DEFAULT: HLINKGETREF = HLINKGETREF(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKGETREF_ABSOLUTE: HLINKGETREF = HLINKGETREF(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKGETREF_RELATIVE: HLINKGETREF = HLINKGETREF(2i32);
impl ::core::marker::Copy for HLINKGETREF {}
impl ::core::clone::Clone for HLINKGETREF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKGETREF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKGETREF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKGETREF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKGETREF").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLINKMISC(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKMISC_RELATIVE: HLINKMISC = HLINKMISC(1i32);
impl ::core::marker::Copy for HLINKMISC {}
impl ::core::clone::Clone for HLINKMISC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKMISC {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKMISC {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKMISC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKMISC").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLINKSETF(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKSETF_TARGET: HLINKSETF = HLINKSETF(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKSETF_LOCATION: HLINKSETF = HLINKSETF(2i32);
impl ::core::marker::Copy for HLINKSETF {}
impl ::core::clone::Clone for HLINKSETF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKSETF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKSETF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKSETF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKSETF").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLINKWHICHMK(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKWHICHMK_CONTAINER: HLINKWHICHMK = HLINKWHICHMK(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINKWHICHMK_BASE: HLINKWHICHMK = HLINKWHICHMK(2i32);
impl ::core::marker::Copy for HLINKWHICHMK {}
impl ::core::clone::Clone for HLINKWHICHMK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKWHICHMK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKWHICHMK {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKWHICHMK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKWHICHMK").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINK_E_FIRST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147221248i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINK_S_DONTHIDE: i32 = 262400i32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLINK_S_FIRST: ::windows::core::HRESULT = ::windows::core::HRESULT(262400i32);
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub struct HLITEM {
    pub uHLID: u32,
    pub pwzFriendlyName: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for HLITEM {}
impl ::core::clone::Clone for HLITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for HLITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HLITEM").field("uHLID", &self.uHLID).field("pwzFriendlyName", &self.pwzFriendlyName).finish()
    }
}
unsafe impl ::windows::core::Abi for HLITEM {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for HLITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HLITEM>()) == 0 }
    }
}
impl ::core::cmp::Eq for HLITEM {}
impl ::core::default::Default for HLITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLNF(pub u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_INTERNALJUMP: HLNF = HLNF(1u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_OPENINNEWWINDOW: HLNF = HLNF(2u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_NAVIGATINGBACK: HLNF = HLNF(4u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_NAVIGATINGFORWARD: HLNF = HLNF(8u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_NAVIGATINGTOSTACKITEM: HLNF = HLNF(16u32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_CREATENOHISTORY: HLNF = HLNF(32u32);
impl ::core::marker::Copy for HLNF {}
impl ::core::clone::Clone for HLNF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLNF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLNF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLNF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLNF").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for HLNF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for HLNF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for HLNF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for HLNF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for HLNF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_ALLOW_AUTONAVIGATE: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_CALLERUNTRUSTED: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_DISABLEWINDOWRESTRICTIONS: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_EXTERNALNAVIGATE: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_NEWWINDOWSMANAGED: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_TRUSTEDFORACTIVEX: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_TRUSTFIRSTDOWNLOAD: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLNF_UNTRUSTEDFORDOWNLOAD: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLQF_INFO(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLQF_ISVALID: HLQF_INFO = HLQF_INFO(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLQF_ISCURRENT: HLQF_INFO = HLQF_INFO(2i32);
impl ::core::marker::Copy for HLQF_INFO {}
impl ::core::clone::Clone for HLQF_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLQF_INFO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLQF_INFO {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLQF_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLQF_INFO").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HLTBINFO {
    pub uDockType: u32,
    pub rcTbPos: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HLTBINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HLTBINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HLTBINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HLTBINFO").field("uDockType", &self.uDockType).field("rcTbPos", &self.rcTbPos).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HLTBINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HLTBINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HLTBINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HLTBINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HLTBINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HLTB_INFO(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLTB_DOCKEDLEFT: HLTB_INFO = HLTB_INFO(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLTB_DOCKEDTOP: HLTB_INFO = HLTB_INFO(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLTB_DOCKEDRIGHT: HLTB_INFO = HLTB_INFO(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLTB_DOCKEDBOTTOM: HLTB_INFO = HLTB_INFO(3i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HLTB_FLOATING: HLTB_INFO = HLTB_INFO(4i32);
impl ::core::marker::Copy for HLTB_INFO {}
impl ::core::clone::Clone for HLTB_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLTB_INFO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLTB_INFO {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLTB_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLTB_INFO").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR);
    }
    HMONITOR_UserFree(::core::mem::transmute(param0), ::core::mem::transmute(param1))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR);
    }
    HMONITOR_UserFree64(::core::mem::transmute(param0), ::core::mem::transmute(param1))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserMarshal(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserMarshal64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32;
    }
    HMONITOR_UserSize(::core::mem::transmute(param0), param1, ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32;
    }
    HMONITOR_UserSize64(::core::mem::transmute(param0), param1, ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserUnmarshal(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserUnmarshal64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HOMEGROUPSHARINGCHOICES(pub i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HGSC_NONE: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(0i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HGSC_MUSICLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(1i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HGSC_PICTURESLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(2i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HGSC_VIDEOSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(4i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HGSC_DOCUMENTSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(8i32);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HGSC_PRINTERS: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(16i32);
impl ::core::marker::Copy for HOMEGROUPSHARINGCHOICES {}
impl ::core::clone::Clone for HOMEGROUPSHARINGCHOICES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HOMEGROUPSHARINGCHOICES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HOMEGROUPSHARINGCHOICES {
    type Abi = Self;
}
impl ::core::fmt::Debug for HOMEGROUPSHARINGCHOICES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HOMEGROUPSHARINGCHOICES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HOMEGROUP_SECURITY_GROUP: &str = "HomeUsers";
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const HOMEGROUP_SECURITY_GROUP_MULTI: &str = "HUG";
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HPSXA(pub isize);
impl HPSXA {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 || self.0 == 0
    }
}
impl ::core::default::Default for HPSXA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HPSXA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HPSXA {}
impl ::core::fmt::Debug for HPSXA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HPSXA").field(&self.0).finish()
    }
}
impl ::core::convert::From<::core::option::Option<HPSXA>> for HPSXA {
    fn from(optional: ::core::option::Option<HPSXA>) -> HPSXA {
        optional.unwrap_or_default()
    }
}
unsafe impl ::windows::core::Abi for HPSXA {
    type Abi = Self;
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HashData(pbdata: *const u8, cbdata: u32, pbhash: *mut u8, cbhash: u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HashData(pbdata: *const u8, cbdata: u32, pbhash: *mut u8, cbhash: u32) -> ::windows::core::HRESULT;
    }
    HashData(::core::mem::transmute(pbdata), cbdata, ::core::mem::transmute(pbhash), cbhash).ok()
}
pub const HideInputPaneAnimationCoordinator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x384742b1_2a77_4cb3_8cf8_1136f5e17e59);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkClone<'a, P0, P1>(pihl: P0, riid: *const ::windows::core::GUID, pihlsiteforclone: P1, dwsitedata: u32, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlink>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkClone(pihl: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pihlsiteforclone: *mut ::core::ffi::c_void, dwsitedata: u32, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkClone(pihl.into().abi(), ::core::mem::transmute(riid), pihlsiteforclone.into().abi(), dwsitedata, ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateBrowseContext<'a, P0>(piunkouter: P0, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateBrowseContext(piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkCreateBrowseContext(piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkCreateExtensionServices<'a, P0, P1, P2, P3, P4>(pwzadditionalheaders: P0, phwnd: P1, pszusername: P2, pszpassword: P3, piunkouter: P4, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<super::super::Foundation::HWND>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateExtensionServices(pwzadditionalheaders: ::windows::core::PCWSTR, phwnd: super::super::Foundation::HWND, pszusername: ::windows::core::PCWSTR, pszpassword: ::windows::core::PCWSTR, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkCreateExtensionServices(pwzadditionalheaders.into(), phwnd.into(), pszusername.into(), pszpassword.into(), piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromData<'a, P0, P1, P2>(pidataobj: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P2, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateFromData(pidataobj: *mut ::core::ffi::c_void, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkCreateFromData(pidataobj.into().abi(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromMoniker<'a, P0, P1, P2, P3, P4>(pimktrgt: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P4, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateFromMoniker(pimktrgt: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkCreateFromMoniker(pimktrgt.into().abi(), pwzlocation.into(), pwzfriendlyname.into(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateFromString<'a, P0, P1, P2, P3, P4>(pwztarget: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P4, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateFromString(pwztarget: ::windows::core::PCWSTR, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkCreateFromString(pwztarget.into(), pwzlocation.into(), pwzfriendlyname.into(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateShortcut<'a, P0, P1, P2>(grfhlshortcutf: u32, pihl: P0, pwzdir: P1, pwzfilename: P2, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlink>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateShortcut(grfhlshortcutf: u32, pihl: *mut ::core::ffi::c_void, pwzdir: ::windows::core::PCWSTR, pwzfilename: ::windows::core::PCWSTR, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
    }
    HlinkCreateShortcut(grfhlshortcutf, pihl.into().abi(), pwzdir.into(), pwzfilename.into(), ::core::mem::transmute(ppwzshortcutfile), dwreserved).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateShortcutFromMoniker<'a, P0, P1, P2, P3>(grfhlshortcutf: u32, pimktarget: P0, pwzlocation: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateShortcutFromMoniker(grfhlshortcutf: u32, pimktarget: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzdir: ::windows::core::PCWSTR, pwzfilename: ::windows::core::PCWSTR, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
    }
    HlinkCreateShortcutFromMoniker(grfhlshortcutf, pimktarget.into().abi(), pwzlocation.into(), pwzdir.into(), pwzfilename.into(), ::core::mem::transmute(ppwzshortcutfile), dwreserved).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateShortcutFromString<'a, P0, P1, P2, P3>(grfhlshortcutf: u32, pwztarget: P0, pwzlocation: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateShortcutFromString(grfhlshortcutf: u32, pwztarget: ::windows::core::PCWSTR, pwzlocation: ::windows::core::PCWSTR, pwzdir: ::windows::core::PCWSTR, pwzfilename: ::windows::core::PCWSTR, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
    }
    HlinkCreateShortcutFromString(grfhlshortcutf, pwztarget.into(), pwzlocation.into(), pwzdir.into(), pwzfilename.into(), ::core::mem::transmute(ppwzshortcutfile), dwreserved).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkGetSpecialReference(ureference: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkGetSpecialReference(ureference: u32, ppwzreference: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkGetSpecialReference(ureference, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkGetValueFromParams<'a, P0, P1>(pwzparams: P0, pwzname: P1) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkGetValueFromParams(pwzparams: ::windows::core::PCWSTR, pwzname: ::windows::core::PCWSTR, ppwzvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkGetValueFromParams(pwzparams.into(), pwzname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkIsShortcut<'a, P0>(pwzfilename: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkIsShortcut(pwzfilename: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    HlinkIsShortcut(pwzfilename.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigate<'a, P0, P1, P2, P3, P4>(pihl: P0, pihlframe: P1, grfhlnf: u32, pbc: P2, pibsc: P3, pihlbc: P4) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlink>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkNavigate(pihl: *mut ::core::ffi::c_void, pihlframe: *mut ::core::ffi::c_void, grfhlnf: u32, pbc: *mut ::core::ffi::c_void, pibsc: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkNavigate(pihl.into().abi(), pihlframe.into().abi(), grfhlnf, pbc.into().abi(), pibsc.into().abi(), pihlbc.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigateToStringReference<'a, P0, P1, P2, P3, P4, P5, P6>(pwztarget: P0, pwzlocation: P1, pihlsite: P2, dwsitedata: u32, pihlframe: P3, grfhlnf: u32, pibc: P4, pibsc: P5, pihlbc: P6) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P5: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P6: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkNavigateToStringReference(pwztarget: ::windows::core::PCWSTR, pwzlocation: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, pihlframe: *mut ::core::ffi::c_void, grfhlnf: u32, pibc: *mut ::core::ffi::c_void, pibsc: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkNavigateToStringReference(pwztarget.into(), pwzlocation.into(), pihlsite.into().abi(), dwsitedata, pihlframe.into().abi(), grfhlnf, pibc.into().abi(), pibsc.into().abi(), pihlbc.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnNavigate<'a, P0, P1, P2, P3, P4>(pihlframe: P0, pihlbc: P1, grfhlnf: u32, pimktarget: P2, pwzlocation: P3, pwzfriendlyname: P4, puhlid: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkOnNavigate(pihlframe: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void, grfhlnf: u32, pimktarget: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR, puhlid: *mut u32) -> ::windows::core::HRESULT;
    }
    HlinkOnNavigate(pihlframe.into().abi(), pihlbc.into().abi(), grfhlnf, pimktarget.into().abi(), pwzlocation.into(), pwzfriendlyname.into(), ::core::mem::transmute(puhlid)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnRenameDocument<'a, P0, P1, P2>(dwreserved: u32, pihlbc: P0, pimkold: P1, pimknew: P2) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkOnRenameDocument(dwreserved: u32, pihlbc: *mut ::core::ffi::c_void, pimkold: *mut ::core::ffi::c_void, pimknew: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkOnRenameDocument(dwreserved, pihlbc.into().abi(), pimkold.into().abi(), pimknew.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkParseDisplayName<'a, P0, P1, P2>(pibc: P0, pwzdisplayname: P1, fnoforceabs: P2, pccheaten: *mut u32, ppimk: *mut ::core::option::Option<super::super::System::Com::IMoniker>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkParseDisplayName(pibc: *mut ::core::ffi::c_void, pwzdisplayname: ::windows::core::PCWSTR, fnoforceabs: super::super::Foundation::BOOL, pccheaten: *mut u32, ppimk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkParseDisplayName(pibc.into().abi(), pwzdisplayname.into(), fnoforceabs.into(), ::core::mem::transmute(pccheaten), ::core::mem::transmute(ppimk)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkPreprocessMoniker<'a, P0, P1>(pibc: P0, pimkin: P1) -> ::windows::core::Result<super::super::System::Com::IMoniker>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkPreprocessMoniker(pibc: *mut ::core::ffi::c_void, pimkin: *mut ::core::ffi::c_void, ppimkout: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkPreprocessMoniker(pibc.into().abi(), pimkin.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IMoniker>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkQueryCreateFromData<'a, P0>(pidataobj: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkQueryCreateFromData(pidataobj: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkQueryCreateFromData(pidataobj.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveMonikerForData<'a, P0, P1, P2, P3>(pimkreference: P0, reserved: u32, pibc: P1, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P2, pimkbase: P3) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveMonikerForData(pimkreference: *mut ::core::ffi::c_void, reserved: u32, pibc: *mut ::core::ffi::c_void, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: *mut ::core::ffi::c_void, pimkbase: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkResolveMonikerForData(pimkreference.into().abi(), reserved, pibc.into().abi(), cfmtetc, ::core::mem::transmute(rgfmtetc), pibsc.into().abi(), pimkbase.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkResolveShortcut<'a, P0, P1, P2>(pwzshortcutfilename: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P2, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveShortcut(pwzshortcutfilename: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkResolveShortcut(pwzshortcutfilename.into(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveShortcutToMoniker<'a, P0>(pwzshortcutfilename: P0, ppimktarget: *mut ::core::option::Option<super::super::System::Com::IMoniker>, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveShortcutToMoniker(pwzshortcutfilename: ::windows::core::PCWSTR, ppimktarget: *mut *mut ::core::ffi::c_void, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    HlinkResolveShortcutToMoniker(pwzshortcutfilename.into(), ::core::mem::transmute(ppimktarget), ::core::mem::transmute(ppwzlocation)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkResolveShortcutToString<'a, P0>(pwzshortcutfilename: P0, ppwztarget: *mut ::windows::core::PWSTR, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveShortcutToString(pwzshortcutfilename: ::windows::core::PCWSTR, ppwztarget: *mut ::windows::core::PWSTR, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    HlinkResolveShortcutToString(pwzshortcutfilename.into(), ::core::mem::transmute(ppwztarget), ::core::mem::transmute(ppwzlocation)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveStringForData<'a, P0, P1, P2, P3>(pwzreference: P0, reserved: u32, pibc: P1, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P2, pimkbase: P3) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveStringForData(pwzreference: ::windows::core::PCWSTR, reserved: u32, pibc: *mut ::core::ffi::c_void, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: *mut ::core::ffi::c_void, pimkbase: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkResolveStringForData(pwzreference.into(), reserved, pibc.into().abi(), cfmtetc, ::core::mem::transmute(rgfmtetc), pibsc.into().abi(), pimkbase.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkSetSpecialReference<'a, P0>(ureference: u32, pwzreference: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkSetSpecialReference(ureference: u32, pwzreference: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    HlinkSetSpecialReference(ureference, pwzreference.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkTranslateURL<'a, P0>(pwzurl: P0, grfflags: u32) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkTranslateURL(pwzurl: ::windows::core::PCWSTR, grfflags: u32, ppwztranslatedurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkTranslateURL(pwzurl.into(), grfflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkUpdateStackItem<'a, P0, P1, P2, P3, P4>(pihlframe: P0, pihlbc: P1, uhlid: u32, pimktrgt: P2, pwzlocation: P3, pwzfriendlyname: P4) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkUpdateStackItem(pihlframe: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void, uhlid: u32, pimktrgt: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    HlinkUpdateStackItem(pihlframe.into().abi(), pihlbc.into().abi(), uhlid, pimktrgt.into().abi(), pwzlocation.into(), pwzfriendlyname.into()).ok()
}
pub const HomeGroup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde77ba04_3c92_4d11_a1a5_42352a53e0e3);
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IACList(::windows::core::IUnknown);
impl IACList {
    pub unsafe fn Expand<'a, P0>(&self, pszexpand: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Expand)(::windows::core::Interface::as_raw(self), pszexpand.into()).ok()
    }
}
impl ::core::convert::From<IACList> for ::windows::core::IUnknown {
    fn from(value: IACList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IACList> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IACList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IACList> for ::windows::core::IUnknown {
    fn from(value: &IACList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IACList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IACList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IACList {}
impl ::core::fmt::Debug for IACList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IACList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IACList {
    type Vtable = IACList_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x77a130b0_94fd_11d0_a544_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Expand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszexpand: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IACList2(::windows::core::IUnknown);
impl IACList2 {
    pub unsafe fn Expand<'a, P0>(&self, pszexpand: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.Expand)(::windows::core::Interface::as_raw(self), pszexpand.into()).ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOptions)(::windows::core::Interface::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IACList2> for ::windows::core::IUnknown {
    fn from(value: IACList2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IACList2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IACList2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IACList2> for ::windows::core::IUnknown {
    fn from(value: &IACList2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IACList2> for IACList {
    fn from(value: IACList2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IACList2> for &'a IACList {
    fn from(value: &'a IACList2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IACList2> for IACList {
    fn from(value: &IACList2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IACList2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IACList2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IACList2 {}
impl ::core::fmt::Debug for IACList2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IACList2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IACList2 {
    type Vtable = IACList2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x470141a0_5186_11d2_bbb6_0060977b464c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList2_Vtbl {
    pub base__: IACList_Vtbl,
    pub SetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32) -> ::windows::core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflag: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAccessibilityDockingService(::windows::core::IUnknown);
impl IAccessibilityDockingService {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableSize<'a, P0>(&self, hmonitor: P0, pcxfixed: *mut u32, pcymax: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Interface::vtable(self).GetAvailableSize)(::windows::core::Interface::as_raw(self), hmonitor.into(), ::core::mem::transmute(pcxfixed), ::core::mem::transmute(pcymax)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn DockWindow<'a, P0, P1, P2>(&self, hwnd: P0, hmonitor: P1, cyrequested: u32, pcallback: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IAccessibilityDockingServiceCallback>>,
    {
        (::windows::core::Interface::vtable(self).DockWindow)(::windows::core::Interface::as_raw(self), hwnd.into(), hmonitor.into(), cyrequested, pcallback.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UndockWindow<'a, P0>(&self, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).UndockWindow)(::windows::core::Interface::as_raw(self), hwnd.into()).ok()
    }
}
impl ::core::convert::From<IAccessibilityDockingService> for ::windows::core::IUnknown {
    fn from(value: IAccessibilityDockingService) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAccessibilityDockingService> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAccessibilityDockingService) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessibilityDockingService> for ::windows::core::IUnknown {
    fn from(value: &IAccessibilityDockingService) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAccessibilityDockingService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibilityDockingService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibilityDockingService {}
impl ::core::fmt::Debug for IAccessibilityDockingService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibilityDockingService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessibilityDockingService {
    type Vtable = IAccessibilityDockingService_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8849dc22_cedf_4c95_998d_051419dd3f76);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingService_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pcxfixed: *mut u32, pcymax: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub DockWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, hmonitor: super::super::Graphics::Gdi::HMONITOR, cyrequested: u32, pcallback: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    DockWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub UndockWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UndockWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAccessibilityDockingServiceCallback(::windows::core::IUnknown);
impl IAccessibilityDockingServiceCallback {
    pub unsafe fn Undocked(&self, undockreason: UNDOCK_REASON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Undocked)(::windows::core::Interface::as_raw(self), undockreason).ok()
    }
}
impl ::core::convert::From<IAccessibilityDockingServiceCallback> for ::windows::core::IUnknown {
    fn from(value: IAccessibilityDockingServiceCallback) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAccessibilityDockingServiceCallback> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAccessibilityDockingServiceCallback) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessibilityDockingServiceCallback> for ::windows::core::IUnknown {
    fn from(value: &IAccessibilityDockingServiceCallback) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAccessibilityDockingServiceCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibilityDockingServiceCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibilityDockingServiceCallback {}
impl ::core::fmt::Debug for IAccessibilityDockingServiceCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibilityDockingServiceCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessibilityDockingServiceCallback {
    type Vtable = IAccessibilityDockingServiceCallback_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x157733fd_a592_42e5_b594_248468c5a81b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingServiceCallback_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Undocked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, undockreason: UNDOCK_REASON) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAccessibleObject(::windows::core::IUnknown);
impl IAccessibleObject {
    pub unsafe fn SetAccessibleName<'a, P0>(&self, pszname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetAccessibleName)(::windows::core::Interface::as_raw(self), pszname.into()).ok()
    }
}
impl ::core::convert::From<IAccessibleObject> for ::windows::core::IUnknown {
    fn from(value: IAccessibleObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAccessibleObject> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAccessibleObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessibleObject> for ::windows::core::IUnknown {
    fn from(value: &IAccessibleObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAccessibleObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibleObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibleObject {}
impl ::core::fmt::Debug for IAccessibleObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibleObject").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessibleObject {
    type Vtable = IAccessibleObject_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x95a391c5_9ed4_4c28_8401_ab9e06719e11);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleObject_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetAccessibleName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IActionProgress(::windows::core::IUnknown);
impl IActionProgress {
    pub unsafe fn Begin(&self, action: SPACTION, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Begin)(::windows::core::Interface::as_raw(self), action, flags).ok()
    }
    pub unsafe fn UpdateProgress(&self, ulcompleted: u64, ultotal: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateProgress)(::windows::core::Interface::as_raw(self), ulcompleted, ultotal).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateText<'a, P0, P1>(&self, sptext: SPTEXT, psztext: P0, fmaycompact: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).UpdateText)(::windows::core::Interface::as_raw(self), sptext, psztext.into(), fmaycompact.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryCancel(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).QueryCancel)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ResetCancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetCancel)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn End(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).End)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IActionProgress> for ::windows::core::IUnknown {
    fn from(value: IActionProgress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IActionProgress> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IActionProgress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActionProgress> for ::windows::core::IUnknown {
    fn from(value: &IActionProgress) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IActionProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IActionProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActionProgress {}
impl ::core::fmt::Debug for IActionProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActionProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActionProgress {
    type Vtable = IActionProgress_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49ff1173_eadc_446d_9285_156453a6431c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgress_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Begin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, action: SPACTION, flags: u32) -> ::windows::core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcompleted: u64, ultotal: u64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UpdateText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sptext: SPTEXT, psztext: ::windows::core::PCWSTR, fmaycompact: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UpdateText: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryCancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfcancelled: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryCancel: usize,
    pub ResetCancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub End: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IActionProgressDialog(::windows::core::IUnknown);
impl IActionProgressDialog {
    pub unsafe fn Initialize<'a, P0, P1>(&self, flags: u32, psztitle: P0, pszcancel: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), flags, psztitle.into(), pszcancel.into()).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Stop)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IActionProgressDialog> for ::windows::core::IUnknown {
    fn from(value: IActionProgressDialog) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IActionProgressDialog> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IActionProgressDialog) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActionProgressDialog> for ::windows::core::IUnknown {
    fn from(value: &IActionProgressDialog) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IActionProgressDialog {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IActionProgressDialog {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActionProgressDialog {}
impl ::core::fmt::Debug for IActionProgressDialog {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActionProgressDialog").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActionProgressDialog {
    type Vtable = IActionProgressDialog_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49ff1172_eadc_446d_9285_156453a6431c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgressDialog_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, psztitle: ::windows::core::PCWSTR, pszcancel: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppActivationUIInfo(::windows::core::IUnknown);
impl IAppActivationUIInfo {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HMONITOR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetMonitor)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HMONITOR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInvokePoint(&self) -> ::windows::core::Result<super::super::Foundation::POINT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetInvokePoint)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::POINT>(result__)
    }
    pub unsafe fn GetShowCommand(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetShowCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetShowUI(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetShowUI)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetKeyState(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetKeyState)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAppActivationUIInfo> for ::windows::core::IUnknown {
    fn from(value: IAppActivationUIInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAppActivationUIInfo> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAppActivationUIInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppActivationUIInfo> for ::windows::core::IUnknown {
    fn from(value: &IAppActivationUIInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAppActivationUIInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppActivationUIInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppActivationUIInfo {}
impl ::core::fmt::Debug for IAppActivationUIInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppActivationUIInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppActivationUIInfo {
    type Vtable = IAppActivationUIInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xabad189d_9fa3_4278_b3ca_8ca448a88dcb);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppActivationUIInfo_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Graphics::Gdi::HMONITOR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetMonitor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetInvokePoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Foundation::POINT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetInvokePoint: usize,
    pub GetShowCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetShowUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetShowUI: usize,
    pub GetKeyState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppPublisher(::windows::core::IUnknown);
impl IAppPublisher {
    pub unsafe fn GetNumberOfCategories(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNumberOfCategories)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetCategories(&self) -> ::windows::core::Result<APPCATEGORYINFOLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCategories)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<APPCATEGORYINFOLIST>(result__)
    }
    pub unsafe fn GetNumberOfApps(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNumberOfApps)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn EnumApps(&self, pappcategoryid: *const ::windows::core::GUID) -> ::windows::core::Result<IEnumPublishedApps> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumApps)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pappcategoryid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumPublishedApps>(result__)
    }
}
impl ::core::convert::From<IAppPublisher> for ::windows::core::IUnknown {
    fn from(value: IAppPublisher) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAppPublisher> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAppPublisher) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppPublisher> for ::windows::core::IUnknown {
    fn from(value: &IAppPublisher) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAppPublisher {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppPublisher {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppPublisher {}
impl ::core::fmt::Debug for IAppPublisher {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppPublisher").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppPublisher {
    type Vtable = IAppPublisher_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x07250a10_9cf9_11d1_9076_006008059382);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppPublisher_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetNumberOfCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcat: *mut u32) -> ::windows::core::HRESULT,
    pub GetCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pappcategorylist: *mut APPCATEGORYINFOLIST) -> ::windows::core::HRESULT,
    pub GetNumberOfApps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwapps: *mut u32) -> ::windows::core::HRESULT,
    pub EnumApps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pappcategoryid: *const ::windows::core::GUID, ppepa: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppVisibility(::windows::core::IUnknown);
impl IAppVisibility {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAppVisibilityOnMonitor<'a, P0>(&self, hmonitor: P0) -> ::windows::core::Result<MONITOR_APP_VISIBILITY>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAppVisibilityOnMonitor)(::windows::core::Interface::as_raw(self), hmonitor.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<MONITOR_APP_VISIBILITY>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsLauncherVisible(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsLauncherVisible)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Advise<'a, P0>(&self, pcallback: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IAppVisibilityEvents>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Advise)(::windows::core::Interface::as_raw(self), pcallback.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Unadvise)(::windows::core::Interface::as_raw(self), dwcookie).ok()
    }
}
impl ::core::convert::From<IAppVisibility> for ::windows::core::IUnknown {
    fn from(value: IAppVisibility) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAppVisibility> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAppVisibility) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppVisibility> for ::windows::core::IUnknown {
    fn from(value: &IAppVisibility) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAppVisibility {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppVisibility {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppVisibility {}
impl ::core::fmt::Debug for IAppVisibility {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppVisibility").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppVisibility {
    type Vtable = IAppVisibility_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2246ea2d_caea_4444_a3c4_6de827e44313);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibility_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAppVisibilityOnMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pmode: *mut MONITOR_APP_VISIBILITY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAppVisibilityOnMonitor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsLauncherVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfvisible: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsLauncherVisible: usize,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcallback: *mut ::core::ffi::c_void, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppVisibilityEvents(::windows::core::IUnknown);
impl IAppVisibilityEvents {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn AppVisibilityOnMonitorChanged<'a, P0>(&self, hmonitor: P0, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Interface::vtable(self).AppVisibilityOnMonitorChanged)(::windows::core::Interface::as_raw(self), hmonitor.into(), previousmode, currentmode).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LauncherVisibilityChange<'a, P0>(&self, currentvisiblestate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).LauncherVisibilityChange)(::windows::core::Interface::as_raw(self), currentvisiblestate.into()).ok()
    }
}
impl ::core::convert::From<IAppVisibilityEvents> for ::windows::core::IUnknown {
    fn from(value: IAppVisibilityEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAppVisibilityEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAppVisibilityEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppVisibilityEvents> for ::windows::core::IUnknown {
    fn from(value: &IAppVisibilityEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAppVisibilityEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppVisibilityEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppVisibilityEvents {}
impl ::core::fmt::Debug for IAppVisibilityEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppVisibilityEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppVisibilityEvents {
    type Vtable = IAppVisibilityEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6584ce6b_7d82_49c2_89c9_c6bc02ba8c38);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibilityEvents_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub AppVisibilityOnMonitorChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    AppVisibilityOnMonitorChanged: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub LauncherVisibilityChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, currentvisiblestate: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LauncherVisibilityChange: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationActivationManager(::windows::core::IUnknown);
impl IApplicationActivationManager {
    pub unsafe fn ActivateApplication<'a, P0, P1>(&self, appusermodelid: P0, arguments: P1, options: ACTIVATEOPTIONS) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ActivateApplication)(::windows::core::Interface::as_raw(self), appusermodelid.into(), arguments.into(), options, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn ActivateForFile<'a, P0, P1, P2>(&self, appusermodelid: P0, itemarray: P1, verb: P2) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellItemArray>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ActivateForFile)(::windows::core::Interface::as_raw(self), appusermodelid.into(), itemarray.into().abi(), verb.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn ActivateForProtocol<'a, P0, P1>(&self, appusermodelid: P0, itemarray: P1) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellItemArray>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ActivateForProtocol)(::windows::core::Interface::as_raw(self), appusermodelid.into(), itemarray.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IApplicationActivationManager> for ::windows::core::IUnknown {
    fn from(value: IApplicationActivationManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationActivationManager> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationActivationManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationActivationManager> for ::windows::core::IUnknown {
    fn from(value: &IApplicationActivationManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationActivationManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationActivationManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationActivationManager {}
impl ::core::fmt::Debug for IApplicationActivationManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationActivationManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationActivationManager {
    type Vtable = IApplicationActivationManager_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2e941141_7f97_4756_ba1d_9decde894a3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationActivationManager_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub ActivateApplication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: ::windows::core::PCWSTR, arguments: ::windows::core::PCWSTR, options: ACTIVATEOPTIONS, processid: *mut u32) -> ::windows::core::HRESULT,
    pub ActivateForFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: ::windows::core::PCWSTR, itemarray: *mut ::core::ffi::c_void, verb: ::windows::core::PCWSTR, processid: *mut u32) -> ::windows::core::HRESULT,
    pub ActivateForProtocol: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: ::windows::core::PCWSTR, itemarray: *mut ::core::ffi::c_void, processid: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationAssociationRegistration(::windows::core::IUnknown);
impl IApplicationAssociationRegistration {
    pub unsafe fn QueryCurrentDefault<'a, P0>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).QueryCurrentDefault)(::windows::core::Interface::as_raw(self), pszquery.into(), atquerytype, alquerylevel, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefault<'a, P0, P1>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P1) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).QueryAppIsDefault)(::windows::core::Interface::as_raw(self), pszquery.into(), atquerytype, alquerylevel, pszappregistryname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefaultAll<'a, P0>(&self, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).QueryAppIsDefaultAll)(::windows::core::Interface::as_raw(self), alquerylevel, pszappregistryname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetAppAsDefault<'a, P0, P1>(&self, pszappregistryname: P0, pszset: P1, atsettype: ASSOCIATIONTYPE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetAppAsDefault)(::windows::core::Interface::as_raw(self), pszappregistryname.into(), pszset.into(), atsettype).ok()
    }
    pub unsafe fn SetAppAsDefaultAll<'a, P0>(&self, pszappregistryname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetAppAsDefaultAll)(::windows::core::Interface::as_raw(self), pszappregistryname.into()).ok()
    }
    pub unsafe fn ClearUserAssociations(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ClearUserAssociations)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IApplicationAssociationRegistration> for ::windows::core::IUnknown {
    fn from(value: IApplicationAssociationRegistration) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationAssociationRegistration> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationAssociationRegistration) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationAssociationRegistration> for ::windows::core::IUnknown {
    fn from(value: &IApplicationAssociationRegistration) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationAssociationRegistration {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationAssociationRegistration {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationAssociationRegistration {}
impl ::core::fmt::Debug for IApplicationAssociationRegistration {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationAssociationRegistration").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationAssociationRegistration {
    type Vtable = IApplicationAssociationRegistration_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4e530b0a_e611_4c77_a3ac_9031d022281b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistration_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub QueryCurrentDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: ::windows::core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, ppszassociation: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryAppIsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: ::windows::core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: ::windows::core::PCWSTR, pfdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryAppIsDefault: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryAppIsDefaultAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: ::windows::core::PCWSTR, pfdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryAppIsDefaultAll: usize,
    pub SetAppAsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: ::windows::core::PCWSTR, pszset: ::windows::core::PCWSTR, atsettype: ASSOCIATIONTYPE) -> ::windows::core::HRESULT,
    pub SetAppAsDefaultAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ClearUserAssociations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationAssociationRegistrationUI(::windows::core::IUnknown);
impl IApplicationAssociationRegistrationUI {
    pub unsafe fn LaunchAdvancedAssociationUI<'a, P0>(&self, pszappregistryname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).LaunchAdvancedAssociationUI)(::windows::core::Interface::as_raw(self), pszappregistryname.into()).ok()
    }
}
impl ::core::convert::From<IApplicationAssociationRegistrationUI> for ::windows::core::IUnknown {
    fn from(value: IApplicationAssociationRegistrationUI) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationAssociationRegistrationUI> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationAssociationRegistrationUI) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationAssociationRegistrationUI> for ::windows::core::IUnknown {
    fn from(value: &IApplicationAssociationRegistrationUI) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationAssociationRegistrationUI {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationAssociationRegistrationUI {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationAssociationRegistrationUI {}
impl ::core::fmt::Debug for IApplicationAssociationRegistrationUI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationAssociationRegistrationUI").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationAssociationRegistrationUI {
    type Vtable = IApplicationAssociationRegistrationUI_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1f76a169_f994_40ac_8fc8_0959e8874710);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistrationUI_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub LaunchAdvancedAssociationUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDesignModeSettings(::windows::core::IUnknown);
impl IApplicationDesignModeSettings {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize(&self, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNativeDisplaySize)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(nativedisplaysizepixels)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetScaleFactor)(::windows::core::Interface::as_raw(self), scalefactor).ok()
    }
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetApplicationViewState)(::windows::core::Interface::as_raw(self), viewstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(&self) -> ::windows::core::Result<super::super::Foundation::SIZE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).ComputeApplicationSize)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsApplicationViewStateSupported)(::windows::core::Interface::as_raw(self), viewstate, ::core::mem::transmute(nativedisplaysizepixels), scalefactor, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TriggerEdgeGesture)(::windows::core::Interface::as_raw(self), edgegesturekind).ok()
    }
}
impl ::core::convert::From<IApplicationDesignModeSettings> for ::windows::core::IUnknown {
    fn from(value: IApplicationDesignModeSettings) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationDesignModeSettings> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationDesignModeSettings) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDesignModeSettings> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDesignModeSettings) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationDesignModeSettings {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDesignModeSettings {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDesignModeSettings {}
impl ::core::fmt::Debug for IApplicationDesignModeSettings {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDesignModeSettings").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDesignModeSettings {
    type Vtable = IApplicationDesignModeSettings_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a3dee9a_e31d_46d6_8508_bcc597db3557);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetNativeDisplaySize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetNativeDisplaySize: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetScaleFactor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetScaleFactor: usize,
    pub SetApplicationViewState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ComputeApplicationSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, applicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ComputeApplicationSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub IsApplicationViewStateSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR, supported: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    IsApplicationViewStateSupported: usize,
    pub TriggerEdgeGesture: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDesignModeSettings2(::windows::core::IUnknown);
impl IApplicationDesignModeSettings2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize(&self, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetNativeDisplaySize)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(nativedisplaysizepixels)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetScaleFactor)(::windows::core::Interface::as_raw(self), scalefactor).ok()
    }
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetApplicationViewState)(::windows::core::Interface::as_raw(self), viewstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(&self) -> ::windows::core::Result<super::super::Foundation::SIZE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.ComputeApplicationSize)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsApplicationViewStateSupported)(::windows::core::Interface::as_raw(self), viewstate, ::core::mem::transmute(nativedisplaysizepixels), scalefactor, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.TriggerEdgeGesture)(::windows::core::Interface::as_raw(self), edgegesturekind).ok()
    }
    pub unsafe fn SetNativeDisplayOrientation(&self, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNativeDisplayOrientation)(::windows::core::Interface::as_raw(self), nativedisplayorientation).ok()
    }
    pub unsafe fn SetApplicationViewOrientation(&self, vieworientation: APPLICATION_VIEW_ORIENTATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetApplicationViewOrientation)(::windows::core::Interface::as_raw(self), vieworientation).ok()
    }
    pub unsafe fn SetAdjacentDisplayEdges(&self, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAdjacentDisplayEdges)(::windows::core::Interface::as_raw(self), adjacentdisplayedges).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIsOnLockScreen<'a, P0>(&self, isonlockscreen: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetIsOnLockScreen)(::windows::core::Interface::as_raw(self), isonlockscreen.into()).ok()
    }
    pub unsafe fn SetApplicationViewMinWidth(&self, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetApplicationViewMinWidth)(::windows::core::Interface::as_raw(self), viewminwidth).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationSizeBounds(&self, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetApplicationSizeBounds)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(minapplicationsizepixels), ::core::mem::transmute(maxapplicationsizepixels)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationViewOrientation(&self, applicationsizepixels: super::super::Foundation::SIZE) -> ::windows::core::Result<APPLICATION_VIEW_ORIENTATION> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetApplicationViewOrientation)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(applicationsizepixels), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<APPLICATION_VIEW_ORIENTATION>(result__)
    }
}
impl ::core::convert::From<IApplicationDesignModeSettings2> for ::windows::core::IUnknown {
    fn from(value: IApplicationDesignModeSettings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationDesignModeSettings2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationDesignModeSettings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDesignModeSettings2> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDesignModeSettings2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IApplicationDesignModeSettings2> for IApplicationDesignModeSettings {
    fn from(value: IApplicationDesignModeSettings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationDesignModeSettings2> for &'a IApplicationDesignModeSettings {
    fn from(value: &'a IApplicationDesignModeSettings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDesignModeSettings2> for IApplicationDesignModeSettings {
    fn from(value: &IApplicationDesignModeSettings2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationDesignModeSettings2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDesignModeSettings2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDesignModeSettings2 {}
impl ::core::fmt::Debug for IApplicationDesignModeSettings2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDesignModeSettings2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDesignModeSettings2 {
    type Vtable = IApplicationDesignModeSettings2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x490514e1_675a_4d6e_a58d_e54901b4ca2f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings2_Vtbl {
    pub base__: IApplicationDesignModeSettings_Vtbl,
    pub SetNativeDisplayOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> ::windows::core::HRESULT,
    pub SetApplicationViewOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vieworientation: APPLICATION_VIEW_ORIENTATION) -> ::windows::core::HRESULT,
    pub SetAdjacentDisplayEdges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetIsOnLockScreen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isonlockscreen: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetIsOnLockScreen: usize,
    pub SetApplicationViewMinWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetApplicationSizeBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetApplicationSizeBounds: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetApplicationViewOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, applicationsizepixels: super::super::Foundation::SIZE, vieworientation: *mut APPLICATION_VIEW_ORIENTATION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetApplicationViewOrientation: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDestinations(::windows::core::IUnknown);
impl IApplicationDestinations {
    pub unsafe fn SetAppID<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetAppID)(::windows::core::Interface::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn RemoveDestination<'a, P0>(&self, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).RemoveDestination)(::windows::core::Interface::as_raw(self), punk.into().abi()).ok()
    }
    pub unsafe fn RemoveAllDestinations(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveAllDestinations)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IApplicationDestinations> for ::windows::core::IUnknown {
    fn from(value: IApplicationDestinations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationDestinations> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationDestinations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDestinations> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDestinations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationDestinations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDestinations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDestinations {}
impl ::core::fmt::Debug for IApplicationDestinations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDestinations").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDestinations {
    type Vtable = IApplicationDestinations_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12337d35_94c6_48a0_bce7_6a9c69d4d600);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDestinations_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RemoveDestination: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RemoveAllDestinations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDocumentLists(::windows::core::IUnknown);
impl IApplicationDocumentLists {
    pub unsafe fn SetAppID<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetAppID)(::windows::core::Interface::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn GetList<T>(&self, listtype: APPDOCLISTTYPE, citemsdesired: u32) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetList)(::windows::core::Interface::as_raw(self), listtype, citemsdesired, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
impl ::core::convert::From<IApplicationDocumentLists> for ::windows::core::IUnknown {
    fn from(value: IApplicationDocumentLists) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IApplicationDocumentLists> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IApplicationDocumentLists) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDocumentLists> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDocumentLists) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IApplicationDocumentLists {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDocumentLists {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDocumentLists {}
impl ::core::fmt::Debug for IApplicationDocumentLists {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDocumentLists").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDocumentLists {
    type Vtable = IApplicationDocumentLists_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c594f9f_9f30_47a1_979a_c9e83d3d0a06);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDocumentLists_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, listtype: APPDOCLISTTYPE, citemsdesired: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAssocHandler(::windows::core::IUnknown);
impl IAssocHandler {
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetUIName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetUIName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetIconLocation(&self, ppszpath: *mut ::windows::core::PWSTR, pindex: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIconLocation)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppszpath), ::core::mem::transmute(pindex)).ok()
    }
    pub unsafe fn IsRecommended(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsRecommended)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn MakeDefault<'a, P0>(&self, pszdescription: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).MakeDefault)(::windows::core::Interface::as_raw(self), pszdescription.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<'a, P0>(&self, pdo: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    {
        (::windows::core::Interface::vtable(self).Invoke)(::windows::core::Interface::as_raw(self), pdo.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateInvoker<'a, P0>(&self, pdo: P0) -> ::windows::core::Result<IAssocHandlerInvoker>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CreateInvoker)(::windows::core::Interface::as_raw(self), pdo.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IAssocHandlerInvoker>(result__)
    }
}
impl ::core::convert::From<IAssocHandler> for ::windows::core::IUnknown {
    fn from(value: IAssocHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAssocHandler> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAssocHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAssocHandler> for ::windows::core::IUnknown {
    fn from(value: &IAssocHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAssocHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAssocHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAssocHandler {}
impl ::core::fmt::Debug for IAssocHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAssocHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAssocHandler {
    type Vtable = IAssocHandler_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf04061ac_1659_4a3f_a954_775aa57fc083);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandler_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetUIName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetIconLocation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpath: *mut ::windows::core::PWSTR, pindex: *mut i32) -> ::windows::core::HRESULT,
    pub IsRecommended: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub MakeDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdescription: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdo: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Invoke: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateInvoker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdo: *mut ::core::ffi::c_void, ppinvoker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateInvoker: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAssocHandlerInvoker(::windows::core::IUnknown);
impl IAssocHandlerInvoker {
    pub unsafe fn SupportsSelection(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SupportsSelection)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Invoke(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Invoke)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IAssocHandlerInvoker> for ::windows::core::IUnknown {
    fn from(value: IAssocHandlerInvoker) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAssocHandlerInvoker> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAssocHandlerInvoker) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAssocHandlerInvoker> for ::windows::core::IUnknown {
    fn from(value: &IAssocHandlerInvoker) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAssocHandlerInvoker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAssocHandlerInvoker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAssocHandlerInvoker {}
impl ::core::fmt::Debug for IAssocHandlerInvoker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAssocHandlerInvoker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAssocHandlerInvoker {
    type Vtable = IAssocHandlerInvoker_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x92218cab_ecaa_4335_8133_807fd234c2ee);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandlerInvoker_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SupportsSelection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAttachmentExecute(::windows::core::IUnknown);
impl IAttachmentExecute {
    pub unsafe fn SetClientTitle<'a, P0>(&self, psztitle: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetClientTitle)(::windows::core::Interface::as_raw(self), psztitle.into()).ok()
    }
    pub unsafe fn SetClientGuid(&self, guid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetClientGuid)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(guid)).ok()
    }
    pub unsafe fn SetLocalPath<'a, P0>(&self, pszlocalpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetLocalPath)(::windows::core::Interface::as_raw(self), pszlocalpath.into()).ok()
    }
    pub unsafe fn SetFileName<'a, P0>(&self, pszfilename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetFileName)(::windows::core::Interface::as_raw(self), pszfilename.into()).ok()
    }
    pub unsafe fn SetSource<'a, P0>(&self, pszsource: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetSource)(::windows::core::Interface::as_raw(self), pszsource.into()).ok()
    }
    pub unsafe fn SetReferrer<'a, P0>(&self, pszreferrer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetReferrer)(::windows::core::Interface::as_raw(self), pszreferrer.into()).ok()
    }
    pub unsafe fn CheckPolicy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CheckPolicy)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Prompt<'a, P0>(&self, hwnd: P0, prompt: ATTACHMENT_PROMPT) -> ::windows::core::Result<ATTACHMENT_ACTION>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Prompt)(::windows::core::Interface::as_raw(self), hwnd.into(), prompt, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ATTACHMENT_ACTION>(result__)
    }
    pub unsafe fn Save(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Save)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Execute<'a, P0, P1>(&self, hwnd: P0, pszverb: P1) -> ::windows::core::Result<super::super::Foundation::HANDLE>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).Execute)(::windows::core::Interface::as_raw(self), hwnd.into(), pszverb.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SaveWithUI<'a, P0>(&self, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).SaveWithUI)(::windows::core::Interface::as_raw(self), hwnd.into()).ok()
    }
    pub unsafe fn ClearClientState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ClearClientState)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IAttachmentExecute> for ::windows::core::IUnknown {
    fn from(value: IAttachmentExecute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAttachmentExecute> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAttachmentExecute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAttachmentExecute> for ::windows::core::IUnknown {
    fn from(value: &IAttachmentExecute) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAttachmentExecute {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAttachmentExecute {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAttachmentExecute {}
impl ::core::fmt::Debug for IAttachmentExecute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAttachmentExecute").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAttachmentExecute {
    type Vtable = IAttachmentExecute_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73db1241_1e85_4581_8e4f_a81e1d0f8c57);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttachmentExecute_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetClientTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psztitle: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetClientGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub SetLocalPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszlocalpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsource: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetReferrer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszreferrer: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CheckPolicy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Prompt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, prompt: ATTACHMENT_PROMPT, paction: *mut ATTACHMENT_ACTION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Prompt: usize,
    pub Save: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pszverb: ::windows::core::PCWSTR, phprocess: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Execute: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SaveWithUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SaveWithUI: usize,
    pub ClearClientState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAutoComplete(::windows::core::IUnknown);
impl IAutoComplete {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0, P1, P2, P3>(&self, hwndedit: P0, punkacl: P1, pwszregkeypath: P2, pwszquickcomplete: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Init)(::windows::core::Interface::as_raw(self), hwndedit.into(), punkacl.into().abi(), pwszregkeypath.into(), pwszquickcomplete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, P0>(&self, fenable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).Enable)(::windows::core::Interface::as_raw(self), fenable.into()).ok()
    }
}
impl ::core::convert::From<IAutoComplete> for ::windows::core::IUnknown {
    fn from(value: IAutoComplete) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAutoComplete> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAutoComplete) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoComplete> for ::windows::core::IUnknown {
    fn from(value: &IAutoComplete) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAutoComplete {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoComplete {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoComplete {}
impl ::core::fmt::Debug for IAutoComplete {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoComplete").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAutoComplete {
    type Vtable = IAutoComplete_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2762_6a77_11d0_a535_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndedit: super::super::Foundation::HWND, punkacl: *mut ::core::ffi::c_void, pwszregkeypath: ::windows::core::PCWSTR, pwszquickcomplete: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Init: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Enable: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAutoComplete2(::windows::core::IUnknown);
impl IAutoComplete2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0, P1, P2, P3>(&self, hwndedit: P0, punkacl: P1, pwszregkeypath: P2, pwszquickcomplete: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.Init)(::windows::core::Interface::as_raw(self), hwndedit.into(), punkacl.into().abi(), pwszregkeypath.into(), pwszquickcomplete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, P0>(&self, fenable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.Enable)(::windows::core::Interface::as_raw(self), fenable.into()).ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOptions)(::windows::core::Interface::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAutoComplete2> for ::windows::core::IUnknown {
    fn from(value: IAutoComplete2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAutoComplete2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAutoComplete2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoComplete2> for ::windows::core::IUnknown {
    fn from(value: &IAutoComplete2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IAutoComplete2> for IAutoComplete {
    fn from(value: IAutoComplete2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAutoComplete2> for &'a IAutoComplete {
    fn from(value: &'a IAutoComplete2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoComplete2> for IAutoComplete {
    fn from(value: &IAutoComplete2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAutoComplete2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoComplete2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoComplete2 {}
impl ::core::fmt::Debug for IAutoComplete2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoComplete2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAutoComplete2 {
    type Vtable = IAutoComplete2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeac04bc0_3791_11d2_bb95_0060977b464c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete2_Vtbl {
    pub base__: IAutoComplete_Vtbl,
    pub SetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32) -> ::windows::core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflag: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAutoCompleteDropDown(::windows::core::IUnknown);
impl IAutoCompleteDropDown {
    pub unsafe fn GetDropDownStatus(&self, pdwflags: *mut u32, ppwszstring: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDropDownStatus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwflags), ::core::mem::transmute(ppwszstring)).ok()
    }
    pub unsafe fn ResetEnumerator(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetEnumerator)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IAutoCompleteDropDown> for ::windows::core::IUnknown {
    fn from(value: IAutoCompleteDropDown) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IAutoCompleteDropDown> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IAutoCompleteDropDown) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoCompleteDropDown> for ::windows::core::IUnknown {
    fn from(value: &IAutoCompleteDropDown) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IAutoCompleteDropDown {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoCompleteDropDown {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoCompleteDropDown {}
impl ::core::fmt::Debug for IAutoCompleteDropDown {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoCompleteDropDown").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAutoCompleteDropDown {
    type Vtable = IAutoCompleteDropDown_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3cd141f4_3c6a_11d2_bcaa_00c04fd929db);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoCompleteDropDown_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetDropDownStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32, ppwszstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub ResetEnumerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBandHost(::windows::core::IUnknown);
impl IBandHost {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBand<'a, P0, P1, T>(&self, rclsidband: *const ::windows::core::GUID, favailable: P0, fvisible: P1) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateBand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(rclsidband), favailable.into(), fvisible.into(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBandAvailability<'a, P0>(&self, rclsidband: *const ::windows::core::GUID, favailable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetBandAvailability)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(rclsidband), favailable.into()).ok()
    }
    pub unsafe fn DestroyBand(&self, rclsidband: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DestroyBand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(rclsidband)).ok()
    }
}
impl ::core::convert::From<IBandHost> for ::windows::core::IUnknown {
    fn from(value: IBandHost) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBandHost> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBandHost) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBandHost> for ::windows::core::IUnknown {
    fn from(value: &IBandHost) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBandHost {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBandHost {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBandHost {}
impl ::core::fmt::Debug for IBandHost {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBandHost").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBandHost {
    type Vtable = IBandHost_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb9075c7c_d48e_403f_ab99_d6c77a1084ac);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandHost_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID, favailable: super::super::Foundation::BOOL, fvisible: super::super::Foundation::BOOL, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateBand: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetBandAvailability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID, favailable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetBandAvailability: usize,
    pub DestroyBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBandSite(::windows::core::IUnknown);
impl IBandSite {
    pub unsafe fn AddBand<'a, P0>(&self, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).AddBand)(::windows::core::Interface::as_raw(self), punk.into().abi()).ok()
    }
    pub unsafe fn EnumBands(&self, uband: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumBands)(::windows::core::Interface::as_raw(self), uband, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn QueryBand(&self, dwbandid: u32, ppstb: *mut ::core::option::Option<IDeskBand>, pdwstate: *mut u32, pszname: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryBand)(::windows::core::Interface::as_raw(self), dwbandid, ::core::mem::transmute(ppstb), ::core::mem::transmute(pdwstate), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszname)), pszname.len() as _).ok()
    }
    pub unsafe fn SetBandState(&self, dwbandid: u32, dwmask: u32, dwstate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBandState)(::windows::core::Interface::as_raw(self), dwbandid, dwmask, dwstate).ok()
    }
    pub unsafe fn RemoveBand(&self, dwbandid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveBand)(::windows::core::Interface::as_raw(self), dwbandid).ok()
    }
    pub unsafe fn GetBandObject<T>(&self, dwbandid: u32) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetBandObject)(::windows::core::Interface::as_raw(self), dwbandid, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn SetBandSiteInfo(&self, pbsinfo: *const BANDSITEINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBandSiteInfo)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pbsinfo)).ok()
    }
    pub unsafe fn GetBandSiteInfo(&self, pbsinfo: *mut BANDSITEINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetBandSiteInfo)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pbsinfo)).ok()
    }
}
impl ::core::convert::From<IBandSite> for ::windows::core::IUnknown {
    fn from(value: IBandSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBandSite> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBandSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBandSite> for ::windows::core::IUnknown {
    fn from(value: &IBandSite) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBandSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBandSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBandSite {}
impl ::core::fmt::Debug for IBandSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBandSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBandSite {
    type Vtable = IBandSite_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4cf504b0_de96_11d0_8b3f_00a0c911e8e5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandSite_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub AddBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumBands: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uband: u32, pdwbandid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub QueryBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, ppstb: *mut *mut ::core::ffi::c_void, pdwstate: *mut u32, pszname: ::windows::core::PWSTR, cchname: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    QueryBand: usize,
    pub SetBandState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, dwmask: u32, dwstate: u32) -> ::windows::core::HRESULT,
    pub RemoveBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32) -> ::windows::core::HRESULT,
    pub GetBandObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetBandSiteInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbsinfo: *const BANDSITEINFO) -> ::windows::core::HRESULT,
    pub GetBandSiteInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbsinfo: *mut BANDSITEINFO) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBannerNotificationHandler(::windows::core::IUnknown);
impl IBannerNotificationHandler {
    pub unsafe fn OnBannerEvent(&self, notification: *const BANNER_NOTIFICATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnBannerEvent)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(notification)).ok()
    }
}
impl ::core::convert::From<IBannerNotificationHandler> for ::windows::core::IUnknown {
    fn from(value: IBannerNotificationHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBannerNotificationHandler> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBannerNotificationHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBannerNotificationHandler> for ::windows::core::IUnknown {
    fn from(value: &IBannerNotificationHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBannerNotificationHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBannerNotificationHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBannerNotificationHandler {}
impl ::core::fmt::Debug for IBannerNotificationHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBannerNotificationHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBannerNotificationHandler {
    type Vtable = IBannerNotificationHandler_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8d7b2ba7_db05_46a8_823c_d2b6de08ee91);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBannerNotificationHandler_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub OnBannerEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, notification: *const BANNER_NOTIFICATION) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBanneredBar(::windows::core::IUnknown);
impl IBanneredBar {
    pub unsafe fn SetIconSize(&self, iicon: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetIconSize)(::windows::core::Interface::as_raw(self), iicon).ok()
    }
    pub unsafe fn GetIconSize(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetIconSize)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetBitmap<'a, P0>(&self, hbitmap: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HBITMAP>,
    {
        (::windows::core::Interface::vtable(self).SetBitmap)(::windows::core::Interface::as_raw(self), hbitmap.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmap(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBitmap)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
}
impl ::core::convert::From<IBanneredBar> for ::windows::core::IUnknown {
    fn from(value: IBanneredBar) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBanneredBar> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBanneredBar) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBanneredBar> for ::windows::core::IUnknown {
    fn from(value: &IBanneredBar) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBanneredBar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBanneredBar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBanneredBar {}
impl ::core::fmt::Debug for IBanneredBar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBanneredBar").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBanneredBar {
    type Vtable = IBanneredBar_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x596a9a94_013e_11d1_8d34_00a0c90f2719);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBanneredBar_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetIconSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iicon: u32) -> ::windows::core::HRESULT,
    pub GetIconSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, piicon: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hbitmap: super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phbitmap: *mut super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmap: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserFrameOptions(::windows::core::IUnknown);
impl IBrowserFrameOptions {
    pub unsafe fn GetFrameOptions(&self, dwmask: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFrameOptions)(::windows::core::Interface::as_raw(self), dwmask, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IBrowserFrameOptions> for ::windows::core::IUnknown {
    fn from(value: IBrowserFrameOptions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserFrameOptions> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBrowserFrameOptions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserFrameOptions> for ::windows::core::IUnknown {
    fn from(value: &IBrowserFrameOptions) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBrowserFrameOptions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserFrameOptions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserFrameOptions {}
impl ::core::fmt::Debug for IBrowserFrameOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserFrameOptions").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserFrameOptions {
    type Vtable = IBrowserFrameOptions_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x10df43c8_1dbe_11d3_8b34_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserFrameOptions_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetFrameOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwmask: u32, pdwoptions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService(::windows::core::IUnknown);
impl IBrowserService {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetParentSite)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).GetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszname)), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetOleObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetTravelLog)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).ShowControlWindow)(::windows::core::Interface::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IsControlWindowShown)(::windows::core::Interface::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IEGetDisplayName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IEParseDisplayName)(::windows::core::Interface::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DisplayParseError)(::windows::core::Interface::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).NavigateToPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNavigateState)(::windows::core::Interface::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetNavigateState)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).NotifyRedirect)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateWindowList)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateBackForwardState)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFlags)(::windows::core::Interface::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CanNavigateNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetReferrer)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Interface::vtable(self).GetBrowserIndex)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBrowserByIndex)(::windows::core::Interface::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetHistoryObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetHistoryObject)(::windows::core::Interface::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Interface::vtable(self).CacheOLEServer)(::windows::core::Interface::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetSetCodePage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).OnHttpEquiv)(::windows::core::Interface::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetPalette)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).RegisterWindow)(::windows::core::Interface::as_raw(self), fforceregister.into(), swc).ok()
    }
}
impl ::core::convert::From<IBrowserService> for ::windows::core::IUnknown {
    fn from(value: IBrowserService) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBrowserService) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBrowserService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService {}
impl ::core::fmt::Debug for IBrowserService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService {
    type Vtable = IBrowserService_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x02ba3b52_0547_11d1_b833_00c04fc9b31f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetParentSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppipsite: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetParentSite: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pszname: ::windows::core::PWSTR, cchname: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetOleObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppobjv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetOleObject: usize,
    pub GetTravelLog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptl: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowControlWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: u32, fshow: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowControlWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsControlWindowShown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: u32, pfshown: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsControlWindowShown: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEGetDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEGetDisplayName: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicp: u32, pwszpath: ::windows::core::PCWSTR, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayName: usize,
    pub DisplayParseError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hres: ::windows::core::HRESULT, pwszpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub NavigateToPidl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    NavigateToPidl: usize,
    pub SetNavigateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bnstate: BNSTATE) -> ::windows::core::HRESULT,
    pub GetNavigateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbnstate: *mut BNSTATE) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub NotifyRedirect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pfdidbrowse: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    NotifyRedirect: usize,
    pub UpdateWindowList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UpdateBackForwardState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, dwflagmask: u32) -> ::windows::core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
    pub CanNavigateNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetPidl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetPidl: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetReferrer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetReferrer: usize,
    pub GetBrowserIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub GetBrowserByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwid: u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetHistoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppole: *mut *mut ::core::ffi::c_void, pstm: *mut *mut ::core::ffi::c_void, ppbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetHistoryObject: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub SetHistoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pole: *mut ::core::ffi::c_void, fislocalanchor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    SetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub CacheOLEServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pole: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CacheOLEServer: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetSetCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarin: *const super::super::System::Com::VARIANT, pvarout: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetSetCodePage: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OnHttpEquiv: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, fdone: super::super::Foundation::BOOL, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OnHttpEquiv: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hpal: *mut super::super::Graphics::Gdi::HPALETTE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RegisterWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fforceregister: super::super::Foundation::BOOL, swc: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RegisterWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService2(::windows::core::IUnknown);
impl IBrowserService2 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetParentSite)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.GetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszname)), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetOleObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetTravelLog)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.ShowControlWindow)(::windows::core::Interface::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IsControlWindowShown)(::windows::core::Interface::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.IEGetDisplayName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IEParseDisplayName)(::windows::core::Interface::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.DisplayParseError)(::windows::core::Interface::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.NavigateToPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetNavigateState)(::windows::core::Interface::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetNavigateState)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.NotifyRedirect)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UpdateWindowList)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UpdateBackForwardState)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetFlags)(::windows::core::Interface::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CanNavigateNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetReferrer)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Interface::vtable(self).base__.GetBrowserIndex)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetBrowserByIndex)(::windows::core::Interface::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetHistoryObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetHistoryObject)(::windows::core::Interface::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Interface::vtable(self).base__.CacheOLEServer)(::windows::core::Interface::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetSetCodePage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.OnHttpEquiv)(::windows::core::Interface::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetPalette)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.RegisterWindow)(::windows::core::Interface::as_raw(self), fforceregister.into(), swc).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).WndProcBS)(::windows::core::Interface::as_raw(self), hwnd.into(), umsg, wparam.into(), lparam.into())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAsDefFolderSettings)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetViewRect)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, P0>(&self, wparam: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    {
        (::windows::core::Interface::vtable(self).OnSize)(::windows::core::Interface::as_raw(self), wparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnCreate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).OnCommand)(::windows::core::Interface::as_raw(self), wparam.into(), lparam.into())
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnDestroy)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (::windows::core::Interface::vtable(self).OnNotify)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pnm))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnSetFocus)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, P0>(&self, factive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).OnFrameWindowActivateBS)(::windows::core::Interface::as_raw(self), factive.into()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReleaseShellView)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ActivatePendingView)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).CreateViewWindow)(::windows::core::Interface::as_raw(self), psvnew.into().abi(), psvold.into().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateBrowserPropSheetExt)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetViewWindow)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBaseBrowserData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (::windows::core::Interface::vtable(self).PutBaseBrowserData)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<'a, P0>(&self, ptl: P0, dw: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ITravelLog>>,
    {
        (::windows::core::Interface::vtable(self).InitializeTravelLog)(::windows::core::Interface::as_raw(self), ptl.into().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTopBrowser)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Offline)(::windows::core::Interface::as_raw(self), icmd).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, P0>(&self, f: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).AllowViewResize)(::windows::core::Interface::as_raw(self), f.into()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetActivateState)(::windows::core::Interface::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateSecureLockIcon)(::windows::core::Interface::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeDownloadManager)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeTransitionSite)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, P0, P1>(&self, hwnd: P0, pauto: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self)._Initialize)(::windows::core::Interface::as_raw(self), hwnd.into(), pauto.into().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._CancelPendingNavigationAsync)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._CancelPendingView)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._MaySaveChanges)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, P0>(&self, fpaused: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self)._PauseOrResumeView)(::windows::core::Interface::as_raw(self), fpaused.into()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._DisableModeless)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._NavigateToPidl2)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self)._TryShell2Rename)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._SwitchActivationNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self)._ExecChildren)(::windows::core::Interface::as_raw(self), punkbar.into().abi(), fbroadcast.into(), ::core::mem::transmute(pguidcmdgroup), ncmdid, ncmdexecopt, ::core::mem::transmute(pvarargin), ::core::mem::transmute(pvarargout)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P3: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self)._SendChildren)(::windows::core::Interface::as_raw(self), hwndbar.into(), fbroadcast.into(), umsg, wparam.into(), lparam.into()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetFolderSetData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pfsd)).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._OnFocusChange)(::windows::core::Interface::as_raw(self), itb).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, P0>(&self, fchildonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).v_ShowHideChildWindows)(::windows::core::Interface::as_raw(self), fchildonly.into()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (::windows::core::Interface::vtable(self)._get_itbLastFocus)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._put_itbLastFocus)(::windows::core::Interface::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._UIActivateView)(::windows::core::Interface::as_raw(self), ustate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._GetViewBorderRect)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._UpdateViewRectSize)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeNextBorder)(::windows::core::Interface::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeView)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Interface::vtable(self)._GetEffectiveClientArea)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(lprectborder), hmon.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> ::core::option::Option<super::super::System::Com::IStream>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).v_GetViewStream)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfmode, pwszname.into())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).ForwardViewMsg)(::windows::core::Interface::as_raw(self), umsg, wparam.into(), lparam.into())
    }
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, P0>(&self, hacc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HACCEL>,
    {
        (::windows::core::Interface::vtable(self).SetAcceleratorMenu)(::windows::core::Interface::as_raw(self), hacc.into()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (::windows::core::Interface::vtable(self)._GetToolbarCount)(::windows::core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (::windows::core::Interface::vtable(self)._GetToolbarItem)(::windows::core::Interface::as_raw(self), itb)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Interface::vtable(self)._SaveToolbars)(::windows::core::Interface::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Interface::vtable(self)._LoadToolbars)(::windows::core::Interface::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, P0>(&self, fclose: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self)._CloseAndReleaseToolbars)(::windows::core::Interface::as_raw(self), fclose.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_MayGetNextToolbarFocus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(lpmsg), itbnext, citb, ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, P0>(&self, itb: u32, busehmonitor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self)._ResizeNextBorderHelper)(::windows::core::Interface::as_raw(self), itb, busehmonitor.into()).ok()
    }
    pub unsafe fn _FindTBar<'a, P0>(&self, punksrc: P0) -> u32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self)._FindTBar)(::windows::core::Interface::as_raw(self), punksrc.into().abi())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self)._SetFocus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ptbi), hwnd.into(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_MayTranslateAccelerator)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self)._GetBorderDWHelper)(::windows::core::Interface::as_raw(self), punksrc.into().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_CheckZoneCrossing)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
}
impl ::core::convert::From<IBrowserService2> for ::windows::core::IUnknown {
    fn from(value: IBrowserService2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBrowserService2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService2> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IBrowserService2> for IBrowserService {
    fn from(value: IBrowserService2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService2> for &'a IBrowserService {
    fn from(value: &'a IBrowserService2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService2> for IBrowserService {
    fn from(value: &IBrowserService2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBrowserService2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService2 {}
impl ::core::fmt::Debug for IBrowserService2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService2 {
    type Vtable = IBrowserService2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x68bd21cc_438b_11d2_a560_00a0c92dbfe8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService2_Vtbl {
    pub base__: IBrowserService_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub WndProcBS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WndProcBS: usize,
    pub SetAsDefFolderSettings: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetViewRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetViewRect: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wparam: super::super::Foundation::WPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub OnCreate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    OnCreate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnCommand: usize,
    pub OnDestroy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub OnNotify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls")))]
    OnNotify: usize,
    pub OnSetFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnFrameWindowActivateBS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, factive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnFrameWindowActivateBS: usize,
    pub ReleaseShellView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ActivatePendingView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub CreateViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psvnew: *mut ::core::ffi::c_void, psvold: *mut ::core::ffi::c_void, prcview: *const super::super::Foundation::RECT, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    CreateViewWindow: usize,
    pub CreateBrowserPropSheetExt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndview: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetViewWindow: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub GetBaseBrowserData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbbd: *mut *mut BASEBROWSERDATALH) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    GetBaseBrowserData: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub PutBaseBrowserData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> *mut BASEBROWSERDATALH,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    PutBaseBrowserData: usize,
    pub InitializeTravelLog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptl: *mut ::core::ffi::c_void, dw: u32) -> ::windows::core::HRESULT,
    pub SetTopBrowser: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Offline: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, icmd: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub AllowViewResize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, f: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AllowViewResize: usize,
    pub SetActivateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, u: u32) -> ::windows::core::HRESULT,
    pub UpdateSecureLockIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, esecurelock: i32) -> ::windows::core::HRESULT,
    pub InitializeDownloadManager: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub InitializeTransitionSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pauto: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _Initialize: usize,
    pub _CancelPendingNavigationAsync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _CancelPendingView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _MaySaveChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _PauseOrResumeView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpaused: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _PauseOrResumeView: usize,
    pub _DisableModeless: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub _NavigateToPidl2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    _NavigateToPidl2: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub _TryShell2Rename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    _TryShell2Rename: usize,
    pub _SwitchActivationNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub _ExecChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkbar: *mut ::core::ffi::c_void, fbroadcast: super::super::Foundation::BOOL, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    _ExecChildren: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _SendChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndbar: super::super::Foundation::HWND, fbroadcast: super::super::Foundation::BOOL, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _SendChildren: usize,
    pub GetFolderSetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfsd: *mut FOLDERSETDATA) -> ::windows::core::HRESULT,
    pub _OnFocusChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub v_ShowHideChildWindows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fchildonly: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    v_ShowHideChildWindows: usize,
    pub _get_itbLastFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub _put_itbLastFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itblastfocus: u32) -> ::windows::core::HRESULT,
    pub _UIActivateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ustate: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _GetViewBorderRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _GetViewBorderRect: usize,
    pub _UpdateViewRectSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _ResizeNextBorder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32) -> ::windows::core::HRESULT,
    pub _ResizeView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub _GetEffectiveClientArea: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, hmon: super::super::Graphics::Gdi::HMONITOR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    _GetEffectiveClientArea: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub v_GetViewStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: ::windows::core::PCWSTR) -> ::core::option::Option<super::super::System::Com::IStream>,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common")))]
    v_GetViewStream: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ForwardViewMsg: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ForwardViewMsg: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetAcceleratorMenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hacc: super::WindowsAndMessaging::HACCEL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetAcceleratorMenu: usize,
    pub _GetToolbarCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub _GetToolbarItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: i32) -> *mut TOOLBARITEM,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole")))]
    _GetToolbarItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _SaveToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _SaveToolbars: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _LoadToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _LoadToolbars: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _CloseAndReleaseToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fclose: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _CloseAndReleaseToolbars: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayGetNextToolbarFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayGetNextToolbarFocus: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _ResizeNextBorderHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32, busehmonitor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _ResizeNextBorderHelper: usize,
    pub _FindTBar: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksrc: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub _SetFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptbi: *const TOOLBARITEM, hwnd: super::super::Foundation::HWND, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    _SetFocus: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayTranslateAccelerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayTranslateAccelerator: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _GetBorderDWHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksrc: *mut ::core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _GetBorderDWHelper: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub v_CheckZoneCrossing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    v_CheckZoneCrossing: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService3(::windows::core::IUnknown);
impl IBrowserService3 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetParentSite)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.GetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszname)), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetOleObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetTravelLog)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.ShowControlWindow)(::windows::core::Interface::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.IsControlWindowShown)(::windows::core::Interface::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.IEGetDisplayName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.IEParseDisplayName)(::windows::core::Interface::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.DisplayParseError)(::windows::core::Interface::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.NavigateToPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetNavigateState)(::windows::core::Interface::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetNavigateState)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.NotifyRedirect)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.UpdateWindowList)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.UpdateBackForwardState)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetFlags)(::windows::core::Interface::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.CanNavigateNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetReferrer)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Interface::vtable(self).base__.base__.GetBrowserIndex)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetBrowserByIndex)(::windows::core::Interface::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.GetHistoryObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetHistoryObject)(::windows::core::Interface::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.CacheOLEServer)(::windows::core::Interface::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetSetCodePage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.OnHttpEquiv)(::windows::core::Interface::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetPalette)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.RegisterWindow)(::windows::core::Interface::as_raw(self), fforceregister.into(), swc).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.WndProcBS)(::windows::core::Interface::as_raw(self), hwnd.into(), umsg, wparam.into(), lparam.into())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetAsDefFolderSettings)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetViewRect)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, P0>(&self, wparam: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.OnSize)(::windows::core::Interface::as_raw(self), wparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.OnCreate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.OnCommand)(::windows::core::Interface::as_raw(self), wparam.into(), lparam.into())
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.OnDestroy)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (::windows::core::Interface::vtable(self).base__.OnNotify)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pnm))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.OnSetFocus)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, P0>(&self, factive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.OnFrameWindowActivateBS)(::windows::core::Interface::as_raw(self), factive.into()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ReleaseShellView)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ActivatePendingView)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.CreateViewWindow)(::windows::core::Interface::as_raw(self), psvnew.into().abi(), psvold.into().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CreateBrowserPropSheetExt)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetViewWindow)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetBaseBrowserData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (::windows::core::Interface::vtable(self).base__.PutBaseBrowserData)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<'a, P0>(&self, ptl: P0, dw: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ITravelLog>>,
    {
        (::windows::core::Interface::vtable(self).base__.InitializeTravelLog)(::windows::core::Interface::as_raw(self), ptl.into().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetTopBrowser)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Offline)(::windows::core::Interface::as_raw(self), icmd).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, P0>(&self, f: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.AllowViewResize)(::windows::core::Interface::as_raw(self), f.into()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetActivateState)(::windows::core::Interface::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UpdateSecureLockIcon)(::windows::core::Interface::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.InitializeDownloadManager)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.InitializeTransitionSite)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, P0, P1>(&self, hwnd: P0, pauto: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).base__._Initialize)(::windows::core::Interface::as_raw(self), hwnd.into(), pauto.into().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._CancelPendingNavigationAsync)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._CancelPendingView)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._MaySaveChanges)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, P0>(&self, fpaused: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__._PauseOrResumeView)(::windows::core::Interface::as_raw(self), fpaused.into()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._DisableModeless)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._NavigateToPidl2)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__._TryShell2Rename)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._SwitchActivationNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__._ExecChildren)(::windows::core::Interface::as_raw(self), punkbar.into().abi(), fbroadcast.into(), ::core::mem::transmute(pguidcmdgroup), ncmdid, ncmdexecopt, ::core::mem::transmute(pvarargin), ::core::mem::transmute(pvarargout)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P3: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__._SendChildren)(::windows::core::Interface::as_raw(self), hwndbar.into(), fbroadcast.into(), umsg, wparam.into(), lparam.into()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetFolderSetData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pfsd)).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._OnFocusChange)(::windows::core::Interface::as_raw(self), itb).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, P0>(&self, fchildonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.v_ShowHideChildWindows)(::windows::core::Interface::as_raw(self), fchildonly.into()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (::windows::core::Interface::vtable(self).base__._get_itbLastFocus)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._put_itbLastFocus)(::windows::core::Interface::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._UIActivateView)(::windows::core::Interface::as_raw(self), ustate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._GetViewBorderRect)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._UpdateViewRectSize)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._ResizeNextBorder)(::windows::core::Interface::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__._ResizeView)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Interface::vtable(self).base__._GetEffectiveClientArea)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(lprectborder), hmon.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> ::core::option::Option<super::super::System::Com::IStream>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.v_GetViewStream)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfmode, pwszname.into())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.ForwardViewMsg)(::windows::core::Interface::as_raw(self), umsg, wparam.into(), lparam.into())
    }
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, P0>(&self, hacc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HACCEL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetAcceleratorMenu)(::windows::core::Interface::as_raw(self), hacc.into()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (::windows::core::Interface::vtable(self).base__._GetToolbarCount)(::windows::core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (::windows::core::Interface::vtable(self).base__._GetToolbarItem)(::windows::core::Interface::as_raw(self), itb)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Interface::vtable(self).base__._SaveToolbars)(::windows::core::Interface::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Interface::vtable(self).base__._LoadToolbars)(::windows::core::Interface::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, P0>(&self, fclose: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__._CloseAndReleaseToolbars)(::windows::core::Interface::as_raw(self), fclose.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.v_MayGetNextToolbarFocus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(lpmsg), itbnext, citb, ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, P0>(&self, itb: u32, busehmonitor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__._ResizeNextBorderHelper)(::windows::core::Interface::as_raw(self), itb, busehmonitor.into()).ok()
    }
    pub unsafe fn _FindTBar<'a, P0>(&self, punksrc: P0) -> u32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).base__._FindTBar)(::windows::core::Interface::as_raw(self), punksrc.into().abi())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).base__._SetFocus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ptbi), hwnd.into(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.v_MayTranslateAccelerator)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__._GetBorderDWHelper)(::windows::core::Interface::as_raw(self), punksrc.into().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.v_CheckZoneCrossing)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<'a, P0>(&self, hwnd: P0, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self)._PositionViewWindow)(::windows::core::Interface::as_raw(self), hwnd.into(), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayNameEx<'a, P0>(&self, uicp: u32, pwszpath: P0, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).IEParseDisplayNameEx)(::windows::core::Interface::as_raw(self), uicp, pwszpath.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
}
impl ::core::convert::From<IBrowserService3> for ::windows::core::IUnknown {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService3> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IBrowserService3> for IBrowserService {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService3> for &'a IBrowserService {
    fn from(value: &'a IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService3> for IBrowserService {
    fn from(value: &IBrowserService3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IBrowserService3> for IBrowserService2 {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService3> for &'a IBrowserService2 {
    fn from(value: &'a IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService3> for IBrowserService2 {
    fn from(value: &IBrowserService3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBrowserService3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService3 {}
impl ::core::fmt::Debug for IBrowserService3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService3 {
    type Vtable = IBrowserService3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x27d7ce21_762d_48f3_86f3_40e2fd3749c4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService3_Vtbl {
    pub base__: IBrowserService2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub _PositionViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, prc: *const super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _PositionViewWindow: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayNameEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicp: u32, pwszpath: ::windows::core::PCWSTR, dwflags: u32, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayNameEx: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService4(::windows::core::IUnknown);
impl IBrowserService4 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetParentSite)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetTitle)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszname)), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetOleObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetTravelLog)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.ShowControlWindow)(::windows::core::Interface::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.IsControlWindowShown)(::windows::core::Interface::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.IEGetDisplayName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.IEParseDisplayName)(::windows::core::Interface::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.DisplayParseError)(::windows::core::Interface::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.NavigateToPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetNavigateState)(::windows::core::Interface::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetNavigateState)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.NotifyRedirect)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.UpdateWindowList)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.UpdateBackForwardState)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetFlags)(::windows::core::Interface::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.CanNavigateNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetPidl)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetReferrer)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetBrowserIndex)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetBrowserByIndex)(::windows::core::Interface::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetHistoryObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetHistoryObject)(::windows::core::Interface::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.CacheOLEServer)(::windows::core::Interface::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetSetCodePage)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.OnHttpEquiv)(::windows::core::Interface::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.base__.GetPalette)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.base__.RegisterWindow)(::windows::core::Interface::as_raw(self), fforceregister.into(), swc).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.WndProcBS)(::windows::core::Interface::as_raw(self), hwnd.into(), umsg, wparam.into(), lparam.into())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetAsDefFolderSettings)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetViewRect)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, P0>(&self, wparam: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.OnSize)(::windows::core::Interface::as_raw(self), wparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.OnCreate)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.OnCommand)(::windows::core::Interface::as_raw(self), wparam.into(), lparam.into())
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.OnDestroy)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (::windows::core::Interface::vtable(self).base__.base__.OnNotify)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pnm))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.OnSetFocus)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, P0>(&self, factive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.OnFrameWindowActivateBS)(::windows::core::Interface::as_raw(self), factive.into()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.ReleaseShellView)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.ActivatePendingView)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.CreateViewWindow)(::windows::core::Interface::as_raw(self), psvnew.into().abi(), psvold.into().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.CreateBrowserPropSheetExt)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetViewWindow)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.base__.GetBaseBrowserData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (::windows::core::Interface::vtable(self).base__.base__.PutBaseBrowserData)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<'a, P0>(&self, ptl: P0, dw: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ITravelLog>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.InitializeTravelLog)(::windows::core::Interface::as_raw(self), ptl.into().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetTopBrowser)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.Offline)(::windows::core::Interface::as_raw(self), icmd).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, P0>(&self, f: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.AllowViewResize)(::windows::core::Interface::as_raw(self), f.into()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetActivateState)(::windows::core::Interface::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.UpdateSecureLockIcon)(::windows::core::Interface::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.InitializeDownloadManager)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.InitializeTransitionSite)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, P0, P1>(&self, hwnd: P0, pauto: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._Initialize)(::windows::core::Interface::as_raw(self), hwnd.into(), pauto.into().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._CancelPendingNavigationAsync)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._CancelPendingView)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._MaySaveChanges)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, P0>(&self, fpaused: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._PauseOrResumeView)(::windows::core::Interface::as_raw(self), fpaused.into()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._DisableModeless)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._NavigateToPidl2)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfhlnf, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._TryShell2Rename)(::windows::core::Interface::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._SwitchActivationNow)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._ExecChildren)(::windows::core::Interface::as_raw(self), punkbar.into().abi(), fbroadcast.into(), ::core::mem::transmute(pguidcmdgroup), ncmdid, ncmdexecopt, ::core::mem::transmute(pvarargin), ::core::mem::transmute(pvarargout)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P3: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._SendChildren)(::windows::core::Interface::as_raw(self), hwndbar.into(), fbroadcast.into(), umsg, wparam.into(), lparam.into()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.GetFolderSetData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pfsd)).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._OnFocusChange)(::windows::core::Interface::as_raw(self), itb).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, P0>(&self, fchildonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.v_ShowHideChildWindows)(::windows::core::Interface::as_raw(self), fchildonly.into()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (::windows::core::Interface::vtable(self).base__.base__._get_itbLastFocus)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._put_itbLastFocus)(::windows::core::Interface::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._UIActivateView)(::windows::core::Interface::as_raw(self), ustate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._GetViewBorderRect)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._UpdateViewRectSize)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._ResizeNextBorder)(::windows::core::Interface::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__._ResizeView)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._GetEffectiveClientArea)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(lprectborder), hmon.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> ::core::option::Option<super::super::System::Com::IStream>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.v_GetViewStream)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl), grfmode, pwszname.into())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.ForwardViewMsg)(::windows::core::Interface::as_raw(self), umsg, wparam.into(), lparam.into())
    }
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, P0>(&self, hacc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HACCEL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetAcceleratorMenu)(::windows::core::Interface::as_raw(self), hacc.into()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (::windows::core::Interface::vtable(self).base__.base__._GetToolbarCount)(::windows::core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (::windows::core::Interface::vtable(self).base__.base__._GetToolbarItem)(::windows::core::Interface::as_raw(self), itb)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._SaveToolbars)(::windows::core::Interface::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._LoadToolbars)(::windows::core::Interface::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, P0>(&self, fclose: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._CloseAndReleaseToolbars)(::windows::core::Interface::as_raw(self), fclose.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.v_MayGetNextToolbarFocus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(lpmsg), itbnext, citb, ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, P0>(&self, itb: u32, busehmonitor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._ResizeNextBorderHelper)(::windows::core::Interface::as_raw(self), itb, busehmonitor.into()).ok()
    }
    pub unsafe fn _FindTBar<'a, P0>(&self, punksrc: P0) -> u32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._FindTBar)(::windows::core::Interface::as_raw(self), punksrc.into().abi())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._SetFocus)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(ptbi), hwnd.into(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.v_MayTranslateAccelerator)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.base__._GetBorderDWHelper)(::windows::core::Interface::as_raw(self), punksrc.into().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.v_CheckZoneCrossing)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<'a, P0>(&self, hwnd: P0, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).base__._PositionViewWindow)(::windows::core::Interface::as_raw(self), hwnd.into(), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayNameEx<'a, P0>(&self, uicp: u32, pwszpath: P0, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.IEParseDisplayNameEx)(::windows::core::Interface::as_raw(self), uicp, pwszpath.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateView<'a, P0>(&self, fpendingview: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).ActivateView)(::windows::core::Interface::as_raw(self), fpendingview.into()).ok()
    }
    pub unsafe fn SaveViewState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SaveViewState)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeAllBorders(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeAllBorders)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IBrowserService4> for ::windows::core::IUnknown {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService4> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IBrowserService4> for IBrowserService {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService4> for &'a IBrowserService {
    fn from(value: &'a IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for IBrowserService {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IBrowserService4> for IBrowserService2 {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService4> for &'a IBrowserService2 {
    fn from(value: &'a IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for IBrowserService2 {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IBrowserService4> for IBrowserService3 {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IBrowserService4> for &'a IBrowserService3 {
    fn from(value: &'a IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for IBrowserService3 {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IBrowserService4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService4 {}
impl ::core::fmt::Debug for IBrowserService4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService4 {
    type Vtable = IBrowserService4_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x639f1bff_e135_4096_abd8_e0f504d649a4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService4_Vtbl {
    pub base__: IBrowserService3_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpendingview: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateView: usize,
    pub SaveViewState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _ResizeAllBorders: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICDBurn(::windows::core::IUnknown);
impl ICDBurn {
    pub unsafe fn GetRecorderDriveLetter(&self, pszdrive: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRecorderDriveLetter)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszdrive)), pszdrive.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Burn<'a, P0>(&self, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Interface::vtable(self).Burn)(::windows::core::Interface::as_raw(self), hwnd.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasRecordableDrive(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).HasRecordableDrive)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
impl ::core::convert::From<ICDBurn> for ::windows::core::IUnknown {
    fn from(value: ICDBurn) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICDBurn> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICDBurn) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICDBurn> for ::windows::core::IUnknown {
    fn from(value: &ICDBurn) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICDBurn {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICDBurn {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICDBurn {}
impl ::core::fmt::Debug for ICDBurn {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICDBurn").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICDBurn {
    type Vtable = ICDBurn_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d73a659_e5d0_4d42_afc0_5121ba425c8d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurn_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetRecorderDriveLetter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdrive: ::windows::core::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Burn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Burn: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub HasRecordableDrive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfhasrecorder: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HasRecordableDrive: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICDBurnExt(::windows::core::IUnknown);
impl ICDBurnExt {
    pub unsafe fn GetSupportedActionTypes(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetSupportedActionTypes)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<ICDBurnExt> for ::windows::core::IUnknown {
    fn from(value: ICDBurnExt) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICDBurnExt> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICDBurnExt) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICDBurnExt> for ::windows::core::IUnknown {
    fn from(value: &ICDBurnExt) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICDBurnExt {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICDBurnExt {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICDBurnExt {}
impl ::core::fmt::Debug for ICDBurnExt {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICDBurnExt").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICDBurnExt {
    type Vtable = ICDBurnExt_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2271dcca_74fc_4414_8fb7_c56b05ace2d7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurnExt_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetSupportedActionTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwactions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICategorizer(::windows::core::IUnknown);
impl ICategorizer {
    pub unsafe fn GetDescription(&self, pszdesc: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszdesc)), pszdesc.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetCategory(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCategory)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(cidl), ::core::mem::transmute(apidl), ::core::mem::transmute(rgcategoryids)).ok()
    }
    pub unsafe fn GetCategoryInfo(&self, dwcategoryid: u32) -> ::windows::core::Result<CATEGORY_INFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCategoryInfo)(::windows::core::Interface::as_raw(self), dwcategoryid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CATEGORY_INFO>(result__)
    }
    pub unsafe fn CompareCategory(&self, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CompareCategory)(::windows::core::Interface::as_raw(self), csfflags, dwcategoryid1, dwcategoryid2).ok()
    }
}
impl ::core::convert::From<ICategorizer> for ::windows::core::IUnknown {
    fn from(value: ICategorizer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICategorizer> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICategorizer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICategorizer> for ::windows::core::IUnknown {
    fn from(value: &ICategorizer) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICategorizer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICategorizer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICategorizer {}
impl ::core::fmt::Debug for ICategorizer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICategorizer").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICategorizer {
    type Vtable = ICategorizer_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3b14589_9174_49a8_89a3_06a1ae2b9ba7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategorizer_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdesc: ::windows::core::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetCategory: usize,
    pub GetCategoryInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> ::windows::core::HRESULT,
    pub CompareCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICategoryProvider(::windows::core::IUnknown);
impl ICategoryProvider {
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn CanCategorizeOnSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CanCategorizeOnSCID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pscid)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetDefaultCategory(&self, pguid: *mut ::windows::core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDefaultCategory)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pscid)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetCategoryForSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCategoryForSCID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pscid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategories(&self) -> ::windows::core::Result<super::super::System::Com::IEnumGUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).EnumCategories)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IEnumGUID>(result__)
    }
    pub unsafe fn GetCategoryName(&self, pguid: *const ::windows::core::GUID, pszname: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCategoryName)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pguid), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszname)), pszname.len() as _).ok()
    }
    pub unsafe fn CreateCategory<T>(&self, pguid: *const ::windows::core::GUID) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateCategory)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pguid), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
impl ::core::convert::From<ICategoryProvider> for ::windows::core::IUnknown {
    fn from(value: ICategoryProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICategoryProvider> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICategoryProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICategoryProvider> for ::windows::core::IUnknown {
    fn from(value: &ICategoryProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICategoryProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICategoryProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICategoryProvider {}
impl ::core::fmt::Debug for ICategoryProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICategoryProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICategoryProvider {
    type Vtable = ICategoryProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9af64809_5864_4c26_a720_c1f78c086ee3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategoryProvider_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub CanCategorizeOnSCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    CanCategorizeOnSCID: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetDefaultCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *mut ::windows::core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetDefaultCategory: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetCategoryForSCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY, pguid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetCategoryForSCID: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumCategories: usize,
    pub GetCategoryName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pszname: ::windows::core::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    pub CreateCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IColumnManager(::windows::core::IUnknown);
impl IColumnManager {
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetColumnInfo)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(propkey), ::core::mem::transmute(pcmci)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumnInfo)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(propkey), ::core::mem::transmute(pcmci)).ok()
    }
    pub unsafe fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetColumnCount)(::windows::core::Interface::as_raw(self), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumns(&self, dwflags: CM_ENUM_FLAGS, rgkeyorder: &mut [PropertiesSystem::PROPERTYKEY]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumns)(::windows::core::Interface::as_raw(self), dwflags, ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(rgkeyorder)), rgkeyorder.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumns(&self, rgkeyorder: &[PropertiesSystem::PROPERTYKEY]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetColumns)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(::windows::core::as_ptr_or_null(rgkeyorder)), rgkeyorder.len() as _).ok()
    }
}
impl ::core::convert::From<IColumnManager> for ::windows::core::IUnknown {
    fn from(value: IColumnManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IColumnManager> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IColumnManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnManager> for ::windows::core::IUnknown {
    fn from(value: &IColumnManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IColumnManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnManager {}
impl ::core::fmt::Debug for IColumnManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnManager {
    type Vtable = IColumnManager_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd8ec27bb_3f3b_4042_b10a_4acfd924d453);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnManager_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumnInfo: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumnInfo: usize,
    pub GetColumnCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: CM_ENUM_FLAGS, pucount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: CM_ENUM_FLAGS, rgkeyorder: *mut PropertiesSystem::PROPERTYKEY, ccolumns: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumns: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rgkeyorder: *const PropertiesSystem::PROPERTYKEY, cvisible: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumns: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IColumnProvider(::windows::core::IUnknown);
impl IColumnProvider {
    pub unsafe fn Initialize(&self, psci: *const SHCOLUMNINIT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(psci)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, dwindex: u32) -> ::windows::core::Result<SHCOLUMNINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetColumnInfo)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SHCOLUMNINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetItemData(&self, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetItemData)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pscid), ::core::mem::transmute(pscd), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
impl ::core::convert::From<IColumnProvider> for ::windows::core::IUnknown {
    fn from(value: IColumnProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IColumnProvider> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IColumnProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnProvider> for ::windows::core::IUnknown {
    fn from(value: &IColumnProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IColumnProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnProvider {}
impl ::core::fmt::Debug for IColumnProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnProvider {
    type Vtable = IColumnProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8025004_1c42_11d2_be2c_00a0c9a83da1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnProvider_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psci: *const SHCOLUMNINIT) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, psci: *mut SHCOLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumnInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetItemData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA, pvardata: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetItemData: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICommDlgBrowser(::windows::core::IUnknown);
impl ICommDlgBrowser {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).OnDefaultCommand)(::windows::core::Interface::as_raw(self), ppshv.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, P0>(&self, ppshv: P0, uchange: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).OnStateChange)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), uchange).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).IncludeObject)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(pidl)).ok()
    }
}
impl ::core::convert::From<ICommDlgBrowser> for ::windows::core::IUnknown {
    fn from(value: ICommDlgBrowser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICommDlgBrowser> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICommDlgBrowser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser> for ::windows::core::IUnknown {
    fn from(value: &ICommDlgBrowser) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICommDlgBrowser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser {}
impl ::core::fmt::Debug for ICommDlgBrowser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser {
    type Vtable = ICommDlgBrowser_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214f1_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnDefaultCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnDefaultCommand: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnStateChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, uchange: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnStateChange: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub IncludeObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    IncludeObject: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICommDlgBrowser2(::windows::core::IUnknown);
impl ICommDlgBrowser2 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.OnDefaultCommand)(::windows::core::Interface::as_raw(self), ppshv.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, P0>(&self, ppshv: P0, uchange: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.OnStateChange)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), uchange).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.IncludeObject)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<'a, P0>(&self, ppshv: P0, dwnotifytype: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).Notify)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), dwnotifytype).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetDefaultMenuText<'a, P0>(&self, ppshv: P0, psztext: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).GetDefaultMenuText)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(psztext)), psztext.len() as _).ok()
    }
    pub unsafe fn GetViewFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetViewFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<ICommDlgBrowser2> for ::windows::core::IUnknown {
    fn from(value: ICommDlgBrowser2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICommDlgBrowser2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICommDlgBrowser2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser2> for ::windows::core::IUnknown {
    fn from(value: &ICommDlgBrowser2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICommDlgBrowser2> for ICommDlgBrowser {
    fn from(value: ICommDlgBrowser2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICommDlgBrowser2> for &'a ICommDlgBrowser {
    fn from(value: &'a ICommDlgBrowser2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser2> for ICommDlgBrowser {
    fn from(value: &ICommDlgBrowser2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICommDlgBrowser2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser2 {}
impl ::core::fmt::Debug for ICommDlgBrowser2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser2 {
    type Vtable = ICommDlgBrowser2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x10339516_2894_11d2_9039_00c04f8eeb3e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser2_Vtbl {
    pub base__: ICommDlgBrowser_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, dwnotifytype: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    Notify: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetDefaultMenuText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, psztext: ::windows::core::PWSTR, cchmax: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetDefaultMenuText: usize,
    pub GetViewFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICommDlgBrowser3(::windows::core::IUnknown);
impl ICommDlgBrowser3 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.OnDefaultCommand)(::windows::core::Interface::as_raw(self), ppshv.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, P0>(&self, ppshv: P0, uchange: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.OnStateChange)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), uchange).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.IncludeObject)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<'a, P0>(&self, ppshv: P0, dwnotifytype: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.Notify)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), dwnotifytype).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetDefaultMenuText<'a, P0>(&self, ppshv: P0, psztext: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).base__.GetDefaultMenuText)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(psztext)), psztext.len() as _).ok()
    }
    pub unsafe fn GetViewFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetViewFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnColumnClicked<'a, P0>(&self, ppshv: P0, icolumn: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).OnColumnClicked)(::windows::core::Interface::as_raw(self), ppshv.into().abi(), icolumn).ok()
    }
    pub unsafe fn GetCurrentFilter(&self, pszfilespec: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCurrentFilter)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pszfilespec)), pszfilespec.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnPreViewCreated<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Interface::vtable(self).OnPreViewCreated)(::windows::core::Interface::as_raw(self), ppshv.into().abi()).ok()
    }
}
impl ::core::convert::From<ICommDlgBrowser3> for ::windows::core::IUnknown {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICommDlgBrowser3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser3> for ::windows::core::IUnknown {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICommDlgBrowser3> for ICommDlgBrowser {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICommDlgBrowser3> for &'a ICommDlgBrowser {
    fn from(value: &'a ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser3> for ICommDlgBrowser {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICommDlgBrowser3> for ICommDlgBrowser2 {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICommDlgBrowser3> for &'a ICommDlgBrowser2 {
    fn from(value: &'a ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser3> for ICommDlgBrowser2 {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICommDlgBrowser3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser3 {}
impl ::core::fmt::Debug for ICommDlgBrowser3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser3 {
    type Vtable = ICommDlgBrowser3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8ad25a1_3294_41ee_8165_71174bd01c57);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser3_Vtbl {
    pub base__: ICommDlgBrowser2_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnColumnClicked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, icolumn: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnColumnClicked: usize,
    pub GetCurrentFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilespec: ::windows::core::PWSTR, cchfilespec: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnPreViewCreated: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnPreViewCreated: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IComputerInfoChangeNotify(::windows::core::IUnknown);
impl IComputerInfoChangeNotify {
    pub unsafe fn ComputerInfoChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ComputerInfoChanged)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IComputerInfoChangeNotify> for ::windows::core::IUnknown {
    fn from(value: IComputerInfoChangeNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IComputerInfoChangeNotify> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IComputerInfoChangeNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IComputerInfoChangeNotify> for ::windows::core::IUnknown {
    fn from(value: &IComputerInfoChangeNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IComputerInfoChangeNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IComputerInfoChangeNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IComputerInfoChangeNotify {}
impl ::core::fmt::Debug for IComputerInfoChangeNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IComputerInfoChangeNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IComputerInfoChangeNotify {
    type Vtable = IComputerInfoChangeNotify_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0df60d92_6818_46d6_b358_d66170dde466);
}
#[repr(C)]
#[doc(hidden)]
pub struct IComputerInfoChangeNotify_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub ComputerInfoChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IConnectableCredentialProviderCredential(::windows::core::IUnknown);
impl IConnectableCredentialProviderCredential {
    pub unsafe fn Advise<'a, P0>(&self, pcpce: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredentialEvents>>,
    {
        (::windows::core::Interface::vtable(self).base__.Advise)(::windows::core::Interface::as_raw(self), pcpce.into().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UnAdvise)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.SetSelected)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetDeselected)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetFieldState)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetStringValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetBitmapValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCheckboxValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetSubmitButtonValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetComboBoxValueCount)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetComboBoxValueAt)(::windows::core::Interface::as_raw(self), dwfieldid, dwitem, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetStringValue<'a, P0>(&self, dwfieldid: u32, psz: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetStringValue)(::windows::core::Interface::as_raw(self), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, P0>(&self, dwfieldid: u32, bchecked: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCheckboxValue)(::windows::core::Interface::as_raw(self), dwfieldid, bchecked.into()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetComboBoxSelectedValue)(::windows::core::Interface::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CommandLinkClicked)(::windows::core::Interface::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetSerialization)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
        P1: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
    {
        (::windows::core::Interface::vtable(self).base__.ReportResult)(::windows::core::Interface::as_raw(self), ntsstatus.into(), ntssubstatus.into(), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    pub unsafe fn Connect<'a, P0>(&self, pqcws: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IQueryContinueWithStatus>>,
    {
        (::windows::core::Interface::vtable(self).Connect)(::windows::core::Interface::as_raw(self), pqcws.into().abi()).ok()
    }
    pub unsafe fn Disconnect(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Disconnect)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<IConnectableCredentialProviderCredential> for ::windows::core::IUnknown {
    fn from(value: IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IConnectableCredentialProviderCredential> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConnectableCredentialProviderCredential> for ::windows::core::IUnknown {
    fn from(value: &IConnectableCredentialProviderCredential) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IConnectableCredentialProviderCredential> for ICredentialProviderCredential {
    fn from(value: IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IConnectableCredentialProviderCredential> for &'a ICredentialProviderCredential {
    fn from(value: &'a IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConnectableCredentialProviderCredential> for ICredentialProviderCredential {
    fn from(value: &IConnectableCredentialProviderCredential) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IConnectableCredentialProviderCredential {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConnectableCredentialProviderCredential {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConnectableCredentialProviderCredential {}
impl ::core::fmt::Debug for IConnectableCredentialProviderCredential {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConnectableCredentialProviderCredential").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IConnectableCredentialProviderCredential {
    type Vtable = IConnectableCredentialProviderCredential_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9387928b_ac75_4bf9_8ab2_2b93c4a55290);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConnectableCredentialProviderCredential_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub Connect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pqcws: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Disconnect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContactManagerInterop(::windows::core::IUnknown);
impl IContactManagerInterop {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowContactCardForWindow<'a, P0, P1>(&self, appwindow: P0, contact: P1, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).ShowContactCardForWindow)(::windows::core::Interface::as_raw(self), appwindow.into(), contact.into().abi(), ::core::mem::transmute(selection), preferredplacement).ok()
    }
}
impl ::core::convert::From<IContactManagerInterop> for ::windows::core::IUnknown {
    fn from(value: IContactManagerInterop) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContactManagerInterop> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IContactManagerInterop) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContactManagerInterop> for ::windows::core::IUnknown {
    fn from(value: &IContactManagerInterop) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IContactManagerInterop {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContactManagerInterop {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContactManagerInterop {}
impl ::core::fmt::Debug for IContactManagerInterop {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContactManagerInterop").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IContactManagerInterop {
    type Vtable = IContactManagerInterop_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x99eacba7_e073_43b6_a896_55afe48a0833);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContactManagerInterop_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowContactCardForWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appwindow: super::super::Foundation::HWND, contact: *mut ::core::ffi::c_void, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowContactCardForWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenu(::windows::core::IUnknown);
impl IContextMenu {
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<'a, P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    {
        (::windows::core::Interface::vtable(self).QueryContextMenu)(::windows::core::Interface::as_raw(self), hmenu.into(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InvokeCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pici)).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: *mut u32, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommandString)(::windows::core::Interface::as_raw(self), idcmd, utype, ::core::mem::transmute(preserved), ::core::mem::transmute(pszname), cchmax).ok()
    }
}
impl ::core::convert::From<IContextMenu> for ::windows::core::IUnknown {
    fn from(value: IContextMenu) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenu> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IContextMenu) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenu> for ::windows::core::IUnknown {
    fn from(value: &IContextMenu) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IContextMenu {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenu {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenu {}
impl ::core::fmt::Debug for IContextMenu {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenu").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IContextMenu {
    type Vtable = IContextMenu_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214e4_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub QueryContextMenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmenu: super::WindowsAndMessaging::HMENU, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    QueryContextMenu: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InvokeCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InvokeCommand: usize,
    pub GetCommandString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idcmd: usize, utype: u32, preserved: *mut u32, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenu2(::windows::core::IUnknown);
impl IContextMenu2 {
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<'a, P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    {
        (::windows::core::Interface::vtable(self).base__.QueryContextMenu)(::windows::core::Interface::as_raw(self), hmenu.into(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.InvokeCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pici)).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: *mut u32, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCommandString)(::windows::core::Interface::as_raw(self), idcmd, utype, ::core::mem::transmute(preserved), ::core::mem::transmute(pszname), cchmax).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleMenuMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).HandleMenuMsg)(::windows::core::Interface::as_raw(self), umsg, wparam.into(), lparam.into()).ok()
    }
}
impl ::core::convert::From<IContextMenu2> for ::windows::core::IUnknown {
    fn from(value: IContextMenu2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenu2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IContextMenu2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenu2> for ::windows::core::IUnknown {
    fn from(value: &IContextMenu2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IContextMenu2> for IContextMenu {
    fn from(value: IContextMenu2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenu2> for &'a IContextMenu {
    fn from(value: &'a IContextMenu2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenu2> for IContextMenu {
    fn from(value: &IContextMenu2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IContextMenu2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenu2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenu2 {}
impl ::core::fmt::Debug for IContextMenu2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenu2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IContextMenu2 {
    type Vtable = IContextMenu2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214f4_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu2_Vtbl {
    pub base__: IContextMenu_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub HandleMenuMsg: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HandleMenuMsg: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenu3(::windows::core::IUnknown);
impl IContextMenu3 {
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<'a, P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.QueryContextMenu)(::windows::core::Interface::as_raw(self), hmenu.into(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.InvokeCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pici)).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: *mut u32, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.GetCommandString)(::windows::core::Interface::as_raw(self), idcmd, utype, ::core::mem::transmute(preserved), ::core::mem::transmute(pszname), cchmax).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleMenuMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).base__.HandleMenuMsg)(::windows::core::Interface::as_raw(self), umsg, wparam.into(), lparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleMenuMsg2<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> ::windows::core::Result<super::super::Foundation::LRESULT>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).HandleMenuMsg2)(::windows::core::Interface::as_raw(self), umsg, wparam.into(), lparam.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::LRESULT>(result__)
    }
}
impl ::core::convert::From<IContextMenu3> for ::windows::core::IUnknown {
    fn from(value: IContextMenu3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenu3> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IContextMenu3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenu3> for ::windows::core::IUnknown {
    fn from(value: &IContextMenu3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IContextMenu3> for IContextMenu {
    fn from(value: IContextMenu3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenu3> for &'a IContextMenu {
    fn from(value: &'a IContextMenu3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenu3> for IContextMenu {
    fn from(value: &IContextMenu3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<IContextMenu3> for IContextMenu2 {
    fn from(value: IContextMenu3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenu3> for &'a IContextMenu2 {
    fn from(value: &'a IContextMenu3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenu3> for IContextMenu2 {
    fn from(value: &IContextMenu3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IContextMenu3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenu3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenu3 {}
impl ::core::fmt::Debug for IContextMenu3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenu3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IContextMenu3 {
    type Vtable = IContextMenu3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcfce0a0_ec17_11d0_8d10_00a0c90f2719);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu3_Vtbl {
    pub base__: IContextMenu2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub HandleMenuMsg2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM, plresult: *mut super::super::Foundation::LRESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HandleMenuMsg2: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenuCB(::windows::core::IUnknown);
impl IContextMenuCB {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CallBack<'a, P0, P1, P2, P3, P4>(&self, psf: P0, hwndowner: P1, pdtobj: P2, umsg: u32, wparam: P3, lparam: P4) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
        P3: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P4: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Interface::vtable(self).CallBack)(::windows::core::Interface::as_raw(self), psf.into().abi(), hwndowner.into(), pdtobj.into().abi(), umsg, wparam.into(), lparam.into()).ok()
    }
}
impl ::core::convert::From<IContextMenuCB> for ::windows::core::IUnknown {
    fn from(value: IContextMenuCB) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenuCB> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IContextMenuCB) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenuCB> for ::windows::core::IUnknown {
    fn from(value: &IContextMenuCB) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IContextMenuCB {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenuCB {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenuCB {}
impl ::core::fmt::Debug for IContextMenuCB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenuCB").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IContextMenuCB {
    type Vtable = IContextMenuCB_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3409e930_5a39_11d1_83fa_00a0c90dc849);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenuCB_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CallBack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psf: *mut ::core::ffi::c_void, hwndowner: super::super::Foundation::HWND, pdtobj: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CallBack: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenuSite(::windows::core::IUnknown);
impl IContextMenuSite {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DoContextMenuPopup<'a, P0>(&self, punkcontextmenu: P0, fflags: u32, pt: super::super::Foundation::POINT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Interface::vtable(self).DoContextMenuPopup)(::windows::core::Interface::as_raw(self), punkcontextmenu.into().abi(), fflags, ::core::mem::transmute(pt)).ok()
    }
}
impl ::core::convert::From<IContextMenuSite> for ::windows::core::IUnknown {
    fn from(value: IContextMenuSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IContextMenuSite> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IContextMenuSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IContextMenuSite> for ::windows::core::IUnknown {
    fn from(value: &IContextMenuSite) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IContextMenuSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenuSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenuSite {}
impl ::core::fmt::Debug for IContextMenuSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenuSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IContextMenuSite {
    type Vtable = IContextMenuSite_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0811aebe_0b87_4c54_9e72_548cf649016b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenuSite_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DoContextMenuPopup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkcontextmenu: *mut ::core::ffi::c_void, fflags: u32, pt: super::super::Foundation::POINT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DoContextMenuPopup: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICopyHookA(::windows::core::IUnknown);
impl ICopyHookA {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CopyCallback<'a, P0, P1, P2>(&self, hwnd: P0, wfunc: u32, wflags: u32, pszsrcfile: P1, dwsrcattribs: u32, pszdestfile: P2, dwdestattribs: u32) -> u32
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCSTR>,
        P2: ::std::convert::Into<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CopyCallback)(::windows::core::Interface::as_raw(self), hwnd.into(), wfunc, wflags, pszsrcfile.into(), dwsrcattribs, pszdestfile.into(), dwdestattribs)
    }
}
impl ::core::convert::From<ICopyHookA> for ::windows::core::IUnknown {
    fn from(value: ICopyHookA) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICopyHookA> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICopyHookA) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICopyHookA> for ::windows::core::IUnknown {
    fn from(value: &ICopyHookA) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICopyHookA {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICopyHookA {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICopyHookA {}
impl ::core::fmt::Debug for ICopyHookA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICopyHookA").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICopyHookA {
    type Vtable = ICopyHookA_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214ef_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICopyHookA_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CopyCallback: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: ::windows::core::PCSTR, dwsrcattribs: u32, pszdestfile: ::windows::core::PCSTR, dwdestattribs: u32) -> u32,
    #[cfg(not(feature = "Win32_Foundation"))]
    CopyCallback: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICopyHookW(::windows::core::IUnknown);
impl ICopyHookW {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CopyCallback<'a, P0, P1, P2>(&self, hwnd: P0, wfunc: u32, wflags: u32, pszsrcfile: P1, dwsrcattribs: u32, pszdestfile: P2, dwdestattribs: u32) -> u32
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CopyCallback)(::windows::core::Interface::as_raw(self), hwnd.into(), wfunc, wflags, pszsrcfile.into(), dwsrcattribs, pszdestfile.into(), dwdestattribs)
    }
}
impl ::core::convert::From<ICopyHookW> for ::windows::core::IUnknown {
    fn from(value: ICopyHookW) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICopyHookW> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICopyHookW) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICopyHookW> for ::windows::core::IUnknown {
    fn from(value: &ICopyHookW) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICopyHookW {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICopyHookW {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICopyHookW {}
impl ::core::fmt::Debug for ICopyHookW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICopyHookW").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICopyHookW {
    type Vtable = ICopyHookW_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214fc_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICopyHookW_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CopyCallback: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: ::windows::core::PCWSTR, dwsrcattribs: u32, pszdestfile: ::windows::core::PCWSTR, dwdestattribs: u32) -> u32,
    #[cfg(not(feature = "Win32_Foundation"))]
    CopyCallback: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICreateProcessInputs(::windows::core::IUnknown);
impl ICreateProcessInputs {
    pub unsafe fn GetCreateFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCreateFlags)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetCreateFlags(&self, dwcreationflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetCreateFlags)(::windows::core::Interface::as_raw(self), dwcreationflags).ok()
    }
    pub unsafe fn AddCreateFlags(&self, dwcreationflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddCreateFlags)(::windows::core::Interface::as_raw(self), dwcreationflags).ok()
    }
    pub unsafe fn SetHotKey(&self, whotkey: u16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetHotKey)(::windows::core::Interface::as_raw(self), whotkey).ok()
    }
    pub unsafe fn AddStartupFlags(&self, dwstartupinfoflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddStartupFlags)(::windows::core::Interface::as_raw(self), dwstartupinfoflags).ok()
    }
    pub unsafe fn SetTitle<'a, P0>(&self, psztitle: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetTitle)(::windows::core::Interface::as_raw(self), psztitle.into()).ok()
    }
    pub unsafe fn SetEnvironmentVariable<'a, P0, P1>(&self, pszname: P0, pszvalue: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetEnvironmentVariable)(::windows::core::Interface::as_raw(self), pszname.into(), pszvalue.into()).ok()
    }
}
impl ::core::convert::From<ICreateProcessInputs> for ::windows::core::IUnknown {
    fn from(value: ICreateProcessInputs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICreateProcessInputs> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICreateProcessInputs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICreateProcessInputs> for ::windows::core::IUnknown {
    fn from(value: &ICreateProcessInputs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICreateProcessInputs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreateProcessInputs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreateProcessInputs {}
impl ::core::fmt::Debug for ICreateProcessInputs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreateProcessInputs").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICreateProcessInputs {
    type Vtable = ICreateProcessInputs_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf6ef6140_e26f_4d82_bac4_e9ba5fd239a8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateProcessInputs_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetCreateFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcreationflags: *mut u32) -> ::windows::core::HRESULT,
    pub SetCreateFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcreationflags: u32) -> ::windows::core::HRESULT,
    pub AddCreateFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcreationflags: u32) -> ::windows::core::HRESULT,
    pub SetHotKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, whotkey: u16) -> ::windows::core::HRESULT,
    pub AddStartupFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstartupinfoflags: u32) -> ::windows::core::HRESULT,
    pub SetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psztitle: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetEnvironmentVariable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICreatingProcess(::windows::core::IUnknown);
impl ICreatingProcess {
    pub unsafe fn OnCreating<'a, P0>(&self, pcpi: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICreateProcessInputs>>,
    {
        (::windows::core::Interface::vtable(self).OnCreating)(::windows::core::Interface::as_raw(self), pcpi.into().abi()).ok()
    }
}
impl ::core::convert::From<ICreatingProcess> for ::windows::core::IUnknown {
    fn from(value: ICreatingProcess) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICreatingProcess> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICreatingProcess) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICreatingProcess> for ::windows::core::IUnknown {
    fn from(value: &ICreatingProcess) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICreatingProcess {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreatingProcess {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreatingProcess {}
impl ::core::fmt::Debug for ICreatingProcess {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreatingProcess").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICreatingProcess {
    type Vtable = ICreatingProcess_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc2b937a9_3110_4398_8a56_f34c6342d244);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreatingProcess_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub OnCreating: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpi: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProvider(::windows::core::IUnknown);
impl ICredentialProvider {
    pub unsafe fn SetUsageScenario(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetUsageScenario)(::windows::core::Interface::as_raw(self), cpus, dwflags).ok()
    }
    pub unsafe fn SetSerialization(&self, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetSerialization)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcpcs)).ok()
    }
    pub unsafe fn Advise<'a, P0>(&self, pcpe: P0, upadvisecontext: usize) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderEvents>>,
    {
        (::windows::core::Interface::vtable(self).Advise)(::windows::core::Interface::as_raw(self), pcpe.into().abi(), upadvisecontext).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UnAdvise)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldDescriptorCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFieldDescriptorCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetFieldDescriptorAt(&self, dwindex: u32) -> ::windows::core::Result<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFieldDescriptorAt)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCredentialCount(&self, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCredentialCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pdwcount), ::core::mem::transmute(pdwdefault), ::core::mem::transmute(pbautologonwithdefault)).ok()
    }
    pub unsafe fn GetCredentialAt(&self, dwindex: u32) -> ::windows::core::Result<ICredentialProviderCredential> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCredentialAt)(::windows::core::Interface::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICredentialProviderCredential>(result__)
    }
}
impl ::core::convert::From<ICredentialProvider> for ::windows::core::IUnknown {
    fn from(value: ICredentialProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProvider> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProvider> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProvider {}
impl ::core::fmt::Debug for ICredentialProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProvider {
    type Vtable = ICredentialProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd27c3481_5a1c_45b2_8aaa_c20ebbe8229e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProvider_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetUsageScenario: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> ::windows::core::HRESULT,
    pub SetSerialization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::HRESULT,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpe: *mut ::core::ffi::c_void, upadvisecontext: usize) -> ::windows::core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFieldDescriptorCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetFieldDescriptorAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, ppcpfd: *mut *mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCredentialCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCredentialCount: usize,
    pub GetCredentialAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, ppcpc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredential(::windows::core::IUnknown);
impl ICredentialProviderCredential {
    pub unsafe fn Advise<'a, P0>(&self, pcpce: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredentialEvents>>,
    {
        (::windows::core::Interface::vtable(self).Advise)(::windows::core::Interface::as_raw(self), pcpce.into().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UnAdvise)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).SetSelected)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetDeselected)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetFieldState)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetStringValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetBitmapValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCheckboxValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetSubmitButtonValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetComboBoxValueCount)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetComboBoxValueAt)(::windows::core::Interface::as_raw(self), dwfieldid, dwitem, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetStringValue<'a, P0>(&self, dwfieldid: u32, psz: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetStringValue)(::windows::core::Interface::as_raw(self), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, P0>(&self, dwfieldid: u32, bchecked: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetCheckboxValue)(::windows::core::Interface::as_raw(self), dwfieldid, bchecked.into()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetComboBoxSelectedValue)(::windows::core::Interface::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CommandLinkClicked)(::windows::core::Interface::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSerialization)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
        P1: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
    {
        (::windows::core::Interface::vtable(self).ReportResult)(::windows::core::Interface::as_raw(self), ntsstatus.into(), ntssubstatus.into(), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
}
impl ::core::convert::From<ICredentialProviderCredential> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredential> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredential> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderCredential) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderCredential {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredential {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredential {}
impl ::core::fmt::Debug for ICredentialProviderCredential {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredential").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredential {
    type Vtable = ICredentialProviderCredential_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63913a93_40c1_481a_818d_4072ff8c70cc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredential_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpce: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSelected: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbautologon: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSelected: usize,
    pub SetDeselected: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFieldState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::HRESULT,
    pub GetStringValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmapValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, phbmp: *mut super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmapValue: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCheckboxValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCheckboxValue: usize,
    pub GetSubmitButtonValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pdwadjacentto: *mut u32) -> ::windows::core::HRESULT,
    pub GetComboBoxValueCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::HRESULT,
    pub GetComboBoxValueAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, dwitem: u32, ppszitem: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetStringValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, psz: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCheckboxValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, bchecked: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCheckboxValue: usize,
    pub SetComboBoxSelectedValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::HRESULT,
    pub CommandLinkClicked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32) -> ::windows::core::HRESULT,
    pub GetSerialization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ReportResult: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ntsstatus: super::super::Foundation::NTSTATUS, ntssubstatus: super::super::Foundation::NTSTATUS, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ReportResult: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredential2(::windows::core::IUnknown);
impl ICredentialProviderCredential2 {
    pub unsafe fn Advise<'a, P0>(&self, pcpce: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredentialEvents>>,
    {
        (::windows::core::Interface::vtable(self).base__.Advise)(::windows::core::Interface::as_raw(self), pcpce.into().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.UnAdvise)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.SetSelected)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetDeselected)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetFieldState)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetStringValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetBitmapValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCheckboxValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetSubmitButtonValue)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetComboBoxValueCount)(::windows::core::Interface::as_raw(self), dwfieldid, ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetComboBoxValueAt)(::windows::core::Interface::as_raw(self), dwfieldid, dwitem, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetStringValue<'a, P0>(&self, dwfieldid: u32, psz: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetStringValue)(::windows::core::Interface::as_raw(self), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, P0>(&self, dwfieldid: u32, bchecked: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).base__.SetCheckboxValue)(::windows::core::Interface::as_raw(self), dwfieldid, bchecked.into()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetComboBoxSelectedValue)(::windows::core::Interface::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CommandLinkClicked)(::windows::core::Interface::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetSerialization)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
        P1: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
    {
        (::windows::core::Interface::vtable(self).base__.ReportResult)(::windows::core::Interface::as_raw(self), ntsstatus.into(), ntssubstatus.into(), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    pub unsafe fn GetUserSid(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetUserSid)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
impl ::core::convert::From<ICredentialProviderCredential2> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderCredential2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredential2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderCredential2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredential2> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderCredential2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICredentialProviderCredential2> for ICredentialProviderCredential {
    fn from(value: ICredentialProviderCredential2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredential2> for &'a ICredentialProviderCredential {
    fn from(value: &'a ICredentialProviderCredential2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredential2> for ICredentialProviderCredential {
    fn from(value: &ICredentialProviderCredential2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderCredential2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredential2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredential2 {}
impl ::core::fmt::Debug for ICredentialProviderCredential2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredential2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredential2 {
    type Vtable = ICredentialProviderCredential2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfd672c54_40ea_4d6e_9b49_cfb1a7507bd7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredential2_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub GetUserSid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredentialEvents(::windows::core::IUnknown);
impl ICredentialProviderCredentialEvents {
    pub unsafe fn SetFieldState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).SetFieldState)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, cpfs).ok()
    }
    pub unsafe fn SetFieldInteractiveState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).SetFieldInteractiveState)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, cpfis).ok()
    }
    pub unsafe fn SetFieldString<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, psz: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetFieldString)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFieldCheckbox<'a, P0, P1, P2>(&self, pcpc: P0, dwfieldid: u32, bchecked: P1, pszlabel: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetFieldCheckbox)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, bchecked.into(), pszlabel.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetFieldBitmap<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, hbmp: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Graphics::Gdi::HBITMAP>,
    {
        (::windows::core::Interface::vtable(self).SetFieldBitmap)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, hbmp.into()).ok()
    }
    pub unsafe fn SetFieldComboBoxSelectedItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).SetFieldComboBoxSelectedItem)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn DeleteFieldComboBoxItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).DeleteFieldComboBoxItem)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, dwitem).ok()
    }
    pub unsafe fn AppendFieldComboBoxItem<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, pszitem: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AppendFieldComboBoxItem)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, pszitem.into()).ok()
    }
    pub unsafe fn SetFieldSubmitButton<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwadjacentto: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).SetFieldSubmitButton)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, dwadjacentto).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCreatingWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).OnCreatingWindow)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
}
impl ::core::convert::From<ICredentialProviderCredentialEvents> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderCredentialEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredentialEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderCredentialEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredentialEvents> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderCredentialEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderCredentialEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredentialEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredentialEvents {}
impl ::core::fmt::Debug for ICredentialProviderCredentialEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredentialEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredentialEvents {
    type Vtable = ICredentialProviderCredentialEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa6fa76b_66b7_4b11_95f1_86171118e816);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredentialEvents_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetFieldState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> ::windows::core::HRESULT,
    pub SetFieldInteractiveState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::HRESULT,
    pub SetFieldString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, psz: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetFieldCheckbox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, bchecked: super::super::Foundation::BOOL, pszlabel: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetFieldCheckbox: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetFieldBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, hbmp: super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetFieldBitmap: usize,
    pub SetFieldComboBoxSelectedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::HRESULT,
    pub DeleteFieldComboBoxItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, dwitem: u32) -> ::windows::core::HRESULT,
    pub AppendFieldComboBoxItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, pszitem: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetFieldSubmitButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, dwadjacentto: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnCreatingWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndowner: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnCreatingWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredentialEvents2(::windows::core::IUnknown);
impl ICredentialProviderCredentialEvents2 {
    pub unsafe fn SetFieldState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldState)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, cpfs).ok()
    }
    pub unsafe fn SetFieldInteractiveState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldInteractiveState)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, cpfis).ok()
    }
    pub unsafe fn SetFieldString<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, psz: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldString)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFieldCheckbox<'a, P0, P1, P2>(&self, pcpc: P0, dwfieldid: u32, bchecked: P1, pszlabel: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldCheckbox)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, bchecked.into(), pszlabel.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetFieldBitmap<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, hbmp: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Graphics::Gdi::HBITMAP>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldBitmap)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, hbmp.into()).ok()
    }
    pub unsafe fn SetFieldComboBoxSelectedItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldComboBoxSelectedItem)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn DeleteFieldComboBoxItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).base__.DeleteFieldComboBoxItem)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, dwitem).ok()
    }
    pub unsafe fn AppendFieldComboBoxItem<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, pszitem: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.AppendFieldComboBoxItem)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, pszitem.into()).ok()
    }
    pub unsafe fn SetFieldSubmitButton<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwadjacentto: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).base__.SetFieldSubmitButton)(::windows::core::Interface::as_raw(self), pcpc.into().abi(), dwfieldid, dwadjacentto).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCreatingWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.OnCreatingWindow)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn BeginFieldUpdates(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BeginFieldUpdates)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndFieldUpdates(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndFieldUpdates)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFieldOptions<'a, P0>(&self, credential: P0, fieldid: u32, options: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Interface::vtable(self).SetFieldOptions)(::windows::core::Interface::as_raw(self), credential.into().abi(), fieldid, options).ok()
    }
}
impl ::core::convert::From<ICredentialProviderCredentialEvents2> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderCredentialEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredentialEvents2> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderCredentialEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredentialEvents2> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderCredentialEvents2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICredentialProviderCredentialEvents2> for ICredentialProviderCredentialEvents {
    fn from(value: ICredentialProviderCredentialEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredentialEvents2> for &'a ICredentialProviderCredentialEvents {
    fn from(value: &'a ICredentialProviderCredentialEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredentialEvents2> for ICredentialProviderCredentialEvents {
    fn from(value: &ICredentialProviderCredentialEvents2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderCredentialEvents2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredentialEvents2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredentialEvents2 {}
impl ::core::fmt::Debug for ICredentialProviderCredentialEvents2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredentialEvents2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredentialEvents2 {
    type Vtable = ICredentialProviderCredentialEvents2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb53c00b6_9922_4b78_b1f4_ddfe774dc39b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredentialEvents2_Vtbl {
    pub base__: ICredentialProviderCredentialEvents_Vtbl,
    pub BeginFieldUpdates: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndFieldUpdates: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetFieldOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, credential: *mut ::core::ffi::c_void, fieldid: u32, options: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredentialWithFieldOptions(::windows::core::IUnknown);
impl ICredentialProviderCredentialWithFieldOptions {
    pub unsafe fn GetFieldOptions(&self, fieldid: u32) -> ::windows::core::Result<CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetFieldOptions)(::windows::core::Interface::as_raw(self), fieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS>(result__)
    }
}
impl ::core::convert::From<ICredentialProviderCredentialWithFieldOptions> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderCredentialWithFieldOptions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderCredentialWithFieldOptions> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderCredentialWithFieldOptions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderCredentialWithFieldOptions> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderCredentialWithFieldOptions) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderCredentialWithFieldOptions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredentialWithFieldOptions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredentialWithFieldOptions {}
impl ::core::fmt::Debug for ICredentialProviderCredentialWithFieldOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredentialWithFieldOptions").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredentialWithFieldOptions {
    type Vtable = ICredentialProviderCredentialWithFieldOptions_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdbc6fb30_c843_49e3_a645_573e6f39446a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredentialWithFieldOptions_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetFieldOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fieldid: u32, options: *mut CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderEvents(::windows::core::IUnknown);
impl ICredentialProviderEvents {
    pub unsafe fn CredentialsChanged(&self, upadvisecontext: usize) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CredentialsChanged)(::windows::core::Interface::as_raw(self), upadvisecontext).ok()
    }
}
impl ::core::convert::From<ICredentialProviderEvents> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderEvents> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderEvents> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderEvents {}
impl ::core::fmt::Debug for ICredentialProviderEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderEvents {
    type Vtable = ICredentialProviderEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x34201e5a_a787_41a3_a5a4_bd6dcf2a854e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderEvents_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub CredentialsChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, upadvisecontext: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderFilter(::windows::core::IUnknown);
impl ICredentialProviderFilter {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Filter(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32, rgclsidproviders: *const ::windows::core::GUID, rgballow: *mut super::super::Foundation::BOOL, cproviders: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Filter)(::windows::core::Interface::as_raw(self), cpus, dwflags, ::core::mem::transmute(rgclsidproviders), ::core::mem::transmute(rgballow), ::core::mem::transmute(cproviders)).ok()
    }
    pub unsafe fn UpdateRemoteCredential(&self, pcpcsin: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::Result<CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).UpdateRemoteCredential)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcpcsin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION>(result__)
    }
}
impl ::core::convert::From<ICredentialProviderFilter> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderFilter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderFilter> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderFilter) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderFilter> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderFilter) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderFilter {}
impl ::core::fmt::Debug for ICredentialProviderFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderFilter {
    type Vtable = ICredentialProviderFilter_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa5da53f9_d475_4080_a120_910c4a739880);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderFilter_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Filter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32, rgclsidproviders: *const ::windows::core::GUID, rgballow: *mut super::super::Foundation::BOOL, cproviders: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Filter: usize,
    pub UpdateRemoteCredential: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpcsin: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, pcpcsout: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderSetUserArray(::windows::core::IUnknown);
impl ICredentialProviderSetUserArray {
    pub unsafe fn SetUserArray<'a, P0>(&self, users: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderUserArray>>,
    {
        (::windows::core::Interface::vtable(self).SetUserArray)(::windows::core::Interface::as_raw(self), users.into().abi()).ok()
    }
}
impl ::core::convert::From<ICredentialProviderSetUserArray> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderSetUserArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderSetUserArray> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderSetUserArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderSetUserArray> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderSetUserArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderSetUserArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderSetUserArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderSetUserArray {}
impl ::core::fmt::Debug for ICredentialProviderSetUserArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderSetUserArray").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderSetUserArray {
    type Vtable = ICredentialProviderSetUserArray_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x095c1484_1c0c_4388_9c6d_500e61bf84bd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderSetUserArray_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetUserArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, users: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderUser(::windows::core::IUnknown);
impl ICredentialProviderUser {
    pub unsafe fn GetSid(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetSid)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetProviderID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetProviderID)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetStringValue(&self, key: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetStringValue)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(key), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetValue(&self, key: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetValue)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(key), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::StructuredStorage::PROPVARIANT>(result__)
    }
}
impl ::core::convert::From<ICredentialProviderUser> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderUser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderUser> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderUser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderUser> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderUser) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderUser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderUser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderUser {}
impl ::core::fmt::Debug for ICredentialProviderUser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderUser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderUser {
    type Vtable = ICredentialProviderUser_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x13793285_3ea6_40fd_b420_15f47da41fbb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderUser_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetSid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetProviderID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, providerid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetStringValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: *const PropertiesSystem::PROPERTYKEY, stringvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetStringValue: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: *const PropertiesSystem::PROPERTYKEY, value: *mut super::super::System::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetValue: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderUserArray(::windows::core::IUnknown);
impl ICredentialProviderUserArray {
    pub unsafe fn SetProviderFilter(&self, guidprovidertofilterto: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProviderFilter)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(guidprovidertofilterto)).ok()
    }
    pub unsafe fn GetAccountOptions(&self) -> ::windows::core::Result<CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAccountOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS>(result__)
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetCount)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetAt(&self, userindex: u32) -> ::windows::core::Result<ICredentialProviderUser> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAt)(::windows::core::Interface::as_raw(self), userindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICredentialProviderUser>(result__)
    }
}
impl ::core::convert::From<ICredentialProviderUserArray> for ::windows::core::IUnknown {
    fn from(value: ICredentialProviderUserArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICredentialProviderUserArray> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICredentialProviderUserArray) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICredentialProviderUserArray> for ::windows::core::IUnknown {
    fn from(value: &ICredentialProviderUserArray) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICredentialProviderUserArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderUserArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderUserArray {}
impl ::core::fmt::Debug for ICredentialProviderUserArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderUserArray").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICredentialProviderUserArray {
    type Vtable = ICredentialProviderUserArray_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90c119ae_0f18_4520_a1f1_114366a40fe8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderUserArray_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetProviderFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidprovidertofilterto: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub GetAccountOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, credentialprovideraccountoptions: *mut CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usercount: *mut u32) -> ::windows::core::HRESULT,
    pub GetAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, userindex: u32, user: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICurrentItem(::windows::core::IUnknown);
impl ICurrentItem {
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetItemIDList(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetItemIDList)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn GetItem(&self) -> ::windows::core::Result<IShellItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).base__.GetItem)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItem>(result__)
    }
}
impl ::core::convert::From<ICurrentItem> for ::windows::core::IUnknown {
    fn from(value: ICurrentItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICurrentItem> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICurrentItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICurrentItem> for ::windows::core::IUnknown {
    fn from(value: &ICurrentItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::convert::From<ICurrentItem> for IRelatedItem {
    fn from(value: ICurrentItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICurrentItem> for &'a IRelatedItem {
    fn from(value: &'a ICurrentItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICurrentItem> for IRelatedItem {
    fn from(value: &ICurrentItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICurrentItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICurrentItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICurrentItem {}
impl ::core::fmt::Debug for ICurrentItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICurrentItem").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICurrentItem {
    type Vtable = ICurrentItem_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x240a7174_d653_4a1d_a6d3_d4943cfbfe3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICurrentItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICurrentWorkingDirectory(::windows::core::IUnknown);
impl ICurrentWorkingDirectory {
    pub unsafe fn GetDirectory(&self, pwzpath: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDirectory)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(::windows::core::as_mut_ptr_or_null(pwzpath)), pwzpath.len() as _).ok()
    }
    pub unsafe fn SetDirectory<'a, P0>(&self, pwzpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetDirectory)(::windows::core::Interface::as_raw(self), pwzpath.into()).ok()
    }
}
impl ::core::convert::From<ICurrentWorkingDirectory> for ::windows::core::IUnknown {
    fn from(value: ICurrentWorkingDirectory) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICurrentWorkingDirectory> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICurrentWorkingDirectory) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICurrentWorkingDirectory> for ::windows::core::IUnknown {
    fn from(value: &ICurrentWorkingDirectory) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICurrentWorkingDirectory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICurrentWorkingDirectory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICurrentWorkingDirectory {}
impl ::core::fmt::Debug for ICurrentWorkingDirectory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICurrentWorkingDirectory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICurrentWorkingDirectory {
    type Vtable = ICurrentWorkingDirectory_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91956d21_9276_11d1_921a_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICurrentWorkingDirectory_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub GetDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwzpath: ::windows::core::PWSTR, cchsize: u32) -> ::windows::core::HRESULT,
    pub SetDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwzpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICustomDestinationList(::windows::core::IUnknown);
impl ICustomDestinationList {
    pub unsafe fn SetAppID<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetAppID)(::windows::core::Interface::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn BeginList<T>(&self, pcminslots: *mut u32) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).BeginList)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pcminslots), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn AppendCategory<'a, P0, P1>(&self, pszcategory: P0, poa: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, Common::IObjectArray>>,
    {
        (::windows::core::Interface::vtable(self).AppendCategory)(::windows::core::Interface::as_raw(self), pszcategory.into(), poa.into().abi()).ok()
    }
    pub unsafe fn AppendKnownCategory(&self, category: KNOWNDESTCATEGORY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AppendKnownCategory)(::windows::core::Interface::as_raw(self), category).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn AddUserTasks<'a, P0>(&self, poa: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, Common::IObjectArray>>,
    {
        (::windows::core::Interface::vtable(self).AddUserTasks)(::windows::core::Interface::as_raw(self), poa.into().abi()).ok()
    }
    pub unsafe fn CommitList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CommitList)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRemovedDestinations<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetRemovedDestinations)(::windows::core::Interface::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn DeleteList<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DeleteList)(::windows::core::Interface::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn AbortList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbortList)(::windows::core::Interface::as_raw(self)).ok()
    }
}
impl ::core::convert::From<ICustomDestinationList> for ::windows::core::IUnknown {
    fn from(value: ICustomDestinationList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a ICustomDestinationList> for &'a ::windows::core::IUnknown {
    fn from(value: &'a ICustomDestinationList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICustomDestinationList> for ::windows::core::IUnknown {
    fn from(value: &ICustomDestinationList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for ICustomDestinationList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICustomDestinationList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICustomDestinationList {}
impl ::core::fmt::Debug for ICustomDestinationList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICustomDestinationList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICustomDestinationList {
    type Vtable = ICustomDestinationList_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6332debf_87b5_4670_90c0_5e57b408a49e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICustomDestinationList_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub BeginList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcminslots: *mut u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub AppendCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcategory: ::windows::core::PCWSTR, poa: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    AppendCategory: usize,
    pub AppendKnownCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, category: KNOWNDESTCATEGORY) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub AddUserTasks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poa: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    AddUserTasks: usize,
    pub CommitList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRemovedDestinations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DeleteList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AbortList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDC_OFFLINE_HAND: u32 = 103u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDC_PANTOOL_HAND_CLOSED: u32 = 105u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDC_PANTOOL_HAND_OPEN: u32 = 104u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDD_WIZEXTN_FIRST: u32 = 20480u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDD_WIZEXTN_LAST: u32 = 20736u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDO_SHGIOI_DEFAULT: u64 = 4294967292u64;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDO_SHGIOI_LINK: u32 = 268435454u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDO_SHGIOI_SHARE: u32 = 268435455u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDO_SHGIOI_SLOWFILE: u64 = 4294967293u64;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const IDS_DESCRIPTION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
pub const ID_APP: u32 = 100u32;
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDataObjectAsyncCapability(::windows::core::IUnknown);
impl IDataObjectAsyncCapability {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAsyncMode<'a, P0>(&self, fdoopasync: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).SetAsyncMode)(::windows::core::Interface::as_raw(self), fdoopasync.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAsyncMode(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetAsyncMode)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StartOperation<'a, P0>(&self, pbcreserved: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    {
        (::windows::core::Interface::vtable(self).StartOperation)(::windows::core::Interface::as_raw(self), pbcreserved.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InOperation(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).InOperation)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EndOperation<'a, P0>(&self, hresult: ::windows::core::HRESULT, pbcreserved: P0, dweffects: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    {
        (::windows::core::Interface::vtable(self).EndOperation)(::windows::core::Interface::as_raw(self), hresult, pbcreserved.into().abi(), dweffects).ok()
    }
}
impl ::core::convert::From<IDataObjectAsyncCapability> for ::windows::core::IUnknown {
    fn from(value: IDataObjectAsyncCapability) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IDataObjectAsyncCapability> for &'a ::windows::core::IUnknown {
    fn from(value: &'a IDataObjectAsyncCapability) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IDataObjectAsyncCapability> for ::windows::core::IUnknown {
    fn from(value: &IDataObjectAsyncCapability) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl ::core::clone::Clone for IDataObjectAsyncCapability {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataObjectAsyncCapability {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataObjectAsyncCapability {}
impl ::core::fmt::Debug for IDataObjectAsyncCapability {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataObjectAsyncCapability").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataObjectAsyncCapability {
    type Vtable = IDataObjectAsyncCapability_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d8b0590_f691_11d2_8ea9_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataObjectAsyncCapability_Vtbl {
    pub base__: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAsyncMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdoopasync: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAsyncMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetAsyncMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisopasync: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetAsyncMode: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub StartOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbcreserved: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StartOperation: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfinasyncop: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InOperation: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EndOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hresult: ::windows::core::HRESULT, pbcreserved: *mut ::core::ffi::c_void, dweffects: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EndOperation: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDataObjectProvider(::windows::core::IUnknown);
impl IDataObjectProvider {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetDataObject(&self) -> ::windows::core::Result<super::super::System::Com::IDataObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Interface::vtable(self).GetDataObject)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDataObject>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetDataObject<'a, P0>(&self, dataobject: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    {
        (::windows::core::Interface::vtable(self).SetDataObject)(::windows::core::Interface::as_raw(self), dataobject.into().abi()).ok()
    }
}
impl ::core::convert::From<IDataObjectProvider> for ::windows::core::IUnknown {
    fn from(value: IDataObjectProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl<'a> ::core::convert::From<&'a IDataObjectProvider> for &'a ::windows::core::IUnknown {
