use ::prelude::*;
DEFINE_IID!(IID_IAppDisplayInfo, 451612931, 58580, 16810, 164, 246, 196, 162, 118, 231, 158, 172);
RT_INTERFACE!{interface IAppDisplayInfo(IAppDisplayInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAppDisplayInfo] {
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(feature="windows-storage")] fn GetLogo(&self, size: super::foundation::Size, out: *mut *mut super::storage::streams::RandomAccessStreamReference) -> HRESULT
}}
impl IAppDisplayInfo {
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_logo(&self, size: super::foundation::Size) -> Result<ComPtr<super::storage::streams::RandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetLogo)(self as *const _ as *mut _, size, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppDisplayInfo: IAppDisplayInfo}
DEFINE_IID!(IID_IAppInfo, 3481229747, 27145, 19944, 166, 192, 87, 146, 213, 104, 128, 209);
RT_INTERFACE!{interface IAppInfo(IAppInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAppInfo] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppUserModelId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayInfo(&self, out: *mut *mut AppDisplayInfo) -> HRESULT,
    fn get_PackageFamilyName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppInfo {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_user_model_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppUserModelId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_info(&self) -> Result<ComPtr<AppDisplayInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppInfo: IAppInfo}
RT_CLASS!{static class DesignMode}
impl RtActivatable<IDesignModeStatics> for DesignMode {}
impl RtActivatable<IDesignModeStatics2> for DesignMode {}
impl DesignMode {
    #[inline] pub fn get_design_mode_enabled() -> Result<bool> { unsafe {
        <Self as RtActivatable<IDesignModeStatics>>::get_activation_factory().get_design_mode_enabled()
    }}
    #[inline] pub fn get_design_mode2_enabled() -> Result<bool> { unsafe {
        <Self as RtActivatable<IDesignModeStatics2>>::get_activation_factory().get_design_mode2_enabled()
    }}
}
DEFINE_CLSID!(DesignMode(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,68,101,115,105,103,110,77,111,100,101,0]) [CLSID_DesignMode]);
DEFINE_IID!(IID_IDesignModeStatics, 741905356, 63514, 20090, 184, 87, 118, 168, 8, 135, 225, 133);
RT_INTERFACE!{static interface IDesignModeStatics(IDesignModeStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDesignModeStatics] {
    fn get_DesignModeEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IDesignModeStatics {
    #[inline] pub unsafe fn get_design_mode_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesignModeEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDesignModeStatics2, 2161082679, 45156, 18520, 190, 200, 62, 186, 34, 53, 117, 53);
RT_INTERFACE!{static interface IDesignModeStatics2(IDesignModeStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IDesignModeStatics2] {
    fn get_DesignMode2Enabled(&self, out: *mut bool) -> HRESULT
}}
impl IDesignModeStatics2 {
    #[inline] pub unsafe fn get_design_mode2_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesignMode2Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IEnteredBackgroundEventArgs, 4146257090, 38951, 16445, 170, 237, 236, 202, 154, 193, 115, 152);
RT_INTERFACE!{interface IEnteredBackgroundEventArgs(IEnteredBackgroundEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IEnteredBackgroundEventArgs] {
    fn GetDeferral(&self, out: *mut *mut super::foundation::Deferral) -> HRESULT
}}
impl IEnteredBackgroundEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class EnteredBackgroundEventArgs: IEnteredBackgroundEventArgs}
RT_CLASS!{static class FullTrustProcessLauncher}
impl RtActivatable<IFullTrustProcessLauncherStatics> for FullTrustProcessLauncher {}
impl FullTrustProcessLauncher {
    #[inline] pub fn launch_full_trust_process_for_current_app_async() -> Result<ComPtr<super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IFullTrustProcessLauncherStatics>>::get_activation_factory().launch_full_trust_process_for_current_app_async()
    }}
    #[inline] pub fn launch_full_trust_process_for_current_app_with_parameters_async(parameterGroupId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IFullTrustProcessLauncherStatics>>::get_activation_factory().launch_full_trust_process_for_current_app_with_parameters_async(parameterGroupId)
    }}
    #[inline] pub fn launch_full_trust_process_for_app_async(fullTrustPackageRelativeAppId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IFullTrustProcessLauncherStatics>>::get_activation_factory().launch_full_trust_process_for_app_async(fullTrustPackageRelativeAppId)
    }}
    #[inline] pub fn launch_full_trust_process_for_app_with_parameters_async(fullTrustPackageRelativeAppId: &HStringArg, parameterGroupId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IFullTrustProcessLauncherStatics>>::get_activation_factory().launch_full_trust_process_for_app_with_parameters_async(fullTrustPackageRelativeAppId, parameterGroupId)
    }}
}
DEFINE_CLSID!(FullTrustProcessLauncher(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,70,117,108,108,84,114,117,115,116,80,114,111,99,101,115,115,76,97,117,110,99,104,101,114,0]) [CLSID_FullTrustProcessLauncher]);
DEFINE_IID!(IID_IFullTrustProcessLauncherStatics, 3615785855, 4352, 15467, 164, 85, 246, 38, 44, 195, 49, 182);
RT_INTERFACE!{static interface IFullTrustProcessLauncherStatics(IFullTrustProcessLauncherStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFullTrustProcessLauncherStatics] {
    fn LaunchFullTrustProcessForCurrentAppAsync(&self, out: *mut *mut super::foundation::IAsyncAction) -> HRESULT,
    fn LaunchFullTrustProcessForCurrentAppWithParametersAsync(&self, parameterGroupId: HSTRING, out: *mut *mut super::foundation::IAsyncAction) -> HRESULT,
    fn LaunchFullTrustProcessForAppAsync(&self, fullTrustPackageRelativeAppId: HSTRING, out: *mut *mut super::foundation::IAsyncAction) -> HRESULT,
    fn LaunchFullTrustProcessForAppWithParametersAsync(&self, fullTrustPackageRelativeAppId: HSTRING, parameterGroupId: HSTRING, out: *mut *mut super::foundation::IAsyncAction) -> HRESULT
}}
impl IFullTrustProcessLauncherStatics {
    #[inline] pub unsafe fn launch_full_trust_process_for_current_app_async(&self) -> Result<ComPtr<super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LaunchFullTrustProcessForCurrentAppAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn launch_full_trust_process_for_current_app_with_parameters_async(&self, parameterGroupId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LaunchFullTrustProcessForCurrentAppWithParametersAsync)(self as *const _ as *mut _, parameterGroupId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn launch_full_trust_process_for_app_async(&self, fullTrustPackageRelativeAppId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LaunchFullTrustProcessForAppAsync)(self as *const _ as *mut _, fullTrustPackageRelativeAppId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn launch_full_trust_process_for_app_with_parameters_async(&self, fullTrustPackageRelativeAppId: &HStringArg, parameterGroupId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LaunchFullTrustProcessForAppWithParametersAsync)(self as *const _ as *mut _, fullTrustPackageRelativeAppId.get(), parameterGroupId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ILeavingBackgroundEventArgs, 969338010, 44654, 18169, 160, 122, 207, 194, 63, 136, 115, 62);
RT_INTERFACE!{interface ILeavingBackgroundEventArgs(ILeavingBackgroundEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ILeavingBackgroundEventArgs] {
    fn GetDeferral(&self, out: *mut *mut super::foundation::Deferral) -> HRESULT
}}
impl ILeavingBackgroundEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LeavingBackgroundEventArgs: ILeavingBackgroundEventArgs}
DEFINE_IID!(IID_IPackage, 373061935, 48501, 16700, 191, 35, 177, 254, 123, 149, 216, 37);
RT_INTERFACE!{interface IPackage(IPackageVtbl): IInspectable(IInspectableVtbl) [IID_IPackage] {
    fn get_Id(&self, out: *mut *mut PackageId) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_InstalledLocation(&self, out: *mut *mut super::storage::StorageFolder) -> HRESULT,
    fn get_IsFramework(&self, out: *mut bool) -> HRESULT,
    fn get_Dependencies(&self, out: *mut *mut super::foundation::collections::IVectorView<Package>) -> HRESULT
}}
impl IPackage {
    #[inline] pub unsafe fn get_id(&self) -> Result<ComPtr<PackageId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_installed_location(&self) -> Result<ComPtr<super::storage::StorageFolder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InstalledLocation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_framework(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFramework)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dependencies(&self) -> Result<ComPtr<super::foundation::collections::IVectorView<Package>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dependencies)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Package: IPackage}
impl RtActivatable<IPackageStatics> for Package {}
impl Package {
    #[inline] pub fn get_current() -> Result<ComPtr<Package>> { unsafe {
        <Self as RtActivatable<IPackageStatics>>::get_activation_factory().get_current()
    }}
}
DEFINE_CLSID!(Package(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,80,97,99,107,97,103,101,0]) [CLSID_Package]);
DEFINE_IID!(IID_IPackage2, 2791387062, 30344, 19150, 149, 251, 53, 149, 56, 231, 170, 1);
RT_INTERFACE!{interface IPackage2(IPackage2Vtbl): IInspectable(IInspectableVtbl) [IID_IPackage2] {
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PublisherDisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Logo(&self, out: *mut *mut super::foundation::Uri) -> HRESULT,
    fn get_IsResourcePackage(&self, out: *mut bool) -> HRESULT,
    fn get_IsBundle(&self, out: *mut bool) -> HRESULT,
    fn get_IsDevelopmentMode(&self, out: *mut bool) -> HRESULT
}}
impl IPackage2 {
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_publisher_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PublisherDisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_logo(&self) -> Result<ComPtr<super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_resource_package(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsResourcePackage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_bundle(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBundle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_development_mode(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDevelopmentMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackage3, 1601407841, 63594, 18711, 147, 209, 241, 238, 157, 59, 53, 217);
RT_INTERFACE!{interface IPackage3(IPackage3Vtbl): IInspectable(IInspectableVtbl) [IID_IPackage3] {
    fn get_Status(&self, out: *mut *mut PackageStatus) -> HRESULT,
    fn get_InstalledDate(&self, out: *mut super::foundation::DateTime) -> HRESULT,
    fn GetAppListEntriesAsync(&self, out: *mut *mut super::foundation::IAsyncOperation<super::foundation::collections::IVectorView<core::AppListEntry>>) -> HRESULT
}}
impl IPackage3 {
    #[inline] pub unsafe fn get_status(&self) -> Result<ComPtr<PackageStatus>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_installed_date(&self) -> Result<super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InstalledDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_list_entries_async(&self) -> Result<ComPtr<super::foundation::IAsyncOperation<super::foundation::collections::IVectorView<core::AppListEntry>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppListEntriesAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackage4, 1705955758, 47451, 17676, 136, 43, 98, 85, 24, 127, 57, 126);
RT_INTERFACE!{interface IPackage4(IPackage4Vtbl): IInspectable(IInspectableVtbl) [IID_IPackage4] {
    fn get_SignatureKind(&self, out: *mut PackageSignatureKind) -> HRESULT,
    fn get_IsOptional(&self, out: *mut bool) -> HRESULT,
    fn VerifyContentIntegrityAsync(&self, out: *mut *mut super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IPackage4 {
    #[inline] pub unsafe fn get_signature_kind(&self) -> Result<PackageSignatureKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SignatureKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_optional(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOptional)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn verify_content_integrity_async(&self) -> Result<ComPtr<super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).VerifyContentIntegrityAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackage5, 243543508, 55724, 17901, 154, 30, 116, 206, 5, 107, 38, 53);
RT_INTERFACE!{interface IPackage5(IPackage5Vtbl): IInspectable(IInspectableVtbl) [IID_IPackage5] {
    fn GetContentGroupsAsync(&self, out: *mut *mut super::foundation::IAsyncOperation<super::foundation::collections::IVector<PackageContentGroup>>) -> HRESULT,
    fn GetContentGroupAsync(&self, name: HSTRING, out: *mut *mut super::foundation::IAsyncOperation<PackageContentGroup>) -> HRESULT,
    fn StageContentGroupsAsync(&self, names: *mut super::foundation::collections::IIterable<HString>, out: *mut *mut super::foundation::IAsyncOperation<super::foundation::collections::IVector<PackageContentGroup>>) -> HRESULT,
    fn StageContentGroupsWithPriorityAsync(&self, names: *mut super::foundation::collections::IIterable<HString>, moveToHeadOfQueue: bool, out: *mut *mut super::foundation::IAsyncOperation<super::foundation::collections::IVector<PackageContentGroup>>) -> HRESULT,
    fn SetInUseAsync(&self, inUse: bool, out: *mut *mut super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IPackage5 {
    #[inline] pub unsafe fn get_content_groups_async(&self) -> Result<ComPtr<super::foundation::IAsyncOperation<super::foundation::collections::IVector<PackageContentGroup>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContentGroupsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_group_async(&self, name: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncOperation<PackageContentGroup>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContentGroupAsync)(self as *const _ as *mut _, name.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stage_content_groups_async(&self, names: &super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::foundation::IAsyncOperation<super::foundation::collections::IVector<PackageContentGroup>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StageContentGroupsAsync)(self as *const _ as *mut _, names as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stage_content_groups_with_priority_async(&self, names: &super::foundation::collections::IIterable<HString>, moveToHeadOfQueue: bool) -> Result<ComPtr<super::foundation::IAsyncOperation<super::foundation::collections::IVector<PackageContentGroup>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StageContentGroupsWithPriorityAsync)(self as *const _ as *mut _, names as *const _ as *mut _, moveToHeadOfQueue, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_in_use_async(&self, inUse: bool) -> Result<ComPtr<super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetInUseAsync)(self as *const _ as *mut _, inUse, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageCatalog, 587872081, 40419, 17477, 190, 116, 145, 251, 50, 90, 190, 254);
RT_INTERFACE!{interface IPackageCatalog(IPackageCatalogVtbl): IInspectable(IInspectableVtbl) [IID_IPackageCatalog] {
    fn add_PackageStaging(&self, handler: *mut super::foundation::TypedEventHandler<PackageCatalog, PackageStagingEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PackageStaging(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PackageInstalling(&self, handler: *mut super::foundation::TypedEventHandler<PackageCatalog, PackageInstallingEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PackageInstalling(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PackageUpdating(&self, handler: *mut super::foundation::TypedEventHandler<PackageCatalog, PackageUpdatingEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PackageUpdating(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PackageUninstalling(&self, handler: *mut super::foundation::TypedEventHandler<PackageCatalog, PackageUninstallingEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PackageUninstalling(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PackageStatusChanged(&self, handler: *mut super::foundation::TypedEventHandler<PackageCatalog, PackageStatusChangedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PackageStatusChanged(&self, token: super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IPackageCatalog {
    #[inline] pub unsafe fn add_package_staging(&self, handler: &super::foundation::TypedEventHandler<PackageCatalog, PackageStagingEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PackageStaging)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_package_staging(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PackageStaging)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_package_installing(&self, handler: &super::foundation::TypedEventHandler<PackageCatalog, PackageInstallingEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PackageInstalling)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_package_installing(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PackageInstalling)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_package_updating(&self, handler: &super::foundation::TypedEventHandler<PackageCatalog, PackageUpdatingEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PackageUpdating)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_package_updating(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PackageUpdating)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_package_uninstalling(&self, handler: &super::foundation::TypedEventHandler<PackageCatalog, PackageUninstallingEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PackageUninstalling)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_package_uninstalling(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PackageUninstalling)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_package_status_changed(&self, handler: &super::foundation::TypedEventHandler<PackageCatalog, PackageStatusChangedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PackageStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_package_status_changed(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PackageStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PackageCatalog: IPackageCatalog}
impl RtActivatable<IPackageCatalogStatics> for PackageCatalog {}
impl PackageCatalog {
    #[inline] pub fn open_for_current_package() -> Result<ComPtr<PackageCatalog>> { unsafe {
        <Self as RtActivatable<IPackageCatalogStatics>>::get_activation_factory().open_for_current_package()
    }}
    #[inline] pub fn open_for_current_user() -> Result<ComPtr<PackageCatalog>> { unsafe {
        <Self as RtActivatable<IPackageCatalogStatics>>::get_activation_factory().open_for_current_user()
    }}
}
DEFINE_CLSID!(PackageCatalog(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,80,97,99,107,97,103,101,67,97,116,97,108,111,103,0]) [CLSID_PackageCatalog]);
DEFINE_IID!(IID_IPackageCatalog2, 2527464502, 36855, 17220, 182, 191, 238, 100, 194, 32, 126, 210);
RT_INTERFACE!{interface IPackageCatalog2(IPackageCatalog2Vtbl): IInspectable(IInspectableVtbl) [IID_IPackageCatalog2] {
    fn add_PackageContentGroupStaging(&self, handler: *mut super::foundation::TypedEventHandler<PackageCatalog, PackageContentGroupStagingEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PackageContentGroupStaging(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn AddOptionalPackageAsync(&self, optionalPackageFamilyName: HSTRING, out: *mut *mut super::foundation::IAsyncOperation<PackageCatalogAddOptionalPackageResult>) -> HRESULT
}}
impl IPackageCatalog2 {
    #[inline] pub unsafe fn add_package_content_group_staging(&self, handler: &super::foundation::TypedEventHandler<PackageCatalog, PackageContentGroupStagingEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PackageContentGroupStaging)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_package_content_group_staging(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PackageContentGroupStaging)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_optional_package_async(&self, optionalPackageFamilyName: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncOperation<PackageCatalogAddOptionalPackageResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AddOptionalPackageAsync)(self as *const _ as *mut _, optionalPackageFamilyName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageCatalog3, 2531089544, 34871, 17401, 144, 21, 3, 52, 52, 186, 20, 243);
RT_INTERFACE!{interface IPackageCatalog3(IPackageCatalog3Vtbl): IInspectable(IInspectableVtbl) [IID_IPackageCatalog3] {
    fn RemoveOptionalPackagesAsync(&self, optionalPackageFamilyNames: *mut super::foundation::collections::IIterable<HString>, out: *mut *mut super::foundation::IAsyncOperation<PackageCatalogRemoveOptionalPackagesResult>) -> HRESULT
}}
impl IPackageCatalog3 {
    #[inline] pub unsafe fn remove_optional_packages_async(&self, optionalPackageFamilyNames: &super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::foundation::IAsyncOperation<PackageCatalogRemoveOptionalPackagesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RemoveOptionalPackagesAsync)(self as *const _ as *mut _, optionalPackageFamilyNames as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageCatalogAddOptionalPackageResult, 1005653204, 46303, 18355, 169, 99, 226, 250, 131, 47, 125, 211);
RT_INTERFACE!{interface IPackageCatalogAddOptionalPackageResult(IPackageCatalogAddOptionalPackageResultVtbl): IInspectable(IInspectableVtbl) [IID_IPackageCatalogAddOptionalPackageResult] {
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT,
    fn get_ExtendedError(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IPackageCatalogAddOptionalPackageResult {
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageCatalogAddOptionalPackageResult: IPackageCatalogAddOptionalPackageResult}
DEFINE_IID!(IID_IPackageCatalogRemoveOptionalPackagesResult, 701692283, 55668, 20068, 147, 89, 34, 202, 223, 215, 152, 40);
RT_INTERFACE!{interface IPackageCatalogRemoveOptionalPackagesResult(IPackageCatalogRemoveOptionalPackagesResultVtbl): IInspectable(IInspectableVtbl) [IID_IPackageCatalogRemoveOptionalPackagesResult] {
    fn get_PackagesRemoved(&self, out: *mut *mut super::foundation::collections::IVectorView<Package>) -> HRESULT,
    fn get_ExtendedError(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IPackageCatalogRemoveOptionalPackagesResult {
    #[inline] pub unsafe fn get_packages_removed(&self) -> Result<ComPtr<super::foundation::collections::IVectorView<Package>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PackagesRemoved)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageCatalogRemoveOptionalPackagesResult: IPackageCatalogRemoveOptionalPackagesResult}
DEFINE_IID!(IID_IPackageCatalogStatics, 2710345366, 58971, 17972, 186, 33, 94, 99, 235, 114, 68, 167);
RT_INTERFACE!{static interface IPackageCatalogStatics(IPackageCatalogStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageCatalogStatics] {
    fn OpenForCurrentPackage(&self, out: *mut *mut PackageCatalog) -> HRESULT,
    fn OpenForCurrentUser(&self, out: *mut *mut PackageCatalog) -> HRESULT
}}
impl IPackageCatalogStatics {
    #[inline] pub unsafe fn open_for_current_package(&self) -> Result<ComPtr<PackageCatalog>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenForCurrentPackage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_for_current_user(&self) -> Result<ComPtr<PackageCatalog>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenForCurrentUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageContentGroup, 2405591389, 4618, 18328, 181, 225, 88, 0, 221, 168, 242, 225);
RT_INTERFACE!{interface IPackageContentGroup(IPackageContentGroupVtbl): IInspectable(IInspectableVtbl) [IID_IPackageContentGroup] {
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_State(&self, out: *mut PackageContentGroupState) -> HRESULT,
    fn get_IsRequired(&self, out: *mut bool) -> HRESULT
}}
impl IPackageContentGroup {
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<PackageContentGroupState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_required(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRequired)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageContentGroup: IPackageContentGroup}
impl RtActivatable<IPackageContentGroupStatics> for PackageContentGroup {}
impl PackageContentGroup {
    #[inline] pub fn get_required_group_name() -> Result<HString> { unsafe {
        <Self as RtActivatable<IPackageContentGroupStatics>>::get_activation_factory().get_required_group_name()
    }}
}
DEFINE_CLSID!(PackageContentGroup(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,80,97,99,107,97,103,101,67,111,110,116,101,110,116,71,114,111,117,112,0]) [CLSID_PackageContentGroup]);
DEFINE_IID!(IID_IPackageContentGroupStagingEventArgs, 1031520894, 28455, 17516, 152, 110, 212, 115, 61, 77, 145, 19);
RT_INTERFACE!{interface IPackageContentGroupStagingEventArgs(IPackageContentGroupStagingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageContentGroupStagingEventArgs] {
    fn get_ActivityId(&self, out: *mut Guid) -> HRESULT,
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT,
    fn get_Progress(&self, out: *mut f64) -> HRESULT,
    fn get_IsComplete(&self, out: *mut bool) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut super::foundation::HResult) -> HRESULT,
    fn get_ContentGroupName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsContentGroupRequired(&self, out: *mut bool) -> HRESULT
}}
impl IPackageContentGroupStagingEventArgs {
    #[inline] pub unsafe fn get_activity_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivityId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_complete(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComplete)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_group_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentGroupName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_content_group_required(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsContentGroupRequired)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageContentGroupStagingEventArgs: IPackageContentGroupStagingEventArgs}
RT_ENUM! { enum PackageContentGroupState: i32 {
    NotStaged (PackageContentGroupState_NotStaged) = 0, Queued (PackageContentGroupState_Queued) = 1, Staging (PackageContentGroupState_Staging) = 2, Staged (PackageContentGroupState_Staged) = 3,
}}
DEFINE_IID!(IID_IPackageContentGroupStatics, 1894675993, 24338, 19346, 185, 234, 108, 202, 218, 19, 188, 117);
RT_INTERFACE!{static interface IPackageContentGroupStatics(IPackageContentGroupStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageContentGroupStatics] {
    fn get_RequiredGroupName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPackageContentGroupStatics {
    #[inline] pub unsafe fn get_required_group_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RequiredGroupName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageId, 450586206, 14279, 18320, 153, 128, 221, 122, 231, 78, 139, 178);
RT_INTERFACE!{interface IPackageId(IPackageIdVtbl): IInspectable(IInspectableVtbl) [IID_IPackageId] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Version(&self, out: *mut PackageVersion) -> HRESULT,
    #[cfg(not(feature="windows-system"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-system")] fn get_Architecture(&self, out: *mut super::system::ProcessorArchitecture) -> HRESULT,
    fn get_ResourceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Publisher(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PublisherId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_FullName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_FamilyName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPackageId {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_version(&self) -> Result<PackageVersion> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Version)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_architecture(&self) -> Result<super::system::ProcessorArchitecture> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Architecture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_resource_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ResourceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_publisher(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Publisher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_publisher_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PublisherId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_full_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FullName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PackageId: IPackageId}
DEFINE_IID!(IID_IPackageIdWithMetadata, 1079474812, 3230, 17469, 144, 116, 133, 95, 92, 224, 160, 141);
RT_INTERFACE!{interface IPackageIdWithMetadata(IPackageIdWithMetadataVtbl): IInspectable(IInspectableVtbl) [IID_IPackageIdWithMetadata] {
    fn get_ProductId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Author(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPackageIdWithMetadata {
    #[inline] pub unsafe fn get_product_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProductId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_author(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Author)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageInstallingEventArgs, 2540969655, 43898, 16410, 139, 97, 235, 14, 127, 175, 242, 55);
RT_INTERFACE!{interface IPackageInstallingEventArgs(IPackageInstallingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageInstallingEventArgs] {
    fn get_ActivityId(&self, out: *mut Guid) -> HRESULT,
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT,
    fn get_Progress(&self, out: *mut f64) -> HRESULT,
    fn get_IsComplete(&self, out: *mut bool) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IPackageInstallingEventArgs {
    #[inline] pub unsafe fn get_activity_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivityId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_complete(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComplete)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageInstallingEventArgs: IPackageInstallingEventArgs}
RT_ENUM! { enum PackageSignatureKind: i32 {
    None (PackageSignatureKind_None) = 0, Developer (PackageSignatureKind_Developer) = 1, Enterprise (PackageSignatureKind_Enterprise) = 2, Store (PackageSignatureKind_Store) = 3, System (PackageSignatureKind_System) = 4,
}}
DEFINE_IID!(IID_IPackageStagingEventArgs, 272721965, 21730, 20305, 184, 40, 158, 247, 4, 108, 33, 15);
RT_INTERFACE!{interface IPackageStagingEventArgs(IPackageStagingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageStagingEventArgs] {
    fn get_ActivityId(&self, out: *mut Guid) -> HRESULT,
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT,
    fn get_Progress(&self, out: *mut f64) -> HRESULT,
    fn get_IsComplete(&self, out: *mut bool) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IPackageStagingEventArgs {
    #[inline] pub unsafe fn get_activity_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivityId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_complete(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComplete)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageStagingEventArgs: IPackageStagingEventArgs}
DEFINE_IID!(IID_IPackageStatics, 1314081759, 10592, 18552, 151, 164, 150, 36, 222, 183, 47, 45);
RT_INTERFACE!{static interface IPackageStatics(IPackageStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageStatics] {
    fn get_Current(&self, out: *mut *mut Package) -> HRESULT
}}
impl IPackageStatics {
    #[inline] pub unsafe fn get_current(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Current)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageStatus, 1608994673, 41829, 19465, 160, 45, 4, 109, 82, 94, 161, 218);
RT_INTERFACE!{interface IPackageStatus(IPackageStatusVtbl): IInspectable(IInspectableVtbl) [IID_IPackageStatus] {
    fn VerifyIsOK(&self, out: *mut bool) -> HRESULT,
    fn get_NotAvailable(&self, out: *mut bool) -> HRESULT,
    fn get_PackageOffline(&self, out: *mut bool) -> HRESULT,
    fn get_DataOffline(&self, out: *mut bool) -> HRESULT,
    fn get_Disabled(&self, out: *mut bool) -> HRESULT,
    fn get_NeedsRemediation(&self, out: *mut bool) -> HRESULT,
    fn get_LicenseIssue(&self, out: *mut bool) -> HRESULT,
    fn get_Modified(&self, out: *mut bool) -> HRESULT,
    fn get_Tampered(&self, out: *mut bool) -> HRESULT,
    fn get_DependencyIssue(&self, out: *mut bool) -> HRESULT,
    fn get_Servicing(&self, out: *mut bool) -> HRESULT,
    fn get_DeploymentInProgress(&self, out: *mut bool) -> HRESULT
}}
impl IPackageStatus {
    #[inline] pub unsafe fn verify_is_ok(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).VerifyIsOK)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_not_available(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NotAvailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package_offline(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PackageOffline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_offline(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DataOffline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Disabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_needs_remediation(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NeedsRemediation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_license_issue(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LicenseIssue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_modified(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Modified)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tampered(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Tampered)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dependency_issue(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DependencyIssue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_servicing(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Servicing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deployment_in_progress(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeploymentInProgress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageStatus: IPackageStatus}
DEFINE_IID!(IID_IPackageStatus2, 4096326291, 31830, 18530, 172, 250, 171, 174, 220, 192, 105, 77);
RT_INTERFACE!{interface IPackageStatus2(IPackageStatus2Vtbl): IInspectable(IInspectableVtbl) [IID_IPackageStatus2] {
    fn get_IsPartiallyStaged(&self, out: *mut bool) -> HRESULT
}}
impl IPackageStatus2 {
    #[inline] pub unsafe fn get_is_partially_staged(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPartiallyStaged)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPackageStatusChangedEventArgs, 1132294477, 48512, 19056, 188, 80, 246, 231, 150, 80, 149, 117);
RT_INTERFACE!{interface IPackageStatusChangedEventArgs(IPackageStatusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageStatusChangedEventArgs] {
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT
}}
impl IPackageStatusChangedEventArgs {
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PackageStatusChangedEventArgs: IPackageStatusChangedEventArgs}
DEFINE_IID!(IID_IPackageUninstallingEventArgs, 1145285202, 43810, 17613, 130, 187, 78, 201, 184, 39, 54, 122);
RT_INTERFACE!{interface IPackageUninstallingEventArgs(IPackageUninstallingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageUninstallingEventArgs] {
    fn get_ActivityId(&self, out: *mut Guid) -> HRESULT,
    fn get_Package(&self, out: *mut *mut Package) -> HRESULT,
    fn get_Progress(&self, out: *mut f64) -> HRESULT,
    fn get_IsComplete(&self, out: *mut bool) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IPackageUninstallingEventArgs {
    #[inline] pub unsafe fn get_activity_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivityId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Package)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_complete(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComplete)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageUninstallingEventArgs: IPackageUninstallingEventArgs}
DEFINE_IID!(IID_IPackageUpdatingEventArgs, 3447407144, 64884, 17470, 177, 20, 35, 230, 119, 176, 232, 111);
RT_INTERFACE!{interface IPackageUpdatingEventArgs(IPackageUpdatingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPackageUpdatingEventArgs] {
    fn get_ActivityId(&self, out: *mut Guid) -> HRESULT,
    fn get_SourcePackage(&self, out: *mut *mut Package) -> HRESULT,
    fn get_TargetPackage(&self, out: *mut *mut Package) -> HRESULT,
    fn get_Progress(&self, out: *mut f64) -> HRESULT,
    fn get_IsComplete(&self, out: *mut bool) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IPackageUpdatingEventArgs {
    #[inline] pub unsafe fn get_activity_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivityId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourcePackage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_package(&self) -> Result<ComPtr<Package>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetPackage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_complete(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComplete)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PackageUpdatingEventArgs: IPackageUpdatingEventArgs}
RT_STRUCT! { struct PackageVersion {
    Major: u16, Minor: u16, Build: u16, Revision: u16,
}}
DEFINE_IID!(IID_IPackageWithMetadata, 2509543296, 7657, 16626, 180, 82, 13, 233, 241, 145, 0, 18);
RT_INTERFACE!{interface IPackageWithMetadata(IPackageWithMetadataVtbl): IInspectable(IInspectableVtbl) [IID_IPackageWithMetadata] {
    fn get_InstallDate(&self, out: *mut super::foundation::DateTime) -> HRESULT,
    fn GetThumbnailToken(&self, out: *mut HSTRING) -> HRESULT,
    fn Launch(&self, parameters: HSTRING) -> HRESULT
}}
impl IPackageWithMetadata {
    #[inline] pub unsafe fn get_install_date(&self) -> Result<super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InstallDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail_token(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetThumbnailToken)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn launch(&self, parameters: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).Launch)(self as *const _ as *mut _, parameters.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IStartupTask, 4150010824, 46578, 20332, 136, 221, 54, 203, 29, 89, 157, 23);
RT_INTERFACE!{interface IStartupTask(IStartupTaskVtbl): IInspectable(IInspectableVtbl) [IID_IStartupTask] {
    fn RequestEnableAsync(&self, out: *mut *mut super::foundation::IAsyncOperation<StartupTaskState>) -> HRESULT,
    fn Disable(&self) -> HRESULT,
    fn get_State(&self, out: *mut StartupTaskState) -> HRESULT,
    fn get_TaskId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IStartupTask {
    #[inline] pub unsafe fn request_enable_async(&self) -> Result<ComPtr<super::foundation::IAsyncOperation<StartupTaskState>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestEnableAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn disable(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Disable)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<StartupTaskState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_task_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TaskId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class StartupTask: IStartupTask}
impl RtActivatable<IStartupTaskStatics> for StartupTask {}
impl StartupTask {
    #[inline] pub fn get_for_current_package_async() -> Result<ComPtr<super::foundation::IAsyncOperation<super::foundation::collections::IVectorView<StartupTask>>>> { unsafe {
        <Self as RtActivatable<IStartupTaskStatics>>::get_activation_factory().get_for_current_package_async()
    }}
    #[inline] pub fn get_async(taskId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncOperation<StartupTask>>> { unsafe {
        <Self as RtActivatable<IStartupTaskStatics>>::get_activation_factory().get_async(taskId)
    }}
}
DEFINE_CLSID!(StartupTask(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,116,97,114,116,117,112,84,97,115,107,0]) [CLSID_StartupTask]);
RT_ENUM! { enum StartupTaskState: i32 {
    Disabled (StartupTaskState_Disabled) = 0, DisabledByUser (StartupTaskState_DisabledByUser) = 1, Enabled (StartupTaskState_Enabled) = 2, DisabledByPolicy (StartupTaskState_DisabledByPolicy) = 3,
}}
DEFINE_IID!(IID_IStartupTaskStatics, 3998965949, 41288, 16807, 178, 110, 232, 184, 138, 30, 98, 248);
RT_INTERFACE!{static interface IStartupTaskStatics(IStartupTaskStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IStartupTaskStatics] {
    fn GetForCurrentPackageAsync(&self, out: *mut *mut super::foundation::IAsyncOperation<super::foundation::collections::IVectorView<StartupTask>>) -> HRESULT,
    fn GetAsync(&self, taskId: HSTRING, out: *mut *mut super::foundation::IAsyncOperation<StartupTask>) -> HRESULT
}}
impl IStartupTaskStatics {
    #[inline] pub unsafe fn get_for_current_package_async(&self) -> Result<ComPtr<super::foundation::IAsyncOperation<super::foundation::collections::IVectorView<StartupTask>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentPackageAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_async(&self, taskId: &HStringArg) -> Result<ComPtr<super::foundation::IAsyncOperation<StartupTask>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAsync)(self as *const _ as *mut _, taskId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISuspendingDeferral, 1494484233, 35785, 20148, 182, 54, 218, 189, 196, 244, 111, 102);
RT_INTERFACE!{interface ISuspendingDeferral(ISuspendingDeferralVtbl): IInspectable(IInspectableVtbl) [IID_ISuspendingDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl ISuspendingDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SuspendingDeferral: ISuspendingDeferral}
DEFINE_IID!(IID_ISuspendingEventArgs, 2516982789, 11706, 19720, 176, 189, 43, 48, 161, 49, 198, 170);
RT_INTERFACE!{interface ISuspendingEventArgs(ISuspendingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISuspendingEventArgs] {
    fn get_SuspendingOperation(&self, out: *mut *mut SuspendingOperation) -> HRESULT
}}
impl ISuspendingEventArgs {
    #[inline] pub unsafe fn get_suspending_operation(&self) -> Result<ComPtr<SuspendingOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SuspendingOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SuspendingEventArgs: ISuspendingEventArgs}
DEFINE_IID!(IID_ISuspendingOperation, 2644822593, 8417, 20123, 159, 101, 169, 244, 53, 52, 12, 58);
RT_INTERFACE!{interface ISuspendingOperation(ISuspendingOperationVtbl): IInspectable(IInspectableVtbl) [IID_ISuspendingOperation] {
    fn GetDeferral(&self, out: *mut *mut SuspendingDeferral) -> HRESULT,
    fn get_Deadline(&self, out: *mut super::foundation::DateTime) -> HRESULT
}}
impl ISuspendingOperation {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<SuspendingDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deadline(&self) -> Result<super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Deadline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SuspendingOperation: ISuspendingOperation}
pub mod calls { // Windows.ApplicationModel.Calls
use ::prelude::*;
DEFINE_IID!(IID_ICallAnswerEventArgs, 4252538391, 11735, 19596, 178, 189, 149, 209, 122, 91, 183, 51);
RT_INTERFACE!{interface ICallAnswerEventArgs(ICallAnswerEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICallAnswerEventArgs] {
    fn get_AcceptedMedia(&self, out: *mut VoipPhoneCallMedia) -> HRESULT
}}
impl ICallAnswerEventArgs {
    #[inline] pub unsafe fn get_accepted_media(&self) -> Result<VoipPhoneCallMedia> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AcceptedMedia)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CallAnswerEventArgs: ICallAnswerEventArgs}
DEFINE_IID!(IID_ICallRejectEventArgs, 3662150359, 5076, 19858, 161, 194, 183, 120, 17, 238, 55, 236);
RT_INTERFACE!{interface ICallRejectEventArgs(ICallRejectEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICallRejectEventArgs] {
    fn get_RejectReason(&self, out: *mut VoipPhoneCallRejectReason) -> HRESULT
}}
impl ICallRejectEventArgs {
    #[inline] pub unsafe fn get_reject_reason(&self) -> Result<VoipPhoneCallRejectReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RejectReason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CallRejectEventArgs: ICallRejectEventArgs}
DEFINE_IID!(IID_ICallStateChangeEventArgs, 3937547422, 26357, 18425, 159, 181, 69, 156, 81, 152, 199, 32);
RT_INTERFACE!{interface ICallStateChangeEventArgs(ICallStateChangeEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICallStateChangeEventArgs] {
    fn get_State(&self, out: *mut VoipPhoneCallState) -> HRESULT
}}
impl ICallStateChangeEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<VoipPhoneCallState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CallStateChangeEventArgs: ICallStateChangeEventArgs}
DEFINE_IID!(IID_ILockScreenCallEndCallDeferral, 769125645, 39149, 16449, 150, 50, 80, 255, 129, 43, 119, 63);
RT_INTERFACE!{interface ILockScreenCallEndCallDeferral(ILockScreenCallEndCallDeferralVtbl): IInspectable(IInspectableVtbl) [IID_ILockScreenCallEndCallDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl ILockScreenCallEndCallDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class LockScreenCallEndCallDeferral: ILockScreenCallEndCallDeferral}
DEFINE_IID!(IID_ILockScreenCallEndRequestedEventArgs, 2173739875, 28455, 18153, 174, 182, 192, 174, 131, 228, 125, 199);
RT_INTERFACE!{interface ILockScreenCallEndRequestedEventArgs(ILockScreenCallEndRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ILockScreenCallEndRequestedEventArgs] {
    fn GetDeferral(&self, out: *mut *mut LockScreenCallEndCallDeferral) -> HRESULT,
    fn get_Deadline(&self, out: *mut super::super::foundation::DateTime) -> HRESULT
}}
impl ILockScreenCallEndRequestedEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<LockScreenCallEndCallDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deadline(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Deadline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class LockScreenCallEndRequestedEventArgs: ILockScreenCallEndRequestedEventArgs}
DEFINE_IID!(IID_ILockScreenCallUI, 3315006861, 29641, 18964, 176, 33, 236, 28, 80, 163, 183, 39);
RT_INTERFACE!{interface ILockScreenCallUI(ILockScreenCallUIVtbl): IInspectable(IInspectableVtbl) [IID_ILockScreenCallUI] {
    fn Dismiss(&self) -> HRESULT,
    fn add_EndRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<LockScreenCallUI, LockScreenCallEndRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EndRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, handler: *mut super::super::foundation::TypedEventHandler<LockScreenCallUI, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_CallTitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CallTitle(&self, value: HSTRING) -> HRESULT
}}
impl ILockScreenCallUI {
    #[inline] pub unsafe fn dismiss(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Dismiss)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_end_requested(&self, handler: &super::super::foundation::TypedEventHandler<LockScreenCallUI, LockScreenCallEndRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EndRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_end_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EndRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, handler: &super::super::foundation::TypedEventHandler<LockScreenCallUI, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_call_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallTitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_call_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CallTitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class LockScreenCallUI: ILockScreenCallUI}
DEFINE_IID!(IID_IMuteChangeEventArgs, 2240143705, 3137, 17196, 129, 77, 197, 241, 253, 245, 48, 190);
RT_INTERFACE!{interface IMuteChangeEventArgs(IMuteChangeEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMuteChangeEventArgs] {
    fn get_Muted(&self, out: *mut bool) -> HRESULT
}}
impl IMuteChangeEventArgs {
    #[inline] pub unsafe fn get_muted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Muted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MuteChangeEventArgs: IMuteChangeEventArgs}
DEFINE_IID!(IID_IPhoneCallHistoryEntry, 4205895977, 12964, 19333, 131, 209, 249, 13, 140, 35, 168, 87);
RT_INTERFACE!{interface IPhoneCallHistoryEntry(IPhoneCallHistoryEntryVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryEntry] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Address(&self, out: *mut *mut PhoneCallHistoryEntryAddress) -> HRESULT,
    fn put_Address(&self, value: *mut PhoneCallHistoryEntryAddress) -> HRESULT,
    fn get_Duration(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_Duration(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_IsCallerIdBlocked(&self, out: *mut bool) -> HRESULT,
    fn put_IsCallerIdBlocked(&self, value: bool) -> HRESULT,
    fn get_IsEmergency(&self, out: *mut bool) -> HRESULT,
    fn put_IsEmergency(&self, value: bool) -> HRESULT,
    fn get_IsIncoming(&self, out: *mut bool) -> HRESULT,
    fn put_IsIncoming(&self, value: bool) -> HRESULT,
    fn get_IsMissed(&self, out: *mut bool) -> HRESULT,
    fn put_IsMissed(&self, value: bool) -> HRESULT,
    fn get_IsRinging(&self, out: *mut bool) -> HRESULT,
    fn put_IsRinging(&self, value: bool) -> HRESULT,
    fn get_IsSeen(&self, out: *mut bool) -> HRESULT,
    fn put_IsSeen(&self, value: bool) -> HRESULT,
    fn get_IsSuppressed(&self, out: *mut bool) -> HRESULT,
    fn put_IsSuppressed(&self, value: bool) -> HRESULT,
    fn get_IsVoicemail(&self, out: *mut bool) -> HRESULT,
    fn put_IsVoicemail(&self, value: bool) -> HRESULT,
    fn get_Media(&self, out: *mut PhoneCallHistoryEntryMedia) -> HRESULT,
    fn put_Media(&self, value: PhoneCallHistoryEntryMedia) -> HRESULT,
    fn get_OtherAppReadAccess(&self, out: *mut PhoneCallHistoryEntryOtherAppReadAccess) -> HRESULT,
    fn put_OtherAppReadAccess(&self, value: PhoneCallHistoryEntryOtherAppReadAccess) -> HRESULT,
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    fn get_SourceDisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SourceId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SourceId(&self, value: HSTRING) -> HRESULT,
    fn get_SourceIdKind(&self, out: *mut PhoneCallHistorySourceIdKind) -> HRESULT,
    fn put_SourceIdKind(&self, value: PhoneCallHistorySourceIdKind) -> HRESULT,
    fn get_StartTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_StartTime(&self, value: super::super::foundation::DateTime) -> HRESULT
}}
impl IPhoneCallHistoryEntry {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_address(&self) -> Result<ComPtr<PhoneCallHistoryEntryAddress>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Address)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_address(&self, value: &PhoneCallHistoryEntryAddress) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Address)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_caller_id_blocked(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCallerIdBlocked)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_caller_id_blocked(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCallerIdBlocked)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_emergency(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEmergency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_emergency(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEmergency)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_incoming(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsIncoming)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_incoming(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsIncoming)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_missed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMissed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_missed(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsMissed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_ringing(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRinging)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_ringing(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsRinging)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_seen(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSeen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_seen(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSeen)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_suppressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSuppressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_suppressed(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSuppressed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_voicemail(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsVoicemail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_voicemail(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsVoicemail)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media(&self) -> Result<PhoneCallHistoryEntryMedia> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Media)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_media(&self, value: PhoneCallHistoryEntryMedia) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Media)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_other_app_read_access(&self) -> Result<PhoneCallHistoryEntryOtherAppReadAccess> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OtherAppReadAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_other_app_read_access(&self, value: PhoneCallHistoryEntryOtherAppReadAccess) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OtherAppReadAccess)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceDisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SourceId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_id_kind(&self) -> Result<PhoneCallHistorySourceIdKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SourceIdKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source_id_kind(&self, value: PhoneCallHistorySourceIdKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SourceIdKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallHistoryEntry: IPhoneCallHistoryEntry}
impl RtActivatable<IActivationFactory> for PhoneCallHistoryEntry {}
DEFINE_CLSID!(PhoneCallHistoryEntry(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,97,108,108,115,46,80,104,111,110,101,67,97,108,108,72,105,115,116,111,114,121,69,110,116,114,121,0]) [CLSID_PhoneCallHistoryEntry]);
DEFINE_IID!(IID_IPhoneCallHistoryEntryAddress, 821123546, 14677, 16450, 132, 230, 102, 238, 191, 130, 230, 127);
RT_INTERFACE!{interface IPhoneCallHistoryEntryAddress(IPhoneCallHistoryEntryAddressVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryEntryAddress] {
    fn get_ContactId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ContactId(&self, value: HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_RawAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RawAddress(&self, value: HSTRING) -> HRESULT,
    fn get_RawAddressKind(&self, out: *mut PhoneCallHistoryEntryRawAddressKind) -> HRESULT,
    fn put_RawAddressKind(&self, value: PhoneCallHistoryEntryRawAddressKind) -> HRESULT
}}
impl IPhoneCallHistoryEntryAddress {
    #[inline] pub unsafe fn get_contact_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_contact_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContactId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_raw_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RawAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_raw_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RawAddress)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_raw_address_kind(&self) -> Result<PhoneCallHistoryEntryRawAddressKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RawAddressKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_raw_address_kind(&self, value: PhoneCallHistoryEntryRawAddressKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RawAddressKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallHistoryEntryAddress: IPhoneCallHistoryEntryAddress}
impl RtActivatable<IPhoneCallHistoryEntryAddressFactory> for PhoneCallHistoryEntryAddress {}
impl RtActivatable<IActivationFactory> for PhoneCallHistoryEntryAddress {}
impl PhoneCallHistoryEntryAddress {
    #[inline] pub fn create(rawAddress: &HStringArg, rawAddressKind: PhoneCallHistoryEntryRawAddressKind) -> Result<ComPtr<PhoneCallHistoryEntryAddress>> { unsafe {
        <Self as RtActivatable<IPhoneCallHistoryEntryAddressFactory>>::get_activation_factory().create(rawAddress, rawAddressKind)
    }}
}
DEFINE_CLSID!(PhoneCallHistoryEntryAddress(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,97,108,108,115,46,80,104,111,110,101,67,97,108,108,72,105,115,116,111,114,121,69,110,116,114,121,65,100,100,114,101,115,115,0]) [CLSID_PhoneCallHistoryEntryAddress]);
DEFINE_IID!(IID_IPhoneCallHistoryEntryAddressFactory, 4212108730, 51184, 19382, 159, 107, 186, 93, 115, 32, 154, 202);
RT_INTERFACE!{static interface IPhoneCallHistoryEntryAddressFactory(IPhoneCallHistoryEntryAddressFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryEntryAddressFactory] {
    fn Create(&self, rawAddress: HSTRING, rawAddressKind: PhoneCallHistoryEntryRawAddressKind, out: *mut *mut PhoneCallHistoryEntryAddress) -> HRESULT
}}
impl IPhoneCallHistoryEntryAddressFactory {
    #[inline] pub unsafe fn create(&self, rawAddress: &HStringArg, rawAddressKind: PhoneCallHistoryEntryRawAddressKind) -> Result<ComPtr<PhoneCallHistoryEntryAddress>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, rawAddress.get(), rawAddressKind, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum PhoneCallHistoryEntryMedia: i32 {
    Audio (PhoneCallHistoryEntryMedia_Audio) = 0, Video (PhoneCallHistoryEntryMedia_Video) = 1,
}}
RT_ENUM! { enum PhoneCallHistoryEntryOtherAppReadAccess: i32 {
    Full (PhoneCallHistoryEntryOtherAppReadAccess_Full) = 0, SystemOnly (PhoneCallHistoryEntryOtherAppReadAccess_SystemOnly) = 1,
}}
RT_ENUM! { enum PhoneCallHistoryEntryQueryDesiredMedia: u32 {
    None (PhoneCallHistoryEntryQueryDesiredMedia_None) = 0, Audio (PhoneCallHistoryEntryQueryDesiredMedia_Audio) = 1, Video (PhoneCallHistoryEntryQueryDesiredMedia_Video) = 2, All (PhoneCallHistoryEntryQueryDesiredMedia_All) = 4294967295,
}}
DEFINE_IID!(IID_IPhoneCallHistoryEntryQueryOptions, 2623529308, 35821, 16586, 176, 110, 196, 202, 142, 174, 92, 135);
RT_INTERFACE!{interface IPhoneCallHistoryEntryQueryOptions(IPhoneCallHistoryEntryQueryOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryEntryQueryOptions] {
    fn get_DesiredMedia(&self, out: *mut PhoneCallHistoryEntryQueryDesiredMedia) -> HRESULT,
    fn put_DesiredMedia(&self, value: PhoneCallHistoryEntryQueryDesiredMedia) -> HRESULT,
    fn get_SourceIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IPhoneCallHistoryEntryQueryOptions {
    #[inline] pub unsafe fn get_desired_media(&self) -> Result<PhoneCallHistoryEntryQueryDesiredMedia> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredMedia)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_media(&self, value: PhoneCallHistoryEntryQueryDesiredMedia) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredMedia)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallHistoryEntryQueryOptions: IPhoneCallHistoryEntryQueryOptions}
impl RtActivatable<IActivationFactory> for PhoneCallHistoryEntryQueryOptions {}
DEFINE_CLSID!(PhoneCallHistoryEntryQueryOptions(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,97,108,108,115,46,80,104,111,110,101,67,97,108,108,72,105,115,116,111,114,121,69,110,116,114,121,81,117,101,114,121,79,112,116,105,111,110,115,0]) [CLSID_PhoneCallHistoryEntryQueryOptions]);
RT_ENUM! { enum PhoneCallHistoryEntryRawAddressKind: i32 {
    PhoneNumber (PhoneCallHistoryEntryRawAddressKind_PhoneNumber) = 0, Custom (PhoneCallHistoryEntryRawAddressKind_Custom) = 1,
}}
DEFINE_IID!(IID_IPhoneCallHistoryEntryReader, 1642915006, 36230, 18335, 132, 4, 169, 132, 105, 32, 254, 230);
RT_INTERFACE!{interface IPhoneCallHistoryEntryReader(IPhoneCallHistoryEntryReaderVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryEntryReader] {
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<PhoneCallHistoryEntry>>) -> HRESULT
}}
impl IPhoneCallHistoryEntryReader {
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<PhoneCallHistoryEntry>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallHistoryEntryReader: IPhoneCallHistoryEntryReader}
RT_CLASS!{static class PhoneCallHistoryManager}
impl RtActivatable<IPhoneCallHistoryManagerStatics> for PhoneCallHistoryManager {}
impl RtActivatable<IPhoneCallHistoryManagerStatics2> for PhoneCallHistoryManager {}
impl PhoneCallHistoryManager {
    #[inline] pub fn request_store_async(accessType: PhoneCallHistoryStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PhoneCallHistoryStore>>> { unsafe {
        <Self as RtActivatable<IPhoneCallHistoryManagerStatics>>::get_activation_factory().request_store_async(accessType)
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<PhoneCallHistoryManagerForUser>> { unsafe {
        <Self as RtActivatable<IPhoneCallHistoryManagerStatics2>>::get_activation_factory().get_for_user(user)
    }}
}
DEFINE_CLSID!(PhoneCallHistoryManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,97,108,108,115,46,80,104,111,110,101,67,97,108,108,72,105,115,116,111,114,121,77,97,110,97,103,101,114,0]) [CLSID_PhoneCallHistoryManager]);
DEFINE_IID!(IID_IPhoneCallHistoryManagerForUser, 3643131171, 62815, 17235, 157, 180, 2, 5, 165, 38, 90, 85);
RT_INTERFACE!{interface IPhoneCallHistoryManagerForUser(IPhoneCallHistoryManagerForUserVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryManagerForUser] {
    fn RequestStoreAsync(&self, accessType: PhoneCallHistoryStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<PhoneCallHistoryStore>) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IPhoneCallHistoryManagerForUser {
    #[inline] pub unsafe fn request_store_async(&self, accessType: PhoneCallHistoryStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PhoneCallHistoryStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, accessType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallHistoryManagerForUser: IPhoneCallHistoryManagerForUser}
DEFINE_IID!(IID_IPhoneCallHistoryManagerStatics, 4121352761, 45855, 20293, 172, 142, 27, 8, 137, 60, 27, 80);
RT_INTERFACE!{static interface IPhoneCallHistoryManagerStatics(IPhoneCallHistoryManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryManagerStatics] {
    fn RequestStoreAsync(&self, accessType: PhoneCallHistoryStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<PhoneCallHistoryStore>) -> HRESULT
}}
impl IPhoneCallHistoryManagerStatics {
    #[inline] pub unsafe fn request_store_async(&self, accessType: PhoneCallHistoryStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PhoneCallHistoryStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, accessType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPhoneCallHistoryManagerStatics2, 4023678192, 41691, 16776, 158, 146, 188, 60, 250, 104, 19, 207);
RT_INTERFACE!{static interface IPhoneCallHistoryManagerStatics2(IPhoneCallHistoryManagerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryManagerStatics2] {
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut PhoneCallHistoryManagerForUser) -> HRESULT
}}
impl IPhoneCallHistoryManagerStatics2 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<PhoneCallHistoryManagerForUser>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum PhoneCallHistorySourceIdKind: i32 {
    CellularPhoneLineId (PhoneCallHistorySourceIdKind_CellularPhoneLineId) = 0, PackageFamilyName (PhoneCallHistorySourceIdKind_PackageFamilyName) = 1,
}}
DEFINE_IID!(IID_IPhoneCallHistoryStore, 797998520, 46094, 16939, 133, 69, 203, 25, 16, 166, 28, 82);
RT_INTERFACE!{interface IPhoneCallHistoryStore(IPhoneCallHistoryStoreVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallHistoryStore] {
    fn GetEntryAsync(&self, callHistoryEntryId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<PhoneCallHistoryEntry>) -> HRESULT,
    fn GetEntryReader(&self, out: *mut *mut PhoneCallHistoryEntryReader) -> HRESULT,
    fn GetEntryReaderWithOptions(&self, queryOptions: *mut PhoneCallHistoryEntryQueryOptions, out: *mut *mut PhoneCallHistoryEntryReader) -> HRESULT,
    fn SaveEntryAsync(&self, callHistoryEntry: *mut PhoneCallHistoryEntry, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteEntryAsync(&self, callHistoryEntry: *mut PhoneCallHistoryEntry, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteEntriesAsync(&self, callHistoryEntries: *mut super::super::foundation::collections::IIterable<PhoneCallHistoryEntry>, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn MarkEntryAsSeenAsync(&self, callHistoryEntry: *mut PhoneCallHistoryEntry, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn MarkEntriesAsSeenAsync(&self, callHistoryEntries: *mut super::super::foundation::collections::IIterable<PhoneCallHistoryEntry>, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetUnseenCountAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<u32>) -> HRESULT,
    fn MarkAllAsSeenAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetSourcesUnseenCountAsync(&self, sourceIds: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<u32>) -> HRESULT,
    fn MarkSourcesAsSeenAsync(&self, sourceIds: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IPhoneCallHistoryStore {
    #[inline] pub unsafe fn get_entry_async(&self, callHistoryEntryId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PhoneCallHistoryEntry>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEntryAsync)(self as *const _ as *mut _, callHistoryEntryId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_entry_reader(&self) -> Result<ComPtr<PhoneCallHistoryEntryReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEntryReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_entry_reader_with_options(&self, queryOptions: &PhoneCallHistoryEntryQueryOptions) -> Result<ComPtr<PhoneCallHistoryEntryReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEntryReaderWithOptions)(self as *const _ as *mut _, queryOptions as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_entry_async(&self, callHistoryEntry: &PhoneCallHistoryEntry) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveEntryAsync)(self as *const _ as *mut _, callHistoryEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_entry_async(&self, callHistoryEntry: &PhoneCallHistoryEntry) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteEntryAsync)(self as *const _ as *mut _, callHistoryEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_entries_async(&self, callHistoryEntries: &super::super::foundation::collections::IIterable<PhoneCallHistoryEntry>) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteEntriesAsync)(self as *const _ as *mut _, callHistoryEntries as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_entry_as_seen_async(&self, callHistoryEntry: &PhoneCallHistoryEntry) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkEntryAsSeenAsync)(self as *const _ as *mut _, callHistoryEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_entries_as_seen_async(&self, callHistoryEntries: &super::super::foundation::collections::IIterable<PhoneCallHistoryEntry>) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkEntriesAsSeenAsync)(self as *const _ as *mut _, callHistoryEntries as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unseen_count_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetUnseenCountAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_all_as_seen_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkAllAsSeenAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sources_unseen_count_async(&self, sourceIds: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSourcesUnseenCountAsync)(self as *const _ as *mut _, sourceIds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_sources_as_seen_async(&self, sourceIds: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkSourcesAsSeenAsync)(self as *const _ as *mut _, sourceIds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallHistoryStore: IPhoneCallHistoryStore}
RT_ENUM! { enum PhoneCallHistoryStoreAccessType: i32 {
    AppEntriesReadWrite (PhoneCallHistoryStoreAccessType_AppEntriesReadWrite) = 0, AllEntriesLimitedReadWrite (PhoneCallHistoryStoreAccessType_AllEntriesLimitedReadWrite) = 1, AllEntriesReadWrite (PhoneCallHistoryStoreAccessType_AllEntriesReadWrite) = 2,
}}
DEFINE_IID!(IID_IVoipCallCoordinator, 1326549967, 59631, 17460, 156, 95, 168, 216, 147, 250, 254, 121);
RT_INTERFACE!{interface IVoipCallCoordinator(IVoipCallCoordinatorVtbl): IInspectable(IInspectableVtbl) [IID_IVoipCallCoordinator] {
    fn ReserveCallResourcesAsync(&self, taskEntryPoint: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<VoipPhoneCallResourceReservationStatus>) -> HRESULT,
    fn add_MuteStateChanged(&self, muteChangeHandler: *mut super::super::foundation::TypedEventHandler<VoipCallCoordinator, MuteChangeEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MuteStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn RequestNewIncomingCall(&self, context: HSTRING, contactName: HSTRING, contactNumber: HSTRING, contactImage: *mut super::super::foundation::Uri, serviceName: HSTRING, brandingImage: *mut super::super::foundation::Uri, callDetails: HSTRING, ringtone: *mut super::super::foundation::Uri, media: VoipPhoneCallMedia, ringTimeout: super::super::foundation::TimeSpan, out: *mut *mut VoipPhoneCall) -> HRESULT,
    fn RequestNewOutgoingCall(&self, context: HSTRING, contactName: HSTRING, serviceName: HSTRING, media: VoipPhoneCallMedia, out: *mut *mut VoipPhoneCall) -> HRESULT,
    fn NotifyMuted(&self) -> HRESULT,
    fn NotifyUnmuted(&self) -> HRESULT,
    fn RequestOutgoingUpgradeToVideoCall(&self, callUpgradeGuid: Guid, context: HSTRING, contactName: HSTRING, serviceName: HSTRING, out: *mut *mut VoipPhoneCall) -> HRESULT,
    fn RequestIncomingUpgradeToVideoCall(&self, context: HSTRING, contactName: HSTRING, contactNumber: HSTRING, contactImage: *mut super::super::foundation::Uri, serviceName: HSTRING, brandingImage: *mut super::super::foundation::Uri, callDetails: HSTRING, ringtone: *mut super::super::foundation::Uri, ringTimeout: super::super::foundation::TimeSpan, out: *mut *mut VoipPhoneCall) -> HRESULT,
    fn TerminateCellularCall(&self, callUpgradeGuid: Guid) -> HRESULT,
    fn CancelUpgrade(&self, callUpgradeGuid: Guid) -> HRESULT
}}
impl IVoipCallCoordinator {
    #[inline] pub unsafe fn reserve_call_resources_async(&self, taskEntryPoint: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<VoipPhoneCallResourceReservationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReserveCallResourcesAsync)(self as *const _ as *mut _, taskEntryPoint.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_mute_state_changed(&self, muteChangeHandler: &super::super::foundation::TypedEventHandler<VoipCallCoordinator, MuteChangeEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MuteStateChanged)(self as *const _ as *mut _, muteChangeHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_mute_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MuteStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_new_incoming_call(&self, context: &HStringArg, contactName: &HStringArg, contactNumber: &HStringArg, contactImage: &super::super::foundation::Uri, serviceName: &HStringArg, brandingImage: &super::super::foundation::Uri, callDetails: &HStringArg, ringtone: &super::super::foundation::Uri, media: VoipPhoneCallMedia, ringTimeout: super::super::foundation::TimeSpan) -> Result<ComPtr<VoipPhoneCall>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestNewIncomingCall)(self as *const _ as *mut _, context.get(), contactName.get(), contactNumber.get(), contactImage as *const _ as *mut _, serviceName.get(), brandingImage as *const _ as *mut _, callDetails.get(), ringtone as *const _ as *mut _, media, ringTimeout, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_new_outgoing_call(&self, context: &HStringArg, contactName: &HStringArg, serviceName: &HStringArg, media: VoipPhoneCallMedia) -> Result<ComPtr<VoipPhoneCall>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestNewOutgoingCall)(self as *const _ as *mut _, context.get(), contactName.get(), serviceName.get(), media, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_muted(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyMuted)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_unmuted(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyUnmuted)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_outgoing_upgrade_to_video_call(&self, callUpgradeGuid: Guid, context: &HStringArg, contactName: &HStringArg, serviceName: &HStringArg) -> Result<ComPtr<VoipPhoneCall>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestOutgoingUpgradeToVideoCall)(self as *const _ as *mut _, callUpgradeGuid, context.get(), contactName.get(), serviceName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_incoming_upgrade_to_video_call(&self, context: &HStringArg, contactName: &HStringArg, contactNumber: &HStringArg, contactImage: &super::super::foundation::Uri, serviceName: &HStringArg, brandingImage: &super::super::foundation::Uri, callDetails: &HStringArg, ringtone: &super::super::foundation::Uri, ringTimeout: super::super::foundation::TimeSpan) -> Result<ComPtr<VoipPhoneCall>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestIncomingUpgradeToVideoCall)(self as *const _ as *mut _, context.get(), contactName.get(), contactNumber.get(), contactImage as *const _ as *mut _, serviceName.get(), brandingImage as *const _ as *mut _, callDetails.get(), ringtone as *const _ as *mut _, ringTimeout, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn terminate_cellular_call(&self, callUpgradeGuid: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).TerminateCellularCall)(self as *const _ as *mut _, callUpgradeGuid);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn cancel_upgrade(&self, callUpgradeGuid: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).CancelUpgrade)(self as *const _ as *mut _, callUpgradeGuid);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VoipCallCoordinator: IVoipCallCoordinator}
impl RtActivatable<IVoipCallCoordinatorStatics> for VoipCallCoordinator {}
impl VoipCallCoordinator {
    #[inline] pub fn get_default() -> Result<ComPtr<VoipCallCoordinator>> { unsafe {
        <Self as RtActivatable<IVoipCallCoordinatorStatics>>::get_activation_factory().get_default()
    }}
}
DEFINE_CLSID!(VoipCallCoordinator(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,97,108,108,115,46,86,111,105,112,67,97,108,108,67,111,111,114,100,105,110,97,116,111,114,0]) [CLSID_VoipCallCoordinator]);
DEFINE_IID!(IID_IVoipCallCoordinator2, 3199511027, 50948, 16948, 137, 206, 232, 140, 192, 210, 143, 190);
RT_INTERFACE!{interface IVoipCallCoordinator2(IVoipCallCoordinator2Vtbl): IInspectable(IInspectableVtbl) [IID_IVoipCallCoordinator2] {
    fn SetupNewAcceptedCall(&self, context: HSTRING, contactName: HSTRING, contactNumber: HSTRING, serviceName: HSTRING, media: VoipPhoneCallMedia, out: *mut *mut VoipPhoneCall) -> HRESULT
}}
impl IVoipCallCoordinator2 {
    #[inline] pub unsafe fn setup_new_accepted_call(&self, context: &HStringArg, contactName: &HStringArg, contactNumber: &HStringArg, serviceName: &HStringArg, media: VoipPhoneCallMedia) -> Result<ComPtr<VoipPhoneCall>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetupNewAcceptedCall)(self as *const _ as *mut _, context.get(), contactName.get(), contactNumber.get(), serviceName.get(), media, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVoipCallCoordinatorStatics, 2136809259, 57418, 19728, 179, 26, 165, 92, 146, 44, 194, 251);
RT_INTERFACE!{static interface IVoipCallCoordinatorStatics(IVoipCallCoordinatorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IVoipCallCoordinatorStatics] {
    fn GetDefault(&self, out: *mut *mut VoipCallCoordinator) -> HRESULT
}}
impl IVoipCallCoordinatorStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<VoipCallCoordinator>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVoipPhoneCall, 1827795354, 30612, 19034, 140, 104, 174, 135, 148, 122, 105, 144);
RT_INTERFACE!{interface IVoipPhoneCall(IVoipPhoneCallVtbl): IInspectable(IInspectableVtbl) [IID_IVoipPhoneCall] {
    fn add_EndRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<VoipPhoneCall, CallStateChangeEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EndRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_HoldRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<VoipPhoneCall, CallStateChangeEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HoldRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ResumeRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<VoipPhoneCall, CallStateChangeEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ResumeRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AnswerRequested(&self, acceptHandler: *mut super::super::foundation::TypedEventHandler<VoipPhoneCall, CallAnswerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AnswerRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RejectRequested(&self, rejectHandler: *mut super::super::foundation::TypedEventHandler<VoipPhoneCall, CallRejectEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RejectRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn NotifyCallHeld(&self) -> HRESULT,
    fn NotifyCallActive(&self) -> HRESULT,
    fn NotifyCallEnded(&self) -> HRESULT,
    fn get_ContactName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ContactName(&self, value: HSTRING) -> HRESULT,
    fn get_StartTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_StartTime(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_CallMedia(&self, out: *mut VoipPhoneCallMedia) -> HRESULT,
    fn put_CallMedia(&self, value: VoipPhoneCallMedia) -> HRESULT,
    fn NotifyCallReady(&self) -> HRESULT
}}
impl IVoipPhoneCall {
    #[inline] pub unsafe fn add_end_requested(&self, handler: &super::super::foundation::TypedEventHandler<VoipPhoneCall, CallStateChangeEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EndRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_end_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EndRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hold_requested(&self, handler: &super::super::foundation::TypedEventHandler<VoipPhoneCall, CallStateChangeEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HoldRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hold_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HoldRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_resume_requested(&self, handler: &super::super::foundation::TypedEventHandler<VoipPhoneCall, CallStateChangeEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ResumeRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resume_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ResumeRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_answer_requested(&self, acceptHandler: &super::super::foundation::TypedEventHandler<VoipPhoneCall, CallAnswerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AnswerRequested)(self as *const _ as *mut _, acceptHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_answer_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AnswerRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_reject_requested(&self, rejectHandler: &super::super::foundation::TypedEventHandler<VoipPhoneCall, CallRejectEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RejectRequested)(self as *const _ as *mut _, rejectHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_reject_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RejectRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_call_held(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyCallHeld)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_call_active(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyCallActive)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_call_ended(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyCallEnded)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_contact_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContactName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_call_media(&self) -> Result<VoipPhoneCallMedia> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CallMedia)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_call_media(&self, value: VoipPhoneCallMedia) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CallMedia)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_call_ready(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyCallReady)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VoipPhoneCall: IVoipPhoneCall}
DEFINE_IID!(IID_IVoipPhoneCall2, 1947944673, 9311, 16883, 147, 153, 49, 65, 210, 91, 82, 227);
RT_INTERFACE!{interface IVoipPhoneCall2(IVoipPhoneCall2Vtbl): IInspectable(IInspectableVtbl) [IID_IVoipPhoneCall2] {
    fn TryShowAppUI(&self) -> HRESULT
}}
impl IVoipPhoneCall2 {
    #[inline] pub unsafe fn try_show_app_ui(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).TryShowAppUI)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum VoipPhoneCallMedia: u32 {
    None (VoipPhoneCallMedia_None) = 0, Audio (VoipPhoneCallMedia_Audio) = 1, Video (VoipPhoneCallMedia_Video) = 2,
}}
RT_ENUM! { enum VoipPhoneCallRejectReason: i32 {
    UserIgnored (VoipPhoneCallRejectReason_UserIgnored) = 0, TimedOut (VoipPhoneCallRejectReason_TimedOut) = 1, OtherIncomingCall (VoipPhoneCallRejectReason_OtherIncomingCall) = 2, EmergencyCallExists (VoipPhoneCallRejectReason_EmergencyCallExists) = 3, InvalidCallState (VoipPhoneCallRejectReason_InvalidCallState) = 4,
}}
RT_ENUM! { enum VoipPhoneCallResourceReservationStatus: i32 {
    Success (VoipPhoneCallResourceReservationStatus_Success) = 0, ResourcesNotAvailable (VoipPhoneCallResourceReservationStatus_ResourcesNotAvailable) = 1,
}}
RT_ENUM! { enum VoipPhoneCallState: i32 {
    Ended (VoipPhoneCallState_Ended) = 0, Held (VoipPhoneCallState_Held) = 1, Active (VoipPhoneCallState_Active) = 2, Incoming (VoipPhoneCallState_Incoming) = 3, Outgoing (VoipPhoneCallState_Outgoing) = 4,
}}
pub mod background { // Windows.ApplicationModel.Calls.Background
use ::prelude::*;
RT_ENUM! { enum PhoneCallBlockedReason: i32 {
    InCallBlockingList (PhoneCallBlockedReason_InCallBlockingList) = 0, PrivateNumber (PhoneCallBlockedReason_PrivateNumber) = 1, UnknownNumber (PhoneCallBlockedReason_UnknownNumber) = 2,
}}
DEFINE_IID!(IID_IPhoneCallBlockedTriggerDetails, 2762379426, 58561, 17023, 134, 78, 228, 112, 71, 125, 219, 103);
RT_INTERFACE!{interface IPhoneCallBlockedTriggerDetails(IPhoneCallBlockedTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallBlockedTriggerDetails] {
    fn get_PhoneNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_LineId(&self, out: *mut Guid) -> HRESULT,
    fn get_CallBlockedReason(&self, out: *mut PhoneCallBlockedReason) -> HRESULT
}}
impl IPhoneCallBlockedTriggerDetails {
    #[inline] pub unsafe fn get_phone_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_call_blocked_reason(&self) -> Result<PhoneCallBlockedReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CallBlockedReason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallBlockedTriggerDetails: IPhoneCallBlockedTriggerDetails}
DEFINE_IID!(IID_IPhoneCallOriginDataRequestTriggerDetails, 1855675199, 50507, 20098, 76, 201, 227, 41, 164, 24, 69, 146);
RT_INTERFACE!{interface IPhoneCallOriginDataRequestTriggerDetails(IPhoneCallOriginDataRequestTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneCallOriginDataRequestTriggerDetails] {
    fn get_RequestId(&self, out: *mut Guid) -> HRESULT,
    fn get_PhoneNumber(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPhoneCallOriginDataRequestTriggerDetails {
    #[inline] pub unsafe fn get_request_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneCallOriginDataRequestTriggerDetails: IPhoneCallOriginDataRequestTriggerDetails}
DEFINE_IID!(IID_IPhoneLineChangedTriggerDetails, 3335725543, 53533, 16600, 178, 183, 228, 10, 1, 214, 98, 73);
RT_INTERFACE!{interface IPhoneLineChangedTriggerDetails(IPhoneLineChangedTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneLineChangedTriggerDetails] {
    fn get_LineId(&self, out: *mut Guid) -> HRESULT,
    fn get_ChangeType(&self, out: *mut PhoneLineChangeKind) -> HRESULT,
    fn HasLinePropertyChanged(&self, lineProperty: PhoneLineProperties, out: *mut bool) -> HRESULT
}}
impl IPhoneLineChangedTriggerDetails {
    #[inline] pub unsafe fn get_line_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_change_type(&self) -> Result<PhoneLineChangeKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChangeType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn has_line_property_changed(&self, lineProperty: PhoneLineProperties) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).HasLinePropertyChanged)(self as *const _ as *mut _, lineProperty, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneLineChangedTriggerDetails: IPhoneLineChangedTriggerDetails}
RT_ENUM! { enum PhoneLineChangeKind: i32 {
    Added (PhoneLineChangeKind_Added) = 0, Removed (PhoneLineChangeKind_Removed) = 1, PropertiesChanged (PhoneLineChangeKind_PropertiesChanged) = 2,
}}
RT_ENUM! { enum PhoneLineProperties: u32 {
    None (PhoneLineProperties_None) = 0, BrandingOptions (PhoneLineProperties_BrandingOptions) = 1, CanDial (PhoneLineProperties_CanDial) = 2, CellularDetails (PhoneLineProperties_CellularDetails) = 4, DisplayColor (PhoneLineProperties_DisplayColor) = 8, DisplayName (PhoneLineProperties_DisplayName) = 16, NetworkName (PhoneLineProperties_NetworkName) = 32, NetworkState (PhoneLineProperties_NetworkState) = 64, Transport (PhoneLineProperties_Transport) = 128, Voicemail (PhoneLineProperties_Voicemail) = 256,
}}
DEFINE_IID!(IID_IPhoneNewVoicemailMessageTriggerDetails, 329826331, 47153, 18643, 139, 169, 141, 34, 166, 88, 13, 207);
RT_INTERFACE!{interface IPhoneNewVoicemailMessageTriggerDetails(IPhoneNewVoicemailMessageTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneNewVoicemailMessageTriggerDetails] {
    fn get_LineId(&self, out: *mut Guid) -> HRESULT,
    fn get_VoicemailCount(&self, out: *mut i32) -> HRESULT,
    fn get_OperatorMessage(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPhoneNewVoicemailMessageTriggerDetails {
    #[inline] pub unsafe fn get_line_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_voicemail_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VoicemailCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_operator_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OperatorMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneNewVoicemailMessageTriggerDetails: IPhoneNewVoicemailMessageTriggerDetails}
RT_ENUM! { enum PhoneTriggerType: i32 {
    NewVoicemailMessage (PhoneTriggerType_NewVoicemailMessage) = 0, CallHistoryChanged (PhoneTriggerType_CallHistoryChanged) = 1, LineChanged (PhoneTriggerType_LineChanged) = 2, AirplaneModeDisabledForEmergencyCall (PhoneTriggerType_AirplaneModeDisabledForEmergencyCall) = 3, CallOriginDataRequest (PhoneTriggerType_CallOriginDataRequest) = 4, CallBlocked (PhoneTriggerType_CallBlocked) = 5,
}}
} // Windows.ApplicationModel.Calls.Background
} // Windows.ApplicationModel.Calls
pub mod socialinfo { // Windows.ApplicationModel.SocialInfo
use ::prelude::*;
DEFINE_IID!(IID_ISocialFeedChildItem, 191535194, 54685, 16574, 152, 12, 72, 138, 42, 179, 10, 131);
RT_INTERFACE!{interface ISocialFeedChildItem(ISocialFeedChildItemVtbl): IInspectable(IInspectableVtbl) [IID_ISocialFeedChildItem] {
    fn get_Author(&self, out: *mut *mut SocialUserInfo) -> HRESULT,
    fn get_PrimaryContent(&self, out: *mut *mut SocialFeedContent) -> HRESULT,
    fn get_SecondaryContent(&self, out: *mut *mut SocialFeedContent) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_Timestamp(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_TargetUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Thumbnails(&self, out: *mut *mut super::super::foundation::collections::IVector<SocialItemThumbnail>) -> HRESULT,
    fn get_SharedItem(&self, out: *mut *mut SocialFeedSharedItem) -> HRESULT,
    fn put_SharedItem(&self, value: *mut SocialFeedSharedItem) -> HRESULT
}}
impl ISocialFeedChildItem {
    #[inline] pub unsafe fn get_author(&self) -> Result<ComPtr<SocialUserInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Author)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_content(&self) -> Result<ComPtr<SocialFeedContent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryContent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_content(&self) -> Result<ComPtr<SocialFeedContent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryContent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_timestamp(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Timestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnails(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<SocialItemThumbnail>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_shared_item(&self) -> Result<ComPtr<SocialFeedSharedItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SharedItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_shared_item(&self, value: &SocialFeedSharedItem) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharedItem)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SocialFeedChildItem: ISocialFeedChildItem}
impl RtActivatable<IActivationFactory> for SocialFeedChildItem {}
DEFINE_CLSID!(SocialFeedChildItem(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,111,99,105,97,108,73,110,102,111,46,83,111,99,105,97,108,70,101,101,100,67,104,105,108,100,73,116,101,109,0]) [CLSID_SocialFeedChildItem]);
DEFINE_IID!(IID_ISocialFeedContent, 2721375273, 15929, 18765, 163, 124, 244, 98, 162, 73, 69, 20);
RT_INTERFACE!{interface ISocialFeedContent(ISocialFeedContentVtbl): IInspectable(IInspectableVtbl) [IID_ISocialFeedContent] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Message(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Message(&self, value: HSTRING) -> HRESULT,
    fn get_TargetUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT
}}
impl ISocialFeedContent {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_message(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Message)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SocialFeedContent: ISocialFeedContent}
DEFINE_IID!(IID_ISocialFeedItem, 1326682795, 8050, 19763, 182, 149, 222, 62, 29, 182, 3, 23);
RT_INTERFACE!{interface ISocialFeedItem(ISocialFeedItemVtbl): IInspectable(IInspectableVtbl) [IID_ISocialFeedItem] {
    fn get_Author(&self, out: *mut *mut SocialUserInfo) -> HRESULT,
    fn get_PrimaryContent(&self, out: *mut *mut SocialFeedContent) -> HRESULT,
    fn get_SecondaryContent(&self, out: *mut *mut SocialFeedContent) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_Timestamp(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_TargetUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Thumbnails(&self, out: *mut *mut super::super::foundation::collections::IVector<SocialItemThumbnail>) -> HRESULT,
    fn get_SharedItem(&self, out: *mut *mut SocialFeedSharedItem) -> HRESULT,
    fn put_SharedItem(&self, value: *mut SocialFeedSharedItem) -> HRESULT,
    fn get_BadgeStyle(&self, out: *mut SocialItemBadgeStyle) -> HRESULT,
    fn put_BadgeStyle(&self, value: SocialItemBadgeStyle) -> HRESULT,
    fn get_BadgeCountValue(&self, out: *mut i32) -> HRESULT,
    fn put_BadgeCountValue(&self, value: i32) -> HRESULT,
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    fn get_ChildItem(&self, out: *mut *mut SocialFeedChildItem) -> HRESULT,
    fn put_ChildItem(&self, value: *mut SocialFeedChildItem) -> HRESULT,
    fn get_Style(&self, out: *mut SocialFeedItemStyle) -> HRESULT,
    fn put_Style(&self, value: SocialFeedItemStyle) -> HRESULT
}}
impl ISocialFeedItem {
    #[inline] pub unsafe fn get_author(&self) -> Result<ComPtr<SocialUserInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Author)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_content(&self) -> Result<ComPtr<SocialFeedContent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryContent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_content(&self) -> Result<ComPtr<SocialFeedContent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryContent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_timestamp(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Timestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnails(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<SocialItemThumbnail>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_shared_item(&self) -> Result<ComPtr<SocialFeedSharedItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SharedItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_shared_item(&self, value: &SocialFeedSharedItem) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharedItem)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_badge_style(&self) -> Result<SocialItemBadgeStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BadgeStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_badge_style(&self, value: SocialItemBadgeStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BadgeStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_badge_count_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BadgeCountValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_badge_count_value(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BadgeCountValue)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_child_item(&self) -> Result<ComPtr<SocialFeedChildItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChildItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_child_item(&self, value: &SocialFeedChildItem) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChildItem)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_style(&self) -> Result<SocialFeedItemStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Style)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_style(&self, value: SocialFeedItemStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Style)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SocialFeedItem: ISocialFeedItem}
impl RtActivatable<IActivationFactory> for SocialFeedItem {}
DEFINE_CLSID!(SocialFeedItem(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,111,99,105,97,108,73,110,102,111,46,83,111,99,105,97,108,70,101,101,100,73,116,101,109,0]) [CLSID_SocialFeedItem]);
RT_ENUM! { enum SocialFeedItemStyle: i32 {
    Default (SocialFeedItemStyle_Default) = 0, Photo (SocialFeedItemStyle_Photo) = 1,
}}
RT_ENUM! { enum SocialFeedKind: i32 {
    HomeFeed (SocialFeedKind_HomeFeed) = 0, ContactFeed (SocialFeedKind_ContactFeed) = 1, Dashboard (SocialFeedKind_Dashboard) = 2,
}}
DEFINE_IID!(IID_ISocialFeedSharedItem, 2080087616, 42666, 17831, 159, 246, 84, 196, 33, 5, 221, 31);
RT_INTERFACE!{interface ISocialFeedSharedItem(ISocialFeedSharedItemVtbl): IInspectable(IInspectableVtbl) [IID_ISocialFeedSharedItem] {
    fn get_OriginalSource(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_OriginalSource(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Content(&self, out: *mut *mut SocialFeedContent) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_Timestamp(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_TargetUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Thumbnail(&self, value: *mut SocialItemThumbnail) -> HRESULT,
    fn get_Thumbnail(&self, out: *mut *mut SocialItemThumbnail) -> HRESULT
}}
impl ISocialFeedSharedItem {
    #[inline] pub unsafe fn get_original_source(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OriginalSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_original_source(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OriginalSource)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<SocialFeedContent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_timestamp(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Timestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_thumbnail(&self, value: &SocialItemThumbnail) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Thumbnail)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<SocialItemThumbnail>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SocialFeedSharedItem: ISocialFeedSharedItem}
impl RtActivatable<IActivationFactory> for SocialFeedSharedItem {}
DEFINE_CLSID!(SocialFeedSharedItem(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,111,99,105,97,108,73,110,102,111,46,83,111,99,105,97,108,70,101,101,100,83,104,97,114,101,100,73,116,101,109,0]) [CLSID_SocialFeedSharedItem]);
RT_ENUM! { enum SocialFeedUpdateMode: i32 {
    Append (SocialFeedUpdateMode_Append) = 0, Replace (SocialFeedUpdateMode_Replace) = 1,
}}
RT_ENUM! { enum SocialItemBadgeStyle: i32 {
    Hidden (SocialItemBadgeStyle_Hidden) = 0, Visible (SocialItemBadgeStyle_Visible) = 1, VisibleWithCount (SocialItemBadgeStyle_VisibleWithCount) = 2,
}}
DEFINE_IID!(IID_ISocialItemThumbnail, 1556054810, 16136, 18815, 145, 127, 87, 224, 157, 132, 177, 65);
RT_INTERFACE!{interface ISocialItemThumbnail(ISocialItemThumbnailVtbl): IInspectable(IInspectableVtbl) [IID_ISocialItemThumbnail] {
    fn get_TargetUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_ImageUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_ImageUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-graphics")] fn get_BitmapSize(&self, out: *mut super::super::graphics::imaging::BitmapSize) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-graphics")] fn put_BitmapSize(&self, value: super::super::graphics::imaging::BitmapSize) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SetImageAsync(&self, image: *mut super::super::storage::streams::IInputStream, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ISocialItemThumbnail {
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_image_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ImageUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_image_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ImageUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_bitmap_size(&self) -> Result<super::super::graphics::imaging::BitmapSize> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BitmapSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn set_bitmap_size(&self, value: super::super::graphics::imaging::BitmapSize) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BitmapSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_image_async(&self, image: &super::super::storage::streams::IInputStream) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetImageAsync)(self as *const _ as *mut _, image as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SocialItemThumbnail: ISocialItemThumbnail}
impl RtActivatable<IActivationFactory> for SocialItemThumbnail {}
DEFINE_CLSID!(SocialItemThumbnail(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,111,99,105,97,108,73,110,102,111,46,83,111,99,105,97,108,73,116,101,109,84,104,117,109,98,110,97,105,108,0]) [CLSID_SocialItemThumbnail]);
DEFINE_IID!(IID_ISocialUserInfo, 2656967633, 37072, 19997, 149, 84, 132, 77, 70, 96, 127, 97);
RT_INTERFACE!{interface ISocialUserInfo(ISocialUserInfoVtbl): IInspectable(IInspectableVtbl) [IID_ISocialUserInfo] {
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_UserName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_UserName(&self, value: HSTRING) -> HRESULT,
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    fn get_TargetUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT
}}
impl ISocialUserInfo {
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_user_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UserName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SocialUserInfo: ISocialUserInfo}
pub mod provider { // Windows.ApplicationModel.SocialInfo.Provider
use ::prelude::*;
DEFINE_IID!(IID_ISocialDashboardItemUpdater, 1021222345, 18432, 18125, 134, 155, 25, 115, 236, 104, 91, 222);
RT_INTERFACE!{interface ISocialDashboardItemUpdater(ISocialDashboardItemUpdaterVtbl): IInspectable(IInspectableVtbl) [IID_ISocialDashboardItemUpdater] {
    fn get_OwnerRemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Content(&self, out: *mut *mut super::SocialFeedContent) -> HRESULT,
    fn get_Timestamp(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_Timestamp(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_Thumbnail(&self, value: *mut super::SocialItemThumbnail) -> HRESULT,
    fn get_Thumbnail(&self, out: *mut *mut super::SocialItemThumbnail) -> HRESULT,
    fn CommitAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn get_TargetUri(&self, out: *mut *mut ::rt::gen::windows::foundation::Uri) -> HRESULT,
    fn put_TargetUri(&self, value: *mut ::rt::gen::windows::foundation::Uri) -> HRESULT
}}
impl ISocialDashboardItemUpdater {
    #[inline] pub unsafe fn get_owner_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OwnerRemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<super::SocialFeedContent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_timestamp(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Timestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_thumbnail(&self, value: &super::SocialItemThumbnail) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Thumbnail)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<super::SocialItemThumbnail>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn commit_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CommitAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_uri(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_uri(&self, value: &::rt::gen::windows::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SocialDashboardItemUpdater: ISocialDashboardItemUpdater}
DEFINE_IID!(IID_ISocialFeedUpdater, 2047609511, 60809, 19413, 168, 217, 21, 244, 217, 134, 28, 16);
RT_INTERFACE!{interface ISocialFeedUpdater(ISocialFeedUpdaterVtbl): IInspectable(IInspectableVtbl) [IID_ISocialFeedUpdater] {
    fn get_OwnerRemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Kind(&self, out: *mut super::SocialFeedKind) -> HRESULT,
    fn get_Items(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<super::SocialFeedItem>) -> HRESULT,
    fn CommitAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl ISocialFeedUpdater {
    #[inline] pub unsafe fn get_owner_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OwnerRemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<super::SocialFeedKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_items(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<super::SocialFeedItem>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Items)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn commit_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CommitAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SocialFeedUpdater: ISocialFeedUpdater}
RT_CLASS!{static class SocialInfoProviderManager}
impl RtActivatable<ISocialInfoProviderManagerStatics> for SocialInfoProviderManager {}
impl SocialInfoProviderManager {
    #[inline] pub fn create_social_feed_updater_async(kind: super::SocialFeedKind, mode: super::SocialFeedUpdateMode, ownerRemoteId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<SocialFeedUpdater>>> { unsafe {
        <Self as RtActivatable<ISocialInfoProviderManagerStatics>>::get_activation_factory().create_social_feed_updater_async(kind, mode, ownerRemoteId)
    }}
    #[inline] pub fn create_dashboard_item_updater_async(ownerRemoteId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<SocialDashboardItemUpdater>>> { unsafe {
        <Self as RtActivatable<ISocialInfoProviderManagerStatics>>::get_activation_factory().create_dashboard_item_updater_async(ownerRemoteId)
    }}
    #[inline] pub fn update_badge_count_value(itemRemoteId: &HStringArg, newCount: i32) -> Result<()> { unsafe {
        <Self as RtActivatable<ISocialInfoProviderManagerStatics>>::get_activation_factory().update_badge_count_value(itemRemoteId, newCount)
    }}
    #[inline] pub fn report_new_content_available(contactRemoteId: &HStringArg, kind: super::SocialFeedKind) -> Result<()> { unsafe {
        <Self as RtActivatable<ISocialInfoProviderManagerStatics>>::get_activation_factory().report_new_content_available(contactRemoteId, kind)
    }}
    #[inline] pub fn provision_async() -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<ISocialInfoProviderManagerStatics>>::get_activation_factory().provision_async()
    }}
    #[inline] pub fn deprovision_async() -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<ISocialInfoProviderManagerStatics>>::get_activation_factory().deprovision_async()
    }}
}
DEFINE_CLSID!(SocialInfoProviderManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,111,99,105,97,108,73,110,102,111,46,80,114,111,118,105,100,101,114,46,83,111,99,105,97,108,73,110,102,111,80,114,111,118,105,100,101,114,77,97,110,97,103,101,114,0]) [CLSID_SocialInfoProviderManager]);
DEFINE_IID!(IID_ISocialInfoProviderManagerStatics, 461956395, 30599, 18646, 170, 18, 216, 232, 244, 122, 184, 90);
RT_INTERFACE!{static interface ISocialInfoProviderManagerStatics(ISocialInfoProviderManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISocialInfoProviderManagerStatics] {
    fn CreateSocialFeedUpdaterAsync(&self, kind: super::SocialFeedKind, mode: super::SocialFeedUpdateMode, ownerRemoteId: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<SocialFeedUpdater>) -> HRESULT,
    fn CreateDashboardItemUpdaterAsync(&self, ownerRemoteId: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<SocialDashboardItemUpdater>) -> HRESULT,
    fn UpdateBadgeCountValue(&self, itemRemoteId: HSTRING, newCount: i32) -> HRESULT,
    fn ReportNewContentAvailable(&self, contactRemoteId: HSTRING, kind: super::SocialFeedKind) -> HRESULT,
    fn ProvisionAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn DeprovisionAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl ISocialInfoProviderManagerStatics {
    #[inline] pub unsafe fn create_social_feed_updater_async(&self, kind: super::SocialFeedKind, mode: super::SocialFeedUpdateMode, ownerRemoteId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<SocialFeedUpdater>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSocialFeedUpdaterAsync)(self as *const _ as *mut _, kind, mode, ownerRemoteId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_dashboard_item_updater_async(&self, ownerRemoteId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<SocialDashboardItemUpdater>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDashboardItemUpdaterAsync)(self as *const _ as *mut _, ownerRemoteId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn update_badge_count_value(&self, itemRemoteId: &HStringArg, newCount: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).UpdateBadgeCountValue)(self as *const _ as *mut _, itemRemoteId.get(), newCount);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_new_content_available(&self, contactRemoteId: &HStringArg, kind: super::SocialFeedKind) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportNewContentAvailable)(self as *const _ as *mut _, contactRemoteId.get(), kind);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn provision_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ProvisionAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn deprovision_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeprovisionAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.ApplicationModel.SocialInfo.Provider
} // Windows.ApplicationModel.SocialInfo
pub mod search { // Windows.ApplicationModel.Search
use ::prelude::*;
DEFINE_IID!(IID_ILocalContentSuggestionSettings, 4004425826, 29757, 17774, 132, 163, 35, 240, 111, 45, 21, 215);
RT_INTERFACE!{interface ILocalContentSuggestionSettings(ILocalContentSuggestionSettingsVtbl): IInspectable(IInspectableVtbl) [IID_ILocalContentSuggestionSettings] {
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Locations(&self, out: *mut *mut super::super::foundation::collections::IVector<super::super::storage::StorageFolder>) -> HRESULT,
    fn put_AqsFilter(&self, value: HSTRING) -> HRESULT,
    fn get_AqsFilter(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PropertiesToMatch(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl ILocalContentSuggestionSettings {
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_locations(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::super::storage::StorageFolder>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Locations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_aqs_filter(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AqsFilter)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_aqs_filter(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AqsFilter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties_to_match(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PropertiesToMatch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LocalContentSuggestionSettings: ILocalContentSuggestionSettings}
impl RtActivatable<IActivationFactory> for LocalContentSuggestionSettings {}
DEFINE_CLSID!(LocalContentSuggestionSettings(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,101,97,114,99,104,46,76,111,99,97,108,67,111,110,116,101,110,116,83,117,103,103,101,115,116,105,111,110,83,101,116,116,105,110,103,115,0]) [CLSID_LocalContentSuggestionSettings]);
DEFINE_IID!(IID_ISearchPane, 4255968312, 14080, 19827, 145, 161, 47, 153, 134, 116, 35, 138);
RT_INTERFACE!{interface ISearchPane(ISearchPaneVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPane] {
    fn put_SearchHistoryEnabled(&self, value: bool) -> HRESULT,
    fn get_SearchHistoryEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_SearchHistoryContext(&self, value: HSTRING) -> HRESULT,
    fn get_SearchHistoryContext(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PlaceholderText(&self, value: HSTRING) -> HRESULT,
    fn get_PlaceholderText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_QueryText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Visible(&self, out: *mut bool) -> HRESULT,
    fn add_VisibilityChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<SearchPane, SearchPaneVisibilityChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VisibilityChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_QueryChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<SearchPane, SearchPaneQueryChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_QueryChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SuggestionsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<SearchPane, SearchPaneSuggestionsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SuggestionsRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_QuerySubmitted(&self, handler: *mut super::super::foundation::TypedEventHandler<SearchPane, SearchPaneQuerySubmittedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_QuerySubmitted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ResultSuggestionChosen(&self, handler: *mut super::super::foundation::TypedEventHandler<SearchPane, SearchPaneResultSuggestionChosenEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ResultSuggestionChosen(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn SetLocalContentSuggestionSettings(&self, settings: *mut LocalContentSuggestionSettings) -> HRESULT,
    fn ShowOverloadDefault(&self) -> HRESULT,
    fn ShowOverloadWithQuery(&self, query: HSTRING) -> HRESULT,
    fn put_ShowOnKeyboardInput(&self, value: bool) -> HRESULT,
    fn get_ShowOnKeyboardInput(&self, out: *mut bool) -> HRESULT,
    fn TrySetQueryText(&self, query: HSTRING, out: *mut bool) -> HRESULT
}}
impl ISearchPane {
    #[inline] pub unsafe fn set_search_history_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SearchHistoryEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_history_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SearchHistoryEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_search_history_context(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SearchHistoryContext)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_history_context(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SearchHistoryContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_placeholder_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaceholderText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_visibility_changed(&self, handler: &super::super::foundation::TypedEventHandler<SearchPane, SearchPaneVisibilityChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VisibilityChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_visibility_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VisibilityChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_query_changed(&self, handler: &super::super::foundation::TypedEventHandler<SearchPane, SearchPaneQueryChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_QueryChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_query_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_QueryChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_suggestions_requested(&self, handler: &super::super::foundation::TypedEventHandler<SearchPane, SearchPaneSuggestionsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SuggestionsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_suggestions_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SuggestionsRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_query_submitted(&self, handler: &super::super::foundation::TypedEventHandler<SearchPane, SearchPaneQuerySubmittedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_QuerySubmitted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_query_submitted(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_QuerySubmitted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_result_suggestion_chosen(&self, handler: &super::super::foundation::TypedEventHandler<SearchPane, SearchPaneResultSuggestionChosenEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ResultSuggestionChosen)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_result_suggestion_chosen(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ResultSuggestionChosen)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_local_content_suggestion_settings(&self, settings: &LocalContentSuggestionSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).SetLocalContentSuggestionSettings)(self as *const _ as *mut _, settings as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_overload_default(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowOverloadDefault)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_overload_with_query(&self, query: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowOverloadWithQuery)(self as *const _ as *mut _, query.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_on_keyboard_input(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowOnKeyboardInput)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_on_keyboard_input(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowOnKeyboardInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_query_text(&self, query: &HStringArg) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetQueryText)(self as *const _ as *mut _, query.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPane: ISearchPane}
impl RtActivatable<ISearchPaneStatics> for SearchPane {}
impl RtActivatable<ISearchPaneStaticsWithHideThisApplication> for SearchPane {}
impl SearchPane {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<SearchPane>> { unsafe {
        <Self as RtActivatable<ISearchPaneStatics>>::get_activation_factory().get_for_current_view()
    }}
    #[inline] pub fn hide_this_application() -> Result<()> { unsafe {
        <Self as RtActivatable<ISearchPaneStaticsWithHideThisApplication>>::get_activation_factory().hide_this_application()
    }}
}
DEFINE_CLSID!(SearchPane(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,101,97,114,99,104,46,83,101,97,114,99,104,80,97,110,101,0]) [CLSID_SearchPane]);
DEFINE_IID!(IID_ISearchPaneQueryChangedEventArgs, 1007046633, 9041, 16968, 165, 41, 113, 16, 244, 100, 167, 133);
RT_INTERFACE!{interface ISearchPaneQueryChangedEventArgs(ISearchPaneQueryChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneQueryChangedEventArgs] {
    fn get_QueryText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn get_LinguisticDetails(&self, out: *mut *mut SearchPaneQueryLinguisticDetails) -> HRESULT
}}
impl ISearchPaneQueryChangedEventArgs {
    #[inline] pub unsafe fn get_query_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_linguistic_details(&self) -> Result<ComPtr<SearchPaneQueryLinguisticDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LinguisticDetails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneQueryChangedEventArgs: ISearchPaneQueryChangedEventArgs}
DEFINE_IID!(IID_ISearchPaneQueryLinguisticDetails, 2197505550, 2368, 19309, 184, 208, 100, 43, 48, 152, 158, 21);
RT_INTERFACE!{interface ISearchPaneQueryLinguisticDetails(ISearchPaneQueryLinguisticDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneQueryLinguisticDetails] {
    fn get_QueryTextAlternatives(&self, out: *mut *mut super::super::foundation::collections::IVectorView<HString>) -> HRESULT,
    fn get_QueryTextCompositionStart(&self, out: *mut u32) -> HRESULT,
    fn get_QueryTextCompositionLength(&self, out: *mut u32) -> HRESULT
}}
impl ISearchPaneQueryLinguisticDetails {
    #[inline] pub unsafe fn get_query_text_alternatives(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryTextAlternatives)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query_text_composition_start(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_QueryTextCompositionStart)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query_text_composition_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_QueryTextCompositionLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneQueryLinguisticDetails: ISearchPaneQueryLinguisticDetails}
DEFINE_IID!(IID_ISearchPaneQuerySubmittedEventArgs, 339453180, 59845, 18230, 145, 178, 232, 235, 156, 184, 131, 86);
RT_INTERFACE!{interface ISearchPaneQuerySubmittedEventArgs(ISearchPaneQuerySubmittedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneQuerySubmittedEventArgs] {
    fn get_QueryText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT
}}
impl ISearchPaneQuerySubmittedEventArgs {
    #[inline] pub unsafe fn get_query_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneQuerySubmittedEventArgs: ISearchPaneQuerySubmittedEventArgs}
DEFINE_IID!(IID_ISearchPaneQuerySubmittedEventArgsWithLinguisticDetails, 1175229157, 19506, 17720, 164, 212, 182, 180, 64, 13, 20, 15);
RT_INTERFACE!{interface ISearchPaneQuerySubmittedEventArgsWithLinguisticDetails(ISearchPaneQuerySubmittedEventArgsWithLinguisticDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneQuerySubmittedEventArgsWithLinguisticDetails] {
    fn get_LinguisticDetails(&self, out: *mut *mut SearchPaneQueryLinguisticDetails) -> HRESULT
}}
impl ISearchPaneQuerySubmittedEventArgsWithLinguisticDetails {
    #[inline] pub unsafe fn get_linguistic_details(&self) -> Result<ComPtr<SearchPaneQueryLinguisticDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LinguisticDetails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISearchPaneResultSuggestionChosenEventArgs, 3358682304, 44754, 16864, 188, 224, 194, 108, 167, 79, 133, 236);
RT_INTERFACE!{interface ISearchPaneResultSuggestionChosenEventArgs(ISearchPaneResultSuggestionChosenEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneResultSuggestionChosenEventArgs] {
    fn get_Tag(&self, out: *mut HSTRING) -> HRESULT
}}
impl ISearchPaneResultSuggestionChosenEventArgs {
    #[inline] pub unsafe fn get_tag(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneResultSuggestionChosenEventArgs: ISearchPaneResultSuggestionChosenEventArgs}
DEFINE_IID!(IID_ISearchPaneStatics, 2507320817, 36637, 18463, 161, 91, 198, 22, 85, 241, 106, 14);
RT_INTERFACE!{static interface ISearchPaneStatics(ISearchPaneStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneStatics] {
    fn GetForCurrentView(&self, out: *mut *mut SearchPane) -> HRESULT
}}
impl ISearchPaneStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<SearchPane>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISearchPaneStaticsWithHideThisApplication, 7546928, 20721, 19715, 153, 172, 198, 100, 76, 142, 216, 181);
RT_INTERFACE!{static interface ISearchPaneStaticsWithHideThisApplication(ISearchPaneStaticsWithHideThisApplicationVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneStaticsWithHideThisApplication] {
    fn HideThisApplication(&self) -> HRESULT
}}
impl ISearchPaneStaticsWithHideThisApplication {
    #[inline] pub unsafe fn hide_this_application(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).HideThisApplication)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISearchPaneSuggestionsRequest, 2175863580, 58721, 16531, 155, 77, 42, 212, 130, 121, 74, 83);
RT_INTERFACE!{interface ISearchPaneSuggestionsRequest(ISearchPaneSuggestionsRequestVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneSuggestionsRequest] {
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn get_SearchSuggestionCollection(&self, out: *mut *mut SearchSuggestionCollection) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut SearchPaneSuggestionsRequestDeferral) -> HRESULT
}}
impl ISearchPaneSuggestionsRequest {
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_suggestion_collection(&self) -> Result<ComPtr<SearchSuggestionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SearchSuggestionCollection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<SearchPaneSuggestionsRequestDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneSuggestionsRequest: ISearchPaneSuggestionsRequest}
DEFINE_IID!(IID_ISearchPaneSuggestionsRequestDeferral, 2697988599, 34632, 20194, 173, 68, 175, 166, 190, 153, 124, 81);
RT_INTERFACE!{interface ISearchPaneSuggestionsRequestDeferral(ISearchPaneSuggestionsRequestDeferralVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneSuggestionsRequestDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl ISearchPaneSuggestionsRequestDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneSuggestionsRequestDeferral: ISearchPaneSuggestionsRequestDeferral}
DEFINE_IID!(IID_ISearchPaneSuggestionsRequestedEventArgs, 3365636655, 44118, 17504, 141, 47, 128, 2, 59, 236, 79, 197);
RT_INTERFACE!{interface ISearchPaneSuggestionsRequestedEventArgs(ISearchPaneSuggestionsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneSuggestionsRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut SearchPaneSuggestionsRequest) -> HRESULT
}}
impl ISearchPaneSuggestionsRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<SearchPaneSuggestionsRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneSuggestionsRequestedEventArgs: ISearchPaneSuggestionsRequestedEventArgs}
DEFINE_IID!(IID_ISearchPaneVisibilityChangedEventArgs, 1011691590, 44107, 18930, 151, 214, 2, 14, 97, 130, 203, 156);
RT_INTERFACE!{interface ISearchPaneVisibilityChangedEventArgs(ISearchPaneVisibilityChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchPaneVisibilityChangedEventArgs] {
    fn get_Visible(&self, out: *mut bool) -> HRESULT
}}
impl ISearchPaneVisibilityChangedEventArgs {
    #[inline] pub unsafe fn get_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SearchPaneVisibilityChangedEventArgs: ISearchPaneVisibilityChangedEventArgs}
DEFINE_IID!(IID_ISearchQueryLinguisticDetails, 1184964699, 27081, 18245, 183, 47, 168, 164, 252, 143, 36, 174);
RT_INTERFACE!{interface ISearchQueryLinguisticDetails(ISearchQueryLinguisticDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchQueryLinguisticDetails] {
    fn get_QueryTextAlternatives(&self, out: *mut *mut super::super::foundation::collections::IVectorView<HString>) -> HRESULT,
    fn get_QueryTextCompositionStart(&self, out: *mut u32) -> HRESULT,
    fn get_QueryTextCompositionLength(&self, out: *mut u32) -> HRESULT
}}
impl ISearchQueryLinguisticDetails {
    #[inline] pub unsafe fn get_query_text_alternatives(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryTextAlternatives)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query_text_composition_start(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_QueryTextCompositionStart)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query_text_composition_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_QueryTextCompositionLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SearchQueryLinguisticDetails: ISearchQueryLinguisticDetails}
impl RtActivatable<ISearchQueryLinguisticDetailsFactory> for SearchQueryLinguisticDetails {}
impl SearchQueryLinguisticDetails {
    #[inline] pub fn create_instance(queryTextAlternatives: &super::super::foundation::collections::IIterable<HString>, queryTextCompositionStart: u32, queryTextCompositionLength: u32) -> Result<ComPtr<SearchQueryLinguisticDetails>> { unsafe {
        <Self as RtActivatable<ISearchQueryLinguisticDetailsFactory>>::get_activation_factory().create_instance(queryTextAlternatives, queryTextCompositionStart, queryTextCompositionLength)
    }}
}
DEFINE_CLSID!(SearchQueryLinguisticDetails(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,101,97,114,99,104,46,83,101,97,114,99,104,81,117,101,114,121,76,105,110,103,117,105,115,116,105,99,68,101,116,97,105,108,115,0]) [CLSID_SearchQueryLinguisticDetails]);
DEFINE_IID!(IID_ISearchQueryLinguisticDetailsFactory, 3402023864, 15460, 19965, 173, 159, 71, 158, 77, 64, 101, 164);
RT_INTERFACE!{static interface ISearchQueryLinguisticDetailsFactory(ISearchQueryLinguisticDetailsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISearchQueryLinguisticDetailsFactory] {
    fn CreateInstance(&self, queryTextAlternatives: *mut super::super::foundation::collections::IIterable<HString>, queryTextCompositionStart: u32, queryTextCompositionLength: u32, out: *mut *mut SearchQueryLinguisticDetails) -> HRESULT
}}
impl ISearchQueryLinguisticDetailsFactory {
    #[inline] pub unsafe fn create_instance(&self, queryTextAlternatives: &super::super::foundation::collections::IIterable<HString>, queryTextCompositionStart: u32, queryTextCompositionLength: u32) -> Result<ComPtr<SearchQueryLinguisticDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, queryTextAlternatives as *const _ as *mut _, queryTextCompositionStart, queryTextCompositionLength, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISearchSuggestionCollection, 842697291, 64490, 17478, 171, 188, 61, 167, 145, 95, 221, 58);
RT_INTERFACE!{interface ISearchSuggestionCollection(ISearchSuggestionCollectionVtbl): IInspectable(IInspectableVtbl) [IID_ISearchSuggestionCollection] {
    fn get_Size(&self, out: *mut u32) -> HRESULT,
    fn AppendQuerySuggestion(&self, text: HSTRING) -> HRESULT,
    fn AppendQuerySuggestions(&self, suggestions: *mut super::super::foundation::collections::IIterable<HString>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-storage")] fn AppendResultSuggestion(&self, text: HSTRING, detailText: HSTRING, tag: HSTRING, image: *mut super::super::storage::streams::IRandomAccessStreamReference, imageAlternateText: HSTRING) -> HRESULT,
    fn AppendSearchSeparator(&self, label: HSTRING) -> HRESULT
}}
impl ISearchSuggestionCollection {
    #[inline] pub unsafe fn get_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn append_query_suggestion(&self, text: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendQuerySuggestion)(self as *const _ as *mut _, text.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn append_query_suggestions(&self, suggestions: &super::super::foundation::collections::IIterable<HString>) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendQuerySuggestions)(self as *const _ as *mut _, suggestions as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn append_result_suggestion(&self, text: &HStringArg, detailText: &HStringArg, tag: &HStringArg, image: &super::super::storage::streams::IRandomAccessStreamReference, imageAlternateText: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendResultSuggestion)(self as *const _ as *mut _, text.get(), detailText.get(), tag.get(), image as *const _ as *mut _, imageAlternateText.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn append_search_separator(&self, label: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendSearchSeparator)(self as *const _ as *mut _, label.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SearchSuggestionCollection: ISearchSuggestionCollection}
DEFINE_IID!(IID_ISearchSuggestionsRequest, 1313744551, 17637, 16441, 144, 153, 96, 0, 234, 209, 240, 198);
RT_INTERFACE!{interface ISearchSuggestionsRequest(ISearchSuggestionsRequestVtbl): IInspectable(IInspectableVtbl) [IID_ISearchSuggestionsRequest] {
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn get_SearchSuggestionCollection(&self, out: *mut *mut SearchSuggestionCollection) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut SearchSuggestionsRequestDeferral) -> HRESULT
}}
impl ISearchSuggestionsRequest {
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_suggestion_collection(&self) -> Result<ComPtr<SearchSuggestionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SearchSuggestionCollection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<SearchSuggestionsRequestDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchSuggestionsRequest: ISearchSuggestionsRequest}
DEFINE_IID!(IID_ISearchSuggestionsRequestDeferral, 3071645865, 49253, 17773, 168, 69, 30, 204, 236, 93, 194, 139);
RT_INTERFACE!{interface ISearchSuggestionsRequestDeferral(ISearchSuggestionsRequestDeferralVtbl): IInspectable(IInspectableVtbl) [IID_ISearchSuggestionsRequestDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl ISearchSuggestionsRequestDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SearchSuggestionsRequestDeferral: ISearchSuggestionsRequestDeferral}
pub mod core { // Windows.ApplicationModel.Search.Core
use ::prelude::*;
DEFINE_IID!(IID_IRequestingFocusOnKeyboardInputEventArgs, 2702794535, 45479, 16802, 135, 157, 106, 104, 104, 126, 89, 133);
RT_INTERFACE!{interface IRequestingFocusOnKeyboardInputEventArgs(IRequestingFocusOnKeyboardInputEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRequestingFocusOnKeyboardInputEventArgs] {
    
}}
RT_CLASS!{class RequestingFocusOnKeyboardInputEventArgs: IRequestingFocusOnKeyboardInputEventArgs}
DEFINE_IID!(IID_ISearchSuggestion, 1532318896, 5415, 17275, 149, 197, 141, 24, 210, 184, 175, 85);
RT_INTERFACE!{interface ISearchSuggestion(ISearchSuggestionVtbl): IInspectable(IInspectableVtbl) [IID_ISearchSuggestion] {
    fn get_Kind(&self, out: *mut SearchSuggestionKind) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Tag(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DetailText(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Image(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn get_ImageAlternateText(&self, out: *mut HSTRING) -> HRESULT
}}
impl ISearchSuggestion {
    #[inline] pub unsafe fn get_kind(&self) -> Result<SearchSuggestionKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tag(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_detail_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DetailText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_image(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Image)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_image_alternate_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ImageAlternateText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchSuggestion: ISearchSuggestion}
RT_ENUM! { enum SearchSuggestionKind: i32 {
    Query (SearchSuggestionKind_Query) = 0, Result (SearchSuggestionKind_Result) = 1, Separator (SearchSuggestionKind_Separator) = 2,
}}
DEFINE_IID!(IID_ISearchSuggestionManager, 1057771681, 52125, 18811, 181, 0, 60, 4, 172, 149, 154, 210);
RT_INTERFACE!{interface ISearchSuggestionManager(ISearchSuggestionManagerVtbl): IInspectable(IInspectableVtbl) [IID_ISearchSuggestionManager] {
    fn get_SearchHistoryEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_SearchHistoryEnabled(&self, value: bool) -> HRESULT,
    fn get_SearchHistoryContext(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SearchHistoryContext(&self, value: HSTRING) -> HRESULT,
    fn SetLocalContentSuggestionSettings(&self, settings: *mut super::LocalContentSuggestionSettings) -> HRESULT,
    fn SetQuery(&self, queryText: HSTRING) -> HRESULT,
    fn SetQueryWithLanguage(&self, queryText: HSTRING, language: HSTRING) -> HRESULT,
    fn SetQueryWithSearchQueryLinguisticDetails(&self, queryText: HSTRING, language: HSTRING, linguisticDetails: *mut super::SearchQueryLinguisticDetails) -> HRESULT,
    fn get_Suggestions(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IObservableVector<SearchSuggestion>) -> HRESULT,
    fn AddToHistory(&self, queryText: HSTRING) -> HRESULT,
    fn AddToHistoryWithLanguage(&self, queryText: HSTRING, language: HSTRING) -> HRESULT,
    fn ClearHistory(&self) -> HRESULT,
    fn add_SuggestionsRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SearchSuggestionManager, SearchSuggestionsRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SuggestionsRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RequestingFocusOnKeyboardInput(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SearchSuggestionManager, RequestingFocusOnKeyboardInputEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RequestingFocusOnKeyboardInput(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISearchSuggestionManager {
    #[inline] pub unsafe fn get_search_history_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SearchHistoryEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_search_history_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SearchHistoryEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_history_context(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SearchHistoryContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_search_history_context(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SearchHistoryContext)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_local_content_suggestion_settings(&self, settings: &super::LocalContentSuggestionSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).SetLocalContentSuggestionSettings)(self as *const _ as *mut _, settings as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_query(&self, queryText: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetQuery)(self as *const _ as *mut _, queryText.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_query_with_language(&self, queryText: &HStringArg, language: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetQueryWithLanguage)(self as *const _ as *mut _, queryText.get(), language.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_query_with_search_query_linguistic_details(&self, queryText: &HStringArg, language: &HStringArg, linguisticDetails: &super::SearchQueryLinguisticDetails) -> Result<()> {
        let hr = ((*self.lpVtbl).SetQueryWithSearchQueryLinguisticDetails)(self as *const _ as *mut _, queryText.get(), language.get(), linguisticDetails as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_suggestions(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IObservableVector<SearchSuggestion>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Suggestions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_to_history(&self, queryText: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).AddToHistory)(self as *const _ as *mut _, queryText.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_to_history_with_language(&self, queryText: &HStringArg, language: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).AddToHistoryWithLanguage)(self as *const _ as *mut _, queryText.get(), language.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_history(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ClearHistory)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_suggestions_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SearchSuggestionManager, SearchSuggestionsRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SuggestionsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_suggestions_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SuggestionsRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_requesting_focus_on_keyboard_input(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SearchSuggestionManager, RequestingFocusOnKeyboardInputEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RequestingFocusOnKeyboardInput)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_requesting_focus_on_keyboard_input(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RequestingFocusOnKeyboardInput)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SearchSuggestionManager: ISearchSuggestionManager}
impl RtActivatable<IActivationFactory> for SearchSuggestionManager {}
DEFINE_CLSID!(SearchSuggestionManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,83,101,97,114,99,104,46,67,111,114,101,46,83,101,97,114,99,104,83,117,103,103,101,115,116,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_SearchSuggestionManager]);
DEFINE_IID!(IID_ISearchSuggestionsRequestedEventArgs, 1876236773, 40574, 19124, 139, 227, 199, 107, 27, 212, 52, 74);
RT_INTERFACE!{interface ISearchSuggestionsRequestedEventArgs(ISearchSuggestionsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchSuggestionsRequestedEventArgs] {
    fn get_QueryText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn get_LinguisticDetails(&self, out: *mut *mut super::SearchQueryLinguisticDetails) -> HRESULT,
    fn get_Request(&self, out: *mut *mut super::SearchSuggestionsRequest) -> HRESULT
}}
impl ISearchSuggestionsRequestedEventArgs {
    #[inline] pub unsafe fn get_query_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_linguistic_details(&self) -> Result<ComPtr<super::SearchQueryLinguisticDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LinguisticDetails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<super::SearchSuggestionsRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchSuggestionsRequestedEventArgs: ISearchSuggestionsRequestedEventArgs}
} // Windows.ApplicationModel.Search.Core
} // Windows.ApplicationModel.Search
pub mod background { // Windows.ApplicationModel.Background
use ::prelude::*;
DEFINE_IID!(IID_IActivitySensorTrigger, 3504161602, 58235, 18467, 165, 254, 107, 49, 223, 239, 222, 176);
RT_INTERFACE!{interface IActivitySensorTrigger(IActivitySensorTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IActivitySensorTrigger] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_SubscribedActivities(&self, out: *mut *mut super::super::foundation::collections::IVector<super::super::devices::sensors::ActivityType>) -> HRESULT,
    fn get_ReportInterval(&self, out: *mut u32) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_SupportedActivities(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::devices::sensors::ActivityType>) -> HRESULT,
    fn get_MinimumReportInterval(&self, out: *mut u32) -> HRESULT
}}
impl IActivitySensorTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_subscribed_activities(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::super::devices::sensors::ActivityType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubscribedActivities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_report_interval(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReportInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_supported_activities(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::devices::sensors::ActivityType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedActivities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_minimum_report_interval(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinimumReportInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ActivitySensorTrigger: IActivitySensorTrigger}
impl RtActivatable<IActivitySensorTriggerFactory> for ActivitySensorTrigger {}
impl ActivitySensorTrigger {
    #[inline] pub fn create(reportIntervalInMilliseconds: u32) -> Result<ComPtr<ActivitySensorTrigger>> { unsafe {
        <Self as RtActivatable<IActivitySensorTriggerFactory>>::get_activation_factory().create(reportIntervalInMilliseconds)
    }}
}
DEFINE_CLSID!(ActivitySensorTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,65,99,116,105,118,105,116,121,83,101,110,115,111,114,84,114,105,103,103,101,114,0]) [CLSID_ActivitySensorTrigger]);
DEFINE_IID!(IID_IActivitySensorTriggerFactory, 2804322755, 14391, 17655, 131, 27, 1, 50, 204, 135, 43, 195);
RT_INTERFACE!{static interface IActivitySensorTriggerFactory(IActivitySensorTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IActivitySensorTriggerFactory] {
    fn Create(&self, reportIntervalInMilliseconds: u32, out: *mut *mut ActivitySensorTrigger) -> HRESULT
}}
impl IActivitySensorTriggerFactory {
    #[inline] pub unsafe fn create(&self, reportIntervalInMilliseconds: u32) -> Result<ComPtr<ActivitySensorTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, reportIntervalInMilliseconds, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AlarmAccessStatus: i32 {
    Unspecified (AlarmAccessStatus_Unspecified) = 0, AllowedWithWakeupCapability (AlarmAccessStatus_AllowedWithWakeupCapability) = 1, AllowedWithoutWakeupCapability (AlarmAccessStatus_AllowedWithoutWakeupCapability) = 2, Denied (AlarmAccessStatus_Denied) = 3,
}}
RT_CLASS!{static class AlarmApplicationManager}
impl RtActivatable<IAlarmApplicationManagerStatics> for AlarmApplicationManager {}
impl AlarmApplicationManager {
    #[inline] pub fn request_access_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<AlarmAccessStatus>>> { unsafe {
        <Self as RtActivatable<IAlarmApplicationManagerStatics>>::get_activation_factory().request_access_async()
    }}
    #[inline] pub fn get_access_status() -> Result<AlarmAccessStatus> { unsafe {
        <Self as RtActivatable<IAlarmApplicationManagerStatics>>::get_activation_factory().get_access_status()
    }}
}
DEFINE_CLSID!(AlarmApplicationManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,65,108,97,114,109,65,112,112,108,105,99,97,116,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_AlarmApplicationManager]);
DEFINE_IID!(IID_IAlarmApplicationManagerStatics, 3389258299, 52454, 19938, 176, 155, 150, 40, 189, 51, 187, 190);
RT_INTERFACE!{static interface IAlarmApplicationManagerStatics(IAlarmApplicationManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAlarmApplicationManagerStatics] {
    fn RequestAccessAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<AlarmAccessStatus>) -> HRESULT,
    fn GetAccessStatus(&self, out: *mut AlarmAccessStatus) -> HRESULT
}}
impl IAlarmApplicationManagerStatics {
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AlarmAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_status(&self) -> Result<AlarmAccessStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetAccessStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBroadcastTrigger, 1960113302, 36151, 17644, 148, 129, 42, 11, 152, 84, 235, 72);
RT_INTERFACE!{interface IAppBroadcastTrigger(IAppBroadcastTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastTrigger] {
    fn put_ProviderInfo(&self, value: *mut AppBroadcastTriggerProviderInfo) -> HRESULT,
    fn get_ProviderInfo(&self, out: *mut *mut AppBroadcastTriggerProviderInfo) -> HRESULT
}}
impl IAppBroadcastTrigger {
    #[inline] pub unsafe fn set_provider_info(&self, value: &AppBroadcastTriggerProviderInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProviderInfo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_provider_info(&self) -> Result<ComPtr<AppBroadcastTriggerProviderInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProviderInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastTrigger: IAppBroadcastTrigger}
impl RtActivatable<IAppBroadcastTriggerFactory> for AppBroadcastTrigger {}
impl AppBroadcastTrigger {
    #[inline] pub fn create_app_broadcast_trigger(providerKey: &HStringArg) -> Result<ComPtr<AppBroadcastTrigger>> { unsafe {
        <Self as RtActivatable<IAppBroadcastTriggerFactory>>::get_activation_factory().create_app_broadcast_trigger(providerKey)
    }}
}
DEFINE_CLSID!(AppBroadcastTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,65,112,112,66,114,111,97,100,99,97,115,116,84,114,105,103,103,101,114,0]) [CLSID_AppBroadcastTrigger]);
DEFINE_IID!(IID_IAppBroadcastTriggerFactory, 671850308, 8948, 17944, 160, 46, 231, 228, 17, 235, 114, 56);
RT_INTERFACE!{static interface IAppBroadcastTriggerFactory(IAppBroadcastTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastTriggerFactory] {
    fn CreateAppBroadcastTrigger(&self, providerKey: HSTRING, out: *mut *mut AppBroadcastTrigger) -> HRESULT
}}
impl IAppBroadcastTriggerFactory {
    #[inline] pub unsafe fn create_app_broadcast_trigger(&self, providerKey: &HStringArg) -> Result<ComPtr<AppBroadcastTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAppBroadcastTrigger)(self as *const _ as *mut _, providerKey.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBroadcastTriggerProviderInfo, 4061738285, 40424, 17440, 156, 226, 94, 255, 143, 23, 55, 107);
RT_INTERFACE!{interface IAppBroadcastTriggerProviderInfo(IAppBroadcastTriggerProviderInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastTriggerProviderInfo] {
    fn put_DisplayNameResource(&self, value: HSTRING) -> HRESULT,
    fn get_DisplayNameResource(&self, out: *mut HSTRING) -> HRESULT,
    fn put_LogoResource(&self, value: HSTRING) -> HRESULT,
    fn get_LogoResource(&self, out: *mut HSTRING) -> HRESULT,
    fn put_VideoKeyFrameInterval(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_VideoKeyFrameInterval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_MaxVideoBitrate(&self, value: u32) -> HRESULT,
    fn get_MaxVideoBitrate(&self, out: *mut u32) -> HRESULT,
    fn put_MaxVideoWidth(&self, value: u32) -> HRESULT,
    fn get_MaxVideoWidth(&self, out: *mut u32) -> HRESULT,
    fn put_MaxVideoHeight(&self, value: u32) -> HRESULT,
    fn get_MaxVideoHeight(&self, out: *mut u32) -> HRESULT
}}
impl IAppBroadcastTriggerProviderInfo {
    #[inline] pub unsafe fn set_display_name_resource(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayNameResource)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name_resource(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayNameResource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_logo_resource(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LogoResource)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_logo_resource(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LogoResource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_key_frame_interval(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoKeyFrameInterval)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_key_frame_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoKeyFrameInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_video_bitrate(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxVideoBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_video_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxVideoBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_video_width(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxVideoWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_video_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxVideoWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_video_height(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxVideoHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_video_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxVideoHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastTriggerProviderInfo: IAppBroadcastTriggerProviderInfo}
DEFINE_IID!(IID_IApplicationTrigger, 189171248, 38260, 18732, 158, 147, 26, 58, 230, 51, 95, 233);
RT_INTERFACE!{interface IApplicationTrigger(IApplicationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationTrigger] {
    fn RequestAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ApplicationTriggerResult>) -> HRESULT,
    fn RequestAsyncWithArguments(&self, arguments: *mut super::super::foundation::collections::ValueSet, out: *mut *mut super::super::foundation::IAsyncOperation<ApplicationTriggerResult>) -> HRESULT
}}
impl IApplicationTrigger {
    #[inline] pub unsafe fn request_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ApplicationTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_async_with_arguments(&self, arguments: &super::super::foundation::collections::ValueSet) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ApplicationTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsyncWithArguments)(self as *const _ as *mut _, arguments as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ApplicationTrigger: IApplicationTrigger}
impl RtActivatable<IActivationFactory> for ApplicationTrigger {}
DEFINE_CLSID!(ApplicationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,65,112,112,108,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_ApplicationTrigger]);
DEFINE_IID!(IID_IApplicationTriggerDetails, 2547804850, 8729, 19102, 156, 94, 65, 208, 71, 247, 110, 130);
RT_INTERFACE!{interface IApplicationTriggerDetails(IApplicationTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationTriggerDetails] {
    fn get_Arguments(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT
}}
impl IApplicationTriggerDetails {
    #[inline] pub unsafe fn get_arguments(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ApplicationTriggerDetails: IApplicationTriggerDetails}
RT_ENUM! { enum ApplicationTriggerResult: i32 {
    Allowed (ApplicationTriggerResult_Allowed) = 0, CurrentlyRunning (ApplicationTriggerResult_CurrentlyRunning) = 1, DisabledByPolicy (ApplicationTriggerResult_DisabledByPolicy) = 2, UnknownError (ApplicationTriggerResult_UnknownError) = 3,
}}
DEFINE_IID!(IID_IAppointmentStoreNotificationTrigger, 1691616268, 49665, 17069, 170, 42, 226, 27, 163, 66, 91, 109);
RT_INTERFACE!{interface IAppointmentStoreNotificationTrigger(IAppointmentStoreNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreNotificationTrigger] {
    
}}
RT_CLASS!{class AppointmentStoreNotificationTrigger: IAppointmentStoreNotificationTrigger}
impl RtActivatable<IActivationFactory> for AppointmentStoreNotificationTrigger {}
DEFINE_CLSID!(AppointmentStoreNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,65,112,112,111,105,110,116,109,101,110,116,83,116,111,114,101,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_AppointmentStoreNotificationTrigger]);
RT_ENUM! { enum BackgroundAccessStatus: i32 {
    Unspecified (BackgroundAccessStatus_Unspecified) = 0, AllowedWithAlwaysOnRealTimeConnectivity (BackgroundAccessStatus_AllowedWithAlwaysOnRealTimeConnectivity) = 1, AllowedMayUseActiveRealTimeConnectivity (BackgroundAccessStatus_AllowedMayUseActiveRealTimeConnectivity) = 2, Denied (BackgroundAccessStatus_Denied) = 3, AlwaysAllowed (BackgroundAccessStatus_AlwaysAllowed) = 4, AllowedSubjectToSystemPolicy (BackgroundAccessStatus_AllowedSubjectToSystemPolicy) = 5, DeniedBySystemPolicy (BackgroundAccessStatus_DeniedBySystemPolicy) = 6, DeniedByUser (BackgroundAccessStatus_DeniedByUser) = 7,
}}
DEFINE_IID!(IID_IBackgroundCondition, 2923995630, 35153, 16394, 131, 2, 156, 156, 154, 42, 58, 59);
RT_INTERFACE!{interface IBackgroundCondition(IBackgroundConditionVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundCondition] {
    
}}
RT_CLASS!{static class BackgroundExecutionManager}
impl RtActivatable<IBackgroundExecutionManagerStatics> for BackgroundExecutionManager {}
impl BackgroundExecutionManager {
    #[inline] pub fn request_access_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<BackgroundAccessStatus>>> { unsafe {
        <Self as RtActivatable<IBackgroundExecutionManagerStatics>>::get_activation_factory().request_access_async()
    }}
    #[inline] pub fn request_access_for_application_async(applicationId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BackgroundAccessStatus>>> { unsafe {
        <Self as RtActivatable<IBackgroundExecutionManagerStatics>>::get_activation_factory().request_access_for_application_async(applicationId)
    }}
    #[inline] pub fn remove_access() -> Result<()> { unsafe {
        <Self as RtActivatable<IBackgroundExecutionManagerStatics>>::get_activation_factory().remove_access()
    }}
    #[inline] pub fn remove_access_for_application(applicationId: &HStringArg) -> Result<()> { unsafe {
        <Self as RtActivatable<IBackgroundExecutionManagerStatics>>::get_activation_factory().remove_access_for_application(applicationId)
    }}
    #[inline] pub fn get_access_status() -> Result<BackgroundAccessStatus> { unsafe {
        <Self as RtActivatable<IBackgroundExecutionManagerStatics>>::get_activation_factory().get_access_status()
    }}
    #[inline] pub fn get_access_status_for_application(applicationId: &HStringArg) -> Result<BackgroundAccessStatus> { unsafe {
        <Self as RtActivatable<IBackgroundExecutionManagerStatics>>::get_activation_factory().get_access_status_for_application(applicationId)
    }}
}
DEFINE_CLSID!(BackgroundExecutionManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,97,99,107,103,114,111,117,110,100,69,120,101,99,117,116,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_BackgroundExecutionManager]);
DEFINE_IID!(IID_IBackgroundExecutionManagerStatics, 3894864472, 26281, 19777, 131, 212, 180, 193, 140, 135, 184, 70);
RT_INTERFACE!{static interface IBackgroundExecutionManagerStatics(IBackgroundExecutionManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundExecutionManagerStatics] {
    fn RequestAccessAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<BackgroundAccessStatus>) -> HRESULT,
    fn RequestAccessForApplicationAsync(&self, applicationId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<BackgroundAccessStatus>) -> HRESULT,
    fn RemoveAccess(&self) -> HRESULT,
    fn RemoveAccessForApplication(&self, applicationId: HSTRING) -> HRESULT,
    fn GetAccessStatus(&self, out: *mut BackgroundAccessStatus) -> HRESULT,
    fn GetAccessStatusForApplication(&self, applicationId: HSTRING, out: *mut BackgroundAccessStatus) -> HRESULT
}}
impl IBackgroundExecutionManagerStatics {
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BackgroundAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_access_for_application_async(&self, applicationId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BackgroundAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessForApplicationAsync)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_access(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveAccess)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_access_for_application(&self, applicationId: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveAccessForApplication)(self as *const _ as *mut _, applicationId.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_status(&self) -> Result<BackgroundAccessStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetAccessStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_status_for_application(&self, applicationId: &HStringArg) -> Result<BackgroundAccessStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetAccessStatusForApplication)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTask, 2098451764, 64786, 17358, 140, 34, 234, 31, 241, 60, 6, 223);
RT_INTERFACE!{interface IBackgroundTask(IBackgroundTaskVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTask] {
    fn Run(&self, taskInstance: *mut IBackgroundTaskInstance) -> HRESULT
}}
impl IBackgroundTask {
    #[inline] pub unsafe fn run(&self, taskInstance: &IBackgroundTaskInstance) -> Result<()> {
        let hr = ((*self.lpVtbl).Run)(self as *const _ as *mut _, taskInstance as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskBuilder, 55661838, 15972, 17778, 169, 58, 132, 7, 90, 55, 201, 23);
RT_INTERFACE!{interface IBackgroundTaskBuilder(IBackgroundTaskBuilderVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskBuilder] {
    fn put_TaskEntryPoint(&self, value: HSTRING) -> HRESULT,
    fn get_TaskEntryPoint(&self, out: *mut HSTRING) -> HRESULT,
    fn SetTrigger(&self, trigger: *mut IBackgroundTrigger) -> HRESULT,
    fn AddCondition(&self, condition: *mut IBackgroundCondition) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn Register(&self, out: *mut *mut BackgroundTaskRegistration) -> HRESULT
}}
impl IBackgroundTaskBuilder {
    #[inline] pub unsafe fn set_task_entry_point(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TaskEntryPoint)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_task_entry_point(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TaskEntryPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_trigger(&self, trigger: &IBackgroundTrigger) -> Result<()> {
        let hr = ((*self.lpVtbl).SetTrigger)(self as *const _ as *mut _, trigger as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_condition(&self, condition: &IBackgroundCondition) -> Result<()> {
        let hr = ((*self.lpVtbl).AddCondition)(self as *const _ as *mut _, condition as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn register(&self) -> Result<ComPtr<BackgroundTaskRegistration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Register)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundTaskBuilder: IBackgroundTaskBuilder}
impl RtActivatable<IActivationFactory> for BackgroundTaskBuilder {}
DEFINE_CLSID!(BackgroundTaskBuilder(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,97,99,107,103,114,111,117,110,100,84,97,115,107,66,117,105,108,100,101,114,0]) [CLSID_BackgroundTaskBuilder]);
DEFINE_IID!(IID_IBackgroundTaskBuilder2, 1793576881, 4175, 16493, 141, 182, 132, 74, 87, 15, 66, 187);
RT_INTERFACE!{interface IBackgroundTaskBuilder2(IBackgroundTaskBuilder2Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskBuilder2] {
    fn put_CancelOnConditionLoss(&self, value: bool) -> HRESULT,
    fn get_CancelOnConditionLoss(&self, out: *mut bool) -> HRESULT
}}
impl IBackgroundTaskBuilder2 {
    #[inline] pub unsafe fn set_cancel_on_condition_loss(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CancelOnConditionLoss)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cancel_on_condition_loss(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CancelOnConditionLoss)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskBuilder3, 684150602, 35753, 19465, 162, 79, 25, 104, 62, 44, 146, 76);
RT_INTERFACE!{interface IBackgroundTaskBuilder3(IBackgroundTaskBuilder3Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskBuilder3] {
    fn put_IsNetworkRequested(&self, value: bool) -> HRESULT,
    fn get_IsNetworkRequested(&self, out: *mut bool) -> HRESULT
}}
impl IBackgroundTaskBuilder3 {
    #[inline] pub unsafe fn set_is_network_requested(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsNetworkRequested)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_network_requested(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsNetworkRequested)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskBuilder4, 1196811554, 52130, 20021, 189, 22, 166, 218, 127, 28, 25, 170);
RT_INTERFACE!{interface IBackgroundTaskBuilder4(IBackgroundTaskBuilder4Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskBuilder4] {
    fn get_TaskGroup(&self, out: *mut *mut BackgroundTaskRegistrationGroup) -> HRESULT,
    fn put_TaskGroup(&self, value: *mut BackgroundTaskRegistrationGroup) -> HRESULT
}}
impl IBackgroundTaskBuilder4 {
    #[inline] pub unsafe fn get_task_group(&self) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TaskGroup)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_task_group(&self, value: &BackgroundTaskRegistrationGroup) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TaskGroup)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_BackgroundTaskCanceledEventHandler, 2797910720, 20984, 19543, 172, 63, 21, 109, 209, 104, 12, 79);
RT_DELEGATE!{delegate BackgroundTaskCanceledEventHandler(BackgroundTaskCanceledEventHandlerVtbl, BackgroundTaskCanceledEventHandlerImpl) [IID_BackgroundTaskCanceledEventHandler] {
    fn Invoke(&self, sender: *mut IBackgroundTaskInstance, reason: BackgroundTaskCancellationReason) -> HRESULT
}}
impl BackgroundTaskCanceledEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IBackgroundTaskInstance, reason: BackgroundTaskCancellationReason) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, reason);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum BackgroundTaskCancellationReason: i32 {
    Abort (BackgroundTaskCancellationReason_Abort) = 0, Terminating (BackgroundTaskCancellationReason_Terminating) = 1, LoggingOff (BackgroundTaskCancellationReason_LoggingOff) = 2, ServicingUpdate (BackgroundTaskCancellationReason_ServicingUpdate) = 3, IdleTask (BackgroundTaskCancellationReason_IdleTask) = 4, Uninstall (BackgroundTaskCancellationReason_Uninstall) = 5, ConditionLoss (BackgroundTaskCancellationReason_ConditionLoss) = 6, SystemPolicy (BackgroundTaskCancellationReason_SystemPolicy) = 7, QuietHoursEntered (BackgroundTaskCancellationReason_QuietHoursEntered) = 8, ExecutionTimeExceeded (BackgroundTaskCancellationReason_ExecutionTimeExceeded) = 9, ResourceRevocation (BackgroundTaskCancellationReason_ResourceRevocation) = 10, EnergySaver (BackgroundTaskCancellationReason_EnergySaver) = 11,
}}
DEFINE_IID!(IID_IBackgroundTaskCompletedEventArgs, 1448945103, 61961, 18676, 153, 103, 43, 24, 79, 123, 251, 240);
RT_INTERFACE!{interface IBackgroundTaskCompletedEventArgs(IBackgroundTaskCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskCompletedEventArgs] {
    fn get_InstanceId(&self, out: *mut Guid) -> HRESULT,
    fn CheckResult(&self) -> HRESULT
}}
impl IBackgroundTaskCompletedEventArgs {
    #[inline] pub unsafe fn get_instance_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InstanceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn check_result(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).CheckResult)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundTaskCompletedEventArgs: IBackgroundTaskCompletedEventArgs}
DEFINE_IID!(IID_BackgroundTaskCompletedEventHandler, 1530456361, 41094, 18087, 166, 120, 67, 145, 53, 130, 43, 207);
RT_DELEGATE!{delegate BackgroundTaskCompletedEventHandler(BackgroundTaskCompletedEventHandlerVtbl, BackgroundTaskCompletedEventHandlerImpl) [IID_BackgroundTaskCompletedEventHandler] {
    fn Invoke(&self, sender: *mut BackgroundTaskRegistration, args: *mut BackgroundTaskCompletedEventArgs) -> HRESULT
}}
impl BackgroundTaskCompletedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &BackgroundTaskRegistration, args: &BackgroundTaskCompletedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskDeferral, 2479625581, 44839, 19923, 132, 110, 36, 238, 64, 202, 221, 37);
RT_INTERFACE!{interface IBackgroundTaskDeferral(IBackgroundTaskDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IBackgroundTaskDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundTaskDeferral: IBackgroundTaskDeferral}
DEFINE_IID!(IID_IBackgroundTaskInstance, 2254166650, 8664, 17779, 143, 50, 146, 138, 27, 6, 65, 246);
RT_INTERFACE!{interface IBackgroundTaskInstance(IBackgroundTaskInstanceVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskInstance] {
    fn get_InstanceId(&self, out: *mut Guid) -> HRESULT,
    fn get_Task(&self, out: *mut *mut BackgroundTaskRegistration) -> HRESULT,
    fn get_Progress(&self, out: *mut u32) -> HRESULT,
    fn put_Progress(&self, value: u32) -> HRESULT,
    fn get_TriggerDetails(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn add_Canceled(&self, cancelHandler: *mut BackgroundTaskCanceledEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Canceled(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_SuspendedCount(&self, out: *mut u32) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut BackgroundTaskDeferral) -> HRESULT
}}
impl IBackgroundTaskInstance {
    #[inline] pub unsafe fn get_instance_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InstanceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_task(&self) -> Result<ComPtr<BackgroundTaskRegistration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Task)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_progress(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Progress)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_trigger_details(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TriggerDetails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_canceled(&self, cancelHandler: &BackgroundTaskCanceledEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Canceled)(self as *const _ as *mut _, cancelHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_canceled(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Canceled)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_suspended_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SuspendedCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<BackgroundTaskDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskInstance2, 1333592438, 3190, 20404, 137, 109, 93, 225, 134, 65, 34, 246);
RT_INTERFACE!{interface IBackgroundTaskInstance2(IBackgroundTaskInstance2Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskInstance2] {
    fn GetThrottleCount(&self, counter: BackgroundTaskThrottleCounter, out: *mut u32) -> HRESULT
}}
impl IBackgroundTaskInstance2 {
    #[inline] pub unsafe fn get_throttle_count(&self, counter: BackgroundTaskThrottleCounter) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetThrottleCount)(self as *const _ as *mut _, counter, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskInstance4, 2133455420, 43524, 19208, 151, 176, 6, 216, 116, 205, 171, 245);
RT_INTERFACE!{interface IBackgroundTaskInstance4(IBackgroundTaskInstance4Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskInstance4] {
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IBackgroundTaskInstance4 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskProgressEventArgs, 4212418732, 33586, 19722, 149, 50, 3, 234, 230, 132, 218, 49);
RT_INTERFACE!{interface IBackgroundTaskProgressEventArgs(IBackgroundTaskProgressEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskProgressEventArgs] {
    fn get_InstanceId(&self, out: *mut Guid) -> HRESULT,
    fn get_Progress(&self, out: *mut u32) -> HRESULT
}}
impl IBackgroundTaskProgressEventArgs {
    #[inline] pub unsafe fn get_instance_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InstanceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundTaskProgressEventArgs: IBackgroundTaskProgressEventArgs}
DEFINE_IID!(IID_BackgroundTaskProgressEventHandler, 1189111868, 35464, 19609, 128, 76, 118, 137, 127, 98, 119, 166);
RT_DELEGATE!{delegate BackgroundTaskProgressEventHandler(BackgroundTaskProgressEventHandlerVtbl, BackgroundTaskProgressEventHandlerImpl) [IID_BackgroundTaskProgressEventHandler] {
    fn Invoke(&self, sender: *mut BackgroundTaskRegistration, args: *mut BackgroundTaskProgressEventArgs) -> HRESULT
}}
impl BackgroundTaskProgressEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &BackgroundTaskRegistration, args: &BackgroundTaskProgressEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskRegistration, 275074242, 41582, 17343, 140, 18, 31, 180, 13, 191, 191, 160);
RT_INTERFACE!{interface IBackgroundTaskRegistration(IBackgroundTaskRegistrationVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistration] {
    fn get_TaskId(&self, out: *mut Guid) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn add_Progress(&self, handler: *mut BackgroundTaskProgressEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Progress(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Completed(&self, handler: *mut BackgroundTaskCompletedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Completed(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Unregister(&self, cancelTask: bool) -> HRESULT
}}
impl IBackgroundTaskRegistration {
    #[inline] pub unsafe fn get_task_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TaskId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_progress(&self, handler: &BackgroundTaskProgressEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Progress)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_progress(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Progress)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_completed(&self, handler: &BackgroundTaskCompletedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Completed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_completed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Completed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn unregister(&self, cancelTask: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).Unregister)(self as *const _ as *mut _, cancelTask);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundTaskRegistration: IBackgroundTaskRegistration}
impl RtActivatable<IBackgroundTaskRegistrationStatics> for BackgroundTaskRegistration {}
impl RtActivatable<IBackgroundTaskRegistrationStatics2> for BackgroundTaskRegistration {}
impl BackgroundTaskRegistration {
    #[inline] pub fn get_all_tasks() -> Result<ComPtr<super::super::foundation::collections::IMapView<Guid, IBackgroundTaskRegistration>>> { unsafe {
        <Self as RtActivatable<IBackgroundTaskRegistrationStatics>>::get_activation_factory().get_all_tasks()
    }}
    #[inline] pub fn get_all_task_groups() -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, BackgroundTaskRegistrationGroup>>> { unsafe {
        <Self as RtActivatable<IBackgroundTaskRegistrationStatics2>>::get_activation_factory().get_all_task_groups()
    }}
    #[inline] pub fn get_task_group(groupId: &HStringArg) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> { unsafe {
        <Self as RtActivatable<IBackgroundTaskRegistrationStatics2>>::get_activation_factory().get_task_group(groupId)
    }}
}
DEFINE_CLSID!(BackgroundTaskRegistration(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,97,99,107,103,114,111,117,110,100,84,97,115,107,82,101,103,105,115,116,114,97,116,105,111,110,0]) [CLSID_BackgroundTaskRegistration]);
DEFINE_IID!(IID_IBackgroundTaskRegistration2, 1631110915, 48006, 16658, 175, 195, 127, 147, 155, 22, 110, 59);
RT_INTERFACE!{interface IBackgroundTaskRegistration2(IBackgroundTaskRegistration2Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistration2] {
    fn get_Trigger(&self, out: *mut *mut IBackgroundTrigger) -> HRESULT
}}
impl IBackgroundTaskRegistration2 {
    #[inline] pub unsafe fn get_trigger(&self) -> Result<ComPtr<IBackgroundTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Trigger)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskRegistration3, 4264788373, 37923, 19851, 131, 13, 177, 221, 44, 123, 173, 213);
RT_INTERFACE!{interface IBackgroundTaskRegistration3(IBackgroundTaskRegistration3Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistration3] {
    fn get_TaskGroup(&self, out: *mut *mut BackgroundTaskRegistrationGroup) -> HRESULT
}}
impl IBackgroundTaskRegistration3 {
    #[inline] pub unsafe fn get_task_group(&self) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TaskGroup)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskRegistrationGroup, 716280218, 34587, 16743, 138, 118, 5, 92, 214, 123, 91, 35);
RT_INTERFACE!{interface IBackgroundTaskRegistrationGroup(IBackgroundTaskRegistrationGroupVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistrationGroup] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn add_BackgroundActivated(&self, handler: *mut super::super::foundation::TypedEventHandler<BackgroundTaskRegistrationGroup, super::activation::BackgroundActivatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BackgroundActivated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_AllTasks(&self, out: *mut *mut super::super::foundation::collections::IMapView<Guid, BackgroundTaskRegistration>) -> HRESULT
}}
impl IBackgroundTaskRegistrationGroup {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_background_activated(&self, handler: &super::super::foundation::TypedEventHandler<BackgroundTaskRegistrationGroup, super::activation::BackgroundActivatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BackgroundActivated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_background_activated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BackgroundActivated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_tasks(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<Guid, BackgroundTaskRegistration>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllTasks)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundTaskRegistrationGroup: IBackgroundTaskRegistrationGroup}
impl RtActivatable<IBackgroundTaskRegistrationGroupFactory> for BackgroundTaskRegistrationGroup {}
impl BackgroundTaskRegistrationGroup {
    #[inline] pub fn create(id: &HStringArg) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> { unsafe {
        <Self as RtActivatable<IBackgroundTaskRegistrationGroupFactory>>::get_activation_factory().create(id)
    }}
    #[inline] pub fn create_with_name(id: &HStringArg, name: &HStringArg) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> { unsafe {
        <Self as RtActivatable<IBackgroundTaskRegistrationGroupFactory>>::get_activation_factory().create_with_name(id, name)
    }}
}
DEFINE_CLSID!(BackgroundTaskRegistrationGroup(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,97,99,107,103,114,111,117,110,100,84,97,115,107,82,101,103,105,115,116,114,97,116,105,111,110,71,114,111,117,112,0]) [CLSID_BackgroundTaskRegistrationGroup]);
DEFINE_IID!(IID_IBackgroundTaskRegistrationGroupFactory, 2212047721, 17615, 17969, 151, 64, 3, 199, 216, 116, 27, 197);
RT_INTERFACE!{static interface IBackgroundTaskRegistrationGroupFactory(IBackgroundTaskRegistrationGroupFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistrationGroupFactory] {
    fn Create(&self, id: HSTRING, out: *mut *mut BackgroundTaskRegistrationGroup) -> HRESULT,
    fn CreateWithName(&self, id: HSTRING, name: HSTRING, out: *mut *mut BackgroundTaskRegistrationGroup) -> HRESULT
}}
impl IBackgroundTaskRegistrationGroupFactory {
    #[inline] pub unsafe fn create(&self, id: &HStringArg) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, id.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_name(&self, id: &HStringArg, name: &HStringArg) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithName)(self as *const _ as *mut _, id.get(), name.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskRegistrationStatics, 1280585577, 45056, 17082, 160, 147, 106, 86, 60, 101, 227, 248);
RT_INTERFACE!{static interface IBackgroundTaskRegistrationStatics(IBackgroundTaskRegistrationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistrationStatics] {
    fn get_AllTasks(&self, out: *mut *mut super::super::foundation::collections::IMapView<Guid, IBackgroundTaskRegistration>) -> HRESULT
}}
impl IBackgroundTaskRegistrationStatics {
    #[inline] pub unsafe fn get_all_tasks(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<Guid, IBackgroundTaskRegistration>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllTasks)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBackgroundTaskRegistrationStatics2, 390817566, 45581, 20393, 173, 154, 233, 58, 214, 199, 30, 1);
RT_INTERFACE!{static interface IBackgroundTaskRegistrationStatics2(IBackgroundTaskRegistrationStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTaskRegistrationStatics2] {
    fn get_AllTaskGroups(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, BackgroundTaskRegistrationGroup>) -> HRESULT,
    fn GetTaskGroup(&self, groupId: HSTRING, out: *mut *mut BackgroundTaskRegistrationGroup) -> HRESULT
}}
impl IBackgroundTaskRegistrationStatics2 {
    #[inline] pub unsafe fn get_all_task_groups(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, BackgroundTaskRegistrationGroup>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllTaskGroups)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_task_group(&self, groupId: &HStringArg) -> Result<ComPtr<BackgroundTaskRegistrationGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTaskGroup)(self as *const _ as *mut _, groupId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BackgroundTaskThrottleCounter: i32 {
    All (BackgroundTaskThrottleCounter_All) = 0, Cpu (BackgroundTaskThrottleCounter_Cpu) = 1, Network (BackgroundTaskThrottleCounter_Network) = 2,
}}
DEFINE_IID!(IID_IBackgroundTrigger, 2226364504, 24615, 19335, 151, 144, 189, 243, 247, 87, 219, 215);
RT_INTERFACE!{interface IBackgroundTrigger(IBackgroundTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundTrigger] {
    
}}
RT_CLASS!{static class BackgroundWorkCost}
impl RtActivatable<IBackgroundWorkCostStatics> for BackgroundWorkCost {}
impl BackgroundWorkCost {
    #[inline] pub fn get_current_background_work_cost() -> Result<BackgroundWorkCostValue> { unsafe {
        <Self as RtActivatable<IBackgroundWorkCostStatics>>::get_activation_factory().get_current_background_work_cost()
    }}
}
DEFINE_CLSID!(BackgroundWorkCost(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,97,99,107,103,114,111,117,110,100,87,111,114,107,67,111,115,116,0]) [CLSID_BackgroundWorkCost]);
DEFINE_IID!(IID_IBackgroundWorkCostStatics, 3342902882, 49936, 19330, 179, 227, 59, 207, 185, 228, 199, 125);
RT_INTERFACE!{static interface IBackgroundWorkCostStatics(IBackgroundWorkCostStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundWorkCostStatics] {
    fn get_CurrentBackgroundWorkCost(&self, out: *mut BackgroundWorkCostValue) -> HRESULT
}}
impl IBackgroundWorkCostStatics {
    #[inline] pub unsafe fn get_current_background_work_cost(&self) -> Result<BackgroundWorkCostValue> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentBackgroundWorkCost)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum BackgroundWorkCostValue: i32 {
    Low (BackgroundWorkCostValue_Low) = 0, Medium (BackgroundWorkCostValue_Medium) = 1, High (BackgroundWorkCostValue_High) = 2,
}}
DEFINE_IID!(IID_IBluetoothLEAdvertisementPublisherTrigger, 2872976914, 9683, 18606, 135, 36, 216, 24, 119, 174, 97, 41);
RT_INTERFACE!{interface IBluetoothLEAdvertisementPublisherTrigger(IBluetoothLEAdvertisementPublisherTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementPublisherTrigger] {
    #[cfg(feature="windows-devices")] fn get_Advertisement(&self, out: *mut *mut super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisement) -> HRESULT
}}
impl IBluetoothLEAdvertisementPublisherTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_advertisement(&self) -> Result<ComPtr<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Advertisement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementPublisherTrigger: IBluetoothLEAdvertisementPublisherTrigger}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementPublisherTrigger {}
DEFINE_CLSID!(BluetoothLEAdvertisementPublisherTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,80,117,98,108,105,115,104,101,114,84,114,105,103,103,101,114,0]) [CLSID_BluetoothLEAdvertisementPublisherTrigger]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementWatcherTrigger, 447420441, 48353, 18667, 168, 39, 89, 251, 124, 238, 82, 166);
RT_INTERFACE!{interface IBluetoothLEAdvertisementWatcherTrigger(IBluetoothLEAdvertisementWatcherTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementWatcherTrigger] {
    fn get_MinSamplingInterval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_MaxSamplingInterval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_MinOutOfRangeTimeout(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_MaxOutOfRangeTimeout(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SignalStrengthFilter(&self, out: *mut *mut super::super::devices::bluetooth::BluetoothSignalStrengthFilter) -> HRESULT,
    #[cfg(feature="windows-devices")] fn put_SignalStrengthFilter(&self, value: *mut super::super::devices::bluetooth::BluetoothSignalStrengthFilter) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_AdvertisementFilter(&self, out: *mut *mut super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementFilter) -> HRESULT,
    #[cfg(feature="windows-devices")] fn put_AdvertisementFilter(&self, value: *mut super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementFilter) -> HRESULT
}}
impl IBluetoothLEAdvertisementWatcherTrigger {
    #[inline] pub unsafe fn get_min_sampling_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinSamplingInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_sampling_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSamplingInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_out_of_range_timeout(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinOutOfRangeTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_out_of_range_timeout(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxOutOfRangeTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_signal_strength_filter(&self) -> Result<ComPtr<super::super::devices::bluetooth::BluetoothSignalStrengthFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SignalStrengthFilter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn set_signal_strength_filter(&self, value: &super::super::devices::bluetooth::BluetoothSignalStrengthFilter) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SignalStrengthFilter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_advertisement_filter(&self) -> Result<ComPtr<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AdvertisementFilter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn set_advertisement_filter(&self, value: &super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementFilter) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AdvertisementFilter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementWatcherTrigger: IBluetoothLEAdvertisementWatcherTrigger}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementWatcherTrigger {}
DEFINE_CLSID!(BluetoothLEAdvertisementWatcherTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,87,97,116,99,104,101,114,84,114,105,103,103,101,114,0]) [CLSID_BluetoothLEAdvertisementWatcherTrigger]);
DEFINE_IID!(IID_ICachedFileUpdaterTrigger, 3793530603, 13042, 19761, 181, 83, 185, 224, 27, 222, 55, 224);
RT_INTERFACE!{interface ICachedFileUpdaterTrigger(ICachedFileUpdaterTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ICachedFileUpdaterTrigger] {
    
}}
RT_CLASS!{class CachedFileUpdaterTrigger: ICachedFileUpdaterTrigger}
impl RtActivatable<IActivationFactory> for CachedFileUpdaterTrigger {}
DEFINE_CLSID!(CachedFileUpdaterTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,67,97,99,104,101,100,70,105,108,101,85,112,100,97,116,101,114,84,114,105,103,103,101,114,0]) [CLSID_CachedFileUpdaterTrigger]);
DEFINE_IID!(IID_ICachedFileUpdaterTriggerDetails, 1904446483, 4884, 18356, 149, 151, 220, 126, 36, 140, 23, 204);
RT_INTERFACE!{interface ICachedFileUpdaterTriggerDetails(ICachedFileUpdaterTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ICachedFileUpdaterTriggerDetails] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_UpdateTarget(&self, out: *mut super::super::storage::provider::CachedFileTarget) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_UpdateRequest(&self, out: *mut *mut super::super::storage::provider::FileUpdateRequest) -> HRESULT,
    fn get_CanRequestUserInput(&self, out: *mut bool) -> HRESULT
}}
impl ICachedFileUpdaterTriggerDetails {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_update_target(&self) -> Result<super::super::storage::provider::CachedFileTarget> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UpdateTarget)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_update_request(&self) -> Result<ComPtr<super::super::storage::provider::FileUpdateRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UpdateRequest)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_request_user_input(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanRequestUserInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CachedFileUpdaterTriggerDetails: ICachedFileUpdaterTriggerDetails}
DEFINE_IID!(IID_IChatMessageNotificationTrigger, 1362838463, 7488, 23645, 120, 245, 201, 35, 254, 227, 115, 158);
RT_INTERFACE!{interface IChatMessageNotificationTrigger(IChatMessageNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageNotificationTrigger] {
    
}}
RT_CLASS!{class ChatMessageNotificationTrigger: IChatMessageNotificationTrigger}
impl RtActivatable<IActivationFactory> for ChatMessageNotificationTrigger {}
DEFINE_CLSID!(ChatMessageNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,67,104,97,116,77,101,115,115,97,103,101,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_ChatMessageNotificationTrigger]);
DEFINE_IID!(IID_IChatMessageReceivedNotificationTrigger, 1050899982, 47861, 16503, 136, 233, 6, 12, 246, 240, 198, 213);
RT_INTERFACE!{interface IChatMessageReceivedNotificationTrigger(IChatMessageReceivedNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageReceivedNotificationTrigger] {
    
}}
RT_CLASS!{class ChatMessageReceivedNotificationTrigger: IChatMessageReceivedNotificationTrigger}
impl RtActivatable<IActivationFactory> for ChatMessageReceivedNotificationTrigger {}
DEFINE_CLSID!(ChatMessageReceivedNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,67,104,97,116,77,101,115,115,97,103,101,82,101,99,101,105,118,101,100,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_ChatMessageReceivedNotificationTrigger]);
DEFINE_IID!(IID_IContactStoreNotificationTrigger, 3358802331, 18181, 17777, 154, 22, 6, 185, 151, 191, 156, 150);
RT_INTERFACE!{interface IContactStoreNotificationTrigger(IContactStoreNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IContactStoreNotificationTrigger] {
    
}}
RT_CLASS!{class ContactStoreNotificationTrigger: IContactStoreNotificationTrigger}
impl RtActivatable<IActivationFactory> for ContactStoreNotificationTrigger {}
DEFINE_CLSID!(ContactStoreNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,67,111,110,116,97,99,116,83,116,111,114,101,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_ContactStoreNotificationTrigger]);
DEFINE_IID!(IID_IContentPrefetchTrigger, 1896228846, 1274, 17419, 128, 192, 23, 50, 2, 25, 158, 93);
RT_INTERFACE!{interface IContentPrefetchTrigger(IContentPrefetchTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IContentPrefetchTrigger] {
    fn get_WaitInterval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IContentPrefetchTrigger {
    #[inline] pub unsafe fn get_wait_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WaitInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ContentPrefetchTrigger: IContentPrefetchTrigger}
impl RtActivatable<IContentPrefetchTriggerFactory> for ContentPrefetchTrigger {}
impl RtActivatable<IActivationFactory> for ContentPrefetchTrigger {}
impl ContentPrefetchTrigger {
    #[inline] pub fn create(waitInterval: super::super::foundation::TimeSpan) -> Result<ComPtr<ContentPrefetchTrigger>> { unsafe {
        <Self as RtActivatable<IContentPrefetchTriggerFactory>>::get_activation_factory().create(waitInterval)
    }}
}
DEFINE_CLSID!(ContentPrefetchTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,67,111,110,116,101,110,116,80,114,101,102,101,116,99,104,84,114,105,103,103,101,114,0]) [CLSID_ContentPrefetchTrigger]);
DEFINE_IID!(IID_IContentPrefetchTriggerFactory, 3261349594, 35331, 16542, 184, 196, 136, 129, 76, 40, 204, 182);
RT_INTERFACE!{static interface IContentPrefetchTriggerFactory(IContentPrefetchTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContentPrefetchTriggerFactory] {
    fn Create(&self, waitInterval: super::super::foundation::TimeSpan, out: *mut *mut ContentPrefetchTrigger) -> HRESULT
}}
impl IContentPrefetchTriggerFactory {
    #[inline] pub unsafe fn create(&self, waitInterval: super::super::foundation::TimeSpan) -> Result<ComPtr<ContentPrefetchTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, waitInterval, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceConnectionChangeTrigger, 2424790628, 15581, 20219, 171, 28, 91, 59, 106, 96, 206, 52);
RT_INTERFACE!{interface IDeviceConnectionChangeTrigger(IDeviceConnectionChangeTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceConnectionChangeTrigger] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CanMaintainConnection(&self, out: *mut bool) -> HRESULT,
    fn get_MaintainConnection(&self, out: *mut bool) -> HRESULT,
    fn put_MaintainConnection(&self, value: bool) -> HRESULT
}}
impl IDeviceConnectionChangeTrigger {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_maintain_connection(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanMaintainConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_maintain_connection(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaintainConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_maintain_connection(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaintainConnection)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceConnectionChangeTrigger: IDeviceConnectionChangeTrigger}
impl RtActivatable<IDeviceConnectionChangeTriggerStatics> for DeviceConnectionChangeTrigger {}
impl DeviceConnectionChangeTrigger {
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceConnectionChangeTrigger>>> { unsafe {
        <Self as RtActivatable<IDeviceConnectionChangeTriggerStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
}
DEFINE_CLSID!(DeviceConnectionChangeTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,68,101,118,105,99,101,67,111,110,110,101,99,116,105,111,110,67,104,97,110,103,101,84,114,105,103,103,101,114,0]) [CLSID_DeviceConnectionChangeTrigger]);
DEFINE_IID!(IID_IDeviceConnectionChangeTriggerStatics, 3286901866, 20221, 17560, 170, 96, 164, 228, 227, 177, 122, 185);
RT_INTERFACE!{static interface IDeviceConnectionChangeTriggerStatics(IDeviceConnectionChangeTriggerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceConnectionChangeTriggerStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceConnectionChangeTrigger>) -> HRESULT
}}
impl IDeviceConnectionChangeTriggerStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceConnectionChangeTrigger>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceManufacturerNotificationTrigger, 2166852277, 16811, 5850, 134, 194, 127, 123, 240, 145, 47, 91);
RT_INTERFACE!{interface IDeviceManufacturerNotificationTrigger(IDeviceManufacturerNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceManufacturerNotificationTrigger] {
    fn get_TriggerQualifier(&self, out: *mut HSTRING) -> HRESULT,
    fn get_OneShot(&self, out: *mut bool) -> HRESULT
}}
impl IDeviceManufacturerNotificationTrigger {
    #[inline] pub unsafe fn get_trigger_qualifier(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TriggerQualifier)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_one_shot(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OneShot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceManufacturerNotificationTrigger: IDeviceManufacturerNotificationTrigger}
impl RtActivatable<IDeviceManufacturerNotificationTriggerFactory> for DeviceManufacturerNotificationTrigger {}
impl DeviceManufacturerNotificationTrigger {
    #[inline] pub fn create(triggerQualifier: &HStringArg, oneShot: bool) -> Result<ComPtr<DeviceManufacturerNotificationTrigger>> { unsafe {
        <Self as RtActivatable<IDeviceManufacturerNotificationTriggerFactory>>::get_activation_factory().create(triggerQualifier, oneShot)
    }}
}
DEFINE_CLSID!(DeviceManufacturerNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,68,101,118,105,99,101,77,97,110,117,102,97,99,116,117,114,101,114,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_DeviceManufacturerNotificationTrigger]);
DEFINE_IID!(IID_IDeviceManufacturerNotificationTriggerFactory, 2035670645, 9659, 16723, 161, 162, 48, 41, 252, 171, 182, 82);
RT_INTERFACE!{static interface IDeviceManufacturerNotificationTriggerFactory(IDeviceManufacturerNotificationTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceManufacturerNotificationTriggerFactory] {
    fn Create(&self, triggerQualifier: HSTRING, oneShot: bool, out: *mut *mut DeviceManufacturerNotificationTrigger) -> HRESULT
}}
impl IDeviceManufacturerNotificationTriggerFactory {
    #[inline] pub unsafe fn create(&self, triggerQualifier: &HStringArg, oneShot: bool) -> Result<ComPtr<DeviceManufacturerNotificationTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, triggerQualifier.get(), oneShot, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceServicingTrigger, 447879085, 28212, 18899, 158, 111, 23, 241, 182, 223, 168, 129);
RT_INTERFACE!{interface IDeviceServicingTrigger(IDeviceServicingTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceServicingTrigger] {
    fn RequestAsyncSimple(&self, deviceId: HSTRING, expectedDuration: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceTriggerResult>) -> HRESULT,
    fn RequestAsyncWithArguments(&self, deviceId: HSTRING, expectedDuration: super::super::foundation::TimeSpan, arguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceTriggerResult>) -> HRESULT
}}
impl IDeviceServicingTrigger {
    #[inline] pub unsafe fn request_async_simple(&self, deviceId: &HStringArg, expectedDuration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsyncSimple)(self as *const _ as *mut _, deviceId.get(), expectedDuration, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_async_with_arguments(&self, deviceId: &HStringArg, expectedDuration: super::super::foundation::TimeSpan, arguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsyncWithArguments)(self as *const _ as *mut _, deviceId.get(), expectedDuration, arguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceServicingTrigger: IDeviceServicingTrigger}
impl RtActivatable<IActivationFactory> for DeviceServicingTrigger {}
DEFINE_CLSID!(DeviceServicingTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,68,101,118,105,99,101,83,101,114,118,105,99,105,110,103,84,114,105,103,103,101,114,0]) [CLSID_DeviceServicingTrigger]);
RT_ENUM! { enum DeviceTriggerResult: i32 {
    Allowed (DeviceTriggerResult_Allowed) = 0, DeniedByUser (DeviceTriggerResult_DeniedByUser) = 1, DeniedBySystem (DeviceTriggerResult_DeniedBySystem) = 2, LowBattery (DeviceTriggerResult_LowBattery) = 3,
}}
DEFINE_IID!(IID_IDeviceUseTrigger, 229015569, 13135, 19799, 182, 236, 109, 202, 100, 180, 18, 228);
RT_INTERFACE!{interface IDeviceUseTrigger(IDeviceUseTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceUseTrigger] {
    fn RequestAsyncSimple(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceTriggerResult>) -> HRESULT,
    fn RequestAsyncWithArguments(&self, deviceId: HSTRING, arguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceTriggerResult>) -> HRESULT
}}
impl IDeviceUseTrigger {
    #[inline] pub unsafe fn request_async_simple(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsyncSimple)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_async_with_arguments(&self, deviceId: &HStringArg, arguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsyncWithArguments)(self as *const _ as *mut _, deviceId.get(), arguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceUseTrigger: IDeviceUseTrigger}
impl RtActivatable<IActivationFactory> for DeviceUseTrigger {}
DEFINE_CLSID!(DeviceUseTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,68,101,118,105,99,101,85,115,101,84,114,105,103,103,101,114,0]) [CLSID_DeviceUseTrigger]);
DEFINE_IID!(IID_IDeviceWatcherTrigger, 2757853149, 34163, 16992, 190, 252, 91, 236, 137, 203, 105, 61);
RT_INTERFACE!{interface IDeviceWatcherTrigger(IDeviceWatcherTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceWatcherTrigger] {
    
}}
RT_CLASS!{class DeviceWatcherTrigger: IDeviceWatcherTrigger}
DEFINE_IID!(IID_IEmailStoreNotificationTrigger, 2557282010, 18411, 17000, 164, 242, 243, 247, 113, 136, 56, 138);
RT_INTERFACE!{interface IEmailStoreNotificationTrigger(IEmailStoreNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IEmailStoreNotificationTrigger] {
    
}}
RT_CLASS!{class EmailStoreNotificationTrigger: IEmailStoreNotificationTrigger}
impl RtActivatable<IActivationFactory> for EmailStoreNotificationTrigger {}
DEFINE_CLSID!(EmailStoreNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,69,109,97,105,108,83,116,111,114,101,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_EmailStoreNotificationTrigger]);
DEFINE_IID!(IID_IGattCharacteristicNotificationTrigger, 3797913544, 1686, 18255, 167, 50, 242, 146, 176, 206, 188, 93);
RT_INTERFACE!{interface IGattCharacteristicNotificationTrigger(IGattCharacteristicNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicNotificationTrigger] {
    #[cfg(feature="windows-devices")] fn get_Characteristic(&self, out: *mut *mut super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic) -> HRESULT
}}
impl IGattCharacteristicNotificationTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_characteristic(&self) -> Result<ComPtr<super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattCharacteristicNotificationTrigger: IGattCharacteristicNotificationTrigger}
impl RtActivatable<IGattCharacteristicNotificationTriggerFactory> for GattCharacteristicNotificationTrigger {}
impl RtActivatable<IGattCharacteristicNotificationTriggerFactory2> for GattCharacteristicNotificationTrigger {}
impl GattCharacteristicNotificationTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub fn create(characteristic: &super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic) -> Result<ComPtr<GattCharacteristicNotificationTrigger>> { unsafe {
        <Self as RtActivatable<IGattCharacteristicNotificationTriggerFactory>>::get_activation_factory().create(characteristic)
    }}
    #[cfg(feature="windows-devices")] #[inline] pub fn create_with_event_triggering_mode(characteristic: &super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic, eventTriggeringMode: super::super::devices::bluetooth::background::BluetoothEventTriggeringMode) -> Result<ComPtr<GattCharacteristicNotificationTrigger>> { unsafe {
        <Self as RtActivatable<IGattCharacteristicNotificationTriggerFactory2>>::get_activation_factory().create_with_event_triggering_mode(characteristic, eventTriggeringMode)
    }}
}
DEFINE_CLSID!(GattCharacteristicNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,71,97,116,116,67,104,97,114,97,99,116,101,114,105,115,116,105,99,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_GattCharacteristicNotificationTrigger]);
DEFINE_IID!(IID_IGattCharacteristicNotificationTrigger2, 2468520644, 44558, 17138, 178, 140, 245, 19, 114, 230, 146, 69);
RT_INTERFACE!{interface IGattCharacteristicNotificationTrigger2(IGattCharacteristicNotificationTrigger2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicNotificationTrigger2] {
    #[cfg(feature="windows-devices")] fn get_EventTriggeringMode(&self, out: *mut super::super::devices::bluetooth::background::BluetoothEventTriggeringMode) -> HRESULT
}}
impl IGattCharacteristicNotificationTrigger2 {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_event_triggering_mode(&self) -> Result<super::super::devices::bluetooth::background::BluetoothEventTriggeringMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EventTriggeringMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattCharacteristicNotificationTriggerFactory, 1471814037, 45379, 17781, 159, 107, 253, 89, 217, 58, 206, 26);
RT_INTERFACE!{static interface IGattCharacteristicNotificationTriggerFactory(IGattCharacteristicNotificationTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicNotificationTriggerFactory] {
    #[cfg(feature="windows-devices")] fn Create(&self, characteristic: *mut super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic, out: *mut *mut GattCharacteristicNotificationTrigger) -> HRESULT
}}
impl IGattCharacteristicNotificationTriggerFactory {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create(&self, characteristic: &super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic) -> Result<ComPtr<GattCharacteristicNotificationTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, characteristic as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattCharacteristicNotificationTriggerFactory2, 1503193375, 35411, 20127, 163, 44, 35, 205, 51, 102, 76, 238);
RT_INTERFACE!{static interface IGattCharacteristicNotificationTriggerFactory2(IGattCharacteristicNotificationTriggerFactory2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicNotificationTriggerFactory2] {
    #[cfg(feature="windows-devices")] fn CreateWithEventTriggeringMode(&self, characteristic: *mut super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic, eventTriggeringMode: super::super::devices::bluetooth::background::BluetoothEventTriggeringMode, out: *mut *mut GattCharacteristicNotificationTrigger) -> HRESULT
}}
impl IGattCharacteristicNotificationTriggerFactory2 {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create_with_event_triggering_mode(&self, characteristic: &super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic, eventTriggeringMode: super::super::devices::bluetooth::background::BluetoothEventTriggeringMode) -> Result<ComPtr<GattCharacteristicNotificationTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithEventTriggeringMode)(self as *const _ as *mut _, characteristic as *const _ as *mut _, eventTriggeringMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattServiceProviderTrigger, 3720782825, 5463, 19416, 133, 66, 70, 138, 160, 198, 150, 246);
RT_INTERFACE!{interface IGattServiceProviderTrigger(IGattServiceProviderTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderTrigger] {
    fn get_TriggerId(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_Service(&self, out: *mut *mut super::super::devices::bluetooth::genericattributeprofile::GattLocalService) -> HRESULT,
    #[cfg(feature="windows-devices")] fn put_AdvertisingParameters(&self, value: *mut super::super::devices::bluetooth::genericattributeprofile::GattServiceProviderAdvertisingParameters) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_AdvertisingParameters(&self, out: *mut *mut super::super::devices::bluetooth::genericattributeprofile::GattServiceProviderAdvertisingParameters) -> HRESULT
}}
impl IGattServiceProviderTrigger {
    #[inline] pub unsafe fn get_trigger_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TriggerId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_service(&self) -> Result<ComPtr<super::super::devices::bluetooth::genericattributeprofile::GattLocalService>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Service)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn set_advertising_parameters(&self, value: &super::super::devices::bluetooth::genericattributeprofile::GattServiceProviderAdvertisingParameters) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AdvertisingParameters)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_advertising_parameters(&self) -> Result<ComPtr<super::super::devices::bluetooth::genericattributeprofile::GattServiceProviderAdvertisingParameters>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AdvertisingParameters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderTrigger: IGattServiceProviderTrigger}
impl RtActivatable<IGattServiceProviderTriggerStatics> for GattServiceProviderTrigger {}
impl GattServiceProviderTrigger {
    #[inline] pub fn create_async(triggerId: &HStringArg, serviceUuid: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<GattServiceProviderTriggerResult>>> { unsafe {
        <Self as RtActivatable<IGattServiceProviderTriggerStatics>>::get_activation_factory().create_async(triggerId, serviceUuid)
    }}
}
DEFINE_CLSID!(GattServiceProviderTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,71,97,116,116,83,101,114,118,105,99,101,80,114,111,118,105,100,101,114,84,114,105,103,103,101,114,0]) [CLSID_GattServiceProviderTrigger]);
DEFINE_IID!(IID_IGattServiceProviderTriggerResult, 1011257777, 45464, 20100, 186, 212, 207, 74, 210, 153, 237, 58);
RT_INTERFACE!{interface IGattServiceProviderTriggerResult(IGattServiceProviderTriggerResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderTriggerResult] {
    fn get_Trigger(&self, out: *mut *mut GattServiceProviderTrigger) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_Error(&self, out: *mut super::super::devices::bluetooth::BluetoothError) -> HRESULT
}}
impl IGattServiceProviderTriggerResult {
    #[inline] pub unsafe fn get_trigger(&self) -> Result<ComPtr<GattServiceProviderTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Trigger)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_error(&self) -> Result<super::super::devices::bluetooth::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderTriggerResult: IGattServiceProviderTriggerResult}
DEFINE_IID!(IID_IGattServiceProviderTriggerStatics, 3021185898, 58004, 17809, 165, 166, 100, 137, 26, 130, 129, 83);
RT_INTERFACE!{static interface IGattServiceProviderTriggerStatics(IGattServiceProviderTriggerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderTriggerStatics] {
    fn CreateAsync(&self, triggerId: HSTRING, serviceUuid: Guid, out: *mut *mut super::super::foundation::IAsyncOperation<GattServiceProviderTriggerResult>) -> HRESULT
}}
impl IGattServiceProviderTriggerStatics {
    #[inline] pub unsafe fn create_async(&self, triggerId: &HStringArg, serviceUuid: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<GattServiceProviderTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAsync)(self as *const _ as *mut _, triggerId.get(), serviceUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeovisitTrigger, 1209593258, 1249, 16679, 154, 76, 25, 53, 27, 138, 128, 164);
RT_INTERFACE!{interface IGeovisitTrigger(IGeovisitTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IGeovisitTrigger] {
    #[cfg(feature="windows-devices")] fn get_MonitoringScope(&self, out: *mut super::super::devices::geolocation::VisitMonitoringScope) -> HRESULT,
    #[cfg(feature="windows-devices")] fn put_MonitoringScope(&self, value: super::super::devices::geolocation::VisitMonitoringScope) -> HRESULT
}}
impl IGeovisitTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_monitoring_scope(&self) -> Result<super::super::devices::geolocation::VisitMonitoringScope> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonitoringScope)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn set_monitoring_scope(&self, value: super::super::devices::geolocation::VisitMonitoringScope) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonitoringScope)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GeovisitTrigger: IGeovisitTrigger}
impl RtActivatable<IActivationFactory> for GeovisitTrigger {}
DEFINE_CLSID!(GeovisitTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,71,101,111,118,105,115,105,116,84,114,105,103,103,101,114,0]) [CLSID_GeovisitTrigger]);
DEFINE_IID!(IID_ILocationTrigger, 1197894172, 26743, 18462, 128, 38, 255, 126, 20, 168, 17, 160);
RT_INTERFACE!{interface ILocationTrigger(ILocationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ILocationTrigger] {
    fn get_TriggerType(&self, out: *mut LocationTriggerType) -> HRESULT
}}
impl ILocationTrigger {
    #[inline] pub unsafe fn get_trigger_type(&self) -> Result<LocationTriggerType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TriggerType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class LocationTrigger: ILocationTrigger}
impl RtActivatable<ILocationTriggerFactory> for LocationTrigger {}
impl LocationTrigger {
    #[inline] pub fn create(triggerType: LocationTriggerType) -> Result<ComPtr<LocationTrigger>> { unsafe {
        <Self as RtActivatable<ILocationTriggerFactory>>::get_activation_factory().create(triggerType)
    }}
}
DEFINE_CLSID!(LocationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,76,111,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_LocationTrigger]);
DEFINE_IID!(IID_ILocationTriggerFactory, 285653767, 65385, 19977, 170, 139, 19, 132, 234, 71, 94, 152);
RT_INTERFACE!{static interface ILocationTriggerFactory(ILocationTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ILocationTriggerFactory] {
    fn Create(&self, triggerType: LocationTriggerType, out: *mut *mut LocationTrigger) -> HRESULT
}}
impl ILocationTriggerFactory {
    #[inline] pub unsafe fn create(&self, triggerType: LocationTriggerType) -> Result<ComPtr<LocationTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, triggerType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum LocationTriggerType: i32 {
    Geofence (LocationTriggerType_Geofence) = 0,
}}
DEFINE_IID!(IID_IMaintenanceTrigger, 1746422915, 64546, 19685, 132, 26, 114, 57, 169, 129, 0, 71);
RT_INTERFACE!{interface IMaintenanceTrigger(IMaintenanceTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IMaintenanceTrigger] {
    fn get_FreshnessTime(&self, out: *mut u32) -> HRESULT,
    fn get_OneShot(&self, out: *mut bool) -> HRESULT
}}
impl IMaintenanceTrigger {
    #[inline] pub unsafe fn get_freshness_time(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FreshnessTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_one_shot(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OneShot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MaintenanceTrigger: IMaintenanceTrigger}
impl RtActivatable<IMaintenanceTriggerFactory> for MaintenanceTrigger {}
impl MaintenanceTrigger {
    #[inline] pub fn create(freshnessTime: u32, oneShot: bool) -> Result<ComPtr<MaintenanceTrigger>> { unsafe {
        <Self as RtActivatable<IMaintenanceTriggerFactory>>::get_activation_factory().create(freshnessTime, oneShot)
    }}
}
DEFINE_CLSID!(MaintenanceTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,77,97,105,110,116,101,110,97,110,99,101,84,114,105,103,103,101,114,0]) [CLSID_MaintenanceTrigger]);
DEFINE_IID!(IID_IMaintenanceTriggerFactory, 1262345006, 38877, 17961, 136, 176, 176, 108, 249, 72, 42, 229);
RT_INTERFACE!{static interface IMaintenanceTriggerFactory(IMaintenanceTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IMaintenanceTriggerFactory] {
    fn Create(&self, freshnessTime: u32, oneShot: bool, out: *mut *mut MaintenanceTrigger) -> HRESULT
}}
impl IMaintenanceTriggerFactory {
    #[inline] pub unsafe fn create(&self, freshnessTime: u32, oneShot: bool) -> Result<ComPtr<MaintenanceTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, freshnessTime, oneShot, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaProcessingTrigger, 2593504869, 35410, 19248, 144, 17, 207, 56, 4, 14, 168, 176);
RT_INTERFACE!{interface IMediaProcessingTrigger(IMediaProcessingTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IMediaProcessingTrigger] {
    fn RequestAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<MediaProcessingTriggerResult>) -> HRESULT,
    fn RequestAsyncWithArguments(&self, arguments: *mut super::super::foundation::collections::ValueSet, out: *mut *mut super::super::foundation::IAsyncOperation<MediaProcessingTriggerResult>) -> HRESULT
}}
impl IMediaProcessingTrigger {
    #[inline] pub unsafe fn request_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaProcessingTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_async_with_arguments(&self, arguments: &super::super::foundation::collections::ValueSet) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaProcessingTriggerResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAsyncWithArguments)(self as *const _ as *mut _, arguments as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaProcessingTrigger: IMediaProcessingTrigger}
impl RtActivatable<IActivationFactory> for MediaProcessingTrigger {}
DEFINE_CLSID!(MediaProcessingTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,77,101,100,105,97,80,114,111,99,101,115,115,105,110,103,84,114,105,103,103,101,114,0]) [CLSID_MediaProcessingTrigger]);
RT_ENUM! { enum MediaProcessingTriggerResult: i32 {
    Allowed (MediaProcessingTriggerResult_Allowed) = 0, CurrentlyRunning (MediaProcessingTriggerResult_CurrentlyRunning) = 1, DisabledByPolicy (MediaProcessingTriggerResult_DisabledByPolicy) = 2, UnknownError (MediaProcessingTriggerResult_UnknownError) = 3,
}}
RT_CLASS!{class MobileBroadbandDeviceServiceNotificationTrigger: IBackgroundTrigger}
impl RtActivatable<IActivationFactory> for MobileBroadbandDeviceServiceNotificationTrigger {}
DEFINE_CLSID!(MobileBroadbandDeviceServiceNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,77,111,98,105,108,101,66,114,111,97,100,98,97,110,100,68,101,118,105,99,101,83,101,114,118,105,99,101,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_MobileBroadbandDeviceServiceNotificationTrigger]);
RT_CLASS!{class MobileBroadbandPinLockStateChangeTrigger: IBackgroundTrigger}
impl RtActivatable<IActivationFactory> for MobileBroadbandPinLockStateChangeTrigger {}
DEFINE_CLSID!(MobileBroadbandPinLockStateChangeTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,77,111,98,105,108,101,66,114,111,97,100,98,97,110,100,80,105,110,76,111,99,107,83,116,97,116,101,67,104,97,110,103,101,84,114,105,103,103,101,114,0]) [CLSID_MobileBroadbandPinLockStateChangeTrigger]);
RT_CLASS!{class MobileBroadbandRadioStateChangeTrigger: IBackgroundTrigger}
impl RtActivatable<IActivationFactory> for MobileBroadbandRadioStateChangeTrigger {}
DEFINE_CLSID!(MobileBroadbandRadioStateChangeTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,77,111,98,105,108,101,66,114,111,97,100,98,97,110,100,82,97,100,105,111,83,116,97,116,101,67,104,97,110,103,101,84,114,105,103,103,101,114,0]) [CLSID_MobileBroadbandRadioStateChangeTrigger]);
RT_CLASS!{class MobileBroadbandRegistrationStateChangeTrigger: IBackgroundTrigger}
impl RtActivatable<IActivationFactory> for MobileBroadbandRegistrationStateChangeTrigger {}
DEFINE_CLSID!(MobileBroadbandRegistrationStateChangeTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,77,111,98,105,108,101,66,114,111,97,100,98,97,110,100,82,101,103,105,115,116,114,97,116,105,111,110,83,116,97,116,101,67,104,97,110,103,101,84,114,105,103,103,101,114,0]) [CLSID_MobileBroadbandRegistrationStateChangeTrigger]);
DEFINE_IID!(IID_INetworkOperatorHotspotAuthenticationTrigger, 3881224081, 12289, 19941, 131, 199, 222, 97, 216, 136, 49, 208);
RT_INTERFACE!{interface INetworkOperatorHotspotAuthenticationTrigger(INetworkOperatorHotspotAuthenticationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_INetworkOperatorHotspotAuthenticationTrigger] {
    
}}
RT_CLASS!{class NetworkOperatorHotspotAuthenticationTrigger: INetworkOperatorHotspotAuthenticationTrigger}
impl RtActivatable<IActivationFactory> for NetworkOperatorHotspotAuthenticationTrigger {}
DEFINE_CLSID!(NetworkOperatorHotspotAuthenticationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,78,101,116,119,111,114,107,79,112,101,114,97,116,111,114,72,111,116,115,112,111,116,65,117,116,104,101,110,116,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_NetworkOperatorHotspotAuthenticationTrigger]);
DEFINE_IID!(IID_INetworkOperatorNotificationTrigger, 2416483526, 25549, 18444, 149, 209, 110, 106, 239, 128, 30, 74);
RT_INTERFACE!{interface INetworkOperatorNotificationTrigger(INetworkOperatorNotificationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_INetworkOperatorNotificationTrigger] {
    fn get_NetworkAccountId(&self, out: *mut HSTRING) -> HRESULT
}}
impl INetworkOperatorNotificationTrigger {
    #[inline] pub unsafe fn get_network_account_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NetworkAccountId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class NetworkOperatorNotificationTrigger: INetworkOperatorNotificationTrigger}
impl RtActivatable<INetworkOperatorNotificationTriggerFactory> for NetworkOperatorNotificationTrigger {}
impl NetworkOperatorNotificationTrigger {
    #[inline] pub fn create(networkAccountId: &HStringArg) -> Result<ComPtr<NetworkOperatorNotificationTrigger>> { unsafe {
        <Self as RtActivatable<INetworkOperatorNotificationTriggerFactory>>::get_activation_factory().create(networkAccountId)
    }}
}
DEFINE_CLSID!(NetworkOperatorNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,78,101,116,119,111,114,107,79,112,101,114,97,116,111,114,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_NetworkOperatorNotificationTrigger]);
DEFINE_IID!(IID_INetworkOperatorNotificationTriggerFactory, 170016256, 10199, 17235, 173, 185, 146, 101, 170, 234, 87, 157);
RT_INTERFACE!{static interface INetworkOperatorNotificationTriggerFactory(INetworkOperatorNotificationTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_INetworkOperatorNotificationTriggerFactory] {
    fn Create(&self, networkAccountId: HSTRING, out: *mut *mut NetworkOperatorNotificationTrigger) -> HRESULT
}}
impl INetworkOperatorNotificationTriggerFactory {
    #[inline] pub unsafe fn create(&self, networkAccountId: &HStringArg) -> Result<ComPtr<NetworkOperatorNotificationTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, networkAccountId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PaymentAppCanMakePaymentTrigger: IBackgroundTrigger}
impl RtActivatable<IActivationFactory> for PaymentAppCanMakePaymentTrigger {}
DEFINE_CLSID!(PaymentAppCanMakePaymentTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,80,97,121,109,101,110,116,65,112,112,67,97,110,77,97,107,101,80,97,121,109,101,110,116,84,114,105,103,103,101,114,0]) [CLSID_PaymentAppCanMakePaymentTrigger]);
DEFINE_IID!(IID_IPhoneTrigger, 2379213211, 54469, 18929, 183, 211, 130, 232, 122, 14, 157, 222);
RT_INTERFACE!{interface IPhoneTrigger(IPhoneTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneTrigger] {
    fn get_OneShot(&self, out: *mut bool) -> HRESULT,
    fn get_TriggerType(&self, out: *mut super::calls::background::PhoneTriggerType) -> HRESULT
}}
impl IPhoneTrigger {
    #[inline] pub unsafe fn get_one_shot(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OneShot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_trigger_type(&self) -> Result<super::calls::background::PhoneTriggerType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TriggerType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PhoneTrigger: IPhoneTrigger}
impl RtActivatable<IPhoneTriggerFactory> for PhoneTrigger {}
impl PhoneTrigger {
    #[inline] pub fn create(type_: super::calls::background::PhoneTriggerType, oneShot: bool) -> Result<ComPtr<PhoneTrigger>> { unsafe {
        <Self as RtActivatable<IPhoneTriggerFactory>>::get_activation_factory().create(type_, oneShot)
    }}
}
DEFINE_CLSID!(PhoneTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,80,104,111,110,101,84,114,105,103,103,101,114,0]) [CLSID_PhoneTrigger]);
DEFINE_IID!(IID_IPhoneTriggerFactory, 2698591450, 24513, 18683, 165, 70, 50, 38, 32, 64, 21, 123);
RT_INTERFACE!{static interface IPhoneTriggerFactory(IPhoneTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IPhoneTriggerFactory] {
    fn Create(&self, type_: super::calls::background::PhoneTriggerType, oneShot: bool, out: *mut *mut PhoneTrigger) -> HRESULT
}}
impl IPhoneTriggerFactory {
    #[inline] pub unsafe fn create(&self, type_: super::calls::background::PhoneTriggerType, oneShot: bool) -> Result<ComPtr<PhoneTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, type_, oneShot, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PushNotificationTrigger: IBackgroundTrigger}
impl RtActivatable<IPushNotificationTriggerFactory> for PushNotificationTrigger {}
impl RtActivatable<IActivationFactory> for PushNotificationTrigger {}
impl PushNotificationTrigger {
    #[inline] pub fn create(applicationId: &HStringArg) -> Result<ComPtr<PushNotificationTrigger>> { unsafe {
        <Self as RtActivatable<IPushNotificationTriggerFactory>>::get_activation_factory().create(applicationId)
    }}
}
DEFINE_CLSID!(PushNotificationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,80,117,115,104,78,111,116,105,102,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_PushNotificationTrigger]);
DEFINE_IID!(IID_IPushNotificationTriggerFactory, 1842933019, 17806, 20418, 188, 46, 213, 102, 79, 119, 237, 25);
RT_INTERFACE!{static interface IPushNotificationTriggerFactory(IPushNotificationTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IPushNotificationTriggerFactory] {
    fn Create(&self, applicationId: HSTRING, out: *mut *mut PushNotificationTrigger) -> HRESULT
}}
impl IPushNotificationTriggerFactory {
    #[inline] pub unsafe fn create(&self, applicationId: &HStringArg) -> Result<ComPtr<PushNotificationTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRcsEndUserMessageAvailableTrigger, 2557283690, 45814, 18047, 169, 120, 164, 64, 145, 193, 26, 102);
RT_INTERFACE!{interface IRcsEndUserMessageAvailableTrigger(IRcsEndUserMessageAvailableTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IRcsEndUserMessageAvailableTrigger] {
    
}}
RT_CLASS!{class RcsEndUserMessageAvailableTrigger: IRcsEndUserMessageAvailableTrigger}
impl RtActivatable<IActivationFactory> for RcsEndUserMessageAvailableTrigger {}
DEFINE_CLSID!(RcsEndUserMessageAvailableTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,82,99,115,69,110,100,85,115,101,114,77,101,115,115,97,103,101,65,118,97,105,108,97,98,108,101,84,114,105,103,103,101,114,0]) [CLSID_RcsEndUserMessageAvailableTrigger]);
DEFINE_IID!(IID_IRfcommConnectionTrigger, 3905211106, 2899, 17508, 147, 148, 253, 135, 86, 84, 222, 100);
RT_INTERFACE!{interface IRfcommConnectionTrigger(IRfcommConnectionTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommConnectionTrigger] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_InboundConnection(&self, out: *mut *mut super::super::devices::bluetooth::background::RfcommInboundConnectionInformation) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_OutboundConnection(&self, out: *mut *mut super::super::devices::bluetooth::background::RfcommOutboundConnectionInformation) -> HRESULT,
    fn get_AllowMultipleConnections(&self, out: *mut bool) -> HRESULT,
    fn put_AllowMultipleConnections(&self, value: bool) -> HRESULT,
    #[cfg(feature="windows-networking")] fn get_ProtectionLevel(&self, out: *mut super::super::networking::sockets::SocketProtectionLevel) -> HRESULT,
    #[cfg(feature="windows-networking")] fn put_ProtectionLevel(&self, value: super::super::networking::sockets::SocketProtectionLevel) -> HRESULT,
    #[cfg(feature="windows-networking")] fn get_RemoteHostName(&self, out: *mut *mut super::super::networking::HostName) -> HRESULT,
    #[cfg(feature="windows-networking")] fn put_RemoteHostName(&self, value: *mut super::super::networking::HostName) -> HRESULT
}}
impl IRfcommConnectionTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_inbound_connection(&self) -> Result<ComPtr<super::super::devices::bluetooth::background::RfcommInboundConnectionInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InboundConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_outbound_connection(&self) -> Result<ComPtr<super::super::devices::bluetooth::background::RfcommOutboundConnectionInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutboundConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_multiple_connections(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowMultipleConnections)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_multiple_connections(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowMultipleConnections)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_protection_level(&self) -> Result<super::super::networking::sockets::SocketProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn set_protection_level(&self, value: super::super::networking::sockets::SocketProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_remote_host_name(&self) -> Result<ComPtr<super::super::networking::HostName>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteHostName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn set_remote_host_name(&self, value: &super::super::networking::HostName) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteHostName)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommConnectionTrigger: IRfcommConnectionTrigger}
impl RtActivatable<IActivationFactory> for RfcommConnectionTrigger {}
DEFINE_CLSID!(RfcommConnectionTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,82,102,99,111,109,109,67,111,110,110,101,99,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_RfcommConnectionTrigger]);
DEFINE_IID!(IID_ISecondaryAuthenticationFactorAuthenticationTrigger, 4063752999, 20865, 20260, 150, 167, 112, 10, 78, 95, 172, 98);
RT_INTERFACE!{interface ISecondaryAuthenticationFactorAuthenticationTrigger(ISecondaryAuthenticationFactorAuthenticationTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryAuthenticationFactorAuthenticationTrigger] {
    
}}
RT_CLASS!{class SecondaryAuthenticationFactorAuthenticationTrigger: ISecondaryAuthenticationFactorAuthenticationTrigger}
impl RtActivatable<IActivationFactory> for SecondaryAuthenticationFactorAuthenticationTrigger {}
DEFINE_CLSID!(SecondaryAuthenticationFactorAuthenticationTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,101,99,111,110,100,97,114,121,65,117,116,104,101,110,116,105,99,97,116,105,111,110,70,97,99,116,111,114,65,117,116,104,101,110,116,105,99,97,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_SecondaryAuthenticationFactorAuthenticationTrigger]);
DEFINE_IID!(IID_ISensorDataThresholdTrigger, 1539371890, 54411, 19327, 171, 236, 21, 249, 186, 204, 18, 226);
RT_INTERFACE!{interface ISensorDataThresholdTrigger(ISensorDataThresholdTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ISensorDataThresholdTrigger] {
    
}}
RT_CLASS!{class SensorDataThresholdTrigger: ISensorDataThresholdTrigger}
impl RtActivatable<ISensorDataThresholdTriggerFactory> for SensorDataThresholdTrigger {}
impl SensorDataThresholdTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub fn create(threshold: &super::super::devices::sensors::ISensorDataThreshold) -> Result<ComPtr<SensorDataThresholdTrigger>> { unsafe {
        <Self as RtActivatable<ISensorDataThresholdTriggerFactory>>::get_activation_factory().create(threshold)
    }}
}
DEFINE_CLSID!(SensorDataThresholdTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,101,110,115,111,114,68,97,116,97,84,104,114,101,115,104,111,108,100,84,114,105,103,103,101,114,0]) [CLSID_SensorDataThresholdTrigger]);
DEFINE_IID!(IID_ISensorDataThresholdTriggerFactory, 2451564149, 32240, 19875, 151, 179, 229, 68, 238, 133, 127, 230);
RT_INTERFACE!{static interface ISensorDataThresholdTriggerFactory(ISensorDataThresholdTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISensorDataThresholdTriggerFactory] {
    #[cfg(feature="windows-devices")] fn Create(&self, threshold: *mut super::super::devices::sensors::ISensorDataThreshold, out: *mut *mut SensorDataThresholdTrigger) -> HRESULT
}}
impl ISensorDataThresholdTriggerFactory {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create(&self, threshold: &super::super::devices::sensors::ISensorDataThreshold) -> Result<ComPtr<SensorDataThresholdTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, threshold as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardTrigger, 4114335148, 33994, 18802, 140, 233, 229, 143, 151, 179, 122, 80);
RT_INTERFACE!{interface ISmartCardTrigger(ISmartCardTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardTrigger] {
    #[cfg(feature="windows-devices")] fn get_TriggerType(&self, out: *mut super::super::devices::smartcards::SmartCardTriggerType) -> HRESULT
}}
impl ISmartCardTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_trigger_type(&self) -> Result<super::super::devices::smartcards::SmartCardTriggerType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TriggerType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardTrigger: ISmartCardTrigger}
impl RtActivatable<ISmartCardTriggerFactory> for SmartCardTrigger {}
impl SmartCardTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub fn create(triggerType: super::super::devices::smartcards::SmartCardTriggerType) -> Result<ComPtr<SmartCardTrigger>> { unsafe {
        <Self as RtActivatable<ISmartCardTriggerFactory>>::get_activation_factory().create(triggerType)
    }}
}
DEFINE_CLSID!(SmartCardTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,109,97,114,116,67,97,114,100,84,114,105,103,103,101,114,0]) [CLSID_SmartCardTrigger]);
DEFINE_IID!(IID_ISmartCardTriggerFactory, 1673483459, 35265, 19968, 169, 211, 151, 198, 41, 38, 157, 173);
RT_INTERFACE!{static interface ISmartCardTriggerFactory(ISmartCardTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardTriggerFactory] {
    #[cfg(feature="windows-devices")] fn Create(&self, triggerType: super::super::devices::smartcards::SmartCardTriggerType, out: *mut *mut SmartCardTrigger) -> HRESULT
}}
impl ISmartCardTriggerFactory {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create(&self, triggerType: super::super::devices::smartcards::SmartCardTriggerType) -> Result<ComPtr<SmartCardTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, triggerType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsMessageReceivedTrigger: IBackgroundTrigger}
impl RtActivatable<ISmsMessageReceivedTriggerFactory> for SmsMessageReceivedTrigger {}
impl SmsMessageReceivedTrigger {
    #[cfg(feature="windows-devices")] #[inline] pub fn create(filterRules: &super::super::devices::sms::SmsFilterRules) -> Result<ComPtr<SmsMessageReceivedTrigger>> { unsafe {
        <Self as RtActivatable<ISmsMessageReceivedTriggerFactory>>::get_activation_factory().create(filterRules)
    }}
}
DEFINE_CLSID!(SmsMessageReceivedTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,109,115,77,101,115,115,97,103,101,82,101,99,101,105,118,101,100,84,114,105,103,103,101,114,0]) [CLSID_SmsMessageReceivedTrigger]);
DEFINE_IID!(IID_ISmsMessageReceivedTriggerFactory, 3929725128, 27556, 19122, 141, 33, 188, 107, 9, 199, 117, 100);
RT_INTERFACE!{static interface ISmsMessageReceivedTriggerFactory(ISmsMessageReceivedTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessageReceivedTriggerFactory] {
    #[cfg(feature="windows-devices")] fn Create(&self, filterRules: *mut super::super::devices::sms::SmsFilterRules, out: *mut *mut SmsMessageReceivedTrigger) -> HRESULT
}}
impl ISmsMessageReceivedTriggerFactory {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create(&self, filterRules: &super::super::devices::sms::SmsFilterRules) -> Result<ComPtr<SmsMessageReceivedTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, filterRules as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISocketActivityTrigger, 2847668240, 40414, 20362, 131, 227, 176, 224, 231, 165, 13, 112);
RT_INTERFACE!{interface ISocketActivityTrigger(ISocketActivityTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ISocketActivityTrigger] {
    fn get_IsWakeFromLowPowerSupported(&self, out: *mut bool) -> HRESULT
}}
impl ISocketActivityTrigger {
    #[inline] pub unsafe fn get_is_wake_from_low_power_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsWakeFromLowPowerSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SocketActivityTrigger: IBackgroundTrigger}
impl RtActivatable<IActivationFactory> for SocketActivityTrigger {}
DEFINE_CLSID!(SocketActivityTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,111,99,107,101,116,65,99,116,105,118,105,116,121,84,114,105,103,103,101,114,0]) [CLSID_SocketActivityTrigger]);
DEFINE_IID!(IID_IStorageLibraryContentChangedTrigger, 372760743, 33436, 17852, 146, 155, 161, 231, 234, 120, 216, 155);
RT_INTERFACE!{interface IStorageLibraryContentChangedTrigger(IStorageLibraryContentChangedTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IStorageLibraryContentChangedTrigger] {
    
}}
RT_CLASS!{class StorageLibraryContentChangedTrigger: IStorageLibraryContentChangedTrigger}
impl RtActivatable<IStorageLibraryContentChangedTriggerStatics> for StorageLibraryContentChangedTrigger {}
impl StorageLibraryContentChangedTrigger {
    #[cfg(feature="windows-storage")] #[inline] pub fn create(storageLibrary: &super::super::storage::StorageLibrary) -> Result<ComPtr<StorageLibraryContentChangedTrigger>> { unsafe {
        <Self as RtActivatable<IStorageLibraryContentChangedTriggerStatics>>::get_activation_factory().create(storageLibrary)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_libraries(storageLibraries: &super::super::foundation::collections::IIterable<super::super::storage::StorageLibrary>) -> Result<ComPtr<StorageLibraryContentChangedTrigger>> { unsafe {
        <Self as RtActivatable<IStorageLibraryContentChangedTriggerStatics>>::get_activation_factory().create_from_libraries(storageLibraries)
    }}
}
DEFINE_CLSID!(StorageLibraryContentChangedTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,116,111,114,97,103,101,76,105,98,114,97,114,121,67,111,110,116,101,110,116,67,104,97,110,103,101,100,84,114,105,103,103,101,114,0]) [CLSID_StorageLibraryContentChangedTrigger]);
DEFINE_IID!(IID_IStorageLibraryContentChangedTriggerStatics, 2141133625, 24464, 19986, 145, 78, 167, 216, 224, 187, 251, 24);
RT_INTERFACE!{static interface IStorageLibraryContentChangedTriggerStatics(IStorageLibraryContentChangedTriggerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IStorageLibraryContentChangedTriggerStatics] {
    #[cfg(feature="windows-storage")] fn Create(&self, storageLibrary: *mut super::super::storage::StorageLibrary, out: *mut *mut StorageLibraryContentChangedTrigger) -> HRESULT,
    #[cfg(feature="windows-storage")] fn CreateFromLibraries(&self, storageLibraries: *mut super::super::foundation::collections::IIterable<super::super::storage::StorageLibrary>, out: *mut *mut StorageLibraryContentChangedTrigger) -> HRESULT
}}
impl IStorageLibraryContentChangedTriggerStatics {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create(&self, storageLibrary: &super::super::storage::StorageLibrary) -> Result<ComPtr<StorageLibraryContentChangedTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, storageLibrary as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_libraries(&self, storageLibraries: &super::super::foundation::collections::IIterable<super::super::storage::StorageLibrary>) -> Result<ComPtr<StorageLibraryContentChangedTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromLibraries)(self as *const _ as *mut _, storageLibraries as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISystemCondition, 3244274806, 35269, 16907, 171, 211, 251, 48, 48, 71, 33, 40);
RT_INTERFACE!{interface ISystemCondition(ISystemConditionVtbl): IInspectable(IInspectableVtbl) [IID_ISystemCondition] {
    fn get_ConditionType(&self, out: *mut SystemConditionType) -> HRESULT
}}
impl ISystemCondition {
    #[inline] pub unsafe fn get_condition_type(&self) -> Result<SystemConditionType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConditionType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SystemCondition: ISystemCondition}
impl RtActivatable<ISystemConditionFactory> for SystemCondition {}
impl SystemCondition {
    #[inline] pub fn create(conditionType: SystemConditionType) -> Result<ComPtr<SystemCondition>> { unsafe {
        <Self as RtActivatable<ISystemConditionFactory>>::get_activation_factory().create(conditionType)
    }}
}
DEFINE_CLSID!(SystemCondition(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,121,115,116,101,109,67,111,110,100,105,116,105,111,110,0]) [CLSID_SystemCondition]);
DEFINE_IID!(IID_ISystemConditionFactory, 3530150385, 1447, 18862, 135, 215, 22, 178, 184, 185, 165, 83);
RT_INTERFACE!{static interface ISystemConditionFactory(ISystemConditionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISystemConditionFactory] {
    fn Create(&self, conditionType: SystemConditionType, out: *mut *mut SystemCondition) -> HRESULT
}}
impl ISystemConditionFactory {
    #[inline] pub unsafe fn create(&self, conditionType: SystemConditionType) -> Result<ComPtr<SystemCondition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, conditionType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SystemConditionType: i32 {
    Invalid (SystemConditionType_Invalid) = 0, UserPresent (SystemConditionType_UserPresent) = 1, UserNotPresent (SystemConditionType_UserNotPresent) = 2, InternetAvailable (SystemConditionType_InternetAvailable) = 3, InternetNotAvailable (SystemConditionType_InternetNotAvailable) = 4, SessionConnected (SystemConditionType_SessionConnected) = 5, SessionDisconnected (SystemConditionType_SessionDisconnected) = 6, FreeNetworkAvailable (SystemConditionType_FreeNetworkAvailable) = 7, BackgroundWorkCostNotHigh (SystemConditionType_BackgroundWorkCostNotHigh) = 8,
}}
DEFINE_IID!(IID_ISystemTrigger, 494978934, 14152, 17507, 141, 126, 39, 109, 193, 57, 172, 28);
RT_INTERFACE!{interface ISystemTrigger(ISystemTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ISystemTrigger] {
    fn get_OneShot(&self, out: *mut bool) -> HRESULT,
    fn get_TriggerType(&self, out: *mut SystemTriggerType) -> HRESULT
}}
impl ISystemTrigger {
    #[inline] pub unsafe fn get_one_shot(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OneShot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_trigger_type(&self) -> Result<SystemTriggerType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TriggerType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SystemTrigger: ISystemTrigger}
impl RtActivatable<ISystemTriggerFactory> for SystemTrigger {}
impl SystemTrigger {
    #[inline] pub fn create(triggerType: SystemTriggerType, oneShot: bool) -> Result<ComPtr<SystemTrigger>> { unsafe {
        <Self as RtActivatable<ISystemTriggerFactory>>::get_activation_factory().create(triggerType, oneShot)
    }}
}
DEFINE_CLSID!(SystemTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,83,121,115,116,101,109,84,114,105,103,103,101,114,0]) [CLSID_SystemTrigger]);
DEFINE_IID!(IID_ISystemTriggerFactory, 3892585428, 34705, 17785, 129, 38, 135, 236, 138, 170, 64, 122);
RT_INTERFACE!{static interface ISystemTriggerFactory(ISystemTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISystemTriggerFactory] {
    fn Create(&self, triggerType: SystemTriggerType, oneShot: bool, out: *mut *mut SystemTrigger) -> HRESULT
}}
impl ISystemTriggerFactory {
    #[inline] pub unsafe fn create(&self, triggerType: SystemTriggerType, oneShot: bool) -> Result<ComPtr<SystemTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, triggerType, oneShot, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SystemTriggerType: i32 {
    Invalid (SystemTriggerType_Invalid) = 0, SmsReceived (SystemTriggerType_SmsReceived) = 1, UserPresent (SystemTriggerType_UserPresent) = 2, UserAway (SystemTriggerType_UserAway) = 3, NetworkStateChange (SystemTriggerType_NetworkStateChange) = 4, ControlChannelReset (SystemTriggerType_ControlChannelReset) = 5, InternetAvailable (SystemTriggerType_InternetAvailable) = 6, SessionConnected (SystemTriggerType_SessionConnected) = 7, ServicingComplete (SystemTriggerType_ServicingComplete) = 8, LockScreenApplicationAdded (SystemTriggerType_LockScreenApplicationAdded) = 9, LockScreenApplicationRemoved (SystemTriggerType_LockScreenApplicationRemoved) = 10, TimeZoneChange (SystemTriggerType_TimeZoneChange) = 11, OnlineIdConnectedStateChange (SystemTriggerType_OnlineIdConnectedStateChange) = 12, BackgroundWorkCostChange (SystemTriggerType_BackgroundWorkCostChange) = 13, PowerStateChange (SystemTriggerType_PowerStateChange) = 14, DefaultSignInAccountChange (SystemTriggerType_DefaultSignInAccountChange) = 15,
}}
DEFINE_IID!(IID_ITimeTrigger, 1701729622, 2858, 17271, 186, 112, 59, 69, 169, 53, 84, 127);
RT_INTERFACE!{interface ITimeTrigger(ITimeTriggerVtbl): IInspectable(IInspectableVtbl) [IID_ITimeTrigger] {
    fn get_FreshnessTime(&self, out: *mut u32) -> HRESULT,
    fn get_OneShot(&self, out: *mut bool) -> HRESULT
}}
impl ITimeTrigger {
    #[inline] pub unsafe fn get_freshness_time(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FreshnessTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_one_shot(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OneShot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class TimeTrigger: ITimeTrigger}
impl RtActivatable<ITimeTriggerFactory> for TimeTrigger {}
impl TimeTrigger {
    #[inline] pub fn create(freshnessTime: u32, oneShot: bool) -> Result<ComPtr<TimeTrigger>> { unsafe {
        <Self as RtActivatable<ITimeTriggerFactory>>::get_activation_factory().create(freshnessTime, oneShot)
    }}
}
DEFINE_CLSID!(TimeTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,84,105,109,101,84,114,105,103,103,101,114,0]) [CLSID_TimeTrigger]);
DEFINE_IID!(IID_ITimeTriggerFactory, 952533758, 39764, 17894, 178, 243, 38, 155, 135, 166, 247, 52);
RT_INTERFACE!{static interface ITimeTriggerFactory(ITimeTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ITimeTriggerFactory] {
    fn Create(&self, freshnessTime: u32, oneShot: bool, out: *mut *mut TimeTrigger) -> HRESULT
}}
impl ITimeTriggerFactory {
    #[inline] pub unsafe fn create(&self, freshnessTime: u32, oneShot: bool) -> Result<ComPtr<TimeTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, freshnessTime, oneShot, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ToastNotificationActionTrigger: IBackgroundTrigger}
impl RtActivatable<IToastNotificationActionTriggerFactory> for ToastNotificationActionTrigger {}
impl RtActivatable<IActivationFactory> for ToastNotificationActionTrigger {}
impl ToastNotificationActionTrigger {
    #[inline] pub fn create(applicationId: &HStringArg) -> Result<ComPtr<ToastNotificationActionTrigger>> { unsafe {
        <Self as RtActivatable<IToastNotificationActionTriggerFactory>>::get_activation_factory().create(applicationId)
    }}
}
DEFINE_CLSID!(ToastNotificationActionTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,84,111,97,115,116,78,111,116,105,102,105,99,97,116,105,111,110,65,99,116,105,111,110,84,114,105,103,103,101,114,0]) [CLSID_ToastNotificationActionTrigger]);
DEFINE_IID!(IID_IToastNotificationActionTriggerFactory, 2963143719, 25728, 17225, 129, 37, 151, 179, 239, 170, 10, 58);
RT_INTERFACE!{static interface IToastNotificationActionTriggerFactory(IToastNotificationActionTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IToastNotificationActionTriggerFactory] {
    fn Create(&self, applicationId: HSTRING, out: *mut *mut ToastNotificationActionTrigger) -> HRESULT
}}
impl IToastNotificationActionTriggerFactory {
    #[inline] pub unsafe fn create(&self, applicationId: &HStringArg) -> Result<ComPtr<ToastNotificationActionTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ToastNotificationHistoryChangedTrigger: IBackgroundTrigger}
impl RtActivatable<IToastNotificationHistoryChangedTriggerFactory> for ToastNotificationHistoryChangedTrigger {}
impl RtActivatable<IActivationFactory> for ToastNotificationHistoryChangedTrigger {}
impl ToastNotificationHistoryChangedTrigger {
    #[inline] pub fn create(applicationId: &HStringArg) -> Result<ComPtr<ToastNotificationHistoryChangedTrigger>> { unsafe {
        <Self as RtActivatable<IToastNotificationHistoryChangedTriggerFactory>>::get_activation_factory().create(applicationId)
    }}
}
DEFINE_CLSID!(ToastNotificationHistoryChangedTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,84,111,97,115,116,78,111,116,105,102,105,99,97,116,105,111,110,72,105,115,116,111,114,121,67,104,97,110,103,101,100,84,114,105,103,103,101,114,0]) [CLSID_ToastNotificationHistoryChangedTrigger]);
DEFINE_IID!(IID_IToastNotificationHistoryChangedTriggerFactory, 2177301165, 34711, 18309, 129, 180, 176, 204, 203, 115, 209, 217);
RT_INTERFACE!{static interface IToastNotificationHistoryChangedTriggerFactory(IToastNotificationHistoryChangedTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IToastNotificationHistoryChangedTriggerFactory] {
    fn Create(&self, applicationId: HSTRING, out: *mut *mut ToastNotificationHistoryChangedTrigger) -> HRESULT
}}
impl IToastNotificationHistoryChangedTriggerFactory {
    #[inline] pub unsafe fn create(&self, applicationId: &HStringArg) -> Result<ComPtr<ToastNotificationHistoryChangedTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class UserNotificationChangedTrigger: IBackgroundTrigger}
impl RtActivatable<IUserNotificationChangedTriggerFactory> for UserNotificationChangedTrigger {}
impl UserNotificationChangedTrigger {
    #[cfg(feature="windows-ui")] #[inline] pub fn create(notificationKinds: super::super::ui::notifications::NotificationKinds) -> Result<ComPtr<UserNotificationChangedTrigger>> { unsafe {
        <Self as RtActivatable<IUserNotificationChangedTriggerFactory>>::get_activation_factory().create(notificationKinds)
    }}
}
DEFINE_CLSID!(UserNotificationChangedTrigger(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,66,97,99,107,103,114,111,117,110,100,46,85,115,101,114,78,111,116,105,102,105,99,97,116,105,111,110,67,104,97,110,103,101,100,84,114,105,103,103,101,114,0]) [CLSID_UserNotificationChangedTrigger]);
DEFINE_IID!(IID_IUserNotificationChangedTriggerFactory, 3402908524, 27051, 19992, 164, 138, 94, 210, 172, 67, 89, 87);
RT_INTERFACE!{static interface IUserNotificationChangedTriggerFactory(IUserNotificationChangedTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IUserNotificationChangedTriggerFactory] {
    #[cfg(feature="windows-ui")] fn Create(&self, notificationKinds: super::super::ui::notifications::NotificationKinds, out: *mut *mut UserNotificationChangedTrigger) -> HRESULT
}}
impl IUserNotificationChangedTriggerFactory {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn create(&self, notificationKinds: super::super::ui::notifications::NotificationKinds) -> Result<ComPtr<UserNotificationChangedTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, notificationKinds, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.ApplicationModel.Background
pub mod core { // Windows.ApplicationModel.Core
use ::prelude::*;
DEFINE_IID!(IID_IAppListEntry, 4009816191, 8456, 18698, 135, 122, 138, 159, 23, 194, 95, 173);
RT_INTERFACE!{interface IAppListEntry(IAppListEntryVtbl): IInspectable(IInspectableVtbl) [IID_IAppListEntry] {
    fn get_DisplayInfo(&self, out: *mut *mut super::AppDisplayInfo) -> HRESULT,
    fn LaunchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IAppListEntry {
    #[inline] pub unsafe fn get_display_info(&self) -> Result<ComPtr<super::AppDisplayInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn launch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LaunchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppListEntry: IAppListEntry}
DEFINE_IID!(IID_IAppListEntry2, 3500546221, 48949, 17068, 172, 6, 134, 238, 235, 65, 208, 75);
RT_INTERFACE!{interface IAppListEntry2(IAppListEntry2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppListEntry2] {
    fn get_AppUserModelId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppListEntry2 {
    #[inline] pub unsafe fn get_app_user_model_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppUserModelId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppRestartFailureReason: i32 {
    RestartPending (AppRestartFailureReason_RestartPending) = 0, NotInForeground (AppRestartFailureReason_NotInForeground) = 1, InvalidUser (AppRestartFailureReason_InvalidUser) = 2, Other (AppRestartFailureReason_Other) = 3,
}}
DEFINE_IID!(IID_ICoreApplication, 179107748, 24093, 18911, 128, 52, 251, 106, 104, 188, 94, 209);
RT_INTERFACE!{static interface ICoreApplication(ICoreApplicationVtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplication] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn add_Suspending(&self, handler: *mut super::super::foundation::EventHandler<super::SuspendingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Suspending(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Resuming(&self, handler: *mut super::super::foundation::EventHandler<IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Resuming(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut super::super::foundation::collections::IPropertySet) -> HRESULT,
    fn GetCurrentView(&self, out: *mut *mut CoreApplicationView) -> HRESULT,
    fn Run(&self, viewSource: *mut IFrameworkViewSource) -> HRESULT,
    fn RunWithActivationFactories(&self, activationFactoryCallback: *mut super::super::foundation::IGetActivationFactory) -> HRESULT
}}
impl ICoreApplication {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_suspending(&self, handler: &super::super::foundation::EventHandler<super::SuspendingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Suspending)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_suspending(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Suspending)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_resuming(&self, handler: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Resuming)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resuming(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Resuming)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IPropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_view(&self) -> Result<ComPtr<CoreApplicationView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn run(&self, viewSource: &IFrameworkViewSource) -> Result<()> {
        let hr = ((*self.lpVtbl).Run)(self as *const _ as *mut _, viewSource as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn run_with_activation_factories(&self, activationFactoryCallback: &super::super::foundation::IGetActivationFactory) -> Result<()> {
        let hr = ((*self.lpVtbl).RunWithActivationFactories)(self as *const _ as *mut _, activationFactoryCallback as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{static class CoreApplication}
impl RtActivatable<ICoreApplication> for CoreApplication {}
impl RtActivatable<ICoreApplication2> for CoreApplication {}
impl RtActivatable<ICoreApplication3> for CoreApplication {}
impl RtActivatable<ICoreApplicationExit> for CoreApplication {}
impl RtActivatable<ICoreApplicationUnhandledError> for CoreApplication {}
impl RtActivatable<ICoreApplicationUseCount> for CoreApplication {}
impl RtActivatable<ICoreImmersiveApplication> for CoreApplication {}
impl RtActivatable<ICoreImmersiveApplication2> for CoreApplication {}
impl RtActivatable<ICoreImmersiveApplication3> for CoreApplication {}
impl CoreApplication {
    #[inline] pub fn get_id() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().get_id()
    }}
    #[inline] pub fn add_suspending(handler: &super::super::foundation::EventHandler<super::SuspendingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().add_suspending(handler)
    }}
    #[inline] pub fn remove_suspending(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().remove_suspending(token)
    }}
    #[inline] pub fn add_resuming(handler: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().add_resuming(handler)
    }}
    #[inline] pub fn remove_resuming(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().remove_resuming(token)
    }}
    #[inline] pub fn get_properties() -> Result<ComPtr<super::super::foundation::collections::IPropertySet>> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().get_properties()
    }}
    #[inline] pub fn get_current_view() -> Result<ComPtr<CoreApplicationView>> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().get_current_view()
    }}
    #[inline] pub fn run(viewSource: &IFrameworkViewSource) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().run(viewSource)
    }}
    #[inline] pub fn run_with_activation_factories(activationFactoryCallback: &super::super::foundation::IGetActivationFactory) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication>>::get_activation_factory().run_with_activation_factories(activationFactoryCallback)
    }}
    #[inline] pub fn add_background_activated(handler: &super::super::foundation::EventHandler<super::activation::BackgroundActivatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().add_background_activated(handler)
    }}
    #[inline] pub fn remove_background_activated(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().remove_background_activated(token)
    }}
    #[inline] pub fn add_leaving_background(handler: &super::super::foundation::EventHandler<super::LeavingBackgroundEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().add_leaving_background(handler)
    }}
    #[inline] pub fn remove_leaving_background(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().remove_leaving_background(token)
    }}
    #[inline] pub fn add_entered_background(handler: &super::super::foundation::EventHandler<super::EnteredBackgroundEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().add_entered_background(handler)
    }}
    #[inline] pub fn remove_entered_background(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().remove_entered_background(token)
    }}
    #[inline] pub fn enable_prelaunch(value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplication2>>::get_activation_factory().enable_prelaunch(value)
    }}
    #[inline] pub fn request_restart_async(launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRestartFailureReason>>> { unsafe {
        <Self as RtActivatable<ICoreApplication3>>::get_activation_factory().request_restart_async(launchArguments)
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn request_restart_for_user_async(user: &super::super::system::User, launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRestartFailureReason>>> { unsafe {
        <Self as RtActivatable<ICoreApplication3>>::get_activation_factory().request_restart_for_user_async(user, launchArguments)
    }}
    #[inline] pub fn exit() -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplicationExit>>::get_activation_factory().exit()
    }}
    #[inline] pub fn add_exiting(handler: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplicationExit>>::get_activation_factory().add_exiting(handler)
    }}
    #[inline] pub fn remove_exiting(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplicationExit>>::get_activation_factory().remove_exiting(token)
    }}
    #[inline] pub fn add_unhandled_error_detected(handler: &super::super::foundation::EventHandler<UnhandledErrorDetectedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ICoreApplicationUnhandledError>>::get_activation_factory().add_unhandled_error_detected(handler)
    }}
    #[inline] pub fn remove_unhandled_error_detected(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplicationUnhandledError>>::get_activation_factory().remove_unhandled_error_detected(token)
    }}
    #[inline] pub fn increment_application_use_count() -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplicationUseCount>>::get_activation_factory().increment_application_use_count()
    }}
    #[inline] pub fn decrement_application_use_count() -> Result<()> { unsafe {
        <Self as RtActivatable<ICoreApplicationUseCount>>::get_activation_factory().decrement_application_use_count()
    }}
    #[inline] pub fn get_views() -> Result<ComPtr<super::super::foundation::collections::IVectorView<CoreApplicationView>>> { unsafe {
        <Self as RtActivatable<ICoreImmersiveApplication>>::get_activation_factory().get_views()
    }}
    #[inline] pub fn create_new_view(runtimeType: &HStringArg, entryPoint: &HStringArg) -> Result<ComPtr<CoreApplicationView>> { unsafe {
        <Self as RtActivatable<ICoreImmersiveApplication>>::get_activation_factory().create_new_view(runtimeType, entryPoint)
    }}
    #[inline] pub fn get_main_view() -> Result<ComPtr<CoreApplicationView>> { unsafe {
        <Self as RtActivatable<ICoreImmersiveApplication>>::get_activation_factory().get_main_view()
    }}
    #[inline] pub fn create_new_view_from_main_view() -> Result<ComPtr<CoreApplicationView>> { unsafe {
        <Self as RtActivatable<ICoreImmersiveApplication2>>::get_activation_factory().create_new_view_from_main_view()
    }}
    #[inline] pub fn create_new_view_with_view_source(viewSource: &IFrameworkViewSource) -> Result<ComPtr<CoreApplicationView>> { unsafe {
        <Self as RtActivatable<ICoreImmersiveApplication3>>::get_activation_factory().create_new_view_with_view_source(viewSource)
    }}
}
DEFINE_CLSID!(CoreApplication(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,114,101,46,67,111,114,101,65,112,112,108,105,99,97,116,105,111,110,0]) [CLSID_CoreApplication]);
DEFINE_IID!(IID_ICoreApplication2, 2575729147, 6838, 19327, 190, 74, 154, 6, 69, 34, 76, 4);
RT_INTERFACE!{static interface ICoreApplication2(ICoreApplication2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplication2] {
    fn add_BackgroundActivated(&self, handler: *mut super::super::foundation::EventHandler<super::activation::BackgroundActivatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BackgroundActivated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_LeavingBackground(&self, handler: *mut super::super::foundation::EventHandler<super::LeavingBackgroundEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LeavingBackground(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_EnteredBackground(&self, handler: *mut super::super::foundation::EventHandler<super::EnteredBackgroundEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EnteredBackground(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn EnablePrelaunch(&self, value: bool) -> HRESULT
}}
impl ICoreApplication2 {
    #[inline] pub unsafe fn add_background_activated(&self, handler: &super::super::foundation::EventHandler<super::activation::BackgroundActivatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BackgroundActivated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_background_activated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BackgroundActivated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_leaving_background(&self, handler: &super::super::foundation::EventHandler<super::LeavingBackgroundEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LeavingBackground)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_leaving_background(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LeavingBackground)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_entered_background(&self, handler: &super::super::foundation::EventHandler<super::EnteredBackgroundEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EnteredBackground)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_entered_background(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EnteredBackground)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn enable_prelaunch(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).EnablePrelaunch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplication3, 4276882745, 22923, 17671, 138, 103, 119, 38, 50, 88, 10, 87);
RT_INTERFACE!{static interface ICoreApplication3(ICoreApplication3Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplication3] {
    fn RequestRestartAsync(&self, launchArguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<AppRestartFailureReason>) -> HRESULT,
    #[cfg(feature="windows-system")] fn RequestRestartForUserAsync(&self, user: *mut super::super::system::User, launchArguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<AppRestartFailureReason>) -> HRESULT
}}
impl ICoreApplication3 {
    #[inline] pub unsafe fn request_restart_async(&self, launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRestartFailureReason>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestRestartAsync)(self as *const _ as *mut _, launchArguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn request_restart_for_user_async(&self, user: &super::super::system::User, launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRestartFailureReason>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestRestartForUserAsync)(self as *const _ as *mut _, user as *const _ as *mut _, launchArguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationExit, 3481683485, 9758, 19314, 154, 205, 68, 237, 42, 206, 106, 41);
RT_INTERFACE!{static interface ICoreApplicationExit(ICoreApplicationExitVtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationExit] {
    fn Exit(&self) -> HRESULT,
    fn add_Exiting(&self, handler: *mut super::super::foundation::EventHandler<IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Exiting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreApplicationExit {
    #[inline] pub unsafe fn exit(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Exit)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_exiting(&self, handler: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Exiting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_exiting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Exiting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationUnhandledError, 4041362096, 56585, 17121, 176, 188, 224, 225, 49, 247, 141, 126);
RT_INTERFACE!{interface ICoreApplicationUnhandledError(ICoreApplicationUnhandledErrorVtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationUnhandledError] {
    fn add_UnhandledErrorDetected(&self, handler: *mut super::super::foundation::EventHandler<UnhandledErrorDetectedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UnhandledErrorDetected(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreApplicationUnhandledError {
    #[inline] pub unsafe fn add_unhandled_error_detected(&self, handler: &super::super::foundation::EventHandler<UnhandledErrorDetectedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UnhandledErrorDetected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_unhandled_error_detected(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UnhandledErrorDetected)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationUseCount, 1368245256, 49271, 18267, 128, 158, 11, 192, 197, 126, 75, 116);
RT_INTERFACE!{static interface ICoreApplicationUseCount(ICoreApplicationUseCountVtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationUseCount] {
    fn IncrementApplicationUseCount(&self) -> HRESULT,
    fn DecrementApplicationUseCount(&self) -> HRESULT
}}
impl ICoreApplicationUseCount {
    #[inline] pub unsafe fn increment_application_use_count(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).IncrementApplicationUseCount)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn decrement_application_use_count(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DecrementApplicationUseCount)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationView, 1670099675, 17693, 18017, 176, 153, 65, 79, 52, 255, 185, 241);
RT_INTERFACE!{interface ICoreApplicationView(ICoreApplicationViewVtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationView] {
    #[cfg(not(feature="windows-ui"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_CoreWindow(&self, out: *mut *mut super::super::ui::core::CoreWindow) -> HRESULT,
    fn add_Activated(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreApplicationView, super::activation::IActivatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Activated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_IsMain(&self, out: *mut bool) -> HRESULT,
    fn get_IsHosted(&self, out: *mut bool) -> HRESULT
}}
impl ICoreApplicationView {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_core_window(&self) -> Result<ComPtr<super::super::ui::core::CoreWindow>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CoreWindow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_activated(&self, handler: &super::super::foundation::TypedEventHandler<CoreApplicationView, super::activation::IActivatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Activated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_activated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Activated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_main(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hosted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHosted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CoreApplicationView: ICoreApplicationView}
DEFINE_IID!(IID_ICoreApplicationView2, 1760262879, 37247, 18667, 154, 235, 125, 229, 62, 8, 106, 177);
RT_INTERFACE!{interface ICoreApplicationView2(ICoreApplicationView2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationView2] {
    #[cfg(feature="windows-ui")] fn get_Dispatcher(&self, out: *mut *mut super::super::ui::core::CoreDispatcher) -> HRESULT
}}
impl ICoreApplicationView2 {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_dispatcher(&self) -> Result<ComPtr<super::super::ui::core::CoreDispatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dispatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationView3, 132899251, 42191, 17744, 171, 112, 176, 126, 133, 51, 11, 200);
RT_INTERFACE!{interface ICoreApplicationView3(ICoreApplicationView3Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationView3] {
    fn get_IsComponent(&self, out: *mut bool) -> HRESULT,
    fn get_TitleBar(&self, out: *mut *mut CoreApplicationViewTitleBar) -> HRESULT,
    fn add_HostedViewClosing(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreApplicationView, HostedViewClosingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HostedViewClosing(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreApplicationView3 {
    #[inline] pub unsafe fn get_is_component(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComponent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_bar(&self) -> Result<ComPtr<CoreApplicationViewTitleBar>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleBar)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hosted_view_closing(&self, handler: &super::super::foundation::TypedEventHandler<CoreApplicationView, HostedViewClosingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HostedViewClosing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hosted_view_closing(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HostedViewClosing)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationView5, 734041512, 36592, 17517, 158, 96, 58, 62, 4, 40, 198, 113);
RT_INTERFACE!{interface ICoreApplicationView5(ICoreApplicationView5Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationView5] {
    fn get_Properties(&self, out: *mut *mut super::super::foundation::collections::IPropertySet) -> HRESULT
}}
impl ICoreApplicationView5 {
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IPropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationView6, 3239695514, 1657, 18874, 128, 63, 183, 156, 92, 243, 76, 202);
RT_INTERFACE!{interface ICoreApplicationView6(ICoreApplicationView6Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationView6] {
    #[cfg(feature="windows-system")] fn get_DispatcherQueue(&self, out: *mut *mut super::super::system::DispatcherQueue) -> HRESULT
}}
impl ICoreApplicationView6 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_dispatcher_queue(&self) -> Result<ComPtr<super::super::system::DispatcherQueue>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DispatcherQueue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreApplicationViewTitleBar, 7157219, 57841, 17179, 149, 8, 41, 185, 105, 38, 172, 83);
RT_INTERFACE!{interface ICoreApplicationViewTitleBar(ICoreApplicationViewTitleBarVtbl): IInspectable(IInspectableVtbl) [IID_ICoreApplicationViewTitleBar] {
    fn put_ExtendViewIntoTitleBar(&self, value: bool) -> HRESULT,
    fn get_ExtendViewIntoTitleBar(&self, out: *mut bool) -> HRESULT,
    fn get_SystemOverlayLeftInset(&self, out: *mut f64) -> HRESULT,
    fn get_SystemOverlayRightInset(&self, out: *mut f64) -> HRESULT,
    fn get_Height(&self, out: *mut f64) -> HRESULT,
    fn add_LayoutMetricsChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreApplicationViewTitleBar, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LayoutMetricsChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_IsVisible(&self, out: *mut bool) -> HRESULT,
    fn add_IsVisibleChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreApplicationViewTitleBar, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_IsVisibleChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreApplicationViewTitleBar {
    #[inline] pub unsafe fn set_extend_view_into_title_bar(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ExtendViewIntoTitleBar)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extend_view_into_title_bar(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendViewIntoTitleBar)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_overlay_left_inset(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemOverlayLeftInset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_overlay_right_inset(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemOverlayRightInset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Height)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_layout_metrics_changed(&self, handler: &super::super::foundation::TypedEventHandler<CoreApplicationViewTitleBar, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LayoutMetricsChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_layout_metrics_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LayoutMetricsChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_is_visible_changed(&self, handler: &super::super::foundation::TypedEventHandler<CoreApplicationViewTitleBar, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_IsVisibleChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_is_visible_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_IsVisibleChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreApplicationViewTitleBar: ICoreApplicationViewTitleBar}
DEFINE_IID!(IID_ICoreImmersiveApplication, 450498110, 58530, 16675, 180, 81, 220, 150, 191, 128, 4, 25);
RT_INTERFACE!{static interface ICoreImmersiveApplication(ICoreImmersiveApplicationVtbl): IInspectable(IInspectableVtbl) [IID_ICoreImmersiveApplication] {
    fn get_Views(&self, out: *mut *mut super::super::foundation::collections::IVectorView<CoreApplicationView>) -> HRESULT,
    fn CreateNewView(&self, runtimeType: HSTRING, entryPoint: HSTRING, out: *mut *mut CoreApplicationView) -> HRESULT,
    fn get_MainView(&self, out: *mut *mut CoreApplicationView) -> HRESULT
}}
impl ICoreImmersiveApplication {
    #[inline] pub unsafe fn get_views(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<CoreApplicationView>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Views)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_new_view(&self, runtimeType: &HStringArg, entryPoint: &HStringArg) -> Result<ComPtr<CoreApplicationView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateNewView)(self as *const _ as *mut _, runtimeType.get(), entryPoint.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_main_view(&self) -> Result<ComPtr<CoreApplicationView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MainView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreImmersiveApplication2, 2190351926, 59875, 19708, 155, 102, 72, 183, 142, 169, 187, 44);
RT_INTERFACE!{static interface ICoreImmersiveApplication2(ICoreImmersiveApplication2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreImmersiveApplication2] {
    fn CreateNewViewFromMainView(&self, out: *mut *mut CoreApplicationView) -> HRESULT
}}
impl ICoreImmersiveApplication2 {
    #[inline] pub unsafe fn create_new_view_from_main_view(&self) -> Result<ComPtr<CoreApplicationView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateNewViewFromMainView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreImmersiveApplication3, 882924335, 60941, 16869, 131, 20, 207, 16, 201, 27, 240, 175);
RT_INTERFACE!{static interface ICoreImmersiveApplication3(ICoreImmersiveApplication3Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreImmersiveApplication3] {
    fn CreateNewViewWithViewSource(&self, viewSource: *mut IFrameworkViewSource, out: *mut *mut CoreApplicationView) -> HRESULT
}}
impl ICoreImmersiveApplication3 {
    #[inline] pub unsafe fn create_new_view_with_view_source(&self, viewSource: &IFrameworkViewSource) -> Result<ComPtr<CoreApplicationView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateNewViewWithViewSource)(self as *const _ as *mut _, viewSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkView, 4205534416, 35108, 17836, 173, 15, 160, 143, 174, 93, 3, 36);
RT_INTERFACE!{interface IFrameworkView(IFrameworkViewVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkView] {
    fn Initialize(&self, applicationView: *mut CoreApplicationView) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-ui")] fn SetWindow(&self, window: *mut super::super::ui::core::CoreWindow) -> HRESULT,
    fn Load(&self, entryPoint: HSTRING) -> HRESULT,
    fn Run(&self) -> HRESULT,
    fn Uninitialize(&self) -> HRESULT
}}
impl IFrameworkView {
    #[inline] pub unsafe fn initialize(&self, applicationView: &CoreApplicationView) -> Result<()> {
        let hr = ((*self.lpVtbl).Initialize)(self as *const _ as *mut _, applicationView as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_window(&self, window: &super::super::ui::core::CoreWindow) -> Result<()> {
        let hr = ((*self.lpVtbl).SetWindow)(self as *const _ as *mut _, window as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn load(&self, entryPoint: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).Load)(self as *const _ as *mut _, entryPoint.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn run(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Run)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn uninitialize(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Uninitialize)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkViewSource, 3447129620, 26052, 17004, 148, 148, 52, 252, 67, 85, 72, 98);
RT_INTERFACE!{interface IFrameworkViewSource(IFrameworkViewSourceVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkViewSource] {
    fn CreateView(&self, out: *mut *mut IFrameworkView) -> HRESULT
}}
impl IFrameworkViewSource {
    #[inline] pub unsafe fn create_view(&self) -> Result<ComPtr<IFrameworkView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHostedViewClosingEventArgs, 3526923324, 45646, 18320, 172, 181, 62, 66, 67, 196, 255, 135);
RT_INTERFACE!{interface IHostedViewClosingEventArgs(IHostedViewClosingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IHostedViewClosingEventArgs] {
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl IHostedViewClosingEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class HostedViewClosingEventArgs: IHostedViewClosingEventArgs}
DEFINE_IID!(IID_IUnhandledError, 2488907558, 21429, 18054, 158, 175, 250, 129, 98, 220, 57, 128);
RT_INTERFACE!{interface IUnhandledError(IUnhandledErrorVtbl): IInspectable(IInspectableVtbl) [IID_IUnhandledError] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn Propagate(&self) -> HRESULT
}}
impl IUnhandledError {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn propagate(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Propagate)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class UnhandledError: IUnhandledError}
DEFINE_IID!(IID_IUnhandledErrorDetectedEventArgs, 1738192779, 45878, 18466, 172, 64, 13, 117, 15, 11, 122, 43);
RT_INTERFACE!{interface IUnhandledErrorDetectedEventArgs(IUnhandledErrorDetectedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IUnhandledErrorDetectedEventArgs] {
    fn get_UnhandledError(&self, out: *mut *mut UnhandledError) -> HRESULT
}}
impl IUnhandledErrorDetectedEventArgs {
    #[inline] pub unsafe fn get_unhandled_error(&self) -> Result<ComPtr<UnhandledError>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UnhandledError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class UnhandledErrorDetectedEventArgs: IUnhandledErrorDetectedEventArgs}
} // Windows.ApplicationModel.Core
pub mod appservice { // Windows.ApplicationModel.AppService
use ::prelude::*;
RT_CLASS!{static class AppServiceCatalog}
impl RtActivatable<IAppServiceCatalogStatics> for AppServiceCatalog {}
impl AppServiceCatalog {
    #[inline] pub fn find_app_service_providers_async(appServiceName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<super::AppInfo>>>> { unsafe {
        <Self as RtActivatable<IAppServiceCatalogStatics>>::get_activation_factory().find_app_service_providers_async(appServiceName)
    }}
}
DEFINE_CLSID!(AppServiceCatalog(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,83,101,114,118,105,99,101,46,65,112,112,83,101,114,118,105,99,101,67,97,116,97,108,111,103,0]) [CLSID_AppServiceCatalog]);
DEFINE_IID!(IID_IAppServiceCatalogStatics, 4010616071, 53554, 19589, 131, 149, 60, 49, 213, 161, 233, 65);
RT_INTERFACE!{static interface IAppServiceCatalogStatics(IAppServiceCatalogStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceCatalogStatics] {
    fn FindAppServiceProvidersAsync(&self, appServiceName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<super::AppInfo>>) -> HRESULT
}}
impl IAppServiceCatalogStatics {
    #[inline] pub unsafe fn find_app_service_providers_async(&self, appServiceName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<super::AppInfo>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppServiceProvidersAsync)(self as *const _ as *mut _, appServiceName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppServiceClosedEventArgs, 3730839286, 51971, 19765, 172, 141, 204, 99, 3, 35, 151, 49);
RT_INTERFACE!{interface IAppServiceClosedEventArgs(IAppServiceClosedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceClosedEventArgs] {
    fn get_Status(&self, out: *mut AppServiceClosedStatus) -> HRESULT
}}
impl IAppServiceClosedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<AppServiceClosedStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceClosedEventArgs: IAppServiceClosedEventArgs}
RT_ENUM! { enum AppServiceClosedStatus: i32 {
    Completed (AppServiceClosedStatus_Completed) = 0, Canceled (AppServiceClosedStatus_Canceled) = 1, ResourceLimitsExceeded (AppServiceClosedStatus_ResourceLimitsExceeded) = 2, Unknown (AppServiceClosedStatus_Unknown) = 3,
}}
DEFINE_IID!(IID_IAppServiceConnection, 2647946402, 34591, 19794, 137, 169, 158, 9, 5, 49, 189, 39);
RT_INTERFACE!{interface IAppServiceConnection(IAppServiceConnectionVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceConnection] {
    fn get_AppServiceName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_AppServiceName(&self, value: HSTRING) -> HRESULT,
    fn get_PackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PackageFamilyName(&self, value: HSTRING) -> HRESULT,
    fn OpenAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<AppServiceConnectionStatus>) -> HRESULT,
    fn SendMessageAsync(&self, message: *mut super::super::foundation::collections::ValueSet, out: *mut *mut super::super::foundation::IAsyncOperation<AppServiceResponse>) -> HRESULT,
    fn add_RequestReceived(&self, handler: *mut super::super::foundation::TypedEventHandler<AppServiceConnection, AppServiceRequestReceivedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RequestReceived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ServiceClosed(&self, handler: *mut super::super::foundation::TypedEventHandler<AppServiceConnection, AppServiceClosedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ServiceClosed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppServiceConnection {
    #[inline] pub unsafe fn get_app_service_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppServiceName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_app_service_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppServiceName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_package_family_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PackageFamilyName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppServiceConnectionStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn send_message_async(&self, message: &super::super::foundation::collections::ValueSet) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppServiceResponse>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendMessageAsync)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_request_received(&self, handler: &super::super::foundation::TypedEventHandler<AppServiceConnection, AppServiceRequestReceivedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RequestReceived)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_request_received(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RequestReceived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_service_closed(&self, handler: &super::super::foundation::TypedEventHandler<AppServiceConnection, AppServiceClosedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ServiceClosed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_service_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ServiceClosed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceConnection: IAppServiceConnection}
impl RtActivatable<IActivationFactory> for AppServiceConnection {}
DEFINE_CLSID!(AppServiceConnection(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,83,101,114,118,105,99,101,46,65,112,112,83,101,114,118,105,99,101,67,111,110,110,101,99,116,105,111,110,0]) [CLSID_AppServiceConnection]);
DEFINE_IID!(IID_IAppServiceConnection2, 2346700127, 8962, 20413, 128, 97, 82, 81, 28, 47, 139, 249);
RT_INTERFACE!{interface IAppServiceConnection2(IAppServiceConnection2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceConnection2] {
    #[cfg(feature="windows-system")] fn OpenRemoteAsync(&self, remoteSystemConnectionRequest: *mut super::super::system::remotesystems::RemoteSystemConnectionRequest, out: *mut *mut super::super::foundation::IAsyncOperation<AppServiceConnectionStatus>) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_User(&self, value: *mut super::super::system::User) -> HRESULT
}}
impl IAppServiceConnection2 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn open_remote_async(&self, remoteSystemConnectionRequest: &super::super::system::remotesystems::RemoteSystemConnectionRequest) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppServiceConnectionStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenRemoteAsync)(self as *const _ as *mut _, remoteSystemConnectionRequest as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_user(&self, value: &super::super::system::User) -> Result<()> {
        let hr = ((*self.lpVtbl).put_User)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppServiceConnectionStatus: i32 {
    Success (AppServiceConnectionStatus_Success) = 0, AppNotInstalled (AppServiceConnectionStatus_AppNotInstalled) = 1, AppUnavailable (AppServiceConnectionStatus_AppUnavailable) = 2, AppServiceUnavailable (AppServiceConnectionStatus_AppServiceUnavailable) = 3, Unknown (AppServiceConnectionStatus_Unknown) = 4, RemoteSystemUnavailable (AppServiceConnectionStatus_RemoteSystemUnavailable) = 5, RemoteSystemNotSupportedByApp (AppServiceConnectionStatus_RemoteSystemNotSupportedByApp) = 6, NotAuthorized (AppServiceConnectionStatus_NotAuthorized) = 7,
}}
DEFINE_IID!(IID_IAppServiceDeferral, 2115719970, 60080, 16968, 174, 4, 253, 249, 56, 56, 228, 114);
RT_INTERFACE!{interface IAppServiceDeferral(IAppServiceDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IAppServiceDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceDeferral: IAppServiceDeferral}
DEFINE_IID!(IID_IAppServiceRequest, 551914909, 6366, 19201, 128, 186, 144, 167, 98, 4, 227, 200);
RT_INTERFACE!{interface IAppServiceRequest(IAppServiceRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceRequest] {
    fn get_Message(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT,
    fn SendResponseAsync(&self, message: *mut super::super::foundation::collections::ValueSet, out: *mut *mut super::super::foundation::IAsyncOperation<AppServiceResponseStatus>) -> HRESULT
}}
impl IAppServiceRequest {
    #[inline] pub unsafe fn get_message(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn send_response_async(&self, message: &super::super::foundation::collections::ValueSet) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppServiceResponseStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendResponseAsync)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceRequest: IAppServiceRequest}
DEFINE_IID!(IID_IAppServiceRequestReceivedEventArgs, 1846682464, 65381, 17582, 158, 69, 133, 127, 228, 24, 6, 129);
RT_INTERFACE!{interface IAppServiceRequestReceivedEventArgs(IAppServiceRequestReceivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceRequestReceivedEventArgs] {
    fn get_Request(&self, out: *mut *mut AppServiceRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut AppServiceDeferral) -> HRESULT
}}
impl IAppServiceRequestReceivedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppServiceRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<AppServiceDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceRequestReceivedEventArgs: IAppServiceRequestReceivedEventArgs}
DEFINE_IID!(IID_IAppServiceResponse, 2370845932, 39587, 20072, 149, 89, 157, 230, 62, 55, 44, 228);
RT_INTERFACE!{interface IAppServiceResponse(IAppServiceResponseVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceResponse] {
    fn get_Message(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT,
    fn get_Status(&self, out: *mut AppServiceResponseStatus) -> HRESULT
}}
impl IAppServiceResponse {
    #[inline] pub unsafe fn get_message(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<AppServiceResponseStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceResponse: IAppServiceResponse}
RT_ENUM! { enum AppServiceResponseStatus: i32 {
    Success (AppServiceResponseStatus_Success) = 0, Failure (AppServiceResponseStatus_Failure) = 1, ResourceLimitsExceeded (AppServiceResponseStatus_ResourceLimitsExceeded) = 2, Unknown (AppServiceResponseStatus_Unknown) = 3, RemoteSystemUnavailable (AppServiceResponseStatus_RemoteSystemUnavailable) = 4, MessageSizeTooLarge (AppServiceResponseStatus_MessageSizeTooLarge) = 5,
}}
DEFINE_IID!(IID_IAppServiceTriggerDetails, 2292374700, 44328, 16824, 128, 187, 189, 241, 178, 22, 158, 25);
RT_INTERFACE!{interface IAppServiceTriggerDetails(IAppServiceTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceTriggerDetails] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CallerPackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppServiceConnection(&self, out: *mut *mut AppServiceConnection) -> HRESULT
}}
impl IAppServiceTriggerDetails {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_caller_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallerPackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_service_connection(&self) -> Result<ComPtr<AppServiceConnection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppServiceConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppServiceTriggerDetails: IAppServiceTriggerDetails}
DEFINE_IID!(IID_IAppServiceTriggerDetails2, 3896333490, 10444, 17394, 180, 101, 192, 72, 46, 89, 226, 220);
RT_INTERFACE!{interface IAppServiceTriggerDetails2(IAppServiceTriggerDetails2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceTriggerDetails2] {
    fn get_IsRemoteSystemConnection(&self, out: *mut bool) -> HRESULT
}}
impl IAppServiceTriggerDetails2 {
    #[inline] pub unsafe fn get_is_remote_system_connection(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRemoteSystemConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppServiceTriggerDetails3, 4225179169, 31033, 20072, 158, 60, 119, 128, 20, 122, 171, 182);
RT_INTERFACE!{interface IAppServiceTriggerDetails3(IAppServiceTriggerDetails3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppServiceTriggerDetails3] {
    fn CheckCallerForCapabilityAsync(&self, capabilityName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IAppServiceTriggerDetails3 {
    #[inline] pub unsafe fn check_caller_for_capability_async(&self, capabilityName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CheckCallerForCapabilityAsync)(self as *const _ as *mut _, capabilityName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.ApplicationModel.AppService
pub mod appointments { // Windows.ApplicationModel.Appointments
use ::prelude::*;
DEFINE_IID!(IID_IAppointment, 3707776815, 11229, 16502, 144, 163, 34, 194, 117, 49, 41, 101);
RT_INTERFACE!{interface IAppointment(IAppointmentVtbl): IInspectable(IInspectableVtbl) [IID_IAppointment] {
    fn get_StartTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_StartTime(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_Duration(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Location(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Location(&self, value: HSTRING) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Subject(&self, value: HSTRING) -> HRESULT,
    fn get_Details(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Details(&self, value: HSTRING) -> HRESULT,
    fn get_Reminder(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_Reminder(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_Organizer(&self, out: *mut *mut AppointmentOrganizer) -> HRESULT,
    fn put_Organizer(&self, value: *mut AppointmentOrganizer) -> HRESULT,
    fn get_Invitees(&self, out: *mut *mut super::super::foundation::collections::IVector<AppointmentInvitee>) -> HRESULT,
    fn get_Recurrence(&self, out: *mut *mut AppointmentRecurrence) -> HRESULT,
    fn put_Recurrence(&self, value: *mut AppointmentRecurrence) -> HRESULT,
    fn get_BusyStatus(&self, out: *mut AppointmentBusyStatus) -> HRESULT,
    fn put_BusyStatus(&self, value: AppointmentBusyStatus) -> HRESULT,
    fn get_AllDay(&self, out: *mut bool) -> HRESULT,
    fn put_AllDay(&self, value: bool) -> HRESULT,
    fn get_Sensitivity(&self, out: *mut AppointmentSensitivity) -> HRESULT,
    fn put_Sensitivity(&self, value: AppointmentSensitivity) -> HRESULT,
    fn get_Uri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Uri(&self, value: *mut super::super::foundation::Uri) -> HRESULT
}}
impl IAppointment {
    #[inline] pub unsafe fn get_start_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Location)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_location(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Location)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subject(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Subject)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_details(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Details)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_details(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Details)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reminder(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Reminder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reminder(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Reminder)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_organizer(&self) -> Result<ComPtr<AppointmentOrganizer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Organizer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_organizer(&self, value: &AppointmentOrganizer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Organizer)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invitees(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<AppointmentInvitee>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Invitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recurrence(&self) -> Result<ComPtr<AppointmentRecurrence>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Recurrence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_recurrence(&self, value: &AppointmentRecurrence) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Recurrence)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_busy_status(&self) -> Result<AppointmentBusyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BusyStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_busy_status(&self, value: AppointmentBusyStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BusyStatus)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_day(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllDay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_all_day(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllDay)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sensitivity(&self) -> Result<AppointmentSensitivity> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Sensitivity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sensitivity(&self, value: AppointmentSensitivity) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Sensitivity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Uri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Uri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Appointment: IAppointment}
impl RtActivatable<IActivationFactory> for Appointment {}
DEFINE_CLSID!(Appointment(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,0]) [CLSID_Appointment]);
DEFINE_IID!(IID_IAppointment2, 1585813564, 21519, 13394, 155, 92, 13, 215, 173, 76, 101, 162);
RT_INTERFACE!{interface IAppointment2(IAppointment2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointment2] {
    fn get_LocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CalendarId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RoamingId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RoamingId(&self, value: HSTRING) -> HRESULT,
    fn get_OriginalStartTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_IsResponseRequested(&self, out: *mut bool) -> HRESULT,
    fn put_IsResponseRequested(&self, value: bool) -> HRESULT,
    fn get_AllowNewTimeProposal(&self, out: *mut bool) -> HRESULT,
    fn put_AllowNewTimeProposal(&self, value: bool) -> HRESULT,
    fn get_OnlineMeetingLink(&self, out: *mut HSTRING) -> HRESULT,
    fn put_OnlineMeetingLink(&self, value: HSTRING) -> HRESULT,
    fn get_ReplyTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_ReplyTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_UserResponse(&self, out: *mut AppointmentParticipantResponse) -> HRESULT,
    fn put_UserResponse(&self, value: AppointmentParticipantResponse) -> HRESULT,
    fn get_HasInvitees(&self, out: *mut bool) -> HRESULT,
    fn get_IsCanceledMeeting(&self, out: *mut bool) -> HRESULT,
    fn put_IsCanceledMeeting(&self, value: bool) -> HRESULT,
    fn get_IsOrganizedByUser(&self, out: *mut bool) -> HRESULT,
    fn put_IsOrganizedByUser(&self, value: bool) -> HRESULT
}}
impl IAppointment2 {
    #[inline] pub unsafe fn get_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_roaming_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RoamingId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_roaming_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoamingId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_original_start_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OriginalStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_response_requested(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsResponseRequested)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_response_requested(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsResponseRequested)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_new_time_proposal(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowNewTimeProposal)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_new_time_proposal(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowNewTimeProposal)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_online_meeting_link(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OnlineMeetingLink)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_online_meeting_link(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OnlineMeetingLink)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reply_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ReplyTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reply_time(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReplyTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_response(&self) -> Result<AppointmentParticipantResponse> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UserResponse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_user_response(&self, value: AppointmentParticipantResponse) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UserResponse)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_invitees(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasInvitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled_meeting(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceledMeeting)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_canceled_meeting(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCanceledMeeting)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_organized_by_user(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOrganizedByUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_organized_by_user(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOrganizedByUser)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointment3, 3217835433, 35169, 18833, 147, 75, 196, 135, 104, 229, 169, 108);
RT_INTERFACE!{interface IAppointment3(IAppointment3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointment3] {
    fn get_ChangeNumber(&self, out: *mut u64) -> HRESULT,
    fn get_RemoteChangeNumber(&self, out: *mut u64) -> HRESULT,
    fn put_RemoteChangeNumber(&self, value: u64) -> HRESULT,
    fn get_DetailsKind(&self, out: *mut AppointmentDetailsKind) -> HRESULT,
    fn put_DetailsKind(&self, value: AppointmentDetailsKind) -> HRESULT
}}
impl IAppointment3 {
    #[inline] pub unsafe fn get_change_number(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChangeNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_change_number(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RemoteChangeNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_change_number(&self, value: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteChangeNumber)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_details_kind(&self) -> Result<AppointmentDetailsKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DetailsKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_details_kind(&self, value: AppointmentDetailsKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DetailsKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentBusyStatus: i32 {
    Busy (AppointmentBusyStatus_Busy) = 0, Tentative (AppointmentBusyStatus_Tentative) = 1, Free (AppointmentBusyStatus_Free) = 2, OutOfOffice (AppointmentBusyStatus_OutOfOffice) = 3, WorkingElsewhere (AppointmentBusyStatus_WorkingElsewhere) = 4,
}}
DEFINE_IID!(IID_IAppointmentCalendar, 1383301533, 33593, 15695, 160, 47, 100, 8, 68, 82, 187, 93);
RT_INTERFACE!{interface IAppointmentCalendar(IAppointmentCalendarVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendar] {
    #[cfg(not(feature="windows-ui"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_DisplayColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_LocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsHidden(&self, out: *mut bool) -> HRESULT,
    fn get_OtherAppReadAccess(&self, out: *mut AppointmentCalendarOtherAppReadAccess) -> HRESULT,
    fn put_OtherAppReadAccess(&self, value: AppointmentCalendarOtherAppReadAccess) -> HRESULT,
    fn get_OtherAppWriteAccess(&self, out: *mut AppointmentCalendarOtherAppWriteAccess) -> HRESULT,
    fn put_OtherAppWriteAccess(&self, value: AppointmentCalendarOtherAppWriteAccess) -> HRESULT,
    fn get_SourceDisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SummaryCardView(&self, out: *mut AppointmentSummaryCardView) -> HRESULT,
    fn put_SummaryCardView(&self, value: AppointmentSummaryCardView) -> HRESULT,
    fn FindAppointmentsAsync(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn FindAppointmentsAsyncWithOptions(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, options: *mut FindAppointmentsOptions, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn FindExceptionsFromMasterAsync(&self, masterLocalId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentException>>) -> HRESULT,
    fn FindAllInstancesAsync(&self, masterLocalId: HSTRING, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn FindAllInstancesAsyncWithOptions(&self, masterLocalId: HSTRING, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, pOptions: *mut FindAppointmentsOptions, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn GetAppointmentAsync(&self, localId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Appointment>) -> HRESULT,
    fn GetAppointmentInstanceAsync(&self, localId: HSTRING, instanceStartTime: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<Appointment>) -> HRESULT,
    fn FindUnexpandedAppointmentsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn FindUnexpandedAppointmentsAsyncWithOptions(&self, options: *mut FindAppointmentsOptions, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn DeleteAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SaveAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteAppointmentAsync(&self, localId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteAppointmentInstanceAsync(&self, localId: HSTRING, instanceStartTime: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SaveAppointmentAsync(&self, pAppointment: *mut Appointment, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendar {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_display_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisplayColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hidden(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHidden)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_other_app_read_access(&self) -> Result<AppointmentCalendarOtherAppReadAccess> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OtherAppReadAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_other_app_read_access(&self, value: AppointmentCalendarOtherAppReadAccess) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OtherAppReadAccess)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_other_app_write_access(&self) -> Result<AppointmentCalendarOtherAppWriteAccess> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OtherAppWriteAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_other_app_write_access(&self, value: AppointmentCalendarOtherAppWriteAccess) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OtherAppWriteAccess)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceDisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_summary_card_view(&self) -> Result<AppointmentSummaryCardView> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SummaryCardView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_summary_card_view(&self, value: AppointmentSummaryCardView) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SummaryCardView)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_appointments_async(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppointmentsAsync)(self as *const _ as *mut _, rangeStart, rangeLength, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_appointments_async_with_options(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, options: &FindAppointmentsOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppointmentsAsyncWithOptions)(self as *const _ as *mut _, rangeStart, rangeLength, options as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_exceptions_from_master_async(&self, masterLocalId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentException>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindExceptionsFromMasterAsync)(self as *const _ as *mut _, masterLocalId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_instances_async(&self, masterLocalId: &HStringArg, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllInstancesAsync)(self as *const _ as *mut _, masterLocalId.get(), rangeStart, rangeLength, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_instances_async_with_options(&self, masterLocalId: &HStringArg, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, pOptions: &FindAppointmentsOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllInstancesAsyncWithOptions)(self as *const _ as *mut _, masterLocalId.get(), rangeStart, rangeLength, pOptions as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_async(&self, localId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Appointment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppointmentAsync)(self as *const _ as *mut _, localId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_instance_async(&self, localId: &HStringArg, instanceStartTime: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Appointment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppointmentInstanceAsync)(self as *const _ as *mut _, localId.get(), instanceStartTime, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_unexpanded_appointments_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindUnexpandedAppointmentsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_unexpanded_appointments_async_with_options(&self, options: &FindAppointmentsOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindUnexpandedAppointmentsAsyncWithOptions)(self as *const _ as *mut _, options as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_appointment_async(&self, localId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAppointmentAsync)(self as *const _ as *mut _, localId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_appointment_instance_async(&self, localId: &HStringArg, instanceStartTime: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAppointmentInstanceAsync)(self as *const _ as *mut _, localId.get(), instanceStartTime, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_appointment_async(&self, pAppointment: &Appointment) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveAppointmentAsync)(self as *const _ as *mut _, pAppointment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendar: IAppointmentCalendar}
DEFINE_IID!(IID_IAppointmentCalendar2, 417850402, 9319, 19996, 164, 89, 216, 162, 147, 3, 208, 146);
RT_INTERFACE!{interface IAppointmentCalendar2(IAppointmentCalendar2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendar2] {
    fn get_SyncManager(&self, out: *mut *mut AppointmentCalendarSyncManager) -> HRESULT,
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_DisplayColor(&self, value: super::super::ui::Color) -> HRESULT,
    fn put_IsHidden(&self, value: bool) -> HRESULT,
    fn get_UserDataAccountId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CanCreateOrUpdateAppointments(&self, out: *mut bool) -> HRESULT,
    fn put_CanCreateOrUpdateAppointments(&self, value: bool) -> HRESULT,
    fn get_CanCancelMeetings(&self, out: *mut bool) -> HRESULT,
    fn put_CanCancelMeetings(&self, value: bool) -> HRESULT,
    fn get_CanForwardMeetings(&self, out: *mut bool) -> HRESULT,
    fn put_CanForwardMeetings(&self, value: bool) -> HRESULT,
    fn get_CanProposeNewTimeForMeetings(&self, out: *mut bool) -> HRESULT,
    fn put_CanProposeNewTimeForMeetings(&self, value: bool) -> HRESULT,
    fn get_CanUpdateMeetingResponses(&self, out: *mut bool) -> HRESULT,
    fn put_CanUpdateMeetingResponses(&self, value: bool) -> HRESULT,
    fn get_CanNotifyInvitees(&self, out: *mut bool) -> HRESULT,
    fn put_CanNotifyInvitees(&self, value: bool) -> HRESULT,
    fn get_MustNofityInvitees(&self, out: *mut bool) -> HRESULT,
    fn put_MustNofityInvitees(&self, value: bool) -> HRESULT,
    fn TryCreateOrUpdateAppointmentAsync(&self, appointment: *mut Appointment, notifyInvitees: bool, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryCancelMeetingAsync(&self, meeting: *mut Appointment, subject: HSTRING, comment: HSTRING, notifyInvitees: bool, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryForwardMeetingAsync(&self, meeting: *mut Appointment, invitees: *mut super::super::foundation::collections::IIterable<AppointmentInvitee>, subject: HSTRING, forwardHeader: HSTRING, comment: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryProposeNewTimeForMeetingAsync(&self, meeting: *mut Appointment, newStartTime: super::super::foundation::DateTime, newDuration: super::super::foundation::TimeSpan, subject: HSTRING, comment: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryUpdateMeetingResponseAsync(&self, meeting: *mut Appointment, response: AppointmentParticipantResponse, subject: HSTRING, comment: HSTRING, sendUpdate: bool, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IAppointmentCalendar2 {
    #[inline] pub unsafe fn get_sync_manager(&self) -> Result<ComPtr<AppointmentCalendarSyncManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SyncManager)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_display_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_hidden(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHidden)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_data_account_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserDataAccountId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_create_or_update_appointments(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanCreateOrUpdateAppointments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_create_or_update_appointments(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanCreateOrUpdateAppointments)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_cancel_meetings(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanCancelMeetings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_cancel_meetings(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanCancelMeetings)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_forward_meetings(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanForwardMeetings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_forward_meetings(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanForwardMeetings)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_propose_new_time_for_meetings(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanProposeNewTimeForMeetings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_propose_new_time_for_meetings(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanProposeNewTimeForMeetings)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_update_meeting_responses(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanUpdateMeetingResponses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_update_meeting_responses(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanUpdateMeetingResponses)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_notify_invitees(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanNotifyInvitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_notify_invitees(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanNotifyInvitees)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_must_nofity_invitees(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MustNofityInvitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_must_nofity_invitees(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MustNofityInvitees)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_create_or_update_appointment_async(&self, appointment: &Appointment, notifyInvitees: bool) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCreateOrUpdateAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, notifyInvitees, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_cancel_meeting_async(&self, meeting: &Appointment, subject: &HStringArg, comment: &HStringArg, notifyInvitees: bool) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCancelMeetingAsync)(self as *const _ as *mut _, meeting as *const _ as *mut _, subject.get(), comment.get(), notifyInvitees, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_forward_meeting_async(&self, meeting: &Appointment, invitees: &super::super::foundation::collections::IIterable<AppointmentInvitee>, subject: &HStringArg, forwardHeader: &HStringArg, comment: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryForwardMeetingAsync)(self as *const _ as *mut _, meeting as *const _ as *mut _, invitees as *const _ as *mut _, subject.get(), forwardHeader.get(), comment.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_propose_new_time_for_meeting_async(&self, meeting: &Appointment, newStartTime: super::super::foundation::DateTime, newDuration: super::super::foundation::TimeSpan, subject: &HStringArg, comment: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryProposeNewTimeForMeetingAsync)(self as *const _ as *mut _, meeting as *const _ as *mut _, newStartTime, newDuration, subject.get(), comment.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_update_meeting_response_async(&self, meeting: &Appointment, response: AppointmentParticipantResponse, subject: &HStringArg, comment: &HStringArg, sendUpdate: bool) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryUpdateMeetingResponseAsync)(self as *const _ as *mut _, meeting as *const _ as *mut _, response, subject.get(), comment.get(), sendUpdate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentCalendar3, 3944993323, 42629, 17070, 132, 149, 179, 17, 154, 219, 65, 103);
RT_INTERFACE!{interface IAppointmentCalendar3(IAppointmentCalendar3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendar3] {
    fn RegisterSyncManagerAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendar3 {
    #[inline] pub unsafe fn register_sync_manager_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RegisterSyncManagerAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentCalendarOtherAppReadAccess: i32 {
    SystemOnly (AppointmentCalendarOtherAppReadAccess_SystemOnly) = 0, Limited (AppointmentCalendarOtherAppReadAccess_Limited) = 1, Full (AppointmentCalendarOtherAppReadAccess_Full) = 2, None (AppointmentCalendarOtherAppReadAccess_None) = 3,
}}
RT_ENUM! { enum AppointmentCalendarOtherAppWriteAccess: i32 {
    None (AppointmentCalendarOtherAppWriteAccess_None) = 0, SystemOnly (AppointmentCalendarOtherAppWriteAccess_SystemOnly) = 1, Limited (AppointmentCalendarOtherAppWriteAccess_Limited) = 2,
}}
DEFINE_IID!(IID_IAppointmentCalendarSyncManager, 723628960, 19199, 17298, 188, 95, 86, 69, 255, 207, 251, 23);
RT_INTERFACE!{interface IAppointmentCalendarSyncManager(IAppointmentCalendarSyncManagerVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarSyncManager] {
    fn get_Status(&self, out: *mut AppointmentCalendarSyncStatus) -> HRESULT,
    fn get_LastSuccessfulSyncTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_LastAttemptedSyncTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn SyncAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn add_SyncStatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppointmentCalendarSyncManager, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SyncStatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppointmentCalendarSyncManager {
    #[inline] pub unsafe fn get_status(&self) -> Result<AppointmentCalendarSyncStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_last_successful_sync_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LastSuccessfulSyncTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_last_attempted_sync_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LastAttemptedSyncTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn sync_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SyncAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sync_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppointmentCalendarSyncManager, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SyncStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sync_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SyncStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarSyncManager: IAppointmentCalendarSyncManager}
DEFINE_IID!(IID_IAppointmentCalendarSyncManager2, 1685399725, 3369, 19580, 170, 167, 191, 153, 104, 5, 83, 124);
RT_INTERFACE!{interface IAppointmentCalendarSyncManager2(IAppointmentCalendarSyncManager2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarSyncManager2] {
    fn put_Status(&self, value: AppointmentCalendarSyncStatus) -> HRESULT,
    fn put_LastSuccessfulSyncTime(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn put_LastAttemptedSyncTime(&self, value: super::super::foundation::DateTime) -> HRESULT
}}
impl IAppointmentCalendarSyncManager2 {
    #[inline] pub unsafe fn set_status(&self, value: AppointmentCalendarSyncStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Status)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_last_successful_sync_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LastSuccessfulSyncTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_last_attempted_sync_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LastAttemptedSyncTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentCalendarSyncStatus: i32 {
    Idle (AppointmentCalendarSyncStatus_Idle) = 0, Syncing (AppointmentCalendarSyncStatus_Syncing) = 1, UpToDate (AppointmentCalendarSyncStatus_UpToDate) = 2, AuthenticationError (AppointmentCalendarSyncStatus_AuthenticationError) = 3, PolicyError (AppointmentCalendarSyncStatus_PolicyError) = 4, UnknownError (AppointmentCalendarSyncStatus_UnknownError) = 5, ManualAccountRemovalRequired (AppointmentCalendarSyncStatus_ManualAccountRemovalRequired) = 6,
}}
DEFINE_IID!(IID_IAppointmentConflictResult, 3587043518, 12079, 15229, 175, 10, 167, 226, 15, 58, 70, 227);
RT_INTERFACE!{interface IAppointmentConflictResult(IAppointmentConflictResultVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentConflictResult] {
    fn get_Type(&self, out: *mut AppointmentConflictType) -> HRESULT,
    fn get_Date(&self, out: *mut super::super::foundation::DateTime) -> HRESULT
}}
impl IAppointmentConflictResult {
    #[inline] pub unsafe fn get_type(&self) -> Result<AppointmentConflictType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Date)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentConflictResult: IAppointmentConflictResult}
RT_ENUM! { enum AppointmentConflictType: i32 {
    None (AppointmentConflictType_None) = 0, Adjacent (AppointmentConflictType_Adjacent) = 1, Overlap (AppointmentConflictType_Overlap) = 2,
}}
RT_ENUM! { enum AppointmentDaysOfWeek: u32 {
    None (AppointmentDaysOfWeek_None) = 0, Sunday (AppointmentDaysOfWeek_Sunday) = 1, Monday (AppointmentDaysOfWeek_Monday) = 2, Tuesday (AppointmentDaysOfWeek_Tuesday) = 4, Wednesday (AppointmentDaysOfWeek_Wednesday) = 8, Thursday (AppointmentDaysOfWeek_Thursday) = 16, Friday (AppointmentDaysOfWeek_Friday) = 32, Saturday (AppointmentDaysOfWeek_Saturday) = 64,
}}
RT_ENUM! { enum AppointmentDetailsKind: i32 {
    PlainText (AppointmentDetailsKind_PlainText) = 0, Html (AppointmentDetailsKind_Html) = 1,
}}
DEFINE_IID!(IID_IAppointmentException, 2718394215, 5878, 19406, 159, 90, 134, 0, 184, 1, 159, 203);
RT_INTERFACE!{interface IAppointmentException(IAppointmentExceptionVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentException] {
    fn get_Appointment(&self, out: *mut *mut Appointment) -> HRESULT,
    fn get_ExceptionProperties(&self, out: *mut *mut super::super::foundation::collections::IVectorView<HString>) -> HRESULT,
    fn get_IsDeleted(&self, out: *mut bool) -> HRESULT
}}
impl IAppointmentException {
    #[inline] pub unsafe fn get_appointment(&self) -> Result<ComPtr<Appointment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Appointment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exception_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExceptionProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_deleted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDeleted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentException: IAppointmentException}
DEFINE_IID!(IID_IAppointmentInvitee, 331286422, 38978, 18779, 176, 231, 239, 143, 121, 192, 112, 29);
RT_INTERFACE!{interface IAppointmentInvitee(IAppointmentInviteeVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentInvitee] {
    fn get_Role(&self, out: *mut AppointmentParticipantRole) -> HRESULT,
    fn put_Role(&self, value: AppointmentParticipantRole) -> HRESULT,
    fn get_Response(&self, out: *mut AppointmentParticipantResponse) -> HRESULT,
    fn put_Response(&self, value: AppointmentParticipantResponse) -> HRESULT
}}
impl IAppointmentInvitee {
    #[inline] pub unsafe fn get_role(&self) -> Result<AppointmentParticipantRole> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Role)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_role(&self, value: AppointmentParticipantRole) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Role)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_response(&self) -> Result<AppointmentParticipantResponse> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Response)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_response(&self, value: AppointmentParticipantResponse) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Response)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentInvitee: IAppointmentInvitee}
impl RtActivatable<IActivationFactory> for AppointmentInvitee {}
DEFINE_CLSID!(AppointmentInvitee(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,73,110,118,105,116,101,101,0]) [CLSID_AppointmentInvitee]);
RT_CLASS!{static class AppointmentManager}
impl RtActivatable<IAppointmentManagerStatics> for AppointmentManager {}
impl RtActivatable<IAppointmentManagerStatics2> for AppointmentManager {}
impl RtActivatable<IAppointmentManagerStatics3> for AppointmentManager {}
impl AppointmentManager {
    #[inline] pub fn show_add_appointment_async(appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_add_appointment_async(appointment, selection)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_add_appointment_with_placement_async(appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_add_appointment_with_placement_async(appointment, selection, preferredPlacement)
    }}
    #[inline] pub fn show_replace_appointment_async(appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_replace_appointment_async(appointmentId, appointment, selection)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_replace_appointment_with_placement_async(appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_replace_appointment_with_placement_async(appointmentId, appointment, selection, preferredPlacement)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_replace_appointment_with_placement_and_date_async(appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_replace_appointment_with_placement_and_date_async(appointmentId, appointment, selection, preferredPlacement, instanceStartDate)
    }}
    #[inline] pub fn show_remove_appointment_async(appointmentId: &HStringArg, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_remove_appointment_async(appointmentId, selection)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_remove_appointment_with_placement_async(appointmentId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_remove_appointment_with_placement_async(appointmentId, selection, preferredPlacement)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_remove_appointment_with_placement_and_date_async(appointmentId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_remove_appointment_with_placement_and_date_async(appointmentId, selection, preferredPlacement, instanceStartDate)
    }}
    #[inline] pub fn show_time_frame_async(timeToShow: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics>>::get_activation_factory().show_time_frame_async(timeToShow, duration)
    }}
    #[inline] pub fn show_appointment_details_async(appointmentId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics2>>::get_activation_factory().show_appointment_details_async(appointmentId)
    }}
    #[inline] pub fn show_appointment_details_with_date_async(appointmentId: &HStringArg, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics2>>::get_activation_factory().show_appointment_details_with_date_async(appointmentId, instanceStartDate)
    }}
    #[inline] pub fn show_edit_new_appointment_async(appointment: &Appointment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics2>>::get_activation_factory().show_edit_new_appointment_async(appointment)
    }}
    #[inline] pub fn request_store_async(options: AppointmentStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentStore>>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics2>>::get_activation_factory().request_store_async(options)
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<AppointmentManagerForUser>> { unsafe {
        <Self as RtActivatable<IAppointmentManagerStatics3>>::get_activation_factory().get_for_user(user)
    }}
}
DEFINE_CLSID!(AppointmentManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,77,97,110,97,103,101,114,0]) [CLSID_AppointmentManager]);
DEFINE_IID!(IID_IAppointmentManagerForUser, 1881543715, 29644, 18016, 179, 24, 176, 19, 101, 48, 42, 3);
RT_INTERFACE!{interface IAppointmentManagerForUser(IAppointmentManagerForUserVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentManagerForUser] {
    fn ShowAddAppointmentAsync(&self, appointment: *mut Appointment, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowAddAppointmentWithPlacementAsync(&self, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn ShowReplaceAppointmentAsync(&self, appointmentId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowReplaceAppointmentWithPlacementAsync(&self, appointmentId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowReplaceAppointmentWithPlacementAndDateAsync(&self, appointmentId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn ShowRemoveAppointmentAsync(&self, appointmentId: HSTRING, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowRemoveAppointmentWithPlacementAsync(&self, appointmentId: HSTRING, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowRemoveAppointmentWithPlacementAndDateAsync(&self, appointmentId: HSTRING, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn ShowTimeFrameAsync(&self, timeToShow: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAppointmentDetailsAsync(&self, appointmentId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAppointmentDetailsWithDateAsync(&self, appointmentId: HSTRING, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowEditNewAppointmentAsync(&self, appointment: *mut Appointment, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn RequestStoreAsync(&self, options: AppointmentStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentStore>) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IAppointmentManagerForUser {
    #[inline] pub unsafe fn show_add_appointment_async(&self, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAddAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_add_appointment_with_placement_async(&self, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAddAppointmentWithPlacementAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_replace_appointment_async(&self, appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentAsync)(self as *const _ as *mut _, appointmentId.get(), appointment as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_replace_appointment_with_placement_async(&self, appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentWithPlacementAsync)(self as *const _ as *mut _, appointmentId.get(), appointment as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_replace_appointment_with_placement_and_date_async(&self, appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentWithPlacementAndDateAsync)(self as *const _ as *mut _, appointmentId.get(), appointment as *const _ as *mut _, selection, preferredPlacement, instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_remove_appointment_async(&self, appointmentId: &HStringArg, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentAsync)(self as *const _ as *mut _, appointmentId.get(), selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_remove_appointment_with_placement_async(&self, appointmentId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentWithPlacementAsync)(self as *const _ as *mut _, appointmentId.get(), selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_remove_appointment_with_placement_and_date_async(&self, appointmentId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentWithPlacementAndDateAsync)(self as *const _ as *mut _, appointmentId.get(), selection, preferredPlacement, instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_time_frame_async(&self, timeToShow: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowTimeFrameAsync)(self as *const _ as *mut _, timeToShow, duration, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_appointment_details_async(&self, appointmentId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAppointmentDetailsAsync)(self as *const _ as *mut _, appointmentId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_appointment_details_with_date_async(&self, appointmentId: &HStringArg, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAppointmentDetailsWithDateAsync)(self as *const _ as *mut _, appointmentId.get(), instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_edit_new_appointment_async(&self, appointment: &Appointment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowEditNewAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_store_async(&self, options: AppointmentStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, options, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentManagerForUser: IAppointmentManagerForUser}
DEFINE_IID!(IID_IAppointmentManagerStatics, 976288257, 23616, 18845, 179, 63, 164, 48, 80, 247, 79, 196);
RT_INTERFACE!{static interface IAppointmentManagerStatics(IAppointmentManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentManagerStatics] {
    fn ShowAddAppointmentAsync(&self, appointment: *mut Appointment, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowAddAppointmentWithPlacementAsync(&self, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn ShowReplaceAppointmentAsync(&self, appointmentId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowReplaceAppointmentWithPlacementAsync(&self, appointmentId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowReplaceAppointmentWithPlacementAndDateAsync(&self, appointmentId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn ShowRemoveAppointmentAsync(&self, appointmentId: HSTRING, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowRemoveAppointmentWithPlacementAsync(&self, appointmentId: HSTRING, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowRemoveAppointmentWithPlacementAndDateAsync(&self, appointmentId: HSTRING, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn ShowTimeFrameAsync(&self, timeToShow: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentManagerStatics {
    #[inline] pub unsafe fn show_add_appointment_async(&self, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAddAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_add_appointment_with_placement_async(&self, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAddAppointmentWithPlacementAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_replace_appointment_async(&self, appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentAsync)(self as *const _ as *mut _, appointmentId.get(), appointment as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_replace_appointment_with_placement_async(&self, appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentWithPlacementAsync)(self as *const _ as *mut _, appointmentId.get(), appointment as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_replace_appointment_with_placement_and_date_async(&self, appointmentId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentWithPlacementAndDateAsync)(self as *const _ as *mut _, appointmentId.get(), appointment as *const _ as *mut _, selection, preferredPlacement, instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_remove_appointment_async(&self, appointmentId: &HStringArg, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentAsync)(self as *const _ as *mut _, appointmentId.get(), selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_remove_appointment_with_placement_async(&self, appointmentId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentWithPlacementAsync)(self as *const _ as *mut _, appointmentId.get(), selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_remove_appointment_with_placement_and_date_async(&self, appointmentId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentWithPlacementAndDateAsync)(self as *const _ as *mut _, appointmentId.get(), selection, preferredPlacement, instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_time_frame_async(&self, timeToShow: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowTimeFrameAsync)(self as *const _ as *mut _, timeToShow, duration, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentManagerStatics2, 176289293, 53327, 16436, 175, 114, 163, 101, 115, 180, 95, 240);
RT_INTERFACE!{static interface IAppointmentManagerStatics2(IAppointmentManagerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentManagerStatics2] {
    fn ShowAppointmentDetailsAsync(&self, appointmentId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAppointmentDetailsWithDateAsync(&self, appointmentId: HSTRING, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowEditNewAppointmentAsync(&self, appointment: *mut Appointment, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn RequestStoreAsync(&self, options: AppointmentStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentStore>) -> HRESULT
}}
impl IAppointmentManagerStatics2 {
    #[inline] pub unsafe fn show_appointment_details_async(&self, appointmentId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAppointmentDetailsAsync)(self as *const _ as *mut _, appointmentId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_appointment_details_with_date_async(&self, appointmentId: &HStringArg, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAppointmentDetailsWithDateAsync)(self as *const _ as *mut _, appointmentId.get(), instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_edit_new_appointment_async(&self, appointment: &Appointment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowEditNewAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_store_async(&self, options: AppointmentStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, options, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentManagerStatics3, 798679196, 45900, 19911, 163, 93, 202, 253, 136, 174, 62, 198);
RT_INTERFACE!{static interface IAppointmentManagerStatics3(IAppointmentManagerStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentManagerStatics3] {
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut AppointmentManagerForUser) -> HRESULT
}}
impl IAppointmentManagerStatics3 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<AppointmentManagerForUser>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentOrganizer: IAppointmentParticipant}
impl RtActivatable<IActivationFactory> for AppointmentOrganizer {}
DEFINE_CLSID!(AppointmentOrganizer(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,79,114,103,97,110,105,122,101,114,0]) [CLSID_AppointmentOrganizer]);
DEFINE_IID!(IID_IAppointmentParticipant, 1633560834, 38680, 18043, 131, 251, 178, 147, 161, 145, 33, 222);
RT_INTERFACE!{interface IAppointmentParticipant(IAppointmentParticipantVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentParticipant] {
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_Address(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Address(&self, value: HSTRING) -> HRESULT
}}
impl IAppointmentParticipant {
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Address)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Address)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentParticipantResponse: i32 {
    None (AppointmentParticipantResponse_None) = 0, Tentative (AppointmentParticipantResponse_Tentative) = 1, Accepted (AppointmentParticipantResponse_Accepted) = 2, Declined (AppointmentParticipantResponse_Declined) = 3, Unknown (AppointmentParticipantResponse_Unknown) = 4,
}}
RT_ENUM! { enum AppointmentParticipantRole: i32 {
    RequiredAttendee (AppointmentParticipantRole_RequiredAttendee) = 0, OptionalAttendee (AppointmentParticipantRole_OptionalAttendee) = 1, Resource (AppointmentParticipantRole_Resource) = 2,
}}
RT_CLASS!{static class AppointmentProperties}
impl RtActivatable<IAppointmentPropertiesStatics> for AppointmentProperties {}
impl RtActivatable<IAppointmentPropertiesStatics2> for AppointmentProperties {}
impl AppointmentProperties {
    #[inline] pub fn get_subject() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_subject()
    }}
    #[inline] pub fn get_location() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_location()
    }}
    #[inline] pub fn get_start_time() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_start_time()
    }}
    #[inline] pub fn get_duration() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_duration()
    }}
    #[inline] pub fn get_reminder() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_reminder()
    }}
    #[inline] pub fn get_busy_status() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_busy_status()
    }}
    #[inline] pub fn get_sensitivity() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_sensitivity()
    }}
    #[inline] pub fn get_original_start_time() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_original_start_time()
    }}
    #[inline] pub fn get_is_response_requested() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_is_response_requested()
    }}
    #[inline] pub fn get_allow_new_time_proposal() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_allow_new_time_proposal()
    }}
    #[inline] pub fn get_all_day() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_all_day()
    }}
    #[inline] pub fn get_details() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_details()
    }}
    #[inline] pub fn get_online_meeting_link() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_online_meeting_link()
    }}
    #[inline] pub fn get_reply_time() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_reply_time()
    }}
    #[inline] pub fn get_organizer() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_organizer()
    }}
    #[inline] pub fn get_user_response() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_user_response()
    }}
    #[inline] pub fn get_has_invitees() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_has_invitees()
    }}
    #[inline] pub fn get_is_canceled_meeting() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_is_canceled_meeting()
    }}
    #[inline] pub fn get_is_organized_by_user() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_is_organized_by_user()
    }}
    #[inline] pub fn get_recurrence() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_recurrence()
    }}
    #[inline] pub fn get_uri() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_uri()
    }}
    #[inline] pub fn get_invitees() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_invitees()
    }}
    #[inline] pub fn get_default_properties() -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics>>::get_activation_factory().get_default_properties()
    }}
    #[inline] pub fn get_change_number() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics2>>::get_activation_factory().get_change_number()
    }}
    #[inline] pub fn get_remote_change_number() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics2>>::get_activation_factory().get_remote_change_number()
    }}
    #[inline] pub fn get_details_kind() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentPropertiesStatics2>>::get_activation_factory().get_details_kind()
    }}
}
DEFINE_CLSID!(AppointmentProperties(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,80,114,111,112,101,114,116,105,101,115,0]) [CLSID_AppointmentProperties]);
DEFINE_IID!(IID_IAppointmentPropertiesStatics, 622075881, 26798, 15022, 133, 95, 188, 68, 65, 202, 162, 52);
RT_INTERFACE!{static interface IAppointmentPropertiesStatics(IAppointmentPropertiesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentPropertiesStatics] {
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Location(&self, out: *mut HSTRING) -> HRESULT,
    fn get_StartTime(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Duration(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Reminder(&self, out: *mut HSTRING) -> HRESULT,
    fn get_BusyStatus(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Sensitivity(&self, out: *mut HSTRING) -> HRESULT,
    fn get_OriginalStartTime(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsResponseRequested(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AllowNewTimeProposal(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AllDay(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Details(&self, out: *mut HSTRING) -> HRESULT,
    fn get_OnlineMeetingLink(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ReplyTime(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Organizer(&self, out: *mut HSTRING) -> HRESULT,
    fn get_UserResponse(&self, out: *mut HSTRING) -> HRESULT,
    fn get_HasInvitees(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsCanceledMeeting(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsOrganizedByUser(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Recurrence(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Uri(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Invitees(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DefaultProperties(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IAppointmentPropertiesStatics {
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Location)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_time(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reminder(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Reminder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_busy_status(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BusyStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sensitivity(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Sensitivity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_original_start_time(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OriginalStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_response_requested(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsResponseRequested)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_new_time_proposal(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowNewTimeProposal)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_day(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllDay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_details(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Details)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_online_meeting_link(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OnlineMeetingLink)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reply_time(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ReplyTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_organizer(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Organizer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_response(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserResponse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_invitees(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HasInvitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled_meeting(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsCanceledMeeting)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_organized_by_user(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsOrganizedByUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recurrence(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Recurrence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uri(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Uri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invitees(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Invitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentPropertiesStatics2, 3757851467, 45079, 17885, 138, 245, 209, 99, 209, 8, 1, 187);
RT_INTERFACE!{static interface IAppointmentPropertiesStatics2(IAppointmentPropertiesStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentPropertiesStatics2] {
    fn get_ChangeNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RemoteChangeNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DetailsKind(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppointmentPropertiesStatics2 {
    #[inline] pub unsafe fn get_change_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChangeNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_change_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteChangeNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_details_kind(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DetailsKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentRecurrence, 3631955587, 5542, 18555, 185, 89, 12, 54, 30, 96, 233, 84);
RT_INTERFACE!{interface IAppointmentRecurrence(IAppointmentRecurrenceVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentRecurrence] {
    fn get_Unit(&self, out: *mut AppointmentRecurrenceUnit) -> HRESULT,
    fn put_Unit(&self, value: AppointmentRecurrenceUnit) -> HRESULT,
    fn get_Occurrences(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_Occurrences(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Until(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_Until(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_Interval(&self, out: *mut u32) -> HRESULT,
    fn put_Interval(&self, value: u32) -> HRESULT,
    fn get_DaysOfWeek(&self, out: *mut AppointmentDaysOfWeek) -> HRESULT,
    fn put_DaysOfWeek(&self, value: AppointmentDaysOfWeek) -> HRESULT,
    fn get_WeekOfMonth(&self, out: *mut AppointmentWeekOfMonth) -> HRESULT,
    fn put_WeekOfMonth(&self, value: AppointmentWeekOfMonth) -> HRESULT,
    fn get_Month(&self, out: *mut u32) -> HRESULT,
    fn put_Month(&self, value: u32) -> HRESULT,
    fn get_Day(&self, out: *mut u32) -> HRESULT,
    fn put_Day(&self, value: u32) -> HRESULT
}}
impl IAppointmentRecurrence {
    #[inline] pub unsafe fn get_unit(&self) -> Result<AppointmentRecurrenceUnit> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Unit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_unit(&self, value: AppointmentRecurrenceUnit) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Unit)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_occurrences(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Occurrences)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_occurrences(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Occurrences)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_until(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Until)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_until(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Until)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_interval(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Interval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_interval(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Interval)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_days_of_week(&self) -> Result<AppointmentDaysOfWeek> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DaysOfWeek)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_days_of_week(&self, value: AppointmentDaysOfWeek) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DaysOfWeek)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_week_of_month(&self) -> Result<AppointmentWeekOfMonth> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WeekOfMonth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_week_of_month(&self, value: AppointmentWeekOfMonth) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WeekOfMonth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Month)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Month)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Day)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Day)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentRecurrence: IAppointmentRecurrence}
impl RtActivatable<IActivationFactory> for AppointmentRecurrence {}
DEFINE_CLSID!(AppointmentRecurrence(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,82,101,99,117,114,114,101,110,99,101,0]) [CLSID_AppointmentRecurrence]);
DEFINE_IID!(IID_IAppointmentRecurrence2, 1039377120, 1447, 20304, 159, 134, 176, 63, 148, 54, 37, 77);
RT_INTERFACE!{interface IAppointmentRecurrence2(IAppointmentRecurrence2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentRecurrence2] {
    fn get_RecurrenceType(&self, out: *mut RecurrenceType) -> HRESULT,
    fn get_TimeZone(&self, out: *mut HSTRING) -> HRESULT,
    fn put_TimeZone(&self, value: HSTRING) -> HRESULT
}}
impl IAppointmentRecurrence2 {
    #[inline] pub unsafe fn get_recurrence_type(&self) -> Result<RecurrenceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RecurrenceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_zone(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TimeZone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_time_zone(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TimeZone)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentRecurrence3, 2315228889, 55885, 18967, 141, 210, 28, 235, 194, 181, 255, 157);
RT_INTERFACE!{interface IAppointmentRecurrence3(IAppointmentRecurrence3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentRecurrence3] {
    fn get_CalendarIdentifier(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppointmentRecurrence3 {
    #[inline] pub unsafe fn get_calendar_identifier(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifier)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentRecurrenceUnit: i32 {
    Daily (AppointmentRecurrenceUnit_Daily) = 0, Weekly (AppointmentRecurrenceUnit_Weekly) = 1, Monthly (AppointmentRecurrenceUnit_Monthly) = 2, MonthlyOnDay (AppointmentRecurrenceUnit_MonthlyOnDay) = 3, Yearly (AppointmentRecurrenceUnit_Yearly) = 4, YearlyOnDay (AppointmentRecurrenceUnit_YearlyOnDay) = 5,
}}
RT_ENUM! { enum AppointmentSensitivity: i32 {
    Public (AppointmentSensitivity_Public) = 0, Private (AppointmentSensitivity_Private) = 1,
}}
DEFINE_IID!(IID_IAppointmentStore, 2757857676, 31303, 19862, 150, 201, 21, 205, 138, 5, 167, 53);
RT_INTERFACE!{interface IAppointmentStore(IAppointmentStoreVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStore] {
    fn get_ChangeTracker(&self, out: *mut *mut AppointmentStoreChangeTracker) -> HRESULT,
    fn CreateAppointmentCalendarAsync(&self, name: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentCalendar>) -> HRESULT,
    fn GetAppointmentCalendarAsync(&self, calendarId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentCalendar>) -> HRESULT,
    fn GetAppointmentAsync(&self, localId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Appointment>) -> HRESULT,
    fn GetAppointmentInstanceAsync(&self, localId: HSTRING, instanceStartTime: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<Appointment>) -> HRESULT,
    fn FindAppointmentCalendarsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentCalendar>>) -> HRESULT,
    fn FindAppointmentCalendarsAsyncWithOptions(&self, options: FindAppointmentCalendarsOptions, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentCalendar>>) -> HRESULT,
    fn FindAppointmentsAsync(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn FindAppointmentsAsyncWithOptions(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, options: *mut FindAppointmentsOptions, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>) -> HRESULT,
    fn FindConflictAsync(&self, appointment: *mut Appointment, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentConflictResult>) -> HRESULT,
    fn FindConflictAsyncWithInstanceStart(&self, appointment: *mut Appointment, instanceStartTime: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentConflictResult>) -> HRESULT,
    fn MoveAppointmentAsync(&self, appointment: *mut Appointment, destinationCalendar: *mut AppointmentCalendar, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAddAppointmentAsync(&self, appointment: *mut Appointment, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn ShowReplaceAppointmentAsync(&self, localId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy14(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowReplaceAppointmentWithPlacementAndDateAsync(&self, localId: HSTRING, appointment: *mut Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn ShowRemoveAppointmentAsync(&self, localId: HSTRING, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy16(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowRemoveAppointmentWithPlacementAndDateAsync(&self, localId: HSTRING, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn ShowAppointmentDetailsAsync(&self, localId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAppointmentDetailsWithDateAsync(&self, localId: HSTRING, instanceStartDate: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowEditNewAppointmentAsync(&self, appointment: *mut Appointment, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn FindLocalIdsFromRoamingIdAsync(&self, roamingId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<HString>>) -> HRESULT
}}
impl IAppointmentStore {
    #[inline] pub unsafe fn get_change_tracker(&self) -> Result<ComPtr<AppointmentStoreChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChangeTracker)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_appointment_calendar_async(&self, name: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentCalendar>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAppointmentCalendarAsync)(self as *const _ as *mut _, name.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_calendar_async(&self, calendarId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentCalendar>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppointmentCalendarAsync)(self as *const _ as *mut _, calendarId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_async(&self, localId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Appointment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppointmentAsync)(self as *const _ as *mut _, localId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_instance_async(&self, localId: &HStringArg, instanceStartTime: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Appointment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppointmentInstanceAsync)(self as *const _ as *mut _, localId.get(), instanceStartTime, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_appointment_calendars_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentCalendar>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppointmentCalendarsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_appointment_calendars_async_with_options(&self, options: FindAppointmentCalendarsOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentCalendar>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppointmentCalendarsAsyncWithOptions)(self as *const _ as *mut _, options, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_appointments_async(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppointmentsAsync)(self as *const _ as *mut _, rangeStart, rangeLength, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_appointments_async_with_options(&self, rangeStart: super::super::foundation::DateTime, rangeLength: super::super::foundation::TimeSpan, options: &FindAppointmentsOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Appointment>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAppointmentsAsyncWithOptions)(self as *const _ as *mut _, rangeStart, rangeLength, options as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_conflict_async(&self, appointment: &Appointment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentConflictResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindConflictAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_conflict_async_with_instance_start(&self, appointment: &Appointment, instanceStartTime: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentConflictResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindConflictAsyncWithInstanceStart)(self as *const _ as *mut _, appointment as *const _ as *mut _, instanceStartTime, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_appointment_async(&self, appointment: &Appointment, destinationCalendar: &AppointmentCalendar) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MoveAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, destinationCalendar as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_add_appointment_async(&self, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAddAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_replace_appointment_async(&self, localId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentAsync)(self as *const _ as *mut _, localId.get(), appointment as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_replace_appointment_with_placement_and_date_async(&self, localId: &HStringArg, appointment: &Appointment, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowReplaceAppointmentWithPlacementAndDateAsync)(self as *const _ as *mut _, localId.get(), appointment as *const _ as *mut _, selection, preferredPlacement, instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_remove_appointment_async(&self, localId: &HStringArg, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentAsync)(self as *const _ as *mut _, localId.get(), selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_remove_appointment_with_placement_and_date_async(&self, localId: &HStringArg, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowRemoveAppointmentWithPlacementAndDateAsync)(self as *const _ as *mut _, localId.get(), selection, preferredPlacement, instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_appointment_details_async(&self, localId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAppointmentDetailsAsync)(self as *const _ as *mut _, localId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_appointment_details_with_date_async(&self, localId: &HStringArg, instanceStartDate: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAppointmentDetailsWithDateAsync)(self as *const _ as *mut _, localId.get(), instanceStartDate, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_edit_new_appointment_async(&self, appointment: &Appointment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowEditNewAppointmentAsync)(self as *const _ as *mut _, appointment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_local_ids_from_roaming_id_async(&self, roamingId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<HString>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindLocalIdsFromRoamingIdAsync)(self as *const _ as *mut _, roamingId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentStore: IAppointmentStore}
DEFINE_IID!(IID_IAppointmentStore2, 633637920, 7233, 16975, 128, 132, 103, 193, 207, 224, 168, 84);
RT_INTERFACE!{interface IAppointmentStore2(IAppointmentStore2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStore2] {
    fn add_StoreChanged(&self, pHandler: *mut super::super::foundation::TypedEventHandler<AppointmentStore, AppointmentStoreChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StoreChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn CreateAppointmentCalendarInAccountAsync(&self, name: HSTRING, userDataAccountId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<AppointmentCalendar>) -> HRESULT
}}
impl IAppointmentStore2 {
    #[inline] pub unsafe fn add_store_changed(&self, pHandler: &super::super::foundation::TypedEventHandler<AppointmentStore, AppointmentStoreChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StoreChanged)(self as *const _ as *mut _, pHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_store_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StoreChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_appointment_calendar_in_account_async(&self, name: &HStringArg, userDataAccountId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppointmentCalendar>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAppointmentCalendarInAccountAsync)(self as *const _ as *mut _, name.get(), userDataAccountId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentStore3, 1112642571, 45176, 18186, 154, 64, 194, 224, 23, 97, 247, 47);
RT_INTERFACE!{interface IAppointmentStore3(IAppointmentStore3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStore3] {
    fn GetChangeTracker(&self, identity: HSTRING, out: *mut *mut AppointmentStoreChangeTracker) -> HRESULT
}}
impl IAppointmentStore3 {
    #[inline] pub unsafe fn get_change_tracker(&self, identity: &HStringArg) -> Result<ComPtr<AppointmentStoreChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChangeTracker)(self as *const _ as *mut _, identity.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentStoreAccessType: i32 {
    AppCalendarsReadWrite (AppointmentStoreAccessType_AppCalendarsReadWrite) = 0, AllCalendarsReadOnly (AppointmentStoreAccessType_AllCalendarsReadOnly) = 1, AllCalendarsReadWrite (AppointmentStoreAccessType_AllCalendarsReadWrite) = 2,
}}
DEFINE_IID!(IID_IAppointmentStoreChange, 2779177013, 2611, 13908, 132, 99, 181, 67, 233, 12, 59, 121);
RT_INTERFACE!{interface IAppointmentStoreChange(IAppointmentStoreChangeVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChange] {
    fn get_Appointment(&self, out: *mut *mut Appointment) -> HRESULT,
    fn get_ChangeType(&self, out: *mut AppointmentStoreChangeType) -> HRESULT
}}
impl IAppointmentStoreChange {
    #[inline] pub unsafe fn get_appointment(&self) -> Result<ComPtr<Appointment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Appointment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_change_type(&self) -> Result<AppointmentStoreChangeType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChangeType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentStoreChange: IAppointmentStoreChange}
DEFINE_IID!(IID_IAppointmentStoreChange2, 3011317198, 21009, 17410, 166, 8, 169, 111, 231, 11, 142, 226);
RT_INTERFACE!{interface IAppointmentStoreChange2(IAppointmentStoreChange2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChange2] {
    fn get_AppointmentCalendar(&self, out: *mut *mut AppointmentCalendar) -> HRESULT
}}
impl IAppointmentStoreChange2 {
    #[inline] pub unsafe fn get_appointment_calendar(&self) -> Result<ComPtr<AppointmentCalendar>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendar)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentStoreChangedDeferral, 1287135270, 65243, 19395, 150, 98, 149, 169, 190, 253, 244, 223);
RT_INTERFACE!{interface IAppointmentStoreChangedDeferral(IAppointmentStoreChangedDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChangedDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IAppointmentStoreChangedDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentStoreChangedDeferral: IAppointmentStoreChangedDeferral}
DEFINE_IID!(IID_IAppointmentStoreChangedEventArgs, 579205305, 1937, 16766, 191, 234, 204, 109, 65, 99, 108, 140);
RT_INTERFACE!{interface IAppointmentStoreChangedEventArgs(IAppointmentStoreChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChangedEventArgs] {
    fn GetDeferral(&self, out: *mut *mut AppointmentStoreChangedDeferral) -> HRESULT
}}
impl IAppointmentStoreChangedEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<AppointmentStoreChangedDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentStoreChangedEventArgs: IAppointmentStoreChangedEventArgs}
DEFINE_IID!(IID_IAppointmentStoreChangeReader, 2334394865, 26099, 17056, 150, 29, 76, 32, 155, 243, 3, 112);
RT_INTERFACE!{interface IAppointmentStoreChangeReader(IAppointmentStoreChangeReaderVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChangeReader] {
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentStoreChange>>) -> HRESULT,
    fn AcceptChanges(&self) -> HRESULT,
    fn AcceptChangesThrough(&self, lastChangeToAccept: *mut AppointmentStoreChange) -> HRESULT
}}
impl IAppointmentStoreChangeReader {
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AppointmentStoreChange>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept_changes(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptChanges)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept_changes_through(&self, lastChangeToAccept: &AppointmentStoreChange) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptChangesThrough)(self as *const _ as *mut _, lastChangeToAccept as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentStoreChangeReader: IAppointmentStoreChangeReader}
DEFINE_IID!(IID_IAppointmentStoreChangeTracker, 455472305, 36558, 20247, 147, 200, 230, 65, 36, 88, 253, 92);
RT_INTERFACE!{interface IAppointmentStoreChangeTracker(IAppointmentStoreChangeTrackerVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChangeTracker] {
    fn GetChangeReader(&self, out: *mut *mut AppointmentStoreChangeReader) -> HRESULT,
    fn Enable(&self) -> HRESULT,
    fn Reset(&self) -> HRESULT
}}
impl IAppointmentStoreChangeTracker {
    #[inline] pub unsafe fn get_change_reader(&self) -> Result<ComPtr<AppointmentStoreChangeReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChangeReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn enable(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Enable)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Reset)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentStoreChangeTracker: IAppointmentStoreChangeTracker}
DEFINE_IID!(IID_IAppointmentStoreChangeTracker2, 3060444997, 38210, 19703, 133, 80, 235, 55, 14, 12, 8, 211);
RT_INTERFACE!{interface IAppointmentStoreChangeTracker2(IAppointmentStoreChangeTracker2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreChangeTracker2] {
    fn get_IsTracking(&self, out: *mut bool) -> HRESULT
}}
impl IAppointmentStoreChangeTracker2 {
    #[inline] pub unsafe fn get_is_tracking(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTracking)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum AppointmentStoreChangeType: i32 {
    AppointmentCreated (AppointmentStoreChangeType_AppointmentCreated) = 0, AppointmentModified (AppointmentStoreChangeType_AppointmentModified) = 1, AppointmentDeleted (AppointmentStoreChangeType_AppointmentDeleted) = 2, ChangeTrackingLost (AppointmentStoreChangeType_ChangeTrackingLost) = 3, CalendarCreated (AppointmentStoreChangeType_CalendarCreated) = 4, CalendarModified (AppointmentStoreChangeType_CalendarModified) = 5, CalendarDeleted (AppointmentStoreChangeType_CalendarDeleted) = 6,
}}
DEFINE_IID!(IID_IAppointmentStoreNotificationTriggerDetails, 2603862801, 49921, 16926, 175, 239, 4, 126, 207, 167, 106, 219);
RT_INTERFACE!{interface IAppointmentStoreNotificationTriggerDetails(IAppointmentStoreNotificationTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentStoreNotificationTriggerDetails] {
    
}}
RT_CLASS!{class AppointmentStoreNotificationTriggerDetails: IAppointmentStoreNotificationTriggerDetails}
RT_ENUM! { enum AppointmentSummaryCardView: i32 {
    System (AppointmentSummaryCardView_System) = 0, App (AppointmentSummaryCardView_App) = 1,
}}
RT_ENUM! { enum AppointmentWeekOfMonth: i32 {
    First (AppointmentWeekOfMonth_First) = 0, Second (AppointmentWeekOfMonth_Second) = 1, Third (AppointmentWeekOfMonth_Third) = 2, Fourth (AppointmentWeekOfMonth_Fourth) = 3, Last (AppointmentWeekOfMonth_Last) = 4,
}}
RT_ENUM! { enum FindAppointmentCalendarsOptions: u32 {
    None (FindAppointmentCalendarsOptions_None) = 0, IncludeHidden (FindAppointmentCalendarsOptions_IncludeHidden) = 1,
}}
DEFINE_IID!(IID_IFindAppointmentsOptions, 1442307157, 39234, 12422, 130, 181, 44, 178, 159, 100, 213, 245);
RT_INTERFACE!{interface IFindAppointmentsOptions(IFindAppointmentsOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IFindAppointmentsOptions] {
    fn get_CalendarIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_FetchProperties(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_IncludeHidden(&self, out: *mut bool) -> HRESULT,
    fn put_IncludeHidden(&self, value: bool) -> HRESULT,
    fn get_MaxCount(&self, out: *mut u32) -> HRESULT,
    fn put_MaxCount(&self, value: u32) -> HRESULT
}}
impl IFindAppointmentsOptions {
    #[inline] pub unsafe fn get_calendar_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_fetch_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FetchProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_include_hidden(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IncludeHidden)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_include_hidden(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IncludeHidden)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_count(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxCount)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FindAppointmentsOptions: IFindAppointmentsOptions}
impl RtActivatable<IActivationFactory> for FindAppointmentsOptions {}
DEFINE_CLSID!(FindAppointmentsOptions(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,70,105,110,100,65,112,112,111,105,110,116,109,101,110,116,115,79,112,116,105,111,110,115,0]) [CLSID_FindAppointmentsOptions]);
RT_ENUM! { enum RecurrenceType: i32 {
    Master (RecurrenceType_Master) = 0, Instance (RecurrenceType_Instance) = 1, ExceptionInstance (RecurrenceType_ExceptionInstance) = 2,
}}
pub mod appointmentsprovider { // Windows.ApplicationModel.Appointments.AppointmentsProvider
use ::prelude::*;
DEFINE_IID!(IID_IAddAppointmentOperation, 3964312307, 25101, 19561, 173, 215, 151, 148, 233, 24, 8, 31);
RT_INTERFACE!{interface IAddAppointmentOperation(IAddAppointmentOperationVtbl): IInspectable(IInspectableVtbl) [IID_IAddAppointmentOperation] {
    fn get_AppointmentInformation(&self, out: *mut *mut super::Appointment) -> HRESULT,
    fn get_SourcePackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn ReportCompleted(&self, itemId: HSTRING) -> HRESULT,
    fn ReportCanceled(&self) -> HRESULT,
    fn ReportError(&self, value: HSTRING) -> HRESULT,
    fn DismissUI(&self) -> HRESULT
}}
impl IAddAppointmentOperation {
    #[inline] pub unsafe fn get_appointment_information(&self) -> Result<ComPtr<super::Appointment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourcePackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed(&self, itemId: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportCompleted)(self as *const _ as *mut _, itemId.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_canceled(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportCanceled)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_error(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportError)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn dismiss_ui(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DismissUI)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AddAppointmentOperation: IAddAppointmentOperation}
RT_CLASS!{static class AppointmentsProviderLaunchActionVerbs}
impl RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics> for AppointmentsProviderLaunchActionVerbs {}
impl RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics2> for AppointmentsProviderLaunchActionVerbs {}
impl AppointmentsProviderLaunchActionVerbs {
    #[inline] pub fn get_add_appointment() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics>>::get_activation_factory().get_add_appointment()
    }}
    #[inline] pub fn get_replace_appointment() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics>>::get_activation_factory().get_replace_appointment()
    }}
    #[inline] pub fn get_remove_appointment() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics>>::get_activation_factory().get_remove_appointment()
    }}
    #[inline] pub fn get_show_time_frame() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics>>::get_activation_factory().get_show_time_frame()
    }}
    #[inline] pub fn get_show_appointment_details() -> Result<HString> { unsafe {
        <Self as RtActivatable<IAppointmentsProviderLaunchActionVerbsStatics2>>::get_activation_factory().get_show_appointment_details()
    }}
}
DEFINE_CLSID!(AppointmentsProviderLaunchActionVerbs(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,65,112,112,111,105,110,116,109,101,110,116,115,46,65,112,112,111,105,110,116,109,101,110,116,115,80,114,111,118,105,100,101,114,46,65,112,112,111,105,110,116,109,101,110,116,115,80,114,111,118,105,100,101,114,76,97,117,110,99,104,65,99,116,105,111,110,86,101,114,98,115,0]) [CLSID_AppointmentsProviderLaunchActionVerbs]);
DEFINE_IID!(IID_IAppointmentsProviderLaunchActionVerbsStatics, 920369704, 40494, 18886, 142, 247, 58, 183, 165, 220, 200, 184);
RT_INTERFACE!{static interface IAppointmentsProviderLaunchActionVerbsStatics(IAppointmentsProviderLaunchActionVerbsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderLaunchActionVerbsStatics] {
    fn get_AddAppointment(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ReplaceAppointment(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RemoveAppointment(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ShowTimeFrame(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppointmentsProviderLaunchActionVerbsStatics {
    #[inline] pub unsafe fn get_add_appointment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AddAppointment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_replace_appointment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ReplaceAppointment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remove_appointment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoveAppointment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_time_frame(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ShowTimeFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentsProviderLaunchActionVerbsStatics2, 4019210660, 44833, 18236, 136, 220, 118, 205, 137, 246, 12, 165);
RT_INTERFACE!{static interface IAppointmentsProviderLaunchActionVerbsStatics2(IAppointmentsProviderLaunchActionVerbsStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderLaunchActionVerbsStatics2] {
    fn get_ShowAppointmentDetails(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppointmentsProviderLaunchActionVerbsStatics2 {
    #[inline] pub unsafe fn get_show_appointment_details(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ShowAppointmentDetails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRemoveAppointmentOperation, 146172602, 65075, 18125, 165, 12, 168, 255, 179, 38, 5, 55);
RT_INTERFACE!{interface IRemoveAppointmentOperation(IRemoveAppointmentOperationVtbl): IInspectable(IInspectableVtbl) [IID_IRemoveAppointmentOperation] {
    fn get_AppointmentId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_InstanceStartDate(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_SourcePackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn ReportCompleted(&self) -> HRESULT,
    fn ReportCanceled(&self) -> HRESULT,
    fn ReportError(&self, value: HSTRING) -> HRESULT,
    fn DismissUI(&self) -> HRESULT
}}
impl IRemoveAppointmentOperation {
    #[inline] pub unsafe fn get_appointment_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_instance_start_date(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InstanceStartDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourcePackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportCompleted)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_canceled(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportCanceled)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_error(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportError)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn dismiss_ui(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DismissUI)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RemoveAppointmentOperation: IRemoveAppointmentOperation}
DEFINE_IID!(IID_IReplaceAppointmentOperation, 4103093659, 40545, 19938, 167, 50, 38, 135, 192, 125, 29, 232);
RT_INTERFACE!{interface IReplaceAppointmentOperation(IReplaceAppointmentOperationVtbl): IInspectable(IInspectableVtbl) [IID_IReplaceAppointmentOperation] {
    fn get_AppointmentId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentInformation(&self, out: *mut *mut super::Appointment) -> HRESULT,
    fn get_InstanceStartDate(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_SourcePackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn ReportCompleted(&self, itemId: HSTRING) -> HRESULT,
    fn ReportCanceled(&self) -> HRESULT,
    fn ReportError(&self, value: HSTRING) -> HRESULT,
    fn DismissUI(&self) -> HRESULT
}}
impl IReplaceAppointmentOperation {
    #[inline] pub unsafe fn get_appointment_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_information(&self) -> Result<ComPtr<super::Appointment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_instance_start_date(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InstanceStartDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourcePackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed(&self, itemId: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportCompleted)(self as *const _ as *mut _, itemId.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_canceled(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportCanceled)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_error(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportError)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn dismiss_ui(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DismissUI)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ReplaceAppointmentOperation: IReplaceAppointmentOperation}
} // Windows.ApplicationModel.Appointments.AppointmentsProvider
pub mod dataprovider { // Windows.ApplicationModel.Appointments.DataProvider
use ::prelude::*;
DEFINE_IID!(IID_IAppointmentCalendarCancelMeetingRequest, 1229328269, 25652, 16599, 173, 70, 98, 151, 65, 147, 20, 209);
RT_INTERFACE!{interface IAppointmentCalendarCancelMeetingRequest(IAppointmentCalendarCancelMeetingRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarCancelMeetingRequest] {
    fn get_AppointmentCalendarLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentOriginalStartTime(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Comment(&self, out: *mut HSTRING) -> HRESULT,
    fn get_NotifyInvitees(&self, out: *mut bool) -> HRESULT,
    fn ReportCompletedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn ReportFailedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendarCancelMeetingRequest {
    #[inline] pub unsafe fn get_appointment_calendar_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendarLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_original_start_time(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentOriginalStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_comment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Comment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_notify_invitees(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NotifyInvitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportCompletedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_failed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportFailedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarCancelMeetingRequest: IAppointmentCalendarCancelMeetingRequest}
DEFINE_IID!(IID_IAppointmentCalendarCancelMeetingRequestEventArgs, 444186134, 32560, 20021, 190, 239, 157, 44, 123, 109, 202, 225);
RT_INTERFACE!{interface IAppointmentCalendarCancelMeetingRequestEventArgs(IAppointmentCalendarCancelMeetingRequestEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarCancelMeetingRequestEventArgs] {
    fn get_Request(&self, out: *mut *mut AppointmentCalendarCancelMeetingRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl IAppointmentCalendarCancelMeetingRequestEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppointmentCalendarCancelMeetingRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarCancelMeetingRequestEventArgs: IAppointmentCalendarCancelMeetingRequestEventArgs}
DEFINE_IID!(IID_IAppointmentCalendarCreateOrUpdateAppointmentRequest, 778236594, 51862, 18604, 145, 36, 64, 107, 25, 254, 250, 112);
RT_INTERFACE!{interface IAppointmentCalendarCreateOrUpdateAppointmentRequest(IAppointmentCalendarCreateOrUpdateAppointmentRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarCreateOrUpdateAppointmentRequest] {
    fn get_AppointmentCalendarLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Appointment(&self, out: *mut *mut super::Appointment) -> HRESULT,
    fn get_NotifyInvitees(&self, out: *mut bool) -> HRESULT,
    fn get_ChangedProperties(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<HString>) -> HRESULT,
    fn ReportCompletedAsync(&self, createdOrUpdatedAppointment: *mut super::Appointment, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn ReportFailedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendarCreateOrUpdateAppointmentRequest {
    #[inline] pub unsafe fn get_appointment_calendar_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendarLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment(&self) -> Result<ComPtr<super::Appointment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Appointment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_notify_invitees(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NotifyInvitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_changed_properties(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChangedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed_async(&self, createdOrUpdatedAppointment: &super::Appointment) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportCompletedAsync)(self as *const _ as *mut _, createdOrUpdatedAppointment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_failed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportFailedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarCreateOrUpdateAppointmentRequest: IAppointmentCalendarCreateOrUpdateAppointmentRequest}
DEFINE_IID!(IID_IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs, 3482185000, 46, 19447, 142, 157, 94, 32, 212, 154, 163, 186);
RT_INTERFACE!{interface IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs(IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs] {
    fn get_Request(&self, out: *mut *mut AppointmentCalendarCreateOrUpdateAppointmentRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppointmentCalendarCreateOrUpdateAppointmentRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs: IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs}
DEFINE_IID!(IID_IAppointmentCalendarForwardMeetingRequest, 2196106838, 9910, 16979, 138, 143, 108, 245, 242, 255, 120, 132);
RT_INTERFACE!{interface IAppointmentCalendarForwardMeetingRequest(IAppointmentCalendarForwardMeetingRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarForwardMeetingRequest] {
    fn get_AppointmentCalendarLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentOriginalStartTime(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_Invitees(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<super::AppointmentInvitee>) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ForwardHeader(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Comment(&self, out: *mut HSTRING) -> HRESULT,
    fn ReportCompletedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn ReportFailedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendarForwardMeetingRequest {
    #[inline] pub unsafe fn get_appointment_calendar_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendarLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_original_start_time(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentOriginalStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invitees(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<super::AppointmentInvitee>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Invitees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_forward_header(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForwardHeader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_comment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Comment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportCompletedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_failed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportFailedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarForwardMeetingRequest: IAppointmentCalendarForwardMeetingRequest}
DEFINE_IID!(IID_IAppointmentCalendarForwardMeetingRequestEventArgs, 822678810, 9122, 17149, 156, 130, 201, 166, 13, 89, 248, 168);
RT_INTERFACE!{interface IAppointmentCalendarForwardMeetingRequestEventArgs(IAppointmentCalendarForwardMeetingRequestEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarForwardMeetingRequestEventArgs] {
    fn get_Request(&self, out: *mut *mut AppointmentCalendarForwardMeetingRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl IAppointmentCalendarForwardMeetingRequestEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppointmentCalendarForwardMeetingRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarForwardMeetingRequestEventArgs: IAppointmentCalendarForwardMeetingRequestEventArgs}
DEFINE_IID!(IID_IAppointmentCalendarProposeNewTimeForMeetingRequest, 3457967093, 60918, 17347, 130, 183, 190, 107, 54, 140, 105, 0);
RT_INTERFACE!{interface IAppointmentCalendarProposeNewTimeForMeetingRequest(IAppointmentCalendarProposeNewTimeForMeetingRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarProposeNewTimeForMeetingRequest] {
    fn get_AppointmentCalendarLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentOriginalStartTime(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_NewStartTime(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_NewDuration(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Comment(&self, out: *mut HSTRING) -> HRESULT,
    fn ReportCompletedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn ReportFailedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendarProposeNewTimeForMeetingRequest {
    #[inline] pub unsafe fn get_appointment_calendar_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendarLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_original_start_time(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentOriginalStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_start_time(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_duration(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_comment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Comment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportCompletedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_failed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportFailedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarProposeNewTimeForMeetingRequest: IAppointmentCalendarProposeNewTimeForMeetingRequest}
DEFINE_IID!(IID_IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgs, 3537336280, 65233, 17024, 163, 186, 46, 31, 71, 96, 154, 162);
RT_INTERFACE!{interface IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgs(IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgs] {
    fn get_Request(&self, out: *mut *mut AppointmentCalendarProposeNewTimeForMeetingRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppointmentCalendarProposeNewTimeForMeetingRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarProposeNewTimeForMeetingRequestEventArgs: IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgs}
DEFINE_IID!(IID_IAppointmentCalendarSyncManagerSyncRequest, 313210923, 29027, 19030, 154, 78, 114, 35, 168, 74, 223, 70);
RT_INTERFACE!{interface IAppointmentCalendarSyncManagerSyncRequest(IAppointmentCalendarSyncManagerSyncRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarSyncManagerSyncRequest] {
    fn get_AppointmentCalendarLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn ReportCompletedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn ReportFailedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendarSyncManagerSyncRequest {
    #[inline] pub unsafe fn get_appointment_calendar_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendarLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportCompletedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_failed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportFailedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarSyncManagerSyncRequest: IAppointmentCalendarSyncManagerSyncRequest}
DEFINE_IID!(IID_IAppointmentCalendarSyncManagerSyncRequestEventArgs, 3390555895, 644, 20189, 135, 186, 77, 143, 105, 220, 245, 192);
RT_INTERFACE!{interface IAppointmentCalendarSyncManagerSyncRequestEventArgs(IAppointmentCalendarSyncManagerSyncRequestEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarSyncManagerSyncRequestEventArgs] {
    fn get_Request(&self, out: *mut *mut AppointmentCalendarSyncManagerSyncRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl IAppointmentCalendarSyncManagerSyncRequestEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppointmentCalendarSyncManagerSyncRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarSyncManagerSyncRequestEventArgs: IAppointmentCalendarSyncManagerSyncRequestEventArgs}
DEFINE_IID!(IID_IAppointmentCalendarUpdateMeetingResponseRequest, 2741854348, 49821, 19348, 176, 134, 126, 159, 247, 189, 132, 160);
RT_INTERFACE!{interface IAppointmentCalendarUpdateMeetingResponseRequest(IAppointmentCalendarUpdateMeetingResponseRequestVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarUpdateMeetingResponseRequest] {
    fn get_AppointmentCalendarLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentLocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppointmentOriginalStartTime(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_Response(&self, out: *mut super::AppointmentParticipantResponse) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Comment(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SendUpdate(&self, out: *mut bool) -> HRESULT,
    fn ReportCompletedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn ReportFailedAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IAppointmentCalendarUpdateMeetingResponseRequest {
    #[inline] pub unsafe fn get_appointment_calendar_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentCalendarLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentLocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appointment_original_start_time(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppointmentOriginalStartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_response(&self) -> Result<super::AppointmentParticipantResponse> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Response)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_comment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Comment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_send_update(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SendUpdate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_completed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportCompletedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_failed_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReportFailedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarUpdateMeetingResponseRequest: IAppointmentCalendarUpdateMeetingResponseRequest}
DEFINE_IID!(IID_IAppointmentCalendarUpdateMeetingResponseRequestEventArgs, 2289408131, 38847, 18333, 174, 213, 11, 232, 206, 86, 125, 30);
RT_INTERFACE!{interface IAppointmentCalendarUpdateMeetingResponseRequestEventArgs(IAppointmentCalendarUpdateMeetingResponseRequestEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentCalendarUpdateMeetingResponseRequestEventArgs] {
    fn get_Request(&self, out: *mut *mut AppointmentCalendarUpdateMeetingResponseRequest) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl IAppointmentCalendarUpdateMeetingResponseRequestEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<AppointmentCalendarUpdateMeetingResponseRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentCalendarUpdateMeetingResponseRequestEventArgs: IAppointmentCalendarUpdateMeetingResponseRequestEventArgs}
DEFINE_IID!(IID_IAppointmentDataProviderConnection, 4091387267, 12884, 18015, 171, 219, 146, 128, 70, 85, 44, 244);
RT_INTERFACE!{interface IAppointmentDataProviderConnection(IAppointmentDataProviderConnectionVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentDataProviderConnection] {
    fn add_SyncRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarSyncManagerSyncRequestEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SyncRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CreateOrUpdateAppointmentRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CreateOrUpdateAppointmentRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CancelMeetingRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarCancelMeetingRequestEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CancelMeetingRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ForwardMeetingRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarForwardMeetingRequestEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ForwardMeetingRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ProposeNewTimeForMeetingRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarProposeNewTimeForMeetingRequestEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ProposeNewTimeForMeetingRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_UpdateMeetingResponseRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarUpdateMeetingResponseRequestEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UpdateMeetingResponseRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn Start(&self) -> HRESULT
}}
impl IAppointmentDataProviderConnection {
    #[inline] pub unsafe fn add_sync_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarSyncManagerSyncRequestEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SyncRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sync_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SyncRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_create_or_update_appointment_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CreateOrUpdateAppointmentRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_create_or_update_appointment_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CreateOrUpdateAppointmentRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_cancel_meeting_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarCancelMeetingRequestEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CancelMeetingRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_cancel_meeting_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CancelMeetingRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_forward_meeting_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarForwardMeetingRequestEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ForwardMeetingRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_forward_meeting_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ForwardMeetingRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_propose_new_time_for_meeting_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarProposeNewTimeForMeetingRequestEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ProposeNewTimeForMeetingRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_propose_new_time_for_meeting_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ProposeNewTimeForMeetingRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_update_meeting_response_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<AppointmentDataProviderConnection, AppointmentCalendarUpdateMeetingResponseRequestEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UpdateMeetingResponseRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_update_meeting_response_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UpdateMeetingResponseRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentDataProviderConnection: IAppointmentDataProviderConnection}
DEFINE_IID!(IID_IAppointmentDataProviderTriggerDetails, 3005758465, 32274, 20062, 177, 239, 116, 251, 104, 172, 111, 42);
RT_INTERFACE!{interface IAppointmentDataProviderTriggerDetails(IAppointmentDataProviderTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentDataProviderTriggerDetails] {
    fn get_Connection(&self, out: *mut *mut AppointmentDataProviderConnection) -> HRESULT
}}
impl IAppointmentDataProviderTriggerDetails {
    #[inline] pub unsafe fn get_connection(&self) -> Result<ComPtr<AppointmentDataProviderConnection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Connection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentDataProviderTriggerDetails: IAppointmentDataProviderTriggerDetails}
} // Windows.ApplicationModel.Appointments.DataProvider
} // Windows.ApplicationModel.Appointments
pub mod activation { // Windows.ApplicationModel.Activation
use ::prelude::*;
DEFINE_IID!(IID_IActivatedEventArgs, 3479508755, 52488, 20440, 182, 151, 162, 129, 182, 84, 78, 46);
RT_INTERFACE!{interface IActivatedEventArgs(IActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IActivatedEventArgs] {
    fn get_Kind(&self, out: *mut ActivationKind) -> HRESULT,
    fn get_PreviousExecutionState(&self, out: *mut ApplicationExecutionState) -> HRESULT,
    fn get_SplashScreen(&self, out: *mut *mut SplashScreen) -> HRESULT
}}
impl IActivatedEventArgs {
    #[inline] pub unsafe fn get_kind(&self) -> Result<ActivationKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_previous_execution_state(&self) -> Result<ApplicationExecutionState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PreviousExecutionState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_splash_screen(&self) -> Result<ComPtr<SplashScreen>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SplashScreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IActivatedEventArgsWithUser, 485530526, 39266, 18742, 128, 255, 175, 200, 232, 174, 92, 140);
RT_INTERFACE!{interface IActivatedEventArgsWithUser(IActivatedEventArgsWithUserVtbl): IInspectable(IInspectableVtbl) [IID_IActivatedEventArgsWithUser] {
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IActivatedEventArgsWithUser {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ActivationKind: i32 {
    Launch (ActivationKind_Launch) = 0, Search (ActivationKind_Search) = 1, ShareTarget (ActivationKind_ShareTarget) = 2, File (ActivationKind_File) = 3, Protocol (ActivationKind_Protocol) = 4, FileOpenPicker (ActivationKind_FileOpenPicker) = 5, FileSavePicker (ActivationKind_FileSavePicker) = 6, CachedFileUpdater (ActivationKind_CachedFileUpdater) = 7, ContactPicker (ActivationKind_ContactPicker) = 8, Device (ActivationKind_Device) = 9, PrintTaskSettings (ActivationKind_PrintTaskSettings) = 10, CameraSettings (ActivationKind_CameraSettings) = 11, RestrictedLaunch (ActivationKind_RestrictedLaunch) = 12, AppointmentsProvider (ActivationKind_AppointmentsProvider) = 13, Contact (ActivationKind_Contact) = 14, LockScreenCall (ActivationKind_LockScreenCall) = 15, VoiceCommand (ActivationKind_VoiceCommand) = 16, LockScreen (ActivationKind_LockScreen) = 17, PickerReturned (ActivationKind_PickerReturned) = 1000, WalletAction (ActivationKind_WalletAction) = 1001, PickFileContinuation (ActivationKind_PickFileContinuation) = 1002, PickSaveFileContinuation (ActivationKind_PickSaveFileContinuation) = 1003, PickFolderContinuation (ActivationKind_PickFolderContinuation) = 1004, WebAuthenticationBrokerContinuation (ActivationKind_WebAuthenticationBrokerContinuation) = 1005, WebAccountProvider (ActivationKind_WebAccountProvider) = 1006, ComponentUI (ActivationKind_ComponentUI) = 1007, ProtocolForResults (ActivationKind_ProtocolForResults) = 1009, ToastNotification (ActivationKind_ToastNotification) = 1010, Print3DWorkflow (ActivationKind_Print3DWorkflow) = 1011, DialReceiver (ActivationKind_DialReceiver) = 1012, DevicePairing (ActivationKind_DevicePairing) = 1013, UserDataAccountsProvider (ActivationKind_UserDataAccountsProvider) = 1014, FilePickerExperience (ActivationKind_FilePickerExperience) = 1015, LockScreenComponent (ActivationKind_LockScreenComponent) = 1016, ContactPanel (ActivationKind_ContactPanel) = 1017, PrintWorkflowForegroundTask (ActivationKind_PrintWorkflowForegroundTask) = 1018, GameUIProvider (ActivationKind_GameUIProvider) = 1019, StartupTask (ActivationKind_StartupTask) = 1020, CommandLineLaunch (ActivationKind_CommandLineLaunch) = 1021,
}}
RT_ENUM! { enum ApplicationExecutionState: i32 {
    NotRunning (ApplicationExecutionState_NotRunning) = 0, Running (ApplicationExecutionState_Running) = 1, Suspended (ApplicationExecutionState_Suspended) = 2, Terminated (ApplicationExecutionState_Terminated) = 3, ClosedByUser (ApplicationExecutionState_ClosedByUser) = 4,
}}
DEFINE_IID!(IID_IApplicationViewActivatedEventArgs, 2467098443, 47145, 16636, 136, 244, 133, 19, 232, 166, 71, 56);
RT_INTERFACE!{interface IApplicationViewActivatedEventArgs(IApplicationViewActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewActivatedEventArgs] {
    fn get_CurrentlyShownApplicationViewId(&self, out: *mut i32) -> HRESULT
}}
impl IApplicationViewActivatedEventArgs {
    #[inline] pub unsafe fn get_currently_shown_application_view_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentlyShownApplicationViewId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentsProviderActivatedEventArgs, 862241797, 37692, 20093, 160, 52, 80, 15, 184, 220, 217, 243);
RT_INTERFACE!{interface IAppointmentsProviderActivatedEventArgs(IAppointmentsProviderActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderActivatedEventArgs] {
    fn get_Verb(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppointmentsProviderActivatedEventArgs {
    #[inline] pub unsafe fn get_verb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Verb)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppointmentsProviderAddAppointmentActivatedEventArgs, 2726695783, 52965, 20045, 158, 215, 65, 195, 78, 193, 139, 2);
RT_INTERFACE!{interface IAppointmentsProviderAddAppointmentActivatedEventArgs(IAppointmentsProviderAddAppointmentActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderAddAppointmentActivatedEventArgs] {
    fn get_AddAppointmentOperation(&self, out: *mut *mut super::appointments::appointmentsprovider::AddAppointmentOperation) -> HRESULT
}}
impl IAppointmentsProviderAddAppointmentActivatedEventArgs {
    #[inline] pub unsafe fn get_add_appointment_operation(&self) -> Result<ComPtr<super::appointments::appointmentsprovider::AddAppointmentOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AddAppointmentOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentsProviderAddAppointmentActivatedEventArgs: IAppointmentsProviderAddAppointmentActivatedEventArgs}
DEFINE_IID!(IID_IAppointmentsProviderRemoveAppointmentActivatedEventArgs, 1964980920, 2958, 17692, 159, 21, 150, 110, 105, 155, 172, 37);
RT_INTERFACE!{interface IAppointmentsProviderRemoveAppointmentActivatedEventArgs(IAppointmentsProviderRemoveAppointmentActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderRemoveAppointmentActivatedEventArgs] {
    fn get_RemoveAppointmentOperation(&self, out: *mut *mut super::appointments::appointmentsprovider::RemoveAppointmentOperation) -> HRESULT
}}
impl IAppointmentsProviderRemoveAppointmentActivatedEventArgs {
    #[inline] pub unsafe fn get_remove_appointment_operation(&self) -> Result<ComPtr<super::appointments::appointmentsprovider::RemoveAppointmentOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoveAppointmentOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentsProviderRemoveAppointmentActivatedEventArgs: IAppointmentsProviderRemoveAppointmentActivatedEventArgs}
DEFINE_IID!(IID_IAppointmentsProviderReplaceAppointmentActivatedEventArgs, 357677012, 43393, 16487, 138, 98, 5, 36, 228, 173, 225, 33);
RT_INTERFACE!{interface IAppointmentsProviderReplaceAppointmentActivatedEventArgs(IAppointmentsProviderReplaceAppointmentActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderReplaceAppointmentActivatedEventArgs] {
    fn get_ReplaceAppointmentOperation(&self, out: *mut *mut super::appointments::appointmentsprovider::ReplaceAppointmentOperation) -> HRESULT
}}
impl IAppointmentsProviderReplaceAppointmentActivatedEventArgs {
    #[inline] pub unsafe fn get_replace_appointment_operation(&self) -> Result<ComPtr<super::appointments::appointmentsprovider::ReplaceAppointmentOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ReplaceAppointmentOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentsProviderReplaceAppointmentActivatedEventArgs: IAppointmentsProviderReplaceAppointmentActivatedEventArgs}
DEFINE_IID!(IID_IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs, 962130021, 38977, 19621, 153, 155, 136, 81, 152, 185, 239, 42);
RT_INTERFACE!{interface IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs(IAppointmentsProviderShowAppointmentDetailsActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs] {
    fn get_InstanceStartDate(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_LocalId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RoamingId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs {
    #[inline] pub unsafe fn get_instance_start_date(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InstanceStartDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_local_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LocalId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_roaming_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RoamingId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentsProviderShowAppointmentDetailsActivatedEventArgs: IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs}
DEFINE_IID!(IID_IAppointmentsProviderShowTimeFrameActivatedEventArgs, 2611915686, 3595, 18858, 186, 188, 18, 177, 220, 119, 73, 134);
RT_INTERFACE!{interface IAppointmentsProviderShowTimeFrameActivatedEventArgs(IAppointmentsProviderShowTimeFrameActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppointmentsProviderShowTimeFrameActivatedEventArgs] {
    fn get_TimeToShow(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IAppointmentsProviderShowTimeFrameActivatedEventArgs {
    #[inline] pub unsafe fn get_time_to_show(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeToShow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppointmentsProviderShowTimeFrameActivatedEventArgs: IAppointmentsProviderShowTimeFrameActivatedEventArgs}
DEFINE_IID!(IID_IBackgroundActivatedEventArgs, 2870263520, 59232, 17422, 169, 28, 68, 121, 109, 227, 169, 45);
RT_INTERFACE!{interface IBackgroundActivatedEventArgs(IBackgroundActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBackgroundActivatedEventArgs] {
    fn get_TaskInstance(&self, out: *mut *mut super::background::IBackgroundTaskInstance) -> HRESULT
}}
impl IBackgroundActivatedEventArgs {
    #[inline] pub unsafe fn get_task_instance(&self) -> Result<ComPtr<super::background::IBackgroundTaskInstance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TaskInstance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BackgroundActivatedEventArgs: IBackgroundActivatedEventArgs}
DEFINE_IID!(IID_ICachedFileUpdaterActivatedEventArgs, 3496915399, 14341, 20171, 183, 87, 108, 241, 94, 38, 254, 243);
RT_INTERFACE!{interface ICachedFileUpdaterActivatedEventArgs(ICachedFileUpdaterActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICachedFileUpdaterActivatedEventArgs] {
    #[cfg(feature="windows-storage")] fn get_CachedFileUpdaterUI(&self, out: *mut *mut super::super::storage::provider::CachedFileUpdaterUI) -> HRESULT
}}
impl ICachedFileUpdaterActivatedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_cached_file_updater_ui(&self) -> Result<ComPtr<super::super::storage::provider::CachedFileUpdaterUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CachedFileUpdaterUI)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CachedFileUpdaterActivatedEventArgs: ICachedFileUpdaterActivatedEventArgs}
DEFINE_IID!(IID_ICameraSettingsActivatedEventArgs, 4217873672, 11693, 18698, 145, 112, 220, 160, 54, 235, 17, 75);
RT_INTERFACE!{interface ICameraSettingsActivatedEventArgs(ICameraSettingsActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICameraSettingsActivatedEventArgs] {
    fn get_VideoDeviceController(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_VideoDeviceExtension(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl ICameraSettingsActivatedEventArgs {
    #[inline] pub unsafe fn get_video_device_controller(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_extension(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceExtension)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CameraSettingsActivatedEventArgs: ICameraSettingsActivatedEventArgs}
DEFINE_IID!(IID_ICommandLineActivatedEventArgs, 1158039340, 106, 18667, 138, 251, 208, 122, 178, 94, 51, 102);
RT_INTERFACE!{interface ICommandLineActivatedEventArgs(ICommandLineActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICommandLineActivatedEventArgs] {
    fn get_Operation(&self, out: *mut *mut CommandLineActivationOperation) -> HRESULT
}}
impl ICommandLineActivatedEventArgs {
    #[inline] pub unsafe fn get_operation(&self) -> Result<ComPtr<CommandLineActivationOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Operation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CommandLineActivatedEventArgs: ICommandLineActivatedEventArgs}
DEFINE_IID!(IID_ICommandLineActivationOperation, 2571839553, 50590, 20329, 188, 253, 182, 30, 212, 230, 34, 235);
RT_INTERFACE!{interface ICommandLineActivationOperation(ICommandLineActivationOperationVtbl): IInspectable(IInspectableVtbl) [IID_ICommandLineActivationOperation] {
    fn get_Arguments(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CurrentDirectoryPath(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ExitCode(&self, value: i32) -> HRESULT,
    fn get_ExitCode(&self, out: *mut i32) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl ICommandLineActivationOperation {
    #[inline] pub unsafe fn get_arguments(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_directory_path(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CurrentDirectoryPath)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_exit_code(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ExitCode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exit_code(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExitCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CommandLineActivationOperation: ICommandLineActivationOperation}
DEFINE_IID!(IID_IContactActivatedEventArgs, 3592921540, 49189, 19521, 157, 239, 241, 234, 250, 208, 117, 231);
RT_INTERFACE!{interface IContactActivatedEventArgs(IContactActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactActivatedEventArgs] {
    fn get_Verb(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactActivatedEventArgs {
    #[inline] pub unsafe fn get_verb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Verb)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactCallActivatedEventArgs, 3269399751, 12523, 16838, 179, 188, 91, 22, 148, 249, 218, 179);
RT_INTERFACE!{interface IContactCallActivatedEventArgs(IContactCallActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactCallActivatedEventArgs] {
    fn get_ServiceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ServiceUserId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut super::contacts::Contact) -> HRESULT
}}
impl IContactCallActivatedEventArgs {
    #[inline] pub unsafe fn get_service_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_user_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceUserId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<super::contacts::Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactCallActivatedEventArgs: IContactCallActivatedEventArgs}
DEFINE_IID!(IID_IContactMapActivatedEventArgs, 3006003312, 61159, 19154, 170, 241, 168, 126, 255, 207, 0, 164);
RT_INTERFACE!{interface IContactMapActivatedEventArgs(IContactMapActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactMapActivatedEventArgs] {
    fn get_Address(&self, out: *mut *mut super::contacts::ContactAddress) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut super::contacts::Contact) -> HRESULT
}}
impl IContactMapActivatedEventArgs {
    #[inline] pub unsafe fn get_address(&self) -> Result<ComPtr<super::contacts::ContactAddress>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Address)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<super::contacts::Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactMapActivatedEventArgs: IContactMapActivatedEventArgs}
DEFINE_IID!(IID_IContactMessageActivatedEventArgs, 3730410930, 3587, 17328, 191, 86, 188, 196, 11, 49, 98, 223);
RT_INTERFACE!{interface IContactMessageActivatedEventArgs(IContactMessageActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactMessageActivatedEventArgs] {
    fn get_ServiceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ServiceUserId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut super::contacts::Contact) -> HRESULT
}}
impl IContactMessageActivatedEventArgs {
    #[inline] pub unsafe fn get_service_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_user_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceUserId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<super::contacts::Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactMessageActivatedEventArgs: IContactMessageActivatedEventArgs}
DEFINE_IID!(IID_IContactPanelActivatedEventArgs, 1388012516, 54228, 19299, 128, 81, 74, 242, 8, 44, 171, 128);
RT_INTERFACE!{interface IContactPanelActivatedEventArgs(IContactPanelActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactPanelActivatedEventArgs] {
    fn get_ContactPanel(&self, out: *mut *mut super::contacts::ContactPanel) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut super::contacts::Contact) -> HRESULT
}}
impl IContactPanelActivatedEventArgs {
    #[inline] pub unsafe fn get_contact_panel(&self) -> Result<ComPtr<super::contacts::ContactPanel>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactPanel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<super::contacts::Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPanelActivatedEventArgs: IContactPanelActivatedEventArgs}
DEFINE_IID!(IID_IContactPickerActivatedEventArgs, 3461851879, 25673, 17831, 151, 31, 209, 19, 190, 122, 137, 54);
RT_INTERFACE!{interface IContactPickerActivatedEventArgs(IContactPickerActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactPickerActivatedEventArgs] {
    fn get_ContactPickerUI(&self, out: *mut *mut super::contacts::provider::ContactPickerUI) -> HRESULT
}}
impl IContactPickerActivatedEventArgs {
    #[inline] pub unsafe fn get_contact_picker_ui(&self) -> Result<ComPtr<super::contacts::provider::ContactPickerUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactPickerUI)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPickerActivatedEventArgs: IContactPickerActivatedEventArgs}
DEFINE_IID!(IID_IContactPostActivatedEventArgs, 3009035367, 61927, 18005, 173, 110, 72, 87, 88, 143, 85, 47);
RT_INTERFACE!{interface IContactPostActivatedEventArgs(IContactPostActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactPostActivatedEventArgs] {
    fn get_ServiceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ServiceUserId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut super::contacts::Contact) -> HRESULT
}}
impl IContactPostActivatedEventArgs {
    #[inline] pub unsafe fn get_service_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_user_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceUserId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<super::contacts::Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPostActivatedEventArgs: IContactPostActivatedEventArgs}
DEFINE_IID!(IID_IContactsProviderActivatedEventArgs, 1166073000, 22352, 18710, 170, 82, 192, 130, 149, 33, 235, 148);
RT_INTERFACE!{interface IContactsProviderActivatedEventArgs(IContactsProviderActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactsProviderActivatedEventArgs] {
    fn get_Verb(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactsProviderActivatedEventArgs {
    #[inline] pub unsafe fn get_verb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Verb)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactVideoCallActivatedEventArgs, 1627889080, 58343, 19279, 133, 141, 92, 99, 169, 110, 246, 132);
RT_INTERFACE!{interface IContactVideoCallActivatedEventArgs(IContactVideoCallActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactVideoCallActivatedEventArgs] {
    fn get_ServiceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ServiceUserId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut super::contacts::Contact) -> HRESULT
}}
impl IContactVideoCallActivatedEventArgs {
    #[inline] pub unsafe fn get_service_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_user_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceUserId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<super::contacts::Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactVideoCallActivatedEventArgs: IContactVideoCallActivatedEventArgs}
DEFINE_IID!(IID_IContinuationActivatedEventArgs, 3850438325, 5471, 19092, 167, 66, 199, 224, 143, 78, 24, 140);
RT_INTERFACE!{interface IContinuationActivatedEventArgs(IContinuationActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContinuationActivatedEventArgs] {
    fn get_ContinuationData(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT
}}
impl IContinuationActivatedEventArgs {
    #[inline] pub unsafe fn get_continuation_data(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContinuationData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceActivatedEventArgs, 3444619689, 52752, 17618, 130, 52, 195, 85, 160, 115, 239, 51);
RT_INTERFACE!{interface IDeviceActivatedEventArgs(IDeviceActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceActivatedEventArgs] {
    fn get_DeviceInformationId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Verb(&self, out: *mut HSTRING) -> HRESULT
}}
impl IDeviceActivatedEventArgs {
    #[inline] pub unsafe fn get_device_information_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformationId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_verb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Verb)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceActivatedEventArgs: IDeviceActivatedEventArgs}
DEFINE_IID!(IID_IDevicePairingActivatedEventArgs, 3953185252, 60614, 16712, 148, 237, 244, 179, 126, 192, 91, 62);
RT_INTERFACE!{interface IDevicePairingActivatedEventArgs(IDevicePairingActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePairingActivatedEventArgs] {
    #[cfg(feature="windows-devices")] fn get_DeviceInformation(&self, out: *mut *mut super::super::devices::enumeration::DeviceInformation) -> HRESULT
}}
impl IDevicePairingActivatedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_device_information(&self) -> Result<ComPtr<super::super::devices::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DevicePairingActivatedEventArgs: IDevicePairingActivatedEventArgs}
DEFINE_IID!(IID_IDialReceiverActivatedEventArgs, 4218912471, 34286, 17774, 164, 77, 133, 215, 48, 231, 10, 237);
RT_INTERFACE!{interface IDialReceiverActivatedEventArgs(IDialReceiverActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDialReceiverActivatedEventArgs] {
    fn get_AppName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IDialReceiverActivatedEventArgs {
    #[inline] pub unsafe fn get_app_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DialReceiverActivatedEventArgs: IDialReceiverActivatedEventArgs}
DEFINE_IID!(IID_IFileActivatedEventArgs, 3140156467, 37809, 17133, 139, 38, 35, 109, 217, 199, 132, 150);
RT_INTERFACE!{interface IFileActivatedEventArgs(IFileActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFileActivatedEventArgs] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Files(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::storage::IStorageItem>) -> HRESULT,
    fn get_Verb(&self, out: *mut HSTRING) -> HRESULT
}}
impl IFileActivatedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_files(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::storage::IStorageItem>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Files)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_verb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Verb)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FileActivatedEventArgs: IFileActivatedEventArgs}
DEFINE_IID!(IID_IFileActivatedEventArgsWithCallerPackageFamilyName, 761327723, 53855, 19749, 134, 83, 225, 197, 225, 16, 131, 9);
RT_INTERFACE!{interface IFileActivatedEventArgsWithCallerPackageFamilyName(IFileActivatedEventArgsWithCallerPackageFamilyNameVtbl): IInspectable(IInspectableVtbl) [IID_IFileActivatedEventArgsWithCallerPackageFamilyName] {
    fn get_CallerPackageFamilyName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IFileActivatedEventArgsWithCallerPackageFamilyName {
    #[inline] pub unsafe fn get_caller_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallerPackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFileActivatedEventArgsWithNeighboringFiles, 1127981476, 57826, 18685, 183, 252, 181, 214, 238, 230, 80, 51);
RT_INTERFACE!{interface IFileActivatedEventArgsWithNeighboringFiles(IFileActivatedEventArgsWithNeighboringFilesVtbl): IInspectable(IInspectableVtbl) [IID_IFileActivatedEventArgsWithNeighboringFiles] {
    #[cfg(feature="windows-storage")] fn get_NeighboringFilesQuery(&self, out: *mut *mut super::super::storage::search::StorageFileQueryResult) -> HRESULT
}}
impl IFileActivatedEventArgsWithNeighboringFiles {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_neighboring_files_query(&self) -> Result<ComPtr<super::super::storage::search::StorageFileQueryResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NeighboringFilesQuery)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFileOpenPickerActivatedEventArgs, 1921151106, 21797, 19442, 188, 9, 31, 80, 149, 212, 150, 77);
RT_INTERFACE!{interface IFileOpenPickerActivatedEventArgs(IFileOpenPickerActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFileOpenPickerActivatedEventArgs] {
    #[cfg(feature="windows-storage")] fn get_FileOpenPickerUI(&self, out: *mut *mut super::super::storage::pickers::provider::FileOpenPickerUI) -> HRESULT
}}
impl IFileOpenPickerActivatedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file_open_picker_ui(&self) -> Result<ComPtr<super::super::storage::pickers::provider::FileOpenPickerUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FileOpenPickerUI)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FileOpenPickerActivatedEventArgs: IFileOpenPickerActivatedEventArgs}
DEFINE_IID!(IID_IFileOpenPickerActivatedEventArgs2, 1584602982, 36127, 17915, 175, 29, 115, 32, 92, 143, 199, 161);
RT_INTERFACE!{interface IFileOpenPickerActivatedEventArgs2(IFileOpenPickerActivatedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IFileOpenPickerActivatedEventArgs2] {
    fn get_CallerPackageFamilyName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IFileOpenPickerActivatedEventArgs2 {
    #[inline] pub unsafe fn get_caller_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallerPackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFileOpenPickerContinuationEventArgs, 4042932026, 54504, 19155, 156, 52, 35, 8, 243, 47, 206, 201);
RT_INTERFACE!{interface IFileOpenPickerContinuationEventArgs(IFileOpenPickerContinuationEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFileOpenPickerContinuationEventArgs] {
    #[cfg(feature="windows-storage")] fn get_Files(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::storage::StorageFile>) -> HRESULT
}}
impl IFileOpenPickerContinuationEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_files(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::storage::StorageFile>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Files)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FileOpenPickerContinuationEventArgs: IFileOpenPickerContinuationEventArgs}
DEFINE_IID!(IID_IFileSavePickerActivatedEventArgs, 2176949489, 29926, 17287, 130, 235, 187, 143, 214, 75, 67, 70);
RT_INTERFACE!{interface IFileSavePickerActivatedEventArgs(IFileSavePickerActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFileSavePickerActivatedEventArgs] {
    #[cfg(feature="windows-storage")] fn get_FileSavePickerUI(&self, out: *mut *mut super::super::storage::pickers::provider::FileSavePickerUI) -> HRESULT
}}
impl IFileSavePickerActivatedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file_save_picker_ui(&self) -> Result<ComPtr<super::super::storage::pickers::provider::FileSavePickerUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FileSavePickerUI)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FileSavePickerActivatedEventArgs: IFileSavePickerActivatedEventArgs}
DEFINE_IID!(IID_IFileSavePickerActivatedEventArgs2, 1802763795, 11506, 19784, 140, 188, 175, 103, 210, 63, 28, 231);
RT_INTERFACE!{interface IFileSavePickerActivatedEventArgs2(IFileSavePickerActivatedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IFileSavePickerActivatedEventArgs2] {
    fn get_CallerPackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_EnterpriseId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IFileSavePickerActivatedEventArgs2 {
    #[inline] pub unsafe fn get_caller_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallerPackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enterprise_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EnterpriseId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFileSavePickerContinuationEventArgs, 746876897, 15277, 20275, 140, 139, 228, 111, 174, 130, 75, 75);
RT_INTERFACE!{interface IFileSavePickerContinuationEventArgs(IFileSavePickerContinuationEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFileSavePickerContinuationEventArgs] {
    #[cfg(feature="windows-storage")] fn get_File(&self, out: *mut *mut super::super::storage::StorageFile) -> HRESULT
}}
impl IFileSavePickerContinuationEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file(&self) -> Result<ComPtr<super::super::storage::StorageFile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_File)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FileSavePickerContinuationEventArgs: IFileSavePickerContinuationEventArgs}
DEFINE_IID!(IID_IFolderPickerContinuationEventArgs, 1367876454, 40779, 18831, 190, 176, 66, 104, 79, 110, 28, 41);
RT_INTERFACE!{interface IFolderPickerContinuationEventArgs(IFolderPickerContinuationEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFolderPickerContinuationEventArgs] {
    #[cfg(feature="windows-storage")] fn get_Folder(&self, out: *mut *mut super::super::storage::StorageFolder) -> HRESULT
}}
impl IFolderPickerContinuationEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_folder(&self) -> Result<ComPtr<super::super::storage::StorageFolder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Folder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FolderPickerContinuationEventArgs: IFolderPickerContinuationEventArgs}
DEFINE_IID!(IID_ILaunchActivatedEventArgs, 4224269862, 41290, 19279, 130, 176, 51, 190, 217, 32, 175, 82);
RT_INTERFACE!{interface ILaunchActivatedEventArgs(ILaunchActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ILaunchActivatedEventArgs] {
    fn get_Arguments(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TileId(&self, out: *mut HSTRING) -> HRESULT
}}
impl ILaunchActivatedEventArgs {
    #[inline] pub unsafe fn get_arguments(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tile_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TileId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LaunchActivatedEventArgs: ILaunchActivatedEventArgs}
DEFINE_IID!(IID_ILaunchActivatedEventArgs2, 265518780, 40393, 18101, 154, 206, 189, 149, 212, 86, 83, 69);
RT_INTERFACE!{interface ILaunchActivatedEventArgs2(ILaunchActivatedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_ILaunchActivatedEventArgs2] {
    fn get_TileActivatedInfo(&self, out: *mut *mut TileActivatedInfo) -> HRESULT
}}
impl ILaunchActivatedEventArgs2 {
    #[inline] pub unsafe fn get_tile_activated_info(&self) -> Result<ComPtr<TileActivatedInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TileActivatedInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ILockScreenActivatedEventArgs, 1017608550, 24840, 19009, 130, 32, 238, 125, 19, 60, 133, 50);
RT_INTERFACE!{interface ILockScreenActivatedEventArgs(ILockScreenActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ILockScreenActivatedEventArgs] {
    fn get_Info(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl ILockScreenActivatedEventArgs {
    #[inline] pub unsafe fn get_info(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Info)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LockScreenActivatedEventArgs: ILockScreenActivatedEventArgs}
DEFINE_IID!(IID_ILockScreenCallActivatedEventArgs, 116621246, 46578, 17547, 177, 62, 227, 40, 172, 28, 81, 106);
RT_INTERFACE!{interface ILockScreenCallActivatedEventArgs(ILockScreenCallActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ILockScreenCallActivatedEventArgs] {
    fn get_CallUI(&self, out: *mut *mut super::calls::LockScreenCallUI) -> HRESULT
}}
impl ILockScreenCallActivatedEventArgs {
    #[inline] pub unsafe fn get_call_ui(&self) -> Result<ComPtr<super::calls::LockScreenCallUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallUI)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LockScreenCallActivatedEventArgs: ILockScreenCallActivatedEventArgs}
RT_CLASS!{class LockScreenComponentActivatedEventArgs: IActivatedEventArgs}
DEFINE_IID!(IID_IPickerReturnedActivatedEventArgs, 906883001, 43475, 18820, 164, 237, 158, 199, 52, 96, 73, 33);
RT_INTERFACE!{interface IPickerReturnedActivatedEventArgs(IPickerReturnedActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPickerReturnedActivatedEventArgs] {
    fn get_PickerOperationId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPickerReturnedActivatedEventArgs {
    #[inline] pub unsafe fn get_picker_operation_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PickerOperationId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PickerReturnedActivatedEventArgs: IPickerReturnedActivatedEventArgs}
DEFINE_IID!(IID_IPrelaunchActivatedEventArgs, 205812091, 6647, 18646, 176, 70, 207, 34, 130, 110, 170, 116);
RT_INTERFACE!{interface IPrelaunchActivatedEventArgs(IPrelaunchActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPrelaunchActivatedEventArgs] {
    fn get_PrelaunchActivated(&self, out: *mut bool) -> HRESULT
}}
impl IPrelaunchActivatedEventArgs {
    #[inline] pub unsafe fn get_prelaunch_activated(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PrelaunchActivated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPrint3DWorkflowActivatedEventArgs, 1062725515, 62124, 17945, 131, 2, 239, 133, 94, 28, 155, 144);
RT_INTERFACE!{interface IPrint3DWorkflowActivatedEventArgs(IPrint3DWorkflowActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DWorkflowActivatedEventArgs] {
    #[cfg(feature="windows-devices")] fn get_Workflow(&self, out: *mut *mut super::super::devices::printers::extensions::Print3DWorkflow) -> HRESULT
}}
impl IPrint3DWorkflowActivatedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_workflow(&self) -> Result<ComPtr<super::super::devices::printers::extensions::Print3DWorkflow>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Workflow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Print3DWorkflowActivatedEventArgs: IPrint3DWorkflowActivatedEventArgs}
DEFINE_IID!(IID_IPrintTaskSettingsActivatedEventArgs, 3996164297, 52822, 18533, 186, 142, 137, 84, 172, 39, 17, 7);
RT_INTERFACE!{interface IPrintTaskSettingsActivatedEventArgs(IPrintTaskSettingsActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPrintTaskSettingsActivatedEventArgs] {
    #[cfg(feature="windows-devices")] fn get_Configuration(&self, out: *mut *mut super::super::devices::printers::extensions::PrintTaskConfiguration) -> HRESULT
}}
impl IPrintTaskSettingsActivatedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_configuration(&self) -> Result<ComPtr<super::super::devices::printers::extensions::PrintTaskConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Configuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PrintTaskSettingsActivatedEventArgs: IPrintTaskSettingsActivatedEventArgs}
DEFINE_IID!(IID_IProtocolActivatedEventArgs, 1620440285, 47040, 18091, 129, 254, 217, 15, 54, 208, 13, 36);
RT_INTERFACE!{interface IProtocolActivatedEventArgs(IProtocolActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IProtocolActivatedEventArgs] {
    fn get_Uri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT
}}
impl IProtocolActivatedEventArgs {
    #[inline] pub unsafe fn get_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Uri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ProtocolActivatedEventArgs: IProtocolActivatedEventArgs}
DEFINE_IID!(IID_IProtocolActivatedEventArgsWithCallerPackageFamilyNameAndData, 3628731410, 23695, 17292, 131, 203, 194, 143, 204, 11, 47, 219);
RT_INTERFACE!{interface IProtocolActivatedEventArgsWithCallerPackageFamilyNameAndData(IProtocolActivatedEventArgsWithCallerPackageFamilyNameAndDataVtbl): IInspectable(IInspectableVtbl) [IID_IProtocolActivatedEventArgsWithCallerPackageFamilyNameAndData] {
    fn get_CallerPackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Data(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT
}}
impl IProtocolActivatedEventArgsWithCallerPackageFamilyNameAndData {
    #[inline] pub unsafe fn get_caller_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallerPackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IProtocolForResultsActivatedEventArgs, 3880858306, 31463, 17687, 128, 172, 219, 232, 215, 204, 91, 156);
RT_INTERFACE!{interface IProtocolForResultsActivatedEventArgs(IProtocolForResultsActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IProtocolForResultsActivatedEventArgs] {
    #[cfg(feature="windows-system")] fn get_ProtocolForResultsOperation(&self, out: *mut *mut super::super::system::ProtocolForResultsOperation) -> HRESULT
}}
impl IProtocolForResultsActivatedEventArgs {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_protocol_for_results_operation(&self) -> Result<ComPtr<super::super::system::ProtocolForResultsOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolForResultsOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ProtocolForResultsActivatedEventArgs: IProtocolForResultsActivatedEventArgs}
DEFINE_IID!(IID_IRestrictedLaunchActivatedEventArgs, 3770133633, 49091, 17220, 165, 218, 25, 253, 90, 39, 186, 174);
RT_INTERFACE!{interface IRestrictedLaunchActivatedEventArgs(IRestrictedLaunchActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRestrictedLaunchActivatedEventArgs] {
    fn get_SharedContext(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IRestrictedLaunchActivatedEventArgs {
    #[inline] pub unsafe fn get_shared_context(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SharedContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RestrictedLaunchActivatedEventArgs: IRestrictedLaunchActivatedEventArgs}
DEFINE_IID!(IID_ISearchActivatedEventArgs, 2360568145, 22728, 17379, 148, 188, 65, 211, 63, 139, 99, 14);
RT_INTERFACE!{interface ISearchActivatedEventArgs(ISearchActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchActivatedEventArgs] {
    fn get_QueryText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT
}}
impl ISearchActivatedEventArgs {
    #[inline] pub unsafe fn get_query_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SearchActivatedEventArgs: ISearchActivatedEventArgs}
DEFINE_IID!(IID_ISearchActivatedEventArgsWithLinguisticDetails, 3231658970, 2219, 18737, 155, 124, 69, 16, 37, 242, 31, 129);
RT_INTERFACE!{interface ISearchActivatedEventArgsWithLinguisticDetails(ISearchActivatedEventArgsWithLinguisticDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISearchActivatedEventArgsWithLinguisticDetails] {
    fn get_LinguisticDetails(&self, out: *mut *mut super::search::SearchPaneQueryLinguisticDetails) -> HRESULT
}}
impl ISearchActivatedEventArgsWithLinguisticDetails {
    #[inline] pub unsafe fn get_linguistic_details(&self) -> Result<ComPtr<super::search::SearchPaneQueryLinguisticDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LinguisticDetails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IShareTargetActivatedEventArgs, 1272641992, 52658, 19147, 191, 195, 102, 72, 86, 51, 120, 236);
RT_INTERFACE!{interface IShareTargetActivatedEventArgs(IShareTargetActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IShareTargetActivatedEventArgs] {
    fn get_ShareOperation(&self, out: *mut *mut super::datatransfer::sharetarget::ShareOperation) -> HRESULT
}}
impl IShareTargetActivatedEventArgs {
    #[inline] pub unsafe fn get_share_operation(&self) -> Result<ComPtr<super::datatransfer::sharetarget::ShareOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ShareOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ShareTargetActivatedEventArgs: IShareTargetActivatedEventArgs}
DEFINE_IID!(IID_ISplashScreen, 3394082652, 54486, 17392, 151, 192, 8, 51, 198, 57, 28, 36);
RT_INTERFACE!{interface ISplashScreen(ISplashScreenVtbl): IInspectable(IInspectableVtbl) [IID_ISplashScreen] {
    fn get_ImageLocation(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn add_Dismissed(&self, handler: *mut super::super::foundation::TypedEventHandler<SplashScreen, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Dismissed(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISplashScreen {
    #[inline] pub unsafe fn get_image_location(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ImageLocation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_dismissed(&self, handler: &super::super::foundation::TypedEventHandler<SplashScreen, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Dismissed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_dismissed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Dismissed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SplashScreen: ISplashScreen}
DEFINE_IID!(IID_IStartupTaskActivatedEventArgs, 61938264, 21110, 19857, 134, 33, 84, 97, 24, 100, 213, 250);
RT_INTERFACE!{interface IStartupTaskActivatedEventArgs(IStartupTaskActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IStartupTaskActivatedEventArgs] {
    fn get_TaskId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IStartupTaskActivatedEventArgs {
    #[inline] pub unsafe fn get_task_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TaskId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class StartupTaskActivatedEventArgs: IStartupTaskActivatedEventArgs}
DEFINE_IID!(IID_ITileActivatedInfo, 2162467761, 14720, 20247, 183, 56, 137, 25, 78, 11, 143, 101);
RT_INTERFACE!{interface ITileActivatedInfo(ITileActivatedInfoVtbl): IInspectable(IInspectableVtbl) [IID_ITileActivatedInfo] {
    #[cfg(feature="windows-ui")] fn get_RecentlyShownNotifications(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::ui::notifications::ShownTileNotification>) -> HRESULT
}}
impl ITileActivatedInfo {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_recently_shown_notifications(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::ui::notifications::ShownTileNotification>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecentlyShownNotifications)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TileActivatedInfo: ITileActivatedInfo}
DEFINE_IID!(IID_IToastNotificationActivatedEventArgs, 2460512130, 21136, 17181, 190, 133, 196, 170, 238, 184, 104, 95);
RT_INTERFACE!{interface IToastNotificationActivatedEventArgs(IToastNotificationActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IToastNotificationActivatedEventArgs] {
    fn get_Argument(&self, out: *mut HSTRING) -> HRESULT,
    fn get_UserInput(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT
}}
impl IToastNotificationActivatedEventArgs {
    #[inline] pub unsafe fn get_argument(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Argument)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_input(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ToastNotificationActivatedEventArgs: IToastNotificationActivatedEventArgs}
DEFINE_IID!(IID_IUserDataAccountProviderActivatedEventArgs, 466220835, 36593, 19025, 166, 58, 254, 113, 30, 234, 182, 7);
RT_INTERFACE!{interface IUserDataAccountProviderActivatedEventArgs(IUserDataAccountProviderActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IUserDataAccountProviderActivatedEventArgs] {
    fn get_Operation(&self, out: *mut *mut super::userdataaccounts::provider::IUserDataAccountProviderOperation) -> HRESULT
}}
impl IUserDataAccountProviderActivatedEventArgs {
    #[inline] pub unsafe fn get_operation(&self) -> Result<ComPtr<super::userdataaccounts::provider::IUserDataAccountProviderOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Operation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class UserDataAccountProviderActivatedEventArgs: IUserDataAccountProviderActivatedEventArgs}
DEFINE_IID!(IID_IViewSwitcherProvider, 871532710, 23596, 19751, 186, 199, 117, 54, 8, 143, 18, 25);
RT_INTERFACE!{interface IViewSwitcherProvider(IViewSwitcherProviderVtbl): IInspectable(IInspectableVtbl) [IID_IViewSwitcherProvider] {
    #[cfg(feature="windows-ui")] fn get_ViewSwitcher(&self, out: *mut *mut super::super::ui::viewmanagement::ActivationViewSwitcher) -> HRESULT
}}
impl IViewSwitcherProvider {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_view_switcher(&self) -> Result<ComPtr<super::super::ui::viewmanagement::ActivationViewSwitcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ViewSwitcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVoiceCommandActivatedEventArgs, 2878528765, 36163, 19942, 151, 117, 32, 112, 75, 88, 27, 0);
RT_INTERFACE!{interface IVoiceCommandActivatedEventArgs(IVoiceCommandActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVoiceCommandActivatedEventArgs] {
    #[cfg(feature="windows-media")] fn get_Result(&self, out: *mut *mut super::super::media::speechrecognition::SpeechRecognitionResult) -> HRESULT
}}
impl IVoiceCommandActivatedEventArgs {
    #[cfg(feature="windows-media")] #[inline] pub unsafe fn get_result(&self) -> Result<ComPtr<super::super::media::speechrecognition::SpeechRecognitionResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VoiceCommandActivatedEventArgs: IVoiceCommandActivatedEventArgs}
DEFINE_IID!(IID_IWalletActionActivatedEventArgs, 4244374139, 6682, 19746, 146, 63, 174, 111, 69, 250, 82, 217);
RT_INTERFACE!{interface IWalletActionActivatedEventArgs(IWalletActionActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWalletActionActivatedEventArgs] {
    fn get_ItemId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ActionKind(&self, out: *mut super::wallet::WalletActionKind) -> HRESULT,
    fn get_ActionId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IWalletActionActivatedEventArgs {
    #[inline] pub unsafe fn get_item_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ItemId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_action_kind(&self) -> Result<super::wallet::WalletActionKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActionKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_action_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActionId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WalletActionActivatedEventArgs: IWalletActionActivatedEventArgs}
DEFINE_IID!(IID_IWebAccountProviderActivatedEventArgs, 1924601716, 39146, 19663, 151, 82, 70, 217, 5, 16, 4, 241);
RT_INTERFACE!{interface IWebAccountProviderActivatedEventArgs(IWebAccountProviderActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWebAccountProviderActivatedEventArgs] {
    #[cfg(feature="windows-security")] fn get_Operation(&self, out: *mut *mut super::super::security::authentication::web::provider::IWebAccountProviderOperation) -> HRESULT
}}
impl IWebAccountProviderActivatedEventArgs {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_operation(&self) -> Result<ComPtr<super::super::security::authentication::web::provider::IWebAccountProviderOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Operation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WebAccountProviderActivatedEventArgs: IWebAccountProviderActivatedEventArgs}
DEFINE_IID!(IID_IWebAuthenticationBrokerContinuationEventArgs, 1977459668, 30484, 17725, 183, 255, 185, 94, 58, 23, 9, 218);
RT_INTERFACE!{interface IWebAuthenticationBrokerContinuationEventArgs(IWebAuthenticationBrokerContinuationEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWebAuthenticationBrokerContinuationEventArgs] {
    #[cfg(feature="windows-security")] fn get_WebAuthenticationResult(&self, out: *mut *mut super::super::security::authentication::web::WebAuthenticationResult) -> HRESULT
}}
impl IWebAuthenticationBrokerContinuationEventArgs {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_web_authentication_result(&self) -> Result<ComPtr<super::super::security::authentication::web::WebAuthenticationResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WebAuthenticationResult)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WebAuthenticationBrokerContinuationEventArgs: IWebAuthenticationBrokerContinuationEventArgs}
} // Windows.ApplicationModel.Activation
pub mod chat { // Windows.ApplicationModel.Chat
use ::prelude::*;
DEFINE_IID!(IID_IChatCapabilities, 989820860, 14793, 19921, 173, 45, 57, 100, 221, 157, 64, 63);
RT_INTERFACE!{interface IChatCapabilities(IChatCapabilitiesVtbl): IInspectable(IInspectableVtbl) [IID_IChatCapabilities] {
    fn get_IsOnline(&self, out: *mut bool) -> HRESULT,
    fn get_IsChatCapable(&self, out: *mut bool) -> HRESULT,
    fn get_IsFileTransferCapable(&self, out: *mut bool) -> HRESULT,
    fn get_IsGeoLocationPushCapable(&self, out: *mut bool) -> HRESULT,
    fn get_IsIntegratedMessagingCapable(&self, out: *mut bool) -> HRESULT
}}
impl IChatCapabilities {
    #[inline] pub unsafe fn get_is_online(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOnline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_chat_capable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsChatCapable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_file_transfer_capable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFileTransferCapable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_geo_location_push_capable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGeoLocationPushCapable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_integrated_messaging_capable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsIntegratedMessagingCapable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ChatCapabilities: IChatCapabilities}
RT_CLASS!{static class ChatCapabilitiesManager}
impl RtActivatable<IChatCapabilitiesManagerStatics> for ChatCapabilitiesManager {}
impl ChatCapabilitiesManager {
    #[inline] pub fn get_cached_capabilities_async(address: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatCapabilities>>> { unsafe {
        <Self as RtActivatable<IChatCapabilitiesManagerStatics>>::get_activation_factory().get_cached_capabilities_async(address)
    }}
    #[inline] pub fn get_capabilities_from_network_async(address: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatCapabilities>>> { unsafe {
        <Self as RtActivatable<IChatCapabilitiesManagerStatics>>::get_activation_factory().get_capabilities_from_network_async(address)
    }}
}
DEFINE_CLSID!(ChatCapabilitiesManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,67,97,112,97,98,105,108,105,116,105,101,115,77,97,110,97,103,101,114,0]) [CLSID_ChatCapabilitiesManager]);
DEFINE_IID!(IID_IChatCapabilitiesManagerStatics, 3044683568, 28737, 17806, 176, 207, 124, 13, 159, 234, 51, 58);
RT_INTERFACE!{static interface IChatCapabilitiesManagerStatics(IChatCapabilitiesManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IChatCapabilitiesManagerStatics] {
    fn GetCachedCapabilitiesAsync(&self, address: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatCapabilities>) -> HRESULT,
    fn GetCapabilitiesFromNetworkAsync(&self, address: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatCapabilities>) -> HRESULT
}}
impl IChatCapabilitiesManagerStatics {
    #[inline] pub unsafe fn get_cached_capabilities_async(&self, address: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatCapabilities>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCachedCapabilitiesAsync)(self as *const _ as *mut _, address.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_capabilities_from_network_async(&self, address: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatCapabilities>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCapabilitiesFromNetworkAsync)(self as *const _ as *mut _, address.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatConversation, 2777417741, 6767, 18140, 143, 61, 245, 2, 134, 96, 182, 238);
RT_INTERFACE!{interface IChatConversation(IChatConversationVtbl): IInspectable(IInspectableVtbl) [IID_IChatConversation] {
    fn get_HasUnreadMessages(&self, out: *mut bool) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Subject(&self, value: HSTRING) -> HRESULT,
    fn get_IsConversationMuted(&self, out: *mut bool) -> HRESULT,
    fn put_IsConversationMuted(&self, value: bool) -> HRESULT,
    fn get_MostRecentMessageId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Participants(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_ThreadingInfo(&self, out: *mut *mut ChatConversationThreadingInfo) -> HRESULT,
    fn DeleteAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetMessageReader(&self, out: *mut *mut ChatMessageReader) -> HRESULT,
    fn MarkAllMessagesAsReadAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn MarkMessagesAsReadAsync(&self, value: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SaveAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn NotifyLocalParticipantComposing(&self, transportId: HSTRING, participantAddress: HSTRING, isComposing: bool) -> HRESULT,
    fn NotifyRemoteParticipantComposing(&self, transportId: HSTRING, participantAddress: HSTRING, isComposing: bool) -> HRESULT,
    fn add_RemoteParticipantComposingChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<ChatConversation, RemoteParticipantComposingChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RemoteParticipantComposingChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IChatConversation {
    #[inline] pub unsafe fn get_has_unread_messages(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasUnreadMessages)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subject(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Subject)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_conversation_muted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsConversationMuted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_conversation_muted(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsConversationMuted)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_most_recent_message_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MostRecentMessageId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_participants(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Participants)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_threading_info(&self) -> Result<ComPtr<ChatConversationThreadingInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ThreadingInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_reader(&self) -> Result<ComPtr<ChatMessageReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_all_messages_as_read_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkAllMessagesAsReadAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_messages_as_read_async(&self, value: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkMessagesAsReadAsync)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_local_participant_composing(&self, transportId: &HStringArg, participantAddress: &HStringArg, isComposing: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyLocalParticipantComposing)(self as *const _ as *mut _, transportId.get(), participantAddress.get(), isComposing);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_remote_participant_composing(&self, transportId: &HStringArg, participantAddress: &HStringArg, isComposing: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyRemoteParticipantComposing)(self as *const _ as *mut _, transportId.get(), participantAddress.get(), isComposing);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_remote_participant_composing_changed(&self, handler: &super::super::foundation::TypedEventHandler<ChatConversation, RemoteParticipantComposingChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RemoteParticipantComposingChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_remote_participant_composing_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RemoteParticipantComposingChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatConversation: IChatConversation}
DEFINE_IID!(IID_IChatConversation2, 167972049, 38970, 18346, 154, 144, 238, 72, 238, 153, 123, 89);
RT_INTERFACE!{interface IChatConversation2(IChatConversation2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatConversation2] {
    fn get_CanModifyParticipants(&self, out: *mut bool) -> HRESULT,
    fn put_CanModifyParticipants(&self, value: bool) -> HRESULT
}}
impl IChatConversation2 {
    #[inline] pub unsafe fn get_can_modify_participants(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanModifyParticipants)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_modify_participants(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanModifyParticipants)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatConversationReader, 89208530, 56882, 19015, 169, 58, 179, 220, 8, 51, 133, 43);
RT_INTERFACE!{interface IChatConversationReader(IChatConversationReaderVtbl): IInspectable(IInspectableVtbl) [IID_IChatConversationReader] {
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatConversation>>) -> HRESULT,
    fn ReadBatchWithCountAsync(&self, count: i32, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatConversation>>) -> HRESULT
}}
impl IChatConversationReader {
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatConversation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_batch_with_count_async(&self, count: i32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatConversation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchWithCountAsync)(self as *const _ as *mut _, count, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatConversationReader: IChatConversationReader}
DEFINE_IID!(IID_IChatConversationThreadingInfo, 857481692, 31239, 17442, 163, 44, 36, 190, 124, 109, 171, 36);
RT_INTERFACE!{interface IChatConversationThreadingInfo(IChatConversationThreadingInfoVtbl): IInspectable(IInspectableVtbl) [IID_IChatConversationThreadingInfo] {
    fn get_ContactId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ContactId(&self, value: HSTRING) -> HRESULT,
    fn get_Custom(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Custom(&self, value: HSTRING) -> HRESULT,
    fn get_ConversationId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ConversationId(&self, value: HSTRING) -> HRESULT,
    fn get_Participants(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_Kind(&self, out: *mut ChatConversationThreadingKind) -> HRESULT,
    fn put_Kind(&self, value: ChatConversationThreadingKind) -> HRESULT
}}
impl IChatConversationThreadingInfo {
    #[inline] pub unsafe fn get_contact_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_contact_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContactId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Custom)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Custom)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_conversation_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConversationId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_conversation_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ConversationId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_participants(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Participants)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<ChatConversationThreadingKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_kind(&self, value: ChatConversationThreadingKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Kind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatConversationThreadingInfo: IChatConversationThreadingInfo}
impl RtActivatable<IActivationFactory> for ChatConversationThreadingInfo {}
DEFINE_CLSID!(ChatConversationThreadingInfo(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,67,111,110,118,101,114,115,97,116,105,111,110,84,104,114,101,97,100,105,110,103,73,110,102,111,0]) [CLSID_ChatConversationThreadingInfo]);
RT_ENUM! { enum ChatConversationThreadingKind: i32 {
    Participants (ChatConversationThreadingKind_Participants) = 0, ContactId (ChatConversationThreadingKind_ContactId) = 1, ConversationId (ChatConversationThreadingKind_ConversationId) = 2, Custom (ChatConversationThreadingKind_Custom) = 3,
}}
DEFINE_IID!(IID_IChatItem, 2270285824, 52913, 16963, 184, 3, 21, 212, 90, 29, 212, 40);
RT_INTERFACE!{interface IChatItem(IChatItemVtbl): IInspectable(IInspectableVtbl) [IID_IChatItem] {
    fn get_ItemKind(&self, out: *mut ChatItemKind) -> HRESULT
}}
impl IChatItem {
    #[inline] pub unsafe fn get_item_kind(&self) -> Result<ChatItemKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ItemKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum ChatItemKind: i32 {
    Message (ChatItemKind_Message) = 0, Conversation (ChatItemKind_Conversation) = 1,
}}
DEFINE_IID!(IID_IChatMessage, 1262028074, 4418, 20617, 118, 218, 242, 219, 61, 23, 205, 5);
RT_INTERFACE!{interface IChatMessage(IChatMessageVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessage] {
    fn get_Attachments(&self, out: *mut *mut super::super::foundation::collections::IVector<ChatMessageAttachment>) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Body(&self, value: HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsForwardingDisabled(&self, out: *mut bool) -> HRESULT,
    fn get_IsIncoming(&self, out: *mut bool) -> HRESULT,
    fn get_IsRead(&self, out: *mut bool) -> HRESULT,
    fn get_LocalTimestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_NetworkTimestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_Recipients(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_RecipientSendStatuses(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, ChatMessageStatus>) -> HRESULT,
    fn get_Status(&self, out: *mut ChatMessageStatus) -> HRESULT,
    fn get_Subject(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TransportFriendlyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TransportId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_TransportId(&self, value: HSTRING) -> HRESULT
}}
impl IChatMessage {
    #[inline] pub unsafe fn get_attachments(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ChatMessageAttachment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Attachments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_body(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Body)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_forwarding_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsForwardingDisabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_incoming(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsIncoming)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_read(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRead)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_local_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocalTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_network_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NetworkTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recipients(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Recipients)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recipient_send_statuses(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, ChatMessageStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecipientSendStatuses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<ChatMessageStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subject(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subject)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_friendly_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportFriendlyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_transport_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TransportId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessage: IChatMessage}
impl RtActivatable<IActivationFactory> for ChatMessage {}
DEFINE_CLSID!(ChatMessage(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,77,101,115,115,97,103,101,0]) [CLSID_ChatMessage]);
DEFINE_IID!(IID_IChatMessage2, 2254865202, 21567, 18933, 172, 113, 108, 42, 252, 101, 101, 253);
RT_INTERFACE!{interface IChatMessage2(IChatMessage2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessage2] {
    fn get_EstimatedDownloadSize(&self, out: *mut u64) -> HRESULT,
    fn put_EstimatedDownloadSize(&self, value: u64) -> HRESULT,
    fn put_From(&self, value: HSTRING) -> HRESULT,
    fn get_IsAutoReply(&self, out: *mut bool) -> HRESULT,
    fn put_IsAutoReply(&self, value: bool) -> HRESULT,
    fn put_IsForwardingDisabled(&self, value: bool) -> HRESULT,
    fn get_IsReplyDisabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsIncoming(&self, value: bool) -> HRESULT,
    fn put_IsRead(&self, value: bool) -> HRESULT,
    fn get_IsSeen(&self, out: *mut bool) -> HRESULT,
    fn put_IsSeen(&self, value: bool) -> HRESULT,
    fn get_IsSimMessage(&self, out: *mut bool) -> HRESULT,
    fn put_LocalTimestamp(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_MessageKind(&self, out: *mut ChatMessageKind) -> HRESULT,
    fn put_MessageKind(&self, value: ChatMessageKind) -> HRESULT,
    fn get_MessageOperatorKind(&self, out: *mut ChatMessageOperatorKind) -> HRESULT,
    fn put_MessageOperatorKind(&self, value: ChatMessageOperatorKind) -> HRESULT,
    fn put_NetworkTimestamp(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_IsReceivedDuringQuietHours(&self, out: *mut bool) -> HRESULT,
    fn put_IsReceivedDuringQuietHours(&self, value: bool) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    fn put_Status(&self, value: ChatMessageStatus) -> HRESULT,
    fn put_Subject(&self, value: HSTRING) -> HRESULT,
    fn get_ShouldSuppressNotification(&self, out: *mut bool) -> HRESULT,
    fn put_ShouldSuppressNotification(&self, value: bool) -> HRESULT,
    fn get_ThreadingInfo(&self, out: *mut *mut ChatConversationThreadingInfo) -> HRESULT,
    fn put_ThreadingInfo(&self, value: *mut ChatConversationThreadingInfo) -> HRESULT,
    fn get_RecipientsDeliveryInfos(&self, out: *mut *mut super::super::foundation::collections::IVector<ChatRecipientDeliveryInfo>) -> HRESULT
}}
impl IChatMessage2 {
    #[inline] pub unsafe fn get_estimated_download_size(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EstimatedDownloadSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_estimated_download_size(&self, value: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EstimatedDownloadSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_from(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_From)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_auto_reply(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAutoReply)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_auto_reply(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAutoReply)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_forwarding_disabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsForwardingDisabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_reply_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsReplyDisabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_incoming(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsIncoming)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_read(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsRead)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_seen(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSeen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_seen(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSeen)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_sim_message(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSimMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_local_timestamp(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LocalTimestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_kind(&self) -> Result<ChatMessageKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_message_kind(&self, value: ChatMessageKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MessageKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_operator_kind(&self) -> Result<ChatMessageOperatorKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageOperatorKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_message_operator_kind(&self, value: ChatMessageOperatorKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MessageOperatorKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_network_timestamp(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_NetworkTimestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_received_during_quiet_hours(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsReceivedDuringQuietHours)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_received_during_quiet_hours(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsReceivedDuringQuietHours)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_status(&self, value: ChatMessageStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Status)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subject(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Subject)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_suppress_notification(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldSuppressNotification)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_should_suppress_notification(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShouldSuppressNotification)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_threading_info(&self) -> Result<ComPtr<ChatConversationThreadingInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ThreadingInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_threading_info(&self, value: &ChatConversationThreadingInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ThreadingInfo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recipients_delivery_infos(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ChatRecipientDeliveryInfo>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecipientsDeliveryInfos)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessage3, 1961570224, 15271, 17823, 142, 11, 232, 175, 15, 235, 217, 173);
RT_INTERFACE!{interface IChatMessage3(IChatMessage3Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessage3] {
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IChatMessage3 {
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessage4, 756304655, 53951, 17932, 170, 104, 109, 63, 132, 131, 201, 191);
RT_INTERFACE!{interface IChatMessage4(IChatMessage4Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessage4] {
    fn get_SyncId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SyncId(&self, value: HSTRING) -> HRESULT
}}
impl IChatMessage4 {
    #[inline] pub unsafe fn get_sync_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SyncId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sync_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SyncId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageAttachment, 3351575924, 48995, 22763, 80, 140, 139, 134, 63, 241, 107, 103);
RT_INTERFACE!{interface IChatMessageAttachment(IChatMessageAttachmentVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageAttachment] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_DataStreamReference(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_DataStreamReference(&self, value: *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn get_GroupId(&self, out: *mut u32) -> HRESULT,
    fn put_GroupId(&self, value: u32) -> HRESULT,
    fn get_MimeType(&self, out: *mut HSTRING) -> HRESULT,
    fn put_MimeType(&self, value: HSTRING) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT
}}
impl IChatMessageAttachment {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_data_stream_reference(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataStreamReference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_data_stream_reference(&self, value: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataStreamReference)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_group_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GroupId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_group_id(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_GroupId)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mime_type(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MimeType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mime_type(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MimeType)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageAttachment: IChatMessageAttachment}
impl RtActivatable<IChatMessageAttachmentFactory> for ChatMessageAttachment {}
impl ChatMessageAttachment {
    #[cfg(feature="windows-storage")] #[inline] pub fn create_chat_message_attachment(mimeType: &HStringArg, dataStreamReference: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<ComPtr<ChatMessageAttachment>> { unsafe {
        <Self as RtActivatable<IChatMessageAttachmentFactory>>::get_activation_factory().create_chat_message_attachment(mimeType, dataStreamReference)
    }}
}
DEFINE_CLSID!(ChatMessageAttachment(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,77,101,115,115,97,103,101,65,116,116,97,99,104,109,101,110,116,0]) [CLSID_ChatMessageAttachment]);
DEFINE_IID!(IID_IChatMessageAttachment2, 1591317104, 32209, 19079, 168, 206, 172, 221, 135, 216, 13, 200);
RT_INTERFACE!{interface IChatMessageAttachment2(IChatMessageAttachment2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageAttachment2] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Thumbnail(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_Thumbnail(&self, value: *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn get_TransferProgress(&self, out: *mut f64) -> HRESULT,
    fn put_TransferProgress(&self, value: f64) -> HRESULT,
    fn get_OriginalFileName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_OriginalFileName(&self, value: HSTRING) -> HRESULT
}}
impl IChatMessageAttachment2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_thumbnail(&self, value: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Thumbnail)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transfer_progress(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TransferProgress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_transfer_progress(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TransferProgress)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_original_file_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OriginalFileName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_original_file_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OriginalFileName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageAttachmentFactory, 542659234, 41814, 23409, 108, 169, 102, 201, 133, 183, 208, 213);
RT_INTERFACE!{static interface IChatMessageAttachmentFactory(IChatMessageAttachmentFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageAttachmentFactory] {
    #[cfg(feature="windows-storage")] fn CreateChatMessageAttachment(&self, mimeType: HSTRING, dataStreamReference: *mut super::super::storage::streams::IRandomAccessStreamReference, out: *mut *mut ChatMessageAttachment) -> HRESULT
}}
impl IChatMessageAttachmentFactory {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_chat_message_attachment(&self, mimeType: &HStringArg, dataStreamReference: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<ComPtr<ChatMessageAttachment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateChatMessageAttachment)(self as *const _ as *mut _, mimeType.get(), dataStreamReference as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class ChatMessageBlocking}
impl RtActivatable<IChatMessageBlockingStatic> for ChatMessageBlocking {}
impl ChatMessageBlocking {
    #[inline] pub fn mark_message_as_blocked_async(localChatMessageId: &HStringArg, blocked: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IChatMessageBlockingStatic>>::get_activation_factory().mark_message_as_blocked_async(localChatMessageId, blocked)
    }}
}
DEFINE_CLSID!(ChatMessageBlocking(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,77,101,115,115,97,103,101,66,108,111,99,107,105,110,103,0]) [CLSID_ChatMessageBlocking]);
DEFINE_IID!(IID_IChatMessageBlockingStatic, 4139361152, 52714, 4580, 136, 48, 8, 0, 32, 12, 154, 102);
RT_INTERFACE!{static interface IChatMessageBlockingStatic(IChatMessageBlockingStaticVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageBlockingStatic] {
    fn MarkMessageAsBlockedAsync(&self, localChatMessageId: HSTRING, blocked: bool, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IChatMessageBlockingStatic {
    #[inline] pub unsafe fn mark_message_as_blocked_async(&self, localChatMessageId: &HStringArg, blocked: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkMessageAsBlockedAsync)(self as *const _ as *mut _, localChatMessageId.get(), blocked, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageChange, 471384917, 16926, 21688, 109, 56, 107, 58, 108, 130, 252, 204);
RT_INTERFACE!{interface IChatMessageChange(IChatMessageChangeVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageChange] {
    fn get_ChangeType(&self, out: *mut ChatMessageChangeType) -> HRESULT,
    fn get_Message(&self, out: *mut *mut ChatMessage) -> HRESULT
}}
impl IChatMessageChange {
    #[inline] pub unsafe fn get_change_type(&self) -> Result<ChatMessageChangeType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChangeType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message(&self) -> Result<ComPtr<ChatMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageChange: IChatMessageChange}
DEFINE_IID!(IID_IChatMessageChangedDeferral, 4224103180, 30860, 19916, 172, 231, 98, 130, 56, 41, 104, 207);
RT_INTERFACE!{interface IChatMessageChangedDeferral(IChatMessageChangedDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageChangedDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IChatMessageChangedDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageChangedDeferral: IChatMessageChangedDeferral}
DEFINE_IID!(IID_IChatMessageChangedEventArgs, 3065462317, 26908, 20191, 134, 96, 110, 185, 137, 104, 146, 227);
RT_INTERFACE!{interface IChatMessageChangedEventArgs(IChatMessageChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageChangedEventArgs] {
    fn GetDeferral(&self, out: *mut *mut ChatMessageChangedDeferral) -> HRESULT
}}
impl IChatMessageChangedEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<ChatMessageChangedDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageChangedEventArgs: IChatMessageChangedEventArgs}
DEFINE_IID!(IID_IChatMessageChangeReader, 338063392, 10446, 24358, 123, 5, 154, 92, 124, 206, 135, 202);
RT_INTERFACE!{interface IChatMessageChangeReader(IChatMessageChangeReaderVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageChangeReader] {
    fn AcceptChanges(&self) -> HRESULT,
    fn AcceptChangesThrough(&self, lastChangeToAcknowledge: *mut ChatMessageChange) -> HRESULT,
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessageChange>>) -> HRESULT
}}
impl IChatMessageChangeReader {
    #[inline] pub unsafe fn accept_changes(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptChanges)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept_changes_through(&self, lastChangeToAcknowledge: &ChatMessageChange) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptChangesThrough)(self as *const _ as *mut _, lastChangeToAcknowledge as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessageChange>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageChangeReader: IChatMessageChangeReader}
DEFINE_IID!(IID_IChatMessageChangeTracker, 1622667366, 28832, 21028, 80, 140, 36, 46, 247, 193, 208, 111);
RT_INTERFACE!{interface IChatMessageChangeTracker(IChatMessageChangeTrackerVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageChangeTracker] {
    fn Enable(&self) -> HRESULT,
    fn GetChangeReader(&self, out: *mut *mut ChatMessageChangeReader) -> HRESULT,
    fn Reset(&self) -> HRESULT
}}
impl IChatMessageChangeTracker {
    #[inline] pub unsafe fn enable(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Enable)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_change_reader(&self) -> Result<ComPtr<ChatMessageChangeReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChangeReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Reset)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageChangeTracker: IChatMessageChangeTracker}
RT_ENUM! { enum ChatMessageChangeType: i32 {
    MessageCreated (ChatMessageChangeType_MessageCreated) = 0, MessageModified (ChatMessageChangeType_MessageModified) = 1, MessageDeleted (ChatMessageChangeType_MessageDeleted) = 2, ChangeTrackingLost (ChatMessageChangeType_ChangeTrackingLost) = 3,
}}
RT_ENUM! { enum ChatMessageKind: i32 {
    Standard (ChatMessageKind_Standard) = 0, FileTransferRequest (ChatMessageKind_FileTransferRequest) = 1, TransportCustom (ChatMessageKind_TransportCustom) = 2, JoinedConversation (ChatMessageKind_JoinedConversation) = 3, LeftConversation (ChatMessageKind_LeftConversation) = 4, OtherParticipantJoinedConversation (ChatMessageKind_OtherParticipantJoinedConversation) = 5, OtherParticipantLeftConversation (ChatMessageKind_OtherParticipantLeftConversation) = 6,
}}
RT_CLASS!{static class ChatMessageManager}
impl RtActivatable<IChatMessageManager2Statics> for ChatMessageManager {}
impl RtActivatable<IChatMessageManagerStatic> for ChatMessageManager {}
impl RtActivatable<IChatMessageManagerStatics3> for ChatMessageManager {}
impl ChatMessageManager {
    #[inline] pub fn register_transport_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<IChatMessageManager2Statics>>::get_activation_factory().register_transport_async()
    }}
    #[inline] pub fn get_transport_async(transportId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessageTransport>>> { unsafe {
        <Self as RtActivatable<IChatMessageManager2Statics>>::get_activation_factory().get_transport_async(transportId)
    }}
    #[inline] pub fn get_transports_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessageTransport>>>> { unsafe {
        <Self as RtActivatable<IChatMessageManagerStatic>>::get_activation_factory().get_transports_async()
    }}
    #[inline] pub fn request_store_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessageStore>>> { unsafe {
        <Self as RtActivatable<IChatMessageManagerStatic>>::get_activation_factory().request_store_async()
    }}
    #[inline] pub fn show_compose_sms_message_async(message: &ChatMessage) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IChatMessageManagerStatic>>::get_activation_factory().show_compose_sms_message_async(message)
    }}
    #[inline] pub fn show_sms_settings() -> Result<()> { unsafe {
        <Self as RtActivatable<IChatMessageManagerStatic>>::get_activation_factory().show_sms_settings()
    }}
    #[inline] pub fn request_sync_manager_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatSyncManager>>> { unsafe {
        <Self as RtActivatable<IChatMessageManagerStatics3>>::get_activation_factory().request_sync_manager_async()
    }}
}
DEFINE_CLSID!(ChatMessageManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,77,101,115,115,97,103,101,77,97,110,97,103,101,114,0]) [CLSID_ChatMessageManager]);
DEFINE_IID!(IID_IChatMessageManager2Statics, 491075855, 40783, 20021, 150, 78, 27, 156, 166, 26, 192, 68);
RT_INTERFACE!{static interface IChatMessageManager2Statics(IChatMessageManager2StaticsVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageManager2Statics] {
    fn RegisterTransportAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn GetTransportAsync(&self, transportId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatMessageTransport>) -> HRESULT
}}
impl IChatMessageManager2Statics {
    #[inline] pub unsafe fn register_transport_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RegisterTransportAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_async(&self, transportId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessageTransport>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTransportAsync)(self as *const _ as *mut _, transportId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageManagerStatic, 4049363191, 54760, 24210, 85, 109, 224, 59, 96, 37, 49, 4);
RT_INTERFACE!{static interface IChatMessageManagerStatic(IChatMessageManagerStaticVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageManagerStatic] {
    fn GetTransportsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessageTransport>>) -> HRESULT,
    fn RequestStoreAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ChatMessageStore>) -> HRESULT,
    fn ShowComposeSmsMessageAsync(&self, message: *mut ChatMessage, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowSmsSettings(&self) -> HRESULT
}}
impl IChatMessageManagerStatic {
    #[inline] pub unsafe fn get_transports_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessageTransport>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTransportsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_store_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessageStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_compose_sms_message_async(&self, message: &ChatMessage) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowComposeSmsMessageAsync)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_sms_settings(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowSmsSettings)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageManagerStatics3, 546013965, 26453, 18636, 154, 179, 253, 3, 196, 99, 252, 146);
RT_INTERFACE!{static interface IChatMessageManagerStatics3(IChatMessageManagerStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageManagerStatics3] {
    fn RequestSyncManagerAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ChatSyncManager>) -> HRESULT
}}
impl IChatMessageManagerStatics3 {
    #[inline] pub unsafe fn request_sync_manager_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatSyncManager>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestSyncManagerAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageNotificationTriggerDetails, 4248063483, 12387, 19991, 133, 134, 198, 192, 130, 98, 230, 192);
RT_INTERFACE!{interface IChatMessageNotificationTriggerDetails(IChatMessageNotificationTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageNotificationTriggerDetails] {
    fn get_ChatMessage(&self, out: *mut *mut ChatMessage) -> HRESULT
}}
impl IChatMessageNotificationTriggerDetails {
    #[inline] pub unsafe fn get_chat_message(&self) -> Result<ComPtr<ChatMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChatMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageNotificationTriggerDetails: IChatMessageNotificationTriggerDetails}
DEFINE_IID!(IID_IChatMessageNotificationTriggerDetails2, 1807033056, 43527, 20433, 148, 113, 119, 147, 79, 183, 94, 230);
RT_INTERFACE!{interface IChatMessageNotificationTriggerDetails2(IChatMessageNotificationTriggerDetails2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageNotificationTriggerDetails2] {
    fn get_ShouldDisplayToast(&self, out: *mut bool) -> HRESULT,
    fn get_ShouldUpdateDetailText(&self, out: *mut bool) -> HRESULT,
    fn get_ShouldUpdateBadge(&self, out: *mut bool) -> HRESULT,
    fn get_ShouldUpdateActionCenter(&self, out: *mut bool) -> HRESULT
}}
impl IChatMessageNotificationTriggerDetails2 {
    #[inline] pub unsafe fn get_should_display_toast(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldDisplayToast)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_update_detail_text(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldUpdateDetailText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_update_badge(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldUpdateBadge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_update_action_center(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldUpdateActionCenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum ChatMessageOperatorKind: i32 {
    Unspecified (ChatMessageOperatorKind_Unspecified) = 0, Sms (ChatMessageOperatorKind_Sms) = 1, Mms (ChatMessageOperatorKind_Mms) = 2, Rcs (ChatMessageOperatorKind_Rcs) = 3,
}}
DEFINE_IID!(IID_IChatMessageReader, 3068819662, 17545, 22265, 118, 170, 226, 4, 104, 37, 20, 207);
RT_INTERFACE!{interface IChatMessageReader(IChatMessageReaderVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageReader] {
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessage>>) -> HRESULT
}}
impl IChatMessageReader {
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessage>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageReader: IChatMessageReader}
DEFINE_IID!(IID_IChatMessageReader2, 2305046147, 25787, 18189, 157, 244, 13, 232, 190, 26, 5, 191);
RT_INTERFACE!{interface IChatMessageReader2(IChatMessageReader2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageReader2] {
    fn ReadBatchWithCountAsync(&self, count: i32, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessage>>) -> HRESULT
}}
impl IChatMessageReader2 {
    #[inline] pub unsafe fn read_batch_with_count_async(&self, count: i32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ChatMessage>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchWithCountAsync)(self as *const _ as *mut _, count, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ChatMessageStatus: i32 {
    Draft (ChatMessageStatus_Draft) = 0, Sending (ChatMessageStatus_Sending) = 1, Sent (ChatMessageStatus_Sent) = 2, SendRetryNeeded (ChatMessageStatus_SendRetryNeeded) = 3, SendFailed (ChatMessageStatus_SendFailed) = 4, Received (ChatMessageStatus_Received) = 5, ReceiveDownloadNeeded (ChatMessageStatus_ReceiveDownloadNeeded) = 6, ReceiveDownloadFailed (ChatMessageStatus_ReceiveDownloadFailed) = 7, ReceiveDownloading (ChatMessageStatus_ReceiveDownloading) = 8, Deleted (ChatMessageStatus_Deleted) = 9, Declined (ChatMessageStatus_Declined) = 10, Cancelled (ChatMessageStatus_Cancelled) = 11, Recalled (ChatMessageStatus_Recalled) = 12, ReceiveRetryNeeded (ChatMessageStatus_ReceiveRetryNeeded) = 13,
}}
DEFINE_IID!(IID_IChatMessageStore, 838008065, 52470, 22539, 73, 118, 10, 7, 221, 93, 59, 71);
RT_INTERFACE!{interface IChatMessageStore(IChatMessageStoreVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageStore] {
    fn get_ChangeTracker(&self, out: *mut *mut ChatMessageChangeTracker) -> HRESULT,
    fn DeleteMessageAsync(&self, localMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DownloadMessageAsync(&self, localChatMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetMessageAsync(&self, localChatMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatMessage>) -> HRESULT,
    fn GetMessageReader1(&self, out: *mut *mut ChatMessageReader) -> HRESULT,
    fn GetMessageReader2(&self, recentTimeLimit: super::super::foundation::TimeSpan, out: *mut *mut ChatMessageReader) -> HRESULT,
    fn MarkMessageReadAsync(&self, localChatMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn RetrySendMessageAsync(&self, localChatMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SendMessageAsync(&self, chatMessage: *mut ChatMessage, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ValidateMessage(&self, chatMessage: *mut ChatMessage, out: *mut *mut ChatMessageValidationResult) -> HRESULT,
    fn add_MessageChanged(&self, value: *mut super::super::foundation::TypedEventHandler<ChatMessageStore, ChatMessageChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MessageChanged(&self, value: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IChatMessageStore {
    #[inline] pub unsafe fn get_change_tracker(&self) -> Result<ComPtr<ChatMessageChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChangeTracker)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_message_async(&self, localMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteMessageAsync)(self as *const _ as *mut _, localMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn download_message_async(&self, localChatMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DownloadMessageAsync)(self as *const _ as *mut _, localChatMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_async(&self, localChatMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessage>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageAsync)(self as *const _ as *mut _, localChatMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_reader1(&self) -> Result<ComPtr<ChatMessageReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageReader1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_reader2(&self, recentTimeLimit: super::super::foundation::TimeSpan) -> Result<ComPtr<ChatMessageReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageReader2)(self as *const _ as *mut _, recentTimeLimit, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_message_read_async(&self, localChatMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkMessageReadAsync)(self as *const _ as *mut _, localChatMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn retry_send_message_async(&self, localChatMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RetrySendMessageAsync)(self as *const _ as *mut _, localChatMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn send_message_async(&self, chatMessage: &ChatMessage) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendMessageAsync)(self as *const _ as *mut _, chatMessage as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn validate_message(&self, chatMessage: &ChatMessage) -> Result<ComPtr<ChatMessageValidationResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ValidateMessage)(self as *const _ as *mut _, chatMessage as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_message_changed(&self, value: &super::super::foundation::TypedEventHandler<ChatMessageStore, ChatMessageChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MessageChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_message_changed(&self, value: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MessageChanged)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageStore: IChatMessageStore}
DEFINE_IID!(IID_IChatMessageStore2, 2907555054, 15060, 18715, 179, 17, 171, 223, 155, 178, 39, 104);
RT_INTERFACE!{interface IChatMessageStore2(IChatMessageStore2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageStore2] {
    fn ForwardMessageAsync(&self, localChatMessageId: HSTRING, addresses: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<ChatMessage>) -> HRESULT,
    fn GetConversationAsync(&self, conversationId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatConversation>) -> HRESULT,
    fn GetConversationForTransportsAsync(&self, conversationId: HSTRING, transportIds: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<ChatConversation>) -> HRESULT,
    fn GetConversationFromThreadingInfoAsync(&self, threadingInfo: *mut ChatConversationThreadingInfo, out: *mut *mut super::super::foundation::IAsyncOperation<ChatConversation>) -> HRESULT,
    fn GetConversationReader(&self, out: *mut *mut ChatConversationReader) -> HRESULT,
    fn GetConversationForTransportsReader(&self, transportIds: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut ChatConversationReader) -> HRESULT,
    fn GetMessageByRemoteIdAsync(&self, transportId: HSTRING, remoteId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatMessage>) -> HRESULT,
    fn GetUnseenCountAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<i32>) -> HRESULT,
    fn GetUnseenCountForTransportsReaderAsync(&self, transportIds: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<i32>) -> HRESULT,
    fn MarkAsSeenAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn MarkAsSeenForTransportsAsync(&self, transportIds: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetSearchReader(&self, value: *mut ChatQueryOptions, out: *mut *mut ChatSearchReader) -> HRESULT,
    fn SaveMessageAsync(&self, chatMessage: *mut ChatMessage, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn TryCancelDownloadMessageAsync(&self, localChatMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryCancelSendMessageAsync(&self, localChatMessageId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn add_StoreChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<ChatMessageStore, ChatMessageStoreChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StoreChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IChatMessageStore2 {
    #[inline] pub unsafe fn forward_message_async(&self, localChatMessageId: &HStringArg, addresses: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessage>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ForwardMessageAsync)(self as *const _ as *mut _, localChatMessageId.get(), addresses as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_conversation_async(&self, conversationId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatConversation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetConversationAsync)(self as *const _ as *mut _, conversationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_conversation_for_transports_async(&self, conversationId: &HStringArg, transportIds: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatConversation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetConversationForTransportsAsync)(self as *const _ as *mut _, conversationId.get(), transportIds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_conversation_from_threading_info_async(&self, threadingInfo: &ChatConversationThreadingInfo) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatConversation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetConversationFromThreadingInfoAsync)(self as *const _ as *mut _, threadingInfo as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_conversation_reader(&self) -> Result<ComPtr<ChatConversationReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetConversationReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_conversation_for_transports_reader(&self, transportIds: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<ChatConversationReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetConversationForTransportsReader)(self as *const _ as *mut _, transportIds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_by_remote_id_async(&self, transportId: &HStringArg, remoteId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessage>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageByRemoteIdAsync)(self as *const _ as *mut _, transportId.get(), remoteId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unseen_count_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetUnseenCountAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unseen_count_for_transports_reader_async(&self, transportIds: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetUnseenCountForTransportsReaderAsync)(self as *const _ as *mut _, transportIds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_as_seen_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkAsSeenAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn mark_as_seen_for_transports_async(&self, transportIds: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MarkAsSeenForTransportsAsync)(self as *const _ as *mut _, transportIds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_reader(&self, value: &ChatQueryOptions) -> Result<ComPtr<ChatSearchReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSearchReader)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_message_async(&self, chatMessage: &ChatMessage) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveMessageAsync)(self as *const _ as *mut _, chatMessage as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_cancel_download_message_async(&self, localChatMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCancelDownloadMessageAsync)(self as *const _ as *mut _, localChatMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_cancel_send_message_async(&self, localChatMessageId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCancelSendMessageAsync)(self as *const _ as *mut _, localChatMessageId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_store_changed(&self, handler: &super::super::foundation::TypedEventHandler<ChatMessageStore, ChatMessageStoreChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StoreChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_store_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StoreChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageStore3, 2598091529, 17221, 20161, 139, 116, 183, 51, 130, 67, 113, 156);
RT_INTERFACE!{interface IChatMessageStore3(IChatMessageStore3Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageStore3] {
    fn GetMessageBySyncIdAsync(&self, syncId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ChatMessage>) -> HRESULT
}}
impl IChatMessageStore3 {
    #[inline] pub unsafe fn get_message_by_sync_id_async(&self, syncId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ChatMessage>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageBySyncIdAsync)(self as *const _ as *mut _, syncId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageStoreChangedEventArgs, 1707503532, 65164, 18132, 145, 25, 87, 184, 65, 3, 17, 213);
RT_INTERFACE!{interface IChatMessageStoreChangedEventArgs(IChatMessageStoreChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageStoreChangedEventArgs] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Kind(&self, out: *mut ChatStoreChangedEventKind) -> HRESULT
}}
impl IChatMessageStoreChangedEventArgs {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<ChatStoreChangedEventKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageStoreChangedEventArgs: IChatMessageStoreChangedEventArgs}
DEFINE_IID!(IID_IChatMessageTransport, 1672076280, 59059, 23706, 95, 133, 212, 121, 37, 185, 189, 24);
RT_INTERFACE!{interface IChatMessageTransport(IChatMessageTransportVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageTransport] {
    fn get_IsAppSetAsNotificationProvider(&self, out: *mut bool) -> HRESULT,
    fn get_IsActive(&self, out: *mut bool) -> HRESULT,
    fn get_TransportFriendlyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TransportId(&self, out: *mut HSTRING) -> HRESULT,
    fn RequestSetAsNotificationProviderAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IChatMessageTransport {
    #[inline] pub unsafe fn get_is_app_set_as_notification_provider(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAppSetAsNotificationProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_active(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsActive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_friendly_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportFriendlyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_set_as_notification_provider_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestSetAsNotificationProviderAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageTransport: IChatMessageTransport}
DEFINE_IID!(IID_IChatMessageTransport2, 2426885666, 55370, 19490, 169, 77, 84, 68, 68, 237, 200, 161);
RT_INTERFACE!{interface IChatMessageTransport2(IChatMessageTransport2Vtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageTransport2] {
    fn get_Configuration(&self, out: *mut *mut ChatMessageTransportConfiguration) -> HRESULT,
    fn get_TransportKind(&self, out: *mut ChatMessageTransportKind) -> HRESULT
}}
impl IChatMessageTransport2 {
    #[inline] pub unsafe fn get_configuration(&self) -> Result<ComPtr<ChatMessageTransportConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Configuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_kind(&self) -> Result<ChatMessageTransportKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TransportKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChatMessageTransportConfiguration, 2275407653, 6664, 19146, 160, 117, 51, 85, 18, 99, 18, 230);
RT_INTERFACE!{interface IChatMessageTransportConfiguration(IChatMessageTransportConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageTransportConfiguration] {
    fn get_MaxAttachmentCount(&self, out: *mut i32) -> HRESULT,
    fn get_MaxMessageSizeInKilobytes(&self, out: *mut i32) -> HRESULT,
    fn get_MaxRecipientCount(&self, out: *mut i32) -> HRESULT,
    #[cfg(not(feature="windows-media"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-media")] fn get_SupportedVideoFormat(&self, out: *mut *mut super::super::media::mediaproperties::MediaEncodingProfile) -> HRESULT,
    fn get_ExtendedProperties(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT
}}
impl IChatMessageTransportConfiguration {
    #[inline] pub unsafe fn get_max_attachment_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxAttachmentCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_message_size_in_kilobytes(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxMessageSizeInKilobytes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_recipient_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxRecipientCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-media")] #[inline] pub unsafe fn get_supported_video_format(&self) -> Result<ComPtr<super::super::media::mediaproperties::MediaEncodingProfile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedVideoFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExtendedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageTransportConfiguration: IChatMessageTransportConfiguration}
RT_ENUM! { enum ChatMessageTransportKind: i32 {
    Text (ChatMessageTransportKind_Text) = 0, Untriaged (ChatMessageTransportKind_Untriaged) = 1, Blocked (ChatMessageTransportKind_Blocked) = 2, Custom (ChatMessageTransportKind_Custom) = 3,
}}
DEFINE_IID!(IID_IChatMessageValidationResult, 636041731, 10476, 22665, 86, 155, 126, 72, 107, 18, 111, 24);
RT_INTERFACE!{interface IChatMessageValidationResult(IChatMessageValidationResultVtbl): IInspectable(IInspectableVtbl) [IID_IChatMessageValidationResult] {
    fn get_MaxPartCount(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_PartCount(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_RemainingCharacterCountInPart(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Status(&self, out: *mut ChatMessageValidationStatus) -> HRESULT
}}
impl IChatMessageValidationResult {
    #[inline] pub unsafe fn get_max_part_count(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxPartCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_part_count(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PartCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remaining_character_count_in_part(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemainingCharacterCountInPart)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<ChatMessageValidationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ChatMessageValidationResult: IChatMessageValidationResult}
RT_ENUM! { enum ChatMessageValidationStatus: i32 {
    Valid (ChatMessageValidationStatus_Valid) = 0, NoRecipients (ChatMessageValidationStatus_NoRecipients) = 1, InvalidData (ChatMessageValidationStatus_InvalidData) = 2, MessageTooLarge (ChatMessageValidationStatus_MessageTooLarge) = 3, TooManyRecipients (ChatMessageValidationStatus_TooManyRecipients) = 4, TransportInactive (ChatMessageValidationStatus_TransportInactive) = 5, TransportNotFound (ChatMessageValidationStatus_TransportNotFound) = 6, TooManyAttachments (ChatMessageValidationStatus_TooManyAttachments) = 7, InvalidRecipients (ChatMessageValidationStatus_InvalidRecipients) = 8, InvalidBody (ChatMessageValidationStatus_InvalidBody) = 9, InvalidOther (ChatMessageValidationStatus_InvalidOther) = 10, ValidWithLargeMessage (ChatMessageValidationStatus_ValidWithLargeMessage) = 11, VoiceRoamingRestriction (ChatMessageValidationStatus_VoiceRoamingRestriction) = 12, DataRoamingRestriction (ChatMessageValidationStatus_DataRoamingRestriction) = 13,
}}
DEFINE_IID!(IID_IChatQueryOptions, 802383014, 48950, 17143, 183, 231, 146, 60, 10, 171, 254, 22);
RT_INTERFACE!{interface IChatQueryOptions(IChatQueryOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IChatQueryOptions] {
    fn get_SearchString(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SearchString(&self, value: HSTRING) -> HRESULT
}}
impl IChatQueryOptions {
    #[inline] pub unsafe fn get_search_string(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SearchString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_search_string(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SearchString)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatQueryOptions: IChatQueryOptions}
impl RtActivatable<IActivationFactory> for ChatQueryOptions {}
DEFINE_CLSID!(ChatQueryOptions(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,81,117,101,114,121,79,112,116,105,111,110,115,0]) [CLSID_ChatQueryOptions]);
DEFINE_IID!(IID_IChatRecipientDeliveryInfo, 4291277474, 10300, 19466, 138, 14, 140, 51, 189, 191, 5, 69);
RT_INTERFACE!{interface IChatRecipientDeliveryInfo(IChatRecipientDeliveryInfoVtbl): IInspectable(IInspectableVtbl) [IID_IChatRecipientDeliveryInfo] {
    fn get_TransportAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn put_TransportAddress(&self, value: HSTRING) -> HRESULT,
    fn get_DeliveryTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_DeliveryTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_ReadTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_ReadTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_TransportErrorCodeCategory(&self, out: *mut ChatTransportErrorCodeCategory) -> HRESULT,
    fn get_TransportInterpretedErrorCode(&self, out: *mut ChatTransportInterpretedErrorCode) -> HRESULT,
    fn get_TransportErrorCode(&self, out: *mut i32) -> HRESULT,
    fn get_IsErrorPermanent(&self, out: *mut bool) -> HRESULT,
    fn get_Status(&self, out: *mut ChatMessageStatus) -> HRESULT
}}
impl IChatRecipientDeliveryInfo {
    #[inline] pub unsafe fn get_transport_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_transport_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TransportAddress)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delivery_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeliveryTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_delivery_time(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DeliveryTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_read_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ReadTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_read_time(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReadTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_error_code_category(&self) -> Result<ChatTransportErrorCodeCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TransportErrorCodeCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_interpreted_error_code(&self) -> Result<ChatTransportInterpretedErrorCode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TransportInterpretedErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_error_code(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TransportErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_error_permanent(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsErrorPermanent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<ChatMessageStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ChatRecipientDeliveryInfo: IChatRecipientDeliveryInfo}
impl RtActivatable<IActivationFactory> for ChatRecipientDeliveryInfo {}
DEFINE_CLSID!(ChatRecipientDeliveryInfo(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,67,104,97,116,82,101,99,105,112,105,101,110,116,68,101,108,105,118,101,114,121,73,110,102,111,0]) [CLSID_ChatRecipientDeliveryInfo]);
RT_ENUM! { enum ChatRestoreHistorySpan: i32 {
    LastMonth (ChatRestoreHistorySpan_LastMonth) = 0, LastYear (ChatRestoreHistorySpan_LastYear) = 1, AnyTime (ChatRestoreHistorySpan_AnyTime) = 2,
}}
DEFINE_IID!(IID_IChatSearchReader, 1181089353, 36896, 18258, 152, 13, 57, 97, 35, 37, 245, 137);
RT_INTERFACE!{interface IChatSearchReader(IChatSearchReaderVtbl): IInspectable(IInspectableVtbl) [IID_IChatSearchReader] {
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<IChatItem>>) -> HRESULT,
    fn ReadBatchWithCountAsync(&self, count: i32, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<IChatItem>>) -> HRESULT
}}
impl IChatSearchReader {
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<IChatItem>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_batch_with_count_async(&self, count: i32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<IChatItem>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchWithCountAsync)(self as *const _ as *mut _, count, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatSearchReader: IChatSearchReader}
RT_ENUM! { enum ChatStoreChangedEventKind: i32 {
    NotificationsMissed (ChatStoreChangedEventKind_NotificationsMissed) = 0, StoreModified (ChatStoreChangedEventKind_StoreModified) = 1, MessageCreated (ChatStoreChangedEventKind_MessageCreated) = 2, MessageModified (ChatStoreChangedEventKind_MessageModified) = 3, MessageDeleted (ChatStoreChangedEventKind_MessageDeleted) = 4, ConversationModified (ChatStoreChangedEventKind_ConversationModified) = 5, ConversationDeleted (ChatStoreChangedEventKind_ConversationDeleted) = 6, ConversationTransportDeleted (ChatStoreChangedEventKind_ConversationTransportDeleted) = 7,
}}
DEFINE_IID!(IID_IChatSyncConfiguration, 167274930, 27124, 19199, 130, 182, 6, 153, 47, 244, 2, 210);
RT_INTERFACE!{interface IChatSyncConfiguration(IChatSyncConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IChatSyncConfiguration] {
    fn get_IsSyncEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsSyncEnabled(&self, value: bool) -> HRESULT,
    fn get_RestoreHistorySpan(&self, out: *mut ChatRestoreHistorySpan) -> HRESULT,
    fn put_RestoreHistorySpan(&self, value: ChatRestoreHistorySpan) -> HRESULT
}}
impl IChatSyncConfiguration {
    #[inline] pub unsafe fn get_is_sync_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSyncEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_sync_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSyncEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_restore_history_span(&self) -> Result<ChatRestoreHistorySpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RestoreHistorySpan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_restore_history_span(&self, value: ChatRestoreHistorySpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RestoreHistorySpan)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChatSyncConfiguration: IChatSyncConfiguration}
DEFINE_IID!(IID_IChatSyncManager, 2074422371, 9808, 18543, 180, 180, 107, 217, 211, 214, 60, 132);
RT_INTERFACE!{interface IChatSyncManager(IChatSyncManagerVtbl): IInspectable(IInspectableVtbl) [IID_IChatSyncManager] {
    fn get_Configuration(&self, out: *mut *mut ChatSyncConfiguration) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-security")] fn AssociateAccountAsync(&self, webAccount: *mut super::super::security::credentials::WebAccount, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn UnassociateAccountAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-security")] fn IsAccountAssociated(&self, webAccount: *mut super::super::security::credentials::WebAccount, out: *mut bool) -> HRESULT,
    fn StartSync(&self) -> HRESULT,
    fn SetConfigurationAsync(&self, configuration: *mut ChatSyncConfiguration, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IChatSyncManager {
    #[inline] pub unsafe fn get_configuration(&self) -> Result<ComPtr<ChatSyncConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Configuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn associate_account_async(&self, webAccount: &super::super::security::credentials::WebAccount) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AssociateAccountAsync)(self as *const _ as *mut _, webAccount as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn unassociate_account_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UnassociateAccountAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn is_account_associated(&self, webAccount: &super::super::security::credentials::WebAccount) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsAccountAssociated)(self as *const _ as *mut _, webAccount as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_sync(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StartSync)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_configuration_async(&self, configuration: &ChatSyncConfiguration) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetConfigurationAsync)(self as *const _ as *mut _, configuration as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChatSyncManager: IChatSyncManager}
RT_ENUM! { enum ChatTransportErrorCodeCategory: i32 {
    None (ChatTransportErrorCodeCategory_None) = 0, Http (ChatTransportErrorCodeCategory_Http) = 1, Network (ChatTransportErrorCodeCategory_Network) = 2, MmsServer (ChatTransportErrorCodeCategory_MmsServer) = 3,
}}
RT_ENUM! { enum ChatTransportInterpretedErrorCode: i32 {
    None (ChatTransportInterpretedErrorCode_None) = 0, Unknown (ChatTransportInterpretedErrorCode_Unknown) = 1, InvalidRecipientAddress (ChatTransportInterpretedErrorCode_InvalidRecipientAddress) = 2, NetworkConnectivity (ChatTransportInterpretedErrorCode_NetworkConnectivity) = 3, ServiceDenied (ChatTransportInterpretedErrorCode_ServiceDenied) = 4, Timeout (ChatTransportInterpretedErrorCode_Timeout) = 5,
}}
DEFINE_IID!(IID_IRcsEndUserMessage, 3620578795, 52183, 20283, 133, 38, 181, 6, 222, 195, 92, 83);
RT_INTERFACE!{interface IRcsEndUserMessage(IRcsEndUserMessageVtbl): IInspectable(IInspectableVtbl) [IID_IRcsEndUserMessage] {
    fn get_TransportId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsPinRequired(&self, out: *mut bool) -> HRESULT,
    fn get_Actions(&self, out: *mut *mut super::super::foundation::collections::IVectorView<RcsEndUserMessageAction>) -> HRESULT,
    fn SendResponseAsync(&self, action: *mut RcsEndUserMessageAction, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SendResponseWithPinAsync(&self, action: *mut RcsEndUserMessageAction, pin: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IRcsEndUserMessage {
    #[inline] pub unsafe fn get_transport_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_pin_required(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPinRequired)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actions(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<RcsEndUserMessageAction>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Actions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn send_response_async(&self, action: &RcsEndUserMessageAction) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendResponseAsync)(self as *const _ as *mut _, action as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn send_response_with_pin_async(&self, action: &RcsEndUserMessageAction, pin: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendResponseWithPinAsync)(self as *const _ as *mut _, action as *const _ as *mut _, pin.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RcsEndUserMessage: IRcsEndUserMessage}
DEFINE_IID!(IID_IRcsEndUserMessageAction, 2453112631, 39746, 18131, 157, 94, 60, 27, 45, 174, 124, 184);
RT_INTERFACE!{interface IRcsEndUserMessageAction(IRcsEndUserMessageActionVtbl): IInspectable(IInspectableVtbl) [IID_IRcsEndUserMessageAction] {
    fn get_Label(&self, out: *mut HSTRING) -> HRESULT
}}
impl IRcsEndUserMessageAction {
    #[inline] pub unsafe fn get_label(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Label)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RcsEndUserMessageAction: IRcsEndUserMessageAction}
DEFINE_IID!(IID_IRcsEndUserMessageAvailableEventArgs, 759541249, 16265, 16874, 151, 2, 158, 158, 212, 17, 170, 152);
RT_INTERFACE!{interface IRcsEndUserMessageAvailableEventArgs(IRcsEndUserMessageAvailableEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRcsEndUserMessageAvailableEventArgs] {
    fn get_IsMessageAvailable(&self, out: *mut bool) -> HRESULT,
    fn get_Message(&self, out: *mut *mut RcsEndUserMessage) -> HRESULT
}}
impl IRcsEndUserMessageAvailableEventArgs {
    #[inline] pub unsafe fn get_is_message_available(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMessageAvailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message(&self) -> Result<ComPtr<RcsEndUserMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RcsEndUserMessageAvailableEventArgs: IRcsEndUserMessageAvailableEventArgs}
DEFINE_IID!(IID_IRcsEndUserMessageAvailableTriggerDetails, 1536652333, 13599, 18066, 180, 30, 27, 3, 93, 193, 137, 134);
RT_INTERFACE!{interface IRcsEndUserMessageAvailableTriggerDetails(IRcsEndUserMessageAvailableTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IRcsEndUserMessageAvailableTriggerDetails] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT
}}
impl IRcsEndUserMessageAvailableTriggerDetails {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RcsEndUserMessageAvailableTriggerDetails: IRcsEndUserMessageAvailableTriggerDetails}
DEFINE_IID!(IID_IRcsEndUserMessageManager, 810856026, 19743, 19289, 148, 51, 18, 108, 115, 78, 134, 166);
RT_INTERFACE!{interface IRcsEndUserMessageManager(IRcsEndUserMessageManagerVtbl): IInspectable(IInspectableVtbl) [IID_IRcsEndUserMessageManager] {
    fn add_MessageAvailableChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<RcsEndUserMessageManager, RcsEndUserMessageAvailableEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MessageAvailableChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IRcsEndUserMessageManager {
    #[inline] pub unsafe fn add_message_available_changed(&self, handler: &super::super::foundation::TypedEventHandler<RcsEndUserMessageManager, RcsEndUserMessageAvailableEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MessageAvailableChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_message_available_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MessageAvailableChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RcsEndUserMessageManager: IRcsEndUserMessageManager}
RT_CLASS!{static class RcsManager}
impl RtActivatable<IRcsManagerStatics> for RcsManager {}
impl RcsManager {
    #[inline] pub fn get_end_user_message_manager() -> Result<ComPtr<RcsEndUserMessageManager>> { unsafe {
        <Self as RtActivatable<IRcsManagerStatics>>::get_activation_factory().get_end_user_message_manager()
    }}
    #[inline] pub fn get_transports_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<RcsTransport>>>> { unsafe {
        <Self as RtActivatable<IRcsManagerStatics>>::get_activation_factory().get_transports_async()
    }}
    #[inline] pub fn get_transport_async(transportId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<RcsTransport>>> { unsafe {
        <Self as RtActivatable<IRcsManagerStatics>>::get_activation_factory().get_transport_async(transportId)
    }}
    #[inline] pub fn leave_conversation_async(conversation: &ChatConversation) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IRcsManagerStatics>>::get_activation_factory().leave_conversation_async(conversation)
    }}
}
DEFINE_CLSID!(RcsManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,104,97,116,46,82,99,115,77,97,110,97,103,101,114,0]) [CLSID_RcsManager]);
DEFINE_IID!(IID_IRcsManagerStatics, 2099710661, 2749, 20273, 155, 153, 165, 158, 113, 167, 183, 49);
RT_INTERFACE!{static interface IRcsManagerStatics(IRcsManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRcsManagerStatics] {
    fn GetEndUserMessageManager(&self, out: *mut *mut RcsEndUserMessageManager) -> HRESULT,
    fn GetTransportsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<RcsTransport>>) -> HRESULT,
    fn GetTransportAsync(&self, transportId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<RcsTransport>) -> HRESULT,
    fn LeaveConversationAsync(&self, conversation: *mut ChatConversation, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IRcsManagerStatics {
    #[inline] pub unsafe fn get_end_user_message_manager(&self) -> Result<ComPtr<RcsEndUserMessageManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEndUserMessageManager)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transports_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<RcsTransport>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTransportsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_async(&self, transportId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<RcsTransport>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTransportAsync)(self as *const _ as *mut _, transportId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn leave_conversation_async(&self, conversation: &ChatConversation) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LeaveConversationAsync)(self as *const _ as *mut _, conversation as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum RcsServiceKind: i32 {
    Chat (RcsServiceKind_Chat) = 0, GroupChat (RcsServiceKind_GroupChat) = 1, FileTransfer (RcsServiceKind_FileTransfer) = 2, Capability (RcsServiceKind_Capability) = 3,
}}
DEFINE_IID!(IID_IRcsServiceKindSupportedChangedEventArgs, 4101939780, 59267, 18534, 179, 167, 78, 92, 207, 2, 48, 112);
RT_INTERFACE!{interface IRcsServiceKindSupportedChangedEventArgs(IRcsServiceKindSupportedChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRcsServiceKindSupportedChangedEventArgs] {
    fn get_ServiceKind(&self, out: *mut RcsServiceKind) -> HRESULT
}}
impl IRcsServiceKindSupportedChangedEventArgs {
    #[inline] pub unsafe fn get_service_kind(&self) -> Result<RcsServiceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RcsServiceKindSupportedChangedEventArgs: IRcsServiceKindSupportedChangedEventArgs}
DEFINE_IID!(IID_IRcsTransport, 4272113497, 62332, 17177, 133, 70, 236, 132, 210, 29, 48, 255);
RT_INTERFACE!{interface IRcsTransport(IRcsTransportVtbl): IInspectable(IInspectableVtbl) [IID_IRcsTransport] {
    fn get_ExtendedProperties(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT,
    fn get_IsActive(&self, out: *mut bool) -> HRESULT,
    fn get_TransportFriendlyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TransportId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Configuration(&self, out: *mut *mut RcsTransportConfiguration) -> HRESULT,
    fn IsStoreAndForwardEnabled(&self, serviceKind: RcsServiceKind, out: *mut bool) -> HRESULT,
    fn IsServiceKindSupported(&self, serviceKind: RcsServiceKind, out: *mut bool) -> HRESULT,
    fn add_ServiceKindSupportedChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<RcsTransport, RcsServiceKindSupportedChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ServiceKindSupportedChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IRcsTransport {
    #[inline] pub unsafe fn get_extended_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExtendedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_active(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsActive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_friendly_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportFriendlyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_configuration(&self) -> Result<ComPtr<RcsTransportConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Configuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_store_and_forward_enabled(&self, serviceKind: RcsServiceKind) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsStoreAndForwardEnabled)(self as *const _ as *mut _, serviceKind, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_service_kind_supported(&self, serviceKind: RcsServiceKind) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsServiceKindSupported)(self as *const _ as *mut _, serviceKind, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_service_kind_supported_changed(&self, handler: &super::super::foundation::TypedEventHandler<RcsTransport, RcsServiceKindSupportedChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ServiceKindSupportedChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_service_kind_supported_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ServiceKindSupportedChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RcsTransport: IRcsTransport}
DEFINE_IID!(IID_IRcsTransportConfiguration, 533508354, 9330, 19385, 153, 136, 193, 33, 28, 131, 232, 169);
RT_INTERFACE!{interface IRcsTransportConfiguration(IRcsTransportConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IRcsTransportConfiguration] {
    fn get_MaxAttachmentCount(&self, out: *mut i32) -> HRESULT,
    fn get_MaxMessageSizeInKilobytes(&self, out: *mut i32) -> HRESULT,
    fn get_MaxGroupMessageSizeInKilobytes(&self, out: *mut i32) -> HRESULT,
    fn get_MaxRecipientCount(&self, out: *mut i32) -> HRESULT,
    fn get_MaxFileSizeInKilobytes(&self, out: *mut i32) -> HRESULT,
    fn get_WarningFileSizeInKilobytes(&self, out: *mut i32) -> HRESULT
}}
impl IRcsTransportConfiguration {
    #[inline] pub unsafe fn get_max_attachment_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxAttachmentCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_message_size_in_kilobytes(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxMessageSizeInKilobytes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_group_message_size_in_kilobytes(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxGroupMessageSizeInKilobytes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_recipient_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxRecipientCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_file_size_in_kilobytes(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxFileSizeInKilobytes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_warning_file_size_in_kilobytes(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WarningFileSizeInKilobytes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RcsTransportConfiguration: IRcsTransportConfiguration}
DEFINE_IID!(IID_IRemoteParticipantComposingChangedEventArgs, 515917223, 53193, 17865, 152, 118, 68, 159, 43, 193, 128, 245);
RT_INTERFACE!{interface IRemoteParticipantComposingChangedEventArgs(IRemoteParticipantComposingChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRemoteParticipantComposingChangedEventArgs] {
    fn get_TransportId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ParticipantAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsComposing(&self, out: *mut bool) -> HRESULT
}}
impl IRemoteParticipantComposingChangedEventArgs {
    #[inline] pub unsafe fn get_transport_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransportId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_participant_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ParticipantAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_composing(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsComposing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RemoteParticipantComposingChangedEventArgs: IRemoteParticipantComposingChangedEventArgs}
} // Windows.ApplicationModel.Chat
pub mod contacts { // Windows.ApplicationModel.Contacts
use ::prelude::*;
DEFINE_IID!(IID_IAggregateContactManager, 58316253, 56154, 20435, 181, 78, 77, 241, 121, 23, 162, 18);
RT_INTERFACE!{interface IAggregateContactManager(IAggregateContactManagerVtbl): IInspectable(IInspectableVtbl) [IID_IAggregateContactManager] {
    fn FindRawContactsAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Contact>>) -> HRESULT,
    fn TryLinkContactsAsync(&self, primaryContact: *mut Contact, secondaryContact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn UnlinkRawContactAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn TrySetPreferredSourceForPictureAsync(&self, aggregateContact: *mut Contact, rawContact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IAggregateContactManager {
    #[inline] pub unsafe fn find_raw_contacts_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Contact>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindRawContactsAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_link_contacts_async(&self, primaryContact: &Contact, secondaryContact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryLinkContactsAsync)(self as *const _ as *mut _, primaryContact as *const _ as *mut _, secondaryContact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn unlink_raw_contact_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UnlinkRawContactAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_preferred_source_for_picture_async(&self, aggregateContact: &Contact, rawContact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TrySetPreferredSourceForPictureAsync)(self as *const _ as *mut _, aggregateContact as *const _ as *mut _, rawContact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AggregateContactManager: IAggregateContactManager}
DEFINE_IID!(IID_IAggregateContactManager2, 1586283224, 43469, 17456, 156, 75, 1, 52, 141, 178, 202, 80);
RT_INTERFACE!{interface IAggregateContactManager2(IAggregateContactManager2Vtbl): IInspectable(IInspectableVtbl) [IID_IAggregateContactManager2] {
    fn SetRemoteIdentificationInformationAsync(&self, contactListId: HSTRING, remoteSourceId: HSTRING, accountId: HSTRING, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAggregateContactManager2 {
    #[inline] pub unsafe fn set_remote_identification_information_async(&self, contactListId: &HStringArg, remoteSourceId: &HStringArg, accountId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetRemoteIdentificationInformationAsync)(self as *const _ as *mut _, contactListId.get(), remoteSourceId.get(), accountId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContact, 3959452403, 8472, 16457, 158, 188, 23, 240, 171, 105, 43, 100);
RT_INTERFACE!{interface IContact(IContactVtbl): IInspectable(IInspectableVtbl) [IID_IContact] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Thumbnail(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_Thumbnail(&self, value: *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn get_Fields(&self, out: *mut *mut super::super::foundation::collections::IVector<IContactField>) -> HRESULT
}}
impl IContact {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_thumbnail(&self, value: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Thumbnail)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_fields(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<IContactField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Fields)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Contact: IContact}
impl RtActivatable<IActivationFactory> for Contact {}
DEFINE_CLSID!(Contact(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,0]) [CLSID_Contact]);
DEFINE_IID!(IID_IContact2, 4078105445, 47991, 19604, 128, 45, 131, 40, 206, 228, 12, 8);
RT_INTERFACE!{interface IContact2(IContact2Vtbl): IInspectable(IInspectableVtbl) [IID_IContact2] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Id(&self, value: HSTRING) -> HRESULT,
    fn get_Notes(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Notes(&self, value: HSTRING) -> HRESULT,
    fn get_Phones(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactPhone>) -> HRESULT,
    fn get_Emails(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactEmail>) -> HRESULT,
    fn get_Addresses(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactAddress>) -> HRESULT,
    fn get_ConnectedServiceAccounts(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactConnectedServiceAccount>) -> HRESULT,
    fn get_ImportantDates(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactDate>) -> HRESULT,
    fn get_DataSuppliers(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_JobInfo(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactJobInfo>) -> HRESULT,
    fn get_SignificantOthers(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactSignificantOther>) -> HRESULT,
    fn get_Websites(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactWebsite>) -> HRESULT,
    fn get_ProviderProperties(&self, out: *mut *mut super::super::foundation::collections::IPropertySet) -> HRESULT
}}
impl IContact2 {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Id)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_notes(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Notes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_notes(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Notes)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phones(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactPhone>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Phones)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_emails(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactEmail>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Emails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_addresses(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactAddress>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Addresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connected_service_accounts(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactConnectedServiceAccount>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectedServiceAccounts)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_important_dates(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactDate>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ImportantDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_suppliers(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataSuppliers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_job_info(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactJobInfo>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_JobInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_significant_others(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactSignificantOther>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SignificantOthers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_websites(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactWebsite>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Websites)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_provider_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IPropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProviderProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContact3, 1210064487, 57486, 17060, 181, 97, 65, 208, 140, 169, 87, 93);
RT_INTERFACE!{interface IContact3(IContact3Vtbl): IInspectable(IInspectableVtbl) [IID_IContact3] {
    fn get_ContactListId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayPictureUserUpdateTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_DisplayPictureUserUpdateTime(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn get_IsMe(&self, out: *mut bool) -> HRESULT,
    fn get_AggregateId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    fn get_RingToneToken(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RingToneToken(&self, value: HSTRING) -> HRESULT,
    fn get_IsDisplayPictureManuallySet(&self, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_LargeDisplayPicture(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy11(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SmallDisplayPicture(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy12(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SourceDisplayPicture(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy13(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_SourceDisplayPicture(&self, value: *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn get_TextToneToken(&self, out: *mut HSTRING) -> HRESULT,
    fn put_TextToneToken(&self, value: HSTRING) -> HRESULT,
    fn get_IsAggregate(&self, out: *mut bool) -> HRESULT,
    fn get_FullName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayNameOverride(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayNameOverride(&self, value: HSTRING) -> HRESULT,
    fn get_Nickname(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Nickname(&self, value: HSTRING) -> HRESULT,
    fn get_SortName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContact3 {
    #[inline] pub unsafe fn get_contact_list_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactListId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_picture_user_update_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisplayPictureUserUpdateTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_picture_user_update_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayPictureUserUpdateTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_me(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMe)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_aggregate_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AggregateId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ring_tone_token(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RingToneToken)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_ring_tone_token(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RingToneToken)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_display_picture_manually_set(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisplayPictureManuallySet)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_large_display_picture(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LargeDisplayPicture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_small_display_picture(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmallDisplayPicture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_source_display_picture(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceDisplayPicture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_source_display_picture(&self, value: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SourceDisplayPicture)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_tone_token(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextToneToken)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_tone_token(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextToneToken)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_aggregate(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAggregate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_full_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FullName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name_override(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayNameOverride)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name_override(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayNameOverride)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_nickname(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Nickname)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_nickname(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Nickname)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sort_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SortName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactAddress, 2537149338, 17102, 18546, 141, 112, 48, 99, 170, 88, 75, 112);
RT_INTERFACE!{interface IContactAddress(IContactAddressVtbl): IInspectable(IInspectableVtbl) [IID_IContactAddress] {
    fn get_StreetAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn put_StreetAddress(&self, value: HSTRING) -> HRESULT,
    fn get_Locality(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Locality(&self, value: HSTRING) -> HRESULT,
    fn get_Region(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Region(&self, value: HSTRING) -> HRESULT,
    fn get_Country(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Country(&self, value: HSTRING) -> HRESULT,
    fn get_PostalCode(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PostalCode(&self, value: HSTRING) -> HRESULT,
    fn get_Kind(&self, out: *mut ContactAddressKind) -> HRESULT,
    fn put_Kind(&self, value: ContactAddressKind) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactAddress {
    #[inline] pub unsafe fn get_street_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StreetAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_street_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StreetAddress)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_locality(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Locality)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_locality(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Locality)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_region(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Region)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_region(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Region)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_country(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Country)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_country(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Country)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_postal_code(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PostalCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_postal_code(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PostalCode)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<ContactAddressKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_kind(&self, value: ContactAddressKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Kind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactAddress: IContactAddress}
impl RtActivatable<IActivationFactory> for ContactAddress {}
DEFINE_CLSID!(ContactAddress(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,65,100,100,114,101,115,115,0]) [CLSID_ContactAddress]);
RT_ENUM! { enum ContactAddressKind: i32 {
    Home (ContactAddressKind_Home) = 0, Work (ContactAddressKind_Work) = 1, Other (ContactAddressKind_Other) = 2,
}}
DEFINE_IID!(IID_IContactAnnotation, 2183119599, 32065, 17570, 132, 195, 96, 162, 129, 221, 123, 134);
RT_INTERFACE!{interface IContactAnnotation(IContactAnnotationVtbl): IInspectable(IInspectableVtbl) [IID_IContactAnnotation] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AnnotationListId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ContactId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ContactId(&self, value: HSTRING) -> HRESULT,
    fn get_RemoteId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RemoteId(&self, value: HSTRING) -> HRESULT,
    fn get_SupportedOperations(&self, out: *mut ContactAnnotationOperations) -> HRESULT,
    fn put_SupportedOperations(&self, value: ContactAnnotationOperations) -> HRESULT,
    fn get_IsDisabled(&self, out: *mut bool) -> HRESULT,
    fn get_ProviderProperties(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT
}}
impl IContactAnnotation {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_annotation_list_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AnnotationListId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_contact_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContactId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_operations(&self) -> Result<ContactAnnotationOperations> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportedOperations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_supported_operations(&self, value: ContactAnnotationOperations) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SupportedOperations)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_provider_properties(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProviderProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactAnnotation: IContactAnnotation}
impl RtActivatable<IActivationFactory> for ContactAnnotation {}
DEFINE_CLSID!(ContactAnnotation(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,65,110,110,111,116,97,116,105,111,110,0]) [CLSID_ContactAnnotation]);
DEFINE_IID!(IID_IContactAnnotation2, 3063016691, 19127, 18975, 153, 65, 12, 156, 243, 23, 27, 117);
RT_INTERFACE!{interface IContactAnnotation2(IContactAnnotation2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactAnnotation2] {
    fn get_ContactListId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ContactListId(&self, value: HSTRING) -> HRESULT
}}
impl IContactAnnotation2 {
    #[inline] pub unsafe fn get_contact_list_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactListId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_contact_list_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContactListId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactAnnotationList, 2460255914, 23688, 17849, 170, 208, 70, 24, 136, 230, 141, 138);
RT_INTERFACE!{interface IContactAnnotationList(IContactAnnotationListVtbl): IInspectable(IInspectableVtbl) [IID_IContactAnnotationList] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ProviderPackageFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_UserDataAccountId(&self, out: *mut HSTRING) -> HRESULT,
    fn DeleteAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn TrySaveAnnotationAsync(&self, annotation: *mut ContactAnnotation, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn GetAnnotationAsync(&self, annotationId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ContactAnnotation>) -> HRESULT,
    fn FindAnnotationsByRemoteIdAsync(&self, remoteId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>) -> HRESULT,
    fn FindAnnotationsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>) -> HRESULT,
    fn DeleteAnnotationAsync(&self, annotation: *mut ContactAnnotation, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IContactAnnotationList {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_provider_package_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProviderPackageFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_data_account_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserDataAccountId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_save_annotation_async(&self, annotation: &ContactAnnotation) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TrySaveAnnotationAsync)(self as *const _ as *mut _, annotation as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_annotation_async(&self, annotationId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAnnotationAsync)(self as *const _ as *mut _, annotationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_annotations_by_remote_id_async(&self, remoteId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAnnotationsByRemoteIdAsync)(self as *const _ as *mut _, remoteId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_annotations_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAnnotationsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_annotation_async(&self, annotation: &ContactAnnotation) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAnnotationAsync)(self as *const _ as *mut _, annotation as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactAnnotationList: IContactAnnotationList}
RT_ENUM! { enum ContactAnnotationOperations: u32 {
    None (ContactAnnotationOperations_None) = 0, ContactProfile (ContactAnnotationOperations_ContactProfile) = 1, Message (ContactAnnotationOperations_Message) = 2, AudioCall (ContactAnnotationOperations_AudioCall) = 4, VideoCall (ContactAnnotationOperations_VideoCall) = 8, SocialFeeds (ContactAnnotationOperations_SocialFeeds) = 16, Share (ContactAnnotationOperations_Share) = 32,
}}
DEFINE_IID!(IID_IContactAnnotationStore, 598537386, 31351, 17789, 130, 3, 152, 127, 75, 49, 175, 9);
RT_INTERFACE!{interface IContactAnnotationStore(IContactAnnotationStoreVtbl): IInspectable(IInspectableVtbl) [IID_IContactAnnotationStore] {
    fn FindContactIdsByEmailAsync(&self, emailAddress: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<HString>>) -> HRESULT,
    fn FindContactIdsByPhoneNumberAsync(&self, phoneNumber: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<HString>>) -> HRESULT,
    fn FindAnnotationsForContactAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>) -> HRESULT,
    fn DisableAnnotationAsync(&self, annotation: *mut ContactAnnotation, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn CreateAnnotationListAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ContactAnnotationList>) -> HRESULT,
    fn CreateAnnotationListInAccountAsync(&self, userDataAccountId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ContactAnnotationList>) -> HRESULT,
    fn GetAnnotationListAsync(&self, annotationListId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ContactAnnotationList>) -> HRESULT,
    fn FindAnnotationListsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotationList>>) -> HRESULT
}}
impl IContactAnnotationStore {
    #[inline] pub unsafe fn find_contact_ids_by_email_async(&self, emailAddress: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<HString>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindContactIdsByEmailAsync)(self as *const _ as *mut _, emailAddress.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_contact_ids_by_phone_number_async(&self, phoneNumber: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<HString>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindContactIdsByPhoneNumberAsync)(self as *const _ as *mut _, phoneNumber.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_annotations_for_contact_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAnnotationsForContactAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn disable_annotation_async(&self, annotation: &ContactAnnotation) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DisableAnnotationAsync)(self as *const _ as *mut _, annotation as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_annotation_list_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotationList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAnnotationListAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_annotation_list_in_account_async(&self, userDataAccountId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotationList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAnnotationListInAccountAsync)(self as *const _ as *mut _, userDataAccountId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_annotation_list_async(&self, annotationListId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotationList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAnnotationListAsync)(self as *const _ as *mut _, annotationListId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_annotation_lists_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotationList>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAnnotationListsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactAnnotationStore: IContactAnnotationStore}
DEFINE_IID!(IID_IContactAnnotationStore2, 2128487421, 25063, 18791, 142, 197, 189, 242, 128, 162, 64, 99);
RT_INTERFACE!{interface IContactAnnotationStore2(IContactAnnotationStore2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactAnnotationStore2] {
    fn FindAnnotationsForContactListAsync(&self, contactListId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>) -> HRESULT
}}
impl IContactAnnotationStore2 {
    #[inline] pub unsafe fn find_annotations_for_contact_list_async(&self, contactListId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactAnnotation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAnnotationsForContactListAsync)(self as *const _ as *mut _, contactListId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactAnnotationStoreAccessType: i32 {
    AppAnnotationsReadWrite (ContactAnnotationStoreAccessType_AppAnnotationsReadWrite) = 0, AllAnnotationsReadWrite (ContactAnnotationStoreAccessType_AllAnnotationsReadWrite) = 1,
}}
DEFINE_IID!(IID_IContactBatch, 902928173, 49102, 18107, 147, 248, 165, 176, 110, 197, 226, 1);
RT_INTERFACE!{interface IContactBatch(IContactBatchVtbl): IInspectable(IInspectableVtbl) [IID_IContactBatch] {
    fn get_Contacts(&self, out: *mut *mut super::super::foundation::collections::IVectorView<Contact>) -> HRESULT,
    fn get_Status(&self, out: *mut ContactBatchStatus) -> HRESULT
}}
impl IContactBatch {
    #[inline] pub unsafe fn get_contacts(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contacts)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<ContactBatchStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ContactBatch: IContactBatch}
RT_ENUM! { enum ContactBatchStatus: i32 {
    Success (ContactBatchStatus_Success) = 0, ServerSearchSyncManagerError (ContactBatchStatus_ServerSearchSyncManagerError) = 1, ServerSearchUnknownError (ContactBatchStatus_ServerSearchUnknownError) = 2,
}}
DEFINE_IID!(IID_IContactCardDelayedDataLoader, 3054172418, 5446, 17229, 134, 156, 110, 53, 32, 118, 14, 243);
RT_INTERFACE!{interface IContactCardDelayedDataLoader(IContactCardDelayedDataLoaderVtbl): IInspectable(IInspectableVtbl) [IID_IContactCardDelayedDataLoader] {
    fn SetData(&self, contact: *mut Contact) -> HRESULT
}}
impl IContactCardDelayedDataLoader {
    #[inline] pub unsafe fn set_data(&self, contact: &Contact) -> Result<()> {
        let hr = ((*self.lpVtbl).SetData)(self as *const _ as *mut _, contact as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactCardDelayedDataLoader: IContactCardDelayedDataLoader}
RT_ENUM! { enum ContactCardHeaderKind: i32 {
    Default (ContactCardHeaderKind_Default) = 0, Basic (ContactCardHeaderKind_Basic) = 1, Enterprise (ContactCardHeaderKind_Enterprise) = 2,
}}
DEFINE_IID!(IID_IContactCardOptions, 2349485950, 27318, 20287, 190, 114, 129, 114, 54, 238, 234, 91);
RT_INTERFACE!{interface IContactCardOptions(IContactCardOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IContactCardOptions] {
    fn get_HeaderKind(&self, out: *mut ContactCardHeaderKind) -> HRESULT,
    fn put_HeaderKind(&self, value: ContactCardHeaderKind) -> HRESULT,
    fn get_InitialTabKind(&self, out: *mut ContactCardTabKind) -> HRESULT,
    fn put_InitialTabKind(&self, value: ContactCardTabKind) -> HRESULT
}}
impl IContactCardOptions {
    #[inline] pub unsafe fn get_header_kind(&self) -> Result<ContactCardHeaderKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HeaderKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_kind(&self, value: ContactCardHeaderKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_initial_tab_kind(&self) -> Result<ContactCardTabKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InitialTabKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_initial_tab_kind(&self, value: ContactCardTabKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InitialTabKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactCardOptions: IContactCardOptions}
impl RtActivatable<IActivationFactory> for ContactCardOptions {}
DEFINE_CLSID!(ContactCardOptions(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,67,97,114,100,79,112,116,105,111,110,115,0]) [CLSID_ContactCardOptions]);
DEFINE_IID!(IID_IContactCardOptions2, 2401704864, 55115, 19654, 159, 83, 27, 14, 181, 209, 39, 60);
RT_INTERFACE!{interface IContactCardOptions2(IContactCardOptions2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactCardOptions2] {
    fn get_ServerSearchContactListIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IContactCardOptions2 {
    #[inline] pub unsafe fn get_server_search_contact_list_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServerSearchContactListIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactCardTabKind: i32 {
    Default (ContactCardTabKind_Default) = 0, Email (ContactCardTabKind_Email) = 1, Messaging (ContactCardTabKind_Messaging) = 2, Phone (ContactCardTabKind_Phone) = 3, Video (ContactCardTabKind_Video) = 4, OrganizationalHierarchy (ContactCardTabKind_OrganizationalHierarchy) = 5,
}}
DEFINE_IID!(IID_IContactChange, 2501724944, 27225, 18208, 164, 225, 54, 61, 152, 193, 53, 213);
RT_INTERFACE!{interface IContactChange(IContactChangeVtbl): IInspectable(IInspectableVtbl) [IID_IContactChange] {
    fn get_ChangeType(&self, out: *mut ContactChangeType) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut Contact) -> HRESULT
}}
impl IContactChange {
    #[inline] pub unsafe fn get_change_type(&self) -> Result<ContactChangeType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChangeType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<Contact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactChange: IContactChange}
DEFINE_IID!(IID_IContactChangedDeferral, 3306437352, 6915, 18168, 182, 148, 165, 35, 232, 60, 252, 182);
RT_INTERFACE!{interface IContactChangedDeferral(IContactChangedDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IContactChangedDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IContactChangedDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactChangedDeferral: IContactChangedDeferral}
DEFINE_IID!(IID_IContactChangedEventArgs, 1381924817, 29683, 19325, 169, 24, 88, 11, 228, 54, 97, 33);
RT_INTERFACE!{interface IContactChangedEventArgs(IContactChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactChangedEventArgs] {
    fn GetDeferral(&self, out: *mut *mut ContactChangedDeferral) -> HRESULT
}}
impl IContactChangedEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<ContactChangedDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactChangedEventArgs: IContactChangedEventArgs}
DEFINE_IID!(IID_IContactChangeReader, 561191418, 11532, 17120, 169, 218, 62, 205, 86, 167, 138, 71);
RT_INTERFACE!{interface IContactChangeReader(IContactChangeReaderVtbl): IInspectable(IInspectableVtbl) [IID_IContactChangeReader] {
    fn AcceptChanges(&self) -> HRESULT,
    fn AcceptChangesThrough(&self, lastChangeToAccept: *mut ContactChange) -> HRESULT,
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactChange>>) -> HRESULT
}}
impl IContactChangeReader {
    #[inline] pub unsafe fn accept_changes(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptChanges)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept_changes_through(&self, lastChangeToAccept: &ContactChange) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptChangesThrough)(self as *const _ as *mut _, lastChangeToAccept as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactChange>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactChangeReader: IContactChangeReader}
DEFINE_IID!(IID_IContactChangeTracker, 1855531346, 12443, 16461, 151, 18, 179, 123, 211, 2, 120, 170);
RT_INTERFACE!{interface IContactChangeTracker(IContactChangeTrackerVtbl): IInspectable(IInspectableVtbl) [IID_IContactChangeTracker] {
    fn Enable(&self) -> HRESULT,
    fn GetChangeReader(&self, out: *mut *mut ContactChangeReader) -> HRESULT,
    fn Reset(&self) -> HRESULT
}}
impl IContactChangeTracker {
    #[inline] pub unsafe fn enable(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Enable)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_change_reader(&self) -> Result<ComPtr<ContactChangeReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChangeReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Reset)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactChangeTracker: IContactChangeTracker}
DEFINE_IID!(IID_IContactChangeTracker2, 2139803900, 37665, 19736, 156, 9, 215, 8, 198, 63, 205, 49);
RT_INTERFACE!{interface IContactChangeTracker2(IContactChangeTracker2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactChangeTracker2] {
    fn get_IsTracking(&self, out: *mut bool) -> HRESULT
}}
impl IContactChangeTracker2 {
    #[inline] pub unsafe fn get_is_tracking(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTracking)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactChangeType: i32 {
    Created (ContactChangeType_Created) = 0, Modified (ContactChangeType_Modified) = 1, Deleted (ContactChangeType_Deleted) = 2, ChangeTrackingLost (ContactChangeType_ChangeTrackingLost) = 3,
}}
DEFINE_IID!(IID_IContactConnectedServiceAccount, 4143461715, 43559, 18225, 142, 74, 61, 236, 92, 233, 238, 201);
RT_INTERFACE!{interface IContactConnectedServiceAccount(IContactConnectedServiceAccountVtbl): IInspectable(IInspectableVtbl) [IID_IContactConnectedServiceAccount] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Id(&self, value: HSTRING) -> HRESULT,
    fn get_ServiceName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ServiceName(&self, value: HSTRING) -> HRESULT
}}
impl IContactConnectedServiceAccount {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Id)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_service_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ServiceName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactConnectedServiceAccount: IContactConnectedServiceAccount}
impl RtActivatable<IActivationFactory> for ContactConnectedServiceAccount {}
DEFINE_CLSID!(ContactConnectedServiceAccount(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,67,111,110,110,101,99,116,101,100,83,101,114,118,105,99,101,65,99,99,111,117,110,116,0]) [CLSID_ContactConnectedServiceAccount]);
DEFINE_IID!(IID_IContactDate, 4271418982, 45573, 18740, 145, 116, 15, 242, 176, 86, 87, 7);
RT_INTERFACE!{interface IContactDate(IContactDateVtbl): IInspectable(IInspectableVtbl) [IID_IContactDate] {
    fn get_Day(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_Day(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Month(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_Month(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Year(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_Year(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_Kind(&self, out: *mut ContactDateKind) -> HRESULT,
    fn put_Kind(&self, value: ContactDateKind) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactDate {
    #[inline] pub unsafe fn get_day(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Day)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Day)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Month)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Month)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Year)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Year)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<ContactDateKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_kind(&self, value: ContactDateKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Kind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactDate: IContactDate}
impl RtActivatable<IActivationFactory> for ContactDate {}
DEFINE_CLSID!(ContactDate(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,68,97,116,101,0]) [CLSID_ContactDate]);
RT_ENUM! { enum ContactDateKind: i32 {
    Birthday (ContactDateKind_Birthday) = 0, Anniversary (ContactDateKind_Anniversary) = 1, Other (ContactDateKind_Other) = 2,
}}
DEFINE_IID!(IID_IContactEmail, 2426542505, 58323, 19811, 153, 59, 5, 185, 165, 57, 58, 191);
RT_INTERFACE!{interface IContactEmail(IContactEmailVtbl): IInspectable(IInspectableVtbl) [IID_IContactEmail] {
    fn get_Address(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Address(&self, value: HSTRING) -> HRESULT,
    fn get_Kind(&self, out: *mut ContactEmailKind) -> HRESULT,
    fn put_Kind(&self, value: ContactEmailKind) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactEmail {
    #[inline] pub unsafe fn get_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Address)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Address)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<ContactEmailKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_kind(&self, value: ContactEmailKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Kind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactEmail: IContactEmail}
impl RtActivatable<IActivationFactory> for ContactEmail {}
DEFINE_CLSID!(ContactEmail(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,69,109,97,105,108,0]) [CLSID_ContactEmail]);
RT_ENUM! { enum ContactEmailKind: i32 {
    Personal (ContactEmailKind_Personal) = 0, Work (ContactEmailKind_Work) = 1, Other (ContactEmailKind_Other) = 2,
}}
DEFINE_IID!(IID_IContactField, 2977319018, 53907, 18732, 160, 88, 219, 87, 91, 62, 60, 15);
RT_INTERFACE!{interface IContactField(IContactFieldVtbl): IInspectable(IInspectableVtbl) [IID_IContactField] {
    fn get_Type(&self, out: *mut ContactFieldType) -> HRESULT,
    fn get_Category(&self, out: *mut ContactFieldCategory) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Value(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactField {
    #[inline] pub unsafe fn get_type(&self) -> Result<ContactFieldType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_category(&self) -> Result<ContactFieldCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Category)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactField: IContactField}
impl RtActivatable<IContactFieldFactory> for ContactField {}
impl ContactField {
    #[inline] pub fn create_field_default(value: &HStringArg, type_: ContactFieldType) -> Result<ComPtr<ContactField>> { unsafe {
        <Self as RtActivatable<IContactFieldFactory>>::get_activation_factory().create_field_default(value, type_)
    }}
    #[inline] pub fn create_field_category(value: &HStringArg, type_: ContactFieldType, category: ContactFieldCategory) -> Result<ComPtr<ContactField>> { unsafe {
        <Self as RtActivatable<IContactFieldFactory>>::get_activation_factory().create_field_category(value, type_, category)
    }}
    #[inline] pub fn create_field_custom(name: &HStringArg, value: &HStringArg, type_: ContactFieldType, category: ContactFieldCategory) -> Result<ComPtr<ContactField>> { unsafe {
        <Self as RtActivatable<IContactFieldFactory>>::get_activation_factory().create_field_custom(name, value, type_, category)
    }}
}
DEFINE_CLSID!(ContactField(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,70,105,101,108,100,0]) [CLSID_ContactField]);
RT_ENUM! { enum ContactFieldCategory: i32 {
    None (ContactFieldCategory_None) = 0, Home (ContactFieldCategory_Home) = 1, Work (ContactFieldCategory_Work) = 2, Mobile (ContactFieldCategory_Mobile) = 3, Other (ContactFieldCategory_Other) = 4,
}}
DEFINE_IID!(IID_IContactFieldFactory, 2246218047, 3658, 19006, 137, 148, 64, 106, 231, 237, 100, 110);
RT_INTERFACE!{static interface IContactFieldFactory(IContactFieldFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContactFieldFactory] {
    fn CreateField_Default(&self, value: HSTRING, type_: ContactFieldType, out: *mut *mut ContactField) -> HRESULT,
    fn CreateField_Category(&self, value: HSTRING, type_: ContactFieldType, category: ContactFieldCategory, out: *mut *mut ContactField) -> HRESULT,
    fn CreateField_Custom(&self, name: HSTRING, value: HSTRING, type_: ContactFieldType, category: ContactFieldCategory, out: *mut *mut ContactField) -> HRESULT
}}
impl IContactFieldFactory {
    #[inline] pub unsafe fn create_field_default(&self, value: &HStringArg, type_: ContactFieldType) -> Result<ComPtr<ContactField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateField_Default)(self as *const _ as *mut _, value.get(), type_, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_field_category(&self, value: &HStringArg, type_: ContactFieldType, category: ContactFieldCategory) -> Result<ComPtr<ContactField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateField_Category)(self as *const _ as *mut _, value.get(), type_, category, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_field_custom(&self, name: &HStringArg, value: &HStringArg, type_: ContactFieldType, category: ContactFieldCategory) -> Result<ComPtr<ContactField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateField_Custom)(self as *const _ as *mut _, name.get(), value.get(), type_, category, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactFieldFactory: IContactFieldFactory}
impl RtActivatable<IActivationFactory> for ContactFieldFactory {}
DEFINE_CLSID!(ContactFieldFactory(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,70,105,101,108,100,70,97,99,116,111,114,121,0]) [CLSID_ContactFieldFactory]);
RT_ENUM! { enum ContactFieldType: i32 {
    Email (ContactFieldType_Email) = 0, PhoneNumber (ContactFieldType_PhoneNumber) = 1, Location (ContactFieldType_Location) = 2, InstantMessage (ContactFieldType_InstantMessage) = 3, Custom (ContactFieldType_Custom) = 4, ConnectedServiceAccount (ContactFieldType_ConnectedServiceAccount) = 5, ImportantDate (ContactFieldType_ImportantDate) = 6, Address (ContactFieldType_Address) = 7, SignificantOther (ContactFieldType_SignificantOther) = 8, Notes (ContactFieldType_Notes) = 9, Website (ContactFieldType_Website) = 10, JobInfo (ContactFieldType_JobInfo) = 11,
}}
DEFINE_IID!(IID_IContactGroup, 1505618689, 40602, 18269, 191, 229, 163, 123, 128, 109, 133, 44);
RT_INTERFACE!{interface IContactGroup(IContactGroupVtbl): IInspectable(IInspectableVtbl) [IID_IContactGroup] {
    
}}
RT_CLASS!{class ContactGroup: IContactGroup}
DEFINE_IID!(IID_IContactInformation, 660518612, 27182, 17016, 169, 20, 228, 96, 213, 240, 136, 246);
RT_INTERFACE!{interface IContactInformation(IContactInformationVtbl): IInspectable(IInspectableVtbl) [IID_IContactInformation] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn GetThumbnailAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>) -> HRESULT,
    fn get_Emails(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ContactField>) -> HRESULT,
    fn get_PhoneNumbers(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ContactField>) -> HRESULT,
    fn get_Locations(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ContactLocationField>) -> HRESULT,
    fn get_InstantMessages(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ContactInstantMessageField>) -> HRESULT,
    fn get_CustomFields(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ContactField>) -> HRESULT,
    fn QueryCustomFields(&self, customName: HSTRING, out: *mut *mut super::super::foundation::collections::IVectorView<ContactField>) -> HRESULT
}}
impl IContactInformation {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_thumbnail_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetThumbnailAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_emails(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Emails)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_locations(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactLocationField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Locations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_instant_messages(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactInstantMessageField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InstantMessages)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_fields(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CustomFields)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn query_custom_fields(&self, customName: &HStringArg) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactField>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).QueryCustomFields)(self as *const _ as *mut _, customName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactInformation: IContactInformation}
DEFINE_IID!(IID_IContactInstantMessageField, 3437443895, 3461, 16890, 180, 61, 218, 89, 156, 62, 176, 9);
RT_INTERFACE!{interface IContactInstantMessageField(IContactInstantMessageFieldVtbl): IInspectable(IInspectableVtbl) [IID_IContactInstantMessageField] {
    fn get_UserName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Service(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_LaunchUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT
}}
impl IContactInstantMessageField {
    #[inline] pub unsafe fn get_user_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Service)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_launch_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LaunchUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactInstantMessageField: IContactInstantMessageField}
impl RtActivatable<IContactInstantMessageFieldFactory> for ContactInstantMessageField {}
impl ContactInstantMessageField {
    #[inline] pub fn create_instant_message_default(userName: &HStringArg) -> Result<ComPtr<ContactInstantMessageField>> { unsafe {
        <Self as RtActivatable<IContactInstantMessageFieldFactory>>::get_activation_factory().create_instant_message_default(userName)
    }}
    #[inline] pub fn create_instant_message_category(userName: &HStringArg, category: ContactFieldCategory) -> Result<ComPtr<ContactInstantMessageField>> { unsafe {
        <Self as RtActivatable<IContactInstantMessageFieldFactory>>::get_activation_factory().create_instant_message_category(userName, category)
    }}
    #[inline] pub fn create_instant_message_all(userName: &HStringArg, category: ContactFieldCategory, service: &HStringArg, displayText: &HStringArg, verb: &super::super::foundation::Uri) -> Result<ComPtr<ContactInstantMessageField>> { unsafe {
        <Self as RtActivatable<IContactInstantMessageFieldFactory>>::get_activation_factory().create_instant_message_all(userName, category, service, displayText, verb)
    }}
}
DEFINE_CLSID!(ContactInstantMessageField(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,73,110,115,116,97,110,116,77,101,115,115,97,103,101,70,105,101,108,100,0]) [CLSID_ContactInstantMessageField]);
DEFINE_IID!(IID_IContactInstantMessageFieldFactory, 3121309588, 37283, 19378, 177, 185, 105, 165, 223, 240, 186, 9);
RT_INTERFACE!{static interface IContactInstantMessageFieldFactory(IContactInstantMessageFieldFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContactInstantMessageFieldFactory] {
    fn CreateInstantMessage_Default(&self, userName: HSTRING, out: *mut *mut ContactInstantMessageField) -> HRESULT,
    fn CreateInstantMessage_Category(&self, userName: HSTRING, category: ContactFieldCategory, out: *mut *mut ContactInstantMessageField) -> HRESULT,
    fn CreateInstantMessage_All(&self, userName: HSTRING, category: ContactFieldCategory, service: HSTRING, displayText: HSTRING, verb: *mut super::super::foundation::Uri, out: *mut *mut ContactInstantMessageField) -> HRESULT
}}
impl IContactInstantMessageFieldFactory {
    #[inline] pub unsafe fn create_instant_message_default(&self, userName: &HStringArg) -> Result<ComPtr<ContactInstantMessageField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstantMessage_Default)(self as *const _ as *mut _, userName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_instant_message_category(&self, userName: &HStringArg, category: ContactFieldCategory) -> Result<ComPtr<ContactInstantMessageField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstantMessage_Category)(self as *const _ as *mut _, userName.get(), category, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_instant_message_all(&self, userName: &HStringArg, category: ContactFieldCategory, service: &HStringArg, displayText: &HStringArg, verb: &super::super::foundation::Uri) -> Result<ComPtr<ContactInstantMessageField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstantMessage_All)(self as *const _ as *mut _, userName.get(), category, service.get(), displayText.get(), verb as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactJobInfo, 1829862220, 52816, 19267, 158, 105, 177, 130, 88, 234, 83, 21);
RT_INTERFACE!{interface IContactJobInfo(IContactJobInfoVtbl): IInspectable(IInspectableVtbl) [IID_IContactJobInfo] {
    fn get_CompanyName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CompanyName(&self, value: HSTRING) -> HRESULT,
    fn get_CompanyYomiName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CompanyYomiName(&self, value: HSTRING) -> HRESULT,
    fn get_Department(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Department(&self, value: HSTRING) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Manager(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Manager(&self, value: HSTRING) -> HRESULT,
    fn get_Office(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Office(&self, value: HSTRING) -> HRESULT,
    fn get_CompanyAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CompanyAddress(&self, value: HSTRING) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactJobInfo {
    #[inline] pub unsafe fn get_company_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CompanyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_company_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CompanyName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_company_yomi_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CompanyYomiName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_company_yomi_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CompanyYomiName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_department(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Department)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_department(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Department)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manager(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Manager)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_manager(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Manager)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_office(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Office)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_office(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Office)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_company_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CompanyAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_company_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CompanyAddress)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactJobInfo: IContactJobInfo}
impl RtActivatable<IActivationFactory> for ContactJobInfo {}
DEFINE_CLSID!(ContactJobInfo(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,74,111,98,73,110,102,111,0]) [CLSID_ContactJobInfo]);
RT_CLASS!{static class ContactLaunchActionVerbs}
impl RtActivatable<IContactLaunchActionVerbsStatics> for ContactLaunchActionVerbs {}
impl ContactLaunchActionVerbs {
    #[inline] pub fn get_call() -> Result<HString> { unsafe {
        <Self as RtActivatable<IContactLaunchActionVerbsStatics>>::get_activation_factory().get_call()
    }}
    #[inline] pub fn get_message() -> Result<HString> { unsafe {
        <Self as RtActivatable<IContactLaunchActionVerbsStatics>>::get_activation_factory().get_message()
    }}
    #[inline] pub fn get_map() -> Result<HString> { unsafe {
        <Self as RtActivatable<IContactLaunchActionVerbsStatics>>::get_activation_factory().get_map()
    }}
    #[inline] pub fn get_post() -> Result<HString> { unsafe {
        <Self as RtActivatable<IContactLaunchActionVerbsStatics>>::get_activation_factory().get_post()
    }}
    #[inline] pub fn get_video_call() -> Result<HString> { unsafe {
        <Self as RtActivatable<IContactLaunchActionVerbsStatics>>::get_activation_factory().get_video_call()
    }}
}
DEFINE_CLSID!(ContactLaunchActionVerbs(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,76,97,117,110,99,104,65,99,116,105,111,110,86,101,114,98,115,0]) [CLSID_ContactLaunchActionVerbs]);
DEFINE_IID!(IID_IContactLaunchActionVerbsStatics, 4212273878, 61043, 18151, 135, 97, 17, 205, 1, 87, 114, 143);
RT_INTERFACE!{static interface IContactLaunchActionVerbsStatics(IContactLaunchActionVerbsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IContactLaunchActionVerbsStatics] {
    fn get_Call(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Message(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Map(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Post(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoCall(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactLaunchActionVerbsStatics {
    #[inline] pub unsafe fn get_call(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Call)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_map(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Map)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_post(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Post)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_call(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoCall)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactList, 383642741, 14636, 18501, 157, 251, 81, 163, 231, 239, 62, 66);
RT_INTERFACE!{interface IContactList(IContactListVtbl): IInspectable(IInspectableVtbl) [IID_IContactList] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_SourceDisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsHidden(&self, out: *mut bool) -> HRESULT,
    fn put_IsHidden(&self, value: bool) -> HRESULT,
    fn get_OtherAppReadAccess(&self, out: *mut ContactListOtherAppReadAccess) -> HRESULT,
    fn put_OtherAppReadAccess(&self, value: ContactListOtherAppReadAccess) -> HRESULT,
    fn get_OtherAppWriteAccess(&self, out: *mut ContactListOtherAppWriteAccess) -> HRESULT,
    fn put_OtherAppWriteAccess(&self, value: ContactListOtherAppWriteAccess) -> HRESULT,
    fn get_ChangeTracker(&self, out: *mut *mut ContactChangeTracker) -> HRESULT,
    fn get_SyncManager(&self, out: *mut *mut ContactListSyncManager) -> HRESULT,
    fn get_SupportsServerSearch(&self, out: *mut bool) -> HRESULT,
    fn get_UserDataAccountId(&self, out: *mut HSTRING) -> HRESULT,
    fn add_ContactChanged(&self, value: *mut super::super::foundation::TypedEventHandler<ContactList, ContactChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ContactChanged(&self, value: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn SaveAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetContactFromRemoteIdAsync(&self, remoteId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn GetMeContactAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn GetContactReader(&self, out: *mut *mut ContactReader) -> HRESULT,
    fn GetContactReaderWithOptions(&self, options: *mut ContactQueryOptions, out: *mut *mut ContactReader) -> HRESULT,
    fn SaveContactAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteContactAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetContactAsync(&self, contactId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT
}}
impl IContactList {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceDisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hidden(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHidden)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_hidden(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHidden)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_other_app_read_access(&self) -> Result<ContactListOtherAppReadAccess> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OtherAppReadAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_other_app_read_access(&self, value: ContactListOtherAppReadAccess) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OtherAppReadAccess)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_other_app_write_access(&self) -> Result<ContactListOtherAppWriteAccess> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OtherAppWriteAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_other_app_write_access(&self, value: ContactListOtherAppWriteAccess) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OtherAppWriteAccess)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_change_tracker(&self) -> Result<ComPtr<ContactChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChangeTracker)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sync_manager(&self) -> Result<ComPtr<ContactListSyncManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SyncManager)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supports_server_search(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportsServerSearch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_data_account_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserDataAccountId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_contact_changed(&self, value: &super::super::foundation::TypedEventHandler<ContactList, ContactChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ContactChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_contact_changed(&self, value: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ContactChanged)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_from_remote_id_async(&self, remoteId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactFromRemoteIdAsync)(self as *const _ as *mut _, remoteId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_me_contact_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMeContactAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_reader(&self) -> Result<ComPtr<ContactReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_reader_with_options(&self, options: &ContactQueryOptions) -> Result<ComPtr<ContactReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactReaderWithOptions)(self as *const _ as *mut _, options as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_contact_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveContactAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_contact_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteContactAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_async(&self, contactId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactAsync)(self as *const _ as *mut _, contactId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactList: IContactList}
DEFINE_IID!(IID_IContactList2, 3409527732, 17744, 19915, 146, 41, 64, 255, 145, 251, 2, 3);
RT_INTERFACE!{interface IContactList2(IContactList2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactList2] {
    fn RegisterSyncManagerAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn put_SupportsServerSearch(&self, value: bool) -> HRESULT,
    fn get_SyncConstraints(&self, out: *mut *mut ContactListSyncConstraints) -> HRESULT
}}
impl IContactList2 {
    #[inline] pub unsafe fn register_sync_manager_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RegisterSyncManagerAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_supports_server_search(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SupportsServerSearch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sync_constraints(&self) -> Result<ComPtr<ContactListSyncConstraints>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SyncConstraints)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactList3, 360246871, 9980, 16872, 168, 80, 90, 163, 37, 20, 172, 169);
RT_INTERFACE!{interface IContactList3(IContactList3Vtbl): IInspectable(IInspectableVtbl) [IID_IContactList3] {
    fn get_LimitedWriteOperations(&self, out: *mut *mut ContactListLimitedWriteOperations) -> HRESULT,
    fn GetChangeTracker(&self, identity: HSTRING, out: *mut *mut ContactChangeTracker) -> HRESULT
}}
impl IContactList3 {
    #[inline] pub unsafe fn get_limited_write_operations(&self) -> Result<ComPtr<ContactListLimitedWriteOperations>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LimitedWriteOperations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_change_tracker(&self, identity: &HStringArg) -> Result<ComPtr<ContactChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChangeTracker)(self as *const _ as *mut _, identity.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactListLimitedWriteOperations, 3784840154, 18955, 17592, 154, 31, 160, 243, 210, 24, 23, 95);
RT_INTERFACE!{interface IContactListLimitedWriteOperations(IContactListLimitedWriteOperationsVtbl): IInspectable(IInspectableVtbl) [IID_IContactListLimitedWriteOperations] {
    fn TryCreateOrUpdateContactAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryDeleteContactAsync(&self, contactId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IContactListLimitedWriteOperations {
    #[inline] pub unsafe fn try_create_or_update_contact_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCreateOrUpdateContactAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_delete_contact_async(&self, contactId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryDeleteContactAsync)(self as *const _ as *mut _, contactId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactListLimitedWriteOperations: IContactListLimitedWriteOperations}
RT_ENUM! { enum ContactListOtherAppReadAccess: i32 {
    SystemOnly (ContactListOtherAppReadAccess_SystemOnly) = 0, Limited (ContactListOtherAppReadAccess_Limited) = 1, Full (ContactListOtherAppReadAccess_Full) = 2, None (ContactListOtherAppReadAccess_None) = 3,
}}
RT_ENUM! { enum ContactListOtherAppWriteAccess: i32 {
    None (ContactListOtherAppWriteAccess_None) = 0, SystemOnly (ContactListOtherAppWriteAccess_SystemOnly) = 1, Limited (ContactListOtherAppWriteAccess_Limited) = 2,
}}
DEFINE_IID!(IID_IContactListSyncConstraints, 2997927681, 12386, 20014, 150, 157, 1, 141, 25, 135, 243, 20);
RT_INTERFACE!{interface IContactListSyncConstraints(IContactListSyncConstraintsVtbl): IInspectable(IInspectableVtbl) [IID_IContactListSyncConstraints] {
    fn get_CanSyncDescriptions(&self, out: *mut bool) -> HRESULT,
    fn put_CanSyncDescriptions(&self, value: bool) -> HRESULT,
    fn get_MaxHomePhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxHomePhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxMobilePhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxMobilePhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxWorkPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxWorkPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxOtherPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxOtherPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxPagerPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxPagerPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxBusinessFaxPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxBusinessFaxPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxHomeFaxPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxHomeFaxPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxCompanyPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxCompanyPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxAssistantPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxAssistantPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxRadioPhoneNumbers(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxRadioPhoneNumbers(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxPersonalEmailAddresses(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxPersonalEmailAddresses(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxWorkEmailAddresses(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxWorkEmailAddresses(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxOtherEmailAddresses(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxOtherEmailAddresses(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxHomeAddresses(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxHomeAddresses(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxWorkAddresses(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxWorkAddresses(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxOtherAddresses(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxOtherAddresses(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxBirthdayDates(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxBirthdayDates(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxAnniversaryDates(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxAnniversaryDates(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxOtherDates(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxOtherDates(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxOtherRelationships(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxOtherRelationships(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxSpouseRelationships(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxSpouseRelationships(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxPartnerRelationships(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxPartnerRelationships(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxSiblingRelationships(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxSiblingRelationships(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxParentRelationships(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxParentRelationships(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxChildRelationships(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxChildRelationships(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxJobInfo(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxJobInfo(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_MaxWebsites(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_MaxWebsites(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT
}}
impl IContactListSyncConstraints {
    #[inline] pub unsafe fn get_can_sync_descriptions(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanSyncDescriptions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_sync_descriptions(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanSyncDescriptions)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_home_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxHomePhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_home_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxHomePhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_mobile_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxMobilePhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_mobile_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxMobilePhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_work_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxWorkPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_work_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxWorkPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_other_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxOtherPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_other_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxOtherPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_pager_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxPagerPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_pager_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxPagerPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_business_fax_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxBusinessFaxPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_business_fax_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxBusinessFaxPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_home_fax_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxHomeFaxPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_home_fax_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxHomeFaxPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_company_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxCompanyPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_company_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxCompanyPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_assistant_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxAssistantPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_assistant_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxAssistantPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_radio_phone_numbers(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxRadioPhoneNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_radio_phone_numbers(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxRadioPhoneNumbers)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_personal_email_addresses(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxPersonalEmailAddresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_personal_email_addresses(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxPersonalEmailAddresses)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_work_email_addresses(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxWorkEmailAddresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_work_email_addresses(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxWorkEmailAddresses)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_other_email_addresses(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxOtherEmailAddresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_other_email_addresses(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxOtherEmailAddresses)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_home_addresses(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxHomeAddresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_home_addresses(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxHomeAddresses)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_work_addresses(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxWorkAddresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_work_addresses(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxWorkAddresses)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_other_addresses(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxOtherAddresses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_other_addresses(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxOtherAddresses)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_birthday_dates(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxBirthdayDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_birthday_dates(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxBirthdayDates)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_anniversary_dates(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxAnniversaryDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_anniversary_dates(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxAnniversaryDates)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_other_dates(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxOtherDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_other_dates(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxOtherDates)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_other_relationships(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxOtherRelationships)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_other_relationships(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxOtherRelationships)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_spouse_relationships(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxSpouseRelationships)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_spouse_relationships(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxSpouseRelationships)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_partner_relationships(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxPartnerRelationships)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_partner_relationships(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxPartnerRelationships)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_sibling_relationships(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxSiblingRelationships)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_sibling_relationships(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxSiblingRelationships)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_parent_relationships(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxParentRelationships)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_parent_relationships(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxParentRelationships)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_child_relationships(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxChildRelationships)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_child_relationships(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxChildRelationships)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_job_info(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxJobInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_job_info(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxJobInfo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_websites(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxWebsites)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_websites(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxWebsites)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactListSyncConstraints: IContactListSyncConstraints}
DEFINE_IID!(IID_IContactListSyncManager, 342787006, 31013, 19148, 157, 229, 33, 221, 208, 111, 134, 116);
RT_INTERFACE!{interface IContactListSyncManager(IContactListSyncManagerVtbl): IInspectable(IInspectableVtbl) [IID_IContactListSyncManager] {
    fn get_Status(&self, out: *mut ContactListSyncStatus) -> HRESULT,
    fn get_LastSuccessfulSyncTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_LastAttemptedSyncTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn SyncAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn add_SyncStatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<ContactListSyncManager, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SyncStatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IContactListSyncManager {
    #[inline] pub unsafe fn get_status(&self) -> Result<ContactListSyncStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_last_successful_sync_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LastSuccessfulSyncTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_last_attempted_sync_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LastAttemptedSyncTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn sync_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SyncAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sync_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<ContactListSyncManager, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SyncStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sync_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SyncStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactListSyncManager: IContactListSyncManager}
DEFINE_IID!(IID_IContactListSyncManager2, 2841186887, 47957, 20003, 129, 40, 55, 1, 52, 168, 93, 13);
RT_INTERFACE!{interface IContactListSyncManager2(IContactListSyncManager2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactListSyncManager2] {
    fn put_Status(&self, value: ContactListSyncStatus) -> HRESULT,
    fn put_LastSuccessfulSyncTime(&self, value: super::super::foundation::DateTime) -> HRESULT,
    fn put_LastAttemptedSyncTime(&self, value: super::super::foundation::DateTime) -> HRESULT
}}
impl IContactListSyncManager2 {
    #[inline] pub unsafe fn set_status(&self, value: ContactListSyncStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Status)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_last_successful_sync_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LastSuccessfulSyncTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_last_attempted_sync_time(&self, value: super::super::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LastAttemptedSyncTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactListSyncStatus: i32 {
    Idle (ContactListSyncStatus_Idle) = 0, Syncing (ContactListSyncStatus_Syncing) = 1, UpToDate (ContactListSyncStatus_UpToDate) = 2, AuthenticationError (ContactListSyncStatus_AuthenticationError) = 3, PolicyError (ContactListSyncStatus_PolicyError) = 4, UnknownError (ContactListSyncStatus_UnknownError) = 5, ManualAccountRemovalRequired (ContactListSyncStatus_ManualAccountRemovalRequired) = 6,
}}
DEFINE_IID!(IID_IContactLocationField, 2663387010, 43886, 19254, 137, 227, 178, 59, 192, 161, 218, 204);
RT_INTERFACE!{interface IContactLocationField(IContactLocationFieldVtbl): IInspectable(IInspectableVtbl) [IID_IContactLocationField] {
    fn get_UnstructuredAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Street(&self, out: *mut HSTRING) -> HRESULT,
    fn get_City(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Region(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Country(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PostalCode(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactLocationField {
    #[inline] pub unsafe fn get_unstructured_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UnstructuredAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_street(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Street)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_city(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_City)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_region(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Region)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_country(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Country)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_postal_code(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PostalCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactLocationField: IContactLocationField}
impl RtActivatable<IContactLocationFieldFactory> for ContactLocationField {}
impl ContactLocationField {
    #[inline] pub fn create_location_default(unstructuredAddress: &HStringArg) -> Result<ComPtr<ContactLocationField>> { unsafe {
        <Self as RtActivatable<IContactLocationFieldFactory>>::get_activation_factory().create_location_default(unstructuredAddress)
    }}
    #[inline] pub fn create_location_category(unstructuredAddress: &HStringArg, category: ContactFieldCategory) -> Result<ComPtr<ContactLocationField>> { unsafe {
        <Self as RtActivatable<IContactLocationFieldFactory>>::get_activation_factory().create_location_category(unstructuredAddress, category)
    }}
    #[inline] pub fn create_location_all(unstructuredAddress: &HStringArg, category: ContactFieldCategory, street: &HStringArg, city: &HStringArg, region: &HStringArg, country: &HStringArg, postalCode: &HStringArg) -> Result<ComPtr<ContactLocationField>> { unsafe {
        <Self as RtActivatable<IContactLocationFieldFactory>>::get_activation_factory().create_location_all(unstructuredAddress, category, street, city, region, country, postalCode)
    }}
}
DEFINE_CLSID!(ContactLocationField(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,76,111,99,97,116,105,111,110,70,105,101,108,100,0]) [CLSID_ContactLocationField]);
DEFINE_IID!(IID_IContactLocationFieldFactory, 4154012375, 12255, 17406, 143, 24, 65, 137, 115, 144, 188, 254);
RT_INTERFACE!{static interface IContactLocationFieldFactory(IContactLocationFieldFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContactLocationFieldFactory] {
    fn CreateLocation_Default(&self, unstructuredAddress: HSTRING, out: *mut *mut ContactLocationField) -> HRESULT,
    fn CreateLocation_Category(&self, unstructuredAddress: HSTRING, category: ContactFieldCategory, out: *mut *mut ContactLocationField) -> HRESULT,
    fn CreateLocation_All(&self, unstructuredAddress: HSTRING, category: ContactFieldCategory, street: HSTRING, city: HSTRING, region: HSTRING, country: HSTRING, postalCode: HSTRING, out: *mut *mut ContactLocationField) -> HRESULT
}}
impl IContactLocationFieldFactory {
    #[inline] pub unsafe fn create_location_default(&self, unstructuredAddress: &HStringArg) -> Result<ComPtr<ContactLocationField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateLocation_Default)(self as *const _ as *mut _, unstructuredAddress.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_location_category(&self, unstructuredAddress: &HStringArg, category: ContactFieldCategory) -> Result<ComPtr<ContactLocationField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateLocation_Category)(self as *const _ as *mut _, unstructuredAddress.get(), category, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_location_all(&self, unstructuredAddress: &HStringArg, category: ContactFieldCategory, street: &HStringArg, city: &HStringArg, region: &HStringArg, country: &HStringArg, postalCode: &HStringArg) -> Result<ComPtr<ContactLocationField>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateLocation_All)(self as *const _ as *mut _, unstructuredAddress.get(), category, street.get(), city.get(), region.get(), country.get(), postalCode.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class ContactManager}
impl RtActivatable<IContactManagerStatics> for ContactManager {}
impl RtActivatable<IContactManagerStatics2> for ContactManager {}
impl RtActivatable<IContactManagerStatics3> for ContactManager {}
impl RtActivatable<IContactManagerStatics4> for ContactManager {}
impl RtActivatable<IContactManagerStatics5> for ContactManager {}
impl ContactManager {
    #[inline] pub fn show_contact_card(contact: &Contact, selection: super::super::foundation::Rect) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics>>::get_activation_factory().show_contact_card(contact, selection)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_contact_card_with_placement(contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics>>::get_activation_factory().show_contact_card_with_placement(contact, selection, preferredPlacement)
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_delay_loaded_contact_card(contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<ContactCardDelayedDataLoader>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics>>::get_activation_factory().show_delay_loaded_contact_card(contact, selection, preferredPlacement)
    }}
    #[inline] pub fn request_store_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactStore>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics2>>::get_activation_factory().request_store_async()
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn convert_contact_to_vcard_async(contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().convert_contact_to_vcard_async(contact)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn convert_contact_to_vcard_async_with_max_bytes(contact: &Contact, maxBytes: u32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().convert_contact_to_vcard_async_with_max_bytes(contact, maxBytes)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn convert_vcard_to_contact_async(vCard: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().convert_vcard_to_contact_async(vCard)
    }}
    #[inline] pub fn request_store_async_with_access_type(accessType: ContactStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactStore>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().request_store_async_with_access_type(accessType)
    }}
    #[inline] pub fn request_annotation_store_async(accessType: ContactAnnotationStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotationStore>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().request_annotation_store_async(accessType)
    }}
    #[inline] pub fn is_show_contact_card_supported() -> Result<bool> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().is_show_contact_card_supported()
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_contact_card_with_options(contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, contactCardOptions: &ContactCardOptions) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().show_contact_card_with_options(contact, selection, preferredPlacement, contactCardOptions)
    }}
    #[inline] pub fn is_show_delay_loaded_contact_card_supported() -> Result<bool> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().is_show_delay_loaded_contact_card_supported()
    }}
    #[cfg(feature="windows-ui")] #[inline] pub fn show_delay_loaded_contact_card_with_options(contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, contactCardOptions: &ContactCardOptions) -> Result<ComPtr<ContactCardDelayedDataLoader>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().show_delay_loaded_contact_card_with_options(contact, selection, preferredPlacement, contactCardOptions)
    }}
    #[inline] pub fn show_full_contact_card(contact: &Contact, fullContactCardOptions: &FullContactCardOptions) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().show_full_contact_card(contact, fullContactCardOptions)
    }}
    #[inline] pub fn get_system_display_name_order() -> Result<ContactNameOrder> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().get_system_display_name_order()
    }}
    #[inline] pub fn set_system_display_name_order(value: ContactNameOrder) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().set_system_display_name_order(value)
    }}
    #[inline] pub fn get_system_sort_order() -> Result<ContactNameOrder> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().get_system_sort_order()
    }}
    #[inline] pub fn set_system_sort_order(value: ContactNameOrder) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics3>>::get_activation_factory().set_system_sort_order(value)
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<ContactManagerForUser>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics4>>::get_activation_factory().get_for_user(user)
    }}
    #[inline] pub fn is_show_full_contact_card_supported_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IContactManagerStatics5>>::get_activation_factory().is_show_full_contact_card_supported_async()
    }}
    #[inline] pub fn get_include_middle_name_in_system_display_and_sort() -> Result<bool> { unsafe {
        <Self as RtActivatable<IContactManagerStatics5>>::get_activation_factory().get_include_middle_name_in_system_display_and_sort()
    }}
    #[inline] pub fn set_include_middle_name_in_system_display_and_sort(value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IContactManagerStatics5>>::get_activation_factory().set_include_middle_name_in_system_display_and_sort(value)
    }}
}
DEFINE_CLSID!(ContactManager(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,77,97,110,97,103,101,114,0]) [CLSID_ContactManager]);
DEFINE_IID!(IID_IContactManagerForUser, 3075193431, 4214, 19439, 174, 243, 84, 104, 109, 24, 56, 125);
RT_INTERFACE!{interface IContactManagerForUser(IContactManagerForUserVtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerForUser] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn ConvertContactToVCardAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn ConvertContactToVCardAsyncWithMaxBytes(&self, contact: *mut Contact, maxBytes: u32, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn ConvertVCardToContactAsync(&self, vCard: *mut super::super::storage::streams::IRandomAccessStreamReference, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn RequestStoreAsync(&self, accessType: ContactStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<ContactStore>) -> HRESULT,
    fn RequestAnnotationStoreAsync(&self, accessType: ContactAnnotationStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<ContactAnnotationStore>) -> HRESULT,
    fn get_SystemDisplayNameOrder(&self, out: *mut ContactNameOrder) -> HRESULT,
    fn put_SystemDisplayNameOrder(&self, value: ContactNameOrder) -> HRESULT,
    fn get_SystemSortOrder(&self, out: *mut ContactNameOrder) -> HRESULT,
    fn put_SystemSortOrder(&self, value: ContactNameOrder) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IContactManagerForUser {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn convert_contact_to_vcard_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConvertContactToVCardAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn convert_contact_to_vcard_async_with_max_bytes(&self, contact: &Contact, maxBytes: u32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConvertContactToVCardAsyncWithMaxBytes)(self as *const _ as *mut _, contact as *const _ as *mut _, maxBytes, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn convert_vcard_to_contact_async(&self, vCard: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConvertVCardToContactAsync)(self as *const _ as *mut _, vCard as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_store_async(&self, accessType: ContactStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, accessType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_annotation_store_async(&self, accessType: ContactAnnotationStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotationStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAnnotationStoreAsync)(self as *const _ as *mut _, accessType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_display_name_order(&self) -> Result<ContactNameOrder> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemDisplayNameOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_display_name_order(&self, value: ContactNameOrder) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemDisplayNameOrder)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_sort_order(&self) -> Result<ContactNameOrder> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemSortOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_sort_order(&self, value: ContactNameOrder) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemSortOrder)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactManagerForUser: IContactManagerForUser}
DEFINE_IID!(IID_IContactManagerForUser2, 1296473134, 15221, 19059, 187, 48, 115, 102, 69, 71, 34, 86);
RT_INTERFACE!{interface IContactManagerForUser2(IContactManagerForUser2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerForUser2] {
    fn ShowFullContactCard(&self, contact: *mut Contact, fullContactCardOptions: *mut FullContactCardOptions) -> HRESULT
}}
impl IContactManagerForUser2 {
    #[inline] pub unsafe fn show_full_contact_card(&self, contact: &Contact, fullContactCardOptions: &FullContactCardOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowFullContactCard)(self as *const _ as *mut _, contact as *const _ as *mut _, fullContactCardOptions as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactManagerStatics, 2180127424, 63073, 18184, 186, 79, 211, 134, 189, 13, 98, 46);
RT_INTERFACE!{static interface IContactManagerStatics(IContactManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerStatics] {
    fn ShowContactCard(&self, contact: *mut Contact, selection: super::super::foundation::Rect) -> HRESULT,
    #[cfg(feature="windows-ui")] fn ShowContactCardWithPlacement(&self, contact: *mut Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> HRESULT,
    #[cfg(feature="windows-ui")] fn ShowDelayLoadedContactCard(&self, contact: *mut Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, out: *mut *mut ContactCardDelayedDataLoader) -> HRESULT
}}
impl IContactManagerStatics {
    #[inline] pub unsafe fn show_contact_card(&self, contact: &Contact, selection: super::super::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowContactCard)(self as *const _ as *mut _, contact as *const _ as *mut _, selection);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_contact_card_with_placement(&self, contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowContactCardWithPlacement)(self as *const _ as *mut _, contact as *const _ as *mut _, selection, preferredPlacement);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_delay_loaded_contact_card(&self, contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<ComPtr<ContactCardDelayedDataLoader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowDelayLoadedContactCard)(self as *const _ as *mut _, contact as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactManagerStatics2, 2709055008, 18392, 18636, 150, 60, 149, 146, 182, 229, 16, 198);
RT_INTERFACE!{static interface IContactManagerStatics2(IContactManagerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerStatics2] {
    fn RequestStoreAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ContactStore>) -> HRESULT
}}
impl IContactManagerStatics2 {
    #[inline] pub unsafe fn request_store_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactManagerStatics3, 3301719362, 30086, 18730, 147, 11, 123, 193, 56, 252, 33, 57);
RT_INTERFACE!{static interface IContactManagerStatics3(IContactManagerStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerStatics3] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn ConvertContactToVCardAsync(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn ConvertContactToVCardAsyncWithMaxBytes(&self, contact: *mut Contact, maxBytes: u32, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn ConvertVCardToContactAsync(&self, vCard: *mut super::super::storage::streams::IRandomAccessStreamReference, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn RequestStoreAsyncWithAccessType(&self, accessType: ContactStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<ContactStore>) -> HRESULT,
    fn RequestAnnotationStoreAsync(&self, accessType: ContactAnnotationStoreAccessType, out: *mut *mut super::super::foundation::IAsyncOperation<ContactAnnotationStore>) -> HRESULT,
    fn IsShowContactCardSupported(&self, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowContactCardWithOptions(&self, contact: *mut Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, contactCardOptions: *mut ContactCardOptions) -> HRESULT,
    fn IsShowDelayLoadedContactCardSupported(&self, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowDelayLoadedContactCardWithOptions(&self, contact: *mut Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, contactCardOptions: *mut ContactCardOptions, out: *mut *mut ContactCardDelayedDataLoader) -> HRESULT,
    fn ShowFullContactCard(&self, contact: *mut Contact, fullContactCardOptions: *mut FullContactCardOptions) -> HRESULT,
    fn get_SystemDisplayNameOrder(&self, out: *mut ContactNameOrder) -> HRESULT,
    fn put_SystemDisplayNameOrder(&self, value: ContactNameOrder) -> HRESULT,
    fn get_SystemSortOrder(&self, out: *mut ContactNameOrder) -> HRESULT,
    fn put_SystemSortOrder(&self, value: ContactNameOrder) -> HRESULT
}}
impl IContactManagerStatics3 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn convert_contact_to_vcard_async(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConvertContactToVCardAsync)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn convert_contact_to_vcard_async_with_max_bytes(&self, contact: &Contact, maxBytes: u32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::RandomAccessStreamReference>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConvertContactToVCardAsyncWithMaxBytes)(self as *const _ as *mut _, contact as *const _ as *mut _, maxBytes, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn convert_vcard_to_contact_async(&self, vCard: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConvertVCardToContactAsync)(self as *const _ as *mut _, vCard as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_store_async_with_access_type(&self, accessType: ContactStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStoreAsyncWithAccessType)(self as *const _ as *mut _, accessType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_annotation_store_async(&self, accessType: ContactAnnotationStoreAccessType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactAnnotationStore>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAnnotationStoreAsync)(self as *const _ as *mut _, accessType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_show_contact_card_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsShowContactCardSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_contact_card_with_options(&self, contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, contactCardOptions: &ContactCardOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowContactCardWithOptions)(self as *const _ as *mut _, contact as *const _ as *mut _, selection, preferredPlacement, contactCardOptions as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_show_delay_loaded_contact_card_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsShowDelayLoadedContactCardSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_delay_loaded_contact_card_with_options(&self, contact: &Contact, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement, contactCardOptions: &ContactCardOptions) -> Result<ComPtr<ContactCardDelayedDataLoader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowDelayLoadedContactCardWithOptions)(self as *const _ as *mut _, contact as *const _ as *mut _, selection, preferredPlacement, contactCardOptions as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_full_contact_card(&self, contact: &Contact, fullContactCardOptions: &FullContactCardOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowFullContactCard)(self as *const _ as *mut _, contact as *const _ as *mut _, fullContactCardOptions as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_display_name_order(&self) -> Result<ContactNameOrder> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemDisplayNameOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_display_name_order(&self, value: ContactNameOrder) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemDisplayNameOrder)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_sort_order(&self) -> Result<ContactNameOrder> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemSortOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_sort_order(&self, value: ContactNameOrder) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemSortOrder)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactManagerStatics4, 613950066, 13435, 18140, 141, 149, 81, 189, 65, 225, 90, 175);
RT_INTERFACE!{static interface IContactManagerStatics4(IContactManagerStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerStatics4] {
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut ContactManagerForUser) -> HRESULT
}}
impl IContactManagerStatics4 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<ContactManagerForUser>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactManagerStatics5, 4149811847, 44215, 20397, 144, 242, 168, 171, 100, 205, 187, 164);
RT_INTERFACE!{static interface IContactManagerStatics5(IContactManagerStatics5Vtbl): IInspectable(IInspectableVtbl) [IID_IContactManagerStatics5] {
    fn IsShowFullContactCardSupportedAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn get_IncludeMiddleNameInSystemDisplayAndSort(&self, out: *mut bool) -> HRESULT,
    fn put_IncludeMiddleNameInSystemDisplayAndSort(&self, value: bool) -> HRESULT
}}
impl IContactManagerStatics5 {
    #[inline] pub unsafe fn is_show_full_contact_card_supported_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).IsShowFullContactCardSupportedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_include_middle_name_in_system_display_and_sort(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IncludeMiddleNameInSystemDisplayAndSort)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_include_middle_name_in_system_display_and_sort(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IncludeMiddleNameInSystemDisplayAndSort)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactMatchReason, 3163694340, 59352, 16702, 149, 244, 183, 92, 84, 199, 64, 119);
RT_INTERFACE!{interface IContactMatchReason(IContactMatchReasonVtbl): IInspectable(IInspectableVtbl) [IID_IContactMatchReason] {
    fn get_Field(&self, out: *mut ContactMatchReasonKind) -> HRESULT,
    #[cfg(not(feature="windows-data"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-data")] fn get_Segments(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::data::text::TextSegment>) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactMatchReason {
    #[inline] pub unsafe fn get_field(&self) -> Result<ContactMatchReasonKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Field)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn get_segments(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::data::text::TextSegment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Segments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactMatchReason: IContactMatchReason}
RT_ENUM! { enum ContactMatchReasonKind: i32 {
    Name (ContactMatchReasonKind_Name) = 0, EmailAddress (ContactMatchReasonKind_EmailAddress) = 1, PhoneNumber (ContactMatchReasonKind_PhoneNumber) = 2, JobInfo (ContactMatchReasonKind_JobInfo) = 3, YomiName (ContactMatchReasonKind_YomiName) = 4, Other (ContactMatchReasonKind_Other) = 5,
}}
DEFINE_IID!(IID_IContactName, 4093962619, 36916, 17724, 142, 191, 20, 10, 56, 200, 111, 29);
RT_INTERFACE!{interface IContactName(IContactNameVtbl): IInspectable(IInspectableVtbl) [IID_IContactName] {
    fn get_FirstName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_FirstName(&self, value: HSTRING) -> HRESULT,
    fn get_LastName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_LastName(&self, value: HSTRING) -> HRESULT,
    fn get_MiddleName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_MiddleName(&self, value: HSTRING) -> HRESULT,
    fn get_YomiGivenName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_YomiGivenName(&self, value: HSTRING) -> HRESULT,
    fn get_YomiFamilyName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_YomiFamilyName(&self, value: HSTRING) -> HRESULT,
    fn get_HonorificNameSuffix(&self, out: *mut HSTRING) -> HRESULT,
    fn put_HonorificNameSuffix(&self, value: HSTRING) -> HRESULT,
    fn get_HonorificNamePrefix(&self, out: *mut HSTRING) -> HRESULT,
    fn put_HonorificNamePrefix(&self, value: HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_YomiDisplayName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IContactName {
    #[inline] pub unsafe fn get_first_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_first_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_last_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LastName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_last_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LastName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_middle_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MiddleName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_middle_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MiddleName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_yomi_given_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YomiGivenName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_yomi_given_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_YomiGivenName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_yomi_family_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YomiFamilyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_yomi_family_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_YomiFamilyName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_honorific_name_suffix(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HonorificNameSuffix)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_honorific_name_suffix(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HonorificNameSuffix)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_honorific_name_prefix(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HonorificNamePrefix)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_honorific_name_prefix(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HonorificNamePrefix)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_yomi_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YomiDisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactNameOrder: i32 {
    FirstNameLastName (ContactNameOrder_FirstNameLastName) = 0, LastNameFirstName (ContactNameOrder_LastNameFirstName) = 1,
}}
DEFINE_IID!(IID_IContactPanel, 1103041125, 53998, 19351, 168, 10, 125, 141, 100, 204, 166, 245);
RT_INTERFACE!{interface IContactPanel(IContactPanelVtbl): IInspectable(IInspectableVtbl) [IID_IContactPanel] {
    fn ClosePanel(&self) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_HeaderColor(&self, out: *mut *mut super::super::foundation::IReference<super::super::ui::Color>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_HeaderColor(&self, value: *mut super::super::foundation::IReference<super::super::ui::Color>) -> HRESULT,
    fn add_LaunchFullAppRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<ContactPanel, ContactPanelLaunchFullAppRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LaunchFullAppRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closing(&self, handler: *mut super::super::foundation::TypedEventHandler<ContactPanel, ContactPanelClosingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closing(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IContactPanel {
    #[inline] pub unsafe fn close_panel(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ClosePanel)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_header_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::ui::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_header_color(&self, value: &super::super::foundation::IReference<super::super::ui::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_launch_full_app_requested(&self, handler: &super::super::foundation::TypedEventHandler<ContactPanel, ContactPanelLaunchFullAppRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LaunchFullAppRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_launch_full_app_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LaunchFullAppRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closing(&self, handler: &super::super::foundation::TypedEventHandler<ContactPanel, ContactPanelClosingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closing(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closing)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPanel: IContactPanel}
DEFINE_IID!(IID_IContactPanelClosingEventArgs, 572617939, 53067, 18135, 183, 57, 110, 220, 22, 17, 11, 251);
RT_INTERFACE!{interface IContactPanelClosingEventArgs(IContactPanelClosingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactPanelClosingEventArgs] {
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl IContactPanelClosingEventArgs {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPanelClosingEventArgs: IContactPanelClosingEventArgs}
DEFINE_IID!(IID_IContactPanelLaunchFullAppRequestedEventArgs, 2295733262, 9140, 19432, 138, 252, 7, 44, 37, 164, 25, 13);
RT_INTERFACE!{interface IContactPanelLaunchFullAppRequestedEventArgs(IContactPanelLaunchFullAppRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContactPanelLaunchFullAppRequestedEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl IContactPanelLaunchFullAppRequestedEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPanelLaunchFullAppRequestedEventArgs: IContactPanelLaunchFullAppRequestedEventArgs}
DEFINE_IID!(IID_IContactPhone, 1182640997, 10002, 20306, 183, 131, 158, 168, 17, 28, 99, 205);
RT_INTERFACE!{interface IContactPhone(IContactPhoneVtbl): IInspectable(IInspectableVtbl) [IID_IContactPhone] {
    fn get_Number(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Number(&self, value: HSTRING) -> HRESULT,
    fn get_Kind(&self, out: *mut ContactPhoneKind) -> HRESULT,
    fn put_Kind(&self, value: ContactPhoneKind) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactPhone {
    #[inline] pub unsafe fn get_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Number)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_number(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Number)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<ContactPhoneKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_kind(&self, value: ContactPhoneKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Kind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPhone: IContactPhone}
impl RtActivatable<IActivationFactory> for ContactPhone {}
DEFINE_CLSID!(ContactPhone(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,80,104,111,110,101,0]) [CLSID_ContactPhone]);
RT_ENUM! { enum ContactPhoneKind: i32 {
    Home (ContactPhoneKind_Home) = 0, Mobile (ContactPhoneKind_Mobile) = 1, Work (ContactPhoneKind_Work) = 2, Other (ContactPhoneKind_Other) = 3, Pager (ContactPhoneKind_Pager) = 4, BusinessFax (ContactPhoneKind_BusinessFax) = 5, HomeFax (ContactPhoneKind_HomeFax) = 6, Company (ContactPhoneKind_Company) = 7, Assistant (ContactPhoneKind_Assistant) = 8, Radio (ContactPhoneKind_Radio) = 9,
}}
DEFINE_IID!(IID_IContactPicker, 235535761, 17144, 16469, 144, 160, 137, 111, 150, 115, 137, 54);
RT_INTERFACE!{interface IContactPicker(IContactPickerVtbl): IInspectable(IInspectableVtbl) [IID_IContactPicker] {
    fn get_CommitButtonText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CommitButtonText(&self, value: HSTRING) -> HRESULT,
    fn get_SelectionMode(&self, out: *mut ContactSelectionMode) -> HRESULT,
    fn put_SelectionMode(&self, value: ContactSelectionMode) -> HRESULT,
    fn get_DesiredFields(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn PickSingleContactAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ContactInformation>) -> HRESULT,
    fn PickMultipleContactsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactInformation>>) -> HRESULT
}}
impl IContactPicker {
    #[inline] pub unsafe fn get_commit_button_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommitButtonText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_commit_button_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CommitButtonText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selection_mode(&self) -> Result<ContactSelectionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selection_mode(&self, value: ContactSelectionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_fields(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DesiredFields)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pick_single_contact_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactInformation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PickSingleContactAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pick_multiple_contacts_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactInformation>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PickMultipleContactsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactPicker: IContactPicker}
impl RtActivatable<IContactPickerStatics> for ContactPicker {}
impl RtActivatable<IActivationFactory> for ContactPicker {}
impl ContactPicker {
    #[cfg(feature="windows-system")] #[inline] pub fn create_for_user(user: &super::super::system::User) -> Result<ComPtr<ContactPicker>> { unsafe {
        <Self as RtActivatable<IContactPickerStatics>>::get_activation_factory().create_for_user(user)
    }}
    #[inline] pub fn is_supported_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IContactPickerStatics>>::get_activation_factory().is_supported_async()
    }}
}
DEFINE_CLSID!(ContactPicker(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,80,105,99,107,101,114,0]) [CLSID_ContactPicker]);
DEFINE_IID!(IID_IContactPicker2, 3008369103, 23791, 19748, 170, 12, 52, 12, 82, 8, 114, 93);
RT_INTERFACE!{interface IContactPicker2(IContactPicker2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactPicker2] {
    fn get_DesiredFieldsWithContactFieldType(&self, out: *mut *mut super::super::foundation::collections::IVector<ContactFieldType>) -> HRESULT,
    fn PickContactAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn PickContactsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVector<Contact>>) -> HRESULT
}}
impl IContactPicker2 {
    #[inline] pub unsafe fn get_desired_fields_with_contact_field_type(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ContactFieldType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DesiredFieldsWithContactFieldType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pick_contact_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PickContactAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pick_contacts_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVector<Contact>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PickContactsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactPicker3, 242365205, 45635, 19437, 133, 22, 34, 177, 167, 172, 10, 206);
RT_INTERFACE!{interface IContactPicker3(IContactPicker3Vtbl): IInspectable(IInspectableVtbl) [IID_IContactPicker3] {
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IContactPicker3 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactPickerStatics, 1955119145, 27219, 16984, 163, 233, 98, 223, 246, 120, 75, 108);
RT_INTERFACE!{static interface IContactPickerStatics(IContactPickerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IContactPickerStatics] {
    #[cfg(not(feature="windows-system"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-system")] fn CreateForUser(&self, user: *mut super::super::system::User, out: *mut *mut ContactPicker) -> HRESULT,
    fn IsSupportedAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IContactPickerStatics {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn create_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<ContactPicker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_supported_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).IsSupportedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactQueryDesiredFields: u32 {
    None (ContactQueryDesiredFields_None) = 0, PhoneNumber (ContactQueryDesiredFields_PhoneNumber) = 1, EmailAddress (ContactQueryDesiredFields_EmailAddress) = 2, PostalAddress (ContactQueryDesiredFields_PostalAddress) = 4,
}}
DEFINE_IID!(IID_IContactQueryOptions, 1141427358, 32124, 17136, 138, 199, 245, 7, 51, 236, 219, 193);
RT_INTERFACE!{interface IContactQueryOptions(IContactQueryOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IContactQueryOptions] {
    fn get_TextSearch(&self, out: *mut *mut ContactQueryTextSearch) -> HRESULT,
    fn get_ContactListIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_IncludeContactsFromHiddenLists(&self, out: *mut bool) -> HRESULT,
    fn put_IncludeContactsFromHiddenLists(&self, value: bool) -> HRESULT,
    fn get_DesiredFields(&self, out: *mut ContactQueryDesiredFields) -> HRESULT,
    fn put_DesiredFields(&self, value: ContactQueryDesiredFields) -> HRESULT,
    fn get_DesiredOperations(&self, out: *mut ContactAnnotationOperations) -> HRESULT,
    fn put_DesiredOperations(&self, value: ContactAnnotationOperations) -> HRESULT,
    fn get_AnnotationListIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IContactQueryOptions {
    #[inline] pub unsafe fn get_text_search(&self) -> Result<ComPtr<ContactQueryTextSearch>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextSearch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_list_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContactListIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_include_contacts_from_hidden_lists(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IncludeContactsFromHiddenLists)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_include_contacts_from_hidden_lists(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IncludeContactsFromHiddenLists)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_fields(&self) -> Result<ContactQueryDesiredFields> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredFields)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_fields(&self, value: ContactQueryDesiredFields) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredFields)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_operations(&self) -> Result<ContactAnnotationOperations> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredOperations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_operations(&self, value: ContactAnnotationOperations) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredOperations)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_annotation_list_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AnnotationListIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactQueryOptions: IContactQueryOptions}
impl RtActivatable<IContactQueryOptionsFactory> for ContactQueryOptions {}
impl RtActivatable<IActivationFactory> for ContactQueryOptions {}
impl ContactQueryOptions {
    #[inline] pub fn create_with_text(text: &HStringArg) -> Result<ComPtr<ContactQueryOptions>> { unsafe {
        <Self as RtActivatable<IContactQueryOptionsFactory>>::get_activation_factory().create_with_text(text)
    }}
    #[inline] pub fn create_with_text_and_fields(text: &HStringArg, fields: ContactQuerySearchFields) -> Result<ComPtr<ContactQueryOptions>> { unsafe {
        <Self as RtActivatable<IContactQueryOptionsFactory>>::get_activation_factory().create_with_text_and_fields(text, fields)
    }}
}
DEFINE_CLSID!(ContactQueryOptions(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,81,117,101,114,121,79,112,116,105,111,110,115,0]) [CLSID_ContactQueryOptions]);
DEFINE_IID!(IID_IContactQueryOptionsFactory, 1413462599, 36071, 18123, 157, 172, 154, 164, 42, 27, 200, 226);
RT_INTERFACE!{static interface IContactQueryOptionsFactory(IContactQueryOptionsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContactQueryOptionsFactory] {
    fn CreateWithText(&self, text: HSTRING, out: *mut *mut ContactQueryOptions) -> HRESULT,
    fn CreateWithTextAndFields(&self, text: HSTRING, fields: ContactQuerySearchFields, out: *mut *mut ContactQueryOptions) -> HRESULT
}}
impl IContactQueryOptionsFactory {
    #[inline] pub unsafe fn create_with_text(&self, text: &HStringArg) -> Result<ComPtr<ContactQueryOptions>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithText)(self as *const _ as *mut _, text.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_text_and_fields(&self, text: &HStringArg, fields: ContactQuerySearchFields) -> Result<ComPtr<ContactQueryOptions>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithTextAndFields)(self as *const _ as *mut _, text.get(), fields, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactQuerySearchFields: u32 {
    None (ContactQuerySearchFields_None) = 0, Name (ContactQuerySearchFields_Name) = 1, Email (ContactQuerySearchFields_Email) = 2, Phone (ContactQuerySearchFields_Phone) = 4, All (ContactQuerySearchFields_All) = 4294967295,
}}
RT_ENUM! { enum ContactQuerySearchScope: i32 {
    Local (ContactQuerySearchScope_Local) = 0, Server (ContactQuerySearchScope_Server) = 1,
}}
DEFINE_IID!(IID_IContactQueryTextSearch, 4158912971, 43351, 17307, 160, 183, 28, 2, 161, 150, 63, 240);
RT_INTERFACE!{interface IContactQueryTextSearch(IContactQueryTextSearchVtbl): IInspectable(IInspectableVtbl) [IID_IContactQueryTextSearch] {
    fn get_Fields(&self, out: *mut ContactQuerySearchFields) -> HRESULT,
    fn put_Fields(&self, value: ContactQuerySearchFields) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn get_SearchScope(&self, out: *mut ContactQuerySearchScope) -> HRESULT,
    fn put_SearchScope(&self, value: ContactQuerySearchScope) -> HRESULT
}}
impl IContactQueryTextSearch {
    #[inline] pub unsafe fn get_fields(&self) -> Result<ContactQuerySearchFields> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Fields)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_fields(&self, value: ContactQuerySearchFields) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Fields)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_scope(&self) -> Result<ContactQuerySearchScope> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SearchScope)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_search_scope(&self, value: ContactQuerySearchScope) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SearchScope)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactQueryTextSearch: IContactQueryTextSearch}
DEFINE_IID!(IID_IContactReader, 3549946926, 5256, 17138, 191, 100, 37, 63, 72, 132, 191, 237);
RT_INTERFACE!{interface IContactReader(IContactReaderVtbl): IInspectable(IInspectableVtbl) [IID_IContactReader] {
    fn ReadBatchAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<ContactBatch>) -> HRESULT,
    fn GetMatchingPropertiesWithMatchReason(&self, contact: *mut Contact, out: *mut *mut super::super::foundation::collections::IVectorView<ContactMatchReason>) -> HRESULT
}}
impl IContactReader {
    #[inline] pub unsafe fn read_batch_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactBatch>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadBatchAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_matching_properties_with_match_reason(&self, contact: &Contact) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ContactMatchReason>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMatchingPropertiesWithMatchReason)(self as *const _ as *mut _, contact as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactReader: IContactReader}
RT_ENUM! { enum ContactRelationship: i32 {
    Other (ContactRelationship_Other) = 0, Spouse (ContactRelationship_Spouse) = 1, Partner (ContactRelationship_Partner) = 2, Sibling (ContactRelationship_Sibling) = 3, Parent (ContactRelationship_Parent) = 4, Child (ContactRelationship_Child) = 5,
}}
RT_ENUM! { enum ContactSelectionMode: i32 {
    Contacts (ContactSelectionMode_Contacts) = 0, Fields (ContactSelectionMode_Fields) = 1,
}}
DEFINE_IID!(IID_IContactSignificantOther, 2289284523, 50683, 18136, 147, 254, 218, 63, 241, 147, 64, 84);
RT_INTERFACE!{interface IContactSignificantOther(IContactSignificantOtherVtbl): IInspectable(IInspectableVtbl) [IID_IContactSignificantOther] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactSignificantOther {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactSignificantOther: IContactSignificantOther}
impl RtActivatable<IActivationFactory> for ContactSignificantOther {}
DEFINE_CLSID!(ContactSignificantOther(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,83,105,103,110,105,102,105,99,97,110,116,79,116,104,101,114,0]) [CLSID_ContactSignificantOther]);
DEFINE_IID!(IID_IContactSignificantOther2, 2373702772, 16131, 17912, 186, 15, 196, 237, 55, 214, 66, 25);
RT_INTERFACE!{interface IContactSignificantOther2(IContactSignificantOther2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactSignificantOther2] {
    fn get_Relationship(&self, out: *mut ContactRelationship) -> HRESULT,
    fn put_Relationship(&self, value: ContactRelationship) -> HRESULT
}}
impl IContactSignificantOther2 {
    #[inline] pub unsafe fn get_relationship(&self) -> Result<ContactRelationship> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Relationship)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_relationship(&self, value: ContactRelationship) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Relationship)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactStore, 740428560, 14956, 17043, 185, 188, 254, 152, 127, 110, 13, 82);
RT_INTERFACE!{interface IContactStore(IContactStoreVtbl): IInspectable(IInspectableVtbl) [IID_IContactStore] {
    fn FindContactsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Contact>>) -> HRESULT,
    fn FindContactsWithSearchTextAsync(&self, searchText: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Contact>>) -> HRESULT,
    fn GetContactAsync(&self, contactId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT
}}
impl IContactStore {
    #[inline] pub unsafe fn find_contacts_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Contact>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindContactsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_contacts_with_search_text_async(&self, searchText: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Contact>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindContactsWithSearchTextAsync)(self as *const _ as *mut _, searchText.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_async(&self, contactId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactAsync)(self as *const _ as *mut _, contactId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContactStore: IContactStore}
DEFINE_IID!(IID_IContactStore2, 416160802, 60373, 19451, 182, 144, 95, 79, 39, 196, 240, 232);
RT_INTERFACE!{interface IContactStore2(IContactStore2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactStore2] {
    fn get_ChangeTracker(&self, out: *mut *mut ContactChangeTracker) -> HRESULT,
    fn add_ContactChanged(&self, value: *mut super::super::foundation::TypedEventHandler<ContactStore, ContactChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ContactChanged(&self, value: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_AggregateContactManager(&self, out: *mut *mut AggregateContactManager) -> HRESULT,
    fn FindContactListsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactList>>) -> HRESULT,
    fn GetContactListAsync(&self, contactListId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ContactList>) -> HRESULT,
    fn CreateContactListAsync(&self, displayName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ContactList>) -> HRESULT,
    fn GetMeContactAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<Contact>) -> HRESULT,
    fn GetContactReader(&self, out: *mut *mut ContactReader) -> HRESULT,
    fn GetContactReaderWithOptions(&self, options: *mut ContactQueryOptions, out: *mut *mut ContactReader) -> HRESULT,
    fn CreateContactListInAccountAsync(&self, displayName: HSTRING, userDataAccountId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<ContactList>) -> HRESULT
}}
impl IContactStore2 {
    #[inline] pub unsafe fn get_change_tracker(&self) -> Result<ComPtr<ContactChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChangeTracker)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_contact_changed(&self, value: &super::super::foundation::TypedEventHandler<ContactStore, ContactChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ContactChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_contact_changed(&self, value: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ContactChanged)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_aggregate_contact_manager(&self) -> Result<ComPtr<AggregateContactManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AggregateContactManager)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_contact_lists_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<ContactList>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindContactListsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_list_async(&self, contactListId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactListAsync)(self as *const _ as *mut _, contactListId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_contact_list_async(&self, displayName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateContactListAsync)(self as *const _ as *mut _, displayName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_me_contact_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Contact>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMeContactAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_reader(&self) -> Result<ComPtr<ContactReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_reader_with_options(&self, options: &ContactQueryOptions) -> Result<ComPtr<ContactReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetContactReaderWithOptions)(self as *const _ as *mut _, options as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_contact_list_in_account_async(&self, displayName: &HStringArg, userDataAccountId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ContactList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateContactListInAccountAsync)(self as *const _ as *mut _, displayName.get(), userDataAccountId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContactStore3, 3414699116, 78, 16464, 135, 240, 132, 4, 7, 238, 104, 24);
RT_INTERFACE!{interface IContactStore3(IContactStore3Vtbl): IInspectable(IInspectableVtbl) [IID_IContactStore3] {
    fn GetChangeTracker(&self, identity: HSTRING, out: *mut *mut ContactChangeTracker) -> HRESULT
}}
impl IContactStore3 {
    #[inline] pub unsafe fn get_change_tracker(&self, identity: &HStringArg) -> Result<ComPtr<ContactChangeTracker>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChangeTracker)(self as *const _ as *mut _, identity.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContactStoreAccessType: i32 {
    AppContactsReadWrite (ContactStoreAccessType_AppContactsReadWrite) = 0, AllContactsReadOnly (ContactStoreAccessType_AllContactsReadOnly) = 1, AllContactsReadWrite (ContactStoreAccessType_AllContactsReadWrite) = 2,
}}
DEFINE_IID!(IID_IContactStoreNotificationTriggerDetails, 2880608470, 34698, 20363, 169, 206, 70, 187, 125, 28, 132, 206);
RT_INTERFACE!{interface IContactStoreNotificationTriggerDetails(IContactStoreNotificationTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IContactStoreNotificationTriggerDetails] {
    
}}
RT_CLASS!{class ContactStoreNotificationTriggerDetails: IContactStoreNotificationTriggerDetails}
DEFINE_IID!(IID_IContactWebsite, 2668822902, 56347, 16469, 173, 102, 101, 47, 57, 217, 144, 232);
RT_INTERFACE!{interface IContactWebsite(IContactWebsiteVtbl): IInspectable(IInspectableVtbl) [IID_IContactWebsite] {
    fn get_Uri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Uri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT
}}
impl IContactWebsite {
    #[inline] pub unsafe fn get_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Uri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Uri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContactWebsite: IContactWebsite}
impl RtActivatable<IActivationFactory> for ContactWebsite {}
DEFINE_CLSID!(ContactWebsite(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,67,111,110,116,97,99,116,87,101,98,115,105,116,101,0]) [CLSID_ContactWebsite]);
DEFINE_IID!(IID_IContactWebsite2, 4169066782, 22087, 16488, 187, 94, 75, 111, 67, 124, 227, 8);
RT_INTERFACE!{interface IContactWebsite2(IContactWebsite2Vtbl): IInspectable(IInspectableVtbl) [IID_IContactWebsite2] {
    fn get_RawValue(&self, out: *mut HSTRING) -> HRESULT,
    fn put_RawValue(&self, value: HSTRING) -> HRESULT
}}
impl IContactWebsite2 {
    #[inline] pub unsafe fn get_raw_value(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RawValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_raw_value(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RawValue)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFullContactCardOptions, 2269397868, 23801, 18051, 189, 202, 161, 253, 235, 248, 219, 206);
RT_INTERFACE!{interface IFullContactCardOptions(IFullContactCardOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IFullContactCardOptions] {
    #[cfg(feature="windows-ui")] fn get_DesiredRemainingView(&self, out: *mut super::super::ui::viewmanagement::ViewSizePreference) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_DesiredRemainingView(&self, value: super::super::ui::viewmanagement::ViewSizePreference) -> HRESULT
}}
impl IFullContactCardOptions {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_desired_remaining_view(&self) -> Result<super::super::ui::viewmanagement::ViewSizePreference> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredRemainingView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_desired_remaining_view(&self, value: super::super::ui::viewmanagement::ViewSizePreference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredRemainingView)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FullContactCardOptions: IFullContactCardOptions}
impl RtActivatable<IActivationFactory> for FullContactCardOptions {}
DEFINE_CLSID!(FullContactCardOptions(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,70,117,108,108,67,111,110,116,97,99,116,67,97,114,100,79,112,116,105,111,110,115,0]) [CLSID_FullContactCardOptions]);
RT_CLASS!{static class KnownContactField}
impl RtActivatable<IKnownContactFieldStatics> for KnownContactField {}
impl KnownContactField {
    #[inline] pub fn get_email() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownContactFieldStatics>>::get_activation_factory().get_email()
    }}
    #[inline] pub fn get_phone_number() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownContactFieldStatics>>::get_activation_factory().get_phone_number()
    }}
    #[inline] pub fn get_location() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownContactFieldStatics>>::get_activation_factory().get_location()
    }}
    #[inline] pub fn get_instant_message() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownContactFieldStatics>>::get_activation_factory().get_instant_message()
    }}
    #[inline] pub fn convert_name_to_type(name: &HStringArg) -> Result<ContactFieldType> { unsafe {
        <Self as RtActivatable<IKnownContactFieldStatics>>::get_activation_factory().convert_name_to_type(name)
    }}
    #[inline] pub fn convert_type_to_name(type_: ContactFieldType) -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownContactFieldStatics>>::get_activation_factory().convert_type_to_name(type_)
    }}
}
DEFINE_CLSID!(KnownContactField(&[87,105,110,100,111,119,115,46,65,112,112,108,105,99,97,116,105,111,110,77,111,100,101,108,46,67,111,110,116,97,99,116,115,46,75,110,111,119,110,67,111,110,116,97,99,116,70,105,101,108,100,0]) [CLSID_KnownContactField]);
DEFINE_IID!(IID_IKnownContactFieldStatics, 772676370, 54823, 20426, 186, 212, 31, 175, 22, 140, 125, 20);
RT_INTERFACE!{static interface IKnownContactFieldStatics(IKnownContactFieldStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IKnownContactFieldStatics] {
    fn get_Email(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PhoneNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Location(&self, out: *mut HSTRING) -> HRESULT,
    fn get_InstantMessage(&self, out: *mut HSTRING) -> HRESULT,
    fn ConvertNameToType(&self, name: HSTRING, out: *mut ContactFieldType) -> HRESULT,
    fn ConvertTypeToName(&self, type_: ContactFieldType, out: *mut HSTRING) -> HRESULT
}}
impl IKnownContactFieldStatics {
    #[inline] pub unsafe fn get_email(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Email)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Location)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_instant_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InstantMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe 