use ::prelude::*;
DEFINE_IID!(IID_ILowLevelDevicesAggregateProvider, 2805880348, 43713, 20167, 168, 82, 71, 159, 112, 96, 208, 31);
RT_INTERFACE!{interface ILowLevelDevicesAggregateProvider(ILowLevelDevicesAggregateProviderVtbl): IInspectable(IInspectableVtbl) [IID_ILowLevelDevicesAggregateProvider] {
    fn get_AdcControllerProvider(&self, out: *mut *mut adc::provider::IAdcControllerProvider) -> HRESULT,
    fn get_PwmControllerProvider(&self, out: *mut *mut pwm::provider::IPwmControllerProvider) -> HRESULT,
    fn get_GpioControllerProvider(&self, out: *mut *mut gpio::provider::IGpioControllerProvider) -> HRESULT,
    fn get_I2cControllerProvider(&self, out: *mut *mut i2c::provider::II2cControllerProvider) -> HRESULT,
    fn get_SpiControllerProvider(&self, out: *mut *mut spi::provider::ISpiControllerProvider) -> HRESULT
}}
impl ILowLevelDevicesAggregateProvider {
    #[inline] pub unsafe fn get_adc_controller_provider(&self) -> Result<ComPtr<adc::provider::IAdcControllerProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AdcControllerProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pwm_controller_provider(&self) -> Result<ComPtr<pwm::provider::IPwmControllerProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PwmControllerProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gpio_controller_provider(&self) -> Result<ComPtr<gpio::provider::IGpioControllerProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GpioControllerProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_i2c_controller_provider(&self) -> Result<ComPtr<i2c::provider::II2cControllerProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_I2cControllerProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_spi_controller_provider(&self) -> Result<ComPtr<spi::provider::ISpiControllerProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SpiControllerProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LowLevelDevicesAggregateProvider: ILowLevelDevicesAggregateProvider}
impl RtActivatable<ILowLevelDevicesAggregateProviderFactory> for LowLevelDevicesAggregateProvider {}
impl LowLevelDevicesAggregateProvider {
    #[inline] pub fn create(adc: &adc::provider::IAdcControllerProvider, pwm: &pwm::provider::IPwmControllerProvider, gpio: &gpio::provider::IGpioControllerProvider, i2c: &i2c::provider::II2cControllerProvider, spi: &spi::provider::ISpiControllerProvider) -> Result<ComPtr<LowLevelDevicesAggregateProvider>> { unsafe {
        <Self as RtActivatable<ILowLevelDevicesAggregateProviderFactory>>::get_activation_factory().create(adc, pwm, gpio, i2c, spi)
    }}
}
DEFINE_CLSID!(LowLevelDevicesAggregateProvider(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,76,111,119,76,101,118,101,108,68,101,118,105,99,101,115,65,103,103,114,101,103,97,116,101,80,114,111,118,105,100,101,114,0]) [CLSID_LowLevelDevicesAggregateProvider]);
DEFINE_IID!(IID_ILowLevelDevicesAggregateProviderFactory, 2596580086, 13427, 18014, 150, 213, 54, 40, 26, 44, 87, 175);
RT_INTERFACE!{static interface ILowLevelDevicesAggregateProviderFactory(ILowLevelDevicesAggregateProviderFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ILowLevelDevicesAggregateProviderFactory] {
    fn Create(&self, adc: *mut adc::provider::IAdcControllerProvider, pwm: *mut pwm::provider::IPwmControllerProvider, gpio: *mut gpio::provider::IGpioControllerProvider, i2c: *mut i2c::provider::II2cControllerProvider, spi: *mut spi::provider::ISpiControllerProvider, out: *mut *mut LowLevelDevicesAggregateProvider) -> HRESULT
}}
impl ILowLevelDevicesAggregateProviderFactory {
    #[inline] pub unsafe fn create(&self, adc: &adc::provider::IAdcControllerProvider, pwm: &pwm::provider::IPwmControllerProvider, gpio: &gpio::provider::IGpioControllerProvider, i2c: &i2c::provider::II2cControllerProvider, spi: &spi::provider::ISpiControllerProvider) -> Result<ComPtr<LowLevelDevicesAggregateProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, adc as *const _ as *mut _, pwm as *const _ as *mut _, gpio as *const _ as *mut _, i2c as *const _ as *mut _, spi as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ILowLevelDevicesController, 784481748, 6043, 17886, 155, 57, 58, 224, 37, 39, 222, 82);
RT_INTERFACE!{interface ILowLevelDevicesController(ILowLevelDevicesControllerVtbl): IInspectable(IInspectableVtbl) [IID_ILowLevelDevicesController] {
    
}}
RT_CLASS!{class LowLevelDevicesController: ILowLevelDevicesController}
impl RtActivatable<ILowLevelDevicesControllerStatics> for LowLevelDevicesController {}
impl LowLevelDevicesController {
    #[inline] pub fn get_default_provider() -> Result<ComPtr<ILowLevelDevicesAggregateProvider>> { unsafe {
        <Self as RtActivatable<ILowLevelDevicesControllerStatics>>::get_activation_factory().get_default_provider()
    }}
    #[inline] pub fn set_default_provider(value: &ILowLevelDevicesAggregateProvider) -> Result<()> { unsafe {
        <Self as RtActivatable<ILowLevelDevicesControllerStatics>>::get_activation_factory().set_default_provider(value)
    }}
}
DEFINE_CLSID!(LowLevelDevicesController(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,76,111,119,76,101,118,101,108,68,101,118,105,99,101,115,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_LowLevelDevicesController]);
DEFINE_IID!(IID_ILowLevelDevicesControllerStatics, 155095658, 64715, 17300, 166, 151, 25, 222, 99, 124, 45, 179);
RT_INTERFACE!{static interface ILowLevelDevicesControllerStatics(ILowLevelDevicesControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ILowLevelDevicesControllerStatics] {
    fn get_DefaultProvider(&self, out: *mut *mut ILowLevelDevicesAggregateProvider) -> HRESULT,
    fn put_DefaultProvider(&self, value: *mut ILowLevelDevicesAggregateProvider) -> HRESULT
}}
impl ILowLevelDevicesControllerStatics {
    #[inline] pub unsafe fn get_default_provider(&self) -> Result<ComPtr<ILowLevelDevicesAggregateProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_provider(&self, value: &ILowLevelDevicesAggregateProvider) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultProvider)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
pub mod custom { // Windows.Devices.Custom
use ::prelude::*;
DEFINE_IID!(IID_ICustomDevice, 3710919967, 50315, 17341, 188, 177, 222, 200, 143, 21, 20, 62);
RT_INTERFACE!{interface ICustomDevice(ICustomDeviceVtbl): IInspectable(IInspectableVtbl) [IID_ICustomDevice] {
    #[cfg(feature="windows-storage")] fn get_InputStream(&self, out: *mut *mut super::super::storage::streams::IInputStream) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_OutputStream(&self, out: *mut *mut super::super::storage::streams::IOutputStream) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SendIOControlAsync(&self, ioControlCode: *mut IIOControlCode, inputBuffer: *mut super::super::storage::streams::IBuffer, outputBuffer: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<u32>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn TrySendIOControlAsync(&self, ioControlCode: *mut IIOControlCode, inputBuffer: *mut super::super::storage::streams::IBuffer, outputBuffer: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ICustomDevice {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_input_stream(&self) -> Result<ComPtr<super::super::storage::streams::IInputStream>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InputStream)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_output_stream(&self) -> Result<ComPtr<super::super::storage::streams::IOutputStream>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutputStream)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn send_iocontrol_async(&self, ioControlCode: &IIOControlCode, inputBuffer: &super::super::storage::streams::IBuffer, outputBuffer: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendIOControlAsync)(self as *const _ as *mut _, ioControlCode as *const _ as *mut _, inputBuffer as *const _ as *mut _, outputBuffer as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_send_iocontrol_async(&self, ioControlCode: &IIOControlCode, inputBuffer: &super::super::storage::streams::IBuffer, outputBuffer: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TrySendIOControlAsync)(self as *const _ as *mut _, ioControlCode as *const _ as *mut _, inputBuffer as *const _ as *mut _, outputBuffer as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CustomDevice: ICustomDevice}
impl RtActivatable<ICustomDeviceStatics> for CustomDevice {}
impl CustomDevice {
    #[inline] pub fn get_device_selector(classGuid: Guid) -> Result<HString> { unsafe {
        <Self as RtActivatable<ICustomDeviceStatics>>::get_activation_factory().get_device_selector(classGuid)
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg, desiredAccess: DeviceAccessMode, sharingMode: DeviceSharingMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CustomDevice>>> { unsafe {
        <Self as RtActivatable<ICustomDeviceStatics>>::get_activation_factory().from_id_async(deviceId, desiredAccess, sharingMode)
    }}
}
DEFINE_CLSID!(CustomDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,67,117,115,116,111,109,46,67,117,115,116,111,109,68,101,118,105,99,101,0]) [CLSID_CustomDevice]);
DEFINE_IID!(IID_ICustomDeviceStatics, 3357672210, 61260, 18097, 165, 142, 238, 179, 8, 220, 137, 23);
RT_INTERFACE!{static interface ICustomDeviceStatics(ICustomDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICustomDeviceStatics] {
    fn GetDeviceSelector(&self, classGuid: Guid, out: *mut HSTRING) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, desiredAccess: DeviceAccessMode, sharingMode: DeviceSharingMode, out: *mut *mut super::super::foundation::IAsyncOperation<CustomDevice>) -> HRESULT
}}
impl ICustomDeviceStatics {
    #[inline] pub unsafe fn get_device_selector(&self, classGuid: Guid) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, classGuid, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg, desiredAccess: DeviceAccessMode, sharingMode: DeviceSharingMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CustomDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), desiredAccess, sharingMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum DeviceAccessMode: i32 {
    Read (DeviceAccessMode_Read) = 0, Write (DeviceAccessMode_Write) = 1, ReadWrite (DeviceAccessMode_ReadWrite) = 2,
}}
RT_ENUM! { enum DeviceSharingMode: i32 {
    Shared (DeviceSharingMode_Shared) = 0, Exclusive (DeviceSharingMode_Exclusive) = 1,
}}
DEFINE_IID!(IID_IIOControlCode, 244668903, 24776, 17269, 167, 97, 127, 136, 8, 6, 108, 96);
RT_INTERFACE!{interface IIOControlCode(IIOControlCodeVtbl): IInspectable(IInspectableVtbl) [IID_IIOControlCode] {
    fn get_AccessMode(&self, out: *mut IOControlAccessMode) -> HRESULT,
    fn get_BufferingMethod(&self, out: *mut IOControlBufferingMethod) -> HRESULT,
    fn get_Function(&self, out: *mut u16) -> HRESULT,
    fn get_DeviceType(&self, out: *mut u16) -> HRESULT,
    fn get_ControlCode(&self, out: *mut u32) -> HRESULT
}}
impl IIOControlCode {
    #[inline] pub unsafe fn get_access_mode(&self) -> Result<IOControlAccessMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AccessMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_buffering_method(&self) -> Result<IOControlBufferingMethod> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BufferingMethod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_function(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Function)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_type(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_control_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ControlCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IIOControlCodeFactory, 2238348528, 19473, 17582, 175, 198, 184, 212, 162, 18, 120, 143);
RT_INTERFACE!{static interface IIOControlCodeFactory(IIOControlCodeFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IIOControlCodeFactory] {
    fn CreateIOControlCode(&self, deviceType: u16, function: u16, accessMode: IOControlAccessMode, bufferingMethod: IOControlBufferingMethod, out: *mut *mut IOControlCode) -> HRESULT
}}
impl IIOControlCodeFactory {
    #[inline] pub unsafe fn create_iocontrol_code(&self, deviceType: u16, function: u16, accessMode: IOControlAccessMode, bufferingMethod: IOControlBufferingMethod) -> Result<ComPtr<IOControlCode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateIOControlCode)(self as *const _ as *mut _, deviceType, function, accessMode, bufferingMethod, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class KnownDeviceTypes}
impl RtActivatable<IKnownDeviceTypesStatics> for KnownDeviceTypes {}
impl KnownDeviceTypes {
    #[inline] pub fn get_unknown() -> Result<u16> { unsafe {
        <Self as RtActivatable<IKnownDeviceTypesStatics>>::get_activation_factory().get_unknown()
    }}
}
DEFINE_CLSID!(KnownDeviceTypes(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,67,117,115,116,111,109,46,75,110,111,119,110,68,101,118,105,99,101,84,121,112,101,115,0]) [CLSID_KnownDeviceTypes]);
DEFINE_IID!(IID_IKnownDeviceTypesStatics, 3998513602, 21576, 17882, 173, 27, 36, 148, 140, 35, 144, 148);
RT_INTERFACE!{static interface IKnownDeviceTypesStatics(IKnownDeviceTypesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IKnownDeviceTypesStatics] {
    fn get_Unknown(&self, out: *mut u16) -> HRESULT
}}
impl IKnownDeviceTypesStatics {
    #[inline] pub unsafe fn get_unknown(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Unknown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum IOControlAccessMode: i32 {
    Any (IOControlAccessMode_Any) = 0, Read (IOControlAccessMode_Read) = 1, Write (IOControlAccessMode_Write) = 2, ReadWrite (IOControlAccessMode_ReadWrite) = 3,
}}
RT_ENUM! { enum IOControlBufferingMethod: i32 {
    Buffered (IOControlBufferingMethod_Buffered) = 0, DirectInput (IOControlBufferingMethod_DirectInput) = 1, DirectOutput (IOControlBufferingMethod_DirectOutput) = 2, Neither (IOControlBufferingMethod_Neither) = 3,
}}
RT_CLASS!{class IOControlCode: IIOControlCode}
impl RtActivatable<IIOControlCodeFactory> for IOControlCode {}
impl IOControlCode {
    #[inline] pub fn create_iocontrol_code(deviceType: u16, function: u16, accessMode: IOControlAccessMode, bufferingMethod: IOControlBufferingMethod) -> Result<ComPtr<IOControlCode>> { unsafe {
        <Self as RtActivatable<IIOControlCodeFactory>>::get_activation_factory().create_iocontrol_code(deviceType, function, accessMode, bufferingMethod)
    }}
}
DEFINE_CLSID!(IOControlCode(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,67,117,115,116,111,109,46,73,79,67,111,110,116,114,111,108,67,111,100,101,0]) [CLSID_IOControlCode]);
} // Windows.Devices.Custom
pub mod printers { // Windows.Devices.Printers
use ::prelude::*;
DEFINE_IID!(IID_IPrint3DDevice, 68959513, 38675, 17058, 152, 19, 125, 195, 51, 116, 40, 211);
RT_INTERFACE!{interface IPrint3DDevice(IPrint3DDeviceVtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DDevice] {
    fn get_PrintSchema(&self, out: *mut *mut PrintSchema) -> HRESULT
}}
impl IPrint3DDevice {
    #[inline] pub unsafe fn get_print_schema(&self) -> Result<ComPtr<PrintSchema>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrintSchema)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Print3DDevice: IPrint3DDevice}
impl RtActivatable<IPrint3DDeviceStatics> for Print3DDevice {}
impl Print3DDevice {
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Print3DDevice>>> { unsafe {
        <Self as RtActivatable<IPrint3DDeviceStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IPrint3DDeviceStatics>>::get_activation_factory().get_device_selector()
    }}
}
DEFINE_CLSID!(Print3DDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,80,114,105,110,116,101,114,115,46,80,114,105,110,116,51,68,68,101,118,105,99,101,0]) [CLSID_Print3DDevice]);
DEFINE_IID!(IID_IPrint3DDeviceStatics, 4259537418, 26573, 16823, 163, 68, 81, 80, 161, 253, 117, 181);
RT_INTERFACE!{static interface IPrint3DDeviceStatics(IPrint3DDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DDeviceStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Print3DDevice>) -> HRESULT,
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPrint3DDeviceStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Print3DDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPrintSchema, 3266937622, 9912, 19451, 129, 56, 159, 150, 44, 34, 163, 91);
RT_INTERFACE!{interface IPrintSchema(IPrintSchemaVtbl): IInspectable(IInspectableVtbl) [IID_IPrintSchema] {
    #[cfg(feature="windows-storage")] fn GetDefaultPrintTicketAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn GetCapabilitiesAsync(&self, constrainTicket: *mut super::super::storage::streams::IRandomAccessStreamWithContentType, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn MergeAndValidateWithDefaultPrintTicketAsync(&self, deltaTicket: *mut super::super::storage::streams::IRandomAccessStreamWithContentType, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>) -> HRESULT
}}
impl IPrintSchema {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_default_print_ticket_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultPrintTicketAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_capabilities_async(&self, constrainTicket: &super::super::storage::streams::IRandomAccessStreamWithContentType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCapabilitiesAsync)(self as *const _ as *mut _, constrainTicket as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn merge_and_validate_with_default_print_ticket_async(&self, deltaTicket: &super::super::storage::streams::IRandomAccessStreamWithContentType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::IRandomAccessStreamWithContentType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).MergeAndValidateWithDefaultPrintTicketAsync)(self as *const _ as *mut _, deltaTicket as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PrintSchema: IPrintSchema}
pub mod extensions { // Windows.Devices.Printers.Extensions
use ::prelude::*;
DEFINE_IID!(IID_IPrint3DWorkflow, 3312415933, 13929, 19046, 171, 66, 200, 21, 25, 48, 205, 52);
RT_INTERFACE!{interface IPrint3DWorkflow(IPrint3DWorkflowVtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DWorkflow] {
    fn get_DeviceID(&self, out: *mut HSTRING) -> HRESULT,
    fn GetPrintModelPackage(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_IsPrintReady(&self, out: *mut bool) -> HRESULT,
    fn put_IsPrintReady(&self, value: bool) -> HRESULT,
    fn add_PrintRequested(&self, eventHandler: *mut ::rt::gen::windows::foundation::TypedEventHandler<Print3DWorkflow, Print3DWorkflowPrintRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PrintRequested(&self, eventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IPrint3DWorkflow {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceID)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_print_model_package(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetPrintModelPackage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_print_ready(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPrintReady)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_print_ready(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsPrintReady)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_print_requested(&self, eventHandler: &::rt::gen::windows::foundation::TypedEventHandler<Print3DWorkflow, Print3DWorkflowPrintRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PrintRequested)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_print_requested(&self, eventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PrintRequested)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Print3DWorkflow: IPrint3DWorkflow}
DEFINE_IID!(IID_IPrint3DWorkflow2, 2728838479, 35521, 18712, 151, 65, 227, 79, 48, 4, 35, 158);
RT_INTERFACE!{interface IPrint3DWorkflow2(IPrint3DWorkflow2Vtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DWorkflow2] {
    fn add_PrinterChanged(&self, eventHandler: *mut ::rt::gen::windows::foundation::TypedEventHandler<Print3DWorkflow, Print3DWorkflowPrinterChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PrinterChanged(&self, eventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IPrint3DWorkflow2 {
    #[inline] pub unsafe fn add_printer_changed(&self, eventHandler: &::rt::gen::windows::foundation::TypedEventHandler<Print3DWorkflow, Print3DWorkflowPrinterChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PrinterChanged)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_printer_changed(&self, eventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PrinterChanged)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum Print3DWorkflowDetail: i32 {
    Unknown (Print3DWorkflowDetail_Unknown) = 0, ModelExceedsPrintBed (Print3DWorkflowDetail_ModelExceedsPrintBed) = 1, UploadFailed (Print3DWorkflowDetail_UploadFailed) = 2, InvalidMaterialSelection (Print3DWorkflowDetail_InvalidMaterialSelection) = 3, InvalidModel (Print3DWorkflowDetail_InvalidModel) = 4, ModelNotManifold (Print3DWorkflowDetail_ModelNotManifold) = 5, InvalidPrintTicket (Print3DWorkflowDetail_InvalidPrintTicket) = 6,
}}
DEFINE_IID!(IID_IPrint3DWorkflowPrinterChangedEventArgs, 1159881730, 38396, 18503, 147, 179, 19, 77, 191, 92, 96, 247);
RT_INTERFACE!{interface IPrint3DWorkflowPrinterChangedEventArgs(IPrint3DWorkflowPrinterChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DWorkflowPrinterChangedEventArgs] {
    fn get_NewDeviceId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPrint3DWorkflowPrinterChangedEventArgs {
    #[inline] pub unsafe fn get_new_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Print3DWorkflowPrinterChangedEventArgs: IPrint3DWorkflowPrinterChangedEventArgs}
DEFINE_IID!(IID_IPrint3DWorkflowPrintRequestedEventArgs, 435734616, 23240, 19285, 138, 95, 230, 21, 103, 218, 251, 77);
RT_INTERFACE!{interface IPrint3DWorkflowPrintRequestedEventArgs(IPrint3DWorkflowPrintRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPrint3DWorkflowPrintRequestedEventArgs] {
    fn get_Status(&self, out: *mut Print3DWorkflowStatus) -> HRESULT,
    fn SetExtendedStatus(&self, value: Print3DWorkflowDetail) -> HRESULT,
    fn SetSource(&self, source: *mut IInspectable) -> HRESULT,
    fn SetSourceChanged(&self, value: bool) -> HRESULT
}}
impl IPrint3DWorkflowPrintRequestedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<Print3DWorkflowStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_extended_status(&self, value: Print3DWorkflowDetail) -> Result<()> {
        let hr = ((*self.lpVtbl).SetExtendedStatus)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source(&self, source: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).SetSource)(self as *const _ as *mut _, source as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source_changed(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetSourceChanged)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Print3DWorkflowPrintRequestedEventArgs: IPrint3DWorkflowPrintRequestedEventArgs}
RT_ENUM! { enum Print3DWorkflowStatus: i32 {
    Abandoned (Print3DWorkflowStatus_Abandoned) = 0, Canceled (Print3DWorkflowStatus_Canceled) = 1, Failed (Print3DWorkflowStatus_Failed) = 2, Slicing (Print3DWorkflowStatus_Slicing) = 3, Submitted (Print3DWorkflowStatus_Submitted) = 4,
}}
RT_CLASS!{static class PrintExtensionContext}
impl RtActivatable<IPrintExtensionContextStatic> for PrintExtensionContext {}
impl PrintExtensionContext {
    #[inline] pub fn from_device_id(deviceId: &HStringArg) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPrintExtensionContextStatic>>::get_activation_factory().from_device_id(deviceId)
    }}
}
DEFINE_CLSID!(PrintExtensionContext(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,80,114,105,110,116,101,114,115,46,69,120,116,101,110,115,105,111,110,115,46,80,114,105,110,116,69,120,116,101,110,115,105,111,110,67,111,110,116,101,120,116,0]) [CLSID_PrintExtensionContext]);
DEFINE_IID!(IID_IPrintExtensionContextStatic, 3876429761, 65401, 19108, 140, 155, 12, 147, 174, 223, 222, 138);
RT_INTERFACE!{static interface IPrintExtensionContextStatic(IPrintExtensionContextStaticVtbl): IInspectable(IInspectableVtbl) [IID_IPrintExtensionContextStatic] {
    fn FromDeviceId(&self, deviceId: HSTRING, out: *mut *mut IInspectable) -> HRESULT
}}
impl IPrintExtensionContextStatic {
    #[inline] pub unsafe fn from_device_id(&self, deviceId: &HStringArg) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromDeviceId)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPrintNotificationEventDetails, 3759033482, 18472, 19873, 139, 184, 134, 114, 223, 133, 21, 231);
RT_INTERFACE!{interface IPrintNotificationEventDetails(IPrintNotificationEventDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IPrintNotificationEventDetails] {
    fn get_PrinterName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_EventData(&self, out: *mut HSTRING) -> HRESULT,
    fn put_EventData(&self, value: HSTRING) -> HRESULT
}}
impl IPrintNotificationEventDetails {
    #[inline] pub unsafe fn get_printer_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrinterName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_event_data(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EventData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_event_data(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EventData)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PrintNotificationEventDetails: IPrintNotificationEventDetails}
DEFINE_IID!(IID_IPrintTaskConfiguration, 3821151313, 15012, 18565, 146, 64, 49, 31, 95, 143, 190, 157);
RT_INTERFACE!{interface IPrintTaskConfiguration(IPrintTaskConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IPrintTaskConfiguration] {
    fn get_PrinterExtensionContext(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn add_SaveRequested(&self, eventHandler: *mut ::rt::gen::windows::foundation::TypedEventHandler<PrintTaskConfiguration, PrintTaskConfigurationSaveRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SaveRequested(&self, eventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IPrintTaskConfiguration {
    #[inline] pub unsafe fn get_printer_extension_context(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrinterExtensionContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_save_requested(&self, eventHandler: &::rt::gen::windows::foundation::TypedEventHandler<PrintTaskConfiguration, PrintTaskConfigurationSaveRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SaveRequested)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_save_requested(&self, eventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SaveRequested)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PrintTaskConfiguration: IPrintTaskConfiguration}
DEFINE_IID!(IID_IPrintTaskConfigurationSaveRequest, 4004458443, 25118, 19298, 172, 119, 178, 129, 204, 224, 141, 96);
RT_INTERFACE!{interface IPrintTaskConfigurationSaveRequest(IPrintTaskConfigurationSaveRequestVtbl): IInspectable(IInspectableVtbl) [IID_IPrintTaskConfigurationSaveRequest] {
    fn Cancel(&self) -> HRESULT,
    fn Save(&self, printerExtensionContext: *mut IInspectable) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut PrintTaskConfigurationSaveRequestedDeferral) -> HRESULT,
    fn get_Deadline(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT
}}
impl IPrintTaskConfigurationSaveRequest {
    #[inline] pub unsafe fn cancel(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Cancel)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn save(&self, printerExtensionContext: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).Save)(self as *const _ as *mut _, printerExtensionContext as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<PrintTaskConfigurationSaveRequestedDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deadline(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Deadline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PrintTaskConfigurationSaveRequest: IPrintTaskConfigurationSaveRequest}
DEFINE_IID!(IID_IPrintTaskConfigurationSaveRequestedDeferral, 3914978664, 63273, 17572, 135, 29, 189, 6, 40, 105, 106, 51);
RT_INTERFACE!{interface IPrintTaskConfigurationSaveRequestedDeferral(IPrintTaskConfigurationSaveRequestedDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IPrintTaskConfigurationSaveRequestedDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IPrintTaskConfigurationSaveRequestedDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PrintTaskConfigurationSaveRequestedDeferral: IPrintTaskConfigurationSaveRequestedDeferral}
DEFINE_IID!(IID_IPrintTaskConfigurationSaveRequestedEventArgs, 3765184633, 3425, 18744, 145, 208, 150, 164, 91, 238, 132, 121);
RT_INTERFACE!{interface IPrintTaskConfigurationSaveRequestedEventArgs(IPrintTaskConfigurationSaveRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPrintTaskConfigurationSaveRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut PrintTaskConfigurationSaveRequest) -> HRESULT
}}
impl IPrintTaskConfigurationSaveRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<PrintTaskConfigurationSaveRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PrintTaskConfigurationSaveRequestedEventArgs: IPrintTaskConfigurationSaveRequestedEventArgs}
} // Windows.Devices.Printers.Extensions
} // Windows.Devices.Printers
pub mod adc { // Windows.Devices.Adc
use ::prelude::*;
DEFINE_IID!(IID_IAdcChannel, 67892244, 9608, 19030, 171, 239, 115, 162, 96, 172, 198, 10);
RT_INTERFACE!{interface IAdcChannel(IAdcChannelVtbl): IInspectable(IInspectableVtbl) [IID_IAdcChannel] {
    fn get_Controller(&self, out: *mut *mut AdcController) -> HRESULT,
    fn ReadValue(&self, out: *mut i32) -> HRESULT,
    fn ReadRatio(&self, out: *mut f64) -> HRESULT
}}
impl IAdcChannel {
    #[inline] pub unsafe fn get_controller(&self) -> Result<ComPtr<AdcController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Controller)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ReadValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_ratio(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ReadRatio)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AdcChannel: IAdcChannel}
RT_ENUM! { enum AdcChannelMode: i32 {
    SingleEnded (AdcChannelMode_SingleEnded) = 0, Differential (AdcChannelMode_Differential) = 1,
}}
DEFINE_IID!(IID_IAdcController, 712434864, 43158, 16921, 134, 182, 234, 140, 220, 233, 143, 86);
RT_INTERFACE!{interface IAdcController(IAdcControllerVtbl): IInspectable(IInspectableVtbl) [IID_IAdcController] {
    fn get_ChannelCount(&self, out: *mut i32) -> HRESULT,
    fn get_ResolutionInBits(&self, out: *mut i32) -> HRESULT,
    fn get_MinValue(&self, out: *mut i32) -> HRESULT,
    fn get_MaxValue(&self, out: *mut i32) -> HRESULT,
    fn get_ChannelMode(&self, out: *mut AdcChannelMode) -> HRESULT,
    fn put_ChannelMode(&self, value: AdcChannelMode) -> HRESULT,
    fn IsChannelModeSupported(&self, channelMode: AdcChannelMode, out: *mut bool) -> HRESULT,
    fn OpenChannel(&self, channelNumber: i32, out: *mut *mut AdcChannel) -> HRESULT
}}
impl IAdcController {
    #[inline] pub unsafe fn get_channel_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChannelCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_resolution_in_bits(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ResolutionInBits)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_channel_mode(&self) -> Result<AdcChannelMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChannelMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_channel_mode(&self, value: AdcChannelMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChannelMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_channel_mode_supported(&self, channelMode: AdcChannelMode) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsChannelModeSupported)(self as *const _ as *mut _, channelMode, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_channel(&self, channelNumber: i32) -> Result<ComPtr<AdcChannel>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenChannel)(self as *const _ as *mut _, channelNumber, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AdcController: IAdcController}
impl RtActivatable<IAdcControllerStatics> for AdcController {}
impl RtActivatable<IAdcControllerStatics2> for AdcController {}
impl AdcController {
    #[inline] pub fn get_controllers_async(provider: &provider::IAdcProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AdcController>>>> { unsafe {
        <Self as RtActivatable<IAdcControllerStatics>>::get_activation_factory().get_controllers_async(provider)
    }}
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<AdcController>>> { unsafe {
        <Self as RtActivatable<IAdcControllerStatics2>>::get_activation_factory().get_default_async()
    }}
}
DEFINE_CLSID!(AdcController(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,100,99,46,65,100,99,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_AdcController]);
DEFINE_IID!(IID_IAdcControllerStatics, 3437858316, 504, 18577, 188, 59, 190, 83, 239, 39, 156, 164);
RT_INTERFACE!{static interface IAdcControllerStatics(IAdcControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAdcControllerStatics] {
    fn GetControllersAsync(&self, provider: *mut provider::IAdcProvider, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AdcController>>) -> HRESULT
}}
impl IAdcControllerStatics {
    #[inline] pub unsafe fn get_controllers_async(&self, provider: &provider::IAdcProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<AdcController>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, provider as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdcControllerStatics2, 2730048285, 38779, 20314, 165, 254, 166, 171, 175, 254, 100, 132);
RT_INTERFACE!{static interface IAdcControllerStatics2(IAdcControllerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAdcControllerStatics2] {
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<AdcController>) -> HRESULT
}}
impl IAdcControllerStatics2 {
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AdcController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
pub mod provider { // Windows.Devices.Adc.Provider
use ::prelude::*;
DEFINE_IID!(IID_IAdcControllerProvider, 3193198632, 33133, 19941, 160, 72, 171, 160, 105, 88, 170, 168);
RT_INTERFACE!{interface IAdcControllerProvider(IAdcControllerProviderVtbl): IInspectable(IInspectableVtbl) [IID_IAdcControllerProvider] {
    fn get_ChannelCount(&self, out: *mut i32) -> HRESULT,
    fn get_ResolutionInBits(&self, out: *mut i32) -> HRESULT,
    fn get_MinValue(&self, out: *mut i32) -> HRESULT,
    fn get_MaxValue(&self, out: *mut i32) -> HRESULT,
    fn get_ChannelMode(&self, out: *mut ProviderAdcChannelMode) -> HRESULT,
    fn put_ChannelMode(&self, value: ProviderAdcChannelMode) -> HRESULT,
    fn IsChannelModeSupported(&self, channelMode: ProviderAdcChannelMode, out: *mut bool) -> HRESULT,
    fn AcquireChannel(&self, channel: i32) -> HRESULT,
    fn ReleaseChannel(&self, channel: i32) -> HRESULT,
    fn ReadValue(&self, channelNumber: i32, out: *mut i32) -> HRESULT
}}
impl IAdcControllerProvider {
    #[inline] pub unsafe fn get_channel_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChannelCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_resolution_in_bits(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ResolutionInBits)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_channel_mode(&self) -> Result<ProviderAdcChannelMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChannelMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_channel_mode(&self, value: ProviderAdcChannelMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChannelMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_channel_mode_supported(&self, channelMode: ProviderAdcChannelMode) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsChannelModeSupported)(self as *const _ as *mut _, channelMode, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn acquire_channel(&self, channel: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).AcquireChannel)(self as *const _ as *mut _, channel);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn release_channel(&self, channel: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).ReleaseChannel)(self as *const _ as *mut _, channel);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_value(&self, channelNumber: i32) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ReadValue)(self as *const _ as *mut _, channelNumber, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdcProvider, 680867432, 37721, 19543, 188, 136, 226, 117, 232, 22, 56, 201);
RT_INTERFACE!{interface IAdcProvider(IAdcProviderVtbl): IInspectable(IInspectableVtbl) [IID_IAdcProvider] {
    fn GetControllers(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IAdcControllerProvider>) -> HRESULT
}}
impl IAdcProvider {
    #[inline] pub unsafe fn get_controllers(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IAdcControllerProvider>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ProviderAdcChannelMode: i32 {
    SingleEnded (ProviderAdcChannelMode_SingleEnded) = 0, Differential (ProviderAdcChannelMode_Differential) = 1,
}}
} // Windows.Devices.Adc.Provider
} // Windows.Devices.Adc
pub mod gpio { // Windows.Devices.Gpio
use ::prelude::*;
RT_STRUCT! { struct GpioChangeCount {
    Count: u64, RelativeTime: super::super::foundation::TimeSpan,
}}
DEFINE_IID!(IID_IGpioChangeCounter, 3411984606, 26625, 17407, 128, 61, 69, 118, 98, 138, 139, 38);
RT_INTERFACE!{interface IGpioChangeCounter(IGpioChangeCounterVtbl): IInspectable(IInspectableVtbl) [IID_IGpioChangeCounter] {
    fn put_Polarity(&self, value: GpioChangePolarity) -> HRESULT,
    fn get_Polarity(&self, out: *mut GpioChangePolarity) -> HRESULT,
    fn get_IsStarted(&self, out: *mut bool) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn Read(&self, out: *mut GpioChangeCount) -> HRESULT,
    fn Reset(&self, out: *mut GpioChangeCount) -> HRESULT
}}
impl IGpioChangeCounter {
    #[inline] pub unsafe fn set_polarity(&self, value: GpioChangePolarity) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Polarity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_polarity(&self) -> Result<GpioChangePolarity> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Polarity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_started(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsStarted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self) -> Result<GpioChangeCount> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset(&self) -> Result<GpioChangeCount> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Reset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GpioChangeCounter: IGpioChangeCounter}
impl RtActivatable<IGpioChangeCounterFactory> for GpioChangeCounter {}
impl GpioChangeCounter {
    #[inline] pub fn create(pin: &GpioPin) -> Result<ComPtr<GpioChangeCounter>> { unsafe {
        <Self as RtActivatable<IGpioChangeCounterFactory>>::get_activation_factory().create(pin)
    }}
}
DEFINE_CLSID!(GpioChangeCounter(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,112,105,111,46,71,112,105,111,67,104,97,110,103,101,67,111,117,110,116,101,114,0]) [CLSID_GpioChangeCounter]);
DEFINE_IID!(IID_IGpioChangeCounterFactory, 343774390, 2718, 16652, 180, 250, 248, 159, 64, 82, 8, 77);
RT_INTERFACE!{static interface IGpioChangeCounterFactory(IGpioChangeCounterFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGpioChangeCounterFactory] {
    fn Create(&self, pin: *mut GpioPin, out: *mut *mut GpioChangeCounter) -> HRESULT
}}
impl IGpioChangeCounterFactory {
    #[inline] pub unsafe fn create(&self, pin: &GpioPin) -> Result<ComPtr<GpioChangeCounter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, pin as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum GpioChangePolarity: i32 {
    Falling (GpioChangePolarity_Falling) = 0, Rising (GpioChangePolarity_Rising) = 1, Both (GpioChangePolarity_Both) = 2,
}}
DEFINE_IID!(IID_IGpioChangeReader, 180127839, 57393, 18664, 133, 144, 112, 222, 120, 54, 60, 109);
RT_INTERFACE!{interface IGpioChangeReader(IGpioChangeReaderVtbl): IInspectable(IInspectableVtbl) [IID_IGpioChangeReader] {
    fn get_Capacity(&self, out: *mut i32) -> HRESULT,
    fn get_Length(&self, out: *mut i32) -> HRESULT,
    fn get_IsEmpty(&self, out: *mut bool) -> HRESULT,
    fn get_IsOverflowed(&self, out: *mut bool) -> HRESULT,
    fn put_Polarity(&self, value: GpioChangePolarity) -> HRESULT,
    fn get_Polarity(&self, out: *mut GpioChangePolarity) -> HRESULT,
    fn get_IsStarted(&self, out: *mut bool) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn Clear(&self) -> HRESULT,
    fn GetNextItem(&self, out: *mut GpioChangeRecord) -> HRESULT,
    fn PeekNextItem(&self, out: *mut GpioChangeRecord) -> HRESULT,
    fn GetAllItems(&self, out: *mut *mut super::super::foundation::collections::IVector<GpioChangeRecord>) -> HRESULT,
    fn WaitForItemsAsync(&self, count: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IGpioChangeReader {
    #[inline] pub unsafe fn get_capacity(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Capacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Length)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_empty(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEmpty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_overflowed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOverflowed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_polarity(&self, value: GpioChangePolarity) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Polarity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_polarity(&self) -> Result<GpioChangePolarity> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Polarity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_started(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsStarted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Clear)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_next_item(&self) -> Result<GpioChangeRecord> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetNextItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn peek_next_item(&self) -> Result<GpioChangeRecord> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).PeekNextItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_items(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<GpioChangeRecord>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllItems)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn wait_for_items_async(&self, count: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WaitForItemsAsync)(self as *const _ as *mut _, count, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GpioChangeReader: IGpioChangeReader}
impl RtActivatable<IGpioChangeReaderFactory> for GpioChangeReader {}
impl GpioChangeReader {
    #[inline] pub fn create(pin: &GpioPin) -> Result<ComPtr<GpioChangeReader>> { unsafe {
        <Self as RtActivatable<IGpioChangeReaderFactory>>::get_activation_factory().create(pin)
    }}
    #[inline] pub fn create_with_capacity(pin: &GpioPin, minCapacity: i32) -> Result<ComPtr<GpioChangeReader>> { unsafe {
        <Self as RtActivatable<IGpioChangeReaderFactory>>::get_activation_factory().create_with_capacity(pin, minCapacity)
    }}
}
DEFINE_CLSID!(GpioChangeReader(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,112,105,111,46,71,112,105,111,67,104,97,110,103,101,82,101,97,100,101,114,0]) [CLSID_GpioChangeReader]);
DEFINE_IID!(IID_IGpioChangeReaderFactory, 2841218803, 14606, 17434, 157, 28, 232, 222, 11, 45, 240, 223);
RT_INTERFACE!{static interface IGpioChangeReaderFactory(IGpioChangeReaderFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGpioChangeReaderFactory] {
    fn Create(&self, pin: *mut GpioPin, out: *mut *mut GpioChangeReader) -> HRESULT,
    fn CreateWithCapacity(&self, pin: *mut GpioPin, minCapacity: i32, out: *mut *mut GpioChangeReader) -> HRESULT
}}
impl IGpioChangeReaderFactory {
    #[inline] pub unsafe fn create(&self, pin: &GpioPin) -> Result<ComPtr<GpioChangeReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, pin as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_capacity(&self, pin: &GpioPin, minCapacity: i32) -> Result<ComPtr<GpioChangeReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithCapacity)(self as *const _ as *mut _, pin as *const _ as *mut _, minCapacity, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_STRUCT! { struct GpioChangeRecord {
    RelativeTime: super::super::foundation::TimeSpan, Edge: GpioPinEdge,
}}
DEFINE_IID!(IID_IGpioController, 675287779, 29793, 18076, 168, 188, 97, 214, 157, 8, 165, 60);
RT_INTERFACE!{interface IGpioController(IGpioControllerVtbl): IInspectable(IInspectableVtbl) [IID_IGpioController] {
    fn get_PinCount(&self, out: *mut i32) -> HRESULT,
    fn OpenPin(&self, pinNumber: i32, out: *mut *mut GpioPin) -> HRESULT,
    fn OpenPinWithSharingMode(&self, pinNumber: i32, sharingMode: GpioSharingMode, out: *mut *mut GpioPin) -> HRESULT,
    fn TryOpenPin(&self, pinNumber: i32, sharingMode: GpioSharingMode, pin: *mut *mut GpioPin, openStatus: *mut GpioOpenStatus, out: *mut bool) -> HRESULT
}}
impl IGpioController {
    #[inline] pub unsafe fn get_pin_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PinCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_pin(&self, pinNumber: i32) -> Result<ComPtr<GpioPin>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenPin)(self as *const _ as *mut _, pinNumber, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_pin_with_sharing_mode(&self, pinNumber: i32, sharingMode: GpioSharingMode) -> Result<ComPtr<GpioPin>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenPinWithSharingMode)(self as *const _ as *mut _, pinNumber, sharingMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_open_pin(&self, pinNumber: i32, sharingMode: GpioSharingMode) -> Result<(ComPtr<GpioPin>, GpioOpenStatus, bool)> {
        let mut pin = null_mut(); let mut openStatus = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryOpenPin)(self as *const _ as *mut _, pinNumber, sharingMode, &mut pin, &mut openStatus, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(pin), openStatus, out)) } else { err(hr) }
    }
}
RT_CLASS!{class GpioController: IGpioController}
impl RtActivatable<IGpioControllerStatics> for GpioController {}
impl RtActivatable<IGpioControllerStatics2> for GpioController {}
impl GpioController {
    #[inline] pub fn get_default() -> Result<ComPtr<GpioController>> { unsafe {
        <Self as RtActivatable<IGpioControllerStatics>>::get_activation_factory().get_default()
    }}
    #[inline] pub fn get_controllers_async(provider: &provider::IGpioProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<GpioController>>>> { unsafe {
        <Self as RtActivatable<IGpioControllerStatics2>>::get_activation_factory().get_controllers_async(provider)
    }}
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<GpioController>>> { unsafe {
        <Self as RtActivatable<IGpioControllerStatics2>>::get_activation_factory().get_default_async()
    }}
}
DEFINE_CLSID!(GpioController(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,112,105,111,46,71,112,105,111,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_GpioController]);
DEFINE_IID!(IID_IGpioControllerStatics, 785839150, 31479, 16662, 149, 51, 196, 61, 153, 161, 251, 100);
RT_INTERFACE!{static interface IGpioControllerStatics(IGpioControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGpioControllerStatics] {
    fn GetDefault(&self, out: *mut *mut GpioController) -> HRESULT
}}
impl IGpioControllerStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<GpioController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGpioControllerStatics2, 2435546400, 27812, 16646, 163, 115, 255, 253, 52, 107, 14, 91);
RT_INTERFACE!{static interface IGpioControllerStatics2(IGpioControllerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGpioControllerStatics2] {
    fn GetControllersAsync(&self, provider: *mut provider::IGpioProvider, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<GpioController>>) -> HRESULT,
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<GpioController>) -> HRESULT
}}
impl IGpioControllerStatics2 {
    #[inline] pub unsafe fn get_controllers_async(&self, provider: &provider::IGpioProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<GpioController>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, provider as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<GpioController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum GpioOpenStatus: i32 {
    PinOpened (GpioOpenStatus_PinOpened) = 0, PinUnavailable (GpioOpenStatus_PinUnavailable) = 1, SharingViolation (GpioOpenStatus_SharingViolation) = 2, MuxingConflict (GpioOpenStatus_MuxingConflict) = 3, UnknownError (GpioOpenStatus_UnknownError) = 4,
}}
DEFINE_IID!(IID_IGpioPin, 299479175, 44974, 18320, 158, 233, 224, 234, 201, 66, 210, 1);
RT_INTERFACE!{interface IGpioPin(IGpioPinVtbl): IInspectable(IInspectableVtbl) [IID_IGpioPin] {
    fn add_ValueChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<GpioPin, GpioPinValueChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ValueChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_DebounceTimeout(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_DebounceTimeout(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_PinNumber(&self, out: *mut i32) -> HRESULT,
    fn get_SharingMode(&self, out: *mut GpioSharingMode) -> HRESULT,
    fn IsDriveModeSupported(&self, driveMode: GpioPinDriveMode, out: *mut bool) -> HRESULT,
    fn GetDriveMode(&self, out: *mut GpioPinDriveMode) -> HRESULT,
    fn SetDriveMode(&self, value: GpioPinDriveMode) -> HRESULT,
    fn Write(&self, value: GpioPinValue) -> HRESULT,
    fn Read(&self, out: *mut GpioPinValue) -> HRESULT
}}
impl IGpioPin {
    #[inline] pub unsafe fn add_value_changed(&self, handler: &super::super::foundation::TypedEventHandler<GpioPin, GpioPinValueChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ValueChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_value_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ValueChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_debounce_timeout(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DebounceTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_debounce_timeout(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DebounceTimeout)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pin_number(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PinNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<GpioSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_drive_mode_supported(&self, driveMode: GpioPinDriveMode) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsDriveModeSupported)(self as *const _ as *mut _, driveMode, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drive_mode(&self) -> Result<GpioPinDriveMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetDriveMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_drive_mode(&self, value: GpioPinDriveMode) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDriveMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn write(&self, value: GpioPinValue) -> Result<()> {
        let hr = ((*self.lpVtbl).Write)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self) -> Result<GpioPinValue> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GpioPin: IGpioPin}
RT_ENUM! { enum GpioPinDriveMode: i32 {
    Input (GpioPinDriveMode_Input) = 0, Output (GpioPinDriveMode_Output) = 1, InputPullUp (GpioPinDriveMode_InputPullUp) = 2, InputPullDown (GpioPinDriveMode_InputPullDown) = 3, OutputOpenDrain (GpioPinDriveMode_OutputOpenDrain) = 4, OutputOpenDrainPullUp (GpioPinDriveMode_OutputOpenDrainPullUp) = 5, OutputOpenSource (GpioPinDriveMode_OutputOpenSource) = 6, OutputOpenSourcePullDown (GpioPinDriveMode_OutputOpenSourcePullDown) = 7,
}}
RT_ENUM! { enum GpioPinEdge: i32 {
    FallingEdge (GpioPinEdge_FallingEdge) = 0, RisingEdge (GpioPinEdge_RisingEdge) = 1,
}}
RT_ENUM! { enum GpioPinValue: i32 {
    Low (GpioPinValue_Low) = 0, High (GpioPinValue_High) = 1,
}}
DEFINE_IID!(IID_IGpioPinValueChangedEventArgs, 825731809, 28733, 16473, 189, 36, 181, 178, 93, 255, 184, 78);
RT_INTERFACE!{interface IGpioPinValueChangedEventArgs(IGpioPinValueChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGpioPinValueChangedEventArgs] {
    fn get_Edge(&self, out: *mut GpioPinEdge) -> HRESULT
}}
impl IGpioPinValueChangedEventArgs {
    #[inline] pub unsafe fn get_edge(&self) -> Result<GpioPinEdge> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Edge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GpioPinValueChangedEventArgs: IGpioPinValueChangedEventArgs}
RT_ENUM! { enum GpioSharingMode: i32 {
    Exclusive (GpioSharingMode_Exclusive) = 0, SharedReadOnly (GpioSharingMode_SharedReadOnly) = 1,
}}
pub mod provider { // Windows.Devices.Gpio.Provider
use ::prelude::*;
DEFINE_IID!(IID_IGpioControllerProvider, 2903625415, 6634, 19233, 135, 79, 185, 26, 237, 74, 37, 219);
RT_INTERFACE!{interface IGpioControllerProvider(IGpioControllerProviderVtbl): IInspectable(IInspectableVtbl) [IID_IGpioControllerProvider] {
    fn get_PinCount(&self, out: *mut i32) -> HRESULT,
    fn OpenPinProvider(&self, pin: i32, sharingMode: ProviderGpioSharingMode, out: *mut *mut IGpioPinProvider) -> HRESULT
}}
impl IGpioControllerProvider {
    #[inline] pub unsafe fn get_pin_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PinCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_pin_provider(&self, pin: i32, sharingMode: ProviderGpioSharingMode) -> Result<ComPtr<IGpioPinProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenPinProvider)(self as *const _ as *mut _, pin, sharingMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGpioPinProvider, 1110723767, 27324, 16639, 156, 231, 115, 184, 83, 1, 185, 0);
RT_INTERFACE!{interface IGpioPinProvider(IGpioPinProviderVtbl): IInspectable(IInspectableVtbl) [IID_IGpioPinProvider] {
    fn add_ValueChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<IGpioPinProvider, GpioPinProviderValueChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ValueChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn get_DebounceTimeout(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn put_DebounceTimeout(&self, value: ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_PinNumber(&self, out: *mut i32) -> HRESULT,
    fn get_SharingMode(&self, out: *mut ProviderGpioSharingMode) -> HRESULT,
    fn IsDriveModeSupported(&self, driveMode: ProviderGpioPinDriveMode, out: *mut bool) -> HRESULT,
    fn GetDriveMode(&self, out: *mut ProviderGpioPinDriveMode) -> HRESULT,
    fn SetDriveMode(&self, value: ProviderGpioPinDriveMode) -> HRESULT,
    fn Write(&self, value: ProviderGpioPinValue) -> HRESULT,
    fn Read(&self, out: *mut ProviderGpioPinValue) -> HRESULT
}}
impl IGpioPinProvider {
    #[inline] pub unsafe fn add_value_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<IGpioPinProvider, GpioPinProviderValueChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ValueChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_value_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ValueChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_debounce_timeout(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DebounceTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_debounce_timeout(&self, value: ::rt::gen::windows::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DebounceTimeout)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pin_number(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PinNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<ProviderGpioSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_drive_mode_supported(&self, driveMode: ProviderGpioPinDriveMode) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsDriveModeSupported)(self as *const _ as *mut _, driveMode, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drive_mode(&self) -> Result<ProviderGpioPinDriveMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetDriveMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_drive_mode(&self, value: ProviderGpioPinDriveMode) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDriveMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn write(&self, value: ProviderGpioPinValue) -> Result<()> {
        let hr = ((*self.lpVtbl).Write)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self) -> Result<ProviderGpioPinValue> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGpioPinProviderValueChangedEventArgs, 849794802, 15707, 17613, 143, 190, 19, 166, 159, 46, 219, 36);
RT_INTERFACE!{interface IGpioPinProviderValueChangedEventArgs(IGpioPinProviderValueChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGpioPinProviderValueChangedEventArgs] {
    fn get_Edge(&self, out: *mut ProviderGpioPinEdge) -> HRESULT
}}
impl IGpioPinProviderValueChangedEventArgs {
    #[inline] pub unsafe fn get_edge(&self) -> Result<ProviderGpioPinEdge> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Edge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GpioPinProviderValueChangedEventArgs: IGpioPinProviderValueChangedEventArgs}
impl RtActivatable<IGpioPinProviderValueChangedEventArgsFactory> for GpioPinProviderValueChangedEventArgs {}
impl GpioPinProviderValueChangedEventArgs {
    #[inline] pub fn create(edge: ProviderGpioPinEdge) -> Result<ComPtr<GpioPinProviderValueChangedEventArgs>> { unsafe {
        <Self as RtActivatable<IGpioPinProviderValueChangedEventArgsFactory>>::get_activation_factory().create(edge)
    }}
}
DEFINE_CLSID!(GpioPinProviderValueChangedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,112,105,111,46,80,114,111,118,105,100,101,114,46,71,112,105,111,80,105,110,80,114,111,118,105,100,101,114,86,97,108,117,101,67,104,97,110,103,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_GpioPinProviderValueChangedEventArgs]);
DEFINE_IID!(IID_IGpioPinProviderValueChangedEventArgsFactory, 1053494105, 22156, 17298, 178, 74, 138, 89, 169, 2, 177, 241);
RT_INTERFACE!{static interface IGpioPinProviderValueChangedEventArgsFactory(IGpioPinProviderValueChangedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGpioPinProviderValueChangedEventArgsFactory] {
    fn Create(&self, edge: ProviderGpioPinEdge, out: *mut *mut GpioPinProviderValueChangedEventArgs) -> HRESULT
}}
impl IGpioPinProviderValueChangedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, edge: ProviderGpioPinEdge) -> Result<ComPtr<GpioPinProviderValueChangedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, edge, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGpioProvider, 1156065031, 2250, 17226, 175, 224, 214, 21, 128, 68, 111, 126);
RT_INTERFACE!{interface IGpioProvider(IGpioProviderVtbl): IInspectable(IInspectableVtbl) [IID_IGpioProvider] {
    fn GetControllers(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IGpioControllerProvider>) -> HRESULT
}}
impl IGpioProvider {
    #[inline] pub unsafe fn get_controllers(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IGpioControllerProvider>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ProviderGpioPinDriveMode: i32 {
    Input (ProviderGpioPinDriveMode_Input) = 0, Output (ProviderGpioPinDriveMode_Output) = 1, InputPullUp (ProviderGpioPinDriveMode_InputPullUp) = 2, InputPullDown (ProviderGpioPinDriveMode_InputPullDown) = 3, OutputOpenDrain (ProviderGpioPinDriveMode_OutputOpenDrain) = 4, OutputOpenDrainPullUp (ProviderGpioPinDriveMode_OutputOpenDrainPullUp) = 5, OutputOpenSource (ProviderGpioPinDriveMode_OutputOpenSource) = 6, OutputOpenSourcePullDown (ProviderGpioPinDriveMode_OutputOpenSourcePullDown) = 7,
}}
RT_ENUM! { enum ProviderGpioPinEdge: i32 {
    FallingEdge (ProviderGpioPinEdge_FallingEdge) = 0, RisingEdge (ProviderGpioPinEdge_RisingEdge) = 1,
}}
RT_ENUM! { enum ProviderGpioPinValue: i32 {
    Low (ProviderGpioPinValue_Low) = 0, High (ProviderGpioPinValue_High) = 1,
}}
RT_ENUM! { enum ProviderGpioSharingMode: i32 {
    Exclusive (ProviderGpioSharingMode_Exclusive) = 0, SharedReadOnly (ProviderGpioSharingMode_SharedReadOnly) = 1,
}}
} // Windows.Devices.Gpio.Provider
} // Windows.Devices.Gpio
pub mod i2c { // Windows.Devices.I2c
use ::prelude::*;
RT_ENUM! { enum I2cBusSpeed: i32 {
    StandardMode (I2cBusSpeed_StandardMode) = 0, FastMode (I2cBusSpeed_FastMode) = 1,
}}
DEFINE_IID!(IID_II2cConnectionSettings, 4074443527, 43887, 17977, 167, 103, 84, 83, 109, 195, 70, 15);
RT_INTERFACE!{interface II2cConnectionSettings(II2cConnectionSettingsVtbl): IInspectable(IInspectableVtbl) [IID_II2cConnectionSettings] {
    fn get_SlaveAddress(&self, out: *mut i32) -> HRESULT,
    fn put_SlaveAddress(&self, value: i32) -> HRESULT,
    fn get_BusSpeed(&self, out: *mut I2cBusSpeed) -> HRESULT,
    fn put_BusSpeed(&self, value: I2cBusSpeed) -> HRESULT,
    fn get_SharingMode(&self, out: *mut I2cSharingMode) -> HRESULT,
    fn put_SharingMode(&self, value: I2cSharingMode) -> HRESULT
}}
impl II2cConnectionSettings {
    #[inline] pub unsafe fn get_slave_address(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SlaveAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_slave_address(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SlaveAddress)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bus_speed(&self) -> Result<I2cBusSpeed> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BusSpeed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bus_speed(&self, value: I2cBusSpeed) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BusSpeed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<I2cSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sharing_mode(&self, value: I2cSharingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class I2cConnectionSettings: II2cConnectionSettings}
impl RtActivatable<II2cConnectionSettingsFactory> for I2cConnectionSettings {}
impl I2cConnectionSettings {
    #[inline] pub fn create(slaveAddress: i32) -> Result<ComPtr<I2cConnectionSettings>> { unsafe {
        <Self as RtActivatable<II2cConnectionSettingsFactory>>::get_activation_factory().create(slaveAddress)
    }}
}
DEFINE_CLSID!(I2cConnectionSettings(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,73,50,99,46,73,50,99,67,111,110,110,101,99,116,105,111,110,83,101,116,116,105,110,103,115,0]) [CLSID_I2cConnectionSettings]);
DEFINE_IID!(IID_II2cConnectionSettingsFactory, 2176157363, 38547, 16817, 162, 67, 222, 212, 246, 230, 105, 38);
RT_INTERFACE!{static interface II2cConnectionSettingsFactory(II2cConnectionSettingsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_II2cConnectionSettingsFactory] {
    fn Create(&self, slaveAddress: i32, out: *mut *mut I2cConnectionSettings) -> HRESULT
}}
impl II2cConnectionSettingsFactory {
    #[inline] pub unsafe fn create(&self, slaveAddress: i32) -> Result<ComPtr<I2cConnectionSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, slaveAddress, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_II2cController, 3297423794, 34720, 16742, 142, 62, 180, 184, 249, 124, 215, 41);
RT_INTERFACE!{interface II2cController(II2cControllerVtbl): IInspectable(IInspectableVtbl) [IID_II2cController] {
    fn GetDevice(&self, settings: *mut I2cConnectionSettings, out: *mut *mut I2cDevice) -> HRESULT
}}
impl II2cController {
    #[inline] pub unsafe fn get_device(&self, settings: &I2cConnectionSettings) -> Result<ComPtr<I2cDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDevice)(self as *const _ as *mut _, settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class I2cController: II2cController}
impl RtActivatable<II2cControllerStatics> for I2cController {}
impl I2cController {
    #[inline] pub fn get_controllers_async(provider: &provider::II2cProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<I2cController>>>> { unsafe {
        <Self as RtActivatable<II2cControllerStatics>>::get_activation_factory().get_controllers_async(provider)
    }}
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<I2cController>>> { unsafe {
        <Self as RtActivatable<II2cControllerStatics>>::get_activation_factory().get_default_async()
    }}
}
DEFINE_CLSID!(I2cController(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,73,50,99,46,73,50,99,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_I2cController]);
DEFINE_IID!(IID_II2cControllerStatics, 1090257765, 24325, 20094, 132, 189, 16, 13, 184, 224, 174, 197);
RT_INTERFACE!{static interface II2cControllerStatics(II2cControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_II2cControllerStatics] {
    fn GetControllersAsync(&self, provider: *mut provider::II2cProvider, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<I2cController>>) -> HRESULT,
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<I2cController>) -> HRESULT
}}
impl II2cControllerStatics {
    #[inline] pub unsafe fn get_controllers_async(&self, provider: &provider::II2cProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<I2cController>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, provider as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<I2cController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_II2cDevice, 2251735350, 47557, 20336, 148, 73, 204, 70, 220, 111, 87, 235);
RT_INTERFACE!{interface II2cDevice(II2cDeviceVtbl): IInspectable(IInspectableVtbl) [IID_II2cDevice] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ConnectionSettings(&self, out: *mut *mut I2cConnectionSettings) -> HRESULT,
    fn Write(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn WritePartial(&self, bufferSize: u32, buffer: *mut u8, out: *mut I2cTransferResult) -> HRESULT,
    fn Read(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn ReadPartial(&self, bufferSize: u32, buffer: *mut u8, out: *mut I2cTransferResult) -> HRESULT,
    fn WriteRead(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8) -> HRESULT,
    fn WriteReadPartial(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8, out: *mut I2cTransferResult) -> HRESULT
}}
impl II2cDevice {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_settings(&self) -> Result<ComPtr<I2cConnectionSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn write(&self, buffer: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Write)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_partial(&self, buffer: &[u8]) -> Result<I2cTransferResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).WritePartial)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self, buffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_partial(&self, buffer: &mut [u8]) -> Result<I2cTransferResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ReadPartial)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_mut_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_read(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).WriteRead)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_read_partial(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<I2cTransferResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).WriteReadPartial)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class I2cDevice: II2cDevice}
impl RtActivatable<II2cDeviceStatics> for I2cDevice {}
impl I2cDevice {
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<II2cDeviceStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn get_device_selector_from_friendly_name(friendlyName: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<II2cDeviceStatics>>::get_activation_factory().get_device_selector_from_friendly_name(friendlyName)
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg, settings: &I2cConnectionSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<I2cDevice>>> { unsafe {
        <Self as RtActivatable<II2cDeviceStatics>>::get_activation_factory().from_id_async(deviceId, settings)
    }}
}
DEFINE_CLSID!(I2cDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,73,50,99,46,73,50,99,68,101,118,105,99,101,0]) [CLSID_I2cDevice]);
DEFINE_IID!(IID_II2cDeviceStatics, 2443394019, 29492, 17682, 150, 188, 251, 174, 148, 89, 245, 246);
RT_INTERFACE!{static interface II2cDeviceStatics(II2cDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_II2cDeviceStatics] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromFriendlyName(&self, friendlyName: HSTRING, out: *mut HSTRING) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, settings: *mut I2cConnectionSettings, out: *mut *mut super::super::foundation::IAsyncOperation<I2cDevice>) -> HRESULT
}}
impl II2cDeviceStatics {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_friendly_name(&self, friendlyName: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromFriendlyName)(self as *const _ as *mut _, friendlyName.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg, settings: &I2cConnectionSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<I2cDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum I2cSharingMode: i32 {
    Exclusive (I2cSharingMode_Exclusive) = 0, Shared (I2cSharingMode_Shared) = 1,
}}
RT_STRUCT! { struct I2cTransferResult {
    Status: I2cTransferStatus, BytesTransferred: u32,
}}
RT_ENUM! { enum I2cTransferStatus: i32 {
    FullTransfer (I2cTransferStatus_FullTransfer) = 0, PartialTransfer (I2cTransferStatus_PartialTransfer) = 1, SlaveAddressNotAcknowledged (I2cTransferStatus_SlaveAddressNotAcknowledged) = 2, ClockStretchTimeout (I2cTransferStatus_ClockStretchTimeout) = 3, UnknownError (I2cTransferStatus_UnknownError) = 4,
}}
pub mod provider { // Windows.Devices.I2c.Provider
use ::prelude::*;
DEFINE_IID!(IID_II2cControllerProvider, 1640151938, 17680, 16739, 168, 124, 78, 21, 169, 85, 137, 128);
RT_INTERFACE!{interface II2cControllerProvider(II2cControllerProviderVtbl): IInspectable(IInspectableVtbl) [IID_II2cControllerProvider] {
    fn GetDeviceProvider(&self, settings: *mut ProviderI2cConnectionSettings, out: *mut *mut II2cDeviceProvider) -> HRESULT
}}
impl II2cControllerProvider {
    #[inline] pub unsafe fn get_device_provider(&self, settings: &ProviderI2cConnectionSettings) -> Result<ComPtr<II2cDeviceProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceProvider)(self as *const _ as *mut _, settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_II2cDeviceProvider, 2905876052, 22504, 17726, 131, 41, 209, 228, 71, 209, 3, 169);
RT_INTERFACE!{interface II2cDeviceProvider(II2cDeviceProviderVtbl): IInspectable(IInspectableVtbl) [IID_II2cDeviceProvider] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn Write(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn WritePartial(&self, bufferSize: u32, buffer: *mut u8, out: *mut ProviderI2cTransferResult) -> HRESULT,
    fn Read(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn ReadPartial(&self, bufferSize: u32, buffer: *mut u8, out: *mut ProviderI2cTransferResult) -> HRESULT,
    fn WriteRead(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8) -> HRESULT,
    fn WriteReadPartial(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8, out: *mut ProviderI2cTransferResult) -> HRESULT
}}
impl II2cDeviceProvider {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn write(&self, buffer: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Write)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_partial(&self, buffer: &[u8]) -> Result<ProviderI2cTransferResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).WritePartial)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self, buffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_partial(&self, buffer: &mut [u8]) -> Result<ProviderI2cTransferResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ReadPartial)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_mut_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_read(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).WriteRead)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_read_partial(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<ProviderI2cTransferResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).WriteReadPartial)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_II2cProvider, 1863518270, 48994, 20450, 169, 90, 240, 137, 153, 102, 152, 24);
RT_INTERFACE!{interface II2cProvider(II2cProviderVtbl): IInspectable(IInspectableVtbl) [IID_II2cProvider] {
    fn GetControllersAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<II2cControllerProvider>>) -> HRESULT
}}
impl II2cProvider {
    #[inline] pub unsafe fn get_controllers_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<II2cControllerProvider>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ProviderI2cBusSpeed: i32 {
    StandardMode (ProviderI2cBusSpeed_StandardMode) = 0, FastMode (ProviderI2cBusSpeed_FastMode) = 1,
}}
DEFINE_IID!(IID_IProviderI2cConnectionSettings, 3923463732, 58640, 17591, 128, 157, 242, 248, 91, 85, 83, 57);
RT_INTERFACE!{interface IProviderI2cConnectionSettings(IProviderI2cConnectionSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IProviderI2cConnectionSettings] {
    fn get_SlaveAddress(&self, out: *mut i32) -> HRESULT,
    fn put_SlaveAddress(&self, value: i32) -> HRESULT,
    fn get_BusSpeed(&self, out: *mut ProviderI2cBusSpeed) -> HRESULT,
    fn put_BusSpeed(&self, value: ProviderI2cBusSpeed) -> HRESULT,
    fn get_SharingMode(&self, out: *mut ProviderI2cSharingMode) -> HRESULT,
    fn put_SharingMode(&self, value: ProviderI2cSharingMode) -> HRESULT
}}
impl IProviderI2cConnectionSettings {
    #[inline] pub unsafe fn get_slave_address(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SlaveAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_slave_address(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SlaveAddress)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bus_speed(&self) -> Result<ProviderI2cBusSpeed> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BusSpeed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bus_speed(&self, value: ProviderI2cBusSpeed) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BusSpeed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<ProviderI2cSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sharing_mode(&self, value: ProviderI2cSharingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ProviderI2cConnectionSettings: IProviderI2cConnectionSettings}
RT_ENUM! { enum ProviderI2cSharingMode: i32 {
    Exclusive (ProviderI2cSharingMode_Exclusive) = 0, Shared (ProviderI2cSharingMode_Shared) = 1,
}}
RT_STRUCT! { struct ProviderI2cTransferResult {
    Status: ProviderI2cTransferStatus, BytesTransferred: u32,
}}
RT_ENUM! { enum ProviderI2cTransferStatus: i32 {
    FullTransfer (ProviderI2cTransferStatus_FullTransfer) = 0, PartialTransfer (ProviderI2cTransferStatus_PartialTransfer) = 1, SlaveAddressNotAcknowledged (ProviderI2cTransferStatus_SlaveAddressNotAcknowledged) = 2,
}}
} // Windows.Devices.I2c.Provider
} // Windows.Devices.I2c
pub mod pwm { // Windows.Devices.Pwm
use ::prelude::*;
DEFINE_IID!(IID_IPwmController, 3294583941, 53992, 17103, 155, 214, 207, 94, 208, 41, 230, 167);
RT_INTERFACE!{interface IPwmController(IPwmControllerVtbl): IInspectable(IInspectableVtbl) [IID_IPwmController] {
    fn get_PinCount(&self, out: *mut i32) -> HRESULT,
    fn get_ActualFrequency(&self, out: *mut f64) -> HRESULT,
    fn SetDesiredFrequency(&self, desiredFrequency: f64, out: *mut f64) -> HRESULT,
    fn get_MinFrequency(&self, out: *mut f64) -> HRESULT,
    fn get_MaxFrequency(&self, out: *mut f64) -> HRESULT,
    fn OpenPin(&self, pinNumber: i32, out: *mut *mut PwmPin) -> HRESULT
}}
impl IPwmController {
    #[inline] pub unsafe fn get_pin_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PinCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_frequency(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActualFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_frequency(&self, desiredFrequency: f64) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SetDesiredFrequency)(self as *const _ as *mut _, desiredFrequency, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_frequency(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_frequency(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_pin(&self, pinNumber: i32) -> Result<ComPtr<PwmPin>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenPin)(self as *const _ as *mut _, pinNumber, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PwmController: IPwmController}
impl RtActivatable<IPwmControllerStatics> for PwmController {}
impl RtActivatable<IPwmControllerStatics2> for PwmController {}
impl RtActivatable<IPwmControllerStatics3> for PwmController {}
impl PwmController {
    #[inline] pub fn get_controllers_async(provider: &provider::IPwmProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<PwmController>>>> { unsafe {
        <Self as RtActivatable<IPwmControllerStatics>>::get_activation_factory().get_controllers_async(provider)
    }}
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<PwmController>>> { unsafe {
        <Self as RtActivatable<IPwmControllerStatics2>>::get_activation_factory().get_default_async()
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IPwmControllerStatics3>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn get_device_selector_from_friendly_name(friendlyName: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<IPwmControllerStatics3>>::get_activation_factory().get_device_selector_from_friendly_name(friendlyName)
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PwmController>>> { unsafe {
        <Self as RtActivatable<IPwmControllerStatics3>>::get_activation_factory().from_id_async(deviceId)
    }}
}
DEFINE_CLSID!(PwmController(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,80,119,109,46,80,119,109,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_PwmController]);
DEFINE_IID!(IID_IPwmControllerStatics, 1113832865, 35142, 17412, 189, 72, 129, 221, 18, 74, 244, 217);
RT_INTERFACE!{static interface IPwmControllerStatics(IPwmControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPwmControllerStatics] {
    fn GetControllersAsync(&self, provider: *mut provider::IPwmProvider, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<PwmController>>) -> HRESULT
}}
impl IPwmControllerStatics {
    #[inline] pub unsafe fn get_controllers_async(&self, provider: &provider::IPwmProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<PwmController>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, provider as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPwmControllerStatics2, 1157389087, 61721, 19421, 151, 173, 247, 110, 249, 134, 115, 109);
RT_INTERFACE!{static interface IPwmControllerStatics2(IPwmControllerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IPwmControllerStatics2] {
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<PwmController>) -> HRESULT
}}
impl IPwmControllerStatics2 {
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PwmController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPwmControllerStatics3, 2992117873, 553, 17220, 174, 63, 155, 124, 208, 230, 107, 148);
RT_INTERFACE!{static interface IPwmControllerStatics3(IPwmControllerStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IPwmControllerStatics3] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromFriendlyName(&self, friendlyName: HSTRING, out: *mut HSTRING) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<PwmController>) -> HRESULT
}}
impl IPwmControllerStatics3 {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_friendly_name(&self, friendlyName: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromFriendlyName)(self as *const _ as *mut _, friendlyName.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<PwmController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPwmPin, 580333000, 50895, 18465, 183, 249, 198, 69, 79, 182, 175, 121);
RT_INTERFACE!{interface IPwmPin(IPwmPinVtbl): IInspectable(IInspectableVtbl) [IID_IPwmPin] {
    fn get_Controller(&self, out: *mut *mut PwmController) -> HRESULT,
    fn GetActiveDutyCyclePercentage(&self, out: *mut f64) -> HRESULT,
    fn SetActiveDutyCyclePercentage(&self, dutyCyclePercentage: f64) -> HRESULT,
    fn get_Polarity(&self, out: *mut PwmPulsePolarity) -> HRESULT,
    fn put_Polarity(&self, value: PwmPulsePolarity) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn get_IsStarted(&self, out: *mut bool) -> HRESULT
}}
impl IPwmPin {
    #[inline] pub unsafe fn get_controller(&self) -> Result<ComPtr<PwmController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Controller)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_active_duty_cycle_percentage(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetActiveDutyCyclePercentage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_active_duty_cycle_percentage(&self, dutyCyclePercentage: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).SetActiveDutyCyclePercentage)(self as *const _ as *mut _, dutyCyclePercentage);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_polarity(&self) -> Result<PwmPulsePolarity> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Polarity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_polarity(&self, value: PwmPulsePolarity) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Polarity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_started(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsStarted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PwmPin: IPwmPin}
RT_ENUM! { enum PwmPulsePolarity: i32 {
    ActiveHigh (PwmPulsePolarity_ActiveHigh) = 0, ActiveLow (PwmPulsePolarity_ActiveLow) = 1,
}}
pub mod provider { // Windows.Devices.Pwm.Provider
use ::prelude::*;
DEFINE_IID!(IID_IPwmControllerProvider, 318789947, 58083, 16548, 183, 217, 72, 223, 240, 55, 122, 82);
RT_INTERFACE!{interface IPwmControllerProvider(IPwmControllerProviderVtbl): IInspectable(IInspectableVtbl) [IID_IPwmControllerProvider] {
    fn get_PinCount(&self, out: *mut i32) -> HRESULT,
    fn get_ActualFrequency(&self, out: *mut f64) -> HRESULT,
    fn SetDesiredFrequency(&self, frequency: f64, out: *mut f64) -> HRESULT,
    fn get_MaxFrequency(&self, out: *mut f64) -> HRESULT,
    fn get_MinFrequency(&self, out: *mut f64) -> HRESULT,
    fn AcquirePin(&self, pin: i32) -> HRESULT,
    fn ReleasePin(&self, pin: i32) -> HRESULT,
    fn EnablePin(&self, pin: i32) -> HRESULT,
    fn DisablePin(&self, pin: i32) -> HRESULT,
    fn SetPulseParameters(&self, pin: i32, dutyCycle: f64, invertPolarity: bool) -> HRESULT
}}
impl IPwmControllerProvider {
    #[inline] pub unsafe fn get_pin_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PinCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_frequency(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActualFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_frequency(&self, frequency: f64) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SetDesiredFrequency)(self as *const _ as *mut _, frequency, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_frequency(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_frequency(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn acquire_pin(&self, pin: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).AcquirePin)(self as *const _ as *mut _, pin);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn release_pin(&self, pin: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).ReleasePin)(self as *const _ as *mut _, pin);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn enable_pin(&self, pin: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).EnablePin)(self as *const _ as *mut _, pin);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn disable_pin(&self, pin: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).DisablePin)(self as *const _ as *mut _, pin);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pulse_parameters(&self, pin: i32, dutyCycle: f64, invertPolarity: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPulseParameters)(self as *const _ as *mut _, pin, dutyCycle, invertPolarity);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPwmProvider, 2737836584, 21233, 18352, 147, 73, 102, 186, 67, 210, 89, 2);
RT_INTERFACE!{interface IPwmProvider(IPwmProviderVtbl): IInspectable(IInspectableVtbl) [IID_IPwmProvider] {
    fn GetControllers(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IPwmControllerProvider>) -> HRESULT
}}
impl IPwmProvider {
    #[inline] pub unsafe fn get_controllers(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IPwmControllerProvider>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Devices.Pwm.Provider
} // Windows.Devices.Pwm
pub mod spi { // Windows.Devices.Spi
use ::prelude::*;
DEFINE_IID!(IID_ISpiBusInfo, 2569618506, 21746, 18630, 185, 82, 156, 50, 252, 2, 198, 105);
RT_INTERFACE!{interface ISpiBusInfo(ISpiBusInfoVtbl): IInspectable(IInspectableVtbl) [IID_ISpiBusInfo] {
    fn get_ChipSelectLineCount(&self, out: *mut i32) -> HRESULT,
    fn get_MinClockFrequency(&self, out: *mut i32) -> HRESULT,
    fn get_MaxClockFrequency(&self, out: *mut i32) -> HRESULT,
    fn get_SupportedDataBitLengths(&self, out: *mut *mut super::super::foundation::collections::IVectorView<i32>) -> HRESULT
}}
impl ISpiBusInfo {
    #[inline] pub unsafe fn get_chip_select_line_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChipSelectLineCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_clock_frequency(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinClockFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_clock_frequency(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxClockFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_data_bit_lengths(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedDataBitLengths)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpiBusInfo: ISpiBusInfo}
DEFINE_IID!(IID_ISpiConnectionSettings, 1384358783, 63797, 19359, 167, 167, 58, 120, 144, 175, 165, 206);
RT_INTERFACE!{interface ISpiConnectionSettings(ISpiConnectionSettingsVtbl): IInspectable(IInspectableVtbl) [IID_ISpiConnectionSettings] {
    fn get_ChipSelectLine(&self, out: *mut i32) -> HRESULT,
    fn put_ChipSelectLine(&self, value: i32) -> HRESULT,
    fn get_Mode(&self, out: *mut SpiMode) -> HRESULT,
    fn put_Mode(&self, value: SpiMode) -> HRESULT,
    fn get_DataBitLength(&self, out: *mut i32) -> HRESULT,
    fn put_DataBitLength(&self, value: i32) -> HRESULT,
    fn get_ClockFrequency(&self, out: *mut i32) -> HRESULT,
    fn put_ClockFrequency(&self, value: i32) -> HRESULT,
    fn get_SharingMode(&self, out: *mut SpiSharingMode) -> HRESULT,
    fn put_SharingMode(&self, value: SpiSharingMode) -> HRESULT
}}
impl ISpiConnectionSettings {
    #[inline] pub unsafe fn get_chip_select_line(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChipSelectLine)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_chip_select_line(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChipSelectLine)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<SpiMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: SpiMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_bit_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DataBitLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data_bit_length(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataBitLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clock_frequency(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClockFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_clock_frequency(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ClockFrequency)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<SpiSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sharing_mode(&self, value: SpiSharingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SpiConnectionSettings: ISpiConnectionSettings}
impl RtActivatable<ISpiConnectionSettingsFactory> for SpiConnectionSettings {}
impl SpiConnectionSettings {
    #[inline] pub fn create(chipSelectLine: i32) -> Result<ComPtr<SpiConnectionSettings>> { unsafe {
        <Self as RtActivatable<ISpiConnectionSettingsFactory>>::get_activation_factory().create(chipSelectLine)
    }}
}
DEFINE_CLSID!(SpiConnectionSettings(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,112,105,46,83,112,105,67,111,110,110,101,99,116,105,111,110,83,101,116,116,105,110,103,115,0]) [CLSID_SpiConnectionSettings]);
DEFINE_IID!(IID_ISpiConnectionSettingsFactory, 4288219166, 4292, 17591, 159, 234, 167, 72, 181, 164, 111, 49);
RT_INTERFACE!{static interface ISpiConnectionSettingsFactory(ISpiConnectionSettingsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISpiConnectionSettingsFactory] {
    fn Create(&self, chipSelectLine: i32, out: *mut *mut SpiConnectionSettings) -> HRESULT
}}
impl ISpiConnectionSettingsFactory {
    #[inline] pub unsafe fn create(&self, chipSelectLine: i32) -> Result<ComPtr<SpiConnectionSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, chipSelectLine, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpiController, 2832451625, 39061, 16729, 169, 52, 135, 65, 241, 238, 109, 39);
RT_INTERFACE!{interface ISpiController(ISpiControllerVtbl): IInspectable(IInspectableVtbl) [IID_ISpiController] {
    fn GetDevice(&self, settings: *mut SpiConnectionSettings, out: *mut *mut SpiDevice) -> HRESULT
}}
impl ISpiController {
    #[inline] pub unsafe fn get_device(&self, settings: &SpiConnectionSettings) -> Result<ComPtr<SpiDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDevice)(self as *const _ as *mut _, settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpiController: ISpiController}
impl RtActivatable<ISpiControllerStatics> for SpiController {}
impl SpiController {
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<SpiController>>> { unsafe {
        <Self as RtActivatable<ISpiControllerStatics>>::get_activation_factory().get_default_async()
    }}
    #[inline] pub fn get_controllers_async(provider: &provider::ISpiProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SpiController>>>> { unsafe {
        <Self as RtActivatable<ISpiControllerStatics>>::get_activation_factory().get_controllers_async(provider)
    }}
}
DEFINE_CLSID!(SpiController(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,112,105,46,83,112,105,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_SpiController]);
DEFINE_IID!(IID_ISpiControllerStatics, 223488482, 5003, 20040, 185, 100, 79, 47, 121, 185, 197, 162);
RT_INTERFACE!{static interface ISpiControllerStatics(ISpiControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISpiControllerStatics] {
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SpiController>) -> HRESULT,
    fn GetControllersAsync(&self, provider: *mut provider::ISpiProvider, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SpiController>>) -> HRESULT
}}
impl ISpiControllerStatics {
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SpiController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_controllers_async(&self, provider: &provider::ISpiProvider) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SpiController>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, provider as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpiDevice, 97858925, 4534, 19769, 132, 213, 149, 223, 180, 201, 242, 206);
RT_INTERFACE!{interface ISpiDevice(ISpiDeviceVtbl): IInspectable(IInspectableVtbl) [IID_ISpiDevice] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ConnectionSettings(&self, out: *mut *mut SpiConnectionSettings) -> HRESULT,
    fn Write(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn Read(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn TransferSequential(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8) -> HRESULT,
    fn TransferFullDuplex(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8) -> HRESULT
}}
impl ISpiDevice {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_settings(&self) -> Result<ComPtr<SpiConnectionSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn write(&self, buffer: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Write)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self, buffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn transfer_sequential(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).TransferSequential)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn transfer_full_duplex(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).TransferFullDuplex)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SpiDevice: ISpiDevice}
impl RtActivatable<ISpiDeviceStatics> for SpiDevice {}
impl SpiDevice {
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<ISpiDeviceStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn get_device_selector_from_friendly_name(friendlyName: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<ISpiDeviceStatics>>::get_activation_factory().get_device_selector_from_friendly_name(friendlyName)
    }}
    #[inline] pub fn get_bus_info(busId: &HStringArg) -> Result<ComPtr<SpiBusInfo>> { unsafe {
        <Self as RtActivatable<ISpiDeviceStatics>>::get_activation_factory().get_bus_info(busId)
    }}
    #[inline] pub fn from_id_async(busId: &HStringArg, settings: &SpiConnectionSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SpiDevice>>> { unsafe {
        <Self as RtActivatable<ISpiDeviceStatics>>::get_activation_factory().from_id_async(busId, settings)
    }}
}
DEFINE_CLSID!(SpiDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,112,105,46,83,112,105,68,101,118,105,99,101,0]) [CLSID_SpiDevice]);
DEFINE_IID!(IID_ISpiDeviceStatics, 2725832025, 22304, 19775, 189, 147, 86, 245, 255, 90, 88, 121);
RT_INTERFACE!{static interface ISpiDeviceStatics(ISpiDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISpiDeviceStatics] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromFriendlyName(&self, friendlyName: HSTRING, out: *mut HSTRING) -> HRESULT,
    fn GetBusInfo(&self, busId: HSTRING, out: *mut *mut SpiBusInfo) -> HRESULT,
    fn FromIdAsync(&self, busId: HSTRING, settings: *mut SpiConnectionSettings, out: *mut *mut super::super::foundation::IAsyncOperation<SpiDevice>) -> HRESULT
}}
impl ISpiDeviceStatics {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_friendly_name(&self, friendlyName: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromFriendlyName)(self as *const _ as *mut _, friendlyName.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bus_info(&self, busId: &HStringArg) -> Result<ComPtr<SpiBusInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetBusInfo)(self as *const _ as *mut _, busId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, busId: &HStringArg, settings: &SpiConnectionSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SpiDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, busId.get(), settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SpiMode: i32 {
    Mode0 (SpiMode_Mode0) = 0, Mode1 (SpiMode_Mode1) = 1, Mode2 (SpiMode_Mode2) = 2, Mode3 (SpiMode_Mode3) = 3,
}}
RT_ENUM! { enum SpiSharingMode: i32 {
    Exclusive (SpiSharingMode_Exclusive) = 0, Shared (SpiSharingMode_Shared) = 1,
}}
pub mod provider { // Windows.Devices.Spi.Provider
use ::prelude::*;
DEFINE_IID!(IID_IProviderSpiConnectionSettings, 4127409488, 42306, 20160, 150, 1, 164, 221, 104, 248, 105, 123);
RT_INTERFACE!{interface IProviderSpiConnectionSettings(IProviderSpiConnectionSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IProviderSpiConnectionSettings] {
    fn get_ChipSelectLine(&self, out: *mut i32) -> HRESULT,
    fn put_ChipSelectLine(&self, value: i32) -> HRESULT,
    fn get_Mode(&self, out: *mut ProviderSpiMode) -> HRESULT,
    fn put_Mode(&self, value: ProviderSpiMode) -> HRESULT,
    fn get_DataBitLength(&self, out: *mut i32) -> HRESULT,
    fn put_DataBitLength(&self, value: i32) -> HRESULT,
    fn get_ClockFrequency(&self, out: *mut i32) -> HRESULT,
    fn put_ClockFrequency(&self, value: i32) -> HRESULT,
    fn get_SharingMode(&self, out: *mut ProviderSpiSharingMode) -> HRESULT,
    fn put_SharingMode(&self, value: ProviderSpiSharingMode) -> HRESULT
}}
impl IProviderSpiConnectionSettings {
    #[inline] pub unsafe fn get_chip_select_line(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ChipSelectLine)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_chip_select_line(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChipSelectLine)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<ProviderSpiMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: ProviderSpiMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_bit_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DataBitLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data_bit_length(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataBitLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clock_frequency(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClockFrequency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_clock_frequency(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ClockFrequency)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<ProviderSpiSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sharing_mode(&self, value: ProviderSpiSharingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ProviderSpiConnectionSettings: IProviderSpiConnectionSettings}
impl RtActivatable<IProviderSpiConnectionSettingsFactory> for ProviderSpiConnectionSettings {}
impl ProviderSpiConnectionSettings {
    #[inline] pub fn create(chipSelectLine: i32) -> Result<ComPtr<ProviderSpiConnectionSettings>> { unsafe {
        <Self as RtActivatable<IProviderSpiConnectionSettingsFactory>>::get_activation_factory().create(chipSelectLine)
    }}
}
DEFINE_CLSID!(ProviderSpiConnectionSettings(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,112,105,46,80,114,111,118,105,100,101,114,46,80,114,111,118,105,100,101,114,83,112,105,67,111,110,110,101,99,116,105,111,110,83,101,116,116,105,110,103,115,0]) [CLSID_ProviderSpiConnectionSettings]);
DEFINE_IID!(IID_IProviderSpiConnectionSettingsFactory, 1715825498, 3193, 17379, 159, 60, 229, 151, 128, 172, 24, 250);
RT_INTERFACE!{static interface IProviderSpiConnectionSettingsFactory(IProviderSpiConnectionSettingsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IProviderSpiConnectionSettingsFactory] {
    fn Create(&self, chipSelectLine: i32, out: *mut *mut ProviderSpiConnectionSettings) -> HRESULT
}}
impl IProviderSpiConnectionSettingsFactory {
    #[inline] pub unsafe fn create(&self, chipSelectLine: i32) -> Result<ComPtr<ProviderSpiConnectionSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, chipSelectLine, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ProviderSpiMode: i32 {
    Mode0 (ProviderSpiMode_Mode0) = 0, Mode1 (ProviderSpiMode_Mode1) = 1, Mode2 (ProviderSpiMode_Mode2) = 2, Mode3 (ProviderSpiMode_Mode3) = 3,
}}
RT_ENUM! { enum ProviderSpiSharingMode: i32 {
    Exclusive (ProviderSpiSharingMode_Exclusive) = 0, Shared (ProviderSpiSharingMode_Shared) = 1,
}}
DEFINE_IID!(IID_ISpiControllerProvider, 3244844292, 718, 16934, 163, 133, 79, 17, 251, 4, 180, 27);
RT_INTERFACE!{interface ISpiControllerProvider(ISpiControllerProviderVtbl): IInspectable(IInspectableVtbl) [IID_ISpiControllerProvider] {
    fn GetDeviceProvider(&self, settings: *mut ProviderSpiConnectionSettings, out: *mut *mut ISpiDeviceProvider) -> HRESULT
}}
impl ISpiControllerProvider {
    #[inline] pub unsafe fn get_device_provider(&self, settings: &ProviderSpiConnectionSettings) -> Result<ComPtr<ISpiDeviceProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceProvider)(self as *const _ as *mut _, settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpiDeviceProvider, 219952195, 12363, 16476, 180, 247, 245, 171, 16, 116, 70, 30);
RT_INTERFACE!{interface ISpiDeviceProvider(ISpiDeviceProviderVtbl): IInspectable(IInspectableVtbl) [IID_ISpiDeviceProvider] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ConnectionSettings(&self, out: *mut *mut ProviderSpiConnectionSettings) -> HRESULT,
    fn Write(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn Read(&self, bufferSize: u32, buffer: *mut u8) -> HRESULT,
    fn TransferSequential(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8) -> HRESULT,
    fn TransferFullDuplex(&self, writeBufferSize: u32, writeBuffer: *mut u8, readBufferSize: u32, readBuffer: *mut u8) -> HRESULT
}}
impl ISpiDeviceProvider {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_settings(&self) -> Result<ComPtr<ProviderSpiConnectionSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn write(&self, buffer: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Write)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read(&self, buffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).Read)(self as *const _ as *mut _, buffer.len() as u32, buffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn transfer_sequential(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).TransferSequential)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn transfer_full_duplex(&self, writeBuffer: &[u8], readBuffer: &mut [u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).TransferFullDuplex)(self as *const _ as *mut _, writeBuffer.len() as u32, writeBuffer.as_ptr() as *mut _, readBuffer.len() as u32, readBuffer.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpiProvider, 2528403938, 30676, 18638, 170, 160, 117, 113, 90, 131, 98, 207);
RT_INTERFACE!{interface ISpiProvider(ISpiProviderVtbl): IInspectable(IInspectableVtbl) [IID_ISpiProvider] {
    fn GetControllersAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<ISpiControllerProvider>>) -> HRESULT
}}
impl ISpiProvider {
    #[inline] pub unsafe fn get_controllers_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<ISpiControllerProvider>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetControllersAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Devices.Spi.Provider
} // Windows.Devices.Spi
pub mod smartcards { // Windows.Devices.SmartCards
use ::prelude::*;
DEFINE_IID!(IID_ICardAddedEventArgs, 414969752, 61835, 19923, 177, 24, 223, 178, 200, 226, 60, 198);
RT_INTERFACE!{interface ICardAddedEventArgs(ICardAddedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICardAddedEventArgs] {
    fn get_SmartCard(&self, out: *mut *mut SmartCard) -> HRESULT
}}
impl ICardAddedEventArgs {
    #[inline] pub unsafe fn get_smart_card(&self) -> Result<ComPtr<SmartCard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmartCard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CardAddedEventArgs: ICardAddedEventArgs}
DEFINE_IID!(IID_ICardRemovedEventArgs, 355670703, 8919, 18757, 175, 201, 3, 180, 111, 66, 166, 205);
RT_INTERFACE!{interface ICardRemovedEventArgs(ICardRemovedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICardRemovedEventArgs] {
    fn get_SmartCard(&self, out: *mut *mut SmartCard) -> HRESULT
}}
impl ICardRemovedEventArgs {
    #[inline] pub unsafe fn get_smart_card(&self) -> Result<ComPtr<SmartCard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmartCard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CardRemovedEventArgs: ICardRemovedEventArgs}
DEFINE_IID!(IID_ISmartCard, 460425329, 25652, 17396, 181, 90, 106, 41, 98, 56, 112, 170);
RT_INTERFACE!{interface ISmartCard(ISmartCardVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCard] {
    fn get_Reader(&self, out: *mut *mut SmartCardReader) -> HRESULT,
    fn GetStatusAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardStatus>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn GetAnswerToResetAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::IBuffer>) -> HRESULT
}}
impl ISmartCard {
    #[inline] pub unsafe fn get_reader(&self) -> Result<ComPtr<SmartCardReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Reader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStatusAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_answer_to_reset_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::IBuffer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAnswerToResetAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCard: ISmartCard}
RT_ENUM! { enum SmartCardActivationPolicyChangeResult: i32 {
    Denied (SmartCardActivationPolicyChangeResult_Denied) = 0, Allowed (SmartCardActivationPolicyChangeResult_Allowed) = 1,
}}
DEFINE_IID!(IID_ISmartCardAppletIdGroup, 2108777958, 25188, 22260, 94, 3, 200, 99, 133, 57, 94, 177);
RT_INTERFACE!{interface ISmartCardAppletIdGroup(ISmartCardAppletIdGroupVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAppletIdGroup] {
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_AppletIds(&self, out: *mut *mut super::super::foundation::collections::IVector<super::super::storage::streams::IBuffer>) -> HRESULT,
    fn get_SmartCardEmulationCategory(&self, out: *mut SmartCardEmulationCategory) -> HRESULT,
    fn put_SmartCardEmulationCategory(&self, value: SmartCardEmulationCategory) -> HRESULT,
    fn get_SmartCardEmulationType(&self, out: *mut SmartCardEmulationType) -> HRESULT,
    fn put_SmartCardEmulationType(&self, value: SmartCardEmulationType) -> HRESULT,
    fn get_AutomaticEnablement(&self, out: *mut bool) -> HRESULT,
    fn put_AutomaticEnablement(&self, value: bool) -> HRESULT
}}
impl ISmartCardAppletIdGroup {
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_applet_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::super::storage::streams::IBuffer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppletIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_smart_card_emulation_category(&self) -> Result<SmartCardEmulationCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SmartCardEmulationCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_smart_card_emulation_category(&self, value: SmartCardEmulationCategory) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SmartCardEmulationCategory)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_smart_card_emulation_type(&self) -> Result<SmartCardEmulationType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SmartCardEmulationType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_smart_card_emulation_type(&self, value: SmartCardEmulationType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SmartCardEmulationType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_automatic_enablement(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutomaticEnablement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_automatic_enablement(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutomaticEnablement)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardAppletIdGroup: ISmartCardAppletIdGroup}
impl RtActivatable<ISmartCardAppletIdGroupFactory> for SmartCardAppletIdGroup {}
impl RtActivatable<ISmartCardAppletIdGroupStatics> for SmartCardAppletIdGroup {}
impl RtActivatable<IActivationFactory> for SmartCardAppletIdGroup {}
impl SmartCardAppletIdGroup {
    #[cfg(feature="windows-storage")] #[inline] pub fn create(displayName: &HStringArg, appletIds: &super::super::foundation::collections::IVector<super::super::storage::streams::IBuffer>, emulationCategory: SmartCardEmulationCategory, emulationType: SmartCardEmulationType) -> Result<ComPtr<SmartCardAppletIdGroup>> { unsafe {
        <Self as RtActivatable<ISmartCardAppletIdGroupFactory>>::get_activation_factory().create(displayName, appletIds, emulationCategory, emulationType)
    }}
    #[inline] pub fn get_max_applet_ids() -> Result<u16> { unsafe {
        <Self as RtActivatable<ISmartCardAppletIdGroupStatics>>::get_activation_factory().get_max_applet_ids()
    }}
}
DEFINE_CLSID!(SmartCardAppletIdGroup(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,65,112,112,108,101,116,73,100,71,114,111,117,112,0]) [CLSID_SmartCardAppletIdGroup]);
RT_ENUM! { enum SmartCardAppletIdGroupActivationPolicy: i32 {
    Disabled (SmartCardAppletIdGroupActivationPolicy_Disabled) = 0, ForegroundOverride (SmartCardAppletIdGroupActivationPolicy_ForegroundOverride) = 1, Enabled (SmartCardAppletIdGroupActivationPolicy_Enabled) = 2,
}}
DEFINE_IID!(IID_ISmartCardAppletIdGroupFactory, 2433084237, 19045, 20033, 128, 97, 203, 232, 63, 54, 149, 229);
RT_INTERFACE!{static interface ISmartCardAppletIdGroupFactory(ISmartCardAppletIdGroupFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAppletIdGroupFactory] {
    #[cfg(feature="windows-storage")] fn Create(&self, displayName: HSTRING, appletIds: *mut super::super::foundation::collections::IVector<super::super::storage::streams::IBuffer>, emulationCategory: SmartCardEmulationCategory, emulationType: SmartCardEmulationType, out: *mut *mut SmartCardAppletIdGroup) -> HRESULT
}}
impl ISmartCardAppletIdGroupFactory {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create(&self, displayName: &HStringArg, appletIds: &super::super::foundation::collections::IVector<super::super::storage::streams::IBuffer>, emulationCategory: SmartCardEmulationCategory, emulationType: SmartCardEmulationType) -> Result<ComPtr<SmartCardAppletIdGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, displayName.get(), appletIds as *const _ as *mut _, emulationCategory, emulationType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardAppletIdGroupRegistration, 3742501073, 12731, 21910, 67, 177, 109, 105, 160, 37, 123, 58);
RT_INTERFACE!{interface ISmartCardAppletIdGroupRegistration(ISmartCardAppletIdGroupRegistrationVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAppletIdGroupRegistration] {
    fn get_ActivationPolicy(&self, out: *mut SmartCardAppletIdGroupActivationPolicy) -> HRESULT,
    fn get_AppletIdGroup(&self, out: *mut *mut SmartCardAppletIdGroup) -> HRESULT,
    fn RequestActivationPolicyChangeAsync(&self, policy: SmartCardAppletIdGroupActivationPolicy, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardActivationPolicyChangeResult>) -> HRESULT,
    fn get_Id(&self, out: *mut Guid) -> HRESULT,
    fn SetAutomaticResponseApdusAsync(&self, apdus: *mut super::super::foundation::collections::IIterable<SmartCardAutomaticResponseApdu>, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ISmartCardAppletIdGroupRegistration {
    #[inline] pub unsafe fn get_activation_policy(&self) -> Result<SmartCardAppletIdGroupActivationPolicy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivationPolicy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_applet_id_group(&self) -> Result<ComPtr<SmartCardAppletIdGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppletIdGroup)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_activation_policy_change_async(&self, policy: SmartCardAppletIdGroupActivationPolicy) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardActivationPolicyChangeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestActivationPolicyChangeAsync)(self as *const _ as *mut _, policy, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_automatic_response_apdus_async(&self, apdus: &super::super::foundation::collections::IIterable<SmartCardAutomaticResponseApdu>) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetAutomaticResponseApdusAsync)(self as *const _ as *mut _, apdus as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardAppletIdGroupRegistration: ISmartCardAppletIdGroupRegistration}
DEFINE_IID!(IID_ISmartCardAppletIdGroupStatics, 2871564713, 59244, 17871, 191, 29, 144, 234, 166, 32, 89, 39);
RT_INTERFACE!{static interface ISmartCardAppletIdGroupStatics(ISmartCardAppletIdGroupStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAppletIdGroupStatics] {
    fn get_MaxAppletIds(&self, out: *mut u16) -> HRESULT
}}
impl ISmartCardAppletIdGroupStatics {
    #[inline] pub unsafe fn get_max_applet_ids(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxAppletIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardAutomaticResponseApdu, 1377119147, 50750, 17713, 168, 87, 215, 86, 217, 155, 152, 106);
RT_INTERFACE!{interface ISmartCardAutomaticResponseApdu(ISmartCardAutomaticResponseApduVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAutomaticResponseApdu] {
    #[cfg(feature="windows-storage")] fn get_CommandApdu(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_CommandApdu(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_CommandApduBitMask(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_CommandApduBitMask(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_ShouldMatchLength(&self, out: *mut bool) -> HRESULT,
    fn put_ShouldMatchLength(&self, value: bool) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_AppletId(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_AppletId(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_ResponseApdu(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_ResponseApdu(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl ISmartCardAutomaticResponseApdu {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_command_apdu(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommandApdu)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_command_apdu(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CommandApdu)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_command_apdu_bit_mask(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommandApduBitMask)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_command_apdu_bit_mask(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CommandApduBitMask)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_match_length(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldMatchLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_should_match_length(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShouldMatchLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_applet_id(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppletId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_applet_id(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppletId)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_response_apdu(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ResponseApdu)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_response_apdu(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ResponseApdu)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardAutomaticResponseApdu: ISmartCardAutomaticResponseApdu}
impl RtActivatable<ISmartCardAutomaticResponseApduFactory> for SmartCardAutomaticResponseApdu {}
impl SmartCardAutomaticResponseApdu {
    #[cfg(feature="windows-storage")] #[inline] pub fn create(commandApdu: &super::super::storage::streams::IBuffer, responseApdu: &super::super::storage::streams::IBuffer) -> Result<ComPtr<SmartCardAutomaticResponseApdu>> { unsafe {
        <Self as RtActivatable<ISmartCardAutomaticResponseApduFactory>>::get_activation_factory().create(commandApdu, responseApdu)
    }}
}
DEFINE_CLSID!(SmartCardAutomaticResponseApdu(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,65,117,116,111,109,97,116,105,99,82,101,115,112,111,110,115,101,65,112,100,117,0]) [CLSID_SmartCardAutomaticResponseApdu]);
DEFINE_IID!(IID_ISmartCardAutomaticResponseApdu2, 1152301844, 21917, 17713, 78, 81, 137, 219, 111, 168, 165, 122);
RT_INTERFACE!{interface ISmartCardAutomaticResponseApdu2(ISmartCardAutomaticResponseApdu2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAutomaticResponseApdu2] {
    fn get_InputState(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_InputState(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_OutputState(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_OutputState(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT
}}
impl ISmartCardAutomaticResponseApdu2 {
    #[inline] pub unsafe fn get_input_state(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InputState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_input_state(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InputState)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_output_state(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutputState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_output_state(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutputState)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardAutomaticResponseApdu3, 3208895092, 25974, 17298, 147, 103, 254, 59, 201, 226, 212, 150);
RT_INTERFACE!{interface ISmartCardAutomaticResponseApdu3(ISmartCardAutomaticResponseApdu3Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAutomaticResponseApdu3] {
    fn get_AllowWhenCryptogramGeneratorNotPrepared(&self, out: *mut bool) -> HRESULT,
    fn put_AllowWhenCryptogramGeneratorNotPrepared(&self, value: bool) -> HRESULT
}}
impl ISmartCardAutomaticResponseApdu3 {
    #[inline] pub unsafe fn get_allow_when_cryptogram_generator_not_prepared(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowWhenCryptogramGeneratorNotPrepared)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_when_cryptogram_generator_not_prepared(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowWhenCryptogramGeneratorNotPrepared)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardAutomaticResponseApduFactory, 3917390586, 53292, 19541, 176, 42, 140, 255, 127, 169, 240, 91);
RT_INTERFACE!{static interface ISmartCardAutomaticResponseApduFactory(ISmartCardAutomaticResponseApduFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardAutomaticResponseApduFactory] {
    #[cfg(feature="windows-storage")] fn Create(&self, commandApdu: *mut super::super::storage::streams::IBuffer, responseApdu: *mut super::super::storage::streams::IBuffer, out: *mut *mut SmartCardAutomaticResponseApdu) -> HRESULT
}}
impl ISmartCardAutomaticResponseApduFactory {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create(&self, commandApdu: &super::super::storage::streams::IBuffer, responseApdu: &super::super::storage::streams::IBuffer) -> Result<ComPtr<SmartCardAutomaticResponseApdu>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, commandApdu as *const _ as *mut _, responseApdu as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmartCardAutomaticResponseStatus: i32 {
    None (SmartCardAutomaticResponseStatus_None) = 0, Success (SmartCardAutomaticResponseStatus_Success) = 1, UnknownError (SmartCardAutomaticResponseStatus_UnknownError) = 2,
}}
DEFINE_IID!(IID_ISmartCardChallengeContext, 422204185, 51652, 18759, 129, 204, 68, 121, 74, 97, 239, 145);
RT_INTERFACE!{interface ISmartCardChallengeContext(ISmartCardChallengeContextVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardChallengeContext] {
    #[cfg(feature="windows-storage")] fn get_Challenge(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn VerifyResponseAsync(&self, response: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn ProvisionAsync(&self, response: *mut super::super::storage::streams::IBuffer, formatCard: bool, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(feature="windows-storage")] fn ProvisionAsyncWithNewCardId(&self, response: *mut super::super::storage::streams::IBuffer, formatCard: bool, newCardId: Guid, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(feature="windows-storage")] fn ChangeAdministrativeKeyAsync(&self, response: *mut super::super::storage::streams::IBuffer, newAdministrativeKey: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ISmartCardChallengeContext {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_challenge(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Challenge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn verify_response_async(&self, response: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).VerifyResponseAsync)(self as *const _ as *mut _, response as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn provision_async(&self, response: &super::super::storage::streams::IBuffer, formatCard: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ProvisionAsync)(self as *const _ as *mut _, response as *const _ as *mut _, formatCard, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn provision_async_with_new_card_id(&self, response: &super::super::storage::streams::IBuffer, formatCard: bool, newCardId: Guid) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ProvisionAsyncWithNewCardId)(self as *const _ as *mut _, response as *const _ as *mut _, formatCard, newCardId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn change_administrative_key_async(&self, response: &super::super::storage::streams::IBuffer, newAdministrativeKey: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ChangeAdministrativeKeyAsync)(self as *const _ as *mut _, response as *const _ as *mut _, newAdministrativeKey as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardChallengeContext: ISmartCardChallengeContext}
DEFINE_IID!(IID_ISmartCardConnect, 803178469, 653, 18718, 160, 88, 51, 130, 195, 152, 111, 64);
RT_INTERFACE!{interface ISmartCardConnect(ISmartCardConnectVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardConnect] {
    fn ConnectAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardConnection>) -> HRESULT
}}
impl ISmartCardConnect {
    #[inline] pub unsafe fn connect_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardConnection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ConnectAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardConnection, 2128320794, 43034, 18364, 166, 73, 21, 107, 230, 183, 242, 49);
RT_INTERFACE!{interface ISmartCardConnection(ISmartCardConnectionVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardConnection] {
    #[cfg(feature="windows-storage")] fn TransmitAsync(&self, command: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::streams::IBuffer>) -> HRESULT
}}
impl ISmartCardConnection {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn transmit_async(&self, command: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::streams::IBuffer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TransmitAsync)(self as *const _ as *mut _, command as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardConnection: ISmartCardConnection}
RT_ENUM! { enum SmartCardCryptogramAlgorithm: i32 {
    None (SmartCardCryptogramAlgorithm_None) = 0, CbcMac (SmartCardCryptogramAlgorithm_CbcMac) = 1, Cvc3Umd (SmartCardCryptogramAlgorithm_Cvc3Umd) = 2, DecimalizedMsd (SmartCardCryptogramAlgorithm_DecimalizedMsd) = 3, Cvc3MD (SmartCardCryptogramAlgorithm_Cvc3MD) = 4, Sha1 (SmartCardCryptogramAlgorithm_Sha1) = 5, SignedDynamicApplicationData (SmartCardCryptogramAlgorithm_SignedDynamicApplicationData) = 6, RsaPkcs1 (SmartCardCryptogramAlgorithm_RsaPkcs1) = 7, Sha256Hmac (SmartCardCryptogramAlgorithm_Sha256Hmac) = 8,
}}
DEFINE_IID!(IID_ISmartCardCryptogramGenerator, 3818870907, 60883, 20041, 181, 148, 15, 245, 228, 208, 199, 111);
RT_INTERFACE!{interface ISmartCardCryptogramGenerator(ISmartCardCryptogramGeneratorVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGenerator] {
    fn get_SupportedCryptogramMaterialTypes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialType>) -> HRESULT,
    fn get_SupportedCryptogramAlgorithms(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramAlgorithm>) -> HRESULT,
    fn get_SupportedCryptogramMaterialPackageFormats(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageFormat>) -> HRESULT,
    fn get_SupportedCryptogramMaterialPackageConfirmationResponseFormats(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageConfirmationResponseFormat>) -> HRESULT,
    fn get_SupportedSmartCardCryptogramStorageKeyCapabilities(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramStorageKeyCapabilities>) -> HRESULT,
    fn DeleteCryptogramMaterialStorageKeyAsync(&self, storageKeyName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT,
    fn CreateCryptogramMaterialStorageKeyAsync(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, storageKeyName: HSTRING, algorithm: SmartCardCryptogramStorageKeyAlgorithm, capabilities: SmartCardCryptogramStorageKeyCapabilities, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-security")] fn RequestCryptogramMaterialStorageKeyInfoAsync(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, storageKeyName: HSTRING, format: super::super::security::cryptography::core::CryptographicPublicKeyBlobType, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramStorageKeyInfo>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-storage")] fn ImportCryptogramMaterialPackageAsync(&self, format: SmartCardCryptogramMaterialPackageFormat, storageKeyName: HSTRING, materialPackageName: HSTRING, cryptogramMaterialPackage: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-storage")] fn TryProvePossessionOfCryptogramMaterialPackageAsync(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, responseFormat: SmartCardCryptogramMaterialPackageConfirmationResponseFormat, materialPackageName: HSTRING, materialName: HSTRING, challenge: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramMaterialPossessionProof>) -> HRESULT,
    fn RequestUnlockCryptogramMaterialForUseAsync(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT,
    fn DeleteCryptogramMaterialPackageAsync(&self, materialPackageName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT
}}
impl ISmartCardCryptogramGenerator {
    #[inline] pub unsafe fn get_supported_cryptogram_material_types(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedCryptogramMaterialTypes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_cryptogram_algorithms(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramAlgorithm>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedCryptogramAlgorithms)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_cryptogram_material_package_formats(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedCryptogramMaterialPackageFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_cryptogram_material_package_confirmation_response_formats(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageConfirmationResponseFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedCryptogramMaterialPackageConfirmationResponseFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_smart_card_cryptogram_storage_key_capabilities(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramStorageKeyCapabilities>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedSmartCardCryptogramStorageKeyCapabilities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_cryptogram_material_storage_key_async(&self, storageKeyName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteCryptogramMaterialStorageKeyAsync)(self as *const _ as *mut _, storageKeyName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_cryptogram_material_storage_key_async(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, storageKeyName: &HStringArg, algorithm: SmartCardCryptogramStorageKeyAlgorithm, capabilities: SmartCardCryptogramStorageKeyCapabilities) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCryptogramMaterialStorageKeyAsync)(self as *const _ as *mut _, promptingBehavior, storageKeyName.get(), algorithm, capabilities, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn request_cryptogram_material_storage_key_info_async(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, storageKeyName: &HStringArg, format: super::super::security::cryptography::core::CryptographicPublicKeyBlobType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramStorageKeyInfo>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestCryptogramMaterialStorageKeyInfoAsync)(self as *const _ as *mut _, promptingBehavior, storageKeyName.get(), format, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn import_cryptogram_material_package_async(&self, format: SmartCardCryptogramMaterialPackageFormat, storageKeyName: &HStringArg, materialPackageName: &HStringArg, cryptogramMaterialPackage: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ImportCryptogramMaterialPackageAsync)(self as *const _ as *mut _, format, storageKeyName.get(), materialPackageName.get(), cryptogramMaterialPackage as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_prove_possession_of_cryptogram_material_package_async(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, responseFormat: SmartCardCryptogramMaterialPackageConfirmationResponseFormat, materialPackageName: &HStringArg, materialName: &HStringArg, challenge: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramMaterialPossessionProof>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryProvePossessionOfCryptogramMaterialPackageAsync)(self as *const _ as *mut _, promptingBehavior, responseFormat, materialPackageName.get(), materialName.get(), challenge as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_unlock_cryptogram_material_for_use_async(&self, promptingBehavior: SmartCardUnlockPromptingBehavior) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestUnlockCryptogramMaterialForUseAsync)(self as *const _ as *mut _, promptingBehavior, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_cryptogram_material_package_async(&self, materialPackageName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteCryptogramMaterialPackageAsync)(self as *const _ as *mut _, materialPackageName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramGenerator: ISmartCardCryptogramGenerator}
impl RtActivatable<ISmartCardCryptogramGeneratorStatics> for SmartCardCryptogramGenerator {}
impl RtActivatable<ISmartCardCryptogramGeneratorStatics2> for SmartCardCryptogramGenerator {}
impl SmartCardCryptogramGenerator {
    #[inline] pub fn get_smart_card_cryptogram_generator_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGenerator>>> { unsafe {
        <Self as RtActivatable<ISmartCardCryptogramGeneratorStatics>>::get_activation_factory().get_smart_card_cryptogram_generator_async()
    }}
    #[inline] pub fn is_supported() -> Result<bool> { unsafe {
        <Self as RtActivatable<ISmartCardCryptogramGeneratorStatics2>>::get_activation_factory().is_supported()
    }}
}
DEFINE_CLSID!(SmartCardCryptogramGenerator(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,71,101,110,101,114,97,116,111,114,0]) [CLSID_SmartCardCryptogramGenerator]);
DEFINE_IID!(IID_ISmartCardCryptogramGenerator2, 1897310772, 23917, 19274, 150, 163, 239, 164, 125, 42, 126, 37);
RT_INTERFACE!{interface ISmartCardCryptogramGenerator2(ISmartCardCryptogramGenerator2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGenerator2] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn ValidateRequestApduAsync(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, apduToValidate: *mut super::super::storage::streams::IBuffer, cryptogramPlacementSteps: *mut super::super::foundation::collections::IIterable<SmartCardCryptogramPlacementStep>, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT,
    fn GetAllCryptogramStorageKeyCharacteristicsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult>) -> HRESULT,
    fn GetAllCryptogramMaterialPackageCharacteristicsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult>) -> HRESULT,
    fn GetAllCryptogramMaterialPackageCharacteristicsWithStorageKeyAsync(&self, storageKeyName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult>) -> HRESULT,
    fn GetAllCryptogramMaterialCharacteristicsAsync(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, materialPackageName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult>) -> HRESULT
}}
impl ISmartCardCryptogramGenerator2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn validate_request_apdu_async(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, apduToValidate: &super::super::storage::streams::IBuffer, cryptogramPlacementSteps: &super::super::foundation::collections::IIterable<SmartCardCryptogramPlacementStep>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ValidateRequestApduAsync)(self as *const _ as *mut _, promptingBehavior, apduToValidate as *const _ as *mut _, cryptogramPlacementSteps as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_cryptogram_storage_key_characteristics_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllCryptogramStorageKeyCharacteristicsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_cryptogram_material_package_characteristics_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllCryptogramMaterialPackageCharacteristicsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_cryptogram_material_package_characteristics_with_storage_key_async(&self, storageKeyName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllCryptogramMaterialPackageCharacteristicsWithStorageKeyAsync)(self as *const _ as *mut _, storageKeyName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_cryptogram_material_characteristics_async(&self, promptingBehavior: SmartCardUnlockPromptingBehavior, materialPackageName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllCryptogramMaterialCharacteristicsAsync)(self as *const _ as *mut _, promptingBehavior, materialPackageName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmartCardCryptogramGeneratorOperationStatus: i32 {
    Success (SmartCardCryptogramGeneratorOperationStatus_Success) = 0, AuthorizationFailed (SmartCardCryptogramGeneratorOperationStatus_AuthorizationFailed) = 1, AuthorizationCanceled (SmartCardCryptogramGeneratorOperationStatus_AuthorizationCanceled) = 2, AuthorizationRequired (SmartCardCryptogramGeneratorOperationStatus_AuthorizationRequired) = 3, CryptogramMaterialPackageStorageKeyExists (SmartCardCryptogramGeneratorOperationStatus_CryptogramMaterialPackageStorageKeyExists) = 4, NoCryptogramMaterialPackageStorageKey (SmartCardCryptogramGeneratorOperationStatus_NoCryptogramMaterialPackageStorageKey) = 5, NoCryptogramMaterialPackage (SmartCardCryptogramGeneratorOperationStatus_NoCryptogramMaterialPackage) = 6, UnsupportedCryptogramMaterialPackage (SmartCardCryptogramGeneratorOperationStatus_UnsupportedCryptogramMaterialPackage) = 7, UnknownCryptogramMaterialName (SmartCardCryptogramGeneratorOperationStatus_UnknownCryptogramMaterialName) = 8, InvalidCryptogramMaterialUsage (SmartCardCryptogramGeneratorOperationStatus_InvalidCryptogramMaterialUsage) = 9, ApduResponseNotSent (SmartCardCryptogramGeneratorOperationStatus_ApduResponseNotSent) = 10, OtherError (SmartCardCryptogramGeneratorOperationStatus_OtherError) = 11, ValidationFailed (SmartCardCryptogramGeneratorOperationStatus_ValidationFailed) = 12, NotSupported (SmartCardCryptogramGeneratorOperationStatus_NotSupported) = 13,
}}
DEFINE_IID!(IID_ISmartCardCryptogramGeneratorStatics, 160643344, 52124, 16405, 150, 125, 82, 52, 243, 176, 41, 0);
RT_INTERFACE!{static interface ISmartCardCryptogramGeneratorStatics(ISmartCardCryptogramGeneratorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGeneratorStatics] {
    fn GetSmartCardCryptogramGeneratorAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGenerator>) -> HRESULT
}}
impl ISmartCardCryptogramGeneratorStatics {
    #[inline] pub unsafe fn get_smart_card_cryptogram_generator_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGenerator>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSmartCardCryptogramGeneratorAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardCryptogramGeneratorStatics2, 163444197, 46269, 20003, 165, 136, 116, 70, 146, 4, 193, 40);
RT_INTERFACE!{static interface ISmartCardCryptogramGeneratorStatics2(ISmartCardCryptogramGeneratorStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGeneratorStatics2] {
    fn IsSupported(&self, out: *mut bool) -> HRESULT
}}
impl ISmartCardCryptogramGeneratorStatics2 {
    #[inline] pub unsafe fn is_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult, 664330281, 54919, 19602, 134, 198, 57, 158, 154, 14, 203, 9);
RT_INTERFACE!{interface ISmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult(ISmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResultVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult] {
    fn get_OperationStatus(&self, out: *mut SmartCardCryptogramGeneratorOperationStatus) -> HRESULT,
    fn get_Characteristics(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialCharacteristics>) -> HRESULT
}}
impl ISmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult {
    #[inline] pub unsafe fn get_operation_status(&self) -> Result<SmartCardCryptogramGeneratorOperationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OperationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialCharacteristics>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult: ISmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult {}
DEFINE_CLSID!(SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,71,101,116,65,108,108,67,114,121,112,116,111,103,114,97,109,77,97,116,101,114,105,97,108,67,104,97,114,97,99,116,101,114,105,115,116,105,99,115,82,101,115,117,108,116,0]) [CLSID_SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult]);
DEFINE_IID!(IID_ISmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult, 1315605084, 38771, 18116, 163, 47, 177, 229, 67, 21, 158, 4);
RT_INTERFACE!{interface ISmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult(ISmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResultVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult] {
    fn get_OperationStatus(&self, out: *mut SmartCardCryptogramGeneratorOperationStatus) -> HRESULT,
    fn get_Characteristics(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageCharacteristics>) -> HRESULT
}}
impl ISmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult {
    #[inline] pub unsafe fn get_operation_status(&self) -> Result<SmartCardCryptogramGeneratorOperationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OperationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageCharacteristics>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult: ISmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult {}
DEFINE_CLSID!(SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,71,101,116,65,108,108,67,114,121,112,116,111,103,114,97,109,77,97,116,101,114,105,97,108,80,97,99,107,97,103,101,67,104,97,114,97,99,116,101,114,105,115,116,105,99,115,82,101,115,117,108,116,0]) [CLSID_SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult]);
DEFINE_IID!(IID_ISmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult, 2356996183, 42983, 18589, 185, 214, 54, 128, 97, 81, 80, 18);
RT_INTERFACE!{interface ISmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult(ISmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResultVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult] {
    fn get_OperationStatus(&self, out: *mut SmartCardCryptogramGeneratorOperationStatus) -> HRESULT,
    fn get_Characteristics(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramStorageKeyCharacteristics>) -> HRESULT
}}
impl ISmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult {
    #[inline] pub unsafe fn get_operation_status(&self) -> Result<SmartCardCryptogramGeneratorOperationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OperationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramStorageKeyCharacteristics>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult: ISmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult {}
DEFINE_CLSID!(SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,71,101,116,65,108,108,67,114,121,112,116,111,103,114,97,109,83,116,111,114,97,103,101,75,101,121,67,104,97,114,97,99,116,101,114,105,115,116,105,99,115,82,101,115,117,108,116,0]) [CLSID_SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult]);
DEFINE_IID!(IID_ISmartCardCryptogramMaterialCharacteristics, 4238001612, 49623, 16723, 146, 59, 162, 212, 60, 108, 141, 73);
RT_INTERFACE!{interface ISmartCardCryptogramMaterialCharacteristics(ISmartCardCryptogramMaterialCharacteristicsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramMaterialCharacteristics] {
    fn get_MaterialName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AllowedAlgorithms(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramAlgorithm>) -> HRESULT,
    fn get_AllowedProofOfPossessionAlgorithms(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageConfirmationResponseFormat>) -> HRESULT,
    fn get_AllowedValidations(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmartCardCryptogramAlgorithm>) -> HRESULT,
    fn get_MaterialType(&self, out: *mut SmartCardCryptogramMaterialType) -> HRESULT,
    fn get_ProtectionMethod(&self, out: *mut SmartCardCryptogramMaterialProtectionMethod) -> HRESULT,
    fn get_ProtectionVersion(&self, out: *mut i32) -> HRESULT,
    fn get_MaterialLength(&self, out: *mut i32) -> HRESULT
}}
impl ISmartCardCryptogramMaterialCharacteristics {
    #[inline] pub unsafe fn get_material_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaterialName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allowed_algorithms(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramAlgorithm>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowedAlgorithms)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allowed_proof_of_possession_algorithms(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramMaterialPackageConfirmationResponseFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowedProofOfPossessionAlgorithms)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allowed_validations(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmartCardCryptogramAlgorithm>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowedValidations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_material_type(&self) -> Result<SmartCardCryptogramMaterialType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaterialType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protection_method(&self) -> Result<SmartCardCryptogramMaterialProtectionMethod> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionMethod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protection_version(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_material_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaterialLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramMaterialCharacteristics: ISmartCardCryptogramMaterialCharacteristics}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramMaterialCharacteristics {}
DEFINE_CLSID!(SmartCardCryptogramMaterialCharacteristics(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,77,97,116,101,114,105,97,108,67,104,97,114,97,99,116,101,114,105,115,116,105,99,115,0]) [CLSID_SmartCardCryptogramMaterialCharacteristics]);
DEFINE_IID!(IID_ISmartCardCryptogramMaterialPackageCharacteristics, 4290088479, 1682, 19527, 147, 207, 52, 217, 31, 157, 205, 0);
RT_INTERFACE!{interface ISmartCardCryptogramMaterialPackageCharacteristics(ISmartCardCryptogramMaterialPackageCharacteristicsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramMaterialPackageCharacteristics] {
    fn get_PackageName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_StorageKeyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DateImported(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_PackageFormat(&self, out: *mut SmartCardCryptogramMaterialPackageFormat) -> HRESULT
}}
impl ISmartCardCryptogramMaterialPackageCharacteristics {
    #[inline] pub unsafe fn get_package_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PackageName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_storage_key_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StorageKeyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_imported(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DateImported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_package_format(&self) -> Result<SmartCardCryptogramMaterialPackageFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PackageFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramMaterialPackageCharacteristics: ISmartCardCryptogramMaterialPackageCharacteristics}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramMaterialPackageCharacteristics {}
DEFINE_CLSID!(SmartCardCryptogramMaterialPackageCharacteristics(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,77,97,116,101,114,105,97,108,80,97,99,107,97,103,101,67,104,97,114,97,99,116,101,114,105,115,116,105,99,115,0]) [CLSID_SmartCardCryptogramMaterialPackageCharacteristics]);
RT_ENUM! { enum SmartCardCryptogramMaterialPackageConfirmationResponseFormat: i32 {
    None (SmartCardCryptogramMaterialPackageConfirmationResponseFormat_None) = 0, VisaHmac (SmartCardCryptogramMaterialPackageConfirmationResponseFormat_VisaHmac) = 1,
}}
RT_ENUM! { enum SmartCardCryptogramMaterialPackageFormat: i32 {
    None (SmartCardCryptogramMaterialPackageFormat_None) = 0, JweRsaPki (SmartCardCryptogramMaterialPackageFormat_JweRsaPki) = 1,
}}
DEFINE_IID!(IID_ISmartCardCryptogramMaterialPossessionProof, 3854150540, 41281, 16693, 154, 221, 176, 210, 227, 170, 31, 201);
RT_INTERFACE!{interface ISmartCardCryptogramMaterialPossessionProof(ISmartCardCryptogramMaterialPossessionProofVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramMaterialPossessionProof] {
    fn get_OperationStatus(&self, out: *mut SmartCardCryptogramGeneratorOperationStatus) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Proof(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl ISmartCardCryptogramMaterialPossessionProof {
    #[inline] pub unsafe fn get_operation_status(&self) -> Result<SmartCardCryptogramGeneratorOperationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OperationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_proof(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Proof)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramMaterialPossessionProof: ISmartCardCryptogramMaterialPossessionProof}
RT_ENUM! { enum SmartCardCryptogramMaterialProtectionMethod: i32 {
    None (SmartCardCryptogramMaterialProtectionMethod_None) = 0, WhiteBoxing (SmartCardCryptogramMaterialProtectionMethod_WhiteBoxing) = 1,
}}
RT_ENUM! { enum SmartCardCryptogramMaterialType: i32 {
    None (SmartCardCryptogramMaterialType_None) = 0, StaticDataAuthentication (SmartCardCryptogramMaterialType_StaticDataAuthentication) = 1, TripleDes112 (SmartCardCryptogramMaterialType_TripleDes112) = 2, Aes (SmartCardCryptogramMaterialType_Aes) = 3, RsaPkcs1 (SmartCardCryptogramMaterialType_RsaPkcs1) = 4,
}}
RT_ENUM! { enum SmartCardCryptogramPlacementOptions: u32 {
    None (SmartCardCryptogramPlacementOptions_None) = 0, UnitsAreInNibbles (SmartCardCryptogramPlacementOptions_UnitsAreInNibbles) = 1, ChainOutput (SmartCardCryptogramPlacementOptions_ChainOutput) = 2,
}}
DEFINE_IID!(IID_ISmartCardCryptogramPlacementStep, 2491089899, 33602, 18322, 162, 229, 146, 86, 54, 55, 138, 83);
RT_INTERFACE!{interface ISmartCardCryptogramPlacementStep(ISmartCardCryptogramPlacementStepVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramPlacementStep] {
    fn get_Algorithm(&self, out: *mut SmartCardCryptogramAlgorithm) -> HRESULT,
    fn put_Algorithm(&self, value: SmartCardCryptogramAlgorithm) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SourceData(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_SourceData(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_CryptogramMaterialPackageName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CryptogramMaterialPackageName(&self, value: HSTRING) -> HRESULT,
    fn get_CryptogramMaterialName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CryptogramMaterialName(&self, value: HSTRING) -> HRESULT,
    fn get_TemplateOffset(&self, out: *mut i32) -> HRESULT,
    fn put_TemplateOffset(&self, value: i32) -> HRESULT,
    fn get_CryptogramOffset(&self, out: *mut i32) -> HRESULT,
    fn put_CryptogramOffset(&self, value: i32) -> HRESULT,
    fn get_CryptogramLength(&self, out: *mut i32) -> HRESULT,
    fn put_CryptogramLength(&self, value: i32) -> HRESULT,
    fn get_CryptogramPlacementOptions(&self, out: *mut SmartCardCryptogramPlacementOptions) -> HRESULT,
    fn put_CryptogramPlacementOptions(&self, value: SmartCardCryptogramPlacementOptions) -> HRESULT,
    fn get_ChainedOutputStep(&self, out: *mut *mut SmartCardCryptogramPlacementStep) -> HRESULT,
    fn put_ChainedOutputStep(&self, value: *mut SmartCardCryptogramPlacementStep) -> HRESULT
}}
impl ISmartCardCryptogramPlacementStep {
    #[inline] pub unsafe fn get_algorithm(&self) -> Result<SmartCardCryptogramAlgorithm> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Algorithm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_algorithm(&self, value: SmartCardCryptogramAlgorithm) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Algorithm)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_source_data(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_source_data(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SourceData)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cryptogram_material_package_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CryptogramMaterialPackageName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cryptogram_material_package_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CryptogramMaterialPackageName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cryptogram_material_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CryptogramMaterialName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cryptogram_material_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CryptogramMaterialName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template_offset(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TemplateOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_template_offset(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TemplateOffset)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cryptogram_offset(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CryptogramOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cryptogram_offset(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CryptogramOffset)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cryptogram_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CryptogramLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cryptogram_length(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CryptogramLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cryptogram_placement_options(&self) -> Result<SmartCardCryptogramPlacementOptions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CryptogramPlacementOptions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cryptogram_placement_options(&self, value: SmartCardCryptogramPlacementOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CryptogramPlacementOptions)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_chained_output_step(&self) -> Result<ComPtr<SmartCardCryptogramPlacementStep>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChainedOutputStep)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_chained_output_step(&self, value: &SmartCardCryptogramPlacementStep) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChainedOutputStep)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramPlacementStep: ISmartCardCryptogramPlacementStep}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramPlacementStep {}
DEFINE_CLSID!(SmartCardCryptogramPlacementStep(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,80,108,97,99,101,109,101,110,116,83,116,101,112,0]) [CLSID_SmartCardCryptogramPlacementStep]);
RT_ENUM! { enum SmartCardCryptogramStorageKeyAlgorithm: i32 {
    None (SmartCardCryptogramStorageKeyAlgorithm_None) = 0, Rsa2048 (SmartCardCryptogramStorageKeyAlgorithm_Rsa2048) = 1,
}}
RT_ENUM! { enum SmartCardCryptogramStorageKeyCapabilities: u32 {
    None (SmartCardCryptogramStorageKeyCapabilities_None) = 0, HardwareProtection (SmartCardCryptogramStorageKeyCapabilities_HardwareProtection) = 1, UnlockPrompt (SmartCardCryptogramStorageKeyCapabilities_UnlockPrompt) = 2,
}}
DEFINE_IID!(IID_ISmartCardCryptogramStorageKeyCharacteristics, 2236765294, 17495, 18469, 180, 100, 99, 84, 113, 163, 159, 92);
RT_INTERFACE!{interface ISmartCardCryptogramStorageKeyCharacteristics(ISmartCardCryptogramStorageKeyCharacteristicsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramStorageKeyCharacteristics] {
    fn get_StorageKeyName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DateCreated(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_Algorithm(&self, out: *mut SmartCardCryptogramStorageKeyAlgorithm) -> HRESULT,
    fn get_Capabilities(&self, out: *mut SmartCardCryptogramStorageKeyCapabilities) -> HRESULT
}}
impl ISmartCardCryptogramStorageKeyCharacteristics {
    #[inline] pub unsafe fn get_storage_key_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StorageKeyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_created(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DateCreated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_algorithm(&self) -> Result<SmartCardCryptogramStorageKeyAlgorithm> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Algorithm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_capabilities(&self) -> Result<SmartCardCryptogramStorageKeyCapabilities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Capabilities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramStorageKeyCharacteristics: ISmartCardCryptogramStorageKeyCharacteristics}
impl RtActivatable<IActivationFactory> for SmartCardCryptogramStorageKeyCharacteristics {}
DEFINE_CLSID!(SmartCardCryptogramStorageKeyCharacteristics(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,67,114,121,112,116,111,103,114,97,109,83,116,111,114,97,103,101,75,101,121,67,104,97,114,97,99,116,101,114,105,115,116,105,99,115,0]) [CLSID_SmartCardCryptogramStorageKeyCharacteristics]);
DEFINE_IID!(IID_ISmartCardCryptogramStorageKeyInfo, 2008084493, 45207, 20321, 162, 106, 149, 97, 99, 156, 156, 58);
RT_INTERFACE!{interface ISmartCardCryptogramStorageKeyInfo(ISmartCardCryptogramStorageKeyInfoVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramStorageKeyInfo] {
    fn get_OperationStatus(&self, out: *mut SmartCardCryptogramGeneratorOperationStatus) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-security")] fn get_PublicKeyBlobType(&self, out: *mut super::super::security::cryptography::core::CryptographicPublicKeyBlobType) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_PublicKey(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_AttestationStatus(&self, out: *mut SmartCardCryptographicKeyAttestationStatus) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Attestation(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_AttestationCertificateChain(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_Capabilities(&self, out: *mut SmartCardCryptogramStorageKeyCapabilities) -> HRESULT
}}
impl ISmartCardCryptogramStorageKeyInfo {
    #[inline] pub unsafe fn get_operation_status(&self) -> Result<SmartCardCryptogramGeneratorOperationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OperationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_public_key_blob_type(&self) -> Result<super::super::security::cryptography::core::CryptographicPublicKeyBlobType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PublicKeyBlobType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_public_key(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PublicKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_attestation_status(&self) -> Result<SmartCardCryptographicKeyAttestationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttestationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_attestation(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Attestation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_attestation_certificate_chain(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AttestationCertificateChain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_capabilities(&self) -> Result<SmartCardCryptogramStorageKeyCapabilities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Capabilities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardCryptogramStorageKeyInfo: ISmartCardCryptogramStorageKeyInfo}
DEFINE_IID!(IID_ISmartCardCryptogramStorageKeyInfo2, 278777, 63485, 16765, 137, 225, 251, 176, 56, 42, 220, 77);
RT_INTERFACE!{interface ISmartCardCryptogramStorageKeyInfo2(ISmartCardCryptogramStorageKeyInfo2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardCryptogramStorageKeyInfo2] {
    fn get_OperationalRequirements(&self, out: *mut HSTRING) -> HRESULT
}}
impl ISmartCardCryptogramStorageKeyInfo2 {
    #[inline] pub unsafe fn get_operational_requirements(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OperationalRequirements)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmartCardCryptographicKeyAttestationStatus: i32 {
    NoAttestation (SmartCardCryptographicKeyAttestationStatus_NoAttestation) = 0, SoftwareKeyWithoutTpm (SmartCardCryptographicKeyAttestationStatus_SoftwareKeyWithoutTpm) = 1, SoftwareKeyWithTpm (SmartCardCryptographicKeyAttestationStatus_SoftwareKeyWithTpm) = 2, TpmKeyUnknownAttestationStatus (SmartCardCryptographicKeyAttestationStatus_TpmKeyUnknownAttestationStatus) = 3, TpmKeyWithoutAttestationCapability (SmartCardCryptographicKeyAttestationStatus_TpmKeyWithoutAttestationCapability) = 4, TpmKeyWithTemporaryAttestationFailure (SmartCardCryptographicKeyAttestationStatus_TpmKeyWithTemporaryAttestationFailure) = 5, TpmKeyWithLongTermAttestationFailure (SmartCardCryptographicKeyAttestationStatus_TpmKeyWithLongTermAttestationFailure) = 6, TpmKeyWithAttestation (SmartCardCryptographicKeyAttestationStatus_TpmKeyWithAttestation) = 7,
}}
RT_ENUM! { enum SmartCardEmulationCategory: i32 {
    Other (SmartCardEmulationCategory_Other) = 0, Payment (SmartCardEmulationCategory_Payment) = 1,
}}
RT_ENUM! { enum SmartCardEmulationType: i32 {
    Host (SmartCardEmulationType_Host) = 0, Uicc (SmartCardEmulationType_Uicc) = 1, EmbeddedSE (SmartCardEmulationType_EmbeddedSE) = 2,
}}
DEFINE_IID!(IID_ISmartCardEmulator, 3753445042, 34654, 18405, 128, 119, 232, 191, 241, 177, 198, 251);
RT_INTERFACE!{interface ISmartCardEmulator(ISmartCardEmulatorVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulator] {
    fn get_EnablementPolicy(&self, out: *mut SmartCardEmulatorEnablementPolicy) -> HRESULT
}}
impl ISmartCardEmulator {
    #[inline] pub unsafe fn get_enablement_policy(&self) -> Result<SmartCardEmulatorEnablementPolicy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EnablementPolicy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardEmulator: ISmartCardEmulator}
impl RtActivatable<ISmartCardEmulatorStatics> for SmartCardEmulator {}
impl RtActivatable<ISmartCardEmulatorStatics2> for SmartCardEmulator {}
impl RtActivatable<ISmartCardEmulatorStatics3> for SmartCardEmulator {}
impl SmartCardEmulator {
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardEmulator>>> { unsafe {
        <Self as RtActivatable<ISmartCardEmulatorStatics>>::get_activation_factory().get_default_async()
    }}
    #[inline] pub fn get_applet_id_group_registrations_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SmartCardAppletIdGroupRegistration>>>> { unsafe {
        <Self as RtActivatable<ISmartCardEmulatorStatics2>>::get_activation_factory().get_applet_id_group_registrations_async()
    }}
    #[inline] pub fn register_applet_id_group_async(appletIdGroup: &SmartCardAppletIdGroup) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardAppletIdGroupRegistration>>> { unsafe {
        <Self as RtActivatable<ISmartCardEmulatorStatics2>>::get_activation_factory().register_applet_id_group_async(appletIdGroup)
    }}
    #[inline] pub fn unregister_applet_id_group_async(registration: &SmartCardAppletIdGroupRegistration) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<ISmartCardEmulatorStatics2>>::get_activation_factory().unregister_applet_id_group_async(registration)
    }}
    #[inline] pub fn get_max_applet_id_group_registrations() -> Result<u16> { unsafe {
        <Self as RtActivatable<ISmartCardEmulatorStatics2>>::get_activation_factory().get_max_applet_id_group_registrations()
    }}
    #[inline] pub fn is_supported() -> Result<bool> { unsafe {
        <Self as RtActivatable<ISmartCardEmulatorStatics3>>::get_activation_factory().is_supported()
    }}
}
DEFINE_CLSID!(SmartCardEmulator(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,69,109,117,108,97,116,111,114,0]) [CLSID_SmartCardEmulator]);
DEFINE_IID!(IID_ISmartCardEmulator2, 4265590968, 34089, 16666, 128, 123, 72, 237, 194, 160, 171, 68);
RT_INTERFACE!{interface ISmartCardEmulator2(ISmartCardEmulator2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulator2] {
    fn add_ApduReceived(&self, value: *mut super::super::foundation::TypedEventHandler<SmartCardEmulator, SmartCardEmulatorApduReceivedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ApduReceived(&self, value: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ConnectionDeactivated(&self, value: *mut super::super::foundation::TypedEventHandler<SmartCardEmulator, SmartCardEmulatorConnectionDeactivatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ConnectionDeactivated(&self, value: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn IsHostCardEmulationSupported(&self, out: *mut bool) -> HRESULT
}}
impl ISmartCardEmulator2 {
    #[inline] pub unsafe fn add_apdu_received(&self, value: &super::super::foundation::TypedEventHandler<SmartCardEmulator, SmartCardEmulatorApduReceivedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ApduReceived)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_apdu_received(&self, value: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ApduReceived)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_connection_deactivated(&self, value: &super::super::foundation::TypedEventHandler<SmartCardEmulator, SmartCardEmulatorConnectionDeactivatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ConnectionDeactivated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_connection_deactivated(&self, value: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ConnectionDeactivated)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_host_card_emulation_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsHostCardEmulationSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardEmulatorApduReceivedEventArgs, 3579647350, 27090, 21299, 91, 95, 248, 192, 214, 233, 240, 159);
RT_INTERFACE!{interface ISmartCardEmulatorApduReceivedEventArgs(ISmartCardEmulatorApduReceivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorApduReceivedEventArgs] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_CommandApdu(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_ConnectionProperties(&self, out: *mut *mut SmartCardEmulatorConnectionProperties) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn TryRespondAsync(&self, responseApdu: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn get_AutomaticResponseStatus(&self, out: *mut SmartCardAutomaticResponseStatus) -> HRESULT
}}
impl ISmartCardEmulatorApduReceivedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_command_apdu(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommandApdu)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_properties(&self) -> Result<ComPtr<SmartCardEmulatorConnectionProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_respond_async(&self, responseApdu: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryRespondAsync)(self as *const _ as *mut _, responseApdu as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_automatic_response_status(&self) -> Result<SmartCardAutomaticResponseStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutomaticResponseStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardEmulatorApduReceivedEventArgs: ISmartCardEmulatorApduReceivedEventArgs}
DEFINE_IID!(IID_ISmartCardEmulatorApduReceivedEventArgs2, 2348367344, 8929, 16952, 134, 16, 148, 206, 74, 150, 84, 37);
RT_INTERFACE!{interface ISmartCardEmulatorApduReceivedEventArgs2(ISmartCardEmulatorApduReceivedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorApduReceivedEventArgs2] {
    fn get_State(&self, out: *mut u32) -> HRESULT,
    #[cfg(feature="windows-storage")] fn TryRespondWithStateAsync(&self, responseApdu: *mut super::super::storage::streams::IBuffer, nextState: *mut super::super::foundation::IReference<u32>, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ISmartCardEmulatorApduReceivedEventArgs2 {
    #[inline] pub unsafe fn get_state(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_respond_with_state_async(&self, responseApdu: &super::super::storage::streams::IBuffer, nextState: &super::super::foundation::IReference<u32>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryRespondWithStateAsync)(self as *const _ as *mut _, responseApdu as *const _ as *mut _, nextState as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardEmulatorApduReceivedEventArgsWithCryptograms, 3578837703, 47039, 20009, 146, 148, 12, 74, 195, 201, 65, 189);
RT_INTERFACE!{interface ISmartCardEmulatorApduReceivedEventArgsWithCryptograms(ISmartCardEmulatorApduReceivedEventArgsWithCryptogramsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorApduReceivedEventArgsWithCryptograms] {
    #[cfg(feature="windows-storage")] fn TryRespondWithCryptogramsAsync(&self, responseTemplate: *mut super::super::storage::streams::IBuffer, cryptogramPlacementSteps: *mut super::super::foundation::collections::IIterable<SmartCardCryptogramPlacementStep>, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn TryRespondWithCryptogramsAndStateAsync(&self, responseTemplate: *mut super::super::storage::streams::IBuffer, cryptogramPlacementSteps: *mut super::super::foundation::collections::IIterable<SmartCardCryptogramPlacementStep>, nextState: *mut super::super::foundation::IReference<u32>, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>) -> HRESULT
}}
impl ISmartCardEmulatorApduReceivedEventArgsWithCryptograms {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_respond_with_cryptograms_async(&self, responseTemplate: &super::super::storage::streams::IBuffer, cryptogramPlacementSteps: &super::super::foundation::collections::IIterable<SmartCardCryptogramPlacementStep>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryRespondWithCryptogramsAsync)(self as *const _ as *mut _, responseTemplate as *const _ as *mut _, cryptogramPlacementSteps as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_respond_with_cryptograms_and_state_async(&self, responseTemplate: &super::super::storage::streams::IBuffer, cryptogramPlacementSteps: &super::super::foundation::collections::IIterable<SmartCardCryptogramPlacementStep>, nextState: &super::super::foundation::IReference<u32>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardCryptogramGeneratorOperationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryRespondWithCryptogramsAndStateAsync)(self as *const _ as *mut _, responseTemplate as *const _ as *mut _, cryptogramPlacementSteps as *const _ as *mut _, nextState as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardEmulatorConnectionDeactivatedEventArgs, 562485459, 50667, 21090, 67, 223, 98, 160, 161, 181, 85, 87);
RT_INTERFACE!{interface ISmartCardEmulatorConnectionDeactivatedEventArgs(ISmartCardEmulatorConnectionDeactivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorConnectionDeactivatedEventArgs] {
    fn get_ConnectionProperties(&self, out: *mut *mut SmartCardEmulatorConnectionProperties) -> HRESULT,
    fn get_Reason(&self, out: *mut SmartCardEmulatorConnectionDeactivatedReason) -> HRESULT
}}
impl ISmartCardEmulatorConnectionDeactivatedEventArgs {
    #[inline] pub unsafe fn get_connection_properties(&self) -> Result<ComPtr<SmartCardEmulatorConnectionProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reason(&self) -> Result<SmartCardEmulatorConnectionDeactivatedReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Reason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardEmulatorConnectionDeactivatedEventArgs: ISmartCardEmulatorConnectionDeactivatedEventArgs}
RT_ENUM! { enum SmartCardEmulatorConnectionDeactivatedReason: i32 {
    ConnectionLost (SmartCardEmulatorConnectionDeactivatedReason_ConnectionLost) = 0, ConnectionRedirected (SmartCardEmulatorConnectionDeactivatedReason_ConnectionRedirected) = 1,
}}
DEFINE_IID!(IID_ISmartCardEmulatorConnectionProperties, 1311548910, 63849, 20605, 108, 249, 52, 226, 209, 141, 243, 17);
RT_INTERFACE!{interface ISmartCardEmulatorConnectionProperties(ISmartCardEmulatorConnectionPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorConnectionProperties] {
    fn get_Id(&self, out: *mut Guid) -> HRESULT,
    fn get_Source(&self, out: *mut SmartCardEmulatorConnectionSource) -> HRESULT
}}
impl ISmartCardEmulatorConnectionProperties {
    #[inline] pub unsafe fn get_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source(&self) -> Result<SmartCardEmulatorConnectionSource> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardEmulatorConnectionProperties: ISmartCardEmulatorConnectionProperties}
RT_ENUM! { enum SmartCardEmulatorConnectionSource: i32 {
    Unknown (SmartCardEmulatorConnectionSource_Unknown) = 0, NfcReader (SmartCardEmulatorConnectionSource_NfcReader) = 1,
}}
RT_ENUM! { enum SmartCardEmulatorEnablementPolicy: i32 {
    Never (SmartCardEmulatorEnablementPolicy_Never) = 0, Always (SmartCardEmulatorEnablementPolicy_Always) = 1, ScreenOn (SmartCardEmulatorEnablementPolicy_ScreenOn) = 2, ScreenUnlocked (SmartCardEmulatorEnablementPolicy_ScreenUnlocked) = 3,
}}
DEFINE_IID!(IID_ISmartCardEmulatorStatics, 2057043019, 50387, 18767, 184, 162, 98, 21, 216, 30, 133, 178);
RT_INTERFACE!{static interface ISmartCardEmulatorStatics(ISmartCardEmulatorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorStatics] {
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardEmulator>) -> HRESULT
}}
impl ISmartCardEmulatorStatics {
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardEmulator>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardEmulatorStatics2, 1773051786, 46965, 18571, 132, 54, 108, 30, 40, 237, 115, 31);
RT_INTERFACE!{static interface ISmartCardEmulatorStatics2(ISmartCardEmulatorStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorStatics2] {
    fn GetAppletIdGroupRegistrationsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SmartCardAppletIdGroupRegistration>>) -> HRESULT,
    fn RegisterAppletIdGroupAsync(&self, appletIdGroup: *mut SmartCardAppletIdGroup, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardAppletIdGroupRegistration>) -> HRESULT,
    fn UnregisterAppletIdGroupAsync(&self, registration: *mut SmartCardAppletIdGroupRegistration, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_MaxAppletIdGroupRegistrations(&self, out: *mut u16) -> HRESULT
}}
impl ISmartCardEmulatorStatics2 {
    #[inline] pub unsafe fn get_applet_id_group_registrations_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SmartCardAppletIdGroupRegistration>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAppletIdGroupRegistrationsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_applet_id_group_async(&self, appletIdGroup: &SmartCardAppletIdGroup) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardAppletIdGroupRegistration>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RegisterAppletIdGroupAsync)(self as *const _ as *mut _, appletIdGroup as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn unregister_applet_id_group_async(&self, registration: &SmartCardAppletIdGroupRegistration) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UnregisterAppletIdGroupAsync)(self as *const _ as *mut _, registration as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_applet_id_group_registrations(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxAppletIdGroupRegistrations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardEmulatorStatics3, 1508512810, 40713, 17397, 133, 101, 207, 168, 20, 142, 76, 178);
RT_INTERFACE!{static interface ISmartCardEmulatorStatics3(ISmartCardEmulatorStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardEmulatorStatics3] {
    fn IsSupported(&self, out: *mut bool) -> HRESULT
}}
impl ISmartCardEmulatorStatics3 {
    #[inline] pub unsafe fn is_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum SmartCardLaunchBehavior: i32 {
    Default (SmartCardLaunchBehavior_Default) = 0, AboveLock (SmartCardLaunchBehavior_AboveLock) = 1,
}}
RT_ENUM! { enum SmartCardPinCharacterPolicyOption: i32 {
    Allow (SmartCardPinCharacterPolicyOption_Allow) = 0, RequireAtLeastOne (SmartCardPinCharacterPolicyOption_RequireAtLeastOne) = 1, Disallow (SmartCardPinCharacterPolicyOption_Disallow) = 2,
}}
DEFINE_IID!(IID_ISmartCardPinPolicy, 406643076, 19894, 18497, 172, 158, 42, 193, 243, 155, 115, 4);
RT_INTERFACE!{interface ISmartCardPinPolicy(ISmartCardPinPolicyVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardPinPolicy] {
    fn get_MinLength(&self, out: *mut u32) -> HRESULT,
    fn put_MinLength(&self, value: u32) -> HRESULT,
    fn get_MaxLength(&self, out: *mut u32) -> HRESULT,
    fn put_MaxLength(&self, value: u32) -> HRESULT,
    fn get_UppercaseLetters(&self, out: *mut SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn put_UppercaseLetters(&self, value: SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn get_LowercaseLetters(&self, out: *mut SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn put_LowercaseLetters(&self, value: SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn get_Digits(&self, out: *mut SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn put_Digits(&self, value: SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn get_SpecialCharacters(&self, out: *mut SmartCardPinCharacterPolicyOption) -> HRESULT,
    fn put_SpecialCharacters(&self, value: SmartCardPinCharacterPolicyOption) -> HRESULT
}}
impl ISmartCardPinPolicy {
    #[inline] pub unsafe fn get_min_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_length(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_length(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uppercase_letters(&self) -> Result<SmartCardPinCharacterPolicyOption> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UppercaseLetters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_uppercase_letters(&self, value: SmartCardPinCharacterPolicyOption) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UppercaseLetters)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lowercase_letters(&self) -> Result<SmartCardPinCharacterPolicyOption> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LowercaseLetters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_lowercase_letters(&self, value: SmartCardPinCharacterPolicyOption) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LowercaseLetters)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_digits(&self) -> Result<SmartCardPinCharacterPolicyOption> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Digits)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_digits(&self, value: SmartCardPinCharacterPolicyOption) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Digits)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_special_characters(&self) -> Result<SmartCardPinCharacterPolicyOption> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpecialCharacters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_special_characters(&self, value: SmartCardPinCharacterPolicyOption) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SpecialCharacters)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardPinPolicy: ISmartCardPinPolicy}
impl RtActivatable<IActivationFactory> for SmartCardPinPolicy {}
DEFINE_CLSID!(SmartCardPinPolicy(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,80,105,110,80,111,108,105,99,121,0]) [CLSID_SmartCardPinPolicy]);
DEFINE_IID!(IID_ISmartCardPinResetDeferral, 415845036, 30725, 16388, 133, 228, 187, 239, 172, 143, 104, 132);
RT_INTERFACE!{interface ISmartCardPinResetDeferral(ISmartCardPinResetDeferralVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardPinResetDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl ISmartCardPinResetDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardPinResetDeferral: ISmartCardPinResetDeferral}
DEFINE_IID!(IID_SmartCardPinResetHandler, 328031808, 62396, 19036, 180, 29, 75, 78, 246, 132, 226, 55);
RT_DELEGATE!{delegate SmartCardPinResetHandler(SmartCardPinResetHandlerVtbl, SmartCardPinResetHandlerImpl) [IID_SmartCardPinResetHandler] {
    fn Invoke(&self, sender: *mut SmartCardProvisioning, request: *mut SmartCardPinResetRequest) -> HRESULT
}}
impl SmartCardPinResetHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &SmartCardProvisioning, request: &SmartCardPinResetRequest) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, request as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardPinResetRequest, 318651469, 24505, 20110, 159, 246, 97, 244, 117, 18, 79, 239);
RT_INTERFACE!{interface ISmartCardPinResetRequest(ISmartCardPinResetRequestVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardPinResetRequest] {
    #[cfg(feature="windows-storage")] fn get_Challenge(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_Deadline(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut SmartCardPinResetDeferral) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SetResponse(&self, response: *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl ISmartCardPinResetRequest {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_challenge(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Challenge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deadline(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Deadline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<SmartCardPinResetDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_response(&self, response: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).SetResponse)(self as *const _ as *mut _, response as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardPinResetRequest: ISmartCardPinResetRequest}
DEFINE_IID!(IID_ISmartCardProvisioning, 435088829, 8107, 18300, 183, 18, 26, 44, 90, 241, 253, 110);
RT_INTERFACE!{interface ISmartCardProvisioning(ISmartCardProvisioningVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardProvisioning] {
    fn get_SmartCard(&self, out: *mut *mut SmartCard) -> HRESULT,
    fn GetIdAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<Guid>) -> HRESULT,
    fn GetNameAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn GetChallengeContextAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardChallengeContext>) -> HRESULT,
    fn RequestPinChangeAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestPinResetAsync(&self, handler: *mut SmartCardPinResetHandler, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ISmartCardProvisioning {
    #[inline] pub unsafe fn get_smart_card(&self) -> Result<ComPtr<SmartCard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmartCard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Guid>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIdAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetNameAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_challenge_context_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardChallengeContext>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChallengeContextAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_pin_change_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestPinChangeAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_pin_reset_async(&self, handler: &SmartCardPinResetHandler) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestPinResetAsync)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardProvisioning: ISmartCardProvisioning}
impl RtActivatable<ISmartCardProvisioningStatics> for SmartCardProvisioning {}
impl RtActivatable<ISmartCardProvisioningStatics2> for SmartCardProvisioning {}
impl SmartCardProvisioning {
    #[inline] pub fn from_smart_card_async(card: &SmartCard) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> { unsafe {
        <Self as RtActivatable<ISmartCardProvisioningStatics>>::get_activation_factory().from_smart_card_async(card)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn request_virtual_smart_card_creation_async(friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> { unsafe {
        <Self as RtActivatable<ISmartCardProvisioningStatics>>::get_activation_factory().request_virtual_smart_card_creation_async(friendlyName, administrativeKey, pinPolicy)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn request_virtual_smart_card_creation_async_with_card_id(friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy, cardId: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> { unsafe {
        <Self as RtActivatable<ISmartCardProvisioningStatics>>::get_activation_factory().request_virtual_smart_card_creation_async_with_card_id(friendlyName, administrativeKey, pinPolicy, cardId)
    }}
    #[inline] pub fn request_virtual_smart_card_deletion_async(card: &SmartCard) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<ISmartCardProvisioningStatics>>::get_activation_factory().request_virtual_smart_card_deletion_async(card)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn request_attested_virtual_smart_card_creation_async(friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> { unsafe {
        <Self as RtActivatable<ISmartCardProvisioningStatics2>>::get_activation_factory().request_attested_virtual_smart_card_creation_async(friendlyName, administrativeKey, pinPolicy)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn request_attested_virtual_smart_card_creation_async_with_card_id(friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy, cardId: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> { unsafe {
        <Self as RtActivatable<ISmartCardProvisioningStatics2>>::get_activation_factory().request_attested_virtual_smart_card_creation_async_with_card_id(friendlyName, administrativeKey, pinPolicy, cardId)
    }}
}
DEFINE_CLSID!(SmartCardProvisioning(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,80,114,111,118,105,115,105,111,110,105,110,103,0]) [CLSID_SmartCardProvisioning]);
DEFINE_IID!(IID_ISmartCardProvisioning2, 285026539, 16249, 19302, 155, 124, 17, 193, 73, 183, 208, 188);
RT_INTERFACE!{interface ISmartCardProvisioning2(ISmartCardProvisioning2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardProvisioning2] {
    fn GetAuthorityKeyContainerNameAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT
}}
impl ISmartCardProvisioning2 {
    #[inline] pub unsafe fn get_authority_key_container_name_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAuthorityKeyContainerNameAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardProvisioningStatics, 327690312, 3347, 20080, 151, 53, 81, 218, 236, 165, 37, 79);
RT_INTERFACE!{static interface ISmartCardProvisioningStatics(ISmartCardProvisioningStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardProvisioningStatics] {
    fn FromSmartCardAsync(&self, card: *mut SmartCard, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardProvisioning>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn RequestVirtualSmartCardCreationAsync(&self, friendlyName: HSTRING, administrativeKey: *mut super::super::storage::streams::IBuffer, pinPolicy: *mut SmartCardPinPolicy, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardProvisioning>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn RequestVirtualSmartCardCreationAsyncWithCardId(&self, friendlyName: HSTRING, administrativeKey: *mut super::super::storage::streams::IBuffer, pinPolicy: *mut SmartCardPinPolicy, cardId: Guid, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardProvisioning>) -> HRESULT,
    fn RequestVirtualSmartCardDeletionAsync(&self, card: *mut SmartCard, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ISmartCardProvisioningStatics {
    #[inline] pub unsafe fn from_smart_card_async(&self, card: &SmartCard) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromSmartCardAsync)(self as *const _ as *mut _, card as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn request_virtual_smart_card_creation_async(&self, friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestVirtualSmartCardCreationAsync)(self as *const _ as *mut _, friendlyName.get(), administrativeKey as *const _ as *mut _, pinPolicy as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn request_virtual_smart_card_creation_async_with_card_id(&self, friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy, cardId: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestVirtualSmartCardCreationAsyncWithCardId)(self as *const _ as *mut _, friendlyName.get(), administrativeKey as *const _ as *mut _, pinPolicy as *const _ as *mut _, cardId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_virtual_smart_card_deletion_async(&self, card: &SmartCard) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestVirtualSmartCardDeletionAsync)(self as *const _ as *mut _, card as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardProvisioningStatics2, 877119144, 51616, 19414, 181, 13, 37, 31, 78, 141, 58, 98);
RT_INTERFACE!{static interface ISmartCardProvisioningStatics2(ISmartCardProvisioningStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardProvisioningStatics2] {
    #[cfg(feature="windows-storage")] fn RequestAttestedVirtualSmartCardCreationAsync(&self, friendlyName: HSTRING, administrativeKey: *mut super::super::storage::streams::IBuffer, pinPolicy: *mut SmartCardPinPolicy, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardProvisioning>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn RequestAttestedVirtualSmartCardCreationAsyncWithCardId(&self, friendlyName: HSTRING, administrativeKey: *mut super::super::storage::streams::IBuffer, pinPolicy: *mut SmartCardPinPolicy, cardId: Guid, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardProvisioning>) -> HRESULT
}}
impl ISmartCardProvisioningStatics2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn request_attested_virtual_smart_card_creation_async(&self, friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAttestedVirtualSmartCardCreationAsync)(self as *const _ as *mut _, friendlyName.get(), administrativeKey as *const _ as *mut _, pinPolicy as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn request_attested_virtual_smart_card_creation_async_with_card_id(&self, friendlyName: &HStringArg, administrativeKey: &super::super::storage::streams::IBuffer, pinPolicy: &SmartCardPinPolicy, cardId: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardProvisioning>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAttestedVirtualSmartCardCreationAsyncWithCardId)(self as *const _ as *mut _, friendlyName.get(), administrativeKey as *const _ as *mut _, pinPolicy as *const _ as *mut _, cardId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardReader, 276083936, 21698, 19952, 129, 122, 20, 193, 67, 120, 240, 108);
RT_INTERFACE!{interface ISmartCardReader(ISmartCardReaderVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardReader] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Kind(&self, out: *mut SmartCardReaderKind) -> HRESULT,
    fn GetStatusAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardReaderStatus>) -> HRESULT,
    fn FindAllCardsAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SmartCard>>) -> HRESULT,
    fn add_CardAdded(&self, handler: *mut super::super::foundation::TypedEventHandler<SmartCardReader, CardAddedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CardAdded(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CardRemoved(&self, handler: *mut super::super::foundation::TypedEventHandler<SmartCardReader, CardRemovedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CardRemoved(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISmartCardReader {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<SmartCardReaderKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardReaderStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStatusAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_cards_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SmartCard>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllCardsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_card_added(&self, handler: &super::super::foundation::TypedEventHandler<SmartCardReader, CardAddedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CardAdded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_card_added(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CardAdded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_card_removed(&self, handler: &super::super::foundation::TypedEventHandler<SmartCardReader, CardRemovedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CardRemoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_card_removed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CardRemoved)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardReader: ISmartCardReader}
impl RtActivatable<ISmartCardReaderStatics> for SmartCardReader {}
impl SmartCardReader {
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<ISmartCardReaderStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn get_device_selector_with_kind(kind: SmartCardReaderKind) -> Result<HString> { unsafe {
        <Self as RtActivatable<ISmartCardReaderStatics>>::get_activation_factory().get_device_selector_with_kind(kind)
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardReader>>> { unsafe {
        <Self as RtActivatable<ISmartCardReaderStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
}
DEFINE_CLSID!(SmartCardReader(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,97,114,116,67,97,114,100,115,46,83,109,97,114,116,67,97,114,100,82,101,97,100,101,114,0]) [CLSID_SmartCardReader]);
RT_ENUM! { enum SmartCardReaderKind: i32 {
    Any (SmartCardReaderKind_Any) = 0, Generic (SmartCardReaderKind_Generic) = 1, Tpm (SmartCardReaderKind_Tpm) = 2, Nfc (SmartCardReaderKind_Nfc) = 3, Uicc (SmartCardReaderKind_Uicc) = 4, EmbeddedSE (SmartCardReaderKind_EmbeddedSE) = 5,
}}
DEFINE_IID!(IID_ISmartCardReaderStatics, 272368865, 41418, 18674, 162, 129, 91, 111, 102, 154, 241, 7);
RT_INTERFACE!{static interface ISmartCardReaderStatics(ISmartCardReaderStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardReaderStatics] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorWithKind(&self, kind: SmartCardReaderKind, out: *mut HSTRING) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmartCardReader>) -> HRESULT
}}
impl ISmartCardReaderStatics {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_with_kind(&self, kind: SmartCardReaderKind) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorWithKind)(self as *const _ as *mut _, kind, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmartCardReader>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmartCardReaderStatus: i32 {
    Disconnected (SmartCardReaderStatus_Disconnected) = 0, Ready (SmartCardReaderStatus_Ready) = 1, Exclusive (SmartCardReaderStatus_Exclusive) = 2,
}}
RT_ENUM! { enum SmartCardStatus: i32 {
    Disconnected (SmartCardStatus_Disconnected) = 0, Ready (SmartCardStatus_Ready) = 1, Shared (SmartCardStatus_Shared) = 2, Exclusive (SmartCardStatus_Exclusive) = 3, Unresponsive (SmartCardStatus_Unresponsive) = 4,
}}
DEFINE_IID!(IID_ISmartCardTriggerDetails, 1604055326, 14831, 20267, 180, 79, 10, 145, 85, 177, 119, 188);
RT_INTERFACE!{interface ISmartCardTriggerDetails(ISmartCardTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardTriggerDetails] {
    fn get_TriggerType(&self, out: *mut SmartCardTriggerType) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_SourceAppletId(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_TriggerData(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl ISmartCardTriggerDetails {
    #[inline] pub unsafe fn get_trigger_type(&self) -> Result<SmartCardTriggerType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TriggerType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_source_applet_id(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceAppletId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_trigger_data(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TriggerData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmartCardTriggerDetails: ISmartCardTriggerDetails}
DEFINE_IID!(IID_ISmartCardTriggerDetails2, 692438377, 35189, 19025, 158, 26, 95, 138, 118, 238, 81, 175);
RT_INTERFACE!{interface ISmartCardTriggerDetails2(ISmartCardTriggerDetails2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardTriggerDetails2] {
    fn get_Emulator(&self, out: *mut *mut SmartCardEmulator) -> HRESULT,
    fn TryLaunchCurrentAppAsync(&self, arguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryLaunchCurrentAppWithBehaviorAsync(&self, arguments: HSTRING, behavior: SmartCardLaunchBehavior, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ISmartCardTriggerDetails2 {
    #[inline] pub unsafe fn get_emulator(&self) -> Result<ComPtr<SmartCardEmulator>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Emulator)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_launch_current_app_async(&self, arguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryLaunchCurrentAppAsync)(self as *const _ as *mut _, arguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_launch_current_app_with_behavior_async(&self, arguments: &HStringArg, behavior: SmartCardLaunchBehavior) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryLaunchCurrentAppWithBehaviorAsync)(self as *const _ as *mut _, arguments.get(), behavior, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmartCardTriggerDetails3, 3017982589, 6342, 19368, 131, 118, 239, 3, 212, 145, 38, 102);
RT_INTERFACE!{interface ISmartCardTriggerDetails3(ISmartCardTriggerDetails3Vtbl): IInspectable(IInspectableVtbl) [IID_ISmartCardTriggerDetails3] {
    fn get_SmartCard(&self, out: *mut *mut SmartCard) -> HRESULT
}}
impl ISmartCardTriggerDetails3 {
    #[inline] pub unsafe fn get_smart_card(&self) -> Result<ComPtr<SmartCard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmartCard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmartCardTriggerType: i32 {
    EmulatorTransaction (SmartCardTriggerType_EmulatorTransaction) = 0, EmulatorNearFieldEntry (SmartCardTriggerType_EmulatorNearFieldEntry) = 1, EmulatorNearFieldExit (SmartCardTriggerType_EmulatorNearFieldExit) = 2, EmulatorHostApplicationActivated (SmartCardTriggerType_EmulatorHostApplicationActivated) = 3, EmulatorAppletIdGroupRegistrationChanged (SmartCardTriggerType_EmulatorAppletIdGroupRegistrationChanged) = 4, ReaderCardAdded (SmartCardTriggerType_ReaderCardAdded) = 5,
}}
RT_ENUM! { enum SmartCardUnlockPromptingBehavior: i32 {
    AllowUnlockPrompt (SmartCardUnlockPromptingBehavior_AllowUnlockPrompt) = 0, RequireUnlockPrompt (SmartCardUnlockPromptingBehavior_RequireUnlockPrompt) = 1, PreventUnlockPrompt (SmartCardUnlockPromptingBehavior_PreventUnlockPrompt) = 2,
}}
} // Windows.Devices.SmartCards
pub mod power { // Windows.Devices.Power
use ::prelude::*;
DEFINE_IID!(IID_IBattery, 3163115462, 114, 18376, 139, 93, 97, 74, 170, 122, 67, 126);
RT_INTERFACE!{interface IBattery(IBatteryVtbl): IInspectable(IInspectableVtbl) [IID_IBattery] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn GetReport(&self, out: *mut *mut BatteryReport) -> HRESULT,
    fn add_ReportUpdated(&self, handler: *mut super::super::foundation::TypedEventHandler<Battery, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ReportUpdated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IBattery {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_report(&self) -> Result<ComPtr<BatteryReport>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetReport)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_report_updated(&self, handler: &super::super::foundation::TypedEventHandler<Battery, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ReportUpdated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_report_updated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ReportUpdated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Battery: IBattery}
impl RtActivatable<IBatteryStatics> for Battery {}
impl Battery {
    #[inline] pub fn get_aggregate_battery() -> Result<ComPtr<Battery>> { unsafe {
        <Self as RtActivatable<IBatteryStatics>>::get_activation_factory().get_aggregate_battery()
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Battery>>> { unsafe {
        <Self as RtActivatable<IBatteryStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IBatteryStatics>>::get_activation_factory().get_device_selector()
    }}
}
DEFINE_CLSID!(Battery(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,80,111,119,101,114,46,66,97,116,116,101,114,121,0]) [CLSID_Battery]);
DEFINE_IID!(IID_IBatteryReport, 3380972602, 19987, 16906, 168, 208, 36, 241, 143, 57, 84, 1);
RT_INTERFACE!{interface IBatteryReport(IBatteryReportVtbl): IInspectable(IInspectableVtbl) [IID_IBatteryReport] {
    fn get_ChargeRateInMilliwatts(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_DesignCapacityInMilliwattHours(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_FullChargeCapacityInMilliwattHours(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_RemainingCapacityInMilliwattHours(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_Status(&self, out: *mut super::super::system::power::BatteryStatus) -> HRESULT
}}
impl IBatteryReport {
    #[inline] pub unsafe fn get_charge_rate_in_milliwatts(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChargeRateInMilliwatts)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_design_capacity_in_milliwatt_hours(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DesignCapacityInMilliwattHours)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_full_charge_capacity_in_milliwatt_hours(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FullChargeCapacityInMilliwattHours)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remaining_capacity_in_milliwatt_hours(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemainingCapacityInMilliwattHours)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_status(&self) -> Result<super::super::system::power::BatteryStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BatteryReport: IBatteryReport}
DEFINE_IID!(IID_IBatteryStatics, 2043507382, 40542, 17490, 190, 166, 223, 205, 84, 30, 89, 127);
RT_INTERFACE!{static interface IBatteryStatics(IBatteryStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBatteryStatics] {
    fn get_AggregateBattery(&self, out: *mut *mut Battery) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<Battery>) -> HRESULT,
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT
}}
impl IBatteryStatics {
    #[inline] pub unsafe fn get_aggregate_battery(&self) -> Result<ComPtr<Battery>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AggregateBattery)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Battery>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Devices.Power
pub mod sms { // Windows.Devices.Sms
use ::prelude::*;
RT_ENUM! { enum CellularClass: i32 {
    None (CellularClass_None) = 0, Gsm (CellularClass_Gsm) = 1, Cdma (CellularClass_Cdma) = 2,
}}
RT_CLASS!{class DeleteSmsMessageOperation: super::super::foundation::IAsyncAction}
RT_CLASS!{class DeleteSmsMessagesOperation: super::super::foundation::IAsyncAction}
RT_CLASS!{class GetSmsDeviceOperation: super::super::foundation::IAsyncOperation<SmsDevice>}
RT_CLASS!{class GetSmsMessageOperation: super::super::foundation::IAsyncOperation<ISmsMessage>}
RT_CLASS!{class GetSmsMessagesOperation: super::super::foundation::IAsyncOperationWithProgress<super::super::foundation::collections::IVectorView<ISmsMessage>, i32>}
RT_CLASS!{class SendSmsMessageOperation: super::super::foundation::IAsyncAction}
DEFINE_IID!(IID_ISmsAppMessage, 3904603284, 54176, 18954, 134, 215, 41, 16, 51, 168, 207, 84);
RT_INTERFACE!{interface ISmsAppMessage(ISmsAppMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsAppMessage] {
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn put_To(&self, value: HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Body(&self, value: HSTRING) -> HRESULT,
    fn get_CallbackNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CallbackNumber(&self, value: HSTRING) -> HRESULT,
    fn get_IsDeliveryNotificationEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsDeliveryNotificationEnabled(&self, value: bool) -> HRESULT,
    fn get_RetryAttemptCount(&self, out: *mut i32) -> HRESULT,
    fn put_RetryAttemptCount(&self, value: i32) -> HRESULT,
    fn get_Encoding(&self, out: *mut SmsEncoding) -> HRESULT,
    fn put_Encoding(&self, value: SmsEncoding) -> HRESULT,
    fn get_PortNumber(&self, out: *mut i32) -> HRESULT,
    fn put_PortNumber(&self, value: i32) -> HRESULT,
    fn get_TeleserviceId(&self, out: *mut i32) -> HRESULT,
    fn put_TeleserviceId(&self, value: i32) -> HRESULT,
    fn get_ProtocolId(&self, out: *mut i32) -> HRESULT,
    fn put_ProtocolId(&self, value: i32) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_BinaryBody(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_BinaryBody(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl ISmsAppMessage {
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_to(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_To)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_body(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Body)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_callback_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallbackNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_callback_number(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CallbackNumber)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_delivery_notification_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDeliveryNotificationEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_delivery_notification_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDeliveryNotificationEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_retry_attempt_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RetryAttemptCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_retry_attempt_count(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RetryAttemptCount)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding(&self) -> Result<SmsEncoding> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Encoding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_encoding(&self, value: SmsEncoding) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Encoding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_port_number(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PortNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_port_number(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PortNumber)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_teleservice_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TeleserviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_teleservice_id(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TeleserviceId)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtocolId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_protocol_id(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProtocolId)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_binary_body(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BinaryBody)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_binary_body(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BinaryBody)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmsAppMessage: ISmsAppMessage}
impl RtActivatable<IActivationFactory> for SmsAppMessage {}
DEFINE_CLSID!(SmsAppMessage(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,65,112,112,77,101,115,115,97,103,101,0]) [CLSID_SmsAppMessage]);
DEFINE_IID!(IID_ISmsBinaryMessage, 1542776851, 15187, 19566, 182, 26, 216, 106, 99, 117, 86, 80);
RT_INTERFACE!{interface ISmsBinaryMessage(ISmsBinaryMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsBinaryMessage] {
    fn get_Format(&self, out: *mut SmsDataFormat) -> HRESULT,
    fn put_Format(&self, value: SmsDataFormat) -> HRESULT,
    fn GetData(&self, outSize: *mut u32, out: *mut *mut u8) -> HRESULT,
    fn SetData(&self, valueSize: u32, value: *mut u8) -> HRESULT
}}
impl ISmsBinaryMessage {
    #[inline] pub unsafe fn get_format(&self) -> Result<SmsDataFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Format)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_format(&self, value: SmsDataFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Format)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data(&self) -> Result<ComArray<u8>> {
        let mut outSize = 0; let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetData)(self as *const _ as *mut _, &mut outSize, &mut out);
        if hr == S_OK { Ok(ComArray::from_raw(outSize, out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data(&self, value: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).SetData)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmsBinaryMessage: ISmsBinaryMessage}
impl RtActivatable<IActivationFactory> for SmsBinaryMessage {}
DEFINE_CLSID!(SmsBinaryMessage(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,66,105,110,97,114,121,77,101,115,115,97,103,101,0]) [CLSID_SmsBinaryMessage]);
DEFINE_IID!(IID_ISmsBroadcastMessage, 1974385649, 58551, 18548, 160, 156, 41, 86, 229, 146, 249, 87);
RT_INTERFACE!{interface ISmsBroadcastMessage(ISmsBroadcastMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsBroadcastMessage] {
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Channel(&self, out: *mut i32) -> HRESULT,
    fn get_GeographicalScope(&self, out: *mut SmsGeographicalScope) -> HRESULT,
    fn get_MessageCode(&self, out: *mut i32) -> HRESULT,
    fn get_UpdateNumber(&self, out: *mut i32) -> HRESULT,
    fn get_BroadcastType(&self, out: *mut SmsBroadcastType) -> HRESULT,
    fn get_IsEmergencyAlert(&self, out: *mut bool) -> HRESULT,
    fn get_IsUserPopupRequested(&self, out: *mut bool) -> HRESULT
}}
impl ISmsBroadcastMessage {
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_channel(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Channel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_geographical_scope(&self) -> Result<SmsGeographicalScope> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GeographicalScope)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_code(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_update_number(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UpdateNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_type(&self) -> Result<SmsBroadcastType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BroadcastType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_emergency_alert(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEmergencyAlert)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_user_popup_requested(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsUserPopupRequested)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmsBroadcastMessage: ISmsBroadcastMessage}
RT_ENUM! { enum SmsBroadcastType: i32 {
    Other (SmsBroadcastType_Other) = 0, CmasPresidential (SmsBroadcastType_CmasPresidential) = 1, CmasExtreme (SmsBroadcastType_CmasExtreme) = 2, CmasSevere (SmsBroadcastType_CmasSevere) = 3, CmasAmber (SmsBroadcastType_CmasAmber) = 4, CmasTest (SmsBroadcastType_CmasTest) = 5, EUAlert1 (SmsBroadcastType_EUAlert1) = 6, EUAlert2 (SmsBroadcastType_EUAlert2) = 7, EUAlert3 (SmsBroadcastType_EUAlert3) = 8, EUAlertAmber (SmsBroadcastType_EUAlertAmber) = 9, EUAlertInfo (SmsBroadcastType_EUAlertInfo) = 10, EtwsEarthquake (SmsBroadcastType_EtwsEarthquake) = 11, EtwsTsunami (SmsBroadcastType_EtwsTsunami) = 12, EtwsTsunamiAndEarthquake (SmsBroadcastType_EtwsTsunamiAndEarthquake) = 13, LatAlertLocal (SmsBroadcastType_LatAlertLocal) = 14,
}}
RT_ENUM! { enum SmsDataFormat: i32 {
    Unknown (SmsDataFormat_Unknown) = 0, CdmaSubmit (SmsDataFormat_CdmaSubmit) = 1, GsmSubmit (SmsDataFormat_GsmSubmit) = 2, CdmaDeliver (SmsDataFormat_CdmaDeliver) = 3, GsmDeliver (SmsDataFormat_GsmDeliver) = 4,
}}
DEFINE_IID!(IID_ISmsDevice, 152539629, 34603, 20204, 156, 114, 171, 17, 98, 123, 52, 236);
RT_INTERFACE!{interface ISmsDevice(ISmsDeviceVtbl): IInspectable(IInspectableVtbl) [IID_ISmsDevice] {
    fn SendMessageAsync(&self, message: *mut ISmsMessage, out: *mut *mut SendSmsMessageOperation) -> HRESULT,
    fn CalculateLength(&self, message: *mut SmsTextMessage, out: *mut SmsEncodedLength) -> HRESULT,
    fn get_AccountPhoneNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CellularClass(&self, out: *mut CellularClass) -> HRESULT,
    fn get_MessageStore(&self, out: *mut *mut SmsDeviceMessageStore) -> HRESULT,
    fn get_DeviceStatus(&self, out: *mut SmsDeviceStatus) -> HRESULT,
    fn add_SmsMessageReceived(&self, eventHandler: *mut SmsMessageReceivedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SmsMessageReceived(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SmsDeviceStatusChanged(&self, eventHandler: *mut SmsDeviceStatusChangedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SmsDeviceStatusChanged(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISmsDevice {
    #[inline] pub unsafe fn send_message_async(&self, message: &ISmsMessage) -> Result<ComPtr<SendSmsMessageOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendMessageAsync)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn calculate_length(&self, message: &SmsTextMessage) -> Result<SmsEncodedLength> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CalculateLength)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_account_phone_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccountPhoneNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cellular_class(&self) -> Result<CellularClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CellularClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_store(&self) -> Result<ComPtr<SmsDeviceMessageStore>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MessageStore)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_status(&self) -> Result<SmsDeviceStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeviceStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sms_message_received(&self, eventHandler: &SmsMessageReceivedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SmsMessageReceived)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sms_message_received(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SmsMessageReceived)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sms_device_status_changed(&self, eventHandler: &SmsDeviceStatusChangedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SmsDeviceStatusChanged)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sms_device_status_changed(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SmsDeviceStatusChanged)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmsDevice: ISmsDevice}
impl RtActivatable<ISmsDeviceStatics> for SmsDevice {}
impl RtActivatable<ISmsDeviceStatics2> for SmsDevice {}
impl SmsDevice {
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<ISmsDeviceStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsDevice>>> { unsafe {
        <Self as RtActivatable<ISmsDeviceStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsDevice>>> { unsafe {
        <Self as RtActivatable<ISmsDeviceStatics>>::get_activation_factory().get_default_async()
    }}
    #[inline] pub fn from_network_account_id_async(networkAccountId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsDevice>>> { unsafe {
        <Self as RtActivatable<ISmsDeviceStatics2>>::get_activation_factory().from_network_account_id_async(networkAccountId)
    }}
}
DEFINE_CLSID!(SmsDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,68,101,118,105,99,101,0]) [CLSID_SmsDevice]);
DEFINE_IID!(IID_ISmsDevice2, 3179961363, 58658, 18123, 184, 213, 158, 173, 48, 251, 108, 71);
RT_INTERFACE!{interface ISmsDevice2(ISmsDevice2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmsDevice2] {
    fn get_SmscAddress(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SmscAddress(&self, value: HSTRING) -> HRESULT,
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ParentDeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AccountPhoneNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CellularClass(&self, out: *mut CellularClass) -> HRESULT,
    fn get_DeviceStatus(&self, out: *mut SmsDeviceStatus) -> HRESULT,
    fn CalculateLength(&self, message: *mut ISmsMessageBase, out: *mut SmsEncodedLength) -> HRESULT,
    fn SendMessageAndGetResultAsync(&self, message: *mut ISmsMessageBase, out: *mut *mut super::super::foundation::IAsyncOperation<SmsSendMessageResult>) -> HRESULT,
    fn add_DeviceStatusChanged(&self, eventHandler: *mut super::super::foundation::TypedEventHandler<SmsDevice2, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DeviceStatusChanged(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISmsDevice2 {
    #[inline] pub unsafe fn get_smsc_address(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmscAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_smsc_address(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SmscAddress)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_parent_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ParentDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_account_phone_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccountPhoneNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cellular_class(&self) -> Result<CellularClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CellularClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_status(&self) -> Result<SmsDeviceStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeviceStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn calculate_length(&self, message: &ISmsMessageBase) -> Result<SmsEncodedLength> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CalculateLength)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn send_message_and_get_result_async(&self, message: &ISmsMessageBase) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsSendMessageResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendMessageAndGetResultAsync)(self as *const _ as *mut _, message as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_device_status_changed(&self, eventHandler: &super::super::foundation::TypedEventHandler<SmsDevice2, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DeviceStatusChanged)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_device_status_changed(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DeviceStatusChanged)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmsDevice2: ISmsDevice2}
impl RtActivatable<ISmsDevice2Statics> for SmsDevice2 {}
impl SmsDevice2 {
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<ISmsDevice2Statics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn from_id(deviceId: &HStringArg) -> Result<ComPtr<SmsDevice2>> { unsafe {
        <Self as RtActivatable<ISmsDevice2Statics>>::get_activation_factory().from_id(deviceId)
    }}
    #[inline] pub fn get_default() -> Result<ComPtr<SmsDevice2>> { unsafe {
        <Self as RtActivatable<ISmsDevice2Statics>>::get_activation_factory().get_default()
    }}
    #[inline] pub fn from_parent_id(parentDeviceId: &HStringArg) -> Result<ComPtr<SmsDevice2>> { unsafe {
        <Self as RtActivatable<ISmsDevice2Statics>>::get_activation_factory().from_parent_id(parentDeviceId)
    }}
}
DEFINE_CLSID!(SmsDevice2(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,68,101,118,105,99,101,50,0]) [CLSID_SmsDevice2]);
DEFINE_IID!(IID_ISmsDevice2Statics, 1707574053, 4145, 18718, 143, 182, 239, 153, 145, 175, 227, 99);
RT_INTERFACE!{static interface ISmsDevice2Statics(ISmsDevice2StaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsDevice2Statics] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn FromId(&self, deviceId: HSTRING, out: *mut *mut SmsDevice2) -> HRESULT,
    fn GetDefault(&self, out: *mut *mut SmsDevice2) -> HRESULT,
    fn FromParentId(&self, parentDeviceId: HSTRING, out: *mut *mut SmsDevice2) -> HRESULT
}}
impl ISmsDevice2Statics {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id(&self, deviceId: &HStringArg) -> Result<ComPtr<SmsDevice2>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromId)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<SmsDevice2>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_parent_id(&self, parentDeviceId: &HStringArg) -> Result<ComPtr<SmsDevice2>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromParentId)(self as *const _ as *mut _, parentDeviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsDeviceMessageStore, 2559177299, 61832, 17447, 141, 84, 206, 12, 36, 35, 197, 193);
RT_INTERFACE!{interface ISmsDeviceMessageStore(ISmsDeviceMessageStoreVtbl): IInspectable(IInspectableVtbl) [IID_ISmsDeviceMessageStore] {
    fn DeleteMessageAsync(&self, messageId: u32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn DeleteMessagesAsync(&self, messageFilter: SmsMessageFilter, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn GetMessageAsync(&self, messageId: u32, out: *mut *mut super::super::foundation::IAsyncOperation<ISmsMessage>) -> HRESULT,
    fn GetMessagesAsync(&self, messageFilter: SmsMessageFilter, out: *mut *mut super::super::foundation::IAsyncOperationWithProgress<super::super::foundation::collections::IVectorView<ISmsMessage>, i32>) -> HRESULT,
    fn get_MaxMessages(&self, out: *mut u32) -> HRESULT
}}
impl ISmsDeviceMessageStore {
    #[inline] pub unsafe fn delete_message_async(&self, messageId: u32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteMessageAsync)(self as *const _ as *mut _, messageId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_messages_async(&self, messageFilter: SmsMessageFilter) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeleteMessagesAsync)(self as *const _ as *mut _, messageFilter, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_async(&self, messageId: u32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ISmsMessage>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessageAsync)(self as *const _ as *mut _, messageId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_messages_async(&self, messageFilter: SmsMessageFilter) -> Result<ComPtr<super::super::foundation::IAsyncOperationWithProgress<super::super::foundation::collections::IVectorView<ISmsMessage>, i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMessagesAsync)(self as *const _ as *mut _, messageFilter, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_messages(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxMessages)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmsDeviceMessageStore: ISmsDeviceMessageStore}
DEFINE_IID!(IID_ISmsDeviceStatics, 4169992170, 55317, 19921, 162, 52, 69, 32, 206, 70, 4, 164);
RT_INTERFACE!{static interface ISmsDeviceStatics(ISmsDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsDeviceStatics] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmsDevice>) -> HRESULT,
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<SmsDevice>) -> HRESULT
}}
impl ISmsDeviceStatics {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsDeviceStatics2, 748756103, 2163, 19631, 138, 125, 189, 71, 30, 133, 134, 209);
RT_INTERFACE!{static interface ISmsDeviceStatics2(ISmsDeviceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmsDeviceStatics2] {
    fn FromNetworkAccountIdAsync(&self, networkAccountId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<SmsDevice>) -> HRESULT
}}
impl ISmsDeviceStatics2 {
    #[inline] pub unsafe fn from_network_account_id_async(&self, networkAccountId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<SmsDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromNetworkAccountIdAsync)(self as *const _ as *mut _, networkAccountId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmsDeviceStatus: i32 {
    Off (SmsDeviceStatus_Off) = 0, Ready (SmsDeviceStatus_Ready) = 1, SimNotInserted (SmsDeviceStatus_SimNotInserted) = 2, BadSim (SmsDeviceStatus_BadSim) = 3, DeviceFailure (SmsDeviceStatus_DeviceFailure) = 4, SubscriptionNotActivated (SmsDeviceStatus_SubscriptionNotActivated) = 5, DeviceLocked (SmsDeviceStatus_DeviceLocked) = 6, DeviceBlocked (SmsDeviceStatus_DeviceBlocked) = 7,
}}
DEFINE_IID!(IID_SmsDeviceStatusChangedEventHandler, 2552959330, 15831, 17944, 175, 137, 12, 39, 45, 93, 6, 216);
RT_DELEGATE!{delegate SmsDeviceStatusChangedEventHandler(SmsDeviceStatusChangedEventHandlerVtbl, SmsDeviceStatusChangedEventHandlerImpl) [IID_SmsDeviceStatusChangedEventHandler] {
    fn Invoke(&self, sender: *mut SmsDevice) -> HRESULT
}}
impl SmsDeviceStatusChangedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &SmsDevice) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_STRUCT! { struct SmsEncodedLength {
    SegmentCount: u32, CharacterCountLastSegment: u32, CharactersPerSegment: u32, ByteCountLastSegment: u32, BytesPerSegment: u32,
}}
RT_ENUM! { enum SmsEncoding: i32 {
    Unknown (SmsEncoding_Unknown) = 0, Optimal (SmsEncoding_Optimal) = 1, SevenBitAscii (SmsEncoding_SevenBitAscii) = 2, Unicode (SmsEncoding_Unicode) = 3, GsmSevenBit (SmsEncoding_GsmSevenBit) = 4, EightBit (SmsEncoding_EightBit) = 5, Latin (SmsEncoding_Latin) = 6, Korean (SmsEncoding_Korean) = 7, IA5 (SmsEncoding_IA5) = 8, ShiftJis (SmsEncoding_ShiftJis) = 9, LatinHebrew (SmsEncoding_LatinHebrew) = 10,
}}
RT_ENUM! { enum SmsFilterActionType: i32 {
    AcceptImmediately (SmsFilterActionType_AcceptImmediately) = 0, Drop (SmsFilterActionType_Drop) = 1, Peek (SmsFilterActionType_Peek) = 2, Accept (SmsFilterActionType_Accept) = 3,
}}
DEFINE_IID!(IID_ISmsFilterRule, 1088630702, 45129, 20412, 175, 233, 226, 166, 16, 239, 245, 92);
RT_INTERFACE!{interface ISmsFilterRule(ISmsFilterRuleVtbl): IInspectable(IInspectableVtbl) [IID_ISmsFilterRule] {
    fn get_MessageType(&self, out: *mut SmsMessageType) -> HRESULT,
    fn get_ImsiPrefixes(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_DeviceIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_SenderNumbers(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_TextMessagePrefixes(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_PortNumbers(&self, out: *mut *mut super::super::foundation::collections::IVector<i32>) -> HRESULT,
    fn get_CellularClass(&self, out: *mut CellularClass) -> HRESULT,
    fn put_CellularClass(&self, value: CellularClass) -> HRESULT,
    fn get_ProtocolIds(&self, out: *mut *mut super::super::foundation::collections::IVector<i32>) -> HRESULT,
    fn get_TeleserviceIds(&self, out: *mut *mut super::super::foundation::collections::IVector<i32>) -> HRESULT,
    fn get_WapApplicationIds(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_WapContentTypes(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn get_BroadcastTypes(&self, out: *mut *mut super::super::foundation::collections::IVector<SmsBroadcastType>) -> HRESULT,
    fn get_BroadcastChannels(&self, out: *mut *mut super::super::foundation::collections::IVector<i32>) -> HRESULT
}}
impl ISmsFilterRule {
    #[inline] pub unsafe fn get_message_type(&self) -> Result<SmsMessageType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_imsi_prefixes(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ImsiPrefixes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sender_numbers(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SenderNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_message_prefixes(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextMessagePrefixes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_port_numbers(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PortNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cellular_class(&self) -> Result<CellularClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CellularClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cellular_class(&self, value: CellularClass) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CellularClass)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_teleservice_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TeleserviceIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wap_application_ids(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WapApplicationIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wap_content_types(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WapContentTypes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_types(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<SmsBroadcastType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastTypes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_channels(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastChannels)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsFilterRule: ISmsFilterRule}
impl RtActivatable<ISmsFilterRuleFactory> for SmsFilterRule {}
impl SmsFilterRule {
    #[inline] pub fn create_filter_rule(messageType: SmsMessageType) -> Result<ComPtr<SmsFilterRule>> { unsafe {
        <Self as RtActivatable<ISmsFilterRuleFactory>>::get_activation_factory().create_filter_rule(messageType)
    }}
}
DEFINE_CLSID!(SmsFilterRule(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,70,105,108,116,101,114,82,117,108,101,0]) [CLSID_SmsFilterRule]);
DEFINE_IID!(IID_ISmsFilterRuleFactory, 12805384, 25238, 20265, 154, 173, 137, 32, 206, 186, 60, 232);
RT_INTERFACE!{static interface ISmsFilterRuleFactory(ISmsFilterRuleFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISmsFilterRuleFactory] {
    fn CreateFilterRule(&self, messageType: SmsMessageType, out: *mut *mut SmsFilterRule) -> HRESULT
}}
impl ISmsFilterRuleFactory {
    #[inline] pub unsafe fn create_filter_rule(&self, messageType: SmsMessageType) -> Result<ComPtr<SmsFilterRule>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFilterRule)(self as *const _ as *mut _, messageType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsFilterRules, 1313336059, 31181, 18561, 152, 148, 85, 164, 19, 91, 35, 250);
RT_INTERFACE!{interface ISmsFilterRules(ISmsFilterRulesVtbl): IInspectable(IInspectableVtbl) [IID_ISmsFilterRules] {
    fn get_ActionType(&self, out: *mut SmsFilterActionType) -> HRESULT,
    fn get_Rules(&self, out: *mut *mut super::super::foundation::collections::IVector<SmsFilterRule>) -> HRESULT
}}
impl ISmsFilterRules {
    #[inline] pub unsafe fn get_action_type(&self) -> Result<SmsFilterActionType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActionType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rules(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<SmsFilterRule>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Rules)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsFilterRules: ISmsFilterRules}
impl RtActivatable<ISmsFilterRulesFactory> for SmsFilterRules {}
impl SmsFilterRules {
    #[inline] pub fn create_filter_rules(actionType: SmsFilterActionType) -> Result<ComPtr<SmsFilterRules>> { unsafe {
        <Self as RtActivatable<ISmsFilterRulesFactory>>::get_activation_factory().create_filter_rules(actionType)
    }}
}
DEFINE_CLSID!(SmsFilterRules(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,70,105,108,116,101,114,82,117,108,101,115,0]) [CLSID_SmsFilterRules]);
DEFINE_IID!(IID_ISmsFilterRulesFactory, 2694391021, 28206, 17712, 159, 222, 70, 93, 2, 238, 208, 14);
RT_INTERFACE!{static interface ISmsFilterRulesFactory(ISmsFilterRulesFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISmsFilterRulesFactory] {
    fn CreateFilterRules(&self, actionType: SmsFilterActionType, out: *mut *mut SmsFilterRules) -> HRESULT
}}
impl ISmsFilterRulesFactory {
    #[inline] pub unsafe fn create_filter_rules(&self, actionType: SmsFilterActionType) -> Result<ComPtr<SmsFilterRules>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFilterRules)(self as *const _ as *mut _, actionType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmsGeographicalScope: i32 {
    None (SmsGeographicalScope_None) = 0, CellWithImmediateDisplay (SmsGeographicalScope_CellWithImmediateDisplay) = 1, LocationArea (SmsGeographicalScope_LocationArea) = 2, Plmn (SmsGeographicalScope_Plmn) = 3, Cell (SmsGeographicalScope_Cell) = 4,
}}
DEFINE_IID!(IID_ISmsMessage, 3980156456, 27012, 19207, 129, 29, 141, 89, 6, 237, 60, 234);
RT_INTERFACE!{interface ISmsMessage(ISmsMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessage] {
    fn get_Id(&self, out: *mut u32) -> HRESULT,
    fn get_MessageClass(&self, out: *mut SmsMessageClass) -> HRESULT
}}
impl ISmsMessage {
    #[inline] pub unsafe fn get_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_class(&self) -> Result<SmsMessageClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsMessageBase, 753991216, 65104, 20422, 170, 136, 76, 207, 226, 122, 41, 234);
RT_INTERFACE!{interface ISmsMessageBase(ISmsMessageBaseVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessageBase] {
    fn get_MessageType(&self, out: *mut SmsMessageType) -> HRESULT,
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CellularClass(&self, out: *mut CellularClass) -> HRESULT,
    fn get_MessageClass(&self, out: *mut SmsMessageClass) -> HRESULT,
    fn get_SimIccId(&self, out: *mut HSTRING) -> HRESULT
}}
impl ISmsMessageBase {
    #[inline] pub unsafe fn get_message_type(&self) -> Result<SmsMessageType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cellular_class(&self) -> Result<CellularClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CellularClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_class(&self) -> Result<SmsMessageClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sim_icc_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimIccId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmsMessageClass: i32 {
    None (SmsMessageClass_None) = 0, Class0 (SmsMessageClass_Class0) = 1, Class1 (SmsMessageClass_Class1) = 2, Class2 (SmsMessageClass_Class2) = 3, Class3 (SmsMessageClass_Class3) = 4,
}}
RT_ENUM! { enum SmsMessageFilter: i32 {
    All (SmsMessageFilter_All) = 0, Unread (SmsMessageFilter_Unread) = 1, Read (SmsMessageFilter_Read) = 2, Sent (SmsMessageFilter_Sent) = 3, Draft (SmsMessageFilter_Draft) = 4,
}}
DEFINE_IID!(IID_ISmsMessageReceivedEventArgs, 149424792, 47333, 16833, 163, 216, 211, 171, 250, 226, 38, 117);
RT_INTERFACE!{interface ISmsMessageReceivedEventArgs(ISmsMessageReceivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessageReceivedEventArgs] {
    fn get_TextMessage(&self, out: *mut *mut SmsTextMessage) -> HRESULT,
    fn get_BinaryMessage(&self, out: *mut *mut SmsBinaryMessage) -> HRESULT
}}
impl ISmsMessageReceivedEventArgs {
    #[inline] pub unsafe fn get_text_message(&self) -> Result<ComPtr<SmsTextMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_binary_message(&self) -> Result<ComPtr<SmsBinaryMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BinaryMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsMessageReceivedEventArgs: ISmsMessageReceivedEventArgs}
DEFINE_IID!(IID_SmsMessageReceivedEventHandler, 192599049, 60461, 18382, 162, 83, 115, 43, 238, 235, 202, 205);
RT_DELEGATE!{delegate SmsMessageReceivedEventHandler(SmsMessageReceivedEventHandlerVtbl, SmsMessageReceivedEventHandlerImpl) [IID_SmsMessageReceivedEventHandler] {
    fn Invoke(&self, sender: *mut SmsDevice, e: *mut SmsMessageReceivedEventArgs) -> HRESULT
}}
impl SmsMessageReceivedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &SmsDevice, e: &SmsMessageReceivedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsMessageReceivedTriggerDetails, 735038420, 9815, 16680, 173, 95, 227, 135, 113, 50, 189, 177);
RT_INTERFACE!{interface ISmsMessageReceivedTriggerDetails(ISmsMessageReceivedTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessageReceivedTriggerDetails] {
    fn get_MessageType(&self, out: *mut SmsMessageType) -> HRESULT,
    fn get_TextMessage(&self, out: *mut *mut SmsTextMessage2) -> HRESULT,
    fn get_WapMessage(&self, out: *mut *mut SmsWapMessage) -> HRESULT,
    fn get_AppMessage(&self, out: *mut *mut SmsAppMessage) -> HRESULT,
    fn get_BroadcastMessage(&self, out: *mut *mut SmsBroadcastMessage) -> HRESULT,
    fn get_VoicemailMessage(&self, out: *mut *mut SmsVoicemailMessage) -> HRESULT,
    fn get_StatusMessage(&self, out: *mut *mut SmsStatusMessage) -> HRESULT,
    fn Drop(&self) -> HRESULT,
    fn Accept(&self) -> HRESULT
}}
impl ISmsMessageReceivedTriggerDetails {
    #[inline] pub unsafe fn get_message_type(&self) -> Result<SmsMessageType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_message(&self) -> Result<ComPtr<SmsTextMessage2>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wap_message(&self) -> Result<ComPtr<SmsWapMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WapMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_message(&self) -> Result<ComPtr<SmsAppMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_message(&self) -> Result<ComPtr<SmsBroadcastMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_voicemail_message(&self) -> Result<ComPtr<SmsVoicemailMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VoicemailMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status_message(&self) -> Result<ComPtr<SmsStatusMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StatusMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn drop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Drop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Accept)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmsMessageReceivedTriggerDetails: ISmsMessageReceivedTriggerDetails}
DEFINE_IID!(IID_ISmsMessageRegistration, 387993662, 62287, 17515, 131, 179, 15, 241, 153, 35, 180, 9);
RT_INTERFACE!{interface ISmsMessageRegistration(ISmsMessageRegistrationVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessageRegistration] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn Unregister(&self) -> HRESULT,
    fn add_MessageReceived(&self, eventHandler: *mut super::super::foundation::TypedEventHandler<SmsMessageRegistration, SmsMessageReceivedTriggerDetails>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MessageReceived(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISmsMessageRegistration {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn unregister(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Unregister)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_message_received(&self, eventHandler: &super::super::foundation::TypedEventHandler<SmsMessageRegistration, SmsMessageReceivedTriggerDetails>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MessageReceived)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_message_received(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MessageReceived)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SmsMessageRegistration: ISmsMessageRegistration}
impl RtActivatable<ISmsMessageRegistrationStatics> for SmsMessageRegistration {}
impl SmsMessageRegistration {
    #[inline] pub fn get_all_registrations() -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmsMessageRegistration>>> { unsafe {
        <Self as RtActivatable<ISmsMessageRegistrationStatics>>::get_activation_factory().get_all_registrations()
    }}
    #[inline] pub fn register(id: &HStringArg, filterRules: &SmsFilterRules) -> Result<ComPtr<SmsMessageRegistration>> { unsafe {
        <Self as RtActivatable<ISmsMessageRegistrationStatics>>::get_activation_factory().register(id, filterRules)
    }}
}
DEFINE_CLSID!(SmsMessageRegistration(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,77,101,115,115,97,103,101,82,101,103,105,115,116,114,97,116,105,111,110,0]) [CLSID_SmsMessageRegistration]);
DEFINE_IID!(IID_ISmsMessageRegistrationStatics, 1671451748, 10392, 18296, 160, 60, 111, 153, 73, 7, 214, 58);
RT_INTERFACE!{static interface ISmsMessageRegistrationStatics(ISmsMessageRegistrationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsMessageRegistrationStatics] {
    fn get_AllRegistrations(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SmsMessageRegistration>) -> HRESULT,
    fn Register(&self, id: HSTRING, filterRules: *mut SmsFilterRules, out: *mut *mut SmsMessageRegistration) -> HRESULT
}}
impl ISmsMessageRegistrationStatics {
    #[inline] pub unsafe fn get_all_registrations(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SmsMessageRegistration>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllRegistrations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn register(&self, id: &HStringArg, filterRules: &SmsFilterRules) -> Result<ComPtr<SmsMessageRegistration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Register)(self as *const _ as *mut _, id.get(), filterRules as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SmsMessageType: i32 {
    Binary (SmsMessageType_Binary) = 0, Text (SmsMessageType_Text) = 1, Wap (SmsMessageType_Wap) = 2, App (SmsMessageType_App) = 3, Broadcast (SmsMessageType_Broadcast) = 4, Voicemail (SmsMessageType_Voicemail) = 5, Status (SmsMessageType_Status) = 6,
}}
RT_ENUM! { enum SmsModemErrorCode: i32 {
    Other (SmsModemErrorCode_Other) = 0, MessagingNetworkError (SmsModemErrorCode_MessagingNetworkError) = 1, SmsOperationNotSupportedByDevice (SmsModemErrorCode_SmsOperationNotSupportedByDevice) = 2, SmsServiceNotSupportedByNetwork (SmsModemErrorCode_SmsServiceNotSupportedByNetwork) = 3, DeviceFailure (SmsModemErrorCode_DeviceFailure) = 4, MessageNotEncodedProperly (SmsModemErrorCode_MessageNotEncodedProperly) = 5, MessageTooLarge (SmsModemErrorCode_MessageTooLarge) = 6, DeviceNotReady (SmsModemErrorCode_DeviceNotReady) = 7, NetworkNotReady (SmsModemErrorCode_NetworkNotReady) = 8, InvalidSmscAddress (SmsModemErrorCode_InvalidSmscAddress) = 9, NetworkFailure (SmsModemErrorCode_NetworkFailure) = 10, FixedDialingNumberRestricted (SmsModemErrorCode_FixedDialingNumberRestricted) = 11,
}}
DEFINE_IID!(IID_ISmsReceivedEventDetails, 1538592533, 58477, 19586, 132, 125, 90, 3, 4, 193, 213, 61);
RT_INTERFACE!{interface ISmsReceivedEventDetails(ISmsReceivedEventDetailsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsReceivedEventDetails] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_MessageIndex(&self, out: *mut u32) -> HRESULT
}}
impl ISmsReceivedEventDetails {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmsReceivedEventDetails: ISmsReceivedEventDetails}
DEFINE_IID!(IID_ISmsReceivedEventDetails2, 1088445574, 42932, 18289, 154, 231, 11, 95, 251, 18, 192, 58);
RT_INTERFACE!{interface ISmsReceivedEventDetails2(ISmsReceivedEventDetails2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmsReceivedEventDetails2] {
    fn get_MessageClass(&self, out: *mut SmsMessageClass) -> HRESULT,
    fn get_BinaryMessage(&self, out: *mut *mut SmsBinaryMessage) -> HRESULT
}}
impl ISmsReceivedEventDetails2 {
    #[inline] pub unsafe fn get_message_class(&self) -> Result<SmsMessageClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_binary_message(&self) -> Result<ComPtr<SmsBinaryMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BinaryMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsSendMessageResult, 3675495154, 30921, 20459, 150, 34, 69, 35, 40, 8, 141, 98);
RT_INTERFACE!{interface ISmsSendMessageResult(ISmsSendMessageResultVtbl): IInspectable(IInspectableVtbl) [IID_ISmsSendMessageResult] {
    fn get_IsSuccessful(&self, out: *mut bool) -> HRESULT,
    fn get_MessageReferenceNumbers(&self, out: *mut *mut super::super::foundation::collections::IVectorView<i32>) -> HRESULT,
    fn get_CellularClass(&self, out: *mut CellularClass) -> HRESULT,
    fn get_ModemErrorCode(&self, out: *mut SmsModemErrorCode) -> HRESULT,
    fn get_IsErrorTransient(&self, out: *mut bool) -> HRESULT,
    fn get_NetworkCauseCode(&self, out: *mut i32) -> HRESULT,
    fn get_TransportFailureCause(&self, out: *mut i32) -> HRESULT
}}
impl ISmsSendMessageResult {
    #[inline] pub unsafe fn get_is_successful(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSuccessful)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_reference_numbers(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MessageReferenceNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cellular_class(&self) -> Result<CellularClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CellularClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_modem_error_code(&self) -> Result<SmsModemErrorCode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ModemErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_error_transient(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsErrorTransient)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_network_cause_code(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NetworkCauseCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transport_failure_cause(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TransportFailureCause)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmsSendMessageResult: ISmsSendMessageResult}
DEFINE_IID!(IID_ISmsStatusMessage, 3872555842, 46859, 18039, 147, 121, 201, 120, 63, 223, 248, 244);
RT_INTERFACE!{interface ISmsStatusMessage(ISmsStatusMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsStatusMessage] {
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Status(&self, out: *mut i32) -> HRESULT,
    fn get_MessageReferenceNumber(&self, out: *mut i32) -> HRESULT,
    fn get_ServiceCenterTimestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_DischargeTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT
}}
impl ISmsStatusMessage {
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_reference_number(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageReferenceNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_center_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceCenterTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_discharge_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DischargeTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmsStatusMessage: ISmsStatusMessage}
DEFINE_IID!(IID_ISmsTextMessage, 3592196172, 42133, 18559, 154, 111, 151, 21, 72, 197, 188, 159);
RT_INTERFACE!{interface ISmsTextMessage(ISmsTextMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsTextMessage] {
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_PartReferenceId(&self, out: *mut u32) -> HRESULT,
    fn get_PartNumber(&self, out: *mut u32) -> HRESULT,
    fn get_PartCount(&self, out: *mut u32) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn put_To(&self, value: HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn put_From(&self, value: HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Body(&self, value: HSTRING) -> HRESULT,
    fn get_Encoding(&self, out: *mut SmsEncoding) -> HRESULT,
    fn put_Encoding(&self, value: SmsEncoding) -> HRESULT,
    fn ToBinaryMessages(&self, format: SmsDataFormat, out: *mut *mut super::super::foundation::collections::IVectorView<ISmsBinaryMessage>) -> HRESULT
}}
impl ISmsTextMessage {
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_part_reference_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PartReferenceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_part_number(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PartNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_part_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PartCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_to(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_To)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_from(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_From)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_body(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Body)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding(&self) -> Result<SmsEncoding> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Encoding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_encoding(&self, value: SmsEncoding) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Encoding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn to_binary_messages(&self, format: SmsDataFormat) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ISmsBinaryMessage>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ToBinaryMessages)(self as *const _ as *mut _, format, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsTextMessage: ISmsTextMessage}
impl RtActivatable<ISmsTextMessageStatics> for SmsTextMessage {}
impl RtActivatable<IActivationFactory> for SmsTextMessage {}
impl SmsTextMessage {
    #[inline] pub fn from_binary_message(binaryMessage: &SmsBinaryMessage) -> Result<ComPtr<SmsTextMessage>> { unsafe {
        <Self as RtActivatable<ISmsTextMessageStatics>>::get_activation_factory().from_binary_message(binaryMessage)
    }}
    #[inline] pub fn from_binary_data(format: SmsDataFormat, value: &[u8]) -> Result<ComPtr<SmsTextMessage>> { unsafe {
        <Self as RtActivatable<ISmsTextMessageStatics>>::get_activation_factory().from_binary_data(format, value)
    }}
}
DEFINE_CLSID!(SmsTextMessage(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,84,101,120,116,77,101,115,115,97,103,101,0]) [CLSID_SmsTextMessage]);
DEFINE_IID!(IID_ISmsTextMessage2, 580966547, 17749, 18261, 181, 161, 231, 253, 132, 149, 95, 141);
RT_INTERFACE!{interface ISmsTextMessage2(ISmsTextMessage2Vtbl): IInspectable(IInspectableVtbl) [IID_ISmsTextMessage2] {
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn put_To(&self, value: HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Body(&self, value: HSTRING) -> HRESULT,
    fn get_Encoding(&self, out: *mut SmsEncoding) -> HRESULT,
    fn put_Encoding(&self, value: SmsEncoding) -> HRESULT,
    fn get_CallbackNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CallbackNumber(&self, value: HSTRING) -> HRESULT,
    fn get_IsDeliveryNotificationEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsDeliveryNotificationEnabled(&self, value: bool) -> HRESULT,
    fn get_RetryAttemptCount(&self, out: *mut i32) -> HRESULT,
    fn put_RetryAttemptCount(&self, value: i32) -> HRESULT,
    fn get_TeleserviceId(&self, out: *mut i32) -> HRESULT,
    fn get_ProtocolId(&self, out: *mut i32) -> HRESULT
}}
impl ISmsTextMessage2 {
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_to(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_To)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_body(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Body)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding(&self) -> Result<SmsEncoding> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Encoding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_encoding(&self, value: SmsEncoding) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Encoding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_callback_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CallbackNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_callback_number(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CallbackNumber)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_delivery_notification_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDeliveryNotificationEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_delivery_notification_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDeliveryNotificationEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_retry_attempt_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RetryAttemptCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_retry_attempt_count(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RetryAttemptCount)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_teleservice_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TeleserviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtocolId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SmsTextMessage2: ISmsTextMessage2}
impl RtActivatable<IActivationFactory> for SmsTextMessage2 {}
DEFINE_CLSID!(SmsTextMessage2(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,83,109,115,46,83,109,115,84,101,120,116,77,101,115,115,97,103,101,50,0]) [CLSID_SmsTextMessage2]);
DEFINE_IID!(IID_ISmsTextMessageStatics, 2137572845, 15564, 18339, 140, 85, 56, 13, 59, 1, 8, 146);
RT_INTERFACE!{static interface ISmsTextMessageStatics(ISmsTextMessageStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISmsTextMessageStatics] {
    fn FromBinaryMessage(&self, binaryMessage: *mut SmsBinaryMessage, out: *mut *mut SmsTextMessage) -> HRESULT,
    fn FromBinaryData(&self, format: SmsDataFormat, valueSize: u32, value: *mut u8, out: *mut *mut SmsTextMessage) -> HRESULT
}}
impl ISmsTextMessageStatics {
    #[inline] pub unsafe fn from_binary_message(&self, binaryMessage: &SmsBinaryMessage) -> Result<ComPtr<SmsTextMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromBinaryMessage)(self as *const _ as *mut _, binaryMessage as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_binary_data(&self, format: SmsDataFormat, value: &[u8]) -> Result<ComPtr<SmsTextMessage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromBinaryData)(self as *const _ as *mut _, format, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISmsVoicemailMessage, 656056486, 38321, 17663, 188, 184, 184, 253, 215, 224, 139, 195);
RT_INTERFACE!{interface ISmsVoicemailMessage(ISmsVoicemailMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsVoicemailMessage] {
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn get_MessageCount(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT
}}
impl ISmsVoicemailMessage {
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_count(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MessageCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsVoicemailMessage: ISmsVoicemailMessage}
DEFINE_IID!(IID_ISmsWapMessage, 3448993603, 31317, 19771, 144, 33, 242, 46, 2, 45, 9, 197);
RT_INTERFACE!{interface ISmsWapMessage(ISmsWapMessageVtbl): IInspectable(IInspectableVtbl) [IID_ISmsWapMessage] {
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ApplicationId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ContentType(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_BinaryBody(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_Headers(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT
}}
impl ISmsWapMessage {
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_application_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ApplicationId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_type(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_binary_body(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BinaryBody)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_headers(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Headers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SmsWapMessage: ISmsWapMessage}
} // Windows.Devices.Sms
pub mod alljoyn { // Windows.Devices.AllJoyn
use ::prelude::*;
DEFINE_IID!(IID_IAllJoynAboutData, 3853106944, 8098, 18489, 147, 239, 249, 223, 64, 72, 144, 247);
RT_INTERFACE!{interface IAllJoynAboutData(IAllJoynAboutDataVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAboutData] {
    fn get_IsEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsEnabled(&self, value: bool) -> HRESULT,
    fn get_DefaultAppName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DefaultAppName(&self, value: HSTRING) -> HRESULT,
    fn get_AppNames(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT,
    fn get_DateOfManufacture(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_DateOfManufacture(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_DefaultDescription(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DefaultDescription(&self, value: HSTRING) -> HRESULT,
    fn get_Descriptions(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT,
    fn get_DefaultManufacturer(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DefaultManufacturer(&self, value: HSTRING) -> HRESULT,
    fn get_Manufacturers(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT,
    fn get_ModelNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ModelNumber(&self, value: HSTRING) -> HRESULT,
    fn get_SoftwareVersion(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SoftwareVersion(&self, value: HSTRING) -> HRESULT,
    fn get_SupportUrl(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_SupportUrl(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_AppId(&self, out: *mut Guid) -> HRESULT,
    fn put_AppId(&self, value: Guid) -> HRESULT
}}
impl IAllJoynAboutData {
    #[inline] pub unsafe fn get_is_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_app_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultAppName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_app_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultAppName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_names(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppNames)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_of_manufacture(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateOfManufacture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_date_of_manufacture(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DateOfManufacture)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultDescription)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_descriptions(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Descriptions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_manufacturer(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultManufacturer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_manufacturer(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultManufacturer)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manufacturers(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Manufacturers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_model_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ModelNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_model_number(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ModelNumber)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_software_version(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SoftwareVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_software_version(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SoftwareVersion)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_support_url(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportUrl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_support_url(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SupportUrl)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AppId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_app_id(&self, value: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppId)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynAboutData: IAllJoynAboutData}
DEFINE_IID!(IID_IAllJoynAboutDataView, 1747128607, 25106, 18740, 156, 72, 225, 156, 164, 152, 66, 136);
RT_INTERFACE!{interface IAllJoynAboutDataView(IAllJoynAboutDataViewVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAboutDataView] {
    fn get_Status(&self, out: *mut i32) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT,
    fn get_AJSoftwareVersion(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppId(&self, out: *mut Guid) -> HRESULT,
    fn get_DateOfManufacture(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-globalization")] fn get_DefaultLanguage(&self, out: *mut *mut super::super::globalization::Language) -> HRESULT,
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_HardwareVersion(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ModelNumber(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SoftwareVersion(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-globalization")] fn get_SupportedLanguages(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::globalization::Language>) -> HRESULT,
    fn get_SupportUrl(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn get_AppName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DeviceName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Manufacturer(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAllJoynAboutDataView {
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ajsoftware_version(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AJSoftwareVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AppId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_of_manufacture(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateOfManufacture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_default_language(&self) -> Result<ComPtr<super::super::globalization::Language>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultLanguage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hardware_version(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HardwareVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_model_number(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ModelNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_software_version(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SoftwareVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_supported_languages(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::globalization::Language>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedLanguages)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_support_url(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportUrl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manufacturer(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Manufacturer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynAboutDataView: IAllJoynAboutDataView}
impl RtActivatable<IAllJoynAboutDataViewStatics> for AllJoynAboutDataView {}
impl AllJoynAboutDataView {
    #[inline] pub fn get_data_by_session_port_async(uniqueName: &HStringArg, busAttachment: &AllJoynBusAttachment, sessionPort: u16) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynAboutDataView>>> { unsafe {
        <Self as RtActivatable<IAllJoynAboutDataViewStatics>>::get_activation_factory().get_data_by_session_port_async(uniqueName, busAttachment, sessionPort)
    }}
    #[cfg(feature="windows-globalization")] #[inline] pub fn get_data_by_session_port_with_language_async(uniqueName: &HStringArg, busAttachment: &AllJoynBusAttachment, sessionPort: u16, language: &super::super::globalization::Language) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynAboutDataView>>> { unsafe {
        <Self as RtActivatable<IAllJoynAboutDataViewStatics>>::get_activation_factory().get_data_by_session_port_with_language_async(uniqueName, busAttachment, sessionPort, language)
    }}
}
DEFINE_CLSID!(AllJoynAboutDataView(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,65,98,111,117,116,68,97,116,97,86,105,101,119,0]) [CLSID_AllJoynAboutDataView]);
DEFINE_IID!(IID_IAllJoynAboutDataViewStatics, 1475196552, 3166, 16750, 136, 181, 57, 179, 45, 37, 196, 125);
RT_INTERFACE!{static interface IAllJoynAboutDataViewStatics(IAllJoynAboutDataViewStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAboutDataViewStatics] {
    fn GetDataBySessionPortAsync(&self, uniqueName: HSTRING, busAttachment: *mut AllJoynBusAttachment, sessionPort: u16, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynAboutDataView>) -> HRESULT,
    #[cfg(feature="windows-globalization")] fn GetDataBySessionPortWithLanguageAsync(&self, uniqueName: HSTRING, busAttachment: *mut AllJoynBusAttachment, sessionPort: u16, language: *mut super::super::globalization::Language, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynAboutDataView>) -> HRESULT
}}
impl IAllJoynAboutDataViewStatics {
    #[inline] pub unsafe fn get_data_by_session_port_async(&self, uniqueName: &HStringArg, busAttachment: &AllJoynBusAttachment, sessionPort: u16) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynAboutDataView>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDataBySessionPortAsync)(self as *const _ as *mut _, uniqueName.get(), busAttachment as *const _ as *mut _, sessionPort, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_data_by_session_port_with_language_async(&self, uniqueName: &HStringArg, busAttachment: &AllJoynBusAttachment, sessionPort: u16, language: &super::super::globalization::Language) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynAboutDataView>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDataBySessionPortWithLanguageAsync)(self as *const _ as *mut _, uniqueName.get(), busAttachment as *const _ as *mut _, sessionPort, language as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynAcceptSessionJoiner, 1302861778, 52509, 16419, 167, 196, 22, 222, 248, 156, 40, 223);
RT_INTERFACE!{interface IAllJoynAcceptSessionJoiner(IAllJoynAcceptSessionJoinerVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAcceptSessionJoiner] {
    fn Accept(&self) -> HRESULT
}}
impl IAllJoynAcceptSessionJoiner {
    #[inline] pub unsafe fn accept(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Accept)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynAcceptSessionJoinerEventArgs, 1325093733, 16010, 16983, 143, 16, 83, 156, 224, 213, 108, 15);
RT_INTERFACE!{interface IAllJoynAcceptSessionJoinerEventArgs(IAllJoynAcceptSessionJoinerEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAcceptSessionJoinerEventArgs] {
    fn get_UniqueName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SessionPort(&self, out: *mut u16) -> HRESULT,
    fn get_TrafficType(&self, out: *mut AllJoynTrafficType) -> HRESULT,
    fn get_SamePhysicalNode(&self, out: *mut bool) -> HRESULT,
    fn get_SameNetwork(&self, out: *mut bool) -> HRESULT,
    fn Accept(&self) -> HRESULT
}}
impl IAllJoynAcceptSessionJoinerEventArgs {
    #[inline] pub unsafe fn get_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_session_port(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SessionPort)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_traffic_type(&self) -> Result<AllJoynTrafficType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TrafficType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_same_physical_node(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SamePhysicalNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_same_network(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SameNetwork)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Accept)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynAcceptSessionJoinerEventArgs: IAllJoynAcceptSessionJoinerEventArgs}
impl RtActivatable<IAllJoynAcceptSessionJoinerEventArgsFactory> for AllJoynAcceptSessionJoinerEventArgs {}
impl AllJoynAcceptSessionJoinerEventArgs {
    #[inline] pub fn create(uniqueName: &HStringArg, sessionPort: u16, trafficType: AllJoynTrafficType, proximity: u8, acceptSessionJoiner: &IAllJoynAcceptSessionJoiner) -> Result<ComPtr<AllJoynAcceptSessionJoinerEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynAcceptSessionJoinerEventArgsFactory>>::get_activation_factory().create(uniqueName, sessionPort, trafficType, proximity, acceptSessionJoiner)
    }}
}
DEFINE_CLSID!(AllJoynAcceptSessionJoinerEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,65,99,99,101,112,116,83,101,115,115,105,111,110,74,111,105,110,101,114,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynAcceptSessionJoinerEventArgs]);
DEFINE_IID!(IID_IAllJoynAcceptSessionJoinerEventArgsFactory, 3024313280, 24901, 17054, 132, 219, 213, 191, 231, 114, 177, 79);
RT_INTERFACE!{static interface IAllJoynAcceptSessionJoinerEventArgsFactory(IAllJoynAcceptSessionJoinerEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAcceptSessionJoinerEventArgsFactory] {
    fn Create(&self, uniqueName: HSTRING, sessionPort: u16, trafficType: AllJoynTrafficType, proximity: u8, acceptSessionJoiner: *mut IAllJoynAcceptSessionJoiner, out: *mut *mut AllJoynAcceptSessionJoinerEventArgs) -> HRESULT
}}
impl IAllJoynAcceptSessionJoinerEventArgsFactory {
    #[inline] pub unsafe fn create(&self, uniqueName: &HStringArg, sessionPort: u16, trafficType: AllJoynTrafficType, proximity: u8, acceptSessionJoiner: &IAllJoynAcceptSessionJoiner) -> Result<ComPtr<AllJoynAcceptSessionJoinerEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, uniqueName.get(), sessionPort, trafficType, proximity, acceptSessionJoiner as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynAuthenticationCompleteEventArgs, 2545184796, 5596, 19283, 182, 164, 125, 19, 67, 0, 215, 191);
RT_INTERFACE!{interface IAllJoynAuthenticationCompleteEventArgs(IAllJoynAuthenticationCompleteEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynAuthenticationCompleteEventArgs] {
    fn get_AuthenticationMechanism(&self, out: *mut AllJoynAuthenticationMechanism) -> HRESULT,
    fn get_PeerUniqueName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Succeeded(&self, out: *mut bool) -> HRESULT
}}
impl IAllJoynAuthenticationCompleteEventArgs {
    #[inline] pub unsafe fn get_authentication_mechanism(&self) -> Result<AllJoynAuthenticationMechanism> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AuthenticationMechanism)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_peer_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PeerUniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_succeeded(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Succeeded)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynAuthenticationCompleteEventArgs: IAllJoynAuthenticationCompleteEventArgs}
RT_ENUM! { enum AllJoynAuthenticationMechanism: i32 {
    None (AllJoynAuthenticationMechanism_None) = 0, SrpAnonymous (AllJoynAuthenticationMechanism_SrpAnonymous) = 1, SrpLogon (AllJoynAuthenticationMechanism_SrpLogon) = 2, EcdheNull (AllJoynAuthenticationMechanism_EcdheNull) = 3, EcdhePsk (AllJoynAuthenticationMechanism_EcdhePsk) = 4, EcdheEcdsa (AllJoynAuthenticationMechanism_EcdheEcdsa) = 5, EcdheSpeke (AllJoynAuthenticationMechanism_EcdheSpeke) = 6,
}}
DEFINE_IID!(IID_IAllJoynBusAttachment, 4077515091, 7917, 17091, 162, 14, 67, 109, 65, 254, 98, 246);
RT_INTERFACE!{interface IAllJoynBusAttachment(IAllJoynBusAttachmentVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusAttachment] {
    fn get_AboutData(&self, out: *mut *mut AllJoynAboutData) -> HRESULT,
    fn get_ConnectionSpecification(&self, out: *mut HSTRING) -> HRESULT,
    fn get_State(&self, out: *mut AllJoynBusAttachmentState) -> HRESULT,
    fn get_UniqueName(&self, out: *mut HSTRING) -> HRESULT,
    fn PingAsync(&self, uniqueName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<i32>) -> HRESULT,
    fn Connect(&self) -> HRESULT,
    fn Disconnect(&self) -> HRESULT,
    fn add_StateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynBusAttachmentStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_AuthenticationMechanisms(&self, out: *mut *mut super::super::foundation::collections::IVector<AllJoynAuthenticationMechanism>) -> HRESULT,
    fn add_CredentialsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynCredentialsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CredentialsRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CredentialsVerificationRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynCredentialsVerificationRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CredentialsVerificationRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AuthenticationComplete(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynAuthenticationCompleteEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AuthenticationComplete(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAllJoynBusAttachment {
    #[inline] pub unsafe fn get_about_data(&self) -> Result<ComPtr<AllJoynAboutData>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AboutData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_specification(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionSpecification)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<AllJoynBusAttachmentState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn ping_async(&self, uniqueName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PingAsync)(self as *const _ as *mut _, uniqueName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn connect(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Connect)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn disconnect(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Disconnect)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynBusAttachmentStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_authentication_mechanisms(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<AllJoynAuthenticationMechanism>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AuthenticationMechanisms)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_credentials_requested(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynCredentialsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CredentialsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_credentials_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CredentialsRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_credentials_verification_requested(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynCredentialsVerificationRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CredentialsVerificationRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_credentials_verification_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CredentialsVerificationRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_authentication_complete(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynAuthenticationCompleteEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AuthenticationComplete)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_authentication_complete(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AuthenticationComplete)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynBusAttachment: IAllJoynBusAttachment}
impl RtActivatable<IAllJoynBusAttachmentFactory> for AllJoynBusAttachment {}
impl RtActivatable<IAllJoynBusAttachmentStatics> for AllJoynBusAttachment {}
impl RtActivatable<IActivationFactory> for AllJoynBusAttachment {}
impl AllJoynBusAttachment {
    #[inline] pub fn create(connectionSpecification: &HStringArg) -> Result<ComPtr<AllJoynBusAttachment>> { unsafe {
        <Self as RtActivatable<IAllJoynBusAttachmentFactory>>::get_activation_factory().create(connectionSpecification)
    }}
    #[inline] pub fn get_default() -> Result<ComPtr<AllJoynBusAttachment>> { unsafe {
        <Self as RtActivatable<IAllJoynBusAttachmentStatics>>::get_activation_factory().get_default()
    }}
    #[inline] pub fn get_watcher(requiredInterfaces: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::enumeration::DeviceWatcher>> { unsafe {
        <Self as RtActivatable<IAllJoynBusAttachmentStatics>>::get_activation_factory().get_watcher(requiredInterfaces)
    }}
}
DEFINE_CLSID!(AllJoynBusAttachment(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,66,117,115,65,116,116,97,99,104,109,101,110,116,0]) [CLSID_AllJoynBusAttachment]);
DEFINE_IID!(IID_IAllJoynBusAttachment2, 880069406, 9064, 17330, 180, 62, 106, 58, 193, 39, 141, 152);
RT_INTERFACE!{interface IAllJoynBusAttachment2(IAllJoynBusAttachment2Vtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusAttachment2] {
    fn GetAboutDataAsync(&self, serviceInfo: *mut AllJoynServiceInfo, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynAboutDataView>) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-globalization")] fn GetAboutDataWithLanguageAsync(&self, serviceInfo: *mut AllJoynServiceInfo, language: *mut super::super::globalization::Language, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynAboutDataView>) -> HRESULT,
    fn add_AcceptSessionJoinerRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynAcceptSessionJoinerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AcceptSessionJoinerRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SessionJoined(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynSessionJoinedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SessionJoined(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAllJoynBusAttachment2 {
    #[inline] pub unsafe fn get_about_data_async(&self, serviceInfo: &AllJoynServiceInfo) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynAboutDataView>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAboutDataAsync)(self as *const _ as *mut _, serviceInfo as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_about_data_with_language_async(&self, serviceInfo: &AllJoynServiceInfo, language: &super::super::globalization::Language) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynAboutDataView>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAboutDataWithLanguageAsync)(self as *const _ as *mut _, serviceInfo as *const _ as *mut _, language as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_accept_session_joiner_requested(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynAcceptSessionJoinerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AcceptSessionJoinerRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_accept_session_joiner_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AcceptSessionJoinerRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_session_joined(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusAttachment, AllJoynSessionJoinedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SessionJoined)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_session_joined(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SessionJoined)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynBusAttachmentFactory, 1680798116, 44421, 19935, 144, 174, 96, 68, 82, 178, 34, 136);
RT_INTERFACE!{static interface IAllJoynBusAttachmentFactory(IAllJoynBusAttachmentFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusAttachmentFactory] {
    fn Create(&self, connectionSpecification: HSTRING, out: *mut *mut AllJoynBusAttachment) -> HRESULT
}}
impl IAllJoynBusAttachmentFactory {
    #[inline] pub unsafe fn create(&self, connectionSpecification: &HStringArg) -> Result<ComPtr<AllJoynBusAttachment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, connectionSpecification.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AllJoynBusAttachmentState: i32 {
    Disconnected (AllJoynBusAttachmentState_Disconnected) = 0, Connecting (AllJoynBusAttachmentState_Connecting) = 1, Connected (AllJoynBusAttachmentState_Connected) = 2, Disconnecting (AllJoynBusAttachmentState_Disconnecting) = 3,
}}
DEFINE_IID!(IID_IAllJoynBusAttachmentStateChangedEventArgs, 3626923508, 49194, 16876, 168, 213, 234, 177, 85, 137, 83, 170);
RT_INTERFACE!{interface IAllJoynBusAttachmentStateChangedEventArgs(IAllJoynBusAttachmentStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusAttachmentStateChangedEventArgs] {
    fn get_State(&self, out: *mut AllJoynBusAttachmentState) -> HRESULT,
    fn get_Status(&self, out: *mut i32) -> HRESULT
}}
impl IAllJoynBusAttachmentStateChangedEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<AllJoynBusAttachmentState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynBusAttachmentStateChangedEventArgs: IAllJoynBusAttachmentStateChangedEventArgs}
DEFINE_IID!(IID_IAllJoynBusAttachmentStatics, 2208124221, 4177, 16599, 135, 42, 141, 1, 65, 17, 91, 31);
RT_INTERFACE!{static interface IAllJoynBusAttachmentStatics(IAllJoynBusAttachmentStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusAttachmentStatics] {
    fn GetDefault(&self, out: *mut *mut AllJoynBusAttachment) -> HRESULT,
    fn GetWatcher(&self, requiredInterfaces: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::enumeration::DeviceWatcher) -> HRESULT
}}
impl IAllJoynBusAttachmentStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<AllJoynBusAttachment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_watcher(&self, requiredInterfaces: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::enumeration::DeviceWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetWatcher)(self as *const _ as *mut _, requiredInterfaces as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynBusObject, 3908928094, 63290, 18700, 136, 4, 4, 224, 38, 100, 48, 71);
RT_INTERFACE!{interface IAllJoynBusObject(IAllJoynBusObjectVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusObject] {
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn AddProducer(&self, producer: *mut IAllJoynProducer) -> HRESULT,
    fn get_BusAttachment(&self, out: *mut *mut AllJoynBusAttachment) -> HRESULT,
    fn get_Session(&self, out: *mut *mut AllJoynSession) -> HRESULT,
    fn add_Stopped(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynBusObject, AllJoynBusObjectStoppedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Stopped(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAllJoynBusObject {
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_producer(&self, producer: &IAllJoynProducer) -> Result<()> {
        let hr = ((*self.lpVtbl).AddProducer)(self as *const _ as *mut _, producer as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bus_attachment(&self) -> Result<ComPtr<AllJoynBusAttachment>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BusAttachment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_session(&self) -> Result<ComPtr<AllJoynSession>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Session)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stopped(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynBusObject, AllJoynBusObjectStoppedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Stopped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stopped(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Stopped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynBusObject: IAllJoynBusObject}
impl RtActivatable<IAllJoynBusObjectFactory> for AllJoynBusObject {}
impl RtActivatable<IActivationFactory> for AllJoynBusObject {}
impl AllJoynBusObject {
    #[inline] pub fn create(objectPath: &HStringArg) -> Result<ComPtr<AllJoynBusObject>> { unsafe {
        <Self as RtActivatable<IAllJoynBusObjectFactory>>::get_activation_factory().create(objectPath)
    }}
    #[inline] pub fn create_with_bus_attachment(objectPath: &HStringArg, busAttachment: &AllJoynBusAttachment) -> Result<ComPtr<AllJoynBusObject>> { unsafe {
        <Self as RtActivatable<IAllJoynBusObjectFactory>>::get_activation_factory().create_with_bus_attachment(objectPath, busAttachment)
    }}
}
DEFINE_CLSID!(AllJoynBusObject(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,66,117,115,79,98,106,101,99,116,0]) [CLSID_AllJoynBusObject]);
DEFINE_IID!(IID_IAllJoynBusObjectFactory, 741318411, 36354, 20380, 172, 39, 234, 109, 173, 93, 59, 80);
RT_INTERFACE!{static interface IAllJoynBusObjectFactory(IAllJoynBusObjectFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusObjectFactory] {
    fn Create(&self, objectPath: HSTRING, out: *mut *mut AllJoynBusObject) -> HRESULT,
    fn CreateWithBusAttachment(&self, objectPath: HSTRING, busAttachment: *mut AllJoynBusAttachment, out: *mut *mut AllJoynBusObject) -> HRESULT
}}
impl IAllJoynBusObjectFactory {
    #[inline] pub unsafe fn create(&self, objectPath: &HStringArg) -> Result<ComPtr<AllJoynBusObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, objectPath.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_bus_attachment(&self, objectPath: &HStringArg, busAttachment: &AllJoynBusAttachment) -> Result<ComPtr<AllJoynBusObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithBusAttachment)(self as *const _ as *mut _, objectPath.get(), busAttachment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynBusObjectStoppedEventArgs, 3725598997, 61326, 19778, 185, 59, 162, 174, 116, 81, 151, 102);
RT_INTERFACE!{interface IAllJoynBusObjectStoppedEventArgs(IAllJoynBusObjectStoppedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusObjectStoppedEventArgs] {
    fn get_Status(&self, out: *mut i32) -> HRESULT
}}
impl IAllJoynBusObjectStoppedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynBusObjectStoppedEventArgs: IAllJoynBusObjectStoppedEventArgs}
impl RtActivatable<IAllJoynBusObjectStoppedEventArgsFactory> for AllJoynBusObjectStoppedEventArgs {}
impl AllJoynBusObjectStoppedEventArgs {
    #[inline] pub fn create(status: i32) -> Result<ComPtr<AllJoynBusObjectStoppedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynBusObjectStoppedEventArgsFactory>>::get_activation_factory().create(status)
    }}
}
DEFINE_CLSID!(AllJoynBusObjectStoppedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,66,117,115,79,98,106,101,99,116,83,116,111,112,112,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynBusObjectStoppedEventArgs]);
DEFINE_IID!(IID_IAllJoynBusObjectStoppedEventArgsFactory, 1797455176, 53411, 16981, 149, 58, 71, 114, 180, 2, 128, 115);
RT_INTERFACE!{static interface IAllJoynBusObjectStoppedEventArgsFactory(IAllJoynBusObjectStoppedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynBusObjectStoppedEventArgsFactory] {
    fn Create(&self, status: i32, out: *mut *mut AllJoynBusObjectStoppedEventArgs) -> HRESULT
}}
impl IAllJoynBusObjectStoppedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, status: i32) -> Result<ComPtr<AllJoynBusObjectStoppedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, status, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynCredentials, 2185646322, 41360, 16561, 171, 171, 52, 158, 194, 68, 223, 170);
RT_INTERFACE!{interface IAllJoynCredentials(IAllJoynCredentialsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynCredentials] {
    fn get_AuthenticationMechanism(&self, out: *mut AllJoynAuthenticationMechanism) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-security")] fn get_Certificate(&self, out: *mut *mut super::super::security::cryptography::certificates::Certificate) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-security")] fn put_Certificate(&self, value: *mut super::super::security::cryptography::certificates::Certificate) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-security")] fn get_PasswordCredential(&self, out: *mut *mut super::super::security::credentials::PasswordCredential) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-security")] fn put_PasswordCredential(&self, value: *mut super::super::security::credentials::PasswordCredential) -> HRESULT,
    fn get_Timeout(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_Timeout(&self, value: super::super::foundation::TimeSpan) -> HRESULT
}}
impl IAllJoynCredentials {
    #[inline] pub unsafe fn get_authentication_mechanism(&self) -> Result<AllJoynAuthenticationMechanism> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AuthenticationMechanism)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_certificate(&self) -> Result<ComPtr<super::super::security::cryptography::certificates::Certificate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Certificate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn set_certificate(&self, value: &super::super::security::cryptography::certificates::Certificate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Certificate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_password_credential(&self) -> Result<ComPtr<super::super::security::credentials::PasswordCredential>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PasswordCredential)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn set_password_credential(&self, value: &super::super::security::credentials::PasswordCredential) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PasswordCredential)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timeout(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_timeout(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Timeout)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynCredentials: IAllJoynCredentials}
DEFINE_IID!(IID_IAllJoynCredentialsRequestedEventArgs, 1787290446, 45161, 19328, 158, 26, 65, 188, 131, 124, 101, 210);
RT_INTERFACE!{interface IAllJoynCredentialsRequestedEventArgs(IAllJoynCredentialsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynCredentialsRequestedEventArgs] {
    fn get_AttemptCount(&self, out: *mut u16) -> HRESULT,
    fn get_Credentials(&self, out: *mut *mut AllJoynCredentials) -> HRESULT,
    fn get_PeerUniqueName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RequestedUserName(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl IAllJoynCredentialsRequestedEventArgs {
    #[inline] pub unsafe fn get_attempt_count(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttemptCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_credentials(&self) -> Result<ComPtr<AllJoynCredentials>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Credentials)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_peer_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PeerUniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_requested_user_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RequestedUserName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynCredentialsRequestedEventArgs: IAllJoynCredentialsRequestedEventArgs}
DEFINE_IID!(IID_IAllJoynCredentialsVerificationRequestedEventArgs, 2148169234, 47109, 17583, 162, 225, 121, 42, 182, 85, 162, 208);
RT_INTERFACE!{interface IAllJoynCredentialsVerificationRequestedEventArgs(IAllJoynCredentialsVerificationRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynCredentialsVerificationRequestedEventArgs] {
    fn get_AuthenticationMechanism(&self, out: *mut AllJoynAuthenticationMechanism) -> HRESULT,
    fn get_PeerUniqueName(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-security")] fn get_PeerCertificate(&self, out: *mut *mut super::super::security::cryptography::certificates::Certificate) -> HRESULT,
    #[cfg(not(feature="windows-networking"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-networking")] fn get_PeerCertificateErrorSeverity(&self, out: *mut super::super::networking::sockets::SocketSslErrorSeverity) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-security")] fn get_PeerCertificateErrors(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::security::cryptography::certificates::ChainValidationResult>) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-security")] fn get_PeerIntermediateCertificates(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::security::cryptography::certificates::Certificate>) -> HRESULT,
    fn Accept(&self) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl IAllJoynCredentialsVerificationRequestedEventArgs {
    #[inline] pub unsafe fn get_authentication_mechanism(&self) -> Result<AllJoynAuthenticationMechanism> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AuthenticationMechanism)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_peer_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PeerUniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_peer_certificate(&self) -> Result<ComPtr<super::super::security::cryptography::certificates::Certificate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PeerCertificate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_peer_certificate_error_severity(&self) -> Result<super::super::networking::sockets::SocketSslErrorSeverity> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PeerCertificateErrorSeverity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_peer_certificate_errors(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::security::cryptography::certificates::ChainValidationResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PeerCertificateErrors)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_peer_intermediate_certificates(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::security::cryptography::certificates::Certificate>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PeerIntermediateCertificates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Accept)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynCredentialsVerificationRequestedEventArgs: IAllJoynCredentialsVerificationRequestedEventArgs}
DEFINE_IID!(IID_IAllJoynMessageInfo, 4281008423, 11282, 18521, 170, 58, 199, 68, 97, 238, 129, 76);
RT_INTERFACE!{interface IAllJoynMessageInfo(IAllJoynMessageInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynMessageInfo] {
    fn get_SenderUniqueName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAllJoynMessageInfo {
    #[inline] pub unsafe fn get_sender_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SenderUniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynMessageInfo: IAllJoynMessageInfo}
impl RtActivatable<IAllJoynMessageInfoFactory> for AllJoynMessageInfo {}
impl AllJoynMessageInfo {
    #[inline] pub fn create(senderUniqueName: &HStringArg) -> Result<ComPtr<AllJoynMessageInfo>> { unsafe {
        <Self as RtActivatable<IAllJoynMessageInfoFactory>>::get_activation_factory().create(senderUniqueName)
    }}
}
DEFINE_CLSID!(AllJoynMessageInfo(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,77,101,115,115,97,103,101,73,110,102,111,0]) [CLSID_AllJoynMessageInfo]);
DEFINE_IID!(IID_IAllJoynMessageInfoFactory, 879119402, 33417, 17364, 180, 168, 63, 77, 227, 89, 240, 67);
RT_INTERFACE!{static interface IAllJoynMessageInfoFactory(IAllJoynMessageInfoFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynMessageInfoFactory] {
    fn Create(&self, senderUniqueName: HSTRING, out: *mut *mut AllJoynMessageInfo) -> HRESULT
}}
impl IAllJoynMessageInfoFactory {
    #[inline] pub unsafe fn create(&self, senderUniqueName: &HStringArg) -> Result<ComPtr<AllJoynMessageInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, senderUniqueName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynProducer, 2634565241, 18075, 18778, 167, 16, 172, 80, 241, 35, 6, 159);
RT_INTERFACE!{interface IAllJoynProducer(IAllJoynProducerVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynProducer] {
    fn SetBusObject(&self, busObject: *mut AllJoynBusObject) -> HRESULT
}}
impl IAllJoynProducer {
    #[inline] pub unsafe fn set_bus_object(&self, busObject: &AllJoynBusObject) -> Result<()> {
        let hr = ((*self.lpVtbl).SetBusObject)(self as *const _ as *mut _, busObject as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynProducerStoppedEventArgs, 1362138992, 18743, 18733, 128, 128, 35, 100, 57, 152, 124, 235);
RT_INTERFACE!{interface IAllJoynProducerStoppedEventArgs(IAllJoynProducerStoppedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynProducerStoppedEventArgs] {
    fn get_Status(&self, out: *mut i32) -> HRESULT
}}
impl IAllJoynProducerStoppedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynProducerStoppedEventArgs: IAllJoynProducerStoppedEventArgs}
impl RtActivatable<IAllJoynProducerStoppedEventArgsFactory> for AllJoynProducerStoppedEventArgs {}
impl AllJoynProducerStoppedEventArgs {
    #[inline] pub fn create(status: i32) -> Result<ComPtr<AllJoynProducerStoppedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynProducerStoppedEventArgsFactory>>::get_activation_factory().create(status)
    }}
}
DEFINE_CLSID!(AllJoynProducerStoppedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,80,114,111,100,117,99,101,114,83,116,111,112,112,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynProducerStoppedEventArgs]);
DEFINE_IID!(IID_IAllJoynProducerStoppedEventArgsFactory, 1448253793, 45593, 19822, 159, 120, 250, 63, 153, 250, 143, 229);
RT_INTERFACE!{static interface IAllJoynProducerStoppedEventArgsFactory(IAllJoynProducerStoppedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynProducerStoppedEventArgsFactory] {
    fn Create(&self, status: i32, out: *mut *mut AllJoynProducerStoppedEventArgs) -> HRESULT
}}
impl IAllJoynProducerStoppedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, status: i32) -> Result<ComPtr<AllJoynProducerStoppedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, status, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynServiceInfo, 1287553545, 47422, 16770, 153, 155, 221, 208, 0, 249, 197, 117);
RT_INTERFACE!{interface IAllJoynServiceInfo(IAllJoynServiceInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynServiceInfo] {
    fn get_UniqueName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ObjectPath(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SessionPort(&self, out: *mut u16) -> HRESULT
}}
impl IAllJoynServiceInfo {
    #[inline] pub unsafe fn get_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_object_path(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ObjectPath)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_session_port(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SessionPort)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynServiceInfo: IAllJoynServiceInfo}
impl RtActivatable<IAllJoynServiceInfoFactory> for AllJoynServiceInfo {}
impl RtActivatable<IAllJoynServiceInfoStatics> for AllJoynServiceInfo {}
impl AllJoynServiceInfo {
    #[inline] pub fn create(uniqueName: &HStringArg, objectPath: &HStringArg, sessionPort: u16) -> Result<ComPtr<AllJoynServiceInfo>> { unsafe {
        <Self as RtActivatable<IAllJoynServiceInfoFactory>>::get_activation_factory().create(uniqueName, objectPath, sessionPort)
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynServiceInfo>>> { unsafe {
        <Self as RtActivatable<IAllJoynServiceInfoStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
}
DEFINE_CLSID!(AllJoynServiceInfo(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,114,118,105,99,101,73,110,102,111,0]) [CLSID_AllJoynServiceInfo]);
DEFINE_IID!(IID_IAllJoynServiceInfoFactory, 1971444413, 65027, 20299, 148, 164, 240, 47, 220, 189, 17, 184);
RT_INTERFACE!{static interface IAllJoynServiceInfoFactory(IAllJoynServiceInfoFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynServiceInfoFactory] {
    fn Create(&self, uniqueName: HSTRING, objectPath: HSTRING, sessionPort: u16, out: *mut *mut AllJoynServiceInfo) -> HRESULT
}}
impl IAllJoynServiceInfoFactory {
    #[inline] pub unsafe fn create(&self, uniqueName: &HStringArg, objectPath: &HStringArg, sessionPort: u16) -> Result<ComPtr<AllJoynServiceInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, uniqueName.get(), objectPath.get(), sessionPort, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynServiceInfoRemovedEventArgs, 811051359, 7487, 16883, 137, 105, 227, 39, 146, 98, 115, 150);
RT_INTERFACE!{interface IAllJoynServiceInfoRemovedEventArgs(IAllJoynServiceInfoRemovedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynServiceInfoRemovedEventArgs] {
    fn get_UniqueName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAllJoynServiceInfoRemovedEventArgs {
    #[inline] pub unsafe fn get_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynServiceInfoRemovedEventArgs: IAllJoynServiceInfoRemovedEventArgs}
impl RtActivatable<IAllJoynServiceInfoRemovedEventArgsFactory> for AllJoynServiceInfoRemovedEventArgs {}
impl AllJoynServiceInfoRemovedEventArgs {
    #[inline] pub fn create(uniqueName: &HStringArg) -> Result<ComPtr<AllJoynServiceInfoRemovedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynServiceInfoRemovedEventArgsFactory>>::get_activation_factory().create(uniqueName)
    }}
}
DEFINE_CLSID!(AllJoynServiceInfoRemovedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,114,118,105,99,101,73,110,102,111,82,101,109,111,118,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynServiceInfoRemovedEventArgs]);
DEFINE_IID!(IID_IAllJoynServiceInfoRemovedEventArgsFactory, 230655527, 39679, 18773, 146, 39, 105, 83, 186, 244, 21, 105);
RT_INTERFACE!{static interface IAllJoynServiceInfoRemovedEventArgsFactory(IAllJoynServiceInfoRemovedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynServiceInfoRemovedEventArgsFactory] {
    fn Create(&self, uniqueName: HSTRING, out: *mut *mut AllJoynServiceInfoRemovedEventArgs) -> HRESULT
}}
impl IAllJoynServiceInfoRemovedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, uniqueName: &HStringArg) -> Result<ComPtr<AllJoynServiceInfoRemovedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, uniqueName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynServiceInfoStatics, 1450727178, 24634, 18940, 183, 80, 14, 241, 54, 9, 33, 60);
RT_INTERFACE!{static interface IAllJoynServiceInfoStatics(IAllJoynServiceInfoStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynServiceInfoStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynServiceInfo>) -> HRESULT
}}
impl IAllJoynServiceInfoStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynServiceInfo>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynSession, 3906018060, 49364, 16492, 136, 169, 169, 62, 250, 133, 212, 177);
RT_INTERFACE!{interface IAllJoynSession(IAllJoynSessionVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSession] {
    fn get_Id(&self, out: *mut i32) -> HRESULT,
    fn get_Status(&self, out: *mut i32) -> HRESULT,
    fn RemoveMemberAsync(&self, uniqueName: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<i32>) -> HRESULT,
    fn add_MemberAdded(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynSession, AllJoynSessionMemberAddedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MemberAdded(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_MemberRemoved(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynSession, AllJoynSessionMemberRemovedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MemberRemoved(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Lost(&self, handler: *mut super::super::foundation::TypedEventHandler<AllJoynSession, AllJoynSessionLostEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Lost(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAllJoynSession {
    #[inline] pub unsafe fn get_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_member_async(&self, uniqueName: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RemoveMemberAsync)(self as *const _ as *mut _, uniqueName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_member_added(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynSession, AllJoynSessionMemberAddedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MemberAdded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_member_added(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MemberAdded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_member_removed(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynSession, AllJoynSessionMemberRemovedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MemberRemoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_member_removed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MemberRemoved)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_lost(&self, handler: &super::super::foundation::TypedEventHandler<AllJoynSession, AllJoynSessionLostEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Lost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_lost(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Lost)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynSession: IAllJoynSession}
impl RtActivatable<IAllJoynSessionStatics> for AllJoynSession {}
impl AllJoynSession {
    #[inline] pub fn get_from_service_info_async(serviceInfo: &AllJoynServiceInfo) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynSession>>> { unsafe {
        <Self as RtActivatable<IAllJoynSessionStatics>>::get_activation_factory().get_from_service_info_async(serviceInfo)
    }}
    #[inline] pub fn get_from_service_info_and_bus_attachment_async(serviceInfo: &AllJoynServiceInfo, busAttachment: &AllJoynBusAttachment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynSession>>> { unsafe {
        <Self as RtActivatable<IAllJoynSessionStatics>>::get_activation_factory().get_from_service_info_and_bus_attachment_async(serviceInfo, busAttachment)
    }}
}
DEFINE_CLSID!(AllJoynSession(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,115,115,105,111,110,0]) [CLSID_AllJoynSession]);
DEFINE_IID!(IID_IAllJoynSessionJoinedEventArgs, 2661243856, 46551, 18373, 141, 171, 176, 64, 204, 25, 40, 113);
RT_INTERFACE!{interface IAllJoynSessionJoinedEventArgs(IAllJoynSessionJoinedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionJoinedEventArgs] {
    fn get_Session(&self, out: *mut *mut AllJoynSession) -> HRESULT
}}
impl IAllJoynSessionJoinedEventArgs {
    #[inline] pub unsafe fn get_session(&self) -> Result<ComPtr<AllJoynSession>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Session)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynSessionJoinedEventArgs: IAllJoynSessionJoinedEventArgs}
impl RtActivatable<IAllJoynSessionJoinedEventArgsFactory> for AllJoynSessionJoinedEventArgs {}
impl AllJoynSessionJoinedEventArgs {
    #[inline] pub fn create(session: &AllJoynSession) -> Result<ComPtr<AllJoynSessionJoinedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynSessionJoinedEventArgsFactory>>::get_activation_factory().create(session)
    }}
}
DEFINE_CLSID!(AllJoynSessionJoinedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,115,115,105,111,110,74,111,105,110,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynSessionJoinedEventArgs]);
DEFINE_IID!(IID_IAllJoynSessionJoinedEventArgsFactory, 1747244681, 54987, 19870, 160, 158, 53, 128, 104, 112, 177, 127);
RT_INTERFACE!{static interface IAllJoynSessionJoinedEventArgsFactory(IAllJoynSessionJoinedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionJoinedEventArgsFactory] {
    fn Create(&self, session: *mut AllJoynSession, out: *mut *mut AllJoynSessionJoinedEventArgs) -> HRESULT
}}
impl IAllJoynSessionJoinedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, session: &AllJoynSession) -> Result<ComPtr<AllJoynSessionJoinedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, session as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynSessionLostEventArgs, 3882263690, 35768, 18772, 174, 103, 210, 250, 67, 209, 249, 107);
RT_INTERFACE!{interface IAllJoynSessionLostEventArgs(IAllJoynSessionLostEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionLostEventArgs] {
    fn get_Reason(&self, out: *mut AllJoynSessionLostReason) -> HRESULT
}}
impl IAllJoynSessionLostEventArgs {
    #[inline] pub unsafe fn get_reason(&self) -> Result<AllJoynSessionLostReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Reason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynSessionLostEventArgs: IAllJoynSessionLostEventArgs}
impl RtActivatable<IAllJoynSessionLostEventArgsFactory> for AllJoynSessionLostEventArgs {}
impl AllJoynSessionLostEventArgs {
    #[inline] pub fn create(reason: AllJoynSessionLostReason) -> Result<ComPtr<AllJoynSessionLostEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynSessionLostEventArgsFactory>>::get_activation_factory().create(reason)
    }}
}
DEFINE_CLSID!(AllJoynSessionLostEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,115,115,105,111,110,76,111,115,116,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynSessionLostEventArgs]);
DEFINE_IID!(IID_IAllJoynSessionLostEventArgsFactory, 331087154, 54004, 18889, 152, 14, 40, 5, 225, 53, 134, 177);
RT_INTERFACE!{static interface IAllJoynSessionLostEventArgsFactory(IAllJoynSessionLostEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionLostEventArgsFactory] {
    fn Create(&self, reason: AllJoynSessionLostReason, out: *mut *mut AllJoynSessionLostEventArgs) -> HRESULT
}}
impl IAllJoynSessionLostEventArgsFactory {
    #[inline] pub unsafe fn create(&self, reason: AllJoynSessionLostReason) -> Result<ComPtr<AllJoynSessionLostEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, reason, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AllJoynSessionLostReason: i32 {
    None (AllJoynSessionLostReason_None) = 0, ProducerLeftSession (AllJoynSessionLostReason_ProducerLeftSession) = 1, ProducerClosedAbruptly (AllJoynSessionLostReason_ProducerClosedAbruptly) = 2, RemovedByProducer (AllJoynSessionLostReason_RemovedByProducer) = 3, LinkTimeout (AllJoynSessionLostReason_LinkTimeout) = 4, Other (AllJoynSessionLostReason_Other) = 5,
}}
DEFINE_IID!(IID_IAllJoynSessionMemberAddedEventArgs, 1235384714, 3537, 18113, 156, 214, 39, 25, 14, 80, 58, 94);
RT_INTERFACE!{interface IAllJoynSessionMemberAddedEventArgs(IAllJoynSessionMemberAddedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionMemberAddedEventArgs] {
    fn get_UniqueName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAllJoynSessionMemberAddedEventArgs {
    #[inline] pub unsafe fn get_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynSessionMemberAddedEventArgs: IAllJoynSessionMemberAddedEventArgs}
impl RtActivatable<IAllJoynSessionMemberAddedEventArgsFactory> for AllJoynSessionMemberAddedEventArgs {}
impl AllJoynSessionMemberAddedEventArgs {
    #[inline] pub fn create(uniqueName: &HStringArg) -> Result<ComPtr<AllJoynSessionMemberAddedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynSessionMemberAddedEventArgsFactory>>::get_activation_factory().create(uniqueName)
    }}
}
DEFINE_CLSID!(AllJoynSessionMemberAddedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,115,115,105,111,110,77,101,109,98,101,114,65,100,100,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynSessionMemberAddedEventArgs]);
DEFINE_IID!(IID_IAllJoynSessionMemberAddedEventArgsFactory, 874373970, 7475, 16545, 161, 211, 229, 119, 112, 32, 225, 241);
RT_INTERFACE!{static interface IAllJoynSessionMemberAddedEventArgsFactory(IAllJoynSessionMemberAddedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionMemberAddedEventArgsFactory] {
    fn Create(&self, uniqueName: HSTRING, out: *mut *mut AllJoynSessionMemberAddedEventArgs) -> HRESULT
}}
impl IAllJoynSessionMemberAddedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, uniqueName: &HStringArg) -> Result<ComPtr<AllJoynSessionMemberAddedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, uniqueName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynSessionMemberRemovedEventArgs, 1083842975, 43594, 18579, 180, 48, 186, 161, 182, 60, 98, 25);
RT_INTERFACE!{interface IAllJoynSessionMemberRemovedEventArgs(IAllJoynSessionMemberRemovedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionMemberRemovedEventArgs] {
    fn get_UniqueName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAllJoynSessionMemberRemovedEventArgs {
    #[inline] pub unsafe fn get_unique_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UniqueName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynSessionMemberRemovedEventArgs: IAllJoynSessionMemberRemovedEventArgs}
impl RtActivatable<IAllJoynSessionMemberRemovedEventArgsFactory> for AllJoynSessionMemberRemovedEventArgs {}
impl AllJoynSessionMemberRemovedEventArgs {
    #[inline] pub fn create(uniqueName: &HStringArg) -> Result<ComPtr<AllJoynSessionMemberRemovedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynSessionMemberRemovedEventArgsFactory>>::get_activation_factory().create(uniqueName)
    }}
}
DEFINE_CLSID!(AllJoynSessionMemberRemovedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,101,115,115,105,111,110,77,101,109,98,101,114,82,101,109,111,118,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynSessionMemberRemovedEventArgs]);
DEFINE_IID!(IID_IAllJoynSessionMemberRemovedEventArgsFactory, 3302184424, 17080, 19303, 183, 87, 208, 207, 202, 213, 146, 128);
RT_INTERFACE!{static interface IAllJoynSessionMemberRemovedEventArgsFactory(IAllJoynSessionMemberRemovedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionMemberRemovedEventArgsFactory] {
    fn Create(&self, uniqueName: HSTRING, out: *mut *mut AllJoynSessionMemberRemovedEventArgs) -> HRESULT
}}
impl IAllJoynSessionMemberRemovedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, uniqueName: &HStringArg) -> Result<ComPtr<AllJoynSessionMemberRemovedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, uniqueName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAllJoynSessionStatics, 2651182596, 41068, 18132, 180, 108, 11, 11, 84, 16, 91, 68);
RT_INTERFACE!{static interface IAllJoynSessionStatics(IAllJoynSessionStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynSessionStatics] {
    fn GetFromServiceInfoAsync(&self, serviceInfo: *mut AllJoynServiceInfo, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynSession>) -> HRESULT,
    fn GetFromServiceInfoAndBusAttachmentAsync(&self, serviceInfo: *mut AllJoynServiceInfo, busAttachment: *mut AllJoynBusAttachment, out: *mut *mut super::super::foundation::IAsyncOperation<AllJoynSession>) -> HRESULT
}}
impl IAllJoynSessionStatics {
    #[inline] pub unsafe fn get_from_service_info_async(&self, serviceInfo: &AllJoynServiceInfo) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynSession>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetFromServiceInfoAsync)(self as *const _ as *mut _, serviceInfo as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from_service_info_and_bus_attachment_async(&self, serviceInfo: &AllJoynServiceInfo, busAttachment: &AllJoynBusAttachment) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AllJoynSession>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetFromServiceInfoAndBusAttachmentAsync)(self as *const _ as *mut _, serviceInfo as *const _ as *mut _, busAttachment as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class AllJoynStatus}
impl RtActivatable<IAllJoynStatusStatics> for AllJoynStatus {}
impl AllJoynStatus {
    #[inline] pub fn get_ok() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_ok()
    }}
    #[inline] pub fn get_fail() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_fail()
    }}
    #[inline] pub fn get_operation_timed_out() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_operation_timed_out()
    }}
    #[inline] pub fn get_other_end_closed() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_other_end_closed()
    }}
    #[inline] pub fn get_connection_refused() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_connection_refused()
    }}
    #[inline] pub fn get_authentication_failed() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_authentication_failed()
    }}
    #[inline] pub fn get_authentication_rejected_by_user() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_authentication_rejected_by_user()
    }}
    #[inline] pub fn get_ssl_connect_failed() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_ssl_connect_failed()
    }}
    #[inline] pub fn get_ssl_identity_verification_failed() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_ssl_identity_verification_failed()
    }}
    #[inline] pub fn get_insufficient_security() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_insufficient_security()
    }}
    #[inline] pub fn get_invalid_argument1() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument1()
    }}
    #[inline] pub fn get_invalid_argument2() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument2()
    }}
    #[inline] pub fn get_invalid_argument3() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument3()
    }}
    #[inline] pub fn get_invalid_argument4() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument4()
    }}
    #[inline] pub fn get_invalid_argument5() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument5()
    }}
    #[inline] pub fn get_invalid_argument6() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument6()
    }}
    #[inline] pub fn get_invalid_argument7() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument7()
    }}
    #[inline] pub fn get_invalid_argument8() -> Result<i32> { unsafe {
        <Self as RtActivatable<IAllJoynStatusStatics>>::get_activation_factory().get_invalid_argument8()
    }}
}
DEFINE_CLSID!(AllJoynStatus(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,83,116,97,116,117,115,0]) [CLSID_AllJoynStatus]);
DEFINE_IID!(IID_IAllJoynStatusStatics, 3501695358, 3369, 19881, 138, 198, 84, 197, 84, 190, 219, 197);
RT_INTERFACE!{static interface IAllJoynStatusStatics(IAllJoynStatusStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynStatusStatics] {
    fn get_Ok(&self, out: *mut i32) -> HRESULT,
    fn get_Fail(&self, out: *mut i32) -> HRESULT,
    fn get_OperationTimedOut(&self, out: *mut i32) -> HRESULT,
    fn get_OtherEndClosed(&self, out: *mut i32) -> HRESULT,
    fn get_ConnectionRefused(&self, out: *mut i32) -> HRESULT,
    fn get_AuthenticationFailed(&self, out: *mut i32) -> HRESULT,
    fn get_AuthenticationRejectedByUser(&self, out: *mut i32) -> HRESULT,
    fn get_SslConnectFailed(&self, out: *mut i32) -> HRESULT,
    fn get_SslIdentityVerificationFailed(&self, out: *mut i32) -> HRESULT,
    fn get_InsufficientSecurity(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument1(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument2(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument3(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument4(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument5(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument6(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument7(&self, out: *mut i32) -> HRESULT,
    fn get_InvalidArgument8(&self, out: *mut i32) -> HRESULT
}}
impl IAllJoynStatusStatics {
    #[inline] pub unsafe fn get_ok(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Ok)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_fail(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Fail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_operation_timed_out(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OperationTimedOut)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_other_end_closed(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OtherEndClosed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_refused(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConnectionRefused)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_authentication_failed(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AuthenticationFailed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_authentication_rejected_by_user(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AuthenticationRejectedByUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ssl_connect_failed(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SslConnectFailed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ssl_identity_verification_failed(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SslIdentityVerificationFailed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_insufficient_security(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InsufficientSecurity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument1(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument2(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument3(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument3)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument4(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument4)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument5(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument5)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument6(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument6)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument7(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument7)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_argument8(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidArgument8)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum AllJoynTrafficType: i32 {
    Unknown (AllJoynTrafficType_Unknown) = 0, Messages (AllJoynTrafficType_Messages) = 1, RawUnreliable (AllJoynTrafficType_RawUnreliable) = 2, RawReliable (AllJoynTrafficType_RawReliable) = 4,
}}
DEFINE_IID!(IID_IAllJoynWatcherStoppedEventArgs, 3388776507, 28701, 19112, 151, 221, 162, 187, 10, 143, 95, 163);
RT_INTERFACE!{interface IAllJoynWatcherStoppedEventArgs(IAllJoynWatcherStoppedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynWatcherStoppedEventArgs] {
    fn get_Status(&self, out: *mut i32) -> HRESULT
}}
impl IAllJoynWatcherStoppedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AllJoynWatcherStoppedEventArgs: IAllJoynWatcherStoppedEventArgs}
impl RtActivatable<IAllJoynWatcherStoppedEventArgsFactory> for AllJoynWatcherStoppedEventArgs {}
impl AllJoynWatcherStoppedEventArgs {
    #[inline] pub fn create(status: i32) -> Result<ComPtr<AllJoynWatcherStoppedEventArgs>> { unsafe {
        <Self as RtActivatable<IAllJoynWatcherStoppedEventArgsFactory>>::get_activation_factory().create(status)
    }}
}
DEFINE_CLSID!(AllJoynWatcherStoppedEventArgs(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,65,108,108,74,111,121,110,46,65,108,108,74,111,121,110,87,97,116,99,104,101,114,83,116,111,112,112,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AllJoynWatcherStoppedEventArgs]);
DEFINE_IID!(IID_IAllJoynWatcherStoppedEventArgsFactory, 2274338216, 11600, 18401, 144, 74, 32, 191, 13, 72, 199, 130);
RT_INTERFACE!{static interface IAllJoynWatcherStoppedEventArgsFactory(IAllJoynWatcherStoppedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAllJoynWatcherStoppedEventArgsFactory] {
    fn Create(&self, status: i32, out: *mut *mut AllJoynWatcherStoppedEventArgs) -> HRESULT
}}
impl IAllJoynWatcherStoppedEventArgsFactory {
    #[inline] pub unsafe fn create(&self, status: i32) -> Result<ComPtr<AllJoynWatcherStoppedEventArgs>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, status, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Devices.AllJoyn
pub mod background { // Windows.Devices.Background
use ::prelude::*;
DEFINE_IID!(IID_IDeviceServicingDetails, 1252781609, 9028, 19140, 133, 39, 74, 142, 246, 144, 86, 69);
RT_INTERFACE!{interface IDeviceServicingDetails(IDeviceServicingDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceServicingDetails] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Arguments(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ExpectedDuration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IDeviceServicingDetails {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_arguments(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_expected_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExpectedDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceServicingDetails: IDeviceServicingDetails}
DEFINE_IID!(IID_IDeviceUseDetails, 2102808897, 21886, 16724, 185, 148, 228, 247, 161, 31, 179, 35);
RT_INTERFACE!{interface IDeviceUseDetails(IDeviceUseDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceUseDetails] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Arguments(&self, out: *mut HSTRING) -> HRESULT
}}
impl IDeviceUseDetails {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_arguments(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceUseDetails: IDeviceUseDetails}
} // Windows.Devices.Background
pub mod bluetooth { // Windows.Devices.Bluetooth
use ::prelude::*;
DEFINE_IID!(IID_IBluetoothAdapter, 2037706828, 24442, 18996, 146, 37, 168, 85, 248, 75, 26, 139);
RT_INTERFACE!{interface IBluetoothAdapter(IBluetoothAdapterVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothAdapter] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_BluetoothAddress(&self, out: *mut u64) -> HRESULT,
    fn get_IsClassicSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsLowEnergySupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsPeripheralRoleSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsCentralRoleSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsAdvertisementOffloadSupported(&self, out: *mut bool) -> HRESULT,
    fn GetRadioAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::radios::Radio>) -> HRESULT
}}
impl IBluetoothAdapter {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bluetooth_address(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BluetoothAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_classic_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsClassicSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_low_energy_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsLowEnergySupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_peripheral_role_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPeripheralRoleSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_central_role_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCentralRoleSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_advertisement_offload_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAdvertisementOffloadSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_radio_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::radios::Radio>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRadioAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothAdapter: IBluetoothAdapter}
impl RtActivatable<IBluetoothAdapterStatics> for BluetoothAdapter {}
impl BluetoothAdapter {
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothAdapterStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothAdapter>>> { unsafe {
        <Self as RtActivatable<IBluetoothAdapterStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn get_default_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothAdapter>>> { unsafe {
        <Self as RtActivatable<IBluetoothAdapterStatics>>::get_activation_factory().get_default_async()
    }}
}
DEFINE_CLSID!(BluetoothAdapter(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,65,100,97,112,116,101,114,0]) [CLSID_BluetoothAdapter]);
DEFINE_IID!(IID_IBluetoothAdapterStatics, 2332228458, 44108, 18241, 134, 97, 142, 171, 125, 23, 234, 159);
RT_INTERFACE!{static interface IBluetoothAdapterStatics(IBluetoothAdapterStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothAdapterStatics] {
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothAdapter>) -> HRESULT,
    fn GetDefaultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothAdapter>) -> HRESULT
}}
impl IBluetoothAdapterStatics {
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothAdapter>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothAdapter>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothAddressType: i32 {
    Public (BluetoothAddressType_Public) = 0, Random (BluetoothAddressType_Random) = 1, Unspecified (BluetoothAddressType_Unspecified) = 2,
}}
RT_ENUM! { enum BluetoothCacheMode: i32 {
    Cached (BluetoothCacheMode_Cached) = 0, Uncached (BluetoothCacheMode_Uncached) = 1,
}}
DEFINE_IID!(IID_IBluetoothClassOfDevice, 3594527358, 55255, 18017, 148, 84, 101, 3, 156, 161, 122, 43);
RT_INTERFACE!{interface IBluetoothClassOfDevice(IBluetoothClassOfDeviceVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothClassOfDevice] {
    fn get_RawValue(&self, out: *mut u32) -> HRESULT,
    fn get_MajorClass(&self, out: *mut BluetoothMajorClass) -> HRESULT,
    fn get_MinorClass(&self, out: *mut BluetoothMinorClass) -> HRESULT,
    fn get_ServiceCapabilities(&self, out: *mut BluetoothServiceCapabilities) -> HRESULT
}}
impl IBluetoothClassOfDevice {
    #[inline] pub unsafe fn get_raw_value(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RawValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_major_class(&self) -> Result<BluetoothMajorClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MajorClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_minor_class(&self) -> Result<BluetoothMinorClass> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinorClass)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_capabilities(&self) -> Result<BluetoothServiceCapabilities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceCapabilities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothClassOfDevice: IBluetoothClassOfDevice}
impl RtActivatable<IBluetoothClassOfDeviceStatics> for BluetoothClassOfDevice {}
impl BluetoothClassOfDevice {
    #[inline] pub fn from_raw_value(rawValue: u32) -> Result<ComPtr<BluetoothClassOfDevice>> { unsafe {
        <Self as RtActivatable<IBluetoothClassOfDeviceStatics>>::get_activation_factory().from_raw_value(rawValue)
    }}
    #[inline] pub fn from_parts(majorClass: BluetoothMajorClass, minorClass: BluetoothMinorClass, serviceCapabilities: BluetoothServiceCapabilities) -> Result<ComPtr<BluetoothClassOfDevice>> { unsafe {
        <Self as RtActivatable<IBluetoothClassOfDeviceStatics>>::get_activation_factory().from_parts(majorClass, minorClass, serviceCapabilities)
    }}
}
DEFINE_CLSID!(BluetoothClassOfDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,67,108,97,115,115,79,102,68,101,118,105,99,101,0]) [CLSID_BluetoothClassOfDevice]);
DEFINE_IID!(IID_IBluetoothClassOfDeviceStatics, 3831575997, 4002, 16748, 145, 180, 193, 228, 140, 160, 97, 193);
RT_INTERFACE!{static interface IBluetoothClassOfDeviceStatics(IBluetoothClassOfDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothClassOfDeviceStatics] {
    fn FromRawValue(&self, rawValue: u32, out: *mut *mut BluetoothClassOfDevice) -> HRESULT,
    fn FromParts(&self, majorClass: BluetoothMajorClass, minorClass: BluetoothMinorClass, serviceCapabilities: BluetoothServiceCapabilities, out: *mut *mut BluetoothClassOfDevice) -> HRESULT
}}
impl IBluetoothClassOfDeviceStatics {
    #[inline] pub unsafe fn from_raw_value(&self, rawValue: u32) -> Result<ComPtr<BluetoothClassOfDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromRawValue)(self as *const _ as *mut _, rawValue, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_parts(&self, majorClass: BluetoothMajorClass, minorClass: BluetoothMinorClass, serviceCapabilities: BluetoothServiceCapabilities) -> Result<ComPtr<BluetoothClassOfDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromParts)(self as *const _ as *mut _, majorClass, minorClass, serviceCapabilities, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothConnectionStatus: i32 {
    Disconnected (BluetoothConnectionStatus_Disconnected) = 0, Connected (BluetoothConnectionStatus_Connected) = 1,
}}
DEFINE_IID!(IID_IBluetoothDevice, 590721366, 37074, 18948, 174, 245, 14, 32, 185, 230, 183, 7);
RT_INTERFACE!{interface IBluetoothDevice(IBluetoothDeviceVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDevice] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-networking"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-networking")] fn get_HostName(&self, out: *mut *mut super::super::networking::HostName) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ClassOfDevice(&self, out: *mut *mut BluetoothClassOfDevice) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SdpRecords(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::storage::streams::IBuffer>) -> HRESULT,
    fn get_RfcommServices(&self, out: *mut *mut super::super::foundation::collections::IVectorView<rfcomm::RfcommDeviceService>) -> HRESULT,
    fn get_ConnectionStatus(&self, out: *mut BluetoothConnectionStatus) -> HRESULT,
    fn get_BluetoothAddress(&self, out: *mut u64) -> HRESULT,
    fn add_NameChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<BluetoothDevice, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NameChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SdpRecordsChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<BluetoothDevice, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SdpRecordsChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ConnectionStatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<BluetoothDevice, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ConnectionStatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IBluetoothDevice {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_host_name(&self) -> Result<ComPtr<super::super::networking::HostName>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HostName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_class_of_device(&self) -> Result<ComPtr<BluetoothClassOfDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ClassOfDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_sdp_records(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::storage::streams::IBuffer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SdpRecords)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rfcomm_services(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<rfcomm::RfcommDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RfcommServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_status(&self) -> Result<BluetoothConnectionStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConnectionStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bluetooth_address(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BluetoothAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_name_changed(&self, handler: &super::super::foundation::TypedEventHandler<BluetoothDevice, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NameChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_name_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NameChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sdp_records_changed(&self, handler: &super::super::foundation::TypedEventHandler<BluetoothDevice, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SdpRecordsChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sdp_records_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SdpRecordsChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_connection_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<BluetoothDevice, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ConnectionStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_connection_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ConnectionStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothDevice: IBluetoothDevice}
impl RtActivatable<IBluetoothDeviceStatics> for BluetoothDevice {}
impl RtActivatable<IBluetoothDeviceStatics2> for BluetoothDevice {}
impl BluetoothDevice {
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothDevice>>> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[cfg(feature="windows-networking")] #[inline] pub fn from_host_name_async(hostName: &super::super::networking::HostName) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothDevice>>> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics>>::get_activation_factory().from_host_name_async(hostName)
    }}
    #[inline] pub fn from_bluetooth_address_async(address: u64) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothDevice>>> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics>>::get_activation_factory().from_bluetooth_address_async(address)
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn get_device_selector_from_pairing_state(pairingState: bool) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics2>>::get_activation_factory().get_device_selector_from_pairing_state(pairingState)
    }}
    #[inline] pub fn get_device_selector_from_connection_status(connectionStatus: BluetoothConnectionStatus) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics2>>::get_activation_factory().get_device_selector_from_connection_status(connectionStatus)
    }}
    #[inline] pub fn get_device_selector_from_device_name(deviceName: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics2>>::get_activation_factory().get_device_selector_from_device_name(deviceName)
    }}
    #[inline] pub fn get_device_selector_from_bluetooth_address(bluetoothAddress: u64) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics2>>::get_activation_factory().get_device_selector_from_bluetooth_address(bluetoothAddress)
    }}
    #[inline] pub fn get_device_selector_from_class_of_device(classOfDevice: &BluetoothClassOfDevice) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceStatics2>>::get_activation_factory().get_device_selector_from_class_of_device(classOfDevice)
    }}
}
DEFINE_CLSID!(BluetoothDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,68,101,118,105,99,101,0]) [CLSID_BluetoothDevice]);
DEFINE_IID!(IID_IBluetoothDevice2, 20183380, 45398, 19920, 177, 245, 193, 27, 195, 26, 81, 99);
RT_INTERFACE!{interface IBluetoothDevice2(IBluetoothDevice2Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDevice2] {
    fn get_DeviceInformation(&self, out: *mut *mut super::enumeration::DeviceInformation) -> HRESULT
}}
impl IBluetoothDevice2 {
    #[inline] pub unsafe fn get_device_information(&self) -> Result<ComPtr<super::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothDevice3, 1476392843, 25882, 17492, 185, 15, 235, 33, 239, 11, 13, 113);
RT_INTERFACE!{interface IBluetoothDevice3(IBluetoothDevice3Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDevice3] {
    fn get_DeviceAccessInformation(&self, out: *mut *mut super::enumeration::DeviceAccessInformation) -> HRESULT,
    fn RequestAccessAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::enumeration::DeviceAccessStatus>) -> HRESULT,
    fn GetRfcommServicesAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>) -> HRESULT,
    fn GetRfcommServicesWithCacheModeAsync(&self, cacheMode: BluetoothCacheMode, out: *mut *mut super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>) -> HRESULT,
    fn GetRfcommServicesForIdAsync(&self, serviceId: *mut rfcomm::RfcommServiceId, out: *mut *mut super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>) -> HRESULT,
    fn GetRfcommServicesForIdWithCacheModeAsync(&self, serviceId: *mut rfcomm::RfcommServiceId, cacheMode: BluetoothCacheMode, out: *mut *mut super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>) -> HRESULT
}}
impl IBluetoothDevice3 {
    #[inline] pub unsafe fn get_device_access_information(&self) -> Result<ComPtr<super::enumeration::DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceAccessInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::enumeration::DeviceAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rfcomm_services_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRfcommServicesAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rfcomm_services_with_cache_mode_async(&self, cacheMode: BluetoothCacheMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRfcommServicesWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rfcomm_services_for_id_async(&self, serviceId: &rfcomm::RfcommServiceId) -> Result<ComPtr<super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRfcommServicesForIdAsync)(self as *const _ as *mut _, serviceId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rfcomm_services_for_id_with_cache_mode_async(&self, serviceId: &rfcomm::RfcommServiceId, cacheMode: BluetoothCacheMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<rfcomm::RfcommDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRfcommServicesForIdWithCacheModeAsync)(self as *const _ as *mut _, serviceId as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothDevice4, 2172400813, 3740, 17074, 168, 220, 62, 128, 148, 148, 13, 18);
RT_INTERFACE!{interface IBluetoothDevice4(IBluetoothDevice4Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDevice4] {
    fn get_BluetoothDeviceId(&self, out: *mut *mut BluetoothDeviceId) -> HRESULT
}}
impl IBluetoothDevice4 {
    #[inline] pub unsafe fn get_bluetooth_device_id(&self) -> Result<ComPtr<BluetoothDeviceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BluetoothDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothDeviceId, 3245951407, 22465, 17986, 188, 206, 230, 192, 107, 32, 174, 118);
RT_INTERFACE!{interface IBluetoothDeviceId(IBluetoothDeviceIdVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDeviceId] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsClassicDevice(&self, out: *mut bool) -> HRESULT,
    fn get_IsLowEnergyDevice(&self, out: *mut bool) -> HRESULT
}}
impl IBluetoothDeviceId {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_classic_device(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsClassicDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_low_energy_device(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsLowEnergyDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothDeviceId: IBluetoothDeviceId}
impl RtActivatable<IBluetoothDeviceIdStatics> for BluetoothDeviceId {}
impl BluetoothDeviceId {
    #[inline] pub fn from_id(deviceId: &HStringArg) -> Result<ComPtr<BluetoothDeviceId>> { unsafe {
        <Self as RtActivatable<IBluetoothDeviceIdStatics>>::get_activation_factory().from_id(deviceId)
    }}
}
DEFINE_CLSID!(BluetoothDeviceId(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,68,101,118,105,99,101,73,100,0]) [CLSID_BluetoothDeviceId]);
DEFINE_IID!(IID_IBluetoothDeviceIdStatics, 2810728039, 16123, 20273, 187, 194, 129, 14, 9, 151, 116, 4);
RT_INTERFACE!{static interface IBluetoothDeviceIdStatics(IBluetoothDeviceIdStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDeviceIdStatics] {
    fn FromId(&self, deviceId: HSTRING, out: *mut *mut BluetoothDeviceId) -> HRESULT
}}
impl IBluetoothDeviceIdStatics {
    #[inline] pub unsafe fn from_id(&self, deviceId: &HStringArg) -> Result<ComPtr<BluetoothDeviceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromId)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothDeviceStatics, 160554833, 22491, 18213, 187, 215, 132, 246, 67, 39, 236, 44);
RT_INTERFACE!{static interface IBluetoothDeviceStatics(IBluetoothDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDeviceStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothDevice>) -> HRESULT,
    #[cfg(not(feature="windows-networking"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-networking")] fn FromHostNameAsync(&self, hostName: *mut super::super::networking::HostName, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothDevice>) -> HRESULT,
    fn FromBluetoothAddressAsync(&self, address: u64, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothDevice>) -> HRESULT,
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT
}}
impl IBluetoothDeviceStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn from_host_name_async(&self, hostName: &super::super::networking::HostName) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromHostNameAsync)(self as *const _ as *mut _, hostName as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_bluetooth_address_async(&self, address: u64) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromBluetoothAddressAsync)(self as *const _ as *mut _, address, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothDeviceStatics2, 3265170991, 19988, 17527, 170, 27, 184, 180, 126, 91, 126, 206);
RT_INTERFACE!{static interface IBluetoothDeviceStatics2(IBluetoothDeviceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothDeviceStatics2] {
    fn GetDeviceSelectorFromPairingState(&self, pairingState: bool, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromConnectionStatus(&self, connectionStatus: BluetoothConnectionStatus, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromDeviceName(&self, deviceName: HSTRING, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromBluetoothAddress(&self, bluetoothAddress: u64, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromClassOfDevice(&self, classOfDevice: *mut BluetoothClassOfDevice, out: *mut HSTRING) -> HRESULT
}}
impl IBluetoothDeviceStatics2 {
    #[inline] pub unsafe fn get_device_selector_from_pairing_state(&self, pairingState: bool) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromPairingState)(self as *const _ as *mut _, pairingState, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_connection_status(&self, connectionStatus: BluetoothConnectionStatus) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromConnectionStatus)(self as *const _ as *mut _, connectionStatus, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_device_name(&self, deviceName: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromDeviceName)(self as *const _ as *mut _, deviceName.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_bluetooth_address(&self, bluetoothAddress: u64) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromBluetoothAddress)(self as *const _ as *mut _, bluetoothAddress, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_class_of_device(&self, classOfDevice: &BluetoothClassOfDevice) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromClassOfDevice)(self as *const _ as *mut _, classOfDevice as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothError: i32 {
    Success (BluetoothError_Success) = 0, RadioNotAvailable (BluetoothError_RadioNotAvailable) = 1, ResourceInUse (BluetoothError_ResourceInUse) = 2, DeviceNotConnected (BluetoothError_DeviceNotConnected) = 3, OtherError (BluetoothError_OtherError) = 4, DisabledByPolicy (BluetoothError_DisabledByPolicy) = 5, NotSupported (BluetoothError_NotSupported) = 6, DisabledByUser (BluetoothError_DisabledByUser) = 7, ConsentRequired (BluetoothError_ConsentRequired) = 8, TransportNotSupported (BluetoothError_TransportNotSupported) = 9,
}}
DEFINE_IID!(IID_IBluetoothLEAppearance, 1562409458, 26280, 16984, 152, 94, 2, 180, 217, 80, 159, 24);
RT_INTERFACE!{interface IBluetoothLEAppearance(IBluetoothLEAppearanceVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAppearance] {
    fn get_RawValue(&self, out: *mut u16) -> HRESULT,
    fn get_Category(&self, out: *mut u16) -> HRESULT,
    fn get_SubCategory(&self, out: *mut u16) -> HRESULT
}}
impl IBluetoothLEAppearance {
    #[inline] pub unsafe fn get_raw_value(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RawValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_category(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Category)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sub_category(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SubCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAppearance: IBluetoothLEAppearance}
impl RtActivatable<IBluetoothLEAppearanceStatics> for BluetoothLEAppearance {}
impl BluetoothLEAppearance {
    #[inline] pub fn from_raw_value(rawValue: u16) -> Result<ComPtr<BluetoothLEAppearance>> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceStatics>>::get_activation_factory().from_raw_value(rawValue)
    }}
    #[inline] pub fn from_parts(appearanceCategory: u16, appearanceSubCategory: u16) -> Result<ComPtr<BluetoothLEAppearance>> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceStatics>>::get_activation_factory().from_parts(appearanceCategory, appearanceSubCategory)
    }}
}
DEFINE_CLSID!(BluetoothLEAppearance(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,76,69,65,112,112,101,97,114,97,110,99,101,0]) [CLSID_BluetoothLEAppearance]);
RT_CLASS!{static class BluetoothLEAppearanceCategories}
impl RtActivatable<IBluetoothLEAppearanceCategoriesStatics> for BluetoothLEAppearanceCategories {}
impl BluetoothLEAppearanceCategories {
    #[inline] pub fn get_uncategorized() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_uncategorized()
    }}
    #[inline] pub fn get_phone() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_phone()
    }}
    #[inline] pub fn get_computer() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_computer()
    }}
    #[inline] pub fn get_watch() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_watch()
    }}
    #[inline] pub fn get_clock() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_clock()
    }}
    #[inline] pub fn get_display() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_display()
    }}
    #[inline] pub fn get_remote_control() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_remote_control()
    }}
    #[inline] pub fn get_eye_glasses() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_eye_glasses()
    }}
    #[inline] pub fn get_tag() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_tag()
    }}
    #[inline] pub fn get_keyring() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_keyring()
    }}
    #[inline] pub fn get_media_player() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_media_player()
    }}
    #[inline] pub fn get_barcode_scanner() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_barcode_scanner()
    }}
    #[inline] pub fn get_thermometer() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_thermometer()
    }}
    #[inline] pub fn get_heart_rate() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_heart_rate()
    }}
    #[inline] pub fn get_blood_pressure() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_blood_pressure()
    }}
    #[inline] pub fn get_human_interface_device() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_human_interface_device()
    }}
    #[inline] pub fn get_glucose_meter() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_glucose_meter()
    }}
    #[inline] pub fn get_running_walking() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_running_walking()
    }}
    #[inline] pub fn get_cycling() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_cycling()
    }}
    #[inline] pub fn get_pulse_oximeter() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_pulse_oximeter()
    }}
    #[inline] pub fn get_weight_scale() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_weight_scale()
    }}
    #[inline] pub fn get_outdoor_sport_activity() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceCategoriesStatics>>::get_activation_factory().get_outdoor_sport_activity()
    }}
}
DEFINE_CLSID!(BluetoothLEAppearanceCategories(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,76,69,65,112,112,101,97,114,97,110,99,101,67,97,116,101,103,111,114,105,101,115,0]) [CLSID_BluetoothLEAppearanceCategories]);
DEFINE_IID!(IID_IBluetoothLEAppearanceCategoriesStatics, 1833784574, 1130, 16773, 170, 182, 130, 76, 240, 97, 8, 97);
RT_INTERFACE!{static interface IBluetoothLEAppearanceCategoriesStatics(IBluetoothLEAppearanceCategoriesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAppearanceCategoriesStatics] {
    fn get_Uncategorized(&self, out: *mut u16) -> HRESULT,
    fn get_Phone(&self, out: *mut u16) -> HRESULT,
    fn get_Computer(&self, out: *mut u16) -> HRESULT,
    fn get_Watch(&self, out: *mut u16) -> HRESULT,
    fn get_Clock(&self, out: *mut u16) -> HRESULT,
    fn get_Display(&self, out: *mut u16) -> HRESULT,
    fn get_RemoteControl(&self, out: *mut u16) -> HRESULT,
    fn get_EyeGlasses(&self, out: *mut u16) -> HRESULT,
    fn get_Tag(&self, out: *mut u16) -> HRESULT,
    fn get_Keyring(&self, out: *mut u16) -> HRESULT,
    fn get_MediaPlayer(&self, out: *mut u16) -> HRESULT,
    fn get_BarcodeScanner(&self, out: *mut u16) -> HRESULT,
    fn get_Thermometer(&self, out: *mut u16) -> HRESULT,
    fn get_HeartRate(&self, out: *mut u16) -> HRESULT,
    fn get_BloodPressure(&self, out: *mut u16) -> HRESULT,
    fn get_HumanInterfaceDevice(&self, out: *mut u16) -> HRESULT,
    fn get_GlucoseMeter(&self, out: *mut u16) -> HRESULT,
    fn get_RunningWalking(&self, out: *mut u16) -> HRESULT,
    fn get_Cycling(&self, out: *mut u16) -> HRESULT,
    fn get_PulseOximeter(&self, out: *mut u16) -> HRESULT,
    fn get_WeightScale(&self, out: *mut u16) -> HRESULT,
    fn get_OutdoorSportActivity(&self, out: *mut u16) -> HRESULT
}}
impl IBluetoothLEAppearanceCategoriesStatics {
    #[inline] pub unsafe fn get_uncategorized(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uncategorized)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Phone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_computer(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Computer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_watch(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Watch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clock(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Clock)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Display)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_control(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RemoteControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_eye_glasses(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EyeGlasses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tag(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Tag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_keyring(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Keyring)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_player(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediaPlayer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_barcode_scanner(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BarcodeScanner)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thermometer(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Thermometer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_heart_rate(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HeartRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blood_pressure(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BloodPressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_human_interface_device(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HumanInterfaceDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_glucose_meter(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GlucoseMeter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_running_walking(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RunningWalking)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cycling)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pulse_oximeter(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PulseOximeter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_weight_scale(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WeightScale)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outdoor_sport_activity(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OutdoorSportActivity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEAppearanceStatics, 2710814919, 17668, 20298, 155, 165, 205, 16, 84, 229, 224, 101);
RT_INTERFACE!{static interface IBluetoothLEAppearanceStatics(IBluetoothLEAppearanceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAppearanceStatics] {
    fn FromRawValue(&self, rawValue: u16, out: *mut *mut BluetoothLEAppearance) -> HRESULT,
    fn FromParts(&self, appearanceCategory: u16, appearanceSubCategory: u16, out: *mut *mut BluetoothLEAppearance) -> HRESULT
}}
impl IBluetoothLEAppearanceStatics {
    #[inline] pub unsafe fn from_raw_value(&self, rawValue: u16) -> Result<ComPtr<BluetoothLEAppearance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromRawValue)(self as *const _ as *mut _, rawValue, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_parts(&self, appearanceCategory: u16, appearanceSubCategory: u16) -> Result<ComPtr<BluetoothLEAppearance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromParts)(self as *const _ as *mut _, appearanceCategory, appearanceSubCategory, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class BluetoothLEAppearanceSubcategories}
impl RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics> for BluetoothLEAppearanceSubcategories {}
impl BluetoothLEAppearanceSubcategories {
    #[inline] pub fn get_generic() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_generic()
    }}
    #[inline] pub fn get_sports_watch() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_sports_watch()
    }}
    #[inline] pub fn get_thermometer_ear() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_thermometer_ear()
    }}
    #[inline] pub fn get_heart_rate_belt() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_heart_rate_belt()
    }}
    #[inline] pub fn get_blood_pressure_arm() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_blood_pressure_arm()
    }}
    #[inline] pub fn get_blood_pressure_wrist() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_blood_pressure_wrist()
    }}
    #[inline] pub fn get_keyboard() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_keyboard()
    }}
    #[inline] pub fn get_mouse() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_mouse()
    }}
    #[inline] pub fn get_joystick() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_joystick()
    }}
    #[inline] pub fn get_gamepad() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_gamepad()
    }}
    #[inline] pub fn get_digitizer_tablet() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_digitizer_tablet()
    }}
    #[inline] pub fn get_card_reader() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_card_reader()
    }}
    #[inline] pub fn get_digital_pen() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_digital_pen()
    }}
    #[inline] pub fn get_barcode_scanner() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_barcode_scanner()
    }}
    #[inline] pub fn get_running_walking_in_shoe() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_running_walking_in_shoe()
    }}
    #[inline] pub fn get_running_walking_on_shoe() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_running_walking_on_shoe()
    }}
    #[inline] pub fn get_running_walking_on_hip() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_running_walking_on_hip()
    }}
    #[inline] pub fn get_cycling_computer() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_cycling_computer()
    }}
    #[inline] pub fn get_cycling_speed_sensor() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_cycling_speed_sensor()
    }}
    #[inline] pub fn get_cycling_cadence_sensor() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_cycling_cadence_sensor()
    }}
    #[inline] pub fn get_cycling_power_sensor() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_cycling_power_sensor()
    }}
    #[inline] pub fn get_cycling_speed_cadence_sensor() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_cycling_speed_cadence_sensor()
    }}
    #[inline] pub fn get_oximeter_fingertip() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_oximeter_fingertip()
    }}
    #[inline] pub fn get_oximeter_wrist_worn() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_oximeter_wrist_worn()
    }}
    #[inline] pub fn get_location_display() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_location_display()
    }}
    #[inline] pub fn get_location_navigation_display() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_location_navigation_display()
    }}
    #[inline] pub fn get_location_pod() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_location_pod()
    }}
    #[inline] pub fn get_location_navigation_pod() -> Result<u16> { unsafe {
        <Self as RtActivatable<IBluetoothLEAppearanceSubcategoriesStatics>>::get_activation_factory().get_location_navigation_pod()
    }}
}
DEFINE_CLSID!(BluetoothLEAppearanceSubcategories(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,76,69,65,112,112,101,97,114,97,110,99,101,83,117,98,99,97,116,101,103,111,114,105,101,115,0]) [CLSID_BluetoothLEAppearanceSubcategories]);
DEFINE_IID!(IID_IBluetoothLEAppearanceSubcategoriesStatics, 3850085894, 8516, 16730, 131, 18, 113, 204, 242, 145, 248, 209);
RT_INTERFACE!{static interface IBluetoothLEAppearanceSubcategoriesStatics(IBluetoothLEAppearanceSubcategoriesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAppearanceSubcategoriesStatics] {
    fn get_Generic(&self, out: *mut u16) -> HRESULT,
    fn get_SportsWatch(&self, out: *mut u16) -> HRESULT,
    fn get_ThermometerEar(&self, out: *mut u16) -> HRESULT,
    fn get_HeartRateBelt(&self, out: *mut u16) -> HRESULT,
    fn get_BloodPressureArm(&self, out: *mut u16) -> HRESULT,
    fn get_BloodPressureWrist(&self, out: *mut u16) -> HRESULT,
    fn get_Keyboard(&self, out: *mut u16) -> HRESULT,
    fn get_Mouse(&self, out: *mut u16) -> HRESULT,
    fn get_Joystick(&self, out: *mut u16) -> HRESULT,
    fn get_Gamepad(&self, out: *mut u16) -> HRESULT,
    fn get_DigitizerTablet(&self, out: *mut u16) -> HRESULT,
    fn get_CardReader(&self, out: *mut u16) -> HRESULT,
    fn get_DigitalPen(&self, out: *mut u16) -> HRESULT,
    fn get_BarcodeScanner(&self, out: *mut u16) -> HRESULT,
    fn get_RunningWalkingInShoe(&self, out: *mut u16) -> HRESULT,
    fn get_RunningWalkingOnShoe(&self, out: *mut u16) -> HRESULT,
    fn get_RunningWalkingOnHip(&self, out: *mut u16) -> HRESULT,
    fn get_CyclingComputer(&self, out: *mut u16) -> HRESULT,
    fn get_CyclingSpeedSensor(&self, out: *mut u16) -> HRESULT,
    fn get_CyclingCadenceSensor(&self, out: *mut u16) -> HRESULT,
    fn get_CyclingPowerSensor(&self, out: *mut u16) -> HRESULT,
    fn get_CyclingSpeedCadenceSensor(&self, out: *mut u16) -> HRESULT,
    fn get_OximeterFingertip(&self, out: *mut u16) -> HRESULT,
    fn get_OximeterWristWorn(&self, out: *mut u16) -> HRESULT,
    fn get_LocationDisplay(&self, out: *mut u16) -> HRESULT,
    fn get_LocationNavigationDisplay(&self, out: *mut u16) -> HRESULT,
    fn get_LocationPod(&self, out: *mut u16) -> HRESULT,
    fn get_LocationNavigationPod(&self, out: *mut u16) -> HRESULT
}}
impl IBluetoothLEAppearanceSubcategoriesStatics {
    #[inline] pub unsafe fn get_generic(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Generic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sports_watch(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SportsWatch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thermometer_ear(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThermometerEar)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_heart_rate_belt(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HeartRateBelt)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blood_pressure_arm(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BloodPressureArm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blood_pressure_wrist(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BloodPressureWrist)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_keyboard(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Keyboard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mouse(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mouse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_joystick(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Joystick)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gamepad(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gamepad)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_digitizer_tablet(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DigitizerTablet)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_card_reader(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CardReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_digital_pen(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DigitalPen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_barcode_scanner(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BarcodeScanner)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_running_walking_in_shoe(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RunningWalkingInShoe)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_running_walking_on_shoe(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RunningWalkingOnShoe)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_running_walking_on_hip(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RunningWalkingOnHip)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_computer(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingComputer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_speed_sensor(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingSpeedSensor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_cadence_sensor(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingCadenceSensor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_power_sensor(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingPowerSensor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_speed_cadence_sensor(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingSpeedCadenceSensor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_oximeter_fingertip(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OximeterFingertip)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_oximeter_wrist_worn(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OximeterWristWorn)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_display(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationDisplay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_navigation_display(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationNavigationDisplay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_pod(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationPod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_navigation_pod(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationNavigationPod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEDevice, 3052285819, 19160, 17986, 172, 72, 128, 160, 181, 0, 232, 135);
RT_INTERFACE!{interface IBluetoothLEDevice(IBluetoothLEDeviceVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEDevice] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_GattServices(&self, out: *mut *mut super::super::foundation::collections::IVectorView<genericattributeprofile::GattDeviceService>) -> HRESULT,
    fn get_ConnectionStatus(&self, out: *mut BluetoothConnectionStatus) -> HRESULT,
    fn get_BluetoothAddress(&self, out: *mut u64) -> HRESULT,
    fn GetGattService(&self, serviceUuid: Guid, out: *mut *mut genericattributeprofile::GattDeviceService) -> HRESULT,
    fn add_NameChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<BluetoothLEDevice, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NameChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_GattServicesChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<BluetoothLEDevice, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_GattServicesChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ConnectionStatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<BluetoothLEDevice, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ConnectionStatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IBluetoothLEDevice {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_services(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<genericattributeprofile::GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GattServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_status(&self) -> Result<BluetoothConnectionStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConnectionStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bluetooth_address(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BluetoothAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_service(&self, serviceUuid: Guid) -> Result<ComPtr<genericattributeprofile::GattDeviceService>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGattService)(self as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_name_changed(&self, handler: &super::super::foundation::TypedEventHandler<BluetoothLEDevice, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NameChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_name_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NameChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_gatt_services_changed(&self, handler: &super::super::foundation::TypedEventHandler<BluetoothLEDevice, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_GattServicesChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_gatt_services_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_GattServicesChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_connection_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<BluetoothLEDevice, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ConnectionStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_connection_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ConnectionStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEDevice: IBluetoothLEDevice}
impl RtActivatable<IBluetoothLEDeviceStatics> for BluetoothLEDevice {}
impl RtActivatable<IBluetoothLEDeviceStatics2> for BluetoothLEDevice {}
impl BluetoothLEDevice {
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothLEDevice>>> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn from_bluetooth_address_async(bluetoothAddress: u64) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothLEDevice>>> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics>>::get_activation_factory().from_bluetooth_address_async(bluetoothAddress)
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics>>::get_activation_factory().get_device_selector()
    }}
    #[inline] pub fn get_device_selector_from_pairing_state(pairingState: bool) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().get_device_selector_from_pairing_state(pairingState)
    }}
    #[inline] pub fn get_device_selector_from_connection_status(connectionStatus: BluetoothConnectionStatus) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().get_device_selector_from_connection_status(connectionStatus)
    }}
    #[inline] pub fn get_device_selector_from_device_name(deviceName: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().get_device_selector_from_device_name(deviceName)
    }}
    #[inline] pub fn get_device_selector_from_bluetooth_address(bluetoothAddress: u64) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().get_device_selector_from_bluetooth_address(bluetoothAddress)
    }}
    #[inline] pub fn get_device_selector_from_bluetooth_address_with_bluetooth_address_type(bluetoothAddress: u64, bluetoothAddressType: BluetoothAddressType) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().get_device_selector_from_bluetooth_address_with_bluetooth_address_type(bluetoothAddress, bluetoothAddressType)
    }}
    #[inline] pub fn get_device_selector_from_appearance(appearance: &BluetoothLEAppearance) -> Result<HString> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().get_device_selector_from_appearance(appearance)
    }}
    #[inline] pub fn from_bluetooth_address_with_bluetooth_address_type_async(bluetoothAddress: u64, bluetoothAddressType: BluetoothAddressType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothLEDevice>>> { unsafe {
        <Self as RtActivatable<IBluetoothLEDeviceStatics2>>::get_activation_factory().from_bluetooth_address_with_bluetooth_address_type_async(bluetoothAddress, bluetoothAddressType)
    }}
}
DEFINE_CLSID!(BluetoothLEDevice(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,76,69,68,101,118,105,99,101,0]) [CLSID_BluetoothLEDevice]);
DEFINE_IID!(IID_IBluetoothLEDevice2, 653288115, 31470, 19761, 186, 186, 177, 185, 119, 95, 89, 22);
RT_INTERFACE!{interface IBluetoothLEDevice2(IBluetoothLEDevice2Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEDevice2] {
    fn get_DeviceInformation(&self, out: *mut *mut super::enumeration::DeviceInformation) -> HRESULT,
    fn get_Appearance(&self, out: *mut *mut BluetoothLEAppearance) -> HRESULT,
    fn get_BluetoothAddressType(&self, out: *mut BluetoothAddressType) -> HRESULT
}}
impl IBluetoothLEDevice2 {
    #[inline] pub unsafe fn get_device_information(&self) -> Result<ComPtr<super::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appearance(&self) -> Result<ComPtr<BluetoothLEAppearance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Appearance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bluetooth_address_type(&self) -> Result<BluetoothAddressType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BluetoothAddressType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEDevice3, 2934563987, 17580, 16604, 175, 51, 178, 193, 60, 1, 202, 70);
RT_INTERFACE!{interface IBluetoothLEDevice3(IBluetoothLEDevice3Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEDevice3] {
    fn get_DeviceAccessInformation(&self, out: *mut *mut super::enumeration::DeviceAccessInformation) -> HRESULT,
    fn RequestAccessAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::enumeration::DeviceAccessStatus>) -> HRESULT,
    fn GetGattServicesAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>) -> HRESULT,
    fn GetGattServicesWithCacheModeAsync(&self, cacheMode: BluetoothCacheMode, out: *mut *mut super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>) -> HRESULT,
    fn GetGattServicesForUuidAsync(&self, serviceUuid: Guid, out: *mut *mut super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>) -> HRESULT,
    fn GetGattServicesForUuidWithCacheModeAsync(&self, serviceUuid: Guid, cacheMode: BluetoothCacheMode, out: *mut *mut super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>) -> HRESULT
}}
impl IBluetoothLEDevice3 {
    #[inline] pub unsafe fn get_device_access_information(&self) -> Result<ComPtr<super::enumeration::DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceAccessInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::enumeration::DeviceAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_services_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGattServicesAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_services_with_cache_mode_async(&self, cacheMode: BluetoothCacheMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGattServicesWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_services_for_uuid_async(&self, serviceUuid: Guid) -> Result<ComPtr<super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGattServicesForUuidAsync)(self as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_services_for_uuid_with_cache_mode_async(&self, serviceUuid: Guid, cacheMode: BluetoothCacheMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<genericattributeprofile::GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGattServicesForUuidWithCacheModeAsync)(self as *const _ as *mut _, serviceUuid, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEDevice4, 727732273, 8776, 19247, 172, 240, 124, 238, 54, 252, 88, 112);
RT_INTERFACE!{interface IBluetoothLEDevice4(IBluetoothLEDevice4Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEDevice4] {
    fn get_BluetoothDeviceId(&self, out: *mut *mut BluetoothDeviceId) -> HRESULT
}}
impl IBluetoothLEDevice4 {
    #[inline] pub unsafe fn get_bluetooth_device_id(&self) -> Result<ComPtr<BluetoothDeviceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BluetoothDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEDeviceStatics, 3369015833, 61622, 19440, 134, 137, 65, 48, 61, 226, 217, 244);
RT_INTERFACE!{static interface IBluetoothLEDeviceStatics(IBluetoothLEDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEDeviceStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothLEDevice>) -> HRESULT,
    fn FromBluetoothAddressAsync(&self, bluetoothAddress: u64, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothLEDevice>) -> HRESULT,
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT
}}
impl IBluetoothLEDeviceStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothLEDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_bluetooth_address_async(&self, bluetoothAddress: u64) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothLEDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromBluetoothAddressAsync)(self as *const _ as *mut _, bluetoothAddress, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEDeviceStatics2, 1595064427, 15276, 17384, 173, 22, 86, 50, 113, 189, 65, 194);
RT_INTERFACE!{static interface IBluetoothLEDeviceStatics2(IBluetoothLEDeviceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEDeviceStatics2] {
    fn GetDeviceSelectorFromPairingState(&self, pairingState: bool, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromConnectionStatus(&self, connectionStatus: BluetoothConnectionStatus, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromDeviceName(&self, deviceName: HSTRING, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromBluetoothAddress(&self, bluetoothAddress: u64, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromBluetoothAddressWithBluetoothAddressType(&self, bluetoothAddress: u64, bluetoothAddressType: BluetoothAddressType, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromAppearance(&self, appearance: *mut BluetoothLEAppearance, out: *mut HSTRING) -> HRESULT,
    fn FromBluetoothAddressWithBluetoothAddressTypeAsync(&self, bluetoothAddress: u64, bluetoothAddressType: BluetoothAddressType, out: *mut *mut super::super::foundation::IAsyncOperation<BluetoothLEDevice>) -> HRESULT
}}
impl IBluetoothLEDeviceStatics2 {
    #[inline] pub unsafe fn get_device_selector_from_pairing_state(&self, pairingState: bool) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromPairingState)(self as *const _ as *mut _, pairingState, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_connection_status(&self, connectionStatus: BluetoothConnectionStatus) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromConnectionStatus)(self as *const _ as *mut _, connectionStatus, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_device_name(&self, deviceName: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromDeviceName)(self as *const _ as *mut _, deviceName.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_bluetooth_address(&self, bluetoothAddress: u64) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromBluetoothAddress)(self as *const _ as *mut _, bluetoothAddress, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_bluetooth_address_with_bluetooth_address_type(&self, bluetoothAddress: u64, bluetoothAddressType: BluetoothAddressType) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromBluetoothAddressWithBluetoothAddressType)(self as *const _ as *mut _, bluetoothAddress, bluetoothAddressType, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_appearance(&self, appearance: &BluetoothLEAppearance) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromAppearance)(self as *const _ as *mut _, appearance as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_bluetooth_address_with_bluetooth_address_type_async(&self, bluetoothAddress: u64, bluetoothAddressType: BluetoothAddressType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<BluetoothLEDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromBluetoothAddressWithBluetoothAddressTypeAsync)(self as *const _ as *mut _, bluetoothAddress, bluetoothAddressType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothMajorClass: i32 {
    Miscellaneous (BluetoothMajorClass_Miscellaneous) = 0, Computer (BluetoothMajorClass_Computer) = 1, Phone (BluetoothMajorClass_Phone) = 2, NetworkAccessPoint (BluetoothMajorClass_NetworkAccessPoint) = 3, AudioVideo (BluetoothMajorClass_AudioVideo) = 4, Peripheral (BluetoothMajorClass_Peripheral) = 5, Imaging (BluetoothMajorClass_Imaging) = 6, Wearable (BluetoothMajorClass_Wearable) = 7, Toy (BluetoothMajorClass_Toy) = 8, Health (BluetoothMajorClass_Health) = 9,
}}
RT_ENUM! { enum BluetoothMinorClass: i32 {
    Uncategorized (BluetoothMinorClass_Uncategorized) = 0, ComputerDesktop (BluetoothMinorClass_ComputerDesktop) = 1, ComputerServer (BluetoothMinorClass_ComputerServer) = 2, ComputerLaptop (BluetoothMinorClass_ComputerLaptop) = 3, ComputerHandheld (BluetoothMinorClass_ComputerHandheld) = 4, ComputerPalmSize (BluetoothMinorClass_ComputerPalmSize) = 5, ComputerWearable (BluetoothMinorClass_ComputerWearable) = 6, ComputerTablet (BluetoothMinorClass_ComputerTablet) = 7, PhoneCellular (BluetoothMinorClass_PhoneCellular) = 1, PhoneCordless (BluetoothMinorClass_PhoneCordless) = 2, PhoneSmartPhone (BluetoothMinorClass_PhoneSmartPhone) = 3, PhoneWired (BluetoothMinorClass_PhoneWired) = 4, PhoneIsdn (BluetoothMinorClass_PhoneIsdn) = 5, NetworkFullyAvailable (BluetoothMinorClass_NetworkFullyAvailable) = 0, NetworkUsed01To17Percent (BluetoothMinorClass_NetworkUsed01To17Percent) = 8, NetworkUsed17To33Percent (BluetoothMinorClass_NetworkUsed17To33Percent) = 16, NetworkUsed33To50Percent (BluetoothMinorClass_NetworkUsed33To50Percent) = 24, NetworkUsed50To67Percent (BluetoothMinorClass_NetworkUsed50To67Percent) = 32, NetworkUsed67To83Percent (BluetoothMinorClass_NetworkUsed67To83Percent) = 40, NetworkUsed83To99Percent (BluetoothMinorClass_NetworkUsed83To99Percent) = 48, NetworkNoServiceAvailable (BluetoothMinorClass_NetworkNoServiceAvailable) = 56, AudioVideoWearableHeadset (BluetoothMinorClass_AudioVideoWearableHeadset) = 1, AudioVideoHandsFree (BluetoothMinorClass_AudioVideoHandsFree) = 2, AudioVideoMicrophone (BluetoothMinorClass_AudioVideoMicrophone) = 4, AudioVideoLoudspeaker (BluetoothMinorClass_AudioVideoLoudspeaker) = 5, AudioVideoHeadphones (BluetoothMinorClass_AudioVideoHeadphones) = 6, AudioVideoPortableAudio (BluetoothMinorClass_AudioVideoPortableAudio) = 7, AudioVideoCarAudio (BluetoothMinorClass_AudioVideoCarAudio) = 8, AudioVideoSetTopBox (BluetoothMinorClass_AudioVideoSetTopBox) = 9, AudioVideoHifiAudioDevice (BluetoothMinorClass_AudioVideoHifiAudioDevice) = 10, AudioVideoVcr (BluetoothMinorClass_AudioVideoVcr) = 11, AudioVideoVideoCamera (BluetoothMinorClass_AudioVideoVideoCamera) = 12, AudioVideoCamcorder (BluetoothMinorClass_AudioVideoCamcorder) = 13, AudioVideoVideoMonitor (BluetoothMinorClass_AudioVideoVideoMonitor) = 14, AudioVideoVideoDisplayAndLoudspeaker (BluetoothMinorClass_AudioVideoVideoDisplayAndLoudspeaker) = 15, AudioVideoVideoConferencing (BluetoothMinorClass_AudioVideoVideoConferencing) = 16, AudioVideoGamingOrToy (BluetoothMinorClass_AudioVideoGamingOrToy) = 18, PeripheralJoystick (BluetoothMinorClass_PeripheralJoystick) = 1, PeripheralGamepad (BluetoothMinorClass_PeripheralGamepad) = 2, PeripheralRemoteControl (BluetoothMinorClass_PeripheralRemoteControl) = 3, PeripheralSensing (BluetoothMinorClass_PeripheralSensing) = 4, PeripheralDigitizerTablet (BluetoothMinorClass_PeripheralDigitizerTablet) = 5, PeripheralCardReader (BluetoothMinorClass_PeripheralCardReader) = 6, PeripheralDigitalPen (BluetoothMinorClass_PeripheralDigitalPen) = 7, PeripheralHandheldScanner (BluetoothMinorClass_PeripheralHandheldScanner) = 8, PeripheralHandheldGesture (BluetoothMinorClass_PeripheralHandheldGesture) = 9, WearableWristwatch (BluetoothMinorClass_WearableWristwatch) = 1, WearablePager (BluetoothMinorClass_WearablePager) = 2, WearableJacket (BluetoothMinorClass_WearableJacket) = 3, WearableHelmet (BluetoothMinorClass_WearableHelmet) = 4, WearableGlasses (BluetoothMinorClass_WearableGlasses) = 5, ToyRobot (BluetoothMinorClass_ToyRobot) = 1, ToyVehicle (BluetoothMinorClass_ToyVehicle) = 2, ToyDoll (BluetoothMinorClass_ToyDoll) = 3, ToyController (BluetoothMinorClass_ToyController) = 4, ToyGame (BluetoothMinorClass_ToyGame) = 5, HealthBloodPressureMonitor (BluetoothMinorClass_HealthBloodPressureMonitor) = 1, HealthThermometer (BluetoothMinorClass_HealthThermometer) = 2, HealthWeighingScale (BluetoothMinorClass_HealthWeighingScale) = 3, HealthGlucoseMeter (BluetoothMinorClass_HealthGlucoseMeter) = 4, HealthPulseOximeter (BluetoothMinorClass_HealthPulseOximeter) = 5, HealthHeartRateMonitor (BluetoothMinorClass_HealthHeartRateMonitor) = 6, HealthHealthDataDisplay (BluetoothMinorClass_HealthHealthDataDisplay) = 7, HealthStepCounter (BluetoothMinorClass_HealthStepCounter) = 8, HealthBodyCompositionAnalyzer (BluetoothMinorClass_HealthBodyCompositionAnalyzer) = 9, HealthPeakFlowMonitor (BluetoothMinorClass_HealthPeakFlowMonitor) = 10, HealthMedicationMonitor (BluetoothMinorClass_HealthMedicationMonitor) = 11, HealthKneeProsthesis (BluetoothMinorClass_HealthKneeProsthesis) = 12, HealthAnkleProsthesis (BluetoothMinorClass_HealthAnkleProsthesis) = 13, HealthGenericHealthManager (BluetoothMinorClass_HealthGenericHealthManager) = 14, HealthPersonalMobilityDevice (BluetoothMinorClass_HealthPersonalMobilityDevice) = 15,
}}
RT_ENUM! { enum BluetoothServiceCapabilities: u32 {
    None (BluetoothServiceCapabilities_None) = 0, LimitedDiscoverableMode (BluetoothServiceCapabilities_LimitedDiscoverableMode) = 1, PositioningService (BluetoothServiceCapabilities_PositioningService) = 8, NetworkingService (BluetoothServiceCapabilities_NetworkingService) = 16, RenderingService (BluetoothServiceCapabilities_RenderingService) = 32, CapturingService (BluetoothServiceCapabilities_CapturingService) = 64, ObjectTransferService (BluetoothServiceCapabilities_ObjectTransferService) = 128, AudioService (BluetoothServiceCapabilities_AudioService) = 256, TelephoneService (BluetoothServiceCapabilities_TelephoneService) = 512, InformationService (BluetoothServiceCapabilities_InformationService) = 1024,
}}
DEFINE_IID!(IID_IBluetoothSignalStrengthFilter, 3749409681, 27573, 19710, 144, 177, 93, 115, 36, 237, 207, 127);
RT_INTERFACE!{interface IBluetoothSignalStrengthFilter(IBluetoothSignalStrengthFilterVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothSignalStrengthFilter] {
    fn get_InRangeThresholdInDBm(&self, out: *mut *mut super::super::foundation::IReference<i16>) -> HRESULT,
    fn put_InRangeThresholdInDBm(&self, value: *mut super::super::foundation::IReference<i16>) -> HRESULT,
    fn get_OutOfRangeThresholdInDBm(&self, out: *mut *mut super::super::foundation::IReference<i16>) -> HRESULT,
    fn put_OutOfRangeThresholdInDBm(&self, value: *mut super::super::foundation::IReference<i16>) -> HRESULT,
    fn get_OutOfRangeTimeout(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_OutOfRangeTimeout(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_SamplingInterval(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_SamplingInterval(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT
}}
impl IBluetoothSignalStrengthFilter {
    #[inline] pub unsafe fn get_in_range_threshold_in_dbm(&self) -> Result<ComPtr<super::super::foundation::IReference<i16>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InRangeThresholdInDBm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_in_range_threshold_in_dbm(&self, value: &super::super::foundation::IReference<i16>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InRangeThresholdInDBm)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_out_of_range_threshold_in_dbm(&self) -> Result<ComPtr<super::super::foundation::IReference<i16>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutOfRangeThresholdInDBm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_out_of_range_threshold_in_dbm(&self, value: &super::super::foundation::IReference<i16>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutOfRangeThresholdInDBm)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_out_of_range_timeout(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutOfRangeTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_out_of_range_timeout(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutOfRangeTimeout)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sampling_interval(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SamplingInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sampling_interval(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SamplingInterval)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothSignalStrengthFilter: IBluetoothSignalStrengthFilter}
impl RtActivatable<IActivationFactory> for BluetoothSignalStrengthFilter {}
DEFINE_CLSID!(BluetoothSignalStrengthFilter(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,83,105,103,110,97,108,83,116,114,101,110,103,116,104,70,105,108,116,101,114,0]) [CLSID_BluetoothSignalStrengthFilter]);
RT_CLASS!{static class BluetoothUuidHelper}
impl RtActivatable<IBluetoothUuidHelperStatics> for BluetoothUuidHelper {}
impl BluetoothUuidHelper {
    #[inline] pub fn from_short_id(shortId: u32) -> Result<Guid> { unsafe {
        <Self as RtActivatable<IBluetoothUuidHelperStatics>>::get_activation_factory().from_short_id(shortId)
    }}
    #[inline] pub fn try_get_short_id(uuid: Guid) -> Result<ComPtr<super::super::foundation::IReference<u32>>> { unsafe {
        <Self as RtActivatable<IBluetoothUuidHelperStatics>>::get_activation_factory().try_get_short_id(uuid)
    }}
}
DEFINE_CLSID!(BluetoothUuidHelper(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,108,117,101,116,111,111,116,104,85,117,105,100,72,101,108,112,101,114,0]) [CLSID_BluetoothUuidHelper]);
DEFINE_IID!(IID_IBluetoothUuidHelperStatics, 400493784, 53108, 19233, 175, 230, 245, 122, 17, 188, 222, 160);
RT_INTERFACE!{static interface IBluetoothUuidHelperStatics(IBluetoothUuidHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothUuidHelperStatics] {
    fn FromShortId(&self, shortId: u32, out: *mut Guid) -> HRESULT,
    fn TryGetShortId(&self, uuid: Guid, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT
}}
impl IBluetoothUuidHelperStatics {
    #[inline] pub unsafe fn from_short_id(&self, shortId: u32) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromShortId)(self as *const _ as *mut _, shortId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_short_id(&self, uuid: Guid) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetShortId)(self as *const _ as *mut _, uuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
pub mod rfcomm { // Windows.Devices.Bluetooth.Rfcomm
use ::prelude::*;
DEFINE_IID!(IID_IRfcommDeviceService, 2927755039, 50593, 19520, 140, 40, 243, 239, 214, 144, 98, 243);
RT_INTERFACE!{interface IRfcommDeviceService(IRfcommDeviceServiceVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommDeviceService] {
    #[cfg(not(feature="windows-networking"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-networking")] fn get_ConnectionHostName(&self, out: *mut *mut ::rt::gen::windows::networking::HostName) -> HRESULT,
    fn get_ConnectionServiceName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ServiceId(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    #[cfg(not(feature="windows-networking"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-networking")] fn get_ProtectionLevel(&self, out: *mut ::rt::gen::windows::networking::sockets::SocketProtectionLevel) -> HRESULT,
    #[cfg(not(feature="windows-networking"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-networking")] fn get_MaxProtectionLevel(&self, out: *mut ::rt::gen::windows::networking::sockets::SocketProtectionLevel) -> HRESULT,
    #[cfg(feature="windows-storage")] fn GetSdpRawAttributesAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IMapView<u32, ::rt::gen::windows::storage::streams::IBuffer>>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn GetSdpRawAttributesWithCacheModeAsync(&self, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IMapView<u32, ::rt::gen::windows::storage::streams::IBuffer>>) -> HRESULT
}}
impl IRfcommDeviceService {
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_connection_host_name(&self) -> Result<ComPtr<::rt::gen::windows::networking::HostName>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionHostName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_connection_service_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConnectionServiceName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_id(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_protection_level(&self) -> Result<::rt::gen::windows::networking::sockets::SocketProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_max_protection_level(&self) -> Result<::rt::gen::windows::networking::sockets::SocketProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_sdp_raw_attributes_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IMapView<u32, ::rt::gen::windows::storage::streams::IBuffer>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSdpRawAttributesAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_sdp_raw_attributes_with_cache_mode_async(&self, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IMapView<u32, ::rt::gen::windows::storage::streams::IBuffer>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSdpRawAttributesWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommDeviceService: IRfcommDeviceService}
impl RtActivatable<IRfcommDeviceServiceStatics> for RfcommDeviceService {}
impl RtActivatable<IRfcommDeviceServiceStatics2> for RfcommDeviceService {}
impl RfcommDeviceService {
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<RfcommDeviceService>>> { unsafe {
        <Self as RtActivatable<IRfcommDeviceServiceStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn get_device_selector(serviceId: &RfcommServiceId) -> Result<HString> { unsafe {
        <Self as RtActivatable<IRfcommDeviceServiceStatics>>::get_activation_factory().get_device_selector(serviceId)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device(bluetoothDevice: &super::BluetoothDevice) -> Result<HString> { unsafe {
        <Self as RtActivatable<IRfcommDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device(bluetoothDevice)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_with_cache_mode(bluetoothDevice: &super::BluetoothDevice, cacheMode: super::BluetoothCacheMode) -> Result<HString> { unsafe {
        <Self as RtActivatable<IRfcommDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_with_cache_mode(bluetoothDevice, cacheMode)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_and_service_id(bluetoothDevice: &super::BluetoothDevice, serviceId: &RfcommServiceId) -> Result<HString> { unsafe {
        <Self as RtActivatable<IRfcommDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_and_service_id(bluetoothDevice, serviceId)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_and_service_id_with_cache_mode(bluetoothDevice: &super::BluetoothDevice, serviceId: &RfcommServiceId, cacheMode: super::BluetoothCacheMode) -> Result<HString> { unsafe {
        <Self as RtActivatable<IRfcommDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_and_service_id_with_cache_mode(bluetoothDevice, serviceId, cacheMode)
    }}
}
DEFINE_CLSID!(RfcommDeviceService(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,82,102,99,111,109,109,46,82,102,99,111,109,109,68,101,118,105,99,101,83,101,114,118,105,99,101,0]) [CLSID_RfcommDeviceService]);
DEFINE_IID!(IID_IRfcommDeviceService2, 1399647508, 60365, 18942, 191, 159, 64, 239, 198, 137, 178, 13);
RT_INTERFACE!{interface IRfcommDeviceService2(IRfcommDeviceService2Vtbl): IInspectable(IInspectableVtbl) [IID_IRfcommDeviceService2] {
    fn get_Device(&self, out: *mut *mut super::BluetoothDevice) -> HRESULT
}}
impl IRfcommDeviceService2 {
    #[inline] pub unsafe fn get_device(&self) -> Result<ComPtr<super::BluetoothDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Device)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRfcommDeviceService3, 472034534, 56644, 19747, 134, 109, 143, 52, 134, 238, 100, 144);
RT_INTERFACE!{interface IRfcommDeviceService3(IRfcommDeviceService3Vtbl): IInspectable(IInspectableVtbl) [IID_IRfcommDeviceService3] {
    fn get_DeviceAccessInformation(&self, out: *mut *mut super::super::enumeration::DeviceAccessInformation) -> HRESULT,
    fn RequestAccessAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<super::super::enumeration::DeviceAccessStatus>) -> HRESULT
}}
impl IRfcommDeviceService3 {
    #[inline] pub unsafe fn get_device_access_information(&self) -> Result<ComPtr<super::super::enumeration::DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceAccessInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<super::super::enumeration::DeviceAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRfcommDeviceServicesResult, 994588812, 31951, 18574, 150, 37, 210, 89, 165, 115, 45, 85);
RT_INTERFACE!{interface IRfcommDeviceServicesResult(IRfcommDeviceServicesResultVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommDeviceServicesResult] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT,
    fn get_Services(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<RfcommDeviceService>) -> HRESULT
}}
impl IRfcommDeviceServicesResult {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_services(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<RfcommDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Services)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommDeviceServicesResult: IRfcommDeviceServicesResult}
DEFINE_IID!(IID_IRfcommDeviceServiceStatics, 2762033647, 25197, 16812, 178, 83, 135, 172, 92, 39, 226, 138);
RT_INTERFACE!{static interface IRfcommDeviceServiceStatics(IRfcommDeviceServiceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommDeviceServiceStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<RfcommDeviceService>) -> HRESULT,
    fn GetDeviceSelector(&self, serviceId: *mut RfcommServiceId, out: *mut HSTRING) -> HRESULT
}}
impl IRfcommDeviceServiceStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<RfcommDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self, serviceId: &RfcommServiceId) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, serviceId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRfcommDeviceServiceStatics2, 2861347273, 59277, 19428, 128, 118, 10, 61, 135, 160, 160, 95);
RT_INTERFACE!{static interface IRfcommDeviceServiceStatics2(IRfcommDeviceServiceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IRfcommDeviceServiceStatics2] {
    fn GetDeviceSelectorForBluetoothDevice(&self, bluetoothDevice: *mut super::BluetoothDevice, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceWithCacheMode(&self, bluetoothDevice: *mut super::BluetoothDevice, cacheMode: super::BluetoothCacheMode, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceAndServiceId(&self, bluetoothDevice: *mut super::BluetoothDevice, serviceId: *mut RfcommServiceId, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceAndServiceIdWithCacheMode(&self, bluetoothDevice: *mut super::BluetoothDevice, serviceId: *mut RfcommServiceId, cacheMode: super::BluetoothCacheMode, out: *mut HSTRING) -> HRESULT
}}
impl IRfcommDeviceServiceStatics2 {
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device(&self, bluetoothDevice: &super::BluetoothDevice) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDevice)(self as *const _ as *mut _, bluetoothDevice as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_with_cache_mode(&self, bluetoothDevice: &super::BluetoothDevice, cacheMode: super::BluetoothCacheMode) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceWithCacheMode)(self as *const _ as *mut _, bluetoothDevice as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_and_service_id(&self, bluetoothDevice: &super::BluetoothDevice, serviceId: &RfcommServiceId) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceAndServiceId)(self as *const _ as *mut _, bluetoothDevice as *const _ as *mut _, serviceId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_and_service_id_with_cache_mode(&self, bluetoothDevice: &super::BluetoothDevice, serviceId: &RfcommServiceId, cacheMode: super::BluetoothCacheMode) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceAndServiceIdWithCacheMode)(self as *const _ as *mut _, bluetoothDevice as *const _ as *mut _, serviceId as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRfcommServiceId, 576885252, 32258, 16407, 129, 54, 218, 27, 106, 27, 155, 191);
RT_INTERFACE!{interface IRfcommServiceId(IRfcommServiceIdVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommServiceId] {
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    fn AsShortId(&self, out: *mut u32) -> HRESULT,
    fn AsString(&self, out: *mut HSTRING) -> HRESULT
}}
impl IRfcommServiceId {
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn as_short_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).AsShortId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn as_string(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AsString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommServiceId: IRfcommServiceId}
impl RtActivatable<IRfcommServiceIdStatics> for RfcommServiceId {}
impl RfcommServiceId {
    #[inline] pub fn from_uuid(uuid: Guid) -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().from_uuid(uuid)
    }}
    #[inline] pub fn from_short_id(shortId: u32) -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().from_short_id(shortId)
    }}
    #[inline] pub fn get_serial_port() -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().get_serial_port()
    }}
    #[inline] pub fn get_obex_object_push() -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().get_obex_object_push()
    }}
    #[inline] pub fn get_obex_file_transfer() -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().get_obex_file_transfer()
    }}
    #[inline] pub fn get_phone_book_access_pce() -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().get_phone_book_access_pce()
    }}
    #[inline] pub fn get_phone_book_access_pse() -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().get_phone_book_access_pse()
    }}
    #[inline] pub fn get_generic_file_transfer() -> Result<ComPtr<RfcommServiceId>> { unsafe {
        <Self as RtActivatable<IRfcommServiceIdStatics>>::get_activation_factory().get_generic_file_transfer()
    }}
}
DEFINE_CLSID!(RfcommServiceId(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,82,102,99,111,109,109,46,82,102,99,111,109,109,83,101,114,118,105,99,101,73,100,0]) [CLSID_RfcommServiceId]);
DEFINE_IID!(IID_IRfcommServiceIdStatics, 706191034, 43381, 18147, 181, 107, 8, 255, 215, 131, 165, 254);
RT_INTERFACE!{static interface IRfcommServiceIdStatics(IRfcommServiceIdStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommServiceIdStatics] {
    fn FromUuid(&self, uuid: Guid, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn FromShortId(&self, shortId: u32, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn get_SerialPort(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn get_ObexObjectPush(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn get_ObexFileTransfer(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn get_PhoneBookAccessPce(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn get_PhoneBookAccessPse(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    fn get_GenericFileTransfer(&self, out: *mut *mut RfcommServiceId) -> HRESULT
}}
impl IRfcommServiceIdStatics {
    #[inline] pub unsafe fn from_uuid(&self, uuid: Guid) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromUuid)(self as *const _ as *mut _, uuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_short_id(&self, shortId: u32) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromShortId)(self as *const _ as *mut _, shortId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_serial_port(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SerialPort)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_obex_object_push(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ObexObjectPush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_obex_file_transfer(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ObexFileTransfer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone_book_access_pce(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneBookAccessPce)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone_book_access_pse(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneBookAccessPse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_generic_file_transfer(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GenericFileTransfer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRfcommServiceProvider, 3940285892, 45558, 17663, 159, 124, 231, 168, 42, 184, 104, 33);
RT_INTERFACE!{interface IRfcommServiceProvider(IRfcommServiceProviderVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommServiceProvider] {
    fn get_ServiceId(&self, out: *mut *mut RfcommServiceId) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SdpRawAttributes(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMap<u32, ::rt::gen::windows::storage::streams::IBuffer>) -> HRESULT,
    #[cfg(not(feature="windows-networking"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-networking")] fn StartAdvertising(&self, listener: *mut ::rt::gen::windows::networking::sockets::StreamSocketListener) -> HRESULT,
    fn StopAdvertising(&self) -> HRESULT
}}
impl IRfcommServiceProvider {
    #[inline] pub unsafe fn get_service_id(&self) -> Result<ComPtr<RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_sdp_raw_attributes(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMap<u32, ::rt::gen::windows::storage::streams::IBuffer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SdpRawAttributes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn start_advertising(&self, listener: &::rt::gen::windows::networking::sockets::StreamSocketListener) -> Result<()> {
        let hr = ((*self.lpVtbl).StartAdvertising)(self as *const _ as *mut _, listener as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_advertising(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopAdvertising)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommServiceProvider: IRfcommServiceProvider}
impl RtActivatable<IRfcommServiceProviderStatics> for RfcommServiceProvider {}
impl RfcommServiceProvider {
    #[inline] pub fn create_async(serviceId: &RfcommServiceId) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<RfcommServiceProvider>>> { unsafe {
        <Self as RtActivatable<IRfcommServiceProviderStatics>>::get_activation_factory().create_async(serviceId)
    }}
}
DEFINE_CLSID!(RfcommServiceProvider(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,82,102,99,111,109,109,46,82,102,99,111,109,109,83,101,114,118,105,99,101,80,114,111,118,105,100,101,114,0]) [CLSID_RfcommServiceProvider]);
DEFINE_IID!(IID_IRfcommServiceProvider2, 1936449478, 15489, 19742, 186, 242, 221, 187, 129, 40, 69, 18);
RT_INTERFACE!{interface IRfcommServiceProvider2(IRfcommServiceProvider2Vtbl): IInspectable(IInspectableVtbl) [IID_IRfcommServiceProvider2] {
    #[cfg(feature="windows-networking")] fn StartAdvertisingWithRadioDiscoverability(&self, listener: *mut ::rt::gen::windows::networking::sockets::StreamSocketListener, radioDiscoverable: bool) -> HRESULT
}}
impl IRfcommServiceProvider2 {
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn start_advertising_with_radio_discoverability(&self, listener: &::rt::gen::windows::networking::sockets::StreamSocketListener, radioDiscoverable: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).StartAdvertisingWithRadioDiscoverability)(self as *const _ as *mut _, listener as *const _ as *mut _, radioDiscoverable);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRfcommServiceProviderStatics, 2559083267, 27082, 16698, 132, 247, 67, 68, 199, 41, 41, 151);
RT_INTERFACE!{static interface IRfcommServiceProviderStatics(IRfcommServiceProviderStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommServiceProviderStatics] {
    fn CreateAsync(&self, serviceId: *mut RfcommServiceId, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<RfcommServiceProvider>) -> HRESULT
}}
impl IRfcommServiceProviderStatics {
    #[inline] pub unsafe fn create_async(&self, serviceId: &RfcommServiceId) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<RfcommServiceProvider>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAsync)(self as *const _ as *mut _, serviceId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Devices.Bluetooth.Rfcomm
pub mod genericattributeprofile { // Windows.Devices.Bluetooth.GenericAttributeProfile
use ::prelude::*;
DEFINE_IID!(IID_IGattCharacteristic, 1506496705, 22836, 20328, 161, 152, 235, 134, 79, 164, 78, 107);
RT_INTERFACE!{interface IGattCharacteristic(IGattCharacteristicVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristic] {
    fn GetDescriptors(&self, descriptorUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDescriptor>) -> HRESULT,
    fn get_CharacteristicProperties(&self, out: *mut GattCharacteristicProperties) -> HRESULT,
    fn get_ProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn put_ProtectionLevel(&self, value: GattProtectionLevel) -> HRESULT,
    fn get_UserDescription(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    fn get_AttributeHandle(&self, out: *mut u16) -> HRESULT,
    fn get_PresentationFormats(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattPresentationFormat>) -> HRESULT,
    fn ReadValueAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>) -> HRESULT,
    fn ReadValueWithCacheModeAsync(&self, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-storage")] fn WriteValueAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy11(&self) -> (),
    #[cfg(feature="windows-storage")] fn WriteValueWithOptionAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, writeOption: GattWriteOption, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>) -> HRESULT,
    fn ReadClientCharacteristicConfigurationDescriptorAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattReadClientCharacteristicConfigurationDescriptorResult>) -> HRESULT,
    fn WriteClientCharacteristicConfigurationDescriptorAsync(&self, clientCharacteristicConfigurationDescriptorValue: GattClientCharacteristicConfigurationDescriptorValue, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>) -> HRESULT,
    fn add_ValueChanged(&self, valueChangedHandler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattCharacteristic, GattValueChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ValueChanged(&self, valueChangedEventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGattCharacteristic {
    #[inline] pub unsafe fn get_descriptors(&self, descriptorUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDescriptor>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDescriptors)(self as *const _ as *mut _, descriptorUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristic_properties(&self) -> Result<GattCharacteristicProperties> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_protection_level(&self, value: GattProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_attribute_handle(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttributeHandle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_presentation_formats(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattPresentationFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PresentationFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_value_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadValueAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_value_with_cache_mode_async(&self, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadValueWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteValueAsync)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value_with_option_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer, writeOption: GattWriteOption) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteValueWithOptionAsync)(self as *const _ as *mut _, value as *const _ as *mut _, writeOption, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_client_characteristic_configuration_descriptor_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattReadClientCharacteristicConfigurationDescriptorResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadClientCharacteristicConfigurationDescriptorAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_client_characteristic_configuration_descriptor_async(&self, clientCharacteristicConfigurationDescriptorValue: GattClientCharacteristicConfigurationDescriptorValue) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteClientCharacteristicConfigurationDescriptorAsync)(self as *const _ as *mut _, clientCharacteristicConfigurationDescriptorValue, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_value_changed(&self, valueChangedHandler: &::rt::gen::windows::foundation::TypedEventHandler<GattCharacteristic, GattValueChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ValueChanged)(self as *const _ as *mut _, valueChangedHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_value_changed(&self, valueChangedEventCookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ValueChanged)(self as *const _ as *mut _, valueChangedEventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattCharacteristic: IGattCharacteristic}
impl RtActivatable<IGattCharacteristicStatics> for GattCharacteristic {}
impl GattCharacteristic {
    #[inline] pub fn convert_short_id_to_uuid(shortId: u16) -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicStatics>>::get_activation_factory().convert_short_id_to_uuid(shortId)
    }}
}
DEFINE_CLSID!(GattCharacteristic(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,67,104,97,114,97,99,116,101,114,105,115,116,105,99,0]) [CLSID_GattCharacteristic]);
DEFINE_IID!(IID_IGattCharacteristic2, 2920985976, 60422, 18276, 183, 128, 152, 53, 161, 211, 93, 110);
RT_INTERFACE!{interface IGattCharacteristic2(IGattCharacteristic2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristic2] {
    fn get_Service(&self, out: *mut *mut GattDeviceService) -> HRESULT,
    fn GetAllDescriptors(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDescriptor>) -> HRESULT
}}
impl IGattCharacteristic2 {
    #[inline] pub unsafe fn get_service(&self) -> Result<ComPtr<GattDeviceService>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Service)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_descriptors(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDescriptor>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllDescriptors)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattCharacteristic3, 1060922942, 37844, 16491, 184, 23, 219, 129, 248, 237, 83, 179);
RT_INTERFACE!{interface IGattCharacteristic3(IGattCharacteristic3Vtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristic3] {
    fn GetDescriptorsAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>) -> HRESULT,
    fn GetDescriptorsWithCacheModeAsync(&self, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>) -> HRESULT,
    fn GetDescriptorsForUuidAsync(&self, descriptorUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>) -> HRESULT,
    fn GetDescriptorsForUuidWithCacheModeAsync(&self, descriptorUuid: Guid, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn WriteValueWithResultAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-storage")] fn WriteValueWithResultAndOptionAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, writeOption: GattWriteOption, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>) -> HRESULT,
    fn WriteClientCharacteristicConfigurationDescriptorWithResultAsync(&self, clientCharacteristicConfigurationDescriptorValue: GattClientCharacteristicConfigurationDescriptorValue, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>) -> HRESULT
}}
impl IGattCharacteristic3 {
    #[inline] pub unsafe fn get_descriptors_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDescriptorsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_descriptors_with_cache_mode_async(&self, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDescriptorsWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_descriptors_for_uuid_async(&self, descriptorUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDescriptorsForUuidAsync)(self as *const _ as *mut _, descriptorUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_descriptors_for_uuid_with_cache_mode_async(&self, descriptorUuid: Guid, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDescriptorsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDescriptorsForUuidWithCacheModeAsync)(self as *const _ as *mut _, descriptorUuid, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value_with_result_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteValueWithResultAsync)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value_with_result_and_option_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer, writeOption: GattWriteOption) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteValueWithResultAndOptionAsync)(self as *const _ as *mut _, value as *const _ as *mut _, writeOption, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn write_client_characteristic_configuration_descriptor_with_result_async(&self, clientCharacteristicConfigurationDescriptorValue: GattClientCharacteristicConfigurationDescriptorValue) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteClientCharacteristicConfigurationDescriptorWithResultAsync)(self as *const _ as *mut _, clientCharacteristicConfigurationDescriptorValue, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum GattCharacteristicProperties: u32 {
    None (GattCharacteristicProperties_None) = 0, Broadcast (GattCharacteristicProperties_Broadcast) = 1, Read (GattCharacteristicProperties_Read) = 2, WriteWithoutResponse (GattCharacteristicProperties_WriteWithoutResponse) = 4, Write (GattCharacteristicProperties_Write) = 8, Notify (GattCharacteristicProperties_Notify) = 16, Indicate (GattCharacteristicProperties_Indicate) = 32, AuthenticatedSignedWrites (GattCharacteristicProperties_AuthenticatedSignedWrites) = 64, ExtendedProperties (GattCharacteristicProperties_ExtendedProperties) = 128, ReliableWrites (GattCharacteristicProperties_ReliableWrites) = 256, WritableAuxiliaries (GattCharacteristicProperties_WritableAuxiliaries) = 512,
}}
DEFINE_IID!(IID_IGattCharacteristicsResult, 294949980, 45655, 20286, 157, 183, 246, 139, 201, 169, 174, 242);
RT_INTERFACE!{interface IGattCharacteristicsResult(IGattCharacteristicsResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicsResult] {
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT,
    fn get_Characteristics(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattCharacteristic>) -> HRESULT
}}
impl IGattCharacteristicsResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattCharacteristic>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattCharacteristicsResult: IGattCharacteristicsResult}
DEFINE_IID!(IID_IGattCharacteristicStatics, 1506496707, 22836, 20328, 161, 152, 235, 134, 79, 164, 78, 107);
RT_INTERFACE!{static interface IGattCharacteristicStatics(IGattCharacteristicStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicStatics] {
    fn ConvertShortIdToUuid(&self, shortId: u16, out: *mut Guid) -> HRESULT
}}
impl IGattCharacteristicStatics {
    #[inline] pub unsafe fn convert_short_id_to_uuid(&self, shortId: u16) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ConvertShortIdToUuid)(self as *const _ as *mut _, shortId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{static class GattCharacteristicUuids}
impl RtActivatable<IGattCharacteristicUuidsStatics> for GattCharacteristicUuids {}
impl RtActivatable<IGattCharacteristicUuidsStatics2> for GattCharacteristicUuids {}
impl GattCharacteristicUuids {
    #[inline] pub fn get_battery_level() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_battery_level()
    }}
    #[inline] pub fn get_blood_pressure_feature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_blood_pressure_feature()
    }}
    #[inline] pub fn get_blood_pressure_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_blood_pressure_measurement()
    }}
    #[inline] pub fn get_body_sensor_location() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_body_sensor_location()
    }}
    #[inline] pub fn get_csc_feature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_csc_feature()
    }}
    #[inline] pub fn get_csc_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_csc_measurement()
    }}
    #[inline] pub fn get_glucose_feature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_glucose_feature()
    }}
    #[inline] pub fn get_glucose_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_glucose_measurement()
    }}
    #[inline] pub fn get_glucose_measurement_context() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_glucose_measurement_context()
    }}
    #[inline] pub fn get_heart_rate_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_heart_rate_control_point()
    }}
    #[inline] pub fn get_heart_rate_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_heart_rate_measurement()
    }}
    #[inline] pub fn get_intermediate_cuff_pressure() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_intermediate_cuff_pressure()
    }}
    #[inline] pub fn get_intermediate_temperature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_intermediate_temperature()
    }}
    #[inline] pub fn get_measurement_interval() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_measurement_interval()
    }}
    #[inline] pub fn get_record_access_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_record_access_control_point()
    }}
    #[inline] pub fn get_rsc_feature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_rsc_feature()
    }}
    #[inline] pub fn get_rsc_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_rsc_measurement()
    }}
    #[inline] pub fn get_sccontrol_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_sccontrol_point()
    }}
    #[inline] pub fn get_sensor_location() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_sensor_location()
    }}
    #[inline] pub fn get_temperature_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_temperature_measurement()
    }}
    #[inline] pub fn get_temperature_type() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics>>::get_activation_factory().get_temperature_type()
    }}
    #[inline] pub fn get_alert_category_id() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_alert_category_id()
    }}
    #[inline] pub fn get_alert_category_id_bit_mask() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_alert_category_id_bit_mask()
    }}
    #[inline] pub fn get_alert_level() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_alert_level()
    }}
    #[inline] pub fn get_alert_notification_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_alert_notification_control_point()
    }}
    #[inline] pub fn get_alert_status() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_alert_status()
    }}
    #[inline] pub fn get_gap_appearance() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_gap_appearance()
    }}
    #[inline] pub fn get_boot_keyboard_input_report() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_boot_keyboard_input_report()
    }}
    #[inline] pub fn get_boot_keyboard_output_report() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_boot_keyboard_output_report()
    }}
    #[inline] pub fn get_boot_mouse_input_report() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_boot_mouse_input_report()
    }}
    #[inline] pub fn get_current_time() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_current_time()
    }}
    #[inline] pub fn get_cycling_power_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_cycling_power_control_point()
    }}
    #[inline] pub fn get_cycling_power_feature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_cycling_power_feature()
    }}
    #[inline] pub fn get_cycling_power_measurement() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_cycling_power_measurement()
    }}
    #[inline] pub fn get_cycling_power_vector() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_cycling_power_vector()
    }}
    #[inline] pub fn get_date_time() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_date_time()
    }}
    #[inline] pub fn get_day_date_time() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_day_date_time()
    }}
    #[inline] pub fn get_day_of_week() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_day_of_week()
    }}
    #[inline] pub fn get_gap_device_name() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_gap_device_name()
    }}
    #[inline] pub fn get_dst_offset() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_dst_offset()
    }}
    #[inline] pub fn get_exact_time256() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_exact_time256()
    }}
    #[inline] pub fn get_firmware_revision_string() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_firmware_revision_string()
    }}
    #[inline] pub fn get_hardware_revision_string() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_hardware_revision_string()
    }}
    #[inline] pub fn get_hid_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_hid_control_point()
    }}
    #[inline] pub fn get_hid_information() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_hid_information()
    }}
    #[inline] pub fn get_ieee1107320601_regulatory_certification_data_list() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_ieee1107320601_regulatory_certification_data_list()
    }}
    #[inline] pub fn get_ln_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_ln_control_point()
    }}
    #[inline] pub fn get_ln_feature() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_ln_feature()
    }}
    #[inline] pub fn get_local_time_information() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_local_time_information()
    }}
    #[inline] pub fn get_location_and_speed() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_location_and_speed()
    }}
    #[inline] pub fn get_manufacturer_name_string() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_manufacturer_name_string()
    }}
    #[inline] pub fn get_model_number_string() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_model_number_string()
    }}
    #[inline] pub fn get_navigation() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_navigation()
    }}
    #[inline] pub fn get_new_alert() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_new_alert()
    }}
    #[inline] pub fn get_gap_peripheral_preferred_connection_parameters() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_gap_peripheral_preferred_connection_parameters()
    }}
    #[inline] pub fn get_gap_peripheral_privacy_flag() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_gap_peripheral_privacy_flag()
    }}
    #[inline] pub fn get_pnp_id() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_pnp_id()
    }}
    #[inline] pub fn get_position_quality() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_position_quality()
    }}
    #[inline] pub fn get_protocol_mode() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_protocol_mode()
    }}
    #[inline] pub fn get_gap_reconnection_address() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_gap_reconnection_address()
    }}
    #[inline] pub fn get_reference_time_information() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_reference_time_information()
    }}
    #[inline] pub fn get_report() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_report()
    }}
    #[inline] pub fn get_report_map() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_report_map()
    }}
    #[inline] pub fn get_ringer_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_ringer_control_point()
    }}
    #[inline] pub fn get_ringer_setting() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_ringer_setting()
    }}
    #[inline] pub fn get_scan_interval_window() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_scan_interval_window()
    }}
    #[inline] pub fn get_scan_refresh() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_scan_refresh()
    }}
    #[inline] pub fn get_serial_number_string() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_serial_number_string()
    }}
    #[inline] pub fn get_gatt_service_changed() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_gatt_service_changed()
    }}
    #[inline] pub fn get_software_revision_string() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_software_revision_string()
    }}
    #[inline] pub fn get_supported_new_alert_category() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_supported_new_alert_category()
    }}
    #[inline] pub fn get_support_unread_alert_category() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_support_unread_alert_category()
    }}
    #[inline] pub fn get_system_id() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_system_id()
    }}
    #[inline] pub fn get_time_accuracy() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_time_accuracy()
    }}
    #[inline] pub fn get_time_source() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_time_source()
    }}
    #[inline] pub fn get_time_update_control_point() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_time_update_control_point()
    }}
    #[inline] pub fn get_time_update_state() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_time_update_state()
    }}
    #[inline] pub fn get_time_with_dst() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_time_with_dst()
    }}
    #[inline] pub fn get_time_zone() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_time_zone()
    }}
    #[inline] pub fn get_tx_power_level() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_tx_power_level()
    }}
    #[inline] pub fn get_unread_alert_status() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattCharacteristicUuidsStatics2>>::get_activation_factory().get_unread_alert_status()
    }}
}
DEFINE_CLSID!(GattCharacteristicUuids(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,67,104,97,114,97,99,116,101,114,105,115,116,105,99,85,117,105,100,115,0]) [CLSID_GattCharacteristicUuids]);
DEFINE_IID!(IID_IGattCharacteristicUuidsStatics, 1492796806, 45534, 18188, 183, 222, 13, 17, 255, 68, 244, 183);
RT_INTERFACE!{static interface IGattCharacteristicUuidsStatics(IGattCharacteristicUuidsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicUuidsStatics] {
    fn get_BatteryLevel(&self, out: *mut Guid) -> HRESULT,
    fn get_BloodPressureFeature(&self, out: *mut Guid) -> HRESULT,
    fn get_BloodPressureMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_BodySensorLocation(&self, out: *mut Guid) -> HRESULT,
    fn get_CscFeature(&self, out: *mut Guid) -> HRESULT,
    fn get_CscMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_GlucoseFeature(&self, out: *mut Guid) -> HRESULT,
    fn get_GlucoseMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_GlucoseMeasurementContext(&self, out: *mut Guid) -> HRESULT,
    fn get_HeartRateControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_HeartRateMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_IntermediateCuffPressure(&self, out: *mut Guid) -> HRESULT,
    fn get_IntermediateTemperature(&self, out: *mut Guid) -> HRESULT,
    fn get_MeasurementInterval(&self, out: *mut Guid) -> HRESULT,
    fn get_RecordAccessControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_RscFeature(&self, out: *mut Guid) -> HRESULT,
    fn get_RscMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_SCControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_SensorLocation(&self, out: *mut Guid) -> HRESULT,
    fn get_TemperatureMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_TemperatureType(&self, out: *mut Guid) -> HRESULT
}}
impl IGattCharacteristicUuidsStatics {
    #[inline] pub unsafe fn get_battery_level(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BatteryLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blood_pressure_feature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BloodPressureFeature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blood_pressure_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BloodPressureMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body_sensor_location(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BodySensorLocation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_csc_feature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CscFeature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_csc_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CscMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_glucose_feature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GlucoseFeature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_glucose_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GlucoseMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_glucose_measurement_context(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GlucoseMeasurementContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_heart_rate_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HeartRateControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_heart_rate_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HeartRateMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_intermediate_cuff_pressure(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IntermediateCuffPressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_intermediate_temperature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IntermediateTemperature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_measurement_interval(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MeasurementInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_record_access_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RecordAccessControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rsc_feature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RscFeature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rsc_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RscMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sccontrol_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SCControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sensor_location(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SensorLocation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_temperature_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TemperatureMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_temperature_type(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TemperatureType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattCharacteristicUuidsStatics2, 408269861, 54382, 18988, 156, 63, 237, 109, 234, 41, 231, 190);
RT_INTERFACE!{static interface IGattCharacteristicUuidsStatics2(IGattCharacteristicUuidsStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicUuidsStatics2] {
    fn get_AlertCategoryId(&self, out: *mut Guid) -> HRESULT,
    fn get_AlertCategoryIdBitMask(&self, out: *mut Guid) -> HRESULT,
    fn get_AlertLevel(&self, out: *mut Guid) -> HRESULT,
    fn get_AlertNotificationControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_AlertStatus(&self, out: *mut Guid) -> HRESULT,
    fn get_GapAppearance(&self, out: *mut Guid) -> HRESULT,
    fn get_BootKeyboardInputReport(&self, out: *mut Guid) -> HRESULT,
    fn get_BootKeyboardOutputReport(&self, out: *mut Guid) -> HRESULT,
    fn get_BootMouseInputReport(&self, out: *mut Guid) -> HRESULT,
    fn get_CurrentTime(&self, out: *mut Guid) -> HRESULT,
    fn get_CyclingPowerControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_CyclingPowerFeature(&self, out: *mut Guid) -> HRESULT,
    fn get_CyclingPowerMeasurement(&self, out: *mut Guid) -> HRESULT,
    fn get_CyclingPowerVector(&self, out: *mut Guid) -> HRESULT,
    fn get_DateTime(&self, out: *mut Guid) -> HRESULT,
    fn get_DayDateTime(&self, out: *mut Guid) -> HRESULT,
    fn get_DayOfWeek(&self, out: *mut Guid) -> HRESULT,
    fn get_GapDeviceName(&self, out: *mut Guid) -> HRESULT,
    fn get_DstOffset(&self, out: *mut Guid) -> HRESULT,
    fn get_ExactTime256(&self, out: *mut Guid) -> HRESULT,
    fn get_FirmwareRevisionString(&self, out: *mut Guid) -> HRESULT,
    fn get_HardwareRevisionString(&self, out: *mut Guid) -> HRESULT,
    fn get_HidControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_HidInformation(&self, out: *mut Guid) -> HRESULT,
    fn get_Ieee1107320601RegulatoryCertificationDataList(&self, out: *mut Guid) -> HRESULT,
    fn get_LnControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_LnFeature(&self, out: *mut Guid) -> HRESULT,
    fn get_LocalTimeInformation(&self, out: *mut Guid) -> HRESULT,
    fn get_LocationAndSpeed(&self, out: *mut Guid) -> HRESULT,
    fn get_ManufacturerNameString(&self, out: *mut Guid) -> HRESULT,
    fn get_ModelNumberString(&self, out: *mut Guid) -> HRESULT,
    fn get_Navigation(&self, out: *mut Guid) -> HRESULT,
    fn get_NewAlert(&self, out: *mut Guid) -> HRESULT,
    fn get_GapPeripheralPreferredConnectionParameters(&self, out: *mut Guid) -> HRESULT,
    fn get_GapPeripheralPrivacyFlag(&self, out: *mut Guid) -> HRESULT,
    fn get_PnpId(&self, out: *mut Guid) -> HRESULT,
    fn get_PositionQuality(&self, out: *mut Guid) -> HRESULT,
    fn get_ProtocolMode(&self, out: *mut Guid) -> HRESULT,
    fn get_GapReconnectionAddress(&self, out: *mut Guid) -> HRESULT,
    fn get_ReferenceTimeInformation(&self, out: *mut Guid) -> HRESULT,
    fn get_Report(&self, out: *mut Guid) -> HRESULT,
    fn get_ReportMap(&self, out: *mut Guid) -> HRESULT,
    fn get_RingerControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_RingerSetting(&self, out: *mut Guid) -> HRESULT,
    fn get_ScanIntervalWindow(&self, out: *mut Guid) -> HRESULT,
    fn get_ScanRefresh(&self, out: *mut Guid) -> HRESULT,
    fn get_SerialNumberString(&self, out: *mut Guid) -> HRESULT,
    fn get_GattServiceChanged(&self, out: *mut Guid) -> HRESULT,
    fn get_SoftwareRevisionString(&self, out: *mut Guid) -> HRESULT,
    fn get_SupportedNewAlertCategory(&self, out: *mut Guid) -> HRESULT,
    fn get_SupportUnreadAlertCategory(&self, out: *mut Guid) -> HRESULT,
    fn get_SystemId(&self, out: *mut Guid) -> HRESULT,
    fn get_TimeAccuracy(&self, out: *mut Guid) -> HRESULT,
    fn get_TimeSource(&self, out: *mut Guid) -> HRESULT,
    fn get_TimeUpdateControlPoint(&self, out: *mut Guid) -> HRESULT,
    fn get_TimeUpdateState(&self, out: *mut Guid) -> HRESULT,
    fn get_TimeWithDst(&self, out: *mut Guid) -> HRESULT,
    fn get_TimeZone(&self, out: *mut Guid) -> HRESULT,
    fn get_TxPowerLevel(&self, out: *mut Guid) -> HRESULT,
    fn get_UnreadAlertStatus(&self, out: *mut Guid) -> HRESULT
}}
impl IGattCharacteristicUuidsStatics2 {
    #[inline] pub unsafe fn get_alert_category_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlertCategoryId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_alert_category_id_bit_mask(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlertCategoryIdBitMask)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_alert_level(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlertLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_alert_notification_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlertNotificationControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_alert_status(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlertStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gap_appearance(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GapAppearance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_boot_keyboard_input_report(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BootKeyboardInputReport)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_boot_keyboard_output_report(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BootKeyboardOutputReport)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_boot_mouse_input_report(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BootMouseInputReport)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_time(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_power_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingPowerControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_power_feature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingPowerFeature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_power_measurement(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingPowerMeasurement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_power_vector(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingPowerVector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_time(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DateTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_date_time(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayDateTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_of_week(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayOfWeek)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gap_device_name(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GapDeviceName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dst_offset(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DstOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exact_time256(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExactTime256)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_firmware_revision_string(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirmwareRevisionString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hardware_revision_string(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HardwareRevisionString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hid_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HidControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hid_information(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HidInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ieee1107320601_regulatory_certification_data_list(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Ieee1107320601RegulatoryCertificationDataList)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ln_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LnControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ln_feature(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LnFeature)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_local_time_information(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocalTimeInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_and_speed(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationAndSpeed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manufacturer_name_string(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ManufacturerNameString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_model_number_string(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ModelNumberString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_navigation(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Navigation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_alert(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewAlert)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gap_peripheral_preferred_connection_parameters(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GapPeripheralPreferredConnectionParameters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gap_peripheral_privacy_flag(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GapPeripheralPrivacyFlag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pnp_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PnpId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position_quality(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionQuality)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_mode(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtocolMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gap_reconnection_address(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GapReconnectionAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reference_time_information(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReferenceTimeInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_report(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Report)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_report_map(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReportMap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ringer_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RingerControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ringer_setting(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RingerSetting)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scan_interval_window(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScanIntervalWindow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scan_refresh(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScanRefresh)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_serial_number_string(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SerialNumberString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gatt_service_changed(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GattServiceChanged)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_software_revision_string(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SoftwareRevisionString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_new_alert_category(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportedNewAlertCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_support_unread_alert_category(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportUnreadAlertCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_id(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_accuracy(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeAccuracy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_source(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_update_control_point(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeUpdateControlPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_update_state(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeUpdateState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_with_dst(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeWithDst)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_zone(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeZone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tx_power_level(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TxPowerLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unread_alert_status(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UnreadAlertStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum GattClientCharacteristicConfigurationDescriptorValue: i32 {
    None (GattClientCharacteristicConfigurationDescriptorValue_None) = 0, Notify (GattClientCharacteristicConfigurationDescriptorValue_Notify) = 1, Indicate (GattClientCharacteristicConfigurationDescriptorValue_Indicate) = 2,
}}
DEFINE_IID!(IID_IGattClientNotificationResult, 1349342617, 274, 16794, 142, 59, 174, 33, 175, 171, 210, 194);
RT_INTERFACE!{interface IGattClientNotificationResult(IGattClientNotificationResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattClientNotificationResult] {
    fn get_SubscribedClient(&self, out: *mut *mut GattSubscribedClient) -> HRESULT,
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT
}}
impl IGattClientNotificationResult {
    #[inline] pub unsafe fn get_subscribed_client(&self) -> Result<ComPtr<GattSubscribedClient>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubscribedClient)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattClientNotificationResult: IGattClientNotificationResult}
DEFINE_IID!(IID_IGattClientNotificationResult2, 2410595479, 17888, 18814, 149, 130, 41, 161, 254, 40, 26, 213);
RT_INTERFACE!{interface IGattClientNotificationResult2(IGattClientNotificationResult2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattClientNotificationResult2] {
    fn get_BytesSent(&self, out: *mut u16) -> HRESULT
}}
impl IGattClientNotificationResult2 {
    #[inline] pub unsafe fn get_bytes_sent(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BytesSent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum GattCommunicationStatus: i32 {
    Success (GattCommunicationStatus_Success) = 0, Unreachable (GattCommunicationStatus_Unreachable) = 1, ProtocolError (GattCommunicationStatus_ProtocolError) = 2, AccessDenied (GattCommunicationStatus_AccessDenied) = 3,
}}
DEFINE_IID!(IID_IGattDescriptor, 2449825579, 32900, 17220, 180, 194, 40, 77, 225, 154, 133, 6);
RT_INTERFACE!{interface IGattDescriptor(IGattDescriptorVtbl): IInspectable(IInspectableVtbl) [IID_IGattDescriptor] {
    fn get_ProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn put_ProtectionLevel(&self, value: GattProtectionLevel) -> HRESULT,
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    fn get_AttributeHandle(&self, out: *mut u16) -> HRESULT,
    fn ReadValueAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>) -> HRESULT,
    fn ReadValueWithCacheModeAsync(&self, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn WriteValueAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>) -> HRESULT
}}
impl IGattDescriptor {
    #[inline] pub unsafe fn get_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_protection_level(&self, value: GattProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_attribute_handle(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttributeHandle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_value_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadValueAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_value_with_cache_mode_async(&self, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattReadResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadValueWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteValueAsync)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattDescriptor: IGattDescriptor}
impl RtActivatable<IGattDescriptorStatics> for GattDescriptor {}
impl GattDescriptor {
    #[inline] pub fn convert_short_id_to_uuid(shortId: u16) -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorStatics>>::get_activation_factory().convert_short_id_to_uuid(shortId)
    }}
}
DEFINE_CLSID!(GattDescriptor(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,68,101,115,99,114,105,112,116,111,114,0]) [CLSID_GattDescriptor]);
DEFINE_IID!(IID_IGattDescriptor2, 2404793657, 54832, 16492, 186, 17, 16, 205, 209, 107, 14, 94);
RT_INTERFACE!{interface IGattDescriptor2(IGattDescriptor2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattDescriptor2] {
    #[cfg(feature="windows-storage")] fn WriteValueWithResultAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>) -> HRESULT
}}
impl IGattDescriptor2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value_with_result_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).WriteValueWithResultAsync)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattDescriptorsResult, 2613088755, 38375, 17545, 141, 37, 255, 129, 149, 90, 87, 185);
RT_INTERFACE!{interface IGattDescriptorsResult(IGattDescriptorsResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattDescriptorsResult] {
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT,
    fn get_Descriptors(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDescriptor>) -> HRESULT
}}
impl IGattDescriptorsResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_descriptors(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDescriptor>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Descriptors)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattDescriptorsResult: IGattDescriptorsResult}
DEFINE_IID!(IID_IGattDescriptorStatics, 2449825581, 32900, 17220, 180, 194, 40, 77, 225, 154, 133, 6);
RT_INTERFACE!{static interface IGattDescriptorStatics(IGattDescriptorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattDescriptorStatics] {
    fn ConvertShortIdToUuid(&self, shortId: u16, out: *mut Guid) -> HRESULT
}}
impl IGattDescriptorStatics {
    #[inline] pub unsafe fn convert_short_id_to_uuid(&self, shortId: u16) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ConvertShortIdToUuid)(self as *const _ as *mut _, shortId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{static class GattDescriptorUuids}
impl RtActivatable<IGattDescriptorUuidsStatics> for GattDescriptorUuids {}
impl GattDescriptorUuids {
    #[inline] pub fn get_characteristic_aggregate_format() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorUuidsStatics>>::get_activation_factory().get_characteristic_aggregate_format()
    }}
    #[inline] pub fn get_characteristic_extended_properties() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorUuidsStatics>>::get_activation_factory().get_characteristic_extended_properties()
    }}
    #[inline] pub fn get_characteristic_presentation_format() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorUuidsStatics>>::get_activation_factory().get_characteristic_presentation_format()
    }}
    #[inline] pub fn get_characteristic_user_description() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorUuidsStatics>>::get_activation_factory().get_characteristic_user_description()
    }}
    #[inline] pub fn get_client_characteristic_configuration() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorUuidsStatics>>::get_activation_factory().get_client_characteristic_configuration()
    }}
    #[inline] pub fn get_server_characteristic_configuration() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDescriptorUuidsStatics>>::get_activation_factory().get_server_characteristic_configuration()
    }}
}
DEFINE_CLSID!(GattDescriptorUuids(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,68,101,115,99,114,105,112,116,111,114,85,117,105,100,115,0]) [CLSID_GattDescriptorUuids]);
DEFINE_IID!(IID_IGattDescriptorUuidsStatics, 2801296078, 40188, 17137, 145, 133, 255, 55, 183, 81, 129, 211);
RT_INTERFACE!{static interface IGattDescriptorUuidsStatics(IGattDescriptorUuidsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattDescriptorUuidsStatics] {
    fn get_CharacteristicAggregateFormat(&self, out: *mut Guid) -> HRESULT,
    fn get_CharacteristicExtendedProperties(&self, out: *mut Guid) -> HRESULT,
    fn get_CharacteristicPresentationFormat(&self, out: *mut Guid) -> HRESULT,
    fn get_CharacteristicUserDescription(&self, out: *mut Guid) -> HRESULT,
    fn get_ClientCharacteristicConfiguration(&self, out: *mut Guid) -> HRESULT,
    fn get_ServerCharacteristicConfiguration(&self, out: *mut Guid) -> HRESULT
}}
impl IGattDescriptorUuidsStatics {
    #[inline] pub unsafe fn get_characteristic_aggregate_format(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicAggregateFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristic_extended_properties(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicExtendedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristic_presentation_format(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicPresentationFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristic_user_description(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicUserDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_client_characteristic_configuration(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClientCharacteristicConfiguration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_server_characteristic_configuration(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServerCharacteristicConfiguration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattDeviceService, 2893773829, 45884, 18383, 153, 15, 107, 143, 85, 119, 223, 113);
RT_INTERFACE!{interface IGattDeviceService(IGattDeviceServiceVtbl): IInspectable(IInspectableVtbl) [IID_IGattDeviceService] {
    fn GetCharacteristics(&self, characteristicUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattCharacteristic>) -> HRESULT,
    fn GetIncludedServices(&self, serviceUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>) -> HRESULT,
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    fn get_AttributeHandle(&self, out: *mut u16) -> HRESULT
}}
impl IGattDeviceService {
    #[inline] pub unsafe fn get_characteristics(&self, characteristicUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattCharacteristic>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCharacteristics)(self as *const _ as *mut _, characteristicUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_included_services(&self, serviceUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIncludedServices)(self as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_attribute_handle(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttributeHandle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattDeviceService: IGattDeviceService}
impl RtActivatable<IGattDeviceServiceStatics> for GattDeviceService {}
impl RtActivatable<IGattDeviceServiceStatics2> for GattDeviceService {}
impl GattDeviceService {
    #[inline] pub fn from_id_async(deviceId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceService>>> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics>>::get_activation_factory().from_id_async(deviceId)
    }}
    #[inline] pub fn get_device_selector_from_uuid(serviceUuid: Guid) -> Result<HString> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics>>::get_activation_factory().get_device_selector_from_uuid(serviceUuid)
    }}
    #[inline] pub fn get_device_selector_from_short_id(serviceShortId: u16) -> Result<HString> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics>>::get_activation_factory().get_device_selector_from_short_id(serviceShortId)
    }}
    #[inline] pub fn convert_short_id_to_uuid(shortId: u16) -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics>>::get_activation_factory().convert_short_id_to_uuid(shortId)
    }}
    #[inline] pub fn from_id_with_sharing_mode_async(deviceId: &HStringArg, sharingMode: GattSharingMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceService>>> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics2>>::get_activation_factory().from_id_with_sharing_mode_async(deviceId, sharingMode)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_id(bluetoothDeviceId: &super::BluetoothDeviceId) -> Result<HString> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_id(bluetoothDeviceId)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_id_with_cache_mode(bluetoothDeviceId: &super::BluetoothDeviceId, cacheMode: super::BluetoothCacheMode) -> Result<HString> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_id_with_cache_mode(bluetoothDeviceId, cacheMode)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_id_and_uuid(bluetoothDeviceId: &super::BluetoothDeviceId, serviceUuid: Guid) -> Result<HString> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_id_and_uuid(bluetoothDeviceId, serviceUuid)
    }}
    #[inline] pub fn get_device_selector_for_bluetooth_device_id_and_uuid_with_cache_mode(bluetoothDeviceId: &super::BluetoothDeviceId, serviceUuid: Guid, cacheMode: super::BluetoothCacheMode) -> Result<HString> { unsafe {
        <Self as RtActivatable<IGattDeviceServiceStatics2>>::get_activation_factory().get_device_selector_for_bluetooth_device_id_and_uuid_with_cache_mode(bluetoothDeviceId, serviceUuid, cacheMode)
    }}
}
DEFINE_CLSID!(GattDeviceService(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,68,101,118,105,99,101,83,101,114,118,105,99,101,0]) [CLSID_GattDeviceService]);
DEFINE_IID!(IID_IGattDeviceService2, 4233384459, 2829, 18184, 186, 224, 159, 253, 148, 137, 188, 89);
RT_INTERFACE!{interface IGattDeviceService2(IGattDeviceService2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattDeviceService2] {
    fn get_Device(&self, out: *mut *mut super::BluetoothLEDevice) -> HRESULT,
    fn get_ParentServices(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>) -> HRESULT,
    fn GetAllCharacteristics(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattCharacteristic>) -> HRESULT,
    fn GetAllIncludedServices(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>) -> HRESULT
}}
impl IGattDeviceService2 {
    #[inline] pub unsafe fn get_device(&self) -> Result<ComPtr<super::BluetoothLEDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Device)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_parent_services(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ParentServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_characteristics(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattCharacteristic>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllCharacteristics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_all_included_services(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAllIncludedServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattDeviceService3, 2996021584, 3155, 17276, 169, 179, 92, 50, 16, 198, 229, 105);
RT_INTERFACE!{interface IGattDeviceService3(IGattDeviceService3Vtbl): IInspectable(IInspectableVtbl) [IID_IGattDeviceService3] {
    fn get_DeviceAccessInformation(&self, out: *mut *mut super::super::enumeration::DeviceAccessInformation) -> HRESULT,
    fn get_Session(&self, out: *mut *mut GattSession) -> HRESULT,
    fn get_SharingMode(&self, out: *mut GattSharingMode) -> HRESULT,
    fn RequestAccessAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<super::super::enumeration::DeviceAccessStatus>) -> HRESULT,
    fn OpenAsync(&self, sharingMode: GattSharingMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattOpenStatus>) -> HRESULT,
    fn GetCharacteristicsAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>) -> HRESULT,
    fn GetCharacteristicsWithCacheModeAsync(&self, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>) -> HRESULT,
    fn GetCharacteristicsForUuidAsync(&self, characteristicUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>) -> HRESULT,
    fn GetCharacteristicsForUuidWithCacheModeAsync(&self, characteristicUuid: Guid, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>) -> HRESULT,
    fn GetIncludedServicesAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>) -> HRESULT,
    fn GetIncludedServicesWithCacheModeAsync(&self, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>) -> HRESULT,
    fn GetIncludedServicesForUuidAsync(&self, serviceUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>) -> HRESULT,
    fn GetIncludedServicesForUuidWithCacheModeAsync(&self, serviceUuid: Guid, cacheMode: super::BluetoothCacheMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>) -> HRESULT
}}
impl IGattDeviceService3 {
    #[inline] pub unsafe fn get_device_access_information(&self) -> Result<ComPtr<super::super::enumeration::DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceAccessInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_session(&self) -> Result<ComPtr<GattSession>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Session)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<GattSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<super::super::enumeration::DeviceAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_async(&self, sharingMode: GattSharingMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattOpenStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenAsync)(self as *const _ as *mut _, sharingMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCharacteristicsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics_with_cache_mode_async(&self, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCharacteristicsWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics_for_uuid_async(&self, characteristicUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCharacteristicsForUuidAsync)(self as *const _ as *mut _, characteristicUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics_for_uuid_with_cache_mode_async(&self, characteristicUuid: Guid, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCharacteristicsResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCharacteristicsForUuidWithCacheModeAsync)(self as *const _ as *mut _, characteristicUuid, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_included_services_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIncludedServicesAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_included_services_with_cache_mode_async(&self, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIncludedServicesWithCacheModeAsync)(self as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_included_services_for_uuid_async(&self, serviceUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIncludedServicesForUuidAsync)(self as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_included_services_for_uuid_with_cache_mode_async(&self, serviceUuid: Guid, cacheMode: super::BluetoothCacheMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceServicesResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIncludedServicesForUuidWithCacheModeAsync)(self as *const _ as *mut _, serviceUuid, cacheMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattDeviceServicesResult, 387830766, 365, 16797, 131, 138, 87, 108, 244, 117, 163, 216);
RT_INTERFACE!{interface IGattDeviceServicesResult(IGattDeviceServicesResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattDeviceServicesResult] {
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT,
    fn get_Services(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>) -> HRESULT
}}
impl IGattDeviceServicesResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_services(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Services)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattDeviceServicesResult: IGattDeviceServicesResult}
DEFINE_IID!(IID_IGattDeviceServiceStatics, 426573858, 64173, 17884, 174, 91, 42, 195, 24, 78, 132, 219);
RT_INTERFACE!{static interface IGattDeviceServiceStatics(IGattDeviceServiceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattDeviceServiceStatics] {
    fn FromIdAsync(&self, deviceId: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDeviceService>) -> HRESULT,
    fn GetDeviceSelectorFromUuid(&self, serviceUuid: Guid, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromShortId(&self, serviceShortId: u16, out: *mut HSTRING) -> HRESULT,
    fn ConvertShortIdToUuid(&self, shortId: u16, out: *mut Guid) -> HRESULT
}}
impl IGattDeviceServiceStatics {
    #[inline] pub unsafe fn from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_uuid(&self, serviceUuid: Guid) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromUuid)(self as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_short_id(&self, serviceShortId: u16) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromShortId)(self as *const _ as *mut _, serviceShortId, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn convert_short_id_to_uuid(&self, shortId: u16) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ConvertShortIdToUuid)(self as *const _ as *mut _, shortId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattDeviceServiceStatics2, 100931694, 9382, 19213, 162, 242, 48, 204, 1, 84, 93, 37);
RT_INTERFACE!{static interface IGattDeviceServiceStatics2(IGattDeviceServiceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattDeviceServiceStatics2] {
    fn FromIdWithSharingModeAsync(&self, deviceId: HSTRING, sharingMode: GattSharingMode, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattDeviceService>) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceId(&self, bluetoothDeviceId: *mut super::BluetoothDeviceId, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceIdWithCacheMode(&self, bluetoothDeviceId: *mut super::BluetoothDeviceId, cacheMode: super::BluetoothCacheMode, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceIdAndUuid(&self, bluetoothDeviceId: *mut super::BluetoothDeviceId, serviceUuid: Guid, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorForBluetoothDeviceIdAndUuidWithCacheMode(&self, bluetoothDeviceId: *mut super::BluetoothDeviceId, serviceUuid: Guid, cacheMode: super::BluetoothCacheMode, out: *mut HSTRING) -> HRESULT
}}
impl IGattDeviceServiceStatics2 {
    #[inline] pub unsafe fn from_id_with_sharing_mode_async(&self, deviceId: &HStringArg, sharingMode: GattSharingMode) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattDeviceService>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdWithSharingModeAsync)(self as *const _ as *mut _, deviceId.get(), sharingMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_id(&self, bluetoothDeviceId: &super::BluetoothDeviceId) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceId)(self as *const _ as *mut _, bluetoothDeviceId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_id_with_cache_mode(&self, bluetoothDeviceId: &super::BluetoothDeviceId, cacheMode: super::BluetoothCacheMode) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceIdWithCacheMode)(self as *const _ as *mut _, bluetoothDeviceId as *const _ as *mut _, cacheMode, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_id_and_uuid(&self, bluetoothDeviceId: &super::BluetoothDeviceId, serviceUuid: Guid) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceIdAndUuid)(self as *const _ as *mut _, bluetoothDeviceId as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_for_bluetooth_device_id_and_uuid_with_cache_mode(&self, bluetoothDeviceId: &super::BluetoothDeviceId, serviceUuid: Guid, cacheMode: super::BluetoothCacheMode) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorForBluetoothDeviceIdAndUuidWithCacheMode)(self as *const _ as *mut _, bluetoothDeviceId as *const _ as *mut _, serviceUuid, cacheMode, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattLocalCharacteristic, 2933798765, 21522, 19828, 146, 168, 141, 235, 133, 38, 130, 156);
RT_INTERFACE!{interface IGattLocalCharacteristic(IGattLocalCharacteristicVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalCharacteristic] {
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_StaticValue(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn get_CharacteristicProperties(&self, out: *mut GattCharacteristicProperties) -> HRESULT,
    fn get_ReadProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn get_WriteProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn CreateDescriptorAsync(&self, descriptorUuid: Guid, parameters: *mut GattLocalDescriptorParameters, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattLocalDescriptorResult>) -> HRESULT,
    fn get_Descriptors(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattLocalDescriptor>) -> HRESULT,
    fn get_UserDescription(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PresentationFormats(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattPresentationFormat>) -> HRESULT,
    fn get_SubscribedClients(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattSubscribedClient>) -> HRESULT,
    fn add_SubscribedClientsChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattLocalCharacteristic, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SubscribedClientsChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ReadRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattLocalCharacteristic, GattReadRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ReadRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_WriteRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattLocalCharacteristic, GattWriteRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WriteRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    #[cfg(feature="windows-storage")] fn NotifyValueAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<GattClientNotificationResult>>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn NotifyValueForSubscribedClientAsync(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer, subscribedClient: *mut GattSubscribedClient, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattClientNotificationResult>) -> HRESULT
}}
impl IGattLocalCharacteristic {
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_static_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StaticValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristic_properties(&self) -> Result<GattCharacteristicProperties> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_read_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReadProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_write_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WriteProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_descriptor_async(&self, descriptorUuid: Guid, parameters: &GattLocalDescriptorParameters) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattLocalDescriptorResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDescriptorAsync)(self as *const _ as *mut _, descriptorUuid, parameters as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_descriptors(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattLocalDescriptor>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Descriptors)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_presentation_formats(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattPresentationFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PresentationFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subscribed_clients(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattSubscribedClient>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubscribedClients)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_subscribed_clients_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattLocalCharacteristic, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SubscribedClientsChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_subscribed_clients_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SubscribedClientsChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_read_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattLocalCharacteristic, GattReadRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ReadRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_read_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ReadRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_write_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattLocalCharacteristic, GattWriteRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WriteRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_write_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WriteRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn notify_value_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<GattClientNotificationResult>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).NotifyValueAsync)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn notify_value_for_subscribed_client_async(&self, value: &::rt::gen::windows::storage::streams::IBuffer, subscribedClient: &GattSubscribedClient) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattClientNotificationResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).NotifyValueForSubscribedClientAsync)(self as *const _ as *mut _, value as *const _ as *mut _, subscribedClient as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalCharacteristic: IGattLocalCharacteristic}
DEFINE_IID!(IID_IGattLocalCharacteristicParameters, 4210507188, 19711, 17607, 132, 69, 4, 14, 110, 173, 0, 99);
RT_INTERFACE!{interface IGattLocalCharacteristicParameters(IGattLocalCharacteristicParametersVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalCharacteristicParameters] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_StaticValue(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_StaticValue(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn put_CharacteristicProperties(&self, value: GattCharacteristicProperties) -> HRESULT,
    fn get_CharacteristicProperties(&self, out: *mut GattCharacteristicProperties) -> HRESULT,
    fn put_ReadProtectionLevel(&self, value: GattProtectionLevel) -> HRESULT,
    fn get_ReadProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn put_WriteProtectionLevel(&self, value: GattProtectionLevel) -> HRESULT,
    fn get_WriteProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn put_UserDescription(&self, value: HSTRING) -> HRESULT,
    fn get_UserDescription(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PresentationFormats(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<GattPresentationFormat>) -> HRESULT
}}
impl IGattLocalCharacteristicParameters {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_static_value(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StaticValue)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_static_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StaticValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_characteristic_properties(&self, value: GattCharacteristicProperties) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CharacteristicProperties)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristic_properties(&self) -> Result<GattCharacteristicProperties> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacteristicProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_read_protection_level(&self, value: GattProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReadProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_read_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReadProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_write_protection_level(&self, value: GattProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WriteProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_write_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WriteProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_user_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UserDescription)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_presentation_formats(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<GattPresentationFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PresentationFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalCharacteristicParameters: IGattLocalCharacteristicParameters}
impl RtActivatable<IActivationFactory> for GattLocalCharacteristicParameters {}
DEFINE_CLSID!(GattLocalCharacteristicParameters(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,76,111,99,97,108,67,104,97,114,97,99,116,101,114,105,115,116,105,99,80,97,114,97,109,101,116,101,114,115,0]) [CLSID_GattLocalCharacteristicParameters]);
DEFINE_IID!(IID_IGattLocalCharacteristicResult, 2037767835, 368, 17303, 150, 102, 146, 248, 99, 241, 46, 230);
RT_INTERFACE!{interface IGattLocalCharacteristicResult(IGattLocalCharacteristicResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalCharacteristicResult] {
    fn get_Characteristic(&self, out: *mut *mut GattLocalCharacteristic) -> HRESULT,
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT
}}
impl IGattLocalCharacteristicResult {
    #[inline] pub unsafe fn get_characteristic(&self) -> Result<ComPtr<GattLocalCharacteristic>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalCharacteristicResult: IGattLocalCharacteristicResult}
DEFINE_IID!(IID_IGattLocalDescriptor, 4102995462, 30877, 19019, 134, 82, 189, 1, 123, 93, 47, 198);
RT_INTERFACE!{interface IGattLocalDescriptor(IGattLocalDescriptorVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalDescriptor] {
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_StaticValue(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn get_ReadProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn get_WriteProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn add_ReadRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattLocalDescriptor, GattReadRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ReadRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_WriteRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattLocalDescriptor, GattWriteRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WriteRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGattLocalDescriptor {
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_static_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StaticValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_read_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReadProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_write_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WriteProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_read_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattLocalDescriptor, GattReadRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ReadRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_read_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ReadRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_write_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattLocalDescriptor, GattWriteRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WriteRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_write_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WriteRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalDescriptor: IGattLocalDescriptor}
DEFINE_IID!(IID_IGattLocalDescriptorParameters, 1608441450, 62401, 19302, 140, 75, 227, 210, 41, 59, 64, 233);
RT_INTERFACE!{interface IGattLocalDescriptorParameters(IGattLocalDescriptorParametersVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalDescriptorParameters] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_StaticValue(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_StaticValue(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn put_ReadProtectionLevel(&self, value: GattProtectionLevel) -> HRESULT,
    fn get_ReadProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT,
    fn put_WriteProtectionLevel(&self, value: GattProtectionLevel) -> HRESULT,
    fn get_WriteProtectionLevel(&self, out: *mut GattProtectionLevel) -> HRESULT
}}
impl IGattLocalDescriptorParameters {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_static_value(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StaticValue)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_static_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StaticValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_read_protection_level(&self, value: GattProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReadProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_read_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReadProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_write_protection_level(&self, value: GattProtectionLevel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WriteProtectionLevel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_write_protection_level(&self) -> Result<GattProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WriteProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalDescriptorParameters: IGattLocalDescriptorParameters}
impl RtActivatable<IActivationFactory> for GattLocalDescriptorParameters {}
DEFINE_CLSID!(GattLocalDescriptorParameters(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,76,111,99,97,108,68,101,115,99,114,105,112,116,111,114,80,97,114,97,109,101,116,101,114,115,0]) [CLSID_GattLocalDescriptorParameters]);
DEFINE_IID!(IID_IGattLocalDescriptorResult, 928485822, 12831, 17254, 191, 193, 59, 198, 184, 44, 121, 248);
RT_INTERFACE!{interface IGattLocalDescriptorResult(IGattLocalDescriptorResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalDescriptorResult] {
    fn get_Descriptor(&self, out: *mut *mut GattLocalDescriptor) -> HRESULT,
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT
}}
impl IGattLocalDescriptorResult {
    #[inline] pub unsafe fn get_descriptor(&self) -> Result<ComPtr<GattLocalDescriptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Descriptor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalDescriptorResult: IGattLocalDescriptorResult}
DEFINE_IID!(IID_IGattLocalService, 4111721048, 63479, 18690, 184, 3, 87, 252, 199, 214, 254, 131);
RT_INTERFACE!{interface IGattLocalService(IGattLocalServiceVtbl): IInspectable(IInspectableVtbl) [IID_IGattLocalService] {
    fn get_Uuid(&self, out: *mut Guid) -> HRESULT,
    fn CreateCharacteristicAsync(&self, characteristicUuid: Guid, parameters: *mut GattLocalCharacteristicParameters, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattLocalCharacteristicResult>) -> HRESULT,
    fn get_Characteristics(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<GattLocalCharacteristic>) -> HRESULT
}}
impl IGattLocalService {
    #[inline] pub unsafe fn get_uuid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Uuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_characteristic_async(&self, characteristicUuid: Guid, parameters: &GattLocalCharacteristicParameters) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattLocalCharacteristicResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCharacteristicAsync)(self as *const _ as *mut _, characteristicUuid, parameters as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_characteristics(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<GattLocalCharacteristic>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattLocalService: IGattLocalService}
RT_ENUM! { enum GattOpenStatus: i32 {
    Unspecified (GattOpenStatus_Unspecified) = 0, Success (GattOpenStatus_Success) = 1, AlreadyOpened (GattOpenStatus_AlreadyOpened) = 2, NotFound (GattOpenStatus_NotFound) = 3, SharingViolation (GattOpenStatus_SharingViolation) = 4, AccessDenied (GattOpenStatus_AccessDenied) = 5,
}}
DEFINE_IID!(IID_IGattPresentationFormat, 426573857, 64173, 17884, 174, 91, 42, 195, 24, 78, 132, 219);
RT_INTERFACE!{interface IGattPresentationFormat(IGattPresentationFormatVtbl): IInspectable(IInspectableVtbl) [IID_IGattPresentationFormat] {
    fn get_FormatType(&self, out: *mut u8) -> HRESULT,
    fn get_Exponent(&self, out: *mut i32) -> HRESULT,
    fn get_Unit(&self, out: *mut u16) -> HRESULT,
    fn get_Namespace(&self, out: *mut u8) -> HRESULT,
    fn get_Description(&self, out: *mut u16) -> HRESULT
}}
impl IGattPresentationFormat {
    #[inline] pub unsafe fn get_format_type(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FormatType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exponent(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Exponent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unit(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Unit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_namespace(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Namespace)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattPresentationFormat: IGattPresentationFormat}
impl RtActivatable<IGattPresentationFormatStatics> for GattPresentationFormat {}
impl RtActivatable<IGattPresentationFormatStatics2> for GattPresentationFormat {}
impl GattPresentationFormat {
    #[inline] pub fn get_bluetooth_sig_assigned_numbers() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatStatics>>::get_activation_factory().get_bluetooth_sig_assigned_numbers()
    }}
    #[inline] pub fn from_parts(formatType: u8, exponent: i32, unit: u16, namespaceId: u8, description: u16) -> Result<ComPtr<GattPresentationFormat>> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatStatics2>>::get_activation_factory().from_parts(formatType, exponent, unit, namespaceId, description)
    }}
}
DEFINE_CLSID!(GattPresentationFormat(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,80,114,101,115,101,110,116,97,116,105,111,110,70,111,114,109,97,116,0]) [CLSID_GattPresentationFormat]);
DEFINE_IID!(IID_IGattPresentationFormatStatics, 426573856, 64173, 17884, 174, 91, 42, 195, 24, 78, 132, 219);
RT_INTERFACE!{static interface IGattPresentationFormatStatics(IGattPresentationFormatStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattPresentationFormatStatics] {
    fn get_BluetoothSigAssignedNumbers(&self, out: *mut u8) -> HRESULT
}}
impl IGattPresentationFormatStatics {
    #[inline] pub unsafe fn get_bluetooth_sig_assigned_numbers(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BluetoothSigAssignedNumbers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattPresentationFormatStatics2, 2848069395, 47151, 17246, 182, 52, 33, 253, 133, 164, 60, 7);
RT_INTERFACE!{static interface IGattPresentationFormatStatics2(IGattPresentationFormatStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattPresentationFormatStatics2] {
    fn FromParts(&self, formatType: u8, exponent: i32, unit: u16, namespaceId: u8, description: u16, out: *mut *mut GattPresentationFormat) -> HRESULT
}}
impl IGattPresentationFormatStatics2 {
    #[inline] pub unsafe fn from_parts(&self, formatType: u8, exponent: i32, unit: u16, namespaceId: u8, description: u16) -> Result<ComPtr<GattPresentationFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromParts)(self as *const _ as *mut _, formatType, exponent, unit, namespaceId, description, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class GattPresentationFormatTypes}
impl RtActivatable<IGattPresentationFormatTypesStatics> for GattPresentationFormatTypes {}
impl GattPresentationFormatTypes {
    #[inline] pub fn get_boolean() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_boolean()
    }}
    #[inline] pub fn get_bit2() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_bit2()
    }}
    #[inline] pub fn get_nibble() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_nibble()
    }}
    #[inline] pub fn get_uint8() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint8()
    }}
    #[inline] pub fn get_uint12() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint12()
    }}
    #[inline] pub fn get_uint16() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint16()
    }}
    #[inline] pub fn get_uint24() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint24()
    }}
    #[inline] pub fn get_uint32() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint32()
    }}
    #[inline] pub fn get_uint48() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint48()
    }}
    #[inline] pub fn get_uint64() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint64()
    }}
    #[inline] pub fn get_uint128() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_uint128()
    }}
    #[inline] pub fn get_sint8() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint8()
    }}
    #[inline] pub fn get_sint12() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint12()
    }}
    #[inline] pub fn get_sint16() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint16()
    }}
    #[inline] pub fn get_sint24() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint24()
    }}
    #[inline] pub fn get_sint32() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint32()
    }}
    #[inline] pub fn get_sint48() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint48()
    }}
    #[inline] pub fn get_sint64() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint64()
    }}
    #[inline] pub fn get_sint128() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sint128()
    }}
    #[inline] pub fn get_float32() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_float32()
    }}
    #[inline] pub fn get_float64() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_float64()
    }}
    #[inline] pub fn get_sfloat() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_sfloat()
    }}
    #[inline] pub fn get_float() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_float()
    }}
    #[inline] pub fn get_duint16() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_duint16()
    }}
    #[inline] pub fn get_utf8() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_utf8()
    }}
    #[inline] pub fn get_utf16() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_utf16()
    }}
    #[inline] pub fn get_struct() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattPresentationFormatTypesStatics>>::get_activation_factory().get_struct()
    }}
}
DEFINE_CLSID!(GattPresentationFormatTypes(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,80,114,101,115,101,110,116,97,116,105,111,110,70,111,114,109,97,116,84,121,112,101,115,0]) [CLSID_GattPresentationFormatTypes]);
DEFINE_IID!(IID_IGattPresentationFormatTypesStatics, 4210145802, 12474, 16540, 190, 247, 207, 251, 109, 3, 184, 251);
RT_INTERFACE!{static interface IGattPresentationFormatTypesStatics(IGattPresentationFormatTypesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattPresentationFormatTypesStatics] {
    fn get_Boolean(&self, out: *mut u8) -> HRESULT,
    fn get_Bit2(&self, out: *mut u8) -> HRESULT,
    fn get_Nibble(&self, out: *mut u8) -> HRESULT,
    fn get_UInt8(&self, out: *mut u8) -> HRESULT,
    fn get_UInt12(&self, out: *mut u8) -> HRESULT,
    fn get_UInt16(&self, out: *mut u8) -> HRESULT,
    fn get_UInt24(&self, out: *mut u8) -> HRESULT,
    fn get_UInt32(&self, out: *mut u8) -> HRESULT,
    fn get_UInt48(&self, out: *mut u8) -> HRESULT,
    fn get_UInt64(&self, out: *mut u8) -> HRESULT,
    fn get_UInt128(&self, out: *mut u8) -> HRESULT,
    fn get_SInt8(&self, out: *mut u8) -> HRESULT,
    fn get_SInt12(&self, out: *mut u8) -> HRESULT,
    fn get_SInt16(&self, out: *mut u8) -> HRESULT,
    fn get_SInt24(&self, out: *mut u8) -> HRESULT,
    fn get_SInt32(&self, out: *mut u8) -> HRESULT,
    fn get_SInt48(&self, out: *mut u8) -> HRESULT,
    fn get_SInt64(&self, out: *mut u8) -> HRESULT,
    fn get_SInt128(&self, out: *mut u8) -> HRESULT,
    fn get_Float32(&self, out: *mut u8) -> HRESULT,
    fn get_Float64(&self, out: *mut u8) -> HRESULT,
    fn get_SFloat(&self, out: *mut u8) -> HRESULT,
    fn get_Float(&self, out: *mut u8) -> HRESULT,
    fn get_DUInt16(&self, out: *mut u8) -> HRESULT,
    fn get_Utf8(&self, out: *mut u8) -> HRESULT,
    fn get_Utf16(&self, out: *mut u8) -> HRESULT,
    fn get_Struct(&self, out: *mut u8) -> HRESULT
}}
impl IGattPresentationFormatTypesStatics {
    #[inline] pub unsafe fn get_boolean(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Boolean)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bit2(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bit2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_nibble(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Nibble)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint8(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt8)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint12(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt12)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint16(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint24(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt24)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint32(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt32)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint48(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt48)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint64(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt64)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint128(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UInt128)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint8(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt8)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint12(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt12)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint16(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint24(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt24)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint32(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt32)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint48(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt48)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint64(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt64)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sint128(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SInt128)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_float32(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Float32)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_float64(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Float64)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sfloat(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SFloat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_float(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Float)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duint16(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DUInt16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_utf8(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Utf8)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_utf16(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Utf16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_struct(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Struct)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum GattProtectionLevel: i32 {
    Plain (GattProtectionLevel_Plain) = 0, AuthenticationRequired (GattProtectionLevel_AuthenticationRequired) = 1, EncryptionRequired (GattProtectionLevel_EncryptionRequired) = 2, EncryptionAndAuthenticationRequired (GattProtectionLevel_EncryptionAndAuthenticationRequired) = 3,
}}
RT_CLASS!{static class GattProtocolError}
impl RtActivatable<IGattProtocolErrorStatics> for GattProtocolError {}
impl GattProtocolError {
    #[inline] pub fn get_invalid_handle() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_invalid_handle()
    }}
    #[inline] pub fn get_read_not_permitted() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_read_not_permitted()
    }}
    #[inline] pub fn get_write_not_permitted() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_write_not_permitted()
    }}
    #[inline] pub fn get_invalid_pdu() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_invalid_pdu()
    }}
    #[inline] pub fn get_insufficient_authentication() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_insufficient_authentication()
    }}
    #[inline] pub fn get_request_not_supported() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_request_not_supported()
    }}
    #[inline] pub fn get_invalid_offset() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_invalid_offset()
    }}
    #[inline] pub fn get_insufficient_authorization() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_insufficient_authorization()
    }}
    #[inline] pub fn get_prepare_queue_full() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_prepare_queue_full()
    }}
    #[inline] pub fn get_attribute_not_found() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_attribute_not_found()
    }}
    #[inline] pub fn get_attribute_not_long() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_attribute_not_long()
    }}
    #[inline] pub fn get_insufficient_encryption_key_size() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_insufficient_encryption_key_size()
    }}
    #[inline] pub fn get_invalid_attribute_value_length() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_invalid_attribute_value_length()
    }}
    #[inline] pub fn get_unlikely_error() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_unlikely_error()
    }}
    #[inline] pub fn get_insufficient_encryption() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_insufficient_encryption()
    }}
    #[inline] pub fn get_unsupported_group_type() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_unsupported_group_type()
    }}
    #[inline] pub fn get_insufficient_resources() -> Result<u8> { unsafe {
        <Self as RtActivatable<IGattProtocolErrorStatics>>::get_activation_factory().get_insufficient_resources()
    }}
}
DEFINE_CLSID!(GattProtocolError(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,80,114,111,116,111,99,111,108,69,114,114,111,114,0]) [CLSID_GattProtocolError]);
DEFINE_IID!(IID_IGattProtocolErrorStatics, 3393635781, 3788, 18441, 190, 163, 207, 121, 188, 153, 30, 55);
RT_INTERFACE!{static interface IGattProtocolErrorStatics(IGattProtocolErrorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattProtocolErrorStatics] {
    fn get_InvalidHandle(&self, out: *mut u8) -> HRESULT,
    fn get_ReadNotPermitted(&self, out: *mut u8) -> HRESULT,
    fn get_WriteNotPermitted(&self, out: *mut u8) -> HRESULT,
    fn get_InvalidPdu(&self, out: *mut u8) -> HRESULT,
    fn get_InsufficientAuthentication(&self, out: *mut u8) -> HRESULT,
    fn get_RequestNotSupported(&self, out: *mut u8) -> HRESULT,
    fn get_InvalidOffset(&self, out: *mut u8) -> HRESULT,
    fn get_InsufficientAuthorization(&self, out: *mut u8) -> HRESULT,
    fn get_PrepareQueueFull(&self, out: *mut u8) -> HRESULT,
    fn get_AttributeNotFound(&self, out: *mut u8) -> HRESULT,
    fn get_AttributeNotLong(&self, out: *mut u8) -> HRESULT,
    fn get_InsufficientEncryptionKeySize(&self, out: *mut u8) -> HRESULT,
    fn get_InvalidAttributeValueLength(&self, out: *mut u8) -> HRESULT,
    fn get_UnlikelyError(&self, out: *mut u8) -> HRESULT,
    fn get_InsufficientEncryption(&self, out: *mut u8) -> HRESULT,
    fn get_UnsupportedGroupType(&self, out: *mut u8) -> HRESULT,
    fn get_InsufficientResources(&self, out: *mut u8) -> HRESULT
}}
impl IGattProtocolErrorStatics {
    #[inline] pub unsafe fn get_invalid_handle(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidHandle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_read_not_permitted(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReadNotPermitted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_write_not_permitted(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WriteNotPermitted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_pdu(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidPdu)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_insufficient_authentication(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InsufficientAuthentication)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_request_not_supported(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestNotSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_offset(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_insufficient_authorization(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InsufficientAuthorization)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_prepare_queue_full(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PrepareQueueFull)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_attribute_not_found(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttributeNotFound)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_attribute_not_long(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AttributeNotLong)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_insufficient_encryption_key_size(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InsufficientEncryptionKeySize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invalid_attribute_value_length(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InvalidAttributeValueLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unlikely_error(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UnlikelyError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_insufficient_encryption(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InsufficientEncryption)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unsupported_group_type(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UnsupportedGroupType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_insufficient_resources(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InsufficientResources)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattReadClientCharacteristicConfigurationDescriptorResult, 1671851785, 6890, 19532, 165, 15, 151, 186, 228, 116, 179, 72);
RT_INTERFACE!{interface IGattReadClientCharacteristicConfigurationDescriptorResult(IGattReadClientCharacteristicConfigurationDescriptorResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattReadClientCharacteristicConfigurationDescriptorResult] {
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    fn get_ClientCharacteristicConfigurationDescriptor(&self, out: *mut GattClientCharacteristicConfigurationDescriptorValue) -> HRESULT
}}
impl IGattReadClientCharacteristicConfigurationDescriptorResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_client_characteristic_configuration_descriptor(&self) -> Result<GattClientCharacteristicConfigurationDescriptorValue> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClientCharacteristicConfigurationDescriptor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattReadClientCharacteristicConfigurationDescriptorResult: IGattReadClientCharacteristicConfigurationDescriptorResult}
DEFINE_IID!(IID_IGattReadClientCharacteristicConfigurationDescriptorResult2, 468821405, 47693, 17954, 134, 81, 244, 238, 21, 13, 10, 93);
RT_INTERFACE!{interface IGattReadClientCharacteristicConfigurationDescriptorResult2(IGattReadClientCharacteristicConfigurationDescriptorResult2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattReadClientCharacteristicConfigurationDescriptorResult2] {
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT
}}
impl IGattReadClientCharacteristicConfigurationDescriptorResult2 {
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattReadRequest, 4057818421, 27341, 17062, 164, 187, 215, 137, 218, 224, 4, 62);
RT_INTERFACE!{interface IGattReadRequest(IGattReadRequestVtbl): IInspectable(IInspectableVtbl) [IID_IGattReadRequest] {
    fn get_Offset(&self, out: *mut u32) -> HRESULT,
    fn get_Length(&self, out: *mut u32) -> HRESULT,
    fn get_State(&self, out: *mut GattRequestState) -> HRESULT,
    fn add_StateChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattReadRequest, GattRequestStateChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-storage")] fn RespondWithValue(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn RespondWithProtocolError(&self, protocolError: u8) -> HRESULT
}}
impl IGattReadRequest {
    #[inline] pub unsafe fn get_offset(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Offset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Length)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<GattRequestState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_state_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattReadRequest, GattRequestStateChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn respond_with_value(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).RespondWithValue)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn respond_with_protocol_error(&self, protocolError: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).RespondWithProtocolError)(self as *const _ as *mut _, protocolError);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattReadRequest: IGattReadRequest}
DEFINE_IID!(IID_IGattReadRequestedEventArgs, 2471064131, 62364, 18507, 138, 182, 153, 107, 164, 134, 207, 163);
RT_INTERFACE!{interface IGattReadRequestedEventArgs(IGattReadRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGattReadRequestedEventArgs] {
    fn get_Session(&self, out: *mut *mut GattSession) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT,
    fn GetRequestAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattReadRequest>) -> HRESULT
}}
impl IGattReadRequestedEventArgs {
    #[inline] pub unsafe fn get_session(&self) -> Result<ComPtr<GattSession>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Session)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_request_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattReadRequest>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRequestAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattReadRequestedEventArgs: IGattReadRequestedEventArgs}
DEFINE_IID!(IID_IGattReadResult, 1671851784, 6890, 19532, 165, 15, 151, 186, 228, 116, 179, 72);
RT_INTERFACE!{interface IGattReadResult(IGattReadResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattReadResult] {
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Value(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT
}}
impl IGattReadResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattReadResult: IGattReadResult}
DEFINE_IID!(IID_IGattReadResult2, 2702135456, 64323, 18607, 186, 170, 99, 138, 92, 99, 41, 254);
RT_INTERFACE!{interface IGattReadResult2(IGattReadResult2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattReadResult2] {
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT
}}
impl IGattReadResult2 {
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattReliableWriteTransaction, 1671851783, 6890, 19532, 165, 15, 151, 186, 228, 116, 179, 72);
RT_INTERFACE!{interface IGattReliableWriteTransaction(IGattReliableWriteTransactionVtbl): IInspectable(IInspectableVtbl) [IID_IGattReliableWriteTransaction] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn WriteValue(&self, characteristic: *mut GattCharacteristic, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn CommitAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>) -> HRESULT
}}
impl IGattReliableWriteTransaction {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn write_value(&self, characteristic: &GattCharacteristic, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).WriteValue)(self as *const _ as *mut _, characteristic as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn commit_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattCommunicationStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CommitAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattReliableWriteTransaction: IGattReliableWriteTransaction}
impl RtActivatable<IActivationFactory> for GattReliableWriteTransaction {}
DEFINE_CLSID!(GattReliableWriteTransaction(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,82,101,108,105,97,98,108,101,87,114,105,116,101,84,114,97,110,115,97,99,116,105,111,110,0]) [CLSID_GattReliableWriteTransaction]);
DEFINE_IID!(IID_IGattReliableWriteTransaction2, 1360083335, 61202, 17967, 159, 178, 161, 164, 58, 103, 148, 22);
RT_INTERFACE!{interface IGattReliableWriteTransaction2(IGattReliableWriteTransaction2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattReliableWriteTransaction2] {
    fn CommitWithResultAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>) -> HRESULT
}}
impl IGattReliableWriteTransaction2 {
    #[inline] pub unsafe fn commit_with_result_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattWriteResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CommitWithResultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum GattRequestState: i32 {
    Pending (GattRequestState_Pending) = 0, Completed (GattRequestState_Completed) = 1, Canceled (GattRequestState_Canceled) = 2,
}}
DEFINE_IID!(IID_IGattRequestStateChangedEventArgs, 3895777580, 10174, 17587, 157, 13, 79, 198, 232, 8, 221, 63);
RT_INTERFACE!{interface IGattRequestStateChangedEventArgs(IGattRequestStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGattRequestStateChangedEventArgs] {
    fn get_State(&self, out: *mut GattRequestState) -> HRESULT,
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT
}}
impl IGattRequestStateChangedEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<GattRequestState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattRequestStateChangedEventArgs: IGattRequestStateChangedEventArgs}
DEFINE_IID!(IID_IGattServiceProvider, 2015540173, 10377, 20358, 160, 81, 63, 10, 237, 28, 39, 96);
RT_INTERFACE!{interface IGattServiceProvider(IGattServiceProviderVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProvider] {
    fn get_Service(&self, out: *mut *mut GattLocalService) -> HRESULT,
    fn get_AdvertisementStatus(&self, out: *mut GattServiceProviderAdvertisementStatus) -> HRESULT,
    fn add_AdvertisementStatusChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattServiceProvider, GattServiceProviderAdvertisementStatusChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AdvertisementStatusChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn StartAdvertising(&self) -> HRESULT,
    fn StartAdvertisingWithParameters(&self, parameters: *mut GattServiceProviderAdvertisingParameters) -> HRESULT,
    fn StopAdvertising(&self) -> HRESULT
}}
impl IGattServiceProvider {
    #[inline] pub unsafe fn get_service(&self) -> Result<ComPtr<GattLocalService>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Service)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertisement_status(&self) -> Result<GattServiceProviderAdvertisementStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AdvertisementStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_advertisement_status_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattServiceProvider, GattServiceProviderAdvertisementStatusChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AdvertisementStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_advertisement_status_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AdvertisementStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_advertising(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StartAdvertising)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_advertising_with_parameters(&self, parameters: &GattServiceProviderAdvertisingParameters) -> Result<()> {
        let hr = ((*self.lpVtbl).StartAdvertisingWithParameters)(self as *const _ as *mut _, parameters as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_advertising(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopAdvertising)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProvider: IGattServiceProvider}
impl RtActivatable<IGattServiceProviderStatics> for GattServiceProvider {}
impl GattServiceProvider {
    #[inline] pub fn create_async(serviceUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattServiceProviderResult>>> { unsafe {
        <Self as RtActivatable<IGattServiceProviderStatics>>::get_activation_factory().create_async(serviceUuid)
    }}
}
DEFINE_CLSID!(GattServiceProvider(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,83,101,114,118,105,99,101,80,114,111,118,105,100,101,114,0]) [CLSID_GattServiceProvider]);
RT_ENUM! { enum GattServiceProviderAdvertisementStatus: i32 {
    Created (GattServiceProviderAdvertisementStatus_Created) = 0, Stopped (GattServiceProviderAdvertisementStatus_Stopped) = 1, Started (GattServiceProviderAdvertisementStatus_Started) = 2, Aborted (GattServiceProviderAdvertisementStatus_Aborted) = 3,
}}
DEFINE_IID!(IID_IGattServiceProviderAdvertisementStatusChangedEventArgs, 1504029285, 64033, 20476, 177, 85, 4, 217, 40, 1, 38, 134);
RT_INTERFACE!{interface IGattServiceProviderAdvertisementStatusChangedEventArgs(IGattServiceProviderAdvertisementStatusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderAdvertisementStatusChangedEventArgs] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT,
    fn get_Status(&self, out: *mut GattServiceProviderAdvertisementStatus) -> HRESULT
}}
impl IGattServiceProviderAdvertisementStatusChangedEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<GattServiceProviderAdvertisementStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderAdvertisementStatusChangedEventArgs: IGattServiceProviderAdvertisementStatusChangedEventArgs}
DEFINE_IID!(IID_IGattServiceProviderAdvertisingParameters, 3805163947, 25365, 19490, 155, 215, 120, 29, 188, 61, 141, 130);
RT_INTERFACE!{interface IGattServiceProviderAdvertisingParameters(IGattServiceProviderAdvertisingParametersVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderAdvertisingParameters] {
    fn put_IsConnectable(&self, value: bool) -> HRESULT,
    fn get_IsConnectable(&self, out: *mut bool) -> HRESULT,
    fn put_IsDiscoverable(&self, value: bool) -> HRESULT,
    fn get_IsDiscoverable(&self, out: *mut bool) -> HRESULT
}}
impl IGattServiceProviderAdvertisingParameters {
    #[inline] pub unsafe fn set_is_connectable(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsConnectable)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_connectable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsConnectable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_discoverable(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDiscoverable)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_discoverable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDiscoverable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderAdvertisingParameters: IGattServiceProviderAdvertisingParameters}
impl RtActivatable<IActivationFactory> for GattServiceProviderAdvertisingParameters {}
DEFINE_CLSID!(GattServiceProviderAdvertisingParameters(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,83,101,114,118,105,99,101,80,114,111,118,105,100,101,114,65,100,118,101,114,116,105,115,105,110,103,80,97,114,97,109,101,116,101,114,115,0]) [CLSID_GattServiceProviderAdvertisingParameters]);
DEFINE_IID!(IID_IGattServiceProviderResult, 1984337624, 50494, 17036, 138, 72, 103, 175, 224, 44, 58, 230);
RT_INTERFACE!{interface IGattServiceProviderResult(IGattServiceProviderResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderResult] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT,
    fn get_ServiceProvider(&self, out: *mut *mut GattServiceProvider) -> HRESULT
}}
impl IGattServiceProviderResult {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_provider(&self) -> Result<ComPtr<GattServiceProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderResult: IGattServiceProviderResult}
DEFINE_IID!(IID_IGattServiceProviderStatics, 830029923, 21078, 16468, 164, 244, 123, 190, 119, 85, 165, 126);
RT_INTERFACE!{static interface IGattServiceProviderStatics(IGattServiceProviderStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderStatics] {
    fn CreateAsync(&self, serviceUuid: Guid, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattServiceProviderResult>) -> HRESULT
}}
impl IGattServiceProviderStatics {
    #[inline] pub unsafe fn create_async(&self, serviceUuid: Guid) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattServiceProviderResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAsync)(self as *const _ as *mut _, serviceUuid, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class GattServiceUuids}
impl RtActivatable<IGattServiceUuidsStatics> for GattServiceUuids {}
impl RtActivatable<IGattServiceUuidsStatics2> for GattServiceUuids {}
impl GattServiceUuids {
    #[inline] pub fn get_battery() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_battery()
    }}
    #[inline] pub fn get_blood_pressure() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_blood_pressure()
    }}
    #[inline] pub fn get_cycling_speed_and_cadence() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_cycling_speed_and_cadence()
    }}
    #[inline] pub fn get_generic_access() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_generic_access()
    }}
    #[inline] pub fn get_generic_attribute() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_generic_attribute()
    }}
    #[inline] pub fn get_glucose() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_glucose()
    }}
    #[inline] pub fn get_health_thermometer() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_health_thermometer()
    }}
    #[inline] pub fn get_heart_rate() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_heart_rate()
    }}
    #[inline] pub fn get_running_speed_and_cadence() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics>>::get_activation_factory().get_running_speed_and_cadence()
    }}
    #[inline] pub fn get_alert_notification() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_alert_notification()
    }}
    #[inline] pub fn get_current_time() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_current_time()
    }}
    #[inline] pub fn get_cycling_power() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_cycling_power()
    }}
    #[inline] pub fn get_device_information() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_device_information()
    }}
    #[inline] pub fn get_human_interface_device() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_human_interface_device()
    }}
    #[inline] pub fn get_immediate_alert() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_immediate_alert()
    }}
    #[inline] pub fn get_link_loss() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_link_loss()
    }}
    #[inline] pub fn get_location_and_navigation() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_location_and_navigation()
    }}
    #[inline] pub fn get_next_dst_change() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_next_dst_change()
    }}
    #[inline] pub fn get_phone_alert_status() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_phone_alert_status()
    }}
    #[inline] pub fn get_reference_time_update() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_reference_time_update()
    }}
    #[inline] pub fn get_scan_parameters() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_scan_parameters()
    }}
    #[inline] pub fn get_tx_power() -> Result<Guid> { unsafe {
        <Self as RtActivatable<IGattServiceUuidsStatics2>>::get_activation_factory().get_tx_power()
    }}
}
DEFINE_CLSID!(GattServiceUuids(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,83,101,114,118,105,99,101,85,117,105,100,115,0]) [CLSID_GattServiceUuids]);
DEFINE_IID!(IID_IGattServiceUuidsStatics, 1841655896, 39610, 17431, 184, 242, 220, 224, 22, 211, 78, 226);
RT_INTERFACE!{static interface IGattServiceUuidsStatics(IGattServiceUuidsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceUuidsStatics] {
    fn get_Battery(&self, out: *mut Guid) -> HRESULT,
    fn get_BloodPressure(&self, out: *mut Guid) -> HRESULT,
    fn get_CyclingSpeedAndCadence(&self, out: *mut Guid) -> HRESULT,
    fn get_GenericAccess(&self, out: *mut Guid) -> HRESULT,
    fn get_GenericAttribute(&self, out: *mut Guid) -> HRESULT,
    fn get_Glucose(&self, out: *mut Guid) -> HRESULT,
    fn get_HealthThermometer(&self, out: *mut Guid) -> HRESULT,
    fn get_HeartRate(&self, out: *mut Guid) -> HRESULT,
    fn get_RunningSpeedAndCadence(&self, out: *mut Guid) -> HRESULT
}}
impl IGattServiceUuidsStatics {
    #[inline] pub unsafe fn get_battery(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Battery)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blood_pressure(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BloodPressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_speed_and_cadence(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingSpeedAndCadence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_generic_access(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GenericAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_generic_attribute(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GenericAttribute)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_glucose(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Glucose)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_health_thermometer(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HealthThermometer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_heart_rate(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HeartRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_running_speed_and_cadence(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RunningSpeedAndCadence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattServiceUuidsStatics2, 3534656757, 15637, 20345, 156, 12, 234, 175, 166, 117, 21, 92);
RT_INTERFACE!{static interface IGattServiceUuidsStatics2(IGattServiceUuidsStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceUuidsStatics2] {
    fn get_AlertNotification(&self, out: *mut Guid) -> HRESULT,
    fn get_CurrentTime(&self, out: *mut Guid) -> HRESULT,
    fn get_CyclingPower(&self, out: *mut Guid) -> HRESULT,
    fn get_DeviceInformation(&self, out: *mut Guid) -> HRESULT,
    fn get_HumanInterfaceDevice(&self, out: *mut Guid) -> HRESULT,
    fn get_ImmediateAlert(&self, out: *mut Guid) -> HRESULT,
    fn get_LinkLoss(&self, out: *mut Guid) -> HRESULT,
    fn get_LocationAndNavigation(&self, out: *mut Guid) -> HRESULT,
    fn get_NextDstChange(&self, out: *mut Guid) -> HRESULT,
    fn get_PhoneAlertStatus(&self, out: *mut Guid) -> HRESULT,
    fn get_ReferenceTimeUpdate(&self, out: *mut Guid) -> HRESULT,
    fn get_ScanParameters(&self, out: *mut Guid) -> HRESULT,
    fn get_TxPower(&self, out: *mut Guid) -> HRESULT
}}
impl IGattServiceUuidsStatics2 {
    #[inline] pub unsafe fn get_alert_notification(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlertNotification)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_time(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cycling_power(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CyclingPower)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_information(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_human_interface_device(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HumanInterfaceDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_immediate_alert(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ImmediateAlert)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_link_loss(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LinkLoss)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_and_navigation(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationAndNavigation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_next_dst_change(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NextDstChange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phone_alert_status(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PhoneAlertStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reference_time_update(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReferenceTimeUpdate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scan_parameters(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScanParameters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tx_power(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TxPower)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattSession, 3527102787, 57422, 19492, 153, 156, 156, 37, 111, 152, 86, 177);
RT_INTERFACE!{interface IGattSession(IGattSessionVtbl): IInspectable(IInspectableVtbl) [IID_IGattSession] {
    fn get_DeviceId(&self, out: *mut *mut super::BluetoothDeviceId) -> HRESULT,
    fn get_CanMaintainConnection(&self, out: *mut bool) -> HRESULT,
    fn put_MaintainConnection(&self, value: bool) -> HRESULT,
    fn get_MaintainConnection(&self, out: *mut bool) -> HRESULT,
    fn get_MaxPduSize(&self, out: *mut u16) -> HRESULT,
    fn get_SessionStatus(&self, out: *mut GattSessionStatus) -> HRESULT,
    fn add_MaxPduSizeChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattSession, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MaxPduSizeChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SessionStatusChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattSession, GattSessionStatusChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SessionStatusChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGattSession {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<ComPtr<super::BluetoothDeviceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_maintain_connection(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanMaintainConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_maintain_connection(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaintainConnection)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_maintain_connection(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaintainConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_pdu_size(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxPduSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_session_status(&self) -> Result<GattSessionStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SessionStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_max_pdu_size_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattSession, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MaxPduSizeChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_max_pdu_size_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MaxPduSizeChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_session_status_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattSession, GattSessionStatusChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SessionStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_session_status_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SessionStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattSession: IGattSession}
impl RtActivatable<IGattSessionStatics> for GattSession {}
impl GattSession {
    #[inline] pub fn from_device_id_async(deviceId: &super::BluetoothDeviceId) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattSession>>> { unsafe {
        <Self as RtActivatable<IGattSessionStatics>>::get_activation_factory().from_device_id_async(deviceId)
    }}
}
DEFINE_CLSID!(GattSession(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,71,101,110,101,114,105,99,65,116,116,114,105,98,117,116,101,80,114,111,102,105,108,101,46,71,97,116,116,83,101,115,115,105,111,110,0]) [CLSID_GattSession]);
DEFINE_IID!(IID_IGattSessionStatics, 778418524, 21407, 19895, 130, 168, 115, 189, 187, 247, 62, 191);
RT_INTERFACE!{static interface IGattSessionStatics(IGattSessionStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattSessionStatics] {
    fn FromDeviceIdAsync(&self, deviceId: *mut super::BluetoothDeviceId, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattSession>) -> HRESULT
}}
impl IGattSessionStatics {
    #[inline] pub unsafe fn from_device_id_async(&self, deviceId: &super::BluetoothDeviceId) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattSession>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromDeviceIdAsync)(self as *const _ as *mut _, deviceId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum GattSessionStatus: i32 {
    Closed (GattSessionStatus_Closed) = 0, Active (GattSessionStatus_Active) = 1,
}}
DEFINE_IID!(IID_IGattSessionStatusChangedEventArgs, 1980086062, 33663, 16460, 171, 52, 49, 99, 243, 157, 223, 50);
RT_INTERFACE!{interface IGattSessionStatusChangedEventArgs(IGattSessionStatusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGattSessionStatusChangedEventArgs] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT,
    fn get_Status(&self, out: *mut GattSessionStatus) -> HRESULT
}}
impl IGattSessionStatusChangedEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<GattSessionStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattSessionStatusChangedEventArgs: IGattSessionStatusChangedEventArgs}
RT_ENUM! { enum GattSharingMode: i32 {
    Unspecified (GattSharingMode_Unspecified) = 0, Exclusive (GattSharingMode_Exclusive) = 1, SharedReadOnly (GattSharingMode_SharedReadOnly) = 2, SharedReadAndWrite (GattSharingMode_SharedReadAndWrite) = 3,
}}
DEFINE_IID!(IID_IGattSubscribedClient, 1936625665, 5540, 20162, 146, 72, 227, 242, 13, 70, 59, 233);
RT_INTERFACE!{interface IGattSubscribedClient(IGattSubscribedClientVtbl): IInspectable(IInspectableVtbl) [IID_IGattSubscribedClient] {
    fn get_Session(&self, out: *mut *mut GattSession) -> HRESULT,
    fn get_MaxNotificationSize(&self, out: *mut u16) -> HRESULT,
    fn add_MaxNotificationSizeChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattSubscribedClient, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MaxNotificationSizeChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGattSubscribedClient {
    #[inline] pub unsafe fn get_session(&self) -> Result<ComPtr<GattSession>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Session)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_notification_size(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxNotificationSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_max_notification_size_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattSubscribedClient, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MaxNotificationSizeChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_max_notification_size_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MaxNotificationSizeChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattSubscribedClient: IGattSubscribedClient}
DEFINE_IID!(IID_IGattValueChangedEventArgs, 3525040980, 1763, 20184, 162, 99, 172, 250, 200, 186, 115, 19);
RT_INTERFACE!{interface IGattValueChangedEventArgs(IGattValueChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGattValueChangedEventArgs] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_CharacteristicValue(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn get_Timestamp(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT
}}
impl IGattValueChangedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_characteristic_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CharacteristicValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GattValueChangedEventArgs: IGattValueChangedEventArgs}
RT_ENUM! { enum GattWriteOption: i32 {
    WriteWithResponse (GattWriteOption_WriteWithResponse) = 0, WriteWithoutResponse (GattWriteOption_WriteWithoutResponse) = 1,
}}
DEFINE_IID!(IID_IGattWriteRequest, 2931206637, 56879, 20418, 169, 168, 148, 234, 120, 68, 241, 61);
RT_INTERFACE!{interface IGattWriteRequest(IGattWriteRequestVtbl): IInspectable(IInspectableVtbl) [IID_IGattWriteRequest] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Value(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn get_Offset(&self, out: *mut u32) -> HRESULT,
    fn get_Option(&self, out: *mut GattWriteOption) -> HRESULT,
    fn get_State(&self, out: *mut GattRequestState) -> HRESULT,
    fn add_StateChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<GattWriteRequest, GattRequestStateChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn Respond(&self) -> HRESULT,
    fn RespondWithProtocolError(&self, protocolError: u8) -> HRESULT
}}
impl IGattWriteRequest {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_offset(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Offset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_option(&self) -> Result<GattWriteOption> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Option)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<GattRequestState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_state_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<GattWriteRequest, GattRequestStateChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn respond(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Respond)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn respond_with_protocol_error(&self, protocolError: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).RespondWithProtocolError)(self as *const _ as *mut _, protocolError);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattWriteRequest: IGattWriteRequest}
DEFINE_IID!(IID_IGattWriteRequestedEventArgs, 770476990, 42810, 18202, 148, 213, 3, 125, 234, 221, 8, 6);
RT_INTERFACE!{interface IGattWriteRequestedEventArgs(IGattWriteRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGattWriteRequestedEventArgs] {
    fn get_Session(&self, out: *mut *mut GattSession) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT,
    fn GetRequestAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<GattWriteRequest>) -> HRESULT
}}
impl IGattWriteRequestedEventArgs {
    #[inline] pub unsafe fn get_session(&self) -> Result<ComPtr<GattSession>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Session)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_request_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<GattWriteRequest>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRequestAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattWriteRequestedEventArgs: IGattWriteRequestedEventArgs}
DEFINE_IID!(IID_IGattWriteResult, 1234296241, 52011, 17655, 153, 252, 210, 154, 40, 113, 220, 155);
RT_INTERFACE!{interface IGattWriteResult(IGattWriteResultVtbl): IInspectable(IInspectableVtbl) [IID_IGattWriteResult] {
    fn get_Status(&self, out: *mut GattCommunicationStatus) -> HRESULT,
    fn get_ProtocolError(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u8>) -> HRESULT
}}
impl IGattWriteResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<GattCommunicationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protocol_error(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u8>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProtocolError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattWriteResult: IGattWriteResult}
} // Windows.Devices.Bluetooth.GenericAttributeProfile
pub mod advertisement { // Windows.Devices.Bluetooth.Advertisement
use ::prelude::*;
DEFINE_IID!(IID_IBluetoothLEAdvertisement, 107983543, 13265, 20093, 131, 103, 207, 129, 208, 247, 150, 83);
RT_INTERFACE!{interface IBluetoothLEAdvertisement(IBluetoothLEAdvertisementVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisement] {
    fn get_Flags(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<BluetoothLEAdvertisementFlags>) -> HRESULT,
    fn put_Flags(&self, value: *mut ::rt::gen::windows::foundation::IReference<BluetoothLEAdvertisementFlags>) -> HRESULT,
    fn get_LocalName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_LocalName(&self, value: HSTRING) -> HRESULT,
    fn get_ServiceUuids(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<Guid>) -> HRESULT,
    fn get_ManufacturerData(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<BluetoothLEManufacturerData>) -> HRESULT,
    fn get_DataSections(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<BluetoothLEAdvertisementDataSection>) -> HRESULT,
    fn GetManufacturerDataByCompanyId(&self, companyId: u16, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<BluetoothLEManufacturerData>) -> HRESULT,
    fn GetSectionsByType(&self, type_: u8, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<BluetoothLEAdvertisementDataSection>) -> HRESULT
}}
impl IBluetoothLEAdvertisement {
    #[inline] pub unsafe fn get_flags(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<BluetoothLEAdvertisementFlags>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Flags)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_flags(&self, value: &::rt::gen::windows::foundation::IReference<BluetoothLEAdvertisementFlags>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Flags)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_local_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LocalName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_local_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LocalName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_uuids(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<Guid>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ServiceUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manufacturer_data(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<BluetoothLEManufacturerData>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManufacturerData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_sections(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<BluetoothLEAdvertisementDataSection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataSections)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manufacturer_data_by_company_id(&self, companyId: u16) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<BluetoothLEManufacturerData>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetManufacturerDataByCompanyId)(self as *const _ as *mut _, companyId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sections_by_type(&self, type_: u8) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<BluetoothLEAdvertisementDataSection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSectionsByType)(self as *const _ as *mut _, type_, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisement: IBluetoothLEAdvertisement}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisement {}
DEFINE_CLSID!(BluetoothLEAdvertisement(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,0]) [CLSID_BluetoothLEAdvertisement]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementBytePattern, 4227520498, 47557, 18952, 188, 81, 80, 47, 142, 246, 138, 121);
RT_INTERFACE!{interface IBluetoothLEAdvertisementBytePattern(IBluetoothLEAdvertisementBytePatternVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementBytePattern] {
    fn get_DataType(&self, out: *mut u8) -> HRESULT,
    fn put_DataType(&self, value: u8) -> HRESULT,
    fn get_Offset(&self, out: *mut i16) -> HRESULT,
    fn put_Offset(&self, value: i16) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Data(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_Data(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT
}}
impl IBluetoothLEAdvertisementBytePattern {
    #[inline] pub unsafe fn get_data_type(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DataType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data_type(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_offset(&self) -> Result<i16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Offset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_offset(&self, value: i16) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Offset)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_data(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Data)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementBytePattern: IBluetoothLEAdvertisementBytePattern}
impl RtActivatable<IBluetoothLEAdvertisementBytePatternFactory> for BluetoothLEAdvertisementBytePattern {}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementBytePattern {}
impl BluetoothLEAdvertisementBytePattern {
    #[cfg(feature="windows-storage")] #[inline] pub fn create(dataType: u8, offset: i16, data: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<BluetoothLEAdvertisementBytePattern>> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementBytePatternFactory>>::get_activation_factory().create(dataType, offset, data)
    }}
}
DEFINE_CLSID!(BluetoothLEAdvertisementBytePattern(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,66,121,116,101,80,97,116,116,101,114,110,0]) [CLSID_BluetoothLEAdvertisementBytePattern]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementBytePatternFactory, 3269610867, 64860, 20163, 190, 42, 156, 166, 250, 17, 183, 189);
RT_INTERFACE!{static interface IBluetoothLEAdvertisementBytePatternFactory(IBluetoothLEAdvertisementBytePatternFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementBytePatternFactory] {
    #[cfg(feature="windows-storage")] fn Create(&self, dataType: u8, offset: i16, data: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut BluetoothLEAdvertisementBytePattern) -> HRESULT
}}
impl IBluetoothLEAdvertisementBytePatternFactory {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create(&self, dataType: u8, offset: i16, data: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<BluetoothLEAdvertisementBytePattern>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, dataType, offset, data as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEAdvertisementDataSection, 3609277204, 14915, 16633, 182, 240, 146, 191, 239, 195, 74, 227);
RT_INTERFACE!{interface IBluetoothLEAdvertisementDataSection(IBluetoothLEAdvertisementDataSectionVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementDataSection] {
    fn get_DataType(&self, out: *mut u8) -> HRESULT,
    fn put_DataType(&self, value: u8) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Data(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_Data(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT
}}
impl IBluetoothLEAdvertisementDataSection {
    #[inline] pub unsafe fn get_data_type(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DataType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data_type(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_data(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Data)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementDataSection: IBluetoothLEAdvertisementDataSection}
impl RtActivatable<IBluetoothLEAdvertisementDataSectionFactory> for BluetoothLEAdvertisementDataSection {}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementDataSection {}
impl BluetoothLEAdvertisementDataSection {
    #[cfg(feature="windows-storage")] #[inline] pub fn create(dataType: u8, data: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<BluetoothLEAdvertisementDataSection>> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataSectionFactory>>::get_activation_factory().create(dataType, data)
    }}
}
DEFINE_CLSID!(BluetoothLEAdvertisementDataSection(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,68,97,116,97,83,101,99,116,105,111,110,0]) [CLSID_BluetoothLEAdvertisementDataSection]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementDataSectionFactory, 3886287170, 43077, 16453, 191, 126, 62, 153, 113, 219, 138, 107);
RT_INTERFACE!{static interface IBluetoothLEAdvertisementDataSectionFactory(IBluetoothLEAdvertisementDataSectionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementDataSectionFactory] {
    #[cfg(feature="windows-storage")] fn Create(&self, dataType: u8, data: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut BluetoothLEAdvertisementDataSection) -> HRESULT
}}
impl IBluetoothLEAdvertisementDataSectionFactory {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create(&self, dataType: u8, data: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<BluetoothLEAdvertisementDataSection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, dataType, data as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class BluetoothLEAdvertisementDataTypes}
impl RtActivatable<IBluetoothLEAdvertisementDataTypesStatics> for BluetoothLEAdvertisementDataTypes {}
impl BluetoothLEAdvertisementDataTypes {
    #[inline] pub fn get_flags() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_flags()
    }}
    #[inline] pub fn get_incomplete_service16_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_incomplete_service16_bit_uuids()
    }}
    #[inline] pub fn get_complete_service16_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_complete_service16_bit_uuids()
    }}
    #[inline] pub fn get_incomplete_service32_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_incomplete_service32_bit_uuids()
    }}
    #[inline] pub fn get_complete_service32_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_complete_service32_bit_uuids()
    }}
    #[inline] pub fn get_incomplete_service128_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_incomplete_service128_bit_uuids()
    }}
    #[inline] pub fn get_complete_service128_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_complete_service128_bit_uuids()
    }}
    #[inline] pub fn get_shortened_local_name() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_shortened_local_name()
    }}
    #[inline] pub fn get_complete_local_name() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_complete_local_name()
    }}
    #[inline] pub fn get_tx_power_level() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_tx_power_level()
    }}
    #[inline] pub fn get_slave_connection_interval_range() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_slave_connection_interval_range()
    }}
    #[inline] pub fn get_service_solicitation16_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_service_solicitation16_bit_uuids()
    }}
    #[inline] pub fn get_service_solicitation32_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_service_solicitation32_bit_uuids()
    }}
    #[inline] pub fn get_service_solicitation128_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_service_solicitation128_bit_uuids()
    }}
    #[inline] pub fn get_service_data16_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_service_data16_bit_uuids()
    }}
    #[inline] pub fn get_service_data32_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_service_data32_bit_uuids()
    }}
    #[inline] pub fn get_service_data128_bit_uuids() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_service_data128_bit_uuids()
    }}
    #[inline] pub fn get_public_target_address() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_public_target_address()
    }}
    #[inline] pub fn get_random_target_address() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_random_target_address()
    }}
    #[inline] pub fn get_appearance() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_appearance()
    }}
    #[inline] pub fn get_advertising_interval() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_advertising_interval()
    }}
    #[inline] pub fn get_manufacturer_specific_data() -> Result<u8> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementDataTypesStatics>>::get_activation_factory().get_manufacturer_specific_data()
    }}
}
DEFINE_CLSID!(BluetoothLEAdvertisementDataTypes(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,68,97,116,97,84,121,112,101,115,0]) [CLSID_BluetoothLEAdvertisementDataTypes]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementDataTypesStatics, 1001801519, 1542, 17227, 167, 110, 116, 21, 159, 6, 132, 211);
RT_INTERFACE!{static interface IBluetoothLEAdvertisementDataTypesStatics(IBluetoothLEAdvertisementDataTypesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementDataTypesStatics] {
    fn get_Flags(&self, out: *mut u8) -> HRESULT,
    fn get_IncompleteService16BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_CompleteService16BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_IncompleteService32BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_CompleteService32BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_IncompleteService128BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_CompleteService128BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_ShortenedLocalName(&self, out: *mut u8) -> HRESULT,
    fn get_CompleteLocalName(&self, out: *mut u8) -> HRESULT,
    fn get_TxPowerLevel(&self, out: *mut u8) -> HRESULT,
    fn get_SlaveConnectionIntervalRange(&self, out: *mut u8) -> HRESULT,
    fn get_ServiceSolicitation16BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_ServiceSolicitation32BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_ServiceSolicitation128BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_ServiceData16BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_ServiceData32BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_ServiceData128BitUuids(&self, out: *mut u8) -> HRESULT,
    fn get_PublicTargetAddress(&self, out: *mut u8) -> HRESULT,
    fn get_RandomTargetAddress(&self, out: *mut u8) -> HRESULT,
    fn get_Appearance(&self, out: *mut u8) -> HRESULT,
    fn get_AdvertisingInterval(&self, out: *mut u8) -> HRESULT,
    fn get_ManufacturerSpecificData(&self, out: *mut u8) -> HRESULT
}}
impl IBluetoothLEAdvertisementDataTypesStatics {
    #[inline] pub unsafe fn get_flags(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Flags)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_incomplete_service16_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IncompleteService16BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_complete_service16_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompleteService16BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_incomplete_service32_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IncompleteService32BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_complete_service32_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompleteService32BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_incomplete_service128_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IncompleteService128BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_complete_service128_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompleteService128BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_shortened_local_name(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShortenedLocalName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_complete_local_name(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompleteLocalName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tx_power_level(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TxPowerLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_slave_connection_interval_range(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SlaveConnectionIntervalRange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_solicitation16_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceSolicitation16BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_solicitation32_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceSolicitation32BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_solicitation128_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceSolicitation128BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_data16_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceData16BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_data32_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceData32BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_data128_bit_uuids(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceData128BitUuids)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_public_target_address(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PublicTargetAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_random_target_address(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RandomTargetAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appearance(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Appearance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertising_interval(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AdvertisingInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manufacturer_specific_data(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ManufacturerSpecificData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBluetoothLEAdvertisementFilter, 320778451, 53326, 18353, 131, 126, 73, 64, 91, 246, 248, 15);
RT_INTERFACE!{interface IBluetoothLEAdvertisementFilter(IBluetoothLEAdvertisementFilterVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementFilter] {
    fn get_Advertisement(&self, out: *mut *mut BluetoothLEAdvertisement) -> HRESULT,
    fn put_Advertisement(&self, value: *mut BluetoothLEAdvertisement) -> HRESULT,
    fn get_BytePatterns(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<BluetoothLEAdvertisementBytePattern>) -> HRESULT
}}
impl IBluetoothLEAdvertisementFilter {
    #[inline] pub unsafe fn get_advertisement(&self) -> Result<ComPtr<BluetoothLEAdvertisement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Advertisement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_advertisement(&self, value: &BluetoothLEAdvertisement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Advertisement)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_byte_patterns(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<BluetoothLEAdvertisementBytePattern>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BytePatterns)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementFilter: IBluetoothLEAdvertisementFilter}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementFilter {}
DEFINE_CLSID!(BluetoothLEAdvertisementFilter(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,70,105,108,116,101,114,0]) [CLSID_BluetoothLEAdvertisementFilter]);
RT_ENUM! { enum BluetoothLEAdvertisementFlags: u32 {
    None (BluetoothLEAdvertisementFlags_None) = 0, LimitedDiscoverableMode (BluetoothLEAdvertisementFlags_LimitedDiscoverableMode) = 1, GeneralDiscoverableMode (BluetoothLEAdvertisementFlags_GeneralDiscoverableMode) = 2, ClassicNotSupported (BluetoothLEAdvertisementFlags_ClassicNotSupported) = 4, DualModeControllerCapable (BluetoothLEAdvertisementFlags_DualModeControllerCapable) = 8, DualModeHostCapable (BluetoothLEAdvertisementFlags_DualModeHostCapable) = 16,
}}
DEFINE_IID!(IID_IBluetoothLEAdvertisementPublisher, 3454542073, 55802, 17366, 162, 100, 221, 216, 183, 218, 139, 120);
RT_INTERFACE!{interface IBluetoothLEAdvertisementPublisher(IBluetoothLEAdvertisementPublisherVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementPublisher] {
    fn get_Status(&self, out: *mut BluetoothLEAdvertisementPublisherStatus) -> HRESULT,
    fn get_Advertisement(&self, out: *mut *mut BluetoothLEAdvertisement) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn add_StatusChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<BluetoothLEAdvertisementPublisher, BluetoothLEAdvertisementPublisherStatusChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StatusChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IBluetoothLEAdvertisementPublisher {
    #[inline] pub unsafe fn get_status(&self) -> Result<BluetoothLEAdvertisementPublisherStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertisement(&self) -> Result<ComPtr<BluetoothLEAdvertisement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Advertisement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_status_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<BluetoothLEAdvertisementPublisher, BluetoothLEAdvertisementPublisherStatusChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_status_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementPublisher: IBluetoothLEAdvertisementPublisher}
impl RtActivatable<IBluetoothLEAdvertisementPublisherFactory> for BluetoothLEAdvertisementPublisher {}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementPublisher {}
impl BluetoothLEAdvertisementPublisher {
    #[inline] pub fn create(advertisement: &BluetoothLEAdvertisement) -> Result<ComPtr<BluetoothLEAdvertisementPublisher>> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementPublisherFactory>>::get_activation_factory().create(advertisement)
    }}
}
DEFINE_CLSID!(BluetoothLEAdvertisementPublisher(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,80,117,98,108,105,115,104,101,114,0]) [CLSID_BluetoothLEAdvertisementPublisher]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementPublisherFactory, 1549731422, 47203, 18817, 161, 175, 28, 84, 77, 139, 12, 13);
RT_INTERFACE!{static interface IBluetoothLEAdvertisementPublisherFactory(IBluetoothLEAdvertisementPublisherFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementPublisherFactory] {
    fn Create(&self, advertisement: *mut BluetoothLEAdvertisement, out: *mut *mut BluetoothLEAdvertisementPublisher) -> HRESULT
}}
impl IBluetoothLEAdvertisementPublisherFactory {
    #[inline] pub unsafe fn create(&self, advertisement: &BluetoothLEAdvertisement) -> Result<ComPtr<BluetoothLEAdvertisementPublisher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, advertisement as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothLEAdvertisementPublisherStatus: i32 {
    Created (BluetoothLEAdvertisementPublisherStatus_Created) = 0, Waiting (BluetoothLEAdvertisementPublisherStatus_Waiting) = 1, Started (BluetoothLEAdvertisementPublisherStatus_Started) = 2, Stopping (BluetoothLEAdvertisementPublisherStatus_Stopping) = 3, Stopped (BluetoothLEAdvertisementPublisherStatus_Stopped) = 4, Aborted (BluetoothLEAdvertisementPublisherStatus_Aborted) = 5,
}}
DEFINE_IID!(IID_IBluetoothLEAdvertisementPublisherStatusChangedEventArgs, 163757471, 11775, 19235, 134, 238, 13, 20, 251, 148, 174, 174);
RT_INTERFACE!{interface IBluetoothLEAdvertisementPublisherStatusChangedEventArgs(IBluetoothLEAdvertisementPublisherStatusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementPublisherStatusChangedEventArgs] {
    fn get_Status(&self, out: *mut BluetoothLEAdvertisementPublisherStatus) -> HRESULT,
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT
}}
impl IBluetoothLEAdvertisementPublisherStatusChangedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<BluetoothLEAdvertisementPublisherStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementPublisherStatusChangedEventArgs: IBluetoothLEAdvertisementPublisherStatusChangedEventArgs}
DEFINE_IID!(IID_IBluetoothLEAdvertisementReceivedEventArgs, 664305119, 58774, 16830, 141, 67, 158, 103, 49, 212, 169, 19);
RT_INTERFACE!{interface IBluetoothLEAdvertisementReceivedEventArgs(IBluetoothLEAdvertisementReceivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementReceivedEventArgs] {
    fn get_RawSignalStrengthInDBm(&self, out: *mut i16) -> HRESULT,
    fn get_BluetoothAddress(&self, out: *mut u64) -> HRESULT,
    fn get_AdvertisementType(&self, out: *mut BluetoothLEAdvertisementType) -> HRESULT,
    fn get_Timestamp(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_Advertisement(&self, out: *mut *mut BluetoothLEAdvertisement) -> HRESULT
}}
impl IBluetoothLEAdvertisementReceivedEventArgs {
    #[inline] pub unsafe fn get_raw_signal_strength_in_dbm(&self) -> Result<i16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RawSignalStrengthInDBm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bluetooth_address(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BluetoothAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertisement_type(&self) -> Result<BluetoothLEAdvertisementType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AdvertisementType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertisement(&self) -> Result<ComPtr<BluetoothLEAdvertisement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Advertisement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementReceivedEventArgs: IBluetoothLEAdvertisementReceivedEventArgs}
RT_ENUM! { enum BluetoothLEAdvertisementType: i32 {
    ConnectableUndirected (BluetoothLEAdvertisementType_ConnectableUndirected) = 0, ConnectableDirected (BluetoothLEAdvertisementType_ConnectableDirected) = 1, ScannableUndirected (BluetoothLEAdvertisementType_ScannableUndirected) = 2, NonConnectableUndirected (BluetoothLEAdvertisementType_NonConnectableUndirected) = 3, ScanResponse (BluetoothLEAdvertisementType_ScanResponse) = 4,
}}
DEFINE_IID!(IID_IBluetoothLEAdvertisementWatcher, 2796303215, 62419, 17047, 141, 108, 200, 30, 166, 98, 63, 64);
RT_INTERFACE!{interface IBluetoothLEAdvertisementWatcher(IBluetoothLEAdvertisementWatcherVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementWatcher] {
    fn get_MinSamplingInterval(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_MaxSamplingInterval(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_MinOutOfRangeTimeout(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_MaxOutOfRangeTimeout(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_Status(&self, out: *mut BluetoothLEAdvertisementWatcherStatus) -> HRESULT,
    fn get_ScanningMode(&self, out: *mut BluetoothLEScanningMode) -> HRESULT,
    fn put_ScanningMode(&self, value: BluetoothLEScanningMode) -> HRESULT,
    fn get_SignalStrengthFilter(&self, out: *mut *mut super::BluetoothSignalStrengthFilter) -> HRESULT,
    fn put_SignalStrengthFilter(&self, value: *mut super::BluetoothSignalStrengthFilter) -> HRESULT,
    fn get_AdvertisementFilter(&self, out: *mut *mut BluetoothLEAdvertisementFilter) -> HRESULT,
    fn put_AdvertisementFilter(&self, value: *mut BluetoothLEAdvertisementFilter) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn add_Received(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<BluetoothLEAdvertisementWatcher, BluetoothLEAdvertisementReceivedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Received(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Stopped(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<BluetoothLEAdvertisementWatcher, BluetoothLEAdvertisementWatcherStoppedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IBluetoothLEAdvertisementWatcher {
    #[inline] pub unsafe fn get_min_sampling_interval(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinSamplingInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_sampling_interval(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSamplingInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_out_of_range_timeout(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinOutOfRangeTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_out_of_range_timeout(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxOutOfRangeTimeout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<BluetoothLEAdvertisementWatcherStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scanning_mode(&self) -> Result<BluetoothLEScanningMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScanningMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_scanning_mode(&self, value: BluetoothLEScanningMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ScanningMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_signal_strength_filter(&self) -> Result<ComPtr<super::BluetoothSignalStrengthFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SignalStrengthFilter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_signal_strength_filter(&self, value: &super::BluetoothSignalStrengthFilter) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SignalStrengthFilter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertisement_filter(&self) -> Result<ComPtr<BluetoothLEAdvertisementFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AdvertisementFilter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_advertisement_filter(&self, value: &BluetoothLEAdvertisementFilter) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AdvertisementFilter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_received(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<BluetoothLEAdvertisementWatcher, BluetoothLEAdvertisementReceivedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Received)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_received(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Received)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stopped(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<BluetoothLEAdvertisementWatcher, BluetoothLEAdvertisementWatcherStoppedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Stopped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Stopped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementWatcher: IBluetoothLEAdvertisementWatcher}
impl RtActivatable<IBluetoothLEAdvertisementWatcherFactory> for BluetoothLEAdvertisementWatcher {}
impl RtActivatable<IActivationFactory> for BluetoothLEAdvertisementWatcher {}
impl BluetoothLEAdvertisementWatcher {
    #[inline] pub fn create(advertisementFilter: &BluetoothLEAdvertisementFilter) -> Result<ComPtr<BluetoothLEAdvertisementWatcher>> { unsafe {
        <Self as RtActivatable<IBluetoothLEAdvertisementWatcherFactory>>::get_activation_factory().create(advertisementFilter)
    }}
}
DEFINE_CLSID!(BluetoothLEAdvertisementWatcher(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,65,100,118,101,114,116,105,115,101,109,101,110,116,87,97,116,99,104,101,114,0]) [CLSID_BluetoothLEAdvertisementWatcher]);
DEFINE_IID!(IID_IBluetoothLEAdvertisementWatcherFactory, 2595171670, 14764, 17726, 179, 42, 133, 198, 87, 224, 23, 241);
RT_INTERFACE!{static interface IBluetoothLEAdvertisementWatcherFactory(IBluetoothLEAdvertisementWatcherFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementWatcherFactory] {
    fn Create(&self, advertisementFilter: *mut BluetoothLEAdvertisementFilter, out: *mut *mut BluetoothLEAdvertisementWatcher) -> HRESULT
}}
impl IBluetoothLEAdvertisementWatcherFactory {
    #[inline] pub unsafe fn create(&self, advertisementFilter: &BluetoothLEAdvertisementFilter) -> Result<ComPtr<BluetoothLEAdvertisementWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, advertisementFilter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothLEAdvertisementWatcherStatus: i32 {
    Created (BluetoothLEAdvertisementWatcherStatus_Created) = 0, Started (BluetoothLEAdvertisementWatcherStatus_Started) = 1, Stopping (BluetoothLEAdvertisementWatcherStatus_Stopping) = 2, Stopped (BluetoothLEAdvertisementWatcherStatus_Stopped) = 3, Aborted (BluetoothLEAdvertisementWatcherStatus_Aborted) = 4,
}}
DEFINE_IID!(IID_IBluetoothLEAdvertisementWatcherStoppedEventArgs, 3712022605, 59321, 17379, 156, 4, 6, 133, 208, 133, 253, 140);
RT_INTERFACE!{interface IBluetoothLEAdvertisementWatcherStoppedEventArgs(IBluetoothLEAdvertisementWatcherStoppedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementWatcherStoppedEventArgs] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT
}}
impl IBluetoothLEAdvertisementWatcherStoppedEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementWatcherStoppedEventArgs: IBluetoothLEAdvertisementWatcherStoppedEventArgs}
DEFINE_IID!(IID_IBluetoothLEManufacturerData, 2435693080, 26979, 17715, 176, 97, 70, 148, 218, 251, 52, 229);
RT_INTERFACE!{interface IBluetoothLEManufacturerData(IBluetoothLEManufacturerDataVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEManufacturerData] {
    fn get_CompanyId(&self, out: *mut u16) -> HRESULT,
    fn put_CompanyId(&self, value: u16) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Data(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn put_Data(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT
}}
impl IBluetoothLEManufacturerData {
    #[inline] pub unsafe fn get_company_id(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompanyId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_company_id(&self, value: u16) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CompanyId)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_data(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Data)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEManufacturerData: IBluetoothLEManufacturerData}
impl RtActivatable<IBluetoothLEManufacturerDataFactory> for BluetoothLEManufacturerData {}
impl RtActivatable<IActivationFactory> for BluetoothLEManufacturerData {}
impl BluetoothLEManufacturerData {
    #[cfg(feature="windows-storage")] #[inline] pub fn create(companyId: u16, data: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<BluetoothLEManufacturerData>> { unsafe {
        <Self as RtActivatable<IBluetoothLEManufacturerDataFactory>>::get_activation_factory().create(companyId, data)
    }}
}
DEFINE_CLSID!(BluetoothLEManufacturerData(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,65,100,118,101,114,116,105,115,101,109,101,110,116,46,66,108,117,101,116,111,111,116,104,76,69,77,97,110,117,102,97,99,116,117,114,101,114,68,97,116,97,0]) [CLSID_BluetoothLEManufacturerData]);
DEFINE_IID!(IID_IBluetoothLEManufacturerDataFactory, 3231398392, 12698, 17438, 141, 229, 102, 168, 30, 135, 122, 108);
RT_INTERFACE!{static interface IBluetoothLEManufacturerDataFactory(IBluetoothLEManufacturerDataFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEManufacturerDataFactory] {
    #[cfg(feature="windows-storage")] fn Create(&self, companyId: u16, data: *mut ::rt::gen::windows::storage::streams::IBuffer, out: *mut *mut BluetoothLEManufacturerData) -> HRESULT
}}
impl IBluetoothLEManufacturerDataFactory {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create(&self, companyId: u16, data: &::rt::gen::windows::storage::streams::IBuffer) -> Result<ComPtr<BluetoothLEManufacturerData>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, companyId, data as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BluetoothLEScanningMode: i32 {
    Passive (BluetoothLEScanningMode_Passive) = 0, Active (BluetoothLEScanningMode_Active) = 1,
}}
} // Windows.Devices.Bluetooth.Advertisement
pub mod background { // Windows.Devices.Bluetooth.Background
use ::prelude::*;
RT_ENUM! { enum BluetoothEventTriggeringMode: i32 {
    Serial (BluetoothEventTriggeringMode_Serial) = 0, Batch (BluetoothEventTriggeringMode_Batch) = 1, KeepLatest (BluetoothEventTriggeringMode_KeepLatest) = 2,
}}
DEFINE_IID!(IID_IBluetoothLEAdvertisementPublisherTriggerDetails, 1628359302, 13440, 16841, 169, 24, 125, 218, 223, 32, 126, 0);
RT_INTERFACE!{interface IBluetoothLEAdvertisementPublisherTriggerDetails(IBluetoothLEAdvertisementPublisherTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementPublisherTriggerDetails] {
    fn get_Status(&self, out: *mut super::advertisement::BluetoothLEAdvertisementPublisherStatus) -> HRESULT,
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT
}}
impl IBluetoothLEAdvertisementPublisherTriggerDetails {
    #[inline] pub unsafe fn get_status(&self) -> Result<super::advertisement::BluetoothLEAdvertisementPublisherStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementPublisherTriggerDetails: IBluetoothLEAdvertisementPublisherTriggerDetails}
DEFINE_IID!(IID_IBluetoothLEAdvertisementWatcherTriggerDetails, 2816170711, 8791, 20073, 151, 132, 254, 230, 69, 193, 220, 224);
RT_INTERFACE!{interface IBluetoothLEAdvertisementWatcherTriggerDetails(IBluetoothLEAdvertisementWatcherTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IBluetoothLEAdvertisementWatcherTriggerDetails] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT,
    fn get_Advertisements(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<super::advertisement::BluetoothLEAdvertisementReceivedEventArgs>) -> HRESULT,
    fn get_SignalStrengthFilter(&self, out: *mut *mut super::BluetoothSignalStrengthFilter) -> HRESULT
}}
impl IBluetoothLEAdvertisementWatcherTriggerDetails {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advertisements(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<super::advertisement::BluetoothLEAdvertisementReceivedEventArgs>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Advertisements)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_signal_strength_filter(&self) -> Result<ComPtr<super::BluetoothSignalStrengthFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SignalStrengthFilter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BluetoothLEAdvertisementWatcherTriggerDetails: IBluetoothLEAdvertisementWatcherTriggerDetails}
DEFINE_IID!(IID_IGattCharacteristicNotificationTriggerDetails, 2610969368, 4076, 17258, 147, 177, 244, 108, 105, 117, 50, 162);
RT_INTERFACE!{interface IGattCharacteristicNotificationTriggerDetails(IGattCharacteristicNotificationTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicNotificationTriggerDetails] {
    fn get_Characteristic(&self, out: *mut *mut super::genericattributeprofile::GattCharacteristic) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Value(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT
}}
impl IGattCharacteristicNotificationTriggerDetails {
    #[inline] pub unsafe fn get_characteristic(&self) -> Result<ComPtr<super::genericattributeprofile::GattCharacteristic>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Characteristic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattCharacteristicNotificationTriggerDetails: IGattCharacteristicNotificationTriggerDetails}
DEFINE_IID!(IID_IGattCharacteristicNotificationTriggerDetails2, 1920618716, 38045, 17738, 177, 146, 152, 52, 103, 227, 213, 15);
RT_INTERFACE!{interface IGattCharacteristicNotificationTriggerDetails2(IGattCharacteristicNotificationTriggerDetails2Vtbl): IInspectable(IInspectableVtbl) [IID_IGattCharacteristicNotificationTriggerDetails2] {
    fn get_Error(&self, out: *mut super::BluetoothError) -> HRESULT,
    fn get_EventTriggeringMode(&self, out: *mut BluetoothEventTriggeringMode) -> HRESULT,
    fn get_ValueChangedEvents(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<super::genericattributeprofile::GattValueChangedEventArgs>) -> HRESULT
}}
impl IGattCharacteristicNotificationTriggerDetails2 {
    #[inline] pub unsafe fn get_error(&self) -> Result<super::BluetoothError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_event_triggering_mode(&self) -> Result<BluetoothEventTriggeringMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EventTriggeringMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value_changed_events(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<super::genericattributeprofile::GattValueChangedEventArgs>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ValueChangedEvents)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattServiceProviderConnection, 2141305273, 12051, 16565, 149, 130, 142, 183, 142, 152, 239, 19);
RT_INTERFACE!{interface IGattServiceProviderConnection(IGattServiceProviderConnectionVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderConnection] {
    fn get_TriggerId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Service(&self, out: *mut *mut super::genericattributeprofile::GattLocalService) -> HRESULT,
    fn Start(&self) -> HRESULT
}}
impl IGattServiceProviderConnection {
    #[inline] pub unsafe fn get_trigger_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TriggerId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service(&self) -> Result<ComPtr<super::genericattributeprofile::GattLocalService>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Service)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderConnection: IGattServiceProviderConnection}
impl RtActivatable<IGattServiceProviderConnectionStatics> for GattServiceProviderConnection {}
impl GattServiceProviderConnection {
    #[inline] pub fn get_all_services() -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<HString, GattServiceProviderConnection>>> { unsafe {
        <Self as RtActivatable<IGattServiceProviderConnectionStatics>>::get_activation_factory().get_all_services()
    }}
}
DEFINE_CLSID!(GattServiceProviderConnection(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,66,108,117,101,116,111,111,116,104,46,66,97,99,107,103,114,111,117,110,100,46,71,97,116,116,83,101,114,118,105,99,101,80,114,111,118,105,100,101,114,67,111,110,110,101,99,116,105,111,110,0]) [CLSID_GattServiceProviderConnection]);
DEFINE_IID!(IID_IGattServiceProviderConnectionStatics, 1028693835, 2830, 17510, 184, 205, 110, 189, 218, 31, 161, 125);
RT_INTERFACE!{static interface IGattServiceProviderConnectionStatics(IGattServiceProviderConnectionStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderConnectionStatics] {
    fn get_AllServices(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMapView<HString, GattServiceProviderConnection>) -> HRESULT
}}
impl IGattServiceProviderConnectionStatics {
    #[inline] pub unsafe fn get_all_services(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<HString, GattServiceProviderConnection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGattServiceProviderTriggerDetails, 2928412197, 1535, 19195, 177, 106, 222, 149, 243, 207, 1, 88);
RT_INTERFACE!{interface IGattServiceProviderTriggerDetails(IGattServiceProviderTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IGattServiceProviderTriggerDetails] {
    fn get_Connection(&self, out: *mut *mut GattServiceProviderConnection) -> HRESULT
}}
impl IGattServiceProviderTriggerDetails {
    #[inline] pub unsafe fn get_connection(&self) -> Result<ComPtr<GattServiceProviderConnection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Connection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GattServiceProviderTriggerDetails: IGattServiceProviderTriggerDetails}
DEFINE_IID!(IID_IRfcommConnectionTriggerDetails, 4179784525, 11836, 20220, 171, 89, 252, 92, 249, 111, 151, 227);
RT_INTERFACE!{interface IRfcommConnectionTriggerDetails(IRfcommConnectionTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommConnectionTriggerDetails] {
    #[cfg(not(feature="windows-networking"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-networking")] fn get_Socket(&self, out: *mut *mut ::rt::gen::windows::networking::sockets::StreamSocket) -> HRESULT,
    fn get_Incoming(&self, out: *mut bool) -> HRESULT,
    fn get_RemoteDevice(&self, out: *mut *mut super::BluetoothDevice) -> HRESULT
}}
impl IRfcommConnectionTriggerDetails {
    #[cfg(feature="windows-networking")] #[inline] pub unsafe fn get_socket(&self) -> Result<ComPtr<::rt::gen::windows::networking::sockets::StreamSocket>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Socket)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_incoming(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Incoming)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remote_device(&self) -> Result<ComPtr<super::BluetoothDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommConnectionTriggerDetails: IRfcommConnectionTriggerDetails}
DEFINE_IID!(IID_IRfcommInboundConnectionInformation, 1832809896, 21545, 16473, 146, 227, 30, 139, 101, 82, 135, 7);
RT_INTERFACE!{interface IRfcommInboundConnectionInformation(IRfcommInboundConnectionInformationVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommInboundConnectionInformation] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SdpRecord(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_SdpRecord(&self, value: *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT,
    fn get_LocalServiceId(&self, out: *mut *mut super::rfcomm::RfcommServiceId) -> HRESULT,
    fn put_LocalServiceId(&self, value: *mut super::rfcomm::RfcommServiceId) -> HRESULT,
    fn get_ServiceCapabilities(&self, out: *mut super::BluetoothServiceCapabilities) -> HRESULT,
    fn put_ServiceCapabilities(&self, value: super::BluetoothServiceCapabilities) -> HRESULT
}}
impl IRfcommInboundConnectionInformation {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_sdp_record(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SdpRecord)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_sdp_record(&self, value: &::rt::gen::windows::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SdpRecord)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_local_service_id(&self) -> Result<ComPtr<super::rfcomm::RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LocalServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_local_service_id(&self, value: &super::rfcomm::RfcommServiceId) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LocalServiceId)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_service_capabilities(&self) -> Result<super::BluetoothServiceCapabilities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ServiceCapabilities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_service_capabilities(&self, value: super::BluetoothServiceCapabilities) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ServiceCapabilities)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommInboundConnectionInformation: IRfcommInboundConnectionInformation}
DEFINE_IID!(IID_IRfcommOutboundConnectionInformation, 2962301563, 62516, 19632, 153, 177, 74, 184, 206, 218, 237, 215);
RT_INTERFACE!{interface IRfcommOutboundConnectionInformation(IRfcommOutboundConnectionInformationVtbl): IInspectable(IInspectableVtbl) [IID_IRfcommOutboundConnectionInformation] {
    fn get_RemoteServiceId(&self, out: *mut *mut super::rfcomm::RfcommServiceId) -> HRESULT,
    fn put_RemoteServiceId(&self, value: *mut super::rfcomm::RfcommServiceId) -> HRESULT
}}
impl IRfcommOutboundConnectionInformation {
    #[inline] pub unsafe fn get_remote_service_id(&self) -> Result<ComPtr<super::rfcomm::RfcommServiceId>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemoteServiceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_remote_service_id(&self, value: &super::rfcomm::RfcommServiceId) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RemoteServiceId)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RfcommOutboundConnectionInformation: IRfcommOutboundConnectionInformation}
} // Windows.Devices.Bluetooth.Background
} // Windows.Devices.Bluetooth
pub mod enumeration { // Windows.Devices.Enumeration
use ::prelude::*;
DEFINE_IID!(IID_IDeviceAccessChangedEventArgs, 3738831820, 20381, 20312, 157, 186, 169, 188, 128, 4, 8, 213);
RT_INTERFACE!{interface IDeviceAccessChangedEventArgs(IDeviceAccessChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceAccessChangedEventArgs] {
    fn get_Status(&self, out: *mut DeviceAccessStatus) -> HRESULT
}}
impl IDeviceAccessChangedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<DeviceAccessStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceAccessChangedEventArgs: IDeviceAccessChangedEventArgs}
DEFINE_IID!(IID_IDeviceAccessChangedEventArgs2, 2186424930, 37707, 19248, 161, 120, 173, 195, 159, 47, 43, 227);
RT_INTERFACE!{interface IDeviceAccessChangedEventArgs2(IDeviceAccessChangedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IDeviceAccessChangedEventArgs2] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT
}}
impl IDeviceAccessChangedEventArgs2 {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceAccessInformation, 195730035, 28133, 18709, 141, 221, 154, 5, 84, 166, 245, 69);
RT_INTERFACE!{interface IDeviceAccessInformation(IDeviceAccessInformationVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceAccessInformation] {
    fn add_AccessChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceAccessInformation, DeviceAccessChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AccessChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_CurrentStatus(&self, out: *mut DeviceAccessStatus) -> HRESULT
}}
impl IDeviceAccessInformation {
    #[inline] pub unsafe fn add_access_changed(&self, handler: &super::super::foundation::TypedEventHandler<DeviceAccessInformation, DeviceAccessChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AccessChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_access_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AccessChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_status(&self) -> Result<DeviceAccessStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceAccessInformation: IDeviceAccessInformation}
impl RtActivatable<IDeviceAccessInformationStatics> for DeviceAccessInformation {}
impl DeviceAccessInformation {
    #[inline] pub fn create_from_id(deviceId: &HStringArg) -> Result<ComPtr<DeviceAccessInformation>> { unsafe {
        <Self as RtActivatable<IDeviceAccessInformationStatics>>::get_activation_factory().create_from_id(deviceId)
    }}
    #[inline] pub fn create_from_device_class_id(deviceClassId: Guid) -> Result<ComPtr<DeviceAccessInformation>> { unsafe {
        <Self as RtActivatable<IDeviceAccessInformationStatics>>::get_activation_factory().create_from_device_class_id(deviceClassId)
    }}
    #[inline] pub fn create_from_device_class(deviceClass: DeviceClass) -> Result<ComPtr<DeviceAccessInformation>> { unsafe {
        <Self as RtActivatable<IDeviceAccessInformationStatics>>::get_activation_factory().create_from_device_class(deviceClass)
    }}
}
DEFINE_CLSID!(DeviceAccessInformation(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,69,110,117,109,101,114,97,116,105,111,110,46,68,101,118,105,99,101,65,99,99,101,115,115,73,110,102,111,114,109,97,116,105,111,110,0]) [CLSID_DeviceAccessInformation]);
DEFINE_IID!(IID_IDeviceAccessInformationStatics, 1464587219, 24368, 17869, 138, 148, 114, 79, 229, 151, 48, 132);
RT_INTERFACE!{static interface IDeviceAccessInformationStatics(IDeviceAccessInformationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceAccessInformationStatics] {
    fn CreateFromId(&self, deviceId: HSTRING, out: *mut *mut DeviceAccessInformation) -> HRESULT,
    fn CreateFromDeviceClassId(&self, deviceClassId: Guid, out: *mut *mut DeviceAccessInformation) -> HRESULT,
    fn CreateFromDeviceClass(&self, deviceClass: DeviceClass, out: *mut *mut DeviceAccessInformation) -> HRESULT
}}
impl IDeviceAccessInformationStatics {
    #[inline] pub unsafe fn create_from_id(&self, deviceId: &HStringArg) -> Result<ComPtr<DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromId)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_device_class_id(&self, deviceClassId: Guid) -> Result<ComPtr<DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromDeviceClassId)(self as *const _ as *mut _, deviceClassId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_device_class(&self, deviceClass: DeviceClass) -> Result<ComPtr<DeviceAccessInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromDeviceClass)(self as *const _ as *mut _, deviceClass, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum DeviceAccessStatus: i32 {
    Unspecified (DeviceAccessStatus_Unspecified) = 0, Allowed (DeviceAccessStatus_Allowed) = 1, DeniedByUser (DeviceAccessStatus_DeniedByUser) = 2, DeniedBySystem (DeviceAccessStatus_DeniedBySystem) = 3,
}}
RT_ENUM! { enum DeviceClass: i32 {
    All (DeviceClass_All) = 0, AudioCapture (DeviceClass_AudioCapture) = 1, AudioRender (DeviceClass_AudioRender) = 2, PortableStorageDevice (DeviceClass_PortableStorageDevice) = 3, VideoCapture (DeviceClass_VideoCapture) = 4, ImageScanner (DeviceClass_ImageScanner) = 5, Location (DeviceClass_Location) = 6,
}}
DEFINE_IID!(IID_IDeviceConnectionChangeTriggerDetails, 3092745228, 48065, 18507, 191, 250, 123, 49, 220, 194, 0, 178);
RT_INTERFACE!{interface IDeviceConnectionChangeTriggerDetails(IDeviceConnectionChangeTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceConnectionChangeTriggerDetails] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IDeviceConnectionChangeTriggerDetails {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceConnectionChangeTriggerDetails: IDeviceConnectionChangeTriggerDetails}
DEFINE_IID!(IID_IDeviceDisconnectButtonClickedEventArgs, 2386867565, 63746, 18944, 181, 54, 243, 121, 146, 230, 162, 167);
RT_INTERFACE!{interface IDeviceDisconnectButtonClickedEventArgs(IDeviceDisconnectButtonClickedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceDisconnectButtonClickedEventArgs] {
    fn get_Device(&self, out: *mut *mut DeviceInformation) -> HRESULT
}}
impl IDeviceDisconnectButtonClickedEventArgs {
    #[inline] pub unsafe fn get_device(&self) -> Result<ComPtr<DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Device)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceDisconnectButtonClickedEventArgs: IDeviceDisconnectButtonClickedEventArgs}
DEFINE_IID!(IID_IDeviceInformation, 2879454101, 17304, 18589, 142, 68, 230, 19, 9, 39, 1, 31);
RT_INTERFACE!{interface IDeviceInformation(IDeviceInformationVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformation] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsEnabled(&self, out: *mut bool) -> HRESULT,
    fn get_IsDefault(&self, out: *mut bool) -> HRESULT,
    fn get_EnclosureLocation(&self, out: *mut *mut EnclosureLocation) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT,
    fn Update(&self, updateInfo: *mut DeviceInformationUpdate) -> HRESULT,
    fn GetThumbnailAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceThumbnail>) -> HRESULT,
    fn GetGlyphThumbnailAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceThumbnail>) -> HRESULT
}}
impl IDeviceInformation {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_default(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enclosure_location(&self) -> Result<ComPtr<EnclosureLocation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EnclosureLocation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn update(&self, updateInfo: &DeviceInformationUpdate) -> Result<()> {
        let hr = ((*self.lpVtbl).Update)(self as *const _ as *mut _, updateInfo as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceThumbnail>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetThumbnailAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_glyph_thumbnail_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceThumbnail>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGlyphThumbnailAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceInformation: IDeviceInformation}
impl RtActivatable<IDeviceInformationStatics> for DeviceInformation {}
impl RtActivatable<IDeviceInformationStatics2> for DeviceInformation {}
impl DeviceInformation {
    #[inline] pub fn create_from_id_async(deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().create_from_id_async(deviceId)
    }}
    #[inline] pub fn create_from_id_async_additional_properties(deviceId: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().create_from_id_async_additional_properties(deviceId, additionalProperties)
    }}
    #[inline] pub fn find_all_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().find_all_async()
    }}
    #[inline] pub fn find_all_async_device_class(deviceClass: DeviceClass) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().find_all_async_device_class(deviceClass)
    }}
    #[inline] pub fn find_all_async_aqs_filter(aqsFilter: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().find_all_async_aqs_filter(aqsFilter)
    }}
    #[inline] pub fn find_all_async_aqs_filter_and_additional_properties(aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().find_all_async_aqs_filter_and_additional_properties(aqsFilter, additionalProperties)
    }}
    #[inline] pub fn create_watcher() -> Result<ComPtr<DeviceWatcher>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().create_watcher()
    }}
    #[inline] pub fn create_watcher_device_class(deviceClass: DeviceClass) -> Result<ComPtr<DeviceWatcher>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().create_watcher_device_class(deviceClass)
    }}
    #[inline] pub fn create_watcher_aqs_filter(aqsFilter: &HStringArg) -> Result<ComPtr<DeviceWatcher>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().create_watcher_aqs_filter(aqsFilter)
    }}
    #[inline] pub fn create_watcher_aqs_filter_and_additional_properties(aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<DeviceWatcher>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics>>::get_activation_factory().create_watcher_aqs_filter_and_additional_properties(aqsFilter, additionalProperties)
    }}
    #[inline] pub fn get_aqs_filter_from_device_class(deviceClass: DeviceClass) -> Result<HString> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics2>>::get_activation_factory().get_aqs_filter_from_device_class(deviceClass)
    }}
    #[inline] pub fn create_from_id_async_with_kind_and_additional_properties(deviceId: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics2>>::get_activation_factory().create_from_id_async_with_kind_and_additional_properties(deviceId, additionalProperties, kind)
    }}
    #[inline] pub fn find_all_async_with_kind_aqs_filter_and_additional_properties(aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics2>>::get_activation_factory().find_all_async_with_kind_aqs_filter_and_additional_properties(aqsFilter, additionalProperties, kind)
    }}
    #[inline] pub fn create_watcher_with_kind_aqs_filter_and_additional_properties(aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind) -> Result<ComPtr<DeviceWatcher>> { unsafe {
        <Self as RtActivatable<IDeviceInformationStatics2>>::get_activation_factory().create_watcher_with_kind_aqs_filter_and_additional_properties(aqsFilter, additionalProperties, kind)
    }}
}
DEFINE_CLSID!(DeviceInformation(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,69,110,117,109,101,114,97,116,105,111,110,46,68,101,118,105,99,101,73,110,102,111,114,109,97,116,105,111,110,0]) [CLSID_DeviceInformation]);
DEFINE_IID!(IID_IDeviceInformation2, 4048987704, 31127, 18649, 161, 12, 38, 157, 70, 83, 63, 72);
RT_INTERFACE!{interface IDeviceInformation2(IDeviceInformation2Vtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformation2] {
    fn get_Kind(&self, out: *mut DeviceInformationKind) -> HRESULT,
    fn get_Pairing(&self, out: *mut *mut DeviceInformationPairing) -> HRESULT
}}
impl IDeviceInformation2 {
    #[inline] pub unsafe fn get_kind(&self) -> Result<DeviceInformationKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pairing(&self) -> Result<ComPtr<DeviceInformationPairing>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Pairing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceInformationCollection: super::super::foundation::collections::IVectorView<DeviceInformation>}
DEFINE_IID!(IID_IDeviceInformationCustomPairing, 2232650754, 20198, 18708, 131, 112, 16, 122, 57, 20, 76, 14);
RT_INTERFACE!{interface IDeviceInformationCustomPairing(IDeviceInformationCustomPairingVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationCustomPairing] {
    fn PairAsync(&self, pairingKindsSupported: DevicePairingKinds, out: *mut *mut super::super::foundation::IAsyncOperation<DevicePairingResult>) -> HRESULT,
    fn PairWithProtectionLevelAsync(&self, pairingKindsSupported: DevicePairingKinds, minProtectionLevel: DevicePairingProtectionLevel, out: *mut *mut super::super::foundation::IAsyncOperation<DevicePairingResult>) -> HRESULT,
    fn PairWithProtectionLevelAndSettingsAsync(&self, pairingKindsSupported: DevicePairingKinds, minProtectionLevel: DevicePairingProtectionLevel, devicePairingSettings: *mut IDevicePairingSettings, out: *mut *mut super::super::foundation::IAsyncOperation<DevicePairingResult>) -> HRESULT,
    fn add_PairingRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceInformationCustomPairing, DevicePairingRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PairingRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IDeviceInformationCustomPairing {
    #[inline] pub unsafe fn pair_async(&self, pairingKindsSupported: DevicePairingKinds) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DevicePairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PairAsync)(self as *const _ as *mut _, pairingKindsSupported, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pair_with_protection_level_async(&self, pairingKindsSupported: DevicePairingKinds, minProtectionLevel: DevicePairingProtectionLevel) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DevicePairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PairWithProtectionLevelAsync)(self as *const _ as *mut _, pairingKindsSupported, minProtectionLevel, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pair_with_protection_level_and_settings_async(&self, pairingKindsSupported: DevicePairingKinds, minProtectionLevel: DevicePairingProtectionLevel, devicePairingSettings: &IDevicePairingSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DevicePairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PairWithProtectionLevelAndSettingsAsync)(self as *const _ as *mut _, pairingKindsSupported, minProtectionLevel, devicePairingSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pairing_requested(&self, handler: &super::super::foundation::TypedEventHandler<DeviceInformationCustomPairing, DevicePairingRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PairingRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pairing_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PairingRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceInformationCustomPairing: IDeviceInformationCustomPairing}
RT_ENUM! { enum DeviceInformationKind: i32 {
    Unknown (DeviceInformationKind_Unknown) = 0, DeviceInterface (DeviceInformationKind_DeviceInterface) = 1, DeviceContainer (DeviceInformationKind_DeviceContainer) = 2, Device (DeviceInformationKind_Device) = 3, DeviceInterfaceClass (DeviceInformationKind_DeviceInterfaceClass) = 4, AssociationEndpoint (DeviceInformationKind_AssociationEndpoint) = 5, AssociationEndpointContainer (DeviceInformationKind_AssociationEndpointContainer) = 6, AssociationEndpointService (DeviceInformationKind_AssociationEndpointService) = 7,
}}
DEFINE_IID!(IID_IDeviceInformationPairing, 742877685, 63108, 16597, 132, 105, 232, 219, 170, 183, 4, 133);
RT_INTERFACE!{interface IDeviceInformationPairing(IDeviceInformationPairingVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationPairing] {
    fn get_IsPaired(&self, out: *mut bool) -> HRESULT,
    fn get_CanPair(&self, out: *mut bool) -> HRESULT,
    fn PairAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<DevicePairingResult>) -> HRESULT,
    fn PairWithProtectionLevelAsync(&self, minProtectionLevel: DevicePairingProtectionLevel, out: *mut *mut super::super::foundation::IAsyncOperation<DevicePairingResult>) -> HRESULT
}}
impl IDeviceInformationPairing {
    #[inline] pub unsafe fn get_is_paired(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPaired)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_pair(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanPair)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn pair_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DevicePairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PairAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pair_with_protection_level_async(&self, minProtectionLevel: DevicePairingProtectionLevel) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DevicePairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PairWithProtectionLevelAsync)(self as *const _ as *mut _, minProtectionLevel, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceInformationPairing: IDeviceInformationPairing}
impl RtActivatable<IDeviceInformationPairingStatics> for DeviceInformationPairing {}
impl DeviceInformationPairing {
    #[inline] pub fn try_register_for_all_inbound_pairing_requests(pairingKindsSupported: DevicePairingKinds) -> Result<bool> { unsafe {
        <Self as RtActivatable<IDeviceInformationPairingStatics>>::get_activation_factory().try_register_for_all_inbound_pairing_requests(pairingKindsSupported)
    }}
}
DEFINE_CLSID!(DeviceInformationPairing(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,69,110,117,109,101,114,97,116,105,111,110,46,68,101,118,105,99,101,73,110,102,111,114,109,97,116,105,111,110,80,97,105,114,105,110,103,0]) [CLSID_DeviceInformationPairing]);
DEFINE_IID!(IID_IDeviceInformationPairing2, 4135981821, 2798, 17192, 133, 204, 28, 116, 43, 177, 121, 13);
RT_INTERFACE!{interface IDeviceInformationPairing2(IDeviceInformationPairing2Vtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationPairing2] {
    fn get_ProtectionLevel(&self, out: *mut DevicePairingProtectionLevel) -> HRESULT,
    fn get_Custom(&self, out: *mut *mut DeviceInformationCustomPairing) -> HRESULT,
    fn PairWithProtectionLevelAndSettingsAsync(&self, minProtectionLevel: DevicePairingProtectionLevel, devicePairingSettings: *mut IDevicePairingSettings, out: *mut *mut super::super::foundation::IAsyncOperation<DevicePairingResult>) -> HRESULT,
    fn UnpairAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceUnpairingResult>) -> HRESULT
}}
impl IDeviceInformationPairing2 {
    #[inline] pub unsafe fn get_protection_level(&self) -> Result<DevicePairingProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom(&self) -> Result<ComPtr<DeviceInformationCustomPairing>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Custom)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pair_with_protection_level_and_settings_async(&self, minProtectionLevel: DevicePairingProtectionLevel, devicePairingSettings: &IDevicePairingSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DevicePairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PairWithProtectionLevelAndSettingsAsync)(self as *const _ as *mut _, minProtectionLevel, devicePairingSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn unpair_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceUnpairingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UnpairAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceInformationPairingStatics, 3910517768, 14036, 18849, 191, 19, 81, 65, 115, 121, 155, 107);
RT_INTERFACE!{static interface IDeviceInformationPairingStatics(IDeviceInformationPairingStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationPairingStatics] {
    fn TryRegisterForAllInboundPairingRequests(&self, pairingKindsSupported: DevicePairingKinds, out: *mut bool) -> HRESULT
}}
impl IDeviceInformationPairingStatics {
    #[inline] pub unsafe fn try_register_for_all_inbound_pairing_requests(&self, pairingKindsSupported: DevicePairingKinds) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryRegisterForAllInboundPairingRequests)(self as *const _ as *mut _, pairingKindsSupported, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceInformationStatics, 3246329870, 14918, 19064, 128, 19, 118, 157, 201, 185, 115, 144);
RT_INTERFACE!{static interface IDeviceInformationStatics(IDeviceInformationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationStatics] {
    fn CreateFromIdAsync(&self, deviceId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformation>) -> HRESULT,
    fn CreateFromIdAsyncAdditionalProperties(&self, deviceId: HSTRING, additionalProperties: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformation>) -> HRESULT,
    fn FindAllAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformationCollection>) -> HRESULT,
    fn FindAllAsyncDeviceClass(&self, deviceClass: DeviceClass, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformationCollection>) -> HRESULT,
    fn FindAllAsyncAqsFilter(&self, aqsFilter: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformationCollection>) -> HRESULT,
    fn FindAllAsyncAqsFilterAndAdditionalProperties(&self, aqsFilter: HSTRING, additionalProperties: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformationCollection>) -> HRESULT,
    fn CreateWatcher(&self, out: *mut *mut DeviceWatcher) -> HRESULT,
    fn CreateWatcherDeviceClass(&self, deviceClass: DeviceClass, out: *mut *mut DeviceWatcher) -> HRESULT,
    fn CreateWatcherAqsFilter(&self, aqsFilter: HSTRING, out: *mut *mut DeviceWatcher) -> HRESULT,
    fn CreateWatcherAqsFilterAndAdditionalProperties(&self, aqsFilter: HSTRING, additionalProperties: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut DeviceWatcher) -> HRESULT
}}
impl IDeviceInformationStatics {
    #[inline] pub unsafe fn create_from_id_async(&self, deviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromIdAsync)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_id_async_additional_properties(&self, deviceId: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromIdAsyncAdditionalProperties)(self as *const _ as *mut _, deviceId.get(), additionalProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async_device_class(&self, deviceClass: DeviceClass) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsyncDeviceClass)(self as *const _ as *mut _, deviceClass, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async_aqs_filter(&self, aqsFilter: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsyncAqsFilter)(self as *const _ as *mut _, aqsFilter.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async_aqs_filter_and_additional_properties(&self, aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsyncAqsFilterAndAdditionalProperties)(self as *const _ as *mut _, aqsFilter.get(), additionalProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher(&self) -> Result<ComPtr<DeviceWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher_device_class(&self, deviceClass: DeviceClass) -> Result<ComPtr<DeviceWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcherDeviceClass)(self as *const _ as *mut _, deviceClass, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher_aqs_filter(&self, aqsFilter: &HStringArg) -> Result<ComPtr<DeviceWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcherAqsFilter)(self as *const _ as *mut _, aqsFilter.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher_aqs_filter_and_additional_properties(&self, aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<DeviceWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcherAqsFilterAndAdditionalProperties)(self as *const _ as *mut _, aqsFilter.get(), additionalProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceInformationStatics2, 1228623668, 43087, 17917, 145, 103, 21, 209, 203, 27, 209, 249);
RT_INTERFACE!{static interface IDeviceInformationStatics2(IDeviceInformationStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationStatics2] {
    fn GetAqsFilterFromDeviceClass(&self, deviceClass: DeviceClass, out: *mut HSTRING) -> HRESULT,
    fn CreateFromIdAsyncWithKindAndAdditionalProperties(&self, deviceId: HSTRING, additionalProperties: *mut super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformation>) -> HRESULT,
    fn FindAllAsyncWithKindAqsFilterAndAdditionalProperties(&self, aqsFilter: HSTRING, additionalProperties: *mut super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformationCollection>) -> HRESULT,
    fn CreateWatcherWithKindAqsFilterAndAdditionalProperties(&self, aqsFilter: HSTRING, additionalProperties: *mut super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind, out: *mut *mut DeviceWatcher) -> HRESULT
}}
impl IDeviceInformationStatics2 {
    #[inline] pub unsafe fn get_aqs_filter_from_device_class(&self, deviceClass: DeviceClass) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAqsFilterFromDeviceClass)(self as *const _ as *mut _, deviceClass, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_id_async_with_kind_and_additional_properties(&self, deviceId: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromIdAsyncWithKindAndAdditionalProperties)(self as *const _ as *mut _, deviceId.get(), additionalProperties as *const _ as *mut _, kind, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async_with_kind_aqs_filter_and_additional_properties(&self, aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformationCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsyncWithKindAqsFilterAndAdditionalProperties)(self as *const _ as *mut _, aqsFilter.get(), additionalProperties as *const _ as *mut _, kind, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher_with_kind_aqs_filter_and_additional_properties(&self, aqsFilter: &HStringArg, additionalProperties: &super::super::foundation::collections::IIterable<HString>, kind: DeviceInformationKind) -> Result<ComPtr<DeviceWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcherWithKindAqsFilterAndAdditionalProperties)(self as *const _ as *mut _, aqsFilter.get(), additionalProperties as *const _ as *mut _, kind, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceInformationUpdate, 2402374405, 55666, 17591, 163, 126, 158, 130, 44, 120, 33, 59);
RT_INTERFACE!{interface IDeviceInformationUpdate(IDeviceInformationUpdateVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationUpdate] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT
}}
impl IDeviceInformationUpdate {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceInformationUpdate: IDeviceInformationUpdate}
DEFINE_IID!(IID_IDeviceInformationUpdate2, 1570575500, 43123, 18526, 186, 166, 170, 98, 7, 136, 227, 204);
RT_INTERFACE!{interface IDeviceInformationUpdate2(IDeviceInformationUpdate2Vtbl): IInspectable(IInspectableVtbl) [IID_IDeviceInformationUpdate2] {
    fn get_Kind(&self, out: *mut DeviceInformationKind) -> HRESULT
}}
impl IDeviceInformationUpdate2 {
    #[inline] pub unsafe fn get_kind(&self) -> Result<DeviceInformationKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum DevicePairingKinds: u32 {
    None (DevicePairingKinds_None) = 0, ConfirmOnly (DevicePairingKinds_ConfirmOnly) = 1, DisplayPin (DevicePairingKinds_DisplayPin) = 2, ProvidePin (DevicePairingKinds_ProvidePin) = 4, ConfirmPinMatch (DevicePairingKinds_ConfirmPinMatch) = 8,
}}
RT_ENUM! { enum DevicePairingProtectionLevel: i32 {
    Default (DevicePairingProtectionLevel_Default) = 0, None (DevicePairingProtectionLevel_None) = 1, Encryption (DevicePairingProtectionLevel_Encryption) = 2, EncryptionAndAuthentication (DevicePairingProtectionLevel_EncryptionAndAuthentication) = 3,
}}
DEFINE_IID!(IID_IDevicePairingRequestedEventArgs, 4145544278, 56939, 18559, 131, 118, 1, 128, 172, 166, 153, 99);
RT_INTERFACE!{interface IDevicePairingRequestedEventArgs(IDevicePairingRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePairingRequestedEventArgs] {
    fn get_DeviceInformation(&self, out: *mut *mut DeviceInformation) -> HRESULT,
    fn get_PairingKind(&self, out: *mut DevicePairingKinds) -> HRESULT,
    fn get_Pin(&self, out: *mut HSTRING) -> HRESULT,
    fn Accept(&self) -> HRESULT,
    fn AcceptWithPin(&self, pin: HSTRING) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl IDevicePairingRequestedEventArgs {
    #[inline] pub unsafe fn get_device_information(&self) -> Result<ComPtr<DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pairing_kind(&self) -> Result<DevicePairingKinds> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PairingKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pin(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Pin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Accept)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn accept_with_pin(&self, pin: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).AcceptWithPin)(self as *const _ as *mut _, pin.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DevicePairingRequestedEventArgs: IDevicePairingRequestedEventArgs}
DEFINE_IID!(IID_IDevicePairingResult, 120259263, 56725, 16421, 155, 55, 222, 81, 173, 186, 55, 183);
RT_INTERFACE!{interface IDevicePairingResult(IDevicePairingResultVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePairingResult] {
    fn get_Status(&self, out: *mut DevicePairingResultStatus) -> HRESULT,
    fn get_ProtectionLevelUsed(&self, out: *mut DevicePairingProtectionLevel) -> HRESULT
}}
impl IDevicePairingResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<DevicePairingResultStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protection_level_used(&self) -> Result<DevicePairingProtectionLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectionLevelUsed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DevicePairingResult: IDevicePairingResult}
RT_ENUM! { enum DevicePairingResultStatus: i32 {
    Paired (DevicePairingResultStatus_Paired) = 0, NotReadyToPair (DevicePairingResultStatus_NotReadyToPair) = 1, NotPaired (DevicePairingResultStatus_NotPaired) = 2, AlreadyPaired (DevicePairingResultStatus_AlreadyPaired) = 3, ConnectionRejected (DevicePairingResultStatus_ConnectionRejected) = 4, TooManyConnections (DevicePairingResultStatus_TooManyConnections) = 5, HardwareFailure (DevicePairingResultStatus_HardwareFailure) = 6, AuthenticationTimeout (DevicePairingResultStatus_AuthenticationTimeout) = 7, AuthenticationNotAllowed (DevicePairingResultStatus_AuthenticationNotAllowed) = 8, AuthenticationFailure (DevicePairingResultStatus_AuthenticationFailure) = 9, NoSupportedProfiles (DevicePairingResultStatus_NoSupportedProfiles) = 10, ProtectionLevelCouldNotBeMet (DevicePairingResultStatus_ProtectionLevelCouldNotBeMet) = 11, AccessDenied (DevicePairingResultStatus_AccessDenied) = 12, InvalidCeremonyData (DevicePairingResultStatus_InvalidCeremonyData) = 13, PairingCanceled (DevicePairingResultStatus_PairingCanceled) = 14, OperationAlreadyInProgress (DevicePairingResultStatus_OperationAlreadyInProgress) = 15, RequiredHandlerNotRegistered (DevicePairingResultStatus_RequiredHandlerNotRegistered) = 16, RejectedByHandler (DevicePairingResultStatus_RejectedByHandler) = 17, RemoteDeviceHasAssociation (DevicePairingResultStatus_RemoteDeviceHasAssociation) = 18, Failed (DevicePairingResultStatus_Failed) = 19,
}}
DEFINE_IID!(IID_IDevicePairingSettings, 1210888828, 33723, 16910, 190, 81, 102, 2, 178, 34, 222, 84);
RT_INTERFACE!{interface IDevicePairingSettings(IDevicePairingSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePairingSettings] {
    
}}
DEFINE_IID!(IID_IDevicePicker, 2224650914, 842, 17472, 136, 19, 125, 11, 212, 121, 191, 90);
RT_INTERFACE!{interface IDevicePicker(IDevicePickerVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePicker] {
    fn get_Filter(&self, out: *mut *mut DevicePickerFilter) -> HRESULT,
    fn get_Appearance(&self, out: *mut *mut DevicePickerAppearance) -> HRESULT,
    fn get_RequestedProperties(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT,
    fn add_DeviceSelected(&self, handler: *mut super::super::foundation::TypedEventHandler<DevicePicker, DeviceSelectedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DeviceSelected(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DisconnectButtonClicked(&self, handler: *mut super::super::foundation::TypedEventHandler<DevicePicker, DeviceDisconnectButtonClickedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DisconnectButtonClicked(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DevicePickerDismissed(&self, handler: *mut super::super::foundation::TypedEventHandler<DevicePicker, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DevicePickerDismissed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Show(&self, selection: super::super::foundation::Rect) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowWithPlacement(&self, selection: super::super::foundation::Rect, placement: super::super::ui::popups::Placement) -> HRESULT,
    fn PickSingleDeviceAsync(&self, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformation>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy12(&self) -> (),
    #[cfg(feature="windows-ui")] fn PickSingleDeviceAsyncWithPlacement(&self, selection: super::super::foundation::Rect, placement: super::super::ui::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<DeviceInformation>) -> HRESULT,
    fn Hide(&self) -> HRESULT,
    fn SetDisplayStatus(&self, device: *mut DeviceInformation, status: HSTRING, options: DevicePickerDisplayStatusOptions) -> HRESULT
}}
impl IDevicePicker {
    #[inline] pub unsafe fn get_filter(&self) -> Result<ComPtr<DevicePickerFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Filter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_appearance(&self) -> Result<ComPtr<DevicePickerAppearance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Appearance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_requested_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RequestedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_device_selected(&self, handler: &super::super::foundation::TypedEventHandler<DevicePicker, DeviceSelectedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DeviceSelected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_device_selected(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DeviceSelected)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_disconnect_button_clicked(&self, handler: &super::super::foundation::TypedEventHandler<DevicePicker, DeviceDisconnectButtonClickedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DisconnectButtonClicked)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_disconnect_button_clicked(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DisconnectButtonClicked)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_device_picker_dismissed(&self, handler: &super::super::foundation::TypedEventHandler<DevicePicker, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DevicePickerDismissed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_device_picker_dismissed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DevicePickerDismissed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show(&self, selection: super::super::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).Show)(self as *const _ as *mut _, selection);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_with_placement(&self, selection: super::super::foundation::Rect, placement: super::super::ui::popups::Placement) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowWithPlacement)(self as *const _ as *mut _, selection, placement);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn pick_single_device_async(&self, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PickSingleDeviceAsync)(self as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn pick_single_device_async_with_placement(&self, selection: super::super::foundation::Rect, placement: super::super::ui::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<DeviceInformation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PickSingleDeviceAsyncWithPlacement)(self as *const _ as *mut _, selection, placement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn hide(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Hide)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_status(&self, device: &DeviceInformation, status: &HStringArg, options: DevicePickerDisplayStatusOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDisplayStatus)(self as *const _ as *mut _, device as *const _ as *mut _, status.get(), options);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DevicePicker: IDevicePicker}
impl RtActivatable<IActivationFactory> for DevicePicker {}
DEFINE_CLSID!(DevicePicker(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,69,110,117,109,101,114,97,116,105,111,110,46,68,101,118,105,99,101,80,105,99,107,101,114,0]) [CLSID_DevicePicker]);
DEFINE_IID!(IID_IDevicePickerAppearance, 3868857030, 58919, 20184, 155, 108, 70, 10, 244, 69, 229, 109);
RT_INTERFACE!{interface IDevicePickerAppearance(IDevicePickerAppearanceVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePickerAppearance] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_ForegroundColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_ForegroundColor(&self, value: super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_BackgroundColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_BackgroundColor(&self, value: super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_AccentColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_AccentColor(&self, value: super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_SelectedForegroundColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_SelectedForegroundColor(&self, value: super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_SelectedBackgroundColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_SelectedBackgroundColor(&self, value: super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_SelectedAccentColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_SelectedAccentColor(&self, value: super::super::ui::Color) -> HRESULT
}}
impl IDevicePickerAppearance {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_foreground_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_foreground_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ForegroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_background_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_background_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackgroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_accent_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AccentColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_accent_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AccentColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_selected_foreground_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectedForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_selected_foreground_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedForegroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_selected_background_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectedBackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_selected_background_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedBackgroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_selected_accent_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectedAccentColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_selected_accent_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedAccentColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DevicePickerAppearance: IDevicePickerAppearance}
RT_ENUM! { enum DevicePickerDisplayStatusOptions: u32 {
    None (DevicePickerDisplayStatusOptions_None) = 0, ShowProgress (DevicePickerDisplayStatusOptions_ShowProgress) = 1, ShowDisconnectButton (DevicePickerDisplayStatusOptions_ShowDisconnectButton) = 2, ShowRetryButton (DevicePickerDisplayStatusOptions_ShowRetryButton) = 4,
}}
DEFINE_IID!(IID_IDevicePickerFilter, 2447086242, 22475, 18673, 155, 89, 165, 155, 122, 31, 2, 162);
RT_INTERFACE!{interface IDevicePickerFilter(IDevicePickerFilterVtbl): IInspectable(IInspectableVtbl) [IID_IDevicePickerFilter] {
    fn get_SupportedDeviceClasses(&self, out: *mut *mut super::super::foundation::collections::IVector<DeviceClass>) -> HRESULT,
    fn get_SupportedDeviceSelectors(&self, out: *mut *mut super::super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IDevicePickerFilter {
    #[inline] pub unsafe fn get_supported_device_classes(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<DeviceClass>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedDeviceClasses)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_device_selectors(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedDeviceSelectors)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DevicePickerFilter: IDevicePickerFilter}
DEFINE_IID!(IID_IDeviceSelectedEventArgs, 647944926, 7471, 18752, 132, 2, 65, 86, 184, 29, 60, 119);
RT_INTERFACE!{interface IDeviceSelectedEventArgs(IDeviceSelectedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceSelectedEventArgs] {
    fn get_SelectedDevice(&self, out: *mut *mut DeviceInformation) -> HRESULT
}}
impl IDeviceSelectedEventArgs {
    #[inline] pub unsafe fn get_selected_device(&self) -> Result<ComPtr<DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceSelectedEventArgs: IDeviceSelectedEventArgs}
#[cfg(feature="windows-storage")] RT_CLASS!{class DeviceThumbnail: super::super::storage::streams::IRandomAccessStreamWithContentType}
#[cfg(not(feature="windows-storage"))] RT_CLASS!{class DeviceThumbnail: IInspectable}
DEFINE_IID!(IID_IDeviceUnpairingResult, 1727285971, 31193, 17483, 146, 207, 169, 46, 247, 37, 113, 199);
RT_INTERFACE!{interface IDeviceUnpairingResult(IDeviceUnpairingResultVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceUnpairingResult] {
    fn get_Status(&self, out: *mut DeviceUnpairingResultStatus) -> HRESULT
}}
impl IDeviceUnpairingResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<DeviceUnpairingResultStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceUnpairingResult: IDeviceUnpairingResult}
RT_ENUM! { enum DeviceUnpairingResultStatus: i32 {
    Unpaired (DeviceUnpairingResultStatus_Unpaired) = 0, AlreadyUnpaired (DeviceUnpairingResultStatus_AlreadyUnpaired) = 1, OperationAlreadyInProgress (DeviceUnpairingResultStatus_OperationAlreadyInProgress) = 2, AccessDenied (DeviceUnpairingResultStatus_AccessDenied) = 3, Failed (DeviceUnpairingResultStatus_Failed) = 4,
}}
DEFINE_IID!(IID_IDeviceWatcher, 3387603325, 36715, 20374, 169, 244, 171, 200, 20, 226, 34, 113);
RT_INTERFACE!{interface IDeviceWatcher(IDeviceWatcherVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceWatcher] {
    fn add_Added(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceWatcher, DeviceInformation>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Added(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Updated(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceWatcher, DeviceInformationUpdate>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Updated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Removed(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceWatcher, DeviceInformationUpdate>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Removed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_EnumerationCompleted(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceWatcher, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EnumerationCompleted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Stopped(&self, handler: *mut super::super::foundation::TypedEventHandler<DeviceWatcher, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Stopped(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Status(&self, out: *mut DeviceWatcherStatus) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT
}}
impl IDeviceWatcher {
    #[inline] pub unsafe fn add_added(&self, handler: &super::super::foundation::TypedEventHandler<DeviceWatcher, DeviceInformation>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Added)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_added(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Added)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_updated(&self, handler: &super::super::foundation::TypedEventHandler<DeviceWatcher, DeviceInformationUpdate>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Updated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_updated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Updated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_removed(&self, handler: &super::super::foundation::TypedEventHandler<DeviceWatcher, DeviceInformationUpdate>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Removed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_removed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Removed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_enumeration_completed(&self, handler: &super::super::foundation::TypedEventHandler<DeviceWatcher, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EnumerationCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_enumeration_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EnumerationCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stopped(&self, handler: &super::super::foundation::TypedEventHandler<DeviceWatcher, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Stopped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stopped(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Stopped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<DeviceWatcherStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceWatcher: IDeviceWatcher}
DEFINE_IID!(IID_IDeviceWatcher2, 4278732142, 60692, 18921, 154, 105, 129, 23, 197, 74, 233, 113);
RT_INTERFACE!{interface IDeviceWatcher2(IDeviceWatcher2Vtbl): IInspectable(IInspectableVtbl) [IID_IDeviceWatcher2] {
    #[cfg(feature="windows-applicationmodel")] fn GetBackgroundTrigger(&self, requestedEventKinds: *mut super::super::foundation::collections::IIterable<DeviceWatcherEventKind>, out: *mut *mut super::super::applicationmodel::background::DeviceWatcherTrigger) -> HRESULT
}}
impl IDeviceWatcher2 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_background_trigger(&self, requestedEventKinds: &super::super::foundation::collections::IIterable<DeviceWatcherEventKind>) -> Result<ComPtr<super::super::applicationmodel::background::DeviceWatcherTrigger>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetBackgroundTrigger)(self as *const _ as *mut _, requestedEventKinds as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeviceWatcherEvent, 1957338123, 7613, 18429, 182, 53, 60, 197, 86, 208, 255, 139);
RT_INTERFACE!{interface IDeviceWatcherEvent(IDeviceWatcherEventVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceWatcherEvent] {
    fn get_Kind(&self, out: *mut DeviceWatcherEventKind) -> HRESULT,
    fn get_DeviceInformation(&self, out: *mut *mut DeviceInformation) -> HRESULT,
    fn get_DeviceInformationUpdate(&self, out: *mut *mut DeviceInformationUpdate) -> HRESULT
}}
impl IDeviceWatcherEvent {
    #[inline] pub unsafe fn get_kind(&self) -> Result<DeviceWatcherEventKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_information(&self) -> Result<ComPtr<DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_information_update(&self) -> Result<ComPtr<DeviceInformationUpdate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformationUpdate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceWatcherEvent: IDeviceWatcherEvent}
RT_ENUM! { enum DeviceWatcherEventKind: i32 {
    Add (DeviceWatcherEventKind_Add) = 0, Update (DeviceWatcherEventKind_Update) = 1, Remove (DeviceWatcherEventKind_Remove) = 2,
}}
RT_ENUM! { enum DeviceWatcherStatus: i32 {
    Created (DeviceWatcherStatus_Created) = 0, Started (DeviceWatcherStatus_Started) = 1, EnumerationCompleted (DeviceWatcherStatus_EnumerationCompleted) = 2, Stopping (DeviceWatcherStatus_Stopping) = 3, Stopped (DeviceWatcherStatus_Stopped) = 4, Aborted (DeviceWatcherStatus_Aborted) = 5,
}}
DEFINE_IID!(IID_IDeviceWatcherTriggerDetails, 947945753, 19639, 20055, 165, 109, 119, 109, 7, 203, 254, 249);
RT_INTERFACE!{interface IDeviceWatcherTriggerDetails(IDeviceWatcherTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IDeviceWatcherTriggerDetails] {
    fn get_DeviceWatcherEvents(&self, out: *mut *mut super::super::foundation::collections::IVectorView<DeviceWatcherEvent>) -> HRESULT
}}
impl IDeviceWatcherTriggerDetails {
    #[inline] pub unsafe fn get_device_watcher_events(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<DeviceWatcherEvent>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceWatcherEvents)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DeviceWatcherTriggerDetails: IDeviceWatcherTriggerDetails}
DEFINE_IID!(IID_IEnclosureLocation, 1110706727, 22544, 17820, 170, 187, 198, 94, 31, 129, 62, 207);
RT_INTERFACE!{interface IEnclosureLocation(IEnclosureLocationVtbl): IInspectable(IInspectableVtbl) [IID_IEnclosureLocation] {
    fn get_InDock(&self, out: *mut bool) -> HRESULT,
    fn get_InLid(&self, out: *mut bool) -> HRESULT,
    fn get_Panel(&self, out: *mut Panel) -> HRESULT
}}
impl IEnclosureLocation {
    #[inline] pub unsafe fn get_in_dock(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InDock)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_in_lid(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InLid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_panel(&self) -> Result<Panel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Panel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class EnclosureLocation: IEnclosureLocation}
DEFINE_IID!(IID_IEnclosureLocation2, 679844187, 57469, 18525, 138, 158, 189, 242, 154, 239, 79, 102);
RT_INTERFACE!{interface IEnclosureLocation2(IEnclosureLocation2Vtbl): IInspectable(IInspectableVtbl) [IID_IEnclosureLocation2] {
    fn get_RotationAngleInDegreesClockwise(&self, out: *mut u32) -> HRESULT
}}
impl IEnclosureLocation2 {
    #[inline] pub unsafe fn get_rotation_angle_in_degrees_clockwise(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RotationAngleInDegreesClockwise)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum Panel: i32 {
    Unknown (Panel_Unknown) = 0, Front (Panel_Front) = 1, Back (Panel_Back) = 2, Top (Panel_Top) = 3, Bottom (Panel_Bottom) = 4, Left (Panel_Left) = 5, Right (Panel_Right) = 6,
}}
pub mod pnp { // Windows.Devices.Enumeration.Pnp
use ::prelude::*;
DEFINE_IID!(IID_IPnpObject, 2512806488, 29499, 19087, 147, 163, 219, 7, 138, 200, 112, 193);
RT_INTERFACE!{interface IPnpObject(IPnpObjectVtbl): IInspectable(IInspectableVtbl) [IID_IPnpObject] {
    fn get_Type(&self, out: *mut PnpObjectType) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT,
    fn Update(&self, updateInfo: *mut PnpObjectUpdate) -> HRESULT
}}
impl IPnpObject {
    #[inline] pub unsafe fn get_type(&self) -> Result<PnpObjectType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn update(&self, updateInfo: &PnpObjectUpdate) -> Result<()> {
        let hr = ((*self.lpVtbl).Update)(self as *const _ as *mut _, updateInfo as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PnpObject: IPnpObject}
impl RtActivatable<IPnpObjectStatics> for PnpObject {}
impl PnpObject {
    #[inline] pub fn create_from_id_async(type_: PnpObjectType, id: &HStringArg, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<PnpObject>>> { unsafe {
        <Self as RtActivatable<IPnpObjectStatics>>::get_activation_factory().create_from_id_async(type_, id, requestedProperties)
    }}
    #[inline] pub fn find_all_async(type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<PnpObjectCollection>>> { unsafe {
        <Self as RtActivatable<IPnpObjectStatics>>::get_activation_factory().find_all_async(type_, requestedProperties)
    }}
    #[inline] pub fn find_all_async_aqs_filter(type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>, aqsFilter: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<PnpObjectCollection>>> { unsafe {
        <Self as RtActivatable<IPnpObjectStatics>>::get_activation_factory().find_all_async_aqs_filter(type_, requestedProperties, aqsFilter)
    }}
    #[inline] pub fn create_watcher(type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>) -> Result<ComPtr<PnpObjectWatcher>> { unsafe {
        <Self as RtActivatable<IPnpObjectStatics>>::get_activation_factory().create_watcher(type_, requestedProperties)
    }}
    #[inline] pub fn create_watcher_aqs_filter(type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>, aqsFilter: &HStringArg) -> Result<ComPtr<PnpObjectWatcher>> { unsafe {
        <Self as RtActivatable<IPnpObjectStatics>>::get_activation_factory().create_watcher_aqs_filter(type_, requestedProperties, aqsFilter)
    }}
}
DEFINE_CLSID!(PnpObject(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,69,110,117,109,101,114,97,116,105,111,110,46,80,110,112,46,80,110,112,79,98,106,101,99,116,0]) [CLSID_PnpObject]);
RT_CLASS!{class PnpObjectCollection: ::rt::gen::windows::foundation::collections::IVectorView<PnpObject>}
DEFINE_IID!(IID_IPnpObjectStatics, 3015911997, 53608, 18016, 187, 243, 167, 51, 177, 75, 110, 1);
RT_INTERFACE!{static interface IPnpObjectStatics(IPnpObjectStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPnpObjectStatics] {
    fn CreateFromIdAsync(&self, type_: PnpObjectType, id: HSTRING, requestedProperties: *mut ::rt::gen::windows::foundation::collections::IIterable<HString>, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<PnpObject>) -> HRESULT,
    fn FindAllAsync(&self, type_: PnpObjectType, requestedProperties: *mut ::rt::gen::windows::foundation::collections::IIterable<HString>, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<PnpObjectCollection>) -> HRESULT,
    fn FindAllAsyncAqsFilter(&self, type_: PnpObjectType, requestedProperties: *mut ::rt::gen::windows::foundation::collections::IIterable<HString>, aqsFilter: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<PnpObjectCollection>) -> HRESULT,
    fn CreateWatcher(&self, type_: PnpObjectType, requestedProperties: *mut ::rt::gen::windows::foundation::collections::IIterable<HString>, out: *mut *mut PnpObjectWatcher) -> HRESULT,
    fn CreateWatcherAqsFilter(&self, type_: PnpObjectType, requestedProperties: *mut ::rt::gen::windows::foundation::collections::IIterable<HString>, aqsFilter: HSTRING, out: *mut *mut PnpObjectWatcher) -> HRESULT
}}
impl IPnpObjectStatics {
    #[inline] pub unsafe fn create_from_id_async(&self, type_: PnpObjectType, id: &HStringArg, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<PnpObject>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromIdAsync)(self as *const _ as *mut _, type_, id.get(), requestedProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async(&self, type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<PnpObjectCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsync)(self as *const _ as *mut _, type_, requestedProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async_aqs_filter(&self, type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>, aqsFilter: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<PnpObjectCollection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsyncAqsFilter)(self as *const _ as *mut _, type_, requestedProperties as *const _ as *mut _, aqsFilter.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher(&self, type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>) -> Result<ComPtr<PnpObjectWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcher)(self as *const _ as *mut _, type_, requestedProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_watcher_aqs_filter(&self, type_: PnpObjectType, requestedProperties: &::rt::gen::windows::foundation::collections::IIterable<HString>, aqsFilter: &HStringArg) -> Result<ComPtr<PnpObjectWatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWatcherAqsFilter)(self as *const _ as *mut _, type_, requestedProperties as *const _ as *mut _, aqsFilter.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum PnpObjectType: i32 {
    Unknown (PnpObjectType_Unknown) = 0, DeviceInterface (PnpObjectType_DeviceInterface) = 1, DeviceContainer (PnpObjectType_DeviceContainer) = 2, Device (PnpObjectType_Device) = 3, DeviceInterfaceClass (PnpObjectType_DeviceInterfaceClass) = 4, AssociationEndpoint (PnpObjectType_AssociationEndpoint) = 5, AssociationEndpointContainer (PnpObjectType_AssociationEndpointContainer) = 6, AssociationEndpointService (PnpObjectType_AssociationEndpointService) = 7,
}}
DEFINE_IID!(IID_IPnpObjectUpdate, 1868163090, 30, 18500, 188, 198, 67, 40, 134, 133, 106, 23);
RT_INTERFACE!{interface IPnpObjectUpdate(IPnpObjectUpdateVtbl): IInspectable(IInspectableVtbl) [IID_IPnpObjectUpdate] {
    fn get_Type(&self, out: *mut PnpObjectType) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMapView<HString, IInspectable>) -> HRESULT
}}
impl IPnpObjectUpdate {
    #[inline] pub unsafe fn get_type(&self) -> Result<PnpObjectType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<HString, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PnpObjectUpdate: IPnpObjectUpdate}
DEFINE_IID!(IID_IPnpObjectWatcher, 2211011752, 18290, 19066, 172, 168, 228, 140, 66, 168, 156, 68);
RT_INTERFACE!{interface IPnpObjectWatcher(IPnpObjectWatcherVtbl): IInspectable(IInspectableVtbl) [IID_IPnpObjectWatcher] {
    fn add_Added(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, PnpObject>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Added(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Updated(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, PnpObjectUpdate>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Updated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Removed(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, PnpObjectUpdate>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Removed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_EnumerationCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EnumerationCompleted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Stopped(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Status(&self, out: *mut super::DeviceWatcherStatus) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT
}}
impl IPnpObjectWatcher {
    #[inline] pub unsafe fn add_added(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, PnpObject>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Added)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_added(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Added)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_updated(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, PnpObjectUpdate>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Updated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_updated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Updated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_removed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, PnpObjectUpdate>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Removed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_removed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Removed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_enumeration_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EnumerationCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_enumeration_completed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EnumerationCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stopped(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<PnpObjectWatcher, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Stopped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Stopped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<super::DeviceWatcherStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PnpObjectWatcher: IPnpObjectWatcher}
} // Windows.Devices.Enumeration.Pnp
} // Windows.Devices.Enumeration
pub mod geolocation { // Windows.Devices.Geolocation
use ::prelude::*;
RT_ENUM! { enum AltitudeReferenceSystem: i32 {
    Unspecified (AltitudeReferenceSystem_Unspecified) = 0, Terrain (AltitudeReferenceSystem_Terrain) = 1, Ellipsoid (AltitudeReferenceSystem_Ellipsoid) = 2, Geoid (AltitudeReferenceSystem_Geoid) = 3, Surface (AltitudeReferenceSystem_Surface) = 4,
}}
RT_STRUCT! { struct BasicGeoposition {
    Latitude: f64, Longitude: f64, Altitude: f64,
}}
DEFINE_IID!(IID_ICivicAddress, 2824239642, 25844, 19784, 188, 234, 246, 176, 8, 236, 163, 76);
RT_INTERFACE!{interface ICivicAddress(ICivicAddressVtbl): IInspectable(IInspectableVtbl) [IID_ICivicAddress] {
    fn get_Country(&self, out: *mut HSTRING) -> HRESULT,
    fn get_State(&self, out: *mut HSTRING) -> HRESULT,
    fn get_City(&self, out: *mut HSTRING) -> HRESULT,
    fn get_PostalCode(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT
}}
impl ICivicAddress {
    #[inline] pub unsafe fn get_country(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Country)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_city(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_City)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_postal_code(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PostalCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CivicAddress: ICivicAddress}
DEFINE_IID!(IID_IGeoboundingBox, 144099339, 10063, 17370, 154, 6, 203, 252, 218, 235, 78, 194);
RT_INTERFACE!{interface IGeoboundingBox(IGeoboundingBoxVtbl): IInspectable(IInspectableVtbl) [IID_IGeoboundingBox] {
    fn get_NorthwestCorner(&self, out: *mut BasicGeoposition) -> HRESULT,
    fn get_SoutheastCorner(&self, out: *mut BasicGeoposition) -> HRESULT,
    fn get_Center(&self, out: *mut BasicGeoposition) -> HRESULT,
    fn get_MinAltitude(&self, out: *mut f64) -> HRESULT,
    fn get_MaxAltitude(&self, out: *mut f64) -> HRESULT
}}
impl IGeoboundingBox {
    #[inline] pub unsafe fn get_northwest_corner(&self) -> Result<BasicGeoposition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NorthwestCorner)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_southeast_corner(&self) -> Result<BasicGeoposition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SoutheastCorner)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_center(&self) -> Result<BasicGeoposition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Center)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_altitude(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinAltitude)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_altitude(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxAltitude)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GeoboundingBox: IGeoboundingBox}
impl RtActivatable<IGeoboundingBoxFactory> for GeoboundingBox {}
impl RtActivatable<IGeoboundingBoxStatics> for GeoboundingBox {}
impl GeoboundingBox {
    #[inline] pub fn create(northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition) -> Result<ComPtr<GeoboundingBox>> { unsafe {
        <Self as RtActivatable<IGeoboundingBoxFactory>>::get_activation_factory().create(northwestCorner, southeastCorner)
    }}
    #[inline] pub fn create_with_altitude_reference(northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<GeoboundingBox>> { unsafe {
        <Self as RtActivatable<IGeoboundingBoxFactory>>::get_activation_factory().create_with_altitude_reference(northwestCorner, southeastCorner, altitudeReferenceSystem)
    }}
    #[inline] pub fn create_with_altitude_reference_and_spatial_reference(northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<GeoboundingBox>> { unsafe {
        <Self as RtActivatable<IGeoboundingBoxFactory>>::get_activation_factory().create_with_altitude_reference_and_spatial_reference(northwestCorner, southeastCorner, altitudeReferenceSystem, spatialReferenceId)
    }}
    #[inline] pub fn try_compute(positions: &super::super::foundation::collections::IIterable<BasicGeoposition>) -> Result<ComPtr<GeoboundingBox>> { unsafe {
        <Self as RtActivatable<IGeoboundingBoxStatics>>::get_activation_factory().try_compute(positions)
    }}
    #[inline] pub fn try_compute_with_altitude_reference(positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeRefSystem: AltitudeReferenceSystem) -> Result<ComPtr<GeoboundingBox>> { unsafe {
        <Self as RtActivatable<IGeoboundingBoxStatics>>::get_activation_factory().try_compute_with_altitude_reference(positions, altitudeRefSystem)
    }}
    #[inline] pub fn try_compute_with_altitude_reference_and_spatial_reference(positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeRefSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<GeoboundingBox>> { unsafe {
        <Self as RtActivatable<IGeoboundingBoxStatics>>::get_activation_factory().try_compute_with_altitude_reference_and_spatial_reference(positions, altitudeRefSystem, spatialReferenceId)
    }}
}
DEFINE_CLSID!(GeoboundingBox(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,101,111,108,111,99,97,116,105,111,110,46,71,101,111,98,111,117,110,100,105,110,103,66,111,120,0]) [CLSID_GeoboundingBox]);
DEFINE_IID!(IID_IGeoboundingBoxFactory, 1308337545, 1041, 19132, 179, 181, 91, 188, 203, 87, 217, 140);
RT_INTERFACE!{static interface IGeoboundingBoxFactory(IGeoboundingBoxFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGeoboundingBoxFactory] {
    fn Create(&self, northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, out: *mut *mut GeoboundingBox) -> HRESULT,
    fn CreateWithAltitudeReference(&self, northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, out: *mut *mut GeoboundingBox) -> HRESULT,
    fn CreateWithAltitudeReferenceAndSpatialReference(&self, northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32, out: *mut *mut GeoboundingBox) -> HRESULT
}}
impl IGeoboundingBoxFactory {
    #[inline] pub unsafe fn create(&self, northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition) -> Result<ComPtr<GeoboundingBox>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, northwestCorner, southeastCorner, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference(&self, northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<GeoboundingBox>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReference)(self as *const _ as *mut _, northwestCorner, southeastCorner, altitudeReferenceSystem, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference_and_spatial_reference(&self, northwestCorner: BasicGeoposition, southeastCorner: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<GeoboundingBox>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReferenceAndSpatialReference)(self as *const _ as *mut _, northwestCorner, southeastCorner, altitudeReferenceSystem, spatialReferenceId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeoboundingBoxStatics, 1740113672, 58906, 19664, 132, 27, 147, 35, 55, 146, 181, 202);
RT_INTERFACE!{static interface IGeoboundingBoxStatics(IGeoboundingBoxStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGeoboundingBoxStatics] {
    fn TryCompute(&self, positions: *mut super::super::foundation::collections::IIterable<BasicGeoposition>, out: *mut *mut GeoboundingBox) -> HRESULT,
    fn TryComputeWithAltitudeReference(&self, positions: *mut super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeRefSystem: AltitudeReferenceSystem, out: *mut *mut GeoboundingBox) -> HRESULT,
    fn TryComputeWithAltitudeReferenceAndSpatialReference(&self, positions: *mut super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeRefSystem: AltitudeReferenceSystem, spatialReferenceId: u32, out: *mut *mut GeoboundingBox) -> HRESULT
}}
impl IGeoboundingBoxStatics {
    #[inline] pub unsafe fn try_compute(&self, positions: &super::super::foundation::collections::IIterable<BasicGeoposition>) -> Result<ComPtr<GeoboundingBox>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCompute)(self as *const _ as *mut _, positions as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_compute_with_altitude_reference(&self, positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeRefSystem: AltitudeReferenceSystem) -> Result<ComPtr<GeoboundingBox>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryComputeWithAltitudeReference)(self as *const _ as *mut _, positions as *const _ as *mut _, altitudeRefSystem, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_compute_with_altitude_reference_and_spatial_reference(&self, positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeRefSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<GeoboundingBox>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryComputeWithAltitudeReferenceAndSpatialReference)(self as *const _ as *mut _, positions as *const _ as *mut _, altitudeRefSystem, spatialReferenceId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeocircle, 971266115, 43001, 20067, 146, 167, 186, 12, 40, 209, 36, 177);
RT_INTERFACE!{interface IGeocircle(IGeocircleVtbl): IInspectable(IInspectableVtbl) [IID_IGeocircle] {
    fn get_Center(&self, out: *mut BasicGeoposition) -> HRESULT,
    fn get_Radius(&self, out: *mut f64) -> HRESULT
}}
impl IGeocircle {
    #[inline] pub unsafe fn get_center(&self) -> Result<BasicGeoposition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Center)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_radius(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Radius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class Geocircle: IGeocircle}
impl RtActivatable<IGeocircleFactory> for Geocircle {}
impl Geocircle {
    #[inline] pub fn create(position: BasicGeoposition, radius: f64) -> Result<ComPtr<Geocircle>> { unsafe {
        <Self as RtActivatable<IGeocircleFactory>>::get_activation_factory().create(position, radius)
    }}
    #[inline] pub fn create_with_altitude_reference_system(position: BasicGeoposition, radius: f64, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<Geocircle>> { unsafe {
        <Self as RtActivatable<IGeocircleFactory>>::get_activation_factory().create_with_altitude_reference_system(position, radius, altitudeReferenceSystem)
    }}
    #[inline] pub fn create_with_altitude_reference_system_and_spatial_reference_id(position: BasicGeoposition, radius: f64, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<Geocircle>> { unsafe {
        <Self as RtActivatable<IGeocircleFactory>>::get_activation_factory().create_with_altitude_reference_system_and_spatial_reference_id(position, radius, altitudeReferenceSystem, spatialReferenceId)
    }}
}
DEFINE_CLSID!(Geocircle(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,101,111,108,111,99,97,116,105,111,110,46,71,101,111,99,105,114,99,108,101,0]) [CLSID_Geocircle]);
DEFINE_IID!(IID_IGeocircleFactory, 2950058783, 29361, 20349, 135, 204, 78, 212, 201, 132, 156, 5);
RT_INTERFACE!{static interface IGeocircleFactory(IGeocircleFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGeocircleFactory] {
    fn Create(&self, position: BasicGeoposition, radius: f64, out: *mut *mut Geocircle) -> HRESULT,
    fn CreateWithAltitudeReferenceSystem(&self, position: BasicGeoposition, radius: f64, altitudeReferenceSystem: AltitudeReferenceSystem, out: *mut *mut Geocircle) -> HRESULT,
    fn CreateWithAltitudeReferenceSystemAndSpatialReferenceId(&self, position: BasicGeoposition, radius: f64, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32, out: *mut *mut Geocircle) -> HRESULT
}}
impl IGeocircleFactory {
    #[inline] pub unsafe fn create(&self, position: BasicGeoposition, radius: f64) -> Result<ComPtr<Geocircle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, position, radius, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference_system(&self, position: BasicGeoposition, radius: f64, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<Geocircle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReferenceSystem)(self as *const _ as *mut _, position, radius, altitudeReferenceSystem, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference_system_and_spatial_reference_id(&self, position: BasicGeoposition, radius: f64, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<Geocircle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReferenceSystemAndSpatialReferenceId)(self as *const _ as *mut _, position, radius, altitudeReferenceSystem, spatialReferenceId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeocoordinate, 3995181994, 38762, 19568, 128, 61, 8, 62, 165, 91, 203, 196);
RT_INTERFACE!{interface IGeocoordinate(IGeocoordinateVtbl): IInspectable(IInspectableVtbl) [IID_IGeocoordinate] {
    fn get_Latitude(&self, out: *mut f64) -> HRESULT,
    fn get_Longitude(&self, out: *mut f64) -> HRESULT,
    fn get_Altitude(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_Accuracy(&self, out: *mut f64) -> HRESULT,
    fn get_AltitudeAccuracy(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_Heading(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_Speed(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT
}}
impl IGeocoordinate {
    #[inline] pub unsafe fn get_latitude(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Latitude)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_longitude(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Longitude)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_altitude(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Altitude)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_accuracy(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Accuracy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_altitude_accuracy(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AltitudeAccuracy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_heading(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Heading)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_speed(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Speed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class Geocoordinate: IGeocoordinate}
DEFINE_IID!(IID_IGeocoordinateSatelliteData, 3274339545, 9736, 18252, 145, 44, 6, 221, 73, 15, 74, 247);
RT_INTERFACE!{interface IGeocoordinateSatelliteData(IGeocoordinateSatelliteDataVtbl): IInspectable(IInspectableVtbl) [IID_IGeocoordinateSatelliteData] {
    fn get_PositionDilutionOfPrecision(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_HorizontalDilutionOfPrecision(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_VerticalDilutionOfPrecision(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT
}}
impl IGeocoordinateSatelliteData {
    #[inline] pub unsafe fn get_position_dilution_of_precision(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PositionDilutionOfPrecision)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_dilution_of_precision(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HorizontalDilutionOfPrecision)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_dilution_of_precision(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VerticalDilutionOfPrecision)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GeocoordinateSatelliteData: IGeocoordinateSatelliteData}
DEFINE_IID!(IID_IGeocoordinateWithPoint, 4276749605, 53804, 19782, 181, 39, 11, 150, 6, 111, 199, 219);
RT_INTERFACE!{interface IGeocoordinateWithPoint(IGeocoordinateWithPointVtbl): IInspectable(IInspectableVtbl) [IID_IGeocoordinateWithPoint] {
    fn get_Point(&self, out: *mut *mut Geopoint) -> HRESULT
}}
impl IGeocoordinateWithPoint {
    #[inline] pub unsafe fn get_point(&self) -> Result<ComPtr<Geopoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Point)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeocoordinateWithPositionData, 2514891966, 56278, 16556, 184, 242, 166, 92, 3, 64, 217, 166);
RT_INTERFACE!{interface IGeocoordinateWithPositionData(IGeocoordinateWithPositionDataVtbl): IInspectable(IInspectableVtbl) [IID_IGeocoordinateWithPositionData] {
    fn get_PositionSource(&self, out: *mut PositionSource) -> HRESULT,
    fn get_SatelliteData(&self, out: *mut *mut GeocoordinateSatelliteData) -> HRESULT
}}
impl IGeocoordinateWithPositionData {
    #[inline] pub unsafe fn get_position_source(&self) -> Result<PositionSource> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_satellite_data(&self) -> Result<ComPtr<GeocoordinateSatelliteData>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SatelliteData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeocoordinateWithPositionSourceTimestamp, 2235825154, 51697, 17936, 175, 224, 139, 195, 166, 168, 112, 54);
RT_INTERFACE!{interface IGeocoordinateWithPositionSourceTimestamp(IGeocoordinateWithPositionSourceTimestampVtbl): IInspectable(IInspectableVtbl) [IID_IGeocoordinateWithPositionSourceTimestamp] {
    fn get_PositionSourceTimestamp(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT
}}
impl IGeocoordinateWithPositionSourceTimestamp {
    #[inline] pub unsafe fn get_position_source_timestamp(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PositionSourceTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum GeolocationAccessStatus: i32 {
    Unspecified (GeolocationAccessStatus_Unspecified) = 0, Allowed (GeolocationAccessStatus_Allowed) = 1, Denied (GeolocationAccessStatus_Denied) = 2,
}}
DEFINE_IID!(IID_IGeolocator, 2848178018, 17700, 18825, 138, 169, 222, 1, 157, 46, 85, 31);
RT_INTERFACE!{interface IGeolocator(IGeolocatorVtbl): IInspectable(IInspectableVtbl) [IID_IGeolocator] {
    fn get_DesiredAccuracy(&self, out: *mut PositionAccuracy) -> HRESULT,
    fn put_DesiredAccuracy(&self, value: PositionAccuracy) -> HRESULT,
    fn get_MovementThreshold(&self, out: *mut f64) -> HRESULT,
    fn put_MovementThreshold(&self, value: f64) -> HRESULT,
    fn get_ReportInterval(&self, out: *mut u32) -> HRESULT,
    fn put_ReportInterval(&self, value: u32) -> HRESULT,
    fn get_LocationStatus(&self, out: *mut PositionStatus) -> HRESULT,
    fn GetGeopositionAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<Geoposition>) -> HRESULT,
    fn GetGeopositionAsyncWithAgeAndTimeout(&self, maximumAge: super::super::foundation::TimeSpan, timeout: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<Geoposition>) -> HRESULT,
    fn add_PositionChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<Geolocator, PositionChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PositionChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<Geolocator, StatusChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGeolocator {
    #[inline] pub unsafe fn get_desired_accuracy(&self) -> Result<PositionAccuracy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredAccuracy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_accuracy(&self, value: PositionAccuracy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredAccuracy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_movement_threshold(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MovementThreshold)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_movement_threshold(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MovementThreshold)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_report_interval(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReportInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_report_interval(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReportInterval)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_location_status(&self) -> Result<PositionStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LocationStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_geoposition_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Geoposition>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGeopositionAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_geoposition_async_with_age_and_timeout(&self, maximumAge: super::super::foundation::TimeSpan, timeout: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Geoposition>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGeopositionAsyncWithAgeAndTimeout)(self as *const _ as *mut _, maximumAge, timeout, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_position_changed(&self, handler: &super::super::foundation::TypedEventHandler<Geolocator, PositionChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PositionChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_position_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PositionChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<Geolocator, StatusChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Geolocator: IGeolocator}
impl RtActivatable<IGeolocatorStatics> for Geolocator {}
impl RtActivatable<IGeolocatorStatics2> for Geolocator {}
impl RtActivatable<IActivationFactory> for Geolocator {}
impl Geolocator {
    #[inline] pub fn request_access_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<GeolocationAccessStatus>>> { unsafe {
        <Self as RtActivatable<IGeolocatorStatics>>::get_activation_factory().request_access_async()
    }}
    #[inline] pub fn get_geoposition_history_async(startTime: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Geoposition>>>> { unsafe {
        <Self as RtActivatable<IGeolocatorStatics>>::get_activation_factory().get_geoposition_history_async(startTime)
    }}
    #[inline] pub fn get_geoposition_history_with_duration_async(startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Geoposition>>>> { unsafe {
        <Self as RtActivatable<IGeolocatorStatics>>::get_activation_factory().get_geoposition_history_with_duration_async(startTime, duration)
    }}
    #[inline] pub fn get_is_default_geoposition_recommended() -> Result<bool> { unsafe {
        <Self as RtActivatable<IGeolocatorStatics2>>::get_activation_factory().get_is_default_geoposition_recommended()
    }}
    #[inline] pub fn set_default_geoposition(value: &super::super::foundation::IReference<BasicGeoposition>) -> Result<()> { unsafe {
        <Self as RtActivatable<IGeolocatorStatics2>>::get_activation_factory().set_default_geoposition(value)
    }}
    #[inline] pub fn get_default_geoposition() -> Result<ComPtr<super::super::foundation::IReference<BasicGeoposition>>> { unsafe {
        <Self as RtActivatable<IGeolocatorStatics2>>::get_activation_factory().get_default_geoposition()
    }}
}
DEFINE_CLSID!(Geolocator(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,101,111,108,111,99,97,116,105,111,110,46,71,101,111,108,111,99,97,116,111,114,0]) [CLSID_Geolocator]);
DEFINE_IID!(IID_IGeolocator2, 3518246509, 34961, 17332, 173, 54, 39, 198, 254, 154, 151, 177);
RT_INTERFACE!{interface IGeolocator2(IGeolocator2Vtbl): IInspectable(IInspectableVtbl) [IID_IGeolocator2] {
    fn AllowFallbackToConsentlessPositions(&self) -> HRESULT
}}
impl IGeolocator2 {
    #[inline] pub unsafe fn allow_fallback_to_consentless_positions(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).AllowFallbackToConsentlessPositions)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeolocatorStatics, 2593027441, 11765, 17809, 159, 135, 235, 95, 216, 148, 233, 183);
RT_INTERFACE!{static interface IGeolocatorStatics(IGeolocatorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGeolocatorStatics] {
    fn RequestAccessAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<GeolocationAccessStatus>) -> HRESULT,
    fn GetGeopositionHistoryAsync(&self, startTime: super::super::foundation::DateTime, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Geoposition>>) -> HRESULT,
    fn GetGeopositionHistoryWithDurationAsync(&self, startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Geoposition>>) -> HRESULT
}}
impl IGeolocatorStatics {
    #[inline] pub unsafe fn request_access_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<GeolocationAccessStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAccessAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_geoposition_history_async(&self, startTime: super::super::foundation::DateTime) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Geoposition>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGeopositionHistoryAsync)(self as *const _ as *mut _, startTime, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_geoposition_history_with_duration_async(&self, startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<Geoposition>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGeopositionHistoryWithDurationAsync)(self as *const _ as *mut _, startTime, duration, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeolocatorStatics2, 2570064290, 64028, 17969, 167, 29, 13, 190, 177, 37, 13, 156);
RT_INTERFACE!{static interface IGeolocatorStatics2(IGeolocatorStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGeolocatorStatics2] {
    fn get_IsDefaultGeopositionRecommended(&self, out: *mut bool) -> HRESULT,
    fn put_DefaultGeoposition(&self, value: *mut super::super::foundation::IReference<BasicGeoposition>) -> HRESULT,
    fn get_DefaultGeoposition(&self, out: *mut *mut super::super::foundation::IReference<BasicGeoposition>) -> HRESULT
}}
impl IGeolocatorStatics2 {
    #[inline] pub unsafe fn get_is_default_geoposition_recommended(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDefaultGeopositionRecommended)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_geoposition(&self, value: &super::super::foundation::IReference<BasicGeoposition>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultGeoposition)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_geoposition(&self) -> Result<ComPtr<super::super::foundation::IReference<BasicGeoposition>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultGeoposition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeolocatorWithScalarAccuracy, 2532692929, 47119, 17930, 153, 77, 169, 108, 71, 165, 26, 164);
RT_INTERFACE!{interface IGeolocatorWithScalarAccuracy(IGeolocatorWithScalarAccuracyVtbl): IInspectable(IInspectableVtbl) [IID_IGeolocatorWithScalarAccuracy] {
    fn get_DesiredAccuracyInMeters(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_DesiredAccuracyInMeters(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT
}}
impl IGeolocatorWithScalarAccuracy {
    #[inline] pub unsafe fn get_desired_accuracy_in_meters(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DesiredAccuracyInMeters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_accuracy_in_meters(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredAccuracyInMeters)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeopath, 3846166457, 11684, 18196, 166, 82, 222, 133, 147, 40, 152, 152);
RT_INTERFACE!{interface IGeopath(IGeopathVtbl): IInspectable(IInspectableVtbl) [IID_IGeopath] {
    fn get_Positions(&self, out: *mut *mut super::super::foundation::collections::IVectorView<BasicGeoposition>) -> HRESULT
}}
impl IGeopath {
    #[inline] pub unsafe fn get_positions(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<BasicGeoposition>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Positions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Geopath: IGeopath}
impl RtActivatable<IGeopathFactory> for Geopath {}
impl Geopath {
    #[inline] pub fn create(positions: &super::super::foundation::collections::IIterable<BasicGeoposition>) -> Result<ComPtr<Geopath>> { unsafe {
        <Self as RtActivatable<IGeopathFactory>>::get_activation_factory().create(positions)
    }}
    #[inline] pub fn create_with_altitude_reference(positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<Geopath>> { unsafe {
        <Self as RtActivatable<IGeopathFactory>>::get_activation_factory().create_with_altitude_reference(positions, altitudeReferenceSystem)
    }}
    #[inline] pub fn create_with_altitude_reference_and_spatial_reference(positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<Geopath>> { unsafe {
        <Self as RtActivatable<IGeopathFactory>>::get_activation_factory().create_with_altitude_reference_and_spatial_reference(positions, altitudeReferenceSystem, spatialReferenceId)
    }}
}
DEFINE_CLSID!(Geopath(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,101,111,108,111,99,97,116,105,111,110,46,71,101,111,112,97,116,104,0]) [CLSID_Geopath]);
DEFINE_IID!(IID_IGeopathFactory, 666806728, 51175, 17241, 155, 155, 252, 163, 224, 94, 245, 147);
RT_INTERFACE!{static interface IGeopathFactory(IGeopathFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGeopathFactory] {
    fn Create(&self, positions: *mut super::super::foundation::collections::IIterable<BasicGeoposition>, out: *mut *mut Geopath) -> HRESULT,
    fn CreateWithAltitudeReference(&self, positions: *mut super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeReferenceSystem: AltitudeReferenceSystem, out: *mut *mut Geopath) -> HRESULT,
    fn CreateWithAltitudeReferenceAndSpatialReference(&self, positions: *mut super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32, out: *mut *mut Geopath) -> HRESULT
}}
impl IGeopathFactory {
    #[inline] pub unsafe fn create(&self, positions: &super::super::foundation::collections::IIterable<BasicGeoposition>) -> Result<ComPtr<Geopath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, positions as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference(&self, positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<Geopath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReference)(self as *const _ as *mut _, positions as *const _ as *mut _, altitudeReferenceSystem, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference_and_spatial_reference(&self, positions: &super::super::foundation::collections::IIterable<BasicGeoposition>, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<Geopath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReferenceAndSpatialReference)(self as *const _ as *mut _, positions as *const _ as *mut _, altitudeReferenceSystem, spatialReferenceId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeopoint, 1811546347, 58734, 18875, 156, 175, 203, 170, 120, 168, 188, 239);
RT_INTERFACE!{interface IGeopoint(IGeopointVtbl): IInspectable(IInspectableVtbl) [IID_IGeopoint] {
    fn get_Position(&self, out: *mut BasicGeoposition) -> HRESULT
}}
impl IGeopoint {
    #[inline] pub unsafe fn get_position(&self) -> Result<BasicGeoposition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class Geopoint: IGeopoint}
impl RtActivatable<IGeopointFactory> for Geopoint {}
impl Geopoint {
    #[inline] pub fn create(position: BasicGeoposition) -> Result<ComPtr<Geopoint>> { unsafe {
        <Self as RtActivatable<IGeopointFactory>>::get_activation_factory().create(position)
    }}
    #[inline] pub fn create_with_altitude_reference_system(position: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<Geopoint>> { unsafe {
        <Self as RtActivatable<IGeopointFactory>>::get_activation_factory().create_with_altitude_reference_system(position, altitudeReferenceSystem)
    }}
    #[inline] pub fn create_with_altitude_reference_system_and_spatial_reference_id(position: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<Geopoint>> { unsafe {
        <Self as RtActivatable<IGeopointFactory>>::get_activation_factory().create_with_altitude_reference_system_and_spatial_reference_id(position, altitudeReferenceSystem, spatialReferenceId)
    }}
}
DEFINE_CLSID!(Geopoint(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,101,111,108,111,99,97,116,105,111,110,46,71,101,111,112,111,105,110,116,0]) [CLSID_Geopoint]);
DEFINE_IID!(IID_IGeopointFactory, 3681258803, 30397, 20016, 138, 247, 168, 68, 220, 55, 183, 160);
RT_INTERFACE!{static interface IGeopointFactory(IGeopointFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGeopointFactory] {
    fn Create(&self, position: BasicGeoposition, out: *mut *mut Geopoint) -> HRESULT,
    fn CreateWithAltitudeReferenceSystem(&self, position: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, out: *mut *mut Geopoint) -> HRESULT,
    fn CreateWithAltitudeReferenceSystemAndSpatialReferenceId(&self, position: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32, out: *mut *mut Geopoint) -> HRESULT
}}
impl IGeopointFactory {
    #[inline] pub unsafe fn create(&self, position: BasicGeoposition) -> Result<ComPtr<Geopoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, position, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference_system(&self, position: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem) -> Result<ComPtr<Geopoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReferenceSystem)(self as *const _ as *mut _, position, altitudeReferenceSystem, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_altitude_reference_system_and_spatial_reference_id(&self, position: BasicGeoposition, altitudeReferenceSystem: AltitudeReferenceSystem, spatialReferenceId: u32) -> Result<ComPtr<Geopoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAltitudeReferenceSystemAndSpatialReferenceId)(self as *const _ as *mut _, position, altitudeReferenceSystem, spatialReferenceId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeoposition, 3247244372, 32065, 20471, 169, 87, 157, 255, 180, 239, 127, 91);
RT_INTERFACE!{interface IGeoposition(IGeopositionVtbl): IInspectable(IInspectableVtbl) [IID_IGeoposition] {
    fn get_Coordinate(&self, out: *mut *mut Geocoordinate) -> HRESULT,
    fn get_CivicAddress(&self, out: *mut *mut CivicAddress) -> HRESULT
}}
impl IGeoposition {
    #[inline] pub unsafe fn get_coordinate(&self) -> Result<ComPtr<Geocoordinate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Coordinate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_civic_address(&self) -> Result<ComPtr<CivicAddress>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CivicAddress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Geoposition: IGeoposition}
DEFINE_IID!(IID_IGeoposition2, 2137192087, 34417, 19213, 134, 248, 71, 74, 132, 150, 24, 124);
RT_INTERFACE!{interface IGeoposition2(IGeoposition2Vtbl): IInspectable(IInspectableVtbl) [IID_IGeoposition2] {
    fn get_VenueData(&self, out: *mut *mut VenueData) -> HRESULT
}}
impl IGeoposition2 {
    #[inline] pub unsafe fn get_venue_data(&self) -> Result<ComPtr<VenueData>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VenueData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeoshape, 3382485679, 50985, 17345, 143, 171, 214, 222, 201, 20, 223, 126);
RT_INTERFACE!{interface IGeoshape(IGeoshapeVtbl): IInspectable(IInspectableVtbl) [IID_IGeoshape] {
    fn get_GeoshapeType(&self, out: *mut GeoshapeType) -> HRESULT,
    fn get_SpatialReferenceId(&self, out: *mut u32) -> HRESULT,
    fn get_AltitudeReferenceSystem(&self, out: *mut AltitudeReferenceSystem) -> HRESULT
}}
impl IGeoshape {
    #[inline] pub unsafe fn get_geoshape_type(&self) -> Result<GeoshapeType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GeoshapeType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_spatial_reference_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpatialReferenceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_altitude_reference_system(&self) -> Result<AltitudeReferenceSystem> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AltitudeReferenceSystem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum GeoshapeType: i32 {
    Geopoint (GeoshapeType_Geopoint) = 0, Geocircle (GeoshapeType_Geocircle) = 1, Geopath (GeoshapeType_Geopath) = 2, GeoboundingBox (GeoshapeType_GeoboundingBox) = 3,
}}
DEFINE_IID!(IID_IGeovisit, 2978445942, 40694, 16811, 160, 221, 121, 62, 206, 118, 226, 222);
RT_INTERFACE!{interface IGeovisit(IGeovisitVtbl): IInspectable(IInspectableVtbl) [IID_IGeovisit] {
    fn get_Position(&self, out: *mut *mut Geoposition) -> HRESULT,
    fn get_StateChange(&self, out: *mut VisitStateChange) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT
}}
impl IGeovisit {
    #[inline] pub unsafe fn get_position(&self) -> Result<ComPtr<Geoposition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state_change(&self) -> Result<VisitStateChange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StateChange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class Geovisit: IGeovisit}
DEFINE_IID!(IID_IGeovisitMonitor, 2148633263, 22852, 17809, 131, 193, 57, 102, 71, 245, 79, 44);
RT_INTERFACE!{interface IGeovisitMonitor(IGeovisitMonitorVtbl): IInspectable(IInspectableVtbl) [IID_IGeovisitMonitor] {
    fn get_MonitoringScope(&self, out: *mut VisitMonitoringScope) -> HRESULT,
    fn Start(&self, value: VisitMonitoringScope) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn add_VisitStateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<GeovisitMonitor, GeovisitStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VisitStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGeovisitMonitor {
    #[inline] pub unsafe fn get_monitoring_scope(&self) -> Result<VisitMonitoringScope> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonitoringScope)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self, value: VisitMonitoringScope) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_visit_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<GeovisitMonitor, GeovisitStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VisitStateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_visit_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VisitStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GeovisitMonitor: IGeovisitMonitor}
impl RtActivatable<IGeovisitMonitorStatics> for GeovisitMonitor {}
impl RtActivatable<IActivationFactory> for GeovisitMonitor {}
impl GeovisitMonitor {
    #[inline] pub fn get_last_report_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<Geovisit>>> { unsafe {
        <Self as RtActivatable<IGeovisitMonitorStatics>>::get_activation_factory().get_last_report_async()
    }}
}
DEFINE_CLSID!(GeovisitMonitor(&[87,105,110,100,111,119,115,46,68,101,118,105,99,101,115,46,71,101,111,108,111,99,97,116,105,111,110,46,71,101,111,118,105,115,105,116,77,111,110,105,116,111,114,0]) [CLSID_GeovisitMonitor]);
DEFINE_IID!(IID_IGeovisitMonitorStatics, 3170465447, 48114, 19677, 149, 207, 85, 76, 130, 237, 251, 135);
RT_INTERFACE!{static interface IGeovisitMonitorStatics(IGeovisitMonitorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGeovisitMonitorStatics] {
    fn GetLastReportAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<Geovisit>) -> HRESULT
}}
impl IGeovisitMonitorStatics {
    #[inline] pub unsafe fn get_last_report_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<Geovisit>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetLastReportAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGeovisitStateChangedEventArgs, 3467956735, 35667, 18792, 190, 237, 76, 236, 208, 41, 206, 21);
RT_INTERFACE!{interface IGeovisitStateChangedEventArgs(IGeovisitStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGeovisitStateChangedEventArgs] {
    fn get_Visit(&self, out: *mut *mut Geovisit) -> HRESULT
}}
impl IGeovisitStateChangedEventArgs {
    #[inline] pub unsafe fn get_visit(&self) -> Result<ComPtr<Geovisit>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Visit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GeovisitStateChangedEventArgs: IGeovisitStateChangedEventArgs}
DEFINE_IID!(IID_IGeovisitTriggerDetails, 3933670814, 53705, 17739, 153, 183, 178, 248, 205, 210, 72, 47);
RT_INTERFACE!{interface IGeovisitTriggerDetails(IGeovisitTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IGeovisitTriggerDetails] {
    fn ReadReports(&self, out: *mut *mut super::super::foundation::collections::IVectorView<Geovisit>) -> HRESULT
}}
impl IGeovisitTriggerDetails {
    #[inline] pub unsafe fn read_reports(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<Geovisit>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadReports)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GeovisitTriggerDetails: IGeovisitTriggerDetails}
RT_ENUM! { enum PositionAccuracy: i32 {
    Default (PositionAccuracy_Default) = 0, High (PositionAccuracy_High) = 1,
}}
DEFINE_IID!(IID_IPositionChangedEventArgs, 931503333, 40222, 18117, 191, 59, 106, 216, 202, 193, 160, 147);
RT_INTERFACE!{interface IPositionChangedEventArgs(IPositionChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPositionChangedEventArgs] {
    fn get_Position(&self, out: *mut *mut Geoposition) -> HRESULT
}}
impl IPositionChangedEventArgs {
    #[inline] pub unsafe fn get_position(&self) -> Result<ComPtr<Geoposition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PositionChangedEventArgs: IPositionChangedEventArgs}
RT_ENUM! { enum PositionSource: i32 {
    Cellular (PositionSource_Cellular) = 0, Satellite (PositionSource_Satellite) = 1, WiFi (PositionSource_WiFi) = 2, IPAddress (PositionSource_IPAddress) = 3, Unknown (PositionSource_Unknown) = 4, Default (PositionSource_Default) = 5, Obfuscated (PositionSource_Obfuscated) = 6,
}}
RT_ENUM! { enum PositionStatus: i32 {
    Ready (PositionStatus_Ready) = 0, Initializing (PositionStatus_Initializing) = 1, NoData (PositionStatus_NoData) = 2, Disabled (PositionStatus_Disabled) = 3, NotInitialized (PositionStatus_NotInitialized) = 4, NotAvailable (PositionStatus_NotAvailable) = 5,
}}
DEFINE_IID!(IID_IStatusChangedEventArgs, 877908698, 35987, 16657, 162, 5, 154, 236, 252, 155, 229, 192);
RT_INTERFACE!{interface IStatusChangedEventArgs(IStatusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IStatusChangedEventArgs] {
    fn get_Status(&self, out: *mut PositionStatus) -> HRESULT
}}
impl IStatusChangedEventArgs {
    #[inline] pub unsafe fn get_status(&self) -> Result<PositionStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class StatusChangedEventArgs: IStatusChangedEven