use ::prelude::*;
DEFINE_IID!(IID_IAsyncAction, 1516535814, 33850, 19881, 134, 91, 157, 38, 229, 223, 173, 123);
RT_INTERFACE!{interface IAsyncAction(IAsyncActionVtbl): IInspectable(IInspectableVtbl) [IID_IAsyncAction] {
    fn put_Completed(&self, handler: *mut AsyncActionCompletedHandler) -> HRESULT,
    fn get_Completed(&self, out: *mut *mut AsyncActionCompletedHandler) -> HRESULT,
    fn GetResults(&self) -> HRESULT
}}
impl IAsyncAction {
    #[inline] pub unsafe fn set_completed(&self, handler: &AsyncActionCompletedHandler) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Completed)(self as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_completed(&self) -> Result<ComPtr<AsyncActionCompletedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Completed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_results(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).GetResults)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_AsyncActionCompletedHandler, 2767019137, 30409, 16573, 139, 230, 177, 217, 15, 178, 10, 231);
RT_DELEGATE!{delegate AsyncActionCompletedHandler(AsyncActionCompletedHandlerVtbl, AsyncActionCompletedHandlerImpl) [IID_AsyncActionCompletedHandler] {
    fn Invoke(&self, asyncInfo: *mut IAsyncAction, asyncStatus: AsyncStatus) -> HRESULT
}}
impl AsyncActionCompletedHandler {
    #[inline] pub unsafe fn invoke(&self, asyncInfo: &IAsyncAction, asyncStatus: AsyncStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, asyncInfo as *const _ as *mut _, asyncStatus);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_AsyncActionProgressHandler, 1837385816, 3327, 17808, 174, 137, 149, 165, 165, 200, 180, 184);
RT_DELEGATE!{delegate AsyncActionProgressHandler<TProgress>(AsyncActionProgressHandlerVtbl, AsyncActionProgressHandlerImpl) [IID_AsyncActionProgressHandler] {
    fn Invoke(&self, asyncInfo: *mut IAsyncActionWithProgress<TProgress>, progressInfo: TProgress::Abi) -> HRESULT
}}
impl<TProgress: RtType> AsyncActionProgressHandler<TProgress> {
    #[inline] pub unsafe fn invoke(&self, asyncInfo: &IAsyncActionWithProgress<TProgress>, progressInfo: &TProgress::In) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, asyncInfo as *const _ as *mut _, TProgress::unwrap(progressInfo));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAsyncActionWithProgress, 527282776, 59395, 18593, 149, 70, 235, 115, 83, 57, 136, 132);
RT_INTERFACE!{interface IAsyncActionWithProgress<TProgress>(IAsyncActionWithProgressVtbl): IInspectable(IInspectableVtbl) [IID_IAsyncActionWithProgress] {
    fn put_Progress(&self, handler: *mut AsyncActionProgressHandler<TProgress>) -> HRESULT,
    fn get_Progress(&self, out: *mut *mut AsyncActionProgressHandler<TProgress>) -> HRESULT,
    fn put_Completed(&self, handler: *mut AsyncActionWithProgressCompletedHandler<TProgress>) -> HRESULT,
    fn get_Completed(&self, out: *mut *mut AsyncActionWithProgressCompletedHandler<TProgress>) -> HRESULT,
    fn GetResults(&self) -> HRESULT
}}
impl<TProgress: RtType> IAsyncActionWithProgress<TProgress> {
    #[inline] pub unsafe fn set_progress(&self, handler: &AsyncActionProgressHandler<TProgress>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Progress)(self as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<ComPtr<AsyncActionProgressHandler<TProgress>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_completed(&self, handler: &AsyncActionWithProgressCompletedHandler<TProgress>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Completed)(self as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_completed(&self) -> Result<ComPtr<AsyncActionWithProgressCompletedHandler<TProgress>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Completed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_results(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).GetResults)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_AsyncActionWithProgressCompletedHandler, 2617417617, 52356, 17661, 172, 38, 10, 108, 78, 85, 82, 129);
RT_DELEGATE!{delegate AsyncActionWithProgressCompletedHandler<TProgress>(AsyncActionWithProgressCompletedHandlerVtbl, AsyncActionWithProgressCompletedHandlerImpl) [IID_AsyncActionWithProgressCompletedHandler] {
    fn Invoke(&self, asyncInfo: *mut IAsyncActionWithProgress<TProgress>, asyncStatus: AsyncStatus) -> HRESULT
}}
impl<TProgress: RtType> AsyncActionWithProgressCompletedHandler<TProgress> {
    #[inline] pub unsafe fn invoke(&self, asyncInfo: &IAsyncActionWithProgress<TProgress>, asyncStatus: AsyncStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, asyncInfo as *const _ as *mut _, asyncStatus);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAsyncInfo, 54, 0, 0, 192, 0, 0, 0, 0, 0, 0, 70);
RT_INTERFACE!{interface IAsyncInfo(IAsyncInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAsyncInfo] {
    fn get_Id(&self, out: *mut u32) -> HRESULT,
    fn get_Status(&self, out: *mut AsyncStatus) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut HResult) -> HRESULT,
    fn Cancel(&self) -> HRESULT,
    fn Close(&self) -> HRESULT
}}
impl IAsyncInfo {
    #[inline] pub unsafe fn get_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<AsyncStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn cancel(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Cancel)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn close(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Close)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAsyncOperation, 2680336571, 58438, 17634, 170, 97, 156, 171, 143, 99, 106, 242);
RT_INTERFACE!{interface IAsyncOperation<TResult>(IAsyncOperationVtbl): IInspectable(IInspectableVtbl) [IID_IAsyncOperation] {
    fn put_Completed(&self, handler: *mut AsyncOperationCompletedHandler<TResult>) -> HRESULT,
    fn get_Completed(&self, out: *mut *mut AsyncOperationCompletedHandler<TResult>) -> HRESULT,
    fn GetResults(&self, out: *mut TResult::Abi) -> HRESULT
}}
impl<TResult: RtType> IAsyncOperation<TResult> {
    #[inline] pub unsafe fn set_completed(&self, handler: &AsyncOperationCompletedHandler<TResult>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Completed)(self as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_completed(&self) -> Result<ComPtr<AsyncOperationCompletedHandler<TResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Completed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_results(&self) -> Result<TResult::Out> {
        let mut out = TResult::uninitialized();
        let hr = ((*self.lpVtbl).GetResults)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(TResult::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_AsyncOperationCompletedHandler, 4242337836, 58840, 17528, 145, 90, 77, 144, 183, 75, 131, 165);
RT_DELEGATE!{delegate AsyncOperationCompletedHandler<TResult>(AsyncOperationCompletedHandlerVtbl, AsyncOperationCompletedHandlerImpl) [IID_AsyncOperationCompletedHandler] {
    fn Invoke(&self, asyncInfo: *mut IAsyncOperation<TResult>, asyncStatus: AsyncStatus) -> HRESULT
}}
impl<TResult: RtType> AsyncOperationCompletedHandler<TResult> {
    #[inline] pub unsafe fn invoke(&self, asyncInfo: &IAsyncOperation<TResult>, asyncStatus: AsyncStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, asyncInfo as *const _ as *mut _, asyncStatus);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_AsyncOperationProgressHandler, 1432946946, 2731, 16922, 135, 120, 248, 206, 80, 38, 215, 88);
RT_DELEGATE!{delegate AsyncOperationProgressHandler<TResult, TProgress>(AsyncOperationProgressHandlerVtbl, AsyncOperationProgressHandlerImpl) [IID_AsyncOperationProgressHandler] {
    fn Invoke(&self, asyncInfo: *mut IAsyncOperationWithProgress<TResult, TProgress>, progressInfo: TProgress::Abi) -> HRESULT
}}
impl<TResult: RtType, TProgress: RtType> AsyncOperationProgressHandler<TResult, TProgress> {
    #[inline] pub unsafe fn invoke(&self, asyncInfo: &IAsyncOperationWithProgress<TResult, TProgress>, progressInfo: &TProgress::In) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, asyncInfo as *const _ as *mut _, TProgress::unwrap(progressInfo));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAsyncOperationWithProgress, 3050321623, 58007, 18831, 186, 96, 2, 137, 231, 110, 35, 221);
RT_INTERFACE!{interface IAsyncOperationWithProgress<TResult, TProgress>(IAsyncOperationWithProgressVtbl): IInspectable(IInspectableVtbl) [IID_IAsyncOperationWithProgress] {
    fn put_Progress(&self, handler: *mut AsyncOperationProgressHandler<TResult, TProgress>) -> HRESULT,
    fn get_Progress(&self, out: *mut *mut AsyncOperationProgressHandler<TResult, TProgress>) -> HRESULT,
    fn put_Completed(&self, handler: *mut AsyncOperationWithProgressCompletedHandler<TResult, TProgress>) -> HRESULT,
    fn get_Completed(&self, out: *mut *mut AsyncOperationWithProgressCompletedHandler<TResult, TProgress>) -> HRESULT,
    fn GetResults(&self, out: *mut TResult::Abi) -> HRESULT
}}
impl<TResult: RtType, TProgress: RtType> IAsyncOperationWithProgress<TResult, TProgress> {
    #[inline] pub unsafe fn set_progress(&self, handler: &AsyncOperationProgressHandler<TResult, TProgress>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Progress)(self as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_progress(&self) -> Result<ComPtr<AsyncOperationProgressHandler<TResult, TProgress>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Progress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_completed(&self, handler: &AsyncOperationWithProgressCompletedHandler<TResult, TProgress>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Completed)(self as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_completed(&self) -> Result<ComPtr<AsyncOperationWithProgressCompletedHandler<TResult, TProgress>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Completed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_results(&self) -> Result<TResult::Out> {
        let mut out = TResult::uninitialized();
        let hr = ((*self.lpVtbl).GetResults)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(TResult::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_AsyncOperationWithProgressCompletedHandler, 3898471453, 27303, 18147, 168, 226, 240, 9, 216, 64, 198, 39);
RT_DELEGATE!{delegate AsyncOperationWithProgressCompletedHandler<TResult, TProgress>(AsyncOperationWithProgressCompletedHandlerVtbl, AsyncOperationWithProgressCompletedHandlerImpl) [IID_AsyncOperationWithProgressCompletedHandler] {
    fn Invoke(&self, asyncInfo: *mut IAsyncOperationWithProgress<TResult, TProgress>, asyncStatus: AsyncStatus) -> HRESULT
}}
impl<TResult: RtType, TProgress: RtType> AsyncOperationWithProgressCompletedHandler<TResult, TProgress> {
    #[inline] pub unsafe fn invoke(&self, asyncInfo: &IAsyncOperationWithProgress<TResult, TProgress>, asyncStatus: AsyncStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, asyncInfo as *const _ as *mut _, asyncStatus);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AsyncStatus: i32 {
    Canceled (AsyncStatus_Canceled) = 2, Completed (AsyncStatus_Completed) = 1, Error (AsyncStatus_Error) = 3, Started (AsyncStatus_Started) = 0,
}}
DEFINE_IID!(IID_IClosable, 819308585, 32676, 16422, 131, 187, 215, 91, 174, 78, 169, 158);
RT_INTERFACE!{interface IClosable(IClosableVtbl): IInspectable(IInspectableVtbl) [IID_IClosable] {
    fn Close(&self) -> HRESULT
}}
impl IClosable {
    #[inline] pub unsafe fn close(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Close)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_STRUCT! { struct DateTime {
    UniversalTime: i64,
}}
DEFINE_IID!(IID_IDeferral, 3592853298, 15231, 18087, 180, 11, 79, 220, 162, 162, 198, 147);
RT_INTERFACE!{interface IDeferral(IDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Deferral: IDeferral}
impl RtActivatable<IDeferralFactory> for Deferral {}
impl Deferral {
    #[inline] pub fn create(handler: &DeferralCompletedHandler) -> Result<ComPtr<Deferral>> { unsafe {
        <Self as RtActivatable<IDeferralFactory>>::get_activation_factory().create(handler)
    }}
}
DEFINE_CLSID!(Deferral(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,68,101,102,101,114,114,97,108,0]) [CLSID_Deferral]);
DEFINE_IID!(IID_DeferralCompletedHandler, 3979518834, 62408, 20394, 156, 251, 71, 1, 72, 218, 56, 136);
RT_DELEGATE!{delegate DeferralCompletedHandler(DeferralCompletedHandlerVtbl, DeferralCompletedHandlerImpl) [IID_DeferralCompletedHandler] {
    fn Invoke(&self) -> HRESULT
}}
impl DeferralCompletedHandler {
    #[inline] pub unsafe fn invoke(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDeferralFactory, 1705110725, 16309, 18482, 140, 169, 240, 97, 178, 129, 209, 58);
RT_INTERFACE!{static interface IDeferralFactory(IDeferralFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDeferralFactory] {
    fn Create(&self, handler: *mut DeferralCompletedHandler, out: *mut *mut Deferral) -> HRESULT
}}
impl IDeferralFactory {
    #[inline] pub unsafe fn create(&self, handler: &DeferralCompletedHandler) -> Result<ComPtr<Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_EventHandler, 2648818997, 27361, 4576, 132, 225, 24, 169, 5, 188, 197, 63);
RT_DELEGATE!{delegate EventHandler<T>(EventHandlerVtbl, EventHandlerImpl) [IID_EventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, args: T::Abi) -> HRESULT
}}
impl<T: RtType> EventHandler<T> {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, args: &T::In) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, T::unwrap(args));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_STRUCT! { struct EventRegistrationToken {
    Value: i64,
}}
DEFINE_IID!(IID_IGetActivationFactory, 1323011810, 38621, 18855, 148, 247, 70, 7, 221, 171, 142, 60);
RT_INTERFACE!{interface IGetActivationFactory(IGetActivationFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGetActivationFactory] {
    fn GetActivationFactory(&self, activatableClassId: HSTRING, out: *mut *mut IInspectable) -> HRESULT
}}
impl IGetActivationFactory {
    #[inline] pub unsafe fn get_activation_factory(&self, activatableClassId: &HStringArg) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetActivationFactory)(self as *const _ as *mut _, activatableClassId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_STRUCT! { struct HResult {
    Value: i32,
}}
DEFINE_IID!(IID_IMemoryBuffer, 4223982890, 9307, 4580, 175, 152, 104, 148, 35, 38, 12, 248);
RT_INTERFACE!{interface IMemoryBuffer(IMemoryBufferVtbl): IInspectable(IInspectableVtbl) [IID_IMemoryBuffer] {
    fn CreateReference(&self, out: *mut *mut IMemoryBufferReference) -> HRESULT
}}
impl IMemoryBuffer {
    #[inline] pub unsafe fn create_reference(&self) -> Result<ComPtr<IMemoryBufferReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateReference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MemoryBuffer: IMemoryBuffer}
impl RtActivatable<IMemoryBufferFactory> for MemoryBuffer {}
impl MemoryBuffer {
    #[inline] pub fn create(capacity: u32) -> Result<ComPtr<MemoryBuffer>> { unsafe {
        <Self as RtActivatable<IMemoryBufferFactory>>::get_activation_factory().create(capacity)
    }}
}
DEFINE_CLSID!(MemoryBuffer(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,77,101,109,111,114,121,66,117,102,102,101,114,0]) [CLSID_MemoryBuffer]);
DEFINE_IID!(IID_IMemoryBufferFactory, 4223982891, 9307, 4580, 175, 152, 104, 148, 35, 38, 12, 248);
RT_INTERFACE!{static interface IMemoryBufferFactory(IMemoryBufferFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IMemoryBufferFactory] {
    fn Create(&self, capacity: u32, out: *mut *mut MemoryBuffer) -> HRESULT
}}
impl IMemoryBufferFactory {
    #[inline] pub unsafe fn create(&self, capacity: u32) -> Result<ComPtr<MemoryBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, capacity, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMemoryBufferReference, 4223982889, 9307, 4580, 175, 152, 104, 148, 35, 38, 12, 248);
RT_INTERFACE!{interface IMemoryBufferReference(IMemoryBufferReferenceVtbl): IInspectable(IInspectableVtbl) [IID_IMemoryBufferReference] {
    fn get_Capacity(&self, out: *mut u32) -> HRESULT,
    fn add_Closed(&self, handler: *mut TypedEventHandler<IMemoryBufferReference, IInspectable>, out: *mut EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, cookie: EventRegistrationToken) -> HRESULT
}}
impl IMemoryBufferReference {
    #[inline] pub unsafe fn get_capacity(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Capacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, handler: &TypedEventHandler<IMemoryBufferReference, IInspectable>) -> Result<EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, cookie: EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_STRUCT! { struct Point {
    X: f32, Y: f32,
}}
RT_ENUM! { enum PropertyType: i32 {
    Empty (PropertyType_Empty) = 0, UInt8 (PropertyType_UInt8) = 1, Int16 (PropertyType_Int16) = 2, UInt16 (PropertyType_UInt16) = 3, Int32 (PropertyType_Int32) = 4, UInt32 (PropertyType_UInt32) = 5, Int64 (PropertyType_Int64) = 6, UInt64 (PropertyType_UInt64) = 7, Single (PropertyType_Single) = 8, Double (PropertyType_Double) = 9, Char16 (PropertyType_Char16) = 10, Boolean (PropertyType_Boolean) = 11, String (PropertyType_String) = 12, Inspectable (PropertyType_Inspectable) = 13, DateTime (PropertyType_DateTime) = 14, TimeSpan (PropertyType_TimeSpan) = 15, Guid (PropertyType_Guid) = 16, Point (PropertyType_Point) = 17, Size (PropertyType_Size) = 18, Rect (PropertyType_Rect) = 19, OtherType (PropertyType_OtherType) = 20, UInt8Array (PropertyType_UInt8Array) = 1025, Int16Array (PropertyType_Int16Array) = 1026, UInt16Array (PropertyType_UInt16Array) = 1027, Int32Array (PropertyType_Int32Array) = 1028, UInt32Array (PropertyType_UInt32Array) = 1029, Int64Array (PropertyType_Int64Array) = 1030, UInt64Array (PropertyType_UInt64Array) = 1031, SingleArray (PropertyType_SingleArray) = 1032, DoubleArray (PropertyType_DoubleArray) = 1033, Char16Array (PropertyType_Char16Array) = 1034, BooleanArray (PropertyType_BooleanArray) = 1035, StringArray (PropertyType_StringArray) = 1036, InspectableArray (PropertyType_InspectableArray) = 1037, DateTimeArray (PropertyType_DateTimeArray) = 1038, TimeSpanArray (PropertyType_TimeSpanArray) = 1039, GuidArray (PropertyType_GuidArray) = 1040, PointArray (PropertyType_PointArray) = 1041, SizeArray (PropertyType_SizeArray) = 1042, RectArray (PropertyType_RectArray) = 1043, OtherTypeArray (PropertyType_OtherTypeArray) = 1044,
}}
DEFINE_IID!(IID_IPropertyValue, 1272349405, 30036, 16617, 154, 155, 130, 101, 78, 222, 126, 98);
RT_INTERFACE!{interface IPropertyValue(IPropertyValueVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyValue] {
    fn get_Type(&self, out: *mut PropertyType) -> HRESULT,
    fn get_IsNumericScalar(&self, out: *mut bool) -> HRESULT,
    fn GetUInt8(&self, out: *mut u8) -> HRESULT,
    fn GetInt16(&self, out: *mut i16) -> HRESULT,
    fn GetUInt16(&self, out: *mut u16) -> HRESULT,
    fn GetInt32(&self, out: *mut i32) -> HRESULT,
    fn GetUInt32(&self, out: *mut u32) -> HRESULT,
    fn GetInt64(&self, out: *mut i64) -> HRESULT,
    fn GetUInt64(&self, out: *mut u64) -> HRESULT,
    fn GetSingle(&self, out: *mut f32) -> HRESULT,
    fn GetDouble(&self, out: *mut f64) -> HRESULT,
    fn GetChar16(&self, out: *mut Char) -> HRESULT,
    fn GetBoolean(&self, out: *mut bool) -> HRESULT,
    fn GetString(&self, out: *mut HSTRING) -> HRESULT,
    fn GetGuid(&self, out: *mut Guid) -> HRESULT,
    fn GetDateTime(&self, out: *mut DateTime) -> HRESULT,
    fn GetTimeSpan(&self, out: *mut TimeSpan) -> HRESULT,
    fn GetPoint(&self, out: *mut Point) -> HRESULT,
    fn GetSize(&self, out: *mut Size) -> HRESULT,
    fn GetRect(&self, out: *mut Rect) -> HRESULT,
    fn GetUInt8Array(&self, valueSize: *mut u32, value: *mut *mut u8) -> HRESULT,
    fn GetInt16Array(&self, valueSize: *mut u32, value: *mut *mut i16) -> HRESULT,
    fn GetUInt16Array(&self, valueSize: *mut u32, value: *mut *mut u16) -> HRESULT,
    fn GetInt32Array(&self, valueSize: *mut u32, value: *mut *mut i32) -> HRESULT,
    fn GetUInt32Array(&self, valueSize: *mut u32, value: *mut *mut u32) -> HRESULT,
    fn GetInt64Array(&self, valueSize: *mut u32, value: *mut *mut i64) -> HRESULT,
    fn GetUInt64Array(&self, valueSize: *mut u32, value: *mut *mut u64) -> HRESULT,
    fn GetSingleArray(&self, valueSize: *mut u32, value: *mut *mut f32) -> HRESULT,
    fn GetDoubleArray(&self, valueSize: *mut u32, value: *mut *mut f64) -> HRESULT,
    fn GetChar16Array(&self, valueSize: *mut u32, value: *mut *mut Char) -> HRESULT,
    fn GetBooleanArray(&self, valueSize: *mut u32, value: *mut *mut bool) -> HRESULT,
    fn GetStringArray(&self, valueSize: *mut u32, value: *mut *mut HSTRING) -> HRESULT,
    fn GetInspectableArray(&self, valueSize: *mut u32, value: *mut *mut *mut IInspectable) -> HRESULT,
    fn GetGuidArray(&self, valueSize: *mut u32, value: *mut *mut Guid) -> HRESULT,
    fn GetDateTimeArray(&self, valueSize: *mut u32, value: *mut *mut DateTime) -> HRESULT,
    fn GetTimeSpanArray(&self, valueSize: *mut u32, value: *mut *mut TimeSpan) -> HRESULT,
    fn GetPointArray(&self, valueSize: *mut u32, value: *mut *mut Point) -> HRESULT,
    fn GetSizeArray(&self, valueSize: *mut u32, value: *mut *mut Size) -> HRESULT,
    fn GetRectArray(&self, valueSize: *mut u32, value: *mut *mut Rect) -> HRESULT
}}
impl IPropertyValue {
    #[inline] pub unsafe fn get_type(&self) -> Result<PropertyType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_numeric_scalar(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsNumericScalar)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint8(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetUInt8)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_int16(&self) -> Result<i16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetInt16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint16(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetUInt16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_int32(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetInt32)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint32(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetUInt32)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_int64(&self) -> Result<i64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetInt64)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint64(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetUInt64)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_single(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetSingle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_double(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetDouble)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_char16(&self) -> Result<Char> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetChar16)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_boolean(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetBoolean)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_string(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_guid(&self) -> Result<Guid> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetGuid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_time(&self) -> Result<DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetDateTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_span(&self) -> Result<TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetTimeSpan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_point(&self) -> Result<Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rect(&self) -> Result<Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint8_array(&self) -> Result<ComArray<u8>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetUInt8Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_int16_array(&self) -> Result<ComArray<i16>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetInt16Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint16_array(&self) -> Result<ComArray<u16>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetUInt16Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_int32_array(&self) -> Result<ComArray<i32>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetInt32Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint32_array(&self) -> Result<ComArray<u32>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetUInt32Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_int64_array(&self) -> Result<ComArray<i64>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetInt64Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uint64_array(&self) -> Result<ComArray<u64>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetUInt64Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_single_array(&self) -> Result<ComArray<f32>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetSingleArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_double_array(&self) -> Result<ComArray<f64>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetDoubleArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_char16_array(&self) -> Result<ComArray<Char>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetChar16Array)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_boolean_array(&self) -> Result<ComArray<bool>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetBooleanArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_string_array(&self) -> Result<ComArray<HString>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetStringArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inspectable_array(&self) -> Result<ComArray<IInspectable>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetInspectableArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_guid_array(&self) -> Result<ComArray<Guid>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetGuidArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_time_array(&self) -> Result<ComArray<DateTime>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetDateTimeArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_span_array(&self) -> Result<ComArray<TimeSpan>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetTimeSpanArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_point_array(&self) -> Result<ComArray<Point>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetPointArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size_array(&self) -> Result<ComArray<Size>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetSizeArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rect_array(&self) -> Result<ComArray<Rect>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetRectArray)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
}
RT_CLASS!{static class PropertyValue}
impl RtActivatable<IPropertyValueStatics> for PropertyValue {}
impl PropertyValue {
    #[inline] pub fn create_empty() -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_empty()
    }}
    #[inline] pub fn create_uint8(value: u8) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint8(value)
    }}
    #[inline] pub fn create_int16(value: i16) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_int16(value)
    }}
    #[inline] pub fn create_uint16(value: u16) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint16(value)
    }}
    #[inline] pub fn create_int32(value: i32) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_int32(value)
    }}
    #[inline] pub fn create_uint32(value: u32) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint32(value)
    }}
    #[inline] pub fn create_int64(value: i64) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_int64(value)
    }}
    #[inline] pub fn create_uint64(value: u64) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint64(value)
    }}
    #[inline] pub fn create_single(value: f32) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_single(value)
    }}
    #[inline] pub fn create_double(value: f64) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_double(value)
    }}
    #[inline] pub fn create_char16(value: Char) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_char16(value)
    }}
    #[inline] pub fn create_boolean(value: bool) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_boolean(value)
    }}
    #[inline] pub fn create_string(value: &HStringArg) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_string(value)
    }}
    #[inline] pub fn create_inspectable(value: &IInspectable) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_inspectable(value)
    }}
    #[inline] pub fn create_guid(value: Guid) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_guid(value)
    }}
    #[inline] pub fn create_date_time(value: DateTime) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_date_time(value)
    }}
    #[inline] pub fn create_time_span(value: TimeSpan) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_time_span(value)
    }}
    #[inline] pub fn create_point(value: Point) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_point(value)
    }}
    #[inline] pub fn create_size(value: Size) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_size(value)
    }}
    #[inline] pub fn create_rect(value: Rect) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_rect(value)
    }}
    #[inline] pub fn create_uint8_array(value: &[u8]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint8_array(value)
    }}
    #[inline] pub fn create_int16_array(value: &[i16]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_int16_array(value)
    }}
    #[inline] pub fn create_uint16_array(value: &[u16]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint16_array(value)
    }}
    #[inline] pub fn create_int32_array(value: &[i32]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_int32_array(value)
    }}
    #[inline] pub fn create_uint32_array(value: &[u32]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint32_array(value)
    }}
    #[inline] pub fn create_int64_array(value: &[i64]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_int64_array(value)
    }}
    #[inline] pub fn create_uint64_array(value: &[u64]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_uint64_array(value)
    }}
    #[inline] pub fn create_single_array(value: &[f32]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_single_array(value)
    }}
    #[inline] pub fn create_double_array(value: &[f64]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_double_array(value)
    }}
    #[inline] pub fn create_char16_array(value: &[Char]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_char16_array(value)
    }}
    #[inline] pub fn create_boolean_array(value: &[bool]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_boolean_array(value)
    }}
    #[inline] pub fn create_string_array(value: &[&HStringArg]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_string_array(value)
    }}
    #[inline] pub fn create_inspectable_array(value: &[&IInspectable]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_inspectable_array(value)
    }}
    #[inline] pub fn create_guid_array(value: &[Guid]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_guid_array(value)
    }}
    #[inline] pub fn create_date_time_array(value: &[DateTime]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_date_time_array(value)
    }}
    #[inline] pub fn create_time_span_array(value: &[TimeSpan]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_time_span_array(value)
    }}
    #[inline] pub fn create_point_array(value: &[Point]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_point_array(value)
    }}
    #[inline] pub fn create_size_array(value: &[Size]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_size_array(value)
    }}
    #[inline] pub fn create_rect_array(value: &[Rect]) -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IPropertyValueStatics>>::get_activation_factory().create_rect_array(value)
    }}
}
DEFINE_CLSID!(PropertyValue(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,80,114,111,112,101,114,116,121,86,97,108,117,101,0]) [CLSID_PropertyValue]);
DEFINE_IID!(IID_IPropertyValueStatics, 1654381512, 55602, 20468, 150, 185, 141, 150, 197, 193, 232, 88);
RT_INTERFACE!{static interface IPropertyValueStatics(IPropertyValueStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyValueStatics] {
    fn CreateEmpty(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt8(&self, value: u8, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInt16(&self, value: i16, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt16(&self, value: u16, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInt32(&self, value: i32, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt32(&self, value: u32, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInt64(&self, value: i64, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt64(&self, value: u64, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateSingle(&self, value: f32, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateDouble(&self, value: f64, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateChar16(&self, value: Char, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateBoolean(&self, value: bool, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateString(&self, value: HSTRING, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInspectable(&self, value: *mut IInspectable, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateGuid(&self, value: Guid, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateDateTime(&self, value: DateTime, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateTimeSpan(&self, value: TimeSpan, out: *mut *mut IInspectable) -> HRESULT,
    fn CreatePoint(&self, value: Point, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateSize(&self, value: Size, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateRect(&self, value: Rect, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt8Array(&self, valueSize: u32, value: *mut u8, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInt16Array(&self, valueSize: u32, value: *mut i16, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt16Array(&self, valueSize: u32, value: *mut u16, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInt32Array(&self, valueSize: u32, value: *mut i32, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt32Array(&self, valueSize: u32, value: *mut u32, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInt64Array(&self, valueSize: u32, value: *mut i64, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateUInt64Array(&self, valueSize: u32, value: *mut u64, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateSingleArray(&self, valueSize: u32, value: *mut f32, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateDoubleArray(&self, valueSize: u32, value: *mut f64, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateChar16Array(&self, valueSize: u32, value: *mut Char, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateBooleanArray(&self, valueSize: u32, value: *mut bool, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateStringArray(&self, valueSize: u32, value: *mut HSTRING, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateInspectableArray(&self, valueSize: u32, value: *mut *mut IInspectable, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateGuidArray(&self, valueSize: u32, value: *mut Guid, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateDateTimeArray(&self, valueSize: u32, value: *mut DateTime, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateTimeSpanArray(&self, valueSize: u32, value: *mut TimeSpan, out: *mut *mut IInspectable) -> HRESULT,
    fn CreatePointArray(&self, valueSize: u32, value: *mut Point, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateSizeArray(&self, valueSize: u32, value: *mut Size, out: *mut *mut IInspectable) -> HRESULT,
    fn CreateRectArray(&self, valueSize: u32, value: *mut Rect, out: *mut *mut IInspectable) -> HRESULT
}}
impl IPropertyValueStatics {
    #[inline] pub unsafe fn create_empty(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateEmpty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint8(&self, value: u8) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt8)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_int16(&self, value: i16) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInt16)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint16(&self, value: u16) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt16)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_int32(&self, value: i32) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInt32)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint32(&self, value: u32) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt32)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_int64(&self, value: i64) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInt64)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint64(&self, value: u64) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt64)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_single(&self, value: f32) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSingle)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_double(&self, value: f64) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDouble)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_char16(&self, value: Char) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateChar16)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_boolean(&self, value: bool) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBoolean)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_string(&self, value: &HStringArg) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateString)(self as *const _ as *mut _, value.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_inspectable(&self, value: &IInspectable) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInspectable)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_guid(&self, value: Guid) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateGuid)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_date_time(&self, value: DateTime) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDateTime)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_time_span(&self, value: TimeSpan) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateTimeSpan)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_point(&self, value: Point) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreatePoint)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_size(&self, value: Size) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSize)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_rect(&self, value: Rect) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateRect)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint8_array(&self, value: &[u8]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt8Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_int16_array(&self, value: &[i16]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInt16Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint16_array(&self, value: &[u16]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt16Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_int32_array(&self, value: &[i32]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInt32Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint32_array(&self, value: &[u32]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt32Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_int64_array(&self, value: &[i64]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInt64Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_uint64_array(&self, value: &[u64]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUInt64Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_single_array(&self, value: &[f32]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSingleArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_double_array(&self, value: &[f64]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDoubleArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_char16_array(&self, value: &[Char]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateChar16Array)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_boolean_array(&self, value: &[bool]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBooleanArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_string_array(&self, value: &[&HStringArg]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateStringArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_inspectable_array(&self, value: &[&IInspectable]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInspectableArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_guid_array(&self, value: &[Guid]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateGuidArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_date_time_array(&self, value: &[DateTime]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDateTimeArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_time_span_array(&self, value: &[TimeSpan]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateTimeSpanArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_point_array(&self, value: &[Point]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreatePointArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_size_array(&self, value: &[Size]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSizeArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_rect_array(&self, value: &[Rect]) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateRectArray)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_STRUCT! { struct Rect {
    X: f32, Y: f32, Width: f32, Height: f32,
}}
DEFINE_IID!(IID_IReference, 1640068870, 11621, 4576, 154, 232, 212, 133, 100, 1, 84, 114);
RT_INTERFACE!{interface IReference<T>(IReferenceVtbl): IInspectable(IInspectableVtbl) [IID_IReference] {
    fn get_Value(&self, out: *mut T::Abi) -> HRESULT
}}
impl<T: RtType> IReference<T> {
    #[inline] pub unsafe fn get_value(&self) -> Result<T::Out> {
        let mut out = T::uninitialized();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(T::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IReferenceArray, 1640068871, 11621, 4576, 154, 232, 212, 133, 100, 1, 84, 114);
RT_INTERFACE!{interface IReferenceArray<T>(IReferenceArrayVtbl): IInspectable(IInspectableVtbl) [IID_IReferenceArray] {
    fn get_Value(&self, outSize: *mut u32, out: *mut *mut T::Abi) -> HRESULT
}}
impl<T: RtType> IReferenceArray<T> {
    #[inline] pub unsafe fn get_value(&self) -> Result<ComArray<T>> {
        let mut outSize = 0; let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut outSize, &mut out);
        if hr == S_OK { Ok(ComArray::from_raw(outSize, out)) } else { err(hr) }
    }
}
RT_STRUCT! { struct Size {
    Width: f32, Height: f32,
}}
DEFINE_IID!(IID_IStringable, 2520162132, 36534, 18672, 171, 206, 193, 178, 17, 230, 39, 195);
RT_INTERFACE!{interface IStringable(IStringableVtbl): IInspectable(IInspectableVtbl) [IID_IStringable] {
    fn ToString(&self, out: *mut HSTRING) -> HRESULT
}}
impl IStringable {
    #[inline] pub unsafe fn to_string(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ToString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_STRUCT! { struct TimeSpan {
    Duration: i64,
}}
DEFINE_IID!(IID_TypedEventHandler, 2648818996, 27361, 4576, 132, 225, 24, 169, 5, 188, 197, 63);
RT_DELEGATE!{delegate TypedEventHandler<TSender, TResult>(TypedEventHandlerVtbl, TypedEventHandlerImpl) [IID_TypedEventHandler] {
    fn Invoke(&self, sender: TSender::Abi, args: TResult::Abi) -> HRESULT
}}
impl<TSender: RtType, TResult: RtType> TypedEventHandler<TSender, TResult> {
    #[inline] pub unsafe fn invoke(&self, sender: &TSender::In, args: &TResult::In) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, TSender::unwrap(sender), TResult::unwrap(args));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Uri: IUriRuntimeClass}
impl RtActivatable<IUriRuntimeClassFactory> for Uri {}
impl RtActivatable<IUriEscapeStatics> for Uri {}
impl Uri {
    #[inline] pub fn create_uri(uri: &HStringArg) -> Result<ComPtr<Uri>> { unsafe {
        <Self as RtActivatable<IUriRuntimeClassFactory>>::get_activation_factory().create_uri(uri)
    }}
    #[inline] pub fn create_with_relative_uri(baseUri: &HStringArg, relativeUri: &HStringArg) -> Result<ComPtr<Uri>> { unsafe {
        <Self as RtActivatable<IUriRuntimeClassFactory>>::get_activation_factory().create_with_relative_uri(baseUri, relativeUri)
    }}
    #[inline] pub fn unescape_component(toUnescape: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<IUriEscapeStatics>>::get_activation_factory().unescape_component(toUnescape)
    }}
    #[inline] pub fn escape_component(toEscape: &HStringArg) -> Result<HString> { unsafe {
        <Self as RtActivatable<IUriEscapeStatics>>::get_activation_factory().escape_component(toEscape)
    }}
}
DEFINE_CLSID!(Uri(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,85,114,105,0]) [CLSID_Uri]);
DEFINE_IID!(IID_IUriEscapeStatics, 3251909306, 51236, 17490, 167, 253, 81, 43, 195, 187, 233, 161);
RT_INTERFACE!{static interface IUriEscapeStatics(IUriEscapeStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IUriEscapeStatics] {
    fn UnescapeComponent(&self, toUnescape: HSTRING, out: *mut HSTRING) -> HRESULT,
    fn EscapeComponent(&self, toEscape: HSTRING, out: *mut HSTRING) -> HRESULT
}}
impl IUriEscapeStatics {
    #[inline] pub unsafe fn unescape_component(&self, toUnescape: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UnescapeComponent)(self as *const _ as *mut _, toUnescape.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn escape_component(&self, toEscape: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).EscapeComponent)(self as *const _ as *mut _, toEscape.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUriRuntimeClass, 2654363223, 18610, 16736, 149, 111, 199, 56, 81, 32, 187, 252);
RT_INTERFACE!{interface IUriRuntimeClass(IUriRuntimeClassVtbl): IInspectable(IInspectableVtbl) [IID_IUriRuntimeClass] {
    fn get_AbsoluteUri(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayUri(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Domain(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Extension(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Fragment(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Host(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Password(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Path(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Query(&self, out: *mut HSTRING) -> HRESULT,
    fn get_QueryParsed(&self, out: *mut *mut WwwFormUrlDecoder) -> HRESULT,
    fn get_RawUri(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SchemeName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_UserName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Port(&self, out: *mut i32) -> HRESULT,
    fn get_Suspicious(&self, out: *mut bool) -> HRESULT,
    fn Equals(&self, pUri: *mut Uri, out: *mut bool) -> HRESULT,
    fn CombineUri(&self, relativeUri: HSTRING, out: *mut *mut Uri) -> HRESULT
}}
impl IUriRuntimeClass {
    #[inline] pub unsafe fn get_absolute_uri(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AbsoluteUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_uri(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_domain(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Domain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extension(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Extension)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_fragment(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Fragment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_host(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Host)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_password(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Password)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_path(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Path)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Query)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_query_parsed(&self) -> Result<ComPtr<WwwFormUrlDecoder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryParsed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_raw_uri(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RawUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scheme_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SchemeName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_port(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Port)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_suspicious(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Suspicious)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn equals(&self, pUri: &Uri) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Equals)(self as *const _ as *mut _, pUri as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn combine_uri(&self, relativeUri: &HStringArg) -> Result<ComPtr<Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CombineUri)(self as *const _ as *mut _, relativeUri.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUriRuntimeClassFactory, 1151957359, 29246, 20447, 162, 24, 3, 62, 117, 176, 192, 132);
RT_INTERFACE!{static interface IUriRuntimeClassFactory(IUriRuntimeClassFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IUriRuntimeClassFactory] {
    fn CreateUri(&self, uri: HSTRING, out: *mut *mut Uri) -> HRESULT,
    fn CreateWithRelativeUri(&self, baseUri: HSTRING, relativeUri: HSTRING, out: *mut *mut Uri) -> HRESULT
}}
impl IUriRuntimeClassFactory {
    #[inline] pub unsafe fn create_uri(&self, uri: &HStringArg) -> Result<ComPtr<Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateUri)(self as *const _ as *mut _, uri.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_relative_uri(&self, baseUri: &HStringArg, relativeUri: &HStringArg) -> Result<ComPtr<Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithRelativeUri)(self as *const _ as *mut _, baseUri.get(), relativeUri.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUriRuntimeClassWithAbsoluteCanonicalUri, 1972213345, 8732, 18447, 163, 57, 80, 101, 102, 115, 244, 111);
RT_INTERFACE!{interface IUriRuntimeClassWithAbsoluteCanonicalUri(IUriRuntimeClassWithAbsoluteCanonicalUriVtbl): IInspectable(IInspectableVtbl) [IID_IUriRuntimeClassWithAbsoluteCanonicalUri] {
    fn get_AbsoluteCanonicalUri(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayIri(&self, out: *mut HSTRING) -> HRESULT
}}
impl IUriRuntimeClassWithAbsoluteCanonicalUri {
    #[inline] pub unsafe fn get_absolute_canonical_uri(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AbsoluteCanonicalUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_iri(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayIri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WwwFormUrlDecoder: IWwwFormUrlDecoderRuntimeClass}
impl RtActivatable<IWwwFormUrlDecoderRuntimeClassFactory> for WwwFormUrlDecoder {}
impl WwwFormUrlDecoder {
    #[inline] pub fn create_www_form_url_decoder(query: &HStringArg) -> Result<ComPtr<WwwFormUrlDecoder>> { unsafe {
        <Self as RtActivatable<IWwwFormUrlDecoderRuntimeClassFactory>>::get_activation_factory().create_www_form_url_decoder(query)
    }}
}
DEFINE_CLSID!(WwwFormUrlDecoder(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,87,119,119,70,111,114,109,85,114,108,68,101,99,111,100,101,114,0]) [CLSID_WwwFormUrlDecoder]);
DEFINE_IID!(IID_IWwwFormUrlDecoderEntry, 308180017, 63096, 20110, 182, 112, 32, 169, 176, 108, 81, 45);
RT_INTERFACE!{interface IWwwFormUrlDecoderEntry(IWwwFormUrlDecoderEntryVtbl): IInspectable(IInspectableVtbl) [IID_IWwwFormUrlDecoderEntry] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Value(&self, out: *mut HSTRING) -> HRESULT
}}
impl IWwwFormUrlDecoderEntry {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WwwFormUrlDecoderEntry: IWwwFormUrlDecoderEntry}
DEFINE_IID!(IID_IWwwFormUrlDecoderRuntimeClass, 3562669137, 61989, 17730, 146, 150, 14, 29, 245, 210, 84, 223);
RT_INTERFACE!{interface IWwwFormUrlDecoderRuntimeClass(IWwwFormUrlDecoderRuntimeClassVtbl): IInspectable(IInspectableVtbl) [IID_IWwwFormUrlDecoderRuntimeClass] {
    fn GetFirstValueByName(&self, name: HSTRING, out: *mut HSTRING) -> HRESULT
}}
impl IWwwFormUrlDecoderRuntimeClass {
    #[inline] pub unsafe fn get_first_value_by_name(&self, name: &HStringArg) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetFirstValueByName)(self as *const _ as *mut _, name.get(), &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWwwFormUrlDecoderRuntimeClassFactory, 1535929149, 9390, 16821, 161, 191, 240, 195, 213, 68, 132, 91);
RT_INTERFACE!{static interface IWwwFormUrlDecoderRuntimeClassFactory(IWwwFormUrlDecoderRuntimeClassFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IWwwFormUrlDecoderRuntimeClassFactory] {
    fn CreateWwwFormUrlDecoder(&self, query: HSTRING, out: *mut *mut WwwFormUrlDecoder) -> HRESULT
}}
impl IWwwFormUrlDecoderRuntimeClassFactory {
    #[inline] pub unsafe fn create_www_form_url_decoder(&self, query: &HStringArg) -> Result<ComPtr<WwwFormUrlDecoder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWwwFormUrlDecoder)(self as *const _ as *mut _, query.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_PINTERFACE!{ for AsyncActionProgressHandler<f64> => [0x44825c7c,0x0da9,0x5691,0xb2,0xb4,0x91,0x4f,0x23,0x1e,0xec,0xed] as IID_AsyncActionProgressHandler_1_System_Double }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncActionProgressHandler<super::web::syndication::TransferProgress> => [0xc1610085,0x94d0,0x5706,0x9a,0xc6,0x10,0x17,0x9d,0x7d,0xeb,0x92] as IID_AsyncActionProgressHandler_1_Windows_Web_Syndication_TransferProgress }
RT_PINTERFACE!{ for AsyncActionProgressHandler<u64> => [0x55e233ca,0xf243,0x5ae2,0x85,0x3b,0xf9,0xcc,0x7c,0x0a,0xe0,0xcf] as IID_AsyncActionProgressHandler_1_System_UInt64 }
RT_PINTERFACE!{ for AsyncActionWithProgressCompletedHandler<f64> => [0x94d64ac6,0x4491,0x53ef,0x8b,0xe8,0x36,0x48,0x1f,0x3f,0xf1,0xe8] as IID_AsyncActionWithProgressCompletedHandler_1_System_Double }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncActionWithProgressCompletedHandler<super::web::syndication::TransferProgress> => [0xf1c031c8,0x90bf,0x5cae,0xad,0xf6,0x15,0x5b,0x4a,0xed,0xfb,0x60] as IID_AsyncActionWithProgressCompletedHandler_1_Windows_Web_Syndication_TransferProgress }
RT_PINTERFACE!{ for AsyncActionWithProgressCompletedHandler<u64> => [0xe6ff857b,0xf160,0x571a,0xa9,0x34,0x2c,0x61,0xf9,0x8c,0x86,0x2d] as IID_AsyncActionWithProgressCompletedHandler_1_System_UInt64 }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<bool> => [0xc1d3d1a2,0xae17,0x5a5f,0xb5,0xa2,0xbd,0xcc,0x88,0x44,0x88,0x9a] as IID_AsyncOperationCompletedHandler_1_System_Boolean }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IMap<HString, HString>> => [0x39bb624e,0xb5c6,0x5785,0xba,0x46,0x3f,0x45,0xaa,0xf3,0xef,0x35] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IMap_2_System_String_System_String }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IMap<HString, IInspectable>> => [0x7344f356,0x8399,0x5756,0xa2,0xf8,0xab,0xd5,0x0c,0x41,0x46,0xff] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IMap_2_System_String_System_Object }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IMapView<HString, IInspectable>> => [0x89981889,0x1207,0x5ae6,0x9b,0x28,0xcc,0xc5,0x8f,0x3a,0xac,0x6e] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IMapView_2_System_String_System_Object }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IMapView<HString, super::perception::spatial::SpatialAnchor>> => [0x3a950aa3,0x9c65,0x586e,0xaf,0x75,0x1a,0xcf,0x07,0x19,0x0e,0x90] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IMapView_2_System_String_Windows_Perception_Spatial_SpatialAnchor }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IMapView<HString, super::storage::streams::RandomAccessStreamReference>> => [0xd4cb6b80,0x821a,0x5a7b,0x89,0x8d,0xd5,0x89,0x17,0xb3,0x1a,0x36] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IMapView_2_System_String_Windows_Storage_Streams_RandomAccessStreamReference }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IMapView<u32, super::storage::streams::IBuffer>> => [0x92c2e4d0,0x7c25,0x596b,0x91,0x35,0x10,0xd1,0x47,0x2e,0x69,0x68] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IMapView_2_System_UInt32_Windows_Storage_Streams_IBuffer }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IPropertySet> => [0x5075a55f,0x68ba,0x56f2,0x97,0xe6,0x9b,0x1c,0xbf,0xa2,0xc5,0xf2] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IPropertySet }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVector<HString>> => [0xfae4b396,0x97c8,0x5cc3,0xbf,0x88,0xea,0x30,0x98,0xed,0xf6,0xb2] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVector_1_System_String }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVector<super::applicationmodel::contacts::Contact>> => [0x589b0543,0xeeae,0x5ca2,0xa6,0x3b,0x76,0x01,0x0c,0x64,0xfc,0xcb] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVector_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVector<super::applicationmodel::PackageContentGroup>> => [0x52465bf3,0x3ca6,0x5681,0xa7,0xb4,0x91,0x84,0x77,0x57,0xb5,0xfd] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVector_1_Windows_ApplicationModel_PackageContentGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVector<super::media::faceanalysis::DetectedFace>> => [0xb0a53153,0x2015,0x58b3,0x9d,0xd0,0xbd,0xf2,0x91,0xb8,0x56,0xb2] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVector_1_Windows_Media_FaceAnalysis_DetectedFace }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVector<super::system::AppDiagnosticInfo>> => [0xcc3f5f7e,0x4160,0x567f,0xa0,0xf6,0xaa,0x9a,0xeb,0x18,0x7a,0xf3] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVector_1_Windows_System_AppDiagnosticInfo }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<collections::IMapView<HString, IInspectable>>> => [0xa782a13a,0x16a0,0x5326,0xb9,0x85,0xc4,0xca,0x49,0xe5,0x4e,0x77] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Foundation_Collections_IMapView_2_System_String_System_Object }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<HString>> => [0x7c7899be,0x5f2e,0x5bf3,0xad,0xe5,0xad,0x98,0xb7,0x72,0xc7,0xcd] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_System_String }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<IInspectable>> => [0x261a9d81,0xf58f,0x5283,0x94,0x61,0xca,0x3e,0x31,0xc1,0x12,0x3c] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::appextensions::AppExtension>> => [0xcbd3ea3b,0x1275,0x5688,0x86,0x10,0x0a,0xb1,0xf8,0x34,0x42,0xfc] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_AppExtensions_AppExtension }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::AppInfo>> => [0x07f25b6f,0xf054,0x5649,0xa5,0xce,0xb3,0x48,0xdd,0xc6,0x18,0xb6] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_AppInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::appointments::Appointment>> => [0xf626345f,0x7bfc,0x5418,0x9f,0x47,0xf1,0xd8,0x63,0x06,0xe0,0x6b] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_Appointment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::appointments::AppointmentCalendar>> => [0xf478469b,0x9777,0x553d,0xbe,0xab,0x1b,0xb5,0xee,0xe1,0xca,0x8b] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_AppointmentCalendar }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::appointments::AppointmentException>> => [0x60e2023c,0xc2a9,0x5d3c,0x86,0xb1,0xcd,0x22,0x1c,0x30,0x8a,0x5e] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_AppointmentException }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::appointments::AppointmentStoreChange>> => [0x3fe84fc8,0xda80,0x5fab,0x8b,0x46,0x37,0x20,0xf7,0x64,0x63,0x45] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_AppointmentStoreChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::calls::PhoneCallHistoryEntry>> => [0x1ef6a805,0xfd84,0x5756,0xa1,0x80,0x35,0x3d,0xd7,0x2d,0xb2,0x75] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Calls_PhoneCallHistoryEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::chat::ChatConversation>> => [0xa54ad656,0x836f,0x5b3e,0xae,0xbd,0x17,0xc3,0xe9,0x8d,0xe4,0x8e] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::chat::ChatMessage>> => [0xe136bd95,0x1eca,0x5b87,0xb2,0x33,0x9d,0x47,0xd6,0xaa,0x52,0x24] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::chat::ChatMessageChange>> => [0x38b09bc0,0x5029,0x54de,0x91,0x65,0xdc,0xd8,0xb3,0xb9,0xb5,0x49] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatMessageChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::chat::ChatMessageTransport>> => [0xa40a3b3a,0x6a96,0x5297,0x8a,0xfb,0xcb,0xb4,0x97,0xd4,0x8e,0x15] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatMessageTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::chat::IChatItem>> => [0x53daad1e,0x44e7,0x5a96,0x86,0x88,0x2d,0xb7,0xc0,0x0d,0x81,0x43] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_IChatItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::chat::RcsTransport>> => [0xf6555a8d,0xa624,0x5eb4,0xa2,0xf3,0xf5,0xb1,0xc5,0xc1,0xa0,0xd2] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_RcsTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::Contact>> => [0x22da703a,0xc764,0x58cb,0x91,0x85,0xcc,0xfa,0xc3,0x60,0x02,0x5a] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::ContactAnnotation>> => [0x92707d1c,0x79b1,0x5200,0x81,0x1a,0x43,0x54,0x1a,0xd1,0xea,0xfa] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactAnnotation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::ContactAnnotationList>> => [0xdd802265,0xec6f,0x5573,0xa0,0x9e,0x02,0xb1,0xf1,0x8a,0x8a,0x51] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactAnnotationList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::ContactChange>> => [0x280a5e6f,0x8fd2,0x5659,0xa7,0xcc,0x7e,0xfa,0x11,0xbb,0xce,0x46] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::ContactGroup>> => [0xbd49aed6,0x182c,0x5847,0x94,0x67,0xf7,0x50,0xd1,0xd0,0x29,0xbc] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::ContactInformation>> => [0x059f51aa,0x64c6,0x53d5,0xbd,0x28,0x76,0xd0,0xe8,0x8e,0x3b,0x8f] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::contacts::ContactList>> => [0xeaafaa0f,0x472b,0x5cb1,0xad,0x7a,0xad,0x9f,0xd5,0x05,0xe2,0xc5] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::core::AppListEntry>> => [0x51c74372,0x9452,0x57ce,0x92,0x70,0x76,0x20,0x09,0xfb,0xfe,0x4d] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Core_AppListEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::email::EmailCertificateValidationStatus>> => [0x7db1b498,0x0944,0x5b7f,0x86,0x53,0x45,0xd0,0xd3,0x5d,0xdf,0xf1] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailCertificateValidationStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::email::EmailFolder>> => [0x1e343987,0xcbb3,0x5260,0xa6,0x9d,0xcb,0x00,0xe1,0x7c,0x8e,0x52] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailFolder }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::email::EmailMailbox>> => [0x478ddb6a,0xe122,0x5832,0x82,0x63,0xf3,0xd9,0x0a,0x1f,0x53,0x77] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailMailbox }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::email::EmailMailboxChange>> => [0xece9e82b,0xbbc1,0x5d32,0xb3,0x06,0x1e,0x4d,0x45,0x01,0xb6,0x8a] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailMailboxChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::email::EmailMessage>> => [0x128697e6,0x231f,0x5c2f,0x91,0x7d,0xc3,0x30,0xde,0x1d,0xa6,0x9b] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::email::EmailRecipientResolutionResult>> => [0xafee5c98,0xf2ed,0x5bbf,0x90,0xfb,0x95,0x5f,0x8e,0x6c,0x15,0xe0] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailRecipientResolutionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::resources::management::IndexedResourceCandidate>> => [0x4f2b3869,0xd059,0x5739,0x90,0x6c,0x9e,0xb2,0x72,0x9c,0x2f,0xde] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Resources_Management_IndexedResourceCandidate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::StartupTask>> => [0x15d40795,0x41f9,0x50d7,0xa3,0x9e,0x53,0x90,0x98,0x1a,0xf6,0x51] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_StartupTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::store::preview::installcontrol::AppInstallItem>> => [0xf92bfe4e,0xcf96,0x54cf,0xab,0x89,0x38,0x8c,0xa0,0x04,0xb5,0xa9] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::store::preview::StorePreviewProductInfo>> => [0x167564b0,0xc6f5,0x5143,0xb6,0x6f,0xa6,0xf9,0xca,0x69,0xe7,0xa2] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_Preview_StorePreviewProductInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::store::preview::StoreSystemFeature>> => [0x7e7946ef,0xf8f0,0x53fd,0x96,0x13,0x72,0x61,0xcb,0x35,0xda,0xf4] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_Preview_StoreSystemFeature }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::store::UnfulfilledConsumable>> => [0x0451fe11,0x6b50,0x54c1,0xb7,0x65,0xd9,0x46,0xb1,0xd5,0xc8,0x8b] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_UnfulfilledConsumable }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::userdataaccounts::UserDataAccount>> => [0xdc12096d,0x7e54,0x54a2,0xab,0x99,0x28,0x0f,0x30,0xf0,0xff,0x81] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::userdatatasks::UserDataTaskList>> => [0x4aba8568,0x5231,0x526c,0xb2,0xe4,0x80,0x50,0x06,0xb8,0xef,0x2f] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::applicationmodel::wallet::WalletItem>> => [0x9302d49e,0xdda3,0x5971,0xb4,0x8a,0xdf,0xdf,0x02,0xc5,0x72,0xaf] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Wallet_WalletItem }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::data::text::TextPhoneme>> => [0x83e14307,0x0be1,0x5560,0x8b,0xfc,0x29,0x10,0x95,0xcf,0x6d,0x30] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Data_Text_TextPhoneme }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::adc::AdcController>> => [0x7c4038c8,0xd920,0x53c7,0xa5,0xd6,0xa9,0x76,0x07,0x0d,0x76,0x37] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Adc_AdcController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::bluetooth::genericattributeprofile::GattClientNotificationResult>> => [0x2f6c4343,0x667f,0x5d74,0x8e,0xe7,0xb3,0x9d,0xe3,0x35,0xa9,0x60] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattClientNotificationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::geolocation::Geoposition>> => [0x6c67a1d1,0x9441,0x5aee,0xb6,0x25,0xe3,0xc1,0xb5,0x67,0x6a,0x6d] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Geolocation_Geoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::gpio::GpioController>> => [0xee427f2e,0x7d37,0x558f,0x97,0x18,0x9c,0xbc,0xbf,0xf4,0x0c,0x94] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Gpio_GpioController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::haptics::VibrationDevice>> => [0x096f6389,0x6757,0x56df,0xaf,0x12,0xcf,0xe1,0xd8,0xf2,0x3f,0xc1] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Haptics_VibrationDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::i2c::I2cController>> => [0x3b9d7cb1,0xae0b,0x56af,0x8e,0xd5,0x68,0x56,0xb1,0xe7,0xcd,0x5b] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_I2c_I2cController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::i2c::provider::II2cControllerProvider>> => [0x771e22ed,0xda9e,0x50be,0xb7,0x30,0xa3,0xba,0xda,0x6b,0xfb,0x25] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_I2c_Provider_II2cControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::perception::PerceptionColorFrameSource>> => [0x0a36a7af,0xda9e,0x553f,0x8d,0xc5,0xe8,0x9d,0x70,0x5b,0xb4,0x0b] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Perception_PerceptionColorFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::perception::PerceptionDepthFrameSource>> => [0xc06e62a4,0x965b,0x5a29,0x97,0x32,0x8a,0xc8,0x66,0x9b,0x58,0x5e] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Perception_PerceptionDepthFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::perception::PerceptionInfraredFrameSource>> => [0x3aac58a8,0x4454,0x57e5,0xa9,0x0b,0x24,0x49,0xc5,0xb7,0xdf,0xe8] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Perception_PerceptionInfraredFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::pwm::PwmController>> => [0xe72bd078,0xce02,0x55ac,0xa7,0xb9,0xab,0xd0,0x12,0x48,0xd8,0x88] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Pwm_PwmController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::radios::Radio>> => [0xd30691e6,0x60a0,0x59c9,0x89,0x65,0x5b,0xbe,0x28,0x2e,0x82,0x08] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Radios_Radio }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::sensors::ActivitySensorReading>> => [0x179fb953,0x2d58,0x5991,0x8f,0x5b,0xac,0x64,0x21,0x9a,0x11,0x01] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sensors_ActivitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::sensors::PedometerReading>> => [0x5bbff840,0x59f2,0x5108,0x92,0x05,0xa0,0xbb,0xf8,0xf9,0xba,0x68] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sensors_PedometerReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::smartcards::SmartCard>> => [0xbfea3fad,0x411e,0x5721,0x88,0xf5,0x92,0xc9,0xb9,0xfb,0xbe,0x14] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_SmartCards_SmartCard }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::smartcards::SmartCardAppletIdGroupRegistration>> => [0xdddeb324,0x2853,0x5e3c,0xa4,0xd9,0x1c,0xa8,0xc5,0x77,0xc0,0x2e] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_SmartCards_SmartCardAppletIdGroupRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::spi::provider::ISpiControllerProvider>> => [0xe9e2ae03,0x42d6,0x5211,0xab,0x52,0x32,0x5e,0x72,0x2e,0x26,0x11] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Spi_Provider_ISpiControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::spi::SpiController>> => [0xc8afc9cb,0x6807,0x57ec,0x84,0xc9,0x9f,0x3d,0xbc,0x00,0x34,0x50] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Spi_SpiController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::devices::wifi::WiFiAdapter>> => [0x92902a07,0x2f18,0x56e9,0x87,0xfb,0x24,0xfe,0x19,0xf7,0x06,0x88] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_WiFi_WiFiAdapter }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::gaming::preview::gamesenumeration::GameListEntry>> => [0xeadac44b,0x7fdd,0x5589,0xb0,0x93,0x1b,0xb7,0x3c,0xc6,0x4f,0x02] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Gaming_Preview_GamesEnumeration_GameListEntry }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::graphics::imaging::ImageStream>> => [0x6683d49c,0x9fd5,0x5b08,0x89,0x9f,0xe2,0xd7,0xdc,0x5c,0xf9,0xc4] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Graphics_Imaging_ImageStream }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::management::deployment::PackageVolume>> => [0x721241c2,0x0b83,0x594a,0x9b,0x61,0xce,0x7f,0x14,0x92,0xc4,0x15] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Management_Deployment_PackageVolume }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::media::capture::frames::MediaFrameSourceGroup>> => [0xcff78a64,0xbd44,0x5638,0xaf,0x2f,0x54,0x0c,0x23,0xb3,0x22,0xe7] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Media_Capture_Frames_MediaFrameSourceGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::media::core::CodecInfo>> => [0x58bf2d7c,0xae9b,0x5f1b,0x8b,0x66,0x5f,0xf1,0xbb,0xb1,0x02,0x9a] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Media_Core_CodecInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::media::import::PhotoImportSource>> => [0x72cde698,0x9247,0x5053,0x8c,0xbd,0xd9,0x07,0x6b,0xfd,0xfd,0xa5] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Media_Import_PhotoImportSource }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::backgroundtransfer::DownloadOperation>> => [0x1986b372,0x0ddb,0x520c,0xb7,0x2d,0xfb,0x25,0x77,0xe9,0x9f,0xf5] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::backgroundtransfer::UploadOperation>> => [0x608a29a8,0xbbc5,0x5ea3,0xb3,0xf7,0x87,0xed,0xc4,0xe7,0xbb,0xbc] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::connectivity::AttributedNetworkUsage>> => [0x96af15cc,0xf060,0x5667,0x92,0x23,0xe0,0x54,0xd1,0x42,0x39,0xec] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_AttributedNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::connectivity::ConnectionProfile>> => [0xc523d9dd,0x4ea6,0x5115,0x80,0xe9,0x4e,0x7a,0xd4,0x76,0x97,0x98] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_ConnectionProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::connectivity::ConnectivityInterval>> => [0xb475014c,0x95f1,0x5310,0xb5,0xd1,0xc2,0x30,0x9d,0x94,0x44,0x40] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_ConnectivityInterval }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::connectivity::NetworkUsage>> => [0xe31d7e7e,0x4173,0x5c71,0xb0,0x4b,0xa0,0x96,0x58,0x00,0x25,0x90] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_NetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::connectivity::ProviderNetworkUsage>> => [0xc310276b,0x3932,0x5da9,0x9a,0x3b,0xc5,0xc4,0x23,0x58,0x6b,0x42] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_ProviderNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::EndpointPair>> => [0x20d6faab,0x3b8e,0x5a1f,0x83,0x97,0xb0,0x1c,0xb2,0x19,0xa1,0x8d] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_EndpointPair }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::proximity::PeerInformation>> => [0xecf90f2c,0xe3f4,0x5b62,0xa0,0x66,0x8b,0x9c,0x81,0x8f,0xd4,0x1a] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Proximity_PeerInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::networking::vpn::IVpnProfile>> => [0xdac6dd72,0xa5d1,0x56d4,0xaf,0xc4,0x98,0x9f,0x84,0xdc,0xb2,0xb3] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Vpn_IVpnProfile }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::security::authentication::identity::EnterpriseKeyCredentialRegistrationInfo>> => [0x67746c40,0xade0,0x5981,0xae,0x23,0x10,0x48,0x91,0x74,0x88,0x53] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Authentication_Identity_EnterpriseKeyCredentialRegistrationInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::security::authentication::identity::provider::SecondaryAuthenticationFactorInfo>> => [0x06752d25,0xd43e,0x5d2e,0xa3,0x05,0x4e,0x15,0x76,0x84,0x6f,0xee] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::security::authentication::web::provider::WebAccountClientView>> => [0x3fa6536f,0x7e7a,0x5bc9,0xb2,0x0f,0xd8,0x66,0xca,0xca,0xf8,0x1c] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Authentication_Web_Provider_WebAccountClientView }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::security::credentials::WebAccount>> => [0xc2090d8c,0x37d8,0x5c47,0x95,0x81,0x0f,0x17,0xb9,0x1a,0x0c,0xd3] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Credentials_WebAccount }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::security::cryptography::certificates::Certificate>> => [0x1896faee,0x23e2,0x59ca,0x98,0x02,0x0f,0x48,0xee,0xd9,0x8e,0xf4] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Cryptography_Certificates_Certificate }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::services::store::StorePackageUpdate>> => [0xf8491bcd,0x2db5,0x58e0,0x8c,0x47,0x44,0xe6,0xeb,0x10,0xc1,0x2d] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Services_Store_StorePackageUpdate }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::bulkaccess::FileInformation>> => [0xebdb2c85,0xd27a,0x5c93,0xa1,0xb3,0x6c,0xa3,0x65,0x1a,0xda,0x5d] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_BulkAccess_FileInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::bulkaccess::FolderInformation>> => [0x020713ec,0x604a,0x5e45,0xb0,0x3f,0x1b,0x9e,0x65,0x25,0x38,0x04] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_BulkAccess_FolderInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::bulkaccess::IStorageItemInformation>> => [0xff163034,0xece9,0x55be,0xa6,0xf8,0x08,0xc7,0x2a,0xae,0x56,0xb4] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_BulkAccess_IStorageItemInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::IStorageItem>> => [0x51436e75,0xace1,0x5a68,0xb2,0x60,0xf8,0x43,0xb8,0x46,0xf0,0xdb] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_IStorageItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::search::IIndexableContent>> => [0x6a29f493,0xefb7,0x5fdb,0xa1,0x3e,0xf2,0xc2,0x8b,0x4d,0xab,0x58] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_Search_IIndexableContent }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::StorageFile>> => [0xcb4206c5,0x0988,0x5104,0xaf,0xa9,0x25,0x3c,0x29,0x8f,0x86,0xfd] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_StorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::StorageFolder>> => [0xed2d1d9b,0x26ec,0x5be7,0xa8,0xa3,0x56,0x45,0x89,0x33,0xd2,0x5f] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_StorageFolder }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::storage::StorageLibraryChange>> => [0xab9cea41,0x6df8,0x535d,0x81,0x71,0x46,0xaf,0xf1,0x87,0x15,0x8f] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_StorageLibraryChange }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::system::User>> => [0x09870533,0xf7cb,0x569c,0xb7,0x97,0xdc,0xb4,0x8d,0xeb,0xd7,0x09] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_System_User }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::ui::input::inking::InkRecognitionResult>> => [0xece8567f,0x8080,0x5ced,0x89,0x88,0xbb,0x03,0x64,0xc8,0x03,0xd4] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_Input_Inking_InkRecognitionResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::ui::notifications::ToastCollection>> => [0x4650e069,0x3052,0x530e,0xbc,0x38,0x93,0xc4,0x11,0x77,0x3b,0x77] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_Notifications_ToastCollection }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::ui::notifications::UserNotification>> => [0x9e42ed08,0x45b3,0x5643,0xb5,0xc7,0xb2,0x16,0xf5,0x78,0x15,0x94] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_Notifications_UserNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<super::ui::startscreen::SecondaryTile>> => [0xb9d6d973,0xa089,0x550a,0x83,0xb7,0xf6,0x59,0xea,0x0d,0xea,0x04] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_StartScreen_SecondaryTile }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<collections::IVectorView<u32>> => [0x55772f29,0xda64,0x5c87,0x87,0x1c,0x07,0x43,0x37,0xa8,0x45,0x73] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Collections_IVectorView_1_System_UInt32 }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<diagnostics::ErrorDetails> => [0xa6997f9d,0x7195,0x5972,0x8e,0xcd,0x1c,0x73,0xaa,0x5c,0xb3,0x12] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Diagnostics_ErrorDetails }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<Guid> => [0x5233899b,0xba7e,0x504f,0xbb,0x83,0xce,0xeb,0xac,0x62,0xde,0xcf] as IID_AsyncOperationCompletedHandler_1_System_Guid }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<HString> => [0xb79a741f,0x7fb5,0x50ae,0x9e,0x99,0x91,0x12,0x01,0xec,0x3d,0x41] as IID_AsyncOperationCompletedHandler_1_System_String }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<i32> => [0xd60cae9d,0x88cb,0x59f1,0x85,0x76,0x3f,0xba,0x44,0x79,0x6b,0xe8] as IID_AsyncOperationCompletedHandler_1_System_Int32 }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<i64> => [0xd3ef5872,0x7d4e,0x59bb,0x95,0xed,0x79,0xfe,0x0f,0x0d,0xbe,0x89] as IID_AsyncOperationCompletedHandler_1_System_Int64 }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<IInspectable> => [0x3f08262e,0xa2e1,0x5134,0x92,0x97,0xe9,0x21,0x1f,0x48,0x1a,0x2d] as IID_AsyncOperationCompletedHandler_1_System_Object }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<IReference<DateTime>> => [0xc4225d5e,0x1b7c,0x571e,0x9b,0x88,0x2a,0xb2,0xee,0xfa,0x8c,0x8f] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_IReference_1_Windows_Foundation_DateTime }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<IReference<TimeSpan>> => [0xe137b677,0xbfef,0x54b0,0xb2,0x00,0x95,0xc5,0xc2,0x90,0x2a,0x25] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_IReference_1_Windows_Foundation_TimeSpan }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appointments::Appointment> => [0xb640ed04,0x9331,0x5b28,0x92,0x47,0x01,0x46,0xbc,0xf5,0xb7,0x2a] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Appointments_Appointment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appointments::AppointmentCalendar> => [0x6d9cb651,0x5af6,0x51b0,0x9c,0xd3,0x45,0xdd,0x51,0xf1,0x79,0x49] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Appointments_AppointmentCalendar }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appointments::AppointmentConflictResult> => [0x82fb40fe,0x05b1,0x523c,0x9b,0x53,0xb3,0xdd,0x75,0x9c,0x9f,0x75] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Appointments_AppointmentConflictResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appointments::AppointmentStore> => [0xbccf6d2a,0xab72,0x5f23,0xb7,0xd5,0x4c,0x2c,0x9b,0xd4,0x5b,0x79] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Appointments_AppointmentStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appservice::AppServiceConnectionStatus> => [0xb6c6bbf2,0x72ca,0x5799,0xa6,0x51,0xd1,0x99,0x06,0x70,0x09,0x7b] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_AppService_AppServiceConnectionStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appservice::AppServiceResponse> => [0x7ea7d7ec,0xe164,0x52c3,0x8e,0x32,0xbb,0xa7,0x12,0x6d,0x90,0x28] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_AppService_AppServiceResponse }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::appservice::AppServiceResponseStatus> => [0xb824383d,0x32e0,0x5579,0x86,0x70,0xa0,0x6a,0x61,0x45,0x7f,0x20] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_AppService_AppServiceResponseStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::AlarmAccessStatus> => [0x84108017,0xa8e7,0x5449,0xb7,0x13,0xdf,0x48,0x50,0x3a,0x95,0x3e] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_AlarmAccessStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::ApplicationTriggerResult> => [0xd0065ef6,0xee9d,0x55f8,0xac,0x2b,0x53,0xa9,0x1f,0xf9,0x6d,0x2e] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_ApplicationTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::BackgroundAccessStatus> => [0x26dd26e3,0x3f47,0x5709,0xb2,0xf2,0xd6,0xd0,0xad,0x32,0x88,0xf0] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_BackgroundAccessStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::DeviceConnectionChangeTrigger> => [0x3fd5a57e,0x47e4,0x5921,0xb1,0x48,0x5c,0xb5,0x86,0x16,0x6c,0xa8] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_DeviceConnectionChangeTrigger }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::DeviceTriggerResult> => [0xd5aa9506,0x1464,0x57d4,0x85,0x9d,0x7e,0xe9,0xb2,0x6c,0xb1,0xf9] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_DeviceTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::GattServiceProviderTriggerResult> => [0x39d8105f,0xa505,0x5f88,0x91,0xa9,0xb0,0xfc,0x6d,0x62,0x86,0x99] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_GattServiceProviderTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::background::MediaProcessingTriggerResult> => [0x3814c6a5,0x2ad1,0x5875,0xbe,0xd5,0x50,0x31,0xcd,0x1f,0x50,0xa2] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Background_MediaProcessingTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::calls::PhoneCallHistoryEntry> => [0x3234244b,0xabee,0x561d,0xb2,0x47,0x79,0xb8,0x32,0x82,0x20,0x55] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Calls_PhoneCallHistoryEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::calls::PhoneCallHistoryStore> => [0x226a138b,0x79ea,0x56d3,0xad,0xc2,0xa4,0x0d,0xb8,0xd8,0xc9,0xb0] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Calls_PhoneCallHistoryStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::calls::VoipPhoneCallResourceReservationStatus> => [0x7a27b20f,0x647a,0x53fc,0x80,0xf0,0xa7,0x9d,0x08,0x3c,0xe5,0x31] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Calls_VoipPhoneCallResourceReservationStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::ChatCapabilities> => [0xce2d035c,0x7686,0x56bd,0xa2,0xca,0x19,0x47,0x35,0xfd,0x86,0x17] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_ChatCapabilities }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::ChatConversation> => [0x0b9c15f1,0x1871,0x50c5,0x86,0xde,0x6e,0x61,0x4d,0x59,0x3c,0x57] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_ChatConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::ChatMessage> => [0x2704edec,0x009d,0x5abb,0xa7,0x18,0x76,0x77,0x18,0x15,0x8d,0x88] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_ChatMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::ChatMessageStore> => [0xa9174f86,0x1fc7,0x50f4,0x8d,0x7e,0x10,0x3d,0x3f,0xd6,0xe5,0xa3] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_ChatMessageStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::ChatMessageTransport> => [0x69dc85b1,0xba0b,0x57d3,0xb7,0xc3,0x61,0x8e,0x01,0x56,0xf8,0xcb] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_ChatMessageTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::ChatSyncManager> => [0x5b3512cc,0x8528,0x5e87,0xb0,0x61,0x1b,0x98,0x2a,0x64,0x7f,0xc4] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_ChatSyncManager }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::chat::RcsTransport> => [0x7851a9c5,0x1467,0x5c7d,0xaf,0x74,0x57,0xec,0x6b,0xd3,0x34,0x17] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Chat_RcsTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::Contact> => [0xa1d09bee,0xc181,0x5419,0xbd,0x14,0x82,0x23,0xb9,0x5f,0x29,0xa1] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactAnnotation> => [0x23c8c9ed,0x8920,0x5d9e,0xb0,0x52,0xc3,0x5e,0x31,0xfc,0x23,0x43] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactAnnotation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactAnnotationList> => [0xb2478ee7,0xdc89,0x5b7d,0xb4,0xa3,0xb3,0xbe,0x29,0x52,0x20,0x9f] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactAnnotationList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactAnnotationStore> => [0x558f6e19,0x2d4e,0x5a4a,0x8c,0x58,0x38,0x73,0xd6,0x23,0xb1,0xd4] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactAnnotationStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactBatch> => [0xdc49c74d,0x1ac7,0x5754,0x82,0xe9,0x25,0x18,0x0c,0x4d,0xd8,0x88] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactInformation> => [0xc94b8021,0x508b,0x589b,0x93,0xb3,0x25,0x56,0xcb,0xc7,0x3a,0x2f] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactList> => [0xd4678af2,0x2cc4,0x5890,0xb3,0xa2,0x03,0xa5,0xab,0x7b,0xb8,0xf8] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::ContactStore> => [0xd123e7f2,0x0b5b,0x590a,0xb2,0x34,0xa1,0x21,0xac,0x1e,0x0b,0xab] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_ContactStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::contacts::PinnedContactIdsQueryResult> => [0x930a23a2,0x28cf,0x5606,0x82,0xf1,0x65,0xdf,0xee,0x22,0x87,0x35] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Contacts_PinnedContactIdsQueryResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::core::AppRestartFailureReason> => [0xdcec478a,0x9f27,0x5c5d,0xaf,0xdb,0xc9,0x1a,0xee,0x4f,0x1f,0x02] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Core_AppRestartFailureReason }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::datatransfer::DataPackage> => [0xa93a3b99,0xe946,0x57ce,0xaa,0xd9,0xc2,0x3d,0x13,0x8c,0x35,0x3e] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_DataTransfer_DataPackage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::datatransfer::DataPackageOperation> => [0xadd21d46,0x17df,0x5a43,0xa6,0x85,0x32,0x62,0xfc,0xe8,0x46,0x43] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_DataTransfer_DataPackageOperation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailConversation> => [0x0294c89d,0x8d98,0x5342,0xb8,0x2f,0x01,0x10,0x24,0x15,0xc8,0x70] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailConversationBatch> => [0xf1406083,0x2a75,0x5726,0xba,0x48,0x90,0xe3,0x2e,0xad,0xd7,0xfa] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailConversationBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailFolder> => [0xf1b66ef7,0x0525,0x5da5,0xa3,0xd6,0xb2,0x5b,0x3f,0x53,0x3a,0xa1] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailFolder }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailItemCounts> => [0x02c54220,0xded8,0x5495,0x84,0x1d,0xd4,0x32,0xc8,0x79,0xb8,0x26] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailItemCounts }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMailbox> => [0x4d5f57df,0xe0dc,0x5cf5,0xb2,0xe5,0xfa,0x1e,0x5c,0x00,0x06,0xfa] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMailbox }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMailboxAutoReplySettings> => [0xdfc1275a,0xc7b0,0x5fe4,0x93,0x70,0x32,0xb9,0x4a,0xd0,0xba,0x8e] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMailboxAutoReplySettings }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMailboxCreateFolderResult> => [0x929f0fda,0xf350,0x55be,0x85,0x55,0xe9,0x8d,0x81,0xea,0xf1,0xa5] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMailboxCreateFolderResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMailboxDeleteFolderStatus> => [0x52604da6,0x485b,0x5445,0x8e,0x6f,0x64,0xcc,0x13,0x05,0x60,0x45] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMailboxDeleteFolderStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMailboxEmptyFolderStatus> => [0x50333005,0xdaed,0x567e,0xbb,0x88,0xb1,0xbc,0x46,0x63,0xb0,0x75] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMailboxEmptyFolderStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMessage> => [0x69d11d1e,0xf0bb,0x5f1b,0xac,0xb5,0x12,0x0c,0x26,0xfe,0xbd,0xed] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailMessageBatch> => [0xb6674195,0x87f8,0x5575,0x91,0x08,0x9c,0x56,0x21,0xd5,0x29,0xb1] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailMessageBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::email::EmailStore> => [0xddb761d3,0x71b8,0x5c4b,0xad,0x8b,0x1e,0x65,0x22,0x66,0x49,0x21] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Email_EmailStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::extendedexecution::ExtendedExecutionResult> => [0x873c5c7a,0xc638,0x5a33,0x9b,0x03,0x21,0x5c,0x72,0x47,0x16,0x63] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_ExtendedExecution_ExtendedExecutionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::extendedexecution::foreground::ExtendedExecutionForegroundResult> => [0x07e1dc01,0x18ba,0x596a,0xb7,0x45,0x79,0xf9,0xcd,0xe4,0x4c,0xcc] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_ExtendedExecution_Foreground_ExtendedExecutionForegroundResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::PackageCatalogAddOptionalPackageResult> => [0x6c5f9b5d,0x3c24,0x5087,0xae,0x15,0x6a,0xb4,0x94,0x2c,0x46,0x39] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_PackageCatalogAddOptionalPackageResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::PackageCatalogRemoveOptionalPackagesResult> => [0xf168612c,0x6882,0x5c8c,0xa4,0x64,0x7e,0xa2,0x5e,0x26,0x98,0x76] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_PackageCatalogRemoveOptionalPackagesResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::PackageContentGroup> => [0x2253dc38,0x9a1a,0x5364,0x9a,0x3b,0x03,0xa7,0xda,0x61,0x54,0x99] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_PackageContentGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::payments::PaymentCanMakePaymentResult> => [0x89ae5b89,0x6d05,0x5842,0x9c,0xdf,0xf4,0xcb,0xf7,0x06,0xdc,0x5e] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Payments_PaymentCanMakePaymentResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::payments::PaymentRequestChangedResult> => [0xbec8b726,0x9056,0x5e47,0xb2,0x2a,0x0d,0xa0,0x9a,0xa8,0x4a,0xfe] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Payments_PaymentRequestChangedResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::payments::PaymentRequestSubmitResult> => [0xcbcd07a6,0xae2a,0x5a70,0xbc,0x0b,0x91,0x20,0x56,0x08,0x25,0xd1] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Payments_PaymentRequestSubmitResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::payments::provider::PaymentTransaction> => [0xbd5b92e5,0x1086,0x5c3d,0x9d,0xe1,0x99,0x82,0xe7,0x76,0xd1,0x93] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Payments_Provider_PaymentTransaction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::payments::provider::PaymentTransactionAcceptResult> => [0x4538f88a,0x89af,0x50b9,0x81,0x65,0x7e,0x62,0x69,0x63,0x98,0x84] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Payments_Provider_PaymentTransactionAcceptResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::socialinfo::provider::SocialDashboardItemUpdater> => [0x33cfd9aa,0x6c3c,0x50df,0xbb,0xc8,0x34,0xc2,0x2a,0x0e,0x5b,0x6b] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_SocialInfo_Provider_SocialDashboardItemUpdater }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::socialinfo::provider::SocialFeedUpdater> => [0x0b227474,0x80c0,0x5f33,0x9f,0xf9,0x23,0x44,0x03,0xab,0xd6,0xfa] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_SocialInfo_Provider_SocialFeedUpdater }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::StartupTask> => [0x741f7697,0x2452,0x5c80,0x83,0xc6,0x3b,0x6f,0x82,0x2b,0x90,0x4c] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_StartupTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::StartupTaskState> => [0x70a0bf67,0x19e8,0x5a86,0xa3,0x2e,0x3c,0x98,0x63,0x82,0x5a,0x04] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_StartupTaskState }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::FulfillmentResult> => [0x8775acc9,0xb9ae,0x5cce,0x89,0x5c,0x97,0x1b,0xf9,0x27,0x08,0x92] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_FulfillmentResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::licensemanagement::LicenseSatisfactionResult> => [0x936e8471,0x252f,0x5339,0x89,0xc3,0x94,0x28,0x41,0x20,0x86,0xca] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_LicenseManagement_LicenseSatisfactionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::ListingInformation> => [0xfdf83922,0x762e,0x57dc,0xb7,0x21,0xc7,0x2e,0xe5,0x68,0xfd,0x96] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_ListingInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::preview::installcontrol::AppInstallItem> => [0xa85c1ceb,0x0e8c,0x5422,0xb2,0xef,0xad,0x48,0xed,0x33,0x87,0x06] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::preview::installcontrol::GetEntitlementResult> => [0x62559e90,0x1c0a,0x5708,0x92,0x30,0x03,0xa6,0x58,0x65,0x2d,0xb3] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_Preview_InstallControl_GetEntitlementResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::preview::StorePreviewPurchaseResults> => [0xb1ea16e7,0x8268,0x51ff,0x81,0x29,0xdc,0xef,0xd4,0x93,0xf3,0x5f] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_Preview_StorePreviewPurchaseResults }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::store::PurchaseResults> => [0x24b6922a,0xfdb1,0x5003,0xae,0x89,0xc8,0xbf,0x16,0xca,0x01,0x43] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Store_PurchaseResults }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::useractivities::UserActivity> => [0x652507c7,0x0bc6,0x5d0b,0x82,0xbe,0x97,0xad,0x22,0x57,0xb6,0x85] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserActivities_UserActivity }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdataaccounts::systemaccess::DeviceAccountConfiguration> => [0xcbee2c48,0xe3ed,0x5ebd,0xa4,0xae,0x56,0x58,0x33,0x88,0xa4,0x9a] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataAccounts_SystemAccess_DeviceAccountConfiguration }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdataaccounts::UserDataAccount> => [0xab92e426,0x2ac6,0x5ffb,0x88,0xca,0xcb,0xdd,0x91,0xdf,0x39,0x27] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdataaccounts::UserDataAccountStore> => [0x264c2ca9,0x29b4,0x5035,0xb4,0x60,0x8c,0x8d,0x0e,0x8f,0xbc,0xd9] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccountStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdatatasks::UserDataTask> => [0xa731c0cd,0x206d,0x5af8,0xad,0x64,0x85,0xb7,0x20,0x0f,0x4c,0xe2] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataTasks_UserDataTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdatatasks::UserDataTaskBatch> => [0xe63bf8b8,0x91f0,0x5f13,0xa1,0xc9,0xde,0xe1,0x87,0x9d,0x0a,0x52] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdatatasks::UserDataTaskList> => [0xeefb814a,0x6af7,0x5d59,0xbf,0x3f,0xb6,0xc7,0x3b,0x8c,0x74,0xa2] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::userdatatasks::UserDataTaskStore> => [0x33c9c615,0x2f80,0x587d,0x9f,0x51,0x02,0x7e,0xc4,0x57,0xb7,0xa3] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::voicecommands::VoiceCommand> => [0x1024f849,0xb4a1,0x52e6,0xb7,0x71,0x6d,0x2f,0x08,0xc3,0x0e,0x63] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_VoiceCommands_VoiceCommand }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::voicecommands::VoiceCommandConfirmationResult> => [0xf5244cb8,0xf912,0x50c9,0xb2,0x18,0xd7,0xa0,0x40,0x39,0x71,0xaa] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_VoiceCommands_VoiceCommandConfirmationResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::voicecommands::VoiceCommandDisambiguationResult> => [0x46b96890,0x2942,0x5564,0x82,0xd8,0x31,0xa4,0x85,0x1b,0xd7,0xb8] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_VoiceCommands_VoiceCommandDisambiguationResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::wallet::system::WalletItemSystemStore> => [0xfe76bd86,0x3570,0x5d56,0x93,0x2e,0xa6,0xfb,0x80,0x93,0xa5,0x57] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Wallet_System_WalletItemSystemStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::wallet::WalletItem> => [0x88b0349f,0x503d,0x5786,0xa2,0x67,0x55,0xbb,0x37,0xa8,0xa1,0xb1] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Wallet_WalletItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::applicationmodel::wallet::WalletItemStore> => [0x5334975e,0x205a,0x5b6c,0x96,0xfd,0x89,0x6f,0xb9,0x39,0x49,0xbd] as IID_AsyncOperationCompletedHandler_1_Windows_ApplicationModel_Wallet_WalletItemStore }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::data::pdf::PdfDocument> => [0x8d4950b3,0x629d,0x5d7d,0x84,0xcc,0x04,0xc0,0xdc,0xf7,0x94,0x2b] as IID_AsyncOperationCompletedHandler_1_Windows_Data_Pdf_PdfDocument }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::data::xml::dom::XmlDocument> => [0x5eef7817,0x93dd,0x5c0b,0x9e,0x5a,0xeb,0x49,0x04,0x08,0xf3,0xa9] as IID_AsyncOperationCompletedHandler_1_Windows_Data_Xml_Dom_XmlDocument }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::adc::AdcController> => [0xbaf66488,0x202f,0x5d51,0xb0,0x5e,0x18,0x60,0x6c,0x46,0xb8,0x08] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Adc_AdcController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::alljoyn::AllJoynAboutDataView> => [0xba2da2f5,0xf9b0,0x5c66,0x8f,0xc9,0x7d,0x43,0x7a,0x67,0xf2,0x8a] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_AllJoyn_AllJoynAboutDataView }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::alljoyn::AllJoynServiceInfo> => [0xffb22299,0xa9c9,0x5c2a,0xac,0xe3,0x0c,0xd0,0xa6,0xdd,0x10,0x39] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_AllJoyn_AllJoynServiceInfo }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::alljoyn::AllJoynSession> => [0x52490f64,0xc98f,0x5019,0x83,0x61,0xb2,0xa3,0xe1,0x67,0x9f,0x27] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_AllJoyn_AllJoynSession }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::BluetoothAdapter> => [0x10a10a88,0x90e0,0x511a,0x9a,0x08,0xd7,0x5f,0xeb,0x52,0xa1,0x9f] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_BluetoothAdapter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::BluetoothDevice> => [0xb2e8cdd1,0x66aa,0x5892,0x85,0xa3,0x8f,0x0b,0x16,0x5e,0x43,0xfc] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_BluetoothDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::BluetoothLEDevice> => [0x9156b79f,0xc54a,0x5277,0x8f,0x8b,0xd2,0xcc,0x43,0xc7,0xe0,0x04] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_BluetoothLEDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattCharacteristicsResult> => [0xd6a15475,0x1e72,0x5c56,0x98,0xe8,0x88,0xf4,0xbc,0x3e,0x03,0x13] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattClientNotificationResult> => [0x9783fef1,0x1b62,0x5418,0x98,0x98,0x93,0x31,0x38,0xc2,0xbd,0x14] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattClientNotificationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattCommunicationStatus> => [0x2154117a,0x978d,0x59db,0x99,0xcf,0x6b,0x69,0x0c,0xb3,0x38,0x9b] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCommunicationStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattDescriptorsResult> => [0xdf09ae77,0xf606,0x53e4,0x8b,0xa6,0x79,0x9f,0x59,0x92,0xc8,0x5e] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDescriptorsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattDeviceService> => [0x2dbcf64a,0x262b,0x5708,0xad,0xb1,0xc3,0xb8,0x75,0x0b,0xd6,0x80] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattDeviceServicesResult> => [0x74ab0892,0xa631,0x5d6c,0xb1,0xb4,0xbd,0x2e,0x1a,0x74,0x1a,0x9b] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDeviceServicesResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristicResult> => [0x85c70edd,0xd815,0x5284,0x8c,0x84,0x58,0xa8,0xf7,0x69,0xe3,0x88] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristicResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattLocalDescriptorResult> => [0xf2927eec,0x47d9,0x5338,0x9b,0xa5,0x5b,0xe8,0x46,0x1a,0xd4,0x10] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalDescriptorResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattOpenStatus> => [0x548b3cd0,0xdce8,0x5d3d,0x98,0xab,0x69,0x48,0xdd,0x7f,0x90,0xb8] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattOpenStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattReadClientCharacteristicConfigurationDescriptorResult> => [0x98f9a6f3,0x4d29,0x5351,0x8b,0x12,0x75,0x1d,0xc9,0x77,0xa3,0x31] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadClientCharacteristicConfigurationDescriptorResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattReadRequest> => [0x31823848,0x3ab2,0x547a,0x83,0x03,0x96,0x4d,0xcc,0x37,0x7c,0x9c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadRequest }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattReadResult> => [0xd8992aa0,0xeac2,0x55b7,0x92,0xc5,0x89,0x48,0x86,0xbe,0xb0,0xca] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattServiceProviderResult> => [0xf992789a,0xe981,0x597a,0x91,0x97,0x1f,0xbd,0x98,0x6f,0x74,0xc7] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattServiceProviderResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattSession> => [0xcae01a28,0xfd33,0x542e,0xa5,0xad,0x3d,0x87,0x8f,0x73,0xdb,0x90] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSession }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattWriteRequest> => [0x25b737f6,0x30ff,0x558e,0xba,0x16,0xb5,0x64,0xc4,0x5f,0xdc,0x06] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteRequest }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::genericattributeprofile::GattWriteResult> => [0x6fa8c9c3,0xff7e,0x5fa1,0xa2,0xf3,0x27,0x14,0xcf,0x04,0xb8,0x99] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::rfcomm::RfcommDeviceService> => [0x5c772518,0x442f,0x58ed,0x80,0xcb,0x53,0x8d,0x34,0xb8,0x82,0x95] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_Rfcomm_RfcommDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::rfcomm::RfcommDeviceServicesResult> => [0x522c25d1,0x866b,0x5de4,0xbd,0x8e,0x1f,0xeb,0x5a,0xe6,0x0d,0x47] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_Rfcomm_RfcommDeviceServicesResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::bluetooth::rfcomm::RfcommServiceProvider> => [0x446a7f50,0x8f2e,0x51f0,0xae,0xbb,0x1b,0xc3,0xd1,0x92,0x90,0x5f] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Bluetooth_Rfcomm_RfcommServiceProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::custom::CustomDevice> => [0x1fdd39b0,0xe0e5,0x5c59,0xb2,0x7d,0xa5,0x49,0xb1,0x07,0x5c,0xe9] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Custom_CustomDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::DeviceAccessStatus> => [0xee154d83,0x805b,0x53e8,0x84,0x69,0x90,0x71,0x50,0x36,0xd0,0x13] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_DeviceAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::DeviceInformation> => [0xbb483df2,0x7bb6,0x5923,0xa2,0x8d,0x83,0x42,0xec,0x30,0x04,0x6b] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_DeviceInformation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::DeviceInformationCollection> => [0x4a458732,0x527e,0x5c73,0x9a,0x68,0xa7,0x3d,0xa3,0x70,0xf7,0x82] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_DeviceInformationCollection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::DevicePairingResult> => [0x7ee0247f,0x5f57,0x5cb2,0xb4,0x0e,0x18,0xb5,0xa2,0x11,0xd6,0xc3] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_DevicePairingResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::DeviceThumbnail> => [0x86d455b2,0xd795,0x554c,0x9c,0x31,0xbf,0x65,0x39,0x34,0x9c,0x19] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_DeviceThumbnail }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::DeviceUnpairingResult> => [0x9bbe6eb9,0xdb2d,0x5160,0xa2,0x0c,0xf0,0xc2,0x65,0xf2,0x0d,0x8e] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_DeviceUnpairingResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::pnp::PnpObject> => [0x9d615463,0x6879,0x521f,0x8e,0x97,0xe6,0x6d,0x3d,0xdb,0xc9,0x5e] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_Pnp_PnpObject }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::enumeration::pnp::PnpObjectCollection> => [0x811d834c,0xa15e,0x5522,0xb7,0xf4,0xe5,0x30,0x04,0xfc,0x58,0xff] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Enumeration_Pnp_PnpObjectCollection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::geolocation::GeolocationAccessStatus> => [0xf3524c93,0xe5c7,0x5b88,0xbe,0xdb,0xd3,0xe6,0x37,0xcf,0xf2,0x71] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Geolocation_GeolocationAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::geolocation::Geopoint> => [0x4b5f2f60,0x19b1,0x5566,0x9d,0xf6,0x92,0xa4,0x22,0x35,0xcb,0xf9] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Geolocation_Geopoint }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::geolocation::Geoposition> => [0x7668a704,0x244e,0x5e12,0x8d,0xcb,0x92,0xa3,0x29,0x9e,0xba,0x26] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Geolocation_Geoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::geolocation::Geovisit> => [0xb9bce8cb,0x2e04,0x5269,0x9b,0x03,0x16,0x14,0xd0,0xc0,0x0b,0x01] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Geolocation_Geovisit }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::gpio::GpioController> => [0x370167c0,0x0f7b,0x5e77,0x9b,0xae,0xd3,0x50,0x89,0xa3,0xdb,0x75] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Gpio_GpioController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::haptics::VibrationAccessStatus> => [0xa38b59db,0x4ef1,0x5bd2,0x89,0xef,0xf1,0xd9,0xf1,0xfa,0xca,0x96] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Haptics_VibrationAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::haptics::VibrationDevice> => [0x4e22a135,0xf59a,0x546d,0x9f,0xcf,0x82,0xde,0xb8,0x33,0xd9,0x68] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Haptics_VibrationDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::humaninterfacedevice::HidDevice> => [0xb0e8e149,0x0cb6,0x55a7,0xbc,0xc1,0xd9,0x96,0x32,0x4d,0x65,0xc4] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_HumanInterfaceDevice_HidDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::humaninterfacedevice::HidFeatureReport> => [0xdb643555,0x3d16,0x57fe,0xb7,0xef,0x2b,0xdb,0xd7,0x19,0xfd,0xbf] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_HumanInterfaceDevice_HidFeatureReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::humaninterfacedevice::HidInputReport> => [0x01c83770,0x03ab,0x5576,0x98,0xb4,0x8d,0x75,0xce,0x1a,0x98,0x85] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_HumanInterfaceDevice_HidInputReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::i2c::I2cController> => [0x6ff64b72,0xa5aa,0x5986,0xb5,0x63,0x27,0x61,0x2a,0xfb,0x37,0x3c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_I2c_I2cController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::i2c::I2cDevice> => [0x2df5bb6a,0x5e73,0x5ae3,0xa0,0xb2,0x22,0xe1,0xc9,0xd8,0xef,0x4d] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_I2c_I2cDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::lights::Lamp> => [0x191a8c6e,0x60dd,0x5a21,0xa5,0x3c,0xbf,0x3f,0x94,0x0a,0x1d,0xde] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Lights_Lamp }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::midi::IMidiOutPort> => [0xeed37805,0x2a49,0x59b4,0xb4,0xd4,0x11,0x88,0xc6,0x81,0x91,0x22] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Midi_IMidiOutPort }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::midi::MidiInPort> => [0x6c090fb2,0x8099,0x558f,0x8a,0x92,0x9a,0x8e,0xa8,0x06,0xe6,0xfb] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Midi_MidiInPort }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::midi::MidiSynthesizer> => [0x5d716335,0xd087,0x516f,0xad,0x0a,0x63,0xf6,0x1c,0xbc,0xf3,0x42] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Midi_MidiSynthesizer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionColorFrameSource> => [0x3b56acc2,0xe275,0x54fb,0xbe,0x08,0x9f,0xdc,0x8f,0x1a,0x1e,0x10] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionColorFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionDepthCorrelatedCameraIntrinsics> => [0xf396602a,0x3d8d,0x5fd5,0x99,0xe3,0x1d,0x36,0x30,0xbe,0x59,0x38] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionDepthCorrelatedCameraIntrinsics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionDepthCorrelatedCoordinateMapper> => [0x48deeda0,0x684d,0x51e6,0xb0,0x7c,0xd2,0x34,0xd1,0x00,0x6b,0xfc] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionDepthCorrelatedCoordinateMapper }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionDepthFrameSource> => [0xb48cb886,0x3476,0x58d9,0xb7,0x6d,0xfd,0xa6,0xb3,0xe8,0x1f,0x54] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionDepthFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionFrameSourceAccessStatus> => [0x62744ea4,0x3447,0x5722,0xab,0x5e,0x02,0x56,0x7b,0x4f,0xce,0xeb] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionFrameSourceAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionFrameSourcePropertyChangeResult> => [0x3a06099c,0xdba6,0x58a5,0x84,0x64,0xe2,0x32,0x68,0x96,0x84,0x1a] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionFrameSourcePropertyChangeResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::perception::PerceptionInfraredFrameSource> => [0xa8d4cd8e,0xb210,0x54f7,0xae,0x2b,0x77,0x70,0xe1,0x9b,0x3e,0x36] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Perception_PerceptionInfraredFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::BarcodeScanner> => [0x8d8abf39,0x99dd,0x50a4,0xaa,0x7c,0x2f,0x73,0x01,0xb5,0xca,0x9c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_BarcodeScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::BarcodeSymbologyAttributes> => [0xf8fc5a52,0x2f45,0x5e46,0xa8,0x2e,0x3d,0xa0,0x09,0x57,0x3b,0x5c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_BarcodeSymbologyAttributes }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::CashDrawer> => [0x57836710,0xf186,0x5636,0x89,0x1d,0xf8,0xc5,0x39,0x8e,0xa6,0xdf] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_CashDrawer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::ClaimedBarcodeScanner> => [0xff72ba2d,0xf3c4,0x5abe,0xbb,0xce,0x53,0x15,0x04,0x49,0xb6,0x37] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_ClaimedBarcodeScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::ClaimedCashDrawer> => [0xe68c3736,0xfde7,0x5cfb,0xb2,0x2f,0x92,0x11,0x97,0x23,0xe7,0x29] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_ClaimedCashDrawer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::ClaimedLineDisplay> => [0x4e1a79f1,0xdff2,0x5b18,0xbe,0xbe,0x2a,0xca,0x01,0x0b,0xbf,0xcc] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_ClaimedLineDisplay }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::ClaimedMagneticStripeReader> => [0x946c2d64,0x22d4,0x552d,0xab,0xfb,0x9e,0xb3,0x41,0xbd,0x67,0xf3] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_ClaimedMagneticStripeReader }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::ClaimedPosPrinter> => [0x01eb0dc3,0x3c30,0x5eea,0x9f,0xce,0xef,0xb3,0x98,0xe0,0xbe,0x34] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_ClaimedPosPrinter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::LineDisplay> => [0xb5c4d476,0x4f46,0x53c4,0x8a,0x45,0x89,0xdb,0xe6,0xd6,0xf2,0x86] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_LineDisplay }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::LineDisplayPowerStatus> => [0xabba6d19,0xd81f,0x5d85,0xa9,0x00,0x66,0xb9,0x6b,0x6d,0x2b,0x32] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_LineDisplayPowerStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::LineDisplayStoredBitmap> => [0xa576fa69,0x9988,0x5a23,0x84,0x4c,0xf8,0xa6,0x9f,0x48,0xa4,0x29] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_LineDisplayStoredBitmap }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::LineDisplayWindow> => [0xe4d37b02,0xb65a,0x5aec,0xa2,0x19,0xd1,0xe0,0xb7,0xf3,0xf9,0x12] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_LineDisplayWindow }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::MagneticStripeReader> => [0x32c55f7b,0x8ee3,0x555d,0x99,0x8b,0x78,0xc9,0x8a,0xa9,0x62,0x7b] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_MagneticStripeReader }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pointofservice::PosPrinter> => [0x5e8dbbc8,0x8b60,0x5881,0x8b,0x6e,0xf6,0x99,0xb4,0x94,0x9d,0xba] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_PointOfService_PosPrinter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::power::Battery> => [0x97f82115,0x3822,0x507b,0x82,0xe6,0x27,0x77,0xb3,0x36,0xe9,0x8e] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Power_Battery }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::printers::Print3DDevice> => [0x8d4b123f,0x4343,0x5195,0xbb,0xc9,0xb9,0x9e,0x95,0x6e,0x05,0x7f] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Printers_Print3DDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::pwm::PwmController> => [0x5fc68e9f,0xffff,0x5d53,0xba,0x21,0x9c,0x33,0xef,0x56,0xb2,0x40] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Pwm_PwmController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::radios::Radio> => [0x8a5c7e3a,0x80e2,0x585b,0x86,0x30,0x7a,0x8e,0x77,0x7f,0x03,0x54] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Radios_Radio }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::radios::RadioAccessStatus> => [0xbd248e73,0xf05f,0x574c,0xae,0x3d,0x9b,0x95,0xc4,0xbf,0x28,0x2a] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Radios_RadioAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::scanners::ImageScanner> => [0xb35ad6b4,0x0da0,0x5241,0x87,0xff,0xee,0xf3,0xa1,0x88,0x32,0x43] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Scanners_ImageScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::scanners::ImageScannerPreviewResult> => [0xc054a410,0xac3c,0x5353,0xb1,0xee,0xe8,0x5e,0x78,0xfa,0xf3,0xf1] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Scanners_ImageScannerPreviewResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Accelerometer> => [0xc7c339b6,0x7527,0x502a,0x8a,0x4c,0xcb,0x9b,0xef,0xe1,0x58,0x40] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Accelerometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::ActivitySensor> => [0xfb0594f4,0x93d9,0x5c2f,0xb8,0xeb,0x90,0xf1,0xe9,0x25,0x8f,0xdc] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_ActivitySensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::ActivitySensorReading> => [0xadc48d5d,0xb343,0x5a58,0x84,0x54,0x6e,0x2b,0xc2,0xe0,0x47,0x5c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_ActivitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Barometer> => [0xa15e21d6,0x5467,0x590c,0xaf,0xe1,0x9c,0x81,0x32,0xdc,0xd8,0xa4] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Barometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Compass> => [0x0cf1e460,0xbc2c,0x587c,0x98,0x22,0x42,0x0b,0xa0,0x4d,0x05,0x51] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Compass }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::custom::CustomSensor> => [0x808b62d7,0x6e02,0x5680,0xa5,0x9e,0x11,0x8a,0x98,0xa4,0xe7,0x0f] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Custom_CustomSensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Gyrometer> => [0x15799501,0x958e,0x5315,0xa2,0x4a,0x0d,0x7d,0x7a,0xcb,0xc7,0x9c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Gyrometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Inclinometer> => [0x8f0ede2a,0x2d0f,0x55f6,0x95,0x66,0x3c,0x21,0x38,0x5f,0xae,0x64] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Inclinometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::LightSensor> => [0x5d04e2bf,0x5163,0x5238,0x8f,0x23,0xce,0x47,0x0b,0x30,0x34,0x0d] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_LightSensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Magnetometer> => [0x46e0a768,0x9645,0x51a6,0xb6,0xa7,0x1e,0x5f,0x4b,0x40,0xe1,0xf3] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Magnetometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::OrientationSensor> => [0x8330b323,0x6695,0x53d4,0xac,0xd7,0xb6,0x0c,0x24,0xc1,0xb8,0x79] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_OrientationSensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sensors::Pedometer> => [0xa62dbe4e,0x51de,0x5a13,0xba,0x21,0xe7,0x6d,0xf3,0xbc,0x13,0x96] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sensors_Pedometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::serialcommunication::SerialDevice> => [0x84a34b33,0x06fc,0x5e63,0x8e,0xe2,0xea,0xb4,0xff,0x69,0xac,0xb7] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SerialCommunication_SerialDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardActivationPolicyChangeResult> => [0x9528f94b,0x047b,0x5e2a,0x8f,0xc0,0x70,0x17,0xf5,0xda,0xdd,0xff] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardActivationPolicyChangeResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardAppletIdGroupRegistration> => [0x371045fb,0x4994,0x5413,0x89,0xbe,0xba,0x4e,0x97,0xad,0x82,0xa0] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardAppletIdGroupRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardChallengeContext> => [0x96b172f6,0xdedb,0x5f3e,0xaf,0x90,0x7b,0x0f,0x10,0x21,0x93,0x52] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardChallengeContext }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardConnection> => [0xc71f00e6,0xaf26,0x5e5c,0x91,0x3d,0x0e,0xfe,0xb7,0xd0,0x8e,0xf7] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardConnection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramGenerator> => [0x25cc9462,0x46a1,0x50a6,0xad,0x14,0x9a,0x97,0x18,0x37,0x20,0x05] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramGenerator }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramGeneratorOperationStatus> => [0xc6c447c7,0xa60d,0x500a,0x9b,0xfe,0x59,0xf2,0x5c,0x33,0xe9,0x79] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramGeneratorOperationStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult> => [0x45cffa0a,0xb354,0x50c3,0x8f,0x24,0x3d,0xd4,0xf1,0x67,0x7f,0xbe] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult> => [0xcd50ac04,0xe836,0x5525,0x9e,0xdb,0x06,0x6d,0x62,0x05,0xa2,0xa7] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult> => [0xc960993d,0xb328,0x5e86,0xb0,0xa3,0x25,0xf0,0x9f,0x7e,0x45,0xdf] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramMaterialPossessionProof> => [0xcaf2474e,0x8810,0x5b17,0x95,0xd6,0x81,0x75,0x8a,0xe5,0x19,0x85] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPossessionProof }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardCryptogramStorageKeyInfo> => [0x3f34e667,0x0a36,0x5414,0x88,0xab,0x63,0x71,0xd1,0xb3,0xb0,0x7e] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardCryptogramStorageKeyInfo }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardEmulator> => [0x4982e406,0x052c,0x5782,0xa5,0x7d,0x54,0xf9,0xf4,0x4f,0x84,0x12] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardEmulator }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardProvisioning> => [0x7a2e58dc,0x22ee,0x5cb8,0x83,0xcc,0xa7,0xa6,0x1b,0x9d,0xcd,0x2c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardProvisioning }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardReader> => [0x20d3244d,0x375a,0x5f7d,0x89,0x44,0x16,0x4f,0xdf,0xed,0x42,0x39] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardReader }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardReaderStatus> => [0x3d7e6ea9,0xe739,0x555c,0x9c,0x02,0x07,0x39,0x6c,0x53,0x21,0xf5] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardReaderStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::smartcards::SmartCardStatus> => [0xbdaf4a41,0x3b4a,0x56b0,0xae,0xec,0xfe,0xe7,0x1c,0xc7,0xf3,0x28] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_SmartCards_SmartCardStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sms::ISmsMessage> => [0x4e6c4c86,0xebe6,0x55d9,0xad,0xc0,0xfe,0xcc,0x38,0xc8,0x2a,0xa2] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sms_ISmsMessage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sms::SmsDevice> => [0x44aa5484,0x43d0,0x5893,0xa4,0xee,0x7d,0xb0,0x01,0x13,0xae,0x60] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sms_SmsDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::sms::SmsSendMessageResult> => [0xc7d5c6fe,0x9206,0x5eb1,0xab,0xc1,0xc1,0xbc,0x21,0x80,0x4e,0xeb] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Sms_SmsSendMessageResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::spi::SpiController> => [0x5e94d949,0xa844,0x5b25,0xa3,0xcc,0xaf,0xab,0xeb,0x18,0xc1,0xd2] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Spi_SpiController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::spi::SpiDevice> => [0xa88a28ba,0x6966,0x55e7,0x8c,0x81,0x7c,0x65,0xf7,0x4e,0x39,0xc0] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Spi_SpiDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::usb::UsbDevice> => [0x7331254f,0x6caf,0x587d,0x9c,0x2a,0x01,0x8c,0x66,0xd3,0x12,0xdb] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_Usb_UsbDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifi::WiFiAccessStatus> => [0x65e889ca,0xf6c9,0x5c75,0xbe,0xf9,0x05,0xab,0x88,0xa4,0x9a,0x54] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFi_WiFiAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifi::WiFiAdapter> => [0x35362f75,0x6aae,0x560d,0xb3,0xd0,0x3f,0xae,0x9c,0x72,0x60,0xa8] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFi_WiFiAdapter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifi::WiFiConnectionResult> => [0xf380eb8d,0x1e52,0x5350,0xa2,0x88,0x86,0x1c,0x96,0x3a,0x84,0xf0] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFi_WiFiConnectionResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifi::WiFiWpsConfigurationResult> => [0x33fa345b,0x28cd,0x58a8,0xbc,0xfc,0xbe,0x4c,0xfd,0x10,0x8e,0x91] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFi_WiFiWpsConfigurationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifidirect::services::WiFiDirectService> => [0xf505a3c8,0x4837,0x5e0e,0x8a,0x4d,0x1e,0x2a,0xf5,0x47,0x7e,0x5c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFiDirect_Services_WiFiDirectService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifidirect::services::WiFiDirectServiceProvisioningInfo> => [0x94cb9568,0x040a,0x5186,0xa3,0xc9,0x52,0x68,0x0e,0xe1,0x79,0x84] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceProvisioningInfo }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifidirect::services::WiFiDirectServiceSession> => [0xb29de711,0x60b8,0x59da,0x8f,0x4d,0xfc,0x79,0xd8,0xcc,0xd4,0x22] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceSession }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::devices::wifidirect::WiFiDirectDevice> => [0xd34abe17,0xfb19,0x57be,0xbc,0x41,0x0e,0xb8,0x3d,0xea,0x15,0x1c] as IID_AsyncOperationCompletedHandler_1_Windows_Devices_WiFiDirect_WiFiDirectDevice }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::input::forcefeedback::ForceFeedbackLoadEffectResult> => [0xf8220a41,0xf738,0x51e8,0x89,0xba,0x76,0xbb,0xd6,0x61,0x58,0xcb] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_Input_ForceFeedback_ForceFeedbackLoadEffectResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::preview::gamesenumeration::GameListEntry> => [0xa77293e0,0xd508,0x5582,0xac,0x76,0x8c,0x96,0x05,0xfa,0x1d,0xe9] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_Preview_GamesEnumeration_GameListEntry }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::ui::GameMonitoringPermission> => [0xb30d8404,0x94e7,0x5267,0x9c,0x7a,0xbd,0x79,0x72,0x7b,0x81,0x5a] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_UI_GameMonitoringPermission }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::xboxlive::storage::GameSaveBlobGetResult> => [0x9d96282c,0xb6ab,0x5cd3,0x99,0x1b,0xa3,0x58,0xc5,0x31,0xbc,0xb6] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_XboxLive_Storage_GameSaveBlobGetResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::xboxlive::storage::GameSaveBlobInfoGetResult> => [0x9331e53a,0xa414,0x51e7,0xbf,0xbc,0x77,0x84,0xdf,0x83,0xdc,0x8e] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_XboxLive_Storage_GameSaveBlobInfoGetResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::xboxlive::storage::GameSaveContainerInfoGetResult> => [0x05f86a80,0xbe5b,0x5e7e,0xb9,0x77,0x82,0x57,0xc5,0xe4,0x8a,0xcc] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_XboxLive_Storage_GameSaveContainerInfoGetResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::xboxlive::storage::GameSaveOperationResult> => [0xee53e64f,0x5319,0x56fd,0xa2,0x8a,0x2c,0x47,0x4f,0xc4,0x2e,0x48] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_XboxLive_Storage_GameSaveOperationResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::gaming::xboxlive::storage::GameSaveProviderGetResult> => [0x7617548d,0x8e60,0x50cb,0xa1,0x1e,0x12,0x0f,0xa2,0x08,0x2e,0x5b] as IID_AsyncOperationCompletedHandler_1_Windows_Gaming_XboxLive_Storage_GameSaveProviderGetResult }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::BitmapDecoder> => [0xbb6514f2,0x3cfb,0x566f,0x82,0xbc,0x60,0xaa,0xbd,0x30,0x2d,0x53] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_BitmapDecoder }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::BitmapEncoder> => [0x5df1afc5,0x478d,0x55dd,0xb3,0x17,0x02,0x42,0x74,0x06,0x2a,0x0d] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_BitmapEncoder }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::BitmapFrame> => [0x2817455a,0x983f,0x5a06,0x9f,0xe4,0xfb,0x96,0x37,0x68,0x43,0x20] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_BitmapFrame }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::BitmapPropertySet> => [0xa8325bd7,0xa3be,0x5881,0x9f,0xa7,0x04,0xce,0xef,0xb9,0xdc,0x2f] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_BitmapPropertySet }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::ImageStream> => [0x29bb8288,0x4462,0x516e,0xa6,0x75,0x8c,0x92,0x35,0xc4,0x29,0x94] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_ImageStream }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::PixelDataProvider> => [0x37bdf4be,0x2f39,0x592c,0xa4,0xf7,0xd1,0x6a,0x09,0xd2,0xb2,0xdb] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_PixelDataProvider }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::imaging::SoftwareBitmap> => [0xb699b653,0x33ed,0x5e2d,0xa7,0x5f,0x02,0xbf,0x90,0xe3,0x26,0x19] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Imaging_SoftwareBitmap }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::printing::printticket::WorkflowPrintTicket> => [0xd486c08d,0x8e7c,0x5f8d,0x87,0xab,0x0d,0xf7,0xba,0x06,0xc5,0xe3] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Printing_PrintTicket_WorkflowPrintTicket }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::printing::printticket::WorkflowPrintTicketValidationResult> => [0x3b0bfff8,0x0d4b,0x51eb,0xb0,0x40,0x49,0x3d,0xe1,0xad,0xda,0xb9] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Printing_PrintTicket_WorkflowPrintTicketValidationResult }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::printing3d::Printing3D3MFPackage> => [0x28b6b208,0x85a7,0x53f1,0x83,0xae,0x57,0x7a,0x7d,0xe6,0x6a,0x9b] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Printing3D_Printing3D3MFPackage }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::printing3d::Printing3DMeshVerificationResult> => [0x186bae17,0x5896,0x56de,0xbf,0xf4,0x4f,0x17,0x6b,0x3e,0x61,0x94] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Printing3D_Printing3DMeshVerificationResult }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::graphics::printing3d::Printing3DModel> => [0x26f4d34c,0xa11d,0x5b09,0x99,0x08,0xad,0xe8,0xb1,0xb1,0x35,0x55] as IID_AsyncOperationCompletedHandler_1_Windows_Graphics_Printing3D_Printing3DModel }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::management::deployment::PackageVolume> => [0x35fee361,0x6cea,0x5e5c,0x8e,0xda,0x34,0xb3,0xf2,0x2d,0xf4,0xe7] as IID_AsyncOperationCompletedHandler_1_Windows_Management_Deployment_PackageVolume }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::apprecording::AppRecordingResult> => [0x1f6f478f,0x6cab,0x58e5,0x81,0x94,0x98,0x08,0x3c,0x72,0xdd,0xfc] as IID_AsyncOperationCompletedHandler_1_Windows_Media_AppRecording_AppRecordingResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::apprecording::AppRecordingSaveScreenshotResult> => [0x8e2047c3,0x4cdd,0x5404,0x9f,0x68,0x52,0x9d,0x0a,0x35,0xbe,0x65] as IID_AsyncOperationCompletedHandler_1_Windows_Media_AppRecording_AppRecordingSaveScreenshotResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::audio::CreateAudioDeviceInputNodeResult> => [0x6cc56450,0xe4e8,0x59c9,0x83,0xd8,0x63,0xe4,0x6e,0xac,0xb2,0x0b] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Audio_CreateAudioDeviceInputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::audio::CreateAudioDeviceOutputNodeResult> => [0xedbc9b59,0x7cae,0x513f,0xb0,0xdc,0x17,0x66,0x6d,0x37,0xba,0x77] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Audio_CreateAudioDeviceOutputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::audio::CreateAudioFileInputNodeResult> => [0x504d1efd,0xc11c,0x506e,0xb8,0xc9,0xaf,0x17,0xc7,0x71,0xef,0xb5] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Audio_CreateAudioFileInputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::audio::CreateAudioFileOutputNodeResult> => [0xa7a95713,0xa08f,0x5fdf,0x89,0xc6,0x96,0x27,0xbc,0xf5,0xd8,0x0a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Audio_CreateAudioFileOutputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::audio::CreateAudioGraphResult> => [0x4e660bda,0xd438,0x5741,0x8b,0x66,0x85,0xfe,0x72,0x57,0x4a,0xab] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Audio_CreateAudioGraphResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::AdvancedCapturedPhoto> => [0xedf3452c,0xd918,0x5c95,0x8e,0x3a,0x24,0x50,0x44,0xdd,0x70,0xdf] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_AdvancedCapturedPhoto }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::AdvancedPhotoCapture> => [0xd1dfaec8,0xeed3,0x5ce3,0x98,0x32,0x18,0x34,0x4c,0x98,0xfa,0x71] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_AdvancedPhotoCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::CapturedPhoto> => [0xfdb0aa78,0x04e1,0x56b3,0xb6,0xfc,0xf4,0xde,0x79,0xcd,0x41,0xa0] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_CapturedPhoto }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::core::VariablePhotoSequenceCapture> => [0x18a55dd3,0x01e3,0x5ae5,0x9b,0x5e,0xc8,0x4a,0xd4,0x0c,0xf6,0xb7] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Core_VariablePhotoSequenceCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MediaFrameReader> => [0xa6214dad,0xb917,0x5c89,0xa0,0x68,0xe3,0x2c,0x9a,0x70,0x37,0xd3] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MediaFrameReader }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MediaFrameReaderStartStatus> => [0x9f49b2e5,0x2f68,0x5c58,0x8d,0x8b,0x12,0x17,0x6f,0xf6,0xea,0x50] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MediaFrameReaderStartStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MediaFrameSourceGetPropertyResult> => [0xd0577f0d,0xce46,0x5c47,0x8f,0x7c,0x4a,0xe5,0x62,0x6c,0xc7,0x6d] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MediaFrameSourceGetPropertyResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MediaFrameSourceGroup> => [0xadf10eeb,0x9fc5,0x553b,0x91,0x64,0x29,0x42,0x46,0x99,0x2a,0x2a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MediaFrameSourceGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MediaFrameSourceSetPropertyStatus> => [0xf613663a,0xc685,0x5dc0,0xb1,0x33,0x60,0xd9,0x43,0x03,0xa6,0xe3] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MediaFrameSourceSetPropertyStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MultiSourceMediaFrameReader> => [0x69993778,0xa48c,0x50cc,0xa6,0xf0,0x53,0x68,0xf5,0x8a,0x29,0x7a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MultiSourceMediaFrameReader }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::frames::MultiSourceMediaFrameReaderStartStatus> => [0x18eef24a,0x3332,0x5fee,0xa0,0xf0,0x72,0xce,0xed,0x33,0x06,0x45] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_Frames_MultiSourceMediaFrameReaderStartStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::LowLagMediaRecording> => [0x64a8f80c,0xe646,0x52bb,0x8f,0x4b,0x2a,0x1d,0x6b,0x0b,0x82,0x19] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_LowLagMediaRecording }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::LowLagPhotoCapture> => [0x6cebb368,0x4e84,0x500a,0x9a,0x5f,0x7b,0x9a,0x1a,0xde,0x1f,0x44] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_LowLagPhotoCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::LowLagPhotoSequenceCapture> => [0x767e0fdc,0x9563,0x572d,0x84,0xe1,0x9c,0xaa,0xb0,0xde,0xb6,0x3f] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_LowLagPhotoSequenceCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::MediaCapturePauseResult> => [0xfe726311,0x26bf,0x51cd,0xbd,0xeb,0xf4,0x0f,0x8f,0x46,0x9d,0x0a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_MediaCapturePauseResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::capture::MediaCaptureStopResult> => [0x5d4e0674,0x1df4,0x5326,0xba,0x78,0x72,0xf6,0x65,0x5d,0x2a,0x76] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Capture_MediaCaptureStopResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::casting::CastingConnectionErrorStatus> => [0x7216a94a,0xa10a,0x5763,0x8e,0x96,0xbf,0x33,0xc5,0x82,0xed,0x92] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Casting_CastingConnectionErrorStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::casting::CastingDevice> => [0xf0c69b9e,0x14cb,0x510a,0x8e,0xf0,0x7e,0x86,0xd7,0x71,0xba,0xaf] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Casting_CastingDevice }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::casting::CastingPlaybackTypes> => [0xb55e550c,0xdfa8,0x50be,0xbe,0x8f,0x5d,0x42,0xc9,0xda,0xc1,0x20] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Casting_CastingPlaybackTypes }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::contentrestrictions::ContentAccessRestrictionLevel> => [0xcf61be5d,0x40c3,0x5484,0x84,0x6a,0x3f,0x82,0xb8,0xba,0x57,0x38] as IID_AsyncOperationCompletedHandler_1_Windows_Media_ContentRestrictions_ContentAccessRestrictionLevel }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::contentrestrictions::ContentRestrictionsBrowsePolicy> => [0x72ae1a16,0xc705,0x54e7,0xb1,0xc4,0xfc,0x05,0xa0,0xe0,0x7a,0x77] as IID_AsyncOperationCompletedHandler_1_Windows_Media_ContentRestrictions_ContentRestrictionsBrowsePolicy }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::core::MediaStreamSample> => [0xdf7aacc9,0xa86c,0x5c7d,0xbf,0x98,0xcc,0x37,0x1c,0x97,0xc6,0x7b] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Core_MediaStreamSample }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::devices::ModuleCommandResult> => [0xcb786404,0xf2e8,0x5e0b,0xbf,0x12,0x39,0xe3,0x14,0x83,0xcf,0xae] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Devices_ModuleCommandResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::dialprotocol::DialAppLaunchResult> => [0x164c0aa8,0x3d2b,0x579b,0x94,0xa3,0xcc,0x49,0x25,0xc6,0x95,0xec] as IID_AsyncOperationCompletedHandler_1_Windows_Media_DialProtocol_DialAppLaunchResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::dialprotocol::DialAppStateDetails> => [0x38c62dd5,0x1f16,0x55c0,0x8e,0xc7,0xca,0x0f,0xc8,0x41,0xd6,0x14] as IID_AsyncOperationCompletedHandler_1_Windows_Media_DialProtocol_DialAppStateDetails }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::dialprotocol::DialAppStopResult> => [0xc755f54a,0xef7b,0x563a,0x9b,0x14,0x46,0x2e,0x72,0xd9,0x66,0x5a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_DialProtocol_DialAppStopResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::dialprotocol::DialDevice> => [0x81bc7d1b,0x7d06,0x555f,0x81,0x1b,0x42,0xec,0x0f,0xa7,0x1b,0x55] as IID_AsyncOperationCompletedHandler_1_Windows_Media_DialProtocol_DialDevice }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::editing::BackgroundAudioTrack> => [0xb8830bc7,0x188b,0x5c25,0xa3,0xbb,0x95,0x90,0x52,0xbc,0xb7,0x40] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Editing_BackgroundAudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::editing::MediaClip> => [0x60cde3bc,0x119f,0x50a8,0x9c,0xcb,0x9e,0xa5,0x7e,0xa9,0x6b,0xfd] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Editing_MediaClip }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::editing::MediaComposition> => [0xedd253f8,0x4ebd,0x56e5,0x95,0x92,0x3c,0x09,0x37,0x5e,0xbd,0xc4] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Editing_MediaComposition }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::faceanalysis::FaceDetector> => [0x3224aec6,0xe785,0x5066,0x97,0x6f,0x79,0xdd,0x08,0x1b,0x75,0xa9] as IID_AsyncOperationCompletedHandler_1_Windows_Media_FaceAnalysis_FaceDetector }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::faceanalysis::FaceTracker> => [0x57d5163d,0x9e80,0x59d2,0x93,0x66,0xd2,0xb5,0x24,0x8b,0x27,0x24] as IID_AsyncOperationCompletedHandler_1_Windows_Media_FaceAnalysis_FaceTracker }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::IMediaExtension> => [0x9c1b578e,0xfb7d,0x5bab,0xba,0x39,0x86,0x38,0x7f,0xe5,0x33,0xb6] as IID_AsyncOperationCompletedHandler_1_Windows_Media_IMediaExtension }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::import::PhotoImportSource> => [0xdc38b22a,0x872e,0x53f8,0x8e,0x97,0x45,0xed,0x85,0xdf,0x0d,0x23] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Import_PhotoImportSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::mediaproperties::MediaEncodingProfile> => [0x37296fc1,0x86da,0x58a0,0x90,0xc0,0xc8,0x07,0xbd,0x94,0x39,0x5e] as IID_AsyncOperationCompletedHandler_1_Windows_Media_MediaProperties_MediaEncodingProfile }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::ocr::OcrResult> => [0x989c1371,0x444a,0x5e7e,0xb1,0x97,0x9e,0xaa,0xf9,0xd2,0x82,0x9a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Ocr_OcrResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::playlists::Playlist> => [0x427deafd,0xb226,0x5ef0,0x93,0x20,0xc9,0xf3,0x25,0xe3,0x74,0x74] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Playlists_Playlist }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::protection::HdcpSetProtectionResult> => [0x19344a58,0xa5c1,0x5168,0x80,0x3e,0x63,0x27,0x71,0x62,0x81,0x43] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Protection_HdcpSetProtectionResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::protection::playready::INDLicenseFetchResult> => [0xf72fdf87,0x9055,0x58d8,0x96,0xab,0x2c,0xc0,0x4d,0x06,0xcc,0xd7] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Protection_PlayReady_INDLicenseFetchResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::protection::playready::INDSendResult> => [0xc6c485d0,0xfdab,0x5142,0xb0,0x79,0x97,0xaf,0x05,0x67,0xf0,0xb6] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Protection_PlayReady_INDSendResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::protection::playready::INDStartResult> => [0x1e4e3760,0xb22b,0x5f0a,0x90,0x58,0x47,0x5a,0xff,0x31,0x0d,0xb5] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Protection_PlayReady_INDStartResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::speechrecognition::SpeechRecognitionCompilationResult> => [0x78c859bd,0x14d4,0x5c40,0xab,0xff,0x49,0x06,0x16,0xd5,0xe9,0x2d] as IID_AsyncOperationCompletedHandler_1_Windows_Media_SpeechRecognition_SpeechRecognitionCompilationResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::speechrecognition::SpeechRecognitionResult> => [0xc2195c7d,0xdcc2,0x5c6d,0x91,0x62,0xc8,0xdf,0x66,0x52,0x87,0x62] as IID_AsyncOperationCompletedHandler_1_Windows_Media_SpeechRecognition_SpeechRecognitionResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::speechsynthesis::SpeechSynthesisStream> => [0xc972b996,0x6165,0x50d4,0xaf,0x60,0xa8,0xc3,0xdf,0x51,0xd0,0x92] as IID_AsyncOperationCompletedHandler_1_Windows_Media_SpeechSynthesis_SpeechSynthesisStream }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::streaming::adaptive::AdaptiveMediaSourceCreationResult> => [0xbd68cc00,0x724c,0x5a76,0xa4,0x37,0x14,0x64,0xeb,0xdd,0xa4,0xac] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceCreationResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::transcoding::PrepareTranscodeResult> => [0xa44d7d07,0x8f74,0x52ee,0x9f,0x02,0xc2,0xb2,0x44,0xb4,0xff,0x2a] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Transcoding_PrepareTranscodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::transcoding::TranscodeFailureReason> => [0xc42ae2bf,0xe194,0x5179,0xb8,0xad,0x03,0xb5,0x1c,0x04,0xe1,0xda] as IID_AsyncOperationCompletedHandler_1_Windows_Media_Transcoding_TranscodeFailureReason }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::media::VideoFrame> => [0x6086f2fb,0x4a29,0x54ca,0xb6,0xa3,0xf2,0x39,0x1a,0x03,0xbc,0x3b] as IID_AsyncOperationCompletedHandler_1_Windows_Media_VideoFrame }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::backgroundtransfer::DownloadOperation> => [0x2aa63857,0xffaf,0x5cf6,0x9b,0x2c,0x0d,0xc5,0x97,0xb6,0x0a,0x60] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::backgroundtransfer::UnconstrainedTransferRequestResult> => [0x4f52bfe8,0x9b0e,0x5b22,0x91,0x6b,0x83,0x44,0x25,0xb4,0xab,0x97] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_BackgroundTransfer_UnconstrainedTransferRequestResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::backgroundtransfer::UploadOperation> => [0xead68818,0x0c38,0x5cde,0xae,0xc1,0xc6,0xa7,0x61,0x87,0x11,0xf7] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::connectivity::ConnectionProfile> => [0xe4f0c96a,0x0571,0x59f4,0xa9,0xa9,0xaf,0xac,0x3e,0x61,0xca,0xa0] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_Connectivity_ConnectionProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::connectivity::ConnectionSession> => [0x3bc680d8,0x9e83,0x5086,0x8f,0x49,0x7a,0x29,0xbf,0xb1,0xc7,0xe1] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_Connectivity_ConnectionSession }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::connectivity::ProxyConfiguration> => [0x035b2567,0xefb9,0x5bc3,0xb6,0x09,0xf9,0xa8,0xc2,0x0b,0x70,0x01] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_Connectivity_ProxyConfiguration }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::HotspotCredentialsAuthenticationResult> => [0x7f254beb,0x471f,0x5000,0x94,0xce,0x10,0x2c,0xc3,0x33,0x05,0x5f] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_HotspotCredentialsAuthenticationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandCellsInfo> => [0x98f9a3f7,0x92a2,0x5431,0x90,0x2f,0x9b,0xf0,0x10,0x67,0xab,0x60] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandCellsInfo }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandDeviceServiceCommandResult> => [0x21f0ce4f,0x8f33,0x5e71,0xa4,0x57,0xdd,0xa5,0x53,0xb0,0xd6,0xbb] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandDeviceServiceCommandResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandModemConfiguration> => [0xc11e0649,0x8237,0x5c93,0xbb,0xdb,0x2e,0xda,0x52,0x16,0xfd,0x3f] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandModemConfiguration }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandModemStatus> => [0xb8628318,0xee4f,0x5af4,0x9e,0x3b,0xaf,0x99,0x4f,0xa9,0x6c,0x51] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandModemStatus }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandPinOperationResult> => [0x595ad094,0x60e3,0x5349,0x8f,0xe6,0xea,0x8e,0xcb,0xbb,0x25,0x41] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandPinOperationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandUiccAppReadRecordResult> => [0xb81892b3,0x4ca9,0x5ec4,0x89,0x71,0x2f,0xbc,0x19,0xb5,0x6c,0xa9] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccAppReadRecordResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandUiccAppRecordDetailsResult> => [0xd0b53858,0x0e54,0x5791,0x82,0xed,0x33,0x13,0xdc,0x75,0xda,0x45] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccAppRecordDetailsResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::MobileBroadbandUiccAppsResult> => [0xa12bed56,0xc672,0x595e,0xa6,0x7b,0x49,0xab,0xc2,0x85,0xad,0xdc] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccAppsResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::NetworkOperatorTetheringOperationResult> => [0xa936b927,0x7537,0x59c6,0x89,0xde,0x33,0xf3,0x6a,0x97,0x25,0xab] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_NetworkOperatorTetheringOperationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::ProvisionFromXmlDocumentResults> => [0x7a7eee1b,0x17f9,0x5a41,0x86,0x1b,0xc3,0x0e,0xa1,0x27,0xd0,0xf1] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_ProvisionFromXmlDocumentResults }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::networkoperators::UssdReply> => [0x9385bd8f,0x5e14,0x557a,0xa7,0xf1,0x63,0xf3,0x3d,0x9e,0xca,0xcf] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_NetworkOperators_UssdReply }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::pushnotifications::PushNotificationChannel> => [0xcf7c902f,0x0f0d,0x5b22,0x90,0xb1,0x85,0x14,0x1b,0x58,0x16,0xcd] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_PushNotifications_PushNotificationChannel }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::servicediscovery::dnssd::DnssdRegistrationResult> => [0xf3632f52,0x894a,0x5345,0x9b,0xe6,0x83,0x89,0x75,0x1c,0x51,0x89] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_ServiceDiscovery_Dnssd_DnssdRegistrationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::sockets::StreamSocket> => [0x71b5d99e,0x3854,0x5e9a,0xb4,0xdc,0xd1,0xb5,0x8b,0xf1,0x98,0xfc] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_Sockets_StreamSocket }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::vpn::VpnCredential> => [0x1c9c4504,0x4b75,0x57ea,0x83,0x7d,0x53,0x38,0x35,0x8b,0xb7,0x62] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_Vpn_VpnCredential }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::vpn::VpnManagementErrorStatus> => [0x31229f8c,0x709d,0x5017,0x86,0x29,0x57,0xef,0x12,0x89,0xe6,0x16] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_Vpn_VpnManagementErrorStatus }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::networking::xboxlive::XboxLiveEndpointPairCreationResult> => [0xad57fa1d,0xdb1b,0x5df5,0x96,0x94,0xf7,0x1b,0x9b,0xd5,0x62,0x5b] as IID_AsyncOperationCompletedHandler_1_Windows_Networking_XboxLive_XboxLiveEndpointPairCreationResult }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::perception::spatial::SpatialAnchorStore> => [0x84c21a3a,0x037a,0x503f,0x80,0x06,0xab,0x57,0x7b,0x7f,0x6f,0x66] as IID_AsyncOperationCompletedHandler_1_Windows_Perception_Spatial_SpatialAnchorStore }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::perception::spatial::SpatialPerceptionAccessStatus> => [0x6ced54c8,0x7689,0x525a,0x80,0xe1,0x95,0x6a,0x9d,0x85,0xcd,0x83] as IID_AsyncOperationCompletedHandler_1_Windows_Perception_Spatial_SpatialPerceptionAccessStatus }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::perception::spatial::SpatialStageFrameOfReference> => [0xfbb7e9fb,0xe49a,0x54e1,0x8c,0x83,0xd1,0xa8,0x7e,0x4d,0x23,0x04] as IID_AsyncOperationCompletedHandler_1_Windows_Perception_Spatial_SpatialStageFrameOfReference }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::perception::spatial::surfaces::SpatialSurfaceMesh> => [0x4680f7f6,0x44c5,0x5fc6,0x8d,0x51,0xd6,0x96,0x29,0x15,0xfa,0x23] as IID_AsyncOperationCompletedHandler_1_Windows_Perception_Spatial_Surfaces_SpatialSurfaceMesh }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::core::MicrosoftAccountMultiFactorGetSessionsResult> => [0xcecbb0ca,0x0a27,0x57d4,0xa3,0x5d,0x49,0x98,0xf1,0x99,0xda,0xc9] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorGetSessionsResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::core::MicrosoftAccountMultiFactorOneTimeCodedInfo> => [0x02e84540,0xf4a1,0x589f,0x93,0x60,0xa0,0x50,0x2e,0x6d,0xc9,0xc0] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorOneTimeCodedInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::core::MicrosoftAccountMultiFactorServiceResponse> => [0x8d7f8240,0x81cf,0x5896,0x95,0xfa,0xe7,0xb2,0x23,0xf7,0x69,0xf9] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorServiceResponse }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::core::MicrosoftAccountMultiFactorUnregisteredAccountsAndSessionInfo> => [0x6cc53e8c,0xd0e4,0x5ded,0x94,0xf4,0x7c,0x73,0xb1,0x32,0xd2,0xa4] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorUnregisteredAccountsAndSessionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::provider::SecondaryAuthenticationFactorAuthenticationResult> => [0x2547373d,0x9684,0x5e5b,0xa9,0xb8,0xa6,0xf9,0x0c,0xe6,0x32,0xad] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorAuthenticationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::provider::SecondaryAuthenticationFactorAuthenticationStageInfo> => [0x7811d384,0x2eb8,0x58f1,0xaf,0xed,0x4b,0x4b,0x88,0x8f,0x43,0x57] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorAuthenticationStageInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::provider::SecondaryAuthenticationFactorDevicePresenceMonitoringRegistrationStatus> => [0x2294a212,0x9061,0x5e99,0xa2,0x26,0xa4,0x4a,0xc8,0xf8,0xf4,0xdd] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorDevicePresenceMonitoringRegistrationStatus }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::provider::SecondaryAuthenticationFactorFinishAuthenticationStatus> => [0xae1d7146,0x3d91,0x50e3,0x8f,0x13,0x61,0x3c,0xf2,0x80,0x12,0x07] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorFinishAuthenticationStatus }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::identity::provider::SecondaryAuthenticationFactorRegistrationResult> => [0xa04902e8,0xf830,0x50ea,0x89,0xea,0x96,0xe2,0xa6,0xfb,0x94,0x53] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorRegistrationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::onlineid::OnlineIdSystemTicketResult> => [0x05f9f2ec,0x5950,0x56f8,0xb7,0xf8,0x22,0xe2,0x0b,0x98,0x46,0x79] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_OnlineId_OnlineIdSystemTicketResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::onlineid::UserIdentity> => [0xcded76fd,0x7841,0x52a0,0xa7,0x71,0x76,0xcd,0x75,0x1d,0x13,0xcd] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_OnlineId_UserIdentity }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::web::core::WebTokenRequestResult> => [0xdeb54b22,0x70f2,0x55ab,0x97,0xc0,0x6c,0xbd,0xc5,0xdd,0xb6,0xf0] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Web_Core_WebTokenRequestResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::authentication::web::WebAuthenticationResult> => [0x3c1ec44c,0xe942,0x54e5,0xbc,0xd3,0xe3,0x29,0xc9,0x51,0xf5,0x95] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Authentication_Web_WebAuthenticationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::KeyCredentialAttestationResult> => [0x2c16e103,0xf783,0x5dd9,0xa5,0xf3,0x33,0x62,0xbc,0xbd,0xaa,0xbd] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_KeyCredentialAttestationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::KeyCredentialOperationResult> => [0x39b4609a,0x0202,0x55fa,0x80,0x05,0x6f,0x83,0x70,0x9e,0x20,0xf3] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_KeyCredentialOperationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::KeyCredentialRetrievalResult> => [0x03ea60b1,0xa874,0x58ce,0x8e,0x8e,0xff,0xf4,0x48,0xb6,0x73,0x3e] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_KeyCredentialRetrievalResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::ui::CredentialPickerResults> => [0x091a96b8,0x52a6,0x523a,0x8c,0x94,0x7f,0x9c,0x11,0xc6,0xda,0xe5] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_UI_CredentialPickerResults }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::ui::UserConsentVerificationResult> => [0x0cffc6c9,0x4c2b,0x5cd4,0xb3,0x8c,0x7b,0x8d,0xf3,0xff,0x5a,0xfb] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_UI_UserConsentVerificationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::ui::UserConsentVerifierAvailability> => [0x28988174,0xace2,0x5c15,0xa0,0xdf,0x58,0x0a,0x26,0xd9,0x42,0x94] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_UI_UserConsentVerifierAvailability }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::WebAccount> => [0x4bd6f1e5,0xca89,0x5240,0x8f,0x3d,0x7f,0x1b,0x54,0xae,0x90,0xa7] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_WebAccount }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::credentials::WebAccountProvider> => [0x9477622b,0x1340,0x5574,0x81,0xfc,0x50,0x13,0x58,0x1f,0x57,0xc9] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Credentials_WebAccountProvider }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::cryptography::certificates::CertificateChain> => [0x4c3f50e9,0x90e3,0x5a30,0x90,0x15,0x4a,0xa0,0x37,0x69,0x04,0xf3] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Cryptography_Certificates_CertificateChain }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::cryptography::certificates::SignatureValidationResult> => [0xdff50005,0x78ad,0x5f4f,0xa0,0x85,0xcb,0x61,0x4a,0x67,0x4a,0x25] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Cryptography_Certificates_SignatureValidationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::cryptography::core::CryptographicKey> => [0x04ca4378,0xf594,0x5de6,0xa5,0x55,0x30,0x4f,0x62,0xcb,0x4f,0xaf] as IID_AsyncOperationCompletedHandler_1_Windows_Security_Cryptography_Core_CryptographicKey }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::BufferProtectUnprotectResult> => [0x73d780cb,0xad38,0x59e6,0xa2,0x36,0xcc,0x0d,0xf6,0x9f,0x15,0xa8] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_BufferProtectUnprotectResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::DataProtectionInfo> => [0xe12bb475,0x3f2b,0x51c9,0x83,0xc6,0xa5,0x66,0x10,0x86,0xb6,0xc3] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_DataProtectionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::FileProtectionInfo> => [0x2918ffea,0xe091,0x53e2,0xbd,0xe5,0x61,0x7c,0x9b,0xb3,0xd8,0xfe] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_FileProtectionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::FileProtectionStatus> => [0xe104f25b,0xb957,0x5ed4,0xb1,0xc5,0x19,0x93,0x60,0x4c,0xfe,0xae] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_FileProtectionStatus }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::ProtectedContainerExportResult> => [0x560c5521,0x5008,0x5272,0xa7,0x66,0x94,0x1f,0x70,0x71,0x8b,0xc6] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_ProtectedContainerExportResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::ProtectedContainerImportResult> => [0xcfea00f8,0xd2ad,0x5ad2,0xa3,0x96,0xe4,0xf7,0x1b,0x9a,0x7c,0x3f] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_ProtectedContainerImportResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::ProtectedFileCreateResult> => [0x6c44a868,0x7c80,0x5187,0xa0,0x8d,0x37,0x9b,0xe4,0x19,0x09,0xf6] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_ProtectedFileCreateResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::enterprisedata::ProtectionPolicyEvaluationResult> => [0x2833ba54,0xa4e1,0x5c2d,0x8a,0x7a,0x13,0x6e,0x85,0x10,0xc7,0x8b] as IID_AsyncOperationCompletedHandler_1_Windows_Security_EnterpriseData_ProtectionPolicyEvaluationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::security::exchangeactivesyncprovisioning::EasComplianceResults> => [0x24a4131a,0xed31,0x5eff,0x97,0x2e,0x75,0x0b,0x95,0x64,0x04,0xd0] as IID_AsyncOperationCompletedHandler_1_Windows_Security_ExchangeActiveSyncProvisioning_EasComplianceResults }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::cortana::CortanaPermissionsChangeResult> => [0xec1c6586,0x5e0d,0x5bc0,0xb8,0x4f,0x20,0x05,0x2c,0x5a,0xc7,0xa9] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Cortana_CortanaPermissionsChangeResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::maps::localsearch::LocalLocationFinderResult> => [0x7b4a1b93,0x2943,0x5e50,0xa0,0x10,0xee,0x9a,0xec,0x1b,0xbf,0xe7] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Maps_LocalSearch_LocalLocationFinderResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::maps::MapLocationFinderResult> => [0x26ceeb11,0x1221,0x5c2b,0xbb,0xf9,0xcf,0xea,0x36,0x63,0xc2,0xed] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Maps_MapLocationFinderResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::maps::MapRouteFinderResult> => [0x6e7a2b4f,0x811c,0x54c3,0x89,0x38,0x67,0x95,0xf4,0xe6,0x70,0x09] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Maps_MapRouteFinderResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::maps::offlinemaps::OfflineMapPackageQueryResult> => [0x8a4df3c9,0x2595,0x5bec,0x8b,0xa1,0xc1,0xd9,0x55,0xf1,0x68,0xc0] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Maps_OfflineMaps_OfflineMapPackageQueryResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::maps::offlinemaps::OfflineMapPackageStartDownloadResult> => [0x8654a79e,0xc52f,0x5f98,0xaf,0x0a,0x52,0x24,0x66,0xc2,0x72,0x46] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Maps_OfflineMaps_OfflineMapPackageStartDownloadResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreAcquireLicenseResult> => [0x6987c97c,0x2c19,0x5f44,0xb5,0xac,0x37,0x39,0x3f,0x3c,0x1a,0x4a] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreAcquireLicenseResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreAppLicense> => [0xceff1e09,0xe506,0x50ad,0xa9,0x08,0x52,0x03,0x8c,0x25,0x65,0x52] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreAppLicense }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreConsumableResult> => [0x3f2bb178,0x3c4e,0x56ed,0x86,0xa5,0xad,0x13,0x79,0x7c,0xfb,0xfd] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreConsumableResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreProductPagedQueryResult> => [0xe786321f,0xb791,0x5e38,0x8b,0xc4,0x98,0xcb,0x28,0x7d,0x10,0x85] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreProductPagedQueryResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreProductQueryResult> => [0x02f4a42c,0x0458,0x58d6,0x92,0x3c,0xb4,0x4b,0xa8,0xef,0x22,0x22] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreProductQueryResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreProductResult> => [0xeb93e936,0xd515,0x5414,0x9d,0x15,0xf0,0x50,0xc0,0xb8,0xf5,0x21] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreProductResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StorePurchaseResult> => [0x1d9f89ee,0x2fce,0x54e6,0xa0,0xa9,0x52,0xd0,0x0c,0x52,0xcc,0x3a] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StorePurchaseResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::store::StoreSendRequestResult> => [0x7800b2a3,0xbbbc,0x5a11,0x8c,0x35,0xd2,0xbd,0xe5,0x48,0x9e,0x81] as IID_AsyncOperationCompletedHandler_1_Windows_Services_Store_StoreSendRequestResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::targetedcontent::TargetedContentContainer> => [0x8fc6bc2a,0x26ce,0x50b5,0x97,0xbb,0xfc,0xc8,0x0c,0xa0,0x87,0x1d] as IID_AsyncOperationCompletedHandler_1_Windows_Services_TargetedContent_TargetedContentContainer }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::services::targetedcontent::TargetedContentSubscription> => [0xe4188c71,0x5a8e,0x57ec,0xb0,0xde,0x1d,0x31,0x4f,0xb3,0xe2,0xcf] as IID_AsyncOperationCompletedHandler_1_Windows_Services_TargetedContent_TargetedContentSubscription }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::ApplicationData> => [0xabafe590,0x65fe,0x520a,0x9d,0x7c,0x6a,0xb5,0xf1,0x88,0x22,0x37] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_ApplicationData }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::fileproperties::BasicProperties> => [0xc8659aae,0x4926,0x52ad,0x8f,0x60,0xd8,0x9f,0xe5,0xa8,0xdf,0x5f] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_FileProperties_BasicProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::fileproperties::DocumentProperties> => [0x4452ed4c,0x642b,0x501b,0x96,0x17,0x7d,0x68,0xb4,0xac,0x3c,0x66] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_FileProperties_DocumentProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::fileproperties::ImageProperties> => [0xc63729bc,0xe4c3,0x564c,0xb1,0x37,0x2c,0xb4,0xf5,0x96,0x6a,0x83] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_FileProperties_ImageProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::fileproperties::MusicProperties> => [0xd84e1312,0xd661,0x5b7f,0x95,0x66,0x74,0x21,0xbd,0xed,0xc1,0xea] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_FileProperties_MusicProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::fileproperties::StorageItemThumbnail> => [0x6d0036f2,0xa8a8,0x505d,0xb0,0x42,0xd0,0x87,0xdc,0x1f,0xc1,0xb7] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_FileProperties_StorageItemThumbnail }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::fileproperties::VideoProperties> => [0x43401d34,0x61ab,0x5cf2,0x92,0x1f,0x55,0xb6,0x16,0x63,0x1d,0x1d] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_FileProperties_VideoProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::IStorageItem> => [0x92c3102f,0xa327,0x5318,0xa6,0xc1,0x76,0xf6,0xb2,0xa0,0xab,0xfb] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_IStorageItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::provider::FileUpdateStatus> => [0xbb185a07,0x0285,0x5f37,0x9c,0x7d,0x2f,0xc6,0xa3,0xe0,0xe6,0xe5] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Provider_FileUpdateStatus }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::search::IndexedState> => [0xb67a3cba,0xf5f7,0x5e51,0x96,0x8a,0x38,0x51,0x26,0xd1,0xf9,0x18] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Search_IndexedState }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::StorageFile> => [0xe521c894,0x2c26,0x5946,0x9e,0x61,0x2b,0x5e,0x18,0x8d,0x01,0xed] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_StorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::StorageFolder> => [0xc211026e,0x9e63,0x5452,0xba,0x54,0x3a,0x07,0xd6,0xa9,0x68,0x74] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_StorageFolder }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::StorageLibrary> => [0x36d560c3,0x731f,0x5c70,0xb9,0x07,0x30,0xbc,0x99,0xbc,0x30,0x0f] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_StorageLibrary }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::StorageStreamTransaction> => [0xd11739e6,0x2995,0x5d33,0xbf,0xff,0x51,0xb6,0x04,0x1f,0x68,0xc1] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_StorageStreamTransaction }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::IBuffer> => [0x51c3d2fd,0xb8a1,0x5620,0xb7,0x46,0x7e,0xe6,0xd5,0x33,0xac,0xa3] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_IBuffer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::IInputStream> => [0xd0bd0125,0x9049,0x57a3,0xbd,0x66,0xe2,0x52,0x5d,0x98,0xc8,0x14] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_IInputStream }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::IOutputStream> => [0xbcb37f4f,0x3af4,0x561c,0xa9,0xe3,0xee,0xf1,0x73,0x84,0x94,0xd7] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_IOutputStream }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::IRandomAccessStream> => [0x398c4183,0x793d,0x5b00,0x81,0x9b,0x4a,0xef,0x92,0x48,0x5e,0x94] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_IRandomAccessStream }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::IRandomAccessStreamReference> => [0x60847289,0xea0b,0x5df6,0x89,0xdf,0xf2,0xc6,0x2c,0xba,0x96,0x93] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_IRandomAccessStreamReference }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::IRandomAccessStreamWithContentType> => [0x3dddecf4,0x1d39,0x58e8,0x83,0xb1,0xdb,0xed,0x54,0x1c,0x7f,0x35] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_IRandomAccessStreamWithContentType }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::storage::streams::RandomAccessStreamReference> => [0x3d203732,0xded7,0x5d32,0x87,0xe6,0xc1,0x79,0x78,0x1f,0x79,0x1f] as IID_AsyncOperationCompletedHandler_1_Windows_Storage_Streams_RandomAccessStreamReference }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::DiagnosticAccessStatus> => [0x5d1302d7,0x5497,0x5a92,0xbf,0x43,0xeb,0x8b,0x50,0x67,0x9a,0xab] as IID_AsyncOperationCompletedHandler_1_Windows_System_DiagnosticAccessStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::LaunchQuerySupportStatus> => [0x198cac52,0xabcd,0x5529,0x93,0x3f,0x07,0x1c,0xc9,0x3f,0xd6,0x35] as IID_AsyncOperationCompletedHandler_1_Windows_System_LaunchQuerySupportStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::LaunchUriResult> => [0x70a97bf8,0xe0a5,0x59bb,0x91,0x74,0x81,0x2a,0x13,0x1d,0x85,0xa0] as IID_AsyncOperationCompletedHandler_1_Windows_System_LaunchUriResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::LaunchUriStatus> => [0x520aa58e,0x40d6,0x5a57,0xa6,0xdc,0xcb,0x5f,0xae,0xa5,0xcc,0xa5] as IID_AsyncOperationCompletedHandler_1_Windows_System_LaunchUriStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::ProcessLauncherResult> => [0x8d787ee6,0x07e4,0x5dce,0x8f,0xe5,0xb5,0x03,0xa1,0xf6,0x36,0x8c] as IID_AsyncOperationCompletedHandler_1_Windows_System_ProcessLauncherResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::RemoteLaunchUriStatus> => [0x3f8f4b1b,0xcd54,0x543c,0x81,0x7f,0x26,0x30,0x48,0x7f,0x18,0x78] as IID_AsyncOperationCompletedHandler_1_Windows_System_RemoteLaunchUriStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::remotesystems::RemoteSystem> => [0x3a0b522d,0x98d0,0x5d34,0xac,0xe6,0x2c,0x73,0x46,0x61,0x3f,0x1d] as IID_AsyncOperationCompletedHandler_1_Windows_System_RemoteSystems_RemoteSystem }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::remotesystems::RemoteSystemAccessStatus> => [0x543a221d,0xef39,0x57f5,0x97,0x41,0xb0,0x52,0xdb,0xc2,0x92,0x49] as IID_AsyncOperationCompletedHandler_1_Windows_System_RemoteSystems_RemoteSystemAccessStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::remotesystems::RemoteSystemSessionCreationResult> => [0x6e72c549,0x73aa,0x5168,0x85,0x60,0xc7,0x23,0x64,0x93,0xb5,0x04] as IID_AsyncOperationCompletedHandler_1_Windows_System_RemoteSystems_RemoteSystemSessionCreationResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::remotesystems::RemoteSystemSessionJoinResult> => [0x379adf35,0x4cb4,0x522f,0x91,0xbe,0x91,0x3b,0x56,0x90,0x56,0x8f] as IID_AsyncOperationCompletedHandler_1_Windows_System_RemoteSystems_RemoteSystemSessionJoinResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::User> => [0xf913e3a2,0xd1c5,0x5308,0xbe,0xcf,0x4c,0x2d,0x81,0x67,0x82,0x4a] as IID_AsyncOperationCompletedHandler_1_Windows_System_User }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::userprofile::SetAccountPictureResult> => [0x603f3e31,0x7a51,0x518c,0x92,0x80,0xc1,0x88,0xea,0x42,0x13,0xd8] as IID_AsyncOperationCompletedHandler_1_Windows_System_UserProfile_SetAccountPictureResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::system::userprofile::SetImageFeedResult> => [0xf214731a,0x1305,0x5b44,0x93,0x2c,0xaf,0x9a,0x1e,0x4d,0x78,0xc9] as IID_AsyncOperationCompletedHandler_1_Windows_System_UserProfile_SetImageFeedResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::input::inking::analysis::InkAnalysisResult> => [0xa7ef2666,0x6fc4,0x568f,0xbb,0xf3,0x19,0xc1,0x03,0x6a,0x26,0xbf] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Input_Inking_Analysis_InkAnalysisResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::notifications::management::UserNotificationListenerAccessStatus> => [0xf09e843a,0x13cb,0x559b,0xa9,0xfc,0x01,0x57,0x22,0xc2,0xcd,0x57] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Notifications_Management_UserNotificationListenerAccessStatus }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::notifications::ToastCollection> => [0x8d44ca1e,0x15d7,0x5bcb,0xb0,0x02,0x38,0x4c,0x87,0x17,0x1c,0x74] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Notifications_ToastCollection }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::notifications::ToastNotificationHistory> => [0xc661d5da,0x6762,0x5d93,0x91,0x38,0xe7,0xda,0xcd,0x57,0x10,0x56] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Notifications_ToastNotificationHistory }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::notifications::ToastNotifier> => [0xfde26ed7,0xbc37,0x5a7c,0xb3,0xda,0x3e,0x41,0xac,0x97,0xbb,0xa4] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Notifications_ToastNotifier }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::popups::IUICommand> => [0xdd33fd5b,0xa24d,0x5a44,0x91,0xfe,0xdd,0x64,0x41,0x77,0x01,0x03] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Popups_IUICommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::startscreen::JumpList> => [0x3c047c6a,0xc55b,0x5485,0xb6,0x73,0x8d,0x4b,0xd7,0xc3,0x42,0xe2] as IID_AsyncOperationCompletedHandler_1_Windows_UI_StartScreen_JumpList }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::xaml::controls::ContentDialogResult> => [0x45c7a306,0xe330,0x54d6,0xa9,0xba,0x61,0xc9,0x1f,0x93,0xf5,0x3b] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Xaml_Controls_ContentDialogResult }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::xaml::controls::maps::MapModel3D> => [0x60ef194b,0xdbe0,0x5911,0xb7,0x25,0xec,0xc5,0xde,0x29,0x87,0x82] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Xaml_Controls_Maps_MapModel3D }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::xaml::controls::maps::StreetsidePanorama> => [0xf6f3b17c,0x4527,0x5528,0x86,0xaa,0x1c,0xf1,0xfb,0x78,0xa5,0xeb] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Xaml_Controls_Maps_StreetsidePanorama }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::xaml::data::LoadMoreItemsResult> => [0x10fb738b,0xa63b,0x506e,0x9e,0xd7,0x2e,0xab,0x37,0x91,0x52,0x21] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Xaml_Data_LoadMoreItemsResult }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::xaml::hosting::DesignerAppView> => [0xaeeb272e,0xa814,0x5981,0xa2,0xc3,0x62,0x3e,0x22,0x6e,0x4a,0x71] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Xaml_Hosting_DesignerAppView }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for AsyncOperationCompletedHandler<super::ui::xaml::media::imaging::SvgImageSourceLoadStatus> => [0x7c8bc668,0x4e0b,0x5924,0xb7,0xe7,0x23,0x4a,0x11,0xd6,0x3d,0x61] as IID_AsyncOperationCompletedHandler_1_Windows_UI_Xaml_Media_Imaging_SvgImageSourceLoadStatus }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<u32> => [0x9343b6e7,0xe3d2,0x5e4a,0xab,0x2d,0x2b,0xce,0x49,0x19,0xa6,0xa4] as IID_AsyncOperationCompletedHandler_1_System_UInt32 }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<u64> => [0xee8aeb02,0xfb00,0x51fa,0x8f,0x57,0x32,0x58,0x3e,0xa2,0x41,0xf9] as IID_AsyncOperationCompletedHandler_1_System_UInt64 }
RT_PINTERFACE!{ for AsyncOperationCompletedHandler<Uri> => [0xad46f1cc,0x2bb0,0x585c,0x98,0x85,0x03,0xc2,0x78,0x0d,0x4d,0x58] as IID_AsyncOperationCompletedHandler_1_Windows_Foundation_Uri }
RT_PINTERFACE!{ for AsyncOperationProgressHandler<bool, f64> => [0xcadf3784,0x1200,0x5633,0x82,0x80,0x16,0x38,0x49,0x91,0x4a,0xb3] as IID_AsyncOperationProgressHandler_2_System_Boolean_System_Double }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<collections::IVectorView<super::devices::sms::ISmsMessage>, i32> => [0x3f9d1255,0xebf8,0x569f,0x91,0xc3,0x49,0x74,0x0d,0x59,0x44,0xce] as IID_AsyncOperationProgressHandler_2_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sms_ISmsMessage__System_Int32 }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<HString, super::web::http::HttpProgress> => [0xcf0a03f6,0xa80a,0x5b46,0x9c,0x80,0xf4,0xad,0x9e,0xd6,0xe2,0xd6] as IID_AsyncOperationProgressHandler_2_System_String_Windows_Web_Http_HttpProgress }
RT_PINTERFACE!{ for AsyncOperationProgressHandler<HString, u64> => [0x14da7de7,0x40df,0x5d4c,0x82,0x3f,0xcf,0x31,0x06,0x25,0xad,0x39] as IID_AsyncOperationProgressHandler_2_System_String_System_UInt64 }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::devices::scanners::ImageScannerScanResult, u32> => [0xd1662baa,0x4f20,0x5d18,0x97,0xf1,0xa0,0x1a,0x6d,0x0d,0xd9,0x80] as IID_AsyncOperationProgressHandler_2_Windows_Devices_Scanners_ImageScannerScanResult_System_UInt32 }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::gaming::input::custom::GipFirmwareUpdateResult, super::gaming::input::custom::GipFirmwareUpdateProgress> => [0x065c16af,0x49dc,0x5c94,0xaf,0xe2,0x93,0x85,0x93,0x7f,0xac,0xc9] as IID_AsyncOperationProgressHandler_2_Windows_Gaming_Input_Custom_GipFirmwareUpdateResult_Windows_Gaming_Input_Custom_GipFirmwareUpdateProgress }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::management::deployment::DeploymentResult, super::management::deployment::DeploymentProgress> => [0xf1b926d1,0x1796,0x597a,0x9b,0xea,0x6c,0x64,0x49,0xd0,0x3e,0xef] as IID_AsyncOperationProgressHandler_2_Windows_Management_Deployment_DeploymentResult_Windows_Management_Deployment_DeploymentProgress }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::media::core::LowLightFusionResult, f64> => [0x79337bbf,0x7b7f,0x5f88,0xa2,0xea,0x8d,0xf1,0x4a,0xe3,0x1d,0xe4] as IID_AsyncOperationProgressHandler_2_Windows_Media_Core_LowLightFusionResult_System_Double }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::media::import::PhotoImportDeleteImportedItemsFromSourceResult, f64> => [0xac6e425d,0x49e8,0x50d7,0x98,0x8c,0xcd,0x5e,0x42,0x03,0x85,0x77] as IID_AsyncOperationProgressHandler_2_Windows_Media_Import_PhotoImportDeleteImportedItemsFromSourceResult_System_Double }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::media::import::PhotoImportFindItemsResult, u32> => [0x91190f62,0x7956,0x5e8f,0x83,0xf1,0x84,0xf9,0xfe,0x01,0x1b,0x21] as IID_AsyncOperationProgressHandler_2_Windows_Media_Import_PhotoImportFindItemsResult_System_UInt32 }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::media::import::PhotoImportImportItemsResult, super::media::import::PhotoImportProgress> => [0xacd8a978,0xb2e1,0x55d0,0xbb,0xf6,0x8d,0xc5,0x08,0x8d,0x72,0x8a] as IID_AsyncOperationProgressHandler_2_Windows_Media_Import_PhotoImportImportItemsResult_Windows_Media_Import_PhotoImportProgress }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::media::protection::RenewalStatus, u32> => [0xb9da4aa0,0x26e0,0x5d69,0xa0,0xc8,0x05,0x71,0x6a,0x40,0x62,0x35] as IID_AsyncOperationProgressHandler_2_Windows_Media_Protection_RenewalStatus_System_UInt32 }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::media::transcoding::TranscodeFailureReason, f64> => [0x009c6245,0x0e59,0x53b0,0x9f,0xd2,0xd2,0x50,0xe4,0x5a,0x00,0xa3] as IID_AsyncOperationProgressHandler_2_Windows_Media_Transcoding_TranscodeFailureReason_System_Double }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::networking::backgroundtransfer::DownloadOperation, super::networking::backgroundtransfer::DownloadOperation> => [0xb2ff13f1,0xc743,0x54f4,0xbc,0xcc,0xf0,0x8e,0x16,0xa8,0x78,0x90] as IID_AsyncOperationProgressHandler_2_Windows_Networking_BackgroundTransfer_DownloadOperation_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::networking::backgroundtransfer::UploadOperation, super::networking::backgroundtransfer::UploadOperation> => [0xccd13730,0xfed3,0x54e8,0x84,0x71,0x09,0x6e,0x4b,0x64,0xca,0xdd] as IID_AsyncOperationProgressHandler_2_Windows_Networking_BackgroundTransfer_UploadOperation_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::services::store::StorePackageUpdateResult, super::services::store::StorePackageUpdateStatus> => [0x961260f1,0x7352,0x5edf,0x96,0x66,0x1f,0x9a,0x0a,0x8e,0xe4,0x77] as IID_AsyncOperationProgressHandler_2_Windows_Services_Store_StorePackageUpdateResult_Windows_Services_Store_StorePackageUpdateStatus }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::storage::streams::IBuffer, super::web::http::HttpProgress> => [0x9eb2b852,0xe019,0x5440,0x8f,0x88,0x0d,0xd7,0xd5,0x6f,0xea,0x47] as IID_AsyncOperationProgressHandler_2_Windows_Storage_Streams_IBuffer_Windows_Web_Http_HttpProgress }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::storage::streams::IBuffer, u32> => [0xbf666554,0x7605,0x5d9a,0xb1,0x4e,0x18,0xd8,0xc8,0x47,0x2a,0xfe] as IID_AsyncOperationProgressHandler_2_Windows_Storage_Streams_IBuffer_System_UInt32 }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::storage::streams::IBuffer, u64> => [0xd17f5eb6,0xb422,0x5e26,0xa8,0x17,0x7e,0x0f,0xd0,0x8f,0x75,0xd5] as IID_AsyncOperationProgressHandler_2_Windows_Storage_Streams_IBuffer_System_UInt64 }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::storage::streams::IInputStream, super::web::http::HttpProgress> => [0x04682e89,0x6e8b,0x54b1,0xa4,0x66,0x43,0x2e,0x13,0x0c,0xf9,0xa6] as IID_AsyncOperationProgressHandler_2_Windows_Storage_Streams_IInputStream_Windows_Web_Http_HttpProgress }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::storage::streams::IInputStream, super::web::syndication::RetrievalProgress> => [0x6136b327,0x4152,0x54e3,0xaa,0x34,0x38,0xa0,0xc1,0x21,0xdc,0x4d] as IID_AsyncOperationProgressHandler_2_Windows_Storage_Streams_IInputStream_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::storage::streams::IInputStream, u64> => [0xf9b2e7f6,0x762f,0x50db,0x95,0xdd,0x7f,0x6c,0x6e,0xc4,0x70,0x90] as IID_AsyncOperationProgressHandler_2_Windows_Storage_Streams_IInputStream_System_UInt64 }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::system::diagnostics::DiagnosticActionResult, super::system::diagnostics::DiagnosticActionState> => [0xa0422898,0xb50a,0x52e3,0xb4,0x61,0x53,0x98,0x93,0x08,0xbe,0x12] as IID_AsyncOperationProgressHandler_2_Windows_System_Diagnostics_DiagnosticActionResult_Windows_System_Diagnostics_DiagnosticActionState }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::web::atompub::ServiceDocument, super::web::syndication::RetrievalProgress> => [0xdd2a6d54,0x55aa,0x5d09,0xb7,0x90,0x95,0x20,0xd4,0xeb,0x4f,0x19] as IID_AsyncOperationProgressHandler_2_Windows_Web_AtomPub_ServiceDocument_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::web::http::HttpResponseMessage, super::web::http::HttpProgress> => [0x68e4606a,0x76ec,0x5816,0xb2,0xfe,0xa0,0x4e,0xcd,0xe4,0x12,0x6a] as IID_AsyncOperationProgressHandler_2_Windows_Web_Http_HttpResponseMessage_Windows_Web_Http_HttpProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::web::syndication::SyndicationFeed, super::web::syndication::RetrievalProgress> => [0x1017bbe0,0x9d10,0x543e,0x8f,0x03,0x88,0x51,0x22,0xa0,0x82,0xf3] as IID_AsyncOperationProgressHandler_2_Windows_Web_Syndication_SyndicationFeed_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::web::syndication::SyndicationItem, super::web::syndication::RetrievalProgress> => [0xb670d335,0xe83b,0x58b1,0xad,0x7b,0x84,0x03,0x96,0x08,0x5c,0x65] as IID_AsyncOperationProgressHandler_2_Windows_Web_Syndication_SyndicationItem_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationProgressHandler<super::web::syndication::SyndicationItem, super::web::syndication::TransferProgress> => [0x1ffb57b2,0xd2de,0x5559,0x8d,0xe2,0x50,0x10,0x9c,0x63,0x53,0x9b] as IID_AsyncOperationProgressHandler_2_Windows_Web_Syndication_SyndicationItem_Windows_Web_Syndication_TransferProgress }
RT_PINTERFACE!{ for AsyncOperationProgressHandler<u32, u32> => [0xea0fe405,0xd432,0x5ac7,0x9e,0xf8,0x5a,0x65,0xe1,0xf9,0x7d,0x7e] as IID_AsyncOperationProgressHandler_2_System_UInt32_System_UInt32 }
RT_PINTERFACE!{ for AsyncOperationProgressHandler<u64, u64> => [0xffb2b65d,0x4120,0x5d13,0x82,0x6d,0x10,0x78,0x51,0xe6,0xbb,0x1c] as IID_AsyncOperationProgressHandler_2_System_UInt64_System_UInt64 }
RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<bool, f64> => [0x0ec5345b,0xb37a,0x5cd5,0x83,0xd7,0x95,0x90,0xcd,0xf4,0x45,0xb5] as IID_AsyncOperationWithProgressCompletedHandler_2_System_Boolean_System_Double }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<collections::IVectorView<super::devices::sms::ISmsMessage>, i32> => [0xc0454cfc,0x2f2f,0x5e0c,0x8d,0xe9,0x58,0xb9,0xe8,0x2a,0x03,0xba] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sms_ISmsMessage__System_Int32 }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<HString, super::web::http::HttpProgress> => [0x98ab9acb,0x38db,0x588f,0xa5,0xf9,0x9f,0x48,0x4b,0x22,0x00,0xcd] as IID_AsyncOperationWithProgressCompletedHandler_2_System_String_Windows_Web_Http_HttpProgress }
RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<HString, u64> => [0xbd75eebe,0xe7b5,0x5af6,0x84,0x15,0xa4,0xb9,0xc9,0x04,0x52,0x02] as IID_AsyncOperationWithProgressCompletedHandler_2_System_String_System_UInt64 }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::devices::scanners::ImageScannerScanResult, u32> => [0xbd8bdbd8,0x459a,0x52dc,0xb1,0x01,0x75,0xb3,0x98,0xa6,0x1a,0xef] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Devices_Scanners_ImageScannerScanResult_System_UInt32 }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::gaming::input::custom::GipFirmwareUpdateResult, super::gaming::input::custom::GipFirmwareUpdateProgress> => [0x61b95949,0xa027,0x51d8,0x9f,0x33,0x37,0x92,0x74,0x51,0x50,0x2b] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Gaming_Input_Custom_GipFirmwareUpdateResult_Windows_Gaming_Input_Custom_GipFirmwareUpdateProgress }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::management::deployment::DeploymentResult, super::management::deployment::DeploymentProgress> => [0x6e1c7129,0x61e0,0x5d88,0x9f,0xd4,0xf3,0xce,0x65,0xa0,0x57,0x19] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Management_Deployment_DeploymentResult_Windows_Management_Deployment_DeploymentProgress }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::media::core::LowLightFusionResult, f64> => [0x4a952fc2,0xefce,0x5275,0x90,0xd0,0x36,0x89,0xbe,0x26,0xf6,0x66] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Media_Core_LowLightFusionResult_System_Double }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::media::import::PhotoImportDeleteImportedItemsFromSourceResult, f64> => [0x5e24e7c1,0xf356,0x59c1,0xb0,0xe5,0xb2,0xdf,0xb2,0x25,0xeb,0x4e] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Media_Import_PhotoImportDeleteImportedItemsFromSourceResult_System_Double }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::media::import::PhotoImportFindItemsResult, u32> => [0xdd7a69d4,0x2456,0x5250,0x96,0x53,0x31,0xbd,0x2d,0x48,0x71,0x04] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Media_Import_PhotoImportFindItemsResult_System_UInt32 }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::media::import::PhotoImportImportItemsResult, super::media::import::PhotoImportProgress> => [0x0d141ec2,0xee90,0x53a0,0x93,0x18,0x10,0xf0,0xab,0x7f,0x2d,0x17] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Media_Import_PhotoImportImportItemsResult_Windows_Media_Import_PhotoImportProgress }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::media::protection::RenewalStatus, u32> => [0xec067827,0x67d9,0x59a6,0xa5,0x7b,0x3e,0x7c,0xa1,0x2b,0x89,0xc1] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Media_Protection_RenewalStatus_System_UInt32 }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::media::transcoding::TranscodeFailureReason, f64> => [0x080f1890,0x4fca,0x5165,0xa9,0x89,0x4b,0x07,0xda,0x8e,0x0b,0x53] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Media_Transcoding_TranscodeFailureReason_System_Double }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::networking::backgroundtransfer::DownloadOperation, super::networking::backgroundtransfer::DownloadOperation> => [0x781b479c,0x0207,0x5d15,0xa4,0xe5,0x78,0x37,0xd1,0x3b,0xf9,0x3d] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Networking_BackgroundTransfer_DownloadOperation_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::networking::backgroundtransfer::UploadOperation, super::networking::backgroundtransfer::UploadOperation> => [0x79fcae93,0x53ec,0x5f66,0xab,0x34,0x82,0x6a,0xf7,0x8e,0xc1,0x1a] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Networking_BackgroundTransfer_UploadOperation_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::services::store::StorePackageUpdateResult, super::services::store::StorePackageUpdateStatus> => [0xb3be0c8b,0xef1d,0x56dc,0x85,0x47,0x4d,0xa0,0x6e,0xa5,0x63,0xdf] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Services_Store_StorePackageUpdateResult_Windows_Services_Store_StorePackageUpdateStatus }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::storage::streams::IBuffer, super::web::http::HttpProgress> => [0xb0cf2f85,0x6992,0x52be,0x8f,0x0b,0x93,0x96,0x4b,0x14,0xd9,0x63] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Storage_Streams_IBuffer_Windows_Web_Http_HttpProgress }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::storage::streams::IBuffer, u32> => [0x06386a7a,0xe009,0x5b0b,0xab,0x68,0xa8,0xe4,0x8b,0x51,0x66,0x47] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Storage_Streams_IBuffer_System_UInt32 }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::storage::streams::IBuffer, u64> => [0xabc81235,0x39c7,0x59bf,0x99,0x48,0x2d,0x14,0xa9,0x3d,0x40,0xfd] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Storage_Streams_IBuffer_System_UInt64 }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::storage::streams::IInputStream, super::web::http::HttpProgress> => [0x504a34ec,0x5499,0x5a16,0xbf,0xfc,0x3c,0xcb,0x64,0xa3,0x54,0x7a] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Storage_Streams_IInputStream_Windows_Web_Http_HttpProgress }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::storage::streams::IInputStream, super::web::syndication::RetrievalProgress> => [0x76772ec1,0xc26f,0x5f6e,0x8d,0x3b,0x83,0x14,0x10,0x7c,0xef,0xeb] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Storage_Streams_IInputStream_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::storage::streams::IInputStream, u64> => [0x8db69706,0x3dd1,0x5a28,0x98,0x6a,0x93,0xbe,0x07,0x76,0xd9,0xc3] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Storage_Streams_IInputStream_System_UInt64 }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::system::diagnostics::DiagnosticActionResult, super::system::diagnostics::DiagnosticActionState> => [0x390b0091,0xcaf7,0x5b64,0x83,0x9d,0x49,0x90,0xae,0x7f,0x75,0x3c] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_System_Diagnostics_DiagnosticActionResult_Windows_System_Diagnostics_DiagnosticActionState }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::web::atompub::ServiceDocument, super::web::syndication::RetrievalProgress> => [0x5f03b1d3,0x470d,0x5be7,0x81,0x76,0x1c,0x9a,0x46,0x01,0x09,0x00] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Web_AtomPub_ServiceDocument_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::web::http::HttpResponseMessage, super::web::http::HttpProgress> => [0xbeadb572,0xf9a3,0x5e93,0xb6,0xca,0xe3,0x11,0xb6,0x59,0x33,0xfc] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Web_Http_HttpResponseMessage_Windows_Web_Http_HttpProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::web::syndication::SyndicationFeed, super::web::syndication::RetrievalProgress> => [0x0e3d7f70,0x4e8c,0x5260,0xa7,0xe5,0x78,0x6e,0x05,0xbd,0xed,0x99] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Web_Syndication_SyndicationFeed_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::web::syndication::SyndicationItem, super::web::syndication::RetrievalProgress> => [0x9de7422b,0x4bc3,0x5546,0x87,0xb8,0x2e,0xeb,0xfd,0x60,0xbe,0x48] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Web_Syndication_SyndicationItem_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<super::web::syndication::SyndicationItem, super::web::syndication::TransferProgress> => [0x8a796ea9,0xff95,0x50ef,0x93,0xea,0x71,0x1b,0xf7,0x94,0x64,0x73] as IID_AsyncOperationWithProgressCompletedHandler_2_Windows_Web_Syndication_SyndicationItem_Windows_Web_Syndication_TransferProgress }
RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<u32, u32> => [0x1e466dc5,0x840f,0x54f9,0xb8,0x77,0x5e,0x3a,0x9f,0x4b,0x6c,0x74] as IID_AsyncOperationWithProgressCompletedHandler_2_System_UInt32_System_UInt32 }
RT_PINTERFACE!{ for AsyncOperationWithProgressCompletedHandler<u64, u64> => [0xd2024e41,0x5500,0x5b5a,0xba,0x46,0xcb,0x70,0x09,0x59,0x6a,0x2f] as IID_AsyncOperationWithProgressCompletedHandler_2_System_UInt64_System_UInt64 }
RT_PINTERFACE!{ for EventHandler<diagnostics::TracingStatusChangedEventArgs> => [0x2bf27008,0x2eb4,0x5675,0xb1,0xcd,0xe9,0x90,0x6c,0xc5,0xce,0x64] as IID_EventHandler_1_Windows_Foundation_Diagnostics_TracingStatusChangedEventArgs }
RT_PINTERFACE!{ for EventHandler<IInspectable> => [0xc50898f6,0xc536,0x5f47,0x85,0x83,0x8b,0x2c,0x24,0x38,0xa1,0x3b] as IID_EventHandler_1_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for EventHandler<super::applicationmodel::activation::BackgroundActivatedEventArgs> => [0x49a07732,0xe7b8,0x5c5b,0x9d,0xe7,0x22,0xe3,0x3c,0xb9,0x70,0x04] as IID_EventHandler_1_Windows_ApplicationModel_Activation_BackgroundActivatedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for EventHandler<super::applicationmodel::core::UnhandledErrorDetectedEventArgs> => [0xf68bc421,0x6b54,0x559b,0x9c,0xdd,0x48,0x9a,0xad,0x0b,0xd4,0x1d] as IID_EventHandler_1_Windows_ApplicationModel_Core_UnhandledErrorDetectedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for EventHandler<super::applicationmodel::EnteredBackgroundEventArgs> => [0xe0739c32,0xfc14,0x5361,0xa8,0xb3,0x08,0x09,0x69,0x9f,0xbc,0xbd] as IID_EventHandler_1_Windows_ApplicationModel_EnteredBackgroundEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for EventHandler<super::applicationmodel::LeavingBackgroundEventArgs> => [0x9b6171c2,0xabb2,0x5194,0xaf,0xc0,0xce,0xf1,0x67,0xc4,0x24,0xeb] as IID_EventHandler_1_Windows_ApplicationModel_LeavingBackgroundEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for EventHandler<super::applicationmodel::SuspendingEventArgs> => [0x338579bf,0x1a35,0x5cc4,0xa6,0x22,0xa6,0xf3,0x84,0xfd,0x89,0x2c] as IID_EventHandler_1_Windows_ApplicationModel_SuspendingEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for EventHandler<super::devices::pointofservice::ClaimedBarcodeScanner> => [0xc0acd2ae,0x5b55,0x588d,0x81,0x1b,0xbe,0x33,0xa4,0xfd,0xda,0x57] as IID_EventHandler_1_Windows_Devices_PointOfService_ClaimedBarcodeScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for EventHandler<super::devices::pointofservice::ClaimedMagneticStripeReader> => [0x8006bf5d,0x0895,0x5b8c,0x80,0x8a,0x6b,0xb8,0xf2,0x67,0x94,0xfa] as IID_EventHandler_1_Windows_Devices_PointOfService_ClaimedMagneticStripeReader }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for EventHandler<super::gaming::input::ArcadeStick> => [0x6afb8188,0xd28d,0x539b,0xbb,0x69,0xea,0x17,0x63,0xfb,0x99,0x20] as IID_EventHandler_1_Windows_Gaming_Input_ArcadeStick }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for EventHandler<super::gaming::input::FlightStick> => [0xd57470b1,0xcc22,0x5a43,0x8e,0x18,0x5c,0xa0,0x64,0xaa,0xfe,0x21] as IID_EventHandler_1_Windows_Gaming_Input_FlightStick }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for EventHandler<super::gaming::input::Gamepad> => [0x8a7639ee,0x624a,0x501a,0xbb,0x53,0x56,0x2d,0x1e,0xc1,0x1b,0x52] as IID_EventHandler_1_Windows_Gaming_Input_Gamepad }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for EventHandler<super::gaming::input::RacingWheel> => [0x352ec824,0xf64b,0x5353,0x80,0xea,0x7f,0xf5,0x8e,0x3b,0x92,0xa4] as IID_EventHandler_1_Windows_Gaming_Input_RacingWheel }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for EventHandler<super::gaming::input::RawGameController> => [0x00621c22,0x42e8,0x529f,0x92,0x70,0x83,0x6b,0x32,0x93,0x1d,0x72] as IID_EventHandler_1_Windows_Gaming_Input_RawGameController }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for EventHandler<super::gaming::input::UINavigationController> => [0x9eaec424,0x75c1,0x5871,0x8d,0xa9,0xce,0x59,0x0c,0x65,0x30,0x45] as IID_EventHandler_1_Windows_Gaming_Input_UINavigationController }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for EventHandler<super::media::playback::MediaPlayerDataReceivedEventArgs> => [0x078fc818,0x19f5,0x5b8a,0xac,0x82,0x25,0x19,0x3b,0xea,0x56,0xee] as IID_EventHandler_1_Windows_Media_Playback_MediaPlayerDataReceivedEventArgs }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for EventHandler<super::security::authentication::identity::provider::SecondaryAuthenticationFactorAuthenticationStageChangedEventArgs> => [0x10409b3c,0x42e4,0x586f,0x84,0xc1,0x80,0x3d,0xa2,0x37,0x65,0xaf] as IID_EventHandler_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorAuthenticationStageChangedEventArgs }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for EventHandler<super::security::enterprisedata::ProtectedAccessResumedEventArgs> => [0x9efe4d36,0x6549,0x5222,0x9b,0xc2,0x4d,0x5d,0x92,0x9d,0x00,0x5c] as IID_EventHandler_1_Windows_Security_EnterpriseData_ProtectedAccessResumedEventArgs }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for EventHandler<super::security::enterprisedata::ProtectedAccessSuspendingEventArgs> => [0xfe8bb4d8,0x0d3d,0x5416,0xb3,0x90,0x9e,0xad,0x5d,0xd9,0xb3,0x84] as IID_EventHandler_1_Windows_Security_EnterpriseData_ProtectedAccessSuspendingEventArgs }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for EventHandler<super::security::enterprisedata::ProtectedContentRevokedEventArgs> => [0x4ff76357,0x6805,0x573e,0xa6,0x7d,0x2c,0x59,0x4f,0x50,0x04,0xb7] as IID_EventHandler_1_Windows_Security_EnterpriseData_ProtectedContentRevokedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for EventHandler<super::system::AppMemoryUsageLimitChangingEventArgs> => [0x6030e7c3,0xf93f,0x5e9c,0x9b,0xa2,0x9a,0x01,0x8d,0x2b,0x09,0xc0] as IID_EventHandler_1_Windows_System_AppMemoryUsageLimitChangingEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for EventHandler<super::system::UserDeviceAssociationChangedEventArgs> => [0xd3a3d4c5,0xd8b6,0x5a0e,0x88,0xed,0xa5,0x49,0x9c,0x37,0x7b,0xe3] as IID_EventHandler_1_Windows_System_UserDeviceAssociationChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for EventHandler<super::ui::core::BackRequestedEventArgs> => [0xca821060,0x002b,0x526d,0x81,0x22,0x98,0x26,0x30,0xd7,0xcd,0xbe] as IID_EventHandler_1_Windows_UI_Core_BackRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for EventHandler<super::ui::core::preview::SystemNavigationCloseRequestedPreviewEventArgs> => [0x01bca043,0x4d09,0x59e4,0xb1,0xb3,0xa2,0xce,0x24,0x62,0x9e,0x41] as IID_EventHandler_1_Windows_UI_Core_Preview_SystemNavigationCloseRequestedPreviewEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for EventHandler<super::ui::xaml::controls::DatePickerValueChangedEventArgs> => [0x18a84f8e,0xc1ec,0x5b25,0xac,0x98,0x81,0x82,0x67,0xe6,0xf9,0xa4] as IID_EventHandler_1_Windows_UI_Xaml_Controls_DatePickerValueChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for EventHandler<super::ui::xaml::controls::ScrollViewerViewChangedEventArgs> => [0x354c0f34,0xe691,0x502a,0xa4,0x44,0xd5,0xf0,0x7a,0xee,0x31,0x0e] as IID_EventHandler_1_Windows_UI_Xaml_Controls_ScrollViewerViewChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for EventHandler<super::ui::xaml::controls::ScrollViewerViewChangingEventArgs> => [0xe0c06ef2,0xdbc9,0x511c,0xba,0xb6,0x25,0x75,0x6d,0xd5,0x16,0xa3] as IID_EventHandler_1_Windows_UI_Xaml_Controls_ScrollViewerViewChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for EventHandler<super::ui::xaml::controls::TimePickerValueChangedEventArgs> => [0xebc4d41b,0x356a,0x59ca,0xb1,0x35,0x0e,0xc3,0x4f,0x68,0xc3,0x07] as IID_EventHandler_1_Windows_UI_Xaml_Controls_TimePickerValueChangedEventArgs }
RT_PINTERFACE!{ for IAsyncActionWithProgress<f64> => [0x4f1430a6,0xa825,0x56ca,0xb0,0x47,0x1a,0x9b,0xad,0x52,0xba,0x67] as IID_IAsyncActionWithProgress_1_System_Double }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncActionWithProgress<super::web::syndication::TransferProgress> => [0xb7eb83f5,0xa746,0x50f2,0xb9,0x1f,0x31,0x80,0x31,0x61,0xcc,0xc7] as IID_IAsyncActionWithProgress_1_Windows_Web_Syndication_TransferProgress }
RT_PINTERFACE!{ for IAsyncActionWithProgress<u64> => [0x43f713d0,0xc49d,0x5e55,0xae,0xbf,0xaf,0x39,0x57,0x68,0x35,0x1e] as IID_IAsyncActionWithProgress_1_System_UInt64 }
RT_PINTERFACE!{ for IAsyncOperation<bool> => [0xcdb5efb3,0x5788,0x509d,0x9b,0xe1,0x71,0xcc,0xb8,0xa3,0x36,0x2a] as IID_IAsyncOperation_1_System_Boolean }
RT_PINTERFACE!{ for IAsyncOperation<collections::IMap<HString, HString>> => [0x84e30b9c,0x351d,0x5fcb,0x8b,0x0a,0xbc,0x14,0x54,0x07,0xf9,0x15] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IMap_2_System_String_System_String }
RT_PINTERFACE!{ for IAsyncOperation<collections::IMap<HString, IInspectable>> => [0x127e39c7,0x07c1,0x58e5,0xb4,0x8e,0x3a,0x47,0x29,0x83,0x9f,0xec] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IMap_2_System_String_System_Object }
RT_PINTERFACE!{ for IAsyncOperation<collections::IMapView<HString, IInspectable>> => [0x5dcbee48,0x9965,0x51da,0xa4,0x61,0x17,0x7c,0x88,0x5b,0xe7,0xe5] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IMapView_2_System_String_System_Object }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IAsyncOperation<collections::IMapView<HString, super::perception::spatial::SpatialAnchor>> => [0xbbe07728,0xda33,0x52c5,0xaa,0xe0,0xa5,0xe7,0x4c,0xdf,0x04,0x71] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IMapView_2_System_String_Windows_Perception_Spatial_SpatialAnchor }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IMapView<HString, super::storage::streams::RandomAccessStreamReference>> => [0xfc012d44,0x2dcf,0x5162,0xbe,0x9a,0x76,0x68,0x67,0x5a,0xa5,0x90] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IMapView_2_System_String_Windows_Storage_Streams_RandomAccessStreamReference }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IMapView<u32, super::storage::streams::IBuffer>> => [0xd4904ded,0xbc1d,0x5933,0xae,0xcf,0xe4,0x2c,0x5d,0x46,0x5b,0xff] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IMapView_2_System_UInt32_Windows_Storage_Streams_IBuffer }
RT_PINTERFACE!{ for IAsyncOperation<collections::IPropertySet> => [0x490b0686,0xafd7,0x5037,0x96,0x47,0xd8,0xfe,0x24,0x8f,0x18,0x2c] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IPropertySet }
RT_PINTERFACE!{ for IAsyncOperation<collections::IVector<HString>> => [0x92b02cd3,0xaa6e,0x573d,0xbc,0x03,0x8d,0x23,0x09,0xcb,0xa3,0xeb] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVector_1_System_String }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVector<super::applicationmodel::contacts::Contact>> => [0x0f0ff4e8,0xd25d,0x53a8,0xba,0x87,0x1a,0x6b,0x23,0xe4,0x31,0x5c] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVector_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVector<super::applicationmodel::PackageContentGroup>> => [0x929e3c29,0xbf29,0x5594,0xbc,0x63,0x67,0xdb,0x43,0xa5,0x39,0xea] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVector_1_Windows_ApplicationModel_PackageContentGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVector<super::media::faceanalysis::DetectedFace>> => [0x37f1d7dc,0xa1a4,0x5a94,0xb3,0x3b,0x74,0x20,0x5a,0x65,0xa1,0xed] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVector_1_Windows_Media_FaceAnalysis_DetectedFace }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVector<super::system::AppDiagnosticInfo>> => [0xd6a9d3b9,0xf63c,0x59be,0xa0,0x96,0x3e,0x95,0x57,0xc4,0x11,0x82] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVector_1_Windows_System_AppDiagnosticInfo }
RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<collections::IMapView<HString, IInspectable>>> => [0xfc227365,0x219d,0x5d59,0x8b,0x5b,0x58,0xeb,0x0a,0x91,0xca,0x0a] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Foundation_Collections_IMapView_2_System_String_System_Object }
RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<HString>> => [0x2f92b529,0x119b,0x575a,0xa4,0x19,0x39,0x04,0xb4,0xe4,0x1a,0xf2] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_System_String }
RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<IInspectable>> => [0xd671d332,0x22aa,0x5597,0x8d,0xcc,0x24,0x59,0xea,0xb4,0x94,0x18] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::appextensions::AppExtension>> => [0x83295bb9,0x10df,0x530f,0xa0,0xd7,0xbe,0x05,0xba,0x80,0xcb,0x18] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_AppExtensions_AppExtension }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::AppInfo>> => [0x07543d91,0x8610,0x5152,0xb0,0xe4,0x43,0xd6,0xe4,0xcd,0xd0,0xcb] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_AppInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::appointments::Appointment>> => [0xa6bb6962,0xe2c1,0x5da2,0x99,0x38,0x15,0xef,0x82,0xcb,0xd1,0xcc] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_Appointment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::appointments::AppointmentCalendar>> => [0xd26021ac,0x99b4,0x5c40,0xb0,0xd2,0xd6,0x83,0x5d,0x2e,0x92,0x02] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_AppointmentCalendar }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::appointments::AppointmentException>> => [0x87e171ac,0x53fe,0x50ea,0xbe,0xb3,0x05,0x89,0x99,0x3a,0xc9,0x84] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_AppointmentException }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::appointments::AppointmentStoreChange>> => [0xd54944b9,0xb72e,0x50bc,0xa6,0x4a,0x19,0x39,0x6e,0x0d,0x1b,0xcc] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Appointments_AppointmentStoreChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::calls::PhoneCallHistoryEntry>> => [0x2258b912,0xeb70,0x5361,0xb2,0x0a,0x73,0x1e,0x15,0xbb,0x90,0x97] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Calls_PhoneCallHistoryEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::chat::ChatConversation>> => [0xd531f714,0xd3c7,0x589b,0x87,0x5c,0xbf,0xaa,0x27,0x52,0x24,0x78] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::chat::ChatMessage>> => [0xd9f6a9dd,0x7fcf,0x5e9e,0x86,0xc7,0x15,0x16,0x63,0xdb,0x67,0xcc] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::chat::ChatMessageChange>> => [0x831968b7,0xaa61,0x58cc,0x87,0x13,0x98,0xf6,0x5c,0xad,0x4e,0xd9] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatMessageChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::chat::ChatMessageTransport>> => [0xd558786d,0x95ce,0x5f23,0x9e,0x90,0x53,0x99,0x02,0xac,0x92,0xa6] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_ChatMessageTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::chat::IChatItem>> => [0x65b3eea1,0x7b6f,0x51a0,0xa2,0xeb,0x7f,0xb1,0xdc,0x47,0x30,0x22] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_IChatItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::chat::RcsTransport>> => [0x17e1f428,0x6e60,0x5153,0xb0,0xa6,0x5f,0xaf,0x18,0x65,0x61,0xc1] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Chat_RcsTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::Contact>> => [0x938328e5,0xd460,0x50cc,0x9c,0x94,0x70,0x26,0xa6,0xb2,0xe5,0xb2] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::ContactAnnotation>> => [0x8ebd10f1,0xc10b,0x50a4,0xa7,0xe5,0xb1,0xae,0x2c,0x32,0xba,0xb7] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactAnnotation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::ContactAnnotationList>> => [0xa549e2bf,0x9e24,0x5352,0x92,0x3d,0xff,0x18,0x4f,0x96,0xac,0xbb] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactAnnotationList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::ContactChange>> => [0x48db578e,0x9eab,0x5e97,0x82,0xee,0x0f,0xd0,0x79,0x96,0xc6,0x66] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::ContactGroup>> => [0xf78d6a56,0x6e40,0x5f68,0x99,0xde,0xb0,0xec,0x11,0x9c,0xca,0xb2] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::ContactInformation>> => [0xeab8500a,0x6a6f,0x5b05,0x89,0xc2,0x8d,0xcd,0x66,0x02,0x3b,0x3d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::contacts::ContactList>> => [0x79fd4783,0x5cc9,0x571b,0xbc,0x42,0xe2,0xe2,0xf8,0xdd,0xf9,0x67] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Contacts_ContactList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::core::AppListEntry>> => [0xd3bcf8a0,0x3538,0x5dae,0x98,0xd7,0x1f,0x2a,0xb8,0x8c,0x3f,0x01] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Core_AppListEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::email::EmailCertificateValidationStatus>> => [0xf3e7ef5b,0x8894,0x5488,0x97,0xef,0x02,0x9c,0xa4,0x91,0x39,0x47] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailCertificateValidationStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::email::EmailFolder>> => [0x0c1ca8b9,0x7f85,0x534d,0x98,0xf1,0x0f,0x5c,0xd8,0xe7,0x2c,0x1f] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailFolder }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::email::EmailMailbox>> => [0x5bed07ec,0xf5d5,0x5b25,0xb0,0x67,0x9b,0x22,0xa4,0xa7,0x62,0xea] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailMailbox }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::email::EmailMailboxChange>> => [0x81153d29,0xd502,0x5050,0xaf,0x64,0xb1,0x33,0x34,0x62,0xd1,0x6a] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailMailboxChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::email::EmailMessage>> => [0x47065121,0xdc80,0x59f9,0x87,0x19,0x3f,0x0c,0x6e,0xef,0x87,0x53] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::email::EmailRecipientResolutionResult>> => [0x12a76f8e,0xed11,0x5c2b,0x81,0xc6,0x11,0x02,0x96,0xfc,0x7a,0x43] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Email_EmailRecipientResolutionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::resources::management::IndexedResourceCandidate>> => [0xd2d41b8a,0x6616,0x5de8,0xaa,0xf9,0x32,0xae,0x51,0xf6,0x7f,0xcb] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Resources_Management_IndexedResourceCandidate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::StartupTask>> => [0x16543165,0x5b65,0x5683,0x8a,0x02,0xc3,0x85,0x65,0x91,0x58,0xbd] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_StartupTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::store::preview::installcontrol::AppInstallItem>> => [0x9267e107,0x2ac6,0x5e0d,0x86,0xe9,0x31,0x54,0xf6,0x16,0xc6,0x8b] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::store::preview::StorePreviewProductInfo>> => [0x49c36a66,0x3908,0x51b3,0x84,0x02,0xeb,0x8e,0x94,0xc6,0x88,0x64] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_Preview_StorePreviewProductInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::store::preview::StoreSystemFeature>> => [0xb1713163,0xee1b,0x5290,0x83,0x16,0xf7,0xeb,0xb9,0xd5,0x31,0x63] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_Preview_StoreSystemFeature }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::store::UnfulfilledConsumable>> => [0xf1cd679a,0x3a8f,0x5e1b,0x82,0xf1,0xf2,0xfd,0x09,0x16,0xca,0x3f] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Store_UnfulfilledConsumable }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::userdataaccounts::UserDataAccount>> => [0x8461a475,0x5f2f,0x5a03,0xb9,0xf8,0x01,0xe1,0x32,0x4d,0xef,0x3b] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::userdatatasks::UserDataTaskList>> => [0x2a4e06ee,0x9030,0x5ce6,0xad,0x7f,0xcf,0x55,0x17,0x95,0x76,0x5d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::applicationmodel::wallet::WalletItem>> => [0x23540ddd,0x166f,0x5b93,0x86,0x69,0xe3,0x40,0xb5,0xe1,0x82,0x0d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_ApplicationModel_Wallet_WalletItem }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::data::text::TextPhoneme>> => [0x6bc3019d,0xdd10,0x5510,0xb1,0x64,0x80,0x8c,0x23,0x2b,0x7d,0x64] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Data_Text_TextPhoneme }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::adc::AdcController>> => [0x1b0cddfb,0xd255,0x5a93,0xbc,0xb9,0xde,0x20,0x47,0xa3,0xe4,0xf3] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Adc_AdcController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::bluetooth::genericattributeprofile::GattClientNotificationResult>> => [0xb6fa5848,0xaccd,0x536b,0xa3,0x7e,0x24,0x44,0xd8,0x6f,0x2c,0x1f] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattClientNotificationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::geolocation::Geoposition>> => [0x9454b533,0xefb4,0x5385,0x8d,0x3a,0x43,0x7f,0xab,0xc3,0x2d,0x91] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Geolocation_Geoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::gpio::GpioController>> => [0x5da3faf4,0x60a7,0x5a14,0x93,0x19,0x39,0x41,0xdf,0xb1,0x3f,0xed] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Gpio_GpioController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::haptics::VibrationDevice>> => [0xbda8b138,0x7862,0x59f3,0xbf,0xd9,0x5f,0x1c,0xb0,0x63,0xdf,0x02] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Haptics_VibrationDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::i2c::I2cController>> => [0x77f52ff7,0xaba0,0x54bb,0x89,0x1a,0x49,0x35,0x1a,0x83,0x8e,0x33] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_I2c_I2cController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::i2c::provider::II2cControllerProvider>> => [0x5fe77838,0x1125,0x5b2c,0xa2,0x81,0xe0,0x6a,0x3d,0xfb,0xb7,0x6e] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_I2c_Provider_II2cControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::perception::PerceptionColorFrameSource>> => [0x33845b5f,0xd59e,0x5271,0xbb,0x68,0xf7,0x4e,0x9d,0x6a,0x53,0x8d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Perception_PerceptionColorFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::perception::PerceptionDepthFrameSource>> => [0xe20a534d,0xd406,0x5964,0x84,0x65,0xe6,0xdc,0x75,0xc5,0x82,0x1d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Perception_PerceptionDepthFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::perception::PerceptionInfraredFrameSource>> => [0xb11eecaa,0x6f8c,0x5040,0x8d,0x46,0xc3,0x20,0x4c,0x56,0x25,0x82] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Perception_PerceptionInfraredFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::pwm::PwmController>> => [0xe4151e8d,0x4688,0x5023,0x9f,0x5d,0x00,0x8b,0xbd,0x90,0x48,0x91] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Pwm_PwmController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::radios::Radio>> => [0x040b54a1,0x203e,0x58f5,0x94,0x3f,0xc1,0xcc,0xa8,0x6b,0xd5,0x32] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Radios_Radio }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::sensors::ActivitySensorReading>> => [0xcd781b82,0x7900,0x51a3,0x80,0xce,0x90,0x3e,0x2e,0x0a,0x4f,0x0e] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sensors_ActivitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::sensors::PedometerReading>> => [0x2aeac503,0xa3a8,0x57b3,0xa8,0xa9,0xe1,0x6b,0x0c,0xd4,0xc0,0xa4] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sensors_PedometerReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::smartcards::SmartCard>> => [0x3b2691b2,0xfc5e,0x59ff,0x8c,0x6f,0xe6,0xdd,0x29,0xa9,0x67,0xfc] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_SmartCards_SmartCard }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::smartcards::SmartCardAppletIdGroupRegistration>> => [0x045e34b9,0xf153,0x5920,0x99,0xde,0xed,0x91,0x2e,0xa3,0x8b,0x1a] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_SmartCards_SmartCardAppletIdGroupRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::spi::provider::ISpiControllerProvider>> => [0xb3af3490,0xdede,0x59d1,0xb5,0x62,0x1f,0x6b,0xe7,0x1a,0xe1,0x39] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Spi_Provider_ISpiControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::spi::SpiController>> => [0x89624331,0xf802,0x56f7,0x9b,0x33,0x17,0xc6,0x16,0xec,0xbc,0xfa] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Spi_SpiController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::devices::wifi::WiFiAdapter>> => [0x3140802b,0x987c,0x5c56,0xa4,0x30,0x90,0xfb,0xc1,0x89,0x8d,0xda] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_WiFi_WiFiAdapter }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::gaming::preview::gamesenumeration::GameListEntry>> => [0x721a94fb,0xa733,0x5e19,0x8a,0xbf,0x03,0x24,0x9c,0x29,0x87,0x0e] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Gaming_Preview_GamesEnumeration_GameListEntry }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::graphics::imaging::ImageStream>> => [0xa58d867e,0xbeef,0x5f17,0xb7,0xcf,0xe4,0xc8,0x7b,0xe2,0x2e,0xe4] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Graphics_Imaging_ImageStream }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::management::deployment::PackageVolume>> => [0x1e357e07,0xd337,0x5c07,0xae,0x06,0x90,0x0c,0x1b,0x9a,0x77,0xc1] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Management_Deployment_PackageVolume }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::media::capture::frames::MediaFrameSourceGroup>> => [0xa795889f,0x6d49,0x5687,0xaa,0xbe,0xf2,0xfc,0x62,0x37,0xfa,0x1a] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Media_Capture_Frames_MediaFrameSourceGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::media::core::CodecInfo>> => [0xc1c59efc,0x71df,0x5534,0xb0,0x3f,0xe1,0x8a,0x8f,0xbe,0x78,0xbb] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Media_Core_CodecInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::media::import::PhotoImportSource>> => [0x3ef45f6e,0x39b9,0x5976,0x86,0x43,0x6b,0xaf,0xea,0x4d,0x14,0x79] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Media_Import_PhotoImportSource }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::backgroundtransfer::DownloadOperation>> => [0xae42cddf,0x3042,0x5d92,0xa0,0x1e,0x64,0x3c,0x25,0x2b,0x80,0x50] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::backgroundtransfer::UploadOperation>> => [0x3e4c6a3c,0x48a4,0x5e22,0xb2,0x9a,0x3e,0x42,0x94,0x69,0x46,0x2f] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::connectivity::AttributedNetworkUsage>> => [0x9d8a4113,0xe7f3,0x552d,0x9a,0x8c,0x1c,0x25,0xe2,0x13,0x72,0x53] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_AttributedNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::connectivity::ConnectionProfile>> => [0xc0023294,0xc2cb,0x52f0,0xa9,0xf4,0x21,0x91,0x60,0x32,0xf6,0x9d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_ConnectionProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::connectivity::ConnectivityInterval>> => [0xaf96d70b,0x41c7,0x5dc6,0x98,0x95,0xea,0x04,0x3a,0x88,0x5d,0x8d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_ConnectivityInterval }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::connectivity::NetworkUsage>> => [0x05c9e081,0x6229,0x5049,0x8e,0xea,0xa4,0x98,0x40,0x7c,0x00,0xd5] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_NetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::connectivity::ProviderNetworkUsage>> => [0x7eba5a8f,0xe4fd,0x5201,0xa4,0xf4,0x95,0x67,0x59,0x6f,0x21,0x3c] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Connectivity_ProviderNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::EndpointPair>> => [0xafc2ff8e,0xe393,0x566a,0x89,0xc4,0xd0,0x43,0xe9,0x40,0x05,0x0d] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_EndpointPair }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::proximity::PeerInformation>> => [0xa36ec4bc,0x607a,0x5180,0xa7,0x85,0x40,0x42,0xf8,0x79,0x5c,0x8b] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Proximity_PeerInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::networking::vpn::IVpnProfile>> => [0x69d957be,0x045e,0x538f,0x98,0xf6,0x1a,0xa6,0x5c,0xee,0x24,0x4a] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Networking_Vpn_IVpnProfile }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::security::authentication::identity::EnterpriseKeyCredentialRegistrationInfo>> => [0x0bd64c2f,0x8b1d,0x56d4,0xa7,0x07,0xfa,0xb5,0x31,0x5e,0x72,0x78] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Authentication_Identity_EnterpriseKeyCredentialRegistrationInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::security::authentication::identity::provider::SecondaryAuthenticationFactorInfo>> => [0x47eb155b,0xabe0,0x55a5,0x93,0x10,0xfe,0xb1,0xdd,0x57,0xdc,0xa5] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::security::authentication::web::provider::WebAccountClientView>> => [0x116827c1,0x187e,0x5095,0xa1,0x4b,0xdf,0x41,0x11,0xc6,0x38,0xc2] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Authentication_Web_Provider_WebAccountClientView }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::security::credentials::WebAccount>> => [0x66b59040,0x7c93,0x5f96,0xb5,0x2f,0x2c,0x09,0x8d,0x15,0x57,0xd0] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Credentials_WebAccount }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::security::cryptography::certificates::Certificate>> => [0x9b26648e,0xb32f,0x5909,0xa6,0x35,0x78,0xe6,0xd3,0xbb,0x40,0x67] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Security_Cryptography_Certificates_Certificate }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::services::store::StorePackageUpdate>> => [0x0ac66c33,0x45b8,0x546b,0xaa,0xaf,0xd5,0x8d,0x62,0xa4,0xc5,0xc5] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Services_Store_StorePackageUpdate }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::bulkaccess::FileInformation>> => [0x222f6bb6,0xe71e,0x55cb,0x88,0x5d,0xe0,0x51,0xe3,0x59,0x95,0xdc] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_BulkAccess_FileInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::bulkaccess::FolderInformation>> => [0x7f10e569,0x2bf7,0x5752,0x8f,0x75,0x60,0x28,0x09,0xa7,0xd3,0x04] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_BulkAccess_FolderInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::bulkaccess::IStorageItemInformation>> => [0x413d160c,0x3e1a,0x5603,0xac,0xba,0x1e,0x17,0x6d,0x6a,0x60,0x82] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_BulkAccess_IStorageItemInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::IStorageItem>> => [0x4b1c0fd7,0x7a01,0x5e7a,0xa6,0xfe,0xbe,0x45,0x00,0x28,0x3f,0x23] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_IStorageItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::search::IIndexableContent>> => [0x919850e1,0x084b,0x5f9b,0xa0,0xa0,0x50,0xdb,0x0c,0xd5,0xda,0x91] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_Search_IIndexableContent }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::StorageFile>> => [0x03362e33,0xe413,0x5f29,0x97,0xd0,0x48,0xa4,0x78,0x09,0x35,0xf9] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_StorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::StorageFolder>> => [0xca40b21b,0xaeb1,0x5a61,0x9e,0x08,0x3b,0xd5,0xd9,0x59,0x40,0x23] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_StorageFolder }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::storage::StorageLibraryChange>> => [0x66e11b8a,0x9003,0x52c9,0x84,0xa8,0xae,0x5c,0xce,0xbe,0x8c,0xf9] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_Storage_StorageLibraryChange }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::system::User>> => [0xe44ea1df,0xbb85,0x5a8c,0xbd,0xdc,0xc8,0xe9,0x60,0xc3,0x55,0xc9] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_System_User }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::ui::input::inking::InkRecognitionResult>> => [0xb1923f59,0xd674,0x5365,0xb9,0x9a,0x3f,0x1e,0x52,0x26,0x8c,0x7f] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_Input_Inking_InkRecognitionResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::ui::notifications::ToastCollection>> => [0x34d4fa14,0x252b,0x5cb4,0xa7,0xda,0x97,0x1e,0xe5,0xda,0xec,0x7c] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_Notifications_ToastCollection }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::ui::notifications::UserNotification>> => [0xbf7f3d3c,0x230f,0x54ea,0xad,0x74,0x0c,0xf6,0xc5,0x5c,0xd8,0xd1] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_Notifications_UserNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<super::ui::startscreen::SecondaryTile>> => [0xf72d55b2,0xb004,0x5e35,0xb5,0xc4,0x22,0xe8,0x76,0x19,0xb3,0x0a] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_Windows_UI_StartScreen_SecondaryTile }
RT_PINTERFACE!{ for IAsyncOperation<collections::IVectorView<u32>> => [0x52c56f3c,0x713a,0x5162,0x9e,0x62,0x36,0x2c,0xe7,0xed,0x53,0xbe] as IID_IAsyncOperation_1_Windows_Foundation_Collections_IVectorView_1_System_UInt32 }
RT_PINTERFACE!{ for IAsyncOperation<diagnostics::ErrorDetails> => [0x9b05106d,0x77e0,0x5c24,0x82,0xb0,0x9b,0x2d,0xc8,0xf7,0x96,0x71] as IID_IAsyncOperation_1_Windows_Foundation_Diagnostics_ErrorDetails }
RT_PINTERFACE!{ for IAsyncOperation<Guid> => [0x6607bc41,0x294b,0x5975,0x9c,0x3f,0x4b,0x49,0x83,0x6d,0x09,0x16] as IID_IAsyncOperation_1_System_Guid }
RT_PINTERFACE!{ for IAsyncOperation<HString> => [0x3e1fe603,0xf897,0x5263,0xb3,0x28,0x08,0x06,0x42,0x6b,0x8a,0x79] as IID_IAsyncOperation_1_System_String }
RT_PINTERFACE!{ for IAsyncOperation<i32> => [0x968b9665,0x06ed,0x5774,0x8f,0x53,0x8e,0xde,0xab,0xd5,0xf7,0xb5] as IID_IAsyncOperation_1_System_Int32 }
RT_PINTERFACE!{ for IAsyncOperation<i64> => [0xcc468085,0x4bef,0x5584,0x90,0x7c,0x92,0x23,0xd2,0x67,0x90,0x19] as IID_IAsyncOperation_1_System_Int64 }
RT_PINTERFACE!{ for IAsyncOperation<IInspectable> => [0xabf53c57,0xee50,0x5342,0xb5,0x2a,0x26,0xe3,0xb8,0xcc,0x02,0x4f] as IID_IAsyncOperation_1_System_Object }
RT_PINTERFACE!{ for IAsyncOperation<IReference<DateTime>> => [0x2025b34f,0x4214,0x56ab,0xab,0xfe,0x2f,0xbe,0x65,0x95,0xda,0x9d] as IID_IAsyncOperation_1_Windows_Foundation_IReference_1_Windows_Foundation_DateTime }
RT_PINTERFACE!{ for IAsyncOperation<IReference<TimeSpan>> => [0x24a901ad,0x910f,0x5c0f,0xb2,0x3c,0x67,0x00,0x75,0x77,0xa5,0x58] as IID_IAsyncOperation_1_Windows_Foundation_IReference_1_Windows_Foundation_TimeSpan }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appointments::Appointment> => [0x0c5732f8,0x5bb9,0x5bb3,0x93,0xe5,0xb8,0x7e,0x43,0xe0,0xcd,0x6a] as IID_IAsyncOperation_1_Windows_ApplicationModel_Appointments_Appointment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appointments::AppointmentCalendar> => [0x6bb17a95,0x918e,0x5ad0,0xbb,0xc2,0xbc,0xc5,0xfa,0x1f,0xf9,0x36] as IID_IAsyncOperation_1_Windows_ApplicationModel_Appointments_AppointmentCalendar }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appointments::AppointmentConflictResult> => [0xb376080f,0xe5b2,0x5ae2,0x99,0x01,0x86,0xcf,0x77,0xba,0x5d,0x00] as IID_IAsyncOperation_1_Windows_ApplicationModel_Appointments_AppointmentConflictResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appointments::AppointmentStore> => [0x63798415,0x4d1f,0x5fc7,0x87,0x29,0x79,0xa2,0x82,0xbc,0xec,0xa4] as IID_IAsyncOperation_1_Windows_ApplicationModel_Appointments_AppointmentStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appservice::AppServiceConnectionStatus> => [0x0d0e6663,0x2639,0x5a9a,0x9c,0xbc,0x30,0xd7,0xd4,0xce,0x53,0x3b] as IID_IAsyncOperation_1_Windows_ApplicationModel_AppService_AppServiceConnectionStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appservice::AppServiceResponse> => [0x48755a7c,0xc88f,0x5ef0,0x9b,0x4c,0x87,0x6f,0xcc,0x26,0x10,0xb4] as IID_IAsyncOperation_1_Windows_ApplicationModel_AppService_AppServiceResponse }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::appservice::AppServiceResponseStatus> => [0x98fdb842,0x5a0b,0x539a,0xa3,0x5c,0x55,0xac,0x5f,0x22,0x86,0x12] as IID_IAsyncOperation_1_Windows_ApplicationModel_AppService_AppServiceResponseStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::AlarmAccessStatus> => [0xa55a747d,0x59f6,0x5cb6,0xb4,0x39,0xc8,0xaa,0xd6,0x70,0x90,0x5c] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_AlarmAccessStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::ApplicationTriggerResult> => [0x47cbd985,0x0f08,0x5a3d,0x92,0xcf,0xb2,0x79,0x60,0x50,0x6e,0xd6] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_ApplicationTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::BackgroundAccessStatus> => [0x7b44e581,0xcfa9,0x5763,0xbe,0xd7,0x6a,0x65,0x73,0x9f,0x0d,0xbf] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_BackgroundAccessStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::DeviceConnectionChangeTrigger> => [0x9d01424d,0x5653,0x59f8,0xba,0x6b,0xd0,0xc0,0x77,0x34,0x6d,0x2d] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_DeviceConnectionChangeTrigger }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::DeviceTriggerResult> => [0xb5136c46,0x2f2e,0x511d,0x9e,0x8e,0x5e,0xf4,0xde,0xcb,0x1d,0xa7] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_DeviceTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::GattServiceProviderTriggerResult> => [0xf402ec9f,0x84b2,0x57c3,0x95,0x43,0x01,0xfb,0xda,0x05,0x21,0x9b] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_GattServiceProviderTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::background::MediaProcessingTriggerResult> => [0x2595482c,0x1cbf,0x5691,0xa3,0x0d,0x21,0x64,0x90,0x9c,0x67,0x12] as IID_IAsyncOperation_1_Windows_ApplicationModel_Background_MediaProcessingTriggerResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::calls::PhoneCallHistoryEntry> => [0x785e7cca,0x90e2,0x5d03,0x8f,0x23,0xb3,0x35,0x8d,0x09,0xc9,0x51] as IID_IAsyncOperation_1_Windows_ApplicationModel_Calls_PhoneCallHistoryEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::calls::PhoneCallHistoryStore> => [0x0d9a97b0,0x8796,0x52bf,0x80,0xda,0xb1,0x43,0x5f,0xe6,0x4a,0x26] as IID_IAsyncOperation_1_Windows_ApplicationModel_Calls_PhoneCallHistoryStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::calls::VoipPhoneCallResourceReservationStatus> => [0x8528be80,0x7ce9,0x5668,0x8e,0x48,0x46,0x9a,0xe5,0xba,0x9e,0xad] as IID_IAsyncOperation_1_Windows_ApplicationModel_Calls_VoipPhoneCallResourceReservationStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::ChatCapabilities> => [0x30889035,0xc687,0x573b,0x86,0xe4,0x02,0x4e,0x38,0xf2,0xaa,0x6d] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_ChatCapabilities }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::ChatConversation> => [0xc4d8e414,0x0e54,0x5adf,0x88,0xc3,0xe5,0x6d,0x4e,0x88,0xb5,0xd4] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_ChatConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::ChatMessage> => [0xee129c22,0xda8f,0x5c55,0x90,0xb6,0xa7,0x3b,0xac,0xc9,0xd7,0x35] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_ChatMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::ChatMessageStore> => [0x19642405,0x0e06,0x5119,0x9a,0xc5,0x16,0xcf,0xd1,0x06,0xb3,0x37] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_ChatMessageStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::ChatMessageTransport> => [0x275e7895,0x3a8e,0x5175,0xb7,0x6f,0x21,0xd2,0xe0,0x45,0xbd,0x2f] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_ChatMessageTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::ChatSyncManager> => [0xa4667a6a,0x1c64,0x51f6,0x97,0x2e,0xa1,0x05,0x07,0x19,0xf8,0xea] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_ChatSyncManager }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::chat::RcsTransport> => [0xf88774e8,0x9664,0x5df5,0xab,0xbd,0xc6,0x45,0x56,0xd2,0x50,0x62] as IID_IAsyncOperation_1_Windows_ApplicationModel_Chat_RcsTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::Contact> => [0x857db963,0xf62c,0x53c4,0xa3,0xa0,0xf6,0xbf,0x0c,0x8f,0xd3,0xd3] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactAnnotation> => [0x61ea54c3,0xd629,0x5b5e,0xb5,0x81,0x63,0x05,0x04,0xb5,0x17,0x02] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactAnnotation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactAnnotationList> => [0x3a0a5967,0xc17c,0x579f,0xba,0x05,0xcc,0x56,0xe0,0xa1,0xd0,0x91] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactAnnotationList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactAnnotationStore> => [0xc6912277,0x5dd3,0x5e50,0xa7,0xeb,0xa5,0x66,0x06,0x46,0xd4,0x32] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactAnnotationStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactBatch> => [0x446fb5e0,0x5d2b,0x591d,0xb8,0xde,0xfb,0x7c,0x95,0xfc,0x9f,0x37] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactInformation> => [0x0e51c030,0x27aa,0x561f,0xbb,0xd8,0x2f,0x57,0xc0,0x8f,0xef,0x83] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactList> => [0xae816b3d,0x57a8,0x50a7,0x80,0x7e,0x2c,0x76,0x8a,0x36,0x4a,0x4f] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::ContactStore> => [0x235e0791,0x9a3e,0x5723,0x87,0xf0,0x44,0xff,0xb7,0x86,0xc9,0xe1] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_ContactStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::contacts::PinnedContactIdsQueryResult> => [0x031adb6c,0x3aa3,0x5b09,0xa8,0xfb,0x92,0xea,0x01,0x45,0xdc,0x40] as IID_IAsyncOperation_1_Windows_ApplicationModel_Contacts_PinnedContactIdsQueryResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::core::AppRestartFailureReason> => [0x0938905d,0x54c0,0x572f,0x84,0x51,0x4b,0xfd,0x2b,0x52,0xed,0xda] as IID_IAsyncOperation_1_Windows_ApplicationModel_Core_AppRestartFailureReason }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::datatransfer::DataPackage> => [0xa16f2d07,0xead3,0x53e4,0x94,0x90,0x75,0xbd,0xba,0xeb,0x7a,0x5b] as IID_IAsyncOperation_1_Windows_ApplicationModel_DataTransfer_DataPackage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::datatransfer::DataPackageOperation> => [0x8b98aea9,0x64f0,0x5672,0xb3,0x0e,0xdf,0xd9,0xc2,0xe4,0xf6,0xfe] as IID_IAsyncOperation_1_Windows_ApplicationModel_DataTransfer_DataPackageOperation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailConversation> => [0x6885966c,0x13b9,0x59cc,0xb3,0x58,0xad,0xf8,0x2e,0xec,0x84,0x2a] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailConversationBatch> => [0x7d87db9c,0x947d,0x5e0c,0x8c,0xf2,0x24,0x59,0x98,0xd1,0x9d,0x8f] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailConversationBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailFolder> => [0x6132274f,0x733d,0x5391,0x90,0x77,0x08,0x67,0xfc,0x33,0x09,0x16] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailFolder }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailItemCounts> => [0x5856790d,0x5204,0x5a99,0xb6,0x9e,0xc7,0x16,0x2f,0xd2,0x58,0x69] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailItemCounts }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMailbox> => [0x6f01f05e,0x988d,0x5b28,0xab,0xa8,0xdb,0xaa,0xbb,0x4e,0xb0,0xd9] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMailbox }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMailboxAutoReplySettings> => [0xb354d4c4,0xe4a0,0x5a3c,0xb8,0x97,0x8d,0xeb,0x45,0x8a,0xc6,0x73] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMailboxAutoReplySettings }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMailboxCreateFolderResult> => [0x6d5a0e81,0x6949,0x50f9,0xbf,0xfb,0x92,0xbe,0x12,0x16,0x72,0x4d] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMailboxCreateFolderResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMailboxDeleteFolderStatus> => [0x6860f87f,0x0297,0x5adf,0xaa,0x16,0x9f,0x1f,0x08,0xe2,0xd9,0x50] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMailboxDeleteFolderStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMailboxEmptyFolderStatus> => [0x0033a74e,0x9baa,0x5f50,0x8d,0x6e,0x23,0x86,0x35,0xe6,0xfd,0xd3] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMailboxEmptyFolderStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMessage> => [0x73157119,0xfa58,0x5d2d,0x81,0x7c,0xb5,0x63,0x0c,0x15,0x11,0xe4] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailMessageBatch> => [0x37fea119,0x0f1e,0x5012,0x88,0xbb,0xf0,0x17,0x9f,0x8f,0x4d,0xe5] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailMessageBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::email::EmailStore> => [0x7c9df991,0x5d99,0x55b4,0xb4,0x39,0x06,0x4e,0xdd,0x09,0x7a,0xc4] as IID_IAsyncOperation_1_Windows_ApplicationModel_Email_EmailStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::extendedexecution::ExtendedExecutionResult> => [0x1dbb1bc9,0x6cd7,0x5947,0x8c,0xd1,0x29,0x63,0x2b,0x5a,0xa9,0x50] as IID_IAsyncOperation_1_Windows_ApplicationModel_ExtendedExecution_ExtendedExecutionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::extendedexecution::foreground::ExtendedExecutionForegroundResult> => [0xb18ea00f,0x8c20,0x5ac2,0x92,0x46,0x3e,0xf4,0x05,0x27,0x1f,0x1a] as IID_IAsyncOperation_1_Windows_ApplicationModel_ExtendedExecution_Foreground_ExtendedExecutionForegroundResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::PackageCatalogAddOptionalPackageResult> => [0x59b2497f,0x86eb,0x542f,0xbe,0xa6,0x1b,0xe5,0x3e,0x93,0xe1,0x3d] as IID_IAsyncOperation_1_Windows_ApplicationModel_PackageCatalogAddOptionalPackageResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::PackageCatalogRemoveOptionalPackagesResult> => [0xcfc179aa,0xfb98,0x54ef,0x8e,0xa8,0x64,0x49,0x93,0x47,0xb7,0xf7] as IID_IAsyncOperation_1_Windows_ApplicationModel_PackageCatalogRemoveOptionalPackagesResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::PackageContentGroup> => [0xbbd292e3,0xdb9f,0x5802,0xa4,0x88,0x40,0xf1,0x56,0x33,0x2c,0x04] as IID_IAsyncOperation_1_Windows_ApplicationModel_PackageContentGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::payments::PaymentCanMakePaymentResult> => [0xa467410a,0x11de,0x5090,0xb9,0x05,0x96,0xa5,0x62,0xd8,0x5d,0xe5] as IID_IAsyncOperation_1_Windows_ApplicationModel_Payments_PaymentCanMakePaymentResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::payments::PaymentRequestChangedResult> => [0x0cc32025,0xac67,0x57e2,0xa0,0xf6,0x3a,0x8e,0x11,0x6c,0xef,0x4c] as IID_IAsyncOperation_1_Windows_ApplicationModel_Payments_PaymentRequestChangedResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::payments::PaymentRequestSubmitResult> => [0xcf290deb,0x5549,0x57c3,0x8a,0xbd,0x53,0xb7,0x6c,0x64,0x3c,0xca] as IID_IAsyncOperation_1_Windows_ApplicationModel_Payments_PaymentRequestSubmitResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::payments::provider::PaymentTransaction> => [0xe09a3f7d,0x6ad0,0x58cf,0xab,0x4c,0x2e,0x4c,0x9c,0x79,0x18,0x73] as IID_IAsyncOperation_1_Windows_ApplicationModel_Payments_Provider_PaymentTransaction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::payments::provider::PaymentTransactionAcceptResult> => [0xc645e8ef,0x0863,0x55b4,0x8a,0xed,0x42,0xbd,0x15,0x2d,0x80,0x04] as IID_IAsyncOperation_1_Windows_ApplicationModel_Payments_Provider_PaymentTransactionAcceptResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::socialinfo::provider::SocialDashboardItemUpdater> => [0x8bbca9a4,0xa4fc,0x5fe2,0xb6,0xb1,0x0e,0x5a,0x75,0xd0,0x5b,0x07] as IID_IAsyncOperation_1_Windows_ApplicationModel_SocialInfo_Provider_SocialDashboardItemUpdater }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::socialinfo::provider::SocialFeedUpdater> => [0x4efa4da9,0xc556,0x59f4,0x9d,0x99,0xe7,0x80,0x1c,0x5b,0x0f,0x45] as IID_IAsyncOperation_1_Windows_ApplicationModel_SocialInfo_Provider_SocialFeedUpdater }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::StartupTask> => [0xcbec7a4e,0xa046,0x5330,0x87,0x3d,0x0f,0xce,0x22,0x87,0x92,0xfa] as IID_IAsyncOperation_1_Windows_ApplicationModel_StartupTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::StartupTaskState> => [0x5239a934,0x80e2,0x518f,0xb8,0x19,0x1f,0x31,0x6f,0x37,0x9a,0x3f] as IID_IAsyncOperation_1_Windows_ApplicationModel_StartupTaskState }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::FulfillmentResult> => [0x5c8531ac,0x5d8d,0x5e07,0xb6,0xee,0x7c,0xab,0x96,0x93,0x0e,0x8a] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_FulfillmentResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::licensemanagement::LicenseSatisfactionResult> => [0xb8447bc9,0xa9f8,0x5867,0x8b,0x30,0xcd,0x34,0x72,0x0e,0xdc,0x31] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_LicenseManagement_LicenseSatisfactionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::ListingInformation> => [0x161600f7,0x6d4f,0x500d,0x93,0xa8,0x09,0xad,0x6b,0x5a,0xc4,0xab] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_ListingInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::preview::installcontrol::AppInstallItem> => [0x83b51cbf,0x35e0,0x59ad,0xab,0x3e,0xff,0xb3,0xf0,0x37,0x04,0xf9] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::preview::installcontrol::GetEntitlementResult> => [0x4c24d7ee,0x4b92,0x5cea,0xa4,0xf4,0x7a,0x5d,0x6e,0x91,0x90,0x62] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_Preview_InstallControl_GetEntitlementResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::preview::StorePreviewPurchaseResults> => [0x9aa2af80,0x0dcb,0x5ec1,0x84,0x35,0x0b,0x68,0x7e,0xd3,0x74,0xa5] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_Preview_StorePreviewPurchaseResults }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::store::PurchaseResults> => [0x241f6b10,0x6af6,0x5164,0x85,0xeb,0xba,0xe6,0xbd,0xae,0x0b,0xe8] as IID_IAsyncOperation_1_Windows_ApplicationModel_Store_PurchaseResults }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::useractivities::UserActivity> => [0x35095983,0x7790,0x5974,0xa6,0x60,0x1c,0x2d,0xbd,0xd2,0xef,0xa7] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserActivities_UserActivity }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdataaccounts::systemaccess::DeviceAccountConfiguration> => [0x469859f3,0x6b7b,0x5399,0x8a,0x8c,0xfe,0x61,0x5b,0x95,0xae,0x07] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataAccounts_SystemAccess_DeviceAccountConfiguration }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdataaccounts::UserDataAccount> => [0xf0aeb2af,0xa69b,0x5caa,0xa2,0x83,0x32,0xe6,0x97,0xa6,0x5d,0x31] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdataaccounts::UserDataAccountStore> => [0x06b68f1e,0x9937,0x5296,0xa5,0x5e,0xd4,0x3d,0xd8,0xa7,0x54,0x5c] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccountStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdatatasks::UserDataTask> => [0xb8b749b1,0xa847,0x5c34,0x86,0x6c,0xea,0x56,0x0c,0xde,0x1f,0x49] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataTasks_UserDataTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdatatasks::UserDataTaskBatch> => [0xd36b10df,0x1cab,0x544c,0x8c,0x2e,0x3c,0x7b,0xc4,0xd2,0x4b,0x24] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskBatch }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdatatasks::UserDataTaskList> => [0xd9274ef2,0x63e0,0x544c,0x8d,0xb2,0xfe,0x2d,0x5b,0x82,0x5d,0x9e] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::userdatatasks::UserDataTaskStore> => [0xe02c4e60,0x78aa,0x5eb8,0xba,0xdb,0xea,0xd2,0x2d,0xca,0x96,0x79] as IID_IAsyncOperation_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::voicecommands::VoiceCommand> => [0x815f1854,0x4d79,0x570d,0x9b,0x57,0x5b,0x47,0xe2,0x82,0xcd,0x66] as IID_IAsyncOperation_1_Windows_ApplicationModel_VoiceCommands_VoiceCommand }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::voicecommands::VoiceCommandConfirmationResult> => [0x3b39db5f,0xd2a4,0x5d88,0x85,0x1f,0xe9,0xa0,0xea,0x0d,0x94,0x7e] as IID_IAsyncOperation_1_Windows_ApplicationModel_VoiceCommands_VoiceCommandConfirmationResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::voicecommands::VoiceCommandDisambiguationResult> => [0xb03d44c8,0x060f,0x5b98,0x95,0x3a,0xfd,0x1e,0xb1,0xd4,0x6a,0xbc] as IID_IAsyncOperation_1_Windows_ApplicationModel_VoiceCommands_VoiceCommandDisambiguationResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::wallet::system::WalletItemSystemStore> => [0x587c5f4f,0x7c55,0x5f74,0xb2,0x6a,0xf8,0x0e,0x3b,0xc6,0xd4,0xf2] as IID_IAsyncOperation_1_Windows_ApplicationModel_Wallet_System_WalletItemSystemStore }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::wallet::WalletItem> => [0x8e64ddb0,0xea5c,0x5593,0xa1,0xf3,0x0b,0x82,0x09,0xdf,0x39,0x05] as IID_IAsyncOperation_1_Windows_ApplicationModel_Wallet_WalletItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IAsyncOperation<super::applicationmodel::wallet::WalletItemStore> => [0x9664f3ba,0x0049,0x5cbf,0x84,0x5f,0x8f,0x0b,0xca,0xd2,0xb1,0x4c] as IID_IAsyncOperation_1_Windows_ApplicationModel_Wallet_WalletItemStore }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IAsyncOperation<super::data::pdf::PdfDocument> => [0xd6b166ec,0x099a,0x5ee2,0xad,0x2e,0xf4,0xc8,0x86,0x14,0xaa,0xbb] as IID_IAsyncOperation_1_Windows_Data_Pdf_PdfDocument }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IAsyncOperation<super::data::xml::dom::XmlDocument> => [0xf858e239,0x1896,0x5982,0x84,0x95,0x14,0x31,0x68,0x47,0x8e,0xb8] as IID_IAsyncOperation_1_Windows_Data_Xml_Dom_XmlDocument }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::adc::AdcController> => [0x69420262,0x35c9,0x583f,0xa4,0x0e,0xc2,0x69,0x45,0x62,0xc9,0xe2] as IID_IAsyncOperation_1_Windows_Devices_Adc_AdcController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::alljoyn::AllJoynAboutDataView> => [0x3757414e,0xf54b,0x51c4,0x8f,0x2f,0xe0,0x47,0x75,0x59,0xb2,0xad] as IID_IAsyncOperation_1_Windows_Devices_AllJoyn_AllJoynAboutDataView }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::alljoyn::AllJoynServiceInfo> => [0xb9ce48c1,0x16cc,0x5e46,0x91,0xd5,0xe5,0xcd,0x06,0xf8,0x02,0x6e] as IID_IAsyncOperation_1_Windows_Devices_AllJoyn_AllJoynServiceInfo }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::alljoyn::AllJoynSession> => [0x74ae55f8,0x3d63,0x5472,0x91,0x3d,0x74,0xe9,0xa1,0x12,0x5d,0xd3] as IID_IAsyncOperation_1_Windows_Devices_AllJoyn_AllJoynSession }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::BluetoothAdapter> => [0x46fce70c,0x6c07,0x5a3a,0xb7,0x75,0x26,0xf9,0x94,0x02,0x55,0x3f] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_BluetoothAdapter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::BluetoothDevice> => [0xb58d8d19,0x44bd,0x5ac0,0xa0,0xd6,0x1b,0x50,0x80,0x0f,0x31,0x81] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_BluetoothDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::BluetoothLEDevice> => [0x375f9d67,0x74a2,0x5f91,0xa1,0x1d,0x16,0x90,0x93,0x71,0x8d,0x41] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_BluetoothLEDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattCharacteristicsResult> => [0x0972194a,0xac1c,0x5536,0x98,0x86,0x27,0xe5,0x8a,0x18,0xf2,0x73] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattClientNotificationResult> => [0xde27c5cf,0x6227,0x5829,0xb9,0x97,0x88,0xe5,0x75,0xad,0x06,0x80] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattClientNotificationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattCommunicationStatus> => [0x3ff69516,0x1bfb,0x52e9,0x9e,0xe6,0xe5,0xcd,0xb7,0x8e,0x16,0x83] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCommunicationStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattDescriptorsResult> => [0xceaf40c7,0xbe37,0x52a5,0x9a,0x1b,0x63,0x39,0x85,0x13,0xe5,0x97] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDescriptorsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattDeviceService> => [0xe5e90272,0x408f,0x5055,0x9b,0xd3,0x88,0x40,0x89,0x82,0xd3,0x01] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattDeviceServicesResult> => [0xe7c667f6,0xe874,0x500f,0x86,0xff,0x76,0x0c,0xa6,0xf0,0x7a,0x58] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDeviceServicesResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristicResult> => [0x1f97164e,0x88d5,0x567d,0x90,0xf9,0x75,0xd4,0xf6,0x45,0x52,0x74] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristicResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattLocalDescriptorResult> => [0x3ef6d808,0x754f,0x5040,0x97,0xac,0x07,0x03,0x30,0x9c,0x57,0x4f] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalDescriptorResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattOpenStatus> => [0x983201ac,0x8777,0x53e8,0x86,0xe0,0x63,0xfa,0x68,0x4b,0xe1,0xbd] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattOpenStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattReadClientCharacteristicConfigurationDescriptorResult> => [0xcf4444cc,0x4077,0x5719,0x83,0x66,0x46,0xe8,0x6b,0x98,0x36,0x85] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadClientCharacteristicConfigurationDescriptorResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattReadRequest> => [0x4732cec2,0xd943,0x5ceb,0x82,0x81,0x8d,0x54,0xa2,0x1b,0x9a,0x45] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadRequest }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattReadResult> => [0xd40432a8,0x1e14,0x51d0,0xb4,0x9b,0xae,0x2c,0xe1,0xaa,0x05,0xe5] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattServiceProviderResult> => [0x21781028,0xf5a2,0x5d99,0xa5,0xab,0xbc,0xe6,0x55,0x4f,0xbc,0x02] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattServiceProviderResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattSession> => [0x6d40b467,0x46b9,0x516f,0x82,0x08,0xdb,0x23,0xb7,0x86,0xea,0x48] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSession }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattWriteRequest> => [0xfb8b3c18,0x2f60,0x5b43,0xb7,0x73,0x14,0x60,0x45,0x81,0x6e,0x03] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteRequest }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::genericattributeprofile::GattWriteResult> => [0xe83b4534,0xbd14,0x5a9b,0xa5,0x3b,0x17,0xcc,0x02,0xa2,0xa8,0xa8] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::rfcomm::RfcommDeviceService> => [0x0df56bd7,0xc8f6,0x5c32,0x96,0x44,0xaa,0x0b,0xcf,0x28,0xd7,0x8c] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_Rfcomm_RfcommDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::rfcomm::RfcommDeviceServicesResult> => [0xb7f2f74d,0xbf9c,0x5721,0xbf,0x6e,0x03,0xf1,0xb4,0x40,0x95,0x88] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_Rfcomm_RfcommDeviceServicesResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::bluetooth::rfcomm::RfcommServiceProvider> => [0xfed44828,0xe232,0x554d,0x85,0xd1,0x2f,0x04,0xd1,0x32,0x2e,0x69] as IID_IAsyncOperation_1_Windows_Devices_Bluetooth_Rfcomm_RfcommServiceProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::custom::CustomDevice> => [0x2a6344aa,0x0568,0x548e,0xa1,0xa2,0xb6,0xbb,0x45,0x1d,0x22,0x8c] as IID_IAsyncOperation_1_Windows_Devices_Custom_CustomDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::DeviceAccessStatus> => [0xc00bc2f2,0xa7f8,0x5f3f,0x80,0xd1,0x28,0x08,0xef,0x6b,0xca,0x10] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_DeviceAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::DeviceInformation> => [0x07faa053,0xeb2f,0x5cba,0xb2,0x5b,0xd9,0xd5,0x7b,0xe6,0x71,0x5f] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_DeviceInformation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::DeviceInformationCollection> => [0x45180254,0x082e,0x5274,0xb2,0xe7,0xac,0x05,0x17,0xf4,0x4d,0x07] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_DeviceInformationCollection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::DevicePairingResult> => [0x1002db74,0x8948,0x591e,0x81,0x5d,0xe4,0x0b,0x66,0x75,0x99,0xa3] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_DevicePairingResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::DeviceThumbnail> => [0xbac083a3,0x3a19,0x5072,0x9d,0x90,0x13,0x33,0x23,0xa0,0x49,0xba] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_DeviceThumbnail }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::DeviceUnpairingResult> => [0x2bb4df3d,0xbd7e,0x5fe0,0x90,0x20,0x56,0xdc,0x0d,0x30,0xb9,0x35] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_DeviceUnpairingResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::pnp::PnpObject> => [0x22b0fb93,0x30e6,0x501a,0xbd,0x3b,0x9f,0xa3,0x06,0x3e,0x9c,0x16] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_Pnp_PnpObject }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::enumeration::pnp::PnpObjectCollection> => [0xf383c2cc,0xf326,0x5bbe,0x95,0xd1,0xcb,0xc2,0x47,0x14,0xef,0x86] as IID_IAsyncOperation_1_Windows_Devices_Enumeration_Pnp_PnpObjectCollection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::geolocation::GeolocationAccessStatus> => [0xde2b24d0,0xb726,0x57b1,0xa7,0xc5,0xe5,0xa1,0x39,0x32,0xb7,0xde] as IID_IAsyncOperation_1_Windows_Devices_Geolocation_GeolocationAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::geolocation::Geopoint> => [0x3723e070,0xc2ae,0x538f,0x84,0x6e,0x0f,0x9d,0x28,0x03,0x10,0xc0] as IID_IAsyncOperation_1_Windows_Devices_Geolocation_Geopoint }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::geolocation::Geoposition> => [0xee73ecf0,0x099d,0x57e5,0x84,0x07,0x5b,0x32,0xe5,0xaf,0x1c,0xc4] as IID_IAsyncOperation_1_Windows_Devices_Geolocation_Geoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::geolocation::Geovisit> => [0x8d1c950a,0xefb9,0x5440,0xa6,0xa7,0x82,0x0a,0x83,0x9b,0xe0,0x7b] as IID_IAsyncOperation_1_Windows_Devices_Geolocation_Geovisit }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::gpio::GpioController> => [0xed045917,0x96c7,0x5735,0xb4,0xbe,0xd7,0x96,0x19,0xd4,0x83,0x5e] as IID_IAsyncOperation_1_Windows_Devices_Gpio_GpioController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::haptics::VibrationAccessStatus> => [0x076b2611,0x5614,0x55a5,0x9c,0x58,0xf9,0xd1,0x7a,0x8f,0x0b,0x79] as IID_IAsyncOperation_1_Windows_Devices_Haptics_VibrationAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::haptics::VibrationDevice> => [0x44193494,0xe331,0x50ca,0xbb,0x61,0x6a,0x71,0xbd,0x9b,0x01,0xc4] as IID_IAsyncOperation_1_Windows_Devices_Haptics_VibrationDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::humaninterfacedevice::HidDevice> => [0xa76a4fbf,0x5177,0x5256,0x84,0xa8,0xb3,0x1a,0x8d,0xcf,0x10,0x48] as IID_IAsyncOperation_1_Windows_Devices_HumanInterfaceDevice_HidDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::humaninterfacedevice::HidFeatureReport> => [0xd72fb6f9,0x42f6,0x5f45,0xbf,0xe3,0x29,0xaf,0x24,0x7c,0x2e,0x85] as IID_IAsyncOperation_1_Windows_Devices_HumanInterfaceDevice_HidFeatureReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::humaninterfacedevice::HidInputReport> => [0xb3e28917,0xcd48,0x57b3,0xa0,0xb1,0x32,0x14,0x32,0xe8,0x5b,0xd6] as IID_IAsyncOperation_1_Windows_Devices_HumanInterfaceDevice_HidInputReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::i2c::I2cController> => [0xa4fb1dd4,0x80c9,0x5a61,0xae,0x8d,0xc8,0xa7,0xaf,0xc0,0x32,0x75] as IID_IAsyncOperation_1_Windows_Devices_I2c_I2cController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::i2c::I2cDevice> => [0x1e8a7cd8,0xe41b,0x5a41,0x82,0xb1,0x80,0x05,0x50,0x12,0xae,0x00] as IID_IAsyncOperation_1_Windows_Devices_I2c_I2cDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::lights::Lamp> => [0x52a69dfd,0xf0d6,0x5931,0xb8,0xe1,0xf3,0x80,0x66,0xd7,0x1b,0xf2] as IID_IAsyncOperation_1_Windows_Devices_Lights_Lamp }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::midi::IMidiOutPort> => [0x32699a4d,0x1cc0,0x5a1c,0x9d,0xa6,0x87,0x51,0x97,0x87,0x50,0x86] as IID_IAsyncOperation_1_Windows_Devices_Midi_IMidiOutPort }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::midi::MidiInPort> => [0xcc664f0e,0xedb1,0x55c8,0x9e,0xf7,0xec,0x90,0x07,0xe4,0x56,0x1c] as IID_IAsyncOperation_1_Windows_Devices_Midi_MidiInPort }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::midi::MidiSynthesizer> => [0x9388b978,0x13f1,0x5e37,0x81,0x33,0x94,0x43,0x0d,0x90,0xdd,0x50] as IID_IAsyncOperation_1_Windows_Devices_Midi_MidiSynthesizer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionColorFrameSource> => [0x9647fec8,0x2c56,0x5348,0x86,0xc8,0xa9,0xc3,0xa9,0x7f,0xb9,0x44] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionColorFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionDepthCorrelatedCameraIntrinsics> => [0x702b0f49,0xa742,0x5c3a,0xab,0xd6,0x77,0xf9,0x99,0x9b,0x8a,0x09] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionDepthCorrelatedCameraIntrinsics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionDepthCorrelatedCoordinateMapper> => [0xf04b9d99,0xc0d5,0x5b48,0x9a,0xe5,0x98,0x02,0x09,0x3c,0xb4,0x5e] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionDepthCorrelatedCoordinateMapper }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionDepthFrameSource> => [0x4382b038,0xd4b1,0x540b,0x85,0x9a,0x70,0x16,0x62,0x6b,0xb9,0x9d] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionDepthFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionFrameSourceAccessStatus> => [0x2c2f22a8,0xf383,0x5802,0xba,0x2c,0x0c,0xbb,0xcd,0x98,0x9c,0x9a] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionFrameSourceAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionFrameSourcePropertyChangeResult> => [0x4a7bcb69,0x2b09,0x55d1,0xaf,0x68,0xb5,0xaa,0x5c,0x2c,0x64,0x71] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionFrameSourcePropertyChangeResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::perception::PerceptionInfraredFrameSource> => [0x55122e42,0xcc65,0x5ccd,0x8f,0x6c,0x84,0xce,0xd0,0x9d,0xb2,0x4e] as IID_IAsyncOperation_1_Windows_Devices_Perception_PerceptionInfraredFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::BarcodeScanner> => [0x616494dd,0x30a2,0x523f,0xb1,0xa2,0x9a,0x11,0x74,0xde,0x3b,0x17] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_BarcodeScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::BarcodeSymbologyAttributes> => [0x461550ca,0x7bb3,0x5ade,0xa6,0x42,0x61,0xb8,0xfe,0xf2,0xe3,0x5c] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_BarcodeSymbologyAttributes }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::CashDrawer> => [0x45007467,0x92f2,0x5bff,0xb1,0x91,0xaa,0x50,0x00,0xfe,0xdd,0x9e] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_CashDrawer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::ClaimedBarcodeScanner> => [0xc9704809,0xa0e2,0x5e1d,0x87,0xcf,0x75,0xa1,0xd4,0x9d,0x7b,0xdb] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_ClaimedBarcodeScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::ClaimedCashDrawer> => [0x9230e7aa,0x20a0,0x5752,0x9c,0x20,0x4b,0xf4,0x49,0x34,0xa8,0x7e] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_ClaimedCashDrawer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::ClaimedLineDisplay> => [0x4bd0a904,0x1aaa,0x545a,0x8c,0xbc,0x1d,0x45,0xc3,0xe8,0x0e,0x5e] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_ClaimedLineDisplay }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::ClaimedMagneticStripeReader> => [0x41630bd4,0xf45a,0x590d,0x8a,0x4e,0xf7,0x0c,0x9e,0x49,0xad,0x01] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_ClaimedMagneticStripeReader }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::ClaimedPosPrinter> => [0xb4476f95,0x355a,0x503d,0xb8,0x44,0x17,0x56,0xc8,0xcf,0xda,0x98] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_ClaimedPosPrinter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::LineDisplay> => [0x40ffdae9,0xe7c1,0x5c44,0x91,0xb4,0xbd,0x84,0xeb,0xf8,0x53,0x9b] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_LineDisplay }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::LineDisplayPowerStatus> => [0x363eedcd,0x7922,0x5503,0x90,0x09,0x1c,0x63,0x1c,0x9e,0x36,0x53] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_LineDisplayPowerStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::LineDisplayStoredBitmap> => [0xdda5d77d,0xb7a1,0x541d,0xa4,0x80,0x3d,0x46,0xbe,0xd9,0x8e,0x9d] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_LineDisplayStoredBitmap }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::LineDisplayWindow> => [0x9755f05b,0x64cc,0x5051,0x83,0x50,0x4a,0xcf,0x1f,0xfc,0xbe,0x58] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_LineDisplayWindow }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::MagneticStripeReader> => [0x93726e09,0x817c,0x5f33,0xbe,0xe4,0x09,0x0d,0xe7,0x07,0x4f,0x19] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_MagneticStripeReader }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pointofservice::PosPrinter> => [0x024f77ce,0x51c3,0x5afc,0x9f,0x30,0x24,0xb3,0xc0,0xf3,0xb2,0x5a] as IID_IAsyncOperation_1_Windows_Devices_PointOfService_PosPrinter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::power::Battery> => [0xdaa3d556,0x1529,0x56d2,0xa5,0xf8,0xbf,0xb6,0xc2,0x2a,0x3d,0xfe] as IID_IAsyncOperation_1_Windows_Devices_Power_Battery }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::printers::Print3DDevice> => [0x7cfc4a8f,0x5eb7,0x5af7,0xbc,0x9f,0x78,0xa7,0xe4,0x07,0xcd,0x2e] as IID_IAsyncOperation_1_Windows_Devices_Printers_Print3DDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::pwm::PwmController> => [0x0a288d41,0x1f20,0x5d16,0x85,0xdd,0x52,0x85,0x5b,0x11,0x56,0x9a] as IID_IAsyncOperation_1_Windows_Devices_Pwm_PwmController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::radios::Radio> => [0xeac62c40,0x8dbc,0x5854,0x8b,0xa0,0xb7,0xb9,0x94,0x0e,0x73,0x89] as IID_IAsyncOperation_1_Windows_Devices_Radios_Radio }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::radios::RadioAccessStatus> => [0x21fb30ef,0x072f,0x502c,0x98,0x98,0xd0,0xc3,0xb2,0xcd,0x9a,0xc5] as IID_IAsyncOperation_1_Windows_Devices_Radios_RadioAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::scanners::ImageScanner> => [0x75d78736,0x6c52,0x551e,0xab,0x5f,0x50,0x67,0x4f,0x32,0x34,0x31] as IID_IAsyncOperation_1_Windows_Devices_Scanners_ImageScanner }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::scanners::ImageScannerPreviewResult> => [0x2f74576f,0x0498,0x5348,0xbc,0x3b,0xa7,0x0d,0x1a,0x77,0x17,0x18] as IID_IAsyncOperation_1_Windows_Devices_Scanners_ImageScannerPreviewResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Accelerometer> => [0xfc761d3b,0x5e4d,0x5148,0xa6,0x18,0x7b,0x67,0x70,0x59,0xd0,0xb8] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Accelerometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::ActivitySensor> => [0xc33003ae,0xe7ae,0x572b,0x8d,0x55,0x7d,0xb1,0x97,0x35,0x6c,0x30] as IID_IAsyncOperation_1_Windows_Devices_Sensors_ActivitySensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::ActivitySensorReading> => [0x79a87969,0x327f,0x5b7a,0xa0,0xd3,0x73,0xea,0xb1,0x6d,0xe2,0x1c] as IID_IAsyncOperation_1_Windows_Devices_Sensors_ActivitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Barometer> => [0x51876037,0x9f36,0x5c86,0x85,0x5d,0x3d,0xdd,0x25,0x1d,0xf9,0xa8] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Barometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Compass> => [0x5297c24c,0xa6fb,0x5e03,0xa4,0xf8,0xee,0x14,0x3c,0x43,0x5d,0xf8] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Compass }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::custom::CustomSensor> => [0x7fbfbe55,0x9674,0x54e3,0xa2,0x69,0x9c,0xaa,0x82,0x0e,0xd2,0x3c] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Custom_CustomSensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Gyrometer> => [0xfcee7abf,0x1dcf,0x50cc,0xb9,0x1b,0x7a,0x1f,0x59,0xe0,0xc2,0x8b] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Gyrometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Inclinometer> => [0x84ebb496,0xb69a,0x53cd,0xb6,0x90,0xa4,0x61,0x89,0x82,0x2b,0x01] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Inclinometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::LightSensor> => [0x380e592c,0x47a0,0x5df4,0x8d,0xe2,0xb2,0xee,0xfa,0x9d,0xb8,0xad] as IID_IAsyncOperation_1_Windows_Devices_Sensors_LightSensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Magnetometer> => [0xb0455443,0xe790,0x5aa3,0x87,0x67,0x49,0x32,0x03,0x22,0x74,0xee] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Magnetometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::OrientationSensor> => [0x8ef36aa8,0x6f6d,0x538b,0xa4,0x2b,0x37,0xaf,0x73,0x69,0x04,0x9e] as IID_IAsyncOperation_1_Windows_Devices_Sensors_OrientationSensor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sensors::Pedometer> => [0x9414388f,0x1b3e,0x55f5,0x81,0x9b,0xab,0x38,0x33,0x64,0x60,0x55] as IID_IAsyncOperation_1_Windows_Devices_Sensors_Pedometer }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::serialcommunication::SerialDevice> => [0x44ef26ed,0xc1ff,0x546a,0xa4,0x6b,0x6a,0x37,0xde,0x91,0x87,0xfb] as IID_IAsyncOperation_1_Windows_Devices_SerialCommunication_SerialDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardActivationPolicyChangeResult> => [0xb8f15d35,0x2f3d,0x53aa,0xb5,0xc6,0xfa,0xca,0x4c,0x7f,0xf1,0x6e] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardActivationPolicyChangeResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardAppletIdGroupRegistration> => [0xd8030032,0x5f3c,0x50e8,0x91,0xb8,0x69,0x1c,0x45,0x46,0x09,0xe8] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardAppletIdGroupRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardChallengeContext> => [0x1c650663,0x3f68,0x599b,0xb9,0xd4,0xc3,0x50,0xf1,0x3e,0xe4,0xe4] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardChallengeContext }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardConnection> => [0x779bbc5b,0xa75c,0x5988,0x97,0x8f,0x34,0xdb,0xc6,0x29,0xd5,0x76] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardConnection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramGenerator> => [0x5dfde47d,0x9770,0x5f44,0xa9,0x83,0xf2,0xfe,0xe4,0x30,0x76,0x8e] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramGenerator }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramGeneratorOperationStatus> => [0xf5b0e1b0,0x57a7,0x5ab3,0xae,0xaa,0xd6,0xb6,0x35,0x25,0x78,0x66] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramGeneratorOperationStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult> => [0x001a0095,0x2adc,0x54c2,0x85,0x94,0x3a,0x36,0xba,0x16,0xfd,0x86] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult> => [0x2cab81a8,0x3c29,0x50d1,0x97,0x61,0x5f,0x39,0x27,0xc9,0x6d,0xca] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult> => [0x8110f6e1,0x3520,0x5cd2,0xba,0xb5,0x08,0x31,0x18,0x5d,0x2c,0x2e] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramMaterialPossessionProof> => [0x6f2eea36,0xde40,0x55b4,0x90,0xc3,0x25,0x56,0x73,0xf7,0x1b,0x2e] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPossessionProof }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardCryptogramStorageKeyInfo> => [0x2187f5a4,0x691c,0x50e1,0xbf,0x4f,0xdd,0xed,0xc3,0xe6,0x84,0xb8] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardCryptogramStorageKeyInfo }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardEmulator> => [0x1dd898f0,0xc825,0x5bf3,0x95,0x64,0x47,0x08,0x93,0x2f,0x95,0x5f] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardEmulator }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardProvisioning> => [0x6184fc80,0xb752,0x5ce8,0xa1,0x36,0xf5,0x71,0x74,0xbb,0x93,0x09] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardProvisioning }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardReader> => [0x036a830d,0xbbca,0x5cb9,0x97,0x7f,0xb2,0x9e,0xa3,0x04,0x21,0x49] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardReader }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardReaderStatus> => [0x5ae402fa,0x1f22,0x5570,0xa0,0xc8,0xb2,0x32,0x0a,0xde,0xdb,0x81] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardReaderStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::smartcards::SmartCardStatus> => [0xe2223376,0x8cf6,0x51bd,0x99,0x07,0x13,0x44,0xaa,0x66,0x5e,0x5d] as IID_IAsyncOperation_1_Windows_Devices_SmartCards_SmartCardStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sms::ISmsMessage> => [0xabf9b459,0x48c3,0x5eac,0x97,0x49,0x4c,0x6d,0xb4,0xd5,0x07,0xe6] as IID_IAsyncOperation_1_Windows_Devices_Sms_ISmsMessage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sms::SmsDevice> => [0xab710de1,0xfcbb,0x5bd6,0x9f,0x2f,0x28,0x5f,0xa9,0xfb,0x44,0xe8] as IID_IAsyncOperation_1_Windows_Devices_Sms_SmsDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::sms::SmsSendMessageResult> => [0xfc0a0b0f,0x4dcc,0x5257,0xbc,0x61,0x34,0x35,0xe3,0x02,0xce,0x1f] as IID_IAsyncOperation_1_Windows_Devices_Sms_SmsSendMessageResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::spi::SpiController> => [0xb6b0df6f,0xc097,0x5844,0x93,0xbd,0x78,0x21,0x99,0x8f,0xdb,0x8e] as IID_IAsyncOperation_1_Windows_Devices_Spi_SpiController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::spi::SpiDevice> => [0xfeb8466a,0x878f,0x577b,0xbb,0xca,0x89,0x57,0x5c,0xfc,0x56,0xe4] as IID_IAsyncOperation_1_Windows_Devices_Spi_SpiDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::usb::UsbDevice> => [0x2138c5ed,0xb71a,0x5166,0x99,0x48,0xd5,0x57,0x92,0x74,0x8f,0x5c] as IID_IAsyncOperation_1_Windows_Devices_Usb_UsbDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifi::WiFiAccessStatus> => [0xf8c75a3a,0x739a,0x57aa,0x98,0x6d,0x1f,0x76,0x04,0xd7,0xe3,0x86] as IID_IAsyncOperation_1_Windows_Devices_WiFi_WiFiAccessStatus }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifi::WiFiAdapter> => [0x1dcf739d,0x10b7,0x59e9,0xab,0x47,0x8b,0x02,0x77,0xe2,0x01,0x93] as IID_IAsyncOperation_1_Windows_Devices_WiFi_WiFiAdapter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifi::WiFiConnectionResult> => [0xffa41f49,0x4c30,0x50d3,0x95,0x49,0xe4,0xf0,0x55,0xb4,0x17,0xb4] as IID_IAsyncOperation_1_Windows_Devices_WiFi_WiFiConnectionResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifi::WiFiWpsConfigurationResult> => [0x4b721d74,0x0289,0x583c,0xa8,0x1d,0xf3,0xbe,0x03,0xea,0x59,0x6d] as IID_IAsyncOperation_1_Windows_Devices_WiFi_WiFiWpsConfigurationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifidirect::services::WiFiDirectService> => [0xc4fa2ae8,0x4ff7,0x5aa0,0xaf,0x97,0xed,0x85,0xea,0x66,0xf9,0xae] as IID_IAsyncOperation_1_Windows_Devices_WiFiDirect_Services_WiFiDirectService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifidirect::services::WiFiDirectServiceProvisioningInfo> => [0xd7fa4dc4,0x4730,0x506e,0xbf,0xf0,0x80,0x1e,0xb4,0xa8,0x31,0xa8] as IID_IAsyncOperation_1_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceProvisioningInfo }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifidirect::services::WiFiDirectServiceSession> => [0xc2da4e97,0x728b,0x5401,0xa9,0xd9,0x3a,0x01,0x85,0x45,0x0a,0xf2] as IID_IAsyncOperation_1_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceSession }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperation<super::devices::wifidirect::WiFiDirectDevice> => [0xdad01b61,0xa82d,0x566c,0xba,0x82,0x22,0x4c,0x11,0x50,0x06,0x69] as IID_IAsyncOperation_1_Windows_Devices_WiFiDirect_WiFiDirectDevice }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::input::forcefeedback::ForceFeedbackLoadEffectResult> => [0x21f834fc,0xe845,0x5ab9,0xbf,0x85,0x95,0x34,0xe2,0x39,0x77,0x98] as IID_IAsyncOperation_1_Windows_Gaming_Input_ForceFeedback_ForceFeedbackLoadEffectResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::preview::gamesenumeration::GameListEntry> => [0x37bcb2e2,0x9c6f,0x5658,0xa4,0x3b,0xed,0x28,0xfe,0x0c,0x84,0x58] as IID_IAsyncOperation_1_Windows_Gaming_Preview_GamesEnumeration_GameListEntry }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::ui::GameMonitoringPermission> => [0x5a3bf49f,0xd58f,0x58c3,0xa7,0xe1,0x1e,0xd0,0x54,0x70,0xba,0xa6] as IID_IAsyncOperation_1_Windows_Gaming_UI_GameMonitoringPermission }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::xboxlive::storage::GameSaveBlobGetResult> => [0x7023b023,0x7aed,0x526c,0xb3,0xbc,0xbe,0x12,0xe3,0x5c,0xe1,0xcf] as IID_IAsyncOperation_1_Windows_Gaming_XboxLive_Storage_GameSaveBlobGetResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::xboxlive::storage::GameSaveBlobInfoGetResult> => [0xd7b7f3b4,0x6028,0x522f,0x84,0x9d,0xa6,0x94,0x95,0xe4,0xdc,0xd0] as IID_IAsyncOperation_1_Windows_Gaming_XboxLive_Storage_GameSaveBlobInfoGetResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::xboxlive::storage::GameSaveContainerInfoGetResult> => [0xcff8afeb,0x5a18,0x5f51,0xb6,0x1b,0x94,0x38,0x87,0xf7,0x29,0xee] as IID_IAsyncOperation_1_Windows_Gaming_XboxLive_Storage_GameSaveContainerInfoGetResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::xboxlive::storage::GameSaveOperationResult> => [0x1c27fb97,0x1e1a,0x516f,0xab,0xb2,0x12,0xc1,0x8e,0x18,0x21,0x8d] as IID_IAsyncOperation_1_Windows_Gaming_XboxLive_Storage_GameSaveOperationResult }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperation<super::gaming::xboxlive::storage::GameSaveProviderGetResult> => [0x3dc36085,0x5fec,0x541b,0x96,0xcf,0x62,0x7b,0x2a,0xd8,0x0d,0x36] as IID_IAsyncOperation_1_Windows_Gaming_XboxLive_Storage_GameSaveProviderGetResult }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::BitmapDecoder> => [0xaa94d8e9,0xcaef,0x53f6,0x82,0x3d,0x91,0xb6,0xe8,0x34,0x05,0x10] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_BitmapDecoder }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::BitmapEncoder> => [0x151bd1c5,0x4675,0x5af5,0xa2,0x89,0x00,0x1e,0xdc,0x66,0xb8,0x6a] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_BitmapEncoder }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::BitmapFrame> => [0xcb1483d1,0x1464,0x5bf9,0x93,0x46,0xd5,0x37,0x73,0x5d,0xfb,0xd6] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_BitmapFrame }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::BitmapPropertySet> => [0x464ac000,0xb1f1,0x5246,0x82,0x68,0x91,0x2a,0x25,0x93,0xd8,0x89] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_BitmapPropertySet }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::ImageStream> => [0x684165be,0x0011,0x56d6,0xbe,0xbf,0x43,0x00,0x16,0xd5,0x1b,0x7a] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_ImageStream }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::PixelDataProvider> => [0x8c2dfeb0,0x6c22,0x5863,0x88,0xd8,0x85,0xc1,0xfb,0xc7,0x56,0x97] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_PixelDataProvider }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::imaging::SoftwareBitmap> => [0xc4a10980,0x714b,0x5501,0x8d,0xa2,0xdb,0xda,0xcc,0xe7,0x0f,0x73] as IID_IAsyncOperation_1_Windows_Graphics_Imaging_SoftwareBitmap }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::printing::printticket::WorkflowPrintTicket> => [0x26aedf79,0x0659,0x5a5d,0x9a,0xcf,0xb4,0x42,0x3e,0xef,0xde,0xbb] as IID_IAsyncOperation_1_Windows_Graphics_Printing_PrintTicket_WorkflowPrintTicket }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::printing::printticket::WorkflowPrintTicketValidationResult> => [0xf47c8f81,0x23ef,0x5a68,0x88,0x40,0x70,0x07,0x47,0xb1,0x09,0x99] as IID_IAsyncOperation_1_Windows_Graphics_Printing_PrintTicket_WorkflowPrintTicketValidationResult }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::printing3d::Printing3D3MFPackage> => [0x6cf2eb38,0xe068,0x5558,0x94,0xb0,0x01,0x61,0x19,0x2c,0x5f,0x19] as IID_IAsyncOperation_1_Windows_Graphics_Printing3D_Printing3D3MFPackage }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::printing3d::Printing3DMeshVerificationResult> => [0x0f9eb6c4,0x19f5,0x5be9,0x9a,0xdb,0x64,0xf2,0x4a,0xf1,0x15,0xd8] as IID_IAsyncOperation_1_Windows_Graphics_Printing3D_Printing3DMeshVerificationResult }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IAsyncOperation<super::graphics::printing3d::Printing3DModel> => [0x1b27900b,0x10d5,0x53ff,0x9a,0x34,0x4b,0x31,0xf3,0x15,0x82,0xb0] as IID_IAsyncOperation_1_Windows_Graphics_Printing3D_Printing3DModel }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IAsyncOperation<super::management::deployment::PackageVolume> => [0x0315edb6,0xdc58,0x51cc,0xa5,0x19,0x44,0x90,0x1a,0xd2,0xcf,0x15] as IID_IAsyncOperation_1_Windows_Management_Deployment_PackageVolume }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::apprecording::AppRecordingResult> => [0x2c72c716,0x30ea,0x552c,0xaa,0xca,0x51,0xd1,0x23,0x23,0x4e,0xe3] as IID_IAsyncOperation_1_Windows_Media_AppRecording_AppRecordingResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::apprecording::AppRecordingSaveScreenshotResult> => [0xa048c53e,0xe624,0x512b,0x8e,0x07,0xac,0x4e,0x64,0x39,0x1b,0x2a] as IID_IAsyncOperation_1_Windows_Media_AppRecording_AppRecordingSaveScreenshotResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::audio::CreateAudioDeviceInputNodeResult> => [0x71ab4481,0xec4a,0x5ee9,0xa3,0x42,0x3a,0x31,0x74,0x78,0x29,0xb8] as IID_IAsyncOperation_1_Windows_Media_Audio_CreateAudioDeviceInputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::audio::CreateAudioDeviceOutputNodeResult> => [0xf810d730,0xde15,0x58e0,0xa5,0xf4,0xc1,0x59,0xf7,0x36,0x69,0xed] as IID_IAsyncOperation_1_Windows_Media_Audio_CreateAudioDeviceOutputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::audio::CreateAudioFileInputNodeResult> => [0x473b06bf,0x387b,0x56ca,0xbe,0xe1,0x52,0x74,0x80,0x27,0x2b,0x0f] as IID_IAsyncOperation_1_Windows_Media_Audio_CreateAudioFileInputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::audio::CreateAudioFileOutputNodeResult> => [0x1164517d,0xe953,0x5415,0xa5,0xb3,0x42,0x49,0xa9,0x69,0xbe,0x7b] as IID_IAsyncOperation_1_Windows_Media_Audio_CreateAudioFileOutputNodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::audio::CreateAudioGraphResult> => [0x3e13b431,0x65ce,0x5bfb,0xb0,0xaa,0xfa,0xc8,0xdf,0x95,0x8b,0x95] as IID_IAsyncOperation_1_Windows_Media_Audio_CreateAudioGraphResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::AdvancedCapturedPhoto> => [0x8f71b217,0x61ec,0x58ab,0xa6,0x46,0xee,0xde,0x01,0x42,0xd5,0x68] as IID_IAsyncOperation_1_Windows_Media_Capture_AdvancedCapturedPhoto }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::AdvancedPhotoCapture> => [0x8eb156d9,0x2ce4,0x5ecd,0x81,0xf4,0xa0,0x87,0x31,0xfb,0x74,0xcf] as IID_IAsyncOperation_1_Windows_Media_Capture_AdvancedPhotoCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::CapturedPhoto> => [0xaf5235b1,0x4778,0x55e1,0xb4,0x9f,0x60,0x80,0x48,0xea,0x9b,0xd9] as IID_IAsyncOperation_1_Windows_Media_Capture_CapturedPhoto }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::core::VariablePhotoSequenceCapture> => [0x0327c8bc,0x3148,0x53f3,0x8a,0x3d,0xcd,0xb1,0x2e,0x49,0xe1,0x32] as IID_IAsyncOperation_1_Windows_Media_Capture_Core_VariablePhotoSequenceCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MediaFrameReader> => [0xa10cb14d,0x7935,0x5c87,0x90,0x26,0x8a,0xbe,0x79,0x2a,0x3b,0xe5] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MediaFrameReader }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MediaFrameReaderStartStatus> => [0xdb8e251a,0xadc6,0x5753,0x87,0x84,0xc4,0x4b,0x4d,0x7c,0x5b,0x07] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MediaFrameReaderStartStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MediaFrameSourceGetPropertyResult> => [0x80003979,0x4986,0x52a7,0xb2,0x27,0xae,0x6b,0xe4,0xd2,0xb5,0xcd] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MediaFrameSourceGetPropertyResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MediaFrameSourceGroup> => [0xf3256a87,0xb1cf,0x5943,0xb6,0x64,0x9f,0x19,0x36,0x7d,0x27,0x79] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MediaFrameSourceGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MediaFrameSourceSetPropertyStatus> => [0xa1507c16,0x5f84,0x586e,0x8c,0xa9,0x22,0x4f,0x37,0xe0,0xe0,0xde] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MediaFrameSourceSetPropertyStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MultiSourceMediaFrameReader> => [0x53d56be8,0xf110,0x5226,0x9c,0xe1,0xa8,0xc2,0x6a,0x57,0x25,0x76] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MultiSourceMediaFrameReader }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::frames::MultiSourceMediaFrameReaderStartStatus> => [0xa242b952,0x76aa,0x54e5,0xa1,0x3b,0xa8,0x70,0x7c,0x10,0x98,0xe1] as IID_IAsyncOperation_1_Windows_Media_Capture_Frames_MultiSourceMediaFrameReaderStartStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::LowLagMediaRecording> => [0x4febefcc,0xbec0,0x5433,0xa7,0xba,0x76,0x03,0xd1,0xed,0xc7,0xb9] as IID_IAsyncOperation_1_Windows_Media_Capture_LowLagMediaRecording }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::LowLagPhotoCapture> => [0xaf24404b,0x7e0d,0x5ffe,0xbb,0xc8,0xaa,0xf6,0xff,0xe2,0x08,0xfc] as IID_IAsyncOperation_1_Windows_Media_Capture_LowLagPhotoCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::LowLagPhotoSequenceCapture> => [0xac9f0460,0x9d14,0x5af0,0xb1,0x7b,0x37,0xea,0x2d,0x76,0xa8,0x0d] as IID_IAsyncOperation_1_Windows_Media_Capture_LowLagPhotoSequenceCapture }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::MediaCapturePauseResult> => [0x202a2618,0x5478,0x5eba,0x9b,0xd3,0x9d,0x83,0xf4,0x62,0x74,0x7e] as IID_IAsyncOperation_1_Windows_Media_Capture_MediaCapturePauseResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::capture::MediaCaptureStopResult> => [0xeb798827,0xa4a9,0x533a,0x9e,0x83,0x0f,0xb0,0x85,0xb2,0xad,0x36] as IID_IAsyncOperation_1_Windows_Media_Capture_MediaCaptureStopResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::casting::CastingConnectionErrorStatus> => [0x25c821bc,0xdeb8,0x5850,0x8a,0xf2,0xd3,0xac,0x35,0x42,0x6b,0xd2] as IID_IAsyncOperation_1_Windows_Media_Casting_CastingConnectionErrorStatus }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::casting::CastingDevice> => [0x1b4ee058,0x4c69,0x5e70,0x88,0x34,0xc1,0xd1,0x71,0xcc,0x1b,0x22] as IID_IAsyncOperation_1_Windows_Media_Casting_CastingDevice }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::casting::CastingPlaybackTypes> => [0xdff10e53,0x4c5e,0x5dba,0x92,0x69,0xcd,0x61,0x88,0x1b,0xb8,0xb3] as IID_IAsyncOperation_1_Windows_Media_Casting_CastingPlaybackTypes }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::contentrestrictions::ContentAccessRestrictionLevel> => [0x860c0179,0xbe01,0x546d,0xa9,0xce,0x59,0x56,0x46,0x4c,0x98,0xab] as IID_IAsyncOperation_1_Windows_Media_ContentRestrictions_ContentAccessRestrictionLevel }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::contentrestrictions::ContentRestrictionsBrowsePolicy> => [0xae3399b2,0xc7d5,0x5f1b,0x9f,0xb9,0xf8,0xbd,0x81,0xe9,0xf9,0xbe] as IID_IAsyncOperation_1_Windows_Media_ContentRestrictions_ContentRestrictionsBrowsePolicy }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::core::MediaStreamSample> => [0x3cdc5e86,0x4ada,0x5ef7,0x96,0x7a,0xe1,0x37,0xa4,0x62,0x19,0x07] as IID_IAsyncOperation_1_Windows_Media_Core_MediaStreamSample }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::devices::ModuleCommandResult> => [0x2e1f3d72,0xa58d,0x5b0a,0xb4,0x2d,0x36,0x60,0xc0,0x4c,0xfe,0xeb] as IID_IAsyncOperation_1_Windows_Media_Devices_ModuleCommandResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::dialprotocol::DialAppLaunchResult> => [0x4512c15e,0x1fc4,0x5648,0xbd,0x49,0x51,0x53,0x3a,0x3f,0xe6,0xb4] as IID_IAsyncOperation_1_Windows_Media_DialProtocol_DialAppLaunchResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::dialprotocol::DialAppStateDetails> => [0xe50a07a2,0x2cef,0x5fc7,0xb1,0x4c,0xd6,0xdd,0x85,0x17,0xc5,0x8e] as IID_IAsyncOperation_1_Windows_Media_DialProtocol_DialAppStateDetails }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::dialprotocol::DialAppStopResult> => [0x8598f24e,0x0d62,0x517a,0x96,0x1c,0x31,0xfc,0xa7,0x3a,0xce,0xdd] as IID_IAsyncOperation_1_Windows_Media_DialProtocol_DialAppStopResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::dialprotocol::DialDevice> => [0x471cada5,0x1ee4,0x51c0,0xb6,0xb5,0xbf,0x72,0xf5,0xf5,0x04,0x22] as IID_IAsyncOperation_1_Windows_Media_DialProtocol_DialDevice }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::editing::BackgroundAudioTrack> => [0x493dc898,0x6076,0x55f5,0xab,0x84,0xcc,0xf9,0x73,0xac,0x03,0x97] as IID_IAsyncOperation_1_Windows_Media_Editing_BackgroundAudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::editing::MediaClip> => [0xb5e699dd,0xb6f1,0x51c0,0xb7,0x52,0xe0,0x2f,0xa0,0x06,0x8d,0x79] as IID_IAsyncOperation_1_Windows_Media_Editing_MediaClip }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::editing::MediaComposition> => [0xe170e898,0xd11f,0x5054,0xab,0x13,0x10,0x80,0xa4,0x80,0x76,0x36] as IID_IAsyncOperation_1_Windows_Media_Editing_MediaComposition }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::faceanalysis::FaceDetector> => [0xc0141cd2,0x7a65,0x514c,0xbf,0xc4,0xb4,0x9e,0x99,0x1f,0x03,0xeb] as IID_IAsyncOperation_1_Windows_Media_FaceAnalysis_FaceDetector }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::faceanalysis::FaceTracker> => [0x7f32c680,0xe37e,0x539a,0x89,0x93,0x2a,0xbb,0xea,0x71,0xaf,0xda] as IID_IAsyncOperation_1_Windows_Media_FaceAnalysis_FaceTracker }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::IMediaExtension> => [0xf5cb3303,0x1c1f,0x5d30,0xb4,0x02,0xef,0xa1,0x92,0xe8,0x0c,0x49] as IID_IAsyncOperation_1_Windows_Media_IMediaExtension }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::import::PhotoImportSource> => [0xc8c5dc1e,0xeb47,0x50b8,0xb5,0xd9,0xaa,0xfe,0x1a,0x82,0x31,0x8a] as IID_IAsyncOperation_1_Windows_Media_Import_PhotoImportSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::mediaproperties::MediaEncodingProfile> => [0xd4f86f16,0xc6cf,0x57c8,0x97,0x43,0x5e,0xc2,0x0c,0x31,0xab,0x79] as IID_IAsyncOperation_1_Windows_Media_MediaProperties_MediaEncodingProfile }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::ocr::OcrResult> => [0xc7d7118e,0xae36,0x59c0,0xac,0x76,0x7b,0xad,0xee,0x71,0x1c,0x8b] as IID_IAsyncOperation_1_Windows_Media_Ocr_OcrResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::playlists::Playlist> => [0x8ffb74ab,0x912f,0x5bc1,0x87,0xfa,0x28,0x65,0xf6,0x73,0xcb,0xfc] as IID_IAsyncOperation_1_Windows_Media_Playlists_Playlist }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::protection::HdcpSetProtectionResult> => [0x5061ee0f,0x899a,0x569c,0xa0,0xa3,0xc2,0x56,0x6e,0xb8,0x81,0x42] as IID_IAsyncOperation_1_Windows_Media_Protection_HdcpSetProtectionResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::protection::playready::INDLicenseFetchResult> => [0x9b9d0c68,0x3ad2,0x5b01,0x8d,0xc7,0x6f,0x7f,0xc1,0xee,0xd6,0xf6] as IID_IAsyncOperation_1_Windows_Media_Protection_PlayReady_INDLicenseFetchResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::protection::playready::INDSendResult> => [0x6c3788a8,0x0e6d,0x5e29,0x9a,0xd1,0xd8,0x8a,0x65,0xeb,0x50,0x0b] as IID_IAsyncOperation_1_Windows_Media_Protection_PlayReady_INDSendResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::protection::playready::INDStartResult> => [0x01fab63e,0x6aab,0x54a2,0x80,0xf7,0xdb,0xed,0x22,0xf5,0x8d,0x56] as IID_IAsyncOperation_1_Windows_Media_Protection_PlayReady_INDStartResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::speechrecognition::SpeechRecognitionCompilationResult> => [0xa392249a,0xe28a,0x564a,0x9e,0x73,0x1d,0xda,0x63,0xca,0x64,0x3c] as IID_IAsyncOperation_1_Windows_Media_SpeechRecognition_SpeechRecognitionCompilationResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::speechrecognition::SpeechRecognitionResult> => [0xba3eebe8,0x8d7c,0x51f2,0x9e,0xd4,0xeb,0xaf,0xe3,0x67,0x4d,0xb4] as IID_IAsyncOperation_1_Windows_Media_SpeechRecognition_SpeechRecognitionResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::speechsynthesis::SpeechSynthesisStream> => [0xdf9d48ad,0x9cea,0x560c,0x9e,0xdc,0xcb,0x88,0x52,0xcb,0x55,0xe3] as IID_IAsyncOperation_1_Windows_Media_SpeechSynthesis_SpeechSynthesisStream }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::streaming::adaptive::AdaptiveMediaSourceCreationResult> => [0xbe0bcc1d,0xd606,0x59d2,0xb2,0xf9,0xff,0x20,0x45,0x43,0xda,0x12] as IID_IAsyncOperation_1_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceCreationResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::transcoding::PrepareTranscodeResult> => [0xf5f07c13,0x3047,0x5bab,0x8e,0xb7,0x6e,0x5d,0x7d,0x14,0xaf,0xae] as IID_IAsyncOperation_1_Windows_Media_Transcoding_PrepareTranscodeResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::transcoding::TranscodeFailureReason> => [0x02132510,0x3899,0x5257,0xbe,0xd9,0xa4,0x3e,0x51,0x49,0xd2,0x8c] as IID_IAsyncOperation_1_Windows_Media_Transcoding_TranscodeFailureReason }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperation<super::media::VideoFrame> => [0xf12e515d,0xac45,0x5153,0x96,0xb2,0xce,0x53,0xab,0x59,0x4a,0x57] as IID_IAsyncOperation_1_Windows_Media_VideoFrame }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::backgroundtransfer::DownloadOperation> => [0x43ef3a5f,0xcc7d,0x566d,0xa9,0x2a,0x4c,0xaa,0x76,0xb9,0x2a,0x1f] as IID_IAsyncOperation_1_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::backgroundtransfer::UnconstrainedTransferRequestResult> => [0xa8dc2a04,0x3f44,0x5046,0x81,0x82,0xcd,0x0e,0xc1,0x47,0xe1,0x7d] as IID_IAsyncOperation_1_Windows_Networking_BackgroundTransfer_UnconstrainedTransferRequestResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::backgroundtransfer::UploadOperation> => [0x44212ea1,0xb524,0x5aee,0xa3,0x20,0x71,0x99,0x22,0x53,0x81,0xd1] as IID_IAsyncOperation_1_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::connectivity::ConnectionProfile> => [0x5bf519ca,0x8adb,0x5ab5,0xab,0xb8,0xff,0x1b,0xbe,0x5d,0x2d,0xe8] as IID_IAsyncOperation_1_Windows_Networking_Connectivity_ConnectionProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::connectivity::ConnectionSession> => [0x94fc6211,0x4702,0x5d24,0x81,0xbf,0x17,0x0c,0xa7,0x81,0x89,0x95] as IID_IAsyncOperation_1_Windows_Networking_Connectivity_ConnectionSession }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::connectivity::ProxyConfiguration> => [0x1e7651f6,0x6562,0x59c7,0x9a,0xf3,0x87,0x56,0x63,0x6e,0xee,0xe2] as IID_IAsyncOperation_1_Windows_Networking_Connectivity_ProxyConfiguration }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::HotspotCredentialsAuthenticationResult> => [0x522781d8,0x29c8,0x5d89,0x89,0x37,0x1d,0x1c,0x20,0x32,0xf0,0xc8] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_HotspotCredentialsAuthenticationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandCellsInfo> => [0xba1101d2,0x7219,0x5421,0xa0,0x87,0x4c,0xc5,0xf1,0xf2,0x5f,0xc4] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandCellsInfo }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandDeviceServiceCommandResult> => [0x2c673aa8,0x6a35,0x50fd,0x94,0x22,0x36,0x15,0xa1,0xc2,0x8c,0xcb] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandDeviceServiceCommandResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandModemConfiguration> => [0xcdbe0003,0xdaaa,0x5c89,0x92,0xe6,0xa4,0x7f,0xfc,0x24,0x18,0xa2] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandModemConfiguration }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandModemStatus> => [0xab0d25ab,0x68cd,0x54ab,0xb1,0x9c,0x62,0x47,0x11,0x65,0x9d,0x3d] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandModemStatus }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandPinOperationResult> => [0x2f76661c,0x2f74,0x5ce2,0x99,0xf9,0x47,0xd1,0xa3,0xa1,0x36,0x33] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandPinOperationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandUiccAppReadRecordResult> => [0x27fc8483,0x30d8,0x5be3,0xbc,0x1e,0x8c,0xca,0x0b,0x24,0x1d,0xf3] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccAppReadRecordResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandUiccAppRecordDetailsResult> => [0x0774f4a6,0xbdbe,0x59ff,0xaa,0x1c,0xa6,0x2e,0x3c,0x6f,0x9d,0x37] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccAppRecordDetailsResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::MobileBroadbandUiccAppsResult> => [0xcf1ce97f,0x1a81,0x5ce6,0x8a,0xd5,0x55,0xff,0x8b,0x0e,0x8d,0x1b] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccAppsResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::NetworkOperatorTetheringOperationResult> => [0x601b30ed,0x9b7f,0x54b6,0xb6,0x1b,0x24,0xa0,0x9b,0xc5,0x63,0x04] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_NetworkOperatorTetheringOperationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::ProvisionFromXmlDocumentResults> => [0x9f8fe338,0xc6b1,0x5614,0xa1,0x4f,0x89,0x77,0xa7,0x7e,0x17,0xf2] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_ProvisionFromXmlDocumentResults }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::networkoperators::UssdReply> => [0x9dd0a063,0x6153,0x5afd,0x82,0x88,0x87,0x70,0xdd,0xcf,0xf2,0xdb] as IID_IAsyncOperation_1_Windows_Networking_NetworkOperators_UssdReply }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::pushnotifications::PushNotificationChannel> => [0x70945a09,0x331a,0x5e40,0xb8,0x54,0x66,0xb7,0xa3,0x23,0x3b,0xab] as IID_IAsyncOperation_1_Windows_Networking_PushNotifications_PushNotificationChannel }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::servicediscovery::dnssd::DnssdRegistrationResult> => [0x0c251e73,0x52c9,0x5026,0xa8,0x75,0xf6,0x85,0xa5,0x0c,0xbf,0xfd] as IID_IAsyncOperation_1_Windows_Networking_ServiceDiscovery_Dnssd_DnssdRegistrationResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::sockets::StreamSocket> => [0xfb3e3d3c,0x6fe5,0x5e27,0xa1,0x32,0x90,0x22,0x47,0xe2,0xa9,0x3e] as IID_IAsyncOperation_1_Windows_Networking_Sockets_StreamSocket }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::vpn::VpnCredential> => [0x216a6f97,0xdba1,0x5f71,0xa1,0x4b,0x28,0x18,0xad,0x3c,0x4c,0x69] as IID_IAsyncOperation_1_Windows_Networking_Vpn_VpnCredential }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::vpn::VpnManagementErrorStatus> => [0xe99b86dc,0x6b65,0x5f23,0x94,0x19,0x90,0xb5,0x58,0x52,0xf2,0x83] as IID_IAsyncOperation_1_Windows_Networking_Vpn_VpnManagementErrorStatus }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperation<super::networking::xboxlive::XboxLiveEndpointPairCreationResult> => [0xa4b9d41e,0x4b2c,0x5bf9,0xa1,0x9d,0xed,0x39,0x5b,0x23,0x82,0x3c] as IID_IAsyncOperation_1_Windows_Networking_XboxLive_XboxLiveEndpointPairCreationResult }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IAsyncOperation<super::perception::spatial::SpatialAnchorStore> => [0x1cd05e51,0x1457,0x5023,0x8f,0x5d,0xfe,0x5e,0x5a,0x95,0x34,0x23] as IID_IAsyncOperation_1_Windows_Perception_Spatial_SpatialAnchorStore }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IAsyncOperation<super::perception::spatial::SpatialPerceptionAccessStatus> => [0xb425d126,0x1069,0x563f,0xa8,0x63,0x44,0xa3,0x0a,0x8f,0x07,0x1d] as IID_IAsyncOperation_1_Windows_Perception_Spatial_SpatialPerceptionAccessStatus }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IAsyncOperation<super::perception::spatial::SpatialStageFrameOfReference> => [0xb4d8b1bf,0x1d66,0x5458,0xa5,0xdf,0x3f,0x4f,0x6c,0x36,0x6c,0x58] as IID_IAsyncOperation_1_Windows_Perception_Spatial_SpatialStageFrameOfReference }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IAsyncOperation<super::perception::spatial::surfaces::SpatialSurfaceMesh> => [0xf5938fad,0xa8a1,0x5f7e,0x94,0x40,0xbd,0xb7,0x81,0xad,0x26,0xb6] as IID_IAsyncOperation_1_Windows_Perception_Spatial_Surfaces_SpatialSurfaceMesh }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::core::MicrosoftAccountMultiFactorGetSessionsResult> => [0x544cc4e9,0xa3da,0x5398,0xa3,0x08,0xe3,0x32,0xa5,0x89,0x61,0xf6] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorGetSessionsResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::core::MicrosoftAccountMultiFactorOneTimeCodedInfo> => [0xae63588e,0x1fc2,0x58a3,0xaf,0x36,0x6f,0x67,0xb8,0x92,0x2b,0xe7] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorOneTimeCodedInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::core::MicrosoftAccountMultiFactorServiceResponse> => [0x05953b8e,0x5adb,0x51b9,0xa9,0x4a,0xad,0x03,0x00,0x30,0xb8,0xe3] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorServiceResponse }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::core::MicrosoftAccountMultiFactorUnregisteredAccountsAndSessionInfo> => [0x989f4c21,0xef69,0x56ad,0xba,0x8c,0xe5,0xd2,0x5a,0x3c,0x62,0x4e] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorUnregisteredAccountsAndSessionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::provider::SecondaryAuthenticationFactorAuthenticationResult> => [0x18b0a73c,0xdb59,0x5279,0xa7,0x6d,0x02,0x41,0x6b,0x2d,0x90,0xb6] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorAuthenticationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::provider::SecondaryAuthenticationFactorAuthenticationStageInfo> => [0x864a2317,0xb440,0x5e9e,0xae,0x55,0x45,0x50,0xbb,0x63,0x07,0xdf] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorAuthenticationStageInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::provider::SecondaryAuthenticationFactorDevicePresenceMonitoringRegistrationStatus> => [0x7f37ecea,0xe3e8,0x53fc,0xb0,0xe5,0x7a,0xa4,0x71,0x97,0x0e,0xdd] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorDevicePresenceMonitoringRegistrationStatus }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::provider::SecondaryAuthenticationFactorFinishAuthenticationStatus> => [0x9159437a,0x4397,0x546e,0xbe,0x61,0x2e,0xf1,0x61,0x71,0x7e,0x06] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorFinishAuthenticationStatus }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::identity::provider::SecondaryAuthenticationFactorRegistrationResult> => [0x05da520c,0xaba4,0x584c,0xbc,0x08,0x19,0xc5,0x38,0x9a,0x70,0xe2] as IID_IAsyncOperation_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorRegistrationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::onlineid::OnlineIdSystemTicketResult> => [0x162f5870,0x5a4a,0x503c,0x98,0x7f,0xa0,0x5a,0x13,0x12,0xd8,0xe4] as IID_IAsyncOperation_1_Windows_Security_Authentication_OnlineId_OnlineIdSystemTicketResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::onlineid::UserIdentity> => [0xb8cc25e1,0x409f,0x57f4,0xbb,0xe4,0x3b,0x95,0xb7,0x4b,0x86,0xc8] as IID_IAsyncOperation_1_Windows_Security_Authentication_OnlineId_UserIdentity }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::web::core::WebTokenRequestResult> => [0x0a815852,0x7c44,0x5674,0xb3,0xd2,0xfa,0x2e,0x4c,0x1e,0x46,0xc9] as IID_IAsyncOperation_1_Windows_Security_Authentication_Web_Core_WebTokenRequestResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::authentication::web::WebAuthenticationResult> => [0xb34952ac,0x265e,0x5947,0x87,0x35,0xe9,0x31,0x8f,0x43,0x01,0xff] as IID_IAsyncOperation_1_Windows_Security_Authentication_Web_WebAuthenticationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::KeyCredentialAttestationResult> => [0xb83d29e9,0xf4e4,0x5aa4,0x92,0xd5,0xb2,0x62,0xcb,0x40,0xc6,0x22] as IID_IAsyncOperation_1_Windows_Security_Credentials_KeyCredentialAttestationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::KeyCredentialOperationResult> => [0x6576e5b3,0x9535,0x50d6,0x98,0xf6,0xc6,0x7d,0x6a,0xac,0xa2,0xc5] as IID_IAsyncOperation_1_Windows_Security_Credentials_KeyCredentialOperationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::KeyCredentialRetrievalResult> => [0x89d0ad1e,0xbd4c,0x55b4,0x81,0x0e,0xbd,0xdd,0x4c,0xec,0x7a,0x2a] as IID_IAsyncOperation_1_Windows_Security_Credentials_KeyCredentialRetrievalResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::ui::CredentialPickerResults> => [0x83fd09a4,0x21fd,0x5c01,0x9c,0xf6,0x82,0x93,0xb2,0x92,0x9a,0x9f] as IID_IAsyncOperation_1_Windows_Security_Credentials_UI_CredentialPickerResults }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::ui::UserConsentVerificationResult> => [0xfd596ffd,0x2318,0x558f,0x9d,0xbe,0xd2,0x1d,0xf4,0x37,0x64,0xa5] as IID_IAsyncOperation_1_Windows_Security_Credentials_UI_UserConsentVerificationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::ui::UserConsentVerifierAvailability> => [0xddd384f3,0xd818,0x5d83,0xab,0x4b,0x32,0x11,0x9c,0x28,0x58,0x7c] as IID_IAsyncOperation_1_Windows_Security_Credentials_UI_UserConsentVerifierAvailability }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::WebAccount> => [0xacd76b54,0x297f,0x5a18,0x91,0x43,0x20,0xa3,0x09,0xe2,0xdf,0xd3] as IID_IAsyncOperation_1_Windows_Security_Credentials_WebAccount }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::credentials::WebAccountProvider> => [0x88c66009,0x12f7,0x58e2,0x8d,0xbe,0x6e,0xfc,0x62,0x0c,0x85,0xba] as IID_IAsyncOperation_1_Windows_Security_Credentials_WebAccountProvider }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::cryptography::certificates::CertificateChain> => [0xf618c7d4,0xaee1,0x58ae,0xaf,0xe8,0xfc,0x33,0x6d,0xaf,0x03,0x95] as IID_IAsyncOperation_1_Windows_Security_Cryptography_Certificates_CertificateChain }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::cryptography::certificates::SignatureValidationResult> => [0xf09c0bcf,0xce3b,0x5dff,0x97,0x1f,0x2c,0x3f,0xfe,0x6f,0xd0,0x4d] as IID_IAsyncOperation_1_Windows_Security_Cryptography_Certificates_SignatureValidationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::cryptography::core::CryptographicKey> => [0x81ca789b,0x98df,0x5c6a,0x95,0x31,0x96,0x62,0x38,0xe3,0xe7,0xae] as IID_IAsyncOperation_1_Windows_Security_Cryptography_Core_CryptographicKey }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::BufferProtectUnprotectResult> => [0x11f95a2e,0x2e87,0x5449,0xbc,0xa3,0xdc,0xdf,0x2a,0xe6,0xe1,0x7a] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_BufferProtectUnprotectResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::DataProtectionInfo> => [0xc8ef3f16,0xdd70,0x5e88,0x93,0x23,0x85,0xdd,0xdd,0xcd,0x2c,0xa5] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_DataProtectionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::FileProtectionInfo> => [0x67e04591,0x2d11,0x5018,0x9f,0xf0,0x0b,0x85,0x52,0x0b,0x88,0x8b] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_FileProtectionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::FileProtectionStatus> => [0x033efe7c,0x709e,0x53a8,0x8e,0x64,0xcd,0xab,0x6b,0xd1,0xed,0x59] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_FileProtectionStatus }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::ProtectedContainerExportResult> => [0xc99f0b2e,0x67ad,0x518a,0x86,0x6f,0xe3,0x9b,0x45,0x67,0xb1,0x10] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_ProtectedContainerExportResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::ProtectedContainerImportResult> => [0x384e9499,0xd491,0x5297,0xbe,0xba,0xb3,0x3a,0x3d,0x67,0xf2,0x07] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_ProtectedContainerImportResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::ProtectedFileCreateResult> => [0xd7f98a9c,0x738e,0x50f6,0x93,0xe3,0x26,0x08,0xba,0xf5,0x4b,0xe9] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_ProtectedFileCreateResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::enterprisedata::ProtectionPolicyEvaluationResult> => [0xe8d81715,0xc56c,0x5a6b,0xb7,0x38,0x5d,0xf6,0xc2,0x77,0x5b,0x7b] as IID_IAsyncOperation_1_Windows_Security_EnterpriseData_ProtectionPolicyEvaluationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IAsyncOperation<super::security::exchangeactivesyncprovisioning::EasComplianceResults> => [0xfc3a733a,0x7ded,0x5e92,0xa5,0x69,0xb4,0x33,0x89,0xee,0x88,0x27] as IID_IAsyncOperation_1_Windows_Security_ExchangeActiveSyncProvisioning_EasComplianceResults }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::cortana::CortanaPermissionsChangeResult> => [0x838a3dd0,0xf0a3,0x508f,0x84,0x6a,0xd3,0xc1,0x9e,0x4f,0xe7,0xa0] as IID_IAsyncOperation_1_Windows_Services_Cortana_CortanaPermissionsChangeResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::maps::localsearch::LocalLocationFinderResult> => [0x08e69b32,0xf420,0x5280,0xa7,0x21,0x07,0x5b,0x4f,0xd0,0x3d,0x94] as IID_IAsyncOperation_1_Windows_Services_Maps_LocalSearch_LocalLocationFinderResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::maps::MapLocationFinderResult> => [0xe5e5ee33,0xabd8,0x5695,0x9f,0xe5,0xac,0x95,0x85,0x0d,0x71,0x98] as IID_IAsyncOperation_1_Windows_Services_Maps_MapLocationFinderResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::maps::MapRouteFinderResult> => [0xecaa3e7f,0xc526,0x5097,0xb6,0x24,0xcf,0x74,0x3d,0x78,0xa9,0xba] as IID_IAsyncOperation_1_Windows_Services_Maps_MapRouteFinderResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::maps::offlinemaps::OfflineMapPackageQueryResult> => [0xc01a663d,0x6d9b,0x5385,0xae,0x68,0x0a,0x65,0xa9,0x54,0x45,0x14] as IID_IAsyncOperation_1_Windows_Services_Maps_OfflineMaps_OfflineMapPackageQueryResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::maps::offlinemaps::OfflineMapPackageStartDownloadResult> => [0x911272f7,0xf5aa,0x5393,0x94,0xa1,0xe9,0x6a,0xdf,0xad,0x3d,0xa4] as IID_IAsyncOperation_1_Windows_Services_Maps_OfflineMaps_OfflineMapPackageStartDownloadResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreAcquireLicenseResult> => [0xdd6c4705,0xa76c,0x528e,0x99,0xa5,0xcd,0xd1,0x31,0x97,0xd4,0xcf] as IID_IAsyncOperation_1_Windows_Services_Store_StoreAcquireLicenseResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreAppLicense> => [0x3866370b,0xafc6,0x5d01,0x84,0xc2,0x45,0x74,0x62,0x8d,0xe5,0x39] as IID_IAsyncOperation_1_Windows_Services_Store_StoreAppLicense }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreConsumableResult> => [0x873c497b,0xc3f7,0x5657,0xb9,0x21,0x3e,0x58,0xce,0x48,0xee,0x50] as IID_IAsyncOperation_1_Windows_Services_Store_StoreConsumableResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreProductPagedQueryResult> => [0x3079e7db,0x1ba4,0x5b9e,0x85,0x6a,0x65,0x76,0xbf,0x7f,0x9c,0x8a] as IID_IAsyncOperation_1_Windows_Services_Store_StoreProductPagedQueryResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreProductQueryResult> => [0x9699e7bb,0xea1f,0x5e03,0x94,0x39,0xc8,0x0e,0x69,0x77,0xb7,0x11] as IID_IAsyncOperation_1_Windows_Services_Store_StoreProductQueryResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreProductResult> => [0x9e61e86b,0x6afb,0x50ae,0xaf,0xc1,0xc5,0x9f,0x54,0x51,0x08,0xdd] as IID_IAsyncOperation_1_Windows_Services_Store_StoreProductResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StorePurchaseResult> => [0x33d8cc30,0x78f5,0x5f81,0xaa,0x2d,0xa4,0xfa,0x2a,0x3b,0x1c,0x68] as IID_IAsyncOperation_1_Windows_Services_Store_StorePurchaseResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::store::StoreSendRequestResult> => [0x2acdffe8,0x259c,0x5eae,0x93,0xc1,0x13,0xa2,0x3c,0x74,0xdf,0xee] as IID_IAsyncOperation_1_Windows_Services_Store_StoreSendRequestResult }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::targetedcontent::TargetedContentContainer> => [0xe757e0fc,0x0136,0x5f63,0x97,0xb8,0x6a,0x96,0xb8,0xd0,0x60,0x1e] as IID_IAsyncOperation_1_Windows_Services_TargetedContent_TargetedContentContainer }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperation<super::services::targetedcontent::TargetedContentSubscription> => [0x46f16f4b,0x8ec1,0x5c4f,0xb1,0xf5,0xa7,0xe7,0xac,0xd6,0x33,0x66] as IID_IAsyncOperation_1_Windows_Services_TargetedContent_TargetedContentSubscription }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::ApplicationData> => [0x31456b58,0xa5cb,0x5c5b,0xbd,0x6e,0xcc,0xce,0x3a,0x7b,0xf4,0xb4] as IID_IAsyncOperation_1_Windows_Storage_ApplicationData }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::fileproperties::BasicProperties> => [0x5186131a,0x4467,0x504b,0x97,0x7a,0x07,0x85,0xa8,0x23,0x04,0x85] as IID_IAsyncOperation_1_Windows_Storage_FileProperties_BasicProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::fileproperties::DocumentProperties> => [0x6c86e97c,0x5699,0x5700,0x8d,0x35,0xd3,0x50,0xad,0x3e,0x4d,0xf2] as IID_IAsyncOperation_1_Windows_Storage_FileProperties_DocumentProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::fileproperties::ImageProperties> => [0xfcd07511,0xe7f8,0x5bda,0x8c,0x04,0x79,0x5a,0x63,0x9d,0xae,0x8f] as IID_IAsyncOperation_1_Windows_Storage_FileProperties_ImageProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::fileproperties::MusicProperties> => [0x0d023b76,0x20a7,0x56f3,0x84,0xab,0xce,0x31,0xe6,0x54,0x4b,0x71] as IID_IAsyncOperation_1_Windows_Storage_FileProperties_MusicProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::fileproperties::StorageItemThumbnail> => [0x11c7cc5e,0xc04e,0x50e7,0xa6,0x5e,0x6f,0x69,0x03,0x69,0x0c,0x16] as IID_IAsyncOperation_1_Windows_Storage_FileProperties_StorageItemThumbnail }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::fileproperties::VideoProperties> => [0x447d4590,0xd3f9,0x58bf,0xac,0x58,0x6f,0x9a,0x50,0x83,0x9e,0xfe] as IID_IAsyncOperation_1_Windows_Storage_FileProperties_VideoProperties }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::IStorageItem> => [0x5fc9c137,0xebb7,0x5e6c,0x9c,0xba,0x68,0x6f,0x2e,0xc2,0xb0,0xbb] as IID_IAsyncOperation_1_Windows_Storage_IStorageItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::provider::FileUpdateStatus> => [0x8f0f439e,0x87d0,0x531f,0x85,0xb1,0x54,0xf4,0x52,0x8f,0x29,0xc3] as IID_IAsyncOperation_1_Windows_Storage_Provider_FileUpdateStatus }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::search::IndexedState> => [0x88694b1f,0xf380,0x574d,0x8a,0x05,0x4f,0x67,0xbd,0x52,0xcd,0x11] as IID_IAsyncOperation_1_Windows_Storage_Search_IndexedState }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::StorageFile> => [0x5e52f8ce,0xaced,0x5a42,0x95,0xb4,0xf6,0x74,0xdd,0x84,0x88,0x5e] as IID_IAsyncOperation_1_Windows_Storage_StorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::StorageFolder> => [0x6be9e7d7,0xe83a,0x5cbc,0x80,0x2c,0x17,0x68,0x96,0x0b,0x52,0xc3] as IID_IAsyncOperation_1_Windows_Storage_StorageFolder }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::StorageLibrary> => [0x2f160a19,0x99c1,0x52b9,0x8d,0xca,0x14,0xe4,0xab,0x79,0xf2,0x87] as IID_IAsyncOperation_1_Windows_Storage_StorageLibrary }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::StorageStreamTransaction> => [0x0d81405a,0x9bd3,0x5e87,0x82,0xf4,0x9b,0x41,0x28,0xa8,0x87,0xeb] as IID_IAsyncOperation_1_Windows_Storage_StorageStreamTransaction }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::IBuffer> => [0x3bee8834,0xb9a7,0x5a80,0xa7,0x46,0x5e,0xf0,0x97,0x22,0x78,0x78] as IID_IAsyncOperation_1_Windows_Storage_Streams_IBuffer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::IInputStream> => [0xa8fe0732,0x556d,0x5841,0xb7,0xee,0xb3,0x45,0x0f,0xb5,0x26,0x66] as IID_IAsyncOperation_1_Windows_Storage_Streams_IInputStream }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::IOutputStream> => [0xe8736833,0xd013,0x5361,0x97,0x7d,0xc5,0xe9,0x99,0x34,0x68,0x0e] as IID_IAsyncOperation_1_Windows_Storage_Streams_IOutputStream }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::IRandomAccessStream> => [0x430ecece,0x1418,0x5d19,0x81,0xb2,0x5d,0xdb,0x38,0x16,0x03,0xcc] as IID_IAsyncOperation_1_Windows_Storage_Streams_IRandomAccessStream }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::IRandomAccessStreamReference> => [0x65178d50,0xe6a2,0x5d16,0xb2,0x44,0x65,0xe9,0x72,0x5e,0x5a,0x0c] as IID_IAsyncOperation_1_Windows_Storage_Streams_IRandomAccessStreamReference }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::IRandomAccessStreamWithContentType> => [0xc4a57c5e,0x32b0,0x55b3,0xad,0x13,0xce,0x1c,0x23,0x04,0x1e,0xd6] as IID_IAsyncOperation_1_Windows_Storage_Streams_IRandomAccessStreamWithContentType }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperation<super::storage::streams::RandomAccessStreamReference> => [0xd90442ca,0x543c,0x504b,0x9e,0xb9,0x29,0x4b,0xca,0xd8,0xa2,0x83] as IID_IAsyncOperation_1_Windows_Storage_Streams_RandomAccessStreamReference }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::DiagnosticAccessStatus> => [0x61c11bbe,0x2618,0x588a,0xa7,0xca,0xf6,0x06,0x91,0x27,0x23,0x24] as IID_IAsyncOperation_1_Windows_System_DiagnosticAccessStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::LaunchQuerySupportStatus> => [0xe7539992,0x2220,0x5d2d,0x82,0xc4,0x3d,0x44,0xf8,0x75,0x0d,0x91] as IID_IAsyncOperation_1_Windows_System_LaunchQuerySupportStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::LaunchUriResult> => [0x7f97fc15,0x1cd6,0x54b7,0xa2,0x90,0xac,0xb6,0x0d,0xba,0x81,0xa1] as IID_IAsyncOperation_1_Windows_System_LaunchUriResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::LaunchUriStatus> => [0xab3d721b,0xa4f3,0x5861,0xb0,0x34,0x03,0x0b,0x15,0x23,0x3c,0x52] as IID_IAsyncOperation_1_Windows_System_LaunchUriStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::ProcessLauncherResult> => [0xe6827240,0x7a8d,0x51be,0x8d,0x21,0xe0,0x93,0x26,0x8c,0xcc,0x15] as IID_IAsyncOperation_1_Windows_System_ProcessLauncherResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::RemoteLaunchUriStatus> => [0xbb70e5cd,0x62c2,0x5f78,0xac,0x8d,0xf4,0xb9,0x73,0x98,0x1d,0xa4] as IID_IAsyncOperation_1_Windows_System_RemoteLaunchUriStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::remotesystems::RemoteSystem> => [0x0d39f546,0x0eca,0x5236,0xa5,0xca,0x7e,0x36,0x60,0x65,0x84,0x62] as IID_IAsyncOperation_1_Windows_System_RemoteSystems_RemoteSystem }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::remotesystems::RemoteSystemAccessStatus> => [0xd76da678,0xdd76,0x5460,0x87,0x45,0x91,0x5b,0x44,0x10,0xc9,0x05] as IID_IAsyncOperation_1_Windows_System_RemoteSystems_RemoteSystemAccessStatus }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::remotesystems::RemoteSystemSessionCreationResult> => [0x90364bf5,0xd084,0x5f50,0x97,0x29,0x82,0x02,0x53,0x26,0xab,0xef] as IID_IAsyncOperation_1_Windows_System_RemoteSystems_RemoteSystemSessionCreationResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::remotesystems::RemoteSystemSessionJoinResult> => [0xc58dbd1e,0xe300,0x55a8,0xad,0xa5,0xe2,0x5a,0xaa,0xa8,0x66,0x67] as IID_IAsyncOperation_1_Windows_System_RemoteSystems_RemoteSystemSessionJoinResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::User> => [0xa895d2f9,0x2399,0x5104,0xa5,0x32,0x5b,0xa4,0x4a,0xb4,0xb1,0x65] as IID_IAsyncOperation_1_Windows_System_User }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::userprofile::SetAccountPictureResult> => [0x6809e406,0x6d3b,0x5164,0x8f,0x32,0xb8,0x45,0xb0,0x78,0x14,0x05] as IID_IAsyncOperation_1_Windows_System_UserProfile_SetAccountPictureResult }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperation<super::system::userprofile::SetImageFeedResult> => [0x5361bfc9,0x0740,0x544a,0x97,0x97,0x1f,0xfe,0x5e,0x73,0xc5,0x4e] as IID_IAsyncOperation_1_Windows_System_UserProfile_SetImageFeedResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::input::inking::analysis::InkAnalysisResult> => [0x2c46d1bd,0x6dbb,0x5007,0xba,0x85,0x3d,0x01,0x06,0xbd,0xdf,0x50] as IID_IAsyncOperation_1_Windows_UI_Input_Inking_Analysis_InkAnalysisResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::notifications::management::UserNotificationListenerAccessStatus> => [0x0fbad8c7,0x086f,0x5bf9,0x81,0xe2,0x8d,0x79,0xe7,0x18,0x48,0x03] as IID_IAsyncOperation_1_Windows_UI_Notifications_Management_UserNotificationListenerAccessStatus }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::notifications::ToastCollection> => [0x9310ec47,0x9f0a,0x5999,0x80,0xc2,0x4b,0x31,0xe9,0xf7,0x7e,0x8e] as IID_IAsyncOperation_1_Windows_UI_Notifications_ToastCollection }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::notifications::ToastNotificationHistory> => [0x2a22fecb,0x4b96,0x551f,0xb7,0xb9,0xa7,0xb5,0xbe,0xec,0xad,0x05] as IID_IAsyncOperation_1_Windows_UI_Notifications_ToastNotificationHistory }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::notifications::ToastNotifier> => [0x2dddc10e,0x38e6,0x5655,0xad,0xf3,0x82,0x0e,0x8f,0xb1,0x4d,0xcc] as IID_IAsyncOperation_1_Windows_UI_Notifications_ToastNotifier }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::popups::IUICommand> => [0xb8770535,0x6a4b,0x52b1,0xb5,0x78,0xf3,0xcd,0xc5,0x00,0x7a,0x1f] as IID_IAsyncOperation_1_Windows_UI_Popups_IUICommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::startscreen::JumpList> => [0x1c008c58,0x733b,0x5b42,0x96,0x2a,0xb3,0x33,0x28,0x23,0x6c,0xd3] as IID_IAsyncOperation_1_Windows_UI_StartScreen_JumpList }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::xaml::controls::ContentDialogResult> => [0x1f23bdd1,0x06dc,0x5be9,0x9a,0x60,0x0b,0x4d,0x94,0xd4,0xd7,0x2c] as IID_IAsyncOperation_1_Windows_UI_Xaml_Controls_ContentDialogResult }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::xaml::controls::maps::MapModel3D> => [0x0cf0240f,0x7f78,0x535b,0x85,0x0c,0xfe,0x62,0x31,0x75,0x90,0x64] as IID_IAsyncOperation_1_Windows_UI_Xaml_Controls_Maps_MapModel3D }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::xaml::controls::maps::StreetsidePanorama> => [0x6ad8ea47,0x6670,0x51d8,0xa1,0xdb,0x33,0xfe,0x75,0x49,0x1f,0x0c] as IID_IAsyncOperation_1_Windows_UI_Xaml_Controls_Maps_StreetsidePanorama }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::xaml::data::LoadMoreItemsResult> => [0xc788089d,0x37ab,0x5ba2,0xb8,0x65,0x5a,0x30,0x9a,0xcd,0xfc,0x4d] as IID_IAsyncOperation_1_Windows_UI_Xaml_Data_LoadMoreItemsResult }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::xaml::hosting::DesignerAppView> => [0x49c6c658,0x1bd2,0x581e,0xa3,0x85,0x6e,0xb3,0xfd,0x9b,0xfe,0xe3] as IID_IAsyncOperation_1_Windows_UI_Xaml_Hosting_DesignerAppView }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IAsyncOperation<super::ui::xaml::media::imaging::SvgImageSourceLoadStatus> => [0xf19df5c2,0x2b78,0x53a9,0x8d,0x38,0x5c,0xa8,0xdb,0xb5,0xdb,0xc6] as IID_IAsyncOperation_1_Windows_UI_Xaml_Media_Imaging_SvgImageSourceLoadStatus }
RT_PINTERFACE!{ for IAsyncOperation<u32> => [0xef60385f,0xbe78,0x584b,0xaa,0xef,0x78,0x29,0xad,0xa2,0xb0,0xde] as IID_IAsyncOperation_1_System_UInt32 }
RT_PINTERFACE!{ for IAsyncOperation<u64> => [0x2a70d630,0x0767,0x5f0a,0xa1,0xc2,0xde,0xb0,0x81,0x26,0xe2,0x6e] as IID_IAsyncOperation_1_System_UInt64 }
RT_PINTERFACE!{ for IAsyncOperation<Uri> => [0x641cb9dd,0xa28d,0x59e2,0xb8,0xdb,0xa2,0x27,0xed,0xa6,0xcf,0x2e] as IID_IAsyncOperation_1_Windows_Foundation_Uri }
RT_PINTERFACE!{ for IAsyncOperationWithProgress<bool, f64> => [0xaf873c66,0x2df0,0x5a95,0xab,0x54,0x25,0x63,0x4d,0xa3,0xff,0xa9] as IID_IAsyncOperationWithProgress_2_System_Boolean_System_Double }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<collections::IVectorView<super::devices::sms::ISmsMessage>, i32> => [0x12f85589,0x415d,0x5b5d,0xb0,0xd0,0xfd,0xa3,0xb0,0x29,0x5a,0xdc] as IID_IAsyncOperationWithProgress_2_Windows_Foundation_Collections_IVectorView_1_Windows_Devices_Sms_ISmsMessage__System_Int32 }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<HString, super::web::http::HttpProgress> => [0x91ecbe45,0xe889,0x5518,0xbd,0x8d,0xc5,0xbd,0xe1,0x63,0x10,0x9b] as IID_IAsyncOperationWithProgress_2_System_String_Windows_Web_Http_HttpProgress }
RT_PINTERFACE!{ for IAsyncOperationWithProgress<HString, u64> => [0xc8bbcb29,0x6b64,0x5ce2,0xa8,0x31,0x03,0x8f,0x6e,0x02,0x19,0x9e] as IID_IAsyncOperationWithProgress_2_System_String_System_UInt64 }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::devices::scanners::ImageScannerScanResult, u32> => [0x6e6e228a,0xf618,0x5d33,0x85,0x23,0x02,0xd1,0x66,0x72,0x66,0x5b] as IID_IAsyncOperationWithProgress_2_Windows_Devices_Scanners_ImageScannerScanResult_System_UInt32 }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::gaming::input::custom::GipFirmwareUpdateResult, super::gaming::input::custom::GipFirmwareUpdateProgress> => [0xbfaa48bd,0x155f,0x5112,0xbd,0x86,0xe0,0x1d,0x6f,0x7c,0xd4,0x05] as IID_IAsyncOperationWithProgress_2_Windows_Gaming_Input_Custom_GipFirmwareUpdateResult_Windows_Gaming_Input_Custom_GipFirmwareUpdateProgress }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::management::deployment::DeploymentResult, super::management::deployment::DeploymentProgress> => [0x5a97aab7,0xb6ea,0x55ac,0xa5,0xdc,0xd5,0xb1,0x64,0xd9,0x4e,0x94] as IID_IAsyncOperationWithProgress_2_Windows_Management_Deployment_DeploymentResult_Windows_Management_Deployment_DeploymentProgress }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::media::core::LowLightFusionResult, f64> => [0xa2302c2d,0x66b5,0x59c7,0xab,0x97,0x3f,0x57,0x93,0xe2,0x1d,0x43] as IID_IAsyncOperationWithProgress_2_Windows_Media_Core_LowLightFusionResult_System_Double }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::media::import::PhotoImportDeleteImportedItemsFromSourceResult, f64> => [0x3e2371a9,0x281a,0x5226,0xae,0x85,0xca,0xa5,0x5c,0x0d,0x61,0xde] as IID_IAsyncOperationWithProgress_2_Windows_Media_Import_PhotoImportDeleteImportedItemsFromSourceResult_System_Double }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::media::import::PhotoImportFindItemsResult, u32> => [0x6e6f9b4e,0xc6e1,0x5364,0xa6,0x50,0x11,0xc3,0x52,0x11,0xbe,0xad] as IID_IAsyncOperationWithProgress_2_Windows_Media_Import_PhotoImportFindItemsResult_System_UInt32 }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::media::import::PhotoImportImportItemsResult, super::media::import::PhotoImportProgress> => [0xd874ec64,0x0951,0x5459,0xa0,0xdd,0x0f,0x8b,0xf3,0x91,0x7e,0xb1] as IID_IAsyncOperationWithProgress_2_Windows_Media_Import_PhotoImportImportItemsResult_Windows_Media_Import_PhotoImportProgress }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::media::protection::RenewalStatus, u32> => [0x595dcc09,0x9ad3,0x5094,0x80,0x0a,0x08,0x83,0xcc,0xe1,0xef,0x01] as IID_IAsyncOperationWithProgress_2_Windows_Media_Protection_RenewalStatus_System_UInt32 }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::media::transcoding::TranscodeFailureReason, f64> => [0x272eec20,0x4b64,0x5d53,0xa6,0x44,0xf9,0x91,0x7b,0x3d,0x19,0xd8] as IID_IAsyncOperationWithProgress_2_Windows_Media_Transcoding_TranscodeFailureReason_System_Double }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::networking::backgroundtransfer::DownloadOperation, super::networking::backgroundtransfer::DownloadOperation> => [0xe86a4f5d,0x743a,0x5f18,0x9d,0x4c,0xbc,0x8e,0xd5,0x94,0x26,0x59] as IID_IAsyncOperationWithProgress_2_Windows_Networking_BackgroundTransfer_DownloadOperation_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::networking::backgroundtransfer::UploadOperation, super::networking::backgroundtransfer::UploadOperation> => [0x35ddaefa,0xdb6a,0x5d0d,0xba,0x54,0xa0,0x72,0x84,0x01,0x17,0x1e] as IID_IAsyncOperationWithProgress_2_Windows_Networking_BackgroundTransfer_UploadOperation_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::services::store::StorePackageUpdateResult, super::services::store::StorePackageUpdateStatus> => [0x42c436ca,0x51f7,0x50b2,0x8f,0xe4,0x7b,0x75,0x40,0x62,0xe6,0xeb] as IID_IAsyncOperationWithProgress_2_Windows_Services_Store_StorePackageUpdateResult_Windows_Services_Store_StorePackageUpdateStatus }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::storage::streams::IBuffer, super::web::http::HttpProgress> => [0x88d9bb75,0xafb4,0x5f32,0x9d,0x7e,0xd3,0xbf,0x37,0x85,0x35,0x4c] as IID_IAsyncOperationWithProgress_2_Windows_Storage_Streams_IBuffer_Windows_Web_Http_HttpProgress }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::storage::streams::IBuffer, u32> => [0xd26b2819,0x897f,0x5c7d,0x84,0xd6,0x56,0xd7,0x96,0x56,0x14,0x31] as IID_IAsyncOperationWithProgress_2_Windows_Storage_Streams_IBuffer_System_UInt32 }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::storage::streams::IBuffer, u64> => [0xad960e7f,0xd73b,0x56e4,0xa5,0x8c,0x6e,0xc7,0x67,0x8c,0xfd,0x88] as IID_IAsyncOperationWithProgress_2_Windows_Storage_Streams_IBuffer_System_UInt64 }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::storage::streams::IInputStream, super::web::http::HttpProgress> => [0x0b97c784,0xdf17,0x571f,0x83,0x37,0x44,0x7d,0xff,0x06,0x8a,0x9c] as IID_IAsyncOperationWithProgress_2_Windows_Storage_Streams_IInputStream_Windows_Web_Http_HttpProgress }
#[cfg(all(feature="windows-storage",feature="windows-web"))] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::storage::streams::IInputStream, super::web::syndication::RetrievalProgress> => [0xf71cff65,0xe737,0x5345,0xb3,0x8f,0xfd,0x44,0x5d,0x2d,0xc7,0xe2] as IID_IAsyncOperationWithProgress_2_Windows_Storage_Streams_IInputStream_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::storage::streams::IInputStream, u64> => [0x455aa601,0xf13e,0x5dee,0xb9,0xcb,0x16,0xb5,0x31,0x99,0x63,0x27] as IID_IAsyncOperationWithProgress_2_Windows_Storage_Streams_IInputStream_System_UInt64 }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::system::diagnostics::DiagnosticActionResult, super::system::diagnostics::DiagnosticActionState> => [0xbb5d493e,0x74e9,0x57a1,0x8c,0x4c,0x92,0x3e,0x0d,0xc4,0x56,0x5b] as IID_IAsyncOperationWithProgress_2_Windows_System_Diagnostics_DiagnosticActionResult_Windows_System_Diagnostics_DiagnosticActionState }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::web::atompub::ServiceDocument, super::web::syndication::RetrievalProgress> => [0xda07abf4,0x91fa,0x5c96,0x84,0xcb,0x45,0x9e,0xa9,0x7b,0x93,0x4d] as IID_IAsyncOperationWithProgress_2_Windows_Web_AtomPub_ServiceDocument_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::web::http::HttpResponseMessage, super::web::http::HttpProgress> => [0x5d144364,0x77d7,0x5eca,0x8b,0x09,0x93,0x6a,0x69,0x44,0x66,0x52] as IID_IAsyncOperationWithProgress_2_Windows_Web_Http_HttpResponseMessage_Windows_Web_Http_HttpProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::web::syndication::SyndicationFeed, super::web::syndication::RetrievalProgress> => [0x92eaf151,0x415e,0x5f87,0x80,0x95,0x78,0x16,0x23,0xc8,0x89,0x98] as IID_IAsyncOperationWithProgress_2_Windows_Web_Syndication_SyndicationFeed_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::web::syndication::SyndicationItem, super::web::syndication::RetrievalProgress> => [0x44fa5a15,0x1204,0x521c,0x85,0xe5,0x01,0x25,0x93,0x01,0xd5,0x27] as IID_IAsyncOperationWithProgress_2_Windows_Web_Syndication_SyndicationItem_Windows_Web_Syndication_RetrievalProgress }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IAsyncOperationWithProgress<super::web::syndication::SyndicationItem, super::web::syndication::TransferProgress> => [0xe57d0717,0x27c0,0x561e,0xb4,0xb3,0x72,0xaa,0x2b,0x1e,0x3f,0xc9] as IID_IAsyncOperationWithProgress_2_Windows_Web_Syndication_SyndicationItem_Windows_Web_Syndication_TransferProgress }
RT_PINTERFACE!{ for IAsyncOperationWithProgress<u32, u32> => [0xeccb574a,0xc684,0x5572,0xa6,0x79,0x6b,0x08,0x42,0xcf,0xb5,0x7f] as IID_IAsyncOperationWithProgress_2_System_UInt32_System_UInt32 }
RT_PINTERFACE!{ for IAsyncOperationWithProgress<u64, u64> => [0x8f1db6e3,0x6556,0x5516,0x82,0x5c,0x10,0x21,0xee,0x27,0xcd,0x0c] as IID_IAsyncOperationWithProgress_2_System_UInt64_System_UInt64 }
RT_PINTERFACE!{ for IReference<bool> => [0x3c00fd60,0x2950,0x5939,0xa2,0x1a,0x2d,0x12,0xc5,0xa0,0x1b,0x8a] as IID_IReference_1_System_Boolean }
RT_PINTERFACE!{ for IReference<Char> => [0xfb393ef3,0xbbac,0x5bd5,0x91,0x44,0x84,0xf2,0x35,0x76,0xf4,0x15] as IID_IReference_1_System_Char }
RT_PINTERFACE!{ for IReference<DateTime> => [0x5541d8a7,0x497c,0x5aa4,0x86,0xfc,0x77,0x13,0xad,0xbf,0x2a,0x2c] as IID_IReference_1_Windows_Foundation_DateTime }
RT_PINTERFACE!{ for IReference<f32> => [0x719cc2ba,0x3e76,0x5def,0x9f,0x1a,0x38,0xd8,0x5a,0x14,0x5e,0xa8] as IID_IReference_1_System_Single }
RT_PINTERFACE!{ for IReference<f64> => [0x2f2d6c29,0x5473,0x5f3e,0x92,0xe7,0x96,0x57,0x2b,0xb9,0x90,0xe2] as IID_IReference_1_System_Double }
RT_PINTERFACE!{ for IReference<Guid> => [0x7d50f649,0x632c,0x51f9,0x84,0x9a,0xee,0x49,0x42,0x89,0x33,0xea] as IID_IReference_1_System_Guid }
RT_PINTERFACE!{ for IReference<HString> => [0xfd416dfb,0x2a07,0x52eb,0xaa,0xe3,0xdf,0xce,0x14,0x11,0x6c,0x05] as IID_IReference_1_System_String }
RT_PINTERFACE!{ for IReference<i16> => [0x6ec9e41b,0x6709,0x5647,0x99,0x18,0xa1,0x27,0x01,0x10,0xfc,0x4e] as IID_IReference_1_System_Int16 }
RT_PINTERFACE!{ for IReference<i32> => [0x548cefbd,0xbc8a,0x5fa0,0x8d,0xf2,0x95,0x74,0x40,0xfc,0x8b,0xf4] as IID_IReference_1_System_Int32 }
RT_PINTERFACE!{ for IReference<i64> => [0x4dda9e24,0xe69f,0x5c6a,0xa0,0xa6,0x93,0x42,0x73,0x65,0xaf,0x2a] as IID_IReference_1_System_Int64 }
RT_PINTERFACE!{ for IReference<i8> => [0x95500129,0xfbf6,0x5afc,0x89,0xdf,0x70,0x64,0x2d,0x74,0x19,0x90] as IID_IReference_1_System_SByte }
RT_PINTERFACE!{ for IReference<IInspectable> => [0x06dccc90,0xa058,0x5c88,0x87,0xb7,0x6f,0x33,0x60,0xa2,0xfc,0x16] as IID_IReference_1_System_Object }
RT_PINTERFACE!{ for IReference<numerics::Matrix4x4> => [0xdacbffdc,0x68ef,0x5fd0,0xb6,0x57,0x78,0x2d,0x0a,0xc9,0x80,0x7e] as IID_IReference_1_Windows_Foundation_Numerics_Matrix4x4 }
RT_PINTERFACE!{ for IReference<numerics::Quaternion> => [0xb27004bb,0xc014,0x5dce,0x9a,0x21,0x79,0x9c,0x5a,0x3c,0x14,0x61] as IID_IReference_1_Windows_Foundation_Numerics_Quaternion }
RT_PINTERFACE!{ for IReference<numerics::Vector2> => [0x48f6a69e,0x8465,0x57ae,0x94,0x00,0x97,0x64,0x08,0x7f,0x65,0xad] as IID_IReference_1_Windows_Foundation_Numerics_Vector2 }
RT_PINTERFACE!{ for IReference<numerics::Vector3> => [0x1ee770ff,0xc954,0x59ca,0xa7,0x54,0x61,0x99,0xa9,0xbe,0x28,0x2c] as IID_IReference_1_Windows_Foundation_Numerics_Vector3 }
RT_PINTERFACE!{ for IReference<Point> => [0x84f14c22,0xa00a,0x5272,0x8d,0x3d,0x82,0x11,0x2e,0x66,0xdf,0x00] as IID_IReference_1_Windows_Foundation_Point }
RT_PINTERFACE!{ for IReference<Rect> => [0x80423f11,0x054f,0x5eac,0xaf,0xd3,0x63,0xb6,0xce,0x15,0xe7,0x7b] as IID_IReference_1_Windows_Foundation_Rect }
RT_PINTERFACE!{ for IReference<Size> => [0x61723086,0x8e53,0x5276,0x9f,0x36,0x2a,0x4b,0xb9,0x3e,0x2b,0x75] as IID_IReference_1_Windows_Foundation_Size }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IReference<super::applicationmodel::email::EmailMailboxSmimeEncryptionAlgorithm> => [0x433b124d,0x60e6,0x5b7a,0x96,0xbc,0x86,0x81,0xde,0x5f,0x5e,0x75] as IID_IReference_1_Windows_ApplicationModel_Email_EmailMailboxSmimeEncryptionAlgorithm }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IReference<super::applicationmodel::email::EmailMailboxSmimeSigningAlgorithm> => [0xe498a622,0xf168,0x5104,0xa5,0x3b,0xfa,0xf9,0x96,0xf5,0x16,0x32] as IID_IReference_1_Windows_ApplicationModel_Email_EmailMailboxSmimeSigningAlgorithm }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IReference<super::applicationmodel::userdatatasks::UserDataTaskDaysOfWeek> => [0x903861c5,0xd29d,0x5083,0xa0,0x3d,0x6b,0x2a,0x02,0x33,0xdc,0xca] as IID_IReference_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskDaysOfWeek }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IReference<super::applicationmodel::userdatatasks::UserDataTaskWeekOfMonth> => [0x5246fa7f,0xf9e9,0x5574,0x80,0xf7,0x4a,0xa3,0x59,0xb0,0x02,0x3d] as IID_IReference_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskWeekOfMonth }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IReference<super::devices::bluetooth::advertisement::BluetoothLEAdvertisementFlags> => [0x91c0ba96,0x9e69,0x5b82,0xbf,0x1d,0x83,0xab,0x2a,0x50,0x9c,0x53] as IID_IReference_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementFlags }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IReference<super::devices::geolocation::BasicGeoposition> => [0xe4d5dda6,0xf57c,0x57cc,0xb6,0x7f,0x29,0x39,0xa9,0x01,0xda,0xbe] as IID_IReference_1_Windows_Devices_Geolocation_BasicGeoposition }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IReference<super::graphics::holographic::HolographicStereoTransform> => [0x6e67ce78,0xcc67,0x52c0,0xb6,0x35,0x99,0x1d,0xb0,0xbf,0xf5,0xca] as IID_IReference_1_Windows_Graphics_Holographic_HolographicStereoTransform }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::capture::WhiteBalanceGain> => [0x79c7838a,0x39e2,0x5287,0xac,0x3b,0xb1,0x18,0xdb,0x25,0x10,0x02] as IID_IReference_1_Windows_Media_Capture_WhiteBalanceGain }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::core::MseTimeRange> => [0x2fffd101,0x16f8,0x596d,0xa8,0x8e,0x65,0x9b,0x6f,0x58,0x46,0x41] as IID_IReference_1_Windows_Media_Core_MseTimeRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::devices::CaptureSceneMode> => [0xe20596aa,0x0bbe,0x5203,0xbe,0x6b,0x6b,0x71,0xff,0x5b,0x08,0x43] as IID_IReference_1_Windows_Media_Devices_CaptureSceneMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::devices::ManualFocusDistance> => [0xb0060b8a,0x1105,0x5ad4,0x96,0x3d,0xf6,0xcf,0x19,0x05,0xd3,0x49] as IID_IReference_1_Windows_Media_Devices_ManualFocusDistance }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::devices::MediaCaptureFocusState> => [0x58820185,0x5da0,0x5faa,0x86,0xda,0x9b,0xd9,0xf0,0x39,0x74,0xfa] as IID_IReference_1_Windows_Media_Devices_MediaCaptureFocusState }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::protection::HdcpProtection> => [0x8e330979,0x2fef,0x5d68,0x88,0xaa,0xa9,0xee,0x66,0x97,0xd1,0x17] as IID_IReference_1_Windows_Media_Protection_HdcpProtection }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IReference<super::media::streaming::adaptive::AdaptiveMediaSourceResourceType> => [0x74c8c3aa,0xde03,0x5bf0,0xaa,0xe8,0xaa,0x8b,0x69,0x20,0x66,0xb3] as IID_IReference_1_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceResourceType }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IReference<super::perception::spatial::SpatialBoundingBox> => [0xab3274d9,0x9b82,0x5396,0xbb,0x00,0xd7,0x0c,0x53,0x97,0x96,0xb3] as IID_IReference_1_Windows_Perception_Spatial_SpatialBoundingBox }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IReference<super::perception::spatial::SpatialBoundingFrustum> => [0xf434face,0x0c36,0x5749,0xa8,0xa0,0x0b,0xb6,0xce,0x78,0xa6,0x14] as IID_IReference_1_Windows_Perception_Spatial_SpatialBoundingFrustum }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IReference<super::perception::spatial::SpatialBoundingOrientedBox> => [0x09f88309,0x9f81,0x5207,0xbd,0xb2,0xab,0xef,0x92,0x6d,0xb1,0x8f] as IID_IReference_1_Windows_Perception_Spatial_SpatialBoundingOrientedBox }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IReference<super::ui::Color> => [0xab8e5d11,0xb0c1,0x5a21,0x95,0xae,0xf1,0x6b,0xf3,0xa3,0x76,0x24] as IID_IReference_1_Windows_UI_Color }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IReference<super::ui::text::UnderlineType> => [0x1b63ec17,0x7b2b,0x59fe,0xab,0x9d,0xb6,0x0e,0xa4,0xf9,0xc9,0xb8] as IID_IReference_1_Windows_UI_Text_UnderlineType }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IReference<super::ui::viewmanagement::UIElementType> => [0xe17e08c9,0x7deb,0x51d1,0x84,0x87,0x33,0x4e,0xb3,0xfe,0x46,0x91] as IID_IReference_1_Windows_UI_ViewManagement_UIElementType }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IReference<super::ui::xaml::Thickness> => [0xa19f7ba8,0xd8cd,0x5df2,0xab,0x44,0xfe,0xfd,0x26,0x64,0x44,0x84] as IID_IReference_1_Windows_UI_Xaml_Thickness }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IReference<super::web::WebErrorStatus> => [0xf2b26336,0x6a9d,0x54de,0x8e,0xca,0x00,0xd6,0xc8,0x71,0xe4,0x69] as IID_IReference_1_Windows_Web_WebErrorStatus }
RT_PINTERFACE!{ for IReference<TimeSpan> => [0x604d0c4c,0x91de,0x5c2a,0x93,0x5f,0x36,0x2f,0x13,0xea,0xf8,0x00] as IID_IReference_1_Windows_Foundation_TimeSpan }
RT_PINTERFACE!{ for IReference<u16> => [0x5ab7d2c3,0x6b62,0x5e71,0xa4,0xb6,0x2d,0x49,0xc4,0xf2,0x38,0xfd] as IID_IReference_1_System_UInt16 }
RT_PINTERFACE!{ for IReference<u32> => [0x513ef3af,0xe784,0x5325,0xa9,0x1e,0x97,0xc2,0xb8,0x11,0x1c,0xf3] as IID_IReference_1_System_UInt32 }
RT_PINTERFACE!{ for IReference<u64> => [0x6755e376,0x53bb,0x568b,0xa1,0x1d,0x17,0x23,0x98,0x68,0x30,0x9e] as IID_IReference_1_System_UInt64 }
RT_PINTERFACE!{ for IReference<u8> => [0xe5198cc8,0x2873,0x55f5,0xb0,0xa1,0x84,0xff,0x9e,0x4a,0xad,0x62] as IID_IReference_1_System_Byte }
RT_PINTERFACE!{ for IReferenceArray<bool> => [0xe8e72666,0x48cc,0x593f,0xba,0x85,0x26,0x63,0x49,0x69,0x56,0xe3] as IID_IReferenceArray_1_System_Boolean }
RT_PINTERFACE!{ for IReferenceArray<Char> => [0xa4095aab,0xeb7d,0x5782,0x8f,0xad,0x16,0x09,0xde,0xa2,0x49,0xad] as IID_IReferenceArray_1_System_Char }
RT_PINTERFACE!{ for IReferenceArray<DateTime> => [0x1b8e9594,0x588e,0x5a07,0x9e,0x65,0x07,0x31,0xa4,0xc9,0xa2,0xdb] as IID_IReferenceArray_1_Windows_Foundation_DateTime }
RT_PINTERFACE!{ for IReferenceArray<f32> => [0x6ab1ea83,0xcb41,0x5f99,0x92,0xcc,0x23,0xbd,0x43,0x36,0xa1,0xfb] as IID_IReferenceArray_1_System_Single }
RT_PINTERFACE!{ for IReferenceArray<f64> => [0xd301f253,0xe0a3,0x5d2b,0x9a,0x41,0xa4,0xd6,0x2b,0xec,0x46,0x23] as IID_IReferenceArray_1_System_Double }
RT_PINTERFACE!{ for IReferenceArray<Guid> => [0xeecf9838,0xc1c2,0x5b4a,0x97,0x6f,0xce,0xc2,0x61,0xae,0x1d,0x55] as IID_IReferenceArray_1_System_Guid }
RT_PINTERFACE!{ for IReferenceArray<HString> => [0x0385688e,0xe3c7,0x5c5e,0xa3,0x89,0x55,0x24,0xed,0xe3,0x49,0xf1] as IID_IReferenceArray_1_System_String }
RT_PINTERFACE!{ for IReferenceArray<i16> => [0x912f8fd7,0xadc0,0x5d60,0xa8,0x96,0x7e,0xd7,0x60,0x89,0xcc,0x5b] as IID_IReferenceArray_1_System_Int16 }
RT_PINTERFACE!{ for IReferenceArray<i32> => [0xa6d080a5,0xb087,0x5bc2,0x9a,0x9f,0x5c,0xd6,0x87,0xb4,0xd1,0xf7] as IID_IReferenceArray_1_System_Int32 }
RT_PINTERFACE!{ for IReferenceArray<i64> => [0x6e333271,0x2e2a,0x5955,0x87,0x90,0x83,0x6c,0x76,0xee,0x53,0xb6] as IID_IReferenceArray_1_System_Int64 }
RT_PINTERFACE!{ for IReferenceArray<i8> => [0x08de13ea,0xbbbf,0x50db,0xa4,0x03,0x57,0x84,0x20,0xbb,0x49,0xef] as IID_IReferenceArray_1_System_SByte }
RT_PINTERFACE!{ for IReferenceArray<IInspectable> => [0x9cd7a84f,0x0c80,0x59c5,0xb4,0x4e,0x97,0x78,0x41,0xbb,0x43,0xd9] as IID_IReferenceArray_1_System_Object }
RT_PINTERFACE!{ for IReferenceArray<Point> => [0x39313214,0x5c7d,0x599d,0xae,0x5a,0x17,0xd9,0xd6,0x49,0x22,0x58] as IID_IReferenceArray_1_Windows_Foundation_Point }
RT_PINTERFACE!{ for IReferenceArray<Rect> => [0x8a444256,0xd661,0x5e9a,0xa7,0x2b,0xd8,0xf1,0xd7,0x96,0x2d,0x0c] as IID_IReferenceArray_1_Windows_Foundation_Rect }
RT_PINTERFACE!{ for IReferenceArray<Size> => [0x3b40e9d4,0xe0c3,0x56f6,0xb8,0x8b,0xe5,0x05,0xeb,0x73,0x75,0x7b] as IID_IReferenceArray_1_Windows_Foundation_Size }
RT_PINTERFACE!{ for IReferenceArray<TimeSpan> => [0xad73197d,0x2cfa,0x57a6,0x89,0x93,0x9f,0xac,0x40,0xfe,0xb7,0x91] as IID_IReferenceArray_1_Windows_Foundation_TimeSpan }
RT_PINTERFACE!{ for IReferenceArray<u16> => [0x6624a2dd,0x83f7,0x519c,0x9d,0x55,0xbb,0x1f,0x65,0x60,0x45,0x6b] as IID_IReferenceArray_1_System_UInt16 }
RT_PINTERFACE!{ for IReferenceArray<u32> => [0x97374b68,0xeb87,0x56cc,0xb1,0x8e,0x27,0xef,0x0f,0x9c,0xfc,0x0c] as IID_IReferenceArray_1_System_UInt32 }
RT_PINTERFACE!{ for IReferenceArray<u64> => [0x38b60434,0xd67c,0x523e,0x9d,0x0e,0x24,0xd6,0x43,0x41,0x10,0x73] as IID_IReferenceArray_1_System_UInt64 }
RT_PINTERFACE!{ for IReferenceArray<u8> => [0x2af22683,0x3734,0x56d0,0xa6,0x0e,0x68,0x8c,0xc8,0x5d,0x16,0x19] as IID_IReferenceArray_1_System_Byte }
RT_PINTERFACE!{ for TypedEventHandler<diagnostics::IFileLoggingSession, diagnostics::LogFileGeneratedEventArgs> => [0x0c6563b0,0x9d8b,0x5b60,0x99,0x4b,0xde,0xe1,0x17,0x4d,0x1e,0xfb] as IID_TypedEventHandler_2_Windows_Foundation_Diagnostics_IFileLoggingSession_Windows_Foundation_Diagnostics_LogFileGeneratedEventArgs }
RT_PINTERFACE!{ for TypedEventHandler<diagnostics::ILoggingChannel, IInspectable> => [0x52c9c2a1,0x54a3,0x5ef9,0x9a,0xff,0x01,0x4e,0x7c,0x45,0x46,0x55] as IID_TypedEventHandler_2_Windows_Foundation_Diagnostics_ILoggingChannel_System_Object }
RT_PINTERFACE!{ for TypedEventHandler<IInspectable, IInspectable> => [0xc7e65ce2,0xfad5,0x5e3b,0x9c,0x58,0x18,0x6c,0xa8,0xc1,0xdd,0x57] as IID_TypedEventHandler_2_System_Object_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::applicationmodel::extendedexecution::ExtendedExecutionRevokedEventArgs> => [0xb6d68d9c,0x9546,0x50b3,0x8a,0xf6,0x9c,0x98,0x5a,0x37,0x2b,0xa8] as IID_TypedEventHandler_2_System_Object_Windows_ApplicationModel_ExtendedExecution_ExtendedExecutionRevokedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::applicationmodel::extendedexecution::foreground::ExtendedExecutionForegroundRevokedEventArgs> => [0xf874197a,0xbf19,0x5482,0x9a,0xb1,0x34,0x92,0x3d,0xe6,0x73,0x8d] as IID_TypedEventHandler_2_System_Object_Windows_ApplicationModel_ExtendedExecution_Foreground_ExtendedExecutionForegroundRevokedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::media::devices::DefaultAudioCaptureDeviceChangedEventArgs> => [0x97d07327,0x2c78,0x57bc,0x98,0xe6,0xa2,0x4c,0xd0,0x24,0xcf,0x5b] as IID_TypedEventHandler_2_System_Object_Windows_Media_Devices_DefaultAudioCaptureDeviceChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::media::devices::DefaultAudioRenderDeviceChangedEventArgs> => [0xfd732aca,0xdafc,0x5b7d,0xbf,0x72,0xb5,0x60,0xb7,0x8d,0x26,0x0c] as IID_TypedEventHandler_2_System_Object_Windows_Media_Devices_DefaultAudioRenderDeviceChangedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::networking::proximity::ConnectionRequestedEventArgs> => [0x512c383c,0x8b29,0x5079,0x95,0x3e,0x8d,0xee,0x8f,0x8a,0x82,0x24] as IID_TypedEventHandler_2_System_Object_Windows_Networking_Proximity_ConnectionRequestedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::networking::proximity::TriggeredConnectionStateChangedEventArgs> => [0x2e5ad6fa,0x3ca6,0x5518,0xbd,0x4d,0xfe,0xfc,0x45,0x35,0x58,0x0e] as IID_TypedEventHandler_2_System_Object_Windows_Networking_Proximity_TriggeredConnectionStateChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::composition::CompositionBatchCompletedEventArgs> => [0x9df03456,0x3383,0x508b,0x9c,0x75,0xee,0x84,0x0a,0x7e,0x1a,0x39] as IID_TypedEventHandler_2_System_Object_Windows_UI_Composition_CompositionBatchCompletedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::core::CharacterReceivedEventArgs> => [0x5aa4a848,0x86b2,0x506b,0x89,0xab,0x5e,0xb5,0x78,0x64,0x20,0xc6] as IID_TypedEventHandler_2_System_Object_Windows_UI_Core_CharacterReceivedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::core::CoreWindowEventArgs> => [0x1a8ac270,0xa777,0x50f7,0x88,0xa1,0xe3,0x4e,0x56,0xc0,0x94,0x49] as IID_TypedEventHandler_2_System_Object_Windows_UI_Core_CoreWindowEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::core::InputEnabledEventArgs> => [0xc9965f1c,0x3641,0x51b6,0xb8,0x23,0x04,0x8e,0xc3,0x62,0x8f,0xb0] as IID_TypedEventHandler_2_System_Object_Windows_UI_Core_InputEnabledEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::core::KeyEventArgs> => [0xeadffdf7,0xd70e,0x5688,0x90,0x6c,0xc2,0xb1,0x22,0x9e,0xa1,0x6d] as IID_TypedEventHandler_2_System_Object_Windows_UI_Core_KeyEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::core::PointerEventArgs> => [0x26aabf41,0xa0fd,0x5e66,0xb1,0x88,0x6c,0x74,0x18,0x2d,0x00,0xcd] as IID_TypedEventHandler_2_System_Object_Windows_UI_Core_PointerEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<IInspectable, super::ui::core::TouchHitTestingEventArgs> => [0xc76e9d25,0x6a96,0x58fd,0x87,0x4f,0xae,0x52,0xbd,0x60,0x3a,0xf8] as IID_TypedEventHandler_2_System_Object_Windows_UI_Core_TouchHitTestingEventArgs }
RT_PINTERFACE!{ for TypedEventHandler<IMemoryBufferReference, IInspectable> => [0xf4637d4a,0x0760,0x5431,0xbf,0xc0,0x24,0xeb,0x1d,0x4f,0x6c,0x4f] as IID_TypedEventHandler_2_Windows_Foundation_IMemoryBufferReference_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::activation::SplashScreen, IInspectable> => [0x7725b2a5,0x287d,0x5ed2,0xa7,0x89,0x2a,0x6a,0x26,0x73,0xc7,0xfe] as IID_TypedEventHandler_2_Windows_ApplicationModel_Activation_SplashScreen_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appextensions::AppExtensionCatalog, super::applicationmodel::appextensions::AppExtensionPackageInstalledEventArgs> => [0x26460556,0x9f0a,0x562e,0x91,0x65,0x9e,0xb9,0xe1,0x89,0x8b,0x1e] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppExtensions_AppExtensionCatalog_Windows_ApplicationModel_AppExtensions_AppExtensionPackageInstalledEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appextensions::AppExtensionCatalog, super::applicationmodel::appextensions::AppExtensionPackageStatusChangedEventArgs> => [0x61a2a9c0,0xd3bb,0x5953,0x8d,0xf7,0x59,0x1f,0xdd,0x5b,0xd7,0x4a] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppExtensions_AppExtensionCatalog_Windows_ApplicationModel_AppExtensions_AppExtensionPackageStatusChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appextensions::AppExtensionCatalog, super::applicationmodel::appextensions::AppExtensionPackageUninstallingEventArgs> => [0x60e847e8,0x2eca,0x54be,0x8b,0x13,0x9e,0x62,0xdb,0xd5,0xb9,0x5d] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppExtensions_AppExtensionCatalog_Windows_ApplicationModel_AppExtensions_AppExtensionPackageUninstallingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appextensions::AppExtensionCatalog, super::applicationmodel::appextensions::AppExtensionPackageUpdatedEventArgs> => [0xa7e0dc0b,0x525e,0x52b1,0xb1,0xd9,0x2d,0x5b,0x4b,0x52,0x94,0xa5] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppExtensions_AppExtensionCatalog_Windows_ApplicationModel_AppExtensions_AppExtensionPackageUpdatedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appextensions::AppExtensionCatalog, super::applicationmodel::appextensions::AppExtensionPackageUpdatingEventArgs> => [0x91f40910,0x6acf,0x510d,0x8d,0x7b,0x0b,0xd0,0x5b,0x83,0x58,0x83] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppExtensions_AppExtensionCatalog_Windows_ApplicationModel_AppExtensions_AppExtensionPackageUpdatingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::AppointmentCalendarSyncManager, IInspectable> => [0xbd1308de,0x6d2e,0x5541,0xb2,0x54,0xbd,0xb6,0x18,0x39,0xba,0xc1] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_AppointmentCalendarSyncManager_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::AppointmentStore, super::applicationmodel::appointments::AppointmentStoreChangedEventArgs> => [0x9e628351,0xc639,0x5cef,0xab,0x1d,0x8b,0xea,0xe9,0xd7,0x5d,0x52] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_AppointmentStore_Windows_ApplicationModel_Appointments_AppointmentStoreChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::dataprovider::AppointmentDataProviderConnection, super::applicationmodel::appointments::dataprovider::AppointmentCalendarCancelMeetingRequestEventArgs> => [0x0e9cc1d8,0x0d26,0x5207,0xb7,0xd9,0x9a,0xd1,0xbf,0x66,0xe1,0xe6] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_DataProvider_AppointmentDataProviderConnection_Windows_ApplicationModel_Appointments_DataProvider_AppointmentCalendarCancelMeetingRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::dataprovider::AppointmentDataProviderConnection, super::applicationmodel::appointments::dataprovider::AppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs> => [0xb45150b9,0xdf09,0x5c86,0xb5,0x7d,0x3e,0x6d,0xef,0xf2,0x47,0x67] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_DataProvider_AppointmentDataProviderConnection_Windows_ApplicationModel_Appointments_DataProvider_AppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::dataprovider::AppointmentDataProviderConnection, super::applicationmodel::appointments::dataprovider::AppointmentCalendarForwardMeetingRequestEventArgs> => [0x8961d738,0xecdc,0x53c8,0xb0,0xec,0xe7,0x29,0xd8,0x10,0x94,0x59] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_DataProvider_AppointmentDataProviderConnection_Windows_ApplicationModel_Appointments_DataProvider_AppointmentCalendarForwardMeetingRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::dataprovider::AppointmentDataProviderConnection, super::applicationmodel::appointments::dataprovider::AppointmentCalendarProposeNewTimeForMeetingRequestEventArgs> => [0x4fe460a4,0xe875,0x5836,0x9e,0xec,0x27,0x3d,0x52,0xc8,0x6a,0xb3] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_DataProvider_AppointmentDataProviderConnection_Windows_ApplicationModel_Appointments_DataProvider_AppointmentCalendarProposeNewTimeForMeetingRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::dataprovider::AppointmentDataProviderConnection, super::applicationmodel::appointments::dataprovider::AppointmentCalendarSyncManagerSyncRequestEventArgs> => [0x37f52677,0x5f3a,0x57e6,0x82,0xf5,0xcb,0xab,0x2e,0x4d,0xbe,0x8e] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_DataProvider_AppointmentDataProviderConnection_Windows_ApplicationModel_Appointments_DataProvider_AppointmentCalendarSyncManagerSyncRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appointments::dataprovider::AppointmentDataProviderConnection, super::applicationmodel::appointments::dataprovider::AppointmentCalendarUpdateMeetingResponseRequestEventArgs> => [0x5370df2b,0x62cd,0x5133,0x93,0xe6,0xfc,0x80,0xa5,0x02,0xaf,0x64] as IID_TypedEventHandler_2_Windows_ApplicationModel_Appointments_DataProvider_AppointmentDataProviderConnection_Windows_ApplicationModel_Appointments_DataProvider_AppointmentCalendarUpdateMeetingResponseRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appservice::AppServiceConnection, super::applicationmodel::appservice::AppServiceClosedEventArgs> => [0xe4efa98d,0x4bfc,0x5e61,0xa2,0x33,0x68,0x8f,0x5f,0x06,0x52,0x1f] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppService_AppServiceConnection_Windows_ApplicationModel_AppService_AppServiceClosedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::appservice::AppServiceConnection, super::applicationmodel::appservice::AppServiceRequestReceivedEventArgs> => [0x18c67d61,0x4176,0x5553,0xb1,0x8d,0xd8,0xf5,0x7f,0xe7,0x95,0x52] as IID_TypedEventHandler_2_Windows_ApplicationModel_AppService_AppServiceConnection_Windows_ApplicationModel_AppService_AppServiceRequestReceivedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::background::BackgroundTaskRegistrationGroup, super::applicationmodel::activation::BackgroundActivatedEventArgs> => [0xd4f89768,0x688f,0x59ec,0xbf,0x24,0xc2,0xaf,0x6a,0x31,0x0f,0xa4] as IID_TypedEventHandler_2_Windows_ApplicationModel_Background_BackgroundTaskRegistrationGroup_Windows_ApplicationModel_Activation_BackgroundActivatedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::calls::LockScreenCallUI, IInspectable> => [0xaddada2a,0xe5a7,0x5921,0xb7,0xe0,0x17,0x32,0x3a,0xdf,0x73,0x82] as IID_TypedEventHandler_2_Windows_ApplicationModel_Calls_LockScreenCallUI_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::calls::LockScreenCallUI, super::applicationmodel::calls::LockScreenCallEndRequestedEventArgs> => [0x92f7c40e,0xe7b9,0x5f68,0x98,0xf0,0x56,0xfb,0x89,0x01,0x58,0x06] as IID_TypedEventHandler_2_Windows_ApplicationModel_Calls_LockScreenCallUI_Windows_ApplicationModel_Calls_LockScreenCallEndRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::calls::VoipCallCoordinator, super::applicationmodel::calls::MuteChangeEventArgs> => [0xecafec77,0x4bf6,0x57b7,0x86,0xc6,0xe2,0xfe,0xca,0x5b,0x5a,0xee] as IID_TypedEventHandler_2_Windows_ApplicationModel_Calls_VoipCallCoordinator_Windows_ApplicationModel_Calls_MuteChangeEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::calls::VoipPhoneCall, super::applicationmodel::calls::CallAnswerEventArgs> => [0xd47be4da,0xc00c,0x5faa,0xbf,0xa5,0x1b,0x11,0xe0,0xc3,0xcc,0xc1] as IID_TypedEventHandler_2_Windows_ApplicationModel_Calls_VoipPhoneCall_Windows_ApplicationModel_Calls_CallAnswerEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::calls::VoipPhoneCall, super::applicationmodel::calls::CallRejectEventArgs> => [0xd06255ce,0x0967,0x5441,0x8f,0xe6,0xed,0x2e,0x70,0x08,0x19,0x7e] as IID_TypedEventHandler_2_Windows_ApplicationModel_Calls_VoipPhoneCall_Windows_ApplicationModel_Calls_CallRejectEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::calls::VoipPhoneCall, super::applicationmodel::calls::CallStateChangeEventArgs> => [0x1e00c6cc,0xe14c,0x51ce,0x93,0xf3,0x0a,0x0a,0x9a,0x3f,0x3e,0xec] as IID_TypedEventHandler_2_Windows_ApplicationModel_Calls_VoipPhoneCall_Windows_ApplicationModel_Calls_CallStateChangeEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::chat::ChatConversation, super::applicationmodel::chat::RemoteParticipantComposingChangedEventArgs> => [0x09e43bb2,0x692d,0x5330,0xb9,0xe7,0xad,0xf6,0x9a,0xd5,0xc1,0xa9] as IID_TypedEventHandler_2_Windows_ApplicationModel_Chat_ChatConversation_Windows_ApplicationModel_Chat_RemoteParticipantComposingChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::chat::ChatMessageStore, super::applicationmodel::chat::ChatMessageChangedEventArgs> => [0x2a4ed3d1,0x0d01,0x5133,0xb9,0xe4,0xdd,0xf6,0x8f,0x09,0x94,0x85] as IID_TypedEventHandler_2_Windows_ApplicationModel_Chat_ChatMessageStore_Windows_ApplicationModel_Chat_ChatMessageChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::chat::ChatMessageStore, super::applicationmodel::chat::ChatMessageStoreChangedEventArgs> => [0x3b5903d7,0xa037,0x5c7c,0x83,0x36,0x88,0x42,0x3d,0x81,0xe4,0x08] as IID_TypedEventHandler_2_Windows_ApplicationModel_Chat_ChatMessageStore_Windows_ApplicationModel_Chat_ChatMessageStoreChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::chat::RcsEndUserMessageManager, super::applicationmodel::chat::RcsEndUserMessageAvailableEventArgs> => [0x8d6beb36,0xf6ce,0x5769,0x96,0xc2,0x25,0x32,0x6e,0xb4,0x63,0xf6] as IID_TypedEventHandler_2_Windows_ApplicationModel_Chat_RcsEndUserMessageManager_Windows_ApplicationModel_Chat_RcsEndUserMessageAvailableEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::chat::RcsTransport, super::applicationmodel::chat::RcsServiceKindSupportedChangedEventArgs> => [0xe5f1c3a4,0xe498,0x50b0,0x91,0xfe,0x94,0xeb,0xb0,0x1d,0xe0,0xab] as IID_TypedEventHandler_2_Windows_ApplicationModel_Chat_RcsTransport_Windows_ApplicationModel_Chat_RcsServiceKindSupportedChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::ContactList, super::applicationmodel::contacts::ContactChangedEventArgs> => [0xc953dc00,0x30be,0x5379,0xbc,0xac,0x43,0x5c,0x6b,0xad,0x3c,0xe6] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_ContactList_Windows_ApplicationModel_Contacts_ContactChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::ContactListSyncManager, IInspectable> => [0xf0c4ce23,0x4e80,0x5cb1,0x9f,0x43,0xfb,0xdc,0x1c,0x60,0x91,0x22] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_ContactListSyncManager_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::ContactPanel, super::applicationmodel::contacts::ContactPanelClosingEventArgs> => [0x4357954b,0xbce6,0x5456,0xa5,0x11,0xfe,0x89,0x04,0xe8,0x09,0x0b] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_ContactPanel_Windows_ApplicationModel_Contacts_ContactPanelClosingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::ContactPanel, super::applicationmodel::contacts::ContactPanelLaunchFullAppRequestedEventArgs> => [0xc4030df2,0xad34,0x5575,0xa3,0x69,0x56,0x16,0x57,0x78,0x78,0xeb] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_ContactPanel_Windows_ApplicationModel_Contacts_ContactPanelLaunchFullAppRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::ContactStore, super::applicationmodel::contacts::ContactChangedEventArgs> => [0x5da35e68,0x7513,0x5ead,0xaa,0xd4,0xcd,0xd3,0xde,0x4e,0x5a,0xe7] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_ContactStore_Windows_ApplicationModel_Contacts_ContactChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::dataprovider::ContactDataProviderConnection, super::applicationmodel::contacts::dataprovider::ContactListCreateOrUpdateContactRequestEventArgs> => [0x9b90aab6,0x7ba3,0x5169,0xb7,0x3c,0x7e,0x64,0x13,0xd2,0xbd,0x57] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_DataProvider_ContactDataProviderConnection_Windows_ApplicationModel_Contacts_DataProvider_ContactListCreateOrUpdateContactRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::dataprovider::ContactDataProviderConnection, super::applicationmodel::contacts::dataprovider::ContactListDeleteContactRequestEventArgs> => [0x9ff3c767,0xb488,0x53e2,0xa4,0x94,0x32,0x70,0x61,0x61,0xca,0x01] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_DataProvider_ContactDataProviderConnection_Windows_ApplicationModel_Contacts_DataProvider_ContactListDeleteContactRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::dataprovider::ContactDataProviderConnection, super::applicationmodel::contacts::dataprovider::ContactListServerSearchReadBatchRequestEventArgs> => [0xbaee1b2f,0xa5b6,0x5a03,0xae,0x59,0xfb,0x18,0xf3,0xe0,0x25,0xb7] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_DataProvider_ContactDataProviderConnection_Windows_ApplicationModel_Contacts_DataProvider_ContactListServerSearchReadBatchRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::dataprovider::ContactDataProviderConnection, super::applicationmodel::contacts::dataprovider::ContactListSyncManagerSyncRequestEventArgs> => [0xbb9f410f,0xa739,0x5280,0x9b,0xb7,0xb6,0xa9,0x38,0xc7,0xa6,0x20] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_DataProvider_ContactDataProviderConnection_Windows_ApplicationModel_Contacts_DataProvider_ContactListSyncManagerSyncRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::contacts::provider::ContactPickerUI, super::applicationmodel::contacts::provider::ContactRemovedEventArgs> => [0xa39aeb7e,0x765c,0x5e83,0xb2,0x31,0x84,0xbe,0xad,0x98,0xe9,0xa0] as IID_TypedEventHandler_2_Windows_ApplicationModel_Contacts_Provider_ContactPickerUI_Windows_ApplicationModel_Contacts_Provider_ContactRemovedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::core::CoreApplicationView, super::applicationmodel::activation::IActivatedEventArgs> => [0xcf193a96,0xeb13,0x5e3b,0x8b,0xdf,0x87,0xb6,0xef,0xae,0x83,0x39] as IID_TypedEventHandler_2_Windows_ApplicationModel_Core_CoreApplicationView_Windows_ApplicationModel_Activation_IActivatedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::core::CoreApplicationView, super::applicationmodel::core::HostedViewClosingEventArgs> => [0xd9a3f433,0x9bcc,0x54d6,0xb3,0xcf,0x7b,0x01,0xf0,0x26,0xd4,0xcd] as IID_TypedEventHandler_2_Windows_ApplicationModel_Core_CoreApplicationView_Windows_ApplicationModel_Core_HostedViewClosingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::core::CoreApplicationViewTitleBar, IInspectable> => [0x28342e21,0xdad3,0x5e32,0xba,0xe1,0xaf,0xe7,0xb2,0x6c,0x66,0xfb] as IID_TypedEventHandler_2_Windows_ApplicationModel_Core_CoreApplicationViewTitleBar_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::DataPackage, IInspectable> => [0xc156b0c3,0x1cbc,0x5ca4,0x90,0x1c,0x62,0xc5,0xa8,0xca,0x5c,0xb5] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DataPackage_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::DataPackage, super::applicationmodel::datatransfer::OperationCompletedEventArgs> => [0xdd48af6c,0xef9a,0x59cb,0xb3,0x26,0x57,0xd9,0xe2,0x41,0x1f,0x21] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DataPackage_Windows_ApplicationModel_DataTransfer_OperationCompletedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::DataPackage, super::applicationmodel::datatransfer::ShareCompletedEventArgs> => [0xf8f7e24a,0x56fe,0x58df,0xbc,0x15,0x23,0x65,0xae,0xc0,0x39,0x66] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DataPackage_Windows_ApplicationModel_DataTransfer_ShareCompletedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::DataTransferManager, super::applicationmodel::datatransfer::DataRequestedEventArgs> => [0xec6f9cc8,0x46d0,0x5e0e,0xb4,0xd2,0x7d,0x77,0x73,0xae,0x37,0xa0] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DataTransferManager_Windows_ApplicationModel_DataTransfer_DataRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::DataTransferManager, super::applicationmodel::datatransfer::ShareProvidersRequestedEventArgs> => [0x147e2860,0x7397,0x582f,0x80,0xdb,0xb8,0x68,0x53,0x83,0xa9,0x37] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DataTransferManager_Windows_ApplicationModel_DataTransfer_ShareProvidersRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::DataTransferManager, super::applicationmodel::datatransfer::TargetApplicationChosenEventArgs> => [0xc4ac1ba2,0x7851,0x5a44,0xbc,0x8d,0x3d,0x7c,0x71,0x3f,0x1f,0x41] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DataTransferManager_Windows_ApplicationModel_DataTransfer_TargetApplicationChosenEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::datatransfer::dragdrop::core::CoreDragDropManager, super::applicationmodel::datatransfer::dragdrop::core::CoreDropOperationTargetRequestedEventArgs> => [0xa4c3b1c1,0xb8ad,0x58cb,0xac,0xc0,0x8e,0xf3,0x7e,0xae,0x4e,0xd4] as IID_TypedEventHandler_2_Windows_ApplicationModel_DataTransfer_DragDrop_Core_CoreDragDropManager_Windows_ApplicationModel_DataTransfer_DragDrop_Core_CoreDropOperationTargetRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxCreateFolderRequestEventArgs> => [0x8c7db52d,0x496e,0x5419,0xbd,0x78,0xb8,0xb6,0x57,0xcf,0x4e,0x66] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxCreateFolderRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxDeleteFolderRequestEventArgs> => [0xd962a9b6,0xbbb4,0x5d82,0x84,0xb4,0x8f,0x70,0x3b,0xf3,0x08,0x6f] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxDeleteFolderRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxDownloadAttachmentRequestEventArgs> => [0xd2e92019,0xb997,0x5cd6,0x8f,0x88,0x4d,0xbc,0x6f,0x96,0x9f,0x15] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxDownloadAttachmentRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxDownloadMessageRequestEventArgs> => [0xe1b59b2f,0xddd5,0x5159,0xae,0x9a,0x14,0xa8,0x66,0x91,0x20,0x95] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxDownloadMessageRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxEmptyFolderRequestEventArgs> => [0x9a851b84,0xbcb1,0x5121,0xab,0x61,0x3e,0xfe,0x56,0x8f,0x68,0x3d] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxEmptyFolderRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxForwardMeetingRequestEventArgs> => [0x9d6a017f,0x5a70,0x5d83,0xa6,0x80,0xd2,0x80,0x67,0x48,0xca,0x0b] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxForwardMeetingRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxGetAutoReplySettingsRequestEventArgs> => [0x587c6f92,0xa969,0x57b3,0x89,0x5f,0x9a,0x06,0xb3,0x65,0x0d,0x3a] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxGetAutoReplySettingsRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxMoveFolderRequestEventArgs> => [0x2c6bf2c8,0x42f3,0x523d,0x80,0xdb,0x17,0x0e,0x4f,0xb1,0x56,0x7f] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxMoveFolderRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxProposeNewTimeForMeetingRequestEventArgs> => [0x309d8bde,0x1e60,0x524b,0x82,0x8c,0x5a,0x3d,0x64,0xa6,0x72,0xaa] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxProposeNewTimeForMeetingRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxResolveRecipientsRequestEventArgs> => [0xec14e586,0xe4fb,0x5fc0,0x91,0xfc,0x93,0x1c,0xe1,0x7a,0x3f,0xc3] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxResolveRecipientsRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxServerSearchReadBatchRequestEventArgs> => [0xf8bf9067,0x7d11,0x56a0,0xa3,0x03,0x16,0x34,0x35,0xc1,0x40,0x16] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxServerSearchReadBatchRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxSetAutoReplySettingsRequestEventArgs> => [0xaa4f8fb3,0x05e0,0x54e6,0xaf,0xac,0xa2,0x8e,0x85,0x3e,0x75,0x6e] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxSetAutoReplySettingsRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxSyncManagerSyncRequestEventArgs> => [0xb65fc3ec,0x9476,0x51c4,0xba,0x70,0x15,0x05,0xd7,0x98,0x26,0xb9] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxSyncManagerSyncRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxUpdateMeetingResponseRequestEventArgs> => [0x3274fbfd,0xc10a,0x5b30,0xad,0xea,0x2b,0x4b,0x86,0x0b,0x4a,0x0d] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxUpdateMeetingResponseRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::dataprovider::EmailDataProviderConnection, super::applicationmodel::email::dataprovider::EmailMailboxValidateCertificatesRequestEventArgs> => [0xde2625f7,0xe16f,0x512e,0xa8,0xc6,0xb7,0x44,0x55,0x32,0xbc,0xc6] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_DataProvider_EmailDataProviderConnection_Windows_ApplicationModel_Email_DataProvider_EmailMailboxValidateCertificatesRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::EmailMailbox, super::applicationmodel::email::EmailMailboxChangedEventArgs> => [0x20789b0d,0x1555,0x51fc,0x87,0xa5,0x22,0x22,0x25,0x0b,0x9b,0x06] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_EmailMailbox_Windows_ApplicationModel_Email_EmailMailboxChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::email::EmailMailboxSyncManager, IInspectable> => [0x5cbe61bb,0xd615,0x5b82,0xbb,0x11,0x41,0x2e,0x32,0x66,0x4c,0x07] as IID_TypedEventHandler_2_Windows_ApplicationModel_Email_EmailMailboxSyncManager_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::lockscreen::LockApplicationHost, super::applicationmodel::lockscreen::LockScreenUnlockingEventArgs> => [0x002e5776,0x8a5b,0x5b93,0x8c,0x6c,0x9c,0x4c,0x87,0x88,0xf5,0xb4] as IID_TypedEventHandler_2_Windows_ApplicationModel_LockScreen_LockApplicationHost_Windows_ApplicationModel_LockScreen_LockScreenUnlockingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::lockscreen::LockScreenInfo, IInspectable> => [0x8be9e6a3,0xf88a,0x5429,0x8d,0xa3,0x67,0x6b,0x7d,0x4f,0x1a,0x5b] as IID_TypedEventHandler_2_Windows_ApplicationModel_LockScreen_LockScreenInfo_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::PackageCatalog, super::applicationmodel::PackageContentGroupStagingEventArgs> => [0xdf206861,0x9d30,0x5739,0x88,0xb2,0x97,0xe0,0x71,0x7c,0xc5,0xf0] as IID_TypedEventHandler_2_Windows_ApplicationModel_PackageCatalog_Windows_ApplicationModel_PackageContentGroupStagingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::PackageCatalog, super::applicationmodel::PackageInstallingEventArgs> => [0xa8a900c6,0xda0b,0x5bcc,0xa7,0x1a,0xbe,0x0b,0x92,0x65,0xd8,0x7a] as IID_TypedEventHandler_2_Windows_ApplicationModel_PackageCatalog_Windows_ApplicationModel_PackageInstallingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::PackageCatalog, super::applicationmodel::PackageStagingEventArgs> => [0x1726f52d,0x2b8c,0x524a,0x98,0xc6,0xf2,0xcf,0x08,0x93,0xc0,0xf2] as IID_TypedEventHandler_2_Windows_ApplicationModel_PackageCatalog_Windows_ApplicationModel_PackageStagingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::PackageCatalog, super::applicationmodel::PackageStatusChangedEventArgs> => [0xb32d7d63,0xcd0e,0x5c2e,0xa2,0x51,0xfb,0x8d,0x29,0x08,0x24,0xe4] as IID_TypedEventHandler_2_Windows_ApplicationModel_PackageCatalog_Windows_ApplicationModel_PackageStatusChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::PackageCatalog, super::applicationmodel::PackageUninstallingEventArgs> => [0xbd636cf1,0x541f,0x53ea,0x8e,0xfc,0xe1,0x60,0x4a,0x39,0x5b,0x1a] as IID_TypedEventHandler_2_Windows_ApplicationModel_PackageCatalog_Windows_ApplicationModel_PackageUninstallingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::PackageCatalog, super::applicationmodel::PackageUpdatingEventArgs> => [0xc23e15f6,0xc618,0x522a,0x82,0xab,0x4f,0xab,0x36,0x66,0x5c,0xe5] as IID_TypedEventHandler_2_Windows_ApplicationModel_PackageCatalog_Windows_ApplicationModel_PackageUpdatingEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::preview::notes::NotesWindowManagerPreview, IInspectable> => [0x6f2755fb,0x6c33,0x543c,0x9a,0xb4,0xde,0x48,0x6b,0xc7,0xbf,0xe2] as IID_TypedEventHandler_2_Windows_ApplicationModel_Preview_Notes_NotesWindowManagerPreview_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::preview::notes::NotesWindowManagerPreview, super::applicationmodel::preview::notes::NotePlacementChangedPreviewEventArgs> => [0xa28af2c7,0x4012,0x5999,0xa3,0x22,0x52,0x36,0xb3,0x0d,0x99,0x5f] as IID_TypedEventHandler_2_Windows_ApplicationModel_Preview_Notes_NotesWindowManagerPreview_Windows_ApplicationModel_Preview_Notes_NotePlacementChangedPreviewEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::preview::notes::NotesWindowManagerPreview, super::applicationmodel::preview::notes::NoteVisibilityChangedPreviewEventArgs> => [0x16d825c8,0x5271,0x51c8,0xa0,0x0f,0x0c,0xfb,0x1b,0x02,0x9a,0xb6] as IID_TypedEventHandler_2_Windows_ApplicationModel_Preview_Notes_NotesWindowManagerPreview_Windows_ApplicationModel_Preview_Notes_NoteVisibilityChangedPreviewEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::core::SearchSuggestionManager, super::applicationmodel::search::core::RequestingFocusOnKeyboardInputEventArgs> => [0xbb198760,0x4739,0x5559,0x80,0xe6,0xf0,0xe1,0xaf,0x53,0x55,0xfd] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_Core_SearchSuggestionManager_Windows_ApplicationModel_Search_Core_RequestingFocusOnKeyboardInputEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::core::SearchSuggestionManager, super::applicationmodel::search::core::SearchSuggestionsRequestedEventArgs> => [0x7e7f3cdf,0x80d9,0x5646,0x87,0x43,0xec,0x1e,0x38,0x64,0x5d,0x68] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_Core_SearchSuggestionManager_Windows_ApplicationModel_Search_Core_SearchSuggestionsRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::SearchPane, super::applicationmodel::search::SearchPaneQueryChangedEventArgs> => [0x7ccd7da1,0x8767,0x5eef,0x97,0x2d,0x31,0xd0,0x9f,0x1b,0xf3,0x08] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_SearchPane_Windows_ApplicationModel_Search_SearchPaneQueryChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::SearchPane, super::applicationmodel::search::SearchPaneQuerySubmittedEventArgs> => [0x5f05121b,0x61a6,0x5f6b,0xb0,0x07,0x20,0x81,0x6d,0xfe,0x70,0x09] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_SearchPane_Windows_ApplicationModel_Search_SearchPaneQuerySubmittedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::SearchPane, super::applicationmodel::search::SearchPaneResultSuggestionChosenEventArgs> => [0xec31e5d4,0x3b8c,0x5757,0x96,0xbf,0x14,0x09,0x6b,0xe9,0x46,0xcd] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_SearchPane_Windows_ApplicationModel_Search_SearchPaneResultSuggestionChosenEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::SearchPane, super::applicationmodel::search::SearchPaneSuggestionsRequestedEventArgs> => [0x95088dc0,0x6c14,0x55b8,0x8a,0x8f,0x9d,0xf1,0xca,0x44,0xd1,0xd4] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_SearchPane_Windows_ApplicationModel_Search_SearchPaneSuggestionsRequestedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::search::SearchPane, super::applicationmodel::search::SearchPaneVisibilityChangedEventArgs> => [0x3975ff72,0x971b,0x54b6,0x9b,0x5f,0xcc,0x44,0x2e,0x2a,0x87,0xf0] as IID_TypedEventHandler_2_Windows_ApplicationModel_Search_SearchPane_Windows_ApplicationModel_Search_SearchPaneVisibilityChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::store::preview::installcontrol::AppInstallItem, IInspectable> => [0x92730467,0x501e,0x5b05,0x88,0x26,0x92,0x6f,0x86,0x92,0x5b,0x03] as IID_TypedEventHandler_2_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::store::preview::installcontrol::AppInstallManager, super::applicationmodel::store::preview::installcontrol::AppInstallManagerItemEventArgs> => [0xabf1c837,0xdacd,0x5446,0xa0,0x32,0x3e,0xe9,0x02,0x88,0x02,0x44] as IID_TypedEventHandler_2_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallManager_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallManagerItemEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdataaccounts::UserDataAccountStore, super::applicationmodel::userdataaccounts::UserDataAccountStoreChangedEventArgs> => [0x7b27aec8,0x0690,0x5063,0xbe,0xb0,0xd9,0xe2,0xeb,0x1a,0x12,0x01] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataAccounts_UserDataAccountStore_Windows_ApplicationModel_UserDataAccounts_UserDataAccountStoreChangedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdatatasks::dataprovider::UserDataTaskDataProviderConnection, super::applicationmodel::userdatatasks::dataprovider::UserDataTaskListCompleteTaskRequestEventArgs> => [0x6035f9f7,0xd4c5,0x5394,0xb0,0xe3,0x5d,0x60,0x69,0x87,0xba,0x47] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskDataProviderConnection_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskListCompleteTaskRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdatatasks::dataprovider::UserDataTaskDataProviderConnection, super::applicationmodel::userdatatasks::dataprovider::UserDataTaskListCreateOrUpdateTaskRequestEventArgs> => [0x28adf45c,0x6807,0x5590,0xa7,0xf1,0x93,0x47,0x47,0x93,0x75,0x92] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskDataProviderConnection_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskListCreateOrUpdateTaskRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdatatasks::dataprovider::UserDataTaskDataProviderConnection, super::applicationmodel::userdatatasks::dataprovider::UserDataTaskListDeleteTaskRequestEventArgs> => [0x0b18e688,0xb269,0x5ca2,0xa8,0xf3,0xd6,0xd1,0x0f,0x0f,0xb3,0x20] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskDataProviderConnection_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskListDeleteTaskRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdatatasks::dataprovider::UserDataTaskDataProviderConnection, super::applicationmodel::userdatatasks::dataprovider::UserDataTaskListSkipOccurrenceRequestEventArgs> => [0x0887b178,0xc546,0x5ac8,0xae,0x10,0x32,0x92,0xab,0x52,0x65,0xbc] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskDataProviderConnection_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskListSkipOccurrenceRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdatatasks::dataprovider::UserDataTaskDataProviderConnection, super::applicationmodel::userdatatasks::dataprovider::UserDataTaskListSyncManagerSyncRequestEventArgs> => [0xb164e8ef,0x167c,0x5852,0xa7,0x92,0x09,0x30,0xb4,0x00,0x18,0x71] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskDataProviderConnection_Windows_ApplicationModel_UserDataTasks_DataProvider_UserDataTaskListSyncManagerSyncRequestEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::userdatatasks::UserDataTaskListSyncManager, IInspectable> => [0x03e790f2,0xeacf,0x53eb,0x90,0x60,0x6b,0xfe,0xec,0x5b,0xc3,0x75] as IID_TypedEventHandler_2_Windows_ApplicationModel_UserDataTasks_UserDataTaskListSyncManager_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::voicecommands::VoiceCommandServiceConnection, super::applicationmodel::voicecommands::VoiceCommandCompletedEventArgs> => [0x780a6352,0xb400,0x5767,0x99,0x3b,0x90,0x87,0x57,0x10,0xd9,0x37] as IID_TypedEventHandler_2_Windows_ApplicationModel_VoiceCommands_VoiceCommandServiceConnection_Windows_ApplicationModel_VoiceCommands_VoiceCommandCompletedEventArgs }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::wallet::system::WalletItemSystemStore, IInspectable> => [0x3c619943,0xa672,0x57ee,0xad,0x32,0xf6,0xd9,0x7a,0x6f,0x42,0x17] as IID_TypedEventHandler_2_Windows_ApplicationModel_Wallet_System_WalletItemSystemStore_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for TypedEventHandler<super::applicationmodel::wallet::WalletItemStore, IInspectable> => [0x07fc9084,0x9ea1,0x5505,0x89,0xcc,0x4d,0x75,0x47,0x19,0xf5,0x82] as IID_TypedEventHandler_2_Windows_ApplicationModel_Wallet_WalletItemStore_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusAttachment, super::devices::alljoyn::AllJoynAcceptSessionJoinerEventArgs> => [0xdd224d96,0xf45c,0x5e3d,0x88,0x60,0x85,0x96,0xd0,0xe4,0x74,0xf0] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusAttachment_Windows_Devices_AllJoyn_AllJoynAcceptSessionJoinerEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusAttachment, super::devices::alljoyn::AllJoynAuthenticationCompleteEventArgs> => [0xe4fd18b4,0x4cde,0x508e,0x80,0x84,0x63,0xe7,0x28,0x32,0x62,0xc5] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusAttachment_Windows_Devices_AllJoyn_AllJoynAuthenticationCompleteEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusAttachment, super::devices::alljoyn::AllJoynBusAttachmentStateChangedEventArgs> => [0x82a8561d,0x3693,0x5c90,0x8c,0xf2,0x58,0xde,0x83,0xd8,0x02,0x43] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusAttachment_Windows_Devices_AllJoyn_AllJoynBusAttachmentStateChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusAttachment, super::devices::alljoyn::AllJoynCredentialsRequestedEventArgs> => [0xab2196e7,0x4b41,0x53bd,0x95,0xb1,0xb8,0x0c,0xad,0x82,0x47,0x95] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusAttachment_Windows_Devices_AllJoyn_AllJoynCredentialsRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusAttachment, super::devices::alljoyn::AllJoynCredentialsVerificationRequestedEventArgs> => [0x7ef99c96,0x51b1,0x5670,0xa4,0x1f,0xae,0x40,0x4f,0x2f,0xf5,0x3f] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusAttachment_Windows_Devices_AllJoyn_AllJoynCredentialsVerificationRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusAttachment, super::devices::alljoyn::AllJoynSessionJoinedEventArgs> => [0x56bb8d26,0x39b6,0x53fa,0x80,0x13,0x37,0x81,0xaa,0x27,0xa0,0xbc] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusAttachment_Windows_Devices_AllJoyn_AllJoynSessionJoinedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynBusObject, super::devices::alljoyn::AllJoynBusObjectStoppedEventArgs> => [0x9871592f,0x823d,0x5630,0xbe,0x72,0xca,0x8f,0x17,0x84,0x6b,0x71] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynBusObject_Windows_Devices_AllJoyn_AllJoynBusObjectStoppedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynSession, super::devices::alljoyn::AllJoynSessionLostEventArgs> => [0xdffc2b25,0x5ae2,0x52f1,0xbb,0xc4,0x36,0x3c,0xef,0xed,0xa0,0x3f] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynSession_Windows_Devices_AllJoyn_AllJoynSessionLostEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynSession, super::devices::alljoyn::AllJoynSessionMemberAddedEventArgs> => [0x330baa61,0x1c24,0x5faa,0xaf,0x3c,0x4d,0x69,0xad,0x2f,0x1e,0x31] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynSession_Windows_Devices_AllJoyn_AllJoynSessionMemberAddedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::alljoyn::AllJoynSession, super::devices::alljoyn::AllJoynSessionMemberRemovedEventArgs> => [0x2969ed7c,0xdb6c,0x58aa,0x9f,0x6d,0x89,0xe7,0xfe,0x08,0x9f,0xc1] as IID_TypedEventHandler_2_Windows_Devices_AllJoyn_AllJoynSession_Windows_Devices_AllJoyn_AllJoynSessionMemberRemovedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::advertisement::BluetoothLEAdvertisementPublisher, super::devices::bluetooth::advertisement::BluetoothLEAdvertisementPublisherStatusChangedEventArgs> => [0xc2ffa4f1,0x5893,0x54a8,0xbd,0x94,0xaa,0x11,0x98,0xb0,0x5d,0x07] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementPublisher_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementPublisherStatusChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::advertisement::BluetoothLEAdvertisementWatcher, super::devices::bluetooth::advertisement::BluetoothLEAdvertisementReceivedEventArgs> => [0x90eb4eca,0xd465,0x5ea0,0xa6,0x1c,0x03,0x3c,0x8c,0x5e,0xce,0xf2] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementWatcher_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::advertisement::BluetoothLEAdvertisementWatcher, super::devices::bluetooth::advertisement::BluetoothLEAdvertisementWatcherStoppedEventArgs> => [0x9936a4db,0xdc99,0x55c3,0x9e,0x9b,0xbf,0x48,0x54,0xbd,0x9e,0xab] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementWatcher_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementWatcherStoppedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::BluetoothDevice, IInspectable> => [0xdb56ce1c,0x5e9f,0x5138,0x92,0x27,0xb1,0xa6,0x6d,0x60,0xbc,0x1b] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_BluetoothDevice_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::BluetoothLEDevice, IInspectable> => [0xa90661e2,0x372e,0x5d1e,0xbb,0xbb,0xb8,0xa2,0xce,0x0e,0x7c,0x4d] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_BluetoothLEDevice_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattCharacteristic, super::devices::bluetooth::genericattributeprofile::GattValueChangedEventArgs> => [0xc1f420f6,0x6292,0x5760,0xa2,0xc9,0x9d,0xdf,0x98,0x68,0x3c,0xfc] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCharacteristic_Windows_Devices_Bluetooth_GenericAttributeProfile_GattValueChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristic, IInspectable> => [0x8087acd6,0xaed7,0x53eb,0x9b,0x23,0x48,0x08,0xbb,0x91,0x0c,0x17] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristic_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristic, super::devices::bluetooth::genericattributeprofile::GattReadRequestedEventArgs> => [0x218a3e4a,0xaa9d,0x500e,0xbc,0xa7,0x04,0x77,0x51,0xbb,0x10,0xa3] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristic_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristic, super::devices::bluetooth::genericattributeprofile::GattWriteRequestedEventArgs> => [0xed61a2fb,0x7d2a,0x5ba3,0x8e,0xbf,0x8a,0xd8,0x78,0xe5,0x39,0xa9] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristic_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattLocalDescriptor, super::devices::bluetooth::genericattributeprofile::GattReadRequestedEventArgs> => [0x252dca5c,0x86e7,0x5be1,0xae,0xed,0xf7,0x8c,0x6e,0xd4,0x66,0xab] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalDescriptor_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattLocalDescriptor, super::devices::bluetooth::genericattributeprofile::GattWriteRequestedEventArgs> => [0x6cf5b169,0x3731,0x591b,0xae,0x7c,0xd9,0x39,0xfa,0xaa,0x8a,0x71] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalDescriptor_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattReadRequest, super::devices::bluetooth::genericattributeprofile::GattRequestStateChangedEventArgs> => [0x0246e199,0x5199,0x5bdb,0x91,0x9d,0x85,0x44,0xce,0x30,0xfd,0x71] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattReadRequest_Windows_Devices_Bluetooth_GenericAttributeProfile_GattRequestStateChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattServiceProvider, super::devices::bluetooth::genericattributeprofile::GattServiceProviderAdvertisementStatusChangedEventArgs> => [0x56ce41b0,0x2570,0x50d3,0xa1,0xb1,0x7e,0x41,0x67,0xe1,0xfd,0xe7] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattServiceProvider_Windows_Devices_Bluetooth_GenericAttributeProfile_GattServiceProviderAdvertisementStatusChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattSession, IInspectable> => [0x6c7ec2ec,0x9f00,0x5ea0,0x9a,0x08,0x60,0xe5,0x07,0x0b,0xcf,0x03] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSession_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattSession, super::devices::bluetooth::genericattributeprofile::GattSessionStatusChangedEventArgs> => [0x0e1210f2,0x7b6f,0x543e,0x8a,0xdb,0xa6,0x1d,0x34,0xab,0x53,0x5d] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSession_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSessionStatusChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattSubscribedClient, IInspectable> => [0x9c17a110,0x806d,0x594b,0xb3,0x3d,0xed,0x28,0x0b,0xbf,0x27,0xe5] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSubscribedClient_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::bluetooth::genericattributeprofile::GattWriteRequest, super::devices::bluetooth::genericattributeprofile::GattRequestStateChangedEventArgs> => [0x7744c6bc,0xcdcd,0x5283,0x9e,0x4f,0x2e,0x21,0xb4,0x9a,0x2e,0xf2] as IID_TypedEventHandler_2_Windows_Devices_Bluetooth_GenericAttributeProfile_GattWriteRequest_Windows_Devices_Bluetooth_GenericAttributeProfile_GattRequestStateChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DeviceAccessInformation, super::devices::enumeration::DeviceAccessChangedEventArgs> => [0x4c71d028,0xb793,0x5bce,0xae,0x59,0xfa,0x77,0xf4,0x5a,0x40,0xd8] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DeviceAccessInformation_Windows_Devices_Enumeration_DeviceAccessChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DeviceInformationCustomPairing, super::devices::enumeration::DevicePairingRequestedEventArgs> => [0xfa65231f,0x4178,0x5de1,0xb2,0xcc,0x03,0xe2,0x2d,0x77,0x02,0xb4] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DeviceInformationCustomPairing_Windows_Devices_Enumeration_DevicePairingRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DevicePicker, IInspectable> => [0x62c6d98c,0x57ee,0x5bb8,0xa4,0x1c,0x95,0x8d,0x20,0xc3,0xf3,0xe8] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DevicePicker_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DevicePicker, super::devices::enumeration::DeviceDisconnectButtonClickedEventArgs> => [0x35dd0319,0x5723,0x506c,0x88,0x96,0x1a,0x28,0xb8,0x2b,0xe7,0x98] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DevicePicker_Windows_Devices_Enumeration_DeviceDisconnectButtonClickedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DevicePicker, super::devices::enumeration::DeviceSelectedEventArgs> => [0x47e48c88,0x1c56,0x5b58,0x96,0xa2,0x8e,0x81,0x3d,0x25,0x07,0x7a] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DevicePicker_Windows_Devices_Enumeration_DeviceSelectedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DeviceWatcher, IInspectable> => [0x9234630f,0x1ff4,0x54f6,0x9e,0x3f,0xac,0x20,0x36,0x9b,0x77,0x25] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DeviceWatcher_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DeviceWatcher, super::devices::enumeration::DeviceInformation> => [0x03c5a07b,0x990c,0x5d09,0xb0,0xb8,0x57,0x34,0xea,0xa3,0x82,0x22] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DeviceWatcher_Windows_Devices_Enumeration_DeviceInformation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::DeviceWatcher, super::devices::enumeration::DeviceInformationUpdate> => [0x906f1254,0x79ad,0x54fc,0x93,0xc4,0xcd,0xb9,0x9b,0x43,0x78,0x99] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_DeviceWatcher_Windows_Devices_Enumeration_DeviceInformationUpdate }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::pnp::PnpObjectWatcher, IInspectable> => [0x2ee2b4c9,0xb696,0x5ecc,0xb2,0x9b,0xf1,0xe0,0xef,0x5f,0xe1,0xf7] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_Pnp_PnpObjectWatcher_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::pnp::PnpObjectWatcher, super::devices::enumeration::pnp::PnpObject> => [0xd578eed2,0x58e5,0x5825,0x8a,0xf2,0x12,0xf8,0x93,0x87,0xb6,0x56] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_Pnp_PnpObjectWatcher_Windows_Devices_Enumeration_Pnp_PnpObject }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::enumeration::pnp::PnpObjectWatcher, super::devices::enumeration::pnp::PnpObjectUpdate> => [0xaf8f929d,0x8058,0x5c38,0xa3,0xd8,0x30,0xaa,0x7a,0x08,0xb5,0x88] as IID_TypedEventHandler_2_Windows_Devices_Enumeration_Pnp_PnpObjectWatcher_Windows_Devices_Enumeration_Pnp_PnpObjectUpdate }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::geolocation::geofencing::GeofenceMonitor, IInspectable> => [0xecc5af2c,0xe47a,0x59ce,0x86,0xbe,0x9c,0x30,0x66,0xfe,0x26,0xf7] as IID_TypedEventHandler_2_Windows_Devices_Geolocation_Geofencing_GeofenceMonitor_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::geolocation::Geolocator, super::devices::geolocation::PositionChangedEventArgs> => [0xdf3c6164,0x4e7b,0x5e8e,0x9a,0x7e,0x13,0xda,0x05,0x9d,0xec,0x1e] as IID_TypedEventHandler_2_Windows_Devices_Geolocation_Geolocator_Windows_Devices_Geolocation_PositionChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::geolocation::Geolocator, super::devices::geolocation::StatusChangedEventArgs> => [0x97fcf582,0xde6b,0x5cd3,0x96,0x90,0xe2,0xec,0xbb,0x66,0xda,0x4d] as IID_TypedEventHandler_2_Windows_Devices_Geolocation_Geolocator_Windows_Devices_Geolocation_StatusChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::geolocation::GeovisitMonitor, super::devices::geolocation::GeovisitStateChangedEventArgs> => [0x76abc5ea,0xee4f,0x5391,0x9b,0x50,0xde,0xca,0x5d,0x43,0x11,0xc9] as IID_TypedEventHandler_2_Windows_Devices_Geolocation_GeovisitMonitor_Windows_Devices_Geolocation_GeovisitStateChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::gpio::GpioPin, super::devices::gpio::GpioPinValueChangedEventArgs> => [0x44ba689b,0x7d42,0x5374,0xad,0xd9,0xab,0x41,0xe8,0x77,0xa3,0x4b] as IID_TypedEventHandler_2_Windows_Devices_Gpio_GpioPin_Windows_Devices_Gpio_GpioPinValueChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::gpio::provider::IGpioPinProvider, super::devices::gpio::provider::GpioPinProviderValueChangedEventArgs> => [0xaf259d89,0x9e01,0x529e,0xa8,0x79,0xc6,0x76,0x31,0x42,0xd1,0x60] as IID_TypedEventHandler_2_Windows_Devices_Gpio_Provider_IGpioPinProvider_Windows_Devices_Gpio_Provider_GpioPinProviderValueChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::humaninterfacedevice::HidDevice, super::devices::humaninterfacedevice::HidInputReportReceivedEventArgs> => [0x31e757c8,0x8f6a,0x540b,0x93,0x8b,0xab,0xa7,0x9b,0x6f,0x03,0xec] as IID_TypedEventHandler_2_Windows_Devices_HumanInterfaceDevice_HidDevice_Windows_Devices_HumanInterfaceDevice_HidInputReportReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::input::MouseDevice, super::devices::input::MouseEventArgs> => [0x5d72e594,0x28e4,0x5895,0xa3,0x4b,0xea,0x91,0x0f,0x70,0xfd,0xbb] as IID_TypedEventHandler_2_Windows_Devices_Input_MouseDevice_Windows_Devices_Input_MouseEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::lights::Lamp, super::devices::lights::LampAvailabilityChangedEventArgs> => [0x556a02d9,0x7685,0x576f,0x89,0xca,0xb6,0x2d,0xc4,0x81,0xd2,0x9d] as IID_TypedEventHandler_2_Windows_Devices_Lights_Lamp_Windows_Devices_Lights_LampAvailabilityChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::midi::MidiInPort, super::devices::midi::MidiMessageReceivedEventArgs> => [0x50017240,0xcc39,0x5775,0x8a,0x6b,0xf6,0xf2,0x23,0x86,0xbf,0xca] as IID_TypedEventHandler_2_Windows_Devices_Midi_MidiInPort_Windows_Devices_Midi_MidiMessageReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionColorFrameReader, super::devices::perception::PerceptionColorFrameArrivedEventArgs> => [0xa4a50ea5,0x778d,0x5056,0xa1,0xcf,0x54,0x6a,0x1b,0xe2,0xc0,0x10] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionColorFrameReader_Windows_Devices_Perception_PerceptionColorFrameArrivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionColorFrameSource, IInspectable> => [0x023444d9,0x7b47,0x5497,0x95,0x69,0x43,0x99,0xfa,0xf9,0x67,0x17] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionColorFrameSource_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionColorFrameSource, super::devices::perception::PerceptionFrameSourcePropertiesChangedEventArgs> => [0xb2c3a488,0x7ed9,0x5110,0x80,0x4a,0x97,0x92,0xef,0x7f,0x26,0xbe] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionColorFrameSource_Windows_Devices_Perception_PerceptionFrameSourcePropertiesChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionColorFrameSourceWatcher, IInspectable> => [0xb3f5bf64,0x7fc0,0x5d8c,0x97,0x8c,0xa3,0x8d,0x5b,0x18,0xa5,0x1d] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionColorFrameSourceWatcher_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionColorFrameSourceWatcher, super::devices::perception::PerceptionColorFrameSourceAddedEventArgs> => [0x7202e817,0x22b8,0x5e7b,0x86,0xb5,0xc4,0xa9,0x0c,0xcc,0x23,0xaa] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionColorFrameSourceWatcher_Windows_Devices_Perception_PerceptionColorFrameSourceAddedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionColorFrameSourceWatcher, super::devices::perception::PerceptionColorFrameSourceRemovedEventArgs> => [0xc7131ddd,0xff22,0x5fb7,0xad,0xa0,0x96,0x1e,0x3b,0x28,0x91,0x7b] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionColorFrameSourceWatcher_Windows_Devices_Perception_PerceptionColorFrameSourceRemovedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionControlSession, IInspectable> => [0xabc21152,0x2495,0x5e8c,0xae,0xd3,0x7d,0xc5,0x53,0x09,0xac,0x08] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionControlSession_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionDepthFrameReader, super::devices::perception::PerceptionDepthFrameArrivedEventArgs> => [0x4d529b7e,0xeea0,0x511b,0x82,0x85,0x47,0xe8,0xc8,0x5d,0x02,0x95] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionDepthFrameReader_Windows_Devices_Perception_PerceptionDepthFrameArrivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionDepthFrameSource, IInspectable> => [0x135ba76a,0xab44,0x5f69,0xb2,0x08,0xe7,0x32,0xcc,0xe9,0x40,0x3b] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionDepthFrameSource_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionDepthFrameSource, super::devices::perception::PerceptionFrameSourcePropertiesChangedEventArgs> => [0x188fdef2,0xd829,0x548b,0xa8,0x9d,0x38,0xa3,0x4c,0x5c,0xb6,0x41] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionDepthFrameSource_Windows_Devices_Perception_PerceptionFrameSourcePropertiesChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionDepthFrameSourceWatcher, IInspectable> => [0xc5efa976,0xd948,0x50c7,0x85,0x55,0x66,0x41,0x90,0xf9,0xa9,0x68] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionDepthFrameSourceWatcher_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionDepthFrameSourceWatcher, super::devices::perception::PerceptionDepthFrameSourceAddedEventArgs> => [0xa3c1e25f,0x3574,0x5a27,0xa7,0x91,0x16,0xe1,0xbc,0xc4,0x24,0xf4] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionDepthFrameSourceWatcher_Windows_Devices_Perception_PerceptionDepthFrameSourceAddedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionDepthFrameSourceWatcher, super::devices::perception::PerceptionDepthFrameSourceRemovedEventArgs> => [0x5cf5faf7,0x0785,0x5589,0xa6,0x21,0x08,0x9d,0x90,0x04,0x12,0xc8] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionDepthFrameSourceWatcher_Windows_Devices_Perception_PerceptionDepthFrameSourceRemovedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionInfraredFrameReader, super::devices::perception::PerceptionInfraredFrameArrivedEventArgs> => [0x687fef67,0x8871,0x56fe,0x8e,0x7e,0x1d,0x29,0x29,0xcc,0x6f,0x42] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionInfraredFrameReader_Windows_Devices_Perception_PerceptionInfraredFrameArrivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionInfraredFrameSource, IInspectable> => [0x31edabbd,0xd123,0x5e88,0x89,0xd8,0xc8,0x0e,0xe8,0xf0,0xf2,0xca] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionInfraredFrameSource_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionInfraredFrameSource, super::devices::perception::PerceptionFrameSourcePropertiesChangedEventArgs> => [0xb6c1b828,0xa157,0x54ed,0x9c,0x18,0x69,0x19,0xb9,0xf9,0x1b,0xe9] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionInfraredFrameSource_Windows_Devices_Perception_PerceptionFrameSourcePropertiesChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionInfraredFrameSourceWatcher, IInspectable> => [0x1555a628,0x3dff,0x5fd0,0xb1,0x0a,0xca,0x6a,0xdb,0x24,0x40,0xc6] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionInfraredFrameSourceWatcher_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionInfraredFrameSourceWatcher, super::devices::perception::PerceptionInfraredFrameSourceAddedEventArgs> => [0xa8180cd1,0xc25b,0x5c7f,0x94,0xdd,0x19,0x84,0x23,0xbb,0x56,0xd5] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionInfraredFrameSourceWatcher_Windows_Devices_Perception_PerceptionInfraredFrameSourceAddedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::perception::PerceptionInfraredFrameSourceWatcher, super::devices::perception::PerceptionInfraredFrameSourceRemovedEventArgs> => [0x2ca3a9b7,0x3348,0x5953,0x8d,0x0d,0xef,0x8d,0x78,0x64,0x0b,0x23] as IID_TypedEventHandler_2_Windows_Devices_Perception_PerceptionInfraredFrameSourceWatcher_Windows_Devices_Perception_PerceptionInfraredFrameSourceRemovedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::BarcodeScanner, super::devices::pointofservice::BarcodeScannerStatusUpdatedEventArgs> => [0xcfc8a053,0xf611,0x521a,0x8a,0xb0,0xa4,0x60,0xe1,0xf7,0x16,0x4d] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_BarcodeScanner_Windows_Devices_PointOfService_BarcodeScannerStatusUpdatedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::CashDrawer, super::devices::pointofservice::CashDrawerStatusUpdatedEventArgs> => [0x64662ef4,0xcb0e,0x5c6f,0xa8,0x20,0x7d,0x0a,0x76,0x95,0x54,0xc9] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_CashDrawer_Windows_Devices_PointOfService_CashDrawerStatusUpdatedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::CashDrawerCloseAlarm, IInspectable> => [0xc54fbda4,0x5e0b,0x54c3,0x94,0xf2,0x83,0x35,0x1e,0x41,0xc4,0x6f] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_CashDrawerCloseAlarm_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::CashDrawerEventSource, super::devices::pointofservice::CashDrawerClosedEventArgs> => [0x81495aa4,0x4476,0x577f,0xbf,0x88,0x7f,0xe8,0xa1,0x28,0x64,0x44] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_CashDrawerEventSource_Windows_Devices_PointOfService_CashDrawerClosedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::CashDrawerEventSource, super::devices::pointofservice::CashDrawerOpenedEventArgs> => [0x27648799,0xe7d5,0x5ce3,0x97,0xce,0x2f,0x41,0x10,0xdd,0x32,0x98] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_CashDrawerEventSource_Windows_Devices_PointOfService_CashDrawerOpenedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedBarcodeScanner, super::devices::pointofservice::BarcodeScannerDataReceivedEventArgs> => [0x4f64e49a,0xbd8c,0x549d,0x97,0x0c,0xa5,0xa2,0x50,0xbd,0x27,0xca] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedBarcodeScanner_Windows_Devices_PointOfService_BarcodeScannerDataReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedBarcodeScanner, super::devices::pointofservice::BarcodeScannerErrorOccurredEventArgs> => [0xba42ff49,0xde12,0x5406,0x97,0x9e,0x06,0xc4,0x5c,0xa2,0xd5,0xa4] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedBarcodeScanner_Windows_Devices_PointOfService_BarcodeScannerErrorOccurredEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedBarcodeScanner, super::devices::pointofservice::BarcodeScannerImagePreviewReceivedEventArgs> => [0xfba116af,0x2a39,0x516f,0xa5,0x79,0xcc,0x3e,0xaf,0x36,0xa3,0x4b] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedBarcodeScanner_Windows_Devices_PointOfService_BarcodeScannerImagePreviewReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedCashDrawer, IInspectable> => [0xdb886581,0x2462,0x5c81,0x88,0x0c,0x06,0x11,0x2c,0xa7,0x00,0x12] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedCashDrawer_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedLineDisplay, IInspectable> => [0xc997782b,0x46e9,0x5d92,0xac,0x84,0xee,0x9d,0x7d,0x07,0x3a,0xb5] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedLineDisplay_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedLineDisplay, super::devices::pointofservice::LineDisplayStatusUpdatedEventArgs> => [0x25d178ff,0x3069,0x536c,0xa0,0xc2,0x88,0xe0,0x25,0x0e,0x8a,0x29] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedLineDisplay_Windows_Devices_PointOfService_LineDisplayStatusUpdatedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedMagneticStripeReader, super::devices::pointofservice::MagneticStripeReaderAamvaCardDataReceivedEventArgs> => [0x29e08f92,0xc3ab,0x57ea,0xaa,0xba,0x78,0x9f,0x79,0x2d,0x7a,0x46] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedMagneticStripeReader_Windows_Devices_PointOfService_MagneticStripeReaderAamvaCardDataReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedMagneticStripeReader, super::devices::pointofservice::MagneticStripeReaderBankCardDataReceivedEventArgs> => [0x6a41d015,0x245e,0x51ba,0xbd,0x6c,0x44,0x77,0x5d,0x70,0xbf,0xa2] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedMagneticStripeReader_Windows_Devices_PointOfService_MagneticStripeReaderBankCardDataReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedMagneticStripeReader, super::devices::pointofservice::MagneticStripeReaderErrorOccurredEventArgs> => [0x1464a1e6,0x9d92,0x547e,0xb4,0xac,0xf2,0x55,0xac,0x85,0xf9,0x50] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedMagneticStripeReader_Windows_Devices_PointOfService_MagneticStripeReaderErrorOccurredEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedMagneticStripeReader, super::devices::pointofservice::MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs> => [0x959124ba,0xee44,0x560c,0x81,0x83,0x61,0xc6,0xa2,0x30,0x8d,0x8f] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedMagneticStripeReader_Windows_Devices_PointOfService_MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::ClaimedPosPrinter, super::devices::pointofservice::PosPrinterReleaseDeviceRequestedEventArgs> => [0x31424f6f,0xcfeb,0x5031,0x8a,0x95,0xbe,0xa5,0x9b,0x09,0xe5,0x84] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_ClaimedPosPrinter_Windows_Devices_PointOfService_PosPrinterReleaseDeviceRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::MagneticStripeReader, super::devices::pointofservice::MagneticStripeReaderStatusUpdatedEventArgs> => [0x722d8bfa,0xe10e,0x548d,0xaf,0x29,0x28,0xdd,0x90,0x6f,0x6f,0xc9] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_MagneticStripeReader_Windows_Devices_PointOfService_MagneticStripeReaderStatusUpdatedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::pointofservice::PosPrinter, super::devices::pointofservice::PosPrinterStatusUpdatedEventArgs> => [0x20b0c66a,0x5f41,0x5a32,0xb4,0x5a,0x34,0x4f,0x12,0xe7,0x0a,0x34] as IID_TypedEventHandler_2_Windows_Devices_PointOfService_PosPrinter_Windows_Devices_PointOfService_PosPrinterStatusUpdatedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::power::Battery, IInspectable> => [0x4d4aa646,0x767f,0x5645,0xaf,0x5c,0x54,0x64,0x64,0xd3,0xec,0x09] as IID_TypedEventHandler_2_Windows_Devices_Power_Battery_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::printers::extensions::Print3DWorkflow, super::devices::printers::extensions::Print3DWorkflowPrinterChangedEventArgs> => [0xb4b5ddc2,0x1a74,0x5905,0x9f,0xc5,0xdd,0xaa,0xe9,0xa3,0xab,0x93] as IID_TypedEventHandler_2_Windows_Devices_Printers_Extensions_Print3DWorkflow_Windows_Devices_Printers_Extensions_Print3DWorkflowPrinterChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::printers::extensions::Print3DWorkflow, super::devices::printers::extensions::Print3DWorkflowPrintRequestedEventArgs> => [0x5f4c6603,0x5512,0x59aa,0x8d,0x96,0xb1,0x38,0x9d,0x8b,0x57,0x96] as IID_TypedEventHandler_2_Windows_Devices_Printers_Extensions_Print3DWorkflow_Windows_Devices_Printers_Extensions_Print3DWorkflowPrintRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::printers::extensions::PrintTaskConfiguration, super::devices::printers::extensions::PrintTaskConfigurationSaveRequestedEventArgs> => [0x0363f57a,0xb7a2,0x5e20,0xa1,0x56,0x25,0x34,0x23,0xe7,0xee,0x40] as IID_TypedEventHandler_2_Windows_Devices_Printers_Extensions_PrintTaskConfiguration_Windows_Devices_Printers_Extensions_PrintTaskConfigurationSaveRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::radios::Radio, IInspectable> => [0xfc6aa329,0xb586,0x5ebb,0x9e,0x85,0x3f,0x6b,0x84,0xeb,0xdf,0x18] as IID_TypedEventHandler_2_Windows_Devices_Radios_Radio_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Accelerometer, super::devices::sensors::AccelerometerReadingChangedEventArgs> => [0xa5e83e40,0xb597,0x5b83,0x92,0xf5,0x5b,0xed,0x39,0x26,0xca,0x80] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Accelerometer_Windows_Devices_Sensors_AccelerometerReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Accelerometer, super::devices::sensors::AccelerometerShakenEventArgs> => [0x3e5d6eaf,0xf169,0x5d60,0x92,0xb0,0x98,0xcd,0x6b,0xd8,0xf8,0x08] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Accelerometer_Windows_Devices_Sensors_AccelerometerShakenEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::ActivitySensor, super::devices::sensors::ActivitySensorReadingChangedEventArgs> => [0xa5b72e01,0x546c,0x5fbb,0xb8,0x47,0x49,0x20,0x0a,0xaa,0xaa,0xc5] as IID_TypedEventHandler_2_Windows_Devices_Sensors_ActivitySensor_Windows_Devices_Sensors_ActivitySensorReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Altimeter, super::devices::sensors::AltimeterReadingChangedEventArgs> => [0xd775d699,0x9d74,0x5473,0x9c,0x1b,0xd5,0x1a,0x89,0xdb,0x66,0x42] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Altimeter_Windows_Devices_Sensors_AltimeterReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Barometer, super::devices::sensors::BarometerReadingChangedEventArgs> => [0xe4caf459,0xd101,0x5ca5,0xa4,0xea,0xde,0xb0,0x91,0x7a,0xe2,0x7e] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Barometer_Windows_Devices_Sensors_BarometerReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Compass, super::devices::sensors::CompassReadingChangedEventArgs> => [0xe787d73d,0xa121,0x5ae6,0xb4,0x97,0xab,0x93,0x48,0x37,0xe5,0x7f] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Compass_Windows_Devices_Sensors_CompassReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::custom::CustomSensor, super::devices::sensors::custom::CustomSensorReadingChangedEventArgs> => [0xaa9460cb,0xf08c,0x5963,0xb2,0x32,0xcc,0x40,0x75,0xe9,0x84,0xe7] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Custom_CustomSensor_Windows_Devices_Sensors_Custom_CustomSensorReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Gyrometer, super::devices::sensors::GyrometerReadingChangedEventArgs> => [0x15171524,0x5786,0x59a5,0xaf,0x5b,0xa0,0x12,0x45,0x72,0x6c,0x44] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Gyrometer_Windows_Devices_Sensors_GyrometerReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Inclinometer, super::devices::sensors::InclinometerReadingChangedEventArgs> => [0x6f3b411f,0xd147,0x59f1,0xbb,0xe4,0x7b,0xec,0x39,0x6c,0x7b,0x6e] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Inclinometer_Windows_Devices_Sensors_InclinometerReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::LightSensor, super::devices::sensors::LightSensorReadingChangedEventArgs> => [0x1ecf183a,0x9f0a,0x5f73,0x92,0x25,0x5a,0x33,0xea,0xb5,0x59,0x4f] as IID_TypedEventHandler_2_Windows_Devices_Sensors_LightSensor_Windows_Devices_Sensors_LightSensorReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Magnetometer, super::devices::sensors::MagnetometerReadingChangedEventArgs> => [0xf9a0da76,0xc4fd,0x50ab,0x98,0xb6,0xbf,0xd2,0x6d,0x6d,0x3d,0x82] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Magnetometer_Windows_Devices_Sensors_MagnetometerReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::OrientationSensor, super::devices::sensors::OrientationSensorReadingChangedEventArgs> => [0x91ae0c43,0xe1f7,0x577d,0xa1,0x61,0x8a,0xaf,0x27,0x5e,0xb9,0x27] as IID_TypedEventHandler_2_Windows_Devices_Sensors_OrientationSensor_Windows_Devices_Sensors_OrientationSensorReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::Pedometer, super::devices::sensors::PedometerReadingChangedEventArgs> => [0xdcd47693,0xaad5,0x5b3c,0x9c,0x8d,0x14,0x0b,0x8b,0xc2,0x12,0x2b] as IID_TypedEventHandler_2_Windows_Devices_Sensors_Pedometer_Windows_Devices_Sensors_PedometerReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::ProximitySensor, super::devices::sensors::ProximitySensorReadingChangedEventArgs> => [0x9f7e222b,0x892a,0x5e68,0xb0,0x8a,0x10,0x38,0x4b,0x5f,0x92,0xb9] as IID_TypedEventHandler_2_Windows_Devices_Sensors_ProximitySensor_Windows_Devices_Sensors_ProximitySensorReadingChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sensors::SimpleOrientationSensor, super::devices::sensors::SimpleOrientationSensorOrientationChangedEventArgs> => [0x92437fa7,0xea7b,0x5fc5,0x8e,0xcf,0x1b,0x91,0x1b,0xea,0x2b,0xfc] as IID_TypedEventHandler_2_Windows_Devices_Sensors_SimpleOrientationSensor_Windows_Devices_Sensors_SimpleOrientationSensorOrientationChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::serialcommunication::SerialDevice, super::devices::serialcommunication::ErrorReceivedEventArgs> => [0xd92ea323,0xb7bf,0x5e02,0xb9,0xfb,0xc6,0x1f,0x97,0xd0,0x80,0xe9] as IID_TypedEventHandler_2_Windows_Devices_SerialCommunication_SerialDevice_Windows_Devices_SerialCommunication_ErrorReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::serialcommunication::SerialDevice, super::devices::serialcommunication::PinChangedEventArgs> => [0xe496c3ef,0x5802,0x5ac4,0xac,0x2e,0x96,0xbc,0x23,0xfa,0x94,0x47] as IID_TypedEventHandler_2_Windows_Devices_SerialCommunication_SerialDevice_Windows_Devices_SerialCommunication_PinChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::smartcards::SmartCardEmulator, super::devices::smartcards::SmartCardEmulatorApduReceivedEventArgs> => [0x146f9403,0x42f4,0x59a2,0xa8,0x5a,0x82,0x94,0xaf,0x3e,0x3e,0x78] as IID_TypedEventHandler_2_Windows_Devices_SmartCards_SmartCardEmulator_Windows_Devices_SmartCards_SmartCardEmulatorApduReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::smartcards::SmartCardEmulator, super::devices::smartcards::SmartCardEmulatorConnectionDeactivatedEventArgs> => [0xcb9840cb,0xcc46,0x5c37,0xab,0x00,0xdd,0x23,0xd7,0x7b,0x26,0x3b] as IID_TypedEventHandler_2_Windows_Devices_SmartCards_SmartCardEmulator_Windows_Devices_SmartCards_SmartCardEmulatorConnectionDeactivatedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::smartcards::SmartCardReader, super::devices::smartcards::CardAddedEventArgs> => [0xd36f2db9,0x5674,0x5f74,0x9f,0x69,0x3c,0xdc,0x45,0x59,0x99,0x9f] as IID_TypedEventHandler_2_Windows_Devices_SmartCards_SmartCardReader_Windows_Devices_SmartCards_CardAddedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::smartcards::SmartCardReader, super::devices::smartcards::CardRemovedEventArgs> => [0x69da07c6,0xb266,0x5a1c,0x93,0x7c,0xd8,0x2b,0x4a,0x82,0x32,0xc6] as IID_TypedEventHandler_2_Windows_Devices_SmartCards_SmartCardReader_Windows_Devices_SmartCards_CardRemovedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sms::SmsDevice2, IInspectable> => [0x3f3808e6,0x3dee,0x57a6,0xa8,0x8d,0xba,0xcf,0xb0,0x66,0xc7,0xfb] as IID_TypedEventHandler_2_Windows_Devices_Sms_SmsDevice2_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::sms::SmsMessageRegistration, super::devices::sms::SmsMessageReceivedTriggerDetails> => [0x33f985c7,0xdcfa,0x531f,0x9c,0xce,0xee,0x5e,0x6c,0x26,0xb1,0xe6] as IID_TypedEventHandler_2_Windows_Devices_Sms_SmsMessageRegistration_Windows_Devices_Sms_SmsMessageReceivedTriggerDetails }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::usb::UsbInterruptInPipe, super::devices::usb::UsbInterruptInEventArgs> => [0xe6db9449,0xf36a,0x50f2,0x92,0x6c,0x2a,0xfd,0x85,0xc4,0x9f,0x01] as IID_TypedEventHandler_2_Windows_Devices_Usb_UsbInterruptInPipe_Windows_Devices_Usb_UsbInterruptInEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifi::WiFiAdapter, IInspectable> => [0xf6c02d1b,0x43e8,0x5fc8,0x8e,0x8e,0xee,0x7b,0x80,0x94,0xb6,0x83] as IID_TypedEventHandler_2_Windows_Devices_WiFi_WiFiAdapter_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::services::WiFiDirectService, super::devices::wifidirect::services::WiFiDirectServiceSessionDeferredEventArgs> => [0xfc3dfc2c,0x9cfa,0x5822,0xba,0x3f,0xff,0x3a,0xfb,0x65,0x77,0x7e] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_Services_WiFiDirectService_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceSessionDeferredEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::services::WiFiDirectServiceAdvertiser, IInspectable> => [0x67fc3121,0xc1a0,0x5c23,0xaf,0x58,0xec,0xb7,0xf2,0xa7,0xd7,0x73] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceAdvertiser_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::services::WiFiDirectServiceAdvertiser, super::devices::wifidirect::services::WiFiDirectServiceAutoAcceptSessionConnectedEventArgs> => [0x3be2d508,0xa856,0x5c09,0x99,0x98,0x52,0x25,0x97,0xb4,0x4b,0x07] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceAdvertiser_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceAutoAcceptSessionConnectedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::services::WiFiDirectServiceAdvertiser, super::devices::wifidirect::services::WiFiDirectServiceSessionRequestedEventArgs> => [0xcb98fd74,0x871d,0x5730,0x91,0xfe,0x81,0xef,0x94,0x7f,0xe7,0x8f] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceAdvertiser_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceSessionRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::services::WiFiDirectServiceSession, IInspectable> => [0x10c33301,0xe31c,0x5cce,0xb2,0xa0,0xc1,0xdc,0x2d,0x8d,0x0e,0x13] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceSession_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::services::WiFiDirectServiceSession, super::devices::wifidirect::services::WiFiDirectServiceRemotePortAddedEventArgs> => [0x8326a337,0x3c19,0x57a7,0x80,0xec,0xcc,0xa2,0xea,0x62,0xef,0x12] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceSession_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceRemotePortAddedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::WiFiDirectAdvertisementPublisher, super::devices::wifidirect::WiFiDirectAdvertisementPublisherStatusChangedEventArgs> => [0xde73cba7,0x370d,0x550c,0xb2,0x3a,0x53,0xdd,0x0b,0x4e,0x48,0x0d] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_WiFiDirectAdvertisementPublisher_Windows_Devices_WiFiDirect_WiFiDirectAdvertisementPublisherStatusChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::WiFiDirectConnectionListener, super::devices::wifidirect::WiFiDirectConnectionRequestedEventArgs> => [0xd04b0403,0x1fe2,0x532f,0x8e,0x47,0x48,0x23,0xa1,0x4e,0x62,0x4f] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_WiFiDirectConnectionListener_Windows_Devices_WiFiDirect_WiFiDirectConnectionRequestedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for TypedEventHandler<super::devices::wifidirect::WiFiDirectDevice, IInspectable> => [0x9208929a,0x2a3c,0x50ad,0xaa,0x08,0xa0,0xa9,0x86,0xed,0xba,0xbe] as IID_TypedEventHandler_2_Windows_Devices_WiFiDirect_WiFiDirectDevice_System_Object }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for TypedEventHandler<super::gaming::input::IGameController, super::gaming::input::Headset> => [0x07b2f2b7,0x8825,0x5c4e,0xa0,0x52,0xfc,0xfe,0xdf,0x3a,0xee,0xa1] as IID_TypedEventHandler_2_Windows_Gaming_Input_IGameController_Windows_Gaming_Input_Headset }
#[cfg(all(feature="windows-gaming",feature="windows-system"))] RT_PINTERFACE!{ for TypedEventHandler<super::gaming::input::IGameController, super::system::UserChangedEventArgs> => [0xcb753f2c,0x2f36,0x5a8f,0xad,0xad,0x05,0x7b,0xea,0xe7,0x3a,0xa4] as IID_TypedEventHandler_2_Windows_Gaming_Input_IGameController_Windows_System_UserChangedEventArgs }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for TypedEventHandler<super::gaming::ui::GameChatOverlayMessageSource, super::gaming::ui::GameChatMessageReceivedEventArgs> => [0xfe4f13bf,0x689c,0x5fe3,0xb7,0xad,0x55,0xbc,0x57,0xf9,0x24,0x66] as IID_TypedEventHandler_2_Windows_Gaming_UI_GameChatOverlayMessageSource_Windows_Gaming_UI_GameChatMessageReceivedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::display::BrightnessOverride, IInspectable> => [0xa460214e,0x6620,0x521d,0x9c,0xb9,0xa0,0xa0,0xf7,0x32,0xce,0x90] as IID_TypedEventHandler_2_Windows_Graphics_Display_BrightnessOverride_System_Object }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::display::core::HdmiDisplayInformation, IInspectable> => [0xd109932b,0x9ce1,0x5cdd,0x94,0xc7,0x93,0xc6,0x0c,0x83,0x3a,0xa3] as IID_TypedEventHandler_2_Windows_Graphics_Display_Core_HdmiDisplayInformation_System_Object }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::display::DisplayInformation, IInspectable> => [0x86c4f619,0x67b6,0x51c7,0xb3,0x0d,0xd8,0xcf,0x13,0x62,0x53,0x27] as IID_TypedEventHandler_2_Windows_Graphics_Display_DisplayInformation_System_Object }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::holographic::HolographicSpace, super::graphics::holographic::HolographicSpaceCameraAddedEventArgs> => [0x71d80b7c,0x1d27,0x5102,0x83,0xd1,0x4f,0x0e,0xfc,0x7c,0x9d,0x6f] as IID_TypedEventHandler_2_Windows_Graphics_Holographic_HolographicSpace_Windows_Graphics_Holographic_HolographicSpaceCameraAddedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::holographic::HolographicSpace, super::graphics::holographic::HolographicSpaceCameraRemovedEventArgs> => [0xdb68cfc3,0x0874,0x502a,0xa3,0xb9,0x2b,0x1f,0xe8,0x6c,0x67,0xbe] as IID_TypedEventHandler_2_Windows_Graphics_Holographic_HolographicSpace_Windows_Graphics_Holographic_HolographicSpaceCameraRemovedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::optiondetails::PrintTaskOptionDetails, IInspectable> => [0x5c88455c,0x5b59,0x557c,0x80,0x64,0x5e,0x4f,0x3d,0x59,0xa8,0xec] as IID_TypedEventHandler_2_Windows_Graphics_Printing_OptionDetails_PrintTaskOptionDetails_System_Object }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::optiondetails::PrintTaskOptionDetails, super::graphics::printing::optiondetails::PrintTaskOptionChangedEventArgs> => [0x1b1f456b,0x8821,0x592e,0xb4,0xa7,0x9b,0x4c,0x37,0x12,0x51,0x8e] as IID_TypedEventHandler_2_Windows_Graphics_Printing_OptionDetails_PrintTaskOptionDetails_Windows_Graphics_Printing_OptionDetails_PrintTaskOptionChangedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::PrintManager, super::graphics::printing::PrintTaskRequestedEventArgs> => [0x8a8cb877,0x70c5,0x54ce,0x8b,0x42,0xd7,0x90,0xe2,0x91,0x48,0x59] as IID_TypedEventHandler_2_Windows_Graphics_Printing_PrintManager_Windows_Graphics_Printing_PrintTaskRequestedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::PrintTask, IInspectable> => [0x4cc141d4,0xc0d9,0x5220,0xb1,0xce,0x80,0xff,0xf3,0xbd,0x2d,0x44] as IID_TypedEventHandler_2_Windows_Graphics_Printing_PrintTask_System_Object }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::PrintTask, super::graphics::printing::PrintTaskCompletedEventArgs> => [0xb0b02549,0xb9ad,0x5226,0x89,0x8a,0x7b,0x56,0x3b,0x46,0x64,0x0c] as IID_TypedEventHandler_2_Windows_Graphics_Printing_PrintTask_Windows_Graphics_Printing_PrintTaskCompletedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::PrintTask, super::graphics::printing::PrintTaskProgressingEventArgs> => [0xc08d0524,0x5899,0x536c,0x8f,0x46,0x55,0xfd,0xaa,0x4c,0xf7,0x8b] as IID_TypedEventHandler_2_Windows_Graphics_Printing_PrintTask_Windows_Graphics_Printing_PrintTaskProgressingEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::workflow::PrintWorkflowBackgroundSession, super::graphics::printing::workflow::PrintWorkflowBackgroundSetupRequestedEventArgs> => [0xbb5c0591,0x4b11,0x511c,0x8e,0xf3,0x18,0x22,0xcb,0x71,0x42,0x7c] as IID_TypedEventHandler_2_Windows_Graphics_Printing_Workflow_PrintWorkflowBackgroundSession_Windows_Graphics_Printing_Workflow_PrintWorkflowBackgroundSetupRequestedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::workflow::PrintWorkflowBackgroundSession, super::graphics::printing::workflow::PrintWorkflowSubmittedEventArgs> => [0x9ec7b563,0x5044,0x5df3,0x98,0xb5,0x3a,0x56,0x43,0xfc,0x59,0xfe] as IID_TypedEventHandler_2_Windows_Graphics_Printing_Workflow_PrintWorkflowBackgroundSession_Windows_Graphics_Printing_Workflow_PrintWorkflowSubmittedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::workflow::PrintWorkflowForegroundSession, super::graphics::printing::workflow::PrintWorkflowForegroundSetupRequestedEventArgs> => [0xd85b48f0,0x960b,0x5f65,0x98,0xb1,0x5f,0x9b,0x09,0xfe,0xb2,0xf6] as IID_TypedEventHandler_2_Windows_Graphics_Printing_Workflow_PrintWorkflowForegroundSession_Windows_Graphics_Printing_Workflow_PrintWorkflowForegroundSetupRequestedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing::workflow::PrintWorkflowForegroundSession, super::graphics::printing::workflow::PrintWorkflowXpsDataAvailableEventArgs> => [0x6d38ab29,0x2bb3,0x5849,0x80,0xcd,0xec,0xe1,0x3a,0x58,0x9d,0x13] as IID_TypedEventHandler_2_Windows_Graphics_Printing_Workflow_PrintWorkflowForegroundSession_Windows_Graphics_Printing_Workflow_PrintWorkflowXpsDataAvailableEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing3d::Print3DManager, super::graphics::printing3d::Print3DTaskRequestedEventArgs> => [0x77c464a3,0xa7c6,0x5512,0x98,0x59,0x41,0x2d,0xb3,0xf6,0x6a,0xc4] as IID_TypedEventHandler_2_Windows_Graphics_Printing3D_Print3DManager_Windows_Graphics_Printing3D_Print3DTaskRequestedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing3d::Print3DTask, IInspectable> => [0xc0081611,0x7485,0x58a8,0x88,0xbe,0x82,0xe7,0x12,0xd8,0xc1,0xba] as IID_TypedEventHandler_2_Windows_Graphics_Printing3D_Print3DTask_System_Object }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing3d::Print3DTask, super::graphics::printing3d::Print3DTaskCompletedEventArgs> => [0xbccf7095,0xbc8e,0x5ff5,0x83,0xc0,0xd5,0x69,0x1e,0x0a,0xa2,0x4d] as IID_TypedEventHandler_2_Windows_Graphics_Printing3D_Print3DTask_Windows_Graphics_Printing3D_Print3DTaskCompletedEventArgs }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for TypedEventHandler<super::graphics::printing3d::Print3DTask, super::graphics::printing3d::Print3DTaskSourceChangedEventArgs> => [0x58d36055,0x0241,0x555d,0xaf,0x7b,0x9f,0x05,0xe5,0xda,0xa4,0x12] as IID_TypedEventHandler_2_Windows_Graphics_Printing3D_Print3DTask_Windows_Graphics_Printing3D_Print3DTaskSourceChangedEventArgs }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for TypedEventHandler<super::management::policies::NamedPolicyData, IInspectable> => [0x791a3c00,0x5aa2,0x5f0e,0xbb,0x17,0x34,0x80,0xbc,0x2d,0x96,0xcc] as IID_TypedEventHandler_2_Windows_Management_Policies_NamedPolicyData_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::appbroadcasting::AppBroadcastingMonitor, IInspectable> => [0xdc64118b,0x04f9,0x5161,0xa7,0xc0,0xe6,0xa9,0x60,0x70,0xa8,0xd1] as IID_TypedEventHandler_2_Windows_Media_AppBroadcasting_AppBroadcastingMonitor_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::audio::AudioFileInputNode, IInspectable> => [0x4481085b,0x8b8b,0x5520,0x98,0x25,0xe9,0x67,0x1d,0xa2,0xa8,0x9f] as IID_TypedEventHandler_2_Windows_Media_Audio_AudioFileInputNode_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::audio::AudioFrameInputNode, super::media::audio::AudioFrameCompletedEventArgs> => [0xad59dcfe,0x71b0,0x5e16,0x99,0xc2,0xcd,0x90,0x64,0x4d,0x8e,0xe8] as IID_TypedEventHandler_2_Windows_Media_Audio_AudioFrameInputNode_Windows_Media_Audio_AudioFrameCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::audio::AudioFrameInputNode, super::media::audio::FrameInputNodeQuantumStartedEventArgs> => [0x4530d121,0xbb9a,0x57fe,0x92,0x2f,0xa9,0x8e,0xee,0xdf,0x59,0xaf] as IID_TypedEventHandler_2_Windows_Media_Audio_AudioFrameInputNode_Windows_Media_Audio_FrameInputNodeQuantumStartedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::audio::AudioGraph, IInspectable> => [0xe1407134,0x09e7,0x53de,0xb5,0x4c,0x8a,0x06,0x59,0x39,0x7b,0x88] as IID_TypedEventHandler_2_Windows_Media_Audio_AudioGraph_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::audio::AudioGraph, super::media::audio::AudioGraphUnrecoverableErrorOccurredEventArgs> => [0x899670c9,0xdd7f,0x5f12,0x98,0xcb,0x8b,0x17,0xfe,0x80,0xa4,0x7f] as IID_TypedEventHandler_2_Windows_Media_Audio_AudioGraph_Windows_Media_Audio_AudioGraphUnrecoverableErrorOccurredEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AdvancedPhotoCapture, IInspectable> => [0x5cb4a98f,0xabf1,0x5518,0x90,0x94,0x26,0xdb,0x32,0x6a,0x5f,0x4e] as IID_TypedEventHandler_2_Windows_Media_Capture_AdvancedPhotoCapture_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AdvancedPhotoCapture, super::media::capture::OptionalReferencePhotoCapturedEventArgs> => [0x843e69ba,0x5702,0x5d97,0xab,0x81,0xef,0x07,0x8d,0xe3,0xf9,0xb1] as IID_TypedEventHandler_2_Windows_Media_Capture_AdvancedPhotoCapture_Windows_Media_Capture_OptionalReferencePhotoCapturedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastBackgroundService, IInspectable> => [0x6e820f00,0xe1e0,0x5c73,0xaf,0xd8,0xa4,0x7b,0x9b,0x1c,0x1b,0xed] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastBackgroundService_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastBackgroundService, super::media::capture::AppBroadcastHeartbeatRequestedEventArgs> => [0x633c91ca,0x4fde,0x5160,0x92,0x09,0x3f,0xd3,0xa4,0x03,0xa9,0x17] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastBackgroundService_Windows_Media_Capture_AppBroadcastHeartbeatRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastBackgroundServiceSignInInfo, IInspectable> => [0xf8715188,0xefc7,0x575c,0xad,0x9d,0x69,0x5e,0xb2,0x04,0x45,0x24] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastBackgroundServiceSignInInfo_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastBackgroundServiceSignInInfo, super::media::capture::AppBroadcastSignInStateChangedEventArgs> => [0xe2672c1a,0xa3d9,0x56f3,0x8a,0x77,0x20,0xd3,0x08,0x73,0xce,0x87] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastBackgroundServiceSignInInfo_Windows_Media_Capture_AppBroadcastSignInStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastBackgroundServiceStreamInfo, IInspectable> => [0x73c8ec4b,0xf104,0x5536,0xb8,0xb4,0x4d,0x9a,0xad,0x61,0xc9,0xb4] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastBackgroundServiceStreamInfo_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastBackgroundServiceStreamInfo, super::media::capture::AppBroadcastStreamStateChangedEventArgs> => [0x0c110cb8,0xb08a,0x5c07,0xb2,0x95,0x22,0x90,0x49,0xa4,0x6c,0x22] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastBackgroundServiceStreamInfo_Windows_Media_Capture_AppBroadcastStreamStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastPreview, super::media::capture::AppBroadcastPreviewStateChangedEventArgs> => [0x41d8b8e1,0xdce7,0x5ebc,0x94,0x0f,0xde,0x7d,0xd2,0xa6,0x2a,0xb5] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastPreview_Windows_Media_Capture_AppBroadcastPreviewStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastPreviewStreamReader, IInspectable> => [0x7918f32c,0x187f,0x5f0f,0xb8,0x0e,0x6f,0xca,0xaa,0x5e,0x14,0xb9] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastPreviewStreamReader_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastState, IInspectable> => [0xa9b0513c,0xd638,0x5c5f,0x80,0x51,0x79,0x1d,0x7a,0xa2,0xd5,0x66] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastState_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastState, super::media::capture::AppBroadcastCameraCaptureStateChangedEventArgs> => [0xb59aa695,0xb324,0x5b43,0x81,0x5b,0x8f,0xfd,0xa6,0x01,0x38,0x16] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastState_Windows_Media_Capture_AppBroadcastCameraCaptureStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastState, super::media::capture::AppBroadcastMicrophoneCaptureStateChangedEventArgs> => [0xf64d996a,0x3859,0x5174,0x97,0xb1,0xe3,0x3d,0x56,0xdf,0xca,0x3a] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastState_Windows_Media_Capture_AppBroadcastMicrophoneCaptureStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastState, super::media::capture::AppBroadcastPlugInStateChangedEventArgs> => [0x373d850e,0x045b,0x52a5,0x92,0xda,0xc2,0x2f,0x92,0x4b,0x79,0xfb] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastState_Windows_Media_Capture_AppBroadcastPlugInStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastState, super::media::capture::AppBroadcastStreamStateChangedEventArgs> => [0x2545fbd2,0x3fb6,0x5004,0xa4,0x75,0x56,0xc0,0x59,0xf3,0xd7,0x5a] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastState_Windows_Media_Capture_AppBroadcastStreamStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastState, super::media::capture::AppBroadcastViewerCountChangedEventArgs> => [0x16a22a27,0x61c2,0x56c2,0x93,0xe5,0x18,0xd6,0x68,0x1c,0xee,0xb4] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastState_Windows_Media_Capture_AppBroadcastViewerCountChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppBroadcastStreamReader, IInspectable> => [0x66d1378b,0x0e04,0x5801,0x8b,0xdd,0xfe,0xb1,0x08,0x1b,0xbe,0xcb] as IID_TypedEventHandler_2_Windows_Media_Capture_AppBroadcastStreamReader_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCapture, IInspectable> => [0xf5cb24b5,0xff00,0x58df,0xb4,0x60,0x17,0xbb,0xf2,0xcd,0x64,0xd3] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCapture_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCaptureMetadataWriter, IInspectable> => [0x1aaed84c,0xed87,0x5f38,0xa9,0xd1,0x35,0x53,0x12,0x8d,0x4a,0x62] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCaptureMetadataWriter_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCaptureRecordOperation, super::media::capture::AppCaptureDurationGeneratedEventArgs> => [0xab6419b5,0x9917,0x5275,0x98,0x76,0x9e,0x46,0xb9,0xab,0xad,0xa7] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCaptureRecordOperation_Windows_Media_Capture_AppCaptureDurationGeneratedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCaptureRecordOperation, super::media::capture::AppCaptureFileGeneratedEventArgs> => [0xf00f69e5,0x9ee6,0x5119,0x9c,0x39,0xf2,0x79,0xf9,0xff,0xd9,0x08] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCaptureRecordOperation_Windows_Media_Capture_AppCaptureFileGeneratedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCaptureRecordOperation, super::media::capture::AppCaptureRecordingStateChangedEventArgs> => [0x227cbf02,0x2dfb,0x5425,0x85,0xb1,0x0d,0x62,0xce,0x5d,0x12,0x43] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCaptureRecordOperation_Windows_Media_Capture_AppCaptureRecordingStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCaptureState, IInspectable> => [0xb74ae481,0x777b,0x5bc9,0x83,0xda,0x56,0x2d,0x90,0x5a,0x43,0xf1] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCaptureState_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::AppCaptureState, super::media::capture::AppCaptureMicrophoneCaptureStateChangedEventArgs> => [0x0b28a1a3,0x372e,0x50e9,0xa6,0x13,0x37,0xb9,0x7c,0xfd,0x7a,0x68] as IID_TypedEventHandler_2_Windows_Media_Capture_AppCaptureState_Windows_Media_Capture_AppCaptureMicrophoneCaptureStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::core::VariablePhotoSequenceCapture, IInspectable> => [0x2210a640,0x0e7b,0x5e8f,0xa6,0x17,0x2c,0xbb,0x10,0x31,0x4a,0x5a] as IID_TypedEventHandler_2_Windows_Media_Capture_Core_VariablePhotoSequenceCapture_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::core::VariablePhotoSequenceCapture, super::media::capture::core::VariablePhotoCapturedEventArgs> => [0xbab30230,0x3dcd,0x58e2,0xaa,0xc5,0xa4,0x5f,0x3e,0x6f,0x80,0x97] as IID_TypedEventHandler_2_Windows_Media_Capture_Core_VariablePhotoSequenceCapture_Windows_Media_Capture_Core_VariablePhotoCapturedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::frames::MediaFrameReader, super::media::capture::frames::MediaFrameArrivedEventArgs> => [0xd3dd49cb,0x8d25,0x591a,0x80,0xf7,0x83,0x63,0xd5,0xc0,0x3e,0xc9] as IID_TypedEventHandler_2_Windows_Media_Capture_Frames_MediaFrameReader_Windows_Media_Capture_Frames_MediaFrameArrivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::frames::MediaFrameSource, IInspectable> => [0xc7e61aa7,0x4716,0x5514,0xa9,0x13,0xef,0x17,0x96,0xb9,0x8d,0xbd] as IID_TypedEventHandler_2_Windows_Media_Capture_Frames_MediaFrameSource_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::frames::MultiSourceMediaFrameReader, super::media::capture::frames::MultiSourceMediaFrameArrivedEventArgs> => [0x82b1ad4d,0x9887,0x56f4,0x9a,0x9e,0x3a,0xb1,0x8b,0x02,0x19,0x8c] as IID_TypedEventHandler_2_Windows_Media_Capture_Frames_MultiSourceMediaFrameReader_Windows_Media_Capture_Frames_MultiSourceMediaFrameArrivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::GameBarServices, super::media::capture::GameBarServicesCommandEventArgs> => [0x0dab4f7e,0xbfec,0x59e1,0x82,0xcf,0xeb,0xf6,0x4b,0x1d,0xb4,0xf3] as IID_TypedEventHandler_2_Windows_Media_Capture_GameBarServices_Windows_Media_Capture_GameBarServicesCommandEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::GameBarServicesManager, super::media::capture::GameBarServicesManagerGameBarServicesCreatedEventArgs> => [0x2f85b809,0x7d8b,0x5be4,0x9a,0x69,0x81,0x38,0x6d,0x87,0x4c,0x7f] as IID_TypedEventHandler_2_Windows_Media_Capture_GameBarServicesManager_Windows_Media_Capture_GameBarServicesManagerGameBarServicesCreatedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::LowLagPhotoSequenceCapture, super::media::capture::PhotoCapturedEventArgs> => [0xb98aab3a,0xfe80,0x5b27,0x88,0xc3,0xe7,0x7f,0xf5,0x85,0xa9,0x6b] as IID_TypedEventHandler_2_Windows_Media_Capture_LowLagPhotoSequenceCapture_Windows_Media_Capture_PhotoCapturedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::MediaCapture, IInspectable> => [0x44c588f1,0x1bb7,0x5e12,0x84,0x13,0x3c,0xf0,0x37,0x3c,0x0b,0xc8] as IID_TypedEventHandler_2_Windows_Media_Capture_MediaCapture_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::MediaCapture, super::media::capture::MediaCaptureDeviceExclusiveControlStatusChangedEventArgs> => [0x5c91f8ba,0xb379,0x53ff,0xa2,0x88,0x24,0xe7,0x88,0x3b,0xf5,0x92] as IID_TypedEventHandler_2_Windows_Media_Capture_MediaCapture_Windows_Media_Capture_MediaCaptureDeviceExclusiveControlStatusChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::MediaCapture, super::media::capture::MediaCaptureFocusChangedEventArgs> => [0x0561d9e8,0x0290,0x5332,0xb1,0x5e,0xb0,0xd5,0x1a,0xbe,0x73,0x7c] as IID_TypedEventHandler_2_Windows_Media_Capture_MediaCapture_Windows_Media_Capture_MediaCaptureFocusChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::capture::MediaCapture, super::media::capture::PhotoConfirmationCapturedEventArgs> => [0x37dc3b13,0xb096,0x5f43,0x81,0x04,0xf0,0xdc,0x43,0x02,0xe2,0xb5] as IID_TypedEventHandler_2_Windows_Media_Capture_MediaCapture_Windows_Media_Capture_PhotoConfirmationCapturedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::casting::CastingConnection, IInspectable> => [0xf1576170,0x9b08,0x5a9b,0x87,0xd2,0xc1,0xac,0x47,0xbc,0x66,0x81] as IID_TypedEventHandler_2_Windows_Media_Casting_CastingConnection_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::casting::CastingConnection, super::media::casting::CastingConnectionErrorOccurredEventArgs> => [0x78afbbd0,0x9811,0x5f0e,0x95,0x66,0x47,0xc3,0xe8,0xcd,0xd9,0x29] as IID_TypedEventHandler_2_Windows_Media_Casting_CastingConnection_Windows_Media_Casting_CastingConnectionErrorOccurredEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::casting::CastingDevicePicker, IInspectable> => [0xa64b972b,0xaa63,0x5c61,0x9c,0xde,0xcd,0x6f,0xfe,0xa8,0xa2,0x47] as IID_TypedEventHandler_2_Windows_Media_Casting_CastingDevicePicker_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::casting::CastingDevicePicker, super::media::casting::CastingDeviceSelectedEventArgs> => [0xb3655b33,0xc4ad,0x5f4c,0xa1,0x87,0xb2,0xe4,0xc7,0x70,0xa1,0x6b] as IID_TypedEventHandler_2_Windows_Media_Casting_CastingDevicePicker_Windows_Media_Casting_CastingDeviceSelectedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::AudioTrack, super::media::core::AudioTrackOpenFailedEventArgs> => [0xb5b7e554,0x2476,0x5667,0x9c,0x9a,0x1c,0x7a,0x7d,0x09,0xac,0xe2] as IID_TypedEventHandler_2_Windows_Media_Core_AudioTrack_Windows_Media_Core_AudioTrackOpenFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::FaceDetectionEffect, super::media::core::FaceDetectedEventArgs> => [0x01f0d7a6,0xf9bd,0x5bc1,0xaa,0xa9,0xdf,0xf3,0x96,0xf7,0x2f,0x87] as IID_TypedEventHandler_2_Windows_Media_Core_FaceDetectionEffect_Windows_Media_Core_FaceDetectedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::ISingleSelectMediaTrackList, IInspectable> => [0x21eb6e39,0x728a,0x56a9,0x8d,0xce,0x06,0x2b,0xa4,0xc8,0x1b,0xf5] as IID_TypedEventHandler_2_Windows_Media_Core_ISingleSelectMediaTrackList_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaBinder, super::media::core::MediaBindingEventArgs> => [0x5b133719,0xee98,0x59b2,0xb4,0x32,0x1c,0x9a,0x5a,0x56,0xab,0x05] as IID_TypedEventHandler_2_Windows_Media_Core_MediaBinder_Windows_Media_Core_MediaBindingEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaBindingEventArgs, IInspectable> => [0x3f3b10e2,0xb2e9,0x55c6,0xab,0xb3,0x4a,0x25,0x80,0x72,0xeb,0xb9] as IID_TypedEventHandler_2_Windows_Media_Core_MediaBindingEventArgs_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaSource, super::media::core::MediaSourceOpenOperationCompletedEventArgs> => [0x425d53e3,0xfba6,0x5ea3,0xb7,0x13,0xdb,0x4d,0x70,0x78,0x74,0x36] as IID_TypedEventHandler_2_Windows_Media_Core_MediaSource_Windows_Media_Core_MediaSourceOpenOperationCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaSource, super::media::core::MediaSourceStateChangedEventArgs> => [0x2274d3a6,0x1ba0,0x5230,0xbb,0x86,0xde,0x90,0x05,0x8b,0x64,0x03] as IID_TypedEventHandler_2_Windows_Media_Core_MediaSource_Windows_Media_Core_MediaSourceStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaSourceAppServiceConnection, super::media::core::InitializeMediaStreamSourceRequestedEventArgs> => [0xf6f1b895,0x9c61,0x5e2a,0x88,0x83,0x9f,0xf8,0xcc,0x8b,0x3d,0x76] as IID_TypedEventHandler_2_Windows_Media_Core_MediaSourceAppServiceConnection_Windows_Media_Core_InitializeMediaStreamSourceRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSample, IInspectable> => [0xd4dc5ef1,0xc1cb,0x5c32,0x80,0x3d,0xf2,0xf9,0xa7,0xad,0x99,0x16] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSample_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSource, IInspectable> => [0x6fd6ded7,0x421b,0x5ef5,0x8b,0xf5,0xed,0xea,0x45,0x40,0x16,0x65] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSource_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSource, super::media::core::MediaStreamSourceClosedEventArgs> => [0x238cc251,0xd0b8,0x5a34,0x81,0xd4,0x0d,0xd1,0xf9,0x36,0xa2,0x0d] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSource_Windows_Media_Core_MediaStreamSourceClosedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSource, super::media::core::MediaStreamSourceSampleRenderedEventArgs> => [0x9d812c70,0x9f0d,0x5ad5,0x82,0x74,0xf7,0x60,0xc9,0xca,0x0c,0x38] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSource_Windows_Media_Core_MediaStreamSourceSampleRenderedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSource, super::media::core::MediaStreamSourceSampleRequestedEventArgs> => [0x4f1a3ae3,0xb8b7,0x5689,0x90,0x1d,0xb0,0xb6,0x23,0xf5,0xa1,0x72] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSource_Windows_Media_Core_MediaStreamSourceSampleRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSource, super::media::core::MediaStreamSourceStartingEventArgs> => [0xa93d5846,0xc660,0x586e,0xb6,0xb5,0xa5,0x2f,0xb8,0x1f,0x92,0x40] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSource_Windows_Media_Core_MediaStreamSourceStartingEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MediaStreamSource, super::media::core::MediaStreamSourceSwitchStreamsRequestedEventArgs> => [0x452b2e4a,0x5511,0x5b3c,0x8a,0x8e,0xee,0x65,0x95,0x76,0xa4,0xc1] as IID_TypedEventHandler_2_Windows_Media_Core_MediaStreamSource_Windows_Media_Core_MediaStreamSourceSwitchStreamsRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MseSourceBuffer, IInspectable> => [0x187fd3d7,0xbb9d,0x541a,0x94,0xfd,0x43,0xc3,0x1d,0xd8,0x4a,0x67] as IID_TypedEventHandler_2_Windows_Media_Core_MseSourceBuffer_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MseSourceBufferList, IInspectable> => [0x0ff01695,0xfbb2,0x5e95,0x8e,0xc7,0xda,0x17,0xd8,0xe9,0x9f,0x16] as IID_TypedEventHandler_2_Windows_Media_Core_MseSourceBufferList_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::MseStreamSource, IInspectable> => [0x724bf4ef,0xde7a,0x5dbd,0x81,0x5e,0x52,0x2a,0x87,0xbc,0x33,0x44] as IID_TypedEventHandler_2_Windows_Media_Core_MseStreamSource_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::SceneAnalysisEffect, super::media::core::SceneAnalyzedEventArgs> => [0x48630f8c,0xdbde,0x569e,0xa0,0xc8,0x75,0x88,0xd1,0xd2,0xbd,0x03] as IID_TypedEventHandler_2_Windows_Media_Core_SceneAnalysisEffect_Windows_Media_Core_SceneAnalyzedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::TimedMetadataTrack, super::media::core::MediaCueEventArgs> => [0x4aac9411,0xc355,0x5c95,0x8c,0x78,0x5a,0x0f,0x5c,0xa1,0xa5,0x4d] as IID_TypedEventHandler_2_Windows_Media_Core_TimedMetadataTrack_Windows_Media_Core_MediaCueEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::TimedMetadataTrack, super::media::core::TimedMetadataTrackFailedEventArgs> => [0x8dc73162,0x255b,0x532e,0xb0,0xc7,0x9a,0x6d,0x70,0xb4,0xbb,0x9e] as IID_TypedEventHandler_2_Windows_Media_Core_TimedMetadataTrack_Windows_Media_Core_TimedMetadataTrackFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::TimedTextSource, super::media::core::TimedTextSourceResolveResultEventArgs> => [0x0220562a,0x5de4,0x5ad2,0xac,0x20,0x6c,0xd2,0x6f,0x11,0x17,0x45] as IID_TypedEventHandler_2_Windows_Media_Core_TimedTextSource_Windows_Media_Core_TimedTextSourceResolveResultEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::VideoStabilizationEffect, super::media::core::VideoStabilizationEffectEnabledChangedEventArgs> => [0x897592e2,0xbfcc,0x5f16,0x88,0x34,0x2c,0x9c,0x4f,0x20,0x55,0x9b] as IID_TypedEventHandler_2_Windows_Media_Core_VideoStabilizationEffect_Windows_Media_Core_VideoStabilizationEffectEnabledChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::core::VideoTrack, super::media::core::VideoTrackOpenFailedEventArgs> => [0xb1e4bd43,0x541b,0x53f3,0xad,0x6c,0xdd,0xaa,0xc4,0x81,0x30,0x23] as IID_TypedEventHandler_2_Windows_Media_Core_VideoTrack_Windows_Media_Core_VideoTrackOpenFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::devices::AudioDeviceModulesManager, super::media::devices::AudioDeviceModuleNotificationEventArgs> => [0xb2f6b1fd,0x7092,0x5724,0xb2,0xce,0x91,0xb1,0x17,0x6e,0x80,0xe1] as IID_TypedEventHandler_2_Windows_Media_Devices_AudioDeviceModulesManager_Windows_Media_Devices_AudioDeviceModuleNotificationEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::dialprotocol::DialDevicePicker, IInspectable> => [0xdac94028,0x1b44,0x5f45,0xb9,0xe3,0xab,0xcf,0x4a,0xb0,0x44,0xbf] as IID_TypedEventHandler_2_Windows_Media_DialProtocol_DialDevicePicker_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::dialprotocol::DialDevicePicker, super::media::dialprotocol::DialDeviceSelectedEventArgs> => [0x8375c0d7,0xe7c3,0x56bc,0x98,0x80,0x46,0xb6,0x9c,0xa1,0x0d,0x45] as IID_TypedEventHandler_2_Windows_Media_DialProtocol_DialDevicePicker_Windows_Media_DialProtocol_DialDeviceSelectedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::dialprotocol::DialDevicePicker, super::media::dialprotocol::DialDisconnectButtonClickedEventArgs> => [0x13492af0,0x1c7f,0x57e8,0xb5,0x7e,0xa5,0xae,0x8f,0x2c,0x46,0x2e] as IID_TypedEventHandler_2_Windows_Media_DialProtocol_DialDevicePicker_Windows_Media_DialProtocol_DialDisconnectButtonClickedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::effects::AudioCaptureEffectsManager, IInspectable> => [0xa1c5e803,0xa275,0x5bb1,0x9d,0x44,0x2a,0xc8,0xae,0x9f,0xfb,0x89] as IID_TypedEventHandler_2_Windows_Media_Effects_AudioCaptureEffectsManager_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::effects::AudioRenderEffectsManager, IInspectable> => [0x4be29c7e,0x449c,0x576e,0xa7,0xb8,0x3a,0x40,0xf2,0xf0,0x1d,0xc8] as IID_TypedEventHandler_2_Windows_Media_Effects_AudioRenderEffectsManager_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::import::PhotoImportFindItemsResult, super::media::import::PhotoImportItemImportedEventArgs> => [0xa3cce94d,0xf26e,0x58d9,0x81,0x38,0x59,0x9a,0xd6,0x3c,0x70,0x69] as IID_TypedEventHandler_2_Windows_Media_Import_PhotoImportFindItemsResult_Windows_Media_Import_PhotoImportItemImportedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::import::PhotoImportFindItemsResult, super::media::import::PhotoImportSelectionChangedEventArgs> => [0xe67279fe,0x692f,0x5602,0x82,0x0b,0x86,0x50,0x98,0xd9,0xb4,0x3e] as IID_TypedEventHandler_2_Windows_Media_Import_PhotoImportFindItemsResult_Windows_Media_Import_PhotoImportSelectionChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::MediaTimelineController, IInspectable> => [0x5c43e195,0x7d39,0x5d0d,0xa3,0x09,0x19,0x91,0xe6,0x8a,0xcd,0xb7] as IID_TypedEventHandler_2_Windows_Media_MediaTimelineController_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::MediaTimelineController, super::media::MediaTimelineControllerFailedEventArgs> => [0x07cd62fb,0x578d,0x56a6,0xa8,0xef,0xe6,0x53,0xeb,0x00,0x5d,0x1b] as IID_TypedEventHandler_2_Windows_Media_MediaTimelineController_Windows_Media_MediaTimelineControllerFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaBreakManager, super::media::playback::MediaBreakEndedEventArgs> => [0x04afafa9,0xd83a,0x5ccb,0x8c,0xab,0x82,0xc9,0xd9,0x2a,0x19,0xab] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaBreakManager_Windows_Media_Playback_MediaBreakEndedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaBreakManager, super::media::playback::MediaBreakSeekedOverEventArgs> => [0xa6954c30,0x99dc,0x5f84,0xb4,0x82,0x7d,0x06,0x92,0xc0,0x27,0x7b] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaBreakManager_Windows_Media_Playback_MediaBreakSeekedOverEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaBreakManager, super::media::playback::MediaBreakSkippedEventArgs> => [0xc530fa5d,0x1a56,0x582a,0xa2,0x54,0x1b,0x1a,0xe1,0x7b,0x8d,0x2d] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaBreakManager_Windows_Media_Playback_MediaBreakSkippedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaBreakManager, super::media::playback::MediaBreakStartedEventArgs> => [0x4bf2cca1,0xcd9d,0x5d88,0x9e,0x47,0x18,0x81,0x20,0x1b,0xb7,0x2d] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaBreakManager_Windows_Media_Playback_MediaBreakStartedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaBreakSchedule, IInspectable> => [0x3c57acbf,0xca07,0x586a,0x8a,0xdb,0x80,0x47,0xdc,0x91,0x65,0xa6] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaBreakSchedule_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs> => [0x824845b8,0xc5df,0x560b,0xa7,0x22,0xc1,0x5b,0x25,0xd4,0x46,0x3a] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerFastForwardReceivedEventArgs> => [0xd7cd6ce3,0x516f,0x5b34,0xbe,0xaf,0x3e,0xe9,0x0b,0x62,0x28,0x72] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerFastForwardReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerNextReceivedEventArgs> => [0xce41af40,0x93a6,0x52bf,0x9c,0xad,0x4d,0x5f,0xff,0xd1,0x0e,0xe0] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerNextReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerPauseReceivedEventArgs> => [0x79eb2ad3,0x0781,0x5f64,0xb0,0xcd,0x31,0xe1,0x14,0x5d,0x10,0x9f] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerPauseReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerPlayReceivedEventArgs> => [0x76d59f7c,0xedf3,0x5dde,0x95,0x29,0x6f,0x80,0x6b,0xdb,0x1f,0xcb] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerPlayReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerPositionReceivedEventArgs> => [0xd863b1c4,0x7442,0x53c4,0x94,0xd2,0x20,0xd8,0x97,0x3d,0xf5,0x85] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerPositionReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerPreviousReceivedEventArgs> => [0x25726db4,0x8913,0x5967,0x90,0xeb,0x10,0xf0,0x9f,0x30,0xdd,0x33] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerPreviousReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerRateReceivedEventArgs> => [0x3f8a8ea1,0xff9a,0x5613,0x98,0x46,0x33,0x79,0x9f,0x6b,0x8c,0x8a] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerRateReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerRewindReceivedEventArgs> => [0x3c37e026,0x8d0b,0x5d73,0xa6,0x50,0x9f,0x18,0xab,0xbc,0x35,0x3d] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerRewindReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManager, super::media::playback::MediaPlaybackCommandManagerShuffleReceivedEventArgs> => [0x6c972f91,0xf626,0x5799,0xba,0x86,0x5e,0x94,0x1f,0x02,0x02,0xc8] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManager_Windows_Media_Playback_MediaPlaybackCommandManagerShuffleReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackCommandManagerCommandBehavior, IInspectable> => [0x2675973a,0xeb2d,0x56a1,0x82,0xa0,0x34,0x0b,0x0f,0xf0,0x41,0xe6] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackCommandManagerCommandBehavior_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackItem, collections::IVectorChangedEventArgs> => [0x2dd51918,0x4525,0x5be5,0xa6,0xc1,0x40,0x9b,0xc7,0x28,0x63,0xa6] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackItem_Windows_Foundation_Collections_IVectorChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackList, super::media::playback::CurrentMediaPlaybackItemChangedEventArgs> => [0x404c5f9d,0x250d,0x5f8c,0x96,0x27,0x6b,0x41,0x05,0xc3,0x2d,0x09] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackList_Windows_Media_Playback_CurrentMediaPlaybackItemChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackList, super::media::playback::MediaPlaybackItemFailedEventArgs> => [0x23319e7d,0x34b1,0x57b7,0x97,0xe5,0x84,0x49,0x48,0xba,0x47,0x19] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackList_Windows_Media_Playback_MediaPlaybackItemFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackList, super::media::playback::MediaPlaybackItemOpenedEventArgs> => [0x6732bbef,0x3311,0x5f83,0x9c,0x9d,0x82,0xa5,0xcf,0x3c,0xd8,0x2a] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackList_Windows_Media_Playback_MediaPlaybackItemOpenedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackSession, IInspectable> => [0x7c70f38d,0x2aa1,0x5522,0xa6,0xd6,0x34,0xb5,0x2b,0x98,0x8a,0xe7] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackSession_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlaybackTimedMetadataTrackList, super::media::playback::TimedMetadataPresentationModeChangedEventArgs> => [0x40213c85,0xbf23,0x5f78,0xb9,0xc4,0xe0,0x3f,0x3b,0xe2,0xb4,0x1c] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlaybackTimedMetadataTrackList_Windows_Media_Playback_TimedMetadataPresentationModeChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlayer, IInspectable> => [0xf1a6a51e,0xd078,0x5c40,0xba,0x3f,0x34,0x88,0x70,0xba,0x5c,0x87] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlayer_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlayer, super::media::playback::MediaPlayerFailedEventArgs> => [0x362c45a7,0x3a0a,0x5e27,0x99,0xce,0xcf,0xf6,0xd1,0xb7,0x70,0xe1] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlayer_Windows_Media_Playback_MediaPlayerFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlayer, super::media::playback::MediaPlayerRateChangedEventArgs> => [0xba51d31a,0x5688,0x5d4d,0xaf,0x42,0x12,0x20,0x70,0xb1,0xee,0xfa] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlayer_Windows_Media_Playback_MediaPlayerRateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playback::MediaPlayer, super::media::playback::PlaybackMediaMarkerReachedEventArgs> => [0x67a4f43c,0xc254,0x57f0,0xa3,0x9d,0xa4,0x75,0xa3,0x42,0xd2,0x1d] as IID_TypedEventHandler_2_Windows_Media_Playback_MediaPlayer_Windows_Media_Playback_PlaybackMediaMarkerReachedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToConnection, super::media::playto::PlayToConnectionErrorEventArgs> => [0x8f599f3d,0x3655,0x5993,0xa1,0x19,0x74,0x1e,0xc4,0xee,0x6e,0x42] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToConnection_Windows_Media_PlayTo_PlayToConnectionErrorEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToConnection, super::media::playto::PlayToConnectionStateChangedEventArgs> => [0xdef77c1c,0x9363,0x5b47,0xb9,0xf8,0xa2,0x36,0xc5,0x0d,0x37,0x2e] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToConnection_Windows_Media_PlayTo_PlayToConnectionStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToConnection, super::media::playto::PlayToConnectionTransferredEventArgs> => [0x7278e7f2,0x0360,0x5571,0x8c,0x3e,0xea,0x03,0x27,0x67,0xc4,0x73] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToConnection_Windows_Media_PlayTo_PlayToConnectionTransferredEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToManager, super::media::playto::PlayToSourceRequestedEventArgs> => [0x6ac9f3a4,0x39b6,0x51d8,0x8e,0x08,0xf1,0x37,0x90,0x8e,0x92,0x2f] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToManager_Windows_Media_PlayTo_PlayToSourceRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToManager, super::media::playto::PlayToSourceSelectedEventArgs> => [0xbf87431a,0x7451,0x52a5,0xa5,0xe2,0xbf,0xaf,0x40,0x8e,0x0c,0x88] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToManager_Windows_Media_PlayTo_PlayToSourceSelectedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToReceiver, IInspectable> => [0x7a89b9c2,0x78d4,0x5866,0x88,0xf1,0x4c,0xdc,0x0a,0x0e,0x75,0xb8] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToReceiver_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToReceiver, super::media::playto::CurrentTimeChangeRequestedEventArgs> => [0x42abdf9f,0x14a6,0x5c1f,0x83,0x9b,0x86,0x02,0x95,0x05,0xb1,0xd0] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToReceiver_Windows_Media_PlayTo_CurrentTimeChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToReceiver, super::media::playto::MuteChangeRequestedEventArgs> => [0x0674cf85,0xb6fd,0x5926,0x9b,0x72,0x35,0xfe,0x51,0x7a,0x3f,0x44] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToReceiver_Windows_Media_PlayTo_MuteChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToReceiver, super::media::playto::PlaybackRateChangeRequestedEventArgs> => [0xe7594396,0x58c3,0x5316,0xbc,0x4f,0x1d,0x13,0xea,0xdb,0xef,0xfd] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToReceiver_Windows_Media_PlayTo_PlaybackRateChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToReceiver, super::media::playto::SourceChangeRequestedEventArgs> => [0x1466d074,0xb7b4,0x5814,0xb2,0xd7,0x84,0x7c,0x5a,0xe7,0xd8,0x7d] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToReceiver_Windows_Media_PlayTo_SourceChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::playto::PlayToReceiver, super::media::playto::VolumeChangeRequestedEventArgs> => [0x9c3f7c84,0x9b4d,0x5cdc,0x81,0x44,0x1c,0x2f,0x61,0x7b,0x6e,0xde] as IID_TypedEventHandler_2_Windows_Media_PlayTo_PlayToReceiver_Windows_Media_PlayTo_VolumeChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::protection::HdcpSession, IInspectable> => [0xf82ae043,0x54fb,0x5366,0xa6,0x07,0x19,0xb6,0x8e,0x6b,0xab,0x8c] as IID_TypedEventHandler_2_Windows_Media_Protection_HdcpSession_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::protection::playready::NDClient, IInspectable> => [0xd20f3387,0xb3f5,0x5010,0x9b,0x0b,0xe8,0x51,0xae,0x84,0x94,0x0d] as IID_TypedEventHandler_2_Windows_Media_Protection_PlayReady_NDClient_System_Object }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::protection::playready::NDClient, super::media::protection::playready::INDClosedCaptionDataReceivedEventArgs> => [0x36ec9e44,0x25f6,0x5d3d,0x87,0xee,0x8a,0xd1,0x0a,0x33,0x5c,0x83] as IID_TypedEventHandler_2_Windows_Media_Protection_PlayReady_NDClient_Windows_Media_Protection_PlayReady_INDClosedCaptionDataReceivedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::protection::playready::NDClient, super::media::protection::playready::INDLicenseFetchCompletedEventArgs> => [0xa5401278,0xe2c1,0x5354,0x85,0x8f,0x6f,0x32,0xcb,0xdf,0xbe,0xa7] as IID_TypedEventHandler_2_Windows_Media_Protection_PlayReady_NDClient_Windows_Media_Protection_PlayReady_INDLicenseFetchCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::protection::playready::NDClient, super::media::protection::playready::INDProximityDetectionCompletedEventArgs> => [0xb545268a,0xc7ce,0x51f8,0xbd,0xdc,0x02,0x9d,0x2c,0x66,0xb6,0x6b] as IID_TypedEventHandler_2_Windows_Media_Protection_PlayReady_NDClient_Windows_Media_Protection_PlayReady_INDProximityDetectionCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::protection::playready::NDClient, super::media::protection::playready::INDRegistrationCompletedEventArgs> => [0x46b3f056,0xc1a0,0x51c0,0x85,0x21,0xcd,0xe2,0x22,0x15,0x7e,0xff] as IID_TypedEventHandler_2_Windows_Media_Protection_PlayReady_NDClient_Windows_Media_Protection_PlayReady_INDRegistrationCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::speechrecognition::SpeechContinuousRecognitionSession, super::media::speechrecognition::SpeechContinuousRecognitionCompletedEventArgs> => [0x8103c018,0x7952,0x59f9,0x9f,0x41,0x23,0xb1,0x7d,0x6e,0x45,0x2d] as IID_TypedEventHandler_2_Windows_Media_SpeechRecognition_SpeechContinuousRecognitionSession_Windows_Media_SpeechRecognition_SpeechContinuousRecognitionCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::speechrecognition::SpeechContinuousRecognitionSession, super::media::speechrecognition::SpeechContinuousRecognitionResultGeneratedEventArgs> => [0x26192073,0xa2c9,0x527d,0x9b,0xd3,0x91,0x1c,0x05,0xe0,0x01,0x1e] as IID_TypedEventHandler_2_Windows_Media_SpeechRecognition_SpeechContinuousRecognitionSession_Windows_Media_SpeechRecognition_SpeechContinuousRecognitionResultGeneratedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::speechrecognition::SpeechRecognizer, super::media::speechrecognition::SpeechRecognitionHypothesisGeneratedEventArgs> => [0x4cb45aba,0x7573,0x545a,0xb2,0x9a,0xe9,0xbe,0x35,0xbd,0x46,0x82] as IID_TypedEventHandler_2_Windows_Media_SpeechRecognition_SpeechRecognizer_Windows_Media_SpeechRecognition_SpeechRecognitionHypothesisGeneratedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::speechrecognition::SpeechRecognizer, super::media::speechrecognition::SpeechRecognitionQualityDegradingEventArgs> => [0x15ca7918,0x61d2,0x57b2,0xb9,0x33,0x44,0x06,0x3e,0x8b,0xb6,0x62] as IID_TypedEventHandler_2_Windows_Media_SpeechRecognition_SpeechRecognizer_Windows_Media_SpeechRecognition_SpeechRecognitionQualityDegradingEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::speechrecognition::SpeechRecognizer, super::media::speechrecognition::SpeechRecognizerStateChangedEventArgs> => [0xd1185e92,0x5c30,0x5561,0xb3,0xe2,0xe8,0x2d,0xdb,0xd8,0x72,0xc3] as IID_TypedEventHandler_2_Windows_Media_SpeechRecognition_SpeechRecognizer_Windows_Media_SpeechRecognition_SpeechRecognizerStateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::streaming::adaptive::AdaptiveMediaSource, super::media::streaming::adaptive::AdaptiveMediaSourceDownloadBitrateChangedEventArgs> => [0xad268caf,0x7da0,0x5ad4,0x85,0x85,0xce,0xeb,0x90,0x3d,0xbd,0x50] as IID_TypedEventHandler_2_Windows_Media_Streaming_Adaptive_AdaptiveMediaSource_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceDownloadBitrateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::streaming::adaptive::AdaptiveMediaSource, super::media::streaming::adaptive::AdaptiveMediaSourceDownloadCompletedEventArgs> => [0xcef775dd,0x25b2,0x5588,0x8d,0x51,0xda,0xcd,0xea,0x66,0x0a,0x7d] as IID_TypedEventHandler_2_Windows_Media_Streaming_Adaptive_AdaptiveMediaSource_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceDownloadCompletedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::streaming::adaptive::AdaptiveMediaSource, super::media::streaming::adaptive::AdaptiveMediaSourceDownloadFailedEventArgs> => [0x6ee5cc44,0x49ad,0x5138,0xab,0x47,0xf5,0xc0,0x75,0xa2,0xbc,0x34] as IID_TypedEventHandler_2_Windows_Media_Streaming_Adaptive_AdaptiveMediaSource_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceDownloadFailedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::streaming::adaptive::AdaptiveMediaSource, super::media::streaming::adaptive::AdaptiveMediaSourceDownloadRequestedEventArgs> => [0xd3b7dbf1,0xfd8e,0x589e,0x9c,0x7f,0xba,0x67,0x39,0x7e,0x50,0xcd] as IID_TypedEventHandler_2_Windows_Media_Streaming_Adaptive_AdaptiveMediaSource_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceDownloadRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::streaming::adaptive::AdaptiveMediaSource, super::media::streaming::adaptive::AdaptiveMediaSourcePlaybackBitrateChangedEventArgs> => [0xdf4f4e89,0x6173,0x539b,0x94,0xd8,0x69,0xb7,0xcb,0x75,0x78,0xa7] as IID_TypedEventHandler_2_Windows_Media_Streaming_Adaptive_AdaptiveMediaSource_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourcePlaybackBitrateChangedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::streaming::adaptive::AdaptiveMediaSourceDiagnostics, super::media::streaming::adaptive::AdaptiveMediaSourceDiagnosticAvailableEventArgs> => [0xfd4ce6b5,0x7c3b,0x58f4,0x9e,0xfc,0x1d,0x9e,0xe6,0xa0,0x9d,0x21] as IID_TypedEventHandler_2_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceDiagnostics_Windows_Media_Streaming_Adaptive_AdaptiveMediaSourceDiagnosticAvailableEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::SystemMediaTransportControls, super::media::AutoRepeatModeChangeRequestedEventArgs> => [0xa6214bde,0x02d5,0x55b3,0xab,0x0d,0xc6,0x03,0x1b,0xe7,0x0d,0xa1] as IID_TypedEventHandler_2_Windows_Media_SystemMediaTransportControls_Windows_Media_AutoRepeatModeChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::SystemMediaTransportControls, super::media::PlaybackPositionChangeRequestedEventArgs> => [0x44e34f15,0xbdc0,0x50a7,0xac,0xe4,0x39,0xe9,0x1f,0xb7,0x53,0xf1] as IID_TypedEventHandler_2_Windows_Media_SystemMediaTransportControls_Windows_Media_PlaybackPositionChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::SystemMediaTransportControls, super::media::PlaybackRateChangeRequestedEventArgs> => [0x15eb0182,0x6366,0x5b9f,0xbd,0x8c,0x8a,0xb4,0xfa,0x9d,0x7c,0xd9] as IID_TypedEventHandler_2_Windows_Media_SystemMediaTransportControls_Windows_Media_PlaybackRateChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::SystemMediaTransportControls, super::media::ShuffleEnabledChangeRequestedEventArgs> => [0x17ecea80,0x27e4,0x5dae,0xab,0xb4,0xc8,0x58,0xad,0x1c,0x53,0x07] as IID_TypedEventHandler_2_Windows_Media_SystemMediaTransportControls_Windows_Media_ShuffleEnabledChangeRequestedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::SystemMediaTransportControls, super::media::SystemMediaTransportControlsButtonPressedEventArgs> => [0x0557e996,0x7b23,0x5bae,0xaa,0x81,0xea,0x0d,0x67,0x11,0x43,0xa4] as IID_TypedEventHandler_2_Windows_Media_SystemMediaTransportControls_Windows_Media_SystemMediaTransportControlsButtonPressedEventArgs }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for TypedEventHandler<super::media::SystemMediaTransportControls, super::media::SystemMediaTransportControlsPropertyChangedEventArgs> => [0x9fd61dad,0x1746,0x5fa1,0xa9,0x08,0xef,0x7c,0xb4,0x60,0x3c,0x85] as IID_TypedEventHandler_2_Windows_Media_SystemMediaTransportControls_Windows_Media_SystemMediaTransportControlsPropertyChangedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::backgroundtransfer::DownloadOperation, super::networking::backgroundtransfer::BackgroundTransferRangesDownloadedEventArgs> => [0x93a20d85,0xbdfc,0x5195,0x90,0xd9,0x8c,0xb5,0x6c,0xbc,0xb3,0xd8] as IID_TypedEventHandler_2_Windows_Networking_BackgroundTransfer_DownloadOperation_Windows_Networking_BackgroundTransfer_BackgroundTransferRangesDownloadedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::networkoperators::MobileBroadbandAccountWatcher, IInspectable> => [0xe4dc9cfc,0xf462,0x5afd,0x85,0x6d,0x04,0xac,0xe2,0x29,0xd0,0x0e] as IID_TypedEventHandler_2_Windows_Networking_NetworkOperators_MobileBroadbandAccountWatcher_System_Object }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::networkoperators::MobileBroadbandAccountWatcher, super::networking::networkoperators::MobileBroadbandAccountEventArgs> => [0x423cc41e,0xfe8c,0x5a7d,0x9f,0xee,0xaa,0xe0,0x4e,0xf8,0x57,0x00] as IID_TypedEventHandler_2_Windows_Networking_NetworkOperators_MobileBroadbandAccountWatcher_Windows_Networking_NetworkOperators_MobileBroadbandAccountEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::networkoperators::MobileBroadbandAccountWatcher, super::networking::networkoperators::MobileBroadbandAccountUpdatedEventArgs> => [0x0e865096,0x1ffa,0x5792,0x8d,0x4f,0x86,0x23,0xe3,0xc7,0x7f,0x56] as IID_TypedEventHandler_2_Windows_Networking_NetworkOperators_MobileBroadbandAccountWatcher_Windows_Networking_NetworkOperators_MobileBroadbandAccountUpdatedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::networkoperators::MobileBroadbandDeviceServiceDataSession, super::networking::networkoperators::MobileBroadbandDeviceServiceDataReceivedEventArgs> => [0x31f89ca6,0xdd7f,0x5325,0x90,0x20,0x62,0x7d,0x8b,0x47,0xea,0x02] as IID_TypedEventHandler_2_Windows_Networking_NetworkOperators_MobileBroadbandDeviceServiceDataSession_Windows_Networking_NetworkOperators_MobileBroadbandDeviceServiceDataReceivedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::networkoperators::MobileBroadbandSarManager, super::networking::networkoperators::MobileBroadbandTransmissionStateChangedEventArgs> => [0x540c4534,0xcd85,0x5abe,0x80,0x13,0x13,0xcb,0x14,0x0e,0xd1,0x8b] as IID_TypedEventHandler_2_Windows_Networking_NetworkOperators_MobileBroadbandSarManager_Windows_Networking_NetworkOperators_MobileBroadbandTransmissionStateChangedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::proximity::PeerWatcher, IInspectable> => [0xf4979ea1,0x7e06,0x50a8,0x88,0xdc,0x3f,0x29,0x52,0x4e,0x4f,0xdb] as IID_TypedEventHandler_2_Windows_Networking_Proximity_PeerWatcher_System_Object }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::proximity::PeerWatcher, super::networking::proximity::PeerInformation> => [0xad674bbf,0x6281,0x5943,0x97,0x72,0xe0,0xfd,0x76,0x64,0xd4,0xe1] as IID_TypedEventHandler_2_Windows_Networking_Proximity_PeerWatcher_Windows_Networking_Proximity_PeerInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::pushnotifications::PushNotificationChannel, super::networking::pushnotifications::PushNotificationReceivedEventArgs> => [0x55fa217d,0x1fc3,0x5863,0xb9,0x80,0x70,0x94,0xd4,0x37,0x96,0x94] as IID_TypedEventHandler_2_Windows_Networking_PushNotifications_PushNotificationChannel_Windows_Networking_PushNotifications_PushNotificationReceivedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::servicediscovery::dnssd::DnssdServiceWatcher, IInspectable> => [0x6a6cc5d5,0x9f43,0x545a,0x91,0xd7,0x3a,0x40,0x05,0x54,0x75,0xda] as IID_TypedEventHandler_2_Windows_Networking_ServiceDiscovery_Dnssd_DnssdServiceWatcher_System_Object }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::servicediscovery::dnssd::DnssdServiceWatcher, super::networking::servicediscovery::dnssd::DnssdServiceInstance> => [0xe617711e,0xcdd5,0x5975,0x8f,0xb3,0x8e,0xaa,0xae,0xd2,0x4e,0x7b] as IID_TypedEventHandler_2_Windows_Networking_ServiceDiscovery_Dnssd_DnssdServiceWatcher_Windows_Networking_ServiceDiscovery_Dnssd_DnssdServiceInstance }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::sockets::DatagramSocket, super::networking::sockets::DatagramSocketMessageReceivedEventArgs> => [0x4482e19b,0x2389,0x5767,0x9b,0x0b,0x8d,0x7a,0x8e,0xf5,0x57,0x43] as IID_TypedEventHandler_2_Windows_Networking_Sockets_DatagramSocket_Windows_Networking_Sockets_DatagramSocketMessageReceivedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::sockets::IWebSocket, super::networking::sockets::WebSocketClosedEventArgs> => [0x03cf8f90,0x1669,0x5f4d,0x94,0x04,0x2b,0x78,0x46,0x78,0xe6,0xdd] as IID_TypedEventHandler_2_Windows_Networking_Sockets_IWebSocket_Windows_Networking_Sockets_WebSocketClosedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::sockets::MessageWebSocket, super::networking::sockets::MessageWebSocketMessageReceivedEventArgs> => [0xde980538,0x6dcd,0x52b0,0x80,0x2f,0x4b,0x6c,0xf5,0x9a,0x01,0xab] as IID_TypedEventHandler_2_Windows_Networking_Sockets_MessageWebSocket_Windows_Networking_Sockets_MessageWebSocketMessageReceivedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::sockets::MessageWebSocket, super::networking::sockets::WebSocketServerCustomValidationRequestedEventArgs> => [0x2c34c585,0x9cf6,0x56c7,0x8d,0xd1,0x5d,0xa2,0x6e,0x32,0x20,0x78] as IID_TypedEventHandler_2_Windows_Networking_Sockets_MessageWebSocket_Windows_Networking_Sockets_WebSocketServerCustomValidationRequestedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::sockets::StreamSocketListener, super::networking::sockets::StreamSocketListenerConnectionReceivedEventArgs> => [0x33d00d41,0xc94f,0x5a61,0x9a,0xb7,0x28,0x0d,0xce,0xfa,0x0b,0x08] as IID_TypedEventHandler_2_Windows_Networking_Sockets_StreamSocketListener_Windows_Networking_Sockets_StreamSocketListenerConnectionReceivedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::sockets::StreamWebSocket, super::networking::sockets::WebSocketServerCustomValidationRequestedEventArgs> => [0x18b143d3,0x897e,0x595e,0xac,0xc1,0xef,0x35,0x61,0x4b,0x4c,0xec] as IID_TypedEventHandler_2_Windows_Networking_Sockets_StreamWebSocket_Windows_Networking_Sockets_WebSocketServerCustomValidationRequestedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::vpn::VpnChannel, super::networking::vpn::VpnChannelActivityEventArgs> => [0x39907949,0xa8cc,0x5ce5,0x9e,0x0a,0x06,0xe3,0xb2,0xd3,0x15,0x70] as IID_TypedEventHandler_2_Windows_Networking_Vpn_VpnChannel_Windows_Networking_Vpn_VpnChannelActivityEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::vpn::VpnChannel, super::networking::vpn::VpnChannelActivityStateChangedArgs> => [0x2cfcf1ba,0xbffc,0x5746,0xb8,0x68,0x2e,0x45,0xa4,0x6d,0x29,0x58] as IID_TypedEventHandler_2_Windows_Networking_Vpn_VpnChannel_Windows_Networking_Vpn_VpnChannelActivityStateChangedArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::xboxlive::XboxLiveDeviceAddress, IInspectable> => [0x7fa76199,0xd1b8,0x5494,0xa0,0x42,0x70,0x02,0xa4,0x16,0xad,0xc3] as IID_TypedEventHandler_2_Windows_Networking_XboxLive_XboxLiveDeviceAddress_System_Object }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::xboxlive::XboxLiveEndpointPair, super::networking::xboxlive::XboxLiveEndpointPairStateChangedEventArgs> => [0x51037260,0x4609,0x58c1,0xad,0xb3,0x06,0x18,0xb8,0x9b,0x99,0x75] as IID_TypedEventHandler_2_Windows_Networking_XboxLive_XboxLiveEndpointPair_Windows_Networking_XboxLive_XboxLiveEndpointPairStateChangedEventArgs }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for TypedEventHandler<super::networking::xboxlive::XboxLiveEndpointPairTemplate, super::networking::xboxlive::XboxLiveInboundEndpointPairCreatedEventArgs> => [0x2aef5136,0x6e7a,0x51f8,0x88,0x53,0xcc,0x0c,0xe4,0x66,0xfe,0xf9] as IID_TypedEventHandler_2_Windows_Networking_XboxLive_XboxLiveEndpointPairTemplate_Windows_Networking_XboxLive_XboxLiveInboundEndpointPairCreatedEventArgs }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialAnchor, super::perception::spatial::SpatialAnchorRawCoordinateSystemAdjustedEventArgs> => [0xfa43f9e4,0x3558,0x59c8,0x9a,0x77,0x6e,0x8b,0x76,0x5a,0xdc,0xc8] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialAnchor_Windows_Perception_Spatial_SpatialAnchorRawCoordinateSystemAdjustedEventArgs }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialEntityWatcher, IInspectable> => [0x50171823,0x30a9,0x5938,0x9f,0x3b,0x35,0x8d,0x86,0x16,0x9f,0x2e] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialEntityWatcher_System_Object }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialEntityWatcher, super::perception::spatial::SpatialEntityAddedEventArgs> => [0xf8edae01,0x6a30,0x52cc,0xb5,0x43,0x8a,0xbd,0xb2,0x65,0x29,0xb4] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialEntityWatcher_Windows_Perception_Spatial_SpatialEntityAddedEventArgs }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialEntityWatcher, super::perception::spatial::SpatialEntityRemovedEventArgs> => [0x36f982ad,0xeaa2,0x5263,0x86,0x1e,0x2a,0xcf,0x03,0x0c,0x9e,0x17] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialEntityWatcher_Windows_Perception_Spatial_SpatialEntityRemovedEventArgs }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialEntityWatcher, super::perception::spatial::SpatialEntityUpdatedEventArgs> => [0xa15fd0c0,0x8a0a,0x5a7d,0x89,0x7a,0xf2,0x06,0xcc,0x50,0x91,0x90] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialEntityWatcher_Windows_Perception_Spatial_SpatialEntityUpdatedEventArgs }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialLocator, IInspectable> => [0xdbb08ab5,0x6b40,0x55fb,0x83,0xd3,0x50,0xd5,0x37,0x3a,0x3b,0x20] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialLocator_System_Object }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::SpatialLocator, super::perception::spatial::SpatialLocatorPositionalTrackingDeactivatingEventArgs> => [0x34bf236c,0xe5d6,0x501f,0x86,0x93,0xbc,0x1d,0x8d,0x43,0x1d,0x7e] as IID_TypedEventHandler_2_Windows_Perception_Spatial_SpatialLocator_Windows_Perception_Spatial_SpatialLocatorPositionalTrackingDeactivatingEventArgs }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for TypedEventHandler<super::perception::spatial::surfaces::SpatialSurfaceObserver, IInspectable> => [0x8b31274a,0x7693,0x52be,0x90,0x14,0xb0,0xf5,0xf6,0x5a,0x35,0x39] as IID_TypedEventHandler_2_Windows_Perception_Spatial_Surfaces_SpatialSurfaceObserver_System_Object }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for TypedEventHandler<super::security::authentication::web::core::WebAccountMonitor, IInspectable> => [0xc8cb498d,0xe0da,0x52a1,0xab,0xf9,0x71,0x98,0xc7,0xf5,0xcb,0x42] as IID_TypedEventHandler_2_Windows_Security_Authentication_Web_Core_WebAccountMonitor_System_Object }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for TypedEventHandler<super::security::authentication::web::core::WebAccountMonitor, super::security::authentication::web::core::WebAccountEventArgs> => [0xfa704f04,0x87b6,0x516b,0x95,0x96,0xcd,0x7c,0xc0,0x92,0x16,0x9b] as IID_TypedEventHandler_2_Windows_Security_Authentication_Web_Core_WebAccountMonitor_Windows_Security_Authentication_Web_Core_WebAccountEventArgs }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::maps::guidance::GuidanceNavigator, IInspectable> => [0x3f496c35,0x3dca,0x5e91,0x87,0x30,0x6e,0xf7,0x7e,0x9d,0x70,0xbd] as IID_TypedEventHandler_2_Windows_Services_Maps_Guidance_GuidanceNavigator_System_Object }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::maps::guidance::GuidanceNavigator, super::services::maps::guidance::GuidanceAudioNotificationRequestedEventArgs> => [0x743db36f,0xe9aa,0x557a,0x9f,0xd7,0x30,0x4c,0x9b,0x04,0x99,0xdf] as IID_TypedEventHandler_2_Windows_Services_Maps_Guidance_GuidanceNavigator_Windows_Services_Maps_Guidance_GuidanceAudioNotificationRequestedEventArgs }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::maps::guidance::GuidanceNavigator, super::services::maps::guidance::GuidanceReroutedEventArgs> => [0x61b92b1b,0xf22f,0x581b,0xbf,0xa0,0x48,0x68,0xc3,0x14,0xc6,0x3a] as IID_TypedEventHandler_2_Windows_Services_Maps_Guidance_GuidanceNavigator_Windows_Services_Maps_Guidance_GuidanceReroutedEventArgs }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::maps::guidance::GuidanceNavigator, super::services::maps::guidance::GuidanceUpdatedEventArgs> => [0x82b3f7df,0xbf13,0x5445,0xaa,0xdc,0xec,0x61,0xb5,0x0f,0xbb,0x46] as IID_TypedEventHandler_2_Windows_Services_Maps_Guidance_GuidanceNavigator_Windows_Services_Maps_Guidance_GuidanceUpdatedEventArgs }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::maps::offlinemaps::OfflineMapPackage, IInspectable> => [0x2d2e0d20,0x826f,0x560c,0xb1,0xc1,0xb4,0xbd,0x6f,0xbf,0x32,0x9a] as IID_TypedEventHandler_2_Windows_Services_Maps_OfflineMaps_OfflineMapPackage_System_Object }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::store::StoreContext, IInspectable> => [0xd5a00ac7,0x082d,0x547c,0xa0,0x4b,0x25,0x40,0xc1,0xcd,0xe9,0x7a] as IID_TypedEventHandler_2_Windows_Services_Store_StoreContext_System_Object }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::store::StorePackageLicense, IInspectable> => [0x6c59d637,0x2970,0x5f64,0x95,0x11,0xd3,0x9a,0xc2,0x45,0xbc,0x94] as IID_TypedEventHandler_2_Windows_Services_Store_StorePackageLicense_System_Object }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::targetedcontent::TargetedContentSubscription, super::services::targetedcontent::TargetedContentAvailabilityChangedEventArgs> => [0x99929904,0x138a,0x59ac,0xa1,0x1a,0xfe,0x00,0x42,0xf0,0xfd,0x50] as IID_TypedEventHandler_2_Windows_Services_TargetedContent_TargetedContentSubscription_Windows_Services_TargetedContent_TargetedContentAvailabilityChangedEventArgs }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::targetedcontent::TargetedContentSubscription, super::services::targetedcontent::TargetedContentChangedEventArgs> => [0xef11d751,0x9d56,0x580d,0x8a,0x9f,0x51,0xae,0x7e,0x80,0x36,0xe3] as IID_TypedEventHandler_2_Windows_Services_TargetedContent_TargetedContentSubscription_Windows_Services_TargetedContent_TargetedContentChangedEventArgs }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for TypedEventHandler<super::services::targetedcontent::TargetedContentSubscription, super::services::targetedcontent::TargetedContentStateChangedEventArgs> => [0xc4d5acbe,0xf65b,0x5fa4,0x92,0x42,0xd2,0x86,0x0d,0xe8,0x5d,0x52] as IID_TypedEventHandler_2_Windows_Services_TargetedContent_TargetedContentSubscription_Windows_Services_TargetedContent_TargetedContentStateChangedEventArgs }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::accesscache::StorageItemMostRecentlyUsedList, super::storage::accesscache::ItemRemovedEventArgs> => [0x029dace8,0x98d1,0x5bf7,0xb7,0x80,0x97,0x17,0xe9,0x50,0x27,0xff] as IID_TypedEventHandler_2_Windows_Storage_AccessCache_StorageItemMostRecentlyUsedList_Windows_Storage_AccessCache_ItemRemovedEventArgs }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::ApplicationData, IInspectable> => [0xb5348b3b,0x5081,0x5ae9,0x8f,0xa3,0x4d,0x22,0xd6,0x8f,0xb0,0xea] as IID_TypedEventHandler_2_Windows_Storage_ApplicationData_System_Object }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::bulkaccess::IStorageItemInformation, IInspectable> => [0x5b98b352,0xe0cf,0x58de,0xb2,0xec,0x4f,0xd7,0x86,0xbb,0xb5,0xa7] as IID_TypedEventHandler_2_Windows_Storage_BulkAccess_IStorageItemInformation_System_Object }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::pickers::provider::FileOpenPickerUI, super::storage::pickers::provider::FileRemovedEventArgs> => [0xf1fb2939,0x695b,0x5f56,0x84,0x1a,0xa5,0x2a,0x7d,0x14,0x85,0x72] as IID_TypedEventHandler_2_Windows_Storage_Pickers_Provider_FileOpenPickerUI_Windows_Storage_Pickers_Provider_FileRemovedEventArgs }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::pickers::provider::FileOpenPickerUI, super::storage::pickers::provider::PickerClosingEventArgs> => [0x2b06bdac,0x983b,0x5552,0xb5,0xc9,0xb0,0x99,0x0a,0x2d,0xb3,0xa1] as IID_TypedEventHandler_2_Windows_Storage_Pickers_Provider_FileOpenPickerUI_Windows_Storage_Pickers_Provider_PickerClosingEventArgs }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::pickers::provider::FileSavePickerUI, IInspectable> => [0xf1e6a632,0xf97f,0x54d9,0x9e,0x1b,0xa7,0x14,0xed,0xc3,0xff,0x06] as IID_TypedEventHandler_2_Windows_Storage_Pickers_Provider_FileSavePickerUI_System_Object }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::pickers::provider::FileSavePickerUI, super::storage::pickers::provider::TargetFileRequestedEventArgs> => [0xd3e1f8c7,0x45c5,0x5249,0xb3,0x36,0xa1,0x11,0xbf,0xaa,0x98,0x5b] as IID_TypedEventHandler_2_Windows_Storage_Pickers_Provider_FileSavePickerUI_Windows_Storage_Pickers_Provider_TargetFileRequestedEventArgs }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::provider::CachedFileUpdaterUI, IInspectable> => [0x45fdd443,0xc0b9,0x57b0,0xa8,0x4f,0x7d,0x87,0x6e,0xdc,0x31,0x49] as IID_TypedEventHandler_2_Windows_Storage_Provider_CachedFileUpdaterUI_System_Object }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::provider::CachedFileUpdaterUI, super::storage::provider::FileUpdateRequestedEventArgs> => [0xed56ab72,0xebd3,0x52c8,0xb0,0xac,0x98,0x7d,0x30,0x09,0x03,0x51] as IID_TypedEventHandler_2_Windows_Storage_Provider_CachedFileUpdaterUI_Windows_Storage_Provider_FileUpdateRequestedEventArgs }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::search::IStorageQueryResultBase, IInspectable> => [0x4ba22861,0x00c4,0x597f,0xb6,0xbf,0x3a,0xf5,0x16,0xf3,0xb8,0x70] as IID_TypedEventHandler_2_Windows_Storage_Search_IStorageQueryResultBase_System_Object }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for TypedEventHandler<super::storage::StorageLibrary, IInspectable> => [0xedc09538,0xbbae,0x5b2b,0x9e,0x81,0xb4,0x49,0xea,0x7e,0x48,0xfe] as IID_TypedEventHandler_2_Windows_Storage_StorageLibrary_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::AppDiagnosticInfoWatcher, IInspectable> => [0x895dee2f,0xe0f2,0x5304,0xa4,0x0e,0x1c,0x67,0xa2,0xc0,0x58,0xaa] as IID_TypedEventHandler_2_Windows_System_AppDiagnosticInfoWatcher_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::AppDiagnosticInfoWatcher, super::system::AppDiagnosticInfoWatcherEventArgs> => [0x7c8c6f9f,0xd6bf,0x5566,0xb0,0x13,0x39,0xc1,0x41,0xe0,0xff,0x8c] as IID_TypedEventHandler_2_Windows_System_AppDiagnosticInfoWatcher_Windows_System_AppDiagnosticInfoWatcherEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::AppResourceGroupInfoWatcher, IInspectable> => [0xe23a2901,0x197a,0x5867,0x87,0x28,0x9c,0x9d,0xb9,0x49,0x8d,0x76] as IID_TypedEventHandler_2_Windows_System_AppResourceGroupInfoWatcher_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::AppResourceGroupInfoWatcher, super::system::AppResourceGroupInfoWatcherEventArgs> => [0xa7e14bae,0xc778,0x5661,0xa4,0x1c,0x1a,0xc3,0xac,0x63,0x5f,0x79] as IID_TypedEventHandler_2_Windows_System_AppResourceGroupInfoWatcher_Windows_System_AppResourceGroupInfoWatcherEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::AppResourceGroupInfoWatcher, super::system::AppResourceGroupInfoWatcherExecutionStateChangedEventArgs> => [0x93f9724c,0x17f8,0x5df5,0xa6,0xcf,0x2f,0x0a,0xb9,0x0c,0x0a,0x27] as IID_TypedEventHandler_2_Windows_System_AppResourceGroupInfoWatcher_Windows_System_AppResourceGroupInfoWatcherExecutionStateChangedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::diagnostics::deviceportal::DevicePortalConnection, super::system::diagnostics::deviceportal::DevicePortalConnectionClosedEventArgs> => [0x2aad93a8,0x52fa,0x54b3,0x95,0x56,0x15,0xd6,0x51,0x20,0x8b,0x3f] as IID_TypedEventHandler_2_Windows_System_Diagnostics_DevicePortal_DevicePortalConnection_Windows_System_Diagnostics_DevicePortal_DevicePortalConnectionClosedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::diagnostics::deviceportal::DevicePortalConnection, super::system::diagnostics::deviceportal::DevicePortalConnectionRequestReceivedEventArgs> => [0xd8e33ff8,0x8ac4,0x5fd9,0xb1,0x84,0x8a,0xe8,0x7d,0x82,0x8e,0xb9] as IID_TypedEventHandler_2_Windows_System_Diagnostics_DevicePortal_DevicePortalConnection_Windows_System_Diagnostics_DevicePortal_DevicePortalConnectionRequestReceivedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::DispatcherQueue, IInspectable> => [0xfe79f855,0x2f40,0x5b88,0xa0,0xc3,0x4c,0x04,0x2a,0x05,0xdd,0x05] as IID_TypedEventHandler_2_Windows_System_DispatcherQueue_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::DispatcherQueue, super::system::DispatcherQueueShutdownStartingEventArgs> => [0xb58b5e24,0xe1c6,0x528e,0x9d,0x99,0x07,0xec,0x88,0x29,0xde,0xa5] as IID_TypedEventHandler_2_Windows_System_DispatcherQueue_Windows_System_DispatcherQueueShutdownStartingEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::DispatcherQueueTimer, IInspectable> => [0x8b5644c8,0x8b57,0x50ce,0x89,0x33,0x7a,0xb2,0xcc,0x5a,0x14,0xef] as IID_TypedEventHandler_2_Windows_System_DispatcherQueueTimer_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSession, super::system::remotesystems::RemoteSystemSessionDisconnectedEventArgs> => [0xfba14773,0x5038,0x511a,0x95,0xa3,0x4b,0xa4,0x53,0x49,0x10,0x0a] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSession_Windows_System_RemoteSystems_RemoteSystemSessionDisconnectedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionController, super::system::remotesystems::RemoteSystemSessionJoinRequestedEventArgs> => [0xd8e04916,0xb452,0x5322,0xae,0xc9,0xe3,0xd4,0xd5,0x81,0xc7,0x72] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionController_Windows_System_RemoteSystems_RemoteSystemSessionJoinRequestedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionInvitationListener, super::system::remotesystems::RemoteSystemSessionInvitationReceivedEventArgs> => [0x18a242bb,0xd338,0x56c4,0x95,0x59,0x56,0x8d,0x5c,0x2c,0x3e,0x93] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionInvitationListener_Windows_System_RemoteSystems_RemoteSystemSessionInvitationReceivedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionMessageChannel, super::system::remotesystems::RemoteSystemSessionValueSetReceivedEventArgs> => [0xc476232d,0x8c76,0x5ba6,0x99,0xf5,0x14,0x55,0x74,0x84,0xc2,0x0d] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionMessageChannel_Windows_System_RemoteSystems_RemoteSystemSessionValueSetReceivedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionParticipantWatcher, IInspectable> => [0xd4cf5bda,0xcc7a,0x52ef,0xa2,0x56,0xc4,0xb3,0x61,0x63,0xbe,0xec] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionParticipantWatcher_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionParticipantWatcher, super::system::remotesystems::RemoteSystemSessionParticipantAddedEventArgs> => [0x7d42fff3,0xfd21,0x5e15,0xb2,0x1a,0x75,0xe1,0xbb,0xcd,0x13,0xc7] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionParticipantWatcher_Windows_System_RemoteSystems_RemoteSystemSessionParticipantAddedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionParticipantWatcher, super::system::remotesystems::RemoteSystemSessionParticipantRemovedEventArgs> => [0x73d7e8b3,0x7d44,0x50c8,0xaf,0xad,0x45,0x0d,0xe5,0x9f,0xd0,0xae] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionParticipantWatcher_Windows_System_RemoteSystems_RemoteSystemSessionParticipantRemovedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionWatcher, super::system::remotesystems::RemoteSystemSessionAddedEventArgs> => [0x1b036c4f,0x6b8f,0x55d6,0xb6,0xdf,0x45,0xe4,0x6a,0x82,0x3b,0x1d] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionWatcher_Windows_System_RemoteSystems_RemoteSystemSessionAddedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionWatcher, super::system::remotesystems::RemoteSystemSessionRemovedEventArgs> => [0x1cbc54f0,0x0c9d,0x59cc,0x80,0x55,0x5e,0x01,0x7a,0x31,0x78,0x12] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionWatcher_Windows_System_RemoteSystems_RemoteSystemSessionRemovedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemSessionWatcher, super::system::remotesystems::RemoteSystemSessionUpdatedEventArgs> => [0x040f48b7,0x0d41,0x5aa2,0x85,0xe8,0x63,0x11,0x66,0x6f,0x03,0x24] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemSessionWatcher_Windows_System_RemoteSystems_RemoteSystemSessionUpdatedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemWatcher, super::system::remotesystems::RemoteSystemAddedEventArgs> => [0xa9b98f4a,0xb63d,0x5d07,0x92,0xbb,0xe2,0xac,0xb3,0x94,0x55,0xd1] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemWatcher_Windows_System_RemoteSystems_RemoteSystemAddedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemWatcher, super::system::remotesystems::RemoteSystemRemovedEventArgs> => [0xc290fb5a,0x3ed0,0x5858,0xaf,0x19,0xf8,0x55,0x53,0xcb,0x96,0xb8] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemWatcher_Windows_System_RemoteSystems_RemoteSystemRemovedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::remotesystems::RemoteSystemWatcher, super::system::remotesystems::RemoteSystemUpdatedEventArgs> => [0x88f9d23f,0x8946,0x5a1e,0x8d,0xa1,0x82,0xc6,0x69,0x82,0xa6,0xd2] as IID_TypedEventHandler_2_Windows_System_RemoteSystems_RemoteSystemWatcher_Windows_System_RemoteSystems_RemoteSystemUpdatedEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::UserWatcher, IInspectable> => [0xf155e0ff,0xdbb5,0x5c34,0xac,0x0c,0x7e,0x29,0x1e,0x33,0x00,0xab] as IID_TypedEventHandler_2_Windows_System_UserWatcher_System_Object }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::UserWatcher, super::system::UserAuthenticationStatusChangingEventArgs> => [0x9ec3d9d5,0xb413,0x51df,0x8c,0x64,0x64,0x0e,0x33,0x56,0xe3,0x51] as IID_TypedEventHandler_2_Windows_System_UserWatcher_Windows_System_UserAuthenticationStatusChangingEventArgs }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for TypedEventHandler<super::system::UserWatcher, super::system::UserChangedEventArgs> => [0xeb9d0454,0x25db,0x5620,0x98,0xb8,0xbe,0x4c,0x5d,0x0d,0xbc,0x67] as IID_TypedEventHandler_2_Windows_System_UserWatcher_Windows_System_UserChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::applicationsettings::AccountsSettingsPane, super::ui::applicationsettings::AccountsSettingsPaneCommandsRequestedEventArgs> => [0x69b8847e,0x7d72,0x5a15,0xbc,0x1c,0x4c,0xa3,0x9c,0x93,0xb1,0x62] as IID_TypedEventHandler_2_Windows_UI_ApplicationSettings_AccountsSettingsPane_Windows_UI_ApplicationSettings_AccountsSettingsPaneCommandsRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::applicationsettings::SettingsPane, super::ui::applicationsettings::SettingsPaneCommandsRequestedEventArgs> => [0xf39a56a2,0x7db1,0x5c48,0x9e,0x13,0x7d,0xc4,0x85,0xa4,0xa9,0x9e] as IID_TypedEventHandler_2_Windows_UI_ApplicationSettings_SettingsPane_Windows_UI_ApplicationSettings_SettingsPaneCommandsRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::composition::CompositionCapabilities, IInspectable> => [0x6e8cc6f4,0x6cf5,0x5994,0x94,0x47,0x72,0x61,0x71,0x23,0x6e,0xa8] as IID_TypedEventHandler_2_Windows_UI_Composition_CompositionCapabilities_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::composition::CompositionGraphicsDevice, super::ui::composition::RenderingDeviceReplacedEventArgs> => [0x259b32be,0xbd06,0x53c2,0xbd,0x51,0x89,0xe8,0xe0,0xf9,0xe2,0x39] as IID_TypedEventHandler_2_Windows_UI_Composition_CompositionGraphicsDevice_Windows_UI_Composition_RenderingDeviceReplacedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreComponentInputSource, super::ui::core::ClosestInteractiveBoundsRequestedEventArgs> => [0xe2c62d42,0x0577,0x5112,0x9e,0x59,0xea,0xe1,0x59,0xbf,0x39,0xe9] as IID_TypedEventHandler_2_Windows_UI_Core_CoreComponentInputSource_Windows_UI_Core_ClosestInteractiveBoundsRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreDispatcher, super::ui::core::AcceleratorKeyEventArgs> => [0x136dff0d,0xf7e8,0x5153,0xb3,0x1c,0x86,0x39,0x0c,0x70,0x18,0x80] as IID_TypedEventHandler_2_Windows_UI_Core_CoreDispatcher_Windows_UI_Core_AcceleratorKeyEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, IInspectable> => [0x6368ae3d,0x52d4,0x5290,0xb9,0x36,0x71,0x7a,0x9a,0xcf,0x5b,0xea] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::AutomationProviderRequestedEventArgs> => [0x54db5c04,0x81f7,0x5f46,0x9f,0xb8,0xe4,0x9b,0xee,0xc7,0x0a,0x24] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_AutomationProviderRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::CharacterReceivedEventArgs> => [0x73f846a8,0x0af6,0x5872,0x8f,0xb8,0xae,0x2f,0x56,0xd8,0x55,0x3e] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_CharacterReceivedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::ClosestInteractiveBoundsRequestedEventArgs> => [0x21a652d2,0xbfe2,0x5b2e,0xa2,0xab,0xca,0x45,0x25,0x3b,0xe8,0xb0] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_ClosestInteractiveBoundsRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::CoreWindowEventArgs> => [0xd08e4f66,0x3457,0x57f2,0xba,0x0c,0xcb,0x34,0x71,0x33,0xbd,0x15] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_CoreWindowEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::CoreWindowPopupShowingEventArgs> => [0xb32d6422,0x78b2,0x5e00,0x84,0xa8,0x6e,0x31,0x67,0xaa,0xab,0xde] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_CoreWindowPopupShowingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::InputEnabledEventArgs> => [0xe230a64a,0x506a,0x59c3,0xbb,0x61,0x55,0x59,0xff,0x99,0x56,0x63] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_InputEnabledEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::KeyEventArgs> => [0xa3ec0774,0x55ac,0x5d61,0x82,0x32,0xb3,0x5c,0x5d,0x35,0xc9,0x3c] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_KeyEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::PointerEventArgs> => [0x420e1bb6,0xe99d,0x5e64,0x8e,0x25,0x07,0x46,0x7e,0x3c,0xae,0x9e] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_PointerEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::TouchHitTestingEventArgs> => [0x197654c9,0x0c47,0x502b,0x9a,0xa1,0x0d,0xeb,0x03,0xed,0x97,0x02] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_TouchHitTestingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::VisibilityChangedEventArgs> => [0x14b7f692,0x5583,0x52a1,0xaa,0x42,0xfc,0x18,0x43,0xc0,0xf7,0x48] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_VisibilityChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::WindowActivatedEventArgs> => [0x26a73b35,0xa7f9,0x52db,0x88,0xd6,0x15,0x72,0x6d,0xeb,0x25,0x23] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_WindowActivatedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::CoreWindow, super::ui::core::WindowSizeChangedEventArgs> => [0x318dbb67,0x4089,0x5690,0x90,0x40,0x1d,0x45,0x4f,0xb2,0xf6,0x86] as IID_TypedEventHandler_2_Windows_UI_Core_CoreWindow_Windows_UI_Core_WindowSizeChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::core::ICorePointerRedirector, super::ui::core::PointerEventArgs> => [0x29742d27,0x177d,0x54c3,0xb9,0x74,0x61,0x6f,0xc4,0x5a,0x2b,0x0c] as IID_TypedEventHandler_2_Windows_UI_Core_ICorePointerRedirector_Windows_UI_Core_PointerEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::EdgeGesture, super::ui::input::EdgeGestureEventArgs> => [0xb62d7f11,0xc7b1,0x5bf0,0xa3,0x47,0x33,0x66,0x25,0x2d,0xb4,0xce] as IID_TypedEventHandler_2_Windows_UI_Input_EdgeGesture_Windows_UI_Input_EdgeGestureEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::CrossSlidingEventArgs> => [0x1fc1eb70,0x0c26,0x5cf0,0x9e,0x50,0x84,0x3a,0x34,0x08,0x36,0x13] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_CrossSlidingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::DraggingEventArgs> => [0xbe7cca42,0x98dd,0x5d72,0x9e,0x91,0x97,0x61,0x13,0xd7,0x98,0x5e] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_DraggingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::HoldingEventArgs> => [0x0027bdf5,0x6948,0x53f7,0xaf,0xbe,0xd4,0xd8,0xfe,0x50,0x0f,0xeb] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_HoldingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::ManipulationCompletedEventArgs> => [0xc24f5605,0x3059,0x52cc,0xbd,0xf3,0x70,0x98,0x14,0x6d,0x34,0xd7] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_ManipulationCompletedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::ManipulationInertiaStartingEventArgs> => [0x350a72ab,0x34a5,0x5193,0x91,0x3d,0x3d,0x4c,0x59,0x83,0x84,0x2c] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_ManipulationInertiaStartingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::ManipulationStartedEventArgs> => [0x110d75c8,0xba5e,0x5462,0x8b,0x2d,0x4a,0x15,0x82,0x57,0x4b,0x61] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_ManipulationStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::ManipulationUpdatedEventArgs> => [0xeb5216f5,0x020a,0x5e40,0x9c,0x4b,0x48,0x91,0x2c,0x69,0x0e,0x2d] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_ManipulationUpdatedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::RightTappedEventArgs> => [0x8420d242,0xba34,0x5b17,0x92,0xf3,0x8f,0x76,0x7f,0x1d,0x0d,0xe4] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_RightTappedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::GestureRecognizer, super::ui::input::TappedEventArgs> => [0x27f3ad57,0x8994,0x5712,0x8b,0x83,0xa9,0x3b,0xa1,0x7c,0x03,0xc2] as IID_TypedEventHandler_2_Windows_UI_Input_GestureRecognizer_Windows_UI_Input_TappedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::inking::core::CoreInkIndependentInputSource, super::ui::core::PointerEventArgs> => [0xb83fbe98,0x882a,0x5b69,0xbd,0x1c,0xc6,0x66,0x90,0x70,0x7f,0xef] as IID_TypedEventHandler_2_Windows_UI_Input_Inking_Core_CoreInkIndependentInputSource_Windows_UI_Core_PointerEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::inking::core::CoreWetStrokeUpdateSource, super::ui::input::inking::core::CoreWetStrokeUpdateEventArgs> => [0x67ff75e8,0x02a4,0x5254,0xa9,0x65,0x0b,0x25,0x4c,0x7d,0x07,0x88] as IID_TypedEventHandler_2_Windows_UI_Input_Inking_Core_CoreWetStrokeUpdateSource_Windows_UI_Input_Inking_Core_CoreWetStrokeUpdateEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::inking::InkPresenter, super::ui::input::inking::InkStrokesCollectedEventArgs> => [0x176bfa8f,0xc0de,0x5b3a,0xb2,0x8c,0x0f,0x39,0x31,0xca,0x52,0xd3] as IID_TypedEventHandler_2_Windows_UI_Input_Inking_InkPresenter_Windows_UI_Input_Inking_InkStrokesCollectedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::inking::InkPresenter, super::ui::input::inking::InkStrokesErasedEventArgs> => [0x30fec929,0x14d0,0x550f,0x84,0xf2,0x13,0x7f,0xc6,0xa9,0xf0,0x8f] as IID_TypedEventHandler_2_Windows_UI_Input_Inking_InkPresenter_Windows_UI_Input_Inking_InkStrokesErasedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::inking::InkStrokeInput, super::ui::core::PointerEventArgs> => [0xbf66b962,0x702d,0x5c07,0xa2,0xd5,0x15,0xf2,0x15,0x83,0xc4,0x3a] as IID_TypedEventHandler_2_Windows_UI_Input_Inking_InkStrokeInput_Windows_UI_Core_PointerEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::inking::InkUnprocessedInput, super::ui::core::PointerEventArgs> => [0x4a86bd78,0x5bcf,0x5ede,0x8f,0x65,0xa8,0xc6,0x52,0x35,0x05,0x5c] as IID_TypedEventHandler_2_Windows_UI_Input_Inking_InkUnprocessedInput_Windows_UI_Core_PointerEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::KeyboardDeliveryInterceptor, super::ui::core::KeyEventArgs> => [0x2c1caf11,0x9d6f,0x5e0f,0xa9,0xea,0x4c,0x7c,0x73,0x4d,0x73,0xd6] as IID_TypedEventHandler_2_Windows_UI_Input_KeyboardDeliveryInterceptor_Windows_UI_Core_KeyEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, IInspectable> => [0x5e0f93b1,0xc2f2,0x5351,0x82,0xaa,0x6c,0xf5,0xf4,0xc2,0xd0,0x68] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerButtonClickedEventArgs> => [0xd09d9fcc,0xedb8,0x56c0,0x85,0x6d,0x70,0xe4,0x77,0xa9,0xdd,0xf3] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerButtonClickedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerButtonHoldingEventArgs> => [0x4c44f2ff,0x3a4a,0x51ba,0xa0,0x1f,0x9f,0x20,0x02,0x47,0x1f,0x59] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerButtonHoldingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerButtonPressedEventArgs> => [0x660bee4a,0x4fed,0x5a62,0xaa,0x5d,0x81,0x13,0xb4,0x77,0xbc,0x69] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerButtonPressedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerButtonReleasedEventArgs> => [0xc22ff62c,0xc642,0x5d50,0x93,0x40,0xfe,0x16,0x31,0x22,0x72,0x0c] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerButtonReleasedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerControlAcquiredEventArgs> => [0x4ec5f3fd,0xb217,0x5452,0xa2,0xbd,0x97,0x25,0xce,0x9f,0x66,0x75] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerControlAcquiredEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerRotationChangedEventArgs> => [0x8fe73ac9,0x8a36,0x5152,0x81,0x5d,0x03,0x31,0x0e,0xe8,0xbf,0x85] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerRotationChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerScreenContactContinuedEventArgs> => [0x30579e67,0xfb4f,0x5d38,0x83,0xb4,0x9c,0xb6,0x10,0x09,0x0d,0xef] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerScreenContactContinuedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialController, super::ui::input::RadialControllerScreenContactStartedEventArgs> => [0x1f2d584e,0x3ad8,0x5049,0xb4,0x51,0x3a,0x44,0xa1,0x02,0xfa,0x82] as IID_TypedEventHandler_2_Windows_UI_Input_RadialController_Windows_UI_Input_RadialControllerScreenContactStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::RadialControllerMenuItem, IInspectable> => [0x5c90d6fb,0xe4f8,0x5be2,0x85,0x44,0x9d,0xe3,0x3f,0x82,0xc4,0x1a] as IID_TypedEventHandler_2_Windows_UI_Input_RadialControllerMenuItem_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialHoldCanceledEventArgs> => [0x6a715963,0xc49f,0x5f3d,0xbf,0xec,0x95,0x27,0x00,0x30,0x88,0x60] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialHoldCanceledEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialHoldCompletedEventArgs> => [0xe425d80e,0x8c18,0x5375,0xb6,0x00,0x1d,0xd7,0xa1,0x1d,0xba,0x5e] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialHoldCompletedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialHoldStartedEventArgs> => [0x7537dd12,0x02b8,0x5132,0x8f,0xf7,0x90,0xc8,0x0e,0xf4,0x54,0xd1] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialHoldStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialManipulationCanceledEventArgs> => [0xb92a6754,0x3946,0x5353,0xb8,0xf9,0x2a,0x07,0xeb,0x0e,0x88,0x86] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialManipulationCanceledEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialManipulationCompletedEventArgs> => [0x10dac914,0xbea2,0x5d67,0x86,0x07,0xdc,0x47,0x0e,0xa1,0xdc,0xd8] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialManipulationCompletedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialManipulationStartedEventArgs> => [0xa123252b,0xcfe8,0x5cfb,0xb6,0x1c,0xf2,0xdc,0x01,0x1e,0xb1,0x2e] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialManipulationStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialManipulationUpdatedEventArgs> => [0xcecbe023,0x3c49,0x530e,0xa0,0x10,0x8c,0x0c,0x3c,0xbd,0x30,0x88] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialManipulationUpdatedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialNavigationCanceledEventArgs> => [0x9947ea8e,0xeb4d,0x5f93,0x9f,0xd9,0x2a,0xde,0x64,0x70,0xbc,0x5d] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialNavigationCanceledEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialNavigationCompletedEventArgs> => [0xf0d459df,0xebd3,0x5388,0xb0,0xa9,0x5f,0x44,0xbc,0xd6,0xf5,0x8f] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialNavigationCompletedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialNavigationStartedEventArgs> => [0x5419cadc,0x2600,0x527b,0x93,0x98,0x17,0x44,0x31,0x8d,0x06,0x18] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialNavigationStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialNavigationUpdatedEventArgs> => [0xa7216b90,0xc175,0x5a28,0xb5,0x00,0xa4,0x45,0xf0,0x75,0x1c,0x5b] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialNavigationUpdatedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialRecognitionEndedEventArgs> => [0xafa7fad7,0x3fd7,0x5c81,0x88,0x02,0x19,0x5c,0x52,0x3f,0x6e,0x7b] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialRecognitionEndedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialRecognitionStartedEventArgs> => [0xf2bd99d6,0x99fa,0x5599,0xa1,0x4a,0x1f,0x7a,0x7a,0x92,0xe3,0xd7] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialRecognitionStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialGestureRecognizer, super::ui::input::spatial::SpatialTappedEventArgs> => [0x630205a4,0x2f93,0x5022,0xb7,0xb8,0xc4,0x3e,0xd4,0x28,0x49,0x8a] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialGestureRecognizer_Windows_UI_Input_Spatial_SpatialTappedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialInteractionManager, super::ui::input::spatial::SpatialInteractionDetectedEventArgs> => [0x0f223f8f,0xf220,0x5388,0x8f,0xe6,0xb3,0xb7,0xe7,0x93,0x09,0x87] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialInteractionManager_Windows_UI_Input_Spatial_SpatialInteractionDetectedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::input::spatial::SpatialInteractionManager, super::ui::input::spatial::SpatialInteractionSourceEventArgs> => [0xae831d66,0x70f0,0x5371,0x86,0x6f,0xa3,0xfc,0x8b,0x60,0xe2,0xd8] as IID_TypedEventHandler_2_Windows_UI_Input_Spatial_SpatialInteractionManager_Windows_UI_Input_Spatial_SpatialInteractionSourceEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::notifications::management::UserNotificationListener, super::ui::notifications::UserNotificationChangedEventArgs> => [0x10242902,0xb897,0x5507,0x99,0x22,0x2c,0x0a,0x7d,0x34,0x46,0x4d] as IID_TypedEventHandler_2_Windows_UI_Notifications_Management_UserNotificationListener_Windows_UI_Notifications_UserNotificationChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::notifications::ToastNotification, IInspectable> => [0xab54de2d,0x97d9,0x5528,0xb6,0xad,0x10,0x5a,0xfe,0x15,0x65,0x30] as IID_TypedEventHandler_2_Windows_UI_Notifications_ToastNotification_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::notifications::ToastNotification, super::ui::notifications::ToastDismissedEventArgs> => [0x61c2402f,0x0ed0,0x5a18,0xab,0x69,0x59,0xf4,0xaa,0x99,0xa3,0x68] as IID_TypedEventHandler_2_Windows_UI_Notifications_ToastNotification_Windows_UI_Notifications_ToastDismissedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::notifications::ToastNotification, super::ui::notifications::ToastFailedEventArgs> => [0x95e3e803,0xc969,0x5e3a,0x97,0x53,0xea,0x2a,0xd2,0x2a,0x9a,0x33] as IID_TypedEventHandler_2_Windows_UI_Notifications_ToastNotification_Windows_UI_Notifications_ToastFailedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::startscreen::SecondaryTile, super::ui::startscreen::VisualElementsRequestedEventArgs> => [0x02d9f968,0xfa76,0x5d77,0x93,0x4b,0x66,0x5e,0x7c,0x3b,0xe7,0xcf] as IID_TypedEventHandler_2_Windows_UI_StartScreen_SecondaryTile_Windows_UI_StartScreen_VisualElementsRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, IInspectable> => [0xef53b467,0xc472,0x5b59,0xa8,0x27,0x38,0xad,0xc3,0xa9,0xd3,0x26] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextCompositionCompletedEventArgs> => [0xa2d7059e,0x68ed,0x5260,0x8d,0x8e,0x1d,0xcf,0x3d,0x25,0xd6,0x63] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextCompositionCompletedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextCompositionStartedEventArgs> => [0xe671d625,0x5b59,0x57e6,0xa9,0x2e,0x40,0x00,0x95,0x07,0x85,0x3a] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextCompositionStartedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextFormatUpdatingEventArgs> => [0x3e4ef599,0x4cc2,0x5248,0xbf,0x2d,0x13,0xf1,0x76,0x13,0xb0,0xa6] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextFormatUpdatingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextLayoutRequestedEventArgs> => [0x1a5f5596,0x561c,0x57f6,0xa4,0xff,0xcb,0x85,0x01,0x3c,0x65,0x44] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextLayoutRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextSelectionRequestedEventArgs> => [0x882e51e1,0xf4a3,0x57e5,0x93,0x92,0x6a,0x8c,0x38,0x57,0x91,0x81] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextSelectionRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextSelectionUpdatingEventArgs> => [0x6b140a40,0xd461,0x555a,0xb6,0xeb,0x5d,0xbb,0x8e,0x21,0x01,0xe5] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextSelectionUpdatingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextTextRequestedEventArgs> => [0xc7e08176,0x4134,0x50b7,0xbc,0x73,0x72,0x9e,0x9f,0x9a,0xd2,0x2a] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextTextRequestedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextEditContext, super::ui::text::core::CoreTextTextUpdatingEventArgs> => [0xfd896a84,0xdf7c,0x50d5,0x91,0x67,0x58,0xf6,0x16,0xbd,0xdb,0x6e] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextEditContext_Windows_UI_Text_Core_CoreTextTextUpdatingEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::text::core::CoreTextServicesManager, IInspectable> => [0x112fb01d,0x260a,0x51c6,0x91,0x98,0x5d,0xb3,0xe6,0xe9,0xef,0x3d] as IID_TypedEventHandler_2_Windows_UI_Text_Core_CoreTextServicesManager_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::viewmanagement::AccessibilitySettings, IInspectable> => [0xf5917e6f,0x5abf,0x5e65,0xb5,0xb4,0x1b,0x9c,0x8d,0x94,0xe7,0x88] as IID_TypedEventHandler_2_Windows_UI_ViewManagement_AccessibilitySettings_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::viewmanagement::ApplicationView, IInspectable> => [0x00c1f983,0xc836,0x565c,0x8b,0xbf,0x70,0x53,0x05,0x5b,0xdb,0x4c] as IID_TypedEventHandler_2_Windows_UI_ViewManagement_ApplicationView_System_Object }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::viewmanagement::ApplicationView, super::ui::viewmanagement::ApplicationViewConsolidatedEventArgs> => [0x463c606a,0x8c82,0x5a29,0xa2,0xbd,0x04,0x07,0x81,0xf2,0x53,0x48] as IID_TypedEventHandler_2_Windows_UI_ViewManagement_ApplicationView_Windows_UI_ViewManagement_ApplicationViewConsolidatedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::viewmanagement::core::CoreInputView, super::ui::viewmanagement::core::CoreInputViewOcclusionsChangedEventArgs> => [0x5adecf04,0xedd1,0x5133,0xab,0xc7,0x58,0x2a,0x02,0x7f,0x09,0xbb] as IID_TypedEventHandler_2_Windows_UI_ViewManagement_Core_CoreInputView_Windows_UI_ViewManagement_Core_CoreInputViewOcclusionsChangedEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::viewmanagement::InputPane, super::ui::viewmanagement::InputPaneVisibilityEventArgs> => [0xb813d684,0xd953,0x5a8a,0x9b,0x30,0x78,0xb7,0x9f,0xb9,0x14,0x7b] as IID_TypedEventHandler_2_Windows_UI_ViewManagement_InputPane_Windows_UI_ViewManagement_InputPaneVisibilityEventArgs }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::viewmanagement::UISettings, IInspectable> => [0x2dbdba9d,0x20da,0x519d,0x90,0x78,0x09,0xf8,0x35,0xbc,0x5b,0xc7] as IID_TypedEventHandler_2_Windows_UI_ViewManagement_UISettings_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::AutoSuggestBox, super::ui::xaml::controls::AutoSuggestBoxQuerySubmittedEventArgs> => [0x1fa5f243,0x7045,0x56cb,0xbf,0x2d,0xf5,0xa4,0x25,0x02,0x5c,0x21] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_AutoSuggestBox_Windows_UI_Xaml_Controls_AutoSuggestBoxQuerySubmittedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::AutoSuggestBox, super::ui::xaml::controls::AutoSuggestBoxSuggestionChosenEventArgs> => [0x7996a97e,0x615e,0x5ff5,0xbe,0x3d,0x0f,0xf9,0xfe,0x43,0x45,0x1c] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_AutoSuggestBox_Windows_UI_Xaml_Controls_AutoSuggestBoxSuggestionChosenEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::AutoSuggestBox, super::ui::xaml::controls::AutoSuggestBoxTextChangedEventArgs> => [0x7e2dc943,0x5f2f,0x54fb,0x81,0x6f,0x8e,0x65,0xe8,0x93,0xf9,0x0a] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_AutoSuggestBox_Windows_UI_Xaml_Controls_AutoSuggestBoxTextChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::CalendarDatePicker, super::ui::xaml::controls::CalendarDatePickerDateChangedEventArgs> => [0x5ff44775,0x026e,0x51db,0xb4,0x62,0x44,0xc1,0x9c,0x45,0xa7,0x77] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_CalendarDatePicker_Windows_UI_Xaml_Controls_CalendarDatePickerDateChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::CalendarView, super::ui::xaml::controls::CalendarViewDayItemChangingEventArgs> => [0x6a74874e,0xf6b3,0x5c39,0x9e,0x5f,0x17,0x51,0xb7,0x82,0xbb,0x32] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_CalendarView_Windows_UI_Xaml_Controls_CalendarViewDayItemChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::CalendarView, super::ui::xaml::controls::CalendarViewSelectedDatesChangedEventArgs> => [0xd22361ee,0x5234,0x5d25,0xa5,0x3b,0x79,0xa5,0xff,0x6a,0x03,0xb8] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_CalendarView_Windows_UI_Xaml_Controls_CalendarViewSelectedDatesChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ColorPicker, super::ui::xaml::controls::ColorChangedEventArgs> => [0xe162d9c5,0x40b6,0x5662,0x82,0xb0,0x4d,0x24,0x04,0xd3,0x71,0x6b] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ColorPicker_Windows_UI_Xaml_Controls_ColorChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::CommandBar, super::ui::xaml::controls::DynamicOverflowItemsChangingEventArgs> => [0x758990cd,0xa4a5,0x5c0a,0xac,0xa5,0x64,0xa6,0x29,0xaf,0xdb,0xcc] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_CommandBar_Windows_UI_Xaml_Controls_DynamicOverflowItemsChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ContentDialog, super::ui::xaml::controls::ContentDialogButtonClickEventArgs> => [0x4b00de1a,0xffed,0x57b4,0xbd,0x6e,0x8c,0x7a,0xab,0x2c,0x53,0xff] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ContentDialog_Windows_UI_Xaml_Controls_ContentDialogButtonClickEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ContentDialog, super::ui::xaml::controls::ContentDialogClosedEventArgs> => [0xb040eb41,0xb4f5,0x5d9f,0x83,0xc7,0x9c,0x93,0x9c,0x48,0xc8,0x90] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ContentDialog_Windows_UI_Xaml_Controls_ContentDialogClosedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ContentDialog, super::ui::xaml::controls::ContentDialogClosingEventArgs> => [0x30491cfe,0xfff8,0x5c91,0xb3,0x87,0xce,0x81,0x37,0x71,0x39,0x18] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ContentDialog_Windows_UI_Xaml_Controls_ContentDialogClosingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ContentDialog, super::ui::xaml::controls::ContentDialogOpenedEventArgs> => [0xb79b774b,0x7c7f,0x580c,0x89,0x14,0xe9,0xcb,0x26,0x42,0x43,0x2e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ContentDialog_Windows_UI_Xaml_Controls_ContentDialogOpenedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::Control, super::ui::xaml::controls::FocusDisengagedEventArgs> => [0x38b4535c,0x2785,0x5122,0x96,0xfe,0xd4,0x4f,0x79,0x5b,0x9c,0xb2] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Control_Windows_UI_Xaml_Controls_FocusDisengagedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::Control, super::ui::xaml::controls::FocusEngagedEventArgs> => [0x0c3f6433,0x66b6,0x5544,0x8b,0x9b,0x89,0x04,0xf4,0x05,0x5e,0x92] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Control_Windows_UI_Xaml_Controls_FocusEngagedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::DatePickerFlyout, super::ui::xaml::controls::DatePickedEventArgs> => [0x4d9c196f,0xcdd3,0x54d8,0x98,0xd9,0x4f,0x29,0xab,0xba,0xde,0x76] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_DatePickerFlyout_Windows_UI_Xaml_Controls_DatePickedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::InkToolbar, IInspectable> => [0xeea8b7be,0x9cba,0x5129,0x9b,0x75,0x49,0x30,0xdc,0x0c,0x27,0x05] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_InkToolbar_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::InkToolbar, super::ui::xaml::controls::InkToolbarIsStencilButtonCheckedChangedEventArgs> => [0x80a45bd6,0x7b40,0x5410,0x9c,0x65,0xa8,0xe0,0x5f,0xee,0x5e,0x0f] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_InkToolbar_Windows_UI_Xaml_Controls_InkToolbarIsStencilButtonCheckedChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::InkToolbarFlyoutItem, IInspectable> => [0x127a421c,0xae3f,0x53df,0xb9,0xad,0x17,0x68,0x47,0xf3,0x2c,0xde] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_InkToolbarFlyoutItem_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ListPickerFlyout, super::ui::xaml::controls::ItemsPickedEventArgs> => [0x46c68740,0x3f79,0x593f,0xa8,0x5f,0x42,0x48,0x12,0x79,0x48,0xc6] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ListPickerFlyout_Windows_UI_Xaml_Controls_ItemsPickedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ListViewBase, super::ui::xaml::controls::ChoosingGroupHeaderContainerEventArgs> => [0x4f5971d1,0xbae9,0x56f4,0xac,0xd6,0x0a,0x82,0x46,0xa6,0xf2,0x55] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ListViewBase_Windows_UI_Xaml_Controls_ChoosingGroupHeaderContainerEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ListViewBase, super::ui::xaml::controls::ChoosingItemContainerEventArgs> => [0xf06fc999,0x61e1,0x5d3f,0xb0,0xac,0x69,0xf2,0xee,0x9e,0x4d,0x64] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ListViewBase_Windows_UI_Xaml_Controls_ChoosingItemContainerEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ListViewBase, super::ui::xaml::controls::ContainerContentChangingEventArgs> => [0xd01fb083,0x5e61,0x5c12,0xa1,0x8f,0x62,0x94,0x71,0x58,0xfa,0xa8] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ListViewBase_Windows_UI_Xaml_Controls_ContainerContentChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::ListViewBase, super::ui::xaml::controls::DragItemsCompletedEventArgs> => [0x586d1c88,0xe27e,0x58ad,0x8e,0x2f,0x7e,0x6e,0x83,0xd8,0x1e,0x40] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_ListViewBase_Windows_UI_Xaml_Controls_DragItemsCompletedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::CustomMapTileDataSource, super::ui::xaml::controls::maps::MapTileBitmapRequestedEventArgs> => [0x8d2d9655,0x2f82,0x5271,0x9e,0x95,0xa2,0xdb,0x39,0xd8,0x72,0xf0] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_CustomMapTileDataSource_Windows_UI_Xaml_Controls_Maps_MapTileBitmapRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::HttpMapTileDataSource, super::ui::xaml::controls::maps::MapTileUriRequestedEventArgs> => [0x4933a19a,0x00cc,0x5c21,0xa3,0xdf,0xb6,0x8f,0x99,0x39,0xf6,0xef] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_HttpMapTileDataSource_Windows_UI_Xaml_Controls_Maps_MapTileUriRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::LocalMapTileDataSource, super::ui::xaml::controls::maps::MapTileUriRequestedEventArgs> => [0x76752fc4,0xb240,0x502c,0x90,0x98,0x62,0x2c,0x6c,0x36,0xe6,0xa3] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_LocalMapTileDataSource_Windows_UI_Xaml_Controls_Maps_MapTileUriRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, IInspectable> => [0xf250dd93,0xe636,0x51ef,0xbc,0x93,0xee,0x78,0xd4,0x31,0xa6,0xbd] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapActualCameraChangedEventArgs> => [0x1b536ae0,0x08b0,0x5c54,0xbb,0x30,0x67,0x9e,0x6a,0x87,0x5d,0x61] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapActualCameraChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapActualCameraChangingEventArgs> => [0x78bfb71b,0x2d80,0x50e1,0xa2,0xe9,0xe5,0x66,0x7f,0xf8,0x9e,0xf2] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapActualCameraChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapContextRequestedEventArgs> => [0xe5239641,0xba1f,0x5d89,0xaa,0xe1,0xc7,0xb4,0x99,0xa4,0x7b,0x0c] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapContextRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlBusinessLandmarkClickEventArgs> => [0x3a9d75c2,0xa41b,0x5708,0x8c,0x1b,0x8e,0x7c,0x26,0xe8,0x57,0xd0] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlBusinessLandmarkClickEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlBusinessLandmarkPointerEnteredEventArgs> => [0xfd7dabea,0x0014,0x5a30,0x9a,0x59,0xbd,0x41,0x26,0xa2,0xff,0xb7] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlBusinessLandmarkPointerEnteredEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlBusinessLandmarkPointerExitedEventArgs> => [0xc4574b81,0xa192,0x5810,0xb0,0xd9,0xcc,0x99,0x23,0x0f,0xdc,0xdc] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlBusinessLandmarkPointerExitedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlBusinessLandmarkRightTappedEventArgs> => [0xe3634a54,0x05ed,0x5e39,0x9d,0x8a,0x03,0x85,0x7f,0x0b,0xa0,0xe7] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlBusinessLandmarkRightTappedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlTransitFeatureClickEventArgs> => [0x3ec75af0,0x1679,0x53ff,0xbb,0x0c,0x37,0x6b,0x8c,0x44,0x19,0x80] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlTransitFeatureClickEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlTransitFeaturePointerEnteredEventArgs> => [0x166ea60b,0xab70,0x580c,0xbb,0x70,0x2f,0x79,0xee,0x21,0x4c,0xea] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlTransitFeaturePointerEnteredEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlTransitFeaturePointerExitedEventArgs> => [0x7553fcf8,0xa4c2,0x5cc1,0x9a,0x3c,0xf0,0xb3,0x6b,0x75,0x60,0x68] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlTransitFeaturePointerExitedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapControlTransitFeatureRightTappedEventArgs> => [0xa18b47d7,0x6326,0x5fc1,0x8a,0x40,0x88,0xaf,0x91,0xbb,0x05,0x89] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapControlTransitFeatureRightTappedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapCustomExperienceChangedEventArgs> => [0x272cf26f,0x18da,0x599e,0x89,0x6f,0x3b,0xfb,0xf6,0xfb,0x13,0x26] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapCustomExperienceChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapElementClickEventArgs> => [0x4c7821a1,0xd570,0x597d,0xac,0xc7,0x06,0x88,0x53,0xc4,0xab,0x27] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapElementClickEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapElementPointerEnteredEventArgs> => [0xca2638e5,0x7c33,0x5b90,0x9b,0x66,0x27,0x37,0x31,0xfc,0x70,0x91] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapElementPointerEnteredEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapElementPointerExitedEventArgs> => [0xf6a7bfd1,0x2c79,0x5191,0xb3,0x82,0x75,0xb1,0x41,0xd1,0x88,0x46] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapElementPointerExitedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapInputEventArgs> => [0xb92f6816,0x4d0a,0x52c2,0x98,0x68,0x94,0xb5,0xc9,0x42,0x00,0x7e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapInputEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapRightTappedEventArgs> => [0xefc52f2d,0xad6b,0x59af,0xa0,0xf0,0x22,0x53,0xd4,0x34,0x41,0x4f] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapRightTappedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapControl, super::ui::xaml::controls::maps::MapTargetCameraChangedEventArgs> => [0x2671c2dd,0xe212,0x5e43,0x80,0xe2,0xab,0x6f,0xf3,0xf3,0x08,0x6c] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapControl_Windows_UI_Xaml_Controls_Maps_MapTargetCameraChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapElementsLayer, super::ui::xaml::controls::maps::MapElementsLayerClickEventArgs> => [0xd3ee3faa,0x6a6f,0x576a,0x99,0x00,0x52,0x8e,0x8e,0xba,0x92,0x86] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapElementsLayer_Windows_UI_Xaml_Controls_Maps_MapElementsLayerClickEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapElementsLayer, super::ui::xaml::controls::maps::MapElementsLayerContextRequestedEventArgs> => [0xd4c7eced,0x5053,0x5d3c,0x8c,0xfa,0xfb,0x19,0xdb,0xde,0x4a,0x3a] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapElementsLayer_Windows_UI_Xaml_Controls_Maps_MapElementsLayerContextRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapElementsLayer, super::ui::xaml::controls::maps::MapElementsLayerPointerEnteredEventArgs> => [0x3622cf53,0x117c,0x5605,0xb1,0x42,0xfe,0x47,0xd8,0x74,0xe2,0x6b] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapElementsLayer_Windows_UI_Xaml_Controls_Maps_MapElementsLayerPointerEnteredEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapElementsLayer, super::ui::xaml::controls::maps::MapElementsLayerPointerExitedEventArgs> => [0xd54471d2,0x03dd,0x5698,0xa9,0x2f,0x5f,0xac,0x8a,0x5e,0x76,0x68] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapElementsLayer_Windows_UI_Xaml_Controls_Maps_MapElementsLayerPointerExitedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::maps::MapScene, super::ui::xaml::controls::maps::MapTargetCameraChangedEventArgs> => [0x766ed4a8,0xe810,0x5f78,0xbc,0x96,0x9a,0xff,0x9f,0x58,0xcf,0xca] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Maps_MapScene_Windows_UI_Xaml_Controls_Maps_MapTargetCameraChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::MediaElement, super::ui::xaml::media::PartialMediaFailureDetectedEventArgs> => [0xb402b0ca,0xbeca,0x5537,0x81,0x92,0x8f,0x30,0xf7,0xcb,0x5d,0x0e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_MediaElement_Windows_UI_Xaml_Media_PartialMediaFailureDetectedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::MediaTransportControls, super::ui::xaml::media::MediaTransportControlsThumbnailRequestedEventArgs> => [0xc2925ff8,0x71f0,0x59d3,0xba,0x13,0x86,0x2b,0x22,0x6e,0xeb,0xa2] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_MediaTransportControls_Windows_UI_Xaml_Media_MediaTransportControlsThumbnailRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::NavigationView, super::ui::xaml::controls::NavigationViewDisplayModeChangedEventArgs> => [0x10a54ac4,0x84cf,0x580b,0xa6,0x3d,0x51,0xaa,0x3a,0x6a,0x3c,0x0a] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_NavigationView_Windows_UI_Xaml_Controls_NavigationViewDisplayModeChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::NavigationView, super::ui::xaml::controls::NavigationViewItemInvokedEventArgs> => [0x15ec8ec2,0xc8b3,0x53e7,0x89,0x3c,0x0c,0xfb,0x68,0x54,0x9b,0x77] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_NavigationView_Windows_UI_Xaml_Controls_NavigationViewItemInvokedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::NavigationView, super::ui::xaml::controls::NavigationViewSelectionChangedEventArgs> => [0x17c78c17,0x2850,0x5dd4,0x83,0xd6,0xd4,0x70,0x32,0x3c,0x21,0xc7] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_NavigationView_Windows_UI_Xaml_Controls_NavigationViewSelectionChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::PasswordBox, super::ui::xaml::controls::PasswordBoxPasswordChangingEventArgs> => [0xc3bc2f43,0x1d73,0x5aac,0xae,0xd4,0xb4,0xe0,0x86,0x03,0xe9,0xf0] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_PasswordBox_Windows_UI_Xaml_Controls_PasswordBoxPasswordChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::PickerFlyout, super::ui::xaml::controls::PickerConfirmedEventArgs> => [0x22cde5b7,0x4eb7,0x5ee4,0x8d,0x28,0x1f,0x1c,0xbc,0xf6,0x8f,0xb0] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_PickerFlyout_Windows_UI_Xaml_Controls_PickerConfirmedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::Pivot, super::ui::xaml::controls::PivotItemEventArgs> => [0x6b0c4ca2,0x7feb,0x5e4e,0xbf,0x5c,0xde,0x9f,0x3a,0xc4,0x22,0x1c] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Pivot_Windows_UI_Xaml_Controls_PivotItemEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::primitives::ColorSpectrum, super::ui::xaml::controls::ColorChangedEventArgs> => [0x650cfa09,0x70c2,0x5151,0xa2,0xcd,0x27,0x57,0x0f,0xb9,0x55,0x6b] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Primitives_ColorSpectrum_Windows_UI_Xaml_Controls_ColorChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::primitives::FlyoutBase, super::ui::xaml::controls::primitives::FlyoutBaseClosingEventArgs> => [0x96e17fbc,0x78c7,0x5560,0xac,0x3a,0x58,0x7f,0x46,0xdb,0x70,0xd6] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_Primitives_FlyoutBase_Windows_UI_Xaml_Controls_Primitives_FlyoutBaseClosingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RatingControl, IInspectable> => [0x180be111,0xc600,0x5e5d,0x82,0x66,0xfb,0x29,0xb9,0x65,0x6a,0xf4] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RatingControl_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::CandidateWindowBoundsChangedEventArgs> => [0xb0b3c248,0x7604,0x5108,0xae,0xc9,0x6f,0x3a,0xec,0xca,0x27,0x37] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_CandidateWindowBoundsChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::RichEditBoxTextChangingEventArgs> => [0xfad2ffb9,0xd2d9,0x563c,0x88,0xca,0x13,0x23,0xb1,0x33,0xfb,0xf3] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_RichEditBoxTextChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::TextCompositionChangedEventArgs> => [0xc080b01b,0xeec0,0x542c,0xb1,0xf1,0xd0,0x0e,0x20,0x7e,0xe1,0xe0] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_TextCompositionChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::TextCompositionEndedEventArgs> => [0xe6750b95,0x305f,0x52fd,0xbb,0x80,0xcf,0xcf,0x72,0xbc,0x54,0x21] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_TextCompositionEndedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::TextCompositionStartedEventArgs> => [0x297dde84,0xd0c7,0x5d21,0xb1,0xed,0xf9,0x6c,0x4e,0xa4,0x77,0x2f] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_TextCompositionStartedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::TextControlCopyingToClipboardEventArgs> => [0xb8cb973a,0x91c4,0x5ae4,0x8b,0x4e,0x01,0xb9,0x68,0xdc,0x1a,0x57] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_TextControlCopyingToClipboardEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichEditBox, super::ui::xaml::controls::TextControlCuttingToClipboardEventArgs> => [0xc3feed97,0xc386,0x5d87,0xa3,0x20,0xe9,0x5c,0xcb,0x36,0x5a,0x6b] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichEditBox_Windows_UI_Xaml_Controls_TextControlCuttingToClipboardEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichTextBlock, super::ui::xaml::controls::IsTextTrimmedChangedEventArgs> => [0x1e9d65a8,0x7312,0x5d13,0xa3,0xb9,0x27,0xa9,0x1b,0x90,0x63,0x24] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichTextBlock_Windows_UI_Xaml_Controls_IsTextTrimmedChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::RichTextBlockOverflow, super::ui::xaml::controls::IsTextTrimmedChangedEventArgs> => [0x8f4572d1,0x9348,0x56b3,0xb0,0x45,0xcb,0x42,0xf9,0x8a,0x43,0xa4] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_RichTextBlockOverflow_Windows_UI_Xaml_Controls_IsTextTrimmedChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SearchBox, super::ui::xaml::controls::SearchBoxQueryChangedEventArgs> => [0xb15ccc28,0x40f3,0x52da,0x90,0x11,0x87,0x62,0x1e,0x9c,0x60,0xea] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SearchBox_Windows_UI_Xaml_Controls_SearchBoxQueryChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SearchBox, super::ui::xaml::controls::SearchBoxQuerySubmittedEventArgs> => [0x56d6c824,0xa5b2,0x51f4,0x8a,0xf7,0x7b,0x8e,0xe5,0x82,0xc0,0x29] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SearchBox_Windows_UI_Xaml_Controls_SearchBoxQuerySubmittedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SearchBox, super::ui::xaml::controls::SearchBoxResultSuggestionChosenEventArgs> => [0x8d18767b,0xa4b8,0x52fc,0x87,0x67,0xf8,0x7d,0x05,0xb5,0x17,0x2e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SearchBox_Windows_UI_Xaml_Controls_SearchBoxResultSuggestionChosenEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SearchBox, super::ui::xaml::controls::SearchBoxSuggestionsRequestedEventArgs> => [0x287dd4fe,0x12fc,0x5289,0xab,0x8a,0x7c,0x72,0x17,0x02,0x4a,0x6b] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SearchBox_Windows_UI_Xaml_Controls_SearchBoxSuggestionsRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SearchBox, super::ui::xaml::RoutedEventArgs> => [0xa16eff3c,0xcc37,0x554c,0x8f,0x10,0x0f,0x7e,0x6e,0x2b,0xca,0xad] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SearchBox_Windows_UI_Xaml_RoutedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SplitView, IInspectable> => [0xe277bfe5,0x10c1,0x5472,0x9b,0xc6,0x1a,0xe3,0x9a,0xeb,0xfc,0x86] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SplitView_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SplitView, super::ui::xaml::controls::SplitViewPaneClosingEventArgs> => [0xc674a1de,0xc3d9,0x5e39,0xbc,0x39,0x12,0x1f,0xc3,0xcc,0x7d,0x41] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SplitView_Windows_UI_Xaml_Controls_SplitViewPaneClosingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SwapChainPanel, IInspectable> => [0xa8bbf146,0xb687,0x5c03,0x9a,0x42,0x2a,0xe2,0xd5,0x5b,0xfb,0xb4] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SwapChainPanel_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::SwipeItem, super::ui::xaml::controls::SwipeItemInvokedEventArgs> => [0x3397b4eb,0xce58,0x5d81,0xa2,0x5f,0xe8,0xe6,0x31,0x98,0xb3,0x68] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_SwipeItem_Windows_UI_Xaml_Controls_SwipeItemInvokedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBlock, super::ui::xaml::controls::IsTextTrimmedChangedEventArgs> => [0x4f8ad0d6,0x06e6,0x5c3d,0xb2,0x53,0x8e,0x23,0x99,0x1f,0x4e,0x80] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBlock_Windows_UI_Xaml_Controls_IsTextTrimmedChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::CandidateWindowBoundsChangedEventArgs> => [0xb6b53bf8,0x1ac8,0x51c4,0xba,0xfc,0x95,0xf8,0xe0,0x16,0x37,0xb0] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_CandidateWindowBoundsChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextBoxBeforeTextChangingEventArgs> => [0x40c0c57b,0x7c67,0x52f4,0xb3,0x18,0xbe,0xa8,0xfd,0x03,0x36,0x10] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextBoxBeforeTextChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextBoxTextChangingEventArgs> => [0x1e65e112,0xe634,0x55c3,0xbe,0xfb,0xdb,0xf5,0xcf,0xcb,0x30,0xb1] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextBoxTextChangingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextCompositionChangedEventArgs> => [0x61107067,0x2cfb,0x5de1,0x92,0xb6,0xd3,0x32,0xc1,0x7f,0x75,0x6e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextCompositionChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextCompositionEndedEventArgs> => [0xb9ac0e9e,0x5b32,0x52b7,0xa8,0xf9,0xb8,0x5e,0x4b,0xe1,0x4b,0x16] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextCompositionEndedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextCompositionStartedEventArgs> => [0x98fee2a4,0x211d,0x5a3d,0xa8,0x32,0xc5,0xdd,0xeb,0x84,0x44,0xa9] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextCompositionStartedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextControlCopyingToClipboardEventArgs> => [0x50c332f2,0x58d1,0x5228,0xa3,0xa9,0x1c,0xcb,0xde,0xd7,0x05,0x37] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextControlCopyingToClipboardEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TextBox, super::ui::xaml::controls::TextControlCuttingToClipboardEventArgs> => [0xc1033f73,0xf81a,0x50d8,0x8d,0x3a,0x07,0xb3,0x8d,0x8d,0x17,0x7e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TextBox_Windows_UI_Xaml_Controls_TextControlCuttingToClipboardEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::TimePickerFlyout, super::ui::xaml::controls::TimePickedEventArgs> => [0x7d77980b,0xa0df,0x51b1,0x87,0x9b,0xc2,0x3d,0x2d,0xe0,0xab,0xbe] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_TimePickerFlyout_Windows_UI_Xaml_Controls_TimePickedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, IInspectable> => [0xd9f52e0d,0x21fb,0x5a0b,0xb4,0xc6,0x7d,0x16,0x2a,0xf7,0xfb,0x9c] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewContentLoadingEventArgs> => [0xe7b42a9a,0xf140,0x52ad,0xa6,0x58,0xe2,0x37,0xb9,0xa3,0xdc,0xca] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewContentLoadingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewDOMContentLoadedEventArgs> => [0xb9cc891c,0x4745,0x5a25,0x98,0x45,0xe4,0x4d,0x13,0x42,0x5a,0x38] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewDOMContentLoadedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewLongRunningScriptDetectedEventArgs> => [0xecdc76ef,0xa99b,0x5ce7,0xb9,0xa4,0xc8,0x5e,0x66,0xfe,0xd1,0xee] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewLongRunningScriptDetectedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewNavigationCompletedEventArgs> => [0x411136f7,0x770d,0x599c,0x85,0x45,0x6d,0x05,0x3a,0x6a,0x17,0x99] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewNavigationCompletedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewNavigationStartingEventArgs> => [0x98055b5a,0x36bb,0x5962,0x97,0x1f,0x8b,0x87,0x61,0x9e,0xb1,0x7e] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewNavigationStartingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewNewWindowRequestedEventArgs> => [0xa8d0aff5,0x90e1,0x5921,0x87,0xdd,0x57,0x6a,0x4b,0x0a,0x95,0xb6] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewNewWindowRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewPermissionRequestedEventArgs> => [0x718c7a23,0xeb9f,0x50a6,0x8c,0xf7,0xfb,0xac,0x10,0x4e,0x59,0xc3] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewPermissionRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewUnsupportedUriSchemeIdentifiedEventArgs> => [0xd304027c,0x5714,0x502a,0x93,0x12,0x68,0xca,0x86,0x39,0x71,0x24] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewUnsupportedUriSchemeIdentifiedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::controls::WebView, super::ui::xaml::controls::WebViewUnviewableContentIdentifiedEventArgs> => [0xf00e9fbf,0xd30e,0x5854,0x89,0x27,0xc9,0x51,0x2a,0xbd,0x81,0x18] as IID_TypedEventHandler_2_Windows_UI_Xaml_Controls_WebView_Windows_UI_Xaml_Controls_WebViewUnviewableContentIdentifiedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::documents::Hyperlink, super::ui::xaml::documents::HyperlinkClickEventArgs> => [0x5fead0d2,0xe657,0x5aef,0xa9,0x1b,0x7f,0x52,0xea,0xd1,0x7f,0xe3] as IID_TypedEventHandler_2_Windows_UI_Xaml_Documents_Hyperlink_Windows_UI_Xaml_Documents_HyperlinkClickEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::documents::TextElement, super::ui::xaml::input::AccessKeyDisplayDismissedEventArgs> => [0xa8c9544b,0x7078,0x5316,0xbe,0xb6,0xd9,0xec,0x91,0x6a,0xb8,0x8a] as IID_TypedEventHandler_2_Windows_UI_Xaml_Documents_TextElement_Windows_UI_Xaml_Input_AccessKeyDisplayDismissedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::documents::TextElement, super::ui::xaml::input::AccessKeyDisplayRequestedEventArgs> => [0x39ad7708,0x254e,0x560a,0x9e,0x2e,0x73,0xb1,0xdb,0x31,0xf9,0x35] as IID_TypedEventHandler_2_Windows_UI_Xaml_Documents_TextElement_Windows_UI_Xaml_Input_AccessKeyDisplayRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::documents::TextElement, super::ui::xaml::input::AccessKeyInvokedEventArgs> => [0xa72c6b01,0x2e3c,0x57b5,0x9e,0xc4,0x94,0x8f,0x6c,0x6d,0x93,0x0a] as IID_TypedEventHandler_2_Windows_UI_Xaml_Documents_TextElement_Windows_UI_Xaml_Input_AccessKeyInvokedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::FrameworkElement, IInspectable> => [0xc229f252,0xdede,0x5d42,0xa0,0x1a,0x84,0x79,0xd5,0x6a,0x7d,0x2f] as IID_TypedEventHandler_2_Windows_UI_Xaml_FrameworkElement_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::FrameworkElement, super::ui::xaml::DataContextChangedEventArgs> => [0xb01c8a21,0xde6f,0x5edd,0x87,0x96,0x30,0x0e,0x3f,0xe6,0x63,0x82] as IID_TypedEventHandler_2_Windows_UI_Xaml_FrameworkElement_Windows_UI_Xaml_DataContextChangedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::hosting::DesignerAppManager, super::ui::xaml::hosting::DesignerAppExitedEventArgs> => [0x3772ce98,0x9ba0,0x504b,0x8a,0x0d,0x36,0xb7,0xf8,0x16,0xa1,0xc2] as IID_TypedEventHandler_2_Windows_UI_Xaml_Hosting_DesignerAppManager_Windows_UI_Xaml_Hosting_DesignerAppExitedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::input::KeyboardAccelerator, super::ui::xaml::input::KeyboardAcceleratorInvokedEventArgs> => [0xf763f3ae,0xb1eb,0x5592,0xa0,0x91,0xd5,0x08,0xf3,0x2b,0x0b,0x2c] as IID_TypedEventHandler_2_Windows_UI_Xaml_Input_KeyboardAccelerator_Windows_UI_Xaml_Input_KeyboardAcceleratorInvokedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::media::animation::ConnectedAnimation, IInspectable> => [0x44caa9ea,0x7598,0x517a,0xb7,0x8e,0xab,0xd2,0x0d,0x93,0xd5,0x87] as IID_TypedEventHandler_2_Windows_UI_Xaml_Media_Animation_ConnectedAnimation_System_Object }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::media::imaging::SvgImageSource, super::ui::xaml::media::imaging::SvgImageSourceFailedEventArgs> => [0xd723938d,0xefee,0x5a0c,0xab,0x3e,0x1e,0x1d,0xb3,0xc9,0xa2,0x16] as IID_TypedEventHandler_2_Windows_UI_Xaml_Media_Imaging_SvgImageSource_Windows_UI_Xaml_Media_Imaging_SvgImageSourceFailedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::media::imaging::SvgImageSource, super::ui::xaml::media::imaging::SvgImageSourceOpenedEventArgs> => [0x9e321151,0x8b27,0x5e18,0x9e,0xa3,0x50,0x52,0x0a,0xce,0xb7,0xef] as IID_TypedEventHandler_2_Windows_UI_Xaml_Media_Imaging_SvgImageSource_Windows_UI_Xaml_Media_Imaging_SvgImageSourceOpenedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::media::LoadedImageSurface, super::ui::xaml::media::LoadedImageSourceLoadCompletedEventArgs> => [0x0aa0c46e,0x1db6,0x5850,0xae,0x17,0xec,0x31,0x0e,0xa3,0xfd,0x2d] as IID_TypedEventHandler_2_Windows_UI_Xaml_Media_LoadedImageSurface_Windows_UI_Xaml_Media_LoadedImageSourceLoadCompletedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::DragStartingEventArgs> => [0xecc4b13b,0x146c,0x5963,0xb8,0xb3,0x02,0x4c,0x5b,0x9b,0x95,0xe4] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_DragStartingEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::DropCompletedEventArgs> => [0xffd72e78,0xec1f,0x5bcc,0x9d,0x13,0xff,0x5f,0xbb,0x04,0x05,0x62] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_DropCompletedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::AccessKeyDisplayDismissedEventArgs> => [0x2831903f,0x655e,0x5464,0x82,0x8c,0x56,0xa8,0xb4,0xc6,0x5f,0x1e] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_AccessKeyDisplayDismissedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::AccessKeyDisplayRequestedEventArgs> => [0x5871821a,0x2491,0x5cec,0xa4,0x57,0x21,0x99,0x6c,0xa4,0xef,0xaf] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_AccessKeyDisplayRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::AccessKeyInvokedEventArgs> => [0xa5c9a137,0xf716,0x5d8d,0x92,0xc4,0x02,0xf1,0x71,0x93,0x6f,0xa1] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_AccessKeyInvokedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::CharacterReceivedRoutedEventArgs> => [0x24330117,0x55d4,0x5789,0x8a,0xa2,0x6c,0xab,0x1d,0x06,0x62,0xa0] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_CharacterReceivedRoutedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::ContextRequestedEventArgs> => [0x41d66b93,0xd17b,0x59b2,0xb9,0x16,0x8e,0x81,0x3f,0xec,0xb9,0xbd] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_ContextRequestedEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::GettingFocusEventArgs> => [0x34f34b77,0xec52,0x5eb6,0xaf,0xfc,0x22,0x0c,0xb5,0x2c,0xa0,0x93] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_GettingFocusEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::LosingFocusEventArgs> => [0xa0f49f5f,0xc366,0x569a,0x89,0x5a,0x3a,0x82,0xd8,0x80,0x1f,0xe4] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_LosingFocusEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::NoFocusCandidateFoundEventArgs> => [0xd5de4415,0xb53c,0x5312,0x9e,0x1b,0xac,0x2a,0x19,0xf0,0x4e,0x71] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_NoFocusCandidateFoundEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::input::ProcessKeyboardAcceleratorEventArgs> => [0xc134d249,0x476a,0x5146,0xb5,0xd4,0x6c,0x98,0xf4,0xe8,0x14,0x61] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_Input_ProcessKeyboardAcceleratorEventArgs }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for TypedEventHandler<super::ui::xaml::UIElement, super::ui::xaml::RoutedEventArgs> => [0x657f28aa,0x8c76,0x501f,0xb0,0x32,0xd8,0xdc,0x93,0x59,0x5e,0x76] as IID_TypedEventHandler_2_Windows_UI_Xaml_UIElement_Windows_UI_Xaml_RoutedEventArgs }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for TypedEventHandler<super::web::http::diagnostics::HttpDiagnosticProvider, super::web::http::diagnostics::HttpDiagnosticProviderRequestResponseCompletedEventArgs> => [0x2281ad23,0x9c8d,0x5d82,0x9b,0x20,0xbc,0xf1,0x57,0xb0,0x4f,0xd9] as IID_TypedEventHandler_2_Windows_Web_Http_Diagnostics_HttpDiagnosticProvider_Windows_Web_Http_Diagnostics_HttpDiagnosticProviderRequestResponseCompletedEventArgs }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for TypedEventHandler<super::web::http::diagnostics::HttpDiagnosticProvider, super::web::http::diagnostics::HttpDiagnosticProviderRequestSentEventArgs> => [0xf8e10321,0x47bd,0x526a,0xa9,0xb2,0x3b,0xf1,0x2f,0x72,0x5f,0x8b] as IID_TypedEventHandler_2_Windows_Web_Http_Diagnostics_HttpDiagnosticProvider_Windows_Web_Http_Diagnostics_HttpDiagnosticProviderRequestSentEventArgs }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for TypedEventHandler<super::web::http::diagnostics::HttpDiagnosticProvider, super::web::http::diagnostics::HttpDiagnosticProviderResponseReceivedEventArgs> => [0x2eef1846,0x8176,0x52af,0x8d,0x2b,0xe0,0xc9,0x32,0x51,0x2e,0x9f] as IID_TypedEventHandler_2_Windows_Web_Http_Diagnostics_HttpDiagnosticProvider_Windows_Web_Http_Diagnostics_HttpDiagnosticProviderResponseReceivedEventArgs }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for TypedEventHandler<super::web::http::filters::HttpBaseProtocolFilter, super::web::http::filters::HttpServerCustomValidationRequestedEventArgs> => [0xed0260c6,0x41f2,0x5a04,0x9a,0x8b,0x29,0x30,0xd7,0xff,0x8a,0x9e] as IID_TypedEventHandler_2_Windows_Web_Http_Filters_HttpBaseProtocolFilter_Windows_Web_Http_Filters_HttpServerCustomValidationRequestedEventArgs }
pub mod collections { // Windows.Foundation.Collections
use ::prelude::*;
RT_ENUM! { enum CollectionChange: i32 {
    Reset (CollectionChange_Reset) = 0, ItemInserted (CollectionChange_ItemInserted) = 1, ItemRemoved (CollectionChange_ItemRemoved) = 2, ItemChanged (CollectionChange_ItemChanged) = 3,
}}
DEFINE_IID!(IID_IIterable, 4205151722, 25108, 16919, 175, 218, 127, 70, 222, 88, 105, 179);
RT_INTERFACE!{interface IIterable<T>(IIterableVtbl): IInspectable(IInspectableVtbl) [IID_IIterable] {
    fn First(&self, out: *mut *mut IIterator<T>) -> HRESULT
}}
impl<T: RtType> IIterable<T> {
    #[inline] pub unsafe fn first(&self) -> Result<ComPtr<IIterator<T>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).First)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IIterator, 1786374243, 17152, 17818, 153, 102, 203, 182, 96, 150, 62, 225);
RT_INTERFACE!{interface IIterator<T>(IIteratorVtbl): IInspectable(IInspectableVtbl) [IID_IIterator] {
    fn get_Current(&self, out: *mut T::Abi) -> HRESULT,
    fn get_HasCurrent(&self, out: *mut bool) -> HRESULT,
    fn MoveNext(&self, out: *mut bool) -> HRESULT,
    fn GetMany(&self, itemsSize: u32, items: *mut T::Abi, out: *mut u32) -> HRESULT
}}
impl<T: RtType> IIterator<T> {
    #[inline] pub unsafe fn get_current(&self) -> Result<T::Out> {
        let mut out = T::uninitialized();
        let hr = ((*self.lpVtbl).get_Current)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(T::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_current(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasCurrent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_next(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveNext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_many(&self, items: &mut Vec<T::Out>) -> Result<()> {
        debug_assert!(items.capacity() > 0, "capacity of `items` must not be 0 (use Vec::with_capacity)"); items.clear();
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetMany)(self as *const _ as *mut _, items.capacity() as u32, items.as_mut_ptr() as *mut T::Abi, &mut out);
        if hr == S_OK { items.set_len(out as usize); Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IKeyValuePair, 45422889, 49604, 19070, 137, 64, 3, 18, 181, 193, 133, 0);
RT_INTERFACE!{interface IKeyValuePair<K, V>(IKeyValuePairVtbl): IInspectable(IInspectableVtbl) [IID_IKeyValuePair] {
    fn get_Key(&self, out: *mut K::Abi) -> HRESULT,
    fn get_Value(&self, out: *mut V::Abi) -> HRESULT
}}
impl<K: RtType, V: RtType> IKeyValuePair<K, V> {
    #[inline] pub unsafe fn get_key(&self) -> Result<K::Out> {
        let mut out = K::uninitialized();
        let hr = ((*self.lpVtbl).get_Key)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(K::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<V::Out> {
        let mut out = V::uninitialized();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(V::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMap, 1009329662, 34073, 17857, 170, 121, 25, 123, 103, 24, 193, 193);
RT_INTERFACE!{interface IMap<K, V>(IMapVtbl): IInspectable(IInspectableVtbl) [IID_IMap] {
    fn Lookup(&self, key: K::Abi, out: *mut V::Abi) -> HRESULT,
    fn get_Size(&self, out: *mut u32) -> HRESULT,
    fn HasKey(&self, key: K::Abi, out: *mut bool) -> HRESULT,
    fn GetView(&self, out: *mut *mut IMapView<K, V>) -> HRESULT,
    fn Insert(&self, key: K::Abi, value: V::Abi, out: *mut bool) -> HRESULT,
    fn Remove(&self, key: K::Abi) -> HRESULT,
    fn Clear(&self) -> HRESULT
}}
impl<K: RtType, V: RtType> IMap<K, V> {
    #[inline] pub unsafe fn lookup(&self, key: &K::In) -> Result<V::Out> {
        let mut out = V::uninitialized();
        let hr = ((*self.lpVtbl).Lookup)(self as *const _ as *mut _, K::unwrap(key), &mut out);
        if hr == S_OK { Ok(V::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn has_key(&self, key: &K::In) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).HasKey)(self as *const _ as *mut _, K::unwrap(key), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_view(&self) -> Result<ComPtr<IMapView<K, V>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn insert(&self, key: &K::In, value: &V::In) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Insert)(self as *const _ as *mut _, K::unwrap(key), V::unwrap(value), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove(&self, key: &K::In) -> Result<()> {
        let hr = ((*self.lpVtbl).Remove)(self as *const _ as *mut _, K::unwrap(key));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Clear)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMapChangedEventArgs, 2570712287, 1290, 19471, 170, 96, 119, 7, 95, 156, 71, 119);
RT_INTERFACE!{interface IMapChangedEventArgs<K>(IMapChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMapChangedEventArgs] {
    fn get_CollectionChange(&self, out: *mut CollectionChange) -> HRESULT,
    fn get_Key(&self, out: *mut K::Abi) -> HRESULT
}}
impl<K: RtType> IMapChangedEventArgs<K> {
    #[inline] pub unsafe fn get_collection_change(&self) -> Result<CollectionChange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CollectionChange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key(&self) -> Result<K::Out> {
        let mut out = K::uninitialized();
        let hr = ((*self.lpVtbl).get_Key)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(K::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_MapChangedEventHandler, 395646963, 38126, 16888, 189, 220, 118, 138, 137, 85, 68, 243);
RT_DELEGATE!{delegate MapChangedEventHandler<K, V>(MapChangedEventHandlerVtbl, MapChangedEventHandlerImpl) [IID_MapChangedEventHandler] {
    fn Invoke(&self, sender: *mut IObservableMap<K, V>, event: *mut IMapChangedEventArgs<K>) -> HRESULT
}}
impl<K: RtType, V: RtType> MapChangedEventHandler<K, V> {
    #[inline] pub unsafe fn invoke(&self, sender: &IObservableMap<K, V>, event: &IMapChangedEventArgs<K>) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, event as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMapView, 3833646656, 41784, 19162, 173, 207, 39, 34, 114, 228, 140, 185);
RT_INTERFACE!{interface IMapView<K, V>(IMapViewVtbl): IInspectable(IInspectableVtbl) [IID_IMapView] {
    fn Lookup(&self, key: K::Abi, out: *mut V::Abi) -> HRESULT,
    fn get_Size(&self, out: *mut u32) -> HRESULT,
    fn HasKey(&self, key: K::Abi, out: *mut bool) -> HRESULT,
    fn Split(&self, first: *mut *mut IMapView<K, V>, second: *mut *mut IMapView<K, V>) -> HRESULT
}}
impl<K: RtType, V: RtType> IMapView<K, V> {
    #[inline] pub unsafe fn lookup(&self, key: &K::In) -> Result<V::Out> {
        let mut out = V::uninitialized();
        let hr = ((*self.lpVtbl).Lookup)(self as *const _ as *mut _, K::unwrap(key), &mut out);
        if hr == S_OK { Ok(V::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn has_key(&self, key: &K::In) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).HasKey)(self as *const _ as *mut _, K::unwrap(key), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn split(&self) -> Result<(ComPtr<IMapView<K, V>>, ComPtr<IMapView<K, V>>)> {
        let mut first = null_mut(); let mut second = null_mut();
        let hr = ((*self.lpVtbl).Split)(self as *const _ as *mut _, &mut first, &mut second);
        if hr == S_OK { Ok((ComPtr::wrap(first), ComPtr::wrap(second))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IObservableMap, 1709124597, 48953, 16821, 174, 188, 90, 157, 134, 94, 71, 43);
RT_INTERFACE!{interface IObservableMap<K, V>(IObservableMapVtbl): IInspectable(IInspectableVtbl) [IID_IObservableMap] {
    fn add_MapChanged(&self, vhnd: *mut MapChangedEventHandler<K, V>, out: *mut super::EventRegistrationToken) -> HRESULT,
    fn remove_MapChanged(&self, token: super::EventRegistrationToken) -> HRESULT
}}
impl<K: RtType, V: RtType> IObservableMap<K, V> {
    #[inline] pub unsafe fn add_map_changed(&self, vhnd: &MapChangedEventHandler<K, V>) -> Result<super::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MapChanged)(self as *const _ as *mut _, vhnd as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_map_changed(&self, token: super::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MapChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IObservableVector, 1494739795, 20660, 18957, 179, 9, 101, 134, 43, 63, 29, 188);
RT_INTERFACE!{interface IObservableVector<T>(IObservableVectorVtbl): IInspectable(IInspectableVtbl) [IID_IObservableVector] {
    fn add_VectorChanged(&self, vhnd: *mut VectorChangedEventHandler<T>, out: *mut super::EventRegistrationToken) -> HRESULT,
    fn remove_VectorChanged(&self, token: super::EventRegistrationToken) -> HRESULT
}}
impl<T: RtType> IObservableVector<T> {
    #[inline] pub unsafe fn add_vector_changed(&self, vhnd: &VectorChangedEventHandler<T>) -> Result<super::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VectorChanged)(self as *const _ as *mut _, vhnd as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_vector_changed(&self, token: super::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VectorChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPropertySet, 2319707551, 62694, 17441, 172, 249, 29, 171, 41, 134, 130, 12);
RT_INTERFACE!{interface IPropertySet(IPropertySetVtbl): IInspectable(IInspectableVtbl) [IID_IPropertySet] {
    
}}
RT_CLASS!{class PropertySet: IPropertySet}
impl RtActivatable<IActivationFactory> for PropertySet {}
DEFINE_CLSID!(PropertySet(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,67,111,108,108,101,99,116,105,111,110,115,46,80,114,111,112,101,114,116,121,83,101,116,0]) [CLSID_PropertySet]);
RT_CLASS!{class StringMap: IMap<HString, HString>}
impl RtActivatable<IActivationFactory> for StringMap {}
DEFINE_CLSID!(StringMap(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,67,111,108,108,101,99,116,105,111,110,115,46,83,116,114,105,110,103,77,97,112,0]) [CLSID_StringMap]);
RT_CLASS!{class ValueSet: IPropertySet}
impl RtActivatable<IActivationFactory> for ValueSet {}
DEFINE_CLSID!(ValueSet(&[87,105,110,100,111,119,115,46,70,111,117,110,100,97,116,105,111,110,46,67,111,108,108,101,99,116,105,111,110,115,46,86,97,108,117,101,83,101,116,0]) [CLSID_ValueSet]);
DEFINE_IID!(IID_IVector, 2436052969, 4513, 17221, 163, 162, 78, 127, 149, 110, 34, 45);
RT_INTERFACE!{interface IVector<T>(IVectorVtbl): IInspectable(IInspectableVtbl) [IID_IVector] {
    fn GetAt(&self, index: u32, out: *mut T::Abi) -> HRESULT,
    fn get_Size(&self, out: *mut u32) -> HRESULT,
    fn GetView(&self, out: *mut *mut IVectorView<T>) -> HRESULT,
    fn IndexOf(&self, value: T::Abi, index: *mut u32, out: *mut bool) -> HRESULT,
    fn SetAt(&self, index: u32, value: T::Abi) -> HRESULT,
    fn InsertAt(&self, index: u32, value: T::Abi) -> HRESULT,
    fn RemoveAt(&self, index: u32) -> HRESULT,
    fn Append(&self, value: T::Abi) -> HRESULT,
    fn RemoveAtEnd(&self) -> HRESULT,
    fn Clear(&self) -> HRESULT,
    fn GetMany(&self, startIndex: u32, itemsSize: u32, items: *mut T::Abi, out: *mut u32) -> HRESULT,
    fn ReplaceAll(&self, itemsSize: u32, items: *mut T::Abi) -> HRESULT
}}
impl<T: RtType> IVector<T> {
    #[inline] pub unsafe fn get_at(&self, index: u32) -> Result<T::Out> {
        let mut out = T::uninitialized();
        let hr = ((*self.lpVtbl).GetAt)(self as *const _ as *mut _, index, &mut out);
        if hr == S_OK { Ok(T::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_view(&self) -> Result<ComPtr<IVectorView<T>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn index_of(&self, value: &T::In) -> Result<(u32, bool)> {
        let mut index = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).IndexOf)(self as *const _ as *mut _, T::unwrap(value), &mut index, &mut out);
        if hr == S_OK { Ok((index, out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_at(&self, index: u32, value: &T::In) -> Result<()> {
        let hr = ((*self.lpVtbl).SetAt)(self as *const _ as *mut _, index, T::unwrap(value));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn insert_at(&self, index: u32, value: &T::In) -> Result<()> {
        let hr = ((*self.lpVtbl).InsertAt)(self as *const _ as *mut _, index, T::unwrap(value));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_at(&self, index: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveAt)(self as *const _ as *mut _, index);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn append(&self, value: &T::In) -> Result<()> {
        let hr = ((*self.lpVtbl).Append)(self as *const _ as *mut _, T::unwrap(value));
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_at_end(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveAtEnd)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Clear)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_many(&self, startIndex: u32, items: &mut Vec<T::Out>) -> Result<()> {
        debug_assert!(items.capacity() > 0, "capacity of `items` must not be 0 (use Vec::with_capacity)"); items.clear();
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetMany)(self as *const _ as *mut _, startIndex, items.capacity() as u32, items.as_mut_ptr() as *mut T::Abi, &mut out);
        if hr == S_OK { items.set_len(out as usize); Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn replace_all(&self, items: &[&T::In]) -> Result<()> {
        let hr = ((*self.lpVtbl).ReplaceAll)(self as *const _ as *mut _, items.len() as u32, items.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVectorChangedEventArgs, 1465463775, 13566, 17536, 175, 21, 7, 105, 31, 61, 93, 155);
RT_INTERFACE!{interface IVectorChangedEventArgs(IVectorChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVectorChangedEventArgs] {
    fn get_CollectionChange(&self, out: *mut CollectionChange) -> HRESULT,
    fn get_Index(&self, out: *mut u32) -> HRESULT
}}
impl IVectorChangedEventArgs {
    #[inline] pub unsafe fn get_collection_change(&self) -> Result<CollectionChange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CollectionChange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Index)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_VectorChangedEventHandler, 201660242, 40895, 19568, 170, 12, 14, 76, 130, 217, 167, 97);
RT_DELEGATE!{delegate VectorChangedEventHandler<T>(VectorChangedEventHandlerVtbl, VectorChangedEventHandlerImpl) [IID_VectorChangedEventHandler] {
    fn Invoke(&self, sender: *mut IObservableVector<T>, event: *mut IVectorChangedEventArgs) -> HRESULT
}}
impl<T: RtType> VectorChangedEventHandler<T> {
    #[inline] pub unsafe fn invoke(&self, sender: &IObservableVector<T>, event: &IVectorChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, event as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVectorView, 3152149068, 45283, 17795, 186, 239, 31, 27, 46, 72, 62, 86);
RT_INTERFACE!{interface IVectorView<T>(IVectorViewVtbl): IInspectable(IInspectableVtbl) [IID_IVectorView] {
    fn GetAt(&self, index: u32, out: *mut T::Abi) -> HRESULT,
    fn get_Size(&self, out: *mut u32) -> HRESULT,
    fn IndexOf(&self, value: T::Abi, index: *mut u32, out: *mut bool) -> HRESULT,
    fn GetMany(&self, startIndex: u32, itemsSize: u32, items: *mut T::Abi, out: *mut u32) -> HRESULT
}}
impl<T: RtType> IVectorView<T> {
    #[inline] pub unsafe fn get_at(&self, index: u32) -> Result<T::Out> {
        let mut out = T::uninitialized();
        let hr = ((*self.lpVtbl).GetAt)(self as *const _ as *mut _, index, &mut out);
        if hr == S_OK { Ok(T::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn index_of(&self, value: &T::In) -> Result<(u32, bool)> {
        let mut index = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).IndexOf)(self as *const _ as *mut _, T::unwrap(value), &mut index, &mut out);
        if hr == S_OK { Ok((index, out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_many(&self, startIndex: u32, items: &mut Vec<T::Out>) -> Result<()> {
        debug_assert!(items.capacity() > 0, "capacity of `items` must not be 0 (use Vec::with_capacity)"); items.clear();
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetMany)(self as *const _ as *mut _, startIndex, items.capacity() as u32, items.as_mut_ptr() as *mut T::Abi, &mut out);
        if hr == S_OK { items.set_len(out as usize); Ok(()) } else { err(hr) }
    }
}
RT_PINTERFACE!{ for IIterable<bool> => [0x30160817,0x1d7d,0x54e9,0x99,0xdb,0xd7,0x63,0x62,0x66,0xa4,0x76] as IID_IIterable_1_System_Boolean }
RT_PINTERFACE!{ for IIterable<f32> => [0xb01bee51,0x063a,0x5fda,0xbd,0x72,0xd7,0x66,0x37,0xbb,0x8c,0xb8] as IID_IIterable_1_System_Single }
RT_PINTERFACE!{ for IIterable<f64> => [0xc738964e,0x9c64,0x5bce,0xb5,0xce,0x61,0xe9,0xa2,0x82,0xec,0x4a] as IID_IIterable_1_System_Double }
RT_PINTERFACE!{ for IIterable<Guid> => [0xf4ca3045,0x5dd7,0x54be,0x98,0x2e,0xd8,0x8d,0x8c,0xa0,0x87,0x6e] as IID_IIterable_1_System_Guid }
RT_PINTERFACE!{ for IIterable<HString> => [0xe2fcc7c1,0x3bfc,0x5a0b,0xb2,0xb0,0x72,0xe7,0x69,0xd1,0xcb,0x7e] as IID_IIterable_1_System_String }
RT_PINTERFACE!{ for IIterable<i32> => [0x81a643fb,0xf51c,0x5565,0x83,0xc4,0xf9,0x64,0x25,0x77,0x7b,0x66] as IID_IIterable_1_System_Int32 }
RT_PINTERFACE!{ for IIterable<IInspectable> => [0x092b849b,0x60b1,0x52be,0xa4,0x4a,0x6f,0xe8,0xe9,0x33,0xcb,0xe4] as IID_IIterable_1_System_Object }
RT_PINTERFACE!{ for IIterable<IIterable<super::Point>> => [0xae44597e,0xd411,0x5b7f,0xbb,0xec,0x6a,0x96,0xc9,0x4a,0x10,0x7a] as IID_IIterable_1_Windows_Foundation_Collections_IIterable_1_Windows_Foundation_Point }
RT_PINTERFACE!{ for IIterable<IKeyValuePair<Guid, IInspectable>> => [0xf3b20528,0xe3b3,0x5331,0xb2,0xd0,0x0c,0x26,0x23,0xae,0xe7,0x85] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<Guid, super::super::applicationmodel::background::BackgroundTaskRegistration>> => [0x62ae0fda,0xb238,0x554f,0xa2,0x75,0x1d,0xc1,0x6d,0x6c,0xa0,0x3a] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_Windows_ApplicationModel_Background_BackgroundTaskRegistration }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<Guid, super::super::applicationmodel::background::IBackgroundTaskRegistration>> => [0x80fb0327,0x5a00,0x55cc,0x85,0xdb,0xa8,0x52,0x71,0x99,0x81,0xb9] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_Windows_ApplicationModel_Background_IBackgroundTaskRegistration }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<Guid, super::super::perception::spatial::surfaces::SpatialSurfaceInfo>> => [0x868757d1,0xbe21,0x51d9,0x8d,0xee,0xa9,0x58,0xb9,0xde,0xec,0x71] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_Windows_Perception_Spatial_Surfaces_SpatialSurfaceInfo }
RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, HString>> => [0xe9bdaaf0,0xcbf6,0x5c72,0xbe,0x90,0x29,0xcb,0xf3,0xa1,0x31,0x9b] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_System_String }
RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, IInspectable>> => [0xfe2f3d47,0x5d47,0x5499,0x83,0x74,0x43,0x0c,0x7c,0xda,0x02,0x04] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_System_Object }
RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, IVector<HString>>> => [0x4fed2669,0xd0d3,0x59f6,0x91,0xd9,0x95,0x90,0x2d,0x72,0x8d,0x6a] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Foundation_Collections_IVector_1_System_String }
RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, IVectorView<HString>>> => [0xa4cd6151,0x2cc1,0x56f1,0x90,0x14,0xdf,0x6b,0xa3,0x41,0x0b,0xeb] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Foundation_Collections_IVectorView_1_System_String }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, IVectorView<super::super::data::text::TextSegment>>> => [0xf819a276,0xb3f5,0x54d4,0xb8,0xfd,0xc9,0xad,0xb7,0xf7,0x00,0xe3] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Foundation_Collections_IVectorView_1_Windows_Data_Text_TextSegment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::background::BackgroundTaskRegistrationGroup>> => [0x04428524,0x7d54,0x59b4,0xbf,0x17,0xac,0x57,0xc4,0xce,0x6b,0x40] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Background_BackgroundTaskRegistrationGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::chat::ChatMessageStatus>> => [0x57d87c13,0x48e9,0x546f,0x9b,0x4e,0xa3,0x90,0x6e,0x1e,0x7c,0x24] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Chat_ChatMessageStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::resources::core::ResourceMap>> => [0x9895431e,0xa817,0x5509,0x91,0xe6,0xd9,0x0a,0x93,0x3e,0xd8,0x30] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Resources_Core_ResourceMap }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::store::licensemanagement::LicenseSatisfactionInfo>> => [0xac935021,0xe04b,0x5226,0x81,0x19,0x5b,0x73,0xd0,0xb8,0xbe,0x5b] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Store_LicenseManagement_LicenseSatisfactionInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::store::ProductLicense>> => [0xffe05002,0x6e65,0x5001,0xa7,0x52,0x9b,0x27,0xed,0x3e,0x28,0x39] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Store_ProductLicense }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::store::ProductListing>> => [0x3a7d9a2f,0x2a82,0x59f8,0xbd,0x7c,0xd6,0x91,0xca,0x16,0x98,0x63] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Store_ProductListing }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::voicecommands::VoiceCommandDefinition>> => [0x67693dd1,0xac45,0x5ef3,0x9b,0xa6,0x4d,0x78,0x70,0x9d,0x9e,0xe0] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_VoiceCommands_VoiceCommandDefinition }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletItemCustomProperty>> => [0x3f45154c,0x0c0d,0x5df9,0xa5,0x57,0x25,0x9f,0x20,0xc9,0x27,0xae] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletItemCustomProperty }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletRelevantLocation>> => [0xe55e510c,0x4028,0x5df0,0xb7,0x8b,0x27,0xbd,0x06,0x98,0x0b,0x0b] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletRelevantLocation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletTransaction>> => [0x4fd2ca58,0xb7a2,0x5923,0x93,0x80,0x49,0xc1,0x1c,0x69,0xc3,0x9a] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletTransaction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletVerb>> => [0x6d2ef172,0x8ae3,0x572e,0xae,0x44,0x8e,0xe3,0xfd,0x49,0xd1,0x9f] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletVerb }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::devices::bluetooth::background::GattServiceProviderConnection>> => [0xeb2cecfb,0xdd6c,0x5329,0x8e,0x17,0x7f,0xb8,0x0a,0x84,0x19,0x1f] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Devices_Bluetooth_Background_GattServiceProviderConnection }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::graphics::imaging::BitmapTypedValue>> => [0x05f9430c,0x2f22,0x5638,0xaa,0x89,0x8c,0x9a,0xbc,0xd5,0x4f,0xf9] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Graphics_Imaging_BitmapTypedValue }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::graphics::printing::optiondetails::IPrintOptionDetails>> => [0x6770cf39,0x094f,0x59c5,0x8a,0x5d,0xe3,0xb5,0xdc,0x64,0xdb,0x0f] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Graphics_Printing_OptionDetails_IPrintOptionDetails }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::media::capture::frames::MediaFrameSource>> => [0xa038e80f,0x0b3d,0x5cd4,0x84,0x9d,0x13,0x03,0x6e,0x1f,0x50,0x6e] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Media_Capture_Frames_MediaFrameSource }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::networking::sockets::SocketActivityInformation>> => [0x3e43fa16,0x7af1,0x51df,0xa0,0xd3,0xda,0x81,0xb3,0x21,0x63,0x9d] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Networking_Sockets_SocketActivityInformation }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::perception::spatial::SpatialAnchor>> => [0x55f0fa8a,0xafd4,0x5541,0xa1,0xc3,0x36,0xf1,0x21,0x47,0xd6,0x06] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Perception_Spatial_SpatialAnchor }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::services::store::StoreLicense>> => [0xca8ba445,0x6f4d,0x5da9,0x95,0xee,0x42,0xcf,0x11,0x8d,0xef,0x63] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Services_Store_StoreLicense }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::services::store::StoreProduct>> => [0x78a33722,0xabfb,0x57c0,0x85,0x3f,0x56,0x16,0xa3,0xab,0x8d,0x57] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Services_Store_StoreProduct }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::services::targetedcontent::TargetedContentValue>> => [0x45a020d8,0xfe49,0x5720,0x95,0x0b,0x3c,0xce,0xab,0x65,0x55,0x31] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Services_TargetedContent_TargetedContentValue }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::storage::ApplicationDataContainer>> => [0xa785be1d,0x159e,0x53ad,0x95,0x53,0x59,0x8b,0x03,0xdc,0xa0,0x48] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Storage_ApplicationDataContainer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::storage::streams::IBuffer>> => [0x3c9ffa92,0x5123,0x5ac4,0xb1,0x11,0x03,0xc2,0x15,0xf0,0xc5,0x1c] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Storage_Streams_IBuffer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<HString, super::super::storage::streams::RandomAccessStreamReference>> => [0xc9729ba7,0x5e20,0x569d,0xa3,0xd1,0x97,0xa4,0xe6,0x53,0xe5,0xbb] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Storage_Streams_RandomAccessStreamReference }
RT_PINTERFACE!{ for IIterable<IKeyValuePair<IInspectable, IInspectable>> => [0x33ac68f0,0x1084,0x529a,0x8a,0x17,0x4e,0x7c,0x8a,0xdb,0x7a,0x0c] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Object_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<super::super::devices::sensors::PedometerStepKind, super::super::devices::sensors::PedometerReading>> => [0x098f29cb,0xbc91,0x5639,0xa5,0x41,0xd5,0xa4,0x81,0x1e,0xc3,0x5b] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_Windows_Devices_Sensors_PedometerStepKind_Windows_Devices_Sensors_PedometerReading }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<IKeyValuePair<u32, super::super::storage::streams::IBuffer>> => [0x4fe7fe23,0x22b1,0x528c,0x88,0x1d,0xa4,0xec,0xea,0xef,0x0f,0x11] as IID_IIterable_1_Windows_Foundation_Collections_IKeyValuePair_2_System_UInt32_Windows_Storage_Streams_IBuffer }
RT_PINTERFACE!{ for IIterable<IMapView<HString, IInspectable>> => [0xe1670fae,0x49cd,0x5c47,0xa8,0xc8,0xf6,0xfa,0x2c,0x65,0x0c,0x6c] as IID_IIterable_1_Windows_Foundation_Collections_IMapView_2_System_String_System_Object }
RT_PINTERFACE!{ for IIterable<super::DateTime> => [0x576a207d,0x977c,0x5b36,0xb5,0x4d,0x62,0x4e,0xc8,0x6c,0x53,0xa3] as IID_IIterable_1_Windows_Foundation_DateTime }
RT_PINTERFACE!{ for IIterable<super::Point> => [0xc192280d,0x3a09,0x5423,0x9d,0xc5,0x67,0xb8,0x3e,0xbd,0xe4,0x1d] as IID_IIterable_1_Windows_Foundation_Point }
RT_PINTERFACE!{ for IIterable<super::Size> => [0xc9df55c3,0x4d41,0x5e90,0xba,0x76,0xe8,0x9e,0xd5,0x64,0x44,0x6b] as IID_IIterable_1_Windows_Foundation_Size }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::appextensions::AppExtension> => [0x3b4fe356,0x1b13,0x59cb,0xab,0x1f,0xc4,0x66,0x7a,0x74,0x75,0x6b] as IID_IIterable_1_Windows_ApplicationModel_AppExtensions_AppExtension }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::AppInfo> => [0x63d0bffe,0x0e34,0x55b3,0x83,0xd5,0x31,0x4c,0xaf,0xf2,0xb1,0x37] as IID_IIterable_1_Windows_ApplicationModel_AppInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::appointments::Appointment> => [0xb9802bba,0xff53,0x5d37,0x8c,0xd7,0xe5,0x61,0x62,0xf1,0x21,0x56] as IID_IIterable_1_Windows_ApplicationModel_Appointments_Appointment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::appointments::AppointmentCalendar> => [0xd3fb010b,0xb692,0x5130,0x9d,0x16,0x2c,0xfd,0xab,0xcb,0x6d,0xec] as IID_IIterable_1_Windows_ApplicationModel_Appointments_AppointmentCalendar }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::appointments::AppointmentException> => [0xcaac41d6,0x6c65,0x5fd8,0xb7,0x83,0xeb,0x9d,0x9a,0x42,0x72,0xb8] as IID_IIterable_1_Windows_ApplicationModel_Appointments_AppointmentException }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::appointments::AppointmentInvitee> => [0xfb9718a9,0xf059,0x52b0,0xa9,0x04,0x1a,0x65,0xe4,0x28,0x1e,0x40] as IID_IIterable_1_Windows_ApplicationModel_Appointments_AppointmentInvitee }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::appointments::AppointmentStoreChange> => [0x7b657ca2,0xe02e,0x5026,0xa0,0x32,0x99,0x05,0xe4,0x96,0x82,0xfd] as IID_IIterable_1_Windows_ApplicationModel_Appointments_AppointmentStoreChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::calls::PhoneCallHistoryEntry> => [0xa3f93eea,0xc846,0x52c7,0xaa,0x5a,0x33,0x06,0x70,0x7f,0x63,0x69] as IID_IIterable_1_Windows_ApplicationModel_Calls_PhoneCallHistoryEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::ChatConversation> => [0xaf43c676,0xa512,0x5388,0x9f,0x69,0x03,0x08,0x95,0x3d,0x71,0x9b] as IID_IIterable_1_Windows_ApplicationModel_Chat_ChatConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::ChatMessage> => [0x647bf12c,0xf621,0x5fd8,0xaf,0x39,0xc7,0x2b,0x16,0xba,0xf0,0x7e] as IID_IIterable_1_Windows_ApplicationModel_Chat_ChatMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::ChatMessageAttachment> => [0x8a1e36ac,0x13b6,0x577c,0x9b,0x43,0x3d,0x24,0xa4,0x53,0xf8,0x66] as IID_IIterable_1_Windows_ApplicationModel_Chat_ChatMessageAttachment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::ChatMessageChange> => [0x0df896df,0x354c,0x5d35,0xb7,0xac,0x6b,0x2e,0x1d,0x70,0xc8,0xeb] as IID_IIterable_1_Windows_ApplicationModel_Chat_ChatMessageChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::ChatMessageTransport> => [0xaae32f12,0xed85,0x528c,0x8b,0xad,0x63,0x62,0xd8,0x76,0xef,0x8b] as IID_IIterable_1_Windows_ApplicationModel_Chat_ChatMessageTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::ChatRecipientDeliveryInfo> => [0xe3d7b44c,0x4829,0x561b,0xa1,0x5e,0xa7,0x45,0xe5,0xad,0xf6,0xd1] as IID_IIterable_1_Windows_ApplicationModel_Chat_ChatRecipientDeliveryInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::IChatItem> => [0xea8e3309,0x099a,0x592e,0x9e,0x28,0x44,0x1b,0x15,0x1f,0xe0,0x61] as IID_IIterable_1_Windows_ApplicationModel_Chat_IChatItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::RcsEndUserMessageAction> => [0xb6d21a55,0x471e,0x5a25,0xac,0xdd,0x77,0x84,0xf7,0xb4,0xd7,0xba] as IID_IIterable_1_Windows_ApplicationModel_Chat_RcsEndUserMessageAction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::chat::RcsTransport> => [0x184c2264,0x65fd,0x5ad4,0xb2,0x2f,0xcb,0x34,0xe8,0xea,0xec,0x63] as IID_IIterable_1_Windows_ApplicationModel_Chat_RcsTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::Contact> => [0x63319996,0x7e0f,0x552e,0x87,0x2b,0x7b,0x9a,0xdb,0x1f,0x49,0x97] as IID_IIterable_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactAddress> => [0xe783287c,0xe920,0x5540,0x91,0x82,0xc1,0xa6,0xa5,0xf2,0xad,0x36] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactAddress }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactAnnotation> => [0xea7fc05e,0xfe09,0x5690,0xa7,0x0b,0xa1,0x48,0x67,0x04,0x0f,0xa5] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactAnnotation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactAnnotationList> => [0xae095a89,0x8b8b,0x5b8a,0x8f,0x28,0x55,0x5a,0xa4,0x90,0xad,0x87] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactAnnotationList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactChange> => [0xf761174c,0x1f89,0x5796,0x9d,0x09,0x7f,0xee,0x08,0x13,0x70,0x4d] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactConnectedServiceAccount> => [0x35e203b2,0x5138,0x5967,0x80,0xfa,0xa4,0x77,0xed,0x4c,0x7d,0xdc] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactConnectedServiceAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactDate> => [0x96045d0b,0xb38b,0x5d91,0x83,0x11,0x4f,0xbc,0x7a,0xd4,0x33,0x7d] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactDate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactEmail> => [0x37d0d55f,0xe136,0x5b07,0x8a,0x3a,0x81,0x10,0xbd,0xe3,0x39,0x17] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactEmail }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactField> => [0x3b012111,0xc82b,0x541e,0xa0,0xc1,0x37,0x71,0x3e,0xd8,0x35,0x41] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactFieldType> => [0x384b8b1b,0xce8e,0x5781,0xb3,0xdc,0x07,0x76,0xd6,0x84,0xf6,0x58] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactFieldType }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactGroup> => [0x9db1688a,0xf7e0,0x5059,0x98,0x9e,0xd1,0x45,0x30,0x56,0xd7,0x3a] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactInformation> => [0x352762af,0x17e3,0x55e0,0x8b,0xe1,0x6a,0x59,0x8a,0x44,0xb5,0xb4] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactInstantMessageField> => [0x810533b2,0x28bb,0x5ed3,0xac,0x19,0xfe,0xc8,0x05,0x9d,0x7b,0x3c] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactInstantMessageField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactJobInfo> => [0x17c1cead,0x56a3,0x5d93,0xab,0xf2,0x14,0xd3,0x4d,0x4b,0x93,0x56] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactJobInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactList> => [0xf9b0782c,0xbfe9,0x564e,0xbc,0xa2,0x97,0x23,0x5f,0xd6,0x44,0x63] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactLocationField> => [0x2a0a41a6,0xda96,0x50a5,0xb8,0xdf,0xe4,0xa8,0xc4,0xfc,0xf8,0x6b] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactLocationField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactMatchReason> => [0x0a8c1bd9,0x2402,0x5c98,0xbe,0x6e,0x63,0xa4,0x80,0x80,0x47,0xba] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactMatchReason }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactPhone> => [0x4abd089c,0x49a1,0x5ba9,0x80,0xdf,0x53,0xb7,0x2d,0xd6,0x91,0xce] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactPhone }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactSignificantOther> => [0xae12bd35,0x93d6,0x53d8,0x87,0xc0,0x49,0xd8,0x4c,0x5c,0x6a,0x83] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactSignificantOther }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::ContactWebsite> => [0x4b03c203,0x989e,0x5b97,0x8f,0xcb,0x67,0xd6,0x61,0xde,0xfe,0x76] as IID_IIterable_1_Windows_ApplicationModel_Contacts_ContactWebsite }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::contacts::IContactField> => [0xe065edc5,0x1d23,0x5be5,0x99,0x98,0x27,0x36,0xcd,0x4d,0x52,0x97] as IID_IIterable_1_Windows_ApplicationModel_Contacts_IContactField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::core::AppListEntry> => [0x86f4d4ef,0xd8fd,0x5fb5,0x80,0x7c,0x72,0xda,0x8f,0xc9,0xe5,0x44] as IID_IIterable_1_Windows_ApplicationModel_Core_AppListEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::core::CoreApplicationView> => [0x32bc12d1,0x2653,0x5a41,0xa5,0x5e,0x88,0xa1,0x2a,0xf2,0x02,0x6a] as IID_IIterable_1_Windows_ApplicationModel_Core_CoreApplicationView }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::datatransfer::ShareProvider> => [0x0903b218,0x5cad,0x53e6,0x9a,0x21,0x6f,0x4b,0x31,0xc4,0xa4,0x09] as IID_IIterable_1_Windows_ApplicationModel_DataTransfer_ShareProvider }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailAttachment> => [0xa5ab00e4,0x0ed7,0x52ee,0xaa,0xcb,0x83,0xd8,0x40,0xd6,0xf8,0xfa] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailAttachment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailCertificateValidationStatus> => [0x7e326530,0x7449,0x51a7,0xb1,0xbc,0xc4,0x35,0x33,0xa7,0x8e,0x06] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailCertificateValidationStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailConversation> => [0xd495f8dc,0x4327,0x5bca,0xa5,0x06,0x44,0xb1,0x72,0xd6,0xd4,0x35] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailFolder> => [0x6dcb53eb,0x8a35,0x54bf,0x8c,0x8e,0x44,0x9b,0xce,0x9b,0x39,0x20] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailFolder }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailMailbox> => [0x8fc76b2e,0xf800,0x5f1d,0xa0,0x23,0xde,0x47,0xe5,0xf3,0x06,0xe0] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailMailbox }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailMailboxAction> => [0x26419311,0x1cd7,0x5bab,0x9c,0x4a,0xe9,0x58,0x84,0xd5,0x53,0x9c] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailMailboxAction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailMailboxChange> => [0x4630ccb6,0xdfce,0x57dc,0xa5,0xd1,0x28,0xb8,0x89,0xc2,0xc2,0xb7] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailMailboxChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailMessage> => [0xa5fac823,0x8e6d,0x5bbe,0xad,0x16,0x83,0x50,0xae,0xa4,0x46,0xe0] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailRecipient> => [0x5f18cab2,0x236d,0x5ec5,0xbc,0x64,0xe3,0xe6,0x3d,0x29,0xe7,0x74] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailRecipient }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::email::EmailRecipientResolutionResult> => [0xcae3c1c4,0xc689,0x5787,0x97,0x6f,0x1a,0x15,0x8f,0xfd,0xd1,0x6b] as IID_IIterable_1_Windows_ApplicationModel_Email_EmailRecipientResolutionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::lockscreen::LockScreenBadge> => [0x6e82dedc,0xb74e,0x503a,0xb0,0x0b,0x9c,0x6f,0x47,0xf1,0x2a,0x0f] as IID_IIterable_1_Windows_ApplicationModel_LockScreen_LockScreenBadge }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::Package> => [0x69ad6aa7,0x0c49,0x5f27,0xa5,0xeb,0xef,0x4d,0x59,0x46,0x7b,0x6d] as IID_IIterable_1_Windows_ApplicationModel_Package }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::PackageContentGroup> => [0xd7dd1456,0x4805,0x5768,0xa2,0x5d,0x99,0x64,0x1b,0x09,0x64,0x91] as IID_IIterable_1_Windows_ApplicationModel_PackageContentGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::payments::PaymentDetailsModifier> => [0x585d2b3d,0xcb34,0x58c4,0x81,0xf4,0x1e,0xa1,0x57,0x99,0x6d,0xef] as IID_IIterable_1_Windows_ApplicationModel_Payments_PaymentDetailsModifier }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::payments::PaymentItem> => [0xb61b704c,0xe5fa,0x5524,0x8b,0x95,0x7d,0x03,0xf5,0xd3,0x6a,0xe9] as IID_IIterable_1_Windows_ApplicationModel_Payments_PaymentItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::payments::PaymentMethodData> => [0x8c9ed87e,0x4add,0x58a8,0xad,0x9a,0x9d,0xfa,0x48,0xca,0x25,0x0a] as IID_IIterable_1_Windows_ApplicationModel_Payments_PaymentMethodData }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::payments::PaymentShippingOption> => [0xde881c69,0x6642,0x54de,0xa8,0xf7,0xd1,0xa8,0x8b,0x24,0x04,0xcf] as IID_IIterable_1_Windows_ApplicationModel_Payments_PaymentShippingOption }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::resources::core::NamedResource> => [0xe80d3d9d,0x96c9,0x579e,0x8e,0x42,0xd5,0x50,0x70,0x0d,0xe9,0x25] as IID_IIterable_1_Windows_ApplicationModel_Resources_Core_NamedResource }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::resources::core::ResourceCandidate> => [0xd89c9498,0x8869,0x57f8,0xa8,0x83,0x9c,0x2d,0xfe,0xec,0xb6,0xc6] as IID_IIterable_1_Windows_ApplicationModel_Resources_Core_ResourceCandidate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::resources::core::ResourceMap> => [0x8bbe1154,0x19aa,0x53e7,0x9d,0x6e,0xdc,0x7d,0x35,0x85,0x80,0xf4] as IID_IIterable_1_Windows_ApplicationModel_Resources_Core_ResourceMap }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::resources::core::ResourceQualifier> => [0x2eee68e2,0x687c,0x5f7a,0xa1,0x4e,0x58,0x8c,0x4d,0x30,0x89,0xe1] as IID_IIterable_1_Windows_ApplicationModel_Resources_Core_ResourceQualifier }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::resources::management::IndexedResourceCandidate> => [0x0fcb4184,0x1489,0x5774,0x99,0x10,0xba,0xb3,0x26,0xbb,0x50,0xf6] as IID_IIterable_1_Windows_ApplicationModel_Resources_Management_IndexedResourceCandidate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::resources::management::IndexedResourceQualifier> => [0xe16e0455,0x7341,0x55c0,0xa0,0x24,0x26,0xd9,0xad,0x43,0xc8,0xcc] as IID_IIterable_1_Windows_ApplicationModel_Resources_Management_IndexedResourceQualifier }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::search::core::SearchSuggestion> => [0xdf956160,0xf155,0x5816,0xb3,0x8b,0xa2,0xff,0x06,0x29,0xba,0x0e] as IID_IIterable_1_Windows_ApplicationModel_Search_Core_SearchSuggestion }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::socialinfo::SocialFeedItem> => [0xad33d864,0x9569,0x5e2d,0xbd,0x72,0x18,0x2a,0x8f,0xf5,0x0c,0xf6] as IID_IIterable_1_Windows_ApplicationModel_SocialInfo_SocialFeedItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::socialinfo::SocialItemThumbnail> => [0x5d102c6d,0x92c3,0x59f3,0xb1,0xdc,0x59,0x86,0xc5,0x64,0x45,0xa5] as IID_IIterable_1_Windows_ApplicationModel_SocialInfo_SocialItemThumbnail }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::StartupTask> => [0x61885ead,0xbf9e,0x5e9f,0xaf,0x04,0x62,0x96,0xb3,0x36,0x93,0x0b] as IID_IIterable_1_Windows_ApplicationModel_StartupTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::store::preview::installcontrol::AppInstallItem> => [0x93e1cdc8,0x503f,0x55b1,0x91,0x5b,0xc0,0xdc,0x78,0x88,0xce,0x31] as IID_IIterable_1_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::store::preview::StorePreviewProductInfo> => [0xa9cb4860,0x67d1,0x53c2,0xa6,0x21,0x30,0x74,0xb0,0x34,0x4d,0x49] as IID_IIterable_1_Windows_ApplicationModel_Store_Preview_StorePreviewProductInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::store::preview::StorePreviewSkuInfo> => [0x2c0d85d9,0x0df7,0x5de6,0x96,0x2e,0xbc,0x8f,0x14,0x9f,0xaf,0x19] as IID_IIterable_1_Windows_ApplicationModel_Store_Preview_StorePreviewSkuInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::store::preview::StoreSystemFeature> => [0x98a8577a,0xb128,0x5400,0x8d,0x3d,0x58,0x65,0x4e,0xaa,0xf9,0x57] as IID_IIterable_1_Windows_ApplicationModel_Store_Preview_StoreSystemFeature }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::store::UnfulfilledConsumable> => [0x2f4d1483,0xdd86,0x5fdb,0x8c,0x44,0x06,0xc9,0x88,0x44,0xbf,0x3d] as IID_IIterable_1_Windows_ApplicationModel_Store_UnfulfilledConsumable }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::userdataaccounts::provider::UserDataAccountPartnerAccountInfo> => [0x5cdb425e,0xda5a,0x55fa,0xb3,0x49,0x54,0x67,0x99,0x6c,0xab,0x32] as IID_IIterable_1_Windows_ApplicationModel_UserDataAccounts_Provider_UserDataAccountPartnerAccountInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::userdataaccounts::systemaccess::DeviceAccountConfiguration> => [0xa9c3ea6e,0x9dd9,0x52fe,0x9d,0x27,0xf9,0xe4,0xde,0xdd,0x4d,0x3f] as IID_IIterable_1_Windows_ApplicationModel_UserDataAccounts_SystemAccess_DeviceAccountConfiguration }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::userdataaccounts::UserDataAccount> => [0x1bc7f1ff,0x26b4,0x5440,0x96,0x29,0xcb,0x4c,0xd8,0xc8,0x79,0x87] as IID_IIterable_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::userdatatasks::UserDataTask> => [0x8ae8becd,0x375f,0x5932,0x91,0xed,0xf8,0x2a,0x74,0x22,0x43,0x65] as IID_IIterable_1_Windows_ApplicationModel_UserDataTasks_UserDataTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::userdatatasks::UserDataTaskList> => [0x2c4d63bc,0xcffb,0x50d2,0x8a,0x82,0xa9,0xae,0xfa,0xd6,0x51,0xd3] as IID_IIterable_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::voicecommands::VoiceCommandContentTile> => [0xbd13249b,0x8099,0x5573,0xbf,0x74,0x74,0x57,0x79,0x6e,0x92,0xe5] as IID_IIterable_1_Windows_ApplicationModel_VoiceCommands_VoiceCommandContentTile }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterable<super::super::applicationmodel::wallet::WalletItem> => [0xac174c8c,0x0fdd,0x5cff,0xa2,0x9f,0x4e,0x8c,0xe1,0xc8,0xbc,0x81] as IID_IIterable_1_Windows_ApplicationModel_Wallet_WalletItem }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterable<super::super::data::text::AlternateWordForm> => [0xae838c29,0x60c1,0x5093,0xae,0x61,0x0e,0xd2,0x28,0x57,0xdb,0x05] as IID_IIterable_1_Windows_Data_Text_AlternateWordForm }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterable<super::super::data::text::SelectableWordSegment> => [0x784b0cec,0x1348,0x5334,0x91,0xe5,0x2e,0x01,0x32,0x94,0xe2,0x11] as IID_IIterable_1_Windows_Data_Text_SelectableWordSegment }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterable<super::super::data::text::TextPhoneme> => [0x2017f561,0x8162,0x55f8,0xb0,0x56,0x65,0x66,0x36,0x93,0x58,0x15] as IID_IIterable_1_Windows_Data_Text_TextPhoneme }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterable<super::super::data::text::TextSegment> => [0x5498f4f3,0xcee4,0x5b72,0x97,0x29,0x81,0x5c,0x4a,0xd7,0xb9,0xdc] as IID_IIterable_1_Windows_Data_Text_TextSegment }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterable<super::super::data::text::WordSegment> => [0xd14dc94a,0xa311,0x5ddc,0xbf,0x8b,0xd5,0x87,0x95,0xd8,0x7d,0x6d] as IID_IIterable_1_Windows_Data_Text_WordSegment }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::adc::AdcController> => [0x4e478aad,0x4861,0x5758,0xb6,0x4b,0x5b,0x4f,0x28,0xd8,0xf8,0x6e] as IID_IIterable_1_Windows_Devices_Adc_AdcController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::adc::provider::IAdcControllerProvider> => [0x30047155,0x1f71,0x5223,0x84,0x82,0xe5,0x15,0x9d,0x01,0x37,0xd0] as IID_IIterable_1_Windows_Devices_Adc_Provider_IAdcControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::alljoyn::AllJoynAuthenticationMechanism> => [0xd307c7af,0x4106,0x5d1c,0xb0,0x6c,0x5e,0xb5,0x93,0xd9,0xbe,0x34] as IID_IIterable_1_Windows_Devices_AllJoyn_AllJoynAuthenticationMechanism }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementBytePattern> => [0x1e3fadee,0x54ac,0x538b,0x87,0x77,0x35,0x1a,0xfb,0x78,0xcb,0x74] as IID_IIterable_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementBytePattern }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementDataSection> => [0xdb98b5d1,0x897e,0x59cc,0xb8,0x6a,0x7b,0x88,0x55,0xac,0x98,0xaf] as IID_IIterable_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementDataSection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementReceivedEventArgs> => [0x34f6412f,0x8314,0x5205,0x96,0x7c,0xdb,0x35,0x7c,0x9a,0x42,0xa7] as IID_IIterable_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::advertisement::BluetoothLEManufacturerData> => [0x834a4cac,0xbb8b,0x5f0f,0x9f,0x28,0x4d,0xbc,0x98,0xc1,0x79,0x07] as IID_IIterable_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEManufacturerData }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic> => [0xe3c56728,0x7f2d,0x5a0d,0xad,0x38,0x03,0x0d,0x39,0xc6,0x0f,0x9f] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCharacteristic }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattClientNotificationResult> => [0xd3f4b8ad,0x251f,0x5bbb,0xad,0xa2,0xea,0x47,0x43,0x4e,0x74,0xd6] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattClientNotificationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattDescriptor> => [0x30e2ffc4,0x3aa3,0x5219,0x9a,0x18,0xca,0x2d,0x0b,0x65,0x62,0xe8] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattDeviceService> => [0x4b192e23,0x4893,0x56b2,0x8e,0xff,0x43,0x9c,0x3a,0xb7,0xfd,0x1f] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristic> => [0x7082ed53,0x37f6,0x5262,0x8d,0x09,0x93,0x9b,0xea,0x9e,0xdb,0xd5] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristic }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattLocalDescriptor> => [0x9016e9a2,0xc9f7,0x5d09,0xb0,0xae,0x55,0x2f,0xa6,0x77,0x96,0xae] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattPresentationFormat> => [0xd75fcef1,0xc10e,0x5b7b,0xb1,0x30,0xf5,0xa0,0x03,0x14,0xd3,0x5d] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattPresentationFormat }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattSubscribedClient> => [0xb19864e4,0xf2b1,0x50de,0x8c,0x11,0xff,0xf9,0xec,0xa9,0x34,0xe9] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSubscribedClient }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::genericattributeprofile::GattValueChangedEventArgs> => [0x526a63df,0x8827,0x51b9,0x9e,0x2c,0x9d,0x65,0x02,0x1a,0x79,0xd7] as IID_IIterable_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattValueChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::bluetooth::rfcomm::RfcommDeviceService> => [0x3378e9a6,0xf6e2,0x50ea,0xbf,0xee,0xb8,0x10,0x96,0x31,0xfe,0xca] as IID_IIterable_1_Windows_Devices_Bluetooth_Rfcomm_RfcommDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::enumeration::DeviceClass> => [0x47d4be05,0x58f1,0x522e,0x81,0xc6,0x97,0x5e,0xb4,0x13,0x1b,0xb9] as IID_IIterable_1_Windows_Devices_Enumeration_DeviceClass }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::enumeration::DeviceInformation> => [0xdd9f8a5d,0xec98,0x5f4b,0xa3,0xea,0x9c,0x8b,0x5a,0xd5,0x3c,0x4b] as IID_IIterable_1_Windows_Devices_Enumeration_DeviceInformation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::enumeration::DeviceWatcherEvent> => [0xb48fd051,0xeafa,0x523f,0xa6,0x6e,0x9d,0x41,0x51,0xc5,0xd5,0x22] as IID_IIterable_1_Windows_Devices_Enumeration_DeviceWatcherEvent }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::enumeration::DeviceWatcherEventKind> => [0xf04365ab,0xd3f3,0x5f85,0xa7,0xda,0xdc,0x19,0xcf,0xf7,0x3d,0x86] as IID_IIterable_1_Windows_Devices_Enumeration_DeviceWatcherEventKind }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::enumeration::pnp::PnpObject> => [0x30b50092,0x36ee,0x53ff,0x94,0x50,0x02,0x90,0x04,0x43,0x6c,0x60] as IID_IIterable_1_Windows_Devices_Enumeration_Pnp_PnpObject }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::BasicGeoposition> => [0x922399a8,0x0093,0x5009,0xa8,0xd2,0xf8,0x7b,0x0e,0xae,0x75,0xf5] as IID_IIterable_1_Windows_Devices_Geolocation_BasicGeoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::geofencing::Geofence> => [0xce697733,0x595c,0x51c0,0xad,0x5f,0x32,0x4a,0xf5,0xcd,0xf2,0xdd] as IID_IIterable_1_Windows_Devices_Geolocation_Geofencing_Geofence }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::geofencing::GeofenceStateChangeReport> => [0x76f50b4e,0x7aa7,0x565b,0xaa,0xda,0xb0,0xc1,0xcc,0x14,0x4e,0xd0] as IID_IIterable_1_Windows_Devices_Geolocation_Geofencing_GeofenceStateChangeReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::Geopath> => [0x246fcfbd,0xa881,0x5e8e,0x99,0x08,0xc1,0xb9,0xeb,0xdf,0xec,0x78] as IID_IIterable_1_Windows_Devices_Geolocation_Geopath }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::Geopoint> => [0xe7617fc9,0x2cc7,0x5bd1,0xbc,0x5a,0xf4,0x72,0x60,0x83,0x4e,0xd8] as IID_IIterable_1_Windows_Devices_Geolocation_Geopoint }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::Geoposition> => [0x135ed72d,0x75b1,0x5881,0xbe,0x41,0x6f,0xfe,0xaa,0x20,0x20,0x44] as IID_IIterable_1_Windows_Devices_Geolocation_Geoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::geolocation::Geovisit> => [0xd5800189,0x0f3f,0x54a0,0xa7,0x49,0x60,0x00,0xc1,0xe1,0x2e,0x58] as IID_IIterable_1_Windows_Devices_Geolocation_Geovisit }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::gpio::GpioChangeRecord> => [0xb4afbf4f,0x620e,0x5725,0x87,0x8a,0x78,0xc6,0xed,0x10,0x37,0x4e] as IID_IIterable_1_Windows_Devices_Gpio_GpioChangeRecord }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::gpio::GpioController> => [0x415c3794,0xb2b6,0x5f5c,0x9a,0x05,0xae,0x92,0x68,0x51,0x47,0x26] as IID_IIterable_1_Windows_Devices_Gpio_GpioController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::gpio::provider::IGpioControllerProvider> => [0x09212bd4,0x851b,0x52bd,0xb8,0x2c,0x42,0x1b,0xf3,0xd6,0xf5,0x11] as IID_IIterable_1_Windows_Devices_Gpio_Provider_IGpioControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::haptics::SimpleHapticsController> => [0xb50da692,0x4a2b,0x5c8a,0x8e,0x14,0x04,0x39,0xc0,0xb1,0xdb,0xa4] as IID_IIterable_1_Windows_Devices_Haptics_SimpleHapticsController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::haptics::SimpleHapticsControllerFeedback> => [0x8894a0df,0x33b0,0x57b0,0xaa,0x1a,0x92,0x55,0xee,0xe7,0x2d,0xd5] as IID_IIterable_1_Windows_Devices_Haptics_SimpleHapticsControllerFeedback }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::haptics::VibrationDevice> => [0x1a40c994,0x8810,0x5688,0x93,0x62,0xc4,0xbb,0x51,0x01,0x85,0x52] as IID_IIterable_1_Windows_Devices_Haptics_VibrationDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::humaninterfacedevice::HidBooleanControl> => [0x1111e585,0x5ab0,0x5d2b,0x8a,0xed,0xb6,0xd6,0x18,0x6d,0x1c,0x3f] as IID_IIterable_1_Windows_Devices_HumanInterfaceDevice_HidBooleanControl }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::humaninterfacedevice::HidBooleanControlDescription> => [0xd0ff0fed,0xa156,0x58bf,0x94,0x11,0x57,0x77,0xdf,0x9d,0x57,0xbf] as IID_IIterable_1_Windows_Devices_HumanInterfaceDevice_HidBooleanControlDescription }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::humaninterfacedevice::HidCollection> => [0xbbeada0f,0x708f,0x5b5e,0xa0,0x17,0x5c,0x64,0xff,0xb9,0x6b,0x69] as IID_IIterable_1_Windows_Devices_HumanInterfaceDevice_HidCollection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::humaninterfacedevice::HidNumericControlDescription> => [0x868f060d,0xe0d4,0x571b,0xb2,0xf7,0x43,0x1d,0x69,0x84,0xa5,0x13] as IID_IIterable_1_Windows_Devices_HumanInterfaceDevice_HidNumericControlDescription }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::i2c::I2cController> => [0xa5ee8233,0x2429,0x5b26,0x9a,0x02,0x99,0x3e,0x4e,0x7e,0xdf,0xa9] as IID_IIterable_1_Windows_Devices_I2c_I2cController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::i2c::provider::II2cControllerProvider> => [0x11341a6c,0x3a02,0x5f73,0x9d,0xb8,0xc3,0xec,0x58,0x23,0xe3,0x5d] as IID_IIterable_1_Windows_Devices_I2c_Provider_II2cControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::input::PointerDevice> => [0xad26662c,0x845b,0x5c6d,0xae,0xaa,0x40,0x6f,0x48,0xc2,0x1a,0xe9] as IID_IIterable_1_Windows_Devices_Input_PointerDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::input::PointerDeviceUsage> => [0x592d6618,0xeaab,0x5a79,0xa4,0x7a,0xc7,0xfc,0x0b,0x74,0x9a,0x4e] as IID_IIterable_1_Windows_Devices_Input_PointerDeviceUsage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::perception::PerceptionColorFrameSource> => [0xdb18069e,0x7b5a,0x54c3,0xa6,0x27,0xd5,0x6f,0x95,0x17,0xfd,0xf5] as IID_IIterable_1_Windows_Devices_Perception_PerceptionColorFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::perception::PerceptionDepthFrameSource> => [0x8a07e1e8,0x5a02,0x585b,0xa2,0x6e,0xad,0x79,0xbe,0xaa,0x94,0xcf] as IID_IIterable_1_Windows_Devices_Perception_PerceptionDepthFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::perception::PerceptionInfraredFrameSource> => [0x9309d0db,0x338d,0x5adf,0x8b,0x3e,0x50,0x9b,0xfd,0xfc,0xce,0xf3] as IID_IIterable_1_Windows_Devices_Perception_PerceptionInfraredFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::perception::PerceptionVideoProfile> => [0xf6aea351,0xeb9b,0x564d,0xb1,0x0a,0x06,0x67,0x30,0x94,0xac,0xc8] as IID_IIterable_1_Windows_Devices_Perception_PerceptionVideoProfile }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::perception::provider::PerceptionCorrelation> => [0xca6bf87e,0x1745,0x5cd0,0xae,0xe2,0x59,0x73,0x6f,0x5a,0x20,0x6d] as IID_IIterable_1_Windows_Devices_Perception_Provider_PerceptionCorrelation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::pointofservice::PosPrinterRotation> => [0x1b1e4d8d,0x15f5,0x5802,0x9b,0x23,0x8b,0x75,0xce,0x2a,0x58,0xc5] as IID_IIterable_1_Windows_Devices_PointOfService_PosPrinterRotation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::pwm::provider::IPwmControllerProvider> => [0x4936ed59,0xb494,0x5128,0xbc,0x7e,0x03,0xe6,0x30,0x34,0x64,0x75] as IID_IIterable_1_Windows_Devices_Pwm_Provider_IPwmControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::pwm::PwmController> => [0x1403a6ab,0x73cb,0x5805,0x9b,0xbc,0xa0,0xdd,0x39,0xd4,0x76,0xb0] as IID_IIterable_1_Windows_Devices_Pwm_PwmController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::radios::Radio> => [0xe82500af,0x1f53,0x504e,0xb8,0xbe,0xda,0xc4,0xfb,0xb6,0x90,0x84] as IID_IIterable_1_Windows_Devices_Radios_Radio }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sensors::ActivitySensorReading> => [0x9a34ce03,0x8c6d,0x5994,0x90,0x7f,0xd5,0xc2,0xd1,0x91,0x48,0xcb] as IID_IIterable_1_Windows_Devices_Sensors_ActivitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sensors::ActivitySensorReadingChangeReport> => [0x551a4962,0x9e96,0x5e6b,0x8b,0x8a,0x65,0xee,0x3d,0x00,0x46,0xf3] as IID_IIterable_1_Windows_Devices_Sensors_ActivitySensorReadingChangeReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sensors::ActivityType> => [0x2a04cdfa,0x5dfd,0x5178,0x87,0x31,0xad,0xe9,0x98,0xe4,0xa7,0xf6] as IID_IIterable_1_Windows_Devices_Sensors_ActivityType }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sensors::PedometerReading> => [0xbbb61a5c,0x98c3,0x5718,0x88,0xfe,0x53,0x92,0xa7,0x45,0x1e,0x2d] as IID_IIterable_1_Windows_Devices_Sensors_PedometerReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sensors::ProximitySensorReading> => [0x301ebccf,0x11ab,0x5e90,0x98,0xee,0xbd,0x99,0xc0,0xe3,0xbb,0x76] as IID_IIterable_1_Windows_Devices_Sensors_ProximitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCard> => [0xa32c5202,0xd113,0x535f,0x88,0x0e,0x50,0xf3,0xe5,0x12,0x1e,0xf8] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCard }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardAppletIdGroupRegistration> => [0x4d153aad,0x915c,0x59c9,0x98,0xb9,0xa9,0x7b,0xf3,0xa5,0x70,0xad] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardAppletIdGroupRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardAutomaticResponseApdu> => [0xdb52d376,0x027e,0x5270,0xa4,0x57,0xfb,0x8b,0x4a,0xe8,0x95,0x8c] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardAutomaticResponseApdu }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramAlgorithm> => [0x8e0de0e9,0x0742,0x559e,0x9b,0x1b,0x46,0x02,0x68,0x62,0x2c,0x1f] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramAlgorithm }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramMaterialCharacteristics> => [0x92058349,0xb443,0x52d8,0x8e,0x46,0x9c,0xf3,0x81,0x5d,0xd1,0x5a] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialCharacteristics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramMaterialPackageCharacteristics> => [0xab1dac61,0x1bd9,0x54a6,0xb4,0x07,0x1d,0xc4,0xe5,0xb1,0xa1,0x97] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPackageCharacteristics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramMaterialPackageConfirmationResponseFormat> => [0xc40c4451,0x4ebb,0x5635,0x9c,0x7d,0x33,0xc8,0xc5,0xd3,0x7a,0x09] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPackageConfirmationResponseFormat }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramMaterialPackageFormat> => [0x3e241acc,0x1745,0x57ce,0x93,0x68,0x21,0xba,0x21,0x30,0xc3,0xc1] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPackageFormat }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramMaterialType> => [0x2d379f84,0x389c,0x5809,0xa2,0xc6,0x91,0x9b,0x47,0xca,0xab,0x88] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialType }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramPlacementStep> => [0x234ab631,0xed5f,0x51bc,0x8a,0x8a,0xd5,0xf3,0x49,0x5f,0x32,0xde] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramPlacementStep }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramStorageKeyCapabilities> => [0x983619f1,0x45b9,0x5557,0x98,0x00,0xea,0xa2,0xbc,0xa6,0xda,0x57] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramStorageKeyCapabilities }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::smartcards::SmartCardCryptogramStorageKeyCharacteristics> => [0x16d5cc89,0x2f6a,0x5779,0x8e,0xf8,0x2d,0x5a,0x20,0x07,0x81,0x50] as IID_IIterable_1_Windows_Devices_SmartCards_SmartCardCryptogramStorageKeyCharacteristics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sms::ISmsBinaryMessage> => [0x5678a6a5,0x4d5a,0x51c2,0xa1,0x33,0x4b,0x83,0xbf,0x25,0xd9,0x87] as IID_IIterable_1_Windows_Devices_Sms_ISmsBinaryMessage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sms::ISmsMessage> => [0xecabfd70,0x9601,0x5e38,0x83,0xcf,0xb1,0x04,0x60,0x22,0xa2,0x44] as IID_IIterable_1_Windows_Devices_Sms_ISmsMessage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sms::SmsBroadcastType> => [0x12276b75,0x173e,0x514b,0x98,0xf0,0x8a,0x79,0x27,0xa9,0x20,0x6c] as IID_IIterable_1_Windows_Devices_Sms_SmsBroadcastType }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sms::SmsFilterRule> => [0x03ed8267,0x9c90,0x5260,0x8b,0xc0,0x6c,0x3e,0x33,0x06,0xc9,0x64] as IID_IIterable_1_Windows_Devices_Sms_SmsFilterRule }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::sms::SmsMessageRegistration> => [0xf836fa0a,0x770d,0x5e8f,0x86,0x64,0x01,0xc4,0x3f,0x95,0x9e,0xea] as IID_IIterable_1_Windows_Devices_Sms_SmsMessageRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::spi::provider::ISpiControllerProvider> => [0x71ba027d,0x8c84,0x58b1,0x8d,0x66,0x91,0x77,0xc1,0x16,0x98,0xeb] as IID_IIterable_1_Windows_Devices_Spi_Provider_ISpiControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::spi::SpiController> => [0x7b076938,0xdc1b,0x5368,0x90,0x03,0x05,0x92,0x91,0xd3,0x7f,0x35] as IID_IIterable_1_Windows_Devices_Spi_SpiController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbBulkInEndpointDescriptor> => [0x101b1fd9,0xf1c9,0x5dda,0x9a,0xd4,0x71,0x17,0x6f,0xa8,0x39,0xb2] as IID_IIterable_1_Windows_Devices_Usb_UsbBulkInEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbBulkInPipe> => [0x2201a671,0x42d2,0x508d,0xa8,0x48,0x64,0xb5,0x44,0x70,0x83,0xc8] as IID_IIterable_1_Windows_Devices_Usb_UsbBulkInPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbBulkOutEndpointDescriptor> => [0xb80beb39,0x62b3,0x5f59,0xb3,0xe7,0x88,0x2c,0xc9,0xc5,0xb0,0xc0] as IID_IIterable_1_Windows_Devices_Usb_UsbBulkOutEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbBulkOutPipe> => [0x9824caba,0x5ca6,0x5c2d,0x80,0xcf,0x19,0x49,0x02,0x6d,0x78,0x57] as IID_IIterable_1_Windows_Devices_Usb_UsbBulkOutPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbDescriptor> => [0x989909a5,0x5a03,0x51fb,0xbd,0x94,0x84,0xda,0x7b,0xda,0x88,0x19] as IID_IIterable_1_Windows_Devices_Usb_UsbDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbInterface> => [0xf54037ed,0x92e9,0x590d,0xb9,0x04,0x3a,0xd7,0xbf,0xa9,0xa6,0x21] as IID_IIterable_1_Windows_Devices_Usb_UsbInterface }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbInterfaceSetting> => [0x1aaf5739,0x9c2c,0x533e,0xa0,0xe9,0xd5,0x3f,0xdb,0x45,0xd1,0x5d] as IID_IIterable_1_Windows_Devices_Usb_UsbInterfaceSetting }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbInterruptInEndpointDescriptor> => [0x8a7bac69,0x1f10,0x59c7,0x98,0x37,0x72,0xcf,0xed,0x71,0x54,0xa4] as IID_IIterable_1_Windows_Devices_Usb_UsbInterruptInEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbInterruptInPipe> => [0x39aef336,0x18aa,0x5be4,0x86,0xd9,0xe3,0x32,0xfe,0x26,0x32,0xf3] as IID_IIterable_1_Windows_Devices_Usb_UsbInterruptInPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbInterruptOutEndpointDescriptor> => [0x09393d62,0x2316,0x536b,0x8a,0x10,0x70,0x38,0x88,0x4a,0xb2,0xa7] as IID_IIterable_1_Windows_Devices_Usb_UsbInterruptOutEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::usb::UsbInterruptOutPipe> => [0xe61a011e,0x4abe,0x53f2,0x83,0xb3,0xed,0x4a,0x94,0x9d,0x2e,0x3f] as IID_IIterable_1_Windows_Devices_Usb_UsbInterruptOutPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::wifi::WiFiAdapter> => [0xe0bc76c4,0x8d0c,0x53fc,0xbc,0xd4,0x22,0x8f,0x47,0x21,0x0a,0xce] as IID_IIterable_1_Windows_Devices_WiFi_WiFiAdapter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::wifi::WiFiAvailableNetwork> => [0xf17484ea,0xc71e,0x5d3e,0xb7,0x4c,0x3a,0x0e,0x61,0xdd,0x9c,0x20] as IID_IIterable_1_Windows_Devices_WiFi_WiFiAvailableNetwork }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::wifi::WiFiWpsKind> => [0x41e16513,0xa8f2,0x55ed,0x9b,0xe4,0x56,0x65,0x16,0x7d,0x49,0xd7] as IID_IIterable_1_Windows_Devices_WiFi_WiFiWpsKind }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::wifidirect::services::WiFiDirectServiceConfigurationMethod> => [0xd9773b1a,0xa148,0x58bf,0x9c,0x4b,0xaf,0xea,0xc9,0xbe,0x3a,0xb4] as IID_IIterable_1_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceConfigurationMethod }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::wifidirect::WiFiDirectConfigurationMethod> => [0x794f12da,0x2dc6,0x5277,0x82,0xdc,0xb0,0x78,0x16,0x10,0x53,0x7b] as IID_IIterable_1_Windows_Devices_WiFiDirect_WiFiDirectConfigurationMethod }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterable<super::super::devices::wifidirect::WiFiDirectInformationElement> => [0x19c1ca4e,0x9561,0x5253,0x96,0xd9,0xdb,0xaf,0x28,0xd4,0x7d,0x89] as IID_IIterable_1_Windows_Devices_WiFiDirect_WiFiDirectInformationElement }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::ArcadeStick> => [0x9376f457,0x2da5,0x544a,0xa4,0x09,0xc6,0x36,0xf5,0xd8,0x1c,0x35] as IID_IIterable_1_Windows_Gaming_Input_ArcadeStick }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::FlightStick> => [0x3b7fc175,0xbebe,0x52ef,0xa3,0xe9,0xdd,0xa7,0x5e,0xa1,0xac,0xfc] as IID_IIterable_1_Windows_Gaming_Input_FlightStick }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::forcefeedback::ForceFeedbackMotor> => [0xc14440d1,0xfea0,0x5147,0xae,0xd8,0x9b,0x85,0x23,0x9d,0xa8,0x82] as IID_IIterable_1_Windows_Gaming_Input_ForceFeedback_ForceFeedbackMotor }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::Gamepad> => [0x47132ba0,0x6b17,0x5cd2,0xa8,0xbd,0xb5,0xd3,0x44,0x3c,0xcb,0x13] as IID_IIterable_1_Windows_Gaming_Input_Gamepad }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::RacingWheel> => [0x9a7c3830,0x9a87,0x5287,0xa1,0xe2,0x8a,0x2a,0xf2,0x9c,0xf6,0x8c] as IID_IIterable_1_Windows_Gaming_Input_RacingWheel }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::RawGameController> => [0x8f2f08cc,0xf4f4,0x5539,0x93,0x57,0x1f,0x07,0x33,0x4d,0x38,0x1f] as IID_IIterable_1_Windows_Gaming_Input_RawGameController }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::input::UINavigationController> => [0x8dea85a0,0x0204,0x57dd,0xab,0xad,0x90,0xe3,0x7c,0x0e,0xf2,0x40] as IID_IIterable_1_Windows_Gaming_Input_UINavigationController }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::preview::gamesenumeration::GameListEntry> => [0x42b8c8a0,0x3d03,0x5d5f,0x81,0x7e,0x44,0x05,0xc8,0x50,0xf6,0x46] as IID_IIterable_1_Windows_Gaming_Preview_GamesEnumeration_GameListEntry }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::xboxlive::storage::GameSaveBlobInfo> => [0xa7c456d7,0xfa9f,0x536f,0x8e,0xd2,0x45,0x95,0x45,0x81,0x1e,0xd4] as IID_IIterable_1_Windows_Gaming_XboxLive_Storage_GameSaveBlobInfo }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterable<super::super::gaming::xboxlive::storage::GameSaveContainerInfo> => [0x55e4d98f,0x0889,0x5c06,0xa8,0x57,0x7d,0xd1,0x68,0xc2,0xd8,0x52] as IID_IIterable_1_Windows_Gaming_XboxLive_Storage_GameSaveContainerInfo }
#[cfg(feature="windows-globalization")] RT_PINTERFACE!{ for IIterable<super::super::globalization::JapanesePhoneme> => [0x1aad17cb,0x1829,0x5236,0x8a,0xef,0x0b,0x75,0xf8,0xdf,0xd7,0xa6] as IID_IIterable_1_Windows_Globalization_JapanesePhoneme }
#[cfg(feature="windows-globalization")] RT_PINTERFACE!{ for IIterable<super::super::globalization::Language> => [0x48409a10,0x61b6,0x5db1,0xa6,0x9d,0x8a,0xbc,0x46,0xac,0x60,0x8a] as IID_IIterable_1_Windows_Globalization_Language }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::directx::direct3d11::IDirect3DSurface> => [0xcc63bf9c,0xe16a,0x5a75,0xa5,0xaa,0x2b,0x53,0xf9,0x75,0xb0,0xb0] as IID_IIterable_1_Windows_Graphics_DirectX_Direct3D11_IDirect3DSurface }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::directx::DirectXPixelFormat> => [0x3908f2c6,0x1aee,0x5129,0xb9,0xa6,0x2a,0x6e,0x01,0xd9,0x50,0x7e] as IID_IIterable_1_Windows_Graphics_DirectX_DirectXPixelFormat }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::display::core::HdmiDisplayMode> => [0x497e3d51,0x0ea1,0x5be0,0x8d,0xba,0x8f,0x7f,0x4c,0xe4,0xfb,0x33] as IID_IIterable_1_Windows_Graphics_Display_Core_HdmiDisplayMode }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::holographic::HolographicCamera> => [0xb2afd154,0x8db0,0x5bb2,0xad,0x7a,0x68,0x4a,0xfd,0x47,0x92,0x64] as IID_IIterable_1_Windows_Graphics_Holographic_HolographicCamera }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::holographic::HolographicCameraPose> => [0x92111aff,0x8dcc,0x538e,0xae,0x3d,0x31,0xfd,0x25,0x2a,0x0a,0xd5] as IID_IIterable_1_Windows_Graphics_Holographic_HolographicCameraPose }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::holographic::HolographicQuadLayer> => [0x84744661,0x94de,0x5866,0xa1,0x5d,0x9e,0xfb,0x19,0xa9,0x9a,0x54] as IID_IIterable_1_Windows_Graphics_Holographic_HolographicQuadLayer }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::imaging::BitmapCodecInformation> => [0x2b6bdb90,0xa4eb,0x5142,0xb5,0x82,0x3c,0xcb,0x1e,0xdc,0x57,0x89] as IID_IIterable_1_Windows_Graphics_Imaging_BitmapCodecInformation }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::imaging::BitmapPixelFormat> => [0xe924d9ed,0xa13e,0x5bdb,0x9e,0xd8,0x65,0xa1,0x47,0x4d,0xc2,0x74] as IID_IIterable_1_Windows_Graphics_Imaging_BitmapPixelFormat }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::imaging::ImageStream> => [0x034ea0c4,0xc20e,0x5c0c,0xba,0x31,0x64,0x21,0x2f,0x28,0xe6,0x50] as IID_IIterable_1_Windows_Graphics_Imaging_ImageStream }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::imaging::SoftwareBitmap> => [0x22d3a30f,0x0898,0x5e94,0x99,0xa3,0xaf,0xa5,0x95,0x1d,0xfc,0xd4] as IID_IIterable_1_Windows_Graphics_Imaging_SoftwareBitmap }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing::printticket::PrintTicketOption> => [0x5c7e6676,0x9046,0x5b6a,0x9e,0xb0,0xc6,0xa9,0x54,0xe8,0x22,0x6b] as IID_IIterable_1_Windows_Graphics_Printing_PrintTicket_PrintTicketOption }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DBaseMaterial> => [0x9a6bd130,0x6f22,0x559c,0xb9,0x2c,0x14,0xf9,0xf8,0xdd,0xda,0x47] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DBaseMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DBaseMaterialGroup> => [0xc08f8e70,0xf6ef,0x5469,0x80,0x6a,0x7c,0xb6,0x01,0xdd,0xdb,0x67] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DBaseMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DColorMaterial> => [0xc77d4f28,0x7882,0x52b4,0xb3,0xc9,0x7d,0x58,0xc8,0x83,0x65,0x73] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DColorMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DColorMaterialGroup> => [0x1bf32a86,0x26ab,0x5750,0xb5,0x4c,0x3b,0xda,0x67,0x86,0x7f,0x8a] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DColorMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DComponent> => [0x516556ca,0xf862,0x59f8,0x82,0x41,0xe0,0xf0,0xc1,0x77,0xda,0xdd] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DComponent }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DComponentWithMatrix> => [0x8a213648,0x0b81,0x5e23,0xa4,0x8e,0xaf,0xe9,0xf6,0x69,0x1c,0xc1] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DComponentWithMatrix }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DCompositeMaterial> => [0xa0af2623,0x1b11,0x53cf,0x97,0x5d,0x64,0x95,0x93,0x86,0xcd,0xd3] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DCompositeMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DCompositeMaterialGroup> => [0xf2ffef61,0xc254,0x58c0,0x82,0x06,0xb3,0xb3,0x09,0x6b,0xe9,0xcb] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DCompositeMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DMesh> => [0xa8018fda,0xde4d,0x56fa,0x86,0x09,0xfd,0x22,0x98,0xbf,0xb5,0x58] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DMesh }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DModelTexture> => [0x94790870,0x6041,0x5d04,0x86,0x99,0x17,0x41,0x71,0x17,0xbb,0x85] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DModelTexture }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DMultiplePropertyMaterial> => [0x0dfc274e,0xae4d,0x5bbb,0x93,0xa8,0x7d,0xc9,0xf8,0x4d,0xda,0xc3] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DMultiplePropertyMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DMultiplePropertyMaterialGroup> => [0x23f7518e,0x2439,0x5573,0xa6,0x83,0xef,0xca,0x0c,0x61,0xa8,0xd6] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DMultiplePropertyMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DTexture2CoordMaterial> => [0x28373276,0x483c,0x5bd0,0x99,0xc7,0x01,0xbf,0xa0,0x4a,0x57,0xd4] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DTexture2CoordMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DTexture2CoordMaterialGroup> => [0x00017a1d,0x96bc,0x5c0e,0xb7,0x86,0x59,0x4f,0xb4,0xd0,0x77,0xb6] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DTexture2CoordMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterable<super::super::graphics::printing3d::Printing3DTextureResource> => [0x54e3a71d,0xeae0,0x5199,0x97,0x28,0xfa,0xc9,0x64,0x85,0x0e,0xbb] as IID_IIterable_1_Windows_Graphics_Printing3D_Printing3DTextureResource }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IIterable<super::super::management::deployment::PackageUserInformation> => [0x341348b9,0x52c8,0x5b57,0x9e,0x91,0xf1,0x9f,0x2a,0x05,0xb1,0x88] as IID_IIterable_1_Windows_Management_Deployment_PackageUserInformation }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IIterable<super::super::management::deployment::PackageVolume> => [0xa6199162,0xb163,0x56a1,0x99,0x80,0xdb,0x0c,0x3f,0x4e,0x92,0x84] as IID_IIterable_1_Windows_Management_Deployment_PackageVolume }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IIterable<super::super::management::MdmAlert> => [0xa0a617dc,0x210c,0x529f,0xb5,0xe9,0x29,0xae,0xce,0xeb,0xb5,0xa8] as IID_IIterable_1_Windows_Management_MdmAlert }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::apprecording::AppRecordingSavedScreenshotInfo> => [0xdd170424,0x794d,0x5158,0xa9,0xaf,0x68,0x24,0x35,0x3f,0x91,0xb2] as IID_IIterable_1_Windows_Media_AppRecording_AppRecordingSavedScreenshotInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::audio::AudioGraphConnection> => [0x96168d06,0xa51a,0x5480,0x94,0x03,0xfb,0xd7,0x63,0x1e,0x3b,0x3c] as IID_IIterable_1_Windows_Media_Audio_AudioGraphConnection }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::audio::EqualizerBand> => [0x6f76d148,0x023e,0x565a,0x9f,0x09,0x4a,0xd4,0xa3,0x2a,0xd7,0x4f] as IID_IIterable_1_Windows_Media_Audio_EqualizerBand }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::AppBroadcastPlugIn> => [0xc531c5b0,0x0223,0x5c9e,0xa8,0xfb,0x20,0xf5,0x2e,0xa5,0x8d,0x75] as IID_IIterable_1_Windows_Media_Capture_AppBroadcastPlugIn }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::frames::MediaFrameFormat> => [0x1f029a27,0x1123,0x538a,0x92,0x61,0x8a,0x38,0x0e,0x12,0xba,0xc6] as IID_IIterable_1_Windows_Media_Capture_Frames_MediaFrameFormat }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::frames::MediaFrameSource> => [0x0d447be3,0x8c91,0x581d,0x80,0x71,0x17,0x98,0x4b,0x8b,0x59,0x94] as IID_IIterable_1_Windows_Media_Capture_Frames_MediaFrameSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::frames::MediaFrameSourceGroup> => [0xd0b71deb,0x76e8,0x5833,0x96,0x23,0x2b,0x1e,0x1a,0x8e,0x1b,0x72] as IID_IIterable_1_Windows_Media_Capture_Frames_MediaFrameSourceGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::frames::MediaFrameSourceInfo> => [0x2e29c5b0,0x6aa9,0x50f2,0x91,0xa4,0x5b,0x67,0xa5,0x59,0x8f,0x2e] as IID_IIterable_1_Windows_Media_Capture_Frames_MediaFrameSourceInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::MediaCaptureVideoProfile> => [0xdbd49d71,0xe07b,0x5e11,0x82,0x4a,0x62,0xac,0xe8,0xbd,0xfc,0x3e] as IID_IIterable_1_Windows_Media_Capture_MediaCaptureVideoProfile }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::capture::MediaCaptureVideoProfileMediaDescription> => [0x0895e56d,0xfe1f,0x5364,0xab,0x67,0xc5,0x97,0xd8,0x97,0x0b,0x89] as IID_IIterable_1_Windows_Media_Capture_MediaCaptureVideoProfileMediaDescription }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::casting::CastingSource> => [0x1abb2cc9,0x46a2,0x58b1,0x91,0xaa,0x28,0x69,0x9d,0x66,0xd1,0xab] as IID_IIterable_1_Windows_Media_Casting_CastingSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::AudioStreamDescriptor> => [0xa3e2c972,0xa171,0x5b94,0x83,0x89,0xe9,0x83,0xeb,0xc3,0xf3,0xb9] as IID_IIterable_1_Windows_Media_Core_AudioStreamDescriptor }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::AudioTrack> => [0xb3be50a8,0x9856,0x5656,0xab,0x6d,0xcd,0x58,0xf9,0xde,0x0a,0x4f] as IID_IIterable_1_Windows_Media_Core_AudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::CodecInfo> => [0x552f7709,0x3bc3,0x59fb,0x93,0xe6,0x1e,0xbd,0x28,0xd3,0xc0,0x08] as IID_IIterable_1_Windows_Media_Core_CodecInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::IMediaCue> => [0x737a2098,0x41bf,0x5d9f,0xa1,0xd2,0x2f,0x17,0x1c,0x57,0x8b,0x3c] as IID_IIterable_1_Windows_Media_Core_IMediaCue }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::MseSourceBuffer> => [0x5ca0da86,0x6307,0x558a,0x86,0x5f,0x3a,0x1e,0xf9,0xfe,0x56,0xb3] as IID_IIterable_1_Windows_Media_Core_MseSourceBuffer }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::MseTimeRange> => [0xed0c6e08,0xe22f,0x5ac2,0xba,0x14,0xe0,0xff,0x1d,0xf3,0x46,0x7f] as IID_IIterable_1_Windows_Media_Core_MseTimeRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::TimedMetadataTrack> => [0x150a4454,0x03bb,0x5dd1,0x81,0x53,0x6a,0x60,0x0e,0x85,0x1f,0x71] as IID_IIterable_1_Windows_Media_Core_TimedMetadataTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::TimedTextLine> => [0xaec710ad,0x3bd8,0x5a59,0xae,0x77,0xe7,0xfc,0x46,0xfb,0x10,0x5b] as IID_IIterable_1_Windows_Media_Core_TimedTextLine }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::TimedTextSource> => [0x4fc57282,0x0edf,0x5d85,0x9d,0x89,0xdd,0xc2,0xa5,0x69,0x2c,0x13] as IID_IIterable_1_Windows_Media_Core_TimedTextSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::TimedTextSubformat> => [0xcee3ae43,0xc93c,0x56f7,0x8c,0x55,0x90,0x24,0xde,0xd7,0x2c,0x76] as IID_IIterable_1_Windows_Media_Core_TimedTextSubformat }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::VideoStreamDescriptor> => [0x3acbf03c,0x0a79,0x5823,0xaa,0xa9,0xd8,0x8b,0xc3,0xf8,0xf5,0x94] as IID_IIterable_1_Windows_Media_Core_VideoStreamDescriptor }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::core::VideoTrack> => [0x84413442,0xa2e3,0x5e0f,0x93,0x6d,0xbc,0x40,0xb0,0xfb,0x2d,0xcd] as IID_IIterable_1_Windows_Media_Core_VideoTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::AdvancedPhotoMode> => [0x7d090784,0x70a9,0x570c,0xbe,0x82,0x0d,0x08,0x90,0x31,0x89,0x75] as IID_IIterable_1_Windows_Media_Devices_AdvancedPhotoMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::AudioDeviceModule> => [0x7eeb51c3,0xd70e,0x548a,0x85,0xc2,0x3c,0xf7,0x1b,0x4a,0x12,0x4c] as IID_IIterable_1_Windows_Media_Devices_AudioDeviceModule }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::AutoFocusRange> => [0x751664c6,0xf8d6,0x50a3,0xab,0x80,0x13,0x7c,0x6d,0x90,0x8c,0x55] as IID_IIterable_1_Windows_Media_Devices_AutoFocusRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::CaptureSceneMode> => [0x16d26b98,0x2cbc,0x52f0,0xab,0x64,0x17,0x23,0x71,0x44,0x18,0xe9] as IID_IIterable_1_Windows_Media_Devices_CaptureSceneMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::core::FrameController> => [0xbd8eeadc,0x2dd9,0x5ad8,0xac,0x5d,0xf3,0xb1,0x3b,0x94,0xb9,0xc2] as IID_IIterable_1_Windows_Media_Devices_Core_FrameController }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::FocusMode> => [0x561bc21f,0x4ae2,0x580a,0xa2,0x16,0x0a,0xd4,0x8f,0x37,0x3a,0x4c] as IID_IIterable_1_Windows_Media_Devices_FocusMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::FocusPreset> => [0x26ba711b,0x3a32,0x5216,0xbc,0x34,0x61,0xec,0xaf,0xbe,0xbd,0xc1] as IID_IIterable_1_Windows_Media_Devices_FocusPreset }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::HdrVideoMode> => [0x1d9679a7,0x2d06,0x5294,0xac,0x67,0xf9,0xcd,0x35,0x61,0xdc,0xb8] as IID_IIterable_1_Windows_Media_Devices_HdrVideoMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::IsoSpeedPreset> => [0x94839abe,0x9712,0x545a,0xa9,0x4d,0xa5,0x67,0xa3,0xe8,0xdf,0xb7] as IID_IIterable_1_Windows_Media_Devices_IsoSpeedPreset }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::ManualFocusDistance> => [0xcf8cbeb1,0x2a4c,0x522d,0x96,0x2f,0x84,0xc3,0x1a,0x59,0x8d,0x68] as IID_IIterable_1_Windows_Media_Devices_ManualFocusDistance }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::OpticalImageStabilizationMode> => [0x323d7734,0x94c2,0x544d,0xa5,0x60,0x56,0x56,0x0f,0xe6,0x88,0x19] as IID_IIterable_1_Windows_Media_Devices_OpticalImageStabilizationMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::RegionOfInterest> => [0xd73144c7,0x9d75,0x5dfb,0x80,0x40,0x62,0x62,0x02,0xdc,0xf4,0x54] as IID_IIterable_1_Windows_Media_Devices_RegionOfInterest }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::devices::ZoomTransitionMode> => [0xdb656915,0x8fac,0x5fb2,0x98,0xe0,0x0e,0x97,0x42,0x16,0x56,0xc5] as IID_IIterable_1_Windows_Media_Devices_ZoomTransitionMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::editing::BackgroundAudioTrack> => [0x3fc05ba2,0x30f6,0x5219,0x90,0x47,0x11,0x97,0xff,0xae,0x8d,0xba] as IID_IIterable_1_Windows_Media_Editing_BackgroundAudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::editing::EmbeddedAudioTrack> => [0x32fabed0,0xe1e6,0x578e,0x86,0xe5,0xb4,0xe6,0xab,0xeb,0x22,0xd6] as IID_IIterable_1_Windows_Media_Editing_EmbeddedAudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::editing::MediaClip> => [0xff2e9b5c,0x26d0,0x575d,0xa3,0xeb,0x7d,0x93,0x8b,0xd1,0x6f,0x17] as IID_IIterable_1_Windows_Media_Editing_MediaClip }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::editing::MediaOverlay> => [0xefcda247,0xa1fb,0x51dc,0xa7,0x76,0xe3,0xe0,0x66,0x95,0xfb,0x36] as IID_IIterable_1_Windows_Media_Editing_MediaOverlay }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::editing::MediaOverlayLayer> => [0x7d2312d0,0xf3a2,0x5091,0x8a,0x5e,0x41,0x83,0x2e,0x63,0x2c,0x08] as IID_IIterable_1_Windows_Media_Editing_MediaOverlayLayer }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::effects::AudioEffect> => [0x07af9afd,0x25b8,0x579d,0xbe,0x7e,0x8a,0xcc,0x03,0x41,0x8d,0x0b] as IID_IIterable_1_Windows_Media_Effects_AudioEffect }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::effects::IAudioEffectDefinition> => [0x607a20bf,0x32b4,0x5b8e,0xa7,0x93,0x30,0x24,0xf8,0xd3,0x58,0x2a] as IID_IIterable_1_Windows_Media_Effects_IAudioEffectDefinition }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::effects::IVideoEffectDefinition> => [0xeb567f6f,0xb014,0x513d,0x99,0xcd,0xf1,0x6c,0x22,0x6c,0x3c,0x41] as IID_IIterable_1_Windows_Media_Effects_IVideoEffectDefinition }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::faceanalysis::DetectedFace> => [0x25347323,0x3556,0x5cbb,0x98,0x55,0x2b,0x58,0x56,0x43,0x7f,0x4d] as IID_IIterable_1_Windows_Media_FaceAnalysis_DetectedFace }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::IMediaMarker> => [0xa1c0a397,0x0364,0x5e4c,0x9d,0xca,0x7c,0xd7,0x01,0x1b,0xd1,0x14] as IID_IIterable_1_Windows_Media_IMediaMarker }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::import::PhotoImportItem> => [0x82347483,0x3b75,0x5e95,0xbb,0xa4,0xab,0xc0,0xb8,0xa3,0x20,0xaa] as IID_IIterable_1_Windows_Media_Import_PhotoImportItem }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::import::PhotoImportOperation> => [0x94f33a8f,0x115a,0x50cb,0xb5,0x9d,0xab,0x84,0x83,0xa8,0x48,0x42] as IID_IIterable_1_Windows_Media_Import_PhotoImportOperation }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::import::PhotoImportSidecar> => [0x2b7f92ad,0xe596,0x5669,0xb6,0x22,0xfb,0xfb,0xc7,0x04,0x0e,0x89] as IID_IIterable_1_Windows_Media_Import_PhotoImportSidecar }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::import::PhotoImportSource> => [0x40e01d62,0xb413,0x5b43,0xab,0x07,0xab,0x28,0xb2,0x3f,0xc8,0x86] as IID_IIterable_1_Windows_Media_Import_PhotoImportSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::import::PhotoImportStorageMedium> => [0x3233cbfe,0xf9ee,0x560f,0xbd,0x0f,0xe3,0x6a,0xbe,0x6c,0xda,0x7f] as IID_IIterable_1_Windows_Media_Import_PhotoImportStorageMedium }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::import::PhotoImportVideoSegment> => [0x94dd3b44,0xda03,0x5d79,0xbb,0xfb,0x1b,0xea,0xf2,0xed,0xe4,0x82] as IID_IIterable_1_Windows_Media_Import_PhotoImportVideoSegment }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::mediaproperties::AudioEncodingProperties> => [0x00939468,0x25d8,0x533f,0x85,0x4e,0x4f,0x20,0xf3,0x6c,0x51,0xdc] as IID_IIterable_1_Windows_Media_MediaProperties_AudioEncodingProperties }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::mediaproperties::IMediaEncodingProperties> => [0xd7fc75d5,0x3492,0x5bbb,0x9b,0x34,0xda,0xc3,0xe2,0x4e,0x79,0xd0] as IID_IIterable_1_Windows_Media_MediaProperties_IMediaEncodingProperties }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::mediaproperties::VideoEncodingProperties> => [0x73c7317c,0x8682,0x5f81,0x84,0xa2,0x30,0xc4,0x25,0xfa,0x2d,0x24] as IID_IIterable_1_Windows_Media_MediaProperties_VideoEncodingProperties }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::MediaTimeRange> => [0x268204e2,0x9d52,0x5e7b,0xa5,0x4b,0x86,0x9c,0x63,0xde,0xfc,0x8e] as IID_IIterable_1_Windows_Media_MediaTimeRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::ocr::OcrLine> => [0x6afa94a2,0x60d7,0x5dbe,0x94,0x2d,0x81,0xaa,0x39,0x29,0xc8,0x5e] as IID_IIterable_1_Windows_Media_Ocr_OcrLine }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::ocr::OcrWord> => [0xa0ce663a,0x46d0,0x55e5,0x92,0x8e,0x25,0x1e,0xb6,0x7a,0x1e,0x99] as IID_IIterable_1_Windows_Media_Ocr_OcrWord }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::playback::MediaBreak> => [0x04f000ec,0xc727,0x5dc0,0x9f,0x7c,0x24,0x5c,0x75,0xc9,0x2f,0x2f] as IID_IIterable_1_Windows_Media_Playback_MediaBreak }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::playback::MediaPlaybackItem> => [0x8b8ab4a4,0x0253,0x56e9,0xa2,0x32,0x94,0xe3,0x35,0xae,0xfa,0x8f] as IID_IIterable_1_Windows_Media_Playback_MediaPlaybackItem }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::protection::playready::IPlayReadyDomain> => [0x84e98f86,0x4bee,0x5f41,0x93,0xa1,0x25,0x58,0x87,0x12,0x2d,0x9f] as IID_IIterable_1_Windows_Media_Protection_PlayReady_IPlayReadyDomain }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::protection::playready::IPlayReadyLicense> => [0x9f28f6b7,0xb5ea,0x5073,0xba,0x3d,0x8c,0xb2,0xf0,0x72,0x91,0xa1] as IID_IIterable_1_Windows_Media_Protection_PlayReady_IPlayReadyLicense }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::protection::playready::IPlayReadySecureStopServiceRequest> => [0x8d8ac279,0xb07d,0x5308,0x9c,0x78,0x1c,0x5c,0x99,0x6c,0xa0,0x3c] as IID_IIterable_1_Windows_Media_Protection_PlayReady_IPlayReadySecureStopServiceRequest }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::protection::RevocationAndRenewalItem> => [0x07015868,0x578c,0x556b,0x8a,0x35,0x40,0x39,0xa3,0x5d,0x1d,0x92] as IID_IIterable_1_Windows_Media_Protection_RevocationAndRenewalItem }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::speechrecognition::ISpeechRecognitionConstraint> => [0x88e6436c,0x3253,0x520b,0x9e,0xd8,0xa6,0x3b,0x17,0x8c,0x44,0xa2] as IID_IIterable_1_Windows_Media_SpeechRecognition_ISpeechRecognitionConstraint }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::speechrecognition::SpeechRecognitionResult> => [0x0d9b7b48,0x98a1,0x5b22,0x9a,0x66,0x6f,0x81,0x2f,0x59,0x47,0xaa] as IID_IIterable_1_Windows_Media_SpeechRecognition_SpeechRecognitionResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterable<super::super::media::speechsynthesis::VoiceInformation> => [0x3c33bb52,0xbd98,0x5c8c,0xad,0xee,0xee,0x8d,0xa0,0x62,0x8e,0xfc] as IID_IIterable_1_Windows_Media_SpeechSynthesis_VoiceInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::backgroundtransfer::BackgroundTransferContentPart> => [0xcf303199,0xde3b,0x5dac,0xa7,0x03,0x6c,0x57,0xd8,0x08,0x21,0xc4] as IID_IIterable_1_Windows_Networking_BackgroundTransfer_BackgroundTransferContentPart }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::backgroundtransfer::BackgroundTransferFileRange> => [0x2cc2d499,0x974c,0x5078,0x89,0xae,0x2d,0x4e,0xe1,0x13,0x97,0x21] as IID_IIterable_1_Windows_Networking_BackgroundTransfer_BackgroundTransferFileRange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::backgroundtransfer::DownloadOperation> => [0xf6fd69cb,0xe6e7,0x56d5,0x9b,0xe6,0xe0,0xdc,0x46,0x83,0xfa,0x80] as IID_IIterable_1_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::backgroundtransfer::UploadOperation> => [0x79778799,0x38cc,0x5b67,0x9c,0xd0,0x04,0x3f,0xc4,0x7a,0x9e,0xf7] as IID_IIterable_1_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::connectivity::AttributedNetworkUsage> => [0xd061dcb9,0x6854,0x5ef9,0x8e,0x03,0x00,0x8a,0x7a,0x70,0x4c,0x48] as IID_IIterable_1_Windows_Networking_Connectivity_AttributedNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::connectivity::ConnectionProfile> => [0x34dabef9,0x87d0,0x5b1c,0xa7,0xac,0x9d,0x29,0x0a,0xde,0xb0,0xc8] as IID_IIterable_1_Windows_Networking_Connectivity_ConnectionProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::connectivity::ConnectivityInterval> => [0x58051a8b,0xb259,0x5414,0x9b,0x9a,0xca,0xa0,0x78,0x9e,0x83,0x3e] as IID_IIterable_1_Windows_Networking_Connectivity_ConnectivityInterval }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::connectivity::LanIdentifier> => [0xaccef3cd,0x5d92,0x5c01,0x8a,0xc4,0x79,0xfe,0x74,0xcd,0x73,0x3e] as IID_IIterable_1_Windows_Networking_Connectivity_LanIdentifier }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::connectivity::NetworkUsage> => [0xdd2656b1,0x8360,0x5772,0xb2,0x72,0xc4,0x7f,0x7f,0x0f,0xc7,0xa6] as IID_IIterable_1_Windows_Networking_Connectivity_NetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::connectivity::ProviderNetworkUsage> => [0xf79bc7ba,0x01df,0x51ec,0xbf,0xaf,0xfd,0x88,0x3f,0x69,0x8e,0x07] as IID_IIterable_1_Windows_Networking_Connectivity_ProviderNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::EndpointPair> => [0xd7ec83c4,0xa17b,0x51bf,0x89,0x97,0xaa,0x33,0xb9,0x10,0x2d,0xc9] as IID_IIterable_1_Windows_Networking_EndpointPair }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::HostName> => [0x9e5f3ed0,0xcf1c,0x5d38,0x83,0x2c,0xac,0xea,0x61,0x64,0xbf,0x5c] as IID_IIterable_1_Windows_Networking_HostName }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandAntennaSar> => [0xfd66b9ac,0x40dc,0x5ac7,0xaa,0xf1,0x2d,0x34,0x03,0xe5,0xfc,0xbb] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandAntennaSar }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandCellCdma> => [0x46e83a22,0x4c40,0x5f27,0xbb,0xcd,0x25,0x5d,0xfd,0x97,0xea,0x93] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandCellCdma }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandCellGsm> => [0x83e5eae8,0x3887,0x599e,0xbe,0xbf,0x8c,0x51,0x36,0x2d,0xb4,0x4c] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandCellGsm }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandCellLte> => [0x45d961d3,0xe228,0x5afd,0xb1,0x8c,0xd4,0xcf,0xa3,0x90,0x34,0x32] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandCellLte }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandCellTdscdma> => [0x6e1e543f,0x1cf0,0x5cb3,0xb3,0xfc,0xb5,0x59,0x21,0x3c,0x58,0xe2] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandCellTdscdma }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandCellUmts> => [0x20392566,0x69cb,0x5eda,0xb6,0x41,0x55,0x10,0xe7,0xed,0x1a,0x12] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandCellUmts }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandDeviceServiceInformation> => [0x88511855,0x6fe6,0x5694,0x83,0xa7,0x99,0x1e,0x29,0x03,0x3d,0xe5] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandDeviceServiceInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandNetworkRegistrationStateChange> => [0x0b90bb30,0x660c,0x51c6,0x9b,0x8c,0x31,0xdd,0x84,0x86,0xe1,0x0e] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandNetworkRegistrationStateChange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandPinLockStateChange> => [0xaa4a8700,0x9943,0x59a3,0x86,0x47,0xd3,0x73,0xfd,0x5e,0x0e,0x2b] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandPinLockStateChange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandPinType> => [0x9d55726d,0x813e,0x50fb,0x94,0x98,0x87,0xaa,0x87,0x2d,0xd6,0xca] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandPinType }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandRadioStateChange> => [0xc385adaa,0x574c,0x5ad8,0x98,0xc2,0x61,0x30,0x95,0x25,0x13,0x2d] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandRadioStateChange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::MobileBroadbandUiccApp> => [0xaf538114,0xbd14,0x53b0,0xb1,0xd1,0x84,0x1d,0xca,0xa4,0x51,0xad] as IID_IIterable_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccApp }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::networkoperators::NetworkOperatorTetheringClient> => [0x4762ecb3,0xaf48,0x5b63,0x89,0xb7,0x78,0xa4,0x20,0x56,0x54,0x9f] as IID_IIterable_1_Windows_Networking_NetworkOperators_NetworkOperatorTetheringClient }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::proximity::PeerInformation> => [0x917e1105,0x0647,0x5793,0x9d,0x50,0xbe,0xfe,0x22,0x5f,0x0f,0x2f] as IID_IIterable_1_Windows_Networking_Proximity_PeerInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::servicediscovery::dnssd::DnssdServiceInstance> => [0x1de3a3e5,0x387e,0x5328,0xb8,0x64,0x3f,0x0e,0x34,0x75,0xd3,0x43] as IID_IIterable_1_Windows_Networking_ServiceDiscovery_Dnssd_DnssdServiceInstance }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::IVpnCustomPrompt> => [0x8bac695c,0x70cb,0x54d6,0x86,0x06,0xaf,0x6e,0x3a,0x25,0xe3,0xa1] as IID_IIterable_1_Windows_Networking_Vpn_IVpnCustomPrompt }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::IVpnCustomPromptElement> => [0x437d3693,0x00c4,0x50b4,0x98,0x9a,0x93,0x8f,0x10,0x16,0xa2,0x30] as IID_IIterable_1_Windows_Networking_Vpn_IVpnCustomPromptElement }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::IVpnProfile> => [0xdb35f6b1,0xf266,0x5c87,0x88,0x62,0x9d,0xd8,0x7d,0x9d,0xf1,0x8f] as IID_IIterable_1_Windows_Networking_Vpn_IVpnProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::VpnAppId> => [0x0e1e00aa,0xf93d,0x5dc7,0x99,0x12,0xe0,0x7d,0x1f,0xa6,0xbd,0x67] as IID_IIterable_1_Windows_Networking_Vpn_VpnAppId }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::VpnDomainNameInfo> => [0x33abe488,0xbe1a,0x558a,0xa9,0xcf,0xb5,0x33,0x0a,0xb4,0x9f,0x50] as IID_IIterable_1_Windows_Networking_Vpn_VpnDomainNameInfo }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::VpnNamespaceInfo> => [0x17781d03,0xddcf,0x553f,0xab,0xa8,0xd2,0xe8,0x15,0x5c,0xb6,0xb8] as IID_IIterable_1_Windows_Networking_Vpn_VpnNamespaceInfo }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::VpnRoute> => [0xbbf498d5,0xb9ef,0x55f1,0x97,0xb1,0x77,0xa0,0x66,0x39,0xe4,0xe2] as IID_IIterable_1_Windows_Networking_Vpn_VpnRoute }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::vpn::VpnTrafficFilter> => [0xb6d4c853,0x77c9,0x52ca,0x9c,0xe9,0x85,0x3a,0xdd,0x45,0x54,0xcf] as IID_IIterable_1_Windows_Networking_Vpn_VpnTrafficFilter }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::xboxlive::XboxLiveDeviceAddress> => [0x44df817c,0xb475,0x5fdb,0x86,0x2a,0x4a,0x96,0xed,0x1d,0xad,0x5c] as IID_IIterable_1_Windows_Networking_XboxLive_XboxLiveDeviceAddress }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::xboxlive::XboxLiveEndpointPair> => [0x7fcaf666,0xddc0,0x50dc,0xa7,0x6f,0x9b,0xb6,0x05,0x8b,0xe3,0xc9] as IID_IIterable_1_Windows_Networking_XboxLive_XboxLiveEndpointPair }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::xboxlive::XboxLiveEndpointPairTemplate> => [0x9fce55c3,0x5580,0x581a,0x85,0xb5,0x88,0xdd,0x5e,0x9d,0x4f,0xf7] as IID_IIterable_1_Windows_Networking_XboxLive_XboxLiveEndpointPairTemplate }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::xboxlive::XboxLiveQualityOfServiceMetric> => [0xe202eef6,0x93bd,0x5fa2,0x91,0xfc,0x7c,0xa6,0xa4,0xed,0xc3,0x8a] as IID_IIterable_1_Windows_Networking_XboxLive_XboxLiveQualityOfServiceMetric }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::xboxlive::XboxLiveQualityOfServiceMetricResult> => [0x65cc99ec,0x9779,0x568a,0x89,0x82,0xae,0xe4,0x39,0xfa,0x24,0xce] as IID_IIterable_1_Windows_Networking_XboxLive_XboxLiveQualityOfServiceMetricResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterable<super::super::networking::xboxlive::XboxLiveQualityOfServicePrivatePayloadResult> => [0x3a061dd4,0x03dd,0x52fb,0x9a,0x83,0x06,0x7d,0xe2,0x7c,0x2b,0xb1] as IID_IIterable_1_Windows_Networking_XboxLive_XboxLiveQualityOfServicePrivatePayloadResult }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IIterable<super::super::perception::spatial::SpatialBoundingVolume> => [0x89e8f1ee,0x3a2a,0x5b69,0xa7,0x86,0xcd,0xdc,0xf7,0x45,0x6a,0x3a] as IID_IIterable_1_Windows_Perception_Spatial_SpatialBoundingVolume }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::identity::core::MicrosoftAccountMultiFactorSessionInfo> => [0x85a662c8,0x8a5d,0x59a8,0x9f,0x73,0xee,0x23,0x73,0x93,0xc5,0x5c] as IID_IIterable_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorSessionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::identity::EnterpriseKeyCredentialRegistrationInfo> => [0xe7eea796,0x77f9,0x5473,0xa9,0x13,0x73,0x4e,0xa0,0xe3,0xff,0x46] as IID_IIterable_1_Windows_Security_Authentication_Identity_EnterpriseKeyCredentialRegistrationInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::identity::provider::SecondaryAuthenticationFactorInfo> => [0x43b7bbe4,0xf096,0x53dd,0x8c,0x16,0x1f,0xaa,0x4b,0x46,0x8c,0x86] as IID_IIterable_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::onlineid::OnlineIdServiceTicket> => [0x809d1314,0x97ab,0x5544,0x98,0x91,0xdd,0xcd,0xfa,0xdd,0x1d,0xbb] as IID_IIterable_1_Windows_Security_Authentication_OnlineId_OnlineIdServiceTicket }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::onlineid::OnlineIdServiceTicketRequest> => [0xcb72d686,0x9516,0x520d,0xa2,0x74,0xfa,0x4c,0xd1,0x76,0x2c,0xb2] as IID_IIterable_1_Windows_Security_Authentication_OnlineId_OnlineIdServiceTicketRequest }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::web::core::WebTokenResponse> => [0x7e5bb7ec,0xbbd7,0x5575,0x9a,0x61,0xf5,0x81,0x5f,0xa2,0x2a,0x0e] as IID_IIterable_1_Windows_Security_Authentication_Web_Core_WebTokenResponse }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::web::provider::WebAccountClientView> => [0x610e0f9d,0xaae4,0x54e1,0xbb,0x0b,0x1a,0xca,0x14,0x11,0x0a,0xbf] as IID_IIterable_1_Windows_Security_Authentication_Web_Provider_WebAccountClientView }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::authentication::web::provider::WebProviderTokenResponse> => [0xe9bac236,0xc077,0x553a,0xb4,0xae,0xb5,0x8f,0xb0,0xb8,0x99,0x18] as IID_IIterable_1_Windows_Security_Authentication_Web_Provider_WebProviderTokenResponse }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::credentials::PasswordCredential> => [0x0d224a66,0xbad5,0x5ad5,0x9a,0xde,0x1e,0x9f,0x5a,0x60,0xfe,0x73] as IID_IIterable_1_Windows_Security_Credentials_PasswordCredential }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::credentials::WebAccount> => [0xcb15d439,0xa910,0x542a,0x89,0xed,0x7c,0xfe,0x67,0x84,0x8a,0x83] as IID_IIterable_1_Windows_Security_Credentials_WebAccount }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::cryptography::certificates::Certificate> => [0x0c7d1423,0xe8fd,0x5a91,0xb5,0x5c,0x8b,0xfb,0xe7,0xac,0x2d,0x40] as IID_IIterable_1_Windows_Security_Cryptography_Certificates_Certificate }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::cryptography::certificates::CertificateExtension> => [0x1bdd7127,0x73b3,0x5192,0x8b,0xde,0x20,0xc1,0x36,0x28,0x12,0x60] as IID_IIterable_1_Windows_Security_Cryptography_Certificates_CertificateExtension }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::cryptography::certificates::ChainValidationResult> => [0x2628f58f,0x3f02,0x54f2,0x80,0x8f,0xe1,0x11,0x77,0x09,0xd6,0xd0] as IID_IIterable_1_Windows_Security_Cryptography_Certificates_ChainValidationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterable<super::super::security::cryptography::certificates::CmsSignerInfo> => [0x6af24174,0x2dda,0x5a54,0xa0,0xb9,0x4d,0x66,0x90,0x05,0x94,0x27] as IID_IIterable_1_Windows_Security_Cryptography_Certificates_CmsSignerInfo }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::cortana::CortanaPermission> => [0x36a12eae,0x2e24,0x5e07,0xbf,0xd0,0x34,0x4a,0x92,0x99,0x09,0x16] as IID_IIterable_1_Windows_Services_Cortana_CortanaPermission }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::EnhancedWaypoint> => [0xd0545dba,0x9b05,0x5e37,0xbf,0xc0,0x3d,0xa2,0xb5,0x1d,0x13,0x5b] as IID_IIterable_1_Windows_Services_Maps_EnhancedWaypoint }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::guidance::GuidanceLaneInfo> => [0x45960d72,0x1bf6,0x5a1d,0xa1,0x7f,0xe8,0x3f,0x56,0xf1,0xab,0x57] as IID_IIterable_1_Windows_Services_Maps_Guidance_GuidanceLaneInfo }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::guidance::GuidanceManeuver> => [0xb5780d67,0x8a8b,0x558f,0xa4,0xb6,0xc4,0x53,0x1e,0xf3,0x2e,0xc8] as IID_IIterable_1_Windows_Services_Maps_Guidance_GuidanceManeuver }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::guidance::GuidanceRoadSegment> => [0xf7c614c4,0x0fca,0x5eda,0x80,0x4c,0x85,0xc8,0x29,0x95,0x63,0x34] as IID_IIterable_1_Windows_Services_Maps_Guidance_GuidanceRoadSegment }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::localsearch::LocalLocation> => [0x5474eefb,0x60f4,0x58ac,0x89,0xe2,0x6e,0x83,0xf7,0x9f,0xa7,0x6c] as IID_IIterable_1_Windows_Services_Maps_LocalSearch_LocalLocation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::localsearch::LocalLocationHoursOfOperationItem> => [0xf298f515,0xb9bd,0x5297,0xb8,0xbd,0x1c,0x00,0x40,0xda,0xac,0x76] as IID_IIterable_1_Windows_Services_Maps_LocalSearch_LocalLocationHoursOfOperationItem }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::ManeuverWarning> => [0xce0a7c13,0xd3c4,0x55af,0xa9,0x0f,0xc5,0x3f,0x7b,0xd9,0x33,0x73] as IID_IIterable_1_Windows_Services_Maps_ManeuverWarning }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::MapLocation> => [0x77da6151,0x0763,0x508a,0x90,0x41,0x33,0x10,0xba,0xac,0xe5,0x75] as IID_IIterable_1_Windows_Services_Maps_MapLocation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::MapRoute> => [0xd88a62a2,0x0edf,0x5312,0x97,0xa8,0x10,0xae,0xae,0xa8,0x0b,0x99] as IID_IIterable_1_Windows_Services_Maps_MapRoute }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::MapRouteLeg> => [0x8ff98759,0x78cd,0x56e8,0x87,0x7b,0x83,0xce,0x84,0x6d,0x6f,0x8b] as IID_IIterable_1_Windows_Services_Maps_MapRouteLeg }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::MapRouteManeuver> => [0xde9015fb,0x91d7,0x556e,0xbb,0x4d,0x20,0x0b,0x6f,0x58,0xfa,0xd4] as IID_IIterable_1_Windows_Services_Maps_MapRouteManeuver }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::maps::offlinemaps::OfflineMapPackage> => [0x7522287c,0x0af2,0x586c,0xbb,0x3f,0x45,0x7c,0x07,0x98,0x4a,0x6f] as IID_IIterable_1_Windows_Services_Maps_OfflineMaps_OfflineMapPackage }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::store::StoreAvailability> => [0xc58de1a0,0x25de,0x578b,0xbb,0x69,0xe0,0xa2,0x6d,0x67,0xb2,0x03] as IID_IIterable_1_Windows_Services_Store_StoreAvailability }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::store::StoreImage> => [0xb2da6de8,0xad55,0x56ce,0x87,0x54,0x2c,0x96,0xf4,0xfe,0x1c,0x2e] as IID_IIterable_1_Windows_Services_Store_StoreImage }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::store::StorePackageUpdate> => [0x6b076c51,0x849e,0x5ec5,0xae,0xd5,0x9b,0x05,0x85,0x59,0x19,0x02] as IID_IIterable_1_Windows_Services_Store_StorePackageUpdate }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::store::StorePackageUpdateStatus> => [0x60832223,0x7eb4,0x5cd7,0x83,0x40,0xf5,0x07,0x71,0x73,0xd3,0x64] as IID_IIterable_1_Windows_Services_Store_StorePackageUpdateStatus }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::store::StoreSku> => [0x522d34ef,0x4b5a,0x5b44,0xa0,0x46,0x7a,0x16,0x05,0x1d,0x01,0x1e] as IID_IIterable_1_Windows_Services_Store_StoreSku }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::store::StoreVideo> => [0x46be61e4,0x7173,0x565e,0xae,0xd5,0x4a,0x21,0x52,0xf1,0xce,0x69] as IID_IIterable_1_Windows_Services_Store_StoreVideo }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::targetedcontent::TargetedContentAction> => [0xcf05b497,0x3afd,0x5d00,0x85,0x9e,0x9f,0xbd,0x1a,0x36,0xd5,0x76] as IID_IIterable_1_Windows_Services_TargetedContent_TargetedContentAction }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::targetedcontent::TargetedContentCollection> => [0x2049f813,0x37ee,0x5158,0x99,0x96,0x70,0x98,0x59,0xf0,0xce,0x49] as IID_IIterable_1_Windows_Services_TargetedContent_TargetedContentCollection }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::targetedcontent::TargetedContentFile> => [0x5f65d649,0xccbd,0x5728,0xa8,0x5b,0xd3,0xff,0x92,0xfc,0xa9,0x62] as IID_IIterable_1_Windows_Services_TargetedContent_TargetedContentFile }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::targetedcontent::TargetedContentImage> => [0xefadb6bf,0xaf18,0x5af9,0xa5,0x09,0x19,0x88,0x1b,0xc5,0x86,0xf5] as IID_IIterable_1_Windows_Services_TargetedContent_TargetedContentImage }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterable<super::super::services::targetedcontent::TargetedContentItem> => [0x03f38fb6,0x54e6,0x5bf1,0x91,0x3b,0x95,0x10,0xfe,0xc8,0xbe,0x1f] as IID_IIterable_1_Windows_Services_TargetedContent_TargetedContentItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::accesscache::AccessListEntry> => [0x4995c2b0,0x736b,0x588d,0xae,0x42,0x6f,0x69,0xb0,0x25,0xb3,0x88] as IID_IIterable_1_Windows_Storage_AccessCache_AccessListEntry }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::bulkaccess::FileInformation> => [0xdd96d7e9,0x892b,0x5932,0xb6,0x77,0x5b,0xc3,0x25,0x88,0x00,0x8f] as IID_IIterable_1_Windows_Storage_BulkAccess_FileInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::bulkaccess::FolderInformation> => [0x5c720bf5,0x7636,0x51fd,0x9e,0xf7,0xd5,0xf5,0x7f,0x07,0x1a,0x9b] as IID_IIterable_1_Windows_Storage_BulkAccess_FolderInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::bulkaccess::IStorageItemInformation> => [0x43bc252e,0xa3d6,0x5f00,0xa1,0x2c,0xb0,0x88,0xd3,0xb9,0x12,0xd4] as IID_IIterable_1_Windows_Storage_BulkAccess_IStorageItemInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::IStorageFile> => [0x76d43c7e,0xfd09,0x5908,0xa2,0xb9,0xa4,0x9b,0x48,0x48,0x29,0x4b] as IID_IIterable_1_Windows_Storage_IStorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::IStorageItem> => [0xbb8b8418,0x65d1,0x544b,0xb0,0x83,0x6d,0x17,0x2f,0x56,0x8c,0x73] as IID_IIterable_1_Windows_Storage_IStorageItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::provider::StorageProviderItemProperty> => [0x4584cb69,0xee26,0x59e0,0xb0,0x5d,0xc9,0xa7,0x85,0x1a,0x73,0x17] as IID_IIterable_1_Windows_Storage_Provider_StorageProviderItemProperty }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::provider::StorageProviderItemPropertyDefinition> => [0x41e78b90,0x1a7f,0x5dab,0xa1,0x23,0x7d,0x5f,0x50,0x11,0xdf,0xeb] as IID_IIterable_1_Windows_Storage_Provider_StorageProviderItemPropertyDefinition }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::provider::StorageProviderSyncRootInfo> => [0x62ba69a0,0xf65c,0x502c,0x97,0x82,0xb4,0xbc,0x25,0x19,0x4d,0x11] as IID_IIterable_1_Windows_Storage_Provider_StorageProviderSyncRootInfo }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::search::IIndexableContent> => [0x4a6edbfe,0x0c41,0x5042,0xac,0x58,0xa8,0x85,0xa8,0xfc,0x79,0x28] as IID_IIterable_1_Windows_Storage_Search_IIndexableContent }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::search::SortEntry> => [0x35aff6f9,0xef75,0x5280,0xbb,0x84,0xa2,0xbf,0x83,0x17,0xcf,0x35] as IID_IIterable_1_Windows_Storage_Search_SortEntry }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::StorageFile> => [0x9ac00304,0x83ea,0x5688,0x87,0xb6,0xae,0x38,0xaa,0xb6,0x5d,0x0b] as IID_IIterable_1_Windows_Storage_StorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::StorageFolder> => [0x4669befc,0xae5c,0x52b1,0x8a,0x97,0x54,0x66,0xce,0x61,0xe9,0x4e] as IID_IIterable_1_Windows_Storage_StorageFolder }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::StorageLibrary> => [0x851e3cfd,0x306b,0x5c8e,0xae,0x3c,0xa8,0xd8,0x3c,0x62,0x36,0x04] as IID_IIterable_1_Windows_Storage_StorageLibrary }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::StorageLibraryChange> => [0x87c15dfc,0x0c5e,0x518b,0x92,0x06,0x97,0xd3,0xd9,0x82,0x3c,0x61] as IID_IIterable_1_Windows_Storage_StorageLibraryChange }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::streams::IBuffer> => [0x902972bf,0xa984,0x5443,0xb1,0xc5,0x2f,0x04,0xa9,0x9e,0x1f,0xca] as IID_IIterable_1_Windows_Storage_Streams_IBuffer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterable<super::super::storage::streams::IRandomAccessStream> => [0xba666a00,0x1555,0x5df4,0x81,0xa5,0x07,0xd2,0x3f,0x7f,0xfc,0xeb] as IID_IIterable_1_Windows_Storage_Streams_IRandomAccessStream }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::AppDiagnosticInfo> => [0x8118de8f,0x3ae3,0x55e1,0x80,0xa8,0x25,0x45,0x3c,0xdb,0xa8,0x94] as IID_IIterable_1_Windows_System_AppDiagnosticInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::AppResourceGroupBackgroundTaskReport> => [0x3e7dcbca,0x1804,0x5672,0xad,0x3b,0x58,0xd9,0x44,0xbb,0x04,0x4c] as IID_IIterable_1_Windows_System_AppResourceGroupBackgroundTaskReport }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::AppResourceGroupInfo> => [0x8b640948,0xc0d3,0x5b7e,0xa9,0x9c,0x59,0x56,0x19,0x0d,0x54,0x08] as IID_IIterable_1_Windows_System_AppResourceGroupInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::diagnostics::ProcessDiagnosticInfo> => [0x97b73627,0xb296,0x5076,0xb8,0xcd,0x6b,0xd8,0xa2,0x40,0xe9,0x66] as IID_IIterable_1_Windows_System_Diagnostics_ProcessDiagnosticInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::diagnostics::tracereporting::PlatformDiagnosticTraceInfo> => [0xecb0c107,0xc97b,0x52fe,0xa5,0xe6,0xa3,0x3e,0x93,0x49,0x37,0x69] as IID_IIterable_1_Windows_System_Diagnostics_TraceReporting_PlatformDiagnosticTraceInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::remotesystems::IRemoteSystemFilter> => [0x13966c92,0xa8de,0x50c0,0xb1,0x6b,0x00,0xc2,0xc4,0x8f,0x5f,0x37] as IID_IIterable_1_Windows_System_RemoteSystems_IRemoteSystemFilter }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::remotesystems::RemoteSystemSessionParticipant> => [0x00189d10,0x16ec,0x5d1a,0x83,0x69,0x48,0x70,0xc6,0x9e,0x52,0xb3] as IID_IIterable_1_Windows_System_RemoteSystems_RemoteSystemSessionParticipant }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterable<super::super::system::User> => [0xd1bacd1f,0x0376,0x5823,0x8c,0x29,0x1d,0x45,0xb9,0xf4,0xc1,0x91] as IID_IIterable_1_Windows_System_User }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::applicationsettings::CredentialCommand> => [0x883ed18d,0x4dbb,0x58f2,0x8f,0xd2,0xe4,0xb0,0x18,0x50,0x95,0x53] as IID_IIterable_1_Windows_UI_ApplicationSettings_CredentialCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::applicationsettings::SettingsCommand> => [0x6308e7e8,0xcb85,0x5339,0xa3,0xe9,0x9a,0x75,0x00,0xd1,0x9c,0x68] as IID_IIterable_1_Windows_UI_ApplicationSettings_SettingsCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::applicationsettings::WebAccountCommand> => [0xbd0d999c,0xb2ba,0x51b2,0xbc,0xc0,0xd4,0xa5,0xcd,0x82,0x15,0x55] as IID_IIterable_1_Windows_UI_ApplicationSettings_WebAccountCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::applicationsettings::WebAccountProviderCommand> => [0x15165367,0x2e93,0x59a6,0xb5,0xc7,0x16,0xd3,0xb5,0x8f,0xd2,0xe7] as IID_IIterable_1_Windows_UI_ApplicationSettings_WebAccountProviderCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::Color> => [0x932eef5e,0x2c2f,0x5eae,0x92,0x9a,0x74,0xe9,0x73,0xb5,0x7c,0x27] as IID_IIterable_1_Windows_UI_Color }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::composition::interactions::CompositionConditionalValue> => [0xb268447b,0xf519,0x5ce5,0x89,0xcd,0xb7,0xe1,0xbc,0x56,0x52,0xee] as IID_IIterable_1_Windows_UI_Composition_Interactions_CompositionConditionalValue }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::composition::interactions::InteractionTrackerInertiaModifier> => [0x9a245c40,0xaae6,0x59fb,0x87,0xf5,0x4b,0xb0,0x55,0x99,0xf0,0xb1] as IID_IIterable_1_Windows_UI_Composition_Interactions_InteractionTrackerInertiaModifier }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::composition::interactions::InteractionTrackerVector2InertiaModifier> => [0x3aeacfd8,0xc7f1,0x580c,0xa2,0x3b,0x99,0x66,0x6e,0x42,0xe6,0x2b] as IID_IIterable_1_Windows_UI_Composition_Interactions_InteractionTrackerVector2InertiaModifier }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::core::animationmetrics::IPropertyAnimation> => [0xc75f1bd1,0xa3c1,0x5881,0x9d,0xa0,0x1e,0xcd,0xb8,0xe5,0x1b,0xc3] as IID_IIterable_1_Windows_UI_Core_AnimationMetrics_IPropertyAnimation }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::inking::analysis::IInkAnalysisNode> => [0x784f069e,0xbadd,0x5258,0xbd,0x8f,0x42,0xce,0x20,0x5c,0xc9,0x5a] as IID_IIterable_1_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::inking::InkPoint> => [0x0630c0ef,0xa4e2,0x5af6,0xb2,0xe9,0x8e,0x04,0x2e,0x29,0x4e,0x17] as IID_IIterable_1_Windows_UI_Input_Inking_InkPoint }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::inking::InkRecognitionResult> => [0xe29b658b,0x7cc1,0x561c,0x99,0x12,0x00,0x1d,0xbc,0xa8,0x66,0x51] as IID_IIterable_1_Windows_UI_Input_Inking_InkRecognitionResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::inking::InkRecognizer> => [0x611b7e84,0xa803,0x5071,0xaa,0xea,0x4f,0x2c,0xe0,0x15,0x10,0x52] as IID_IIterable_1_Windows_UI_Input_Inking_InkRecognizer }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::inking::InkStroke> => [0xbbc11401,0x89d0,0x5305,0xa3,0xb3,0x36,0xc8,0x87,0x71,0x4b,0x9b] as IID_IIterable_1_Windows_UI_Input_Inking_InkStroke }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::inking::InkStrokeRenderingSegment> => [0x27000f47,0x2885,0x5da9,0x89,0x23,0x16,0xa3,0xa5,0x8b,0x7a,0x55] as IID_IIterable_1_Windows_UI_Input_Inking_InkStrokeRenderingSegment }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::PointerPoint> => [0xf6f2cba6,0x7076,0x5b59,0x96,0x31,0xf6,0xac,0x32,0xb5,0x76,0x95] as IID_IIterable_1_Windows_UI_Input_PointerPoint }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::preview::injection::InjectedInputKeyboardInfo> => [0x15d6330f,0x9c97,0x5705,0xb6,0x77,0x87,0x25,0x85,0x66,0x4f,0xb5] as IID_IIterable_1_Windows_UI_Input_Preview_Injection_InjectedInputKeyboardInfo }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::preview::injection::InjectedInputMouseInfo> => [0x6c34e5bd,0x0fa4,0x5244,0x89,0xfb,0x04,0xbf,0xd4,0x80,0xec,0xd8] as IID_IIterable_1_Windows_UI_Input_Preview_Injection_InjectedInputMouseInfo }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::preview::injection::InjectedInputTouchInfo> => [0xac5fac0b,0x82a0,0x5436,0x92,0x84,0xe7,0xdb,0x0b,0xf4,0xe6,0x15] as IID_IIterable_1_Windows_UI_Input_Preview_Injection_InjectedInputTouchInfo }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::RadialControllerMenuItem> => [0x1aa752b3,0xdc11,0x5bce,0xb2,0xb9,0xcd,0x1b,0xf8,0xf2,0x35,0xbe] as IID_IIterable_1_Windows_UI_Input_RadialControllerMenuItem }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::RadialControllerSystemMenuItemKind> => [0x4516010f,0xfd98,0x5e1d,0xbf,0x3f,0xae,0xaf,0x79,0xf1,0xf3,0xda] as IID_IIterable_1_Windows_UI_Input_RadialControllerSystemMenuItemKind }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::input::spatial::SpatialInteractionSourceState> => [0x7ecce0f5,0x0874,0x506f,0x8d,0x42,0x4c,0x95,0x19,0x15,0x64,0x07] as IID_IIterable_1_Windows_UI_Input_Spatial_SpatialInteractionSourceState }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::AdaptiveNotificationText> => [0x0343e8f2,0xca4c,0x5f40,0xb8,0xd1,0x3f,0xf4,0x70,0x47,0xce,0x43] as IID_IIterable_1_Windows_UI_Notifications_AdaptiveNotificationText }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::NotificationBinding> => [0xe8d9489c,0x635e,0x5153,0x8a,0xb7,0x38,0x9f,0x2e,0xe9,0xfa,0xca] as IID_IIterable_1_Windows_UI_Notifications_NotificationBinding }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::ScheduledTileNotification> => [0x4b60d1e5,0x52ae,0x5766,0x97,0x20,0xbe,0x4a,0xd0,0x86,0xf9,0x52] as IID_IIterable_1_Windows_UI_Notifications_ScheduledTileNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::ScheduledToastNotification> => [0x7a7b2a51,0xc182,0x5846,0xa8,0x61,0x4f,0x9c,0x03,0x6f,0x24,0xad] as IID_IIterable_1_Windows_UI_Notifications_ScheduledToastNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::ShownTileNotification> => [0x1863baee,0x44f1,0x5e51,0xbc,0xdf,0xa3,0xcd,0xab,0x82,0x6a,0x15] as IID_IIterable_1_Windows_UI_Notifications_ShownTileNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::ToastCollection> => [0x8928d527,0xdb5d,0x5a10,0xae,0x9b,0x43,0x0f,0xa0,0x90,0x6e,0x74] as IID_IIterable_1_Windows_UI_Notifications_ToastCollection }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::ToastNotification> => [0x52c9428b,0xd37a,0x554d,0xbf,0x55,0xb8,0x68,0x5d,0x5f,0x55,0x2d] as IID_IIterable_1_Windows_UI_Notifications_ToastNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::notifications::UserNotification> => [0x18170480,0x1bd8,0x5cd0,0xbb,0x32,0x67,0xe7,0x1d,0x5b,0x4d,0x7c] as IID_IIterable_1_Windows_UI_Notifications_UserNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::popups::IUICommand> => [0xe63de42b,0x53c3,0x5e07,0x90,0xd3,0x98,0x17,0x2d,0x54,0x54,0x12] as IID_IIterable_1_Windows_UI_Popups_IUICommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::startscreen::JumpListItem> => [0x130a7274,0x1afb,0x5c10,0xab,0xea,0x61,0xd8,0x16,0x92,0xa4,0x96] as IID_IIterable_1_Windows_UI_StartScreen_JumpListItem }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::startscreen::SecondaryTile> => [0x75651af0,0x014a,0x5593,0xbc,0x48,0x83,0x6b,0xa3,0xd1,0xd5,0xd4] as IID_IIterable_1_Windows_UI_StartScreen_SecondaryTile }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::startscreen::SecondaryTileVisualElements> => [0x6ef7c354,0xf153,0x5b53,0x99,0xc2,0xe0,0x45,0xc7,0x8c,0xce,0x08] as IID_IIterable_1_Windows_UI_StartScreen_SecondaryTileVisualElements }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::text::core::CoreTextCompositionSegment> => [0x38372bd2,0xd3fe,0x5ad2,0x9d,0x39,0xd1,0x66,0xb6,0x8e,0x78,0xe7] as IID_IIterable_1_Windows_UI_Text_Core_CoreTextCompositionSegment }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterable<super::super::ui::viewmanagement::core::CoreInputViewOcclusion> => [0x0a11958b,0x63da,0x5566,0x91,0x3a,0x18,0x05,0x50,0xda,0xd2,0x6a] as IID_IIterable_1_Windows_UI_ViewManagement_Core_CoreInputViewOcclusion }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::automation::AutomationAnnotation> => [0xc6e210cb,0x1c7b,0x5e6a,0x93,0x6b,0x61,0xd4,0xe5,0x36,0xa2,0x91] as IID_IIterable_1_Windows_UI_Xaml_Automation_AutomationAnnotation }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::automation::peers::AutomationPeer> => [0x7f67a4e2,0x96e0,0x522b,0x87,0x10,0x14,0xc4,0x2d,0x83,0x4f,0x1e] as IID_IIterable_1_Windows_UI_Xaml_Automation_Peers_AutomationPeer }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::automation::peers::AutomationPeerAnnotation> => [0xdd28ff94,0xd11e,0x5ae7,0xb8,0x19,0x61,0x77,0xc1,0x59,0x93,0x13] as IID_IIterable_1_Windows_UI_Xaml_Automation_Peers_AutomationPeerAnnotation }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::ColumnDefinition> => [0xa99329f3,0x4130,0x55cc,0xa4,0xf0,0xc2,0xba,0x43,0xca,0x07,0x35] as IID_IIterable_1_Windows_UI_Xaml_Controls_ColumnDefinition }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::GroupStyle> => [0x89be2766,0x2a52,0x5790,0xad,0x0e,0xd5,0xca,0xe3,0x05,0xb0,0x7c] as IID_IIterable_1_Windows_UI_Xaml_Controls_GroupStyle }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::HubSection> => [0x558c4082,0x463a,0x5c3d,0xb5,0x1e,0x10,0x92,0x1b,0x4a,0x4d,0x6c] as IID_IIterable_1_Windows_UI_Xaml_Controls_HubSection }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::ICommandBarElement> => [0xd4c5a8e7,0x0d5e,0x5922,0xa7,0xb4,0x59,0xb5,0xe6,0x34,0xd3,0x35] as IID_IIterable_1_Windows_UI_Xaml_Controls_ICommandBarElement }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::maps::MapElement> => [0x81d25c25,0xa4b3,0x5d0d,0x92,0xab,0x26,0x36,0x0c,0x2a,0x7f,0xac] as IID_IIterable_1_Windows_UI_Xaml_Controls_Maps_MapElement }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::maps::MapLayer> => [0x508e2ce9,0x1984,0x5fc8,0xa4,0x91,0x62,0xe8,0x88,0x95,0x39,0xf4] as IID_IIterable_1_Windows_UI_Xaml_Controls_Maps_MapLayer }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::maps::MapRouteView> => [0x090ad4b3,0x8fce,0x502d,0x86,0x65,0x18,0x65,0x0c,0x51,0xbe,0xa9] as IID_IIterable_1_Windows_UI_Xaml_Controls_Maps_MapRouteView }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::maps::MapStyleSheet> => [0x05483d88,0x841c,0x5a0e,0xb9,0xc7,0x5d,0x82,0x8d,0x9f,0x2a,0xff] as IID_IIterable_1_Windows_UI_Xaml_Controls_Maps_MapStyleSheet }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::maps::MapTileSource> => [0x6d8a73f7,0xabd7,0x56c4,0x99,0xa7,0x06,0xc1,0xfa,0x77,0xdc,0xd2] as IID_IIterable_1_Windows_UI_Xaml_Controls_Maps_MapTileSource }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::MenuFlyoutItemBase> => [0x0bb14d64,0xcc9a,0x58ae,0xb8,0x81,0x73,0xfe,0x0e,0xcb,0x99,0xeb] as IID_IIterable_1_Windows_UI_Xaml_Controls_MenuFlyoutItemBase }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::primitives::Popup> => [0x0af05ce9,0x3b0f,0x5a6d,0xa0,0x53,0xd0,0x1a,0x1a,0x55,0x4f,0x8c] as IID_IIterable_1_Windows_UI_Xaml_Controls_Primitives_Popup }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::RowDefinition> => [0xabef522a,0x7378,0x504f,0x94,0x06,0x97,0xd9,0xf4,0x26,0x43,0xa7] as IID_IIterable_1_Windows_UI_Xaml_Controls_RowDefinition }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::controls::WebViewDeferredPermissionRequest> => [0x3981a977,0xda6c,0x5450,0x82,0x3e,0x7d,0xd2,0x3b,0x91,0xf2,0xbc] as IID_IIterable_1_Windows_UI_Xaml_Controls_WebViewDeferredPermissionRequest }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::data::ItemIndexRange> => [0x273b8073,0x8c16,0x59c2,0xa6,0x16,0x0a,0x53,0x44,0x83,0xc6,0x12] as IID_IIterable_1_Windows_UI_Xaml_Data_ItemIndexRange }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::DependencyObject> => [0xf66c6bd3,0x55b4,0x5bbb,0xb8,0x2a,0x6d,0x9c,0xe3,0x83,0x09,0x1a] as IID_IIterable_1_Windows_UI_Xaml_DependencyObject }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::documents::Block> => [0xf7023b9a,0xe6d1,0x5e2d,0x8f,0x41,0xb2,0x8c,0x33,0x32,0x3e,0x04] as IID_IIterable_1_Windows_UI_Xaml_Documents_Block }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::documents::Inline> => [0xe1d2b910,0x18c2,0x5906,0x8f,0x8a,0xd6,0x2a,0x63,0xf9,0x3f,0x18] as IID_IIterable_1_Windows_UI_Xaml_Documents_Inline }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::documents::TextHighlighter> => [0x4d7e043f,0x6697,0x599a,0xa1,0x3b,0x8d,0xde,0x71,0xd5,0x53,0x7d] as IID_IIterable_1_Windows_UI_Xaml_Documents_TextHighlighter }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::documents::TextRange> => [0x2ad42fdb,0x56db,0x500b,0x8e,0xa8,0x3d,0x57,0xed,0xfa,0xdf,0xc6] as IID_IIterable_1_Windows_UI_Xaml_Documents_TextRange }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::input::InputScopeName> => [0x81416296,0x95d0,0x5100,0xb5,0x9b,0xbe,0xa1,0xc2,0x7d,0x20,0x02] as IID_IIterable_1_Windows_UI_Xaml_Input_InputScopeName }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::input::KeyboardAccelerator> => [0xaf1e5ff1,0xd518,0x5521,0xb4,0x0e,0x6f,0x52,0x4d,0x04,0xc1,0x29] as IID_IIterable_1_Windows_UI_Xaml_Input_KeyboardAccelerator }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::input::Pointer> => [0x6cf9f859,0x2234,0x510d,0x86,0x0a,0xdb,0x32,0x80,0x30,0xcb,0xcc] as IID_IIterable_1_Windows_UI_Xaml_Input_Pointer }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::animation::ColorKeyFrame> => [0x1859dd08,0x582d,0x51dc,0x82,0xa1,0x46,0x61,0x11,0xca,0xf9,0x44] as IID_IIterable_1_Windows_UI_Xaml_Media_Animation_ColorKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::animation::DoubleKeyFrame> => [0x5f1676da,0xa405,0x5b7a,0xba,0xf1,0x96,0x8d,0xe4,0x39,0x1f,0xb7] as IID_IIterable_1_Windows_UI_Xaml_Media_Animation_DoubleKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::animation::ObjectKeyFrame> => [0x9084a8e1,0x8f4d,0x5de3,0xb1,0xc6,0xe5,0xf0,0x57,0x24,0xca,0xed] as IID_IIterable_1_Windows_UI_Xaml_Media_Animation_ObjectKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::animation::PointKeyFrame> => [0xb8de4dc9,0x8c69,0x55f3,0xaf,0x58,0x04,0x0f,0x13,0x19,0x64,0x9c] as IID_IIterable_1_Windows_UI_Xaml_Media_Animation_PointKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::animation::Timeline> => [0xa122a346,0xe6d5,0x5c54,0x85,0x7d,0x03,0x8e,0x60,0xf5,0xd9,0xc1] as IID_IIterable_1_Windows_UI_Xaml_Media_Animation_Timeline }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::animation::Transition> => [0xfeb51398,0x4fdb,0x5112,0x8a,0x9b,0x6a,0x87,0x86,0xca,0x01,0xce] as IID_IIterable_1_Windows_UI_Xaml_Media_Animation_Transition }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::Brush> => [0xb07e92d5,0x06b3,0x5dd2,0x8d,0x49,0x34,0x9f,0xfb,0xd8,0x46,0x34] as IID_IIterable_1_Windows_UI_Xaml_Media_Brush }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::Geometry> => [0x35340039,0x0dfc,0x52b4,0x87,0x48,0x0d,0x9a,0x75,0x5d,0xb8,0xa8] as IID_IIterable_1_Windows_UI_Xaml_Media_Geometry }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::GradientStop> => [0x9105bb93,0xac26,0x5bae,0x8c,0x1e,0xdf,0x8e,0xcf,0x00,0xde,0xe6] as IID_IIterable_1_Windows_UI_Xaml_Media_GradientStop }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::PathFigure> => [0xcd1dc421,0xd6e5,0x5b3f,0xa8,0xc7,0x99,0x38,0xf2,0x8b,0x29,0x95] as IID_IIterable_1_Windows_UI_Xaml_Media_PathFigure }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::PathSegment> => [0x37e2cb21,0xb9c9,0x5006,0xbe,0xd7,0x4c,0x32,0x89,0x81,0xb5,0x51] as IID_IIterable_1_Windows_UI_Xaml_Media_PathSegment }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::TimelineMarker> => [0x946c5af5,0x4c09,0x5784,0x9c,0xf2,0x50,0x69,0x47,0x37,0x8e,0x8e] as IID_IIterable_1_Windows_UI_Xaml_Media_TimelineMarker }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::Transform> => [0xfb8cacbc,0xd3ec,0x51b8,0x97,0x78,0x99,0xed,0xe8,0x46,0x36,0x11] as IID_IIterable_1_Windows_UI_Xaml_Media_Transform }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::media::XamlLight> => [0x03229ead,0x2ba2,0x5101,0x93,0x24,0xa2,0x64,0x9d,0xb7,0xe6,0x1d] as IID_IIterable_1_Windows_UI_Xaml_Media_XamlLight }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::navigation::PageStackEntry> => [0xdd2278a5,0x4c14,0x5967,0x8a,0x41,0x9a,0x47,0xc3,0xc5,0xc4,0xa7] as IID_IIterable_1_Windows_UI_Xaml_Navigation_PageStackEntry }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::ResourceDictionary> => [0xeaf20635,0xa462,0x5397,0xbe,0xe1,0xf7,0xa0,0x95,0x04,0x65,0x3b] as IID_IIterable_1_Windows_UI_Xaml_ResourceDictionary }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::StateTriggerBase> => [0x073325bc,0x8f0f,0x56d8,0xb5,0x21,0x6b,0xe4,0x76,0x44,0xc5,0x54] as IID_IIterable_1_Windows_UI_Xaml_StateTriggerBase }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::TriggerAction> => [0xa9d34579,0x8a6a,0x58bf,0x85,0xfd,0x0f,0x37,0x32,0x4e,0x23,0x97] as IID_IIterable_1_Windows_UI_Xaml_TriggerAction }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::TriggerBase> => [0xd697764f,0x4e15,0x5888,0xa2,0xa5,0x7b,0x4c,0xf0,0xeb,0x07,0xa5] as IID_IIterable_1_Windows_UI_Xaml_TriggerBase }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::UIElement> => [0x42e26ae1,0xd357,0x57e8,0xbb,0x48,0xf7,0x5c,0x9f,0xf6,0x9d,0x91] as IID_IIterable_1_Windows_UI_Xaml_UIElement }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::VisualState> => [0x1fb071a3,0xa064,0x5619,0xa9,0x4e,0x23,0xc0,0x1a,0x4c,0xbf,0x3a] as IID_IIterable_1_Windows_UI_Xaml_VisualState }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::VisualStateGroup> => [0x5d9ab411,0xe991,0x55b0,0xb1,0x6c,0xa4,0x00,0xa5,0x0a,0x93,0xdf] as IID_IIterable_1_Windows_UI_Xaml_VisualStateGroup }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterable<super::super::ui::xaml::VisualTransition> => [0x017a8eb0,0xe942,0x5f25,0xa9,0x45,0x20,0x5a,0x94,0x70,0xb9,0xfc] as IID_IIterable_1_Windows_UI_Xaml_VisualTransition }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::atompub::ResourceCollection> => [0xd4372a2d,0x7ab0,0x5d8e,0xbd,0x5c,0x6e,0x9c,0x0a,0x67,0xa8,0xd8] as IID_IIterable_1_Windows_Web_AtomPub_ResourceCollection }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::atompub::Workspace> => [0xf02d0ebe,0xeac2,0x502f,0x98,0x36,0x1c,0x54,0x82,0x33,0x3b,0xfe] as IID_IIterable_1_Windows_Web_AtomPub_Workspace }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::http::diagnostics::HttpDiagnosticSourceLocation> => [0x4286ca1a,0xa4c5,0x5ae8,0x9d,0xa9,0x5b,0xfa,0x24,0x76,0x8e,0x22] as IID_IIterable_1_Windows_Web_Http_Diagnostics_HttpDiagnosticSourceLocation }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::http::headers::HttpNameValueHeaderValue> => [0x5838a126,0xb617,0x5417,0xb3,0x2e,0xde,0xd2,0xd2,0x7d,0x40,0xa3] as IID_IIterable_1_Windows_Web_Http_Headers_HttpNameValueHeaderValue }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::http::HttpCookie> => [0x0eb9fa36,0x88de,0x590d,0x8e,0xa0,0xb6,0x13,0xd0,0xab,0x01,0x5f] as IID_IIterable_1_Windows_Web_Http_HttpCookie }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::syndication::ISyndicationNode> => [0xb486569a,0x72b3,0x57aa,0x99,0x50,0xce,0xa0,0xb3,0xe4,0xfc,0x58] as IID_IIterable_1_Windows_Web_Syndication_ISyndicationNode }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::syndication::SyndicationAttribute> => [0x329eabe1,0xefcc,0x539e,0x96,0xba,0xf6,0xa4,0x4f,0x22,0x1d,0xbd] as IID_IIterable_1_Windows_Web_Syndication_SyndicationAttribute }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::syndication::SyndicationCategory> => [0xd151f7d1,0xeabd,0x5300,0xb5,0x5c,0x14,0x9e,0xb2,0x89,0xcc,0x71] as IID_IIterable_1_Windows_Web_Syndication_SyndicationCategory }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::syndication::SyndicationItem> => [0x55463eef,0xecb8,0x59cd,0x8d,0x6b,0x74,0xda,0xac,0xbe,0x7d,0x19] as IID_IIterable_1_Windows_Web_Syndication_SyndicationItem }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::syndication::SyndicationLink> => [0xc6919f6a,0x66d9,0x556a,0x96,0x32,0x87,0xd3,0x9a,0xf1,0x46,0x38] as IID_IIterable_1_Windows_Web_Syndication_SyndicationLink }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::syndication::SyndicationPerson> => [0xe58e7844,0xeb34,0x5284,0xb0,0x9e,0xde,0x67,0x62,0xd5,0x48,0xca] as IID_IIterable_1_Windows_Web_Syndication_SyndicationPerson }
#[cfg(feature="windows-web")] RT_PINTERFACE!{ for IIterable<super::super::web::WebErrorStatus> => [0x7b7f182e,0xa6ce,0x556b,0x9a,0x2e,0xef,0x97,0x66,0x2f,0x2a,0xee] as IID_IIterable_1_Windows_Web_WebErrorStatus }
RT_PINTERFACE!{ for IIterable<super::TimeSpan> => [0xe9f78726,0x829a,0x5f67,0x8d,0x19,0x95,0xef,0x15,0x4b,0x77,0x42] as IID_IIterable_1_Windows_Foundation_TimeSpan }
RT_PINTERFACE!{ for IIterable<super::Uri> => [0xb0d63b78,0x78ad,0x5e31,0xb6,0xd8,0xe3,0x2a,0x0e,0x16,0xc4,0x47] as IID_IIterable_1_Windows_Foundation_Uri }
RT_PINTERFACE!{ for IIterable<u32> => [0x421d4b91,0xb13b,0x5f37,0xae,0x54,0xb5,0x24,0x9b,0xd8,0x05,0x39] as IID_IIterable_1_System_UInt32 }
RT_PINTERFACE!{ for IIterable<u8> => [0x88318266,0xf3fd,0x50fc,0x8f,0x08,0xb8,0x23,0xa4,0x1b,0x60,0xc1] as IID_IIterable_1_System_Byte }
RT_PINTERFACE!{ for IIterator<bool> => [0x740a0296,0xa535,0x572a,0xbf,0x0b,0x17,0xc1,0x8f,0xf7,0x1f,0xe6] as IID_IIterator_1_System_Boolean }
RT_PINTERFACE!{ for IIterator<f32> => [0x42614e61,0xb0aa,0x5e72,0x93,0x54,0x27,0x71,0xdb,0x20,0xb7,0xa8] as IID_IIterator_1_System_Single }
RT_PINTERFACE!{ for IIterator<f64> => [0x638a2cf4,0xf474,0x5318,0x90,0x55,0x14,0x1c,0xb9,0x09,0xac,0x4b] as IID_IIterator_1_System_Double }
RT_PINTERFACE!{ for IIterator<Guid> => [0xd3d64048,0x82b3,0x53c7,0x92,0x85,0xb0,0xbe,0x18,0x36,0x84,0x82] as IID_IIterator_1_System_Guid }
RT_PINTERFACE!{ for IIterator<HString> => [0x8c304ebb,0x6615,0x50a4,0x88,0x29,0x87,0x9e,0xcd,0x44,0x32,0x36] as IID_IIterator_1_System_String }
RT_PINTERFACE!{ for IIterator<i32> => [0xbfea7f78,0x50c2,0x5f1d,0xa6,0xea,0x9e,0x97,0x8d,0x26,0x99,0xff] as IID_IIterator_1_System_Int32 }
RT_PINTERFACE!{ for IIterator<IInspectable> => [0x44a94f2d,0x04f8,0x5091,0xb3,0x36,0xbe,0x78,0x92,0xdd,0x10,0xbe] as IID_IIterator_1_System_Object }
RT_PINTERFACE!{ for IIterator<IIterable<super::Point>> => [0x377f6162,0x6e4d,0x574e,0xbf,0x01,0x77,0xf4,0xfd,0x02,0x1d,0x0e] as IID_IIterator_1_Windows_Foundation_Collections_IIterable_1_Windows_Foundation_Point }
RT_PINTERFACE!{ for IIterator<IKeyValuePair<Guid, IInspectable>> => [0x4f25059a,0x0b9a,0x5f25,0x9b,0x9e,0x4b,0x9f,0x1d,0x22,0xff,0x65] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_System_Object }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<Guid, super::super::applicationmodel::background::BackgroundTaskRegistration>> => [0x8445d2ae,0xdd03,0x5b98,0x95,0xe4,0x82,0xb4,0x3a,0x3f,0x0d,0x64] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_Windows_ApplicationModel_Background_BackgroundTaskRegistration }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<Guid, super::super::applicationmodel::background::IBackgroundTaskRegistration>> => [0x2001aea5,0x1a86,0x517e,0x8b,0xe5,0x11,0xd7,0xfb,0x59,0x35,0xb2] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_Windows_ApplicationModel_Background_IBackgroundTaskRegistration }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<Guid, super::super::perception::spatial::surfaces::SpatialSurfaceInfo>> => [0x6d328390,0xf279,0x5f39,0x96,0x82,0xbb,0xa0,0xcd,0x81,0x48,0x9b] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Guid_Windows_Perception_Spatial_Surfaces_SpatialSurfaceInfo }
RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, HString>> => [0x05eb86f1,0x7140,0x5517,0xb8,0x8d,0xcb,0xae,0xbe,0x57,0xe6,0xb1] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_System_String }
RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, IInspectable>> => [0x5db5fa32,0x707c,0x5849,0xa0,0x6b,0x91,0xc8,0xeb,0x9d,0x10,0xe8] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_System_Object }
RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, IVector<HString>>> => [0xa11824c9,0xe458,0x502a,0xaf,0xd8,0xce,0x3c,0xe0,0xab,0xd6,0xfe] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Foundation_Collections_IVector_1_System_String }
RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, IVectorView<HString>>> => [0x643b6d83,0x457e,0x5a43,0x80,0x0f,0xb0,0x44,0x9f,0x91,0xd9,0x6b] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Foundation_Collections_IVectorView_1_System_String }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, IVectorView<super::super::data::text::TextSegment>>> => [0x00078aa3,0x8676,0x5f06,0xad,0xf5,0xff,0xe5,0xd6,0x61,0xd6,0x70] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Foundation_Collections_IVectorView_1_Windows_Data_Text_TextSegment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::background::BackgroundTaskRegistrationGroup>> => [0x4c21744b,0xb583,0x559d,0x89,0xf7,0xd4,0x13,0x8c,0xff,0xff,0xbc] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Background_BackgroundTaskRegistrationGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::chat::ChatMessageStatus>> => [0x5b099e05,0x07e2,0x5346,0xb0,0x75,0xf4,0x29,0x7b,0x3e,0x30,0x8b] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Chat_ChatMessageStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::resources::core::NamedResource>> => [0x7fdcc3d7,0xe13e,0x5f76,0xaf,0xc6,0x07,0x69,0xc4,0x08,0x63,0x99] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Resources_Core_NamedResource }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::resources::core::ResourceMap>> => [0x28cf8d5e,0x69f6,0x59f6,0x98,0x65,0xbc,0xa9,0x7d,0x59,0xf7,0x4f] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Resources_Core_ResourceMap }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::store::licensemanagement::LicenseSatisfactionInfo>> => [0x168d4306,0xe80a,0x5e37,0xae,0x46,0x2c,0xee,0xcd,0xd7,0xfc,0x9a] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Store_LicenseManagement_LicenseSatisfactionInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::store::ProductLicense>> => [0x3f3c06e6,0x593f,0x557a,0x8e,0x3c,0x45,0x51,0x3a,0xc0,0x1f,0x7c] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Store_ProductLicense }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::store::ProductListing>> => [0x142a6937,0x1ae1,0x5aad,0x8a,0xda,0x9a,0x8e,0xe0,0x34,0xe4,0xeb] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Store_ProductListing }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::voicecommands::VoiceCommandDefinition>> => [0x91fbb58b,0xfb9c,0x5165,0xa1,0xbf,0x81,0x5d,0x27,0x67,0x30,0x0d] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_VoiceCommands_VoiceCommandDefinition }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletItemCustomProperty>> => [0xc66d71b4,0x4336,0x5693,0x83,0x6e,0x49,0x15,0x30,0x3c,0x18,0x3b] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletItemCustomProperty }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletRelevantLocation>> => [0xb5d9a611,0x5f2c,0x542c,0xae,0x58,0x27,0x67,0x53,0xbb,0xf8,0xc7] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletRelevantLocation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletTransaction>> => [0x75f5591e,0x31a9,0x50e9,0xb9,0xd0,0x37,0x3b,0x1e,0xb0,0xd6,0xb6] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletTransaction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::applicationmodel::wallet::WalletVerb>> => [0x93b2ca58,0xf717,0x56e6,0xa9,0x45,0x85,0x13,0xc4,0x8f,0x91,0x5c] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_ApplicationModel_Wallet_WalletVerb }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::devices::bluetooth::background::GattServiceProviderConnection>> => [0x6faf610e,0xcf1e,0x50e4,0xb1,0xcc,0xf3,0x22,0xfc,0xf2,0x50,0x36] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Devices_Bluetooth_Background_GattServiceProviderConnection }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::graphics::imaging::BitmapTypedValue>> => [0x2ad3fb0c,0x0656,0x5302,0xb5,0x04,0x31,0x53,0xbe,0x84,0x51,0x61] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Graphics_Imaging_BitmapTypedValue }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::graphics::printing::optiondetails::IPrintOptionDetails>> => [0x7bef6011,0x58a1,0x5523,0x8e,0x2a,0x30,0x9f,0x8c,0xb1,0xbd,0x39] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Graphics_Printing_OptionDetails_IPrintOptionDetails }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::media::capture::frames::MediaFrameSource>> => [0xd8ec36b7,0x64eb,0x5675,0xad,0x81,0x62,0x23,0x3e,0x48,0x3e,0x17] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Media_Capture_Frames_MediaFrameSource }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::networking::sockets::SocketActivityInformation>> => [0xf656f7a2,0x264b,0x5cfd,0x82,0x88,0x64,0xeb,0x89,0x45,0x51,0x57] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Networking_Sockets_SocketActivityInformation }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::perception::spatial::SpatialAnchor>> => [0x67a5f318,0x0232,0x5900,0xac,0x7e,0x5c,0x64,0x7d,0x73,0x1c,0xbc] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Perception_Spatial_SpatialAnchor }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::services::store::StoreLicense>> => [0xa1509348,0x6522,0x5062,0xae,0x86,0xcf,0x59,0x54,0x75,0x92,0x6d] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Services_Store_StoreLicense }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::services::store::StoreProduct>> => [0x0edb142c,0x9d04,0x532b,0x81,0xe9,0x4c,0x84,0xab,0x09,0xb3,0x4b] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Services_Store_StoreProduct }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::services::targetedcontent::TargetedContentValue>> => [0xb97e682b,0x6e0a,0x5eea,0xb7,0x0b,0x25,0x79,0x5b,0x28,0xe9,0x37] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Services_TargetedContent_TargetedContentValue }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::storage::ApplicationDataContainer>> => [0xaf3c131d,0x67aa,0x5c8d,0xae,0x0e,0x27,0x2b,0xa2,0x4a,0xe7,0x4f] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Storage_ApplicationDataContainer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::storage::streams::IBuffer>> => [0x790acb62,0xc4b3,0x57ea,0xa1,0x52,0x9e,0x21,0x93,0x71,0xc6,0xdc] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Storage_Streams_IBuffer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<HString, super::super::storage::streams::RandomAccessStreamReference>> => [0x9419af53,0xacb8,0x5328,0x88,0x53,0x70,0xba,0x87,0xeb,0x6a,0xd5] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_String_Windows_Storage_Streams_RandomAccessStreamReference }
RT_PINTERFACE!{ for IIterator<IKeyValuePair<IInspectable, IInspectable>> => [0x31e55e8a,0x0f05,0x52fd,0x90,0xd3,0xb0,0x4a,0xa3,0x31,0xaa,0xa4] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_Object_System_Object }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<super::super::devices::sensors::PedometerStepKind, super::super::devices::sensors::PedometerReading>> => [0x3e88fe66,0xd4a7,0x5658,0xb5,0xcf,0x1a,0x39,0xe1,0xfc,0x41,0x65] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_Windows_Devices_Sensors_PedometerStepKind_Windows_Devices_Sensors_PedometerReading }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<IKeyValuePair<u32, super::super::storage::streams::IBuffer>> => [0xa295fa0c,0xc99f,0x5109,0x8a,0xb9,0x91,0x53,0x4b,0xb4,0x8c,0x9b] as IID_IIterator_1_Windows_Foundation_Collections_IKeyValuePair_2_System_UInt32_Windows_Storage_Streams_IBuffer }
RT_PINTERFACE!{ for IIterator<IMapView<HString, IInspectable>> => [0x53a2e825,0x9bf1,0x5083,0x8a,0x7b,0x9d,0x94,0xf3,0x12,0xda,0xde] as IID_IIterator_1_Windows_Foundation_Collections_IMapView_2_System_String_System_Object }
RT_PINTERFACE!{ for IIterator<super::DateTime> => [0xf56158df,0x8947,0x5480,0x96,0xed,0x36,0xc1,0x05,0x78,0x77,0xea] as IID_IIterator_1_Windows_Foundation_DateTime }
RT_PINTERFACE!{ for IIterator<super::Point> => [0xc602b59e,0x0a8e,0x5e99,0xb4,0x78,0x2b,0x56,0x45,0x85,0x27,0x8d] as IID_IIterator_1_Windows_Foundation_Point }
RT_PINTERFACE!{ for IIterator<super::Size> => [0xa3508ee0,0x3527,0x5144,0x89,0x4d,0x42,0x2e,0xad,0xef,0x43,0xd7] as IID_IIterator_1_Windows_Foundation_Size }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::appextensions::AppExtension> => [0x8e80ca83,0x3cd3,0x5f9c,0x83,0xe4,0x84,0x34,0x7c,0xa5,0x49,0x8c] as IID_IIterator_1_Windows_ApplicationModel_AppExtensions_AppExtension }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::AppInfo> => [0x69cec62c,0x41eb,0x5d69,0xa4,0x75,0x29,0xee,0x22,0x32,0x3d,0xd8] as IID_IIterator_1_Windows_ApplicationModel_AppInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::appointments::Appointment> => [0x386a5922,0x49fc,0x53b6,0x8b,0xed,0x4c,0x9f,0xf9,0xfe,0x6e,0x01] as IID_IIterator_1_Windows_ApplicationModel_Appointments_Appointment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::appointments::AppointmentCalendar> => [0xf40a879d,0xb6b7,0x5f92,0xbe,0xb1,0x6a,0x8e,0x7c,0xe5,0x41,0x20] as IID_IIterator_1_Windows_ApplicationModel_Appointments_AppointmentCalendar }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::appointments::AppointmentException> => [0xe58c63db,0xd9d5,0x5fa5,0x87,0x90,0x29,0x84,0x6d,0xe5,0x4f,0xa4] as IID_IIterator_1_Windows_ApplicationModel_Appointments_AppointmentException }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::appointments::AppointmentInvitee> => [0x57e35198,0x1b41,0x54da,0xad,0xaf,0x50,0xef,0x1e,0x93,0xfd,0xed] as IID_IIterator_1_Windows_ApplicationModel_Appointments_AppointmentInvitee }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::appointments::AppointmentStoreChange> => [0x16a427bf,0xe5b0,0x5662,0x92,0x79,0xca,0xa8,0xed,0x84,0x81,0xa6] as IID_IIterator_1_Windows_ApplicationModel_Appointments_AppointmentStoreChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::calls::PhoneCallHistoryEntry> => [0xc1cf3870,0x064a,0x54d5,0xaf,0xab,0xd1,0xdc,0x4e,0xe2,0x6c,0xcb] as IID_IIterator_1_Windows_ApplicationModel_Calls_PhoneCallHistoryEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::ChatConversation> => [0x7007a155,0x47ca,0x59c8,0xbf,0x1e,0x96,0x0b,0x82,0x15,0x99,0x07] as IID_IIterator_1_Windows_ApplicationModel_Chat_ChatConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::ChatMessage> => [0xcd3c8682,0x2366,0x5646,0x9a,0xf5,0xbc,0xb9,0xc3,0xbe,0x9e,0xbe] as IID_IIterator_1_Windows_ApplicationModel_Chat_ChatMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::ChatMessageAttachment> => [0xbc37f8a5,0xcd61,0x5054,0xa8,0x97,0x6d,0x40,0x2b,0x56,0xb5,0x8b] as IID_IIterator_1_Windows_ApplicationModel_Chat_ChatMessageAttachment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::ChatMessageChange> => [0xdf6e6b4f,0x3e45,0x52cd,0xaa,0xde,0x33,0x16,0x89,0x6a,0xba,0xd0] as IID_IIterator_1_Windows_ApplicationModel_Chat_ChatMessageChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::ChatMessageTransport> => [0x98ebffc3,0xef5f,0x58ac,0x96,0x95,0x04,0x7a,0x96,0xc3,0xf0,0xb0] as IID_IIterator_1_Windows_ApplicationModel_Chat_ChatMessageTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::ChatRecipientDeliveryInfo> => [0x3a7b0f38,0xecd7,0x55f8,0xa5,0xc5,0xe0,0x3d,0x43,0xa3,0x97,0x8e] as IID_IIterator_1_Windows_ApplicationModel_Chat_ChatRecipientDeliveryInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::IChatItem> => [0x5d2c1b3f,0x9bc7,0x5126,0x93,0xcd,0xf5,0x23,0x26,0x49,0x4d,0xe1] as IID_IIterator_1_Windows_ApplicationModel_Chat_IChatItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::RcsEndUserMessageAction> => [0x75a37f34,0xd87d,0x555c,0x8e,0x64,0xa1,0xea,0x48,0xa3,0xdd,0x20] as IID_IIterator_1_Windows_ApplicationModel_Chat_RcsEndUserMessageAction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::chat::RcsTransport> => [0xa4eda5fb,0xfb99,0x56a7,0x89,0x48,0x95,0xc6,0x68,0xa3,0xed,0x3c] as IID_IIterator_1_Windows_ApplicationModel_Chat_RcsTransport }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::Contact> => [0xa572c173,0x800a,0x58bb,0xab,0x24,0x17,0x99,0x59,0xdf,0x28,0x13] as IID_IIterator_1_Windows_ApplicationModel_Contacts_Contact }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactAddress> => [0xd9003f84,0x63df,0x5c0c,0xbd,0x1e,0x2c,0xcd,0xea,0x55,0xe7,0x17] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactAddress }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactAnnotation> => [0x77bc5ee1,0x7130,0x5876,0x9d,0x30,0x1f,0x93,0x06,0xcc,0x22,0x6a] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactAnnotation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactAnnotationList> => [0x3d7b4ad2,0xbb54,0x5e21,0xa9,0x2e,0x6b,0x80,0x26,0x4c,0xcc,0x50] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactAnnotationList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactChange> => [0xcd1a34ad,0x16df,0x572c,0xb5,0xcd,0x52,0x6e,0xb3,0x04,0x4f,0xce] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactConnectedServiceAccount> => [0x3ef1863f,0xc859,0x5b9d,0x8e,0x35,0x20,0xad,0xf1,0x02,0xa4,0x0d] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactConnectedServiceAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactDate> => [0x5004bf96,0x5349,0x5b10,0x87,0xc6,0xc7,0x6f,0x21,0xf2,0xa1,0xd5] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactDate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactEmail> => [0xd64ce66d,0x2936,0x5a1e,0xb8,0xf5,0x08,0x0b,0xb1,0x35,0x60,0x22] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactEmail }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactField> => [0xaa226af5,0xfaa5,0x5353,0x87,0x1c,0x53,0x80,0x99,0xb7,0xc8,0x36] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactFieldType> => [0x2f6d856a,0x50d4,0x5173,0xab,0xea,0xdb,0x6c,0x6b,0x8f,0xc5,0x30] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactFieldType }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactGroup> => [0x86dac457,0x7314,0x5044,0x81,0x08,0x75,0x29,0x0c,0x36,0xdd,0x2b] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactInformation> => [0x7b77b895,0xabee,0x5501,0x94,0xdb,0xce,0x4e,0x48,0xa9,0xa3,0x4f] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactInformation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactInstantMessageField> => [0x65e069e6,0x28d1,0x5d57,0x9f,0xe1,0x80,0xff,0x64,0x85,0x0e,0x67] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactInstantMessageField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactJobInfo> => [0x0873df73,0xac99,0x50ef,0x86,0x73,0xe7,0x8f,0x8a,0x54,0x0e,0x2e] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactJobInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactList> => [0xee69382d,0x887d,0x5964,0x83,0xb4,0x47,0xee,0x9d,0xed,0x6f,0x05] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactLocationField> => [0xa20407d7,0x6980,0x5c4f,0xb9,0x93,0xf1,0xda,0x03,0x99,0x41,0x05] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactLocationField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactMatchReason> => [0x4ae36741,0xbbde,0x5bd6,0x9d,0x4f,0x0d,0x57,0xb1,0x41,0x0e,0x4e] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactMatchReason }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactPhone> => [0x603b190e,0x1fb6,0x5762,0xbd,0x8a,0xf5,0x9e,0x95,0x27,0x26,0xf7] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactPhone }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactSignificantOther> => [0x2051d4fa,0xbd46,0x52eb,0xb2,0xd0,0x4e,0xb5,0xda,0xc1,0x21,0x57] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactSignificantOther }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::ContactWebsite> => [0x91a59fa2,0x5cc1,0x564d,0xbb,0x1d,0xf5,0x2d,0xae,0xc1,0x36,0xad] as IID_IIterator_1_Windows_ApplicationModel_Contacts_ContactWebsite }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::contacts::IContactField> => [0xc501c1b3,0x171b,0x5320,0x8d,0x84,0xc3,0xa8,0x9a,0x3d,0x40,0x34] as IID_IIterator_1_Windows_ApplicationModel_Contacts_IContactField }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::core::AppListEntry> => [0xb93e2028,0x50bc,0x599e,0xb3,0xd9,0x42,0x7b,0x61,0xd2,0x6c,0x01] as IID_IIterator_1_Windows_ApplicationModel_Core_AppListEntry }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::core::CoreApplicationView> => [0x4f5f6944,0x264b,0x5868,0x80,0x9e,0xc7,0xac,0x1a,0xc5,0xed,0xad] as IID_IIterator_1_Windows_ApplicationModel_Core_CoreApplicationView }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::datatransfer::ShareProvider> => [0x886f5642,0xe9f9,0x573b,0x92,0x13,0x58,0x40,0xb5,0x06,0x2b,0x40] as IID_IIterator_1_Windows_ApplicationModel_DataTransfer_ShareProvider }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailAttachment> => [0x44655b88,0x9a99,0x5994,0x8e,0x0f,0x5b,0x96,0x40,0x92,0x41,0x20] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailAttachment }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailCertificateValidationStatus> => [0x1cfe3d41,0x16a5,0x5026,0xa6,0xfe,0x2c,0xb0,0xa3,0x03,0xa6,0x05] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailCertificateValidationStatus }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailConversation> => [0xfadada27,0xe629,0x5a34,0xb2,0xe9,0x1d,0x25,0xc9,0x35,0x44,0xb5] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailConversation }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailFolder> => [0x95ae5494,0x43bc,0x5f6b,0xa0,0x2b,0xb6,0x95,0x6d,0x0c,0x70,0x69] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailFolder }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailMailbox> => [0x312f8d4a,0x0e85,0x566e,0xb7,0xaa,0xdb,0xd4,0x0a,0x03,0x43,0xff] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailMailbox }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailMailboxAction> => [0xb9d8eec0,0xf0e0,0x5a4d,0x88,0xd0,0x75,0x8a,0xcb,0xc6,0x38,0x0f] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailMailboxAction }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailMailboxChange> => [0xb2b91198,0x5f8b,0x5e4a,0x85,0xf8,0xdd,0xca,0x82,0xba,0x0b,0x7f] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailMailboxChange }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailMessage> => [0xca569bf8,0xd6d7,0x5411,0x96,0x00,0xab,0x95,0xec,0x06,0x5c,0x72] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailMessage }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailRecipient> => [0x12238d88,0x1a2f,0x5e7a,0x89,0xb1,0x8d,0xc1,0x40,0x53,0x6b,0xac] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailRecipient }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::email::EmailRecipientResolutionResult> => [0x5c040cd6,0x9593,0x5e74,0x9a,0x5e,0x72,0x84,0xcd,0x1b,0x72,0x00] as IID_IIterator_1_Windows_ApplicationModel_Email_EmailRecipientResolutionResult }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::lockscreen::LockScreenBadge> => [0x8d38f924,0x154d,0x5705,0x8f,0x0b,0xed,0x61,0x35,0x3f,0x6c,0xe2] as IID_IIterator_1_Windows_ApplicationModel_LockScreen_LockScreenBadge }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::Package> => [0x0217f069,0x025c,0x5ee6,0xa8,0x7f,0xe7,0x82,0xe3,0xb6,0x23,0xae] as IID_IIterator_1_Windows_ApplicationModel_Package }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::PackageContentGroup> => [0x5f23d323,0x28f5,0x560f,0xa4,0x0e,0x6f,0x38,0x27,0xf8,0x2e,0x9f] as IID_IIterator_1_Windows_ApplicationModel_PackageContentGroup }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::payments::PaymentDetailsModifier> => [0xfafb6774,0xb665,0x5b8b,0xb1,0xef,0x95,0x03,0x8c,0x3a,0xab,0xe1] as IID_IIterator_1_Windows_ApplicationModel_Payments_PaymentDetailsModifier }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::payments::PaymentItem> => [0x93c12cc3,0x6a0b,0x5f02,0xac,0x74,0x05,0x60,0x07,0x47,0x27,0x31] as IID_IIterator_1_Windows_ApplicationModel_Payments_PaymentItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::payments::PaymentMethodData> => [0x9666522e,0xe5ac,0x5374,0xa5,0xd9,0x5c,0xf5,0x7c,0x4b,0xf6,0x89] as IID_IIterator_1_Windows_ApplicationModel_Payments_PaymentMethodData }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::payments::PaymentShippingOption> => [0x49edc9f4,0x2ce6,0x534c,0xb5,0x29,0x5c,0xee,0xc7,0x05,0xde,0xf5] as IID_IIterator_1_Windows_ApplicationModel_Payments_PaymentShippingOption }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::resources::core::NamedResource> => [0x0c5a605f,0xa7f1,0x5030,0xa1,0x79,0x9f,0xd3,0x63,0xca,0xf3,0xb5] as IID_IIterator_1_Windows_ApplicationModel_Resources_Core_NamedResource }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::resources::core::ResourceCandidate> => [0xe151bd8c,0xa286,0x57ab,0xbc,0xea,0x79,0xb7,0xbc,0x26,0x87,0xa1] as IID_IIterator_1_Windows_ApplicationModel_Resources_Core_ResourceCandidate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::resources::core::ResourceMap> => [0x3dedcae6,0xd048,0x5eaa,0xaf,0xa2,0xfb,0x4a,0x79,0x70,0xef,0x68] as IID_IIterator_1_Windows_ApplicationModel_Resources_Core_ResourceMap }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::resources::core::ResourceQualifier> => [0xfedb74db,0xe74f,0x597a,0xb9,0xbf,0x70,0x4b,0x0d,0xad,0xca,0x38] as IID_IIterator_1_Windows_ApplicationModel_Resources_Core_ResourceQualifier }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::resources::management::IndexedResourceCandidate> => [0x6b6f3ab9,0x1593,0x5852,0xb6,0xbb,0x17,0xa2,0x17,0xe1,0x2f,0x9f] as IID_IIterator_1_Windows_ApplicationModel_Resources_Management_IndexedResourceCandidate }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::resources::management::IndexedResourceQualifier> => [0x1a22ebee,0x7992,0x5198,0x97,0x2b,0x05,0x45,0x80,0x94,0x57,0x41] as IID_IIterator_1_Windows_ApplicationModel_Resources_Management_IndexedResourceQualifier }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::search::core::SearchSuggestion> => [0xc3157582,0xf72f,0x513a,0xb0,0x89,0x62,0x08,0x18,0x8e,0xc2,0xb6] as IID_IIterator_1_Windows_ApplicationModel_Search_Core_SearchSuggestion }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::socialinfo::SocialFeedItem> => [0xe7c8cd1f,0x3907,0x5da8,0x9d,0x72,0x90,0x42,0x6d,0xc3,0x70,0x72] as IID_IIterator_1_Windows_ApplicationModel_SocialInfo_SocialFeedItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::socialinfo::SocialItemThumbnail> => [0xfabcf39f,0xfd48,0x5550,0x8f,0x47,0xa0,0xf1,0x57,0x3e,0x1f,0x53] as IID_IIterator_1_Windows_ApplicationModel_SocialInfo_SocialItemThumbnail }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::StartupTask> => [0x14653598,0x9065,0x508e,0xb3,0x7b,0x44,0xeb,0x28,0xd5,0x1c,0xb7] as IID_IIterator_1_Windows_ApplicationModel_StartupTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::store::preview::installcontrol::AppInstallItem> => [0xccaca81b,0x6cf7,0x56f0,0xb7,0xff,0x8a,0xc5,0x19,0x1e,0x79,0xbf] as IID_IIterator_1_Windows_ApplicationModel_Store_Preview_InstallControl_AppInstallItem }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::store::preview::StorePreviewProductInfo> => [0x3fb16dec,0x73f1,0x5cfa,0x80,0xe6,0x67,0xfa,0x23,0x2d,0x1b,0xef] as IID_IIterator_1_Windows_ApplicationModel_Store_Preview_StorePreviewProductInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::store::preview::StorePreviewSkuInfo> => [0xb6f9b421,0x7f54,0x5d26,0x9c,0x37,0x9f,0x9d,0x7a,0xc8,0x93,0xeb] as IID_IIterator_1_Windows_ApplicationModel_Store_Preview_StorePreviewSkuInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::store::preview::StoreSystemFeature> => [0xd0455b2d,0xd8aa,0x557e,0x89,0xa3,0x63,0xc3,0x3e,0x8c,0xee,0x99] as IID_IIterator_1_Windows_ApplicationModel_Store_Preview_StoreSystemFeature }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::store::UnfulfilledConsumable> => [0xcb77cf2e,0xef57,0x5256,0x97,0x53,0x21,0x4b,0xaa,0xda,0x23,0x01] as IID_IIterator_1_Windows_ApplicationModel_Store_UnfulfilledConsumable }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::userdataaccounts::provider::UserDataAccountPartnerAccountInfo> => [0xac401b26,0x3ebf,0x5cbf,0x96,0x43,0xc9,0x6a,0x40,0xab,0x40,0xa2] as IID_IIterator_1_Windows_ApplicationModel_UserDataAccounts_Provider_UserDataAccountPartnerAccountInfo }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::userdataaccounts::systemaccess::DeviceAccountConfiguration> => [0x51705a87,0x8dcb,0x5971,0x8d,0x6b,0xca,0x8a,0xe6,0xa9,0x55,0xad] as IID_IIterator_1_Windows_ApplicationModel_UserDataAccounts_SystemAccess_DeviceAccountConfiguration }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::userdataaccounts::UserDataAccount> => [0xe38246ab,0xdf01,0x5d16,0x92,0x3a,0x17,0xc8,0x8c,0xdb,0xac,0x29] as IID_IIterator_1_Windows_ApplicationModel_UserDataAccounts_UserDataAccount }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::userdatatasks::UserDataTask> => [0x98733fc7,0x1908,0x532f,0xbf,0xe3,0x38,0x68,0x44,0x5d,0x29,0xd6] as IID_IIterator_1_Windows_ApplicationModel_UserDataTasks_UserDataTask }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::userdatatasks::UserDataTaskList> => [0x8e989bcb,0x9d7c,0x512f,0x89,0xda,0xfd,0xb7,0x55,0x32,0xd6,0x65] as IID_IIterator_1_Windows_ApplicationModel_UserDataTasks_UserDataTaskList }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::voicecommands::VoiceCommandContentTile> => [0x968d589c,0x0710,0x52f0,0x85,0xed,0x11,0x2f,0xac,0x4c,0xff,0x35] as IID_IIterator_1_Windows_ApplicationModel_VoiceCommands_VoiceCommandContentTile }
#[cfg(feature="windows-applicationmodel")] RT_PINTERFACE!{ for IIterator<super::super::applicationmodel::wallet::WalletItem> => [0xe3ceb002,0xc2dd,0x5e63,0x91,0x3c,0xd7,0xd5,0x77,0x56,0x1e,0x73] as IID_IIterator_1_Windows_ApplicationModel_Wallet_WalletItem }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterator<super::super::data::text::AlternateWordForm> => [0x7f463f8a,0xe08f,0x516e,0xb4,0xb8,0x81,0xb5,0x41,0x7b,0xfb,0x58] as IID_IIterator_1_Windows_Data_Text_AlternateWordForm }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterator<super::super::data::text::SelectableWordSegment> => [0xa5842459,0x147d,0x5a88,0x8f,0x23,0xa3,0x39,0x8a,0xfd,0x8a,0x85] as IID_IIterator_1_Windows_Data_Text_SelectableWordSegment }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterator<super::super::data::text::TextPhoneme> => [0x36426c36,0xb5c4,0x5d1b,0xa4,0x68,0xaf,0xf3,0xb4,0x8b,0x7c,0x3a] as IID_IIterator_1_Windows_Data_Text_TextPhoneme }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterator<super::super::data::text::TextSegment> => [0x645a39b4,0xf001,0x5272,0x90,0x15,0xfb,0x4a,0x32,0x71,0x79,0xae] as IID_IIterator_1_Windows_Data_Text_TextSegment }
#[cfg(feature="windows-data")] RT_PINTERFACE!{ for IIterator<super::super::data::text::WordSegment> => [0xaeb846b3,0x664b,0x545e,0xab,0x93,0xf5,0xfc,0x66,0xd2,0x4e,0x32] as IID_IIterator_1_Windows_Data_Text_WordSegment }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::adc::AdcController> => [0xa10b62c1,0xa014,0x5335,0x88,0x67,0x74,0x7f,0xca,0xb1,0x60,0x05] as IID_IIterator_1_Windows_Devices_Adc_AdcController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::adc::provider::IAdcControllerProvider> => [0xb43acf15,0xa24a,0x5b00,0xb7,0x10,0x17,0x37,0xba,0x55,0x0a,0x18] as IID_IIterator_1_Windows_Devices_Adc_Provider_IAdcControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::alljoyn::AllJoynAuthenticationMechanism> => [0x0fbc36d2,0xf46e,0x5a4d,0xaa,0x10,0x4c,0x80,0x6b,0x49,0x45,0xd6] as IID_IIterator_1_Windows_Devices_AllJoyn_AllJoynAuthenticationMechanism }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementBytePattern> => [0xb33e103a,0x1a61,0x5107,0x88,0x13,0xc0,0xe9,0x05,0xc0,0x54,0x86] as IID_IIterator_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementBytePattern }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementDataSection> => [0xaf5c0e81,0x788b,0x52d4,0x82,0xa2,0x1e,0xd2,0x8c,0x66,0xa0,0x5e] as IID_IIterator_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementDataSection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::advertisement::BluetoothLEAdvertisementReceivedEventArgs> => [0x096edbb8,0xecef,0x5724,0xbe,0x62,0x24,0x0d,0xcf,0xf6,0xac,0xa9] as IID_IIterator_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEAdvertisementReceivedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::advertisement::BluetoothLEManufacturerData> => [0x12f158dd,0x7016,0x5338,0xac,0x5c,0x7d,0x55,0x03,0xd7,0x32,0x74] as IID_IIterator_1_Windows_Devices_Bluetooth_Advertisement_BluetoothLEManufacturerData }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattCharacteristic> => [0x1ffc4777,0x4346,0x5564,0xb7,0xa5,0x59,0xea,0xe3,0x85,0xf4,0xf6] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattCharacteristic }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattClientNotificationResult> => [0xfca87386,0xa3ab,0x55e2,0xa8,0x3e,0x21,0xf5,0xbf,0xab,0x40,0x49] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattClientNotificationResult }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattDescriptor> => [0x3d8df436,0xcefb,0x5ffb,0x85,0x8c,0x48,0x82,0xce,0x1d,0xa0,0x79] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattDeviceService> => [0x8beb3a26,0x73ca,0x50f3,0xa1,0xd3,0x41,0x8c,0x60,0xa9,0xf3,0xb2] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattLocalCharacteristic> => [0xedd74875,0x8e85,0x546f,0x83,0xb8,0x1e,0x00,0xaa,0x89,0x64,0x19] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalCharacteristic }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattLocalDescriptor> => [0x08023045,0x5f5c,0x59cc,0xab,0xd3,0xbb,0xcf,0xe6,0xfa,0x70,0x30] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattLocalDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattPresentationFormat> => [0x20006c53,0x5dda,0x5319,0x91,0xb1,0xc6,0xf2,0x8f,0xe6,0x59,0x33] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattPresentationFormat }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattSubscribedClient> => [0xdf039115,0xa5ff,0x5d5a,0xb0,0x7b,0x20,0xb4,0x2e,0x07,0x87,0x65] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattSubscribedClient }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::genericattributeprofile::GattValueChangedEventArgs> => [0xcd20a796,0xaa22,0x521d,0x8e,0x0f,0xfc,0x6d,0x4a,0x18,0xe2,0x87] as IID_IIterator_1_Windows_Devices_Bluetooth_GenericAttributeProfile_GattValueChangedEventArgs }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::bluetooth::rfcomm::RfcommDeviceService> => [0x64ab0132,0xc64c,0x5a87,0x81,0x13,0x61,0x3e,0xf3,0x56,0x92,0x4c] as IID_IIterator_1_Windows_Devices_Bluetooth_Rfcomm_RfcommDeviceService }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::enumeration::DeviceClass> => [0xc3807283,0x1416,0x593c,0x95,0x5c,0x0b,0x4a,0x28,0x6f,0xf7,0xbb] as IID_IIterator_1_Windows_Devices_Enumeration_DeviceClass }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::enumeration::DeviceInformation> => [0x6f85d843,0xe8ab,0x5b46,0x85,0xd7,0x32,0x7c,0x58,0xd1,0x87,0x12] as IID_IIterator_1_Windows_Devices_Enumeration_DeviceInformation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::enumeration::DeviceWatcherEvent> => [0x74f7d6cc,0x9c20,0x5bb9,0xba,0xce,0xb2,0xff,0xa3,0x86,0x87,0xf9] as IID_IIterator_1_Windows_Devices_Enumeration_DeviceWatcherEvent }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::enumeration::DeviceWatcherEventKind> => [0xcb5ca9db,0xccd6,0x5103,0xa9,0x3d,0xc9,0x25,0xc9,0x08,0x83,0x8d] as IID_IIterator_1_Windows_Devices_Enumeration_DeviceWatcherEventKind }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::enumeration::pnp::PnpObject> => [0x6bb6d2f1,0xb5fb,0x57f0,0x82,0x51,0xf2,0x0c,0xde,0x5a,0x68,0x71] as IID_IIterator_1_Windows_Devices_Enumeration_Pnp_PnpObject }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::BasicGeoposition> => [0x1b4e26a1,0x88e4,0x5872,0xbb,0x2d,0x4f,0x31,0x70,0x08,0x28,0xb2] as IID_IIterator_1_Windows_Devices_Geolocation_BasicGeoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::geofencing::Geofence> => [0xe7a9e144,0x202d,0x5708,0xa9,0xbd,0xe3,0xdc,0x0e,0x14,0xdf,0x46] as IID_IIterator_1_Windows_Devices_Geolocation_Geofencing_Geofence }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::geofencing::GeofenceStateChangeReport> => [0xeaff2de4,0x6650,0x544a,0xb7,0xac,0x6d,0x5b,0x81,0x9d,0x46,0x98] as IID_IIterator_1_Windows_Devices_Geolocation_Geofencing_GeofenceStateChangeReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::Geopath> => [0xcf1d4402,0x4754,0x57e7,0xaa,0xe0,0x69,0xca,0x42,0xcb,0xd8,0xf2] as IID_IIterator_1_Windows_Devices_Geolocation_Geopath }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::Geopoint> => [0x88225b39,0x8be9,0x5c03,0x97,0x14,0x8f,0x16,0x42,0xd8,0xa4,0x3f] as IID_IIterator_1_Windows_Devices_Geolocation_Geopoint }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::Geoposition> => [0xa99b4206,0x263e,0x5308,0x82,0xf2,0x31,0x31,0x5c,0x65,0x13,0x5c] as IID_IIterator_1_Windows_Devices_Geolocation_Geoposition }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::geolocation::Geovisit> => [0xf525fc34,0xb058,0x5345,0x8e,0x28,0x3e,0x69,0xe5,0xf5,0x90,0x70] as IID_IIterator_1_Windows_Devices_Geolocation_Geovisit }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::gpio::GpioChangeRecord> => [0xa4c620b9,0xcb89,0x5a25,0xbf,0x16,0x5f,0x41,0x2c,0x1a,0x33,0x88] as IID_IIterator_1_Windows_Devices_Gpio_GpioChangeRecord }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::gpio::GpioController> => [0x67944db0,0x6c56,0x5a2f,0x9e,0x7b,0x63,0xca,0x1a,0xa8,0xc4,0x11] as IID_IIterator_1_Windows_Devices_Gpio_GpioController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::gpio::provider::IGpioControllerProvider> => [0x6ac0edb9,0xe3c9,0x5840,0x8a,0xa8,0x1b,0xc4,0x53,0x66,0xf6,0xca] as IID_IIterator_1_Windows_Devices_Gpio_Provider_IGpioControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::haptics::SimpleHapticsController> => [0x3c501ba4,0xeda4,0x5238,0xbd,0xb7,0xd1,0x0b,0xa3,0x50,0xcd,0x83] as IID_IIterator_1_Windows_Devices_Haptics_SimpleHapticsController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::haptics::SimpleHapticsControllerFeedback> => [0xb7d297d6,0x9666,0x5c9e,0x9d,0xcc,0x5c,0x38,0x2e,0xae,0x67,0x50] as IID_IIterator_1_Windows_Devices_Haptics_SimpleHapticsControllerFeedback }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::haptics::VibrationDevice> => [0x24e9b323,0xeef1,0x533f,0xad,0x38,0xde,0x8f,0xc8,0xca,0x56,0x92] as IID_IIterator_1_Windows_Devices_Haptics_VibrationDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::humaninterfacedevice::HidBooleanControl> => [0x5cde3c23,0xd054,0x53d6,0xab,0xf1,0x41,0xe7,0x33,0x79,0xb4,0x72] as IID_IIterator_1_Windows_Devices_HumanInterfaceDevice_HidBooleanControl }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::humaninterfacedevice::HidBooleanControlDescription> => [0x203203b0,0xb7f4,0x542d,0xb0,0xd0,0x9c,0xaa,0x1f,0xb5,0x5d,0x7f] as IID_IIterator_1_Windows_Devices_HumanInterfaceDevice_HidBooleanControlDescription }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::humaninterfacedevice::HidCollection> => [0xcefcee70,0xc7ff,0x57c1,0xa6,0x75,0xa0,0xdf,0x89,0x76,0xa9,0x88] as IID_IIterator_1_Windows_Devices_HumanInterfaceDevice_HidCollection }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::humaninterfacedevice::HidNumericControlDescription> => [0x52b9c36e,0x7d95,0x5d1c,0xac,0xab,0x23,0xc1,0x9e,0xa7,0x6f,0x01] as IID_IIterator_1_Windows_Devices_HumanInterfaceDevice_HidNumericControlDescription }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::i2c::I2cController> => [0x8f6822fc,0xe4ea,0x5b35,0x93,0x9a,0x27,0xf3,0xb3,0xd5,0x50,0xd2] as IID_IIterator_1_Windows_Devices_I2c_I2cController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::i2c::provider::II2cControllerProvider> => [0xf6232961,0xc660,0x50a1,0x82,0xe8,0x12,0x89,0x2f,0xcd,0x91,0xf7] as IID_IIterator_1_Windows_Devices_I2c_Provider_II2cControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::input::PointerDevice> => [0xde94641c,0x7960,0x5fcd,0xab,0xe8,0xd6,0xba,0x60,0x9e,0xf7,0xd3] as IID_IIterator_1_Windows_Devices_Input_PointerDevice }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::input::PointerDeviceUsage> => [0x9ab2160d,0x11ef,0x5eca,0x8d,0xd9,0x3e,0x13,0xaa,0x4e,0x5f,0x99] as IID_IIterator_1_Windows_Devices_Input_PointerDeviceUsage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::perception::PerceptionColorFrameSource> => [0x24089f00,0xba6d,0x50d4,0xac,0x46,0xf2,0x88,0x75,0x5e,0x41,0x81] as IID_IIterator_1_Windows_Devices_Perception_PerceptionColorFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::perception::PerceptionDepthFrameSource> => [0x20cff8c2,0x7844,0x54e5,0xae,0x4f,0x57,0xe7,0x76,0x8f,0x9b,0x69] as IID_IIterator_1_Windows_Devices_Perception_PerceptionDepthFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::perception::PerceptionInfraredFrameSource> => [0xb22b294f,0xa4d2,0x5726,0xa7,0xfc,0x5e,0x33,0x14,0x32,0xd9,0xb4] as IID_IIterator_1_Windows_Devices_Perception_PerceptionInfraredFrameSource }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::perception::PerceptionVideoProfile> => [0x38ce8062,0x7079,0x5d7b,0x84,0x1f,0x9a,0xa4,0x58,0x0f,0xd5,0xf1] as IID_IIterator_1_Windows_Devices_Perception_PerceptionVideoProfile }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::perception::provider::PerceptionCorrelation> => [0xc4db1093,0xd705,0x5503,0x8b,0xce,0x68,0x53,0x5c,0xd4,0x2f,0xfa] as IID_IIterator_1_Windows_Devices_Perception_Provider_PerceptionCorrelation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::pointofservice::PosPrinterRotation> => [0xf687ef7c,0xb11e,0x56c3,0x91,0x58,0xe6,0xba,0x15,0xbd,0x52,0x1b] as IID_IIterator_1_Windows_Devices_PointOfService_PosPrinterRotation }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::pwm::provider::IPwmControllerProvider> => [0x90389702,0xf036,0x56e1,0xa9,0x4f,0x6d,0x99,0xd5,0x2b,0x95,0x78] as IID_IIterator_1_Windows_Devices_Pwm_Provider_IPwmControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::pwm::PwmController> => [0x599330bd,0xb0ca,0x533e,0x93,0x8f,0x5d,0xd4,0x24,0x2b,0xf5,0x13] as IID_IIterator_1_Windows_Devices_Pwm_PwmController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::radios::Radio> => [0xcf37ede7,0xeaec,0x5b8f,0xad,0x31,0x4d,0x51,0xab,0xd9,0xdb,0x05] as IID_IIterator_1_Windows_Devices_Radios_Radio }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sensors::ActivitySensorReading> => [0xd2dab535,0x0c94,0x547e,0xaf,0xe3,0x55,0x27,0xbc,0xbe,0xb9,0xcc] as IID_IIterator_1_Windows_Devices_Sensors_ActivitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sensors::ActivitySensorReadingChangeReport> => [0x9c07034e,0x8333,0x59d5,0x8d,0x60,0x0e,0x3f,0x04,0x38,0xac,0x12] as IID_IIterator_1_Windows_Devices_Sensors_ActivitySensorReadingChangeReport }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sensors::ActivityType> => [0x40524281,0xa7c6,0x50b1,0xb6,0xf5,0x0b,0xaa,0x95,0xd9,0x02,0xc2] as IID_IIterator_1_Windows_Devices_Sensors_ActivityType }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sensors::PedometerReading> => [0x0ac70ed3,0x8553,0x5ef3,0x92,0xf8,0x43,0x86,0x09,0x62,0x30,0x87] as IID_IIterator_1_Windows_Devices_Sensors_PedometerReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sensors::ProximitySensorReading> => [0x1d4f08df,0x7f49,0x573b,0x93,0x6a,0x6d,0x4d,0x4e,0x61,0x09,0x30] as IID_IIterator_1_Windows_Devices_Sensors_ProximitySensorReading }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCard> => [0x86b29903,0x916e,0x5817,0xbc,0x96,0xdf,0x32,0x44,0x75,0xe3,0x1a] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCard }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardAppletIdGroupRegistration> => [0xd3777a61,0x2106,0x505f,0xbc,0xfa,0xb3,0xcc,0x8e,0x14,0x12,0xe1] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardAppletIdGroupRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardAutomaticResponseApdu> => [0x78eb5c52,0x9dd2,0x5e35,0xa8,0x68,0xf6,0x49,0x19,0xeb,0xa6,0xb6] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardAutomaticResponseApdu }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramAlgorithm> => [0x4f1e0492,0xdab2,0x53c3,0xb5,0xfb,0xc4,0xb4,0x37,0x3b,0x1e,0xc2] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramAlgorithm }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramMaterialCharacteristics> => [0xe2a912a1,0x6133,0x571c,0xb0,0xa9,0x2a,0xaa,0xb2,0x83,0xa0,0x7a] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialCharacteristics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramMaterialPackageCharacteristics> => [0xb78e40b2,0x70f0,0x5e34,0xaa,0x8c,0xca,0x75,0xa1,0xb3,0xb1,0xbf] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPackageCharacteristics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramMaterialPackageConfirmationResponseFormat> => [0x9d1091ae,0xbe37,0x5be7,0x8e,0xdf,0x60,0xc5,0x16,0x48,0x80,0xb6] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPackageConfirmationResponseFormat }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramMaterialPackageFormat> => [0x7bf75a02,0xee7e,0x513a,0x80,0xf8,0xf7,0xd8,0xf0,0x04,0xc9,0x07] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialPackageFormat }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramMaterialType> => [0x97e1414d,0x439a,0x5dc2,0x81,0xfc,0xd9,0x88,0xe3,0x2c,0x8d,0xab] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramMaterialType }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramPlacementStep> => [0x81a62a70,0x8acd,0x598c,0x8d,0x0a,0xa2,0x7d,0x23,0xe6,0xcb,0x1e] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramPlacementStep }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramStorageKeyCapabilities> => [0xc858d7a0,0xc54e,0x513c,0xa0,0x97,0xa4,0x2f,0xd3,0xd5,0x69,0xaf] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramStorageKeyCapabilities }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::smartcards::SmartCardCryptogramStorageKeyCharacteristics> => [0xc65f0917,0x372c,0x5157,0x80,0xe2,0x2c,0xfb,0xd6,0x5e,0x8f,0xea] as IID_IIterator_1_Windows_Devices_SmartCards_SmartCardCryptogramStorageKeyCharacteristics }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sms::ISmsBinaryMessage> => [0x13e60d89,0xea0a,0x5b01,0x9c,0x2f,0x0e,0x5b,0x43,0x50,0x58,0xe0] as IID_IIterator_1_Windows_Devices_Sms_ISmsBinaryMessage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sms::ISmsMessage> => [0xeed04f5c,0xb2b2,0x5c83,0x8b,0x13,0xc7,0x8a,0xf6,0xca,0x3a,0x18] as IID_IIterator_1_Windows_Devices_Sms_ISmsMessage }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sms::SmsBroadcastType> => [0x6448ddea,0xc1cd,0x5143,0xa4,0x22,0x5f,0xe4,0xf0,0x08,0xcc,0x92] as IID_IIterator_1_Windows_Devices_Sms_SmsBroadcastType }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sms::SmsFilterRule> => [0xfec7cae6,0x97f5,0x5a19,0xb3,0x2a,0xd8,0xf0,0xba,0x27,0x6f,0x34] as IID_IIterator_1_Windows_Devices_Sms_SmsFilterRule }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::sms::SmsMessageRegistration> => [0xee1a0675,0xf3c9,0x5c12,0x93,0xe0,0xf2,0xb0,0x1b,0xdc,0xe6,0x11] as IID_IIterator_1_Windows_Devices_Sms_SmsMessageRegistration }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::spi::provider::ISpiControllerProvider> => [0xcf1d15d3,0xa6c8,0x56dd,0x80,0xc8,0xe8,0xd9,0x60,0x26,0x22,0x77] as IID_IIterator_1_Windows_Devices_Spi_Provider_ISpiControllerProvider }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::spi::SpiController> => [0xfd7d5997,0x544c,0x5be9,0xb0,0xfa,0x1d,0x0e,0xfb,0xfc,0x4a,0x03] as IID_IIterator_1_Windows_Devices_Spi_SpiController }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbBulkInEndpointDescriptor> => [0xea511030,0x89c4,0x503d,0x8c,0xaf,0x66,0x7f,0x42,0x30,0xd2,0xa9] as IID_IIterator_1_Windows_Devices_Usb_UsbBulkInEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbBulkInPipe> => [0xd7af2c5b,0x528d,0x5cbb,0xa9,0x97,0xd8,0x30,0xad,0xe7,0x04,0xc7] as IID_IIterator_1_Windows_Devices_Usb_UsbBulkInPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbBulkOutEndpointDescriptor> => [0xa8b89ab3,0x883d,0x5361,0x99,0x03,0xf4,0x89,0xcc,0x62,0xbe,0xa5] as IID_IIterator_1_Windows_Devices_Usb_UsbBulkOutEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbBulkOutPipe> => [0x46dd2f6a,0x573b,0x5c45,0xb1,0x68,0x92,0x23,0x03,0x84,0x91,0xdd] as IID_IIterator_1_Windows_Devices_Usb_UsbBulkOutPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbDescriptor> => [0x521598ed,0x0167,0x528e,0x99,0x0d,0x52,0xab,0xb7,0x12,0xf0,0x72] as IID_IIterator_1_Windows_Devices_Usb_UsbDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbInterface> => [0x216b5a5f,0x63e3,0x5a9b,0x9c,0x99,0xb0,0x9c,0xbc,0x0f,0xf3,0xb1] as IID_IIterator_1_Windows_Devices_Usb_UsbInterface }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbInterfaceSetting> => [0x71267ec7,0x5697,0x5dea,0xb2,0xf8,0x14,0xcf,0x69,0x8e,0xc0,0xad] as IID_IIterator_1_Windows_Devices_Usb_UsbInterfaceSetting }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbInterruptInEndpointDescriptor> => [0x6717500f,0xec1c,0x5b12,0xbf,0x33,0x0e,0x3e,0x3d,0x24,0x45,0x87] as IID_IIterator_1_Windows_Devices_Usb_UsbInterruptInEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbInterruptInPipe> => [0xe3a7b1c0,0x74f6,0x5292,0xa2,0x2a,0x67,0x2a,0xa2,0xb4,0x99,0x85] as IID_IIterator_1_Windows_Devices_Usb_UsbInterruptInPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbInterruptOutEndpointDescriptor> => [0x4b6426db,0xdb32,0x5b51,0xad,0xad,0x04,0x53,0x2e,0xa9,0x4a,0xcd] as IID_IIterator_1_Windows_Devices_Usb_UsbInterruptOutEndpointDescriptor }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::usb::UsbInterruptOutPipe> => [0xcbd8d8a8,0x2286,0x5cbd,0xa6,0xe4,0x96,0x27,0x42,0xff,0xd9,0x1a] as IID_IIterator_1_Windows_Devices_Usb_UsbInterruptOutPipe }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::wifi::WiFiAdapter> => [0x144136c6,0xb502,0x5a52,0x90,0xfc,0x22,0xa0,0x93,0x18,0xf9,0x32] as IID_IIterator_1_Windows_Devices_WiFi_WiFiAdapter }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::wifi::WiFiAvailableNetwork> => [0x468677c4,0xebb9,0x5196,0x83,0x6d,0x72,0xfa,0xa9,0xfe,0x67,0x3e] as IID_IIterator_1_Windows_Devices_WiFi_WiFiAvailableNetwork }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::wifi::WiFiWpsKind> => [0x9b19593c,0x602d,0x57d9,0xa8,0x52,0xa4,0x8a,0x82,0x04,0xff,0x42] as IID_IIterator_1_Windows_Devices_WiFi_WiFiWpsKind }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::wifidirect::services::WiFiDirectServiceConfigurationMethod> => [0x19889f5e,0x49ae,0x5e31,0xb0,0x59,0x08,0x3f,0x9f,0x15,0x32,0xc3] as IID_IIterator_1_Windows_Devices_WiFiDirect_Services_WiFiDirectServiceConfigurationMethod }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::wifidirect::WiFiDirectConfigurationMethod> => [0x201940f9,0xa368,0x57f4,0x9e,0xf2,0x3f,0x64,0xe2,0x43,0xe0,0xa4] as IID_IIterator_1_Windows_Devices_WiFiDirect_WiFiDirectConfigurationMethod }
#[cfg(feature="windows-devices")] RT_PINTERFACE!{ for IIterator<super::super::devices::wifidirect::WiFiDirectInformationElement> => [0xcf806026,0xc915,0x553e,0xaf,0x3c,0x8d,0xa4,0x38,0x71,0xb6,0x93] as IID_IIterator_1_Windows_Devices_WiFiDirect_WiFiDirectInformationElement }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::ArcadeStick> => [0xd30629af,0xcc9d,0x52e1,0x8b,0x1f,0x0f,0xfa,0x96,0x29,0xaf,0xee] as IID_IIterator_1_Windows_Gaming_Input_ArcadeStick }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::FlightStick> => [0xf5fa1919,0x3f18,0x5560,0xbb,0x13,0xcf,0x70,0x18,0xac,0x41,0xd5] as IID_IIterator_1_Windows_Gaming_Input_FlightStick }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::forcefeedback::ForceFeedbackMotor> => [0x64cf69e0,0x5464,0x5b72,0xbd,0x4b,0x82,0xf7,0xc3,0xd0,0x38,0x6d] as IID_IIterator_1_Windows_Gaming_Input_ForceFeedback_ForceFeedbackMotor }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::Gamepad> => [0x246737e8,0x12bc,0x5c64,0xaf,0x52,0x06,0xdb,0x4b,0x13,0xfa,0x2f] as IID_IIterator_1_Windows_Gaming_Input_Gamepad }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::RacingWheel> => [0x23d735b8,0x4d36,0x5377,0xa2,0x45,0x69,0xdf,0x97,0xc9,0xfc,0xd9] as IID_IIterator_1_Windows_Gaming_Input_RacingWheel }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::RawGameController> => [0x51cc88dc,0x66fb,0x55ea,0x9a,0x1b,0xaa,0xdc,0xd7,0x1c,0xc0,0x8e] as IID_IIterator_1_Windows_Gaming_Input_RawGameController }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::input::UINavigationController> => [0xc10b2696,0x64a3,0x5262,0xbc,0x4f,0xb7,0x41,0xe5,0xd5,0xaf,0xab] as IID_IIterator_1_Windows_Gaming_Input_UINavigationController }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::preview::gamesenumeration::GameListEntry> => [0xed5b903e,0x5aeb,0x5d8c,0x95,0x38,0x83,0x06,0xf0,0x29,0x26,0xc3] as IID_IIterator_1_Windows_Gaming_Preview_GamesEnumeration_GameListEntry }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::xboxlive::storage::GameSaveBlobInfo> => [0xaaaf545b,0xf5e9,0x5da6,0xaf,0x70,0x9d,0x90,0x4c,0x7a,0x4d,0x37] as IID_IIterator_1_Windows_Gaming_XboxLive_Storage_GameSaveBlobInfo }
#[cfg(feature="windows-gaming")] RT_PINTERFACE!{ for IIterator<super::super::gaming::xboxlive::storage::GameSaveContainerInfo> => [0x0ecd9756,0x3e0d,0x523f,0xa5,0x49,0x2b,0x65,0x04,0xdb,0x52,0x02] as IID_IIterator_1_Windows_Gaming_XboxLive_Storage_GameSaveContainerInfo }
#[cfg(feature="windows-globalization")] RT_PINTERFACE!{ for IIterator<super::super::globalization::JapanesePhoneme> => [0xf15ca7e7,0x69a8,0x564d,0x9c,0x20,0x4d,0xa7,0x5a,0x77,0x34,0x32] as IID_IIterator_1_Windows_Globalization_JapanesePhoneme }
#[cfg(feature="windows-globalization")] RT_PINTERFACE!{ for IIterator<super::super::globalization::Language> => [0x30e99ae6,0xf414,0x5243,0x8d,0xb2,0xaa,0xb3,0x8e,0xa3,0xf1,0xf1] as IID_IIterator_1_Windows_Globalization_Language }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::directx::direct3d11::IDirect3DSurface> => [0xbdfb6d0b,0xe785,0x5d5a,0xab,0xd2,0xfe,0x1b,0x18,0xc4,0x32,0x57] as IID_IIterator_1_Windows_Graphics_DirectX_Direct3D11_IDirect3DSurface }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::directx::DirectXPixelFormat> => [0xea016190,0xac80,0x5840,0x8f,0x58,0xff,0x43,0x4c,0x7b,0x29,0x07] as IID_IIterator_1_Windows_Graphics_DirectX_DirectXPixelFormat }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::display::core::HdmiDisplayMode> => [0xd66eb831,0xe22c,0x5ee3,0xaf,0x45,0xe1,0xc0,0x3d,0xe4,0xbc,0x62] as IID_IIterator_1_Windows_Graphics_Display_Core_HdmiDisplayMode }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::holographic::HolographicCamera> => [0x6acc8576,0x2fea,0x561d,0x84,0xdd,0x4a,0x1a,0xb0,0x5f,0xc7,0xed] as IID_IIterator_1_Windows_Graphics_Holographic_HolographicCamera }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::holographic::HolographicCameraPose> => [0x93e27fb4,0x332b,0x591e,0xae,0x6b,0x61,0x92,0xfa,0x0a,0x10,0x09] as IID_IIterator_1_Windows_Graphics_Holographic_HolographicCameraPose }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::holographic::HolographicQuadLayer> => [0x85765170,0x495b,0x541c,0xae,0xf0,0x74,0x92,0x85,0x6d,0xe3,0xdf] as IID_IIterator_1_Windows_Graphics_Holographic_HolographicQuadLayer }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::imaging::BitmapCodecInformation> => [0x4ff2b2db,0x9326,0x537f,0xb8,0xdc,0x4c,0x93,0xd7,0x7f,0xbb,0x84] as IID_IIterator_1_Windows_Graphics_Imaging_BitmapCodecInformation }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::imaging::BitmapPixelFormat> => [0x7fc2e293,0x1084,0x5d45,0xb8,0xb8,0x93,0xe1,0x06,0x92,0xbc,0xc8] as IID_IIterator_1_Windows_Graphics_Imaging_BitmapPixelFormat }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::imaging::ImageStream> => [0x4a10752d,0x6b1a,0x5fec,0xa5,0x9c,0x70,0x38,0x9b,0xf1,0x62,0xa2] as IID_IIterator_1_Windows_Graphics_Imaging_ImageStream }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::imaging::SoftwareBitmap> => [0xcd12e4c3,0x8ca8,0x5be6,0xb6,0x4b,0x20,0x4a,0x01,0x4f,0xc6,0x20] as IID_IIterator_1_Windows_Graphics_Imaging_SoftwareBitmap }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing::printticket::PrintTicketOption> => [0xc92a35e2,0x829d,0x5adf,0x87,0x4e,0x4d,0x74,0x5b,0x4e,0xf0,0xaa] as IID_IIterator_1_Windows_Graphics_Printing_PrintTicket_PrintTicketOption }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DBaseMaterial> => [0xdad4dd0d,0x59ab,0x501f,0x9d,0x6b,0xa2,0x09,0xc7,0xd5,0x46,0x49] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DBaseMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DBaseMaterialGroup> => [0xa34dc709,0xe2a7,0x5254,0x9d,0xc1,0xcd,0x47,0xe8,0x5e,0x25,0x04] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DBaseMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DColorMaterial> => [0x5a54a4a1,0x4d97,0x58d3,0xbd,0xcc,0x1b,0xf3,0x8b,0x43,0x8d,0x6d] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DColorMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DColorMaterialGroup> => [0x498467be,0xde0e,0x552b,0xb2,0x4e,0x8e,0xe2,0x5e,0xc9,0xa4,0x86] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DColorMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DComponent> => [0x2e9eabba,0x184b,0x5c14,0xae,0x5f,0xeb,0x63,0x4a,0xa7,0x17,0xe0] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DComponent }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DComponentWithMatrix> => [0x01d2ce44,0x8b63,0x571f,0xb9,0x2e,0xbf,0x2c,0xf7,0xcc,0x6d,0x53] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DComponentWithMatrix }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DCompositeMaterial> => [0xb7e6b17a,0xa885,0x5c97,0xb2,0x9e,0xbf,0x26,0x1e,0xb5,0xda,0xd4] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DCompositeMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DCompositeMaterialGroup> => [0xaf86eea4,0xdd9d,0x5aa9,0xae,0xe5,0xbe,0x38,0x92,0x12,0x47,0x42] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DCompositeMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DMesh> => [0x16ddf132,0xf80d,0x53b2,0xb0,0x9f,0xa4,0x2e,0xd9,0x68,0x9f,0xc4] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DMesh }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DModelTexture> => [0x3d473ca2,0x4a8c,0x5cbd,0x80,0x7f,0x49,0xaf,0x15,0x80,0xd2,0xba] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DModelTexture }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DMultiplePropertyMaterial> => [0x614c0a0a,0xbf75,0x56ad,0xa3,0x04,0xb7,0x9f,0x60,0x01,0x7b,0x83] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DMultiplePropertyMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DMultiplePropertyMaterialGroup> => [0xa24bab9a,0xd946,0x5036,0xb1,0xc9,0x1c,0x09,0xb7,0x93,0xf3,0x6c] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DMultiplePropertyMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DTexture2CoordMaterial> => [0x72d80d63,0x3626,0x5a2f,0xa5,0x79,0x78,0xe7,0x0a,0xa8,0x6d,0x46] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DTexture2CoordMaterial }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DTexture2CoordMaterialGroup> => [0x11eaecc4,0x6ac1,0x5697,0x9b,0xf5,0x1e,0xf6,0x17,0xe1,0xdf,0xeb] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DTexture2CoordMaterialGroup }
#[cfg(feature="windows-graphics")] RT_PINTERFACE!{ for IIterator<super::super::graphics::printing3d::Printing3DTextureResource> => [0x0678d5db,0x8fca,0x5084,0xa8,0x51,0x73,0x12,0xfe,0x53,0xf7,0x35] as IID_IIterator_1_Windows_Graphics_Printing3D_Printing3DTextureResource }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IIterator<super::super::management::deployment::PackageUserInformation> => [0x75660566,0xae43,0x5858,0xad,0xa6,0xd5,0x7d,0xda,0xe9,0x02,0x77] as IID_IIterator_1_Windows_Management_Deployment_PackageUserInformation }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IIterator<super::super::management::deployment::PackageVolume> => [0xa8d5b736,0x4e68,0x5ef1,0x9f,0x07,0xf0,0x68,0x37,0x98,0x8c,0x73] as IID_IIterator_1_Windows_Management_Deployment_PackageVolume }
#[cfg(feature="windows-management")] RT_PINTERFACE!{ for IIterator<super::super::management::MdmAlert> => [0xb4a6ebea,0xb19f,0x5da5,0xb3,0xd1,0xe8,0x59,0xf1,0xf4,0xdf,0x17] as IID_IIterator_1_Windows_Management_MdmAlert }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::apprecording::AppRecordingSavedScreenshotInfo> => [0x3c407016,0x1940,0x5e2b,0x88,0x30,0xc5,0x4b,0xec,0xbb,0xe0,0xda] as IID_IIterator_1_Windows_Media_AppRecording_AppRecordingSavedScreenshotInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::audio::AudioGraphConnection> => [0x4af6a8fc,0xe7fb,0x5957,0x91,0xc1,0x2d,0xf9,0x60,0x0b,0x22,0xeb] as IID_IIterator_1_Windows_Media_Audio_AudioGraphConnection }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::audio::EqualizerBand> => [0xeb4f8b6a,0x7928,0x5f2f,0xb7,0xf2,0x7b,0x90,0xc0,0x84,0x35,0x6f] as IID_IIterator_1_Windows_Media_Audio_EqualizerBand }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::AppBroadcastPlugIn> => [0xcf667b1a,0x3bb9,0x57ce,0xa3,0x8b,0x1e,0x81,0x47,0x1f,0x8c,0xf8] as IID_IIterator_1_Windows_Media_Capture_AppBroadcastPlugIn }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::frames::MediaFrameFormat> => [0x83a0cfaa,0x6546,0x5a63,0x8c,0xd7,0xf6,0x21,0x52,0xa7,0x5d,0x27] as IID_IIterator_1_Windows_Media_Capture_Frames_MediaFrameFormat }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::frames::MediaFrameSource> => [0xd05e53cd,0xbbec,0x5fb7,0x8e,0x4e,0xde,0x86,0x11,0x5b,0x5e,0x88] as IID_IIterator_1_Windows_Media_Capture_Frames_MediaFrameSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::frames::MediaFrameSourceGroup> => [0xdc0c1f9a,0xb748,0x5cfa,0x9b,0x42,0xa3,0xa8,0xfe,0x37,0x28,0x1a] as IID_IIterator_1_Windows_Media_Capture_Frames_MediaFrameSourceGroup }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::frames::MediaFrameSourceInfo> => [0x443c60d8,0x208e,0x5399,0xbc,0x44,0xed,0xc6,0xfe,0xf0,0x22,0x93] as IID_IIterator_1_Windows_Media_Capture_Frames_MediaFrameSourceInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::MediaCaptureVideoProfile> => [0xa9bc95f8,0xb5c0,0x5108,0xb9,0xed,0xa9,0x02,0x33,0x93,0x66,0xe9] as IID_IIterator_1_Windows_Media_Capture_MediaCaptureVideoProfile }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::capture::MediaCaptureVideoProfileMediaDescription> => [0xb3e8378f,0x710c,0x5126,0xa6,0xc9,0x8f,0x48,0x9f,0x63,0xe1,0x5e] as IID_IIterator_1_Windows_Media_Capture_MediaCaptureVideoProfileMediaDescription }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::casting::CastingSource> => [0x3f6c93e9,0xcc77,0x5ef4,0xb2,0xb7,0x25,0xcf,0xcf,0xc0,0x97,0x20] as IID_IIterator_1_Windows_Media_Casting_CastingSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::AudioStreamDescriptor> => [0xa61a11cd,0xb32e,0x518b,0xa6,0xa7,0x54,0x72,0xcb,0xe0,0x0e,0x83] as IID_IIterator_1_Windows_Media_Core_AudioStreamDescriptor }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::AudioTrack> => [0x138064ef,0x8693,0x5303,0x8a,0x75,0xeb,0xa4,0x94,0xd0,0x63,0x42] as IID_IIterator_1_Windows_Media_Core_AudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::CodecInfo> => [0xd4141d5b,0x23f6,0x564b,0xb8,0x5c,0x5d,0x46,0x09,0xf8,0x18,0x63] as IID_IIterator_1_Windows_Media_Core_CodecInfo }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::IMediaCue> => [0x1a594dc8,0xa64b,0x55ed,0x9b,0x34,0x7b,0x27,0x4e,0x1d,0x5c,0x70] as IID_IIterator_1_Windows_Media_Core_IMediaCue }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::MseSourceBuffer> => [0x53076581,0x01a9,0x51b9,0x98,0xcc,0x52,0x65,0x50,0x4c,0xd3,0x52] as IID_IIterator_1_Windows_Media_Core_MseSourceBuffer }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::MseTimeRange> => [0x92a36852,0xfbb3,0x5b48,0xb4,0xec,0x01,0xdd,0xa0,0x97,0x2a,0x5c] as IID_IIterator_1_Windows_Media_Core_MseTimeRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::TimedMetadataTrack> => [0x859354e5,0x077b,0x5d53,0xb2,0x97,0x1a,0x07,0xb9,0x7f,0x09,0xc3] as IID_IIterator_1_Windows_Media_Core_TimedMetadataTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::TimedTextLine> => [0x84c4fcac,0x86d8,0x5c74,0xa1,0x38,0xd9,0xbf,0x37,0xb7,0x49,0xec] as IID_IIterator_1_Windows_Media_Core_TimedTextLine }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::TimedTextSource> => [0xbdded7c0,0x5c73,0x57f5,0x9b,0x08,0x65,0x29,0x33,0x58,0x6d,0xd5] as IID_IIterator_1_Windows_Media_Core_TimedTextSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::TimedTextSubformat> => [0x65105e50,0x865c,0x591d,0x9b,0xf4,0x96,0x23,0x7d,0xe2,0x53,0x3f] as IID_IIterator_1_Windows_Media_Core_TimedTextSubformat }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::VideoStreamDescriptor> => [0xda51ab3c,0x3c64,0x545c,0xa3,0xf4,0xf9,0xb0,0x55,0xaa,0xf7,0xd9] as IID_IIterator_1_Windows_Media_Core_VideoStreamDescriptor }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::core::VideoTrack> => [0xa7c8d22c,0xb59d,0x5d7a,0x8d,0x70,0x67,0xf8,0x98,0xa0,0xb8,0x77] as IID_IIterator_1_Windows_Media_Core_VideoTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::AdvancedPhotoMode> => [0xe6d0bc9d,0xe1cb,0x5ed0,0x8e,0xde,0x7d,0x03,0x7b,0xcc,0x2e,0x07] as IID_IIterator_1_Windows_Media_Devices_AdvancedPhotoMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::AudioDeviceModule> => [0xb4cbbfb7,0x9851,0x56c9,0x83,0x9d,0xa1,0x0a,0x8b,0x1b,0xb2,0x34] as IID_IIterator_1_Windows_Media_Devices_AudioDeviceModule }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::AutoFocusRange> => [0x07489ac5,0x3c71,0x59c6,0xb7,0xdc,0x7f,0x21,0x34,0x1c,0x2f,0x71] as IID_IIterator_1_Windows_Media_Devices_AutoFocusRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::CaptureSceneMode> => [0xaafa6d7a,0x2f7f,0x5dd7,0xaa,0x0a,0x26,0x57,0x31,0xa2,0xb3,0xb3] as IID_IIterator_1_Windows_Media_Devices_CaptureSceneMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::core::FrameController> => [0x1440dc88,0x63ff,0x5a01,0xbb,0x93,0x39,0x0c,0x76,0x74,0x24,0x88] as IID_IIterator_1_Windows_Media_Devices_Core_FrameController }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::FocusMode> => [0xf9a43cd4,0xb300,0x541f,0xaf,0x79,0x3d,0xe3,0x40,0x0e,0x16,0xaf] as IID_IIterator_1_Windows_Media_Devices_FocusMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::FocusPreset> => [0xd3ebc8e9,0xf0c5,0x51c0,0xbb,0x86,0xbd,0xea,0x0a,0x69,0x46,0xfb] as IID_IIterator_1_Windows_Media_Devices_FocusPreset }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::HdrVideoMode> => [0x3db61d13,0x0f30,0x5d2d,0x99,0xcb,0x30,0xc7,0xb9,0x00,0x98,0x78] as IID_IIterator_1_Windows_Media_Devices_HdrVideoMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::IsoSpeedPreset> => [0x1b33af76,0x980b,0x5348,0x91,0x6a,0x79,0x3f,0x61,0xb5,0x55,0xa0] as IID_IIterator_1_Windows_Media_Devices_IsoSpeedPreset }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::ManualFocusDistance> => [0xb02944e1,0xf649,0x511e,0x80,0xdd,0x2e,0x2b,0x20,0x37,0x9d,0xeb] as IID_IIterator_1_Windows_Media_Devices_ManualFocusDistance }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::OpticalImageStabilizationMode> => [0x4a165d46,0xcf19,0x5a03,0xbb,0x54,0x63,0xfc,0x2b,0x4e,0xd3,0x9b] as IID_IIterator_1_Windows_Media_Devices_OpticalImageStabilizationMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::RegionOfInterest> => [0x8eb80e4e,0x9691,0x594f,0x8b,0x3d,0xf5,0x2e,0xcc,0x0f,0x78,0x37] as IID_IIterator_1_Windows_Media_Devices_RegionOfInterest }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::devices::ZoomTransitionMode> => [0x80eb468a,0xfdc4,0x5c89,0x99,0xb8,0x8d,0x47,0x62,0x64,0xe2,0x11] as IID_IIterator_1_Windows_Media_Devices_ZoomTransitionMode }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::editing::BackgroundAudioTrack> => [0x18b0f692,0x8635,0x577a,0x9e,0xfa,0xcb,0x90,0x47,0x70,0xd6,0xe5] as IID_IIterator_1_Windows_Media_Editing_BackgroundAudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::editing::EmbeddedAudioTrack> => [0xc9fa7f51,0xb52c,0x578e,0x99,0xf9,0x01,0x2c,0xd5,0x64,0x12,0x47] as IID_IIterator_1_Windows_Media_Editing_EmbeddedAudioTrack }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::editing::MediaClip> => [0x2dfd20b2,0x06d8,0x577d,0xab,0x06,0x77,0x1e,0x04,0x14,0xfc,0x00] as IID_IIterator_1_Windows_Media_Editing_MediaClip }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::editing::MediaOverlay> => [0x351f6f24,0x4a92,0x56d6,0xa1,0x87,0xfa,0xea,0xe7,0x48,0xe0,0xc7] as IID_IIterator_1_Windows_Media_Editing_MediaOverlay }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::editing::MediaOverlayLayer> => [0xca401ed8,0x63d2,0x525a,0x80,0xbb,0xe4,0x94,0x90,0x0c,0x4c,0xe6] as IID_IIterator_1_Windows_Media_Editing_MediaOverlayLayer }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::effects::AudioEffect> => [0x673ce717,0xa3cf,0x5d68,0xa8,0x0b,0x5e,0xd3,0xe7,0xb9,0x3f,0xed] as IID_IIterator_1_Windows_Media_Effects_AudioEffect }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::effects::IAudioEffectDefinition> => [0xec0f39fc,0x6959,0x5423,0x9e,0x1a,0xf7,0xcb,0x8e,0x84,0x5c,0xa1] as IID_IIterator_1_Windows_Media_Effects_IAudioEffectDefinition }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::effects::IVideoEffectDefinition> => [0x9d82379d,0x4958,0x558e,0xa1,0x55,0x3a,0x80,0x9b,0xb1,0x6c,0x04] as IID_IIterator_1_Windows_Media_Effects_IVideoEffectDefinition }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::faceanalysis::DetectedFace> => [0xa0cf090e,0x0340,0x531f,0x89,0x8b,0xc2,0x1e,0xaf,0xb9,0xf4,0xae] as IID_IIterator_1_Windows_Media_FaceAnalysis_DetectedFace }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::IMediaMarker> => [0xf464661e,0x88bc,0x5cea,0x93,0xcd,0x0c,0x12,0x3f,0x17,0xd2,0x58] as IID_IIterator_1_Windows_Media_IMediaMarker }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::import::PhotoImportItem> => [0xd04d6068,0xb5a3,0x508e,0xbc,0x6b,0x1d,0xcd,0xfc,0xfb,0x0d,0x08] as IID_IIterator_1_Windows_Media_Import_PhotoImportItem }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::import::PhotoImportOperation> => [0x7c9dde1a,0xa8a1,0x5957,0x8e,0x0d,0xc4,0x01,0xd1,0x9c,0x92,0x37] as IID_IIterator_1_Windows_Media_Import_PhotoImportOperation }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::import::PhotoImportSidecar> => [0xaef5ebf0,0x1363,0x593a,0x86,0xd5,0xf9,0x2b,0xc2,0x30,0xbf,0xd6] as IID_IIterator_1_Windows_Media_Import_PhotoImportSidecar }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::import::PhotoImportSource> => [0x7d70f831,0x6ee4,0x5130,0xa7,0xb8,0x25,0x3a,0x21,0x15,0x4e,0x82] as IID_IIterator_1_Windows_Media_Import_PhotoImportSource }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::import::PhotoImportStorageMedium> => [0x985cb948,0x9769,0x55dc,0x85,0xd9,0x12,0x5a,0x5d,0x03,0xd6,0xbb] as IID_IIterator_1_Windows_Media_Import_PhotoImportStorageMedium }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::import::PhotoImportVideoSegment> => [0xc4c16a75,0x3310,0x5ab9,0x93,0x07,0x78,0x75,0x5a,0xb1,0x09,0x4d] as IID_IIterator_1_Windows_Media_Import_PhotoImportVideoSegment }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::mediaproperties::AudioEncodingProperties> => [0x064b6aef,0x3bd0,0x5463,0x84,0x50,0x72,0xc6,0x16,0x9a,0xf5,0xd4] as IID_IIterator_1_Windows_Media_MediaProperties_AudioEncodingProperties }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::mediaproperties::IMediaEncodingProperties> => [0x7c094aec,0xc8f3,0x5f49,0x99,0xc7,0xb6,0x6d,0x84,0x14,0x20,0x0e] as IID_IIterator_1_Windows_Media_MediaProperties_IMediaEncodingProperties }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::mediaproperties::VideoEncodingProperties> => [0x094166ef,0xae5f,0x5315,0xa3,0xbf,0xfe,0x54,0xe8,0xc3,0x5f,0xcd] as IID_IIterator_1_Windows_Media_MediaProperties_VideoEncodingProperties }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::MediaTimeRange> => [0x29b8d190,0x5e46,0x5873,0xaf,0xc0,0x8f,0x2f,0x40,0xfb,0xe8,0xfd] as IID_IIterator_1_Windows_Media_MediaTimeRange }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::ocr::OcrLine> => [0x52ca0f8a,0x5788,0x5695,0xb9,0x05,0x46,0xb8,0xd8,0x17,0x1d,0x88] as IID_IIterator_1_Windows_Media_Ocr_OcrLine }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::ocr::OcrWord> => [0x0ed4317a,0x9964,0x51c6,0xac,0xbe,0x02,0x51,0x2a,0x06,0x90,0x82] as IID_IIterator_1_Windows_Media_Ocr_OcrWord }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::playback::MediaBreak> => [0x9efd8746,0xf93c,0x524f,0x9f,0x95,0x4b,0x59,0x8a,0xcf,0x8d,0x25] as IID_IIterator_1_Windows_Media_Playback_MediaBreak }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::playback::MediaPlaybackItem> => [0xab074059,0x8c08,0x53e7,0x96,0x54,0x02,0xd2,0x59,0x8f,0xff,0x55] as IID_IIterator_1_Windows_Media_Playback_MediaPlaybackItem }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::protection::playready::IPlayReadyDomain> => [0x5c35e8a5,0x4ad7,0x5e70,0xbe,0xdf,0x91,0xf5,0xd5,0x88,0x8d,0x35] as IID_IIterator_1_Windows_Media_Protection_PlayReady_IPlayReadyDomain }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::protection::playready::IPlayReadyLicense> => [0x6a6d000a,0xce26,0x541b,0xa1,0x58,0x84,0x57,0x40,0x9b,0x26,0x04] as IID_IIterator_1_Windows_Media_Protection_PlayReady_IPlayReadyLicense }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::protection::playready::IPlayReadySecureStopServiceRequest> => [0x77b0419b,0x3f4b,0x5ef9,0xae,0x0b,0x88,0x11,0x43,0xb1,0x72,0xc9] as IID_IIterator_1_Windows_Media_Protection_PlayReady_IPlayReadySecureStopServiceRequest }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::protection::RevocationAndRenewalItem> => [0xdfb9655c,0x8b22,0x511f,0x8e,0xaf,0x3a,0xea,0x75,0x21,0x80,0x2b] as IID_IIterator_1_Windows_Media_Protection_RevocationAndRenewalItem }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::speechrecognition::ISpeechRecognitionConstraint> => [0x738f00b1,0xe18c,0x5140,0xa5,0x3a,0xf1,0x78,0x8d,0x10,0xc9,0x3d] as IID_IIterator_1_Windows_Media_SpeechRecognition_ISpeechRecognitionConstraint }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::speechrecognition::SpeechRecognitionResult> => [0x20756dd2,0x6d3f,0x5409,0x84,0x6a,0x0f,0x0f,0x01,0xd7,0xbf,0x9a] as IID_IIterator_1_Windows_Media_SpeechRecognition_SpeechRecognitionResult }
#[cfg(feature="windows-media")] RT_PINTERFACE!{ for IIterator<super::super::media::speechsynthesis::VoiceInformation> => [0x12d40a27,0xae8d,0x5fb0,0x8f,0xed,0x00,0x16,0x5d,0x59,0xc6,0xab] as IID_IIterator_1_Windows_Media_SpeechSynthesis_VoiceInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::backgroundtransfer::BackgroundTransferContentPart> => [0x07fbc351,0x781d,0x52c7,0x95,0x58,0xa4,0x53,0xe5,0x70,0x3f,0x29] as IID_IIterator_1_Windows_Networking_BackgroundTransfer_BackgroundTransferContentPart }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::backgroundtransfer::BackgroundTransferFileRange> => [0xa753d778,0x8cbb,0x524a,0xb8,0xc4,0x70,0xc5,0x15,0xa4,0x27,0x82] as IID_IIterator_1_Windows_Networking_BackgroundTransfer_BackgroundTransferFileRange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::backgroundtransfer::DownloadOperation> => [0x2ab61055,0x2d0a,0x59cb,0x8c,0xbd,0x05,0x6f,0x2d,0x7f,0xb4,0x54] as IID_IIterator_1_Windows_Networking_BackgroundTransfer_DownloadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::backgroundtransfer::UploadOperation> => [0xcaa85133,0x73d7,0x5f96,0xab,0x2d,0xfb,0xb4,0xfa,0x00,0xf7,0x15] as IID_IIterator_1_Windows_Networking_BackgroundTransfer_UploadOperation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::connectivity::AttributedNetworkUsage> => [0x4070c40f,0xab2f,0x56f2,0xb5,0x4c,0x82,0x32,0xae,0x86,0xaa,0xcd] as IID_IIterator_1_Windows_Networking_Connectivity_AttributedNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::connectivity::ConnectionProfile> => [0x89913732,0xa08b,0x5cb2,0xaf,0x16,0xbb,0xbb,0x22,0x23,0x83,0x9e] as IID_IIterator_1_Windows_Networking_Connectivity_ConnectionProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::connectivity::ConnectivityInterval> => [0x741cea48,0x651c,0x5fd9,0x93,0x1e,0x4f,0x91,0xb5,0x21,0xe1,0x82] as IID_IIterator_1_Windows_Networking_Connectivity_ConnectivityInterval }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::connectivity::LanIdentifier> => [0x2c5d2f7e,0xce9c,0x5253,0xa0,0xf4,0x01,0xe5,0xbd,0xc1,0x19,0x88] as IID_IIterator_1_Windows_Networking_Connectivity_LanIdentifier }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::connectivity::NetworkUsage> => [0x5fafb57b,0x9c82,0x50a1,0x99,0x70,0x69,0xf9,0xcb,0x06,0x96,0x95] as IID_IIterator_1_Windows_Networking_Connectivity_NetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::connectivity::ProviderNetworkUsage> => [0xd7090752,0xab5f,0x506f,0x8f,0x15,0x56,0xb3,0x75,0x52,0xfb,0xea] as IID_IIterator_1_Windows_Networking_Connectivity_ProviderNetworkUsage }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::EndpointPair> => [0xc899ff9f,0xe6f5,0x5673,0x81,0x0c,0x04,0xe2,0xff,0x98,0x70,0x4f] as IID_IIterator_1_Windows_Networking_EndpointPair }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::HostName> => [0x557bf83c,0xa428,0x5dbd,0xa0,0xfe,0x05,0xf6,0xee,0x54,0x3d,0x45] as IID_IIterator_1_Windows_Networking_HostName }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandAntennaSar> => [0x03327f15,0xe40f,0x52d1,0xbb,0x6c,0xbe,0xbb,0xd8,0x15,0x51,0x34] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandAntennaSar }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandCellCdma> => [0xb86379f2,0x5369,0x508f,0xa2,0xdf,0xde,0xb3,0xb7,0x2c,0x33,0x78] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandCellCdma }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandCellGsm> => [0x8be60634,0x4021,0x5ac2,0xbd,0x8a,0xa9,0x69,0xb0,0x90,0xb5,0x8d] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandCellGsm }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandCellLte> => [0x186b9d0b,0xef0c,0x540a,0x8f,0xe7,0x4d,0xbc,0x5c,0x1d,0x14,0xda] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandCellLte }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandCellTdscdma> => [0xdd0aeb24,0x0efe,0x5548,0x84,0x48,0xe1,0x53,0xd4,0x90,0x3d,0xf7] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandCellTdscdma }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandCellUmts> => [0xdc24cdb5,0x15f5,0x5a1d,0xa6,0x0b,0xae,0x12,0xf9,0xf4,0x2f,0x06] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandCellUmts }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandDeviceServiceInformation> => [0xd8d776f6,0x4692,0x5461,0x91,0x55,0x81,0x6e,0x63,0xba,0xc8,0x74] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandDeviceServiceInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandNetworkRegistrationStateChange> => [0x9cb0f858,0xe589,0x57a7,0x9d,0x01,0x2c,0x62,0x91,0x56,0x7c,0xc7] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandNetworkRegistrationStateChange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandPinLockStateChange> => [0xe61b479f,0x7bd9,0x5550,0xbc,0x69,0xf9,0xc2,0xf7,0x1c,0x6a,0x05] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandPinLockStateChange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandPinType> => [0x23efcf0c,0x1f8e,0x5bd9,0x8b,0x57,0xf0,0x85,0x01,0x21,0x20,0x1c] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandPinType }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandRadioStateChange> => [0xc088cec3,0x08e5,0x5f35,0xa2,0xb9,0x09,0x00,0xd0,0x28,0xc8,0x3b] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandRadioStateChange }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::MobileBroadbandUiccApp> => [0x4bb2066f,0x1b75,0x57cf,0xa7,0x22,0x1e,0x58,0xbf,0xc5,0xae,0x50] as IID_IIterator_1_Windows_Networking_NetworkOperators_MobileBroadbandUiccApp }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::networkoperators::NetworkOperatorTetheringClient> => [0x5653d065,0xc708,0x5341,0xbc,0x05,0xd3,0xb9,0xce,0xcd,0x2a,0xc7] as IID_IIterator_1_Windows_Networking_NetworkOperators_NetworkOperatorTetheringClient }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::proximity::PeerInformation> => [0xeb6fe2c2,0xd6cd,0x5df0,0xa2,0x95,0x74,0xc5,0x6e,0xc5,0x8a,0xab] as IID_IIterator_1_Windows_Networking_Proximity_PeerInformation }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::servicediscovery::dnssd::DnssdServiceInstance> => [0xbc0cca83,0x44e5,0x5544,0xab,0x5b,0xe0,0x9d,0x66,0xf5,0xfd,0x5f] as IID_IIterator_1_Windows_Networking_ServiceDiscovery_Dnssd_DnssdServiceInstance }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::IVpnCustomPrompt> => [0x6fc7cfe8,0x1882,0x5ba1,0x8e,0x5e,0x4c,0x5e,0x3a,0x4f,0xa8,0x6d] as IID_IIterator_1_Windows_Networking_Vpn_IVpnCustomPrompt }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::IVpnCustomPromptElement> => [0xee23ff21,0x51ba,0x5cc4,0x98,0x56,0x62,0x5c,0x79,0xc2,0x80,0x80] as IID_IIterator_1_Windows_Networking_Vpn_IVpnCustomPromptElement }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::IVpnProfile> => [0x91ccb492,0xec28,0x530b,0xb4,0x5e,0xc4,0x31,0x74,0x4c,0xa9,0xb5] as IID_IIterator_1_Windows_Networking_Vpn_IVpnProfile }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::VpnAppId> => [0xec9298b0,0x8ca2,0x549c,0xbb,0xe2,0x25,0x28,0x23,0xe7,0x0e,0xef] as IID_IIterator_1_Windows_Networking_Vpn_VpnAppId }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::VpnDomainNameInfo> => [0x29f9008e,0x3e81,0x5c58,0x8a,0x78,0x6b,0xe9,0x1a,0xbc,0xc1,0x7d] as IID_IIterator_1_Windows_Networking_Vpn_VpnDomainNameInfo }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::VpnNamespaceInfo> => [0x91e28244,0x7555,0x594d,0xb5,0x4d,0x9c,0x87,0x09,0x5e,0x79,0xa2] as IID_IIterator_1_Windows_Networking_Vpn_VpnNamespaceInfo }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::VpnRoute> => [0x44f813ac,0x052f,0x514b,0xa7,0x76,0xaa,0xd3,0x7a,0x64,0xfd,0xc6] as IID_IIterator_1_Windows_Networking_Vpn_VpnRoute }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::vpn::VpnTrafficFilter> => [0x8f37d5a0,0x5905,0x55bf,0x9c,0x18,0xb9,0xb3,0xb5,0x44,0x64,0x8b] as IID_IIterator_1_Windows_Networking_Vpn_VpnTrafficFilter }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::xboxlive::XboxLiveDeviceAddress> => [0x85fb7103,0xef5e,0x5746,0x93,0x41,0x1d,0xfb,0xb2,0x1d,0x72,0x0d] as IID_IIterator_1_Windows_Networking_XboxLive_XboxLiveDeviceAddress }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::xboxlive::XboxLiveEndpointPair> => [0xe796a96b,0x98a0,0x52a2,0xbb,0x54,0x9d,0xba,0x5b,0xb6,0x4f,0xc4] as IID_IIterator_1_Windows_Networking_XboxLive_XboxLiveEndpointPair }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::xboxlive::XboxLiveEndpointPairTemplate> => [0x515331c6,0x39e1,0x5cc7,0x84,0x54,0x7f,0x1c,0x8b,0xcb,0xa1,0x8e] as IID_IIterator_1_Windows_Networking_XboxLive_XboxLiveEndpointPairTemplate }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::xboxlive::XboxLiveQualityOfServiceMetric> => [0xb281ef1a,0x56bc,0x5daa,0xbb,0xe2,0x65,0xe6,0x17,0xb4,0x99,0x25] as IID_IIterator_1_Windows_Networking_XboxLive_XboxLiveQualityOfServiceMetric }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::xboxlive::XboxLiveQualityOfServiceMetricResult> => [0xe0696826,0x0069,0x57d6,0x9a,0xd8,0xd0,0xb3,0x68,0x62,0x9e,0x2e] as IID_IIterator_1_Windows_Networking_XboxLive_XboxLiveQualityOfServiceMetricResult }
#[cfg(feature="windows-networking")] RT_PINTERFACE!{ for IIterator<super::super::networking::xboxlive::XboxLiveQualityOfServicePrivatePayloadResult> => [0xeb5bfdf4,0x7897,0x5cbf,0xaa,0xa5,0x35,0x82,0xfa,0xfb,0x4d,0x78] as IID_IIterator_1_Windows_Networking_XboxLive_XboxLiveQualityOfServicePrivatePayloadResult }
#[cfg(feature="windows-perception")] RT_PINTERFACE!{ for IIterator<super::super::perception::spatial::SpatialBoundingVolume> => [0xeb8385c5,0x0775,0x5415,0x8f,0x76,0x32,0x7e,0x6e,0x38,0x8a,0xc5] as IID_IIterator_1_Windows_Perception_Spatial_SpatialBoundingVolume }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::identity::core::MicrosoftAccountMultiFactorSessionInfo> => [0xfd6d2ade,0x0fd3,0x5cd0,0xb8,0x6e,0xd2,0x4a,0xd9,0xa2,0x09,0x2c] as IID_IIterator_1_Windows_Security_Authentication_Identity_Core_MicrosoftAccountMultiFactorSessionInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::identity::EnterpriseKeyCredentialRegistrationInfo> => [0xe3497259,0x1737,0x5fad,0x80,0x3b,0x9d,0x2d,0x29,0x27,0x3e,0x3b] as IID_IIterator_1_Windows_Security_Authentication_Identity_EnterpriseKeyCredentialRegistrationInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::identity::provider::SecondaryAuthenticationFactorInfo> => [0x0eedbda6,0x2de0,0x50af,0xab,0xc4,0x46,0x07,0x32,0x45,0xfb,0x2d] as IID_IIterator_1_Windows_Security_Authentication_Identity_Provider_SecondaryAuthenticationFactorInfo }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::onlineid::OnlineIdServiceTicket> => [0x039feee7,0x0882,0x50e2,0xbc,0x3f,0x4f,0xac,0x7e,0x8c,0x27,0x69] as IID_IIterator_1_Windows_Security_Authentication_OnlineId_OnlineIdServiceTicket }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::onlineid::OnlineIdServiceTicketRequest> => [0xb6a5c8e4,0x6e3c,0x5c37,0x92,0xcf,0xcf,0x9f,0x1c,0x38,0x33,0x35] as IID_IIterator_1_Windows_Security_Authentication_OnlineId_OnlineIdServiceTicketRequest }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::web::core::WebTokenResponse> => [0xf080b0c9,0xa095,0x5b3a,0xa1,0xdc,0xd1,0x7e,0x7d,0x29,0x82,0xc7] as IID_IIterator_1_Windows_Security_Authentication_Web_Core_WebTokenResponse }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::web::provider::WebAccountClientView> => [0xa5984607,0x661d,0x5e9c,0xa0,0xba,0x5c,0x7d,0x5f,0x41,0xaf,0x1c] as IID_IIterator_1_Windows_Security_Authentication_Web_Provider_WebAccountClientView }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::authentication::web::provider::WebProviderTokenResponse> => [0xeb57825d,0x5ad6,0x5ee0,0x8d,0xc6,0xa5,0x3c,0x1e,0x82,0xe3,0xab] as IID_IIterator_1_Windows_Security_Authentication_Web_Provider_WebProviderTokenResponse }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::credentials::PasswordCredential> => [0xb01093d8,0x4f52,0x50f0,0x9a,0xa4,0xe2,0x26,0x39,0x11,0x11,0x62] as IID_IIterator_1_Windows_Security_Credentials_PasswordCredential }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::credentials::WebAccount> => [0xbfb82cca,0xaebc,0x567c,0x95,0xd9,0xeb,0xa2,0x5c,0x36,0x5f,0xaa] as IID_IIterator_1_Windows_Security_Credentials_WebAccount }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::cryptography::certificates::Certificate> => [0x676fc159,0xf15c,0x58bd,0x91,0xa7,0x28,0xf7,0xe7,0x95,0xc7,0x56] as IID_IIterator_1_Windows_Security_Cryptography_Certificates_Certificate }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::cryptography::certificates::CertificateExtension> => [0x5e5af982,0x332d,0x54ec,0x8e,0x54,0xe6,0x2c,0x1a,0x1e,0xac,0xe9] as IID_IIterator_1_Windows_Security_Cryptography_Certificates_CertificateExtension }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::cryptography::certificates::ChainValidationResult> => [0x8bcad2b7,0x0e3b,0x5eae,0xbf,0x69,0xe1,0xf6,0xd9,0xc8,0x88,0xf8] as IID_IIterator_1_Windows_Security_Cryptography_Certificates_ChainValidationResult }
#[cfg(feature="windows-security")] RT_PINTERFACE!{ for IIterator<super::super::security::cryptography::certificates::CmsSignerInfo> => [0xba691628,0xd419,0x5e0a,0xb9,0x24,0x03,0xeb,0xc2,0x36,0xb1,0x1e] as IID_IIterator_1_Windows_Security_Cryptography_Certificates_CmsSignerInfo }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::cortana::CortanaPermission> => [0x0f1ac33c,0x511a,0x52e8,0xaf,0x09,0xd8,0x9f,0x70,0x04,0xe8,0xc5] as IID_IIterator_1_Windows_Services_Cortana_CortanaPermission }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::EnhancedWaypoint> => [0x164a4c21,0xd0a0,0x5d68,0x80,0xe2,0x44,0x88,0x9d,0xce,0xa6,0xd5] as IID_IIterator_1_Windows_Services_Maps_EnhancedWaypoint }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::guidance::GuidanceLaneInfo> => [0x4d4ce4d8,0x7ce0,0x5168,0xab,0x29,0x6b,0xcf,0x7f,0x19,0x8a,0x58] as IID_IIterator_1_Windows_Services_Maps_Guidance_GuidanceLaneInfo }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::guidance::GuidanceManeuver> => [0x74a37092,0x2641,0x5c3d,0xb3,0xcb,0x68,0x9d,0xc8,0xab,0xa2,0x2e] as IID_IIterator_1_Windows_Services_Maps_Guidance_GuidanceManeuver }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::guidance::GuidanceRoadSegment> => [0x148cb8ff,0x3ab9,0x53ab,0x88,0x24,0x25,0x6a,0x62,0x04,0x7b,0x43] as IID_IIterator_1_Windows_Services_Maps_Guidance_GuidanceRoadSegment }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::localsearch::LocalLocation> => [0xa23c2e87,0xa8e7,0x568f,0x96,0xa1,0x69,0xe9,0x8f,0x86,0xb9,0xd3] as IID_IIterator_1_Windows_Services_Maps_LocalSearch_LocalLocation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::localsearch::LocalLocationHoursOfOperationItem> => [0x3f9ba5c0,0xb2dc,0x5777,0xa8,0x1e,0xb0,0xa2,0x83,0x9b,0x15,0x2b] as IID_IIterator_1_Windows_Services_Maps_LocalSearch_LocalLocationHoursOfOperationItem }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::ManeuverWarning> => [0xdf74a2a3,0x1eeb,0x5ac2,0xbc,0x5f,0x9f,0x2d,0xaf,0xfc,0xe0,0x17] as IID_IIterator_1_Windows_Services_Maps_ManeuverWarning }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::MapLocation> => [0x2a704d9a,0x3997,0x5f1e,0x86,0x41,0x88,0x3e,0xba,0x40,0x87,0x26] as IID_IIterator_1_Windows_Services_Maps_MapLocation }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::MapRoute> => [0x97e8485a,0x79c0,0x5343,0x93,0xd1,0x47,0xcd,0xfb,0x55,0x24,0x6b] as IID_IIterator_1_Windows_Services_Maps_MapRoute }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::MapRouteLeg> => [0xdd1be7d2,0xde62,0x5752,0xb2,0xe0,0xa2,0xb0,0x87,0x23,0xb7,0x87] as IID_IIterator_1_Windows_Services_Maps_MapRouteLeg }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::MapRouteManeuver> => [0xa7ab048b,0xa6dc,0x5e4c,0x93,0x21,0x71,0xb0,0xe4,0x65,0xdf,0xe8] as IID_IIterator_1_Windows_Services_Maps_MapRouteManeuver }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::maps::offlinemaps::OfflineMapPackage> => [0x750f4d37,0x3766,0x5842,0xa4,0x25,0xcc,0xd9,0xb8,0xd8,0x07,0x86] as IID_IIterator_1_Windows_Services_Maps_OfflineMaps_OfflineMapPackage }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::store::StoreAvailability> => [0x50511ccb,0x089e,0x5b73,0xbb,0x4a,0x4d,0x1e,0xf7,0x7b,0x8f,0x0f] as IID_IIterator_1_Windows_Services_Store_StoreAvailability }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::store::StoreImage> => [0xfbe076f6,0xc3d2,0x5df7,0x83,0x9f,0x01,0x2a,0xc0,0xf9,0x51,0xc5] as IID_IIterator_1_Windows_Services_Store_StoreImage }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::store::StorePackageUpdate> => [0xb75dd77b,0x87ca,0x5956,0x89,0x02,0x84,0xe9,0xff,0xc9,0x7d,0x83] as IID_IIterator_1_Windows_Services_Store_StorePackageUpdate }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::store::StorePackageUpdateStatus> => [0x6181d84f,0xf731,0x57b8,0x9a,0x6b,0x8a,0x12,0xfc,0xd5,0x8d,0x04] as IID_IIterator_1_Windows_Services_Store_StorePackageUpdateStatus }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::store::StoreSku> => [0x365cde92,0x7fe3,0x59d5,0xb8,0xf8,0x8f,0x05,0xac,0xf5,0x09,0x47] as IID_IIterator_1_Windows_Services_Store_StoreSku }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::store::StoreVideo> => [0x91b0b554,0xa537,0x5e22,0xb3,0x9f,0x6a,0x93,0x5d,0x0b,0xef,0x45] as IID_IIterator_1_Windows_Services_Store_StoreVideo }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::targetedcontent::TargetedContentAction> => [0x79656935,0x5813,0x5aa6,0x8e,0x69,0x62,0x7a,0x0d,0x85,0x08,0x8f] as IID_IIterator_1_Windows_Services_TargetedContent_TargetedContentAction }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::targetedcontent::TargetedContentCollection> => [0x6093b8fd,0x6d5d,0x53cd,0xb4,0x97,0x7b,0x45,0x40,0xf1,0x08,0x57] as IID_IIterator_1_Windows_Services_TargetedContent_TargetedContentCollection }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::targetedcontent::TargetedContentFile> => [0x6a957f20,0xed25,0x5019,0x90,0xe7,0x98,0x90,0xd4,0xf9,0x12,0xf2] as IID_IIterator_1_Windows_Services_TargetedContent_TargetedContentFile }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::targetedcontent::TargetedContentImage> => [0xa807b298,0x9e2f,0x5673,0xbc,0xf6,0x1e,0x35,0xfe,0xba,0x06,0x47] as IID_IIterator_1_Windows_Services_TargetedContent_TargetedContentImage }
#[cfg(feature="windows-services")] RT_PINTERFACE!{ for IIterator<super::super::services::targetedcontent::TargetedContentItem> => [0x50109d8e,0xf711,0x5076,0x83,0x09,0xe4,0xe2,0x30,0xef,0x7e,0x85] as IID_IIterator_1_Windows_Services_TargetedContent_TargetedContentItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::accesscache::AccessListEntry> => [0xd1a0a6c4,0x889d,0x519b,0x85,0x08,0x26,0x24,0x1b,0x32,0x9b,0x7e] as IID_IIterator_1_Windows_Storage_AccessCache_AccessListEntry }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::bulkaccess::FileInformation> => [0xbf2f6543,0x230e,0x50bf,0x9c,0x57,0x9e,0x4b,0xa8,0x63,0x59,0x03] as IID_IIterator_1_Windows_Storage_BulkAccess_FileInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::bulkaccess::FolderInformation> => [0xff68b5b6,0xcaad,0x553a,0x98,0x08,0x95,0xee,0xa7,0x00,0xc9,0xde] as IID_IIterator_1_Windows_Storage_BulkAccess_FolderInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::bulkaccess::IStorageItemInformation> => [0x3da6401d,0x1279,0x55a1,0x96,0x2c,0x25,0xcd,0x23,0xb9,0x9b,0x27] as IID_IIterator_1_Windows_Storage_BulkAccess_IStorageItemInformation }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::IStorageFile> => [0x314d2318,0x74ee,0x535c,0xb3,0x61,0x21,0x44,0xdb,0xc5,0x73,0xa0] as IID_IIterator_1_Windows_Storage_IStorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::IStorageItem> => [0x05b487c2,0x3830,0x5d3c,0x98,0xda,0x25,0xfa,0x11,0x54,0x2d,0xbd] as IID_IIterator_1_Windows_Storage_IStorageItem }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::provider::StorageProviderItemProperty> => [0x0c6dddde,0x1aa3,0x54f5,0xb1,0x39,0xe4,0xa2,0x37,0xdc,0x1c,0x5f] as IID_IIterator_1_Windows_Storage_Provider_StorageProviderItemProperty }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::provider::StorageProviderItemPropertyDefinition> => [0x55e5719d,0x2bda,0x521f,0x8c,0x60,0x69,0x21,0xd9,0x0b,0x0b,0xb1] as IID_IIterator_1_Windows_Storage_Provider_StorageProviderItemPropertyDefinition }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::provider::StorageProviderSyncRootInfo> => [0xf73f72c9,0x6bf9,0x5f24,0x95,0xaf,0x72,0x64,0xe5,0x51,0x64,0x23] as IID_IIterator_1_Windows_Storage_Provider_StorageProviderSyncRootInfo }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::search::IIndexableContent> => [0x6cdb32ba,0x2361,0x57a8,0xa3,0x9d,0xbe,0x1d,0xf0,0x41,0xbd,0xb8] as IID_IIterator_1_Windows_Storage_Search_IIndexableContent }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::search::SortEntry> => [0x520434a2,0xacf7,0x58c9,0xb4,0x7a,0x27,0x41,0xf2,0xfa,0xc2,0xc2] as IID_IIterator_1_Windows_Storage_Search_SortEntry }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::StorageFile> => [0x43e29f53,0x0298,0x55aa,0xa6,0xc8,0x4e,0xdd,0x32,0x3d,0x95,0x98] as IID_IIterator_1_Windows_Storage_StorageFile }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::StorageFolder> => [0x5aac96fb,0xb3b9,0x5a7f,0xa9,0x20,0x4b,0x5a,0x8d,0xf8,0x11,0x68] as IID_IIterator_1_Windows_Storage_StorageFolder }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::StorageLibrary> => [0x0a1c6409,0xfbd3,0x58c8,0x9a,0xf3,0x62,0x62,0xcc,0x56,0xe5,0xb3] as IID_IIterator_1_Windows_Storage_StorageLibrary }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::StorageLibraryChange> => [0xc48a1103,0x56e6,0x5398,0x84,0xfe,0x92,0xed,0xad,0x7f,0xc1,0x11] as IID_IIterator_1_Windows_Storage_StorageLibraryChange }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::streams::IBuffer> => [0xafee38e0,0xf882,0x5f10,0x96,0x55,0x1f,0xc9,0x8c,0xc8,0xcc,0xe5] as IID_IIterator_1_Windows_Storage_Streams_IBuffer }
#[cfg(feature="windows-storage")] RT_PINTERFACE!{ for IIterator<super::super::storage::streams::IRandomAccessStream> => [0xc875446a,0x587f,0x58da,0x89,0x7e,0x3b,0xbe,0x5e,0xc7,0xc3,0x0b] as IID_IIterator_1_Windows_Storage_Streams_IRandomAccessStream }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::AppDiagnosticInfo> => [0x183f1e4a,0x2224,0x5fe4,0xb0,0x64,0x68,0x86,0x9c,0x53,0xe3,0x61] as IID_IIterator_1_Windows_System_AppDiagnosticInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::AppResourceGroupBackgroundTaskReport> => [0x00c2180a,0x08e5,0x5eed,0xa0,0x8d,0x56,0xa3,0x56,0xcc,0x00,0x4f] as IID_IIterator_1_Windows_System_AppResourceGroupBackgroundTaskReport }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::AppResourceGroupInfo> => [0xe44d5851,0xe4bc,0x50b9,0xa8,0x98,0x69,0x03,0x13,0x7d,0x8a,0x99] as IID_IIterator_1_Windows_System_AppResourceGroupInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::diagnostics::ProcessDiagnosticInfo> => [0xa89b4418,0x4c3b,0x5f49,0xb9,0x57,0x78,0x56,0x97,0xc9,0x9a,0xbf] as IID_IIterator_1_Windows_System_Diagnostics_ProcessDiagnosticInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::diagnostics::tracereporting::PlatformDiagnosticTraceInfo> => [0x1af4598d,0x98bb,0x5e51,0x84,0x2b,0xcf,0x69,0x19,0x25,0xb6,0xc2] as IID_IIterator_1_Windows_System_Diagnostics_TraceReporting_PlatformDiagnosticTraceInfo }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::remotesystems::IRemoteSystemFilter> => [0x6a2c5aef,0x9f30,0x58ae,0xa6,0xcb,0x9a,0xc9,0xc8,0x09,0x2a,0x41] as IID_IIterator_1_Windows_System_RemoteSystems_IRemoteSystemFilter }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::remotesystems::RemoteSystemSessionParticipant> => [0x05fec44b,0x3dd9,0x5cf1,0xa1,0x00,0xbe,0xdc,0x92,0x33,0x29,0x2d] as IID_IIterator_1_Windows_System_RemoteSystems_RemoteSystemSessionParticipant }
#[cfg(feature="windows-system")] RT_PINTERFACE!{ for IIterator<super::super::system::User> => [0x326fe162,0x582b,0x5659,0xb8,0xa4,0x68,0xff,0x0f,0x52,0x57,0x45] as IID_IIterator_1_Windows_System_User }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::applicationsettings::CredentialCommand> => [0x9f1177f1,0x85bb,0x5cd0,0x9b,0x08,0xa0,0xb4,0x7a,0x76,0x4c,0x75] as IID_IIterator_1_Windows_UI_ApplicationSettings_CredentialCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::applicationsettings::SettingsCommand> => [0x2f071c24,0x4a58,0x5a00,0xa2,0x94,0xc7,0x16,0x2e,0x98,0xc2,0xa0] as IID_IIterator_1_Windows_UI_ApplicationSettings_SettingsCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::applicationsettings::WebAccountCommand> => [0x8cbb62b6,0xbd9c,0x5486,0x9d,0x14,0x9c,0xc4,0x62,0x7b,0x32,0xd4] as IID_IIterator_1_Windows_UI_ApplicationSettings_WebAccountCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::applicationsettings::WebAccountProviderCommand> => [0x82d7cd74,0x8e33,0x5f06,0x92,0xfc,0x91,0x51,0x38,0xaa,0xcb,0xde] as IID_IIterator_1_Windows_UI_ApplicationSettings_WebAccountProviderCommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::Color> => [0xc4310b12,0x7ac2,0x5e5b,0xb5,0x11,0xe5,0x46,0xee,0xa4,0x73,0xb4] as IID_IIterator_1_Windows_UI_Color }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::composition::interactions::CompositionConditionalValue> => [0x8a75b02d,0x3991,0x55a6,0xbf,0xe2,0x82,0xcb,0x7d,0xd6,0x5b,0x98] as IID_IIterator_1_Windows_UI_Composition_Interactions_CompositionConditionalValue }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::composition::interactions::InteractionTrackerInertiaModifier> => [0x46617d87,0x2cd2,0x5e31,0x9a,0x30,0xea,0x86,0xf8,0xaa,0x7c,0xa1] as IID_IIterator_1_Windows_UI_Composition_Interactions_InteractionTrackerInertiaModifier }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::composition::interactions::InteractionTrackerVector2InertiaModifier> => [0x7762caab,0x5b42,0x5958,0x9f,0x49,0x06,0xae,0xfd,0x43,0xad,0x75] as IID_IIterator_1_Windows_UI_Composition_Interactions_InteractionTrackerVector2InertiaModifier }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::core::animationmetrics::IPropertyAnimation> => [0xbb6799d3,0x9f1a,0x5a4e,0xa9,0x40,0x94,0x5f,0x1a,0xb8,0xc4,0xfe] as IID_IIterator_1_Windows_UI_Core_AnimationMetrics_IPropertyAnimation }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::inking::analysis::IInkAnalysisNode> => [0xad35ed5c,0x5f8c,0x5a68,0xa6,0xe1,0x67,0xf2,0x09,0xa0,0x5e,0xa7] as IID_IIterator_1_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::inking::InkPoint> => [0x47415452,0xdb79,0x567e,0x84,0xd5,0xe9,0x91,0x23,0x30,0xf9,0x44] as IID_IIterator_1_Windows_UI_Input_Inking_InkPoint }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::inking::InkRecognitionResult> => [0x9abc247f,0x0223,0x5f44,0x8f,0xa1,0x0d,0x6d,0x69,0x1b,0xf9,0xaf] as IID_IIterator_1_Windows_UI_Input_Inking_InkRecognitionResult }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::inking::InkRecognizer> => [0xf8bd3097,0x5262,0x5e7a,0xa1,0x9d,0x13,0xc0,0x29,0xd2,0xd7,0xe5] as IID_IIterator_1_Windows_UI_Input_Inking_InkRecognizer }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::inking::InkStroke> => [0x5608d5a9,0xe7e4,0x5a0b,0x94,0x1f,0xb7,0xfe,0xd7,0x6b,0x35,0xbf] as IID_IIterator_1_Windows_UI_Input_Inking_InkStroke }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::inking::InkStrokeRenderingSegment> => [0xd7d8c317,0x6f3f,0x5192,0x92,0x10,0x65,0xa2,0x63,0xba,0xf8,0xd1] as IID_IIterator_1_Windows_UI_Input_Inking_InkStrokeRenderingSegment }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::PointerPoint> => [0x721fe01c,0x5ad4,0x5262,0xb0,0x78,0x3a,0xb3,0x45,0x10,0x5d,0xb8] as IID_IIterator_1_Windows_UI_Input_PointerPoint }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::preview::injection::InjectedInputKeyboardInfo> => [0x500e5efe,0x3bc1,0x5d9b,0xbc,0xfc,0xc1,0xf4,0x39,0x50,0x5f,0x12] as IID_IIterator_1_Windows_UI_Input_Preview_Injection_InjectedInputKeyboardInfo }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::preview::injection::InjectedInputMouseInfo> => [0x9604d1d9,0x1744,0x5bd3,0xb5,0xb9,0xd4,0x7b,0x94,0x34,0xfa,0xcb] as IID_IIterator_1_Windows_UI_Input_Preview_Injection_InjectedInputMouseInfo }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::preview::injection::InjectedInputTouchInfo> => [0x4bc92e92,0xd32e,0x597a,0xae,0x24,0xb3,0x88,0x61,0xc5,0xfb,0x08] as IID_IIterator_1_Windows_UI_Input_Preview_Injection_InjectedInputTouchInfo }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::RadialControllerMenuItem> => [0x5a773e24,0xd968,0x535e,0x96,0x9a,0x76,0xce,0x36,0x02,0xa6,0x37] as IID_IIterator_1_Windows_UI_Input_RadialControllerMenuItem }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::RadialControllerSystemMenuItemKind> => [0x3fbc1858,0xa43e,0x54dc,0xb0,0xe2,0x8b,0x09,0x8b,0xdd,0xac,0xf6] as IID_IIterator_1_Windows_UI_Input_RadialControllerSystemMenuItemKind }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::input::spatial::SpatialInteractionSourceState> => [0x23f50032,0x907e,0x5d73,0xbb,0xdc,0xf7,0x56,0x3d,0xe6,0x55,0xc4] as IID_IIterator_1_Windows_UI_Input_Spatial_SpatialInteractionSourceState }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::AdaptiveNotificationText> => [0x18015daa,0xcbc3,0x5a51,0x9f,0x4b,0x3c,0x06,0x91,0x35,0xb0,0xe0] as IID_IIterator_1_Windows_UI_Notifications_AdaptiveNotificationText }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::NotificationBinding> => [0x66187f56,0x9ee1,0x5c48,0x82,0xda,0x6c,0xb9,0xdd,0xf8,0x79,0xe7] as IID_IIterator_1_Windows_UI_Notifications_NotificationBinding }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::ScheduledTileNotification> => [0x5665e491,0x6543,0x5036,0x93,0x5f,0xb5,0x15,0x79,0x50,0xb3,0x59] as IID_IIterator_1_Windows_UI_Notifications_ScheduledTileNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::ScheduledToastNotification> => [0x304238b6,0x888a,0x5dd2,0x96,0xcd,0xbf,0xca,0x89,0x27,0x48,0x3b] as IID_IIterator_1_Windows_UI_Notifications_ScheduledToastNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::ShownTileNotification> => [0x04d8d70b,0x7c15,0x5f60,0x98,0x94,0xb2,0x13,0x66,0xb4,0x27,0xc2] as IID_IIterator_1_Windows_UI_Notifications_ShownTileNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::ToastCollection> => [0x1512ed75,0x8c74,0x5520,0xac,0x88,0x13,0x4a,0x14,0x03,0xf7,0xad] as IID_IIterator_1_Windows_UI_Notifications_ToastCollection }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::ToastNotification> => [0xfe1e726a,0x3aa9,0x5d98,0xb1,0x9b,0x97,0xe3,0xe1,0x7e,0xec,0x7b] as IID_IIterator_1_Windows_UI_Notifications_ToastNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::notifications::UserNotification> => [0x6ee1200d,0xdd13,0x5050,0x88,0xcb,0x53,0x52,0xaf,0x11,0x3f,0xd1] as IID_IIterator_1_Windows_UI_Notifications_UserNotification }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::popups::IUICommand> => [0xf45db3d3,0x7299,0x57ce,0xa7,0x3e,0x29,0x7c,0xf0,0xaf,0x30,0x83] as IID_IIterator_1_Windows_UI_Popups_IUICommand }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::startscreen::JumpListItem> => [0xf69f5cc4,0x004f,0x53eb,0x89,0xe6,0x78,0x6e,0x46,0x05,0x88,0xa4] as IID_IIterator_1_Windows_UI_StartScreen_JumpListItem }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::startscreen::SecondaryTile> => [0x391f7579,0xa90e,0x5352,0x9d,0x01,0xfd,0xa9,0x95,0xd7,0x91,0x2f] as IID_IIterator_1_Windows_UI_StartScreen_SecondaryTile }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::startscreen::SecondaryTileVisualElements> => [0xbbc6e16c,0xcace,0x5230,0x88,0x04,0x22,0x98,0x37,0x51,0x68,0xac] as IID_IIterator_1_Windows_UI_StartScreen_SecondaryTileVisualElements }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::text::core::CoreTextCompositionSegment> => [0x39b4528d,0x2370,0x57fa,0xb5,0xd4,0xb5,0xa2,0x07,0x9a,0x7c,0xea] as IID_IIterator_1_Windows_UI_Text_Core_CoreTextCompositionSegment }
#[cfg(feature="windows-ui")] RT_PINTERFACE!{ for IIterator<super::super::ui::viewmanagement::core::CoreInputViewOcclusion> => [0x5bb57354,0x4f40,0x5ef3,0xa5,0xd1,0x6a,0x60,0x49,0xf9,0x05,0xa1] as IID_IIterator_1_Windows_UI_ViewManagement_Core_CoreInputViewOcclusion }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::automation::AutomationAnnotation> => [0x7ed32ba3,0xdb0c,0x5a54,0xab,0x43,0x30,0x62,0x8a,0xfb,0xc2,0xd8] as IID_IIterator_1_Windows_UI_Xaml_Automation_AutomationAnnotation }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::automation::peers::AutomationPeer> => [0x1f93cd7a,0x8075,0x5ba9,0xbc,0x3e,0xb0,0x4a,0x94,0xe1,0x4b,0xc0] as IID_IIterator_1_Windows_UI_Xaml_Automation_Peers_AutomationPeer }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::automation::peers::AutomationPeerAnnotation> => [0x3b415733,0x48f2,0x58b0,0x98,0x84,0x6f,0x0d,0x0e,0x35,0xdc,0x1a] as IID_IIterator_1_Windows_UI_Xaml_Automation_Peers_AutomationPeerAnnotation }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::ColumnDefinition> => [0x264ebc1f,0xed90,0x528e,0xbf,0x80,0xe9,0xf7,0xe0,0x2c,0x0e,0xe4] as IID_IIterator_1_Windows_UI_Xaml_Controls_ColumnDefinition }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::GroupStyle> => [0x4b1bfdea,0x343f,0x5b34,0x96,0xf4,0x75,0x3d,0x57,0x22,0x7e,0xb9] as IID_IIterator_1_Windows_UI_Xaml_Controls_GroupStyle }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::HubSection> => [0x4f845272,0xf53e,0x5652,0xb0,0x08,0xa8,0xfb,0xf1,0xe0,0x91,0xef] as IID_IIterator_1_Windows_UI_Xaml_Controls_HubSection }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::ICommandBarElement> => [0xcddb0380,0xe9d7,0x5264,0xab,0x5c,0xd7,0x2b,0x64,0x28,0x74,0xc9] as IID_IIterator_1_Windows_UI_Xaml_Controls_ICommandBarElement }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::maps::MapElement> => [0xf916b428,0x3b74,0x5ad4,0x9d,0x97,0x1b,0x0a,0x38,0x7a,0xec,0xb5] as IID_IIterator_1_Windows_UI_Xaml_Controls_Maps_MapElement }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::maps::MapLayer> => [0xaf2283ff,0x250e,0x56d1,0x96,0xd4,0x9f,0x78,0xe1,0x64,0xcb,0xc6] as IID_IIterator_1_Windows_UI_Xaml_Controls_Maps_MapLayer }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::maps::MapRouteView> => [0xaf256095,0x4144,0x55a7,0x91,0x39,0x89,0x84,0x3b,0x57,0x2d,0xb7] as IID_IIterator_1_Windows_UI_Xaml_Controls_Maps_MapRouteView }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::maps::MapStyleSheet> => [0xe6c727e5,0x6a18,0x5333,0xaa,0x6a,0x26,0x6e,0x8c,0x8b,0xdd,0x51] as IID_IIterator_1_Windows_UI_Xaml_Controls_Maps_MapStyleSheet }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::maps::MapTileSource> => [0xe5c7eba6,0x7c75,0x50bc,0x8b,0x36,0x2d,0x8c,0xa1,0xfa,0x53,0x8b] as IID_IIterator_1_Windows_UI_Xaml_Controls_Maps_MapTileSource }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::MenuFlyoutItemBase> => [0x2a8a81ef,0xf351,0x50a7,0xbc,0xdc,0x83,0x68,0xdf,0x21,0x52,0x80] as IID_IIterator_1_Windows_UI_Xaml_Controls_MenuFlyoutItemBase }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::primitives::Popup> => [0x5bcb0970,0x5472,0x56e8,0xb1,0x84,0xd0,0x1f,0xb8,0x1e,0x40,0x8a] as IID_IIterator_1_Windows_UI_Xaml_Controls_Primitives_Popup }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::RowDefinition> => [0x2655d45d,0x38c6,0x53f0,0x87,0x19,0xf3,0xc3,0xa7,0x39,0xc1,0xf9] as IID_IIterator_1_Windows_UI_Xaml_Controls_RowDefinition }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::controls::WebViewDeferredPermissionRequest> => [0xa6ed0a56,0x801b,0x5301,0x95,0xba,0xdf,0x84,0xd0,0x27,0xa9,0x77] as IID_IIterator_1_Windows_UI_Xaml_Controls_WebViewDeferredPermissionRequest }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::data::ItemIndexRange> => [0x9c223a26,0x0c81,0x59f6,0xa9,0x09,0xba,0x49,0x66,0xb4,0xcf,0x24] as IID_IIterator_1_Windows_UI_Xaml_Data_ItemIndexRange }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::DependencyObject> => [0x29f8d454,0x905d,0x587e,0xb9,0xd8,0xbf,0xd4,0x18,0x80,0x5a,0x65] as IID_IIterator_1_Windows_UI_Xaml_DependencyObject }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::documents::Block> => [0x798d518e,0xa9f8,0x5fc7,0x8c,0xcc,0x2a,0x49,0x06,0x9a,0xba,0x05] as IID_IIterator_1_Windows_UI_Xaml_Documents_Block }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::documents::Inline> => [0xf80dc964,0x2542,0x5c6a,0xba,0x65,0xb0,0x48,0x24,0xb5,0xed,0x75] as IID_IIterator_1_Windows_UI_Xaml_Documents_Inline }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::documents::TextHighlighter> => [0xfe6f1eed,0xe66f,0x5236,0xa4,0x1f,0x81,0x75,0x44,0xe1,0xe7,0xbd] as IID_IIterator_1_Windows_UI_Xaml_Documents_TextHighlighter }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::documents::TextRange> => [0x71f63622,0xc0fe,0x5423,0x91,0x4e,0xd3,0x19,0xd2,0x5b,0xcc,0x84] as IID_IIterator_1_Windows_UI_Xaml_Documents_TextRange }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::input::InputScopeName> => [0x7ac16ff4,0x5857,0x5001,0xb8,0x7f,0x32,0x70,0x93,0xf6,0x83,0x92] as IID_IIterator_1_Windows_UI_Xaml_Input_InputScopeName }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::input::KeyboardAccelerator> => [0x8b6ac198,0xeaa0,0x50e6,0x9a,0x35,0x32,0xdf,0xdf,0x1f,0x59,0xe1] as IID_IIterator_1_Windows_UI_Xaml_Input_KeyboardAccelerator }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::input::Pointer> => [0x8cb1347d,0x8888,0x5fb3,0xbf,0xfd,0xe6,0xca,0xf6,0x1b,0x4f,0x03] as IID_IIterator_1_Windows_UI_Xaml_Input_Pointer }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::animation::ColorKeyFrame> => [0x36a6440d,0xaa86,0x5bce,0x8d,0xf2,0x5d,0xe9,0x92,0x06,0xf1,0x51] as IID_IIterator_1_Windows_UI_Xaml_Media_Animation_ColorKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::animation::DoubleKeyFrame> => [0xca007bbd,0x84a1,0x512f,0x97,0x7f,0x9b,0xd7,0x28,0xe1,0xe7,0x3f] as IID_IIterator_1_Windows_UI_Xaml_Media_Animation_DoubleKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::animation::ObjectKeyFrame> => [0x69c69834,0x8951,0x54a7,0xa2,0xca,0x92,0x2b,0xac,0xf9,0xfc,0x70] as IID_IIterator_1_Windows_UI_Xaml_Media_Animation_ObjectKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::animation::PointKeyFrame> => [0xe55a65ad,0xe742,0x5f78,0x87,0x6b,0x64,0xd1,0x68,0x1f,0xc9,0xe2] as IID_IIterator_1_Windows_UI_Xaml_Media_Animation_PointKeyFrame }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::animation::Timeline> => [0xb0c22c25,0xae1a,0x5326,0xbf,0x81,0x39,0x42,0x46,0xcc,0x30,0x76] as IID_IIterator_1_Windows_UI_Xaml_Media_Animation_Timeline }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::animation::Transition> => [0x0f149913,0xd622,0x5dde,0xb6,0xe3,0x78,0x35,0xc2,0xab,0x54,0xb7] as IID_IIterator_1_Windows_UI_Xaml_Media_Animation_Transition }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::Brush> => [0x5d4853d4,0x3f43,0x5aba,0xa0,0x74,0xf2,0x1b,0x30,0x92,0x7b,0xf6] as IID_IIterator_1_Windows_UI_Xaml_Media_Brush }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::Geometry> => [0x8726dcbf,0x961d,0x527a,0xa7,0xcb,0x2d,0xb4,0x7e,0x1c,0x90,0x92] as IID_IIterator_1_Windows_UI_Xaml_Media_Geometry }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::GradientStop> => [0x01dca32b,0x0938,0x5e4a,0x94,0xad,0xbb,0x49,0x06,0xf6,0x51,0xed] as IID_IIterator_1_Windows_UI_Xaml_Media_GradientStop }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::PathFigure> => [0x71bd579b,0x088e,0x5e59,0x88,0x76,0x80,0x61,0x3d,0xcf,0xf8,0x3e] as IID_IIterator_1_Windows_UI_Xaml_Media_PathFigure }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::PathSegment> => [0x3cfedcfb,0x7a75,0x5bc7,0xa7,0xe2,0x95,0xee,0x9b,0xc6,0xdd,0x32] as IID_IIterator_1_Windows_UI_Xaml_Media_PathSegment }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::TimelineMarker> => [0x63e1e513,0xfca3,0x51c0,0x8c,0x2b,0x09,0xdb,0x5f,0x8f,0x4c,0x40] as IID_IIterator_1_Windows_UI_Xaml_Media_TimelineMarker }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xaml::media::Transform> => [0x2cdbd536,0x4598,0x5f0f,0xa2,0x36,0x11,0xec,0x05,0x3c,0x8e,0x4b] as IID_IIterator_1_Windows_UI_Xaml_Media_Transform }
#[cfg(feature="windows-ui-xaml")] RT_PINTERFACE!{ for IIterator<super::super::ui::xam