use ::prelude::*;
DEFINE_IID!(IID_IAudioBuffer, 890722343, 29259, 19562, 177, 48, 246, 83, 127, 154, 224, 208);
RT_INTERFACE!{interface IAudioBuffer(IAudioBufferVtbl): IInspectable(IInspectableVtbl) [IID_IAudioBuffer] {
    fn get_Capacity(&self, out: *mut u32) -> HRESULT,
    fn get_Length(&self, out: *mut u32) -> HRESULT,
    fn put_Length(&self, value: u32) -> HRESULT
}}
impl IAudioBuffer {
    #[inline] pub unsafe fn get_capacity(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Capacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Length)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_length(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Length)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AudioBuffer: IAudioBuffer}
RT_ENUM! { enum AudioBufferAccessMode: i32 {
    Read (AudioBufferAccessMode_Read) = 0, ReadWrite (AudioBufferAccessMode_ReadWrite) = 1, Write (AudioBufferAccessMode_Write) = 2,
}}
DEFINE_IID!(IID_IAudioFrame, 3815424772, 43698, 17015, 158, 208, 67, 206, 223, 142, 41, 198);
RT_INTERFACE!{interface IAudioFrame(IAudioFrameVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFrame] {
    fn LockBuffer(&self, mode: AudioBufferAccessMode, out: *mut *mut AudioBuffer) -> HRESULT
}}
impl IAudioFrame {
    #[inline] pub unsafe fn lock_buffer(&self, mode: AudioBufferAccessMode) -> Result<ComPtr<AudioBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LockBuffer)(self as *const _ as *mut _, mode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioFrame: IAudioFrame}
impl RtActivatable<IAudioFrameFactory> for AudioFrame {}
impl AudioFrame {
    #[inline] pub fn create(capacity: u32) -> Result<ComPtr<AudioFrame>> { unsafe {
        <Self as RtActivatable<IAudioFrameFactory>>::get_activation_factory().create(capacity)
    }}
}
DEFINE_CLSID!(AudioFrame(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,70,114,97,109,101,0]) [CLSID_AudioFrame]);
DEFINE_IID!(IID_IAudioFrameFactory, 2443774686, 9250, 16550, 185, 173, 48, 208, 36, 4, 49, 125);
RT_INTERFACE!{static interface IAudioFrameFactory(IAudioFrameFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFrameFactory] {
    fn Create(&self, capacity: u32, out: *mut *mut AudioFrame) -> HRESULT
}}
impl IAudioFrameFactory {
    #[inline] pub unsafe fn create(&self, capacity: u32) -> Result<ComPtr<AudioFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, capacity, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AudioProcessing: i32 {
    Default (AudioProcessing_Default) = 0, Raw (AudioProcessing_Raw) = 1,
}}
DEFINE_IID!(IID_IAutoRepeatModeChangeRequestedEventArgs, 3927146234, 55378, 17294, 136, 43, 201, 144, 16, 154, 120, 244);
RT_INTERFACE!{interface IAutoRepeatModeChangeRequestedEventArgs(IAutoRepeatModeChangeRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAutoRepeatModeChangeRequestedEventArgs] {
    fn get_RequestedAutoRepeatMode(&self, out: *mut MediaPlaybackAutoRepeatMode) -> HRESULT
}}
impl IAutoRepeatModeChangeRequestedEventArgs {
    #[inline] pub unsafe fn get_requested_auto_repeat_mode(&self) -> Result<MediaPlaybackAutoRepeatMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestedAutoRepeatMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AutoRepeatModeChangeRequestedEventArgs: IAutoRepeatModeChangeRequestedEventArgs}
DEFINE_IID!(IID_IImageDisplayProperties, 3440101359, 21735, 16671, 153, 51, 240, 233, 139, 10, 150, 210);
RT_INTERFACE!{interface IImageDisplayProperties(IImageDisplayPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IImageDisplayProperties] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Subtitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Subtitle(&self, value: HSTRING) -> HRESULT
}}
impl IImageDisplayProperties {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subtitle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subtitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subtitle(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Subtitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ImageDisplayProperties: IImageDisplayProperties}
DEFINE_IID!(IID_IMediaControl, 2565995489, 31373, 17099, 182, 254, 143, 230, 152, 38, 79, 19);
RT_INTERFACE!{static interface IMediaControl(IMediaControlVtbl): IInspectable(IInspectableVtbl) [IID_IMediaControl] {
    fn add_SoundLevelChanged(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SoundLevelChanged(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PlayPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PlayPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PausePressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PausePressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StopPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StopPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PlayPauseTogglePressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PlayPauseTogglePressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RecordPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RecordPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NextTrackPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NextTrackPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PreviousTrackPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PreviousTrackPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_FastForwardPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FastForwardPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RewindPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RewindPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ChannelUpPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ChannelUpPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ChannelDownPressed(&self, handler: *mut super::foundation::EventHandler<IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ChannelDownPressed(&self, cookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_SoundLevel(&self, out: *mut SoundLevel) -> HRESULT,
    fn put_TrackName(&self, value: HSTRING) -> HRESULT,
    fn get_TrackName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ArtistName(&self, value: HSTRING) -> HRESULT,
    fn get_ArtistName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_IsPlaying(&self, value: bool) -> HRESULT,
    fn get_IsPlaying(&self, out: *mut bool) -> HRESULT,
    fn put_AlbumArt(&self, value: *mut super::foundation::Uri) -> HRESULT,
    fn get_AlbumArt(&self, out: *mut *mut super::foundation::Uri) -> HRESULT
}}
impl IMediaControl {
    #[inline] pub unsafe fn add_sound_level_changed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SoundLevelChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sound_level_changed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SoundLevelChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_play_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PlayPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_play_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PlayPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pause_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PausePressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pause_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PausePressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stop_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StopPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stop_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StopPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_play_pause_toggle_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PlayPauseTogglePressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_play_pause_toggle_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PlayPauseTogglePressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_record_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RecordPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_record_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RecordPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_next_track_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NextTrackPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_next_track_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NextTrackPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_previous_track_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PreviousTrackPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_previous_track_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PreviousTrackPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_fast_forward_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FastForwardPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_fast_forward_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FastForwardPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_rewind_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RewindPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_rewind_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RewindPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_channel_up_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ChannelUpPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_channel_up_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ChannelUpPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_channel_down_pressed(&self, handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ChannelDownPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_channel_down_pressed(&self, cookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ChannelDownPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sound_level(&self) -> Result<SoundLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SoundLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_track_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TrackName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_track_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TrackName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_artist_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ArtistName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_artist_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ArtistName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_playing(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsPlaying)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_playing(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPlaying)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_album_art(&self, value: &super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AlbumArt)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_album_art(&self) -> Result<ComPtr<super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AlbumArt)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class MediaControl}
impl RtActivatable<IMediaControl> for MediaControl {}
impl MediaControl {
    #[inline] pub fn add_sound_level_changed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_sound_level_changed(handler)
    }}
    #[inline] pub fn remove_sound_level_changed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_sound_level_changed(cookie)
    }}
    #[inline] pub fn add_play_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_play_pressed(handler)
    }}
    #[inline] pub fn remove_play_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_play_pressed(cookie)
    }}
    #[inline] pub fn add_pause_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_pause_pressed(handler)
    }}
    #[inline] pub fn remove_pause_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_pause_pressed(cookie)
    }}
    #[inline] pub fn add_stop_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_stop_pressed(handler)
    }}
    #[inline] pub fn remove_stop_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_stop_pressed(cookie)
    }}
    #[inline] pub fn add_play_pause_toggle_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_play_pause_toggle_pressed(handler)
    }}
    #[inline] pub fn remove_play_pause_toggle_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_play_pause_toggle_pressed(cookie)
    }}
    #[inline] pub fn add_record_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_record_pressed(handler)
    }}
    #[inline] pub fn remove_record_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_record_pressed(cookie)
    }}
    #[inline] pub fn add_next_track_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_next_track_pressed(handler)
    }}
    #[inline] pub fn remove_next_track_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_next_track_pressed(cookie)
    }}
    #[inline] pub fn add_previous_track_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_previous_track_pressed(handler)
    }}
    #[inline] pub fn remove_previous_track_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_previous_track_pressed(cookie)
    }}
    #[inline] pub fn add_fast_forward_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_fast_forward_pressed(handler)
    }}
    #[inline] pub fn remove_fast_forward_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_fast_forward_pressed(cookie)
    }}
    #[inline] pub fn add_rewind_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_rewind_pressed(handler)
    }}
    #[inline] pub fn remove_rewind_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_rewind_pressed(cookie)
    }}
    #[inline] pub fn add_channel_up_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_channel_up_pressed(handler)
    }}
    #[inline] pub fn remove_channel_up_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_channel_up_pressed(cookie)
    }}
    #[inline] pub fn add_channel_down_pressed(handler: &super::foundation::EventHandler<IInspectable>) -> Result<super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().add_channel_down_pressed(handler)
    }}
    #[inline] pub fn remove_channel_down_pressed(cookie: super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().remove_channel_down_pressed(cookie)
    }}
    #[inline] pub fn get_sound_level() -> Result<SoundLevel> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().get_sound_level()
    }}
    #[inline] pub fn set_track_name(value: &HStringArg) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().set_track_name(value)
    }}
    #[inline] pub fn get_track_name() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().get_track_name()
    }}
    #[inline] pub fn set_artist_name(value: &HStringArg) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().set_artist_name(value)
    }}
    #[inline] pub fn get_artist_name() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().get_artist_name()
    }}
    #[inline] pub fn set_is_playing(value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().set_is_playing(value)
    }}
    #[inline] pub fn get_is_playing() -> Result<bool> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().get_is_playing()
    }}
    #[inline] pub fn set_album_art(value: &super::foundation::Uri) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().set_album_art(value)
    }}
    #[inline] pub fn get_album_art() -> Result<ComPtr<super::foundation::Uri>> { unsafe {
        <Self as RtActivatable<IMediaControl>>::get_activation_factory().get_album_art()
    }}
}
DEFINE_CLSID!(MediaControl(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,77,101,100,105,97,67,111,110,116,114,111,108,0]) [CLSID_MediaControl]);
DEFINE_IID!(IID_IMediaExtension, 126963992, 17887, 17451, 138, 63, 247, 130, 106, 99, 112, 171);
RT_INTERFACE!{interface IMediaExtension(IMediaExtensionVtbl): IInspectable(IInspectableVtbl) [IID_IMediaExtension] {
    fn SetProperties(&self, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT
}}
impl IMediaExtension {
    #[inline] pub unsafe fn set_properties(&self, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).SetProperties)(self as *const _ as *mut _, configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaExtensionManager, 1243998965, 9261, 19963, 151, 244, 105, 183, 196, 37, 118, 255);
RT_INTERFACE!{interface IMediaExtensionManager(IMediaExtensionManagerVtbl): IInspectable(IInspectableVtbl) [IID_IMediaExtensionManager] {
    fn RegisterSchemeHandler(&self, activatableClassId: HSTRING, scheme: HSTRING) -> HRESULT,
    fn RegisterSchemeHandlerWithSettings(&self, activatableClassId: HSTRING, scheme: HSTRING, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT,
    fn RegisterByteStreamHandler(&self, activatableClassId: HSTRING, fileExtension: HSTRING, mimeType: HSTRING) -> HRESULT,
    fn RegisterByteStreamHandlerWithSettings(&self, activatableClassId: HSTRING, fileExtension: HSTRING, mimeType: HSTRING, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT,
    fn RegisterAudioDecoder(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid) -> HRESULT,
    fn RegisterAudioDecoderWithSettings(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT,
    fn RegisterAudioEncoder(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid) -> HRESULT,
    fn RegisterAudioEncoderWithSettings(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT,
    fn RegisterVideoDecoder(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid) -> HRESULT,
    fn RegisterVideoDecoderWithSettings(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT,
    fn RegisterVideoEncoder(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid) -> HRESULT,
    fn RegisterVideoEncoderWithSettings(&self, activatableClassId: HSTRING, inputSubtype: Guid, outputSubtype: Guid, configuration: *mut super::foundation::collections::IPropertySet) -> HRESULT
}}
impl IMediaExtensionManager {
    #[inline] pub unsafe fn register_scheme_handler(&self, activatableClassId: &HStringArg, scheme: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterSchemeHandler)(self as *const _ as *mut _, activatableClassId.get(), scheme.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_scheme_handler_with_settings(&self, activatableClassId: &HStringArg, scheme: &HStringArg, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterSchemeHandlerWithSettings)(self as *const _ as *mut _, activatableClassId.get(), scheme.get(), configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_byte_stream_handler(&self, activatableClassId: &HStringArg, fileExtension: &HStringArg, mimeType: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterByteStreamHandler)(self as *const _ as *mut _, activatableClassId.get(), fileExtension.get(), mimeType.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_byte_stream_handler_with_settings(&self, activatableClassId: &HStringArg, fileExtension: &HStringArg, mimeType: &HStringArg, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterByteStreamHandlerWithSettings)(self as *const _ as *mut _, activatableClassId.get(), fileExtension.get(), mimeType.get(), configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_audio_decoder(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterAudioDecoder)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_audio_decoder_with_settings(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterAudioDecoderWithSettings)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype, configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_audio_encoder(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterAudioEncoder)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_audio_encoder_with_settings(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterAudioEncoderWithSettings)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype, configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_video_decoder(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterVideoDecoder)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_video_decoder_with_settings(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterVideoDecoderWithSettings)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype, configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_video_encoder(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterVideoEncoder)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_video_encoder_with_settings(&self, activatableClassId: &HStringArg, inputSubtype: Guid, outputSubtype: Guid, configuration: &super::foundation::collections::IPropertySet) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterVideoEncoderWithSettings)(self as *const _ as *mut _, activatableClassId.get(), inputSubtype, outputSubtype, configuration as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaExtensionManager: IMediaExtensionManager}
impl RtActivatable<IActivationFactory> for MediaExtensionManager {}
DEFINE_CLSID!(MediaExtensionManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,77,101,100,105,97,69,120,116,101,110,115,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_MediaExtensionManager]);
DEFINE_IID!(IID_IMediaExtensionManager2, 1540276039, 16451, 20461, 172, 175, 84, 236, 41, 223, 177, 247);
RT_INTERFACE!{interface IMediaExtensionManager2(IMediaExtensionManager2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaExtensionManager2] {
    #[cfg(feature="windows-applicationmodel")] fn RegisterMediaExtensionForAppService(&self, extension: *mut IMediaExtension, connection: *mut super::applicationmodel::appservice::AppServiceConnection) -> HRESULT
}}
impl IMediaExtensionManager2 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn register_media_extension_for_app_service(&self, extension: &IMediaExtension, connection: &super::applicationmodel::appservice::AppServiceConnection) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterMediaExtensionForAppService)(self as *const _ as *mut _, extension as *const _ as *mut _, connection as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaFrame, 3216322444, 22851, 18392, 142, 16, 5, 48, 138, 165, 251, 208);
RT_INTERFACE!{interface IMediaFrame(IMediaFrameVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrame] {
    fn get_Type(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsReadOnly(&self, out: *mut bool) -> HRESULT,
    fn put_RelativeTime(&self, value: *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn get_RelativeTime(&self, out: *mut *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn put_SystemRelativeTime(&self, value: *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn get_SystemRelativeTime(&self, out: *mut *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn put_Duration(&self, value: *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn get_Duration(&self, out: *mut *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn put_IsDiscontinuous(&self, value: bool) -> HRESULT,
    fn get_IsDiscontinuous(&self, out: *mut bool) -> HRESULT,
    fn get_ExtendedProperties(&self, out: *mut *mut super::foundation::collections::IPropertySet) -> HRESULT
}}
impl IMediaFrame {
    #[inline] pub unsafe fn get_type(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_read_only(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsReadOnly)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_relative_time(&self, value: &super::foundation::IReference<super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RelativeTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_relative_time(&self) -> Result<ComPtr<super::foundation::IReference<super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RelativeTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_relative_time(&self, value: &super::foundation::IReference<super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemRelativeTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_relative_time(&self) -> Result<ComPtr<super::foundation::IReference<super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SystemRelativeTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: &super::foundation::IReference<super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<ComPtr<super::foundation::IReference<super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_discontinuous(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDiscontinuous)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_discontinuous(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDiscontinuous)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_properties(&self) -> Result<ComPtr<super::foundation::collections::IPropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExtendedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaMarker, 402906872, 56485, 19311, 156, 32, 227, 211, 192, 100, 54, 37);
RT_INTERFACE!{interface IMediaMarker(IMediaMarkerVtbl): IInspectable(IInspectableVtbl) [IID_IMediaMarker] {
    fn get_Time(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn get_MediaMarkerType(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaMarker {
    #[inline] pub unsafe fn get_time(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Time)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_marker_type(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaMarkerType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaMarkers, 2951393673, 63709, 18030, 170, 16, 146, 11, 82, 53, 63, 223);
RT_INTERFACE!{interface IMediaMarkers(IMediaMarkersVtbl): IInspectable(IInspectableVtbl) [IID_IMediaMarkers] {
    fn get_Markers(&self, out: *mut *mut super::foundation::collections::IVectorView<IMediaMarker>) -> HRESULT
}}
impl IMediaMarkers {
    #[inline] pub unsafe fn get_markers(&self) -> Result<ComPtr<super::foundation::collections::IVectorView<IMediaMarker>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Markers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class MediaMarkerTypes}
impl RtActivatable<IMediaMarkerTypesStatics> for MediaMarkerTypes {}
impl MediaMarkerTypes {
    #[inline] pub fn get_bookmark() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaMarkerTypesStatics>>::get_activation_factory().get_bookmark()
    }}
}
DEFINE_CLSID!(MediaMarkerTypes(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,77,101,100,105,97,77,97,114,107,101,114,84,121,112,101,115,0]) [CLSID_MediaMarkerTypes]);
DEFINE_IID!(IID_IMediaMarkerTypesStatics, 3139010624, 18479, 18243, 136, 50, 69, 133, 56, 33, 236, 224);
RT_INTERFACE!{static interface IMediaMarkerTypesStatics(IMediaMarkerTypesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaMarkerTypesStatics] {
    fn get_Bookmark(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaMarkerTypesStatics {
    #[inline] pub unsafe fn get_bookmark(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Bookmark)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaPlaybackAutoRepeatMode: i32 {
    None (MediaPlaybackAutoRepeatMode_None) = 0, Track (MediaPlaybackAutoRepeatMode_Track) = 1, List (MediaPlaybackAutoRepeatMode_List) = 2,
}}
RT_ENUM! { enum MediaPlaybackStatus: i32 {
    Closed (MediaPlaybackStatus_Closed) = 0, Changing (MediaPlaybackStatus_Changing) = 1, Stopped (MediaPlaybackStatus_Stopped) = 2, Playing (MediaPlaybackStatus_Playing) = 3, Paused (MediaPlaybackStatus_Paused) = 4,
}}
RT_ENUM! { enum MediaPlaybackType: i32 {
    Unknown (MediaPlaybackType_Unknown) = 0, Music (MediaPlaybackType_Music) = 1, Video (MediaPlaybackType_Video) = 2, Image (MediaPlaybackType_Image) = 3,
}}
DEFINE_IID!(IID_IMediaProcessingTriggerDetails, 3951387820, 41809, 20302, 180, 240, 155, 242, 64, 137, 147, 219);
RT_INTERFACE!{interface IMediaProcessingTriggerDetails(IMediaProcessingTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaProcessingTriggerDetails] {
    fn get_Arguments(&self, out: *mut *mut super::foundation::collections::ValueSet) -> HRESULT
}}
impl IMediaProcessingTriggerDetails {
    #[inline] pub unsafe fn get_arguments(&self) -> Result<ComPtr<super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaProcessingTriggerDetails: IMediaProcessingTriggerDetails}
DEFINE_IID!(IID_IMediaTimelineController, 2396217843, 2936, 17248, 191, 113, 12, 132, 25, 153, 234, 27);
RT_INTERFACE!{interface IMediaTimelineController(IMediaTimelineControllerVtbl): IInspectable(IInspectableVtbl) [IID_IMediaTimelineController] {
    fn Start(&self) -> HRESULT,
    fn Resume(&self) -> HRESULT,
    fn Pause(&self) -> HRESULT,
    fn get_Position(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn put_Position(&self, value: super::foundation::TimeSpan) -> HRESULT,
    fn get_ClockRate(&self, out: *mut f64) -> HRESULT,
    fn put_ClockRate(&self, value: f64) -> HRESULT,
    fn get_State(&self, out: *mut MediaTimelineControllerState) -> HRESULT,
    fn add_PositionChanged(&self, positionChangedEventHandler: *mut super::foundation::TypedEventHandler<MediaTimelineController, IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PositionChanged(&self, eventCookie: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StateChanged(&self, stateChangedEventHandler: *mut super::foundation::TypedEventHandler<MediaTimelineController, IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, eventCookie: super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IMediaTimelineController {
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn resume(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Resume)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn pause(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Pause)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clock_rate(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClockRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_clock_rate(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ClockRate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<MediaTimelineControllerState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_position_changed(&self, positionChangedEventHandler: &super::foundation::TypedEventHandler<MediaTimelineController, IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PositionChanged)(self as *const _ as *mut _, positionChangedEventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_position_changed(&self, eventCookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PositionChanged)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_state_changed(&self, stateChangedEventHandler: &super::foundation::TypedEventHandler<MediaTimelineController, IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, stateChangedEventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, eventCookie: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaTimelineController: IMediaTimelineController}
impl RtActivatable<IActivationFactory> for MediaTimelineController {}
DEFINE_CLSID!(MediaTimelineController(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,77,101,100,105,97,84,105,109,101,108,105,110,101,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_MediaTimelineController]);
DEFINE_IID!(IID_IMediaTimelineController2, 4017416760, 40562, 19961, 131, 85, 110, 144, 200, 27, 186, 221);
RT_INTERFACE!{interface IMediaTimelineController2(IMediaTimelineController2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaTimelineController2] {
    fn get_Duration(&self, out: *mut *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn put_Duration(&self, value: *mut super::foundation::IReference<super::foundation::TimeSpan>) -> HRESULT,
    fn get_IsLoopingEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsLoopingEnabled(&self, value: bool) -> HRESULT,
    fn add_Failed(&self, eventHandler: *mut super::foundation::TypedEventHandler<MediaTimelineController, MediaTimelineControllerFailedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Failed(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Ended(&self, eventHandler: *mut super::foundation::TypedEventHandler<MediaTimelineController, IInspectable>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Ended(&self, token: super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IMediaTimelineController2 {
    #[inline] pub unsafe fn get_duration(&self) -> Result<ComPtr<super::foundation::IReference<super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: &super::foundation::IReference<super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_looping_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsLoopingEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_looping_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsLoopingEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_failed(&self, eventHandler: &super::foundation::TypedEventHandler<MediaTimelineController, MediaTimelineControllerFailedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Failed)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_failed(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Failed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_ended(&self, eventHandler: &super::foundation::TypedEventHandler<MediaTimelineController, IInspectable>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Ended)(self as *const _ as *mut _, eventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_ended(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Ended)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaTimelineControllerFailedEventArgs, 2283927581, 15991, 17403, 190, 38, 79, 200, 122, 4, 72, 52);
RT_INTERFACE!{interface IMediaTimelineControllerFailedEventArgs(IMediaTimelineControllerFailedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaTimelineControllerFailedEventArgs] {
    fn get_ExtendedError(&self, out: *mut super::foundation::HResult) -> HRESULT
}}
impl IMediaTimelineControllerFailedEventArgs {
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaTimelineControllerFailedEventArgs: IMediaTimelineControllerFailedEventArgs}
RT_ENUM! { enum MediaTimelineControllerState: i32 {
    Paused (MediaTimelineControllerState_Paused) = 0, Running (MediaTimelineControllerState_Running) = 1, Stalled (MediaTimelineControllerState_Stalled) = 2, Error (MediaTimelineControllerState_Error) = 3,
}}
RT_STRUCT! { struct MediaTimeRange {
    Start: super::foundation::TimeSpan, End: super::foundation::TimeSpan,
}}
DEFINE_IID!(IID_IMusicDisplayProperties, 1807682649, 53408, 19750, 146, 160, 249, 120, 225, 209, 142, 123);
RT_INTERFACE!{interface IMusicDisplayProperties(IMusicDisplayPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IMusicDisplayProperties] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_AlbumArtist(&self, out: *mut HSTRING) -> HRESULT,
    fn put_AlbumArtist(&self, value: HSTRING) -> HRESULT,
    fn get_Artist(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Artist(&self, value: HSTRING) -> HRESULT
}}
impl IMusicDisplayProperties {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_album_artist(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AlbumArtist)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_album_artist(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AlbumArtist)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_artist(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Artist)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_artist(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Artist)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MusicDisplayProperties: IMusicDisplayProperties}
DEFINE_IID!(IID_IMusicDisplayProperties2, 3572834, 38867, 17593, 176, 15, 0, 138, 252, 239, 175, 24);
RT_INTERFACE!{interface IMusicDisplayProperties2(IMusicDisplayProperties2Vtbl): IInspectable(IInspectableVtbl) [IID_IMusicDisplayProperties2] {
    fn get_AlbumTitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_AlbumTitle(&self, value: HSTRING) -> HRESULT,
    fn get_TrackNumber(&self, out: *mut u32) -> HRESULT,
    fn put_TrackNumber(&self, value: u32) -> HRESULT,
    fn get_Genres(&self, out: *mut *mut super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IMusicDisplayProperties2 {
    #[inline] pub unsafe fn get_album_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AlbumTitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_album_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AlbumTitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_track_number(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TrackNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_track_number(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TrackNumber)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_genres(&self) -> Result<ComPtr<super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Genres)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMusicDisplayProperties3, 1303714497, 1665, 20108, 148, 1, 184, 21, 157, 158, 239, 199);
RT_INTERFACE!{interface IMusicDisplayProperties3(IMusicDisplayProperties3Vtbl): IInspectable(IInspectableVtbl) [IID_IMusicDisplayProperties3] {
    fn get_AlbumTrackCount(&self, out: *mut u32) -> HRESULT,
    fn put_AlbumTrackCount(&self, value: u32) -> HRESULT
}}
impl IMusicDisplayProperties3 {
    #[inline] pub unsafe fn get_album_track_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlbumTrackCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_album_track_count(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AlbumTrackCount)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPlaybackPositionChangeRequestedEventArgs, 3024699272, 60200, 18785, 156, 20, 51, 94, 68, 243, 225, 37);
RT_INTERFACE!{interface IPlaybackPositionChangeRequestedEventArgs(IPlaybackPositionChangeRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPlaybackPositionChangeRequestedEventArgs] {
    fn get_RequestedPlaybackPosition(&self, out: *mut super::foundation::TimeSpan) -> HRESULT
}}
impl IPlaybackPositionChangeRequestedEventArgs {
    #[inline] pub unsafe fn get_requested_playback_position(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestedPlaybackPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PlaybackPositionChangeRequestedEventArgs: IPlaybackPositionChangeRequestedEventArgs}
DEFINE_IID!(IID_IPlaybackRateChangeRequestedEventArgs, 753058847, 15574, 20343, 155, 167, 235, 39, 194, 106, 33, 64);
RT_INTERFACE!{interface IPlaybackRateChangeRequestedEventArgs(IPlaybackRateChangeRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPlaybackRateChangeRequestedEventArgs] {
    fn get_RequestedPlaybackRate(&self, out: *mut f64) -> HRESULT
}}
impl IPlaybackRateChangeRequestedEventArgs {
    #[inline] pub unsafe fn get_requested_playback_rate(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestedPlaybackRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PlaybackRateChangeRequestedEventArgs: IPlaybackRateChangeRequestedEventArgs}
DEFINE_IID!(IID_IShuffleEnabledChangeRequestedEventArgs, 1236636670, 20432, 18022, 163, 20, 192, 224, 25, 64, 211, 2);
RT_INTERFACE!{interface IShuffleEnabledChangeRequestedEventArgs(IShuffleEnabledChangeRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IShuffleEnabledChangeRequestedEventArgs] {
    fn get_RequestedShuffleEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IShuffleEnabledChangeRequestedEventArgs {
    #[inline] pub unsafe fn get_requested_shuffle_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestedShuffleEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ShuffleEnabledChangeRequestedEventArgs: IShuffleEnabledChangeRequestedEventArgs}
RT_ENUM! { enum SoundLevel: i32 {
    Muted (SoundLevel_Muted) = 0, Low (SoundLevel_Low) = 1, Full (SoundLevel_Full) = 2,
}}
DEFINE_IID!(IID_ISystemMediaTransportControls, 2583314420, 5954, 17062, 144, 46, 8, 125, 65, 249, 101, 236);
RT_INTERFACE!{interface ISystemMediaTransportControls(ISystemMediaTransportControlsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControls] {
    fn get_PlaybackStatus(&self, out: *mut MediaPlaybackStatus) -> HRESULT,
    fn put_PlaybackStatus(&self, value: MediaPlaybackStatus) -> HRESULT,
    fn get_DisplayUpdater(&self, out: *mut *mut SystemMediaTransportControlsDisplayUpdater) -> HRESULT,
    fn get_SoundLevel(&self, out: *mut SoundLevel) -> HRESULT,
    fn get_IsEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsEnabled(&self, value: bool) -> HRESULT,
    fn get_IsPlayEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsPlayEnabled(&self, value: bool) -> HRESULT,
    fn get_IsStopEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsStopEnabled(&self, value: bool) -> HRESULT,
    fn get_IsPauseEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsPauseEnabled(&self, value: bool) -> HRESULT,
    fn get_IsRecordEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsRecordEnabled(&self, value: bool) -> HRESULT,
    fn get_IsFastForwardEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsFastForwardEnabled(&self, value: bool) -> HRESULT,
    fn get_IsRewindEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsRewindEnabled(&self, value: bool) -> HRESULT,
    fn get_IsPreviousEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsPreviousEnabled(&self, value: bool) -> HRESULT,
    fn get_IsNextEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsNextEnabled(&self, value: bool) -> HRESULT,
    fn get_IsChannelUpEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsChannelUpEnabled(&self, value: bool) -> HRESULT,
    fn get_IsChannelDownEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsChannelDownEnabled(&self, value: bool) -> HRESULT,
    fn add_ButtonPressed(&self, handler: *mut super::foundation::TypedEventHandler<SystemMediaTransportControls, SystemMediaTransportControlsButtonPressedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ButtonPressed(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PropertyChanged(&self, handler: *mut super::foundation::TypedEventHandler<SystemMediaTransportControls, SystemMediaTransportControlsPropertyChangedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PropertyChanged(&self, token: super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISystemMediaTransportControls {
    #[inline] pub unsafe fn get_playback_status(&self) -> Result<MediaPlaybackStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlaybackStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_playback_status(&self, value: MediaPlaybackStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaybackStatus)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_updater(&self) -> Result<ComPtr<SystemMediaTransportControlsDisplayUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayUpdater)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sound_level(&self) -> Result<SoundLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SoundLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_play_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPlayEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_play_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsPlayEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_stop_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsStopEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_stop_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsStopEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_pause_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPauseEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_pause_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsPauseEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_record_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRecordEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_record_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsRecordEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_fast_forward_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFastForwardEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_fast_forward_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsFastForwardEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_rewind_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRewindEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_rewind_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsRewindEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_previous_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPreviousEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_previous_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsPreviousEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_next_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsNextEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_next_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsNextEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_channel_up_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsChannelUpEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_channel_up_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsChannelUpEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_channel_down_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsChannelDownEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_channel_down_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsChannelDownEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_button_pressed(&self, handler: &super::foundation::TypedEventHandler<SystemMediaTransportControls, SystemMediaTransportControlsButtonPressedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ButtonPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_button_pressed(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ButtonPressed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_property_changed(&self, handler: &super::foundation::TypedEventHandler<SystemMediaTransportControls, SystemMediaTransportControlsPropertyChangedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PropertyChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_property_changed(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PropertyChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SystemMediaTransportControls: ISystemMediaTransportControls}
impl RtActivatable<ISystemMediaTransportControlsStatics> for SystemMediaTransportControls {}
impl SystemMediaTransportControls {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<SystemMediaTransportControls>> { unsafe {
        <Self as RtActivatable<ISystemMediaTransportControlsStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(SystemMediaTransportControls(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,83,121,115,116,101,109,77,101,100,105,97,84,114,97,110,115,112,111,114,116,67,111,110,116,114,111,108,115,0]) [CLSID_SystemMediaTransportControls]);
DEFINE_IID!(IID_ISystemMediaTransportControls2, 3935884022, 32572, 19186, 165, 134, 114, 136, 152, 8, 239, 177);
RT_INTERFACE!{interface ISystemMediaTransportControls2(ISystemMediaTransportControls2Vtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControls2] {
    fn get_AutoRepeatMode(&self, out: *mut MediaPlaybackAutoRepeatMode) -> HRESULT,
    fn put_AutoRepeatMode(&self, value: MediaPlaybackAutoRepeatMode) -> HRESULT,
    fn get_ShuffleEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_ShuffleEnabled(&self, value: bool) -> HRESULT,
    fn get_PlaybackRate(&self, out: *mut f64) -> HRESULT,
    fn put_PlaybackRate(&self, value: f64) -> HRESULT,
    fn UpdateTimelineProperties(&self, timelineProperties: *mut SystemMediaTransportControlsTimelineProperties) -> HRESULT,
    fn add_PlaybackPositionChangeRequested(&self, handler: *mut super::foundation::TypedEventHandler<SystemMediaTransportControls, PlaybackPositionChangeRequestedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PlaybackPositionChangeRequested(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PlaybackRateChangeRequested(&self, handler: *mut super::foundation::TypedEventHandler<SystemMediaTransportControls, PlaybackRateChangeRequestedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PlaybackRateChangeRequested(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ShuffleEnabledChangeRequested(&self, handler: *mut super::foundation::TypedEventHandler<SystemMediaTransportControls, ShuffleEnabledChangeRequestedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ShuffleEnabledChangeRequested(&self, token: super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AutoRepeatModeChangeRequested(&self, handler: *mut super::foundation::TypedEventHandler<SystemMediaTransportControls, AutoRepeatModeChangeRequestedEventArgs>, out: *mut super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AutoRepeatModeChangeRequested(&self, token: super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISystemMediaTransportControls2 {
    #[inline] pub unsafe fn get_auto_repeat_mode(&self) -> Result<MediaPlaybackAutoRepeatMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoRepeatMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_repeat_mode(&self, value: MediaPlaybackAutoRepeatMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoRepeatMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_shuffle_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShuffleEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_shuffle_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShuffleEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_playback_rate(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlaybackRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_playback_rate(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaybackRate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn update_timeline_properties(&self, timelineProperties: &SystemMediaTransportControlsTimelineProperties) -> Result<()> {
        let hr = ((*self.lpVtbl).UpdateTimelineProperties)(self as *const _ as *mut _, timelineProperties as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_playback_position_change_requested(&self, handler: &super::foundation::TypedEventHandler<SystemMediaTransportControls, PlaybackPositionChangeRequestedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PlaybackPositionChangeRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_playback_position_change_requested(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PlaybackPositionChangeRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_playback_rate_change_requested(&self, handler: &super::foundation::TypedEventHandler<SystemMediaTransportControls, PlaybackRateChangeRequestedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PlaybackRateChangeRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_playback_rate_change_requested(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PlaybackRateChangeRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_shuffle_enabled_change_requested(&self, handler: &super::foundation::TypedEventHandler<SystemMediaTransportControls, ShuffleEnabledChangeRequestedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ShuffleEnabledChangeRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_shuffle_enabled_change_requested(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ShuffleEnabledChangeRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_auto_repeat_mode_change_requested(&self, handler: &super::foundation::TypedEventHandler<SystemMediaTransportControls, AutoRepeatModeChangeRequestedEventArgs>) -> Result<super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AutoRepeatModeChangeRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_auto_repeat_mode_change_requested(&self, token: super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AutoRepeatModeChangeRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum SystemMediaTransportControlsButton: i32 {
    Play (SystemMediaTransportControlsButton_Play) = 0, Pause (SystemMediaTransportControlsButton_Pause) = 1, Stop (SystemMediaTransportControlsButton_Stop) = 2, Record (SystemMediaTransportControlsButton_Record) = 3, FastForward (SystemMediaTransportControlsButton_FastForward) = 4, Rewind (SystemMediaTransportControlsButton_Rewind) = 5, Next (SystemMediaTransportControlsButton_Next) = 6, Previous (SystemMediaTransportControlsButton_Previous) = 7, ChannelUp (SystemMediaTransportControlsButton_ChannelUp) = 8, ChannelDown (SystemMediaTransportControlsButton_ChannelDown) = 9,
}}
DEFINE_IID!(IID_ISystemMediaTransportControlsButtonPressedEventArgs, 3086250262, 42351, 19912, 158, 17, 146, 3, 31, 74, 135, 194);
RT_INTERFACE!{interface ISystemMediaTransportControlsButtonPressedEventArgs(ISystemMediaTransportControlsButtonPressedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControlsButtonPressedEventArgs] {
    fn get_Button(&self, out: *mut SystemMediaTransportControlsButton) -> HRESULT
}}
impl ISystemMediaTransportControlsButtonPressedEventArgs {
    #[inline] pub unsafe fn get_button(&self) -> Result<SystemMediaTransportControlsButton> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Button)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SystemMediaTransportControlsButtonPressedEventArgs: ISystemMediaTransportControlsButtonPressedEventArgs}
DEFINE_IID!(IID_ISystemMediaTransportControlsDisplayUpdater, 2327561534, 64085, 20175, 173, 142, 201, 132, 229, 221, 21, 80);
RT_INTERFACE!{interface ISystemMediaTransportControlsDisplayUpdater(ISystemMediaTransportControlsDisplayUpdaterVtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControlsDisplayUpdater] {
    fn get_Type(&self, out: *mut MediaPlaybackType) -> HRESULT,
    fn put_Type(&self, value: MediaPlaybackType) -> HRESULT,
    fn get_AppMediaId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_AppMediaId(&self, value: HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Thumbnail(&self, out: *mut *mut super::storage::streams::RandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_Thumbnail(&self, value: *mut super::storage::streams::RandomAccessStreamReference) -> HRESULT,
    fn get_MusicProperties(&self, out: *mut *mut MusicDisplayProperties) -> HRESULT,
    fn get_VideoProperties(&self, out: *mut *mut VideoDisplayProperties) -> HRESULT,
    fn get_ImageProperties(&self, out: *mut *mut ImageDisplayProperties) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-storage")] fn CopyFromFileAsync(&self, type_: MediaPlaybackType, source: *mut super::storage::StorageFile, out: *mut *mut super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn ClearAll(&self) -> HRESULT,
    fn Update(&self) -> HRESULT
}}
impl ISystemMediaTransportControlsDisplayUpdater {
    #[inline] pub unsafe fn get_type(&self) -> Result<MediaPlaybackType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_type(&self, value: MediaPlaybackType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Type)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_media_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppMediaId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_app_media_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppMediaId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<super::storage::streams::RandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_thumbnail(&self, value: &super::storage::streams::RandomAccessStreamReference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Thumbnail)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_music_properties(&self) -> Result<ComPtr<MusicDisplayProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MusicProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_properties(&self) -> Result<ComPtr<VideoDisplayProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_image_properties(&self) -> Result<ComPtr<ImageDisplayProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ImageProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn copy_from_file_async(&self, type_: MediaPlaybackType, source: &super::storage::StorageFile) -> Result<ComPtr<super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CopyFromFileAsync)(self as *const _ as *mut _, type_, source as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_all(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ClearAll)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn update(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Update)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SystemMediaTransportControlsDisplayUpdater: ISystemMediaTransportControlsDisplayUpdater}
RT_ENUM! { enum SystemMediaTransportControlsProperty: i32 {
    SoundLevel (SystemMediaTransportControlsProperty_SoundLevel) = 0,
}}
DEFINE_IID!(IID_ISystemMediaTransportControlsPropertyChangedEventArgs, 3502901558, 13211, 19635, 142, 235, 115, 118, 7, 245, 110, 8);
RT_INTERFACE!{interface ISystemMediaTransportControlsPropertyChangedEventArgs(ISystemMediaTransportControlsPropertyChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControlsPropertyChangedEventArgs] {
    fn get_Property(&self, out: *mut SystemMediaTransportControlsProperty) -> HRESULT
}}
impl ISystemMediaTransportControlsPropertyChangedEventArgs {
    #[inline] pub unsafe fn get_property(&self) -> Result<SystemMediaTransportControlsProperty> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Property)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SystemMediaTransportControlsPropertyChangedEventArgs: ISystemMediaTransportControlsPropertyChangedEventArgs}
DEFINE_IID!(IID_ISystemMediaTransportControlsStatics, 1136277514, 60580, 18482, 145, 171, 212, 21, 250, 228, 132, 198);
RT_INTERFACE!{static interface ISystemMediaTransportControlsStatics(ISystemMediaTransportControlsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControlsStatics] {
    fn GetForCurrentView(&self, out: *mut *mut SystemMediaTransportControls) -> HRESULT
}}
impl ISystemMediaTransportControlsStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<SystemMediaTransportControls>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISystemMediaTransportControlsTimelineProperties, 1361391978, 50082, 18267, 133, 7, 147, 83, 77, 200, 143, 21);
RT_INTERFACE!{interface ISystemMediaTransportControlsTimelineProperties(ISystemMediaTransportControlsTimelinePropertiesVtbl): IInspectable(IInspectableVtbl) [IID_ISystemMediaTransportControlsTimelineProperties] {
    fn get_StartTime(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn put_StartTime(&self, value: super::foundation::TimeSpan) -> HRESULT,
    fn get_EndTime(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn put_EndTime(&self, value: super::foundation::TimeSpan) -> HRESULT,
    fn get_MinSeekTime(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn put_MinSeekTime(&self, value: super::foundation::TimeSpan) -> HRESULT,
    fn get_MaxSeekTime(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn put_MaxSeekTime(&self, value: super::foundation::TimeSpan) -> HRESULT,
    fn get_Position(&self, out: *mut super::foundation::TimeSpan) -> HRESULT,
    fn put_Position(&self, value: super::foundation::TimeSpan) -> HRESULT
}}
impl ISystemMediaTransportControlsTimelineProperties {
    #[inline] pub unsafe fn get_start_time(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_time(&self, value: super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_end_time(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EndTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_end_time(&self, value: super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EndTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_seek_time(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinSeekTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_seek_time(&self, value: super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinSeekTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_seek_time(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSeekTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_seek_time(&self, value: super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxSeekTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SystemMediaTransportControlsTimelineProperties: ISystemMediaTransportControlsTimelineProperties}
impl RtActivatable<IActivationFactory> for SystemMediaTransportControlsTimelineProperties {}
DEFINE_CLSID!(SystemMediaTransportControlsTimelineProperties(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,83,121,115,116,101,109,77,101,100,105,97,84,114,97,110,115,112,111,114,116,67,111,110,116,114,111,108,115,84,105,109,101,108,105,110,101,80,114,111,112,101,114,116,105,101,115,0]) [CLSID_SystemMediaTransportControlsTimelineProperties]);
DEFINE_IID!(IID_IVideoDisplayProperties, 1443495345, 23853, 18546, 129, 112, 69, 222, 229, 188, 47, 92);
RT_INTERFACE!{interface IVideoDisplayProperties(IVideoDisplayPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IVideoDisplayProperties] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Subtitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Subtitle(&self, value: HSTRING) -> HRESULT
}}
impl IVideoDisplayProperties {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subtitle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subtitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subtitle(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Subtitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VideoDisplayProperties: IVideoDisplayProperties}
DEFINE_IID!(IID_IVideoDisplayProperties2, 3021005262, 43858, 16811, 164, 134, 204, 16, 250, 177, 82, 249);
RT_INTERFACE!{interface IVideoDisplayProperties2(IVideoDisplayProperties2Vtbl): IInspectable(IInspectableVtbl) [IID_IVideoDisplayProperties2] {
    fn get_Genres(&self, out: *mut *mut super::foundation::collections::IVector<HString>) -> HRESULT
}}
impl IVideoDisplayProperties2 {
    #[inline] pub unsafe fn get_genres(&self) -> Result<ComPtr<super::foundation::collections::IVector<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Genres)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class VideoEffects}
impl RtActivatable<IVideoEffectsStatics> for VideoEffects {}
impl VideoEffects {
    #[inline] pub fn get_video_stabilization() -> Result<HString> { unsafe {
        <Self as RtActivatable<IVideoEffectsStatics>>::get_activation_factory().get_video_stabilization()
    }}
}
DEFINE_CLSID!(VideoEffects(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,86,105,100,101,111,69,102,102,101,99,116,115,0]) [CLSID_VideoEffects]);
DEFINE_IID!(IID_IVideoEffectsStatics, 533571048, 47857, 17697, 152, 12, 59, 206, 187, 68, 207, 56);
RT_INTERFACE!{static interface IVideoEffectsStatics(IVideoEffectsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IVideoEffectsStatics] {
    fn get_VideoStabilization(&self, out: *mut HSTRING) -> HRESULT
}}
impl IVideoEffectsStatics {
    #[inline] pub unsafe fn get_video_stabilization(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoStabilization)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVideoFrame, 213935653, 37116, 19602, 189, 149, 125, 237, 33, 129, 157, 28);
RT_INTERFACE!{interface IVideoFrame(IVideoFrameVtbl): IInspectable(IInspectableVtbl) [IID_IVideoFrame] {
    #[cfg(feature="windows-graphics")] fn get_SoftwareBitmap(&self, out: *mut *mut super::graphics::imaging::SoftwareBitmap) -> HRESULT,
    fn CopyToAsync(&self, frame: *mut VideoFrame, out: *mut *mut super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn get_Direct3DSurface(&self, out: *mut *mut super::graphics::directx::direct3d11::IDirect3DSurface) -> HRESULT
}}
impl IVideoFrame {
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_software_bitmap(&self) -> Result<ComPtr<super::graphics::imaging::SoftwareBitmap>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SoftwareBitmap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn copy_to_async(&self, frame: &VideoFrame) -> Result<ComPtr<super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CopyToAsync)(self as *const _ as *mut _, frame as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_direct3_dsurface(&self) -> Result<ComPtr<super::graphics::directx::direct3d11::IDirect3DSurface>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Direct3DSurface)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoFrame: IVideoFrame}
impl RtActivatable<IVideoFrameFactory> for VideoFrame {}
impl VideoFrame {
    #[cfg(feature="windows-graphics")] #[inline] pub fn create(format: super::graphics::imaging::BitmapPixelFormat, width: i32, height: i32) -> Result<ComPtr<VideoFrame>> { unsafe {
        <Self as RtActivatable<IVideoFrameFactory>>::get_activation_factory().create(format, width, height)
    }}
    #[cfg(feature="windows-graphics")] #[inline] pub fn create_with_alpha(format: super::graphics::imaging::BitmapPixelFormat, width: i32, height: i32, alpha: super::graphics::imaging::BitmapAlphaMode) -> Result<ComPtr<VideoFrame>> { unsafe {
        <Self as RtActivatable<IVideoFrameFactory>>::get_activation_factory().create_with_alpha(format, width, height, alpha)
    }}
}
DEFINE_CLSID!(VideoFrame(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,86,105,100,101,111,70,114,97,109,101,0]) [CLSID_VideoFrame]);
DEFINE_IID!(IID_IVideoFrameFactory, 21720425, 8744, 19602, 146, 255, 80, 195, 128, 211, 231, 118);
RT_INTERFACE!{static interface IVideoFrameFactory(IVideoFrameFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IVideoFrameFactory] {
    #[cfg(feature="windows-graphics")] fn Create(&self, format: super::graphics::imaging::BitmapPixelFormat, width: i32, height: i32, out: *mut *mut VideoFrame) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn CreateWithAlpha(&self, format: super::graphics::imaging::BitmapPixelFormat, width: i32, height: i32, alpha: super::graphics::imaging::BitmapAlphaMode, out: *mut *mut VideoFrame) -> HRESULT
}}
impl IVideoFrameFactory {
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn create(&self, format: super::graphics::imaging::BitmapPixelFormat, width: i32, height: i32) -> Result<ComPtr<VideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, format, width, height, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn create_with_alpha(&self, format: super::graphics::imaging::BitmapPixelFormat, width: i32, height: i32, alpha: super::graphics::imaging::BitmapAlphaMode) -> Result<ComPtr<VideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithAlpha)(self as *const _ as *mut _, format, width, height, alpha, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
pub mod capture { // Windows.Media.Capture
use ::prelude::*;
DEFINE_IID!(IID_IAdvancedCapturedPhoto, 4034032267, 45714, 17553, 157, 65, 153, 128, 122, 85, 11, 191);
RT_INTERFACE!{interface IAdvancedCapturedPhoto(IAdvancedCapturedPhotoVtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedCapturedPhoto] {
    fn get_Frame(&self, out: *mut *mut CapturedFrame) -> HRESULT,
    fn get_Mode(&self, out: *mut super::devices::AdvancedPhotoMode) -> HRESULT,
    fn get_Context(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IAdvancedCapturedPhoto {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<super::devices::AdvancedPhotoMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_context(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Context)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AdvancedCapturedPhoto: IAdvancedCapturedPhoto}
DEFINE_IID!(IID_IAdvancedCapturedPhoto2, 416247000, 53246, 17112, 129, 4, 1, 123, 179, 24, 244, 161);
RT_INTERFACE!{interface IAdvancedCapturedPhoto2(IAdvancedCapturedPhoto2Vtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedCapturedPhoto2] {
    fn get_FrameBoundsRelativeToReferencePhoto(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::Rect>) -> HRESULT
}}
impl IAdvancedCapturedPhoto2 {
    #[inline] pub unsafe fn get_frame_bounds_relative_to_reference_photo(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::Rect>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameBoundsRelativeToReferencePhoto)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdvancedPhotoCapture, 2214570746, 26215, 17628, 151, 60, 166, 188, 229, 150, 170, 15);
RT_INTERFACE!{interface IAdvancedPhotoCapture(IAdvancedPhotoCaptureVtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedPhotoCapture] {
    fn CaptureAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<AdvancedCapturedPhoto>) -> HRESULT,
    fn CaptureWithContextAsync(&self, context: *mut IInspectable, out: *mut *mut super::super::foundation::IAsyncOperation<AdvancedCapturedPhoto>) -> HRESULT,
    fn add_OptionalReferencePhotoCaptured(&self, handler: *mut super::super::foundation::TypedEventHandler<AdvancedPhotoCapture, OptionalReferencePhotoCapturedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_OptionalReferencePhotoCaptured(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AllPhotosCaptured(&self, handler: *mut super::super::foundation::TypedEventHandler<AdvancedPhotoCapture, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AllPhotosCaptured(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn FinishAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAdvancedPhotoCapture {
    #[inline] pub unsafe fn capture_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AdvancedCapturedPhoto>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CaptureAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn capture_with_context_async(&self, context: &IInspectable) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AdvancedCapturedPhoto>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CaptureWithContextAsync)(self as *const _ as *mut _, context as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_optional_reference_photo_captured(&self, handler: &super::super::foundation::TypedEventHandler<AdvancedPhotoCapture, OptionalReferencePhotoCapturedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_OptionalReferencePhotoCaptured)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_optional_reference_photo_captured(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_OptionalReferencePhotoCaptured)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_all_photos_captured(&self, handler: &super::super::foundation::TypedEventHandler<AdvancedPhotoCapture, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AllPhotosCaptured)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_all_photos_captured(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AllPhotosCaptured)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn finish_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FinishAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AdvancedPhotoCapture: IAdvancedPhotoCapture}
DEFINE_IID!(IID_IAppBroadcastBackgroundService, 3134318378, 64148, 18169, 149, 252, 215, 21, 17, 205, 167, 11);
RT_INTERFACE!{interface IAppBroadcastBackgroundService(IAppBroadcastBackgroundServiceVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastBackgroundService] {
    fn put_PlugInState(&self, value: AppBroadcastPlugInState) -> HRESULT,
    fn get_PlugInState(&self, out: *mut AppBroadcastPlugInState) -> HRESULT,
    fn put_SignInInfo(&self, value: *mut AppBroadcastBackgroundServiceSignInInfo) -> HRESULT,
    fn get_SignInInfo(&self, out: *mut *mut AppBroadcastBackgroundServiceSignInInfo) -> HRESULT,
    fn put_StreamInfo(&self, value: *mut AppBroadcastBackgroundServiceStreamInfo) -> HRESULT,
    fn get_StreamInfo(&self, out: *mut *mut AppBroadcastBackgroundServiceStreamInfo) -> HRESULT,
    fn get_AppId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_BroadcastTitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ViewerCount(&self, value: u32) -> HRESULT,
    fn get_ViewerCount(&self, out: *mut u32) -> HRESULT,
    fn TerminateBroadcast(&self, reason: AppBroadcastTerminationReason, providerSpecificReason: u32) -> HRESULT,
    fn add_HeartbeatRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, AppBroadcastHeartbeatRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HeartbeatRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_TitleId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppBroadcastBackgroundService {
    #[inline] pub unsafe fn set_plug_in_state(&self, value: AppBroadcastPlugInState) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlugInState)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_plug_in_state(&self) -> Result<AppBroadcastPlugInState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlugInState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sign_in_info(&self, value: &AppBroadcastBackgroundServiceSignInInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SignInInfo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sign_in_info(&self) -> Result<ComPtr<AppBroadcastBackgroundServiceSignInInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SignInInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stream_info(&self, value: &AppBroadcastBackgroundServiceStreamInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StreamInfo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stream_info(&self) -> Result<ComPtr<AppBroadcastBackgroundServiceStreamInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StreamInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastTitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_viewer_count(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ViewerCount)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_viewer_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ViewerCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn terminate_broadcast(&self, reason: AppBroadcastTerminationReason, providerSpecificReason: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).TerminateBroadcast)(self as *const _ as *mut _, reason, providerSpecificReason);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_heartbeat_requested(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, AppBroadcastHeartbeatRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HeartbeatRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_heartbeat_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HeartbeatRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastBackgroundService: IAppBroadcastBackgroundService}
DEFINE_IID!(IID_IAppBroadcastBackgroundService2, 4237085631, 21833, 19335, 149, 159, 35, 202, 64, 31, 212, 115);
RT_INTERFACE!{interface IAppBroadcastBackgroundService2(IAppBroadcastBackgroundService2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastBackgroundService2] {
    fn put_BroadcastTitle(&self, value: HSTRING) -> HRESULT,
    fn get_BroadcastLanguage(&self, out: *mut HSTRING) -> HRESULT,
    fn put_BroadcastLanguage(&self, value: HSTRING) -> HRESULT,
    fn get_BroadcastChannel(&self, out: *mut HSTRING) -> HRESULT,
    fn put_BroadcastChannel(&self, value: HSTRING) -> HRESULT,
    fn add_BroadcastTitleChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BroadcastTitleChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_BroadcastLanguageChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BroadcastLanguageChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_BroadcastChannelChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BroadcastChannelChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastBackgroundService2 {
    #[inline] pub unsafe fn set_broadcast_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BroadcastTitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastLanguage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_broadcast_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BroadcastLanguage)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_channel(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastChannel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_broadcast_channel(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BroadcastChannel)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_broadcast_title_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BroadcastTitleChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_broadcast_title_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BroadcastTitleChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_broadcast_language_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BroadcastLanguageChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_broadcast_language_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BroadcastLanguageChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_broadcast_channel_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundService, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BroadcastChannelChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_broadcast_channel_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BroadcastChannelChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBroadcastBackgroundServiceSignInInfo, 1584616053, 35016, 20170, 137, 186, 72, 37, 152, 93, 184, 128);
RT_INTERFACE!{interface IAppBroadcastBackgroundServiceSignInInfo(IAppBroadcastBackgroundServiceSignInInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastBackgroundServiceSignInInfo] {
    fn get_SignInState(&self, out: *mut AppBroadcastSignInState) -> HRESULT,
    fn put_OAuthRequestUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_OAuthRequestUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_OAuthCallbackUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_OAuthCallbackUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-security")] fn get_AuthenticationResult(&self, out: *mut *mut super::super::security::authentication::web::WebAuthenticationResult) -> HRESULT,
    fn put_UserName(&self, value: HSTRING) -> HRESULT,
    fn get_UserName(&self, out: *mut HSTRING) -> HRESULT,
    fn add_SignInStateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceSignInInfo, AppBroadcastSignInStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SignInStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastBackgroundServiceSignInInfo {
    #[inline] pub unsafe fn get_sign_in_state(&self) -> Result<AppBroadcastSignInState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SignInState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_oauth_request_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OAuthRequestUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_oauth_request_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OAuthRequestUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_oauth_callback_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OAuthCallbackUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_oauth_callback_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OAuthCallbackUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_authentication_result(&self) -> Result<ComPtr<super::super::security::authentication::web::WebAuthenticationResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AuthenticationResult)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_user_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UserName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sign_in_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceSignInInfo, AppBroadcastSignInStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SignInStateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sign_in_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SignInStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastBackgroundServiceSignInInfo: IAppBroadcastBackgroundServiceSignInInfo}
DEFINE_IID!(IID_IAppBroadcastBackgroundServiceSignInInfo2, 2432968796, 25295, 19004, 167, 238, 174, 181, 7, 64, 70, 69);
RT_INTERFACE!{interface IAppBroadcastBackgroundServiceSignInInfo2(IAppBroadcastBackgroundServiceSignInInfo2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastBackgroundServiceSignInInfo2] {
    fn add_UserNameChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceSignInInfo, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UserNameChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastBackgroundServiceSignInInfo2 {
    #[inline] pub unsafe fn add_user_name_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceSignInInfo, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UserNameChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_user_name_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UserNameChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBroadcastBackgroundServiceStreamInfo, 836502204, 39178, 18692, 170, 150, 254, 54, 67, 129, 241, 54);
RT_INTERFACE!{interface IAppBroadcastBackgroundServiceStreamInfo(IAppBroadcastBackgroundServiceStreamInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastBackgroundServiceStreamInfo] {
    fn get_StreamState(&self, out: *mut AppBroadcastStreamState) -> HRESULT,
    fn put_DesiredVideoEncodingBitrate(&self, value: u64) -> HRESULT,
    fn get_DesiredVideoEncodingBitrate(&self, out: *mut u64) -> HRESULT,
    fn put_BandwidthTestBitrate(&self, value: u64) -> HRESULT,
    fn get_BandwidthTestBitrate(&self, out: *mut u64) -> HRESULT,
    fn put_AudioCodec(&self, value: HSTRING) -> HRESULT,
    fn get_AudioCodec(&self, out: *mut HSTRING) -> HRESULT,
    fn get_BroadcastStreamReader(&self, out: *mut *mut AppBroadcastStreamReader) -> HRESULT,
    fn add_StreamStateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceStreamInfo, AppBroadcastStreamStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StreamStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_VideoEncodingResolutionChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceStreamInfo, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VideoEncodingResolutionChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_VideoEncodingBitrateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceStreamInfo, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VideoEncodingBitrateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastBackgroundServiceStreamInfo {
    #[inline] pub unsafe fn get_stream_state(&self) -> Result<AppBroadcastStreamState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StreamState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_video_encoding_bitrate(&self, value: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredVideoEncodingBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_video_encoding_bitrate(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredVideoEncodingBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bandwidth_test_bitrate(&self, value: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BandwidthTestBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bandwidth_test_bitrate(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BandwidthTestBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_audio_codec(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioCodec)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_codec(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioCodec)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_stream_reader(&self) -> Result<ComPtr<AppBroadcastStreamReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastStreamReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stream_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceStreamInfo, AppBroadcastStreamStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StreamStateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stream_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StreamStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_video_encoding_resolution_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceStreamInfo, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VideoEncodingResolutionChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_video_encoding_resolution_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VideoEncodingResolutionChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_video_encoding_bitrate_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastBackgroundServiceStreamInfo, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VideoEncodingBitrateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_video_encoding_bitrate_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VideoEncodingBitrateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastBackgroundServiceStreamInfo: IAppBroadcastBackgroundServiceStreamInfo}
DEFINE_IID!(IID_IAppBroadcastBackgroundServiceStreamInfo2, 3172900717, 38108, 20430, 149, 65, 169, 241, 41, 89, 99, 52);
RT_INTERFACE!{interface IAppBroadcastBackgroundServiceStreamInfo2(IAppBroadcastBackgroundServiceStreamInfo2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastBackgroundServiceStreamInfo2] {
    fn ReportProblemWithStream(&self) -> HRESULT
}}
impl IAppBroadcastBackgroundServiceStreamInfo2 {
    #[inline] pub unsafe fn report_problem_with_stream(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportProblemWithStream)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppBroadcastCameraCaptureState: i32 {
    Stopped (AppBroadcastCameraCaptureState_Stopped) = 0, Started (AppBroadcastCameraCaptureState_Started) = 1, Failed (AppBroadcastCameraCaptureState_Failed) = 2,
}}
DEFINE_IID!(IID_IAppBroadcastCameraCaptureStateChangedEventArgs, 506678480, 47234, 19336, 134, 146, 5, 153, 154, 206, 183, 15);
RT_INTERFACE!{interface IAppBroadcastCameraCaptureStateChangedEventArgs(IAppBroadcastCameraCaptureStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastCameraCaptureStateChangedEventArgs] {
    fn get_State(&self, out: *mut AppBroadcastCameraCaptureState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut u32) -> HRESULT
}}
impl IAppBroadcastCameraCaptureStateChangedEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<AppBroadcastCameraCaptureState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastCameraCaptureStateChangedEventArgs: IAppBroadcastCameraCaptureStateChangedEventArgs}
RT_ENUM! { enum AppBroadcastCameraOverlayLocation: i32 {
    TopLeft (AppBroadcastCameraOverlayLocation_TopLeft) = 0, TopCenter (AppBroadcastCameraOverlayLocation_TopCenter) = 1, TopRight (AppBroadcastCameraOverlayLocation_TopRight) = 2, MiddleLeft (AppBroadcastCameraOverlayLocation_MiddleLeft) = 3, MiddleCenter (AppBroadcastCameraOverlayLocation_MiddleCenter) = 4, MiddleRight (AppBroadcastCameraOverlayLocation_MiddleRight) = 5, BottomLeft (AppBroadcastCameraOverlayLocation_BottomLeft) = 6, BottomCenter (AppBroadcastCameraOverlayLocation_BottomCenter) = 7, BottomRight (AppBroadcastCameraOverlayLocation_BottomRight) = 8,
}}
RT_ENUM! { enum AppBroadcastCameraOverlaySize: i32 {
    Small (AppBroadcastCameraOverlaySize_Small) = 0, Medium (AppBroadcastCameraOverlaySize_Medium) = 1, Large (AppBroadcastCameraOverlaySize_Large) = 2,
}}
RT_ENUM! { enum AppBroadcastCaptureTargetType: i32 {
    AppView (AppBroadcastCaptureTargetType_AppView) = 0, EntireDisplay (AppBroadcastCaptureTargetType_EntireDisplay) = 1,
}}
RT_ENUM! { enum AppBroadcastExitBroadcastModeReason: i32 {
    NormalExit (AppBroadcastExitBroadcastModeReason_NormalExit) = 0, UserCanceled (AppBroadcastExitBroadcastModeReason_UserCanceled) = 1, AuthorizationFail (AppBroadcastExitBroadcastModeReason_AuthorizationFail) = 2, ForegroundAppActivated (AppBroadcastExitBroadcastModeReason_ForegroundAppActivated) = 3,
}}
DEFINE_IID!(IID_IAppBroadcastGlobalSettings, 2999658405, 28924, 19991, 128, 189, 107, 160, 253, 63, 243, 160);
RT_INTERFACE!{interface IAppBroadcastGlobalSettings(IAppBroadcastGlobalSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastGlobalSettings] {
    fn get_IsBroadcastEnabled(&self, out: *mut bool) -> HRESULT,
    fn get_IsDisabledByPolicy(&self, out: *mut bool) -> HRESULT,
    fn get_IsGpuConstrained(&self, out: *mut bool) -> HRESULT,
    fn get_HasHardwareEncoder(&self, out: *mut bool) -> HRESULT,
    fn put_IsAudioCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsAudioCaptureEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsMicrophoneCaptureEnabledByDefault(&self, value: bool) -> HRESULT,
    fn get_IsMicrophoneCaptureEnabledByDefault(&self, out: *mut bool) -> HRESULT,
    fn put_IsEchoCancellationEnabled(&self, value: bool) -> HRESULT,
    fn get_IsEchoCancellationEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_SystemAudioGain(&self, value: f64) -> HRESULT,
    fn get_SystemAudioGain(&self, out: *mut f64) -> HRESULT,
    fn put_MicrophoneGain(&self, value: f64) -> HRESULT,
    fn get_MicrophoneGain(&self, out: *mut f64) -> HRESULT,
    fn put_IsCameraCaptureEnabledByDefault(&self, value: bool) -> HRESULT,
    fn get_IsCameraCaptureEnabledByDefault(&self, out: *mut bool) -> HRESULT,
    fn put_SelectedCameraId(&self, value: HSTRING) -> HRESULT,
    fn get_SelectedCameraId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CameraOverlayLocation(&self, value: AppBroadcastCameraOverlayLocation) -> HRESULT,
    fn get_CameraOverlayLocation(&self, out: *mut AppBroadcastCameraOverlayLocation) -> HRESULT,
    fn put_CameraOverlaySize(&self, value: AppBroadcastCameraOverlaySize) -> HRESULT,
    fn get_CameraOverlaySize(&self, out: *mut AppBroadcastCameraOverlaySize) -> HRESULT,
    fn put_IsCursorImageCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsCursorImageCaptureEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IAppBroadcastGlobalSettings {
    #[inline] pub unsafe fn get_is_broadcast_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBroadcastEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled_by_policy(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabledByPolicy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_gpu_constrained(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGpuConstrained)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_hardware_encoder(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasHardwareEncoder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_audio_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAudioCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_audio_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAudioCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_microphone_capture_enabled_by_default(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsMicrophoneCaptureEnabledByDefault)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_microphone_capture_enabled_by_default(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMicrophoneCaptureEnabledByDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_echo_cancellation_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEchoCancellationEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_echo_cancellation_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEchoCancellationEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_audio_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemAudioGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_audio_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemAudioGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_microphone_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MicrophoneGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_microphone_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MicrophoneGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_camera_capture_enabled_by_default(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCameraCaptureEnabledByDefault)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_camera_capture_enabled_by_default(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCameraCaptureEnabledByDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected_camera_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedCameraId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_camera_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedCameraId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_camera_overlay_location(&self, value: AppBroadcastCameraOverlayLocation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CameraOverlayLocation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_overlay_location(&self) -> Result<AppBroadcastCameraOverlayLocation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CameraOverlayLocation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_camera_overlay_size(&self, value: AppBroadcastCameraOverlaySize) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CameraOverlaySize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_overlay_size(&self) -> Result<AppBroadcastCameraOverlaySize> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CameraOverlaySize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_cursor_image_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCursorImageCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_cursor_image_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCursorImageCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastGlobalSettings: IAppBroadcastGlobalSettings}
DEFINE_IID!(IID_IAppBroadcastHeartbeatRequestedEventArgs, 3466936963, 61009, 19903, 148, 114, 121, 169, 237, 78, 33, 101);
RT_INTERFACE!{interface IAppBroadcastHeartbeatRequestedEventArgs(IAppBroadcastHeartbeatRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastHeartbeatRequestedEventArgs] {
    fn put_Handled(&self, value: bool) -> HRESULT,
    fn get_Handled(&self, out: *mut bool) -> HRESULT
}}
impl IAppBroadcastHeartbeatRequestedEventArgs {
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastHeartbeatRequestedEventArgs: IAppBroadcastHeartbeatRequestedEventArgs}
RT_CLASS!{static class AppBroadcastManager}
impl RtActivatable<IAppBroadcastManagerStatics> for AppBroadcastManager {}
impl AppBroadcastManager {
    #[inline] pub fn get_global_settings() -> Result<ComPtr<AppBroadcastGlobalSettings>> { unsafe {
        <Self as RtActivatable<IAppBroadcastManagerStatics>>::get_activation_factory().get_global_settings()
    }}
    #[inline] pub fn apply_global_settings(value: &AppBroadcastGlobalSettings) -> Result<()> { unsafe {
        <Self as RtActivatable<IAppBroadcastManagerStatics>>::get_activation_factory().apply_global_settings(value)
    }}
    #[inline] pub fn get_provider_settings() -> Result<ComPtr<AppBroadcastProviderSettings>> { unsafe {
        <Self as RtActivatable<IAppBroadcastManagerStatics>>::get_activation_factory().get_provider_settings()
    }}
    #[inline] pub fn apply_provider_settings(value: &AppBroadcastProviderSettings) -> Result<()> { unsafe {
        <Self as RtActivatable<IAppBroadcastManagerStatics>>::get_activation_factory().apply_provider_settings(value)
    }}
}
DEFINE_CLSID!(AppBroadcastManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,65,112,112,66,114,111,97,100,99,97,115,116,77,97,110,97,103,101,114,0]) [CLSID_AppBroadcastManager]);
DEFINE_IID!(IID_IAppBroadcastManagerStatics, 911081867, 7758, 16671, 171, 62, 146, 149, 152, 68, 193, 86);
RT_INTERFACE!{static interface IAppBroadcastManagerStatics(IAppBroadcastManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastManagerStatics] {
    fn GetGlobalSettings(&self, out: *mut *mut AppBroadcastGlobalSettings) -> HRESULT,
    fn ApplyGlobalSettings(&self, value: *mut AppBroadcastGlobalSettings) -> HRESULT,
    fn GetProviderSettings(&self, out: *mut *mut AppBroadcastProviderSettings) -> HRESULT,
    fn ApplyProviderSettings(&self, value: *mut AppBroadcastProviderSettings) -> HRESULT
}}
impl IAppBroadcastManagerStatics {
    #[inline] pub unsafe fn get_global_settings(&self) -> Result<ComPtr<AppBroadcastGlobalSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetGlobalSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn apply_global_settings(&self, value: &AppBroadcastGlobalSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).ApplyGlobalSettings)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_provider_settings(&self) -> Result<ComPtr<AppBroadcastProviderSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetProviderSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn apply_provider_settings(&self, value: &AppBroadcastProviderSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).ApplyProviderSettings)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppBroadcastMicrophoneCaptureState: i32 {
    Stopped (AppBroadcastMicrophoneCaptureState_Stopped) = 0, Started (AppBroadcastMicrophoneCaptureState_Started) = 1, Failed (AppBroadcastMicrophoneCaptureState_Failed) = 2,
}}
DEFINE_IID!(IID_IAppBroadcastMicrophoneCaptureStateChangedEventArgs, 2825573865, 37952, 18696, 157, 9, 101, 183, 227, 21, 215, 149);
RT_INTERFACE!{interface IAppBroadcastMicrophoneCaptureStateChangedEventArgs(IAppBroadcastMicrophoneCaptureStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastMicrophoneCaptureStateChangedEventArgs] {
    fn get_State(&self, out: *mut AppBroadcastMicrophoneCaptureState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut u32) -> HRESULT
}}
impl IAppBroadcastMicrophoneCaptureStateChangedEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<AppBroadcastMicrophoneCaptureState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastMicrophoneCaptureStateChangedEventArgs: IAppBroadcastMicrophoneCaptureStateChangedEventArgs}
DEFINE_IID!(IID_IAppBroadcastPlugIn, 1376525926, 25875, 17780, 172, 84, 35, 183, 151, 41, 97, 91);
RT_INTERFACE!{interface IAppBroadcastPlugIn(IAppBroadcastPlugInVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPlugIn] {
    fn get_AppId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ProviderSettings(&self, out: *mut *mut AppBroadcastProviderSettings) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Logo(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppBroadcastPlugIn {
    #[inline] pub unsafe fn get_app_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_provider_settings(&self) -> Result<ComPtr<AppBroadcastProviderSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProviderSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_logo(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPlugIn: IAppBroadcastPlugIn}
DEFINE_IID!(IID_IAppBroadcastPlugInManager, 3847281017, 10145, 18855, 187, 244, 215, 169, 233, 208, 118, 104);
RT_INTERFACE!{interface IAppBroadcastPlugInManager(IAppBroadcastPlugInManagerVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPlugInManager] {
    fn get_IsBroadcastProviderAvailable(&self, out: *mut bool) -> HRESULT,
    fn get_PlugInList(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AppBroadcastPlugIn>) -> HRESULT,
    fn get_DefaultPlugIn(&self, out: *mut *mut AppBroadcastPlugIn) -> HRESULT,
    fn put_DefaultPlugIn(&self, value: *mut AppBroadcastPlugIn) -> HRESULT
}}
impl IAppBroadcastPlugInManager {
    #[inline] pub unsafe fn get_is_broadcast_provider_available(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBroadcastProviderAvailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_plug_in_list(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AppBroadcastPlugIn>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlugInList)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_plug_in(&self) -> Result<ComPtr<AppBroadcastPlugIn>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultPlugIn)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_plug_in(&self, value: &AppBroadcastPlugIn) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultPlugIn)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPlugInManager: IAppBroadcastPlugInManager}
impl RtActivatable<IAppBroadcastPlugInManagerStatics> for AppBroadcastPlugInManager {}
impl AppBroadcastPlugInManager {
    #[inline] pub fn get_default() -> Result<ComPtr<AppBroadcastPlugInManager>> { unsafe {
        <Self as RtActivatable<IAppBroadcastPlugInManagerStatics>>::get_activation_factory().get_default()
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<AppBroadcastPlugInManager>> { unsafe {
        <Self as RtActivatable<IAppBroadcastPlugInManagerStatics>>::get_activation_factory().get_for_user(user)
    }}
}
DEFINE_CLSID!(AppBroadcastPlugInManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,65,112,112,66,114,111,97,100,99,97,115,116,80,108,117,103,73,110,77,97,110,97,103,101,114,0]) [CLSID_AppBroadcastPlugInManager]);
DEFINE_IID!(IID_IAppBroadcastPlugInManagerStatics, 4066663456, 23670, 19676, 147, 100, 130, 254, 158, 182, 83, 77);
RT_INTERFACE!{static interface IAppBroadcastPlugInManagerStatics(IAppBroadcastPlugInManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPlugInManagerStatics] {
    fn GetDefault(&self, out: *mut *mut AppBroadcastPlugInManager) -> HRESULT,
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut AppBroadcastPlugInManager) -> HRESULT
}}
impl IAppBroadcastPlugInManagerStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<AppBroadcastPlugInManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<AppBroadcastPlugInManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppBroadcastPlugInState: i32 {
    Unknown (AppBroadcastPlugInState_Unknown) = 0, Initialized (AppBroadcastPlugInState_Initialized) = 1, MicrosoftSignInRequired (AppBroadcastPlugInState_MicrosoftSignInRequired) = 2, OAuthSignInRequired (AppBroadcastPlugInState_OAuthSignInRequired) = 3, ProviderSignInRequired (AppBroadcastPlugInState_ProviderSignInRequired) = 4, InBandwidthTest (AppBroadcastPlugInState_InBandwidthTest) = 5, ReadyToBroadcast (AppBroadcastPlugInState_ReadyToBroadcast) = 6,
}}
DEFINE_IID!(IID_IAppBroadcastPlugInStateChangedEventArgs, 1216467186, 43973, 20422, 132, 176, 137, 55, 11, 180, 114, 18);
RT_INTERFACE!{interface IAppBroadcastPlugInStateChangedEventArgs(IAppBroadcastPlugInStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPlugInStateChangedEventArgs] {
    fn get_PlugInState(&self, out: *mut AppBroadcastPlugInState) -> HRESULT
}}
impl IAppBroadcastPlugInStateChangedEventArgs {
    #[inline] pub unsafe fn get_plug_in_state(&self) -> Result<AppBroadcastPlugInState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlugInState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPlugInStateChangedEventArgs: IAppBroadcastPlugInStateChangedEventArgs}
DEFINE_IID!(IID_IAppBroadcastPreview, 347475802, 28234, 19328, 161, 79, 103, 238, 119, 209, 83, 231);
RT_INTERFACE!{interface IAppBroadcastPreview(IAppBroadcastPreviewVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPreview] {
    fn StopPreview(&self) -> HRESULT,
    fn get_PreviewState(&self, out: *mut AppBroadcastPreviewState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn add_PreviewStateChanged(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastPreview, AppBroadcastPreviewStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PreviewStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_PreviewStreamReader(&self, out: *mut *mut AppBroadcastPreviewStreamReader) -> HRESULT
}}
impl IAppBroadcastPreview {
    #[inline] pub unsafe fn stop_preview(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopPreview)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_state(&self) -> Result<AppBroadcastPreviewState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PreviewState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_preview_state_changed(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastPreview, AppBroadcastPreviewStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PreviewStateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_preview_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PreviewStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_stream_reader(&self) -> Result<ComPtr<AppBroadcastPreviewStreamReader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreviewStreamReader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPreview: IAppBroadcastPreview}
RT_ENUM! { enum AppBroadcastPreviewState: i32 {
    Started (AppBroadcastPreviewState_Started) = 0, Stopped (AppBroadcastPreviewState_Stopped) = 1, Failed (AppBroadcastPreviewState_Failed) = 2,
}}
DEFINE_IID!(IID_IAppBroadcastPreviewStateChangedEventArgs, 1515713246, 36330, 20102, 144, 173, 3, 252, 38, 185, 101, 60);
RT_INTERFACE!{interface IAppBroadcastPreviewStateChangedEventArgs(IAppBroadcastPreviewStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPreviewStateChangedEventArgs] {
    fn get_PreviewState(&self, out: *mut AppBroadcastPreviewState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut u32) -> HRESULT
}}
impl IAppBroadcastPreviewStateChangedEventArgs {
    #[inline] pub unsafe fn get_preview_state(&self) -> Result<AppBroadcastPreviewState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PreviewState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPreviewStateChangedEventArgs: IAppBroadcastPreviewStateChangedEventArgs}
DEFINE_IID!(IID_IAppBroadcastPreviewStreamReader, 2451737936, 56127, 16552, 140, 212, 244, 227, 113, 221, 171, 55);
RT_INTERFACE!{interface IAppBroadcastPreviewStreamReader(IAppBroadcastPreviewStreamReaderVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPreviewStreamReader] {
    fn get_VideoWidth(&self, out: *mut u32) -> HRESULT,
    fn get_VideoHeight(&self, out: *mut u32) -> HRESULT,
    fn get_VideoStride(&self, out: *mut u32) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-graphics")] fn get_VideoBitmapPixelFormat(&self, out: *mut super::super::graphics::imaging::BitmapPixelFormat) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-graphics")] fn get_VideoBitmapAlphaMode(&self, out: *mut super::super::graphics::imaging::BitmapAlphaMode) -> HRESULT,
    fn TryGetNextVideoFrame(&self, out: *mut *mut AppBroadcastPreviewStreamVideoFrame) -> HRESULT,
    fn add_VideoFrameArrived(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastPreviewStreamReader, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VideoFrameArrived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastPreviewStreamReader {
    #[inline] pub unsafe fn get_video_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_stride(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoStride)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_video_bitmap_pixel_format(&self) -> Result<super::super::graphics::imaging::BitmapPixelFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoBitmapPixelFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_video_bitmap_alpha_mode(&self) -> Result<super::super::graphics::imaging::BitmapAlphaMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoBitmapAlphaMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_next_video_frame(&self) -> Result<ComPtr<AppBroadcastPreviewStreamVideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetNextVideoFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_video_frame_arrived(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastPreviewStreamReader, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VideoFrameArrived)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_video_frame_arrived(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VideoFrameArrived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPreviewStreamReader: IAppBroadcastPreviewStreamReader}
DEFINE_IID!(IID_IAppBroadcastPreviewStreamVideoFrame, 17809057, 38142, 17561, 184, 192, 141, 36, 66, 121, 251, 18);
RT_INTERFACE!{interface IAppBroadcastPreviewStreamVideoFrame(IAppBroadcastPreviewStreamVideoFrameVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPreviewStreamVideoFrame] {
    fn get_VideoHeader(&self, out: *mut *mut AppBroadcastPreviewStreamVideoHeader) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_VideoBuffer(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl IAppBroadcastPreviewStreamVideoFrame {
    #[inline] pub unsafe fn get_video_header(&self) -> Result<ComPtr<AppBroadcastPreviewStreamVideoHeader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoHeader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_video_buffer(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoBuffer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPreviewStreamVideoFrame: IAppBroadcastPreviewStreamVideoFrame}
DEFINE_IID!(IID_IAppBroadcastPreviewStreamVideoHeader, 2347720979, 55940, 17561, 167, 171, 135, 17, 140, 180, 161, 87);
RT_INTERFACE!{interface IAppBroadcastPreviewStreamVideoHeader(IAppBroadcastPreviewStreamVideoHeaderVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastPreviewStreamVideoHeader] {
    fn get_AbsoluteTimestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_RelativeTimestamp(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_FrameId(&self, out: *mut u64) -> HRESULT
}}
impl IAppBroadcastPreviewStreamVideoHeader {
    #[inline] pub unsafe fn get_absolute_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AbsoluteTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_relative_timestamp(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RelativeTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_id(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FrameId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastPreviewStreamVideoHeader: IAppBroadcastPreviewStreamVideoHeader}
DEFINE_IID!(IID_IAppBroadcastProviderSettings, 3272335202, 39240, 17807, 173, 80, 170, 6, 236, 3, 218, 8);
RT_INTERFACE!{interface IAppBroadcastProviderSettings(IAppBroadcastProviderSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastProviderSettings] {
    fn put_DefaultBroadcastTitle(&self, value: HSTRING) -> HRESULT,
    fn get_DefaultBroadcastTitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_AudioEncodingBitrate(&self, value: u32) -> HRESULT,
    fn get_AudioEncodingBitrate(&self, out: *mut u32) -> HRESULT,
    fn put_CustomVideoEncodingBitrate(&self, value: u32) -> HRESULT,
    fn get_CustomVideoEncodingBitrate(&self, out: *mut u32) -> HRESULT,
    fn put_CustomVideoEncodingHeight(&self, value: u32) -> HRESULT,
    fn get_CustomVideoEncodingHeight(&self, out: *mut u32) -> HRESULT,
    fn put_CustomVideoEncodingWidth(&self, value: u32) -> HRESULT,
    fn get_CustomVideoEncodingWidth(&self, out: *mut u32) -> HRESULT,
    fn put_VideoEncodingBitrateMode(&self, value: AppBroadcastVideoEncodingBitrateMode) -> HRESULT,
    fn get_VideoEncodingBitrateMode(&self, out: *mut AppBroadcastVideoEncodingBitrateMode) -> HRESULT,
    fn put_VideoEncodingResolutionMode(&self, value: AppBroadcastVideoEncodingResolutionMode) -> HRESULT,
    fn get_VideoEncodingResolutionMode(&self, out: *mut AppBroadcastVideoEncodingResolutionMode) -> HRESULT
}}
impl IAppBroadcastProviderSettings {
    #[inline] pub unsafe fn set_default_broadcast_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultBroadcastTitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_broadcast_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultBroadcastTitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_audio_encoding_bitrate(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioEncodingBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_encoding_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioEncodingBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_video_encoding_bitrate(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomVideoEncodingBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_video_encoding_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomVideoEncodingBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_video_encoding_height(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomVideoEncodingHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_video_encoding_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomVideoEncodingHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_video_encoding_width(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomVideoEncodingWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_video_encoding_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomVideoEncodingWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_encoding_bitrate_mode(&self, value: AppBroadcastVideoEncodingBitrateMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoEncodingBitrateMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_encoding_bitrate_mode(&self) -> Result<AppBroadcastVideoEncodingBitrateMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoEncodingBitrateMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_encoding_resolution_mode(&self, value: AppBroadcastVideoEncodingResolutionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoEncodingResolutionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_encoding_resolution_mode(&self) -> Result<AppBroadcastVideoEncodingResolutionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoEncodingResolutionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastProviderSettings: IAppBroadcastProviderSettings}
DEFINE_IID!(IID_IAppBroadcastServices, 2254484694, 38555, 20028, 172, 58, 139, 4, 46, 228, 238, 99);
RT_INTERFACE!{interface IAppBroadcastServices(IAppBroadcastServicesVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastServices] {
    fn get_CaptureTargetType(&self, out: *mut AppBroadcastCaptureTargetType) -> HRESULT,
    fn put_CaptureTargetType(&self, value: AppBroadcastCaptureTargetType) -> HRESULT,
    fn get_BroadcastTitle(&self, out: *mut HSTRING) -> HRESULT,
    fn put_BroadcastTitle(&self, value: HSTRING) -> HRESULT,
    fn get_BroadcastLanguage(&self, out: *mut HSTRING) -> HRESULT,
    fn put_BroadcastLanguage(&self, value: HSTRING) -> HRESULT,
    fn get_UserName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CanCapture(&self, out: *mut bool) -> HRESULT,
    fn EnterBroadcastModeAsync(&self, plugIn: *mut AppBroadcastPlugIn, out: *mut *mut super::super::foundation::IAsyncOperation<u32>) -> HRESULT,
    fn ExitBroadcastMode(&self, reason: AppBroadcastExitBroadcastModeReason) -> HRESULT,
    fn StartBroadcast(&self) -> HRESULT,
    fn PauseBroadcast(&self) -> HRESULT,
    fn ResumeBroadcast(&self) -> HRESULT,
    fn StartPreview(&self, desiredSize: super::super::foundation::Size, out: *mut *mut AppBroadcastPreview) -> HRESULT,
    fn get_State(&self, out: *mut *mut AppBroadcastState) -> HRESULT
}}
impl IAppBroadcastServices {
    #[inline] pub unsafe fn get_capture_target_type(&self) -> Result<AppBroadcastCaptureTargetType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaptureTargetType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_capture_target_type(&self, value: AppBroadcastCaptureTargetType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CaptureTargetType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastTitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_broadcast_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BroadcastTitle)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_broadcast_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BroadcastLanguage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_broadcast_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BroadcastLanguage)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_user_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UserName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_capture(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanCapture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn enter_broadcast_mode_async(&self, plugIn: &AppBroadcastPlugIn) -> Result<ComPtr<super::super::foundation::IAsyncOperation<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).EnterBroadcastModeAsync)(self as *const _ as *mut _, plugIn as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn exit_broadcast_mode(&self, reason: AppBroadcastExitBroadcastModeReason) -> Result<()> {
        let hr = ((*self.lpVtbl).ExitBroadcastMode)(self as *const _ as *mut _, reason);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_broadcast(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StartBroadcast)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn pause_broadcast(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).PauseBroadcast)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn resume_broadcast(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ResumeBroadcast)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_preview(&self, desiredSize: super::super::foundation::Size) -> Result<ComPtr<AppBroadcastPreview>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartPreview)(self as *const _ as *mut _, desiredSize, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<ComPtr<AppBroadcastState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastServices: IAppBroadcastServices}
RT_ENUM! { enum AppBroadcastSignInResult: i32 {
    Success (AppBroadcastSignInResult_Success) = 0, AuthenticationFailed (AppBroadcastSignInResult_AuthenticationFailed) = 1, Unauthorized (AppBroadcastSignInResult_Unauthorized) = 2, ServiceUnavailable (AppBroadcastSignInResult_ServiceUnavailable) = 3, Unknown (AppBroadcastSignInResult_Unknown) = 4,
}}
RT_ENUM! { enum AppBroadcastSignInState: i32 {
    NotSignedIn (AppBroadcastSignInState_NotSignedIn) = 0, MicrosoftSignInInProgress (AppBroadcastSignInState_MicrosoftSignInInProgress) = 1, MicrosoftSignInComplete (AppBroadcastSignInState_MicrosoftSignInComplete) = 2, OAuthSignInInProgress (AppBroadcastSignInState_OAuthSignInInProgress) = 3, OAuthSignInComplete (AppBroadcastSignInState_OAuthSignInComplete) = 4,
}}
DEFINE_IID!(IID_IAppBroadcastSignInStateChangedEventArgs, 45519524, 22809, 19102, 141, 94, 201, 187, 13, 211, 55, 122);
RT_INTERFACE!{interface IAppBroadcastSignInStateChangedEventArgs(IAppBroadcastSignInStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastSignInStateChangedEventArgs] {
    fn get_SignInState(&self, out: *mut AppBroadcastSignInState) -> HRESULT,
    fn get_Result(&self, out: *mut AppBroadcastSignInResult) -> HRESULT
}}
impl IAppBroadcastSignInStateChangedEventArgs {
    #[inline] pub unsafe fn get_sign_in_state(&self) -> Result<AppBroadcastSignInState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SignInState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_result(&self) -> Result<AppBroadcastSignInResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastSignInStateChangedEventArgs: IAppBroadcastSignInStateChangedEventArgs}
DEFINE_IID!(IID_IAppBroadcastState, 3993503085, 32921, 19933, 146, 46, 197, 109, 172, 88, 171, 251);
RT_INTERFACE!{interface IAppBroadcastState(IAppBroadcastStateVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastState] {
    fn get_IsCaptureTargetRunning(&self, out: *mut bool) -> HRESULT,
    fn get_ViewerCount(&self, out: *mut u32) -> HRESULT,
    fn get_ShouldCaptureMicrophone(&self, out: *mut bool) -> HRESULT,
    fn put_ShouldCaptureMicrophone(&self, value: bool) -> HRESULT,
    fn RestartMicrophoneCapture(&self) -> HRESULT,
    fn get_ShouldCaptureCamera(&self, out: *mut bool) -> HRESULT,
    fn put_ShouldCaptureCamera(&self, value: bool) -> HRESULT,
    fn RestartCameraCapture(&self) -> HRESULT,
    fn get_EncodedVideoSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_MicrophoneCaptureState(&self, out: *mut AppBroadcastMicrophoneCaptureState) -> HRESULT,
    fn get_MicrophoneCaptureError(&self, out: *mut u32) -> HRESULT,
    fn get_CameraCaptureState(&self, out: *mut AppBroadcastCameraCaptureState) -> HRESULT,
    fn get_CameraCaptureError(&self, out: *mut u32) -> HRESULT,
    fn get_StreamState(&self, out: *mut AppBroadcastStreamState) -> HRESULT,
    fn get_PlugInState(&self, out: *mut AppBroadcastPlugInState) -> HRESULT,
    fn get_OAuthRequestUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn get_OAuthCallbackUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy17(&self) -> (),
    #[cfg(feature="windows-security")] fn get_AuthenticationResult(&self, out: *mut *mut super::super::security::authentication::web::WebAuthenticationResult) -> HRESULT,
    #[cfg(not(feature="windows-security"))] fn __Dummy18(&self) -> (),
    #[cfg(feature="windows-security")] fn put_AuthenticationResult(&self, value: *mut super::super::security::authentication::web::WebAuthenticationResult) -> HRESULT,
    fn put_SignInState(&self, value: AppBroadcastSignInState) -> HRESULT,
    fn get_SignInState(&self, out: *mut AppBroadcastSignInState) -> HRESULT,
    fn get_TerminationReason(&self, out: *mut AppBroadcastTerminationReason) -> HRESULT,
    fn get_TerminationReasonPlugInSpecific(&self, out: *mut u32) -> HRESULT,
    fn add_ViewerCountChanged(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastViewerCountChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ViewerCountChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_MicrophoneCaptureStateChanged(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastMicrophoneCaptureStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MicrophoneCaptureStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CameraCaptureStateChanged(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastCameraCaptureStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CameraCaptureStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PlugInStateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastPlugInStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PlugInStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StreamStateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastStreamStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StreamStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CaptureTargetClosed(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastState, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CaptureTargetClosed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastState {
    #[inline] pub unsafe fn get_is_capture_target_running(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCaptureTargetRunning)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_viewer_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ViewerCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_capture_microphone(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldCaptureMicrophone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_should_capture_microphone(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShouldCaptureMicrophone)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn restart_microphone_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).RestartMicrophoneCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_capture_camera(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldCaptureCamera)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_should_capture_camera(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShouldCaptureCamera)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn restart_camera_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).RestartCameraCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoded_video_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EncodedVideoSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_microphone_capture_state(&self) -> Result<AppBroadcastMicrophoneCaptureState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MicrophoneCaptureState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_microphone_capture_error(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MicrophoneCaptureError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_capture_state(&self) -> Result<AppBroadcastCameraCaptureState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CameraCaptureState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_capture_error(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CameraCaptureError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stream_state(&self) -> Result<AppBroadcastStreamState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StreamState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_plug_in_state(&self) -> Result<AppBroadcastPlugInState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlugInState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_oauth_request_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OAuthRequestUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_oauth_callback_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OAuthCallbackUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_authentication_result(&self) -> Result<ComPtr<super::super::security::authentication::web::WebAuthenticationResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AuthenticationResult)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn set_authentication_result(&self, value: &super::super::security::authentication::web::WebAuthenticationResult) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AuthenticationResult)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sign_in_state(&self, value: AppBroadcastSignInState) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SignInState)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sign_in_state(&self) -> Result<AppBroadcastSignInState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SignInState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_termination_reason(&self) -> Result<AppBroadcastTerminationReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TerminationReason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_termination_reason_plug_in_specific(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TerminationReasonPlugInSpecific)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_viewer_count_changed(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastViewerCountChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ViewerCountChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_viewer_count_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ViewerCountChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_microphone_capture_state_changed(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastMicrophoneCaptureStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MicrophoneCaptureStateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_microphone_capture_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MicrophoneCaptureStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_camera_capture_state_changed(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastCameraCaptureStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CameraCaptureStateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_camera_capture_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CameraCaptureStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_plug_in_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastPlugInStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PlugInStateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_plug_in_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PlugInStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stream_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastState, AppBroadcastStreamStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StreamStateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stream_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StreamStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_capture_target_closed(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastState, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CaptureTargetClosed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_capture_target_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CaptureTargetClosed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastState: IAppBroadcastState}
DEFINE_IID!(IID_IAppBroadcastStreamAudioFrame, 4020980424, 8634, 17727, 139, 183, 94, 147, 138, 46, 154, 116);
RT_INTERFACE!{interface IAppBroadcastStreamAudioFrame(IAppBroadcastStreamAudioFrameVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastStreamAudioFrame] {
    fn get_AudioHeader(&self, out: *mut *mut AppBroadcastStreamAudioHeader) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_AudioBuffer(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl IAppBroadcastStreamAudioFrame {
    #[inline] pub unsafe fn get_audio_header(&self) -> Result<ComPtr<AppBroadcastStreamAudioHeader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioHeader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_audio_buffer(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioBuffer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastStreamAudioFrame: IAppBroadcastStreamAudioFrame}
DEFINE_IID!(IID_IAppBroadcastStreamAudioHeader, 3206653296, 27512, 16918, 159, 7, 90, 255, 82, 86, 241, 183);
RT_INTERFACE!{interface IAppBroadcastStreamAudioHeader(IAppBroadcastStreamAudioHeaderVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastStreamAudioHeader] {
    fn get_AbsoluteTimestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_RelativeTimestamp(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_HasDiscontinuity(&self, out: *mut bool) -> HRESULT,
    fn get_FrameId(&self, out: *mut u64) -> HRESULT
}}
impl IAppBroadcastStreamAudioHeader {
    #[inline] pub unsafe fn get_absolute_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AbsoluteTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_relative_timestamp(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RelativeTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_discontinuity(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasDiscontinuity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_id(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FrameId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastStreamAudioHeader: IAppBroadcastStreamAudioHeader}
DEFINE_IID!(IID_IAppBroadcastStreamReader, 3006840057, 13156, 17504, 181, 241, 60, 194, 121, 106, 138, 162);
RT_INTERFACE!{interface IAppBroadcastStreamReader(IAppBroadcastStreamReaderVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastStreamReader] {
    fn get_AudioChannels(&self, out: *mut u32) -> HRESULT,
    fn get_AudioSampleRate(&self, out: *mut u32) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_AudioAacSequence(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT,
    fn get_AudioBitrate(&self, out: *mut u32) -> HRESULT,
    fn TryGetNextAudioFrame(&self, out: *mut *mut AppBroadcastStreamAudioFrame) -> HRESULT,
    fn get_VideoWidth(&self, out: *mut u32) -> HRESULT,
    fn get_VideoHeight(&self, out: *mut u32) -> HRESULT,
    fn get_VideoBitrate(&self, out: *mut u32) -> HRESULT,
    fn TryGetNextVideoFrame(&self, out: *mut *mut AppBroadcastStreamVideoFrame) -> HRESULT,
    fn add_AudioFrameArrived(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastStreamReader, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AudioFrameArrived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_VideoFrameArrived(&self, value: *mut super::super::foundation::TypedEventHandler<AppBroadcastStreamReader, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VideoFrameArrived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastStreamReader {
    #[inline] pub unsafe fn get_audio_channels(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioChannels)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_sample_rate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioSampleRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_audio_aac_sequence(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioAacSequence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_next_audio_frame(&self) -> Result<ComPtr<AppBroadcastStreamAudioFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetNextAudioFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_next_video_frame(&self) -> Result<ComPtr<AppBroadcastStreamVideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetNextVideoFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_audio_frame_arrived(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastStreamReader, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AudioFrameArrived)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_audio_frame_arrived(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AudioFrameArrived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_video_frame_arrived(&self, value: &super::super::foundation::TypedEventHandler<AppBroadcastStreamReader, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VideoFrameArrived)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_video_frame_arrived(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VideoFrameArrived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastStreamReader: IAppBroadcastStreamReader}
RT_ENUM! { enum AppBroadcastStreamState: i32 {
    Initializing (AppBroadcastStreamState_Initializing) = 0, StreamReady (AppBroadcastStreamState_StreamReady) = 1, Started (AppBroadcastStreamState_Started) = 2, Paused (AppBroadcastStreamState_Paused) = 3, Terminated (AppBroadcastStreamState_Terminated) = 4,
}}
DEFINE_IID!(IID_IAppBroadcastStreamStateChangedEventArgs, 1359521587, 53256, 19081, 147, 190, 88, 174, 217, 97, 55, 78);
RT_INTERFACE!{interface IAppBroadcastStreamStateChangedEventArgs(IAppBroadcastStreamStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastStreamStateChangedEventArgs] {
    fn get_StreamState(&self, out: *mut AppBroadcastStreamState) -> HRESULT
}}
impl IAppBroadcastStreamStateChangedEventArgs {
    #[inline] pub unsafe fn get_stream_state(&self) -> Result<AppBroadcastStreamState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StreamState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastStreamStateChangedEventArgs: IAppBroadcastStreamStateChangedEventArgs}
DEFINE_IID!(IID_IAppBroadcastStreamVideoFrame, 261607211, 51684, 20104, 129, 148, 216, 20, 203, 213, 133, 216);
RT_INTERFACE!{interface IAppBroadcastStreamVideoFrame(IAppBroadcastStreamVideoFrameVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastStreamVideoFrame] {
    fn get_VideoHeader(&self, out: *mut *mut AppBroadcastStreamVideoHeader) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_VideoBuffer(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl IAppBroadcastStreamVideoFrame {
    #[inline] pub unsafe fn get_video_header(&self) -> Result<ComPtr<AppBroadcastStreamVideoHeader>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoHeader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_video_buffer(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoBuffer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastStreamVideoFrame: IAppBroadcastStreamVideoFrame}
DEFINE_IID!(IID_IAppBroadcastStreamVideoHeader, 194952910, 32306, 17197, 140, 162, 54, 191, 16, 185, 244, 98);
RT_INTERFACE!{interface IAppBroadcastStreamVideoHeader(IAppBroadcastStreamVideoHeaderVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastStreamVideoHeader] {
    fn get_AbsoluteTimestamp(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_RelativeTimestamp(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_IsKeyFrame(&self, out: *mut bool) -> HRESULT,
    fn get_HasDiscontinuity(&self, out: *mut bool) -> HRESULT,
    fn get_FrameId(&self, out: *mut u64) -> HRESULT
}}
impl IAppBroadcastStreamVideoHeader {
    #[inline] pub unsafe fn get_absolute_timestamp(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AbsoluteTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_relative_timestamp(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RelativeTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_key_frame(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsKeyFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_discontinuity(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasDiscontinuity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_id(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FrameId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastStreamVideoHeader: IAppBroadcastStreamVideoHeader}
RT_ENUM! { enum AppBroadcastTerminationReason: i32 {
    NormalTermination (AppBroadcastTerminationReason_NormalTermination) = 0, LostConnectionToService (AppBroadcastTerminationReason_LostConnectionToService) = 1, NoNetworkConnectivity (AppBroadcastTerminationReason_NoNetworkConnectivity) = 2, ServiceAbort (AppBroadcastTerminationReason_ServiceAbort) = 3, ServiceError (AppBroadcastTerminationReason_ServiceError) = 4, ServiceUnavailable (AppBroadcastTerminationReason_ServiceUnavailable) = 5, InternalError (AppBroadcastTerminationReason_InternalError) = 6, UnsupportedFormat (AppBroadcastTerminationReason_UnsupportedFormat) = 7, BackgroundTaskTerminated (AppBroadcastTerminationReason_BackgroundTaskTerminated) = 8, BackgroundTaskUnresponsive (AppBroadcastTerminationReason_BackgroundTaskUnresponsive) = 9,
}}
DEFINE_IID!(IID_IAppBroadcastTriggerDetails, 3739986741, 60510, 19855, 177, 192, 93, 166, 232, 199, 86, 56);
RT_INTERFACE!{interface IAppBroadcastTriggerDetails(IAppBroadcastTriggerDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastTriggerDetails] {
    fn get_BackgroundService(&self, out: *mut *mut AppBroadcastBackgroundService) -> HRESULT
}}
impl IAppBroadcastTriggerDetails {
    #[inline] pub unsafe fn get_background_service(&self) -> Result<ComPtr<AppBroadcastBackgroundService>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackgroundService)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastTriggerDetails: IAppBroadcastTriggerDetails}
RT_ENUM! { enum AppBroadcastVideoEncodingBitrateMode: i32 {
    Custom (AppBroadcastVideoEncodingBitrateMode_Custom) = 0, Auto (AppBroadcastVideoEncodingBitrateMode_Auto) = 1,
}}
RT_ENUM! { enum AppBroadcastVideoEncodingResolutionMode: i32 {
    Custom (AppBroadcastVideoEncodingResolutionMode_Custom) = 0, Auto (AppBroadcastVideoEncodingResolutionMode_Auto) = 1,
}}
DEFINE_IID!(IID_IAppBroadcastViewerCountChangedEventArgs, 3873511461, 21505, 19166, 139, 210, 193, 78, 206, 230, 128, 125);
RT_INTERFACE!{interface IAppBroadcastViewerCountChangedEventArgs(IAppBroadcastViewerCountChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastViewerCountChangedEventArgs] {
    fn get_ViewerCount(&self, out: *mut u32) -> HRESULT
}}
impl IAppBroadcastViewerCountChangedEventArgs {
    #[inline] pub unsafe fn get_viewer_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ViewerCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastViewerCountChangedEventArgs: IAppBroadcastViewerCountChangedEventArgs}
DEFINE_IID!(IID_IAppCapture, 2538198099, 41626, 17901, 143, 41, 34, 208, 153, 66, 207, 247);
RT_INTERFACE!{interface IAppCapture(IAppCaptureVtbl): IInspectable(IInspectableVtbl) [IID_IAppCapture] {
    fn get_IsCapturingAudio(&self, out: *mut bool) -> HRESULT,
    fn get_IsCapturingVideo(&self, out: *mut bool) -> HRESULT,
    fn add_CapturingChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppCapture, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CapturingChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppCapture {
    #[inline] pub unsafe fn get_is_capturing_audio(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCapturingAudio)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_capturing_video(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCapturingVideo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_capturing_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppCapture, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CapturingChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_capturing_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CapturingChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppCapture: IAppCapture}
impl RtActivatable<IAppCaptureStatics> for AppCapture {}
impl RtActivatable<IAppCaptureStatics2> for AppCapture {}
impl AppCapture {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<AppCapture>> { unsafe {
        <Self as RtActivatable<IAppCaptureStatics>>::get_activation_factory().get_for_current_view()
    }}
    #[inline] pub fn set_allowed_async(allowed: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IAppCaptureStatics2>>::get_activation_factory().set_allowed_async(allowed)
    }}
}
DEFINE_CLSID!(AppCapture(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,65,112,112,67,97,112,116,117,114,101,0]) [CLSID_AppCapture]);
DEFINE_IID!(IID_IAppCaptureAlternateShortcutKeys, 434692335, 9068, 16633, 179, 143, 155, 125, 214, 93, 28, 204);
RT_INTERFACE!{interface IAppCaptureAlternateShortcutKeys(IAppCaptureAlternateShortcutKeysVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureAlternateShortcutKeys] {
    #[cfg(feature="windows-system")] fn put_ToggleGameBarKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleGameBarKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleGameBarKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleGameBarKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_SaveHistoricalVideoKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_SaveHistoricalVideoKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_SaveHistoricalVideoKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_SaveHistoricalVideoKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleRecordingKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleRecordingKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleRecordingKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleRecordingKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_TakeScreenshotKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_TakeScreenshotKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_TakeScreenshotKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_TakeScreenshotKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleRecordingIndicatorKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleRecordingIndicatorKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleRecordingIndicatorKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleRecordingIndicatorKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT
}}
impl IAppCaptureAlternateShortcutKeys {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_game_bar_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleGameBarKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_game_bar_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleGameBarKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_game_bar_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleGameBarKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_game_bar_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleGameBarKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_save_historical_video_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SaveHistoricalVideoKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_save_historical_video_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SaveHistoricalVideoKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_save_historical_video_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SaveHistoricalVideoKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_save_historical_video_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SaveHistoricalVideoKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_recording_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleRecordingKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_recording_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleRecordingKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_recording_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleRecordingKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_recording_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleRecordingKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_take_screenshot_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TakeScreenshotKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_take_screenshot_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TakeScreenshotKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_take_screenshot_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TakeScreenshotKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_take_screenshot_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TakeScreenshotKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_recording_indicator_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleRecordingIndicatorKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_recording_indicator_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleRecordingIndicatorKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_recording_indicator_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleRecordingIndicatorKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_recording_indicator_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleRecordingIndicatorKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureAlternateShortcutKeys: IAppCaptureAlternateShortcutKeys}
DEFINE_IID!(IID_IAppCaptureAlternateShortcutKeys2, 3278278800, 56599, 18416, 149, 229, 206, 66, 40, 108, 243, 56);
RT_INTERFACE!{interface IAppCaptureAlternateShortcutKeys2(IAppCaptureAlternateShortcutKeys2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureAlternateShortcutKeys2] {
    #[cfg(feature="windows-system")] fn put_ToggleMicrophoneCaptureKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleMicrophoneCaptureKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleMicrophoneCaptureKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleMicrophoneCaptureKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT
}}
impl IAppCaptureAlternateShortcutKeys2 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_microphone_capture_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleMicrophoneCaptureKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_microphone_capture_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleMicrophoneCaptureKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_microphone_capture_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleMicrophoneCaptureKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_microphone_capture_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleMicrophoneCaptureKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureAlternateShortcutKeys3, 2072069260, 16782, 18076, 164, 154, 69, 181, 151, 200, 38, 182);
RT_INTERFACE!{interface IAppCaptureAlternateShortcutKeys3(IAppCaptureAlternateShortcutKeys3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureAlternateShortcutKeys3] {
    #[cfg(feature="windows-system")] fn put_ToggleCameraCaptureKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleCameraCaptureKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleCameraCaptureKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleCameraCaptureKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleBroadcastKey(&self, value: super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleBroadcastKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    #[cfg(feature="windows-system")] fn put_ToggleBroadcastKeyModifiers(&self, value: super::super::system::VirtualKeyModifiers) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_ToggleBroadcastKeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT
}}
impl IAppCaptureAlternateShortcutKeys3 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_camera_capture_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleCameraCaptureKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_camera_capture_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleCameraCaptureKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_camera_capture_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleCameraCaptureKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_camera_capture_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleCameraCaptureKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_broadcast_key(&self, value: super::super::system::VirtualKey) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleBroadcastKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_broadcast_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleBroadcastKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn set_toggle_broadcast_key_modifiers(&self, value: super::super::system::VirtualKeyModifiers) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ToggleBroadcastKeyModifiers)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_toggle_broadcast_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ToggleBroadcastKeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureDurationGeneratedEventArgs, 3254081083, 65441, 17609, 151, 95, 39, 251, 235, 85, 59, 53);
RT_INTERFACE!{interface IAppCaptureDurationGeneratedEventArgs(IAppCaptureDurationGeneratedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureDurationGeneratedEventArgs] {
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IAppCaptureDurationGeneratedEventArgs {
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureDurationGeneratedEventArgs: IAppCaptureDurationGeneratedEventArgs}
DEFINE_IID!(IID_IAppCaptureFileGeneratedEventArgs, 1099561972, 18014, 17855, 144, 127, 22, 91, 63, 178, 55, 88);
RT_INTERFACE!{interface IAppCaptureFileGeneratedEventArgs(IAppCaptureFileGeneratedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureFileGeneratedEventArgs] {
    #[cfg(feature="windows-storage")] fn get_File(&self, out: *mut *mut super::super::storage::StorageFile) -> HRESULT
}}
impl IAppCaptureFileGeneratedEventArgs {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file(&self) -> Result<ComPtr<super::super::storage::StorageFile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_File)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureFileGeneratedEventArgs: IAppCaptureFileGeneratedEventArgs}
RT_ENUM! { enum AppCaptureHistoricalBufferLengthUnit: i32 {
    Megabytes (AppCaptureHistoricalBufferLengthUnit_Megabytes) = 0, Seconds (AppCaptureHistoricalBufferLengthUnit_Seconds) = 1,
}}
RT_CLASS!{static class AppCaptureManager}
impl RtActivatable<IAppCaptureManagerStatics> for AppCaptureManager {}
impl AppCaptureManager {
    #[inline] pub fn get_current_settings() -> Result<ComPtr<AppCaptureSettings>> { unsafe {
        <Self as RtActivatable<IAppCaptureManagerStatics>>::get_activation_factory().get_current_settings()
    }}
    #[inline] pub fn apply_settings(appCaptureSettings: &AppCaptureSettings) -> Result<()> { unsafe {
        <Self as RtActivatable<IAppCaptureManagerStatics>>::get_activation_factory().apply_settings(appCaptureSettings)
    }}
}
DEFINE_CLSID!(AppCaptureManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,65,112,112,67,97,112,116,117,114,101,77,97,110,97,103,101,114,0]) [CLSID_AppCaptureManager]);
DEFINE_IID!(IID_IAppCaptureManagerStatics, 2107522727, 25218, 18229, 141, 78, 170, 69, 249, 15, 103, 35);
RT_INTERFACE!{static interface IAppCaptureManagerStatics(IAppCaptureManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureManagerStatics] {
    fn GetCurrentSettings(&self, out: *mut *mut AppCaptureSettings) -> HRESULT,
    fn ApplySettings(&self, appCaptureSettings: *mut AppCaptureSettings) -> HRESULT
}}
impl IAppCaptureManagerStatics {
    #[inline] pub unsafe fn get_current_settings(&self) -> Result<ComPtr<AppCaptureSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn apply_settings(&self, appCaptureSettings: &AppCaptureSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).ApplySettings)(self as *const _ as *mut _, appCaptureSettings as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum AppCaptureMetadataPriority: i32 {
    Informational (AppCaptureMetadataPriority_Informational) = 0, Important (AppCaptureMetadataPriority_Important) = 1,
}}
DEFINE_IID!(IID_IAppCaptureMetadataWriter, 3771615351, 39599, 18100, 173, 49, 106, 96, 180, 65, 199, 128);
RT_INTERFACE!{interface IAppCaptureMetadataWriter(IAppCaptureMetadataWriterVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureMetadataWriter] {
    fn AddStringEvent(&self, name: HSTRING, value: HSTRING, priority: AppCaptureMetadataPriority) -> HRESULT,
    fn AddInt32Event(&self, name: HSTRING, value: i32, priority: AppCaptureMetadataPriority) -> HRESULT,
    fn AddDoubleEvent(&self, name: HSTRING, value: f64, priority: AppCaptureMetadataPriority) -> HRESULT,
    fn StartStringState(&self, name: HSTRING, value: HSTRING, priority: AppCaptureMetadataPriority) -> HRESULT,
    fn StartInt32State(&self, name: HSTRING, value: i32, priority: AppCaptureMetadataPriority) -> HRESULT,
    fn StartDoubleState(&self, name: HSTRING, value: f64, priority: AppCaptureMetadataPriority) -> HRESULT,
    fn StopState(&self, name: HSTRING) -> HRESULT,
    fn StopAllStates(&self) -> HRESULT,
    fn get_RemainingStorageBytesAvailable(&self, out: *mut u64) -> HRESULT,
    fn add_MetadataPurged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppCaptureMetadataWriter, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MetadataPurged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppCaptureMetadataWriter {
    #[inline] pub unsafe fn add_string_event(&self, name: &HStringArg, value: &HStringArg, priority: AppCaptureMetadataPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).AddStringEvent)(self as *const _ as *mut _, name.get(), value.get(), priority);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_int32_event(&self, name: &HStringArg, value: i32, priority: AppCaptureMetadataPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).AddInt32Event)(self as *const _ as *mut _, name.get(), value, priority);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_double_event(&self, name: &HStringArg, value: f64, priority: AppCaptureMetadataPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).AddDoubleEvent)(self as *const _ as *mut _, name.get(), value, priority);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_string_state(&self, name: &HStringArg, value: &HStringArg, priority: AppCaptureMetadataPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).StartStringState)(self as *const _ as *mut _, name.get(), value.get(), priority);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_int32_state(&self, name: &HStringArg, value: i32, priority: AppCaptureMetadataPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).StartInt32State)(self as *const _ as *mut _, name.get(), value, priority);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_double_state(&self, name: &HStringArg, value: f64, priority: AppCaptureMetadataPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).StartDoubleState)(self as *const _ as *mut _, name.get(), value, priority);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_state(&self, name: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).StopState)(self as *const _ as *mut _, name.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_all_states(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopAllStates)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_remaining_storage_bytes_available(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RemainingStorageBytesAvailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_metadata_purged(&self, handler: &super::super::foundation::TypedEventHandler<AppCaptureMetadataWriter, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MetadataPurged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_metadata_purged(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MetadataPurged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureMetadataWriter: IAppCaptureMetadataWriter}
impl RtActivatable<IActivationFactory> for AppCaptureMetadataWriter {}
DEFINE_CLSID!(AppCaptureMetadataWriter(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,65,112,112,67,97,112,116,117,114,101,77,101,116,97,100,97,116,97,87,114,105,116,101,114,0]) [CLSID_AppCaptureMetadataWriter]);
RT_ENUM! { enum AppCaptureMicrophoneCaptureState: i32 {
    Stopped (AppCaptureMicrophoneCaptureState_Stopped) = 0, Started (AppCaptureMicrophoneCaptureState_Started) = 1, Failed (AppCaptureMicrophoneCaptureState_Failed) = 2,
}}
DEFINE_IID!(IID_IAppCaptureMicrophoneCaptureStateChangedEventArgs, 843916446, 17852, 19509, 188, 53, 228, 105, 252, 122, 105, 224);
RT_INTERFACE!{interface IAppCaptureMicrophoneCaptureStateChangedEventArgs(IAppCaptureMicrophoneCaptureStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureMicrophoneCaptureStateChangedEventArgs] {
    fn get_State(&self, out: *mut AppCaptureMicrophoneCaptureState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut u32) -> HRESULT
}}
impl IAppCaptureMicrophoneCaptureStateChangedEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<AppCaptureMicrophoneCaptureState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureMicrophoneCaptureStateChangedEventArgs: IAppCaptureMicrophoneCaptureStateChangedEventArgs}
RT_ENUM! { enum AppCaptureRecordingState: i32 {
    InProgress (AppCaptureRecordingState_InProgress) = 0, Completed (AppCaptureRecordingState_Completed) = 1, Failed (AppCaptureRecordingState_Failed) = 2,
}}
DEFINE_IID!(IID_IAppCaptureRecordingStateChangedEventArgs, 620529426, 58117, 18701, 180, 21, 107, 28, 144, 73, 115, 107);
RT_INTERFACE!{interface IAppCaptureRecordingStateChangedEventArgs(IAppCaptureRecordingStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureRecordingStateChangedEventArgs] {
    fn get_State(&self, out: *mut AppCaptureRecordingState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut u32) -> HRESULT
}}
impl IAppCaptureRecordingStateChangedEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<AppCaptureRecordingState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureRecordingStateChangedEventArgs: IAppCaptureRecordingStateChangedEventArgs}
DEFINE_IID!(IID_IAppCaptureRecordOperation, 3328188585, 5432, 18780, 155, 187, 43, 168, 112, 236, 88, 97);
RT_INTERFACE!{interface IAppCaptureRecordOperation(IAppCaptureRecordOperationVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureRecordOperation] {
    fn StopRecording(&self) -> HRESULT,
    fn get_State(&self, out: *mut AppCaptureRecordingState) -> HRESULT,
    fn get_ErrorCode(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Duration(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_File(&self, out: *mut *mut super::super::storage::StorageFile) -> HRESULT,
    fn get_IsFileTruncated(&self, out: *mut *mut super::super::foundation::IReference<bool>) -> HRESULT,
    fn add_StateChanged(&self, value: *mut super::super::foundation::TypedEventHandler<AppCaptureRecordOperation, AppCaptureRecordingStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DurationGenerated(&self, value: *mut super::super::foundation::TypedEventHandler<AppCaptureRecordOperation, AppCaptureDurationGeneratedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DurationGenerated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_FileGenerated(&self, value: *mut super::super::foundation::TypedEventHandler<AppCaptureRecordOperation, AppCaptureFileGeneratedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FileGenerated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppCaptureRecordOperation {
    #[inline] pub unsafe fn stop_recording(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopRecording)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<AppCaptureRecordingState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_error_code(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file(&self) -> Result<ComPtr<super::super::storage::StorageFile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_File)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_file_truncated(&self) -> Result<ComPtr<super::super::foundation::IReference<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsFileTruncated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_state_changed(&self, value: &super::super::foundation::TypedEventHandler<AppCaptureRecordOperation, AppCaptureRecordingStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_duration_generated(&self, value: &super::super::foundation::TypedEventHandler<AppCaptureRecordOperation, AppCaptureDurationGeneratedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DurationGenerated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_duration_generated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DurationGenerated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_file_generated(&self, value: &super::super::foundation::TypedEventHandler<AppCaptureRecordOperation, AppCaptureFileGeneratedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FileGenerated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_file_generated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FileGenerated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureRecordOperation: IAppCaptureRecordOperation}
DEFINE_IID!(IID_IAppCaptureServices, 1157546165, 13557, 20248, 174, 140, 185, 18, 58, 187, 252, 13);
RT_INTERFACE!{interface IAppCaptureServices(IAppCaptureServicesVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureServices] {
    fn Record(&self, out: *mut *mut AppCaptureRecordOperation) -> HRESULT,
    fn RecordTimeSpan(&self, startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan, out: *mut *mut AppCaptureRecordOperation) -> HRESULT,
    fn get_CanCapture(&self, out: *mut bool) -> HRESULT,
    fn get_State(&self, out: *mut *mut AppCaptureState) -> HRESULT
}}
impl IAppCaptureServices {
    #[inline] pub unsafe fn record(&self) -> Result<ComPtr<AppCaptureRecordOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Record)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn record_time_span(&self, startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan) -> Result<ComPtr<AppCaptureRecordOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RecordTimeSpan)(self as *const _ as *mut _, startTime, duration, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_capture(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanCapture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<ComPtr<AppCaptureState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureServices: IAppCaptureServices}
DEFINE_IID!(IID_IAppCaptureSettings, 342375046, 34823, 18643, 136, 58, 151, 14, 228, 83, 42, 57);
RT_INTERFACE!{interface IAppCaptureSettings(IAppCaptureSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureSettings] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_AppCaptureDestinationFolder(&self, value: *mut super::super::storage::StorageFolder) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_AppCaptureDestinationFolder(&self, out: *mut *mut super::super::storage::StorageFolder) -> HRESULT,
    fn put_AudioEncodingBitrate(&self, value: u32) -> HRESULT,
    fn get_AudioEncodingBitrate(&self, out: *mut u32) -> HRESULT,
    fn put_IsAudioCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsAudioCaptureEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_CustomVideoEncodingBitrate(&self, value: u32) -> HRESULT,
    fn get_CustomVideoEncodingBitrate(&self, out: *mut u32) -> HRESULT,
    fn put_CustomVideoEncodingHeight(&self, value: u32) -> HRESULT,
    fn get_CustomVideoEncodingHeight(&self, out: *mut u32) -> HRESULT,
    fn put_CustomVideoEncodingWidth(&self, value: u32) -> HRESULT,
    fn get_CustomVideoEncodingWidth(&self, out: *mut u32) -> HRESULT,
    fn put_HistoricalBufferLength(&self, value: u32) -> HRESULT,
    fn get_HistoricalBufferLength(&self, out: *mut u32) -> HRESULT,
    fn put_HistoricalBufferLengthUnit(&self, value: AppCaptureHistoricalBufferLengthUnit) -> HRESULT,
    fn get_HistoricalBufferLengthUnit(&self, out: *mut AppCaptureHistoricalBufferLengthUnit) -> HRESULT,
    fn put_IsHistoricalCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsHistoricalCaptureEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsHistoricalCaptureOnBatteryAllowed(&self, value: bool) -> HRESULT,
    fn get_IsHistoricalCaptureOnBatteryAllowed(&self, out: *mut bool) -> HRESULT,
    fn put_IsHistoricalCaptureOnWirelessDisplayAllowed(&self, value: bool) -> HRESULT,
    fn get_IsHistoricalCaptureOnWirelessDisplayAllowed(&self, out: *mut bool) -> HRESULT,
    fn put_MaximumRecordLength(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_MaximumRecordLength(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy24(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_ScreenshotDestinationFolder(&self, value: *mut super::super::storage::StorageFolder) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy25(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_ScreenshotDestinationFolder(&self, out: *mut *mut super::super::storage::StorageFolder) -> HRESULT,
    fn put_VideoEncodingBitrateMode(&self, value: AppCaptureVideoEncodingBitrateMode) -> HRESULT,
    fn get_VideoEncodingBitrateMode(&self, out: *mut AppCaptureVideoEncodingBitrateMode) -> HRESULT,
    fn put_VideoEncodingResolutionMode(&self, value: AppCaptureVideoEncodingResolutionMode) -> HRESULT,
    fn get_VideoEncodingResolutionMode(&self, out: *mut AppCaptureVideoEncodingResolutionMode) -> HRESULT,
    fn put_IsAppCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsAppCaptureEnabled(&self, out: *mut bool) -> HRESULT,
    fn get_IsCpuConstrained(&self, out: *mut bool) -> HRESULT,
    fn get_IsDisabledByPolicy(&self, out: *mut bool) -> HRESULT,
    fn get_IsMemoryConstrained(&self, out: *mut bool) -> HRESULT,
    fn get_HasHardwareEncoder(&self, out: *mut bool) -> HRESULT
}}
impl IAppCaptureSettings {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_app_capture_destination_folder(&self, value: &super::super::storage::StorageFolder) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppCaptureDestinationFolder)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_app_capture_destination_folder(&self) -> Result<ComPtr<super::super::storage::StorageFolder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppCaptureDestinationFolder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_audio_encoding_bitrate(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioEncodingBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_encoding_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioEncodingBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_audio_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAudioCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_audio_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAudioCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_video_encoding_bitrate(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomVideoEncodingBitrate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_video_encoding_bitrate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomVideoEncodingBitrate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_video_encoding_height(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomVideoEncodingHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_video_encoding_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomVideoEncodingHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_video_encoding_width(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomVideoEncodingWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_video_encoding_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomVideoEncodingWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_historical_buffer_length(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HistoricalBufferLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_historical_buffer_length(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HistoricalBufferLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_historical_buffer_length_unit(&self, value: AppCaptureHistoricalBufferLengthUnit) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HistoricalBufferLengthUnit)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_historical_buffer_length_unit(&self) -> Result<AppCaptureHistoricalBufferLengthUnit> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HistoricalBufferLengthUnit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_historical_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHistoricalCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_historical_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHistoricalCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_historical_capture_on_battery_allowed(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHistoricalCaptureOnBatteryAllowed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_historical_capture_on_battery_allowed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHistoricalCaptureOnBatteryAllowed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_historical_capture_on_wireless_display_allowed(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHistoricalCaptureOnWirelessDisplayAllowed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_historical_capture_on_wireless_display_allowed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHistoricalCaptureOnWirelessDisplayAllowed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_maximum_record_length(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaximumRecordLength)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_maximum_record_length(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaximumRecordLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_screenshot_destination_folder(&self, value: &super::super::storage::StorageFolder) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ScreenshotDestinationFolder)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_screenshot_destination_folder(&self) -> Result<ComPtr<super::super::storage::StorageFolder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ScreenshotDestinationFolder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_encoding_bitrate_mode(&self, value: AppCaptureVideoEncodingBitrateMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoEncodingBitrateMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_encoding_bitrate_mode(&self) -> Result<AppCaptureVideoEncodingBitrateMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoEncodingBitrateMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_encoding_resolution_mode(&self, value: AppCaptureVideoEncodingResolutionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoEncodingResolutionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_encoding_resolution_mode(&self) -> Result<AppCaptureVideoEncodingResolutionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoEncodingResolutionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_app_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAppCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_app_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAppCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_cpu_constrained(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCpuConstrained)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled_by_policy(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabledByPolicy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_memory_constrained(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMemoryConstrained)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_hardware_encoder(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasHardwareEncoder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureSettings: IAppCaptureSettings}
DEFINE_IID!(IID_IAppCaptureSettings2, 4239970023, 57963, 18287, 155, 26, 236, 52, 45, 42, 143, 222);
RT_INTERFACE!{interface IAppCaptureSettings2(IAppCaptureSettings2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureSettings2] {
    fn get_IsGpuConstrained(&self, out: *mut bool) -> HRESULT,
    fn get_AlternateShortcutKeys(&self, out: *mut *mut AppCaptureAlternateShortcutKeys) -> HRESULT
}}
impl IAppCaptureSettings2 {
    #[inline] pub unsafe fn get_is_gpu_constrained(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGpuConstrained)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_alternate_shortcut_keys(&self) -> Result<ComPtr<AppCaptureAlternateShortcutKeys>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AlternateShortcutKeys)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureSettings3, 2838823678, 35010, 17110, 170, 170, 64, 254, 255, 215, 90, 236);
RT_INTERFACE!{interface IAppCaptureSettings3(IAppCaptureSettings3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureSettings3] {
    fn put_IsMicrophoneCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsMicrophoneCaptureEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IAppCaptureSettings3 {
    #[inline] pub unsafe fn set_is_microphone_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsMicrophoneCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_microphone_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMicrophoneCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureSettings4, 130185036, 6785, 18479, 162, 68, 4, 157, 149, 242, 91, 11);
RT_INTERFACE!{interface IAppCaptureSettings4(IAppCaptureSettings4Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureSettings4] {
    fn put_IsMicrophoneCaptureEnabledByDefault(&self, value: bool) -> HRESULT,
    fn get_IsMicrophoneCaptureEnabledByDefault(&self, out: *mut bool) -> HRESULT,
    fn put_SystemAudioGain(&self, value: f64) -> HRESULT,
    fn get_SystemAudioGain(&self, out: *mut f64) -> HRESULT,
    fn put_MicrophoneGain(&self, value: f64) -> HRESULT,
    fn get_MicrophoneGain(&self, out: *mut f64) -> HRESULT,
    fn put_VideoEncodingFrameRateMode(&self, value: AppCaptureVideoEncodingFrameRateMode) -> HRESULT,
    fn get_VideoEncodingFrameRateMode(&self, out: *mut AppCaptureVideoEncodingFrameRateMode) -> HRESULT
}}
impl IAppCaptureSettings4 {
    #[inline] pub unsafe fn set_is_microphone_capture_enabled_by_default(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsMicrophoneCaptureEnabledByDefault)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_microphone_capture_enabled_by_default(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMicrophoneCaptureEnabledByDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_audio_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemAudioGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_audio_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemAudioGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_microphone_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MicrophoneGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_microphone_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MicrophoneGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_encoding_frame_rate_mode(&self, value: AppCaptureVideoEncodingFrameRateMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoEncodingFrameRateMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_encoding_frame_rate_mode(&self) -> Result<AppCaptureVideoEncodingFrameRateMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoEncodingFrameRateMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureSettings5, 411649314, 45288, 19360, 143, 19, 62, 170, 95, 164, 1, 59);
RT_INTERFACE!{interface IAppCaptureSettings5(IAppCaptureSettings5Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureSettings5] {
    fn put_IsEchoCancellationEnabled(&self, value: bool) -> HRESULT,
    fn get_IsEchoCancellationEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsCursorImageCaptureEnabled(&self, value: bool) -> HRESULT,
    fn get_IsCursorImageCaptureEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IAppCaptureSettings5 {
    #[inline] pub unsafe fn set_is_echo_cancellation_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEchoCancellationEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_echo_cancellation_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEchoCancellationEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_cursor_image_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCursorImageCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_cursor_image_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCursorImageCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureState, 1930642290, 54507, 17614, 149, 56, 70, 95, 80, 106, 196, 234);
RT_INTERFACE!{interface IAppCaptureState(IAppCaptureStateVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureState] {
    fn get_IsTargetRunning(&self, out: *mut bool) -> HRESULT,
    fn get_IsHistoricalCaptureEnabled(&self, out: *mut bool) -> HRESULT,
    fn get_ShouldCaptureMicrophone(&self, out: *mut bool) -> HRESULT,
    fn put_ShouldCaptureMicrophone(&self, value: bool) -> HRESULT,
    fn RestartMicrophoneCapture(&self) -> HRESULT,
    fn get_MicrophoneCaptureState(&self, out: *mut AppCaptureMicrophoneCaptureState) -> HRESULT,
    fn get_MicrophoneCaptureError(&self, out: *mut u32) -> HRESULT,
    fn add_MicrophoneCaptureStateChanged(&self, value: *mut super::super::foundation::TypedEventHandler<AppCaptureState, AppCaptureMicrophoneCaptureStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_MicrophoneCaptureStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CaptureTargetClosed(&self, value: *mut super::super::foundation::TypedEventHandler<AppCaptureState, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CaptureTargetClosed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppCaptureState {
    #[inline] pub unsafe fn get_is_target_running(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTargetRunning)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_historical_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHistoricalCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_capture_microphone(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldCaptureMicrophone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_should_capture_microphone(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShouldCaptureMicrophone)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn restart_microphone_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).RestartMicrophoneCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_microphone_capture_state(&self) -> Result<AppCaptureMicrophoneCaptureState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MicrophoneCaptureState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_microphone_capture_error(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MicrophoneCaptureError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_microphone_capture_state_changed(&self, value: &super::super::foundation::TypedEventHandler<AppCaptureState, AppCaptureMicrophoneCaptureStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_MicrophoneCaptureStateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_microphone_capture_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_MicrophoneCaptureStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_capture_target_closed(&self, value: &super::super::foundation::TypedEventHandler<AppCaptureState, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CaptureTargetClosed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_capture_target_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CaptureTargetClosed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppCaptureState: IAppCaptureState}
DEFINE_IID!(IID_IAppCaptureStatics, 4179811692, 2686, 20084, 139, 32, 156, 31, 144, 45, 8, 161);
RT_INTERFACE!{static interface IAppCaptureStatics(IAppCaptureStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureStatics] {
    fn GetForCurrentView(&self, out: *mut *mut AppCapture) -> HRESULT
}}
impl IAppCaptureStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<AppCapture>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppCaptureStatics2, 3000533460, 33644, 19876, 175, 215, 250, 204, 4, 30, 28, 243);
RT_INTERFACE!{static interface IAppCaptureStatics2(IAppCaptureStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppCaptureStatics2] {
    fn SetAllowedAsync(&self, allowed: bool, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAppCaptureStatics2 {
    #[inline] pub unsafe fn set_allowed_async(&self, allowed: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetAllowedAsync)(self as *const _ as *mut _, allowed, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppCaptureVideoEncodingBitrateMode: i32 {
    Custom (AppCaptureVideoEncodingBitrateMode_Custom) = 0, High (AppCaptureVideoEncodingBitrateMode_High) = 1, Standard (AppCaptureVideoEncodingBitrateMode_Standard) = 2,
}}
RT_ENUM! { enum AppCaptureVideoEncodingFrameRateMode: i32 {
    Standard (AppCaptureVideoEncodingFrameRateMode_Standard) = 0, High (AppCaptureVideoEncodingFrameRateMode_High) = 1,
}}
RT_ENUM! { enum AppCaptureVideoEncodingResolutionMode: i32 {
    Custom (AppCaptureVideoEncodingResolutionMode_Custom) = 0, High (AppCaptureVideoEncodingResolutionMode_High) = 1, Standard (AppCaptureVideoEncodingResolutionMode_Standard) = 2,
}}
DEFINE_IID!(IID_ICameraCaptureUI, 1213756736, 28563, 19380, 184, 243, 232, 158, 72, 148, 140, 145);
RT_INTERFACE!{interface ICameraCaptureUI(ICameraCaptureUIVtbl): IInspectable(IInspectableVtbl) [IID_ICameraCaptureUI] {
    fn get_PhotoSettings(&self, out: *mut *mut CameraCaptureUIPhotoCaptureSettings) -> HRESULT,
    fn get_VideoSettings(&self, out: *mut *mut CameraCaptureUIVideoCaptureSettings) -> HRESULT,
    #[cfg(feature="windows-storage")] fn CaptureFileAsync(&self, mode: CameraCaptureUIMode, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::storage::StorageFile>) -> HRESULT
}}
impl ICameraCaptureUI {
    #[inline] pub unsafe fn get_photo_settings(&self) -> Result<ComPtr<CameraCaptureUIPhotoCaptureSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhotoSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_settings(&self) -> Result<ComPtr<CameraCaptureUIVideoCaptureSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn capture_file_async(&self, mode: CameraCaptureUIMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::storage::StorageFile>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CaptureFileAsync)(self as *const _ as *mut _, mode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CameraCaptureUI: ICameraCaptureUI}
impl RtActivatable<IActivationFactory> for CameraCaptureUI {}
DEFINE_CLSID!(CameraCaptureUI(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,67,97,109,101,114,97,67,97,112,116,117,114,101,85,73,0]) [CLSID_CameraCaptureUI]);
RT_ENUM! { enum CameraCaptureUIMaxPhotoResolution: i32 {
    HighestAvailable (CameraCaptureUIMaxPhotoResolution_HighestAvailable) = 0, VerySmallQvga (CameraCaptureUIMaxPhotoResolution_VerySmallQvga) = 1, SmallVga (CameraCaptureUIMaxPhotoResolution_SmallVga) = 2, MediumXga (CameraCaptureUIMaxPhotoResolution_MediumXga) = 3, Large3M (CameraCaptureUIMaxPhotoResolution_Large3M) = 4, VeryLarge5M (CameraCaptureUIMaxPhotoResolution_VeryLarge5M) = 5,
}}
RT_ENUM! { enum CameraCaptureUIMaxVideoResolution: i32 {
    HighestAvailable (CameraCaptureUIMaxVideoResolution_HighestAvailable) = 0, LowDefinition (CameraCaptureUIMaxVideoResolution_LowDefinition) = 1, StandardDefinition (CameraCaptureUIMaxVideoResolution_StandardDefinition) = 2, HighDefinition (CameraCaptureUIMaxVideoResolution_HighDefinition) = 3,
}}
RT_ENUM! { enum CameraCaptureUIMode: i32 {
    PhotoOrVideo (CameraCaptureUIMode_PhotoOrVideo) = 0, Photo (CameraCaptureUIMode_Photo) = 1, Video (CameraCaptureUIMode_Video) = 2,
}}
DEFINE_IID!(IID_ICameraCaptureUIPhotoCaptureSettings, 3119890071, 13426, 18088, 138, 158, 4, 206, 66, 204, 201, 125);
RT_INTERFACE!{interface ICameraCaptureUIPhotoCaptureSettings(ICameraCaptureUIPhotoCaptureSettingsVtbl): IInspectable(IInspectableVtbl) [IID_ICameraCaptureUIPhotoCaptureSettings] {
    fn get_Format(&self, out: *mut CameraCaptureUIPhotoFormat) -> HRESULT,
    fn put_Format(&self, value: CameraCaptureUIPhotoFormat) -> HRESULT,
    fn get_MaxResolution(&self, out: *mut CameraCaptureUIMaxPhotoResolution) -> HRESULT,
    fn put_MaxResolution(&self, value: CameraCaptureUIMaxPhotoResolution) -> HRESULT,
    fn get_CroppedSizeInPixels(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn put_CroppedSizeInPixels(&self, value: super::super::foundation::Size) -> HRESULT,
    fn get_CroppedAspectRatio(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn put_CroppedAspectRatio(&self, value: super::super::foundation::Size) -> HRESULT,
    fn get_AllowCropping(&self, out: *mut bool) -> HRESULT,
    fn put_AllowCropping(&self, value: bool) -> HRESULT
}}
impl ICameraCaptureUIPhotoCaptureSettings {
    #[inline] pub unsafe fn get_format(&self) -> Result<CameraCaptureUIPhotoFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Format)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_format(&self, value: CameraCaptureUIPhotoFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Format)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_resolution(&self) -> Result<CameraCaptureUIMaxPhotoResolution> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxResolution)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_resolution(&self, value: CameraCaptureUIMaxPhotoResolution) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxResolution)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cropped_size_in_pixels(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CroppedSizeInPixels)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cropped_size_in_pixels(&self, value: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CroppedSizeInPixels)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cropped_aspect_ratio(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CroppedAspectRatio)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cropped_aspect_ratio(&self, value: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CroppedAspectRatio)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_cropping(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowCropping)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_cropping(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowCropping)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CameraCaptureUIPhotoCaptureSettings: ICameraCaptureUIPhotoCaptureSettings}
RT_ENUM! { enum CameraCaptureUIPhotoFormat: i32 {
    Jpeg (CameraCaptureUIPhotoFormat_Jpeg) = 0, Png (CameraCaptureUIPhotoFormat_Png) = 1, JpegXR (CameraCaptureUIPhotoFormat_JpegXR) = 2,
}}
DEFINE_IID!(IID_ICameraCaptureUIVideoCaptureSettings, 1693003039, 41613, 16986, 184, 79, 229, 104, 51, 95, 242, 78);
RT_INTERFACE!{interface ICameraCaptureUIVideoCaptureSettings(ICameraCaptureUIVideoCaptureSettingsVtbl): IInspectable(IInspectableVtbl) [IID_ICameraCaptureUIVideoCaptureSettings] {
    fn get_Format(&self, out: *mut CameraCaptureUIVideoFormat) -> HRESULT,
    fn put_Format(&self, value: CameraCaptureUIVideoFormat) -> HRESULT,
    fn get_MaxResolution(&self, out: *mut CameraCaptureUIMaxVideoResolution) -> HRESULT,
    fn put_MaxResolution(&self, value: CameraCaptureUIMaxVideoResolution) -> HRESULT,
    fn get_MaxDurationInSeconds(&self, out: *mut f32) -> HRESULT,
    fn put_MaxDurationInSeconds(&self, value: f32) -> HRESULT,
    fn get_AllowTrimming(&self, out: *mut bool) -> HRESULT,
    fn put_AllowTrimming(&self, value: bool) -> HRESULT
}}
impl ICameraCaptureUIVideoCaptureSettings {
    #[inline] pub unsafe fn get_format(&self) -> Result<CameraCaptureUIVideoFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Format)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_format(&self, value: CameraCaptureUIVideoFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Format)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_resolution(&self) -> Result<CameraCaptureUIMaxVideoResolution> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxResolution)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_resolution(&self, value: CameraCaptureUIMaxVideoResolution) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxResolution)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_duration_in_seconds(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxDurationInSeconds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_duration_in_seconds(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxDurationInSeconds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_trimming(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowTrimming)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_trimming(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowTrimming)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CameraCaptureUIVideoCaptureSettings: ICameraCaptureUIVideoCaptureSettings}
RT_ENUM! { enum CameraCaptureUIVideoFormat: i32 {
    Mp4 (CameraCaptureUIVideoFormat_Mp4) = 0, Wmv (CameraCaptureUIVideoFormat_Wmv) = 1,
}}
RT_CLASS!{static class CameraOptionsUI}
impl RtActivatable<ICameraOptionsUIStatics> for CameraOptionsUI {}
impl CameraOptionsUI {
    #[inline] pub fn show(mediaCapture: &MediaCapture) -> Result<()> { unsafe {
        <Self as RtActivatable<ICameraOptionsUIStatics>>::get_activation_factory().show(mediaCapture)
    }}
}
DEFINE_CLSID!(CameraOptionsUI(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,67,97,109,101,114,97,79,112,116,105,111,110,115,85,73,0]) [CLSID_CameraOptionsUI]);
DEFINE_IID!(IID_ICameraOptionsUIStatics, 990731828, 14598, 19325, 148, 108, 123, 222, 132, 68, 153, 174);
RT_INTERFACE!{static interface ICameraOptionsUIStatics(ICameraOptionsUIStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICameraOptionsUIStatics] {
    fn Show(&self, mediaCapture: *mut MediaCapture) -> HRESULT
}}
impl ICameraOptionsUIStatics {
    #[inline] pub unsafe fn show(&self, mediaCapture: &MediaCapture) -> Result<()> {
        let hr = ((*self.lpVtbl).Show)(self as *const _ as *mut _, mediaCapture as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICapturedFrame, 500358687, 22299, 17624, 142, 128, 160, 138, 21, 120, 118, 110);
RT_INTERFACE!{interface ICapturedFrame(ICapturedFrameVtbl): IInspectable(IInspectableVtbl) [IID_ICapturedFrame] {
    fn get_Width(&self, out: *mut u32) -> HRESULT,
    fn get_Height(&self, out: *mut u32) -> HRESULT
}}
impl ICapturedFrame {
    #[inline] pub unsafe fn get_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Width)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Height)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CapturedFrame: ICapturedFrame}
DEFINE_IID!(IID_ICapturedFrameControlValues, 2428918655, 19981, 19620, 136, 45, 122, 20, 79, 237, 10, 144);
RT_INTERFACE!{interface ICapturedFrameControlValues(ICapturedFrameControlValuesVtbl): IInspectable(IInspectableVtbl) [IID_ICapturedFrameControlValues] {
    fn get_Exposure(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_ExposureCompensation(&self, out: *mut *mut super::super::foundation::IReference<f32>) -> HRESULT,
    fn get_IsoSpeed(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Focus(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_SceneMode(&self, out: *mut *mut super::super::foundation::IReference<super::devices::CaptureSceneMode>) -> HRESULT,
    fn get_Flashed(&self, out: *mut *mut super::super::foundation::IReference<bool>) -> HRESULT,
    fn get_FlashPowerPercent(&self, out: *mut *mut super::super::foundation::IReference<f32>) -> HRESULT,
    fn get_WhiteBalance(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_ZoomFactor(&self, out: *mut *mut super::super::foundation::IReference<f32>) -> HRESULT
}}
impl ICapturedFrameControlValues {
    #[inline] pub unsafe fn get_exposure(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Exposure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exposure_compensation(&self) -> Result<ComPtr<super::super::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposureCompensation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_iso_speed(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsoSpeed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Focus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scene_mode(&self) -> Result<ComPtr<super::super::foundation::IReference<super::devices::CaptureSceneMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SceneMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flashed(&self) -> Result<ComPtr<super::super::foundation::IReference<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Flashed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flash_power_percent(&self) -> Result<ComPtr<super::super::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlashPowerPercent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_white_balance(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WhiteBalance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zoom_factor(&self) -> Result<ComPtr<super::super::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ZoomFactor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CapturedFrameControlValues: ICapturedFrameControlValues}
DEFINE_IID!(IID_ICapturedFrameControlValues2, 1342909320, 1746, 19111, 167, 219, 211, 122, 247, 51, 33, 216);
RT_INTERFACE!{interface ICapturedFrameControlValues2(ICapturedFrameControlValues2Vtbl): IInspectable(IInspectableVtbl) [IID_ICapturedFrameControlValues2] {
    fn get_FocusState(&self, out: *mut *mut super::super::foundation::IReference<super::devices::MediaCaptureFocusState>) -> HRESULT,
    fn get_IsoDigitalGain(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_IsoAnalogGain(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_SensorFrameRate(&self, out: *mut *mut super::mediaproperties::MediaRatio) -> HRESULT,
    fn get_WhiteBalanceGain(&self, out: *mut *mut super::super::foundation::IReference<WhiteBalanceGain>) -> HRESULT
}}
impl ICapturedFrameControlValues2 {
    #[inline] pub unsafe fn get_focus_state(&self) -> Result<ComPtr<super::super::foundation::IReference<super::devices::MediaCaptureFocusState>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_iso_digital_gain(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsoDigitalGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_iso_analog_gain(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsoAnalogGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sensor_frame_rate(&self) -> Result<ComPtr<super::mediaproperties::MediaRatio>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SensorFrameRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_white_balance_gain(&self) -> Result<ComPtr<super::super::foundation::IReference<WhiteBalanceGain>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WhiteBalanceGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICapturedFrameWithSoftwareBitmap, 3046017902, 34051, 18869, 158, 134, 137, 125, 38, 163, 255, 61);
RT_INTERFACE!{interface ICapturedFrameWithSoftwareBitmap(ICapturedFrameWithSoftwareBitmapVtbl): IInspectable(IInspectableVtbl) [IID_ICapturedFrameWithSoftwareBitmap] {
    #[cfg(feature="windows-graphics")] fn get_SoftwareBitmap(&self, out: *mut *mut super::super::graphics::imaging::SoftwareBitmap) -> HRESULT
}}
impl ICapturedFrameWithSoftwareBitmap {
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_software_bitmap(&self) -> Result<ComPtr<super::super::graphics::imaging::SoftwareBitmap>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SoftwareBitmap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICapturedPhoto, 2966322778, 53196, 19820, 138, 209, 8, 105, 32, 138, 202, 22);
RT_INTERFACE!{interface ICapturedPhoto(ICapturedPhotoVtbl): IInspectable(IInspectableVtbl) [IID_ICapturedPhoto] {
    fn get_Frame(&self, out: *mut *mut CapturedFrame) -> HRESULT,
    fn get_Thumbnail(&self, out: *mut *mut CapturedFrame) -> HRESULT
}}
impl ICapturedPhoto {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CapturedPhoto: ICapturedPhoto}
RT_ENUM! { enum ForegroundActivationArgument: i32 {
    SignInRequired (ForegroundActivationArgument_SignInRequired) = 0, MoreSettings (ForegroundActivationArgument_MoreSettings) = 1,
}}
RT_ENUM! { enum GameBarCommand: i32 {
    OpenGameBar (GameBarCommand_OpenGameBar) = 0, RecordHistoricalBuffer (GameBarCommand_RecordHistoricalBuffer) = 1, ToggleStartStopRecord (GameBarCommand_ToggleStartStopRecord) = 2, StartRecord (GameBarCommand_StartRecord) = 3, StopRecord (GameBarCommand_StopRecord) = 4, TakeScreenshot (GameBarCommand_TakeScreenshot) = 5, StartBroadcast (GameBarCommand_StartBroadcast) = 6, StopBroadcast (GameBarCommand_StopBroadcast) = 7, PauseBroadcast (GameBarCommand_PauseBroadcast) = 8, ResumeBroadcast (GameBarCommand_ResumeBroadcast) = 9, ToggleStartStopBroadcast (GameBarCommand_ToggleStartStopBroadcast) = 10, ToggleMicrophoneCapture (GameBarCommand_ToggleMicrophoneCapture) = 11, ToggleCameraCapture (GameBarCommand_ToggleCameraCapture) = 12, ToggleRecordingIndicator (GameBarCommand_ToggleRecordingIndicator) = 13,
}}
RT_ENUM! { enum GameBarCommandOrigin: i32 {
    ShortcutKey (GameBarCommandOrigin_ShortcutKey) = 0, Cortana (GameBarCommandOrigin_Cortana) = 1, AppCommand (GameBarCommandOrigin_AppCommand) = 2,
}}
DEFINE_IID!(IID_IGameBarServices, 767470935, 20646, 18846, 140, 108, 211, 48, 167, 49, 23, 150);
RT_INTERFACE!{interface IGameBarServices(IGameBarServicesVtbl): IInspectable(IInspectableVtbl) [IID_IGameBarServices] {
    fn get_TargetCapturePolicy(&self, out: *mut GameBarTargetCapturePolicy) -> HRESULT,
    fn EnableCapture(&self) -> HRESULT,
    fn DisableCapture(&self) -> HRESULT,
    fn get_TargetInfo(&self, out: *mut *mut GameBarServicesTargetInfo) -> HRESULT,
    fn get_SessionId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppBroadcastServices(&self, out: *mut *mut AppBroadcastServices) -> HRESULT,
    fn get_AppCaptureServices(&self, out: *mut *mut AppCaptureServices) -> HRESULT,
    fn add_CommandReceived(&self, value: *mut super::super::foundation::TypedEventHandler<GameBarServices, GameBarServicesCommandEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CommandReceived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGameBarServices {
    #[inline] pub unsafe fn get_target_capture_policy(&self) -> Result<GameBarTargetCapturePolicy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TargetCapturePolicy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn enable_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).EnableCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn disable_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DisableCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_info(&self) -> Result<ComPtr<GameBarServicesTargetInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_session_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SessionId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_broadcast_services(&self) -> Result<ComPtr<AppBroadcastServices>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppBroadcastServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_capture_services(&self) -> Result<ComPtr<AppCaptureServices>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppCaptureServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_command_received(&self, value: &super::super::foundation::TypedEventHandler<GameBarServices, GameBarServicesCommandEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CommandReceived)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_command_received(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CommandReceived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GameBarServices: IGameBarServices}
DEFINE_IID!(IID_IGameBarServicesCommandEventArgs, 2806130354, 61814, 20431, 143, 187, 207, 105, 139, 46, 184, 224);
RT_INTERFACE!{interface IGameBarServicesCommandEventArgs(IGameBarServicesCommandEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGameBarServicesCommandEventArgs] {
    fn get_Command(&self, out: *mut GameBarCommand) -> HRESULT,
    fn get_Origin(&self, out: *mut GameBarCommandOrigin) -> HRESULT
}}
impl IGameBarServicesCommandEventArgs {
    #[inline] pub unsafe fn get_command(&self) -> Result<GameBarCommand> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Command)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_origin(&self) -> Result<GameBarCommandOrigin> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Origin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GameBarServicesCommandEventArgs: IGameBarServicesCommandEventArgs}
RT_ENUM! { enum GameBarServicesDisplayMode: i32 {
    Windowed (GameBarServicesDisplayMode_Windowed) = 0, FullScreenExclusive (GameBarServicesDisplayMode_FullScreenExclusive) = 1,
}}
DEFINE_IID!(IID_IGameBarServicesManager, 978033914, 32651, 19552, 157, 187, 11, 205, 38, 45, 255, 198);
RT_INTERFACE!{interface IGameBarServicesManager(IGameBarServicesManagerVtbl): IInspectable(IInspectableVtbl) [IID_IGameBarServicesManager] {
    fn add_GameBarServicesCreated(&self, value: *mut super::super::foundation::TypedEventHandler<GameBarServicesManager, GameBarServicesManagerGameBarServicesCreatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_GameBarServicesCreated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGameBarServicesManager {
    #[inline] pub unsafe fn add_game_bar_services_created(&self, value: &super::super::foundation::TypedEventHandler<GameBarServicesManager, GameBarServicesManagerGameBarServicesCreatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_GameBarServicesCreated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_game_bar_services_created(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_GameBarServicesCreated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GameBarServicesManager: IGameBarServicesManager}
impl RtActivatable<IGameBarServicesManagerStatics> for GameBarServicesManager {}
impl GameBarServicesManager {
    #[inline] pub fn get_default() -> Result<ComPtr<GameBarServicesManager>> { unsafe {
        <Self as RtActivatable<IGameBarServicesManagerStatics>>::get_activation_factory().get_default()
    }}
}
DEFINE_CLSID!(GameBarServicesManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,71,97,109,101,66,97,114,83,101,114,118,105,99,101,115,77,97,110,97,103,101,114,0]) [CLSID_GameBarServicesManager]);
DEFINE_IID!(IID_IGameBarServicesManagerGameBarServicesCreatedEventArgs, 3991780764, 5182, 18851, 165, 234, 11, 25, 149, 200, 212, 110);
RT_INTERFACE!{interface IGameBarServicesManagerGameBarServicesCreatedEventArgs(IGameBarServicesManagerGameBarServicesCreatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IGameBarServicesManagerGameBarServicesCreatedEventArgs] {
    fn get_GameBarServices(&self, out: *mut *mut GameBarServices) -> HRESULT
}}
impl IGameBarServicesManagerGameBarServicesCreatedEventArgs {
    #[inline] pub unsafe fn get_game_bar_services(&self) -> Result<ComPtr<GameBarServices>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GameBarServices)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GameBarServicesManagerGameBarServicesCreatedEventArgs: IGameBarServicesManagerGameBarServicesCreatedEventArgs}
DEFINE_IID!(IID_IGameBarServicesManagerStatics, 885110294, 65317, 18322, 152, 242, 211, 117, 63, 21, 172, 19);
RT_INTERFACE!{static interface IGameBarServicesManagerStatics(IGameBarServicesManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGameBarServicesManagerStatics] {
    fn GetDefault(&self, out: *mut *mut GameBarServicesManager) -> HRESULT
}}
impl IGameBarServicesManagerStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<GameBarServicesManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGameBarServicesTargetInfo, 3022008210, 5649, 19973, 182, 239, 223, 215, 55, 174, 51, 176);
RT_INTERFACE!{interface IGameBarServicesTargetInfo(IGameBarServicesTargetInfoVtbl): IInspectable(IInspectableVtbl) [IID_IGameBarServicesTargetInfo] {
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AppId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TitleId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayMode(&self, out: *mut GameBarServicesDisplayMode) -> HRESULT
}}
impl IGameBarServicesTargetInfo {
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_mode(&self) -> Result<GameBarServicesDisplayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisplayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class GameBarServicesTargetInfo: IGameBarServicesTargetInfo}
RT_ENUM! { enum GameBarTargetCapturePolicy: i32 {
    EnabledBySystem (GameBarTargetCapturePolicy_EnabledBySystem) = 0, EnabledByUser (GameBarTargetCapturePolicy_EnabledByUser) = 1, NotEnabled (GameBarTargetCapturePolicy_NotEnabled) = 2, ProhibitedBySystem (GameBarTargetCapturePolicy_ProhibitedBySystem) = 3, ProhibitedByPublisher (GameBarTargetCapturePolicy_ProhibitedByPublisher) = 4,
}}
RT_ENUM! { enum KnownVideoProfile: i32 {
    VideoRecording (KnownVideoProfile_VideoRecording) = 0, HighQualityPhoto (KnownVideoProfile_HighQualityPhoto) = 1, BalancedVideoAndPhoto (KnownVideoProfile_BalancedVideoAndPhoto) = 2, VideoConferencing (KnownVideoProfile_VideoConferencing) = 3, PhotoSequence (KnownVideoProfile_PhotoSequence) = 4,
}}
DEFINE_IID!(IID_ILowLagMediaRecording, 1103674103, 65343, 18928, 164, 119, 241, 149, 227, 206, 81, 8);
RT_INTERFACE!{interface ILowLagMediaRecording(ILowLagMediaRecordingVtbl): IInspectable(IInspectableVtbl) [IID_ILowLagMediaRecording] {
    fn StartAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StopAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn FinishAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ILowLagMediaRecording {
    #[inline] pub unsafe fn start_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn finish_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FinishAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LowLagMediaRecording: ILowLagMediaRecording}
DEFINE_IID!(IID_ILowLagMediaRecording2, 1667876696, 22084, 16866, 151, 175, 142, 245, 106, 37, 226, 37);
RT_INTERFACE!{interface ILowLagMediaRecording2(ILowLagMediaRecording2Vtbl): IInspectable(IInspectableVtbl) [IID_ILowLagMediaRecording2] {
    fn PauseAsync(&self, behavior: super::devices::MediaCapturePauseBehavior, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ResumeAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ILowLagMediaRecording2 {
    #[inline] pub unsafe fn pause_async(&self, behavior: super::devices::MediaCapturePauseBehavior) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PauseAsync)(self as *const _ as *mut _, behavior, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn resume_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ResumeAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ILowLagMediaRecording3, 1546890002, 18679, 18394, 180, 30, 144, 136, 10, 95, 224, 236);
RT_INTERFACE!{interface ILowLagMediaRecording3(ILowLagMediaRecording3Vtbl): IInspectable(IInspectableVtbl) [IID_ILowLagMediaRecording3] {
    fn PauseWithResultAsync(&self, behavior: super::devices::MediaCapturePauseBehavior, out: *mut *mut super::super::foundation::IAsyncOperation<MediaCapturePauseResult>) -> HRESULT,
    fn StopWithResultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<MediaCaptureStopResult>) -> HRESULT
}}
impl ILowLagMediaRecording3 {
    #[inline] pub unsafe fn pause_with_result_async(&self, behavior: super::devices::MediaCapturePauseBehavior) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaCapturePauseResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PauseWithResultAsync)(self as *const _ as *mut _, behavior, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_with_result_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaCaptureStopResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopWithResultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ILowLagPhotoCapture, 2742178231, 27460, 18237, 143, 36, 247, 3, 214, 192, 236, 68);
RT_INTERFACE!{interface ILowLagPhotoCapture(ILowLagPhotoCaptureVtbl): IInspectable(IInspectableVtbl) [IID_ILowLagPhotoCapture] {
    fn CaptureAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<CapturedPhoto>) -> HRESULT,
    fn FinishAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ILowLagPhotoCapture {
    #[inline] pub unsafe fn capture_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CapturedPhoto>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CaptureAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn finish_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FinishAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LowLagPhotoCapture: ILowLagPhotoCapture}
DEFINE_IID!(IID_ILowLagPhotoSequenceCapture, 2093172411, 47529, 19601, 143, 250, 40, 126, 156, 102, 134, 105);
RT_INTERFACE!{interface ILowLagPhotoSequenceCapture(ILowLagPhotoSequenceCaptureVtbl): IInspectable(IInspectableVtbl) [IID_ILowLagPhotoSequenceCapture] {
    fn StartAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StopAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn FinishAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn add_PhotoCaptured(&self, handler: *mut super::super::foundation::TypedEventHandler<LowLagPhotoSequenceCapture, PhotoCapturedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PhotoCaptured(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ILowLagPhotoSequenceCapture {
    #[inline] pub unsafe fn start_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn finish_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FinishAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_photo_captured(&self, handler: &super::super::foundation::TypedEventHandler<LowLagPhotoSequenceCapture, PhotoCapturedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PhotoCaptured)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_photo_captured(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PhotoCaptured)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class LowLagPhotoSequenceCapture: ILowLagPhotoSequenceCapture}
DEFINE_IID!(IID_IMediaCapture, 3323657140, 64272, 18996, 172, 24, 202, 128, 217, 200, 231, 238);
RT_INTERFACE!{interface IMediaCapture(IMediaCaptureVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapture] {
    fn InitializeAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn InitializeWithSettingsAsync(&self, mediaCaptureInitializationSettings: *mut MediaCaptureInitializationSettings, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn StartRecordToStorageFileAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, file: *mut super::super::storage::IStorageFile, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-storage")] fn StartRecordToStreamAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, stream: *mut super::super::storage::streams::IRandomAccessStream, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StartRecordToCustomSinkAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, customMediaSink: *mut super::IMediaExtension, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StartRecordToCustomSinkIdAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, customSinkActivationId: HSTRING, customSinkSettings: *mut super::super::foundation::collections::IPropertySet, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StopRecordAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-storage")] fn CapturePhotoToStorageFileAsync(&self, type_: *mut super::mediaproperties::ImageEncodingProperties, file: *mut super::super::storage::IStorageFile, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-storage")] fn CapturePhotoToStreamAsync(&self, type_: *mut super::mediaproperties::ImageEncodingProperties, stream: *mut super::super::storage::streams::IRandomAccessStream, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn AddEffectAsync(&self, mediaStreamType: MediaStreamType, effectActivationID: HSTRING, effectSettings: *mut super::super::foundation::collections::IPropertySet, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ClearEffectsAsync(&self, mediaStreamType: MediaStreamType, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SetEncoderProperty(&self, mediaStreamType: MediaStreamType, propertyId: Guid, propertyValue: *mut IInspectable) -> HRESULT,
    fn GetEncoderProperty(&self, mediaStreamType: MediaStreamType, propertyId: Guid, out: *mut *mut IInspectable) -> HRESULT,
    fn add_Failed(&self, errorEventHandler: *mut MediaCaptureFailedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Failed(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RecordLimitationExceeded(&self, recordLimitationExceededEventHandler: *mut RecordLimitationExceededEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RecordLimitationExceeded(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_MediaCaptureSettings(&self, out: *mut *mut MediaCaptureSettings) -> HRESULT,
    fn get_AudioDeviceController(&self, out: *mut *mut super::devices::AudioDeviceController) -> HRESULT,
    fn get_VideoDeviceController(&self, out: *mut *mut super::devices::VideoDeviceController) -> HRESULT,
    fn SetPreviewMirroring(&self, value: bool) -> HRESULT,
    fn GetPreviewMirroring(&self, out: *mut bool) -> HRESULT,
    fn SetPreviewRotation(&self, value: VideoRotation) -> HRESULT,
    fn GetPreviewRotation(&self, out: *mut VideoRotation) -> HRESULT,
    fn SetRecordRotation(&self, value: VideoRotation) -> HRESULT,
    fn GetRecordRotation(&self, out: *mut VideoRotation) -> HRESULT
}}
impl IMediaCapture {
    #[inline] pub unsafe fn initialize_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).InitializeAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn initialize_with_settings_async(&self, mediaCaptureInitializationSettings: &MediaCaptureInitializationSettings) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).InitializeWithSettingsAsync)(self as *const _ as *mut _, mediaCaptureInitializationSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn start_record_to_storage_file_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, file: &super::super::storage::IStorageFile) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartRecordToStorageFileAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn start_record_to_stream_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, stream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartRecordToStreamAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, stream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_record_to_custom_sink_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, customMediaSink: &super::IMediaExtension) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartRecordToCustomSinkAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, customMediaSink as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_record_to_custom_sink_id_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, customSinkActivationId: &HStringArg, customSinkSettings: &super::super::foundation::collections::IPropertySet) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartRecordToCustomSinkIdAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, customSinkActivationId.get(), customSinkSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_record_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopRecordAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn capture_photo_to_storage_file_async(&self, type_: &super::mediaproperties::ImageEncodingProperties, file: &super::super::storage::IStorageFile) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CapturePhotoToStorageFileAsync)(self as *const _ as *mut _, type_ as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn capture_photo_to_stream_async(&self, type_: &super::mediaproperties::ImageEncodingProperties, stream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CapturePhotoToStreamAsync)(self as *const _ as *mut _, type_ as *const _ as *mut _, stream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_effect_async(&self, mediaStreamType: MediaStreamType, effectActivationID: &HStringArg, effectSettings: &super::super::foundation::collections::IPropertySet) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AddEffectAsync)(self as *const _ as *mut _, mediaStreamType, effectActivationID.get(), effectSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_effects_async(&self, mediaStreamType: MediaStreamType) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ClearEffectsAsync)(self as *const _ as *mut _, mediaStreamType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_encoder_property(&self, mediaStreamType: MediaStreamType, propertyId: Guid, propertyValue: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).SetEncoderProperty)(self as *const _ as *mut _, mediaStreamType, propertyId, propertyValue as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoder_property(&self, mediaStreamType: MediaStreamType, propertyId: Guid) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEncoderProperty)(self as *const _ as *mut _, mediaStreamType, propertyId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_failed(&self, errorEventHandler: &MediaCaptureFailedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Failed)(self as *const _ as *mut _, errorEventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_failed(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Failed)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_record_limitation_exceeded(&self, recordLimitationExceededEventHandler: &RecordLimitationExceededEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RecordLimitationExceeded)(self as *const _ as *mut _, recordLimitationExceededEventHandler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_record_limitation_exceeded(&self, eventCookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RecordLimitationExceeded)(self as *const _ as *mut _, eventCookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_capture_settings(&self) -> Result<ComPtr<MediaCaptureSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaCaptureSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_device_controller(&self) -> Result<ComPtr<super::devices::AudioDeviceController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioDeviceController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_controller(&self) -> Result<ComPtr<super::devices::VideoDeviceController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preview_mirroring(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPreviewMirroring)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_mirroring(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetPreviewMirroring)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preview_rotation(&self, value: VideoRotation) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPreviewRotation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_rotation(&self) -> Result<VideoRotation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetPreviewRotation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_record_rotation(&self, value: VideoRotation) -> Result<()> {
        let hr = ((*self.lpVtbl).SetRecordRotation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_record_rotation(&self) -> Result<VideoRotation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetRecordRotation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCapture: IMediaCapture}
impl RtActivatable<IMediaCaptureStatics> for MediaCapture {}
impl RtActivatable<IActivationFactory> for MediaCapture {}
impl MediaCapture {
    #[inline] pub fn is_video_profile_supported(videoDeviceId: &HStringArg) -> Result<bool> { unsafe {
        <Self as RtActivatable<IMediaCaptureStatics>>::get_activation_factory().is_video_profile_supported(videoDeviceId)
    }}
    #[inline] pub fn find_all_video_profiles(videoDeviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> { unsafe {
        <Self as RtActivatable<IMediaCaptureStatics>>::get_activation_factory().find_all_video_profiles(videoDeviceId)
    }}
    #[inline] pub fn find_concurrent_profiles(videoDeviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> { unsafe {
        <Self as RtActivatable<IMediaCaptureStatics>>::get_activation_factory().find_concurrent_profiles(videoDeviceId)
    }}
    #[inline] pub fn find_known_video_profiles(videoDeviceId: &HStringArg, name: KnownVideoProfile) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> { unsafe {
        <Self as RtActivatable<IMediaCaptureStatics>>::get_activation_factory().find_known_video_profiles(videoDeviceId, name)
    }}
}
DEFINE_CLSID!(MediaCapture(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,77,101,100,105,97,67,97,112,116,117,114,101,0]) [CLSID_MediaCapture]);
DEFINE_IID!(IID_IMediaCapture2, 2630255200, 32161, 16451, 182, 82, 33, 184, 135, 141, 175, 249);
RT_INTERFACE!{interface IMediaCapture2(IMediaCapture2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapture2] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn PrepareLowLagRecordToStorageFileAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, file: *mut super::super::storage::IStorageFile, out: *mut *mut super::super::foundation::IAsyncOperation<LowLagMediaRecording>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn PrepareLowLagRecordToStreamAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, stream: *mut super::super::storage::streams::IRandomAccessStream, out: *mut *mut super::super::foundation::IAsyncOperation<LowLagMediaRecording>) -> HRESULT,
    fn PrepareLowLagRecordToCustomSinkAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, customMediaSink: *mut super::IMediaExtension, out: *mut *mut super::super::foundation::IAsyncOperation<LowLagMediaRecording>) -> HRESULT,
    fn PrepareLowLagRecordToCustomSinkIdAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, customSinkActivationId: HSTRING, customSinkSettings: *mut super::super::foundation::collections::IPropertySet, out: *mut *mut super::super::foundation::IAsyncOperation<LowLagMediaRecording>) -> HRESULT,
    fn PrepareLowLagPhotoCaptureAsync(&self, type_: *mut super::mediaproperties::ImageEncodingProperties, out: *mut *mut super::super::foundation::IAsyncOperation<LowLagPhotoCapture>) -> HRESULT,
    fn PrepareLowLagPhotoSequenceCaptureAsync(&self, type_: *mut super::mediaproperties::ImageEncodingProperties, out: *mut *mut super::super::foundation::IAsyncOperation<LowLagPhotoSequenceCapture>) -> HRESULT,
    fn SetEncodingPropertiesAsync(&self, mediaStreamType: MediaStreamType, mediaEncodingProperties: *mut super::mediaproperties::IMediaEncodingProperties, encoderProperties: *mut super::mediaproperties::MediaPropertySet, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IMediaCapture2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn prepare_low_lag_record_to_storage_file_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, file: &super::super::storage::IStorageFile) -> Result<ComPtr<super::super::foundation::IAsyncOperation<LowLagMediaRecording>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareLowLagRecordToStorageFileAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn prepare_low_lag_record_to_stream_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, stream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<super::super::foundation::IAsyncOperation<LowLagMediaRecording>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareLowLagRecordToStreamAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, stream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn prepare_low_lag_record_to_custom_sink_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, customMediaSink: &super::IMediaExtension) -> Result<ComPtr<super::super::foundation::IAsyncOperation<LowLagMediaRecording>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareLowLagRecordToCustomSinkAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, customMediaSink as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn prepare_low_lag_record_to_custom_sink_id_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, customSinkActivationId: &HStringArg, customSinkSettings: &super::super::foundation::collections::IPropertySet) -> Result<ComPtr<super::super::foundation::IAsyncOperation<LowLagMediaRecording>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareLowLagRecordToCustomSinkIdAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, customSinkActivationId.get(), customSinkSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn prepare_low_lag_photo_capture_async(&self, type_: &super::mediaproperties::ImageEncodingProperties) -> Result<ComPtr<super::super::foundation::IAsyncOperation<LowLagPhotoCapture>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareLowLagPhotoCaptureAsync)(self as *const _ as *mut _, type_ as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn prepare_low_lag_photo_sequence_capture_async(&self, type_: &super::mediaproperties::ImageEncodingProperties) -> Result<ComPtr<super::super::foundation::IAsyncOperation<LowLagPhotoSequenceCapture>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareLowLagPhotoSequenceCaptureAsync)(self as *const _ as *mut _, type_ as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_encoding_properties_async(&self, mediaStreamType: MediaStreamType, mediaEncodingProperties: &super::mediaproperties::IMediaEncodingProperties, encoderProperties: &super::mediaproperties::MediaPropertySet) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetEncodingPropertiesAsync)(self as *const _ as *mut _, mediaStreamType, mediaEncodingProperties as *const _ as *mut _, encoderProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCapture3, 3558043440, 5476, 18030, 188, 10, 175, 148, 224, 42, 176, 22);
RT_INTERFACE!{interface IMediaCapture3(IMediaCapture3Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapture3] {
    fn PrepareVariablePhotoSequenceCaptureAsync(&self, type_: *mut super::mediaproperties::ImageEncodingProperties, out: *mut *mut super::super::foundation::IAsyncOperation<core::VariablePhotoSequenceCapture>) -> HRESULT,
    fn add_FocusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaCapture, MediaCaptureFocusChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FocusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PhotoConfirmationCaptured(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaCapture, PhotoConfirmationCapturedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PhotoConfirmationCaptured(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IMediaCapture3 {
    #[inline] pub unsafe fn prepare_variable_photo_sequence_capture_async(&self, type_: &super::mediaproperties::ImageEncodingProperties) -> Result<ComPtr<super::super::foundation::IAsyncOperation<core::VariablePhotoSequenceCapture>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareVariablePhotoSequenceCaptureAsync)(self as *const _ as *mut _, type_ as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_focus_changed(&self, handler: &super::super::foundation::TypedEventHandler<MediaCapture, MediaCaptureFocusChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FocusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_focus_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FocusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_photo_confirmation_captured(&self, handler: &super::super::foundation::TypedEventHandler<MediaCapture, PhotoConfirmationCapturedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PhotoConfirmationCaptured)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_photo_confirmation_captured(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PhotoConfirmationCaptured)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCapture4, 3134025686, 64264, 18759, 174, 162, 206, 20, 239, 240, 206, 19);
RT_INTERFACE!{interface IMediaCapture4(IMediaCapture4Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapture4] {
    fn AddAudioEffectAsync(&self, definition: *mut super::effects::IAudioEffectDefinition, out: *mut *mut super::super::foundation::IAsyncOperation<super::IMediaExtension>) -> HRESULT,
    fn AddVideoEffectAsync(&self, definition: *mut super::effects::IVideoEffectDefinition, mediaStreamType: MediaStreamType, out: *mut *mut super::super::foundation::IAsyncOperation<super::IMediaExtension>) -> HRESULT,
    fn PauseRecordAsync(&self, behavior: super::devices::MediaCapturePauseBehavior, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ResumeRecordAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn add_CameraStreamStateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaCapture, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CameraStreamStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_CameraStreamState(&self, out: *mut super::devices::CameraStreamState) -> HRESULT,
    fn GetPreviewFrameAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::VideoFrame>) -> HRESULT,
    fn GetPreviewFrameCopyAsync(&self, destination: *mut super::VideoFrame, out: *mut *mut super::super::foundation::IAsyncOperation<super::VideoFrame>) -> HRESULT,
    fn add_ThermalStatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaCapture, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ThermalStatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_ThermalStatus(&self, out: *mut MediaCaptureThermalStatus) -> HRESULT,
    fn PrepareAdvancedPhotoCaptureAsync(&self, encodingProperties: *mut super::mediaproperties::ImageEncodingProperties, out: *mut *mut super::super::foundation::IAsyncOperation<AdvancedPhotoCapture>) -> HRESULT
}}
impl IMediaCapture4 {
    #[inline] pub unsafe fn add_audio_effect_async(&self, definition: &super::effects::IAudioEffectDefinition) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::IMediaExtension>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AddAudioEffectAsync)(self as *const _ as *mut _, definition as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_video_effect_async(&self, definition: &super::effects::IVideoEffectDefinition, mediaStreamType: MediaStreamType) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::IMediaExtension>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AddVideoEffectAsync)(self as *const _ as *mut _, definition as *const _ as *mut _, mediaStreamType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pause_record_async(&self, behavior: super::devices::MediaCapturePauseBehavior) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PauseRecordAsync)(self as *const _ as *mut _, behavior, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn resume_record_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ResumeRecordAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_camera_stream_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<MediaCapture, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CameraStreamStateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_camera_stream_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CameraStreamStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_stream_state(&self) -> Result<super::devices::CameraStreamState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CameraStreamState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_frame_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::VideoFrame>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetPreviewFrameAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_frame_copy_async(&self, destination: &super::VideoFrame) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::VideoFrame>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetPreviewFrameCopyAsync)(self as *const _ as *mut _, destination as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_thermal_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<MediaCapture, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ThermalStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_thermal_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ThermalStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thermal_status(&self) -> Result<MediaCaptureThermalStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThermalStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn prepare_advanced_photo_capture_async(&self, encodingProperties: &super::mediaproperties::ImageEncodingProperties) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AdvancedPhotoCapture>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareAdvancedPhotoCaptureAsync)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCapture5, 3665329186, 15003, 18208, 167, 30, 151, 144, 10, 49, 110, 90);
RT_INTERFACE!{interface IMediaCapture5(IMediaCapture5Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapture5] {
    fn RemoveEffectAsync(&self, effect: *mut super::IMediaExtension, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn PauseRecordWithResultAsync(&self, behavior: super::devices::MediaCapturePauseBehavior, out: *mut *mut super::super::foundation::IAsyncOperation<MediaCapturePauseResult>) -> HRESULT,
    fn StopRecordWithResultAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<MediaCaptureStopResult>) -> HRESULT,
    fn get_FrameSources(&self, out: *mut *mut super::super::foundation::collections::IMapView<HString, frames::MediaFrameSource>) -> HRESULT,
    fn CreateFrameReaderAsync(&self, inputSource: *mut frames::MediaFrameSource, out: *mut *mut super::super::foundation::IAsyncOperation<frames::MediaFrameReader>) -> HRESULT,
    fn CreateFrameReaderWithSubtypeAsync(&self, inputSource: *mut frames::MediaFrameSource, outputSubtype: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<frames::MediaFrameReader>) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn CreateFrameReaderWithSubtypeAndSizeAsync(&self, inputSource: *mut frames::MediaFrameSource, outputSubtype: HSTRING, outputSize: super::super::graphics::imaging::BitmapSize, out: *mut *mut super::super::foundation::IAsyncOperation<frames::MediaFrameReader>) -> HRESULT
}}
impl IMediaCapture5 {
    #[inline] pub unsafe fn remove_effect_async(&self, effect: &super::IMediaExtension) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RemoveEffectAsync)(self as *const _ as *mut _, effect as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn pause_record_with_result_async(&self, behavior: super::devices::MediaCapturePauseBehavior) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaCapturePauseResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PauseRecordWithResultAsync)(self as *const _ as *mut _, behavior, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_record_with_result_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaCaptureStopResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopRecordWithResultAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_sources(&self) -> Result<ComPtr<super::super::foundation::collections::IMapView<HString, frames::MediaFrameSource>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameSources)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_frame_reader_async(&self, inputSource: &frames::MediaFrameSource) -> Result<ComPtr<super::super::foundation::IAsyncOperation<frames::MediaFrameReader>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameReaderAsync)(self as *const _ as *mut _, inputSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_frame_reader_with_subtype_async(&self, inputSource: &frames::MediaFrameSource, outputSubtype: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<frames::MediaFrameReader>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameReaderWithSubtypeAsync)(self as *const _ as *mut _, inputSource as *const _ as *mut _, outputSubtype.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn create_frame_reader_with_subtype_and_size_async(&self, inputSource: &frames::MediaFrameSource, outputSubtype: &HStringArg, outputSize: super::super::graphics::imaging::BitmapSize) -> Result<ComPtr<super::super::foundation::IAsyncOperation<frames::MediaFrameReader>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameReaderWithSubtypeAndSizeAsync)(self as *const _ as *mut _, inputSource as *const _ as *mut _, outputSubtype.get(), outputSize, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCapture6, 579422397, 19232, 19377, 159, 214, 165, 131, 33, 42, 16, 18);
RT_INTERFACE!{interface IMediaCapture6(IMediaCapture6Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapture6] {
    fn add_CaptureDeviceExclusiveControlStatusChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaCapture, MediaCaptureDeviceExclusiveControlStatusChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CaptureDeviceExclusiveControlStatusChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn CreateMultiSourceFrameReaderAsync(&self, inputSources: *mut super::super::foundation::collections::IIterable<frames::MediaFrameSource>, out: *mut *mut super::super::foundation::IAsyncOperation<frames::MultiSourceMediaFrameReader>) -> HRESULT
}}
impl IMediaCapture6 {
    #[inline] pub unsafe fn add_capture_device_exclusive_control_status_changed(&self, handler: &super::super::foundation::TypedEventHandler<MediaCapture, MediaCaptureDeviceExclusiveControlStatusChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CaptureDeviceExclusiveControlStatusChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_capture_device_exclusive_control_status_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CaptureDeviceExclusiveControlStatusChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_multi_source_frame_reader_async(&self, inputSources: &super::super::foundation::collections::IIterable<frames::MediaFrameSource>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<frames::MultiSourceMediaFrameReader>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateMultiSourceFrameReaderAsync)(self as *const _ as *mut _, inputSources as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaCaptureDeviceExclusiveControlStatus: i32 {
    ExclusiveControlAvailable (MediaCaptureDeviceExclusiveControlStatus_ExclusiveControlAvailable) = 0, SharedReadOnlyAvailable (MediaCaptureDeviceExclusiveControlStatus_SharedReadOnlyAvailable) = 1,
}}
DEFINE_IID!(IID_IMediaCaptureDeviceExclusiveControlStatusChangedEventArgs, 2637140493, 42376, 17350, 137, 214, 90, 211, 34, 175, 0, 106);
RT_INTERFACE!{interface IMediaCaptureDeviceExclusiveControlStatusChangedEventArgs(IMediaCaptureDeviceExclusiveControlStatusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureDeviceExclusiveControlStatusChangedEventArgs] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Status(&self, out: *mut MediaCaptureDeviceExclusiveControlStatus) -> HRESULT
}}
impl IMediaCaptureDeviceExclusiveControlStatusChangedEventArgs {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_status(&self) -> Result<MediaCaptureDeviceExclusiveControlStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureDeviceExclusiveControlStatusChangedEventArgs: IMediaCaptureDeviceExclusiveControlStatusChangedEventArgs}
DEFINE_IID!(IID_IMediaCaptureFailedEventArgs, 2164122612, 21700, 17088, 141, 25, 206, 161, 168, 124, 161, 139);
RT_INTERFACE!{interface IMediaCaptureFailedEventArgs(IMediaCaptureFailedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureFailedEventArgs] {
    fn get_Message(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Code(&self, out: *mut u32) -> HRESULT
}}
impl IMediaCaptureFailedEventArgs {
    #[inline] pub unsafe fn get_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Code)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureFailedEventArgs: IMediaCaptureFailedEventArgs}
DEFINE_IID!(IID_MediaCaptureFailedEventHandler, 538243067, 23768, 20232, 163, 20, 13, 54, 13, 165, 159, 20);
RT_DELEGATE!{delegate MediaCaptureFailedEventHandler(MediaCaptureFailedEventHandlerVtbl, MediaCaptureFailedEventHandlerImpl) [IID_MediaCaptureFailedEventHandler] {
    fn Invoke(&self, sender: *mut MediaCapture, errorEventArgs: *mut MediaCaptureFailedEventArgs) -> HRESULT
}}
impl MediaCaptureFailedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &MediaCapture, errorEventArgs: &MediaCaptureFailedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, errorEventArgs as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureFocusChangedEventArgs, 2179054719, 8823, 18750, 171, 238, 211, 244, 79, 249, 140, 4);
RT_INTERFACE!{interface IMediaCaptureFocusChangedEventArgs(IMediaCaptureFocusChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureFocusChangedEventArgs] {
    fn get_FocusState(&self, out: *mut super::devices::MediaCaptureFocusState) -> HRESULT
}}
impl IMediaCaptureFocusChangedEventArgs {
    #[inline] pub unsafe fn get_focus_state(&self) -> Result<super::devices::MediaCaptureFocusState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureFocusChangedEventArgs: IMediaCaptureFocusChangedEventArgs}
DEFINE_IID!(IID_IMediaCaptureInitializationSettings, 2541927024, 60005, 18688, 147, 86, 140, 168, 135, 114, 104, 132);
RT_INTERFACE!{interface IMediaCaptureInitializationSettings(IMediaCaptureInitializationSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureInitializationSettings] {
    fn put_AudioDeviceId(&self, value: HSTRING) -> HRESULT,
    fn get_AudioDeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_VideoDeviceId(&self, value: HSTRING) -> HRESULT,
    fn get_VideoDeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_StreamingCaptureMode(&self, value: StreamingCaptureMode) -> HRESULT,
    fn get_StreamingCaptureMode(&self, out: *mut StreamingCaptureMode) -> HRESULT,
    fn put_PhotoCaptureSource(&self, value: PhotoCaptureSource) -> HRESULT,
    fn get_PhotoCaptureSource(&self, out: *mut PhotoCaptureSource) -> HRESULT
}}
impl IMediaCaptureInitializationSettings {
    #[inline] pub unsafe fn set_audio_device_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioDeviceId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_device_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoDeviceId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_streaming_capture_mode(&self, value: StreamingCaptureMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StreamingCaptureMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_streaming_capture_mode(&self) -> Result<StreamingCaptureMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StreamingCaptureMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_photo_capture_source(&self, value: PhotoCaptureSource) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PhotoCaptureSource)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photo_capture_source(&self) -> Result<PhotoCaptureSource> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PhotoCaptureSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureInitializationSettings: IMediaCaptureInitializationSettings}
impl RtActivatable<IActivationFactory> for MediaCaptureInitializationSettings {}
DEFINE_CLSID!(MediaCaptureInitializationSettings(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,77,101,100,105,97,67,97,112,116,117,114,101,73,110,105,116,105,97,108,105,122,97,116,105,111,110,83,101,116,116,105,110,103,115,0]) [CLSID_MediaCaptureInitializationSettings]);
DEFINE_IID!(IID_IMediaCaptureInitializationSettings2, 1078855206, 51676, 17385, 174, 228, 230, 191, 27, 87, 180, 76);
RT_INTERFACE!{interface IMediaCaptureInitializationSettings2(IMediaCaptureInitializationSettings2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureInitializationSettings2] {
    fn put_MediaCategory(&self, value: MediaCategory) -> HRESULT,
    fn get_MediaCategory(&self, out: *mut MediaCategory) -> HRESULT,
    fn put_AudioProcessing(&self, value: super::AudioProcessing) -> HRESULT,
    fn get_AudioProcessing(&self, out: *mut super::AudioProcessing) -> HRESULT
}}
impl IMediaCaptureInitializationSettings2 {
    #[inline] pub unsafe fn set_media_category(&self, value: MediaCategory) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MediaCategory)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_category(&self) -> Result<MediaCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediaCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_audio_processing(&self, value: super::AudioProcessing) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioProcessing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_processing(&self) -> Result<super::AudioProcessing> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioProcessing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureInitializationSettings3, 1096831389, 48712, 18224, 129, 4, 12, 246, 233, 233, 121, 72);
RT_INTERFACE!{interface IMediaCaptureInitializationSettings3(IMediaCaptureInitializationSettings3Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureInitializationSettings3] {
    fn put_AudioSource(&self, value: *mut super::core::IMediaSource) -> HRESULT,
    fn get_AudioSource(&self, out: *mut *mut super::core::IMediaSource) -> HRESULT,
    fn put_VideoSource(&self, value: *mut super::core::IMediaSource) -> HRESULT,
    fn get_VideoSource(&self, out: *mut *mut super::core::IMediaSource) -> HRESULT
}}
impl IMediaCaptureInitializationSettings3 {
    #[inline] pub unsafe fn set_audio_source(&self, value: &super::core::IMediaSource) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioSource)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_source(&self) -> Result<ComPtr<super::core::IMediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_source(&self, value: &super::core::IMediaSource) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoSource)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_source(&self) -> Result<ComPtr<super::core::IMediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureInitializationSettings4, 4110591287, 19639, 19752, 149, 237, 79, 159, 1, 46, 5, 24);
RT_INTERFACE!{interface IMediaCaptureInitializationSettings4(IMediaCaptureInitializationSettings4Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureInitializationSettings4] {
    fn get_VideoProfile(&self, out: *mut *mut MediaCaptureVideoProfile) -> HRESULT,
    fn put_VideoProfile(&self, value: *mut MediaCaptureVideoProfile) -> HRESULT,
    fn get_PreviewMediaDescription(&self, out: *mut *mut MediaCaptureVideoProfileMediaDescription) -> HRESULT,
    fn put_PreviewMediaDescription(&self, value: *mut MediaCaptureVideoProfileMediaDescription) -> HRESULT,
    fn get_RecordMediaDescription(&self, out: *mut *mut MediaCaptureVideoProfileMediaDescription) -> HRESULT,
    fn put_RecordMediaDescription(&self, value: *mut MediaCaptureVideoProfileMediaDescription) -> HRESULT,
    fn get_PhotoMediaDescription(&self, out: *mut *mut MediaCaptureVideoProfileMediaDescription) -> HRESULT,
    fn put_PhotoMediaDescription(&self, value: *mut MediaCaptureVideoProfileMediaDescription) -> HRESULT
}}
impl IMediaCaptureInitializationSettings4 {
    #[inline] pub unsafe fn get_video_profile(&self) -> Result<ComPtr<MediaCaptureVideoProfile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoProfile)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_video_profile(&self, value: &MediaCaptureVideoProfile) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VideoProfile)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_media_description(&self) -> Result<ComPtr<MediaCaptureVideoProfileMediaDescription>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreviewMediaDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preview_media_description(&self, value: &MediaCaptureVideoProfileMediaDescription) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PreviewMediaDescription)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_record_media_description(&self) -> Result<ComPtr<MediaCaptureVideoProfileMediaDescription>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecordMediaDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_record_media_description(&self, value: &MediaCaptureVideoProfileMediaDescription) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RecordMediaDescription)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photo_media_description(&self) -> Result<ComPtr<MediaCaptureVideoProfileMediaDescription>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhotoMediaDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_photo_media_description(&self, value: &MediaCaptureVideoProfileMediaDescription) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PhotoMediaDescription)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureInitializationSettings5, 3584222136, 9766, 20116, 183, 179, 83, 8, 160, 246, 75, 26);
RT_INTERFACE!{interface IMediaCaptureInitializationSettings5(IMediaCaptureInitializationSettings5Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureInitializationSettings5] {
    fn get_SourceGroup(&self, out: *mut *mut frames::MediaFrameSourceGroup) -> HRESULT,
    fn put_SourceGroup(&self, value: *mut frames::MediaFrameSourceGroup) -> HRESULT,
    fn get_SharingMode(&self, out: *mut MediaCaptureSharingMode) -> HRESULT,
    fn put_SharingMode(&self, value: MediaCaptureSharingMode) -> HRESULT,
    fn get_MemoryPreference(&self, out: *mut MediaCaptureMemoryPreference) -> HRESULT,
    fn put_MemoryPreference(&self, value: MediaCaptureMemoryPreference) -> HRESULT
}}
impl IMediaCaptureInitializationSettings5 {
    #[inline] pub unsafe fn get_source_group(&self) -> Result<ComPtr<frames::MediaFrameSourceGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceGroup)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source_group(&self, value: &frames::MediaFrameSourceGroup) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SourceGroup)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sharing_mode(&self) -> Result<MediaCaptureSharingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SharingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sharing_mode(&self, value: MediaCaptureSharingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SharingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_memory_preference(&self) -> Result<MediaCaptureMemoryPreference> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MemoryPreference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_memory_preference(&self, value: MediaCaptureMemoryPreference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MemoryPreference)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureInitializationSettings6, 3001183047, 15793, 19763, 171, 99, 15, 250, 9, 5, 101, 133);
RT_INTERFACE!{interface IMediaCaptureInitializationSettings6(IMediaCaptureInitializationSettings6Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureInitializationSettings6] {
    fn get_AlwaysPlaySystemShutterSound(&self, out: *mut bool) -> HRESULT,
    fn put_AlwaysPlaySystemShutterSound(&self, value: bool) -> HRESULT
}}
impl IMediaCaptureInitializationSettings6 {
    #[inline] pub unsafe fn get_always_play_system_shutter_sound(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlwaysPlaySystemShutterSound)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_always_play_system_shutter_sound(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AlwaysPlaySystemShutterSound)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaCaptureMemoryPreference: i32 {
    Auto (MediaCaptureMemoryPreference_Auto) = 0, Cpu (MediaCaptureMemoryPreference_Cpu) = 1,
}}
DEFINE_IID!(IID_IMediaCapturePauseResult, 2932112547, 17527, 19204, 160, 111, 44, 28, 81, 130, 254, 157);
RT_INTERFACE!{interface IMediaCapturePauseResult(IMediaCapturePauseResultVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCapturePauseResult] {
    fn get_LastFrame(&self, out: *mut *mut super::VideoFrame) -> HRESULT,
    fn get_RecordDuration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IMediaCapturePauseResult {
    #[inline] pub unsafe fn get_last_frame(&self) -> Result<ComPtr<super::VideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LastFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_record_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RecordDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCapturePauseResult: IMediaCapturePauseResult}
DEFINE_IID!(IID_IMediaCaptureSettings, 495168254, 27973, 17527, 141, 196, 172, 91, 192, 28, 64, 145);
RT_INTERFACE!{interface IMediaCaptureSettings(IMediaCaptureSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureSettings] {
    fn get_AudioDeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoDeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_StreamingCaptureMode(&self, out: *mut StreamingCaptureMode) -> HRESULT,
    fn get_PhotoCaptureSource(&self, out: *mut PhotoCaptureSource) -> HRESULT,
    fn get_VideoDeviceCharacteristic(&self, out: *mut VideoDeviceCharacteristic) -> HRESULT
}}
impl IMediaCaptureSettings {
    #[inline] pub unsafe fn get_audio_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_streaming_capture_mode(&self) -> Result<StreamingCaptureMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StreamingCaptureMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photo_capture_source(&self) -> Result<PhotoCaptureSource> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PhotoCaptureSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_characteristic(&self) -> Result<VideoDeviceCharacteristic> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VideoDeviceCharacteristic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureSettings: IMediaCaptureSettings}
DEFINE_IID!(IID_IMediaCaptureSettings2, 1872657659, 64159, 19219, 156, 190, 90, 185, 79, 31, 52, 147);
RT_INTERFACE!{interface IMediaCaptureSettings2(IMediaCaptureSettings2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureSettings2] {
    fn get_ConcurrentRecordAndPhotoSupported(&self, out: *mut bool) -> HRESULT,
    fn get_ConcurrentRecordAndPhotoSequenceSupported(&self, out: *mut bool) -> HRESULT,
    fn get_CameraSoundRequiredForRegion(&self, out: *mut bool) -> HRESULT,
    fn get_Horizontal35mmEquivalentFocalLength(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_PitchOffsetDegrees(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_Vertical35mmEquivalentFocalLength(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_MediaCategory(&self, out: *mut MediaCategory) -> HRESULT,
    fn get_AudioProcessing(&self, out: *mut super::AudioProcessing) -> HRESULT
}}
impl IMediaCaptureSettings2 {
    #[inline] pub unsafe fn get_concurrent_record_and_photo_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConcurrentRecordAndPhotoSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_concurrent_record_and_photo_sequence_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConcurrentRecordAndPhotoSequenceSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_sound_required_for_region(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CameraSoundRequiredForRegion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal35mm_equivalent_focal_length(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Horizontal35mmEquivalentFocalLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pitch_offset_degrees(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PitchOffsetDegrees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical35mm_equivalent_focal_length(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Vertical35mmEquivalentFocalLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_category(&self) -> Result<MediaCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediaCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_processing(&self) -> Result<super::AudioProcessing> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioProcessing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaCaptureSharingMode: i32 {
    ExclusiveControl (MediaCaptureSharingMode_ExclusiveControl) = 0, SharedReadOnly (MediaCaptureSharingMode_SharedReadOnly) = 1,
}}
DEFINE_IID!(IID_IMediaCaptureStatics, 2901377535, 39405, 17989, 150, 94, 25, 37, 207, 198, 56, 52);
RT_INTERFACE!{static interface IMediaCaptureStatics(IMediaCaptureStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureStatics] {
    fn IsVideoProfileSupported(&self, videoDeviceId: HSTRING, out: *mut bool) -> HRESULT,
    fn FindAllVideoProfiles(&self, videoDeviceId: HSTRING, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>) -> HRESULT,
    fn FindConcurrentProfiles(&self, videoDeviceId: HSTRING, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>) -> HRESULT,
    fn FindKnownVideoProfiles(&self, videoDeviceId: HSTRING, name: KnownVideoProfile, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>) -> HRESULT
}}
impl IMediaCaptureStatics {
    #[inline] pub unsafe fn is_video_profile_supported(&self, videoDeviceId: &HStringArg) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsVideoProfileSupported)(self as *const _ as *mut _, videoDeviceId.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_video_profiles(&self, videoDeviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllVideoProfiles)(self as *const _ as *mut _, videoDeviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_concurrent_profiles(&self, videoDeviceId: &HStringArg) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindConcurrentProfiles)(self as *const _ as *mut _, videoDeviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_known_video_profiles(&self, videoDeviceId: &HStringArg, name: KnownVideoProfile) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindKnownVideoProfiles)(self as *const _ as *mut _, videoDeviceId.get(), name, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureStopResult, 4191906346, 41106, 19153, 151, 212, 242, 1, 249, 208, 130, 219);
RT_INTERFACE!{interface IMediaCaptureStopResult(IMediaCaptureStopResultVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureStopResult] {
    fn get_LastFrame(&self, out: *mut *mut super::VideoFrame) -> HRESULT,
    fn get_RecordDuration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IMediaCaptureStopResult {
    #[inline] pub unsafe fn get_last_frame(&self) -> Result<ComPtr<super::VideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LastFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_record_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RecordDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureStopResult: IMediaCaptureStopResult}
RT_ENUM! { enum MediaCaptureThermalStatus: i32 {
    Normal (MediaCaptureThermalStatus_Normal) = 0, Overheated (MediaCaptureThermalStatus_Overheated) = 1,
}}
DEFINE_IID!(IID_IMediaCaptureVideoPreview, 661811315, 21662, 17535, 162, 10, 79, 3, 196, 121, 216, 192);
RT_INTERFACE!{interface IMediaCaptureVideoPreview(IMediaCaptureVideoPreviewVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureVideoPreview] {
    fn StartPreviewAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StartPreviewToCustomSinkAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, customMediaSink: *mut super::IMediaExtension, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StartPreviewToCustomSinkIdAsync(&self, encodingProfile: *mut super::mediaproperties::MediaEncodingProfile, customSinkActivationId: HSTRING, customSinkSettings: *mut super::super::foundation::collections::IPropertySet, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StopPreviewAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IMediaCaptureVideoPreview {
    #[inline] pub unsafe fn start_preview_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartPreviewAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_preview_to_custom_sink_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, customMediaSink: &super::IMediaExtension) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartPreviewToCustomSinkAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, customMediaSink as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_preview_to_custom_sink_id_async(&self, encodingProfile: &super::mediaproperties::MediaEncodingProfile, customSinkActivationId: &HStringArg, customSinkSettings: &super::super::foundation::collections::IPropertySet) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartPreviewToCustomSinkIdAsync)(self as *const _ as *mut _, encodingProfile as *const _ as *mut _, customSinkActivationId.get(), customSinkSettings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_preview_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopPreviewAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCaptureVideoProfile, 564163519, 41966, 20175, 158, 246, 80, 176, 188, 78, 19, 5);
RT_INTERFACE!{interface IMediaCaptureVideoProfile(IMediaCaptureVideoProfileVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureVideoProfile] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoDeviceId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SupportedPreviewMediaDescription(&self, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfileMediaDescription>) -> HRESULT,
    fn get_SupportedRecordMediaDescription(&self, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfileMediaDescription>) -> HRESULT,
    fn get_SupportedPhotoMediaDescription(&self, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfileMediaDescription>) -> HRESULT,
    fn GetConcurrency(&self, out: *mut *mut super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>) -> HRESULT
}}
impl IMediaCaptureVideoProfile {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_preview_media_description(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfileMediaDescription>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedPreviewMediaDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_record_media_description(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfileMediaDescription>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedRecordMediaDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_photo_media_description(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfileMediaDescription>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedPhotoMediaDescription)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_concurrency(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MediaCaptureVideoProfile>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetConcurrency)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureVideoProfile: IMediaCaptureVideoProfile}
DEFINE_IID!(IID_IMediaCaptureVideoProfileMediaDescription, 2148708335, 46737, 18943, 131, 242, 193, 231, 110, 170, 234, 27);
RT_INTERFACE!{interface IMediaCaptureVideoProfileMediaDescription(IMediaCaptureVideoProfileMediaDescriptionVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCaptureVideoProfileMediaDescription] {
    fn get_Width(&self, out: *mut u32) -> HRESULT,
    fn get_Height(&self, out: *mut u32) -> HRESULT,
    fn get_FrameRate(&self, out: *mut f64) -> HRESULT,
    fn get_IsVariablePhotoSequenceSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsHdrVideoSupported(&self, out: *mut bool) -> HRESULT
}}
impl IMediaCaptureVideoProfileMediaDescription {
    #[inline] pub unsafe fn get_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Width)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Height)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_rate(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FrameRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_variable_photo_sequence_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsVariablePhotoSequenceSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hdr_video_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHdrVideoSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCaptureVideoProfileMediaDescription: IMediaCaptureVideoProfileMediaDescription}
RT_ENUM! { enum MediaCategory: i32 {
    Other (MediaCategory_Other) = 0, Communications (MediaCategory_Communications) = 1, Media (MediaCategory_Media) = 2, GameChat (MediaCategory_GameChat) = 3, Speech (MediaCategory_Speech) = 4,
}}
RT_ENUM! { enum MediaStreamType: i32 {
    VideoPreview (MediaStreamType_VideoPreview) = 0, VideoRecord (MediaStreamType_VideoRecord) = 1, Audio (MediaStreamType_Audio) = 2, Photo (MediaStreamType_Photo) = 3,
}}
DEFINE_IID!(IID_IOptionalReferencePhotoCapturedEventArgs, 1192200371, 7789, 16465, 156, 139, 241, 216, 90, 240, 71, 183);
RT_INTERFACE!{interface IOptionalReferencePhotoCapturedEventArgs(IOptionalReferencePhotoCapturedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IOptionalReferencePhotoCapturedEventArgs] {
    fn get_Frame(&self, out: *mut *mut CapturedFrame) -> HRESULT,
    fn get_Context(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IOptionalReferencePhotoCapturedEventArgs {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_context(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Context)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class OptionalReferencePhotoCapturedEventArgs: IOptionalReferencePhotoCapturedEventArgs}
DEFINE_IID!(IID_IPhotoCapturedEventArgs, 926677953, 38990, 20464, 191, 133, 28, 0, 170, 188, 90, 69);
RT_INTERFACE!{interface IPhotoCapturedEventArgs(IPhotoCapturedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPhotoCapturedEventArgs] {
    fn get_Frame(&self, out: *mut *mut CapturedFrame) -> HRESULT,
    fn get_Thumbnail(&self, out: *mut *mut CapturedFrame) -> HRESULT,
    fn get_CaptureTimeOffset(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IPhotoCapturedEventArgs {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_capture_time_offset(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaptureTimeOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PhotoCapturedEventArgs: IPhotoCapturedEventArgs}
RT_ENUM! { enum PhotoCaptureSource: i32 {
    Auto (PhotoCaptureSource_Auto) = 0, VideoPreview (PhotoCaptureSource_VideoPreview) = 1, Photo (PhotoCaptureSource_Photo) = 2,
}}
DEFINE_IID!(IID_IPhotoConfirmationCapturedEventArgs, 2873570930, 49802, 18471, 143, 141, 54, 54, 211, 190, 181, 30);
RT_INTERFACE!{interface IPhotoConfirmationCapturedEventArgs(IPhotoConfirmationCapturedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPhotoConfirmationCapturedEventArgs] {
    fn get_Frame(&self, out: *mut *mut CapturedFrame) -> HRESULT,
    fn get_CaptureTimeOffset(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IPhotoConfirmationCapturedEventArgs {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_capture_time_offset(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaptureTimeOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PhotoConfirmationCapturedEventArgs: IPhotoConfirmationCapturedEventArgs}
RT_ENUM! { enum PowerlineFrequency: i32 {
    Disabled (PowerlineFrequency_Disabled) = 0, FiftyHertz (PowerlineFrequency_FiftyHertz) = 1, SixtyHertz (PowerlineFrequency_SixtyHertz) = 2, Auto (PowerlineFrequency_Auto) = 3,
}}
DEFINE_IID!(IID_RecordLimitationExceededEventHandler, 1068404526, 20449, 20477, 170, 186, 225, 241, 51, 125, 78, 83);
RT_DELEGATE!{delegate RecordLimitationExceededEventHandler(RecordLimitationExceededEventHandlerVtbl, RecordLimitationExceededEventHandlerImpl) [IID_RecordLimitationExceededEventHandler] {
    fn Invoke(&self, sender: *mut MediaCapture) -> HRESULT
}}
impl RecordLimitationExceededEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &MediaCapture) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum StreamingCaptureMode: i32 {
    AudioAndVideo (StreamingCaptureMode_AudioAndVideo) = 0, Audio (StreamingCaptureMode_Audio) = 1, Video (StreamingCaptureMode_Video) = 2,
}}
RT_ENUM! { enum VideoDeviceCharacteristic: i32 {
    AllStreamsIndependent (VideoDeviceCharacteristic_AllStreamsIndependent) = 0, PreviewRecordStreamsIdentical (VideoDeviceCharacteristic_PreviewRecordStreamsIdentical) = 1, PreviewPhotoStreamsIdentical (VideoDeviceCharacteristic_PreviewPhotoStreamsIdentical) = 2, RecordPhotoStreamsIdentical (VideoDeviceCharacteristic_RecordPhotoStreamsIdentical) = 3, AllStreamsIdentical (VideoDeviceCharacteristic_AllStreamsIdentical) = 4,
}}
RT_ENUM! { enum VideoRotation: i32 {
    None (VideoRotation_None) = 0, Clockwise90Degrees (VideoRotation_Clockwise90Degrees) = 1, Clockwise180Degrees (VideoRotation_Clockwise180Degrees) = 2, Clockwise270Degrees (VideoRotation_Clockwise270Degrees) = 3,
}}
DEFINE_IID!(IID_IVideoStreamConfiguration, 3631680111, 17296, 19294, 173, 62, 15, 138, 240, 150, 52, 144);
RT_INTERFACE!{interface IVideoStreamConfiguration(IVideoStreamConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IVideoStreamConfiguration] {
    fn get_InputProperties(&self, out: *mut *mut super::mediaproperties::VideoEncodingProperties) -> HRESULT,
    fn get_OutputProperties(&self, out: *mut *mut super::mediaproperties::VideoEncodingProperties) -> HRESULT
}}
impl IVideoStreamConfiguration {
    #[inline] pub unsafe fn get_input_properties(&self) -> Result<ComPtr<super::mediaproperties::VideoEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InputProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_output_properties(&self) -> Result<ComPtr<super::mediaproperties::VideoEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutputProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoStreamConfiguration: IVideoStreamConfiguration}
RT_STRUCT! { struct WhiteBalanceGain {
    R: f64, G: f64, B: f64,
}}
pub mod frames { // Windows.Media.Capture.Frames
use ::prelude::*;
DEFINE_IID!(IID_IBufferMediaFrame, 3048297415, 39812, 16482, 183, 156, 163, 101, 178, 89, 104, 84);
RT_INTERFACE!{interface IBufferMediaFrame(IBufferMediaFrameVtbl): IInspectable(IInspectableVtbl) [IID_IBufferMediaFrame] {
    fn get_FrameReference(&self, out: *mut *mut MediaFrameReference) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Buffer(&self, out: *mut *mut ::rt::gen::windows::storage::streams::IBuffer) -> HRESULT
}}
impl IBufferMediaFrame {
    #[inline] pub unsafe fn get_frame_reference(&self) -> Result<ComPtr<MediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameReference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_buffer(&self) -> Result<ComPtr<::rt::gen::windows::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Buffer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BufferMediaFrame: IBufferMediaFrame}
DEFINE_IID!(IID_IDepthMediaFrame, 1192451663, 34121, 17856, 146, 91, 128, 211, 94, 253, 177, 10);
RT_INTERFACE!{interface IDepthMediaFrame(IDepthMediaFrameVtbl): IInspectable(IInspectableVtbl) [IID_IDepthMediaFrame] {
    fn get_FrameReference(&self, out: *mut *mut MediaFrameReference) -> HRESULT,
    fn get_VideoMediaFrame(&self, out: *mut *mut VideoMediaFrame) -> HRESULT,
    fn get_DepthFormat(&self, out: *mut *mut DepthMediaFrameFormat) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryCreateCoordinateMapper(&self, cameraIntrinsics: *mut super::super::devices::core::CameraIntrinsics, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut super::super::devices::core::DepthCorrelatedCoordinateMapper) -> HRESULT
}}
impl IDepthMediaFrame {
    #[inline] pub unsafe fn get_frame_reference(&self) -> Result<ComPtr<MediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameReference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_media_frame(&self) -> Result<ComPtr<VideoMediaFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoMediaFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_depth_format(&self) -> Result<ComPtr<DepthMediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DepthFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_create_coordinate_mapper(&self, cameraIntrinsics: &super::super::devices::core::CameraIntrinsics, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<super::super::devices::core::DepthCorrelatedCoordinateMapper>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCreateCoordinateMapper)(self as *const _ as *mut _, cameraIntrinsics as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DepthMediaFrame: IDepthMediaFrame}
DEFINE_IID!(IID_IDepthMediaFrame2, 1825195837, 50340, 16758, 176, 205, 51, 234, 227, 179, 90, 163);
RT_INTERFACE!{interface IDepthMediaFrame2(IDepthMediaFrame2Vtbl): IInspectable(IInspectableVtbl) [IID_IDepthMediaFrame2] {
    fn get_MaxReliableDepth(&self, out: *mut u32) -> HRESULT,
    fn get_MinReliableDepth(&self, out: *mut u32) -> HRESULT
}}
impl IDepthMediaFrame2 {
    #[inline] pub unsafe fn get_max_reliable_depth(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxReliableDepth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_reliable_depth(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinReliableDepth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDepthMediaFrameFormat, 3272789824, 55081, 17726, 135, 128, 46, 4, 241, 64, 210, 142);
RT_INTERFACE!{interface IDepthMediaFrameFormat(IDepthMediaFrameFormatVtbl): IInspectable(IInspectableVtbl) [IID_IDepthMediaFrameFormat] {
    fn get_VideoFormat(&self, out: *mut *mut VideoMediaFrameFormat) -> HRESULT,
    fn get_DepthScaleInMeters(&self, out: *mut f64) -> HRESULT
}}
impl IDepthMediaFrameFormat {
    #[inline] pub unsafe fn get_video_format(&self) -> Result<ComPtr<VideoMediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_depth_scale_in_meters(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DepthScaleInMeters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DepthMediaFrameFormat: IDepthMediaFrameFormat}
DEFINE_IID!(IID_IInfraredMediaFrame, 1070675203, 75, 20238, 145, 172, 70, 82, 153, 180, 22, 88);
RT_INTERFACE!{interface IInfraredMediaFrame(IInfraredMediaFrameVtbl): IInspectable(IInspectableVtbl) [IID_IInfraredMediaFrame] {
    fn get_FrameReference(&self, out: *mut *mut MediaFrameReference) -> HRESULT,
    fn get_VideoMediaFrame(&self, out: *mut *mut VideoMediaFrame) -> HRESULT,
    fn get_IsIlluminated(&self, out: *mut bool) -> HRESULT
}}
impl IInfraredMediaFrame {
    #[inline] pub unsafe fn get_frame_reference(&self) -> Result<ComPtr<MediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameReference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_media_frame(&self) -> Result<ComPtr<VideoMediaFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoMediaFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_illuminated(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsIlluminated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InfraredMediaFrame: IInfraredMediaFrame}
DEFINE_IID!(IID_IMediaFrameArrivedEventArgs, 188943069, 42128, 17461, 173, 161, 154, 255, 213, 82, 57, 247);
RT_INTERFACE!{interface IMediaFrameArrivedEventArgs(IMediaFrameArrivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameArrivedEventArgs] {
    
}}
RT_CLASS!{class MediaFrameArrivedEventArgs: IMediaFrameArrivedEventArgs}
DEFINE_IID!(IID_IMediaFrameFormat, 1905273678, 45689, 19095, 169, 219, 189, 90, 47, 183, 143, 57);
RT_INTERFACE!{interface IMediaFrameFormat(IMediaFrameFormatVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameFormat] {
    fn get_MajorType(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Subtype(&self, out: *mut HSTRING) -> HRESULT,
    fn get_FrameRate(&self, out: *mut *mut super::super::mediaproperties::MediaRatio) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMapView<Guid, IInspectable>) -> HRESULT,
    fn get_VideoFormat(&self, out: *mut *mut VideoMediaFrameFormat) -> HRESULT
}}
impl IMediaFrameFormat {
    #[inline] pub unsafe fn get_major_type(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MajorType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subtype(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subtype)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_rate(&self) -> Result<ComPtr<super::super::mediaproperties::MediaRatio>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<Guid, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format(&self) -> Result<ComPtr<VideoMediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameFormat: IMediaFrameFormat}
DEFINE_IID!(IID_IMediaFrameReader, 3838395285, 8232, 18669, 144, 176, 209, 193, 177, 98, 226, 76);
RT_INTERFACE!{interface IMediaFrameReader(IMediaFrameReaderVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameReader] {
    fn add_FrameArrived(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<MediaFrameReader, MediaFrameArrivedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FrameArrived(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn TryAcquireLatestFrame(&self, out: *mut *mut MediaFrameReference) -> HRESULT,
    fn StartAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MediaFrameReaderStartStatus>) -> HRESULT,
    fn StopAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IMediaFrameReader {
    #[inline] pub unsafe fn add_frame_arrived(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<MediaFrameReader, MediaFrameArrivedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FrameArrived)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_frame_arrived(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FrameArrived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_acquire_latest_frame(&self) -> Result<ComPtr<MediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryAcquireLatestFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameReaderStartStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameReader: IMediaFrameReader}
DEFINE_IID!(IID_IMediaFrameReader2, 2266048435, 34097, 16464, 135, 204, 161, 55, 51, 207, 62, 155);
RT_INTERFACE!{interface IMediaFrameReader2(IMediaFrameReader2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameReader2] {
    fn put_AcquisitionMode(&self, value: MediaFrameReaderAcquisitionMode) -> HRESULT,
    fn get_AcquisitionMode(&self, out: *mut MediaFrameReaderAcquisitionMode) -> HRESULT
}}
impl IMediaFrameReader2 {
    #[inline] pub unsafe fn set_acquisition_mode(&self, value: MediaFrameReaderAcquisitionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AcquisitionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_acquisition_mode(&self) -> Result<MediaFrameReaderAcquisitionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AcquisitionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaFrameReaderAcquisitionMode: i32 {
    Realtime (MediaFrameReaderAcquisitionMode_Realtime) = 0, Buffered (MediaFrameReaderAcquisitionMode_Buffered) = 1,
}}
RT_ENUM! { enum MediaFrameReaderStartStatus: i32 {
    Success (MediaFrameReaderStartStatus_Success) = 0, UnknownFailure (MediaFrameReaderStartStatus_UnknownFailure) = 1, DeviceNotAvailable (MediaFrameReaderStartStatus_DeviceNotAvailable) = 2, OutputFormatNotSupported (MediaFrameReaderStartStatus_OutputFormatNotSupported) = 3, ExclusiveControlNotAvailable (MediaFrameReaderStartStatus_ExclusiveControlNotAvailable) = 4,
}}
DEFINE_IID!(IID_IMediaFrameReference, 4139288129, 61660, 16452, 141, 201, 150, 28, 237, 208, 91, 173);
RT_INTERFACE!{interface IMediaFrameReference(IMediaFrameReferenceVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameReference] {
    fn get_SourceKind(&self, out: *mut MediaFrameSourceKind) -> HRESULT,
    fn get_Format(&self, out: *mut *mut MediaFrameFormat) -> HRESULT,
    fn get_SystemRelativeTime(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>) -> HRESULT,
    fn get_Duration(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMapView<Guid, IInspectable>) -> HRESULT,
    fn get_BufferMediaFrame(&self, out: *mut *mut BufferMediaFrame) -> HRESULT,
    fn get_VideoMediaFrame(&self, out: *mut *mut VideoMediaFrame) -> HRESULT,
    #[cfg(feature="windows-perception")] fn get_CoordinateSystem(&self, out: *mut *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> HRESULT
}}
impl IMediaFrameReference {
    #[inline] pub unsafe fn get_source_kind(&self) -> Result<MediaFrameSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_format(&self) -> Result<ComPtr<MediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Format)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_relative_time(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SystemRelativeTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<Guid, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_buffer_media_frame(&self) -> Result<ComPtr<BufferMediaFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BufferMediaFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_media_frame(&self) -> Result<ComPtr<VideoMediaFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoMediaFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_coordinate_system(&self) -> Result<ComPtr<::rt::gen::windows::perception::spatial::SpatialCoordinateSystem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CoordinateSystem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameReference: IMediaFrameReference}
DEFINE_IID!(IID_IMediaFrameSource, 3598199123, 37083, 18088, 138, 221, 42, 168, 132, 168, 210, 83);
RT_INTERFACE!{interface IMediaFrameSource(IMediaFrameSourceVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSource] {
    fn get_Info(&self, out: *mut *mut MediaFrameSourceInfo) -> HRESULT,
    fn get_Controller(&self, out: *mut *mut MediaFrameSourceController) -> HRESULT,
    fn get_SupportedFormats(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<MediaFrameFormat>) -> HRESULT,
    fn get_CurrentFormat(&self, out: *mut *mut MediaFrameFormat) -> HRESULT,
    fn SetFormatAsync(&self, format: *mut MediaFrameFormat, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn add_FormatChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<MediaFrameSource, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FormatChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn TryGetCameraIntrinsics(&self, format: *mut MediaFrameFormat, out: *mut *mut super::super::devices::core::CameraIntrinsics) -> HRESULT
}}
impl IMediaFrameSource {
    #[inline] pub unsafe fn get_info(&self) -> Result<ComPtr<MediaFrameSourceInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Info)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_controller(&self) -> Result<ComPtr<MediaFrameSourceController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Controller)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_formats(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<MediaFrameFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_format(&self) -> Result<ComPtr<MediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CurrentFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_format_async(&self, format: &MediaFrameFormat) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetFormatAsync)(self as *const _ as *mut _, format as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_format_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<MediaFrameSource, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FormatChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_format_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FormatChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_camera_intrinsics(&self, format: &MediaFrameFormat) -> Result<ComPtr<super::super::devices::core::CameraIntrinsics>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetCameraIntrinsics)(self as *const _ as *mut _, format as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameSource: IMediaFrameSource}
DEFINE_IID!(IID_IMediaFrameSourceController, 1829201461, 12653, 19343, 183, 182, 238, 176, 74, 140, 101, 37);
RT_INTERFACE!{interface IMediaFrameSourceController(IMediaFrameSourceControllerVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSourceController] {
    fn GetPropertyAsync(&self, propertyId: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGetPropertyResult>) -> HRESULT,
    fn SetPropertyAsync(&self, propertyId: HSTRING, propertyValue: *mut IInspectable, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceSetPropertyStatus>) -> HRESULT,
    fn get_VideoDeviceController(&self, out: *mut *mut super::super::devices::VideoDeviceController) -> HRESULT
}}
impl IMediaFrameSourceController {
    #[inline] pub unsafe fn get_property_async(&self, propertyId: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGetPropertyResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetPropertyAsync)(self as *const _ as *mut _, propertyId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_property_async(&self, propertyId: &HStringArg, propertyValue: &IInspectable) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceSetPropertyStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetPropertyAsync)(self as *const _ as *mut _, propertyId.get(), propertyValue as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_device_controller(&self) -> Result<ComPtr<super::super::devices::VideoDeviceController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoDeviceController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameSourceController: IMediaFrameSourceController}
DEFINE_IID!(IID_IMediaFrameSourceController2, 4022640596, 64754, 18947, 180, 228, 172, 150, 40, 115, 155, 238);
RT_INTERFACE!{interface IMediaFrameSourceController2(IMediaFrameSourceController2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSourceController2] {
    fn GetPropertyByExtendedIdAsync(&self, extendedPropertyIdSize: u32, extendedPropertyId: *mut u8, maxPropertyValueSize: *mut ::rt::gen::windows::foundation::IReference<u32>, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGetPropertyResult>) -> HRESULT,
    fn SetPropertyByExtendedIdAsync(&self, extendedPropertyIdSize: u32, extendedPropertyId: *mut u8, propertyValueSize: u32, propertyValue: *mut u8, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceSetPropertyStatus>) -> HRESULT
}}
impl IMediaFrameSourceController2 {
    #[inline] pub unsafe fn get_property_by_extended_id_async(&self, extendedPropertyId: &[u8], maxPropertyValueSize: &::rt::gen::windows::foundation::IReference<u32>) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGetPropertyResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetPropertyByExtendedIdAsync)(self as *const _ as *mut _, extendedPropertyId.len() as u32, extendedPropertyId.as_ptr() as *mut _, maxPropertyValueSize as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_property_by_extended_id_async(&self, extendedPropertyId: &[u8], propertyValue: &[u8]) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceSetPropertyStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetPropertyByExtendedIdAsync)(self as *const _ as *mut _, extendedPropertyId.len() as u32, extendedPropertyId.as_ptr() as *mut _, propertyValue.len() as u32, propertyValue.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaFrameSourceGetPropertyResult, 143005378, 14948, 19413, 189, 43, 231, 200, 152, 210, 243, 122);
RT_INTERFACE!{interface IMediaFrameSourceGetPropertyResult(IMediaFrameSourceGetPropertyResultVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSourceGetPropertyResult] {
    fn get_Status(&self, out: *mut MediaFrameSourceGetPropertyStatus) -> HRESULT,
    fn get_Value(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IMediaFrameSourceGetPropertyResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<MediaFrameSourceGetPropertyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameSourceGetPropertyResult: IMediaFrameSourceGetPropertyResult}
RT_ENUM! { enum MediaFrameSourceGetPropertyStatus: i32 {
    Success (MediaFrameSourceGetPropertyStatus_Success) = 0, UnknownFailure (MediaFrameSourceGetPropertyStatus_UnknownFailure) = 1, NotSupported (MediaFrameSourceGetPropertyStatus_NotSupported) = 2, DeviceNotAvailable (MediaFrameSourceGetPropertyStatus_DeviceNotAvailable) = 3, MaxPropertyValueSizeTooSmall (MediaFrameSourceGetPropertyStatus_MaxPropertyValueSizeTooSmall) = 4, MaxPropertyValueSizeRequired (MediaFrameSourceGetPropertyStatus_MaxPropertyValueSizeRequired) = 5,
}}
DEFINE_IID!(IID_IMediaFrameSourceGroup, 2137021319, 18482, 19295, 174, 61, 65, 47, 170, 179, 125, 52);
RT_INTERFACE!{interface IMediaFrameSourceGroup(IMediaFrameSourceGroupVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSourceGroup] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SourceInfos(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<MediaFrameSourceInfo>) -> HRESULT
}}
impl IMediaFrameSourceGroup {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_infos(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<MediaFrameSourceInfo>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceInfos)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameSourceGroup: IMediaFrameSourceGroup}
impl RtActivatable<IMediaFrameSourceGroupStatics> for MediaFrameSourceGroup {}
impl MediaFrameSourceGroup {
    #[inline] pub fn find_all_async() -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<MediaFrameSourceGroup>>>> { unsafe {
        <Self as RtActivatable<IMediaFrameSourceGroupStatics>>::get_activation_factory().find_all_async()
    }}
    #[inline] pub fn from_id_async(id: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGroup>>> { unsafe {
        <Self as RtActivatable<IMediaFrameSourceGroupStatics>>::get_activation_factory().from_id_async(id)
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaFrameSourceGroupStatics>>::get_activation_factory().get_device_selector()
    }}
}
DEFINE_CLSID!(MediaFrameSourceGroup(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,112,116,117,114,101,46,70,114,97,109,101,115,46,77,101,100,105,97,70,114,97,109,101,83,111,117,114,99,101,71,114,111,117,112,0]) [CLSID_MediaFrameSourceGroup]);
DEFINE_IID!(IID_IMediaFrameSourceGroupStatics, 474529733, 17263, 17672, 148, 207, 213, 216, 183, 50, 100, 69);
RT_INTERFACE!{static interface IMediaFrameSourceGroupStatics(IMediaFrameSourceGroupStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSourceGroupStatics] {
    fn FindAllAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<MediaFrameSourceGroup>>) -> HRESULT,
    fn FromIdAsync(&self, id: HSTRING, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGroup>) -> HRESULT,
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaFrameSourceGroupStatics {
    #[inline] pub unsafe fn find_all_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<MediaFrameSourceGroup>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, id: &HStringArg) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MediaFrameSourceGroup>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, id.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaFrameSourceInfo, 2277362125, 17921, 16527, 145, 207, 3, 131, 24, 205, 10, 243);
RT_INTERFACE!{interface IMediaFrameSourceInfo(IMediaFrameSourceInfoVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFrameSourceInfo] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_MediaStreamType(&self, out: *mut super::MediaStreamType) -> HRESULT,
    fn get_SourceKind(&self, out: *mut MediaFrameSourceKind) -> HRESULT,
    fn get_SourceGroup(&self, out: *mut *mut MediaFrameSourceGroup) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_DeviceInformation(&self, out: *mut *mut ::rt::gen::windows::devices::enumeration::DeviceInformation) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IMapView<Guid, IInspectable>) -> HRESULT,
    #[cfg(feature="windows-perception")] fn get_CoordinateSystem(&self, out: *mut *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> HRESULT
}}
impl IMediaFrameSourceInfo {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_stream_type(&self) -> Result<super::MediaStreamType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediaStreamType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_kind(&self) -> Result<MediaFrameSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_group(&self) -> Result<ComPtr<MediaFrameSourceGroup>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceGroup)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_device_information(&self) -> Result<ComPtr<::rt::gen::windows::devices::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInformation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IMapView<Guid, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_coordinate_system(&self) -> Result<ComPtr<::rt::gen::windows::perception::spatial::SpatialCoordinateSystem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CoordinateSystem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFrameSourceInfo: IMediaFrameSourceInfo}
RT_ENUM! { enum MediaFrameSourceKind: i32 {
    Custom (MediaFrameSourceKind_Custom) = 0, Color (MediaFrameSourceKind_Color) = 1, Infrared (MediaFrameSourceKind_Infrared) = 2, Depth (MediaFrameSourceKind_Depth) = 3,
}}
RT_ENUM! { enum MediaFrameSourceSetPropertyStatus: i32 {
    Success (MediaFrameSourceSetPropertyStatus_Success) = 0, UnknownFailure (MediaFrameSourceSetPropertyStatus_UnknownFailure) = 1, NotSupported (MediaFrameSourceSetPropertyStatus_NotSupported) = 2, InvalidValue (MediaFrameSourceSetPropertyStatus_InvalidValue) = 3, DeviceNotAvailable (MediaFrameSourceSetPropertyStatus_DeviceNotAvailable) = 4, NotInControl (MediaFrameSourceSetPropertyStatus_NotInControl) = 5,
}}
DEFINE_IID!(IID_IMultiSourceMediaFrameArrivedEventArgs, 1662082561, 53073, 18685, 170, 176, 109, 105, 62, 180, 129, 39);
RT_INTERFACE!{interface IMultiSourceMediaFrameArrivedEventArgs(IMultiSourceMediaFrameArrivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMultiSourceMediaFrameArrivedEventArgs] {
    
}}
RT_CLASS!{class MultiSourceMediaFrameArrivedEventArgs: IMultiSourceMediaFrameArrivedEventArgs}
DEFINE_IID!(IID_IMultiSourceMediaFrameReader, 2366915586, 63331, 18573, 152, 242, 180, 55, 188, 240, 117, 231);
RT_INTERFACE!{interface IMultiSourceMediaFrameReader(IMultiSourceMediaFrameReaderVtbl): IInspectable(IInspectableVtbl) [IID_IMultiSourceMediaFrameReader] {
    fn add_FrameArrived(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<MultiSourceMediaFrameReader, MultiSourceMediaFrameArrivedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FrameArrived(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn TryAcquireLatestFrame(&self, out: *mut *mut MultiSourceMediaFrameReference) -> HRESULT,
    fn StartAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<MultiSourceMediaFrameReaderStartStatus>) -> HRESULT,
    fn StopAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IMultiSourceMediaFrameReader {
    #[inline] pub unsafe fn add_frame_arrived(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<MultiSourceMediaFrameReader, MultiSourceMediaFrameArrivedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FrameArrived)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_frame_arrived(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FrameArrived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_acquire_latest_frame(&self) -> Result<ComPtr<MultiSourceMediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryAcquireLatestFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<MultiSourceMediaFrameReaderStartStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MultiSourceMediaFrameReader: IMultiSourceMediaFrameReader}
DEFINE_IID!(IID_IMultiSourceMediaFrameReader2, 4015819453, 64604, 19563, 157, 129, 60, 185, 204, 99, 124, 38);
RT_INTERFACE!{interface IMultiSourceMediaFrameReader2(IMultiSourceMediaFrameReader2Vtbl): IInspectable(IInspectableVtbl) [IID_IMultiSourceMediaFrameReader2] {
    fn put_AcquisitionMode(&self, value: MediaFrameReaderAcquisitionMode) -> HRESULT,
    fn get_AcquisitionMode(&self, out: *mut MediaFrameReaderAcquisitionMode) -> HRESULT
}}
impl IMultiSourceMediaFrameReader2 {
    #[inline] pub unsafe fn set_acquisition_mode(&self, value: MediaFrameReaderAcquisitionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AcquisitionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_acquisition_mode(&self) -> Result<MediaFrameReaderAcquisitionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AcquisitionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum MultiSourceMediaFrameReaderStartStatus: i32 {
    Success (MultiSourceMediaFrameReaderStartStatus_Success) = 0, NotSupported (MultiSourceMediaFrameReaderStartStatus_NotSupported) = 1, InsufficientResources (MultiSourceMediaFrameReaderStartStatus_InsufficientResources) = 2, DeviceNotAvailable (MultiSourceMediaFrameReaderStartStatus_DeviceNotAvailable) = 3, UnknownFailure (MultiSourceMediaFrameReaderStartStatus_UnknownFailure) = 4,
}}
DEFINE_IID!(IID_IMultiSourceMediaFrameReference, 563497754, 32738, 17622, 146, 229, 41, 142, 109, 40, 16, 233);
RT_INTERFACE!{interface IMultiSourceMediaFrameReference(IMultiSourceMediaFrameReferenceVtbl): IInspectable(IInspectableVtbl) [IID_IMultiSourceMediaFrameReference] {
    fn TryGetFrameReferenceBySourceId(&self, sourceId: HSTRING, out: *mut *mut MediaFrameReference) -> HRESULT
}}
impl IMultiSourceMediaFrameReference {
    #[inline] pub unsafe fn try_get_frame_reference_by_source_id(&self, sourceId: &HStringArg) -> Result<ComPtr<MediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetFrameReferenceBySourceId)(self as *const _ as *mut _, sourceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MultiSourceMediaFrameReference: IMultiSourceMediaFrameReference}
DEFINE_IID!(IID_IVideoMediaFrame, 14503115, 12989, 20449, 160, 19, 124, 193, 60, 245, 219, 207);
RT_INTERFACE!{interface IVideoMediaFrame(IVideoMediaFrameVtbl): IInspectable(IInspectableVtbl) [IID_IVideoMediaFrame] {
    fn get_FrameReference(&self, out: *mut *mut MediaFrameReference) -> HRESULT,
    fn get_VideoFormat(&self, out: *mut *mut VideoMediaFrameFormat) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-graphics")] fn get_SoftwareBitmap(&self, out: *mut *mut ::rt::gen::windows::graphics::imaging::SoftwareBitmap) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-graphics")] fn get_Direct3DSurface(&self, out: *mut *mut ::rt::gen::windows::graphics::directx::direct3d11::IDirect3DSurface) -> HRESULT,
    fn get_CameraIntrinsics(&self, out: *mut *mut super::super::devices::core::CameraIntrinsics) -> HRESULT,
    fn get_InfraredMediaFrame(&self, out: *mut *mut InfraredMediaFrame) -> HRESULT,
    fn get_DepthMediaFrame(&self, out: *mut *mut DepthMediaFrame) -> HRESULT,
    fn GetVideoFrame(&self, out: *mut *mut super::super::VideoFrame) -> HRESULT
}}
impl IVideoMediaFrame {
    #[inline] pub unsafe fn get_frame_reference(&self) -> Result<ComPtr<MediaFrameReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameReference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format(&self) -> Result<ComPtr<VideoMediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_software_bitmap(&self) -> Result<ComPtr<::rt::gen::windows::graphics::imaging::SoftwareBitmap>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SoftwareBitmap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_direct3_dsurface(&self) -> Result<ComPtr<::rt::gen::windows::graphics::directx::direct3d11::IDirect3DSurface>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Direct3DSurface)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_camera_intrinsics(&self) -> Result<ComPtr<super::super::devices::core::CameraIntrinsics>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CameraIntrinsics)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_infrared_media_frame(&self) -> Result<ComPtr<InfraredMediaFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InfraredMediaFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_depth_media_frame(&self) -> Result<ComPtr<DepthMediaFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DepthMediaFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_frame(&self) -> Result<ComPtr<super::super::VideoFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetVideoFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoMediaFrame: IVideoMediaFrame}
DEFINE_IID!(IID_IVideoMediaFrameFormat, 1174568896, 55067, 17863, 143, 20, 109, 154, 10, 230, 4, 228);
RT_INTERFACE!{interface IVideoMediaFrameFormat(IVideoMediaFrameFormatVtbl): IInspectable(IInspectableVtbl) [IID_IVideoMediaFrameFormat] {
    fn get_MediaFrameFormat(&self, out: *mut *mut MediaFrameFormat) -> HRESULT,
    fn get_DepthFormat(&self, out: *mut *mut DepthMediaFrameFormat) -> HRESULT,
    fn get_Width(&self, out: *mut u32) -> HRESULT,
    fn get_Height(&self, out: *mut u32) -> HRESULT
}}
impl IVideoMediaFrameFormat {
    #[inline] pub unsafe fn get_media_frame_format(&self) -> Result<ComPtr<MediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaFrameFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_depth_format(&self) -> Result<ComPtr<DepthMediaFrameFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DepthFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Width)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Height)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class VideoMediaFrameFormat: IVideoMediaFrameFormat}
} // Windows.Media.Capture.Frames
pub mod core { // Windows.Media.Capture.Core
use ::prelude::*;
DEFINE_IID!(IID_IVariablePhotoCapturedEventArgs, 3521858652, 6995, 20042, 139, 92, 219, 120, 135, 172, 148, 155);
RT_INTERFACE!{interface IVariablePhotoCapturedEventArgs(IVariablePhotoCapturedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVariablePhotoCapturedEventArgs] {
    fn get_Frame(&self, out: *mut *mut super::CapturedFrame) -> HRESULT,
    fn get_CaptureTimeOffset(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_UsedFrameControllerIndex(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<u32>) -> HRESULT,
    fn get_CapturedFrameControlValues(&self, out: *mut *mut super::CapturedFrameControlValues) -> HRESULT
}}
impl IVariablePhotoCapturedEventArgs {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<super::CapturedFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_capture_time_offset(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaptureTimeOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_used_frame_controller_index(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UsedFrameControllerIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_captured_frame_control_values(&self) -> Result<ComPtr<super::CapturedFrameControlValues>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CapturedFrameControlValues)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VariablePhotoCapturedEventArgs: IVariablePhotoCapturedEventArgs}
DEFINE_IID!(IID_IVariablePhotoSequenceCapture, 3490786589, 798, 16449, 166, 214, 189, 116, 36, 118, 168, 238);
RT_INTERFACE!{interface IVariablePhotoSequenceCapture(IVariablePhotoSequenceCaptureVtbl): IInspectable(IInspectableVtbl) [IID_IVariablePhotoSequenceCapture] {
    fn StartAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn StopAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn FinishAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT,
    fn add_PhotoCaptured(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<VariablePhotoSequenceCapture, VariablePhotoCapturedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PhotoCaptured(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Stopped(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<VariablePhotoSequenceCapture, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IVariablePhotoSequenceCapture {
    #[inline] pub unsafe fn start_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn finish_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FinishAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_photo_captured(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<VariablePhotoSequenceCapture, VariablePhotoCapturedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PhotoCaptured)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_photo_captured(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PhotoCaptured)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stopped(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<VariablePhotoSequenceCapture, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Stopped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Stopped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VariablePhotoSequenceCapture: IVariablePhotoSequenceCapture}
DEFINE_IID!(IID_IVariablePhotoSequenceCapture2, 4264321724, 20656, 17379, 145, 124, 227, 185, 39, 152, 148, 47);
RT_INTERFACE!{interface IVariablePhotoSequenceCapture2(IVariablePhotoSequenceCapture2Vtbl): IInspectable(IInspectableVtbl) [IID_IVariablePhotoSequenceCapture2] {
    fn UpdateSettingsAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncAction) -> HRESULT
}}
impl IVariablePhotoSequenceCapture2 {
    #[inline] pub unsafe fn update_settings_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UpdateSettingsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Media.Capture.Core
} // Windows.Media.Capture
pub mod apprecording { // Windows.Media.AppRecording
use ::prelude::*;
DEFINE_IID!(IID_IAppRecordingManager, 3890372726, 41028, 18658, 165, 18, 48, 148, 213, 116, 199, 204);
RT_INTERFACE!{interface IAppRecordingManager(IAppRecordingManagerVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingManager] {
    fn GetStatus(&self, out: *mut *mut AppRecordingStatus) -> HRESULT,
    #[cfg(feature="windows-storage")] fn StartRecordingToFileAsync(&self, file: *mut super::super::storage::StorageFile, out: *mut *mut super::super::foundation::IAsyncOperation<AppRecordingResult>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn RecordTimeSpanToFileAsync(&self, startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan, file: *mut super::super::storage::StorageFile, out: *mut *mut super::super::foundation::IAsyncOperation<AppRecordingResult>) -> HRESULT,
    fn get_SupportedScreenshotMediaEncodingSubtypes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<HString>) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SaveScreenshotToFilesAsync(&self, folder: *mut super::super::storage::StorageFolder, filenamePrefix: HSTRING, option: AppRecordingSaveScreenshotOption, requestedFormats: *mut super::super::foundation::collections::IIterable<HString>, out: *mut *mut super::super::foundation::IAsyncOperation<AppRecordingSaveScreenshotResult>) -> HRESULT
}}
impl IAppRecordingManager {
    #[inline] pub unsafe fn get_status(&self) -> Result<ComPtr<AppRecordingStatus>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn start_recording_to_file_async(&self, file: &super::super::storage::StorageFile) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRecordingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartRecordingToFileAsync)(self as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn record_time_span_to_file_async(&self, startTime: super::super::foundation::DateTime, duration: super::super::foundation::TimeSpan, file: &super::super::storage::StorageFile) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRecordingResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RecordTimeSpanToFileAsync)(self as *const _ as *mut _, startTime, duration, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_screenshot_media_encoding_subtypes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedScreenshotMediaEncodingSubtypes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn save_screenshot_to_files_async(&self, folder: &super::super::storage::StorageFolder, filenamePrefix: &HStringArg, option: AppRecordingSaveScreenshotOption, requestedFormats: &super::super::foundation::collections::IIterable<HString>) -> Result<ComPtr<super::super::foundation::IAsyncOperation<AppRecordingSaveScreenshotResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveScreenshotToFilesAsync)(self as *const _ as *mut _, folder as *const _ as *mut _, filenamePrefix.get(), option, requestedFormats as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppRecordingManager: IAppRecordingManager}
impl RtActivatable<IAppRecordingManagerStatics> for AppRecordingManager {}
impl AppRecordingManager {
    #[inline] pub fn get_default() -> Result<ComPtr<AppRecordingManager>> { unsafe {
        <Self as RtActivatable<IAppRecordingManagerStatics>>::get_activation_factory().get_default()
    }}
}
DEFINE_CLSID!(AppRecordingManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,112,112,82,101,99,111,114,100,105,110,103,46,65,112,112,82,101,99,111,114,100,105,110,103,77,97,110,97,103,101,114,0]) [CLSID_AppRecordingManager]);
DEFINE_IID!(IID_IAppRecordingManagerStatics, 1357318647, 14542, 19411, 157, 178, 231, 43, 190, 157, 225, 29);
RT_INTERFACE!{static interface IAppRecordingManagerStatics(IAppRecordingManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingManagerStatics] {
    fn GetDefault(&self, out: *mut *mut AppRecordingManager) -> HRESULT
}}
impl IAppRecordingManagerStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<AppRecordingManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppRecordingResult, 982517860, 50797, 18169, 178, 217, 91, 194, 218, 208, 112, 215);
RT_INTERFACE!{interface IAppRecordingResult(IAppRecordingResultVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingResult] {
    fn get_Succeeded(&self, out: *mut bool) -> HRESULT,
    fn get_ExtendedError(&self, out: *mut super::super::foundation::HResult) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_IsFileTruncated(&self, out: *mut bool) -> HRESULT
}}
impl IAppRecordingResult {
    #[inline] pub unsafe fn get_succeeded(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Succeeded)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_file_truncated(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFileTruncated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppRecordingResult: IAppRecordingResult}
DEFINE_IID!(IID_IAppRecordingSavedScreenshotInfo, 2607033610, 6298, 19712, 191, 37, 225, 187, 18, 73, 213, 148);
RT_INTERFACE!{interface IAppRecordingSavedScreenshotInfo(IAppRecordingSavedScreenshotInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingSavedScreenshotInfo] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_File(&self, out: *mut *mut super::super::storage::StorageFile) -> HRESULT,
    fn get_MediaEncodingSubtype(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAppRecordingSavedScreenshotInfo {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file(&self) -> Result<ComPtr<super::super::storage::StorageFile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_File)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_encoding_subtype(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaEncodingSubtype)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppRecordingSavedScreenshotInfo: IAppRecordingSavedScreenshotInfo}
RT_ENUM! { enum AppRecordingSaveScreenshotOption: i32 {
    None (AppRecordingSaveScreenshotOption_None) = 0, HdrContentVisible (AppRecordingSaveScreenshotOption_HdrContentVisible) = 1,
}}
DEFINE_IID!(IID_IAppRecordingSaveScreenshotResult, 2623245578, 2747, 17495, 170, 238, 36, 249, 193, 46, 199, 120);
RT_INTERFACE!{interface IAppRecordingSaveScreenshotResult(IAppRecordingSaveScreenshotResultVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingSaveScreenshotResult] {
    fn get_Succeeded(&self, out: *mut bool) -> HRESULT,
    fn get_ExtendedError(&self, out: *mut super::super::foundation::HResult) -> HRESULT,
    fn get_SavedScreenshotInfos(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AppRecordingSavedScreenshotInfo>) -> HRESULT
}}
impl IAppRecordingSaveScreenshotResult {
    #[inline] pub unsafe fn get_succeeded(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Succeeded)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_saved_screenshot_infos(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AppRecordingSavedScreenshotInfo>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SavedScreenshotInfos)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppRecordingSaveScreenshotResult: IAppRecordingSaveScreenshotResult}
DEFINE_IID!(IID_IAppRecordingStatus, 487376940, 48152, 19338, 166, 239, 18, 126, 250, 179, 181, 217);
RT_INTERFACE!{interface IAppRecordingStatus(IAppRecordingStatusVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingStatus] {
    fn get_CanRecord(&self, out: *mut bool) -> HRESULT,
    fn get_CanRecordTimeSpan(&self, out: *mut bool) -> HRESULT,
    fn get_HistoricalBufferDuration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Details(&self, out: *mut *mut AppRecordingStatusDetails) -> HRESULT
}}
impl IAppRecordingStatus {
    #[inline] pub unsafe fn get_can_record(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanRecord)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_record_time_span(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanRecordTimeSpan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_historical_buffer_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HistoricalBufferDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_details(&self) -> Result<ComPtr<AppRecordingStatusDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Details)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppRecordingStatus: IAppRecordingStatus}
DEFINE_IID!(IID_IAppRecordingStatusDetails, 3040389552, 5357, 17426, 172, 69, 109, 103, 44, 156, 153, 73);
RT_INTERFACE!{interface IAppRecordingStatusDetails(IAppRecordingStatusDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IAppRecordingStatusDetails] {
    fn get_IsAnyAppBroadcasting(&self, out: *mut bool) -> HRESULT,
    fn get_IsCaptureResourceUnavailable(&self, out: *mut bool) -> HRESULT,
    fn get_IsGameStreamInProgress(&self, out: *mut bool) -> HRESULT,
    fn get_IsTimeSpanRecordingDisabled(&self, out: *mut bool) -> HRESULT,
    fn get_IsGpuConstrained(&self, out: *mut bool) -> HRESULT,
    fn get_IsAppInactive(&self, out: *mut bool) -> HRESULT,
    fn get_IsBlockedForApp(&self, out: *mut bool) -> HRESULT,
    fn get_IsDisabledByUser(&self, out: *mut bool) -> HRESULT,
    fn get_IsDisabledBySystem(&self, out: *mut bool) -> HRESULT
}}
impl IAppRecordingStatusDetails {
    #[inline] pub unsafe fn get_is_any_app_broadcasting(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAnyAppBroadcasting)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_capture_resource_unavailable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCaptureResourceUnavailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_game_stream_in_progress(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGameStreamInProgress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_time_span_recording_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTimeSpanRecordingDisabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_gpu_constrained(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGpuConstrained)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_app_inactive(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAppInactive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_blocked_for_app(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBlockedForApp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled_by_user(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabledByUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled_by_system(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabledBySystem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppRecordingStatusDetails: IAppRecordingStatusDetails}
} // Windows.Media.AppRecording
pub mod appbroadcasting { // Windows.Media.AppBroadcasting
use ::prelude::*;
DEFINE_IID!(IID_IAppBroadcastingMonitor, 16341608, 35079, 18592, 184, 239, 36, 210, 8, 19, 117, 66);
RT_INTERFACE!{interface IAppBroadcastingMonitor(IAppBroadcastingMonitorVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastingMonitor] {
    fn get_IsCurrentAppBroadcasting(&self, out: *mut bool) -> HRESULT,
    fn add_IsCurrentAppBroadcastingChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AppBroadcastingMonitor, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_IsCurrentAppBroadcastingChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBroadcastingMonitor {
    #[inline] pub unsafe fn get_is_current_app_broadcasting(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCurrentAppBroadcasting)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_is_current_app_broadcasting_changed(&self, handler: &super::super::foundation::TypedEventHandler<AppBroadcastingMonitor, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_IsCurrentAppBroadcastingChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_is_current_app_broadcasting_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_IsCurrentAppBroadcastingChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastingMonitor: IAppBroadcastingMonitor}
impl RtActivatable<IActivationFactory> for AppBroadcastingMonitor {}
DEFINE_CLSID!(AppBroadcastingMonitor(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,112,112,66,114,111,97,100,99,97,115,116,105,110,103,46,65,112,112,66,114,111,97,100,99,97,115,116,105,110,103,77,111,110,105,116,111,114,0]) [CLSID_AppBroadcastingMonitor]);
DEFINE_IID!(IID_IAppBroadcastingStatus, 304473311, 929, 17144, 139, 128, 201, 34, 140, 217, 207, 46);
RT_INTERFACE!{interface IAppBroadcastingStatus(IAppBroadcastingStatusVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastingStatus] {
    fn get_CanStartBroadcast(&self, out: *mut bool) -> HRESULT,
    fn get_Details(&self, out: *mut *mut AppBroadcastingStatusDetails) -> HRESULT
}}
impl IAppBroadcastingStatus {
    #[inline] pub unsafe fn get_can_start_broadcast(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanStartBroadcast)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_details(&self) -> Result<ComPtr<AppBroadcastingStatusDetails>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Details)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastingStatus: IAppBroadcastingStatus}
DEFINE_IID!(IID_IAppBroadcastingStatusDetails, 110996900, 46451, 20028, 142, 25, 27, 175, 172, 208, 151, 19);
RT_INTERFACE!{interface IAppBroadcastingStatusDetails(IAppBroadcastingStatusDetailsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastingStatusDetails] {
    fn get_IsAnyAppBroadcasting(&self, out: *mut bool) -> HRESULT,
    fn get_IsCaptureResourceUnavailable(&self, out: *mut bool) -> HRESULT,
    fn get_IsGameStreamInProgress(&self, out: *mut bool) -> HRESULT,
    fn get_IsGpuConstrained(&self, out: *mut bool) -> HRESULT,
    fn get_IsAppInactive(&self, out: *mut bool) -> HRESULT,
    fn get_IsBlockedForApp(&self, out: *mut bool) -> HRESULT,
    fn get_IsDisabledByUser(&self, out: *mut bool) -> HRESULT,
    fn get_IsDisabledBySystem(&self, out: *mut bool) -> HRESULT
}}
impl IAppBroadcastingStatusDetails {
    #[inline] pub unsafe fn get_is_any_app_broadcasting(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAnyAppBroadcasting)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_capture_resource_unavailable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCaptureResourceUnavailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_game_stream_in_progress(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGameStreamInProgress)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_gpu_constrained(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGpuConstrained)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_app_inactive(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAppInactive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_blocked_for_app(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBlockedForApp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled_by_user(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabledByUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_disabled_by_system(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDisabledBySystem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastingStatusDetails: IAppBroadcastingStatusDetails}
DEFINE_IID!(IID_IAppBroadcastingUI, 3849297807, 61081, 19914, 163, 195, 112, 175, 61, 180, 79, 95);
RT_INTERFACE!{interface IAppBroadcastingUI(IAppBroadcastingUIVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastingUI] {
    fn GetStatus(&self, out: *mut *mut AppBroadcastingStatus) -> HRESULT,
    fn ShowBroadcastUI(&self) -> HRESULT
}}
impl IAppBroadcastingUI {
    #[inline] pub unsafe fn get_status(&self) -> Result<ComPtr<AppBroadcastingStatus>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_broadcast_ui(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowBroadcastUI)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBroadcastingUI: IAppBroadcastingUI}
impl RtActivatable<IAppBroadcastingUIStatics> for AppBroadcastingUI {}
impl AppBroadcastingUI {
    #[inline] pub fn get_default() -> Result<ComPtr<AppBroadcastingUI>> { unsafe {
        <Self as RtActivatable<IAppBroadcastingUIStatics>>::get_activation_factory().get_default()
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<AppBroadcastingUI>> { unsafe {
        <Self as RtActivatable<IAppBroadcastingUIStatics>>::get_activation_factory().get_for_user(user)
    }}
}
DEFINE_CLSID!(AppBroadcastingUI(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,112,112,66,114,111,97,100,99,97,115,116,105,110,103,46,65,112,112,66,114,111,97,100,99,97,115,116,105,110,103,85,73,0]) [CLSID_AppBroadcastingUI]);
DEFINE_IID!(IID_IAppBroadcastingUIStatics, 1437116317, 9163, 17785, 156, 52, 136, 111, 224, 44, 4, 90);
RT_INTERFACE!{static interface IAppBroadcastingUIStatics(IAppBroadcastingUIStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBroadcastingUIStatics] {
    fn GetDefault(&self, out: *mut *mut AppBroadcastingUI) -> HRESULT,
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut AppBroadcastingUI) -> HRESULT
}}
impl IAppBroadcastingUIStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<AppBroadcastingUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<AppBroadcastingUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.Media.AppBroadcasting
pub mod audio { // Windows.Media.Audio
use ::prelude::*;
DEFINE_IID!(IID_IAudioDeviceInputNode, 2954587105, 28494, 18914, 172, 1, 85, 157, 98, 190, 179, 169);
RT_INTERFACE!{interface IAudioDeviceInputNode(IAudioDeviceInputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceInputNode] {
    #[cfg(feature="windows-devices")] fn get_Device(&self, out: *mut *mut super::super::devices::enumeration::DeviceInformation) -> HRESULT
}}
impl IAudioDeviceInputNode {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_device(&self) -> Result<ComPtr<super::super::devices::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Device)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioDeviceInputNode: IAudioDeviceInputNode}
RT_ENUM! { enum AudioDeviceNodeCreationStatus: i32 {
    Success (AudioDeviceNodeCreationStatus_Success) = 0, DeviceNotAvailable (AudioDeviceNodeCreationStatus_DeviceNotAvailable) = 1, FormatNotSupported (AudioDeviceNodeCreationStatus_FormatNotSupported) = 2, UnknownFailure (AudioDeviceNodeCreationStatus_UnknownFailure) = 3, AccessDenied (AudioDeviceNodeCreationStatus_AccessDenied) = 4,
}}
DEFINE_IID!(IID_IAudioDeviceOutputNode, 909040639, 65308, 17460, 158, 15, 189, 46, 245, 34, 172, 130);
RT_INTERFACE!{interface IAudioDeviceOutputNode(IAudioDeviceOutputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceOutputNode] {
    #[cfg(feature="windows-devices")] fn get_Device(&self, out: *mut *mut super::super::devices::enumeration::DeviceInformation) -> HRESULT
}}
impl IAudioDeviceOutputNode {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_device(&self) -> Result<ComPtr<super::super::devices::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Device)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioDeviceOutputNode: IAudioDeviceOutputNode}
DEFINE_IID!(IID_IAudioFileInputNode, 2421909448, 28517, 19668, 136, 144, 70, 148, 132, 60, 39, 109);
RT_INTERFACE!{interface IAudioFileInputNode(IAudioFileInputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFileInputNode] {
    fn put_PlaybackSpeedFactor(&self, value: f64) -> HRESULT,
    fn get_PlaybackSpeedFactor(&self, out: *mut f64) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn Seek(&self, position: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_StartTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_StartTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_EndTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_EndTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_LoopCount(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_LoopCount(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy11(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_SourceFile(&self, out: *mut *mut super::super::storage::StorageFile) -> HRESULT,
    fn add_FileCompleted(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioFileInputNode, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FileCompleted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAudioFileInputNode {
    #[inline] pub unsafe fn set_playback_speed_factor(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaybackSpeedFactor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_playback_speed_factor(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlaybackSpeedFactor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn seek(&self, position: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).Seek)(self as *const _ as *mut _, position);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_time(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_end_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EndTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_end_time(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EndTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_loop_count(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LoopCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_loop_count(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LoopCount)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_source_file(&self) -> Result<ComPtr<super::super::storage::StorageFile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceFile)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_file_completed(&self, handler: &super::super::foundation::TypedEventHandler<AudioFileInputNode, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FileCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_file_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FileCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AudioFileInputNode: IAudioFileInputNode}
RT_ENUM! { enum AudioFileNodeCreationStatus: i32 {
    Success (AudioFileNodeCreationStatus_Success) = 0, FileNotFound (AudioFileNodeCreationStatus_FileNotFound) = 1, InvalidFileType (AudioFileNodeCreationStatus_InvalidFileType) = 2, FormatNotSupported (AudioFileNodeCreationStatus_FormatNotSupported) = 3, UnknownFailure (AudioFileNodeCreationStatus_UnknownFailure) = 4,
}}
DEFINE_IID!(IID_IAudioFileOutputNode, 1356863872, 20838, 16531, 128, 248, 173, 160, 0, 137, 233, 207);
RT_INTERFACE!{interface IAudioFileOutputNode(IAudioFileOutputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFileOutputNode] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_File(&self, out: *mut *mut super::super::storage::IStorageFile) -> HRESULT,
    fn get_FileEncodingProfile(&self, out: *mut *mut super::mediaproperties::MediaEncodingProfile) -> HRESULT,
    fn FinalizeAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::transcoding::TranscodeFailureReason>) -> HRESULT
}}
impl IAudioFileOutputNode {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_file(&self) -> Result<ComPtr<super::super::storage::IStorageFile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_File)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_file_encoding_profile(&self) -> Result<ComPtr<super::mediaproperties::MediaEncodingProfile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FileEncodingProfile)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn finalize_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::transcoding::TranscodeFailureReason>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FinalizeAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioFileOutputNode: IAudioFileOutputNode}
DEFINE_IID!(IID_IAudioFrameCompletedEventArgs, 3699147422, 520, 17668, 165, 168, 240, 242, 104, 146, 10, 101);
RT_INTERFACE!{interface IAudioFrameCompletedEventArgs(IAudioFrameCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFrameCompletedEventArgs] {
    fn get_Frame(&self, out: *mut *mut super::AudioFrame) -> HRESULT
}}
impl IAudioFrameCompletedEventArgs {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<super::AudioFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioFrameCompletedEventArgs: IAudioFrameCompletedEventArgs}
DEFINE_IID!(IID_IAudioFrameInputNode, 28468935, 64918, 20469, 163, 197, 210, 122, 155, 244, 66, 55);
RT_INTERFACE!{interface IAudioFrameInputNode(IAudioFrameInputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFrameInputNode] {
    fn put_PlaybackSpeedFactor(&self, value: f64) -> HRESULT,
    fn get_PlaybackSpeedFactor(&self, out: *mut f64) -> HRESULT,
    fn AddFrame(&self, frame: *mut super::AudioFrame) -> HRESULT,
    fn DiscardQueuedFrames(&self) -> HRESULT,
    fn get_QueuedSampleCount(&self, out: *mut u64) -> HRESULT,
    fn add_AudioFrameCompleted(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioFrameInputNode, AudioFrameCompletedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AudioFrameCompleted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_QuantumStarted(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioFrameInputNode, FrameInputNodeQuantumStartedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_QuantumStarted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAudioFrameInputNode {
    #[inline] pub unsafe fn set_playback_speed_factor(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaybackSpeedFactor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_playback_speed_factor(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PlaybackSpeedFactor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_frame(&self, frame: &super::AudioFrame) -> Result<()> {
        let hr = ((*self.lpVtbl).AddFrame)(self as *const _ as *mut _, frame as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn discard_queued_frames(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DiscardQueuedFrames)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_queued_sample_count(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_QueuedSampleCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_audio_frame_completed(&self, handler: &super::super::foundation::TypedEventHandler<AudioFrameInputNode, AudioFrameCompletedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AudioFrameCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_audio_frame_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AudioFrameCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_quantum_started(&self, handler: &super::super::foundation::TypedEventHandler<AudioFrameInputNode, FrameInputNodeQuantumStartedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_QuantumStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_quantum_started(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_QuantumStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AudioFrameInputNode: IAudioFrameInputNode}
DEFINE_IID!(IID_IAudioFrameOutputNode, 3091674907, 12953, 17909, 136, 179, 201, 209, 42, 63, 28, 200);
RT_INTERFACE!{interface IAudioFrameOutputNode(IAudioFrameOutputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioFrameOutputNode] {
    fn GetFrame(&self, out: *mut *mut super::AudioFrame) -> HRESULT
}}
impl IAudioFrameOutputNode {
    #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<super::AudioFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioFrameOutputNode: IAudioFrameOutputNode}
DEFINE_IID!(IID_IAudioGraph, 450129645, 58508, 19988, 150, 96, 44, 79, 131, 233, 205, 216);
RT_INTERFACE!{interface IAudioGraph(IAudioGraphVtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraph] {
    fn CreateFrameInputNode(&self, out: *mut *mut AudioFrameInputNode) -> HRESULT,
    fn CreateFrameInputNodeWithFormat(&self, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, out: *mut *mut AudioFrameInputNode) -> HRESULT,
    fn CreateDeviceInputNodeAsync(&self, category: super::capture::MediaCategory, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>) -> HRESULT,
    fn CreateDeviceInputNodeWithFormatAsync(&self, category: super::capture::MediaCategory, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-devices")] fn CreateDeviceInputNodeWithFormatOnDeviceAsync(&self, category: super::capture::MediaCategory, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, device: *mut super::super::devices::enumeration::DeviceInformation, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>) -> HRESULT,
    fn CreateFrameOutputNode(&self, out: *mut *mut AudioFrameOutputNode) -> HRESULT,
    fn CreateFrameOutputNodeWithFormat(&self, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, out: *mut *mut AudioFrameOutputNode) -> HRESULT,
    fn CreateDeviceOutputNodeAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioDeviceOutputNodeResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFileInputNodeAsync(&self, file: *mut super::super::storage::IStorageFile, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioFileInputNodeResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFileOutputNodeAsync(&self, file: *mut super::super::storage::IStorageFile, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioFileOutputNodeResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFileOutputNodeWithFileProfileAsync(&self, file: *mut super::super::storage::IStorageFile, fileEncodingProfile: *mut super::mediaproperties::MediaEncodingProfile, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioFileOutputNodeResult>) -> HRESULT,
    fn CreateSubmixNode(&self, out: *mut *mut AudioSubmixNode) -> HRESULT,
    fn CreateSubmixNodeWithFormat(&self, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, out: *mut *mut AudioSubmixNode) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn ResetAllNodes(&self) -> HRESULT,
    fn add_QuantumStarted(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioGraph, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_QuantumStarted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_QuantumProcessed(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioGraph, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_QuantumProcessed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_UnrecoverableErrorOccurred(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioGraph, AudioGraphUnrecoverableErrorOccurredEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UnrecoverableErrorOccurred(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_CompletedQuantumCount(&self, out: *mut u64) -> HRESULT,
    fn get_EncodingProperties(&self, out: *mut *mut super::mediaproperties::AudioEncodingProperties) -> HRESULT,
    fn get_LatencyInSamples(&self, out: *mut i32) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy25(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PrimaryRenderDevice(&self, out: *mut *mut super::super::devices::enumeration::DeviceInformation) -> HRESULT,
    fn get_RenderDeviceAudioProcessing(&self, out: *mut super::AudioProcessing) -> HRESULT,
    fn get_SamplesPerQuantum(&self, out: *mut i32) -> HRESULT
}}
impl IAudioGraph {
    #[inline] pub unsafe fn create_frame_input_node(&self) -> Result<ComPtr<AudioFrameInputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameInputNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_frame_input_node_with_format(&self, encodingProperties: &super::mediaproperties::AudioEncodingProperties) -> Result<ComPtr<AudioFrameInputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameInputNodeWithFormat)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_device_input_node_async(&self, category: super::capture::MediaCategory) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDeviceInputNodeAsync)(self as *const _ as *mut _, category, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_device_input_node_with_format_async(&self, category: super::capture::MediaCategory, encodingProperties: &super::mediaproperties::AudioEncodingProperties) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDeviceInputNodeWithFormatAsync)(self as *const _ as *mut _, category, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create_device_input_node_with_format_on_device_async(&self, category: super::capture::MediaCategory, encodingProperties: &super::mediaproperties::AudioEncodingProperties, device: &super::super::devices::enumeration::DeviceInformation) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDeviceInputNodeWithFormatOnDeviceAsync)(self as *const _ as *mut _, category, encodingProperties as *const _ as *mut _, device as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_frame_output_node(&self) -> Result<ComPtr<AudioFrameOutputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameOutputNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_frame_output_node_with_format(&self, encodingProperties: &super::mediaproperties::AudioEncodingProperties) -> Result<ComPtr<AudioFrameOutputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameOutputNodeWithFormat)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_device_output_node_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioDeviceOutputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDeviceOutputNodeAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_file_input_node_async(&self, file: &super::super::storage::IStorageFile) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioFileInputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFileInputNodeAsync)(self as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_file_output_node_async(&self, file: &super::super::storage::IStorageFile) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioFileOutputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFileOutputNodeAsync)(self as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_file_output_node_with_file_profile_async(&self, file: &super::super::storage::IStorageFile, fileEncodingProfile: &super::mediaproperties::MediaEncodingProfile) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioFileOutputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFileOutputNodeWithFileProfileAsync)(self as *const _ as *mut _, file as *const _ as *mut _, fileEncodingProfile as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_submix_node(&self) -> Result<ComPtr<AudioSubmixNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSubmixNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_submix_node_with_format(&self, encodingProperties: &super::mediaproperties::AudioEncodingProperties) -> Result<ComPtr<AudioSubmixNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSubmixNodeWithFormat)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset_all_nodes(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ResetAllNodes)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_quantum_started(&self, handler: &super::super::foundation::TypedEventHandler<AudioGraph, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_QuantumStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_quantum_started(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_QuantumStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_quantum_processed(&self, handler: &super::super::foundation::TypedEventHandler<AudioGraph, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_QuantumProcessed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_quantum_processed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_QuantumProcessed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_unrecoverable_error_occurred(&self, handler: &super::super::foundation::TypedEventHandler<AudioGraph, AudioGraphUnrecoverableErrorOccurredEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UnrecoverableErrorOccurred)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_unrecoverable_error_occurred(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UnrecoverableErrorOccurred)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_completed_quantum_count(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompletedQuantumCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::AudioEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_latency_in_samples(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LatencyInSamples)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_primary_render_device(&self) -> Result<ComPtr<super::super::devices::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryRenderDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_render_device_audio_processing(&self) -> Result<super::AudioProcessing> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RenderDeviceAudioProcessing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_samples_per_quantum(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SamplesPerQuantum)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioGraph: IAudioGraph}
impl RtActivatable<IAudioGraphStatics> for AudioGraph {}
impl AudioGraph {
    #[inline] pub fn create_async(settings: &AudioGraphSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioGraphResult>>> { unsafe {
        <Self as RtActivatable<IAudioGraphStatics>>::get_activation_factory().create_async(settings)
    }}
}
DEFINE_CLSID!(AudioGraph(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,65,117,100,105,111,71,114,97,112,104,0]) [CLSID_AudioGraph]);
DEFINE_IID!(IID_IAudioGraph2, 1313618901, 20417, 17910, 169, 71, 60, 211, 143, 79, 216, 57);
RT_INTERFACE!{interface IAudioGraph2(IAudioGraph2Vtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraph2] {
    fn CreateFrameInputNodeWithFormatAndEmitter(&self, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, emitter: *mut AudioNodeEmitter, out: *mut *mut AudioFrameInputNode) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-devices")] fn CreateDeviceInputNodeWithFormatAndEmitterOnDeviceAsync(&self, category: super::capture::MediaCategory, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, device: *mut super::super::devices::enumeration::DeviceInformation, emitter: *mut AudioNodeEmitter, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFileInputNodeWithEmitterAsync(&self, file: *mut super::super::storage::IStorageFile, emitter: *mut AudioNodeEmitter, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioFileInputNodeResult>) -> HRESULT,
    fn CreateSubmixNodeWithFormatAndEmitter(&self, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, emitter: *mut AudioNodeEmitter, out: *mut *mut AudioSubmixNode) -> HRESULT,
    fn CreateBatchUpdater(&self, out: *mut *mut AudioGraphBatchUpdater) -> HRESULT
}}
impl IAudioGraph2 {
    #[inline] pub unsafe fn create_frame_input_node_with_format_and_emitter(&self, encodingProperties: &super::mediaproperties::AudioEncodingProperties, emitter: &AudioNodeEmitter) -> Result<ComPtr<AudioFrameInputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFrameInputNodeWithFormatAndEmitter)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, emitter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn create_device_input_node_with_format_and_emitter_on_device_async(&self, category: super::capture::MediaCategory, encodingProperties: &super::mediaproperties::AudioEncodingProperties, device: &super::super::devices::enumeration::DeviceInformation, emitter: &AudioNodeEmitter) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioDeviceInputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDeviceInputNodeWithFormatAndEmitterOnDeviceAsync)(self as *const _ as *mut _, category, encodingProperties as *const _ as *mut _, device as *const _ as *mut _, emitter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_file_input_node_with_emitter_async(&self, file: &super::super::storage::IStorageFile, emitter: &AudioNodeEmitter) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioFileInputNodeResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFileInputNodeWithEmitterAsync)(self as *const _ as *mut _, file as *const _ as *mut _, emitter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_submix_node_with_format_and_emitter(&self, encodingProperties: &super::mediaproperties::AudioEncodingProperties, emitter: &AudioNodeEmitter) -> Result<ComPtr<AudioSubmixNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSubmixNodeWithFormatAndEmitter)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, emitter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_batch_updater(&self) -> Result<ComPtr<AudioGraphBatchUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBatchUpdater)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioGraphBatchUpdater: super::super::foundation::IClosable}
DEFINE_IID!(IID_IAudioGraphConnection, 1982886125, 53326, 20396, 178, 51, 96, 11, 66, 237, 212, 105);
RT_INTERFACE!{interface IAudioGraphConnection(IAudioGraphConnectionVtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraphConnection] {
    fn get_Destination(&self, out: *mut *mut IAudioNode) -> HRESULT,
    fn put_Gain(&self, value: f64) -> HRESULT,
    fn get_Gain(&self, out: *mut f64) -> HRESULT
}}
impl IAudioGraphConnection {
    #[inline] pub unsafe fn get_destination(&self) -> Result<ComPtr<IAudioNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Destination)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Gain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioGraphConnection: IAudioGraphConnection}
RT_ENUM! { enum AudioGraphCreationStatus: i32 {
    Success (AudioGraphCreationStatus_Success) = 0, DeviceNotAvailable (AudioGraphCreationStatus_DeviceNotAvailable) = 1, FormatNotSupported (AudioGraphCreationStatus_FormatNotSupported) = 2, UnknownFailure (AudioGraphCreationStatus_UnknownFailure) = 3,
}}
DEFINE_IID!(IID_IAudioGraphSettings, 492397695, 59134, 17960, 132, 248, 157, 139, 219, 162, 87, 133);
RT_INTERFACE!{interface IAudioGraphSettings(IAudioGraphSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraphSettings] {
    fn get_EncodingProperties(&self, out: *mut *mut super::mediaproperties::AudioEncodingProperties) -> HRESULT,
    fn put_EncodingProperties(&self, value: *mut super::mediaproperties::AudioEncodingProperties) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PrimaryRenderDevice(&self, out: *mut *mut super::super::devices::enumeration::DeviceInformation) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-devices")] fn put_PrimaryRenderDevice(&self, value: *mut super::super::devices::enumeration::DeviceInformation) -> HRESULT,
    fn get_QuantumSizeSelectionMode(&self, out: *mut QuantumSizeSelectionMode) -> HRESULT,
    fn put_QuantumSizeSelectionMode(&self, value: QuantumSizeSelectionMode) -> HRESULT,
    fn get_DesiredSamplesPerQuantum(&self, out: *mut i32) -> HRESULT,
    fn put_DesiredSamplesPerQuantum(&self, value: i32) -> HRESULT,
    fn get_AudioRenderCategory(&self, out: *mut super::render::AudioRenderCategory) -> HRESULT,
    fn put_AudioRenderCategory(&self, value: super::render::AudioRenderCategory) -> HRESULT,
    fn get_DesiredRenderDeviceAudioProcessing(&self, out: *mut super::AudioProcessing) -> HRESULT,
    fn put_DesiredRenderDeviceAudioProcessing(&self, value: super::AudioProcessing) -> HRESULT
}}
impl IAudioGraphSettings {
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::AudioEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_encoding_properties(&self, value: &super::mediaproperties::AudioEncodingProperties) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EncodingProperties)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_primary_render_device(&self) -> Result<ComPtr<super::super::devices::enumeration::DeviceInformation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryRenderDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn set_primary_render_device(&self, value: &super::super::devices::enumeration::DeviceInformation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryRenderDevice)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_quantum_size_selection_mode(&self) -> Result<QuantumSizeSelectionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_QuantumSizeSelectionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_quantum_size_selection_mode(&self, value: QuantumSizeSelectionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_QuantumSizeSelectionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_samples_per_quantum(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredSamplesPerQuantum)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_samples_per_quantum(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredSamplesPerQuantum)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_render_category(&self) -> Result<super::render::AudioRenderCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AudioRenderCategory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_audio_render_category(&self, value: super::render::AudioRenderCategory) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AudioRenderCategory)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_render_device_audio_processing(&self) -> Result<super::AudioProcessing> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredRenderDeviceAudioProcessing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_render_device_audio_processing(&self, value: super::AudioProcessing) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredRenderDeviceAudioProcessing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AudioGraphSettings: IAudioGraphSettings}
impl RtActivatable<IAudioGraphSettingsFactory> for AudioGraphSettings {}
impl AudioGraphSettings {
    #[inline] pub fn create(audioRenderCategory: super::render::AudioRenderCategory) -> Result<ComPtr<AudioGraphSettings>> { unsafe {
        <Self as RtActivatable<IAudioGraphSettingsFactory>>::get_activation_factory().create(audioRenderCategory)
    }}
}
DEFINE_CLSID!(AudioGraphSettings(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,65,117,100,105,111,71,114,97,112,104,83,101,116,116,105,110,103,115,0]) [CLSID_AudioGraphSettings]);
DEFINE_IID!(IID_IAudioGraphSettingsFactory, 2782469318, 49899, 19041, 162, 20, 29, 102, 215, 95, 131, 218);
RT_INTERFACE!{static interface IAudioGraphSettingsFactory(IAudioGraphSettingsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraphSettingsFactory] {
    fn Create(&self, audioRenderCategory: super::render::AudioRenderCategory, out: *mut *mut AudioGraphSettings) -> HRESULT
}}
impl IAudioGraphSettingsFactory {
    #[inline] pub unsafe fn create(&self, audioRenderCategory: super::render::AudioRenderCategory) -> Result<ComPtr<AudioGraphSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, audioRenderCategory, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioGraphStatics, 1995190578, 57689, 19127, 168, 42, 23, 190, 180, 179, 30, 148);
RT_INTERFACE!{static interface IAudioGraphStatics(IAudioGraphStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraphStatics] {
    fn CreateAsync(&self, settings: *mut AudioGraphSettings, out: *mut *mut super::super::foundation::IAsyncOperation<CreateAudioGraphResult>) -> HRESULT
}}
impl IAudioGraphStatics {
    #[inline] pub unsafe fn create_async(&self, settings: &AudioGraphSettings) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CreateAudioGraphResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAsync)(self as *const _ as *mut _, settings as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AudioGraphUnrecoverableError: i32 {
    None (AudioGraphUnrecoverableError_None) = 0, AudioDeviceLost (AudioGraphUnrecoverableError_AudioDeviceLost) = 1, AudioSessionDisconnected (AudioGraphUnrecoverableError_AudioSessionDisconnected) = 2, UnknownFailure (AudioGraphUnrecoverableError_UnknownFailure) = 3,
}}
DEFINE_IID!(IID_IAudioGraphUnrecoverableErrorOccurredEventArgs, 3285830624, 16374, 20403, 178, 98, 80, 212, 53, 197, 84, 35);
RT_INTERFACE!{interface IAudioGraphUnrecoverableErrorOccurredEventArgs(IAudioGraphUnrecoverableErrorOccurredEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioGraphUnrecoverableErrorOccurredEventArgs] {
    fn get_Error(&self, out: *mut AudioGraphUnrecoverableError) -> HRESULT
}}
impl IAudioGraphUnrecoverableErrorOccurredEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<AudioGraphUnrecoverableError> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioGraphUnrecoverableErrorOccurredEventArgs: IAudioGraphUnrecoverableErrorOccurredEventArgs}
DEFINE_IID!(IID_IAudioInputNode, 3511156828, 33832, 18308, 183, 253, 169, 157, 70, 140, 93, 32);
RT_INTERFACE!{interface IAudioInputNode(IAudioInputNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioInputNode] {
    fn get_OutgoingConnections(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AudioGraphConnection>) -> HRESULT,
    fn AddOutgoingConnection(&self, destination: *mut IAudioNode) -> HRESULT,
    fn AddOutgoingConnectionWithGain(&self, destination: *mut IAudioNode, gain: f64) -> HRESULT,
    fn RemoveOutgoingConnection(&self, destination: *mut IAudioNode) -> HRESULT
}}
impl IAudioInputNode {
    #[inline] pub unsafe fn get_outgoing_connections(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AudioGraphConnection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutgoingConnections)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_outgoing_connection(&self, destination: &IAudioNode) -> Result<()> {
        let hr = ((*self.lpVtbl).AddOutgoingConnection)(self as *const _ as *mut _, destination as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_outgoing_connection_with_gain(&self, destination: &IAudioNode, gain: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).AddOutgoingConnectionWithGain)(self as *const _ as *mut _, destination as *const _ as *mut _, gain);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_outgoing_connection(&self, destination: &IAudioNode) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveOutgoingConnection)(self as *const _ as *mut _, destination as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioInputNode2, 2421249719, 51816, 19565, 168, 188, 227, 238, 23, 254, 63, 210);
RT_INTERFACE!{interface IAudioInputNode2(IAudioInputNode2Vtbl): IInspectable(IInspectableVtbl) [IID_IAudioInputNode2] {
    fn get_Emitter(&self, out: *mut *mut AudioNodeEmitter) -> HRESULT
}}
impl IAudioInputNode2 {
    #[inline] pub unsafe fn get_emitter(&self) -> Result<ComPtr<AudioNodeEmitter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Emitter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioNode, 356031871, 56280, 18457, 191, 3, 102, 142, 147, 87, 205, 109);
RT_INTERFACE!{interface IAudioNode(IAudioNodeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNode] {
    fn get_EffectDefinitions(&self, out: *mut *mut super::super::foundation::collections::IVector<super::effects::IAudioEffectDefinition>) -> HRESULT,
    fn put_OutgoingGain(&self, value: f64) -> HRESULT,
    fn get_OutgoingGain(&self, out: *mut f64) -> HRESULT,
    fn get_EncodingProperties(&self, out: *mut *mut super::mediaproperties::AudioEncodingProperties) -> HRESULT,
    fn get_ConsumeInput(&self, out: *mut bool) -> HRESULT,
    fn put_ConsumeInput(&self, value: bool) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT,
    fn Reset(&self) -> HRESULT,
    fn DisableEffectsByDefinition(&self, definition: *mut super::effects::IAudioEffectDefinition) -> HRESULT,
    fn EnableEffectsByDefinition(&self, definition: *mut super::effects::IAudioEffectDefinition) -> HRESULT
}}
impl IAudioNode {
    #[inline] pub unsafe fn get_effect_definitions(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::effects::IAudioEffectDefinition>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EffectDefinitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_outgoing_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutgoingGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outgoing_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OutgoingGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::AudioEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_consume_input(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ConsumeInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_consume_input(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ConsumeInput)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Reset)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn disable_effects_by_definition(&self, definition: &super::effects::IAudioEffectDefinition) -> Result<()> {
        let hr = ((*self.lpVtbl).DisableEffectsByDefinition)(self as *const _ as *mut _, definition as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn enable_effects_by_definition(&self, definition: &super::effects::IAudioEffectDefinition) -> Result<()> {
        let hr = ((*self.lpVtbl).EnableEffectsByDefinition)(self as *const _ as *mut _, definition as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioNodeEmitter, 913741597, 34826, 18360, 173, 247, 19, 35, 169, 217, 101, 190);
RT_INTERFACE!{interface IAudioNodeEmitter(IAudioNodeEmitterVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitter] {
    fn get_Position(&self, out: *mut super::super::foundation::numerics::Vector3) -> HRESULT,
    fn put_Position(&self, value: super::super::foundation::numerics::Vector3) -> HRESULT,
    fn get_Direction(&self, out: *mut super::super::foundation::numerics::Vector3) -> HRESULT,
    fn put_Direction(&self, value: super::super::foundation::numerics::Vector3) -> HRESULT,
    fn get_Shape(&self, out: *mut *mut AudioNodeEmitterShape) -> HRESULT,
    fn get_DecayModel(&self, out: *mut *mut AudioNodeEmitterDecayModel) -> HRESULT,
    fn get_Gain(&self, out: *mut f64) -> HRESULT,
    fn put_Gain(&self, value: f64) -> HRESULT,
    fn get_DistanceScale(&self, out: *mut f64) -> HRESULT,
    fn put_DistanceScale(&self, value: f64) -> HRESULT,
    fn get_DopplerScale(&self, out: *mut f64) -> HRESULT,
    fn put_DopplerScale(&self, value: f64) -> HRESULT,
    fn get_DopplerVelocity(&self, out: *mut super::super::foundation::numerics::Vector3) -> HRESULT,
    fn put_DopplerVelocity(&self, value: super::super::foundation::numerics::Vector3) -> HRESULT,
    fn get_IsDopplerDisabled(&self, out: *mut bool) -> HRESULT
}}
impl IAudioNodeEmitter {
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: super::super::foundation::numerics::Vector3) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_direction(&self) -> Result<super::super::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Direction)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_direction(&self, value: super::super::foundation::numerics::Vector3) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Direction)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_shape(&self) -> Result<ComPtr<AudioNodeEmitterShape>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Shape)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_decay_model(&self) -> Result<ComPtr<AudioNodeEmitterDecayModel>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DecayModel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Gain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_distance_scale(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DistanceScale)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_distance_scale(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DistanceScale)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_doppler_scale(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DopplerScale)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_doppler_scale(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DopplerScale)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_doppler_velocity(&self) -> Result<super::super::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DopplerVelocity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_doppler_velocity(&self, value: super::super::foundation::numerics::Vector3) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DopplerVelocity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_doppler_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDopplerDisabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioNodeEmitter: IAudioNodeEmitter}
impl RtActivatable<IAudioNodeEmitterFactory> for AudioNodeEmitter {}
impl RtActivatable<IActivationFactory> for AudioNodeEmitter {}
impl AudioNodeEmitter {
    #[inline] pub fn create_audio_node_emitter(shape: &AudioNodeEmitterShape, decayModel: &AudioNodeEmitterDecayModel, settings: AudioNodeEmitterSettings) -> Result<ComPtr<AudioNodeEmitter>> { unsafe {
        <Self as RtActivatable<IAudioNodeEmitterFactory>>::get_activation_factory().create_audio_node_emitter(shape, decayModel, settings)
    }}
}
DEFINE_CLSID!(AudioNodeEmitter(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,65,117,100,105,111,78,111,100,101,69,109,105,116,116,101,114,0]) [CLSID_AudioNodeEmitter]);
DEFINE_IID!(IID_IAudioNodeEmitter2, 1253502667, 60457, 18424, 129, 140, 182, 182, 96, 165, 174, 177);
RT_INTERFACE!{interface IAudioNodeEmitter2(IAudioNodeEmitter2Vtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitter2] {
    fn get_SpatialAudioModel(&self, out: *mut SpatialAudioModel) -> HRESULT,
    fn put_SpatialAudioModel(&self, value: SpatialAudioModel) -> HRESULT
}}
impl IAudioNodeEmitter2 {
    #[inline] pub unsafe fn get_spatial_audio_model(&self) -> Result<SpatialAudioModel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpatialAudioModel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_spatial_audio_model(&self, value: SpatialAudioModel) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SpatialAudioModel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioNodeEmitterConeProperties, 3919260910, 714, 17269, 147, 38, 12, 106, 228, 188, 223, 181);
RT_INTERFACE!{interface IAudioNodeEmitterConeProperties(IAudioNodeEmitterConePropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterConeProperties] {
    fn get_InnerAngle(&self, out: *mut f64) -> HRESULT,
    fn get_OuterAngle(&self, out: *mut f64) -> HRESULT,
    fn get_OuterAngleGain(&self, out: *mut f64) -> HRESULT
}}
impl IAudioNodeEmitterConeProperties {
    #[inline] pub unsafe fn get_inner_angle(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InnerAngle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outer_angle(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OuterAngle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outer_angle_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OuterAngleGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioNodeEmitterConeProperties: IAudioNodeEmitterConeProperties}
RT_ENUM! { enum AudioNodeEmitterDecayKind: i32 {
    Natural (AudioNodeEmitterDecayKind_Natural) = 0, Custom (AudioNodeEmitterDecayKind_Custom) = 1,
}}
DEFINE_IID!(IID_IAudioNodeEmitterDecayModel, 488463095, 3411, 20393, 189, 132, 213, 129, 106, 134, 243, 255);
RT_INTERFACE!{interface IAudioNodeEmitterDecayModel(IAudioNodeEmitterDecayModelVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterDecayModel] {
    fn get_Kind(&self, out: *mut AudioNodeEmitterDecayKind) -> HRESULT,
    fn get_MinGain(&self, out: *mut f64) -> HRESULT,
    fn get_MaxGain(&self, out: *mut f64) -> HRESULT,
    fn get_NaturalProperties(&self, out: *mut *mut AudioNodeEmitterNaturalDecayModelProperties) -> HRESULT
}}
impl IAudioNodeEmitterDecayModel {
    #[inline] pub unsafe fn get_kind(&self) -> Result<AudioNodeEmitterDecayKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_natural_properties(&self) -> Result<ComPtr<AudioNodeEmitterNaturalDecayModelProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NaturalProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioNodeEmitterDecayModel: IAudioNodeEmitterDecayModel}
impl RtActivatable<IAudioNodeEmitterDecayModelStatics> for AudioNodeEmitterDecayModel {}
impl AudioNodeEmitterDecayModel {
    #[inline] pub fn create_natural(minGain: f64, maxGain: f64, unityGainDistance: f64, cutoffDistance: f64) -> Result<ComPtr<AudioNodeEmitterDecayModel>> { unsafe {
        <Self as RtActivatable<IAudioNodeEmitterDecayModelStatics>>::get_activation_factory().create_natural(minGain, maxGain, unityGainDistance, cutoffDistance)
    }}
    #[inline] pub fn create_custom(minGain: f64, maxGain: f64) -> Result<ComPtr<AudioNodeEmitterDecayModel>> { unsafe {
        <Self as RtActivatable<IAudioNodeEmitterDecayModelStatics>>::get_activation_factory().create_custom(minGain, maxGain)
    }}
}
DEFINE_CLSID!(AudioNodeEmitterDecayModel(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,65,117,100,105,111,78,111,100,101,69,109,105,116,116,101,114,68,101,99,97,121,77,111,100,101,108,0]) [CLSID_AudioNodeEmitterDecayModel]);
DEFINE_IID!(IID_IAudioNodeEmitterDecayModelStatics, 3346562216, 61816, 17967, 188, 129, 141, 213, 203, 229, 218, 232);
RT_INTERFACE!{static interface IAudioNodeEmitterDecayModelStatics(IAudioNodeEmitterDecayModelStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterDecayModelStatics] {
    fn CreateNatural(&self, minGain: f64, maxGain: f64, unityGainDistance: f64, cutoffDistance: f64, out: *mut *mut AudioNodeEmitterDecayModel) -> HRESULT,
    fn CreateCustom(&self, minGain: f64, maxGain: f64, out: *mut *mut AudioNodeEmitterDecayModel) -> HRESULT
}}
impl IAudioNodeEmitterDecayModelStatics {
    #[inline] pub unsafe fn create_natural(&self, minGain: f64, maxGain: f64, unityGainDistance: f64, cutoffDistance: f64) -> Result<ComPtr<AudioNodeEmitterDecayModel>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateNatural)(self as *const _ as *mut _, minGain, maxGain, unityGainDistance, cutoffDistance, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_custom(&self, minGain: f64, maxGain: f64) -> Result<ComPtr<AudioNodeEmitterDecayModel>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCustom)(self as *const _ as *mut _, minGain, maxGain, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioNodeEmitterFactory, 4257761434, 27350, 19684, 183, 247, 169, 147, 112, 223, 126, 233);
RT_INTERFACE!{static interface IAudioNodeEmitterFactory(IAudioNodeEmitterFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterFactory] {
    fn CreateAudioNodeEmitter(&self, shape: *mut AudioNodeEmitterShape, decayModel: *mut AudioNodeEmitterDecayModel, settings: AudioNodeEmitterSettings, out: *mut *mut AudioNodeEmitter) -> HRESULT
}}
impl IAudioNodeEmitterFactory {
    #[inline] pub unsafe fn create_audio_node_emitter(&self, shape: &AudioNodeEmitterShape, decayModel: &AudioNodeEmitterDecayModel, settings: AudioNodeEmitterSettings) -> Result<ComPtr<AudioNodeEmitter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAudioNodeEmitter)(self as *const _ as *mut _, shape as *const _ as *mut _, decayModel as *const _ as *mut _, settings, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioNodeEmitterNaturalDecayModelProperties, 1217612751, 53036, 20220, 147, 49, 117, 189, 34, 223, 31, 12);
RT_INTERFACE!{interface IAudioNodeEmitterNaturalDecayModelProperties(IAudioNodeEmitterNaturalDecayModelPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterNaturalDecayModelProperties] {
    fn get_UnityGainDistance(&self, out: *mut f64) -> HRESULT,
    fn get_CutoffDistance(&self, out: *mut f64) -> HRESULT
}}
impl IAudioNodeEmitterNaturalDecayModelProperties {
    #[inline] pub unsafe fn get_unity_gain_distance(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UnityGainDistance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cutoff_distance(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CutoffDistance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioNodeEmitterNaturalDecayModelProperties: IAudioNodeEmitterNaturalDecayModelProperties}
RT_ENUM! { enum AudioNodeEmitterSettings: u32 {
    None (AudioNodeEmitterSettings_None) = 0, DisableDoppler (AudioNodeEmitterSettings_DisableDoppler) = 1,
}}
DEFINE_IID!(IID_IAudioNodeEmitterShape, 3926069701, 59197, 17596, 133, 156, 69, 85, 59, 188, 72, 40);
RT_INTERFACE!{interface IAudioNodeEmitterShape(IAudioNodeEmitterShapeVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterShape] {
    fn get_Kind(&self, out: *mut AudioNodeEmitterShapeKind) -> HRESULT,
    fn get_ConeProperties(&self, out: *mut *mut AudioNodeEmitterConeProperties) -> HRESULT
}}
impl IAudioNodeEmitterShape {
    #[inline] pub unsafe fn get_kind(&self) -> Result<AudioNodeEmitterShapeKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cone_properties(&self) -> Result<ComPtr<AudioNodeEmitterConeProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ConeProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioNodeEmitterShape: IAudioNodeEmitterShape}
impl RtActivatable<IAudioNodeEmitterShapeStatics> for AudioNodeEmitterShape {}
impl AudioNodeEmitterShape {
    #[inline] pub fn create_cone(innerAngle: f64, outerAngle: f64, outerAngleGain: f64) -> Result<ComPtr<AudioNodeEmitterShape>> { unsafe {
        <Self as RtActivatable<IAudioNodeEmitterShapeStatics>>::get_activation_factory().create_cone(innerAngle, outerAngle, outerAngleGain)
    }}
    #[inline] pub fn create_omnidirectional() -> Result<ComPtr<AudioNodeEmitterShape>> { unsafe {
        <Self as RtActivatable<IAudioNodeEmitterShapeStatics>>::get_activation_factory().create_omnidirectional()
    }}
}
DEFINE_CLSID!(AudioNodeEmitterShape(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,65,117,100,105,111,78,111,100,101,69,109,105,116,116,101,114,83,104,97,112,101,0]) [CLSID_AudioNodeEmitterShape]);
RT_ENUM! { enum AudioNodeEmitterShapeKind: i32 {
    Omnidirectional (AudioNodeEmitterShapeKind_Omnidirectional) = 0, Cone (AudioNodeEmitterShapeKind_Cone) = 1,
}}
DEFINE_IID!(IID_IAudioNodeEmitterShapeStatics, 1471883121, 65445, 19334, 167, 121, 226, 100, 174, 185, 20, 95);
RT_INTERFACE!{static interface IAudioNodeEmitterShapeStatics(IAudioNodeEmitterShapeStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeEmitterShapeStatics] {
    fn CreateCone(&self, innerAngle: f64, outerAngle: f64, outerAngleGain: f64, out: *mut *mut AudioNodeEmitterShape) -> HRESULT,
    fn CreateOmnidirectional(&self, out: *mut *mut AudioNodeEmitterShape) -> HRESULT
}}
impl IAudioNodeEmitterShapeStatics {
    #[inline] pub unsafe fn create_cone(&self, innerAngle: f64, outerAngle: f64, outerAngleGain: f64) -> Result<ComPtr<AudioNodeEmitterShape>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCone)(self as *const _ as *mut _, innerAngle, outerAngle, outerAngleGain, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_omnidirectional(&self) -> Result<ComPtr<AudioNodeEmitterShape>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateOmnidirectional)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioNodeListener, 3648138774, 3082, 16858, 183, 85, 108, 119, 131, 95, 177, 235);
RT_INTERFACE!{interface IAudioNodeListener(IAudioNodeListenerVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeListener] {
    fn get_Position(&self, out: *mut super::super::foundation::numerics::Vector3) -> HRESULT,
    fn put_Position(&self, value: super::super::foundation::numerics::Vector3) -> HRESULT,
    fn get_Orientation(&self, out: *mut super::super::foundation::numerics::Quaternion) -> HRESULT,
    fn put_Orientation(&self, value: super::super::foundation::numerics::Quaternion) -> HRESULT,
    fn get_SpeedOfSound(&self, out: *mut f64) -> HRESULT,
    fn put_SpeedOfSound(&self, value: f64) -> HRESULT,
    fn get_DopplerVelocity(&self, out: *mut super::super::foundation::numerics::Vector3) -> HRESULT,
    fn put_DopplerVelocity(&self, value: super::super::foundation::numerics::Vector3) -> HRESULT
}}
impl IAudioNodeListener {
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: super::super::foundation::numerics::Vector3) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation(&self) -> Result<super::super::foundation::numerics::Quaternion> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_orientation(&self, value: super::super::foundation::numerics::Quaternion) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Orientation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_speed_of_sound(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpeedOfSound)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_speed_of_sound(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SpeedOfSound)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_doppler_velocity(&self) -> Result<super::super::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DopplerVelocity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_doppler_velocity(&self, value: super::super::foundation::numerics::Vector3) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DopplerVelocity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AudioNodeListener: IAudioNodeListener}
impl RtActivatable<IActivationFactory> for AudioNodeListener {}
DEFINE_CLSID!(AudioNodeListener(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,65,117,100,105,111,78,111,100,101,76,105,115,116,101,110,101,114,0]) [CLSID_AudioNodeListener]);
DEFINE_IID!(IID_IAudioNodeWithListener, 235901052, 31231, 17732, 158, 235, 1, 37, 123, 21, 16, 90);
RT_INTERFACE!{interface IAudioNodeWithListener(IAudioNodeWithListenerVtbl): IInspectable(IInspectableVtbl) [IID_IAudioNodeWithListener] {
    fn put_Listener(&self, value: *mut AudioNodeListener) -> HRESULT,
    fn get_Listener(&self, out: *mut *mut AudioNodeListener) -> HRESULT
}}
impl IAudioNodeWithListener {
    #[inline] pub unsafe fn set_listener(&self, value: &AudioNodeListener) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Listener)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_listener(&self) -> Result<ComPtr<AudioNodeListener>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Listener)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioSubmixNode: IAudioInputNode}
DEFINE_IID!(IID_ICreateAudioDeviceInputNodeResult, 384747432, 7335, 16623, 145, 164, 211, 70, 224, 170, 27, 186);
RT_INTERFACE!{interface ICreateAudioDeviceInputNodeResult(ICreateAudioDeviceInputNodeResultVtbl): IInspectable(IInspectableVtbl) [IID_ICreateAudioDeviceInputNodeResult] {
    fn get_Status(&self, out: *mut AudioDeviceNodeCreationStatus) -> HRESULT,
    fn get_DeviceInputNode(&self, out: *mut *mut AudioDeviceInputNode) -> HRESULT
}}
impl ICreateAudioDeviceInputNodeResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<AudioDeviceNodeCreationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_input_node(&self) -> Result<ComPtr<AudioDeviceInputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceInputNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CreateAudioDeviceInputNodeResult: ICreateAudioDeviceInputNodeResult}
DEFINE_IID!(IID_ICreateAudioDeviceOutputNodeResult, 4151799079, 7578, 18423, 156, 212, 40, 89, 204, 27, 123, 255);
RT_INTERFACE!{interface ICreateAudioDeviceOutputNodeResult(ICreateAudioDeviceOutputNodeResultVtbl): IInspectable(IInspectableVtbl) [IID_ICreateAudioDeviceOutputNodeResult] {
    fn get_Status(&self, out: *mut AudioDeviceNodeCreationStatus) -> HRESULT,
    fn get_DeviceOutputNode(&self, out: *mut *mut AudioDeviceOutputNode) -> HRESULT
}}
impl ICreateAudioDeviceOutputNodeResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<AudioDeviceNodeCreationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_output_node(&self) -> Result<ComPtr<AudioDeviceOutputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceOutputNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CreateAudioDeviceOutputNodeResult: ICreateAudioDeviceOutputNodeResult}
DEFINE_IID!(IID_ICreateAudioFileInputNodeResult, 3464746524, 58007, 19536, 156, 231, 28, 122, 105, 214, 189, 9);
RT_INTERFACE!{interface ICreateAudioFileInputNodeResult(ICreateAudioFileInputNodeResultVtbl): IInspectable(IInspectableVtbl) [IID_ICreateAudioFileInputNodeResult] {
    fn get_Status(&self, out: *mut AudioFileNodeCreationStatus) -> HRESULT,
    fn get_FileInputNode(&self, out: *mut *mut AudioFileInputNode) -> HRESULT
}}
impl ICreateAudioFileInputNodeResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<AudioFileNodeCreationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_file_input_node(&self) -> Result<ComPtr<AudioFileInputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FileInputNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CreateAudioFileInputNodeResult: ICreateAudioFileInputNodeResult}
DEFINE_IID!(IID_ICreateAudioFileOutputNodeResult, 1205254779, 59657, 17727, 134, 110, 85, 64, 205, 167, 52, 255);
RT_INTERFACE!{interface ICreateAudioFileOutputNodeResult(ICreateAudioFileOutputNodeResultVtbl): IInspectable(IInspectableVtbl) [IID_ICreateAudioFileOutputNodeResult] {
    fn get_Status(&self, out: *mut AudioFileNodeCreationStatus) -> HRESULT,
    fn get_FileOutputNode(&self, out: *mut *mut AudioFileOutputNode) -> HRESULT
}}
impl ICreateAudioFileOutputNodeResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<AudioFileNodeCreationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_file_output_node(&self) -> Result<ComPtr<AudioFileOutputNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FileOutputNode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CreateAudioFileOutputNodeResult: ICreateAudioFileOutputNodeResult}
DEFINE_IID!(IID_ICreateAudioGraphResult, 1414786942, 31710, 19318, 187, 93, 72, 247, 156, 252, 140, 11);
RT_INTERFACE!{interface ICreateAudioGraphResult(ICreateAudioGraphResultVtbl): IInspectable(IInspectableVtbl) [IID_ICreateAudioGraphResult] {
    fn get_Status(&self, out: *mut AudioGraphCreationStatus) -> HRESULT,
    fn get_Graph(&self, out: *mut *mut AudioGraph) -> HRESULT
}}
impl ICreateAudioGraphResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<AudioGraphCreationStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_graph(&self) -> Result<ComPtr<AudioGraph>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Graph)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CreateAudioGraphResult: ICreateAudioGraphResult}
DEFINE_IID!(IID_IEchoEffectDefinition, 239943594, 14008, 19601, 185, 218, 17, 244, 74, 138, 102, 16);
RT_INTERFACE!{interface IEchoEffectDefinition(IEchoEffectDefinitionVtbl): IInspectable(IInspectableVtbl) [IID_IEchoEffectDefinition] {
    fn put_WetDryMix(&self, value: f64) -> HRESULT,
    fn get_WetDryMix(&self, out: *mut f64) -> HRESULT,
    fn put_Feedback(&self, value: f64) -> HRESULT,
    fn get_Feedback(&self, out: *mut f64) -> HRESULT,
    fn put_Delay(&self, value: f64) -> HRESULT,
    fn get_Delay(&self, out: *mut f64) -> HRESULT
}}
impl IEchoEffectDefinition {
    #[inline] pub unsafe fn set_wet_dry_mix(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WetDryMix)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wet_dry_mix(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WetDryMix)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_feedback(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Feedback)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_feedback(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Feedback)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_delay(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Delay)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delay(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Delay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class EchoEffectDefinition: IEchoEffectDefinition}
impl RtActivatable<IEchoEffectDefinitionFactory> for EchoEffectDefinition {}
impl EchoEffectDefinition {
    #[inline] pub fn create(audioGraph: &AudioGraph) -> Result<ComPtr<EchoEffectDefinition>> { unsafe {
        <Self as RtActivatable<IEchoEffectDefinitionFactory>>::get_activation_factory().create(audioGraph)
    }}
}
DEFINE_CLSID!(EchoEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,69,99,104,111,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_EchoEffectDefinition]);
DEFINE_IID!(IID_IEchoEffectDefinitionFactory, 223224407, 43762, 20102, 165, 76, 251, 121, 219, 143, 108, 18);
RT_INTERFACE!{static interface IEchoEffectDefinitionFactory(IEchoEffectDefinitionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IEchoEffectDefinitionFactory] {
    fn Create(&self, audioGraph: *mut AudioGraph, out: *mut *mut EchoEffectDefinition) -> HRESULT
}}
impl IEchoEffectDefinitionFactory {
    #[inline] pub unsafe fn create(&self, audioGraph: &AudioGraph) -> Result<ComPtr<EchoEffectDefinition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, audioGraph as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IEqualizerBand, 3221903978, 9773, 19333, 155, 183, 67, 40, 11, 98, 237, 12);
RT_INTERFACE!{interface IEqualizerBand(IEqualizerBandVtbl): IInspectable(IInspectableVtbl) [IID_IEqualizerBand] {
    fn get_Bandwidth(&self, out: *mut f64) -> HRESULT,
    fn put_Bandwidth(&self, value: f64) -> HRESULT,
    fn get_FrequencyCenter(&self, out: *mut f64) -> HRESULT,
    fn put_FrequencyCenter(&self, value: f64) -> HRESULT,
    fn get_Gain(&self, out: *mut f64) -> HRESULT,
    fn put_Gain(&self, value: f64) -> HRESULT
}}
impl IEqualizerBand {
    #[inline] pub unsafe fn get_bandwidth(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bandwidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bandwidth(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Bandwidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frequency_center(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FrequencyCenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_frequency_center(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FrequencyCenter)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Gain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class EqualizerBand: IEqualizerBand}
DEFINE_IID!(IID_IEqualizerEffectDefinition, 37711647, 33790, 17562, 168, 34, 198, 150, 68, 45, 22, 176);
RT_INTERFACE!{interface IEqualizerEffectDefinition(IEqualizerEffectDefinitionVtbl): IInspectable(IInspectableVtbl) [IID_IEqualizerEffectDefinition] {
    fn get_Bands(&self, out: *mut *mut super::super::foundation::collections::IVectorView<EqualizerBand>) -> HRESULT
}}
impl IEqualizerEffectDefinition {
    #[inline] pub unsafe fn get_bands(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<EqualizerBand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Bands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class EqualizerEffectDefinition: IEqualizerEffectDefinition}
impl RtActivatable<IEqualizerEffectDefinitionFactory> for EqualizerEffectDefinition {}
impl EqualizerEffectDefinition {
    #[inline] pub fn create(audioGraph: &AudioGraph) -> Result<ComPtr<EqualizerEffectDefinition>> { unsafe {
        <Self as RtActivatable<IEqualizerEffectDefinitionFactory>>::get_activation_factory().create(audioGraph)
    }}
}
DEFINE_CLSID!(EqualizerEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,69,113,117,97,108,105,122,101,114,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_EqualizerEffectDefinition]);
DEFINE_IID!(IID_IEqualizerEffectDefinitionFactory, 3532091332, 54288, 20149, 158, 105, 201, 170, 18, 119, 234, 240);
RT_INTERFACE!{static interface IEqualizerEffectDefinitionFactory(IEqualizerEffectDefinitionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IEqualizerEffectDefinitionFactory] {
    fn Create(&self, audioGraph: *mut AudioGraph, out: *mut *mut EqualizerEffectDefinition) -> HRESULT
}}
impl IEqualizerEffectDefinitionFactory {
    #[inline] pub unsafe fn create(&self, audioGraph: &AudioGraph) -> Result<ComPtr<EqualizerEffectDefinition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, audioGraph as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameInputNodeQuantumStartedEventArgs, 1033622680, 41734, 20230, 189, 159, 233, 239, 200, 34, 99, 4);
RT_INTERFACE!{interface IFrameInputNodeQuantumStartedEventArgs(IFrameInputNodeQuantumStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFrameInputNodeQuantumStartedEventArgs] {
    fn get_RequiredSamples(&self, out: *mut i32) -> HRESULT
}}
impl IFrameInputNodeQuantumStartedEventArgs {
    #[inline] pub unsafe fn get_required_samples(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequiredSamples)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class FrameInputNodeQuantumStartedEventArgs: IFrameInputNodeQuantumStartedEventArgs}
DEFINE_IID!(IID_ILimiterEffectDefinition, 1802853657, 9731, 18362, 189, 235, 57, 5, 94, 52, 134, 220);
RT_INTERFACE!{interface ILimiterEffectDefinition(ILimiterEffectDefinitionVtbl): IInspectable(IInspectableVtbl) [IID_ILimiterEffectDefinition] {
    fn put_Release(&self, value: u32) -> HRESULT,
    fn get_Release(&self, out: *mut u32) -> HRESULT,
    fn put_Loudness(&self, value: u32) -> HRESULT,
    fn get_Loudness(&self, out: *mut u32) -> HRESULT
}}
impl ILimiterEffectDefinition {
    #[inline] pub unsafe fn set_release(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Release)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_release(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Release)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_loudness(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Loudness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_loudness(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Loudness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class LimiterEffectDefinition: ILimiterEffectDefinition}
impl RtActivatable<ILimiterEffectDefinitionFactory> for LimiterEffectDefinition {}
impl LimiterEffectDefinition {
    #[inline] pub fn create(audioGraph: &AudioGraph) -> Result<ComPtr<LimiterEffectDefinition>> { unsafe {
        <Self as RtActivatable<ILimiterEffectDefinitionFactory>>::get_activation_factory().create(audioGraph)
    }}
}
DEFINE_CLSID!(LimiterEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,76,105,109,105,116,101,114,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_LimiterEffectDefinition]);
DEFINE_IID!(IID_ILimiterEffectDefinitionFactory, 3971671793, 25087, 17903, 184, 245, 72, 101, 154, 87, 199, 45);
RT_INTERFACE!{static interface ILimiterEffectDefinitionFactory(ILimiterEffectDefinitionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ILimiterEffectDefinitionFactory] {
    fn Create(&self, audioGraph: *mut AudioGraph, out: *mut *mut LimiterEffectDefinition) -> HRESULT
}}
impl ILimiterEffectDefinitionFactory {
    #[inline] pub unsafe fn create(&self, audioGraph: &AudioGraph) -> Result<ComPtr<LimiterEffectDefinition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, audioGraph as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum QuantumSizeSelectionMode: i32 {
    SystemDefault (QuantumSizeSelectionMode_SystemDefault) = 0, LowestLatency (QuantumSizeSelectionMode_LowestLatency) = 1, ClosestToDesired (QuantumSizeSelectionMode_ClosestToDesired) = 2,
}}
DEFINE_IID!(IID_IReverbEffectDefinition, 1174841993, 62819, 19722, 143, 110, 240, 205, 223, 243, 93, 132);
RT_INTERFACE!{interface IReverbEffectDefinition(IReverbEffectDefinitionVtbl): IInspectable(IInspectableVtbl) [IID_IReverbEffectDefinition] {
    fn put_WetDryMix(&self, value: f64) -> HRESULT,
    fn get_WetDryMix(&self, out: *mut f64) -> HRESULT,
    fn put_ReflectionsDelay(&self, value: u32) -> HRESULT,
    fn get_ReflectionsDelay(&self, out: *mut u32) -> HRESULT,
    fn put_ReverbDelay(&self, value: u8) -> HRESULT,
    fn get_ReverbDelay(&self, out: *mut u8) -> HRESULT,
    fn put_RearDelay(&self, value: u8) -> HRESULT,
    fn get_RearDelay(&self, out: *mut u8) -> HRESULT,
    fn put_PositionLeft(&self, value: u8) -> HRESULT,
    fn get_PositionLeft(&self, out: *mut u8) -> HRESULT,
    fn put_PositionRight(&self, value: u8) -> HRESULT,
    fn get_PositionRight(&self, out: *mut u8) -> HRESULT,
    fn put_PositionMatrixLeft(&self, value: u8) -> HRESULT,
    fn get_PositionMatrixLeft(&self, out: *mut u8) -> HRESULT,
    fn put_PositionMatrixRight(&self, value: u8) -> HRESULT,
    fn get_PositionMatrixRight(&self, out: *mut u8) -> HRESULT,
    fn put_EarlyDiffusion(&self, value: u8) -> HRESULT,
    fn get_EarlyDiffusion(&self, out: *mut u8) -> HRESULT,
    fn put_LateDiffusion(&self, value: u8) -> HRESULT,
    fn get_LateDiffusion(&self, out: *mut u8) -> HRESULT,
    fn put_LowEQGain(&self, value: u8) -> HRESULT,
    fn get_LowEQGain(&self, out: *mut u8) -> HRESULT,
    fn put_LowEQCutoff(&self, value: u8) -> HRESULT,
    fn get_LowEQCutoff(&self, out: *mut u8) -> HRESULT,
    fn put_HighEQGain(&self, value: u8) -> HRESULT,
    fn get_HighEQGain(&self, out: *mut u8) -> HRESULT,
    fn put_HighEQCutoff(&self, value: u8) -> HRESULT,
    fn get_HighEQCutoff(&self, out: *mut u8) -> HRESULT,
    fn put_RoomFilterFreq(&self, value: f64) -> HRESULT,
    fn get_RoomFilterFreq(&self, out: *mut f64) -> HRESULT,
    fn put_RoomFilterMain(&self, value: f64) -> HRESULT,
    fn get_RoomFilterMain(&self, out: *mut f64) -> HRESULT,
    fn put_RoomFilterHF(&self, value: f64) -> HRESULT,
    fn get_RoomFilterHF(&self, out: *mut f64) -> HRESULT,
    fn put_ReflectionsGain(&self, value: f64) -> HRESULT,
    fn get_ReflectionsGain(&self, out: *mut f64) -> HRESULT,
    fn put_ReverbGain(&self, value: f64) -> HRESULT,
    fn get_ReverbGain(&self, out: *mut f64) -> HRESULT,
    fn put_DecayTime(&self, value: f64) -> HRESULT,
    fn get_DecayTime(&self, out: *mut f64) -> HRESULT,
    fn put_Density(&self, value: f64) -> HRESULT,
    fn get_Density(&self, out: *mut f64) -> HRESULT,
    fn put_RoomSize(&self, value: f64) -> HRESULT,
    fn get_RoomSize(&self, out: *mut f64) -> HRESULT,
    fn put_DisableLateField(&self, value: bool) -> HRESULT,
    fn get_DisableLateField(&self, out: *mut bool) -> HRESULT
}}
impl IReverbEffectDefinition {
    #[inline] pub unsafe fn set_wet_dry_mix(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WetDryMix)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wet_dry_mix(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WetDryMix)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reflections_delay(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReflectionsDelay)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reflections_delay(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReflectionsDelay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reverb_delay(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReverbDelay)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reverb_delay(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReverbDelay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_rear_delay(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RearDelay)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rear_delay(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RearDelay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position_left(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PositionLeft)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position_left(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position_right(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PositionRight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position_right(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionRight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position_matrix_left(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PositionMatrixLeft)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position_matrix_left(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionMatrixLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position_matrix_right(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PositionMatrixRight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position_matrix_right(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionMatrixRight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_early_diffusion(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EarlyDiffusion)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_early_diffusion(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EarlyDiffusion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_late_diffusion(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LateDiffusion)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_late_diffusion(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LateDiffusion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_low_eqgain(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LowEQGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_low_eqgain(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LowEQGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_low_eqcutoff(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LowEQCutoff)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_low_eqcutoff(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LowEQCutoff)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_high_eqgain(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HighEQGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_high_eqgain(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HighEQGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_high_eqcutoff(&self, value: u8) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HighEQCutoff)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_high_eqcutoff(&self) -> Result<u8> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HighEQCutoff)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_room_filter_freq(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoomFilterFreq)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_room_filter_freq(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RoomFilterFreq)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_room_filter_main(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoomFilterMain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_room_filter_main(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RoomFilterMain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_room_filter_hf(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoomFilterHF)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_room_filter_hf(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RoomFilterHF)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reflections_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReflectionsGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reflections_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReflectionsGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reverb_gain(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ReverbGain)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reverb_gain(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReverbGain)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_decay_time(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DecayTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_decay_time(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DecayTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_density(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Density)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_density(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Density)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_room_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoomSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_room_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RoomSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_disable_late_field(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisableLateField)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_disable_late_field(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisableLateField)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ReverbEffectDefinition: IReverbEffectDefinition}
impl RtActivatable<IReverbEffectDefinitionFactory> for ReverbEffectDefinition {}
impl ReverbEffectDefinition {
    #[inline] pub fn create(audioGraph: &AudioGraph) -> Result<ComPtr<ReverbEffectDefinition>> { unsafe {
        <Self as RtActivatable<IReverbEffectDefinitionFactory>>::get_activation_factory().create(audioGraph)
    }}
}
DEFINE_CLSID!(ReverbEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,65,117,100,105,111,46,82,101,118,101,114,98,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_ReverbEffectDefinition]);
DEFINE_IID!(IID_IReverbEffectDefinitionFactory, 2815806462, 4107, 20464, 157, 166, 220, 78, 5, 167, 89, 240);
RT_INTERFACE!{static interface IReverbEffectDefinitionFactory(IReverbEffectDefinitionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IReverbEffectDefinitionFactory] {
    fn Create(&self, audioGraph: *mut AudioGraph, out: *mut *mut ReverbEffectDefinition) -> HRESULT
}}
impl IReverbEffectDefinitionFactory {
    #[inline] pub unsafe fn create(&self, audioGraph: &AudioGraph) -> Result<ComPtr<ReverbEffectDefinition>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, audioGraph as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SpatialAudioModel: i32 {
    ObjectBased (SpatialAudioModel_ObjectBased) = 0, FoldDown (SpatialAudioModel_FoldDown) = 1,
}}
} // Windows.Media.Audio
pub mod casting { // Windows.Media.Casting
use ::prelude::*;
DEFINE_IID!(IID_ICastingConnection, 3449099859, 49905, 17560, 139, 120, 95, 180, 205, 54, 64, 221);
RT_INTERFACE!{interface ICastingConnection(ICastingConnectionVtbl): IInspectable(IInspectableVtbl) [IID_ICastingConnection] {
    fn get_State(&self, out: *mut CastingConnectionState) -> HRESULT,
    fn get_Device(&self, out: *mut *mut CastingDevice) -> HRESULT,
    fn get_Source(&self, out: *mut *mut CastingSource) -> HRESULT,
    fn put_Source(&self, value: *mut CastingSource) -> HRESULT,
    fn add_StateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<CastingConnection, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ErrorOccurred(&self, handler: *mut super::super::foundation::TypedEventHandler<CastingConnection, CastingConnectionErrorOccurredEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ErrorOccurred(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn RequestStartCastingAsync(&self, value: *mut CastingSource, out: *mut *mut super::super::foundation::IAsyncOperation<CastingConnectionErrorStatus>) -> HRESULT,
    fn DisconnectAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<CastingConnectionErrorStatus>) -> HRESULT
}}
impl ICastingConnection {
    #[inline] pub unsafe fn get_state(&self) -> Result<CastingConnectionState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device(&self) -> Result<ComPtr<CastingDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Device)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<CastingSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source(&self, value: &CastingSource) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Source)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<CastingConnection, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_error_occurred(&self, handler: &super::super::foundation::TypedEventHandler<CastingConnection, CastingConnectionErrorOccurredEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ErrorOccurred)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_error_occurred(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ErrorOccurred)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_start_casting_async(&self, value: &CastingSource) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CastingConnectionErrorStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStartCastingAsync)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn disconnect_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CastingConnectionErrorStatus>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DisconnectAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CastingConnection: ICastingConnection}
DEFINE_IID!(IID_ICastingConnectionErrorOccurredEventArgs, 2818260073, 34585, 20224, 129, 251, 150, 24, 99, 199, 154, 50);
RT_INTERFACE!{interface ICastingConnectionErrorOccurredEventArgs(ICastingConnectionErrorOccurredEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICastingConnectionErrorOccurredEventArgs] {
    fn get_ErrorStatus(&self, out: *mut CastingConnectionErrorStatus) -> HRESULT,
    fn get_Message(&self, out: *mut HSTRING) -> HRESULT
}}
impl ICastingConnectionErrorOccurredEventArgs {
    #[inline] pub unsafe fn get_error_status(&self) -> Result<CastingConnectionErrorStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CastingConnectionErrorOccurredEventArgs: ICastingConnectionErrorOccurredEventArgs}
RT_ENUM! { enum CastingConnectionErrorStatus: i32 {
    Succeeded (CastingConnectionErrorStatus_Succeeded) = 0, DeviceDidNotRespond (CastingConnectionErrorStatus_DeviceDidNotRespond) = 1, DeviceError (CastingConnectionErrorStatus_DeviceError) = 2, DeviceLocked (CastingConnectionErrorStatus_DeviceLocked) = 3, ProtectedPlaybackFailed (CastingConnectionErrorStatus_ProtectedPlaybackFailed) = 4, InvalidCastingSource (CastingConnectionErrorStatus_InvalidCastingSource) = 5, Unknown (CastingConnectionErrorStatus_Unknown) = 6,
}}
RT_ENUM! { enum CastingConnectionState: i32 {
    Disconnected (CastingConnectionState_Disconnected) = 0, Connected (CastingConnectionState_Connected) = 1, Rendering (CastingConnectionState_Rendering) = 2, Disconnecting (CastingConnectionState_Disconnecting) = 3, Connecting (CastingConnectionState_Connecting) = 4,
}}
DEFINE_IID!(IID_ICastingDevice, 3732020355, 19011, 19153, 166, 210, 36, 146, 167, 150, 195, 242);
RT_INTERFACE!{interface ICastingDevice(ICastingDeviceVtbl): IInspectable(IInspectableVtbl) [IID_ICastingDevice] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_FriendlyName(&self, out: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Icon(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamWithContentType) -> HRESULT,
    fn GetSupportedCastingPlaybackTypesAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<CastingPlaybackTypes>) -> HRESULT,
    fn CreateCastingConnection(&self, out: *mut *mut CastingConnection) -> HRESULT
}}
impl ICastingDevice {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_friendly_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FriendlyName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_icon(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamWithContentType>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Icon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_casting_playback_types_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CastingPlaybackTypes>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSupportedCastingPlaybackTypesAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_casting_connection(&self) -> Result<ComPtr<CastingConnection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCastingConnection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CastingDevice: ICastingDevice}
impl RtActivatable<ICastingDeviceStatics> for CastingDevice {}
impl CastingDevice {
    #[inline] pub fn get_device_selector(type_: CastingPlaybackTypes) -> Result<HString> { unsafe {
        <Self as RtActivatable<ICastingDeviceStatics>>::get_activation_factory().get_device_selector(type_)
    }}
    #[inline] pub fn get_device_selector_from_casting_source_async(castingSource: &CastingSource) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> { unsafe {
        <Self as RtActivatable<ICastingDeviceStatics>>::get_activation_factory().get_device_selector_from_casting_source_async(castingSource)
    }}
    #[inline] pub fn from_id_async(value: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CastingDevice>>> { unsafe {
        <Self as RtActivatable<ICastingDeviceStatics>>::get_activation_factory().from_id_async(value)
    }}
    #[cfg(feature="windows-devices")] #[inline] pub fn device_info_supports_casting_async(device: &super::super::devices::enumeration::DeviceInformation) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<ICastingDeviceStatics>>::get_activation_factory().device_info_supports_casting_async(device)
    }}
}
DEFINE_CLSID!(CastingDevice(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,115,116,105,110,103,46,67,97,115,116,105,110,103,68,101,118,105,99,101,0]) [CLSID_CastingDevice]);
DEFINE_IID!(IID_ICastingDevicePicker, 3704854820, 1425, 18878, 170, 203, 75, 130, 238, 117, 106, 149);
RT_INTERFACE!{interface ICastingDevicePicker(ICastingDevicePickerVtbl): IInspectable(IInspectableVtbl) [IID_ICastingDevicePicker] {
    fn get_Filter(&self, out: *mut *mut CastingDevicePickerFilter) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_Appearance(&self, out: *mut *mut super::super::devices::enumeration::DevicePickerAppearance) -> HRESULT,
    fn add_CastingDeviceSelected(&self, handler: *mut super::super::foundation::TypedEventHandler<CastingDevicePicker, CastingDeviceSelectedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CastingDeviceSelected(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CastingDevicePickerDismissed(&self, handler: *mut super::super::foundation::TypedEventHandler<CastingDevicePicker, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CastingDevicePickerDismissed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Show(&self, selection: super::super::foundation::Rect) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-ui")] fn ShowWithPlacement(&self, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> HRESULT,
    fn Hide(&self) -> HRESULT
}}
impl ICastingDevicePicker {
    #[inline] pub unsafe fn get_filter(&self) -> Result<ComPtr<CastingDevicePickerFilter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Filter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_appearance(&self) -> Result<ComPtr<super::super::devices::enumeration::DevicePickerAppearance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Appearance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_casting_device_selected(&self, handler: &super::super::foundation::TypedEventHandler<CastingDevicePicker, CastingDeviceSelectedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CastingDeviceSelected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_casting_device_selected(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CastingDeviceSelected)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_casting_device_picker_dismissed(&self, handler: &super::super::foundation::TypedEventHandler<CastingDevicePicker, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CastingDevicePickerDismissed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_casting_device_picker_dismissed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CastingDevicePickerDismissed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show(&self, selection: super::super::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).Show)(self as *const _ as *mut _, selection);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn show_with_placement(&self, selection: super::super::foundation::Rect, preferredPlacement: super::super::ui::popups::Placement) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowWithPlacement)(self as *const _ as *mut _, selection, preferredPlacement);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn hide(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Hide)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CastingDevicePicker: ICastingDevicePicker}
impl RtActivatable<IActivationFactory> for CastingDevicePicker {}
DEFINE_CLSID!(CastingDevicePicker(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,97,115,116,105,110,103,46,67,97,115,116,105,110,103,68,101,118,105,99,101,80,105,99,107,101,114,0]) [CLSID_CastingDevicePicker]);
DEFINE_IID!(IID_ICastingDevicePickerFilter, 3196871068, 46435, 17236, 174, 51, 159, 218, 173, 140, 98, 145);
RT_INTERFACE!{interface ICastingDevicePickerFilter(ICastingDevicePickerFilterVtbl): IInspectable(IInspectableVtbl) [IID_ICastingDevicePickerFilter] {
    fn get_SupportsAudio(&self, out: *mut bool) -> HRESULT,
    fn put_SupportsAudio(&self, value: bool) -> HRESULT,
    fn get_SupportsVideo(&self, out: *mut bool) -> HRESULT,
    fn put_SupportsVideo(&self, value: bool) -> HRESULT,
    fn get_SupportsPictures(&self, out: *mut bool) -> HRESULT,
    fn put_SupportsPictures(&self, value: bool) -> HRESULT,
    fn get_SupportedCastingSources(&self, out: *mut *mut super::super::foundation::collections::IVector<CastingSource>) -> HRESULT
}}
impl ICastingDevicePickerFilter {
    #[inline] pub unsafe fn get_supports_audio(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportsAudio)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_supports_audio(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SupportsAudio)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supports_video(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportsVideo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_supports_video(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SupportsVideo)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supports_pictures(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SupportsPictures)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_supports_pictures(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SupportsPictures)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_casting_sources(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<CastingSource>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedCastingSources)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CastingDevicePickerFilter: ICastingDevicePickerFilter}
DEFINE_IID!(IID_ICastingDeviceSelectedEventArgs, 3695419014, 56663, 19725, 148, 0, 175, 69, 228, 251, 54, 99);
RT_INTERFACE!{interface ICastingDeviceSelectedEventArgs(ICastingDeviceSelectedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICastingDeviceSelectedEventArgs] {
    fn get_SelectedCastingDevice(&self, out: *mut *mut CastingDevice) -> HRESULT
}}
impl ICastingDeviceSelectedEventArgs {
    #[inline] pub unsafe fn get_selected_casting_device(&self) -> Result<ComPtr<CastingDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedCastingDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CastingDeviceSelectedEventArgs: ICastingDeviceSelectedEventArgs}
DEFINE_IID!(IID_ICastingDeviceStatics, 3889780951, 19731, 16951, 163, 101, 76, 79, 106, 76, 253, 47);
RT_INTERFACE!{static interface ICastingDeviceStatics(ICastingDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICastingDeviceStatics] {
    fn GetDeviceSelector(&self, type_: CastingPlaybackTypes, out: *mut HSTRING) -> HRESULT,
    fn GetDeviceSelectorFromCastingSourceAsync(&self, castingSource: *mut CastingSource, out: *mut *mut super::super::foundation::IAsyncOperation<HString>) -> HRESULT,
    fn FromIdAsync(&self, value: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<CastingDevice>) -> HRESULT,
    #[cfg(feature="windows-devices")] fn DeviceInfoSupportsCastingAsync(&self, device: *mut super::super::devices::enumeration::DeviceInformation, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ICastingDeviceStatics {
    #[inline] pub unsafe fn get_device_selector(&self, type_: CastingPlaybackTypes) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, type_, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector_from_casting_source_async(&self, castingSource: &CastingSource) -> Result<ComPtr<super::super::foundation::IAsyncOperation<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelectorFromCastingSourceAsync)(self as *const _ as *mut _, castingSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id_async(&self, value: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<CastingDevice>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromIdAsync)(self as *const _ as *mut _, value.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn device_info_supports_casting_async(&self, device: &super::super::devices::enumeration::DeviceInformation) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).DeviceInfoSupportsCastingAsync)(self as *const _ as *mut _, device as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CastingPlaybackTypes: u32 {
    None (CastingPlaybackTypes_None) = 0, Audio (CastingPlaybackTypes_Audio) = 1, Video (CastingPlaybackTypes_Video) = 2, Picture (CastingPlaybackTypes_Picture) = 4,
}}
DEFINE_IID!(IID_ICastingSource, 4096387698, 13415, 18406, 160, 39, 82, 41, 35, 233, 215, 39);
RT_INTERFACE!{interface ICastingSource(ICastingSourceVtbl): IInspectable(IInspectableVtbl) [IID_ICastingSource] {
    fn get_PreferredSourceUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_PreferredSourceUri(&self, value: *mut super::super::foundation::Uri) -> HRESULT
}}
impl ICastingSource {
    #[inline] pub unsafe fn get_preferred_source_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreferredSourceUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preferred_source_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PreferredSourceUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CastingSource: ICastingSource}
} // Windows.Media.Casting
pub mod core { // Windows.Media.Core
use ::prelude::*;
RT_ENUM! { enum AudioDecoderDegradation: i32 {
    None (AudioDecoderDegradation_None) = 0, DownmixTo2Channels (AudioDecoderDegradation_DownmixTo2Channels) = 1, DownmixTo6Channels (AudioDecoderDegradation_DownmixTo6Channels) = 2, DownmixTo8Channels (AudioDecoderDegradation_DownmixTo8Channels) = 3,
}}
RT_ENUM! { enum AudioDecoderDegradationReason: i32 {
    None (AudioDecoderDegradationReason_None) = 0, LicensingRequirement (AudioDecoderDegradationReason_LicensingRequirement) = 1, SpatialAudioNotSupported (AudioDecoderDegradationReason_SpatialAudioNotSupported) = 2,
}}
DEFINE_IID!(IID_IAudioStreamDescriptor, 506893028, 16423, 18503, 167, 11, 223, 29, 154, 42, 123, 4);
RT_INTERFACE!{interface IAudioStreamDescriptor(IAudioStreamDescriptorVtbl): IInspectable(IInspectableVtbl) [IID_IAudioStreamDescriptor] {
    fn get_EncodingProperties(&self, out: *mut *mut super::mediaproperties::AudioEncodingProperties) -> HRESULT
}}
impl IAudioStreamDescriptor {
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::AudioEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioStreamDescriptor: IAudioStreamDescriptor}
impl RtActivatable<IAudioStreamDescriptorFactory> for AudioStreamDescriptor {}
impl AudioStreamDescriptor {
    #[inline] pub fn create(encodingProperties: &super::mediaproperties::AudioEncodingProperties) -> Result<ComPtr<AudioStreamDescriptor>> { unsafe {
        <Self as RtActivatable<IAudioStreamDescriptorFactory>>::get_activation_factory().create(encodingProperties)
    }}
}
DEFINE_CLSID!(AudioStreamDescriptor(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,65,117,100,105,111,83,116,114,101,97,109,68,101,115,99,114,105,112,116,111,114,0]) [CLSID_AudioStreamDescriptor]);
DEFINE_IID!(IID_IAudioStreamDescriptor2, 778629622, 42056, 18811, 136, 64, 133, 8, 38, 101, 172, 249);
RT_INTERFACE!{interface IAudioStreamDescriptor2(IAudioStreamDescriptor2Vtbl): IInspectable(IInspectableVtbl) [IID_IAudioStreamDescriptor2] {
    fn put_LeadingEncoderPadding(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_LeadingEncoderPadding(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_TrailingEncoderPadding(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_TrailingEncoderPadding(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT
}}
impl IAudioStreamDescriptor2 {
    #[inline] pub unsafe fn set_leading_encoder_padding(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LeadingEncoderPadding)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_leading_encoder_padding(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LeadingEncoderPadding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_trailing_encoder_padding(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TrailingEncoderPadding)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_trailing_encoder_padding(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TrailingEncoderPadding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioStreamDescriptorFactory, 1250348702, 19633, 17280, 142, 12, 131, 80, 75, 127, 91, 243);
RT_INTERFACE!{static interface IAudioStreamDescriptorFactory(IAudioStreamDescriptorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAudioStreamDescriptorFactory] {
    fn Create(&self, encodingProperties: *mut super::mediaproperties::AudioEncodingProperties, out: *mut *mut AudioStreamDescriptor) -> HRESULT
}}
impl IAudioStreamDescriptorFactory {
    #[inline] pub unsafe fn create(&self, encodingProperties: &super::mediaproperties::AudioEncodingProperties) -> Result<ComPtr<AudioStreamDescriptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioTrack, 4063981175, 16119, 16606, 185, 67, 6, 139, 19, 33, 112, 29);
RT_INTERFACE!{interface IAudioTrack(IAudioTrackVtbl): IInspectable(IInspectableVtbl) [IID_IAudioTrack] {
    fn add_OpenFailed(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioTrack, AudioTrackOpenFailedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_OpenFailed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn GetEncodingProperties(&self, out: *mut *mut super::mediaproperties::AudioEncodingProperties) -> HRESULT,
    fn get_PlaybackItem(&self, out: *mut *mut super::playback::MediaPlaybackItem) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SupportInfo(&self, out: *mut *mut AudioTrackSupportInfo) -> HRESULT
}}
impl IAudioTrack {
    #[inline] pub unsafe fn add_open_failed(&self, handler: &super::super::foundation::TypedEventHandler<AudioTrack, AudioTrackOpenFailedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_OpenFailed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_open_failed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_OpenFailed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::AudioEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_playback_item(&self) -> Result<ComPtr<super::playback::MediaPlaybackItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaybackItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_support_info(&self) -> Result<ComPtr<AudioTrackSupportInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioTrack: IMediaTrack}
DEFINE_IID!(IID_IAudioTrackOpenFailedEventArgs, 4007508409, 47996, 16658, 191, 118, 147, 132, 103, 111, 130, 75);
RT_INTERFACE!{interface IAudioTrackOpenFailedEventArgs(IAudioTrackOpenFailedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioTrackOpenFailedEventArgs] {
    fn get_ExtendedError(&self, out: *mut super::super::foundation::HResult) -> HRESULT
}}
impl IAudioTrackOpenFailedEventArgs {
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioTrackOpenFailedEventArgs: IAudioTrackOpenFailedEventArgs}
DEFINE_IID!(IID_IAudioTrackSupportInfo, 395046903, 52281, 17574, 185, 81, 74, 86, 83, 240, 115, 250);
RT_INTERFACE!{interface IAudioTrackSupportInfo(IAudioTrackSupportInfoVtbl): IInspectable(IInspectableVtbl) [IID_IAudioTrackSupportInfo] {
    fn get_DecoderStatus(&self, out: *mut MediaDecoderStatus) -> HRESULT,
    fn get_Degradation(&self, out: *mut AudioDecoderDegradation) -> HRESULT,
    fn get_DegradationReason(&self, out: *mut AudioDecoderDegradationReason) -> HRESULT,
    fn get_MediaSourceStatus(&self, out: *mut MediaSourceStatus) -> HRESULT
}}
impl IAudioTrackSupportInfo {
    #[inline] pub unsafe fn get_decoder_status(&self) -> Result<MediaDecoderStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DecoderStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_degradation(&self) -> Result<AudioDecoderDegradation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Degradation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_degradation_reason(&self) -> Result<AudioDecoderDegradationReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DegradationReason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_source_status(&self) -> Result<MediaSourceStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediaSourceStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioTrackSupportInfo: IAudioTrackSupportInfo}
DEFINE_IID!(IID_IChapterCue, 1923710977, 54154, 19466, 143, 166, 117, 205, 218, 244, 102, 76);
RT_INTERFACE!{interface IChapterCue(IChapterCueVtbl): IInspectable(IInspectableVtbl) [IID_IChapterCue] {
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT
}}
impl IChapterCue {
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChapterCue: IChapterCue}
impl RtActivatable<IActivationFactory> for ChapterCue {}
DEFINE_CLSID!(ChapterCue(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,67,104,97,112,116,101,114,67,117,101,0]) [CLSID_ChapterCue]);
RT_ENUM! { enum CodecCategory: i32 {
    Encoder (CodecCategory_Encoder) = 0, Decoder (CodecCategory_Decoder) = 1,
}}
DEFINE_IID!(IID_ICodecInfo, 1374199685, 60055, 18844, 134, 172, 76, 229, 231, 63, 58, 66);
RT_INTERFACE!{interface ICodecInfo(ICodecInfoVtbl): IInspectable(IInspectableVtbl) [IID_ICodecInfo] {
    fn get_Kind(&self, out: *mut CodecKind) -> HRESULT,
    fn get_Category(&self, out: *mut CodecCategory) -> HRESULT,
    fn get_Subtypes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<HString>) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IsTrusted(&self, out: *mut bool) -> HRESULT
}}
impl ICodecInfo {
    #[inline] pub unsafe fn get_kind(&self) -> Result<CodecKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_category(&self) -> Result<CodecCategory> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Category)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subtypes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subtypes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_trusted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTrusted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CodecInfo: ICodecInfo}
RT_ENUM! { enum CodecKind: i32 {
    Audio (CodecKind_Audio) = 0, Video (CodecKind_Video) = 1,
}}
DEFINE_IID!(IID_ICodecQuery, 573216058, 44897, 19972, 128, 138, 164, 99, 78, 47, 58, 196);
RT_INTERFACE!{interface ICodecQuery(ICodecQueryVtbl): IInspectable(IInspectableVtbl) [IID_ICodecQuery] {
    fn FindAllAsync(&self, kind: CodecKind, category: CodecCategory, subType: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<CodecInfo>>) -> HRESULT
}}
impl ICodecQuery {
    #[inline] pub unsafe fn find_all_async(&self, kind: CodecKind, category: CodecCategory, subType: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<CodecInfo>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsync)(self as *const _ as *mut _, kind, category, subType.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CodecQuery: ICodecQuery}
impl RtActivatable<IActivationFactory> for CodecQuery {}
DEFINE_CLSID!(CodecQuery(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,67,111,100,101,99,81,117,101,114,121,0]) [CLSID_CodecQuery]);
RT_CLASS!{static class CodecSubtypes}
impl RtActivatable<ICodecSubtypesStatics> for CodecSubtypes {}
impl CodecSubtypes {
    #[inline] pub fn get_video_format_dv25() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dv25()
    }}
    #[inline] pub fn get_video_format_dv50() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dv50()
    }}
    #[inline] pub fn get_video_format_dvc() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dvc()
    }}
    #[inline] pub fn get_video_format_dvh1() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dvh1()
    }}
    #[inline] pub fn get_video_format_dvh_d() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dvh_d()
    }}
    #[inline] pub fn get_video_format_dvsd() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dvsd()
    }}
    #[inline] pub fn get_video_format_dvsl() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_dvsl()
    }}
    #[inline] pub fn get_video_format_h263() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_h263()
    }}
    #[inline] pub fn get_video_format_h264() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_h264()
    }}
    #[inline] pub fn get_video_format_h265() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_h265()
    }}
    #[inline] pub fn get_video_format_h264_es() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_h264_es()
    }}
    #[inline] pub fn get_video_format_hevc() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_hevc()
    }}
    #[inline] pub fn get_video_format_hevc_es() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_hevc_es()
    }}
    #[inline] pub fn get_video_format_m4_s2() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_m4_s2()
    }}
    #[inline] pub fn get_video_format_mjpg() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mjpg()
    }}
    #[inline] pub fn get_video_format_mp43() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mp43()
    }}
    #[inline] pub fn get_video_format_mp4_s() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mp4_s()
    }}
    #[inline] pub fn get_video_format_mp4_v() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mp4_v()
    }}
    #[inline] pub fn get_video_format_mpeg2() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mpeg2()
    }}
    #[inline] pub fn get_video_format_vp80() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_vp80()
    }}
    #[inline] pub fn get_video_format_vp90() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_vp90()
    }}
    #[inline] pub fn get_video_format_mpg1() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mpg1()
    }}
    #[inline] pub fn get_video_format_mss1() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mss1()
    }}
    #[inline] pub fn get_video_format_mss2() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_mss2()
    }}
    #[inline] pub fn get_video_format_wmv1() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_wmv1()
    }}
    #[inline] pub fn get_video_format_wmv2() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_wmv2()
    }}
    #[inline] pub fn get_video_format_wmv3() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_wmv3()
    }}
    #[inline] pub fn get_video_format_wvc1() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format_wvc1()
    }}
    #[inline] pub fn get_video_format420_o() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_video_format420_o()
    }}
    #[inline] pub fn get_audio_format_aac() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_aac()
    }}
    #[inline] pub fn get_audio_format_adts() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_adts()
    }}
    #[inline] pub fn get_audio_format_alac() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_alac()
    }}
    #[inline] pub fn get_audio_format_amr_nb() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_amr_nb()
    }}
    #[inline] pub fn get_audio_format_amr_wb() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_amr_wb()
    }}
    #[inline] pub fn get_audio_format_amr_wp() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_amr_wp()
    }}
    #[inline] pub fn get_audio_format_dolby_ac3() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_dolby_ac3()
    }}
    #[inline] pub fn get_audio_format_dolby_ac3_spdif() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_dolby_ac3_spdif()
    }}
    #[inline] pub fn get_audio_format_dolby_ddplus() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_dolby_ddplus()
    }}
    #[inline] pub fn get_audio_format_drm() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_drm()
    }}
    #[inline] pub fn get_audio_format_dts() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_dts()
    }}
    #[inline] pub fn get_audio_format_flac() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_flac()
    }}
    #[inline] pub fn get_audio_format_float() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_float()
    }}
    #[inline] pub fn get_audio_format_mp3() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_mp3()
    }}
    #[inline] pub fn get_audio_format_mpeg() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_mpeg()
    }}
    #[inline] pub fn get_audio_format_msp1() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_msp1()
    }}
    #[inline] pub fn get_audio_format_opus() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_opus()
    }}
    #[inline] pub fn get_audio_format_pcm() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_pcm()
    }}
    #[inline] pub fn get_audio_format_wma_spdif() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_wma_spdif()
    }}
    #[inline] pub fn get_audio_format_wmaudio_lossless() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_wmaudio_lossless()
    }}
    #[inline] pub fn get_audio_format_wmaudio_v8() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_wmaudio_v8()
    }}
    #[inline] pub fn get_audio_format_wmaudio_v9() -> Result<HString> { unsafe {
        <Self as RtActivatable<ICodecSubtypesStatics>>::get_activation_factory().get_audio_format_wmaudio_v9()
    }}
}
DEFINE_CLSID!(CodecSubtypes(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,67,111,100,101,99,83,117,98,116,121,112,101,115,0]) [CLSID_CodecSubtypes]);
DEFINE_IID!(IID_ICodecSubtypesStatics, 2792015090, 34955, 16932, 140, 246, 42, 141, 78, 176, 35, 130);
RT_INTERFACE!{static interface ICodecSubtypesStatics(ICodecSubtypesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICodecSubtypesStatics] {
    fn get_VideoFormatDV25(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatDV50(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatDvc(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatDvh1(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatDvhD(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatDvsd(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatDvsl(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatH263(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatH264(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatH265(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatH264ES(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatHevc(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatHevcES(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatM4S2(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMjpg(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMP43(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMP4S(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMP4V(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMpeg2(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatVP80(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatVP90(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMpg1(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMss1(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatMss2(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatWmv1(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatWmv2(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatWmv3(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormatWvc1(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VideoFormat420O(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatAac(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatAdts(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatAlac(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatAmrNB(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatAmrWB(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatAmrWP(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatDolbyAC3(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatDolbyAC3Spdif(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatDolbyDDPlus(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatDrm(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatDts(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatFlac(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatFloat(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatMP3(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatMPeg(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatMsp1(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatOpus(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatPcm(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatWmaSpdif(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatWMAudioLossless(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatWMAudioV8(&self, out: *mut HSTRING) -> HRESULT,
    fn get_AudioFormatWMAudioV9(&self, out: *mut HSTRING) -> HRESULT
}}
impl ICodecSubtypesStatics {
    #[inline] pub unsafe fn get_video_format_dv25(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDV25)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_dv50(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDV50)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_dvc(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDvc)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_dvh1(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDvh1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_dvh_d(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDvhD)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_dvsd(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDvsd)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_dvsl(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatDvsl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_h263(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatH263)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_h264(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatH264)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_h265(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatH265)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_h264_es(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatH264ES)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_hevc(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatHevc)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_hevc_es(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatHevcES)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_m4_s2(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatM4S2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mjpg(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMjpg)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mp43(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMP43)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mp4_s(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMP4S)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mp4_v(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMP4V)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mpeg2(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMpeg2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_vp80(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatVP80)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_vp90(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatVP90)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mpg1(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMpg1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mss1(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMss1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_mss2(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatMss2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_wmv1(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatWmv1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_wmv2(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatWmv2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_wmv3(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatWmv3)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format_wvc1(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormatWvc1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_format420_o(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoFormat420O)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_aac(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatAac)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_adts(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatAdts)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_alac(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatAlac)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_amr_nb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatAmrNB)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_amr_wb(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatAmrWB)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_amr_wp(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatAmrWP)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_dolby_ac3(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatDolbyAC3)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_dolby_ac3_spdif(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatDolbyAC3Spdif)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_dolby_ddplus(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatDolbyDDPlus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_drm(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatDrm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_dts(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatDts)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_flac(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatFlac)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_float(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatFloat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_mp3(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatMP3)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_mpeg(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatMPeg)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_msp1(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatMsp1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_opus(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatOpus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_pcm(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatPcm)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_wma_spdif(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatWmaSpdif)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_wmaudio_lossless(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatWMAudioLossless)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_wmaudio_v8(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatWMAudioV8)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_format_wmaudio_v9(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AudioFormatWMAudioV9)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataCue, 2088724333, 8124, 20013, 154, 135, 238, 56, 189, 29, 198, 55);
RT_INTERFACE!{interface IDataCue(IDataCueVtbl): IInspectable(IInspectableVtbl) [IID_IDataCue] {
    #[cfg(feature="windows-storage")] fn put_Data(&self, value: *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Data(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl IDataCue {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_data(&self, value: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Data)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DataCue: IDataCue}
impl RtActivatable<IActivationFactory> for DataCue {}
DEFINE_CLSID!(DataCue(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,68,97,116,97,67,117,101,0]) [CLSID_DataCue]);
DEFINE_IID!(IID_IDataCue2, 3159759637, 38386, 18920, 150, 241, 141, 213, 218, 198, 141, 147);
RT_INTERFACE!{interface IDataCue2(IDataCue2Vtbl): IInspectable(IInspectableVtbl) [IID_IDataCue2] {
    fn get_Properties(&self, out: *mut *mut super::super::foundation::collections::PropertySet) -> HRESULT
}}
impl IDataCue2 {
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<super::super::foundation::collections::PropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFaceDetectedEventArgs, 428966950, 50779, 18106, 133, 248, 19, 136, 5, 118, 201, 10);
RT_INTERFACE!{interface IFaceDetectedEventArgs(IFaceDetectedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFaceDetectedEventArgs] {
    fn get_ResultFrame(&self, out: *mut *mut FaceDetectionEffectFrame) -> HRESULT
}}
impl IFaceDetectedEventArgs {
    #[inline] pub unsafe fn get_result_frame(&self) -> Result<ComPtr<FaceDetectionEffectFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ResultFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FaceDetectedEventArgs: IFaceDetectedEventArgs}
DEFINE_IID!(IID_IFaceDetectionEffect, 2920672210, 1346, 17065, 188, 144, 242, 131, 162, 159, 70, 193);
RT_INTERFACE!{interface IFaceDetectionEffect(IFaceDetectionEffectVtbl): IInspectable(IInspectableVtbl) [IID_IFaceDetectionEffect] {
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    fn put_DesiredDetectionInterval(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_DesiredDetectionInterval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn add_FaceDetected(&self, handler: *mut super::super::foundation::TypedEventHandler<FaceDetectionEffect, FaceDetectedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FaceDetected(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IFaceDetectionEffect {
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_detection_interval(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredDetectionInterval)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_detection_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredDetectionInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_face_detected(&self, handler: &super::super::foundation::TypedEventHandler<FaceDetectionEffect, FaceDetectedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FaceDetected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_face_detected(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FaceDetected)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FaceDetectionEffect: IFaceDetectionEffect}
DEFINE_IID!(IID_IFaceDetectionEffectDefinition, 1138532481, 47176, 20275, 183, 2, 31, 210, 98, 79, 176, 22);
RT_INTERFACE!{interface IFaceDetectionEffectDefinition(IFaceDetectionEffectDefinitionVtbl): IInspectable(IInspectableVtbl) [IID_IFaceDetectionEffectDefinition] {
    fn put_DetectionMode(&self, value: FaceDetectionMode) -> HRESULT,
    fn get_DetectionMode(&self, out: *mut FaceDetectionMode) -> HRESULT,
    fn put_SynchronousDetectionEnabled(&self, value: bool) -> HRESULT,
    fn get_SynchronousDetectionEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IFaceDetectionEffectDefinition {
    #[inline] pub unsafe fn set_detection_mode(&self, value: FaceDetectionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DetectionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_detection_mode(&self) -> Result<FaceDetectionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DetectionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_synchronous_detection_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SynchronousDetectionEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_synchronous_detection_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SynchronousDetectionEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class FaceDetectionEffectDefinition: super::effects::IVideoEffectDefinition}
impl RtActivatable<IActivationFactory> for FaceDetectionEffectDefinition {}
DEFINE_CLSID!(FaceDetectionEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,70,97,99,101,68,101,116,101,99,116,105,111,110,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_FaceDetectionEffectDefinition]);
DEFINE_IID!(IID_IFaceDetectionEffectFrame, 2326825363, 24008, 17531, 162, 71, 82, 112, 189, 128, 46, 206);
RT_INTERFACE!{interface IFaceDetectionEffectFrame(IFaceDetectionEffectFrameVtbl): IInspectable(IInspectableVtbl) [IID_IFaceDetectionEffectFrame] {
    fn get_DetectedFaces(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::faceanalysis::DetectedFace>) -> HRESULT
}}
impl IFaceDetectionEffectFrame {
    #[inline] pub unsafe fn get_detected_faces(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::faceanalysis::DetectedFace>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DetectedFaces)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FaceDetectionEffectFrame: IFaceDetectionEffectFrame}
RT_ENUM! { enum FaceDetectionMode: i32 {
    HighPerformance (FaceDetectionMode_HighPerformance) = 0, Balanced (FaceDetectionMode_Balanced) = 1, HighQuality (FaceDetectionMode_HighQuality) = 2,
}}
DEFINE_IID!(IID_IHighDynamicRangeControl, 1441900462, 55639, 19913, 157, 28, 133, 83, 168, 42, 125, 153);
RT_INTERFACE!{interface IHighDynamicRangeControl(IHighDynamicRangeControlVtbl): IInspectable(IInspectableVtbl) [IID_IHighDynamicRangeControl] {
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT
}}
impl IHighDynamicRangeControl {
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class HighDynamicRangeControl: IHighDynamicRangeControl}
DEFINE_IID!(IID_IHighDynamicRangeOutput, 257392747, 9531, 16665, 187, 64, 58, 144, 229, 19, 132, 247);
RT_INTERFACE!{interface IHighDynamicRangeOutput(IHighDynamicRangeOutputVtbl): IInspectable(IInspectableVtbl) [IID_IHighDynamicRangeOutput] {
    fn get_Certainty(&self, out: *mut f64) -> HRESULT,
    fn get_FrameControllers(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::devices::core::FrameController>) -> HRESULT
}}
impl IHighDynamicRangeOutput {
    #[inline] pub unsafe fn get_certainty(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Certainty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_controllers(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::devices::core::FrameController>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameControllers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class HighDynamicRangeOutput: IHighDynamicRangeOutput}
DEFINE_IID!(IID_IImageCue, 1384284802, 13947, 17419, 145, 22, 60, 132, 87, 13, 210, 112);
RT_INTERFACE!{interface IImageCue(IImageCueVtbl): IInspectable(IInspectableVtbl) [IID_IImageCue] {
    fn get_Position(&self, out: *mut TimedTextPoint) -> HRESULT,
    fn put_Position(&self, value: TimedTextPoint) -> HRESULT,
    fn get_Extent(&self, out: *mut TimedTextSize) -> HRESULT,
    fn put_Extent(&self, value: TimedTextSize) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn put_SoftwareBitmap(&self, value: *mut super::super::graphics::imaging::SoftwareBitmap) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn get_SoftwareBitmap(&self, out: *mut *mut super::super::graphics::imaging::SoftwareBitmap) -> HRESULT
}}
impl IImageCue {
    #[inline] pub unsafe fn get_position(&self) -> Result<TimedTextPoint> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: TimedTextPoint) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extent(&self) -> Result<TimedTextSize> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Extent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_extent(&self, value: TimedTextSize) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Extent)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn set_software_bitmap(&self, value: &super::super::graphics::imaging::SoftwareBitmap) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SoftwareBitmap)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_software_bitmap(&self) -> Result<ComPtr<super::super::graphics::imaging::SoftwareBitmap>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SoftwareBitmap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ImageCue: IImageCue}
impl RtActivatable<IActivationFactory> for ImageCue {}
DEFINE_CLSID!(ImageCue(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,73,109,97,103,101,67,117,101,0]) [CLSID_ImageCue]);
DEFINE_IID!(IID_IInitializeMediaStreamSourceRequestedEventArgs, 633095649, 39688, 19502, 168, 85, 69, 66, 241, 167, 93, 235);
RT_INTERFACE!{interface IInitializeMediaStreamSourceRequestedEventArgs(IInitializeMediaStreamSourceRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IInitializeMediaStreamSourceRequestedEventArgs] {
    fn get_Source(&self, out: *mut *mut MediaStreamSource) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_RandomAccessStream(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStream) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT
}}
impl IInitializeMediaStreamSourceRequestedEventArgs {
    #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<MediaStreamSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_random_access_stream(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStream>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RandomAccessStream)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InitializeMediaStreamSourceRequestedEventArgs: IInitializeMediaStreamSourceRequestedEventArgs}
RT_CLASS!{static class LowLightFusion}
impl RtActivatable<ILowLightFusionStatics> for LowLightFusion {}
impl LowLightFusion {
    #[cfg(feature="windows-graphics")] #[inline] pub fn get_supported_bitmap_pixel_formats() -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::graphics::imaging::BitmapPixelFormat>>> { unsafe {
        <Self as RtActivatable<ILowLightFusionStatics>>::get_activation_factory().get_supported_bitmap_pixel_formats()
    }}
    #[inline] pub fn get_max_supported_frame_count() -> Result<i32> { unsafe {
        <Self as RtActivatable<ILowLightFusionStatics>>::get_activation_factory().get_max_supported_frame_count()
    }}
    #[cfg(feature="windows-graphics")] #[inline] pub fn fuse_async(frameSet: &super::super::foundation::collections::IIterable<super::super::graphics::imaging::SoftwareBitmap>) -> Result<ComPtr<super::super::foundation::IAsyncOperationWithProgress<LowLightFusionResult, f64>>> { unsafe {
        <Self as RtActivatable<ILowLightFusionStatics>>::get_activation_factory().fuse_async(frameSet)
    }}
}
DEFINE_CLSID!(LowLightFusion(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,76,111,119,76,105,103,104,116,70,117,115,105,111,110,0]) [CLSID_LowLightFusion]);
DEFINE_IID!(IID_ILowLightFusionResult, 2028846645, 10144, 17120, 156, 211, 115, 141, 32, 137, 222, 156);
RT_INTERFACE!{interface ILowLightFusionResult(ILowLightFusionResultVtbl): IInspectable(IInspectableVtbl) [IID_ILowLightFusionResult] {
    #[cfg(feature="windows-graphics")] fn get_Frame(&self, out: *mut *mut super::super::graphics::imaging::SoftwareBitmap) -> HRESULT
}}
impl ILowLightFusionResult {
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_frame(&self) -> Result<ComPtr<super::super::graphics::imaging::SoftwareBitmap>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Frame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class LowLightFusionResult: ILowLightFusionResult}
DEFINE_IID!(IID_ILowLightFusionStatics, 1392836973, 49822, 16610, 135, 169, 158, 31, 210, 241, 146, 245);
RT_INTERFACE!{static interface ILowLightFusionStatics(ILowLightFusionStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ILowLightFusionStatics] {
    #[cfg(feature="windows-graphics")] fn get_SupportedBitmapPixelFormats(&self, out: *mut *mut super::super::foundation::collections::IVectorView<super::super::graphics::imaging::BitmapPixelFormat>) -> HRESULT,
    fn get_MaxSupportedFrameCount(&self, out: *mut i32) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn FuseAsync(&self, frameSet: *mut super::super::foundation::collections::IIterable<super::super::graphics::imaging::SoftwareBitmap>, out: *mut *mut super::super::foundation::IAsyncOperationWithProgress<LowLightFusionResult, f64>) -> HRESULT
}}
impl ILowLightFusionStatics {
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn get_supported_bitmap_pixel_formats(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::super::graphics::imaging::BitmapPixelFormat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedBitmapPixelFormats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_supported_frame_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSupportedFrameCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn fuse_async(&self, frameSet: &super::super::foundation::collections::IIterable<super::super::graphics::imaging::SoftwareBitmap>) -> Result<ComPtr<super::super::foundation::IAsyncOperationWithProgress<LowLightFusionResult, f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FuseAsync)(self as *const _ as *mut _, frameSet as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaBinder, 729694378, 56839, 16975, 131, 241, 241, 222, 70, 196, 250, 46);
RT_INTERFACE!{interface IMediaBinder(IMediaBinderVtbl): IInspectable(IInspectableVtbl) [IID_IMediaBinder] {
    fn add_Binding(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaBinder, MediaBindingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Binding(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Token(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Token(&self, value: HSTRING) -> HRESULT,
    fn get_Source(&self, out: *mut *mut MediaSource) -> HRESULT
}}
impl IMediaBinder {
    #[inline] pub unsafe fn add_binding(&self, handler: &super::super::foundation::TypedEventHandler<MediaBinder, MediaBindingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Binding)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_binding(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Binding)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_token(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Token)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_token(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Token)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaBinder: IMediaBinder}
impl RtActivatable<IActivationFactory> for MediaBinder {}
DEFINE_CLSID!(MediaBinder(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,77,101,100,105,97,66,105,110,100,101,114,0]) [CLSID_MediaBinder]);
DEFINE_IID!(IID_IMediaBindingEventArgs, 3055333978, 7021, 17968, 168, 109, 47, 8, 55, 247, 18, 229);
RT_INTERFACE!{interface IMediaBindingEventArgs(IMediaBindingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaBindingEventArgs] {
    fn add_Canceled(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaBindingEventArgs, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Canceled(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_MediaBinder(&self, out: *mut *mut MediaBinder) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut super::super::foundation::Deferral) -> HRESULT,
    fn SetUri(&self, uri: *mut super::super::foundation::Uri) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SetStream(&self, stream: *mut super::super::storage::streams::IRandomAccessStream, contentType: HSTRING) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SetStreamReference(&self, stream: *mut super::super::storage::streams::IRandomAccessStreamReference, contentType: HSTRING) -> HRESULT
}}
impl IMediaBindingEventArgs {
    #[inline] pub unsafe fn add_canceled(&self, handler: &super::super::foundation::TypedEventHandler<MediaBindingEventArgs, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Canceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_canceled(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Canceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_binder(&self) -> Result<ComPtr<MediaBinder>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaBinder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<super::super::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_uri(&self, uri: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).SetUri)(self as *const _ as *mut _, uri as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_stream(&self, stream: &super::super::storage::streams::IRandomAccessStream, contentType: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetStream)(self as *const _ as *mut _, stream as *const _ as *mut _, contentType.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_stream_reference(&self, stream: &super::super::storage::streams::IRandomAccessStreamReference, contentType: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetStreamReference)(self as *const _ as *mut _, stream as *const _ as *mut _, contentType.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaBindingEventArgs: IMediaBindingEventArgs}
DEFINE_IID!(IID_IMediaBindingEventArgs2, 73714923, 47962, 18479, 184, 186, 240, 40, 76, 105, 101, 103);
RT_INTERFACE!{interface IMediaBindingEventArgs2(IMediaBindingEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaBindingEventArgs2] {
    fn SetAdaptiveMediaSource(&self, mediaSource: *mut super::streaming::adaptive::AdaptiveMediaSource) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SetStorageFile(&self, file: *mut super::super::storage::IStorageFile) -> HRESULT
}}
impl IMediaBindingEventArgs2 {
    #[inline] pub unsafe fn set_adaptive_media_source(&self, mediaSource: &super::streaming::adaptive::AdaptiveMediaSource) -> Result<()> {
        let hr = ((*self.lpVtbl).SetAdaptiveMediaSource)(self as *const _ as *mut _, mediaSource as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_storage_file(&self, file: &super::super::storage::IStorageFile) -> Result<()> {
        let hr = ((*self.lpVtbl).SetStorageFile)(self as *const _ as *mut _, file as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCue, 3352387165, 23004, 17183, 160, 238, 39, 116, 67, 35, 179, 109);
RT_INTERFACE!{interface IMediaCue(IMediaCueVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCue] {
    fn put_StartTime(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_StartTime(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_Duration(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_Id(&self, value: HSTRING) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaCue {
    #[inline] pub unsafe fn set_start_time(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_time(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Id)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaCueEventArgs, 3509536759, 24484, 20072, 159, 229, 50, 22, 13, 206, 229, 126);
RT_INTERFACE!{interface IMediaCueEventArgs(IMediaCueEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaCueEventArgs] {
    fn get_Cue(&self, out: *mut *mut IMediaCue) -> HRESULT
}}
impl IMediaCueEventArgs {
    #[inline] pub unsafe fn get_cue(&self) -> Result<ComPtr<IMediaCue>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Cue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaCueEventArgs: IMediaCueEventArgs}
RT_ENUM! { enum MediaDecoderStatus: i32 {
    FullySupported (MediaDecoderStatus_FullySupported) = 0, UnsupportedSubtype (MediaDecoderStatus_UnsupportedSubtype) = 1, UnsupportedEncoderProperties (MediaDecoderStatus_UnsupportedEncoderProperties) = 2, Degraded (MediaDecoderStatus_Degraded) = 3,
}}
DEFINE_IID!(IID_IMediaSource, 3888100761, 41117, 19489, 188, 223, 32, 175, 79, 134, 179, 217);
RT_INTERFACE!{interface IMediaSource(IMediaSourceVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSource] {
    
}}
RT_CLASS!{class MediaSource: IMediaSource2}
impl RtActivatable<IMediaSourceStatics> for MediaSource {}
impl RtActivatable<IMediaSourceStatics2> for MediaSource {}
impl RtActivatable<IMediaSourceStatics3> for MediaSource {}
impl MediaSource {
    #[inline] pub fn create_from_adaptive_media_source(mediaSource: &super::streaming::adaptive::AdaptiveMediaSource) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_adaptive_media_source(mediaSource)
    }}
    #[inline] pub fn create_from_media_stream_source(mediaSource: &MediaStreamSource) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_media_stream_source(mediaSource)
    }}
    #[inline] pub fn create_from_mse_stream_source(mediaSource: &MseStreamSource) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_mse_stream_source(mediaSource)
    }}
    #[inline] pub fn create_from_imedia_source(mediaSource: &IMediaSource) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_imedia_source(mediaSource)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_storage_file(file: &super::super::storage::IStorageFile) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_storage_file(file)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream(stream: &super::super::storage::streams::IRandomAccessStream, contentType: &HStringArg) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_stream(stream, contentType)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream_reference(stream: &super::super::storage::streams::IRandomAccessStreamReference, contentType: &HStringArg) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_stream_reference(stream, contentType)
    }}
    #[inline] pub fn create_from_uri(uri: &super::super::foundation::Uri) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics>>::get_activation_factory().create_from_uri(uri)
    }}
    #[inline] pub fn create_from_media_binder(binder: &MediaBinder) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics2>>::get_activation_factory().create_from_media_binder(binder)
    }}
    #[inline] pub fn create_from_media_frame_source(frameSource: &super::capture::frames::MediaFrameSource) -> Result<ComPtr<MediaSource>> { unsafe {
        <Self as RtActivatable<IMediaSourceStatics3>>::get_activation_factory().create_from_media_frame_source(frameSource)
    }}
}
DEFINE_CLSID!(MediaSource(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,77,101,100,105,97,83,111,117,114,99,101,0]) [CLSID_MediaSource]);
DEFINE_IID!(IID_IMediaSource2, 783683656, 25951, 19511, 184, 19, 180, 228, 93, 250, 10, 190);
RT_INTERFACE!{interface IMediaSource2(IMediaSource2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaSource2] {
    fn add_OpenOperationCompleted(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaSource, MediaSourceOpenOperationCompletedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_OpenOperationCompleted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_CustomProperties(&self, out: *mut *mut super::super::foundation::collections::ValueSet) -> HRESULT,
    fn get_Duration(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_IsOpen(&self, out: *mut bool) -> HRESULT,
    fn get_ExternalTimedTextSources(&self, out: *mut *mut super::super::foundation::collections::IObservableVector<TimedTextSource>) -> HRESULT,
    fn get_ExternalTimedMetadataTracks(&self, out: *mut *mut super::super::foundation::collections::IObservableVector<TimedMetadataTrack>) -> HRESULT
}}
impl IMediaSource2 {
    #[inline] pub unsafe fn add_open_operation_completed(&self, handler: &super::super::foundation::TypedEventHandler<MediaSource, MediaSourceOpenOperationCompletedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_OpenOperationCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_open_operation_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_OpenOperationCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_properties(&self) -> Result<ComPtr<super::super::foundation::collections::ValueSet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CustomProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_open(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOpen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_external_timed_text_sources(&self) -> Result<ComPtr<super::super::foundation::collections::IObservableVector<TimedTextSource>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExternalTimedTextSources)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_external_timed_metadata_tracks(&self) -> Result<ComPtr<super::super::foundation::collections::IObservableVector<TimedMetadataTrack>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExternalTimedMetadataTracks)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaSource3, 3047099803, 19310, 16877, 187, 180, 124, 117, 9, 169, 148, 173);
RT_INTERFACE!{interface IMediaSource3(IMediaSource3Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaSource3] {
    fn add_StateChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaSource, MediaSourceStateChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_State(&self, out: *mut MediaSourceState) -> HRESULT,
    fn Reset(&self) -> HRESULT
}}
impl IMediaSource3 {
    #[inline] pub unsafe fn add_state_changed(&self, handler: &super::super::foundation::TypedEventHandler<MediaSource, MediaSourceStateChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StateChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<MediaSourceState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Reset)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaSource4, 3182406999, 36607, 19555, 133, 166, 132, 222, 10, 227, 228, 242);
RT_INTERFACE!{interface IMediaSource4(IMediaSource4Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaSource4] {
    fn get_AdaptiveMediaSource(&self, out: *mut *mut super::streaming::adaptive::AdaptiveMediaSource) -> HRESULT,
    fn get_MediaStreamSource(&self, out: *mut *mut MediaStreamSource) -> HRESULT,
    fn get_MseStreamSource(&self, out: *mut *mut MseStreamSource) -> HRESULT,
    fn get_Uri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn OpenAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IMediaSource4 {
    #[inline] pub unsafe fn get_adaptive_media_source(&self) -> Result<ComPtr<super::streaming::adaptive::AdaptiveMediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AdaptiveMediaSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_stream_source(&self) -> Result<ComPtr<MediaStreamSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaStreamSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mse_stream_source(&self) -> Result<ComPtr<MseStreamSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MseStreamSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Uri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn open_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OpenAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaSourceAppServiceConnection, 1642195607, 6422, 18448, 183, 244, 182, 66, 190, 130, 149, 150);
RT_INTERFACE!{interface IMediaSourceAppServiceConnection(IMediaSourceAppServiceConnectionVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceAppServiceConnection] {
    fn add_InitializeMediaStreamSourceRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaSourceAppServiceConnection, InitializeMediaStreamSourceRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_InitializeMediaStreamSourceRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Start(&self) -> HRESULT
}}
impl IMediaSourceAppServiceConnection {
    #[inline] pub unsafe fn add_initialize_media_stream_source_requested(&self, handler: &super::super::foundation::TypedEventHandler<MediaSourceAppServiceConnection, InitializeMediaStreamSourceRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_InitializeMediaStreamSourceRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_initialize_media_stream_source_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_InitializeMediaStreamSourceRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaSourceAppServiceConnection: IMediaSourceAppServiceConnection}
impl RtActivatable<IMediaSourceAppServiceConnectionFactory> for MediaSourceAppServiceConnection {}
impl MediaSourceAppServiceConnection {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub fn create(appServiceConnection: &super::super::applicationmodel::appservice::AppServiceConnection) -> Result<ComPtr<MediaSourceAppServiceConnection>> { unsafe {
        <Self as RtActivatable<IMediaSourceAppServiceConnectionFactory>>::get_activation_factory().create(appServiceConnection)
    }}
}
DEFINE_CLSID!(MediaSourceAppServiceConnection(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,77,101,100,105,97,83,111,117,114,99,101,65,112,112,83,101,114,118,105,99,101,67,111,110,110,101,99,116,105,111,110,0]) [CLSID_MediaSourceAppServiceConnection]);
DEFINE_IID!(IID_IMediaSourceAppServiceConnectionFactory, 1706627819, 32953, 17657, 156, 30, 225, 32, 246, 217, 40, 56);
RT_INTERFACE!{static interface IMediaSourceAppServiceConnectionFactory(IMediaSourceAppServiceConnectionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceAppServiceConnectionFactory] {
    #[cfg(feature="windows-applicationmodel")] fn Create(&self, appServiceConnection: *mut super::super::applicationmodel::appservice::AppServiceConnection, out: *mut *mut MediaSourceAppServiceConnection) -> HRESULT
}}
impl IMediaSourceAppServiceConnectionFactory {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn create(&self, appServiceConnection: &super::super::applicationmodel::appservice::AppServiceConnection) -> Result<ComPtr<MediaSourceAppServiceConnection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, appServiceConnection as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaSourceError, 1544194405, 14277, 20125, 141, 33, 28, 222, 233, 12, 236, 198);
RT_INTERFACE!{interface IMediaSourceError(IMediaSourceErrorVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceError] {
    fn get_ExtendedError(&self, out: *mut super::super::foundation::HResult) -> HRESULT
}}
impl IMediaSourceError {
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaSourceError: IMediaSourceError}
DEFINE_IID!(IID_IMediaSourceOpenOperationCompletedEventArgs, 4234685675, 57985, 18300, 168, 224, 26, 205, 101, 65, 20, 200);
RT_INTERFACE!{interface IMediaSourceOpenOperationCompletedEventArgs(IMediaSourceOpenOperationCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceOpenOperationCompletedEventArgs] {
    fn get_Error(&self, out: *mut *mut MediaSourceError) -> HRESULT
}}
impl IMediaSourceOpenOperationCompletedEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<ComPtr<MediaSourceError>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaSourceOpenOperationCompletedEventArgs: IMediaSourceOpenOperationCompletedEventArgs}
RT_ENUM! { enum MediaSourceState: i32 {
    Initial (MediaSourceState_Initial) = 0, Opening (MediaSourceState_Opening) = 1, Opened (MediaSourceState_Opened) = 2, Failed (MediaSourceState_Failed) = 3, Closed (MediaSourceState_Closed) = 4,
}}
DEFINE_IID!(IID_IMediaSourceStateChangedEventArgs, 170962818, 36977, 19372, 188, 57, 202, 42, 147, 183, 23, 169);
RT_INTERFACE!{interface IMediaSourceStateChangedEventArgs(IMediaSourceStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceStateChangedEventArgs] {
    fn get_OldState(&self, out: *mut MediaSourceState) -> HRESULT,
    fn get_NewState(&self, out: *mut MediaSourceState) -> HRESULT
}}
impl IMediaSourceStateChangedEventArgs {
    #[inline] pub unsafe fn get_old_state(&self) -> Result<MediaSourceState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OldState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_state(&self) -> Result<MediaSourceState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaSourceStateChangedEventArgs: IMediaSourceStateChangedEventArgs}
DEFINE_IID!(IID_IMediaSourceStatics, 4152192932, 18002, 16654, 177, 216, 233, 165, 226, 69, 164, 92);
RT_INTERFACE!{static interface IMediaSourceStatics(IMediaSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceStatics] {
    fn CreateFromAdaptiveMediaSource(&self, mediaSource: *mut super::streaming::adaptive::AdaptiveMediaSource, out: *mut *mut MediaSource) -> HRESULT,
    fn CreateFromMediaStreamSource(&self, mediaSource: *mut MediaStreamSource, out: *mut *mut MediaSource) -> HRESULT,
    fn CreateFromMseStreamSource(&self, mediaSource: *mut MseStreamSource, out: *mut *mut MediaSource) -> HRESULT,
    fn CreateFromIMediaSource(&self, mediaSource: *mut IMediaSource, out: *mut *mut MediaSource) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStorageFile(&self, file: *mut super::super::storage::IStorageFile, out: *mut *mut MediaSource) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStream(&self, stream: *mut super::super::storage::streams::IRandomAccessStream, contentType: HSTRING, out: *mut *mut MediaSource) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStreamReference(&self, stream: *mut super::super::storage::streams::IRandomAccessStreamReference, contentType: HSTRING, out: *mut *mut MediaSource) -> HRESULT,
    fn CreateFromUri(&self, uri: *mut super::super::foundation::Uri, out: *mut *mut MediaSource) -> HRESULT
}}
impl IMediaSourceStatics {
    #[inline] pub unsafe fn create_from_adaptive_media_source(&self, mediaSource: &super::streaming::adaptive::AdaptiveMediaSource) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromAdaptiveMediaSource)(self as *const _ as *mut _, mediaSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_media_stream_source(&self, mediaSource: &MediaStreamSource) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromMediaStreamSource)(self as *const _ as *mut _, mediaSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_mse_stream_source(&self, mediaSource: &MseStreamSource) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromMseStreamSource)(self as *const _ as *mut _, mediaSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_imedia_source(&self, mediaSource: &IMediaSource) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromIMediaSource)(self as *const _ as *mut _, mediaSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_storage_file(&self, file: &super::super::storage::IStorageFile) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStorageFile)(self as *const _ as *mut _, file as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream(&self, stream: &super::super::storage::streams::IRandomAccessStream, contentType: &HStringArg) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStream)(self as *const _ as *mut _, stream as *const _ as *mut _, contentType.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream_reference(&self, stream: &super::super::storage::streams::IRandomAccessStreamReference, contentType: &HStringArg) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStreamReference)(self as *const _ as *mut _, stream as *const _ as *mut _, contentType.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_uri(&self, uri: &super::super::foundation::Uri) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromUri)(self as *const _ as *mut _, uri as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaSourceStatics2, 4007748004, 32531, 18582, 184, 203, 223, 13, 229, 188, 185, 241);
RT_INTERFACE!{static interface IMediaSourceStatics2(IMediaSourceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceStatics2] {
    fn CreateFromMediaBinder(&self, binder: *mut MediaBinder, out: *mut *mut MediaSource) -> HRESULT
}}
impl IMediaSourceStatics2 {
    #[inline] pub unsafe fn create_from_media_binder(&self, binder: &MediaBinder) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromMediaBinder)(self as *const _ as *mut _, binder as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaSourceStatics3, 1161441494, 11242, 16674, 159, 115, 234, 206, 4, 82, 110, 53);
RT_INTERFACE!{static interface IMediaSourceStatics3(IMediaSourceStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaSourceStatics3] {
    fn CreateFromMediaFrameSource(&self, frameSource: *mut super::capture::frames::MediaFrameSource, out: *mut *mut MediaSource) -> HRESULT
}}
impl IMediaSourceStatics3 {
    #[inline] pub unsafe fn create_from_media_frame_source(&self, frameSource: &super::capture::frames::MediaFrameSource) -> Result<ComPtr<MediaSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromMediaFrameSource)(self as *const _ as *mut _, frameSource as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaSourceStatus: i32 {
    FullySupported (MediaSourceStatus_FullySupported) = 0, Unknown (MediaSourceStatus_Unknown) = 1,
}}
DEFINE_IID!(IID_IMediaStreamDescriptor, 2163306094, 37623, 17694, 151, 210, 175, 216, 7, 66, 218, 112);
RT_INTERFACE!{interface IMediaStreamDescriptor(IMediaStreamDescriptorVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamDescriptor] {
    fn get_IsSelected(&self, out: *mut bool) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Language(&self, value: HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaStreamDescriptor {
    #[inline] pub unsafe fn get_is_selected(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSelected)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Language)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamDescriptor2, 1349714191, 59570, 16497, 176, 11, 235, 243, 55, 167, 107, 88);
RT_INTERFACE!{interface IMediaStreamDescriptor2(IMediaStreamDescriptor2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamDescriptor2] {
    fn put_Label(&self, value: HSTRING) -> HRESULT,
    fn get_Label(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaStreamDescriptor2 {
    #[inline] pub unsafe fn set_label(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Label)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_label(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Label)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamSample, 1552791079, 19328, 17249, 152, 55, 108, 183, 72, 26, 217, 214);
RT_INTERFACE!{interface IMediaStreamSample(IMediaStreamSampleVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSample] {
    fn add_Processed(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSample, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Processed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Buffer(&self, out: *mut *mut super::super::storage::streams::Buffer) -> HRESULT,
    fn get_Timestamp(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_ExtendedProperties(&self, out: *mut *mut MediaStreamSamplePropertySet) -> HRESULT,
    fn get_Protection(&self, out: *mut *mut MediaStreamSampleProtectionProperties) -> HRESULT,
    fn put_DecodeTimestamp(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_DecodeTimestamp(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_Duration(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_KeyFrame(&self, value: bool) -> HRESULT,
    fn get_KeyFrame(&self, out: *mut bool) -> HRESULT,
    fn put_Discontinuous(&self, value: bool) -> HRESULT,
    fn get_Discontinuous(&self, out: *mut bool) -> HRESULT
}}
impl IMediaStreamSample {
    #[inline] pub unsafe fn add_processed(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSample, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Processed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_processed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Processed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_buffer(&self) -> Result<ComPtr<super::super::storage::streams::Buffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Buffer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_properties(&self) -> Result<ComPtr<MediaStreamSamplePropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExtendedProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protection(&self) -> Result<ComPtr<MediaStreamSampleProtectionProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Protection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_decode_timestamp(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DecodeTimestamp)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_decode_timestamp(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DecodeTimestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_key_frame(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeyFrame)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_frame(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_discontinuous(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Discontinuous)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_discontinuous(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Discontinuous)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSample: IMediaStreamSample}
impl RtActivatable<IMediaStreamSampleStatics> for MediaStreamSample {}
impl MediaStreamSample {
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_buffer(buffer: &super::super::storage::streams::IBuffer, timestamp: super::super::foundation::TimeSpan) -> Result<ComPtr<MediaStreamSample>> { unsafe {
        <Self as RtActivatable<IMediaStreamSampleStatics>>::get_activation_factory().create_from_buffer(buffer, timestamp)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream_async(stream: &super::super::storage::streams::IInputStream, count: u32, timestamp: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaStreamSample>>> { unsafe {
        <Self as RtActivatable<IMediaStreamSampleStatics>>::get_activation_factory().create_from_stream_async(stream, count, timestamp)
    }}
}
DEFINE_CLSID!(MediaStreamSample(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,77,101,100,105,97,83,116,114,101,97,109,83,97,109,112,108,101,0]) [CLSID_MediaStreamSample]);
RT_CLASS!{class MediaStreamSamplePropertySet: super::super::foundation::collections::IMap<Guid, IInspectable>}
DEFINE_IID!(IID_IMediaStreamSampleProtectionProperties, 1320714898, 60639, 18750, 132, 29, 221, 74, 221, 124, 172, 162);
RT_INTERFACE!{interface IMediaStreamSampleProtectionProperties(IMediaStreamSampleProtectionPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSampleProtectionProperties] {
    fn SetKeyIdentifier(&self, valueSize: u32, value: *mut u8) -> HRESULT,
    fn GetKeyIdentifier(&self, valueSize: *mut u32, value: *mut *mut u8) -> HRESULT,
    fn SetInitializationVector(&self, valueSize: u32, value: *mut u8) -> HRESULT,
    fn GetInitializationVector(&self, valueSize: *mut u32, value: *mut *mut u8) -> HRESULT,
    fn SetSubSampleMapping(&self, valueSize: u32, value: *mut u8) -> HRESULT,
    fn GetSubSampleMapping(&self, valueSize: *mut u32, value: *mut *mut u8) -> HRESULT
}}
impl IMediaStreamSampleProtectionProperties {
    #[inline] pub unsafe fn set_key_identifier(&self, value: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).SetKeyIdentifier)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_identifier(&self) -> Result<ComArray<u8>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetKeyIdentifier)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_initialization_vector(&self, value: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).SetInitializationVector)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_initialization_vector(&self) -> Result<ComArray<u8>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetInitializationVector)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sub_sample_mapping(&self, value: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).SetSubSampleMapping)(self as *const _ as *mut _, value.len() as u32, value.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sub_sample_mapping(&self) -> Result<ComArray<u8>> {
        let mut valueSize = 0; let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetSubSampleMapping)(self as *const _ as *mut _, &mut valueSize, &mut value);
        if hr == S_OK { Ok(ComArray::from_raw(valueSize, value)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSampleProtectionProperties: IMediaStreamSampleProtectionProperties}
DEFINE_IID!(IID_IMediaStreamSampleStatics, 3755942287, 42703, 17785, 190, 65, 115, 221, 148, 26, 217, 114);
RT_INTERFACE!{static interface IMediaStreamSampleStatics(IMediaStreamSampleStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSampleStatics] {
    #[cfg(feature="windows-storage")] fn CreateFromBuffer(&self, buffer: *mut super::super::storage::streams::IBuffer, timestamp: super::super::foundation::TimeSpan, out: *mut *mut MediaStreamSample) -> HRESULT,
    #[cfg(feature="windows-storage")] fn CreateFromStreamAsync(&self, stream: *mut super::super::storage::streams::IInputStream, count: u32, timestamp: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncOperation<MediaStreamSample>) -> HRESULT
}}
impl IMediaStreamSampleStatics {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_buffer(&self, buffer: &super::super::storage::streams::IBuffer, timestamp: super::super::foundation::TimeSpan) -> Result<ComPtr<MediaStreamSample>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromBuffer)(self as *const _ as *mut _, buffer as *const _ as *mut _, timestamp, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream_async(&self, stream: &super::super::storage::streams::IInputStream, count: u32, timestamp: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncOperation<MediaStreamSample>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStreamAsync)(self as *const _ as *mut _, stream as *const _ as *mut _, count, timestamp, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamSource, 923981123, 17899, 16696, 170, 98, 192, 30, 38, 243, 132, 63);
RT_INTERFACE!{interface IMediaStreamSource(IMediaStreamSourceVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSource] {
    fn add_Closed(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceClosedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Starting(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceStartingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Starting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Paused(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSource, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Paused(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SampleRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceSampleRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SampleRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SwitchStreamsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceSwitchStreamsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SwitchStreamsRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn NotifyError(&self, errorStatus: MediaStreamSourceErrorStatus) -> HRESULT,
    fn AddStreamDescriptor(&self, descriptor: *mut IMediaStreamDescriptor) -> HRESULT,
    fn put_MediaProtectionManager(&self, value: *mut super::protection::MediaProtectionManager) -> HRESULT,
    fn get_MediaProtectionManager(&self, out: *mut *mut super::protection::MediaProtectionManager) -> HRESULT,
    fn put_Duration(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_CanSeek(&self, value: bool) -> HRESULT,
    fn get_CanSeek(&self, out: *mut bool) -> HRESULT,
    fn put_BufferTime(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_BufferTime(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn SetBufferedRange(&self, startOffset: super::super::foundation::TimeSpan, endOffset: super::super::foundation::TimeSpan) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy21(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_MusicProperties(&self, out: *mut *mut super::super::storage::fileproperties::MusicProperties) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy22(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_VideoProperties(&self, out: *mut *mut super::super::storage::fileproperties::VideoProperties) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy23(&self) -> (),
    #[cfg(feature="windows-storage")] fn put_Thumbnail(&self, value: *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy24(&self) -> (),
    #[cfg(feature="windows-storage")] fn get_Thumbnail(&self, out: *mut *mut super::super::storage::streams::IRandomAccessStreamReference) -> HRESULT,
    fn AddProtectionKey(&self, streamDescriptor: *mut IMediaStreamDescriptor, keyIdentifierSize: u32, keyIdentifier: *mut u8, licenseDataSize: u32, licenseData: *mut u8) -> HRESULT
}}
impl IMediaStreamSource {
    #[inline] pub unsafe fn add_closed(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceClosedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_starting(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceStartingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Starting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_starting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Starting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_paused(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSource, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Paused)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_paused(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Paused)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sample_requested(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceSampleRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SampleRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sample_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SampleRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_switch_streams_requested(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceSwitchStreamsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SwitchStreamsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_switch_streams_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SwitchStreamsRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_error(&self, errorStatus: MediaStreamSourceErrorStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyError)(self as *const _ as *mut _, errorStatus);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stream_descriptor(&self, descriptor: &IMediaStreamDescriptor) -> Result<()> {
        let hr = ((*self.lpVtbl).AddStreamDescriptor)(self as *const _ as *mut _, descriptor as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_media_protection_manager(&self, value: &super::protection::MediaProtectionManager) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MediaProtectionManager)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_protection_manager(&self) -> Result<ComPtr<super::protection::MediaProtectionManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MediaProtectionManager)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_seek(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanSeek)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_seek(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanSeek)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_buffer_time(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BufferTime)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_buffer_time(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BufferTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_buffered_range(&self, startOffset: super::super::foundation::TimeSpan, endOffset: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).SetBufferedRange)(self as *const _ as *mut _, startOffset, endOffset);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_music_properties(&self) -> Result<ComPtr<super::super::storage::fileproperties::MusicProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MusicProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_video_properties(&self) -> Result<ComPtr<super::super::storage::fileproperties::VideoProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VideoProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_thumbnail(&self, value: &super::super::storage::streams::IRandomAccessStreamReference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Thumbnail)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_thumbnail(&self) -> Result<ComPtr<super::super::storage::streams::IRandomAccessStreamReference>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Thumbnail)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_protection_key(&self, streamDescriptor: &IMediaStreamDescriptor, keyIdentifier: &[u8], licenseData: &[u8]) -> Result<()> {
        let hr = ((*self.lpVtbl).AddProtectionKey)(self as *const _ as *mut _, streamDescriptor as *const _ as *mut _, keyIdentifier.len() as u32, keyIdentifier.as_ptr() as *mut _, licenseData.len() as u32, licenseData.as_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSource: IMediaStreamSource}
impl RtActivatable<IMediaStreamSourceFactory> for MediaStreamSource {}
impl MediaStreamSource {
    #[inline] pub fn create_from_descriptor(descriptor: &IMediaStreamDescriptor) -> Result<ComPtr<MediaStreamSource>> { unsafe {
        <Self as RtActivatable<IMediaStreamSourceFactory>>::get_activation_factory().create_from_descriptor(descriptor)
    }}
    #[inline] pub fn create_from_descriptors(descriptor: &IMediaStreamDescriptor, descriptor2: &IMediaStreamDescriptor) -> Result<ComPtr<MediaStreamSource>> { unsafe {
        <Self as RtActivatable<IMediaStreamSourceFactory>>::get_activation_factory().create_from_descriptors(descriptor, descriptor2)
    }}
}
DEFINE_CLSID!(MediaStreamSource(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,77,101,100,105,97,83,116,114,101,97,109,83,111,117,114,99,101,0]) [CLSID_MediaStreamSource]);
DEFINE_IID!(IID_IMediaStreamSource2, 3965046957, 11882, 20340, 173, 187, 181, 98, 209, 83, 56, 73);
RT_INTERFACE!{interface IMediaStreamSource2(IMediaStreamSource2Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSource2] {
    fn add_SampleRendered(&self, handler: *mut super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceSampleRenderedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SampleRendered(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IMediaStreamSource2 {
    #[inline] pub unsafe fn add_sample_rendered(&self, handler: &super::super::foundation::TypedEventHandler<MediaStreamSource, MediaStreamSourceSampleRenderedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SampleRendered)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sample_rendered(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SampleRendered)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamSource3, 1781147462, 15837, 19935, 161, 33, 148, 4, 94, 207, 148, 64);
RT_INTERFACE!{interface IMediaStreamSource3(IMediaStreamSource3Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSource3] {
    fn put_MaxSupportedPlaybackRate(&self, value: *mut super::super::foundation::IReference<f64>) -> HRESULT,
    fn get_MaxSupportedPlaybackRate(&self, out: *mut *mut super::super::foundation::IReference<f64>) -> HRESULT
}}
impl IMediaStreamSource3 {
    #[inline] pub unsafe fn set_max_supported_playback_rate(&self, value: &super::super::foundation::IReference<f64>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxSupportedPlaybackRate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_supported_playback_rate(&self) -> Result<ComPtr<super::super::foundation::IReference<f64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxSupportedPlaybackRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamSource4, 487390379, 33549, 16764, 163, 169, 36, 84, 253, 100, 21, 199);
RT_INTERFACE!{interface IMediaStreamSource4(IMediaStreamSource4Vtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSource4] {
    fn put_IsLive(&self, value: bool) -> HRESULT,
    fn get_IsLive(&self, out: *mut bool) -> HRESULT
}}
impl IMediaStreamSource4 {
    #[inline] pub unsafe fn set_is_live(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsLive)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_live(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsLive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamSourceClosedEventArgs, 3448536754, 18454, 20004, 136, 240, 73, 30, 247, 56, 100, 6);
RT_INTERFACE!{interface IMediaStreamSourceClosedEventArgs(IMediaStreamSourceClosedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceClosedEventArgs] {
    fn get_Request(&self, out: *mut *mut MediaStreamSourceClosedRequest) -> HRESULT
}}
impl IMediaStreamSourceClosedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<MediaStreamSourceClosedRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceClosedEventArgs: IMediaStreamSourceClosedEventArgs}
RT_ENUM! { enum MediaStreamSourceClosedReason: i32 {
    Done (MediaStreamSourceClosedReason_Done) = 0, UnknownError (MediaStreamSourceClosedReason_UnknownError) = 1, AppReportedError (MediaStreamSourceClosedReason_AppReportedError) = 2, UnsupportedProtectionSystem (MediaStreamSourceClosedReason_UnsupportedProtectionSystem) = 3, ProtectionSystemFailure (MediaStreamSourceClosedReason_ProtectionSystemFailure) = 4, UnsupportedEncodingFormat (MediaStreamSourceClosedReason_UnsupportedEncodingFormat) = 5, MissingSampleRequestedEventHandler (MediaStreamSourceClosedReason_MissingSampleRequestedEventHandler) = 6,
}}
DEFINE_IID!(IID_IMediaStreamSourceClosedRequest, 2424045801, 6307, 18769, 136, 122, 44, 30, 235, 213, 198, 158);
RT_INTERFACE!{interface IMediaStreamSourceClosedRequest(IMediaStreamSourceClosedRequestVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceClosedRequest] {
    fn get_Reason(&self, out: *mut MediaStreamSourceClosedReason) -> HRESULT
}}
impl IMediaStreamSourceClosedRequest {
    #[inline] pub unsafe fn get_reason(&self) -> Result<MediaStreamSourceClosedReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Reason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceClosedRequest: IMediaStreamSourceClosedRequest}
RT_ENUM! { enum MediaStreamSourceErrorStatus: i32 {
    Other (MediaStreamSourceErrorStatus_Other) = 0, OutOfMemory (MediaStreamSourceErrorStatus_OutOfMemory) = 1, FailedToOpenFile (MediaStreamSourceErrorStatus_FailedToOpenFile) = 2, FailedToConnectToServer (MediaStreamSourceErrorStatus_FailedToConnectToServer) = 3, ConnectionToServerLost (MediaStreamSourceErrorStatus_ConnectionToServerLost) = 4, UnspecifiedNetworkError (MediaStreamSourceErrorStatus_UnspecifiedNetworkError) = 5, DecodeError (MediaStreamSourceErrorStatus_DecodeError) = 6, UnsupportedMediaFormat (MediaStreamSourceErrorStatus_UnsupportedMediaFormat) = 7,
}}
DEFINE_IID!(IID_IMediaStreamSourceFactory, 4017610969, 53592, 19322, 134, 63, 32, 51, 66, 251, 253, 65);
RT_INTERFACE!{static interface IMediaStreamSourceFactory(IMediaStreamSourceFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceFactory] {
    fn CreateFromDescriptor(&self, descriptor: *mut IMediaStreamDescriptor, out: *mut *mut MediaStreamSource) -> HRESULT,
    fn CreateFromDescriptors(&self, descriptor: *mut IMediaStreamDescriptor, descriptor2: *mut IMediaStreamDescriptor, out: *mut *mut MediaStreamSource) -> HRESULT
}}
impl IMediaStreamSourceFactory {
    #[inline] pub unsafe fn create_from_descriptor(&self, descriptor: &IMediaStreamDescriptor) -> Result<ComPtr<MediaStreamSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromDescriptor)(self as *const _ as *mut _, descriptor as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_descriptors(&self, descriptor: &IMediaStreamDescriptor, descriptor2: &IMediaStreamDescriptor) -> Result<ComPtr<MediaStreamSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromDescriptors)(self as *const _ as *mut _, descriptor as *const _ as *mut _, descriptor2 as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaStreamSourceSampleRenderedEventArgs, 2640935685, 54514, 19578, 157, 254, 141, 108, 208, 179, 238, 132);
RT_INTERFACE!{interface IMediaStreamSourceSampleRenderedEventArgs(IMediaStreamSourceSampleRenderedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSampleRenderedEventArgs] {
    fn get_SampleLag(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT
}}
impl IMediaStreamSourceSampleRenderedEventArgs {
    #[inline] pub unsafe fn get_sample_lag(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SampleLag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSampleRenderedEventArgs: IMediaStreamSourceSampleRenderedEventArgs}
DEFINE_IID!(IID_IMediaStreamSourceSampleRequest, 1303593385, 13569, 19867, 131, 249, 143, 35, 92, 130, 37, 50);
RT_INTERFACE!{interface IMediaStreamSourceSampleRequest(IMediaStreamSourceSampleRequestVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSampleRequest] {
    fn get_StreamDescriptor(&self, out: *mut *mut IMediaStreamDescriptor) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut MediaStreamSourceSampleRequestDeferral) -> HRESULT,
    fn put_Sample(&self, value: *mut MediaStreamSample) -> HRESULT,
    fn get_Sample(&self, out: *mut *mut MediaStreamSample) -> HRESULT,
    fn ReportSampleProgress(&self, progress: u32) -> HRESULT
}}
impl IMediaStreamSourceSampleRequest {
    #[inline] pub unsafe fn get_stream_descriptor(&self) -> Result<ComPtr<IMediaStreamDescriptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StreamDescriptor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<MediaStreamSourceSampleRequestDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sample(&self, value: &MediaStreamSample) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Sample)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sample(&self) -> Result<ComPtr<MediaStreamSample>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Sample)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn report_sample_progress(&self, progress: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).ReportSampleProgress)(self as *const _ as *mut _, progress);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSampleRequest: IMediaStreamSourceSampleRequest}
DEFINE_IID!(IID_IMediaStreamSourceSampleRequestDeferral, 2023083010, 63874, 17352, 157, 22, 198, 45, 153, 147, 25, 190);
RT_INTERFACE!{interface IMediaStreamSourceSampleRequestDeferral(IMediaStreamSourceSampleRequestDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSampleRequestDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IMediaStreamSourceSampleRequestDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSampleRequestDeferral: IMediaStreamSourceSampleRequestDeferral}
DEFINE_IID!(IID_IMediaStreamSourceSampleRequestedEventArgs, 284801950, 29125, 18735, 132, 127, 13, 161, 243, 94, 129, 248);
RT_INTERFACE!{interface IMediaStreamSourceSampleRequestedEventArgs(IMediaStreamSourceSampleRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSampleRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut MediaStreamSourceSampleRequest) -> HRESULT
}}
impl IMediaStreamSourceSampleRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<MediaStreamSourceSampleRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSampleRequestedEventArgs: IMediaStreamSourceSampleRequestedEventArgs}
DEFINE_IID!(IID_IMediaStreamSourceStartingEventArgs, 4094978290, 49780, 18752, 165, 187, 40, 165, 114, 69, 47, 167);
RT_INTERFACE!{interface IMediaStreamSourceStartingEventArgs(IMediaStreamSourceStartingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceStartingEventArgs] {
    fn get_Request(&self, out: *mut *mut MediaStreamSourceStartingRequest) -> HRESULT
}}
impl IMediaStreamSourceStartingEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<MediaStreamSourceStartingRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceStartingEventArgs: IMediaStreamSourceStartingEventArgs}
DEFINE_IID!(IID_IMediaStreamSourceStartingRequest, 714118116, 13764, 19227, 167, 145, 13, 153, 219, 86, 221, 29);
RT_INTERFACE!{interface IMediaStreamSourceStartingRequest(IMediaStreamSourceStartingRequestVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceStartingRequest] {
    fn get_StartPosition(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut MediaStreamSourceStartingRequestDeferral) -> HRESULT,
    fn SetActualStartPosition(&self, position: super::super::foundation::TimeSpan) -> HRESULT
}}
impl IMediaStreamSourceStartingRequest {
    #[inline] pub unsafe fn get_start_position(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StartPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<MediaStreamSourceStartingRequestDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_actual_start_position(&self, position: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).SetActualStartPosition)(self as *const _ as *mut _, position);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceStartingRequest: IMediaStreamSourceStartingRequest}
DEFINE_IID!(IID_IMediaStreamSourceStartingRequestDeferral, 1058231973, 25408, 19908, 153, 16, 6, 142, 217, 245, 152, 248);
RT_INTERFACE!{interface IMediaStreamSourceStartingRequestDeferral(IMediaStreamSourceStartingRequestDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceStartingRequestDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IMediaStreamSourceStartingRequestDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceStartingRequestDeferral: IMediaStreamSourceStartingRequestDeferral}
DEFINE_IID!(IID_IMediaStreamSourceSwitchStreamsRequest, 1102610574, 14505, 20163, 155, 160, 182, 155, 133, 80, 30, 144);
RT_INTERFACE!{interface IMediaStreamSourceSwitchStreamsRequest(IMediaStreamSourceSwitchStreamsRequestVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSwitchStreamsRequest] {
    fn get_OldStreamDescriptor(&self, out: *mut *mut IMediaStreamDescriptor) -> HRESULT,
    fn get_NewStreamDescriptor(&self, out: *mut *mut IMediaStreamDescriptor) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut MediaStreamSourceSwitchStreamsRequestDeferral) -> HRESULT
}}
impl IMediaStreamSourceSwitchStreamsRequest {
    #[inline] pub unsafe fn get_old_stream_descriptor(&self) -> Result<ComPtr<IMediaStreamDescriptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OldStreamDescriptor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_stream_descriptor(&self) -> Result<ComPtr<IMediaStreamDescriptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewStreamDescriptor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<MediaStreamSourceSwitchStreamsRequestDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSwitchStreamsRequest: IMediaStreamSourceSwitchStreamsRequest}
DEFINE_IID!(IID_IMediaStreamSourceSwitchStreamsRequestDeferral, 3202603061, 42245, 20378, 185, 67, 43, 140, 177, 180, 187, 217);
RT_INTERFACE!{interface IMediaStreamSourceSwitchStreamsRequestDeferral(IMediaStreamSourceSwitchStreamsRequestDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSwitchStreamsRequestDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IMediaStreamSourceSwitchStreamsRequestDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSwitchStreamsRequestDeferral: IMediaStreamSourceSwitchStreamsRequestDeferral}
DEFINE_IID!(IID_IMediaStreamSourceSwitchStreamsRequestedEventArgs, 1109404530, 28321, 18039, 152, 30, 53, 10, 13, 164, 18, 170);
RT_INTERFACE!{interface IMediaStreamSourceSwitchStreamsRequestedEventArgs(IMediaStreamSourceSwitchStreamsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaStreamSourceSwitchStreamsRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut MediaStreamSourceSwitchStreamsRequest) -> HRESULT
}}
impl IMediaStreamSourceSwitchStreamsRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<MediaStreamSourceSwitchStreamsRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaStreamSourceSwitchStreamsRequestedEventArgs: IMediaStreamSourceSwitchStreamsRequestedEventArgs}
DEFINE_IID!(IID_IMediaTrack, 65141500, 51505, 18714, 180, 107, 193, 14, 232, 194, 86, 183);
RT_INTERFACE!{interface IMediaTrack(IMediaTrackVtbl): IInspectable(IInspectableVtbl) [IID_IMediaTrack] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TrackKind(&self, out: *mut MediaTrackKind) -> HRESULT,
    fn put_Label(&self, value: HSTRING) -> HRESULT,
    fn get_Label(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaTrack {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_track_kind(&self) -> Result<MediaTrackKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TrackKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_label(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Label)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_label(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Label)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum MediaTrackKind: i32 {
    Audio (MediaTrackKind_Audio) = 0, Video (MediaTrackKind_Video) = 1, TimedMetadata (MediaTrackKind_TimedMetadata) = 2,
}}
RT_ENUM! { enum MseAppendMode: i32 {
    Segments (MseAppendMode_Segments) = 0, Sequence (MseAppendMode_Sequence) = 1,
}}
RT_ENUM! { enum MseEndOfStreamStatus: i32 {
    Success (MseEndOfStreamStatus_Success) = 0, NetworkError (MseEndOfStreamStatus_NetworkError) = 1, DecodeError (MseEndOfStreamStatus_DecodeError) = 2, UnknownError (MseEndOfStreamStatus_UnknownError) = 3,
}}
RT_ENUM! { enum MseReadyState: i32 {
    Closed (MseReadyState_Closed) = 0, Open (MseReadyState_Open) = 1, Ended (MseReadyState_Ended) = 2,
}}
DEFINE_IID!(IID_IMseSourceBuffer, 203072483, 57229, 16505, 163, 254, 104, 73, 24, 75, 78, 47);
RT_INTERFACE!{interface IMseSourceBuffer(IMseSourceBufferVtbl): IInspectable(IInspectableVtbl) [IID_IMseSourceBuffer] {
    fn add_UpdateStarting(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UpdateStarting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Updated(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Updated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_UpdateEnded(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UpdateEnded(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ErrorOccurred(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ErrorOccurred(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Aborted(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Aborted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Mode(&self, out: *mut MseAppendMode) -> HRESULT,
    fn put_Mode(&self, value: MseAppendMode) -> HRESULT,
    fn get_IsUpdating(&self, out: *mut bool) -> HRESULT,
    fn get_Buffered(&self, out: *mut *mut super::super::foundation::collections::IVectorView<MseTimeRange>) -> HRESULT,
    fn get_TimestampOffset(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_TimestampOffset(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_AppendWindowStart(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_AppendWindowStart(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_AppendWindowEnd(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_AppendWindowEnd(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy20(&self) -> (),
    #[cfg(feature="windows-storage")] fn AppendBuffer(&self, buffer: *mut super::super::storage::streams::IBuffer) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy21(&self) -> (),
    #[cfg(feature="windows-storage")] fn AppendStream(&self, stream: *mut super::super::storage::streams::IInputStream) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy22(&self) -> (),
    #[cfg(feature="windows-storage")] fn AppendStreamMaxSize(&self, stream: *mut super::super::storage::streams::IInputStream, maxSize: u64) -> HRESULT,
    fn Abort(&self) -> HRESULT,
    fn Remove(&self, start: super::super::foundation::TimeSpan, end: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT
}}
impl IMseSourceBuffer {
    #[inline] pub unsafe fn add_update_starting(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UpdateStarting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_update_starting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UpdateStarting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_updated(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Updated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_updated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Updated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_update_ended(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UpdateEnded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_update_ended(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UpdateEnded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_error_occurred(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ErrorOccurred)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_error_occurred(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ErrorOccurred)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_aborted(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBuffer, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Aborted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_aborted(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Aborted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<MseAppendMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: MseAppendMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_updating(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsUpdating)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_buffered(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MseTimeRange>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Buffered)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp_offset(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimestampOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_timestamp_offset(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TimestampOffset)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_append_window_start(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AppendWindowStart)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_append_window_start(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppendWindowStart)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_append_window_end(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppendWindowEnd)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_append_window_end(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppendWindowEnd)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn append_buffer(&self, buffer: &super::super::storage::streams::IBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendBuffer)(self as *const _ as *mut _, buffer as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn append_stream(&self, stream: &super::super::storage::streams::IInputStream) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendStream)(self as *const _ as *mut _, stream as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn append_stream_max_size(&self, stream: &super::super::storage::streams::IInputStream, maxSize: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).AppendStreamMaxSize)(self as *const _ as *mut _, stream as *const _ as *mut _, maxSize);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn abort(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Abort)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove(&self, start: super::super::foundation::TimeSpan, end: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).Remove)(self as *const _ as *mut _, start, end as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MseSourceBuffer: IMseSourceBuffer}
DEFINE_IID!(IID_IMseSourceBufferList, 2516248807, 43239, 20159, 137, 39, 20, 94, 148, 11, 165, 17);
RT_INTERFACE!{interface IMseSourceBufferList(IMseSourceBufferListVtbl): IInspectable(IInspectableVtbl) [IID_IMseSourceBufferList] {
    fn add_SourceBufferAdded(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBufferList, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourceBufferAdded(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SourceBufferRemoved(&self, handler: *mut super::super::foundation::TypedEventHandler<MseSourceBufferList, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourceBufferRemoved(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Buffers(&self, out: *mut *mut super::super::foundation::collections::IVectorView<MseSourceBuffer>) -> HRESULT
}}
impl IMseSourceBufferList {
    #[inline] pub unsafe fn add_source_buffer_added(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBufferList, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourceBufferAdded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_buffer_added(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourceBufferAdded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_source_buffer_removed(&self, handler: &super::super::foundation::TypedEventHandler<MseSourceBufferList, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourceBufferRemoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_buffer_removed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourceBufferRemoved)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_buffers(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<MseSourceBuffer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Buffers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MseSourceBufferList: IMseSourceBufferList}
DEFINE_IID!(IID_IMseStreamSource, 2964593037, 756, 18723, 136, 221, 129, 188, 63, 54, 15, 250);
RT_INTERFACE!{interface IMseStreamSource(IMseStreamSourceVtbl): IInspectable(IInspectableVtbl) [IID_IMseStreamSource] {
    fn add_Opened(&self, handler: *mut super::super::foundation::TypedEventHandler<MseStreamSource, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Opened(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Ended(&self, handler: *mut super::super::foundation::TypedEventHandler<MseStreamSource, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Ended(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, handler: *mut super::super::foundation::TypedEventHandler<MseStreamSource, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_SourceBuffers(&self, out: *mut *mut MseSourceBufferList) -> HRESULT,
    fn get_ActiveSourceBuffers(&self, out: *mut *mut MseSourceBufferList) -> HRESULT,
    fn get_ReadyState(&self, out: *mut MseReadyState) -> HRESULT,
    fn get_Duration(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn put_Duration(&self, value: *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn AddSourceBuffer(&self, mimeType: HSTRING, out: *mut *mut MseSourceBuffer) -> HRESULT,
    fn RemoveSourceBuffer(&self, buffer: *mut MseSourceBuffer) -> HRESULT,
    fn EndOfStream(&self, status: MseEndOfStreamStatus) -> HRESULT
}}
impl IMseStreamSource {
    #[inline] pub unsafe fn add_opened(&self, handler: &super::super::foundation::TypedEventHandler<MseStreamSource, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Opened)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_opened(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Opened)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_ended(&self, handler: &super::super::foundation::TypedEventHandler<MseStreamSource, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Ended)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_ended(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Ended)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, handler: &super::super::foundation::TypedEventHandler<MseStreamSource, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_buffers(&self) -> Result<ComPtr<MseSourceBufferList>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceBuffers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_active_source_buffers(&self) -> Result<ComPtr<MseSourceBufferList>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActiveSourceBuffers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ready_state(&self) -> Result<MseReadyState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ReadyState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_duration(&self, value: &super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Duration)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_source_buffer(&self, mimeType: &HStringArg) -> Result<ComPtr<MseSourceBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AddSourceBuffer)(self as *const _ as *mut _, mimeType.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_buffer(&self, buffer: &MseSourceBuffer) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveSourceBuffer)(self as *const _ as *mut _, buffer as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_of_stream(&self, status: MseEndOfStreamStatus) -> Result<()> {
        let hr = ((*self.lpVtbl).EndOfStream)(self as *const _ as *mut _, status);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MseStreamSource: IMseStreamSource}
impl RtActivatable<IMseStreamSourceStatics> for MseStreamSource {}
impl RtActivatable<IActivationFactory> for MseStreamSource {}
impl MseStreamSource {
    #[inline] pub fn is_content_type_supported(contentType: &HStringArg) -> Result<bool> { unsafe {
        <Self as RtActivatable<IMseStreamSourceStatics>>::get_activation_factory().is_content_type_supported(contentType)
    }}
}
DEFINE_CLSID!(MseStreamSource(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,77,115,101,83,116,114,101,97,109,83,111,117,114,99,101,0]) [CLSID_MseStreamSource]);
DEFINE_IID!(IID_IMseStreamSource2, 1727364407, 63975, 16778, 156, 222, 160, 32, 233, 86, 85, 43);
RT_INTERFACE!{interface IMseStreamSource2(IMseStreamSource2Vtbl): IInspectable(IInspectableVtbl) [IID_IMseStreamSource2] {
    fn get_LiveSeekableRange(&self, out: *mut *mut super::super::foundation::IReference<MseTimeRange>) -> HRESULT,
    fn put_LiveSeekableRange(&self, value: *mut super::super::foundation::IReference<MseTimeRange>) -> HRESULT
}}
impl IMseStreamSource2 {
    #[inline] pub unsafe fn get_live_seekable_range(&self) -> Result<ComPtr<super::super::foundation::IReference<MseTimeRange>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LiveSeekableRange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_live_seekable_range(&self, value: &super::super::foundation::IReference<MseTimeRange>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LiveSeekableRange)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMseStreamSourceStatics, 1180460957, 54640, 17358, 186, 33, 11, 255, 95, 63, 189, 10);
RT_INTERFACE!{static interface IMseStreamSourceStatics(IMseStreamSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMseStreamSourceStatics] {
    fn IsContentTypeSupported(&self, contentType: HSTRING, out: *mut bool) -> HRESULT
}}
impl IMseStreamSourceStatics {
    #[inline] pub unsafe fn is_content_type_supported(&self, contentType: &HStringArg) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsContentTypeSupported)(self as *const _ as *mut _, contentType.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_STRUCT! { struct MseTimeRange {
    Start: super::super::foundation::TimeSpan, End: super::super::foundation::TimeSpan,
}}
DEFINE_IID!(IID_ISceneAnalysisEffect, 3226182425, 51777, 18451, 191, 253, 123, 8, 176, 237, 37, 87);
RT_INTERFACE!{interface ISceneAnalysisEffect(ISceneAnalysisEffectVtbl): IInspectable(IInspectableVtbl) [IID_ISceneAnalysisEffect] {
    fn get_HighDynamicRangeAnalyzer(&self, out: *mut *mut HighDynamicRangeControl) -> HRESULT,
    fn put_DesiredAnalysisInterval(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_DesiredAnalysisInterval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn add_SceneAnalyzed(&self, handler: *mut super::super::foundation::TypedEventHandler<SceneAnalysisEffect, SceneAnalyzedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SceneAnalyzed(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISceneAnalysisEffect {
    #[inline] pub unsafe fn get_high_dynamic_range_analyzer(&self) -> Result<ComPtr<HighDynamicRangeControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HighDynamicRangeAnalyzer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_analysis_interval(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredAnalysisInterval)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_analysis_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredAnalysisInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_scene_analyzed(&self, handler: &super::super::foundation::TypedEventHandler<SceneAnalysisEffect, SceneAnalyzedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SceneAnalyzed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_scene_analyzed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SceneAnalyzed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SceneAnalysisEffect: ISceneAnalysisEffect}
RT_CLASS!{class SceneAnalysisEffectDefinition: super::effects::IVideoEffectDefinition}
impl RtActivatable<IActivationFactory> for SceneAnalysisEffectDefinition {}
DEFINE_CLSID!(SceneAnalysisEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,83,99,101,110,101,65,110,97,108,121,115,105,115,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_SceneAnalysisEffectDefinition]);
DEFINE_IID!(IID_ISceneAnalysisEffectFrame, 3635482188, 32729, 17121, 133, 235, 101, 114, 194, 151, 201, 135);
RT_INTERFACE!{interface ISceneAnalysisEffectFrame(ISceneAnalysisEffectFrameVtbl): IInspectable(IInspectableVtbl) [IID_ISceneAnalysisEffectFrame] {
    fn get_FrameControlValues(&self, out: *mut *mut super::capture::CapturedFrameControlValues) -> HRESULT,
    fn get_HighDynamicRange(&self, out: *mut *mut HighDynamicRangeOutput) -> HRESULT
}}
impl ISceneAnalysisEffectFrame {
    #[inline] pub unsafe fn get_frame_control_values(&self) -> Result<ComPtr<super::capture::CapturedFrameControlValues>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FrameControlValues)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_high_dynamic_range(&self) -> Result<ComPtr<HighDynamicRangeOutput>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HighDynamicRange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SceneAnalysisEffectFrame: ISceneAnalysisEffectFrame}
DEFINE_IID!(IID_ISceneAnalysisEffectFrame2, 760097214, 1567, 18350, 153, 21, 2, 82, 75, 95, 154, 95);
RT_INTERFACE!{interface ISceneAnalysisEffectFrame2(ISceneAnalysisEffectFrame2Vtbl): IInspectable(IInspectableVtbl) [IID_ISceneAnalysisEffectFrame2] {
    fn get_AnalysisRecommendation(&self, out: *mut SceneAnalysisRecommendation) -> HRESULT
}}
impl ISceneAnalysisEffectFrame2 {
    #[inline] pub unsafe fn get_analysis_recommendation(&self) -> Result<SceneAnalysisRecommendation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AnalysisRecommendation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum SceneAnalysisRecommendation: i32 {
    Standard (SceneAnalysisRecommendation_Standard) = 0, Hdr (SceneAnalysisRecommendation_Hdr) = 1, LowLight (SceneAnalysisRecommendation_LowLight) = 2,
}}
DEFINE_IID!(IID_ISceneAnalyzedEventArgs, 342594952, 10321, 17892, 173, 85, 68, 207, 141, 248, 219, 77);
RT_INTERFACE!{interface ISceneAnalyzedEventArgs(ISceneAnalyzedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISceneAnalyzedEventArgs] {
    fn get_ResultFrame(&self, out: *mut *mut SceneAnalysisEffectFrame) -> HRESULT
}}
impl ISceneAnalyzedEventArgs {
    #[inline] pub unsafe fn get_result_frame(&self) -> Result<ComPtr<SceneAnalysisEffectFrame>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ResultFrame)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SceneAnalyzedEventArgs: ISceneAnalyzedEventArgs}
DEFINE_IID!(IID_ISingleSelectMediaTrackList, 1998614303, 49999, 18767, 128, 119, 43, 173, 159, 244, 236, 241);
RT_INTERFACE!{interface ISingleSelectMediaTrackList(ISingleSelectMediaTrackListVtbl): IInspectable(IInspectableVtbl) [IID_ISingleSelectMediaTrackList] {
    fn add_SelectedIndexChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<ISingleSelectMediaTrackList, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SelectedIndexChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn put_SelectedIndex(&self, value: i32) -> HRESULT,
    fn get_SelectedIndex(&self, out: *mut i32) -> HRESULT
}}
impl ISingleSelectMediaTrackList {
    #[inline] pub unsafe fn add_selected_index_changed(&self, handler: &super::super::foundation::TypedEventHandler<ISingleSelectMediaTrackList, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SelectedIndexChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_selected_index_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SelectedIndexChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected_index(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectedIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpeechCue, 2934068444, 5925, 19373, 128, 67, 169, 132, 153, 176, 23, 162);
RT_INTERFACE!{interface ISpeechCue(ISpeechCueVtbl): IInspectable(IInspectableVtbl) [IID_ISpeechCue] {
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn get_StartPositionInInput(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_StartPositionInInput(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn get_EndPositionInInput(&self, out: *mut *mut super::super::foundation::IReference<i32>) -> HRESULT,
    fn put_EndPositionInInput(&self, value: *mut super::super::foundation::IReference<i32>) -> HRESULT
}}
impl ISpeechCue {
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_position_in_input(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StartPositionInInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_position_in_input(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartPositionInInput)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_end_position_in_input(&self) -> Result<ComPtr<super::super::foundation::IReference<i32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EndPositionInInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_end_position_in_input(&self, value: &super::super::foundation::IReference<i32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EndPositionInInput)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SpeechCue: ISpeechCue}
impl RtActivatable<IActivationFactory> for SpeechCue {}
DEFINE_CLSID!(SpeechCue(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,83,112,101,101,99,104,67,117,101,0]) [CLSID_SpeechCue]);
RT_ENUM! { enum TimedMetadataKind: i32 {
    Caption (TimedMetadataKind_Caption) = 0, Chapter (TimedMetadataKind_Chapter) = 1, Custom (TimedMetadataKind_Custom) = 2, Data (TimedMetadataKind_Data) = 3, Description (TimedMetadataKind_Description) = 4, Subtitle (TimedMetadataKind_Subtitle) = 5, ImageSubtitle (TimedMetadataKind_ImageSubtitle) = 6, Speech (TimedMetadataKind_Speech) = 7,
}}
DEFINE_IID!(IID_ITimedMetadataTrack, 2657807774, 63098, 18857, 179, 48, 207, 3, 176, 233, 207, 7);
RT_INTERFACE!{interface ITimedMetadataTrack(ITimedMetadataTrackVtbl): IInspectable(IInspectableVtbl) [IID_ITimedMetadataTrack] {
    fn add_CueEntered(&self, handler: *mut super::super::foundation::TypedEventHandler<TimedMetadataTrack, MediaCueEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CueEntered(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CueExited(&self, handler: *mut super::super::foundation::TypedEventHandler<TimedMetadataTrack, MediaCueEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CueExited(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_TrackFailed(&self, handler: *mut super::super::foundation::TypedEventHandler<TimedMetadataTrack, TimedMetadataTrackFailedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TrackFailed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_Cues(&self, out: *mut *mut super::super::foundation::collections::IVectorView<IMediaCue>) -> HRESULT,
    fn get_ActiveCues(&self, out: *mut *mut super::super::foundation::collections::IVectorView<IMediaCue>) -> HRESULT,
    fn get_TimedMetadataKind(&self, out: *mut TimedMetadataKind) -> HRESULT,
    fn get_DispatchType(&self, out: *mut HSTRING) -> HRESULT,
    fn AddCue(&self, cue: *mut IMediaCue) -> HRESULT,
    fn RemoveCue(&self, cue: *mut IMediaCue) -> HRESULT
}}
impl ITimedMetadataTrack {
    #[inline] pub unsafe fn add_cue_entered(&self, handler: &super::super::foundation::TypedEventHandler<TimedMetadataTrack, MediaCueEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CueEntered)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_cue_entered(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CueEntered)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_cue_exited(&self, handler: &super::super::foundation::TypedEventHandler<TimedMetadataTrack, MediaCueEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CueExited)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_cue_exited(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CueExited)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_track_failed(&self, handler: &super::super::foundation::TypedEventHandler<TimedMetadataTrack, TimedMetadataTrackFailedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TrackFailed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_track_failed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TrackFailed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cues(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<IMediaCue>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Cues)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_active_cues(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<IMediaCue>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActiveCues)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timed_metadata_kind(&self) -> Result<TimedMetadataKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimedMetadataKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dispatch_type(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DispatchType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_cue(&self, cue: &IMediaCue) -> Result<()> {
        let hr = ((*self.lpVtbl).AddCue)(self as *const _ as *mut _, cue as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_cue(&self, cue: &IMediaCue) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveCue)(self as *const _ as *mut _, cue as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TimedMetadataTrack: ITimedMetadataTrack}
impl RtActivatable<ITimedMetadataTrackFactory> for TimedMetadataTrack {}
impl TimedMetadataTrack {
    #[inline] pub fn create(id: &HStringArg, language: &HStringArg, kind: TimedMetadataKind) -> Result<ComPtr<TimedMetadataTrack>> { unsafe {
        <Self as RtActivatable<ITimedMetadataTrackFactory>>::get_activation_factory().create(id, language, kind)
    }}
}
DEFINE_CLSID!(TimedMetadataTrack(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,77,101,116,97,100,97,116,97,84,114,97,99,107,0]) [CLSID_TimedMetadataTrack]);
DEFINE_IID!(IID_ITimedMetadataTrack2, 565491272, 40861, 16570, 168, 243, 26, 146, 117, 58, 239, 11);
RT_INTERFACE!{interface ITimedMetadataTrack2(ITimedMetadataTrack2Vtbl): IInspectable(IInspectableVtbl) [IID_ITimedMetadataTrack2] {
    fn get_PlaybackItem(&self, out: *mut *mut super::playback::MediaPlaybackItem) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT
}}
impl ITimedMetadataTrack2 {
    #[inline] pub unsafe fn get_playback_item(&self) -> Result<ComPtr<super::playback::MediaPlaybackItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaybackItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITimedMetadataTrackError, 3010885909, 16660, 18457, 185, 217, 221, 118, 8, 158, 114, 248);
RT_INTERFACE!{interface ITimedMetadataTrackError(ITimedMetadataTrackErrorVtbl): IInspectable(IInspectableVtbl) [IID_ITimedMetadataTrackError] {
    fn get_ErrorCode(&self, out: *mut TimedMetadataTrackErrorCode) -> HRESULT,
    fn get_ExtendedError(&self, out: *mut super::super::foundation::HResult) -> HRESULT
}}
impl ITimedMetadataTrackError {
    #[inline] pub unsafe fn get_error_code(&self) -> Result<TimedMetadataTrackErrorCode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ErrorCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class TimedMetadataTrackError: ITimedMetadataTrackError}
RT_ENUM! { enum TimedMetadataTrackErrorCode: i32 {
    None (TimedMetadataTrackErrorCode_None) = 0, DataFormatError (TimedMetadataTrackErrorCode_DataFormatError) = 1, NetworkError (TimedMetadataTrackErrorCode_NetworkError) = 2, InternalError (TimedMetadataTrackErrorCode_InternalError) = 3,
}}
DEFINE_IID!(IID_ITimedMetadataTrackFactory, 2379576849, 38835, 19999, 133, 44, 15, 72, 44, 129, 173, 38);
RT_INTERFACE!{static interface ITimedMetadataTrackFactory(ITimedMetadataTrackFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ITimedMetadataTrackFactory] {
    fn Create(&self, id: HSTRING, language: HSTRING, kind: TimedMetadataKind, out: *mut *mut TimedMetadataTrack) -> HRESULT
}}
impl ITimedMetadataTrackFactory {
    #[inline] pub unsafe fn create(&self, id: &HStringArg, language: &HStringArg, kind: TimedMetadataKind) -> Result<ComPtr<TimedMetadataTrack>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, id.get(), language.get(), kind, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITimedMetadataTrackFailedEventArgs, 2776615377, 26505, 19789, 176, 127, 132, 180, 243, 26, 203, 112);
RT_INTERFACE!{interface ITimedMetadataTrackFailedEventArgs(ITimedMetadataTrackFailedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ITimedMetadataTrackFailedEventArgs] {
    fn get_Error(&self, out: *mut *mut TimedMetadataTrackError) -> HRESULT
}}
impl ITimedMetadataTrackFailedEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<ComPtr<TimedMetadataTrackError>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TimedMetadataTrackFailedEventArgs: ITimedMetadataTrackFailedEventArgs}
DEFINE_IID!(IID_ITimedMetadataTrackProvider, 998187044, 63310, 19166, 147, 197, 33, 157, 160, 91, 104, 86);
RT_INTERFACE!{interface ITimedMetadataTrackProvider(ITimedMetadataTrackProviderVtbl): IInspectable(IInspectableVtbl) [IID_ITimedMetadataTrackProvider] {
    fn get_TimedMetadataTracks(&self, out: *mut *mut super::super::foundation::collections::IVectorView<TimedMetadataTrack>) -> HRESULT
}}
impl ITimedMetadataTrackProvider {
    #[inline] pub unsafe fn get_timed_metadata_tracks(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<TimedMetadataTrack>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TimedMetadataTracks)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITimedTextCue, 1372036689, 15238, 18765, 179, 89, 187, 46, 167, 172, 169, 169);
RT_INTERFACE!{interface ITimedTextCue(ITimedTextCueVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextCue] {
    fn get_CueRegion(&self, out: *mut *mut TimedTextRegion) -> HRESULT,
    fn put_CueRegion(&self, value: *mut TimedTextRegion) -> HRESULT,
    fn get_CueStyle(&self, out: *mut *mut TimedTextStyle) -> HRESULT,
    fn put_CueStyle(&self, value: *mut TimedTextStyle) -> HRESULT,
    fn get_Lines(&self, out: *mut *mut super::super::foundation::collections::IVector<TimedTextLine>) -> HRESULT
}}
impl ITimedTextCue {
    #[inline] pub unsafe fn get_cue_region(&self) -> Result<ComPtr<TimedTextRegion>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CueRegion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cue_region(&self, value: &TimedTextRegion) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CueRegion)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cue_style(&self) -> Result<ComPtr<TimedTextStyle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CueStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cue_style(&self, value: &TimedTextStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CueStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lines(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<TimedTextLine>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Lines)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextCue: ITimedTextCue}
impl RtActivatable<IActivationFactory> for TimedTextCue {}
DEFINE_CLSID!(TimedTextCue(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,84,101,120,116,67,117,101,0]) [CLSID_TimedTextCue]);
RT_ENUM! { enum TimedTextDisplayAlignment: i32 {
    Before (TimedTextDisplayAlignment_Before) = 0, After (TimedTextDisplayAlignment_After) = 1, Center (TimedTextDisplayAlignment_Center) = 2,
}}
RT_STRUCT! { struct TimedTextDouble {
    Value: f64, Unit: TimedTextUnit,
}}
RT_ENUM! { enum TimedTextFlowDirection: i32 {
    LeftToRight (TimedTextFlowDirection_LeftToRight) = 0, RightToLeft (TimedTextFlowDirection_RightToLeft) = 1,
}}
RT_ENUM! { enum TimedTextFontStyle: i32 {
    Normal (TimedTextFontStyle_Normal) = 0, Oblique (TimedTextFontStyle_Oblique) = 1, Italic (TimedTextFontStyle_Italic) = 2,
}}
DEFINE_IID!(IID_ITimedTextLine, 2542632162, 29448, 19558, 190, 80, 101, 119, 114, 137, 245, 223);
RT_INTERFACE!{interface ITimedTextLine(ITimedTextLineVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextLine] {
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn get_Subformats(&self, out: *mut *mut super::super::foundation::collections::IVector<TimedTextSubformat>) -> HRESULT
}}
impl ITimedTextLine {
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subformats(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<TimedTextSubformat>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subformats)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextLine: ITimedTextLine}
impl RtActivatable<IActivationFactory> for TimedTextLine {}
DEFINE_CLSID!(TimedTextLine(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,84,101,120,116,76,105,110,101,0]) [CLSID_TimedTextLine]);
RT_ENUM! { enum TimedTextLineAlignment: i32 {
    Start (TimedTextLineAlignment_Start) = 0, End (TimedTextLineAlignment_End) = 1, Center (TimedTextLineAlignment_Center) = 2,
}}
RT_STRUCT! { struct TimedTextPadding {
    Before: f64, After: f64, Start: f64, End: f64, Unit: TimedTextUnit,
}}
RT_STRUCT! { struct TimedTextPoint {
    X: f64, Y: f64, Unit: TimedTextUnit,
}}
DEFINE_IID!(IID_ITimedTextRegion, 516982815, 35334, 16930, 159, 89, 178, 27, 244, 1, 36, 180);
RT_INTERFACE!{interface ITimedTextRegion(ITimedTextRegionVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextRegion] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_Position(&self, out: *mut TimedTextPoint) -> HRESULT,
    fn put_Position(&self, value: TimedTextPoint) -> HRESULT,
    fn get_Extent(&self, out: *mut TimedTextSize) -> HRESULT,
    fn put_Extent(&self, value: TimedTextSize) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_Background(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_Background(&self, value: super::super::ui::Color) -> HRESULT,
    fn get_WritingMode(&self, out: *mut TimedTextWritingMode) -> HRESULT,
    fn put_WritingMode(&self, value: TimedTextWritingMode) -> HRESULT,
    fn get_DisplayAlignment(&self, out: *mut TimedTextDisplayAlignment) -> HRESULT,
    fn put_DisplayAlignment(&self, value: TimedTextDisplayAlignment) -> HRESULT,
    fn get_LineHeight(&self, out: *mut TimedTextDouble) -> HRESULT,
    fn put_LineHeight(&self, value: TimedTextDouble) -> HRESULT,
    fn get_IsOverflowClipped(&self, out: *mut bool) -> HRESULT,
    fn put_IsOverflowClipped(&self, value: bool) -> HRESULT,
    fn get_Padding(&self, out: *mut TimedTextPadding) -> HRESULT,
    fn put_Padding(&self, value: TimedTextPadding) -> HRESULT,
    fn get_TextWrapping(&self, out: *mut TimedTextWrapping) -> HRESULT,
    fn put_TextWrapping(&self, value: TimedTextWrapping) -> HRESULT,
    fn get_ZIndex(&self, out: *mut i32) -> HRESULT,
    fn put_ZIndex(&self, value: i32) -> HRESULT,
    fn get_ScrollMode(&self, out: *mut TimedTextScrollMode) -> HRESULT,
    fn put_ScrollMode(&self, value: TimedTextScrollMode) -> HRESULT
}}
impl ITimedTextRegion {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<TimedTextPoint> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: TimedTextPoint) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extent(&self) -> Result<TimedTextSize> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Extent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_extent(&self, value: TimedTextSize) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Extent)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_background(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Background)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_background(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Background)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_writing_mode(&self) -> Result<TimedTextWritingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WritingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_writing_mode(&self, value: TimedTextWritingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WritingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_alignment(&self) -> Result<TimedTextDisplayAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisplayAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_alignment(&self, value: TimedTextDisplayAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_height(&self) -> Result<TimedTextDouble> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_line_height(&self, value: TimedTextDouble) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LineHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_overflow_clipped(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOverflowClipped)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_overflow_clipped(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOverflowClipped)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding(&self) -> Result<TimedTextPadding> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Padding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_padding(&self, value: TimedTextPadding) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Padding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_wrapping(&self) -> Result<TimedTextWrapping> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TextWrapping)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_wrapping(&self, value: TimedTextWrapping) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextWrapping)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zindex(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ZIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_zindex(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ZIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scroll_mode(&self) -> Result<TimedTextScrollMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScrollMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_scroll_mode(&self, value: TimedTextScrollMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ScrollMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextRegion: ITimedTextRegion}
impl RtActivatable<IActivationFactory> for TimedTextRegion {}
DEFINE_CLSID!(TimedTextRegion(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,84,101,120,116,82,101,103,105,111,110,0]) [CLSID_TimedTextRegion]);
RT_ENUM! { enum TimedTextScrollMode: i32 {
    Popon (TimedTextScrollMode_Popon) = 0, Rollup (TimedTextScrollMode_Rollup) = 1,
}}
RT_STRUCT! { struct TimedTextSize {
    Height: f64, Width: f64, Unit: TimedTextUnit,
}}
DEFINE_IID!(IID_ITimedTextSource, 3303906214, 4127, 16461, 169, 73, 130, 243, 63, 205, 147, 183);
RT_INTERFACE!{interface ITimedTextSource(ITimedTextSourceVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextSource] {
    fn add_Resolved(&self, handler: *mut super::super::foundation::TypedEventHandler<TimedTextSource, TimedTextSourceResolveResultEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Resolved(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ITimedTextSource {
    #[inline] pub unsafe fn add_resolved(&self, handler: &super::super::foundation::TypedEventHandler<TimedTextSource, TimedTextSourceResolveResultEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Resolved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resolved(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Resolved)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextSource: ITimedTextSource}
impl RtActivatable<ITimedTextSourceStatics> for TimedTextSource {}
impl RtActivatable<ITimedTextSourceStatics2> for TimedTextSource {}
impl TimedTextSource {
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream(stream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics>>::get_activation_factory().create_from_stream(stream)
    }}
    #[inline] pub fn create_from_uri(uri: &super::super::foundation::Uri) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics>>::get_activation_factory().create_from_uri(uri)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream_with_language(stream: &super::super::storage::streams::IRandomAccessStream, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics>>::get_activation_factory().create_from_stream_with_language(stream, defaultLanguage)
    }}
    #[inline] pub fn create_from_uri_with_language(uri: &super::super::foundation::Uri, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics>>::get_activation_factory().create_from_uri_with_language(uri, defaultLanguage)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream_with_index(stream: &super::super::storage::streams::IRandomAccessStream, indexStream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics2>>::get_activation_factory().create_from_stream_with_index(stream, indexStream)
    }}
    #[inline] pub fn create_from_uri_with_index(uri: &super::super::foundation::Uri, indexUri: &super::super::foundation::Uri) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics2>>::get_activation_factory().create_from_uri_with_index(uri, indexUri)
    }}
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_stream_with_index_and_language(stream: &super::super::storage::streams::IRandomAccessStream, indexStream: &super::super::storage::streams::IRandomAccessStream, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics2>>::get_activation_factory().create_from_stream_with_index_and_language(stream, indexStream, defaultLanguage)
    }}
    #[inline] pub fn create_from_uri_with_index_and_language(uri: &super::super::foundation::Uri, indexUri: &super::super::foundation::Uri, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> { unsafe {
        <Self as RtActivatable<ITimedTextSourceStatics2>>::get_activation_factory().create_from_uri_with_index_and_language(uri, indexUri, defaultLanguage)
    }}
}
DEFINE_CLSID!(TimedTextSource(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,84,101,120,116,83,111,117,114,99,101,0]) [CLSID_TimedTextSource]);
DEFINE_IID!(IID_ITimedTextSourceResolveResultEventArgs, 1217428636, 56536, 19507, 154, 211, 108, 220, 231, 177, 197, 102);
RT_INTERFACE!{interface ITimedTextSourceResolveResultEventArgs(ITimedTextSourceResolveResultEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextSourceResolveResultEventArgs] {
    fn get_Error(&self, out: *mut *mut TimedMetadataTrackError) -> HRESULT,
    fn get_Tracks(&self, out: *mut *mut super::super::foundation::collections::IVectorView<TimedMetadataTrack>) -> HRESULT
}}
impl ITimedTextSourceResolveResultEventArgs {
    #[inline] pub unsafe fn get_error(&self) -> Result<ComPtr<TimedMetadataTrackError>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Error)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tracks(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<TimedMetadataTrack>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tracks)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextSourceResolveResultEventArgs: ITimedTextSourceResolveResultEventArgs}
DEFINE_IID!(IID_ITimedTextSourceStatics, 2117146707, 39610, 19140, 187, 152, 47, 177, 118, 195, 191, 221);
RT_INTERFACE!{static interface ITimedTextSourceStatics(ITimedTextSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextSourceStatics] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStream(&self, stream: *mut super::super::storage::streams::IRandomAccessStream, out: *mut *mut TimedTextSource) -> HRESULT,
    fn CreateFromUri(&self, uri: *mut super::super::foundation::Uri, out: *mut *mut TimedTextSource) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStreamWithLanguage(&self, stream: *mut super::super::storage::streams::IRandomAccessStream, defaultLanguage: HSTRING, out: *mut *mut TimedTextSource) -> HRESULT,
    fn CreateFromUriWithLanguage(&self, uri: *mut super::super::foundation::Uri, defaultLanguage: HSTRING, out: *mut *mut TimedTextSource) -> HRESULT
}}
impl ITimedTextSourceStatics {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream(&self, stream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStream)(self as *const _ as *mut _, stream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_uri(&self, uri: &super::super::foundation::Uri) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromUri)(self as *const _ as *mut _, uri as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream_with_language(&self, stream: &super::super::storage::streams::IRandomAccessStream, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStreamWithLanguage)(self as *const _ as *mut _, stream as *const _ as *mut _, defaultLanguage.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_uri_with_language(&self, uri: &super::super::foundation::Uri, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromUriWithLanguage)(self as *const _ as *mut _, uri as *const _ as *mut _, defaultLanguage.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITimedTextSourceStatics2, 3060495874, 37438, 17402, 150, 51, 88, 112, 117, 129, 45, 181);
RT_INTERFACE!{static interface ITimedTextSourceStatics2(ITimedTextSourceStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextSourceStatics2] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStreamWithIndex(&self, stream: *mut super::super::storage::streams::IRandomAccessStream, indexStream: *mut super::super::storage::streams::IRandomAccessStream, out: *mut *mut TimedTextSource) -> HRESULT,
    fn CreateFromUriWithIndex(&self, uri: *mut super::super::foundation::Uri, indexUri: *mut super::super::foundation::Uri, out: *mut *mut TimedTextSource) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromStreamWithIndexAndLanguage(&self, stream: *mut super::super::storage::streams::IRandomAccessStream, indexStream: *mut super::super::storage::streams::IRandomAccessStream, defaultLanguage: HSTRING, out: *mut *mut TimedTextSource) -> HRESULT,
    fn CreateFromUriWithIndexAndLanguage(&self, uri: *mut super::super::foundation::Uri, indexUri: *mut super::super::foundation::Uri, defaultLanguage: HSTRING, out: *mut *mut TimedTextSource) -> HRESULT
}}
impl ITimedTextSourceStatics2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream_with_index(&self, stream: &super::super::storage::streams::IRandomAccessStream, indexStream: &super::super::storage::streams::IRandomAccessStream) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStreamWithIndex)(self as *const _ as *mut _, stream as *const _ as *mut _, indexStream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_uri_with_index(&self, uri: &super::super::foundation::Uri, indexUri: &super::super::foundation::Uri) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromUriWithIndex)(self as *const _ as *mut _, uri as *const _ as *mut _, indexUri as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_stream_with_index_and_language(&self, stream: &super::super::storage::streams::IRandomAccessStream, indexStream: &super::super::storage::streams::IRandomAccessStream, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromStreamWithIndexAndLanguage)(self as *const _ as *mut _, stream as *const _ as *mut _, indexStream as *const _ as *mut _, defaultLanguage.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_uri_with_index_and_language(&self, uri: &super::super::foundation::Uri, indexUri: &super::super::foundation::Uri, defaultLanguage: &HStringArg) -> Result<ComPtr<TimedTextSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromUriWithIndexAndLanguage)(self as *const _ as *mut _, uri as *const _ as *mut _, indexUri as *const _ as *mut _, defaultLanguage.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITimedTextStyle, 464664653, 43045, 16578, 167, 245, 40, 30, 174, 223, 59, 85);
RT_INTERFACE!{interface ITimedTextStyle(ITimedTextStyleVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextStyle] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_FontFamily(&self, out: *mut HSTRING) -> HRESULT,
    fn put_FontFamily(&self, value: HSTRING) -> HRESULT,
    fn get_FontSize(&self, out: *mut TimedTextDouble) -> HRESULT,
    fn put_FontSize(&self, value: TimedTextDouble) -> HRESULT,
    fn get_FontWeight(&self, out: *mut TimedTextWeight) -> HRESULT,
    fn put_FontWeight(&self, value: TimedTextWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_Foreground(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_Foreground(&self, value: super::super::ui::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_Background(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy11(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_Background(&self, value: super::super::ui::Color) -> HRESULT,
    fn get_IsBackgroundAlwaysShown(&self, out: *mut bool) -> HRESULT,
    fn put_IsBackgroundAlwaysShown(&self, value: bool) -> HRESULT,
    fn get_FlowDirection(&self, out: *mut TimedTextFlowDirection) -> HRESULT,
    fn put_FlowDirection(&self, value: TimedTextFlowDirection) -> HRESULT,
    fn get_LineAlignment(&self, out: *mut TimedTextLineAlignment) -> HRESULT,
    fn put_LineAlignment(&self, value: TimedTextLineAlignment) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy18(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_OutlineColor(&self, out: *mut super::super::ui::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy19(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_OutlineColor(&self, value: super::super::ui::Color) -> HRESULT,
    fn get_OutlineThickness(&self, out: *mut TimedTextDouble) -> HRESULT,
    fn put_OutlineThickness(&self, value: TimedTextDouble) -> HRESULT,
    fn get_OutlineRadius(&self, out: *mut TimedTextDouble) -> HRESULT,
    fn put_OutlineRadius(&self, value: TimedTextDouble) -> HRESULT
}}
impl ITimedTextStyle {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_family(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontFamily)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size(&self) -> Result<TimedTextDouble> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_size(&self, value: TimedTextDouble) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_weight(&self) -> Result<TimedTextWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_weight(&self, value: TimedTextWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_foreground(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Foreground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_foreground(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Foreground)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_background(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Background)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_background(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Background)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_background_always_shown(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBackgroundAlwaysShown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_background_always_shown(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsBackgroundAlwaysShown)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flow_direction(&self) -> Result<TimedTextFlowDirection> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FlowDirection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_flow_direction(&self, value: TimedTextFlowDirection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FlowDirection)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_alignment(&self) -> Result<TimedTextLineAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_line_alignment(&self, value: TimedTextLineAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LineAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_outline_color(&self) -> Result<super::super::ui::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OutlineColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_outline_color(&self, value: super::super::ui::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutlineColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outline_thickness(&self) -> Result<TimedTextDouble> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OutlineThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_outline_thickness(&self, value: TimedTextDouble) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutlineThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outline_radius(&self) -> Result<TimedTextDouble> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OutlineRadius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_outline_radius(&self, value: TimedTextDouble) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutlineRadius)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextStyle: ITimedTextStyle}
impl RtActivatable<IActivationFactory> for TimedTextStyle {}
DEFINE_CLSID!(TimedTextStyle(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,84,101,120,116,83,116,121,108,101,0]) [CLSID_TimedTextStyle]);
DEFINE_IID!(IID_ITimedTextStyle2, 1700743469, 24849, 18311, 137, 204, 104, 111, 236, 229, 126, 20);
RT_INTERFACE!{interface ITimedTextStyle2(ITimedTextStyle2Vtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextStyle2] {
    fn get_FontStyle(&self, out: *mut TimedTextFontStyle) -> HRESULT,
    fn put_FontStyle(&self, value: TimedTextFontStyle) -> HRESULT,
    fn get_IsUnderlineEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsUnderlineEnabled(&self, value: bool) -> HRESULT,
    fn get_IsLineThroughEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsLineThroughEnabled(&self, value: bool) -> HRESULT,
    fn get_IsOverlineEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsOverlineEnabled(&self, value: bool) -> HRESULT
}}
impl ITimedTextStyle2 {
    #[inline] pub unsafe fn get_font_style(&self) -> Result<TimedTextFontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_style(&self, value: TimedTextFontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_underline_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsUnderlineEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_underline_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsUnderlineEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_line_through_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsLineThroughEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_line_through_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsLineThroughEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_overline_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOverlineEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_overline_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOverlineEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITimedTextSubformat, 3608367151, 12897, 18210, 160, 194, 185, 55, 178, 57, 15, 20);
RT_INTERFACE!{interface ITimedTextSubformat(ITimedTextSubformatVtbl): IInspectable(IInspectableVtbl) [IID_ITimedTextSubformat] {
    fn get_StartIndex(&self, out: *mut i32) -> HRESULT,
    fn put_StartIndex(&self, value: i32) -> HRESULT,
    fn get_Length(&self, out: *mut i32) -> HRESULT,
    fn put_Length(&self, value: i32) -> HRESULT,
    fn get_SubformatStyle(&self, out: *mut *mut TimedTextStyle) -> HRESULT,
    fn put_SubformatStyle(&self, value: *mut TimedTextStyle) -> HRESULT
}}
impl ITimedTextSubformat {
    #[inline] pub unsafe fn get_start_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_index(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Length)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_length(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Length)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subformat_style(&self) -> Result<ComPtr<TimedTextStyle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubformatStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subformat_style(&self, value: &TimedTextStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SubformatStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TimedTextSubformat: ITimedTextSubformat}
impl RtActivatable<IActivationFactory> for TimedTextSubformat {}
DEFINE_CLSID!(TimedTextSubformat(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,84,105,109,101,100,84,101,120,116,83,117,98,102,111,114,109,97,116,0]) [CLSID_TimedTextSubformat]);
RT_ENUM! { enum TimedTextUnit: i32 {
    Pixels (TimedTextUnit_Pixels) = 0, Percentage (TimedTextUnit_Percentage) = 1,
}}
RT_ENUM! { enum TimedTextWeight: i32 {
    Normal (TimedTextWeight_Normal) = 400, Bold (TimedTextWeight_Bold) = 700,
}}
RT_ENUM! { enum TimedTextWrapping: i32 {
    NoWrap (TimedTextWrapping_NoWrap) = 0, Wrap (TimedTextWrapping_Wrap) = 1,
}}
RT_ENUM! { enum TimedTextWritingMode: i32 {
    LeftRightTopBottom (TimedTextWritingMode_LeftRightTopBottom) = 0, RightLeftTopBottom (TimedTextWritingMode_RightLeftTopBottom) = 1, TopBottomRightLeft (TimedTextWritingMode_TopBottomRightLeft) = 2, TopBottomLeftRight (TimedTextWritingMode_TopBottomLeftRight) = 3, LeftRight (TimedTextWritingMode_LeftRight) = 4, RightLeft (TimedTextWritingMode_RightLeft) = 5, TopBottom (TimedTextWritingMode_TopBottom) = 6,
}}
DEFINE_IID!(IID_IVideoStabilizationEffect, 134784592, 38552, 20055, 135, 123, 189, 124, 178, 238, 15, 138);
RT_INTERFACE!{interface IVideoStabilizationEffect(IVideoStabilizationEffectVtbl): IInspectable(IInspectableVtbl) [IID_IVideoStabilizationEffect] {
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    fn add_EnabledChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<VideoStabilizationEffect, VideoStabilizationEffectEnabledChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EnabledChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn GetRecommendedStreamConfiguration(&self, controller: *mut super::devices::VideoDeviceController, desiredProperties: *mut super::mediaproperties::VideoEncodingProperties, out: *mut *mut super::capture::VideoStreamConfiguration) -> HRESULT
}}
impl IVideoStabilizationEffect {
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_enabled_changed(&self, handler: &super::super::foundation::TypedEventHandler<VideoStabilizationEffect, VideoStabilizationEffectEnabledChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EnabledChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_enabled_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EnabledChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recommended_stream_configuration(&self, controller: &super::devices::VideoDeviceController, desiredProperties: &super::mediaproperties::VideoEncodingProperties) -> Result<ComPtr<super::capture::VideoStreamConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRecommendedStreamConfiguration)(self as *const _ as *mut _, controller as *const _ as *mut _, desiredProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoStabilizationEffect: IVideoStabilizationEffect}
RT_CLASS!{class VideoStabilizationEffectDefinition: super::effects::IVideoEffectDefinition}
impl RtActivatable<IActivationFactory> for VideoStabilizationEffectDefinition {}
DEFINE_CLSID!(VideoStabilizationEffectDefinition(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,86,105,100,101,111,83,116,97,98,105,108,105,122,97,116,105,111,110,69,102,102,101,99,116,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_VideoStabilizationEffectDefinition]);
DEFINE_IID!(IID_IVideoStabilizationEffectEnabledChangedEventArgs, 410976040, 26555, 18195, 185, 0, 65, 104, 218, 22, 69, 41);
RT_INTERFACE!{interface IVideoStabilizationEffectEnabledChangedEventArgs(IVideoStabilizationEffectEnabledChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVideoStabilizationEffectEnabledChangedEventArgs] {
    fn get_Reason(&self, out: *mut VideoStabilizationEffectEnabledChangedReason) -> HRESULT
}}
impl IVideoStabilizationEffectEnabledChangedEventArgs {
    #[inline] pub unsafe fn get_reason(&self) -> Result<VideoStabilizationEffectEnabledChangedReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Reason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class VideoStabilizationEffectEnabledChangedEventArgs: IVideoStabilizationEffectEnabledChangedEventArgs}
RT_ENUM! { enum VideoStabilizationEffectEnabledChangedReason: i32 {
    Programmatic (VideoStabilizationEffectEnabledChangedReason_Programmatic) = 0, PixelRateTooHigh (VideoStabilizationEffectEnabledChangedReason_PixelRateTooHigh) = 1, RunningSlowly (VideoStabilizationEffectEnabledChangedReason_RunningSlowly) = 2,
}}
DEFINE_IID!(IID_IVideoStreamDescriptor, 317590869, 39979, 17472, 128, 87, 44, 122, 144, 240, 203, 236);
RT_INTERFACE!{interface IVideoStreamDescriptor(IVideoStreamDescriptorVtbl): IInspectable(IInspectableVtbl) [IID_IVideoStreamDescriptor] {
    fn get_EncodingProperties(&self, out: *mut *mut super::mediaproperties::VideoEncodingProperties) -> HRESULT
}}
impl IVideoStreamDescriptor {
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::VideoEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_EncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoStreamDescriptor: IVideoStreamDescriptor}
impl RtActivatable<IVideoStreamDescriptorFactory> for VideoStreamDescriptor {}
impl VideoStreamDescriptor {
    #[inline] pub fn create(encodingProperties: &super::mediaproperties::VideoEncodingProperties) -> Result<ComPtr<VideoStreamDescriptor>> { unsafe {
        <Self as RtActivatable<IVideoStreamDescriptorFactory>>::get_activation_factory().create(encodingProperties)
    }}
}
DEFINE_CLSID!(VideoStreamDescriptor(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,86,105,100,101,111,83,116,114,101,97,109,68,101,115,99,114,105,112,116,111,114,0]) [CLSID_VideoStreamDescriptor]);
DEFINE_IID!(IID_IVideoStreamDescriptorFactory, 1229911761, 47989, 17362, 158, 94, 123, 121, 163, 175, 206, 212);
RT_INTERFACE!{static interface IVideoStreamDescriptorFactory(IVideoStreamDescriptorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IVideoStreamDescriptorFactory] {
    fn Create(&self, encodingProperties: *mut super::mediaproperties::VideoEncodingProperties, out: *mut *mut VideoStreamDescriptor) -> HRESULT
}}
impl IVideoStreamDescriptorFactory {
    #[inline] pub unsafe fn create(&self, encodingProperties: &super::mediaproperties::VideoEncodingProperties) -> Result<ComPtr<VideoStreamDescriptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, encodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVideoTrack, 2582886387, 58008, 17302, 187, 106, 165, 27, 230, 162, 162, 10);
RT_INTERFACE!{interface IVideoTrack(IVideoTrackVtbl): IInspectable(IInspectableVtbl) [IID_IVideoTrack] {
    fn add_OpenFailed(&self, handler: *mut super::super::foundation::TypedEventHandler<VideoTrack, VideoTrackOpenFailedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_OpenFailed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn GetEncodingProperties(&self, out: *mut *mut super::mediaproperties::VideoEncodingProperties) -> HRESULT,
    fn get_PlaybackItem(&self, out: *mut *mut super::playback::MediaPlaybackItem) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SupportInfo(&self, out: *mut *mut VideoTrackSupportInfo) -> HRESULT
}}
impl IVideoTrack {
    #[inline] pub unsafe fn add_open_failed(&self, handler: &super::super::foundation::TypedEventHandler<VideoTrack, VideoTrackOpenFailedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_OpenFailed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_open_failed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_OpenFailed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_encoding_properties(&self) -> Result<ComPtr<super::mediaproperties::VideoEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetEncodingProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_playback_item(&self) -> Result<ComPtr<super::playback::MediaPlaybackItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaybackItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_support_info(&self) -> Result<ComPtr<VideoTrackSupportInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoTrack: IMediaTrack}
DEFINE_IID!(IID_IVideoTrackOpenFailedEventArgs, 1987699249, 1273, 19586, 164, 238, 134, 2, 200, 187, 71, 84);
RT_INTERFACE!{interface IVideoTrackOpenFailedEventArgs(IVideoTrackOpenFailedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVideoTrackOpenFailedEventArgs] {
    fn get_ExtendedError(&self, out: *mut super::super::foundation::HResult) -> HRESULT
}}
impl IVideoTrackOpenFailedEventArgs {
    #[inline] pub unsafe fn get_extended_error(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtendedError)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class VideoTrackOpenFailedEventArgs: IVideoTrackOpenFailedEventArgs}
DEFINE_IID!(IID_IVideoTrackSupportInfo, 1270166688, 64607, 17677, 143, 240, 119, 141, 89, 4, 134, 222);
RT_INTERFACE!{interface IVideoTrackSupportInfo(IVideoTrackSupportInfoVtbl): IInspectable(IInspectableVtbl) [IID_IVideoTrackSupportInfo] {
    fn get_DecoderStatus(&self, out: *mut MediaDecoderStatus) -> HRESULT,
    fn get_MediaSourceStatus(&self, out: *mut MediaSourceStatus) -> HRESULT
}}
impl IVideoTrackSupportInfo {
    #[inline] pub unsafe fn get_decoder_status(&self) -> Result<MediaDecoderStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DecoderStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_source_status(&self) -> Result<MediaSourceStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediaSourceStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class VideoTrackSupportInfo: IVideoTrackSupportInfo}
pub mod preview { // Windows.Media.Core.Preview
use ::prelude::*;
RT_CLASS!{static class SoundLevelBroker}
impl RtActivatable<ISoundLevelBrokerStatics> for SoundLevelBroker {}
impl SoundLevelBroker {
    #[inline] pub fn get_sound_level() -> Result<super::super::SoundLevel> { unsafe {
        <Self as RtActivatable<ISoundLevelBrokerStatics>>::get_activation_factory().get_sound_level()
    }}
    #[inline] pub fn add_sound_level_changed(handler: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<ISoundLevelBrokerStatics>>::get_activation_factory().add_sound_level_changed(handler)
    }}
    #[inline] pub fn remove_sound_level_changed(token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<ISoundLevelBrokerStatics>>::get_activation_factory().remove_sound_level_changed(token)
    }}
}
DEFINE_CLSID!(SoundLevelBroker(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,67,111,114,101,46,80,114,101,118,105,101,119,46,83,111,117,110,100,76,101,118,101,108,66,114,111,107,101,114,0]) [CLSID_SoundLevelBroker]);
DEFINE_IID!(IID_ISoundLevelBrokerStatics, 1784887649, 56301, 17996, 160, 154, 51, 65, 47, 92, 170, 63);
RT_INTERFACE!{static interface ISoundLevelBrokerStatics(ISoundLevelBrokerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISoundLevelBrokerStatics] {
    fn get_SoundLevel(&self, out: *mut super::super::SoundLevel) -> HRESULT,
    fn add_SoundLevelChanged(&self, handler: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SoundLevelChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISoundLevelBrokerStatics {
    #[inline] pub unsafe fn get_sound_level(&self) -> Result<super::super::SoundLevel> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SoundLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sound_level_changed(&self, handler: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SoundLevelChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sound_level_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SoundLevelChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
} // Windows.Media.Core.Preview
} // Windows.Media.Core
pub mod devices { // Windows.Media.Devices
use ::prelude::*;
DEFINE_IID!(IID_IAdvancedPhotoCaptureSettings, 150177338, 24, 17499, 147, 210, 100, 109, 28, 94, 208, 92);
RT_INTERFACE!{interface IAdvancedPhotoCaptureSettings(IAdvancedPhotoCaptureSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedPhotoCaptureSettings] {
    fn get_Mode(&self, out: *mut AdvancedPhotoMode) -> HRESULT,
    fn put_Mode(&self, value: AdvancedPhotoMode) -> HRESULT
}}
impl IAdvancedPhotoCaptureSettings {
    #[inline] pub unsafe fn get_mode(&self) -> Result<AdvancedPhotoMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: AdvancedPhotoMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AdvancedPhotoCaptureSettings: IAdvancedPhotoCaptureSettings}
impl RtActivatable<IActivationFactory> for AdvancedPhotoCaptureSettings {}
DEFINE_CLSID!(AdvancedPhotoCaptureSettings(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,65,100,118,97,110,99,101,100,80,104,111,116,111,67,97,112,116,117,114,101,83,101,116,116,105,110,103,115,0]) [CLSID_AdvancedPhotoCaptureSettings]);
DEFINE_IID!(IID_IAdvancedPhotoControl, 3316733062, 36865, 18050, 147, 9, 104, 234, 224, 8, 14, 236);
RT_INTERFACE!{interface IAdvancedPhotoControl(IAdvancedPhotoControlVtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedPhotoControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_SupportedModes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AdvancedPhotoMode>) -> HRESULT,
    fn get_Mode(&self, out: *mut AdvancedPhotoMode) -> HRESULT,
    fn Configure(&self, settings: *mut AdvancedPhotoCaptureSettings) -> HRESULT
}}
impl IAdvancedPhotoControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_modes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AdvancedPhotoMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedModes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<AdvancedPhotoMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn configure(&self, settings: &AdvancedPhotoCaptureSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).Configure)(self as *const _ as *mut _, settings as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AdvancedPhotoControl: IAdvancedPhotoControl}
RT_ENUM! { enum AdvancedPhotoMode: i32 {
    Auto (AdvancedPhotoMode_Auto) = 0, Standard (AdvancedPhotoMode_Standard) = 1, Hdr (AdvancedPhotoMode_Hdr) = 2, LowLight (AdvancedPhotoMode_LowLight) = 3,
}}
DEFINE_IID!(IID_IAdvancedVideoCaptureDeviceController, 3731879123, 11158, 17795, 128, 171, 181, 176, 29, 198, 168, 215);
RT_INTERFACE!{interface IAdvancedVideoCaptureDeviceController(IAdvancedVideoCaptureDeviceControllerVtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedVideoCaptureDeviceController] {
    fn SetDeviceProperty(&self, propertyId: HSTRING, propertyValue: *mut IInspectable) -> HRESULT,
    fn GetDeviceProperty(&self, propertyId: HSTRING, out: *mut *mut IInspectable) -> HRESULT
}}
impl IAdvancedVideoCaptureDeviceController {
    #[inline] pub unsafe fn set_device_property(&self, propertyId: &HStringArg, propertyValue: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDeviceProperty)(self as *const _ as *mut _, propertyId.get(), propertyValue as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_property(&self, propertyId: &HStringArg) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceProperty)(self as *const _ as *mut _, propertyId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdvancedVideoCaptureDeviceController2, 2344177551, 61722, 17371, 180, 2, 17, 147, 11, 128, 174, 86);
RT_INTERFACE!{interface IAdvancedVideoCaptureDeviceController2(IAdvancedVideoCaptureDeviceController2Vtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedVideoCaptureDeviceController2] {
    fn get_LowLagPhotoSequence(&self, out: *mut *mut LowLagPhotoSequenceControl) -> HRESULT,
    fn get_LowLagPhoto(&self, out: *mut *mut LowLagPhotoControl) -> HRESULT,
    fn get_SceneModeControl(&self, out: *mut *mut SceneModeControl) -> HRESULT,
    fn get_TorchControl(&self, out: *mut *mut TorchControl) -> HRESULT,
    fn get_FlashControl(&self, out: *mut *mut FlashControl) -> HRESULT,
    fn get_WhiteBalanceControl(&self, out: *mut *mut WhiteBalanceControl) -> HRESULT,
    fn get_ExposureControl(&self, out: *mut *mut ExposureControl) -> HRESULT,
    fn get_FocusControl(&self, out: *mut *mut FocusControl) -> HRESULT,
    fn get_ExposureCompensationControl(&self, out: *mut *mut ExposureCompensationControl) -> HRESULT,
    fn get_IsoSpeedControl(&self, out: *mut *mut IsoSpeedControl) -> HRESULT,
    fn get_RegionsOfInterestControl(&self, out: *mut *mut RegionsOfInterestControl) -> HRESULT,
    fn get_PrimaryUse(&self, out: *mut CaptureUse) -> HRESULT,
    fn put_PrimaryUse(&self, value: CaptureUse) -> HRESULT
}}
impl IAdvancedVideoCaptureDeviceController2 {
    #[inline] pub unsafe fn get_low_lag_photo_sequence(&self) -> Result<ComPtr<LowLagPhotoSequenceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LowLagPhotoSequence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_low_lag_photo(&self) -> Result<ComPtr<LowLagPhotoControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LowLagPhoto)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scene_mode_control(&self) -> Result<ComPtr<SceneModeControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SceneModeControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_torch_control(&self) -> Result<ComPtr<TorchControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TorchControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flash_control(&self) -> Result<ComPtr<FlashControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlashControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_white_balance_control(&self) -> Result<ComPtr<WhiteBalanceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WhiteBalanceControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exposure_control(&self) -> Result<ComPtr<ExposureControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposureControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_control(&self) -> Result<ComPtr<FocusControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exposure_compensation_control(&self) -> Result<ComPtr<ExposureCompensationControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposureCompensationControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_iso_speed_control(&self) -> Result<ComPtr<IsoSpeedControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsoSpeedControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_regions_of_interest_control(&self) -> Result<ComPtr<RegionsOfInterestControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RegionsOfInterestControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_use(&self) -> Result<CaptureUse> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PrimaryUse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_primary_use(&self, value: CaptureUse) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryUse)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdvancedVideoCaptureDeviceController3, 2844495668, 60941, 18188, 185, 240, 66, 41, 196, 187, 208, 137);
RT_INTERFACE!{interface IAdvancedVideoCaptureDeviceController3(IAdvancedVideoCaptureDeviceController3Vtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedVideoCaptureDeviceController3] {
    fn get_VariablePhotoSequenceController(&self, out: *mut *mut core::VariablePhotoSequenceController) -> HRESULT,
    fn get_PhotoConfirmationControl(&self, out: *mut *mut PhotoConfirmationControl) -> HRESULT,
    fn get_ZoomControl(&self, out: *mut *mut ZoomControl) -> HRESULT
}}
impl IAdvancedVideoCaptureDeviceController3 {
    #[inline] pub unsafe fn get_variable_photo_sequence_controller(&self) -> Result<ComPtr<core::VariablePhotoSequenceController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VariablePhotoSequenceController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photo_confirmation_control(&self) -> Result<ComPtr<PhotoConfirmationControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhotoConfirmationControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zoom_control(&self) -> Result<ComPtr<ZoomControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ZoomControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdvancedVideoCaptureDeviceController4, 3936337839, 54129, 16835, 154, 23, 130, 74, 135, 235, 223, 210);
RT_INTERFACE!{interface IAdvancedVideoCaptureDeviceController4(IAdvancedVideoCaptureDeviceController4Vtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedVideoCaptureDeviceController4] {
    fn get_ExposurePriorityVideoControl(&self, out: *mut *mut ExposurePriorityVideoControl) -> HRESULT,
    fn get_DesiredOptimization(&self, out: *mut MediaCaptureOptimization) -> HRESULT,
    fn put_DesiredOptimization(&self, value: MediaCaptureOptimization) -> HRESULT,
    fn get_HdrVideoControl(&self, out: *mut *mut HdrVideoControl) -> HRESULT,
    fn get_OpticalImageStabilizationControl(&self, out: *mut *mut OpticalImageStabilizationControl) -> HRESULT,
    fn get_AdvancedPhotoControl(&self, out: *mut *mut AdvancedPhotoControl) -> HRESULT
}}
impl IAdvancedVideoCaptureDeviceController4 {
    #[inline] pub unsafe fn get_exposure_priority_video_control(&self) -> Result<ComPtr<ExposurePriorityVideoControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposurePriorityVideoControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_optimization(&self) -> Result<MediaCaptureOptimization> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredOptimization)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_optimization(&self, value: MediaCaptureOptimization) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredOptimization)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hdr_video_control(&self) -> Result<ComPtr<HdrVideoControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HdrVideoControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_optical_image_stabilization_control(&self) -> Result<ComPtr<OpticalImageStabilizationControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OpticalImageStabilizationControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_advanced_photo_control(&self) -> Result<ComPtr<AdvancedPhotoControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AdvancedPhotoControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdvancedVideoCaptureDeviceController5, 860957463, 47563, 18979, 184, 117, 249, 234, 171, 83, 84, 146);
RT_INTERFACE!{interface IAdvancedVideoCaptureDeviceController5(IAdvancedVideoCaptureDeviceController5Vtbl): IInspectable(IInspectableVtbl) [IID_IAdvancedVideoCaptureDeviceController5] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDevicePropertyById(&self, propertyId: HSTRING, maxPropertyValueSize: *mut super::super::foundation::IReference<u32>, out: *mut *mut VideoDeviceControllerGetDevicePropertyResult) -> HRESULT,
    fn SetDevicePropertyById(&self, propertyId: HSTRING, propertyValue: *mut IInspectable, out: *mut VideoDeviceControllerSetDevicePropertyStatus) -> HRESULT,
    fn GetDevicePropertyByExtendedId(&self, extendedPropertyIdSize: u32, extendedPropertyId: *mut u8, maxPropertyValueSize: *mut super::super::foundation::IReference<u32>, out: *mut *mut VideoDeviceControllerGetDevicePropertyResult) -> HRESULT,
    fn SetDevicePropertyByExtendedId(&self, extendedPropertyIdSize: u32, extendedPropertyId: *mut u8, propertyValueSize: u32, propertyValue: *mut u8, out: *mut VideoDeviceControllerSetDevicePropertyStatus) -> HRESULT
}}
impl IAdvancedVideoCaptureDeviceController5 {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_property_by_id(&self, propertyId: &HStringArg, maxPropertyValueSize: &super::super::foundation::IReference<u32>) -> Result<ComPtr<VideoDeviceControllerGetDevicePropertyResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDevicePropertyById)(self as *const _ as *mut _, propertyId.get(), maxPropertyValueSize as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_device_property_by_id(&self, propertyId: &HStringArg, propertyValue: &IInspectable) -> Result<VideoDeviceControllerSetDevicePropertyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SetDevicePropertyById)(self as *const _ as *mut _, propertyId.get(), propertyValue as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_property_by_extended_id(&self, extendedPropertyId: &[u8], maxPropertyValueSize: &super::super::foundation::IReference<u32>) -> Result<ComPtr<VideoDeviceControllerGetDevicePropertyResult>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDevicePropertyByExtendedId)(self as *const _ as *mut _, extendedPropertyId.len() as u32, extendedPropertyId.as_ptr() as *mut _, maxPropertyValueSize as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_device_property_by_extended_id(&self, extendedPropertyId: &[u8], propertyValue: &[u8]) -> Result<VideoDeviceControllerSetDevicePropertyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SetDevicePropertyByExtendedId)(self as *const _ as *mut _, extendedPropertyId.len() as u32, extendedPropertyId.as_ptr() as *mut _, propertyValue.len() as u32, propertyValue.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAudioDeviceController, 3990135688, 31175, 20348, 144, 232, 239, 147, 75, 33, 88, 10);
RT_INTERFACE!{interface IAudioDeviceController(IAudioDeviceControllerVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceController] {
    fn put_Muted(&self, value: bool) -> HRESULT,
    fn get_Muted(&self, out: *mut bool) -> HRESULT,
    fn put_VolumePercent(&self, value: f32) -> HRESULT,
    fn get_VolumePercent(&self, out: *mut f32) -> HRESULT
}}
impl IAudioDeviceController {
    #[inline] pub unsafe fn set_muted(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Muted)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_muted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Muted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_volume_percent(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VolumePercent)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_volume_percent(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VolumePercent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AudioDeviceController: IAudioDeviceController}
DEFINE_IID!(IID_IAudioDeviceModule, 2261756982, 18369, 19251, 152, 82, 135, 115, 236, 75, 225, 35);
RT_INTERFACE!{interface IAudioDeviceModule(IAudioDeviceModuleVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceModule] {
    fn get_ClassId(&self, out: *mut HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_InstanceId(&self, out: *mut u32) -> HRESULT,
    fn get_MajorVersion(&self, out: *mut u32) -> HRESULT,
    fn get_MinorVersion(&self, out: *mut u32) -> HRESULT,
    #[cfg(feature="windows-storage")] fn SendCommandAsync(&self, command: *mut super::super::storage::streams::IBuffer, out: *mut *mut super::super::foundation::IAsyncOperation<ModuleCommandResult>) -> HRESULT
}}
impl IAudioDeviceModule {
    #[inline] pub unsafe fn get_class_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ClassId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_instance_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InstanceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_major_version(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MajorVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_minor_version(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinorVersion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn send_command_async(&self, command: &super::super::storage::streams::IBuffer) -> Result<ComPtr<super::super::foundation::IAsyncOperation<ModuleCommandResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SendCommandAsync)(self as *const _ as *mut _, command as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioDeviceModule: IAudioDeviceModule}
DEFINE_IID!(IID_IAudioDeviceModuleNotificationEventArgs, 3823357103, 8780, 18622, 149, 107, 154, 19, 19, 78, 150, 232);
RT_INTERFACE!{interface IAudioDeviceModuleNotificationEventArgs(IAudioDeviceModuleNotificationEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceModuleNotificationEventArgs] {
    fn get_Module(&self, out: *mut *mut AudioDeviceModule) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_NotificationData(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl IAudioDeviceModuleNotificationEventArgs {
    #[inline] pub unsafe fn get_module(&self) -> Result<ComPtr<AudioDeviceModule>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Module)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_notification_data(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NotificationData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioDeviceModuleNotificationEventArgs: IAudioDeviceModuleNotificationEventArgs}
DEFINE_IID!(IID_IAudioDeviceModulesManager, 1789135949, 38410, 19740, 179, 24, 0, 34, 96, 69, 71, 237);
RT_INTERFACE!{interface IAudioDeviceModulesManager(IAudioDeviceModulesManagerVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceModulesManager] {
    fn add_ModuleNotificationReceived(&self, handler: *mut super::super::foundation::TypedEventHandler<AudioDeviceModulesManager, AudioDeviceModuleNotificationEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ModuleNotificationReceived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn FindAllById(&self, moduleId: HSTRING, out: *mut *mut super::super::foundation::collections::IVectorView<AudioDeviceModule>) -> HRESULT,
    fn FindAll(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AudioDeviceModule>) -> HRESULT
}}
impl IAudioDeviceModulesManager {
    #[inline] pub unsafe fn add_module_notification_received(&self, handler: &super::super::foundation::TypedEventHandler<AudioDeviceModulesManager, AudioDeviceModuleNotificationEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ModuleNotificationReceived)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_module_notification_received(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ModuleNotificationReceived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_by_id(&self, moduleId: &HStringArg) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AudioDeviceModule>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllById)(self as *const _ as *mut _, moduleId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AudioDeviceModule>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAll)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AudioDeviceModulesManager: IAudioDeviceModulesManager}
impl RtActivatable<IAudioDeviceModulesManagerFactory> for AudioDeviceModulesManager {}
impl AudioDeviceModulesManager {
    #[inline] pub fn create(deviceId: &HStringArg) -> Result<ComPtr<AudioDeviceModulesManager>> { unsafe {
        <Self as RtActivatable<IAudioDeviceModulesManagerFactory>>::get_activation_factory().create(deviceId)
    }}
}
DEFINE_CLSID!(AudioDeviceModulesManager(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,65,117,100,105,111,68,101,118,105,99,101,77,111,100,117,108,101,115,77,97,110,97,103,101,114,0]) [CLSID_AudioDeviceModulesManager]);
DEFINE_IID!(IID_IAudioDeviceModulesManagerFactory, 2377135728, 58957, 18291, 150, 192, 188, 126, 191, 14, 6, 63);
RT_INTERFACE!{static interface IAudioDeviceModulesManagerFactory(IAudioDeviceModulesManagerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAudioDeviceModulesManagerFactory] {
    fn Create(&self, deviceId: HSTRING, out: *mut *mut AudioDeviceModulesManager) -> HRESULT
}}
impl IAudioDeviceModulesManagerFactory {
    #[inline] pub unsafe fn create(&self, deviceId: &HStringArg) -> Result<ComPtr<AudioDeviceModulesManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AudioDeviceRole: i32 {
    Default (AudioDeviceRole_Default) = 0, Communications (AudioDeviceRole_Communications) = 1,
}}
RT_ENUM! { enum AutoFocusRange: i32 {
    FullRange (AutoFocusRange_FullRange) = 0, Macro (AutoFocusRange_Macro) = 1, Normal (AutoFocusRange_Normal) = 2,
}}
DEFINE_IID!(IID_ICallControl, 2770391254, 44685, 17883, 128, 17, 202, 73, 211, 179, 229, 120);
RT_INTERFACE!{interface ICallControl(ICallControlVtbl): IInspectable(IInspectableVtbl) [IID_ICallControl] {
    fn IndicateNewIncomingCall(&self, enableRinger: bool, callerId: HSTRING, out: *mut u64) -> HRESULT,
    fn IndicateNewOutgoingCall(&self, out: *mut u64) -> HRESULT,
    fn IndicateActiveCall(&self, callToken: u64) -> HRESULT,
    fn EndCall(&self, callToken: u64) -> HRESULT,
    fn get_HasRinger(&self, out: *mut bool) -> HRESULT,
    fn add_AnswerRequested(&self, handler: *mut CallControlEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AnswerRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_HangUpRequested(&self, handler: *mut CallControlEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HangUpRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DialRequested(&self, handler: *mut DialRequestedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DialRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RedialRequested(&self, handler: *mut RedialRequestedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RedialRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeypadPressed(&self, handler: *mut KeypadPressedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeypadPressed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AudioTransferRequested(&self, handler: *mut CallControlEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AudioTransferRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICallControl {
    #[inline] pub unsafe fn indicate_new_incoming_call(&self, enableRinger: bool, callerId: &HStringArg) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IndicateNewIncomingCall)(self as *const _ as *mut _, enableRinger, callerId.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn indicate_new_outgoing_call(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IndicateNewOutgoingCall)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn indicate_active_call(&self, callToken: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).IndicateActiveCall)(self as *const _ as *mut _, callToken);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_call(&self, callToken: u64) -> Result<()> {
        let hr = ((*self.lpVtbl).EndCall)(self as *const _ as *mut _, callToken);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_ringer(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasRinger)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_answer_requested(&self, handler: &CallControlEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AnswerRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_answer_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AnswerRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hang_up_requested(&self, handler: &CallControlEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HangUpRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hang_up_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HangUpRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_dial_requested(&self, handler: &DialRequestedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DialRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_dial_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DialRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_redial_requested(&self, handler: &RedialRequestedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RedialRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_redial_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RedialRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_keypad_pressed(&self, handler: &KeypadPressedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeypadPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_keypad_pressed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeypadPressed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_audio_transfer_requested(&self, handler: &CallControlEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AudioTransferRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_audio_transfer_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AudioTransferRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CallControl: ICallControl}
impl RtActivatable<ICallControlStatics> for CallControl {}
impl CallControl {
    #[inline] pub fn get_default() -> Result<ComPtr<CallControl>> { unsafe {
        <Self as RtActivatable<ICallControlStatics>>::get_activation_factory().get_default()
    }}
    #[inline] pub fn from_id(deviceId: &HStringArg) -> Result<ComPtr<CallControl>> { unsafe {
        <Self as RtActivatable<ICallControlStatics>>::get_activation_factory().from_id(deviceId)
    }}
}
DEFINE_CLSID!(CallControl(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,67,97,108,108,67,111,110,116,114,111,108,0]) [CLSID_CallControl]);
DEFINE_IID!(IID_CallControlEventHandler, 1500476831, 20703, 17492, 188, 99, 77, 61, 1, 182, 25, 88);
RT_DELEGATE!{delegate CallControlEventHandler(CallControlEventHandlerVtbl, CallControlEventHandlerImpl) [IID_CallControlEventHandler] {
    fn Invoke(&self, sender: *mut CallControl) -> HRESULT
}}
impl CallControlEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &CallControl) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICallControlStatics, 60054229, 34219, 16609, 175, 25, 86, 201, 67, 3, 176, 25);
RT_INTERFACE!{static interface ICallControlStatics(ICallControlStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICallControlStatics] {
    fn GetDefault(&self, out: *mut *mut CallControl) -> HRESULT,
    fn FromId(&self, deviceId: HSTRING, out: *mut *mut CallControl) -> HRESULT
}}
impl ICallControlStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<CallControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_id(&self, deviceId: &HStringArg) -> Result<ComPtr<CallControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FromId)(self as *const _ as *mut _, deviceId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CameraStreamState: i32 {
    NotStreaming (CameraStreamState_NotStreaming) = 0, Streaming (CameraStreamState_Streaming) = 1, BlockedForPrivacy (CameraStreamState_BlockedForPrivacy) = 2, Shutdown (CameraStreamState_Shutdown) = 3,
}}
RT_ENUM! { enum CaptureSceneMode: i32 {
    Auto (CaptureSceneMode_Auto) = 0, Manual (CaptureSceneMode_Manual) = 1, Macro (CaptureSceneMode_Macro) = 2, Portrait (CaptureSceneMode_Portrait) = 3, Sport (CaptureSceneMode_Sport) = 4, Snow (CaptureSceneMode_Snow) = 5, Night (CaptureSceneMode_Night) = 6, Beach (CaptureSceneMode_Beach) = 7, Sunset (CaptureSceneMode_Sunset) = 8, Candlelight (CaptureSceneMode_Candlelight) = 9, Landscape (CaptureSceneMode_Landscape) = 10, NightPortrait (CaptureSceneMode_NightPortrait) = 11, Backlit (CaptureSceneMode_Backlit) = 12,
}}
RT_ENUM! { enum CaptureUse: i32 {
    None (CaptureUse_None) = 0, Photo (CaptureUse_Photo) = 1, Video (CaptureUse_Video) = 2,
}}
RT_ENUM! { enum ColorTemperaturePreset: i32 {
    Auto (ColorTemperaturePreset_Auto) = 0, Manual (ColorTemperaturePreset_Manual) = 1, Cloudy (ColorTemperaturePreset_Cloudy) = 2, Daylight (ColorTemperaturePreset_Daylight) = 3, Flash (ColorTemperaturePreset_Flash) = 4, Fluorescent (ColorTemperaturePreset_Fluorescent) = 5, Tungsten (ColorTemperaturePreset_Tungsten) = 6, Candlelight (ColorTemperaturePreset_Candlelight) = 7,
}}
RT_CLASS!{class DefaultAudioCaptureDeviceChangedEventArgs: IDefaultAudioDeviceChangedEventArgs}
DEFINE_IID!(IID_IDefaultAudioDeviceChangedEventArgs, 286230575, 7173, 18007, 161, 142, 71, 201, 182, 159, 7, 171);
RT_INTERFACE!{interface IDefaultAudioDeviceChangedEventArgs(IDefaultAudioDeviceChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDefaultAudioDeviceChangedEventArgs] {
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Role(&self, out: *mut AudioDeviceRole) -> HRESULT
}}
impl IDefaultAudioDeviceChangedEventArgs {
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_role(&self) -> Result<AudioDeviceRole> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Role)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DefaultAudioRenderDeviceChangedEventArgs: IDefaultAudioDeviceChangedEventArgs}
DEFINE_IID!(IID_IDialRequestedEventArgs, 58430110, 38204, 17030, 136, 102, 79, 15, 55, 108, 133, 90);
RT_INTERFACE!{interface IDialRequestedEventArgs(IDialRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDialRequestedEventArgs] {
    fn Handled(&self) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IDialRequestedEventArgs {
    #[inline] pub unsafe fn handled(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Handled)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DialRequestedEventArgs: IDialRequestedEventArgs}
DEFINE_IID!(IID_DialRequestedEventHandler, 1522270171, 49695, 19396, 137, 27, 37, 126, 40, 193, 177, 164);
RT_DELEGATE!{delegate DialRequestedEventHandler(DialRequestedEventHandlerVtbl, DialRequestedEventHandlerImpl) [IID_DialRequestedEventHandler] {
    fn Invoke(&self, sender: *mut CallControl, e: *mut DialRequestedEventArgs) -> HRESULT
}}
impl DialRequestedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &CallControl, e: &DialRequestedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IExposureCompensationControl, 2177427508, 56556, 16401, 166, 16, 31, 56, 71, 230, 74, 202);
RT_INTERFACE!{interface IExposureCompensationControl(IExposureCompensationControlVtbl): IInspectable(IInspectableVtbl) [IID_IExposureCompensationControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Min(&self, out: *mut f32) -> HRESULT,
    fn get_Max(&self, out: *mut f32) -> HRESULT,
    fn get_Step(&self, out: *mut f32) -> HRESULT,
    fn get_Value(&self, out: *mut f32) -> HRESULT,
    fn SetValueAsync(&self, value: f32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IExposureCompensationControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value_async(&self, value: f32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetValueAsync)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ExposureCompensationControl: IExposureCompensationControl}
DEFINE_IID!(IID_IExposureControl, 166251490, 44438, 20264, 160, 224, 150, 237, 126, 27, 95, 210);
RT_INTERFACE!{interface IExposureControl(IExposureControlVtbl): IInspectable(IInspectableVtbl) [IID_IExposureControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Auto(&self, out: *mut bool) -> HRESULT,
    fn SetAutoAsync(&self, value: bool, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_Min(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Max(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Step(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn get_Value(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn SetValueAsync(&self, shutterDuration: super::super::foundation::TimeSpan, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IExposureControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Auto)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_async(&self, value: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetAutoAsync)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value_async(&self, shutterDuration: super::super::foundation::TimeSpan) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetValueAsync)(self as *const _ as *mut _, shutterDuration, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ExposureControl: IExposureControl}
DEFINE_IID!(IID_IExposurePriorityVideoControl, 749879459, 20840, 17009, 158, 165, 71, 98, 26, 152, 163, 82);
RT_INTERFACE!{interface IExposurePriorityVideoControl(IExposurePriorityVideoControlVtbl): IInspectable(IInspectableVtbl) [IID_IExposurePriorityVideoControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    fn put_Enabled(&self, value: bool) -> HRESULT
}}
impl IExposurePriorityVideoControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ExposurePriorityVideoControl: IExposurePriorityVideoControl}
DEFINE_IID!(IID_IFlashControl, 3740540350, 32104, 17891, 140, 15, 190, 123, 179, 40, 55, 208);
RT_INTERFACE!{interface IFlashControl(IFlashControlVtbl): IInspectable(IInspectableVtbl) [IID_IFlashControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_PowerSupported(&self, out: *mut bool) -> HRESULT,
    fn get_RedEyeReductionSupported(&self, out: *mut bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_Auto(&self, out: *mut bool) -> HRESULT,
    fn put_Auto(&self, value: bool) -> HRESULT,
    fn get_RedEyeReduction(&self, out: *mut bool) -> HRESULT,
    fn put_RedEyeReduction(&self, value: bool) -> HRESULT,
    fn get_PowerPercent(&self, out: *mut f32) -> HRESULT,
    fn put_PowerPercent(&self, value: f32) -> HRESULT
}}
impl IFlashControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_power_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PowerSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_red_eye_reduction_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RedEyeReductionSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Auto)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Auto)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_red_eye_reduction(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RedEyeReduction)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_red_eye_reduction(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RedEyeReduction)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_power_percent(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PowerPercent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_power_percent(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PowerPercent)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FlashControl: IFlashControl}
DEFINE_IID!(IID_IFlashControl2, 2099891358, 30177, 19191, 189, 125, 78, 56, 225, 192, 108, 214);
RT_INTERFACE!{interface IFlashControl2(IFlashControl2Vtbl): IInspectable(IInspectableVtbl) [IID_IFlashControl2] {
    fn get_AssistantLightSupported(&self, out: *mut bool) -> HRESULT,
    fn get_AssistantLightEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_AssistantLightEnabled(&self, value: bool) -> HRESULT
}}
impl IFlashControl2 {
    #[inline] pub unsafe fn get_assistant_light_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AssistantLightSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_assistant_light_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AssistantLightEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_assistant_light_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AssistantLightEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFocusControl, 3235416566, 21032, 17491, 177, 83, 133, 96, 101, 146, 178, 56);
RT_INTERFACE!{interface IFocusControl(IFocusControlVtbl): IInspectable(IInspectableVtbl) [IID_IFocusControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_SupportedPresets(&self, out: *mut *mut super::super::foundation::collections::IVectorView<FocusPreset>) -> HRESULT,
    fn get_Preset(&self, out: *mut FocusPreset) -> HRESULT,
    fn SetPresetAsync(&self, preset: FocusPreset, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SetPresetWithCompletionOptionAsync(&self, preset: FocusPreset, completeBeforeFocus: bool, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_Min(&self, out: *mut u32) -> HRESULT,
    fn get_Max(&self, out: *mut u32) -> HRESULT,
    fn get_Step(&self, out: *mut u32) -> HRESULT,
    fn get_Value(&self, out: *mut u32) -> HRESULT,
    fn SetValueAsync(&self, focus: u32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn FocusAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IFocusControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_presets(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<FocusPreset>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedPresets)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preset(&self) -> Result<FocusPreset> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Preset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preset_async(&self, preset: FocusPreset) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetPresetAsync)(self as *const _ as *mut _, preset, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preset_with_completion_option_async(&self, preset: FocusPreset, completeBeforeFocus: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetPresetWithCompletionOptionAsync)(self as *const _ as *mut _, preset, completeBeforeFocus, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value_async(&self, focus: u32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetValueAsync)(self as *const _ as *mut _, focus, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn focus_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FocusAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class FocusControl: IFocusControl}
DEFINE_IID!(IID_IFocusControl2, 1065156424, 50484, 20126, 148, 195, 82, 239, 42, 253, 93, 7);
RT_INTERFACE!{interface IFocusControl2(IFocusControl2Vtbl): IInspectable(IInspectableVtbl) [IID_IFocusControl2] {
    fn get_FocusChangedSupported(&self, out: *mut bool) -> HRESULT,
    fn get_WaitForFocusSupported(&self, out: *mut bool) -> HRESULT,
    fn get_SupportedFocusModes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<FocusMode>) -> HRESULT,
    fn get_SupportedFocusDistances(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ManualFocusDistance>) -> HRESULT,
    fn get_SupportedFocusRanges(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AutoFocusRange>) -> HRESULT,
    fn get_Mode(&self, out: *mut FocusMode) -> HRESULT,
    fn get_FocusState(&self, out: *mut MediaCaptureFocusState) -> HRESULT,
    fn UnlockAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn LockAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn Configure(&self, settings: *mut FocusSettings) -> HRESULT
}}
impl IFocusControl2 {
    #[inline] pub unsafe fn get_focus_changed_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusChangedSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wait_for_focus_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WaitForFocusSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_focus_modes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<FocusMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedFocusModes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_focus_distances(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ManualFocusDistance>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedFocusDistances)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_focus_ranges(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AutoFocusRange>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedFocusRanges)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<FocusMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_state(&self) -> Result<MediaCaptureFocusState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn unlock_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UnlockAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn lock_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LockAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn configure(&self, settings: &FocusSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).Configure)(self as *const _ as *mut _, settings as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum FocusMode: i32 {
    Auto (FocusMode_Auto) = 0, Single (FocusMode_Single) = 1, Continuous (FocusMode_Continuous) = 2, Manual (FocusMode_Manual) = 3,
}}
RT_ENUM! { enum FocusPreset: i32 {
    Auto (FocusPreset_Auto) = 0, Manual (FocusPreset_Manual) = 1, AutoMacro (FocusPreset_AutoMacro) = 2, AutoNormal (FocusPreset_AutoNormal) = 3, AutoInfinity (FocusPreset_AutoInfinity) = 4, AutoHyperfocal (FocusPreset_AutoHyperfocal) = 5,
}}
DEFINE_IID!(IID_IFocusSettings, 2039844715, 12899, 17013, 133, 214, 174, 174, 137, 28, 150, 238);
RT_INTERFACE!{interface IFocusSettings(IFocusSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IFocusSettings] {
    fn get_Mode(&self, out: *mut FocusMode) -> HRESULT,
    fn put_Mode(&self, value: FocusMode) -> HRESULT,
    fn get_AutoFocusRange(&self, out: *mut AutoFocusRange) -> HRESULT,
    fn put_AutoFocusRange(&self, value: AutoFocusRange) -> HRESULT,
    fn get_Value(&self, out: *mut *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn put_Value(&self, value: *mut super::super::foundation::IReference<u32>) -> HRESULT,
    fn get_Distance(&self, out: *mut *mut super::super::foundation::IReference<ManualFocusDistance>) -> HRESULT,
    fn put_Distance(&self, value: *mut super::super::foundation::IReference<ManualFocusDistance>) -> HRESULT,
    fn get_WaitForFocus(&self, out: *mut bool) -> HRESULT,
    fn put_WaitForFocus(&self, value: bool) -> HRESULT,
    fn get_DisableDriverFallback(&self, out: *mut bool) -> HRESULT,
    fn put_DisableDriverFallback(&self, value: bool) -> HRESULT
}}
impl IFocusSettings {
    #[inline] pub unsafe fn get_mode(&self) -> Result<FocusMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: FocusMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_focus_range(&self) -> Result<AutoFocusRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoFocusRange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_focus_range(&self, value: AutoFocusRange) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoFocusRange)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<super::super::foundation::IReference<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value(&self, value: &super::super::foundation::IReference<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Value)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_distance(&self) -> Result<ComPtr<super::super::foundation::IReference<ManualFocusDistance>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Distance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_distance(&self, value: &super::super::foundation::IReference<ManualFocusDistance>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Distance)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wait_for_focus(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WaitForFocus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_wait_for_focus(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WaitForFocus)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_disable_driver_fallback(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisableDriverFallback)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_disable_driver_fallback(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisableDriverFallback)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FocusSettings: IFocusSettings}
impl RtActivatable<IActivationFactory> for FocusSettings {}
DEFINE_CLSID!(FocusSettings(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,70,111,99,117,115,83,101,116,116,105,110,103,115,0]) [CLSID_FocusSettings]);
DEFINE_IID!(IID_IHdrVideoControl, 1440277200, 12480, 17343, 155, 154, 151, 153, 215, 12, 237, 148);
RT_INTERFACE!{interface IHdrVideoControl(IHdrVideoControlVtbl): IInspectable(IInspectableVtbl) [IID_IHdrVideoControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_SupportedModes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<HdrVideoMode>) -> HRESULT,
    fn get_Mode(&self, out: *mut HdrVideoMode) -> HRESULT,
    fn put_Mode(&self, value: HdrVideoMode) -> HRESULT
}}
impl IHdrVideoControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_modes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<HdrVideoMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedModes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<HdrVideoMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: HdrVideoMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class HdrVideoControl: IHdrVideoControl}
RT_ENUM! { enum HdrVideoMode: i32 {
    Off (HdrVideoMode_Off) = 0, On (HdrVideoMode_On) = 1, Auto (HdrVideoMode_Auto) = 2,
}}
DEFINE_IID!(IID_IIsoSpeedControl, 666288930, 9645, 20251, 170, 171, 82, 74, 179, 118, 202, 51);
RT_INTERFACE!{interface IIsoSpeedControl(IIsoSpeedControlVtbl): IInspectable(IInspectableVtbl) [IID_IIsoSpeedControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_SupportedPresets(&self, out: *mut *mut super::super::foundation::collections::IVectorView<IsoSpeedPreset>) -> HRESULT,
    fn get_Preset(&self, out: *mut IsoSpeedPreset) -> HRESULT,
    fn SetPresetAsync(&self, preset: IsoSpeedPreset, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IIsoSpeedControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_presets(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<IsoSpeedPreset>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedPresets)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preset(&self) -> Result<IsoSpeedPreset> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Preset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preset_async(&self, preset: IsoSpeedPreset) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetPresetAsync)(self as *const _ as *mut _, preset, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class IsoSpeedControl: IIsoSpeedControl}
DEFINE_IID!(IID_IIsoSpeedControl2, 1863678194, 28023, 20362, 140, 47, 97, 48, 182, 57, 80, 83);
RT_INTERFACE!{interface IIsoSpeedControl2(IIsoSpeedControl2Vtbl): IInspectable(IInspectableVtbl) [IID_IIsoSpeedControl2] {
    fn get_Min(&self, out: *mut u32) -> HRESULT,
    fn get_Max(&self, out: *mut u32) -> HRESULT,
    fn get_Step(&self, out: *mut u32) -> HRESULT,
    fn get_Value(&self, out: *mut u32) -> HRESULT,
    fn SetValueAsync(&self, isoSpeed: u32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_Auto(&self, out: *mut bool) -> HRESULT,
    fn SetAutoAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IIsoSpeedControl2 {
    #[inline] pub unsafe fn get_min(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value_async(&self, isoSpeed: u32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetValueAsync)(self as *const _ as *mut _, isoSpeed, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Auto)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetAutoAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum IsoSpeedPreset: i32 {
    Auto (IsoSpeedPreset_Auto) = 0, Iso50 (IsoSpeedPreset_Iso50) = 1, Iso80 (IsoSpeedPreset_Iso80) = 2, Iso100 (IsoSpeedPreset_Iso100) = 3, Iso200 (IsoSpeedPreset_Iso200) = 4, Iso400 (IsoSpeedPreset_Iso400) = 5, Iso800 (IsoSpeedPreset_Iso800) = 6, Iso1600 (IsoSpeedPreset_Iso1600) = 7, Iso3200 (IsoSpeedPreset_Iso3200) = 8, Iso6400 (IsoSpeedPreset_Iso6400) = 9, Iso12800 (IsoSpeedPreset_Iso12800) = 10, Iso25600 (IsoSpeedPreset_Iso25600) = 11,
}}
DEFINE_IID!(IID_IKeypadPressedEventArgs, 3550755072, 46330, 18893, 148, 66, 137, 175, 101, 104, 246, 1);
RT_INTERFACE!{interface IKeypadPressedEventArgs(IKeypadPressedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IKeypadPressedEventArgs] {
    fn get_TelephonyKey(&self, out: *mut TelephonyKey) -> HRESULT
}}
impl IKeypadPressedEventArgs {
    #[inline] pub unsafe fn get_telephony_key(&self) -> Result<TelephonyKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TelephonyKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class KeypadPressedEventArgs: IKeypadPressedEventArgs}
DEFINE_IID!(IID_KeypadPressedEventHandler, 3862406228, 50471, 16940, 137, 38, 201, 175, 131, 181, 89, 160);
RT_DELEGATE!{delegate KeypadPressedEventHandler(KeypadPressedEventHandlerVtbl, KeypadPressedEventHandlerImpl) [IID_KeypadPressedEventHandler] {
    fn Invoke(&self, sender: *mut CallControl, e: *mut KeypadPressedEventArgs) -> HRESULT
}}
impl KeypadPressedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &CallControl, e: &KeypadPressedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ILowLagPhotoControl, 1834765776, 64223, 16733, 174, 230, 59, 170, 82, 147, 0, 201);
RT_INTERFACE!{interface ILowLagPhotoControl(ILowLagPhotoControlVtbl): IInspectable(IInspectableVtbl) [IID_ILowLagPhotoControl] {
    fn GetHighestConcurrentFrameRate(&self, captureProperties: *mut super::mediaproperties::IMediaEncodingProperties, out: *mut *mut super::mediaproperties::MediaRatio) -> HRESULT,
    fn GetCurrentFrameRate(&self, out: *mut *mut super::mediaproperties::MediaRatio) -> HRESULT,
    fn get_ThumbnailEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_ThumbnailEnabled(&self, value: bool) -> HRESULT,
    fn get_ThumbnailFormat(&self, out: *mut super::mediaproperties::MediaThumbnailFormat) -> HRESULT,
    fn put_ThumbnailFormat(&self, value: super::mediaproperties::MediaThumbnailFormat) -> HRESULT,
    fn get_DesiredThumbnailSize(&self, out: *mut u32) -> HRESULT,
    fn put_DesiredThumbnailSize(&self, value: u32) -> HRESULT,
    fn get_HardwareAcceleratedThumbnailSupported(&self, out: *mut u32) -> HRESULT
}}
impl ILowLagPhotoControl {
    #[inline] pub unsafe fn get_highest_concurrent_frame_rate(&self, captureProperties: &super::mediaproperties::IMediaEncodingProperties) -> Result<ComPtr<super::mediaproperties::MediaRatio>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetHighestConcurrentFrameRate)(self as *const _ as *mut _, captureProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_frame_rate(&self) -> Result<ComPtr<super::mediaproperties::MediaRatio>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentFrameRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThumbnailEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_thumbnail_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ThumbnailEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail_format(&self) -> Result<super::mediaproperties::MediaThumbnailFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThumbnailFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_thumbnail_format(&self, value: super::mediaproperties::MediaThumbnailFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ThumbnailFormat)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_thumbnail_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredThumbnailSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_thumbnail_size(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredThumbnailSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hardware_accelerated_thumbnail_supported(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HardwareAcceleratedThumbnailSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class LowLagPhotoControl: ILowLagPhotoControl}
DEFINE_IID!(IID_ILowLagPhotoSequenceControl, 1037013149, 27926, 16540, 186, 254, 185, 165, 148, 198, 253, 230);
RT_INTERFACE!{interface ILowLagPhotoSequenceControl(ILowLagPhotoSequenceControlVtbl): IInspectable(IInspectableVtbl) [IID_ILowLagPhotoSequenceControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_MaxPastPhotos(&self, out: *mut u32) -> HRESULT,
    fn get_MaxPhotosPerSecond(&self, out: *mut f32) -> HRESULT,
    fn get_PastPhotoLimit(&self, out: *mut u32) -> HRESULT,
    fn put_PastPhotoLimit(&self, value: u32) -> HRESULT,
    fn get_PhotosPerSecondLimit(&self, out: *mut f32) -> HRESULT,
    fn put_PhotosPerSecondLimit(&self, value: f32) -> HRESULT,
    fn GetHighestConcurrentFrameRate(&self, captureProperties: *mut super::mediaproperties::IMediaEncodingProperties, out: *mut *mut super::mediaproperties::MediaRatio) -> HRESULT,
    fn GetCurrentFrameRate(&self, out: *mut *mut super::mediaproperties::MediaRatio) -> HRESULT,
    fn get_ThumbnailEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_ThumbnailEnabled(&self, value: bool) -> HRESULT,
    fn get_ThumbnailFormat(&self, out: *mut super::mediaproperties::MediaThumbnailFormat) -> HRESULT,
    fn put_ThumbnailFormat(&self, value: super::mediaproperties::MediaThumbnailFormat) -> HRESULT,
    fn get_DesiredThumbnailSize(&self, out: *mut u32) -> HRESULT,
    fn put_DesiredThumbnailSize(&self, value: u32) -> HRESULT,
    fn get_HardwareAcceleratedThumbnailSupported(&self, out: *mut u32) -> HRESULT
}}
impl ILowLagPhotoSequenceControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_past_photos(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxPastPhotos)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_photos_per_second(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxPhotosPerSecond)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_past_photo_limit(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PastPhotoLimit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_past_photo_limit(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PastPhotoLimit)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photos_per_second_limit(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PhotosPerSecondLimit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_photos_per_second_limit(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PhotosPerSecondLimit)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_highest_concurrent_frame_rate(&self, captureProperties: &super::mediaproperties::IMediaEncodingProperties) -> Result<ComPtr<super::mediaproperties::MediaRatio>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetHighestConcurrentFrameRate)(self as *const _ as *mut _, captureProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_frame_rate(&self) -> Result<ComPtr<super::mediaproperties::MediaRatio>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentFrameRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThumbnailEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_thumbnail_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ThumbnailEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbnail_format(&self) -> Result<super::mediaproperties::MediaThumbnailFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThumbnailFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_thumbnail_format(&self, value: super::mediaproperties::MediaThumbnailFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ThumbnailFormat)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_thumbnail_size(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredThumbnailSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_thumbnail_size(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DesiredThumbnailSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hardware_accelerated_thumbnail_supported(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HardwareAcceleratedThumbnailSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class LowLagPhotoSequenceControl: ILowLagPhotoSequenceControl}
RT_ENUM! { enum ManualFocusDistance: i32 {
    Infinity (ManualFocusDistance_Infinity) = 0, Hyperfocal (ManualFocusDistance_Hyperfocal) = 1, Nearest (ManualFocusDistance_Nearest) = 2,
}}
RT_ENUM! { enum MediaCaptureFocusState: i32 {
    Uninitialized (MediaCaptureFocusState_Uninitialized) = 0, Lost (MediaCaptureFocusState_Lost) = 1, Searching (MediaCaptureFocusState_Searching) = 2, Focused (MediaCaptureFocusState_Focused) = 3, Failed (MediaCaptureFocusState_Failed) = 4,
}}
RT_ENUM! { enum MediaCaptureOptimization: i32 {
    Default (MediaCaptureOptimization_Default) = 0, Quality (MediaCaptureOptimization_Quality) = 1, Latency (MediaCaptureOptimization_Latency) = 2, Power (MediaCaptureOptimization_Power) = 3, LatencyThenQuality (MediaCaptureOptimization_LatencyThenQuality) = 4, LatencyThenPower (MediaCaptureOptimization_LatencyThenPower) = 5, PowerAndQuality (MediaCaptureOptimization_PowerAndQuality) = 6,
}}
RT_ENUM! { enum MediaCapturePauseBehavior: i32 {
    RetainHardwareResources (MediaCapturePauseBehavior_RetainHardwareResources) = 0, ReleaseHardwareResources (MediaCapturePauseBehavior_ReleaseHardwareResources) = 1,
}}
RT_CLASS!{static class MediaDevice}
impl RtActivatable<IMediaDeviceStatics> for MediaDevice {}
impl MediaDevice {
    #[inline] pub fn get_audio_capture_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().get_audio_capture_selector()
    }}
    #[inline] pub fn get_audio_render_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().get_audio_render_selector()
    }}
    #[inline] pub fn get_video_capture_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().get_video_capture_selector()
    }}
    #[inline] pub fn get_default_audio_capture_id(role: AudioDeviceRole) -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().get_default_audio_capture_id(role)
    }}
    #[inline] pub fn get_default_audio_render_id(role: AudioDeviceRole) -> Result<HString> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().get_default_audio_render_id(role)
    }}
    #[inline] pub fn add_default_audio_capture_device_changed(handler: &super::super::foundation::TypedEventHandler<IInspectable, DefaultAudioCaptureDeviceChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().add_default_audio_capture_device_changed(handler)
    }}
    #[inline] pub fn remove_default_audio_capture_device_changed(cookie: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().remove_default_audio_capture_device_changed(cookie)
    }}
    #[inline] pub fn add_default_audio_render_device_changed(handler: &super::super::foundation::TypedEventHandler<IInspectable, DefaultAudioRenderDeviceChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().add_default_audio_render_device_changed(handler)
    }}
    #[inline] pub fn remove_default_audio_render_device_changed(cookie: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IMediaDeviceStatics>>::get_activation_factory().remove_default_audio_render_device_changed(cookie)
    }}
}
DEFINE_CLSID!(MediaDevice(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,77,101,100,105,97,68,101,118,105,99,101,0]) [CLSID_MediaDevice]);
DEFINE_IID!(IID_IMediaDeviceControl, 4020821929, 28533, 18531, 186, 11, 88, 63, 48, 54, 180, 222);
RT_INTERFACE!{interface IMediaDeviceControl(IMediaDeviceControlVtbl): IInspectable(IInspectableVtbl) [IID_IMediaDeviceControl] {
    fn get_Capabilities(&self, out: *mut *mut MediaDeviceControlCapabilities) -> HRESULT,
    fn TryGetValue(&self, value: *mut f64, out: *mut bool) -> HRESULT,
    fn TrySetValue(&self, value: f64, out: *mut bool) -> HRESULT,
    fn TryGetAuto(&self, value: *mut bool, out: *mut bool) -> HRESULT,
    fn TrySetAuto(&self, value: bool, out: *mut bool) -> HRESULT
}}
impl IMediaDeviceControl {
    #[inline] pub unsafe fn get_capabilities(&self) -> Result<ComPtr<MediaDeviceControlCapabilities>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Capabilities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_value(&self) -> Result<(f64, bool)> {
        let mut value = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryGetValue)(self as *const _ as *mut _, &mut value, &mut out);
        if hr == S_OK { Ok((value, out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_value(&self, value: f64) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetValue)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_auto(&self) -> Result<(bool, bool)> {
        let mut value = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryGetAuto)(self as *const _ as *mut _, &mut value, &mut out);
        if hr == S_OK { Ok((value, out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_auto(&self, value: bool) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetAuto)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaDeviceControl: IMediaDeviceControl}
DEFINE_IID!(IID_IMediaDeviceControlCapabilities, 587225110, 60293, 17378, 185, 43, 130, 64, 213, 238, 112, 236);
RT_INTERFACE!{interface IMediaDeviceControlCapabilities(IMediaDeviceControlCapabilitiesVtbl): IInspectable(IInspectableVtbl) [IID_IMediaDeviceControlCapabilities] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Min(&self, out: *mut f64) -> HRESULT,
    fn get_Max(&self, out: *mut f64) -> HRESULT,
    fn get_Step(&self, out: *mut f64) -> HRESULT,
    fn get_Default(&self, out: *mut f64) -> HRESULT,
    fn get_AutoModeSupported(&self, out: *mut bool) -> HRESULT
}}
impl IMediaDeviceControlCapabilities {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Default)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_mode_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoModeSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class MediaDeviceControlCapabilities: IMediaDeviceControlCapabilities}
DEFINE_IID!(IID_IMediaDeviceController, 4143510990, 8346, 18683, 134, 252, 212, 69, 120, 243, 23, 230);
RT_INTERFACE!{interface IMediaDeviceController(IMediaDeviceControllerVtbl): IInspectable(IInspectableVtbl) [IID_IMediaDeviceController] {
    fn GetAvailableMediaStreamProperties(&self, mediaStreamType: super::capture::MediaStreamType, out: *mut *mut super::super::foundation::collections::IVectorView<super::mediaproperties::IMediaEncodingProperties>) -> HRESULT,
    fn GetMediaStreamProperties(&self, mediaStreamType: super::capture::MediaStreamType, out: *mut *mut super::mediaproperties::IMediaEncodingProperties) -> HRESULT,
    fn SetMediaStreamPropertiesAsync(&self, mediaStreamType: super::capture::MediaStreamType, mediaEncodingProperties: *mut super::mediaproperties::IMediaEncodingProperties, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IMediaDeviceController {
    #[inline] pub unsafe fn get_available_media_stream_properties(&self, mediaStreamType: super::capture::MediaStreamType) -> Result<ComPtr<super::super::foundation::collections::IVectorView<super::mediaproperties::IMediaEncodingProperties>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAvailableMediaStreamProperties)(self as *const _ as *mut _, mediaStreamType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_media_stream_properties(&self, mediaStreamType: super::capture::MediaStreamType) -> Result<ComPtr<super::mediaproperties::IMediaEncodingProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMediaStreamProperties)(self as *const _ as *mut _, mediaStreamType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_media_stream_properties_async(&self, mediaStreamType: super::capture::MediaStreamType, mediaEncodingProperties: &super::mediaproperties::IMediaEncodingProperties) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetMediaStreamPropertiesAsync)(self as *const _ as *mut _, mediaStreamType, mediaEncodingProperties as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IMediaDeviceStatics, 2855115328, 37023, 19386, 191, 139, 12, 13, 41, 111, 20, 240);
RT_INTERFACE!{static interface IMediaDeviceStatics(IMediaDeviceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaDeviceStatics] {
    fn GetAudioCaptureSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetAudioRenderSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetVideoCaptureSelector(&self, out: *mut HSTRING) -> HRESULT,
    fn GetDefaultAudioCaptureId(&self, role: AudioDeviceRole, out: *mut HSTRING) -> HRESULT,
    fn GetDefaultAudioRenderId(&self, role: AudioDeviceRole, out: *mut HSTRING) -> HRESULT,
    fn add_DefaultAudioCaptureDeviceChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, DefaultAudioCaptureDeviceChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DefaultAudioCaptureDeviceChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DefaultAudioRenderDeviceChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, DefaultAudioRenderDeviceChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DefaultAudioRenderDeviceChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IMediaDeviceStatics {
    #[inline] pub unsafe fn get_audio_capture_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAudioCaptureSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_audio_render_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAudioRenderSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_video_capture_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetVideoCaptureSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_audio_capture_id(&self, role: AudioDeviceRole) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAudioCaptureId)(self as *const _ as *mut _, role, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_audio_render_id(&self, role: AudioDeviceRole) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultAudioRenderId)(self as *const _ as *mut _, role, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_default_audio_capture_device_changed(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, DefaultAudioCaptureDeviceChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DefaultAudioCaptureDeviceChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_default_audio_capture_device_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DefaultAudioCaptureDeviceChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_default_audio_render_device_changed(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, DefaultAudioRenderDeviceChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DefaultAudioRenderDeviceChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_default_audio_render_device_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DefaultAudioRenderDeviceChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IModuleCommandResult, 1376591540, 4980, 19581, 177, 228, 57, 220, 223, 62, 174, 78);
RT_INTERFACE!{interface IModuleCommandResult(IModuleCommandResultVtbl): IInspectable(IInspectableVtbl) [IID_IModuleCommandResult] {
    fn get_Status(&self, out: *mut SendCommandStatus) -> HRESULT,
    #[cfg(feature="windows-storage")] fn get_Result(&self, out: *mut *mut super::super::storage::streams::IBuffer) -> HRESULT
}}
impl IModuleCommandResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<SendCommandStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_result(&self) -> Result<ComPtr<super::super::storage::streams::IBuffer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ModuleCommandResult: IModuleCommandResult}
DEFINE_IID!(IID_IOpticalImageStabilizationControl, 3215825949, 188, 16955, 142, 178, 160, 23, 140, 169, 66, 71);
RT_INTERFACE!{interface IOpticalImageStabilizationControl(IOpticalImageStabilizationControlVtbl): IInspectable(IInspectableVtbl) [IID_IOpticalImageStabilizationControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_SupportedModes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<OpticalImageStabilizationMode>) -> HRESULT,
    fn get_Mode(&self, out: *mut OpticalImageStabilizationMode) -> HRESULT,
    fn put_Mode(&self, value: OpticalImageStabilizationMode) -> HRESULT
}}
impl IOpticalImageStabilizationControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_supported_modes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<OpticalImageStabilizationMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedModes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<OpticalImageStabilizationMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: OpticalImageStabilizationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class OpticalImageStabilizationControl: IOpticalImageStabilizationControl}
RT_ENUM! { enum OpticalImageStabilizationMode: i32 {
    Off (OpticalImageStabilizationMode_Off) = 0, On (OpticalImageStabilizationMode_On) = 1, Auto (OpticalImageStabilizationMode_Auto) = 2,
}}
DEFINE_IID!(IID_IPhotoConfirmationControl, 3371430755, 65374, 17794, 169, 168, 5, 80, 248, 90, 74, 118);
RT_INTERFACE!{interface IPhotoConfirmationControl(IPhotoConfirmationControlVtbl): IInspectable(IInspectableVtbl) [IID_IPhotoConfirmationControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_PixelFormat(&self, out: *mut super::mediaproperties::MediaPixelFormat) -> HRESULT,
    fn put_PixelFormat(&self, format: super::mediaproperties::MediaPixelFormat) -> HRESULT
}}
impl IPhotoConfirmationControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pixel_format(&self) -> Result<super::mediaproperties::MediaPixelFormat> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PixelFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pixel_format(&self, format: super::mediaproperties::MediaPixelFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PixelFormat)(self as *const _ as *mut _, format);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class PhotoConfirmationControl: IPhotoConfirmationControl}
DEFINE_IID!(IID_IRedialRequestedEventArgs, 2125812233, 30379, 19505, 180, 14, 75, 88, 55, 157, 88, 12);
RT_INTERFACE!{interface IRedialRequestedEventArgs(IRedialRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRedialRequestedEventArgs] {
    fn Handled(&self) -> HRESULT
}}
impl IRedialRequestedEventArgs {
    #[inline] pub unsafe fn handled(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Handled)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RedialRequestedEventArgs: IRedialRequestedEventArgs}
DEFINE_IID!(IID_RedialRequestedEventHandler, 3136444369, 20157, 19332, 159, 71, 110, 196, 61, 117, 216, 177);
RT_DELEGATE!{delegate RedialRequestedEventHandler(RedialRequestedEventHandlerVtbl, RedialRequestedEventHandlerImpl) [IID_RedialRequestedEventHandler] {
    fn Invoke(&self, sender: *mut CallControl, e: *mut RedialRequestedEventArgs) -> HRESULT
}}
impl RedialRequestedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &CallControl, e: &RedialRequestedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRegionOfInterest, 3857500212, 52838, 19973, 167, 143, 207, 57, 26, 94, 194, 209);
RT_INTERFACE!{interface IRegionOfInterest(IRegionOfInterestVtbl): IInspectable(IInspectableVtbl) [IID_IRegionOfInterest] {
    fn get_AutoFocusEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_AutoFocusEnabled(&self, value: bool) -> HRESULT,
    fn get_AutoWhiteBalanceEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_AutoWhiteBalanceEnabled(&self, value: bool) -> HRESULT,
    fn get_AutoExposureEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_AutoExposureEnabled(&self, value: bool) -> HRESULT,
    fn get_Bounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn put_Bounds(&self, value: super::super::foundation::Rect) -> HRESULT
}}
impl IRegionOfInterest {
    #[inline] pub unsafe fn get_auto_focus_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoFocusEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_focus_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoFocusEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_white_balance_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoWhiteBalanceEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_white_balance_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoWhiteBalanceEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_exposure_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoExposureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_exposure_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoExposureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bounds(&self, value: super::super::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Bounds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RegionOfInterest: IRegionOfInterest}
impl RtActivatable<IActivationFactory> for RegionOfInterest {}
DEFINE_CLSID!(RegionOfInterest(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,82,101,103,105,111,110,79,102,73,110,116,101,114,101,115,116,0]) [CLSID_RegionOfInterest]);
DEFINE_IID!(IID_IRegionOfInterest2, 436087441, 29610, 19793, 138, 157, 86, 204, 247, 219, 127, 84);
RT_INTERFACE!{interface IRegionOfInterest2(IRegionOfInterest2Vtbl): IInspectable(IInspectableVtbl) [IID_IRegionOfInterest2] {
    fn get_Type(&self, out: *mut RegionOfInterestType) -> HRESULT,
    fn put_Type(&self, value: RegionOfInterestType) -> HRESULT,
    fn get_BoundsNormalized(&self, out: *mut bool) -> HRESULT,
    fn put_BoundsNormalized(&self, value: bool) -> HRESULT,
    fn get_Weight(&self, out: *mut u32) -> HRESULT,
    fn put_Weight(&self, value: u32) -> HRESULT
}}
impl IRegionOfInterest2 {
    #[inline] pub unsafe fn get_type(&self) -> Result<RegionOfInterestType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_type(&self, value: RegionOfInterestType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Type)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounds_normalized(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundsNormalized)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bounds_normalized(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BoundsNormalized)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_weight(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Weight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_weight(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Weight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum RegionOfInterestType: i32 {
    Unknown (RegionOfInterestType_Unknown) = 0, Face (RegionOfInterestType_Face) = 1,
}}
DEFINE_IID!(IID_IRegionsOfInterestControl, 3273913639, 43787, 17752, 139, 91, 223, 86, 147, 219, 3, 120);
RT_INTERFACE!{interface IRegionsOfInterestControl(IRegionsOfInterestControlVtbl): IInspectable(IInspectableVtbl) [IID_IRegionsOfInterestControl] {
    fn get_MaxRegions(&self, out: *mut u32) -> HRESULT,
    fn SetRegionsAsync(&self, regions: *mut super::super::foundation::collections::IIterable<RegionOfInterest>, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SetRegionsWithLockAsync(&self, regions: *mut super::super::foundation::collections::IIterable<RegionOfInterest>, lockValues: bool, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ClearRegionsAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_AutoFocusSupported(&self, out: *mut bool) -> HRESULT,
    fn get_AutoWhiteBalanceSupported(&self, out: *mut bool) -> HRESULT,
    fn get_AutoExposureSupported(&self, out: *mut bool) -> HRESULT
}}
impl IRegionsOfInterestControl {
    #[inline] pub unsafe fn get_max_regions(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxRegions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_regions_async(&self, regions: &super::super::foundation::collections::IIterable<RegionOfInterest>) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetRegionsAsync)(self as *const _ as *mut _, regions as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_regions_with_lock_async(&self, regions: &super::super::foundation::collections::IIterable<RegionOfInterest>, lockValues: bool) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetRegionsWithLockAsync)(self as *const _ as *mut _, regions as *const _ as *mut _, lockValues, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_regions_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ClearRegionsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_focus_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoFocusSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_white_balance_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoWhiteBalanceSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_exposure_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoExposureSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RegionsOfInterestControl: IRegionsOfInterestControl}
DEFINE_IID!(IID_ISceneModeControl, 3566099191, 36185, 18516, 140, 98, 18, 199, 11, 168, 155, 124);
RT_INTERFACE!{interface ISceneModeControl(ISceneModeControlVtbl): IInspectable(IInspectableVtbl) [IID_ISceneModeControl] {
    fn get_SupportedModes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<CaptureSceneMode>) -> HRESULT,
    fn get_Value(&self, out: *mut CaptureSceneMode) -> HRESULT,
    fn SetValueAsync(&self, sceneMode: CaptureSceneMode, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ISceneModeControl {
    #[inline] pub unsafe fn get_supported_modes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<CaptureSceneMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedModes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<CaptureSceneMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value_async(&self, sceneMode: CaptureSceneMode) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetValueAsync)(self as *const _ as *mut _, sceneMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SceneModeControl: ISceneModeControl}
RT_ENUM! { enum SendCommandStatus: i32 {
    Success (SendCommandStatus_Success) = 0, DeviceNotAvailable (SendCommandStatus_DeviceNotAvailable) = 1,
}}
RT_ENUM! { enum TelephonyKey: i32 {
    D0 (TelephonyKey_D0) = 0, D1 (TelephonyKey_D1) = 1, D2 (TelephonyKey_D2) = 2, D3 (TelephonyKey_D3) = 3, D4 (TelephonyKey_D4) = 4, D5 (TelephonyKey_D5) = 5, D6 (TelephonyKey_D6) = 6, D7 (TelephonyKey_D7) = 7, D8 (TelephonyKey_D8) = 8, D9 (TelephonyKey_D9) = 9, Star (TelephonyKey_Star) = 10, Pound (TelephonyKey_Pound) = 11, A (TelephonyKey_A) = 12, B (TelephonyKey_B) = 13, C (TelephonyKey_C) = 14, D (TelephonyKey_D) = 15,
}}
DEFINE_IID!(IID_ITorchControl, 2785359461, 33360, 16748, 145, 154, 114, 66, 150, 175, 163, 6);
RT_INTERFACE!{interface ITorchControl(ITorchControlVtbl): IInspectable(IInspectableVtbl) [IID_ITorchControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_PowerSupported(&self, out: *mut bool) -> HRESULT,
    fn get_Enabled(&self, out: *mut bool) -> HRESULT,
    fn put_Enabled(&self, value: bool) -> HRESULT,
    fn get_PowerPercent(&self, out: *mut f32) -> HRESULT,
    fn put_PowerPercent(&self, value: f32) -> HRESULT
}}
impl ITorchControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_power_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PowerSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Enabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Enabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_power_percent(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PowerPercent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_power_percent(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PowerPercent)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TorchControl: ITorchControl}
DEFINE_IID!(IID_IVideoDeviceController, 2572506485, 11822, 16568, 182, 199, 248, 45, 16, 1, 50, 16);
RT_INTERFACE!{interface IVideoDeviceController(IVideoDeviceControllerVtbl): IInspectable(IInspectableVtbl) [IID_IVideoDeviceController] {
    fn get_Brightness(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Contrast(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Hue(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_WhiteBalance(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_BacklightCompensation(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Pan(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Tilt(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Zoom(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Roll(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Exposure(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn get_Focus(&self, out: *mut *mut MediaDeviceControl) -> HRESULT,
    fn TrySetPowerlineFrequency(&self, value: super::capture::PowerlineFrequency, out: *mut bool) -> HRESULT,
    fn TryGetPowerlineFrequency(&self, value: *mut super::capture::PowerlineFrequency, out: *mut bool) -> HRESULT
}}
impl IVideoDeviceController {
    #[inline] pub unsafe fn get_brightness(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Brightness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contrast(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contrast)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hue(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Hue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_white_balance(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WhiteBalance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_backlight_compensation(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BacklightCompensation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pan(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Pan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tilt(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tilt)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zoom(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Zoom)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_roll(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Roll)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exposure(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Exposure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus(&self) -> Result<ComPtr<MediaDeviceControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Focus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_powerline_frequency(&self, value: super::capture::PowerlineFrequency) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetPowerlineFrequency)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_get_powerline_frequency(&self) -> Result<(super::capture::PowerlineFrequency, bool)> {
        let mut value = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryGetPowerlineFrequency)(self as *const _ as *mut _, &mut value, &mut out);
        if hr == S_OK { Ok((value, out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoDeviceController: IVideoDeviceController}
DEFINE_IID!(IID_IVideoDeviceControllerGetDevicePropertyResult, 3319301013, 28373, 18320, 139, 93, 14, 241, 57, 53, 208, 248);
RT_INTERFACE!{interface IVideoDeviceControllerGetDevicePropertyResult(IVideoDeviceControllerGetDevicePropertyResultVtbl): IInspectable(IInspectableVtbl) [IID_IVideoDeviceControllerGetDevicePropertyResult] {
    fn get_Status(&self, out: *mut VideoDeviceControllerGetDevicePropertyStatus) -> HRESULT,
    fn get_Value(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IVideoDeviceControllerGetDevicePropertyResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<VideoDeviceControllerGetDevicePropertyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VideoDeviceControllerGetDevicePropertyResult: IVideoDeviceControllerGetDevicePropertyResult}
RT_ENUM! { enum VideoDeviceControllerGetDevicePropertyStatus: i32 {
    Success (VideoDeviceControllerGetDevicePropertyStatus_Success) = 0, UnknownFailure (VideoDeviceControllerGetDevicePropertyStatus_UnknownFailure) = 1, BufferTooSmall (VideoDeviceControllerGetDevicePropertyStatus_BufferTooSmall) = 2, NotSupported (VideoDeviceControllerGetDevicePropertyStatus_NotSupported) = 3, DeviceNotAvailable (VideoDeviceControllerGetDevicePropertyStatus_DeviceNotAvailable) = 4, MaxPropertyValueSizeTooSmall (VideoDeviceControllerGetDevicePropertyStatus_MaxPropertyValueSizeTooSmall) = 5, MaxPropertyValueSizeRequired (VideoDeviceControllerGetDevicePropertyStatus_MaxPropertyValueSizeRequired) = 6,
}}
RT_ENUM! { enum VideoDeviceControllerSetDevicePropertyStatus: i32 {
    Success (VideoDeviceControllerSetDevicePropertyStatus_Success) = 0, UnknownFailure (VideoDeviceControllerSetDevicePropertyStatus_UnknownFailure) = 1, NotSupported (VideoDeviceControllerSetDevicePropertyStatus_NotSupported) = 2, InvalidValue (VideoDeviceControllerSetDevicePropertyStatus_InvalidValue) = 3, DeviceNotAvailable (VideoDeviceControllerSetDevicePropertyStatus_DeviceNotAvailable) = 4, NotInControl (VideoDeviceControllerSetDevicePropertyStatus_NotInControl) = 5,
}}
DEFINE_IID!(IID_IWhiteBalanceControl, 2015298686, 29026, 18888, 168, 249, 148, 129, 197, 101, 54, 62);
RT_INTERFACE!{interface IWhiteBalanceControl(IWhiteBalanceControlVtbl): IInspectable(IInspectableVtbl) [IID_IWhiteBalanceControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Preset(&self, out: *mut ColorTemperaturePreset) -> HRESULT,
    fn SetPresetAsync(&self, preset: ColorTemperaturePreset, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_Min(&self, out: *mut u32) -> HRESULT,
    fn get_Max(&self, out: *mut u32) -> HRESULT,
    fn get_Step(&self, out: *mut u32) -> HRESULT,
    fn get_Value(&self, out: *mut u32) -> HRESULT,
    fn SetValueAsync(&self, temperature: u32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IWhiteBalanceControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preset(&self) -> Result<ColorTemperaturePreset> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Preset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preset_async(&self, preset: ColorTemperaturePreset) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetPresetAsync)(self as *const _ as *mut _, preset, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value_async(&self, temperature: u32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SetValueAsync)(self as *const _ as *mut _, temperature, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WhiteBalanceControl: IWhiteBalanceControl}
DEFINE_IID!(IID_IZoomControl, 975047442, 13018, 19479, 191, 215, 141, 12, 115, 200, 245, 165);
RT_INTERFACE!{interface IZoomControl(IZoomControlVtbl): IInspectable(IInspectableVtbl) [IID_IZoomControl] {
    fn get_Supported(&self, out: *mut bool) -> HRESULT,
    fn get_Min(&self, out: *mut f32) -> HRESULT,
    fn get_Max(&self, out: *mut f32) -> HRESULT,
    fn get_Step(&self, out: *mut f32) -> HRESULT,
    fn get_Value(&self, out: *mut f32) -> HRESULT,
    fn put_Value(&self, value: f32) -> HRESULT
}}
impl IZoomControl {
    #[inline] pub unsafe fn get_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Supported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Min)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Max)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_step(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Step)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Value)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ZoomControl: IZoomControl}
DEFINE_IID!(IID_IZoomControl2, 1770274224, 11929, 17985, 133, 41, 24, 79, 49, 157, 22, 113);
RT_INTERFACE!{interface IZoomControl2(IZoomControl2Vtbl): IInspectable(IInspectableVtbl) [IID_IZoomControl2] {
    fn get_SupportedModes(&self, out: *mut *mut super::super::foundation::collections::IVectorView<ZoomTransitionMode>) -> HRESULT,
    fn get_Mode(&self, out: *mut ZoomTransitionMode) -> HRESULT,
    fn Configure(&self, settings: *mut ZoomSettings) -> HRESULT
}}
impl IZoomControl2 {
    #[inline] pub unsafe fn get_supported_modes(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<ZoomTransitionMode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SupportedModes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mode(&self) -> Result<ZoomTransitionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn configure(&self, settings: &ZoomSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).Configure)(self as *const _ as *mut _, settings as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IZoomSettings, 1792437028, 5300, 19453, 177, 143, 136, 254, 36, 70, 59, 82);
RT_INTERFACE!{interface IZoomSettings(IZoomSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IZoomSettings] {
    fn get_Mode(&self, out: *mut ZoomTransitionMode) -> HRESULT,
    fn put_Mode(&self, value: ZoomTransitionMode) -> HRESULT,
    fn get_Value(&self, out: *mut f32) -> HRESULT,
    fn put_Value(&self, value: f32) -> HRESULT
}}
impl IZoomSettings {
    #[inline] pub unsafe fn get_mode(&self) -> Result<ZoomTransitionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: ZoomTransitionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Value)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ZoomSettings: IZoomSettings}
impl RtActivatable<IActivationFactory> for ZoomSettings {}
DEFINE_CLSID!(ZoomSettings(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,90,111,111,109,83,101,116,116,105,110,103,115,0]) [CLSID_ZoomSettings]);
RT_ENUM! { enum ZoomTransitionMode: i32 {
    Auto (ZoomTransitionMode_Auto) = 0, Direct (ZoomTransitionMode_Direct) = 1, Smooth (ZoomTransitionMode_Smooth) = 2,
}}
pub mod core { // Windows.Media.Devices.Core
use ::prelude::*;
DEFINE_IID!(IID_ICameraIntrinsics, 178711858, 25993, 18906, 175, 222, 89, 66, 112, 202, 10, 172);
RT_INTERFACE!{interface ICameraIntrinsics(ICameraIntrinsicsVtbl): IInspectable(IInspectableVtbl) [IID_ICameraIntrinsics] {
    fn get_FocalLength(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector2) -> HRESULT,
    fn get_PrincipalPoint(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector2) -> HRESULT,
    fn get_RadialDistortion(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT,
    fn get_TangentialDistortion(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector2) -> HRESULT,
    fn get_ImageWidth(&self, out: *mut u32) -> HRESULT,
    fn get_ImageHeight(&self, out: *mut u32) -> HRESULT,
    fn ProjectOntoFrame(&self, coordinate: ::rt::gen::windows::foundation::numerics::Vector3, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn UnprojectAtUnitDepth(&self, pixelCoordinate: ::rt::gen::windows::foundation::Point, out: *mut ::rt::gen::windows::foundation::numerics::Vector2) -> HRESULT,
    fn ProjectManyOntoFrame(&self, coordinatesSize: u32, coordinates: *mut ::rt::gen::windows::foundation::numerics::Vector3, resultsSize: u32, results: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn UnprojectPixelsAtUnitDepth(&self, pixelCoordinatesSize: u32, pixelCoordinates: *mut ::rt::gen::windows::foundation::Point, resultsSize: u32, results: *mut ::rt::gen::windows::foundation::numerics::Vector2) -> HRESULT
}}
impl ICameraIntrinsics {
    #[inline] pub unsafe fn get_focal_length(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocalLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_principal_point(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PrincipalPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_radial_distortion(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RadialDistortion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tangential_distortion(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TangentialDistortion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_image_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ImageWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_image_height(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ImageHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn project_onto_frame(&self, coordinate: ::rt::gen::windows::foundation::numerics::Vector3) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ProjectOntoFrame)(self as *const _ as *mut _, coordinate, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn unproject_at_unit_depth(&self, pixelCoordinate: ::rt::gen::windows::foundation::Point) -> Result<::rt::gen::windows::foundation::numerics::Vector2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).UnprojectAtUnitDepth)(self as *const _ as *mut _, pixelCoordinate, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn project_many_onto_frame(&self, coordinates: &[::rt::gen::windows::foundation::numerics::Vector3], results: &mut [::rt::gen::windows::foundation::Point]) -> Result<()> {
        let hr = ((*self.lpVtbl).ProjectManyOntoFrame)(self as *const _ as *mut _, coordinates.len() as u32, coordinates.as_ptr() as *mut _, results.len() as u32, results.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn unproject_pixels_at_unit_depth(&self, pixelCoordinates: &[::rt::gen::windows::foundation::Point], results: &mut [::rt::gen::windows::foundation::numerics::Vector2]) -> Result<()> {
        let hr = ((*self.lpVtbl).UnprojectPixelsAtUnitDepth)(self as *const _ as *mut _, pixelCoordinates.len() as u32, pixelCoordinates.as_ptr() as *mut _, results.len() as u32, results.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CameraIntrinsics: ICameraIntrinsics}
DEFINE_IID!(IID_ICameraIntrinsics2, 215655495, 1944, 19277, 131, 159, 197, 236, 65, 77, 178, 122);
RT_INTERFACE!{interface ICameraIntrinsics2(ICameraIntrinsics2Vtbl): IInspectable(IInspectableVtbl) [IID_ICameraIntrinsics2] {
    fn get_UndistortedProjectionTransform(&self, out: *mut ::rt::gen::windows::foundation::numerics::Matrix4x4) -> HRESULT,
    fn DistortPoint(&self, input: ::rt::gen::windows::foundation::Point, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn DistortPoints(&self, inputsSize: u32, inputs: *mut ::rt::gen::windows::foundation::Point, resultsSize: u32, results: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn UndistortPoint(&self, input: ::rt::gen::windows::foundation::Point, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn UndistortPoints(&self, inputsSize: u32, inputs: *mut ::rt::gen::windows::foundation::Point, resultsSize: u32, results: *mut ::rt::gen::windows::foundation::Point) -> HRESULT
}}
impl ICameraIntrinsics2 {
    #[inline] pub unsafe fn get_undistorted_projection_transform(&self) -> Result<::rt::gen::windows::foundation::numerics::Matrix4x4> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndistortedProjectionTransform)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn distort_point(&self, input: ::rt::gen::windows::foundation::Point) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).DistortPoint)(self as *const _ as *mut _, input, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn distort_points(&self, inputs: &[::rt::gen::windows::foundation::Point], results: &mut [::rt::gen::windows::foundation::Point]) -> Result<()> {
        let hr = ((*self.lpVtbl).DistortPoints)(self as *const _ as *mut _, inputs.len() as u32, inputs.as_ptr() as *mut _, results.len() as u32, results.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn undistort_point(&self, input: ::rt::gen::windows::foundation::Point) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).UndistortPoint)(self as *const _ as *mut _, input, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn undistort_points(&self, inputs: &[::rt::gen::windows::foundation::Point], results: &mut [::rt::gen::windows::foundation::Point]) -> Result<()> {
        let hr = ((*self.lpVtbl).UndistortPoints)(self as *const _ as *mut _, inputs.len() as u32, inputs.as_ptr() as *mut _, results.len() as u32, results.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICameraIntrinsicsFactory, 3235759238, 8498, 18996, 166, 89, 155, 254, 42, 5, 87, 18);
RT_INTERFACE!{interface ICameraIntrinsicsFactory(ICameraIntrinsicsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICameraIntrinsicsFactory] {
    fn Create(&self, focalLength: ::rt::gen::windows::foundation::numerics::Vector2, principalPoint: ::rt::gen::windows::foundation::numerics::Vector2, radialDistortion: ::rt::gen::windows::foundation::numerics::Vector3, tangentialDistortion: ::rt::gen::windows::foundation::numerics::Vector2, imageWidth: u32, imageHeight: u32, out: *mut *mut CameraIntrinsics) -> HRESULT
}}
impl ICameraIntrinsicsFactory {
    #[inline] pub unsafe fn create(&self, focalLength: ::rt::gen::windows::foundation::numerics::Vector2, principalPoint: ::rt::gen::windows::foundation::numerics::Vector2, radialDistortion: ::rt::gen::windows::foundation::numerics::Vector3, tangentialDistortion: ::rt::gen::windows::foundation::numerics::Vector2, imageWidth: u32, imageHeight: u32) -> Result<ComPtr<CameraIntrinsics>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, focalLength, principalPoint, radialDistortion, tangentialDistortion, imageWidth, imageHeight, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDepthCorrelatedCoordinateMapper, 4183656955, 35568, 19632, 146, 109, 105, 104, 102, 229, 4, 106);
RT_INTERFACE!{interface IDepthCorrelatedCoordinateMapper(IDepthCorrelatedCoordinateMapperVtbl): IInspectable(IInspectableVtbl) [IID_IDepthCorrelatedCoordinateMapper] {
    #[cfg(feature="windows-perception")] fn UnprojectPoint(&self, sourcePoint: ::rt::gen::windows::foundation::Point, targetCoordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT,
    #[cfg(feature="windows-perception")] fn UnprojectPoints(&self, sourcePointsSize: u32, sourcePoints: *mut ::rt::gen::windows::foundation::Point, targetCoordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, resultsSize: u32, results: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT,
    #[cfg(feature="windows-perception")] fn MapPoint(&self, sourcePoint: ::rt::gen::windows::foundation::Point, targetCoordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, targetCameraIntrinsics: *mut CameraIntrinsics, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    #[cfg(feature="windows-perception")] fn MapPoints(&self, sourcePointsSize: u32, sourcePoints: *mut ::rt::gen::windows::foundation::Point, targetCoordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, targetCameraIntrinsics: *mut CameraIntrinsics, resultsSize: u32, results: *mut ::rt::gen::windows::foundation::Point) -> HRESULT
}}
impl IDepthCorrelatedCoordinateMapper {
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn unproject_point(&self, sourcePoint: ::rt::gen::windows::foundation::Point, targetCoordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).UnprojectPoint)(self as *const _ as *mut _, sourcePoint, targetCoordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn unproject_points(&self, sourcePoints: &[::rt::gen::windows::foundation::Point], targetCoordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, results: &mut [::rt::gen::windows::foundation::numerics::Vector3]) -> Result<()> {
        let hr = ((*self.lpVtbl).UnprojectPoints)(self as *const _ as *mut _, sourcePoints.len() as u32, sourcePoints.as_ptr() as *mut _, targetCoordinateSystem as *const _ as *mut _, results.len() as u32, results.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn map_point(&self, sourcePoint: ::rt::gen::windows::foundation::Point, targetCoordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, targetCameraIntrinsics: &CameraIntrinsics) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MapPoint)(self as *const _ as *mut _, sourcePoint, targetCoordinateSystem as *const _ as *mut _, targetCameraIntrinsics as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn map_points(&self, sourcePoints: &[::rt::gen::windows::foundation::Point], targetCoordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, targetCameraIntrinsics: &CameraIntrinsics, results: &mut [::rt::gen::windows::foundation::Point]) -> Result<()> {
        let hr = ((*self.lpVtbl).MapPoints)(self as *const _ as *mut _, sourcePoints.len() as u32, sourcePoints.as_ptr() as *mut _, targetCoordinateSystem as *const _ as *mut _, targetCameraIntrinsics as *const _ as *mut _, results.len() as u32, results.as_mut_ptr() as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DepthCorrelatedCoordinateMapper: IDepthCorrelatedCoordinateMapper}
DEFINE_IID!(IID_IFrameControlCapabilities, 2835328608, 20126, 17271, 167, 137, 226, 76, 74, 231, 229, 68);
RT_INTERFACE!{interface IFrameControlCapabilities(IFrameControlCapabilitiesVtbl): IInspectable(IInspectableVtbl) [IID_IFrameControlCapabilities] {
    fn get_Exposure(&self, out: *mut *mut FrameExposureCapabilities) -> HRESULT,
    fn get_ExposureCompensation(&self, out: *mut *mut FrameExposureCompensationCapabilities) -> HRESULT,
    fn get_IsoSpeed(&self, out: *mut *mut FrameIsoSpeedCapabilities) -> HRESULT,
    fn get_Focus(&self, out: *mut *mut FrameFocusCapabilities) -> HRESULT,
    fn get_PhotoConfirmationSupported(&self, out: *mut bool) -> HRESULT
}}
impl IFrameControlCapabilities {
    #[inline] pub unsafe fn get_exposure(&self) -> Result<ComPtr<FrameExposureCapabilities>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Exposure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exposure_compensation(&self) -> Result<ComPtr<FrameExposureCompensationCapabilities>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposureCompensation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_iso_speed(&self) -> Result<ComPtr<FrameIsoSpeedCapabilities>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsoSpeed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus(&self) -> Result<ComPtr<FrameFocusCapabilities>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Focus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photo_confirmation_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PhotoConfirmationSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class FrameControlCapabilities: IFrameControlCapabilities}
DEFINE_IID!(IID_IFrameControlCapabilities2, 3466265700, 18224, 17423, 189, 62, 239, 232, 168, 242, 48, 168);
RT_INTERFACE!{interface IFrameControlCapabilities2(IFrameControlCapabilities2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameControlCapabilities2] {
    fn get_Flash(&self, out: *mut *mut FrameFlashCapabilities) -> HRESULT
}}
impl IFrameControlCapabilities2 {
    #[inline] pub unsafe fn get_flash(&self) -> Result<ComPtr<FrameFlashCapabilities>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Flash)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameController, 3244579289, 47855, 16466, 145, 119, 72, 175, 242, 175, 117, 34);
RT_INTERFACE!{interface IFrameController(IFrameControllerVtbl): IInspectable(IInspectableVtbl) [IID_IFrameController] {
    fn get_ExposureControl(&self, out: *mut *mut FrameExposureControl) -> HRESULT,
    fn get_ExposureCompensationControl(&self, out: *mut *mut FrameExposureCompensationControl) -> HRESULT,
    fn get_IsoSpeedControl(&self, out: *mut *mut FrameIsoSpeedControl) -> HRESULT,
    fn get_FocusControl(&self, out: *mut *mut FrameFocusControl) -> HRESULT,
    fn get_PhotoConfirmationEnabled(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<bool>) -> HRESULT,
    fn put_PhotoConfirmationEnabled(&self, value: *mut ::rt::gen::windows::foundation::IReference<bool>) -> HRESULT
}}
impl IFrameController {
    #[inline] pub unsafe fn get_exposure_control(&self) -> Result<ComPtr<FrameExposureControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposureControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exposure_compensation_control(&self) -> Result<ComPtr<FrameExposureCompensationControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExposureCompensationControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_iso_speed_control(&self) -> Result<ComPtr<FrameIsoSpeedControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsoSpeedControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_control(&self) -> Result<ComPtr<FrameFocusControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_photo_confirmation_enabled(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhotoConfirmationEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_photo_confirmation_enabled(&self, value: &::rt::gen::windows::foundation::IReference<bool>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PhotoConfirmationEnabled)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FrameController: IFrameController}
impl RtActivatable<IActivationFactory> for FrameController {}
DEFINE_CLSID!(FrameController(&[87,105,110,100,111,119,115,46,77,101,100,105,97,46,68,101,118,105,99,101,115,46,67,111,114,101,46,70,114,97,109,101,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_FrameController]);
DEFINE_IID!(IID_IFrameController2, 13876341, 55420, 18523, 138, 9, 92, 53, 133, 104, 180, 39);
RT_INTERFACE!{interface IFrameController2(IFrameController2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameController2] {
    fn get_FlashControl(&self, out: *mut *mut FrameFlashControl) -> HRESULT
}}
impl IFrameController2 {
    #[inline] pub unsafe fn get_flash_control(&self) -> Result<ComPtr<FrameFlashControl>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlashControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameExposureCapabilities, 3183385827, 14725, 20082, 151, 194, 5, 144, 214, 19, 7, 161);
RT_INTERFACE!{interface IFrameExposureCapabilities(IFrameExposureCapabilitiesVtbl): I