use ::prelude::*;
RT_STRUCT! { struct Color {
    A: u8, R: u8, G: u8, B: u8,
}}
DEFINE_IID!(IID_IColorHelper, 423427047, 26055, 17728, 173, 8, 98, 131, 186, 118, 135, 154);
RT_INTERFACE!{interface IColorHelper(IColorHelperVtbl): IInspectable(IInspectableVtbl) [IID_IColorHelper] {
    
}}
RT_CLASS!{class ColorHelper: IColorHelper}
impl RtActivatable<IColorHelperStatics> for ColorHelper {}
impl RtActivatable<IColorHelperStatics2> for ColorHelper {}
impl ColorHelper {
    #[inline] pub fn from_argb(a: u8, r: u8, g: u8, b: u8) -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorHelperStatics>>::get_activation_factory().from_argb(a, r, g, b)
    }}
    #[inline] pub fn to_display_name(color: Color) -> Result<HString> { unsafe {
        <Self as RtActivatable<IColorHelperStatics2>>::get_activation_factory().to_display_name(color)
    }}
}
DEFINE_CLSID!(ColorHelper(&[87,105,110,100,111,119,115,46,85,73,46,67,111,108,111,114,72,101,108,112,101,114,0]) [CLSID_ColorHelper]);
DEFINE_IID!(IID_IColorHelperStatics, 2231688170, 64362, 16708, 166, 194, 51, 73, 156, 146, 132, 245);
RT_INTERFACE!{static interface IColorHelperStatics(IColorHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IColorHelperStatics] {
    fn FromArgb(&self, a: u8, r: u8, g: u8, b: u8, out: *mut Color) -> HRESULT
}}
impl IColorHelperStatics {
    #[inline] pub unsafe fn from_argb(&self, a: u8, r: u8, g: u8, b: u8) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromArgb)(self as *const _ as *mut _, a, r, g, b, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IColorHelperStatics2, 618245890, 28336, 19348, 133, 92, 252, 240, 129, 141, 154, 22);
RT_INTERFACE!{static interface IColorHelperStatics2(IColorHelperStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IColorHelperStatics2] {
    fn ToDisplayName(&self, color: Color, out: *mut HSTRING) -> HRESULT
}}
impl IColorHelperStatics2 {
    #[inline] pub unsafe fn to_display_name(&self, color: Color) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ToDisplayName)(self as *const _ as *mut _, color, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IColors, 2609681190, 19622, 19685, 137, 148, 158, 255, 101, 202, 189, 204);
RT_INTERFACE!{interface IColors(IColorsVtbl): IInspectable(IInspectableVtbl) [IID_IColors] {
    
}}
RT_CLASS!{class Colors: IColors}
impl RtActivatable<IColorsStatics> for Colors {}
impl Colors {
    #[inline] pub fn get_alice_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_alice_blue()
    }}
    #[inline] pub fn get_antique_white() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_antique_white()
    }}
    #[inline] pub fn get_aqua() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_aqua()
    }}
    #[inline] pub fn get_aquamarine() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_aquamarine()
    }}
    #[inline] pub fn get_azure() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_azure()
    }}
    #[inline] pub fn get_beige() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_beige()
    }}
    #[inline] pub fn get_bisque() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_bisque()
    }}
    #[inline] pub fn get_black() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_black()
    }}
    #[inline] pub fn get_blanched_almond() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_blanched_almond()
    }}
    #[inline] pub fn get_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_blue()
    }}
    #[inline] pub fn get_blue_violet() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_blue_violet()
    }}
    #[inline] pub fn get_brown() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_brown()
    }}
    #[inline] pub fn get_burly_wood() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_burly_wood()
    }}
    #[inline] pub fn get_cadet_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_cadet_blue()
    }}
    #[inline] pub fn get_chartreuse() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_chartreuse()
    }}
    #[inline] pub fn get_chocolate() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_chocolate()
    }}
    #[inline] pub fn get_coral() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_coral()
    }}
    #[inline] pub fn get_cornflower_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_cornflower_blue()
    }}
    #[inline] pub fn get_cornsilk() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_cornsilk()
    }}
    #[inline] pub fn get_crimson() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_crimson()
    }}
    #[inline] pub fn get_cyan() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_cyan()
    }}
    #[inline] pub fn get_dark_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_blue()
    }}
    #[inline] pub fn get_dark_cyan() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_cyan()
    }}
    #[inline] pub fn get_dark_goldenrod() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_goldenrod()
    }}
    #[inline] pub fn get_dark_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_gray()
    }}
    #[inline] pub fn get_dark_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_green()
    }}
    #[inline] pub fn get_dark_khaki() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_khaki()
    }}
    #[inline] pub fn get_dark_magenta() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_magenta()
    }}
    #[inline] pub fn get_dark_olive_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_olive_green()
    }}
    #[inline] pub fn get_dark_orange() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_orange()
    }}
    #[inline] pub fn get_dark_orchid() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_orchid()
    }}
    #[inline] pub fn get_dark_red() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_red()
    }}
    #[inline] pub fn get_dark_salmon() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_salmon()
    }}
    #[inline] pub fn get_dark_sea_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_sea_green()
    }}
    #[inline] pub fn get_dark_slate_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_slate_blue()
    }}
    #[inline] pub fn get_dark_slate_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_slate_gray()
    }}
    #[inline] pub fn get_dark_turquoise() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_turquoise()
    }}
    #[inline] pub fn get_dark_violet() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dark_violet()
    }}
    #[inline] pub fn get_deep_pink() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_deep_pink()
    }}
    #[inline] pub fn get_deep_sky_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_deep_sky_blue()
    }}
    #[inline] pub fn get_dim_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dim_gray()
    }}
    #[inline] pub fn get_dodger_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_dodger_blue()
    }}
    #[inline] pub fn get_firebrick() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_firebrick()
    }}
    #[inline] pub fn get_floral_white() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_floral_white()
    }}
    #[inline] pub fn get_forest_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_forest_green()
    }}
    #[inline] pub fn get_fuchsia() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_fuchsia()
    }}
    #[inline] pub fn get_gainsboro() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_gainsboro()
    }}
    #[inline] pub fn get_ghost_white() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_ghost_white()
    }}
    #[inline] pub fn get_gold() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_gold()
    }}
    #[inline] pub fn get_goldenrod() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_goldenrod()
    }}
    #[inline] pub fn get_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_gray()
    }}
    #[inline] pub fn get_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_green()
    }}
    #[inline] pub fn get_green_yellow() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_green_yellow()
    }}
    #[inline] pub fn get_honeydew() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_honeydew()
    }}
    #[inline] pub fn get_hot_pink() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_hot_pink()
    }}
    #[inline] pub fn get_indian_red() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_indian_red()
    }}
    #[inline] pub fn get_indigo() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_indigo()
    }}
    #[inline] pub fn get_ivory() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_ivory()
    }}
    #[inline] pub fn get_khaki() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_khaki()
    }}
    #[inline] pub fn get_lavender() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_lavender()
    }}
    #[inline] pub fn get_lavender_blush() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_lavender_blush()
    }}
    #[inline] pub fn get_lawn_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_lawn_green()
    }}
    #[inline] pub fn get_lemon_chiffon() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_lemon_chiffon()
    }}
    #[inline] pub fn get_light_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_blue()
    }}
    #[inline] pub fn get_light_coral() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_coral()
    }}
    #[inline] pub fn get_light_cyan() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_cyan()
    }}
    #[inline] pub fn get_light_goldenrod_yellow() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_goldenrod_yellow()
    }}
    #[inline] pub fn get_light_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_green()
    }}
    #[inline] pub fn get_light_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_gray()
    }}
    #[inline] pub fn get_light_pink() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_pink()
    }}
    #[inline] pub fn get_light_salmon() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_salmon()
    }}
    #[inline] pub fn get_light_sea_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_sea_green()
    }}
    #[inline] pub fn get_light_sky_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_sky_blue()
    }}
    #[inline] pub fn get_light_slate_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_slate_gray()
    }}
    #[inline] pub fn get_light_steel_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_steel_blue()
    }}
    #[inline] pub fn get_light_yellow() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_light_yellow()
    }}
    #[inline] pub fn get_lime() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_lime()
    }}
    #[inline] pub fn get_lime_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_lime_green()
    }}
    #[inline] pub fn get_linen() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_linen()
    }}
    #[inline] pub fn get_magenta() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_magenta()
    }}
    #[inline] pub fn get_maroon() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_maroon()
    }}
    #[inline] pub fn get_medium_aquamarine() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_aquamarine()
    }}
    #[inline] pub fn get_medium_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_blue()
    }}
    #[inline] pub fn get_medium_orchid() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_orchid()
    }}
    #[inline] pub fn get_medium_purple() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_purple()
    }}
    #[inline] pub fn get_medium_sea_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_sea_green()
    }}
    #[inline] pub fn get_medium_slate_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_slate_blue()
    }}
    #[inline] pub fn get_medium_spring_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_spring_green()
    }}
    #[inline] pub fn get_medium_turquoise() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_turquoise()
    }}
    #[inline] pub fn get_medium_violet_red() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_medium_violet_red()
    }}
    #[inline] pub fn get_midnight_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_midnight_blue()
    }}
    #[inline] pub fn get_mint_cream() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_mint_cream()
    }}
    #[inline] pub fn get_misty_rose() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_misty_rose()
    }}
    #[inline] pub fn get_moccasin() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_moccasin()
    }}
    #[inline] pub fn get_navajo_white() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_navajo_white()
    }}
    #[inline] pub fn get_navy() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_navy()
    }}
    #[inline] pub fn get_old_lace() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_old_lace()
    }}
    #[inline] pub fn get_olive() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_olive()
    }}
    #[inline] pub fn get_olive_drab() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_olive_drab()
    }}
    #[inline] pub fn get_orange() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_orange()
    }}
    #[inline] pub fn get_orange_red() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_orange_red()
    }}
    #[inline] pub fn get_orchid() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_orchid()
    }}
    #[inline] pub fn get_pale_goldenrod() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_pale_goldenrod()
    }}
    #[inline] pub fn get_pale_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_pale_green()
    }}
    #[inline] pub fn get_pale_turquoise() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_pale_turquoise()
    }}
    #[inline] pub fn get_pale_violet_red() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_pale_violet_red()
    }}
    #[inline] pub fn get_papaya_whip() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_papaya_whip()
    }}
    #[inline] pub fn get_peach_puff() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_peach_puff()
    }}
    #[inline] pub fn get_peru() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_peru()
    }}
    #[inline] pub fn get_pink() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_pink()
    }}
    #[inline] pub fn get_plum() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_plum()
    }}
    #[inline] pub fn get_powder_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_powder_blue()
    }}
    #[inline] pub fn get_purple() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_purple()
    }}
    #[inline] pub fn get_red() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_red()
    }}
    #[inline] pub fn get_rosy_brown() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_rosy_brown()
    }}
    #[inline] pub fn get_royal_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_royal_blue()
    }}
    #[inline] pub fn get_saddle_brown() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_saddle_brown()
    }}
    #[inline] pub fn get_salmon() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_salmon()
    }}
    #[inline] pub fn get_sandy_brown() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_sandy_brown()
    }}
    #[inline] pub fn get_sea_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_sea_green()
    }}
    #[inline] pub fn get_sea_shell() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_sea_shell()
    }}
    #[inline] pub fn get_sienna() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_sienna()
    }}
    #[inline] pub fn get_silver() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_silver()
    }}
    #[inline] pub fn get_sky_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_sky_blue()
    }}
    #[inline] pub fn get_slate_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_slate_blue()
    }}
    #[inline] pub fn get_slate_gray() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_slate_gray()
    }}
    #[inline] pub fn get_snow() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_snow()
    }}
    #[inline] pub fn get_spring_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_spring_green()
    }}
    #[inline] pub fn get_steel_blue() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_steel_blue()
    }}
    #[inline] pub fn get_tan() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_tan()
    }}
    #[inline] pub fn get_teal() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_teal()
    }}
    #[inline] pub fn get_thistle() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_thistle()
    }}
    #[inline] pub fn get_tomato() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_tomato()
    }}
    #[inline] pub fn get_transparent() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_transparent()
    }}
    #[inline] pub fn get_turquoise() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_turquoise()
    }}
    #[inline] pub fn get_violet() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_violet()
    }}
    #[inline] pub fn get_wheat() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_wheat()
    }}
    #[inline] pub fn get_white() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_white()
    }}
    #[inline] pub fn get_white_smoke() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_white_smoke()
    }}
    #[inline] pub fn get_yellow() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_yellow()
    }}
    #[inline] pub fn get_yellow_green() -> Result<Color> { unsafe {
        <Self as RtActivatable<IColorsStatics>>::get_activation_factory().get_yellow_green()
    }}
}
DEFINE_CLSID!(Colors(&[87,105,110,100,111,119,115,46,85,73,46,67,111,108,111,114,115,0]) [CLSID_Colors]);
DEFINE_IID!(IID_IColorsStatics, 3488951812, 52390, 17940, 161, 126, 117, 73, 16, 200, 74, 153);
RT_INTERFACE!{static interface IColorsStatics(IColorsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IColorsStatics] {
    fn get_AliceBlue(&self, out: *mut Color) -> HRESULT,
    fn get_AntiqueWhite(&self, out: *mut Color) -> HRESULT,
    fn get_Aqua(&self, out: *mut Color) -> HRESULT,
    fn get_Aquamarine(&self, out: *mut Color) -> HRESULT,
    fn get_Azure(&self, out: *mut Color) -> HRESULT,
    fn get_Beige(&self, out: *mut Color) -> HRESULT,
    fn get_Bisque(&self, out: *mut Color) -> HRESULT,
    fn get_Black(&self, out: *mut Color) -> HRESULT,
    fn get_BlanchedAlmond(&self, out: *mut Color) -> HRESULT,
    fn get_Blue(&self, out: *mut Color) -> HRESULT,
    fn get_BlueViolet(&self, out: *mut Color) -> HRESULT,
    fn get_Brown(&self, out: *mut Color) -> HRESULT,
    fn get_BurlyWood(&self, out: *mut Color) -> HRESULT,
    fn get_CadetBlue(&self, out: *mut Color) -> HRESULT,
    fn get_Chartreuse(&self, out: *mut Color) -> HRESULT,
    fn get_Chocolate(&self, out: *mut Color) -> HRESULT,
    fn get_Coral(&self, out: *mut Color) -> HRESULT,
    fn get_CornflowerBlue(&self, out: *mut Color) -> HRESULT,
    fn get_Cornsilk(&self, out: *mut Color) -> HRESULT,
    fn get_Crimson(&self, out: *mut Color) -> HRESULT,
    fn get_Cyan(&self, out: *mut Color) -> HRESULT,
    fn get_DarkBlue(&self, out: *mut Color) -> HRESULT,
    fn get_DarkCyan(&self, out: *mut Color) -> HRESULT,
    fn get_DarkGoldenrod(&self, out: *mut Color) -> HRESULT,
    fn get_DarkGray(&self, out: *mut Color) -> HRESULT,
    fn get_DarkGreen(&self, out: *mut Color) -> HRESULT,
    fn get_DarkKhaki(&self, out: *mut Color) -> HRESULT,
    fn get_DarkMagenta(&self, out: *mut Color) -> HRESULT,
    fn get_DarkOliveGreen(&self, out: *mut Color) -> HRESULT,
    fn get_DarkOrange(&self, out: *mut Color) -> HRESULT,
    fn get_DarkOrchid(&self, out: *mut Color) -> HRESULT,
    fn get_DarkRed(&self, out: *mut Color) -> HRESULT,
    fn get_DarkSalmon(&self, out: *mut Color) -> HRESULT,
    fn get_DarkSeaGreen(&self, out: *mut Color) -> HRESULT,
    fn get_DarkSlateBlue(&self, out: *mut Color) -> HRESULT,
    fn get_DarkSlateGray(&self, out: *mut Color) -> HRESULT,
    fn get_DarkTurquoise(&self, out: *mut Color) -> HRESULT,
    fn get_DarkViolet(&self, out: *mut Color) -> HRESULT,
    fn get_DeepPink(&self, out: *mut Color) -> HRESULT,
    fn get_DeepSkyBlue(&self, out: *mut Color) -> HRESULT,
    fn get_DimGray(&self, out: *mut Color) -> HRESULT,
    fn get_DodgerBlue(&self, out: *mut Color) -> HRESULT,
    fn get_Firebrick(&self, out: *mut Color) -> HRESULT,
    fn get_FloralWhite(&self, out: *mut Color) -> HRESULT,
    fn get_ForestGreen(&self, out: *mut Color) -> HRESULT,
    fn get_Fuchsia(&self, out: *mut Color) -> HRESULT,
    fn get_Gainsboro(&self, out: *mut Color) -> HRESULT,
    fn get_GhostWhite(&self, out: *mut Color) -> HRESULT,
    fn get_Gold(&self, out: *mut Color) -> HRESULT,
    fn get_Goldenrod(&self, out: *mut Color) -> HRESULT,
    fn get_Gray(&self, out: *mut Color) -> HRESULT,
    fn get_Green(&self, out: *mut Color) -> HRESULT,
    fn get_GreenYellow(&self, out: *mut Color) -> HRESULT,
    fn get_Honeydew(&self, out: *mut Color) -> HRESULT,
    fn get_HotPink(&self, out: *mut Color) -> HRESULT,
    fn get_IndianRed(&self, out: *mut Color) -> HRESULT,
    fn get_Indigo(&self, out: *mut Color) -> HRESULT,
    fn get_Ivory(&self, out: *mut Color) -> HRESULT,
    fn get_Khaki(&self, out: *mut Color) -> HRESULT,
    fn get_Lavender(&self, out: *mut Color) -> HRESULT,
    fn get_LavenderBlush(&self, out: *mut Color) -> HRESULT,
    fn get_LawnGreen(&self, out: *mut Color) -> HRESULT,
    fn get_LemonChiffon(&self, out: *mut Color) -> HRESULT,
    fn get_LightBlue(&self, out: *mut Color) -> HRESULT,
    fn get_LightCoral(&self, out: *mut Color) -> HRESULT,
    fn get_LightCyan(&self, out: *mut Color) -> HRESULT,
    fn get_LightGoldenrodYellow(&self, out: *mut Color) -> HRESULT,
    fn get_LightGreen(&self, out: *mut Color) -> HRESULT,
    fn get_LightGray(&self, out: *mut Color) -> HRESULT,
    fn get_LightPink(&self, out: *mut Color) -> HRESULT,
    fn get_LightSalmon(&self, out: *mut Color) -> HRESULT,
    fn get_LightSeaGreen(&self, out: *mut Color) -> HRESULT,
    fn get_LightSkyBlue(&self, out: *mut Color) -> HRESULT,
    fn get_LightSlateGray(&self, out: *mut Color) -> HRESULT,
    fn get_LightSteelBlue(&self, out: *mut Color) -> HRESULT,
    fn get_LightYellow(&self, out: *mut Color) -> HRESULT,
    fn get_Lime(&self, out: *mut Color) -> HRESULT,
    fn get_LimeGreen(&self, out: *mut Color) -> HRESULT,
    fn get_Linen(&self, out: *mut Color) -> HRESULT,
    fn get_Magenta(&self, out: *mut Color) -> HRESULT,
    fn get_Maroon(&self, out: *mut Color) -> HRESULT,
    fn get_MediumAquamarine(&self, out: *mut Color) -> HRESULT,
    fn get_MediumBlue(&self, out: *mut Color) -> HRESULT,
    fn get_MediumOrchid(&self, out: *mut Color) -> HRESULT,
    fn get_MediumPurple(&self, out: *mut Color) -> HRESULT,
    fn get_MediumSeaGreen(&self, out: *mut Color) -> HRESULT,
    fn get_MediumSlateBlue(&self, out: *mut Color) -> HRESULT,
    fn get_MediumSpringGreen(&self, out: *mut Color) -> HRESULT,
    fn get_MediumTurquoise(&self, out: *mut Color) -> HRESULT,
    fn get_MediumVioletRed(&self, out: *mut Color) -> HRESULT,
    fn get_MidnightBlue(&self, out: *mut Color) -> HRESULT,
    fn get_MintCream(&self, out: *mut Color) -> HRESULT,
    fn get_MistyRose(&self, out: *mut Color) -> HRESULT,
    fn get_Moccasin(&self, out: *mut Color) -> HRESULT,
    fn get_NavajoWhite(&self, out: *mut Color) -> HRESULT,
    fn get_Navy(&self, out: *mut Color) -> HRESULT,
    fn get_OldLace(&self, out: *mut Color) -> HRESULT,
    fn get_Olive(&self, out: *mut Color) -> HRESULT,
    fn get_OliveDrab(&self, out: *mut Color) -> HRESULT,
    fn get_Orange(&self, out: *mut Color) -> HRESULT,
    fn get_OrangeRed(&self, out: *mut Color) -> HRESULT,
    fn get_Orchid(&self, out: *mut Color) -> HRESULT,
    fn get_PaleGoldenrod(&self, out: *mut Color) -> HRESULT,
    fn get_PaleGreen(&self, out: *mut Color) -> HRESULT,
    fn get_PaleTurquoise(&self, out: *mut Color) -> HRESULT,
    fn get_PaleVioletRed(&self, out: *mut Color) -> HRESULT,
    fn get_PapayaWhip(&self, out: *mut Color) -> HRESULT,
    fn get_PeachPuff(&self, out: *mut Color) -> HRESULT,
    fn get_Peru(&self, out: *mut Color) -> HRESULT,
    fn get_Pink(&self, out: *mut Color) -> HRESULT,
    fn get_Plum(&self, out: *mut Color) -> HRESULT,
    fn get_PowderBlue(&self, out: *mut Color) -> HRESULT,
    fn get_Purple(&self, out: *mut Color) -> HRESULT,
    fn get_Red(&self, out: *mut Color) -> HRESULT,
    fn get_RosyBrown(&self, out: *mut Color) -> HRESULT,
    fn get_RoyalBlue(&self, out: *mut Color) -> HRESULT,
    fn get_SaddleBrown(&self, out: *mut Color) -> HRESULT,
    fn get_Salmon(&self, out: *mut Color) -> HRESULT,
    fn get_SandyBrown(&self, out: *mut Color) -> HRESULT,
    fn get_SeaGreen(&self, out: *mut Color) -> HRESULT,
    fn get_SeaShell(&self, out: *mut Color) -> HRESULT,
    fn get_Sienna(&self, out: *mut Color) -> HRESULT,
    fn get_Silver(&self, out: *mut Color) -> HRESULT,
    fn get_SkyBlue(&self, out: *mut Color) -> HRESULT,
    fn get_SlateBlue(&self, out: *mut Color) -> HRESULT,
    fn get_SlateGray(&self, out: *mut Color) -> HRESULT,
    fn get_Snow(&self, out: *mut Color) -> HRESULT,
    fn get_SpringGreen(&self, out: *mut Color) -> HRESULT,
    fn get_SteelBlue(&self, out: *mut Color) -> HRESULT,
    fn get_Tan(&self, out: *mut Color) -> HRESULT,
    fn get_Teal(&self, out: *mut Color) -> HRESULT,
    fn get_Thistle(&self, out: *mut Color) -> HRESULT,
    fn get_Tomato(&self, out: *mut Color) -> HRESULT,
    fn get_Transparent(&self, out: *mut Color) -> HRESULT,
    fn get_Turquoise(&self, out: *mut Color) -> HRESULT,
    fn get_Violet(&self, out: *mut Color) -> HRESULT,
    fn get_Wheat(&self, out: *mut Color) -> HRESULT,
    fn get_White(&self, out: *mut Color) -> HRESULT,
    fn get_WhiteSmoke(&self, out: *mut Color) -> HRESULT,
    fn get_Yellow(&self, out: *mut Color) -> HRESULT,
    fn get_YellowGreen(&self, out: *mut Color) -> HRESULT
}}
impl IColorsStatics {
    #[inline] pub unsafe fn get_alice_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AliceBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_antique_white(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AntiqueWhite)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_aqua(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Aqua)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_aquamarine(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Aquamarine)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_azure(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Azure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_beige(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Beige)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bisque(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bisque)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_black(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Black)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blanched_almond(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BlanchedAlmond)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Blue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blue_violet(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BlueViolet)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_brown(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Brown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_burly_wood(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BurlyWood)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cadet_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CadetBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_chartreuse(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Chartreuse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_chocolate(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Chocolate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_coral(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Coral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cornflower_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CornflowerBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cornsilk(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cornsilk)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_crimson(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Crimson)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cyan(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cyan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_cyan(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkCyan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_goldenrod(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkGoldenrod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkGray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_khaki(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkKhaki)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_magenta(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkMagenta)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_olive_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkOliveGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_orange(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkOrange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_orchid(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkOrchid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_red(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkRed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_salmon(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkSalmon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_sea_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkSeaGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_slate_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkSlateBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_slate_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkSlateGray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_turquoise(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkTurquoise)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dark_violet(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DarkViolet)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deep_pink(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeepPink)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deep_sky_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeepSkyBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dim_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DimGray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dodger_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DodgerBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_firebrick(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Firebrick)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_floral_white(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FloralWhite)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_forest_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForestGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_fuchsia(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Fuchsia)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gainsboro(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gainsboro)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ghost_white(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GhostWhite)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gold(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gold)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_goldenrod(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Goldenrod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Green)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_green_yellow(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GreenYellow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_honeydew(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Honeydew)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hot_pink(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HotPink)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_indian_red(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IndianRed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_indigo(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Indigo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ivory(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Ivory)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_khaki(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Khaki)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lavender(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Lavender)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lavender_blush(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LavenderBlush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lawn_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LawnGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lemon_chiffon(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LemonChiffon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_coral(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightCoral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_cyan(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightCyan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_goldenrod_yellow(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightGoldenrodYellow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightGray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_pink(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightPink)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_salmon(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightSalmon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_sea_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightSeaGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_sky_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightSkyBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_slate_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightSlateGray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_steel_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightSteelBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light_yellow(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightYellow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lime(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Lime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lime_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LimeGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_linen(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Linen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_magenta(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Magenta)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_maroon(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Maroon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_aquamarine(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumAquamarine)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_orchid(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumOrchid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_purple(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumPurple)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_sea_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumSeaGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_slate_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumSlateBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_spring_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumSpringGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_turquoise(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumTurquoise)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium_violet_red(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MediumVioletRed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_midnight_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MidnightBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mint_cream(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MintCream)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_misty_rose(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MistyRose)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_moccasin(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Moccasin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_navajo_white(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NavajoWhite)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_navy(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Navy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_old_lace(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OldLace)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_olive(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Olive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_olive_drab(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OliveDrab)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orange(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orange_red(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OrangeRed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orchid(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orchid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pale_goldenrod(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PaleGoldenrod)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pale_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PaleGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pale_turquoise(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PaleTurquoise)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pale_violet_red(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PaleVioletRed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_papaya_whip(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PapayaWhip)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_peach_puff(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PeachPuff)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_peru(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Peru)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pink(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Pink)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_plum(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Plum)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_powder_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PowderBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_purple(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Purple)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_red(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Red)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rosy_brown(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RosyBrown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_royal_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RoyalBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_saddle_brown(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SaddleBrown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_salmon(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Salmon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sandy_brown(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SandyBrown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sea_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SeaGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sea_shell(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SeaShell)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sienna(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Sienna)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_silver(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Silver)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sky_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SkyBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_slate_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SlateBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_slate_gray(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SlateGray)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_snow(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Snow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_spring_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpringGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_steel_blue(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SteelBlue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tan(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Tan)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_teal(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Teal)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thistle(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Thistle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tomato(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Tomato)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transparent(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Transparent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_turquoise(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Turquoise)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_violet(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Violet)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wheat(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Wheat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_white(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_White)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_white_smoke(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WhiteSmoke)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_yellow(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Yellow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_yellow_green(&self) -> Result<Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_YellowGreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
pub mod core { // Windows.UI.Core
use ::prelude::*;
DEFINE_IID!(IID_IAcceleratorKeyEventArgs, 4280044618, 37511, 18187, 131, 110, 144, 134, 227, 18, 106, 222);
RT_INTERFACE!{interface IAcceleratorKeyEventArgs(IAcceleratorKeyEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAcceleratorKeyEventArgs] {
    fn get_EventType(&self, out: *mut CoreAcceleratorKeyEventType) -> HRESULT,
    #[cfg(not(feature="windows-system"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-system")] fn get_VirtualKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    fn get_KeyStatus(&self, out: *mut CorePhysicalKeyStatus) -> HRESULT
}}
impl IAcceleratorKeyEventArgs {
    #[inline] pub unsafe fn get_event_type(&self) -> Result<CoreAcceleratorKeyEventType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EventType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_virtual_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VirtualKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_status(&self) -> Result<CorePhysicalKeyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AcceleratorKeyEventArgs: IAcceleratorKeyEventArgs}
DEFINE_IID!(IID_IAcceleratorKeyEventArgs2, 3540036086, 12158, 18547, 165, 85, 22, 110, 89, 110, 225, 197);
RT_INTERFACE!{interface IAcceleratorKeyEventArgs2(IAcceleratorKeyEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IAcceleratorKeyEventArgs2] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAcceleratorKeyEventArgs2 {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppViewBackButtonVisibility: i32 {
    Visible (AppViewBackButtonVisibility_Visible) = 0, Collapsed (AppViewBackButtonVisibility_Collapsed) = 1,
}}
DEFINE_IID!(IID_IAutomationProviderRequestedEventArgs, 2518676056, 8639, 19266, 162, 152, 250, 71, 157, 76, 82, 226);
RT_INTERFACE!{interface IAutomationProviderRequestedEventArgs(IAutomationProviderRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAutomationProviderRequestedEventArgs] {
    fn get_AutomationProvider(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_AutomationProvider(&self, value: *mut IInspectable) -> HRESULT
}}
impl IAutomationProviderRequestedEventArgs {
    #[inline] pub unsafe fn get_automation_provider(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AutomationProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_automation_provider(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutomationProvider)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AutomationProviderRequestedEventArgs: IAutomationProviderRequestedEventArgs}
DEFINE_IID!(IID_IBackRequestedEventArgs, 3590574730, 58385, 19022, 186, 65, 106, 50, 122, 134, 117, 188);
RT_INTERFACE!{interface IBackRequestedEventArgs(IBackRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBackRequestedEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl IBackRequestedEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BackRequestedEventArgs: IBackRequestedEventArgs}
DEFINE_IID!(IID_ICharacterReceivedEventArgs, 3313788319, 39346, 19404, 189, 51, 4, 230, 63, 66, 144, 46);
RT_INTERFACE!{interface ICharacterReceivedEventArgs(ICharacterReceivedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICharacterReceivedEventArgs] {
    fn get_KeyCode(&self, out: *mut u32) -> HRESULT,
    fn get_KeyStatus(&self, out: *mut CorePhysicalKeyStatus) -> HRESULT
}}
impl ICharacterReceivedEventArgs {
    #[inline] pub unsafe fn get_key_code(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_status(&self) -> Result<CorePhysicalKeyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CharacterReceivedEventArgs: ICharacterReceivedEventArgs}
DEFINE_IID!(IID_IClosestInteractiveBoundsRequestedEventArgs, 880546263, 63224, 16611, 178, 159, 174, 80, 211, 232, 100, 134);
RT_INTERFACE!{interface IClosestInteractiveBoundsRequestedEventArgs(IClosestInteractiveBoundsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IClosestInteractiveBoundsRequestedEventArgs] {
    fn get_PointerPosition(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_SearchBounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn get_ClosestInteractiveBounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn put_ClosestInteractiveBounds(&self, value: super::super::foundation::Rect) -> HRESULT
}}
impl IClosestInteractiveBoundsRequestedEventArgs {
    #[inline] pub unsafe fn get_pointer_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_search_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SearchBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_closest_interactive_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClosestInteractiveBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_closest_interactive_bounds(&self, value: super::super::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ClosestInteractiveBounds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ClosestInteractiveBoundsRequestedEventArgs: IClosestInteractiveBoundsRequestedEventArgs}
RT_ENUM! { enum CoreAcceleratorKeyEventType: i32 {
    Character (CoreAcceleratorKeyEventType_Character) = 2, DeadCharacter (CoreAcceleratorKeyEventType_DeadCharacter) = 3, KeyDown (CoreAcceleratorKeyEventType_KeyDown) = 0, KeyUp (CoreAcceleratorKeyEventType_KeyUp) = 1, SystemCharacter (CoreAcceleratorKeyEventType_SystemCharacter) = 6, SystemDeadCharacter (CoreAcceleratorKeyEventType_SystemDeadCharacter) = 7, SystemKeyDown (CoreAcceleratorKeyEventType_SystemKeyDown) = 4, SystemKeyUp (CoreAcceleratorKeyEventType_SystemKeyUp) = 5, UnicodeCharacter (CoreAcceleratorKeyEventType_UnicodeCharacter) = 8,
}}
DEFINE_IID!(IID_ICoreAcceleratorKeys, 2684221429, 47305, 20208, 183, 210, 29, 230, 38, 86, 31, 200);
RT_INTERFACE!{interface ICoreAcceleratorKeys(ICoreAcceleratorKeysVtbl): IInspectable(IInspectableVtbl) [IID_ICoreAcceleratorKeys] {
    fn add_AcceleratorKeyActivated(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreDispatcher, AcceleratorKeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AcceleratorKeyActivated(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreAcceleratorKeys {
    #[inline] pub unsafe fn add_accelerator_key_activated(&self, handler: &super::super::foundation::TypedEventHandler<CoreDispatcher, AcceleratorKeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AcceleratorKeyActivated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_accelerator_key_activated(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AcceleratorKeyActivated)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreAcceleratorKeys: ICoreAcceleratorKeys}
DEFINE_IID!(IID_ICoreClosestInteractiveBoundsRequested, 4077061178, 59583, 20110, 174, 105, 201, 218, 221, 87, 161, 20);
RT_INTERFACE!{interface ICoreClosestInteractiveBoundsRequested(ICoreClosestInteractiveBoundsRequestedVtbl): IInspectable(IInspectableVtbl) [IID_ICoreClosestInteractiveBoundsRequested] {
    fn add_ClosestInteractiveBoundsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreComponentInputSource, ClosestInteractiveBoundsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ClosestInteractiveBoundsRequested(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreClosestInteractiveBoundsRequested {
    #[inline] pub unsafe fn add_closest_interactive_bounds_requested(&self, handler: &super::super::foundation::TypedEventHandler<CoreComponentInputSource, ClosestInteractiveBoundsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ClosestInteractiveBoundsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closest_interactive_bounds_requested(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ClosestInteractiveBoundsRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreComponentFocusable, 1392078755, 34626, 17425, 174, 105, 121, 168, 95, 41, 172, 139);
RT_INTERFACE!{interface ICoreComponentFocusable(ICoreComponentFocusableVtbl): IInspectable(IInspectableVtbl) [IID_ICoreComponentFocusable] {
    fn get_HasFocus(&self, out: *mut bool) -> HRESULT,
    fn add_GotFocus(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, CoreWindowEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_GotFocus(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_LostFocus(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, CoreWindowEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LostFocus(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreComponentFocusable {
    #[inline] pub unsafe fn get_has_focus(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasFocus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_got_focus(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, CoreWindowEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_GotFocus)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_got_focus(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_GotFocus)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_lost_focus(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, CoreWindowEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LostFocus)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_lost_focus(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LostFocus)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreComponentInputSource: ICoreInputSourceBase}
DEFINE_IID!(IID_ICoreCursor, 2525575887, 4381, 17452, 138, 119, 184, 121, 146, 248, 226, 214);
RT_INTERFACE!{interface ICoreCursor(ICoreCursorVtbl): IInspectable(IInspectableVtbl) [IID_ICoreCursor] {
    fn get_Id(&self, out: *mut u32) -> HRESULT,
    fn get_Type(&self, out: *mut CoreCursorType) -> HRESULT
}}
impl ICoreCursor {
    #[inline] pub unsafe fn get_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_type(&self) -> Result<CoreCursorType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CoreCursor: ICoreCursor}
impl RtActivatable<ICoreCursorFactory> for CoreCursor {}
impl CoreCursor {
    #[inline] pub fn create_cursor(type_: CoreCursorType, id: u32) -> Result<ComPtr<CoreCursor>> { unsafe {
        <Self as RtActivatable<ICoreCursorFactory>>::get_activation_factory().create_cursor(type_, id)
    }}
}
DEFINE_CLSID!(CoreCursor(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,67,111,114,101,67,117,114,115,111,114,0]) [CLSID_CoreCursor]);
DEFINE_IID!(IID_ICoreCursorFactory, 4130706977, 42909, 20179, 140, 50, 169, 239, 157, 107, 118, 164);
RT_INTERFACE!{static interface ICoreCursorFactory(ICoreCursorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICoreCursorFactory] {
    fn CreateCursor(&self, type_: CoreCursorType, id: u32, out: *mut *mut CoreCursor) -> HRESULT
}}
impl ICoreCursorFactory {
    #[inline] pub unsafe fn create_cursor(&self, type_: CoreCursorType, id: u32) -> Result<ComPtr<CoreCursor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCursor)(self as *const _ as *mut _, type_, id, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CoreCursorType: i32 {
    Arrow (CoreCursorType_Arrow) = 0, Cross (CoreCursorType_Cross) = 1, Custom (CoreCursorType_Custom) = 2, Hand (CoreCursorType_Hand) = 3, Help (CoreCursorType_Help) = 4, IBeam (CoreCursorType_IBeam) = 5, SizeAll (CoreCursorType_SizeAll) = 6, SizeNortheastSouthwest (CoreCursorType_SizeNortheastSouthwest) = 7, SizeNorthSouth (CoreCursorType_SizeNorthSouth) = 8, SizeNorthwestSoutheast (CoreCursorType_SizeNorthwestSoutheast) = 9, SizeWestEast (CoreCursorType_SizeWestEast) = 10, UniversalNo (CoreCursorType_UniversalNo) = 11, UpArrow (CoreCursorType_UpArrow) = 12, Wait (CoreCursorType_Wait) = 13, Pin (CoreCursorType_Pin) = 14, Person (CoreCursorType_Person) = 15,
}}
DEFINE_IID!(IID_ICoreDispatcher, 1624977320, 46853, 20446, 167, 214, 235, 187, 24, 145, 211, 158);
RT_INTERFACE!{interface ICoreDispatcher(ICoreDispatcherVtbl): IInspectable(IInspectableVtbl) [IID_ICoreDispatcher] {
    fn get_HasThreadAccess(&self, out: *mut bool) -> HRESULT,
    fn ProcessEvents(&self, options: CoreProcessEventsOption) -> HRESULT,
    fn RunAsync(&self, priority: CoreDispatcherPriority, agileCallback: *mut DispatchedHandler, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn RunIdleAsync(&self, agileCallback: *mut IdleDispatchedHandler, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl ICoreDispatcher {
    #[inline] pub unsafe fn get_has_thread_access(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasThreadAccess)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_events(&self, options: CoreProcessEventsOption) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessEvents)(self as *const _ as *mut _, options);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn run_async(&self, priority: CoreDispatcherPriority, agileCallback: &DispatchedHandler) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RunAsync)(self as *const _ as *mut _, priority, agileCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn run_idle_async(&self, agileCallback: &IdleDispatchedHandler) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RunIdleAsync)(self as *const _ as *mut _, agileCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreDispatcher: ICoreDispatcher}
DEFINE_IID!(IID_ICoreDispatcher2, 1868456903, 58282, 20142, 176, 224, 220, 243, 33, 202, 75, 47);
RT_INTERFACE!{interface ICoreDispatcher2(ICoreDispatcher2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreDispatcher2] {
    fn TryRunAsync(&self, priority: CoreDispatcherPriority, agileCallback: *mut DispatchedHandler, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryRunIdleAsync(&self, agileCallback: *mut IdleDispatchedHandler, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ICoreDispatcher2 {
    #[inline] pub unsafe fn try_run_async(&self, priority: CoreDispatcherPriority, agileCallback: &DispatchedHandler) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryRunAsync)(self as *const _ as *mut _, priority, agileCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_run_idle_async(&self, agileCallback: &IdleDispatchedHandler) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryRunIdleAsync)(self as *const _ as *mut _, agileCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CoreDispatcherPriority: i32 {
    Idle (CoreDispatcherPriority_Idle) = -2, Low (CoreDispatcherPriority_Low) = -1, Normal (CoreDispatcherPriority_Normal) = 0, High (CoreDispatcherPriority_High) = 1,
}}
DEFINE_IID!(IID_ICoreDispatcherWithTaskPriority, 3137006765, 18509, 16830, 186, 128, 29, 88, 198, 82, 99, 234);
RT_INTERFACE!{interface ICoreDispatcherWithTaskPriority(ICoreDispatcherWithTaskPriorityVtbl): IInspectable(IInspectableVtbl) [IID_ICoreDispatcherWithTaskPriority] {
    fn get_CurrentPriority(&self, out: *mut CoreDispatcherPriority) -> HRESULT,
    fn put_CurrentPriority(&self, value: CoreDispatcherPriority) -> HRESULT,
    fn ShouldYield(&self, out: *mut bool) -> HRESULT,
    fn ShouldYieldToPriority(&self, priority: CoreDispatcherPriority, out: *mut bool) -> HRESULT,
    fn StopProcessEvents(&self) -> HRESULT
}}
impl ICoreDispatcherWithTaskPriority {
    #[inline] pub unsafe fn get_current_priority(&self) -> Result<CoreDispatcherPriority> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentPriority)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_current_priority(&self, value: CoreDispatcherPriority) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CurrentPriority)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn should_yield(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ShouldYield)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn should_yield_to_priority(&self, priority: CoreDispatcherPriority) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ShouldYieldToPriority)(self as *const _ as *mut _, priority, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_process_events(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopProcessEvents)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreIndependentInputSource: ICoreInputSourceBase}
RT_ENUM! { enum CoreInputDeviceTypes: u32 {
    None (CoreInputDeviceTypes_None) = 0, Touch (CoreInputDeviceTypes_Touch) = 1, Pen (CoreInputDeviceTypes_Pen) = 2, Mouse (CoreInputDeviceTypes_Mouse) = 4,
}}
DEFINE_IID!(IID_ICoreInputSourceBase, 2672330759, 17792, 19432, 190, 104, 146, 169, 49, 23, 19, 187);
RT_INTERFACE!{interface ICoreInputSourceBase(ICoreInputSourceBaseVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInputSourceBase] {
    fn get_Dispatcher(&self, out: *mut *mut CoreDispatcher) -> HRESULT,
    fn get_IsInputEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsInputEnabled(&self, value: bool) -> HRESULT,
    fn add_InputEnabled(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, InputEnabledEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_InputEnabled(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreInputSourceBase {
    #[inline] pub unsafe fn get_dispatcher(&self) -> Result<ComPtr<CoreDispatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dispatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_input_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInputEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_input_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsInputEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_input_enabled(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, InputEnabledEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_InputEnabled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_input_enabled(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_InputEnabled)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreKeyboardInputSource, 589074568, 58473, 19953, 178, 8, 110, 73, 13, 113, 203, 144);
RT_INTERFACE!{interface ICoreKeyboardInputSource(ICoreKeyboardInputSourceVtbl): IInspectable(IInspectableVtbl) [IID_ICoreKeyboardInputSource] {
    #[cfg(not(feature="windows-system"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-system")] fn GetCurrentKeyState(&self, virtualKey: super::super::system::VirtualKey, out: *mut CoreVirtualKeyStates) -> HRESULT,
    fn add_CharacterReceived(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, CharacterReceivedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CharacterReceived(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeyDown(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, KeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyDown(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeyUp(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, KeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyUp(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreKeyboardInputSource {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_current_key_state(&self, virtualKey: super::super::system::VirtualKey) -> Result<CoreVirtualKeyStates> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetCurrentKeyState)(self as *const _ as *mut _, virtualKey, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_character_received(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, CharacterReceivedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CharacterReceived)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_character_received(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CharacterReceived)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_down(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, KeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyDown)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_down(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyDown)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_up(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, KeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyUp)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_up(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyUp)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreKeyboardInputSource2, 4196715412, 63843, 18341, 135, 120, 32, 124, 72, 43, 10, 253);
RT_INTERFACE!{interface ICoreKeyboardInputSource2(ICoreKeyboardInputSource2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreKeyboardInputSource2] {
    fn GetCurrentKeyEventDeviceId(&self, out: *mut HSTRING) -> HRESULT
}}
impl ICoreKeyboardInputSource2 {
    #[inline] pub unsafe fn get_current_key_event_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentKeyEventDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_STRUCT! { struct CorePhysicalKeyStatus {
    RepeatCount: u32, ScanCode: u32, IsExtendedKey: bool, IsMenuKeyDown: bool, WasKeyDown: bool, IsKeyReleased: bool,
}}
DEFINE_IID!(IID_ICorePointerInputSource, 3153181464, 58490, 18667, 136, 7, 248, 248, 211, 234, 69, 81);
RT_INTERFACE!{interface ICorePointerInputSource(ICorePointerInputSourceVtbl): IInspectable(IInspectableVtbl) [IID_ICorePointerInputSource] {
    fn ReleasePointerCapture(&self) -> HRESULT,
    fn SetPointerCapture(&self) -> HRESULT,
    fn get_HasCapture(&self, out: *mut bool) -> HRESULT,
    fn get_PointerPosition(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_PointerCursor(&self, out: *mut *mut CoreCursor) -> HRESULT,
    fn put_PointerCursor(&self, value: *mut CoreCursor) -> HRESULT,
    fn add_PointerCaptureLost(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerCaptureLost(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerEntered(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerEntered(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerExited(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerExited(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerMoved(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerMoved(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerPressed(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerPressed(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerReleased(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerReleased(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerWheelChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerWheelChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICorePointerInputSource {
    #[inline] pub unsafe fn release_pointer_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReleasePointerCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pointer_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPointerCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_capture(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasCapture)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_cursor(&self) -> Result<ComPtr<CoreCursor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerCursor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pointer_cursor(&self, value: &CoreCursor) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PointerCursor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_capture_lost(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerCaptureLost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_capture_lost(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerCaptureLost)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_entered(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerEntered)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_entered(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerEntered)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_exited(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerExited)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_exited(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerExited)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_moved(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerMoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_moved(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerMoved)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_pressed(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_pressed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_released(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerReleased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_released(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerReleased)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_wheel_changed(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerWheelChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_wheel_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerWheelChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICorePointerRedirector, 2409434260, 22152, 19212, 169, 241, 249, 49, 247, 250, 61, 195);
RT_INTERFACE!{interface ICorePointerRedirector(ICorePointerRedirectorVtbl): IInspectable(IInspectableVtbl) [IID_ICorePointerRedirector] {
    fn add_PointerRoutedAway(&self, handler: *mut super::super::foundation::TypedEventHandler<ICorePointerRedirector, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerRoutedAway(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerRoutedTo(&self, handler: *mut super::super::foundation::TypedEventHandler<ICorePointerRedirector, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerRoutedTo(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerRoutedReleased(&self, handler: *mut super::super::foundation::TypedEventHandler<ICorePointerRedirector, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerRoutedReleased(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICorePointerRedirector {
    #[inline] pub unsafe fn add_pointer_routed_away(&self, handler: &super::super::foundation::TypedEventHandler<ICorePointerRedirector, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerRoutedAway)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_routed_away(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerRoutedAway)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_routed_to(&self, handler: &super::super::foundation::TypedEventHandler<ICorePointerRedirector, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerRoutedTo)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_routed_to(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerRoutedTo)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_routed_released(&self, handler: &super::super::foundation::TypedEventHandler<ICorePointerRedirector, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerRoutedReleased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_routed_released(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerRoutedReleased)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum CoreProcessEventsOption: i32 {
    ProcessOneAndAllPending (CoreProcessEventsOption_ProcessOneAndAllPending) = 0, ProcessOneIfPresent (CoreProcessEventsOption_ProcessOneIfPresent) = 1, ProcessUntilQuit (CoreProcessEventsOption_ProcessUntilQuit) = 2, ProcessAllIfPresent (CoreProcessEventsOption_ProcessAllIfPresent) = 3,
}}
RT_STRUCT! { struct CoreProximityEvaluation {
    Score: i32, AdjustedPoint: super::super::foundation::Point,
}}
RT_ENUM! { enum CoreProximityEvaluationScore: i32 {
    Closest (CoreProximityEvaluationScore_Closest) = 0, Farthest (CoreProximityEvaluationScore_Farthest) = 2147483647,
}}
DEFINE_IID!(IID_ICoreTouchHitTesting, 2983764617, 15055, 16676, 159, 163, 234, 138, 186, 53, 60, 33);
RT_INTERFACE!{interface ICoreTouchHitTesting(ICoreTouchHitTestingVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTouchHitTesting] {
    fn add_TouchHitTesting(&self, handler: *mut super::super::foundation::TypedEventHandler<IInspectable, TouchHitTestingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TouchHitTesting(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreTouchHitTesting {
    #[inline] pub unsafe fn add_touch_hit_testing(&self, handler: &super::super::foundation::TypedEventHandler<IInspectable, TouchHitTestingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TouchHitTesting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_touch_hit_testing(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TouchHitTesting)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum CoreVirtualKeyStates: u32 {
    None (CoreVirtualKeyStates_None) = 0, Down (CoreVirtualKeyStates_Down) = 1, Locked (CoreVirtualKeyStates_Locked) = 2,
}}
DEFINE_IID!(IID_ICoreWindow, 2042222066, 34718, 19337, 183, 152, 121, 228, 117, 152, 3, 12);
RT_INTERFACE!{interface ICoreWindow(ICoreWindowVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindow] {
    fn get_AutomationHostProvider(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_Bounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn get_CustomProperties(&self, out: *mut *mut super::super::foundation::collections::IPropertySet) -> HRESULT,
    fn get_Dispatcher(&self, out: *mut *mut CoreDispatcher) -> HRESULT,
    fn get_FlowDirection(&self, out: *mut CoreWindowFlowDirection) -> HRESULT,
    fn put_FlowDirection(&self, value: CoreWindowFlowDirection) -> HRESULT,
    fn get_IsInputEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsInputEnabled(&self, value: bool) -> HRESULT,
    fn get_PointerCursor(&self, out: *mut *mut CoreCursor) -> HRESULT,
    fn put_PointerCursor(&self, value: *mut CoreCursor) -> HRESULT,
    fn get_PointerPosition(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_Visible(&self, out: *mut bool) -> HRESULT,
    fn Activate(&self) -> HRESULT,
    fn Close(&self) -> HRESULT,
    #[cfg(not(feature="windows-system"))] fn __Dummy14(&self) -> (),
    #[cfg(feature="windows-system")] fn GetAsyncKeyState(&self, virtualKey: super::super::system::VirtualKey, out: *mut CoreVirtualKeyStates) -> HRESULT,
    #[cfg(not(feature="windows-system"))] fn __Dummy15(&self) -> (),
    #[cfg(feature="windows-system")] fn GetKeyState(&self, virtualKey: super::super::system::VirtualKey, out: *mut CoreVirtualKeyStates) -> HRESULT,
    fn ReleasePointerCapture(&self) -> HRESULT,
    fn SetPointerCapture(&self) -> HRESULT,
    fn add_Activated(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, WindowActivatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Activated(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AutomationProviderRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, AutomationProviderRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AutomationProviderRequested(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CharacterReceived(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, CharacterReceivedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CharacterReceived(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, CoreWindowEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_InputEnabled(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, InputEnabledEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_InputEnabled(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeyDown(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, KeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyDown(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeyUp(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, KeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyUp(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerCaptureLost(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerCaptureLost(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerEntered(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerEntered(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerExited(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerExited(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerMoved(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerMoved(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerPressed(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerPressed(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerReleased(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerReleased(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_TouchHitTesting(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, TouchHitTestingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TouchHitTesting(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerWheelChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerWheelChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SizeChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, WindowSizeChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SizeChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_VisibilityChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, VisibilityChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VisibilityChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreWindow {
    #[inline] pub unsafe fn get_automation_host_provider(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AutomationHostProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_properties(&self) -> Result<ComPtr<super::super::foundation::collections::IPropertySet>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CustomProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dispatcher(&self) -> Result<ComPtr<CoreDispatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dispatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flow_direction(&self) -> Result<CoreWindowFlowDirection> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FlowDirection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_flow_direction(&self, value: CoreWindowFlowDirection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FlowDirection)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_input_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInputEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_input_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsInputEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_cursor(&self) -> Result<ComPtr<CoreCursor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerCursor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pointer_cursor(&self, value: &CoreCursor) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PointerCursor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn activate(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Activate)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn close(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Close)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_async_key_state(&self, virtualKey: super::super::system::VirtualKey) -> Result<CoreVirtualKeyStates> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetAsyncKeyState)(self as *const _ as *mut _, virtualKey, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_key_state(&self, virtualKey: super::super::system::VirtualKey) -> Result<CoreVirtualKeyStates> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetKeyState)(self as *const _ as *mut _, virtualKey, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn release_pointer_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReleasePointerCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pointer_capture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPointerCapture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_activated(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, WindowActivatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Activated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_activated(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Activated)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_automation_provider_requested(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, AutomationProviderRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AutomationProviderRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_automation_provider_requested(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AutomationProviderRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_character_received(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, CharacterReceivedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CharacterReceived)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_character_received(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CharacterReceived)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, CoreWindowEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_input_enabled(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, InputEnabledEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_InputEnabled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_input_enabled(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_InputEnabled)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_down(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, KeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyDown)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_down(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyDown)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_up(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, KeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyUp)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_up(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyUp)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_capture_lost(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerCaptureLost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_capture_lost(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerCaptureLost)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_entered(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerEntered)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_entered(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerEntered)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_exited(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerExited)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_exited(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerExited)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_moved(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerMoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_moved(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerMoved)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_pressed(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_pressed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_released(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerReleased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_released(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerReleased)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_touch_hit_testing(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, TouchHitTestingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TouchHitTesting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_touch_hit_testing(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TouchHitTesting)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_wheel_changed(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, PointerEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerWheelChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_wheel_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerWheelChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_size_changed(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, WindowSizeChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SizeChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_size_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SizeChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_visibility_changed(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, VisibilityChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VisibilityChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_visibility_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VisibilityChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWindow: ICoreWindow}
impl RtActivatable<ICoreWindowStatic> for CoreWindow {}
impl CoreWindow {
    #[inline] pub fn get_for_current_thread() -> Result<ComPtr<CoreWindow>> { unsafe {
        <Self as RtActivatable<ICoreWindowStatic>>::get_activation_factory().get_for_current_thread()
    }}
}
DEFINE_CLSID!(CoreWindow(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,67,111,114,101,87,105,110,100,111,119,0]) [CLSID_CoreWindow]);
DEFINE_IID!(IID_ICoreWindow2, 2083199877, 26903, 17249, 156, 2, 13, 158, 58, 66, 11, 149);
RT_INTERFACE!{interface ICoreWindow2(ICoreWindow2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindow2] {
    fn put_PointerPosition(&self, value: super::super::foundation::Point) -> HRESULT
}}
impl ICoreWindow2 {
    #[inline] pub unsafe fn set_pointer_position(&self, value: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PointerPosition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindow3, 851578328, 64239, 17269, 162, 171, 50, 100, 14, 72, 21, 199);
RT_INTERFACE!{interface ICoreWindow3(ICoreWindow3Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindow3] {
    fn add_ClosestInteractiveBoundsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, ClosestInteractiveBoundsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ClosestInteractiveBoundsRequested(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn GetCurrentKeyEventDeviceId(&self, out: *mut HSTRING) -> HRESULT
}}
impl ICoreWindow3 {
    #[inline] pub unsafe fn add_closest_interactive_bounds_requested(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, ClosestInteractiveBoundsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ClosestInteractiveBoundsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closest_interactive_bounds_requested(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ClosestInteractiveBoundsRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_key_event_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentKeyEventDeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindow4, 902492368, 18416, 17260, 175, 151, 13, 216, 143, 111, 95, 2);
RT_INTERFACE!{interface ICoreWindow4(ICoreWindow4Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindow4] {
    fn add_ResizeStarted(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ResizeStarted(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ResizeCompleted(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ResizeCompleted(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreWindow4 {
    #[inline] pub unsafe fn add_resize_started(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ResizeStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resize_started(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ResizeStarted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_resize_completed(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ResizeCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resize_completed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ResizeCompleted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindow5, 1263198689, 11885, 20138, 189, 161, 28, 92, 193, 190, 225, 65);
RT_INTERFACE!{interface ICoreWindow5(ICoreWindow5Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindow5] {
    #[cfg(not(feature="windows-system"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-system")] fn get_DispatcherQueue(&self, out: *mut *mut super::super::system::DispatcherQueue) -> HRESULT,
    fn get_ActivationMode(&self, out: *mut CoreWindowActivationMode) -> HRESULT
}}
impl ICoreWindow5 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_dispatcher_queue(&self) -> Result<ComPtr<super::super::system::DispatcherQueue>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DispatcherQueue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_activation_mode(&self) -> Result<CoreWindowActivationMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActivationMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum CoreWindowActivationMode: i32 {
    None (CoreWindowActivationMode_None) = 0, Deactivated (CoreWindowActivationMode_Deactivated) = 1, ActivatedNotForeground (CoreWindowActivationMode_ActivatedNotForeground) = 2, ActivatedInForeground (CoreWindowActivationMode_ActivatedInForeground) = 3,
}}
RT_ENUM! { enum CoreWindowActivationState: i32 {
    CodeActivated (CoreWindowActivationState_CodeActivated) = 0, Deactivated (CoreWindowActivationState_Deactivated) = 1, PointerActivated (CoreWindowActivationState_PointerActivated) = 2,
}}
DEFINE_IID!(IID_ICoreWindowDialog, 3879283936, 51085, 17022, 139, 44, 1, 255, 66, 12, 105, 213);
RT_INTERFACE!{interface ICoreWindowDialog(ICoreWindowDialogVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowDialog] {
    fn add_Showing(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, CoreWindowPopupShowingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Showing(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_MaxSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_MinSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_IsInteractionDelayed(&self, out: *mut i32) -> HRESULT,
    fn put_IsInteractionDelayed(&self, value: i32) -> HRESULT,
    fn get_Commands(&self, out: *mut *mut super::super::foundation::collections::IVector<super::popups::IUICommand>) -> HRESULT,
    fn get_DefaultCommandIndex(&self, out: *mut u32) -> HRESULT,
    fn put_DefaultCommandIndex(&self, value: u32) -> HRESULT,
    fn get_CancelCommandIndex(&self, out: *mut u32) -> HRESULT,
    fn put_CancelCommandIndex(&self, value: u32) -> HRESULT,
    fn get_BackButtonCommand(&self, out: *mut *mut super::popups::UICommandInvokedHandler) -> HRESULT,
    fn put_BackButtonCommand(&self, value: *mut super::popups::UICommandInvokedHandler) -> HRESULT,
    fn ShowAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::popups::IUICommand>) -> HRESULT
}}
impl ICoreWindowDialog {
    #[inline] pub unsafe fn add_showing(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, CoreWindowPopupShowingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Showing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_showing(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Showing)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_interaction_delayed(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInteractionDelayed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_interaction_delayed(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsInteractionDelayed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::popups::IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Commands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_command_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultCommandIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_command_index(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultCommandIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cancel_command_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CancelCommandIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel_command_index(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CancelCommandIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_back_button_command(&self) -> Result<ComPtr<super::popups::UICommandInvokedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackButtonCommand)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_back_button_command(&self, value: &super::popups::UICommandInvokedHandler) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackButtonCommand)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::popups::IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWindowDialog: ICoreWindowDialog}
impl RtActivatable<ICoreWindowDialogFactory> for CoreWindowDialog {}
impl RtActivatable<IActivationFactory> for CoreWindowDialog {}
impl CoreWindowDialog {
    #[inline] pub fn create_with_title(title: &HStringArg) -> Result<ComPtr<CoreWindowDialog>> { unsafe {
        <Self as RtActivatable<ICoreWindowDialogFactory>>::get_activation_factory().create_with_title(title)
    }}
}
DEFINE_CLSID!(CoreWindowDialog(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,67,111,114,101,87,105,110,100,111,119,68,105,97,108,111,103,0]) [CLSID_CoreWindowDialog]);
DEFINE_IID!(IID_ICoreWindowDialogFactory, 3484592213, 7257, 19219, 177, 229, 22, 226, 152, 5, 247, 196);
RT_INTERFACE!{static interface ICoreWindowDialogFactory(ICoreWindowDialogFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowDialogFactory] {
    fn CreateWithTitle(&self, title: HSTRING, out: *mut *mut CoreWindowDialog) -> HRESULT
}}
impl ICoreWindowDialogFactory {
    #[inline] pub unsafe fn create_with_title(&self, title: &HStringArg) -> Result<ComPtr<CoreWindowDialog>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithTitle)(self as *const _ as *mut _, title.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindowEventArgs, 657137395, 50739, 19877, 162, 108, 198, 208, 245, 107, 41, 218);
RT_INTERFACE!{interface ICoreWindowEventArgs(ICoreWindowEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl ICoreWindowEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWindowEventArgs: ICoreWindowEventArgs}
RT_ENUM! { enum CoreWindowFlowDirection: i32 {
    LeftToRight (CoreWindowFlowDirection_LeftToRight) = 0, RightToLeft (CoreWindowFlowDirection_RightToLeft) = 1,
}}
DEFINE_IID!(IID_ICoreWindowFlyout, 3902637389, 8272, 16571, 179, 68, 246, 243, 85, 238, 179, 20);
RT_INTERFACE!{interface ICoreWindowFlyout(ICoreWindowFlyoutVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowFlyout] {
    fn add_Showing(&self, handler: *mut super::super::foundation::TypedEventHandler<CoreWindow, CoreWindowPopupShowingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Showing(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_MaxSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_MinSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_IsInteractionDelayed(&self, out: *mut i32) -> HRESULT,
    fn put_IsInteractionDelayed(&self, value: i32) -> HRESULT,
    fn get_Commands(&self, out: *mut *mut super::super::foundation::collections::IVector<super::popups::IUICommand>) -> HRESULT,
    fn get_DefaultCommandIndex(&self, out: *mut u32) -> HRESULT,
    fn put_DefaultCommandIndex(&self, value: u32) -> HRESULT,
    fn get_BackButtonCommand(&self, out: *mut *mut super::popups::UICommandInvokedHandler) -> HRESULT,
    fn put_BackButtonCommand(&self, value: *mut super::popups::UICommandInvokedHandler) -> HRESULT,
    fn ShowAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::popups::IUICommand>) -> HRESULT
}}
impl ICoreWindowFlyout {
    #[inline] pub unsafe fn add_showing(&self, handler: &super::super::foundation::TypedEventHandler<CoreWindow, CoreWindowPopupShowingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Showing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_showing(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Showing)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_interaction_delayed(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInteractionDelayed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_interaction_delayed(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsInteractionDelayed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::popups::IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Commands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_command_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultCommandIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_command_index(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultCommandIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_back_button_command(&self) -> Result<ComPtr<super::popups::UICommandInvokedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackButtonCommand)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_back_button_command(&self, value: &super::popups::UICommandInvokedHandler) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackButtonCommand)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::popups::IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWindowFlyout: ICoreWindowFlyout}
impl RtActivatable<ICoreWindowFlyoutFactory> for CoreWindowFlyout {}
impl CoreWindowFlyout {
    #[inline] pub fn create(position: super::super::foundation::Point) -> Result<ComPtr<CoreWindowFlyout>> { unsafe {
        <Self as RtActivatable<ICoreWindowFlyoutFactory>>::get_activation_factory().create(position)
    }}
    #[inline] pub fn create_with_title(position: super::super::foundation::Point, title: &HStringArg) -> Result<ComPtr<CoreWindowFlyout>> { unsafe {
        <Self as RtActivatable<ICoreWindowFlyoutFactory>>::get_activation_factory().create_with_title(position, title)
    }}
}
DEFINE_CLSID!(CoreWindowFlyout(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,67,111,114,101,87,105,110,100,111,119,70,108,121,111,117,116,0]) [CLSID_CoreWindowFlyout]);
DEFINE_IID!(IID_ICoreWindowFlyoutFactory, 3737437892, 37864, 20348, 190, 39, 206, 250, 161, 175, 104, 167);
RT_INTERFACE!{static interface ICoreWindowFlyoutFactory(ICoreWindowFlyoutFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowFlyoutFactory] {
    fn Create(&self, position: super::super::foundation::Point, out: *mut *mut CoreWindowFlyout) -> HRESULT,
    fn CreateWithTitle(&self, position: super::super::foundation::Point, title: HSTRING, out: *mut *mut CoreWindowFlyout) -> HRESULT
}}
impl ICoreWindowFlyoutFactory {
    #[inline] pub unsafe fn create(&self, position: super::super::foundation::Point) -> Result<ComPtr<CoreWindowFlyout>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, position, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_title(&self, position: super::super::foundation::Point, title: &HStringArg) -> Result<ComPtr<CoreWindowFlyout>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithTitle)(self as *const _ as *mut _, position, title.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindowPopupShowingEventArgs, 638934946, 23461, 20132, 163, 180, 45, 199, 214, 60, 142, 38);
RT_INTERFACE!{interface ICoreWindowPopupShowingEventArgs(ICoreWindowPopupShowingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowPopupShowingEventArgs] {
    fn SetDesiredSize(&self, value: super::super::foundation::Size) -> HRESULT
}}
impl ICoreWindowPopupShowingEventArgs {
    #[inline] pub unsafe fn set_desired_size(&self, value: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDesiredSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWindowPopupShowingEventArgs: ICoreWindowPopupShowingEventArgs}
DEFINE_IID!(IID_ICoreWindowResizeManager, 3102783781, 45904, 18611, 161, 152, 92, 26, 132, 112, 2, 67);
RT_INTERFACE!{interface ICoreWindowResizeManager(ICoreWindowResizeManagerVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowResizeManager] {
    fn NotifyLayoutCompleted(&self) -> HRESULT
}}
impl ICoreWindowResizeManager {
    #[inline] pub unsafe fn notify_layout_completed(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyLayoutCompleted)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWindowResizeManager: ICoreWindowResizeManager}
impl RtActivatable<ICoreWindowResizeManagerStatics> for CoreWindowResizeManager {}
impl CoreWindowResizeManager {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<CoreWindowResizeManager>> { unsafe {
        <Self as RtActivatable<ICoreWindowResizeManagerStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(CoreWindowResizeManager(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,67,111,114,101,87,105,110,100,111,119,82,101,115,105,122,101,77,97,110,97,103,101,114,0]) [CLSID_CoreWindowResizeManager]);
DEFINE_IID!(IID_ICoreWindowResizeManagerLayoutCapability, 3145003643, 42308, 17153, 128, 230, 10, 224, 51, 239, 69, 54);
RT_INTERFACE!{interface ICoreWindowResizeManagerLayoutCapability(ICoreWindowResizeManagerLayoutCapabilityVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowResizeManagerLayoutCapability] {
    fn put_ShouldWaitForLayoutCompletion(&self, value: bool) -> HRESULT,
    fn get_ShouldWaitForLayoutCompletion(&self, out: *mut bool) -> HRESULT
}}
impl ICoreWindowResizeManagerLayoutCapability {
    #[inline] pub unsafe fn set_should_wait_for_layout_completion(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShouldWaitForLayoutCompletion)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_should_wait_for_layout_completion(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShouldWaitForLayoutCompletion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindowResizeManagerStatics, 2924122181, 28016, 18907, 142, 104, 70, 255, 189, 23, 211, 141);
RT_INTERFACE!{static interface ICoreWindowResizeManagerStatics(ICoreWindowResizeManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowResizeManagerStatics] {
    fn GetForCurrentView(&self, out: *mut *mut CoreWindowResizeManager) -> HRESULT
}}
impl ICoreWindowResizeManagerStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<CoreWindowResizeManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreWindowStatic, 1294176261, 15402, 16817, 144, 34, 83, 107, 185, 207, 147, 177);
RT_INTERFACE!{static interface ICoreWindowStatic(ICoreWindowStaticVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWindowStatic] {
    fn GetForCurrentThread(&self, out: *mut *mut CoreWindow) -> HRESULT
}}
impl ICoreWindowStatic {
    #[inline] pub unsafe fn get_for_current_thread(&self) -> Result<ComPtr<CoreWindow>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentThread)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_DispatchedHandler, 3522328260, 39128, 17974, 191, 73, 235, 121, 80, 117, 72, 233);
RT_DELEGATE!{delegate DispatchedHandler(DispatchedHandlerVtbl, DispatchedHandlerImpl) [IID_DispatchedHandler] {
    fn Invoke(&self) -> HRESULT
}}
impl DispatchedHandler {
    #[inline] pub unsafe fn invoke(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IdleDispatchedHandler, 2754284580, 32545, 19132, 153, 193, 143, 1, 0, 127, 8, 128);
RT_DELEGATE!{delegate IdleDispatchedHandler(IdleDispatchedHandlerVtbl, IdleDispatchedHandlerImpl) [IID_IdleDispatchedHandler] {
    fn Invoke(&self, e: *mut IdleDispatchedHandlerArgs) -> HRESULT
}}
impl IdleDispatchedHandler {
    #[inline] pub unsafe fn invoke(&self, e: &IdleDispatchedHandlerArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IIdleDispatchedHandlerArgs, 2562419236, 56348, 17355, 180, 237, 209, 192, 235, 35, 145, 243);
RT_INTERFACE!{interface IIdleDispatchedHandlerArgs(IIdleDispatchedHandlerArgsVtbl): IInspectable(IInspectableVtbl) [IID_IIdleDispatchedHandlerArgs] {
    fn get_IsDispatcherIdle(&self, out: *mut bool) -> HRESULT
}}
impl IIdleDispatchedHandlerArgs {
    #[inline] pub unsafe fn get_is_dispatcher_idle(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDispatcherIdle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class IdleDispatchedHandlerArgs: IIdleDispatchedHandlerArgs}
DEFINE_IID!(IID_IInitializeWithCoreWindow, 412033238, 39027, 17994, 172, 229, 87, 224, 16, 244, 101, 230);
RT_INTERFACE!{interface IInitializeWithCoreWindow(IInitializeWithCoreWindowVtbl): IInspectable(IInspectableVtbl) [IID_IInitializeWithCoreWindow] {
    fn Initialize(&self, window: *mut CoreWindow) -> HRESULT
}}
impl IInitializeWithCoreWindow {
    #[inline] pub unsafe fn initialize(&self, window: &CoreWindow) -> Result<()> {
        let hr = ((*self.lpVtbl).Initialize)(self as *const _ as *mut _, window as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInputEnabledEventArgs, 2151095631, 12248, 19492, 170, 134, 49, 99, 168, 123, 78, 90);
RT_INTERFACE!{interface IInputEnabledEventArgs(IInputEnabledEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IInputEnabledEventArgs] {
    fn get_InputEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IInputEnabledEventArgs {
    #[inline] pub unsafe fn get_input_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InputEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InputEnabledEventArgs: IInputEnabledEventArgs}
DEFINE_IID!(IID_IKeyEventArgs, 1609951536, 9540, 18967, 189, 120, 31, 47, 222, 187, 16, 107);
RT_INTERFACE!{interface IKeyEventArgs(IKeyEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IKeyEventArgs] {
    #[cfg(not(feature="windows-system"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-system")] fn get_VirtualKey(&self, out: *mut super::super::system::VirtualKey) -> HRESULT,
    fn get_KeyStatus(&self, out: *mut CorePhysicalKeyStatus) -> HRESULT
}}
impl IKeyEventArgs {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_virtual_key(&self) -> Result<super::super::system::VirtualKey> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VirtualKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_status(&self) -> Result<CorePhysicalKeyStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyStatus)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class KeyEventArgs: IKeyEventArgs}
DEFINE_IID!(IID_IKeyEventArgs2, 1480252824, 1936, 17777, 155, 18, 100, 94, 249, 215, 158, 66);
RT_INTERFACE!{interface IKeyEventArgs2(IKeyEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IKeyEventArgs2] {
    fn get_DeviceId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IKeyEventArgs2 {
    #[inline] pub unsafe fn get_device_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DeviceId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPointerEventArgs, 2450365617, 42492, 18977, 140, 9, 73, 223, 230, 255, 226, 95);
RT_INTERFACE!{interface IPointerEventArgs(IPointerEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IPointerEventArgs] {
    fn get_CurrentPoint(&self, out: *mut *mut super::input::PointerPoint) -> HRESULT,
    #[cfg(not(feature="windows-system"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-system")] fn get_KeyModifiers(&self, out: *mut super::super::system::VirtualKeyModifiers) -> HRESULT,
    fn GetIntermediatePoints(&self, out: *mut *mut super::super::foundation::collections::IVector<super::input::PointerPoint>) -> HRESULT
}}
impl IPointerEventArgs {
    #[inline] pub unsafe fn get_current_point(&self) -> Result<ComPtr<super::input::PointerPoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CurrentPoint)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_key_modifiers(&self) -> Result<super::super::system::VirtualKeyModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyModifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_intermediate_points(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<super::input::PointerPoint>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIntermediatePoints)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PointerEventArgs: IPointerEventArgs}
DEFINE_IID!(IID_ISystemNavigationManager, 2466394392, 53072, 17062, 151, 6, 105, 16, 127, 161, 34, 225);
RT_INTERFACE!{interface ISystemNavigationManager(ISystemNavigationManagerVtbl): IInspectable(IInspectableVtbl) [IID_ISystemNavigationManager] {
    fn add_BackRequested(&self, handler: *mut super::super::foundation::EventHandler<BackRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BackRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISystemNavigationManager {
    #[inline] pub unsafe fn add_back_requested(&self, handler: &super::super::foundation::EventHandler<BackRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BackRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_back_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BackRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SystemNavigationManager: ISystemNavigationManager}
impl RtActivatable<ISystemNavigationManagerStatics> for SystemNavigationManager {}
impl SystemNavigationManager {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<SystemNavigationManager>> { unsafe {
        <Self as RtActivatable<ISystemNavigationManagerStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(SystemNavigationManager(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,83,121,115,116,101,109,78,97,118,105,103,97,116,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_SystemNavigationManager]);
DEFINE_IID!(IID_ISystemNavigationManager2, 2354119681, 26558, 18862, 149, 9, 103, 28, 30, 84, 163, 137);
RT_INTERFACE!{interface ISystemNavigationManager2(ISystemNavigationManager2Vtbl): IInspectable(IInspectableVtbl) [IID_ISystemNavigationManager2] {
    fn get_AppViewBackButtonVisibility(&self, out: *mut AppViewBackButtonVisibility) -> HRESULT,
    fn put_AppViewBackButtonVisibility(&self, value: AppViewBackButtonVisibility) -> HRESULT
}}
impl ISystemNavigationManager2 {
    #[inline] pub unsafe fn get_app_view_back_button_visibility(&self) -> Result<AppViewBackButtonVisibility> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AppViewBackButtonVisibility)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_app_view_back_button_visibility(&self, value: AppViewBackButtonVisibility) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppViewBackButtonVisibility)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISystemNavigationManagerStatics, 3696408014, 48864, 17157, 140, 84, 104, 34, 142, 214, 131, 181);
RT_INTERFACE!{static interface ISystemNavigationManagerStatics(ISystemNavigationManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemNavigationManagerStatics] {
    fn GetForCurrentView(&self, out: *mut *mut SystemNavigationManager) -> HRESULT
}}
impl ISystemNavigationManagerStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<SystemNavigationManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITouchHitTestingEventArgs, 586397731, 2940, 16974, 157, 247, 51, 212, 249, 98, 147, 27);
RT_INTERFACE!{interface ITouchHitTestingEventArgs(ITouchHitTestingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ITouchHitTestingEventArgs] {
    fn get_ProximityEvaluation(&self, out: *mut CoreProximityEvaluation) -> HRESULT,
    fn put_ProximityEvaluation(&self, value: CoreProximityEvaluation) -> HRESULT,
    fn get_Point(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_BoundingBox(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn EvaluateProximityToRect(&self, controlBoundingBox: super::super::foundation::Rect, out: *mut CoreProximityEvaluation) -> HRESULT,
    fn EvaluateProximityToPolygon(&self, controlVerticesSize: u32, controlVertices: *mut super::super::foundation::Point, out: *mut CoreProximityEvaluation) -> HRESULT
}}
impl ITouchHitTestingEventArgs {
    #[inline] pub unsafe fn get_proximity_evaluation(&self) -> Result<CoreProximityEvaluation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProximityEvaluation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_proximity_evaluation(&self, value: CoreProximityEvaluation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProximityEvaluation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_point(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Point)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounding_box(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundingBox)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn evaluate_proximity_to_rect(&self, controlBoundingBox: super::super::foundation::Rect) -> Result<CoreProximityEvaluation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).EvaluateProximityToRect)(self as *const _ as *mut _, controlBoundingBox, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn evaluate_proximity_to_polygon(&self, controlVertices: &[super::super::foundation::Point]) -> Result<CoreProximityEvaluation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).EvaluateProximityToPolygon)(self as *const _ as *mut _, controlVertices.len() as u32, controlVertices.as_ptr() as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class TouchHitTestingEventArgs: ITouchHitTestingEventArgs}
DEFINE_IID!(IID_IVisibilityChangedEventArgs, 3214481642, 55297, 17764, 164, 149, 177, 232, 79, 138, 208, 133);
RT_INTERFACE!{interface IVisibilityChangedEventArgs(IVisibilityChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVisibilityChangedEventArgs] {
    fn get_Visible(&self, out: *mut bool) -> HRESULT
}}
impl IVisibilityChangedEventArgs {
    #[inline] pub unsafe fn get_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class VisibilityChangedEventArgs: IVisibilityChangedEventArgs}
DEFINE_IID!(IID_IWindowActivatedEventArgs, 396191207, 18008, 19638, 170, 19, 65, 208, 148, 234, 37, 94);
RT_INTERFACE!{interface IWindowActivatedEventArgs(IWindowActivatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWindowActivatedEventArgs] {
    fn get_WindowActivationState(&self, out: *mut CoreWindowActivationState) -> HRESULT
}}
impl IWindowActivatedEventArgs {
    #[inline] pub unsafe fn get_window_activation_state(&self) -> Result<CoreWindowActivationState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WindowActivationState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class WindowActivatedEventArgs: IWindowActivatedEventArgs}
DEFINE_IID!(IID_IWindowSizeChangedEventArgs, 1512050375, 1062, 18396, 184, 108, 111, 71, 89, 21, 228, 81);
RT_INTERFACE!{interface IWindowSizeChangedEventArgs(IWindowSizeChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWindowSizeChangedEventArgs] {
    fn get_Size(&self, out: *mut super::super::foundation::Size) -> HRESULT
}}
impl IWindowSizeChangedEventArgs {
    #[inline] pub unsafe fn get_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class WindowSizeChangedEventArgs: IWindowSizeChangedEventArgs}
pub mod preview { // Windows.UI.Core.Preview
use ::prelude::*;
DEFINE_IID!(IID_ISystemNavigationCloseRequestedPreviewEventArgs, 2211450337, 52197, 20273, 132, 20, 54, 29, 160, 70, 81, 143);
RT_INTERFACE!{interface ISystemNavigationCloseRequestedPreviewEventArgs(ISystemNavigationCloseRequestedPreviewEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemNavigationCloseRequestedPreviewEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ISystemNavigationCloseRequestedPreviewEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SystemNavigationCloseRequestedPreviewEventArgs: ISystemNavigationCloseRequestedPreviewEventArgs}
DEFINE_IID!(IID_ISystemNavigationManagerPreview, 3965650056, 25637, 18295, 165, 54, 203, 86, 52, 66, 127, 13);
RT_INTERFACE!{interface ISystemNavigationManagerPreview(ISystemNavigationManagerPreviewVtbl): IInspectable(IInspectableVtbl) [IID_ISystemNavigationManagerPreview] {
    fn add_CloseRequested(&self, handler: *mut ::rt::gen::windows::foundation::EventHandler<SystemNavigationCloseRequestedPreviewEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CloseRequested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISystemNavigationManagerPreview {
    #[inline] pub unsafe fn add_close_requested(&self, handler: &::rt::gen::windows::foundation::EventHandler<SystemNavigationCloseRequestedPreviewEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CloseRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_close_requested(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CloseRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SystemNavigationManagerPreview: ISystemNavigationManagerPreview}
impl RtActivatable<ISystemNavigationManagerPreviewStatics> for SystemNavigationManagerPreview {}
impl SystemNavigationManagerPreview {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<SystemNavigationManagerPreview>> { unsafe {
        <Self as RtActivatable<ISystemNavigationManagerPreviewStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(SystemNavigationManagerPreview(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,80,114,101,118,105,101,119,46,83,121,115,116,101,109,78,97,118,105,103,97,116,105,111,110,77,97,110,97,103,101,114,80,114,101,118,105,101,119,0]) [CLSID_SystemNavigationManagerPreview]);
DEFINE_IID!(IID_ISystemNavigationManagerPreviewStatics, 244781920, 57204, 19406, 132, 203, 189, 17, 129, 172, 10, 113);
RT_INTERFACE!{static interface ISystemNavigationManagerPreviewStatics(ISystemNavigationManagerPreviewStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISystemNavigationManagerPreviewStatics] {
    fn GetForCurrentView(&self, out: *mut *mut SystemNavigationManagerPreview) -> HRESULT
}}
impl ISystemNavigationManagerPreviewStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<SystemNavigationManagerPreview>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.Core.Preview
pub mod animationmetrics { // Windows.UI.Core.AnimationMetrics
use ::prelude::*;
DEFINE_IID!(IID_IAnimationDescription, 2098308425, 48701, 16862, 176, 129, 5, 193, 73, 150, 47, 155);
RT_INTERFACE!{interface IAnimationDescription(IAnimationDescriptionVtbl): IInspectable(IInspectableVtbl) [IID_IAnimationDescription] {
    fn get_Animations(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IPropertyAnimation>) -> HRESULT,
    fn get_StaggerDelay(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_StaggerDelayFactor(&self, out: *mut f32) -> HRESULT,
    fn get_DelayLimit(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_ZOrder(&self, out: *mut i32) -> HRESULT
}}
impl IAnimationDescription {
    #[inline] pub unsafe fn get_animations(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IPropertyAnimation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Animations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stagger_delay(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StaggerDelay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stagger_delay_factor(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StaggerDelayFactor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delay_limit(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DelayLimit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zorder(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ZOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AnimationDescription: IAnimationDescription}
impl RtActivatable<IAnimationDescriptionFactory> for AnimationDescription {}
impl AnimationDescription {
    #[inline] pub fn create_instance(effect: AnimationEffect, target: AnimationEffectTarget) -> Result<ComPtr<AnimationDescription>> { unsafe {
        <Self as RtActivatable<IAnimationDescriptionFactory>>::get_activation_factory().create_instance(effect, target)
    }}
}
DEFINE_CLSID!(AnimationDescription(&[87,105,110,100,111,119,115,46,85,73,46,67,111,114,101,46,65,110,105,109,97,116,105,111,110,77,101,116,114,105,99,115,46,65,110,105,109,97,116,105,111,110,68,101,115,99,114,105,112,116,105,111,110,0]) [CLSID_AnimationDescription]);
DEFINE_IID!(IID_IAnimationDescriptionFactory, 3336731326, 49659, 18613, 146, 113, 236, 199, 10, 200, 110, 240);
RT_INTERFACE!{static interface IAnimationDescriptionFactory(IAnimationDescriptionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAnimationDescriptionFactory] {
    fn CreateInstance(&self, effect: AnimationEffect, target: AnimationEffectTarget, out: *mut *mut AnimationDescription) -> HRESULT
}}
impl IAnimationDescriptionFactory {
    #[inline] pub unsafe fn create_instance(&self, effect: AnimationEffect, target: AnimationEffectTarget) -> Result<ComPtr<AnimationDescription>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, effect, target, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AnimationEffect: i32 {
    Expand (AnimationEffect_Expand) = 0, Collapse (AnimationEffect_Collapse) = 1, Reposition (AnimationEffect_Reposition) = 2, FadeIn (AnimationEffect_FadeIn) = 3, FadeOut (AnimationEffect_FadeOut) = 4, AddToList (AnimationEffect_AddToList) = 5, DeleteFromList (AnimationEffect_DeleteFromList) = 6, AddToGrid (AnimationEffect_AddToGrid) = 7, DeleteFromGrid (AnimationEffect_DeleteFromGrid) = 8, AddToSearchGrid (AnimationEffect_AddToSearchGrid) = 9, DeleteFromSearchGrid (AnimationEffect_DeleteFromSearchGrid) = 10, AddToSearchList (AnimationEffect_AddToSearchList) = 11, DeleteFromSearchList (AnimationEffect_DeleteFromSearchList) = 12, ShowEdgeUI (AnimationEffect_ShowEdgeUI) = 13, ShowPanel (AnimationEffect_ShowPanel) = 14, HideEdgeUI (AnimationEffect_HideEdgeUI) = 15, HidePanel (AnimationEffect_HidePanel) = 16, ShowPopup (AnimationEffect_ShowPopup) = 17, HidePopup (AnimationEffect_HidePopup) = 18, PointerDown (AnimationEffect_PointerDown) = 19, PointerUp (AnimationEffect_PointerUp) = 20, DragSourceStart (AnimationEffect_DragSourceStart) = 21, DragSourceEnd (AnimationEffect_DragSourceEnd) = 22, TransitionContent (AnimationEffect_TransitionContent) = 23, Reveal (AnimationEffect_Reveal) = 24, Hide (AnimationEffect_Hide) = 25, DragBetweenEnter (AnimationEffect_DragBetweenEnter) = 26, DragBetweenLeave (AnimationEffect_DragBetweenLeave) = 27, SwipeSelect (AnimationEffect_SwipeSelect) = 28, SwipeDeselect (AnimationEffect_SwipeDeselect) = 29, SwipeReveal (AnimationEffect_SwipeReveal) = 30, EnterPage (AnimationEffect_EnterPage) = 31, TransitionPage (AnimationEffect_TransitionPage) = 32, CrossFade (AnimationEffect_CrossFade) = 33, Peek (AnimationEffect_Peek) = 34, UpdateBadge (AnimationEffect_UpdateBadge) = 35,
}}
RT_ENUM! { enum AnimationEffectTarget: i32 {
    Primary (AnimationEffectTarget_Primary) = 0, Added (AnimationEffectTarget_Added) = 1, Affected (AnimationEffectTarget_Affected) = 2, Background (AnimationEffectTarget_Background) = 3, Content (AnimationEffectTarget_Content) = 4, Deleted (AnimationEffectTarget_Deleted) = 5, Deselected (AnimationEffectTarget_Deselected) = 6, DragSource (AnimationEffectTarget_DragSource) = 7, Hidden (AnimationEffectTarget_Hidden) = 8, Incoming (AnimationEffectTarget_Incoming) = 9, Outgoing (AnimationEffectTarget_Outgoing) = 10, Outline (AnimationEffectTarget_Outline) = 11, Remaining (AnimationEffectTarget_Remaining) = 12, Revealed (AnimationEffectTarget_Revealed) = 13, RowIn (AnimationEffectTarget_RowIn) = 14, RowOut (AnimationEffectTarget_RowOut) = 15, Selected (AnimationEffectTarget_Selected) = 16, Selection (AnimationEffectTarget_Selection) = 17, Shown (AnimationEffectTarget_Shown) = 18, Tapped (AnimationEffectTarget_Tapped) = 19,
}}
DEFINE_IID!(IID_IOpacityAnimation, 2151328741, 61054, 17759, 132, 233, 37, 6, 175, 184, 210, 180);
RT_INTERFACE!{interface IOpacityAnimation(IOpacityAnimationVtbl): IInspectable(IInspectableVtbl) [IID_IOpacityAnimation] {
    fn get_InitialOpacity(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<f32>) -> HRESULT,
    fn get_FinalOpacity(&self, out: *mut f32) -> HRESULT
}}
impl IOpacityAnimation {
    #[inline] pub unsafe fn get_initial_opacity(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InitialOpacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_final_opacity(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FinalOpacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class OpacityAnimation: IOpacityAnimation}
DEFINE_IID!(IID_IPropertyAnimation, 973190362, 19852, 16670, 182, 21, 26, 222, 104, 58, 153, 3);
RT_INTERFACE!{interface IPropertyAnimation(IPropertyAnimationVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyAnimation] {
    fn get_Type(&self, out: *mut PropertyAnimationType) -> HRESULT,
    fn get_Delay(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_Duration(&self, out: *mut ::rt::gen::windows::foundation::TimeSpan) -> HRESULT,
    fn get_Control1(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn get_Control2(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT
}}
impl IPropertyAnimation {
    #[inline] pub unsafe fn get_type(&self) -> Result<PropertyAnimationType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delay(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Delay)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_duration(&self) -> Result<::rt::gen::windows::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Duration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_control1(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Control1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_control2(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Control2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PropertyAnimation: IPropertyAnimation}
RT_ENUM! { enum PropertyAnimationType: i32 {
    Scale (PropertyAnimationType_Scale) = 0, Translation (PropertyAnimationType_Translation) = 1, Opacity (PropertyAnimationType_Opacity) = 2,
}}
DEFINE_IID!(IID_IScaleAnimation, 37049031, 29099, 17036, 156, 159, 211, 23, 128, 150, 73, 149);
RT_INTERFACE!{interface IScaleAnimation(IScaleAnimationVtbl): IInspectable(IInspectableVtbl) [IID_IScaleAnimation] {
    fn get_InitialScaleX(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<f32>) -> HRESULT,
    fn get_InitialScaleY(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<f32>) -> HRESULT,
    fn get_FinalScaleX(&self, out: *mut f32) -> HRESULT,
    fn get_FinalScaleY(&self, out: *mut f32) -> HRESULT,
    fn get_NormalizedOrigin(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT
}}
impl IScaleAnimation {
    #[inline] pub unsafe fn get_initial_scale_x(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InitialScaleX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_initial_scale_y(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InitialScaleY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_final_scale_x(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FinalScaleX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_final_scale_y(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FinalScaleY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_normalized_origin(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NormalizedOrigin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ScaleAnimation: IScaleAnimation}
RT_CLASS!{class TranslationAnimation: IPropertyAnimation}
} // Windows.UI.Core.AnimationMetrics
} // Windows.UI.Core
pub mod input { // Windows.UI.Input
use ::prelude::*;
RT_STRUCT! { struct CrossSlideThresholds {
    SelectionStart: f32, SpeedBumpStart: f32, SpeedBumpEnd: f32, RearrangeStart: f32,
}}
DEFINE_IID!(IID_ICrossSlidingEventArgs, 3912714040, 28552, 16857, 135, 32, 120, 224, 142, 57, 131, 73);
RT_INTERFACE!{interface ICrossSlidingEventArgs(ICrossSlidingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICrossSlidingEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_CrossSlidingState(&self, out: *mut CrossSlidingState) -> HRESULT
}}
impl ICrossSlidingEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cross_sliding_state(&self) -> Result<CrossSlidingState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CrossSlidingState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CrossSlidingEventArgs: ICrossSlidingEventArgs}
RT_ENUM! { enum CrossSlidingState: i32 {
    Started (CrossSlidingState_Started) = 0, Dragging (CrossSlidingState_Dragging) = 1, Selecting (CrossSlidingState_Selecting) = 2, SelectSpeedBumping (CrossSlidingState_SelectSpeedBumping) = 3, SpeedBumping (CrossSlidingState_SpeedBumping) = 4, Rearranging (CrossSlidingState_Rearranging) = 5, Completed (CrossSlidingState_Completed) = 6,
}}
DEFINE_IID!(IID_IDraggingEventArgs, 479220612, 2108, 19411, 181, 89, 23, 156, 221, 235, 51, 236);
RT_INTERFACE!{interface IDraggingEventArgs(IDraggingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDraggingEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_DraggingState(&self, out: *mut DraggingState) -> HRESULT
}}
impl IDraggingEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dragging_state(&self) -> Result<DraggingState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DraggingState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DraggingEventArgs: IDraggingEventArgs}
RT_ENUM! { enum DraggingState: i32 {
    Started (DraggingState_Started) = 0, Continuing (DraggingState_Continuing) = 1, Completed (DraggingState_Completed) = 2,
}}
DEFINE_IID!(IID_IEdgeGesture, 1477268114, 10929, 18858, 167, 240, 51, 189, 63, 141, 249, 241);
RT_INTERFACE!{interface IEdgeGesture(IEdgeGestureVtbl): IInspectable(IInspectableVtbl) [IID_IEdgeGesture] {
    fn add_Starting(&self, handler: *mut super::super::foundation::TypedEventHandler<EdgeGesture, EdgeGestureEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Starting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Completed(&self, handler: *mut super::super::foundation::TypedEventHandler<EdgeGesture, EdgeGestureEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Completed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Canceled(&self, handler: *mut super::super::foundation::TypedEventHandler<EdgeGesture, EdgeGestureEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Canceled(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IEdgeGesture {
    #[inline] pub unsafe fn add_starting(&self, handler: &super::super::foundation::TypedEventHandler<EdgeGesture, EdgeGestureEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Starting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_starting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Starting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_completed(&self, handler: &super::super::foundation::TypedEventHandler<EdgeGesture, EdgeGestureEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Completed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Completed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_canceled(&self, handler: &super::super::foundation::TypedEventHandler<EdgeGesture, EdgeGestureEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Canceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_canceled(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Canceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class EdgeGesture: IEdgeGesture}
impl RtActivatable<IEdgeGestureStatics> for EdgeGesture {}
impl EdgeGesture {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<EdgeGesture>> { unsafe {
        <Self as RtActivatable<IEdgeGestureStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(EdgeGesture(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,69,100,103,101,71,101,115,116,117,114,101,0]) [CLSID_EdgeGesture]);
DEFINE_IID!(IID_IEdgeGestureEventArgs, 1157253668, 11529, 17121, 139, 94, 54, 130, 8, 121, 106, 76);
RT_INTERFACE!{interface IEdgeGestureEventArgs(IEdgeGestureEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IEdgeGestureEventArgs] {
    fn get_Kind(&self, out: *mut EdgeGestureKind) -> HRESULT
}}
impl IEdgeGestureEventArgs {
    #[inline] pub unsafe fn get_kind(&self) -> Result<EdgeGestureKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class EdgeGestureEventArgs: IEdgeGestureEventArgs}
RT_ENUM! { enum EdgeGestureKind: i32 {
    Touch (EdgeGestureKind_Touch) = 0, Keyboard (EdgeGestureKind_Keyboard) = 1, Mouse (EdgeGestureKind_Mouse) = 2,
}}
DEFINE_IID!(IID_IEdgeGestureStatics, 3161097497, 6382, 16451, 152, 57, 79, 197, 132, 214, 10, 20);
RT_INTERFACE!{static interface IEdgeGestureStatics(IEdgeGestureStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IEdgeGestureStatics] {
    fn GetForCurrentView(&self, out: *mut *mut EdgeGesture) -> HRESULT
}}
impl IEdgeGestureStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<EdgeGesture>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGestureRecognizer, 3027908543, 15723, 20360, 131, 232, 109, 203, 64, 18, 255, 176);
RT_INTERFACE!{interface IGestureRecognizer(IGestureRecognizerVtbl): IInspectable(IInspectableVtbl) [IID_IGestureRecognizer] {
    fn get_GestureSettings(&self, out: *mut GestureSettings) -> HRESULT,
    fn put_GestureSettings(&self, value: GestureSettings) -> HRESULT,
    fn get_IsInertial(&self, out: *mut bool) -> HRESULT,
    fn get_IsActive(&self, out: *mut bool) -> HRESULT,
    fn get_ShowGestureFeedback(&self, out: *mut bool) -> HRESULT,
    fn put_ShowGestureFeedback(&self, value: bool) -> HRESULT,
    fn get_PivotCenter(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn put_PivotCenter(&self, value: super::super::foundation::Point) -> HRESULT,
    fn get_PivotRadius(&self, out: *mut f32) -> HRESULT,
    fn put_PivotRadius(&self, value: f32) -> HRESULT,
    fn get_InertiaTranslationDeceleration(&self, out: *mut f32) -> HRESULT,
    fn put_InertiaTranslationDeceleration(&self, value: f32) -> HRESULT,
    fn get_InertiaRotationDeceleration(&self, out: *mut f32) -> HRESULT,
    fn put_InertiaRotationDeceleration(&self, value: f32) -> HRESULT,
    fn get_InertiaExpansionDeceleration(&self, out: *mut f32) -> HRESULT,
    fn put_InertiaExpansionDeceleration(&self, value: f32) -> HRESULT,
    fn get_InertiaTranslationDisplacement(&self, out: *mut f32) -> HRESULT,
    fn put_InertiaTranslationDisplacement(&self, value: f32) -> HRESULT,
    fn get_InertiaRotationAngle(&self, out: *mut f32) -> HRESULT,
    fn put_InertiaRotationAngle(&self, value: f32) -> HRESULT,
    fn get_InertiaExpansion(&self, out: *mut f32) -> HRESULT,
    fn put_InertiaExpansion(&self, value: f32) -> HRESULT,
    fn get_ManipulationExact(&self, out: *mut bool) -> HRESULT,
    fn put_ManipulationExact(&self, value: bool) -> HRESULT,
    fn get_CrossSlideThresholds(&self, out: *mut CrossSlideThresholds) -> HRESULT,
    fn put_CrossSlideThresholds(&self, value: CrossSlideThresholds) -> HRESULT,
    fn get_CrossSlideHorizontally(&self, out: *mut bool) -> HRESULT,
    fn put_CrossSlideHorizontally(&self, value: bool) -> HRESULT,
    fn get_CrossSlideExact(&self, out: *mut bool) -> HRESULT,
    fn put_CrossSlideExact(&self, value: bool) -> HRESULT,
    fn get_AutoProcessInertia(&self, out: *mut bool) -> HRESULT,
    fn put_AutoProcessInertia(&self, value: bool) -> HRESULT,
    fn get_MouseWheelParameters(&self, out: *mut *mut MouseWheelParameters) -> HRESULT,
    fn CanBeDoubleTap(&self, value: *mut PointerPoint, out: *mut bool) -> HRESULT,
    fn ProcessDownEvent(&self, value: *mut PointerPoint) -> HRESULT,
    fn ProcessMoveEvents(&self, value: *mut super::super::foundation::collections::IVector<PointerPoint>) -> HRESULT,
    fn ProcessUpEvent(&self, value: *mut PointerPoint) -> HRESULT,
    fn ProcessMouseWheelEvent(&self, value: *mut PointerPoint, isShiftKeyDown: bool, isControlKeyDown: bool) -> HRESULT,
    fn ProcessInertia(&self) -> HRESULT,
    fn CompleteGesture(&self) -> HRESULT,
    fn add_Tapped(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, TappedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Tapped(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RightTapped(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, RightTappedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RightTapped(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Holding(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, HoldingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Holding(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Dragging(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, DraggingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Dragging(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationStarted(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationStartedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationStarted(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationUpdated(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationUpdatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationUpdated(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationInertiaStarting(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationInertiaStartingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationInertiaStarting(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationCompleted(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationCompletedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationCompleted(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CrossSliding(&self, handler: *mut super::super::foundation::TypedEventHandler<GestureRecognizer, CrossSlidingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CrossSliding(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IGestureRecognizer {
    #[inline] pub unsafe fn get_gesture_settings(&self) -> Result<GestureSettings> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GestureSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_gesture_settings(&self, value: GestureSettings) -> Result<()> {
        let hr = ((*self.lpVtbl).put_GestureSettings)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_inertial(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInertial)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_active(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsActive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_gesture_feedback(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowGestureFeedback)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_gesture_feedback(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowGestureFeedback)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pivot_center(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PivotCenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pivot_center(&self, value: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PivotCenter)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pivot_radius(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PivotRadius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pivot_radius(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PivotRadius)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inertia_translation_deceleration(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InertiaTranslationDeceleration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inertia_translation_deceleration(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InertiaTranslationDeceleration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inertia_rotation_deceleration(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InertiaRotationDeceleration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inertia_rotation_deceleration(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InertiaRotationDeceleration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inertia_expansion_deceleration(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InertiaExpansionDeceleration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inertia_expansion_deceleration(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InertiaExpansionDeceleration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inertia_translation_displacement(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InertiaTranslationDisplacement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inertia_translation_displacement(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InertiaTranslationDisplacement)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inertia_rotation_angle(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InertiaRotationAngle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inertia_rotation_angle(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InertiaRotationAngle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inertia_expansion(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InertiaExpansion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inertia_expansion(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InertiaExpansion)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_exact(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ManipulationExact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_manipulation_exact(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ManipulationExact)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cross_slide_thresholds(&self) -> Result<CrossSlideThresholds> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CrossSlideThresholds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cross_slide_thresholds(&self, value: CrossSlideThresholds) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CrossSlideThresholds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cross_slide_horizontally(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CrossSlideHorizontally)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cross_slide_horizontally(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CrossSlideHorizontally)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cross_slide_exact(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CrossSlideExact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cross_slide_exact(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CrossSlideExact)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_process_inertia(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoProcessInertia)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_process_inertia(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoProcessInertia)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mouse_wheel_parameters(&self) -> Result<ComPtr<MouseWheelParameters>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MouseWheelParameters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_be_double_tap(&self, value: &PointerPoint) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanBeDoubleTap)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_down_event(&self, value: &PointerPoint) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessDownEvent)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_move_events(&self, value: &super::super::foundation::collections::IVector<PointerPoint>) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessMoveEvents)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_up_event(&self, value: &PointerPoint) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessUpEvent)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_mouse_wheel_event(&self, value: &PointerPoint, isShiftKeyDown: bool, isControlKeyDown: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessMouseWheelEvent)(self as *const _ as *mut _, value as *const _ as *mut _, isShiftKeyDown, isControlKeyDown);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_inertia(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessInertia)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn complete_gesture(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).CompleteGesture)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_tapped(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, TappedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Tapped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_tapped(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Tapped)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_right_tapped(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, RightTappedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RightTapped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_right_tapped(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RightTapped)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_holding(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, HoldingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Holding)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_holding(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Holding)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_dragging(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, DraggingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Dragging)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_dragging(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Dragging)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_started(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationStartedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_started(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationStarted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_updated(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationUpdatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationUpdated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_updated(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationUpdated)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_inertia_starting(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationInertiaStartingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationInertiaStarting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_inertia_starting(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationInertiaStarting)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_completed(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, ManipulationCompletedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_completed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationCompleted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_cross_sliding(&self, handler: &super::super::foundation::TypedEventHandler<GestureRecognizer, CrossSlidingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CrossSliding)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_cross_sliding(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CrossSliding)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GestureRecognizer: IGestureRecognizer}
impl RtActivatable<IActivationFactory> for GestureRecognizer {}
DEFINE_CLSID!(GestureRecognizer(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,71,101,115,116,117,114,101,82,101,99,111,103,110,105,122,101,114,0]) [CLSID_GestureRecognizer]);
RT_ENUM! { enum GestureSettings: u32 {
    None (GestureSettings_None) = 0, Tap (GestureSettings_Tap) = 1, DoubleTap (GestureSettings_DoubleTap) = 2, Hold (GestureSettings_Hold) = 4, HoldWithMouse (GestureSettings_HoldWithMouse) = 8, RightTap (GestureSettings_RightTap) = 16, Drag (GestureSettings_Drag) = 32, ManipulationTranslateX (GestureSettings_ManipulationTranslateX) = 64, ManipulationTranslateY (GestureSettings_ManipulationTranslateY) = 128, ManipulationTranslateRailsX (GestureSettings_ManipulationTranslateRailsX) = 256, ManipulationTranslateRailsY (GestureSettings_ManipulationTranslateRailsY) = 512, ManipulationRotate (GestureSettings_ManipulationRotate) = 1024, ManipulationScale (GestureSettings_ManipulationScale) = 2048, ManipulationTranslateInertia (GestureSettings_ManipulationTranslateInertia) = 4096, ManipulationRotateInertia (GestureSettings_ManipulationRotateInertia) = 8192, ManipulationScaleInertia (GestureSettings_ManipulationScaleInertia) = 16384, CrossSlide (GestureSettings_CrossSlide) = 32768, ManipulationMultipleFingerPanning (GestureSettings_ManipulationMultipleFingerPanning) = 65536,
}}
DEFINE_IID!(IID_IHoldingEventArgs, 737629637, 59289, 16820, 187, 64, 36, 47, 64, 149, 155, 113);
RT_INTERFACE!{interface IHoldingEventArgs(IHoldingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IHoldingEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_HoldingState(&self, out: *mut HoldingState) -> HRESULT
}}
impl IHoldingEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_holding_state(&self) -> Result<HoldingState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HoldingState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class HoldingEventArgs: IHoldingEventArgs}
RT_ENUM! { enum HoldingState: i32 {
    Started (HoldingState_Started) = 0, Completed (HoldingState_Completed) = 1, Canceled (HoldingState_Canceled) = 2,
}}
DEFINE_IID!(IID_IKeyboardDeliveryInterceptor, 3032150120, 36681, 17516, 141, 181, 140, 15, 254, 133, 204, 158);
RT_INTERFACE!{interface IKeyboardDeliveryInterceptor(IKeyboardDeliveryInterceptorVtbl): IInspectable(IInspectableVtbl) [IID_IKeyboardDeliveryInterceptor] {
    fn get_IsInterceptionEnabledWhenInForeground(&self, out: *mut bool) -> HRESULT,
    fn put_IsInterceptionEnabledWhenInForeground(&self, value: bool) -> HRESULT,
    fn add_KeyDown(&self, handler: *mut super::super::foundation::TypedEventHandler<KeyboardDeliveryInterceptor, super::core::KeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyDown(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeyUp(&self, handler: *mut super::super::foundation::TypedEventHandler<KeyboardDeliveryInterceptor, super::core::KeyEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyUp(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IKeyboardDeliveryInterceptor {
    #[inline] pub unsafe fn get_is_interception_enabled_when_in_foreground(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInterceptionEnabledWhenInForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_interception_enabled_when_in_foreground(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsInterceptionEnabledWhenInForeground)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_down(&self, handler: &super::super::foundation::TypedEventHandler<KeyboardDeliveryInterceptor, super::core::KeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyDown)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_down(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyDown)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_up(&self, handler: &super::super::foundation::TypedEventHandler<KeyboardDeliveryInterceptor, super::core::KeyEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyUp)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_up(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyUp)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class KeyboardDeliveryInterceptor: IKeyboardDeliveryInterceptor}
impl RtActivatable<IKeyboardDeliveryInterceptorStatics> for KeyboardDeliveryInterceptor {}
impl KeyboardDeliveryInterceptor {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<KeyboardDeliveryInterceptor>> { unsafe {
        <Self as RtActivatable<IKeyboardDeliveryInterceptorStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(KeyboardDeliveryInterceptor(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,75,101,121,98,111,97,114,100,68,101,108,105,118,101,114,121,73,110,116,101,114,99,101,112,116,111,114,0]) [CLSID_KeyboardDeliveryInterceptor]);
DEFINE_IID!(IID_IKeyboardDeliveryInterceptorStatics, 4193663906, 52922, 18261, 138, 126, 20, 192, 255, 236, 210, 57);
RT_INTERFACE!{static interface IKeyboardDeliveryInterceptorStatics(IKeyboardDeliveryInterceptorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IKeyboardDeliveryInterceptorStatics] {
    fn GetForCurrentView(&self, out: *mut *mut KeyboardDeliveryInterceptor) -> HRESULT
}}
impl IKeyboardDeliveryInterceptorStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<KeyboardDeliveryInterceptor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IManipulationCompletedEventArgs, 3008016939, 53659, 18175, 159, 56, 222, 199, 117, 75, 185, 231);
RT_INTERFACE!{interface IManipulationCompletedEventArgs(IManipulationCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IManipulationCompletedEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_Cumulative(&self, out: *mut ManipulationDelta) -> HRESULT,
    fn get_Velocities(&self, out: *mut ManipulationVelocities) -> HRESULT
}}
impl IManipulationCompletedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cumulative(&self) -> Result<ManipulationDelta> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cumulative)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_velocities(&self) -> Result<ManipulationVelocities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Velocities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ManipulationCompletedEventArgs: IManipulationCompletedEventArgs}
RT_STRUCT! { struct ManipulationDelta {
    Translation: super::super::foundation::Point, Scale: f32, Rotation: f32, Expansion: f32,
}}
DEFINE_IID!(IID_IManipulationInertiaStartingEventArgs, 3711412376, 9919, 18042, 156, 229, 204, 243, 251, 17, 55, 30);
RT_INTERFACE!{interface IManipulationInertiaStartingEventArgs(IManipulationInertiaStartingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IManipulationInertiaStartingEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_Delta(&self, out: *mut ManipulationDelta) -> HRESULT,
    fn get_Cumulative(&self, out: *mut ManipulationDelta) -> HRESULT,
    fn get_Velocities(&self, out: *mut ManipulationVelocities) -> HRESULT
}}
impl IManipulationInertiaStartingEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delta(&self) -> Result<ManipulationDelta> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Delta)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cumulative(&self) -> Result<ManipulationDelta> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cumulative)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_velocities(&self) -> Result<ManipulationVelocities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Velocities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ManipulationInertiaStartingEventArgs: IManipulationInertiaStartingEventArgs}
DEFINE_IID!(IID_IManipulationStartedEventArgs, 3723265854, 53198, 18738, 140, 29, 60, 61, 1, 26, 52, 192);
RT_INTERFACE!{interface IManipulationStartedEventArgs(IManipulationStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IManipulationStartedEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_Cumulative(&self, out: *mut ManipulationDelta) -> HRESULT
}}
impl IManipulationStartedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cumulative(&self) -> Result<ManipulationDelta> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cumulative)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ManipulationStartedEventArgs: IManipulationStartedEventArgs}
DEFINE_IID!(IID_IManipulationUpdatedEventArgs, 3409267941, 43960, 20383, 179, 206, 129, 129, 170, 97, 173, 130);
RT_INTERFACE!{interface IManipulationUpdatedEventArgs(IManipulationUpdatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IManipulationUpdatedEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_Delta(&self, out: *mut ManipulationDelta) -> HRESULT,
    fn get_Cumulative(&self, out: *mut ManipulationDelta) -> HRESULT,
    fn get_Velocities(&self, out: *mut ManipulationVelocities) -> HRESULT
}}
impl IManipulationUpdatedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delta(&self) -> Result<ManipulationDelta> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Delta)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cumulative(&self) -> Result<ManipulationDelta> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cumulative)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_velocities(&self) -> Result<ManipulationVelocities> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Velocities)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ManipulationUpdatedEventArgs: IManipulationUpdatedEventArgs}
RT_STRUCT! { struct ManipulationVelocities {
    Linear: super::super::foundation::Point, Angular: f32, Expansion: f32,
}}
DEFINE_IID!(IID_IMouseWheelParameters, 3939551812, 40429, 16439, 129, 73, 94, 76, 194, 86, 68, 104);
RT_INTERFACE!{interface IMouseWheelParameters(IMouseWheelParametersVtbl): IInspectable(IInspectableVtbl) [IID_IMouseWheelParameters] {
    fn get_CharTranslation(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn put_CharTranslation(&self, value: super::super::foundation::Point) -> HRESULT,
    fn get_DeltaScale(&self, out: *mut f32) -> HRESULT,
    fn put_DeltaScale(&self, value: f32) -> HRESULT,
    fn get_DeltaRotationAngle(&self, out: *mut f32) -> HRESULT,
    fn put_DeltaRotationAngle(&self, value: f32) -> HRESULT,
    fn get_PageTranslation(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn put_PageTranslation(&self, value: super::super::foundation::Point) -> HRESULT
}}
impl IMouseWheelParameters {
    #[inline] pub unsafe fn get_char_translation(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharTranslation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_char_translation(&self, value: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CharTranslation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delta_scale(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeltaScale)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_delta_scale(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DeltaScale)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delta_rotation_angle(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeltaRotationAngle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_delta_rotation_angle(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DeltaRotationAngle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_page_translation(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PageTranslation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_page_translation(&self, value: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PageTranslation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MouseWheelParameters: IMouseWheelParameters}
DEFINE_IID!(IID_IPointerPoint, 3918868861, 29334, 17113, 130, 51, 197, 190, 115, 183, 74, 74);
RT_INTERFACE!{interface IPointerPoint(IPointerPointVtbl): IInspectable(IInspectableVtbl) [IID_IPointerPoint] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDevice(&self, out: *mut *mut super::super::devices::input::PointerDevice) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_RawPosition(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_PointerId(&self, out: *mut u32) -> HRESULT,
    fn get_FrameId(&self, out: *mut u32) -> HRESULT,
    fn get_Timestamp(&self, out: *mut u64) -> HRESULT,
    fn get_IsInContact(&self, out: *mut bool) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut PointerPointProperties) -> HRESULT
}}
impl IPointerPoint {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device(&self) -> Result<ComPtr<super::super::devices::input::PointerDevice>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerDevice)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_raw_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RawPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_frame_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FrameId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_in_contact(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInContact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<PointerPointProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PointerPoint: IPointerPoint}
impl RtActivatable<IPointerPointStatics> for PointerPoint {}
impl PointerPoint {
    #[inline] pub fn get_current_point(pointerId: u32) -> Result<ComPtr<PointerPoint>> { unsafe {
        <Self as RtActivatable<IPointerPointStatics>>::get_activation_factory().get_current_point(pointerId)
    }}
    #[inline] pub fn get_intermediate_points(pointerId: u32) -> Result<ComPtr<super::super::foundation::collections::IVector<PointerPoint>>> { unsafe {
        <Self as RtActivatable<IPointerPointStatics>>::get_activation_factory().get_intermediate_points(pointerId)
    }}
    #[inline] pub fn get_current_point_transformed(pointerId: u32, transform: &IPointerPointTransform) -> Result<ComPtr<PointerPoint>> { unsafe {
        <Self as RtActivatable<IPointerPointStatics>>::get_activation_factory().get_current_point_transformed(pointerId, transform)
    }}
    #[inline] pub fn get_intermediate_points_transformed(pointerId: u32, transform: &IPointerPointTransform) -> Result<ComPtr<super::super::foundation::collections::IVector<PointerPoint>>> { unsafe {
        <Self as RtActivatable<IPointerPointStatics>>::get_activation_factory().get_intermediate_points_transformed(pointerId, transform)
    }}
}
DEFINE_CLSID!(PointerPoint(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,111,105,110,116,101,114,80,111,105,110,116,0]) [CLSID_PointerPoint]);
DEFINE_IID!(IID_IPointerPointProperties, 3348990539, 49507, 20199, 128, 63, 103, 206, 121, 249, 151, 45);
RT_INTERFACE!{interface IPointerPointProperties(IPointerPointPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IPointerPointProperties] {
    fn get_Pressure(&self, out: *mut f32) -> HRESULT,
    fn get_IsInverted(&self, out: *mut bool) -> HRESULT,
    fn get_IsEraser(&self, out: *mut bool) -> HRESULT,
    fn get_Orientation(&self, out: *mut f32) -> HRESULT,
    fn get_XTilt(&self, out: *mut f32) -> HRESULT,
    fn get_YTilt(&self, out: *mut f32) -> HRESULT,
    fn get_Twist(&self, out: *mut f32) -> HRESULT,
    fn get_ContactRect(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn get_ContactRectRaw(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn get_TouchConfidence(&self, out: *mut bool) -> HRESULT,
    fn get_IsLeftButtonPressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsRightButtonPressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsMiddleButtonPressed(&self, out: *mut bool) -> HRESULT,
    fn get_MouseWheelDelta(&self, out: *mut i32) -> HRESULT,
    fn get_IsHorizontalMouseWheel(&self, out: *mut bool) -> HRESULT,
    fn get_IsPrimary(&self, out: *mut bool) -> HRESULT,
    fn get_IsInRange(&self, out: *mut bool) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn get_IsBarrelButtonPressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsXButton1Pressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsXButton2Pressed(&self, out: *mut bool) -> HRESULT,
    fn get_PointerUpdateKind(&self, out: *mut PointerUpdateKind) -> HRESULT,
    fn HasUsage(&self, usagePage: u32, usageId: u32, out: *mut bool) -> HRESULT,
    fn GetUsageValue(&self, usagePage: u32, usageId: u32, out: *mut i32) -> HRESULT
}}
impl IPointerPointProperties {
    #[inline] pub unsafe fn get_pressure(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Pressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_inverted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInverted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_eraser(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEraser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xtilt(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_XTilt)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ytilt(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_YTilt)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_twist(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Twist)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_rect(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ContactRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact_rect_raw(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ContactRectRaw)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_touch_confidence(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TouchConfidence)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_left_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsLeftButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_right_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRightButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_middle_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMiddleButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mouse_wheel_delta(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MouseWheelDelta)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_horizontal_mouse_wheel(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHorizontalMouseWheel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_primary(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPrimary)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_in_range(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInRange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_barrel_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBarrelButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_xbutton1_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsXButton1Pressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_xbutton2_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsXButton2Pressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_update_kind(&self) -> Result<PointerUpdateKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerUpdateKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn has_usage(&self, usagePage: u32, usageId: u32) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).HasUsage)(self as *const _ as *mut _, usagePage, usageId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_usage_value(&self, usagePage: u32, usageId: u32) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetUsageValue)(self as *const _ as *mut _, usagePage, usageId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PointerPointProperties: IPointerPointProperties}
DEFINE_IID!(IID_IPointerPointProperties2, 583222074, 51259, 16832, 162, 150, 94, 35, 45, 100, 214, 175);
RT_INTERFACE!{interface IPointerPointProperties2(IPointerPointProperties2Vtbl): IInspectable(IInspectableVtbl) [IID_IPointerPointProperties2] {
    fn get_ZDistance(&self, out: *mut *mut super::super::foundation::IReference<f32>) -> HRESULT
}}
impl IPointerPointProperties2 {
    #[inline] pub unsafe fn get_zdistance(&self) -> Result<ComPtr<super::super::foundation::IReference<f32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ZDistance)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPointerPointStatics, 2768659341, 10778, 16702, 188, 117, 159, 56, 56, 28, 192, 105);
RT_INTERFACE!{static interface IPointerPointStatics(IPointerPointStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPointerPointStatics] {
    fn GetCurrentPoint(&self, pointerId: u32, out: *mut *mut PointerPoint) -> HRESULT,
    fn GetIntermediatePoints(&self, pointerId: u32, out: *mut *mut super::super::foundation::collections::IVector<PointerPoint>) -> HRESULT,
    fn GetCurrentPointTransformed(&self, pointerId: u32, transform: *mut IPointerPointTransform, out: *mut *mut PointerPoint) -> HRESULT,
    fn GetIntermediatePointsTransformed(&self, pointerId: u32, transform: *mut IPointerPointTransform, out: *mut *mut super::super::foundation::collections::IVector<PointerPoint>) -> HRESULT
}}
impl IPointerPointStatics {
    #[inline] pub unsafe fn get_current_point(&self, pointerId: u32) -> Result<ComPtr<PointerPoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentPoint)(self as *const _ as *mut _, pointerId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_intermediate_points(&self, pointerId: u32) -> Result<ComPtr<super::super::foundation::collections::IVector<PointerPoint>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIntermediatePoints)(self as *const _ as *mut _, pointerId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_point_transformed(&self, pointerId: u32, transform: &IPointerPointTransform) -> Result<ComPtr<PointerPoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCurrentPointTransformed)(self as *const _ as *mut _, pointerId, transform as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_intermediate_points_transformed(&self, pointerId: u32, transform: &IPointerPointTransform) -> Result<ComPtr<super::super::foundation::collections::IVector<PointerPoint>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetIntermediatePointsTransformed)(self as *const _ as *mut _, pointerId, transform as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPointerPointTransform, 1298129231, 47228, 16424, 188, 156, 89, 233, 148, 127, 176, 86);
RT_INTERFACE!{interface IPointerPointTransform(IPointerPointTransformVtbl): IInspectable(IInspectableVtbl) [IID_IPointerPointTransform] {
    fn get_Inverse(&self, out: *mut *mut IPointerPointTransform) -> HRESULT,
    fn TryTransform(&self, inPoint: super::super::foundation::Point, outPoint: *mut super::super::foundation::Point, out: *mut bool) -> HRESULT,
    fn TransformBounds(&self, rect: super::super::foundation::Rect, out: *mut super::super::foundation::Rect) -> HRESULT
}}
impl IPointerPointTransform {
    #[inline] pub unsafe fn get_inverse(&self) -> Result<ComPtr<IPointerPointTransform>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Inverse)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_transform(&self, inPoint: super::super::foundation::Point) -> Result<(super::super::foundation::Point, bool)> {
        let mut outPoint = zeroed(); let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryTransform)(self as *const _ as *mut _, inPoint, &mut outPoint, &mut out);
        if hr == S_OK { Ok((outPoint, out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn transform_bounds(&self, rect: super::super::foundation::Rect) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TransformBounds)(self as *const _ as *mut _, rect, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum PointerUpdateKind: i32 {
    Other (PointerUpdateKind_Other) = 0, LeftButtonPressed (PointerUpdateKind_LeftButtonPressed) = 1, LeftButtonReleased (PointerUpdateKind_LeftButtonReleased) = 2, RightButtonPressed (PointerUpdateKind_RightButtonPressed) = 3, RightButtonReleased (PointerUpdateKind_RightButtonReleased) = 4, MiddleButtonPressed (PointerUpdateKind_MiddleButtonPressed) = 5, MiddleButtonReleased (PointerUpdateKind_MiddleButtonReleased) = 6, XButton1Pressed (PointerUpdateKind_XButton1Pressed) = 7, XButton1Released (PointerUpdateKind_XButton1Released) = 8, XButton2Pressed (PointerUpdateKind_XButton2Pressed) = 9, XButton2Released (PointerUpdateKind_XButton2Released) = 10,
}}
DEFINE_IID!(IID_IPointerVisualizationSettings, 1293837409, 34039, 18845, 189, 145, 42, 54, 226, 183, 170, 162);
RT_INTERFACE!{interface IPointerVisualizationSettings(IPointerVisualizationSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IPointerVisualizationSettings] {
    fn put_IsContactFeedbackEnabled(&self, value: bool) -> HRESULT,
    fn get_IsContactFeedbackEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsBarrelButtonFeedbackEnabled(&self, value: bool) -> HRESULT,
    fn get_IsBarrelButtonFeedbackEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IPointerVisualizationSettings {
    #[inline] pub unsafe fn set_is_contact_feedback_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsContactFeedbackEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_contact_feedback_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsContactFeedbackEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_barrel_button_feedback_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsBarrelButtonFeedbackEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_barrel_button_feedback_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBarrelButtonFeedbackEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class PointerVisualizationSettings: IPointerVisualizationSettings}
impl RtActivatable<IPointerVisualizationSettingsStatics> for PointerVisualizationSettings {}
impl PointerVisualizationSettings {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<PointerVisualizationSettings>> { unsafe {
        <Self as RtActivatable<IPointerVisualizationSettingsStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(PointerVisualizationSettings(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,111,105,110,116,101,114,86,105,115,117,97,108,105,122,97,116,105,111,110,83,101,116,116,105,110,103,115,0]) [CLSID_PointerVisualizationSettings]);
DEFINE_IID!(IID_IPointerVisualizationSettingsStatics, 1753681627, 5723, 16916, 180, 243, 88, 78, 202, 140, 138, 105);
RT_INTERFACE!{static interface IPointerVisualizationSettingsStatics(IPointerVisualizationSettingsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPointerVisualizationSettingsStatics] {
    fn GetForCurrentView(&self, out: *mut *mut PointerVisualizationSettings) -> HRESULT
}}
impl IPointerVisualizationSettingsStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<PointerVisualizationSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialController, 810930632, 57169, 17364, 178, 59, 14, 16, 55, 70, 122, 9);
RT_INTERFACE!{interface IRadialController(IRadialControllerVtbl): IInspectable(IInspectableVtbl) [IID_IRadialController] {
    fn get_Menu(&self, out: *mut *mut RadialControllerMenu) -> HRESULT,
    fn get_RotationResolutionInDegrees(&self, out: *mut f64) -> HRESULT,
    fn put_RotationResolutionInDegrees(&self, value: f64) -> HRESULT,
    fn get_UseAutomaticHapticFeedback(&self, out: *mut bool) -> HRESULT,
    fn put_UseAutomaticHapticFeedback(&self, value: bool) -> HRESULT,
    fn add_ScreenContactStarted(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerScreenContactStartedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ScreenContactStarted(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ScreenContactEnded(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ScreenContactEnded(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ScreenContactContinued(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerScreenContactContinuedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ScreenContactContinued(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ControlLost(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ControlLost(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RotationChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerRotationChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RotationChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ButtonClicked(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonClickedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ButtonClicked(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ControlAcquired(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerControlAcquiredEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ControlAcquired(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IRadialController {
    #[inline] pub unsafe fn get_menu(&self) -> Result<ComPtr<RadialControllerMenu>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Menu)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rotation_resolution_in_degrees(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RotationResolutionInDegrees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_rotation_resolution_in_degrees(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RotationResolutionInDegrees)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_use_automatic_haptic_feedback(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UseAutomaticHapticFeedback)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_use_automatic_haptic_feedback(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UseAutomaticHapticFeedback)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_screen_contact_started(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerScreenContactStartedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ScreenContactStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_screen_contact_started(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ScreenContactStarted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_screen_contact_ended(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ScreenContactEnded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_screen_contact_ended(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ScreenContactEnded)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_screen_contact_continued(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerScreenContactContinuedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ScreenContactContinued)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_screen_contact_continued(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ScreenContactContinued)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_control_lost(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ControlLost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_control_lost(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ControlLost)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_rotation_changed(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerRotationChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RotationChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_rotation_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RotationChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_button_clicked(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonClickedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ButtonClicked)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_button_clicked(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ButtonClicked)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_control_acquired(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerControlAcquiredEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ControlAcquired)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_control_acquired(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ControlAcquired)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RadialController: IRadialController}
impl RtActivatable<IRadialControllerStatics> for RadialController {}
impl RadialController {
    #[inline] pub fn is_supported() -> Result<bool> { unsafe {
        <Self as RtActivatable<IRadialControllerStatics>>::get_activation_factory().is_supported()
    }}
    #[inline] pub fn create_for_current_view() -> Result<ComPtr<RadialController>> { unsafe {
        <Self as RtActivatable<IRadialControllerStatics>>::get_activation_factory().create_for_current_view()
    }}
}
DEFINE_CLSID!(RadialController(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,82,97,100,105,97,108,67,111,110,116,114,111,108,108,101,114,0]) [CLSID_RadialController]);
DEFINE_IID!(IID_IRadialController2, 1029144319, 19694, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialController2(IRadialController2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialController2] {
    fn add_ButtonPressed(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonPressedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ButtonPressed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ButtonHolding(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonHoldingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ButtonHolding(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ButtonReleased(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonReleasedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ButtonReleased(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IRadialController2 {
    #[inline] pub unsafe fn add_button_pressed(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonPressedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ButtonPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_button_pressed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ButtonPressed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_button_holding(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonHoldingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ButtonHolding)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_button_holding(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ButtonHolding)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_button_released(&self, handler: &super::super::foundation::TypedEventHandler<RadialController, RadialControllerButtonReleasedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ButtonReleased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_button_released(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ButtonReleased)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerButtonClickedEventArgs, 543859768, 58961, 4581, 191, 98, 44, 39, 215, 64, 78, 133);
RT_INTERFACE!{interface IRadialControllerButtonClickedEventArgs(IRadialControllerButtonClickedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerButtonClickedEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT
}}
impl IRadialControllerButtonClickedEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerButtonClickedEventArgs: IRadialControllerButtonClickedEventArgs}
DEFINE_IID!(IID_IRadialControllerButtonClickedEventArgs2, 1029144307, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerButtonClickedEventArgs2(IRadialControllerButtonClickedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerButtonClickedEventArgs2] {
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerButtonClickedEventArgs2 {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerButtonHoldingEventArgs, 1029144302, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerButtonHoldingEventArgs(IRadialControllerButtonHoldingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerButtonHoldingEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerButtonHoldingEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerButtonHoldingEventArgs: IRadialControllerButtonHoldingEventArgs}
DEFINE_IID!(IID_IRadialControllerButtonPressedEventArgs, 1029144301, 19694, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerButtonPressedEventArgs(IRadialControllerButtonPressedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerButtonPressedEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerButtonPressedEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerButtonPressedEventArgs: IRadialControllerButtonPressedEventArgs}
DEFINE_IID!(IID_IRadialControllerButtonReleasedEventArgs, 1029144303, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerButtonReleasedEventArgs(IRadialControllerButtonReleasedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerButtonReleasedEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerButtonReleasedEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerButtonReleasedEventArgs: IRadialControllerButtonReleasedEventArgs}
DEFINE_IID!(IID_IRadialControllerConfiguration, 2797051595, 27218, 17456, 145, 12, 86, 55, 10, 157, 107, 66);
RT_INTERFACE!{interface IRadialControllerConfiguration(IRadialControllerConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerConfiguration] {
    fn SetDefaultMenuItems(&self, buttons: *mut super::super::foundation::collections::IIterable<RadialControllerSystemMenuItemKind>) -> HRESULT,
    fn ResetToDefaultMenuItems(&self) -> HRESULT,
    fn TrySelectDefaultMenuItem(&self, type_: RadialControllerSystemMenuItemKind, out: *mut bool) -> HRESULT
}}
impl IRadialControllerConfiguration {
    #[inline] pub unsafe fn set_default_menu_items(&self, buttons: &super::super::foundation::collections::IIterable<RadialControllerSystemMenuItemKind>) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDefaultMenuItems)(self as *const _ as *mut _, buttons as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn reset_to_default_menu_items(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ResetToDefaultMenuItems)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_select_default_menu_item(&self, type_: RadialControllerSystemMenuItemKind) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySelectDefaultMenuItem)(self as *const _ as *mut _, type_, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerConfiguration: IRadialControllerConfiguration}
impl RtActivatable<IRadialControllerConfigurationStatics> for RadialControllerConfiguration {}
impl RtActivatable<IRadialControllerConfigurationStatics2> for RadialControllerConfiguration {}
impl RadialControllerConfiguration {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<RadialControllerConfiguration>> { unsafe {
        <Self as RtActivatable<IRadialControllerConfigurationStatics>>::get_activation_factory().get_for_current_view()
    }}
    #[inline] pub fn set_app_controller(value: &RadialController) -> Result<()> { unsafe {
        <Self as RtActivatable<IRadialControllerConfigurationStatics2>>::get_activation_factory().set_app_controller(value)
    }}
    #[inline] pub fn get_app_controller() -> Result<ComPtr<RadialController>> { unsafe {
        <Self as RtActivatable<IRadialControllerConfigurationStatics2>>::get_activation_factory().get_app_controller()
    }}
    #[inline] pub fn set_is_app_controller_enabled(value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IRadialControllerConfigurationStatics2>>::get_activation_factory().set_is_app_controller_enabled(value)
    }}
    #[inline] pub fn get_is_app_controller_enabled() -> Result<bool> { unsafe {
        <Self as RtActivatable<IRadialControllerConfigurationStatics2>>::get_activation_factory().get_is_app_controller_enabled()
    }}
}
DEFINE_CLSID!(RadialControllerConfiguration(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,82,97,100,105,97,108,67,111,110,116,114,111,108,108,101,114,67,111,110,102,105,103,117,114,97,116,105,111,110,0]) [CLSID_RadialControllerConfiguration]);
DEFINE_IID!(IID_IRadialControllerConfiguration2, 1029144311, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerConfiguration2(IRadialControllerConfiguration2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerConfiguration2] {
    fn put_ActiveControllerWhenMenuIsSuppressed(&self, value: *mut RadialController) -> HRESULT,
    fn get_ActiveControllerWhenMenuIsSuppressed(&self, out: *mut *mut RadialController) -> HRESULT,
    fn put_IsMenuSuppressed(&self, value: bool) -> HRESULT,
    fn get_IsMenuSuppressed(&self, out: *mut bool) -> HRESULT
}}
impl IRadialControllerConfiguration2 {
    #[inline] pub unsafe fn set_active_controller_when_menu_is_suppressed(&self, value: &RadialController) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ActiveControllerWhenMenuIsSuppressed)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_active_controller_when_menu_is_suppressed(&self) -> Result<ComPtr<RadialController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActiveControllerWhenMenuIsSuppressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_menu_suppressed(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsMenuSuppressed)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_menu_suppressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMenuSuppressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerConfigurationStatics, 2042015973, 1690, 17542, 169, 157, 141, 183, 114, 185, 100, 47);
RT_INTERFACE!{static interface IRadialControllerConfigurationStatics(IRadialControllerConfigurationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerConfigurationStatics] {
    fn GetForCurrentView(&self, out: *mut *mut RadialControllerConfiguration) -> HRESULT
}}
impl IRadialControllerConfigurationStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<RadialControllerConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerConfigurationStatics2, 1407224599, 57861, 18643, 156, 175, 128, 255, 71, 196, 215, 199);
RT_INTERFACE!{static interface IRadialControllerConfigurationStatics2(IRadialControllerConfigurationStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerConfigurationStatics2] {
    fn put_AppController(&self, value: *mut RadialController) -> HRESULT,
    fn get_AppController(&self, out: *mut *mut RadialController) -> HRESULT,
    fn put_IsAppControllerEnabled(&self, value: bool) -> HRESULT,
    fn get_IsAppControllerEnabled(&self, out: *mut bool) -> HRESULT
}}
impl IRadialControllerConfigurationStatics2 {
    #[inline] pub unsafe fn set_app_controller(&self, value: &RadialController) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AppController)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_app_controller(&self) -> Result<ComPtr<RadialController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AppController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_app_controller_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAppControllerEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_app_controller_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAppControllerEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerControlAcquiredEventArgs, 543859769, 58961, 4581, 191, 98, 44, 39, 215, 64, 78, 133);
RT_INTERFACE!{interface IRadialControllerControlAcquiredEventArgs(IRadialControllerControlAcquiredEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerControlAcquiredEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT
}}
impl IRadialControllerControlAcquiredEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerControlAcquiredEventArgs: IRadialControllerControlAcquiredEventArgs}
DEFINE_IID!(IID_IRadialControllerControlAcquiredEventArgs2, 1029144308, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerControlAcquiredEventArgs2(IRadialControllerControlAcquiredEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerControlAcquiredEventArgs2] {
    fn get_IsButtonPressed(&self, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerControlAcquiredEventArgs2 {
    #[inline] pub unsafe fn get_is_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerMenu, 2231808861, 63040, 17426, 171, 160, 186, 208, 119, 229, 234, 138);
RT_INTERFACE!{interface IRadialControllerMenu(IRadialControllerMenuVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerMenu] {
    fn get_Items(&self, out: *mut *mut super::super::foundation::collections::IVector<RadialControllerMenuItem>) -> HRESULT,
    fn get_IsEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsEnabled(&self, value: bool) -> HRESULT,
    fn GetSelectedMenuItem(&self, out: *mut *mut RadialControllerMenuItem) -> HRESULT,
    fn SelectMenuItem(&self, menuItem: *mut RadialControllerMenuItem) -> HRESULT,
    fn TrySelectPreviouslySelectedMenuItem(&self, out: *mut bool) -> HRESULT
}}
impl IRadialControllerMenu {
    #[inline] pub unsafe fn get_items(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<RadialControllerMenuItem>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Items)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_menu_item(&self) -> Result<ComPtr<RadialControllerMenuItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetSelectedMenuItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn select_menu_item(&self, menuItem: &RadialControllerMenuItem) -> Result<()> {
        let hr = ((*self.lpVtbl).SelectMenuItem)(self as *const _ as *mut _, menuItem as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_select_previously_selected_menu_item(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySelectPreviouslySelectedMenuItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerMenu: IRadialControllerMenu}
DEFINE_IID!(IID_IRadialControllerMenuItem, 3356477837, 44299, 19612, 143, 47, 19, 106, 35, 115, 166, 186);
RT_INTERFACE!{interface IRadialControllerMenuItem(IRadialControllerMenuItemVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerMenuItem] {
    fn get_DisplayText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Tag(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Tag(&self, value: *mut IInspectable) -> HRESULT,
    fn add_Invoked(&self, handler: *mut super::super::foundation::TypedEventHandler<RadialControllerMenuItem, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Invoked(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IRadialControllerMenuItem {
    #[inline] pub unsafe fn get_display_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tag(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tag(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Tag)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_invoked(&self, handler: &super::super::foundation::TypedEventHandler<RadialControllerMenuItem, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Invoked)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_invoked(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Invoked)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerMenuItem: IRadialControllerMenuItem}
impl RtActivatable<IRadialControllerMenuItemStatics> for RadialControllerMenuItem {}
impl RtActivatable<IRadialControllerMenuItemStatics2> for RadialControllerMenuItem {}
impl RadialControllerMenuItem {
    #[cfg(feature="windows-storage")] #[inline] pub fn create_from_icon(displayText: &HStringArg, icon: &super::super::storage::streams::RandomAccessStreamReference) -> Result<ComPtr<RadialControllerMenuItem>> { unsafe {
        <Self as RtActivatable<IRadialControllerMenuItemStatics>>::get_activation_factory().create_from_icon(displayText, icon)
    }}
    #[inline] pub fn create_from_known_icon(displayText: &HStringArg, value: RadialControllerMenuKnownIcon) -> Result<ComPtr<RadialControllerMenuItem>> { unsafe {
        <Self as RtActivatable<IRadialControllerMenuItemStatics>>::get_activation_factory().create_from_known_icon(displayText, value)
    }}
    #[inline] pub fn create_from_font_glyph(displayText: &HStringArg, glyph: &HStringArg, fontFamily: &HStringArg) -> Result<ComPtr<RadialControllerMenuItem>> { unsafe {
        <Self as RtActivatable<IRadialControllerMenuItemStatics2>>::get_activation_factory().create_from_font_glyph(displayText, glyph, fontFamily)
    }}
    #[inline] pub fn create_from_font_glyph_with_uri(displayText: &HStringArg, glyph: &HStringArg, fontFamily: &HStringArg, fontUri: &super::super::foundation::Uri) -> Result<ComPtr<RadialControllerMenuItem>> { unsafe {
        <Self as RtActivatable<IRadialControllerMenuItemStatics2>>::get_activation_factory().create_from_font_glyph_with_uri(displayText, glyph, fontFamily, fontUri)
    }}
}
DEFINE_CLSID!(RadialControllerMenuItem(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,82,97,100,105,97,108,67,111,110,116,114,111,108,108,101,114,77,101,110,117,73,116,101,109,0]) [CLSID_RadialControllerMenuItem]);
DEFINE_IID!(IID_IRadialControllerMenuItemStatics, 614336647, 55362, 17700, 157, 248, 224, 214, 71, 237, 200, 135);
RT_INTERFACE!{static interface IRadialControllerMenuItemStatics(IRadialControllerMenuItemStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerMenuItemStatics] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn CreateFromIcon(&self, displayText: HSTRING, icon: *mut super::super::storage::streams::RandomAccessStreamReference, out: *mut *mut RadialControllerMenuItem) -> HRESULT,
    fn CreateFromKnownIcon(&self, displayText: HSTRING, value: RadialControllerMenuKnownIcon, out: *mut *mut RadialControllerMenuItem) -> HRESULT
}}
impl IRadialControllerMenuItemStatics {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn create_from_icon(&self, displayText: &HStringArg, icon: &super::super::storage::streams::RandomAccessStreamReference) -> Result<ComPtr<RadialControllerMenuItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromIcon)(self as *const _ as *mut _, displayText.get(), icon as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_known_icon(&self, displayText: &HStringArg, value: RadialControllerMenuKnownIcon) -> Result<ComPtr<RadialControllerMenuItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromKnownIcon)(self as *const _ as *mut _, displayText.get(), value, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerMenuItemStatics2, 213610686, 32318, 18621, 190, 4, 44, 127, 202, 169, 193, 255);
RT_INTERFACE!{static interface IRadialControllerMenuItemStatics2(IRadialControllerMenuItemStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerMenuItemStatics2] {
    fn CreateFromFontGlyph(&self, displayText: HSTRING, glyph: HSTRING, fontFamily: HSTRING, out: *mut *mut RadialControllerMenuItem) -> HRESULT,
    fn CreateFromFontGlyphWithUri(&self, displayText: HSTRING, glyph: HSTRING, fontFamily: HSTRING, fontUri: *mut super::super::foundation::Uri, out: *mut *mut RadialControllerMenuItem) -> HRESULT
}}
impl IRadialControllerMenuItemStatics2 {
    #[inline] pub unsafe fn create_from_font_glyph(&self, displayText: &HStringArg, glyph: &HStringArg, fontFamily: &HStringArg) -> Result<ComPtr<RadialControllerMenuItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromFontGlyph)(self as *const _ as *mut _, displayText.get(), glyph.get(), fontFamily.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_from_font_glyph_with_uri(&self, displayText: &HStringArg, glyph: &HStringArg, fontFamily: &HStringArg, fontUri: &super::super::foundation::Uri) -> Result<ComPtr<RadialControllerMenuItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateFromFontGlyphWithUri)(self as *const _ as *mut _, displayText.get(), glyph.get(), fontFamily.get(), fontUri as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum RadialControllerMenuKnownIcon: i32 {
    Scroll (RadialControllerMenuKnownIcon_Scroll) = 0, Zoom (RadialControllerMenuKnownIcon_Zoom) = 1, UndoRedo (RadialControllerMenuKnownIcon_UndoRedo) = 2, Volume (RadialControllerMenuKnownIcon_Volume) = 3, NextPreviousTrack (RadialControllerMenuKnownIcon_NextPreviousTrack) = 4, Ruler (RadialControllerMenuKnownIcon_Ruler) = 5, InkColor (RadialControllerMenuKnownIcon_InkColor) = 6, InkThickness (RadialControllerMenuKnownIcon_InkThickness) = 7, PenType (RadialControllerMenuKnownIcon_PenType) = 8,
}}
DEFINE_IID!(IID_IRadialControllerRotationChangedEventArgs, 543859765, 58961, 4581, 191, 98, 44, 39, 215, 64, 78, 133);
RT_INTERFACE!{interface IRadialControllerRotationChangedEventArgs(IRadialControllerRotationChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerRotationChangedEventArgs] {
    fn get_RotationDeltaInDegrees(&self, out: *mut f64) -> HRESULT,
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT
}}
impl IRadialControllerRotationChangedEventArgs {
    #[inline] pub unsafe fn get_rotation_delta_in_degrees(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RotationDeltaInDegrees)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerRotationChangedEventArgs: IRadialControllerRotationChangedEventArgs}
DEFINE_IID!(IID_IRadialControllerRotationChangedEventArgs2, 1029144300, 19694, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerRotationChangedEventArgs2(IRadialControllerRotationChangedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerRotationChangedEventArgs2] {
    fn get_IsButtonPressed(&self, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerRotationChangedEventArgs2 {
    #[inline] pub unsafe fn get_is_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerScreenContact, 543859764, 58961, 4581, 191, 98, 44, 39, 215, 64, 78, 133);
RT_INTERFACE!{interface IRadialControllerScreenContact(IRadialControllerScreenContactVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerScreenContact] {
    fn get_Bounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT
}}
impl IRadialControllerScreenContact {
    #[inline] pub unsafe fn get_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerScreenContact: IRadialControllerScreenContact}
DEFINE_IID!(IID_IRadialControllerScreenContactContinuedEventArgs, 543859767, 58961, 4581, 191, 98, 44, 39, 215, 64, 78, 133);
RT_INTERFACE!{interface IRadialControllerScreenContactContinuedEventArgs(IRadialControllerScreenContactContinuedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerScreenContactContinuedEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT
}}
impl IRadialControllerScreenContactContinuedEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerScreenContactContinuedEventArgs: IRadialControllerScreenContactContinuedEventArgs}
DEFINE_IID!(IID_IRadialControllerScreenContactContinuedEventArgs2, 1029144305, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerScreenContactContinuedEventArgs2(IRadialControllerScreenContactContinuedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerScreenContactContinuedEventArgs2] {
    fn get_IsButtonPressed(&self, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerScreenContactContinuedEventArgs2 {
    #[inline] pub unsafe fn get_is_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerScreenContactEndedEventArgs, 1029144306, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerScreenContactEndedEventArgs(IRadialControllerScreenContactEndedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerScreenContactEndedEventArgs] {
    fn get_IsButtonPressed(&self, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerScreenContactEndedEventArgs {
    #[inline] pub unsafe fn get_is_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerScreenContactEndedEventArgs: IRadialControllerScreenContactEndedEventArgs}
DEFINE_IID!(IID_IRadialControllerScreenContactStartedEventArgs, 543859766, 58961, 4581, 191, 98, 44, 39, 215, 64, 78, 133);
RT_INTERFACE!{interface IRadialControllerScreenContactStartedEventArgs(IRadialControllerScreenContactStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerScreenContactStartedEventArgs] {
    fn get_Contact(&self, out: *mut *mut RadialControllerScreenContact) -> HRESULT
}}
impl IRadialControllerScreenContactStartedEventArgs {
    #[inline] pub unsafe fn get_contact(&self) -> Result<ComPtr<RadialControllerScreenContact>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerScreenContactStartedEventArgs: IRadialControllerScreenContactStartedEventArgs}
DEFINE_IID!(IID_IRadialControllerScreenContactStartedEventArgs2, 1029144304, 15598, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerScreenContactStartedEventArgs2(IRadialControllerScreenContactStartedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerScreenContactStartedEventArgs2] {
    fn get_IsButtonPressed(&self, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut super::super::devices::haptics::SimpleHapticsController) -> HRESULT
}}
impl IRadialControllerScreenContactStartedEventArgs2 {
    #[inline] pub unsafe fn get_is_button_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsButtonPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<super::super::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRadialControllerStatics, 4208906423, 47180, 18580, 135, 170, 143, 37, 170, 95, 40, 139);
RT_INTERFACE!{static interface IRadialControllerStatics(IRadialControllerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerStatics] {
    fn IsSupported(&self, out: *mut bool) -> HRESULT,
    fn CreateForCurrentView(&self, out: *mut *mut RadialController) -> HRESULT
}}
impl IRadialControllerStatics {
    #[inline] pub unsafe fn is_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_for_current_view(&self) -> Result<ComPtr<RadialController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum RadialControllerSystemMenuItemKind: i32 {
    Scroll (RadialControllerSystemMenuItemKind_Scroll) = 0, Zoom (RadialControllerSystemMenuItemKind_Zoom) = 1, UndoRedo (RadialControllerSystemMenuItemKind_UndoRedo) = 2, Volume (RadialControllerSystemMenuItemKind_Volume) = 3, NextPreviousTrack (RadialControllerSystemMenuItemKind_NextPreviousTrack) = 4,
}}
DEFINE_IID!(IID_IRightTappedEventArgs, 1287602365, 44922, 18998, 148, 118, 177, 220, 225, 65, 112, 154);
RT_INTERFACE!{interface IRightTappedEventArgs(IRightTappedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRightTappedEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT
}}
impl IRightTappedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class RightTappedEventArgs: IRightTappedEventArgs}
DEFINE_IID!(IID_ITappedEventArgs, 3483444964, 9530, 19516, 149, 59, 57, 92, 55, 174, 211, 9);
RT_INTERFACE!{interface ITappedEventArgs(ITappedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ITappedEventArgs] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_PointerDeviceType(&self, out: *mut super::super::devices::input::PointerDeviceType) -> HRESULT,
    fn get_Position(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn get_TapCount(&self, out: *mut u32) -> HRESULT
}}
impl ITappedEventArgs {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_pointer_device_type(&self) -> Result<super::super::devices::input::PointerDeviceType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerDeviceType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tap_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TapCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class TappedEventArgs: ITappedEventArgs}
pub mod preview { // Windows.UI.Input.Preview
pub mod injection { // Windows.UI.Input.Preview.Injection
use ::prelude::*;
RT_ENUM! { enum InjectedInputButtonChangeKind: i32 {
    None (InjectedInputButtonChangeKind_None) = 0, FirstButtonDown (InjectedInputButtonChangeKind_FirstButtonDown) = 1, FirstButtonUp (InjectedInputButtonChangeKind_FirstButtonUp) = 2, SecondButtonDown (InjectedInputButtonChangeKind_SecondButtonDown) = 3, SecondButtonUp (InjectedInputButtonChangeKind_SecondButtonUp) = 4, ThirdButtonDown (InjectedInputButtonChangeKind_ThirdButtonDown) = 5, ThirdButtonUp (InjectedInputButtonChangeKind_ThirdButtonUp) = 6, FourthButtonDown (InjectedInputButtonChangeKind_FourthButtonDown) = 7, FourthButtonUp (InjectedInputButtonChangeKind_FourthButtonUp) = 8, FifthButtonDown (InjectedInputButtonChangeKind_FifthButtonDown) = 9, FifthButtonUp (InjectedInputButtonChangeKind_FifthButtonUp) = 10,
}}
DEFINE_IID!(IID_IInjectedInputGamepadInfo, 548313663, 57105, 17778, 169, 171, 215, 91, 138, 94, 72, 173);
RT_INTERFACE!{interface IInjectedInputGamepadInfo(IInjectedInputGamepadInfoVtbl): IInspectable(IInspectableVtbl) [IID_IInjectedInputGamepadInfo] {
    #[cfg(not(feature="windows-gaming"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-gaming")] fn get_Buttons(&self, out: *mut ::rt::gen::windows::gaming::input::GamepadButtons) -> HRESULT,
    #[cfg(not(feature="windows-gaming"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-gaming")] fn put_Buttons(&self, value: ::rt::gen::windows::gaming::input::GamepadButtons) -> HRESULT,
    fn get_LeftThumbstickX(&self, out: *mut f64) -> HRESULT,
    fn put_LeftThumbstickX(&self, value: f64) -> HRESULT,
    fn get_LeftThumbstickY(&self, out: *mut f64) -> HRESULT,
    fn put_LeftThumbstickY(&self, value: f64) -> HRESULT,
    fn get_LeftTrigger(&self, out: *mut f64) -> HRESULT,
    fn put_LeftTrigger(&self, value: f64) -> HRESULT,
    fn get_RightThumbstickX(&self, out: *mut f64) -> HRESULT,
    fn put_RightThumbstickX(&self, value: f64) -> HRESULT,
    fn get_RightThumbstickY(&self, out: *mut f64) -> HRESULT,
    fn put_RightThumbstickY(&self, value: f64) -> HRESULT,
    fn get_RightTrigger(&self, out: *mut f64) -> HRESULT,
    fn put_RightTrigger(&self, value: f64) -> HRESULT
}}
impl IInjectedInputGamepadInfo {
    #[cfg(feature="windows-gaming")] #[inline] pub unsafe fn get_buttons(&self) -> Result<::rt::gen::windows::gaming::input::GamepadButtons> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Buttons)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-gaming")] #[inline] pub unsafe fn set_buttons(&self, value: ::rt::gen::windows::gaming::input::GamepadButtons) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Buttons)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left_thumbstick_x(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LeftThumbstickX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_left_thumbstick_x(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LeftThumbstickX)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left_thumbstick_y(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LeftThumbstickY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_left_thumbstick_y(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LeftThumbstickY)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left_trigger(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LeftTrigger)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_left_trigger(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LeftTrigger)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_thumbstick_x(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightThumbstickX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_thumbstick_x(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightThumbstickX)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_thumbstick_y(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightThumbstickY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_thumbstick_y(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightThumbstickY)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_trigger(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightTrigger)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_trigger(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightTrigger)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InjectedInputGamepadInfo: IInjectedInputGamepadInfo}
impl RtActivatable<IInjectedInputGamepadInfoFactory> for InjectedInputGamepadInfo {}
impl RtActivatable<IActivationFactory> for InjectedInputGamepadInfo {}
impl InjectedInputGamepadInfo {
    #[cfg(feature="windows-gaming")] #[inline] pub fn create_instance_from_gamepad_reading(reading: ::rt::gen::windows::gaming::input::GamepadReading) -> Result<ComPtr<InjectedInputGamepadInfo>> { unsafe {
        <Self as RtActivatable<IInjectedInputGamepadInfoFactory>>::get_activation_factory().create_instance_from_gamepad_reading(reading)
    }}
}
DEFINE_CLSID!(InjectedInputGamepadInfo(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,114,101,118,105,101,119,46,73,110,106,101,99,116,105,111,110,46,73,110,106,101,99,116,101,100,73,110,112,117,116,71,97,109,101,112,97,100,73,110,102,111,0]) [CLSID_InjectedInputGamepadInfo]);
DEFINE_IID!(IID_IInjectedInputGamepadInfoFactory, 1499031670, 27705, 20164, 139, 42, 41, 239, 125, 225, 138, 202);
RT_INTERFACE!{static interface IInjectedInputGamepadInfoFactory(IInjectedInputGamepadInfoFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IInjectedInputGamepadInfoFactory] {
    #[cfg(feature="windows-gaming")] fn CreateInstanceFromGamepadReading(&self, reading: ::rt::gen::windows::gaming::input::GamepadReading, out: *mut *mut InjectedInputGamepadInfo) -> HRESULT
}}
impl IInjectedInputGamepadInfoFactory {
    #[cfg(feature="windows-gaming")] #[inline] pub unsafe fn create_instance_from_gamepad_reading(&self, reading: ::rt::gen::windows::gaming::input::GamepadReading) -> Result<ComPtr<InjectedInputGamepadInfo>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstanceFromGamepadReading)(self as *const _ as *mut _, reading, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInjectedInputKeyboardInfo, 1262932288, 11114, 24570, 126, 174, 189, 7, 123, 5, 42, 205);
RT_INTERFACE!{interface IInjectedInputKeyboardInfo(IInjectedInputKeyboardInfoVtbl): IInspectable(IInspectableVtbl) [IID_IInjectedInputKeyboardInfo] {
    fn get_KeyOptions(&self, out: *mut InjectedInputKeyOptions) -> HRESULT,
    fn put_KeyOptions(&self, value: InjectedInputKeyOptions) -> HRESULT,
    fn get_ScanCode(&self, out: *mut u16) -> HRESULT,
    fn put_ScanCode(&self, value: u16) -> HRESULT,
    fn get_VirtualKey(&self, out: *mut u16) -> HRESULT,
    fn put_VirtualKey(&self, value: u16) -> HRESULT
}}
impl IInjectedInputKeyboardInfo {
    #[inline] pub unsafe fn get_key_options(&self) -> Result<InjectedInputKeyOptions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyOptions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_key_options(&self, value: InjectedInputKeyOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeyOptions)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scan_code(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScanCode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_scan_code(&self, value: u16) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ScanCode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_virtual_key(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VirtualKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_virtual_key(&self, value: u16) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VirtualKey)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InjectedInputKeyboardInfo: IInjectedInputKeyboardInfo}
impl RtActivatable<IActivationFactory> for InjectedInputKeyboardInfo {}
DEFINE_CLSID!(InjectedInputKeyboardInfo(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,114,101,118,105,101,119,46,73,110,106,101,99,116,105,111,110,46,73,110,106,101,99,116,101,100,73,110,112,117,116,75,101,121,98,111,97,114,100,73,110,102,111,0]) [CLSID_InjectedInputKeyboardInfo]);
RT_ENUM! { enum InjectedInputKeyOptions: u32 {
    None (InjectedInputKeyOptions_None) = 0, ExtendedKey (InjectedInputKeyOptions_ExtendedKey) = 1, KeyUp (InjectedInputKeyOptions_KeyUp) = 2, ScanCode (InjectedInputKeyOptions_ScanCode) = 8, Unicode (InjectedInputKeyOptions_Unicode) = 4,
}}
DEFINE_IID!(IID_IInjectedInputMouseInfo, 2532666987, 58490, 23796, 65, 141, 138, 95, 185, 103, 12, 125);
RT_INTERFACE!{interface IInjectedInputMouseInfo(IInjectedInputMouseInfoVtbl): IInspectable(IInspectableVtbl) [IID_IInjectedInputMouseInfo] {
    fn get_MouseOptions(&self, out: *mut InjectedInputMouseOptions) -> HRESULT,
    fn put_MouseOptions(&self, value: InjectedInputMouseOptions) -> HRESULT,
    fn get_MouseData(&self, out: *mut u32) -> HRESULT,
    fn put_MouseData(&self, value: u32) -> HRESULT,
    fn get_DeltaY(&self, out: *mut i32) -> HRESULT,
    fn put_DeltaY(&self, value: i32) -> HRESULT,
    fn get_DeltaX(&self, out: *mut i32) -> HRESULT,
    fn put_DeltaX(&self, value: i32) -> HRESULT,
    fn get_TimeOffsetInMilliseconds(&self, out: *mut u32) -> HRESULT,
    fn put_TimeOffsetInMilliseconds(&self, value: u32) -> HRESULT
}}
impl IInjectedInputMouseInfo {
    #[inline] pub unsafe fn get_mouse_options(&self) -> Result<InjectedInputMouseOptions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MouseOptions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mouse_options(&self, value: InjectedInputMouseOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MouseOptions)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mouse_data(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MouseData)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mouse_data(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MouseData)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delta_y(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeltaY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_delta_y(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DeltaY)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delta_x(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeltaX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_delta_x(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DeltaX)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_time_offset_in_milliseconds(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TimeOffsetInMilliseconds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_time_offset_in_milliseconds(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TimeOffsetInMilliseconds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InjectedInputMouseInfo: IInjectedInputMouseInfo}
impl RtActivatable<IActivationFactory> for InjectedInputMouseInfo {}
DEFINE_CLSID!(InjectedInputMouseInfo(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,114,101,118,105,101,119,46,73,110,106,101,99,116,105,111,110,46,73,110,106,101,99,116,101,100,73,110,112,117,116,77,111,117,115,101,73,110,102,111,0]) [CLSID_InjectedInputMouseInfo]);
RT_ENUM! { enum InjectedInputMouseOptions: u32 {
    None (InjectedInputMouseOptions_None) = 0, Move (InjectedInputMouseOptions_Move) = 1, LeftDown (InjectedInputMouseOptions_LeftDown) = 2, LeftUp (InjectedInputMouseOptions_LeftUp) = 4, RightDown (InjectedInputMouseOptions_RightDown) = 8, RightUp (InjectedInputMouseOptions_RightUp) = 16, MiddleDown (InjectedInputMouseOptions_MiddleDown) = 32, MiddleUp (InjectedInputMouseOptions_MiddleUp) = 64, XDown (InjectedInputMouseOptions_XDown) = 128, XUp (InjectedInputMouseOptions_XUp) = 256, Wheel (InjectedInputMouseOptions_Wheel) = 2048, HWheel (InjectedInputMouseOptions_HWheel) = 4096, MoveNoCoalesce (InjectedInputMouseOptions_MoveNoCoalesce) = 8192, VirtualDesk (InjectedInputMouseOptions_VirtualDesk) = 16384, Absolute (InjectedInputMouseOptions_Absolute) = 32768,
}}
RT_ENUM! { enum InjectedInputPenButtons: u32 {
    None (InjectedInputPenButtons_None) = 0, Barrel (InjectedInputPenButtons_Barrel) = 1, Inverted (InjectedInputPenButtons_Inverted) = 2, Eraser (InjectedInputPenButtons_Eraser) = 4,
}}
DEFINE_IID!(IID_IInjectedInputPenInfo, 1799400707, 51742, 21799, 126, 2, 40, 40, 84, 11, 177, 212);
RT_INTERFACE!{interface IInjectedInputPenInfo(IInjectedInputPenInfoVtbl): IInspectable(IInspectableVtbl) [IID_IInjectedInputPenInfo] {
    fn get_PointerInfo(&self, out: *mut InjectedInputPointerInfo) -> HRESULT,
    fn put_PointerInfo(&self, value: InjectedInputPointerInfo) -> HRESULT,
    fn get_PenButtons(&self, out: *mut InjectedInputPenButtons) -> HRESULT,
    fn put_PenButtons(&self, value: InjectedInputPenButtons) -> HRESULT,
    fn get_PenParameters(&self, out: *mut InjectedInputPenParameters) -> HRESULT,
    fn put_PenParameters(&self, value: InjectedInputPenParameters) -> HRESULT,
    fn get_Pressure(&self, out: *mut f64) -> HRESULT,
    fn put_Pressure(&self, value: f64) -> HRESULT,
    fn get_Rotation(&self, out: *mut f64) -> HRESULT,
    fn put_Rotation(&self, value: f64) -> HRESULT,
    fn get_TiltX(&self, out: *mut i32) -> HRESULT,
    fn put_TiltX(&self, value: i32) -> HRESULT,
    fn get_TiltY(&self, out: *mut i32) -> HRESULT,
    fn put_TiltY(&self, value: i32) -> HRESULT
}}
impl IInjectedInputPenInfo {
    #[inline] pub unsafe fn get_pointer_info(&self) -> Result<InjectedInputPointerInfo> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pointer_info(&self, value: InjectedInputPointerInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PointerInfo)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pen_buttons(&self) -> Result<InjectedInputPenButtons> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PenButtons)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pen_buttons(&self, value: InjectedInputPenButtons) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PenButtons)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pen_parameters(&self) -> Result<InjectedInputPenParameters> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PenParameters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pen_parameters(&self, value: InjectedInputPenParameters) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PenParameters)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressure(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Pressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pressure(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Pressure)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rotation(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Rotation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_rotation(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Rotation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tilt_x(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TiltX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tilt_x(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TiltX)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tilt_y(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TiltY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tilt_y(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TiltY)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InjectedInputPenInfo: IInjectedInputPenInfo}
impl RtActivatable<IActivationFactory> for InjectedInputPenInfo {}
DEFINE_CLSID!(InjectedInputPenInfo(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,114,101,118,105,101,119,46,73,110,106,101,99,116,105,111,110,46,73,110,106,101,99,116,101,100,73,110,112,117,116,80,101,110,73,110,102,111,0]) [CLSID_InjectedInputPenInfo]);
RT_ENUM! { enum InjectedInputPenParameters: u32 {
    None (InjectedInputPenParameters_None) = 0, Pressure (InjectedInputPenParameters_Pressure) = 1, Rotation (InjectedInputPenParameters_Rotation) = 2, TiltX (InjectedInputPenParameters_TiltX) = 4, TiltY (InjectedInputPenParameters_TiltY) = 8,
}}
RT_STRUCT! { struct InjectedInputPoint {
    PositionX: i32, PositionY: i32,
}}
RT_STRUCT! { struct InjectedInputPointerInfo {
    PointerId: u32, PointerOptions: InjectedInputPointerOptions, PixelLocation: InjectedInputPoint, TimeOffsetInMilliseconds: u32, PerformanceCount: u64,
}}
RT_ENUM! { enum InjectedInputPointerOptions: u32 {
    None (InjectedInputPointerOptions_None) = 0, New (InjectedInputPointerOptions_New) = 1, InRange (InjectedInputPointerOptions_InRange) = 2, InContact (InjectedInputPointerOptions_InContact) = 4, FirstButton (InjectedInputPointerOptions_FirstButton) = 16, SecondButton (InjectedInputPointerOptions_SecondButton) = 32, Primary (InjectedInputPointerOptions_Primary) = 8192, Confidence (InjectedInputPointerOptions_Confidence) = 16384, Canceled (InjectedInputPointerOptions_Canceled) = 32768, PointerDown (InjectedInputPointerOptions_PointerDown) = 65536, Update (InjectedInputPointerOptions_Update) = 131072, PointerUp (InjectedInputPointerOptions_PointerUp) = 262144, CaptureChanged (InjectedInputPointerOptions_CaptureChanged) = 2097152,
}}
RT_STRUCT! { struct InjectedInputRectangle {
    Left: i32, Top: i32, Bottom: i32, Right: i32,
}}
RT_ENUM! { enum InjectedInputShortcut: i32 {
    Back (InjectedInputShortcut_Back) = 0, Start (InjectedInputShortcut_Start) = 1, Search (InjectedInputShortcut_Search) = 2,
}}
DEFINE_IID!(IID_IInjectedInputTouchInfo, 575656415, 17384, 24309, 81, 10, 105, 202, 140, 155, 76, 40);
RT_INTERFACE!{interface IInjectedInputTouchInfo(IInjectedInputTouchInfoVtbl): IInspectable(IInspectableVtbl) [IID_IInjectedInputTouchInfo] {
    fn get_Contact(&self, out: *mut InjectedInputRectangle) -> HRESULT,
    fn put_Contact(&self, value: InjectedInputRectangle) -> HRESULT,
    fn get_Orientation(&self, out: *mut i32) -> HRESULT,
    fn put_Orientation(&self, value: i32) -> HRESULT,
    fn get_PointerInfo(&self, out: *mut InjectedInputPointerInfo) -> HRESULT,
    fn put_PointerInfo(&self, value: InjectedInputPointerInfo) -> HRESULT,
    fn get_Pressure(&self, out: *mut f64) -> HRESULT,
    fn put_Pressure(&self, value: f64) -> HRESULT,
    fn get_TouchParameters(&self, out: *mut InjectedInputTouchParameters) -> HRESULT,
    fn put_TouchParameters(&self, value: InjectedInputTouchParameters) -> HRESULT
}}
impl IInjectedInputTouchInfo {
    #[inline] pub unsafe fn get_contact(&self) -> Result<InjectedInputRectangle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Contact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_contact(&self, value: InjectedInputRectangle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Contact)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_orientation(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Orientation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_info(&self) -> Result<InjectedInputPointerInfo> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerInfo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pointer_info(&self, value: InjectedInputPointerInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PointerInfo)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressure(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Pressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pressure(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Pressure)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_touch_parameters(&self) -> Result<InjectedInputTouchParameters> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TouchParameters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_touch_parameters(&self, value: InjectedInputTouchParameters) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TouchParameters)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InjectedInputTouchInfo: IInjectedInputTouchInfo}
impl RtActivatable<IActivationFactory> for InjectedInputTouchInfo {}
DEFINE_CLSID!(InjectedInputTouchInfo(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,114,101,118,105,101,119,46,73,110,106,101,99,116,105,111,110,46,73,110,106,101,99,116,101,100,73,110,112,117,116,84,111,117,99,104,73,110,102,111,0]) [CLSID_InjectedInputTouchInfo]);
RT_ENUM! { enum InjectedInputTouchParameters: u32 {
    None (InjectedInputTouchParameters_None) = 0, Contact (InjectedInputTouchParameters_Contact) = 1, Orientation (InjectedInputTouchParameters_Orientation) = 2, Pressure (InjectedInputTouchParameters_Pressure) = 4,
}}
RT_ENUM! { enum InjectedInputVisualizationMode: i32 {
    None (InjectedInputVisualizationMode_None) = 0, Default (InjectedInputVisualizationMode_Default) = 1, Indirect (InjectedInputVisualizationMode_Indirect) = 2,
}}
DEFINE_IID!(IID_IInputInjector, 2395107204, 2818, 19410, 173, 122, 61, 70, 88, 190, 62, 24);
RT_INTERFACE!{interface IInputInjector(IInputInjectorVtbl): IInspectable(IInspectableVtbl) [IID_IInputInjector] {
    fn InjectKeyboardInput(&self, input: *mut ::rt::gen::windows::foundation::collections::IIterable<InjectedInputKeyboardInfo>) -> HRESULT,
    fn InjectMouseInput(&self, input: *mut ::rt::gen::windows::foundation::collections::IIterable<InjectedInputMouseInfo>) -> HRESULT,
    fn InitializeTouchInjection(&self, visualMode: InjectedInputVisualizationMode) -> HRESULT,
    fn InjectTouchInput(&self, input: *mut ::rt::gen::windows::foundation::collections::IIterable<InjectedInputTouchInfo>) -> HRESULT,
    fn UninitializeTouchInjection(&self) -> HRESULT,
    fn InitializePenInjection(&self, visualMode: InjectedInputVisualizationMode) -> HRESULT,
    fn InjectPenInput(&self, input: *mut InjectedInputPenInfo) -> HRESULT,
    fn UninitializePenInjection(&self) -> HRESULT,
    fn InjectShortcut(&self, shortcut: InjectedInputShortcut) -> HRESULT
}}
impl IInputInjector {
    #[inline] pub unsafe fn inject_keyboard_input(&self, input: &::rt::gen::windows::foundation::collections::IIterable<InjectedInputKeyboardInfo>) -> Result<()> {
        let hr = ((*self.lpVtbl).InjectKeyboardInput)(self as *const _ as *mut _, input as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn inject_mouse_input(&self, input: &::rt::gen::windows::foundation::collections::IIterable<InjectedInputMouseInfo>) -> Result<()> {
        let hr = ((*self.lpVtbl).InjectMouseInput)(self as *const _ as *mut _, input as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn initialize_touch_injection(&self, visualMode: InjectedInputVisualizationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).InitializeTouchInjection)(self as *const _ as *mut _, visualMode);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn inject_touch_input(&self, input: &::rt::gen::windows::foundation::collections::IIterable<InjectedInputTouchInfo>) -> Result<()> {
        let hr = ((*self.lpVtbl).InjectTouchInput)(self as *const _ as *mut _, input as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn uninitialize_touch_injection(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).UninitializeTouchInjection)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn initialize_pen_injection(&self, visualMode: InjectedInputVisualizationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).InitializePenInjection)(self as *const _ as *mut _, visualMode);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn inject_pen_input(&self, input: &InjectedInputPenInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).InjectPenInput)(self as *const _ as *mut _, input as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn uninitialize_pen_injection(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).UninitializePenInjection)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn inject_shortcut(&self, shortcut: InjectedInputShortcut) -> Result<()> {
        let hr = ((*self.lpVtbl).InjectShortcut)(self as *const _ as *mut _, shortcut);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InputInjector: IInputInjector}
impl RtActivatable<IInputInjectorStatics> for InputInjector {}
impl RtActivatable<IInputInjectorStatics2> for InputInjector {}
impl InputInjector {
    #[inline] pub fn try_create() -> Result<ComPtr<InputInjector>> { unsafe {
        <Self as RtActivatable<IInputInjectorStatics>>::get_activation_factory().try_create()
    }}
    #[inline] pub fn try_create_for_app_broadcast_only() -> Result<ComPtr<InputInjector>> { unsafe {
        <Self as RtActivatable<IInputInjectorStatics2>>::get_activation_factory().try_create_for_app_broadcast_only()
    }}
}
DEFINE_CLSID!(InputInjector(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,80,114,101,118,105,101,119,46,73,110,106,101,99,116,105,111,110,46,73,110,112,117,116,73,110,106,101,99,116,111,114,0]) [CLSID_InputInjector]);
DEFINE_IID!(IID_IInputInjector2, 2390397021, 5203, 17319, 155, 203, 6, 214, 215, 179, 5, 247);
RT_INTERFACE!{interface IInputInjector2(IInputInjector2Vtbl): IInspectable(IInspectableVtbl) [IID_IInputInjector2] {
    fn InitializeGamepadInjection(&self) -> HRESULT,
    fn InjectGamepadInput(&self, input: *mut InjectedInputGamepadInfo) -> HRESULT,
    fn UninitializeGamepadInjection(&self) -> HRESULT
}}
impl IInputInjector2 {
    #[inline] pub unsafe fn initialize_gamepad_injection(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).InitializeGamepadInjection)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn inject_gamepad_input(&self, input: &InjectedInputGamepadInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).InjectGamepadInput)(self as *const _ as *mut _, input as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn uninitialize_gamepad_injection(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).UninitializeGamepadInjection)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInputInjectorStatics, 3735972163, 29698, 16705, 165, 198, 12, 1, 170, 87, 177, 106);
RT_INTERFACE!{static interface IInputInjectorStatics(IInputInjectorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IInputInjectorStatics] {
    fn TryCreate(&self, out: *mut *mut InputInjector) -> HRESULT
}}
impl IInputInjectorStatics {
    #[inline] pub unsafe fn try_create(&self) -> Result<ComPtr<InputInjector>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCreate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInputInjectorStatics2, 2765830395, 56716, 16719, 149, 234, 248, 126, 244, 192, 174, 108);
RT_INTERFACE!{static interface IInputInjectorStatics2(IInputInjectorStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IInputInjectorStatics2] {
    fn TryCreateForAppBroadcastOnly(&self, out: *mut *mut InputInjector) -> HRESULT
}}
impl IInputInjectorStatics2 {
    #[inline] pub unsafe fn try_create_for_app_broadcast_only(&self) -> Result<ComPtr<InputInjector>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryCreateForAppBroadcastOnly)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.Input.Preview.Injection
} // Windows.UI.Input.Preview
pub mod spatial { // Windows.UI.Input.Spatial
use ::prelude::*;
DEFINE_IID!(IID_ISpatialGestureRecognizer, 1902140364, 3125, 18035, 173, 189, 204, 4, 202, 166, 239, 69);
RT_INTERFACE!{interface ISpatialGestureRecognizer(ISpatialGestureRecognizerVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialGestureRecognizer] {
    fn add_RecognitionStarted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialRecognitionStartedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RecognitionStarted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RecognitionEnded(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialRecognitionEndedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RecognitionEnded(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Tapped(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialTappedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Tapped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_HoldStarted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialHoldStartedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HoldStarted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_HoldCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialHoldCompletedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HoldCompleted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_HoldCanceled(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialHoldCanceledEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HoldCanceled(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationStarted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationStartedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationStarted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationUpdated(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationUpdatedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationUpdated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationCompletedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationCompleted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationCanceled(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationCanceledEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationCanceled(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NavigationStarted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationStartedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NavigationStarted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NavigationUpdated(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationUpdatedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NavigationUpdated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NavigationCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationCompletedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NavigationCompleted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NavigationCanceled(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationCanceledEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NavigationCanceled(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn CaptureInteraction(&self, interaction: *mut SpatialInteraction) -> HRESULT,
    fn CancelPendingGestures(&self) -> HRESULT,
    fn TrySetGestureSettings(&self, settings: SpatialGestureSettings, out: *mut bool) -> HRESULT,
    fn get_GestureSettings(&self, out: *mut SpatialGestureSettings) -> HRESULT
}}
impl ISpatialGestureRecognizer {
    #[inline] pub unsafe fn add_recognition_started(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialRecognitionStartedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RecognitionStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_recognition_started(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RecognitionStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_recognition_ended(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialRecognitionEndedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RecognitionEnded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_recognition_ended(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RecognitionEnded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_tapped(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialTappedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Tapped)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_tapped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Tapped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hold_started(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialHoldStartedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HoldStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hold_started(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HoldStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hold_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialHoldCompletedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HoldCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hold_completed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HoldCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hold_canceled(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialHoldCanceledEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HoldCanceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hold_canceled(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HoldCanceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_started(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationStartedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_started(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_updated(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationUpdatedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationUpdated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_updated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationUpdated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationCompletedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_completed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_canceled(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialManipulationCanceledEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationCanceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_canceled(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationCanceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigation_started(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationStartedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NavigationStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigation_started(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NavigationStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigation_updated(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationUpdatedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NavigationUpdated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigation_updated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NavigationUpdated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigation_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationCompletedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NavigationCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigation_completed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NavigationCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigation_canceled(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialGestureRecognizer, SpatialNavigationCanceledEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NavigationCanceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigation_canceled(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NavigationCanceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn capture_interaction(&self, interaction: &SpatialInteraction) -> Result<()> {
        let hr = ((*self.lpVtbl).CaptureInteraction)(self as *const _ as *mut _, interaction as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn cancel_pending_gestures(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).CancelPendingGestures)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_gesture_settings(&self, settings: SpatialGestureSettings) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetGestureSettings)(self as *const _ as *mut _, settings, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gesture_settings(&self) -> Result<SpatialGestureSettings> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GestureSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialGestureRecognizer: ISpatialGestureRecognizer}
impl RtActivatable<ISpatialGestureRecognizerFactory> for SpatialGestureRecognizer {}
impl SpatialGestureRecognizer {
    #[inline] pub fn create(settings: SpatialGestureSettings) -> Result<ComPtr<SpatialGestureRecognizer>> { unsafe {
        <Self as RtActivatable<ISpatialGestureRecognizerFactory>>::get_activation_factory().create(settings)
    }}
}
DEFINE_CLSID!(SpatialGestureRecognizer(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,83,112,97,116,105,97,108,46,83,112,97,116,105,97,108,71,101,115,116,117,114,101,82,101,99,111,103,110,105,122,101,114,0]) [CLSID_SpatialGestureRecognizer]);
DEFINE_IID!(IID_ISpatialGestureRecognizerFactory, 1998668166, 22457, 12624, 131, 130, 105, 139, 36, 226, 100, 208);
RT_INTERFACE!{static interface ISpatialGestureRecognizerFactory(ISpatialGestureRecognizerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialGestureRecognizerFactory] {
    fn Create(&self, settings: SpatialGestureSettings, out: *mut *mut SpatialGestureRecognizer) -> HRESULT
}}
impl ISpatialGestureRecognizerFactory {
    #[inline] pub unsafe fn create(&self, settings: SpatialGestureSettings) -> Result<ComPtr<SpatialGestureRecognizer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, settings, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SpatialGestureSettings: u32 {
    None (SpatialGestureSettings_None) = 0, Tap (SpatialGestureSettings_Tap) = 1, DoubleTap (SpatialGestureSettings_DoubleTap) = 2, Hold (SpatialGestureSettings_Hold) = 4, ManipulationTranslate (SpatialGestureSettings_ManipulationTranslate) = 8, NavigationX (SpatialGestureSettings_NavigationX) = 16, NavigationY (SpatialGestureSettings_NavigationY) = 32, NavigationZ (SpatialGestureSettings_NavigationZ) = 64, NavigationRailsX (SpatialGestureSettings_NavigationRailsX) = 128, NavigationRailsY (SpatialGestureSettings_NavigationRailsY) = 256, NavigationRailsZ (SpatialGestureSettings_NavigationRailsZ) = 512,
}}
DEFINE_IID!(IID_ISpatialHoldCanceledEventArgs, 1576842855, 19626, 16531, 140, 53, 182, 1, 168, 57, 243, 27);
RT_INTERFACE!{interface ISpatialHoldCanceledEventArgs(ISpatialHoldCanceledEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialHoldCanceledEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT
}}
impl ISpatialHoldCanceledEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialHoldCanceledEventArgs: ISpatialHoldCanceledEventArgs}
DEFINE_IID!(IID_ISpatialHoldCompletedEventArgs, 1063536395, 19709, 17370, 141, 196, 230, 69, 82, 23, 57, 113);
RT_INTERFACE!{interface ISpatialHoldCompletedEventArgs(ISpatialHoldCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialHoldCompletedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT
}}
impl ISpatialHoldCompletedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialHoldCompletedEventArgs: ISpatialHoldCompletedEventArgs}
DEFINE_IID!(IID_ISpatialHoldStartedEventArgs, 2385788281, 44214, 16708, 134, 21, 44, 251, 168, 163, 203, 63);
RT_INTERFACE!{interface ISpatialHoldStartedEventArgs(ISpatialHoldStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialHoldStartedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT
}}
impl ISpatialHoldStartedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialHoldStartedEventArgs: ISpatialHoldStartedEventArgs}
DEFINE_IID!(IID_ISpatialInteraction, 4237719097, 35046, 17990, 145, 18, 67, 68, 170, 236, 157, 250);
RT_INTERFACE!{interface ISpatialInteraction(ISpatialInteractionVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteraction] {
    fn get_SourceState(&self, out: *mut *mut SpatialInteractionSourceState) -> HRESULT
}}
impl ISpatialInteraction {
    #[inline] pub unsafe fn get_source_state(&self) -> Result<ComPtr<SpatialInteractionSourceState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteraction: ISpatialInteraction}
DEFINE_IID!(IID_ISpatialInteractionController, 1594776483, 2388, 20119, 134, 197, 231, 243, 11, 17, 77, 253);
RT_INTERFACE!{interface ISpatialInteractionController(ISpatialInteractionControllerVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionController] {
    fn get_HasTouchpad(&self, out: *mut bool) -> HRESULT,
    fn get_HasThumbstick(&self, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-devices"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-devices")] fn get_SimpleHapticsController(&self, out: *mut *mut ::rt::gen::windows::devices::haptics::SimpleHapticsController) -> HRESULT,
    fn get_VendorId(&self, out: *mut u16) -> HRESULT,
    fn get_ProductId(&self, out: *mut u16) -> HRESULT,
    fn get_Version(&self, out: *mut u16) -> HRESULT
}}
impl ISpatialInteractionController {
    #[inline] pub unsafe fn get_has_touchpad(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasTouchpad)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_thumbstick(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HasThumbstick)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn get_simple_haptics_controller(&self) -> Result<ComPtr<::rt::gen::windows::devices::haptics::SimpleHapticsController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SimpleHapticsController)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vendor_id(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VendorId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_product_id(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProductId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_version(&self) -> Result<u16> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Version)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionController: ISpatialInteractionController}
DEFINE_IID!(IID_ISpatialInteractionController2, 901175588, 51106, 18871, 183, 46, 84, 54, 178, 251, 143, 156);
RT_INTERFACE!{interface ISpatialInteractionController2(ISpatialInteractionController2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionController2] {
    #[cfg(feature="windows-storage")] fn TryGetRenderableModelAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::storage::streams::IRandomAccessStreamWithContentType>) -> HRESULT
}}
impl ISpatialInteractionController2 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn try_get_renderable_model_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::storage::streams::IRandomAccessStreamWithContentType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetRenderableModelAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialInteractionControllerProperties, 1627746225, 31657, 20021, 185, 63, 146, 114, 203, 169, 178, 139);
RT_INTERFACE!{interface ISpatialInteractionControllerProperties(ISpatialInteractionControllerPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionControllerProperties] {
    fn get_IsTouchpadTouched(&self, out: *mut bool) -> HRESULT,
    fn get_IsTouchpadPressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsThumbstickPressed(&self, out: *mut bool) -> HRESULT,
    fn get_ThumbstickX(&self, out: *mut f64) -> HRESULT,
    fn get_ThumbstickY(&self, out: *mut f64) -> HRESULT,
    fn get_TouchpadX(&self, out: *mut f64) -> HRESULT,
    fn get_TouchpadY(&self, out: *mut f64) -> HRESULT
}}
impl ISpatialInteractionControllerProperties {
    #[inline] pub unsafe fn get_is_touchpad_touched(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTouchpadTouched)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_touchpad_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTouchpadPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_thumbstick_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsThumbstickPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbstick_x(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThumbstickX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thumbstick_y(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ThumbstickY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_touchpad_x(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TouchpadX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_touchpad_y(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TouchpadY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionControllerProperties: ISpatialInteractionControllerProperties}
DEFINE_IID!(IID_ISpatialInteractionDetectedEventArgs, 123238628, 22881, 15169, 157, 251, 206, 165, 216, 156, 195, 138);
RT_INTERFACE!{interface ISpatialInteractionDetectedEventArgs(ISpatialInteractionDetectedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionDetectedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(not(feature="windows-perception"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT,
    fn get_Interaction(&self, out: *mut *mut SpatialInteraction) -> HRESULT
}}
impl ISpatialInteractionDetectedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_interaction(&self) -> Result<ComPtr<SpatialInteraction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Interaction)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionDetectedEventArgs: ISpatialInteractionDetectedEventArgs}
DEFINE_IID!(IID_ISpatialInteractionDetectedEventArgs2, 2066103955, 24339, 16796, 151, 213, 131, 70, 120, 38, 106, 166);
RT_INTERFACE!{interface ISpatialInteractionDetectedEventArgs2(ISpatialInteractionDetectedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionDetectedEventArgs2] {
    fn get_InteractionSource(&self, out: *mut *mut SpatialInteractionSource) -> HRESULT
}}
impl ISpatialInteractionDetectedEventArgs2 {
    #[inline] pub unsafe fn get_interaction_source(&self) -> Result<ComPtr<SpatialInteractionSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InteractionSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialInteractionManager, 849759912, 41306, 14741, 184, 189, 128, 81, 60, 181, 173, 239);
RT_INTERFACE!{interface ISpatialInteractionManager(ISpatialInteractionManagerVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionManager] {
    fn add_SourceDetected(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourceDetected(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SourceLost(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourceLost(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SourceUpdated(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourceUpdated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SourcePressed(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourcePressed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SourceReleased(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SourceReleased(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_InteractionDetected(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionDetectedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_InteractionDetected(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    #[cfg(feature="windows-perception")] fn GetDetectedSourcesAtTimestamp(&self, timeStamp: *mut ::rt::gen::windows::perception::PerceptionTimestamp, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<SpatialInteractionSourceState>) -> HRESULT
}}
impl ISpatialInteractionManager {
    #[inline] pub unsafe fn add_source_detected(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourceDetected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_detected(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourceDetected)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_source_lost(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourceLost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_lost(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourceLost)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_source_updated(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourceUpdated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_updated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourceUpdated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_source_pressed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourcePressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_pressed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourcePressed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_source_released(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionSourceEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SourceReleased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_source_released(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SourceReleased)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_interaction_detected(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<SpatialInteractionManager, SpatialInteractionDetectedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_InteractionDetected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_interaction_detected(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_InteractionDetected)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_detected_sources_at_timestamp(&self, timeStamp: &::rt::gen::windows::perception::PerceptionTimestamp) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<SpatialInteractionSourceState>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDetectedSourcesAtTimestamp)(self as *const _ as *mut _, timeStamp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionManager: ISpatialInteractionManager}
impl RtActivatable<ISpatialInteractionManagerStatics> for SpatialInteractionManager {}
impl SpatialInteractionManager {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<SpatialInteractionManager>> { unsafe {
        <Self as RtActivatable<ISpatialInteractionManagerStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(SpatialInteractionManager(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,83,112,97,116,105,97,108,46,83,112,97,116,105,97,108,73,110,116,101,114,97,99,116,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_SpatialInteractionManager]);
DEFINE_IID!(IID_ISpatialInteractionManagerStatics, 14884774, 36002, 12479, 145, 254, 217, 203, 74, 0, 137, 144);
RT_INTERFACE!{static interface ISpatialInteractionManagerStatics(ISpatialInteractionManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionManagerStatics] {
    fn GetForCurrentView(&self, out: *mut *mut SpatialInteractionManager) -> HRESULT
}}
impl ISpatialInteractionManagerStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<SpatialInteractionManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SpatialInteractionPressKind: i32 {
    None (SpatialInteractionPressKind_None) = 0, Select (SpatialInteractionPressKind_Select) = 1, Menu (SpatialInteractionPressKind_Menu) = 2, Grasp (SpatialInteractionPressKind_Grasp) = 3, Touchpad (SpatialInteractionPressKind_Touchpad) = 4, Thumbstick (SpatialInteractionPressKind_Thumbstick) = 5,
}}
DEFINE_IID!(IID_ISpatialInteractionSource, 4216599482, 45235, 12616, 159, 59, 233, 245, 222, 86, 143, 93);
RT_INTERFACE!{interface ISpatialInteractionSource(ISpatialInteractionSourceVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSource] {
    fn get_Id(&self, out: *mut u32) -> HRESULT,
    fn get_Kind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT
}}
impl ISpatialInteractionSource {
    #[inline] pub unsafe fn get_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionSource: ISpatialInteractionSource}
DEFINE_IID!(IID_ISpatialInteractionSource2, 3838162700, 1136, 16424, 136, 192, 160, 235, 68, 211, 78, 254);
RT_INTERFACE!{interface ISpatialInteractionSource2(ISpatialInteractionSource2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSource2] {
    fn get_IsPointingSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsMenuSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsGraspSupported(&self, out: *mut bool) -> HRESULT,
    fn get_Controller(&self, out: *mut *mut SpatialInteractionController) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetStateAtTimestamp(&self, timestamp: *mut ::rt::gen::windows::perception::PerceptionTimestamp, out: *mut *mut SpatialInteractionSourceState) -> HRESULT
}}
impl ISpatialInteractionSource2 {
    #[inline] pub unsafe fn get_is_pointing_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPointingSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_menu_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMenuSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_grasp_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGraspSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_controller(&self) -> Result<ComPtr<SpatialInteractionController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Controller)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_state_at_timestamp(&self, timestamp: &::rt::gen::windows::perception::PerceptionTimestamp) -> Result<ComPtr<SpatialInteractionSourceState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetStateAtTimestamp)(self as *const _ as *mut _, timestamp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialInteractionSource3, 67557881, 39677, 17657, 133, 220, 112, 0, 35, 169, 98, 227);
RT_INTERFACE!{interface ISpatialInteractionSource3(ISpatialInteractionSource3Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSource3] {
    fn get_Handedness(&self, out: *mut SpatialInteractionSourceHandedness) -> HRESULT
}}
impl ISpatialInteractionSource3 {
    #[inline] pub unsafe fn get_handedness(&self) -> Result<SpatialInteractionSourceHandedness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handedness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialInteractionSourceEventArgs, 599230159, 60451, 14713, 178, 124, 235, 14, 18, 254, 183, 199);
RT_INTERFACE!{interface ISpatialInteractionSourceEventArgs(ISpatialInteractionSourceEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceEventArgs] {
    fn get_State(&self, out: *mut *mut SpatialInteractionSourceState) -> HRESULT
}}
impl ISpatialInteractionSourceEventArgs {
    #[inline] pub unsafe fn get_state(&self) -> Result<ComPtr<SpatialInteractionSourceState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionSourceEventArgs: ISpatialInteractionSourceEventArgs}
DEFINE_IID!(IID_ISpatialInteractionSourceEventArgs2, 3635721319, 58952, 19794, 171, 73, 224, 210, 39, 25, 159, 99);
RT_INTERFACE!{interface ISpatialInteractionSourceEventArgs2(ISpatialInteractionSourceEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceEventArgs2] {
    fn get_PressKind(&self, out: *mut SpatialInteractionPressKind) -> HRESULT
}}
impl ISpatialInteractionSourceEventArgs2 {
    #[inline] pub unsafe fn get_press_kind(&self) -> Result<SpatialInteractionPressKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PressKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum SpatialInteractionSourceHandedness: i32 {
    Unspecified (SpatialInteractionSourceHandedness_Unspecified) = 0, Left (SpatialInteractionSourceHandedness_Left) = 1, Right (SpatialInteractionSourceHandedness_Right) = 2,
}}
RT_ENUM! { enum SpatialInteractionSourceKind: i32 {
    Other (SpatialInteractionSourceKind_Other) = 0, Hand (SpatialInteractionSourceKind_Hand) = 1, Voice (SpatialInteractionSourceKind_Voice) = 2, Controller (SpatialInteractionSourceKind_Controller) = 3,
}}
DEFINE_IID!(IID_ISpatialInteractionSourceLocation, 3930494660, 32395, 12490, 188, 197, 199, 113, 137, 206, 163, 10);
RT_INTERFACE!{interface ISpatialInteractionSourceLocation(ISpatialInteractionSourceLocationVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceLocation] {
    fn get_Position(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>) -> HRESULT,
    fn get_Velocity(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>) -> HRESULT
}}
impl ISpatialInteractionSourceLocation {
    #[inline] pub unsafe fn get_position(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_velocity(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Velocity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionSourceLocation: ISpatialInteractionSourceLocation}
DEFINE_IID!(IID_ISpatialInteractionSourceLocation2, 1281822789, 14615, 16636, 169, 172, 49, 201, 207, 95, 249, 27);
RT_INTERFACE!{interface ISpatialInteractionSourceLocation2(ISpatialInteractionSourceLocation2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceLocation2] {
    fn get_Orientation(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Quaternion>) -> HRESULT
}}
impl ISpatialInteractionSourceLocation2 {
    #[inline] pub unsafe fn get_orientation(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Quaternion>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialInteractionSourceLocation3, 1728243294, 59669, 19707, 156, 27, 5, 56, 239, 200, 102, 135);
RT_INTERFACE!{interface ISpatialInteractionSourceLocation3(ISpatialInteractionSourceLocation3Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceLocation3] {
    fn get_PositionAccuracy(&self, out: *mut SpatialInteractionSourcePositionAccuracy) -> HRESULT,
    fn get_AngularVelocity(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>) -> HRESULT,
    fn get_SourcePointerPose(&self, out: *mut *mut SpatialPointerInteractionSourcePose) -> HRESULT
}}
impl ISpatialInteractionSourceLocation3 {
    #[inline] pub unsafe fn get_position_accuracy(&self) -> Result<SpatialInteractionSourcePositionAccuracy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionAccuracy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_angular_velocity(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AngularVelocity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_pointer_pose(&self) -> Result<ComPtr<SpatialPointerInteractionSourcePose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourcePointerPose)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SpatialInteractionSourcePositionAccuracy: i32 {
    High (SpatialInteractionSourcePositionAccuracy_High) = 0, Approximate (SpatialInteractionSourcePositionAccuracy_Approximate) = 1,
}}
DEFINE_IID!(IID_ISpatialInteractionSourceProperties, 90195266, 16119, 12834, 159, 83, 99, 201, 203, 126, 59, 199);
RT_INTERFACE!{interface ISpatialInteractionSourceProperties(ISpatialInteractionSourcePropertiesVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceProperties] {
    #[cfg(feature="windows-perception")] fn TryGetSourceLossMitigationDirection(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>) -> HRESULT,
    fn get_SourceLossRisk(&self, out: *mut f64) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetLocation(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialInteractionSourceLocation) -> HRESULT
}}
impl ISpatialInteractionSourceProperties {
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_source_loss_mitigation_direction(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::numerics::Vector3>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetSourceLossMitigationDirection)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_loss_risk(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SourceLossRisk)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_location(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialInteractionSourceLocation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetLocation)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionSourceProperties: ISpatialInteractionSourceProperties}
DEFINE_IID!(IID_ISpatialInteractionSourceState, 3586422255, 19299, 14316, 152, 185, 159, 198, 82, 185, 210, 242);
RT_INTERFACE!{interface ISpatialInteractionSourceState(ISpatialInteractionSourceStateVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceState] {
    fn get_Source(&self, out: *mut *mut SpatialInteractionSource) -> HRESULT,
    fn get_Properties(&self, out: *mut *mut SpatialInteractionSourceProperties) -> HRESULT,
    fn get_IsPressed(&self, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-perception")] fn get_Timestamp(&self, out: *mut *mut ::rt::gen::windows::perception::PerceptionTimestamp) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT
}}
impl ISpatialInteractionSourceState {
    #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<SpatialInteractionSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_properties(&self) -> Result<ComPtr<SpatialInteractionSourceProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Properties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_timestamp(&self) -> Result<ComPtr<::rt::gen::windows::perception::PerceptionTimestamp>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialInteractionSourceState: ISpatialInteractionSourceState}
DEFINE_IID!(IID_ISpatialInteractionSourceState2, 1173803197, 6003, 18734, 155, 163, 138, 193, 203, 231, 124, 8);
RT_INTERFACE!{interface ISpatialInteractionSourceState2(ISpatialInteractionSourceState2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialInteractionSourceState2] {
    fn get_IsSelectPressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsMenuPressed(&self, out: *mut bool) -> HRESULT,
    fn get_IsGrasped(&self, out: *mut bool) -> HRESULT,
    fn get_SelectPressedValue(&self, out: *mut f64) -> HRESULT,
    fn get_ControllerProperties(&self, out: *mut *mut SpatialInteractionControllerProperties) -> HRESULT
}}
impl ISpatialInteractionSourceState2 {
    #[inline] pub unsafe fn get_is_select_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSelectPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_menu_pressed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMenuPressed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_grasped(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGrasped)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_select_pressed_value(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectPressedValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_controller_properties(&self) -> Result<ComPtr<SpatialInteractionControllerProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ControllerProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialManipulationCanceledEventArgs, 759222731, 59354, 16928, 176, 191, 129, 147, 1, 103, 71, 128);
RT_INTERFACE!{interface ISpatialManipulationCanceledEventArgs(ISpatialManipulationCanceledEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialManipulationCanceledEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT
}}
impl ISpatialManipulationCanceledEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialManipulationCanceledEventArgs: ISpatialManipulationCanceledEventArgs}
DEFINE_IID!(IID_ISpatialManipulationCompletedEventArgs, 84436994, 62209, 17219, 146, 80, 47, 186, 165, 248, 122, 55);
RT_INTERFACE!{interface ISpatialManipulationCompletedEventArgs(ISpatialManipulationCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialManipulationCompletedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetCumulativeDelta(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialManipulationDelta) -> HRESULT
}}
impl ISpatialManipulationCompletedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_cumulative_delta(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialManipulationDelta>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetCumulativeDelta)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialManipulationCompletedEventArgs: ISpatialManipulationCompletedEventArgs}
DEFINE_IID!(IID_ISpatialManipulationDelta, 2817300090, 53539, 14977, 161, 91, 153, 41, 35, 220, 190, 145);
RT_INTERFACE!{interface ISpatialManipulationDelta(ISpatialManipulationDeltaVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialManipulationDelta] {
    fn get_Translation(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT
}}
impl ISpatialManipulationDelta {
    #[inline] pub unsafe fn get_translation(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Translation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialManipulationDelta: ISpatialManipulationDelta}
DEFINE_IID!(IID_ISpatialManipulationStartedEventArgs, 2715204558, 17061, 14203, 173, 166, 210, 142, 61, 56, 71, 55);
RT_INTERFACE!{interface ISpatialManipulationStartedEventArgs(ISpatialManipulationStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialManipulationStartedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT
}}
impl ISpatialManipulationStartedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialManipulationStartedEventArgs: ISpatialManipulationStartedEventArgs}
DEFINE_IID!(IID_ISpatialManipulationUpdatedEventArgs, 1596132251, 24774, 19910, 189, 201, 159, 74, 111, 21, 254, 73);
RT_INTERFACE!{interface ISpatialManipulationUpdatedEventArgs(ISpatialManipulationUpdatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialManipulationUpdatedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(feature="windows-perception")] fn TryGetCumulativeDelta(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialManipulationDelta) -> HRESULT
}}
impl ISpatialManipulationUpdatedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_cumulative_delta(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialManipulationDelta>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetCumulativeDelta)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialManipulationUpdatedEventArgs: ISpatialManipulationUpdatedEventArgs}
DEFINE_IID!(IID_ISpatialNavigationCanceledEventArgs, 3461365468, 59557, 18160, 146, 212, 60, 18, 43, 53, 17, 42);
RT_INTERFACE!{interface ISpatialNavigationCanceledEventArgs(ISpatialNavigationCanceledEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialNavigationCanceledEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT
}}
impl ISpatialNavigationCanceledEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialNavigationCanceledEventArgs: ISpatialNavigationCanceledEventArgs}
DEFINE_IID!(IID_ISpatialNavigationCompletedEventArgs, 19824823, 44859, 17090, 158, 65, 186, 170, 14, 114, 31, 58);
RT_INTERFACE!{interface ISpatialNavigationCompletedEventArgs(ISpatialNavigationCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialNavigationCompletedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    fn get_NormalizedOffset(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT
}}
impl ISpatialNavigationCompletedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_normalized_offset(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NormalizedOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialNavigationCompletedEventArgs: ISpatialNavigationCompletedEventArgs}
DEFINE_IID!(IID_ISpatialNavigationStartedEventArgs, 1967797386, 64356, 18006, 142, 189, 157, 238, 202, 175, 228, 117);
RT_INTERFACE!{interface ISpatialNavigationStartedEventArgs(ISpatialNavigationStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialNavigationStartedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(not(feature="windows-perception"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT,
    fn get_IsNavigatingX(&self, out: *mut bool) -> HRESULT,
    fn get_IsNavigatingY(&self, out: *mut bool) -> HRESULT,
    fn get_IsNavigatingZ(&self, out: *mut bool) -> HRESULT
}}
impl ISpatialNavigationStartedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_navigating_x(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsNavigatingX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_navigating_y(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsNavigatingY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_navigating_z(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsNavigatingZ)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialNavigationStartedEventArgs: ISpatialNavigationStartedEventArgs}
DEFINE_IID!(IID_ISpatialNavigationUpdatedEventArgs, 2607890391, 33693, 19060, 135, 50, 69, 70, 111, 192, 68, 181);
RT_INTERFACE!{interface ISpatialNavigationUpdatedEventArgs(ISpatialNavigationUpdatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialNavigationUpdatedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    fn get_NormalizedOffset(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT
}}
impl ISpatialNavigationUpdatedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_normalized_offset(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NormalizedOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialNavigationUpdatedEventArgs: ISpatialNavigationUpdatedEventArgs}
DEFINE_IID!(IID_ISpatialPointerInteractionSourcePose, 2802860807, 11307, 19770, 146, 167, 128, 206, 215, 196, 160, 208);
RT_INTERFACE!{interface ISpatialPointerInteractionSourcePose(ISpatialPointerInteractionSourcePoseVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialPointerInteractionSourcePose] {
    fn get_Position(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT,
    fn get_ForwardDirection(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT,
    fn get_UpDirection(&self, out: *mut ::rt::gen::windows::foundation::numerics::Vector3) -> HRESULT
}}
impl ISpatialPointerInteractionSourcePose {
    #[inline] pub unsafe fn get_position(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_forward_direction(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForwardDirection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_up_direction(&self) -> Result<::rt::gen::windows::foundation::numerics::Vector3> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UpDirection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialPointerInteractionSourcePose: ISpatialPointerInteractionSourcePose}
DEFINE_IID!(IID_ISpatialPointerInteractionSourcePose2, 3972892344, 21211, 18079, 158, 63, 128, 196, 127, 116, 188, 233);
RT_INTERFACE!{interface ISpatialPointerInteractionSourcePose2(ISpatialPointerInteractionSourcePose2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialPointerInteractionSourcePose2] {
    fn get_Orientation(&self, out: *mut ::rt::gen::windows::foundation::numerics::Quaternion) -> HRESULT,
    fn get_PositionAccuracy(&self, out: *mut SpatialInteractionSourcePositionAccuracy) -> HRESULT
}}
impl ISpatialPointerInteractionSourcePose2 {
    #[inline] pub unsafe fn get_orientation(&self) -> Result<::rt::gen::windows::foundation::numerics::Quaternion> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position_accuracy(&self) -> Result<SpatialInteractionSourcePositionAccuracy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PositionAccuracy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialPointerPose, 1767089198, 49534, 13693, 151, 161, 114, 105, 208, 237, 45, 16);
RT_INTERFACE!{interface ISpatialPointerPose(ISpatialPointerPoseVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialPointerPose] {
    #[cfg(feature="windows-perception")] fn get_Timestamp(&self, out: *mut *mut ::rt::gen::windows::perception::PerceptionTimestamp) -> HRESULT,
    #[cfg(feature="windows-perception")] fn get_Head(&self, out: *mut *mut ::rt::gen::windows::perception::people::HeadPose) -> HRESULT
}}
impl ISpatialPointerPose {
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_timestamp(&self) -> Result<ComPtr<::rt::gen::windows::perception::PerceptionTimestamp>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_head(&self) -> Result<ComPtr<::rt::gen::windows::perception::people::HeadPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Head)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialPointerPose: ISpatialPointerPose}
impl RtActivatable<ISpatialPointerPoseStatics> for SpatialPointerPose {}
impl SpatialPointerPose {
    #[cfg(feature="windows-perception")] #[inline] pub fn try_get_at_timestamp(coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, timestamp: &::rt::gen::windows::perception::PerceptionTimestamp) -> Result<ComPtr<SpatialPointerPose>> { unsafe {
        <Self as RtActivatable<ISpatialPointerPoseStatics>>::get_activation_factory().try_get_at_timestamp(coordinateSystem, timestamp)
    }}
}
DEFINE_CLSID!(SpatialPointerPose(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,83,112,97,116,105,97,108,46,83,112,97,116,105,97,108,80,111,105,110,116,101,114,80,111,115,101,0]) [CLSID_SpatialPointerPose]);
DEFINE_IID!(IID_ISpatialPointerPose2, 2636131095, 38222, 19980, 150, 209, 182, 121, 11, 111, 194, 253);
RT_INTERFACE!{interface ISpatialPointerPose2(ISpatialPointerPose2Vtbl): IInspectable(IInspectableVtbl) [IID_ISpatialPointerPose2] {
    fn TryGetInteractionSourcePose(&self, source: *mut SpatialInteractionSource, out: *mut *mut SpatialPointerInteractionSourcePose) -> HRESULT
}}
impl ISpatialPointerPose2 {
    #[inline] pub unsafe fn try_get_interaction_source_pose(&self, source: &SpatialInteractionSource) -> Result<ComPtr<SpatialPointerInteractionSourcePose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetInteractionSourcePose)(self as *const _ as *mut _, source as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialPointerPoseStatics, 2723516841, 44193, 16096, 152, 22, 120, 92, 251, 46, 63, 184);
RT_INTERFACE!{static interface ISpatialPointerPoseStatics(ISpatialPointerPoseStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialPointerPoseStatics] {
    #[cfg(feature="windows-perception")] fn TryGetAtTimestamp(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, timestamp: *mut ::rt::gen::windows::perception::PerceptionTimestamp, out: *mut *mut SpatialPointerPose) -> HRESULT
}}
impl ISpatialPointerPoseStatics {
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_at_timestamp(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, timestamp: &::rt::gen::windows::perception::PerceptionTimestamp) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetAtTimestamp)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, timestamp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISpatialRecognitionEndedEventArgs, 238417355, 16245, 17395, 172, 129, 209, 220, 45, 249, 177, 251);
RT_INTERFACE!{interface ISpatialRecognitionEndedEventArgs(ISpatialRecognitionEndedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialRecognitionEndedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT
}}
impl ISpatialRecognitionEndedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialRecognitionEndedEventArgs: ISpatialRecognitionEndedEventArgs}
DEFINE_IID!(IID_ISpatialRecognitionStartedEventArgs, 618271375, 8, 19053, 170, 80, 42, 118, 249, 207, 178, 100);
RT_INTERFACE!{interface ISpatialRecognitionStartedEventArgs(ISpatialRecognitionStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialRecognitionStartedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(not(feature="windows-perception"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT,
    fn IsGesturePossible(&self, gesture: SpatialGestureSettings, out: *mut bool) -> HRESULT
}}
impl ISpatialRecognitionStartedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_gesture_possible(&self, gesture: SpatialGestureSettings) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsGesturePossible)(self as *const _ as *mut _, gesture, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialRecognitionStartedEventArgs: ISpatialRecognitionStartedEventArgs}
DEFINE_IID!(IID_ISpatialTappedEventArgs, 695043038, 62532, 19105, 178, 191, 157, 200, 141, 86, 125, 166);
RT_INTERFACE!{interface ISpatialTappedEventArgs(ISpatialTappedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISpatialTappedEventArgs] {
    fn get_InteractionSourceKind(&self, out: *mut SpatialInteractionSourceKind) -> HRESULT,
    #[cfg(not(feature="windows-perception"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-perception")] fn TryGetPointerPose(&self, coordinateSystem: *mut ::rt::gen::windows::perception::spatial::SpatialCoordinateSystem, out: *mut *mut SpatialPointerPose) -> HRESULT,
    fn get_TapCount(&self, out: *mut u32) -> HRESULT
}}
impl ISpatialTappedEventArgs {
    #[inline] pub unsafe fn get_interaction_source_kind(&self) -> Result<SpatialInteractionSourceKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InteractionSourceKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn try_get_pointer_pose(&self, coordinateSystem: &::rt::gen::windows::perception::spatial::SpatialCoordinateSystem) -> Result<ComPtr<SpatialPointerPose>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryGetPointerPose)(self as *const _ as *mut _, coordinateSystem as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tap_count(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TapCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SpatialTappedEventArgs: ISpatialTappedEventArgs}
} // Windows.UI.Input.Spatial
pub mod core { // Windows.UI.Input.Core
use ::prelude::*;
DEFINE_IID!(IID_IRadialControllerIndependentInputSource, 1029144310, 19694, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{interface IRadialControllerIndependentInputSource(IRadialControllerIndependentInputSourceVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerIndependentInputSource] {
    fn get_Controller(&self, out: *mut *mut super::RadialController) -> HRESULT,
    fn get_Dispatcher(&self, out: *mut *mut super::super::core::CoreDispatcher) -> HRESULT
}}
impl IRadialControllerIndependentInputSource {
    #[inline] pub unsafe fn get_controller(&self) -> Result<ComPtr<super::RadialController>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Controller)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dispatcher(&self) -> Result<ComPtr<super::super::core::CoreDispatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dispatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RadialControllerIndependentInputSource: IRadialControllerIndependentInputSource}
impl RtActivatable<IRadialControllerIndependentInputSourceStatics> for RadialControllerIndependentInputSource {}
impl RadialControllerIndependentInputSource {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub fn create_for_view(view: &::rt::gen::windows::applicationmodel::core::CoreApplicationView) -> Result<ComPtr<RadialControllerIndependentInputSource>> { unsafe {
        <Self as RtActivatable<IRadialControllerIndependentInputSourceStatics>>::get_activation_factory().create_for_view(view)
    }}
}
DEFINE_CLSID!(RadialControllerIndependentInputSource(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,67,111,114,101,46,82,97,100,105,97,108,67,111,110,116,114,111,108,108,101,114,73,110,100,101,112,101,110,100,101,110,116,73,110,112,117,116,83,111,117,114,99,101,0]) [CLSID_RadialControllerIndependentInputSource]);
DEFINE_IID!(IID_IRadialControllerIndependentInputSourceStatics, 1029144309, 19694, 4582, 181, 53, 0, 27, 220, 6, 171, 59);
RT_INTERFACE!{static interface IRadialControllerIndependentInputSourceStatics(IRadialControllerIndependentInputSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRadialControllerIndependentInputSourceStatics] {
    #[cfg(feature="windows-applicationmodel")] fn CreateForView(&self, view: *mut ::rt::gen::windows::applicationmodel::core::CoreApplicationView, out: *mut *mut RadialControllerIndependentInputSource) -> HRESULT
}}
impl IRadialControllerIndependentInputSourceStatics {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn create_for_view(&self, view: &::rt::gen::windows::applicationmodel::core::CoreApplicationView) -> Result<ComPtr<RadialControllerIndependentInputSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateForView)(self as *const _ as *mut _, view as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.Input.Core
pub mod inking { // Windows.UI.Input.Inking
use ::prelude::*;
DEFINE_IID!(IID_IInkDrawingAttributes, 2543982444, 26484, 18605, 132, 240, 72, 245, 169, 190, 116, 249);
RT_INTERFACE!{interface IInkDrawingAttributes(IInkDrawingAttributesVtbl): IInspectable(IInspectableVtbl) [IID_IInkDrawingAttributes] {
    fn get_Color(&self, out: *mut super::super::Color) -> HRESULT,
    fn put_Color(&self, value: super::super::Color) -> HRESULT,
    fn get_PenTip(&self, out: *mut PenTipShape) -> HRESULT,
    fn put_PenTip(&self, value: PenTipShape) -> HRESULT,
    fn get_Size(&self, out: *mut ::rt::gen::windows::foundation::Size) -> HRESULT,
    fn put_Size(&self, value: ::rt::gen::windows::foundation::Size) -> HRESULT,
    fn get_IgnorePressure(&self, out: *mut bool) -> HRESULT,
    fn put_IgnorePressure(&self, value: bool) -> HRESULT,
    fn get_FitToCurve(&self, out: *mut bool) -> HRESULT,
    fn put_FitToCurve(&self, value: bool) -> HRESULT
}}
impl IInkDrawingAttributes {
    #[inline] pub unsafe fn get_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Color)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_color(&self, value: super::super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Color)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pen_tip(&self) -> Result<PenTipShape> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PenTip)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pen_tip(&self, value: PenTipShape) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PenTip)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<::rt::gen::windows::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_size(&self, value: ::rt::gen::windows::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Size)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ignore_pressure(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IgnorePressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_ignore_pressure(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IgnorePressure)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_fit_to_curve(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FitToCurve)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_fit_to_curve(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FitToCurve)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkDrawingAttributes: IInkDrawingAttributes}
impl RtActivatable<IInkDrawingAttributesStatics> for InkDrawingAttributes {}
impl RtActivatable<IActivationFactory> for InkDrawingAttributes {}
impl InkDrawingAttributes {
    #[inline] pub fn create_for_pencil() -> Result<ComPtr<InkDrawingAttributes>> { unsafe {
        <Self as RtActivatable<IInkDrawingAttributesStatics>>::get_activation_factory().create_for_pencil()
    }}
}
DEFINE_CLSID!(InkDrawingAttributes(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,68,114,97,119,105,110,103,65,116,116,114,105,98,117,116,101,115,0]) [CLSID_InkDrawingAttributes]);
DEFINE_IID!(IID_IInkDrawingAttributes2, 2091607304, 36548, 17149, 165, 165, 228, 183, 209, 213, 49, 109);
RT_INTERFACE!{interface IInkDrawingAttributes2(IInkDrawingAttributes2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkDrawingAttributes2] {
    fn get_PenTipTransform(&self, out: *mut ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT,
    fn put_PenTipTransform(&self, value: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT,
    fn get_DrawAsHighlighter(&self, out: *mut bool) -> HRESULT,
    fn put_DrawAsHighlighter(&self, value: bool) -> HRESULT
}}
impl IInkDrawingAttributes2 {
    #[inline] pub unsafe fn get_pen_tip_transform(&self) -> Result<::rt::gen::windows::foundation::numerics::Matrix3x2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PenTipTransform)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pen_tip_transform(&self, value: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PenTipTransform)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_draw_as_highlighter(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DrawAsHighlighter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_draw_as_highlighter(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DrawAsHighlighter)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkDrawingAttributes3, 1912733698, 32091, 18064, 138, 244, 230, 100, 203, 226, 183, 79);
RT_INTERFACE!{interface IInkDrawingAttributes3(IInkDrawingAttributes3Vtbl): IInspectable(IInspectableVtbl) [IID_IInkDrawingAttributes3] {
    fn get_Kind(&self, out: *mut InkDrawingAttributesKind) -> HRESULT,
    fn get_PencilProperties(&self, out: *mut *mut InkDrawingAttributesPencilProperties) -> HRESULT
}}
impl IInkDrawingAttributes3 {
    #[inline] pub unsafe fn get_kind(&self) -> Result<InkDrawingAttributesKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pencil_properties(&self) -> Result<ComPtr<InkDrawingAttributesPencilProperties>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PencilProperties)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkDrawingAttributes4, 4016430117, 40729, 17773, 145, 163, 188, 58, 61, 145, 197, 251);
RT_INTERFACE!{interface IInkDrawingAttributes4(IInkDrawingAttributes4Vtbl): IInspectable(IInspectableVtbl) [IID_IInkDrawingAttributes4] {
    fn get_IgnoreTilt(&self, out: *mut bool) -> HRESULT,
    fn put_IgnoreTilt(&self, value: bool) -> HRESULT
}}
impl IInkDrawingAttributes4 {
    #[inline] pub unsafe fn get_ignore_tilt(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IgnoreTilt)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_ignore_tilt(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IgnoreTilt)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum InkDrawingAttributesKind: i32 {
    Default (InkDrawingAttributesKind_Default) = 0, Pencil (InkDrawingAttributesKind_Pencil) = 1,
}}
DEFINE_IID!(IID_IInkDrawingAttributesPencilProperties, 1327838411, 11654, 16827, 176, 232, 228, 194, 160, 37, 60, 82);
RT_INTERFACE!{interface IInkDrawingAttributesPencilProperties(IInkDrawingAttributesPencilPropertiesVtbl): IInspectable(IInspectableVtbl) [IID_IInkDrawingAttributesPencilProperties] {
    fn get_Opacity(&self, out: *mut f64) -> HRESULT,
    fn put_Opacity(&self, value: f64) -> HRESULT
}}
impl IInkDrawingAttributesPencilProperties {
    #[inline] pub unsafe fn get_opacity(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Opacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_opacity(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Opacity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkDrawingAttributesPencilProperties: IInkDrawingAttributesPencilProperties}
DEFINE_IID!(IID_IInkDrawingAttributesStatics, 4147241023, 6757, 18530, 150, 203, 110, 22, 101, 225, 127, 109);
RT_INTERFACE!{static interface IInkDrawingAttributesStatics(IInkDrawingAttributesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IInkDrawingAttributesStatics] {
    fn CreateForPencil(&self, out: *mut *mut InkDrawingAttributes) -> HRESULT
}}
impl IInkDrawingAttributesStatics {
    #[inline] pub unsafe fn create_for_pencil(&self) -> Result<ComPtr<InkDrawingAttributes>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateForPencil)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum InkHighContrastAdjustment: i32 {
    UseSystemColorsWhenNecessary (InkHighContrastAdjustment_UseSystemColorsWhenNecessary) = 0, UseSystemColors (InkHighContrastAdjustment_UseSystemColors) = 1, UseOriginalColors (InkHighContrastAdjustment_UseOriginalColors) = 2,
}}
DEFINE_IID!(IID_IInkInputProcessingConfiguration, 662231134, 13258, 19206, 166, 211, 172, 57, 69, 17, 109, 55);
RT_INTERFACE!{interface IInkInputProcessingConfiguration(IInkInputProcessingConfigurationVtbl): IInspectable(IInspectableVtbl) [IID_IInkInputProcessingConfiguration] {
    fn get_Mode(&self, out: *mut InkInputProcessingMode) -> HRESULT,
    fn put_Mode(&self, value: InkInputProcessingMode) -> HRESULT,
    fn get_RightDragAction(&self, out: *mut InkInputRightDragAction) -> HRESULT,
    fn put_RightDragAction(&self, value: InkInputRightDragAction) -> HRESULT
}}
impl IInkInputProcessingConfiguration {
    #[inline] pub unsafe fn get_mode(&self) -> Result<InkInputProcessingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: InkInputProcessingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_drag_action(&self) -> Result<InkInputRightDragAction> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightDragAction)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_drag_action(&self, value: InkInputRightDragAction) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightDragAction)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkInputProcessingConfiguration: IInkInputProcessingConfiguration}
RT_ENUM! { enum InkInputProcessingMode: i32 {
    None (InkInputProcessingMode_None) = 0, Inking (InkInputProcessingMode_Inking) = 1, Erasing (InkInputProcessingMode_Erasing) = 2,
}}
RT_ENUM! { enum InkInputRightDragAction: i32 {
    LeaveUnprocessed (InkInputRightDragAction_LeaveUnprocessed) = 0, AllowProcessing (InkInputRightDragAction_AllowProcessing) = 1,
}}
DEFINE_IID!(IID_IInkManager, 1195668349, 26395, 16739, 156, 149, 78, 141, 122, 3, 95, 225);
RT_INTERFACE!{interface IInkManager(IInkManagerVtbl): IInspectable(IInspectableVtbl) [IID_IInkManager] {
    fn get_Mode(&self, out: *mut InkManipulationMode) -> HRESULT,
    fn put_Mode(&self, value: InkManipulationMode) -> HRESULT,
    fn ProcessPointerDown(&self, pointerPoint: *mut super::PointerPoint) -> HRESULT,
    fn ProcessPointerUpdate(&self, pointerPoint: *mut super::PointerPoint, out: *mut *mut IInspectable) -> HRESULT,
    fn ProcessPointerUp(&self, pointerPoint: *mut super::PointerPoint, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn SetDefaultDrawingAttributes(&self, drawingAttributes: *mut InkDrawingAttributes) -> HRESULT,
    fn RecognizeAsync2(&self, recognitionTarget: InkRecognitionTarget, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>>) -> HRESULT
}}
impl IInkManager {
    #[inline] pub unsafe fn get_mode(&self) -> Result<InkManipulationMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Mode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mode(&self, value: InkManipulationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Mode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_pointer_down(&self, pointerPoint: &super::PointerPoint) -> Result<()> {
        let hr = ((*self.lpVtbl).ProcessPointerDown)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_pointer_update(&self, pointerPoint: &super::PointerPoint) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ProcessPointerUpdate)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_pointer_up(&self, pointerPoint: &super::PointerPoint) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ProcessPointerUp)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_drawing_attributes(&self, drawingAttributes: &InkDrawingAttributes) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDefaultDrawingAttributes)(self as *const _ as *mut _, drawingAttributes as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn recognize_async2(&self, recognitionTarget: InkRecognitionTarget) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RecognizeAsync2)(self as *const _ as *mut _, recognitionTarget, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkManager: IInkManager}
impl RtActivatable<IActivationFactory> for InkManager {}
DEFINE_CLSID!(InkManager(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,77,97,110,97,103,101,114,0]) [CLSID_InkManager]);
RT_ENUM! { enum InkManipulationMode: i32 {
    Inking (InkManipulationMode_Inking) = 0, Erasing (InkManipulationMode_Erasing) = 1, Selecting (InkManipulationMode_Selecting) = 2,
}}
RT_ENUM! { enum InkPersistenceFormat: i32 {
    GifWithEmbeddedIsf (InkPersistenceFormat_GifWithEmbeddedIsf) = 0, Isf (InkPersistenceFormat_Isf) = 1,
}}
DEFINE_IID!(IID_IInkPoint, 2676434731, 34188, 18085, 155, 65, 209, 149, 151, 4, 89, 253);
RT_INTERFACE!{interface IInkPoint(IInkPointVtbl): IInspectable(IInspectableVtbl) [IID_IInkPoint] {
    fn get_Position(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn get_Pressure(&self, out: *mut f32) -> HRESULT
}}
impl IInkPoint {
    #[inline] pub unsafe fn get_position(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressure(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Pressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InkPoint: IInkPoint}
impl RtActivatable<IInkPointFactory> for InkPoint {}
impl RtActivatable<IInkPointFactory2> for InkPoint {}
impl InkPoint {
    #[inline] pub fn create_ink_point(position: ::rt::gen::windows::foundation::Point, pressure: f32) -> Result<ComPtr<InkPoint>> { unsafe {
        <Self as RtActivatable<IInkPointFactory>>::get_activation_factory().create_ink_point(position, pressure)
    }}
    #[inline] pub fn create_ink_point_with_tilt_and_timestamp(position: ::rt::gen::windows::foundation::Point, pressure: f32, tiltX: f32, tiltY: f32, timestamp: u64) -> Result<ComPtr<InkPoint>> { unsafe {
        <Self as RtActivatable<IInkPointFactory2>>::get_activation_factory().create_ink_point_with_tilt_and_timestamp(position, pressure, tiltX, tiltY, timestamp)
    }}
}
DEFINE_CLSID!(InkPoint(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,80,111,105,110,116,0]) [CLSID_InkPoint]);
DEFINE_IID!(IID_IInkPoint2, 4222206967, 44630, 19804, 189, 47, 10, 196, 95, 94, 74, 249);
RT_INTERFACE!{interface IInkPoint2(IInkPoint2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkPoint2] {
    fn get_TiltX(&self, out: *mut f32) -> HRESULT,
    fn get_TiltY(&self, out: *mut f32) -> HRESULT,
    fn get_Timestamp(&self, out: *mut u64) -> HRESULT
}}
impl IInkPoint2 {
    #[inline] pub unsafe fn get_tilt_x(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TiltX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tilt_y(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TiltY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_timestamp(&self) -> Result<u64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Timestamp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkPointFactory, 702928156, 51599, 16477, 159, 59, 229, 62, 49, 6, 141, 77);
RT_INTERFACE!{static interface IInkPointFactory(IInkPointFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IInkPointFactory] {
    fn CreateInkPoint(&self, position: ::rt::gen::windows::foundation::Point, pressure: f32, out: *mut *mut InkPoint) -> HRESULT
}}
impl IInkPointFactory {
    #[inline] pub unsafe fn create_ink_point(&self, position: ::rt::gen::windows::foundation::Point, pressure: f32) -> Result<ComPtr<InkPoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInkPoint)(self as *const _ as *mut _, position, pressure, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkPointFactory2, 3759431301, 56063, 17906, 173, 105, 5, 13, 130, 86, 162, 9);
RT_INTERFACE!{static interface IInkPointFactory2(IInkPointFactory2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkPointFactory2] {
    fn CreateInkPointWithTiltAndTimestamp(&self, position: ::rt::gen::windows::foundation::Point, pressure: f32, tiltX: f32, tiltY: f32, timestamp: u64, out: *mut *mut InkPoint) -> HRESULT
}}
impl IInkPointFactory2 {
    #[inline] pub unsafe fn create_ink_point_with_tilt_and_timestamp(&self, position: ::rt::gen::windows::foundation::Point, pressure: f32, tiltX: f32, tiltY: f32, timestamp: u64) -> Result<ComPtr<InkPoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInkPointWithTiltAndTimestamp)(self as *const _ as *mut _, position, pressure, tiltX, tiltY, timestamp, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkPresenter, 2795204834, 34939, 17807, 177, 115, 79, 228, 67, 137, 48, 163);
RT_INTERFACE!{interface IInkPresenter(IInkPresenterVtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenter] {
    fn get_IsInputEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsInputEnabled(&self, value: bool) -> HRESULT,
    fn get_InputDeviceTypes(&self, out: *mut super::super::core::CoreInputDeviceTypes) -> HRESULT,
    fn put_InputDeviceTypes(&self, value: super::super::core::CoreInputDeviceTypes) -> HRESULT,
    fn get_UnprocessedInput(&self, out: *mut *mut InkUnprocessedInput) -> HRESULT,
    fn get_StrokeInput(&self, out: *mut *mut InkStrokeInput) -> HRESULT,
    fn get_InputProcessingConfiguration(&self, out: *mut *mut InkInputProcessingConfiguration) -> HRESULT,
    fn get_StrokeContainer(&self, out: *mut *mut InkStrokeContainer) -> HRESULT,
    fn put_StrokeContainer(&self, value: *mut InkStrokeContainer) -> HRESULT,
    fn CopyDefaultDrawingAttributes(&self, out: *mut *mut InkDrawingAttributes) -> HRESULT,
    fn UpdateDefaultDrawingAttributes(&self, value: *mut InkDrawingAttributes) -> HRESULT,
    fn ActivateCustomDrying(&self, out: *mut *mut InkSynchronizer) -> HRESULT,
    fn SetPredefinedConfiguration(&self, value: InkPresenterPredefinedConfiguration) -> HRESULT,
    fn add_StrokesCollected(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkPresenter, InkStrokesCollectedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StrokesCollected(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StrokesErased(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkPresenter, InkStrokesErasedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StrokesErased(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IInkPresenter {
    #[inline] pub unsafe fn get_is_input_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInputEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_input_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsInputEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_input_device_types(&self) -> Result<super::super::core::CoreInputDeviceTypes> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InputDeviceTypes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_input_device_types(&self, value: super::super::core::CoreInputDeviceTypes) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InputDeviceTypes)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_unprocessed_input(&self) -> Result<ComPtr<InkUnprocessedInput>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UnprocessedInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stroke_input(&self) -> Result<ComPtr<InkStrokeInput>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StrokeInput)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_input_processing_configuration(&self) -> Result<ComPtr<InkInputProcessingConfiguration>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InputProcessingConfiguration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stroke_container(&self) -> Result<ComPtr<InkStrokeContainer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StrokeContainer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stroke_container(&self, value: &InkStrokeContainer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StrokeContainer)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn copy_default_drawing_attributes(&self) -> Result<ComPtr<InkDrawingAttributes>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CopyDefaultDrawingAttributes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn update_default_drawing_attributes(&self, value: &InkDrawingAttributes) -> Result<()> {
        let hr = ((*self.lpVtbl).UpdateDefaultDrawingAttributes)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn activate_custom_drying(&self) -> Result<ComPtr<InkSynchronizer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ActivateCustomDrying)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_predefined_configuration(&self, value: InkPresenterPredefinedConfiguration) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPredefinedConfiguration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_strokes_collected(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkPresenter, InkStrokesCollectedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StrokesCollected)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_strokes_collected(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StrokesCollected)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_strokes_erased(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkPresenter, InkStrokesErasedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StrokesErased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_strokes_erased(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StrokesErased)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkPresenter: IInkPresenter}
DEFINE_IID!(IID_IInkPresenter2, 3478382098, 39476, 4582, 159, 51, 162, 79, 192, 217, 100, 156);
RT_INTERFACE!{interface IInkPresenter2(IInkPresenter2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenter2] {
    fn get_HighContrastAdjustment(&self, out: *mut InkHighContrastAdjustment) -> HRESULT,
    fn put_HighContrastAdjustment(&self, value: InkHighContrastAdjustment) -> HRESULT
}}
impl IInkPresenter2 {
    #[inline] pub unsafe fn get_high_contrast_adjustment(&self) -> Result<InkHighContrastAdjustment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HighContrastAdjustment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_high_contrast_adjustment(&self, value: InkHighContrastAdjustment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HighContrastAdjustment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum InkPresenterPredefinedConfiguration: i32 {
    SimpleSinglePointer (InkPresenterPredefinedConfiguration_SimpleSinglePointer) = 0, SimpleMultiplePointer (InkPresenterPredefinedConfiguration_SimpleMultiplePointer) = 1,
}}
DEFINE_IID!(IID_IInkPresenterProtractor, 2112090794, 61292, 20113, 167, 59, 91, 112, 213, 111, 189, 23);
RT_INTERFACE!{interface IInkPresenterProtractor(IInkPresenterProtractorVtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenterProtractor] {
    fn get_AreTickMarksVisible(&self, out: *mut bool) -> HRESULT,
    fn put_AreTickMarksVisible(&self, value: bool) -> HRESULT,
    fn get_AreRaysVisible(&self, out: *mut bool) -> HRESULT,
    fn put_AreRaysVisible(&self, value: bool) -> HRESULT,
    fn get_IsCenterMarkerVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsCenterMarkerVisible(&self, value: bool) -> HRESULT,
    fn get_IsAngleReadoutVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsAngleReadoutVisible(&self, value: bool) -> HRESULT,
    fn get_IsResizable(&self, out: *mut bool) -> HRESULT,
    fn put_IsResizable(&self, value: bool) -> HRESULT,
    fn get_Radius(&self, out: *mut f64) -> HRESULT,
    fn put_Radius(&self, value: f64) -> HRESULT,
    fn get_AccentColor(&self, out: *mut super::super::Color) -> HRESULT,
    fn put_AccentColor(&self, value: super::super::Color) -> HRESULT
}}
impl IInkPresenterProtractor {
    #[inline] pub unsafe fn get_are_tick_marks_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AreTickMarksVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_are_tick_marks_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AreTickMarksVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_are_rays_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AreRaysVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_are_rays_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AreRaysVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_center_marker_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCenterMarkerVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_center_marker_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCenterMarkerVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_angle_readout_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAngleReadoutVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_angle_readout_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAngleReadoutVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_resizable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsResizable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_resizable(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsResizable)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_radius(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Radius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_radius(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Radius)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_accent_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AccentColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_accent_color(&self, value: super::super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AccentColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkPresenterProtractor: IInkPresenterProtractor}
impl RtActivatable<IInkPresenterProtractorFactory> for InkPresenterProtractor {}
impl InkPresenterProtractor {
    #[inline] pub fn create(inkPresenter: &InkPresenter) -> Result<ComPtr<InkPresenterProtractor>> { unsafe {
        <Self as RtActivatable<IInkPresenterProtractorFactory>>::get_activation_factory().create(inkPresenter)
    }}
}
DEFINE_CLSID!(InkPresenterProtractor(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,80,114,101,115,101,110,116,101,114,80,114,111,116,114,97,99,116,111,114,0]) [CLSID_InkPresenterProtractor]);
DEFINE_IID!(IID_IInkPresenterProtractorFactory, 838927305, 26874, 18409, 129, 39, 131, 112, 113, 31, 196, 108);
RT_INTERFACE!{static interface IInkPresenterProtractorFactory(IInkPresenterProtractorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenterProtractorFactory] {
    fn Create(&self, inkPresenter: *mut InkPresenter, out: *mut *mut InkPresenterProtractor) -> HRESULT
}}
impl IInkPresenterProtractorFactory {
    #[inline] pub unsafe fn create(&self, inkPresenter: &InkPresenter) -> Result<ComPtr<InkPresenterProtractor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, inkPresenter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkPresenterRuler, 1826258266, 57031, 19927, 135, 122, 33, 51, 241, 131, 212, 138);
RT_INTERFACE!{interface IInkPresenterRuler(IInkPresenterRulerVtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenterRuler] {
    fn get_Length(&self, out: *mut f64) -> HRESULT,
    fn put_Length(&self, value: f64) -> HRESULT,
    fn get_Width(&self, out: *mut f64) -> HRESULT,
    fn put_Width(&self, value: f64) -> HRESULT
}}
impl IInkPresenterRuler {
    #[inline] pub unsafe fn get_length(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Length)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_length(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Length)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Width)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Width)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkPresenterRuler: IInkPresenterRuler}
impl RtActivatable<IInkPresenterRulerFactory> for InkPresenterRuler {}
impl InkPresenterRuler {
    #[inline] pub fn create(inkPresenter: &InkPresenter) -> Result<ComPtr<InkPresenterRuler>> { unsafe {
        <Self as RtActivatable<IInkPresenterRulerFactory>>::get_activation_factory().create(inkPresenter)
    }}
}
DEFINE_CLSID!(InkPresenterRuler(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,80,114,101,115,101,110,116,101,114,82,117,108,101,114,0]) [CLSID_InkPresenterRuler]);
DEFINE_IID!(IID_IInkPresenterRuler2, 1158876609, 48225, 17620, 164, 35, 84, 113, 42, 230, 113, 196);
RT_INTERFACE!{interface IInkPresenterRuler2(IInkPresenterRuler2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenterRuler2] {
    fn get_AreTickMarksVisible(&self, out: *mut bool) -> HRESULT,
    fn put_AreTickMarksVisible(&self, value: bool) -> HRESULT,
    fn get_IsCompassVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsCompassVisible(&self, value: bool) -> HRESULT
}}
impl IInkPresenterRuler2 {
    #[inline] pub unsafe fn get_are_tick_marks_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AreTickMarksVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_are_tick_marks_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AreTickMarksVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_compass_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCompassVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_compass_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCompassVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkPresenterRulerFactory, 875961323, 36865, 19019, 166, 144, 105, 219, 175, 99, 229, 1);
RT_INTERFACE!{static interface IInkPresenterRulerFactory(IInkPresenterRulerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenterRulerFactory] {
    fn Create(&self, inkPresenter: *mut InkPresenter, out: *mut *mut InkPresenterRuler) -> HRESULT
}}
impl IInkPresenterRulerFactory {
    #[inline] pub unsafe fn create(&self, inkPresenter: &InkPresenter) -> Result<ComPtr<InkPresenterRuler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, inkPresenter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkPresenterStencil, 819015021, 15878, 19714, 177, 22, 39, 127, 181, 216, 173, 220);
RT_INTERFACE!{interface IInkPresenterStencil(IInkPresenterStencilVtbl): IInspectable(IInspectableVtbl) [IID_IInkPresenterStencil] {
    fn get_Kind(&self, out: *mut InkPresenterStencilKind) -> HRESULT,
    fn get_IsVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsVisible(&self, value: bool) -> HRESULT,
    fn get_BackgroundColor(&self, out: *mut super::super::Color) -> HRESULT,
    fn put_BackgroundColor(&self, value: super::super::Color) -> HRESULT,
    fn get_ForegroundColor(&self, out: *mut super::super::Color) -> HRESULT,
    fn put_ForegroundColor(&self, value: super::super::Color) -> HRESULT,
    fn get_Transform(&self, out: *mut ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT,
    fn put_Transform(&self, value: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT
}}
impl IInkPresenterStencil {
    #[inline] pub unsafe fn get_kind(&self) -> Result<InkPresenterStencilKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background_color(&self, value: super::super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackgroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground_color(&self, value: super::super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ForegroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transform(&self) -> Result<::rt::gen::windows::foundation::numerics::Matrix3x2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Transform)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_transform(&self, value: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Transform)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum InkPresenterStencilKind: i32 {
    Other (InkPresenterStencilKind_Other) = 0, Ruler (InkPresenterStencilKind_Ruler) = 1, Protractor (InkPresenterStencilKind_Protractor) = 2,
}}
DEFINE_IID!(IID_IInkRecognitionResult, 910563988, 20584, 16623, 138, 5, 44, 47, 182, 9, 8, 162);
RT_INTERFACE!{interface IInkRecognitionResult(IInkRecognitionResultVtbl): IInspectable(IInspectableVtbl) [IID_IInkRecognitionResult] {
    fn get_BoundingRect(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn GetTextCandidates(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<HString>) -> HRESULT,
    fn GetStrokes(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkStroke>) -> HRESULT
}}
impl IInkRecognitionResult {
    #[inline] pub unsafe fn get_bounding_rect(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_candidates(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTextCandidates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_strokes(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkStroke>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStrokes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkRecognitionResult: IInkRecognitionResult}
RT_ENUM! { enum InkRecognitionTarget: i32 {
    All (InkRecognitionTarget_All) = 0, Selected (InkRecognitionTarget_Selected) = 1, Recent (InkRecognitionTarget_Recent) = 2,
}}
DEFINE_IID!(IID_IInkRecognizer, 125619875, 36941, 17450, 177, 81, 170, 202, 54, 49, 196, 59);
RT_INTERFACE!{interface IInkRecognizer(IInkRecognizerVtbl): IInspectable(IInspectableVtbl) [IID_IInkRecognizer] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT
}}
impl IInkRecognizer {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkRecognizer: IInkRecognizer}
DEFINE_IID!(IID_IInkRecognizerContainer, 2806880817, 32839, 18072, 169, 18, 248, 42, 80, 133, 1, 47);
RT_INTERFACE!{interface IInkRecognizerContainer(IInkRecognizerContainerVtbl): IInspectable(IInspectableVtbl) [IID_IInkRecognizerContainer] {
    fn SetDefaultRecognizer(&self, recognizer: *mut InkRecognizer) -> HRESULT,
    fn RecognizeAsync(&self, strokeCollection: *mut InkStrokeContainer, recognitionTarget: InkRecognitionTarget, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>>) -> HRESULT,
    fn GetRecognizers(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkRecognizer>) -> HRESULT
}}
impl IInkRecognizerContainer {
    #[inline] pub unsafe fn set_default_recognizer(&self, recognizer: &InkRecognizer) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDefaultRecognizer)(self as *const _ as *mut _, recognizer as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn recognize_async(&self, strokeCollection: &InkStrokeContainer, recognitionTarget: InkRecognitionTarget) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RecognizeAsync)(self as *const _ as *mut _, strokeCollection as *const _ as *mut _, recognitionTarget, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recognizers(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkRecognizer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRecognizers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkRecognizerContainer: IInkRecognizerContainer}
impl RtActivatable<IActivationFactory> for InkRecognizerContainer {}
DEFINE_CLSID!(InkRecognizerContainer(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,82,101,99,111,103,110,105,122,101,114,67,111,110,116,97,105,110,101,114,0]) [CLSID_InkRecognizerContainer]);
DEFINE_IID!(IID_IInkStroke, 353652064, 52451, 20431, 157, 82, 17, 81, 138, 182, 175, 212);
RT_INTERFACE!{interface IInkStroke(IInkStrokeVtbl): IInspectable(IInspectableVtbl) [IID_IInkStroke] {
    fn get_DrawingAttributes(&self, out: *mut *mut InkDrawingAttributes) -> HRESULT,
    fn put_DrawingAttributes(&self, value: *mut InkDrawingAttributes) -> HRESULT,
    fn get_BoundingRect(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn get_Selected(&self, out: *mut bool) -> HRESULT,
    fn put_Selected(&self, value: bool) -> HRESULT,
    fn get_Recognized(&self, out: *mut bool) -> HRESULT,
    fn GetRenderingSegments(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkStrokeRenderingSegment>) -> HRESULT,
    fn Clone(&self, out: *mut *mut InkStroke) -> HRESULT
}}
impl IInkStroke {
    #[inline] pub unsafe fn get_drawing_attributes(&self) -> Result<ComPtr<InkDrawingAttributes>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DrawingAttributes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_drawing_attributes(&self, value: &InkDrawingAttributes) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DrawingAttributes)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounding_rect(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Selected)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Selected)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recognized(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Recognized)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rendering_segments(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkStrokeRenderingSegment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRenderingSegments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn clone(&self) -> Result<ComPtr<InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Clone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkStroke: IInkStroke}
DEFINE_IID!(IID_IInkStroke2, 1572463860, 47866, 19937, 137, 211, 32, 27, 30, 215, 216, 155);
RT_INTERFACE!{interface IInkStroke2(IInkStroke2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkStroke2] {
    fn get_PointTransform(&self, out: *mut ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT,
    fn put_PointTransform(&self, value: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT,
    fn GetInkPoints(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkPoint>) -> HRESULT
}}
impl IInkStroke2 {
    #[inline] pub unsafe fn get_point_transform(&self) -> Result<::rt::gen::windows::foundation::numerics::Matrix3x2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointTransform)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_point_transform(&self, value: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PointTransform)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ink_points(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkPoint>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetInkPoints)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkStroke3, 1249932148, 38041, 16669, 161, 196, 104, 133, 93, 3, 214, 95);
RT_INTERFACE!{interface IInkStroke3(IInkStroke3Vtbl): IInspectable(IInspectableVtbl) [IID_IInkStroke3] {
    fn get_Id(&self, out: *mut u32) -> HRESULT,
    fn get_StrokeStartedTime(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn put_StrokeStartedTime(&self, value: *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_StrokeDuration(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>) -> HRESULT,
    fn put_StrokeDuration(&self, value: *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>) -> HRESULT
}}
impl IInkStroke3 {
    #[inline] pub unsafe fn get_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stroke_started_time(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StrokeStartedTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stroke_started_time(&self, value: &::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StrokeStartedTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stroke_duration(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StrokeDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stroke_duration(&self, value: &::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StrokeDuration)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkStrokeBuilder, 2193347036, 7267, 16860, 158, 7, 75, 74, 112, 206, 216, 1);
RT_INTERFACE!{interface IInkStrokeBuilder(IInkStrokeBuilderVtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeBuilder] {
    fn BeginStroke(&self, pointerPoint: *mut super::PointerPoint) -> HRESULT,
    fn AppendToStroke(&self, pointerPoint: *mut super::PointerPoint, out: *mut *mut super::PointerPoint) -> HRESULT,
    fn EndStroke(&self, pointerPoint: *mut super::PointerPoint, out: *mut *mut InkStroke) -> HRESULT,
    fn CreateStroke(&self, points: *mut ::rt::gen::windows::foundation::collections::IIterable<::rt::gen::windows::foundation::Point>, out: *mut *mut InkStroke) -> HRESULT,
    fn SetDefaultDrawingAttributes(&self, drawingAttributes: *mut InkDrawingAttributes) -> HRESULT
}}
impl IInkStrokeBuilder {
    #[inline] pub unsafe fn begin_stroke(&self, pointerPoint: &super::PointerPoint) -> Result<()> {
        let hr = ((*self.lpVtbl).BeginStroke)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn append_to_stroke(&self, pointerPoint: &super::PointerPoint) -> Result<ComPtr<super::PointerPoint>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AppendToStroke)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_stroke(&self, pointerPoint: &super::PointerPoint) -> Result<ComPtr<InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).EndStroke)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_stroke(&self, points: &::rt::gen::windows::foundation::collections::IIterable<::rt::gen::windows::foundation::Point>) -> Result<ComPtr<InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateStroke)(self as *const _ as *mut _, points as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_drawing_attributes(&self, drawingAttributes: &InkDrawingAttributes) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDefaultDrawingAttributes)(self as *const _ as *mut _, drawingAttributes as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkStrokeBuilder: IInkStrokeBuilder}
impl RtActivatable<IActivationFactory> for InkStrokeBuilder {}
DEFINE_CLSID!(InkStrokeBuilder(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,83,116,114,111,107,101,66,117,105,108,100,101,114,0]) [CLSID_InkStrokeBuilder]);
DEFINE_IID!(IID_IInkStrokeBuilder2, 3179461671, 29471, 19644, 187, 191, 109, 70, 128, 68, 241, 229);
RT_INTERFACE!{interface IInkStrokeBuilder2(IInkStrokeBuilder2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeBuilder2] {
    fn CreateStrokeFromInkPoints(&self, inkPoints: *mut ::rt::gen::windows::foundation::collections::IIterable<InkPoint>, transform: ::rt::gen::windows::foundation::numerics::Matrix3x2, out: *mut *mut InkStroke) -> HRESULT
}}
impl IInkStrokeBuilder2 {
    #[inline] pub unsafe fn create_stroke_from_ink_points(&self, inkPoints: &::rt::gen::windows::foundation::collections::IIterable<InkPoint>, transform: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> Result<ComPtr<InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateStrokeFromInkPoints)(self as *const _ as *mut _, inkPoints as *const _ as *mut _, transform, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkStrokeBuilder3, 2999394253, 21618, 18097, 168, 29, 195, 122, 61, 22, 148, 65);
RT_INTERFACE!{interface IInkStrokeBuilder3(IInkStrokeBuilder3Vtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeBuilder3] {
    fn CreateStrokeFromInkPoints(&self, inkPoints: *mut ::rt::gen::windows::foundation::collections::IIterable<InkPoint>, transform: ::rt::gen::windows::foundation::numerics::Matrix3x2, strokeStartedTime: *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>, strokeDuration: *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>, out: *mut *mut InkStroke) -> HRESULT
}}
impl IInkStrokeBuilder3 {
    #[inline] pub unsafe fn create_stroke_from_ink_points(&self, inkPoints: &::rt::gen::windows::foundation::collections::IIterable<InkPoint>, transform: ::rt::gen::windows::foundation::numerics::Matrix3x2, strokeStartedTime: &::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>, strokeDuration: &::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::TimeSpan>) -> Result<ComPtr<InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateStrokeFromInkPoints)(self as *const _ as *mut _, inkPoints as *const _ as *mut _, transform, strokeStartedTime as *const _ as *mut _, strokeDuration as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkStrokeContainer, 581749702, 64169, 20244, 182, 140, 246, 206, 230, 112, 174, 22);
RT_INTERFACE!{interface IInkStrokeContainer(IInkStrokeContainerVtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeContainer] {
    fn get_BoundingRect(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn AddStroke(&self, stroke: *mut InkStroke) -> HRESULT,
    fn DeleteSelected(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn MoveSelected(&self, translation: ::rt::gen::windows::foundation::Point, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn SelectWithPolyLine(&self, polyline: *mut ::rt::gen::windows::foundation::collections::IIterable<::rt::gen::windows::foundation::Point>, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn SelectWithLine(&self, from: ::rt::gen::windows::foundation::Point, to: ::rt::gen::windows::foundation::Point, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn CopySelectedToClipboard(&self) -> HRESULT,
    fn PasteFromClipboard(&self, position: ::rt::gen::windows::foundation::Point, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn CanPasteFromClipboard(&self, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-storage")] fn LoadAsync(&self, inputStream: *mut ::rt::gen::windows::storage::streams::IInputStream, out: *mut *mut ::rt::gen::windows::foundation::IAsyncActionWithProgress<u64>) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy10(&self) -> (),
    #[cfg(feature="windows-storage")] fn SaveAsync(&self, outputStream: *mut ::rt::gen::windows::storage::streams::IOutputStream, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperationWithProgress<u32, u32>) -> HRESULT,
    fn UpdateRecognitionResults(&self, recognitionResults: *mut ::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>) -> HRESULT,
    fn GetStrokes(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkStroke>) -> HRESULT,
    fn GetRecognitionResults(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>) -> HRESULT
}}
impl IInkStrokeContainer {
    #[inline] pub unsafe fn get_bounding_rect(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stroke(&self, stroke: &InkStroke) -> Result<()> {
        let hr = ((*self.lpVtbl).AddStroke)(self as *const _ as *mut _, stroke as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_selected(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).DeleteSelected)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_selected(&self, translation: ::rt::gen::windows::foundation::Point) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveSelected)(self as *const _ as *mut _, translation, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn select_with_poly_line(&self, polyline: &::rt::gen::windows::foundation::collections::IIterable<::rt::gen::windows::foundation::Point>) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SelectWithPolyLine)(self as *const _ as *mut _, polyline as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn select_with_line(&self, from: ::rt::gen::windows::foundation::Point, to: ::rt::gen::windows::foundation::Point) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SelectWithLine)(self as *const _ as *mut _, from, to, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn copy_selected_to_clipboard(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).CopySelectedToClipboard)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn paste_from_clipboard(&self, position: ::rt::gen::windows::foundation::Point) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).PasteFromClipboard)(self as *const _ as *mut _, position, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_paste_from_clipboard(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanPasteFromClipboard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn load_async(&self, inputStream: &::rt::gen::windows::storage::streams::IInputStream) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncActionWithProgress<u64>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LoadAsync)(self as *const _ as *mut _, inputStream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn save_async(&self, outputStream: &::rt::gen::windows::storage::streams::IOutputStream) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperationWithProgress<u32, u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveAsync)(self as *const _ as *mut _, outputStream as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn update_recognition_results(&self, recognitionResults: &::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>) -> Result<()> {
        let hr = ((*self.lpVtbl).UpdateRecognitionResults)(self as *const _ as *mut _, recognitionResults as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_strokes(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkStroke>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStrokes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_recognition_results(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkRecognitionResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRecognitionResults)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkStrokeContainer: IInkStrokeContainer}
impl RtActivatable<IActivationFactory> for InkStrokeContainer {}
DEFINE_CLSID!(InkStrokeContainer(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,73,110,107,83,116,114,111,107,101,67,111,110,116,97,105,110,101,114,0]) [CLSID_InkStrokeContainer]);
DEFINE_IID!(IID_IInkStrokeContainer2, 2298598244, 55862, 19407, 158, 92, 209, 149, 130, 89, 149, 180);
RT_INTERFACE!{interface IInkStrokeContainer2(IInkStrokeContainer2Vtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeContainer2] {
    fn AddStrokes(&self, strokes: *mut ::rt::gen::windows::foundation::collections::IIterable<InkStroke>) -> HRESULT,
    fn Clear(&self) -> HRESULT
}}
impl IInkStrokeContainer2 {
    #[inline] pub unsafe fn add_strokes(&self, strokes: &::rt::gen::windows::foundation::collections::IIterable<InkStroke>) -> Result<()> {
        let hr = ((*self.lpVtbl).AddStrokes)(self as *const _ as *mut _, strokes as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Clear)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkStrokeContainer3, 1023917733, 47850, 19586, 167, 25, 123, 131, 218, 16, 103, 210);
RT_INTERFACE!{interface IInkStrokeContainer3(IInkStrokeContainer3Vtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeContainer3] {
    #[cfg(not(feature="windows-storage"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-storage")] fn SaveWithFormatAsync(&self, outputStream: *mut ::rt::gen::windows::storage::streams::IOutputStream, inkPersistenceFormat: InkPersistenceFormat, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperationWithProgress<u32, u32>) -> HRESULT,
    fn GetStrokeById(&self, id: u32, out: *mut *mut InkStroke) -> HRESULT
}}
impl IInkStrokeContainer3 {
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn save_with_format_async(&self, outputStream: &::rt::gen::windows::storage::streams::IOutputStream, inkPersistenceFormat: InkPersistenceFormat) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperationWithProgress<u32, u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveWithFormatAsync)(self as *const _ as *mut _, outputStream as *const _ as *mut _, inkPersistenceFormat, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stroke_by_id(&self, id: u32) -> Result<ComPtr<InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStrokeById)(self as *const _ as *mut _, id, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkStrokeInput, 3476029051, 24080, 17350, 160, 128, 136, 242, 110, 29, 198, 125);
RT_INTERFACE!{interface IInkStrokeInput(IInkStrokeInputVtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeInput] {
    fn add_StrokeStarted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StrokeStarted(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StrokeContinued(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StrokeContinued(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StrokeEnded(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StrokeEnded(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_StrokeCanceled(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_StrokeCanceled(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn get_InkPresenter(&self, out: *mut *mut InkPresenter) -> HRESULT
}}
impl IInkStrokeInput {
    #[inline] pub unsafe fn add_stroke_started(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StrokeStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stroke_started(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StrokeStarted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stroke_continued(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StrokeContinued)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stroke_continued(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StrokeContinued)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stroke_ended(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StrokeEnded)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stroke_ended(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StrokeEnded)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_stroke_canceled(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkStrokeInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_StrokeCanceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_stroke_canceled(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_StrokeCanceled)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ink_presenter(&self) -> Result<ComPtr<InkPresenter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkPresenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkStrokeInput: IInkStrokeInput}
DEFINE_IID!(IID_IInkStrokeRenderingSegment, 1750142751, 35043, 18298, 162, 250, 86, 159, 95, 31, 155, 213);
RT_INTERFACE!{interface IInkStrokeRenderingSegment(IInkStrokeRenderingSegmentVtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokeRenderingSegment] {
    fn get_Position(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn get_BezierControlPoint1(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn get_BezierControlPoint2(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn get_Pressure(&self, out: *mut f32) -> HRESULT,
    fn get_TiltX(&self, out: *mut f32) -> HRESULT,
    fn get_TiltY(&self, out: *mut f32) -> HRESULT,
    fn get_Twist(&self, out: *mut f32) -> HRESULT
}}
impl IInkStrokeRenderingSegment {
    #[inline] pub unsafe fn get_position(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bezier_control_point1(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BezierControlPoint1)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bezier_control_point2(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BezierControlPoint2)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressure(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Pressure)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tilt_x(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TiltX)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tilt_y(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TiltY)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_twist(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Twist)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InkStrokeRenderingSegment: IInkStrokeRenderingSegment}
DEFINE_IID!(IID_IInkStrokesCollectedEventArgs, 3304321577, 6456, 18780, 180, 217, 109, 228, 176, 141, 72, 17);
RT_INTERFACE!{interface IInkStrokesCollectedEventArgs(IInkStrokesCollectedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokesCollectedEventArgs] {
    fn get_Strokes(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkStroke>) -> HRESULT
}}
impl IInkStrokesCollectedEventArgs {
    #[inline] pub unsafe fn get_strokes(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkStroke>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Strokes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkStrokesCollectedEventArgs: IInkStrokesCollectedEventArgs}
DEFINE_IID!(IID_IInkStrokesErasedEventArgs, 2753653282, 5379, 20159, 143, 245, 45, 232, 69, 132, 168, 170);
RT_INTERFACE!{interface IInkStrokesErasedEventArgs(IInkStrokesErasedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IInkStrokesErasedEventArgs] {
    fn get_Strokes(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkStroke>) -> HRESULT
}}
impl IInkStrokesErasedEventArgs {
    #[inline] pub unsafe fn get_strokes(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkStroke>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Strokes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkStrokesErasedEventArgs: IInkStrokesErasedEventArgs}
DEFINE_IID!(IID_IInkSynchronizer, 2610864480, 44699, 17913, 132, 7, 75, 73, 59, 22, 54, 97);
RT_INTERFACE!{interface IInkSynchronizer(IInkSynchronizerVtbl): IInspectable(IInspectableVtbl) [IID_IInkSynchronizer] {
    fn BeginDry(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<InkStroke>) -> HRESULT,
    fn EndDry(&self) -> HRESULT
}}
impl IInkSynchronizer {
    #[inline] pub unsafe fn begin_dry(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<InkStroke>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).BeginDry)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_dry(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).EndDry)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class InkSynchronizer: IInkSynchronizer}
DEFINE_IID!(IID_IInkUnprocessedInput, 3678684640, 33688, 18721, 172, 59, 171, 151, 140, 91, 162, 86);
RT_INTERFACE!{interface IInkUnprocessedInput(IInkUnprocessedInputVtbl): IInspectable(IInspectableVtbl) [IID_IInkUnprocessedInput] {
    fn add_PointerEntered(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerEntered(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerHovered(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerHovered(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerExited(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerExited(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerPressed(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerPressed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerMoved(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerMoved(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerReleased(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerReleased(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerLost(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerLost(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn get_InkPresenter(&self, out: *mut *mut InkPresenter) -> HRESULT
}}
impl IInkUnprocessedInput {
    #[inline] pub unsafe fn add_pointer_entered(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerEntered)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_entered(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerEntered)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_hovered(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerHovered)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_hovered(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerHovered)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_exited(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerExited)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_exited(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerExited)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_pressed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerPressed)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_pressed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerPressed)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_moved(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerMoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_moved(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerMoved)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_released(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerReleased)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_released(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerReleased)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_lost(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<InkUnprocessedInput, super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerLost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_lost(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerLost)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ink_presenter(&self) -> Result<ComPtr<InkPresenter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkPresenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkUnprocessedInput: IInkUnprocessedInput}
RT_ENUM! { enum PenTipShape: i32 {
    Circle (PenTipShape_Circle) = 0, Rectangle (PenTipShape_Rectangle) = 1,
}}
pub mod analysis { // Windows.UI.Input.Inking.Analysis
use ::prelude::*;
RT_ENUM! { enum InkAnalysisDrawingKind: i32 {
    Drawing (InkAnalysisDrawingKind_Drawing) = 0, Circle (InkAnalysisDrawingKind_Circle) = 1, Ellipse (InkAnalysisDrawingKind_Ellipse) = 2, Triangle (InkAnalysisDrawingKind_Triangle) = 3, IsoscelesTriangle (InkAnalysisDrawingKind_IsoscelesTriangle) = 4, EquilateralTriangle (InkAnalysisDrawingKind_EquilateralTriangle) = 5, RightTriangle (InkAnalysisDrawingKind_RightTriangle) = 6, Quadrilateral (InkAnalysisDrawingKind_Quadrilateral) = 7, Rectangle (InkAnalysisDrawingKind_Rectangle) = 8, Square (InkAnalysisDrawingKind_Square) = 9, Diamond (InkAnalysisDrawingKind_Diamond) = 10, Trapezoid (InkAnalysisDrawingKind_Trapezoid) = 11, Parallelogram (InkAnalysisDrawingKind_Parallelogram) = 12, Pentagon (InkAnalysisDrawingKind_Pentagon) = 13, Hexagon (InkAnalysisDrawingKind_Hexagon) = 14,
}}
DEFINE_IID!(IID_IInkAnalysisInkBullet, 3993277288, 24848, 16694, 149, 249, 238, 128, 159, 194, 0, 48);
RT_INTERFACE!{interface IInkAnalysisInkBullet(IInkAnalysisInkBulletVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisInkBullet] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT
}}
impl IInkAnalysisInkBullet {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisInkBullet: IInkAnalysisInkBullet}
DEFINE_IID!(IID_IInkAnalysisInkDrawing, 1787161887, 8164, 19989, 137, 140, 142, 17, 35, 119, 224, 33);
RT_INTERFACE!{interface IInkAnalysisInkDrawing(IInkAnalysisInkDrawingVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisInkDrawing] {
    fn get_DrawingKind(&self, out: *mut InkAnalysisDrawingKind) -> HRESULT,
    fn get_Center(&self, out: *mut ::rt::gen::windows::foundation::Point) -> HRESULT,
    fn get_Points(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::Point>) -> HRESULT
}}
impl IInkAnalysisInkDrawing {
    #[inline] pub unsafe fn get_drawing_kind(&self) -> Result<InkAnalysisDrawingKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DrawingKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_center(&self) -> Result<::rt::gen::windows::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Center)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_points(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::Point>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Points)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisInkDrawing: IInkAnalysisInkDrawing}
DEFINE_IID!(IID_IInkAnalysisInkWord, 1272064173, 33711, 16436, 143, 59, 248, 104, 125, 255, 244, 54);
RT_INTERFACE!{interface IInkAnalysisInkWord(IInkAnalysisInkWordVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisInkWord] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TextAlternates(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<HString>) -> HRESULT
}}
impl IInkAnalysisInkWord {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_alternates(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextAlternates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisInkWord: IInkAnalysisInkWord}
DEFINE_IID!(IID_IInkAnalysisLine, 2691499149, 11149, 18260, 173, 90, 208, 135, 17, 147, 169, 86);
RT_INTERFACE!{interface IInkAnalysisLine(IInkAnalysisLineVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisLine] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_IndentLevel(&self, out: *mut i32) -> HRESULT
}}
impl IInkAnalysisLine {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_indent_level(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IndentLevel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisLine: IInkAnalysisLine}
DEFINE_IID!(IID_IInkAnalysisListItem, 3034825279, 50371, 19514, 161, 166, 157, 133, 84, 126, 229, 134);
RT_INTERFACE!{interface IInkAnalysisListItem(IInkAnalysisListItemVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisListItem] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT
}}
impl IInkAnalysisListItem {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisListItem: IInkAnalysisListItem}
DEFINE_IID!(IID_IInkAnalysisNode, 813899525, 24420, 18988, 186, 55, 79, 72, 135, 135, 149, 116);
RT_INTERFACE!{interface IInkAnalysisNode(IInkAnalysisNodeVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisNode] {
    fn get_Id(&self, out: *mut u32) -> HRESULT,
    fn get_Kind(&self, out: *mut InkAnalysisNodeKind) -> HRESULT,
    fn get_BoundingRect(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn get_RotatedBoundingRect(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::Point>) -> HRESULT,
    fn get_Children(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IInkAnalysisNode>) -> HRESULT,
    fn get_Parent(&self, out: *mut *mut IInkAnalysisNode) -> HRESULT,
    fn GetStrokeIds(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<u32>) -> HRESULT
}}
impl IInkAnalysisNode {
    #[inline] pub unsafe fn get_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kind(&self) -> Result<InkAnalysisNodeKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounding_rect(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rotated_bounding_rect(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::Point>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RotatedBoundingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_children(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IInkAnalysisNode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Children)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_parent(&self) -> Result<ComPtr<IInkAnalysisNode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Parent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stroke_ids(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<u32>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetStrokeIds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisNode: IInkAnalysisNode}
RT_ENUM! { enum InkAnalysisNodeKind: i32 {
    UnclassifiedInk (InkAnalysisNodeKind_UnclassifiedInk) = 0, Root (InkAnalysisNodeKind_Root) = 1, WritingRegion (InkAnalysisNodeKind_WritingRegion) = 2, Paragraph (InkAnalysisNodeKind_Paragraph) = 3, Line (InkAnalysisNodeKind_Line) = 4, InkWord (InkAnalysisNodeKind_InkWord) = 5, InkBullet (InkAnalysisNodeKind_InkBullet) = 6, InkDrawing (InkAnalysisNodeKind_InkDrawing) = 7, ListItem (InkAnalysisNodeKind_ListItem) = 8,
}}
DEFINE_IID!(IID_IInkAnalysisParagraph, 3651994716, 3281, 19924, 166, 139, 235, 31, 18, 179, 215, 39);
RT_INTERFACE!{interface IInkAnalysisParagraph(IInkAnalysisParagraphVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisParagraph] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT
}}
impl IInkAnalysisParagraph {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisParagraph: IInkAnalysisParagraph}
DEFINE_IID!(IID_IInkAnalysisResult, 2303244921, 41539, 19107, 162, 148, 31, 152, 189, 15, 245, 128);
RT_INTERFACE!{interface IInkAnalysisResult(IInkAnalysisResultVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisResult] {
    fn get_Status(&self, out: *mut InkAnalysisStatus) -> HRESULT
}}
impl IInkAnalysisResult {
    #[inline] pub unsafe fn get_status(&self) -> Result<InkAnalysisStatus> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Status)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisResult: IInkAnalysisResult}
DEFINE_IID!(IID_IInkAnalysisRoot, 1068934084, 12254, 16481, 133, 2, 169, 15, 50, 84, 91, 132);
RT_INTERFACE!{interface IInkAnalysisRoot(IInkAnalysisRootVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisRoot] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT,
    fn FindNodes(&self, nodeKind: InkAnalysisNodeKind, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IInkAnalysisNode>) -> HRESULT
}}
impl IInkAnalysisRoot {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_nodes(&self, nodeKind: InkAnalysisNodeKind) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IInkAnalysisNode>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindNodes)(self as *const _ as *mut _, nodeKind, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisRoot: IInkAnalysisRoot}
RT_ENUM! { enum InkAnalysisStatus: i32 {
    Updated (InkAnalysisStatus_Updated) = 0, Unchanged (InkAnalysisStatus_Unchanged) = 1,
}}
RT_ENUM! { enum InkAnalysisStrokeKind: i32 {
    Auto (InkAnalysisStrokeKind_Auto) = 0, Writing (InkAnalysisStrokeKind_Writing) = 1, Drawing (InkAnalysisStrokeKind_Drawing) = 2,
}}
DEFINE_IID!(IID_IInkAnalysisWritingRegion, 3714933297, 48406, 18019, 181, 174, 148, 29, 48, 67, 239, 91);
RT_INTERFACE!{interface IInkAnalysisWritingRegion(IInkAnalysisWritingRegionVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalysisWritingRegion] {
    fn get_RecognizedText(&self, out: *mut HSTRING) -> HRESULT
}}
impl IInkAnalysisWritingRegion {
    #[inline] pub unsafe fn get_recognized_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RecognizedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalysisWritingRegion: IInkAnalysisWritingRegion}
DEFINE_IID!(IID_IInkAnalyzer, 4046163861, 2150, 19909, 140, 119, 248, 134, 20, 223, 227, 140);
RT_INTERFACE!{interface IInkAnalyzer(IInkAnalyzerVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalyzer] {
    fn get_AnalysisRoot(&self, out: *mut *mut InkAnalysisRoot) -> HRESULT,
    fn get_IsAnalyzing(&self, out: *mut bool) -> HRESULT,
    fn AddDataForStroke(&self, stroke: *mut super::InkStroke) -> HRESULT,
    fn AddDataForStrokes(&self, strokes: *mut ::rt::gen::windows::foundation::collections::IIterable<super::InkStroke>) -> HRESULT,
    fn ClearDataForAllStrokes(&self) -> HRESULT,
    fn RemoveDataForStroke(&self, strokeId: u32) -> HRESULT,
    fn RemoveDataForStrokes(&self, strokeIds: *mut ::rt::gen::windows::foundation::collections::IIterable<u32>) -> HRESULT,
    fn ReplaceDataForStroke(&self, stroke: *mut super::InkStroke) -> HRESULT,
    fn SetStrokeDataKind(&self, strokeId: u32, strokeKind: InkAnalysisStrokeKind) -> HRESULT,
    fn AnalyzeAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<InkAnalysisResult>) -> HRESULT
}}
impl IInkAnalyzer {
    #[inline] pub unsafe fn get_analysis_root(&self) -> Result<ComPtr<InkAnalysisRoot>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AnalysisRoot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_analyzing(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAnalyzing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_data_for_stroke(&self, stroke: &super::InkStroke) -> Result<()> {
        let hr = ((*self.lpVtbl).AddDataForStroke)(self as *const _ as *mut _, stroke as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_data_for_strokes(&self, strokes: &::rt::gen::windows::foundation::collections::IIterable<super::InkStroke>) -> Result<()> {
        let hr = ((*self.lpVtbl).AddDataForStrokes)(self as *const _ as *mut _, strokes as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_data_for_all_strokes(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ClearDataForAllStrokes)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_data_for_stroke(&self, strokeId: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveDataForStroke)(self as *const _ as *mut _, strokeId);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_data_for_strokes(&self, strokeIds: &::rt::gen::windows::foundation::collections::IIterable<u32>) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveDataForStrokes)(self as *const _ as *mut _, strokeIds as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn replace_data_for_stroke(&self, stroke: &super::InkStroke) -> Result<()> {
        let hr = ((*self.lpVtbl).ReplaceDataForStroke)(self as *const _ as *mut _, stroke as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stroke_data_kind(&self, strokeId: u32, strokeKind: InkAnalysisStrokeKind) -> Result<()> {
        let hr = ((*self.lpVtbl).SetStrokeDataKind)(self as *const _ as *mut _, strokeId, strokeKind);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn analyze_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<InkAnalysisResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).AnalyzeAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkAnalyzer: IInkAnalyzer}
impl RtActivatable<IActivationFactory> for InkAnalyzer {}
DEFINE_CLSID!(InkAnalyzer(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,65,110,97,108,121,115,105,115,46,73,110,107,65,110,97,108,121,122,101,114,0]) [CLSID_InkAnalyzer]);
DEFINE_IID!(IID_IInkAnalyzerFactory, 689145478, 6499, 18904, 149, 137, 225, 67, 132, 199, 105, 227);
RT_INTERFACE!{interface IInkAnalyzerFactory(IInkAnalyzerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IInkAnalyzerFactory] {
    fn CreateAnalyzer(&self, out: *mut *mut InkAnalyzer) -> HRESULT
}}
impl IInkAnalyzerFactory {
    #[inline] pub unsafe fn create_analyzer(&self) -> Result<ComPtr<InkAnalyzer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAnalyzer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.Input.Inking.Analysis
pub mod core { // Windows.UI.Input.Inking.Core
use ::prelude::*;
DEFINE_IID!(IID_ICoreIncrementalInkStroke, 4255126995, 40294, 20349, 165, 127, 204, 112, 185, 207, 170, 118);
RT_INTERFACE!{interface ICoreIncrementalInkStroke(ICoreIncrementalInkStrokeVtbl): IInspectable(IInspectableVtbl) [IID_ICoreIncrementalInkStroke] {
    fn AppendInkPoints(&self, inkPoints: *mut ::rt::gen::windows::foundation::collections::IIterable<super::InkPoint>, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn CreateInkStroke(&self, out: *mut *mut super::InkStroke) -> HRESULT,
    fn get_DrawingAttributes(&self, out: *mut *mut super::InkDrawingAttributes) -> HRESULT,
    fn get_PointTransform(&self, out: *mut ::rt::gen::windows::foundation::numerics::Matrix3x2) -> HRESULT,
    fn get_BoundingRect(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT
}}
impl ICoreIncrementalInkStroke {
    #[inline] pub unsafe fn append_ink_points(&self, inkPoints: &::rt::gen::windows::foundation::collections::IIterable<super::InkPoint>) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).AppendInkPoints)(self as *const _ as *mut _, inkPoints as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_ink_stroke(&self) -> Result<ComPtr<super::InkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInkStroke)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drawing_attributes(&self) -> Result<ComPtr<super::InkDrawingAttributes>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DrawingAttributes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_point_transform(&self) -> Result<::rt::gen::windows::foundation::numerics::Matrix3x2> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointTransform)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bounding_rect(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BoundingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CoreIncrementalInkStroke: ICoreIncrementalInkStroke}
impl RtActivatable<ICoreIncrementalInkStrokeFactory> for CoreIncrementalInkStroke {}
impl CoreIncrementalInkStroke {
    #[inline] pub fn create(drawingAttributes: &super::InkDrawingAttributes, pointTransform: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> Result<ComPtr<CoreIncrementalInkStroke>> { unsafe {
        <Self as RtActivatable<ICoreIncrementalInkStrokeFactory>>::get_activation_factory().create(drawingAttributes, pointTransform)
    }}
}
DEFINE_CLSID!(CoreIncrementalInkStroke(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,67,111,114,101,46,67,111,114,101,73,110,99,114,101,109,101,110,116,97,108,73,110,107,83,116,114,111,107,101,0]) [CLSID_CoreIncrementalInkStroke]);
DEFINE_IID!(IID_ICoreIncrementalInkStrokeFactory, 3620052806, 36264, 20336, 151, 81, 229, 59, 182, 223, 69, 150);
RT_INTERFACE!{static interface ICoreIncrementalInkStrokeFactory(ICoreIncrementalInkStrokeFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICoreIncrementalInkStrokeFactory] {
    fn Create(&self, drawingAttributes: *mut super::InkDrawingAttributes, pointTransform: ::rt::gen::windows::foundation::numerics::Matrix3x2, out: *mut *mut CoreIncrementalInkStroke) -> HRESULT
}}
impl ICoreIncrementalInkStrokeFactory {
    #[inline] pub unsafe fn create(&self, drawingAttributes: &super::InkDrawingAttributes, pointTransform: ::rt::gen::windows::foundation::numerics::Matrix3x2) -> Result<ComPtr<CoreIncrementalInkStroke>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, drawingAttributes as *const _ as *mut _, pointTransform, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreInkIndependentInputSource, 968068521, 30265, 17561, 165, 181, 25, 29, 0, 227, 91, 22);
RT_INTERFACE!{interface ICoreInkIndependentInputSource(ICoreInkIndependentInputSourceVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInkIndependentInputSource] {
    fn add_PointerEntering(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerEntering(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerHovering(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerHovering(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerExiting(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerExiting(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerPressing(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerPressing(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerMoving(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerMoving(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerReleasing(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerReleasing(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerLost(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerLost(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn get_InkPresenter(&self, out: *mut *mut super::InkPresenter) -> HRESULT
}}
impl ICoreInkIndependentInputSource {
    #[inline] pub unsafe fn add_pointer_entering(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerEntering)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_entering(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerEntering)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_hovering(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerHovering)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_hovering(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerHovering)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_exiting(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerExiting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_exiting(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerExiting)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_pressing(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerPressing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_pressing(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerPressing)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_moving(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerMoving)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_moving(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerMoving)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_releasing(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerReleasing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_releasing(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerReleasing)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_lost(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInkIndependentInputSource, super::super::super::core::PointerEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerLost)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_lost(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerLost)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ink_presenter(&self) -> Result<ComPtr<super::InkPresenter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkPresenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreInkIndependentInputSource: ICoreInkIndependentInputSource}
impl RtActivatable<ICoreInkIndependentInputSourceStatics> for CoreInkIndependentInputSource {}
impl CoreInkIndependentInputSource {
    #[inline] pub fn create(inkPresenter: &super::InkPresenter) -> Result<ComPtr<CoreInkIndependentInputSource>> { unsafe {
        <Self as RtActivatable<ICoreInkIndependentInputSourceStatics>>::get_activation_factory().create(inkPresenter)
    }}
}
DEFINE_CLSID!(CoreInkIndependentInputSource(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,67,111,114,101,46,67,111,114,101,73,110,107,73,110,100,101,112,101,110,100,101,110,116,73,110,112,117,116,83,111,117,114,99,101,0]) [CLSID_CoreInkIndependentInputSource]);
DEFINE_IID!(IID_ICoreInkIndependentInputSourceStatics, 1944453403, 32960, 19963, 155, 102, 16, 186, 127, 63, 156, 132);
RT_INTERFACE!{static interface ICoreInkIndependentInputSourceStatics(ICoreInkIndependentInputSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInkIndependentInputSourceStatics] {
    fn Create(&self, inkPresenter: *mut super::InkPresenter, out: *mut *mut CoreInkIndependentInputSource) -> HRESULT
}}
impl ICoreInkIndependentInputSourceStatics {
    #[inline] pub unsafe fn create(&self, inkPresenter: &super::InkPresenter) -> Result<ComPtr<CoreInkIndependentInputSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, inkPresenter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreInkPresenterHost, 963545574, 32085, 17943, 158, 88, 104, 199, 12, 145, 105, 185);
RT_INTERFACE!{interface ICoreInkPresenterHost(ICoreInkPresenterHostVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInkPresenterHost] {
    fn get_InkPresenter(&self, out: *mut *mut super::InkPresenter) -> HRESULT,
    fn get_RootVisual(&self, out: *mut *mut super::super::super::composition::ContainerVisual) -> HRESULT,
    fn put_RootVisual(&self, value: *mut super::super::super::composition::ContainerVisual) -> HRESULT
}}
impl ICoreInkPresenterHost {
    #[inline] pub unsafe fn get_ink_presenter(&self) -> Result<ComPtr<super::InkPresenter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkPresenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_root_visual(&self) -> Result<ComPtr<super::super::super::composition::ContainerVisual>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RootVisual)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_root_visual(&self, value: &super::super::super::composition::ContainerVisual) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RootVisual)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreInkPresenterHost: ICoreInkPresenterHost}
impl RtActivatable<IActivationFactory> for CoreInkPresenterHost {}
DEFINE_CLSID!(CoreInkPresenterHost(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,67,111,114,101,46,67,111,114,101,73,110,107,80,114,101,115,101,110,116,101,114,72,111,115,116,0]) [CLSID_CoreInkPresenterHost]);
RT_ENUM! { enum CoreWetStrokeDisposition: i32 {
    Inking (CoreWetStrokeDisposition_Inking) = 0, Completed (CoreWetStrokeDisposition_Completed) = 1, Canceled (CoreWetStrokeDisposition_Canceled) = 2,
}}
DEFINE_IID!(IID_ICoreWetStrokeUpdateEventArgs, 4211593548, 13184, 17786, 169, 135, 153, 19, 87, 137, 108, 27);
RT_INTERFACE!{interface ICoreWetStrokeUpdateEventArgs(ICoreWetStrokeUpdateEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWetStrokeUpdateEventArgs] {
    fn get_NewInkPoints(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<super::InkPoint>) -> HRESULT,
    fn get_PointerId(&self, out: *mut u32) -> HRESULT,
    fn get_Disposition(&self, out: *mut CoreWetStrokeDisposition) -> HRESULT,
    fn put_Disposition(&self, value: CoreWetStrokeDisposition) -> HRESULT
}}
impl ICoreWetStrokeUpdateEventArgs {
    #[inline] pub unsafe fn get_new_ink_points(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<super::InkPoint>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewInkPoints)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_id(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PointerId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_disposition(&self) -> Result<CoreWetStrokeDisposition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Disposition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_disposition(&self, value: CoreWetStrokeDisposition) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Disposition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWetStrokeUpdateEventArgs: ICoreWetStrokeUpdateEventArgs}
DEFINE_IID!(IID_ICoreWetStrokeUpdateSource, 527535650, 61010, 19968, 130, 9, 76, 62, 91, 33, 163, 204);
RT_INTERFACE!{interface ICoreWetStrokeUpdateSource(ICoreWetStrokeUpdateSourceVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWetStrokeUpdateSource] {
    fn add_WetStrokeStarting(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WetStrokeStarting(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_WetStrokeContinuing(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WetStrokeContinuing(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_WetStrokeStopping(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WetStrokeStopping(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_WetStrokeCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WetStrokeCompleted(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_WetStrokeCanceled(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_WetStrokeCanceled(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn get_InkPresenter(&self, out: *mut *mut super::InkPresenter) -> HRESULT
}}
impl ICoreWetStrokeUpdateSource {
    #[inline] pub unsafe fn add_wet_stroke_starting(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WetStrokeStarting)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_wet_stroke_starting(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WetStrokeStarting)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_wet_stroke_continuing(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WetStrokeContinuing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_wet_stroke_continuing(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WetStrokeContinuing)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_wet_stroke_stopping(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WetStrokeStopping)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_wet_stroke_stopping(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WetStrokeStopping)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_wet_stroke_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WetStrokeCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_wet_stroke_completed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WetStrokeCompleted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_wet_stroke_canceled(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreWetStrokeUpdateSource, CoreWetStrokeUpdateEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_WetStrokeCanceled)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_wet_stroke_canceled(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_WetStrokeCanceled)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ink_presenter(&self) -> Result<ComPtr<super::InkPresenter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkPresenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreWetStrokeUpdateSource: ICoreWetStrokeUpdateSource}
impl RtActivatable<ICoreWetStrokeUpdateSourceStatics> for CoreWetStrokeUpdateSource {}
impl CoreWetStrokeUpdateSource {
    #[inline] pub fn create(inkPresenter: &super::InkPresenter) -> Result<ComPtr<CoreWetStrokeUpdateSource>> { unsafe {
        <Self as RtActivatable<ICoreWetStrokeUpdateSourceStatics>>::get_activation_factory().create(inkPresenter)
    }}
}
DEFINE_CLSID!(CoreWetStrokeUpdateSource(&[87,105,110,100,111,119,115,46,85,73,46,73,110,112,117,116,46,73,110,107,105,110,103,46,67,111,114,101,46,67,111,114,101,87,101,116,83,116,114,111,107,101,85,112,100,97,116,101,83,111,117,114,99,101,0]) [CLSID_CoreWetStrokeUpdateSource]);
DEFINE_IID!(IID_ICoreWetStrokeUpdateSourceStatics, 1034788026, 7485, 18094, 171, 157, 134, 71, 72, 108, 111, 144);
RT_INTERFACE!{static interface ICoreWetStrokeUpdateSourceStatics(ICoreWetStrokeUpdateSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreWetStrokeUpdateSourceStatics] {
    fn Create(&self, inkPresenter: *mut super::InkPresenter, out: *mut *mut CoreWetStrokeUpdateSource) -> HRESULT
}}
impl ICoreWetStrokeUpdateSourceStatics {
    #[inline] pub unsafe fn create(&self, inkPresenter: &super::InkPresenter) -> Result<ComPtr<CoreWetStrokeUpdateSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, inkPresenter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.Input.Inking.Core
} // Windows.UI.Input.Inking
} // Windows.UI.Input
pub mod text { // Windows.UI.Text
use ::prelude::*;
RT_ENUM! { enum CaretType: i32 {
    Normal (CaretType_Normal) = 0, Null (CaretType_Null) = 1,
}}
RT_ENUM! { enum FindOptions: u32 {
    None (FindOptions_None) = 0, Word (FindOptions_Word) = 2, Case (FindOptions_Case) = 4,
}}
RT_ENUM! { enum FontStretch: i32 {
    Undefined (FontStretch_Undefined) = 0, UltraCondensed (FontStretch_UltraCondensed) = 1, ExtraCondensed (FontStretch_ExtraCondensed) = 2, Condensed (FontStretch_Condensed) = 3, SemiCondensed (FontStretch_SemiCondensed) = 4, Normal (FontStretch_Normal) = 5, SemiExpanded (FontStretch_SemiExpanded) = 6, Expanded (FontStretch_Expanded) = 7, ExtraExpanded (FontStretch_ExtraExpanded) = 8, UltraExpanded (FontStretch_UltraExpanded) = 9,
}}
RT_ENUM! { enum FontStyle: i32 {
    Normal (FontStyle_Normal) = 0, Oblique (FontStyle_Oblique) = 1, Italic (FontStyle_Italic) = 2,
}}
RT_STRUCT! { struct FontWeight {
    Weight: u16,
}}
DEFINE_IID!(IID_IFontWeights, 2021696580, 427, 18839, 133, 23, 223, 130, 42, 12, 69, 241);
RT_INTERFACE!{interface IFontWeights(IFontWeightsVtbl): IInspectable(IInspectableVtbl) [IID_IFontWeights] {
    
}}
RT_CLASS!{class FontWeights: IFontWeights}
impl RtActivatable<IFontWeightsStatics> for FontWeights {}
impl FontWeights {
    #[inline] pub fn get_black() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_black()
    }}
    #[inline] pub fn get_bold() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_bold()
    }}
    #[inline] pub fn get_extra_black() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_extra_black()
    }}
    #[inline] pub fn get_extra_bold() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_extra_bold()
    }}
    #[inline] pub fn get_extra_light() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_extra_light()
    }}
    #[inline] pub fn get_light() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_light()
    }}
    #[inline] pub fn get_medium() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_medium()
    }}
    #[inline] pub fn get_normal() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_normal()
    }}
    #[inline] pub fn get_semi_bold() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_semi_bold()
    }}
    #[inline] pub fn get_semi_light() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_semi_light()
    }}
    #[inline] pub fn get_thin() -> Result<FontWeight> { unsafe {
        <Self as RtActivatable<IFontWeightsStatics>>::get_activation_factory().get_thin()
    }}
}
DEFINE_CLSID!(FontWeights(&[87,105,110,100,111,119,115,46,85,73,46,84,101,120,116,46,70,111,110,116,87,101,105,103,104,116,115,0]) [CLSID_FontWeights]);
DEFINE_IID!(IID_IFontWeightsStatics, 3015014869, 7081, 18667, 157, 173, 192, 149, 232, 194, 59, 163);
RT_INTERFACE!{static interface IFontWeightsStatics(IFontWeightsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFontWeightsStatics] {
    fn get_Black(&self, out: *mut FontWeight) -> HRESULT,
    fn get_Bold(&self, out: *mut FontWeight) -> HRESULT,
    fn get_ExtraBlack(&self, out: *mut FontWeight) -> HRESULT,
    fn get_ExtraBold(&self, out: *mut FontWeight) -> HRESULT,
    fn get_ExtraLight(&self, out: *mut FontWeight) -> HRESULT,
    fn get_Light(&self, out: *mut FontWeight) -> HRESULT,
    fn get_Medium(&self, out: *mut FontWeight) -> HRESULT,
    fn get_Normal(&self, out: *mut FontWeight) -> HRESULT,
    fn get_SemiBold(&self, out: *mut FontWeight) -> HRESULT,
    fn get_SemiLight(&self, out: *mut FontWeight) -> HRESULT,
    fn get_Thin(&self, out: *mut FontWeight) -> HRESULT
}}
impl IFontWeightsStatics {
    #[inline] pub unsafe fn get_black(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Black)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bold(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bold)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extra_black(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtraBlack)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extra_bold(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtraBold)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extra_light(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExtraLight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_light(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Light)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_medium(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Medium)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_normal(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Normal)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_semi_bold(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SemiBold)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_semi_light(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SemiLight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_thin(&self) -> Result<FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Thin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum FormatEffect: i32 {
    Off (FormatEffect_Off) = 0, On (FormatEffect_On) = 1, Toggle (FormatEffect_Toggle) = 2, Undefined (FormatEffect_Undefined) = 3,
}}
RT_ENUM! { enum HorizontalCharacterAlignment: i32 {
    Left (HorizontalCharacterAlignment_Left) = 0, Right (HorizontalCharacterAlignment_Right) = 1, Center (HorizontalCharacterAlignment_Center) = 2,
}}
RT_ENUM! { enum LetterCase: i32 {
    Lower (LetterCase_Lower) = 0, Upper (LetterCase_Upper) = 1,
}}
RT_ENUM! { enum LineSpacingRule: i32 {
    Undefined (LineSpacingRule_Undefined) = 0, Single (LineSpacingRule_Single) = 1, OneAndHalf (LineSpacingRule_OneAndHalf) = 2, Double (LineSpacingRule_Double) = 3, AtLeast (LineSpacingRule_AtLeast) = 4, Exactly (LineSpacingRule_Exactly) = 5, Multiple (LineSpacingRule_Multiple) = 6, Percent (LineSpacingRule_Percent) = 7,
}}
RT_ENUM! { enum LinkType: i32 {
    Undefined (LinkType_Undefined) = 0, NotALink (LinkType_NotALink) = 1, ClientLink (LinkType_ClientLink) = 2, FriendlyLinkName (LinkType_FriendlyLinkName) = 3, FriendlyLinkAddress (LinkType_FriendlyLinkAddress) = 4, AutoLink (LinkType_AutoLink) = 5, AutoLinkEmail (LinkType_AutoLinkEmail) = 6, AutoLinkPhone (LinkType_AutoLinkPhone) = 7, AutoLinkPath (LinkType_AutoLinkPath) = 8,
}}
RT_ENUM! { enum MarkerAlignment: i32 {
    Undefined (MarkerAlignment_Undefined) = 0, Left (MarkerAlignment_Left) = 1, Center (MarkerAlignment_Center) = 2, Right (MarkerAlignment_Right) = 3,
}}
RT_ENUM! { enum MarkerStyle: i32 {
    Undefined (MarkerStyle_Undefined) = 0, Parenthesis (MarkerStyle_Parenthesis) = 1, Parentheses (MarkerStyle_Parentheses) = 2, Period (MarkerStyle_Period) = 3, Plain (MarkerStyle_Plain) = 4, Minus (MarkerStyle_Minus) = 5, NoNumber (MarkerStyle_NoNumber) = 6,
}}
RT_ENUM! { enum MarkerType: i32 {
    Undefined (MarkerType_Undefined) = 0, None (MarkerType_None) = 1, Bullet (MarkerType_Bullet) = 2, Arabic (MarkerType_Arabic) = 3, LowercaseEnglishLetter (MarkerType_LowercaseEnglishLetter) = 4, UppercaseEnglishLetter (MarkerType_UppercaseEnglishLetter) = 5, LowercaseRoman (MarkerType_LowercaseRoman) = 6, UppercaseRoman (MarkerType_UppercaseRoman) = 7, UnicodeSequence (MarkerType_UnicodeSequence) = 8, CircledNumber (MarkerType_CircledNumber) = 9, BlackCircleWingding (MarkerType_BlackCircleWingding) = 10, WhiteCircleWingding (MarkerType_WhiteCircleWingding) = 11, ArabicWide (MarkerType_ArabicWide) = 12, SimplifiedChinese (MarkerType_SimplifiedChinese) = 13, TraditionalChinese (MarkerType_TraditionalChinese) = 14, JapanSimplifiedChinese (MarkerType_JapanSimplifiedChinese) = 15, JapanKorea (MarkerType_JapanKorea) = 16, ArabicDictionary (MarkerType_ArabicDictionary) = 17, ArabicAbjad (MarkerType_ArabicAbjad) = 18, Hebrew (MarkerType_Hebrew) = 19, ThaiAlphabetic (MarkerType_ThaiAlphabetic) = 20, ThaiNumeric (MarkerType_ThaiNumeric) = 21, DevanagariVowel (MarkerType_DevanagariVowel) = 22, DevanagariConsonant (MarkerType_DevanagariConsonant) = 23, DevanagariNumeric (MarkerType_DevanagariNumeric) = 24,
}}
RT_ENUM! { enum ParagraphAlignment: i32 {
    Undefined (ParagraphAlignment_Undefined) = 0, Left (ParagraphAlignment_Left) = 1, Center (ParagraphAlignment_Center) = 2, Right (ParagraphAlignment_Right) = 3, Justify (ParagraphAlignment_Justify) = 4,
}}
RT_ENUM! { enum ParagraphStyle: i32 {
    Undefined (ParagraphStyle_Undefined) = 0, None (ParagraphStyle_None) = 1, Normal (ParagraphStyle_Normal) = 2, Heading1 (ParagraphStyle_Heading1) = 3, Heading2 (ParagraphStyle_Heading2) = 4, Heading3 (ParagraphStyle_Heading3) = 5, Heading4 (ParagraphStyle_Heading4) = 6, Heading5 (ParagraphStyle_Heading5) = 7, Heading6 (ParagraphStyle_Heading6) = 8, Heading7 (ParagraphStyle_Heading7) = 9, Heading8 (ParagraphStyle_Heading8) = 10, Heading9 (ParagraphStyle_Heading9) = 11,
}}
RT_ENUM! { enum PointOptions: u32 {
    None (PointOptions_None) = 0, IncludeInset (PointOptions_IncludeInset) = 1, Start (PointOptions_Start) = 32, ClientCoordinates (PointOptions_ClientCoordinates) = 256, AllowOffClient (PointOptions_AllowOffClient) = 512, Transform (PointOptions_Transform) = 1024, NoHorizontalScroll (PointOptions_NoHorizontalScroll) = 65536, NoVerticalScroll (PointOptions_NoVerticalScroll) = 262144,
}}
RT_ENUM! { enum RangeGravity: i32 {
    UIBehavior (RangeGravity_UIBehavior) = 0, Backward (RangeGravity_Backward) = 1, Forward (RangeGravity_Forward) = 2, Inward (RangeGravity_Inward) = 3, Outward (RangeGravity_Outward) = 4,
}}
RT_CLASS!{class RichEditTextDocument: ITextDocument}
RT_ENUM! { enum SelectionOptions: u32 {
    StartActive (SelectionOptions_StartActive) = 1, AtEndOfLine (SelectionOptions_AtEndOfLine) = 2, Overtype (SelectionOptions_Overtype) = 4, Active (SelectionOptions_Active) = 8, Replace (SelectionOptions_Replace) = 16,
}}
RT_ENUM! { enum SelectionType: i32 {
    None (SelectionType_None) = 0, InsertionPoint (SelectionType_InsertionPoint) = 1, Normal (SelectionType_Normal) = 2, InlineShape (SelectionType_InlineShape) = 7, Shape (SelectionType_Shape) = 8,
}}
RT_ENUM! { enum TabAlignment: i32 {
    Left (TabAlignment_Left) = 0, Center (TabAlignment_Center) = 1, Right (TabAlignment_Right) = 2, Decimal (TabAlignment_Decimal) = 3, Bar (TabAlignment_Bar) = 4,
}}
RT_ENUM! { enum TabLeader: i32 {
    Spaces (TabLeader_Spaces) = 0, Dots (TabLeader_Dots) = 1, Dashes (TabLeader_Dashes) = 2, Lines (TabLeader_Lines) = 3, ThickLines (TabLeader_ThickLines) = 4, Equals (TabLeader_Equals) = 5,
}}
DEFINE_IID!(IID_ITextCharacterFormat, 1524560859, 1531, 17453, 128, 101, 100, 42, 254, 160, 44, 237);
RT_INTERFACE!{interface ITextCharacterFormat(ITextCharacterFormatVtbl): IInspectable(IInspectableVtbl) [IID_ITextCharacterFormat] {
    fn get_AllCaps(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_AllCaps(&self, value: FormatEffect) -> HRESULT,
    fn get_BackgroundColor(&self, out: *mut super::Color) -> HRESULT,
    fn put_BackgroundColor(&self, value: super::Color) -> HRESULT,
    fn get_Bold(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Bold(&self, value: FormatEffect) -> HRESULT,
    fn get_FontStretch(&self, out: *mut FontStretch) -> HRESULT,
    fn put_FontStretch(&self, value: FontStretch) -> HRESULT,
    fn get_FontStyle(&self, out: *mut FontStyle) -> HRESULT,
    fn put_FontStyle(&self, value: FontStyle) -> HRESULT,
    fn get_ForegroundColor(&self, out: *mut super::Color) -> HRESULT,
    fn put_ForegroundColor(&self, value: super::Color) -> HRESULT,
    fn get_Hidden(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Hidden(&self, value: FormatEffect) -> HRESULT,
    fn get_Italic(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Italic(&self, value: FormatEffect) -> HRESULT,
    fn get_Kerning(&self, out: *mut f32) -> HRESULT,
    fn put_Kerning(&self, value: f32) -> HRESULT,
    fn get_LanguageTag(&self, out: *mut HSTRING) -> HRESULT,
    fn put_LanguageTag(&self, value: HSTRING) -> HRESULT,
    fn get_LinkType(&self, out: *mut LinkType) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_Outline(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Outline(&self, value: FormatEffect) -> HRESULT,
    fn get_Position(&self, out: *mut f32) -> HRESULT,
    fn put_Position(&self, value: f32) -> HRESULT,
    fn get_ProtectedText(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_ProtectedText(&self, value: FormatEffect) -> HRESULT,
    fn get_Size(&self, out: *mut f32) -> HRESULT,
    fn put_Size(&self, value: f32) -> HRESULT,
    fn get_SmallCaps(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_SmallCaps(&self, value: FormatEffect) -> HRESULT,
    fn get_Spacing(&self, out: *mut f32) -> HRESULT,
    fn put_Spacing(&self, value: f32) -> HRESULT,
    fn get_Strikethrough(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Strikethrough(&self, value: FormatEffect) -> HRESULT,
    fn get_Subscript(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Subscript(&self, value: FormatEffect) -> HRESULT,
    fn get_Superscript(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_Superscript(&self, value: FormatEffect) -> HRESULT,
    fn get_TextScript(&self, out: *mut TextScript) -> HRESULT,
    fn put_TextScript(&self, value: TextScript) -> HRESULT,
    fn get_Underline(&self, out: *mut UnderlineType) -> HRESULT,
    fn put_Underline(&self, value: UnderlineType) -> HRESULT,
    fn get_Weight(&self, out: *mut i32) -> HRESULT,
    fn put_Weight(&self, value: i32) -> HRESULT,
    fn SetClone(&self, value: *mut ITextCharacterFormat) -> HRESULT,
    fn GetClone(&self, out: *mut *mut ITextCharacterFormat) -> HRESULT,
    fn IsEqual(&self, format: *mut ITextCharacterFormat, out: *mut bool) -> HRESULT
}}
impl ITextCharacterFormat {
    #[inline] pub unsafe fn get_all_caps(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllCaps)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_all_caps(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllCaps)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_color(&self) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background_color(&self, value: super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackgroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bold(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bold)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bold(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Bold)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_stretch(&self) -> Result<FontStretch> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStretch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_stretch(&self, value: FontStretch) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStretch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_style(&self) -> Result<FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_style(&self, value: FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_color(&self) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground_color(&self, value: super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ForegroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hidden(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Hidden)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_hidden(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Hidden)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_italic(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Italic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_italic(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Italic)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_kerning(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kerning)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_kerning(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Kerning)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language_tag(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LanguageTag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_language_tag(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LanguageTag)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_link_type(&self) -> Result<LinkType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LinkType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_outline(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Outline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_outline(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Outline)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Position)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_position(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Position)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_protected_text(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProtectedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_protected_text(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ProtectedText)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_size(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Size)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_size(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Size)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_small_caps(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SmallCaps)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_small_caps(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SmallCaps)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_spacing(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Spacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_spacing(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Spacing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_strikethrough(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Strikethrough)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_strikethrough(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Strikethrough)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subscript(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Subscript)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_subscript(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Subscript)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_superscript(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Superscript)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_superscript(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Superscript)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_script(&self) -> Result<TextScript> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TextScript)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_script(&self, value: TextScript) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextScript)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_underline(&self) -> Result<UnderlineType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Underline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_underline(&self, value: UnderlineType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Underline)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_weight(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Weight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_weight(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Weight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_clone(&self, value: &ITextCharacterFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).SetClone)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clone(&self) -> Result<ComPtr<ITextCharacterFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetClone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_equal(&self, format: &ITextCharacterFormat) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsEqual)(self as *const _ as *mut _, format as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{static class TextConstants}
impl RtActivatable<ITextConstantsStatics> for TextConstants {}
impl TextConstants {
    #[inline] pub fn get_auto_color() -> Result<super::Color> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_auto_color()
    }}
    #[inline] pub fn get_min_unit_count() -> Result<i32> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_min_unit_count()
    }}
    #[inline] pub fn get_max_unit_count() -> Result<i32> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_max_unit_count()
    }}
    #[inline] pub fn get_undefined_color() -> Result<super::Color> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_undefined_color()
    }}
    #[inline] pub fn get_undefined_float_value() -> Result<f32> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_undefined_float_value()
    }}
    #[inline] pub fn get_undefined_int32_value() -> Result<i32> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_undefined_int32_value()
    }}
    #[inline] pub fn get_undefined_font_stretch() -> Result<FontStretch> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_undefined_font_stretch()
    }}
    #[inline] pub fn get_undefined_font_style() -> Result<FontStyle> { unsafe {
        <Self as RtActivatable<ITextConstantsStatics>>::get_activation_factory().get_undefined_font_style()
    }}
}
DEFINE_CLSID!(TextConstants(&[87,105,110,100,111,119,115,46,85,73,46,84,101,120,116,46,84,101,120,116,67,111,110,115,116,97,110,116,115,0]) [CLSID_TextConstants]);
DEFINE_IID!(IID_ITextConstantsStatics, 2006875187, 6301, 19450, 151, 200, 16, 219, 19, 93, 151, 110);
RT_INTERFACE!{static interface ITextConstantsStatics(ITextConstantsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ITextConstantsStatics] {
    fn get_AutoColor(&self, out: *mut super::Color) -> HRESULT,
    fn get_MinUnitCount(&self, out: *mut i32) -> HRESULT,
    fn get_MaxUnitCount(&self, out: *mut i32) -> HRESULT,
    fn get_UndefinedColor(&self, out: *mut super::Color) -> HRESULT,
    fn get_UndefinedFloatValue(&self, out: *mut f32) -> HRESULT,
    fn get_UndefinedInt32Value(&self, out: *mut i32) -> HRESULT,
    fn get_UndefinedFontStretch(&self, out: *mut FontStretch) -> HRESULT,
    fn get_UndefinedFontStyle(&self, out: *mut FontStyle) -> HRESULT
}}
impl ITextConstantsStatics {
    #[inline] pub unsafe fn get_auto_color(&self) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_unit_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinUnitCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_unit_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxUnitCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_undefined_color(&self) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndefinedColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_undefined_float_value(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndefinedFloatValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_undefined_int32_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndefinedInt32Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_undefined_font_stretch(&self) -> Result<FontStretch> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndefinedFontStretch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_undefined_font_style(&self) -> Result<FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndefinedFontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum TextDecorations: u32 {
    None (TextDecorations_None) = 0, Underline (TextDecorations_Underline) = 1, Strikethrough (TextDecorations_Strikethrough) = 2,
}}
DEFINE_IID!(IID_ITextDocument, 3203288539, 37042, 16524, 162, 246, 10, 10, 195, 30, 51, 228);
RT_INTERFACE!{interface ITextDocument(ITextDocumentVtbl): IInspectable(IInspectableVtbl) [IID_ITextDocument] {
    fn get_CaretType(&self, out: *mut CaretType) -> HRESULT,
    fn put_CaretType(&self, value: CaretType) -> HRESULT,
    fn get_DefaultTabStop(&self, out: *mut f32) -> HRESULT,
    fn put_DefaultTabStop(&self, value: f32) -> HRESULT,
    fn get_Selection(&self, out: *mut *mut ITextSelection) -> HRESULT,
    fn get_UndoLimit(&self, out: *mut u32) -> HRESULT,
    fn put_UndoLimit(&self, value: u32) -> HRESULT,
    fn CanCopy(&self, out: *mut bool) -> HRESULT,
    fn CanPaste(&self, out: *mut bool) -> HRESULT,
    fn CanRedo(&self, out: *mut bool) -> HRESULT,
    fn CanUndo(&self, out: *mut bool) -> HRESULT,
    fn ApplyDisplayUpdates(&self, out: *mut i32) -> HRESULT,
    fn BatchDisplayUpdates(&self, out: *mut i32) -> HRESULT,
    fn BeginUndoGroup(&self) -> HRESULT,
    fn EndUndoGroup(&self) -> HRESULT,
    fn GetDefaultCharacterFormat(&self, out: *mut *mut ITextCharacterFormat) -> HRESULT,
    fn GetDefaultParagraphFormat(&self, out: *mut *mut ITextParagraphFormat) -> HRESULT,
    fn GetRange(&self, startPosition: i32, endPosition: i32, out: *mut *mut ITextRange) -> HRESULT,
    fn GetRangeFromPoint(&self, point: super::super::foundation::Point, options: PointOptions, out: *mut *mut ITextRange) -> HRESULT,
    fn GetText(&self, options: TextGetOptions, value: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy20(&self) -> (),
    #[cfg(feature="windows-storage")] fn LoadFromStream(&self, options: TextSetOptions, value: *mut super::super::storage::streams::IRandomAccessStream) -> HRESULT,
    fn Redo(&self) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy22(&self) -> (),
    #[cfg(feature="windows-storage")] fn SaveToStream(&self, options: TextGetOptions, value: *mut super::super::storage::streams::IRandomAccessStream) -> HRESULT,
    fn SetDefaultCharacterFormat(&self, value: *mut ITextCharacterFormat) -> HRESULT,
    fn SetDefaultParagraphFormat(&self, value: *mut ITextParagraphFormat) -> HRESULT,
    fn SetText(&self, options: TextSetOptions, value: HSTRING) -> HRESULT,
    fn Undo(&self) -> HRESULT
}}
impl ITextDocument {
    #[inline] pub unsafe fn get_caret_type(&self) -> Result<CaretType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaretType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_caret_type(&self, value: CaretType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CaretType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_tab_stop(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultTabStop)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_tab_stop(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultTabStop)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selection(&self) -> Result<ComPtr<ITextSelection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Selection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_undo_limit(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UndoLimit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_undo_limit(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UndoLimit)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_copy(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanCopy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_paste(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanPaste)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_redo(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanRedo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_undo(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanUndo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn apply_display_updates(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ApplyDisplayUpdates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn batch_display_updates(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).BatchDisplayUpdates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn begin_undo_group(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).BeginUndoGroup)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_undo_group(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).EndUndoGroup)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_character_format(&self) -> Result<ComPtr<ITextCharacterFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultCharacterFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_paragraph_format(&self) -> Result<ComPtr<ITextParagraphFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefaultParagraphFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_range(&self, startPosition: i32, endPosition: i32) -> Result<ComPtr<ITextRange>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRange)(self as *const _ as *mut _, startPosition, endPosition, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_range_from_point(&self, point: super::super::foundation::Point, options: PointOptions) -> Result<ComPtr<ITextRange>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetRangeFromPoint)(self as *const _ as *mut _, point, options, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self, options: TextGetOptions) -> Result<HString> {
        let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetText)(self as *const _ as *mut _, options, &mut value);
        if hr == S_OK { Ok(HString::wrap(value)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn load_from_stream(&self, options: TextSetOptions, value: &super::super::storage::streams::IRandomAccessStream) -> Result<()> {
        let hr = ((*self.lpVtbl).LoadFromStream)(self as *const _ as *mut _, options, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn redo(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Redo)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn save_to_stream(&self, options: TextGetOptions, value: &super::super::storage::streams::IRandomAccessStream) -> Result<()> {
        let hr = ((*self.lpVtbl).SaveToStream)(self as *const _ as *mut _, options, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_character_format(&self, value: &ITextCharacterFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDefaultCharacterFormat)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_paragraph_format(&self, value: &ITextParagraphFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDefaultParagraphFormat)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, options: TextSetOptions, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetText)(self as *const _ as *mut _, options, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn undo(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Undo)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITextDocument2, 4063301906, 35977, 18889, 145, 24, 240, 87, 203, 184, 20, 238);
RT_INTERFACE!{interface ITextDocument2(ITextDocument2Vtbl): IInspectable(IInspectableVtbl) [IID_ITextDocument2] {
    fn get_AlignmentIncludesTrailingWhitespace(&self, out: *mut bool) -> HRESULT,
    fn put_AlignmentIncludesTrailingWhitespace(&self, value: bool) -> HRESULT,
    fn get_IgnoreTrailingCharacterSpacing(&self, out: *mut bool) -> HRESULT,
    fn put_IgnoreTrailingCharacterSpacing(&self, value: bool) -> HRESULT
}}
impl ITextDocument2 {
    #[inline] pub unsafe fn get_alignment_includes_trailing_whitespace(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AlignmentIncludesTrailingWhitespace)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_alignment_includes_trailing_whitespace(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AlignmentIncludesTrailingWhitespace)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ignore_trailing_character_spacing(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IgnoreTrailingCharacterSpacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_ignore_trailing_character_spacing(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IgnoreTrailingCharacterSpacing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum TextGetOptions: u32 {
    None (TextGetOptions_None) = 0, AdjustCrlf (TextGetOptions_AdjustCrlf) = 1, UseCrlf (TextGetOptions_UseCrlf) = 2, UseObjectText (TextGetOptions_UseObjectText) = 4, AllowFinalEop (TextGetOptions_AllowFinalEop) = 8, NoHidden (TextGetOptions_NoHidden) = 32, IncludeNumbering (TextGetOptions_IncludeNumbering) = 64, FormatRtf (TextGetOptions_FormatRtf) = 8192, UseLf (TextGetOptions_UseLf) = 16777216,
}}
DEFINE_IID!(IID_ITextParagraphFormat, 754503590, 18038, 18826, 147, 245, 187, 219, 252, 11, 216, 131);
RT_INTERFACE!{interface ITextParagraphFormat(ITextParagraphFormatVtbl): IInspectable(IInspectableVtbl) [IID_ITextParagraphFormat] {
    fn get_Alignment(&self, out: *mut ParagraphAlignment) -> HRESULT,
    fn put_Alignment(&self, value: ParagraphAlignment) -> HRESULT,
    fn get_FirstLineIndent(&self, out: *mut f32) -> HRESULT,
    fn get_KeepTogether(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_KeepTogether(&self, value: FormatEffect) -> HRESULT,
    fn get_KeepWithNext(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_KeepWithNext(&self, value: FormatEffect) -> HRESULT,
    fn get_LeftIndent(&self, out: *mut f32) -> HRESULT,
    fn get_LineSpacing(&self, out: *mut f32) -> HRESULT,
    fn get_LineSpacingRule(&self, out: *mut LineSpacingRule) -> HRESULT,
    fn get_ListAlignment(&self, out: *mut MarkerAlignment) -> HRESULT,
    fn put_ListAlignment(&self, value: MarkerAlignment) -> HRESULT,
    fn get_ListLevelIndex(&self, out: *mut i32) -> HRESULT,
    fn put_ListLevelIndex(&self, value: i32) -> HRESULT,
    fn get_ListStart(&self, out: *mut i32) -> HRESULT,
    fn put_ListStart(&self, value: i32) -> HRESULT,
    fn get_ListStyle(&self, out: *mut MarkerStyle) -> HRESULT,
    fn put_ListStyle(&self, value: MarkerStyle) -> HRESULT,
    fn get_ListTab(&self, out: *mut f32) -> HRESULT,
    fn put_ListTab(&self, value: f32) -> HRESULT,
    fn get_ListType(&self, out: *mut MarkerType) -> HRESULT,
    fn put_ListType(&self, value: MarkerType) -> HRESULT,
    fn get_NoLineNumber(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_NoLineNumber(&self, value: FormatEffect) -> HRESULT,
    fn get_PageBreakBefore(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_PageBreakBefore(&self, value: FormatEffect) -> HRESULT,
    fn get_RightIndent(&self, out: *mut f32) -> HRESULT,
    fn put_RightIndent(&self, value: f32) -> HRESULT,
    fn get_RightToLeft(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_RightToLeft(&self, value: FormatEffect) -> HRESULT,
    fn get_Style(&self, out: *mut ParagraphStyle) -> HRESULT,
    fn put_Style(&self, value: ParagraphStyle) -> HRESULT,
    fn get_SpaceAfter(&self, out: *mut f32) -> HRESULT,
    fn put_SpaceAfter(&self, value: f32) -> HRESULT,
    fn get_SpaceBefore(&self, out: *mut f32) -> HRESULT,
    fn put_SpaceBefore(&self, value: f32) -> HRESULT,
    fn get_WidowControl(&self, out: *mut FormatEffect) -> HRESULT,
    fn put_WidowControl(&self, value: FormatEffect) -> HRESULT,
    fn get_TabCount(&self, out: *mut i32) -> HRESULT,
    fn AddTab(&self, position: f32, align: TabAlignment, leader: TabLeader) -> HRESULT,
    fn ClearAllTabs(&self) -> HRESULT,
    fn DeleteTab(&self, position: f32) -> HRESULT,
    fn GetClone(&self, out: *mut *mut ITextParagraphFormat) -> HRESULT,
    fn GetTab(&self, index: i32, position: *mut f32, align: *mut TabAlignment, leader: *mut TabLeader) -> HRESULT,
    fn IsEqual(&self, format: *mut ITextParagraphFormat, out: *mut bool) -> HRESULT,
    fn SetClone(&self, format: *mut ITextParagraphFormat) -> HRESULT,
    fn SetIndents(&self, start: f32, left: f32, right: f32) -> HRESULT,
    fn SetLineSpacing(&self, rule: LineSpacingRule, spacing: f32) -> HRESULT
}}
impl ITextParagraphFormat {
    #[inline] pub unsafe fn get_alignment(&self) -> Result<ParagraphAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Alignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_alignment(&self, value: ParagraphAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Alignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_line_indent(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstLineIndent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_keep_together(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeepTogether)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_keep_together(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeepTogether)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_keep_with_next(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeepWithNext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_keep_with_next(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeepWithNext)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left_indent(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LeftIndent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_spacing(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineSpacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_spacing_rule(&self) -> Result<LineSpacingRule> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineSpacingRule)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_list_alignment(&self) -> Result<MarkerAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ListAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_list_alignment(&self, value: MarkerAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ListAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_list_level_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ListLevelIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_list_level_index(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ListLevelIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_list_start(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ListStart)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_list_start(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ListStart)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_list_style(&self) -> Result<MarkerStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ListStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_list_style(&self, value: MarkerStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ListStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_list_tab(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ListTab)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_list_tab(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ListTab)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_list_type(&self) -> Result<MarkerType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ListType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_list_type(&self, value: MarkerType) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ListType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_no_line_number(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NoLineNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_no_line_number(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_NoLineNumber)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_page_break_before(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PageBreakBefore)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_page_break_before(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PageBreakBefore)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_indent(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightIndent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_indent(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightIndent)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_to_left(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightToLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_to_left(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightToLeft)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_style(&self) -> Result<ParagraphStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Style)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_style(&self, value: ParagraphStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Style)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_space_after(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpaceAfter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_space_after(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SpaceAfter)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_space_before(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SpaceBefore)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_space_before(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SpaceBefore)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_widow_control(&self) -> Result<FormatEffect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_WidowControl)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_widow_control(&self, value: FormatEffect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WidowControl)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_count(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TabCount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_tab(&self, position: f32, align: TabAlignment, leader: TabLeader) -> Result<()> {
        let hr = ((*self.lpVtbl).AddTab)(self as *const _ as *mut _, position, align, leader);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_all_tabs(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ClearAllTabs)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete_tab(&self, position: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).DeleteTab)(self as *const _ as *mut _, position);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clone(&self) -> Result<ComPtr<ITextParagraphFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetClone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab(&self, index: i32) -> Result<(f32, TabAlignment, TabLeader)> {
        let mut position = zeroed(); let mut align = zeroed(); let mut leader = zeroed();
        let hr = ((*self.lpVtbl).GetTab)(self as *const _ as *mut _, index, &mut position, &mut align, &mut leader);
        if hr == S_OK { Ok((position, align, leader)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_equal(&self, format: &ITextParagraphFormat) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsEqual)(self as *const _ as *mut _, format as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_clone(&self, format: &ITextParagraphFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).SetClone)(self as *const _ as *mut _, format as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_indents(&self, start: f32, left: f32, right: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetIndents)(self as *const _ as *mut _, start, left, right);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_line_spacing(&self, rule: LineSpacingRule, spacing: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetLineSpacing)(self as *const _ as *mut _, rule, spacing);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITextRange, 1537101399, 49266, 17056, 137, 69, 175, 80, 62, 229, 71, 104);
RT_INTERFACE!{interface ITextRange(ITextRangeVtbl): IInspectable(IInspectableVtbl) [IID_ITextRange] {
    fn get_Character(&self, out: *mut Char) -> HRESULT,
    fn put_Character(&self, value: Char) -> HRESULT,
    fn get_CharacterFormat(&self, out: *mut *mut ITextCharacterFormat) -> HRESULT,
    fn put_CharacterFormat(&self, value: *mut ITextCharacterFormat) -> HRESULT,
    fn get_FormattedText(&self, out: *mut *mut ITextRange) -> HRESULT,
    fn put_FormattedText(&self, value: *mut ITextRange) -> HRESULT,
    fn get_EndPosition(&self, out: *mut i32) -> HRESULT,
    fn put_EndPosition(&self, value: i32) -> HRESULT,
    fn get_Gravity(&self, out: *mut RangeGravity) -> HRESULT,
    fn put_Gravity(&self, value: RangeGravity) -> HRESULT,
    fn get_Length(&self, out: *mut i32) -> HRESULT,
    fn get_Link(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Link(&self, value: HSTRING) -> HRESULT,
    fn get_ParagraphFormat(&self, out: *mut *mut ITextParagraphFormat) -> HRESULT,
    fn put_ParagraphFormat(&self, value: *mut ITextParagraphFormat) -> HRESULT,
    fn get_StartPosition(&self, out: *mut i32) -> HRESULT,
    fn put_StartPosition(&self, value: i32) -> HRESULT,
    fn get_StoryLength(&self, out: *mut i32) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn CanPaste(&self, format: i32, out: *mut bool) -> HRESULT,
    fn ChangeCase(&self, value: LetterCase) -> HRESULT,
    fn Collapse(&self, value: bool) -> HRESULT,
    fn Copy(&self) -> HRESULT,
    fn Cut(&self) -> HRESULT,
    fn Delete(&self, unit: TextRangeUnit, count: i32, out: *mut i32) -> HRESULT,
    fn EndOf(&self, unit: TextRangeUnit, extend: bool, out: *mut i32) -> HRESULT,
    fn Expand(&self, unit: TextRangeUnit, out: *mut i32) -> HRESULT,
    fn FindText(&self, value: HSTRING, scanLength: i32, options: FindOptions, out: *mut i32) -> HRESULT,
    fn GetCharacterUtf32(&self, value: *mut u32, offset: i32) -> HRESULT,
    fn GetClone(&self, out: *mut *mut ITextRange) -> HRESULT,
    fn GetIndex(&self, unit: TextRangeUnit, out: *mut i32) -> HRESULT,
    fn GetPoint(&self, horizontalAlign: HorizontalCharacterAlignment, verticalAlign: VerticalCharacterAlignment, options: PointOptions, point: *mut super::super::foundation::Point) -> HRESULT,
    fn GetRect(&self, options: PointOptions, rect: *mut super::super::foundation::Rect, hit: *mut i32) -> HRESULT,
    fn GetText(&self, options: TextGetOptions, value: *mut HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy35(&self) -> (),
    #[cfg(feature="windows-storage")] fn GetTextViaStream(&self, options: TextGetOptions, value: *mut super::super::storage::streams::IRandomAccessStream) -> HRESULT,
    fn InRange(&self, range: *mut ITextRange, out: *mut bool) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy37(&self) -> (),
    #[cfg(feature="windows-storage")] fn InsertImage(&self, width: i32, height: i32, ascent: i32, verticalAlign: VerticalCharacterAlignment, alternateText: HSTRING, value: *mut super::super::storage::streams::IRandomAccessStream) -> HRESULT,
    fn InStory(&self, range: *mut ITextRange, out: *mut bool) -> HRESULT,
    fn IsEqual(&self, range: *mut ITextRange, out: *mut bool) -> HRESULT,
    fn Move(&self, unit: TextRangeUnit, count: i32, out: *mut i32) -> HRESULT,
    fn MoveEnd(&self, unit: TextRangeUnit, count: i32, out: *mut i32) -> HRESULT,
    fn MoveStart(&self, unit: TextRangeUnit, count: i32, out: *mut i32) -> HRESULT,
    fn Paste(&self, format: i32) -> HRESULT,
    fn ScrollIntoView(&self, value: PointOptions) -> HRESULT,
    fn MatchSelection(&self) -> HRESULT,
    fn SetIndex(&self, unit: TextRangeUnit, index: i32, extend: bool) -> HRESULT,
    fn SetPoint(&self, point: super::super::foundation::Point, options: PointOptions, extend: bool) -> HRESULT,
    fn SetRange(&self, startPosition: i32, endPosition: i32) -> HRESULT,
    fn SetText(&self, options: TextSetOptions, value: HSTRING) -> HRESULT,
    #[cfg(not(feature="windows-storage"))] fn __Dummy50(&self) -> (),
    #[cfg(feature="windows-storage")] fn SetTextViaStream(&self, options: TextSetOptions, value: *mut super::super::storage::streams::IRandomAccessStream) -> HRESULT,
    fn StartOf(&self, unit: TextRangeUnit, extend: bool, out: *mut i32) -> HRESULT
}}
impl ITextRange {
    #[inline] pub unsafe fn get_character(&self) -> Result<Char> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Character)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_character(&self, value: Char) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Character)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_format(&self) -> Result<ComPtr<ITextCharacterFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CharacterFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_character_format(&self, value: &ITextCharacterFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CharacterFormat)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_formatted_text(&self) -> Result<ComPtr<ITextRange>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FormattedText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_formatted_text(&self, value: &ITextRange) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FormattedText)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_end_position(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EndPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_end_position(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EndPosition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_gravity(&self) -> Result<RangeGravity> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Gravity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_gravity(&self, value: RangeGravity) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Gravity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Length)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_link(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Link)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_link(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Link)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_paragraph_format(&self) -> Result<ComPtr<ITextParagraphFormat>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ParagraphFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_paragraph_format(&self, value: &ITextParagraphFormat) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ParagraphFormat)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_start_position(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StartPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_start_position(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_StartPosition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_story_length(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_StoryLength)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn can_paste(&self, format: i32) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CanPaste)(self as *const _ as *mut _, format, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn change_case(&self, value: LetterCase) -> Result<()> {
        let hr = ((*self.lpVtbl).ChangeCase)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn collapse(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).Collapse)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn copy(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Copy)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn cut(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Cut)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn delete(&self, unit: TextRangeUnit, count: i32) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Delete)(self as *const _ as *mut _, unit, count, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_of(&self, unit: TextRangeUnit, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).EndOf)(self as *const _ as *mut _, unit, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn expand(&self, unit: TextRangeUnit) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Expand)(self as *const _ as *mut _, unit, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_text(&self, value: &HStringArg, scanLength: i32, options: FindOptions) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FindText)(self as *const _ as *mut _, value.get(), scanLength, options, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_utf32(&self, offset: i32) -> Result<u32> {
        let mut value = zeroed();
        let hr = ((*self.lpVtbl).GetCharacterUtf32)(self as *const _ as *mut _, &mut value, offset);
        if hr == S_OK { Ok(value) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clone(&self) -> Result<ComPtr<ITextRange>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetClone)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_index(&self, unit: TextRangeUnit) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIndex)(self as *const _ as *mut _, unit, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_point(&self, horizontalAlign: HorizontalCharacterAlignment, verticalAlign: VerticalCharacterAlignment, options: PointOptions) -> Result<super::super::foundation::Point> {
        let mut point = zeroed();
        let hr = ((*self.lpVtbl).GetPoint)(self as *const _ as *mut _, horizontalAlign, verticalAlign, options, &mut point);
        if hr == S_OK { Ok(point) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_rect(&self, options: PointOptions) -> Result<(super::super::foundation::Rect, i32)> {
        let mut rect = zeroed(); let mut hit = zeroed();
        let hr = ((*self.lpVtbl).GetRect)(self as *const _ as *mut _, options, &mut rect, &mut hit);
        if hr == S_OK { Ok((rect, hit)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self, options: TextGetOptions) -> Result<HString> {
        let mut value = null_mut();
        let hr = ((*self.lpVtbl).GetText)(self as *const _ as *mut _, options, &mut value);
        if hr == S_OK { Ok(HString::wrap(value)) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn get_text_via_stream(&self, options: TextGetOptions, value: &super::super::storage::streams::IRandomAccessStream) -> Result<()> {
        let hr = ((*self.lpVtbl).GetTextViaStream)(self as *const _ as *mut _, options, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn in_range(&self, range: &ITextRange) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).InRange)(self as *const _ as *mut _, range as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn insert_image(&self, width: i32, height: i32, ascent: i32, verticalAlign: VerticalCharacterAlignment, alternateText: &HStringArg, value: &super::super::storage::streams::IRandomAccessStream) -> Result<()> {
        let hr = ((*self.lpVtbl).InsertImage)(self as *const _ as *mut _, width, height, ascent, verticalAlign, alternateText.get(), value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn in_story(&self, range: &ITextRange) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).InStory)(self as *const _ as *mut _, range as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_equal(&self, range: &ITextRange) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsEqual)(self as *const _ as *mut _, range as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_(&self, unit: TextRangeUnit, count: i32) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Move)(self as *const _ as *mut _, unit, count, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_end(&self, unit: TextRangeUnit, count: i32) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveEnd)(self as *const _ as *mut _, unit, count, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_start(&self, unit: TextRangeUnit, count: i32) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveStart)(self as *const _ as *mut _, unit, count, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn paste(&self, format: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).Paste)(self as *const _ as *mut _, format);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn scroll_into_view(&self, value: PointOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).ScrollIntoView)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn match_selection(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).MatchSelection)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_index(&self, unit: TextRangeUnit, index: i32, extend: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetIndex)(self as *const _ as *mut _, unit, index, extend);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_point(&self, point: super::super::foundation::Point, options: PointOptions, extend: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPoint)(self as *const _ as *mut _, point, options, extend);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_range(&self, startPosition: i32, endPosition: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetRange)(self as *const _ as *mut _, startPosition, endPosition);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, options: TextSetOptions, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetText)(self as *const _ as *mut _, options, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-storage")] #[inline] pub unsafe fn set_text_via_stream(&self, options: TextSetOptions, value: &super::super::storage::streams::IRandomAccessStream) -> Result<()> {
        let hr = ((*self.lpVtbl).SetTextViaStream)(self as *const _ as *mut _, options, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_of(&self, unit: TextRangeUnit, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).StartOf)(self as *const _ as *mut _, unit, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum TextRangeUnit: i32 {
    Character (TextRangeUnit_Character) = 0, Word (TextRangeUnit_Word) = 1, Sentence (TextRangeUnit_Sentence) = 2, Paragraph (TextRangeUnit_Paragraph) = 3, Line (TextRangeUnit_Line) = 4, Story (TextRangeUnit_Story) = 5, Screen (TextRangeUnit_Screen) = 6, Section (TextRangeUnit_Section) = 7, Window (TextRangeUnit_Window) = 8, CharacterFormat (TextRangeUnit_CharacterFormat) = 9, ParagraphFormat (TextRangeUnit_ParagraphFormat) = 10, Object (TextRangeUnit_Object) = 11, HardParagraph (TextRangeUnit_HardParagraph) = 12, Cluster (TextRangeUnit_Cluster) = 13, Bold (TextRangeUnit_Bold) = 14, Italic (TextRangeUnit_Italic) = 15, Underline (TextRangeUnit_Underline) = 16, Strikethrough (TextRangeUnit_Strikethrough) = 17, ProtectedText (TextRangeUnit_ProtectedText) = 18, Link (TextRangeUnit_Link) = 19, SmallCaps (TextRangeUnit_SmallCaps) = 20, AllCaps (TextRangeUnit_AllCaps) = 21, Hidden (TextRangeUnit_Hidden) = 22, Outline (TextRangeUnit_Outline) = 23, Shadow (TextRangeUnit_Shadow) = 24, Imprint (TextRangeUnit_Imprint) = 25, Disabled (TextRangeUnit_Disabled) = 26, Revised (TextRangeUnit_Revised) = 27, Subscript (TextRangeUnit_Subscript) = 28, Superscript (TextRangeUnit_Superscript) = 29, FontBound (TextRangeUnit_FontBound) = 30, LinkProtected (TextRangeUnit_LinkProtected) = 31,
}}
RT_ENUM! { enum TextScript: i32 {
    Undefined (TextScript_Undefined) = 0, Ansi (TextScript_Ansi) = 1, EastEurope (TextScript_EastEurope) = 2, Cyrillic (TextScript_Cyrillic) = 3, Greek (TextScript_Greek) = 4, Turkish (TextScript_Turkish) = 5, Hebrew (TextScript_Hebrew) = 6, Arabic (TextScript_Arabic) = 7, Baltic (TextScript_Baltic) = 8, Vietnamese (TextScript_Vietnamese) = 9, Default (TextScript_Default) = 10, Symbol (TextScript_Symbol) = 11, Thai (TextScript_Thai) = 12, ShiftJis (TextScript_ShiftJis) = 13, GB2312 (TextScript_GB2312) = 14, Hangul (TextScript_Hangul) = 15, Big5 (TextScript_Big5) = 16, PC437 (TextScript_PC437) = 17, Oem (TextScript_Oem) = 18, Mac (TextScript_Mac) = 19, Armenian (TextScript_Armenian) = 20, Syriac (TextScript_Syriac) = 21, Thaana (TextScript_Thaana) = 22, Devanagari (TextScript_Devanagari) = 23, Bengali (TextScript_Bengali) = 24, Gurmukhi (TextScript_Gurmukhi) = 25, Gujarati (TextScript_Gujarati) = 26, Oriya (TextScript_Oriya) = 27, Tamil (TextScript_Tamil) = 28, Telugu (TextScript_Telugu) = 29, Kannada (TextScript_Kannada) = 30, Malayalam (TextScript_Malayalam) = 31, Sinhala (TextScript_Sinhala) = 32, Lao (TextScript_Lao) = 33, Tibetan (TextScript_Tibetan) = 34, Myanmar (TextScript_Myanmar) = 35, Georgian (TextScript_Georgian) = 36, Jamo (TextScript_Jamo) = 37, Ethiopic (TextScript_Ethiopic) = 38, Cherokee (TextScript_Cherokee) = 39, Aboriginal (TextScript_Aboriginal) = 40, Ogham (TextScript_Ogham) = 41, Runic (TextScript_Runic) = 42, Khmer (TextScript_Khmer) = 43, Mongolian (TextScript_Mongolian) = 44, Braille (TextScript_Braille) = 45, Yi (TextScript_Yi) = 46, Limbu (TextScript_Limbu) = 47, TaiLe (TextScript_TaiLe) = 48, NewTaiLue (TextScript_NewTaiLue) = 49, SylotiNagri (TextScript_SylotiNagri) = 50, Kharoshthi (TextScript_Kharoshthi) = 51, Kayahli (TextScript_Kayahli) = 52, UnicodeSymbol (TextScript_UnicodeSymbol) = 53, Emoji (TextScript_Emoji) = 54, Glagolitic (TextScript_Glagolitic) = 55, Lisu (TextScript_Lisu) = 56, Vai (TextScript_Vai) = 57, NKo (TextScript_NKo) = 58, Osmanya (TextScript_Osmanya) = 59, PhagsPa (TextScript_PhagsPa) = 60, Gothic (TextScript_Gothic) = 61, Deseret (TextScript_Deseret) = 62, Tifinagh (TextScript_Tifinagh) = 63,
}}
DEFINE_IID!(IID_ITextSelection, 2798872356, 62095, 17162, 178, 207, 195, 67, 103, 30, 192, 233);
RT_INTERFACE!{interface ITextSelection(ITextSelectionVtbl): IInspectable(IInspectableVtbl) [IID_ITextSelection] {
    fn get_Options(&self, out: *mut SelectionOptions) -> HRESULT,
    fn put_Options(&self, value: SelectionOptions) -> HRESULT,
    fn get_Type(&self, out: *mut SelectionType) -> HRESULT,
    fn EndKey(&self, unit: TextRangeUnit, extend: bool, out: *mut i32) -> HRESULT,
    fn HomeKey(&self, unit: TextRangeUnit, extend: bool, out: *mut i32) -> HRESULT,
    fn MoveDown(&self, unit: TextRangeUnit, count: i32, extend: bool, out: *mut i32) -> HRESULT,
    fn MoveLeft(&self, unit: TextRangeUnit, count: i32, extend: bool, out: *mut i32) -> HRESULT,
    fn MoveRight(&self, unit: TextRangeUnit, count: i32, extend: bool, out: *mut i32) -> HRESULT,
    fn MoveUp(&self, unit: TextRangeUnit, count: i32, extend: bool, out: *mut i32) -> HRESULT,
    fn TypeText(&self, value: HSTRING) -> HRESULT
}}
impl ITextSelection {
    #[inline] pub unsafe fn get_options(&self) -> Result<SelectionOptions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Options)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_options(&self, value: SelectionOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Options)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_type(&self) -> Result<SelectionType> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Type)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn end_key(&self, unit: TextRangeUnit, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).EndKey)(self as *const _ as *mut _, unit, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn home_key(&self, unit: TextRangeUnit, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).HomeKey)(self as *const _ as *mut _, unit, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_down(&self, unit: TextRangeUnit, count: i32, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveDown)(self as *const _ as *mut _, unit, count, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_left(&self, unit: TextRangeUnit, count: i32, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveLeft)(self as *const _ as *mut _, unit, count, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_right(&self, unit: TextRangeUnit, count: i32, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveRight)(self as *const _ as *mut _, unit, count, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn move_up(&self, unit: TextRangeUnit, count: i32, extend: bool) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MoveUp)(self as *const _ as *mut _, unit, count, extend, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn type_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).TypeText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum TextSetOptions: u32 {
    None (TextSetOptions_None) = 0, UnicodeBidi (TextSetOptions_UnicodeBidi) = 1, Unlink (TextSetOptions_Unlink) = 8, Unhide (TextSetOptions_Unhide) = 16, CheckTextLimit (TextSetOptions_CheckTextLimit) = 32, FormatRtf (TextSetOptions_FormatRtf) = 8192, ApplyRtfDocumentDefaults (TextSetOptions_ApplyRtfDocumentDefaults) = 16384,
}}
RT_ENUM! { enum UnderlineType: i32 {
    Undefined (UnderlineType_Undefined) = 0, None (UnderlineType_None) = 1, Single (UnderlineType_Single) = 2, Words (UnderlineType_Words) = 3, Double (UnderlineType_Double) = 4, Dotted (UnderlineType_Dotted) = 5, Dash (UnderlineType_Dash) = 6, DashDot (UnderlineType_DashDot) = 7, DashDotDot (UnderlineType_DashDotDot) = 8, Wave (UnderlineType_Wave) = 9, Thick (UnderlineType_Thick) = 10, Thin (UnderlineType_Thin) = 11, DoubleWave (UnderlineType_DoubleWave) = 12, HeavyWave (UnderlineType_HeavyWave) = 13, LongDash (UnderlineType_LongDash) = 14, ThickDash (UnderlineType_ThickDash) = 15, ThickDashDot (UnderlineType_ThickDashDot) = 16, ThickDashDotDot (UnderlineType_ThickDashDotDot) = 17, ThickDotted (UnderlineType_ThickDotted) = 18, ThickLongDash (UnderlineType_ThickLongDash) = 19,
}}
RT_ENUM! { enum VerticalCharacterAlignment: i32 {
    Top (VerticalCharacterAlignment_Top) = 0, Baseline (VerticalCharacterAlignment_Baseline) = 1, Bottom (VerticalCharacterAlignment_Bottom) = 2,
}}
pub mod core { // Windows.UI.Text.Core
use ::prelude::*;
DEFINE_IID!(IID_ICoreTextCompositionCompletedEventArgs, 523561910, 47007, 16673, 165, 231, 253, 169, 184, 97, 110, 48);
RT_INTERFACE!{interface ICoreTextCompositionCompletedEventArgs(ICoreTextCompositionCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextCompositionCompletedEventArgs] {
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn get_CompositionSegments(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<CoreTextCompositionSegment>) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextCompositionCompletedEventArgs {
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_composition_segments(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<CoreTextCompositionSegment>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CompositionSegments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextCompositionCompletedEventArgs: ICoreTextCompositionCompletedEventArgs}
DEFINE_IID!(IID_ICoreTextCompositionSegment, 2003594201, 20141, 19879, 143, 71, 58, 136, 181, 35, 204, 52);
RT_INTERFACE!{interface ICoreTextCompositionSegment(ICoreTextCompositionSegmentVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextCompositionSegment] {
    fn get_PreconversionString(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Range(&self, out: *mut CoreTextRange) -> HRESULT
}}
impl ICoreTextCompositionSegment {
    #[inline] pub unsafe fn get_preconversion_string(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreconversionString)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_range(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Range)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextCompositionSegment: ICoreTextCompositionSegment}
DEFINE_IID!(IID_ICoreTextCompositionStartedEventArgs, 661329577, 25831, 19120, 188, 75, 160, 45, 115, 131, 91, 251);
RT_INTERFACE!{interface ICoreTextCompositionStartedEventArgs(ICoreTextCompositionStartedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextCompositionStartedEventArgs] {
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextCompositionStartedEventArgs {
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextCompositionStartedEventArgs: ICoreTextCompositionStartedEventArgs}
DEFINE_IID!(IID_ICoreTextEditContext, 3211135151, 16449, 18371, 178, 99, 169, 24, 235, 94, 174, 242);
RT_INTERFACE!{interface ICoreTextEditContext(ICoreTextEditContextVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextEditContext] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_InputScope(&self, out: *mut CoreTextInputScope) -> HRESULT,
    fn put_InputScope(&self, value: CoreTextInputScope) -> HRESULT,
    fn get_IsReadOnly(&self, out: *mut bool) -> HRESULT,
    fn put_IsReadOnly(&self, value: bool) -> HRESULT,
    fn get_InputPaneDisplayPolicy(&self, out: *mut CoreTextInputPaneDisplayPolicy) -> HRESULT,
    fn put_InputPaneDisplayPolicy(&self, value: CoreTextInputPaneDisplayPolicy) -> HRESULT,
    fn add_TextRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextTextRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TextRequested(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SelectionRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextSelectionRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SelectionRequested(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_LayoutRequested(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextLayoutRequestedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LayoutRequested(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_TextUpdating(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextTextUpdatingEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TextUpdating(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SelectionUpdating(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextSelectionUpdatingEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SelectionUpdating(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_FormatUpdating(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextFormatUpdatingEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FormatUpdating(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CompositionStarted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextCompositionStartedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CompositionStarted(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CompositionCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextCompositionCompletedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CompositionCompleted(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_FocusRemoved(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FocusRemoved(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn NotifyFocusEnter(&self) -> HRESULT,
    fn NotifyFocusLeave(&self) -> HRESULT,
    fn NotifyTextChanged(&self, modifiedRange: CoreTextRange, newLength: i32, newSelection: CoreTextRange) -> HRESULT,
    fn NotifySelectionChanged(&self, selection: CoreTextRange) -> HRESULT,
    fn NotifyLayoutChanged(&self) -> HRESULT
}}
impl ICoreTextEditContext {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_input_scope(&self) -> Result<CoreTextInputScope> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InputScope)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_input_scope(&self, value: CoreTextInputScope) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InputScope)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_read_only(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsReadOnly)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_read_only(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsReadOnly)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_input_pane_display_policy(&self) -> Result<CoreTextInputPaneDisplayPolicy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InputPaneDisplayPolicy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_input_pane_display_policy(&self, value: CoreTextInputPaneDisplayPolicy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InputPaneDisplayPolicy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_text_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextTextRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TextRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_text_requested(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TextRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_selection_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextSelectionRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SelectionRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_selection_requested(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SelectionRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_layout_requested(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextLayoutRequestedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LayoutRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_layout_requested(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LayoutRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_text_updating(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextTextUpdatingEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TextUpdating)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_text_updating(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TextUpdating)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_selection_updating(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextSelectionUpdatingEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SelectionUpdating)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_selection_updating(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SelectionUpdating)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_format_updating(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextFormatUpdatingEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FormatUpdating)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_format_updating(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FormatUpdating)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_composition_started(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextCompositionStartedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CompositionStarted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_composition_started(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CompositionStarted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_composition_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, CoreTextCompositionCompletedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CompositionCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_composition_completed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CompositionCompleted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_focus_removed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FocusRemoved)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_focus_removed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FocusRemoved)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_focus_enter(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyFocusEnter)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_focus_leave(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyFocusLeave)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_text_changed(&self, modifiedRange: CoreTextRange, newLength: i32, newSelection: CoreTextRange) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyTextChanged)(self as *const _ as *mut _, modifiedRange, newLength, newSelection);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_selection_changed(&self, selection: CoreTextRange) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifySelectionChanged)(self as *const _ as *mut _, selection);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn notify_layout_changed(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).NotifyLayoutChanged)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextEditContext: ICoreTextEditContext}
DEFINE_IID!(IID_ICoreTextEditContext2, 2978381243, 2107, 18913, 178, 129, 43, 53, 214, 43, 244, 102);
RT_INTERFACE!{interface ICoreTextEditContext2(ICoreTextEditContext2Vtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextEditContext2] {
    fn add_NotifyFocusLeaveCompleted(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NotifyFocusLeaveCompleted(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICoreTextEditContext2 {
    #[inline] pub unsafe fn add_notify_focus_leave_completed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextEditContext, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NotifyFocusLeaveCompleted)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_notify_focus_leave_completed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NotifyFocusLeaveCompleted)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreTextFormatUpdatingEventArgs, 1930476851, 46248, 17329, 179, 123, 7, 36, 212, 172, 167, 171);
RT_INTERFACE!{interface ICoreTextFormatUpdatingEventArgs(ICoreTextFormatUpdatingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextFormatUpdatingEventArgs] {
    fn get_Range(&self, out: *mut CoreTextRange) -> HRESULT,
    fn get_TextColor(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<super::super::viewmanagement::UIElementType>) -> HRESULT,
    fn get_BackgroundColor(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<super::super::viewmanagement::UIElementType>) -> HRESULT,
    fn get_UnderlineColor(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<super::super::viewmanagement::UIElementType>) -> HRESULT,
    fn get_UnderlineType(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<super::UnderlineType>) -> HRESULT,
    fn get_Reason(&self, out: *mut CoreTextFormatUpdatingReason) -> HRESULT,
    fn get_Result(&self, out: *mut CoreTextFormatUpdatingResult) -> HRESULT,
    fn put_Result(&self, value: CoreTextFormatUpdatingResult) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextFormatUpdatingEventArgs {
    #[inline] pub unsafe fn get_range(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Range)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_color(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<super::super::viewmanagement::UIElementType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_color(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<super::super::viewmanagement::UIElementType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_underline_color(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<super::super::viewmanagement::UIElementType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UnderlineColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_underline_type(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<super::UnderlineType>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UnderlineType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_reason(&self) -> Result<CoreTextFormatUpdatingReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Reason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_result(&self) -> Result<CoreTextFormatUpdatingResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_result(&self, value: CoreTextFormatUpdatingResult) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Result)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextFormatUpdatingEventArgs: ICoreTextFormatUpdatingEventArgs}
RT_ENUM! { enum CoreTextFormatUpdatingReason: i32 {
    None (CoreTextFormatUpdatingReason_None) = 0, CompositionUnconverted (CoreTextFormatUpdatingReason_CompositionUnconverted) = 1, CompositionConverted (CoreTextFormatUpdatingReason_CompositionConverted) = 2, CompositionTargetUnconverted (CoreTextFormatUpdatingReason_CompositionTargetUnconverted) = 3, CompositionTargetConverted (CoreTextFormatUpdatingReason_CompositionTargetConverted) = 4,
}}
RT_ENUM! { enum CoreTextFormatUpdatingResult: i32 {
    Succeeded (CoreTextFormatUpdatingResult_Succeeded) = 0, Failed (CoreTextFormatUpdatingResult_Failed) = 1,
}}
RT_ENUM! { enum CoreTextInputPaneDisplayPolicy: i32 {
    Automatic (CoreTextInputPaneDisplayPolicy_Automatic) = 0, Manual (CoreTextInputPaneDisplayPolicy_Manual) = 1,
}}
RT_ENUM! { enum CoreTextInputScope: i32 {
    Default (CoreTextInputScope_Default) = 0, Url (CoreTextInputScope_Url) = 1, FilePath (CoreTextInputScope_FilePath) = 2, FileName (CoreTextInputScope_FileName) = 3, EmailUserName (CoreTextInputScope_EmailUserName) = 4, EmailAddress (CoreTextInputScope_EmailAddress) = 5, UserName (CoreTextInputScope_UserName) = 6, PersonalFullName (CoreTextInputScope_PersonalFullName) = 7, PersonalNamePrefix (CoreTextInputScope_PersonalNamePrefix) = 8, PersonalGivenName (CoreTextInputScope_PersonalGivenName) = 9, PersonalMiddleName (CoreTextInputScope_PersonalMiddleName) = 10, PersonalSurname (CoreTextInputScope_PersonalSurname) = 11, PersonalNameSuffix (CoreTextInputScope_PersonalNameSuffix) = 12, Address (CoreTextInputScope_Address) = 13, AddressPostalCode (CoreTextInputScope_AddressPostalCode) = 14, AddressStreet (CoreTextInputScope_AddressStreet) = 15, AddressStateOrProvince (CoreTextInputScope_AddressStateOrProvince) = 16, AddressCity (CoreTextInputScope_AddressCity) = 17, AddressCountryName (CoreTextInputScope_AddressCountryName) = 18, AddressCountryShortName (CoreTextInputScope_AddressCountryShortName) = 19, CurrencyAmountAndSymbol (CoreTextInputScope_CurrencyAmountAndSymbol) = 20, CurrencyAmount (CoreTextInputScope_CurrencyAmount) = 21, Date (CoreTextInputScope_Date) = 22, DateMonth (CoreTextInputScope_DateMonth) = 23, DateDay (CoreTextInputScope_DateDay) = 24, DateYear (CoreTextInputScope_DateYear) = 25, DateMonthName (CoreTextInputScope_DateMonthName) = 26, DateDayName (CoreTextInputScope_DateDayName) = 27, Number (CoreTextInputScope_Number) = 29, SingleCharacter (CoreTextInputScope_SingleCharacter) = 30, Password (CoreTextInputScope_Password) = 31, TelephoneNumber (CoreTextInputScope_TelephoneNumber) = 32, TelephoneCountryCode (CoreTextInputScope_TelephoneCountryCode) = 33, TelephoneAreaCode (CoreTextInputScope_TelephoneAreaCode) = 34, TelephoneLocalNumber (CoreTextInputScope_TelephoneLocalNumber) = 35, Time (CoreTextInputScope_Time) = 36, TimeHour (CoreTextInputScope_TimeHour) = 37, TimeMinuteOrSecond (CoreTextInputScope_TimeMinuteOrSecond) = 38, NumberFullWidth (CoreTextInputScope_NumberFullWidth) = 39, AlphanumericHalfWidth (CoreTextInputScope_AlphanumericHalfWidth) = 40, AlphanumericFullWidth (CoreTextInputScope_AlphanumericFullWidth) = 41, CurrencyChinese (CoreTextInputScope_CurrencyChinese) = 42, Bopomofo (CoreTextInputScope_Bopomofo) = 43, Hiragana (CoreTextInputScope_Hiragana) = 44, KatakanaHalfWidth (CoreTextInputScope_KatakanaHalfWidth) = 45, KatakanaFullWidth (CoreTextInputScope_KatakanaFullWidth) = 46, Hanja (CoreTextInputScope_Hanja) = 47, HangulHalfWidth (CoreTextInputScope_HangulHalfWidth) = 48, HangulFullWidth (CoreTextInputScope_HangulFullWidth) = 49, Search (CoreTextInputScope_Search) = 50, Formula (CoreTextInputScope_Formula) = 51, SearchIncremental (CoreTextInputScope_SearchIncremental) = 52, ChineseHalfWidth (CoreTextInputScope_ChineseHalfWidth) = 53, ChineseFullWidth (CoreTextInputScope_ChineseFullWidth) = 54, NativeScript (CoreTextInputScope_NativeScript) = 55, Text (CoreTextInputScope_Text) = 57, Chat (CoreTextInputScope_Chat) = 58, NameOrPhoneNumber (CoreTextInputScope_NameOrPhoneNumber) = 59, EmailUserNameOrAddress (CoreTextInputScope_EmailUserNameOrAddress) = 60, Private (CoreTextInputScope_Private) = 61, Maps (CoreTextInputScope_Maps) = 62, PasswordNumeric (CoreTextInputScope_PasswordNumeric) = 63, FormulaNumber (CoreTextInputScope_FormulaNumber) = 67, ChatWithoutEmoji (CoreTextInputScope_ChatWithoutEmoji) = 68, Digits (CoreTextInputScope_Digits) = 28, PinNumeric (CoreTextInputScope_PinNumeric) = 64, PinAlphanumeric (CoreTextInputScope_PinAlphanumeric) = 65,
}}
DEFINE_IID!(IID_ICoreTextLayoutBounds, 3916614004, 17462, 18711, 128, 208, 165, 37, 228, 202, 103, 128);
RT_INTERFACE!{interface ICoreTextLayoutBounds(ICoreTextLayoutBoundsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextLayoutBounds] {
    fn get_TextBounds(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn put_TextBounds(&self, value: ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn get_ControlBounds(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn put_ControlBounds(&self, value: ::rt::gen::windows::foundation::Rect) -> HRESULT
}}
impl ICoreTextLayoutBounds {
    #[inline] pub unsafe fn get_text_bounds(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TextBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_bounds(&self, value: ::rt::gen::windows::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextBounds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_control_bounds(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ControlBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_control_bounds(&self, value: ::rt::gen::windows::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ControlBounds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextLayoutBounds: ICoreTextLayoutBounds}
DEFINE_IID!(IID_ICoreTextLayoutRequest, 626370764, 20989, 20227, 152, 191, 172, 120, 23, 77, 104, 224);
RT_INTERFACE!{interface ICoreTextLayoutRequest(ICoreTextLayoutRequestVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextLayoutRequest] {
    fn get_Range(&self, out: *mut CoreTextRange) -> HRESULT,
    fn get_LayoutBounds(&self, out: *mut *mut CoreTextLayoutBounds) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextLayoutRequest {
    #[inline] pub unsafe fn get_range(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Range)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_layout_bounds(&self) -> Result<ComPtr<CoreTextLayoutBounds>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LayoutBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextLayoutRequest: ICoreTextLayoutRequest}
DEFINE_IID!(IID_ICoreTextLayoutRequestedEventArgs, 2984012512, 39547, 20126, 165, 102, 74, 107, 95, 138, 214, 118);
RT_INTERFACE!{interface ICoreTextLayoutRequestedEventArgs(ICoreTextLayoutRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextLayoutRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut CoreTextLayoutRequest) -> HRESULT
}}
impl ICoreTextLayoutRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<CoreTextLayoutRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextLayoutRequestedEventArgs: ICoreTextLayoutRequestedEventArgs}
RT_STRUCT! { struct CoreTextRange {
    StartCaretPosition: i32, EndCaretPosition: i32,
}}
DEFINE_IID!(IID_ICoreTextSelectionRequest, 4037477379, 8331, 17153, 136, 60, 116, 202, 116, 133, 253, 141);
RT_INTERFACE!{interface ICoreTextSelectionRequest(ICoreTextSelectionRequestVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextSelectionRequest] {
    fn get_Selection(&self, out: *mut CoreTextRange) -> HRESULT,
    fn put_Selection(&self, value: CoreTextRange) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextSelectionRequest {
    #[inline] pub unsafe fn get_selection(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Selection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selection(&self, value: CoreTextRange) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Selection)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextSelectionRequest: ICoreTextSelectionRequest}
DEFINE_IID!(IID_ICoreTextSelectionRequestedEventArgs, 331769899, 62996, 16922, 143, 75, 158, 200, 165, 163, 127, 205);
RT_INTERFACE!{interface ICoreTextSelectionRequestedEventArgs(ICoreTextSelectionRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextSelectionRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut CoreTextSelectionRequest) -> HRESULT
}}
impl ICoreTextSelectionRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<CoreTextSelectionRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextSelectionRequestedEventArgs: ICoreTextSelectionRequestedEventArgs}
DEFINE_IID!(IID_ICoreTextSelectionUpdatingEventArgs, 3561325471, 65151, 19413, 138, 38, 9, 34, 193, 179, 230, 57);
RT_INTERFACE!{interface ICoreTextSelectionUpdatingEventArgs(ICoreTextSelectionUpdatingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextSelectionUpdatingEventArgs] {
    fn get_Selection(&self, out: *mut CoreTextRange) -> HRESULT,
    fn get_Result(&self, out: *mut CoreTextSelectionUpdatingResult) -> HRESULT,
    fn put_Result(&self, value: CoreTextSelectionUpdatingResult) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextSelectionUpdatingEventArgs {
    #[inline] pub unsafe fn get_selection(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Selection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_result(&self) -> Result<CoreTextSelectionUpdatingResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_result(&self, value: CoreTextSelectionUpdatingResult) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Result)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextSelectionUpdatingEventArgs: ICoreTextSelectionUpdatingEventArgs}
RT_ENUM! { enum CoreTextSelectionUpdatingResult: i32 {
    Succeeded (CoreTextSelectionUpdatingResult_Succeeded) = 0, Failed (CoreTextSelectionUpdatingResult_Failed) = 1,
}}
RT_CLASS!{static class CoreTextServicesConstants}
impl RtActivatable<ICoreTextServicesStatics> for CoreTextServicesConstants {}
impl CoreTextServicesConstants {
    #[inline] pub fn get_hidden_character() -> Result<Char> { unsafe {
        <Self as RtActivatable<ICoreTextServicesStatics>>::get_activation_factory().get_hidden_character()
    }}
}
DEFINE_CLSID!(CoreTextServicesConstants(&[87,105,110,100,111,119,115,46,85,73,46,84,101,120,116,46,67,111,114,101,46,67,111,114,101,84,101,120,116,83,101,114,118,105,99,101,115,67,111,110,115,116,97,110,116,115,0]) [CLSID_CoreTextServicesConstants]);
DEFINE_IID!(IID_ICoreTextServicesManager, 3260054915, 28170, 19082, 189, 248, 25, 72, 135, 72, 84, 186);
RT_INTERFACE!{interface ICoreTextServicesManager(ICoreTextServicesManagerVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextServicesManager] {
    #[cfg(not(feature="windows-globalization"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-globalization")] fn get_InputLanguage(&self, out: *mut *mut ::rt::gen::windows::globalization::Language) -> HRESULT,
    fn add_InputLanguageChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreTextServicesManager, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_InputLanguageChanged(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn CreateEditContext(&self, out: *mut *mut CoreTextEditContext) -> HRESULT
}}
impl ICoreTextServicesManager {
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_input_language(&self) -> Result<ComPtr<::rt::gen::windows::globalization::Language>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InputLanguage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_input_language_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreTextServicesManager, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_InputLanguageChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_input_language_changed(&self, cookie: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_InputLanguageChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_edit_context(&self) -> Result<ComPtr<CoreTextEditContext>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateEditContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextServicesManager: ICoreTextServicesManager}
impl RtActivatable<ICoreTextServicesManagerStatics> for CoreTextServicesManager {}
impl CoreTextServicesManager {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<CoreTextServicesManager>> { unsafe {
        <Self as RtActivatable<ICoreTextServicesManagerStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(CoreTextServicesManager(&[87,105,110,100,111,119,115,46,85,73,46,84,101,120,116,46,67,111,114,101,46,67,111,114,101,84,101,120,116,83,101,114,118,105,99,101,115,77,97,110,97,103,101,114,0]) [CLSID_CoreTextServicesManager]);
DEFINE_IID!(IID_ICoreTextServicesManagerStatics, 354460552, 58063, 19813, 174, 185, 179, 45, 134, 254, 57, 185);
RT_INTERFACE!{static interface ICoreTextServicesManagerStatics(ICoreTextServicesManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextServicesManagerStatics] {
    fn GetForCurrentView(&self, out: *mut *mut CoreTextServicesManager) -> HRESULT
}}
impl ICoreTextServicesManagerStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<CoreTextServicesManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreTextServicesStatics, 2441452102, 60623, 18340, 138, 231, 9, 138, 156, 111, 187, 21);
RT_INTERFACE!{static interface ICoreTextServicesStatics(ICoreTextServicesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextServicesStatics] {
    fn get_HiddenCharacter(&self, out: *mut Char) -> HRESULT
}}
impl ICoreTextServicesStatics {
    #[inline] pub unsafe fn get_hidden_character(&self) -> Result<Char> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HiddenCharacter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICoreTextTextRequest, 1356419241, 62750, 19649, 140, 161, 230, 52, 109, 26, 97, 190);
RT_INTERFACE!{interface ICoreTextTextRequest(ICoreTextTextRequestVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextTextRequest] {
    fn get_Range(&self, out: *mut CoreTextRange) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextTextRequest {
    #[inline] pub unsafe fn get_range(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Range)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextTextRequest: ICoreTextTextRequest}
DEFINE_IID!(IID_ICoreTextTextRequestedEventArgs, 4036403920, 16838, 19458, 139, 26, 217, 83, 176, 12, 171, 179);
RT_INTERFACE!{interface ICoreTextTextRequestedEventArgs(ICoreTextTextRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextTextRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut CoreTextTextRequest) -> HRESULT
}}
impl ICoreTextTextRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<CoreTextTextRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextTextRequestedEventArgs: ICoreTextTextRequestedEventArgs}
DEFINE_IID!(IID_ICoreTextTextUpdatingEventArgs, 4003959181, 52267, 20227, 143, 246, 2, 253, 33, 125, 180, 80);
RT_INTERFACE!{interface ICoreTextTextUpdatingEventArgs(ICoreTextTextUpdatingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreTextTextUpdatingEventArgs] {
    fn get_Range(&self, out: *mut CoreTextRange) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn get_NewSelection(&self, out: *mut CoreTextRange) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-globalization")] fn get_InputLanguage(&self, out: *mut *mut ::rt::gen::windows::globalization::Language) -> HRESULT,
    fn get_Result(&self, out: *mut CoreTextTextUpdatingResult) -> HRESULT,
    fn put_Result(&self, value: CoreTextTextUpdatingResult) -> HRESULT,
    fn get_IsCanceled(&self, out: *mut bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ::rt::gen::windows::foundation::Deferral) -> HRESULT
}}
impl ICoreTextTextUpdatingEventArgs {
    #[inline] pub unsafe fn get_range(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Range)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_selection(&self) -> Result<CoreTextRange> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewSelection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_input_language(&self) -> Result<ComPtr<::rt::gen::windows::globalization::Language>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InputLanguage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_result(&self) -> Result<CoreTextTextUpdatingResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_result(&self, value: CoreTextTextUpdatingResult) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Result)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_canceled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCanceled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Deferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CoreTextTextUpdatingEventArgs: ICoreTextTextUpdatingEventArgs}
RT_ENUM! { enum CoreTextTextUpdatingResult: i32 {
    Succeeded (CoreTextTextUpdatingResult_Succeeded) = 0, Failed (CoreTextTextUpdatingResult_Failed) = 1,
}}
} // Windows.UI.Text.Core
} // Windows.UI.Text
pub mod viewmanagement { // Windows.UI.ViewManagement
use ::prelude::*;
DEFINE_IID!(IID_IAccessibilitySettings, 4262363463, 50368, 17762, 185, 98, 19, 39, 181, 42, 213, 185);
RT_INTERFACE!{interface IAccessibilitySettings(IAccessibilitySettingsVtbl): IInspectable(IInspectableVtbl) [IID_IAccessibilitySettings] {
    fn get_HighContrast(&self, out: *mut bool) -> HRESULT,
    fn get_HighContrastScheme(&self, out: *mut HSTRING) -> HRESULT,
    fn add_HighContrastChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<AccessibilitySettings, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_HighContrastChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAccessibilitySettings {
    #[inline] pub unsafe fn get_high_contrast(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HighContrast)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_high_contrast_scheme(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HighContrastScheme)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_high_contrast_changed(&self, handler: &super::super::foundation::TypedEventHandler<AccessibilitySettings, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_HighContrastChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_high_contrast_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_HighContrastChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AccessibilitySettings: IAccessibilitySettings}
impl RtActivatable<IActivationFactory> for AccessibilitySettings {}
DEFINE_CLSID!(AccessibilitySettings(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,65,99,99,101,115,115,105,98,105,108,105,116,121,83,101,116,116,105,110,103,115,0]) [CLSID_AccessibilitySettings]);
DEFINE_IID!(IID_IActivationViewSwitcher, 3701939126, 29520, 18731, 170, 199, 200, 161, 61, 114, 36, 173);
RT_INTERFACE!{interface IActivationViewSwitcher(IActivationViewSwitcherVtbl): IInspectable(IInspectableVtbl) [IID_IActivationViewSwitcher] {
    fn ShowAsStandaloneAsync(&self, viewId: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAsStandaloneWithSizePreferenceAsync(&self, viewId: i32, sizePreference: ViewSizePreference, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn IsViewPresentedOnActivationVirtualDesktop(&self, viewId: i32, out: *mut bool) -> HRESULT
}}
impl IActivationViewSwitcher {
    #[inline] pub unsafe fn show_as_standalone_async(&self, viewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsStandaloneAsync)(self as *const _ as *mut _, viewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_as_standalone_with_size_preference_async(&self, viewId: i32, sizePreference: ViewSizePreference) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsStandaloneWithSizePreferenceAsync)(self as *const _ as *mut _, viewId, sizePreference, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_view_presented_on_activation_virtual_desktop(&self, viewId: i32) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsViewPresentedOnActivationVirtualDesktop)(self as *const _ as *mut _, viewId, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ActivationViewSwitcher: IActivationViewSwitcher}
DEFINE_IID!(IID_IApplicationView, 3525498137, 17249, 17694, 150, 196, 96, 244, 249, 116, 45, 176);
RT_INTERFACE!{interface IApplicationView(IApplicationViewVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationView] {
    fn get_Orientation(&self, out: *mut ApplicationViewOrientation) -> HRESULT,
    fn get_AdjacentToLeftDisplayEdge(&self, out: *mut bool) -> HRESULT,
    fn get_AdjacentToRightDisplayEdge(&self, out: *mut bool) -> HRESULT,
    fn get_IsFullScreen(&self, out: *mut bool) -> HRESULT,
    fn get_IsOnLockScreen(&self, out: *mut bool) -> HRESULT,
    fn get_IsScreenCaptureEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsScreenCaptureEnabled(&self, value: bool) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Id(&self, out: *mut i32) -> HRESULT,
    fn add_Consolidated(&self, handler: *mut super::super::foundation::TypedEventHandler<ApplicationView, ApplicationViewConsolidatedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Consolidated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IApplicationView {
    #[inline] pub unsafe fn get_orientation(&self) -> Result<ApplicationViewOrientation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_adjacent_to_left_display_edge(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AdjacentToLeftDisplayEdge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_adjacent_to_right_display_edge(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AdjacentToRightDisplayEdge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_full_screen(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFullScreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_on_lock_screen(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOnLockScreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_screen_capture_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsScreenCaptureEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_screen_capture_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsScreenCaptureEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_consolidated(&self, handler: &super::super::foundation::TypedEventHandler<ApplicationView, ApplicationViewConsolidatedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Consolidated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_consolidated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Consolidated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ApplicationView: IApplicationView}
impl RtActivatable<IApplicationViewFullscreenStatics> for ApplicationView {}
impl RtActivatable<IApplicationViewInteropStatics> for ApplicationView {}
impl RtActivatable<IApplicationViewStatics> for ApplicationView {}
impl RtActivatable<IApplicationViewStatics2> for ApplicationView {}
impl RtActivatable<IApplicationViewStatics3> for ApplicationView {}
impl ApplicationView {
    #[inline] pub fn try_unsnap_to_fullscreen() -> Result<bool> { unsafe {
        <Self as RtActivatable<IApplicationViewFullscreenStatics>>::get_activation_factory().try_unsnap_to_fullscreen()
    }}
    #[inline] pub fn get_application_view_id_for_window(window: &super::core::ICoreWindow) -> Result<i32> { unsafe {
        <Self as RtActivatable<IApplicationViewInteropStatics>>::get_activation_factory().get_application_view_id_for_window(window)
    }}
    #[inline] pub fn get_value() -> Result<ApplicationViewState> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics>>::get_activation_factory().get_value()
    }}
    #[inline] pub fn try_unsnap() -> Result<bool> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics>>::get_activation_factory().try_unsnap()
    }}
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<ApplicationView>> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics2>>::get_activation_factory().get_for_current_view()
    }}
    #[inline] pub fn get_terminate_app_on_final_view_close() -> Result<bool> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics2>>::get_activation_factory().get_terminate_app_on_final_view_close()
    }}
    #[inline] pub fn set_terminate_app_on_final_view_close(value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics2>>::get_activation_factory().set_terminate_app_on_final_view_close(value)
    }}
    #[inline] pub fn get_preferred_launch_windowing_mode() -> Result<ApplicationViewWindowingMode> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics3>>::get_activation_factory().get_preferred_launch_windowing_mode()
    }}
    #[inline] pub fn set_preferred_launch_windowing_mode(value: ApplicationViewWindowingMode) -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics3>>::get_activation_factory().set_preferred_launch_windowing_mode(value)
    }}
    #[inline] pub fn get_preferred_launch_view_size() -> Result<super::super::foundation::Size> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics3>>::get_activation_factory().get_preferred_launch_view_size()
    }}
    #[inline] pub fn set_preferred_launch_view_size(value: super::super::foundation::Size) -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationViewStatics3>>::get_activation_factory().set_preferred_launch_view_size(value)
    }}
}
DEFINE_CLSID!(ApplicationView(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,65,112,112,108,105,99,97,116,105,111,110,86,105,101,119,0]) [CLSID_ApplicationView]);
DEFINE_IID!(IID_IApplicationView2, 3900092822, 42309, 16604, 181, 148, 69, 12, 186, 104, 204, 0);
RT_INTERFACE!{interface IApplicationView2(IApplicationView2Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationView2] {
    fn get_SuppressSystemOverlays(&self, out: *mut bool) -> HRESULT,
    fn put_SuppressSystemOverlays(&self, value: bool) -> HRESULT,
    fn get_VisibleBounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn add_VisibleBoundsChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<ApplicationView, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VisibleBoundsChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn SetDesiredBoundsMode(&self, boundsMode: ApplicationViewBoundsMode, out: *mut bool) -> HRESULT,
    fn get_DesiredBoundsMode(&self, out: *mut ApplicationViewBoundsMode) -> HRESULT
}}
impl IApplicationView2 {
    #[inline] pub unsafe fn get_suppress_system_overlays(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SuppressSystemOverlays)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_suppress_system_overlays(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SuppressSystemOverlays)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visible_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VisibleBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_visible_bounds_changed(&self, handler: &super::super::foundation::TypedEventHandler<ApplicationView, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VisibleBoundsChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_visible_bounds_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VisibleBoundsChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_desired_bounds_mode(&self, boundsMode: ApplicationViewBoundsMode) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SetDesiredBoundsMode)(self as *const _ as *mut _, boundsMode, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_desired_bounds_mode(&self) -> Result<ApplicationViewBoundsMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredBoundsMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationView3, 2419891429, 31034, 20447, 162, 178, 175, 26, 194, 30, 49, 8);
RT_INTERFACE!{interface IApplicationView3(IApplicationView3Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationView3] {
    fn get_TitleBar(&self, out: *mut *mut ApplicationViewTitleBar) -> HRESULT,
    fn get_FullScreenSystemOverlayMode(&self, out: *mut FullScreenSystemOverlayMode) -> HRESULT,
    fn put_FullScreenSystemOverlayMode(&self, value: FullScreenSystemOverlayMode) -> HRESULT,
    fn get_IsFullScreenMode(&self, out: *mut bool) -> HRESULT,
    fn TryEnterFullScreenMode(&self, out: *mut bool) -> HRESULT,
    fn ExitFullScreenMode(&self) -> HRESULT,
    fn ShowStandardSystemOverlays(&self) -> HRESULT,
    fn TryResizeView(&self, value: super::super::foundation::Size, out: *mut bool) -> HRESULT,
    fn SetPreferredMinSize(&self, minSize: super::super::foundation::Size) -> HRESULT
}}
impl IApplicationView3 {
    #[inline] pub unsafe fn get_title_bar(&self) -> Result<ComPtr<ApplicationViewTitleBar>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleBar)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_full_screen_system_overlay_mode(&self) -> Result<FullScreenSystemOverlayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FullScreenSystemOverlayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_full_screen_system_overlay_mode(&self, value: FullScreenSystemOverlayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FullScreenSystemOverlayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_full_screen_mode(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFullScreenMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_enter_full_screen_mode(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryEnterFullScreenMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn exit_full_screen_mode(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ExitFullScreenMode)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_standard_system_overlays(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ShowStandardSystemOverlays)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_resize_view(&self, value: super::super::foundation::Size) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryResizeView)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preferred_min_size(&self, minSize: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).SetPreferredMinSize)(self as *const _ as *mut _, minSize);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationView4, 367381484, 40463, 18101, 188, 63, 155, 246, 83, 231, 75, 94);
RT_INTERFACE!{interface IApplicationView4(IApplicationView4Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationView4] {
    fn get_ViewMode(&self, out: *mut ApplicationViewMode) -> HRESULT,
    fn IsViewModeSupported(&self, viewMode: ApplicationViewMode, out: *mut bool) -> HRESULT,
    fn TryEnterViewModeAsync(&self, viewMode: ApplicationViewMode, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryEnterViewModeWithPreferencesAsync(&self, viewMode: ApplicationViewMode, viewModePreferences: *mut ViewModePreferences, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryConsolidateAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IApplicationView4 {
    #[inline] pub unsafe fn get_view_mode(&self) -> Result<ApplicationViewMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ViewMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_view_mode_supported(&self, viewMode: ApplicationViewMode) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsViewModeSupported)(self as *const _ as *mut _, viewMode, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_enter_view_mode_async(&self, viewMode: ApplicationViewMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryEnterViewModeAsync)(self as *const _ as *mut _, viewMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_enter_view_mode_with_preferences_async(&self, viewMode: ApplicationViewMode, viewModePreferences: &ViewModePreferences) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryEnterViewModeWithPreferencesAsync)(self as *const _ as *mut _, viewMode, viewModePreferences as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_consolidate_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryConsolidateAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationViewBoundsMode: i32 {
    UseVisible (ApplicationViewBoundsMode_UseVisible) = 0, UseCoreWindow (ApplicationViewBoundsMode_UseCoreWindow) = 1,
}}
DEFINE_IID!(IID_IApplicationViewConsolidatedEventArgs, 1363429868, 32418, 19943, 166, 166, 125, 251, 170, 235, 182, 251);
RT_INTERFACE!{interface IApplicationViewConsolidatedEventArgs(IApplicationViewConsolidatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewConsolidatedEventArgs] {
    fn get_IsUserInitiated(&self, out: *mut bool) -> HRESULT
}}
impl IApplicationViewConsolidatedEventArgs {
    #[inline] pub unsafe fn get_is_user_initiated(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsUserInitiated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ApplicationViewConsolidatedEventArgs: IApplicationViewConsolidatedEventArgs}
DEFINE_IID!(IID_IApplicationViewConsolidatedEventArgs2, 471441100, 28097, 16628, 175, 238, 7, 217, 234, 41, 100, 48);
RT_INTERFACE!{interface IApplicationViewConsolidatedEventArgs2(IApplicationViewConsolidatedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewConsolidatedEventArgs2] {
    fn get_IsAppInitiated(&self, out: *mut bool) -> HRESULT
}}
impl IApplicationViewConsolidatedEventArgs2 {
    #[inline] pub unsafe fn get_is_app_initiated(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAppInitiated)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationViewFullscreenStatics, 3162058429, 25854, 19301, 160, 192, 144, 28, 226, 182, 134, 54);
RT_INTERFACE!{static interface IApplicationViewFullscreenStatics(IApplicationViewFullscreenStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewFullscreenStatics] {
    fn TryUnsnapToFullscreen(&self, out: *mut bool) -> HRESULT
}}
impl IApplicationViewFullscreenStatics {
    #[inline] pub unsafe fn try_unsnap_to_fullscreen(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryUnsnapToFullscreen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationViewInteropStatics, 3292986205, 18323, 18582, 168, 226, 190, 87, 168, 187, 15, 80);
RT_INTERFACE!{static interface IApplicationViewInteropStatics(IApplicationViewInteropStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewInteropStatics] {
    fn GetApplicationViewIdForWindow(&self, window: *mut super::core::ICoreWindow, out: *mut i32) -> HRESULT
}}
impl IApplicationViewInteropStatics {
    #[inline] pub unsafe fn get_application_view_id_for_window(&self, window: &super::core::ICoreWindow) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetApplicationViewIdForWindow)(self as *const _ as *mut _, window as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationViewMode: i32 {
    Default (ApplicationViewMode_Default) = 0, CompactOverlay (ApplicationViewMode_CompactOverlay) = 1,
}}
RT_ENUM! { enum ApplicationViewOrientation: i32 {
    Landscape (ApplicationViewOrientation_Landscape) = 0, Portrait (ApplicationViewOrientation_Portrait) = 1,
}}
DEFINE_IID!(IID_IApplicationViewScaling, 487447587, 9203, 19245, 132, 254, 116, 191, 55, 180, 139, 102);
RT_INTERFACE!{interface IApplicationViewScaling(IApplicationViewScalingVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewScaling] {
    
}}
RT_CLASS!{class ApplicationViewScaling: IApplicationViewScaling}
impl RtActivatable<IApplicationViewScalingStatics> for ApplicationViewScaling {}
impl ApplicationViewScaling {
    #[inline] pub fn get_disable_layout_scaling() -> Result<bool> { unsafe {
        <Self as RtActivatable<IApplicationViewScalingStatics>>::get_activation_factory().get_disable_layout_scaling()
    }}
    #[inline] pub fn try_set_disable_layout_scaling(disableLayoutScaling: bool) -> Result<bool> { unsafe {
        <Self as RtActivatable<IApplicationViewScalingStatics>>::get_activation_factory().try_set_disable_layout_scaling(disableLayoutScaling)
    }}
}
DEFINE_CLSID!(ApplicationViewScaling(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,65,112,112,108,105,99,97,116,105,111,110,86,105,101,119,83,99,97,108,105,110,103,0]) [CLSID_ApplicationViewScaling]);
DEFINE_IID!(IID_IApplicationViewScalingStatics, 2962222320, 47430, 17864, 165, 227, 113, 245, 170, 120, 248, 97);
RT_INTERFACE!{static interface IApplicationViewScalingStatics(IApplicationViewScalingStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewScalingStatics] {
    fn get_DisableLayoutScaling(&self, out: *mut bool) -> HRESULT,
    fn TrySetDisableLayoutScaling(&self, disableLayoutScaling: bool, out: *mut bool) -> HRESULT
}}
impl IApplicationViewScalingStatics {
    #[inline] pub unsafe fn get_disable_layout_scaling(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisableLayoutScaling)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_disable_layout_scaling(&self, disableLayoutScaling: bool) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetDisableLayoutScaling)(self as *const _ as *mut _, disableLayoutScaling, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationViewState: i32 {
    FullScreenLandscape (ApplicationViewState_FullScreenLandscape) = 0, Filled (ApplicationViewState_Filled) = 1, Snapped (ApplicationViewState_Snapped) = 2, FullScreenPortrait (ApplicationViewState_FullScreenPortrait) = 3,
}}
DEFINE_IID!(IID_IApplicationViewStatics, 17457926, 50227, 17637, 169, 242, 189, 132, 212, 3, 10, 149);
RT_INTERFACE!{static interface IApplicationViewStatics(IApplicationViewStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewStatics] {
    fn get_Value(&self, out: *mut ApplicationViewState) -> HRESULT,
    fn TryUnsnap(&self, out: *mut bool) -> HRESULT
}}
impl IApplicationViewStatics {
    #[inline] pub unsafe fn get_value(&self) -> Result<ApplicationViewState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_unsnap(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryUnsnap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationViewStatics2, 2939390693, 53092, 16956, 133, 229, 243, 231, 36, 72, 251, 35);
RT_INTERFACE!{static interface IApplicationViewStatics2(IApplicationViewStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewStatics2] {
    fn GetForCurrentView(&self, out: *mut *mut ApplicationView) -> HRESULT,
    fn get_TerminateAppOnFinalViewClose(&self, out: *mut bool) -> HRESULT,
    fn put_TerminateAppOnFinalViewClose(&self, value: bool) -> HRESULT
}}
impl IApplicationViewStatics2 {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<ApplicationView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_terminate_app_on_final_view_close(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TerminateAppOnFinalViewClose)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_terminate_app_on_final_view_close(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TerminateAppOnFinalViewClose)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationViewStatics3, 2727179668, 35905, 19987, 151, 25, 81, 100, 121, 111, 228, 199);
RT_INTERFACE!{static interface IApplicationViewStatics3(IApplicationViewStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewStatics3] {
    fn get_PreferredLaunchWindowingMode(&self, out: *mut ApplicationViewWindowingMode) -> HRESULT,
    fn put_PreferredLaunchWindowingMode(&self, value: ApplicationViewWindowingMode) -> HRESULT,
    fn get_PreferredLaunchViewSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn put_PreferredLaunchViewSize(&self, value: super::super::foundation::Size) -> HRESULT
}}
impl IApplicationViewStatics3 {
    #[inline] pub unsafe fn get_preferred_launch_windowing_mode(&self) -> Result<ApplicationViewWindowingMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PreferredLaunchWindowingMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preferred_launch_windowing_mode(&self, value: ApplicationViewWindowingMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PreferredLaunchWindowingMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preferred_launch_view_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PreferredLaunchViewSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_preferred_launch_view_size(&self, value: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PreferredLaunchViewSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{static class ApplicationViewSwitcher}
impl RtActivatable<IApplicationViewSwitcherStatics> for ApplicationViewSwitcher {}
impl RtActivatable<IApplicationViewSwitcherStatics2> for ApplicationViewSwitcher {}
impl RtActivatable<IApplicationViewSwitcherStatics3> for ApplicationViewSwitcher {}
impl ApplicationViewSwitcher {
    #[inline] pub fn disable_showing_main_view_on_activation() -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().disable_showing_main_view_on_activation()
    }}
    #[inline] pub fn try_show_as_standalone_async(viewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().try_show_as_standalone_async(viewId)
    }}
    #[inline] pub fn try_show_as_standalone_with_size_preference_async(viewId: i32, sizePreference: ViewSizePreference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().try_show_as_standalone_with_size_preference_async(viewId, sizePreference)
    }}
    #[inline] pub fn try_show_as_standalone_with_anchor_view_and_size_preference_async(viewId: i32, sizePreference: ViewSizePreference, anchorViewId: i32, anchorSizePreference: ViewSizePreference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().try_show_as_standalone_with_anchor_view_and_size_preference_async(viewId, sizePreference, anchorViewId, anchorSizePreference)
    }}
    #[inline] pub fn switch_async(viewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().switch_async(viewId)
    }}
    #[inline] pub fn switch_from_view_async(toViewId: i32, fromViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().switch_from_view_async(toViewId, fromViewId)
    }}
    #[inline] pub fn switch_from_view_with_options_async(toViewId: i32, fromViewId: i32, options: ApplicationViewSwitchingOptions) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().switch_from_view_with_options_async(toViewId, fromViewId, options)
    }}
    #[inline] pub fn prepare_for_custom_animated_switch_async(toViewId: i32, fromViewId: i32, options: ApplicationViewSwitchingOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics>>::get_activation_factory().prepare_for_custom_animated_switch_async(toViewId, fromViewId, options)
    }}
    #[inline] pub fn disable_system_view_activation_policy() -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics2>>::get_activation_factory().disable_system_view_activation_policy()
    }}
    #[inline] pub fn try_show_as_view_mode_async(viewId: i32, viewMode: ApplicationViewMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics3>>::get_activation_factory().try_show_as_view_mode_async(viewId, viewMode)
    }}
    #[inline] pub fn try_show_as_view_mode_with_preferences_async(viewId: i32, viewMode: ApplicationViewMode, viewModePreferences: &ViewModePreferences) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IApplicationViewSwitcherStatics3>>::get_activation_factory().try_show_as_view_mode_with_preferences_async(viewId, viewMode, viewModePreferences)
    }}
}
DEFINE_CLSID!(ApplicationViewSwitcher(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,65,112,112,108,105,99,97,116,105,111,110,86,105,101,119,83,119,105,116,99,104,101,114,0]) [CLSID_ApplicationViewSwitcher]);
DEFINE_IID!(IID_IApplicationViewSwitcherStatics, 2539597598, 58966, 19550, 160, 161, 113, 124, 111, 250, 125, 100);
RT_INTERFACE!{static interface IApplicationViewSwitcherStatics(IApplicationViewSwitcherStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewSwitcherStatics] {
    fn DisableShowingMainViewOnActivation(&self) -> HRESULT,
    fn TryShowAsStandaloneAsync(&self, viewId: i32, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryShowAsStandaloneWithSizePreferenceAsync(&self, viewId: i32, sizePreference: ViewSizePreference, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryShowAsStandaloneWithAnchorViewAndSizePreferenceAsync(&self, viewId: i32, sizePreference: ViewSizePreference, anchorViewId: i32, anchorSizePreference: ViewSizePreference, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn SwitchAsync(&self, viewId: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SwitchFromViewAsync(&self, toViewId: i32, fromViewId: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SwitchFromViewWithOptionsAsync(&self, toViewId: i32, fromViewId: i32, options: ApplicationViewSwitchingOptions, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn PrepareForCustomAnimatedSwitchAsync(&self, toViewId: i32, fromViewId: i32, options: ApplicationViewSwitchingOptions, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IApplicationViewSwitcherStatics {
    #[inline] pub unsafe fn disable_showing_main_view_on_activation(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DisableShowingMainViewOnActivation)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_show_as_standalone_async(&self, viewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryShowAsStandaloneAsync)(self as *const _ as *mut _, viewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_show_as_standalone_with_size_preference_async(&self, viewId: i32, sizePreference: ViewSizePreference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryShowAsStandaloneWithSizePreferenceAsync)(self as *const _ as *mut _, viewId, sizePreference, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_show_as_standalone_with_anchor_view_and_size_preference_async(&self, viewId: i32, sizePreference: ViewSizePreference, anchorViewId: i32, anchorSizePreference: ViewSizePreference) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryShowAsStandaloneWithAnchorViewAndSizePreferenceAsync)(self as *const _ as *mut _, viewId, sizePreference, anchorViewId, anchorSizePreference, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn switch_async(&self, viewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SwitchAsync)(self as *const _ as *mut _, viewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn switch_from_view_async(&self, toViewId: i32, fromViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SwitchFromViewAsync)(self as *const _ as *mut _, toViewId, fromViewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn switch_from_view_with_options_async(&self, toViewId: i32, fromViewId: i32, options: ApplicationViewSwitchingOptions) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SwitchFromViewWithOptionsAsync)(self as *const _ as *mut _, toViewId, fromViewId, options, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn prepare_for_custom_animated_switch_async(&self, toViewId: i32, fromViewId: i32, options: ApplicationViewSwitchingOptions) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).PrepareForCustomAnimatedSwitchAsync)(self as *const _ as *mut _, toViewId, fromViewId, options, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationViewSwitcherStatics2, 1625920973, 20418, 18628, 184, 227, 57, 95, 43, 159, 15, 193);
RT_INTERFACE!{static interface IApplicationViewSwitcherStatics2(IApplicationViewSwitcherStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewSwitcherStatics2] {
    fn DisableSystemViewActivationPolicy(&self) -> HRESULT
}}
impl IApplicationViewSwitcherStatics2 {
    #[inline] pub unsafe fn disable_system_view_activation_policy(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).DisableSystemViewActivationPolicy)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationViewSwitcherStatics3, 2449839136, 32935, 18541, 178, 31, 199, 164, 162, 66, 163, 131);
RT_INTERFACE!{static interface IApplicationViewSwitcherStatics3(IApplicationViewSwitcherStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewSwitcherStatics3] {
    fn TryShowAsViewModeAsync(&self, viewId: i32, viewMode: ApplicationViewMode, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn TryShowAsViewModeWithPreferencesAsync(&self, viewId: i32, viewMode: ApplicationViewMode, viewModePreferences: *mut ViewModePreferences, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IApplicationViewSwitcherStatics3 {
    #[inline] pub unsafe fn try_show_as_view_mode_async(&self, viewId: i32, viewMode: ApplicationViewMode) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryShowAsViewModeAsync)(self as *const _ as *mut _, viewId, viewMode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_show_as_view_mode_with_preferences_async(&self, viewId: i32, viewMode: ApplicationViewMode, viewModePreferences: &ViewModePreferences) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TryShowAsViewModeWithPreferencesAsync)(self as *const _ as *mut _, viewId, viewMode, viewModePreferences as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationViewSwitchingOptions: u32 {
    Default (ApplicationViewSwitchingOptions_Default) = 0, SkipAnimation (ApplicationViewSwitchingOptions_SkipAnimation) = 1, ConsolidateViews (ApplicationViewSwitchingOptions_ConsolidateViews) = 2,
}}
DEFINE_IID!(IID_IApplicationViewTitleBar, 9587392, 37675, 19051, 156, 75, 220, 56, 200, 36, 120, 206);
RT_INTERFACE!{interface IApplicationViewTitleBar(IApplicationViewTitleBarVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewTitleBar] {
    fn put_ForegroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ForegroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_BackgroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_BackgroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonForegroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonForegroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonBackgroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonBackgroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonHoverForegroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonHoverForegroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonHoverBackgroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonHoverBackgroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonPressedForegroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonPressedForegroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonPressedBackgroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonPressedBackgroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_InactiveForegroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_InactiveForegroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_InactiveBackgroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_InactiveBackgroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonInactiveForegroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonInactiveForegroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn put_ButtonInactiveBackgroundColor(&self, value: *mut super::super::foundation::IReference<super::Color>) -> HRESULT,
    fn get_ButtonInactiveBackgroundColor(&self, out: *mut *mut super::super::foundation::IReference<super::Color>) -> HRESULT
}}
impl IApplicationViewTitleBar {
    #[inline] pub unsafe fn set_foreground_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ForegroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackgroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_foreground_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonForegroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_foreground_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_background_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonBackgroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_background_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonBackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_hover_foreground_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonHoverForegroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_hover_foreground_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonHoverForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_hover_background_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonHoverBackgroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_hover_background_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonHoverBackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_pressed_foreground_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonPressedForegroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_pressed_foreground_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonPressedForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_pressed_background_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonPressedBackgroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_pressed_background_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonPressedBackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inactive_foreground_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InactiveForegroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inactive_foreground_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InactiveForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_inactive_background_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InactiveBackgroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_inactive_background_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InactiveBackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_inactive_foreground_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonInactiveForegroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_inactive_foreground_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonInactiveForegroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_button_inactive_background_color(&self, value: &super::super::foundation::IReference<super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ButtonInactiveBackgroundColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_button_inactive_background_color(&self) -> Result<ComPtr<super::super::foundation::IReference<super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ButtonInactiveBackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ApplicationViewTitleBar: IApplicationViewTitleBar}
DEFINE_IID!(IID_IApplicationViewTransferContext, 2239020131, 15383, 16526, 148, 8, 138, 26, 158, 168, 27, 250);
RT_INTERFACE!{interface IApplicationViewTransferContext(IApplicationViewTransferContextVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewTransferContext] {
    fn get_ViewId(&self, out: *mut i32) -> HRESULT,
    fn put_ViewId(&self, value: i32) -> HRESULT
}}
impl IApplicationViewTransferContext {
    #[inline] pub unsafe fn get_view_id(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ViewId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_view_id(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ViewId)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ApplicationViewTransferContext: IApplicationViewTransferContext}
impl RtActivatable<IApplicationViewTransferContextStatics> for ApplicationViewTransferContext {}
impl RtActivatable<IActivationFactory> for ApplicationViewTransferContext {}
impl ApplicationViewTransferContext {
    #[inline] pub fn get_data_package_format_id() -> Result<HString> { unsafe {
        <Self as RtActivatable<IApplicationViewTransferContextStatics>>::get_activation_factory().get_data_package_format_id()
    }}
}
DEFINE_CLSID!(ApplicationViewTransferContext(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,65,112,112,108,105,99,97,116,105,111,110,86,105,101,119,84,114,97,110,115,102,101,114,67,111,110,116,101,120,116,0]) [CLSID_ApplicationViewTransferContext]);
DEFINE_IID!(IID_IApplicationViewTransferContextStatics, 363371922, 56697, 19211, 188, 71, 213, 241, 149, 241, 70, 97);
RT_INTERFACE!{static interface IApplicationViewTransferContextStatics(IApplicationViewTransferContextStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationViewTransferContextStatics] {
    fn get_DataPackageFormatId(&self, out: *mut HSTRING) -> HRESULT
}}
impl IApplicationViewTransferContextStatics {
    #[inline] pub unsafe fn get_data_package_format_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataPackageFormatId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationViewWindowingMode: i32 {
    Auto (ApplicationViewWindowingMode_Auto) = 0, PreferredLaunchViewSize (ApplicationViewWindowingMode_PreferredLaunchViewSize) = 1, FullScreen (ApplicationViewWindowingMode_FullScreen) = 2,
}}
RT_ENUM! { enum FullScreenSystemOverlayMode: i32 {
    Standard (FullScreenSystemOverlayMode_Standard) = 0, Minimal (FullScreenSystemOverlayMode_Minimal) = 1,
}}
RT_ENUM! { enum HandPreference: i32 {
    LeftHanded (HandPreference_LeftHanded) = 0, RightHanded (HandPreference_RightHanded) = 1,
}}
DEFINE_IID!(IID_IInputPane, 1678432880, 1779, 19591, 166, 120, 152, 41, 201, 18, 124, 40);
RT_INTERFACE!{interface IInputPane(IInputPaneVtbl): IInspectable(IInspectableVtbl) [IID_IInputPane] {
    fn add_Showing(&self, handler: *mut super::super::foundation::TypedEventHandler<InputPane, InputPaneVisibilityEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Showing(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Hiding(&self, handler: *mut super::super::foundation::TypedEventHandler<InputPane, InputPaneVisibilityEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Hiding(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn get_OccludedRect(&self, out: *mut super::super::foundation::Rect) -> HRESULT
}}
impl IInputPane {
    #[inline] pub unsafe fn add_showing(&self, handler: &super::super::foundation::TypedEventHandler<InputPane, InputPaneVisibilityEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Showing)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_showing(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Showing)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_hiding(&self, handler: &super::super::foundation::TypedEventHandler<InputPane, InputPaneVisibilityEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Hiding)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_hiding(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Hiding)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_occluded_rect(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OccludedRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InputPane: IInputPane}
impl RtActivatable<IInputPaneStatics> for InputPane {}
impl InputPane {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<InputPane>> { unsafe {
        <Self as RtActivatable<IInputPaneStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(InputPane(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,73,110,112,117,116,80,97,110,101,0]) [CLSID_InputPane]);
DEFINE_IID!(IID_IInputPane2, 2322284326, 28816, 18323, 148, 76, 195, 242, 205, 226, 98, 118);
RT_INTERFACE!{interface IInputPane2(IInputPane2Vtbl): IInspectable(IInspectableVtbl) [IID_IInputPane2] {
    fn TryShow(&self, out: *mut bool) -> HRESULT,
    fn TryHide(&self, out: *mut bool) -> HRESULT
}}
impl IInputPane2 {
    #[inline] pub unsafe fn try_show(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryShow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_hide(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryHide)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInputPaneControl, 143372879, 38447, 18589, 170, 110, 198, 190, 26, 10, 110, 82);
RT_INTERFACE!{interface IInputPaneControl(IInputPaneControlVtbl): IInspectable(IInspectableVtbl) [IID_IInputPaneControl] {
    fn get_Visible(&self, out: *mut bool) -> HRESULT,
    fn put_Visible(&self, value: bool) -> HRESULT
}}
impl IInputPaneControl {
    #[inline] pub unsafe fn get_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Visible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInputPaneStatics, 2515840826, 61255, 16970, 151, 65, 253, 40, 21, 235, 162, 189);
RT_INTERFACE!{static interface IInputPaneStatics(IInputPaneStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IInputPaneStatics] {
    fn GetForCurrentView(&self, out: *mut *mut InputPane) -> HRESULT
}}
impl IInputPaneStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<InputPane>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInputPaneVisibilityEventArgs, 3527663638, 55559, 20428, 187, 141, 247, 123, 170, 80, 40, 241);
RT_INTERFACE!{interface IInputPaneVisibilityEventArgs(IInputPaneVisibilityEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IInputPaneVisibilityEventArgs] {
    fn get_OccludedRect(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn put_EnsuredFocusedElementInView(&self, value: bool) -> HRESULT,
    fn get_EnsuredFocusedElementInView(&self, out: *mut bool) -> HRESULT
}}
impl IInputPaneVisibilityEventArgs {
    #[inline] pub unsafe fn get_occluded_rect(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OccludedRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_ensured_focused_element_in_view(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EnsuredFocusedElementInView)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_ensured_focused_element_in_view(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EnsuredFocusedElementInView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class InputPaneVisibilityEventArgs: IInputPaneVisibilityEventArgs}
RT_CLASS!{static class ProjectionManager}
impl RtActivatable<IProjectionManagerStatics> for ProjectionManager {}
impl RtActivatable<IProjectionManagerStatics2> for ProjectionManager {}
impl ProjectionManager {
    #[inline] pub fn start_projecting_async(projectionViewId: i32, anchorViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics>>::get_activation_factory().start_projecting_async(projectionViewId, anchorViewId)
    }}
    #[inline] pub fn swap_displays_for_views_async(projectionViewId: i32, anchorViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics>>::get_activation_factory().swap_displays_for_views_async(projectionViewId, anchorViewId)
    }}
    #[inline] pub fn stop_projecting_async(projectionViewId: i32, anchorViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics>>::get_activation_factory().stop_projecting_async(projectionViewId, anchorViewId)
    }}
    #[inline] pub fn get_projection_display_available() -> Result<bool> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics>>::get_activation_factory().get_projection_display_available()
    }}
    #[inline] pub fn add_projection_display_available_changed(handler: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics>>::get_activation_factory().add_projection_display_available_changed(handler)
    }}
    #[inline] pub fn remove_projection_display_available_changed(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics>>::get_activation_factory().remove_projection_display_available_changed(token)
    }}
    #[cfg(feature="windows-devices")] #[inline] pub fn start_projecting_with_device_info_async(projectionViewId: i32, anchorViewId: i32, displayDeviceInfo: &super::super::devices::enumeration::DeviceInformation) -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics2>>::get_activation_factory().start_projecting_with_device_info_async(projectionViewId, anchorViewId, displayDeviceInfo)
    }}
    #[inline] pub fn request_start_projecting_async(projectionViewId: i32, anchorViewId: i32, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics2>>::get_activation_factory().request_start_projecting_async(projectionViewId, anchorViewId, selection)
    }}
    #[inline] pub fn request_start_projecting_with_placement_async(projectionViewId: i32, anchorViewId: i32, selection: super::super::foundation::Rect, prefferedPlacement: super::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics2>>::get_activation_factory().request_start_projecting_with_placement_async(projectionViewId, anchorViewId, selection, prefferedPlacement)
    }}
    #[inline] pub fn get_device_selector() -> Result<HString> { unsafe {
        <Self as RtActivatable<IProjectionManagerStatics2>>::get_activation_factory().get_device_selector()
    }}
}
DEFINE_CLSID!(ProjectionManager(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,80,114,111,106,101,99,116,105,111,110,77,97,110,97,103,101,114,0]) [CLSID_ProjectionManager]);
DEFINE_IID!(IID_IProjectionManagerStatics, 3059716413, 58096, 20477, 186, 149, 52, 36, 22, 71, 228, 92);
RT_INTERFACE!{static interface IProjectionManagerStatics(IProjectionManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IProjectionManagerStatics] {
    fn StartProjectingAsync(&self, projectionViewId: i32, anchorViewId: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn SwapDisplaysForViewsAsync(&self, projectionViewId: i32, anchorViewId: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn StopProjectingAsync(&self, projectionViewId: i32, anchorViewId: i32, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn get_ProjectionDisplayAvailable(&self, out: *mut bool) -> HRESULT,
    fn add_ProjectionDisplayAvailableChanged(&self, handler: *mut super::super::foundation::EventHandler<IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ProjectionDisplayAvailableChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IProjectionManagerStatics {
    #[inline] pub unsafe fn start_projecting_async(&self, projectionViewId: i32, anchorViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartProjectingAsync)(self as *const _ as *mut _, projectionViewId, anchorViewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn swap_displays_for_views_async(&self, projectionViewId: i32, anchorViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SwapDisplaysForViewsAsync)(self as *const _ as *mut _, projectionViewId, anchorViewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_projecting_async(&self, projectionViewId: i32, anchorViewId: i32) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StopProjectingAsync)(self as *const _ as *mut _, projectionViewId, anchorViewId, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_projection_display_available(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ProjectionDisplayAvailable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_projection_display_available_changed(&self, handler: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ProjectionDisplayAvailableChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_projection_display_available_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ProjectionDisplayAvailableChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IProjectionManagerStatics2, 4080873283, 10057, 19678, 185, 119, 192, 196, 30, 116, 21, 209);
RT_INTERFACE!{static interface IProjectionManagerStatics2(IProjectionManagerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IProjectionManagerStatics2] {
    #[cfg(not(feature="windows-devices"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-devices")] fn StartProjectingWithDeviceInfoAsync(&self, projectionViewId: i32, anchorViewId: i32, displayDeviceInfo: *mut super::super::devices::enumeration::DeviceInformation, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn RequestStartProjectingAsync(&self, projectionViewId: i32, anchorViewId: i32, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestStartProjectingWithPlacementAsync(&self, projectionViewId: i32, anchorViewId: i32, selection: super::super::foundation::Rect, prefferedPlacement: super::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn GetDeviceSelector(&self, out: *mut HSTRING) -> HRESULT
}}
impl IProjectionManagerStatics2 {
    #[cfg(feature="windows-devices")] #[inline] pub unsafe fn start_projecting_with_device_info_async(&self, projectionViewId: i32, anchorViewId: i32, displayDeviceInfo: &super::super::devices::enumeration::DeviceInformation) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartProjectingWithDeviceInfoAsync)(self as *const _ as *mut _, projectionViewId, anchorViewId, displayDeviceInfo as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_start_projecting_async(&self, projectionViewId: i32, anchorViewId: i32, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStartProjectingAsync)(self as *const _ as *mut _, projectionViewId, anchorViewId, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_start_projecting_with_placement_async(&self, projectionViewId: i32, anchorViewId: i32, selection: super::super::foundation::Rect, prefferedPlacement: super::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestStartProjectingWithPlacementAsync)(self as *const _ as *mut _, projectionViewId, anchorViewId, selection, prefferedPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_device_selector(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeviceSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum UIColorType: i32 {
    Background (UIColorType_Background) = 0, Foreground (UIColorType_Foreground) = 1, AccentDark3 (UIColorType_AccentDark3) = 2, AccentDark2 (UIColorType_AccentDark2) = 3, AccentDark1 (UIColorType_AccentDark1) = 4, Accent (UIColorType_Accent) = 5, AccentLight1 (UIColorType_AccentLight1) = 6, AccentLight2 (UIColorType_AccentLight2) = 7, AccentLight3 (UIColorType_AccentLight3) = 8, Complement (UIColorType_Complement) = 9,
}}
RT_ENUM! { enum UIElementType: i32 {
    ActiveCaption (UIElementType_ActiveCaption) = 0, Background (UIElementType_Background) = 1, ButtonFace (UIElementType_ButtonFace) = 2, ButtonText (UIElementType_ButtonText) = 3, CaptionText (UIElementType_CaptionText) = 4, GrayText (UIElementType_GrayText) = 5, Highlight (UIElementType_Highlight) = 6, HighlightText (UIElementType_HighlightText) = 7, Hotlight (UIElementType_Hotlight) = 8, InactiveCaption (UIElementType_InactiveCaption) = 9, InactiveCaptionText (UIElementType_InactiveCaptionText) = 10, Window (UIElementType_Window) = 11, WindowText (UIElementType_WindowText) = 12, AccentColor (UIElementType_AccentColor) = 1000, TextHigh (UIElementType_TextHigh) = 1001, TextMedium (UIElementType_TextMedium) = 1002, TextLow (UIElementType_TextLow) = 1003, TextContrastWithHigh (UIElementType_TextContrastWithHigh) = 1004, NonTextHigh (UIElementType_NonTextHigh) = 1005, NonTextMediumHigh (UIElementType_NonTextMediumHigh) = 1006, NonTextMedium (UIElementType_NonTextMedium) = 1007, NonTextMediumLow (UIElementType_NonTextMediumLow) = 1008, NonTextLow (UIElementType_NonTextLow) = 1009, PageBackground (UIElementType_PageBackground) = 1010, PopupBackground (UIElementType_PopupBackground) = 1011, OverlayOutsidePopup (UIElementType_OverlayOutsidePopup) = 1012,
}}
DEFINE_IID!(IID_IUISettings, 2234914304, 7267, 17959, 188, 177, 58, 137, 224, 188, 156, 85);
RT_INTERFACE!{interface IUISettings(IUISettingsVtbl): IInspectable(IInspectableVtbl) [IID_IUISettings] {
    fn get_HandPreference(&self, out: *mut HandPreference) -> HRESULT,
    fn get_CursorSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_ScrollBarSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_ScrollBarArrowSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_ScrollBarThumbBoxSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_MessageDuration(&self, out: *mut u32) -> HRESULT,
    fn get_AnimationsEnabled(&self, out: *mut bool) -> HRESULT,
    fn get_CaretBrowsingEnabled(&self, out: *mut bool) -> HRESULT,
    fn get_CaretBlinkRate(&self, out: *mut u32) -> HRESULT,
    fn get_CaretWidth(&self, out: *mut u32) -> HRESULT,
    fn get_DoubleClickTime(&self, out: *mut u32) -> HRESULT,
    fn get_MouseHoverTime(&self, out: *mut u32) -> HRESULT,
    fn UIElementColor(&self, desiredElement: UIElementType, out: *mut super::Color) -> HRESULT
}}
impl IUISettings {
    #[inline] pub unsafe fn get_hand_preference(&self) -> Result<HandPreference> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HandPreference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cursor_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CursorSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scroll_bar_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScrollBarSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scroll_bar_arrow_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScrollBarArrowSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_scroll_bar_thumb_box_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ScrollBarThumbBoxSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message_duration(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MessageDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_animations_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AnimationsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_caret_browsing_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaretBrowsingEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_caret_blink_rate(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaretBlinkRate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_caret_width(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CaretWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_double_click_time(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DoubleClickTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mouse_hover_time(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MouseHoverTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn uielement_color(&self, desiredElement: UIElementType) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).UIElementColor)(self as *const _ as *mut _, desiredElement, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class UISettings: IUISettings}
impl RtActivatable<IActivationFactory> for UISettings {}
DEFINE_CLSID!(UISettings(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,85,73,83,101,116,116,105,110,103,115,0]) [CLSID_UISettings]);
DEFINE_IID!(IID_IUISettings2, 3134727169, 10017, 17657, 187, 145, 43, 178, 40, 190, 68, 47);
RT_INTERFACE!{interface IUISettings2(IUISettings2Vtbl): IInspectable(IInspectableVtbl) [IID_IUISettings2] {
    fn get_TextScaleFactor(&self, out: *mut f64) -> HRESULT,
    fn add_TextScaleFactorChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<UISettings, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TextScaleFactorChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IUISettings2 {
    #[inline] pub unsafe fn get_text_scale_factor(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TextScaleFactor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_text_scale_factor_changed(&self, handler: &super::super::foundation::TypedEventHandler<UISettings, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TextScaleFactorChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_text_scale_factor_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TextScaleFactorChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUISettings3, 50469860, 21076, 18305, 129, 148, 81, 104, 247, 208, 109, 123);
RT_INTERFACE!{interface IUISettings3(IUISettings3Vtbl): IInspectable(IInspectableVtbl) [IID_IUISettings3] {
    fn GetColorValue(&self, desiredColor: UIColorType, out: *mut super::Color) -> HRESULT,
    fn add_ColorValuesChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<UISettings, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ColorValuesChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IUISettings3 {
    #[inline] pub unsafe fn get_color_value(&self, desiredColor: UIColorType) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetColorValue)(self as *const _ as *mut _, desiredColor, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_color_values_changed(&self, handler: &super::super::foundation::TypedEventHandler<UISettings, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ColorValuesChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_color_values_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ColorValuesChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUISettings4, 1387999234, 37275, 19819, 155, 120, 141, 214, 111, 244, 185, 59);
RT_INTERFACE!{interface IUISettings4(IUISettings4Vtbl): IInspectable(IInspectableVtbl) [IID_IUISettings4] {
    fn get_AdvancedEffectsEnabled(&self, out: *mut bool) -> HRESULT,
    fn add_AdvancedEffectsEnabledChanged(&self, handler: *mut super::super::foundation::TypedEventHandler<UISettings, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AdvancedEffectsEnabledChanged(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IUISettings4 {
    #[inline] pub unsafe fn get_advanced_effects_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AdvancedEffectsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_advanced_effects_enabled_changed(&self, handler: &super::super::foundation::TypedEventHandler<UISettings, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AdvancedEffectsEnabledChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_advanced_effects_enabled_changed(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AdvancedEffectsEnabledChanged)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIViewSettings, 3325450230, 34896, 18189, 136, 248, 69, 94, 22, 234, 44, 38);
RT_INTERFACE!{interface IUIViewSettings(IUIViewSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IUIViewSettings] {
    fn get_UserInteractionMode(&self, out: *mut UserInteractionMode) -> HRESULT
}}
impl IUIViewSettings {
    #[inline] pub unsafe fn get_user_interaction_mode(&self) -> Result<UserInteractionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UserInteractionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class UIViewSettings: IUIViewSettings}
impl RtActivatable<IUIViewSettingsStatics> for UIViewSettings {}
impl UIViewSettings {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<UIViewSettings>> { unsafe {
        <Self as RtActivatable<IUIViewSettingsStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(UIViewSettings(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,85,73,86,105,101,119,83,101,116,116,105,110,103,115,0]) [CLSID_UIViewSettings]);
DEFINE_IID!(IID_IUIViewSettingsStatics, 1499240357, 63734, 16847, 176, 251, 170, 205, 184, 31, 213, 246);
RT_INTERFACE!{static interface IUIViewSettingsStatics(IUIViewSettingsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IUIViewSettingsStatics] {
    fn GetForCurrentView(&self, out: *mut *mut UIViewSettings) -> HRESULT
}}
impl IUIViewSettingsStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<UIViewSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum UserInteractionMode: i32 {
    Mouse (UserInteractionMode_Mouse) = 0, Touch (UserInteractionMode_Touch) = 1,
}}
DEFINE_IID!(IID_IViewModePreferences, 2274348346, 2969, 17097, 132, 208, 211, 241, 212, 3, 85, 75);
RT_INTERFACE!{interface IViewModePreferences(IViewModePreferencesVtbl): IInspectable(IInspectableVtbl) [IID_IViewModePreferences] {
    fn get_ViewSizePreference(&self, out: *mut ViewSizePreference) -> HRESULT,
    fn put_ViewSizePreference(&self, value: ViewSizePreference) -> HRESULT,
    fn get_CustomSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn put_CustomSize(&self, value: super::super::foundation::Size) -> HRESULT
}}
impl IViewModePreferences {
    #[inline] pub unsafe fn get_view_size_preference(&self) -> Result<ViewSizePreference> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ViewSizePreference)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_view_size_preference(&self, value: ViewSizePreference) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ViewSizePreference)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CustomSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_size(&self, value: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CustomSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ViewModePreferences: IViewModePreferences}
impl RtActivatable<IViewModePreferencesStatics> for ViewModePreferences {}
impl ViewModePreferences {
    #[inline] pub fn create_default(mode: ApplicationViewMode) -> Result<ComPtr<ViewModePreferences>> { unsafe {
        <Self as RtActivatable<IViewModePreferencesStatics>>::get_activation_factory().create_default(mode)
    }}
}
DEFINE_CLSID!(ViewModePreferences(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,86,105,101,119,77,111,100,101,80,114,101,102,101,114,101,110,99,101,115,0]) [CLSID_ViewModePreferences]);
DEFINE_IID!(IID_IViewModePreferencesStatics, 1773537893, 24037, 16600, 131, 6, 56, 51, 223, 122, 34, 116);
RT_INTERFACE!{static interface IViewModePreferencesStatics(IViewModePreferencesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IViewModePreferencesStatics] {
    fn CreateDefault(&self, mode: ApplicationViewMode, out: *mut *mut ViewModePreferences) -> HRESULT
}}
impl IViewModePreferencesStatics {
    #[inline] pub unsafe fn create_default(&self, mode: ApplicationViewMode) -> Result<ComPtr<ViewModePreferences>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateDefault)(self as *const _ as *mut _, mode, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ViewSizePreference: i32 {
    Default (ViewSizePreference_Default) = 0, UseLess (ViewSizePreference_UseLess) = 1, UseHalf (ViewSizePreference_UseHalf) = 2, UseMore (ViewSizePreference_UseMore) = 3, UseMinimum (ViewSizePreference_UseMinimum) = 4, UseNone (ViewSizePreference_UseNone) = 5, Custom (ViewSizePreference_Custom) = 6,
}}
pub mod core { // Windows.UI.ViewManagement.Core
use ::prelude::*;
DEFINE_IID!(IID_ICoreInputView, 3346058618, 28673, 19506, 191, 148, 37, 193, 245, 84, 203, 241);
RT_INTERFACE!{interface ICoreInputView(ICoreInputViewVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInputView] {
    fn add_OcclusionsChanged(&self, handler: *mut ::rt::gen::windows::foundation::TypedEventHandler<CoreInputView, CoreInputViewOcclusionsChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_OcclusionsChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn GetCoreInputViewOcclusions(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<CoreInputViewOcclusion>) -> HRESULT,
    fn TryShowPrimaryView(&self, out: *mut bool) -> HRESULT,
    fn TryHidePrimaryView(&self, out: *mut bool) -> HRESULT
}}
impl ICoreInputView {
    #[inline] pub unsafe fn add_occlusions_changed(&self, handler: &::rt::gen::windows::foundation::TypedEventHandler<CoreInputView, CoreInputViewOcclusionsChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_OcclusionsChanged)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_occlusions_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_OcclusionsChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_core_input_view_occlusions(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<CoreInputViewOcclusion>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCoreInputViewOcclusions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_show_primary_view(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryShowPrimaryView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_hide_primary_view(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryHidePrimaryView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CoreInputView: ICoreInputView}
impl RtActivatable<ICoreInputViewStatics> for CoreInputView {}
impl CoreInputView {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<CoreInputView>> { unsafe {
        <Self as RtActivatable<ICoreInputViewStatics>>::get_activation_factory().get_for_current_view()
    }}
}
DEFINE_CLSID!(CoreInputView(&[87,105,110,100,111,119,115,46,85,73,46,86,105,101,119,77,97,110,97,103,101,109,101,110,116,46,67,111,114,101,46,67,111,114,101,73,110,112,117,116,86,105,101,119,0]) [CLSID_CoreInputView]);
DEFINE_IID!(IID_ICoreInputViewOcclusion, 3426143750, 14437, 16759, 181, 245, 139, 101, 224, 185, 206, 132);
RT_INTERFACE!{interface ICoreInputViewOcclusion(ICoreInputViewOcclusionVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInputViewOcclusion] {
    fn get_OccludingRect(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT,
    fn get_OcclusionKind(&self, out: *mut CoreInputViewOcclusionKind) -> HRESULT
}}
impl ICoreInputViewOcclusion {
    #[inline] pub unsafe fn get_occluding_rect(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OccludingRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_occlusion_kind(&self) -> Result<CoreInputViewOcclusionKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OcclusionKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CoreInputViewOcclusion: ICoreInputViewOcclusion}
RT_ENUM! { enum CoreInputViewOcclusionKind: i32 {
    Docked (CoreInputViewOcclusionKind_Docked) = 0, Floating (CoreInputViewOcclusionKind_Floating) = 1, Overlay (CoreInputViewOcclusionKind_Overlay) = 2,
}}
DEFINE_IID!(IID_ICoreInputViewOcclusionsChangedEventArgs, 3188729832, 46062, 19959, 149, 84, 137, 205, 198, 96, 130, 194);
RT_INTERFACE!{interface ICoreInputViewOcclusionsChangedEventArgs(ICoreInputViewOcclusionsChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInputViewOcclusionsChangedEventArgs] {
    fn get_Occlusions(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<CoreInputViewOcclusion>) -> HRESULT,
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl ICoreInputViewOcclusionsChangedEventArgs {
    #[inline] pub unsafe fn get_occlusions(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<CoreInputViewOcclusion>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Occlusions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CoreInputViewOcclusionsChangedEventArgs: ICoreInputViewOcclusionsChangedEventArgs}
DEFINE_IID!(IID_ICoreInputViewStatics, 2107348941, 60862, 18895, 165, 79, 51, 125, 224, 82, 144, 127);
RT_INTERFACE!{static interface ICoreInputViewStatics(ICoreInputViewStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICoreInputViewStatics] {
    fn GetForCurrentView(&self, out: *mut *mut CoreInputView) -> HRESULT
}}
impl ICoreInputViewStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<CoreInputView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.ViewManagement.Core
} // Windows.UI.ViewManagement
pub mod applicationsettings { // Windows.UI.ApplicationSettings
use ::prelude::*;
DEFINE_IID!(IID_IAccountsSettingsPane, 2179634220, 20233, 17414, 165, 56, 131, 141, 155, 20, 183, 230);
RT_INTERFACE!{interface IAccountsSettingsPane(IAccountsSettingsPaneVtbl): IInspectable(IInspectableVtbl) [IID_IAccountsSettingsPane] {
    fn add_AccountCommandsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<AccountsSettingsPane, AccountsSettingsPaneCommandsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AccountCommandsRequested(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAccountsSettingsPane {
    #[inline] pub unsafe fn add_account_commands_requested(&self, handler: &super::super::foundation::TypedEventHandler<AccountsSettingsPane, AccountsSettingsPaneCommandsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AccountCommandsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_account_commands_requested(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AccountCommandsRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AccountsSettingsPane: IAccountsSettingsPane}
impl RtActivatable<IAccountsSettingsPaneStatics> for AccountsSettingsPane {}
impl RtActivatable<IAccountsSettingsPaneStatics2> for AccountsSettingsPane {}
impl AccountsSettingsPane {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<AccountsSettingsPane>> { unsafe {
        <Self as RtActivatable<IAccountsSettingsPaneStatics>>::get_activation_factory().get_for_current_view()
    }}
    #[inline] pub fn show() -> Result<()> { unsafe {
        <Self as RtActivatable<IAccountsSettingsPaneStatics>>::get_activation_factory().show()
    }}
    #[inline] pub fn show_manage_accounts_async() -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IAccountsSettingsPaneStatics2>>::get_activation_factory().show_manage_accounts_async()
    }}
    #[inline] pub fn show_add_account_async() -> Result<ComPtr<super::super::foundation::IAsyncAction>> { unsafe {
        <Self as RtActivatable<IAccountsSettingsPaneStatics2>>::get_activation_factory().show_add_account_async()
    }}
}
DEFINE_CLSID!(AccountsSettingsPane(&[87,105,110,100,111,119,115,46,85,73,46,65,112,112,108,105,99,97,116,105,111,110,83,101,116,116,105,110,103,115,46,65,99,99,111,117,110,116,115,83,101,116,116,105,110,103,115,80,97,110,101,0]) [CLSID_AccountsSettingsPane]);
DEFINE_IID!(IID_IAccountsSettingsPaneCommandsRequestedEventArgs, 996720793, 56089, 17872, 154, 191, 149, 211, 119, 60, 147, 48);
RT_INTERFACE!{interface IAccountsSettingsPaneCommandsRequestedEventArgs(IAccountsSettingsPaneCommandsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAccountsSettingsPaneCommandsRequestedEventArgs] {
    fn get_WebAccountProviderCommands(&self, out: *mut *mut super::super::foundation::collections::IVector<WebAccountProviderCommand>) -> HRESULT,
    fn get_WebAccountCommands(&self, out: *mut *mut super::super::foundation::collections::IVector<WebAccountCommand>) -> HRESULT,
    fn get_CredentialCommands(&self, out: *mut *mut super::super::foundation::collections::IVector<CredentialCommand>) -> HRESULT,
    fn get_Commands(&self, out: *mut *mut super::super::foundation::collections::IVector<SettingsCommand>) -> HRESULT,
    fn get_HeaderText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_HeaderText(&self, value: HSTRING) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut AccountsSettingsPaneEventDeferral) -> HRESULT
}}
impl IAccountsSettingsPaneCommandsRequestedEventArgs {
    #[inline] pub unsafe fn get_web_account_provider_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<WebAccountProviderCommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WebAccountProviderCommands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_web_account_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<WebAccountCommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WebAccountCommands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_credential_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<CredentialCommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CredentialCommands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<SettingsCommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Commands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<AccountsSettingsPaneEventDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AccountsSettingsPaneCommandsRequestedEventArgs: IAccountsSettingsPaneCommandsRequestedEventArgs}
DEFINE_IID!(IID_IAccountsSettingsPaneEventDeferral, 3421658431, 58810, 16623, 147, 218, 101, 224, 150, 229, 251, 4);
RT_INTERFACE!{interface IAccountsSettingsPaneEventDeferral(IAccountsSettingsPaneEventDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IAccountsSettingsPaneEventDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IAccountsSettingsPaneEventDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AccountsSettingsPaneEventDeferral: IAccountsSettingsPaneEventDeferral}
DEFINE_IID!(IID_IAccountsSettingsPaneStatics, 1444907872, 45292, 16720, 168, 220, 32, 142, 228, 75, 6, 138);
RT_INTERFACE!{static interface IAccountsSettingsPaneStatics(IAccountsSettingsPaneStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAccountsSettingsPaneStatics] {
    fn GetForCurrentView(&self, out: *mut *mut AccountsSettingsPane) -> HRESULT,
    fn Show(&self) -> HRESULT
}}
impl IAccountsSettingsPaneStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<AccountsSettingsPane>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Show)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAccountsSettingsPaneStatics2, 3525179330, 52749, 18511, 184, 232, 232, 35, 194, 21, 118, 94);
RT_INTERFACE!{static interface IAccountsSettingsPaneStatics2(IAccountsSettingsPaneStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAccountsSettingsPaneStatics2] {
    fn ShowManageAccountsAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT,
    fn ShowAddAccountAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IAccountsSettingsPaneStatics2 {
    #[inline] pub unsafe fn show_manage_accounts_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowManageAccountsAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_add_account_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAddAccountAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICredentialCommand, 2784388582, 24899, 19066, 169, 113, 176, 23, 186, 151, 140, 226);
RT_INTERFACE!{interface ICredentialCommand(ICredentialCommandVtbl): IInspectable(IInspectableVtbl) [IID_ICredentialCommand] {
    #[cfg(not(feature="windows-security"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-security")] fn get_PasswordCredential(&self, out: *mut *mut super::super::security::credentials::PasswordCredential) -> HRESULT,
    fn get_CredentialDeleted(&self, out: *mut *mut CredentialCommandCredentialDeletedHandler) -> HRESULT
}}
impl ICredentialCommand {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_password_credential(&self) -> Result<ComPtr<super::super::security::credentials::PasswordCredential>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PasswordCredential)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_credential_deleted(&self) -> Result<ComPtr<CredentialCommandCredentialDeletedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CredentialDeleted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CredentialCommand: ICredentialCommand}
impl RtActivatable<ICredentialCommandFactory> for CredentialCommand {}
impl CredentialCommand {
    #[cfg(feature="windows-security")] #[inline] pub fn create_credential_command(passwordCredential: &super::super::security::credentials::PasswordCredential) -> Result<ComPtr<CredentialCommand>> { unsafe {
        <Self as RtActivatable<ICredentialCommandFactory>>::get_activation_factory().create_credential_command(passwordCredential)
    }}
    #[cfg(feature="windows-security")] #[inline] pub fn create_credential_command_with_handler(passwordCredential: &super::super::security::credentials::PasswordCredential, deleted: &CredentialCommandCredentialDeletedHandler) -> Result<ComPtr<CredentialCommand>> { unsafe {
        <Self as RtActivatable<ICredentialCommandFactory>>::get_activation_factory().create_credential_command_with_handler(passwordCredential, deleted)
    }}
}
DEFINE_CLSID!(CredentialCommand(&[87,105,110,100,111,119,115,46,85,73,46,65,112,112,108,105,99,97,116,105,111,110,83,101,116,116,105,110,103,115,46,67,114,101,100,101,110,116,105,97,108,67,111,109,109,97,110,100,0]) [CLSID_CredentialCommand]);
DEFINE_IID!(IID_CredentialCommandCredentialDeletedHandler, 1640030597, 2423, 18040, 180, 226, 152, 114, 122, 251, 238, 217);
RT_DELEGATE!{delegate CredentialCommandCredentialDeletedHandler(CredentialCommandCredentialDeletedHandlerVtbl, CredentialCommandCredentialDeletedHandlerImpl) [IID_CredentialCommandCredentialDeletedHandler] {
    fn Invoke(&self, command: *mut CredentialCommand) -> HRESULT
}}
impl CredentialCommandCredentialDeletedHandler {
    #[inline] pub unsafe fn invoke(&self, command: &CredentialCommand) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, command as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICredentialCommandFactory, 669551639, 48190, 19328, 148, 149, 78, 215, 32, 228, 138, 145);
RT_INTERFACE!{static interface ICredentialCommandFactory(ICredentialCommandFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICredentialCommandFactory] {
    #[cfg(feature="windows-security")] fn CreateCredentialCommand(&self, passwordCredential: *mut super::super::security::credentials::PasswordCredential, out: *mut *mut CredentialCommand) -> HRESULT,
    #[cfg(feature="windows-security")] fn CreateCredentialCommandWithHandler(&self, passwordCredential: *mut super::super::security::credentials::PasswordCredential, deleted: *mut CredentialCommandCredentialDeletedHandler, out: *mut *mut CredentialCommand) -> HRESULT
}}
impl ICredentialCommandFactory {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn create_credential_command(&self, passwordCredential: &super::super::security::credentials::PasswordCredential) -> Result<ComPtr<CredentialCommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCredentialCommand)(self as *const _ as *mut _, passwordCredential as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn create_credential_command_with_handler(&self, passwordCredential: &super::super::security::credentials::PasswordCredential, deleted: &CredentialCommandCredentialDeletedHandler) -> Result<ComPtr<CredentialCommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateCredentialCommandWithHandler)(self as *const _ as *mut _, passwordCredential as *const _ as *mut _, deleted as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SettingsCommand: super::popups::IUICommand}
impl RtActivatable<ISettingsCommandFactory> for SettingsCommand {}
impl RtActivatable<ISettingsCommandStatics> for SettingsCommand {}
impl SettingsCommand {
    #[inline] pub fn create_settings_command(settingsCommandId: &IInspectable, label: &HStringArg, handler: &super::popups::UICommandInvokedHandler) -> Result<ComPtr<SettingsCommand>> { unsafe {
        <Self as RtActivatable<ISettingsCommandFactory>>::get_activation_factory().create_settings_command(settingsCommandId, label, handler)
    }}
    #[inline] pub fn get_accounts_command() -> Result<ComPtr<SettingsCommand>> { unsafe {
        <Self as RtActivatable<ISettingsCommandStatics>>::get_activation_factory().get_accounts_command()
    }}
}
DEFINE_CLSID!(SettingsCommand(&[87,105,110,100,111,119,115,46,85,73,46,65,112,112,108,105,99,97,116,105,111,110,83,101,116,116,105,110,103,115,46,83,101,116,116,105,110,103,115,67,111,109,109,97,110,100,0]) [CLSID_SettingsCommand]);
DEFINE_IID!(IID_ISettingsCommandFactory, 1759599411, 7299, 17210, 170, 90, 206, 238, 165, 189, 71, 100);
RT_INTERFACE!{static interface ISettingsCommandFactory(ISettingsCommandFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISettingsCommandFactory] {
    fn CreateSettingsCommand(&self, settingsCommandId: *mut IInspectable, label: HSTRING, handler: *mut super::popups::UICommandInvokedHandler, out: *mut *mut SettingsCommand) -> HRESULT
}}
impl ISettingsCommandFactory {
    #[inline] pub unsafe fn create_settings_command(&self, settingsCommandId: &IInspectable, label: &HStringArg, handler: &super::popups::UICommandInvokedHandler) -> Result<ComPtr<SettingsCommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSettingsCommand)(self as *const _ as *mut _, settingsCommandId as *const _ as *mut _, label.get(), handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISettingsCommandStatics, 1956309332, 12137, 19223, 138, 186, 208, 92, 229, 119, 142, 70);
RT_INTERFACE!{static interface ISettingsCommandStatics(ISettingsCommandStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISettingsCommandStatics] {
    fn get_AccountsCommand(&self, out: *mut *mut SettingsCommand) -> HRESULT
}}
impl ISettingsCommandStatics {
    #[inline] pub unsafe fn get_accounts_command(&self) -> Result<ComPtr<SettingsCommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccountsCommand)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum SettingsEdgeLocation: i32 {
    Right (SettingsEdgeLocation_Right) = 0, Left (SettingsEdgeLocation_Left) = 1,
}}
DEFINE_IID!(IID_ISettingsPane, 2983004466, 17776, 19561, 141, 56, 137, 68, 101, 97, 172, 224);
RT_INTERFACE!{interface ISettingsPane(ISettingsPaneVtbl): IInspectable(IInspectableVtbl) [IID_ISettingsPane] {
    fn add_CommandsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<SettingsPane, SettingsPaneCommandsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CommandsRequested(&self, cookie: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISettingsPane {
    #[inline] pub unsafe fn add_commands_requested(&self, handler: &super::super::foundation::TypedEventHandler<SettingsPane, SettingsPaneCommandsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CommandsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_commands_requested(&self, cookie: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CommandsRequested)(self as *const _ as *mut _, cookie);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class SettingsPane: ISettingsPane}
impl RtActivatable<ISettingsPaneStatics> for SettingsPane {}
impl SettingsPane {
    #[inline] pub fn get_for_current_view() -> Result<ComPtr<SettingsPane>> { unsafe {
        <Self as RtActivatable<ISettingsPaneStatics>>::get_activation_factory().get_for_current_view()
    }}
    #[inline] pub fn show() -> Result<()> { unsafe {
        <Self as RtActivatable<ISettingsPaneStatics>>::get_activation_factory().show()
    }}
    #[inline] pub fn get_edge() -> Result<SettingsEdgeLocation> { unsafe {
        <Self as RtActivatable<ISettingsPaneStatics>>::get_activation_factory().get_edge()
    }}
}
DEFINE_CLSID!(SettingsPane(&[87,105,110,100,111,119,115,46,85,73,46,65,112,112,108,105,99,97,116,105,111,110,83,101,116,116,105,110,103,115,46,83,101,116,116,105,110,103,115,80,97,110,101,0]) [CLSID_SettingsPane]);
DEFINE_IID!(IID_ISettingsPaneCommandsRequest, 1155474350, 23918, 16488, 161, 104, 244, 118, 67, 24, 33, 20);
RT_INTERFACE!{interface ISettingsPaneCommandsRequest(ISettingsPaneCommandsRequestVtbl): IInspectable(IInspectableVtbl) [IID_ISettingsPaneCommandsRequest] {
    fn get_ApplicationCommands(&self, out: *mut *mut super::super::foundation::collections::IVector<SettingsCommand>) -> HRESULT
}}
impl ISettingsPaneCommandsRequest {
    #[inline] pub unsafe fn get_application_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<SettingsCommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ApplicationCommands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SettingsPaneCommandsRequest: ISettingsPaneCommandsRequest}
DEFINE_IID!(IID_ISettingsPaneCommandsRequestedEventArgs, 543120676, 6984, 17961, 166, 202, 47, 223, 237, 175, 183, 93);
RT_INTERFACE!{interface ISettingsPaneCommandsRequestedEventArgs(ISettingsPaneCommandsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISettingsPaneCommandsRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut SettingsPaneCommandsRequest) -> HRESULT
}}
impl ISettingsPaneCommandsRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<SettingsPaneCommandsRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SettingsPaneCommandsRequestedEventArgs: ISettingsPaneCommandsRequestedEventArgs}
DEFINE_IID!(IID_ISettingsPaneStatics, 476730053, 65305, 18203, 186, 107, 248, 243, 86, 148, 173, 154);
RT_INTERFACE!{static interface ISettingsPaneStatics(ISettingsPaneStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISettingsPaneStatics] {
    fn GetForCurrentView(&self, out: *mut *mut SettingsPane) -> HRESULT,
    fn Show(&self) -> HRESULT,
    fn get_Edge(&self, out: *mut SettingsEdgeLocation) -> HRESULT
}}
impl ISettingsPaneStatics {
    #[inline] pub unsafe fn get_for_current_view(&self) -> Result<ComPtr<SettingsPane>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForCurrentView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Show)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_edge(&self) -> Result<SettingsEdgeLocation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Edge)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum SupportedWebAccountActions: u32 {
    None (SupportedWebAccountActions_None) = 0, Reconnect (SupportedWebAccountActions_Reconnect) = 1, Remove (SupportedWebAccountActions_Remove) = 2, ViewDetails (SupportedWebAccountActions_ViewDetails) = 4, Manage (SupportedWebAccountActions_Manage) = 8, More (SupportedWebAccountActions_More) = 16,
}}
RT_ENUM! { enum WebAccountAction: i32 {
    Reconnect (WebAccountAction_Reconnect) = 0, Remove (WebAccountAction_Remove) = 1, ViewDetails (WebAccountAction_ViewDetails) = 2, Manage (WebAccountAction_Manage) = 3, More (WebAccountAction_More) = 4,
}}
DEFINE_IID!(IID_IWebAccountCommand, 3399717784, 40186, 16966, 176, 196, 169, 19, 163, 137, 101, 65);
RT_INTERFACE!{interface IWebAccountCommand(IWebAccountCommandVtbl): IInspectable(IInspectableVtbl) [IID_IWebAccountCommand] {
    #[cfg(not(feature="windows-security"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-security")] fn get_WebAccount(&self, out: *mut *mut super::super::security::credentials::WebAccount) -> HRESULT,
    fn get_Invoked(&self, out: *mut *mut WebAccountCommandInvokedHandler) -> HRESULT,
    fn get_Actions(&self, out: *mut SupportedWebAccountActions) -> HRESULT
}}
impl IWebAccountCommand {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_web_account(&self) -> Result<ComPtr<super::super::security::credentials::WebAccount>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WebAccount)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invoked(&self) -> Result<ComPtr<WebAccountCommandInvokedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Invoked)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actions(&self) -> Result<SupportedWebAccountActions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Actions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class WebAccountCommand: IWebAccountCommand}
impl RtActivatable<IWebAccountCommandFactory> for WebAccountCommand {}
impl WebAccountCommand {
    #[cfg(feature="windows-security")] #[inline] pub fn create_web_account_command(webAccount: &super::super::security::credentials::WebAccount, invoked: &WebAccountCommandInvokedHandler, actions: SupportedWebAccountActions) -> Result<ComPtr<WebAccountCommand>> { unsafe {
        <Self as RtActivatable<IWebAccountCommandFactory>>::get_activation_factory().create_web_account_command(webAccount, invoked, actions)
    }}
}
DEFINE_CLSID!(WebAccountCommand(&[87,105,110,100,111,119,115,46,85,73,46,65,112,112,108,105,99,97,116,105,111,110,83,101,116,116,105,110,103,115,46,87,101,98,65,99,99,111,117,110,116,67,111,109,109,97,110,100,0]) [CLSID_WebAccountCommand]);
DEFINE_IID!(IID_IWebAccountCommandFactory, 3215379967, 12077, 17141, 129, 222, 29, 86, 186, 252, 73, 109);
RT_INTERFACE!{static interface IWebAccountCommandFactory(IWebAccountCommandFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IWebAccountCommandFactory] {
    #[cfg(feature="windows-security")] fn CreateWebAccountCommand(&self, webAccount: *mut super::super::security::credentials::WebAccount, invoked: *mut WebAccountCommandInvokedHandler, actions: SupportedWebAccountActions, out: *mut *mut WebAccountCommand) -> HRESULT
}}
impl IWebAccountCommandFactory {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn create_web_account_command(&self, webAccount: &super::super::security::credentials::WebAccount, invoked: &WebAccountCommandInvokedHandler, actions: SupportedWebAccountActions) -> Result<ComPtr<WebAccountCommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWebAccountCommand)(self as *const _ as *mut _, webAccount as *const _ as *mut _, invoked as *const _ as *mut _, actions, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_WebAccountCommandInvokedHandler, 518448217, 5893, 19098, 181, 153, 160, 195, 214, 146, 25, 115);
RT_DELEGATE!{delegate WebAccountCommandInvokedHandler(WebAccountCommandInvokedHandlerVtbl, WebAccountCommandInvokedHandlerImpl) [IID_WebAccountCommandInvokedHandler] {
    fn Invoke(&self, command: *mut WebAccountCommand, args: *mut WebAccountInvokedArgs) -> HRESULT
}}
impl WebAccountCommandInvokedHandler {
    #[inline] pub unsafe fn invoke(&self, command: &WebAccountCommand, args: &WebAccountInvokedArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, command as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWebAccountInvokedArgs, 3886795840, 41432, 19549, 154, 127, 29, 52, 178, 249, 10, 210);
RT_INTERFACE!{interface IWebAccountInvokedArgs(IWebAccountInvokedArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWebAccountInvokedArgs] {
    fn get_Action(&self, out: *mut WebAccountAction) -> HRESULT
}}
impl IWebAccountInvokedArgs {
    #[inline] pub unsafe fn get_action(&self) -> Result<WebAccountAction> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Action)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class WebAccountInvokedArgs: IWebAccountInvokedArgs}
DEFINE_IID!(IID_IWebAccountProviderCommand, 3600539034, 41126, 20123, 136, 220, 199, 30, 117, 122, 53, 1);
RT_INTERFACE!{interface IWebAccountProviderCommand(IWebAccountProviderCommandVtbl): IInspectable(IInspectableVtbl) [IID_IWebAccountProviderCommand] {
    #[cfg(not(feature="windows-security"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-security")] fn get_WebAccountProvider(&self, out: *mut *mut super::super::security::credentials::WebAccountProvider) -> HRESULT,
    fn get_Invoked(&self, out: *mut *mut WebAccountProviderCommandInvokedHandler) -> HRESULT
}}
impl IWebAccountProviderCommand {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn get_web_account_provider(&self) -> Result<ComPtr<super::super::security::credentials::WebAccountProvider>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WebAccountProvider)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invoked(&self) -> Result<ComPtr<WebAccountProviderCommandInvokedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Invoked)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WebAccountProviderCommand: IWebAccountProviderCommand}
impl RtActivatable<IWebAccountProviderCommandFactory> for WebAccountProviderCommand {}
impl WebAccountProviderCommand {
    #[cfg(feature="windows-security")] #[inline] pub fn create_web_account_provider_command(webAccountProvider: &super::super::security::credentials::WebAccountProvider, invoked: &WebAccountProviderCommandInvokedHandler) -> Result<ComPtr<WebAccountProviderCommand>> { unsafe {
        <Self as RtActivatable<IWebAccountProviderCommandFactory>>::get_activation_factory().create_web_account_provider_command(webAccountProvider, invoked)
    }}
}
DEFINE_CLSID!(WebAccountProviderCommand(&[87,105,110,100,111,119,115,46,85,73,46,65,112,112,108,105,99,97,116,105,111,110,83,101,116,116,105,110,103,115,46,87,101,98,65,99,99,111,117,110,116,80,114,111,118,105,100,101,114,67,111,109,109,97,110,100,0]) [CLSID_WebAccountProviderCommand]);
DEFINE_IID!(IID_IWebAccountProviderCommandFactory, 3580201499, 45430, 18294, 132, 105, 169, 211, 255, 11, 63, 89);
RT_INTERFACE!{static interface IWebAccountProviderCommandFactory(IWebAccountProviderCommandFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IWebAccountProviderCommandFactory] {
    #[cfg(feature="windows-security")] fn CreateWebAccountProviderCommand(&self, webAccountProvider: *mut super::super::security::credentials::WebAccountProvider, invoked: *mut WebAccountProviderCommandInvokedHandler, out: *mut *mut WebAccountProviderCommand) -> HRESULT
}}
impl IWebAccountProviderCommandFactory {
    #[cfg(feature="windows-security")] #[inline] pub unsafe fn create_web_account_provider_command(&self, webAccountProvider: &super::super::security::credentials::WebAccountProvider, invoked: &WebAccountProviderCommandInvokedHandler) -> Result<ComPtr<WebAccountProviderCommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWebAccountProviderCommand)(self as *const _ as *mut _, webAccountProvider as *const _ as *mut _, invoked as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_WebAccountProviderCommandInvokedHandler, 3084801319, 19599, 17117, 132, 218, 94, 196, 147, 171, 219, 154);
RT_DELEGATE!{delegate WebAccountProviderCommandInvokedHandler(WebAccountProviderCommandInvokedHandlerVtbl, WebAccountProviderCommandInvokedHandlerImpl) [IID_WebAccountProviderCommandInvokedHandler] {
    fn Invoke(&self, command: *mut WebAccountProviderCommand) -> HRESULT
}}
impl WebAccountProviderCommandInvokedHandler {
    #[inline] pub unsafe fn invoke(&self, command: &WebAccountProviderCommand) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, command as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
} // Windows.UI.ApplicationSettings
pub mod webui { // Windows.UI.WebUI
use ::prelude::*;
DEFINE_IID!(IID_IActivatedDeferral, 3283949944, 42033, 18904, 167, 106, 57, 90, 78, 3, 220, 243);
RT_INTERFACE!{interface IActivatedDeferral(IActivatedDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IActivatedDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IActivatedDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ActivatedDeferral: IActivatedDeferral}
DEFINE_IID!(IID_IActivatedEventArgsDeferral, 3396165492, 25538, 17574, 185, 123, 217, 160, 60, 32, 188, 155);
RT_INTERFACE!{interface IActivatedEventArgsDeferral(IActivatedEventArgsDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IActivatedEventArgsDeferral] {
    fn get_ActivatedOperation(&self, out: *mut *mut ActivatedOperation) -> HRESULT
}}
impl IActivatedEventArgsDeferral {
    #[inline] pub unsafe fn get_activated_operation(&self) -> Result<ComPtr<ActivatedOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActivatedOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ActivatedEventHandler, 1358030640, 50641, 19307, 154, 219, 138, 17, 117, 107, 226, 156);
RT_DELEGATE!{delegate ActivatedEventHandler(ActivatedEventHandlerVtbl, ActivatedEventHandlerImpl) [IID_ActivatedEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, eventArgs: *mut super::super::applicationmodel::activation::IActivatedEventArgs) -> HRESULT
}}
impl ActivatedEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, eventArgs: &super::super::applicationmodel::activation::IActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, eventArgs as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IActivatedOperation, 3063985340, 50890, 17149, 152, 24, 113, 144, 78, 69, 254, 215);
RT_INTERFACE!{interface IActivatedOperation(IActivatedOperationVtbl): IInspectable(IInspectableVtbl) [IID_IActivatedOperation] {
    fn GetDeferral(&self, out: *mut *mut ActivatedDeferral) -> HRESULT
}}
impl IActivatedOperation {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<ActivatedDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ActivatedOperation: IActivatedOperation}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class EnteredBackgroundEventArgs: super::super::applicationmodel::IEnteredBackgroundEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class EnteredBackgroundEventArgs: IInspectable}
DEFINE_IID!(IID_EnteredBackgroundEventHandler, 722051443, 46734, 19951, 136, 193, 141, 232, 78, 90, 171, 47);
RT_DELEGATE!{delegate EnteredBackgroundEventHandler(EnteredBackgroundEventHandlerVtbl, EnteredBackgroundEventHandlerImpl) [IID_EnteredBackgroundEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::super::applicationmodel::IEnteredBackgroundEventArgs) -> HRESULT
}}
impl EnteredBackgroundEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::super::applicationmodel::IEnteredBackgroundEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHtmlPrintDocumentSource, 3467003546, 3589, 18042, 171, 201, 54, 236, 29, 76, 220, 182);
RT_INTERFACE!{interface IHtmlPrintDocumentSource(IHtmlPrintDocumentSourceVtbl): IInspectable(IInspectableVtbl) [IID_IHtmlPrintDocumentSource] {
    fn get_Content(&self, out: *mut PrintContent) -> HRESULT,
    fn put_Content(&self, value: PrintContent) -> HRESULT,
    fn get_LeftMargin(&self, out: *mut f32) -> HRESULT,
    fn put_LeftMargin(&self, value: f32) -> HRESULT,
    fn get_TopMargin(&self, out: *mut f32) -> HRESULT,
    fn put_TopMargin(&self, value: f32) -> HRESULT,
    fn get_RightMargin(&self, out: *mut f32) -> HRESULT,
    fn put_RightMargin(&self, value: f32) -> HRESULT,
    fn get_BottomMargin(&self, out: *mut f32) -> HRESULT,
    fn put_BottomMargin(&self, value: f32) -> HRESULT,
    fn get_EnableHeaderFooter(&self, out: *mut bool) -> HRESULT,
    fn put_EnableHeaderFooter(&self, value: bool) -> HRESULT,
    fn get_ShrinkToFit(&self, out: *mut bool) -> HRESULT,
    fn put_ShrinkToFit(&self, value: bool) -> HRESULT,
    fn get_PercentScale(&self, out: *mut f32) -> HRESULT,
    fn put_PercentScale(&self, scalePercent: f32) -> HRESULT,
    fn get_PageRange(&self, out: *mut HSTRING) -> HRESULT,
    fn TrySetPageRange(&self, strPageRange: HSTRING, out: *mut bool) -> HRESULT
}}
impl IHtmlPrintDocumentSource {
    #[inline] pub unsafe fn get_content(&self) -> Result<PrintContent> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content(&self, value: PrintContent) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Content)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left_margin(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LeftMargin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_left_margin(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LeftMargin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_top_margin(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TopMargin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_top_margin(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TopMargin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_margin(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RightMargin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_right_margin(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RightMargin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bottom_margin(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BottomMargin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_bottom_margin(&self, value: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BottomMargin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_enable_header_footer(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EnableHeaderFooter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enable_header_footer(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EnableHeaderFooter)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_shrink_to_fit(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShrinkToFit)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_shrink_to_fit(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShrinkToFit)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_percent_scale(&self) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PercentScale)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_percent_scale(&self, scalePercent: f32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PercentScale)(self as *const _ as *mut _, scalePercent);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_page_range(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PageRange)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_set_page_range(&self, strPageRange: &HStringArg) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TrySetPageRange)(self as *const _ as *mut _, strPageRange.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class HtmlPrintDocumentSource: IHtmlPrintDocumentSource}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class LeavingBackgroundEventArgs: super::super::applicationmodel::ILeavingBackgroundEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class LeavingBackgroundEventArgs: IInspectable}
DEFINE_IID!(IID_LeavingBackgroundEventHandler, 11848921, 31388, 19307, 154, 196, 19, 71, 79, 38, 139, 196);
RT_DELEGATE!{delegate LeavingBackgroundEventHandler(LeavingBackgroundEventHandlerVtbl, LeavingBackgroundEventHandlerImpl) [IID_LeavingBackgroundEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::super::applicationmodel::ILeavingBackgroundEventArgs) -> HRESULT
}}
impl LeavingBackgroundEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::super::applicationmodel::ILeavingBackgroundEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_NavigatedEventHandler, 2062839782, 16586, 20041, 167, 214, 219, 219, 51, 12, 209, 163);
RT_DELEGATE!{delegate NavigatedEventHandler(NavigatedEventHandlerVtbl, NavigatedEventHandlerImpl) [IID_NavigatedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut IWebUINavigatedEventArgs) -> HRESULT
}}
impl NavigatedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &IWebUINavigatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum PrintContent: i32 {
    AllPages (PrintContent_AllPages) = 0, CurrentPage (PrintContent_CurrentPage) = 1, CustomPageRange (PrintContent_CustomPageRange) = 2, CurrentSelection (PrintContent_CurrentSelection) = 3,
}}
DEFINE_IID!(IID_ResumingEventHandler, 643406761, 41517, 18438, 167, 40, 172, 173, 193, 208, 117, 250);
RT_DELEGATE!{delegate ResumingEventHandler(ResumingEventHandlerVtbl, ResumingEventHandlerImpl) [IID_ResumingEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable) -> HRESULT
}}
impl ResumingEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class SuspendingDeferral: super::super::applicationmodel::ISuspendingDeferral}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class SuspendingDeferral: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class SuspendingEventArgs: super::super::applicationmodel::ISuspendingEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class SuspendingEventArgs: IInspectable}
DEFINE_IID!(IID_SuspendingEventHandler, 1352417948, 30946, 18563, 171, 200, 137, 96, 220, 222, 27, 92);
RT_DELEGATE!{delegate SuspendingEventHandler(SuspendingEventHandlerVtbl, SuspendingEventHandlerImpl) [IID_SuspendingEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::super::applicationmodel::ISuspendingEventArgs) -> HRESULT
}}
impl SuspendingEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::super::applicationmodel::ISuspendingEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class SuspendingOperation: super::super::applicationmodel::ISuspendingOperation}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class SuspendingOperation: IInspectable}
DEFINE_IID!(IID_IWebUIActivationStatics, 890996413, 17331, 18475, 133, 219, 53, 216, 123, 81, 122, 217);
RT_INTERFACE!{static interface IWebUIActivationStatics(IWebUIActivationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IWebUIActivationStatics] {
    fn add_Activated(&self, handler: *mut ActivatedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Activated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Suspending(&self, handler: *mut SuspendingEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Suspending(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Resuming(&self, handler: *mut ResumingEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Resuming(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Navigated(&self, handler: *mut NavigatedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Navigated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IWebUIActivationStatics {
    #[inline] pub unsafe fn add_activated(&self, handler: &ActivatedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Activated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_activated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Activated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_suspending(&self, handler: &SuspendingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Suspending)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_suspending(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Suspending)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_resuming(&self, handler: &ResumingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Resuming)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resuming(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Resuming)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigated(&self, handler: &NavigatedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Navigated)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Navigated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWebUIActivationStatics2, 3370682006, 19832, 19108, 143, 6, 42, 158, 173, 198, 196, 10);
RT_INTERFACE!{static interface IWebUIActivationStatics2(IWebUIActivationStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IWebUIActivationStatics2] {
    fn add_LeavingBackground(&self, handler: *mut LeavingBackgroundEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LeavingBackground(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_EnteredBackground(&self, handler: *mut EnteredBackgroundEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EnteredBackground(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn EnablePrelaunch(&self, value: bool) -> HRESULT
}}
impl IWebUIActivationStatics2 {
    #[inline] pub unsafe fn add_leaving_background(&self, handler: &LeavingBackgroundEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LeavingBackground)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_leaving_background(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LeavingBackground)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_entered_background(&self, handler: &EnteredBackgroundEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EnteredBackground)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_entered_background(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EnteredBackground)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn enable_prelaunch(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).EnablePrelaunch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWebUIActivationStatics3, 2443949702, 6901, 17477, 180, 159, 148, 89, 244, 15, 200, 222);
RT_INTERFACE!{static interface IWebUIActivationStatics3(IWebUIActivationStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IWebUIActivationStatics3] {
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn RequestRestartAsync(&self, launchArguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::applicationmodel::core::AppRestartFailureReason>) -> HRESULT,
    #[cfg(all(feature="windows-applicationmodel",feature="windows-system"))] fn RequestRestartForUserAsync(&self, user: *mut super::super::system::User, launchArguments: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::applicationmodel::core::AppRestartFailureReason>) -> HRESULT
}}
impl IWebUIActivationStatics3 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn request_restart_async(&self, launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::applicationmodel::core::AppRestartFailureReason>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestRestartAsync)(self as *const _ as *mut _, launchArguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(all(feature="windows-applicationmodel",feature="windows-system"))] #[inline] pub unsafe fn request_restart_for_user_async(&self, user: &super::super::system::User, launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::applicationmodel::core::AppRestartFailureReason>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestRestartForUserAsync)(self as *const _ as *mut _, user as *const _ as *mut _, launchArguments.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class WebUIApplication}
impl RtActivatable<IWebUIActivationStatics> for WebUIApplication {}
impl RtActivatable<IWebUIActivationStatics2> for WebUIApplication {}
impl RtActivatable<IWebUIActivationStatics3> for WebUIApplication {}
impl WebUIApplication {
    #[inline] pub fn add_activated(handler: &ActivatedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().add_activated(handler)
    }}
    #[inline] pub fn remove_activated(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().remove_activated(token)
    }}
    #[inline] pub fn add_suspending(handler: &SuspendingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().add_suspending(handler)
    }}
    #[inline] pub fn remove_suspending(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().remove_suspending(token)
    }}
    #[inline] pub fn add_resuming(handler: &ResumingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().add_resuming(handler)
    }}
    #[inline] pub fn remove_resuming(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().remove_resuming(token)
    }}
    #[inline] pub fn add_navigated(handler: &NavigatedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().add_navigated(handler)
    }}
    #[inline] pub fn remove_navigated(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics>>::get_activation_factory().remove_navigated(token)
    }}
    #[inline] pub fn add_leaving_background(handler: &LeavingBackgroundEventHandler) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics2>>::get_activation_factory().add_leaving_background(handler)
    }}
    #[inline] pub fn remove_leaving_background(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics2>>::get_activation_factory().remove_leaving_background(token)
    }}
    #[inline] pub fn add_entered_background(handler: &EnteredBackgroundEventHandler) -> Result<super::super::foundation::EventRegistrationToken> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics2>>::get_activation_factory().add_entered_background(handler)
    }}
    #[inline] pub fn remove_entered_background(token: super::super::foundation::EventRegistrationToken) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics2>>::get_activation_factory().remove_entered_background(token)
    }}
    #[inline] pub fn enable_prelaunch(value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics2>>::get_activation_factory().enable_prelaunch(value)
    }}
    #[cfg(feature="windows-applicationmodel")] #[inline] pub fn request_restart_async(launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::applicationmodel::core::AppRestartFailureReason>>> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics3>>::get_activation_factory().request_restart_async(launchArguments)
    }}
    #[cfg(all(feature="windows-applicationmodel",feature="windows-system"))] #[inline] pub fn request_restart_for_user_async(user: &super::super::system::User, launchArguments: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::applicationmodel::core::AppRestartFailureReason>>> { unsafe {
        <Self as RtActivatable<IWebUIActivationStatics3>>::get_activation_factory().request_restart_for_user_async(user, launchArguments)
    }}
}
DEFINE_CLSID!(WebUIApplication(&[87,105,110,100,111,119,115,46,85,73,46,87,101,98,85,73,46,87,101,98,85,73,65,112,112,108,105,99,97,116,105,111,110,0]) [CLSID_WebUIApplication]);
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIAppointmentsProviderAddAppointmentActivatedEventArgs: super::super::applicationmodel::activation::IAppointmentsProviderAddAppointmentActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIAppointmentsProviderAddAppointmentActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIAppointmentsProviderRemoveAppointmentActivatedEventArgs: super::super::applicationmodel::activation::IAppointmentsProviderRemoveAppointmentActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIAppointmentsProviderRemoveAppointmentActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIAppointmentsProviderReplaceAppointmentActivatedEventArgs: super::super::applicationmodel::activation::IAppointmentsProviderReplaceAppointmentActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIAppointmentsProviderReplaceAppointmentActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIAppointmentsProviderShowAppointmentDetailsActivatedEventArgs: super::super::applicationmodel::activation::IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIAppointmentsProviderShowAppointmentDetailsActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIAppointmentsProviderShowTimeFrameActivatedEventArgs: super::super::applicationmodel::activation::IAppointmentsProviderShowTimeFrameActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIAppointmentsProviderShowTimeFrameActivatedEventArgs: IInspectable}
DEFINE_IID!(IID_IWebUIBackgroundTaskInstance, 603008037, 58103, 18241, 188, 156, 57, 69, 149, 222, 36, 220);
RT_INTERFACE!{interface IWebUIBackgroundTaskInstance(IWebUIBackgroundTaskInstanceVtbl): IInspectable(IInspectableVtbl) [IID_IWebUIBackgroundTaskInstance] {
    fn get_Succeeded(&self, out: *mut bool) -> HRESULT,
    fn put_Succeeded(&self, succeeded: bool) -> HRESULT
}}
impl IWebUIBackgroundTaskInstance {
    #[inline] pub unsafe fn get_succeeded(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Succeeded)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_succeeded(&self, succeeded: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Succeeded)(self as *const _ as *mut _, succeeded);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{static class WebUIBackgroundTaskInstance}
impl RtActivatable<IWebUIBackgroundTaskInstanceStatics> for WebUIBackgroundTaskInstance {}
impl WebUIBackgroundTaskInstance {
    #[inline] pub fn get_current() -> Result<ComPtr<IWebUIBackgroundTaskInstance>> { unsafe {
        <Self as RtActivatable<IWebUIBackgroundTaskInstanceStatics>>::get_activation_factory().get_current()
    }}
}
DEFINE_CLSID!(WebUIBackgroundTaskInstance(&[87,105,110,100,111,119,115,46,85,73,46,87,101,98,85,73,46,87,101,98,85,73,66,97,99,107,103,114,111,117,110,100,84,97,115,107,73,110,115,116,97,110,99,101,0]) [CLSID_WebUIBackgroundTaskInstance]);
RT_CLASS!{class WebUIBackgroundTaskInstanceRuntimeClass: IWebUIBackgroundTaskInstance}
DEFINE_IID!(IID_IWebUIBackgroundTaskInstanceStatics, 2625262225, 6574, 19619, 185, 75, 254, 78, 199, 68, 167, 64);
RT_INTERFACE!{static interface IWebUIBackgroundTaskInstanceStatics(IWebUIBackgroundTaskInstanceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IWebUIBackgroundTaskInstanceStatics] {
    fn get_Current(&self, out: *mut *mut IWebUIBackgroundTaskInstance) -> HRESULT
}}
impl IWebUIBackgroundTaskInstanceStatics {
    #[inline] pub unsafe fn get_current(&self) -> Result<ComPtr<IWebUIBackgroundTaskInstance>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Current)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUICachedFileUpdaterActivatedEventArgs: super::super::applicationmodel::activation::ICachedFileUpdaterActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUICachedFileUpdaterActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUICameraSettingsActivatedEventArgs: super::super::applicationmodel::activation::ICameraSettingsActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUICameraSettingsActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUICommandLineActivatedEventArgs: super::super::applicationmodel::activation::ICommandLineActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUICommandLineActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactCallActivatedEventArgs: super::super::applicationmodel::activation::IContactCallActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactCallActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactMapActivatedEventArgs: super::super::applicationmodel::activation::IContactMapActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactMapActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactMessageActivatedEventArgs: super::super::applicationmodel::activation::IContactMessageActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactMessageActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactPanelActivatedEventArgs: super::super::applicationmodel::activation::IContactPanelActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactPanelActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactPickerActivatedEventArgs: super::super::applicationmodel::activation::IContactPickerActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactPickerActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactPostActivatedEventArgs: super::super::applicationmodel::activation::IContactPostActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactPostActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIContactVideoCallActivatedEventArgs: super::super::applicationmodel::activation::IContactVideoCallActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIContactVideoCallActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIDeviceActivatedEventArgs: super::super::applicationmodel::activation::IDeviceActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIDeviceActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIDevicePairingActivatedEventArgs: super::super::applicationmodel::activation::IDevicePairingActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIDevicePairingActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIDialReceiverActivatedEventArgs: super::super::applicationmodel::activation::IDialReceiverActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIDialReceiverActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIFileActivatedEventArgs: super::super::applicationmodel::activation::IFileActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIFileActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIFileOpenPickerActivatedEventArgs: super::super::applicationmodel::activation::IFileOpenPickerActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIFileOpenPickerActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIFileOpenPickerContinuationEventArgs: super::super::applicationmodel::activation::IFileOpenPickerContinuationEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIFileOpenPickerContinuationEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIFileSavePickerActivatedEventArgs: super::super::applicationmodel::activation::IFileSavePickerActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIFileSavePickerActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIFileSavePickerContinuationEventArgs: super::super::applicationmodel::activation::IFileSavePickerContinuationEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIFileSavePickerContinuationEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIFolderPickerContinuationEventArgs: super::super::applicationmodel::activation::IFolderPickerContinuationEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIFolderPickerContinuationEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUILaunchActivatedEventArgs: super::super::applicationmodel::activation::ILaunchActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUILaunchActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUILockScreenActivatedEventArgs: super::super::applicationmodel::activation::ILockScreenActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUILockScreenActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUILockScreenCallActivatedEventArgs: super::super::applicationmodel::activation::ILockScreenCallActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUILockScreenCallActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUILockScreenComponentActivatedEventArgs: super::super::applicationmodel::activation::IActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUILockScreenComponentActivatedEventArgs: IInspectable}
DEFINE_IID!(IID_IWebUINavigatedDeferral, 3624149069, 33567, 18146, 180, 50, 58, 252, 226, 17, 249, 98);
RT_INTERFACE!{interface IWebUINavigatedDeferral(IWebUINavigatedDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IWebUINavigatedDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IWebUINavigatedDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class WebUINavigatedDeferral: IWebUINavigatedDeferral}
DEFINE_IID!(IID_IWebUINavigatedEventArgs, 2807579064, 9369, 16432, 166, 157, 21, 210, 217, 207, 229, 36);
RT_INTERFACE!{interface IWebUINavigatedEventArgs(IWebUINavigatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWebUINavigatedEventArgs] {
    fn get_NavigatedOperation(&self, out: *mut *mut WebUINavigatedOperation) -> HRESULT
}}
impl IWebUINavigatedEventArgs {
    #[inline] pub unsafe fn get_navigated_operation(&self) -> Result<ComPtr<WebUINavigatedOperation>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NavigatedOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WebUINavigatedEventArgs: IWebUINavigatedEventArgs}
DEFINE_IID!(IID_IWebUINavigatedOperation, 2056675080, 33154, 19081, 171, 103, 132, 146, 232, 117, 13, 75);
RT_INTERFACE!{interface IWebUINavigatedOperation(IWebUINavigatedOperationVtbl): IInspectable(IInspectableVtbl) [IID_IWebUINavigatedOperation] {
    fn GetDeferral(&self, out: *mut *mut WebUINavigatedDeferral) -> HRESULT
}}
impl IWebUINavigatedOperation {
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<WebUINavigatedDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WebUINavigatedOperation: IWebUINavigatedOperation}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIPrint3DWorkflowActivatedEventArgs: super::super::applicationmodel::activation::IPrint3DWorkflowActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIPrint3DWorkflowActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIPrintTaskSettingsActivatedEventArgs: super::super::applicationmodel::activation::IPrintTaskSettingsActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIPrintTaskSettingsActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIPrintWorkflowForegroundTaskActivatedEventArgs: super::super::applicationmodel::activation::IActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIPrintWorkflowForegroundTaskActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIProtocolActivatedEventArgs: super::super::applicationmodel::activation::IProtocolActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIProtocolActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIProtocolForResultsActivatedEventArgs: super::super::applicationmodel::activation::IProtocolForResultsActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIProtocolForResultsActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIRestrictedLaunchActivatedEventArgs: super::super::applicationmodel::activation::IRestrictedLaunchActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIRestrictedLaunchActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUISearchActivatedEventArgs: super::super::applicationmodel::activation::ISearchActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUISearchActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIShareTargetActivatedEventArgs: super::super::applicationmodel::activation::IShareTargetActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIShareTargetActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIStartupTaskActivatedEventArgs: super::super::applicationmodel::activation::IStartupTaskActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIStartupTaskActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIToastNotificationActivatedEventArgs: super::super::applicationmodel::activation::IToastNotificationActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIToastNotificationActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIUserDataAccountProviderActivatedEventArgs: super::super::applicationmodel::activation::IUserDataAccountProviderActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIUserDataAccountProviderActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIVoiceCommandActivatedEventArgs: super::super::applicationmodel::activation::IVoiceCommandActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIVoiceCommandActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIWalletActionActivatedEventArgs: super::super::applicationmodel::activation::IWalletActionActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIWalletActionActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIWebAccountProviderActivatedEventArgs: super::super::applicationmodel::activation::IWebAccountProviderActivatedEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIWebAccountProviderActivatedEventArgs: IInspectable}
#[cfg(feature="windows-applicationmodel")] RT_CLASS!{class WebUIWebAuthenticationBrokerContinuationEventArgs: super::super::applicationmodel::activation::IWebAuthenticationBrokerContinuationEventArgs}
#[cfg(not(feature="windows-applicationmodel"))] RT_CLASS!{class WebUIWebAuthenticationBrokerContinuationEventArgs: IInspectable}
} // Windows.UI.WebUI
pub mod shell { // Windows.UI.Shell
use ::prelude::*;
DEFINE_IID!(IID_IAdaptiveCard, 1926256268, 41588, 16845, 130, 168, 152, 157, 64, 185, 176, 94);
RT_INTERFACE!{interface IAdaptiveCard(IAdaptiveCardVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveCard] {
    fn ToJson(&self, out: *mut HSTRING) -> HRESULT
}}
impl IAdaptiveCard {
    #[inline] pub unsafe fn to_json(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ToJson)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class AdaptiveCardBuilder}
impl RtActivatable<IAdaptiveCardBuilderStatics> for AdaptiveCardBuilder {}
impl AdaptiveCardBuilder {
    #[inline] pub fn create_adaptive_card_from_json(value: &HStringArg) -> Result<ComPtr<IAdaptiveCard>> { unsafe {
        <Self as RtActivatable<IAdaptiveCardBuilderStatics>>::get_activation_factory().create_adaptive_card_from_json(value)
    }}
}
DEFINE_CLSID!(AdaptiveCardBuilder(&[87,105,110,100,111,119,115,46,85,73,46,83,104,101,108,108,46,65,100,97,112,116,105,118,101,67,97,114,100,66,117,105,108,100,101,114,0]) [CLSID_AdaptiveCardBuilder]);
DEFINE_IID!(IID_IAdaptiveCardBuilderStatics, 1986891528, 54270, 17223, 160, 188, 185, 234, 154, 109, 194, 142);
RT_INTERFACE!{static interface IAdaptiveCardBuilderStatics(IAdaptiveCardBuilderStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveCardBuilderStatics] {
    fn CreateAdaptiveCardFromJson(&self, value: HSTRING, out: *mut *mut IAdaptiveCard) -> HRESULT
}}
impl IAdaptiveCardBuilderStatics {
    #[inline] pub unsafe fn create_adaptive_card_from_json(&self, value: &HStringArg) -> Result<ComPtr<IAdaptiveCard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateAdaptiveCardFromJson)(self as *const _ as *mut _, value.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITaskbarManager, 2269710873, 6873, 18932, 178, 232, 134, 115, 141, 197, 172, 64);
RT_INTERFACE!{interface ITaskbarManager(ITaskbarManagerVtbl): IInspectable(IInspectableVtbl) [IID_ITaskbarManager] {
    fn get_IsSupported(&self, out: *mut bool) -> HRESULT,
    fn get_IsPinningAllowed(&self, out: *mut bool) -> HRESULT,
    fn IsCurrentAppPinnedAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn IsAppListEntryPinnedAsync(&self, appListEntry: *mut super::super::applicationmodel::core::AppListEntry, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestPinCurrentAppAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn RequestPinAppListEntryAsync(&self, appListEntry: *mut super::super::applicationmodel::core::AppListEntry, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ITaskbarManager {
    #[inline] pub unsafe fn get_is_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_pinning_allowed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPinningAllowed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_current_app_pinned_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).IsCurrentAppPinnedAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn is_app_list_entry_pinned_async(&self, appListEntry: &super::super::applicationmodel::core::AppListEntry) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).IsAppListEntryPinnedAsync)(self as *const _ as *mut _, appListEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_pin_current_app_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestPinCurrentAppAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn request_pin_app_list_entry_async(&self, appListEntry: &super::super::applicationmodel::core::AppListEntry) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestPinAppListEntryAsync)(self as *const _ as *mut _, appListEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TaskbarManager: ITaskbarManager}
impl RtActivatable<ITaskbarManagerStatics> for TaskbarManager {}
impl TaskbarManager {
    #[inline] pub fn get_default() -> Result<ComPtr<TaskbarManager>> { unsafe {
        <Self as RtActivatable<ITaskbarManagerStatics>>::get_activation_factory().get_default()
    }}
}
DEFINE_CLSID!(TaskbarManager(&[87,105,110,100,111,119,115,46,85,73,46,83,104,101,108,108,46,84,97,115,107,98,97,114,77,97,110,97,103,101,114,0]) [CLSID_TaskbarManager]);
DEFINE_IID!(IID_ITaskbarManagerStatics, 3677530996, 56914, 20454, 183, 182, 149, 255, 159, 131, 149, 223);
RT_INTERFACE!{static interface ITaskbarManagerStatics(ITaskbarManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ITaskbarManagerStatics] {
    fn GetDefault(&self, out: *mut *mut TaskbarManager) -> HRESULT
}}
impl ITaskbarManagerStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<TaskbarManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
} // Windows.UI.Shell
pub mod startscreen { // Windows.UI.StartScreen
use ::prelude::*;
RT_ENUM! { enum ForegroundText: i32 {
    Dark (ForegroundText_Dark) = 0, Light (ForegroundText_Light) = 1,
}}
DEFINE_IID!(IID_IJumpList, 2955103294, 52591, 19638, 166, 17, 97, 253, 80, 95, 62, 209);
RT_INTERFACE!{interface IJumpList(IJumpListVtbl): IInspectable(IInspectableVtbl) [IID_IJumpList] {
    fn get_Items(&self, out: *mut *mut super::super::foundation::collections::IVector<JumpListItem>) -> HRESULT,
    fn get_SystemGroupKind(&self, out: *mut JumpListSystemGroupKind) -> HRESULT,
    fn put_SystemGroupKind(&self, value: JumpListSystemGroupKind) -> HRESULT,
    fn SaveAsync(&self, out: *mut *mut super::super::foundation::IAsyncAction) -> HRESULT
}}
impl IJumpList {
    #[inline] pub unsafe fn get_items(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<JumpListItem>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Items)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_system_group_kind(&self) -> Result<JumpListSystemGroupKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SystemGroupKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_system_group_kind(&self, value: JumpListSystemGroupKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SystemGroupKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn save_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncAction>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SaveAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class JumpList: IJumpList}
impl RtActivatable<IJumpListStatics> for JumpList {}
impl JumpList {
    #[inline] pub fn load_current_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<JumpList>>> { unsafe {
        <Self as RtActivatable<IJumpListStatics>>::get_activation_factory().load_current_async()
    }}
    #[inline] pub fn is_supported() -> Result<bool> { unsafe {
        <Self as RtActivatable<IJumpListStatics>>::get_activation_factory().is_supported()
    }}
}
DEFINE_CLSID!(JumpList(&[87,105,110,100,111,119,115,46,85,73,46,83,116,97,114,116,83,99,114,101,101,110,46,74,117,109,112,76,105,115,116,0]) [CLSID_JumpList]);
DEFINE_IID!(IID_IJumpListItem, 2061199127, 35677, 18464, 153, 91, 155, 65, 141, 190, 72, 176);
RT_INTERFACE!{interface IJumpListItem(IJumpListItemVtbl): IInspectable(IInspectableVtbl) [IID_IJumpListItem] {
    fn get_Kind(&self, out: *mut JumpListItemKind) -> HRESULT,
    fn get_Arguments(&self, out: *mut HSTRING) -> HRESULT,
    fn get_RemovedByUser(&self, out: *mut bool) -> HRESULT,
    fn get_Description(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Description(&self, value: HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_GroupName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_GroupName(&self, value: HSTRING) -> HRESULT,
    fn get_Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT
}}
impl IJumpListItem {
    #[inline] pub unsafe fn get_kind(&self) -> Result<JumpListItemKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_arguments(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_removed_by_user(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RemovedByUser)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_description(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Description)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_description(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Description)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_group_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GroupName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_group_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_GroupName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class JumpListItem: IJumpListItem}
impl RtActivatable<IJumpListItemStatics> for JumpListItem {}
impl JumpListItem {
    #[inline] pub fn create_with_arguments(arguments: &HStringArg, displayName: &HStringArg) -> Result<ComPtr<JumpListItem>> { unsafe {
        <Self as RtActivatable<IJumpListItemStatics>>::get_activation_factory().create_with_arguments(arguments, displayName)
    }}
    #[inline] pub fn create_separator() -> Result<ComPtr<JumpListItem>> { unsafe {
        <Self as RtActivatable<IJumpListItemStatics>>::get_activation_factory().create_separator()
    }}
}
DEFINE_CLSID!(JumpListItem(&[87,105,110,100,111,119,115,46,85,73,46,83,116,97,114,116,83,99,114,101,101,110,46,74,117,109,112,76,105,115,116,73,116,101,109,0]) [CLSID_JumpListItem]);
RT_ENUM! { enum JumpListItemKind: i32 {
    Arguments (JumpListItemKind_Arguments) = 0, Separator (JumpListItemKind_Separator) = 1,
}}
DEFINE_IID!(IID_IJumpListItemStatics, 4055876840, 51114, 18891, 141, 222, 236, 252, 205, 122, 215, 228);
RT_INTERFACE!{static interface IJumpListItemStatics(IJumpListItemStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IJumpListItemStatics] {
    fn CreateWithArguments(&self, arguments: HSTRING, displayName: HSTRING, out: *mut *mut JumpListItem) -> HRESULT,
    fn CreateSeparator(&self, out: *mut *mut JumpListItem) -> HRESULT
}}
impl IJumpListItemStatics {
    #[inline] pub unsafe fn create_with_arguments(&self, arguments: &HStringArg, displayName: &HStringArg) -> Result<ComPtr<JumpListItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithArguments)(self as *const _ as *mut _, arguments.get(), displayName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_separator(&self) -> Result<ComPtr<JumpListItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateSeparator)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IJumpListStatics, 2816525953, 59006, 19316, 130, 80, 63, 50, 44, 77, 146, 195);
RT_INTERFACE!{static interface IJumpListStatics(IJumpListStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IJumpListStatics] {
    fn LoadCurrentAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<JumpList>) -> HRESULT,
    fn IsSupported(&self, out: *mut bool) -> HRESULT
}}
impl IJumpListStatics {
    #[inline] pub unsafe fn load_current_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<JumpList>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LoadCurrentAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn is_supported(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).IsSupported)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum JumpListSystemGroupKind: i32 {
    None (JumpListSystemGroupKind_None) = 0, Frequent (JumpListSystemGroupKind_Frequent) = 1, Recent (JumpListSystemGroupKind_Recent) = 2,
}}
DEFINE_IID!(IID_ISecondaryTile, 2661175776, 11189, 19392, 187, 141, 66, 178, 58, 188, 200, 141);
RT_INTERFACE!{interface ISecondaryTile(ISecondaryTileVtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTile] {
    fn put_TileId(&self, value: HSTRING) -> HRESULT,
    fn get_TileId(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Arguments(&self, value: HSTRING) -> HRESULT,
    fn get_Arguments(&self, out: *mut HSTRING) -> HRESULT,
    fn put_ShortName(&self, value: HSTRING) -> HRESULT,
    fn get_ShortName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DisplayName(&self, value: HSTRING) -> HRESULT,
    fn get_DisplayName(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_SmallLogo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_SmallLogo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_WideLogo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_WideLogo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_LockScreenBadgeLogo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_LockScreenBadgeLogo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_LockScreenDisplayBadgeAndTileText(&self, value: bool) -> HRESULT,
    fn get_LockScreenDisplayBadgeAndTileText(&self, out: *mut bool) -> HRESULT,
    fn put_TileOptions(&self, value: TileOptions) -> HRESULT,
    fn get_TileOptions(&self, out: *mut TileOptions) -> HRESULT,
    fn put_ForegroundText(&self, value: ForegroundText) -> HRESULT,
    fn get_ForegroundText(&self, out: *mut ForegroundText) -> HRESULT,
    fn put_BackgroundColor(&self, value: super::Color) -> HRESULT,
    fn get_BackgroundColor(&self, out: *mut super::Color) -> HRESULT,
    fn RequestCreateAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestCreateAsyncWithPoint(&self, invocationPoint: super::super::foundation::Point, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestCreateAsyncWithRect(&self, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestCreateAsyncWithRectAndPlacement(&self, selection: super::super::foundation::Rect, preferredPlacement: super::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestDeleteAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestDeleteAsyncWithPoint(&self, invocationPoint: super::super::foundation::Point, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestDeleteAsyncWithRect(&self, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn RequestDeleteAsyncWithRectAndPlacement(&self, selection: super::super::foundation::Rect, preferredPlacement: super::popups::Placement, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    fn UpdateAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl ISecondaryTile {
    #[inline] pub unsafe fn set_tile_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TileId)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tile_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TileId)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_arguments(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Arguments)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_arguments(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Arguments)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_short_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShortName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_short_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ShortName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_small_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SmallLogo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_small_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SmallLogo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_wide_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_WideLogo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wide_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WideLogo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_lock_screen_badge_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LockScreenBadgeLogo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lock_screen_badge_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LockScreenBadgeLogo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_lock_screen_display_badge_and_tile_text(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LockScreenDisplayBadgeAndTileText)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_lock_screen_display_badge_and_tile_text(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LockScreenDisplayBadgeAndTileText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tile_options(&self, value: TileOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TileOptions)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tile_options(&self) -> Result<TileOptions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TileOptions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground_text(&self, value: ForegroundText) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ForegroundText)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_text(&self) -> Result<ForegroundText> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForegroundText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background_color(&self, value: super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackgroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_color(&self) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_create_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestCreateAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_create_async_with_point(&self, invocationPoint: super::super::foundation::Point) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestCreateAsyncWithPoint)(self as *const _ as *mut _, invocationPoint, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_create_async_with_rect(&self, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestCreateAsyncWithRect)(self as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_create_async_with_rect_and_placement(&self, selection: super::super::foundation::Rect, preferredPlacement: super::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestCreateAsyncWithRectAndPlacement)(self as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_delete_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestDeleteAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_delete_async_with_point(&self, invocationPoint: super::super::foundation::Point) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestDeleteAsyncWithPoint)(self as *const _ as *mut _, invocationPoint, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_delete_async_with_rect(&self, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestDeleteAsyncWithRect)(self as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn request_delete_async_with_rect_and_placement(&self, selection: super::super::foundation::Rect, preferredPlacement: super::popups::Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestDeleteAsyncWithRectAndPlacement)(self as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn update_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).UpdateAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class SecondaryTile: ISecondaryTile}
impl RtActivatable<ISecondaryTileFactory> for SecondaryTile {}
impl RtActivatable<ISecondaryTileFactory2> for SecondaryTile {}
impl RtActivatable<ISecondaryTileStatics> for SecondaryTile {}
impl RtActivatable<IActivationFactory> for SecondaryTile {}
impl SecondaryTile {
    #[inline] pub fn create_tile(tileId: &HStringArg, shortName: &HStringArg, displayName: &HStringArg, arguments: &HStringArg, tileOptions: TileOptions, logoReference: &super::super::foundation::Uri) -> Result<ComPtr<SecondaryTile>> { unsafe {
        <Self as RtActivatable<ISecondaryTileFactory>>::get_activation_factory().create_tile(tileId, shortName, displayName, arguments, tileOptions, logoReference)
    }}
    #[inline] pub fn create_wide_tile(tileId: &HStringArg, shortName: &HStringArg, displayName: &HStringArg, arguments: &HStringArg, tileOptions: TileOptions, logoReference: &super::super::foundation::Uri, wideLogoReference: &super::super::foundation::Uri) -> Result<ComPtr<SecondaryTile>> { unsafe {
        <Self as RtActivatable<ISecondaryTileFactory>>::get_activation_factory().create_wide_tile(tileId, shortName, displayName, arguments, tileOptions, logoReference, wideLogoReference)
    }}
    #[inline] pub fn create_with_id(tileId: &HStringArg) -> Result<ComPtr<SecondaryTile>> { unsafe {
        <Self as RtActivatable<ISecondaryTileFactory>>::get_activation_factory().create_with_id(tileId)
    }}
    #[inline] pub fn create_minimal_tile(tileId: &HStringArg, displayName: &HStringArg, arguments: &HStringArg, square150x150Logo: &super::super::foundation::Uri, desiredSize: TileSize) -> Result<ComPtr<SecondaryTile>> { unsafe {
        <Self as RtActivatable<ISecondaryTileFactory2>>::get_activation_factory().create_minimal_tile(tileId, displayName, arguments, square150x150Logo, desiredSize)
    }}
    #[inline] pub fn exists(tileId: &HStringArg) -> Result<bool> { unsafe {
        <Self as RtActivatable<ISecondaryTileStatics>>::get_activation_factory().exists(tileId)
    }}
    #[inline] pub fn find_all_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>>> { unsafe {
        <Self as RtActivatable<ISecondaryTileStatics>>::get_activation_factory().find_all_async()
    }}
    #[inline] pub fn find_all_for_application_async(applicationId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>>> { unsafe {
        <Self as RtActivatable<ISecondaryTileStatics>>::get_activation_factory().find_all_for_application_async(applicationId)
    }}
    #[inline] pub fn find_all_for_package_async() -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>>> { unsafe {
        <Self as RtActivatable<ISecondaryTileStatics>>::get_activation_factory().find_all_for_package_async()
    }}
}
DEFINE_CLSID!(SecondaryTile(&[87,105,110,100,111,119,115,46,85,73,46,83,116,97,114,116,83,99,114,101,101,110,46,83,101,99,111,110,100,97,114,121,84,105,108,101,0]) [CLSID_SecondaryTile]);
DEFINE_IID!(IID_ISecondaryTile2, 3002518581, 12880, 18832, 146, 60, 41, 74, 180, 182, 148, 221);
RT_INTERFACE!{interface ISecondaryTile2(ISecondaryTile2Vtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTile2] {
    fn put_PhoneticName(&self, value: HSTRING) -> HRESULT,
    fn get_PhoneticName(&self, out: *mut HSTRING) -> HRESULT,
    fn get_VisualElements(&self, out: *mut *mut SecondaryTileVisualElements) -> HRESULT,
    fn put_RoamingEnabled(&self, value: bool) -> HRESULT,
    fn get_RoamingEnabled(&self, out: *mut bool) -> HRESULT,
    fn add_VisualElementsRequested(&self, handler: *mut super::super::foundation::TypedEventHandler<SecondaryTile, VisualElementsRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VisualElementsRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl ISecondaryTile2 {
    #[inline] pub unsafe fn set_phonetic_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PhoneticName)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phonetic_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PhoneticName)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visual_elements(&self) -> Result<ComPtr<SecondaryTileVisualElements>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VisualElements)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_roaming_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoamingEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_roaming_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RoamingEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_visual_elements_requested(&self, handler: &super::super::foundation::TypedEventHandler<SecondaryTile, VisualElementsRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VisualElementsRequested)(self as *const _ as *mut _, handler as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_visual_elements_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VisualElementsRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISecondaryTileFactory, 1475685536, 20924, 19135, 142, 191, 98, 122, 3, 152, 176, 90);
RT_INTERFACE!{static interface ISecondaryTileFactory(ISecondaryTileFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileFactory] {
    fn CreateTile(&self, tileId: HSTRING, shortName: HSTRING, displayName: HSTRING, arguments: HSTRING, tileOptions: TileOptions, logoReference: *mut super::super::foundation::Uri, out: *mut *mut SecondaryTile) -> HRESULT,
    fn CreateWideTile(&self, tileId: HSTRING, shortName: HSTRING, displayName: HSTRING, arguments: HSTRING, tileOptions: TileOptions, logoReference: *mut super::super::foundation::Uri, wideLogoReference: *mut super::super::foundation::Uri, out: *mut *mut SecondaryTile) -> HRESULT,
    fn CreateWithId(&self, tileId: HSTRING, out: *mut *mut SecondaryTile) -> HRESULT
}}
impl ISecondaryTileFactory {
    #[inline] pub unsafe fn create_tile(&self, tileId: &HStringArg, shortName: &HStringArg, displayName: &HStringArg, arguments: &HStringArg, tileOptions: TileOptions, logoReference: &super::super::foundation::Uri) -> Result<ComPtr<SecondaryTile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateTile)(self as *const _ as *mut _, tileId.get(), shortName.get(), displayName.get(), arguments.get(), tileOptions, logoReference as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_wide_tile(&self, tileId: &HStringArg, shortName: &HStringArg, displayName: &HStringArg, arguments: &HStringArg, tileOptions: TileOptions, logoReference: &super::super::foundation::Uri, wideLogoReference: &super::super::foundation::Uri) -> Result<ComPtr<SecondaryTile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWideTile)(self as *const _ as *mut _, tileId.get(), shortName.get(), displayName.get(), arguments.get(), tileOptions, logoReference as *const _ as *mut _, wideLogoReference as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_id(&self, tileId: &HStringArg) -> Result<ComPtr<SecondaryTile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithId)(self as *const _ as *mut _, tileId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISecondaryTileFactory2, 659262011, 21037, 17550, 158, 178, 208, 103, 42, 179, 69, 200);
RT_INTERFACE!{static interface ISecondaryTileFactory2(ISecondaryTileFactory2Vtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileFactory2] {
    fn CreateMinimalTile(&self, tileId: HSTRING, displayName: HSTRING, arguments: HSTRING, square150x150Logo: *mut super::super::foundation::Uri, desiredSize: TileSize, out: *mut *mut SecondaryTile) -> HRESULT
}}
impl ISecondaryTileFactory2 {
    #[inline] pub unsafe fn create_minimal_tile(&self, tileId: &HStringArg, displayName: &HStringArg, arguments: &HStringArg, square150x150Logo: &super::super::foundation::Uri, desiredSize: TileSize) -> Result<ComPtr<SecondaryTile>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateMinimalTile)(self as *const _ as *mut _, tileId.get(), displayName.get(), arguments.get(), square150x150Logo as *const _ as *mut _, desiredSize, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISecondaryTileStatics, 2576387502, 53329, 18038, 135, 254, 158, 194, 66, 216, 60, 116);
RT_INTERFACE!{static interface ISecondaryTileStatics(ISecondaryTileStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileStatics] {
    fn Exists(&self, tileId: HSTRING, out: *mut bool) -> HRESULT,
    fn FindAllAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>) -> HRESULT,
    fn FindAllForApplicationAsync(&self, applicationId: HSTRING, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>) -> HRESULT,
    fn FindAllForPackageAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>) -> HRESULT
}}
impl ISecondaryTileStatics {
    #[inline] pub unsafe fn exists(&self, tileId: &HStringArg) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Exists)(self as *const _ as *mut _, tileId.get(), &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_for_application_async(&self, applicationId: &HStringArg) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllForApplicationAsync)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_all_for_package_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::foundation::collections::IVectorView<SecondaryTile>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindAllForPackageAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISecondaryTileVisualElements, 495842099, 33118, 16703, 159, 80, 168, 29, 167, 10, 150, 178);
RT_INTERFACE!{interface ISecondaryTileVisualElements(ISecondaryTileVisualElementsVtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileVisualElements] {
    fn put_Square30x30Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Square30x30Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Square70x70Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Square70x70Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Square150x150Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Square150x150Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Wide310x150Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Wide310x150Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Square310x310Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Square310x310Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_ForegroundText(&self, value: ForegroundText) -> HRESULT,
    fn get_ForegroundText(&self, out: *mut ForegroundText) -> HRESULT,
    fn put_BackgroundColor(&self, value: super::Color) -> HRESULT,
    fn get_BackgroundColor(&self, out: *mut super::Color) -> HRESULT,
    fn put_ShowNameOnSquare150x150Logo(&self, value: bool) -> HRESULT,
    fn get_ShowNameOnSquare150x150Logo(&self, out: *mut bool) -> HRESULT,
    fn put_ShowNameOnWide310x150Logo(&self, value: bool) -> HRESULT,
    fn get_ShowNameOnWide310x150Logo(&self, out: *mut bool) -> HRESULT,
    fn put_ShowNameOnSquare310x310Logo(&self, value: bool) -> HRESULT,
    fn get_ShowNameOnSquare310x310Logo(&self, out: *mut bool) -> HRESULT
}}
impl ISecondaryTileVisualElements {
    #[inline] pub unsafe fn set_square30x30_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Square30x30Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_square30x30_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Square30x30Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_square70x70_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Square70x70Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_square70x70_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Square70x70Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_square150x150_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Square150x150Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_square150x150_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Square150x150Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_wide310x150_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Wide310x150Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wide310x150_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Wide310x150Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_square310x310_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Square310x310Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_square310x310_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Square310x310Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground_text(&self, value: ForegroundText) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ForegroundText)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_text(&self) -> Result<ForegroundText> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ForegroundText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background_color(&self, value: super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BackgroundColor)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_color(&self) -> Result<super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BackgroundColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_name_on_square150x150_logo(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowNameOnSquare150x150Logo)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_name_on_square150x150_logo(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowNameOnSquare150x150Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_name_on_wide310x150_logo(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowNameOnWide310x150Logo)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_name_on_wide310x150_logo(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowNameOnWide310x150Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_name_on_square310x310_logo(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowNameOnSquare310x310Logo)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_name_on_square310x310_logo(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowNameOnSquare310x310Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SecondaryTileVisualElements: ISecondaryTileVisualElements}
DEFINE_IID!(IID_ISecondaryTileVisualElements2, 4247663056, 22492, 18324, 142, 207, 86, 130, 245, 243, 230, 239);
RT_INTERFACE!{interface ISecondaryTileVisualElements2(ISecondaryTileVisualElements2Vtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileVisualElements2] {
    fn put_Square71x71Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Square71x71Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT
}}
impl ISecondaryTileVisualElements2 {
    #[inline] pub unsafe fn set_square71x71_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Square71x71Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_square71x71_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Square71x71Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISecondaryTileVisualElements3, 1454725846, 53596, 16628, 129, 231, 87, 255, 216, 248, 164, 233);
RT_INTERFACE!{interface ISecondaryTileVisualElements3(ISecondaryTileVisualElements3Vtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileVisualElements3] {
    fn put_Square44x44Logo(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Square44x44Logo(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT
}}
impl ISecondaryTileVisualElements3 {
    #[inline] pub unsafe fn set_square44x44_logo(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Square44x44Logo)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_square44x44_logo(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Square44x44Logo)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISecondaryTileVisualElements4, 1716936983, 46404, 16594, 141, 18, 116, 212, 236, 36, 208, 76);
RT_INTERFACE!{interface ISecondaryTileVisualElements4(ISecondaryTileVisualElements4Vtbl): IInspectable(IInspectableVtbl) [IID_ISecondaryTileVisualElements4] {
    fn get_MixedRealityModel(&self, out: *mut *mut TileMixedRealityModel) -> HRESULT
}}
impl ISecondaryTileVisualElements4 {
    #[inline] pub unsafe fn get_mixed_reality_model(&self) -> Result<ComPtr<TileMixedRealityModel>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MixedRealityModel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IStartScreenManager, 1243466699, 9961, 20148, 137, 51, 133, 158, 182, 236, 219, 41);
RT_INTERFACE!{interface IStartScreenManager(IStartScreenManagerVtbl): IInspectable(IInspectableVtbl) [IID_IStartScreenManager] {
    #[cfg(not(feature="windows-system"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn SupportsAppListEntry(&self, appListEntry: *mut super::super::applicationmodel::core::AppListEntry, out: *mut bool) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn ContainsAppListEntryAsync(&self, appListEntry: *mut super::super::applicationmodel::core::AppListEntry, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn RequestAddAppListEntryAsync(&self, appListEntry: *mut super::super::applicationmodel::core::AppListEntry, out: *mut *mut super::super::foundation::IAsyncOperation<bool>) -> HRESULT
}}
impl IStartScreenManager {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn supports_app_list_entry(&self, appListEntry: &super::super::applicationmodel::core::AppListEntry) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).SupportsAppListEntry)(self as *const _ as *mut _, appListEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn contains_app_list_entry_async(&self, appListEntry: &super::super::applicationmodel::core::AppListEntry) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ContainsAppListEntryAsync)(self as *const _ as *mut _, appListEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn request_add_app_list_entry_async(&self, appListEntry: &super::super::applicationmodel::core::AppListEntry) -> Result<ComPtr<super::super::foundation::IAsyncOperation<bool>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RequestAddAppListEntryAsync)(self as *const _ as *mut _, appListEntry as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class StartScreenManager: IStartScreenManager}
impl RtActivatable<IStartScreenManagerStatics> for StartScreenManager {}
impl StartScreenManager {
    #[inline] pub fn get_default() -> Result<ComPtr<StartScreenManager>> { unsafe {
        <Self as RtActivatable<IStartScreenManagerStatics>>::get_activation_factory().get_default()
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<StartScreenManager>> { unsafe {
        <Self as RtActivatable<IStartScreenManagerStatics>>::get_activation_factory().get_for_user(user)
    }}
}
DEFINE_CLSID!(StartScreenManager(&[87,105,110,100,111,119,115,46,85,73,46,83,116,97,114,116,83,99,114,101,101,110,46,83,116,97,114,116,83,99,114,101,101,110,77,97,110,97,103,101,114,0]) [CLSID_StartScreenManager]);
DEFINE_IID!(IID_IStartScreenManagerStatics, 2019946255, 46469, 17998, 137, 147, 52, 232, 248, 115, 141, 72);
RT_INTERFACE!{static interface IStartScreenManagerStatics(IStartScreenManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IStartScreenManagerStatics] {
    fn GetDefault(&self, out: *mut *mut StartScreenManager) -> HRESULT,
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut StartScreenManager) -> HRESULT
}}
impl IStartScreenManagerStatics {
    #[inline] pub unsafe fn get_default(&self) -> Result<ComPtr<StartScreenManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDefault)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<StartScreenManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITileMixedRealityModel, 2960543323, 34941, 16962, 154, 25, 61, 10, 78, 167, 128, 49);
RT_INTERFACE!{interface ITileMixedRealityModel(ITileMixedRealityModelVtbl): IInspectable(IInspectableVtbl) [IID_ITileMixedRealityModel] {
    fn put_Uri(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_Uri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    #[cfg(feature="windows-perception")] fn put_BoundingBox(&self, value: *mut super::super::foundation::IReference<super::super::perception::spatial::SpatialBoundingBox>) -> HRESULT,
    #[cfg(feature="windows-perception")] fn get_BoundingBox(&self, out: *mut *mut super::super::foundation::IReference<super::super::perception::spatial::SpatialBoundingBox>) -> HRESULT
}}
impl ITileMixedRealityModel {
    #[inline] pub unsafe fn set_uri(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Uri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Uri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn set_bounding_box(&self, value: &super::super::foundation::IReference<super::super::perception::spatial::SpatialBoundingBox>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BoundingBox)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-perception")] #[inline] pub unsafe fn get_bounding_box(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::perception::spatial::SpatialBoundingBox>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BoundingBox)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class TileMixedRealityModel: ITileMixedRealityModel}
RT_ENUM! { enum TileOptions: u32 {
    None (TileOptions_None) = 0, ShowNameOnLogo (TileOptions_ShowNameOnLogo) = 1, ShowNameOnWideLogo (TileOptions_ShowNameOnWideLogo) = 2, CopyOnDeployment (TileOptions_CopyOnDeployment) = 4,
}}
RT_ENUM! { enum TileSize: i32 {
    Default (TileSize_Default) = 0, Square30x30 (TileSize_Square30x30) = 1, Square70x70 (TileSize_Square70x70) = 2, Square150x150 (TileSize_Square150x150) = 3, Wide310x150 (TileSize_Wide310x150) = 4, Square310x310 (TileSize_Square310x310) = 5, Square71x71 (TileSize_Square71x71) = 6, Square44x44 (TileSize_Square44x44) = 7,
}}
DEFINE_IID!(IID_IVisualElementsRequest, 3241685818, 37640, 16498, 136, 204, 208, 104, 219, 52, 124, 104);
RT_INTERFACE!{interface IVisualElementsRequest(IVisualElementsRequestVtbl): IInspectable(IInspectableVtbl) [IID_IVisualElementsRequest] {
    fn get_VisualElements(&self, out: *mut *mut SecondaryTileVisualElements) -> HRESULT,
    fn get_AlternateVisualElements(&self, out: *mut *mut super::super::foundation::collections::IVectorView<SecondaryTileVisualElements>) -> HRESULT,
    fn get_Deadline(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut VisualElementsRequestDeferral) -> HRESULT
}}
impl IVisualElementsRequest {
    #[inline] pub unsafe fn get_visual_elements(&self) -> Result<ComPtr<SecondaryTileVisualElements>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VisualElements)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_alternate_visual_elements(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<SecondaryTileVisualElements>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AlternateVisualElements)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deadline(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Deadline)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<VisualElementsRequestDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VisualElementsRequest: IVisualElementsRequest}
DEFINE_IID!(IID_IVisualElementsRequestDeferral, 2707779248, 294, 17239, 130, 4, 189, 130, 187, 42, 4, 109);
RT_INTERFACE!{interface IVisualElementsRequestDeferral(IVisualElementsRequestDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IVisualElementsRequestDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IVisualElementsRequestDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VisualElementsRequestDeferral: IVisualElementsRequestDeferral}
DEFINE_IID!(IID_IVisualElementsRequestedEventArgs, 2070923650, 14861, 20174, 175, 150, 205, 23, 225, 176, 11, 45);
RT_INTERFACE!{interface IVisualElementsRequestedEventArgs(IVisualElementsRequestedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVisualElementsRequestedEventArgs] {
    fn get_Request(&self, out: *mut *mut VisualElementsRequest) -> HRESULT
}}
impl IVisualElementsRequestedEventArgs {
    #[inline] pub unsafe fn get_request(&self) -> Result<ComPtr<VisualElementsRequest>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Request)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class VisualElementsRequestedEventArgs: IVisualElementsRequestedEventArgs}
} // Windows.UI.StartScreen
pub mod popups { // Windows.UI.Popups
use ::prelude::*;
DEFINE_IID!(IID_IMessageDialog, 871734017, 21285, 17323, 154, 179, 189, 174, 68, 14, 65, 33);
RT_INTERFACE!{interface IMessageDialog(IMessageDialogVtbl): IInspectable(IInspectableVtbl) [IID_IMessageDialog] {
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Title(&self, value: HSTRING) -> HRESULT,
    fn get_Commands(&self, out: *mut *mut super::super::foundation::collections::IVector<IUICommand>) -> HRESULT,
    fn get_DefaultCommandIndex(&self, out: *mut u32) -> HRESULT,
    fn put_DefaultCommandIndex(&self, value: u32) -> HRESULT,
    fn get_CancelCommandIndex(&self, out: *mut u32) -> HRESULT,
    fn put_CancelCommandIndex(&self, value: u32) -> HRESULT,
    fn get_Content(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Content(&self, value: HSTRING) -> HRESULT,
    fn ShowAsync(&self, out: *mut *mut super::super::foundation::IAsyncOperation<IUICommand>) -> HRESULT,
    fn get_Options(&self, out: *mut MessageDialogOptions) -> HRESULT,
    fn put_Options(&self, value: MessageDialogOptions) -> HRESULT
}}
impl IMessageDialog {
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Commands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_command_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultCommandIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_command_index(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultCommandIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cancel_command_index(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CancelCommandIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel_command_index(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CancelCommandIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Content)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async(&self) -> Result<ComPtr<super::super::foundation::IAsyncOperation<IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_options(&self) -> Result<MessageDialogOptions> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Options)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_options(&self, value: MessageDialogOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Options)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class MessageDialog: IMessageDialog}
impl RtActivatable<IMessageDialogFactory> for MessageDialog {}
impl MessageDialog {
    #[inline] pub fn create(content: &HStringArg) -> Result<ComPtr<MessageDialog>> { unsafe {
        <Self as RtActivatable<IMessageDialogFactory>>::get_activation_factory().create(content)
    }}
    #[inline] pub fn create_with_title(content: &HStringArg, title: &HStringArg) -> Result<ComPtr<MessageDialog>> { unsafe {
        <Self as RtActivatable<IMessageDialogFactory>>::get_activation_factory().create_with_title(content, title)
    }}
}
DEFINE_CLSID!(MessageDialog(&[87,105,110,100,111,119,115,46,85,73,46,80,111,112,117,112,115,46,77,101,115,115,97,103,101,68,105,97,108,111,103,0]) [CLSID_MessageDialog]);
DEFINE_IID!(IID_IMessageDialogFactory, 756422519, 42607, 20133, 187, 135, 121, 63, 250, 73, 65, 242);
RT_INTERFACE!{static interface IMessageDialogFactory(IMessageDialogFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IMessageDialogFactory] {
    fn Create(&self, content: HSTRING, out: *mut *mut MessageDialog) -> HRESULT,
    fn CreateWithTitle(&self, content: HSTRING, title: HSTRING, out: *mut *mut MessageDialog) -> HRESULT
}}
impl IMessageDialogFactory {
    #[inline] pub unsafe fn create(&self, content: &HStringArg) -> Result<ComPtr<MessageDialog>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, content.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_title(&self, content: &HStringArg, title: &HStringArg) -> Result<ComPtr<MessageDialog>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithTitle)(self as *const _ as *mut _, content.get(), title.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum MessageDialogOptions: u32 {
    None (MessageDialogOptions_None) = 0, AcceptUserInputAfterDelay (MessageDialogOptions_AcceptUserInputAfterDelay) = 1,
}}
RT_ENUM! { enum Placement: i32 {
    Default (Placement_Default) = 0, Above (Placement_Above) = 1, Below (Placement_Below) = 2, Left (Placement_Left) = 3, Right (Placement_Right) = 4,
}}
DEFINE_IID!(IID_IPopupMenu, 1318831836, 34829, 18428, 160, 161, 114, 182, 57, 230, 37, 89);
RT_INTERFACE!{interface IPopupMenu(IPopupMenuVtbl): IInspectable(IInspectableVtbl) [IID_IPopupMenu] {
    fn get_Commands(&self, out: *mut *mut super::super::foundation::collections::IVector<IUICommand>) -> HRESULT,
    fn ShowAsync(&self, invocationPoint: super::super::foundation::Point, out: *mut *mut super::super::foundation::IAsyncOperation<IUICommand>) -> HRESULT,
    fn ShowAsyncWithRect(&self, selection: super::super::foundation::Rect, out: *mut *mut super::super::foundation::IAsyncOperation<IUICommand>) -> HRESULT,
    fn ShowAsyncWithRectAndPlacement(&self, selection: super::super::foundation::Rect, preferredPlacement: Placement, out: *mut *mut super::super::foundation::IAsyncOperation<IUICommand>) -> HRESULT
}}
impl IPopupMenu {
    #[inline] pub unsafe fn get_commands(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Commands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async(&self, invocationPoint: super::super::foundation::Point) -> Result<ComPtr<super::super::foundation::IAsyncOperation<IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsync)(self as *const _ as *mut _, invocationPoint, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async_with_rect(&self, selection: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::IAsyncOperation<IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsyncWithRect)(self as *const _ as *mut _, selection, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async_with_rect_and_placement(&self, selection: super::super::foundation::Rect, preferredPlacement: Placement) -> Result<ComPtr<super::super::foundation::IAsyncOperation<IUICommand>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsyncWithRectAndPlacement)(self as *const _ as *mut _, selection, preferredPlacement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PopupMenu: IPopupMenu}
impl RtActivatable<IActivationFactory> for PopupMenu {}
DEFINE_CLSID!(PopupMenu(&[87,105,110,100,111,119,115,46,85,73,46,80,111,112,117,112,115,46,80,111,112,117,112,77,101,110,117,0]) [CLSID_PopupMenu]);
DEFINE_IID!(IID_IUICommand, 1341733493, 16709, 18431, 172, 127, 223, 241, 193, 250, 91, 15);
RT_INTERFACE!{interface IUICommand(IUICommandVtbl): IInspectable(IInspectableVtbl) [IID_IUICommand] {
    fn get_Label(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Label(&self, value: HSTRING) -> HRESULT,
    fn get_Invoked(&self, out: *mut *mut UICommandInvokedHandler) -> HRESULT,
    fn put_Invoked(&self, value: *mut UICommandInvokedHandler) -> HRESULT,
    fn get_Id(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Id(&self, value: *mut IInspectable) -> HRESULT
}}
impl IUICommand {
    #[inline] pub unsafe fn get_label(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Label)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_label(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Label)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_invoked(&self) -> Result<ComPtr<UICommandInvokedHandler>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Invoked)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_invoked(&self, value: &UICommandInvokedHandler) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Invoked)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_id(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Id)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class UICommand: IUICommand}
impl RtActivatable<IUICommandFactory> for UICommand {}
impl RtActivatable<IActivationFactory> for UICommand {}
impl UICommand {
    #[inline] pub fn create(label: &HStringArg) -> Result<ComPtr<UICommand>> { unsafe {
        <Self as RtActivatable<IUICommandFactory>>::get_activation_factory().create(label)
    }}
    #[inline] pub fn create_with_handler(label: &HStringArg, action: &UICommandInvokedHandler) -> Result<ComPtr<UICommand>> { unsafe {
        <Self as RtActivatable<IUICommandFactory>>::get_activation_factory().create_with_handler(label, action)
    }}
    #[inline] pub fn create_with_handler_and_id(label: &HStringArg, action: &UICommandInvokedHandler, commandId: &IInspectable) -> Result<ComPtr<UICommand>> { unsafe {
        <Self as RtActivatable<IUICommandFactory>>::get_activation_factory().create_with_handler_and_id(label, action, commandId)
    }}
}
DEFINE_CLSID!(UICommand(&[87,105,110,100,111,119,115,46,85,73,46,80,111,112,117,112,115,46,85,73,67,111,109,109,97,110,100,0]) [CLSID_UICommand]);
DEFINE_IID!(IID_IUICommandFactory, 2719646089, 9904, 18038, 174, 148, 84, 4, 27, 193, 37, 232);
RT_INTERFACE!{static interface IUICommandFactory(IUICommandFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IUICommandFactory] {
    fn Create(&self, label: HSTRING, out: *mut *mut UICommand) -> HRESULT,
    fn CreateWithHandler(&self, label: HSTRING, action: *mut UICommandInvokedHandler, out: *mut *mut UICommand) -> HRESULT,
    fn CreateWithHandlerAndId(&self, label: HSTRING, action: *mut UICommandInvokedHandler, commandId: *mut IInspectable, out: *mut *mut UICommand) -> HRESULT
}}
impl IUICommandFactory {
    #[inline] pub unsafe fn create(&self, label: &HStringArg) -> Result<ComPtr<UICommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Create)(self as *const _ as *mut _, label.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_handler(&self, label: &HStringArg, action: &UICommandInvokedHandler) -> Result<ComPtr<UICommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithHandler)(self as *const _ as *mut _, label.get(), action as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_handler_and_id(&self, label: &HStringArg, action: &UICommandInvokedHandler, commandId: &IInspectable) -> Result<ComPtr<UICommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithHandlerAndId)(self as *const _ as *mut _, label.get(), action as *const _ as *mut _, commandId as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_UICommandInvokedHandler, 3673651791, 49786, 17048, 154, 198, 41, 34, 196, 94, 125, 166);
RT_DELEGATE!{delegate UICommandInvokedHandler(UICommandInvokedHandlerVtbl, UICommandInvokedHandlerImpl) [IID_UICommandInvokedHandler] {
    fn Invoke(&self, command: *mut IUICommand) -> HRESULT
}}
impl UICommandInvokedHandler {
    #[inline] pub unsafe fn invoke(&self, command: &IUICommand) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, command as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class UICommandSeparator: IUICommand}
impl RtActivatable<IActivationFactory> for UICommandSeparator {}
DEFINE_CLSID!(UICommandSeparator(&[87,105,110,100,111,119,115,46,85,73,46,80,111,112,117,112,115,46,85,73,67,111,109,109,97,110,100,83,101,112,97,114,97,116,111,114,0]) [CLSID_UICommandSeparator]);
} // Windows.UI.Popups
pub mod notifications { // Windows.UI.Notifications
use ::prelude::*;
DEFINE_IID!(IID_IAdaptiveNotificationContent, 3943546470, 29768, 17549, 157, 184, 215, 138, 205, 42, 187, 169);
RT_INTERFACE!{interface IAdaptiveNotificationContent(IAdaptiveNotificationContentVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveNotificationContent] {
    fn get_Kind(&self, out: *mut AdaptiveNotificationContentKind) -> HRESULT,
    fn get_Hints(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT
}}
impl IAdaptiveNotificationContent {
    #[inline] pub unsafe fn get_kind(&self) -> Result<AdaptiveNotificationContentKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Kind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hints(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Hints)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AdaptiveNotificationContentKind: i32 {
    Text (AdaptiveNotificationContentKind_Text) = 0,
}}
DEFINE_IID!(IID_IAdaptiveNotificationText, 1188340670, 24730, 17190, 164, 11, 191, 222, 135, 32, 52, 163);
RT_INTERFACE!{interface IAdaptiveNotificationText(IAdaptiveNotificationTextVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveNotificationText] {
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Language(&self, value: HSTRING) -> HRESULT
}}
impl IAdaptiveNotificationText {
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Language)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AdaptiveNotificationText: IAdaptiveNotificationText}
impl RtActivatable<IActivationFactory> for AdaptiveNotificationText {}
DEFINE_CLSID!(AdaptiveNotificationText(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,65,100,97,112,116,105,118,101,78,111,116,105,102,105,99,97,116,105,111,110,84,101,120,116,0]) [CLSID_AdaptiveNotificationText]);
DEFINE_IID!(IID_IBadgeNotification, 123516106, 53386, 20015, 146, 51, 126, 40, 156, 31, 119, 34);
RT_INTERFACE!{interface IBadgeNotification(IBadgeNotificationVtbl): IInspectable(IInspectableVtbl) [IID_IBadgeNotification] {
    #[cfg(not(feature="windows-data"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-data")] fn get_Content(&self, out: *mut *mut super::super::data::xml::dom::XmlDocument) -> HRESULT,
    fn put_ExpirationTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_ExpirationTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT
}}
impl IBadgeNotification {
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<super::super::data::xml::dom::XmlDocument>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_expiration_time(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ExpirationTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_expiration_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExpirationTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BadgeNotification: IBadgeNotification}
impl RtActivatable<IBadgeNotificationFactory> for BadgeNotification {}
impl BadgeNotification {
    #[cfg(feature="windows-data")] #[inline] pub fn create_badge_notification(content: &super::super::data::xml::dom::XmlDocument) -> Result<ComPtr<BadgeNotification>> { unsafe {
        <Self as RtActivatable<IBadgeNotificationFactory>>::get_activation_factory().create_badge_notification(content)
    }}
}
DEFINE_CLSID!(BadgeNotification(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,66,97,100,103,101,78,111,116,105,102,105,99,97,116,105,111,110,0]) [CLSID_BadgeNotification]);
DEFINE_IID!(IID_IBadgeNotificationFactory, 3992081870, 1560, 19801, 148, 138, 90, 97, 4, 12, 82, 249);
RT_INTERFACE!{static interface IBadgeNotificationFactory(IBadgeNotificationFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBadgeNotificationFactory] {
    #[cfg(feature="windows-data")] fn CreateBadgeNotification(&self, content: *mut super::super::data::xml::dom::XmlDocument, out: *mut *mut BadgeNotification) -> HRESULT
}}
impl IBadgeNotificationFactory {
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn create_badge_notification(&self, content: &super::super::data::xml::dom::XmlDocument) -> Result<ComPtr<BadgeNotification>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeNotification)(self as *const _ as *mut _, content as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum BadgeTemplateType: i32 {
    BadgeGlyph (BadgeTemplateType_BadgeGlyph) = 0, BadgeNumber (BadgeTemplateType_BadgeNumber) = 1,
}}
RT_CLASS!{static class BadgeUpdateManager}
impl RtActivatable<IBadgeUpdateManagerStatics> for BadgeUpdateManager {}
impl RtActivatable<IBadgeUpdateManagerStatics2> for BadgeUpdateManager {}
impl BadgeUpdateManager {
    #[inline] pub fn create_badge_updater_for_application() -> Result<ComPtr<BadgeUpdater>> { unsafe {
        <Self as RtActivatable<IBadgeUpdateManagerStatics>>::get_activation_factory().create_badge_updater_for_application()
    }}
    #[inline] pub fn create_badge_updater_for_application_with_id(applicationId: &HStringArg) -> Result<ComPtr<BadgeUpdater>> { unsafe {
        <Self as RtActivatable<IBadgeUpdateManagerStatics>>::get_activation_factory().create_badge_updater_for_application_with_id(applicationId)
    }}
    #[inline] pub fn create_badge_updater_for_secondary_tile(tileId: &HStringArg) -> Result<ComPtr<BadgeUpdater>> { unsafe {
        <Self as RtActivatable<IBadgeUpdateManagerStatics>>::get_activation_factory().create_badge_updater_for_secondary_tile(tileId)
    }}
    #[cfg(feature="windows-data")] #[inline] pub fn get_template_content(type_: BadgeTemplateType) -> Result<ComPtr<super::super::data::xml::dom::XmlDocument>> { unsafe {
        <Self as RtActivatable<IBadgeUpdateManagerStatics>>::get_activation_factory().get_template_content(type_)
    }}
    #[cfg(feature="windows-system")] #[inline] pub fn get_for_user(user: &super::super::system::User) -> Result<ComPtr<BadgeUpdateManagerForUser>> { unsafe {
        <Self as RtActivatable<IBadgeUpdateManagerStatics2>>::get_activation_factory().get_for_user(user)
    }}
}
DEFINE_CLSID!(BadgeUpdateManager(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,66,97,100,103,101,85,112,100,97,116,101,77,97,110,97,103,101,114,0]) [CLSID_BadgeUpdateManager]);
DEFINE_IID!(IID_IBadgeUpdateManagerForUser, 2573935036, 902, 17637, 186, 141, 12, 16, 119, 166, 46, 146);
RT_INTERFACE!{interface IBadgeUpdateManagerForUser(IBadgeUpdateManagerForUserVtbl): IInspectable(IInspectableVtbl) [IID_IBadgeUpdateManagerForUser] {
    fn CreateBadgeUpdaterForApplication(&self, out: *mut *mut BadgeUpdater) -> HRESULT,
    fn CreateBadgeUpdaterForApplicationWithId(&self, applicationId: HSTRING, out: *mut *mut BadgeUpdater) -> HRESULT,
    fn CreateBadgeUpdaterForSecondaryTile(&self, tileId: HSTRING, out: *mut *mut BadgeUpdater) -> HRESULT,
    #[cfg(feature="windows-system")] fn get_User(&self, out: *mut *mut super::super::system::User) -> HRESULT
}}
impl IBadgeUpdateManagerForUser {
    #[inline] pub unsafe fn create_badge_updater_for_application(&self) -> Result<ComPtr<BadgeUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeUpdaterForApplication)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_badge_updater_for_application_with_id(&self, applicationId: &HStringArg) -> Result<ComPtr<BadgeUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeUpdaterForApplicationWithId)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_badge_updater_for_secondary_tile(&self, tileId: &HStringArg) -> Result<ComPtr<BadgeUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeUpdaterForSecondaryTile)(self as *const _ as *mut _, tileId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_user(&self) -> Result<ComPtr<super::super::system::User>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_User)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BadgeUpdateManagerForUser: IBadgeUpdateManagerForUser}
DEFINE_IID!(IID_IBadgeUpdateManagerStatics, 859836330, 28117, 16645, 174, 188, 155, 80, 252, 164, 146, 218);
RT_INTERFACE!{static interface IBadgeUpdateManagerStatics(IBadgeUpdateManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBadgeUpdateManagerStatics] {
    fn CreateBadgeUpdaterForApplication(&self, out: *mut *mut BadgeUpdater) -> HRESULT,
    fn CreateBadgeUpdaterForApplicationWithId(&self, applicationId: HSTRING, out: *mut *mut BadgeUpdater) -> HRESULT,
    fn CreateBadgeUpdaterForSecondaryTile(&self, tileId: HSTRING, out: *mut *mut BadgeUpdater) -> HRESULT,
    #[cfg(feature="windows-data")] fn GetTemplateContent(&self, type_: BadgeTemplateType, out: *mut *mut super::super::data::xml::dom::XmlDocument) -> HRESULT
}}
impl IBadgeUpdateManagerStatics {
    #[inline] pub unsafe fn create_badge_updater_for_application(&self) -> Result<ComPtr<BadgeUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeUpdaterForApplication)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_badge_updater_for_application_with_id(&self, applicationId: &HStringArg) -> Result<ComPtr<BadgeUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeUpdaterForApplicationWithId)(self as *const _ as *mut _, applicationId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_badge_updater_for_secondary_tile(&self, tileId: &HStringArg) -> Result<ComPtr<BadgeUpdater>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateBadgeUpdaterForSecondaryTile)(self as *const _ as *mut _, tileId.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn get_template_content(&self, type_: BadgeTemplateType) -> Result<ComPtr<super::super::data::xml::dom::XmlDocument>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTemplateContent)(self as *const _ as *mut _, type_, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBadgeUpdateManagerStatics2, 2543465934, 63808, 18623, 148, 232, 202, 36, 77, 64, 11, 65);
RT_INTERFACE!{static interface IBadgeUpdateManagerStatics2(IBadgeUpdateManagerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IBadgeUpdateManagerStatics2] {
    #[cfg(feature="windows-system")] fn GetForUser(&self, user: *mut super::super::system::User, out: *mut *mut BadgeUpdateManagerForUser) -> HRESULT
}}
impl IBadgeUpdateManagerStatics2 {
    #[cfg(feature="windows-system")] #[inline] pub unsafe fn get_for_user(&self, user: &super::super::system::User) -> Result<ComPtr<BadgeUpdateManagerForUser>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetForUser)(self as *const _ as *mut _, user as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBadgeUpdater, 3053068244, 30050, 20332, 191, 163, 27, 110, 210, 229, 127, 47);
RT_INTERFACE!{interface IBadgeUpdater(IBadgeUpdaterVtbl): IInspectable(IInspectableVtbl) [IID_IBadgeUpdater] {
    fn Update(&self, notification: *mut BadgeNotification) -> HRESULT,
    fn Clear(&self) -> HRESULT,
    fn StartPeriodicUpdate(&self, badgeContent: *mut super::super::foundation::Uri, requestedInterval: PeriodicUpdateRecurrence) -> HRESULT,
    fn StartPeriodicUpdateAtTime(&self, badgeContent: *mut super::super::foundation::Uri, startTime: super::super::foundation::DateTime, requestedInterval: PeriodicUpdateRecurrence) -> HRESULT,
    fn StopPeriodicUpdate(&self) -> HRESULT
}}
impl IBadgeUpdater {
    #[inline] pub unsafe fn update(&self, notification: &BadgeNotification) -> Result<()> {
        let hr = ((*self.lpVtbl).Update)(self as *const _ as *mut _, notification as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Clear)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_periodic_update(&self, badgeContent: &super::super::foundation::Uri, requestedInterval: PeriodicUpdateRecurrence) -> Result<()> {
        let hr = ((*self.lpVtbl).StartPeriodicUpdate)(self as *const _ as *mut _, badgeContent as *const _ as *mut _, requestedInterval);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_periodic_update_at_time(&self, badgeContent: &super::super::foundation::Uri, startTime: super::super::foundation::DateTime, requestedInterval: PeriodicUpdateRecurrence) -> Result<()> {
        let hr = ((*self.lpVtbl).StartPeriodicUpdateAtTime)(self as *const _ as *mut _, badgeContent as *const _ as *mut _, startTime, requestedInterval);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop_periodic_update(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StopPeriodicUpdate)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BadgeUpdater: IBadgeUpdater}
RT_CLASS!{static class KnownAdaptiveNotificationHints}
impl RtActivatable<IKnownAdaptiveNotificationHintsStatics> for KnownAdaptiveNotificationHints {}
impl KnownAdaptiveNotificationHints {
    #[inline] pub fn get_style() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationHintsStatics>>::get_activation_factory().get_style()
    }}
    #[inline] pub fn get_wrap() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationHintsStatics>>::get_activation_factory().get_wrap()
    }}
    #[inline] pub fn get_max_lines() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationHintsStatics>>::get_activation_factory().get_max_lines()
    }}
    #[inline] pub fn get_min_lines() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationHintsStatics>>::get_activation_factory().get_min_lines()
    }}
    #[inline] pub fn get_text_stacking() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationHintsStatics>>::get_activation_factory().get_text_stacking()
    }}
    #[inline] pub fn get_align() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationHintsStatics>>::get_activation_factory().get_align()
    }}
}
DEFINE_CLSID!(KnownAdaptiveNotificationHints(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,75,110,111,119,110,65,100,97,112,116,105,118,101,78,111,116,105,102,105,99,97,116,105,111,110,72,105,110,116,115,0]) [CLSID_KnownAdaptiveNotificationHints]);
DEFINE_IID!(IID_IKnownAdaptiveNotificationHintsStatics, 102786456, 54422, 18813, 134, 146, 79, 125, 124, 39, 112, 223);
RT_INTERFACE!{static interface IKnownAdaptiveNotificationHintsStatics(IKnownAdaptiveNotificationHintsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IKnownAdaptiveNotificationHintsStatics] {
    fn get_Style(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Wrap(&self, out: *mut HSTRING) -> HRESULT,
    fn get_MaxLines(&self, out: *mut HSTRING) -> HRESULT,
    fn get_MinLines(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TextStacking(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Align(&self, out: *mut HSTRING) -> HRESULT
}}
impl IKnownAdaptiveNotificationHintsStatics {
    #[inline] pub unsafe fn get_style(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Style)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_wrap(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Wrap)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_lines(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxLines)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_lines(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinLines)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_stacking(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextStacking)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_align(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Align)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class KnownAdaptiveNotificationTextStyles}
impl RtActivatable<IKnownAdaptiveNotificationTextStylesStatics> for KnownAdaptiveNotificationTextStyles {}
impl KnownAdaptiveNotificationTextStyles {
    #[inline] pub fn get_caption() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_caption()
    }}
    #[inline] pub fn get_body() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_body()
    }}
    #[inline] pub fn get_base() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_base()
    }}
    #[inline] pub fn get_subtitle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_subtitle()
    }}
    #[inline] pub fn get_title() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_title()
    }}
    #[inline] pub fn get_subheader() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_subheader()
    }}
    #[inline] pub fn get_header() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_header()
    }}
    #[inline] pub fn get_title_numeral() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_title_numeral()
    }}
    #[inline] pub fn get_subheader_numeral() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_subheader_numeral()
    }}
    #[inline] pub fn get_header_numeral() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_header_numeral()
    }}
    #[inline] pub fn get_caption_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_caption_subtle()
    }}
    #[inline] pub fn get_body_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_body_subtle()
    }}
    #[inline] pub fn get_base_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_base_subtle()
    }}
    #[inline] pub fn get_subtitle_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_subtitle_subtle()
    }}
    #[inline] pub fn get_title_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_title_subtle()
    }}
    #[inline] pub fn get_subheader_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_subheader_subtle()
    }}
    #[inline] pub fn get_subheader_numeral_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_subheader_numeral_subtle()
    }}
    #[inline] pub fn get_header_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_header_subtle()
    }}
    #[inline] pub fn get_header_numeral_subtle() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownAdaptiveNotificationTextStylesStatics>>::get_activation_factory().get_header_numeral_subtle()
    }}
}
DEFINE_CLSID!(KnownAdaptiveNotificationTextStyles(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,75,110,111,119,110,65,100,97,112,116,105,118,101,78,111,116,105,102,105,99,97,116,105,111,110,84,101,120,116,83,116,121,108,101,115,0]) [CLSID_KnownAdaptiveNotificationTextStyles]);
DEFINE_IID!(IID_IKnownAdaptiveNotificationTextStylesStatics, 539071191, 35222, 17834, 139, 161, 212, 97, 215, 44, 42, 27);
RT_INTERFACE!{static interface IKnownAdaptiveNotificationTextStylesStatics(IKnownAdaptiveNotificationTextStylesStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IKnownAdaptiveNotificationTextStylesStatics] {
    fn get_Caption(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Body(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Base(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Subtitle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Title(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Subheader(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Header(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TitleNumeral(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SubheaderNumeral(&self, out: *mut HSTRING) -> HRESULT,
    fn get_HeaderNumeral(&self, out: *mut HSTRING) -> HRESULT,
    fn get_CaptionSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_BodySubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_BaseSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SubtitleSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_TitleSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SubheaderSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_SubheaderNumeralSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_HeaderSubtle(&self, out: *mut HSTRING) -> HRESULT,
    fn get_HeaderNumeralSubtle(&self, out: *mut HSTRING) -> HRESULT
}}
impl IKnownAdaptiveNotificationTextStylesStatics {
    #[inline] pub unsafe fn get_caption(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Caption)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Body)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_base(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Base)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subtitle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subtitle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subheader(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Subheader)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_numeral(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleNumeral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subheader_numeral(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubheaderNumeral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_numeral(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderNumeral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_caption_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CaptionSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_body_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BodySubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_base_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BaseSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subtitle_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubtitleSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subheader_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubheaderSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_subheader_numeral_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SubheaderNumeralSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_numeral_subtle(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderNumeralSubtle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{static class KnownNotificationBindings}
impl RtActivatable<IKnownNotificationBindingsStatics> for KnownNotificationBindings {}
impl KnownNotificationBindings {
    #[inline] pub fn get_toast_generic() -> Result<HString> { unsafe {
        <Self as RtActivatable<IKnownNotificationBindingsStatics>>::get_activation_factory().get_toast_generic()
    }}
}
DEFINE_CLSID!(KnownNotificationBindings(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,75,110,111,119,110,78,111,116,105,102,105,99,97,116,105,111,110,66,105,110,100,105,110,103,115,0]) [CLSID_KnownNotificationBindings]);
DEFINE_IID!(IID_IKnownNotificationBindingsStatics, 2034400174, 43191, 19800, 137, 234, 118, 167, 183, 188, 205, 237);
RT_INTERFACE!{static interface IKnownNotificationBindingsStatics(IKnownNotificationBindingsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IKnownNotificationBindingsStatics] {
    fn get_ToastGeneric(&self, out: *mut HSTRING) -> HRESULT
}}
impl IKnownNotificationBindingsStatics {
    #[inline] pub unsafe fn get_toast_generic(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ToastGeneric)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_INotification, 276838398, 60278, 20354, 151, 188, 218, 7, 83, 10, 46, 32);
RT_INTERFACE!{interface INotification(INotificationVtbl): IInspectable(IInspectableVtbl) [IID_INotification] {
    fn get_ExpirationTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_ExpirationTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_Visual(&self, out: *mut *mut NotificationVisual) -> HRESULT,
    fn put_Visual(&self, value: *mut NotificationVisual) -> HRESULT
}}
impl INotification {
    #[inline] pub unsafe fn get_expiration_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExpirationTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_expiration_time(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ExpirationTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visual(&self) -> Result<ComPtr<NotificationVisual>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Visual)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_visual(&self, value: &NotificationVisual) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Visual)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Notification: INotification}
impl RtActivatable<IActivationFactory> for Notification {}
DEFINE_CLSID!(Notification(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,78,111,116,105,102,105,99,97,116,105,111,110,0]) [CLSID_Notification]);
DEFINE_IID!(IID_INotificationBinding, 4070460293, 880, 19155, 180, 234, 218, 158, 53, 231, 234, 191);
RT_INTERFACE!{interface INotificationBinding(INotificationBindingVtbl): IInspectable(IInspectableVtbl) [IID_INotificationBinding] {
    fn get_Template(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Template(&self, value: HSTRING) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Language(&self, value: HSTRING) -> HRESULT,
    fn get_Hints(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT,
    fn GetTextElements(&self, out: *mut *mut super::super::foundation::collections::IVectorView<AdaptiveNotificationText>) -> HRESULT
}}
impl INotificationBinding {
    #[inline] pub unsafe fn get_template(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Template)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_template(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Template)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Language)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hints(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Hints)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_elements(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<AdaptiveNotificationText>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTextElements)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class NotificationBinding: INotificationBinding}
DEFINE_IID!(IID_INotificationData, 2684166930, 40298, 19119, 182, 172, 255, 23, 240, 193, 242, 128);
RT_INTERFACE!{interface INotificationData(INotificationDataVtbl): IInspectable(IInspectableVtbl) [IID_INotificationData] {
    fn get_Values(&self, out: *mut *mut super::super::foundation::collections::IMap<HString, HString>) -> HRESULT,
    fn get_SequenceNumber(&self, out: *mut u32) -> HRESULT,
    fn put_SequenceNumber(&self, value: u32) -> HRESULT
}}
impl INotificationData {
    #[inline] pub unsafe fn get_values(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<HString, HString>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Values)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sequence_number(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SequenceNumber)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_sequence_number(&self, value: u32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SequenceNumber)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class NotificationData: INotificationData}
impl RtActivatable<INotificationDataFactory> for NotificationData {}
impl RtActivatable<IActivationFactory> for NotificationData {}
impl NotificationData {
    #[inline] pub fn create_notification_data_with_values_and_sequence_number(initialValues: &super::super::foundation::collections::IIterable<super::super::foundation::collections::IKeyValuePair<HString, HString>>, sequenceNumber: u32) -> Result<ComPtr<NotificationData>> { unsafe {
        <Self as RtActivatable<INotificationDataFactory>>::get_activation_factory().create_notification_data_with_values_and_sequence_number(initialValues, sequenceNumber)
    }}
    #[inline] pub fn create_notification_data_with_values(initialValues: &super::super::foundation::collections::IIterable<super::super::foundation::collections::IKeyValuePair<HString, HString>>) -> Result<ComPtr<NotificationData>> { unsafe {
        <Self as RtActivatable<INotificationDataFactory>>::get_activation_factory().create_notification_data_with_values(initialValues)
    }}
}
DEFINE_CLSID!(NotificationData(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,78,111,116,105,102,105,99,97,116,105,111,110,68,97,116,97,0]) [CLSID_NotificationData]);
DEFINE_IID!(IID_INotificationDataFactory, 599909178, 7184, 18171, 128, 64, 222, 195, 132, 98, 28, 248);
RT_INTERFACE!{static interface INotificationDataFactory(INotificationDataFactoryVtbl): IInspectable(IInspectableVtbl) [IID_INotificationDataFactory] {
    fn CreateNotificationDataWithValuesAndSequenceNumber(&self, initialValues: *mut super::super::foundation::collections::IIterable<super::super::foundation::collections::IKeyValuePair<HString, HString>>, sequenceNumber: u32, out: *mut *mut NotificationData) -> HRESULT,
    fn CreateNotificationDataWithValues(&self, initialValues: *mut super::super::foundation::collections::IIterable<super::super::foundation::collections::IKeyValuePair<HString, HString>>, out: *mut *mut NotificationData) -> HRESULT
}}
impl INotificationDataFactory {
    #[inline] pub unsafe fn create_notification_data_with_values_and_sequence_number(&self, initialValues: &super::super::foundation::collections::IIterable<super::super::foundation::collections::IKeyValuePair<HString, HString>>, sequenceNumber: u32) -> Result<ComPtr<NotificationData>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateNotificationDataWithValuesAndSequenceNumber)(self as *const _ as *mut _, initialValues as *const _ as *mut _, sequenceNumber, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_notification_data_with_values(&self, initialValues: &super::super::foundation::collections::IIterable<super::super::foundation::collections::IKeyValuePair<HString, HString>>) -> Result<ComPtr<NotificationData>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateNotificationDataWithValues)(self as *const _ as *mut _, initialValues as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum NotificationKinds: u32 {
    Unknown (NotificationKinds_Unknown) = 0, Toast (NotificationKinds_Toast) = 1,
}}
RT_ENUM! { enum NotificationMirroring: i32 {
    Allowed (NotificationMirroring_Allowed) = 0, Disabled (NotificationMirroring_Disabled) = 1,
}}
RT_ENUM! { enum NotificationSetting: i32 {
    Enabled (NotificationSetting_Enabled) = 0, DisabledForApplication (NotificationSetting_DisabledForApplication) = 1, DisabledForUser (NotificationSetting_DisabledForUser) = 2, DisabledByGroupPolicy (NotificationSetting_DisabledByGroupPolicy) = 3, DisabledByManifest (NotificationSetting_DisabledByManifest) = 4,
}}
RT_ENUM! { enum NotificationUpdateResult: i32 {
    Succeeded (NotificationUpdateResult_Succeeded) = 0, Failed (NotificationUpdateResult_Failed) = 1, NotificationNotFound (NotificationUpdateResult_NotificationNotFound) = 2,
}}
DEFINE_IID!(IID_INotificationVisual, 1753439118, 43606, 19985, 134, 211, 95, 154, 105, 87, 188, 91);
RT_INTERFACE!{interface INotificationVisual(INotificationVisualVtbl): IInspectable(IInspectableVtbl) [IID_INotificationVisual] {
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Language(&self, value: HSTRING) -> HRESULT,
    fn get_Bindings(&self, out: *mut *mut super::super::foundation::collections::IVector<NotificationBinding>) -> HRESULT,
    fn GetBinding(&self, templateName: HSTRING, out: *mut *mut NotificationBinding) -> HRESULT
}}
impl INotificationVisual {
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Language)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bindings(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<NotificationBinding>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Bindings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_binding(&self, templateName: &HStringArg) -> Result<ComPtr<NotificationBinding>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetBinding)(self as *const _ as *mut _, templateName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class NotificationVisual: INotificationVisual}
RT_ENUM! { enum PeriodicUpdateRecurrence: i32 {
    HalfHour (PeriodicUpdateRecurrence_HalfHour) = 0, Hour (PeriodicUpdateRecurrence_Hour) = 1, SixHours (PeriodicUpdateRecurrence_SixHours) = 2, TwelveHours (PeriodicUpdateRecurrence_TwelveHours) = 3, Daily (PeriodicUpdateRecurrence_Daily) = 4,
}}
DEFINE_IID!(IID_IScheduledTileNotification, 180135637, 39388, 19576, 161, 28, 201, 231, 248, 109, 126, 247);
RT_INTERFACE!{interface IScheduledTileNotification(IScheduledTileNotificationVtbl): IInspectable(IInspectableVtbl) [IID_IScheduledTileNotification] {
    #[cfg(not(feature="windows-data"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-data")] fn get_Content(&self, out: *mut *mut super::super::data::xml::dom::XmlDocument) -> HRESULT,
    fn get_DeliveryTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn put_ExpirationTime(&self, value: *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn get_ExpirationTime(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::DateTime>) -> HRESULT,
    fn put_Tag(&self, value: HSTRING) -> HRESULT,
    fn get_Tag(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Id(&self, value: HSTRING) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT
}}
impl IScheduledTileNotification {
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<super::super::data::xml::dom::XmlDocument>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delivery_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeliveryTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_expiration_time(&self, value: &super::super::foundation::IReference<super::super::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ExpirationTime)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_expiration_time(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExpirationTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tag(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Tag)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tag(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_id(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Id)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_id(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Id)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ScheduledTileNotification: IScheduledTileNotification}
impl RtActivatable<IScheduledTileNotificationFactory> for ScheduledTileNotification {}
impl ScheduledTileNotification {
    #[cfg(feature="windows-data")] #[inline] pub fn create_scheduled_tile_notification(content: &super::super::data::xml::dom::XmlDocument, deliveryTime: super::super::foundation::DateTime) -> Result<ComPtr<ScheduledTileNotification>> { unsafe {
        <Self as RtActivatable<IScheduledTileNotificationFactory>>::get_activation_factory().create_scheduled_tile_notification(content, deliveryTime)
    }}
}
DEFINE_CLSID!(ScheduledTileNotification(&[87,105,110,100,111,119,115,46,85,73,46,78,111,116,105,102,105,99,97,116,105,111,110,115,46,83,99,104,101,100,117,108,101,100,84,105,108,101,78,111,116,105,102,105,99,97,116,105,111,110,0]) [CLSID_ScheduledTileNotification]);
DEFINE_IID!(IID_IScheduledTileNotificationFactory, 864228234, 39104, 19515, 187, 214, 74, 99, 60, 124, 252, 41);
RT_INTERFACE!{static interface IScheduledTileNotificationFactory(IScheduledTileNotificationFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IScheduledTileNotificationFactory] {
    #[cfg(feature="windows-data")] fn CreateScheduledTileNotification(&self, content: *mut super::super::data::xml::dom::XmlDocument, deliveryTime: super::super::foundation::DateTime, out: *mut *mut ScheduledTileNotification) -> HRESULT
}}
impl IScheduledTileNotificationFactory {
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn create_scheduled_tile_notification(&self, content: &super::super::data::xml::dom::XmlDocument, deliveryTime: super::super::foundation::DateTime) -> Result<ComPtr<ScheduledTileNotification>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateScheduledTileNotification)(self as *const _ as *mut _, content as *const _ as *mut _, deliveryTime, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IScheduledToastNotification, 2046130168, 3559, 18637, 151, 64, 155, 55, 4, 144, 200, 56);
RT_INTERFACE!{interface IScheduledToastNotification(IScheduledToastNotificationVtbl): IInspectable(IInspectableVtbl) [IID_IScheduledToastNotification] {
    #[cfg(not(feature="windows-data"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-data")] fn get_Content(&self, out: *mut *mut super::super::data::xml::dom::XmlDocument) -> HRESULT,
    fn get_DeliveryTime(&self, out: *mut super::super::foundation::DateTime) -> HRESULT,
    fn get_SnoozeInterval(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::TimeSpan>) -> HRESULT,
    fn get_MaximumSnoozeCount(&self, out: *mut u32) -> HRESULT,
    fn put_Id(&self, value: HSTRING) -> HRESULT,
    fn get_Id(&self, out: *mut HSTRING) -> HRESULT
}}
impl IScheduledToastNotification {
    #[cfg(feature="windows-data")] #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<super::super::data::xml::dom::XmlDocument>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_delivery_time(&self) -> Result<super::super::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DeliveryTime)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_snooze_interval(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::TimeSpan>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SnoozeInterval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_maximum_snooze_count(&self) -> Result<u32> {
        let mut out = zeroed