use ::prelude::*;
DEFINE_IID!(IID_IAdaptiveTrigger, 2783985945, 3289, 18929, 162, 63, 68, 229, 71, 171, 159, 26);
RT_INTERFACE!{interface IAdaptiveTrigger(IAdaptiveTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveTrigger] {
    fn get_MinWindowWidth(&self, out: *mut f64) -> HRESULT,
    fn put_MinWindowWidth(&self, value: f64) -> HRESULT,
    fn get_MinWindowHeight(&self, out: *mut f64) -> HRESULT,
    fn put_MinWindowHeight(&self, value: f64) -> HRESULT
}}
impl IAdaptiveTrigger {
    #[inline] pub unsafe fn get_min_window_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinWindowWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_window_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinWindowWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_window_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinWindowHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_window_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinWindowHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AdaptiveTrigger: IAdaptiveTrigger}
impl RtActivatable<IAdaptiveTriggerStatics> for AdaptiveTrigger {}
impl AdaptiveTrigger {
    #[inline] pub fn get_min_window_width_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAdaptiveTriggerStatics>>::get_activation_factory().get_min_window_width_property()
    }}
    #[inline] pub fn get_min_window_height_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAdaptiveTriggerStatics>>::get_activation_factory().get_min_window_height_property()
    }}
}
DEFINE_CLSID!(AdaptiveTrigger(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,65,100,97,112,116,105,118,101,84,114,105,103,103,101,114,0]) [CLSID_AdaptiveTrigger]);
DEFINE_IID!(IID_IAdaptiveTriggerFactory, 3378959490, 23275, 18497, 146, 71, 193, 160, 189, 214, 245, 159);
RT_INTERFACE!{interface IAdaptiveTriggerFactory(IAdaptiveTriggerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveTriggerFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut AdaptiveTrigger) -> HRESULT
}}
impl IAdaptiveTriggerFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<AdaptiveTrigger>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAdaptiveTriggerStatics, 3106810346, 5653, 17232, 156, 59, 146, 178, 152, 107, 244, 68);
RT_INTERFACE!{static interface IAdaptiveTriggerStatics(IAdaptiveTriggerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAdaptiveTriggerStatics] {
    fn get_MinWindowWidthProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_MinWindowHeightProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IAdaptiveTriggerStatics {
    #[inline] pub unsafe fn get_min_window_width_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinWindowWidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_window_height_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinWindowHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplication, 1958240673, 29831, 18089, 154, 110, 199, 139, 81, 39, 38, 197);
RT_INTERFACE!{interface IApplication(IApplicationVtbl): IInspectable(IInspectableVtbl) [IID_IApplication] {
    fn get_Resources(&self, out: *mut *mut ResourceDictionary) -> HRESULT,
    fn put_Resources(&self, value: *mut ResourceDictionary) -> HRESULT,
    fn get_DebugSettings(&self, out: *mut *mut DebugSettings) -> HRESULT,
    fn get_RequestedTheme(&self, out: *mut ApplicationTheme) -> HRESULT,
    fn put_RequestedTheme(&self, value: ApplicationTheme) -> HRESULT,
    fn add_UnhandledException(&self, value: *mut UnhandledExceptionEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_UnhandledException(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Suspending(&self, value: *mut SuspendingEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Suspending(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Resuming(&self, value: *mut super::super::foundation::EventHandler<IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Resuming(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Exit(&self) -> HRESULT
}}
impl IApplication {
    #[inline] pub unsafe fn get_resources(&self) -> Result<ComPtr<ResourceDictionary>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Resources)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_resources(&self, value: &ResourceDictionary) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Resources)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_debug_settings(&self) -> Result<ComPtr<DebugSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DebugSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_requested_theme(&self) -> Result<ApplicationTheme> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestedTheme)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_requested_theme(&self, value: ApplicationTheme) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RequestedTheme)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_unhandled_exception(&self, value: &UnhandledExceptionEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_UnhandledException)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_unhandled_exception(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_UnhandledException)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_suspending(&self, value: &SuspendingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Suspending)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_suspending(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Suspending)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_resuming(&self, value: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Resuming)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_resuming(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Resuming)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn exit(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Exit)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Application: IApplication}
impl RtActivatable<IApplicationStatics> for Application {}
impl Application {
    #[inline] pub fn get_current() -> Result<ComPtr<Application>> { unsafe {
        <Self as RtActivatable<IApplicationStatics>>::get_activation_factory().get_current()
    }}
    #[inline] pub fn start(callback: &ApplicationInitializationCallback) -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationStatics>>::get_activation_factory().start(callback)
    }}
    #[inline] pub fn load_component(component: &IInspectable, resourceLocator: &super::super::foundation::Uri) -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationStatics>>::get_activation_factory().load_component(component, resourceLocator)
    }}
    #[inline] pub fn load_component_with_resource_location(component: &IInspectable, resourceLocator: &super::super::foundation::Uri, componentResourceLocation: controls::primitives::ComponentResourceLocation) -> Result<()> { unsafe {
        <Self as RtActivatable<IApplicationStatics>>::get_activation_factory().load_component_with_resource_location(component, resourceLocator, componentResourceLocation)
    }}
}
DEFINE_CLSID!(Application(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,65,112,112,108,105,99,97,116,105,111,110,0]) [CLSID_Application]);
DEFINE_IID!(IID_IApplication2, 26281150, 21034, 22788, 245, 47, 222, 114, 1, 4, 41, 224);
RT_INTERFACE!{interface IApplication2(IApplication2Vtbl): IInspectable(IInspectableVtbl) [IID_IApplication2] {
    fn get_FocusVisualKind(&self, out: *mut FocusVisualKind) -> HRESULT,
    fn put_FocusVisualKind(&self, value: FocusVisualKind) -> HRESULT,
    fn get_RequiresPointerMode(&self, out: *mut ApplicationRequiresPointerMode) -> HRESULT,
    fn put_RequiresPointerMode(&self, value: ApplicationRequiresPointerMode) -> HRESULT,
    fn add_LeavingBackground(&self, value: *mut LeavingBackgroundEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LeavingBackground(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_EnteredBackground(&self, value: *mut EnteredBackgroundEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EnteredBackground(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IApplication2 {
    #[inline] pub unsafe fn get_focus_visual_kind(&self) -> Result<FocusVisualKind> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusVisualKind)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_visual_kind(&self, value: FocusVisualKind) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusVisualKind)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_requires_pointer_mode(&self) -> Result<ApplicationRequiresPointerMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequiresPointerMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_requires_pointer_mode(&self, value: ApplicationRequiresPointerMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RequiresPointerMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_leaving_background(&self, value: &LeavingBackgroundEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LeavingBackground)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_leaving_background(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LeavingBackground)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_entered_background(&self, value: &EnteredBackgroundEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_EnteredBackground)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_entered_background(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_EnteredBackground)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplication3, 3077942652, 6328, 17866, 161, 176, 220, 72, 62, 75, 16, 40);
RT_INTERFACE!{interface IApplication3(IApplication3Vtbl): IInspectable(IInspectableVtbl) [IID_IApplication3] {
    fn get_HighContrastAdjustment(&self, out: *mut ApplicationHighContrastAdjustment) -> HRESULT,
    fn put_HighContrastAdjustment(&self, value: ApplicationHighContrastAdjustment) -> HRESULT
}}
impl IApplication3 {
    #[inline] pub unsafe fn get_high_contrast_adjustment(&self) -> Result<ApplicationHighContrastAdjustment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HighContrastAdjustment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_high_contrast_adjustment(&self, value: ApplicationHighContrastAdjustment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HighContrastAdjustment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationFactory, 2478564193, 48730, 20195, 180, 163, 149, 17, 141, 201, 122, 137);
RT_INTERFACE!{interface IApplicationFactory(IApplicationFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Application) -> HRESULT
}}
impl IApplicationFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Application>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationHighContrastAdjustment: u32 {
    None (ApplicationHighContrastAdjustment_None) = 0, Auto (ApplicationHighContrastAdjustment_Auto) = 4294967295,
}}
DEFINE_IID!(IID_ApplicationInitializationCallback, 3056933973, 49796, 18148, 131, 16, 251, 9, 103, 250, 183, 111);
RT_DELEGATE!{delegate ApplicationInitializationCallback(ApplicationInitializationCallbackVtbl, ApplicationInitializationCallbackImpl) [IID_ApplicationInitializationCallback] {
    fn Invoke(&self, p: *mut ApplicationInitializationCallbackParams) -> HRESULT
}}
impl ApplicationInitializationCallback {
    #[inline] pub unsafe fn invoke(&self, p: &ApplicationInitializationCallbackParams) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, p as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationInitializationCallbackParams, 1964734766, 22386, 17544, 139, 135, 245, 71, 250, 166, 68, 116);
RT_INTERFACE!{interface IApplicationInitializationCallbackParams(IApplicationInitializationCallbackParamsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationInitializationCallbackParams] {
    
}}
RT_CLASS!{class ApplicationInitializationCallbackParams: IApplicationInitializationCallbackParams}
DEFINE_IID!(IID_IApplicationOverrides, 637116407, 37703, 17818, 159, 172, 178, 208, 225, 28, 26, 15);
RT_INTERFACE!{interface IApplicationOverrides(IApplicationOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationOverrides] {
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnActivated(&self, args: *mut super::super::applicationmodel::activation::IActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnLaunched(&self, args: *mut super::super::applicationmodel::activation::LaunchActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnFileActivated(&self, args: *mut super::super::applicationmodel::activation::FileActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnSearchActivated(&self, args: *mut super::super::applicationmodel::activation::SearchActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnShareTargetActivated(&self, args: *mut super::super::applicationmodel::activation::ShareTargetActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnFileOpenPickerActivated(&self, args: *mut super::super::applicationmodel::activation::FileOpenPickerActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnFileSavePickerActivated(&self, args: *mut super::super::applicationmodel::activation::FileSavePickerActivatedEventArgs) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn OnCachedFileUpdaterActivated(&self, args: *mut super::super::applicationmodel::activation::CachedFileUpdaterActivatedEventArgs) -> HRESULT,
    fn OnWindowCreated(&self, args: *mut WindowCreatedEventArgs) -> HRESULT
}}
impl IApplicationOverrides {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_activated(&self, args: &super::super::applicationmodel::activation::IActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_launched(&self, args: &super::super::applicationmodel::activation::LaunchActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnLaunched)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_file_activated(&self, args: &super::super::applicationmodel::activation::FileActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnFileActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_search_activated(&self, args: &super::super::applicationmodel::activation::SearchActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnSearchActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_share_target_activated(&self, args: &super::super::applicationmodel::activation::ShareTargetActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnShareTargetActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_file_open_picker_activated(&self, args: &super::super::applicationmodel::activation::FileOpenPickerActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnFileOpenPickerActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_file_save_picker_activated(&self, args: &super::super::applicationmodel::activation::FileSavePickerActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnFileSavePickerActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_cached_file_updater_activated(&self, args: &super::super::applicationmodel::activation::CachedFileUpdaterActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnCachedFileUpdaterActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_window_created(&self, args: &WindowCreatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnWindowCreated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IApplicationOverrides2, 3680293561, 54196, 21900, 198, 78, 4, 52, 253, 27, 216, 137);
RT_INTERFACE!{interface IApplicationOverrides2(IApplicationOverrides2Vtbl): IInspectable(IInspectableVtbl) [IID_IApplicationOverrides2] {
    #[cfg(feature="windows-applicationmodel")] fn OnBackgroundActivated(&self, args: *mut super::super::applicationmodel::activation::BackgroundActivatedEventArgs) -> HRESULT
}}
impl IApplicationOverrides2 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn on_background_activated(&self, args: &super::super::applicationmodel::activation::BackgroundActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnBackgroundActivated)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationRequiresPointerMode: i32 {
    Auto (ApplicationRequiresPointerMode_Auto) = 0, WhenRequested (ApplicationRequiresPointerMode_WhenRequested) = 1,
}}
DEFINE_IID!(IID_IApplicationStatics, 105486743, 63412, 17918, 183, 99, 117, 119, 209, 211, 203, 74);
RT_INTERFACE!{static interface IApplicationStatics(IApplicationStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IApplicationStatics] {
    fn get_Current(&self, out: *mut *mut Application) -> HRESULT,
    fn Start(&self, callback: *mut ApplicationInitializationCallback) -> HRESULT,
    fn LoadComponent(&self, component: *mut IInspectable, resourceLocator: *mut super::super::foundation::Uri) -> HRESULT,
    fn LoadComponentWithResourceLocation(&self, component: *mut IInspectable, resourceLocator: *mut super::super::foundation::Uri, componentResourceLocation: controls::primitives::ComponentResourceLocation) -> HRESULT
}}
impl IApplicationStatics {
    #[inline] pub unsafe fn get_current(&self) -> Result<ComPtr<Application>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Current)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self, callback: &ApplicationInitializationCallback) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _, callback as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn load_component(&self, component: &IInspectable, resourceLocator: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).LoadComponent)(self as *const _ as *mut _, component as *const _ as *mut _, resourceLocator as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn load_component_with_resource_location(&self, component: &IInspectable, resourceLocator: &super::super::foundation::Uri, componentResourceLocation: controls::primitives::ComponentResourceLocation) -> Result<()> {
        let hr = ((*self.lpVtbl).LoadComponentWithResourceLocation)(self as *const _ as *mut _, component as *const _ as *mut _, resourceLocator as *const _ as *mut _, componentResourceLocation);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum ApplicationTheme: i32 {
    Light (ApplicationTheme_Light) = 0, Dark (ApplicationTheme_Dark) = 1,
}}
RT_ENUM! { enum AutomationTextAttributesEnum: i32 {
    AnimationStyleAttribute (AutomationTextAttributesEnum_AnimationStyleAttribute) = 40000, BackgroundColorAttribute (AutomationTextAttributesEnum_BackgroundColorAttribute) = 40001, BulletStyleAttribute (AutomationTextAttributesEnum_BulletStyleAttribute) = 40002, CapStyleAttribute (AutomationTextAttributesEnum_CapStyleAttribute) = 40003, CultureAttribute (AutomationTextAttributesEnum_CultureAttribute) = 40004, FontNameAttribute (AutomationTextAttributesEnum_FontNameAttribute) = 40005, FontSizeAttribute (AutomationTextAttributesEnum_FontSizeAttribute) = 40006, FontWeightAttribute (AutomationTextAttributesEnum_FontWeightAttribute) = 40007, ForegroundColorAttribute (AutomationTextAttributesEnum_ForegroundColorAttribute) = 40008, HorizontalTextAlignmentAttribute (AutomationTextAttributesEnum_HorizontalTextAlignmentAttribute) = 40009, IndentationFirstLineAttribute (AutomationTextAttributesEnum_IndentationFirstLineAttribute) = 40010, IndentationLeadingAttribute (AutomationTextAttributesEnum_IndentationLeadingAttribute) = 40011, IndentationTrailingAttribute (AutomationTextAttributesEnum_IndentationTrailingAttribute) = 40012, IsHiddenAttribute (AutomationTextAttributesEnum_IsHiddenAttribute) = 40013, IsItalicAttribute (AutomationTextAttributesEnum_IsItalicAttribute) = 40014, IsReadOnlyAttribute (AutomationTextAttributesEnum_IsReadOnlyAttribute) = 40015, IsSubscriptAttribute (AutomationTextAttributesEnum_IsSubscriptAttribute) = 40016, IsSuperscriptAttribute (AutomationTextAttributesEnum_IsSuperscriptAttribute) = 40017, MarginBottomAttribute (AutomationTextAttributesEnum_MarginBottomAttribute) = 40018, MarginLeadingAttribute (AutomationTextAttributesEnum_MarginLeadingAttribute) = 40019, MarginTopAttribute (AutomationTextAttributesEnum_MarginTopAttribute) = 40020, MarginTrailingAttribute (AutomationTextAttributesEnum_MarginTrailingAttribute) = 40021, OutlineStylesAttribute (AutomationTextAttributesEnum_OutlineStylesAttribute) = 40022, OverlineColorAttribute (AutomationTextAttributesEnum_OverlineColorAttribute) = 40023, OverlineStyleAttribute (AutomationTextAttributesEnum_OverlineStyleAttribute) = 40024, StrikethroughColorAttribute (AutomationTextAttributesEnum_StrikethroughColorAttribute) = 40025, StrikethroughStyleAttribute (AutomationTextAttributesEnum_StrikethroughStyleAttribute) = 40026, TabsAttribute (AutomationTextAttributesEnum_TabsAttribute) = 40027, TextFlowDirectionsAttribute (AutomationTextAttributesEnum_TextFlowDirectionsAttribute) = 40028, UnderlineColorAttribute (AutomationTextAttributesEnum_UnderlineColorAttribute) = 40029, UnderlineStyleAttribute (AutomationTextAttributesEnum_UnderlineStyleAttribute) = 40030, AnnotationTypesAttribute (AutomationTextAttributesEnum_AnnotationTypesAttribute) = 40031, AnnotationObjectsAttribute (AutomationTextAttributesEnum_AnnotationObjectsAttribute) = 40032, StyleNameAttribute (AutomationTextAttributesEnum_StyleNameAttribute) = 40033, StyleIdAttribute (AutomationTextAttributesEnum_StyleIdAttribute) = 40034, LinkAttribute (AutomationTextAttributesEnum_LinkAttribute) = 40035, IsActiveAttribute (AutomationTextAttributesEnum_IsActiveAttribute) = 40036, SelectionActiveEndAttribute (AutomationTextAttributesEnum_SelectionActiveEndAttribute) = 40037, CaretPositionAttribute (AutomationTextAttributesEnum_CaretPositionAttribute) = 40038, CaretBidiModeAttribute (AutomationTextAttributesEnum_CaretBidiModeAttribute) = 40039,
}}
DEFINE_IID!(IID_IBindingFailedEventArgs, 851562515, 19901, 17517, 187, 184, 13, 227, 80, 72, 164, 73);
RT_INTERFACE!{interface IBindingFailedEventArgs(IBindingFailedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBindingFailedEventArgs] {
    fn get_Message(&self, out: *mut HSTRING) -> HRESULT
}}
impl IBindingFailedEventArgs {
    #[inline] pub unsafe fn get_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class BindingFailedEventArgs: IBindingFailedEventArgs}
DEFINE_IID!(IID_BindingFailedEventHandler, 325785474, 21690, 16909, 161, 170, 130, 130, 135, 33, 205, 230);
RT_DELEGATE!{delegate BindingFailedEventHandler(BindingFailedEventHandlerVtbl, BindingFailedEventHandlerImpl) [IID_BindingFailedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut BindingFailedEventArgs) -> HRESULT
}}
impl BindingFailedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &BindingFailedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBringIntoViewOptions, 431870389, 51147, 18137, 164, 221, 161, 187, 232, 62, 242, 251);
RT_INTERFACE!{interface IBringIntoViewOptions(IBringIntoViewOptionsVtbl): IInspectable(IInspectableVtbl) [IID_IBringIntoViewOptions] {
    fn get_AnimationDesired(&self, out: *mut bool) -> HRESULT,
    fn put_AnimationDesired(&self, value: bool) -> HRESULT,
    fn get_TargetRect(&self, out: *mut *mut super::super::foundation::IReference<super::super::foundation::Rect>) -> HRESULT,
    fn put_TargetRect(&self, value: *mut super::super::foundation::IReference<super::super::foundation::Rect>) -> HRESULT
}}
impl IBringIntoViewOptions {
    #[inline] pub unsafe fn get_animation_desired(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AnimationDesired)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_animation_desired(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AnimationDesired)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_rect(&self) -> Result<ComPtr<super::super::foundation::IReference<super::super::foundation::Rect>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetRect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_rect(&self, value: &super::super::foundation::IReference<super::super::foundation::Rect>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetRect)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BringIntoViewOptions: IBringIntoViewOptions}
impl RtActivatable<IActivationFactory> for BringIntoViewOptions {}
DEFINE_CLSID!(BringIntoViewOptions(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,66,114,105,110,103,73,110,116,111,86,105,101,119,79,112,116,105,111,110,115,0]) [CLSID_BringIntoViewOptions]);
RT_STRUCT! { struct CornerRadius {
    TopLeft: f64, TopRight: f64, BottomRight: f64, BottomLeft: f64,
}}
DEFINE_IID!(IID_ICornerRadiusHelper, 4252754306, 7387, 17032, 184, 200, 133, 238, 121, 41, 123, 252);
RT_INTERFACE!{interface ICornerRadiusHelper(ICornerRadiusHelperVtbl): IInspectable(IInspectableVtbl) [IID_ICornerRadiusHelper] {
    
}}
RT_CLASS!{class CornerRadiusHelper: ICornerRadiusHelper}
impl RtActivatable<ICornerRadiusHelperStatics> for CornerRadiusHelper {}
impl CornerRadiusHelper {
    #[inline] pub fn from_radii(topLeft: f64, topRight: f64, bottomRight: f64, bottomLeft: f64) -> Result<CornerRadius> { unsafe {
        <Self as RtActivatable<ICornerRadiusHelperStatics>>::get_activation_factory().from_radii(topLeft, topRight, bottomRight, bottomLeft)
    }}
    #[inline] pub fn from_uniform_radius(uniformRadius: f64) -> Result<CornerRadius> { unsafe {
        <Self as RtActivatable<ICornerRadiusHelperStatics>>::get_activation_factory().from_uniform_radius(uniformRadius)
    }}
}
DEFINE_CLSID!(CornerRadiusHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,114,110,101,114,82,97,100,105,117,115,72,101,108,112,101,114,0]) [CLSID_CornerRadiusHelper]);
DEFINE_IID!(IID_ICornerRadiusHelperStatics, 4104255065, 54484, 17695, 163, 135, 214, 191, 75, 36, 81, 212);
RT_INTERFACE!{static interface ICornerRadiusHelperStatics(ICornerRadiusHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICornerRadiusHelperStatics] {
    fn FromRadii(&self, topLeft: f64, topRight: f64, bottomRight: f64, bottomLeft: f64, out: *mut CornerRadius) -> HRESULT,
    fn FromUniformRadius(&self, uniformRadius: f64, out: *mut CornerRadius) -> HRESULT
}}
impl ICornerRadiusHelperStatics {
    #[inline] pub unsafe fn from_radii(&self, topLeft: f64, topRight: f64, bottomRight: f64, bottomLeft: f64) -> Result<CornerRadius> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromRadii)(self as *const _ as *mut _, topLeft, topRight, bottomRight, bottomLeft, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_uniform_radius(&self, uniformRadius: f64) -> Result<CornerRadius> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromUniformRadius)(self as *const _ as *mut _, uniformRadius, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_CreateDefaultValueCallback, 3605836076, 5557, 20168, 185, 92, 205, 210, 8, 240, 129, 83);
RT_DELEGATE!{delegate CreateDefaultValueCallback(CreateDefaultValueCallbackVtbl, CreateDefaultValueCallbackImpl) [IID_CreateDefaultValueCallback] {
    fn Invoke(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl CreateDefaultValueCallback {
    #[inline] pub unsafe fn invoke(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataContextChangedEventArgs, 2108067361, 2959, 20383, 161, 67, 248, 231, 120, 1, 54, 162);
RT_INTERFACE!{interface IDataContextChangedEventArgs(IDataContextChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDataContextChangedEventArgs] {
    fn get_NewValue(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl IDataContextChangedEventArgs {
    #[inline] pub unsafe fn get_new_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DataContextChangedEventArgs: IDataContextChangedEventArgs}
DEFINE_IID!(IID_IDataTemplate, 2568007367, 35509, 16664, 155, 198, 9, 244, 90, 53, 7, 61);
RT_INTERFACE!{interface IDataTemplate(IDataTemplateVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplate] {
    fn LoadContent(&self, out: *mut *mut DependencyObject) -> HRESULT
}}
impl IDataTemplate {
    #[inline] pub unsafe fn load_content(&self) -> Result<ComPtr<DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).LoadContent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DataTemplate: IDataTemplate}
impl RtActivatable<IDataTemplateStatics2> for DataTemplate {}
impl DataTemplate {
    #[inline] pub fn get_extension_instance_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDataTemplateStatics2>>::get_activation_factory().get_extension_instance_property()
    }}
    #[inline] pub fn get_extension_instance(element: &FrameworkElement) -> Result<ComPtr<IDataTemplateExtension>> { unsafe {
        <Self as RtActivatable<IDataTemplateStatics2>>::get_activation_factory().get_extension_instance(element)
    }}
    #[inline] pub fn set_extension_instance(element: &FrameworkElement, value: &IDataTemplateExtension) -> Result<()> { unsafe {
        <Self as RtActivatable<IDataTemplateStatics2>>::get_activation_factory().set_extension_instance(element, value)
    }}
}
DEFINE_CLSID!(DataTemplate(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,68,97,116,97,84,101,109,112,108,97,116,101,0]) [CLSID_DataTemplate]);
DEFINE_IID!(IID_IDataTemplateExtension, 1499370823, 52735, 19346, 183, 115, 171, 57, 104, 120, 243, 83);
RT_INTERFACE!{interface IDataTemplateExtension(IDataTemplateExtensionVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateExtension] {
    fn ResetTemplate(&self) -> HRESULT,
    fn ProcessBinding(&self, phase: u32, out: *mut bool) -> HRESULT,
    fn ProcessBindings(&self, arg: *mut controls::ContainerContentChangingEventArgs, out: *mut i32) -> HRESULT
}}
impl IDataTemplateExtension {
    #[inline] pub unsafe fn reset_template(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ResetTemplate)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_binding(&self, phase: u32) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ProcessBinding)(self as *const _ as *mut _, phase, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn process_bindings(&self, arg: &controls::ContainerContentChangingEventArgs) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ProcessBindings)(self as *const _ as *mut _, arg as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataTemplateFactory, 1374526846, 11091, 18267, 156, 136, 12, 24, 50, 200, 53, 26);
RT_INTERFACE!{interface IDataTemplateFactory(IDataTemplateFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DataTemplate) -> HRESULT
}}
impl IDataTemplateFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DataTemplate>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataTemplateKey, 2268818472, 52459, 19297, 134, 250, 178, 206, 195, 156, 194, 250);
RT_INTERFACE!{interface IDataTemplateKey(IDataTemplateKeyVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateKey] {
    fn get_DataType(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_DataType(&self, value: *mut IInspectable) -> HRESULT
}}
impl IDataTemplateKey {
    #[inline] pub unsafe fn get_data_type(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data_type(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataType)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DataTemplateKey: IDataTemplateKey}
DEFINE_IID!(IID_IDataTemplateKeyFactory, 3916114265, 55682, 16722, 145, 203, 222, 14, 77, 253, 118, 147);
RT_INTERFACE!{interface IDataTemplateKeyFactory(IDataTemplateKeyFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateKeyFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DataTemplateKey) -> HRESULT,
    fn CreateInstanceWithType(&self, dataType: *mut IInspectable, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DataTemplateKey) -> HRESULT
}}
impl IDataTemplateKeyFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DataTemplateKey>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_instance_with_type(&self, dataType: &IInspectable, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DataTemplateKey>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstanceWithType)(self as *const _ as *mut _, dataType as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataTemplateStatics2, 2331475315, 43521, 18206, 190, 221, 139, 173, 134, 33, 155, 119);
RT_INTERFACE!{static interface IDataTemplateStatics2(IDataTemplateStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateStatics2] {
    fn get_ExtensionInstanceProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn GetExtensionInstance(&self, element: *mut FrameworkElement, out: *mut *mut IDataTemplateExtension) -> HRESULT,
    fn SetExtensionInstance(&self, element: *mut FrameworkElement, value: *mut IDataTemplateExtension) -> HRESULT
}}
impl IDataTemplateStatics2 {
    #[inline] pub unsafe fn get_extension_instance_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExtensionInstanceProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_extension_instance(&self, element: &FrameworkElement) -> Result<ComPtr<IDataTemplateExtension>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetExtensionInstance)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_extension_instance(&self, element: &FrameworkElement, value: &IDataTemplateExtension) -> Result<()> {
        let hr = ((*self.lpVtbl).SetExtensionInstance)(self as *const _ as *mut _, element as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDebugSettings, 1027940248, 50855, 19735, 131, 152, 216, 58, 6, 113, 131, 216);
RT_INTERFACE!{interface IDebugSettings(IDebugSettingsVtbl): IInspectable(IInspectableVtbl) [IID_IDebugSettings] {
    fn get_EnableFrameRateCounter(&self, out: *mut bool) -> HRESULT,
    fn put_EnableFrameRateCounter(&self, value: bool) -> HRESULT,
    fn get_IsBindingTracingEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsBindingTracingEnabled(&self, value: bool) -> HRESULT,
    fn get_IsOverdrawHeatMapEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsOverdrawHeatMapEnabled(&self, value: bool) -> HRESULT,
    fn add_BindingFailed(&self, value: *mut BindingFailedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_BindingFailed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IDebugSettings {
    #[inline] pub unsafe fn get_enable_frame_rate_counter(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EnableFrameRateCounter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enable_frame_rate_counter(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EnableFrameRateCounter)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_binding_tracing_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBindingTracingEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_binding_tracing_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsBindingTracingEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_overdraw_heat_map_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOverdrawHeatMapEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_overdraw_heat_map_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOverdrawHeatMapEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_binding_failed(&self, value: &BindingFailedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_BindingFailed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_binding_failed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_BindingFailed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DebugSettings: IDebugSettings}
DEFINE_IID!(IID_IDebugSettings2, 1221817733, 57766, 18075, 131, 200, 48, 130, 80, 55, 17, 158);
RT_INTERFACE!{interface IDebugSettings2(IDebugSettings2Vtbl): IInspectable(IInspectableVtbl) [IID_IDebugSettings2] {
    fn get_EnableRedrawRegions(&self, out: *mut bool) -> HRESULT,
    fn put_EnableRedrawRegions(&self, value: bool) -> HRESULT
}}
impl IDebugSettings2 {
    #[inline] pub unsafe fn get_enable_redraw_regions(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_EnableRedrawRegions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_enable_redraw_regions(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_EnableRedrawRegions)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDebugSettings3, 3871035426, 1573, 18335, 142, 50, 75, 88, 61, 115, 183, 172);
RT_INTERFACE!{interface IDebugSettings3(IDebugSettings3Vtbl): IInspectable(IInspectableVtbl) [IID_IDebugSettings3] {
    fn get_IsTextPerformanceVisualizationEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTextPerformanceVisualizationEnabled(&self, value: bool) -> HRESULT
}}
impl IDebugSettings3 {
    #[inline] pub unsafe fn get_is_text_performance_visualization_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTextPerformanceVisualizationEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_text_performance_visualization_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTextPerformanceVisualizationEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDependencyObject, 1548904037, 62990, 18706, 175, 89, 95, 224, 104, 15, 8, 157);
RT_INTERFACE!{interface IDependencyObject(IDependencyObjectVtbl): IInspectable(IInspectableVtbl) [IID_IDependencyObject] {
    fn GetValue(&self, dp: *mut DependencyProperty, out: *mut *mut IInspectable) -> HRESULT,
    fn SetValue(&self, dp: *mut DependencyProperty, value: *mut IInspectable) -> HRESULT,
    fn ClearValue(&self, dp: *mut DependencyProperty) -> HRESULT,
    fn ReadLocalValue(&self, dp: *mut DependencyProperty, out: *mut *mut IInspectable) -> HRESULT,
    fn GetAnimationBaseValue(&self, dp: *mut DependencyProperty, out: *mut *mut IInspectable) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_Dispatcher(&self, out: *mut *mut super::core::CoreDispatcher) -> HRESULT
}}
impl IDependencyObject {
    #[inline] pub unsafe fn get_value(&self, dp: &DependencyProperty) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetValue)(self as *const _ as *mut _, dp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value(&self, dp: &DependencyProperty, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).SetValue)(self as *const _ as *mut _, dp as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear_value(&self, dp: &DependencyProperty) -> Result<()> {
        let hr = ((*self.lpVtbl).ClearValue)(self as *const _ as *mut _, dp as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn read_local_value(&self, dp: &DependencyProperty) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ReadLocalValue)(self as *const _ as *mut _, dp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_animation_base_value(&self, dp: &DependencyProperty) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAnimationBaseValue)(self as *const _ as *mut _, dp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_dispatcher(&self) -> Result<ComPtr<super::core::CoreDispatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dispatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DependencyObject: IDependencyObject}
DEFINE_IID!(IID_IDependencyObject2, 704567389, 15650, 17313, 173, 208, 23, 2, 124, 8, 178, 18);
RT_INTERFACE!{interface IDependencyObject2(IDependencyObject2Vtbl): IInspectable(IInspectableVtbl) [IID_IDependencyObject2] {
    fn RegisterPropertyChangedCallback(&self, dp: *mut DependencyProperty, callback: *mut DependencyPropertyChangedCallback, out: *mut i64) -> HRESULT,
    fn UnregisterPropertyChangedCallback(&self, dp: *mut DependencyProperty, token: i64) -> HRESULT
}}
impl IDependencyObject2 {
    #[inline] pub unsafe fn register_property_changed_callback(&self, dp: &DependencyProperty, callback: &DependencyPropertyChangedCallback) -> Result<i64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).RegisterPropertyChangedCallback)(self as *const _ as *mut _, dp as *const _ as *mut _, callback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn unregister_property_changed_callback(&self, dp: &DependencyProperty, token: i64) -> Result<()> {
        let hr = ((*self.lpVtbl).UnregisterPropertyChangedCallback)(self as *const _ as *mut _, dp as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DependencyObjectCollection: super::super::foundation::collections::IObservableVector<DependencyObject>}
DEFINE_IID!(IID_IDependencyObjectCollectionFactory, 85883391, 45992, 18926, 181, 175, 172, 143, 104, 182, 73, 228);
RT_INTERFACE!{interface IDependencyObjectCollectionFactory(IDependencyObjectCollectionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDependencyObjectCollectionFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DependencyObjectCollection) -> HRESULT
}}
impl IDependencyObjectCollectionFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DependencyObjectCollection>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDependencyObjectFactory, 2583932818, 32138, 18743, 136, 79, 236, 243, 79, 224, 42, 203);
RT_INTERFACE!{interface IDependencyObjectFactory(IDependencyObjectFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDependencyObjectFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DependencyObject) -> HRESULT
}}
impl IDependencyObjectFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DependencyObject>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDependencyProperty, 2242984304, 39876, 20118, 172, 241, 48, 200, 253, 61, 85, 200);
RT_INTERFACE!{interface IDependencyProperty(IDependencyPropertyVtbl): IInspectable(IInspectableVtbl) [IID_IDependencyProperty] {
    fn GetMetadata(&self, forType: interop::TypeName, out: *mut *mut PropertyMetadata) -> HRESULT
}}
impl IDependencyProperty {
    #[inline] pub unsafe fn get_metadata(&self, forType: interop::TypeName) -> Result<ComPtr<PropertyMetadata>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetMetadata)(self as *const _ as *mut _, forType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DependencyProperty: IDependencyProperty}
impl RtActivatable<IDependencyPropertyStatics> for DependencyProperty {}
impl DependencyProperty {
    #[inline] pub fn get_unset_value() -> Result<ComPtr<IInspectable>> { unsafe {
        <Self as RtActivatable<IDependencyPropertyStatics>>::get_activation_factory().get_unset_value()
    }}
    #[inline] pub fn register(name: &HStringArg, propertyType: interop::TypeName, ownerType: interop::TypeName, typeMetadata: &PropertyMetadata) -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDependencyPropertyStatics>>::get_activation_factory().register(name, propertyType, ownerType, typeMetadata)
    }}
    #[inline] pub fn register_attached(name: &HStringArg, propertyType: interop::TypeName, ownerType: interop::TypeName, defaultMetadata: &PropertyMetadata) -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDependencyPropertyStatics>>::get_activation_factory().register_attached(name, propertyType, ownerType, defaultMetadata)
    }}
}
DEFINE_CLSID!(DependencyProperty(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,68,101,112,101,110,100,101,110,99,121,80,114,111,112,101,114,116,121,0]) [CLSID_DependencyProperty]);
DEFINE_IID!(IID_DependencyPropertyChangedCallback, 1166556438, 10175, 19393, 172, 38, 148, 193, 96, 31, 58, 73);
RT_DELEGATE!{delegate DependencyPropertyChangedCallback(DependencyPropertyChangedCallbackVtbl, DependencyPropertyChangedCallbackImpl) [IID_DependencyPropertyChangedCallback] {
    fn Invoke(&self, sender: *mut DependencyObject, dp: *mut DependencyProperty) -> HRESULT
}}
impl DependencyPropertyChangedCallback {
    #[inline] pub unsafe fn invoke(&self, sender: &DependencyObject, dp: &DependencyProperty) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, dp as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDependencyPropertyChangedEventArgs, 2166434859, 9424, 18775, 171, 195, 34, 68, 112, 169, 58, 78);
RT_INTERFACE!{interface IDependencyPropertyChangedEventArgs(IDependencyPropertyChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDependencyPropertyChangedEventArgs] {
    fn get_Property(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_OldValue(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_NewValue(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IDependencyPropertyChangedEventArgs {
    #[inline] pub unsafe fn get_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Property)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_old_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OldValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DependencyPropertyChangedEventArgs: IDependencyPropertyChangedEventArgs}
DEFINE_IID!(IID_DependencyPropertyChangedEventHandler, 153239130, 30142, 17561, 129, 128, 29, 220, 0, 84, 33, 192);
RT_DELEGATE!{delegate DependencyPropertyChangedEventHandler(DependencyPropertyChangedEventHandlerVtbl, DependencyPropertyChangedEventHandlerImpl) [IID_DependencyPropertyChangedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut DependencyPropertyChangedEventArgs) -> HRESULT
}}
impl DependencyPropertyChangedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &DependencyPropertyChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDependencyPropertyStatics, 1239806607, 33369, 19804, 170, 224, 131, 213, 109, 187, 104, 217);
RT_INTERFACE!{static interface IDependencyPropertyStatics(IDependencyPropertyStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDependencyPropertyStatics] {
    fn get_UnsetValue(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn Register(&self, name: HSTRING, propertyType: interop::TypeName, ownerType: interop::TypeName, typeMetadata: *mut PropertyMetadata, out: *mut *mut DependencyProperty) -> HRESULT,
    fn RegisterAttached(&self, name: HSTRING, propertyType: interop::TypeName, ownerType: interop::TypeName, defaultMetadata: *mut PropertyMetadata, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IDependencyPropertyStatics {
    #[inline] pub unsafe fn get_unset_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UnsetValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn register(&self, name: &HStringArg, propertyType: interop::TypeName, ownerType: interop::TypeName, typeMetadata: &PropertyMetadata) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).Register)(self as *const _ as *mut _, name.get(), propertyType, ownerType, typeMetadata as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_attached(&self, name: &HStringArg, propertyType: interop::TypeName, ownerType: interop::TypeName, defaultMetadata: &PropertyMetadata) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).RegisterAttached)(self as *const _ as *mut _, name.get(), propertyType, ownerType, defaultMetadata as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDispatcherTimer, 3512782406, 52514, 20319, 140, 151, 64, 230, 29, 163, 226, 220);
RT_INTERFACE!{interface IDispatcherTimer(IDispatcherTimerVtbl): IInspectable(IInspectableVtbl) [IID_IDispatcherTimer] {
    fn get_Interval(&self, out: *mut super::super::foundation::TimeSpan) -> HRESULT,
    fn put_Interval(&self, value: super::super::foundation::TimeSpan) -> HRESULT,
    fn get_IsEnabled(&self, out: *mut bool) -> HRESULT,
    fn add_Tick(&self, value: *mut super::super::foundation::EventHandler<IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Tick(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Start(&self) -> HRESULT,
    fn Stop(&self) -> HRESULT
}}
impl IDispatcherTimer {
    #[inline] pub unsafe fn get_interval(&self) -> Result<super::super::foundation::TimeSpan> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Interval)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_interval(&self, value: super::super::foundation::TimeSpan) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Interval)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_tick(&self, value: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Tick)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_tick(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Tick)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Start)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn stop(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Stop)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DispatcherTimer: IDispatcherTimer}
DEFINE_IID!(IID_IDispatcherTimerFactory, 3918929518, 13862, 16442, 175, 224, 4, 13, 88, 22, 86, 50);
RT_INTERFACE!{interface IDispatcherTimerFactory(IDispatcherTimerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDispatcherTimerFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DispatcherTimer) -> HRESULT
}}
impl IDispatcherTimerFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DispatcherTimer>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDragEventArgs, 3024144323, 692, 18816, 147, 66, 37, 218, 225, 192, 241, 136);
RT_INTERFACE!{interface IDragEventArgs(IDragEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDragEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn get_Data(&self, out: *mut *mut super::super::applicationmodel::datatransfer::DataPackage) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn put_Data(&self, value: *mut super::super::applicationmodel::datatransfer::DataPackage) -> HRESULT,
    fn GetPosition(&self, relativeTo: *mut UIElement, out: *mut super::super::foundation::Point) -> HRESULT
}}
impl IDragEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<super::super::applicationmodel::datatransfer::DataPackage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn set_data(&self, value: &super::super::applicationmodel::datatransfer::DataPackage) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Data)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self, relativeTo: &UIElement) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetPosition)(self as *const _ as *mut _, relativeTo as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DragEventArgs: IDragEventArgs}
DEFINE_IID!(IID_IDragEventArgs2, 640902744, 10519, 16669, 191, 195, 47, 34, 71, 28, 187, 231);
RT_INTERFACE!{interface IDragEventArgs2(IDragEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IDragEventArgs2] {
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn get_DataView(&self, out: *mut *mut super::super::applicationmodel::datatransfer::DataPackageView) -> HRESULT,
    fn get_DragUIOverride(&self, out: *mut *mut DragUIOverride) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn get_Modifiers(&self, out: *mut super::super::applicationmodel::datatransfer::dragdrop::DragDropModifiers) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn get_AcceptedOperation(&self, out: *mut super::super::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn put_AcceptedOperation(&self, value: super::super::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut DragOperationDeferral) -> HRESULT
}}
impl IDragEventArgs2 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_data_view(&self) -> Result<ComPtr<super::super::applicationmodel::datatransfer::DataPackageView>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drag_uioverride(&self) -> Result<ComPtr<DragUIOverride>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DragUIOverride)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_modifiers(&self) -> Result<super::super::applicationmodel::datatransfer::dragdrop::DragDropModifiers> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Modifiers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_accepted_operation(&self) -> Result<super::super::applicationmodel::datatransfer::DataPackageOperation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AcceptedOperation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn set_accepted_operation(&self, value: super::super::applicationmodel::datatransfer::DataPackageOperation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AcceptedOperation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<DragOperationDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDragEventArgs3, 3494888390, 33049, 17018, 129, 82, 95, 149, 80, 204, 4, 22);
RT_INTERFACE!{interface IDragEventArgs3(IDragEventArgs3Vtbl): IInspectable(IInspectableVtbl) [IID_IDragEventArgs3] {
    #[cfg(feature="windows-applicationmodel")] fn get_AllowedOperations(&self, out: *mut super::super::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT
}}
impl IDragEventArgs3 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_allowed_operations(&self) -> Result<super::super::applicationmodel::datatransfer::DataPackageOperation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowedOperations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_DragEventHandler, 716284421, 7795, 19407, 170, 188, 87, 185, 126, 33, 150, 29);
RT_DELEGATE!{delegate DragEventHandler(DragEventHandlerVtbl, DragEventHandlerImpl) [IID_DragEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut DragEventArgs) -> HRESULT
}}
impl DragEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &DragEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDragOperationDeferral, 3128159418, 7027, 16518, 179, 211, 194, 35, 190, 234, 22, 51);
RT_INTERFACE!{interface IDragOperationDeferral(IDragOperationDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IDragOperationDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IDragOperationDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DragOperationDeferral: IDragOperationDeferral}
DEFINE_IID!(IID_IDragStartingEventArgs, 1744884730, 37048, 18169, 142, 48, 90, 194, 95, 115, 240, 249);
RT_INTERFACE!{interface IDragStartingEventArgs(IDragStartingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDragStartingEventArgs] {
    fn get_Cancel(&self, out: *mut bool) -> HRESULT,
    fn put_Cancel(&self, value: bool) -> HRESULT,
    #[cfg(not(feature="windows-applicationmodel"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-applicationmodel")] fn get_Data(&self, out: *mut *mut super::super::applicationmodel::datatransfer::DataPackage) -> HRESULT,
    fn get_DragUI(&self, out: *mut *mut DragUI) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut DragOperationDeferral) -> HRESULT,
    fn GetPosition(&self, relativeTo: *mut UIElement, out: *mut super::super::foundation::Point) -> HRESULT
}}
impl IDragStartingEventArgs {
    #[inline] pub unsafe fn get_cancel(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cancel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Cancel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<super::super::applicationmodel::datatransfer::DataPackage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drag_ui(&self) -> Result<ComPtr<DragUI>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DragUI)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<DragOperationDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_position(&self, relativeTo: &UIElement) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetPosition)(self as *const _ as *mut _, relativeTo as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DragStartingEventArgs: IDragStartingEventArgs}
DEFINE_IID!(IID_IDragStartingEventArgs2, 3629506702, 17590, 16913, 189, 11, 127, 221, 187, 110, 130, 49);
RT_INTERFACE!{interface IDragStartingEventArgs2(IDragStartingEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IDragStartingEventArgs2] {
    #[cfg(feature="windows-applicationmodel")] fn get_AllowedOperations(&self, out: *mut super::super::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn put_AllowedOperations(&self, value: super::super::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT
}}
impl IDragStartingEventArgs2 {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_allowed_operations(&self) -> Result<super::super::applicationmodel::datatransfer::DataPackageOperation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowedOperations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn set_allowed_operations(&self, value: super::super::applicationmodel::datatransfer::DataPackageOperation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowedOperations)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDragUI, 765188152, 31840, 18498, 145, 112, 52, 111, 225, 10, 34, 106);
RT_INTERFACE!{interface IDragUI(IDragUIVtbl): IInspectable(IInspectableVtbl) [IID_IDragUI] {
    fn SetContentFromBitmapImage(&self, bitmapImage: *mut media::imaging::BitmapImage) -> HRESULT,
    fn SetContentFromBitmapImageWithAnchorPoint(&self, bitmapImage: *mut media::imaging::BitmapImage, anchorPoint: super::super::foundation::Point) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-graphics")] fn SetContentFromSoftwareBitmap(&self, softwareBitmap: *mut super::super::graphics::imaging::SoftwareBitmap) -> HRESULT,
    #[cfg(not(feature="windows-graphics"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-graphics")] fn SetContentFromSoftwareBitmapWithAnchorPoint(&self, softwareBitmap: *mut super::super::graphics::imaging::SoftwareBitmap, anchorPoint: super::super::foundation::Point) -> HRESULT,
    fn SetContentFromDataPackage(&self) -> HRESULT
}}
impl IDragUI {
    #[inline] pub unsafe fn set_content_from_bitmap_image(&self, bitmapImage: &media::imaging::BitmapImage) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromBitmapImage)(self as *const _ as *mut _, bitmapImage as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_from_bitmap_image_with_anchor_point(&self, bitmapImage: &media::imaging::BitmapImage, anchorPoint: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromBitmapImageWithAnchorPoint)(self as *const _ as *mut _, bitmapImage as *const _ as *mut _, anchorPoint);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn set_content_from_software_bitmap(&self, softwareBitmap: &super::super::graphics::imaging::SoftwareBitmap) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromSoftwareBitmap)(self as *const _ as *mut _, softwareBitmap as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn set_content_from_software_bitmap_with_anchor_point(&self, softwareBitmap: &super::super::graphics::imaging::SoftwareBitmap, anchorPoint: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromSoftwareBitmapWithAnchorPoint)(self as *const _ as *mut _, softwareBitmap as *const _ as *mut _, anchorPoint);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_from_data_package(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromDataPackage)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DragUI: IDragUI}
DEFINE_IID!(IID_IDragUIOverride, 3178012154, 51553, 18529, 183, 165, 191, 79, 228, 168, 166, 239);
RT_INTERFACE!{interface IDragUIOverride(IDragUIOverrideVtbl): IInspectable(IInspectableVtbl) [IID_IDragUIOverride] {
    fn get_Caption(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Caption(&self, value: HSTRING) -> HRESULT,
    fn get_IsContentVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsContentVisible(&self, value: bool) -> HRESULT,
    fn get_IsCaptionVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsCaptionVisible(&self, value: bool) -> HRESULT,
    fn get_IsGlyphVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsGlyphVisible(&self, value: bool) -> HRESULT,
    fn Clear(&self) -> HRESULT,
    fn SetContentFromBitmapImage(&self, bitmapImage: *mut media::imaging::BitmapImage) -> HRESULT,
    fn SetContentFromBitmapImageWithAnchorPoint(&self, bitmapImage: *mut media::imaging::BitmapImage, anchorPoint: super::super::foundation::Point) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn SetContentFromSoftwareBitmap(&self, softwareBitmap: *mut super::super::graphics::imaging::SoftwareBitmap) -> HRESULT,
    #[cfg(feature="windows-graphics")] fn SetContentFromSoftwareBitmapWithAnchorPoint(&self, softwareBitmap: *mut super::super::graphics::imaging::SoftwareBitmap, anchorPoint: super::super::foundation::Point) -> HRESULT
}}
impl IDragUIOverride {
    #[inline] pub unsafe fn get_caption(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Caption)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_caption(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Caption)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_content_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsContentVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_content_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsContentVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_caption_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCaptionVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_caption_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCaptionVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_glyph_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGlyphVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_glyph_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsGlyphVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn clear(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Clear)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_from_bitmap_image(&self, bitmapImage: &media::imaging::BitmapImage) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromBitmapImage)(self as *const _ as *mut _, bitmapImage as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_from_bitmap_image_with_anchor_point(&self, bitmapImage: &media::imaging::BitmapImage, anchorPoint: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromBitmapImageWithAnchorPoint)(self as *const _ as *mut _, bitmapImage as *const _ as *mut _, anchorPoint);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn set_content_from_software_bitmap(&self, softwareBitmap: &super::super::graphics::imaging::SoftwareBitmap) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromSoftwareBitmap)(self as *const _ as *mut _, softwareBitmap as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-graphics")] #[inline] pub unsafe fn set_content_from_software_bitmap_with_anchor_point(&self, softwareBitmap: &super::super::graphics::imaging::SoftwareBitmap, anchorPoint: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).SetContentFromSoftwareBitmapWithAnchorPoint)(self as *const _ as *mut _, softwareBitmap as *const _ as *mut _, anchorPoint);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DragUIOverride: IDragUIOverride}
DEFINE_IID!(IID_IDropCompletedEventArgs, 1817166216, 38332, 16993, 158, 197, 33, 202, 182, 119, 183, 52);
RT_INTERFACE!{interface IDropCompletedEventArgs(IDropCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDropCompletedEventArgs] {
    #[cfg(feature="windows-applicationmodel")] fn get_DropResult(&self, out: *mut super::super::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT
}}
impl IDropCompletedEventArgs {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_drop_result(&self) -> Result<super::super::applicationmodel::datatransfer::DataPackageOperation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DropResult)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DropCompletedEventArgs: IDropCompletedEventArgs}
RT_STRUCT! { struct Duration {
    TimeSpan: super::super::foundation::TimeSpan, Type: DurationType,
}}
DEFINE_IID!(IID_IDurationHelper, 633431455, 17559, 16693, 148, 15, 238, 150, 244, 214, 233, 52);
RT_INTERFACE!{interface IDurationHelper(IDurationHelperVtbl): IInspectable(IInspectableVtbl) [IID_IDurationHelper] {
    
}}
RT_CLASS!{class DurationHelper: IDurationHelper}
impl RtActivatable<IDurationHelperStatics> for DurationHelper {}
impl DurationHelper {
    #[inline] pub fn get_automatic() -> Result<Duration> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().get_automatic()
    }}
    #[inline] pub fn get_forever() -> Result<Duration> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().get_forever()
    }}
    #[inline] pub fn compare(duration1: Duration, duration2: Duration) -> Result<i32> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().compare(duration1, duration2)
    }}
    #[inline] pub fn from_time_span(timeSpan: super::super::foundation::TimeSpan) -> Result<Duration> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().from_time_span(timeSpan)
    }}
    #[inline] pub fn get_has_time_span(target: Duration) -> Result<bool> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().get_has_time_span(target)
    }}
    #[inline] pub fn add(target: Duration, duration: Duration) -> Result<Duration> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().add(target, duration)
    }}
    #[inline] pub fn equals(target: Duration, value: Duration) -> Result<bool> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().equals(target, value)
    }}
    #[inline] pub fn subtract(target: Duration, duration: Duration) -> Result<Duration> { unsafe {
        <Self as RtActivatable<IDurationHelperStatics>>::get_activation_factory().subtract(target, duration)
    }}
}
DEFINE_CLSID!(DurationHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,68,117,114,97,116,105,111,110,72,101,108,112,101,114,0]) [CLSID_DurationHelper]);
DEFINE_IID!(IID_IDurationHelperStatics, 3163031870, 13639, 20160, 181, 25, 255, 168, 249, 196, 131, 140);
RT_INTERFACE!{static interface IDurationHelperStatics(IDurationHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDurationHelperStatics] {
    fn get_Automatic(&self, out: *mut Duration) -> HRESULT,
    fn get_Forever(&self, out: *mut Duration) -> HRESULT,
    fn Compare(&self, duration1: Duration, duration2: Duration, out: *mut i32) -> HRESULT,
    fn FromTimeSpan(&self, timeSpan: super::super::foundation::TimeSpan, out: *mut Duration) -> HRESULT,
    fn GetHasTimeSpan(&self, target: Duration, out: *mut bool) -> HRESULT,
    fn Add(&self, target: Duration, duration: Duration, out: *mut Duration) -> HRESULT,
    fn Equals(&self, target: Duration, value: Duration, out: *mut bool) -> HRESULT,
    fn Subtract(&self, target: Duration, duration: Duration, out: *mut Duration) -> HRESULT
}}
impl IDurationHelperStatics {
    #[inline] pub unsafe fn get_automatic(&self) -> Result<Duration> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Automatic)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_forever(&self) -> Result<Duration> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Forever)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn compare(&self, duration1: Duration, duration2: Duration) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Compare)(self as *const _ as *mut _, duration1, duration2, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_time_span(&self, timeSpan: super::super::foundation::TimeSpan) -> Result<Duration> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromTimeSpan)(self as *const _ as *mut _, timeSpan, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_has_time_span(&self, target: Duration) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetHasTimeSpan)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add(&self, target: Duration, duration: Duration) -> Result<Duration> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Add)(self as *const _ as *mut _, target, duration, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn equals(&self, target: Duration, value: Duration) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Equals)(self as *const _ as *mut _, target, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn subtract(&self, target: Duration, duration: Duration) -> Result<Duration> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Subtract)(self as *const _ as *mut _, target, duration, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum DurationType: i32 {
    Automatic (DurationType_Automatic) = 0, TimeSpan (DurationType_TimeSpan) = 1, Forever (DurationType_Forever) = 2,
}}
RT_ENUM! { enum ElementHighContrastAdjustment: u32 {
    None (ElementHighContrastAdjustment_None) = 0, Application (ElementHighContrastAdjustment_Application) = 2147483648, Auto (ElementHighContrastAdjustment_Auto) = 4294967295,
}}
RT_ENUM! { enum ElementSoundKind: i32 {
    Focus (ElementSoundKind_Focus) = 0, Invoke (ElementSoundKind_Invoke) = 1, Show (ElementSoundKind_Show) = 2, Hide (ElementSoundKind_Hide) = 3, MovePrevious (ElementSoundKind_MovePrevious) = 4, MoveNext (ElementSoundKind_MoveNext) = 5, GoBack (ElementSoundKind_GoBack) = 6,
}}
RT_ENUM! { enum ElementSoundMode: i32 {
    Default (ElementSoundMode_Default) = 0, FocusOnly (ElementSoundMode_FocusOnly) = 1, Off (ElementSoundMode_Off) = 2,
}}
DEFINE_IID!(IID_IElementSoundPlayer, 947352485, 61494, 17932, 155, 129, 243, 214, 234, 67, 246, 242);
RT_INTERFACE!{interface IElementSoundPlayer(IElementSoundPlayerVtbl): IInspectable(IInspectableVtbl) [IID_IElementSoundPlayer] {
    
}}
RT_CLASS!{class ElementSoundPlayer: IElementSoundPlayer}
impl RtActivatable<IElementSoundPlayerStatics> for ElementSoundPlayer {}
impl ElementSoundPlayer {
    #[inline] pub fn get_volume() -> Result<f64> { unsafe {
        <Self as RtActivatable<IElementSoundPlayerStatics>>::get_activation_factory().get_volume()
    }}
    #[inline] pub fn set_volume(value: f64) -> Result<()> { unsafe {
        <Self as RtActivatable<IElementSoundPlayerStatics>>::get_activation_factory().set_volume(value)
    }}
    #[inline] pub fn get_state() -> Result<ElementSoundPlayerState> { unsafe {
        <Self as RtActivatable<IElementSoundPlayerStatics>>::get_activation_factory().get_state()
    }}
    #[inline] pub fn set_state(value: ElementSoundPlayerState) -> Result<()> { unsafe {
        <Self as RtActivatable<IElementSoundPlayerStatics>>::get_activation_factory().set_state(value)
    }}
    #[inline] pub fn play(sound: ElementSoundKind) -> Result<()> { unsafe {
        <Self as RtActivatable<IElementSoundPlayerStatics>>::get_activation_factory().play(sound)
    }}
}
DEFINE_CLSID!(ElementSoundPlayer(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,69,108,101,109,101,110,116,83,111,117,110,100,80,108,97,121,101,114,0]) [CLSID_ElementSoundPlayer]);
RT_ENUM! { enum ElementSoundPlayerState: i32 {
    Auto (ElementSoundPlayerState_Auto) = 0, Off (ElementSoundPlayerState_Off) = 1, On (ElementSoundPlayerState_On) = 2,
}}
DEFINE_IID!(IID_IElementSoundPlayerStatics, 561680388, 38941, 16841, 177, 82, 173, 169, 17, 164, 177, 58);
RT_INTERFACE!{static interface IElementSoundPlayerStatics(IElementSoundPlayerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IElementSoundPlayerStatics] {
    fn get_Volume(&self, out: *mut f64) -> HRESULT,
    fn put_Volume(&self, value: f64) -> HRESULT,
    fn get_State(&self, out: *mut ElementSoundPlayerState) -> HRESULT,
    fn put_State(&self, value: ElementSoundPlayerState) -> HRESULT,
    fn Play(&self, sound: ElementSoundKind) -> HRESULT
}}
impl IElementSoundPlayerStatics {
    #[inline] pub unsafe fn get_volume(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Volume)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_volume(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Volume)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state(&self) -> Result<ElementSoundPlayerState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_State)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_state(&self, value: ElementSoundPlayerState) -> Result<()> {
        let hr = ((*self.lpVtbl).put_State)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn play(&self, sound: ElementSoundKind) -> Result<()> {
        let hr = ((*self.lpVtbl).Play)(self as *const _ as *mut _, sound);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum ElementTheme: i32 {
    Default (ElementTheme_Default) = 0, Light (ElementTheme_Light) = 1, Dark (ElementTheme_Dark) = 2,
}}
DEFINE_IID!(IID_EnteredBackgroundEventHandler, 2477348526, 7551, 17291, 183, 184, 34, 125, 150, 182, 9, 192);
RT_DELEGATE!{delegate EnteredBackgroundEventHandler(EnteredBackgroundEventHandlerVtbl, EnteredBackgroundEventHandlerImpl) [IID_EnteredBackgroundEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::super::applicationmodel::EnteredBackgroundEventArgs) -> HRESULT
}}
impl EnteredBackgroundEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::super::applicationmodel::EnteredBackgroundEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IEventTrigger, 3740858453, 2889, 16519, 177, 169, 184, 179, 132, 136, 247, 134);
RT_INTERFACE!{interface IEventTrigger(IEventTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IEventTrigger] {
    fn get_RoutedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn put_RoutedEvent(&self, value: *mut RoutedEvent) -> HRESULT,
    fn get_Actions(&self, out: *mut *mut TriggerActionCollection) -> HRESULT
}}
impl IEventTrigger {
    #[inline] pub unsafe fn get_routed_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RoutedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_routed_event(&self, value: &RoutedEvent) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RoutedEvent)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actions(&self) -> Result<ComPtr<TriggerActionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Actions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class EventTrigger: IEventTrigger}
impl RtActivatable<IActivationFactory> for EventTrigger {}
DEFINE_CLSID!(EventTrigger(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,69,118,101,110,116,84,114,105,103,103,101,114,0]) [CLSID_EventTrigger]);
DEFINE_IID!(IID_IExceptionRoutedEventArgs, 3718246762, 19298, 19052, 164, 157, 6, 113, 239, 97, 54, 190);
RT_INTERFACE!{interface IExceptionRoutedEventArgs(IExceptionRoutedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IExceptionRoutedEventArgs] {
    fn get_ErrorMessage(&self, out: *mut HSTRING) -> HRESULT
}}
impl IExceptionRoutedEventArgs {
    #[inline] pub unsafe fn get_error_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ErrorMessage)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ExceptionRoutedEventArgs: IExceptionRoutedEventArgs}
DEFINE_IID!(IID_IExceptionRoutedEventArgsFactory, 3148448365, 23930, 17639, 184, 147, 178, 174, 13, 210, 66, 115);
RT_INTERFACE!{interface IExceptionRoutedEventArgsFactory(IExceptionRoutedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IExceptionRoutedEventArgsFactory] {
    
}}
DEFINE_IID!(IID_ExceptionRoutedEventHandler, 1759569936, 63210, 17084, 133, 91, 93, 155, 103, 230, 162, 98);
RT_DELEGATE!{delegate ExceptionRoutedEventHandler(ExceptionRoutedEventHandlerVtbl, ExceptionRoutedEventHandlerImpl) [IID_ExceptionRoutedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut ExceptionRoutedEventArgs) -> HRESULT
}}
impl ExceptionRoutedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &ExceptionRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum FlowDirection: i32 {
    LeftToRight (FlowDirection_LeftToRight) = 0, RightToLeft (FlowDirection_RightToLeft) = 1,
}}
RT_ENUM! { enum FocusState: i32 {
    Unfocused (FocusState_Unfocused) = 0, Pointer (FocusState_Pointer) = 1, Keyboard (FocusState_Keyboard) = 2, Programmatic (FocusState_Programmatic) = 3,
}}
RT_ENUM! { enum FocusVisualKind: i32 {
    DottedLine (FocusVisualKind_DottedLine) = 0, HighVisibility (FocusVisualKind_HighVisibility) = 1,
}}
RT_ENUM! { enum FontCapitals: i32 {
    Normal (FontCapitals_Normal) = 0, AllSmallCaps (FontCapitals_AllSmallCaps) = 1, SmallCaps (FontCapitals_SmallCaps) = 2, AllPetiteCaps (FontCapitals_AllPetiteCaps) = 3, PetiteCaps (FontCapitals_PetiteCaps) = 4, Unicase (FontCapitals_Unicase) = 5, Titling (FontCapitals_Titling) = 6,
}}
RT_ENUM! { enum FontEastAsianLanguage: i32 {
    Normal (FontEastAsianLanguage_Normal) = 0, HojoKanji (FontEastAsianLanguage_HojoKanji) = 1, Jis04 (FontEastAsianLanguage_Jis04) = 2, Jis78 (FontEastAsianLanguage_Jis78) = 3, Jis83 (FontEastAsianLanguage_Jis83) = 4, Jis90 (FontEastAsianLanguage_Jis90) = 5, NlcKanji (FontEastAsianLanguage_NlcKanji) = 6, Simplified (FontEastAsianLanguage_Simplified) = 7, Traditional (FontEastAsianLanguage_Traditional) = 8, TraditionalNames (FontEastAsianLanguage_TraditionalNames) = 9,
}}
RT_ENUM! { enum FontEastAsianWidths: i32 {
    Normal (FontEastAsianWidths_Normal) = 0, Full (FontEastAsianWidths_Full) = 1, Half (FontEastAsianWidths_Half) = 2, Proportional (FontEastAsianWidths_Proportional) = 3, Quarter (FontEastAsianWidths_Quarter) = 4, Third (FontEastAsianWidths_Third) = 5,
}}
RT_ENUM! { enum FontFraction: i32 {
    Normal (FontFraction_Normal) = 0, Stacked (FontFraction_Stacked) = 1, Slashed (FontFraction_Slashed) = 2,
}}
RT_ENUM! { enum FontNumeralAlignment: i32 {
    Normal (FontNumeralAlignment_Normal) = 0, Proportional (FontNumeralAlignment_Proportional) = 1, Tabular (FontNumeralAlignment_Tabular) = 2,
}}
RT_ENUM! { enum FontNumeralStyle: i32 {
    Normal (FontNumeralStyle_Normal) = 0, Lining (FontNumeralStyle_Lining) = 1, OldStyle (FontNumeralStyle_OldStyle) = 2,
}}
RT_ENUM! { enum FontVariants: i32 {
    Normal (FontVariants_Normal) = 0, Superscript (FontVariants_Superscript) = 1, Subscript (FontVariants_Subscript) = 2, Ordinal (FontVariants_Ordinal) = 3, Inferior (FontVariants_Inferior) = 4, Ruby (FontVariants_Ruby) = 5,
}}
DEFINE_IID!(IID_IFrameworkElement, 2744242331, 19097, 19324, 157, 141, 111, 165, 208, 31, 111, 191);
RT_INTERFACE!{interface IFrameworkElement(IFrameworkElementVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElement] {
    fn get_Triggers(&self, out: *mut *mut TriggerCollection) -> HRESULT,
    fn get_Resources(&self, out: *mut *mut ResourceDictionary) -> HRESULT,
    fn put_Resources(&self, value: *mut ResourceDictionary) -> HRESULT,
    fn get_Tag(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Tag(&self, value: *mut IInspectable) -> HRESULT,
    fn get_Language(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Language(&self, value: HSTRING) -> HRESULT,
    fn get_ActualWidth(&self, out: *mut f64) -> HRESULT,
    fn get_ActualHeight(&self, out: *mut f64) -> HRESULT,
    fn get_Width(&self, out: *mut f64) -> HRESULT,
    fn put_Width(&self, value: f64) -> HRESULT,
    fn get_Height(&self, out: *mut f64) -> HRESULT,
    fn put_Height(&self, value: f64) -> HRESULT,
    fn get_MinWidth(&self, out: *mut f64) -> HRESULT,
    fn put_MinWidth(&self, value: f64) -> HRESULT,
    fn get_MaxWidth(&self, out: *mut f64) -> HRESULT,
    fn put_MaxWidth(&self, value: f64) -> HRESULT,
    fn get_MinHeight(&self, out: *mut f64) -> HRESULT,
    fn put_MinHeight(&self, value: f64) -> HRESULT,
    fn get_MaxHeight(&self, out: *mut f64) -> HRESULT,
    fn put_MaxHeight(&self, value: f64) -> HRESULT,
    fn get_HorizontalAlignment(&self, out: *mut HorizontalAlignment) -> HRESULT,
    fn put_HorizontalAlignment(&self, value: HorizontalAlignment) -> HRESULT,
    fn get_VerticalAlignment(&self, out: *mut VerticalAlignment) -> HRESULT,
    fn put_VerticalAlignment(&self, value: VerticalAlignment) -> HRESULT,
    fn get_Margin(&self, out: *mut Thickness) -> HRESULT,
    fn put_Margin(&self, value: Thickness) -> HRESULT,
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Name(&self, value: HSTRING) -> HRESULT,
    fn get_BaseUri(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn get_DataContext(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_DataContext(&self, value: *mut IInspectable) -> HRESULT,
    fn get_Style(&self, out: *mut *mut Style) -> HRESULT,
    fn put_Style(&self, value: *mut Style) -> HRESULT,
    fn get_Parent(&self, out: *mut *mut DependencyObject) -> HRESULT,
    fn get_FlowDirection(&self, out: *mut FlowDirection) -> HRESULT,
    fn put_FlowDirection(&self, value: FlowDirection) -> HRESULT,
    fn add_Loaded(&self, value: *mut RoutedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Loaded(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Unloaded(&self, value: *mut RoutedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Unloaded(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SizeChanged(&self, value: *mut SizeChangedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SizeChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_LayoutUpdated(&self, value: *mut super::super::foundation::EventHandler<IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LayoutUpdated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn FindName(&self, name: HSTRING, out: *mut *mut IInspectable) -> HRESULT,
    fn SetBinding(&self, dp: *mut DependencyProperty, binding: *mut data::BindingBase) -> HRESULT
}}
impl IFrameworkElement {
    #[inline] pub unsafe fn get_triggers(&self) -> Result<ComPtr<TriggerCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Triggers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_resources(&self) -> Result<ComPtr<ResourceDictionary>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Resources)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_resources(&self, value: &ResourceDictionary) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Resources)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tag(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Tag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tag(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Tag)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Language)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_language(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Language)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActualWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActualHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Width)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Width)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Height)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Height)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_alignment(&self) -> Result<HorizontalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HorizontalAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_horizontal_alignment(&self, value: HorizontalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HorizontalAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_alignment(&self) -> Result<VerticalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VerticalAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_vertical_alignment(&self, value: VerticalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VerticalAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_margin(&self) -> Result<Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Margin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_margin(&self, value: Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Margin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_name(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Name)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_base_uri(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BaseUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_context(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataContext)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_data_context(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DataContext)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_style(&self) -> Result<ComPtr<Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Style)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_style(&self, value: &Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Style)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_parent(&self) -> Result<ComPtr<DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Parent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flow_direction(&self) -> Result<FlowDirection> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FlowDirection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_flow_direction(&self, value: FlowDirection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FlowDirection)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_loaded(&self, value: &RoutedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Loaded)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_loaded(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Loaded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_unloaded(&self, value: &RoutedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Unloaded)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_unloaded(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Unloaded)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_size_changed(&self, value: &SizeChangedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SizeChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_size_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SizeChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_layout_updated(&self, value: &super::super::foundation::EventHandler<IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LayoutUpdated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_layout_updated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LayoutUpdated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_name(&self, name: &HStringArg) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindName)(self as *const _ as *mut _, name.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_binding(&self, dp: &DependencyProperty, binding: &data::BindingBase) -> Result<()> {
        let hr = ((*self.lpVtbl).SetBinding)(self as *const _ as *mut _, dp as *const _ as *mut _, binding as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FrameworkElement: IFrameworkElement}
impl RtActivatable<IFrameworkElementStatics> for FrameworkElement {}
impl RtActivatable<IFrameworkElementStatics2> for FrameworkElement {}
impl RtActivatable<IFrameworkElementStatics4> for FrameworkElement {}
impl RtActivatable<IFrameworkElementStatics5> for FrameworkElement {}
impl RtActivatable<IFrameworkElementStatics6> for FrameworkElement {}
impl FrameworkElement {
    #[inline] pub fn get_tag_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_tag_property()
    }}
    #[inline] pub fn get_language_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_language_property()
    }}
    #[inline] pub fn get_actual_width_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_actual_width_property()
    }}
    #[inline] pub fn get_actual_height_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_actual_height_property()
    }}
    #[inline] pub fn get_width_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_width_property()
    }}
    #[inline] pub fn get_height_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_height_property()
    }}
    #[inline] pub fn get_min_width_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_min_width_property()
    }}
    #[inline] pub fn get_max_width_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_max_width_property()
    }}
    #[inline] pub fn get_min_height_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_min_height_property()
    }}
    #[inline] pub fn get_max_height_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_max_height_property()
    }}
    #[inline] pub fn get_horizontal_alignment_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_horizontal_alignment_property()
    }}
    #[inline] pub fn get_vertical_alignment_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_vertical_alignment_property()
    }}
    #[inline] pub fn get_margin_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_margin_property()
    }}
    #[inline] pub fn get_name_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_name_property()
    }}
    #[inline] pub fn get_data_context_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_data_context_property()
    }}
    #[inline] pub fn get_style_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_style_property()
    }}
    #[inline] pub fn get_flow_direction_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics>>::get_activation_factory().get_flow_direction_property()
    }}
    #[inline] pub fn get_requested_theme_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics2>>::get_activation_factory().get_requested_theme_property()
    }}
    #[inline] pub fn get_allow_focus_on_interaction_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_allow_focus_on_interaction_property()
    }}
    #[inline] pub fn get_focus_visual_margin_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_focus_visual_margin_property()
    }}
    #[inline] pub fn get_focus_visual_secondary_thickness_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_focus_visual_secondary_thickness_property()
    }}
    #[inline] pub fn get_focus_visual_primary_thickness_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_focus_visual_primary_thickness_property()
    }}
    #[inline] pub fn get_focus_visual_secondary_brush_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_focus_visual_secondary_brush_property()
    }}
    #[inline] pub fn get_focus_visual_primary_brush_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_focus_visual_primary_brush_property()
    }}
    #[inline] pub fn get_allow_focus_when_disabled_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics4>>::get_activation_factory().get_allow_focus_when_disabled_property()
    }}
    #[inline] pub fn defer_tree(element: &DependencyObject) -> Result<()> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics5>>::get_activation_factory().defer_tree(element)
    }}
    #[inline] pub fn get_actual_theme_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameworkElementStatics6>>::get_activation_factory().get_actual_theme_property()
    }}
}
DEFINE_CLSID!(FrameworkElement(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,70,114,97,109,101,119,111,114,107,69,108,101,109,101,110,116,0]) [CLSID_FrameworkElement]);
DEFINE_IID!(IID_IFrameworkElement2, 4052812990, 16938, 18692, 165, 47, 238, 114, 1, 4, 41, 229);
RT_INTERFACE!{interface IFrameworkElement2(IFrameworkElement2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElement2] {
    fn get_RequestedTheme(&self, out: *mut ElementTheme) -> HRESULT,
    fn put_RequestedTheme(&self, value: ElementTheme) -> HRESULT,
    fn add_DataContextChanged(&self, value: *mut super::super::foundation::TypedEventHandler<FrameworkElement, DataContextChangedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DataContextChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn GetBindingExpression(&self, dp: *mut DependencyProperty, out: *mut *mut data::BindingExpression) -> HRESULT
}}
impl IFrameworkElement2 {
    #[inline] pub unsafe fn get_requested_theme(&self) -> Result<ElementTheme> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequestedTheme)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_requested_theme(&self, value: ElementTheme) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RequestedTheme)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_data_context_changed(&self, value: &super::super::foundation::TypedEventHandler<FrameworkElement, DataContextChangedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DataContextChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_data_context_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DataContextChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_binding_expression(&self, dp: &DependencyProperty) -> Result<ComPtr<data::BindingExpression>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetBindingExpression)(self as *const _ as *mut _, dp as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElement3, 3357288224, 23634, 19390, 161, 153, 43, 30, 52, 240, 15, 112);
RT_INTERFACE!{interface IFrameworkElement3(IFrameworkElement3Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElement3] {
    fn add_Loading(&self, value: *mut super::super::foundation::TypedEventHandler<FrameworkElement, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Loading(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IFrameworkElement3 {
    #[inline] pub unsafe fn add_loading(&self, value: &super::super::foundation::TypedEventHandler<FrameworkElement, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Loading)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_loading(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Loading)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElement4, 1802918835, 64419, 17412, 189, 238, 26, 69, 209, 202, 95, 33);
RT_INTERFACE!{interface IFrameworkElement4(IFrameworkElement4Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElement4] {
    fn get_AllowFocusOnInteraction(&self, out: *mut bool) -> HRESULT,
    fn put_AllowFocusOnInteraction(&self, value: bool) -> HRESULT,
    fn get_FocusVisualMargin(&self, out: *mut Thickness) -> HRESULT,
    fn put_FocusVisualMargin(&self, value: Thickness) -> HRESULT,
    fn get_FocusVisualSecondaryThickness(&self, out: *mut Thickness) -> HRESULT,
    fn put_FocusVisualSecondaryThickness(&self, value: Thickness) -> HRESULT,
    fn get_FocusVisualPrimaryThickness(&self, out: *mut Thickness) -> HRESULT,
    fn put_FocusVisualPrimaryThickness(&self, value: Thickness) -> HRESULT,
    fn get_FocusVisualSecondaryBrush(&self, out: *mut *mut media::Brush) -> HRESULT,
    fn put_FocusVisualSecondaryBrush(&self, value: *mut media::Brush) -> HRESULT,
    fn get_FocusVisualPrimaryBrush(&self, out: *mut *mut media::Brush) -> HRESULT,
    fn put_FocusVisualPrimaryBrush(&self, value: *mut media::Brush) -> HRESULT,
    fn get_AllowFocusWhenDisabled(&self, out: *mut bool) -> HRESULT,
    fn put_AllowFocusWhenDisabled(&self, value: bool) -> HRESULT
}}
impl IFrameworkElement4 {
    #[inline] pub unsafe fn get_allow_focus_on_interaction(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowFocusOnInteraction)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_focus_on_interaction(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowFocusOnInteraction)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_margin(&self) -> Result<Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusVisualMargin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_visual_margin(&self, value: Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusVisualMargin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_secondary_thickness(&self) -> Result<Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusVisualSecondaryThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_visual_secondary_thickness(&self, value: Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusVisualSecondaryThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_primary_thickness(&self) -> Result<Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusVisualPrimaryThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_visual_primary_thickness(&self, value: Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusVisualPrimaryThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_secondary_brush(&self) -> Result<ComPtr<media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualSecondaryBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_visual_secondary_brush(&self, value: &media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusVisualSecondaryBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_primary_brush(&self) -> Result<ComPtr<media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualPrimaryBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_visual_primary_brush(&self, value: &media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusVisualPrimaryBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_focus_when_disabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowFocusWhenDisabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_focus_when_disabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowFocusWhenDisabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElement6, 2032819601, 25249, 16575, 160, 206, 249, 193, 49, 252, 183, 167);
RT_INTERFACE!{interface IFrameworkElement6(IFrameworkElement6Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElement6] {
    fn get_ActualTheme(&self, out: *mut ElementTheme) -> HRESULT,
    fn add_ActualThemeChanged(&self, value: *mut super::super::foundation::TypedEventHandler<FrameworkElement, IInspectable>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ActualThemeChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IFrameworkElement6 {
    #[inline] pub unsafe fn get_actual_theme(&self) -> Result<ElementTheme> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActualTheme)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_actual_theme_changed(&self, value: &super::super::foundation::TypedEventHandler<FrameworkElement, IInspectable>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ActualThemeChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_actual_theme_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ActualThemeChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementFactory, 3736002854, 970, 18790, 181, 118, 96, 76, 206, 147, 181, 232);
RT_INTERFACE!{interface IFrameworkElementFactory(IFrameworkElementFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FrameworkElement) -> HRESULT
}}
impl IFrameworkElementFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FrameworkElement>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementOverrides, 3657465428, 46018, 19354, 170, 142, 211, 240, 113, 38, 43, 151);
RT_INTERFACE!{interface IFrameworkElementOverrides(IFrameworkElementOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementOverrides] {
    fn MeasureOverride(&self, availableSize: super::super::foundation::Size, out: *mut super::super::foundation::Size) -> HRESULT,
    fn ArrangeOverride(&self, finalSize: super::super::foundation::Size, out: *mut super::super::foundation::Size) -> HRESULT,
    fn OnApplyTemplate(&self) -> HRESULT
}}
impl IFrameworkElementOverrides {
    #[inline] pub unsafe fn measure_override(&self, availableSize: super::super::foundation::Size) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).MeasureOverride)(self as *const _ as *mut _, availableSize, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn arrange_override(&self, finalSize: super::super::foundation::Size) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ArrangeOverride)(self as *const _ as *mut _, finalSize, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_apply_template(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).OnApplyTemplate)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementOverrides2, 3411858105, 58292, 17804, 182, 78, 20, 52, 253, 27, 216, 138);
RT_INTERFACE!{interface IFrameworkElementOverrides2(IFrameworkElementOverrides2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementOverrides2] {
    fn GoToElementStateCore(&self, stateName: HSTRING, useTransitions: bool, out: *mut bool) -> HRESULT
}}
impl IFrameworkElementOverrides2 {
    #[inline] pub unsafe fn go_to_element_state_core(&self, stateName: &HStringArg, useTransitions: bool) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GoToElementStateCore)(self as *const _ as *mut _, stateName.get(), useTransitions, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementStatics, 1211641906, 64491, 20362, 174, 210, 238, 33, 251, 39, 165, 123);
RT_INTERFACE!{static interface IFrameworkElementStatics(IFrameworkElementStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementStatics] {
    fn get_TagProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_LanguageProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_ActualWidthProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_ActualHeightProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_WidthProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_HeightProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_MinWidthProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_MaxWidthProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_MinHeightProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_MaxHeightProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_HorizontalAlignmentProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_VerticalAlignmentProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_MarginProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_NameProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_DataContextProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_StyleProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_FlowDirectionProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IFrameworkElementStatics {
    #[inline] pub unsafe fn get_tag_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TagProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_language_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LanguageProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_width_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActualWidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_height_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActualHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_width_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_height_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_width_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinWidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_width_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxWidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_height_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_height_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_alignment_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HorizontalAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_alignment_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VerticalAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_margin_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MarginProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_name_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NameProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_data_context_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DataContextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_style_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flow_direction_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlowDirectionProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementStatics2, 2526403330, 49368, 20386, 177, 0, 63, 162, 223, 139, 149, 56);
RT_INTERFACE!{static interface IFrameworkElementStatics2(IFrameworkElementStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementStatics2] {
    fn get_RequestedThemeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IFrameworkElementStatics2 {
    #[inline] pub unsafe fn get_requested_theme_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RequestedThemeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementStatics4, 2621550933, 50648, 18019, 191, 242, 216, 213, 79, 181, 219, 179);
RT_INTERFACE!{static interface IFrameworkElementStatics4(IFrameworkElementStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementStatics4] {
    fn get_AllowFocusOnInteractionProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_FocusVisualMarginProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_FocusVisualSecondaryThicknessProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_FocusVisualPrimaryThicknessProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_FocusVisualSecondaryBrushProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_FocusVisualPrimaryBrushProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_AllowFocusWhenDisabledProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IFrameworkElementStatics4 {
    #[inline] pub unsafe fn get_allow_focus_on_interaction_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowFocusOnInteractionProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_margin_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualMarginProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_secondary_thickness_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualSecondaryThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_primary_thickness_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualPrimaryThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_secondary_brush_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualSecondaryBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_visual_primary_brush_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusVisualPrimaryBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_focus_when_disabled_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowFocusWhenDisabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementStatics5, 1381841217, 2876, 19430, 153, 120, 25, 168, 2, 92, 9, 216);
RT_INTERFACE!{static interface IFrameworkElementStatics5(IFrameworkElementStatics5Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementStatics5] {
    fn DeferTree(&self, element: *mut DependencyObject) -> HRESULT
}}
impl IFrameworkElementStatics5 {
    #[inline] pub unsafe fn defer_tree(&self, element: &DependencyObject) -> Result<()> {
        let hr = ((*self.lpVtbl).DeferTree)(self as *const _ as *mut _, element as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkElementStatics6, 4240528026, 27099, 17794, 167, 190, 207, 106, 28, 253, 172, 208);
RT_INTERFACE!{static interface IFrameworkElementStatics6(IFrameworkElementStatics6Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkElementStatics6] {
    fn get_ActualThemeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IFrameworkElementStatics6 {
    #[inline] pub unsafe fn get_actual_theme_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActualThemeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkTemplate, 2715964632, 42054, 18983, 154, 157, 160, 245, 158, 18, 88, 165);
RT_INTERFACE!{interface IFrameworkTemplate(IFrameworkTemplateVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkTemplate] {
    
}}
RT_CLASS!{class FrameworkTemplate: IFrameworkTemplate}
DEFINE_IID!(IID_IFrameworkTemplateFactory, 444113061, 37757, 18132, 131, 43, 148, 255, 20, 218, 176, 97);
RT_INTERFACE!{interface IFrameworkTemplateFactory(IFrameworkTemplateFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkTemplateFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FrameworkTemplate) -> HRESULT
}}
impl IFrameworkTemplateFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FrameworkTemplate>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameworkView, 3719980619, 46595, 18346, 148, 45, 56, 51, 23, 79, 13, 128);
RT_INTERFACE!{interface IFrameworkView(IFrameworkViewVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkView] {
    
}}
RT_CLASS!{class FrameworkView: IFrameworkView}
impl RtActivatable<IActivationFactory> for FrameworkView {}
DEFINE_CLSID!(FrameworkView(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,70,114,97,109,101,119,111,114,107,86,105,101,119,0]) [CLSID_FrameworkView]);
DEFINE_IID!(IID_IFrameworkViewSource, 3819993050, 13741, 19209, 181, 178, 39, 66, 0, 65, 186, 159);
RT_INTERFACE!{interface IFrameworkViewSource(IFrameworkViewSourceVtbl): IInspectable(IInspectableVtbl) [IID_IFrameworkViewSource] {
    
}}
RT_CLASS!{class FrameworkViewSource: IFrameworkViewSource}
impl RtActivatable<IActivationFactory> for FrameworkViewSource {}
DEFINE_CLSID!(FrameworkViewSource(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,70,114,97,109,101,119,111,114,107,86,105,101,119,83,111,117,114,99,101,0]) [CLSID_FrameworkViewSource]);
RT_STRUCT! { struct GridLength {
    Value: f64, GridUnitType: GridUnitType,
}}
DEFINE_IID!(IID_IGridLengthHelper, 2055367905, 1952, 16515, 182, 209, 177, 217, 23, 185, 118, 172);
RT_INTERFACE!{interface IGridLengthHelper(IGridLengthHelperVtbl): IInspectable(IInspectableVtbl) [IID_IGridLengthHelper] {
    
}}
RT_CLASS!{class GridLengthHelper: IGridLengthHelper}
impl RtActivatable<IGridLengthHelperStatics> for GridLengthHelper {}
impl GridLengthHelper {
    #[inline] pub fn get_auto() -> Result<GridLength> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().get_auto()
    }}
    #[inline] pub fn from_pixels(pixels: f64) -> Result<GridLength> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().from_pixels(pixels)
    }}
    #[inline] pub fn from_value_and_type(value: f64, type_: GridUnitType) -> Result<GridLength> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().from_value_and_type(value, type_)
    }}
    #[inline] pub fn get_is_absolute(target: GridLength) -> Result<bool> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().get_is_absolute(target)
    }}
    #[inline] pub fn get_is_auto(target: GridLength) -> Result<bool> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().get_is_auto(target)
    }}
    #[inline] pub fn get_is_star(target: GridLength) -> Result<bool> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().get_is_star(target)
    }}
    #[inline] pub fn equals(target: GridLength, value: GridLength) -> Result<bool> { unsafe {
        <Self as RtActivatable<IGridLengthHelperStatics>>::get_activation_factory().equals(target, value)
    }}
}
DEFINE_CLSID!(GridLengthHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,71,114,105,100,76,101,110,103,116,104,72,101,108,112,101,114,0]) [CLSID_GridLengthHelper]);
DEFINE_IID!(IID_IGridLengthHelperStatics, 2638576539, 415, 16998, 136, 114, 33, 95, 25, 143, 106, 157);
RT_INTERFACE!{static interface IGridLengthHelperStatics(IGridLengthHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGridLengthHelperStatics] {
    fn get_Auto(&self, out: *mut GridLength) -> HRESULT,
    fn FromPixels(&self, pixels: f64, out: *mut GridLength) -> HRESULT,
    fn FromValueAndType(&self, value: f64, type_: GridUnitType, out: *mut GridLength) -> HRESULT,
    fn GetIsAbsolute(&self, target: GridLength, out: *mut bool) -> HRESULT,
    fn GetIsAuto(&self, target: GridLength, out: *mut bool) -> HRESULT,
    fn GetIsStar(&self, target: GridLength, out: *mut bool) -> HRESULT,
    fn Equals(&self, target: GridLength, value: GridLength, out: *mut bool) -> HRESULT
}}
impl IGridLengthHelperStatics {
    #[inline] pub unsafe fn get_auto(&self) -> Result<GridLength> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Auto)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_pixels(&self, pixels: f64) -> Result<GridLength> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromPixels)(self as *const _ as *mut _, pixels, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_value_and_type(&self, value: f64, type_: GridUnitType) -> Result<GridLength> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromValueAndType)(self as *const _ as *mut _, value, type_, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_absolute(&self, target: GridLength) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsAbsolute)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_auto(&self, target: GridLength) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsAuto)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_star(&self, target: GridLength) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsStar)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn equals(&self, target: GridLength, value: GridLength) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Equals)(self as *const _ as *mut _, target, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_ENUM! { enum GridUnitType: i32 {
    Auto (GridUnitType_Auto) = 0, Pixel (GridUnitType_Pixel) = 1, Star (GridUnitType_Star) = 2,
}}
RT_ENUM! { enum HorizontalAlignment: i32 {
    Left (HorizontalAlignment_Left) = 0, Center (HorizontalAlignment_Center) = 1, Right (HorizontalAlignment_Right) = 2, Stretch (HorizontalAlignment_Stretch) = 3,
}}
DEFINE_IID!(IID_LeavingBackgroundEventHandler, 2863488429, 20422, 19108, 183, 207, 135, 126, 54, 173, 164, 246);
RT_DELEGATE!{delegate LeavingBackgroundEventHandler(LeavingBackgroundEventHandlerVtbl, LeavingBackgroundEventHandlerImpl) [IID_LeavingBackgroundEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::super::applicationmodel::LeavingBackgroundEventArgs) -> HRESULT
}}
impl LeavingBackgroundEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::super::applicationmodel::LeavingBackgroundEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum LineStackingStrategy: i32 {
    MaxHeight (LineStackingStrategy_MaxHeight) = 0, BlockLineHeight (LineStackingStrategy_BlockLineHeight) = 1, BaselineToBaseline (LineStackingStrategy_BaselineToBaseline) = 2,
}}
DEFINE_IID!(IID_IMediaFailedRoutedEventArgs, 1188166285, 20809, 16723, 186, 60, 176, 62, 100, 238, 83, 30);
RT_INTERFACE!{interface IMediaFailedRoutedEventArgs(IMediaFailedRoutedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IMediaFailedRoutedEventArgs] {
    fn get_ErrorTrace(&self, out: *mut HSTRING) -> HRESULT
}}
impl IMediaFailedRoutedEventArgs {
    #[inline] pub unsafe fn get_error_trace(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ErrorTrace)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class MediaFailedRoutedEventArgs: IMediaFailedRoutedEventArgs}
RT_ENUM! { enum OpticalMarginAlignment: i32 {
    None (OpticalMarginAlignment_None) = 0, TrimSideBearings (OpticalMarginAlignment_TrimSideBearings) = 1,
}}
DEFINE_IID!(IID_IPointHelper, 1920720274, 25776, 18895, 163, 33, 169, 121, 62, 115, 226, 231);
RT_INTERFACE!{interface IPointHelper(IPointHelperVtbl): IInspectable(IInspectableVtbl) [IID_IPointHelper] {
    
}}
RT_CLASS!{class PointHelper: IPointHelper}
impl RtActivatable<IPointHelperStatics> for PointHelper {}
impl PointHelper {
    #[inline] pub fn from_coordinates(x: f32, y: f32) -> Result<super::super::foundation::Point> { unsafe {
        <Self as RtActivatable<IPointHelperStatics>>::get_activation_factory().from_coordinates(x, y)
    }}
}
DEFINE_CLSID!(PointHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,80,111,105,110,116,72,101,108,112,101,114,0]) [CLSID_PointHelper]);
DEFINE_IID!(IID_IPointHelperStatics, 22727285, 30424, 19326, 138, 51, 125, 121, 32, 70, 145, 238);
RT_INTERFACE!{static interface IPointHelperStatics(IPointHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPointHelperStatics] {
    fn FromCoordinates(&self, x: f32, y: f32, out: *mut super::super::foundation::Point) -> HRESULT
}}
impl IPointHelperStatics {
    #[inline] pub unsafe fn from_coordinates(&self, x: f32, y: f32) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromCoordinates)(self as *const _ as *mut _, x, y, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_PropertyChangedCallback, 1520405029, 53570, 17572, 130, 49, 253, 103, 103, 36, 242, 155);
RT_DELEGATE!{delegate PropertyChangedCallback(PropertyChangedCallbackVtbl, PropertyChangedCallbackImpl) [IID_PropertyChangedCallback] {
    fn Invoke(&self, d: *mut DependencyObject, e: *mut DependencyPropertyChangedEventArgs) -> HRESULT
}}
impl PropertyChangedCallback {
    #[inline] pub unsafe fn invoke(&self, d: &DependencyObject, e: &DependencyPropertyChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, d as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPropertyMetadata, 2169434893, 36120, 17546, 134, 68, 242, 203, 81, 231, 3, 128);
RT_INTERFACE!{interface IPropertyMetadata(IPropertyMetadataVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyMetadata] {
    fn get_DefaultValue(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_CreateDefaultValueCallback(&self, out: *mut *mut CreateDefaultValueCallback) -> HRESULT
}}
impl IPropertyMetadata {
    #[inline] pub unsafe fn get_default_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_create_default_value_callback(&self) -> Result<ComPtr<CreateDefaultValueCallback>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CreateDefaultValueCallback)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PropertyMetadata: IPropertyMetadata}
impl RtActivatable<IPropertyMetadataStatics> for PropertyMetadata {}
impl PropertyMetadata {
    #[inline] pub fn create_with_default_value(defaultValue: &IInspectable) -> Result<ComPtr<PropertyMetadata>> { unsafe {
        <Self as RtActivatable<IPropertyMetadataStatics>>::get_activation_factory().create_with_default_value(defaultValue)
    }}
    #[inline] pub fn create_with_default_value_and_callback(defaultValue: &IInspectable, propertyChangedCallback: &PropertyChangedCallback) -> Result<ComPtr<PropertyMetadata>> { unsafe {
        <Self as RtActivatable<IPropertyMetadataStatics>>::get_activation_factory().create_with_default_value_and_callback(defaultValue, propertyChangedCallback)
    }}
    #[inline] pub fn create_with_factory(createDefaultValueCallback: &CreateDefaultValueCallback) -> Result<ComPtr<PropertyMetadata>> { unsafe {
        <Self as RtActivatable<IPropertyMetadataStatics>>::get_activation_factory().create_with_factory(createDefaultValueCallback)
    }}
    #[inline] pub fn create_with_factory_and_callback(createDefaultValueCallback: &CreateDefaultValueCallback, propertyChangedCallback: &PropertyChangedCallback) -> Result<ComPtr<PropertyMetadata>> { unsafe {
        <Self as RtActivatable<IPropertyMetadataStatics>>::get_activation_factory().create_with_factory_and_callback(createDefaultValueCallback, propertyChangedCallback)
    }}
}
DEFINE_CLSID!(PropertyMetadata(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,80,114,111,112,101,114,116,121,77,101,116,97,100,97,116,97,0]) [CLSID_PropertyMetadata]);
DEFINE_IID!(IID_IPropertyMetadataFactory, 3250068672, 22477, 20271, 176, 169, 225, 128, 27, 40, 247, 107);
RT_INTERFACE!{interface IPropertyMetadataFactory(IPropertyMetadataFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyMetadataFactory] {
    fn CreateInstanceWithDefaultValue(&self, defaultValue: *mut IInspectable, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut PropertyMetadata) -> HRESULT,
    fn CreateInstanceWithDefaultValueAndCallback(&self, defaultValue: *mut IInspectable, propertyChangedCallback: *mut PropertyChangedCallback, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut PropertyMetadata) -> HRESULT
}}
impl IPropertyMetadataFactory {
    #[inline] pub unsafe fn create_instance_with_default_value(&self, defaultValue: &IInspectable, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<PropertyMetadata>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstanceWithDefaultValue)(self as *const _ as *mut _, defaultValue as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_instance_with_default_value_and_callback(&self, defaultValue: &IInspectable, propertyChangedCallback: &PropertyChangedCallback, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<PropertyMetadata>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstanceWithDefaultValueAndCallback)(self as *const _ as *mut _, defaultValue as *const _ as *mut _, propertyChangedCallback as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPropertyMetadataStatics, 989923194, 28166, 17897, 139, 92, 175, 36, 52, 88, 192, 98);
RT_INTERFACE!{static interface IPropertyMetadataStatics(IPropertyMetadataStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyMetadataStatics] {
    fn CreateWithDefaultValue(&self, defaultValue: *mut IInspectable, out: *mut *mut PropertyMetadata) -> HRESULT,
    fn CreateWithDefaultValueAndCallback(&self, defaultValue: *mut IInspectable, propertyChangedCallback: *mut PropertyChangedCallback, out: *mut *mut PropertyMetadata) -> HRESULT,
    fn CreateWithFactory(&self, createDefaultValueCallback: *mut CreateDefaultValueCallback, out: *mut *mut PropertyMetadata) -> HRESULT,
    fn CreateWithFactoryAndCallback(&self, createDefaultValueCallback: *mut CreateDefaultValueCallback, propertyChangedCallback: *mut PropertyChangedCallback, out: *mut *mut PropertyMetadata) -> HRESULT
}}
impl IPropertyMetadataStatics {
    #[inline] pub unsafe fn create_with_default_value(&self, defaultValue: &IInspectable) -> Result<ComPtr<PropertyMetadata>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithDefaultValue)(self as *const _ as *mut _, defaultValue as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_default_value_and_callback(&self, defaultValue: &IInspectable, propertyChangedCallback: &PropertyChangedCallback) -> Result<ComPtr<PropertyMetadata>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithDefaultValueAndCallback)(self as *const _ as *mut _, defaultValue as *const _ as *mut _, propertyChangedCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_factory(&self, createDefaultValueCallback: &CreateDefaultValueCallback) -> Result<ComPtr<PropertyMetadata>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithFactory)(self as *const _ as *mut _, createDefaultValueCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn create_with_factory_and_callback(&self, createDefaultValueCallback: &CreateDefaultValueCallback, propertyChangedCallback: &PropertyChangedCallback) -> Result<ComPtr<PropertyMetadata>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateWithFactoryAndCallback)(self as *const _ as *mut _, createDefaultValueCallback as *const _ as *mut _, propertyChangedCallback as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IPropertyPath, 806247818, 8179, 19756, 149, 236, 39, 248, 29, 235, 172, 184);
RT_INTERFACE!{interface IPropertyPath(IPropertyPathVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyPath] {
    fn get_Path(&self, out: *mut HSTRING) -> HRESULT
}}
impl IPropertyPath {
    #[inline] pub unsafe fn get_path(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Path)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class PropertyPath: IPropertyPath}
impl RtActivatable<IPropertyPathFactory> for PropertyPath {}
impl PropertyPath {
    #[inline] pub fn create_instance(path: &HStringArg) -> Result<ComPtr<PropertyPath>> { unsafe {
        <Self as RtActivatable<IPropertyPathFactory>>::get_activation_factory().create_instance(path)
    }}
}
DEFINE_CLSID!(PropertyPath(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,80,114,111,112,101,114,116,121,80,97,116,104,0]) [CLSID_PropertyPath]);
DEFINE_IID!(IID_IPropertyPathFactory, 1313660825, 38950, 20054, 132, 124, 202, 5, 95, 22, 41, 5);
RT_INTERFACE!{static interface IPropertyPathFactory(IPropertyPathFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IPropertyPathFactory] {
    fn CreateInstance(&self, path: HSTRING, out: *mut *mut PropertyPath) -> HRESULT
}}
impl IPropertyPathFactory {
    #[inline] pub unsafe fn create_instance(&self, path: &HStringArg) -> Result<ComPtr<PropertyPath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, path.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRectHelper, 2743566818, 19451, 20194, 175, 229, 137, 243, 27, 55, 71, 141);
RT_INTERFACE!{interface IRectHelper(IRectHelperVtbl): IInspectable(IInspectableVtbl) [IID_IRectHelper] {
    
}}
RT_CLASS!{class RectHelper: IRectHelper}
impl RtActivatable<IRectHelperStatics> for RectHelper {}
impl RectHelper {
    #[inline] pub fn get_empty() -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().get_empty()
    }}
    #[inline] pub fn from_coordinates_and_dimensions(x: f32, y: f32, width: f32, height: f32) -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().from_coordinates_and_dimensions(x, y, width, height)
    }}
    #[inline] pub fn from_points(point1: super::super::foundation::Point, point2: super::super::foundation::Point) -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().from_points(point1, point2)
    }}
    #[inline] pub fn from_location_and_size(location: super::super::foundation::Point, size: super::super::foundation::Size) -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().from_location_and_size(location, size)
    }}
    #[inline] pub fn get_is_empty(target: super::super::foundation::Rect) -> Result<bool> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().get_is_empty(target)
    }}
    #[inline] pub fn get_bottom(target: super::super::foundation::Rect) -> Result<f32> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().get_bottom(target)
    }}
    #[inline] pub fn get_left(target: super::super::foundation::Rect) -> Result<f32> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().get_left(target)
    }}
    #[inline] pub fn get_right(target: super::super::foundation::Rect) -> Result<f32> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().get_right(target)
    }}
    #[inline] pub fn get_top(target: super::super::foundation::Rect) -> Result<f32> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().get_top(target)
    }}
    #[inline] pub fn contains(target: super::super::foundation::Rect, point: super::super::foundation::Point) -> Result<bool> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().contains(target, point)
    }}
    #[inline] pub fn equals(target: super::super::foundation::Rect, value: super::super::foundation::Rect) -> Result<bool> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().equals(target, value)
    }}
    #[inline] pub fn intersect(target: super::super::foundation::Rect, rect: super::super::foundation::Rect) -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().intersect(target, rect)
    }}
    #[inline] pub fn union_with_point(target: super::super::foundation::Rect, point: super::super::foundation::Point) -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().union_with_point(target, point)
    }}
    #[inline] pub fn union_with_rect(target: super::super::foundation::Rect, rect: super::super::foundation::Rect) -> Result<super::super::foundation::Rect> { unsafe {
        <Self as RtActivatable<IRectHelperStatics>>::get_activation_factory().union_with_rect(target, rect)
    }}
}
DEFINE_CLSID!(RectHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,82,101,99,116,72,101,108,112,101,114,0]) [CLSID_RectHelper]);
DEFINE_IID!(IID_IRectHelperStatics, 1591829476, 49534, 18767, 181, 128, 47, 5, 116, 252, 58, 21);
RT_INTERFACE!{static interface IRectHelperStatics(IRectHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IRectHelperStatics] {
    fn get_Empty(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn FromCoordinatesAndDimensions(&self, x: f32, y: f32, width: f32, height: f32, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn FromPoints(&self, point1: super::super::foundation::Point, point2: super::super::foundation::Point, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn FromLocationAndSize(&self, location: super::super::foundation::Point, size: super::super::foundation::Size, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn GetIsEmpty(&self, target: super::super::foundation::Rect, out: *mut bool) -> HRESULT,
    fn GetBottom(&self, target: super::super::foundation::Rect, out: *mut f32) -> HRESULT,
    fn GetLeft(&self, target: super::super::foundation::Rect, out: *mut f32) -> HRESULT,
    fn GetRight(&self, target: super::super::foundation::Rect, out: *mut f32) -> HRESULT,
    fn GetTop(&self, target: super::super::foundation::Rect, out: *mut f32) -> HRESULT,
    fn Contains(&self, target: super::super::foundation::Rect, point: super::super::foundation::Point, out: *mut bool) -> HRESULT,
    fn Equals(&self, target: super::super::foundation::Rect, value: super::super::foundation::Rect, out: *mut bool) -> HRESULT,
    fn Intersect(&self, target: super::super::foundation::Rect, rect: super::super::foundation::Rect, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn UnionWithPoint(&self, target: super::super::foundation::Rect, point: super::super::foundation::Point, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn UnionWithRect(&self, target: super::super::foundation::Rect, rect: super::super::foundation::Rect, out: *mut super::super::foundation::Rect) -> HRESULT
}}
impl IRectHelperStatics {
    #[inline] pub unsafe fn get_empty(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Empty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_coordinates_and_dimensions(&self, x: f32, y: f32, width: f32, height: f32) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromCoordinatesAndDimensions)(self as *const _ as *mut _, x, y, width, height, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_points(&self, point1: super::super::foundation::Point, point2: super::super::foundation::Point) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromPoints)(self as *const _ as *mut _, point1, point2, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_location_and_size(&self, location: super::super::foundation::Point, size: super::super::foundation::Size) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromLocationAndSize)(self as *const _ as *mut _, location, size, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_empty(&self, target: super::super::foundation::Rect) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsEmpty)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_bottom(&self, target: super::super::foundation::Rect) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetBottom)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left(&self, target: super::super::foundation::Rect) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetLeft)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right(&self, target: super::super::foundation::Rect) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetRight)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_top(&self, target: super::super::foundation::Rect) -> Result<f32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetTop)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn contains(&self, target: super::super::foundation::Rect, point: super::super::foundation::Point) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Contains)(self as *const _ as *mut _, target, point, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn equals(&self, target: super::super::foundation::Rect, value: super::super::foundation::Rect) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Equals)(self as *const _ as *mut _, target, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn intersect(&self, target: super::super::foundation::Rect, rect: super::super::foundation::Rect) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Intersect)(self as *const _ as *mut _, target, rect, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn union_with_point(&self, target: super::super::foundation::Rect, point: super::super::foundation::Point) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).UnionWithPoint)(self as *const _ as *mut _, target, point, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn union_with_rect(&self, target: super::super::foundation::Rect, rect: super::super::foundation::Rect) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).UnionWithRect)(self as *const _ as *mut _, target, rect, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IResourceDictionary, 3253358372, 55006, 16785, 142, 58, 244, 134, 1, 247, 72, 156);
RT_INTERFACE!{interface IResourceDictionary(IResourceDictionaryVtbl): IInspectable(IInspectableVtbl) [IID_IResourceDictionary] {
    fn get_Source(&self, out: *mut *mut super::super::foundation::Uri) -> HRESULT,
    fn put_Source(&self, value: *mut super::super::foundation::Uri) -> HRESULT,
    fn get_MergedDictionaries(&self, out: *mut *mut super::super::foundation::collections::IVector<ResourceDictionary>) -> HRESULT,
    fn get_ThemeDictionaries(&self, out: *mut *mut super::super::foundation::collections::IMap<IInspectable, IInspectable>) -> HRESULT
}}
impl IResourceDictionary {
    #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<super::super::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source(&self, value: &super::super::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Source)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_merged_dictionaries(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<ResourceDictionary>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MergedDictionaries)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_theme_dictionaries(&self) -> Result<ComPtr<super::super::foundation::collections::IMap<IInspectable, IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ThemeDictionaries)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ResourceDictionary: IResourceDictionary}
DEFINE_IID!(IID_IResourceDictionaryFactory, 3929422261, 12727, 17009, 146, 201, 124, 149, 132, 169, 28, 34);
RT_INTERFACE!{interface IResourceDictionaryFactory(IResourceDictionaryFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IResourceDictionaryFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ResourceDictionary) -> HRESULT
}}
impl IResourceDictionaryFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ResourceDictionary>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IRoutedEvent, 2796705816, 17345, 19568, 134, 92, 123, 221, 90, 50, 227, 39);
RT_INTERFACE!{interface IRoutedEvent(IRoutedEventVtbl): IInspectable(IInspectableVtbl) [IID_IRoutedEvent] {
    
}}
RT_CLASS!{class RoutedEvent: IRoutedEvent}
DEFINE_IID!(IID_IRoutedEventArgs, 1553488582, 55298, 19256, 162, 35, 191, 7, 12, 67, 254, 223);
RT_INTERFACE!{interface IRoutedEventArgs(IRoutedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IRoutedEventArgs] {
    fn get_OriginalSource(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IRoutedEventArgs {
    #[inline] pub unsafe fn get_original_source(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OriginalSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class RoutedEventArgs: IRoutedEventArgs}
DEFINE_IID!(IID_IRoutedEventArgsFactory, 3055308167, 28901, 16686, 181, 32, 26, 65, 238, 118, 187, 244);
RT_INTERFACE!{interface IRoutedEventArgsFactory(IRoutedEventArgsFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IRoutedEventArgsFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut RoutedEventArgs) -> HRESULT
}}
impl IRoutedEventArgsFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<RoutedEventArgs>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_RoutedEventHandler, 2824267380, 45238, 19395, 187, 168, 27, 160, 110, 64, 212, 181);
RT_DELEGATE!{delegate RoutedEventHandler(RoutedEventHandlerVtbl, RoutedEventHandlerImpl) [IID_RoutedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut RoutedEventArgs) -> HRESULT
}}
impl RoutedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &RoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISetter, 2805853481, 46254, 19073, 190, 133, 230, 144, 186, 13, 59, 110);
RT_INTERFACE!{interface ISetter(ISetterVtbl): IInspectable(IInspectableVtbl) [IID_ISetter] {
    fn get_Property(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn put_Property(&self, value: *mut DependencyProperty) -> HRESULT,
    fn get_Value(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Value(&self, value: *mut IInspectable) -> HRESULT
}}
impl ISetter {
    #[inline] pub unsafe fn get_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Property)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_property(&self, value: &DependencyProperty) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Property)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_value(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Value)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Setter: ISetter}
impl RtActivatable<ISetterFactory> for Setter {}
impl RtActivatable<IActivationFactory> for Setter {}
impl Setter {
    #[inline] pub fn create_instance(targetProperty: &DependencyProperty, value: &IInspectable) -> Result<ComPtr<Setter>> { unsafe {
        <Self as RtActivatable<ISetterFactory>>::get_activation_factory().create_instance(targetProperty, value)
    }}
}
DEFINE_CLSID!(Setter(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,83,101,116,116,101,114,0]) [CLSID_Setter]);
DEFINE_IID!(IID_ISetter2, 1880528225, 1457, 20387, 157, 83, 142, 12, 140, 116, 122, 252);
RT_INTERFACE!{interface ISetter2(ISetter2Vtbl): IInspectable(IInspectableVtbl) [IID_ISetter2] {
    fn get_Target(&self, out: *mut *mut TargetPropertyPath) -> HRESULT,
    fn put_Target(&self, value: *mut TargetPropertyPath) -> HRESULT
}}
impl ISetter2 {
    #[inline] pub unsafe fn get_target(&self) -> Result<ComPtr<TargetPropertyPath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Target)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target(&self, value: &TargetPropertyPath) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Target)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISetterBase, 1099686524, 10948, 20258, 128, 151, 222, 163, 174, 235, 47, 179);
RT_INTERFACE!{interface ISetterBase(ISetterBaseVtbl): IInspectable(IInspectableVtbl) [IID_ISetterBase] {
    fn get_IsSealed(&self, out: *mut bool) -> HRESULT
}}
impl ISetterBase {
    #[inline] pub unsafe fn get_is_sealed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSealed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SetterBase: ISetterBase}
DEFINE_IID!(IID_ISetterBaseCollection, 63179944, 37022, 16663, 129, 28, 164, 82, 148, 150, 189, 241);
RT_INTERFACE!{interface ISetterBaseCollection(ISetterBaseCollectionVtbl): IInspectable(IInspectableVtbl) [IID_ISetterBaseCollection] {
    fn get_IsSealed(&self, out: *mut bool) -> HRESULT
}}
impl ISetterBaseCollection {
    #[inline] pub unsafe fn get_is_sealed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSealed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SetterBaseCollection: ISetterBaseCollection}
impl RtActivatable<IActivationFactory> for SetterBaseCollection {}
DEFINE_CLSID!(SetterBaseCollection(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,83,101,116,116,101,114,66,97,115,101,67,111,108,108,101,99,116,105,111,110,0]) [CLSID_SetterBaseCollection]);
DEFINE_IID!(IID_ISetterBaseFactory, 2180558176, 7400, 18077, 166, 103, 22, 227, 124, 239, 139, 169);
RT_INTERFACE!{interface ISetterBaseFactory(ISetterBaseFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISetterBaseFactory] {
    
}}
DEFINE_IID!(IID_ISetterFactory, 3553246530, 2481, 18901, 136, 145, 231, 181, 100, 142, 2, 162);
RT_INTERFACE!{static interface ISetterFactory(ISetterFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ISetterFactory] {
    fn CreateInstance(&self, targetProperty: *mut DependencyProperty, value: *mut IInspectable, out: *mut *mut Setter) -> HRESULT
}}
impl ISetterFactory {
    #[inline] pub unsafe fn create_instance(&self, targetProperty: &DependencyProperty, value: &IInspectable) -> Result<ComPtr<Setter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, targetProperty as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISizeChangedEventArgs, 3576770144, 23745, 17057, 146, 12, 26, 244, 107, 226, 249, 134);
RT_INTERFACE!{interface ISizeChangedEventArgs(ISizeChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ISizeChangedEventArgs] {
    fn get_PreviousSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_NewSize(&self, out: *mut super::super::foundation::Size) -> HRESULT
}}
impl ISizeChangedEventArgs {
    #[inline] pub unsafe fn get_previous_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_PreviousSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class SizeChangedEventArgs: ISizeChangedEventArgs}
DEFINE_IID!(IID_SizeChangedEventHandler, 286634300, 9682, 18443, 137, 220, 235, 61, 203, 214, 183, 250);
RT_DELEGATE!{delegate SizeChangedEventHandler(SizeChangedEventHandlerVtbl, SizeChangedEventHandlerImpl) [IID_SizeChangedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut SizeChangedEventArgs) -> HRESULT
}}
impl SizeChangedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &SizeChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ISizeHelper, 3877788308, 23811, 18947, 186, 148, 150, 127, 198, 143, 206, 254);
RT_INTERFACE!{interface ISizeHelper(ISizeHelperVtbl): IInspectable(IInspectableVtbl) [IID_ISizeHelper] {
    
}}
RT_CLASS!{class SizeHelper: ISizeHelper}
impl RtActivatable<ISizeHelperStatics> for SizeHelper {}
impl SizeHelper {
    #[inline] pub fn get_empty() -> Result<super::super::foundation::Size> { unsafe {
        <Self as RtActivatable<ISizeHelperStatics>>::get_activation_factory().get_empty()
    }}
    #[inline] pub fn from_dimensions(width: f32, height: f32) -> Result<super::super::foundation::Size> { unsafe {
        <Self as RtActivatable<ISizeHelperStatics>>::get_activation_factory().from_dimensions(width, height)
    }}
    #[inline] pub fn get_is_empty(target: super::super::foundation::Size) -> Result<bool> { unsafe {
        <Self as RtActivatable<ISizeHelperStatics>>::get_activation_factory().get_is_empty(target)
    }}
    #[inline] pub fn equals(target: super::super::foundation::Size, value: super::super::foundation::Size) -> Result<bool> { unsafe {
        <Self as RtActivatable<ISizeHelperStatics>>::get_activation_factory().equals(target, value)
    }}
}
DEFINE_CLSID!(SizeHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,83,105,122,101,72,101,108,112,101,114,0]) [CLSID_SizeHelper]);
DEFINE_IID!(IID_ISizeHelperStatics, 1652999602, 53112, 18709, 170, 64, 118, 0, 74, 22, 95, 94);
RT_INTERFACE!{static interface ISizeHelperStatics(ISizeHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ISizeHelperStatics] {
    fn get_Empty(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn FromDimensions(&self, width: f32, height: f32, out: *mut super::super::foundation::Size) -> HRESULT,
    fn GetIsEmpty(&self, target: super::super::foundation::Size, out: *mut bool) -> HRESULT,
    fn Equals(&self, target: super::super::foundation::Size, value: super::super::foundation::Size, out: *mut bool) -> HRESULT
}}
impl ISizeHelperStatics {
    #[inline] pub unsafe fn get_empty(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Empty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_dimensions(&self, width: f32, height: f32) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromDimensions)(self as *const _ as *mut _, width, height, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_empty(&self, target: super::super::foundation::Size) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsEmpty)(self as *const _ as *mut _, target, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn equals(&self, target: super::super::foundation::Size, value: super::super::foundation::Size) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Equals)(self as *const _ as *mut _, target, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IStateTrigger, 1739452206, 55513, 18935, 161, 253, 46, 53, 238, 221, 35, 205);
RT_INTERFACE!{interface IStateTrigger(IStateTriggerVtbl): IInspectable(IInspectableVtbl) [IID_IStateTrigger] {
    fn get_IsActive(&self, out: *mut bool) -> HRESULT,
    fn put_IsActive(&self, value: bool) -> HRESULT
}}
impl IStateTrigger {
    #[inline] pub unsafe fn get_is_active(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsActive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_active(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsActive)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class StateTrigger: IStateTrigger}
impl RtActivatable<IStateTriggerStatics> for StateTrigger {}
impl RtActivatable<IActivationFactory> for StateTrigger {}
impl StateTrigger {
    #[inline] pub fn get_is_active_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IStateTriggerStatics>>::get_activation_factory().get_is_active_property()
    }}
}
DEFINE_CLSID!(StateTrigger(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,83,116,97,116,101,84,114,105,103,103,101,114,0]) [CLSID_StateTrigger]);
DEFINE_IID!(IID_IStateTriggerBase, 1219626648, 44806, 18028, 128, 82, 147, 102, 109, 222, 14, 73);
RT_INTERFACE!{interface IStateTriggerBase(IStateTriggerBaseVtbl): IInspectable(IInspectableVtbl) [IID_IStateTriggerBase] {
    
}}
RT_CLASS!{class StateTriggerBase: IStateTriggerBase}
DEFINE_IID!(IID_IStateTriggerBaseFactory, 2534288459, 49071, 18352, 190, 66, 193, 215, 17, 187, 46, 159);
RT_INTERFACE!{interface IStateTriggerBaseFactory(IStateTriggerBaseFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IStateTriggerBaseFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut StateTriggerBase) -> HRESULT
}}
impl IStateTriggerBaseFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<StateTriggerBase>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IStateTriggerBaseProtected, 1010950739, 36116, 16918, 153, 76, 249, 147, 4, 41, 246, 229);
RT_INTERFACE!{interface IStateTriggerBaseProtected(IStateTriggerBaseProtectedVtbl): IInspectable(IInspectableVtbl) [IID_IStateTriggerBaseProtected] {
    fn SetActive(&self, isActive: bool) -> HRESULT
}}
impl IStateTriggerBaseProtected {
    #[inline] pub unsafe fn set_active(&self, isActive: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetActive)(self as *const _ as *mut _, isActive);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IStateTriggerStatics, 1911118992, 46078, 19923, 168, 168, 68, 162, 206, 37, 224, 184);
RT_INTERFACE!{static interface IStateTriggerStatics(IStateTriggerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IStateTriggerStatics] {
    fn get_IsActiveProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IStateTriggerStatics {
    #[inline] pub unsafe fn get_is_active_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsActiveProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IStyle, 3299471909, 40375, 19069, 182, 209, 247, 78, 219, 146, 147, 194);
RT_INTERFACE!{interface IStyle(IStyleVtbl): IInspectable(IInspectableVtbl) [IID_IStyle] {
    fn get_IsSealed(&self, out: *mut bool) -> HRESULT,
    fn get_Setters(&self, out: *mut *mut SetterBaseCollection) -> HRESULT,
    fn get_TargetType(&self, out: *mut interop::TypeName) -> HRESULT,
    fn put_TargetType(&self, value: interop::TypeName) -> HRESULT,
    fn get_BasedOn(&self, out: *mut *mut Style) -> HRESULT,
    fn put_BasedOn(&self, value: *mut Style) -> HRESULT,
    fn Seal(&self) -> HRESULT
}}
impl IStyle {
    #[inline] pub unsafe fn get_is_sealed(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSealed)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_setters(&self) -> Result<ComPtr<SetterBaseCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Setters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_type(&self) -> Result<interop::TypeName> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TargetType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_type(&self, value: interop::TypeName) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_based_on(&self) -> Result<ComPtr<Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BasedOn)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_based_on(&self, value: &Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BasedOn)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn seal(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Seal)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Style: IStyle}
impl RtActivatable<IStyleFactory> for Style {}
impl RtActivatable<IActivationFactory> for Style {}
impl Style {
    #[inline] pub fn create_instance(targetType: interop::TypeName) -> Result<ComPtr<Style>> { unsafe {
        <Self as RtActivatable<IStyleFactory>>::get_activation_factory().create_instance(targetType)
    }}
}
DEFINE_CLSID!(Style(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,83,116,121,108,101,0]) [CLSID_Style]);
DEFINE_IID!(IID_IStyleFactory, 2741511395, 15745, 19685, 170, 81, 139, 65, 15, 96, 47, 205);
RT_INTERFACE!{static interface IStyleFactory(IStyleFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IStyleFactory] {
    fn CreateInstance(&self, targetType: interop::TypeName, out: *mut *mut Style) -> HRESULT
}}
impl IStyleFactory {
    #[inline] pub unsafe fn create_instance(&self, targetType: interop::TypeName) -> Result<ComPtr<Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, targetType, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_SuspendingEventHandler, 591565925, 58218, 16610, 177, 57, 164, 112, 70, 2, 166, 225);
RT_DELEGATE!{delegate SuspendingEventHandler(SuspendingEventHandlerVtbl, SuspendingEventHandlerImpl) [IID_SuspendingEventHandler] {
    #[cfg(feature="windows-applicationmodel")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::super::applicationmodel::SuspendingEventArgs) -> HRESULT
}}
impl SuspendingEventHandler {
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::super::applicationmodel::SuspendingEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITargetPropertyPath, 1081347982, 2143, 19693, 190, 112, 111, 71, 172, 241, 90, 208);
RT_INTERFACE!{interface ITargetPropertyPath(ITargetPropertyPathVtbl): IInspectable(IInspectableVtbl) [IID_ITargetPropertyPath] {
    fn get_Path(&self, out: *mut *mut PropertyPath) -> HRESULT,
    fn put_Path(&self, value: *mut PropertyPath) -> HRESULT,
    fn get_Target(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Target(&self, value: *mut IInspectable) -> HRESULT
}}
impl ITargetPropertyPath {
    #[inline] pub unsafe fn get_path(&self) -> Result<ComPtr<PropertyPath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Path)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_path(&self, value: &PropertyPath) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Path)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Target)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Target)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class TargetPropertyPath: ITargetPropertyPath}
impl RtActivatable<ITargetPropertyPathFactory> for TargetPropertyPath {}
impl RtActivatable<IActivationFactory> for TargetPropertyPath {}
impl TargetPropertyPath {
    #[inline] pub fn create_instance(targetProperty: &DependencyProperty) -> Result<ComPtr<TargetPropertyPath>> { unsafe {
        <Self as RtActivatable<ITargetPropertyPathFactory>>::get_activation_factory().create_instance(targetProperty)
    }}
}
DEFINE_CLSID!(TargetPropertyPath(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,84,97,114,103,101,116,80,114,111,112,101,114,116,121,80,97,116,104,0]) [CLSID_TargetPropertyPath]);
DEFINE_IID!(IID_ITargetPropertyPathFactory, 2297351368, 39394, 19012, 153, 7, 180, 75, 200, 110, 43, 190);
RT_INTERFACE!{static interface ITargetPropertyPathFactory(ITargetPropertyPathFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ITargetPropertyPathFactory] {
    fn CreateInstance(&self, targetProperty: *mut DependencyProperty, out: *mut *mut TargetPropertyPath) -> HRESULT
}}
impl ITargetPropertyPathFactory {
    #[inline] pub unsafe fn create_instance(&self, targetProperty: &DependencyProperty) -> Result<ComPtr<TargetPropertyPath>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, targetProperty as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum TextAlignment: i32 {
    Center (TextAlignment_Center) = 0, Left (TextAlignment_Left) = 1, Start (TextAlignment_Start) = 1, Right (TextAlignment_Right) = 2, End (TextAlignment_End) = 2, Justify (TextAlignment_Justify) = 3, DetectFromContent (TextAlignment_DetectFromContent) = 4,
}}
RT_ENUM! { enum TextLineBounds: i32 {
    Full (TextLineBounds_Full) = 0, TrimToCapHeight (TextLineBounds_TrimToCapHeight) = 1, TrimToBaseline (TextLineBounds_TrimToBaseline) = 2, Tight (TextLineBounds_Tight) = 3,
}}
RT_ENUM! { enum TextReadingOrder: i32 {
    Default (TextReadingOrder_Default) = 0, UseFlowDirection (TextReadingOrder_UseFlowDirection) = 0, DetectFromContent (TextReadingOrder_DetectFromContent) = 1,
}}
RT_ENUM! { enum TextTrimming: i32 {
    None (TextTrimming_None) = 0, CharacterEllipsis (TextTrimming_CharacterEllipsis) = 1, WordEllipsis (TextTrimming_WordEllipsis) = 2, Clip (TextTrimming_Clip) = 3,
}}
RT_ENUM! { enum TextWrapping: i32 {
    NoWrap (TextWrapping_NoWrap) = 1, Wrap (TextWrapping_Wrap) = 2, WrapWholeWords (TextWrapping_WrapWholeWords) = 3,
}}
RT_STRUCT! { struct Thickness {
    Left: f64, Top: f64, Right: f64, Bottom: f64,
}}
DEFINE_IID!(IID_IThicknessHelper, 2825629259, 7823, 20203, 144, 19, 11, 40, 56, 169, 123, 52);
RT_INTERFACE!{interface IThicknessHelper(IThicknessHelperVtbl): IInspectable(IInspectableVtbl) [IID_IThicknessHelper] {
    
}}
RT_CLASS!{class ThicknessHelper: IThicknessHelper}
impl RtActivatable<IThicknessHelperStatics> for ThicknessHelper {}
impl ThicknessHelper {
    #[inline] pub fn from_lengths(left: f64, top: f64, right: f64, bottom: f64) -> Result<Thickness> { unsafe {
        <Self as RtActivatable<IThicknessHelperStatics>>::get_activation_factory().from_lengths(left, top, right, bottom)
    }}
    #[inline] pub fn from_uniform_length(uniformLength: f64) -> Result<Thickness> { unsafe {
        <Self as RtActivatable<IThicknessHelperStatics>>::get_activation_factory().from_uniform_length(uniformLength)
    }}
}
DEFINE_CLSID!(ThicknessHelper(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,84,104,105,99,107,110,101,115,115,72,101,108,112,101,114,0]) [CLSID_ThicknessHelper]);
DEFINE_IID!(IID_IThicknessHelperStatics, 3231259260, 1804, 19878, 135, 132, 1, 202, 128, 14, 183, 58);
RT_INTERFACE!{static interface IThicknessHelperStatics(IThicknessHelperStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IThicknessHelperStatics] {
    fn FromLengths(&self, left: f64, top: f64, right: f64, bottom: f64, out: *mut Thickness) -> HRESULT,
    fn FromUniformLength(&self, uniformLength: f64, out: *mut Thickness) -> HRESULT
}}
impl IThicknessHelperStatics {
    #[inline] pub unsafe fn from_lengths(&self, left: f64, top: f64, right: f64, bottom: f64) -> Result<Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromLengths)(self as *const _ as *mut _, left, top, right, bottom, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn from_uniform_length(&self, uniformLength: f64) -> Result<Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).FromUniformLength)(self as *const _ as *mut _, uniformLength, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ITriggerAction, 2730548994, 25557, 19270, 155, 131, 8, 104, 211, 7, 150, 33);
RT_INTERFACE!{interface ITriggerAction(ITriggerActionVtbl): IInspectable(IInspectableVtbl) [IID_ITriggerAction] {
    
}}
RT_CLASS!{class TriggerAction: ITriggerAction}
RT_CLASS!{class TriggerActionCollection: super::super::foundation::collections::IVector<TriggerAction>}
impl RtActivatable<IActivationFactory> for TriggerActionCollection {}
DEFINE_CLSID!(TriggerActionCollection(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,84,114,105,103,103,101,114,65,99,116,105,111,110,67,111,108,108,101,99,116,105,111,110,0]) [CLSID_TriggerActionCollection]);
DEFINE_IID!(IID_ITriggerActionFactory, 1758642361, 12937, 16719, 143, 110, 198, 185, 122, 237, 218, 3);
RT_INTERFACE!{interface ITriggerActionFactory(ITriggerActionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ITriggerActionFactory] {
    
}}
DEFINE_IID!(IID_ITriggerBase, 3890881071, 57062, 17299, 168, 178, 137, 35, 214, 65, 243, 149);
RT_INTERFACE!{interface ITriggerBase(ITriggerBaseVtbl): IInspectable(IInspectableVtbl) [IID_ITriggerBase] {
    
}}
RT_CLASS!{class TriggerBase: ITriggerBase}
DEFINE_IID!(IID_ITriggerBaseFactory, 1782292055, 64605, 17104, 140, 185, 202, 80, 102, 122, 247, 70);
RT_INTERFACE!{interface ITriggerBaseFactory(ITriggerBaseFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ITriggerBaseFactory] {
    
}}
RT_CLASS!{class TriggerCollection: super::super::foundation::collections::IVector<TriggerBase>}
DEFINE_IID!(IID_IUIElement, 1735199721, 46684, 16838, 186, 64, 88, 207, 135, 242, 1, 193);
RT_INTERFACE!{interface IUIElement(IUIElementVtbl): IInspectable(IInspectableVtbl) [IID_IUIElement] {
    fn get_DesiredSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_AllowDrop(&self, out: *mut bool) -> HRESULT,
    fn put_AllowDrop(&self, value: bool) -> HRESULT,
    fn get_Opacity(&self, out: *mut f64) -> HRESULT,
    fn put_Opacity(&self, value: f64) -> HRESULT,
    fn get_Clip(&self, out: *mut *mut media::RectangleGeometry) -> HRESULT,
    fn put_Clip(&self, value: *mut media::RectangleGeometry) -> HRESULT,
    fn get_RenderTransform(&self, out: *mut *mut media::Transform) -> HRESULT,
    fn put_RenderTransform(&self, value: *mut media::Transform) -> HRESULT,
    fn get_Projection(&self, out: *mut *mut media::Projection) -> HRESULT,
    fn put_Projection(&self, value: *mut media::Projection) -> HRESULT,
    fn get_RenderTransformOrigin(&self, out: *mut super::super::foundation::Point) -> HRESULT,
    fn put_RenderTransformOrigin(&self, value: super::super::foundation::Point) -> HRESULT,
    fn get_IsHitTestVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsHitTestVisible(&self, value: bool) -> HRESULT,
    fn get_Visibility(&self, out: *mut Visibility) -> HRESULT,
    fn put_Visibility(&self, value: Visibility) -> HRESULT,
    fn get_RenderSize(&self, out: *mut super::super::foundation::Size) -> HRESULT,
    fn get_UseLayoutRounding(&self, out: *mut bool) -> HRESULT,
    fn put_UseLayoutRounding(&self, value: bool) -> HRESULT,
    fn get_Transitions(&self, out: *mut *mut media::animation::TransitionCollection) -> HRESULT,
    fn put_Transitions(&self, value: *mut media::animation::TransitionCollection) -> HRESULT,
    fn get_CacheMode(&self, out: *mut *mut media::CacheMode) -> HRESULT,
    fn put_CacheMode(&self, value: *mut media::CacheMode) -> HRESULT,
    fn get_IsTapEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTapEnabled(&self, value: bool) -> HRESULT,
    fn get_IsDoubleTapEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsDoubleTapEnabled(&self, value: bool) -> HRESULT,
    fn get_IsRightTapEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsRightTapEnabled(&self, value: bool) -> HRESULT,
    fn get_IsHoldingEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsHoldingEnabled(&self, value: bool) -> HRESULT,
    fn get_ManipulationMode(&self, out: *mut input::ManipulationModes) -> HRESULT,
    fn put_ManipulationMode(&self, value: input::ManipulationModes) -> HRESULT,
    fn get_PointerCaptures(&self, out: *mut *mut super::super::foundation::collections::IVectorView<input::Pointer>) -> HRESULT,
    fn add_KeyUp(&self, value: *mut input::KeyEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyUp(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_KeyDown(&self, value: *mut input::KeyEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_KeyDown(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_GotFocus(&self, value: *mut RoutedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_GotFocus(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_LostFocus(&self, value: *mut RoutedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LostFocus(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DragEnter(&self, value: *mut DragEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DragEnter(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DragLeave(&self, value: *mut DragEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DragLeave(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DragOver(&self, value: *mut DragEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DragOver(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Drop(&self, value: *mut DragEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Drop(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerPressed(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerPressed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerMoved(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerMoved(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerReleased(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerReleased(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerEntered(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerEntered(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerExited(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerExited(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerCaptureLost(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerCaptureLost(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerCanceled(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerCanceled(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PointerWheelChanged(&self, value: *mut input::PointerEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PointerWheelChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Tapped(&self, value: *mut input::TappedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Tapped(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DoubleTapped(&self, value: *mut input::DoubleTappedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DoubleTapped(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Holding(&self, value: *mut input::HoldingEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Holding(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_RightTapped(&self, value: *mut input::RightTappedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_RightTapped(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationStarting(&self, value: *mut input::ManipulationStartingEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationStarting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationInertiaStarting(&self, value: *mut input::ManipulationInertiaStartingEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationInertiaStarting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationStarted(&self, value: *mut input::ManipulationStartedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationStarted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationDelta(&self, value: *mut input::ManipulationDeltaEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationDelta(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ManipulationCompleted(&self, value: *mut input::ManipulationCompletedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ManipulationCompleted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Measure(&self, availableSize: super::super::foundation::Size) -> HRESULT,
    fn Arrange(&self, finalRect: super::super::foundation::Rect) -> HRESULT,
    fn CapturePointer(&self, value: *mut input::Pointer, out: *mut bool) -> HRESULT,
    fn ReleasePointerCapture(&self, value: *mut input::Pointer) -> HRESULT,
    fn ReleasePointerCaptures(&self) -> HRESULT,
    fn AddHandler(&self, routedEvent: *mut RoutedEvent, handler: *mut IInspectable, handledEventsToo: bool) -> HRESULT,
    fn RemoveHandler(&self, routedEvent: *mut RoutedEvent, handler: *mut IInspectable) -> HRESULT,
    fn TransformToVisual(&self, visual: *mut UIElement, out: *mut *mut media::GeneralTransform) -> HRESULT,
    fn InvalidateMeasure(&self) -> HRESULT,
    fn InvalidateArrange(&self) -> HRESULT,
    fn UpdateLayout(&self) -> HRESULT
}}
impl IUIElement {
    #[inline] pub unsafe fn get_desired_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DesiredSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_drop(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AllowDrop)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_allow_drop(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AllowDrop)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_opacity(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Opacity)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_opacity(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Opacity)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clip(&self) -> Result<ComPtr<media::RectangleGeometry>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Clip)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_clip(&self, value: &media::RectangleGeometry) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Clip)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_render_transform(&self) -> Result<ComPtr<media::Transform>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RenderTransform)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_render_transform(&self, value: &media::Transform) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RenderTransform)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_projection(&self) -> Result<ComPtr<media::Projection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Projection)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_projection(&self, value: &media::Projection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Projection)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_render_transform_origin(&self) -> Result<super::super::foundation::Point> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RenderTransformOrigin)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_render_transform_origin(&self, value: super::super::foundation::Point) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RenderTransformOrigin)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hit_test_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHitTestVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_hit_test_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHitTestVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visibility(&self) -> Result<Visibility> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visibility)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_visibility(&self, value: Visibility) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Visibility)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_render_size(&self) -> Result<super::super::foundation::Size> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RenderSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_use_layout_rounding(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UseLayoutRounding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_use_layout_rounding(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UseLayoutRounding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transitions(&self) -> Result<ComPtr<media::animation::TransitionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Transitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_transitions(&self, value: &media::animation::TransitionCollection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Transitions)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cache_mode(&self) -> Result<ComPtr<media::CacheMode>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CacheMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cache_mode(&self, value: &media::CacheMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CacheMode)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_tap_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTapEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_tap_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTapEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_double_tap_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDoubleTapEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_double_tap_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDoubleTapEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_right_tap_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRightTapEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_right_tap_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsRightTapEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_holding_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHoldingEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_holding_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHoldingEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_mode(&self) -> Result<input::ManipulationModes> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ManipulationMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_manipulation_mode(&self, value: input::ManipulationModes) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ManipulationMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_captures(&self) -> Result<ComPtr<super::super::foundation::collections::IVectorView<input::Pointer>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerCaptures)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_up(&self, value: &input::KeyEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyUp)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_up(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyUp)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_key_down(&self, value: &input::KeyEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_KeyDown)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_key_down(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_KeyDown)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_got_focus(&self, value: &RoutedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_GotFocus)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_got_focus(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_GotFocus)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_lost_focus(&self, value: &RoutedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LostFocus)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_lost_focus(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LostFocus)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drag_enter(&self, value: &DragEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DragEnter)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drag_enter(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DragEnter)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drag_leave(&self, value: &DragEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DragLeave)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drag_leave(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DragLeave)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drag_over(&self, value: &DragEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DragOver)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drag_over(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DragOver)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drop(&self, value: &DragEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Drop)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drop(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Drop)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_pressed(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerPressed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_pressed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerPressed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_moved(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerMoved)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_moved(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerMoved)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_released(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerReleased)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_released(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerReleased)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_entered(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerEntered)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_entered(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerEntered)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_exited(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerExited)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_exited(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerExited)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_capture_lost(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerCaptureLost)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_capture_lost(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerCaptureLost)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_canceled(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerCanceled)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_canceled(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerCanceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_pointer_wheel_changed(&self, value: &input::PointerEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PointerWheelChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_pointer_wheel_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PointerWheelChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_tapped(&self, value: &input::TappedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Tapped)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_tapped(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Tapped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_double_tapped(&self, value: &input::DoubleTappedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DoubleTapped)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_double_tapped(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DoubleTapped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_holding(&self, value: &input::HoldingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Holding)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_holding(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Holding)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_right_tapped(&self, value: &input::RightTappedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_RightTapped)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_right_tapped(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_RightTapped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_starting(&self, value: &input::ManipulationStartingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationStarting)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_starting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationStarting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_inertia_starting(&self, value: &input::ManipulationInertiaStartingEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationInertiaStarting)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_inertia_starting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationInertiaStarting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_started(&self, value: &input::ManipulationStartedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationStarted)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_started(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationStarted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_delta(&self, value: &input::ManipulationDeltaEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationDelta)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_delta(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationDelta)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_manipulation_completed(&self, value: &input::ManipulationCompletedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ManipulationCompleted)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_manipulation_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ManipulationCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn measure(&self, availableSize: super::super::foundation::Size) -> Result<()> {
        let hr = ((*self.lpVtbl).Measure)(self as *const _ as *mut _, availableSize);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn arrange(&self, finalRect: super::super::foundation::Rect) -> Result<()> {
        let hr = ((*self.lpVtbl).Arrange)(self as *const _ as *mut _, finalRect);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn capture_pointer(&self, value: &input::Pointer) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CapturePointer)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn release_pointer_capture(&self, value: &input::Pointer) -> Result<()> {
        let hr = ((*self.lpVtbl).ReleasePointerCapture)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn release_pointer_captures(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).ReleasePointerCaptures)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_handler(&self, routedEvent: &RoutedEvent, handler: &IInspectable, handledEventsToo: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).AddHandler)(self as *const _ as *mut _, routedEvent as *const _ as *mut _, handler as *const _ as *mut _, handledEventsToo);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_handler(&self, routedEvent: &RoutedEvent, handler: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveHandler)(self as *const _ as *mut _, routedEvent as *const _ as *mut _, handler as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn transform_to_visual(&self, visual: &UIElement) -> Result<ComPtr<media::GeneralTransform>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).TransformToVisual)(self as *const _ as *mut _, visual as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn invalidate_measure(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).InvalidateMeasure)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn invalidate_arrange(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).InvalidateArrange)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn update_layout(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).UpdateLayout)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class UIElement: IUIElement}
impl RtActivatable<IUIElementStatics> for UIElement {}
impl RtActivatable<IUIElementStatics2> for UIElement {}
impl RtActivatable<IUIElementStatics3> for UIElement {}
impl RtActivatable<IUIElementStatics4> for UIElement {}
impl RtActivatable<IUIElementStatics5> for UIElement {}
impl RtActivatable<IUIElementStatics6> for UIElement {}
impl RtActivatable<IUIElementStatics7> for UIElement {}
impl UIElement {
    #[inline] pub fn get_key_down_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_key_down_event()
    }}
    #[inline] pub fn get_key_up_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_key_up_event()
    }}
    #[inline] pub fn get_pointer_entered_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_entered_event()
    }}
    #[inline] pub fn get_pointer_pressed_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_pressed_event()
    }}
    #[inline] pub fn get_pointer_moved_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_moved_event()
    }}
    #[inline] pub fn get_pointer_released_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_released_event()
    }}
    #[inline] pub fn get_pointer_exited_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_exited_event()
    }}
    #[inline] pub fn get_pointer_capture_lost_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_capture_lost_event()
    }}
    #[inline] pub fn get_pointer_canceled_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_canceled_event()
    }}
    #[inline] pub fn get_pointer_wheel_changed_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_wheel_changed_event()
    }}
    #[inline] pub fn get_tapped_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_tapped_event()
    }}
    #[inline] pub fn get_double_tapped_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_double_tapped_event()
    }}
    #[inline] pub fn get_holding_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_holding_event()
    }}
    #[inline] pub fn get_right_tapped_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_right_tapped_event()
    }}
    #[inline] pub fn get_manipulation_starting_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_manipulation_starting_event()
    }}
    #[inline] pub fn get_manipulation_inertia_starting_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_manipulation_inertia_starting_event()
    }}
    #[inline] pub fn get_manipulation_started_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_manipulation_started_event()
    }}
    #[inline] pub fn get_manipulation_delta_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_manipulation_delta_event()
    }}
    #[inline] pub fn get_manipulation_completed_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_manipulation_completed_event()
    }}
    #[inline] pub fn get_drag_enter_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_drag_enter_event()
    }}
    #[inline] pub fn get_drag_leave_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_drag_leave_event()
    }}
    #[inline] pub fn get_drag_over_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_drag_over_event()
    }}
    #[inline] pub fn get_drop_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_drop_event()
    }}
    #[inline] pub fn get_allow_drop_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_allow_drop_property()
    }}
    #[inline] pub fn get_opacity_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_opacity_property()
    }}
    #[inline] pub fn get_clip_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_clip_property()
    }}
    #[inline] pub fn get_render_transform_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_render_transform_property()
    }}
    #[inline] pub fn get_projection_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_projection_property()
    }}
    #[inline] pub fn get_render_transform_origin_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_render_transform_origin_property()
    }}
    #[inline] pub fn get_is_hit_test_visible_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_is_hit_test_visible_property()
    }}
    #[inline] pub fn get_visibility_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_visibility_property()
    }}
    #[inline] pub fn get_use_layout_rounding_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_use_layout_rounding_property()
    }}
    #[inline] pub fn get_transitions_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_transitions_property()
    }}
    #[inline] pub fn get_cache_mode_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_cache_mode_property()
    }}
    #[inline] pub fn get_is_tap_enabled_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_is_tap_enabled_property()
    }}
    #[inline] pub fn get_is_double_tap_enabled_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_is_double_tap_enabled_property()
    }}
    #[inline] pub fn get_is_right_tap_enabled_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_is_right_tap_enabled_property()
    }}
    #[inline] pub fn get_is_holding_enabled_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_is_holding_enabled_property()
    }}
    #[inline] pub fn get_manipulation_mode_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_manipulation_mode_property()
    }}
    #[inline] pub fn get_pointer_captures_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics>>::get_activation_factory().get_pointer_captures_property()
    }}
    #[inline] pub fn get_composite_mode_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics2>>::get_activation_factory().get_composite_mode_property()
    }}
    #[inline] pub fn get_transform3_dproperty() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics3>>::get_activation_factory().get_transform3_dproperty()
    }}
    #[inline] pub fn get_can_drag_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics3>>::get_activation_factory().get_can_drag_property()
    }}
    #[inline] pub fn try_start_direct_manipulation(value: &input::Pointer) -> Result<bool> { unsafe {
        <Self as RtActivatable<IUIElementStatics3>>::get_activation_factory().try_start_direct_manipulation(value)
    }}
    #[inline] pub fn get_context_flyout_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics4>>::get_activation_factory().get_context_flyout_property()
    }}
    #[inline] pub fn get_exit_display_mode_on_access_key_invoked_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics4>>::get_activation_factory().get_exit_display_mode_on_access_key_invoked_property()
    }}
    #[inline] pub fn get_is_access_key_scope_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics4>>::get_activation_factory().get_is_access_key_scope_property()
    }}
    #[inline] pub fn get_access_key_scope_owner_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics4>>::get_activation_factory().get_access_key_scope_owner_property()
    }}
    #[inline] pub fn get_access_key_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics4>>::get_activation_factory().get_access_key_property()
    }}
    #[inline] pub fn get_lights_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_lights_property()
    }}
    #[inline] pub fn get_key_tip_placement_mode_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_key_tip_placement_mode_property()
    }}
    #[inline] pub fn get_key_tip_horizontal_offset_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_key_tip_horizontal_offset_property()
    }}
    #[inline] pub fn get_key_tip_vertical_offset_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_key_tip_vertical_offset_property()
    }}
    #[inline] pub fn get_xyfocus_keyboard_navigation_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_xyfocus_keyboard_navigation_property()
    }}
    #[inline] pub fn get_xyfocus_up_navigation_strategy_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_xyfocus_up_navigation_strategy_property()
    }}
    #[inline] pub fn get_xyfocus_down_navigation_strategy_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_xyfocus_down_navigation_strategy_property()
    }}
    #[inline] pub fn get_xyfocus_left_navigation_strategy_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_xyfocus_left_navigation_strategy_property()
    }}
    #[inline] pub fn get_xyfocus_right_navigation_strategy_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_xyfocus_right_navigation_strategy_property()
    }}
    #[inline] pub fn get_high_contrast_adjustment_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_high_contrast_adjustment_property()
    }}
    #[inline] pub fn get_tab_focus_navigation_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IUIElementStatics5>>::get_activation_factory().get_tab_focus_navigation_property()
    }}
    #[inline] pub fn get_getting_focus_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics6>>::get_activation_factory().get_getting_focus_event()
    }}
    #[inline] pub fn get_losing_focus_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics6>>::get_activation_factory().get_losing_focus_event()
    }}
    #[inline] pub fn get_no_focus_candidate_found_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics6>>::get_activation_factory().get_no_focus_candidate_found_event()
    }}
    #[inline] pub fn get_preview_key_down_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics7>>::get_activation_factory().get_preview_key_down_event()
    }}
    #[inline] pub fn get_character_received_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics7>>::get_activation_factory().get_character_received_event()
    }}
    #[inline] pub fn get_preview_key_up_event() -> Result<ComPtr<RoutedEvent>> { unsafe {
        <Self as RtActivatable<IUIElementStatics7>>::get_activation_factory().get_preview_key_up_event()
    }}
}
DEFINE_CLSID!(UIElement(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,85,73,69,108,101,109,101,110,116,0]) [CLSID_UIElement]);
DEFINE_IID!(IID_IUIElement2, 1735199737, 46700, 16854, 186, 80, 88, 207, 135, 242, 1, 209);
RT_INTERFACE!{interface IUIElement2(IUIElement2Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElement2] {
    fn get_CompositeMode(&self, out: *mut media::ElementCompositeMode) -> HRESULT,
    fn put_CompositeMode(&self, value: media::ElementCompositeMode) -> HRESULT,
    fn CancelDirectManipulations(&self, out: *mut bool) -> HRESULT
}}
impl IUIElement2 {
    #[inline] pub unsafe fn get_composite_mode(&self) -> Result<media::ElementCompositeMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CompositeMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_composite_mode(&self, value: media::ElementCompositeMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CompositeMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn cancel_direct_manipulations(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CancelDirectManipulations)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElement3, 3156945137, 9970, 19115, 178, 86, 59, 83, 80, 136, 30, 55);
RT_INTERFACE!{interface IUIElement3(IUIElement3Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElement3] {
    fn get_Transform3D(&self, out: *mut *mut media::media3d::Transform3D) -> HRESULT,
    fn put_Transform3D(&self, value: *mut media::media3d::Transform3D) -> HRESULT,
    fn get_CanDrag(&self, out: *mut bool) -> HRESULT,
    fn put_CanDrag(&self, value: bool) -> HRESULT,
    fn add_DragStarting(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, DragStartingEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DragStarting(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DropCompleted(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, DropCompletedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DropCompleted(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    #[cfg(all(feature="windows-applicationmodel",feature="windows-ui"))] fn StartDragAsync(&self, pointerPoint: *mut super::input::PointerPoint, out: *mut *mut super::super::foundation::IAsyncOperation<super::super::applicationmodel::datatransfer::DataPackageOperation>) -> HRESULT
}}
impl IUIElement3 {
    #[inline] pub unsafe fn get_transform3_d(&self) -> Result<ComPtr<media::media3d::Transform3D>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Transform3D)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_transform3_d(&self, value: &media::media3d::Transform3D) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Transform3D)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_drag(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanDrag)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_can_drag(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CanDrag)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drag_starting(&self, value: &super::super::foundation::TypedEventHandler<UIElement, DragStartingEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DragStarting)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drag_starting(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DragStarting)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drop_completed(&self, value: &super::super::foundation::TypedEventHandler<UIElement, DropCompletedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DropCompleted)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drop_completed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DropCompleted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(all(feature="windows-applicationmodel",feature="windows-ui"))] #[inline] pub unsafe fn start_drag_async(&self, pointerPoint: &super::input::PointerPoint) -> Result<ComPtr<super::super::foundation::IAsyncOperation<super::super::applicationmodel::datatransfer::DataPackageOperation>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).StartDragAsync)(self as *const _ as *mut _, pointerPoint as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElement4, 1762942164, 6554, 18007, 158, 87, 233, 158, 143, 19, 103, 18);
RT_INTERFACE!{interface IUIElement4(IUIElement4Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElement4] {
    fn get_ContextFlyout(&self, out: *mut *mut controls::primitives::FlyoutBase) -> HRESULT,
    fn put_ContextFlyout(&self, value: *mut controls::primitives::FlyoutBase) -> HRESULT,
    fn get_ExitDisplayModeOnAccessKeyInvoked(&self, out: *mut bool) -> HRESULT,
    fn put_ExitDisplayModeOnAccessKeyInvoked(&self, value: bool) -> HRESULT,
    fn get_IsAccessKeyScope(&self, out: *mut bool) -> HRESULT,
    fn put_IsAccessKeyScope(&self, value: bool) -> HRESULT,
    fn get_AccessKeyScopeOwner(&self, out: *mut *mut DependencyObject) -> HRESULT,
    fn put_AccessKeyScopeOwner(&self, value: *mut DependencyObject) -> HRESULT,
    fn get_AccessKey(&self, out: *mut HSTRING) -> HRESULT,
    fn put_AccessKey(&self, value: HSTRING) -> HRESULT,
    fn add_ContextRequested(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::ContextRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ContextRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ContextCanceled(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, RoutedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ContextCanceled(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AccessKeyDisplayRequested(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::AccessKeyDisplayRequestedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AccessKeyDisplayRequested(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AccessKeyDisplayDismissed(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::AccessKeyDisplayDismissedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AccessKeyDisplayDismissed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_AccessKeyInvoked(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::AccessKeyInvokedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_AccessKeyInvoked(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IUIElement4 {
    #[inline] pub unsafe fn get_context_flyout(&self) -> Result<ComPtr<controls::primitives::FlyoutBase>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContextFlyout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_context_flyout(&self, value: &controls::primitives::FlyoutBase) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContextFlyout)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exit_display_mode_on_access_key_invoked(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ExitDisplayModeOnAccessKeyInvoked)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_exit_display_mode_on_access_key_invoked(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ExitDisplayModeOnAccessKeyInvoked)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_access_key_scope(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAccessKeyScope)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_access_key_scope(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAccessKeyScope)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_key_scope_owner(&self) -> Result<ComPtr<DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccessKeyScopeOwner)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_access_key_scope_owner(&self, value: &DependencyObject) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AccessKeyScopeOwner)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_key(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccessKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_access_key(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AccessKey)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_context_requested(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::ContextRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ContextRequested)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_context_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ContextRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_context_canceled(&self, value: &super::super::foundation::TypedEventHandler<UIElement, RoutedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ContextCanceled)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_context_canceled(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ContextCanceled)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_access_key_display_requested(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::AccessKeyDisplayRequestedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AccessKeyDisplayRequested)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_access_key_display_requested(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AccessKeyDisplayRequested)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_access_key_display_dismissed(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::AccessKeyDisplayDismissedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AccessKeyDisplayDismissed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_access_key_display_dismissed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AccessKeyDisplayDismissed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_access_key_invoked(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::AccessKeyInvokedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_AccessKeyInvoked)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_access_key_invoked(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_AccessKeyInvoked)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElement5, 2397936578, 42380, 17491, 175, 15, 169, 46, 224, 109, 3, 23);
RT_INTERFACE!{interface IUIElement5(IUIElement5Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElement5] {
    fn get_Lights(&self, out: *mut *mut super::super::foundation::collections::IVector<media::XamlLight>) -> HRESULT,
    fn get_KeyTipPlacementMode(&self, out: *mut input::KeyTipPlacementMode) -> HRESULT,
    fn put_KeyTipPlacementMode(&self, value: input::KeyTipPlacementMode) -> HRESULT,
    fn get_KeyTipHorizontalOffset(&self, out: *mut f64) -> HRESULT,
    fn put_KeyTipHorizontalOffset(&self, value: f64) -> HRESULT,
    fn get_KeyTipVerticalOffset(&self, out: *mut f64) -> HRESULT,
    fn put_KeyTipVerticalOffset(&self, value: f64) -> HRESULT,
    fn get_XYFocusKeyboardNavigation(&self, out: *mut input::XYFocusKeyboardNavigationMode) -> HRESULT,
    fn put_XYFocusKeyboardNavigation(&self, value: input::XYFocusKeyboardNavigationMode) -> HRESULT,
    fn get_XYFocusUpNavigationStrategy(&self, out: *mut input::XYFocusNavigationStrategy) -> HRESULT,
    fn put_XYFocusUpNavigationStrategy(&self, value: input::XYFocusNavigationStrategy) -> HRESULT,
    fn get_XYFocusDownNavigationStrategy(&self, out: *mut input::XYFocusNavigationStrategy) -> HRESULT,
    fn put_XYFocusDownNavigationStrategy(&self, value: input::XYFocusNavigationStrategy) -> HRESULT,
    fn get_XYFocusLeftNavigationStrategy(&self, out: *mut input::XYFocusNavigationStrategy) -> HRESULT,
    fn put_XYFocusLeftNavigationStrategy(&self, value: input::XYFocusNavigationStrategy) -> HRESULT,
    fn get_XYFocusRightNavigationStrategy(&self, out: *mut input::XYFocusNavigationStrategy) -> HRESULT,
    fn put_XYFocusRightNavigationStrategy(&self, value: input::XYFocusNavigationStrategy) -> HRESULT,
    fn get_HighContrastAdjustment(&self, out: *mut ElementHighContrastAdjustment) -> HRESULT,
    fn put_HighContrastAdjustment(&self, value: ElementHighContrastAdjustment) -> HRESULT,
    fn get_TabFocusNavigation(&self, out: *mut input::KeyboardNavigationMode) -> HRESULT,
    fn put_TabFocusNavigation(&self, value: input::KeyboardNavigationMode) -> HRESULT,
    fn add_GettingFocus(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::GettingFocusEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_GettingFocus(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_LosingFocus(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::LosingFocusEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_LosingFocus(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NoFocusCandidateFound(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::NoFocusCandidateFoundEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NoFocusCandidateFound(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn StartBringIntoView(&self) -> HRESULT,
    fn StartBringIntoViewWithOptions(&self, options: *mut BringIntoViewOptions) -> HRESULT
}}
impl IUIElement5 {
    #[inline] pub unsafe fn get_lights(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<media::XamlLight>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Lights)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_tip_placement_mode(&self) -> Result<input::KeyTipPlacementMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyTipPlacementMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_key_tip_placement_mode(&self, value: input::KeyTipPlacementMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeyTipPlacementMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_tip_horizontal_offset(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyTipHorizontalOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_key_tip_horizontal_offset(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeyTipHorizontalOffset)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_tip_vertical_offset(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_KeyTipVerticalOffset)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_key_tip_vertical_offset(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_KeyTipVerticalOffset)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_keyboard_navigation(&self) -> Result<input::XYFocusKeyboardNavigationMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_XYFocusKeyboardNavigation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_keyboard_navigation(&self, value: input::XYFocusKeyboardNavigationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusKeyboardNavigation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_up_navigation_strategy(&self) -> Result<input::XYFocusNavigationStrategy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_XYFocusUpNavigationStrategy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_up_navigation_strategy(&self, value: input::XYFocusNavigationStrategy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusUpNavigationStrategy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_down_navigation_strategy(&self) -> Result<input::XYFocusNavigationStrategy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_XYFocusDownNavigationStrategy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_down_navigation_strategy(&self, value: input::XYFocusNavigationStrategy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusDownNavigationStrategy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_left_navigation_strategy(&self) -> Result<input::XYFocusNavigationStrategy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_XYFocusLeftNavigationStrategy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_left_navigation_strategy(&self, value: input::XYFocusNavigationStrategy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusLeftNavigationStrategy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_right_navigation_strategy(&self) -> Result<input::XYFocusNavigationStrategy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_XYFocusRightNavigationStrategy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_right_navigation_strategy(&self, value: input::XYFocusNavigationStrategy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusRightNavigationStrategy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_high_contrast_adjustment(&self) -> Result<ElementHighContrastAdjustment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HighContrastAdjustment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_high_contrast_adjustment(&self, value: ElementHighContrastAdjustment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HighContrastAdjustment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_focus_navigation(&self) -> Result<input::KeyboardNavigationMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TabFocusNavigation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tab_focus_navigation(&self, value: input::KeyboardNavigationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TabFocusNavigation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_getting_focus(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::GettingFocusEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_GettingFocus)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_getting_focus(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_GettingFocus)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_losing_focus(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::LosingFocusEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_LosingFocus)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_losing_focus(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_LosingFocus)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_no_focus_candidate_found(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::NoFocusCandidateFoundEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NoFocusCandidateFound)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_no_focus_candidate_found(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NoFocusCandidateFound)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_bring_into_view(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).StartBringIntoView)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn start_bring_into_view_with_options(&self, options: &BringIntoViewOptions) -> Result<()> {
        let hr = ((*self.lpVtbl).StartBringIntoViewWithOptions)(self as *const _ as *mut _, options as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElement7, 3405531496, 25449, 16969, 128, 249, 61, 101, 99, 25, 232, 17);
RT_INTERFACE!{interface IUIElement7(IUIElement7Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElement7] {
    fn get_KeyboardAccelerators(&self, out: *mut *mut super::super::foundation::collections::IVector<input::KeyboardAccelerator>) -> HRESULT,
    fn add_CharacterReceived(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::CharacterReceivedRoutedEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CharacterReceived(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ProcessKeyboardAccelerators(&self, value: *mut super::super::foundation::TypedEventHandler<UIElement, input::ProcessKeyboardAcceleratorEventArgs>, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ProcessKeyboardAccelerators(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PreviewKeyDown(&self, value: *mut input::KeyEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PreviewKeyDown(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PreviewKeyUp(&self, value: *mut input::KeyEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PreviewKeyUp(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn TryInvokeKeyboardAccelerator(&self, args: *mut input::ProcessKeyboardAcceleratorEventArgs) -> HRESULT
}}
impl IUIElement7 {
    #[inline] pub unsafe fn get_keyboard_accelerators(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<input::KeyboardAccelerator>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_KeyboardAccelerators)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_character_received(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::CharacterReceivedRoutedEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CharacterReceived)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_character_received(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CharacterReceived)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_process_keyboard_accelerators(&self, value: &super::super::foundation::TypedEventHandler<UIElement, input::ProcessKeyboardAcceleratorEventArgs>) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ProcessKeyboardAccelerators)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_process_keyboard_accelerators(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ProcessKeyboardAccelerators)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_preview_key_down(&self, value: &input::KeyEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PreviewKeyDown)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_preview_key_down(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PreviewKeyDown)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_preview_key_up(&self, value: &input::KeyEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PreviewKeyUp)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_preview_key_up(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PreviewKeyUp)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_invoke_keyboard_accelerator(&self, args: &input::ProcessKeyboardAcceleratorEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).TryInvokeKeyboardAccelerator)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementFactory, 3119420414, 41784, 16799, 172, 50, 145, 220, 170, 223, 93, 8);
RT_INTERFACE!{interface IUIElementFactory(IUIElementFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IUIElementFactory] {
    
}}
DEFINE_IID!(IID_IUIElementOverrides, 1619865373, 30808, 19179, 137, 228, 181, 78, 44, 126, 211, 211);
RT_INTERFACE!{interface IUIElementOverrides(IUIElementOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IUIElementOverrides] {
    fn OnCreateAutomationPeer(&self, out: *mut *mut automation::peers::AutomationPeer) -> HRESULT,
    fn OnDisconnectVisualChildren(&self) -> HRESULT,
    fn FindSubElementsForTouchTargeting(&self, point: super::super::foundation::Point, boundingRect: super::super::foundation::Rect, out: *mut *mut super::super::foundation::collections::IIterable<super::super::foundation::collections::IIterable<super::super::foundation::Point>>) -> HRESULT
}}
impl IUIElementOverrides {
    #[inline] pub unsafe fn on_create_automation_peer(&self) -> Result<ComPtr<automation::peers::AutomationPeer>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).OnCreateAutomationPeer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_disconnect_visual_children(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDisconnectVisualChildren)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn find_sub_elements_for_touch_targeting(&self, point: super::super::foundation::Point, boundingRect: super::super::foundation::Rect) -> Result<ComPtr<super::super::foundation::collections::IIterable<super::super::foundation::collections::IIterable<super::super::foundation::Point>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).FindSubElementsForTouchTargeting)(self as *const _ as *mut _, point, boundingRect, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementOverrides7, 3112140648, 49819, 19609, 161, 195, 149, 38, 25, 214, 231, 32);
RT_INTERFACE!{interface IUIElementOverrides7(IUIElementOverrides7Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementOverrides7] {
    fn GetChildrenInTabFocusOrder(&self, out: *mut *mut super::super::foundation::collections::IIterable<DependencyObject>) -> HRESULT,
    fn OnProcessKeyboardAccelerators(&self, args: *mut input::ProcessKeyboardAcceleratorEventArgs) -> HRESULT
}}
impl IUIElementOverrides7 {
    #[inline] pub unsafe fn get_children_in_tab_focus_order(&self) -> Result<ComPtr<super::super::foundation::collections::IIterable<DependencyObject>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetChildrenInTabFocusOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_process_keyboard_accelerators(&self, args: &input::ProcessKeyboardAcceleratorEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnProcessKeyboardAccelerators)(self as *const _ as *mut _, args as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics, 1490245435, 62764, 17854, 152, 139, 165, 134, 149, 100, 135, 60);
RT_INTERFACE!{static interface IUIElementStatics(IUIElementStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics] {
    fn get_KeyDownEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_KeyUpEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerEnteredEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerPressedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerMovedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerReleasedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerExitedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerCaptureLostEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerCanceledEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PointerWheelChangedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_TappedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_DoubleTappedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_HoldingEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_RightTappedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_ManipulationStartingEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_ManipulationInertiaStartingEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_ManipulationStartedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_ManipulationDeltaEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_ManipulationCompletedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_DragEnterEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_DragLeaveEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_DragOverEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_DropEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_AllowDropProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_OpacityProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_ClipProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_RenderTransformProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_ProjectionProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_RenderTransformOriginProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_IsHitTestVisibleProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_VisibilityProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_UseLayoutRoundingProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_TransitionsProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_CacheModeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_IsTapEnabledProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_IsDoubleTapEnabledProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_IsRightTapEnabledProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_IsHoldingEnabledProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_ManipulationModeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_PointerCapturesProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IUIElementStatics {
    #[inline] pub unsafe fn get_key_down_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_KeyDownEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_up_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_KeyUpEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_entered_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerEnteredEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_pressed_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerPressedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_moved_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerMovedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_released_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerReleasedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_exited_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerExitedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_capture_lost_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerCaptureLostEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_canceled_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerCanceledEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_wheel_changed_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerWheelChangedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tapped_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TappedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_double_tapped_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DoubleTappedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_holding_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HoldingEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_right_tapped_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RightTappedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_starting_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManipulationStartingEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_inertia_starting_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManipulationInertiaStartingEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_started_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManipulationStartedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_delta_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManipulationDeltaEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_completed_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManipulationCompletedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drag_enter_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DragEnterEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drag_leave_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DragLeaveEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drag_over_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DragOverEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_drop_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DropEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_allow_drop_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AllowDropProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_opacity_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OpacityProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_clip_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ClipProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_render_transform_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RenderTransformProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_projection_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ProjectionProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_render_transform_origin_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RenderTransformOriginProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hit_test_visible_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsHitTestVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visibility_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VisibilityProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_use_layout_rounding_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UseLayoutRoundingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transitions_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TransitionsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cache_mode_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CacheModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_tap_enabled_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTapEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_double_tap_enabled_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsDoubleTapEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_right_tap_enabled_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsRightTapEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_holding_enabled_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsHoldingEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_manipulation_mode_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ManipulationModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pointer_captures_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PointerCapturesProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics2, 1490245451, 62780, 17854, 152, 155, 165, 134, 149, 100, 135, 76);
RT_INTERFACE!{static interface IUIElementStatics2(IUIElementStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics2] {
    fn get_CompositeModeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IUIElementStatics2 {
    #[inline] pub unsafe fn get_composite_mode_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CompositeModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics3, 3522722526, 60577, 17761, 163, 43, 100, 96, 27, 78, 5, 151);
RT_INTERFACE!{static interface IUIElementStatics3(IUIElementStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics3] {
    fn get_Transform3DProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_CanDragProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn TryStartDirectManipulation(&self, value: *mut input::Pointer, out: *mut bool) -> HRESULT
}}
impl IUIElementStatics3 {
    #[inline] pub unsafe fn get_transform3_dproperty(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Transform3DProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_drag_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CanDragProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn try_start_direct_manipulation(&self, value: &input::Pointer) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).TryStartDirectManipulation)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics4, 487947617, 5807, 16671, 183, 116, 39, 35, 117, 164, 172, 44);
RT_INTERFACE!{static interface IUIElementStatics4(IUIElementStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics4] {
    fn get_ContextFlyoutProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_ExitDisplayModeOnAccessKeyInvokedProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_IsAccessKeyScopeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_AccessKeyScopeOwnerProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_AccessKeyProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IUIElementStatics4 {
    #[inline] pub unsafe fn get_context_flyout_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContextFlyoutProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_exit_display_mode_on_access_key_invoked_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ExitDisplayModeOnAccessKeyInvokedProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_access_key_scope_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsAccessKeyScopeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_key_scope_owner_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccessKeyScopeOwnerProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_access_key_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AccessKeyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics5, 1505590673, 36771, 19557, 186, 27, 64, 223, 56, 85, 108, 187);
RT_INTERFACE!{static interface IUIElementStatics5(IUIElementStatics5Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics5] {
    fn get_LightsProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_KeyTipPlacementModeProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_KeyTipHorizontalOffsetProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_KeyTipVerticalOffsetProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_XYFocusKeyboardNavigationProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_XYFocusUpNavigationStrategyProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_XYFocusDownNavigationStrategyProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_XYFocusLeftNavigationStrategyProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_XYFocusRightNavigationStrategyProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_HighContrastAdjustmentProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn get_TabFocusNavigationProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT
}}
impl IUIElementStatics5 {
    #[inline] pub unsafe fn get_lights_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LightsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_tip_placement_mode_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_KeyTipPlacementModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_tip_horizontal_offset_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_KeyTipHorizontalOffsetProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_key_tip_vertical_offset_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_KeyTipVerticalOffsetProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_keyboard_navigation_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusKeyboardNavigationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_up_navigation_strategy_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusUpNavigationStrategyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_down_navigation_strategy_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusDownNavigationStrategyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_left_navigation_strategy_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusLeftNavigationStrategyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_right_navigation_strategy_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusRightNavigationStrategyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_high_contrast_adjustment_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HighContrastAdjustmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_focus_navigation_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TabFocusNavigationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics6, 1685980087, 874, 19946, 149, 64, 29, 215, 253, 18, 102, 241);
RT_INTERFACE!{static interface IUIElementStatics6(IUIElementStatics6Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics6] {
    fn get_GettingFocusEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_LosingFocusEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_NoFocusCandidateFoundEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT
}}
impl IUIElementStatics6 {
    #[inline] pub unsafe fn get_getting_focus_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GettingFocusEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_losing_focus_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LosingFocusEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_no_focus_candidate_found_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NoFocusCandidateFoundEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUIElementStatics7, 3667608723, 42645, 16709, 174, 147, 136, 128, 36, 57, 106, 15);
RT_INTERFACE!{static interface IUIElementStatics7(IUIElementStatics7Vtbl): IInspectable(IInspectableVtbl) [IID_IUIElementStatics7] {
    fn get_PreviewKeyDownEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_CharacterReceivedEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT,
    fn get_PreviewKeyUpEvent(&self, out: *mut *mut RoutedEvent) -> HRESULT
}}
impl IUIElementStatics7 {
    #[inline] pub unsafe fn get_preview_key_down_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreviewKeyDownEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_received_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CharacterReceivedEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_preview_key_up_event(&self) -> Result<ComPtr<RoutedEvent>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreviewKeyUpEvent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IUnhandledExceptionEventArgs, 1915758236, 1358, 19699, 134, 197, 190, 144, 235, 104, 99, 213);
RT_INTERFACE!{interface IUnhandledExceptionEventArgs(IUnhandledExceptionEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IUnhandledExceptionEventArgs] {
    fn get_Exception(&self, out: *mut super::super::foundation::HResult) -> HRESULT,
    fn get_Message(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl IUnhandledExceptionEventArgs {
    #[inline] pub unsafe fn get_exception(&self) -> Result<super::super::foundation::HResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Exception)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_message(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Message)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class UnhandledExceptionEventArgs: IUnhandledExceptionEventArgs}
DEFINE_IID!(IID_UnhandledExceptionEventHandler, 2457134781, 18849, 18776, 190, 238, 208, 225, 149, 135, 182, 227);
RT_DELEGATE!{delegate UnhandledExceptionEventHandler(UnhandledExceptionEventHandlerVtbl, UnhandledExceptionEventHandlerImpl) [IID_UnhandledExceptionEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut UnhandledExceptionEventArgs) -> HRESULT
}}
impl UnhandledExceptionEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &UnhandledExceptionEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum VerticalAlignment: i32 {
    Top (VerticalAlignment_Top) = 0, Center (VerticalAlignment_Center) = 1, Bottom (VerticalAlignment_Bottom) = 2, Stretch (VerticalAlignment_Stretch) = 3,
}}
RT_ENUM! { enum Visibility: i32 {
    Visible (Visibility_Visible) = 0, Collapsed (Visibility_Collapsed) = 1,
}}
DEFINE_IID!(IID_IVisualState, 1663086588, 49946, 17488, 175, 222, 246, 234, 123, 209, 245, 134);
RT_INTERFACE!{interface IVisualState(IVisualStateVtbl): IInspectable(IInspectableVtbl) [IID_IVisualState] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Storyboard(&self, out: *mut *mut media::animation::Storyboard) -> HRESULT,
    fn put_Storyboard(&self, value: *mut media::animation::Storyboard) -> HRESULT
}}
impl IVisualState {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_storyboard(&self) -> Result<ComPtr<media::animation::Storyboard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Storyboard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_storyboard(&self, value: &media::animation::Storyboard) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Storyboard)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VisualState: IVisualState}
impl RtActivatable<IActivationFactory> for VisualState {}
DEFINE_CLSID!(VisualState(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,86,105,115,117,97,108,83,116,97,116,101,0]) [CLSID_VisualState]);
DEFINE_IID!(IID_IVisualState2, 262207638, 25792, 17915, 141, 36, 251, 131, 41, 140, 13, 147);
RT_INTERFACE!{interface IVisualState2(IVisualState2Vtbl): IInspectable(IInspectableVtbl) [IID_IVisualState2] {
    fn get_Setters(&self, out: *mut *mut SetterBaseCollection) -> HRESULT,
    fn get_StateTriggers(&self, out: *mut *mut super::super::foundation::collections::IVector<StateTriggerBase>) -> HRESULT
}}
impl IVisualState2 {
    #[inline] pub unsafe fn get_setters(&self) -> Result<ComPtr<SetterBaseCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Setters)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_state_triggers(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<StateTriggerBase>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StateTriggers)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVisualStateChangedEventArgs, 4263602865, 62239, 18321, 137, 137, 199, 14, 29, 155, 89, 255);
RT_INTERFACE!{interface IVisualStateChangedEventArgs(IVisualStateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateChangedEventArgs] {
    fn get_OldState(&self, out: *mut *mut VisualState) -> HRESULT,
    fn put_OldState(&self, value: *mut VisualState) -> HRESULT,
    fn get_NewState(&self, out: *mut *mut VisualState) -> HRESULT,
    fn put_NewState(&self, value: *mut VisualState) -> HRESULT,
    fn get_Control(&self, out: *mut *mut controls::Control) -> HRESULT,
    fn put_Control(&self, value: *mut controls::Control) -> HRESULT
}}
impl IVisualStateChangedEventArgs {
    #[inline] pub unsafe fn get_old_state(&self) -> Result<ComPtr<VisualState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OldState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_old_state(&self, value: &VisualState) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OldState)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_state(&self) -> Result<ComPtr<VisualState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_new_state(&self, value: &VisualState) -> Result<()> {
        let hr = ((*self.lpVtbl).put_NewState)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_control(&self) -> Result<ComPtr<controls::Control>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Control)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_control(&self, value: &controls::Control) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Control)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VisualStateChangedEventArgs: IVisualStateChangedEventArgs}
impl RtActivatable<IActivationFactory> for VisualStateChangedEventArgs {}
DEFINE_CLSID!(VisualStateChangedEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,86,105,115,117,97,108,83,116,97,116,101,67,104,97,110,103,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_VisualStateChangedEventArgs]);
DEFINE_IID!(IID_VisualStateChangedEventHandler, 3872766933, 57385, 17318, 179, 109, 132, 168, 16, 66, 215, 116);
RT_DELEGATE!{delegate VisualStateChangedEventHandler(VisualStateChangedEventHandlerVtbl, VisualStateChangedEventHandlerImpl) [IID_VisualStateChangedEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut VisualStateChangedEventArgs) -> HRESULT
}}
impl VisualStateChangedEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &VisualStateChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVisualStateGroup, 3841579428, 57384, 17630, 155, 21, 73, 41, 174, 10, 38, 194);
RT_INTERFACE!{interface IVisualStateGroup(IVisualStateGroupVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateGroup] {
    fn get_Name(&self, out: *mut HSTRING) -> HRESULT,
    fn get_Transitions(&self, out: *mut *mut super::super::foundation::collections::IVector<VisualTransition>) -> HRESULT,
    fn get_States(&self, out: *mut *mut super::super::foundation::collections::IVector<VisualState>) -> HRESULT,
    fn get_CurrentState(&self, out: *mut *mut VisualState) -> HRESULT,
    fn add_CurrentStateChanged(&self, value: *mut VisualStateChangedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CurrentStateChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_CurrentStateChanging(&self, value: *mut VisualStateChangedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CurrentStateChanging(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT
}}
impl IVisualStateGroup {
    #[inline] pub unsafe fn get_name(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Name)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_transitions(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<VisualTransition>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Transitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_states(&self) -> Result<ComPtr<super::super::foundation::collections::IVector<VisualState>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_States)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_state(&self) -> Result<ComPtr<VisualState>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CurrentState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_current_state_changed(&self, value: &VisualStateChangedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CurrentStateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_current_state_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CurrentStateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_current_state_changing(&self, value: &VisualStateChangedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CurrentStateChanging)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_current_state_changing(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CurrentStateChanging)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VisualStateGroup: IVisualStateGroup}
impl RtActivatable<IActivationFactory> for VisualStateGroup {}
DEFINE_CLSID!(VisualStateGroup(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,86,105,115,117,97,108,83,116,97,116,101,71,114,111,117,112,0]) [CLSID_VisualStateGroup]);
DEFINE_IID!(IID_IVisualStateManager, 1876598682, 28587, 16658, 146, 88, 16, 6, 163, 195, 71, 110);
RT_INTERFACE!{interface IVisualStateManager(IVisualStateManagerVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateManager] {
    
}}
RT_CLASS!{class VisualStateManager: IVisualStateManager}
impl RtActivatable<IVisualStateManagerStatics> for VisualStateManager {}
impl VisualStateManager {
    #[inline] pub fn get_visual_state_groups(obj: &FrameworkElement) -> Result<ComPtr<super::super::foundation::collections::IVector<VisualStateGroup>>> { unsafe {
        <Self as RtActivatable<IVisualStateManagerStatics>>::get_activation_factory().get_visual_state_groups(obj)
    }}
    #[inline] pub fn get_custom_visual_state_manager_property() -> Result<ComPtr<DependencyProperty>> { unsafe {
        <Self as RtActivatable<IVisualStateManagerStatics>>::get_activation_factory().get_custom_visual_state_manager_property()
    }}
    #[inline] pub fn get_custom_visual_state_manager(obj: &FrameworkElement) -> Result<ComPtr<VisualStateManager>> { unsafe {
        <Self as RtActivatable<IVisualStateManagerStatics>>::get_activation_factory().get_custom_visual_state_manager(obj)
    }}
    #[inline] pub fn set_custom_visual_state_manager(obj: &FrameworkElement, value: &VisualStateManager) -> Result<()> { unsafe {
        <Self as RtActivatable<IVisualStateManagerStatics>>::get_activation_factory().set_custom_visual_state_manager(obj, value)
    }}
    #[inline] pub fn go_to_state(control: &controls::Control, stateName: &HStringArg, useTransitions: bool) -> Result<bool> { unsafe {
        <Self as RtActivatable<IVisualStateManagerStatics>>::get_activation_factory().go_to_state(control, stateName, useTransitions)
    }}
}
DEFINE_CLSID!(VisualStateManager(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,86,105,115,117,97,108,83,116,97,116,101,77,97,110,97,103,101,114,0]) [CLSID_VisualStateManager]);
DEFINE_IID!(IID_IVisualStateManagerFactory, 2246416637, 42357, 18358, 158, 48, 56, 60, 208, 133, 133, 242);
RT_INTERFACE!{interface IVisualStateManagerFactory(IVisualStateManagerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateManagerFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut VisualStateManager) -> HRESULT
}}
impl IVisualStateManagerFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<VisualStateManager>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVisualStateManagerOverrides, 1248235790, 31097, 17352, 143, 244, 236, 97, 34, 117, 0, 6);
RT_INTERFACE!{interface IVisualStateManagerOverrides(IVisualStateManagerOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateManagerOverrides] {
    fn GoToStateCore(&self, control: *mut controls::Control, templateRoot: *mut FrameworkElement, stateName: HSTRING, group: *mut VisualStateGroup, state: *mut VisualState, useTransitions: bool, out: *mut bool) -> HRESULT
}}
impl IVisualStateManagerOverrides {
    #[inline] pub unsafe fn go_to_state_core(&self, control: &controls::Control, templateRoot: &FrameworkElement, stateName: &HStringArg, group: &VisualStateGroup, state: &VisualState, useTransitions: bool) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GoToStateCore)(self as *const _ as *mut _, control as *const _ as *mut _, templateRoot as *const _ as *mut _, stateName.get(), group as *const _ as *mut _, state as *const _ as *mut _, useTransitions, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVisualStateManagerProtected, 1262192192, 45239, 16460, 158, 244, 217, 73, 100, 14, 36, 93);
RT_INTERFACE!{interface IVisualStateManagerProtected(IVisualStateManagerProtectedVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateManagerProtected] {
    fn RaiseCurrentStateChanging(&self, stateGroup: *mut VisualStateGroup, oldState: *mut VisualState, newState: *mut VisualState, control: *mut controls::Control) -> HRESULT,
    fn RaiseCurrentStateChanged(&self, stateGroup: *mut VisualStateGroup, oldState: *mut VisualState, newState: *mut VisualState, control: *mut controls::Control) -> HRESULT
}}
impl IVisualStateManagerProtected {
    #[inline] pub unsafe fn raise_current_state_changing(&self, stateGroup: &VisualStateGroup, oldState: &VisualState, newState: &VisualState, control: &controls::Control) -> Result<()> {
        let hr = ((*self.lpVtbl).RaiseCurrentStateChanging)(self as *const _ as *mut _, stateGroup as *const _ as *mut _, oldState as *const _ as *mut _, newState as *const _ as *mut _, control as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn raise_current_state_changed(&self, stateGroup: &VisualStateGroup, oldState: &VisualState, newState: &VisualState, control: &controls::Control) -> Result<()> {
        let hr = ((*self.lpVtbl).RaiseCurrentStateChanged)(self as *const _ as *mut _, stateGroup as *const _ as *mut _, oldState as *const _ as *mut _, newState as *const _ as *mut _, control as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVisualStateManagerStatics, 30468576, 55059, 16718, 167, 78, 230, 62, 199, 172, 140, 61);
RT_INTERFACE!{static interface IVisualStateManagerStatics(IVisualStateManagerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IVisualStateManagerStatics] {
    fn GetVisualStateGroups(&self, obj: *mut FrameworkElement, out: *mut *mut super::super::foundation::collections::IVector<VisualStateGroup>) -> HRESULT,
    fn get_CustomVisualStateManagerProperty(&self, out: *mut *mut DependencyProperty) -> HRESULT,
    fn GetCustomVisualStateManager(&self, obj: *mut FrameworkElement, out: *mut *mut VisualStateManager) -> HRESULT,
    fn SetCustomVisualStateManager(&self, obj: *mut FrameworkElement, value: *mut VisualStateManager) -> HRESULT,
    fn GoToState(&self, control: *mut controls::Control, stateName: HSTRING, useTransitions: bool, out: *mut bool) -> HRESULT
}}
impl IVisualStateManagerStatics {
    #[inline] pub unsafe fn get_visual_state_groups(&self, obj: &FrameworkElement) -> Result<ComPtr<super::super::foundation::collections::IVector<VisualStateGroup>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetVisualStateGroups)(self as *const _ as *mut _, obj as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_visual_state_manager_property(&self) -> Result<ComPtr<DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CustomVisualStateManagerProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_custom_visual_state_manager(&self, obj: &FrameworkElement) -> Result<ComPtr<VisualStateManager>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetCustomVisualStateManager)(self as *const _ as *mut _, obj as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_custom_visual_state_manager(&self, obj: &FrameworkElement, value: &VisualStateManager) -> Result<()> {
        let hr = ((*self.lpVtbl).SetCustomVisualStateManager)(self as *const _ as *mut _, obj as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn go_to_state(&self, control: &controls::Control, stateName: &HStringArg, useTransitions: bool) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GoToState)(self as *const _ as *mut _, control as *const _ as *mut _, stateName.get(), useTransitions, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IVisualTransition, 1439010910, 11207, 16397, 170, 164, 26, 41, 129, 73, 30, 224);
RT_INTERFACE!{interface IVisualTransition(IVisualTransitionVtbl): IInspectable(IInspectableVtbl) [IID_IVisualTransition] {
    fn get_GeneratedDuration(&self, out: *mut Duration) -> HRESULT,
    fn put_GeneratedDuration(&self, value: Duration) -> HRESULT,
    fn get_GeneratedEasingFunction(&self, out: *mut *mut media::animation::EasingFunctionBase) -> HRESULT,
    fn put_GeneratedEasingFunction(&self, value: *mut media::animation::EasingFunctionBase) -> HRESULT,
    fn get_To(&self, out: *mut HSTRING) -> HRESULT,
    fn put_To(&self, value: HSTRING) -> HRESULT,
    fn get_From(&self, out: *mut HSTRING) -> HRESULT,
    fn put_From(&self, value: HSTRING) -> HRESULT,
    fn get_Storyboard(&self, out: *mut *mut media::animation::Storyboard) -> HRESULT,
    fn put_Storyboard(&self, value: *mut media::animation::Storyboard) -> HRESULT
}}
impl IVisualTransition {
    #[inline] pub unsafe fn get_generated_duration(&self) -> Result<Duration> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GeneratedDuration)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_generated_duration(&self, value: Duration) -> Result<()> {
        let hr = ((*self.lpVtbl).put_GeneratedDuration)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_generated_easing_function(&self) -> Result<ComPtr<media::animation::EasingFunctionBase>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GeneratedEasingFunction)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_generated_easing_function(&self, value: &media::animation::EasingFunctionBase) -> Result<()> {
        let hr = ((*self.lpVtbl).put_GeneratedEasingFunction)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_to(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_To)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_to(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_To)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_from(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_From)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_from(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_From)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_storyboard(&self) -> Result<ComPtr<media::animation::Storyboard>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Storyboard)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_storyboard(&self, value: &media::animation::Storyboard) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Storyboard)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class VisualTransition: IVisualTransition}
DEFINE_IID!(IID_IVisualTransitionFactory, 3933570639, 53728, 19886, 180, 41, 137, 252, 50, 39, 36, 244);
RT_INTERFACE!{interface IVisualTransitionFactory(IVisualTransitionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IVisualTransitionFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut VisualTransition) -> HRESULT
}}
impl IVisualTransitionFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<VisualTransition>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWindow, 846599805, 51702, 17965, 157, 226, 174, 76, 31, 216, 194, 229);
RT_INTERFACE!{interface IWindow(IWindowVtbl): IInspectable(IInspectableVtbl) [IID_IWindow] {
    fn get_Bounds(&self, out: *mut super::super::foundation::Rect) -> HRESULT,
    fn get_Visible(&self, out: *mut bool) -> HRESULT,
    fn get_Content(&self, out: *mut *mut UIElement) -> HRESULT,
    fn put_Content(&self, value: *mut UIElement) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_CoreWindow(&self, out: *mut *mut super::core::CoreWindow) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_Dispatcher(&self, out: *mut *mut super::core::CoreDispatcher) -> HRESULT,
    fn add_Activated(&self, value: *mut WindowActivatedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Activated(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, value: *mut WindowClosedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SizeChanged(&self, value: *mut WindowSizeChangedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SizeChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn add_VisibilityChanged(&self, value: *mut WindowVisibilityChangedEventHandler, out: *mut super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_VisibilityChanged(&self, token: super::super::foundation::EventRegistrationToken) -> HRESULT,
    fn Activate(&self) -> HRESULT,
    fn Close(&self) -> HRESULT
}}
impl IWindow {
    #[inline] pub unsafe fn get_bounds(&self) -> Result<super::super::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Visible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<UIElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content(&self, value: &UIElement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Content)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_core_window(&self) -> Result<ComPtr<super::core::CoreWindow>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CoreWindow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_dispatcher(&self) -> Result<ComPtr<super::core::CoreDispatcher>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Dispatcher)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_activated(&self, value: &WindowActivatedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Activated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_activated(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Activated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, value: &WindowClosedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_size_changed(&self, value: &WindowSizeChangedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SizeChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_size_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SizeChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_visibility_changed(&self, value: &WindowVisibilityChangedEventHandler) -> Result<super::super::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_VisibilityChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_visibility_changed(&self, token: super::super::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_VisibilityChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn activate(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Activate)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn close(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Close)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Window: IWindow}
impl RtActivatable<IWindowStatics> for Window {}
impl Window {
    #[inline] pub fn get_current() -> Result<ComPtr<Window>> { unsafe {
        <Self as RtActivatable<IWindowStatics>>::get_activation_factory().get_current()
    }}
}
DEFINE_CLSID!(Window(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,87,105,110,100,111,119,0]) [CLSID_Window]);
DEFINE_IID!(IID_IWindow2, 3548673439, 13558, 17538, 132, 53, 245, 82, 249, 178, 76, 200);
RT_INTERFACE!{interface IWindow2(IWindow2Vtbl): IInspectable(IInspectableVtbl) [IID_IWindow2] {
    fn SetTitleBar(&self, value: *mut UIElement) -> HRESULT
}}
impl IWindow2 {
    #[inline] pub unsafe fn set_title_bar(&self, value: &UIElement) -> Result<()> {
        let hr = ((*self.lpVtbl).SetTitleBar)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWindow3, 3071007901, 7221, 17962, 155, 151, 128, 141, 90, 249, 242, 142);
RT_INTERFACE!{interface IWindow3(IWindow3Vtbl): IInspectable(IInspectableVtbl) [IID_IWindow3] {
    #[cfg(feature="windows-ui")] fn get_Compositor(&self, out: *mut *mut super::composition::Compositor) -> HRESULT
}}
impl IWindow3 {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_compositor(&self) -> Result<ComPtr<super::composition::Compositor>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Compositor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_WindowActivatedEventHandler, 402809672, 34329, 19579, 181, 52, 206, 212, 93, 157, 226, 25);
RT_DELEGATE!{delegate WindowActivatedEventHandler(WindowActivatedEventHandlerVtbl, WindowActivatedEventHandlerImpl) [IID_WindowActivatedEventHandler] {
    #[cfg(feature="windows-ui")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::core::WindowActivatedEventArgs) -> HRESULT
}}
impl WindowActivatedEventHandler {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::core::WindowActivatedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_WindowClosedEventHandler, 230199649, 8407, 17887, 145, 34, 186, 137, 87, 103, 3, 186);
RT_DELEGATE!{delegate WindowClosedEventHandler(WindowClosedEventHandlerVtbl, WindowClosedEventHandlerImpl) [IID_WindowClosedEventHandler] {
    #[cfg(feature="windows-ui")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::core::CoreWindowEventArgs) -> HRESULT
}}
impl WindowClosedEventHandler {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::core::CoreWindowEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWindowCreatedEventArgs, 834081904, 65279, 18004, 175, 72, 155, 57, 138, 181, 119, 43);
RT_INTERFACE!{interface IWindowCreatedEventArgs(IWindowCreatedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IWindowCreatedEventArgs] {
    fn get_Window(&self, out: *mut *mut Window) -> HRESULT
}}
impl IWindowCreatedEventArgs {
    #[inline] pub unsafe fn get_window(&self) -> Result<ComPtr<Window>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Window)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class WindowCreatedEventArgs: IWindowCreatedEventArgs}
DEFINE_IID!(IID_WindowSizeChangedEventHandler, 1545717570, 11501, 20441, 186, 56, 113, 24, 212, 14, 150, 107);
RT_DELEGATE!{delegate WindowSizeChangedEventHandler(WindowSizeChangedEventHandlerVtbl, WindowSizeChangedEventHandlerImpl) [IID_WindowSizeChangedEventHandler] {
    #[cfg(feature="windows-ui")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::core::WindowSizeChangedEventArgs) -> HRESULT
}}
impl WindowSizeChangedEventHandler {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::core::WindowSizeChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IWindowStatics, 2469561353, 20129, 19194, 131, 220, 12, 78, 115, 232, 139, 177);
RT_INTERFACE!{static interface IWindowStatics(IWindowStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IWindowStatics] {
    fn get_Current(&self, out: *mut *mut Window) -> HRESULT
}}
impl IWindowStatics {
    #[inline] pub unsafe fn get_current(&self) -> Result<ComPtr<Window>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Current)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_WindowVisibilityChangedEventHandler, 272657110, 45200, 19018, 178, 173, 214, 130, 223, 39, 19, 15);
RT_DELEGATE!{delegate WindowVisibilityChangedEventHandler(WindowVisibilityChangedEventHandlerVtbl, WindowVisibilityChangedEventHandlerImpl) [IID_WindowVisibilityChangedEventHandler] {
    #[cfg(feature="windows-ui")] fn Invoke(&self, sender: *mut IInspectable, e: *mut super::core::VisibilityChangedEventArgs) -> HRESULT
}}
impl WindowVisibilityChangedEventHandler {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &super::core::VisibilityChangedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
pub mod controls { // Windows.UI.Xaml.Controls
use ::prelude::*;
DEFINE_IID!(IID_IAppBar, 2064630355, 34469, 19267, 152, 114, 11, 138, 98, 52, 183, 75);
RT_INTERFACE!{interface IAppBar(IAppBarVtbl): IInspectable(IInspectableVtbl) [IID_IAppBar] {
    fn get_IsOpen(&self, out: *mut bool) -> HRESULT,
    fn put_IsOpen(&self, value: bool) -> HRESULT,
    fn get_IsSticky(&self, out: *mut bool) -> HRESULT,
    fn put_IsSticky(&self, value: bool) -> HRESULT,
    fn add_Opened(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBar {
    #[inline] pub unsafe fn get_is_open(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOpen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_open(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOpen)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_sticky(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSticky)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_sticky(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSticky)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_opened(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Opened)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Opened)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBar: IAppBar}
impl RtActivatable<IAppBarStatics> for AppBar {}
impl RtActivatable<IAppBarStatics2> for AppBar {}
impl RtActivatable<IAppBarStatics4> for AppBar {}
impl AppBar {
    #[inline] pub fn get_is_open_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarStatics>>::get_activation_factory().get_is_open_property()
    }}
    #[inline] pub fn get_is_sticky_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarStatics>>::get_activation_factory().get_is_sticky_property()
    }}
    #[inline] pub fn get_closed_display_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarStatics2>>::get_activation_factory().get_closed_display_mode_property()
    }}
    #[inline] pub fn get_light_dismiss_overlay_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarStatics4>>::get_activation_factory().get_light_dismiss_overlay_mode_property()
    }}
}
DEFINE_CLSID!(AppBar(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,112,112,66,97,114,0]) [CLSID_AppBar]);
DEFINE_IID!(IID_IAppBar2, 3282769843, 31447, 18038, 153, 16, 127, 227, 240, 232, 233, 147);
RT_INTERFACE!{interface IAppBar2(IAppBar2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBar2] {
    fn get_ClosedDisplayMode(&self, out: *mut AppBarClosedDisplayMode) -> HRESULT,
    fn put_ClosedDisplayMode(&self, value: AppBarClosedDisplayMode) -> HRESULT
}}
impl IAppBar2 {
    #[inline] pub unsafe fn get_closed_display_mode(&self) -> Result<AppBarClosedDisplayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ClosedDisplayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_closed_display_mode(&self, value: AppBarClosedDisplayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ClosedDisplayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBar3, 2552954911, 29998, 20090, 176, 85, 84, 128, 44, 158, 167, 73);
RT_INTERFACE!{interface IAppBar3(IAppBar3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBar3] {
    fn get_TemplateSettings(&self, out: *mut *mut primitives::AppBarTemplateSettings) -> HRESULT,
    fn add_Opening(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Opening(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closing(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAppBar3 {
    #[inline] pub unsafe fn get_template_settings(&self) -> Result<ComPtr<primitives::AppBarTemplateSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TemplateSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_opening(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Opening)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_opening(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Opening)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closing(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closing)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closing)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBar4, 2498480333, 2660, 19875, 191, 67, 241, 49, 0, 164, 102, 5);
RT_INTERFACE!{interface IAppBar4(IAppBar4Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBar4] {
    fn get_LightDismissOverlayMode(&self, out: *mut LightDismissOverlayMode) -> HRESULT,
    fn put_LightDismissOverlayMode(&self, value: LightDismissOverlayMode) -> HRESULT
}}
impl IAppBar4 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode(&self) -> Result<LightDismissOverlayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_light_dismiss_overlay_mode(&self, value: LightDismissOverlayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LightDismissOverlayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarButton, 1146725457, 27112, 17420, 152, 150, 75, 180, 245, 246, 66, 209);
RT_INTERFACE!{interface IAppBarButton(IAppBarButtonVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarButton] {
    fn get_Label(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Label(&self, value: HSTRING) -> HRESULT,
    fn get_Icon(&self, out: *mut *mut IconElement) -> HRESULT,
    fn put_Icon(&self, value: *mut IconElement) -> HRESULT
}}
impl IAppBarButton {
    #[inline] pub unsafe fn get_label(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Label)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_label(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Label)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_icon(&self) -> Result<ComPtr<IconElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Icon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_icon(&self, value: &IconElement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Icon)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBarButton: IAppBarButton}
impl RtActivatable<IAppBarButtonStatics> for AppBarButton {}
impl RtActivatable<IAppBarButtonStatics3> for AppBarButton {}
impl AppBarButton {
    #[inline] pub fn get_label_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarButtonStatics>>::get_activation_factory().get_label_property()
    }}
    #[inline] pub fn get_icon_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarButtonStatics>>::get_activation_factory().get_icon_property()
    }}
    #[inline] pub fn get_is_compact_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarButtonStatics>>::get_activation_factory().get_is_compact_property()
    }}
    #[inline] pub fn get_label_position_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarButtonStatics3>>::get_activation_factory().get_label_position_property()
    }}
    #[inline] pub fn get_is_in_overflow_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarButtonStatics3>>::get_activation_factory().get_is_in_overflow_property()
    }}
    #[inline] pub fn get_dynamic_overflow_order_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarButtonStatics3>>::get_activation_factory().get_dynamic_overflow_order_property()
    }}
}
DEFINE_CLSID!(AppBarButton(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,112,112,66,97,114,66,117,116,116,111,110,0]) [CLSID_AppBarButton]);
DEFINE_IID!(IID_IAppBarButton3, 187179344, 6539, 20100, 143, 28, 159, 106, 139, 162, 103, 167);
RT_INTERFACE!{interface IAppBarButton3(IAppBarButton3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarButton3] {
    fn get_LabelPosition(&self, out: *mut CommandBarLabelPosition) -> HRESULT,
    fn put_LabelPosition(&self, value: CommandBarLabelPosition) -> HRESULT
}}
impl IAppBarButton3 {
    #[inline] pub unsafe fn get_label_position(&self) -> Result<CommandBarLabelPosition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LabelPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_label_position(&self, value: CommandBarLabelPosition) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LabelPosition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarButtonFactory, 3183156150, 52014, 17014, 171, 214, 121, 53, 19, 5, 16, 224);
RT_INTERFACE!{interface IAppBarButtonFactory(IAppBarButtonFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarButtonFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut AppBarButton) -> HRESULT
}}
impl IAppBarButtonFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<AppBarButton>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarButtonStatics, 2093814758, 21249, 16511, 135, 78, 220, 145, 96, 170, 7, 175);
RT_INTERFACE!{static interface IAppBarButtonStatics(IAppBarButtonStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarButtonStatics] {
    fn get_LabelProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IconProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsCompactProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarButtonStatics {
    #[inline] pub unsafe fn get_label_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LabelProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_icon_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IconProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_compact_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsCompactProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarButtonStatics3, 1299968788, 11998, 17192, 137, 6, 117, 42, 31, 39, 205, 250);
RT_INTERFACE!{static interface IAppBarButtonStatics3(IAppBarButtonStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarButtonStatics3] {
    fn get_LabelPositionProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsInOverflowProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DynamicOverflowOrderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarButtonStatics3 {
    #[inline] pub unsafe fn get_label_position_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LabelPositionProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_in_overflow_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsInOverflowProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dynamic_overflow_order_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DynamicOverflowOrderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AppBarClosedDisplayMode: i32 {
    Compact (AppBarClosedDisplayMode_Compact) = 0, Minimal (AppBarClosedDisplayMode_Minimal) = 1, Hidden (AppBarClosedDisplayMode_Hidden) = 2,
}}
DEFINE_IID!(IID_IAppBarFactory, 1632045265, 36453, 17355, 146, 215, 142, 238, 23, 81, 95, 141);
RT_INTERFACE!{interface IAppBarFactory(IAppBarFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut AppBar) -> HRESULT
}}
impl IAppBarFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<AppBar>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarOverrides, 4026787042, 31503, 20298, 151, 13, 174, 138, 14, 170, 155, 112);
RT_INTERFACE!{interface IAppBarOverrides(IAppBarOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarOverrides] {
    fn OnClosed(&self, e: *mut IInspectable) -> HRESULT,
    fn OnOpened(&self, e: *mut IInspectable) -> HRESULT
}}
impl IAppBarOverrides {
    #[inline] pub unsafe fn on_closed(&self, e: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnClosed)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_opened(&self, e: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnOpened)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarOverrides3, 1093385160, 20944, 19273, 171, 98, 163, 221, 107, 220, 178, 152);
RT_INTERFACE!{interface IAppBarOverrides3(IAppBarOverrides3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarOverrides3] {
    fn OnClosing(&self, e: *mut IInspectable) -> HRESULT,
    fn OnOpening(&self, e: *mut IInspectable) -> HRESULT
}}
impl IAppBarOverrides3 {
    #[inline] pub unsafe fn on_closing(&self, e: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnClosing)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_opening(&self, e: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnOpening)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarSeparator, 453481889, 7105, 19795, 149, 234, 251, 10, 44, 204, 201, 5);
RT_INTERFACE!{interface IAppBarSeparator(IAppBarSeparatorVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarSeparator] {
    
}}
RT_CLASS!{class AppBarSeparator: IAppBarSeparator}
impl RtActivatable<IAppBarSeparatorStatics> for AppBarSeparator {}
impl RtActivatable<IAppBarSeparatorStatics3> for AppBarSeparator {}
impl AppBarSeparator {
    #[inline] pub fn get_is_compact_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarSeparatorStatics>>::get_activation_factory().get_is_compact_property()
    }}
    #[inline] pub fn get_is_in_overflow_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarSeparatorStatics3>>::get_activation_factory().get_is_in_overflow_property()
    }}
    #[inline] pub fn get_dynamic_overflow_order_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarSeparatorStatics3>>::get_activation_factory().get_dynamic_overflow_order_property()
    }}
}
DEFINE_CLSID!(AppBarSeparator(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,112,112,66,97,114,83,101,112,97,114,97,116,111,114,0]) [CLSID_AppBarSeparator]);
DEFINE_IID!(IID_IAppBarSeparatorFactory, 98182605, 62471, 18654, 139, 80, 255, 135, 209, 226, 129, 143);
RT_INTERFACE!{interface IAppBarSeparatorFactory(IAppBarSeparatorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarSeparatorFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut AppBarSeparator) -> HRESULT
}}
impl IAppBarSeparatorFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<AppBarSeparator>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarSeparatorStatics, 938620036, 23349, 18019, 167, 93, 242, 213, 12, 185, 198, 25);
RT_INTERFACE!{static interface IAppBarSeparatorStatics(IAppBarSeparatorStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarSeparatorStatics] {
    fn get_IsCompactProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarSeparatorStatics {
    #[inline] pub unsafe fn get_is_compact_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsCompactProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarSeparatorStatics3, 919032825, 29555, 20062, 155, 164, 195, 98, 42, 0, 60, 78);
RT_INTERFACE!{static interface IAppBarSeparatorStatics3(IAppBarSeparatorStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarSeparatorStatics3] {
    fn get_IsInOverflowProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DynamicOverflowOrderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarSeparatorStatics3 {
    #[inline] pub unsafe fn get_is_in_overflow_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsInOverflowProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dynamic_overflow_order_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DynamicOverflowOrderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarStatics, 2042330765, 56489, 19295, 164, 72, 55, 177, 50, 56, 237, 118);
RT_INTERFACE!{static interface IAppBarStatics(IAppBarStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarStatics] {
    fn get_IsOpenProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsStickyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarStatics {
    #[inline] pub unsafe fn get_is_open_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsOpenProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_sticky_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsStickyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarStatics2, 572741097, 900, 18910, 135, 56, 223, 201, 212, 9, 172, 93);
RT_INTERFACE!{static interface IAppBarStatics2(IAppBarStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarStatics2] {
    fn get_ClosedDisplayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarStatics2 {
    #[inline] pub unsafe fn get_closed_display_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ClosedDisplayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarStatics4, 3120695342, 4453, 17489, 148, 179, 235, 58, 199, 62, 65, 150);
RT_INTERFACE!{static interface IAppBarStatics4(IAppBarStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarStatics4] {
    fn get_LightDismissOverlayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarStatics4 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarToggleButton, 781272120, 64851, 19341, 133, 139, 54, 68, 38, 159, 142, 77);
RT_INTERFACE!{interface IAppBarToggleButton(IAppBarToggleButtonVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarToggleButton] {
    fn get_Label(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Label(&self, value: HSTRING) -> HRESULT,
    fn get_Icon(&self, out: *mut *mut IconElement) -> HRESULT,
    fn put_Icon(&self, value: *mut IconElement) -> HRESULT
}}
impl IAppBarToggleButton {
    #[inline] pub unsafe fn get_label(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Label)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_label(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Label)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_icon(&self) -> Result<ComPtr<IconElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Icon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_icon(&self, value: &IconElement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Icon)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AppBarToggleButton: IAppBarToggleButton}
impl RtActivatable<IAppBarToggleButtonStatics> for AppBarToggleButton {}
impl RtActivatable<IAppBarToggleButtonStatics3> for AppBarToggleButton {}
impl AppBarToggleButton {
    #[inline] pub fn get_label_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarToggleButtonStatics>>::get_activation_factory().get_label_property()
    }}
    #[inline] pub fn get_icon_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarToggleButtonStatics>>::get_activation_factory().get_icon_property()
    }}
    #[inline] pub fn get_is_compact_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarToggleButtonStatics>>::get_activation_factory().get_is_compact_property()
    }}
    #[inline] pub fn get_label_position_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarToggleButtonStatics3>>::get_activation_factory().get_label_position_property()
    }}
    #[inline] pub fn get_is_in_overflow_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarToggleButtonStatics3>>::get_activation_factory().get_is_in_overflow_property()
    }}
    #[inline] pub fn get_dynamic_overflow_order_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAppBarToggleButtonStatics3>>::get_activation_factory().get_dynamic_overflow_order_property()
    }}
}
DEFINE_CLSID!(AppBarToggleButton(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,112,112,66,97,114,84,111,103,103,108,101,66,117,116,116,111,110,0]) [CLSID_AppBarToggleButton]);
DEFINE_IID!(IID_IAppBarToggleButton3, 4019881445, 5887, 19826, 185, 232, 155, 134, 30, 175, 132, 168);
RT_INTERFACE!{interface IAppBarToggleButton3(IAppBarToggleButton3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarToggleButton3] {
    fn get_LabelPosition(&self, out: *mut CommandBarLabelPosition) -> HRESULT,
    fn put_LabelPosition(&self, value: CommandBarLabelPosition) -> HRESULT
}}
impl IAppBarToggleButton3 {
    #[inline] pub unsafe fn get_label_position(&self) -> Result<CommandBarLabelPosition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LabelPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_label_position(&self, value: CommandBarLabelPosition) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LabelPosition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarToggleButtonFactory, 42641364, 36692, 17830, 159, 144, 19, 96, 86, 86, 215, 147);
RT_INTERFACE!{interface IAppBarToggleButtonFactory(IAppBarToggleButtonFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarToggleButtonFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut AppBarToggleButton) -> HRESULT
}}
impl IAppBarToggleButtonFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<AppBarToggleButton>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarToggleButtonStatics, 4267356054, 31017, 19873, 170, 103, 205, 223, 115, 163, 228, 181);
RT_INTERFACE!{static interface IAppBarToggleButtonStatics(IAppBarToggleButtonStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAppBarToggleButtonStatics] {
    fn get_LabelProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IconProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsCompactProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarToggleButtonStatics {
    #[inline] pub unsafe fn get_label_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LabelProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_icon_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IconProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_compact_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsCompactProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAppBarToggleButtonStatics3, 3175900607, 11997, 17617, 172, 213, 53, 192, 14, 47, 33, 188);
RT_INTERFACE!{static interface IAppBarToggleButtonStatics3(IAppBarToggleButtonStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IAppBarToggleButtonStatics3] {
    fn get_LabelPositionProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsInOverflowProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DynamicOverflowOrderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAppBarToggleButtonStatics3 {
    #[inline] pub unsafe fn get_label_position_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LabelPositionProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_in_overflow_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsInOverflowProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dynamic_overflow_order_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DynamicOverflowOrderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAutoSuggestBox, 272538387, 13312, 18966, 144, 185, 105, 18, 191, 6, 151, 79);
RT_INTERFACE!{interface IAutoSuggestBox(IAutoSuggestBoxVtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBox] {
    fn get_MaxSuggestionListHeight(&self, out: *mut f64) -> HRESULT,
    fn put_MaxSuggestionListHeight(&self, value: f64) -> HRESULT,
    fn get_IsSuggestionListOpen(&self, out: *mut bool) -> HRESULT,
    fn put_IsSuggestionListOpen(&self, value: bool) -> HRESULT,
    fn get_TextMemberPath(&self, out: *mut HSTRING) -> HRESULT,
    fn put_TextMemberPath(&self, value: HSTRING) -> HRESULT,
    fn get_Text(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Text(&self, value: HSTRING) -> HRESULT,
    fn get_UpdateTextOnSelect(&self, out: *mut bool) -> HRESULT,
    fn put_UpdateTextOnSelect(&self, value: bool) -> HRESULT,
    fn get_PlaceholderText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PlaceholderText(&self, value: HSTRING) -> HRESULT,
    fn get_Header(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Header(&self, value: *mut IInspectable) -> HRESULT,
    fn get_AutoMaximizeSuggestionArea(&self, out: *mut bool) -> HRESULT,
    fn put_AutoMaximizeSuggestionArea(&self, value: bool) -> HRESULT,
    fn get_TextBoxStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_TextBoxStyle(&self, value: *mut super::Style) -> HRESULT,
    fn add_SuggestionChosen(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<AutoSuggestBox, AutoSuggestBoxSuggestionChosenEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SuggestionChosen(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_TextChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<AutoSuggestBox, AutoSuggestBoxTextChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_TextChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAutoSuggestBox {
    #[inline] pub unsafe fn get_max_suggestion_list_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSuggestionListHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_suggestion_list_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxSuggestionListHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_suggestion_list_open(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSuggestionListOpen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_suggestion_list_open(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSuggestionListOpen)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_member_path(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextMemberPath)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_member_path(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextMemberPath)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Text)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Text)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_update_text_on_select(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UpdateTextOnSelect)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_update_text_on_select(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UpdateTextOnSelect)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_placeholder_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaceholderText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Header)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_maximize_suggestion_area(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_AutoMaximizeSuggestionArea)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_auto_maximize_suggestion_area(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_AutoMaximizeSuggestionArea)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_box_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextBoxStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_box_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextBoxStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_suggestion_chosen(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<AutoSuggestBox, AutoSuggestBoxSuggestionChosenEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SuggestionChosen)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_suggestion_chosen(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SuggestionChosen)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_text_changed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<AutoSuggestBox, AutoSuggestBoxTextChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_TextChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_text_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_TextChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class AutoSuggestBox: IAutoSuggestBox}
impl RtActivatable<IAutoSuggestBoxStatics> for AutoSuggestBox {}
impl RtActivatable<IAutoSuggestBoxStatics2> for AutoSuggestBox {}
impl RtActivatable<IAutoSuggestBoxStatics3> for AutoSuggestBox {}
impl RtActivatable<IActivationFactory> for AutoSuggestBox {}
impl AutoSuggestBox {
    #[inline] pub fn get_max_suggestion_list_height_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_max_suggestion_list_height_property()
    }}
    #[inline] pub fn get_is_suggestion_list_open_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_is_suggestion_list_open_property()
    }}
    #[inline] pub fn get_text_member_path_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_text_member_path_property()
    }}
    #[inline] pub fn get_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_text_property()
    }}
    #[inline] pub fn get_update_text_on_select_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_update_text_on_select_property()
    }}
    #[inline] pub fn get_placeholder_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_placeholder_text_property()
    }}
    #[inline] pub fn get_header_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_header_property()
    }}
    #[inline] pub fn get_auto_maximize_suggestion_area_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_auto_maximize_suggestion_area_property()
    }}
    #[inline] pub fn get_text_box_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics>>::get_activation_factory().get_text_box_style_property()
    }}
    #[inline] pub fn get_query_icon_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics2>>::get_activation_factory().get_query_icon_property()
    }}
    #[inline] pub fn get_light_dismiss_overlay_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxStatics3>>::get_activation_factory().get_light_dismiss_overlay_mode_property()
    }}
}
DEFINE_CLSID!(AutoSuggestBox(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,117,116,111,83,117,103,103,101,115,116,66,111,120,0]) [CLSID_AutoSuggestBox]);
DEFINE_IID!(IID_IAutoSuggestBox2, 2861030878, 59001, 17842, 167, 201, 154, 237, 195, 157, 184, 134);
RT_INTERFACE!{interface IAutoSuggestBox2(IAutoSuggestBox2Vtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBox2] {
    fn get_QueryIcon(&self, out: *mut *mut IconElement) -> HRESULT,
    fn put_QueryIcon(&self, value: *mut IconElement) -> HRESULT,
    fn add_QuerySubmitted(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<AutoSuggestBox, AutoSuggestBoxQuerySubmittedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_QuerySubmitted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IAutoSuggestBox2 {
    #[inline] pub unsafe fn get_query_icon(&self) -> Result<ComPtr<IconElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryIcon)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_query_icon(&self, value: &IconElement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_QueryIcon)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_query_submitted(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<AutoSuggestBox, AutoSuggestBoxQuerySubmittedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_QuerySubmitted)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_query_submitted(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_QuerySubmitted)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAutoSuggestBox3, 2612788463, 62253, 16430, 144, 9, 5, 189, 186, 246, 51, 110);
RT_INTERFACE!{interface IAutoSuggestBox3(IAutoSuggestBox3Vtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBox3] {
    fn get_LightDismissOverlayMode(&self, out: *mut LightDismissOverlayMode) -> HRESULT,
    fn put_LightDismissOverlayMode(&self, value: LightDismissOverlayMode) -> HRESULT
}}
impl IAutoSuggestBox3 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode(&self) -> Result<LightDismissOverlayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_light_dismiss_overlay_mode(&self, value: LightDismissOverlayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LightDismissOverlayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAutoSuggestBoxQuerySubmittedEventArgs, 2027729174, 33162, 19637, 188, 167, 56, 44, 230, 221, 201, 13);
RT_INTERFACE!{interface IAutoSuggestBoxQuerySubmittedEventArgs(IAutoSuggestBoxQuerySubmittedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxQuerySubmittedEventArgs] {
    fn get_QueryText(&self, out: *mut HSTRING) -> HRESULT,
    fn get_ChosenSuggestion(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IAutoSuggestBoxQuerySubmittedEventArgs {
    #[inline] pub unsafe fn get_query_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_chosen_suggestion(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChosenSuggestion)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AutoSuggestBoxQuerySubmittedEventArgs: IAutoSuggestBoxQuerySubmittedEventArgs}
impl RtActivatable<IActivationFactory> for AutoSuggestBoxQuerySubmittedEventArgs {}
DEFINE_CLSID!(AutoSuggestBoxQuerySubmittedEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,117,116,111,83,117,103,103,101,115,116,66,111,120,81,117,101,114,121,83,117,98,109,105,116,116,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AutoSuggestBoxQuerySubmittedEventArgs]);
DEFINE_IID!(IID_IAutoSuggestBoxStatics, 3995256820, 49501, 20467, 138, 148, 245, 13, 253, 251, 232, 154);
RT_INTERFACE!{static interface IAutoSuggestBoxStatics(IAutoSuggestBoxStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxStatics] {
    fn get_MaxSuggestionListHeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsSuggestionListOpenProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TextMemberPathProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_UpdateTextOnSelectProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PlaceholderTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_AutoMaximizeSuggestionAreaProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TextBoxStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAutoSuggestBoxStatics {
    #[inline] pub unsafe fn get_max_suggestion_list_height_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxSuggestionListHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_suggestion_list_open_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsSuggestionListOpenProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_member_path_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextMemberPathProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_update_text_on_select_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UpdateTextOnSelectProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_auto_maximize_suggestion_area_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AutoMaximizeSuggestionAreaProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_box_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextBoxStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAutoSuggestBoxStatics2, 483563432, 36458, 16879, 169, 93, 113, 87, 220, 12, 113, 6);
RT_INTERFACE!{static interface IAutoSuggestBoxStatics2(IAutoSuggestBoxStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxStatics2] {
    fn get_QueryIconProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAutoSuggestBoxStatics2 {
    #[inline] pub unsafe fn get_query_icon_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_QueryIconProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAutoSuggestBoxStatics3, 753586909, 50389, 19122, 138, 19, 175, 221, 207, 6, 124, 134);
RT_INTERFACE!{static interface IAutoSuggestBoxStatics3(IAutoSuggestBoxStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxStatics3] {
    fn get_LightDismissOverlayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAutoSuggestBoxStatics3 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IAutoSuggestBoxSuggestionChosenEventArgs, 963605076, 7893, 19397, 160, 96, 101, 85, 48, 188, 166, 186);
RT_INTERFACE!{interface IAutoSuggestBoxSuggestionChosenEventArgs(IAutoSuggestBoxSuggestionChosenEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxSuggestionChosenEventArgs] {
    fn get_SelectedItem(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IAutoSuggestBoxSuggestionChosenEventArgs {
    #[inline] pub unsafe fn get_selected_item(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class AutoSuggestBoxSuggestionChosenEventArgs: IAutoSuggestBoxSuggestionChosenEventArgs}
impl RtActivatable<IActivationFactory> for AutoSuggestBoxSuggestionChosenEventArgs {}
DEFINE_CLSID!(AutoSuggestBoxSuggestionChosenEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,117,116,111,83,117,103,103,101,115,116,66,111,120,83,117,103,103,101,115,116,105,111,110,67,104,111,115,101,110,69,118,101,110,116,65,114,103,115,0]) [CLSID_AutoSuggestBoxSuggestionChosenEventArgs]);
DEFINE_IID!(IID_IAutoSuggestBoxTextChangedEventArgs, 980382292, 7893, 19397, 160, 96, 101, 85, 48, 188, 166, 186);
RT_INTERFACE!{interface IAutoSuggestBoxTextChangedEventArgs(IAutoSuggestBoxTextChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxTextChangedEventArgs] {
    fn get_Reason(&self, out: *mut AutoSuggestionBoxTextChangeReason) -> HRESULT,
    fn put_Reason(&self, value: AutoSuggestionBoxTextChangeReason) -> HRESULT,
    fn CheckCurrent(&self, out: *mut bool) -> HRESULT
}}
impl IAutoSuggestBoxTextChangedEventArgs {
    #[inline] pub unsafe fn get_reason(&self) -> Result<AutoSuggestionBoxTextChangeReason> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Reason)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_reason(&self, value: AutoSuggestionBoxTextChangeReason) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Reason)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn check_current(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).CheckCurrent)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class AutoSuggestBoxTextChangedEventArgs: IAutoSuggestBoxTextChangedEventArgs}
impl RtActivatable<IAutoSuggestBoxTextChangedEventArgsStatics> for AutoSuggestBoxTextChangedEventArgs {}
impl RtActivatable<IActivationFactory> for AutoSuggestBoxTextChangedEventArgs {}
impl AutoSuggestBoxTextChangedEventArgs {
    #[inline] pub fn get_reason_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IAutoSuggestBoxTextChangedEventArgsStatics>>::get_activation_factory().get_reason_property()
    }}
}
DEFINE_CLSID!(AutoSuggestBoxTextChangedEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,65,117,116,111,83,117,103,103,101,115,116,66,111,120,84,101,120,116,67,104,97,110,103,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_AutoSuggestBoxTextChangedEventArgs]);
DEFINE_IID!(IID_IAutoSuggestBoxTextChangedEventArgsStatics, 4277630763, 40773, 17627, 140, 39, 189, 163, 249, 51, 231, 181);
RT_INTERFACE!{static interface IAutoSuggestBoxTextChangedEventArgsStatics(IAutoSuggestBoxTextChangedEventArgsStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IAutoSuggestBoxTextChangedEventArgsStatics] {
    fn get_ReasonProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IAutoSuggestBoxTextChangedEventArgsStatics {
    #[inline] pub unsafe fn get_reason_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ReasonProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum AutoSuggestionBoxTextChangeReason: i32 {
    UserInput (AutoSuggestionBoxTextChangeReason_UserInput) = 0, ProgrammaticChange (AutoSuggestionBoxTextChangeReason_ProgrammaticChange) = 1, SuggestionChosen (AutoSuggestionBoxTextChangeReason_SuggestionChosen) = 2,
}}
DEFINE_IID!(IID_IBackClickEventArgs, 719721580, 18302, 18633, 136, 48, 44, 70, 75, 124, 113, 4);
RT_INTERFACE!{interface IBackClickEventArgs(IBackClickEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IBackClickEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl IBackClickEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BackClickEventArgs: IBackClickEventArgs}
impl RtActivatable<IActivationFactory> for BackClickEventArgs {}
DEFINE_CLSID!(BackClickEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,66,97,99,107,67,108,105,99,107,69,118,101,110,116,65,114,103,115,0]) [CLSID_BackClickEventArgs]);
DEFINE_IID!(IID_BackClickEventHandler, 4204511775, 39058, 18478, 171, 246, 235, 45, 96, 125, 50, 222);
RT_DELEGATE!{delegate BackClickEventHandler(BackClickEventHandlerVtbl, BackClickEventHandlerImpl) [IID_BackClickEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut BackClickEventArgs) -> HRESULT
}}
impl BackClickEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &BackClickEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBitmapIcon, 3908966347, 13815, 16627, 161, 133, 72, 179, 151, 183, 62, 104);
RT_INTERFACE!{interface IBitmapIcon(IBitmapIconVtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIcon] {
    fn get_UriSource(&self, out: *mut *mut ::rt::gen::windows::foundation::Uri) -> HRESULT,
    fn put_UriSource(&self, value: *mut ::rt::gen::windows::foundation::Uri) -> HRESULT
}}
impl IBitmapIcon {
    #[inline] pub unsafe fn get_uri_source(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UriSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_uri_source(&self, value: &::rt::gen::windows::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UriSource)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BitmapIcon: IBitmapIcon}
impl RtActivatable<IBitmapIconStatics> for BitmapIcon {}
impl RtActivatable<IBitmapIconStatics2> for BitmapIcon {}
impl BitmapIcon {
    #[inline] pub fn get_uri_source_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBitmapIconStatics>>::get_activation_factory().get_uri_source_property()
    }}
    #[inline] pub fn get_show_as_monochrome_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBitmapIconStatics2>>::get_activation_factory().get_show_as_monochrome_property()
    }}
}
DEFINE_CLSID!(BitmapIcon(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,66,105,116,109,97,112,73,99,111,110,0]) [CLSID_BitmapIcon]);
DEFINE_IID!(IID_IBitmapIcon2, 103064074, 40401, 16897, 187, 32, 66, 134, 61, 161, 86, 88);
RT_INTERFACE!{interface IBitmapIcon2(IBitmapIcon2Vtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIcon2] {
    fn get_ShowAsMonochrome(&self, out: *mut bool) -> HRESULT,
    fn put_ShowAsMonochrome(&self, value: bool) -> HRESULT
}}
impl IBitmapIcon2 {
    #[inline] pub unsafe fn get_show_as_monochrome(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowAsMonochrome)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_as_monochrome(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowAsMonochrome)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBitmapIconFactory, 1188449053, 31305, 20326, 151, 41, 40, 72, 199, 136, 228, 2);
RT_INTERFACE!{interface IBitmapIconFactory(IBitmapIconFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIconFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut BitmapIcon) -> HRESULT
}}
impl IBitmapIconFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<BitmapIcon>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBitmapIconSource, 3370335687, 54446, 19079, 148, 127, 172, 77, 11, 207, 90, 244);
RT_INTERFACE!{interface IBitmapIconSource(IBitmapIconSourceVtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIconSource] {
    fn get_UriSource(&self, out: *mut *mut ::rt::gen::windows::foundation::Uri) -> HRESULT,
    fn put_UriSource(&self, value: *mut ::rt::gen::windows::foundation::Uri) -> HRESULT,
    fn get_ShowAsMonochrome(&self, out: *mut bool) -> HRESULT,
    fn put_ShowAsMonochrome(&self, value: bool) -> HRESULT
}}
impl IBitmapIconSource {
    #[inline] pub unsafe fn get_uri_source(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UriSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_uri_source(&self, value: &::rt::gen::windows::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UriSource)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_as_monochrome(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ShowAsMonochrome)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_show_as_monochrome(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ShowAsMonochrome)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class BitmapIconSource: IBitmapIconSource}
impl RtActivatable<IBitmapIconSourceStatics> for BitmapIconSource {}
impl BitmapIconSource {
    #[inline] pub fn get_uri_source_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBitmapIconSourceStatics>>::get_activation_factory().get_uri_source_property()
    }}
    #[inline] pub fn get_show_as_monochrome_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBitmapIconSourceStatics>>::get_activation_factory().get_show_as_monochrome_property()
    }}
}
DEFINE_CLSID!(BitmapIconSource(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,66,105,116,109,97,112,73,99,111,110,83,111,117,114,99,101,0]) [CLSID_BitmapIconSource]);
DEFINE_IID!(IID_IBitmapIconSourceFactory, 1695147462, 17590, 19665, 134, 205, 195, 24, 155, 18, 196, 60);
RT_INTERFACE!{interface IBitmapIconSourceFactory(IBitmapIconSourceFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIconSourceFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut BitmapIconSource) -> HRESULT
}}
impl IBitmapIconSourceFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<BitmapIconSource>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBitmapIconSourceStatics, 1511020679, 58516, 19755, 133, 40, 57, 71, 34, 150, 19, 63);
RT_INTERFACE!{static interface IBitmapIconSourceStatics(IBitmapIconSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIconSourceStatics] {
    fn get_UriSourceProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ShowAsMonochromeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IBitmapIconSourceStatics {
    #[inline] pub unsafe fn get_uri_source_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UriSourceProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_show_as_monochrome_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ShowAsMonochromeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBitmapIconStatics, 3765621015, 58599, 19980, 148, 112, 83, 255, 28, 232, 79, 103);
RT_INTERFACE!{static interface IBitmapIconStatics(IBitmapIconStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIconStatics] {
    fn get_UriSourceProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IBitmapIconStatics {
    #[inline] pub unsafe fn get_uri_source_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UriSourceProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBitmapIconStatics2, 2537882219, 46914, 19081, 165, 215, 160, 229, 251, 128, 154, 241);
RT_INTERFACE!{static interface IBitmapIconStatics2(IBitmapIconStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IBitmapIconStatics2] {
    fn get_ShowAsMonochromeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IBitmapIconStatics2 {
    #[inline] pub unsafe fn get_show_as_monochrome_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ShowAsMonochromeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IBorder, 2038187321, 17853, 17971, 160, 68, 191, 176, 46, 245, 23, 15);
RT_INTERFACE!{interface IBorder(IBorderVtbl): IInspectable(IInspectableVtbl) [IID_IBorder] {
    fn get_BorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_BorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_BorderThickness(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_BorderThickness(&self, value: super::Thickness) -> HRESULT,
    fn get_Background(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Background(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_CornerRadius(&self, out: *mut super::CornerRadius) -> HRESULT,
    fn put_CornerRadius(&self, value: super::CornerRadius) -> HRESULT,
    fn get_Padding(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_Padding(&self, value: super::Thickness) -> HRESULT,
    fn get_Child(&self, out: *mut *mut super::UIElement) -> HRESULT,
    fn put_Child(&self, value: *mut super::UIElement) -> HRESULT,
    fn get_ChildTransitions(&self, out: *mut *mut super::media::animation::TransitionCollection) -> HRESULT,
    fn put_ChildTransitions(&self, value: *mut super::media::animation::TransitionCollection) -> HRESULT
}}
impl IBorder {
    #[inline] pub unsafe fn get_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BorderThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_thickness(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Background)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Background)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_corner_radius(&self) -> Result<super::CornerRadius> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CornerRadius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_corner_radius(&self, value: super::CornerRadius) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CornerRadius)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Padding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_padding(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Padding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_child(&self) -> Result<ComPtr<super::UIElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Child)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_child(&self, value: &super::UIElement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Child)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_child_transitions(&self) -> Result<ComPtr<super::media::animation::TransitionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChildTransitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_child_transitions(&self, value: &super::media::animation::TransitionCollection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ChildTransitions)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Border: IBorder}
impl RtActivatable<IBorderStatics> for Border {}
impl RtActivatable<IActivationFactory> for Border {}
impl Border {
    #[inline] pub fn get_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBorderStatics>>::get_activation_factory().get_border_brush_property()
    }}
    #[inline] pub fn get_border_thickness_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBorderStatics>>::get_activation_factory().get_border_thickness_property()
    }}
    #[inline] pub fn get_background_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBorderStatics>>::get_activation_factory().get_background_property()
    }}
    #[inline] pub fn get_corner_radius_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBorderStatics>>::get_activation_factory().get_corner_radius_property()
    }}
    #[inline] pub fn get_padding_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBorderStatics>>::get_activation_factory().get_padding_property()
    }}
    #[inline] pub fn get_child_transitions_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IBorderStatics>>::get_activation_factory().get_child_transitions_property()
    }}
}
DEFINE_CLSID!(Border(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,66,111,114,100,101,114,0]) [CLSID_Border]);
DEFINE_IID!(IID_IBorderStatics, 3088913977, 59665, 20439, 164, 196, 185, 199, 240, 8, 183, 252);
RT_INTERFACE!{static interface IBorderStatics(IBorderStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IBorderStatics] {
    fn get_BorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BorderThicknessProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BackgroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CornerRadiusProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PaddingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ChildTransitionsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IBorderStatics {
    #[inline] pub unsafe fn get_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackgroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_corner_radius_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CornerRadiusProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PaddingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_child_transitions_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ChildTransitionsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IButton, 671298990, 21872, 18119, 142, 11, 96, 43, 231, 18, 41, 162);
RT_INTERFACE!{interface IButton(IButtonVtbl): IInspectable(IInspectableVtbl) [IID_IButton] {
    
}}
RT_CLASS!{class Button: IButton}
impl RtActivatable<IButtonStaticsWithFlyout> for Button {}
impl Button {
    #[inline] pub fn get_flyout_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IButtonStaticsWithFlyout>>::get_activation_factory().get_flyout_property()
    }}
}
DEFINE_CLSID!(Button(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,66,117,116,116,111,110,0]) [CLSID_Button]);
DEFINE_IID!(IID_IButtonFactory, 2158050329, 33850, 17692, 140, 245, 68, 199, 1, 176, 226, 22);
RT_INTERFACE!{interface IButtonFactory(IButtonFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IButtonFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Button) -> HRESULT
}}
impl IButtonFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Button>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IButtonStaticsWithFlyout, 2417244312, 41324, 18265, 178, 240, 165, 247, 230, 37, 22, 158);
RT_INTERFACE!{static interface IButtonStaticsWithFlyout(IButtonStaticsWithFlyoutVtbl): IInspectable(IInspectableVtbl) [IID_IButtonStaticsWithFlyout] {
    fn get_FlyoutProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IButtonStaticsWithFlyout {
    #[inline] pub unsafe fn get_flyout_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlyoutProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IButtonWithFlyout, 152080263, 57196, 16768, 155, 58, 230, 8, 69, 130, 88, 17);
RT_INTERFACE!{interface IButtonWithFlyout(IButtonWithFlyoutVtbl): IInspectable(IInspectableVtbl) [IID_IButtonWithFlyout] {
    fn get_Flyout(&self, out: *mut *mut primitives::FlyoutBase) -> HRESULT,
    fn put_Flyout(&self, value: *mut primitives::FlyoutBase) -> HRESULT
}}
impl IButtonWithFlyout {
    #[inline] pub unsafe fn get_flyout(&self) -> Result<ComPtr<primitives::FlyoutBase>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Flyout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_flyout(&self, value: &primitives::FlyoutBase) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Flyout)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarDatePicker, 1674166639, 26252, 17553, 148, 68, 212, 93, 139, 244, 250, 41);
RT_INTERFACE!{interface ICalendarDatePicker(ICalendarDatePickerVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarDatePicker] {
    fn get_Date(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn put_Date(&self, value: *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_IsCalendarOpen(&self, out: *mut bool) -> HRESULT,
    fn put_IsCalendarOpen(&self, value: bool) -> HRESULT,
    fn get_DateFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DateFormat(&self, value: HSTRING) -> HRESULT,
    fn get_PlaceholderText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PlaceholderText(&self, value: HSTRING) -> HRESULT,
    fn get_Header(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Header(&self, value: *mut IInspectable) -> HRESULT,
    fn get_HeaderTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_HeaderTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_CalendarViewStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_CalendarViewStyle(&self, value: *mut super::Style) -> HRESULT,
    fn get_MinDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MinDate(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_MaxDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MaxDate(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_IsTodayHighlighted(&self, out: *mut bool) -> HRESULT,
    fn put_IsTodayHighlighted(&self, value: bool) -> HRESULT,
    fn get_DisplayMode(&self, out: *mut CalendarViewDisplayMode) -> HRESULT,
    fn put_DisplayMode(&self, value: CalendarViewDisplayMode) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy22(&self) -> (),
    #[cfg(feature="windows-globalization")] fn get_FirstDayOfWeek(&self, out: *mut ::rt::gen::windows::globalization::DayOfWeek) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy23(&self) -> (),
    #[cfg(feature="windows-globalization")] fn put_FirstDayOfWeek(&self, value: ::rt::gen::windows::globalization::DayOfWeek) -> HRESULT,
    fn get_DayOfWeekFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DayOfWeekFormat(&self, value: HSTRING) -> HRESULT,
    fn get_CalendarIdentifier(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CalendarIdentifier(&self, value: HSTRING) -> HRESULT,
    fn get_IsOutOfScopeEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsOutOfScopeEnabled(&self, value: bool) -> HRESULT,
    fn get_IsGroupLabelVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsGroupLabelVisible(&self, value: bool) -> HRESULT,
    fn add_CalendarViewDayItemChanging(&self, value: *mut CalendarViewDayItemChangingEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CalendarViewDayItemChanging(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DateChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<CalendarDatePicker, CalendarDatePickerDateChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DateChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Opened(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn SetDisplayDate(&self, date: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn SetYearDecadeDisplayDimensions(&self, columns: i32, rows: i32) -> HRESULT
}}
impl ICalendarDatePicker {
    #[inline] pub unsafe fn get_date(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Date)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_date(&self, value: &::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Date)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_calendar_open(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCalendarOpen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_calendar_open(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCalendarOpen)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_date_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DateFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_placeholder_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaceholderText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Header)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_view_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarViewStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_view_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarViewStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_date(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinDate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_date(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxDate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_today_highlighted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTodayHighlighted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_today_highlighted(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTodayHighlighted)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_mode(&self) -> Result<CalendarViewDisplayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisplayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_mode(&self, value: CalendarViewDisplayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_first_day_of_week(&self) -> Result<::rt::gen::windows::globalization::DayOfWeek> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstDayOfWeek)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn set_first_day_of_week(&self, value: ::rt::gen::windows::globalization::DayOfWeek) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstDayOfWeek)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_of_week_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayOfWeekFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_of_week_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayOfWeekFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_identifier(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifier)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_identifier(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarIdentifier)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_out_of_scope_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOutOfScopeEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_out_of_scope_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOutOfScopeEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_group_label_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGroupLabelVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_group_label_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsGroupLabelVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_calendar_view_day_item_changing(&self, value: &CalendarViewDayItemChangingEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CalendarViewDayItemChanging)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_calendar_view_day_item_changing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CalendarViewDayItemChanging)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_date_changed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<CalendarDatePicker, CalendarDatePickerDateChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_date_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_opened(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Opened)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Opened)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_date(&self, date: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDisplayDate)(self as *const _ as *mut _, date);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year_decade_display_dimensions(&self, columns: i32, rows: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetYearDecadeDisplayDimensions)(self as *const _ as *mut _, columns, rows);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CalendarDatePicker: ICalendarDatePicker}
impl RtActivatable<ICalendarDatePickerStatics> for CalendarDatePicker {}
impl RtActivatable<ICalendarDatePickerStatics2> for CalendarDatePicker {}
impl CalendarDatePicker {
    #[inline] pub fn get_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_date_property()
    }}
    #[inline] pub fn get_is_calendar_open_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_is_calendar_open_property()
    }}
    #[inline] pub fn get_date_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_date_format_property()
    }}
    #[inline] pub fn get_placeholder_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_placeholder_text_property()
    }}
    #[inline] pub fn get_header_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_header_property()
    }}
    #[inline] pub fn get_header_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_header_template_property()
    }}
    #[inline] pub fn get_calendar_view_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_calendar_view_style_property()
    }}
    #[inline] pub fn get_min_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_min_date_property()
    }}
    #[inline] pub fn get_max_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_max_date_property()
    }}
    #[inline] pub fn get_is_today_highlighted_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_is_today_highlighted_property()
    }}
    #[inline] pub fn get_display_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_display_mode_property()
    }}
    #[inline] pub fn get_first_day_of_week_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_first_day_of_week_property()
    }}
    #[inline] pub fn get_day_of_week_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_day_of_week_format_property()
    }}
    #[inline] pub fn get_calendar_identifier_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_calendar_identifier_property()
    }}
    #[inline] pub fn get_is_out_of_scope_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_is_out_of_scope_enabled_property()
    }}
    #[inline] pub fn get_is_group_label_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics>>::get_activation_factory().get_is_group_label_visible_property()
    }}
    #[inline] pub fn get_light_dismiss_overlay_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarDatePickerStatics2>>::get_activation_factory().get_light_dismiss_overlay_mode_property()
    }}
}
DEFINE_CLSID!(CalendarDatePicker(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,97,108,101,110,100,97,114,68,97,116,101,80,105,99,107,101,114,0]) [CLSID_CalendarDatePicker]);
DEFINE_IID!(IID_ICalendarDatePicker2, 2987835737, 9233, 19040, 167, 170, 39, 65, 107, 73, 72, 30);
RT_INTERFACE!{interface ICalendarDatePicker2(ICalendarDatePicker2Vtbl): IInspectable(IInspectableVtbl) [IID_ICalendarDatePicker2] {
    fn get_LightDismissOverlayMode(&self, out: *mut LightDismissOverlayMode) -> HRESULT,
    fn put_LightDismissOverlayMode(&self, value: LightDismissOverlayMode) -> HRESULT
}}
impl ICalendarDatePicker2 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode(&self) -> Result<LightDismissOverlayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_light_dismiss_overlay_mode(&self, value: LightDismissOverlayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LightDismissOverlayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarDatePickerDateChangedEventArgs, 1624837554, 20496, 18106, 132, 45, 164, 21, 44, 101, 4, 231);
RT_INTERFACE!{interface ICalendarDatePickerDateChangedEventArgs(ICalendarDatePickerDateChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarDatePickerDateChangedEventArgs] {
    fn get_NewDate(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_OldDate(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>) -> HRESULT
}}
impl ICalendarDatePickerDateChangedEventArgs {
    #[inline] pub unsafe fn get_new_date(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NewDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_old_date(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OldDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CalendarDatePickerDateChangedEventArgs: ICalendarDatePickerDateChangedEventArgs}
DEFINE_IID!(IID_ICalendarDatePickerFactory, 276475229, 14526, 17071, 169, 87, 252, 134, 165, 207, 30, 154);
RT_INTERFACE!{interface ICalendarDatePickerFactory(ICalendarDatePickerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarDatePickerFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut CalendarDatePicker) -> HRESULT
}}
impl ICalendarDatePickerFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<CalendarDatePicker>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarDatePickerStatics, 967037585, 44971, 19348, 131, 149, 186, 123, 135, 78, 60, 140);
RT_INTERFACE!{static interface ICalendarDatePickerStatics(ICalendarDatePickerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarDatePickerStatics] {
    fn get_DateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsCalendarOpenProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DateFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PlaceholderTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarViewStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinDateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxDateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTodayHighlightedProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DisplayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstDayOfWeekProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayOfWeekFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarIdentifierProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsOutOfScopeEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsGroupLabelVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICalendarDatePickerStatics {
    #[inline] pub unsafe fn get_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_calendar_open_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsCalendarOpenProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_view_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarViewStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinDateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxDateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_today_highlighted_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTodayHighlightedProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_day_of_week_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstDayOfWeekProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_of_week_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayOfWeekFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_identifier_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifierProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_out_of_scope_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsOutOfScopeEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_group_label_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsGroupLabelVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarDatePickerStatics2, 807431000, 41718, 18944, 141, 19, 51, 196, 107, 107, 142, 13);
RT_INTERFACE!{static interface ICalendarDatePickerStatics2(ICalendarDatePickerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ICalendarDatePickerStatics2] {
    fn get_LightDismissOverlayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICalendarDatePickerStatics2 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarView, 3445854723, 57269, 17170, 172, 7, 192, 57, 24, 36, 96, 123);
RT_INTERFACE!{interface ICalendarView(ICalendarViewVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarView] {
    fn get_CalendarIdentifier(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CalendarIdentifier(&self, value: HSTRING) -> HRESULT,
    fn get_DayOfWeekFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DayOfWeekFormat(&self, value: HSTRING) -> HRESULT,
    fn get_IsGroupLabelVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsGroupLabelVisible(&self, value: bool) -> HRESULT,
    fn get_DisplayMode(&self, out: *mut CalendarViewDisplayMode) -> HRESULT,
    fn put_DisplayMode(&self, value: CalendarViewDisplayMode) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-globalization")] fn get_FirstDayOfWeek(&self, out: *mut ::rt::gen::windows::globalization::DayOfWeek) -> HRESULT,
    #[cfg(not(feature="windows-globalization"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-globalization")] fn put_FirstDayOfWeek(&self, value: ::rt::gen::windows::globalization::DayOfWeek) -> HRESULT,
    fn get_IsOutOfScopeEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsOutOfScopeEnabled(&self, value: bool) -> HRESULT,
    fn get_IsTodayHighlighted(&self, out: *mut bool) -> HRESULT,
    fn put_IsTodayHighlighted(&self, value: bool) -> HRESULT,
    fn get_MaxDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MaxDate(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_MinDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MinDate(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_NumberOfWeeksInView(&self, out: *mut i32) -> HRESULT,
    fn put_NumberOfWeeksInView(&self, value: i32) -> HRESULT,
    fn get_SelectedDates(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_SelectionMode(&self, out: *mut CalendarViewSelectionMode) -> HRESULT,
    fn put_SelectionMode(&self, value: CalendarViewSelectionMode) -> HRESULT,
    fn get_TemplateSettings(&self, out: *mut *mut primitives::CalendarViewTemplateSettings) -> HRESULT,
    fn get_FocusBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_FocusBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_SelectedHoverBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_SelectedHoverBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_SelectedPressedBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_SelectedPressedBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_SelectedBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_SelectedBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_HoverBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_HoverBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_PressedBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_PressedBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_CalendarItemBorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_CalendarItemBorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_OutOfScopeBackground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_OutOfScopeBackground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_CalendarItemBackground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_CalendarItemBackground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_PressedForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_PressedForeground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_TodayForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_TodayForeground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_BlackoutForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_BlackoutForeground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_SelectedForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_SelectedForeground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_OutOfScopeForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_OutOfScopeForeground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_CalendarItemForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_CalendarItemForeground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_DayItemFontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_DayItemFontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    fn get_DayItemFontSize(&self, out: *mut f64) -> HRESULT,
    fn put_DayItemFontSize(&self, value: f64) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy58(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_DayItemFontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy59(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_DayItemFontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy60(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_DayItemFontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy61(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_DayItemFontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy62(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_TodayFontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy63(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_TodayFontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    fn get_FirstOfMonthLabelFontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_FirstOfMonthLabelFontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    fn get_FirstOfMonthLabelFontSize(&self, out: *mut f64) -> HRESULT,
    fn put_FirstOfMonthLabelFontSize(&self, value: f64) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy68(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FirstOfMonthLabelFontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy69(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FirstOfMonthLabelFontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy70(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FirstOfMonthLabelFontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy71(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FirstOfMonthLabelFontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    fn get_MonthYearItemFontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_MonthYearItemFontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    fn get_MonthYearItemFontSize(&self, out: *mut f64) -> HRESULT,
    fn put_MonthYearItemFontSize(&self, value: f64) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy76(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_MonthYearItemFontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy77(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_MonthYearItemFontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy78(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_MonthYearItemFontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy79(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_MonthYearItemFontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    fn get_FirstOfYearDecadeLabelFontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_FirstOfYearDecadeLabelFontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    fn get_FirstOfYearDecadeLabelFontSize(&self, out: *mut f64) -> HRESULT,
    fn put_FirstOfYearDecadeLabelFontSize(&self, value: f64) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy84(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FirstOfYearDecadeLabelFontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy85(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FirstOfYearDecadeLabelFontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy86(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FirstOfYearDecadeLabelFontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy87(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FirstOfYearDecadeLabelFontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    fn get_HorizontalDayItemAlignment(&self, out: *mut super::HorizontalAlignment) -> HRESULT,
    fn put_HorizontalDayItemAlignment(&self, value: super::HorizontalAlignment) -> HRESULT,
    fn get_VerticalDayItemAlignment(&self, out: *mut super::VerticalAlignment) -> HRESULT,
    fn put_VerticalDayItemAlignment(&self, value: super::VerticalAlignment) -> HRESULT,
    fn get_HorizontalFirstOfMonthLabelAlignment(&self, out: *mut super::HorizontalAlignment) -> HRESULT,
    fn put_HorizontalFirstOfMonthLabelAlignment(&self, value: super::HorizontalAlignment) -> HRESULT,
    fn get_VerticalFirstOfMonthLabelAlignment(&self, out: *mut super::VerticalAlignment) -> HRESULT,
    fn put_VerticalFirstOfMonthLabelAlignment(&self, value: super::VerticalAlignment) -> HRESULT,
    fn get_CalendarItemBorderThickness(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_CalendarItemBorderThickness(&self, value: super::Thickness) -> HRESULT,
    fn get_CalendarViewDayItemStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_CalendarViewDayItemStyle(&self, value: *mut super::Style) -> HRESULT,
    fn add_CalendarViewDayItemChanging(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewDayItemChangingEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CalendarViewDayItemChanging(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SelectedDatesChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewSelectedDatesChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SelectedDatesChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn SetDisplayDate(&self, date: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn SetYearDecadeDisplayDimensions(&self, columns: i32, rows: i32) -> HRESULT
}}
impl ICalendarView {
    #[inline] pub unsafe fn get_calendar_identifier(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifier)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_identifier(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarIdentifier)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_of_week_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayOfWeekFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_of_week_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayOfWeekFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_group_label_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsGroupLabelVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_group_label_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsGroupLabelVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_mode(&self) -> Result<CalendarViewDisplayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DisplayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_mode(&self, value: CalendarViewDisplayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DisplayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn get_first_day_of_week(&self) -> Result<::rt::gen::windows::globalization::DayOfWeek> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstDayOfWeek)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-globalization")] #[inline] pub unsafe fn set_first_day_of_week(&self, value: ::rt::gen::windows::globalization::DayOfWeek) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstDayOfWeek)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_out_of_scope_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsOutOfScopeEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_out_of_scope_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsOutOfScopeEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_today_highlighted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTodayHighlighted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_today_highlighted(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTodayHighlighted)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_date(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxDate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_date(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinDate)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_number_of_weeks_in_view(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NumberOfWeeksInView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_number_of_weeks_in_view(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_NumberOfWeeksInView)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_dates(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selection_mode(&self) -> Result<CalendarViewSelectionMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectionMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selection_mode(&self, value: CalendarViewSelectionMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectionMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template_settings(&self) -> Result<ComPtr<primitives::CalendarViewTemplateSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TemplateSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_focus_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FocusBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_hover_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedHoverBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected_hover_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedHoverBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_pressed_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedPressedBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected_pressed_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedPressedBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hover_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HoverBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_hover_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HoverBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressed_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PressedBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pressed_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PressedBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemBorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_item_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarItemBorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_out_of_scope_background(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutOfScopeBackground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_out_of_scope_background(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutOfScopeBackground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_background(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemBackground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_item_background(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarItemBackground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressed_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PressedForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_pressed_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PressedForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_today_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TodayForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_today_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TodayForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blackout_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BlackoutForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_blackout_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BlackoutForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selected_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectedForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_out_of_scope_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutOfScopeForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_out_of_scope_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OutOfScopeForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_item_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarItemForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_item_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayItemFontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_item_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayItemFontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_item_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayItemFontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_item_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayItemFontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_day_item_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayItemFontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_day_item_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayItemFontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_day_item_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayItemFontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_day_item_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayItemFontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_today_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TodayFontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_today_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TodayFontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_month_label_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_first_of_month_label_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfMonthLabelFontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_month_label_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_first_of_month_label_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfMonthLabelFontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_first_of_month_label_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_first_of_month_label_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfMonthLabelFontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_first_of_month_label_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_first_of_month_label_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfMonthLabelFontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_year_item_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month_year_item_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthYearItemFontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_year_item_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month_year_item_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthYearItemFontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_month_year_item_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_month_year_item_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthYearItemFontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_month_year_item_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_month_year_item_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthYearItemFontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_year_decade_label_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_first_of_year_decade_label_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfYearDecadeLabelFontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_year_decade_label_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_first_of_year_decade_label_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfYearDecadeLabelFontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_first_of_year_decade_label_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_first_of_year_decade_label_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfYearDecadeLabelFontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_first_of_year_decade_label_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_first_of_year_decade_label_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FirstOfYearDecadeLabelFontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_day_item_alignment(&self) -> Result<super::HorizontalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HorizontalDayItemAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_horizontal_day_item_alignment(&self, value: super::HorizontalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HorizontalDayItemAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_day_item_alignment(&self) -> Result<super::VerticalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VerticalDayItemAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_vertical_day_item_alignment(&self, value: super::VerticalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VerticalDayItemAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_first_of_month_label_alignment(&self) -> Result<super::HorizontalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HorizontalFirstOfMonthLabelAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_horizontal_first_of_month_label_alignment(&self, value: super::HorizontalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HorizontalFirstOfMonthLabelAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_first_of_month_label_alignment(&self) -> Result<super::VerticalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VerticalFirstOfMonthLabelAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_vertical_first_of_month_label_alignment(&self, value: super::VerticalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VerticalFirstOfMonthLabelAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_border_thickness(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CalendarItemBorderThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_item_border_thickness(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarItemBorderThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_view_day_item_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarViewDayItemStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_view_day_item_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarViewDayItemStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_calendar_view_day_item_changing(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewDayItemChangingEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CalendarViewDayItemChanging)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_calendar_view_day_item_changing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CalendarViewDayItemChanging)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_selected_dates_changed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewSelectedDatesChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SelectedDatesChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_selected_dates_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SelectedDatesChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_display_date(&self, date: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDisplayDate)(self as *const _ as *mut _, date);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year_decade_display_dimensions(&self, columns: i32, rows: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetYearDecadeDisplayDimensions)(self as *const _ as *mut _, columns, rows);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CalendarView: ICalendarView}
impl RtActivatable<ICalendarViewStatics> for CalendarView {}
impl CalendarView {
    #[inline] pub fn get_calendar_identifier_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_calendar_identifier_property()
    }}
    #[inline] pub fn get_day_of_week_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_day_of_week_format_property()
    }}
    #[inline] pub fn get_is_group_label_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_is_group_label_visible_property()
    }}
    #[inline] pub fn get_display_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_display_mode_property()
    }}
    #[inline] pub fn get_first_day_of_week_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_day_of_week_property()
    }}
    #[inline] pub fn get_is_out_of_scope_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_is_out_of_scope_enabled_property()
    }}
    #[inline] pub fn get_is_today_highlighted_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_is_today_highlighted_property()
    }}
    #[inline] pub fn get_max_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_max_date_property()
    }}
    #[inline] pub fn get_min_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_min_date_property()
    }}
    #[inline] pub fn get_number_of_weeks_in_view_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_number_of_weeks_in_view_property()
    }}
    #[inline] pub fn get_selected_dates_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_selected_dates_property()
    }}
    #[inline] pub fn get_selection_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_selection_mode_property()
    }}
    #[inline] pub fn get_template_settings_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_template_settings_property()
    }}
    #[inline] pub fn get_focus_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_focus_border_brush_property()
    }}
    #[inline] pub fn get_selected_hover_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_selected_hover_border_brush_property()
    }}
    #[inline] pub fn get_selected_pressed_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_selected_pressed_border_brush_property()
    }}
    #[inline] pub fn get_selected_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_selected_border_brush_property()
    }}
    #[inline] pub fn get_hover_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_hover_border_brush_property()
    }}
    #[inline] pub fn get_pressed_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_pressed_border_brush_property()
    }}
    #[inline] pub fn get_calendar_item_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_calendar_item_border_brush_property()
    }}
    #[inline] pub fn get_out_of_scope_background_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_out_of_scope_background_property()
    }}
    #[inline] pub fn get_calendar_item_background_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_calendar_item_background_property()
    }}
    #[inline] pub fn get_pressed_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_pressed_foreground_property()
    }}
    #[inline] pub fn get_today_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_today_foreground_property()
    }}
    #[inline] pub fn get_blackout_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_blackout_foreground_property()
    }}
    #[inline] pub fn get_selected_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_selected_foreground_property()
    }}
    #[inline] pub fn get_out_of_scope_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_out_of_scope_foreground_property()
    }}
    #[inline] pub fn get_calendar_item_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_calendar_item_foreground_property()
    }}
    #[inline] pub fn get_day_item_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_day_item_font_family_property()
    }}
    #[inline] pub fn get_day_item_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_day_item_font_size_property()
    }}
    #[inline] pub fn get_day_item_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_day_item_font_style_property()
    }}
    #[inline] pub fn get_day_item_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_day_item_font_weight_property()
    }}
    #[inline] pub fn get_today_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_today_font_weight_property()
    }}
    #[inline] pub fn get_first_of_month_label_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_month_label_font_family_property()
    }}
    #[inline] pub fn get_first_of_month_label_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_month_label_font_size_property()
    }}
    #[inline] pub fn get_first_of_month_label_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_month_label_font_style_property()
    }}
    #[inline] pub fn get_first_of_month_label_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_month_label_font_weight_property()
    }}
    #[inline] pub fn get_month_year_item_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_month_year_item_font_family_property()
    }}
    #[inline] pub fn get_month_year_item_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_month_year_item_font_size_property()
    }}
    #[inline] pub fn get_month_year_item_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_month_year_item_font_style_property()
    }}
    #[inline] pub fn get_month_year_item_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_month_year_item_font_weight_property()
    }}
    #[inline] pub fn get_first_of_year_decade_label_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_year_decade_label_font_family_property()
    }}
    #[inline] pub fn get_first_of_year_decade_label_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_year_decade_label_font_size_property()
    }}
    #[inline] pub fn get_first_of_year_decade_label_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_year_decade_label_font_style_property()
    }}
    #[inline] pub fn get_first_of_year_decade_label_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_first_of_year_decade_label_font_weight_property()
    }}
    #[inline] pub fn get_horizontal_day_item_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_horizontal_day_item_alignment_property()
    }}
    #[inline] pub fn get_vertical_day_item_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_vertical_day_item_alignment_property()
    }}
    #[inline] pub fn get_horizontal_first_of_month_label_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_horizontal_first_of_month_label_alignment_property()
    }}
    #[inline] pub fn get_vertical_first_of_month_label_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_vertical_first_of_month_label_alignment_property()
    }}
    #[inline] pub fn get_calendar_item_border_thickness_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_calendar_item_border_thickness_property()
    }}
    #[inline] pub fn get_calendar_view_day_item_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewStatics>>::get_activation_factory().get_calendar_view_day_item_style_property()
    }}
}
DEFINE_CLSID!(CalendarView(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,97,108,101,110,100,97,114,86,105,101,119,0]) [CLSID_CalendarView]);
DEFINE_IID!(IID_ICalendarViewDayItem, 266022341, 12993, 19343, 190, 252, 1, 123, 85, 91, 50, 210);
RT_INTERFACE!{interface ICalendarViewDayItem(ICalendarViewDayItemVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewDayItem] {
    fn get_IsBlackout(&self, out: *mut bool) -> HRESULT,
    fn put_IsBlackout(&self, value: bool) -> HRESULT,
    fn get_Date(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    #[cfg(feature="windows-ui")] fn SetDensityColors(&self, colors: *mut ::rt::gen::windows::foundation::collections::IIterable<super::super::Color>) -> HRESULT
}}
impl ICalendarViewDayItem {
    #[inline] pub unsafe fn get_is_blackout(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsBlackout)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_blackout(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsBlackout)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Date)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_density_colors(&self, colors: &::rt::gen::windows::foundation::collections::IIterable<super::super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).SetDensityColors)(self as *const _ as *mut _, colors as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CalendarViewDayItem: ICalendarViewDayItem}
impl RtActivatable<ICalendarViewDayItemStatics> for CalendarViewDayItem {}
impl CalendarViewDayItem {
    #[inline] pub fn get_is_blackout_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewDayItemStatics>>::get_activation_factory().get_is_blackout_property()
    }}
    #[inline] pub fn get_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICalendarViewDayItemStatics>>::get_activation_factory().get_date_property()
    }}
}
DEFINE_CLSID!(CalendarViewDayItem(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,97,108,101,110,100,97,114,86,105,101,119,68,97,121,73,116,101,109,0]) [CLSID_CalendarViewDayItem]);
DEFINE_IID!(IID_ICalendarViewDayItemChangingEventArgs, 1930716774, 8113, 17657, 183, 173, 77, 232, 89, 236, 197, 101);
RT_INTERFACE!{interface ICalendarViewDayItemChangingEventArgs(ICalendarViewDayItemChangingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewDayItemChangingEventArgs] {
    fn get_InRecycleQueue(&self, out: *mut bool) -> HRESULT,
    fn get_Item(&self, out: *mut *mut CalendarViewDayItem) -> HRESULT,
    fn get_Phase(&self, out: *mut u32) -> HRESULT,
    fn RegisterUpdateCallback(&self, callback: *mut ::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewDayItemChangingEventArgs>) -> HRESULT,
    fn RegisterUpdateCallbackWithPhase(&self, callbackPhase: u32, callback: *mut ::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewDayItemChangingEventArgs>) -> HRESULT
}}
impl ICalendarViewDayItemChangingEventArgs {
    #[inline] pub unsafe fn get_in_recycle_queue(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InRecycleQueue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_item(&self) -> Result<ComPtr<CalendarViewDayItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Item)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phase(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Phase)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_update_callback(&self, callback: &::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewDayItemChangingEventArgs>) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterUpdateCallback)(self as *const _ as *mut _, callback as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_update_callback_with_phase(&self, callbackPhase: u32, callback: &::rt::gen::windows::foundation::TypedEventHandler<CalendarView, CalendarViewDayItemChangingEventArgs>) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterUpdateCallbackWithPhase)(self as *const _ as *mut _, callbackPhase, callback as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CalendarViewDayItemChangingEventArgs: ICalendarViewDayItemChangingEventArgs}
DEFINE_IID!(IID_CalendarViewDayItemChangingEventHandler, 2373212305, 19939, 18891, 151, 75, 8, 56, 113, 163, 175, 230);
RT_DELEGATE!{delegate CalendarViewDayItemChangingEventHandler(CalendarViewDayItemChangingEventHandlerVtbl, CalendarViewDayItemChangingEventHandlerImpl) [IID_CalendarViewDayItemChangingEventHandler] {
    fn Invoke(&self, sender: *mut CalendarView, e: *mut CalendarViewDayItemChangingEventArgs) -> HRESULT
}}
impl CalendarViewDayItemChangingEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &CalendarView, e: &CalendarViewDayItemChangingEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarViewDayItemFactory, 1645292508, 7471, 20036, 155, 175, 22, 101, 116, 149, 33, 242);
RT_INTERFACE!{interface ICalendarViewDayItemFactory(ICalendarViewDayItemFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewDayItemFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut CalendarViewDayItem) -> HRESULT
}}
impl ICalendarViewDayItemFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<CalendarViewDayItem>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarViewDayItemStatics, 3282164671, 48520, 18571, 185, 22, 208, 13, 105, 177, 115, 90);
RT_INTERFACE!{static interface ICalendarViewDayItemStatics(ICalendarViewDayItemStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewDayItemStatics] {
    fn get_IsBlackoutProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICalendarViewDayItemStatics {
    #[inline] pub unsafe fn get_is_blackout_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsBlackoutProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CalendarViewDisplayMode: i32 {
    Month (CalendarViewDisplayMode_Month) = 0, Year (CalendarViewDisplayMode_Year) = 1, Decade (CalendarViewDisplayMode_Decade) = 2,
}}
DEFINE_IID!(IID_ICalendarViewFactory, 1032815331, 27846, 16958, 141, 124, 112, 20, 217, 84, 221, 239);
RT_INTERFACE!{interface ICalendarViewFactory(ICalendarViewFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut CalendarView) -> HRESULT
}}
impl ICalendarViewFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<CalendarView>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICalendarViewSelectedDatesChangedEventArgs, 3999295990, 5103, 18582, 143, 252, 83, 2, 177, 177, 117, 57);
RT_INTERFACE!{interface ICalendarViewSelectedDatesChangedEventArgs(ICalendarViewSelectedDatesChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewSelectedDatesChangedEventArgs] {
    fn get_AddedDates(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::DateTime>) -> HRESULT,
    fn get_RemovedDates(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::DateTime>) -> HRESULT
}}
impl ICalendarViewSelectedDatesChangedEventArgs {
    #[inline] pub unsafe fn get_added_dates(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_AddedDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_removed_dates(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<::rt::gen::windows::foundation::DateTime>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RemovedDates)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CalendarViewSelectedDatesChangedEventArgs: ICalendarViewSelectedDatesChangedEventArgs}
RT_ENUM! { enum CalendarViewSelectionMode: i32 {
    None (CalendarViewSelectionMode_None) = 0, Single (CalendarViewSelectionMode_Single) = 1, Multiple (CalendarViewSelectionMode_Multiple) = 2,
}}
DEFINE_IID!(IID_ICalendarViewStatics, 1918955972, 12125, 16829, 153, 187, 69, 113, 178, 11, 121, 168);
RT_INTERFACE!{static interface ICalendarViewStatics(ICalendarViewStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICalendarViewStatics] {
    fn get_CalendarIdentifierProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayOfWeekFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsGroupLabelVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DisplayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstDayOfWeekProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsOutOfScopeEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTodayHighlightedProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxDateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinDateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_NumberOfWeeksInViewProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SelectedDatesProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SelectionModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TemplateSettingsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FocusBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SelectedHoverBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SelectedPressedBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SelectedBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HoverBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PressedBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarItemBorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_OutOfScopeBackgroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarItemBackgroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PressedForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TodayForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BlackoutForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SelectedForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_OutOfScopeForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarItemForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayItemFontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayItemFontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayItemFontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayItemFontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TodayFontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfMonthLabelFontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfMonthLabelFontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfMonthLabelFontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfMonthLabelFontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthYearItemFontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthYearItemFontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthYearItemFontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthYearItemFontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfYearDecadeLabelFontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfYearDecadeLabelFontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfYearDecadeLabelFontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FirstOfYearDecadeLabelFontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HorizontalDayItemAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_VerticalDayItemAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HorizontalFirstOfMonthLabelAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_VerticalFirstOfMonthLabelAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarItemBorderThicknessProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarViewDayItemStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICalendarViewStatics {
    #[inline] pub unsafe fn get_calendar_identifier_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifierProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_of_week_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayOfWeekFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_group_label_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsGroupLabelVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_display_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DisplayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_day_of_week_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstDayOfWeekProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_out_of_scope_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsOutOfScopeEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_today_highlighted_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTodayHighlightedProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxDateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinDateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_number_of_weeks_in_view_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NumberOfWeeksInViewProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_dates_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedDatesProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selection_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectionModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template_settings_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TemplateSettingsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_hover_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedHoverBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_pressed_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedPressedBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hover_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HoverBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressed_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PressedBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemBorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_out_of_scope_background_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutOfScopeBackgroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_background_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemBackgroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_pressed_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PressedForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_today_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TodayForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_blackout_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BlackoutForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selected_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectedForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_out_of_scope_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OutOfScopeForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_item_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayItemFontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_item_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayItemFontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_item_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayItemFontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_item_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayItemFontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_today_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TodayFontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_month_label_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_month_label_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_month_label_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_month_label_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfMonthLabelFontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_year_item_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_year_item_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_year_item_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_year_item_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthYearItemFontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_year_decade_label_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_year_decade_label_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_year_decade_label_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_first_of_year_decade_label_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FirstOfYearDecadeLabelFontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_day_item_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HorizontalDayItemAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_day_item_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VerticalDayItemAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_first_of_month_label_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HorizontalFirstOfMonthLabelAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_first_of_month_label_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VerticalFirstOfMonthLabelAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_item_border_thickness_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarItemBorderThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_view_day_item_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarViewDayItemStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CandidateWindowAlignment: i32 {
    Default (CandidateWindowAlignment_Default) = 0, BottomEdge (CandidateWindowAlignment_BottomEdge) = 1,
}}
DEFINE_IID!(IID_ICandidateWindowBoundsChangedEventArgs, 2324980824, 33712, 19506, 148, 80, 81, 105, 165, 131, 139, 85);
RT_INTERFACE!{interface ICandidateWindowBoundsChangedEventArgs(ICandidateWindowBoundsChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICandidateWindowBoundsChangedEventArgs] {
    fn get_Bounds(&self, out: *mut ::rt::gen::windows::foundation::Rect) -> HRESULT
}}
impl ICandidateWindowBoundsChangedEventArgs {
    #[inline] pub unsafe fn get_bounds(&self) -> Result<::rt::gen::windows::foundation::Rect> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Bounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class CandidateWindowBoundsChangedEventArgs: ICandidateWindowBoundsChangedEventArgs}
DEFINE_IID!(IID_ICanvas, 2031685145, 52536, 18467, 174, 174, 100, 167, 113, 50, 245, 25);
RT_INTERFACE!{interface ICanvas(ICanvasVtbl): IInspectable(IInspectableVtbl) [IID_ICanvas] {
    
}}
RT_CLASS!{class Canvas: ICanvas}
impl RtActivatable<ICanvasStatics> for Canvas {}
impl Canvas {
    #[inline] pub fn get_left_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().get_left_property()
    }}
    #[inline] pub fn get_left(element: &super::UIElement) -> Result<f64> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().get_left(element)
    }}
    #[inline] pub fn set_left(element: &super::UIElement, length: f64) -> Result<()> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().set_left(element, length)
    }}
    #[inline] pub fn get_top_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().get_top_property()
    }}
    #[inline] pub fn get_top(element: &super::UIElement) -> Result<f64> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().get_top(element)
    }}
    #[inline] pub fn set_top(element: &super::UIElement, length: f64) -> Result<()> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().set_top(element, length)
    }}
    #[inline] pub fn get_zindex_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().get_zindex_property()
    }}
    #[inline] pub fn get_zindex(element: &super::UIElement) -> Result<i32> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().get_zindex(element)
    }}
    #[inline] pub fn set_zindex(element: &super::UIElement, value: i32) -> Result<()> { unsafe {
        <Self as RtActivatable<ICanvasStatics>>::get_activation_factory().set_zindex(element, value)
    }}
}
DEFINE_CLSID!(Canvas(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,97,110,118,97,115,0]) [CLSID_Canvas]);
DEFINE_IID!(IID_ICanvasFactory, 456297425, 46080, 19086, 148, 59, 90, 210, 196, 91, 224, 223);
RT_INTERFACE!{interface ICanvasFactory(ICanvasFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICanvasFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Canvas) -> HRESULT
}}
impl ICanvasFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Canvas>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICanvasStatics, 1087265862, 10594, 17519, 170, 251, 76, 220, 72, 105, 57, 201);
RT_INTERFACE!{static interface ICanvasStatics(ICanvasStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICanvasStatics] {
    fn get_LeftProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetLeft(&self, element: *mut super::UIElement, out: *mut f64) -> HRESULT,
    fn SetLeft(&self, element: *mut super::UIElement, length: f64) -> HRESULT,
    fn get_TopProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetTop(&self, element: *mut super::UIElement, out: *mut f64) -> HRESULT,
    fn SetTop(&self, element: *mut super::UIElement, length: f64) -> HRESULT,
    fn get_ZIndexProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetZIndex(&self, element: *mut super::UIElement, out: *mut i32) -> HRESULT,
    fn SetZIndex(&self, element: *mut super::UIElement, value: i32) -> HRESULT
}}
impl ICanvasStatics {
    #[inline] pub unsafe fn get_left_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LeftProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_left(&self, element: &super::UIElement) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetLeft)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_left(&self, element: &super::UIElement, length: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).SetLeft)(self as *const _ as *mut _, element as *const _ as *mut _, length);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_top_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TopProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_top(&self, element: &super::UIElement) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetTop)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_top(&self, element: &super::UIElement, length: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).SetTop)(self as *const _ as *mut _, element as *const _ as *mut _, length);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zindex_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ZIndexProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_zindex(&self, element: &super::UIElement) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetZIndex)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_zindex(&self, element: &super::UIElement, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetZIndex)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICaptureElement, 832946407, 62215, 19786, 182, 38, 233, 120, 134, 63, 91, 116);
RT_INTERFACE!{interface ICaptureElement(ICaptureElementVtbl): IInspectable(IInspectableVtbl) [IID_ICaptureElement] {
    #[cfg(not(feature="windows-media"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-media")] fn get_Source(&self, out: *mut *mut ::rt::gen::windows::media::capture::MediaCapture) -> HRESULT,
    #[cfg(not(feature="windows-media"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-media")] fn put_Source(&self, value: *mut ::rt::gen::windows::media::capture::MediaCapture) -> HRESULT,
    fn get_Stretch(&self, out: *mut super::media::Stretch) -> HRESULT,
    fn put_Stretch(&self, value: super::media::Stretch) -> HRESULT
}}
impl ICaptureElement {
    #[cfg(feature="windows-media")] #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<::rt::gen::windows::media::capture::MediaCapture>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-media")] #[inline] pub unsafe fn set_source(&self, value: &::rt::gen::windows::media::capture::MediaCapture) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Source)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stretch(&self) -> Result<super::media::Stretch> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Stretch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stretch(&self, value: super::media::Stretch) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Stretch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CaptureElement: ICaptureElement}
impl RtActivatable<ICaptureElementStatics> for CaptureElement {}
impl RtActivatable<IActivationFactory> for CaptureElement {}
impl CaptureElement {
    #[inline] pub fn get_source_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICaptureElementStatics>>::get_activation_factory().get_source_property()
    }}
    #[inline] pub fn get_stretch_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICaptureElementStatics>>::get_activation_factory().get_stretch_property()
    }}
}
DEFINE_CLSID!(CaptureElement(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,97,112,116,117,114,101,69,108,101,109,101,110,116,0]) [CLSID_CaptureElement]);
DEFINE_IID!(IID_ICaptureElementStatics, 507743725, 32166, 16542, 128, 110, 48, 90, 228, 173, 155, 63);
RT_INTERFACE!{static interface ICaptureElementStatics(ICaptureElementStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICaptureElementStatics] {
    fn get_SourceProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_StretchProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICaptureElementStatics {
    #[inline] pub unsafe fn get_source_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stretch_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StretchProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum CharacterCasing: i32 {
    Normal (CharacterCasing_Normal) = 0, Lower (CharacterCasing_Lower) = 1, Upper (CharacterCasing_Upper) = 2,
}}
DEFINE_IID!(IID_ICheckBox, 580176020, 32298, 19312, 176, 136, 143, 93, 129, 72, 117, 186);
RT_INTERFACE!{interface ICheckBox(ICheckBoxVtbl): IInspectable(IInspectableVtbl) [IID_ICheckBox] {
    
}}
RT_CLASS!{class CheckBox: ICheckBox}
DEFINE_IID!(IID_ICheckBoxFactory, 1336322747, 16203, 17153, 190, 7, 17, 114, 234, 97, 238, 251);
RT_INTERFACE!{interface ICheckBoxFactory(ICheckBoxFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICheckBoxFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut CheckBox) -> HRESULT
}}
impl ICheckBoxFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<CheckBox>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IChoosingGroupHeaderContainerEventArgs, 1742423254, 53761, 19826, 190, 172, 94, 142, 88, 175, 216, 199);
RT_INTERFACE!{interface IChoosingGroupHeaderContainerEventArgs(IChoosingGroupHeaderContainerEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IChoosingGroupHeaderContainerEventArgs] {
    fn get_GroupHeaderContainer(&self, out: *mut *mut ListViewBaseHeaderItem) -> HRESULT,
    fn put_GroupHeaderContainer(&self, value: *mut ListViewBaseHeaderItem) -> HRESULT,
    fn get_GroupIndex(&self, out: *mut i32) -> HRESULT,
    fn get_Group(&self, out: *mut *mut IInspectable) -> HRESULT
}}
impl IChoosingGroupHeaderContainerEventArgs {
    #[inline] pub unsafe fn get_group_header_container(&self) -> Result<ComPtr<ListViewBaseHeaderItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GroupHeaderContainer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_group_header_container(&self, value: &ListViewBaseHeaderItem) -> Result<()> {
        let hr = ((*self.lpVtbl).put_GroupHeaderContainer)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_group_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_GroupIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_group(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Group)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ChoosingGroupHeaderContainerEventArgs: IChoosingGroupHeaderContainerEventArgs}
impl RtActivatable<IActivationFactory> for ChoosingGroupHeaderContainerEventArgs {}
DEFINE_CLSID!(ChoosingGroupHeaderContainerEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,104,111,111,115,105,110,103,71,114,111,117,112,72,101,97,100,101,114,67,111,110,116,97,105,110,101,114,69,118,101,110,116,65,114,103,115,0]) [CLSID_ChoosingGroupHeaderContainerEventArgs]);
DEFINE_IID!(IID_IChoosingItemContainerEventArgs, 2612280270, 44647, 19072, 131, 99, 227, 254, 27, 36, 79, 44);
RT_INTERFACE!{interface IChoosingItemContainerEventArgs(IChoosingItemContainerEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IChoosingItemContainerEventArgs] {
    fn get_ItemIndex(&self, out: *mut i32) -> HRESULT,
    fn get_Item(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_ItemContainer(&self, out: *mut *mut primitives::SelectorItem) -> HRESULT,
    fn put_ItemContainer(&self, value: *mut primitives::SelectorItem) -> HRESULT,
    fn get_IsContainerPrepared(&self, out: *mut bool) -> HRESULT,
    fn put_IsContainerPrepared(&self, value: bool) -> HRESULT
}}
impl IChoosingItemContainerEventArgs {
    #[inline] pub unsafe fn get_item_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ItemIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_item(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Item)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_item_container(&self) -> Result<ComPtr<primitives::SelectorItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ItemContainer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_item_container(&self, value: &primitives::SelectorItem) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ItemContainer)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_container_prepared(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsContainerPrepared)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_container_prepared(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsContainerPrepared)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ChoosingItemContainerEventArgs: IChoosingItemContainerEventArgs}
impl RtActivatable<IActivationFactory> for ChoosingItemContainerEventArgs {}
DEFINE_CLSID!(ChoosingItemContainerEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,104,111,111,115,105,110,103,73,116,101,109,67,111,110,116,97,105,110,101,114,69,118,101,110,116,65,114,103,115,0]) [CLSID_ChoosingItemContainerEventArgs]);
DEFINE_IID!(IID_ICleanUpVirtualizedItemEventArgs, 3926248681, 37756, 16672, 132, 6, 121, 33, 133, 120, 67, 56);
RT_INTERFACE!{interface ICleanUpVirtualizedItemEventArgs(ICleanUpVirtualizedItemEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_ICleanUpVirtualizedItemEventArgs] {
    fn get_Value(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_UIElement(&self, out: *mut *mut super::UIElement) -> HRESULT,
    fn get_Cancel(&self, out: *mut bool) -> HRESULT,
    fn put_Cancel(&self, value: bool) -> HRESULT
}}
impl ICleanUpVirtualizedItemEventArgs {
    #[inline] pub unsafe fn get_value(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Value)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_uielement(&self) -> Result<ComPtr<super::UIElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UIElement)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cancel(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cancel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Cancel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class CleanUpVirtualizedItemEventArgs: ICleanUpVirtualizedItemEventArgs}
DEFINE_IID!(IID_CleanUpVirtualizedItemEventHandler, 3402289366, 3853, 18544, 136, 77, 242, 222, 223, 103, 66, 136);
RT_DELEGATE!{delegate CleanUpVirtualizedItemEventHandler(CleanUpVirtualizedItemEventHandlerVtbl, CleanUpVirtualizedItemEventHandlerImpl) [IID_CleanUpVirtualizedItemEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut CleanUpVirtualizedItemEventArgs) -> HRESULT
}}
impl CleanUpVirtualizedItemEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &CleanUpVirtualizedItemEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum ClickMode: i32 {
    Release (ClickMode_Release) = 0, Press (ClickMode_Press) = 1, Hover (ClickMode_Hover) = 2,
}}
DEFINE_IID!(IID_IColorChangedEventArgs, 888610847, 43728, 19514, 185, 123, 42, 191, 54, 69, 85, 57);
RT_INTERFACE!{interface IColorChangedEventArgs(IColorChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IColorChangedEventArgs] {
    #[cfg(feature="windows-ui")] fn get_OldColor(&self, out: *mut super::super::Color) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_NewColor(&self, out: *mut super::super::Color) -> HRESULT
}}
impl IColorChangedEventArgs {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_old_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OldColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_new_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ColorChangedEventArgs: IColorChangedEventArgs}
DEFINE_IID!(IID_IColorPicker, 1647502193, 23652, 17355, 139, 53, 127, 130, 221, 227, 103, 64);
RT_INTERFACE!{interface IColorPicker(IColorPickerVtbl): IInspectable(IInspectableVtbl) [IID_IColorPicker] {
    #[cfg(not(feature="windows-ui"))] fn __Dummy0(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_Color(&self, out: *mut super::super::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy1(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_Color(&self, value: super::super::Color) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy2(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_PreviousColor(&self, out: *mut *mut ::rt::gen::windows::foundation::IReference<super::super::Color>) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy3(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_PreviousColor(&self, value: *mut ::rt::gen::windows::foundation::IReference<super::super::Color>) -> HRESULT,
    fn get_IsAlphaEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsAlphaEnabled(&self, value: bool) -> HRESULT,
    fn get_IsColorSpectrumVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsColorSpectrumVisible(&self, value: bool) -> HRESULT,
    fn get_IsColorPreviewVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsColorPreviewVisible(&self, value: bool) -> HRESULT,
    fn get_IsColorSliderVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsColorSliderVisible(&self, value: bool) -> HRESULT,
    fn get_IsAlphaSliderVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsAlphaSliderVisible(&self, value: bool) -> HRESULT,
    fn get_IsMoreButtonVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsMoreButtonVisible(&self, value: bool) -> HRESULT,
    fn get_IsColorChannelTextInputVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsColorChannelTextInputVisible(&self, value: bool) -> HRESULT,
    fn get_IsAlphaTextInputVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsAlphaTextInputVisible(&self, value: bool) -> HRESULT,
    fn get_IsHexInputVisible(&self, out: *mut bool) -> HRESULT,
    fn put_IsHexInputVisible(&self, value: bool) -> HRESULT,
    fn get_MinHue(&self, out: *mut i32) -> HRESULT,
    fn put_MinHue(&self, value: i32) -> HRESULT,
    fn get_MaxHue(&self, out: *mut i32) -> HRESULT,
    fn put_MaxHue(&self, value: i32) -> HRESULT,
    fn get_MinSaturation(&self, out: *mut i32) -> HRESULT,
    fn put_MinSaturation(&self, value: i32) -> HRESULT,
    fn get_MaxSaturation(&self, out: *mut i32) -> HRESULT,
    fn put_MaxSaturation(&self, value: i32) -> HRESULT,
    fn get_MinValue(&self, out: *mut i32) -> HRESULT,
    fn put_MinValue(&self, value: i32) -> HRESULT,
    fn get_MaxValue(&self, out: *mut i32) -> HRESULT,
    fn put_MaxValue(&self, value: i32) -> HRESULT,
    fn get_ColorSpectrumShape(&self, out: *mut ColorSpectrumShape) -> HRESULT,
    fn put_ColorSpectrumShape(&self, value: ColorSpectrumShape) -> HRESULT,
    fn get_ColorSpectrumComponents(&self, out: *mut ColorSpectrumComponents) -> HRESULT,
    fn put_ColorSpectrumComponents(&self, value: ColorSpectrumComponents) -> HRESULT,
    fn add_ColorChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ColorPicker, ColorChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ColorChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IColorPicker {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_color(&self) -> Result<super::super::Color> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Color)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_color(&self, value: super::super::Color) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Color)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_previous_color(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IReference<super::super::Color>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreviousColor)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_previous_color(&self, value: &::rt::gen::windows::foundation::IReference<super::super::Color>) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PreviousColor)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_alpha_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAlphaEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_alpha_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAlphaEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_spectrum_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsColorSpectrumVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_color_spectrum_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsColorSpectrumVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_preview_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsColorPreviewVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_color_preview_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsColorPreviewVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_slider_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsColorSliderVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_color_slider_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsColorSliderVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_alpha_slider_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAlphaSliderVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_alpha_slider_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAlphaSliderVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_more_button_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsMoreButtonVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_more_button_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsMoreButtonVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_channel_text_input_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsColorChannelTextInputVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_color_channel_text_input_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsColorChannelTextInputVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_alpha_text_input_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsAlphaTextInputVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_alpha_text_input_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsAlphaTextInputVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hex_input_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHexInputVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_hex_input_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHexInputVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_hue(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinHue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_hue(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinHue)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_hue(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxHue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_hue(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxHue)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_saturation(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinSaturation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_saturation(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinSaturation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_saturation(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxSaturation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_saturation(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxSaturation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_value(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinValue)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_value(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxValue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_value(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxValue)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_color_spectrum_shape(&self) -> Result<ColorSpectrumShape> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ColorSpectrumShape)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_color_spectrum_shape(&self, value: ColorSpectrumShape) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ColorSpectrumShape)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_color_spectrum_components(&self) -> Result<ColorSpectrumComponents> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ColorSpectrumComponents)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_color_spectrum_components(&self, value: ColorSpectrumComponents) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ColorSpectrumComponents)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_color_changed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ColorPicker, ColorChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ColorChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_color_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ColorChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ColorPicker: IColorPicker}
impl RtActivatable<IColorPickerStatics> for ColorPicker {}
impl ColorPicker {
    #[inline] pub fn get_color_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_color_property()
    }}
    #[inline] pub fn get_previous_color_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_previous_color_property()
    }}
    #[inline] pub fn get_is_alpha_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_alpha_enabled_property()
    }}
    #[inline] pub fn get_is_color_spectrum_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_color_spectrum_visible_property()
    }}
    #[inline] pub fn get_is_color_preview_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_color_preview_visible_property()
    }}
    #[inline] pub fn get_is_color_slider_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_color_slider_visible_property()
    }}
    #[inline] pub fn get_is_alpha_slider_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_alpha_slider_visible_property()
    }}
    #[inline] pub fn get_is_more_button_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_more_button_visible_property()
    }}
    #[inline] pub fn get_is_color_channel_text_input_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_color_channel_text_input_visible_property()
    }}
    #[inline] pub fn get_is_alpha_text_input_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_alpha_text_input_visible_property()
    }}
    #[inline] pub fn get_is_hex_input_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_is_hex_input_visible_property()
    }}
    #[inline] pub fn get_min_hue_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_min_hue_property()
    }}
    #[inline] pub fn get_max_hue_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_max_hue_property()
    }}
    #[inline] pub fn get_min_saturation_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_min_saturation_property()
    }}
    #[inline] pub fn get_max_saturation_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_max_saturation_property()
    }}
    #[inline] pub fn get_min_value_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_min_value_property()
    }}
    #[inline] pub fn get_max_value_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_max_value_property()
    }}
    #[inline] pub fn get_color_spectrum_shape_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_color_spectrum_shape_property()
    }}
    #[inline] pub fn get_color_spectrum_components_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColorPickerStatics>>::get_activation_factory().get_color_spectrum_components_property()
    }}
}
DEFINE_CLSID!(ColorPicker(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,108,111,114,80,105,99,107,101,114,0]) [CLSID_ColorPicker]);
DEFINE_IID!(IID_IColorPickerFactory, 2880309247, 44751, 18461, 146, 4, 32, 28, 56, 148, 205, 27);
RT_INTERFACE!{interface IColorPickerFactory(IColorPickerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IColorPickerFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ColorPicker) -> HRESULT
}}
impl IColorPickerFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ColorPicker>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
RT_ENUM! { enum ColorPickerHsvChannel: i32 {
    Hue (ColorPickerHsvChannel_Hue) = 0, Saturation (ColorPickerHsvChannel_Saturation) = 1, Value (ColorPickerHsvChannel_Value) = 2, Alpha (ColorPickerHsvChannel_Alpha) = 3,
}}
DEFINE_IID!(IID_IColorPickerStatics, 1741331431, 5492, 17690, 182, 223, 254, 87, 217, 208, 123, 70);
RT_INTERFACE!{static interface IColorPickerStatics(IColorPickerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IColorPickerStatics] {
    fn get_ColorProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PreviousColorProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsAlphaEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsColorSpectrumVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsColorPreviewVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsColorSliderVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsAlphaSliderVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsMoreButtonVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsColorChannelTextInputVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsAlphaTextInputVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsHexInputVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinHueProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxHueProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinSaturationProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxSaturationProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinValueProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxValueProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ColorSpectrumShapeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ColorSpectrumComponentsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IColorPickerStatics {
    #[inline] pub unsafe fn get_color_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColorProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_previous_color_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PreviousColorProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_alpha_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsAlphaEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_spectrum_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsColorSpectrumVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_preview_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsColorPreviewVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_slider_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsColorSliderVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_alpha_slider_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsAlphaSliderVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_more_button_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsMoreButtonVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_color_channel_text_input_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsColorChannelTextInputVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_alpha_text_input_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsAlphaTextInputVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_hex_input_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsHexInputVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_hue_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinHueProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_hue_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxHueProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_saturation_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinSaturationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_saturation_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxSaturationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_value_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinValueProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_value_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxValueProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_color_spectrum_shape_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColorSpectrumShapeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_color_spectrum_components_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColorSpectrumComponentsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ColorSpectrumComponents: i32 {
    HueValue (ColorSpectrumComponents_HueValue) = 0, ValueHue (ColorSpectrumComponents_ValueHue) = 1, HueSaturation (ColorSpectrumComponents_HueSaturation) = 2, SaturationHue (ColorSpectrumComponents_SaturationHue) = 3, SaturationValue (ColorSpectrumComponents_SaturationValue) = 4, ValueSaturation (ColorSpectrumComponents_ValueSaturation) = 5,
}}
RT_ENUM! { enum ColorSpectrumShape: i32 {
    Box (ColorSpectrumShape_Box) = 0, Ring (ColorSpectrumShape_Ring) = 1,
}}
DEFINE_IID!(IID_IColumnDefinition, 4159812137, 61476, 18047, 151, 10, 126, 112, 86, 21, 219, 123);
RT_INTERFACE!{interface IColumnDefinition(IColumnDefinitionVtbl): IInspectable(IInspectableVtbl) [IID_IColumnDefinition] {
    fn get_Width(&self, out: *mut super::GridLength) -> HRESULT,
    fn put_Width(&self, value: super::GridLength) -> HRESULT,
    fn get_MaxWidth(&self, out: *mut f64) -> HRESULT,
    fn put_MaxWidth(&self, value: f64) -> HRESULT,
    fn get_MinWidth(&self, out: *mut f64) -> HRESULT,
    fn put_MinWidth(&self, value: f64) -> HRESULT,
    fn get_ActualWidth(&self, out: *mut f64) -> HRESULT
}}
impl IColumnDefinition {
    #[inline] pub unsafe fn get_width(&self) -> Result<super::GridLength> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Width)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_width(&self, value: super::GridLength) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Width)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_width(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinWidth)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_actual_width(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ActualWidth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ColumnDefinition: IColumnDefinition}
impl RtActivatable<IColumnDefinitionStatics> for ColumnDefinition {}
impl RtActivatable<IActivationFactory> for ColumnDefinition {}
impl ColumnDefinition {
    #[inline] pub fn get_width_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColumnDefinitionStatics>>::get_activation_factory().get_width_property()
    }}
    #[inline] pub fn get_max_width_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColumnDefinitionStatics>>::get_activation_factory().get_max_width_property()
    }}
    #[inline] pub fn get_min_width_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IColumnDefinitionStatics>>::get_activation_factory().get_min_width_property()
    }}
}
DEFINE_CLSID!(ColumnDefinition(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,108,117,109,110,68,101,102,105,110,105,116,105,111,110,0]) [CLSID_ColumnDefinition]);
RT_CLASS!{class ColumnDefinitionCollection: ::rt::gen::windows::foundation::collections::IVector<ColumnDefinition>}
DEFINE_IID!(IID_IColumnDefinitionStatics, 112252712, 53316, 16582, 148, 46, 174, 96, 234, 199, 72, 81);
RT_INTERFACE!{static interface IColumnDefinitionStatics(IColumnDefinitionStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IColumnDefinitionStatics] {
    fn get_WidthProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxWidthProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinWidthProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IColumnDefinitionStatics {
    #[inline] pub unsafe fn get_width_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_WidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_width_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxWidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_width_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinWidthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBox, 3114848348, 44183, 18417, 165, 244, 63, 159, 77, 75, 17, 108);
RT_INTERFACE!{interface IComboBox(IComboBoxVtbl): IInspectable(IInspectableVtbl) [IID_IComboBox] {
    fn get_IsDropDownOpen(&self, out: *mut bool) -> HRESULT,
    fn put_IsDropDownOpen(&self, value: bool) -> HRESULT,
    fn get_IsEditable(&self, out: *mut bool) -> HRESULT,
    fn get_IsSelectionBoxHighlighted(&self, out: *mut bool) -> HRESULT,
    fn get_MaxDropDownHeight(&self, out: *mut f64) -> HRESULT,
    fn put_MaxDropDownHeight(&self, value: f64) -> HRESULT,
    fn get_SelectionBoxItem(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_SelectionBoxItemTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn get_TemplateSettings(&self, out: *mut *mut primitives::ComboBoxTemplateSettings) -> HRESULT,
    fn add_DropDownClosed(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DropDownClosed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_DropDownOpened(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DropDownOpened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IComboBox {
    #[inline] pub unsafe fn get_is_drop_down_open(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDropDownOpen)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_drop_down_open(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDropDownOpen)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_editable(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEditable)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_selection_box_highlighted(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSelectionBoxHighlighted)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_drop_down_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxDropDownHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_drop_down_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxDropDownHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selection_box_item(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectionBoxItem)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_selection_box_item_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectionBoxItemTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template_settings(&self) -> Result<ComPtr<primitives::ComboBoxTemplateSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TemplateSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drop_down_closed(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DropDownClosed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drop_down_closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DropDownClosed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_drop_down_opened(&self, value: &::rt::gen::windows::foundation::EventHandler<IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DropDownOpened)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_drop_down_opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DropDownOpened)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ComboBox: IComboBox}
impl RtActivatable<IComboBoxStatics> for ComboBox {}
impl RtActivatable<IComboBoxStatics2> for ComboBox {}
impl RtActivatable<IComboBoxStatics3> for ComboBox {}
impl RtActivatable<IComboBoxStatics4> for ComboBox {}
impl RtActivatable<IComboBoxStatics5> for ComboBox {}
impl ComboBox {
    #[inline] pub fn get_is_drop_down_open_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics>>::get_activation_factory().get_is_drop_down_open_property()
    }}
    #[inline] pub fn get_max_drop_down_height_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics>>::get_activation_factory().get_max_drop_down_height_property()
    }}
    #[inline] pub fn get_header_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics2>>::get_activation_factory().get_header_property()
    }}
    #[inline] pub fn get_header_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics2>>::get_activation_factory().get_header_template_property()
    }}
    #[inline] pub fn get_placeholder_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics2>>::get_activation_factory().get_placeholder_text_property()
    }}
    #[inline] pub fn get_light_dismiss_overlay_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics3>>::get_activation_factory().get_light_dismiss_overlay_mode_property()
    }}
    #[inline] pub fn get_is_text_search_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics3>>::get_activation_factory().get_is_text_search_enabled_property()
    }}
    #[inline] pub fn get_selection_changed_trigger_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics4>>::get_activation_factory().get_selection_changed_trigger_property()
    }}
    #[inline] pub fn get_placeholder_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IComboBoxStatics5>>::get_activation_factory().get_placeholder_foreground_property()
    }}
}
DEFINE_CLSID!(ComboBox(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,109,98,111,66,111,120,0]) [CLSID_ComboBox]);
DEFINE_IID!(IID_IComboBox2, 3926704017, 51766, 20397, 151, 42, 46, 83, 166, 113, 139, 159);
RT_INTERFACE!{interface IComboBox2(IComboBox2Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBox2] {
    fn get_Header(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Header(&self, value: *mut IInspectable) -> HRESULT,
    fn get_HeaderTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_HeaderTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_PlaceholderText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PlaceholderText(&self, value: HSTRING) -> HRESULT
}}
impl IComboBox2 {
    #[inline] pub unsafe fn get_header(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Header)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_placeholder_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaceholderText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBox3, 1379928675, 18284, 19382, 183, 129, 1, 147, 36, 211, 254, 217);
RT_INTERFACE!{interface IComboBox3(IComboBox3Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBox3] {
    fn get_LightDismissOverlayMode(&self, out: *mut LightDismissOverlayMode) -> HRESULT,
    fn put_LightDismissOverlayMode(&self, value: LightDismissOverlayMode) -> HRESULT,
    fn get_IsTextSearchEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTextSearchEnabled(&self, value: bool) -> HRESULT
}}
impl IComboBox3 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode(&self) -> Result<LightDismissOverlayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_light_dismiss_overlay_mode(&self, value: LightDismissOverlayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LightDismissOverlayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_text_search_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTextSearchEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_text_search_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTextSearchEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBox4, 3080146761, 45148, 18425, 154, 175, 214, 249, 24, 123, 229, 253);
RT_INTERFACE!{interface IComboBox4(IComboBox4Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBox4] {
    fn get_SelectionChangedTrigger(&self, out: *mut ComboBoxSelectionChangedTrigger) -> HRESULT,
    fn put_SelectionChangedTrigger(&self, value: ComboBoxSelectionChangedTrigger) -> HRESULT
}}
impl IComboBox4 {
    #[inline] pub unsafe fn get_selection_changed_trigger(&self) -> Result<ComboBoxSelectionChangedTrigger> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SelectionChangedTrigger)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_selection_changed_trigger(&self, value: ComboBoxSelectionChangedTrigger) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SelectionChangedTrigger)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBox5, 2876888646, 32778, 18984, 150, 155, 52, 187, 143, 180, 88, 207);
RT_INTERFACE!{interface IComboBox5(IComboBox5Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBox5] {
    fn get_PlaceholderForeground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_PlaceholderForeground(&self, value: *mut super::media::Brush) -> HRESULT
}}
impl IComboBox5 {
    #[inline] pub unsafe fn get_placeholder_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderForeground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_placeholder_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PlaceholderForeground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxFactory, 2886534212, 42587, 19133, 134, 223, 48, 22, 4, 158, 254, 220);
RT_INTERFACE!{interface IComboBoxFactory(IComboBoxFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ComboBox) -> HRESULT
}}
impl IComboBoxFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ComboBox>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxItem, 2571097810, 10926, 20283, 180, 77, 86, 72, 244, 208, 97, 20);
RT_INTERFACE!{interface IComboBoxItem(IComboBoxItemVtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxItem] {
    
}}
RT_CLASS!{class ComboBoxItem: IComboBoxItem}
DEFINE_IID!(IID_IComboBoxItemFactory, 2415913063, 55628, 20103, 143, 196, 110, 188, 214, 60, 90, 194);
RT_INTERFACE!{interface IComboBoxItemFactory(IComboBoxItemFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxItemFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ComboBoxItem) -> HRESULT
}}
impl IComboBoxItemFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ComboBoxItem>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxOverrides, 1325491521, 48382, 18978, 137, 50, 201, 20, 152, 28, 34, 64);
RT_INTERFACE!{interface IComboBoxOverrides(IComboBoxOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxOverrides] {
    fn OnDropDownClosed(&self, e: *mut IInspectable) -> HRESULT,
    fn OnDropDownOpened(&self, e: *mut IInspectable) -> HRESULT
}}
impl IComboBoxOverrides {
    #[inline] pub unsafe fn on_drop_down_closed(&self, e: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDropDownClosed)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_drop_down_opened(&self, e: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDropDownOpened)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum ComboBoxSelectionChangedTrigger: i32 {
    Committed (ComboBoxSelectionChangedTrigger_Committed) = 0, Always (ComboBoxSelectionChangedTrigger_Always) = 1,
}}
DEFINE_IID!(IID_IComboBoxStatics, 1041549745, 53595, 19913, 129, 16, 207, 58, 17, 123, 150, 231);
RT_INTERFACE!{static interface IComboBoxStatics(IComboBoxStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxStatics] {
    fn get_IsDropDownOpenProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxDropDownHeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IComboBoxStatics {
    #[inline] pub unsafe fn get_is_drop_down_open_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsDropDownOpenProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_drop_down_height_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxDropDownHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxStatics2, 2476247569, 16428, 19219, 150, 209, 114, 32, 38, 107, 146, 32);
RT_INTERFACE!{static interface IComboBoxStatics2(IComboBoxStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxStatics2] {
    fn get_HeaderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PlaceholderTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IComboBoxStatics2 {
    #[inline] pub unsafe fn get_header_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_placeholder_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxStatics3, 2493387791, 52863, 20033, 189, 197, 209, 211, 56, 138, 208, 166);
RT_INTERFACE!{static interface IComboBoxStatics3(IComboBoxStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxStatics3] {
    fn get_LightDismissOverlayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTextSearchEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IComboBoxStatics3 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_text_search_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTextSearchEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxStatics4, 3656745816, 63408, 18126, 128, 97, 173, 131, 236, 47, 45, 212);
RT_INTERFACE!{static interface IComboBoxStatics4(IComboBoxStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxStatics4] {
    fn get_SelectionChangedTriggerProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IComboBoxStatics4 {
    #[inline] pub unsafe fn get_selection_changed_trigger_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SelectionChangedTriggerProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IComboBoxStatics5, 3087191793, 41572, 17482, 154, 97, 170, 136, 103, 183, 166, 60);
RT_INTERFACE!{static interface IComboBoxStatics5(IComboBoxStatics5Vtbl): IInspectable(IInspectableVtbl) [IID_IComboBoxStatics5] {
    fn get_PlaceholderForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IComboBoxStatics5 {
    #[inline] pub unsafe fn get_placeholder_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlaceholderForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBar, 2562474624, 19005, 19694, 189, 7, 34, 206, 148, 197, 175, 118);
RT_INTERFACE!{interface ICommandBar(ICommandBarVtbl): IInspectable(IInspectableVtbl) [IID_ICommandBar] {
    fn get_PrimaryCommands(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IObservableVector<ICommandBarElement>) -> HRESULT,
    fn get_SecondaryCommands(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IObservableVector<ICommandBarElement>) -> HRESULT
}}
impl ICommandBar {
    #[inline] pub unsafe fn get_primary_commands(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IObservableVector<ICommandBarElement>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryCommands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_commands(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IObservableVector<ICommandBarElement>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryCommands)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class CommandBar: ICommandBar}
impl RtActivatable<ICommandBarStatics> for CommandBar {}
impl RtActivatable<ICommandBarStatics2> for CommandBar {}
impl RtActivatable<ICommandBarStatics3> for CommandBar {}
impl CommandBar {
    #[inline] pub fn get_primary_commands_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICommandBarStatics>>::get_activation_factory().get_primary_commands_property()
    }}
    #[inline] pub fn get_secondary_commands_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICommandBarStatics>>::get_activation_factory().get_secondary_commands_property()
    }}
    #[inline] pub fn get_command_bar_overflow_presenter_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICommandBarStatics2>>::get_activation_factory().get_command_bar_overflow_presenter_style_property()
    }}
    #[inline] pub fn get_default_label_position_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICommandBarStatics3>>::get_activation_factory().get_default_label_position_property()
    }}
    #[inline] pub fn get_overflow_button_visibility_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICommandBarStatics3>>::get_activation_factory().get_overflow_button_visibility_property()
    }}
    #[inline] pub fn get_is_dynamic_overflow_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<ICommandBarStatics3>>::get_activation_factory().get_is_dynamic_overflow_enabled_property()
    }}
}
DEFINE_CLSID!(CommandBar(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,109,109,97,110,100,66,97,114,0]) [CLSID_CommandBar]);
DEFINE_IID!(IID_ICommandBar2, 1466314584, 23346, 18269, 190, 100, 76, 163, 110, 123, 151, 212);
RT_INTERFACE!{interface ICommandBar2(ICommandBar2Vtbl): IInspectable(IInspectableVtbl) [IID_ICommandBar2] {
    fn get_CommandBarOverflowPresenterStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_CommandBarOverflowPresenterStyle(&self, value: *mut super::Style) -> HRESULT,
    fn get_CommandBarTemplateSettings(&self, out: *mut *mut primitives::CommandBarTemplateSettings) -> HRESULT
}}
impl ICommandBar2 {
    #[inline] pub unsafe fn get_command_bar_overflow_presenter_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommandBarOverflowPresenterStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_command_bar_overflow_presenter_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CommandBarOverflowPresenterStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_command_bar_template_settings(&self) -> Result<ComPtr<primitives::CommandBarTemplateSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommandBarTemplateSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBar3, 1089190947, 10873, 18611, 154, 103, 100, 155, 133, 45, 133, 137);
RT_INTERFACE!{interface ICommandBar3(ICommandBar3Vtbl): IInspectable(IInspectableVtbl) [IID_ICommandBar3] {
    fn get_DefaultLabelPosition(&self, out: *mut CommandBarDefaultLabelPosition) -> HRESULT,
    fn put_DefaultLabelPosition(&self, value: CommandBarDefaultLabelPosition) -> HRESULT,
    fn get_OverflowButtonVisibility(&self, out: *mut CommandBarOverflowButtonVisibility) -> HRESULT,
    fn put_OverflowButtonVisibility(&self, value: CommandBarOverflowButtonVisibility) -> HRESULT,
    fn get_IsDynamicOverflowEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsDynamicOverflowEnabled(&self, value: bool) -> HRESULT,
    fn add_DynamicOverflowItemsChanging(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<CommandBar, DynamicOverflowItemsChangingEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DynamicOverflowItemsChanging(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl ICommandBar3 {
    #[inline] pub unsafe fn get_default_label_position(&self) -> Result<CommandBarDefaultLabelPosition> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultLabelPosition)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_label_position(&self, value: CommandBarDefaultLabelPosition) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultLabelPosition)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_overflow_button_visibility(&self) -> Result<CommandBarOverflowButtonVisibility> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OverflowButtonVisibility)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_overflow_button_visibility(&self, value: CommandBarOverflowButtonVisibility) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OverflowButtonVisibility)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_dynamic_overflow_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsDynamicOverflowEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_dynamic_overflow_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsDynamicOverflowEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_dynamic_overflow_items_changing(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<CommandBar, DynamicOverflowItemsChangingEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DynamicOverflowItemsChanging)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_dynamic_overflow_items_changing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DynamicOverflowItemsChanging)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_ENUM! { enum CommandBarDefaultLabelPosition: i32 {
    Bottom (CommandBarDefaultLabelPosition_Bottom) = 0, Right (CommandBarDefaultLabelPosition_Right) = 1, Collapsed (CommandBarDefaultLabelPosition_Collapsed) = 2,
}}
RT_ENUM! { enum CommandBarDynamicOverflowAction: i32 {
    AddingToOverflow (CommandBarDynamicOverflowAction_AddingToOverflow) = 0, RemovingFromOverflow (CommandBarDynamicOverflowAction_RemovingFromOverflow) = 1,
}}
DEFINE_IID!(IID_ICommandBarElement, 1737592347, 62165, 17617, 139, 132, 146, 184, 127, 128, 163, 80);
RT_INTERFACE!{interface ICommandBarElement(ICommandBarElementVtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarElement] {
    fn get_IsCompact(&self, out: *mut bool) -> HRESULT,
    fn put_IsCompact(&self, value: bool) -> HRESULT
}}
impl ICommandBarElement {
    #[inline] pub unsafe fn get_is_compact(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsCompact)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_compact(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsCompact)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBarElement2, 2847871542, 17410, 18056, 185, 135, 157, 43, 155, 123, 242, 189);
RT_INTERFACE!{interface ICommandBarElement2(ICommandBarElement2Vtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarElement2] {
    fn get_IsInOverflow(&self, out: *mut bool) -> HRESULT,
    fn get_DynamicOverflowOrder(&self, out: *mut i32) -> HRESULT,
    fn put_DynamicOverflowOrder(&self, value: i32) -> HRESULT
}}
impl ICommandBarElement2 {
    #[inline] pub unsafe fn get_is_in_overflow(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsInOverflow)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_dynamic_overflow_order(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DynamicOverflowOrder)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_dynamic_overflow_order(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DynamicOverflowOrder)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBarFactory, 1740499780, 8417, 16759, 173, 68, 246, 23, 179, 116, 232, 232);
RT_INTERFACE!{interface ICommandBarFactory(ICommandBarFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut CommandBar) -> HRESULT
}}
impl ICommandBarFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<CommandBar>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
RT_ENUM! { enum CommandBarLabelPosition: i32 {
    Default (CommandBarLabelPosition_Default) = 0, Collapsed (CommandBarLabelPosition_Collapsed) = 1,
}}
RT_ENUM! { enum CommandBarOverflowButtonVisibility: i32 {
    Auto (CommandBarOverflowButtonVisibility_Auto) = 0, Visible (CommandBarOverflowButtonVisibility_Visible) = 1, Collapsed (CommandBarOverflowButtonVisibility_Collapsed) = 2,
}}
DEFINE_IID!(IID_ICommandBarOverflowPresenter, 1853527079, 22767, 17254, 160, 23, 24, 193, 147, 213, 107, 20);
RT_INTERFACE!{interface ICommandBarOverflowPresenter(ICommandBarOverflowPresenterVtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarOverflowPresenter] {
    
}}
RT_CLASS!{class CommandBarOverflowPresenter: ICommandBarOverflowPresenter}
DEFINE_IID!(IID_ICommandBarOverflowPresenterFactory, 2200172404, 23210, 16457, 183, 143, 33, 140, 106, 25, 195, 126);
RT_INTERFACE!{interface ICommandBarOverflowPresenterFactory(ICommandBarOverflowPresenterFactoryVtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarOverflowPresenterFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut CommandBarOverflowPresenter) -> HRESULT
}}
impl ICommandBarOverflowPresenterFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<CommandBarOverflowPresenter>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBarStatics, 1540981226, 57976, 16540, 181, 34, 249, 70, 202, 37, 59, 68);
RT_INTERFACE!{static interface ICommandBarStatics(ICommandBarStaticsVtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarStatics] {
    fn get_PrimaryCommandsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SecondaryCommandsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICommandBarStatics {
    #[inline] pub unsafe fn get_primary_commands_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryCommandsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_commands_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryCommandsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBarStatics2, 1033816291, 20905, 20020, 149, 108, 112, 129, 208, 111, 38, 248);
RT_INTERFACE!{static interface ICommandBarStatics2(ICommandBarStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarStatics2] {
    fn get_CommandBarOverflowPresenterStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICommandBarStatics2 {
    #[inline] pub unsafe fn get_command_bar_overflow_presenter_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CommandBarOverflowPresenterStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_ICommandBarStatics3, 3025806500, 35569, 18499, 179, 25, 224, 63, 196, 90, 183, 38);
RT_INTERFACE!{static interface ICommandBarStatics3(ICommandBarStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_ICommandBarStatics3] {
    fn get_DefaultLabelPositionProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_OverflowButtonVisibilityProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsDynamicOverflowEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl ICommandBarStatics3 {
    #[inline] pub unsafe fn get_default_label_position_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultLabelPositionProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_overflow_button_visibility_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OverflowButtonVisibilityProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_dynamic_overflow_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsDynamicOverflowEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContainerContentChangingEventArgs, 132049575, 399, 19930, 179, 153, 253, 78, 19, 163, 27, 234);
RT_INTERFACE!{interface IContainerContentChangingEventArgs(IContainerContentChangingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContainerContentChangingEventArgs] {
    fn get_ItemContainer(&self, out: *mut *mut primitives::SelectorItem) -> HRESULT,
    fn get_InRecycleQueue(&self, out: *mut bool) -> HRESULT,
    fn get_ItemIndex(&self, out: *mut i32) -> HRESULT,
    fn get_Item(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn get_Phase(&self, out: *mut u32) -> HRESULT,
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT,
    fn RegisterUpdateCallback(&self, callback: *mut ::rt::gen::windows::foundation::TypedEventHandler<ListViewBase, ContainerContentChangingEventArgs>) -> HRESULT,
    fn RegisterUpdateCallbackWithPhase(&self, callbackPhase: u32, callback: *mut ::rt::gen::windows::foundation::TypedEventHandler<ListViewBase, ContainerContentChangingEventArgs>) -> HRESULT
}}
impl IContainerContentChangingEventArgs {
    #[inline] pub unsafe fn get_item_container(&self) -> Result<ComPtr<primitives::SelectorItem>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ItemContainer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_in_recycle_queue(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InRecycleQueue)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_item_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ItemIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_item(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Item)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_phase(&self) -> Result<u32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Phase)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_update_callback(&self, callback: &::rt::gen::windows::foundation::TypedEventHandler<ListViewBase, ContainerContentChangingEventArgs>) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterUpdateCallback)(self as *const _ as *mut _, callback as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn register_update_callback_with_phase(&self, callbackPhase: u32, callback: &::rt::gen::windows::foundation::TypedEventHandler<ListViewBase, ContainerContentChangingEventArgs>) -> Result<()> {
        let hr = ((*self.lpVtbl).RegisterUpdateCallbackWithPhase)(self as *const _ as *mut _, callbackPhase, callback as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContainerContentChangingEventArgs: IContainerContentChangingEventArgs}
impl RtActivatable<IActivationFactory> for ContainerContentChangingEventArgs {}
DEFINE_CLSID!(ContainerContentChangingEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,110,116,97,105,110,101,114,67,111,110,116,101,110,116,67,104,97,110,103,105,110,103,69,118,101,110,116,65,114,103,115,0]) [CLSID_ContainerContentChangingEventArgs]);
DEFINE_IID!(IID_IContentControl, 2725106140, 52548, 17244, 190, 148, 1, 214, 36, 28, 35, 28);
RT_INTERFACE!{interface IContentControl(IContentControlVtbl): IInspectable(IInspectableVtbl) [IID_IContentControl] {
    fn get_Content(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Content(&self, value: *mut IInspectable) -> HRESULT,
    fn get_ContentTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_ContentTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_ContentTemplateSelector(&self, out: *mut *mut DataTemplateSelector) -> HRESULT,
    fn put_ContentTemplateSelector(&self, value: *mut DataTemplateSelector) -> HRESULT,
    fn get_ContentTransitions(&self, out: *mut *mut super::media::animation::TransitionCollection) -> HRESULT,
    fn put_ContentTransitions(&self, value: *mut super::media::animation::TransitionCollection) -> HRESULT
}}
impl IContentControl {
    #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Content)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_selector(&self) -> Result<ComPtr<DataTemplateSelector>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_template_selector(&self, value: &DataTemplateSelector) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTemplateSelector)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_transitions(&self) -> Result<ComPtr<super::media::animation::TransitionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTransitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_transitions(&self, value: &super::media::animation::TransitionCollection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTransitions)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContentControl: IContentControl}
impl RtActivatable<IContentControlStatics> for ContentControl {}
impl ContentControl {
    #[inline] pub fn get_content_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentControlStatics>>::get_activation_factory().get_content_property()
    }}
    #[inline] pub fn get_content_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentControlStatics>>::get_activation_factory().get_content_template_property()
    }}
    #[inline] pub fn get_content_template_selector_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentControlStatics>>::get_activation_factory().get_content_template_selector_property()
    }}
    #[inline] pub fn get_content_transitions_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentControlStatics>>::get_activation_factory().get_content_transitions_property()
    }}
}
DEFINE_CLSID!(ContentControl(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,110,116,101,110,116,67,111,110,116,114,111,108,0]) [CLSID_ContentControl]);
DEFINE_IID!(IID_IContentControl2, 1697390732, 36047, 17305, 189, 62, 90, 1, 90, 161, 188, 3);
RT_INTERFACE!{interface IContentControl2(IContentControl2Vtbl): IInspectable(IInspectableVtbl) [IID_IContentControl2] {
    fn get_ContentTemplateRoot(&self, out: *mut *mut super::UIElement) -> HRESULT
}}
impl IContentControl2 {
    #[inline] pub unsafe fn get_content_template_root(&self) -> Result<ComPtr<super::UIElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateRoot)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentControlFactory, 2869000985, 6510, 20181, 162, 127, 85, 197, 143, 177, 103, 63);
RT_INTERFACE!{interface IContentControlFactory(IContentControlFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContentControlFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ContentControl) -> HRESULT
}}
impl IContentControlFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ContentControl>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentControlOverrides, 1598819088, 58254, 19293, 190, 26, 94, 208, 66, 70, 166, 53);
RT_INTERFACE!{interface IContentControlOverrides(IContentControlOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IContentControlOverrides] {
    fn OnContentChanged(&self, oldContent: *mut IInspectable, newContent: *mut IInspectable) -> HRESULT,
    fn OnContentTemplateChanged(&self, oldContentTemplate: *mut super::DataTemplate, newContentTemplate: *mut super::DataTemplate) -> HRESULT,
    fn OnContentTemplateSelectorChanged(&self, oldContentTemplateSelector: *mut DataTemplateSelector, newContentTemplateSelector: *mut DataTemplateSelector) -> HRESULT
}}
impl IContentControlOverrides {
    #[inline] pub unsafe fn on_content_changed(&self, oldContent: &IInspectable, newContent: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).OnContentChanged)(self as *const _ as *mut _, oldContent as *const _ as *mut _, newContent as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_content_template_changed(&self, oldContentTemplate: &super::DataTemplate, newContentTemplate: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).OnContentTemplateChanged)(self as *const _ as *mut _, oldContentTemplate as *const _ as *mut _, newContentTemplate as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_content_template_selector_changed(&self, oldContentTemplateSelector: &DataTemplateSelector, newContentTemplateSelector: &DataTemplateSelector) -> Result<()> {
        let hr = ((*self.lpVtbl).OnContentTemplateSelectorChanged)(self as *const _ as *mut _, oldContentTemplateSelector as *const _ as *mut _, newContentTemplateSelector as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentControlStatics, 292127396, 23797, 19461, 165, 63, 21, 228, 135, 108, 133, 236);
RT_INTERFACE!{static interface IContentControlStatics(IContentControlStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IContentControlStatics] {
    fn get_ContentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTemplateSelectorProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTransitionsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentControlStatics {
    #[inline] pub unsafe fn get_content_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_selector_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateSelectorProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_transitions_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTransitionsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentDialog, 953959428, 53838, 16600, 148, 21, 52, 148, 100, 193, 175, 220);
RT_INTERFACE!{interface IContentDialog(IContentDialogVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialog] {
    fn get_Title(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Title(&self, value: *mut IInspectable) -> HRESULT,
    fn get_TitleTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_TitleTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_FullSizeDesired(&self, out: *mut bool) -> HRESULT,
    fn put_FullSizeDesired(&self, value: bool) -> HRESULT,
    fn get_PrimaryButtonText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PrimaryButtonText(&self, value: HSTRING) -> HRESULT,
    fn get_SecondaryButtonText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SecondaryButtonText(&self, value: HSTRING) -> HRESULT,
    fn get_PrimaryButtonCommand(&self, out: *mut *mut super::input::ICommand) -> HRESULT,
    fn put_PrimaryButtonCommand(&self, value: *mut super::input::ICommand) -> HRESULT,
    fn get_SecondaryButtonCommand(&self, out: *mut *mut super::input::ICommand) -> HRESULT,
    fn put_SecondaryButtonCommand(&self, value: *mut super::input::ICommand) -> HRESULT,
    fn get_PrimaryButtonCommandParameter(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_PrimaryButtonCommandParameter(&self, value: *mut IInspectable) -> HRESULT,
    fn get_SecondaryButtonCommandParameter(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_SecondaryButtonCommandParameter(&self, value: *mut IInspectable) -> HRESULT,
    fn get_IsPrimaryButtonEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsPrimaryButtonEnabled(&self, value: bool) -> HRESULT,
    fn get_IsSecondaryButtonEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsSecondaryButtonEnabled(&self, value: bool) -> HRESULT,
    fn add_Closing(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogClosingEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Closed(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogClosedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Opened(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogOpenedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_PrimaryButtonClick(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogButtonClickEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_PrimaryButtonClick(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SecondaryButtonClick(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogButtonClickEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SecondaryButtonClick(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn Hide(&self) -> HRESULT,
    fn ShowAsync(&self, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<ContentDialogResult>) -> HRESULT
}}
impl IContentDialog {
    #[inline] pub unsafe fn get_title(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Title)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Title)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_title_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TitleTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_full_size_desired(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FullSizeDesired)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_full_size_desired(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FullSizeDesired)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_primary_button_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryButtonText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_secondary_button_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SecondaryButtonText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_command(&self) -> Result<ComPtr<super::input::ICommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonCommand)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_primary_button_command(&self, value: &super::input::ICommand) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryButtonCommand)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_command(&self) -> Result<ComPtr<super::input::ICommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonCommand)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_secondary_button_command(&self, value: &super::input::ICommand) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SecondaryButtonCommand)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_command_parameter(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonCommandParameter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_primary_button_command_parameter(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryButtonCommandParameter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_command_parameter(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonCommandParameter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_secondary_button_command_parameter(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SecondaryButtonCommandParameter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_primary_button_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsPrimaryButtonEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_primary_button_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsPrimaryButtonEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_secondary_button_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsSecondaryButtonEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_secondary_button_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsSecondaryButtonEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closing(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogClosingEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closing)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closing(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closing)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_closed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogClosedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Closed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_closed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Closed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_opened(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogOpenedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Opened)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Opened)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_primary_button_click(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogButtonClickEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_PrimaryButtonClick)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_primary_button_click(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_PrimaryButtonClick)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_secondary_button_click(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogButtonClickEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SecondaryButtonClick)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_secondary_button_click(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SecondaryButtonClick)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn hide(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Hide)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_async(&self) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<ContentDialogResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsync)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContentDialog: IContentDialog}
impl RtActivatable<IContentDialogStatics> for ContentDialog {}
impl RtActivatable<IContentDialogStatics2> for ContentDialog {}
impl ContentDialog {
    #[inline] pub fn get_title_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_title_property()
    }}
    #[inline] pub fn get_title_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_title_template_property()
    }}
    #[inline] pub fn get_full_size_desired_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_full_size_desired_property()
    }}
    #[inline] pub fn get_primary_button_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_primary_button_text_property()
    }}
    #[inline] pub fn get_secondary_button_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_secondary_button_text_property()
    }}
    #[inline] pub fn get_primary_button_command_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_primary_button_command_property()
    }}
    #[inline] pub fn get_secondary_button_command_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_secondary_button_command_property()
    }}
    #[inline] pub fn get_primary_button_command_parameter_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_primary_button_command_parameter_property()
    }}
    #[inline] pub fn get_secondary_button_command_parameter_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_secondary_button_command_parameter_property()
    }}
    #[inline] pub fn get_is_primary_button_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_is_primary_button_enabled_property()
    }}
    #[inline] pub fn get_is_secondary_button_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics>>::get_activation_factory().get_is_secondary_button_enabled_property()
    }}
    #[inline] pub fn get_close_button_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_close_button_text_property()
    }}
    #[inline] pub fn get_close_button_command_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_close_button_command_property()
    }}
    #[inline] pub fn get_close_button_command_parameter_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_close_button_command_parameter_property()
    }}
    #[inline] pub fn get_primary_button_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_primary_button_style_property()
    }}
    #[inline] pub fn get_secondary_button_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_secondary_button_style_property()
    }}
    #[inline] pub fn get_close_button_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_close_button_style_property()
    }}
    #[inline] pub fn get_default_button_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentDialogStatics2>>::get_activation_factory().get_default_button_property()
    }}
}
DEFINE_CLSID!(ContentDialog(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,110,116,101,110,116,68,105,97,108,111,103,0]) [CLSID_ContentDialog]);
DEFINE_IID!(IID_IContentDialog2, 798223173, 60995, 17155, 155, 56, 63, 225, 161, 17, 236, 191);
RT_INTERFACE!{interface IContentDialog2(IContentDialog2Vtbl): IInspectable(IInspectableVtbl) [IID_IContentDialog2] {
    fn get_CloseButtonText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CloseButtonText(&self, value: HSTRING) -> HRESULT,
    fn get_CloseButtonCommand(&self, out: *mut *mut super::input::ICommand) -> HRESULT,
    fn put_CloseButtonCommand(&self, value: *mut super::input::ICommand) -> HRESULT,
    fn get_CloseButtonCommandParameter(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_CloseButtonCommandParameter(&self, value: *mut IInspectable) -> HRESULT,
    fn get_PrimaryButtonStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_PrimaryButtonStyle(&self, value: *mut super::Style) -> HRESULT,
    fn get_SecondaryButtonStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_SecondaryButtonStyle(&self, value: *mut super::Style) -> HRESULT,
    fn get_CloseButtonStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_CloseButtonStyle(&self, value: *mut super::Style) -> HRESULT,
    fn get_DefaultButton(&self, out: *mut ContentDialogButton) -> HRESULT,
    fn put_DefaultButton(&self, value: ContentDialogButton) -> HRESULT,
    fn add_CloseButtonClick(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogButtonClickEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_CloseButtonClick(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IContentDialog2 {
    #[inline] pub unsafe fn get_close_button_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_close_button_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CloseButtonText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_close_button_command(&self) -> Result<ComPtr<super::input::ICommand>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonCommand)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_close_button_command(&self, value: &super::input::ICommand) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CloseButtonCommand)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_close_button_command_parameter(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonCommandParameter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_close_button_command_parameter(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CloseButtonCommandParameter)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_primary_button_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryButtonStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_secondary_button_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SecondaryButtonStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_close_button_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_close_button_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CloseButtonStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_button(&self) -> Result<ContentDialogButton> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultButton)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_button(&self, value: ContentDialogButton) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultButton)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_close_button_click(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<ContentDialog, ContentDialogButtonClickEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_CloseButtonClick)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_close_button_click(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_CloseButtonClick)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentDialog3, 2644117662, 63828, 20190, 176, 127, 107, 6, 154, 156, 1, 128);
RT_INTERFACE!{interface IContentDialog3(IContentDialog3Vtbl): IInspectable(IInspectableVtbl) [IID_IContentDialog3] {
    fn ShowAsyncWithPlacement(&self, placement: ContentDialogPlacement, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<ContentDialogResult>) -> HRESULT
}}
impl IContentDialog3 {
    #[inline] pub unsafe fn show_async_with_placement(&self, placement: ContentDialogPlacement) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<ContentDialogResult>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAsyncWithPlacement)(self as *const _ as *mut _, placement, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum ContentDialogButton: i32 {
    None (ContentDialogButton_None) = 0, Primary (ContentDialogButton_Primary) = 1, Secondary (ContentDialogButton_Secondary) = 2, Close (ContentDialogButton_Close) = 3,
}}
DEFINE_IID!(IID_IContentDialogButtonClickDeferral, 3171759671, 6606, 18758, 142, 119, 189, 3, 254, 142, 190, 3);
RT_INTERFACE!{interface IContentDialogButtonClickDeferral(IContentDialogButtonClickDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogButtonClickDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IContentDialogButtonClickDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContentDialogButtonClickDeferral: IContentDialogButtonClickDeferral}
DEFINE_IID!(IID_IContentDialogButtonClickEventArgs, 1597293061, 35578, 19698, 140, 160, 38, 77, 115, 190, 214, 61);
RT_INTERFACE!{interface IContentDialogButtonClickEventArgs(IContentDialogButtonClickEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogButtonClickEventArgs] {
    fn get_Cancel(&self, out: *mut bool) -> HRESULT,
    fn put_Cancel(&self, value: bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ContentDialogButtonClickDeferral) -> HRESULT
}}
impl IContentDialogButtonClickEventArgs {
    #[inline] pub unsafe fn get_cancel(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cancel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Cancel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<ContentDialogButtonClickDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContentDialogButtonClickEventArgs: IContentDialogButtonClickEventArgs}
DEFINE_IID!(IID_IContentDialogClosedEventArgs, 2421498607, 11450, 19192, 182, 102, 204, 54, 194, 39, 50, 251);
RT_INTERFACE!{interface IContentDialogClosedEventArgs(IContentDialogClosedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogClosedEventArgs] {
    fn get_Result(&self, out: *mut ContentDialogResult) -> HRESULT
}}
impl IContentDialogClosedEventArgs {
    #[inline] pub unsafe fn get_result(&self) -> Result<ContentDialogResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ContentDialogClosedEventArgs: IContentDialogClosedEventArgs}
DEFINE_IID!(IID_IContentDialogClosingDeferral, 559762705, 32304, 19641, 167, 16, 90, 79, 156, 202, 139, 66);
RT_INTERFACE!{interface IContentDialogClosingDeferral(IContentDialogClosingDeferralVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogClosingDeferral] {
    fn Complete(&self) -> HRESULT
}}
impl IContentDialogClosingDeferral {
    #[inline] pub unsafe fn complete(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).Complete)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContentDialogClosingDeferral: IContentDialogClosingDeferral}
DEFINE_IID!(IID_IContentDialogClosingEventArgs, 3678149684, 15295, 18388, 190, 79, 201, 236, 17, 89, 24, 185);
RT_INTERFACE!{interface IContentDialogClosingEventArgs(IContentDialogClosingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogClosingEventArgs] {
    fn get_Result(&self, out: *mut ContentDialogResult) -> HRESULT,
    fn get_Cancel(&self, out: *mut bool) -> HRESULT,
    fn put_Cancel(&self, value: bool) -> HRESULT,
    fn GetDeferral(&self, out: *mut *mut ContentDialogClosingDeferral) -> HRESULT
}}
impl IContentDialogClosingEventArgs {
    #[inline] pub unsafe fn get_result(&self) -> Result<ContentDialogResult> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Result)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cancel(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cancel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Cancel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_deferral(&self) -> Result<ComPtr<ContentDialogClosingDeferral>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetDeferral)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class ContentDialogClosingEventArgs: IContentDialogClosingEventArgs}
DEFINE_IID!(IID_IContentDialogFactory, 89485688, 40334, 17173, 179, 125, 104, 12, 20, 1, 44, 53);
RT_INTERFACE!{interface IContentDialogFactory(IContentDialogFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ContentDialog) -> HRESULT
}}
impl IContentDialogFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ContentDialog>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentDialogOpenedEventArgs, 157725461, 24409, 18841, 158, 62, 55, 76, 15, 23, 75, 4);
RT_INTERFACE!{interface IContentDialogOpenedEventArgs(IContentDialogOpenedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogOpenedEventArgs] {
    
}}
RT_CLASS!{class ContentDialogOpenedEventArgs: IContentDialogOpenedEventArgs}
RT_ENUM! { enum ContentDialogPlacement: i32 {
    Popup (ContentDialogPlacement_Popup) = 0, InPlace (ContentDialogPlacement_InPlace) = 1,
}}
RT_ENUM! { enum ContentDialogResult: i32 {
    None (ContentDialogResult_None) = 0, Primary (ContentDialogResult_Primary) = 1, Secondary (ContentDialogResult_Secondary) = 2,
}}
DEFINE_IID!(IID_IContentDialogStatics, 598427558, 20618, 20275, 183, 134, 242, 250, 150, 216, 105, 175);
RT_INTERFACE!{static interface IContentDialogStatics(IContentDialogStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogStatics] {
    fn get_TitleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TitleTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FullSizeDesiredProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PrimaryButtonTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SecondaryButtonTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PrimaryButtonCommandProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SecondaryButtonCommandProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PrimaryButtonCommandParameterProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SecondaryButtonCommandParameterProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsPrimaryButtonEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsSecondaryButtonEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentDialogStatics {
    #[inline] pub unsafe fn get_title_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_title_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TitleTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_full_size_desired_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FullSizeDesiredProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_command_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonCommandProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_command_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonCommandProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_command_parameter_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonCommandParameterProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_command_parameter_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonCommandParameterProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_primary_button_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsPrimaryButtonEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_secondary_button_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsSecondaryButtonEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentDialogStatics2, 848831922, 36784, 16677, 187, 7, 231, 154, 90, 3, 129, 159);
RT_INTERFACE!{static interface IContentDialogStatics2(IContentDialogStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IContentDialogStatics2] {
    fn get_CloseButtonTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CloseButtonCommandProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CloseButtonCommandParameterProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PrimaryButtonStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SecondaryButtonStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CloseButtonStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DefaultButtonProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentDialogStatics2 {
    #[inline] pub unsafe fn get_close_button_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_close_button_command_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonCommandProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_close_button_command_parameter_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonCommandParameterProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_primary_button_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryButtonStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_button_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryButtonStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_close_button_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CloseButtonStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_button_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultButtonProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenter, 2046682548, 52535, 18716, 136, 69, 218, 244, 114, 222, 255, 246);
RT_INTERFACE!{interface IContentPresenter(IContentPresenterVtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenter] {
    fn get_Content(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Content(&self, value: *mut IInspectable) -> HRESULT,
    fn get_ContentTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_ContentTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_ContentTemplateSelector(&self, out: *mut *mut DataTemplateSelector) -> HRESULT,
    fn put_ContentTemplateSelector(&self, value: *mut DataTemplateSelector) -> HRESULT,
    fn get_ContentTransitions(&self, out: *mut *mut super::media::animation::TransitionCollection) -> HRESULT,
    fn put_ContentTransitions(&self, value: *mut super::media::animation::TransitionCollection) -> HRESULT,
    fn get_FontSize(&self, out: *mut f64) -> HRESULT,
    fn put_FontSize(&self, value: f64) -> HRESULT,
    fn get_FontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_FontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy12(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy13(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy14(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy15(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy16(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontStretch(&self, out: *mut super::super::text::FontStretch) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy17(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontStretch(&self, value: super::super::text::FontStretch) -> HRESULT,
    fn get_CharacterSpacing(&self, out: *mut i32) -> HRESULT,
    fn put_CharacterSpacing(&self, value: i32) -> HRESULT,
    fn get_Foreground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Foreground(&self, value: *mut super::media::Brush) -> HRESULT
}}
impl IContentPresenter {
    #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Content)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_selector(&self) -> Result<ComPtr<DataTemplateSelector>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_template_selector(&self, value: &DataTemplateSelector) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTemplateSelector)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_transitions(&self) -> Result<ComPtr<super::media::animation::TransitionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTransitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_transitions(&self, value: &super::media::animation::TransitionCollection) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTransitions)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_stretch(&self) -> Result<super::super::text::FontStretch> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStretch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_stretch(&self, value: super::super::text::FontStretch) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStretch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_spacing(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacterSpacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_character_spacing(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CharacterSpacing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Foreground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Foreground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ContentPresenter: IContentPresenter}
impl RtActivatable<IContentPresenterStatics> for ContentPresenter {}
impl RtActivatable<IContentPresenterStatics2> for ContentPresenter {}
impl RtActivatable<IContentPresenterStatics3> for ContentPresenter {}
impl RtActivatable<IContentPresenterStatics4> for ContentPresenter {}
impl ContentPresenter {
    #[inline] pub fn get_content_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_content_property()
    }}
    #[inline] pub fn get_content_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_content_template_property()
    }}
    #[inline] pub fn get_content_template_selector_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_content_template_selector_property()
    }}
    #[inline] pub fn get_content_transitions_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_content_transitions_property()
    }}
    #[inline] pub fn get_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_font_size_property()
    }}
    #[inline] pub fn get_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_font_family_property()
    }}
    #[inline] pub fn get_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_font_weight_property()
    }}
    #[inline] pub fn get_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_font_style_property()
    }}
    #[inline] pub fn get_font_stretch_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_font_stretch_property()
    }}
    #[inline] pub fn get_character_spacing_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_character_spacing_property()
    }}
    #[inline] pub fn get_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics>>::get_activation_factory().get_foreground_property()
    }}
    #[inline] pub fn get_optical_margin_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics2>>::get_activation_factory().get_optical_margin_alignment_property()
    }}
    #[inline] pub fn get_text_line_bounds_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics2>>::get_activation_factory().get_text_line_bounds_property()
    }}
    #[inline] pub fn get_is_text_scale_factor_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics3>>::get_activation_factory().get_is_text_scale_factor_enabled_property()
    }}
    #[inline] pub fn get_text_wrapping_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_text_wrapping_property()
    }}
    #[inline] pub fn get_max_lines_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_max_lines_property()
    }}
    #[inline] pub fn get_line_stacking_strategy_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_line_stacking_strategy_property()
    }}
    #[inline] pub fn get_line_height_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_line_height_property()
    }}
    #[inline] pub fn get_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_border_brush_property()
    }}
    #[inline] pub fn get_border_thickness_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_border_thickness_property()
    }}
    #[inline] pub fn get_corner_radius_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_corner_radius_property()
    }}
    #[inline] pub fn get_padding_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_padding_property()
    }}
    #[inline] pub fn get_background_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_background_property()
    }}
    #[inline] pub fn get_horizontal_content_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_horizontal_content_alignment_property()
    }}
    #[inline] pub fn get_vertical_content_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IContentPresenterStatics4>>::get_activation_factory().get_vertical_content_alignment_property()
    }}
}
DEFINE_CLSID!(ContentPresenter(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,110,116,101,110,116,80,114,101,115,101,110,116,101,114,0]) [CLSID_ContentPresenter]);
DEFINE_IID!(IID_IContentPresenter2, 1362684248, 13149, 16912, 139, 187, 10, 162, 180, 181, 194, 158);
RT_INTERFACE!{interface IContentPresenter2(IContentPresenter2Vtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenter2] {
    fn get_OpticalMarginAlignment(&self, out: *mut super::OpticalMarginAlignment) -> HRESULT,
    fn put_OpticalMarginAlignment(&self, value: super::OpticalMarginAlignment) -> HRESULT,
    fn get_TextLineBounds(&self, out: *mut super::TextLineBounds) -> HRESULT,
    fn put_TextLineBounds(&self, value: super::TextLineBounds) -> HRESULT
}}
impl IContentPresenter2 {
    #[inline] pub unsafe fn get_optical_margin_alignment(&self) -> Result<super::OpticalMarginAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OpticalMarginAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_optical_margin_alignment(&self, value: super::OpticalMarginAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_OpticalMarginAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_line_bounds(&self) -> Result<super::TextLineBounds> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TextLineBounds)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_line_bounds(&self, value: super::TextLineBounds) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextLineBounds)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenter3, 2956494698, 40013, 17410, 172, 86, 162, 35, 72, 125, 198, 200);
RT_INTERFACE!{interface IContentPresenter3(IContentPresenter3Vtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenter3] {
    fn get_IsTextScaleFactorEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTextScaleFactorEnabled(&self, value: bool) -> HRESULT
}}
impl IContentPresenter3 {
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_text_scale_factor_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTextScaleFactorEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenter4, 2574981911, 15352, 17195, 143, 217, 104, 199, 186, 178, 31, 157);
RT_INTERFACE!{interface IContentPresenter4(IContentPresenter4Vtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenter4] {
    fn get_TextWrapping(&self, out: *mut super::TextWrapping) -> HRESULT,
    fn put_TextWrapping(&self, value: super::TextWrapping) -> HRESULT,
    fn get_MaxLines(&self, out: *mut i32) -> HRESULT,
    fn put_MaxLines(&self, value: i32) -> HRESULT,
    fn get_LineStackingStrategy(&self, out: *mut super::LineStackingStrategy) -> HRESULT,
    fn put_LineStackingStrategy(&self, value: super::LineStackingStrategy) -> HRESULT,
    fn get_LineHeight(&self, out: *mut f64) -> HRESULT,
    fn put_LineHeight(&self, value: f64) -> HRESULT,
    fn get_BorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_BorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_BorderThickness(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_BorderThickness(&self, value: super::Thickness) -> HRESULT,
    fn get_CornerRadius(&self, out: *mut super::CornerRadius) -> HRESULT,
    fn put_CornerRadius(&self, value: super::CornerRadius) -> HRESULT,
    fn get_Padding(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_Padding(&self, value: super::Thickness) -> HRESULT,
    fn get_Background(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Background(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_HorizontalContentAlignment(&self, out: *mut super::HorizontalAlignment) -> HRESULT,
    fn put_HorizontalContentAlignment(&self, value: super::HorizontalAlignment) -> HRESULT,
    fn get_VerticalContentAlignment(&self, out: *mut super::VerticalAlignment) -> HRESULT,
    fn put_VerticalContentAlignment(&self, value: super::VerticalAlignment) -> HRESULT
}}
impl IContentPresenter4 {
    #[inline] pub unsafe fn get_text_wrapping(&self) -> Result<super::TextWrapping> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TextWrapping)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_text_wrapping(&self, value: super::TextWrapping) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TextWrapping)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_lines(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxLines)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_lines(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxLines)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_stacking_strategy(&self) -> Result<super::LineStackingStrategy> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineStackingStrategy)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_line_stacking_strategy(&self, value: super::LineStackingStrategy) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LineStackingStrategy)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_height(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LineHeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_line_height(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LineHeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BorderThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_thickness(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_corner_radius(&self) -> Result<super::CornerRadius> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CornerRadius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_corner_radius(&self, value: super::CornerRadius) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CornerRadius)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Padding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_padding(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Padding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Background)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Background)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_content_alignment(&self) -> Result<super::HorizontalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HorizontalContentAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_horizontal_content_alignment(&self, value: super::HorizontalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HorizontalContentAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_content_alignment(&self) -> Result<super::VerticalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VerticalContentAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_vertical_content_alignment(&self, value: super::VerticalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VerticalContentAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenterFactory, 859428087, 18453, 17604, 159, 118, 104, 200, 56, 128, 239, 16);
RT_INTERFACE!{interface IContentPresenterFactory(IContentPresenterFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenterFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut ContentPresenter) -> HRESULT
}}
impl IContentPresenterFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<ContentPresenter>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenterOverrides, 2808297965, 13055, 17291, 170, 213, 29, 104, 250, 233, 52, 38);
RT_INTERFACE!{interface IContentPresenterOverrides(IContentPresenterOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenterOverrides] {
    fn OnContentTemplateChanged(&self, oldContentTemplate: *mut super::DataTemplate, newContentTemplate: *mut super::DataTemplate) -> HRESULT,
    fn OnContentTemplateSelectorChanged(&self, oldContentTemplateSelector: *mut DataTemplateSelector, newContentTemplateSelector: *mut DataTemplateSelector) -> HRESULT
}}
impl IContentPresenterOverrides {
    #[inline] pub unsafe fn on_content_template_changed(&self, oldContentTemplate: &super::DataTemplate, newContentTemplate: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).OnContentTemplateChanged)(self as *const _ as *mut _, oldContentTemplate as *const _ as *mut _, newContentTemplate as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_content_template_selector_changed(&self, oldContentTemplateSelector: &DataTemplateSelector, newContentTemplateSelector: &DataTemplateSelector) -> Result<()> {
        let hr = ((*self.lpVtbl).OnContentTemplateSelectorChanged)(self as *const _ as *mut _, oldContentTemplateSelector as *const _ as *mut _, newContentTemplateSelector as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenterStatics, 415402299, 55854, 17446, 184, 90, 44, 126, 33, 113, 190, 223);
RT_INTERFACE!{static interface IContentPresenterStatics(IContentPresenterStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenterStatics] {
    fn get_ContentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTemplateSelectorProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTransitionsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontStretchProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CharacterSpacingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentPresenterStatics {
    #[inline] pub unsafe fn get_content_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_selector_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateSelectorProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_transitions_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTransitionsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_stretch_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontStretchProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_spacing_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CharacterSpacingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenterStatics2, 3352862169, 1766, 18110, 168, 160, 156, 17, 125, 48, 36, 163);
RT_INTERFACE!{static interface IContentPresenterStatics2(IContentPresenterStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenterStatics2] {
    fn get_OpticalMarginAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TextLineBoundsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentPresenterStatics2 {
    #[inline] pub unsafe fn get_optical_margin_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OpticalMarginAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_text_line_bounds_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextLineBoundsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenterStatics3, 3420901211, 14513, 19805, 176, 152, 188, 148, 179, 92, 141, 223);
RT_INTERFACE!{static interface IContentPresenterStatics3(IContentPresenterStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenterStatics3] {
    fn get_IsTextScaleFactorEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentPresenterStatics3 {
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContentPresenterStatics4, 4287357586, 44840, 18411, 165, 195, 220, 68, 206, 212, 15, 210);
RT_INTERFACE!{static interface IContentPresenterStatics4(IContentPresenterStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IContentPresenterStatics4] {
    fn get_TextWrappingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxLinesProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_LineStackingStrategyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_LineHeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BorderThicknessProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CornerRadiusProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PaddingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BackgroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HorizontalContentAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_VerticalContentAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IContentPresenterStatics4 {
    #[inline] pub unsafe fn get_text_wrapping_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TextWrappingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_lines_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxLinesProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_stacking_strategy_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LineStackingStrategyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_line_height_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LineHeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_corner_radius_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CornerRadiusProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PaddingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackgroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_content_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HorizontalContentAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_content_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VerticalContentAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IContextMenuEventArgs, 528347747, 49483, 17704, 182, 240, 99, 121, 153, 216, 60, 198);
RT_INTERFACE!{interface IContextMenuEventArgs(IContextMenuEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IContextMenuEventArgs] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT,
    fn get_CursorLeft(&self, out: *mut f64) -> HRESULT,
    fn get_CursorTop(&self, out: *mut f64) -> HRESULT
}}
impl IContextMenuEventArgs {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cursor_left(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CursorLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_cursor_top(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CursorTop)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class ContextMenuEventArgs: IContextMenuEventArgs}
DEFINE_IID!(IID_ContextMenuOpeningEventHandler, 3751039313, 29788, 17478, 178, 252, 33, 109, 118, 88, 71, 160);
RT_DELEGATE!{delegate ContextMenuOpeningEventHandler(ContextMenuOpeningEventHandlerVtbl, ContextMenuOpeningEventHandlerImpl) [IID_ContextMenuOpeningEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut ContextMenuEventArgs) -> HRESULT
}}
impl ContextMenuOpeningEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &ContextMenuEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControl, 2828083811, 10577, 20312, 169, 197, 90, 19, 78, 170, 127, 7);
RT_INTERFACE!{interface IControl(IControlVtbl): IInspectable(IInspectableVtbl) [IID_IControl] {
    fn get_FontSize(&self, out: *mut f64) -> HRESULT,
    fn put_FontSize(&self, value: f64) -> HRESULT,
    fn get_FontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_FontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy4(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontStretch(&self, out: *mut super::super::text::FontStretch) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontStretch(&self, value: super::super::text::FontStretch) -> HRESULT,
    fn get_CharacterSpacing(&self, out: *mut i32) -> HRESULT,
    fn put_CharacterSpacing(&self, value: i32) -> HRESULT,
    fn get_Foreground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Foreground(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_IsTabStop(&self, out: *mut bool) -> HRESULT,
    fn put_IsTabStop(&self, value: bool) -> HRESULT,
    fn get_IsEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsEnabled(&self, value: bool) -> HRESULT,
    fn get_TabIndex(&self, out: *mut i32) -> HRESULT,
    fn put_TabIndex(&self, value: i32) -> HRESULT,
    fn get_TabNavigation(&self, out: *mut super::input::KeyboardNavigationMode) -> HRESULT,
    fn put_TabNavigation(&self, value: super::input::KeyboardNavigationMode) -> HRESULT,
    fn get_Template(&self, out: *mut *mut ControlTemplate) -> HRESULT,
    fn put_Template(&self, value: *mut ControlTemplate) -> HRESULT,
    fn get_Padding(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_Padding(&self, value: super::Thickness) -> HRESULT,
    fn get_HorizontalContentAlignment(&self, out: *mut super::HorizontalAlignment) -> HRESULT,
    fn put_HorizontalContentAlignment(&self, value: super::HorizontalAlignment) -> HRESULT,
    fn get_VerticalContentAlignment(&self, out: *mut super::VerticalAlignment) -> HRESULT,
    fn put_VerticalContentAlignment(&self, value: super::VerticalAlignment) -> HRESULT,
    fn get_Background(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Background(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_BorderThickness(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_BorderThickness(&self, value: super::Thickness) -> HRESULT,
    fn get_BorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_BorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_FocusState(&self, out: *mut super::FocusState) -> HRESULT,
    fn add_IsEnabledChanged(&self, value: *mut super::DependencyPropertyChangedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_IsEnabledChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn ApplyTemplate(&self, out: *mut bool) -> HRESULT,
    fn Focus(&self, value: super::FocusState, out: *mut bool) -> HRESULT
}}
impl IControl {
    #[inline] pub unsafe fn get_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_stretch(&self) -> Result<super::super::text::FontStretch> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStretch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_stretch(&self, value: super::super::text::FontStretch) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStretch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_spacing(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CharacterSpacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_character_spacing(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CharacterSpacing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Foreground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Foreground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_tab_stop(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTabStop)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_tab_stop(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTabStop)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TabIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tab_index(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TabIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_navigation(&self) -> Result<super::input::KeyboardNavigationMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TabNavigation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_tab_navigation(&self, value: super::input::KeyboardNavigationMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TabNavigation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template(&self) -> Result<ComPtr<ControlTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Template)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_template(&self, value: &ControlTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Template)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Padding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_padding(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Padding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_content_alignment(&self) -> Result<super::HorizontalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HorizontalContentAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_horizontal_content_alignment(&self, value: super::HorizontalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HorizontalContentAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_content_alignment(&self) -> Result<super::VerticalAlignment> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_VerticalContentAlignment)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_vertical_content_alignment(&self, value: super::VerticalAlignment) -> Result<()> {
        let hr = ((*self.lpVtbl).put_VerticalContentAlignment)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Background)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_background(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Background)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BorderThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_thickness(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_state(&self) -> Result<super::FocusState> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FocusState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_is_enabled_changed(&self, value: &super::DependencyPropertyChangedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_IsEnabledChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_is_enabled_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_IsEnabledChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn apply_template(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).ApplyTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn focus(&self, value: super::FocusState) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Focus)(self as *const _ as *mut _, value, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class Control: IControl}
impl RtActivatable<IControlStatics> for Control {}
impl RtActivatable<IControlStatics2> for Control {}
impl RtActivatable<IControlStatics3> for Control {}
impl RtActivatable<IControlStatics4> for Control {}
impl RtActivatable<IControlStatics5> for Control {}
impl Control {
    #[inline] pub fn get_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_font_size_property()
    }}
    #[inline] pub fn get_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_font_family_property()
    }}
    #[inline] pub fn get_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_font_weight_property()
    }}
    #[inline] pub fn get_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_font_style_property()
    }}
    #[inline] pub fn get_font_stretch_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_font_stretch_property()
    }}
    #[inline] pub fn get_character_spacing_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_character_spacing_property()
    }}
    #[inline] pub fn get_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_foreground_property()
    }}
    #[inline] pub fn get_is_tab_stop_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_is_tab_stop_property()
    }}
    #[inline] pub fn get_is_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_is_enabled_property()
    }}
    #[inline] pub fn get_tab_index_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_tab_index_property()
    }}
    #[inline] pub fn get_tab_navigation_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_tab_navigation_property()
    }}
    #[inline] pub fn get_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_template_property()
    }}
    #[inline] pub fn get_padding_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_padding_property()
    }}
    #[inline] pub fn get_horizontal_content_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_horizontal_content_alignment_property()
    }}
    #[inline] pub fn get_vertical_content_alignment_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_vertical_content_alignment_property()
    }}
    #[inline] pub fn get_background_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_background_property()
    }}
    #[inline] pub fn get_border_thickness_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_border_thickness_property()
    }}
    #[inline] pub fn get_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_border_brush_property()
    }}
    #[inline] pub fn get_default_style_key_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_default_style_key_property()
    }}
    #[inline] pub fn get_focus_state_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics>>::get_activation_factory().get_focus_state_property()
    }}
    #[inline] pub fn get_is_text_scale_factor_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics2>>::get_activation_factory().get_is_text_scale_factor_enabled_property()
    }}
    #[inline] pub fn get_use_system_focus_visuals_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics3>>::get_activation_factory().get_use_system_focus_visuals_property()
    }}
    #[inline] pub fn get_is_template_focus_target_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics3>>::get_activation_factory().get_is_template_focus_target_property()
    }}
    #[inline] pub fn get_is_template_focus_target(element: &super::FrameworkElement) -> Result<bool> { unsafe {
        <Self as RtActivatable<IControlStatics3>>::get_activation_factory().get_is_template_focus_target(element)
    }}
    #[inline] pub fn set_is_template_focus_target(element: &super::FrameworkElement, value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IControlStatics3>>::get_activation_factory().set_is_template_focus_target(element, value)
    }}
    #[inline] pub fn get_is_focus_engagement_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_is_focus_engagement_enabled_property()
    }}
    #[inline] pub fn get_is_focus_engaged_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_is_focus_engaged_property()
    }}
    #[inline] pub fn get_requires_pointer_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_requires_pointer_property()
    }}
    #[inline] pub fn get_xyfocus_left_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_xyfocus_left_property()
    }}
    #[inline] pub fn get_xyfocus_right_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_xyfocus_right_property()
    }}
    #[inline] pub fn get_xyfocus_up_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_xyfocus_up_property()
    }}
    #[inline] pub fn get_xyfocus_down_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_xyfocus_down_property()
    }}
    #[inline] pub fn get_element_sound_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics4>>::get_activation_factory().get_element_sound_mode_property()
    }}
    #[inline] pub fn get_default_style_resource_uri_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics5>>::get_activation_factory().get_default_style_resource_uri_property()
    }}
    #[inline] pub fn get_is_template_key_tip_target_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IControlStatics5>>::get_activation_factory().get_is_template_key_tip_target_property()
    }}
    #[inline] pub fn get_is_template_key_tip_target(element: &super::DependencyObject) -> Result<bool> { unsafe {
        <Self as RtActivatable<IControlStatics5>>::get_activation_factory().get_is_template_key_tip_target(element)
    }}
    #[inline] pub fn set_is_template_key_tip_target(element: &super::DependencyObject, value: bool) -> Result<()> { unsafe {
        <Self as RtActivatable<IControlStatics5>>::get_activation_factory().set_is_template_key_tip_target(element, value)
    }}
}
DEFINE_CLSID!(Control(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,110,116,114,111,108,0]) [CLSID_Control]);
DEFINE_IID!(IID_IControl2, 1138818576, 5356, 17022, 140, 87, 222, 230, 13, 246, 10, 168);
RT_INTERFACE!{interface IControl2(IControl2Vtbl): IInspectable(IInspectableVtbl) [IID_IControl2] {
    fn get_IsTextScaleFactorEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTextScaleFactorEnabled(&self, value: bool) -> HRESULT
}}
impl IControl2 {
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_text_scale_factor_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTextScaleFactorEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControl3, 125512164, 56030, 20309, 155, 150, 9, 226, 27, 40, 235, 28);
RT_INTERFACE!{interface IControl3(IControl3Vtbl): IInspectable(IInspectableVtbl) [IID_IControl3] {
    fn get_UseSystemFocusVisuals(&self, out: *mut bool) -> HRESULT,
    fn put_UseSystemFocusVisuals(&self, value: bool) -> HRESULT
}}
impl IControl3 {
    #[inline] pub unsafe fn get_use_system_focus_visuals(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UseSystemFocusVisuals)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_use_system_focus_visuals(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UseSystemFocusVisuals)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControl4, 236498670, 24366, 17642, 133, 19, 211, 135, 92, 10, 117, 19);
RT_INTERFACE!{interface IControl4(IControl4Vtbl): IInspectable(IInspectableVtbl) [IID_IControl4] {
    fn get_IsFocusEngagementEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsFocusEngagementEnabled(&self, value: bool) -> HRESULT,
    fn get_IsFocusEngaged(&self, out: *mut bool) -> HRESULT,
    fn put_IsFocusEngaged(&self, value: bool) -> HRESULT,
    fn get_RequiresPointer(&self, out: *mut RequiresPointer) -> HRESULT,
    fn put_RequiresPointer(&self, value: RequiresPointer) -> HRESULT,
    fn get_XYFocusLeft(&self, out: *mut *mut super::DependencyObject) -> HRESULT,
    fn put_XYFocusLeft(&self, value: *mut super::DependencyObject) -> HRESULT,
    fn get_XYFocusRight(&self, out: *mut *mut super::DependencyObject) -> HRESULT,
    fn put_XYFocusRight(&self, value: *mut super::DependencyObject) -> HRESULT,
    fn get_XYFocusUp(&self, out: *mut *mut super::DependencyObject) -> HRESULT,
    fn put_XYFocusUp(&self, value: *mut super::DependencyObject) -> HRESULT,
    fn get_XYFocusDown(&self, out: *mut *mut super::DependencyObject) -> HRESULT,
    fn put_XYFocusDown(&self, value: *mut super::DependencyObject) -> HRESULT,
    fn get_ElementSoundMode(&self, out: *mut super::ElementSoundMode) -> HRESULT,
    fn put_ElementSoundMode(&self, value: super::ElementSoundMode) -> HRESULT,
    fn add_FocusEngaged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<Control, FocusEngagedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FocusEngaged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_FocusDisengaged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<Control, FocusDisengagedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_FocusDisengaged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn RemoveFocusEngagement(&self) -> HRESULT
}}
impl IControl4 {
    #[inline] pub unsafe fn get_is_focus_engagement_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFocusEngagementEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_focus_engagement_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsFocusEngagementEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_focus_engaged(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsFocusEngaged)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_focus_engaged(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsFocusEngaged)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_requires_pointer(&self) -> Result<RequiresPointer> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RequiresPointer)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_requires_pointer(&self, value: RequiresPointer) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RequiresPointer)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_left(&self) -> Result<ComPtr<super::DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_left(&self, value: &super::DependencyObject) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusLeft)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_right(&self) -> Result<ComPtr<super::DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusRight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_right(&self, value: &super::DependencyObject) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusRight)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_up(&self) -> Result<ComPtr<super::DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusUp)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_up(&self, value: &super::DependencyObject) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusUp)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_down(&self) -> Result<ComPtr<super::DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusDown)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_xyfocus_down(&self, value: &super::DependencyObject) -> Result<()> {
        let hr = ((*self.lpVtbl).put_XYFocusDown)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_element_sound_mode(&self) -> Result<super::ElementSoundMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ElementSoundMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_element_sound_mode(&self, value: super::ElementSoundMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ElementSoundMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_focus_engaged(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<Control, FocusEngagedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FocusEngaged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_focus_engaged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FocusEngaged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_focus_disengaged(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<Control, FocusDisengagedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_FocusDisengaged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_focus_disengaged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_FocusDisengaged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_focus_engagement(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).RemoveFocusEngagement)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControl5, 1589334485, 40536, 18871, 188, 45, 1, 85, 255, 17, 134, 100);
RT_INTERFACE!{interface IControl5(IControl5Vtbl): IInspectable(IInspectableVtbl) [IID_IControl5] {
    fn get_DefaultStyleResourceUri(&self, out: *mut *mut ::rt::gen::windows::foundation::Uri) -> HRESULT,
    fn put_DefaultStyleResourceUri(&self, value: *mut ::rt::gen::windows::foundation::Uri) -> HRESULT
}}
impl IControl5 {
    #[inline] pub unsafe fn get_default_style_resource_uri(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultStyleResourceUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_style_resource_uri(&self, value: &::rt::gen::windows::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultStyleResourceUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlFactory, 2972392794, 25625, 19990, 178, 18, 164, 83, 54, 183, 87, 120);
RT_INTERFACE!{interface IControlFactory(IControlFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IControlFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Control) -> HRESULT
}}
impl IControlFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Control>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlOverrides, 2694222303, 38948, 16894, 181, 48, 176, 216, 153, 14, 100, 193);
RT_INTERFACE!{interface IControlOverrides(IControlOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IControlOverrides] {
    fn OnPointerEntered(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerPressed(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerMoved(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerReleased(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerExited(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerCaptureLost(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerCanceled(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnPointerWheelChanged(&self, e: *mut super::input::PointerRoutedEventArgs) -> HRESULT,
    fn OnTapped(&self, e: *mut super::input::TappedRoutedEventArgs) -> HRESULT,
    fn OnDoubleTapped(&self, e: *mut super::input::DoubleTappedRoutedEventArgs) -> HRESULT,
    fn OnHolding(&self, e: *mut super::input::HoldingRoutedEventArgs) -> HRESULT,
    fn OnRightTapped(&self, e: *mut super::input::RightTappedRoutedEventArgs) -> HRESULT,
    fn OnManipulationStarting(&self, e: *mut super::input::ManipulationStartingRoutedEventArgs) -> HRESULT,
    fn OnManipulationInertiaStarting(&self, e: *mut super::input::ManipulationInertiaStartingRoutedEventArgs) -> HRESULT,
    fn OnManipulationStarted(&self, e: *mut super::input::ManipulationStartedRoutedEventArgs) -> HRESULT,
    fn OnManipulationDelta(&self, e: *mut super::input::ManipulationDeltaRoutedEventArgs) -> HRESULT,
    fn OnManipulationCompleted(&self, e: *mut super::input::ManipulationCompletedRoutedEventArgs) -> HRESULT,
    fn OnKeyUp(&self, e: *mut super::input::KeyRoutedEventArgs) -> HRESULT,
    fn OnKeyDown(&self, e: *mut super::input::KeyRoutedEventArgs) -> HRESULT,
    fn OnGotFocus(&self, e: *mut super::RoutedEventArgs) -> HRESULT,
    fn OnLostFocus(&self, e: *mut super::RoutedEventArgs) -> HRESULT,
    fn OnDragEnter(&self, e: *mut super::DragEventArgs) -> HRESULT,
    fn OnDragLeave(&self, e: *mut super::DragEventArgs) -> HRESULT,
    fn OnDragOver(&self, e: *mut super::DragEventArgs) -> HRESULT,
    fn OnDrop(&self, e: *mut super::DragEventArgs) -> HRESULT
}}
impl IControlOverrides {
    #[inline] pub unsafe fn on_pointer_entered(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerEntered)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_pressed(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerPressed)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_moved(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerMoved)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_released(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerReleased)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_exited(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerExited)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_capture_lost(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerCaptureLost)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_canceled(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerCanceled)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_pointer_wheel_changed(&self, e: &super::input::PointerRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPointerWheelChanged)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_tapped(&self, e: &super::input::TappedRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnTapped)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_double_tapped(&self, e: &super::input::DoubleTappedRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDoubleTapped)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_holding(&self, e: &super::input::HoldingRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnHolding)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_right_tapped(&self, e: &super::input::RightTappedRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnRightTapped)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_manipulation_starting(&self, e: &super::input::ManipulationStartingRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnManipulationStarting)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_manipulation_inertia_starting(&self, e: &super::input::ManipulationInertiaStartingRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnManipulationInertiaStarting)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_manipulation_started(&self, e: &super::input::ManipulationStartedRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnManipulationStarted)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_manipulation_delta(&self, e: &super::input::ManipulationDeltaRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnManipulationDelta)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_manipulation_completed(&self, e: &super::input::ManipulationCompletedRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnManipulationCompleted)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_key_up(&self, e: &super::input::KeyRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnKeyUp)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_key_down(&self, e: &super::input::KeyRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnKeyDown)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_got_focus(&self, e: &super::RoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnGotFocus)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_lost_focus(&self, e: &super::RoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnLostFocus)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_drag_enter(&self, e: &super::DragEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDragEnter)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_drag_leave(&self, e: &super::DragEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDragLeave)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_drag_over(&self, e: &super::DragEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDragOver)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_drop(&self, e: &super::DragEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnDrop)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlOverrides6, 3784624490, 55500, 17209, 160, 225, 46, 156, 66, 8, 121, 236);
RT_INTERFACE!{interface IControlOverrides6(IControlOverrides6Vtbl): IInspectable(IInspectableVtbl) [IID_IControlOverrides6] {
    fn OnPreviewKeyDown(&self, e: *mut super::input::KeyRoutedEventArgs) -> HRESULT,
    fn OnPreviewKeyUp(&self, e: *mut super::input::KeyRoutedEventArgs) -> HRESULT,
    fn OnCharacterReceived(&self, e: *mut super::input::CharacterReceivedRoutedEventArgs) -> HRESULT
}}
impl IControlOverrides6 {
    #[inline] pub unsafe fn on_preview_key_down(&self, e: &super::input::KeyRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPreviewKeyDown)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_preview_key_up(&self, e: &super::input::KeyRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnPreviewKeyUp)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn on_character_received(&self, e: &super::input::CharacterReceivedRoutedEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).OnCharacterReceived)(self as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlProtected, 395401338, 10876, 18817, 162, 216, 171, 153, 255, 252, 101, 185);
RT_INTERFACE!{interface IControlProtected(IControlProtectedVtbl): IInspectable(IInspectableVtbl) [IID_IControlProtected] {
    fn get_DefaultStyleKey(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_DefaultStyleKey(&self, value: *mut IInspectable) -> HRESULT,
    fn GetTemplateChild(&self, childName: HSTRING, out: *mut *mut super::DependencyObject) -> HRESULT
}}
impl IControlProtected {
    #[inline] pub unsafe fn get_default_style_key(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultStyleKey)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_style_key(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultStyleKey)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template_child(&self, childName: &HStringArg) -> Result<ComPtr<super::DependencyObject>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetTemplateChild)(self as *const _ as *mut _, childName.get(), &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlStatics, 1195061339, 34685, 19509, 143, 202, 70, 160, 95, 150, 96, 122);
RT_INTERFACE!{static interface IControlStatics(IControlStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IControlStatics] {
    fn get_FontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontStretchProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CharacterSpacingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTabStopProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TabIndexProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TabNavigationProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_TemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PaddingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HorizontalContentAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_VerticalContentAlignmentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BackgroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BorderThicknessProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DefaultStyleKeyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FocusStateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IControlStatics {
    #[inline] pub unsafe fn get_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_stretch_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontStretchProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_character_spacing_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CharacterSpacingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_tab_stop_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTabStopProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_index_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TabIndexProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_tab_navigation_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TabNavigationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PaddingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_horizontal_content_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HorizontalContentAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_vertical_content_alignment_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_VerticalContentAlignmentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_background_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackgroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_style_key_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultStyleKeyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_focus_state_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FocusStateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlStatics2, 841170486, 43892, 18981, 165, 86, 69, 41, 49, 53, 178, 197);
RT_INTERFACE!{static interface IControlStatics2(IControlStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IControlStatics2] {
    fn get_IsTextScaleFactorEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IControlStatics2 {
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlStatics3, 2865847905, 58553, 19826, 182, 83, 147, 65, 73, 170, 80, 3);
RT_INTERFACE!{static interface IControlStatics3(IControlStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IControlStatics3] {
    fn get_UseSystemFocusVisualsProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTemplateFocusTargetProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetIsTemplateFocusTarget(&self, element: *mut super::FrameworkElement, out: *mut bool) -> HRESULT,
    fn SetIsTemplateFocusTarget(&self, element: *mut super::FrameworkElement, value: bool) -> HRESULT
}}
impl IControlStatics3 {
    #[inline] pub unsafe fn get_use_system_focus_visuals_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UseSystemFocusVisualsProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_template_focus_target_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTemplateFocusTargetProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_template_focus_target(&self, element: &super::FrameworkElement) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsTemplateFocusTarget)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_template_focus_target(&self, element: &super::FrameworkElement, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetIsTemplateFocusTarget)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlStatics4, 1509795624, 49242, 20162, 138, 75, 6, 173, 105, 182, 110, 21);
RT_INTERFACE!{static interface IControlStatics4(IControlStatics4Vtbl): IInspectable(IInspectableVtbl) [IID_IControlStatics4] {
    fn get_IsFocusEngagementEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsFocusEngagedProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_RequiresPointerProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_XYFocusLeftProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_XYFocusRightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_XYFocusUpProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_XYFocusDownProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ElementSoundModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IControlStatics4 {
    #[inline] pub unsafe fn get_is_focus_engagement_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsFocusEngagementEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_focus_engaged_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsFocusEngagedProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_requires_pointer_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RequiresPointerProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_left_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusLeftProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_right_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusRightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_up_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusUpProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_xyfocus_down_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_XYFocusDownProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_element_sound_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ElementSoundModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlStatics5, 4130715043, 61326, 16463, 135, 123, 85, 128, 71, 55, 16, 166);
RT_INTERFACE!{static interface IControlStatics5(IControlStatics5Vtbl): IInspectable(IInspectableVtbl) [IID_IControlStatics5] {
    fn get_DefaultStyleResourceUriProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTemplateKeyTipTargetProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetIsTemplateKeyTipTarget(&self, element: *mut super::DependencyObject, out: *mut bool) -> HRESULT,
    fn SetIsTemplateKeyTipTarget(&self, element: *mut super::DependencyObject, value: bool) -> HRESULT
}}
impl IControlStatics5 {
    #[inline] pub unsafe fn get_default_style_resource_uri_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultStyleResourceUriProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_template_key_tip_target_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTemplateKeyTipTargetProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_template_key_tip_target(&self, element: &super::DependencyObject) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetIsTemplateKeyTipTarget)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_template_key_tip_target(&self, element: &super::DependencyObject, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetIsTemplateKeyTipTarget)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IControlTemplate, 4023533966, 16864, 18619, 139, 130, 145, 237, 161, 186, 63, 226);
RT_INTERFACE!{interface IControlTemplate(IControlTemplateVtbl): IInspectable(IInspectableVtbl) [IID_IControlTemplate] {
    fn get_TargetType(&self, out: *mut super::interop::TypeName) -> HRESULT,
    fn put_TargetType(&self, value: super::interop::TypeName) -> HRESULT
}}
impl IControlTemplate {
    #[inline] pub unsafe fn get_target_type(&self) -> Result<super::interop::TypeName> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_TargetType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_type(&self, value: super::interop::TypeName) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class ControlTemplate: IControlTemplate}
impl RtActivatable<IActivationFactory> for ControlTemplate {}
DEFINE_CLSID!(ControlTemplate(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,67,111,110,116,114,111,108,84,101,109,112,108,97,116,101,0]) [CLSID_ControlTemplate]);
DEFINE_IID!(IID_IDataTemplateSelector, 2835862678, 18080, 19671, 141, 190, 249, 165, 129, 223, 96, 177);
RT_INTERFACE!{interface IDataTemplateSelector(IDataTemplateSelectorVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateSelector] {
    fn SelectTemplate(&self, item: *mut IInspectable, container: *mut super::DependencyObject, out: *mut *mut super::DataTemplate) -> HRESULT
}}
impl IDataTemplateSelector {
    #[inline] pub unsafe fn select_template(&self, item: &IInspectable, container: &super::DependencyObject) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SelectTemplate)(self as *const _ as *mut _, item as *const _ as *mut _, container as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DataTemplateSelector: IDataTemplateSelector}
DEFINE_IID!(IID_IDataTemplateSelector2, 932363335, 35915, 16983, 165, 174, 204, 63, 142, 215, 134, 235);
RT_INTERFACE!{interface IDataTemplateSelector2(IDataTemplateSelector2Vtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateSelector2] {
    fn SelectTemplateForItem(&self, item: *mut IInspectable, out: *mut *mut super::DataTemplate) -> HRESULT
}}
impl IDataTemplateSelector2 {
    #[inline] pub unsafe fn select_template_for_item(&self, item: &IInspectable) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SelectTemplateForItem)(self as *const _ as *mut _, item as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataTemplateSelectorFactory, 1360767696, 8458, 17789, 149, 33, 67, 61, 43, 17, 183, 210);
RT_INTERFACE!{interface IDataTemplateSelectorFactory(IDataTemplateSelectorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateSelectorFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DataTemplateSelector) -> HRESULT
}}
impl IDataTemplateSelectorFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DataTemplateSelector>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataTemplateSelectorOverrides, 756427045, 22886, 19450, 134, 56, 77, 52, 86, 137, 246, 207);
RT_INTERFACE!{interface IDataTemplateSelectorOverrides(IDataTemplateSelectorOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateSelectorOverrides] {
    fn SelectTemplateCore(&self, item: *mut IInspectable, container: *mut super::DependencyObject, out: *mut *mut super::DataTemplate) -> HRESULT
}}
impl IDataTemplateSelectorOverrides {
    #[inline] pub unsafe fn select_template_core(&self, item: &IInspectable, container: &super::DependencyObject) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SelectTemplateCore)(self as *const _ as *mut _, item as *const _ as *mut _, container as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDataTemplateSelectorOverrides2, 1816114684, 36484, 19601, 172, 21, 4, 161, 216, 133, 80, 15);
RT_INTERFACE!{interface IDataTemplateSelectorOverrides2(IDataTemplateSelectorOverrides2Vtbl): IInspectable(IInspectableVtbl) [IID_IDataTemplateSelectorOverrides2] {
    fn SelectTemplateForItemCore(&self, item: *mut IInspectable, out: *mut *mut super::DataTemplate) -> HRESULT
}}
impl IDataTemplateSelectorOverrides2 {
    #[inline] pub unsafe fn select_template_for_item_core(&self, item: &IInspectable) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SelectTemplateForItemCore)(self as *const _ as *mut _, item as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickedEventArgs, 2706537234, 22977, 17697, 178, 140, 177, 118, 103, 94, 124, 90);
RT_INTERFACE!{interface IDatePickedEventArgs(IDatePickedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickedEventArgs] {
    fn get_OldDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_NewDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT
}}
impl IDatePickedEventArgs {
    #[inline] pub unsafe fn get_old_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OldDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DatePickedEventArgs: IDatePickedEventArgs}
impl RtActivatable<IActivationFactory> for DatePickedEventArgs {}
DEFINE_CLSID!(DatePickedEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,68,97,116,101,80,105,99,107,101,100,69,118,101,110,116,65,114,103,115,0]) [CLSID_DatePickedEventArgs]);
DEFINE_IID!(IID_IDatePicker, 114964806, 2232, 16643, 139, 138, 9, 62, 253, 106, 118, 87);
RT_INTERFACE!{interface IDatePicker(IDatePickerVtbl): IInspectable(IInspectableVtbl) [IID_IDatePicker] {
    fn get_Header(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Header(&self, value: *mut IInspectable) -> HRESULT,
    fn get_HeaderTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_HeaderTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_CalendarIdentifier(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CalendarIdentifier(&self, value: HSTRING) -> HRESULT,
    fn get_Date(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_Date(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_DayVisible(&self, out: *mut bool) -> HRESULT,
    fn put_DayVisible(&self, value: bool) -> HRESULT,
    fn get_MonthVisible(&self, out: *mut bool) -> HRESULT,
    fn put_MonthVisible(&self, value: bool) -> HRESULT,
    fn get_YearVisible(&self, out: *mut bool) -> HRESULT,
    fn put_YearVisible(&self, value: bool) -> HRESULT,
    fn get_DayFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DayFormat(&self, value: HSTRING) -> HRESULT,
    fn get_MonthFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_MonthFormat(&self, value: HSTRING) -> HRESULT,
    fn get_YearFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_YearFormat(&self, value: HSTRING) -> HRESULT,
    fn get_MinYear(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MinYear(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_MaxYear(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MaxYear(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_Orientation(&self, out: *mut Orientation) -> HRESULT,
    fn put_Orientation(&self, value: Orientation) -> HRESULT,
    fn add_DateChanged(&self, value: *mut ::rt::gen::windows::foundation::EventHandler<DatePickerValueChangedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DateChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IDatePicker {
    #[inline] pub unsafe fn get_header(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Header)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_identifier(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifier)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_identifier(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarIdentifier)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Date)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_date(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Date)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonthVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_YearVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_YearVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YearFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_YearFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_year(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinYear)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_year(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinYear)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_year(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxYear)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_year(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxYear)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation(&self) -> Result<Orientation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_orientation(&self, value: Orientation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Orientation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_date_changed(&self, value: &::rt::gen::windows::foundation::EventHandler<DatePickerValueChangedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DateChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_date_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DateChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DatePicker: IDatePicker}
impl RtActivatable<IDatePickerStatics> for DatePicker {}
impl RtActivatable<IDatePickerStatics2> for DatePicker {}
impl DatePicker {
    #[inline] pub fn get_header_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_header_property()
    }}
    #[inline] pub fn get_header_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_header_template_property()
    }}
    #[inline] pub fn get_calendar_identifier_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_calendar_identifier_property()
    }}
    #[inline] pub fn get_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_date_property()
    }}
    #[inline] pub fn get_day_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_day_visible_property()
    }}
    #[inline] pub fn get_month_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_month_visible_property()
    }}
    #[inline] pub fn get_year_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_year_visible_property()
    }}
    #[inline] pub fn get_day_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_day_format_property()
    }}
    #[inline] pub fn get_month_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_month_format_property()
    }}
    #[inline] pub fn get_year_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_year_format_property()
    }}
    #[inline] pub fn get_min_year_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_min_year_property()
    }}
    #[inline] pub fn get_max_year_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_max_year_property()
    }}
    #[inline] pub fn get_orientation_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics>>::get_activation_factory().get_orientation_property()
    }}
    #[inline] pub fn get_light_dismiss_overlay_mode_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerStatics2>>::get_activation_factory().get_light_dismiss_overlay_mode_property()
    }}
}
DEFINE_CLSID!(DatePicker(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,68,97,116,101,80,105,99,107,101,114,0]) [CLSID_DatePicker]);
DEFINE_IID!(IID_IDatePicker2, 3140007029, 11295, 17216, 158, 48, 148, 143, 153, 201, 229, 122);
RT_INTERFACE!{interface IDatePicker2(IDatePicker2Vtbl): IInspectable(IInspectableVtbl) [IID_IDatePicker2] {
    fn get_LightDismissOverlayMode(&self, out: *mut LightDismissOverlayMode) -> HRESULT,
    fn put_LightDismissOverlayMode(&self, value: LightDismissOverlayMode) -> HRESULT
}}
impl IDatePicker2 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode(&self) -> Result<LightDismissOverlayMode> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayMode)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_light_dismiss_overlay_mode(&self, value: LightDismissOverlayMode) -> Result<()> {
        let hr = ((*self.lpVtbl).put_LightDismissOverlayMode)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerFactory, 4005808772, 39062, 19069, 187, 53, 111, 178, 30, 174, 202, 17);
RT_INTERFACE!{interface IDatePickerFactory(IDatePickerFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut DatePicker) -> HRESULT
}}
impl IDatePickerFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<DatePicker>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerFlyout, 4227021594, 41892, 19960, 146, 40, 35, 165, 172, 39, 223, 78);
RT_INTERFACE!{interface IDatePickerFlyout(IDatePickerFlyoutVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyout] {
    fn get_CalendarIdentifier(&self, out: *mut HSTRING) -> HRESULT,
    fn put_CalendarIdentifier(&self, value: HSTRING) -> HRESULT,
    fn get_Date(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_Date(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_DayVisible(&self, out: *mut bool) -> HRESULT,
    fn put_DayVisible(&self, value: bool) -> HRESULT,
    fn get_MonthVisible(&self, out: *mut bool) -> HRESULT,
    fn put_MonthVisible(&self, value: bool) -> HRESULT,
    fn get_YearVisible(&self, out: *mut bool) -> HRESULT,
    fn put_YearVisible(&self, value: bool) -> HRESULT,
    fn get_MinYear(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MinYear(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_MaxYear(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn put_MaxYear(&self, value: ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn add_DatePicked(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<DatePickerFlyout, DatePickedEventArgs>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_DatePicked(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn ShowAtAsync(&self, target: *mut super::FrameworkElement, out: *mut *mut ::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>) -> HRESULT
}}
impl IDatePickerFlyout {
    #[inline] pub unsafe fn get_calendar_identifier(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifier)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_calendar_identifier(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CalendarIdentifier)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Date)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_date(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Date)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DayVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MonthVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_visible(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_YearVisible)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year_visible(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_YearVisible)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_year(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MinYear)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_min_year(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MinYear)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_year(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MaxYear)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_max_year(&self, value: ::rt::gen::windows::foundation::DateTime) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MaxYear)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_date_picked(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<DatePickerFlyout, DatePickedEventArgs>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_DatePicked)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_date_picked(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_DatePicked)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn show_at_async(&self, target: &super::FrameworkElement) -> Result<ComPtr<::rt::gen::windows::foundation::IAsyncOperation<::rt::gen::windows::foundation::IReference<::rt::gen::windows::foundation::DateTime>>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).ShowAtAsync)(self as *const _ as *mut _, target as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DatePickerFlyout: IDatePickerFlyout}
impl RtActivatable<IDatePickerFlyoutStatics> for DatePickerFlyout {}
impl RtActivatable<IDatePickerFlyoutStatics2> for DatePickerFlyout {}
impl RtActivatable<IActivationFactory> for DatePickerFlyout {}
impl DatePickerFlyout {
    #[inline] pub fn get_calendar_identifier_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_calendar_identifier_property()
    }}
    #[inline] pub fn get_date_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_date_property()
    }}
    #[inline] pub fn get_day_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_day_visible_property()
    }}
    #[inline] pub fn get_month_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_month_visible_property()
    }}
    #[inline] pub fn get_year_visible_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_year_visible_property()
    }}
    #[inline] pub fn get_min_year_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_min_year_property()
    }}
    #[inline] pub fn get_max_year_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics>>::get_activation_factory().get_max_year_property()
    }}
    #[inline] pub fn get_day_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics2>>::get_activation_factory().get_day_format_property()
    }}
    #[inline] pub fn get_month_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics2>>::get_activation_factory().get_month_format_property()
    }}
    #[inline] pub fn get_year_format_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutStatics2>>::get_activation_factory().get_year_format_property()
    }}
}
DEFINE_CLSID!(DatePickerFlyout(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,68,97,116,101,80,105,99,107,101,114,70,108,121,111,117,116,0]) [CLSID_DatePickerFlyout]);
DEFINE_IID!(IID_IDatePickerFlyout2, 3484519867, 39217, 16665, 139, 218, 84, 168, 111, 223, 172, 132);
RT_INTERFACE!{interface IDatePickerFlyout2(IDatePickerFlyout2Vtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyout2] {
    fn get_DayFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_DayFormat(&self, value: HSTRING) -> HRESULT,
    fn get_MonthFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_MonthFormat(&self, value: HSTRING) -> HRESULT,
    fn get_YearFormat(&self, out: *mut HSTRING) -> HRESULT,
    fn put_YearFormat(&self, value: HSTRING) -> HRESULT
}}
impl IDatePickerFlyout2 {
    #[inline] pub unsafe fn get_day_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_day_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DayFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_month_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MonthFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_format(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YearFormat)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_year_format(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_YearFormat)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerFlyoutItem, 2644230793, 210, 19116, 156, 133, 215, 79, 6, 54, 120, 135);
RT_INTERFACE!{interface IDatePickerFlyoutItem(IDatePickerFlyoutItemVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyoutItem] {
    fn get_PrimaryText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_PrimaryText(&self, value: HSTRING) -> HRESULT,
    fn get_SecondaryText(&self, out: *mut HSTRING) -> HRESULT,
    fn put_SecondaryText(&self, value: HSTRING) -> HRESULT
}}
impl IDatePickerFlyoutItem {
    #[inline] pub unsafe fn get_primary_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_primary_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_PrimaryText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_text(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryText)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_secondary_text(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SecondaryText)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class DatePickerFlyoutItem: IDatePickerFlyoutItem}
impl RtActivatable<IDatePickerFlyoutItemStatics> for DatePickerFlyoutItem {}
impl DatePickerFlyoutItem {
    #[inline] pub fn get_primary_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutItemStatics>>::get_activation_factory().get_primary_text_property()
    }}
    #[inline] pub fn get_secondary_text_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IDatePickerFlyoutItemStatics>>::get_activation_factory().get_secondary_text_property()
    }}
}
DEFINE_CLSID!(DatePickerFlyoutItem(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,68,97,116,101,80,105,99,107,101,114,70,108,121,111,117,116,73,116,101,109,0]) [CLSID_DatePickerFlyoutItem]);
DEFINE_IID!(IID_IDatePickerFlyoutItemStatics, 2862387674, 2038, 19679, 137, 180, 221, 163, 189, 176, 234, 107);
RT_INTERFACE!{static interface IDatePickerFlyoutItemStatics(IDatePickerFlyoutItemStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyoutItemStatics] {
    fn get_PrimaryTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SecondaryTextProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IDatePickerFlyoutItemStatics {
    #[inline] pub unsafe fn get_primary_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PrimaryTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_secondary_text_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SecondaryTextProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerFlyoutPresenter, 2086860558, 11740, 17281, 131, 47, 84, 203, 223, 170, 132, 154);
RT_INTERFACE!{interface IDatePickerFlyoutPresenter(IDatePickerFlyoutPresenterVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyoutPresenter] {
    
}}
RT_CLASS!{class DatePickerFlyoutPresenter: IDatePickerFlyoutPresenter}
DEFINE_IID!(IID_IDatePickerFlyoutStatics, 3445031799, 22597, 19474, 140, 16, 89, 45, 159, 204, 124, 217);
RT_INTERFACE!{static interface IDatePickerFlyoutStatics(IDatePickerFlyoutStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyoutStatics] {
    fn get_CalendarIdentifierProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_YearVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinYearProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxYearProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IDatePickerFlyoutStatics {
    #[inline] pub unsafe fn get_calendar_identifier_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifierProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YearVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_year_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinYearProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_year_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxYearProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerFlyoutStatics2, 2949899625, 33254, 19284, 132, 169, 104, 7, 155, 115, 227, 78);
RT_INTERFACE!{static interface IDatePickerFlyoutStatics2(IDatePickerFlyoutStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerFlyoutStatics2] {
    fn get_DayFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_YearFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IDatePickerFlyoutStatics2 {
    #[inline] pub unsafe fn get_day_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YearFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerStatics, 405699689, 8470, 19559, 181, 19, 113, 51, 100, 131, 29, 121);
RT_INTERFACE!{static interface IDatePickerStatics(IDatePickerStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerStatics] {
    fn get_HeaderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CalendarIdentifierProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_YearVisibleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DayFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MonthFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_YearFormatProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MinYearProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MaxYearProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_OrientationProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IDatePickerStatics {
    #[inline] pub unsafe fn get_header_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_calendar_identifier_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CalendarIdentifierProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_date_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_visible_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YearVisibleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_day_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DayFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_month_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MonthFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_year_format_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_YearFormatProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_min_year_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MinYearProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_max_year_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MaxYearProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OrientationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerStatics2, 4043795958, 64422, 17744, 139, 136, 166, 66, 8, 71, 246, 13);
RT_INTERFACE!{static interface IDatePickerStatics2(IDatePickerStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerStatics2] {
    fn get_LightDismissOverlayModeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IDatePickerStatics2 {
    #[inline] pub unsafe fn get_light_dismiss_overlay_mode_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_LightDismissOverlayModeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDatePickerValueChangedEventArgs, 451305906, 45492, 17011, 150, 224, 25, 218, 255, 24, 116, 70);
RT_INTERFACE!{interface IDatePickerValueChangedEventArgs(IDatePickerValueChangedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDatePickerValueChangedEventArgs] {
    fn get_OldDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT,
    fn get_NewDate(&self, out: *mut ::rt::gen::windows::foundation::DateTime) -> HRESULT
}}
impl IDatePickerValueChangedEventArgs {
    #[inline] pub unsafe fn get_old_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_OldDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_new_date(&self) -> Result<::rt::gen::windows::foundation::DateTime> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NewDate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DatePickerValueChangedEventArgs: IDatePickerValueChangedEventArgs}
RT_ENUM! { enum DisabledFormattingAccelerators: u32 {
    None (DisabledFormattingAccelerators_None) = 0, Bold (DisabledFormattingAccelerators_Bold) = 1, Italic (DisabledFormattingAccelerators_Italic) = 2, Underline (DisabledFormattingAccelerators_Underline) = 4, All (DisabledFormattingAccelerators_All) = 4294967295,
}}
DEFINE_IID!(IID_IDragItemsCompletedEventArgs, 2936402479, 40568, 19233, 154, 142, 65, 194, 209, 54, 122, 42);
RT_INTERFACE!{interface IDragItemsCompletedEventArgs(IDragItemsCompletedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDragItemsCompletedEventArgs] {
    fn get_Items(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVectorView<IInspectable>) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn get_DropResult(&self, out: *mut ::rt::gen::windows::applicationmodel::datatransfer::DataPackageOperation) -> HRESULT
}}
impl IDragItemsCompletedEventArgs {
    #[inline] pub unsafe fn get_items(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVectorView<IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Items)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_drop_result(&self) -> Result<::rt::gen::windows::applicationmodel::datatransfer::DataPackageOperation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DropResult)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DragItemsCompletedEventArgs: IDragItemsCompletedEventArgs}
DEFINE_IID!(IID_IDragItemsStartingEventArgs, 1909399900, 56045, 18307, 170, 17, 220, 87, 77, 39, 19, 233);
RT_INTERFACE!{interface IDragItemsStartingEventArgs(IDragItemsStartingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDragItemsStartingEventArgs] {
    fn get_Cancel(&self, out: *mut bool) -> HRESULT,
    fn put_Cancel(&self, value: bool) -> HRESULT,
    fn get_Items(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<IInspectable>) -> HRESULT,
    #[cfg(feature="windows-applicationmodel")] fn get_Data(&self, out: *mut *mut ::rt::gen::windows::applicationmodel::datatransfer::DataPackage) -> HRESULT
}}
impl IDragItemsStartingEventArgs {
    #[inline] pub unsafe fn get_cancel(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Cancel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cancel(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Cancel)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_items(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Items)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[cfg(feature="windows-applicationmodel")] #[inline] pub unsafe fn get_data(&self) -> Result<ComPtr<::rt::gen::windows::applicationmodel::datatransfer::DataPackage>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Data)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class DragItemsStartingEventArgs: IDragItemsStartingEventArgs}
impl RtActivatable<IActivationFactory> for DragItemsStartingEventArgs {}
DEFINE_CLSID!(DragItemsStartingEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,68,114,97,103,73,116,101,109,115,83,116,97,114,116,105,110,103,69,118,101,110,116,65,114,103,115,0]) [CLSID_DragItemsStartingEventArgs]);
DEFINE_IID!(IID_DragItemsStartingEventHandler, 984525644, 5323, 17460, 190, 204, 136, 168, 88, 92, 47, 137);
RT_DELEGATE!{delegate DragItemsStartingEventHandler(DragItemsStartingEventHandlerVtbl, DragItemsStartingEventHandlerImpl) [IID_DragItemsStartingEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut DragItemsStartingEventArgs) -> HRESULT
}}
impl DragItemsStartingEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &DragItemsStartingEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IDynamicOverflowItemsChangingEventArgs, 3376182127, 28526, 20035, 144, 217, 155, 70, 160, 216, 139, 159);
RT_INTERFACE!{interface IDynamicOverflowItemsChangingEventArgs(IDynamicOverflowItemsChangingEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IDynamicOverflowItemsChangingEventArgs] {
    fn get_Action(&self, out: *mut CommandBarDynamicOverflowAction) -> HRESULT
}}
impl IDynamicOverflowItemsChangingEventArgs {
    #[inline] pub unsafe fn get_action(&self) -> Result<CommandBarDynamicOverflowAction> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Action)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
RT_CLASS!{class DynamicOverflowItemsChangingEventArgs: IDynamicOverflowItemsChangingEventArgs}
impl RtActivatable<IActivationFactory> for DynamicOverflowItemsChangingEventArgs {}
DEFINE_CLSID!(DynamicOverflowItemsChangingEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,68,121,110,97,109,105,99,79,118,101,114,102,108,111,119,73,116,101,109,115,67,104,97,110,103,105,110,103,69,118,101,110,116,65,114,103,115,0]) [CLSID_DynamicOverflowItemsChangingEventArgs]);
DEFINE_IID!(IID_IFlipView, 2706911080, 15741, 19771, 183, 29, 72, 142, 237, 30, 52, 147);
RT_INTERFACE!{interface IFlipView(IFlipViewVtbl): IInspectable(IInspectableVtbl) [IID_IFlipView] {
    
}}
RT_CLASS!{class FlipView: IFlipView}
impl RtActivatable<IFlipViewStatics2> for FlipView {}
impl FlipView {
    #[inline] pub fn get_use_touch_animations_for_all_navigation_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFlipViewStatics2>>::get_activation_factory().get_use_touch_animations_for_all_navigation_property()
    }}
}
DEFINE_CLSID!(FlipView(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,70,108,105,112,86,105,101,119,0]) [CLSID_FlipView]);
DEFINE_IID!(IID_IFlipView2, 3305022717, 31475, 18770, 159, 217, 158, 9, 135, 252, 79, 41);
RT_INTERFACE!{interface IFlipView2(IFlipView2Vtbl): IInspectable(IInspectableVtbl) [IID_IFlipView2] {
    fn get_UseTouchAnimationsForAllNavigation(&self, out: *mut bool) -> HRESULT,
    fn put_UseTouchAnimationsForAllNavigation(&self, value: bool) -> HRESULT
}}
impl IFlipView2 {
    #[inline] pub unsafe fn get_use_touch_animations_for_all_navigation(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_UseTouchAnimationsForAllNavigation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_use_touch_animations_for_all_navigation(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_UseTouchAnimationsForAllNavigation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFlipViewFactory, 4057901502, 39656, 19787, 171, 67, 22, 211, 30, 5, 244, 243);
RT_INTERFACE!{interface IFlipViewFactory(IFlipViewFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFlipViewFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FlipView) -> HRESULT
}}
impl IFlipViewFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FlipView>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFlipViewItem, 1444504933, 52779, 19418, 163, 107, 130, 162, 184, 176, 212, 192);
RT_INTERFACE!{interface IFlipViewItem(IFlipViewItemVtbl): IInspectable(IInspectableVtbl) [IID_IFlipViewItem] {
    
}}
RT_CLASS!{class FlipViewItem: IFlipViewItem}
DEFINE_IID!(IID_IFlipViewItemFactory, 4062024190, 8864, 17426, 168, 83, 157, 106, 110, 143, 42, 175);
RT_INTERFACE!{interface IFlipViewItemFactory(IFlipViewItemFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFlipViewItemFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FlipViewItem) -> HRESULT
}}
impl IFlipViewItemFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FlipViewItem>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFlipViewStatics2, 1893980479, 17160, 19362, 187, 206, 226, 203, 14, 211, 68, 118);
RT_INTERFACE!{static interface IFlipViewStatics2(IFlipViewStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IFlipViewStatics2] {
    fn get_UseTouchAnimationsForAllNavigationProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFlipViewStatics2 {
    #[inline] pub unsafe fn get_use_touch_animations_for_all_navigation_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_UseTouchAnimationsForAllNavigationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFlyout, 1703209951, 52167, 19993, 132, 58, 161, 79, 36, 167, 147, 234);
RT_INTERFACE!{interface IFlyout(IFlyoutVtbl): IInspectable(IInspectableVtbl) [IID_IFlyout] {
    fn get_Content(&self, out: *mut *mut super::UIElement) -> HRESULT,
    fn put_Content(&self, value: *mut super::UIElement) -> HRESULT,
    fn get_FlyoutPresenterStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_FlyoutPresenterStyle(&self, value: *mut super::Style) -> HRESULT
}}
impl IFlyout {
    #[inline] pub unsafe fn get_content(&self) -> Result<ComPtr<super::UIElement>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Content)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content(&self, value: &super::UIElement) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Content)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flyout_presenter_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlyoutPresenterStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_flyout_presenter_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FlyoutPresenterStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Flyout: IFlyout}
impl RtActivatable<IFlyoutStatics> for Flyout {}
impl Flyout {
    #[inline] pub fn get_content_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFlyoutStatics>>::get_activation_factory().get_content_property()
    }}
    #[inline] pub fn get_flyout_presenter_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFlyoutStatics>>::get_activation_factory().get_flyout_presenter_style_property()
    }}
}
DEFINE_CLSID!(Flyout(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,70,108,121,111,117,116,0]) [CLSID_Flyout]);
DEFINE_IID!(IID_IFlyoutFactory, 1273841971, 142, 19203, 163, 133, 121, 254, 82, 102, 221, 186);
RT_INTERFACE!{interface IFlyoutFactory(IFlyoutFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFlyoutFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Flyout) -> HRESULT
}}
impl IFlyoutFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Flyout>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFlyoutPresenter, 2189253497, 58235, 18085, 141, 68, 99, 161, 26, 88, 14, 131);
RT_INTERFACE!{interface IFlyoutPresenter(IFlyoutPresenterVtbl): IInspectable(IInspectableVtbl) [IID_IFlyoutPresenter] {
    
}}
RT_CLASS!{class FlyoutPresenter: IFlyoutPresenter}
DEFINE_IID!(IID_IFlyoutPresenterFactory, 3998049935, 55926, 18074, 172, 215, 48, 96, 230, 19, 173, 231);
RT_INTERFACE!{interface IFlyoutPresenterFactory(IFlyoutPresenterFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFlyoutPresenterFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FlyoutPresenter) -> HRESULT
}}
impl IFlyoutPresenterFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FlyoutPresenter>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFlyoutStatics, 1630948875, 56181, 18401, 178, 195, 91, 144, 28, 61, 116, 182);
RT_INTERFACE!{static interface IFlyoutStatics(IFlyoutStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFlyoutStatics] {
    fn get_ContentProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FlyoutPresenterStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFlyoutStatics {
    #[inline] pub unsafe fn get_content_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_flyout_presenter_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FlyoutPresenterStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFocusDisengagedEventArgs, 1578379279, 38206, 19704, 185, 234, 197, 48, 161, 206, 2, 173);
RT_INTERFACE!{interface IFocusDisengagedEventArgs(IFocusDisengagedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFocusDisengagedEventArgs] {
    
}}
RT_CLASS!{class FocusDisengagedEventArgs: IFocusDisengagedEventArgs}
DEFINE_IID!(IID_IFocusEngagedEventArgs, 2795488082, 55910, 16460, 130, 63, 83, 88, 89, 78, 112, 187);
RT_INTERFACE!{interface IFocusEngagedEventArgs(IFocusEngagedEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IFocusEngagedEventArgs] {
    
}}
RT_CLASS!{class FocusEngagedEventArgs: IFocusEngagedEventArgs}
DEFINE_IID!(IID_IFocusEngagedEventArgs2, 1247404276, 34752, 19661, 147, 196, 163, 160, 28, 227, 146, 101);
RT_INTERFACE!{interface IFocusEngagedEventArgs2(IFocusEngagedEventArgs2Vtbl): IInspectable(IInspectableVtbl) [IID_IFocusEngagedEventArgs2] {
    fn get_Handled(&self, out: *mut bool) -> HRESULT,
    fn put_Handled(&self, value: bool) -> HRESULT
}}
impl IFocusEngagedEventArgs2 {
    #[inline] pub unsafe fn get_handled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Handled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_handled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Handled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIcon, 3570799505, 14764, 18768, 145, 102, 54, 6, 194, 100, 65, 139);
RT_INTERFACE!{interface IFontIcon(IFontIconVtbl): IInspectable(IInspectableVtbl) [IID_IFontIcon] {
    fn get_Glyph(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Glyph(&self, value: HSTRING) -> HRESULT,
    fn get_FontSize(&self, out: *mut f64) -> HRESULT,
    fn put_FontSize(&self, value: f64) -> HRESULT,
    fn get_FontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_FontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_FontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_FontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    #[cfg(feature="windows-ui")] fn get_FontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(feature="windows-ui")] fn put_FontStyle(&self, value: super::super::text::FontStyle) -> HRESULT
}}
impl IFontIcon {
    #[inline] pub unsafe fn get_glyph(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Glyph)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_glyph(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Glyph)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FontIcon: IFontIcon}
impl RtActivatable<IFontIconStatics> for FontIcon {}
impl RtActivatable<IFontIconStatics2> for FontIcon {}
impl RtActivatable<IFontIconStatics3> for FontIcon {}
impl FontIcon {
    #[inline] pub fn get_glyph_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics>>::get_activation_factory().get_glyph_property()
    }}
    #[inline] pub fn get_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics>>::get_activation_factory().get_font_size_property()
    }}
    #[inline] pub fn get_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics>>::get_activation_factory().get_font_family_property()
    }}
    #[inline] pub fn get_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics>>::get_activation_factory().get_font_weight_property()
    }}
    #[inline] pub fn get_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics>>::get_activation_factory().get_font_style_property()
    }}
    #[inline] pub fn get_is_text_scale_factor_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics2>>::get_activation_factory().get_is_text_scale_factor_enabled_property()
    }}
    #[inline] pub fn get_mirrored_when_right_to_left_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconStatics3>>::get_activation_factory().get_mirrored_when_right_to_left_property()
    }}
}
DEFINE_CLSID!(FontIcon(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,70,111,110,116,73,99,111,110,0]) [CLSID_FontIcon]);
DEFINE_IID!(IID_IFontIcon2, 4142651469, 14312, 18158, 165, 116, 65, 173, 85, 4, 130, 224);
RT_INTERFACE!{interface IFontIcon2(IFontIcon2Vtbl): IInspectable(IInspectableVtbl) [IID_IFontIcon2] {
    fn get_IsTextScaleFactorEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTextScaleFactorEnabled(&self, value: bool) -> HRESULT
}}
impl IFontIcon2 {
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_text_scale_factor_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTextScaleFactorEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIcon3, 1633016089, 7276, 18768, 135, 148, 35, 30, 240, 145, 77, 148);
RT_INTERFACE!{interface IFontIcon3(IFontIcon3Vtbl): IInspectable(IInspectableVtbl) [IID_IFontIcon3] {
    fn get_MirroredWhenRightToLeft(&self, out: *mut bool) -> HRESULT,
    fn put_MirroredWhenRightToLeft(&self, value: bool) -> HRESULT
}}
impl IFontIcon3 {
    #[inline] pub unsafe fn get_mirrored_when_right_to_left(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MirroredWhenRightToLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mirrored_when_right_to_left(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MirroredWhenRightToLeft)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIconFactory, 477633387, 14271, 19932, 161, 168, 27, 119, 219, 60, 240, 234);
RT_INTERFACE!{interface IFontIconFactory(IFontIconFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFontIconFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FontIcon) -> HRESULT
}}
impl IFontIconFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FontIcon>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIconSource, 571583642, 29923, 17389, 182, 28, 33, 175, 199, 223, 77, 16);
RT_INTERFACE!{interface IFontIconSource(IFontIconSourceVtbl): IInspectable(IInspectableVtbl) [IID_IFontIconSource] {
    fn get_Glyph(&self, out: *mut HSTRING) -> HRESULT,
    fn put_Glyph(&self, value: HSTRING) -> HRESULT,
    fn get_FontSize(&self, out: *mut f64) -> HRESULT,
    fn put_FontSize(&self, value: f64) -> HRESULT,
    fn get_FontFamily(&self, out: *mut *mut super::media::FontFamily) -> HRESULT,
    fn put_FontFamily(&self, value: *mut super::media::FontFamily) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontWeight(&self, out: *mut super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy7(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontWeight(&self, value: super::super::text::FontWeight) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy8(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_FontStyle(&self, out: *mut super::super::text::FontStyle) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy9(&self) -> (),
    #[cfg(feature="windows-ui")] fn put_FontStyle(&self, value: super::super::text::FontStyle) -> HRESULT,
    fn get_IsTextScaleFactorEnabled(&self, out: *mut bool) -> HRESULT,
    fn put_IsTextScaleFactorEnabled(&self, value: bool) -> HRESULT,
    fn get_MirroredWhenRightToLeft(&self, out: *mut bool) -> HRESULT,
    fn put_MirroredWhenRightToLeft(&self, value: bool) -> HRESULT
}}
impl IFontIconSource {
    #[inline] pub unsafe fn get_glyph(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Glyph)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_glyph(&self, value: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Glyph)(self as *const _ as *mut _, value.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_size(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family(&self) -> Result<ComPtr<super::media::FontFamily>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamily)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_font_family(&self, value: &super::media::FontFamily) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontFamily)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_weight(&self) -> Result<super::super::text::FontWeight> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontWeight)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_weight(&self, value: super::super::text::FontWeight) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontWeight)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_font_style(&self) -> Result<super::super::text::FontStyle> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_FontStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn set_font_style(&self, value: super::super::text::FontStyle) -> Result<()> {
        let hr = ((*self.lpVtbl).put_FontStyle)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabled)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_text_scale_factor_enabled(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsTextScaleFactorEnabled)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mirrored_when_right_to_left(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_MirroredWhenRightToLeft)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_mirrored_when_right_to_left(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_MirroredWhenRightToLeft)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class FontIconSource: IFontIconSource}
impl RtActivatable<IFontIconSourceStatics> for FontIconSource {}
impl FontIconSource {
    #[inline] pub fn get_glyph_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_glyph_property()
    }}
    #[inline] pub fn get_font_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_font_size_property()
    }}
    #[inline] pub fn get_font_family_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_font_family_property()
    }}
    #[inline] pub fn get_font_weight_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_font_weight_property()
    }}
    #[inline] pub fn get_font_style_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_font_style_property()
    }}
    #[inline] pub fn get_is_text_scale_factor_enabled_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_is_text_scale_factor_enabled_property()
    }}
    #[inline] pub fn get_mirrored_when_right_to_left_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFontIconSourceStatics>>::get_activation_factory().get_mirrored_when_right_to_left_property()
    }}
}
DEFINE_CLSID!(FontIconSource(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,70,111,110,116,73,99,111,110,83,111,117,114,99,101,0]) [CLSID_FontIconSource]);
DEFINE_IID!(IID_IFontIconSourceFactory, 2346514109, 64518, 17080, 179, 11, 117, 5, 8, 42, 195, 143);
RT_INTERFACE!{interface IFontIconSourceFactory(IFontIconSourceFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFontIconSourceFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut FontIconSource) -> HRESULT
}}
impl IFontIconSourceFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<FontIconSource>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIconSourceStatics, 2349744687, 33385, 17329, 185, 90, 239, 7, 14, 134, 119, 13);
RT_INTERFACE!{static interface IFontIconSourceStatics(IFontIconSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFontIconSourceStatics] {
    fn get_GlyphProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsTextScaleFactorEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_MirroredWhenRightToLeftProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFontIconSourceStatics {
    #[inline] pub unsafe fn get_glyph_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GlyphProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_mirrored_when_right_to_left_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MirroredWhenRightToLeftProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIconStatics, 3015605238, 5223, 16518, 187, 203, 78, 33, 217, 122, 123, 77);
RT_INTERFACE!{static interface IFontIconStatics(IFontIconStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFontIconStatics] {
    fn get_GlyphProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontFamilyProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontWeightProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_FontStyleProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFontIconStatics {
    #[inline] pub unsafe fn get_glyph_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_GlyphProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_family_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontFamilyProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_weight_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontWeightProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_font_style_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_FontStyleProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIconStatics2, 3859285618, 2296, 17363, 135, 144, 70, 4, 41, 12, 190, 189);
RT_INTERFACE!{static interface IFontIconStatics2(IFontIconStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IFontIconStatics2] {
    fn get_IsTextScaleFactorEnabledProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFontIconStatics2 {
    #[inline] pub unsafe fn get_is_text_scale_factor_enabled_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsTextScaleFactorEnabledProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFontIconStatics3, 2756872983, 45188, 19413, 170, 180, 254, 174, 157, 59, 93, 38);
RT_INTERFACE!{static interface IFontIconStatics3(IFontIconStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IFontIconStatics3] {
    fn get_MirroredWhenRightToLeftProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFontIconStatics3 {
    #[inline] pub unsafe fn get_mirrored_when_right_to_left_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_MirroredWhenRightToLeftProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrame, 1760186379, 16361, 18229, 182, 160, 231, 96, 25, 51, 176, 137);
RT_INTERFACE!{interface IFrame(IFrameVtbl): IInspectable(IInspectableVtbl) [IID_IFrame] {
    fn get_CacheSize(&self, out: *mut i32) -> HRESULT,
    fn put_CacheSize(&self, value: i32) -> HRESULT,
    fn get_CanGoBack(&self, out: *mut bool) -> HRESULT,
    fn get_CanGoForward(&self, out: *mut bool) -> HRESULT,
    fn get_CurrentSourcePageType(&self, out: *mut super::interop::TypeName) -> HRESULT,
    fn get_SourcePageType(&self, out: *mut super::interop::TypeName) -> HRESULT,
    fn put_SourcePageType(&self, value: super::interop::TypeName) -> HRESULT,
    fn get_BackStackDepth(&self, out: *mut i32) -> HRESULT,
    fn add_Navigated(&self, value: *mut super::navigation::NavigatedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Navigated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_Navigating(&self, value: *mut super::navigation::NavigatingCancelEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_Navigating(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NavigationFailed(&self, value: *mut super::navigation::NavigationFailedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NavigationFailed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_NavigationStopped(&self, value: *mut super::navigation::NavigationStoppedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_NavigationStopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn GoBack(&self) -> HRESULT,
    fn GoForward(&self) -> HRESULT,
    fn Navigate(&self, sourcePageType: super::interop::TypeName, parameter: *mut IInspectable, out: *mut bool) -> HRESULT,
    fn GetNavigationState(&self, out: *mut HSTRING) -> HRESULT,
    fn SetNavigationState(&self, navigationState: HSTRING) -> HRESULT
}}
impl IFrame {
    #[inline] pub unsafe fn get_cache_size(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CacheSize)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_cache_size(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CacheSize)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_go_back(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanGoBack)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_go_forward(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CanGoForward)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_source_page_type(&self) -> Result<super::interop::TypeName> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CurrentSourcePageType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_page_type(&self) -> Result<super::interop::TypeName> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_SourcePageType)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source_page_type(&self, value: super::interop::TypeName) -> Result<()> {
        let hr = ((*self.lpVtbl).put_SourcePageType)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_back_stack_depth(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BackStackDepth)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigated(&self, value: &super::navigation::NavigatedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Navigated)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigated(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Navigated)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigating(&self, value: &super::navigation::NavigatingCancelEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_Navigating)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigating(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_Navigating)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigation_failed(&self, value: &super::navigation::NavigationFailedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NavigationFailed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigation_failed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NavigationFailed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_navigation_stopped(&self, value: &super::navigation::NavigationStoppedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_NavigationStopped)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_navigation_stopped(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_NavigationStopped)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn go_back(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).GoBack)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn go_forward(&self) -> Result<()> {
        let hr = ((*self.lpVtbl).GoForward)(self as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn navigate(&self, sourcePageType: super::interop::TypeName, parameter: &IInspectable) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Navigate)(self as *const _ as *mut _, sourcePageType, parameter as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_navigation_state(&self) -> Result<HString> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetNavigationState)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(HString::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_navigation_state(&self, navigationState: &HStringArg) -> Result<()> {
        let hr = ((*self.lpVtbl).SetNavigationState)(self as *const _ as *mut _, navigationState.get());
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Frame: IFrame}
impl RtActivatable<IFrameStatics> for Frame {}
impl RtActivatable<IFrameStatics2> for Frame {}
impl Frame {
    #[inline] pub fn get_cache_size_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics>>::get_activation_factory().get_cache_size_property()
    }}
    #[inline] pub fn get_can_go_back_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics>>::get_activation_factory().get_can_go_back_property()
    }}
    #[inline] pub fn get_can_go_forward_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics>>::get_activation_factory().get_can_go_forward_property()
    }}
    #[inline] pub fn get_current_source_page_type_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics>>::get_activation_factory().get_current_source_page_type_property()
    }}
    #[inline] pub fn get_source_page_type_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics>>::get_activation_factory().get_source_page_type_property()
    }}
    #[inline] pub fn get_back_stack_depth_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics>>::get_activation_factory().get_back_stack_depth_property()
    }}
    #[inline] pub fn get_back_stack_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics2>>::get_activation_factory().get_back_stack_property()
    }}
    #[inline] pub fn get_forward_stack_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IFrameStatics2>>::get_activation_factory().get_forward_stack_property()
    }}
}
DEFINE_CLSID!(Frame(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,70,114,97,109,101,0]) [CLSID_Frame]);
DEFINE_IID!(IID_IFrame2, 1060536199, 40794, 19204, 184, 24, 181, 84, 192, 105, 89, 122);
RT_INTERFACE!{interface IFrame2(IFrame2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrame2] {
    fn get_BackStack(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<super::navigation::PageStackEntry>) -> HRESULT,
    fn get_ForwardStack(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<super::navigation::PageStackEntry>) -> HRESULT,
    fn Navigate(&self, sourcePageType: super::interop::TypeName, parameter: *mut IInspectable, infoOverride: *mut super::media::animation::NavigationTransitionInfo, out: *mut bool) -> HRESULT
}}
impl IFrame2 {
    #[inline] pub unsafe fn get_back_stack(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<super::navigation::PageStackEntry>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackStack)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_forward_stack(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<super::navigation::PageStackEntry>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForwardStack)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn navigate(&self, sourcePageType: super::interop::TypeName, parameter: &IInspectable, infoOverride: &super::media::animation::NavigationTransitionInfo) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).Navigate)(self as *const _ as *mut _, sourcePageType, parameter as *const _ as *mut _, infoOverride as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrame3, 1686776653, 21450, 19290, 170, 142, 60, 199, 68, 15, 74, 103);
RT_INTERFACE!{interface IFrame3(IFrame3Vtbl): IInspectable(IInspectableVtbl) [IID_IFrame3] {
    fn GoBack(&self, transitionInfoOverride: *mut super::media::animation::NavigationTransitionInfo) -> HRESULT
}}
impl IFrame3 {
    #[inline] pub unsafe fn go_back(&self, transitionInfoOverride: &super::media::animation::NavigationTransitionInfo) -> Result<()> {
        let hr = ((*self.lpVtbl).GoBack)(self as *const _ as *mut _, transitionInfoOverride as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrame4, 2602025498, 48427, 18944, 153, 235, 148, 107, 233, 97, 128, 132);
RT_INTERFACE!{interface IFrame4(IFrame4Vtbl): IInspectable(IInspectableVtbl) [IID_IFrame4] {
    fn SetNavigationStateWithNavigationControl(&self, navigationState: HSTRING, suppressNavigate: bool) -> HRESULT
}}
impl IFrame4 {
    #[inline] pub unsafe fn set_navigation_state_with_navigation_control(&self, navigationState: &HStringArg, suppressNavigate: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).SetNavigationStateWithNavigationControl)(self as *const _ as *mut _, navigationState.get(), suppressNavigate);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameFactory, 49189844, 17550, 18078, 151, 153, 10, 138, 31, 112, 241, 113);
RT_INTERFACE!{interface IFrameFactory(IFrameFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IFrameFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Frame) -> HRESULT
}}
impl IFrameFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Frame>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameStatics, 3584880873, 55655, 18203, 132, 89, 200, 175, 67, 65, 81, 27);
RT_INTERFACE!{static interface IFrameStatics(IFrameStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IFrameStatics] {
    fn get_CacheSizeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CanGoBackProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CanGoForwardProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CurrentSourcePageTypeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SourcePageTypeProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BackStackDepthProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFrameStatics {
    #[inline] pub unsafe fn get_cache_size_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CacheSizeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_go_back_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CanGoBackProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_can_go_forward_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CanGoForwardProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_current_source_page_type_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CurrentSourcePageTypeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_source_page_type_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourcePageTypeProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_back_stack_depth_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackStackDepthProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IFrameStatics2, 3837119998, 17136, 17506, 161, 193, 93, 37, 157, 216, 42, 3);
RT_INTERFACE!{static interface IFrameStatics2(IFrameStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IFrameStatics2] {
    fn get_BackStackProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ForwardStackProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IFrameStatics2 {
    #[inline] pub unsafe fn get_back_stack_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BackStackProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_forward_stack_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForwardStackProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGrid, 4245701728, 11797, 19363, 139, 143, 250, 105, 58, 65, 97, 233);
RT_INTERFACE!{interface IGrid(IGridVtbl): IInspectable(IInspectableVtbl) [IID_IGrid] {
    fn get_RowDefinitions(&self, out: *mut *mut RowDefinitionCollection) -> HRESULT,
    fn get_ColumnDefinitions(&self, out: *mut *mut ColumnDefinitionCollection) -> HRESULT
}}
impl IGrid {
    #[inline] pub unsafe fn get_row_definitions(&self) -> Result<ComPtr<RowDefinitionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RowDefinitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column_definitions(&self) -> Result<ComPtr<ColumnDefinitionCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColumnDefinitions)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class Grid: IGrid}
impl RtActivatable<IGridStatics> for Grid {}
impl RtActivatable<IGridStatics2> for Grid {}
impl RtActivatable<IGridStatics3> for Grid {}
impl Grid {
    #[inline] pub fn get_row_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_row_property()
    }}
    #[inline] pub fn get_row(element: &super::FrameworkElement) -> Result<i32> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_row(element)
    }}
    #[inline] pub fn set_row(element: &super::FrameworkElement, value: i32) -> Result<()> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().set_row(element, value)
    }}
    #[inline] pub fn get_column_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_column_property()
    }}
    #[inline] pub fn get_column(element: &super::FrameworkElement) -> Result<i32> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_column(element)
    }}
    #[inline] pub fn set_column(element: &super::FrameworkElement, value: i32) -> Result<()> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().set_column(element, value)
    }}
    #[inline] pub fn get_row_span_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_row_span_property()
    }}
    #[inline] pub fn get_row_span(element: &super::FrameworkElement) -> Result<i32> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_row_span(element)
    }}
    #[inline] pub fn set_row_span(element: &super::FrameworkElement, value: i32) -> Result<()> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().set_row_span(element, value)
    }}
    #[inline] pub fn get_column_span_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_column_span_property()
    }}
    #[inline] pub fn get_column_span(element: &super::FrameworkElement) -> Result<i32> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().get_column_span(element)
    }}
    #[inline] pub fn set_column_span(element: &super::FrameworkElement, value: i32) -> Result<()> { unsafe {
        <Self as RtActivatable<IGridStatics>>::get_activation_factory().set_column_span(element, value)
    }}
    #[inline] pub fn get_border_brush_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics2>>::get_activation_factory().get_border_brush_property()
    }}
    #[inline] pub fn get_border_thickness_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics2>>::get_activation_factory().get_border_thickness_property()
    }}
    #[inline] pub fn get_corner_radius_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics2>>::get_activation_factory().get_corner_radius_property()
    }}
    #[inline] pub fn get_padding_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics2>>::get_activation_factory().get_padding_property()
    }}
    #[inline] pub fn get_row_spacing_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics3>>::get_activation_factory().get_row_spacing_property()
    }}
    #[inline] pub fn get_column_spacing_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IGridStatics3>>::get_activation_factory().get_column_spacing_property()
    }}
}
DEFINE_CLSID!(Grid(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,71,114,105,100,0]) [CLSID_Grid]);
DEFINE_IID!(IID_IGrid2, 4151245377, 14350, 17883, 190, 135, 158, 19, 38, 186, 75, 87);
RT_INTERFACE!{interface IGrid2(IGrid2Vtbl): IInspectable(IInspectableVtbl) [IID_IGrid2] {
    fn get_BorderBrush(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_BorderBrush(&self, value: *mut super::media::Brush) -> HRESULT,
    fn get_BorderThickness(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_BorderThickness(&self, value: super::Thickness) -> HRESULT,
    fn get_CornerRadius(&self, out: *mut super::CornerRadius) -> HRESULT,
    fn put_CornerRadius(&self, value: super::CornerRadius) -> HRESULT,
    fn get_Padding(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_Padding(&self, value: super::Thickness) -> HRESULT
}}
impl IGrid2 {
    #[inline] pub unsafe fn get_border_brush(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrush)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_brush(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderBrush)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_BorderThickness)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_border_thickness(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_BorderThickness)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_corner_radius(&self) -> Result<super::CornerRadius> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_CornerRadius)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_corner_radius(&self, value: super::CornerRadius) -> Result<()> {
        let hr = ((*self.lpVtbl).put_CornerRadius)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Padding)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_padding(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Padding)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGrid3, 316655100, 9026, 19922, 158, 125, 32, 144, 161, 113, 209, 239);
RT_INTERFACE!{interface IGrid3(IGrid3Vtbl): IInspectable(IInspectableVtbl) [IID_IGrid3] {
    fn get_RowSpacing(&self, out: *mut f64) -> HRESULT,
    fn put_RowSpacing(&self, value: f64) -> HRESULT,
    fn get_ColumnSpacing(&self, out: *mut f64) -> HRESULT,
    fn put_ColumnSpacing(&self, value: f64) -> HRESULT
}}
impl IGrid3 {
    #[inline] pub unsafe fn get_row_spacing(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_RowSpacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_row_spacing(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_RowSpacing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column_spacing(&self) -> Result<f64> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_ColumnSpacing)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_column_spacing(&self, value: f64) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ColumnSpacing)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridFactory, 2927706177, 50481, 17332, 191, 153, 18, 245, 6, 247, 176, 28);
RT_INTERFACE!{interface IGridFactory(IGridFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGridFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Grid) -> HRESULT
}}
impl IGridFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Grid>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridStatics, 1694379679, 63825, 17078, 169, 206, 187, 23, 154, 241, 21, 149);
RT_INTERFACE!{static interface IGridStatics(IGridStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IGridStatics] {
    fn get_RowProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetRow(&self, element: *mut super::FrameworkElement, out: *mut i32) -> HRESULT,
    fn SetRow(&self, element: *mut super::FrameworkElement, value: i32) -> HRESULT,
    fn get_ColumnProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetColumn(&self, element: *mut super::FrameworkElement, out: *mut i32) -> HRESULT,
    fn SetColumn(&self, element: *mut super::FrameworkElement, value: i32) -> HRESULT,
    fn get_RowSpanProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetRowSpan(&self, element: *mut super::FrameworkElement, out: *mut i32) -> HRESULT,
    fn SetRowSpan(&self, element: *mut super::FrameworkElement, value: i32) -> HRESULT,
    fn get_ColumnSpanProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn GetColumnSpan(&self, element: *mut super::FrameworkElement, out: *mut i32) -> HRESULT,
    fn SetColumnSpan(&self, element: *mut super::FrameworkElement, value: i32) -> HRESULT
}}
impl IGridStatics {
    #[inline] pub unsafe fn get_row_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RowProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_row(&self, element: &super::FrameworkElement) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetRow)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_row(&self, element: &super::FrameworkElement, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetRow)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColumnProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column(&self, element: &super::FrameworkElement) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetColumn)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_column(&self, element: &super::FrameworkElement, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetColumn)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_row_span_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RowSpanProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_row_span(&self, element: &super::FrameworkElement) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetRowSpan)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_row_span(&self, element: &super::FrameworkElement, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetRowSpan)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column_span_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColumnSpanProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column_span(&self, element: &super::FrameworkElement) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).GetColumnSpan)(self as *const _ as *mut _, element as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_column_span(&self, element: &super::FrameworkElement, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).SetColumnSpan)(self as *const _ as *mut _, element as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridStatics2, 761685592, 22710, 18971, 132, 27, 135, 91, 169, 59, 93, 106);
RT_INTERFACE!{static interface IGridStatics2(IGridStatics2Vtbl): IInspectable(IInspectableVtbl) [IID_IGridStatics2] {
    fn get_BorderBrushProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_BorderThicknessProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_CornerRadiusProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PaddingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IGridStatics2 {
    #[inline] pub unsafe fn get_border_brush_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderBrushProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_border_thickness_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_BorderThicknessProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_corner_radius_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_CornerRadiusProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_padding_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PaddingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridStatics3, 3288048695, 23052, 16506, 150, 33, 121, 84, 83, 134, 216, 17);
RT_INTERFACE!{static interface IGridStatics3(IGridStatics3Vtbl): IInspectable(IInspectableVtbl) [IID_IGridStatics3] {
    fn get_RowSpacingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ColumnSpacingProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IGridStatics3 {
    #[inline] pub unsafe fn get_row_spacing_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_RowSpacingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_column_spacing_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ColumnSpacingProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridView, 40560948, 46718, 19840, 143, 114, 138, 166, 75, 77, 130, 123);
RT_INTERFACE!{interface IGridView(IGridViewVtbl): IInspectable(IInspectableVtbl) [IID_IGridView] {
    
}}
RT_CLASS!{class GridView: IGridView}
DEFINE_IID!(IID_IGridViewFactory, 3653028489, 2553, 19566, 168, 62, 241, 153, 20, 111, 14, 125);
RT_INTERFACE!{interface IGridViewFactory(IGridViewFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGridViewFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut GridView) -> HRESULT
}}
impl IGridViewFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<GridView>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridViewHeaderItem, 1926716798, 24003, 20476, 155, 28, 147, 155, 92, 55, 22, 28);
RT_INTERFACE!{interface IGridViewHeaderItem(IGridViewHeaderItemVtbl): IInspectable(IInspectableVtbl) [IID_IGridViewHeaderItem] {
    
}}
RT_CLASS!{class GridViewHeaderItem: IGridViewHeaderItem}
DEFINE_IID!(IID_IGridViewHeaderItemFactory, 920701294, 46442, 19259, 139, 172, 122, 239, 94, 111, 153, 69);
RT_INTERFACE!{interface IGridViewHeaderItemFactory(IGridViewHeaderItemFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGridViewHeaderItemFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut GridViewHeaderItem) -> HRESULT
}}
impl IGridViewHeaderItemFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<GridViewHeaderItem>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGridViewItem, 2107179505, 59329, 20099, 180, 112, 201, 214, 215, 189, 169, 245);
RT_INTERFACE!{interface IGridViewItem(IGridViewItemVtbl): IInspectable(IInspectableVtbl) [IID_IGridViewItem] {
    fn get_TemplateSettings(&self, out: *mut *mut primitives::GridViewItemTemplateSettings) -> HRESULT
}}
impl IGridViewItem {
    #[inline] pub unsafe fn get_template_settings(&self) -> Result<ComPtr<primitives::GridViewItemTemplateSettings>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TemplateSettings)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GridViewItem: IGridViewItem}
DEFINE_IID!(IID_IGridViewItemFactory, 580583599, 16294, 17385, 151, 157, 7, 234, 13, 98, 128, 220);
RT_INTERFACE!{interface IGridViewItemFactory(IGridViewItemFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGridViewItemFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut GridViewItem) -> HRESULT
}}
impl IGridViewItemFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<GridViewItem>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGroupItem, 1256773073, 29224, 18966, 166, 31, 136, 192, 232, 244, 92, 118);
RT_INTERFACE!{interface IGroupItem(IGroupItemVtbl): IInspectable(IInspectableVtbl) [IID_IGroupItem] {
    
}}
RT_CLASS!{class GroupItem: IGroupItem}
DEFINE_IID!(IID_IGroupItemFactory, 3651261758, 45536, 17177, 152, 8, 122, 158, 136, 126, 19, 176);
RT_INTERFACE!{interface IGroupItemFactory(IGroupItemFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGroupItemFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut GroupItem) -> HRESULT
}}
impl IGroupItemFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<GroupItem>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGroupStyle, 1909075979, 47262, 16772, 176, 223, 169, 233, 84, 71, 222, 141);
RT_INTERFACE!{interface IGroupStyle(IGroupStyleVtbl): IInspectable(IInspectableVtbl) [IID_IGroupStyle] {
    fn get_Panel(&self, out: *mut *mut ItemsPanelTemplate) -> HRESULT,
    fn put_Panel(&self, value: *mut ItemsPanelTemplate) -> HRESULT,
    fn get_ContainerStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_ContainerStyle(&self, value: *mut super::Style) -> HRESULT,
    fn get_ContainerStyleSelector(&self, out: *mut *mut StyleSelector) -> HRESULT,
    fn put_ContainerStyleSelector(&self, value: *mut StyleSelector) -> HRESULT,
    fn get_HeaderTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_HeaderTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_HeaderTemplateSelector(&self, out: *mut *mut DataTemplateSelector) -> HRESULT,
    fn put_HeaderTemplateSelector(&self, value: *mut DataTemplateSelector) -> HRESULT,
    fn get_HidesIfEmpty(&self, out: *mut bool) -> HRESULT,
    fn put_HidesIfEmpty(&self, value: bool) -> HRESULT
}}
impl IGroupStyle {
    #[inline] pub unsafe fn get_panel(&self) -> Result<ComPtr<ItemsPanelTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Panel)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_panel(&self, value: &ItemsPanelTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Panel)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_container_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContainerStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_container_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContainerStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_container_style_selector(&self) -> Result<ComPtr<StyleSelector>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContainerStyleSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_container_style_selector(&self, value: &StyleSelector) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContainerStyleSelector)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template_selector(&self) -> Result<ComPtr<DataTemplateSelector>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplateSelector)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template_selector(&self, value: &DataTemplateSelector) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplateSelector)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_hides_if_empty(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_HidesIfEmpty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_hides_if_empty(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HidesIfEmpty)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class GroupStyle: IGroupStyle}
DEFINE_IID!(IID_IGroupStyle2, 1777927801, 14865, 20455, 180, 223, 42, 1, 57, 212, 1, 139);
RT_INTERFACE!{interface IGroupStyle2(IGroupStyle2Vtbl): IInspectable(IInspectableVtbl) [IID_IGroupStyle2] {
    fn get_HeaderContainerStyle(&self, out: *mut *mut super::Style) -> HRESULT,
    fn put_HeaderContainerStyle(&self, value: *mut super::Style) -> HRESULT
}}
impl IGroupStyle2 {
    #[inline] pub unsafe fn get_header_container_style(&self) -> Result<ComPtr<super::Style>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderContainerStyle)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_container_style(&self, value: &super::Style) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderContainerStyle)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGroupStyleFactory, 1459578447, 58071, 20297, 128, 61, 199, 39, 205, 249, 55, 45);
RT_INTERFACE!{interface IGroupStyleFactory(IGroupStyleFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGroupStyleFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut GroupStyle) -> HRESULT
}}
impl IGroupStyleFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<GroupStyle>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGroupStyleSelector, 1843007902, 39540, 18319, 163, 57, 91, 181, 45, 230, 197, 30);
RT_INTERFACE!{interface IGroupStyleSelector(IGroupStyleSelectorVtbl): IInspectable(IInspectableVtbl) [IID_IGroupStyleSelector] {
    fn SelectGroupStyle(&self, group: *mut IInspectable, level: u32, out: *mut *mut GroupStyle) -> HRESULT
}}
impl IGroupStyleSelector {
    #[inline] pub unsafe fn select_group_style(&self, group: &IInspectable, level: u32) -> Result<ComPtr<GroupStyle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SelectGroupStyle)(self as *const _ as *mut _, group as *const _ as *mut _, level, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class GroupStyleSelector: IGroupStyleSelector}
DEFINE_IID!(IID_IGroupStyleSelectorFactory, 3210153267, 45814, 18463, 164, 80, 200, 12, 41, 31, 178, 45);
RT_INTERFACE!{interface IGroupStyleSelectorFactory(IGroupStyleSelectorFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IGroupStyleSelectorFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut GroupStyleSelector) -> HRESULT
}}
impl IGroupStyleSelectorFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<GroupStyleSelector>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IGroupStyleSelectorOverrides, 4136749746, 30637, 19773, 165, 28, 142, 249, 195, 131, 100, 86);
RT_INTERFACE!{interface IGroupStyleSelectorOverrides(IGroupStyleSelectorOverridesVtbl): IInspectable(IInspectableVtbl) [IID_IGroupStyleSelectorOverrides] {
    fn SelectGroupStyleCore(&self, group: *mut IInspectable, level: u32, out: *mut *mut GroupStyle) -> HRESULT
}}
impl IGroupStyleSelectorOverrides {
    #[inline] pub unsafe fn select_group_style_core(&self, group: &IInspectable, level: u32) -> Result<ComPtr<GroupStyle>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).SelectGroupStyleCore)(self as *const _ as *mut _, group as *const _ as *mut _, level, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHub, 2926128770, 29460, 20305, 171, 17, 42, 241, 237, 74, 25, 248);
RT_INTERFACE!{interface IHub(IHubVtbl): IInspectable(IInspectableVtbl) [IID_IHub] {
    fn get_Header(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Header(&self, value: *mut IInspectable) -> HRESULT,
    fn get_HeaderTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_HeaderTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_Orientation(&self, out: *mut Orientation) -> HRESULT,
    fn put_Orientation(&self, value: Orientation) -> HRESULT,
    fn get_DefaultSectionIndex(&self, out: *mut i32) -> HRESULT,
    fn put_DefaultSectionIndex(&self, value: i32) -> HRESULT,
    fn get_Sections(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<HubSection>) -> HRESULT,
    fn get_SectionsInView(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IVector<HubSection>) -> HRESULT,
    fn get_SectionHeaders(&self, out: *mut *mut ::rt::gen::windows::foundation::collections::IObservableVector<IInspectable>) -> HRESULT,
    fn add_SectionHeaderClick(&self, value: *mut HubSectionHeaderClickEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SectionHeaderClick(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_SectionsInViewChanged(&self, value: *mut SectionsInViewChangedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_SectionsInViewChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn ScrollToSection(&self, section: *mut HubSection) -> HRESULT
}}
impl IHub {
    #[inline] pub unsafe fn get_header(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Header)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation(&self) -> Result<Orientation> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Orientation)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_orientation(&self, value: Orientation) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Orientation)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_section_index(&self) -> Result<i32> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_DefaultSectionIndex)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_default_section_index(&self, value: i32) -> Result<()> {
        let hr = ((*self.lpVtbl).put_DefaultSectionIndex)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sections(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<HubSection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Sections)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_sections_in_view(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IVector<HubSection>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SectionsInView)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_section_headers(&self) -> Result<ComPtr<::rt::gen::windows::foundation::collections::IObservableVector<IInspectable>>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SectionHeaders)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_section_header_click(&self, value: &HubSectionHeaderClickEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SectionHeaderClick)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_section_header_click(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SectionHeaderClick)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_sections_in_view_changed(&self, value: &SectionsInViewChangedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_SectionsInViewChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_sections_in_view_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_SectionsInViewChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn scroll_to_section(&self, section: &HubSection) -> Result<()> {
        let hr = ((*self.lpVtbl).ScrollToSection)(self as *const _ as *mut _, section as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Hub: IHub}
impl RtActivatable<IHubStatics> for Hub {}
impl Hub {
    #[inline] pub fn get_header_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_header_property()
    }}
    #[inline] pub fn get_header_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_header_template_property()
    }}
    #[inline] pub fn get_orientation_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_orientation_property()
    }}
    #[inline] pub fn get_default_section_index_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_default_section_index_property()
    }}
    #[inline] pub fn get_semantic_zoom_owner_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_semantic_zoom_owner_property()
    }}
    #[inline] pub fn get_is_active_view_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_is_active_view_property()
    }}
    #[inline] pub fn get_is_zoomed_in_view_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubStatics>>::get_activation_factory().get_is_zoomed_in_view_property()
    }}
}
DEFINE_CLSID!(Hub(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,72,117,98,0]) [CLSID_Hub]);
DEFINE_IID!(IID_IHubFactory, 3701912250, 50933, 18785, 153, 83, 197, 24, 115, 219, 84, 36);
RT_INTERFACE!{interface IHubFactory(IHubFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IHubFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut Hub) -> HRESULT
}}
impl IHubFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<Hub>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHubSection, 2766564535, 32733, 20448, 171, 73, 194, 70, 99, 157, 204, 249);
RT_INTERFACE!{interface IHubSection(IHubSectionVtbl): IInspectable(IInspectableVtbl) [IID_IHubSection] {
    fn get_Header(&self, out: *mut *mut IInspectable) -> HRESULT,
    fn put_Header(&self, value: *mut IInspectable) -> HRESULT,
    fn get_HeaderTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_HeaderTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_ContentTemplate(&self, out: *mut *mut super::DataTemplate) -> HRESULT,
    fn put_ContentTemplate(&self, value: *mut super::DataTemplate) -> HRESULT,
    fn get_IsHeaderInteractive(&self, out: *mut bool) -> HRESULT,
    fn put_IsHeaderInteractive(&self, value: bool) -> HRESULT
}}
impl IHubSection {
    #[inline] pub unsafe fn get_header(&self) -> Result<ComPtr<IInspectable>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Header)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header(&self, value: &IInspectable) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Header)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_header_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_HeaderTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template(&self) -> Result<ComPtr<super::DataTemplate>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplate)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_content_template(&self, value: &super::DataTemplate) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ContentTemplate)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_header_interactive(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsHeaderInteractive)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_header_interactive(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsHeaderInteractive)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class HubSection: IHubSection}
impl RtActivatable<IHubSectionStatics> for HubSection {}
impl HubSection {
    #[inline] pub fn get_header_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubSectionStatics>>::get_activation_factory().get_header_property()
    }}
    #[inline] pub fn get_header_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubSectionStatics>>::get_activation_factory().get_header_template_property()
    }}
    #[inline] pub fn get_content_template_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubSectionStatics>>::get_activation_factory().get_content_template_property()
    }}
    #[inline] pub fn get_is_header_interactive_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHubSectionStatics>>::get_activation_factory().get_is_header_interactive_property()
    }}
}
DEFINE_CLSID!(HubSection(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,72,117,98,83,101,99,116,105,111,110,0]) [CLSID_HubSection]);
RT_CLASS!{class HubSectionCollection: ::rt::gen::windows::foundation::collections::IVector<HubSection>}
DEFINE_IID!(IID_IHubSectionFactory, 4294270882, 60644, 19386, 170, 59, 152, 4, 174, 244, 120, 131);
RT_INTERFACE!{interface IHubSectionFactory(IHubSectionFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IHubSectionFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut HubSection) -> HRESULT
}}
impl IHubSectionFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<HubSection>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHubSectionHeaderClickEventArgs, 3787845380, 7901, 16658, 174, 235, 153, 108, 150, 64, 6, 152);
RT_INTERFACE!{interface IHubSectionHeaderClickEventArgs(IHubSectionHeaderClickEventArgsVtbl): IInspectable(IInspectableVtbl) [IID_IHubSectionHeaderClickEventArgs] {
    fn get_Section(&self, out: *mut *mut HubSection) -> HRESULT
}}
impl IHubSectionHeaderClickEventArgs {
    #[inline] pub unsafe fn get_section(&self) -> Result<ComPtr<HubSection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Section)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class HubSectionHeaderClickEventArgs: IHubSectionHeaderClickEventArgs}
impl RtActivatable<IActivationFactory> for HubSectionHeaderClickEventArgs {}
DEFINE_CLSID!(HubSectionHeaderClickEventArgs(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,72,117,98,83,101,99,116,105,111,110,72,101,97,100,101,114,67,108,105,99,107,69,118,101,110,116,65,114,103,115,0]) [CLSID_HubSectionHeaderClickEventArgs]);
DEFINE_IID!(IID_HubSectionHeaderClickEventHandler, 2950790043, 40035, 17795, 136, 228, 197, 144, 25, 183, 244, 157);
RT_DELEGATE!{delegate HubSectionHeaderClickEventHandler(HubSectionHeaderClickEventHandlerVtbl, HubSectionHeaderClickEventHandlerImpl) [IID_HubSectionHeaderClickEventHandler] {
    fn Invoke(&self, sender: *mut IInspectable, e: *mut HubSectionHeaderClickEventArgs) -> HRESULT
}}
impl HubSectionHeaderClickEventHandler {
    #[inline] pub unsafe fn invoke(&self, sender: &IInspectable, e: &HubSectionHeaderClickEventArgs) -> Result<()> {
        let hr = ((*self.lpVtbl).Invoke)(self as *const _ as *mut _, sender as *const _ as *mut _, e as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHubSectionStatics, 315807834, 59943, 17105, 153, 139, 97, 229, 42, 237, 132, 43);
RT_INTERFACE!{static interface IHubSectionStatics(IHubSectionStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IHubSectionStatics] {
    fn get_HeaderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_ContentTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsHeaderInteractiveProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IHubSectionStatics {
    #[inline] pub unsafe fn get_header_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_content_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ContentTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_header_interactive_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsHeaderInteractiveProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHubStatics, 242196532, 44348, 20274, 183, 1, 226, 79, 171, 86, 32, 40);
RT_INTERFACE!{static interface IHubStatics(IHubStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IHubStatics] {
    fn get_HeaderProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_HeaderTemplateProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_OrientationProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_DefaultSectionIndexProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_SemanticZoomOwnerProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsActiveViewProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_IsZoomedInViewProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IHubStatics {
    #[inline] pub unsafe fn get_header_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_header_template_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_HeaderTemplateProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_orientation_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_OrientationProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_default_section_index_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_DefaultSectionIndexProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_semantic_zoom_owner_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SemanticZoomOwnerProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_active_view_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsActiveViewProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_zoomed_in_view_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_IsZoomedInViewProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHyperlinkButton, 3437997219, 15196, 20300, 155, 253, 134, 136, 123, 199, 151, 114);
RT_INTERFACE!{interface IHyperlinkButton(IHyperlinkButtonVtbl): IInspectable(IInspectableVtbl) [IID_IHyperlinkButton] {
    fn get_NavigateUri(&self, out: *mut *mut ::rt::gen::windows::foundation::Uri) -> HRESULT,
    fn put_NavigateUri(&self, value: *mut ::rt::gen::windows::foundation::Uri) -> HRESULT
}}
impl IHyperlinkButton {
    #[inline] pub unsafe fn get_navigate_uri(&self) -> Result<ComPtr<::rt::gen::windows::foundation::Uri>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NavigateUri)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_navigate_uri(&self, value: &::rt::gen::windows::foundation::Uri) -> Result<()> {
        let hr = ((*self.lpVtbl).put_NavigateUri)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class HyperlinkButton: IHyperlinkButton}
impl RtActivatable<IHyperlinkButtonStatics> for HyperlinkButton {}
impl HyperlinkButton {
    #[inline] pub fn get_navigate_uri_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IHyperlinkButtonStatics>>::get_activation_factory().get_navigate_uri_property()
    }}
}
DEFINE_CLSID!(HyperlinkButton(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,72,121,112,101,114,108,105,110,107,66,117,116,116,111,110,0]) [CLSID_HyperlinkButton]);
DEFINE_IID!(IID_IHyperlinkButtonFactory, 1129454509, 20119, 19881, 166, 77, 147, 93, 253, 140, 237, 242);
RT_INTERFACE!{interface IHyperlinkButtonFactory(IHyperlinkButtonFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IHyperlinkButtonFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut HyperlinkButton) -> HRESULT
}}
impl IHyperlinkButtonFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<HyperlinkButton>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IHyperlinkButtonStatics, 4222531015, 52663, 16995, 183, 214, 60, 13, 41, 4, 237, 152);
RT_INTERFACE!{static interface IHyperlinkButtonStatics(IHyperlinkButtonStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IHyperlinkButtonStatics] {
    fn get_NavigateUriProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IHyperlinkButtonStatics {
    #[inline] pub unsafe fn get_navigate_uri_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NavigateUriProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IIconElement, 2599452731, 53324, 18042, 187, 213, 155, 129, 240, 45, 154, 86);
RT_INTERFACE!{interface IIconElement(IIconElementVtbl): IInspectable(IInspectableVtbl) [IID_IIconElement] {
    fn get_Foreground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Foreground(&self, value: *mut super::media::Brush) -> HRESULT
}}
impl IIconElement {
    #[inline] pub unsafe fn get_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Foreground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Foreground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class IconElement: IIconElement}
impl RtActivatable<IIconElementStatics> for IconElement {}
impl IconElement {
    #[inline] pub fn get_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IIconElementStatics>>::get_activation_factory().get_foreground_property()
    }}
}
DEFINE_CLSID!(IconElement(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,73,99,111,110,69,108,101,109,101,110,116,0]) [CLSID_IconElement]);
DEFINE_IID!(IID_IIconElementFactory, 3476530530, 1060, 17351, 139, 234, 114, 15, 186, 151, 62, 241);
RT_INTERFACE!{interface IIconElementFactory(IIconElementFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IIconElementFactory] {
    
}}
DEFINE_IID!(IID_IIconElementStatics, 3189351971, 30671, 18223, 130, 234, 4, 120, 1, 209, 32, 18);
RT_INTERFACE!{static interface IIconElementStatics(IIconElementStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IIconElementStatics] {
    fn get_ForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IIconElementStatics {
    #[inline] pub unsafe fn get_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IIconSource, 2464976213, 17899, 18340, 134, 60, 145, 178, 36, 4, 79, 155);
RT_INTERFACE!{interface IIconSource(IIconSourceVtbl): IInspectable(IInspectableVtbl) [IID_IIconSource] {
    fn get_Foreground(&self, out: *mut *mut super::media::Brush) -> HRESULT,
    fn put_Foreground(&self, value: *mut super::media::Brush) -> HRESULT
}}
impl IIconSource {
    #[inline] pub unsafe fn get_foreground(&self) -> Result<ComPtr<super::media::Brush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Foreground)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_foreground(&self, value: &super::media::Brush) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Foreground)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class IconSource: IIconSource}
impl RtActivatable<IIconSourceStatics> for IconSource {}
impl IconSource {
    #[inline] pub fn get_foreground_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IIconSourceStatics>>::get_activation_factory().get_foreground_property()
    }}
}
DEFINE_CLSID!(IconSource(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,73,99,111,110,83,111,117,114,99,101,0]) [CLSID_IconSource]);
DEFINE_IID!(IID_IIconSourceFactory, 1292991729, 8150, 18903, 180, 131, 2, 236, 61, 233, 151, 214);
RT_INTERFACE!{interface IIconSourceFactory(IIconSourceFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IIconSourceFactory] {
    
}}
DEFINE_IID!(IID_IIconSourceStatics, 490249662, 7379, 20303, 131, 176, 85, 220, 99, 135, 104, 91);
RT_INTERFACE!{static interface IIconSourceStatics(IIconSourceStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IIconSourceStatics] {
    fn get_ForegroundProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IIconSourceStatics {
    #[inline] pub unsafe fn get_foreground_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ForegroundProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IImage, 1230730242, 39667, 20048, 170, 144, 3, 56, 143, 48, 134, 210);
RT_INTERFACE!{interface IImage(IImageVtbl): IInspectable(IInspectableVtbl) [IID_IImage] {
    fn get_Source(&self, out: *mut *mut super::media::ImageSource) -> HRESULT,
    fn put_Source(&self, value: *mut super::media::ImageSource) -> HRESULT,
    fn get_Stretch(&self, out: *mut super::media::Stretch) -> HRESULT,
    fn put_Stretch(&self, value: super::media::Stretch) -> HRESULT,
    fn get_NineGrid(&self, out: *mut super::Thickness) -> HRESULT,
    fn put_NineGrid(&self, value: super::Thickness) -> HRESULT,
    #[cfg(not(feature="windows-media"))] fn __Dummy6(&self) -> (),
    #[cfg(feature="windows-media")] fn get_PlayToSource(&self, out: *mut *mut ::rt::gen::windows::media::playto::PlayToSource) -> HRESULT,
    fn add_ImageFailed(&self, value: *mut super::ExceptionRoutedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ImageFailed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_ImageOpened(&self, value: *mut super::RoutedEventHandler, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ImageOpened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT
}}
impl IImage {
    #[inline] pub unsafe fn get_source(&self) -> Result<ComPtr<super::media::ImageSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Source)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_source(&self, value: &super::media::ImageSource) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Source)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stretch(&self) -> Result<super::media::Stretch> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_Stretch)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_stretch(&self, value: super::media::Stretch) -> Result<()> {
        let hr = ((*self.lpVtbl).put_Stretch)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_nine_grid(&self) -> Result<super::Thickness> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_NineGrid)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_nine_grid(&self, value: super::Thickness) -> Result<()> {
        let hr = ((*self.lpVtbl).put_NineGrid)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-media")] #[inline] pub unsafe fn get_play_to_source(&self) -> Result<ComPtr<::rt::gen::windows::media::playto::PlayToSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlayToSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_image_failed(&self, value: &super::ExceptionRoutedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ImageFailed)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_image_failed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ImageFailed)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_image_opened(&self, value: &super::RoutedEventHandler) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ImageOpened)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_image_opened(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ImageOpened)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
}
RT_CLASS!{class Image: IImage}
impl RtActivatable<IImageStatics> for Image {}
impl RtActivatable<IActivationFactory> for Image {}
impl Image {
    #[inline] pub fn get_source_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IImageStatics>>::get_activation_factory().get_source_property()
    }}
    #[inline] pub fn get_stretch_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IImageStatics>>::get_activation_factory().get_stretch_property()
    }}
    #[inline] pub fn get_nine_grid_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IImageStatics>>::get_activation_factory().get_nine_grid_property()
    }}
    #[inline] pub fn get_play_to_source_property() -> Result<ComPtr<super::DependencyProperty>> { unsafe {
        <Self as RtActivatable<IImageStatics>>::get_activation_factory().get_play_to_source_property()
    }}
}
DEFINE_CLSID!(Image(&[87,105,110,100,111,119,115,46,85,73,46,88,97,109,108,46,67,111,110,116,114,111,108,115,46,73,109,97,103,101,0]) [CLSID_Image]);
DEFINE_IID!(IID_IImage2, 4098167198, 34847, 18619, 135, 58, 100, 65, 124, 164, 240, 2);
RT_INTERFACE!{interface IImage2(IImage2Vtbl): IInspectable(IInspectableVtbl) [IID_IImage2] {
    #[cfg(feature="windows-media")] fn GetAsCastingSource(&self, out: *mut *mut ::rt::gen::windows::media::casting::CastingSource) -> HRESULT
}}
impl IImage2 {
    #[cfg(feature="windows-media")] #[inline] pub unsafe fn get_as_casting_source(&self) -> Result<ComPtr<::rt::gen::windows::media::casting::CastingSource>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAsCastingSource)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IImage3, 116123538, 18370, 19858, 164, 136, 140, 214, 133, 208, 106, 202);
RT_INTERFACE!{interface IImage3(IImage3Vtbl): IInspectable(IInspectableVtbl) [IID_IImage3] {
    #[cfg(feature="windows-ui")] fn GetAlphaMask(&self, out: *mut *mut super::super::composition::CompositionBrush) -> HRESULT
}}
impl IImage3 {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_alpha_mask(&self) -> Result<ComPtr<super::super::composition::CompositionBrush>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).GetAlphaMask)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IImageStatics, 2307929970, 49974, 17361, 157, 81, 195, 187, 213, 213, 214, 145);
RT_INTERFACE!{static interface IImageStatics(IImageStaticsVtbl): IInspectable(IInspectableVtbl) [IID_IImageStatics] {
    fn get_SourceProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_StretchProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_NineGridProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT,
    fn get_PlayToSourceProperty(&self, out: *mut *mut super::DependencyProperty) -> HRESULT
}}
impl IImageStatics {
    #[inline] pub unsafe fn get_source_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_SourceProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_stretch_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_StretchProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_nine_grid_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_NineGridProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_play_to_source_property(&self) -> Result<ComPtr<super::DependencyProperty>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_PlayToSourceProperty)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_ENUM! { enum IncrementalLoadingTrigger: i32 {
    None (IncrementalLoadingTrigger_None) = 0, Edge (IncrementalLoadingTrigger_Edge) = 1,
}}
DEFINE_IID!(IID_IInkCanvas, 692337704, 36424, 20424, 164, 115, 53, 176, 186, 18, 172, 234);
RT_INTERFACE!{interface IInkCanvas(IInkCanvasVtbl): IInspectable(IInspectableVtbl) [IID_IInkCanvas] {
    #[cfg(feature="windows-ui")] fn get_InkPresenter(&self, out: *mut *mut super::super::input::inking::InkPresenter) -> HRESULT
}}
impl IInkCanvas {
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_ink_presenter(&self) -> Result<ComPtr<super::super::input::inking::InkPresenter>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkPresenter)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
}
RT_CLASS!{class InkCanvas: IInkCanvas}
DEFINE_IID!(IID_IInkCanvasFactory, 2454373086, 43780, 18672, 150, 83, 224, 242, 218, 77, 191, 26);
RT_INTERFACE!{interface IInkCanvasFactory(IInkCanvasFactoryVtbl): IInspectable(IInspectableVtbl) [IID_IInkCanvasFactory] {
    fn CreateInstance(&self, outer: *mut IInspectable, inner: *mut *mut IInspectable, out: *mut *mut InkCanvas) -> HRESULT
}}
impl IInkCanvasFactory {
    #[inline] pub unsafe fn create_instance(&self, outer: &IInspectable) -> Result<(ComPtr<IInspectable>, ComPtr<InkCanvas>)> {
        let mut inner = null_mut(); let mut out = null_mut();
        let hr = ((*self.lpVtbl).CreateInstance)(self as *const _ as *mut _, outer as *const _ as *mut _, &mut inner, &mut out);
        if hr == S_OK { Ok((ComPtr::wrap(inner), ComPtr::wrap(out))) } else { err(hr) }
    }
}
DEFINE_IID!(IID_IInkToolbar, 1037896906, 20976, 18543, 160, 62, 78, 225, 61, 193, 43, 203);
RT_INTERFACE!{interface IInkToolbar(IInkToolbarVtbl): IInspectable(IInspectableVtbl) [IID_IInkToolbar] {
    fn get_InitialControls(&self, out: *mut InkToolbarInitialControls) -> HRESULT,
    fn put_InitialControls(&self, value: InkToolbarInitialControls) -> HRESULT,
    fn get_Children(&self, out: *mut *mut super::DependencyObjectCollection) -> HRESULT,
    fn get_ActiveTool(&self, out: *mut *mut InkToolbarToolButton) -> HRESULT,
    fn put_ActiveTool(&self, value: *mut InkToolbarToolButton) -> HRESULT,
    #[cfg(not(feature="windows-ui"))] fn __Dummy5(&self) -> (),
    #[cfg(feature="windows-ui")] fn get_InkDrawingAttributes(&self, out: *mut *mut super::super::input::inking::InkDrawingAttributes) -> HRESULT,
    fn get_IsRulerButtonChecked(&self, out: *mut bool) -> HRESULT,
    fn put_IsRulerButtonChecked(&self, value: bool) -> HRESULT,
    fn get_TargetInkCanvas(&self, out: *mut *mut InkCanvas) -> HRESULT,
    fn put_TargetInkCanvas(&self, value: *mut InkCanvas) -> HRESULT,
    fn add_ActiveToolChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkToolbar, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_ActiveToolChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_InkDrawingAttributesChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkToolbar, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_InkDrawingAttributesChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_EraseAllClicked(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkToolbar, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_EraseAllClicked(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn add_IsRulerButtonCheckedChanged(&self, value: *mut ::rt::gen::windows::foundation::TypedEventHandler<InkToolbar, IInspectable>, out: *mut ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn remove_IsRulerButtonCheckedChanged(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> HRESULT,
    fn GetToolButton(&self, tool: InkToolbarTool, out: *mut *mut InkToolbarToolButton) -> HRESULT,
    fn GetToggleButton(&self, tool: InkToolbarToggle, out: *mut *mut InkToolbarToggleButton) -> HRESULT
}}
impl IInkToolbar {
    #[inline] pub unsafe fn get_initial_controls(&self) -> Result<InkToolbarInitialControls> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_InitialControls)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_initial_controls(&self, value: InkToolbarInitialControls) -> Result<()> {
        let hr = ((*self.lpVtbl).put_InitialControls)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_children(&self) -> Result<ComPtr<super::DependencyObjectCollection>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_Children)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_active_tool(&self) -> Result<ComPtr<InkToolbarToolButton>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_ActiveTool)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_active_tool(&self, value: &InkToolbarToolButton) -> Result<()> {
        let hr = ((*self.lpVtbl).put_ActiveTool)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[cfg(feature="windows-ui")] #[inline] pub unsafe fn get_ink_drawing_attributes(&self) -> Result<ComPtr<super::super::input::inking::InkDrawingAttributes>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_InkDrawingAttributes)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_is_ruler_button_checked(&self) -> Result<bool> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).get_IsRulerButtonChecked)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_is_ruler_button_checked(&self, value: bool) -> Result<()> {
        let hr = ((*self.lpVtbl).put_IsRulerButtonChecked)(self as *const _ as *mut _, value);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn get_target_ink_canvas(&self) -> Result<ComPtr<InkCanvas>> {
        let mut out = null_mut();
        let hr = ((*self.lpVtbl).get_TargetInkCanvas)(self as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(ComPtr::wrap(out)) } else { err(hr) }
    }
    #[inline] pub unsafe fn set_target_ink_canvas(&self, value: &InkCanvas) -> Result<()> {
        let hr = ((*self.lpVtbl).put_TargetInkCanvas)(self as *const _ as *mut _, value as *const _ as *mut _);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_active_tool_changed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<InkToolbar, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_ActiveToolChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } else { err(hr) }
    }
    #[inline] pub unsafe fn remove_active_tool_changed(&self, token: ::rt::gen::windows::foundation::EventRegistrationToken) -> Result<()> {
        let hr = ((*self.lpVtbl).remove_ActiveToolChanged)(self as *const _ as *mut _, token);
        if hr == S_OK { Ok(()) } else { err(hr) }
    }
    #[inline] pub unsafe fn add_ink_drawing_attributes_changed(&self, value: &::rt::gen::windows::foundation::TypedEventHandler<InkToolbar, IInspectable>) -> Result<::rt::gen::windows::foundation::EventRegistrationToken> {
        let mut out = zeroed();
        let hr = ((*self.lpVtbl).add_InkDrawingAttributesChanged)(self as *const _ as *mut _, value as *const _ as *mut _, &mut out);
        if hr == S_OK { Ok(out) } 