/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.profile.commands;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.lang.Tuple;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.AntBuilder;
import io.micronaut.cli.MicronautCli;
import io.micronaut.cli.console.logging.ConsoleAntBuilder;
import io.micronaut.cli.console.logging.MicronautConsole;
import io.micronaut.cli.io.IOUtils;
import io.micronaut.cli.io.support.BuildTokens;
import io.micronaut.cli.io.support.FileSystemResource;
import io.micronaut.cli.io.support.GradleBuildTokens;
import io.micronaut.cli.io.support.MavenBuildTokens;
import io.micronaut.cli.io.support.Resource;
import io.micronaut.cli.io.support.XmlMerger;
import io.micronaut.cli.profile.Feature;
import io.micronaut.cli.profile.OneOfFeatureGroup;
import io.micronaut.cli.profile.Profile;
import io.micronaut.cli.profile.ProfileRepository;
import io.micronaut.cli.profile.ProfileRepositoryAware;
import io.micronaut.cli.profile.ResetableCommand;
import io.micronaut.cli.profile.commands.AbstractCreateAppCommand;
import io.micronaut.cli.profile.commands.ArgumentCompletingCommand;
import io.micronaut.cli.profile.commands.CommonOptionsMixin;
import io.micronaut.cli.profile.commands.ProfileCompletionCandidates;
import io.micronaut.cli.profile.commands.SupportedBuildTool;
import io.micronaut.cli.profile.commands.SupportedLanguage;
import io.micronaut.cli.util.NameUtils;
import io.micronaut.cli.util.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import picocli.CommandLine;

@CommandLine.Command
public abstract class AbstractCreateCommand
extends ArgumentCompletingCommand
implements ProfileRepositoryAware,
ResetableCommand {
    public static final String ENCODING;
    protected static final String APPLICATION_YML = "application.yml";
    protected static final String BUILD_GRADLE = "build.gradle";
    protected static final String POM_XML = "pom.xml";
    private ProfileRepository profileRepository;
    private Map<String, String> variables;
    @CommandLine.Option(names={"-i", "--inplace"}, description={"Create a service using the current directory"})
    private boolean inplace;
    @CommandLine.Option(completionCandidates=ProfileCompletionCandidates.class, paramLabel="PROFILE", names={"-p", "--profile"}, description={"The profile to use. Possible values: ${COMPLETION-CANDIDATES}."})
    private String profile;
    @CommandLine.Option(split=",", completionCandidates=FeatureCompletionCandidates.class, paramLabel="FEATURE", names={"-f", "--features"}, description={"The features to use. Possible values: ${COMPLETION-CANDIDATES}"})
    private List<String> features;
    @CommandLine.Mixin
    private CommonOptionsMixin autoHelp;
    private Map<URL, File> unzippedDirectories;
    private String appname;
    private String groupname;
    private String defaultpackagename;
    private File targetDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AbstractCreateCommand() {
        MetaClass metaClass;
        List list;
        Map map;
        this.variables = map = ScriptBytecodeAdapter.createMap(new Object[0]);
        this.features = list = ScriptBytecodeAdapter.createList(new Object[0]);
        LinkedHashMap<URL, File> linkedHashMap = new LinkedHashMap<URL, File>();
        this.unzippedDirectories = linkedHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public abstract String getName();

    @Override
    @CommandLine.Spec
    public void setCommandSpec(CommandLine.Model.CommandSpec commandSpec) {
        super.setCommandSpec(commandSpec);
        ProfileCompletionCandidates.updateCommandArguments(commandSpec, this.profileRepository);
        FeatureCompletionCandidates.initCommandArgs(this);
    }

    @Override
    public void setProfileRepository(ProfileRepository profileRepository) {
        ProfileRepository profileRepository2;
        this.profileRepository = profileRepository2 = profileRepository;
    }

    protected File getDestinationDirectory(File srcFile) {
        String searchDir = "skeleton";
        File srcDir = srcFile.getParentFile();
        File destDir = null;
        if (srcDir.getAbsolutePath().endsWith(searchDir)) {
            File file;
            destDir = file = this.targetDirectory;
        } else {
            File file;
            int index = srcDir.getAbsolutePath().lastIndexOf(searchDir) + StringGroovyMethods.size(searchDir) + 1;
            String relativePath = StringGroovyMethods.minus((CharSequence)srcDir.getAbsolutePath(), (Object)srcDir.getAbsolutePath().substring(0, index));
            if (relativePath.startsWith("gradle-build")) {
                String string;
                relativePath = string = relativePath.substring(StringGroovyMethods.size("gradle-build"));
            }
            if (relativePath.startsWith("maven-build")) {
                String string;
                relativePath = string = relativePath.substring(StringGroovyMethods.size("maven-build"));
            }
            destDir = file = new File(this.targetDirectory, relativePath);
        }
        return destDir;
    }

    protected void appendFeatureFiles(File skeletonDir, String build) {
        Set<File> ymlFiles = this.findAllFilesByName(skeletonDir, APPLICATION_YML);
        public final class _appendFeatureFiles_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _appendFeatureFiles_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File newYml) {
                File oldYml = new File((File)ScriptBytecodeAdapter.castToType(InvokerHelper.invokeMethodSafe((AbstractCreateCommand)this.getThisObject(), "getDestinationDirectory", new Object[]{newYml}), File.class), APPLICATION_YML);
                String oldText = ShortTypeHandling.castToString(oldYml.isFile() ? ResourceGroovyMethods.getText(oldYml, ENCODING) : null);
                if (DefaultTypeTransformation.booleanUnbox(oldText)) {
                    ((AbstractCreateCommand)ScriptBytecodeAdapter.castToType(this.getThisObject(), AbstractCreateCommand.class)).appendToYmlSubDocument(newYml, oldText, oldYml);
                    return null;
                }
                String string = ResourceGroovyMethods.getText(newYml, ENCODING);
                ScriptBytecodeAdapter.setProperty(string, null, oldYml, "text");
                return string;
            }

            public Object call(File newYml) {
                return this.doCall(newYml);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _appendFeatureFiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ymlFiles, (Closure)new _appendFeatureFiles_closure1(this, this));
        this.copyBuildFiles(new File(skeletonDir, StringGroovyMethods.plus(build, (CharSequence)"-build")), build, true);
    }

    protected void copyBuildFiles(File skeletonDir, String build, boolean allowMerge) {
        Reference<Boolean> allowMerge2 = new Reference<Boolean>(allowMerge);
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        Reference<AntBuilder> ant = new Reference<AntBuilder>((AntBuilder)ScriptBytecodeAdapter.castToType(callSiteArray[0].callConstructor(ConsoleAntBuilder.class), AntBuilder.class));
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[1].call(skeletonDir))) {
            return;
        }
        if (ScriptBytecodeAdapter.compareEqual(build, "gradle")) {
            Set sourceBuildGradles = (Set)ScriptBytecodeAdapter.castToType(callSiteArray[2].callCurrent(this, skeletonDir, BUILD_GRADLE), Set.class);
            public final class _copyBuildFiles_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference ant;
                private /* synthetic */ Reference allowMerge;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _copyBuildFiles_closure2(Object _outerInstance, Object _thisObject, Reference ant, Reference allowMerge) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _copyBuildFiles_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.ant = reference2 = ant;
                    this.allowMerge = reference = allowMerge;
                }

                public Object doCall(File srcFile) {
                    Reference<File> srcFile2 = new Reference<File>(srcFile);
                    CallSite[] callSiteArray = _copyBuildFiles_closure2.$getCallSiteArray();
                    File srcDir = (File)ScriptBytecodeAdapter.castToType(callSiteArray[0].callGetProperty(srcFile2.get()), File.class);
                    File destDir = (File)ScriptBytecodeAdapter.castToType(callSiteArray[1].callCurrent((GroovyObject)this, srcFile2.get()), File.class);
                    File destFile = (File)ScriptBytecodeAdapter.castToType(callSiteArray[2].callConstructor(File.class, destDir, callSiteArray[3].callGetProperty(AbstractCreateCommand.class)), File.class);
                    callSiteArray[4].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", new GStringImpl(new Object[]{srcDir}, new String[]{"", "/.gitignore"}), "todir", destDir, "failonerror", false}));
                    if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[5].call(destFile))) {
                        return callSiteArray[6].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", srcFile2.get(), "tofile", destFile}));
                    }
                    if (DefaultTypeTransformation.booleanUnbox(this.allowMerge.get())) {
                        Reference<GStringImpl> concatFile = new Reference<GStringImpl>(new GStringImpl(new Object[]{destDir}, new String[]{"", "/concat.gradle"}));
                        callSiteArray[7].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", destFile, "tofile", concatFile.get()}));
                        public final class _closure23
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference concatFile;
                            private /* synthetic */ Reference srcFile;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure23(Object _outerInstance, Object _thisObject, Reference concatFile, Reference srcFile) {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.concatFile = reference2 = concatFile;
                                this.srcFile = reference = srcFile;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                                public final class _closure24
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference concatFile;
                                    private /* synthetic */ Reference srcFile;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure24(Object _outerInstance, Object _thisObject, Reference concatFile, Reference srcFile) {
                                        Reference reference;
                                        Reference reference2;
                                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                        this.concatFile = reference2 = concatFile;
                                        this.srcFile = reference = srcFile;
                                    }

                                    public Object doCall(Object it) {
                                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                                        callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"location", this.concatFile.get()}));
                                        return callSiteArray[1].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"location", this.srcFile.get()}));
                                    }

                                    public Object getConcatFile() {
                                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                                        return this.concatFile.get();
                                    }

                                    public File getSrcFile() {
                                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                                        return (File)ScriptBytecodeAdapter.castToType(this.srcFile.get(), File.class);
                                    }

                                    @Generated
                                    public Object doCall() {
                                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (this.getClass() != _closure24.class) {
                                            return ScriptBytecodeAdapter.initMetaClass(this);
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "pathelement";
                                        stringArray[1] = "pathelement";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[2];
                                        _closure24.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure24.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure24.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                return callSiteArray[0].callCurrent((GroovyObject)this, new _closure24(this, this.getThisObject(), this.concatFile, this.srcFile));
                            }

                            public Object getConcatFile() {
                                CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                                return this.concatFile.get();
                            }

                            public File getSrcFile() {
                                CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                                return (File)ScriptBytecodeAdapter.castToType(this.srcFile.get(), File.class);
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure23.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "path";
                                return new CallSiteArray(_closure23.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure23.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[8].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"destfile", destFile, "fixlastline", true}), new _closure23(this, this.getThisObject(), concatFile, srcFile2));
                        return callSiteArray[9].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", concatFile.get(), "failonerror", false}));
                    }
                    return null;
                }

                public Object call(File srcFile) {
                    Reference<File> srcFile2 = new Reference<File>(srcFile);
                    CallSite[] callSiteArray = _copyBuildFiles_closure2.$getCallSiteArray();
                    return callSiteArray[10].callCurrent((GroovyObject)this, srcFile2.get());
                }

                public AntBuilder getAnt() {
                    CallSite[] callSiteArray = _copyBuildFiles_closure2.$getCallSiteArray();
                    return (AntBuilder)ScriptBytecodeAdapter.castToType(this.ant.get(), AntBuilder.class);
                }

                public boolean getAllowMerge() {
                    CallSite[] callSiteArray = _copyBuildFiles_closure2.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox(this.allowMerge.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _copyBuildFiles_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "parentFile";
                    stringArray[1] = "getDestinationDirectory";
                    stringArray[2] = "<$constructor$>";
                    stringArray[3] = "BUILD_GRADLE";
                    stringArray[4] = "copy";
                    stringArray[5] = "exists";
                    stringArray[6] = "copy";
                    stringArray[7] = "move";
                    stringArray[8] = "concat";
                    stringArray[9] = "delete";
                    stringArray[10] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    _copyBuildFiles_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_copyBuildFiles_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _copyBuildFiles_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[3].call((Object)sourceBuildGradles, new _copyBuildFiles_closure2(this, this, ant, allowMerge2));
        }
        if (ScriptBytecodeAdapter.compareEqual(build, "maven")) {
            Set sourcePomXmls = (Set)ScriptBytecodeAdapter.castToType(callSiteArray[4].callCurrent(this, skeletonDir, POM_XML), Set.class);
            public final class _copyBuildFiles_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference ant;
                private /* synthetic */ Reference allowMerge;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _copyBuildFiles_closure3(Object _outerInstance, Object _thisObject, Reference ant, Reference allowMerge) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _copyBuildFiles_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.ant = reference2 = ant;
                    this.allowMerge = reference = allowMerge;
                }

                public Object doCall(File srcFile) {
                    CallSite[] callSiteArray = _copyBuildFiles_closure3.$getCallSiteArray();
                    File srcDir = (File)ScriptBytecodeAdapter.castToType(callSiteArray[0].callGetProperty(srcFile), File.class);
                    File destDir = (File)ScriptBytecodeAdapter.castToType(callSiteArray[1].callCurrent((GroovyObject)this, srcFile), File.class);
                    File destFile = (File)ScriptBytecodeAdapter.castToType(callSiteArray[2].callConstructor(File.class, destDir, callSiteArray[3].callGetProperty(AbstractCreateCommand.class)), File.class);
                    callSiteArray[4].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", new GStringImpl(new Object[]{srcDir}, new String[]{"", "/.gitignore"}), "todir", destDir, "failonerror", false}));
                    if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[5].call(destFile))) {
                        return callSiteArray[6].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", srcFile, "tofile", destFile}));
                    }
                    if (DefaultTypeTransformation.booleanUnbox(this.allowMerge.get())) {
                        return callSiteArray[7].call(this.ant.get(), ScriptBytecodeAdapter.createMap(new Object[]{"file", destFile, "message", callSiteArray[8].call(callSiteArray[9].callConstructor(XmlMerger.class), srcFile, destFile)}));
                    }
                    return null;
                }

                public Object call(File srcFile) {
                    CallSite[] callSiteArray = _copyBuildFiles_closure3.$getCallSiteArray();
                    return callSiteArray[10].callCurrent((GroovyObject)this, srcFile);
                }

                public AntBuilder getAnt() {
                    CallSite[] callSiteArray = _copyBuildFiles_closure3.$getCallSiteArray();
                    return (AntBuilder)ScriptBytecodeAdapter.castToType(this.ant.get(), AntBuilder.class);
                }

                public boolean getAllowMerge() {
                    CallSite[] callSiteArray = _copyBuildFiles_closure3.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox(this.allowMerge.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _copyBuildFiles_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "parentFile";
                    stringArray[1] = "getDestinationDirectory";
                    stringArray[2] = "<$constructor$>";
                    stringArray[3] = "POM_XML";
                    stringArray[4] = "copy";
                    stringArray[5] = "exists";
                    stringArray[6] = "copy";
                    stringArray[7] = "echo";
                    stringArray[8] = "merge";
                    stringArray[9] = "<$constructor$>";
                    stringArray[10] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    _copyBuildFiles_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_copyBuildFiles_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _copyBuildFiles_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[5].call((Object)sourcePomXmls, new _copyBuildFiles_closure3(this, this, ant, allowMerge2));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildTargetFolders(Profile profile, Map<Profile, File> targetDir, File projectDir) {
        void var3_3;
        void var2_2;
        Reference<Profile> profile2 = new Reference<Profile>(profile);
        Reference<void> targetDir2 = new Reference<void>(var2_2);
        Reference<void> projectDir2 = new Reference<void>(var3_3);
        if (!((Map)targetDir2.get()).containsKey(profile2.get())) {
            File file = (File)projectDir2.get();
            DefaultGroovyMethods.putAt((Map)targetDir2.get(), profile2.get(), file);
        }
        public final class _buildTargetFolders_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference profile;
            private /* synthetic */ Reference targetDir;
            private /* synthetic */ Reference projectDir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTargetFolders_closure4(Object _outerInstance, Object _thisObject, Reference profile, Reference targetDir, Reference projectDir) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.profile = reference3 = profile;
                this.targetDir = reference2 = targetDir;
                this.projectDir = reference = projectDir;
            }

            public Object doCall(Profile p) {
                if (DefaultTypeTransformation.booleanUnbox(((Profile)this.profile.get()).getParentSkeletonDir())) {
                    File file = ((Profile)this.profile.get()).getParentSkeletonDir((File)ScriptBytecodeAdapter.castToType(this.projectDir.get(), File.class));
                    DefaultGroovyMethods.putAt((Map)ScriptBytecodeAdapter.castToType(this.targetDir.get(), Map.class), p, file);
                } else {
                    Object v = DefaultGroovyMethods.getAt((Map)ScriptBytecodeAdapter.castToType(this.targetDir.get(), Map.class), this.profile.get());
                    DefaultGroovyMethods.putAt((Map)ScriptBytecodeAdapter.castToType(this.targetDir.get(), Map.class), p, v);
                }
                return InvokerHelper.invokeMethodSafe((AbstractCreateCommand)this.getThisObject(), "buildTargetFolders", new Object[]{p, this.targetDir.get(), this.projectDir.get()});
            }

            public Object call(Profile p) {
                return this.doCall(p);
            }

            public Profile getProfile() {
                return (Profile)ScriptBytecodeAdapter.castToType(this.profile.get(), Profile.class);
            }

            public Map getTargetDir() {
                return (Map)ScriptBytecodeAdapter.castToType(this.targetDir.get(), Map.class);
            }

            public File getProjectDir() {
                return (File)ScriptBytecodeAdapter.castToType(this.projectDir.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _buildTargetFolders_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(profile2.get().getExtends(), (Closure)new _buildTargetFolders_closure4(this, this, profile2, targetDir2, projectDir2));
    }

    public Set<File> findAllFilesByName(File projectDir, String fileName) {
        Reference<String> fileName2 = new Reference<String>(fileName);
        Reference<Set> files = new Reference<Set>((Set)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[0]), Set.class));
        if (projectDir.exists()) {
            Files.walkFileTree(projectDir.getAbsoluteFile().toPath(), (FileVisitor<? super Path>)((Object)new GroovyObject(this, fileName2, files){
                public /* synthetic */ Reference files;
                public /* synthetic */ Reference fileName;
                public /* synthetic */ AbstractCreateCommand this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    AbstractCreateCommand abstractCreateCommand;
                    this.this$0 = abstractCreateCommand = p0;
                    this.files = reference2 = p2;
                    this.fileName = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes mainAtts) throws IOException {
                    if (ScriptBytecodeAdapter.compareEqual(path.getFileName().toString(), this.fileName.get())) {
                        ((Set)this.files.get()).add(path.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$2(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$2(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty(object, null, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$2(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Override
                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Override
                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Override
                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Override
                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty(this, string);
                }

                @Override
                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty(this, string, object);
                }
            }));
        }
        return files.get();
    }

    public boolean handle(CreateServiceCommandObject cmd) {
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(this.profileRepository, null)) {
            throw (Throwable)callSiteArray[6].callConstructor(IllegalStateException.class, "Property 'profileRepository' must be set");
        }
        String profileName = ShortTypeHandling.castToString(callSiteArray[7].callGroovyObjectGetProperty(cmd));
        Profile profileInstance = (Profile)ScriptBytecodeAdapter.castToType(callSiteArray[8].call((Object)this.profileRepository, profileName), Profile.class);
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[9].callCurrent(this, profileInstance, profileName))) {
            return false;
        }
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[10].callCurrent((GroovyObject)this, callSiteArray[11].callGroovyObjectGetProperty(cmd)))) {
            return false;
        }
        public final class _handle_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _handle_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                return callSiteArray[0].call(SupportedLanguage.class, it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _handle_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "isValidValue";
                return new CallSiteArray(_handle_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _handle_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox(callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty(cmd), new _handle_closure5(this, this)))) {
            callSiteArray[14].call(callSiteArray[15].callGetProperty(MicronautConsole.class), "Language features cannot be used with the --features flag. Use --lang instead");
            return false;
        }
        List features = (List)ScriptBytecodeAdapter.castToType(callSiteArray[16].call(callSiteArray[17].callStatic(AbstractCreateCommand.class, profileInstance, callSiteArray[18].callGroovyObjectGetProperty(cmd), callSiteArray[19].callGroovyObjectGetProperty(cmd))), List.class);
        if (DefaultTypeTransformation.booleanUnbox(profileInstance)) {
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[20].callCurrent(this, callSiteArray[21].callGroovyObjectGetProperty(cmd), callSiteArray[22].callGroovyObjectGetProperty(cmd)))) {
                return false;
            }
            callSiteArray[23].callCurrent(this, profileName, callSiteArray[24].callGroovyObjectGetProperty(cmd));
            Path appFullDirectory = (Path)ScriptBytecodeAdapter.castToType(callSiteArray[25].call(Paths.class, callSiteArray[26].callGetProperty(callSiteArray[27].callGroovyObjectGetProperty(cmd)), this.appname), Path.class);
            File projectTargetDirectory = (File)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox(callSiteArray[28].callGroovyObjectGetProperty(cmd)) ? callSiteArray[29].callGetProperty(callSiteArray[30].callConstructor(File.class, ".")) : callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(appFullDirectory))), File.class);
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[34].call(projectTargetDirectory)) && !DefaultTypeTransformation.booleanUnbox(callSiteArray[35].callGroovyObjectGetProperty(cmd))) {
                callSiteArray[36].call(callSiteArray[37].callGetProperty(MicronautConsole.class), "Cannot create the project because the target directory already exists");
                return false;
            }
            Object profiles = callSiteArray[38].call((Object)this.profileRepository, profileInstance);
            Map targetDirs = ScriptBytecodeAdapter.createMap(new Object[0]);
            callSiteArray[39].callCurrent(this, profileInstance, targetDirs, projectTargetDirectory);
            Profile p = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType(callSiteArray[40].call(profiles), Iterator.class);
            while (iterator.hasNext()) {
                p = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
                Set ymlFiles = (Set)ScriptBytecodeAdapter.castToType(callSiteArray[41].callCurrent(this, projectTargetDirectory, APPLICATION_YML), Set.class);
                Reference<Map> ymlCache = new Reference<Map>(ScriptBytecodeAdapter.createMap(new Object[0]));
                Object object = callSiteArray[42].call((Object)targetDirs, p);
                this.targetDirectory = (File)ScriptBytecodeAdapter.castToType(object, File.class);
                public final class _handle_closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ymlCache;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _handle_closure6(Object _outerInstance, Object _thisObject, Reference ymlCache) {
                        Reference reference;
                        CallSite[] callSiteArray = _handle_closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.ymlCache = reference = ymlCache;
                    }

                    public Object doCall(File applicationYmlFile) {
                        CallSite[] callSiteArray = _handle_closure6.$getCallSiteArray();
                        String previousApplicationYml = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(applicationYmlFile)) ? callSiteArray[1].call((Object)applicationYmlFile, callSiteArray[2].callGetProperty(AbstractCreateCommand.class)) : null);
                        if (DefaultTypeTransformation.booleanUnbox(previousApplicationYml)) {
                            String string = previousApplicationYml;
                            callSiteArray[3].call(this.ymlCache.get(), applicationYmlFile, string);
                            return string;
                        }
                        return null;
                    }

                    public Object call(File applicationYmlFile) {
                        CallSite[] callSiteArray = _handle_closure6.$getCallSiteArray();
                        return callSiteArray[4].callCurrent((GroovyObject)this, applicationYmlFile);
                    }

                    public Map getYmlCache() {
                        CallSite[] callSiteArray = _handle_closure6.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType(this.ymlCache.get(), Map.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "isFile";
                        stringArray[1] = "getText";
                        stringArray[2] = "ENCODING";
                        stringArray[3] = "putAt";
                        stringArray[4] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _handle_closure6.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_handle_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _handle_closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[43].call((Object)ymlFiles, new _handle_closure6(this, this, ymlCache));
                callSiteArray[44].callCurrent(this, profileInstance, p, cmd);
                Map.Entry entry = null;
                Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType(callSiteArray[45].call(callSiteArray[46].call(ymlCache.get())), Iterator.class);
                while (iterator2.hasNext()) {
                    entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator2.next(), Map.Entry.class);
                    if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[47].call(callSiteArray[48].call(entry)))) continue;
                    callSiteArray[49].callCurrent(this, callSiteArray[50].call(entry), callSiteArray[51].call(entry));
                }
            }
            AntBuilder ant = (AntBuilder)ScriptBytecodeAdapter.castToType(callSiteArray[52].callConstructor(ConsoleAntBuilder.class), AntBuilder.class);
            Feature f = null;
            Iterator iterator3 = (Iterator)ScriptBytecodeAdapter.castToType(callSiteArray[53].call(features), Iterator.class);
            while (iterator3.hasNext()) {
                f = (Feature)ScriptBytecodeAdapter.castToType(iterator3.next(), Feature.class);
                Object location = callSiteArray[54].callGetProperty(f);
                File skeletonDir = null;
                File tmpDir = null;
                if (location instanceof FileSystemResource) {
                    Object object = callSiteArray[55].callGetProperty(callSiteArray[56].call(location, "skeleton"));
                    skeletonDir = (File)ScriptBytecodeAdapter.castToType(object, File.class);
                } else {
                    Object object = callSiteArray[57].callCurrent(this, ant, location);
                    tmpDir = (File)ScriptBytecodeAdapter.castToType(object, File.class);
                    Object object2 = callSiteArray[58].callConstructor(File.class, tmpDir, new GStringImpl(new Object[]{callSiteArray[59].callGetProperty(f)}, new String[]{"META-INF/profile/features/", "/skeleton"}));
                    skeletonDir = (File)ScriptBytecodeAdapter.castToType(object2, File.class);
                }
                Object object = callSiteArray[60].call((Object)targetDirs, callSiteArray[61].callGetProperty(f));
                this.targetDirectory = (File)ScriptBytecodeAdapter.castToType(object, File.class);
                callSiteArray[62].callCurrent(this, skeletonDir, callSiteArray[63].callGroovyObjectGetProperty(cmd));
                List featureExcludes = ScriptBytecodeAdapter.createList(new Object[]{callSiteArray[64].call((Object)"**/", APPLICATION_YML)});
                callSiteArray[65].call((Object)featureExcludes, callSiteArray[66].callGetProperty(profileInstance));
                if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[67].call(skeletonDir))) continue;
                callSiteArray[68].callCurrent(this, ant, skeletonDir, featureExcludes, callSiteArray[69].callGetProperty(profileInstance));
                callSiteArray[70].callCurrent(this, ant, callSiteArray[71].callConstructor(File.class, skeletonDir, callSiteArray[72].call(callSiteArray[73].callGroovyObjectGetProperty(cmd), "-build")), featureExcludes, callSiteArray[74].callGetProperty(profileInstance));
                callSiteArray[75].call((Object)ant, ScriptBytecodeAdapter.createMap(new Object[]{"dir", this.targetDirectory, "includes", callSiteArray[76].call(callSiteArray[77].callGetProperty(profileInstance), " "), "perm", "u+x"}));
            }
            callSiteArray[78].callCurrent(this, cmd, profileInstance, features, projectTargetDirectory);
            callSiteArray[79].callCurrent(this, callSiteArray[80].callGroovyObjectGetProperty(cmd), cmd, projectTargetDirectory);
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[81].callGetProperty(profileInstance))) {
                callSiteArray[82].call(callSiteArray[83].callGroovyObjectGetProperty(cmd), callSiteArray[84].callGetProperty(profileInstance));
            }
            callSiteArray[85].call(MicronautCli.class);
            return true;
        }
        callSiteArray[86].call(callSiteArray[87].call(MicronautConsole.class), new GStringImpl(new Object[]{profileName}, new String[]{"Cannot find profile ", ""}));
        return false;
    }

    @Override
    public void reset() {
        List list;
        boolean bl;
        Map map = ScriptBytecodeAdapter.createMap(new Object[0]);
        this.variables = (LinkedHashMap)ScriptBytecodeAdapter.castToType(map, LinkedHashMap.class);
        this.inplace = bl = false;
        Object var3_3 = null;
        this.profile = ShortTypeHandling.castToString(var3_3);
        this.features = list = ScriptBytecodeAdapter.createList(new Object[0]);
        Object var5_5 = null;
        this.appname = ShortTypeHandling.castToString(var5_5);
        Object var6_6 = null;
        this.groupname = ShortTypeHandling.castToString(var6_6);
        Object var7_7 = null;
        this.defaultpackagename = ShortTypeHandling.castToString(var7_7);
        Object var8_8 = null;
        this.targetDirectory = (File)ScriptBytecodeAdapter.castToType(var8_8, File.class);
    }

    protected void messageOnComplete(MicronautConsole console, CreateServiceCommandObject command, File targetDir) {
        console.addStatus(ShortTypeHandling.castToString(new GStringImpl(new Object[]{targetDir.getAbsolutePath()}, new String[]{"Application created at ", ""})));
    }

    protected boolean validateProfile(Profile profileInstance, String profileName) {
        if (profileInstance == null) {
            MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profileName}, new String[]{"Profile not found for name [", "]"})));
            return false;
        }
        if (profileInstance.isAbstract()) {
            MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profileName}, new String[]{"Profile [", "] is designed only for extension and not direct usage"})));
            return false;
        }
        return true;
    }

    protected boolean validateBuild(String buildName) {
        if (!SupportedBuildTool.names().contains(buildName)) {
            MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{buildName, DefaultGroovyMethods.join(SupportedBuildTool.quoted(), ", ")}, new String[]{"Build not one of the supported types [", "]. Supported types are ", "."})));
            return false;
        }
        return true;
    }

    protected File unzipProfile(AntBuilder ant, Resource location) {
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        Object url = callSiteArray[88].callGetProperty(location);
        Object tmpDir = callSiteArray[89].call(this.unzippedDirectories, url);
        if (ScriptBytecodeAdapter.compareEqual(tmpDir, null)) {
            Object object;
            Object jarFile = callSiteArray[90].call(IOUtils.class, url);
            tmpDir = object = callSiteArray[91].call(File.class);
            callSiteArray[92].call(tmpDir);
            callSiteArray[93].call((Object)ant, ScriptBytecodeAdapter.createMap(new Object[]{"src", jarFile, "dest", tmpDir}));
            callSiteArray[94].call(this.unzippedDirectories, url, tmpDir);
        }
        return (File)ScriptBytecodeAdapter.castToType(tmpDir, File.class);
    }

    protected void replaceBuildTokens(CreateServiceCommandObject cmd, Profile profile, List<Feature> features, File targetDirectory) {
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        AntBuilder ant = (AntBuilder)ScriptBytecodeAdapter.castToType(callSiteArray[95].callConstructor(ConsoleAntBuilder.class), AntBuilder.class);
        public final class _replaceBuildTokens_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _replaceBuildTokens_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _replaceBuildTokens_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _replaceBuildTokens_closure7.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _replaceBuildTokens_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _replaceBuildTokens_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "requested";
                return new CallSiteArray(_replaceBuildTokens_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _replaceBuildTokens_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List requestedFeatureNames = (List)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.getPropertySpreadSafe(AbstractCreateCommand.class, callSiteArray[96].call(features, new _replaceBuildTokens_closure7(this, this)), "name"), List.class);
        List allFeatureNames = (List)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.getPropertySpreadSafe(AbstractCreateCommand.class, features, "name"), List.class);
        String testFramework = null;
        String sourceLanguage = null;
        if (ScriptBytecodeAdapter.compareNotEqual(callSiteArray[97].callGetProperty(profile), "profile")) {
            if (DefaultTypeTransformation.booleanUnbox(requestedFeatureNames)) {
                Object object = callSiteArray[98].callStatic(AbstractCreateCommand.class, requestedFeatureNames);
                testFramework = ShortTypeHandling.castToString(object);
                Object object2 = callSiteArray[99].callStatic(AbstractCreateCommand.class, requestedFeatureNames);
                sourceLanguage = ShortTypeHandling.castToString(object2);
            }
            if (!DefaultTypeTransformation.booleanUnbox(testFramework)) {
                Object object = callSiteArray[100].callStatic(AbstractCreateCommand.class, allFeatureNames);
                testFramework = ShortTypeHandling.castToString(object);
            }
            if (!DefaultTypeTransformation.booleanUnbox(sourceLanguage)) {
                Object object = callSiteArray[101].callStatic(AbstractCreateCommand.class, allFeatureNames);
                sourceLanguage = ShortTypeHandling.castToString(object);
            }
        }
        BuildTokens buildTokens = null;
        if (ScriptBytecodeAdapter.compareEqual(callSiteArray[102].callGroovyObjectGetProperty(cmd), "gradle")) {
            Object object = callSiteArray[103].callConstructor(GradleBuildTokens.class, this.appname, sourceLanguage, testFramework);
            buildTokens = (BuildTokens)ScriptBytecodeAdapter.castToType(object, BuildTokens.class);
        } else if (ScriptBytecodeAdapter.compareEqual(callSiteArray[104].callGroovyObjectGetProperty(cmd), "maven")) {
            Object object = callSiteArray[105].callConstructor(MavenBuildTokens.class, this.appname, sourceLanguage, testFramework);
            buildTokens = (BuildTokens)ScriptBytecodeAdapter.castToType(object, BuildTokens.class);
        } else {
            return;
        }
        Reference<Map> tokens = new Reference<Map>((Map)ScriptBytecodeAdapter.castToType(callSiteArray[106].call(buildTokens, profile, features), Map.class));
        if (ScriptBytecodeAdapter.compareEqual(tokens.get(), null)) {
            return;
        }
        callSiteArray[107].call(tokens.get(), "micronautVersion", callSiteArray[108].callGroovyObjectGetProperty(cmd));
        public final class _replaceBuildTokens_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tokens;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _replaceBuildTokens_closure8(Object _outerInstance, Object _thisObject, Reference tokens) {
                Reference reference;
                CallSite[] callSiteArray = _replaceBuildTokens_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tokens = reference = tokens;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _replaceBuildTokens_closure8.$getCallSiteArray();
                public final class _closure25
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure25(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Object doCall(Object k, Object v) {
                        void var2_2;
                        Reference<Object> k2 = new Reference<Object>(k);
                        Reference<void> v2 = new Reference<void>(var2_2);
                        CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                        public final class _closure27
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference k;
                            private /* synthetic */ Reference v;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure27(Object _outerInstance, Object _thisObject, Reference k, Reference v) {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.k = reference2 = k;
                                this.v = reference = v;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                                if (DefaultTypeTransformation.booleanUnbox(this.k.get())) {
                                    callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(new GStringImpl(new Object[]{this.k.get()}, new String[]{"@", "@"})));
                                }
                                if (DefaultTypeTransformation.booleanUnbox(this.v.get())) {
                                    return callSiteArray[2].callCurrent((GroovyObject)this, this.v.get());
                                }
                                return null;
                            }

                            public Object getK() {
                                CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                                return this.k.get();
                            }

                            public Object getV() {
                                CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                                return this.v.get();
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure27.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "replacetoken";
                                stringArray[1] = "toString";
                                stringArray[2] = "replacevalue";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[3];
                                _closure27.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure27.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure27.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callCurrent((GroovyObject)this, new _closure27(this, this.getThisObject(), k2, v2));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Object call(Object k, Object v) {
                        void var2_2;
                        Reference<Object> k2 = new Reference<Object>(k);
                        Reference<void> v2 = new Reference<void>(var2_2);
                        CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                        return callSiteArray[1].callCurrent(this, k2.get(), v2.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure25.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "replacefilter";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure25.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure25.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure25.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].call(this.tokens.get(), new _closure25(this, this.getThisObject()));
                public final class _closure26
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure26(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Object doCall(Object k, Object v) {
                        void var2_2;
                        Reference<Object> k2 = new Reference<Object>(k);
                        Reference<void> v2 = new Reference<void>(var2_2);
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        public final class _closure28
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference k;
                            private /* synthetic */ Reference v;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure28(Object _outerInstance, Object _thisObject, Reference k, Reference v) {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.k = reference2 = k;
                                this.v = reference = v;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(new GStringImpl(new Object[]{this.k.get()}, new String[]{"@", "@"})));
                                return callSiteArray[2].callCurrent((GroovyObject)this, this.v.get());
                            }

                            public Object getK() {
                                CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                                return this.k.get();
                            }

                            public Object getV() {
                                CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                                return this.v.get();
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure28.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "replacetoken";
                                stringArray[1] = "toString";
                                stringArray[2] = "replacevalue";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[3];
                                _closure28.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure28.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure28.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callCurrent((GroovyObject)this, new _closure28(this, this.getThisObject(), k2, v2));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Object call(Object k, Object v) {
                        void var2_2;
                        Reference<Object> k2 = new Reference<Object>(k);
                        Reference<void> v2 = new Reference<void>(var2_2);
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        return callSiteArray[1].callCurrent(this, k2.get(), v2.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "replacefilter";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure26.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure26.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure26.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty(this), new _closure26(this, this.getThisObject()));
            }

            public Map getTokens() {
                CallSite[] callSiteArray = _replaceBuildTokens_closure8.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType(this.tokens.get(), Map.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _replaceBuildTokens_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _replaceBuildTokens_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "each";
                stringArray[2] = "variables";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _replaceBuildTokens_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_replaceBuildTokens_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _replaceBuildTokens_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[109].call(ant, ScriptBytecodeAdapter.createMap(new Object[]{"dir", targetDirectory}), new _replaceBuildTokens_closure8(this, this, tokens));
        callSiteArray[110].callCurrent((GroovyObject)this, buildTokens);
    }

    protected void withTokens(BuildTokens buildTokens) {
    }

    protected static String evaluateTestFramework(List<String> features) {
        String testFramework = null;
        if (features.contains("spock")) {
            String string;
            testFramework = string = "spock";
        } else if (features.contains("junit")) {
            String string;
            testFramework = string = "junit";
        } else if (features.contains("spek")) {
            String string;
            testFramework = string = "spek";
        } else if (features.contains("kotlintest")) {
            String string;
            testFramework = string = "kotlintest";
        }
        return testFramework;
    }

    protected static String evaluateSourceLanguage(List<String> features) {
        String sourceLanguage = null;
        if (features.contains("groovy")) {
            String string;
            sourceLanguage = string = "groovy";
        } else if (features.contains("kotlin")) {
            String string;
            sourceLanguage = string = "kotlin";
        } else if (features.contains("java")) {
            String string;
            sourceLanguage = string = "java";
        }
        return sourceLanguage;
    }

    protected String evaluateProfileName() {
        String string = this.profile;
        return DefaultTypeTransformation.booleanUnbox(string) ? string : this.getDefaultProfile();
    }

    protected static Iterable<Feature> evaluateFeatures(Profile profile, Set<String> requestedFeatures, String lang) {
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        Object object = callSiteArray[111].callStatic(AbstractCreateCommand.class, profile, requestedFeatures, lang);
        Reference<Set> features = new Reference<Set>((Set)ScriptBytecodeAdapter.castToType(callSiteArray[112].call(object, 0), Set.class));
        List validRequestedFeatureNames = (List)ScriptBytecodeAdapter.castToType(callSiteArray[113].call(object, 1), List.class);
        Object object2 = callSiteArray[114].callStatic(AbstractCreateCommand.class, profile, features.get());
        features.set((Set)ScriptBytecodeAdapter.castToType(object2, Set.class));
        Object object3 = callSiteArray[115].callStatic(AbstractCreateCommand.class, profile, features.get());
        features.set((Set)ScriptBytecodeAdapter.castToType(object3, Set.class));
        String language = ShortTypeHandling.castToString(callSiteArray[116].callSafe(callSiteArray[117].callStatic(AbstractCreateCommand.class, features.get())));
        if (DefaultTypeTransformation.booleanUnbox(language)) {
            callSiteArray[118].call(callSiteArray[119].call(MicronautConsole.class), new GStringImpl(new Object[]{language}, new String[]{"Generating ", " project..."}));
        }
        public final class _evaluateFeatures_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference features;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _evaluateFeatures_closure9(Object _outerInstance, Object _thisObject, Reference features) {
                Reference reference;
                CallSite[] callSiteArray = _evaluateFeatures_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.features = reference = features;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _evaluateFeatures_closure9.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(ScriptBytecodeAdapter.getPropertySpreadSafe(_evaluateFeatures_closure9.class, this.features.get(), "name"), it));
            }

            public Set getFeatures() {
                CallSite[] callSiteArray = _evaluateFeatures_closure9.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType(this.features.get(), Set.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _evaluateFeatures_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _evaluateFeatures_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "contains";
                return new CallSiteArray(_evaluateFeatures_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _evaluateFeatures_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List removedFeatures = (List)ScriptBytecodeAdapter.castToType(callSiteArray[120].call((Object)validRequestedFeatureNames, new _evaluateFeatures_closure9(AbstractCreateCommand.class, AbstractCreateCommand.class, features)), List.class);
        if (DefaultTypeTransformation.booleanUnbox(removedFeatures)) {
            StringBuilder warning = (StringBuilder)ScriptBytecodeAdapter.castToType(callSiteArray[121].callConstructor(StringBuilder.class, "The following features are incompatible with other feature selections and have been removed from the project"), StringBuilder.class);
            callSiteArray[122].call((Object)warning, callSiteArray[123].call(System.class, "line.separator"));
            callSiteArray[124].call((Object)warning, new GStringImpl(new Object[]{callSiteArray[125].call((Object)removedFeatures, ", ")}, new String[]{"| ", ""}));
            callSiteArray[126].call(callSiteArray[127].call(MicronautConsole.class), callSiteArray[128].call(warning));
        }
        return features.get();
    }

    /*
     * WARNING - void declaration
     */
    protected static Tuple populateFeatures(Profile profile, Set<String> requestedFeatures, String lang) {
        void var2_2;
        Reference<Profile> profile2 = new Reference<Profile>(profile);
        Reference<void> lang2 = new Reference<void>(var2_2);
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        Set features = (Set)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[0]), Set.class);
        Reference<List> validRequestedFeatureNames = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
        if (DefaultTypeTransformation.booleanUnbox(requestedFeatures)) {
            Reference<List> allFeatureNames = new Reference<List>((List)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.getPropertySpreadSafe(AbstractCreateCommand.class, callSiteArray[129].callGetProperty(profile2.get()), "name"), List.class));
            List list = (List)ScriptBytecodeAdapter.asType(callSiteArray[130].call(requestedFeatures, allFeatureNames.get()), List.class);
            validRequestedFeatureNames.set(list);
            if (DefaultTypeTransformation.booleanUnbox((String)lang2.get())) {
                callSiteArray[131].call((Object)validRequestedFeatureNames.get(), (String)lang2.get());
            }
            callSiteArray[132].call(requestedFeatures, allFeatureNames.get());
            public final class _populateFeatures_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference allFeatureNames;
                private /* synthetic */ Reference profile;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _populateFeatures_closure10(Object _outerInstance, Object _thisObject, Reference allFeatureNames, Reference profile) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _populateFeatures_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.allFeatureNames = reference2 = allFeatureNames;
                    this.profile = reference = profile;
                }

                public Object doCall(String invalidFeature) {
                    Reference<String> invalidFeature2 = new Reference<String>(invalidFeature);
                    CallSite[] callSiteArray = _populateFeatures_closure10.$getCallSiteArray();
                    Reference<Integer> idx = new Reference<Integer>((Integer)ScriptBytecodeAdapter.castToType(callSiteArray[0].call(Math.class, callSiteArray[1].call(invalidFeature2.get()), 2), Integer.class));
                    public final class _closure29
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference idx;
                        private /* synthetic */ Reference invalidFeature;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure29(Object _outerInstance, Object _thisObject, Reference idx, Reference invalidFeature) {
                            Reference reference;
                            Reference reference2;
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.idx = reference2 = idx;
                            this.invalidFeature = reference = invalidFeature;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            return ScriptBytecodeAdapter.compareEqual(callSiteArray[0].call(it, 0, this.idx.get()), callSiteArray[1].call(this.invalidFeature.get(), 0, this.idx.get()));
                        }

                        public Integer getIdx() {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType(this.idx.get(), Integer.class);
                        }

                        public String getInvalidFeature() {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            return ShortTypeHandling.castToString(this.invalidFeature.get());
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _closure29.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "substring";
                            stringArray[1] = "substring";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure29.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure29.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure29.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    List possibleSolutions = (List)ScriptBytecodeAdapter.castToType(callSiteArray[2].call(this.allFeatureNames.get(), new _closure29(this, this.getThisObject(), idx, invalidFeature2)), List.class);
                    StringBuilder warning = (StringBuilder)ScriptBytecodeAdapter.castToType(callSiteArray[3].callConstructor(StringBuilder.class, new GStringImpl(new Object[]{invalidFeature2.get(), callSiteArray[4].callGetProperty(this.profile.get())}, new String[]{"Feature ", " does not exist in the profile ", "!"})), StringBuilder.class);
                    if (DefaultTypeTransformation.booleanUnbox(possibleSolutions)) {
                        callSiteArray[5].call((Object)warning, " Possible solutions: ");
                        callSiteArray[6].call((Object)warning, callSiteArray[7].call((Object)possibleSolutions, ", "));
                    }
                    return callSiteArray[8].call(callSiteArray[9].call(MicronautConsole.class), callSiteArray[10].call(warning));
                }

                public Object call(String invalidFeature) {
                    Reference<String> invalidFeature2 = new Reference<String>(invalidFeature);
                    CallSite[] callSiteArray = _populateFeatures_closure10.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[11].callCurrent((GroovyObject)this, invalidFeature2.get());
                    }
                    return this.doCall(invalidFeature2.get());
                }

                public List getAllFeatureNames() {
                    CallSite[] callSiteArray = _populateFeatures_closure10.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType(this.allFeatureNames.get(), List.class);
                }

                public Profile getProfile() {
                    CallSite[] callSiteArray = _populateFeatures_closure10.$getCallSiteArray();
                    return (Profile)ScriptBytecodeAdapter.castToType(this.profile.get(), Profile.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _populateFeatures_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "min";
                    stringArray[1] = "size";
                    stringArray[2] = "findAll";
                    stringArray[3] = "<$constructor$>";
                    stringArray[4] = "name";
                    stringArray[5] = "append";
                    stringArray[6] = "append";
                    stringArray[7] = "join";
                    stringArray[8] = "warn";
                    stringArray[9] = "getInstance";
                    stringArray[10] = "toString";
                    stringArray[11] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[12];
                    _populateFeatures_closure10.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_populateFeatures_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _populateFeatures_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[133].call(requestedFeatures, new _populateFeatures_closure10(AbstractCreateCommand.class, AbstractCreateCommand.class, allFeatureNames, profile2));
            public final class _populateFeatures_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference validRequestedFeatureNames;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _populateFeatures_closure11(Object _outerInstance, Object _thisObject, Reference validRequestedFeatureNames) {
                    Reference reference;
                    CallSite[] callSiteArray = _populateFeatures_closure11.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.validRequestedFeatureNames = reference = validRequestedFeatureNames;
                }

                public Object doCall(Feature f) {
                    CallSite[] callSiteArray = _populateFeatures_closure11.$getCallSiteArray();
                    return callSiteArray[0].call(this.validRequestedFeatureNames.get(), callSiteArray[1].callGetProperty(f));
                }

                public Object call(Feature f) {
                    CallSite[] callSiteArray = _populateFeatures_closure11.$getCallSiteArray();
                    return callSiteArray[2].callCurrent((GroovyObject)this, f);
                }

                public List getValidRequestedFeatureNames() {
                    CallSite[] callSiteArray = _populateFeatures_closure11.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType(this.validRequestedFeatureNames.get(), List.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _populateFeatures_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "name";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _populateFeatures_closure11.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_populateFeatures_closure11.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _populateFeatures_closure11.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Iterable validFeatures = (Iterable)ScriptBytecodeAdapter.castToType(callSiteArray[134].call(callSiteArray[135].callGetProperty(profile2.get()), new _populateFeatures_closure11(AbstractCreateCommand.class, AbstractCreateCommand.class, validRequestedFeatureNames)), Iterable.class);
            callSiteArray[136].call((Object)features, validFeatures);
        } else {
            callSiteArray[137].call((Object)features, callSiteArray[138].callGetProperty(profile2.get()));
        }
        public final class _populateFeatures_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference lang;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _populateFeatures_closure12(Object _outerInstance, Object _thisObject, Reference lang) {
                Reference reference;
                CallSite[] callSiteArray = _populateFeatures_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.lang = reference = lang;
            }

            public Object doCall(Feature f) {
                CallSite[] callSiteArray = _populateFeatures_closure12.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox(this.lang.get())) {
                    return ScriptBytecodeAdapter.compareEqual(callSiteArray[0].callGetProperty(f), this.lang.get());
                }
                return ScriptBytecodeAdapter.compareEqual(callSiteArray[1].callGetProperty(f), callSiteArray[2].call(callSiteArray[3].callGetProperty(SupportedLanguage.class)));
            }

            public Object call(Feature f) {
                CallSite[] callSiteArray = _populateFeatures_closure12.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, f);
            }

            public String getLang() {
                CallSite[] callSiteArray = _populateFeatures_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString(this.lang.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _populateFeatures_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "name";
                stringArray[2] = "name";
                stringArray[3] = "java";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _populateFeatures_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_populateFeatures_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _populateFeatures_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Feature langFeature = (Feature)ScriptBytecodeAdapter.asType(callSiteArray[139].call(callSiteArray[140].callGetProperty(profile2.get()), new _populateFeatures_closure12(AbstractCreateCommand.class, AbstractCreateCommand.class, lang2)), Feature.class);
        if (DefaultTypeTransformation.booleanUnbox(langFeature)) {
            callSiteArray[141].call((Object)features, langFeature);
        }
        callSiteArray[142].call((Object)features, callSiteArray[143].callGetProperty(profile2.get()));
        if (DefaultTypeTransformation.booleanUnbox(validRequestedFeatureNames.get())) {
            public final class _populateFeatures_closure13
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference validRequestedFeatureNames;
                private /* synthetic */ Reference lang;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _populateFeatures_closure13(Object _outerInstance, Object _thisObject, Reference validRequestedFeatureNames, Reference lang) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _populateFeatures_closure13.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.validRequestedFeatureNames = reference2 = validRequestedFeatureNames;
                    this.lang = reference = lang;
                }

                public Object doCall(Object feature) {
                    CallSite[] callSiteArray = _populateFeatures_closure13.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(this.validRequestedFeatureNames.get(), callSiteArray[1].callGetProperty(feature))) || DefaultTypeTransformation.booleanUnbox(this.lang.get()) && ScriptBytecodeAdapter.compareEqual(callSiteArray[2].callGetProperty(feature), this.lang.get())) {
                        boolean bl = true;
                        ScriptBytecodeAdapter.setProperty(bl, null, feature, "requested");
                        return bl;
                    }
                    return null;
                }

                public List getValidRequestedFeatureNames() {
                    CallSite[] callSiteArray = _populateFeatures_closure13.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType(this.validRequestedFeatureNames.get(), List.class);
                }

                public String getLang() {
                    CallSite[] callSiteArray = _populateFeatures_closure13.$getCallSiteArray();
                    return ShortTypeHandling.castToString(this.lang.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _populateFeatures_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "name";
                    stringArray[2] = "name";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _populateFeatures_closure13.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_populateFeatures_closure13.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _populateFeatures_closure13.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[144].call(callSiteArray[145].call((Object)features, new _populateFeatures_closure13(AbstractCreateCommand.class, AbstractCreateCommand.class, validRequestedFeatureNames, lang2)));
            features = (Set)ScriptBytecodeAdapter.castToType(object, Set.class);
        }
        Object object = callSiteArray[146].callStatic(AbstractCreateCommand.class, profile2.get(), features, true);
        features = (Set)ScriptBytecodeAdapter.castToType(object, Set.class);
        return (Tuple)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[]{features, validRequestedFeatureNames.get()}), Tuple.class);
    }

    /*
     * WARNING - void declaration
     */
    protected static Set<Feature> pruneOneOfFeatures(Profile profile, Set<Feature> features) {
        void var1_1;
        Reference<Profile> profile2 = new Reference<Profile>(profile);
        Reference<void> features2 = new Reference<void>(var1_1);
        if (!DefaultGroovyMethods.isEmpty(profile2.get().getOneOfFeatures())) {
            public final class _pruneOneOfFeatures_closure14
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference features;
                private /* synthetic */ Reference profile;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _pruneOneOfFeatures_closure14(Object _outerInstance, Object _thisObject, Reference features, Reference profile) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.features = reference2 = features;
                    this.profile = reference = profile;
                }

                public Object doCall(OneOfFeatureGroup group) {
                    Reference<OneOfFeatureGroup> group2 = new Reference<OneOfFeatureGroup>(group);
                    public final class _closure30
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference group;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure30(Object _outerInstance, Object _thisObject, Reference group) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.group = reference = group;
                        }

                        public Object doCall(Object it) {
                            return ((List)ScriptBytecodeAdapter.getPropertySpreadSafe(_closure30.class, ((OneOfFeatureGroup)this.group.get()).getOneOfFeatures(), "feature")).contains(it);
                        }

                        public OneOfFeatureGroup getGroup() {
                            return (OneOfFeatureGroup)ScriptBytecodeAdapter.castToType(this.group.get(), OneOfFeatureGroup.class);
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Override
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _closure30.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Reference toRemove = new Reference(DefaultGroovyMethods.findAll((Set)ScriptBytecodeAdapter.castToType(this.features.get(), Set.class), (Closure)new _closure30(this, this.getThisObject(), group2)));
                    public final class _closure31
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure31(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ((Feature)it).getRequested();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Override
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _closure31.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Feature requestedOneOf = (Feature)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.find(toRemove.get(), (Closure)new _closure31(this, this.getThisObject())), Feature.class);
                    if (DefaultTypeTransformation.booleanUnbox(requestedOneOf)) {
                        toRemove.get().remove(requestedOneOf);
                    } else {
                        toRemove.get().remove(DefaultGroovyMethods.getAt(toRemove.get(), 0));
                    }
                    if (!toRemove.get().isEmpty()) {
                        ((Set)this.features.get()).removeAll(toRemove.get());
                        public final class _closure32
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference profile;
                            private /* synthetic */ Reference toRemove;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure32(Object _outerInstance, Object _thisObject, Reference profile, Reference toRemove) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.profile = reference2 = profile;
                                this.toRemove = reference = toRemove;
                            }

                            public Object doCall(Object it) {
                                public final class _closure33
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference toRemove;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure33(Object _outerInstance, Object _thisObject, Reference toRemove) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        this.toRemove = reference = toRemove;
                                    }

                                    public Object doCall(Object it) {
                                        return ((Set)this.toRemove.get()).contains(it);
                                    }

                                    public Set getToRemove() {
                                        return (Set)ScriptBytecodeAdapter.castToType(this.toRemove.get(), Set.class);
                                    }

                                    public Object call(Object args) {
                                        return this.doCall(args);
                                    }

                                    @Override
                                    public Object call() {
                                        return this.doCall(null);
                                    }

                                    @Generated
                                    public Object doCall() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (this.getClass() != _closure33.class) {
                                            return ScriptBytecodeAdapter.initMetaClass(this);
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }
                                }
                                return !DefaultGroovyMethods.any(((Feature)it).getDependentFeatures((Profile)ScriptBytecodeAdapter.castToType(this.profile.get(), Profile.class)), (Closure)new _closure33(this, this.getThisObject(), this.toRemove));
                            }

                            public Profile getProfile() {
                                return (Profile)ScriptBytecodeAdapter.castToType(this.profile.get(), Profile.class);
                            }

                            public Set getToRemove() {
                                return (Set)ScriptBytecodeAdapter.castToType(this.toRemove.get(), Set.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Override
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure32.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Set set = DefaultGroovyMethods.findAll((Set)ScriptBytecodeAdapter.castToType(this.features.get(), Set.class), (Closure)new _closure32(this, this.getThisObject(), this.profile, toRemove));
                        this.features.set(set);
                        return set;
                    }
                    return null;
                }

                public Object call(OneOfFeatureGroup group) {
                    Reference<OneOfFeatureGroup> group2 = new Reference<OneOfFeatureGroup>(group);
                    return this.doCall(group2.get());
                }

                public Set getFeatures() {
                    return (Set)ScriptBytecodeAdapter.castToType(this.features.get(), Set.class);
                }

                public Profile getProfile() {
                    return (Profile)ScriptBytecodeAdapter.castToType(this.profile.get(), Profile.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _pruneOneOfFeatures_closure14.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(profile2.get().getOneOfFeatures(), (Closure)new _pruneOneOfFeatures_closure14(AbstractCreateCommand.class, AbstractCreateCommand.class, features2, profile2));
        }
        return (Set)features2.get();
    }

    protected static Set<Feature> addDependentFeatures(Profile profile, Set<Feature> features, Boolean oneOfOnly) {
        Reference<Integer> javaVersion = new Reference<Integer>(VersionInfo.getJavaVersion());
        public final class _addDependentFeatures_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference javaVersion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addDependentFeatures_closure15(Object _outerInstance, Object _thisObject, Reference javaVersion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.javaVersion = reference = javaVersion;
            }

            public Object doCall(Object it) {
                return ((Feature)it).isSupported((Integer)ScriptBytecodeAdapter.castToType(this.javaVersion.get(), Integer.class));
            }

            public Integer getJavaVersion() {
                return (Integer)ScriptBytecodeAdapter.castToType(this.javaVersion.get(), Integer.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _addDependentFeatures_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Set<Feature> set = DefaultGroovyMethods.findAll(features, (Closure)new _addDependentFeatures_closure15(AbstractCreateCommand.class, AbstractCreateCommand.class, javaVersion));
        features = set;
        public final class _addDependentFeatures_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addDependentFeatures_closure16(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Feature)it).getEvictedFeatureNames();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _addDependentFeatures_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference evicted = new Reference(DefaultGroovyMethods.flatten(DefaultGroovyMethods.collect(features, new _addDependentFeatures_closure16(AbstractCreateCommand.class, AbstractCreateCommand.class))));
        if (DefaultTypeTransformation.booleanUnbox(evicted.get())) {
            public final class _addDependentFeatures_closure17
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference evicted;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addDependentFeatures_closure17(Object _outerInstance, Object _thisObject, Reference evicted) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.evicted = reference = evicted;
                }

                public Object doCall(Object it) {
                    return ((List)this.evicted.get()).contains(((Feature)it).getName());
                }

                public Object getEvicted() {
                    return this.evicted.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _addDependentFeatures_closure17.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            features.removeIf((Predicate)ScriptBytecodeAdapter.castToType(new _addDependentFeatures_closure17(AbstractCreateCommand.class, AbstractCreateCommand.class, evicted), Predicate.class));
        }
        Reference<List> oneOfFeatureNames = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
        public final class _addDependentFeatures_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference oneOfFeatureNames;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addDependentFeatures_closure18(Object _outerInstance, Object _thisObject, Reference oneOfFeatureNames) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.oneOfFeatureNames = reference = oneOfFeatureNames;
            }

            public Object doCall(Object g) {
                return ((List)this.oneOfFeatureNames.get()).addAll((Collection)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.getPropertySpreadSafe(_addDependentFeatures_closure18.class, ScriptBytecodeAdapter.getPropertySpreadSafe(_addDependentFeatures_closure18.class, ((OneOfFeatureGroup)g).getOneOfFeatures(), "feature"), "name"), Collection.class));
            }

            public List getOneOfFeatureNames() {
                return (List)ScriptBytecodeAdapter.castToType(this.oneOfFeatureNames.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _addDependentFeatures_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(profile.getOneOfFeatures(), (Closure)new _addDependentFeatures_closure18(AbstractCreateCommand.class, AbstractCreateCommand.class, oneOfFeatureNames));
        List dependentFeatures = ScriptBytecodeAdapter.createList(new Object[0]);
        int i = 0;
        while (i < features.size()) {
            Feature feature = (Feature)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.getAt(features, i), Feature.class);
            List<List<Feature>> dependents = DefaultGroovyMethods.plus(DefaultGroovyMethods.toList(feature.getDependentFeatures(profile)), DefaultGroovyMethods.toList(feature.getDefaultFeatures(profile)));
            Feature d = null;
            Iterator<List<Feature>> iterator = dependents.iterator();
            while (iterator.hasNext()) {
                d = (Feature)ScriptBytecodeAdapter.castToType(iterator.next(), Feature.class);
                if (!(!DefaultTypeTransformation.booleanUnbox(oneOfOnly) || oneOfFeatureNames.get().contains(d.getName())) || !d.isSupported(javaVersion.get())) continue;
                Boolean bl = feature.getRequested();
                if (bl == null ? false : bl) {
                    boolean bl2 = true;
                    d.setRequested(bl2);
                }
                dependentFeatures.add(d);
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        if (DefaultTypeTransformation.booleanUnbox(dependentFeatures)) {
            LinkedHashSet<Feature> newFeatures = new LinkedHashSet<Feature>();
            DefaultGroovyMethods.addAll(newFeatures, dependentFeatures);
            DefaultGroovyMethods.addAll(newFeatures, features);
            return newFeatures;
        }
        return features;
    }

    protected static String getLanguage(Set<Feature> features) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SupportedLanguage[] supportedLanguageArray = SupportedLanguage.values();
        if (supportedLanguageArray != null) {
            SupportedLanguage for$it$12 = null;
            SupportedLanguage[] supportedLanguageArray2 = supportedLanguageArray;
            if (supportedLanguageArray != null) {
                for (SupportedLanguage for$it$12 : supportedLanguageArray2) {
                    SupportedLanguage supportedLanguage = for$it$12;
                    arrayList.add(supportedLanguage != null ? supportedLanguage.name() : null);
                }
            }
        }
        Reference names = new Reference(arrayList);
        public final class _getLanguage_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference names;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLanguage_closure19(Object _outerInstance, Object _thisObject, Reference names) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.names = reference = names;
            }

            public Object doCall(Object it) {
                return ((List)this.names.get()).contains(((Feature)it).getName());
            }

            public List getNames() {
                return (List)ScriptBytecodeAdapter.castToType(this.names.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getLanguage_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Feature feature = DefaultGroovyMethods.find(features, (Closure)new _getLanguage_closure19(AbstractCreateCommand.class, AbstractCreateCommand.class, names));
        return feature != null ? feature.getName() : null;
    }

    protected String getDefaultProfile() {
        return ProfileRepository.DEFAULT_PROFILE_NAME;
    }

    protected static String createNewApplicationYml(String previousYml, String newYml) {
        String ln = System.getProperty("line.separator");
        if (ScriptBytecodeAdapter.compareNotEqual(newYml, previousYml)) {
            StringBuilder appended = new StringBuilder(previousYml.length() + newYml.length() + 30);
            if (!previousYml.startsWith("---")) {
                appended.append(StringGroovyMethods.plus("---", (CharSequence)ln));
            }
            appended.append(previousYml).append(StringGroovyMethods.plus(StringGroovyMethods.plus(ln, (CharSequence)"---"), (CharSequence)ln));
            appended.append(newYml);
            return appended.toString();
        }
        return newYml;
    }

    private void appendToYmlSubDocument(File applicationYmlFile, String previousApplicationYml) {
        this.appendToYmlSubDocument(applicationYmlFile, previousApplicationYml, applicationYmlFile);
    }

    private void appendToYmlSubDocument(File applicationYmlFile, String previousApplicationYml, File setTo) {
        String newApplicationYml = ResourceGroovyMethods.getText(applicationYmlFile);
        if (DefaultTypeTransformation.booleanUnbox(previousApplicationYml) && ScriptBytecodeAdapter.compareNotEqual(newApplicationYml, previousApplicationYml)) {
            String string = AbstractCreateCommand.createNewApplicationYml(previousApplicationYml, newApplicationYml);
            ScriptBytecodeAdapter.setProperty(string, null, setTo, "text");
        }
    }

    protected boolean initializeGroupAndName(String appName, boolean inplace) {
        block12: {
            String string;
            if (!DefaultTypeTransformation.booleanUnbox(appName) && !inplace) {
                MicronautConsole.getInstance().error("Specify an application name or use --inplace to create an application in the current directory");
                return false;
            }
            String groupAndAppName = appName;
            if (inplace) {
                String string2;
                this.appname = string2 = new File(".").getCanonicalFile().getName();
                if (!DefaultTypeTransformation.booleanUnbox(groupAndAppName)) {
                    String string3;
                    groupAndAppName = string3 = this.appname;
                }
            }
            if (!DefaultTypeTransformation.booleanUnbox(groupAndAppName)) {
                MicronautConsole.getInstance().error("Specify an application name or use --inplace to create an application in the current directory");
                return false;
            }
            this.defaultpackagename = string = this.establishGroupAndAppName(groupAndAppName);
            if (!(!NameUtils.isValidServiceId(this.appname))) break block12;
            MicronautConsole.getInstance().error("Application name should be all lower case and separated by dashes. For example: hello-world");
            boolean bl = false;
            return bl;
        }
        boolean bl = true;
        try {
            return bl;
        }
        catch (IllegalArgumentException e) {
            MicronautConsole.getInstance().error(e.getMessage());
            boolean bl2 = false;
            return bl2;
        }
    }

    private void initializeVariables(String profileName, String micronautVersion) {
        String string = this.appname;
        ScriptBytecodeAdapter.setProperty(string, null, this.variables, "APPNAME");
        String string2 = this.defaultpackagename;
        DefaultGroovyMethods.putAt(this.variables, "defaultPackage", string2);
        String string3 = this.defaultpackagename.replace(".", "/");
        DefaultGroovyMethods.putAt(this.variables, "defaultPackage.path", string3);
        String projectClassName = NameUtils.getNameFromScript(this.appname);
        String string4 = projectClassName;
        DefaultGroovyMethods.putAt(this.variables, "project.className", string4);
        String string5 = NameUtils.getNaturalName(projectClassName);
        DefaultGroovyMethods.putAt(this.variables, "project.naturalName", string5);
        String string6 = NameUtils.getScriptName(projectClassName);
        DefaultGroovyMethods.putAt(this.variables, "project.name", string6);
        String string7 = NameUtils.getPropertyName(projectClassName);
        DefaultGroovyMethods.putAt(this.variables, "project.propertyName", string7);
        String string8 = profileName;
        DefaultGroovyMethods.putAt(this.variables, "profile", string8);
        String string9 = micronautVersion;
        DefaultGroovyMethods.putAt(this.variables, "version", string9);
        String string10 = this.appname;
        DefaultGroovyMethods.putAt(this.variables, "app.name", string10);
        String string11 = this.groupname;
        DefaultGroovyMethods.putAt(this.variables, "app.group", string11);
        String string12 = this.isWindows() ? "false" : "true";
        DefaultGroovyMethods.putAt(this.variables, "jansi", string12);
    }

    private boolean isWindows() {
        String string = System.getProperty("os.name");
        String string2 = string != null ? string.toLowerCase(Locale.ENGLISH) : null;
        return DefaultTypeTransformation.booleanUnbox(string2 != null ? Boolean.valueOf(string2.contains("windows")) : null);
    }

    private String establishGroupAndAppName(String groupAndAppName) {
        Object[] groupApp = this.groupAppName(groupAndAppName);
        Object object = BytecodeInterface8.objectArrayGet(groupApp, 1);
        this.appname = ShortTypeHandling.castToString(object);
        Object object2 = BytecodeInterface8.objectArrayGet(groupApp, 0);
        this.groupname = ShortTypeHandling.castToString(object2);
        return this.groupname;
    }

    protected String[] groupAppName(String groupAndAppName) {
        String packageName = null;
        String appName = null;
        List parts = (List)ScriptBytecodeAdapter.asType(groupAndAppName.split("\\."), List.class);
        if (parts.size() == 1) {
            String string;
            Object t = DefaultGroovyMethods.getAt(parts, 0);
            appName = ShortTypeHandling.castToString(t);
            packageName = string = this.createValidPackageName(appName);
        } else {
            String string;
            Object t = DefaultGroovyMethods.getAt(parts, -1);
            appName = ShortTypeHandling.castToString(t);
            packageName = string = DefaultGroovyMethods.join(DefaultGroovyMethods.getAt(parts, (Range)new IntRange(true, 0, -2)), ".");
        }
        return new String[]{packageName, appName};
    }

    private String createValidPackageName(String appName) {
        public final class _createValidPackageName_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createValidPackageName_closure20(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String token) {
                public final class _closure34
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure34(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(char ch) {
                        return Character.isJavaIdentifierPart(ch);
                    }

                    public Object call(char ch) {
                        return this.doCall(ch);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure34.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return (String)ScriptBytecodeAdapter.asType((char[])ScriptBytecodeAdapter.asType(DefaultGroovyMethods.findAll((Object)token.toLowerCase().toCharArray(), (Closure)new _closure34(this, this.getThisObject())), char[].class), String.class);
            }

            public Object call(String token) {
                return this.doCall(token);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _createValidPackageName_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        String defaultPackage = DefaultGroovyMethods.join(DefaultGroovyMethods.collect((Object[])ScriptBytecodeAdapter.castToType(appName.split("[-]+"), Object[].class), new _createValidPackageName_closure20(this, this)), ".");
        if (!NameUtils.isValidJavaPackage(defaultPackage)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.appname}, new String[]{"Cannot create a valid package name for [", "]. Please specify a name that is also a valid Java package."})));
        }
        return defaultPackage;
    }

    protected void copySkeleton(Profile profile, Profile participatingProfile, CreateServiceCommandObject cmd) {
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        Object buildMergeProfileNames = callSiteArray[147].callGetProperty(profile);
        Object excludes = callSiteArray[148].callGetProperty(profile);
        if (ScriptBytecodeAdapter.compareEqual(profile, participatingProfile)) {
            List list = ScriptBytecodeAdapter.createList(new Object[0]);
            excludes = list;
        }
        callSiteArray[149].call(excludes, callSiteArray[150].callGroovyObjectGetProperty(cmd));
        String build = ShortTypeHandling.castToString(callSiteArray[151].callGroovyObjectGetProperty(cmd));
        AntBuilder ant = (AntBuilder)ScriptBytecodeAdapter.castToType(callSiteArray[152].callConstructor(ConsoleAntBuilder.class), AntBuilder.class);
        Object skeletonResource = callSiteArray[153].call(callSiteArray[154].callGetProperty(participatingProfile), "skeleton");
        File skeletonDir = null;
        File tmpDir = null;
        if (skeletonResource instanceof FileSystemResource) {
            Object object = callSiteArray[155].callGetProperty(skeletonResource);
            skeletonDir = (File)ScriptBytecodeAdapter.castToType(object, File.class);
        } else {
            Object object = callSiteArray[156].callCurrent(this, ant, skeletonResource);
            tmpDir = (File)ScriptBytecodeAdapter.castToType(object, File.class);
            Object object2 = callSiteArray[157].callConstructor(File.class, tmpDir, "META-INF/profile/skeleton");
            skeletonDir = (File)ScriptBytecodeAdapter.castToType(object2, File.class);
        }
        callSiteArray[158].callCurrent(this, ant, skeletonDir, excludes, callSiteArray[159].callGetProperty(profile));
        callSiteArray[160].callCurrent(this, ant, callSiteArray[161].callConstructor(File.class, skeletonDir, callSiteArray[162].call((Object)build, "-build")), excludes, callSiteArray[163].callGetProperty(profile));
        callSiteArray[164].callCurrent(this, callSiteArray[165].callConstructor(File.class, skeletonDir, callSiteArray[166].call((Object)build, "-build")), build, callSiteArray[167].call(buildMergeProfileNames, callSiteArray[168].callGetProperty(participatingProfile)));
        callSiteArray[169].call((Object)ant, ScriptBytecodeAdapter.createMap(new Object[]{"dir", this.targetDirectory, "includes", callSiteArray[170].call(callSiteArray[171].callGetProperty(profile), " "), "perm", "u+x"}));
    }

    /*
     * WARNING - void declaration
     */
    protected void copySrcToTarget(ConsoleAntBuilder ant, File srcDir, List excludes, Set<String> binaryFileExtensions) {
        void var3_3;
        Reference<File> srcDir2 = new Reference<File>(srcDir);
        Reference<void> excludes2 = new Reference<void>(var3_3);
        Reference<Set<String>> binaryFileExtensions2 = new Reference<Set<String>>(binaryFileExtensions);
        CallSite[] callSiteArray = AbstractCreateCommand.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[172].call(srcDir2.get()))) {
            return;
        }
        public final class _copySrcToTarget_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcDir;
            private /* synthetic */ Reference excludes;
            private /* synthetic */ Reference binaryFileExtensions;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copySrcToTarget_closure21(Object _outerInstance, Object _thisObject, Reference srcDir, Reference excludes, Reference binaryFileExtensions) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _copySrcToTarget_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.srcDir = reference3 = srcDir;
                this.excludes = reference2 = excludes;
                this.binaryFileExtensions = reference = binaryFileExtensions;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copySrcToTarget_closure21.$getCallSiteArray();
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference excludes;
                    private /* synthetic */ Reference binaryFileExtensions;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure35(Object _outerInstance, Object _thisObject, Reference excludes, Reference binaryFileExtensions) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.excludes = reference2 = excludes;
                        this.binaryFileExtensions = reference = binaryFileExtensions;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", "**/.gitkeep"}));
                        Object exc = null;
                        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType(callSiteArray[1].call(this.excludes.get()), Iterator.class);
                        while (iterator.hasNext()) {
                            exc = iterator.next();
                            callSiteArray[2].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", exc}));
                        }
                        callSiteArray[3].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", callSiteArray[4].call((Object)"**/", callSiteArray[5].callGroovyObjectGetProperty(this))}));
                        callSiteArray[6].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", callSiteArray[7].call((Object)"**/", callSiteArray[8].callGroovyObjectGetProperty(this))}));
                        callSiteArray[9].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", "maven-build/"}));
                        callSiteArray[10].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", "gradle-build/"}));
                        public final class _closure38
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure38(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure38.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object ext) {
                                CallSite[] callSiteArray = _closure38.$getCallSiteArray();
                                return callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", new GStringImpl(new Object[]{ext}, new String[]{"**/*.", ""})}));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure38.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "exclude";
                                return new CallSiteArray(_closure38.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure38.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[11].call(this.binaryFileExtensions.get(), new _closure38(this, this.getThisObject()));
                    }

                    public List getExcludes() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType(this.excludes.get(), List.class);
                    }

                    public Set getBinaryFileExtensions() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return (Set)ScriptBytecodeAdapter.castToType(this.binaryFileExtensions.get(), Set.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "exclude";
                        stringArray[1] = "iterator";
                        stringArray[2] = "exclude";
                        stringArray[3] = "exclude";
                        stringArray[4] = "plus";
                        stringArray[5] = "BUILD_GRADLE";
                        stringArray[6] = "exclude";
                        stringArray[7] = "plus";
                        stringArray[8] = "POM_XML";
                        stringArray[9] = "exclude";
                        stringArray[10] = "exclude";
                        stringArray[11] = "each";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[12];
                        _closure35.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure35.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure35.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].callCurrent(this, ScriptBytecodeAdapter.createMap(new Object[]{"dir", this.srcDir.get(), "casesensitive", false}), new _closure35(this, this.getThisObject(), this.excludes, this.binaryFileExtensions));
                public final class _closure36
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure36(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        public final class _closure39
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure39(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object k, Object v) {
                                CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                                return callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"token", k, "value", v}));
                            }

                            public Object call(Object k, Object v) {
                                CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                                return callSiteArray[1].callCurrent(this, k, v);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure39.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "filter";
                                stringArray[1] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure39.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure39.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure39.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty(this), new _closure39(this, this.getThisObject()));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure36.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "each";
                        stringArray[1] = "variables";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure36.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure36.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure36.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[1].callCurrent((GroovyObject)this, new _closure36(this, this.getThisObject()));
                public final class _closure37
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure37(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        public final class _closure40
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure40(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                                public final class _closure41
                                extends Closure
                                implements GeneratedClosure {
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure41(Object _outerInstance, Object _thisObject) {
                                        CallSite[] callSiteArray = _closure41.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                    }

                                    public Object doCall(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure41.$getCallSiteArray();
                                        return callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"from", callSiteArray[1].call(new GStringImpl(new Object[]{k}, new String[]{"@", "@"})), "to", v}));
                                    }

                                    public Object call(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure41.$getCallSiteArray();
                                        return callSiteArray[2].callCurrent(this, k, v);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (this.getClass() != _closure41.class) {
                                            return ScriptBytecodeAdapter.initMetaClass(this);
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "replacestring";
                                        stringArray[1] = "toString";
                                        stringArray[2] = "doCall";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[3];
                                        _closure41.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure41.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure41.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty(this), new _closure41(this, this.getThisObject()));
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure40.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "each";
                                stringArray[1] = "variables";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure40.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure40.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure40.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callCurrent((GroovyObject)this, new _closure40(this, this.getThisObject()));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure37.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "filtermapper";
                        return new CallSiteArray(_closure37.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure37.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[2].callCurrent((GroovyObject)this, new _closure37(this, this.getThisObject()));
            }

            public File getSrcDir() {
                CallSite[] callSiteArray = _copySrcToTarget_closure21.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType(this.srcDir.get(), File.class);
            }

            public List getExcludes() {
                CallSite[] callSiteArray = _copySrcToTarget_closure21.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.excludes.get(), List.class);
            }

            public Set getBinaryFileExtensions() {
                CallSite[] callSiteArray = _copySrcToTarget_closure21.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType(this.binaryFileExtensions.get(), Set.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _copySrcToTarget_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _copySrcToTarget_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "fileSet";
                stringArray[1] = "filterset";
                stringArray[2] = "mapper";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _copySrcToTarget_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copySrcToTarget_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copySrcToTarget_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[173].call(ant, ScriptBytecodeAdapter.createMap(new Object[]{"todir", this.targetDirectory, "overwrite", true, "encoding", "UTF-8"}), new _copySrcToTarget_closure21(this, this, srcDir2, excludes2, binaryFileExtensions2));
        public final class _copySrcToTarget_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcDir;
            private /* synthetic */ Reference binaryFileExtensions;
            private /* synthetic */ Reference excludes;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copySrcToTarget_closure22(Object _outerInstance, Object _thisObject, Reference srcDir, Reference binaryFileExtensions, Reference excludes) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _copySrcToTarget_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.srcDir = reference3 = srcDir;
                this.binaryFileExtensions = reference2 = binaryFileExtensions;
                this.excludes = reference = excludes;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copySrcToTarget_closure22.$getCallSiteArray();
                public final class _closure42
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference binaryFileExtensions;
                    private /* synthetic */ Reference excludes;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure42(Object _outerInstance, Object _thisObject, Reference binaryFileExtensions, Reference excludes) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.binaryFileExtensions = reference2 = binaryFileExtensions;
                        this.excludes = reference = excludes;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                        public final class _closure44
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure44(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure44.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object ext) {
                                CallSite[] callSiteArray = _closure44.$getCallSiteArray();
                                return callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", new GStringImpl(new Object[]{ext}, new String[]{"**/*.", ""})}));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure44.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "include";
                                return new CallSiteArray(_closure44.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure44.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[0].call(this.binaryFileExtensions.get(), new _closure44(this, this.getThisObject()));
                        Object exc = null;
                        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType(callSiteArray[1].call(this.excludes.get()), Iterator.class);
                        while (iterator.hasNext()) {
                            exc = iterator.next();
                            callSiteArray[2].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", exc}));
                        }
                        callSiteArray[3].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", callSiteArray[4].call((Object)"**/", callSiteArray[5].callGroovyObjectGetProperty(this))}));
                        callSiteArray[6].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", callSiteArray[7].call((Object)"**/", callSiteArray[8].callGroovyObjectGetProperty(this))}));
                        callSiteArray[9].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", "maven-build/"}));
                        return callSiteArray[10].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"name", "gradle-build/"}));
                    }

                    public Set getBinaryFileExtensions() {
                        CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                        return (Set)ScriptBytecodeAdapter.castToType(this.binaryFileExtensions.get(), Set.class);
                    }

                    public List getExcludes() {
                        CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType(this.excludes.get(), List.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure42.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "each";
                        stringArray[1] = "iterator";
                        stringArray[2] = "exclude";
                        stringArray[3] = "exclude";
                        stringArray[4] = "plus";
                        stringArray[5] = "BUILD_GRADLE";
                        stringArray[6] = "exclude";
                        stringArray[7] = "plus";
                        stringArray[8] = "POM_XML";
                        stringArray[9] = "exclude";
                        stringArray[10] = "exclude";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[11];
                        _closure42.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure42.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure42.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].callCurrent(this, ScriptBytecodeAdapter.createMap(new Object[]{"dir", this.srcDir.get(), "casesensitive", false}), new _closure42(this, this.getThisObject(), this.binaryFileExtensions, this.excludes));
                public final class _closure43
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure43(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        public final class _closure45
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure45(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                                public final class _closure46
                                extends Closure
                                implements GeneratedClosure {
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure46(Object _outerInstance, Object _thisObject) {
                                        CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                    }

                                    public Object doCall(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                                        return callSiteArray[0].callCurrent((GroovyObject)this, ScriptBytecodeAdapter.createMap(new Object[]{"from", callSiteArray[1].call(new GStringImpl(new Object[]{k}, new String[]{"@", "@"})), "to", v}));
                                    }

                                    public Object call(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                                        return callSiteArray[2].callCurrent(this, k, v);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (this.getClass() != _closure46.class) {
                                            return ScriptBytecodeAdapter.initMetaClass(this);
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "replacestring";
                                        stringArray[1] = "toString";
                                        stringArray[2] = "doCall";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[3];
                                        _closure46.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure46.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure46.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty(this), new _closure46(this, this.getThisObject()));
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure45.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "each";
                                stringArray[1] = "variables";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure45.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure45.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure45.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callCurrent((GroovyObject)this, new _closure45(this, this.getThisObject()));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _closure43.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "filtermapper";
                        return new CallSiteArray(_closure43.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure43.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[1].callCurrent((GroovyObject)this, new _closure43(this, this.getThisObject()));
            }

            public File getSrcDir() {
                CallSite[] callSiteArray = _copySrcToTarget_closure22.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType(this.srcDir.get(), File.class);
            }

            public Set getBinaryFileExtensions() {
                CallSite[] callSiteArray = _copySrcToTarget_closure22.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType(this.binaryFileExtensions.get(), Set.class);
            }

            public List getExcludes() {
                CallSite[] callSiteArray = _copySrcToTarget_closure22.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType(this.excludes.get(), List.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _copySrcToTarget_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _copySrcToTarget_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "fileSet";
                stringArray[1] = "mapper";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _copySrcToTarget_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copySrcToTarget_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copySrcToTarget_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[174].call(ant, ScriptBytecodeAdapter.createMap(new Object[]{"todir", this.targetDirectory, "overwrite", true}), new _copySrcToTarget_closure22(this, this, srcDir2, binaryFileExtensions2, excludes2));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractCreateCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractCreateCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, AbstractCreateCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AbstractCreateCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    protected static Set<Feature> addDependentFeatures(Profile profile, Set<Feature> features) {
        return AbstractCreateCommand.addDependentFeatures(profile, features, false);
    }

    static {
        String string;
        String string2 = System.getProperty("file.encoding");
        ENCODING = string = DefaultTypeTransformation.booleanUnbox(string2) ? string2 : "UTF-8";
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Generated
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Generated
    public void setVariables(Map<String, String> map) {
        this.variables = map;
    }

    @Generated
    public boolean getInplace() {
        return this.inplace;
    }

    @Generated
    public boolean isInplace() {
        return this.inplace;
    }

    @Generated
    public void setInplace(boolean bl) {
        this.inplace = bl;
    }

    @Generated
    public String getProfile() {
        return this.profile;
    }

    @Generated
    public void setProfile(String string) {
        this.profile = string;
    }

    @Generated
    public List<String> getFeatures() {
        return this.features;
    }

    @Generated
    public void setFeatures(List<String> list) {
        this.features = list;
    }

    @Generated
    public String getAppname() {
        return this.appname;
    }

    @Generated
    public void setAppname(String string) {
        this.appname = string;
    }

    @Generated
    public String getGroupname() {
        return this.groupname;
    }

    @Generated
    public void setGroupname(String string) {
        this.groupname = string;
    }

    @Generated
    public String getDefaultpackagename() {
        return this.defaultpackagename;
    }

    @Generated
    public void setDefaultpackagename(String string) {
        this.defaultpackagename = string;
    }

    @Generated
    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Generated
    public void setTargetDirectory(File file) {
        this.targetDirectory = file;
    }

    public /* synthetic */ void super$2$setCommandSpec(CommandLine.Model.CommandSpec commandSpec) {
        super.setCommandSpec(commandSpec);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "exists";
        stringArray[2] = "findAllFilesByName";
        stringArray[3] = "each";
        stringArray[4] = "findAllFilesByName";
        stringArray[5] = "each";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "profileName";
        stringArray[8] = "getProfile";
        stringArray[9] = "validateProfile";
        stringArray[10] = "validateBuild";
        stringArray[11] = "build";
        stringArray[12] = "any";
        stringArray[13] = "features";
        stringArray[14] = "error";
        stringArray[15] = "instance";
        stringArray[16] = "toList";
        stringArray[17] = "evaluateFeatures";
        stringArray[18] = "features";
        stringArray[19] = "lang";
        stringArray[20] = "initializeGroupAndName";
        stringArray[21] = "appName";
        stringArray[22] = "inplace";
        stringArray[23] = "initializeVariables";
        stringArray[24] = "micronautVersion";
        stringArray[25] = "get";
        stringArray[26] = "path";
        stringArray[27] = "baseDir";
        stringArray[28] = "inplace";
        stringArray[29] = "canonicalFile";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "toFile";
        stringArray[32] = "normalize";
        stringArray[33] = "toAbsolutePath";
        stringArray[34] = "exists";
        stringArray[35] = "inplace";
        stringArray[36] = "error";
        stringArray[37] = "instance";
        stringArray[38] = "getProfileAndDependencies";
        stringArray[39] = "buildTargetFolders";
        stringArray[40] = "iterator";
        stringArray[41] = "findAllFilesByName";
        stringArray[42] = "getAt";
        stringArray[43] = "each";
        stringArray[44] = "copySkeleton";
        stringArray[45] = "iterator";
        stringArray[46] = "entrySet";
        stringArray[47] = "exists";
        stringArray[48] = "getKey";
        stringArray[49] = "appendToYmlSubDocument";
        stringArray[50] = "getKey";
        stringArray[51] = "getValue";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "iterator";
        stringArray[54] = "location";
        stringArray[55] = "file";
        stringArray[56] = "createRelative";
        stringArray[57] = "unzipProfile";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "name";
        stringArray[60] = "getAt";
        stringArray[61] = "profile";
        stringArray[62] = "appendFeatureFiles";
        stringArray[63] = "build";
        stringArray[64] = "plus";
        stringArray[65] = "addAll";
        stringArray[66] = "skeletonExcludes";
        stringArray[67] = "exists";
        stringArray[68] = "copySrcToTarget";
        stringArray[69] = "binaryExtensions";
        stringArray[70] = "copySrcToTarget";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "plus";
        stringArray[73] = "build";
        stringArray[74] = "binaryExtensions";
        stringArray[75] = "chmod";
        stringArray[76] = "join";
        stringArray[77] = "executablePatterns";
        stringArray[78] = "replaceBuildTokens";
        stringArray[79] = "messageOnComplete";
        stringArray[80] = "console";
        stringArray[81] = "instructions";
        stringArray[82] = "addStatus";
        stringArray[83] = "console";
        stringArray[84] = "instructions";
        stringArray[85] = "tiggerAppLoad";
        stringArray[86] = "error";
        stringArray[87] = "getInstance";
        stringArray[88] = "URL";
        stringArray[89] = "get";
        stringArray[90] = "findJarFile";
        stringArray[91] = "createTempDir";
        stringArray[92] = "deleteOnExit";
        stringArray[93] = "unzip";
        stringArray[94] = "put";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "findAll";
        stringArray[97] = "name";
        stringArray[98] = "evaluateTestFramework";
        stringArray[99] = "evaluateSourceLanguage";
        stringArray[100] = "evaluateTestFramework";
        stringArray[101] = "evaluateSourceLanguage";
        stringArray[102] = "build";
        stringArray[103] = "<$constructor$>";
        stringArray[104] = "build";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "getTokens";
        stringArray[107] = "put";
        stringArray[108] = "micronautVersion";
        stringArray[109] = "replace";
        stringArray[110] = "withTokens";
        stringArray[111] = "populateFeatures";
        stringArray[112] = "getAt";
        stringArray[113] = "getAt";
        stringArray[114] = "addDependentFeatures";
        stringArray[115] = "pruneOneOfFeatures";
        stringArray[116] = "capitalize";
        stringArray[117] = "getLanguage";
        stringArray[118] = "addStatus";
        stringArray[119] = "getInstance";
        stringArray[120] = "findAll";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "append";
        stringArray[123] = "getProperty";
        stringArray[124] = "append";
        stringArray[125] = "join";
        stringArray[126] = "warn";
        stringArray[127] = "getInstance";
        stringArray[128] = "toString";
        stringArray[129] = "features";
        stringArray[130] = "intersect";
        stringArray[131] = "add";
        stringArray[132] = "removeAll";
        stringArray[133] = "each";
        stringArray[134] = "findAll";
        stringArray[135] = "features";
        stringArray[136] = "addAll";
        stringArray[137] = "addAll";
        stringArray[138] = "defaultFeatures";
        stringArray[139] = "find";
        stringArray[140] = "features";
        stringArray[141] = "add";
        stringArray[142] = "addAll";
        stringArray[143] = "requiredFeatures";
        stringArray[144] = "toSet";
        stringArray[145] = "each";
        stringArray[146] = "addDependentFeatures";
        stringArray[147] = "buildMergeProfileNames";
        stringArray[148] = "skeletonExcludes";
        stringArray[149] = "addAll";
        stringArray[150] = "skeletonExclude";
        stringArray[151] = "build";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "createRelative";
        stringArray[154] = "profileDir";
        stringArray[155] = "file";
        stringArray[156] = "unzipProfile";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "copySrcToTarget";
        stringArray[159] = "binaryExtensions";
        stringArray[160] = "copySrcToTarget";
        stringArray[161] = "<$constructor$>";
        stringArray[162] = "plus";
        stringArray[163] = "binaryExtensions";
        stringArray[164] = "copyBuildFiles";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "plus";
        stringArray[167] = "contains";
        stringArray[168] = "name";
        stringArray[169] = "chmod";
        stringArray[170] = "join";
        stringArray[171] = "executablePatterns";
        stringArray[172] = "exists";
        stringArray[173] = "copy";
        stringArray[174] = "copy";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[175];
        AbstractCreateCommand.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractCreateCommand.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractCreateCommand.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class FeatureCompletionCandidates
    implements Iterable<String>,
    GroovyObject {
        private AbstractCreateCommand createCommand;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public FeatureCompletionCandidates() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public Iterator<String> iterator() {
            String string;
            if (!DefaultTypeTransformation.booleanUnbox(this.createCommand)) {
                return Collections.emptyIterator();
            }
            Profile profile = this.createCommand.getProfileRepository().getProfile(DefaultTypeTransformation.booleanUnbox(string = this.createCommand.getProfile()) ? string : this.createCommand.getDefaultProfile());
            public final class _iterator_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _iterator_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Feature f) {
                    return f.getName();
                }

                public Object call(Feature f) {
                    return this.doCall(f);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _iterator_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Reference featureNames = new Reference(DefaultGroovyMethods.collect(profile.getFeatures(), new _iterator_closure1(this, this)));
            if (this.createCommand instanceof AbstractCreateAppCommand) {
                public final class _iterator_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference featureNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _iterator_closure2(Object _outerInstance, Object _thisObject, Reference featureNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.featureNames = reference = featureNames;
                    }

                    public Object doCall(Object it) {
                        return ((List)this.featureNames.get()).remove(((SupportedLanguage)it).name());
                    }

                    public Object getFeatureNames() {
                        return this.featureNames.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _iterator_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((Object[])ScriptBytecodeAdapter.castToType(SupportedLanguage.values(), Object[].class), (Closure)new _iterator_closure2(this, this, featureNames));
            }
            if (!DefaultTypeTransformation.booleanUnbox(this.createCommand.getFeatures())) {
                return featureNames.get().iterator();
            }
            public final class _iterator_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _iterator_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(String f) {
                    return !((FeatureCompletionCandidates)this.getThisObject()).createCommand.getFeatures().contains(f);
                }

                public Object call(String f) {
                    return this.doCall(f);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _iterator_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return DefaultGroovyMethods.findAll(featureNames.get(), (Closure)new _iterator_closure3(this, this)).iterator();
        }

        public static void initCommandArgs(AbstractCreateCommand command) {
            Reference<AbstractCreateCommand> command2 = new Reference<AbstractCreateCommand>(command);
            public final class _initCommandArgs_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference command;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _initCommandArgs_closure4(Object _outerInstance, Object _thisObject, Reference command) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.command = reference = command;
                }

                public Object doCall(Object it) {
                    FeatureCompletionCandidates.init(((CommandLine.Model.OptionSpec)it).completionCandidates(), (AbstractCreateCommand)ScriptBytecodeAdapter.castToType(this.command.get(), AbstractCreateCommand.class));
                    return null;
                }

                public AbstractCreateCommand getCommand() {
                    return (AbstractCreateCommand)ScriptBytecodeAdapter.castToType(this.command.get(), AbstractCreateCommand.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _initCommandArgs_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(command2.get().getCommandSpec().options(), (Closure)new _initCommandArgs_closure4(FeatureCompletionCandidates.class, AbstractCreateCommand.class, command2));
            public final class _initCommandArgs_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference command;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _initCommandArgs_closure5(Object _outerInstance, Object _thisObject, Reference command) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.command = reference = command;
                }

                public Object doCall(Object it) {
                    FeatureCompletionCandidates.init(((CommandLine.Model.PositionalParamSpec)it).completionCandidates(), (AbstractCreateCommand)ScriptBytecodeAdapter.castToType(this.command.get(), AbstractCreateCommand.class));
                    return null;
                }

                public AbstractCreateCommand getCommand() {
                    return (AbstractCreateCommand)ScriptBytecodeAdapter.castToType(this.command.get(), AbstractCreateCommand.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _initCommandArgs_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(command2.get().getCommandSpec().positionalParameters(), (Closure)new _initCommandArgs_closure5(FeatureCompletionCandidates.class, AbstractCreateCommand.class, command2));
        }

        private static void init(Object candidates, AbstractCreateCommand command) {
            if (candidates instanceof FeatureCompletionCandidates) {
                AbstractCreateCommand abstractCreateCommand = command;
                ScriptBytecodeAdapter.setGroovyObjectProperty(abstractCreateCommand, FeatureCompletionCandidates.class, (FeatureCompletionCandidates)ScriptBytecodeAdapter.castToType(candidates, FeatureCompletionCandidates.class), "createCommand");
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != FeatureCompletionCandidates.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(FeatureCompletionCandidates.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(FeatureCompletionCandidates.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(FeatureCompletionCandidates.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(FeatureCompletionCandidates.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }
    }

    public static class CreateServiceCommandObject
    implements GroovyObject {
        private String appName;
        private File baseDir;
        private String profileName;
        private String micronautVersion;
        private Set<String> features;
        private String lang;
        private boolean inplace;
        private String build;
        private MicronautConsole console;
        private List<String> skeletonExclude;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public CreateServiceCommandObject() {
            MetaClass metaClass;
            List list;
            String string;
            boolean bl;
            this.inplace = bl = false;
            this.build = string = "gradle";
            this.skeletonExclude = list = ScriptBytecodeAdapter.createList(new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CreateServiceCommandObject.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(CreateServiceCommandObject.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(CreateServiceCommandObject.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CreateServiceCommandObject.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CreateServiceCommandObject.class, AbstractCreateCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }

        @Generated
        public String getAppName() {
            return this.appName;
        }

        @Generated
        public void setAppName(String string) {
            this.appName = string;
        }

        @Generated
        public File getBaseDir() {
            return this.baseDir;
        }

        @Generated
        public void setBaseDir(File file) {
            this.baseDir = file;
        }

        @Generated
        public String getProfileName() {
            return this.profileName;
        }

        @Generated
        public void setProfileName(String string) {
            this.profileName = string;
        }

        @Generated
        public String getMicronautVersion() {
            return this.micronautVersion;
        }

        @Generated
        public void setMicronautVersion(String string) {
            this.micronautVersion = string;
        }

        @Generated
        public Set<String> getFeatures() {
            return this.features;
        }

        @Generated
        public void setFeatures(Set<String> set) {
            this.features = set;
        }

        @Generated
        public String getLang() {
            return this.lang;
        }

        @Generated
        public void setLang(String string) {
            this.lang = string;
        }

        @Generated
        public boolean getInplace() {
            return this.inplace;
        }

        @Generated
        public boolean isInplace() {
            return this.inplace;
        }

        @Generated
        public void setInplace(boolean bl) {
            this.inplace = bl;
        }

        @Generated
        public String getBuild() {
            return this.build;
        }

        @Generated
        public void setBuild(String string) {
            this.build = string;
        }

        @Generated
        public MicronautConsole getConsole() {
            return this.console;
        }

        @Generated
        public void setConsole(MicronautConsole micronautConsole) {
            this.console = micronautConsole;
        }

        @Generated
        public List<String> getSkeletonExclude() {
            return this.skeletonExclude;
        }

        @Generated
        public void setSkeletonExclude(List<String> list) {
            this.skeletonExclude = list;
        }
    }
}

