# Node.js 16 ChangeLog

<!--lint disable prohibited-strings-->
<!--lint disable maximum-line-length-->
<!--lint disable no-literal-urls-->

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#16.4.0">16.4.0</a><br/>
<a href="#16.3.0">16.3.0</a><br/>
<a href="#16.2.0">16.2.0</a><br/>
<a href="#16.1.0">16.1.0</a><br/>
<a href="#16.0.0">16.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [15.x](CHANGELOG_V15.md)
  * [14.x](CHANGELOG_V14.md)
  * [13.x](CHANGELOG_V13.md)
  * [12.x](CHANGELOG_V12.md)
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [9.x](CHANGELOG_V9.md)
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="16.4.0"></a>
## 2021-06-23, Version 16.4.0 (Current), @danielleadams

### Notable changes

* **async_hooks**:
  * stabilize part of AsyncLocalStorage (Vladimir de Turckheim) [#37675](https://github.com/nodejs/node/pull/37675)
* **deps**:
  * upgrade npm to 7.18.1 (npm-robot) [#39065](https://github.com/nodejs/node/pull/39065)
  * update V8 to 9.1.269.36 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* **dns**:
  * allow `--dns-result-order` to change default dns verbatim (Ouyang Yadong) [#38099](https://github.com/nodejs/node/pull/38099)

### Commits

* [[`d2b972ee52`](https://github.com/nodejs/node/commit/d2b972ee52)] - **async_hooks**: check for empty contexts before removing (Bryan English) [#39095](https://github.com/nodejs/node/pull/39095)
* [[`03e75fda4c`](https://github.com/nodejs/node/commit/03e75fda4c)] - **async_hooks**: switch between native and context hooks correctly (Stephen Belanger) [#38912](https://github.com/nodejs/node/pull/38912)
* [[`8115e6ee6d`](https://github.com/nodejs/node/commit/8115e6ee6d)] - **(SEMVER-MINOR)** **async_hooks**: stabilize part of AsyncLocalStorage (Vladimir de Turckheim) [#37675](https://github.com/nodejs/node/pull/37675)
* [[`5f51729014`](https://github.com/nodejs/node/commit/5f51729014)] - **bootstrap**: move event loop handle checking into snapshot builder (Joyee Cheung) [#39007](https://github.com/nodejs/node/pull/39007)
* [[`9d100aa269`](https://github.com/nodejs/node/commit/9d100aa269)] - **bootstrap**: split NodeMainInstance::Run() (Joyee Cheung) [#39007](https://github.com/nodejs/node/pull/39007)
* [[`2aaf2f231f`](https://github.com/nodejs/node/commit/2aaf2f231f)] - **build**: reconfigure when gyp files change on Windows (Joyee Cheung) [#39066](https://github.com/nodejs/node/pull/39066)
* [[`7f225a05ee`](https://github.com/nodejs/node/commit/7f225a05ee)] - ***Revert*** "**build**: work around bug in MSBuild v16.10.0" (Michaël Zasso) [#38977](https://github.com/nodejs/node/pull/38977)
* [[`1853127dde`](https://github.com/nodejs/node/commit/1853127dde)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`c0d236f5ea`](https://github.com/nodejs/node/commit/c0d236f5ea)] - **build**: make build-addons errors fail the build (Richard Lau) [#38983](https://github.com/nodejs/node/pull/38983)
* [[`173292bcf8`](https://github.com/nodejs/node/commit/173292bcf8)] - **build**: fix commit-queue default branch (Mary Marchini) [#38998](https://github.com/nodejs/node/pull/38998)
* [[`e939e243bf`](https://github.com/nodejs/node/commit/e939e243bf)] - **build**: don't pass python override to V8 build (Richard Lau) [#38969](https://github.com/nodejs/node/pull/38969)
* [[`651c58b412`](https://github.com/nodejs/node/commit/651c58b412)] - **build**: correct Xcode spelling in .gitignore (bl-ue) [#38895](https://github.com/nodejs/node/pull/38895)
* [[`5203c9ced7`](https://github.com/nodejs/node/commit/5203c9ced7)] - **build**: fast-track npm PRs and dont-land them on LTS (Michaël Zasso) [#38885](https://github.com/nodejs/node/pull/38885)
* [[`7de57d4d33`](https://github.com/nodejs/node/commit/7de57d4d33)] - **build**: dont-land gyp-next PRs on LTS branches (Michaël Zasso) [#38887](https://github.com/nodejs/node/pull/38887)
* [[`e87cd4542b`](https://github.com/nodejs/node/commit/e87cd4542b)] - **child_process**: refactor to use `validateBoolean` (Qingyu Deng) [#38927](https://github.com/nodejs/node/pull/38927)
* [[`69fa9e16e9`](https://github.com/nodejs/node/commit/69fa9e16e9)] - **(SEMVER-MINOR)** **child_process**: allow `options.cwd` receive a URL (Khaidi Chu) [#38862](https://github.com/nodejs/node/pull/38862)
* [[`cf9d686c35`](https://github.com/nodejs/node/commit/cf9d686c35)] - **crypto**: fix aes crash when tag length too small (Khaidi Chu) [#38914](https://github.com/nodejs/node/pull/38914)
* [[`1799ea36f0`](https://github.com/nodejs/node/commit/1799ea36f0)] - **crypto**: use compatible version of EVP\_CIPHER\_name (Shelley Vohr) [#38925](https://github.com/nodejs/node/pull/38925)
* [[`6d5dc63ae4`](https://github.com/nodejs/node/commit/6d5dc63ae4)] - **crypto**: fix label cast in EVP\_PKEY\_CTX\_set0\_rsa\_oaep\_label (Shelley Vohr) [#38926](https://github.com/nodejs/node/pull/38926)
* [[`6e93c17bf5`](https://github.com/nodejs/node/commit/6e93c17bf5)] - **crypto**: use EVP\_get\_cipherbynid directly (Shelley Vohr) [#38901](https://github.com/nodejs/node/pull/38901)
* [[`82c293959e`](https://github.com/nodejs/node/commit/82c293959e)] - **crypto**: add missing rand.h include (Shelley Vohr) [#38864](https://github.com/nodejs/node/pull/38864)
* [[`e4f802de9a`](https://github.com/nodejs/node/commit/e4f802de9a)] - **debugger**: rename internal library for clarity (Rich Trott) [#39080](https://github.com/nodejs/node/pull/39080)
* [[`1e8bdab581`](https://github.com/nodejs/node/commit/1e8bdab581)] - **debugger**: use ERR\_DEBUGGER\_STARTUP\_ERROR in \_inspect.js (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`b43cb69fbb`](https://github.com/nodejs/node/commit/b43cb69fbb)] - **debugger**: use error codes in debugger REPL (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`dc9218136b`](https://github.com/nodejs/node/commit/dc9218136b)] - **debugger**: use ERR\_DEBUGGER\_ERROR in debugger client (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`711916a271`](https://github.com/nodejs/node/commit/711916a271)] - **debugger**: remove unnecessary boilerplate copyright comment (Rich Trott) [#38952](https://github.com/nodejs/node/pull/38952)
* [[`0f65e41442`](https://github.com/nodejs/node/commit/0f65e41442)] - **debugger**: reduce scope of eslint disable comment (Rich Trott) [#38946](https://github.com/nodejs/node/pull/38946)
* [[`1fa724ec5a`](https://github.com/nodejs/node/commit/1fa724ec5a)] - **deps**: upgrade npm to 7.18.1 (npm-robot) [#39065](https://github.com/nodejs/node/pull/39065)
* [[`c6aa68598d`](https://github.com/nodejs/node/commit/c6aa68598d)] - **deps**: upgrade npm to 7.17.0 (npm-robot) [#38999](https://github.com/nodejs/node/pull/38999)
* [[`864fe9910b`](https://github.com/nodejs/node/commit/864fe9910b)] - **deps**: make V8 9.1 abi-compatible with 9.0 (Michaël Zasso) [#38991](https://github.com/nodejs/node/pull/38991)
* [[`c93f3573eb`](https://github.com/nodejs/node/commit/c93f3573eb)] - **deps**: V8: cherry-pick fa4cb172cde2 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`3c6c28b0a1`](https://github.com/nodejs/node/commit/3c6c28b0a1)] - **deps**: V8: cherry-pick 4c074516397b (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`3c37396d5c`](https://github.com/nodejs/node/commit/3c37396d5c)] - **deps**: V8: cherry-pick 5f4413194480 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`3433559a55`](https://github.com/nodejs/node/commit/3433559a55)] - **deps**: V8: cherry-pick 272445f10927 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`f56c78574e`](https://github.com/nodejs/node/commit/f56c78574e)] - **deps**: V8: cherry-pick c0fceaa0669b (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`7197fcec93`](https://github.com/nodejs/node/commit/7197fcec93)] - **deps**: V8: cherry-pick d59db06bf542 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`bf7aa9fef8`](https://github.com/nodejs/node/commit/bf7aa9fef8)] - **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`eac377bc15`](https://github.com/nodejs/node/commit/eac377bc15)] - **deps**: V8: backport aaacffa1e003 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`1a7c8a12c1`](https://github.com/nodejs/node/commit/1a7c8a12c1)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`3c9a75522b`](https://github.com/nodejs/node/commit/3c9a75522b)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`8ed258339a`](https://github.com/nodejs/node/commit/8ed258339a)] - **deps**: V8: forward declaration of `Rtl*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`4ef37c83a9`](https://github.com/nodejs/node/commit/4ef37c83a9)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`7c61c6ee25`](https://github.com/nodejs/node/commit/7c61c6ee25)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`e82ef4148e`](https://github.com/nodejs/node/commit/e82ef4148e)] - **(SEMVER-MINOR)** **deps**: update V8 to 9.1.269.36 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`70af146745`](https://github.com/nodejs/node/commit/70af146745)] - **deps**: upgrade npm to 7.16.0 (npm-robot) [#38920](https://github.com/nodejs/node/pull/38920)
* [[`a71df7630e`](https://github.com/nodejs/node/commit/a71df7630e)] - **(SEMVER-MINOR)** **dns**: allow `--dns-result-order` to change default dns verbatim (Ouyang Yadong) [#38099](https://github.com/nodejs/node/pull/38099)
* [[`dce256b210`](https://github.com/nodejs/node/commit/dce256b210)] - **doc**: remove references to deleted freenode channels (devsnek) [#39047](https://github.com/nodejs/node/pull/39047)
* [[`1afff98805`](https://github.com/nodejs/node/commit/1afff98805)] - **doc**: fix typos (bl-ue) [#39049](https://github.com/nodejs/node/pull/39049)
* [[`858f66e691`](https://github.com/nodejs/node/commit/858f66e691)] - **doc**: add missing parameter types (Voltrex) [#39013](https://github.com/nodejs/node/pull/39013)
* [[`ed91379186`](https://github.com/nodejs/node/commit/ed91379186)] - **doc**: clearify that http does chunked encoding itself (Mao Wtm) [#28379](https://github.com/nodejs/node/pull/28379)
* [[`51561f390a`](https://github.com/nodejs/node/commit/51561f390a)] - **doc**: add missing changelog links (Antoine du Hamel) [#39016](https://github.com/nodejs/node/pull/39016)
* [[`a19170eb9d`](https://github.com/nodejs/node/commit/a19170eb9d)] - **doc**: clarify that only one Python version is required to build (bl-ue) [#38894](https://github.com/nodejs/node/pull/38894)
* [[`7b219992e0`](https://github.com/nodejs/node/commit/7b219992e0)] - **doc**: fix markup for aesImportParams (Tobias Nießen) [#38898](https://github.com/nodejs/node/pull/38898)
* [[`405b50cdba`](https://github.com/nodejs/node/commit/405b50cdba)] - **doc**: use `await` in filehandle.truncate() snippet (RA80533) [#38939](https://github.com/nodejs/node/pull/38939)
* [[`5218fe86d1`](https://github.com/nodejs/node/commit/5218fe86d1)] - **doc**: fixed typo in process.md (Derevianchenko Maksym) [#38941](https://github.com/nodejs/node/pull/38941)
* [[`f903ad85f2`](https://github.com/nodejs/node/commit/f903ad85f2)] - **doc**: add missing semis after classes (Darshan Sen) [#38931](https://github.com/nodejs/node/pull/38931)
* [[`0bdeeda3b5`](https://github.com/nodejs/node/commit/0bdeeda3b5)] - **doc**: update write callback documentation (Simone Busoli) [#38959](https://github.com/nodejs/node/pull/38959)
* [[`7a7c0588ad`](https://github.com/nodejs/node/commit/7a7c0588ad)] - **doc**: mark util.inherits as legacy (Voltrex) [#38896](https://github.com/nodejs/node/pull/38896)
* [[`f6964dc506`](https://github.com/nodejs/node/commit/f6964dc506)] - **doc**: clarify when `readable._read(...)` is called (Shaun Keys) [#38726](https://github.com/nodejs/node/pull/38726)
* [[`3481b02e77`](https://github.com/nodejs/node/commit/3481b02e77)] - **doc**: mark Node.js v15.x as EOL (Antoine du Hamel) [#38891](https://github.com/nodejs/node/pull/38891)
* [[`17a9846920`](https://github.com/nodejs/node/commit/17a9846920)] - **doc**: fix .mjs syntax in crypto.md (himself65) [#38882](https://github.com/nodejs/node/pull/38882)
* [[`8c7b2bab5f`](https://github.com/nodejs/node/commit/8c7b2bab5f)] - **doc,fs**: remove experimental status for WHATWG URL as path (Antoine du Hamel) [#38870](https://github.com/nodejs/node/pull/38870)
* [[`eddde6c31a`](https://github.com/nodejs/node/commit/eddde6c31a)] - **errors**: don't rekey on primitive type (Benjamin Coe) [#39025](https://github.com/nodejs/node/pull/39025)
* [[`3d7892ef39`](https://github.com/nodejs/node/commit/3d7892ef39)] - **errors**: add ERR\_DEBUGGER\_STARTUP\_ERROR (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`631856ea32`](https://github.com/nodejs/node/commit/631856ea32)] - **errors**: add ERR\_DEBUGGER\_ERROR (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`336571fbdd`](https://github.com/nodejs/node/commit/336571fbdd)] - ***Revert*** "**http**: make HEAD method to work with keep-alive" (Michaël Zasso) [#38949](https://github.com/nodejs/node/pull/38949)
* [[`c2b4fbba0f`](https://github.com/nodejs/node/commit/c2b4fbba0f)] - **lib**: remove semicolon in preparation for babel/eslint-parser update (Rich Trott) [#39094](https://github.com/nodejs/node/pull/39094)
* [[`f17dde81f3`](https://github.com/nodejs/node/commit/f17dde81f3)] - **lib**: make internal/options lazy (Joyee Cheung) [#38993](https://github.com/nodejs/node/pull/38993)
* [[`551430514b`](https://github.com/nodejs/node/commit/551430514b)] - **lib**: add JSDoc typings for child\_process (Voltrex) [#38222](https://github.com/nodejs/node/pull/38222)
* [[`ded83350a0`](https://github.com/nodejs/node/commit/ded83350a0)] - **lib**: make primordials Promise methods safe (Antoine du Hamel) [#38650](https://github.com/nodejs/node/pull/38650)
* [[`637c1fa83c`](https://github.com/nodejs/node/commit/637c1fa83c)] - **lib**: refactor debuglog init (Antoine du Hamel) [#38838](https://github.com/nodejs/node/pull/38838)
* [[`5b5e07a2cc`](https://github.com/nodejs/node/commit/5b5e07a2cc)] - **meta**: update label-pr-config (Michaël Zasso) [#38950](https://github.com/nodejs/node/pull/38950)
* [[`92ed1c6cce`](https://github.com/nodejs/node/commit/92ed1c6cce)] - **module**: fix legacy `node` specifier resolution to resolve `"main"` field (Antoine du Hamel) [#38979](https://github.com/nodejs/node/pull/38979)
* [[`4174f139b6`](https://github.com/nodejs/node/commit/4174f139b6)] - **net**: use missing validator (Voltrex) [#38984](https://github.com/nodejs/node/pull/38984)
* [[`f7724ab342`](https://github.com/nodejs/node/commit/f7724ab342)] - **node-api**: avoid crashing on passed-in null string (Gabriel Schulhof) [#38923](https://github.com/nodejs/node/pull/38923)
* [[`ec3e5b4c15`](https://github.com/nodejs/node/commit/ec3e5b4c15)] - **node-api**: avoid SecondPassCallback crash (Michael Dawson) [#38899](https://github.com/nodejs/node/pull/38899)
* [[`74f5e30d69`](https://github.com/nodejs/node/commit/74f5e30d69)] - **node-api**: rtn pending excep on napi\_new\_instance (legendecas) [#38798](https://github.com/nodejs/node/pull/38798)
* [[`4c6193fea1`](https://github.com/nodejs/node/commit/4c6193fea1)] - **report**: generates report on threads with no isolates (legendecas) [#38994](https://github.com/nodejs/node/pull/38994)
* [[`3c7a7d9ee4`](https://github.com/nodejs/node/commit/3c7a7d9ee4)] - **(SEMVER-MINOR)** **src**: allow to negate boolean CLI flags (Michaël Zasso) [#39023](https://github.com/nodejs/node/pull/39023)
* [[`284d9c6228`](https://github.com/nodejs/node/commit/284d9c6228)] - **src**: cleanup uv\_fs\_t regardless of success or not (legendecas) [#38996](https://github.com/nodejs/node/pull/38996)
* [[`902bb858d7`](https://github.com/nodejs/node/commit/902bb858d7)] - **src**: refactor to use locale functions (Darshan Sen) [#39014](https://github.com/nodejs/node/pull/39014)
* [[`10370c5e8a`](https://github.com/nodejs/node/commit/10370c5e8a)] - **src**: fix multiple AddLinkedBinding() calls (Anna Henningsen) [#39012](https://github.com/nodejs/node/pull/39012)
* [[`ff8313c3a5`](https://github.com/nodejs/node/commit/ff8313c3a5)] - **src**: throw error in LoadBuiltinModuleSource when reading fails (Joyee Cheung) [#38904](https://github.com/nodejs/node/pull/38904)
* [[`9ba5518f08`](https://github.com/nodejs/node/commit/9ba5518f08)] - **src**: skip test\_fatal/test\_threads for Debug builds (Daniel Bevenius) [#38805](https://github.com/nodejs/node/pull/38805)
* [[`06afb8df65`](https://github.com/nodejs/node/commit/06afb8df65)] - **(SEMVER-MINOR)** **src**: make InitializeOncePerProcess more flexible (Shelley Vohr) [#38888](https://github.com/nodejs/node/pull/38888)
* [[`db4b192113`](https://github.com/nodejs/node/commit/db4b192113)] - **src**: add not-weak DCHECK to PersistentToLocal::Strong (Anna Henningsen) [#38875](https://github.com/nodejs/node/pull/38875)
* [[`08b2a4a138`](https://github.com/nodejs/node/commit/08b2a4a138)] - **src,test**: raise error for --enable-fips when no FIPS (Daniel Bevenius) [#38859](https://github.com/nodejs/node/pull/38859)
* [[`5d92c09bbf`](https://github.com/nodejs/node/commit/5d92c09bbf)] - **src,url**: separate some tables out of node\_url.cc (Khaidi Chu) [#38988](https://github.com/nodejs/node/pull/38988)
* [[`c20e28e1a0`](https://github.com/nodejs/node/commit/c20e28e1a0)] - **stream**: fix pipeline pump (Robert Nagy) [#39006](https://github.com/nodejs/node/pull/39006)
* [[`7b026d8a72`](https://github.com/nodejs/node/commit/7b026d8a72)] - **test**: move inspector-cli tests to sequential (Rich Trott) [#39079](https://github.com/nodejs/node/pull/39079)
* [[`a53911b166`](https://github.com/nodejs/node/commit/a53911b166)] - **test**: improve buffer coverage (Rongjian Zhang) [#38538](https://github.com/nodejs/node/pull/38538)
* [[`5e9175f148`](https://github.com/nodejs/node/commit/5e9175f148)] - **test**: fix name of variable in inspector-cli test (Tobias Nießen) [#38869](https://github.com/nodejs/node/pull/38869)
* [[`bd924610ec`](https://github.com/nodejs/node/commit/bd924610ec)] - **test**: fix typo (Houssem Chebab) [#39045](https://github.com/nodejs/node/pull/39045)
* [[`d50df5dec1`](https://github.com/nodejs/node/commit/d50df5dec1)] - **test**: fix typo in test-http2-invalidheaderfield.js (Ikko Ashimine) [#39021](https://github.com/nodejs/node/pull/39021)
* [[`6111671d45`](https://github.com/nodejs/node/commit/6111671d45)] - **test**: adapt abort tests for new Windows code (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`1816d46cef`](https://github.com/nodejs/node/commit/1816d46cef)] - **test**: adapt test-linux-perf to V8 changes (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`32961c4781`](https://github.com/nodejs/node/commit/32961c4781)] - **test**: fix V8 serdes test for V8 9.1 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`f652284b3b`](https://github.com/nodejs/node/commit/f652284b3b)] - **test**: remove obsolete TLS test (Rich Trott) [#39001](https://github.com/nodejs/node/pull/39001)
* [[`81bbeab3bd`](https://github.com/nodejs/node/commit/81bbeab3bd)] - **test**: improve coverage of lib/events.js (Rongjian Zhang) [#38582](https://github.com/nodejs/node/pull/38582)
* [[`e82111f890`](https://github.com/nodejs/node/commit/e82111f890)] - **test**: http outgoing \_headers setter null (ycjcl868) [#38881](https://github.com/nodejs/node/pull/38881)
* [[`1f10e84939`](https://github.com/nodejs/node/commit/1f10e84939)] - **test**: suppress warning in test\_environment.cc (Daniel Bevenius) [#38868](https://github.com/nodejs/node/pull/38868)
* [[`379b5f79a9`](https://github.com/nodejs/node/commit/379b5f79a9)] - **tls**: tweak clientCertEngine argument parsing (Shelley Vohr) [#38900](https://github.com/nodejs/node/pull/38900)
* [[`78d2e0ed8e`](https://github.com/nodejs/node/commit/78d2e0ed8e)] - **tools**: update babel-eslint-parser to 7.14.5 (Rich Trott) [#39094](https://github.com/nodejs/node/pull/39094)
* [[`fed641127a`](https://github.com/nodejs/node/commit/fed641127a)] - **tools**: update ESLint to 7.29.0 (Rich Trott) [#39083](https://github.com/nodejs/node/pull/39083)
* [[`3ae2a0be48`](https://github.com/nodejs/node/commit/3ae2a0be48)] - **tools**: fix typo (Houssem Chebab) [#39044](https://github.com/nodejs/node/pull/39044)
* [[`a1d0aef60e`](https://github.com/nodejs/node/commit/a1d0aef60e)] - **tools**: update doctool dependencies, migrate to ESM (Michaël Zasso) [#38966](https://github.com/nodejs/node/pull/38966)
* [[`2a292cf574`](https://github.com/nodejs/node/commit/2a292cf574)] - **tools**: update V8 gypfiles for 9.1 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`0c90fd8454`](https://github.com/nodejs/node/commit/0c90fd8454)] - **tools**: avoid crashing CQ when git push fails (Antoine du Hamel) [#36861](https://github.com/nodejs/node/pull/36861)
* [[`f817c2d3bb`](https://github.com/nodejs/node/commit/f817c2d3bb)] - **tools**: fix typo in commit-queue.sh (bl-ue) [#39000](https://github.com/nodejs/node/pull/39000)
* [[`be5101eb32`](https://github.com/nodejs/node/commit/be5101eb32)] - **tools**: update ESLint to 7.28.0 (Luigi Pinca) [#38955](https://github.com/nodejs/node/pull/38955)
* [[`9bf9ddb490`](https://github.com/nodejs/node/commit/9bf9ddb490)] - **tools**: refactor snapshot builder (Joyee Cheung) [#38902](https://github.com/nodejs/node/pull/38902)
* [[`0706565097`](https://github.com/nodejs/node/commit/0706565097)] - **tools**: bump remark-preset-lint-node to 2.3.0 (Rich Trott) [#38910](https://github.com/nodejs/node/pull/38910)
* [[`7d35fa7938`](https://github.com/nodejs/node/commit/7d35fa7938)] - **tools**: update gyp-next to v0.9.1 (Jiawen Geng) [#38867](https://github.com/nodejs/node/pull/38867)
* [[`00c20e621f`](https://github.com/nodejs/node/commit/00c20e621f)] - **tools,doc**: forbid CJS globals in ESM code snippets (Antoine du Hamel) [#38889](https://github.com/nodejs/node/pull/38889)
* [[`99161b09f6`](https://github.com/nodejs/node/commit/99161b09f6)] - **url,src**: simplify ipv6 logic by using uv\_inet\_pton (Khaidi Chu) [#38842](https://github.com/nodejs/node/pull/38842)
* [[`f40725f2a1`](https://github.com/nodejs/node/commit/f40725f2a1)] - **vm**: use missing validator (Voltrex) [#38935](https://github.com/nodejs/node/pull/38935)
* [[`f959cb3c68`](https://github.com/nodejs/node/commit/f959cb3c68)] - **worker**: do not look up context twice in PostMessage (Anna Henningsen) [#38784](https://github.com/nodejs/node/pull/38784)

<a id="16.3.0"></a>
## 2021-06-02, Version 16.3.0 (Current), @danielleadams

### Notable Changes

* **cli**:
  * add -C alias for --conditions flag (Guy Bedford) [#38755](https://github.com/nodejs/node/pull/38755)
* **deps**:
  * add workspaces support to npm install commands (Ruy Adorno) [#38750](https://github.com/nodejs/node/pull/38750)

### Commits

* [[`4e58ec4aa6`](https://github.com/nodejs/node/commit/4e58ec4aa6)] - **benchmark**: output JSON-compatible numbers (Michaël Zasso) [#38778](https://github.com/nodejs/node/pull/38778)
* [[`7a9d0fd5a9`](https://github.com/nodejs/node/commit/7a9d0fd5a9)] - **benchmark**: fix http elapsed time (Antoine du Hamel) [#38743](https://github.com/nodejs/node/pull/38743)
* [[`a98d631905`](https://github.com/nodejs/node/commit/a98d631905)] - **bootstrap**: include vm and contextify binding into the snapshot (Joyee Cheung) [#38677](https://github.com/nodejs/node/pull/38677)
* [[`f1628960e1`](https://github.com/nodejs/node/commit/f1628960e1)] - **build**: remove outdated dont-land-on-v6.x label (Michaël Zasso) [#38886](https://github.com/nodejs/node/pull/38886)
* [[`6986154b30`](https://github.com/nodejs/node/commit/6986154b30)] - **build**: work around bug in MSBuild v16.10.0 (Michaël Zasso) [#38873](https://github.com/nodejs/node/pull/38873)
* [[`24cca7c5ea`](https://github.com/nodejs/node/commit/24cca7c5ea)] - **build**: add lto build to CI (Jiawen Geng) [#38567](https://github.com/nodejs/node/pull/38567)
* [[`80c32b7a9a`](https://github.com/nodejs/node/commit/80c32b7a9a)] - **build**: allow LTO with Clang 3.9.1+ (Jesse Chan) [#38751](https://github.com/nodejs/node/pull/38751)
* [[`e9be2095cf`](https://github.com/nodejs/node/commit/e9be2095cf)] - **build**: replace non-POSIX test -a|o (Issam E. Maghni) [#38731](https://github.com/nodejs/node/pull/38731)
* [[`717a8b63e1`](https://github.com/nodejs/node/commit/717a8b63e1)] - **child_process**: retain reference to data with advanced serialization (Anna Henningsen) [#38728](https://github.com/nodejs/node/pull/38728)
* [[`bc8400122c`](https://github.com/nodejs/node/commit/bc8400122c)] - **(SEMVER-MINOR)** **cli**: add -C alias for --conditions flag (Guy Bedford) [#38755](https://github.com/nodejs/node/pull/38755)
* [[`eb7c932a6d`](https://github.com/nodejs/node/commit/eb7c932a6d)] - **debugger**: revise async iterator usage to comply with lint rules (Rich Trott) [#38847](https://github.com/nodejs/node/pull/38847)
* [[`f1000e0e52`](https://github.com/nodejs/node/commit/f1000e0e52)] - **debugger**: removed unused function argument (Rich Trott) [#38850](https://github.com/nodejs/node/pull/38850)
* [[`ee1056da60`](https://github.com/nodejs/node/commit/ee1056da60)] - **debugger**: wait for V8 debugger to be enabled (Michaël Zasso) [#38811](https://github.com/nodejs/node/pull/38811)
* [[`47ad448def`](https://github.com/nodejs/node/commit/47ad448def)] - **deps**: upgrade npm to 7.15.1 (npm-robot) [#38880](https://github.com/nodejs/node/pull/38880)
* [[`e8192b5e89`](https://github.com/nodejs/node/commit/e8192b5e89)] - **deps**: upgrade npm to 7.14.0 (Ruy Adorno) [#38750](https://github.com/nodejs/node/pull/38750)
* [[`15aaf14690`](https://github.com/nodejs/node/commit/15aaf14690)] - **deps**: update llhttp to 6.0.2 (Fedor Indutny) [#38665](https://github.com/nodejs/node/pull/38665)
* [[`108ffdb68f`](https://github.com/nodejs/node/commit/108ffdb68f)] - **doc**: fixed typo in n-api.md (julianjany) [#38822](https://github.com/nodejs/node/pull/38822)
* [[`131a6918dd`](https://github.com/nodejs/node/commit/131a6918dd)] - **doc**: use "Long Term Support" in collaborator guide (Rich Trott) [#38841](https://github.com/nodejs/node/pull/38841)
* [[`4844337cd7`](https://github.com/nodejs/node/commit/4844337cd7)] - **doc**: use "Long Term Support" in technical values doc (Rich Trott) [#38841](https://github.com/nodejs/node/pull/38841)
* [[`f1e823b679`](https://github.com/nodejs/node/commit/f1e823b679)] - **doc**: use "Long Term Support" in README (Philip) [#38839](https://github.com/nodejs/node/pull/38839)
* [[`4e11971a76`](https://github.com/nodejs/node/commit/4e11971a76)] - **doc**: fix grammar in `fs.md` (yotamselementor) [#38818](https://github.com/nodejs/node/pull/38818)
* [[`e2f28c80d1`](https://github.com/nodejs/node/commit/e2f28c80d1)] - **doc**: fixup code sample in http.md (TodorTotev) [#38776](https://github.com/nodejs/node/pull/38776)
* [[`96fa387082`](https://github.com/nodejs/node/commit/96fa387082)] - **doc**: document null target pattern (Guy Bedford) [#38724](https://github.com/nodejs/node/pull/38724)
* [[`5553be3f4e`](https://github.com/nodejs/node/commit/5553be3f4e)] - **doc**: update code examples for `node:url` module (fisker Cheung) [#38645](https://github.com/nodejs/node/pull/38645)
* [[`0c063a1258`](https://github.com/nodejs/node/commit/0c063a1258)] - **doc,url**: clarify domainTo\* when built without ICU (Darshan Sen) [#38789](https://github.com/nodejs/node/pull/38789)
* [[`2054efa02c`](https://github.com/nodejs/node/commit/2054efa02c)] - **events**: refactor to use primordials in lib/events (Akhil Marsonya) [#38117](https://github.com/nodejs/node/pull/38117)
* [[`4884991a12`](https://github.com/nodejs/node/commit/4884991a12)] - **lib**: include url in bootstrap snapshot and remove unnecessary lazy-loads (Joyee Cheung) [#38826](https://github.com/nodejs/node/pull/38826)
* [[`08ad2f6c18`](https://github.com/nodejs/node/commit/08ad2f6c18)] - **lib**: fix typos (bl-ue) [#38846](https://github.com/nodejs/node/pull/38846)
* [[`7d3a8cb854`](https://github.com/nodejs/node/commit/7d3a8cb854)] - **lib**: remove unnecessary lazy loads (Joyee Cheung) [#38737](https://github.com/nodejs/node/pull/38737)
* [[`5d9442a024`](https://github.com/nodejs/node/commit/5d9442a024)] - **lib**: load internal/fs/watchers and internal/fs/read\_file\_context early (Joyee Cheung) [#38737](https://github.com/nodejs/node/pull/38737)
* [[`2268d1cf4c`](https://github.com/nodejs/node/commit/2268d1cf4c)] - **lib**: refactor to reuse validators (Rongjian Zhang) [#38608](https://github.com/nodejs/node/pull/38608)
* [[`496f7eae92`](https://github.com/nodejs/node/commit/496f7eae92)] - **node-api**: fix shutdown crashes (Michael Dawson) [#38492](https://github.com/nodejs/node/pull/38492)
* [[`e1195312b9`](https://github.com/nodejs/node/commit/e1195312b9)] - **(SEMVER-MINOR)** **os**: add os.devNull (Luigi Pinca) [#38569](https://github.com/nodejs/node/pull/38569)
* [[`7ba305552f`](https://github.com/nodejs/node/commit/7ba305552f)] - **src**: set PromiseHooks by Environment (Bryan English) [#38821](https://github.com/nodejs/node/pull/38821)
* [[`74205b3542`](https://github.com/nodejs/node/commit/74205b3542)] - **src**: replace `auto`s in node\_api.cc (Khaidi Chu) [#38852](https://github.com/nodejs/node/pull/38852)
* [[`120849f609`](https://github.com/nodejs/node/commit/120849f609)] - **src**: cache necessary isolate & context in api/\* (Khaidi Chu) [#38366](https://github.com/nodejs/node/pull/38366)
* [[`f25cd4f377`](https://github.com/nodejs/node/commit/f25cd4f377)] - **src**: fix typos (bl-ue) [#38845](https://github.com/nodejs/node/pull/38845)
* [[`a1b0e64187`](https://github.com/nodejs/node/commit/a1b0e64187)] - **src**: support fs\_event\_wrap binding in the snapshot (Joyee Cheung) [#38737](https://github.com/nodejs/node/pull/38737)
* [[`36d4a4331d`](https://github.com/nodejs/node/commit/36d4a4331d)] - **src**: remove redundant v8 namespaces in `env.cc` (Juan José Arboleda) [#38792](https://github.com/nodejs/node/pull/38792)
* [[`3e6b3b22c5`](https://github.com/nodejs/node/commit/3e6b3b22c5)] - **src**: use SPrintF in ProcessEmitWarning (Darshan Sen) [#38758](https://github.com/nodejs/node/pull/38758)
* [[`9ca5c0e29e`](https://github.com/nodejs/node/commit/9ca5c0e29e)] - **src**: fix compiler warnings in node\_buffer.cc (Darshan Sen) [#38722](https://github.com/nodejs/node/pull/38722)
* [[`3741595289`](https://github.com/nodejs/node/commit/3741595289)] - **src**: set CONF\_MFLAGS\_DEFAULT\_SECTION for OpenSSL 3 (Daniel Bevenius) [#38732](https://github.com/nodejs/node/pull/38732)
* [[`4e3353223e`](https://github.com/nodejs/node/commit/4e3353223e)] - **src**: use HandleScope in StreamReq::Done() (Darshan Sen) [#38720](https://github.com/nodejs/node/pull/38720)
* [[`c576311954`](https://github.com/nodejs/node/commit/c576311954)] - **src**: remove commented code in `node_file.cc` (Juan José Arboleda) [#38693](https://github.com/nodejs/node/pull/38693)
* [[`61c95f08b3`](https://github.com/nodejs/node/commit/61c95f08b3)] - **src**: write named pipe info in diagnostic report (legendecas) [#38637](https://github.com/nodejs/node/pull/38637)
* [[`ba96f14233`](https://github.com/nodejs/node/commit/ba96f14233)] - **src**: remove unused `iostream` library (Juan José Arboleda) [#38694](https://github.com/nodejs/node/pull/38694)
* [[`f5dd85bbe6`](https://github.com/nodejs/node/commit/f5dd85bbe6)] - **src**: remove more extra semis from member fns (Shelley Vohr) [#38744](https://github.com/nodejs/node/pull/38744)
* [[`a47fd67154`](https://github.com/nodejs/node/commit/a47fd67154)] - **src**: replace `auto`s in node\_contextify.cc (Khaidi Chu) [#38644](https://github.com/nodejs/node/pull/38644)
* [[`9054d25acc`](https://github.com/nodejs/node/commit/9054d25acc)] - **stream**: add a non-destroying iterator to Readable (Nitzan Uziely) [#38526](https://github.com/nodejs/node/pull/38526)
* [[`4131f94ca8`](https://github.com/nodejs/node/commit/4131f94ca8)] - **stream**: allow empty string as source of pipeline (Qingyu Deng) [#38723](https://github.com/nodejs/node/pull/38723)
* [[`0aa3cb5c0e`](https://github.com/nodejs/node/commit/0aa3cb5c0e)] - **test**: improve coverage of fs internal utils (Rongjian Zhang) [#38746](https://github.com/nodejs/node/pull/38746)
* [[`48ebebd2a8`](https://github.com/nodejs/node/commit/48ebebd2a8)] - **test**: remove unnecessary `--pending-deprecation` flag (Antoine du Hamel) [#38819](https://github.com/nodejs/node/pull/38819)
* [[`3c492baa51`](https://github.com/nodejs/node/commit/3c492baa51)] - **test**: fix writefile with fd (Nitzan Uziely) [#38820](https://github.com/nodejs/node/pull/38820)
* [[`e91d14c57c`](https://github.com/nodejs/node/commit/e91d14c57c)] - **test**: simplify test-path-resolve.js (himself65) [#38671](https://github.com/nodejs/node/pull/38671)
* [[`1f5baaa2e7`](https://github.com/nodejs/node/commit/1f5baaa2e7)] - **test**: improve coverage for `question` in readline (Qingyu Deng) [#38799](https://github.com/nodejs/node/pull/38799)
* [[`6d86f8afd5`](https://github.com/nodejs/node/commit/6d86f8afd5)] - **test**: os, replace custom flatten method with built-in Array.flat (Wael Almattar) [#38770](https://github.com/nodejs/node/pull/38770)
* [[`c7a58578dc`](https://github.com/nodejs/node/commit/c7a58578dc)] - **test**: set locale for datetime-change-notify test (ZiJian Liu) [#38741](https://github.com/nodejs/node/pull/38741)
* [[`695e982a42`](https://github.com/nodejs/node/commit/695e982a42)] - **test**: improve coverage of lib/fs.js (Rongjian Zhang) [#38604](https://github.com/nodejs/node/pull/38604)
* [[`11ac9c6fcc`](https://github.com/nodejs/node/commit/11ac9c6fcc)] - **test**: improve coverage of lib/\_http\_outgoing.js (Rongjian Zhang) [#38734](https://github.com/nodejs/node/pull/38734)
* [[`6da4aa30c6`](https://github.com/nodejs/node/commit/6da4aa30c6)] - **test**: give js-native-api tests consistent names (Gabriel Schulhof) [#38692](https://github.com/nodejs/node/pull/38692)
* [[`929e8df1c0`](https://github.com/nodejs/node/commit/929e8df1c0)] - **test**: improve coverage of stream.Readable (Rongjian Zhang) [#38702](https://github.com/nodejs/node/pull/38702)
* [[`36ffd58105`](https://github.com/nodejs/node/commit/36ffd58105)] - **tools**: refloat 7 Node.js patches to cpplint.py (Rich Trott) [#38851](https://github.com/nodejs/node/pull/38851)
* [[`6b8c712247`](https://github.com/nodejs/node/commit/6b8c712247)] - **tools**: bump cpplint to 1.5.5 (Rich Trott) [#38851](https://github.com/nodejs/node/pull/38851)
* [[`be8d934679`](https://github.com/nodejs/node/commit/be8d934679)] - **tools**: remove exception for Node.js 8 and earlier (Rich Trott) [#38840](https://github.com/nodejs/node/pull/38840)
* [[`c0bde0cd4a`](https://github.com/nodejs/node/commit/c0bde0cd4a)] - **tools**: update setup-node to setup-node@v2 (pengjie) [#38825](https://github.com/nodejs/node/pull/38825)
* [[`21ce3af904`](https://github.com/nodejs/node/commit/21ce3af904)] - **tools**: update ESLint to 7.27.0 (Luigi Pinca) [#38764](https://github.com/nodejs/node/pull/38764)
* [[`ab44106555`](https://github.com/nodejs/node/commit/ab44106555)] - **tools**: use PrintCaughtException in the snapshot builder (Joyee Cheung) [#38745](https://github.com/nodejs/node/pull/38745)
* [[`30c0020885`](https://github.com/nodejs/node/commit/30c0020885)] - **typings**: add JSDoc typings for https (Voltrex) [#38589](https://github.com/nodejs/node/pull/38589)
* [[`7fb809b475`](https://github.com/nodejs/node/commit/7fb809b475)] - **typings**: add JSDoc typings for events (Voltrex) [#38712](https://github.com/nodejs/node/pull/38712)
* [[`7773d58f1a`](https://github.com/nodejs/node/commit/7773d58f1a)] - **url**: exit early when : delimiter is seen in hostname (Timothy Gu) [#38742](https://github.com/nodejs/node/pull/38742)
* [[`a2da9e254c`](https://github.com/nodejs/node/commit/a2da9e254c)] - **worker**: use rwlock for sibling group (Anna Henningsen) [#38783](https://github.com/nodejs/node/pull/38783)
* [[`18f3ba3674`](https://github.com/nodejs/node/commit/18f3ba3674)] - **worker**: leave TODO comments for using std::variant when possible (Anna Henningsen) [#38788](https://github.com/nodejs/node/pull/38788)

<a id="16.2.0"></a>
## 2021-05-19, Version 16.2.0 (Current), @targos

### Notable Changes

* [[`36b948560c`](https://github.com/nodejs/node/commit/36b948560c)] - **(SEMVER-MINOR)** **async_hooks**: use new v8::Context PromiseHook API (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`c0deeeacb2`](https://github.com/nodejs/node/commit/c0deeeacb2)] - **lib**: support setting process.env.TZ on windows (James M Snell) [#38642](https://github.com/nodejs/node/pull/38642)
* [[`4c4902748c`](https://github.com/nodejs/node/commit/4c4902748c)] - **(SEMVER-MINOR)** **module**: add support for `URL` to `import.meta.resolve` (Antoine du Hamel) [#38587](https://github.com/nodejs/node/pull/38587)
* [[`c182198c44`](https://github.com/nodejs/node/commit/c182198c44)] - **(SEMVER-MINOR)** **process**: add `'worker'` event (James M Snell) [#38659](https://github.com/nodejs/node/pull/38659)
* [[`fbf02e3198`](https://github.com/nodejs/node/commit/fbf02e3198)] - **(SEMVER-MINOR)** **util**: add util.types.isKeyObject and util.types.isCryptoKey (Filip Skokan) [#38619](https://github.com/nodejs/node/pull/38619)

### Commits

* [[`36b948560c`](https://github.com/nodejs/node/commit/36b948560c)] - **(SEMVER-MINOR)** **async_hooks**: use new v8::Context PromiseHook API (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`dcae03203e`](https://github.com/nodejs/node/commit/dcae03203e)] - **buffer**: remove TODOs in `atob` / `btoa` (Khaidi Chu) [#38548](https://github.com/nodejs/node/pull/38548)
* [[`48b557e904`](https://github.com/nodejs/node/commit/48b557e904)] - **buffer**: remove unreachable code (Rongjian Zhang) [#38537](https://github.com/nodejs/node/pull/38537)
* [[`b0df28dea5`](https://github.com/nodejs/node/commit/b0df28dea5)] - **build**: add workaround for V8 builds (Richard Lau) [#38632](https://github.com/nodejs/node/pull/38632)
* [[`3bb12db255`](https://github.com/nodejs/node/commit/3bb12db255)] - **build**: remove dependency on `distutils.spawn` (Richard Lau) [#38600](https://github.com/nodejs/node/pull/38600)
* [[`10aaf30da1`](https://github.com/nodejs/node/commit/10aaf30da1)] - **build**: add missing torque output sources (Richard Lau) [#38576](https://github.com/nodejs/node/pull/38576)
* [[`03b4a3a5bf`](https://github.com/nodejs/node/commit/03b4a3a5bf)] - **build**: compile with -std=gnu++14 (Darshan Sen) [#38504](https://github.com/nodejs/node/pull/38504)
* [[`4296591154`](https://github.com/nodejs/node/commit/4296591154)] - **build,src,test,doc**: enable FIPS for OpenSSL 3.0 (Daniel Bevenius) [#38633](https://github.com/nodejs/node/pull/38633)
* [[`36bb8daba5`](https://github.com/nodejs/node/commit/36bb8daba5)] - **crypto**: forbid NODE-ED25519 and NODE-ED448 "raw" key export (Filip Skokan) [#38668](https://github.com/nodejs/node/pull/38668)
* [[`36bb7243ff`](https://github.com/nodejs/node/commit/36bb7243ff)] - **debugger**: refactor `inspect_repl` to use primordials (Antoine du Hamel) [#38551](https://github.com/nodejs/node/pull/38551)
* [[`16a6c8d5a6`](https://github.com/nodejs/node/commit/16a6c8d5a6)] - **debugger**: refactor to use internal modules (Antoine du Hamel) [#38550](https://github.com/nodejs/node/pull/38550)
* [[`11dd9a6838`](https://github.com/nodejs/node/commit/11dd9a6838)] - **debugger**: disable only the lint rules required by current file state (Rich Trott) [#38529](https://github.com/nodejs/node/pull/38529)
* [[`e79f540fa0`](https://github.com/nodejs/node/commit/e79f540fa0)] - **debugger**: avoid non-ASCII char in code file (Rich Trott) [#38529](https://github.com/nodejs/node/pull/38529)
* [[`d9867b9358`](https://github.com/nodejs/node/commit/d9867b9358)] - **debugger**: wrap lines longer than 80 chars (Rich Trott) [#38529](https://github.com/nodejs/node/pull/38529)
* [[`352a600142`](https://github.com/nodejs/node/commit/352a600142)] - **debugger**: rename inspector-cli test module to debugger (Rich Trott) [#38530](https://github.com/nodejs/node/pull/38530)
* [[`608d0e11f3`](https://github.com/nodejs/node/commit/608d0e11f3)] - **deps**: upgrade npm to 7.13.0 (Ruy Adorno) [#38682](https://github.com/nodejs/node/pull/38682)
* [[`5c71f49d3f`](https://github.com/nodejs/node/commit/5c71f49d3f)] - **deps**: upgrade npm to 7.12.1 (Ruy Adorno) [#38628](https://github.com/nodejs/node/pull/38628)
* [[`ec2dbfb200`](https://github.com/nodejs/node/commit/ec2dbfb200)] - **deps**: patch V8 to 9.0.257.25 (Michaël Zasso) [#38556](https://github.com/nodejs/node/pull/38556)
* [[`ab298723b5`](https://github.com/nodejs/node/commit/ab298723b5)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick fa4cb172cde2 (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`a84e9b3e7d`](https://github.com/nodejs/node/commit/a84e9b3e7d)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick 4c074516397b (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`043b1aaa3f`](https://github.com/nodejs/node/commit/043b1aaa3f)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick 5f4413194480 (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`1a104bac74`](https://github.com/nodejs/node/commit/1a104bac74)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick 272445f10927 (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`827ae05538`](https://github.com/nodejs/node/commit/827ae05538)] - **(SEMVER-MINOR)** **deps**: V8: backport c0fceaa0669b (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`f31a6114a4`](https://github.com/nodejs/node/commit/f31a6114a4)] - **deps**: V8: cherry-pick 530080c44af2 (Milad Fa) [#38489](https://github.com/nodejs/node/pull/38489)
* [[`4001dd28ba`](https://github.com/nodejs/node/commit/4001dd28ba)] - **dgram**: extract cluster lazy loading method to make it testable (Rongjian Zhang) [#38563](https://github.com/nodejs/node/pull/38563)
* [[`a0dc194e31`](https://github.com/nodejs/node/commit/a0dc194e31)] - **doc**: document buffer.kStringMaxLength (Tobias Nießen) [#38688](https://github.com/nodejs/node/pull/38688)
* [[`8590c151cd`](https://github.com/nodejs/node/commit/8590c151cd)] - **doc**: update abort signal in fs promise api example (Moritz Kneilmann) [#38669](https://github.com/nodejs/node/pull/38669)
* [[`0100a3b026`](https://github.com/nodejs/node/commit/0100a3b026)] - **doc**: add documentation for fs.WriteStream.close() (Hitesh Sharma) [#38610](https://github.com/nodejs/node/pull/38610)
* [[`5c38a554ec`](https://github.com/nodejs/node/commit/5c38a554ec)] - **doc**: clarify synchronous blocking of Worker stdio (James M Snell) [#38658](https://github.com/nodejs/node/pull/38658)
* [[`1765e32c45`](https://github.com/nodejs/node/commit/1765e32c45)] - **doc**: update contact info (Gabriel Schulhof) [#38689](https://github.com/nodejs/node/pull/38689)
* [[`c4b161cb89`](https://github.com/nodejs/node/commit/c4b161cb89)] - **doc**: change color of doctag on night mode (Qingyu Deng) [#38652](https://github.com/nodejs/node/pull/38652)
* [[`6620a3182e`](https://github.com/nodejs/node/commit/6620a3182e)] - **doc**: add ESM code examples in url.md (Antoine du Hamel) [#38651](https://github.com/nodejs/node/pull/38651)
* [[`d3de0ef5d4`](https://github.com/nodejs/node/commit/d3de0ef5d4)] - **doc**: fix fs.openSync() signature (Luigi Pinca) [#38591](https://github.com/nodejs/node/pull/38591)
* [[`56bf6c1bcd`](https://github.com/nodejs/node/commit/56bf6c1bcd)] - **doc**: typo stats() should be stat(); clarity (Bryan Field) [#38541](https://github.com/nodejs/node/pull/38541)
* [[`1d9fd49f41`](https://github.com/nodejs/node/commit/1d9fd49f41)] - **doc**: fix code example in ecdh.setPublicKey() (Jordan Baczuk) [#38542](https://github.com/nodejs/node/pull/38542)
* [[`4c70e42928`](https://github.com/nodejs/node/commit/4c70e42928)] - **doc**: use `HEAD` instead of `master` for links (Antoine du Hamel) [#38518](https://github.com/nodejs/node/pull/38518)
* [[`ae9128ec61`](https://github.com/nodejs/node/commit/ae9128ec61)] - **doc**: clarify DiffieHellmanGroup class docs (Nitzan Uziely) [#38363](https://github.com/nodejs/node/pull/38363)
* [[`e59131d97f`](https://github.com/nodejs/node/commit/e59131d97f)] - **doc**: fix broken AHAFS link in fs doc (Rich Trott) [#38534](https://github.com/nodejs/node/pull/38534)
* [[`e9d4c8587a`](https://github.com/nodejs/node/commit/e9d4c8587a)] - **doc**: use AIX instead of Aix in fs.md (Rich Trott) [#38535](https://github.com/nodejs/node/pull/38535)
* [[`e0118f347a`](https://github.com/nodejs/node/commit/e0118f347a)] - **doc**: remove extraneous dash from flag prefix (Rodolfo Carvalho) [#38532](https://github.com/nodejs/node/pull/38532)
* [[`9e10e1a76f`](https://github.com/nodejs/node/commit/9e10e1a76f)] - **doc**: corrected workload name as per the latest VS Installer (MrJithil) [#38500](https://github.com/nodejs/node/pull/38500)
* [[`38644d6f96`](https://github.com/nodejs/node/commit/38644d6f96)] - **doc**: use sentence case in headers in src/crypto/README.md (Rich Trott) [#38524](https://github.com/nodejs/node/pull/38524)
* [[`347b9f2304`](https://github.com/nodejs/node/commit/347b9f2304)] - **errors**: remove input from ERR\_INVALID\_URL message (moander) [#38614](https://github.com/nodejs/node/pull/38614)
* [[`5b40e2f596`](https://github.com/nodejs/node/commit/5b40e2f596)] - **events**: use nullish coalencing operator (Voltrex) [#38328](https://github.com/nodejs/node/pull/38328)
* [[`3a5856cbc3`](https://github.com/nodejs/node/commit/3a5856cbc3)] - **fs**: fix async iterator partial writes (Nitzan Uziely) [#38615](https://github.com/nodejs/node/pull/38615)
* [[`e8761186a5`](https://github.com/nodejs/node/commit/e8761186a5)] - **fs**: fix error when writing buffers \> INT32\_MAX (Zach Bjornson) [#38546](https://github.com/nodejs/node/pull/38546)
* [[`47080bcfc8`](https://github.com/nodejs/node/commit/47080bcfc8)] - **fs**: use `assert` in `fsCall` argument checking (Rongjian Zhang) [#38519](https://github.com/nodejs/node/pull/38519)
* [[`3d8b8e133f`](https://github.com/nodejs/node/commit/3d8b8e133f)] - **http**: refactor to remove redundant argument of \_deferToConnect (Rongjian Zhang) [#38598](https://github.com/nodejs/node/pull/38598)
* [[`c0deeeacb2`](https://github.com/nodejs/node/commit/c0deeeacb2)] - **lib**: support setting process.env.TZ on windows (James M Snell) [#38642](https://github.com/nodejs/node/pull/38642)
* [[`cf4dc80d5f`](https://github.com/nodejs/node/commit/cf4dc80d5f)] - **lib**: make `IterableWeakMap` safe to iterate (Antoine du Hamel) [#38523](https://github.com/nodejs/node/pull/38523)
* [[`90b640efb1`](https://github.com/nodejs/node/commit/90b640efb1)] - **meta**: add v8 team (Jiawen Geng) [#38566](https://github.com/nodejs/node/pull/38566)
* [[`4c4902748c`](https://github.com/nodejs/node/commit/4c4902748c)] - **(SEMVER-MINOR)** **module**: add support for `URL` to `import.meta.resolve` (Antoine du Hamel) [#38587](https://github.com/nodejs/node/pull/38587)
* [[`14a2a00cda`](https://github.com/nodejs/node/commit/14a2a00cda)] - **node-api**: faster threadsafe\_function (Fedor Indutny) [#38506](https://github.com/nodejs/node/pull/38506)
* [[`be4b3a4164`](https://github.com/nodejs/node/commit/be4b3a4164)] - **path**: inline conditions (Voltrex) [#38613](https://github.com/nodejs/node/pull/38613)
* [[`c182198c44`](https://github.com/nodejs/node/commit/c182198c44)] - **(SEMVER-MINOR)** **process**: add `'worker'` event (James M Snell) [#38659](https://github.com/nodejs/node/pull/38659)
* [[`e2b8454582`](https://github.com/nodejs/node/commit/e2b8454582)] - **repl**: fix Ctrl+C on top level await (Antoine du Hamel) [#38656](https://github.com/nodejs/node/pull/38656)
* [[`718ad105e5`](https://github.com/nodejs/node/commit/718ad105e5)] - **src**: fix fatal errors when a current isolate not exist (legendecas) [#38624](https://github.com/nodejs/node/pull/38624)
* [[`524a9d6fcd`](https://github.com/nodejs/node/commit/524a9d6fcd)] - **src**: update cares\_wrap OpenBSD defines (Anna Henningsen) [#38670](https://github.com/nodejs/node/pull/38670)
* [[`6b409cf664`](https://github.com/nodejs/node/commit/6b409cf664)] - **src**: remove extra semi after member fn (Shelley Vohr) [#38686](https://github.com/nodejs/node/pull/38686)
* [[`bfec80fd66`](https://github.com/nodejs/node/commit/bfec80fd66)] - **src**: make workers messaging more resilient (Juan José Arboleda) [#38510](https://github.com/nodejs/node/pull/38510)
* [[`ff1b4322f5`](https://github.com/nodejs/node/commit/ff1b4322f5)] - **test**: refactor `test-readline-interface` to be shorter (Juan José Arboleda) [#38691](https://github.com/nodejs/node/pull/38691)
* [[`8eea317227`](https://github.com/nodejs/node/commit/8eea317227)] - **test**: stream.finished detects a destroyed IncomingMessage (Nitzan Uziely) [#38661](https://github.com/nodejs/node/pull/38661)
* [[`5b25fbe266`](https://github.com/nodejs/node/commit/5b25fbe266)] - **test**: set common.bits to 64 for riscv64 (Andreas Schwab) [#38626](https://github.com/nodejs/node/pull/38626)
* [[`5a0b52120a`](https://github.com/nodejs/node/commit/5a0b52120a)] - **test**: improve coverage of lib/\_http\_client.js (Rongjian Zhang) [#38599](https://github.com/nodejs/node/pull/38599)
* [[`3d0fad3840`](https://github.com/nodejs/node/commit/3d0fad3840)] - **test**: improve coverage of lib/os.js (Rongjian Zhang) [#38653](https://github.com/nodejs/node/pull/38653)
* [[`16b2fb4e0c`](https://github.com/nodejs/node/commit/16b2fb4e0c)] - **test**: increase coverage for repl (ZiJian Liu) [#38559](https://github.com/nodejs/node/pull/38559)
* [[`8f78c6646e`](https://github.com/nodejs/node/commit/8f78c6646e)] - **test**: call functions internally (Voltrex) [#38560](https://github.com/nodejs/node/pull/38560)
* [[`178fe215a4`](https://github.com/nodejs/node/commit/178fe215a4)] - **test**: increase coverage for Histogram (ZiJian Liu) [#38555](https://github.com/nodejs/node/pull/38555)
* [[`95db7d5afc`](https://github.com/nodejs/node/commit/95db7d5afc)] - **test**: improve fs coverage (Rongjian Zhang) [#38517](https://github.com/nodejs/node/pull/38517)
* [[`f2f768f261`](https://github.com/nodejs/node/commit/f2f768f261)] - **test**: complete coverage of querystring (Rongjian Zhang) [#38520](https://github.com/nodejs/node/pull/38520)
* [[`5b44107ae9`](https://github.com/nodejs/node/commit/5b44107ae9)] - **test**: increase coverage for AbortController (ZiJian Liu) [#38514](https://github.com/nodejs/node/pull/38514)
* [[`662265074c`](https://github.com/nodejs/node/commit/662265074c)] - **test**: increase coverage for Blob (ZiJian Liu) [#38515](https://github.com/nodejs/node/pull/38515)
* [[`89e1daccf3`](https://github.com/nodejs/node/commit/89e1daccf3)] - **test**: run message and pseudo-tty tests in parallel (Richard Lau) [#38502](https://github.com/nodejs/node/pull/38502)
* [[`727c2bcc24`](https://github.com/nodejs/node/commit/727c2bcc24)] - **test**: move test-net-connect-econnrefused from pummel to sequential (Rich Trott) [#38462](https://github.com/nodejs/node/pull/38462)
* [[`e64ebac2da`](https://github.com/nodejs/node/commit/e64ebac2da)] - **test**: fix flaky inspector-cli tests when breakpionts are restored (Rich Trott) [#38431](https://github.com/nodejs/node/pull/38431)
* [[`b51b4feece`](https://github.com/nodejs/node/commit/b51b4feece)] - **test**: skip tests for openssl-3.0.0-alpha15 (Daniel Bevenius) [#38451](https://github.com/nodejs/node/pull/38451)
* [[`db5ee23edf`](https://github.com/nodejs/node/commit/db5ee23edf)] - **test**: update OpenSSL 3.0.0-alpha15 error messages (Daniel Bevenius) [#38451](https://github.com/nodejs/node/pull/38451)
* [[`24472d9e0c`](https://github.com/nodejs/node/commit/24472d9e0c)] - **test,repl**: fix tests when inspector is disabled (Antoine du Hamel) [#38564](https://github.com/nodejs/node/pull/38564)
* [[`267a84f5e1`](https://github.com/nodejs/node/commit/267a84f5e1)] - **tools**: remove redundant v8 config (Jiawen Geng) [#38565](https://github.com/nodejs/node/pull/38565)
* [[`a028805f1b`](https://github.com/nodejs/node/commit/a028805f1b)] - **tools**: update ESLint to 7.26.0 (Colin Ihrig) [#38605](https://github.com/nodejs/node/pull/38605)
* [[`ec8ab22ce6`](https://github.com/nodejs/node/commit/ec8ab22ce6)] - **(SEMVER-MINOR)** **tools**: add `Worker` to type-parser (James M Snell) [#38659](https://github.com/nodejs/node/pull/38659)
* [[`151488539b`](https://github.com/nodejs/node/commit/151488539b)] - **tools**: make GH Actions workflows work if default branch is not master (Antoine du Hamel) [#38516](https://github.com/nodejs/node/pull/38516)
* [[`c0f0c9a92d`](https://github.com/nodejs/node/commit/c0f0c9a92d)] - **typings**: add JSDoc typings for readline (Voltrex) [#38253](https://github.com/nodejs/node/pull/38253)
* [[`fbf02e3198`](https://github.com/nodejs/node/commit/fbf02e3198)] - **(SEMVER-MINOR)** **util**: add util.types.isKeyObject and util.types.isCryptoKey (Filip Skokan) [#38619](https://github.com/nodejs/node/pull/38619)
* [[`070ee4bb94`](https://github.com/nodejs/node/commit/070ee4bb94)] - ***Revert*** "**worker**: remove `ERR_CLOSED_MESSAGE_PORT`" (Juan José Arboleda) [#38510](https://github.com/nodejs/node/pull/38510)

<a id="16.1.0"></a>
## 2021-05-04, Version 16.1.0 (Current), @targos

### Notable Changes

* [[`8a90f55a05`](https://github.com/nodejs/node/commit/8a90f55a05)] - **(SEMVER-MINOR)** **fs**: allow no-params fsPromises fileHandle read (Nitzan Uziely) [#38287](https://github.com/nodejs/node/pull/38287)

### Commits

* [[`28e16488cf`](https://github.com/nodejs/node/commit/28e16488cf)] - **async_hooks,doc**: replace process.stdout.fd with 1 (Darshan Sen) [#38382](https://github.com/nodejs/node/pull/38382)
* [[`cbab7ec6e5`](https://github.com/nodejs/node/commit/cbab7ec6e5)] - **benchmark**: avoid using `console.log()` (Antoine du Hamel) [#38370](https://github.com/nodejs/node/pull/38370)
* [[`ba15b20062`](https://github.com/nodejs/node/commit/ba15b20062)] - **benchmark**: use `process.hrtime.bigint()` (Antoine du Hamel) [#38369](https://github.com/nodejs/node/pull/38369)
* [[`bc6e719884`](https://github.com/nodejs/node/commit/bc6e719884)] - **bootstrap**: freeze more intrinsics (Antoine du Hamel) [#38217](https://github.com/nodejs/node/pull/38217)
* [[`29faf0f12e`](https://github.com/nodejs/node/commit/29faf0f12e)] - **build**: fix label-pr workflow (Michaël Zasso) [#38399](https://github.com/nodejs/node/pull/38399)
* [[`b5d669a6ea`](https://github.com/nodejs/node/commit/b5d669a6ea)] - **build**: label PRs with GitHub Action instead of nodejs-github-bot (Phillip Johnsen) [#38301](https://github.com/nodejs/node/pull/38301)
* [[`195f679331`](https://github.com/nodejs/node/commit/195f679331)] - **crypto**: don't crash with some selfsigned certs (Nils Dralle) [#37990](https://github.com/nodejs/node/pull/37990)
* [[`4b073b0beb`](https://github.com/nodejs/node/commit/4b073b0beb)] - **crypto**: fix generateKeyPair type checks (Nitzan Uziely) [#38364](https://github.com/nodejs/node/pull/38364)
* [[`c1d9b5b386`](https://github.com/nodejs/node/commit/c1d9b5b386)] - **crypto**: fix scrypt keylen validation (Antoine du Hamel) [#38385](https://github.com/nodejs/node/pull/38385)
* [[`7354479ad5`](https://github.com/nodejs/node/commit/7354479ad5)] - **crypto**: fix DiffieHellman `generator` validation (eladkeyshawn) [#38311](https://github.com/nodejs/node/pull/38311)
* [[`0e446d6048`](https://github.com/nodejs/node/commit/0e446d6048)] - **debugger**: enable linter on `internal/inspector/inspect_client` (Antoine du Hamel) [#38417](https://github.com/nodejs/node/pull/38417)
* [[`9f0e80aa4d`](https://github.com/nodejs/node/commit/9f0e80aa4d)] - **debugger**: refactor `internal/inspector/_inspect` to use more primordials (Antoine du Hamel) [#38406](https://github.com/nodejs/node/pull/38406)
* [[`a0c566f85a`](https://github.com/nodejs/node/commit/a0c566f85a)] - **debugger**: apply automatic lint fixes for inspect\_repl.js (Rich Trott) [#38411](https://github.com/nodejs/node/pull/38411)
* [[`b884ea739b`](https://github.com/nodejs/node/commit/b884ea739b)] - **debugger**: apply automatic lint fixes for \_inspect.js (Rich Trott) [#38411](https://github.com/nodejs/node/pull/38411)
* [[`f946aa0360`](https://github.com/nodejs/node/commit/f946aa0360)] - **debugger**: remove unused function argument (Rich Trott) [#38400](https://github.com/nodejs/node/pull/38400)
* [[`203a9689a3`](https://github.com/nodejs/node/commit/203a9689a3)] - **debugger**: align message with Node.js standard (Rich Trott) [#38400](https://github.com/nodejs/node/pull/38400)
* [[`ef617dcbb0`](https://github.com/nodejs/node/commit/ef617dcbb0)] - **debugger**: add usage example for `--port` (Rafael Gonzaga) [#38400](https://github.com/nodejs/node/pull/38400)
* [[`37b5ce2d5a`](https://github.com/nodejs/node/commit/37b5ce2d5a)] - **debugger**: fix race condition/deadlock on initialization (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`2a6203d155`](https://github.com/nodejs/node/commit/2a6203d155)] - **debugger**: replace internal use of deprecated API (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`6fff9fff97`](https://github.com/nodejs/node/commit/6fff9fff97)] - **debugger**: allow longer time to connect (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`def85daace`](https://github.com/nodejs/node/commit/def85daace)] - **debugger**: accommodate line chunking in Windows (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`07361e6b77`](https://github.com/nodejs/node/commit/07361e6b77)] - **debugger**: fix inspect restart on Windows (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`d65615e119`](https://github.com/nodejs/node/commit/d65615e119)] - **debugger**: remove unused code (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`62b03bc4f6`](https://github.com/nodejs/node/commit/62b03bc4f6)] - **debugger**: move node-inspect to internal library (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`e3b75cb5aa`](https://github.com/nodejs/node/commit/e3b75cb5aa)] - **deps**: V8: cherry-pick fd75c97d3f56 (Michaël Zasso) [#38455](https://github.com/nodejs/node/pull/38455)
* [[`aabddfbeb5`](https://github.com/nodejs/node/commit/aabddfbeb5)] - **deps**: upgrade npm to 7.11.2 (Ruy Adorno) [#38475](https://github.com/nodejs/node/pull/38475)
* [[`7b9fb92d51`](https://github.com/nodejs/node/commit/7b9fb92d51)] - **deps**: update to cjs-module-lexer@1.2.1 (Guy Bedford) [#38450](https://github.com/nodejs/node/pull/38450)
* [[`47626c52a3`](https://github.com/nodejs/node/commit/47626c52a3)] - **deps**: patch V8 to 9.0.257.24 (Michaël Zasso) [#38423](https://github.com/nodejs/node/pull/38423)
* [[`f455e08621`](https://github.com/nodejs/node/commit/f455e08621)] - **deps**: patch V8 to 9.0.257.21 (Michaël Zasso) [#38333](https://github.com/nodejs/node/pull/38333)
* [[`dd61a26d8c`](https://github.com/nodejs/node/commit/dd61a26d8c)] - **deps**: update llhttp to 6.0.1 (Fedor Indutny) [#38359](https://github.com/nodejs/node/pull/38359)
* [[`05f41cdbcc`](https://github.com/nodejs/node/commit/05f41cdbcc)] - **deps**: patch V8 to 9.0.257.19 (Michaël Zasso) [#38270](https://github.com/nodejs/node/pull/38270)
* [[`224faa0a05`](https://github.com/nodejs/node/commit/224faa0a05)] - ***Revert*** "**doc**: os.uptime() temporary bug notice" (Michaël Zasso) [#38494](https://github.com/nodejs/node/pull/38494)
* [[`3b0480dde8`](https://github.com/nodejs/node/commit/3b0480dde8)] - **doc**: document `'secureConnect'` event limitation (James M Snell) [#38447](https://github.com/nodejs/node/pull/38447)
* [[`92586046ec`](https://github.com/nodejs/node/commit/92586046ec)] - **doc**: fix outdated util inspect documentation and layout example (Ruben Bridgewater) [#37079](https://github.com/nodejs/node/pull/37079)
* [[`13de4cf1ca`](https://github.com/nodejs/node/commit/13de4cf1ca)] - **doc**: mark Node.js 10 as End-of-Life (Richard Lau) [#38482](https://github.com/nodejs/node/pull/38482)
* [[`3cbfde1f25`](https://github.com/nodejs/node/commit/3cbfde1f25)] - **doc**: mark querystring api as legacy (James M Snell) [#38436](https://github.com/nodejs/node/pull/38436)
* [[`a5929c2487`](https://github.com/nodejs/node/commit/a5929c2487)] - **doc**: update node-api support matrix (Michael Dawson) [#38424](https://github.com/nodejs/node/pull/38424)
* [[`f08650cefe`](https://github.com/nodejs/node/commit/f08650cefe)] - **doc**: add arguments for stream event of Http2Server and Http2SecureServer (Qingyu Deng) [#37892](https://github.com/nodejs/node/pull/37892)
* [[`2d59273bed`](https://github.com/nodejs/node/commit/2d59273bed)] - **doc**: indicate that abort tests do not generate core files (Rich Trott) [#38422](https://github.com/nodejs/node/pull/38422)
* [[`f1970127ee`](https://github.com/nodejs/node/commit/f1970127ee)] - **doc**: add try/catch in http2 respondWithFile example (Matteo Collina) [#38410](https://github.com/nodejs/node/pull/38410)
* [[`f6f1317f43`](https://github.com/nodejs/node/commit/f6f1317f43)] - **doc**: note the system requirements for V8 tests (DeeDeeG) [#38319](https://github.com/nodejs/node/pull/38319)
* [[`4b19beaf3c`](https://github.com/nodejs/node/commit/4b19beaf3c)] - **doc**: minor clarification to pathObject (James M Snell) [#38437](https://github.com/nodejs/node/pull/38437)
* [[`1eae4af6f7`](https://github.com/nodejs/node/commit/1eae4af6f7)] - **doc**: clarify that fs.Dir async iterator closes automatically (James M Snell) [#38438](https://github.com/nodejs/node/pull/38438)
* [[`14afb39259`](https://github.com/nodejs/node/commit/14afb39259)] - **doc**: document new TCP\_KEEPCNT and TCP\_KEEPINTVL socket option defaults (Arnold Zokas) [#38313](https://github.com/nodejs/node/pull/38313)
* [[`ed5ef21690`](https://github.com/nodejs/node/commit/ed5ef21690)] - **doc**: do not mention TCP in the allowHalfOpen option description (Luigi Pinca) [#38360](https://github.com/nodejs/node/pull/38360)
* [[`042985c139`](https://github.com/nodejs/node/commit/042985c139)] - **doc**: update message to match actual output (Rich Trott) [#35271](https://github.com/nodejs/node/pull/35271)
* [[`bcc5e2af76`](https://github.com/nodejs/node/commit/bcc5e2af76)] - **doc**: request default snap track be updated for LTS (Rod Vagg) [#37708](https://github.com/nodejs/node/pull/37708)
* [[`dfd4c7ba93`](https://github.com/nodejs/node/commit/dfd4c7ba93)] - **doc**: mark `process.hrtime()` as legacy (Antoine du Hamel) [#38371](https://github.com/nodejs/node/pull/38371)
* [[`67cd88da00`](https://github.com/nodejs/node/commit/67cd88da00)] - **doc**: fix typo in worker\_threads.md (takayama) [#38368](https://github.com/nodejs/node/pull/38368)
* [[`a9314cda7d`](https://github.com/nodejs/node/commit/a9314cda7d)] - **doc**: fix version history for `"exports"` patterns (Antoine du Hamel) [#38355](https://github.com/nodejs/node/pull/38355)
* [[`76885cd578`](https://github.com/nodejs/node/commit/76885cd578)] - **doc**: fix `package.json` `"imports"` field history (Antoine du Hamel) [#38356](https://github.com/nodejs/node/pull/38356)
* [[`0e88ae7ec1`](https://github.com/nodejs/node/commit/0e88ae7ec1)] - **doc**: fix typo in buffer.md (divlo) [#38323](https://github.com/nodejs/node/pull/38323)
* [[`1cccc2da51`](https://github.com/nodejs/node/commit/1cccc2da51)] - **doc**: fix YAML comment opening tags (Jayden Seric) [#38324](https://github.com/nodejs/node/pull/38324)
* [[`25052dc987`](https://github.com/nodejs/node/commit/25052dc987)] - **doc**: add nodejs-sec email template (Daniel Bevenius) [#38290](https://github.com/nodejs/node/pull/38290)
* [[`3858029262`](https://github.com/nodejs/node/commit/3858029262)] - **doc**: update TSC members list with three new members (Rich Trott) [#38352](https://github.com/nodejs/node/pull/38352)
* [[`2eef587674`](https://github.com/nodejs/node/commit/2eef587674)] - **doc**: use `foo.prototype.bar` notation in buffer.md (Voltrex) [#38032](https://github.com/nodejs/node/pull/38032)
* [[`8a90f55a05`](https://github.com/nodejs/node/commit/8a90f55a05)] - **(SEMVER-MINOR)** **fs**: allow no-params fsPromises fileHandle read (Nitzan Uziely) [#38287](https://github.com/nodejs/node/pull/38287)
* [[`a696f1080c`](https://github.com/nodejs/node/commit/a696f1080c)] - **inspector**: remove redundant method for connection check (Yash Ladha) [#37986](https://github.com/nodejs/node/pull/37986)
* [[`fcac2e0363`](https://github.com/nodejs/node/commit/fcac2e0363)] - **lib**: harden lint checks for globals (Antoine du Hamel) [#38419](https://github.com/nodejs/node/pull/38419)
* [[`277122e1fa`](https://github.com/nodejs/node/commit/277122e1fa)] - **lib**: fix and improve os typings (Akhil Marsonya) [#38316](https://github.com/nodejs/node/pull/38316)
* [[`f2c0258b4c`](https://github.com/nodejs/node/commit/f2c0258b4c)] - **lib**: add support for JSTransferable as a mixin (James M Snell) [#38383](https://github.com/nodejs/node/pull/38383)
* [[`96f54d3446`](https://github.com/nodejs/node/commit/96f54d3446)] - **meta**: post comment when pr labeled fast-track (James M Snell) [#38446](https://github.com/nodejs/node/pull/38446)
* [[`4711f57cf2`](https://github.com/nodejs/node/commit/4711f57cf2)] - **perf_hooks**: add toJSON to performance class (Yash Ladha) [#37771](https://github.com/nodejs/node/pull/37771)
* [[`013fa59602`](https://github.com/nodejs/node/commit/013fa59602)] - **perf_hooks**: fix PerformanceObserver 'gc' crash (James M Snell) [#38414](https://github.com/nodejs/node/pull/38414)
* [[`10147f191e`](https://github.com/nodejs/node/commit/10147f191e)] - **readline**: move utilities to internal modules (Antoine du Hamel) [#38466](https://github.com/nodejs/node/pull/38466)
* [[`620ee42ab4`](https://github.com/nodejs/node/commit/620ee42ab4)] - **repl**: document top level await limitation with const/let (James M Snell) [#38449](https://github.com/nodejs/node/pull/38449)
* [[`aa24681dcb`](https://github.com/nodejs/node/commit/aa24681dcb)] - **repl**: display prompt once after error callback (Anna Henningsen) [#38314](https://github.com/nodejs/node/pull/38314)
* [[`9c06103a4f`](https://github.com/nodejs/node/commit/9c06103a4f)] - **src**: fix validation of negative offset to avoid abort (James M Snell) [#38421](https://github.com/nodejs/node/pull/38421)
* [[`7d8cc2abf1`](https://github.com/nodejs/node/commit/7d8cc2abf1)] - **src**: use %progbits instead of @progbits (Stephen Gallagher) [#38312](https://github.com/nodejs/node/pull/38312)
* [[`17856f1f88`](https://github.com/nodejs/node/commit/17856f1f88)] - **src**: print arbitrary javascript exception value in node report (legendecas) [#38009](https://github.com/nodejs/node/pull/38009)
* [[`769a210d55`](https://github.com/nodejs/node/commit/769a210d55)] - **src**: refactor to use THROW\_\* argument based snprintf (Filip Skokan) [#38357](https://github.com/nodejs/node/pull/38357)
* [[`e3538bbcd2`](https://github.com/nodejs/node/commit/e3538bbcd2)] - **src**: fix abort in pbkdf2 (Tobias Nießen) [#38354](https://github.com/nodejs/node/pull/38354)
* [[`09cacd7418`](https://github.com/nodejs/node/commit/09cacd7418)] - **src**: fix setting Converter sub char length (James M Snell) [#38331](https://github.com/nodejs/node/pull/38331)
* [[`3649ec5276`](https://github.com/nodejs/node/commit/3649ec5276)] - **src**: avoid deferred gc/cleanup for Buffer.from (James M Snell) [#38337](https://github.com/nodejs/node/pull/38337)
* [[`f2ffaba78c`](https://github.com/nodejs/node/commit/f2ffaba78c)] - **stream**: the position of \_read() is wrong (helloyou2012) [#38292](https://github.com/nodejs/node/pull/38292)
* [[`7ce39b8608`](https://github.com/nodejs/node/commit/7ce39b8608)] - **test**: fix `common.mustCall` `length` and `name` properties (Antoine du Hamel) [#38464](https://github.com/nodejs/node/pull/38464)
* [[`d1cd1178e7`](https://github.com/nodejs/node/commit/d1cd1178e7)] - **test**: address deprecation warning (Rich Trott) [#38448](https://github.com/nodejs/node/pull/38448)
* [[`67e9e71f75`](https://github.com/nodejs/node/commit/67e9e71f75)] - **test**: crypto KeyObject.from() ERR\_INVALID\_ARG\_TYPE (pezhmanparsaee) [#37890](https://github.com/nodejs/node/pull/37890)
* [[`9ad611c0b2`](https://github.com/nodejs/node/commit/9ad611c0b2)] - **test**: fix flaky test-crypto-timing-safe-dqual-benchmarks (Rich Trott) [#38476](https://github.com/nodejs/node/pull/38476)
* [[`10b6b4e244`](https://github.com/nodejs/node/commit/10b6b4e244)] - **test**: update url Web Platform Tests (Leko) [#38435](https://github.com/nodejs/node/pull/38435)
* [[`4f6c4eb144`](https://github.com/nodejs/node/commit/4f6c4eb144)] - **test**: move abort test from pummel to abort directory (Rich Trott) [#38396](https://github.com/nodejs/node/pull/38396)
* [[`231ef4b0ce`](https://github.com/nodejs/node/commit/231ef4b0ce)] - **test**: move slower tests into pummel and skip on slow devices (Rich Trott) [#38395](https://github.com/nodejs/node/pull/38395)
* [[`45322dfa12`](https://github.com/nodejs/node/commit/45322dfa12)] - **test**: skip some pummel tests on slower machines (Rich Trott) [#38394](https://github.com/nodejs/node/pull/38394)
* [[`1bc47a4c0f`](https://github.com/nodejs/node/commit/1bc47a4c0f)] - **test**: fix test to allow quictls fork of OpenSSL 3 (Richard Lau) [#38372](https://github.com/nodejs/node/pull/38372)
* [[`6ac02755f5`](https://github.com/nodejs/node/commit/6ac02755f5)] - **test**: extend timeout on debugger tests for slower machines (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`93b0c78de0`](https://github.com/nodejs/node/commit/93b0c78de0)] - **test**: fix comment typo (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`6c3e5043b0`](https://github.com/nodejs/node/commit/6c3e5043b0)] - **test**: fix test-inspector-cli-address (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`27d7588ad5`](https://github.com/nodejs/node/commit/27d7588ad5)] - **test**: add ancestor package.json checks for tmpdir (Richard Lau) [#38285](https://github.com/nodejs/node/pull/38285)
* [[`30de03630e`](https://github.com/nodejs/node/commit/30de03630e)] - **test**: replace function with arrow function and remove unused argument (Andres) [#38235](https://github.com/nodejs/node/pull/38235)
* [[`eb8f5ce44f`](https://github.com/nodejs/node/commit/eb8f5ce44f)] - **test**: use .test domain for not found address (Richard Lau) [#38286](https://github.com/nodejs/node/pull/38286)
* [[`a4084d66c6`](https://github.com/nodejs/node/commit/a4084d66c6)] - **test,debugger**: migrate node-inspect tests to core (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`16eb078aa8`](https://github.com/nodejs/node/commit/16eb078aa8)] - **test,readline**: improve tab completion coverage (Antoine du Hamel) [#38465](https://github.com/nodejs/node/pull/38465)
* [[`b3ca1b358e`](https://github.com/nodejs/node/commit/b3ca1b358e)] - **timers**: remove redundant unref calls (Giora Guttsait) [#38320](https://github.com/nodejs/node/pull/38320)
* [[`5b393d9258`](https://github.com/nodejs/node/commit/5b393d9258)] - **tls**: validate ticket keys buffer (Antoine du Hamel) [#38308](https://github.com/nodejs/node/pull/38308)
* [[`f6745e9370`](https://github.com/nodejs/node/commit/f6745e9370)] - **tls**: fix `tlsSocket.setMaxSendFragment` abort (eladkeyshawn) [#38170](https://github.com/nodejs/node/pull/38170)
* [[`499da2d9e3`](https://github.com/nodejs/node/commit/499da2d9e3)] - **tools**: use mktemp to create the workspace directory (Luigi Pinca) [#38432](https://github.com/nodejs/node/pull/38432)
* [[`8a83bfd1bd`](https://github.com/nodejs/node/commit/8a83bfd1bd)] - **tools**: use a shallow clone of the npm/cli repository (Luigi Pinca) [#38463](https://github.com/nodejs/node/pull/38463)
* [[`bec959ef8b`](https://github.com/nodejs/node/commit/bec959ef8b)] - **tools**: disable LTO for "v8\_cppgc\_shared" target (Jesse Chan) [#38346](https://github.com/nodejs/node/pull/38346)
* [[`6350d35b3c`](https://github.com/nodejs/node/commit/6350d35b3c)] - **tools**: remove fixer for non-ascii-character ESLint custom rule (Rich Trott) [#38413](https://github.com/nodejs/node/pull/38413)
* [[`dce8d2968a`](https://github.com/nodejs/node/commit/dce8d2968a)] - **tools**: fix doc generation when version info is not available (Antoine du Hamel) [#38398](https://github.com/nodejs/node/pull/38398)
* [[`1033f6c8cb`](https://github.com/nodejs/node/commit/1033f6c8cb)] - **tools**: add \_depot\_tools to PATH (for V8 tests) (DeeDeeG) [#38299](https://github.com/nodejs/node/pull/38299)
* [[`28f02cb8cf`](https://github.com/nodejs/node/commit/28f02cb8cf)] - **tools**: update ESLint to 7.25.0 (Colin Ihrig) [#38378](https://github.com/nodejs/node/pull/38378)
* [[`f1ea2c8e2b`](https://github.com/nodejs/node/commit/f1ea2c8e2b)] - **tools**: update markdown linter rules (Rich Trott) [#38384](https://github.com/nodejs/node/pull/38384)
* [[`02e875c645`](https://github.com/nodejs/node/commit/02e875c645)] - **tools**: remove node-inspect from license (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`d3bd4b4771`](https://github.com/nodejs/node/commit/d3bd4b4771)] - **tools**: fix type mismatch in test runner (Richard Lau) [#38289](https://github.com/nodejs/node/pull/38289)
* [[`9a2651352b`](https://github.com/nodejs/node/commit/9a2651352b)] - **typings**: add JSDoc typings for fs (Voltrex) [#38306](https://github.com/nodejs/node/pull/38306)
* [[`e389e86b6b`](https://github.com/nodejs/node/commit/e389e86b6b)] - **typings**: add JSDoc typings for util (Rohit Gohri) [#38213](https://github.com/nodejs/node/pull/38213)
* [[`ec5b06eae3`](https://github.com/nodejs/node/commit/ec5b06eae3)] - **util**: fix infinite recursion during inspection (Ruben Bridgewater) [#37079](https://github.com/nodejs/node/pull/37079)
* [[`67bd0ec15c`](https://github.com/nodejs/node/commit/67bd0ec15c)] - **zlib**: fix brotli flush range (Khaidi Chu) [#38408](https://github.com/nodejs/node/pull/38408)

<a id="16.0.0"></a>
## 2021-04-20, Version 16.0.0 (Current), @BethGriggs

### Notable Changes

#### Deprecations and Removals

* **(SEMVER-MAJOR)** **fs**: remove permissive rmdir recursive (Antoine du Hamel) [#37216](https://github.com/nodejs/node/pull/37216)
* **(SEMVER-MAJOR)** **fs**: runtime deprecate rmdir recursive option (Antoine du Hamel) [#37302](https://github.com/nodejs/node/pull/37302)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('http\_parser') (James M Snell) [#37813](https://github.com/nodejs/node/pull/37813)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('url') (James M Snell) [#37799](https://github.com/nodejs/node/pull/37799)
* **(SEMVER-MAJOR)** **lib**: make process.binding('util') return only type checkers (Anna Henningsen) [#37819](https://github.com/nodejs/node/pull/37819)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('crypto') (James M Snell) [#37790](https://github.com/nodejs/node/pull/37790)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('signal\_wrap') (James M Snell) [#37800](https://github.com/nodejs/node/pull/37800)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('v8') (James M Snell) [#37789](https://github.com/nodejs/node/pull/37789)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('async\_wrap') (James M Snell) [#37576](https://github.com/nodejs/node/pull/37576)
* **(SEMVER-MAJOR)** **module**: remove module.createRequireFromPath (Antoine du Hamel) [#37201](https://github.com/nodejs/node/pull/37201)
* **(SEMVER-MAJOR)** **module**: runtime deprecate subpath folder mappings (Antoine du Hamel) [#37215](https://github.com/nodejs/node/pull/37215)
* **(SEMVER-MAJOR)** **module**: runtime deprecate "main" index and extension lookups (Antoine du Hamel) [#37206](https://github.com/nodejs/node/pull/37206)
* **(SEMVER-MAJOR)** **module**: runtime deprecate invalid package.json main entries (Antoine du Hamel) [#37204](https://github.com/nodejs/node/pull/37204)
* **(SEMVER-MAJOR)** **process**: runtime deprecate changing process.config (James M Snell) [#36902](https://github.com/nodejs/node/pull/36902)

#### Stable Timers Promises API

The Timers Promises API provides an alternative set of timer functions that return Promise objects. Added in Node.js v15.0.0, in this release they graduate from experimental status to stable.

Contributed by James Snell - [#38112](https://github.com/nodejs/node/pull/38112)

#### Toolchain and Compiler Upgrades

Node.js v16.0.0 will be the first release where we ship prebuilt binaries for Apple Silicon. While we’ll be providing separate tarballs for the Intel (`darwin-x64`) and ARM (`darwin-arm64`) architectures the macOS installer (`.pkg`) will be shipped as a ‘fat’ (multi-architecture) binary.

* **(SEMVER-MAJOR)** **build**: remove support for Python 2 (Christian Clauss) [#36691](https://github.com/nodejs/node/pull/36691)
* **(SEMVER-MAJOR)** **build**: default PYTHON to python3 in Makefile (Michaël Zasso) [#37764](https://github.com/nodejs/node/pull/37764)
* **build**: update Makefile to support fat binary (Ash Cripps) [#37861](https://github.com/nodejs/node/pull/37861)
* **(SEMVER-MAJOR)** **build**: enable ASLR (PIE) on OS X (woodfairy) [#35704](https://github.com/nodejs/node/pull/35704)
* **build**: warn for gcc versions earlier than 8.3.0 (Richard Lau) [#37935](https://github.com/nodejs/node/pull/37935)
* **(SEMVER-MAJOR)** **doc**: update minimum supported Xcode to 11 (Michaël Zasso) [#37872](https://github.com/nodejs/node/pull/37872)
* **(SEMVER-MAJOR)** **doc**: update minimum supported GCC to 8.3 (Michaël Zasso) [#37871](https://github.com/nodejs/node/pull/37871)
* **(SEMVER-MAJOR)** **doc**: update AIX to GCC8 for v16.x (Ash Cripps) [#37677](https://github.com/nodejs/node/pull/37677)
* **tools**: set arch in Distribution.xml (Ash Cripps) [#38261](https://github.com/nodejs/node/pull/38261)

#### V8 9.0

The V8 JavaScript engine is updated to V8 9.0, including performance tweaks and improvements.

This update also brings the ECMAScript RegExp Match Indices, which provide the start and end indices of the captured string. The indices array is available via the `.indices` property on match objects when the regular expression has the `/d` flag.

Contributed by Michaël Zasso - [#37587](https://github.com/nodejs/node/pull/37587)

#### Other Notable Changes

* **(SEMVER-MINOR)** **assert**: graduate assert.match and assert.doesNotMatch (James M Snell) [#38111](https://github.com/nodejs/node/pull/38111)
* **(SEMVER-MAJOR)** **buffer**: expose btoa and atob as globals (James M Snell) [#37786](https://github.com/nodejs/node/pull/37786)
* **(SEMVER-MAJOR)** **deps**: bump minimum ICU version to 68 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* **deps**: update ICU to 69.1 (Michaël Zasso) [#38178](https://github.com/nodejs/node/pull/38178)
* **deps**: update llhttp to 6.0.0 (Fedor Indutny) [#38277](https://github.com/nodejs/node/pull/38277)
* **deps**: upgrade npm to 7.10.0 (Ruy Adorno) [#38254](https://github.com/nodejs/node/pull/38254)
* **(SEMVER-MINOR)** **http**: add http.ClientRequest.getRawHeaderNames() (simov) [#37660](https://github.com/nodejs/node/pull/37660)
* **(SEMVER-MAJOR)** **lib,src**: update cluster to use Parent (Michael Dawson) [#36478](https://github.com/nodejs/node/pull/36478)
* **(SEMVER-MINOR)** **module**: add support for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* **(SEMVER-MINOR)** **perf_hooks**: add histogram option to timerify (James M Snell) [#37475](https://github.com/nodejs/node/pull/37475)
* **(SEMVER-MINOR)** **repl**: add auto‑completion for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* **(SEMVER-MINOR)** **util**: add getSystemErrorMap() impl (eladkeyshawn) [#38101](https://github.com/nodejs/node/pull/38101)

### Semver-Major Commits

* [[`324a6c235a`](https://github.com/nodejs/node/commit/324a6c235a)] - **(SEMVER-MAJOR)** **async_hooks**: add thisArg to AsyncResource.bind (James M Snell) [#36782](https://github.com/nodejs/node/pull/36782)
* [[`d1e2184c8e`](https://github.com/nodejs/node/commit/d1e2184c8e)] - **(SEMVER-MAJOR)** **buffer**: expose btoa and atob as globals (James M Snell) [#37786](https://github.com/nodejs/node/pull/37786)
* [[`4268fae04a`](https://github.com/nodejs/node/commit/4268fae04a)] - **(SEMVER-MAJOR)** **build**: remove support for Python 2 (Christian Clauss) [#36691](https://github.com/nodejs/node/pull/36691)
* [[`c3a5e15ebe`](https://github.com/nodejs/node/commit/c3a5e15ebe)] - **(SEMVER-MAJOR)** **build**: default PYTHON to python3 in Makefile (Michaël Zasso) [#37764](https://github.com/nodejs/node/pull/37764)
* [[`1d8c022544`](https://github.com/nodejs/node/commit/1d8c022544)] - **(SEMVER-MAJOR)** **build**: update Makefile to support fat binary (Ash Cripps) [#37861](https://github.com/nodejs/node/pull/37861)
* [[`38f32386c1`](https://github.com/nodejs/node/commit/38f32386c1)] - **(SEMVER-MAJOR)** **build**: include minimal V8 headers in distribution (Michaël Zasso) [#37570](https://github.com/nodejs/node/pull/37570)
* [[`a19af5ee71`](https://github.com/nodejs/node/commit/a19af5ee71)] - **(SEMVER-MAJOR)** **build**: use C++11 ABI with libstdc++ (Anna Henningsen) [#36634](https://github.com/nodejs/node/pull/36634)
* [[`8d6b74d347`](https://github.com/nodejs/node/commit/8d6b74d347)] - **(SEMVER-MAJOR)** **build**: enable ASLR (PIE) on OS X (woodfairy) [#35704](https://github.com/nodejs/node/pull/35704)
* [[`732ad99e47`](https://github.com/nodejs/node/commit/732ad99e47)] - **(SEMVER-MAJOR)** **deps**: update V8 to 9.0.257.11 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`43cc8e4b2e`](https://github.com/nodejs/node/commit/43cc8e4b2e)] - **(SEMVER-MAJOR)** **deps**: bump minimum ICU version to 68 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`c5ff019a4e`](https://github.com/nodejs/node/commit/c5ff019a4e)] - **(SEMVER-MAJOR)** **deps**: update V8 to 8.9.255.19 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`c7b3292251`](https://github.com/nodejs/node/commit/c7b3292251)] - **(SEMVER-MAJOR)** **deps**: update V8 to 8.8.278.17 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`48db20f6f5`](https://github.com/nodejs/node/commit/48db20f6f5)] - **(SEMVER-MAJOR)** **deps**: update V8 to 8.7.220 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`d85e1f0703`](https://github.com/nodejs/node/commit/d85e1f0703)] - **(SEMVER-MAJOR)** **dns**: use url module instead of punycode for IDNA (Antoine du Hamel) [#35091](https://github.com/nodejs/node/pull/35091)
* [[`290c158018`](https://github.com/nodejs/node/commit/290c158018)] - **(SEMVER-MAJOR)** **doc**: update minimum supported Xcode to 11 (Michaël Zasso) [#37872](https://github.com/nodejs/node/pull/37872)
* [[`1ff2918d80`](https://github.com/nodejs/node/commit/1ff2918d80)] - **(SEMVER-MAJOR)** **doc**: update minimum supported GCC to 8.3 (Michaël Zasso) [#37871](https://github.com/nodejs/node/pull/37871)
* [[`2706e67116`](https://github.com/nodejs/node/commit/2706e67116)] - **(SEMVER-MAJOR)** **doc**: update AIX to GCC8 for v16.x (Ash Cripps) [#37677](https://github.com/nodejs/node/pull/37677)
* [[`5ae5ca90ef`](https://github.com/nodejs/node/commit/5ae5ca90ef)] - **(SEMVER-MAJOR)** **doc**: add http.IncomingMessage#connection (Pranshu Srivastava) [#33768](https://github.com/nodejs/node/pull/33768)
* [[`83d6e63aee`](https://github.com/nodejs/node/commit/83d6e63aee)] - **(SEMVER-MAJOR)** **events**: change EventTarget handler exception behavior (Nitzan Uziely) [#37237](https://github.com/nodejs/node/pull/37237)
* [[`9948036ee0`](https://github.com/nodejs/node/commit/9948036ee0)] - **(SEMVER-MAJOR)** **fs**: remove permissive rmdir recursive (Antoine du Hamel) [#37216](https://github.com/nodejs/node/pull/37216)
* [[`d4693ff430`](https://github.com/nodejs/node/commit/d4693ff430)] - **(SEMVER-MAJOR)** **fs**: add validation for fd and path (Dylan Elliott) [#35187](https://github.com/nodejs/node/pull/35187)
* [[`0ddd75bcd8`](https://github.com/nodejs/node/commit/0ddd75bcd8)] - **(SEMVER-MAJOR)** **fs**: runtime deprecate rmdir recursive option (Antoine du Hamel) [#37302](https://github.com/nodejs/node/pull/37302)
* [[`da217d0773`](https://github.com/nodejs/node/commit/da217d0773)] - **(SEMVER-MAJOR)** **fs**: fix flag and mode validation (James M Snell) [#37480](https://github.com/nodejs/node/pull/37480)
* [[`2ef9a76ece`](https://github.com/nodejs/node/commit/2ef9a76ece)] - **(SEMVER-MAJOR)** **http**: use objects with null prototype in Agent (Michaël Zasso) [#36409](https://github.com/nodejs/node/pull/36409)
* [[`25e30005b8`](https://github.com/nodejs/node/commit/25e30005b8)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('http\_parser') (James M Snell) [#37813](https://github.com/nodejs/node/pull/37813)
* [[`8bb4e048af`](https://github.com/nodejs/node/commit/8bb4e048af)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('url') (James M Snell) [#37799](https://github.com/nodejs/node/pull/37799)
* [[`fe73e4d578`](https://github.com/nodejs/node/commit/fe73e4d578)] - **(SEMVER-MAJOR)** **lib**: make process.binding('util') return only type checkers (Anna Henningsen) [#37819](https://github.com/nodejs/node/pull/37819)
* [[`3bee6d8aad`](https://github.com/nodejs/node/commit/3bee6d8aad)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('crypto') (James M Snell) [#37790](https://github.com/nodejs/node/pull/37790)
* [[`ac00df112e`](https://github.com/nodejs/node/commit/ac00df112e)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('signal\_wrap') (James M Snell) [#37800](https://github.com/nodejs/node/pull/37800)
* [[`ae595d76e3`](https://github.com/nodejs/node/commit/ae595d76e3)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('v8') (James M Snell) [#37789](https://github.com/nodejs/node/pull/37789)
* [[`104dac79cc`](https://github.com/nodejs/node/commit/104dac79cc)] - **(SEMVER-MAJOR)** **lib**: aggregate errors to avoid error swallowing (Antoine du Hamel) [#37460](https://github.com/nodejs/node/pull/37460)
* [[`1468c9ff7c`](https://github.com/nodejs/node/commit/1468c9ff7c)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('async\_wrap') (James M Snell) [#37576](https://github.com/nodejs/node/pull/37576)
* [[`295e766c27`](https://github.com/nodejs/node/commit/295e766c27)] - **(SEMVER-MAJOR)** **lib**: remove usage of url.parse (raisinten) [#36853](https://github.com/nodejs/node/pull/36853)
* [[`cb3020d824`](https://github.com/nodejs/node/commit/cb3020d824)] - **(SEMVER-MAJOR)** **lib**: add error handling for input stream (rexagod) [#31603](https://github.com/nodejs/node/pull/31603)
* [[`15164cebce`](https://github.com/nodejs/node/commit/15164cebce)] - **(SEMVER-MAJOR)** **lib,src**: update cluster to use Parent (Michael Dawson) [#36478](https://github.com/nodejs/node/pull/36478)
* [[`3cc9aec988`](https://github.com/nodejs/node/commit/3cc9aec988)] - **(SEMVER-MAJOR)** **module**: runtime deprecate subpath folder mappings (Antoine du Hamel) [#37215](https://github.com/nodejs/node/pull/37215)
* [[`9fab73c73b`](https://github.com/nodejs/node/commit/9fab73c73b)] - **(SEMVER-MAJOR)** **module**: runtime deprecate "main" index and extension lookups (Antoine du Hamel) [#37206](https://github.com/nodejs/node/pull/37206)
* [[`76a073b67e`](https://github.com/nodejs/node/commit/76a073b67e)] - **(SEMVER-MAJOR)** **module**: runtime deprecate invalid package.json main entries (Antoine du Hamel) [#37204](https://github.com/nodejs/node/pull/37204)
* [[`674614b3f5`](https://github.com/nodejs/node/commit/674614b3f5)] - **(SEMVER-MAJOR)** **module**: remove module.createRequireFromPath (Antoine du Hamel) [#37201](https://github.com/nodejs/node/pull/37201)
* [[`aecd5ebf49`](https://github.com/nodejs/node/commit/aecd5ebf49)] - **(SEMVER-MAJOR)** **module**: only set cache when finding module succeeds (Yongsheng Zhang) [#36642](https://github.com/nodejs/node/pull/36642)
* [[`f0bf373176`](https://github.com/nodejs/node/commit/f0bf373176)] - **(SEMVER-MAJOR)** **perf_hooks**: make performance a global (James M Snell) [#37970](https://github.com/nodejs/node/pull/37970)
* [[`f3eb224c83`](https://github.com/nodejs/node/commit/f3eb224c83)] - **(SEMVER-MAJOR)** **perf_hooks**: complete overhaul of the implementation (James M Snell) [#37136](https://github.com/nodejs/node/pull/37136)
* [[`f1753d4c76`](https://github.com/nodejs/node/commit/f1753d4c76)] - **(SEMVER-MAJOR)** **process**: disallow adding options to process.allowedNodeEnvironmentFlags (Antoine du Hamel) [#36660](https://github.com/nodejs/node/pull/36660)
* [[`96f3977ded`](https://github.com/nodejs/node/commit/96f3977ded)] - **(SEMVER-MAJOR)** **process**: runtime deprecate changing process.config (James M Snell) [#36902](https://github.com/nodejs/node/pull/36902)
* [[`45dbcbef90`](https://github.com/nodejs/node/commit/45dbcbef90)] - **(SEMVER-MAJOR)** **readline**: cursorTo throw error on NaN (Zijian Liu) [#36379](https://github.com/nodejs/node/pull/36379)
* [[`bf79987433`](https://github.com/nodejs/node/commit/bf79987433)] - **(SEMVER-MAJOR)** **src**: mark internally exported functions as explicitly internal (Tyler Ang-Wanek) [#37000](https://github.com/nodejs/node/pull/37000)
* [[`1fe571aa0c`](https://github.com/nodejs/node/commit/1fe571aa0c)] - **(SEMVER-MAJOR)** **src**: inline AsyncCleanupHookHandle in headers (Tyler Ang-Wanek) [#37000](https://github.com/nodejs/node/pull/37000)
* [[`dfc288e7fd`](https://github.com/nodejs/node/commit/dfc288e7fd)] - **(SEMVER-MAJOR)** **src**: clean up embedder API (Anna Henningsen) [#35897](https://github.com/nodejs/node/pull/35897)
* [[`65e8864fa3`](https://github.com/nodejs/node/commit/65e8864fa3)] - **(SEMVER-MAJOR)** **worker**: send correct error status for worker init (Yash Ladha) [#36242](https://github.com/nodejs/node/pull/36242)

### Semver-Minor Commits

* [[`944a956087`](https://github.com/nodejs/node/commit/944a956087)] - **(SEMVER-MINOR)** **assert**: graduate assert.match and assert.doesNotMatch (James M Snell) [#38111](https://github.com/nodejs/node/pull/38111)
* [[`6a1986d50a`](https://github.com/nodejs/node/commit/6a1986d50a)] - **(SEMVER-MINOR)** **deps**: update llhttp to 5.1.0 (Fedor Indutny) [#38146](https://github.com/nodejs/node/pull/38146)
* [[`069b5df4f6`](https://github.com/nodejs/node/commit/069b5df4f6)] - **(SEMVER-MINOR)** **module**: add support for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* [[`b803bca4fa`](https://github.com/nodejs/node/commit/b803bca4fa)] - **(SEMVER-MINOR)** **perf_hooks**: add histogram option to timerify (James M Snell) [#37475](https://github.com/nodejs/node/pull/37475)
* [[`95391fe689`](https://github.com/nodejs/node/commit/95391fe689)] - **(SEMVER-MINOR)** **repl**: add auto‑completion for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* [[`15b8e6b1c4`](https://github.com/nodejs/node/commit/15b8e6b1c4)] - **(SEMVER-MINOR)** **timers**: graduate awaitable timers and improve docs (James M Snell) [#38112](https://github.com/nodejs/node/pull/38112)
* [[`802171057f`](https://github.com/nodejs/node/commit/802171057f)] - **(SEMVER-MINOR)** **util**: add getSystemErrorMap() impl (eladkeyshawn) [#38101](https://github.com/nodejs/node/pull/38101)

### Semver-Patch Commits

* [[`8930eba199`](https://github.com/nodejs/node/commit/8930eba199)] - **assert**: change status of legacy asserts (James M Snell) [#38113](https://github.com/nodejs/node/pull/38113)
* [[`0180fc5b9b`](https://github.com/nodejs/node/commit/0180fc5b9b)] - **benchmark**: improve compare.R output (Brian White) [#38118](https://github.com/nodejs/node/pull/38118)
* [[`8d9d8236b7`](https://github.com/nodejs/node/commit/8d9d8236b7)] - **bootstrap**: mksnapshot should show JS error (Bradley Meck) [#38174](https://github.com/nodejs/node/pull/38174)
* [[`6cb314bbe5`](https://github.com/nodejs/node/commit/6cb314bbe5)] - **bootstrap**: print information for snapshot at environment exit in debug (Joyee Cheung) [#37967](https://github.com/nodejs/node/pull/37967)
* [[`14aed60941`](https://github.com/nodejs/node/commit/14aed60941)] - **buffer,errors**: add missing n literal in range error string (Cactysman) [#37750](https://github.com/nodejs/node/pull/37750)
* [[`049b703a28`](https://github.com/nodejs/node/commit/049b703a28)] - **build**: sync generation of `v8\_build\_config.json` (Richard Lau) [#38263](https://github.com/nodejs/node/pull/38263)
* [[`1d21a8d140`](https://github.com/nodejs/node/commit/1d21a8d140)] - **build**: add riscv64 configure (luyahan) [#37980](https://github.com/nodejs/node/pull/37980)
* [[`f5eea1744d`](https://github.com/nodejs/node/commit/f5eea1744d)] - **build**: don't run test workflow on doc dir on macOS (ycjcl868) [#37999](https://github.com/nodejs/node/pull/37999)
* [[`2853b76e20`](https://github.com/nodejs/node/commit/2853b76e20)] - **build**: add pummel tests to ci runs (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`24426cd8c4`](https://github.com/nodejs/node/commit/24426cd8c4)] - **build**: prepare Windows coverage GitHub Action for pummel tests (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`7df0fc5c5c`](https://github.com/nodejs/node/commit/7df0fc5c5c)] - **build**: move OPENSSL\_API\_COMPAT to else clause (Daniel Bevenius) [#38126](https://github.com/nodejs/node/pull/38126)
* [[`9cfb418e1f`](https://github.com/nodejs/node/commit/9cfb418e1f)] - **build**: package release changelog for releases (Richard Lau) [#38033](https://github.com/nodejs/node/pull/38033)
* [[`558d1e6c22`](https://github.com/nodejs/node/commit/558d1e6c22)] - **build**: warn for gcc versions earlier than 8.3.0 (Richard Lau) [#37935](https://github.com/nodejs/node/pull/37935)
* [[`a572a4e34e`](https://github.com/nodejs/node/commit/a572a4e34e)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`f3c7078245`](https://github.com/nodejs/node/commit/f3c7078245)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`842389839b`](https://github.com/nodejs/node/commit/842389839b)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`98d1ae47cf`](https://github.com/nodejs/node/commit/98d1ae47cf)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`993ed19f9c`](https://github.com/nodejs/node/commit/993ed19f9c)] - **crypto**: reduce range of size to int max (Qingyu Deng) [#38096](https://github.com/nodejs/node/pull/38096)
* [[`896dc39951`](https://github.com/nodejs/node/commit/896dc39951)] - **crypto**: fix webcrypto derive(Bits|Key) resolve values and docs (Filip Skokan) [#38148](https://github.com/nodejs/node/pull/38148)
* [[`d2f116c6bb`](https://github.com/nodejs/node/commit/d2f116c6bb)] - **crypto**: fixup randomFill size and offset handling (James M Snell) [#38138](https://github.com/nodejs/node/pull/38138)
* [[`dfe3f952a3`](https://github.com/nodejs/node/commit/dfe3f952a3)] - **crypto**: fix crash in CCM mode without data (Tobias Nießen) [#38102](https://github.com/nodejs/node/pull/38102)
* [[`e8cb6446ef`](https://github.com/nodejs/node/commit/e8cb6446ef)] - **crypto**: reconcile oneshot sign/verify sync and async implementations (Filip Skokan) [#37816](https://github.com/nodejs/node/pull/37816)
* [[`1e4a2bcbee`](https://github.com/nodejs/node/commit/1e4a2bcbee)] - **crypto**: remove check for condition that is always true (Rich Trott) [#38072](https://github.com/nodejs/node/pull/38072)
* [[`64d5be25ab`](https://github.com/nodejs/node/commit/64d5be25ab)] - **deps**: V8: cherry-pick 1648e050cade (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`621b544909`](https://github.com/nodejs/node/commit/621b544909)] - **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`0d78bc3101`](https://github.com/nodejs/node/commit/0d78bc3101)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`5214918856`](https://github.com/nodejs/node/commit/5214918856)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`6b3caf77b2`](https://github.com/nodejs/node/commit/6b3caf77b2)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`d0a032fafb`](https://github.com/nodejs/node/commit/d0a032fafb)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`c8b2fa642e`](https://github.com/nodejs/node/commit/c8b2fa642e)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`8eeecc19ae`](https://github.com/nodejs/node/commit/8eeecc19ae)] - **deps**: V8: cherry-pick 8957d4677aa7 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`b186142a0b`](https://github.com/nodejs/node/commit/b186142a0b)] - **deps**: V8: backport a11395433dbd (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`290f2d8d3e`](https://github.com/nodejs/node/commit/290f2d8d3e)] - **deps**: V8: cherry-pick deb0813166f3 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`63ed0b8bfe`](https://github.com/nodejs/node/commit/63ed0b8bfe)] - **deps**: V8: cherry-pick 9a6a22874c81 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`47f1c5257a`](https://github.com/nodejs/node/commit/47f1c5257a)] - **deps**: silence irrelevant V8 warning (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`19d975241f`](https://github.com/nodejs/node/commit/19d975241f)] - **deps**: workaround stod() limitations on SmartOS (Colin Ihrig) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`70f928c6a6`](https://github.com/nodejs/node/commit/70f928c6a6)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`b045e39513`](https://github.com/nodejs/node/commit/b045e39513)] - **deps**: patch V8 to run on Xcode 8 (Mary Marchini) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`32725d2224`](https://github.com/nodejs/node/commit/32725d2224)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`fe3cee7b37`](https://github.com/nodejs/node/commit/fe3cee7b37)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`b2d05f7349`](https://github.com/nodejs/node/commit/b2d05f7349)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`c7a0ab4e3d`](https://github.com/nodejs/node/commit/c7a0ab4e3d)] - **deps**: patch V8 to run on older XCode versions (Ujjwal Sharma) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`60b623ee90`](https://github.com/nodejs/node/commit/60b623ee90)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`577ff9fee5`](https://github.com/nodejs/node/commit/577ff9fee5)] - **deps**: V8: cherry-pick deb0813166f3 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`00e1c7ea83`](https://github.com/nodejs/node/commit/00e1c7ea83)] - **deps**: V8: cherry-pick 9a6a22874c81 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`ee01d6b7fc`](https://github.com/nodejs/node/commit/ee01d6b7fc)] - **deps**: V8: cherry-pick 2059ee813359 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`2dad8d43cc`](https://github.com/nodejs/node/commit/2dad8d43cc)] - **deps**: V8: cherry-pick bde7ee5473d6 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`3046131ea0`](https://github.com/nodejs/node/commit/3046131ea0)] - **deps**: V8: cherry-pick 9a712984025e (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`d178d0738f`](https://github.com/nodejs/node/commit/d178d0738f)] - **deps**: V8: cherry-pick 0b96e5b0bfb2 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`5c71ea151a`](https://github.com/nodejs/node/commit/5c71ea151a)] - **deps**: V8: cherry-pick fbb28902e049 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`c8e15cd2c6`](https://github.com/nodejs/node/commit/c8e15cd2c6)] - **deps**: V8: cherry-pick 821fb3883a8e (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`b0d67426af`](https://github.com/nodejs/node/commit/b0d67426af)] - **deps**: workaround stod() limitations on SmartOS (Colin Ihrig) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`c8a658ac53`](https://github.com/nodejs/node/commit/c8a658ac53)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`153b8cea36`](https://github.com/nodejs/node/commit/153b8cea36)] - **deps**: patch V8 to run on Xcode 8 (Mary Marchini) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`a785984133`](https://github.com/nodejs/node/commit/a785984133)] - **deps**: V8: silence irrelevant warnings (Michaël Zasso) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`246c9b8c31`](https://github.com/nodejs/node/commit/246c9b8c31)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`96a567f9e9`](https://github.com/nodejs/node/commit/96a567f9e9)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`e74383cecb`](https://github.com/nodejs/node/commit/e74383cecb)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`732847f1eb`](https://github.com/nodejs/node/commit/732847f1eb)] - **deps**: patch V8 to run on older XCode versions (Ujjwal Sharma) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`70171d186f`](https://github.com/nodejs/node/commit/70171d186f)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`15c91c6dd5`](https://github.com/nodejs/node/commit/15c91c6dd5)] - **deps**: V8: cherry-pick 821fb3883a8e (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`40b2fa4832`](https://github.com/nodejs/node/commit/40b2fa4832)] - **deps**: V8: cherry-pick 45e49775f5a3 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`cd91ab5865`](https://github.com/nodejs/node/commit/cd91ab5865)] - **deps**: V8: cherry-pick 7b3a27b7ae65 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`f4fc099080`](https://github.com/nodejs/node/commit/f4fc099080)] - **deps**: V8: cherry-pick d76abfed3512 (Michaël Zasso) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`6200176ef0`](https://github.com/nodejs/node/commit/6200176ef0)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`bd5642deb9`](https://github.com/nodejs/node/commit/bd5642deb9)] - **deps**: update V8 postmortem metadata script (Colin Ihrig) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`9ae7159216`](https://github.com/nodejs/node/commit/9ae7159216)] - **deps**: update V8 postmortem metadata script (Colin Ihrig) [#33579](https://github.com/nodejs/node/pull/33579)
* [[`f4b4e21b2f`](https://github.com/nodejs/node/commit/f4b4e21b2f)] - **deps**: patch V8 to run on Xcode 8 (Mary Marchini) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`f6a84540d8`](https://github.com/nodejs/node/commit/f6a84540d8)] - **deps**: V8: silence irrelevant warnings (Michaël Zasso) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`bbc3f46572`](https://github.com/nodejs/node/commit/bbc3f46572)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`0c988642dc`](https://github.com/nodejs/node/commit/0c988642dc)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`703bf933d4`](https://github.com/nodejs/node/commit/703bf933d4)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`5451975b18`](https://github.com/nodejs/node/commit/5451975b18)] - **deps**: patch V8 to run on older XCode versions (Ujjwal Sharma) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`c460f7af4d`](https://github.com/nodejs/node/commit/c460f7af4d)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`bfee9daaa5`](https://github.com/nodejs/node/commit/bfee9daaa5)] - **deps**: update llhttp to 6.0.0 (Fedor Indutny) [#38277](https://github.com/nodejs/node/pull/38277)
* [[`94405650ae`](https://github.com/nodejs/node/commit/94405650ae)] - **deps**: upgrade npm to 7.10.0 (Ruy Adorno) [#38254](https://github.com/nodejs/node/pull/38254)
* [[`8e80fc7ff8`](https://github.com/nodejs/node/commit/8e80fc7ff8)] - **deps**: patch V8 to 9.0.257.17 (Michaël Zasso) [#38237](https://github.com/nodejs/node/pull/38237)
* [[`5b358d57e1`](https://github.com/nodejs/node/commit/5b358d57e1)] - **deps**: patch V8 to 9.0.257.16 (Michaël Zasso) [#38218](https://github.com/nodejs/node/pull/38218)
* [[`ee669a0d29`](https://github.com/nodejs/node/commit/ee669a0d29)] - **deps**: update ICU to 69.1 (Michaël Zasso) [#38178](https://github.com/nodejs/node/pull/38178)
* [[`2468e4ed3e`](https://github.com/nodejs/node/commit/2468e4ed3e)] - **deps**: V8: backport d59db06bf542 (Antoine du Hamel) [#38162](https://github.com/nodejs/node/pull/38162)
* [[`c748668704`](https://github.com/nodejs/node/commit/c748668704)] - **deps**: upgrade npm to 7.9.0 (Ruy Adorno) [#38156](https://github.com/nodejs/node/pull/38156)
* [[`ca13f7aaf3`](https://github.com/nodejs/node/commit/ca13f7aaf3)] - **deps**: V8: cherry-pick 501482cbc704 (Colin Ihrig) [#38121](https://github.com/nodejs/node/pull/38121)
* [[`bc531d1860`](https://github.com/nodejs/node/commit/bc531d1860)] - **deps**: upgrade npm to 7.8.0 (Darcy Clarke) [#38030](https://github.com/nodejs/node/pull/38030)
* [[`d639321acd`](https://github.com/nodejs/node/commit/d639321acd)] - **deps**: patch V8 to 9.0.257.13 (Michaël Zasso) [#37830](https://github.com/nodejs/node/pull/37830)
* [[`bc31dc0e0f`](https://github.com/nodejs/node/commit/bc31dc0e0f)] - **dns**: refactor cares\_wrap internals (James M Snell) [#38172](https://github.com/nodejs/node/pull/38172)
* [[`36decec87f`](https://github.com/nodejs/node/commit/36decec87f)] - **doc**: remove superfluous await from fsPromises.readdir example (Michael Rommel) [#38293](https://github.com/nodejs/node/pull/38293)
* [[`ac2c8c530d`](https://github.com/nodejs/node/commit/ac2c8c530d)] - **doc**: fixup http.IncomingMessage deprecation code (Guy Bedford) [#36917](https://github.com/nodejs/node/pull/36917)
* [[`767643fc19`](https://github.com/nodejs/node/commit/767643fc19)] - **doc**: restore minimum Xcode version for macOS (Richard Lau) [#38266](https://github.com/nodejs/node/pull/38266)
* [[`e541032276`](https://github.com/nodejs/node/commit/e541032276)] - **doc**: fix typo in repl.md (Arkerone) [#38244](https://github.com/nodejs/node/pull/38244)
* [[`fb93b71307`](https://github.com/nodejs/node/commit/fb93b71307)] - **doc**: fix typo in buffer.md (Arkerone) [#38243](https://github.com/nodejs/node/pull/38243)
* [[`7d688d4b36`](https://github.com/nodejs/node/commit/7d688d4b36)] - **doc**: fix missing backtick in fs.md (Siddharth) [#38260](https://github.com/nodejs/node/pull/38260)
* [[`6d04cc6849`](https://github.com/nodejs/node/commit/6d04cc6849)] - **doc**: change "oject" to "object" (Arkerone) [#38256](https://github.com/nodejs/node/pull/38256)
* [[`b4363f726c`](https://github.com/nodejs/node/commit/b4363f726c)] - **doc**: revise TLS minVersion/maxVersion text (Rich Trott) [#38202](https://github.com/nodejs/node/pull/38202)
* [[`98c2067f13`](https://github.com/nodejs/node/commit/98c2067f13)] - **doc**: update BUILDING.md for Apple Silicon (Ash Cripps) [#38227](https://github.com/nodejs/node/pull/38227)
* [[`4def7c4418`](https://github.com/nodejs/node/commit/4def7c4418)] - **doc**: standardize on pseudorandom (Rich Trott) [#38196](https://github.com/nodejs/node/pull/38196)
* [[`f1027ecf29`](https://github.com/nodejs/node/commit/f1027ecf29)] - **doc**: standardize command flag notes (Ferdi) [#38199](https://github.com/nodejs/node/pull/38199)
* [[`756d2e48d8`](https://github.com/nodejs/node/commit/756d2e48d8)] - **doc**: update `buffer.constants.MAX\_LENGTH` (Qingyu Deng) [#38109](https://github.com/nodejs/node/pull/38109)
* [[`474fbb5f6e`](https://github.com/nodejs/node/commit/474fbb5f6e)] - **doc**: clarify child\_process close event (Nitzan Uziely) [#38181](https://github.com/nodejs/node/pull/38181)
* [[`eee2c331ef`](https://github.com/nodejs/node/commit/eee2c331ef)] - **doc**: add command flag to import.meta.resolve (Ferdi) [#38171](https://github.com/nodejs/node/pull/38171)
* [[`f46d29360c`](https://github.com/nodejs/node/commit/f46d29360c)] - **doc**: advise against using randomFill on floats (Tobias Nießen) [#38150](https://github.com/nodejs/node/pull/38150)
* [[`5823fc79ba`](https://github.com/nodejs/node/commit/5823fc79ba)] - **doc**: update links in ICU guide (Michaël Zasso) [#38177](https://github.com/nodejs/node/pull/38177)
* [[`993a1da47c`](https://github.com/nodejs/node/commit/993a1da47c)] - **doc**: mention cryptographic prng in description of randomUUID (Serkan Özel) [#38074](https://github.com/nodejs/node/pull/38074)
* [[`5ba5cc8619`](https://github.com/nodejs/node/commit/5ba5cc8619)] - **doc**: fix typos in doc/api/cli.md (Arkerone) [#38163](https://github.com/nodejs/node/pull/38163)
* [[`6a2314acd7`](https://github.com/nodejs/node/commit/6a2314acd7)] - **doc**: add link to V8 (Voltrex) [#38144](https://github.com/nodejs/node/pull/38144)
* [[`093b527b25`](https://github.com/nodejs/node/commit/093b527b25)] - **doc**: fix typo in assert.md (Arkerone) [#38152](https://github.com/nodejs/node/pull/38152)
* [[`0fa579ac2a`](https://github.com/nodejs/node/commit/0fa579ac2a)] - **doc**: add missing comma in crypto doc (Tobias Nießen) [#38142](https://github.com/nodejs/node/pull/38142)
* [[`4bc8f7542f`](https://github.com/nodejs/node/commit/4bc8f7542f)] - **doc**: fix typo in crypto (Arkerone) [#38130](https://github.com/nodejs/node/pull/38130)
* [[`005ebafbd1`](https://github.com/nodejs/node/commit/005ebafbd1)] - **doc**: improve security text in collaborators guide (Rich Trott) [#38107](https://github.com/nodejs/node/pull/38107)
* [[`54322b8d8b`](https://github.com/nodejs/node/commit/54322b8d8b)] - **doc**: apply consistent punctuation to header contributing guide (Akhil Marsonya) [#38047](https://github.com/nodejs/node/pull/38047)
* [[`0d34767c4c`](https://github.com/nodejs/node/commit/0d34767c4c)] - **doc**: sending http request to localhost to avoid https redirect (Hassaan Pasha) [#38036](https://github.com/nodejs/node/pull/38036)
* [[`f851efd2e1`](https://github.com/nodejs/node/commit/f851efd2e1)] - **doc**: apply sentence case to backporting-to-release-lines.md headers (marsonya) [#37617](https://github.com/nodejs/node/pull/37617)
* [[`36bc8b905c`](https://github.com/nodejs/node/commit/36bc8b905c)] - **doc**: fix typo in fs.md (Antoine du Hamel) [#38100](https://github.com/nodejs/node/pull/38100)
* [[`f52c92134c`](https://github.com/nodejs/node/commit/f52c92134c)] - **doc**: internal/test/binding for testing (Bradley Meck) [#38026](https://github.com/nodejs/node/pull/38026)
* [[`ab42ef3930`](https://github.com/nodejs/node/commit/ab42ef3930)] - **doc**: add parentheses to function and move reference (Rich Trott) [#38066](https://github.com/nodejs/node/pull/38066)
* [[`2861778ecd`](https://github.com/nodejs/node/commit/2861778ecd)] - **doc**: change wording in doc/api/domain.md comment (Akhil Marsonya) [#38044](https://github.com/nodejs/node/pull/38044)
* [[`361632dab1`](https://github.com/nodejs/node/commit/361632dab1)] - **doc**: fix lint error in modules.md (Rich Trott) [#37811](https://github.com/nodejs/node/pull/37811)
* [[`b3f35e2c70`](https://github.com/nodejs/node/commit/b3f35e2c70)] - **doc,lib**: add missing deprecation code (Colin Ihrig) [#37541](https://github.com/nodejs/node/pull/37541)
* [[`cbe3b27166`](https://github.com/nodejs/node/commit/cbe3b27166)] - **doc,tools**: allow stability table to be updated (Richard Lau) [#38048](https://github.com/nodejs/node/pull/38048)
* [[`8dd06850ae`](https://github.com/nodejs/node/commit/8dd06850ae)] - **esm**: use correct URL for error decoration (Bradley Meck) [#37854](https://github.com/nodejs/node/pull/37854)
* [[`6bbe28552c`](https://github.com/nodejs/node/commit/6bbe28552c)] - **fs**: use byteLength to handle ArrayBuffer views (Michaël Zasso) [#38187](https://github.com/nodejs/node/pull/38187)
* [[`8e76397fab`](https://github.com/nodejs/node/commit/8e76397fab)] - **fs**: validate encoding to binding.writeString() (Colin Ihrig) [#38183](https://github.com/nodejs/node/pull/38183)
* [[`24fd791184`](https://github.com/nodejs/node/commit/24fd791184)] - **fs**: move constants to internal/fs/utils.js (Darshan Sen) [#38061](https://github.com/nodejs/node/pull/38061)
* [[`40ace47396`](https://github.com/nodejs/node/commit/40ace47396)] - **http**: fixup perf regression (James M Snell) [#38110](https://github.com/nodejs/node/pull/38110)
* [[`f4d3d12327`](https://github.com/nodejs/node/commit/f4d3d12327)] - **http**: use CRLF conistently in \_http\_outgoing.js (Daniel Bevenius) [#37851](https://github.com/nodejs/node/pull/37851)
* [[`ee9e2a2eb6`](https://github.com/nodejs/node/commit/ee9e2a2eb6)] - **lib**: revert primordials in a hot path (Antoine du Hamel) [#38248](https://github.com/nodejs/node/pull/38248)
* [[`d756d2b99c`](https://github.com/nodejs/node/commit/d756d2b99c)] - **lib**: enforce using `primordials.globalThis` instead of `global` (Antoine du Hamel) [#38230](https://github.com/nodejs/node/pull/38230)
* [[`09c9e5dea4`](https://github.com/nodejs/node/commit/09c9e5dea4)] - **lib**: avoid mutating `Error.stackTraceLimit` when it is not writable (Antoine du Hamel) [#38215](https://github.com/nodejs/node/pull/38215)
* [[`23d2c54bab`](https://github.com/nodejs/node/commit/23d2c54bab)] - **lib**: add `globalThis` to primordials (Antoine du Hamel) [#38211](https://github.com/nodejs/node/pull/38211)
* [[`78343bbdc5`](https://github.com/nodejs/node/commit/78343bbdc5)] - **lib**: add `WeakRef` and `FinalizationRegistry` to `primordials` (ExE Boss) [#37263](https://github.com/nodejs/node/pull/37263)
* [[`656fb4657a`](https://github.com/nodejs/node/commit/656fb4657a)] - **lib**: add tsconfig for code completions (Bradley Meck) [#38042](https://github.com/nodejs/node/pull/38042)
* [[`d86132488d`](https://github.com/nodejs/node/commit/d86132488d)] - **lib**: properly process JavaScript exceptions on async\_hooks fatal error (legendecas) [#38106](https://github.com/nodejs/node/pull/38106)
* [[`a9332e84bf`](https://github.com/nodejs/node/commit/a9332e84bf)] - **lib**: refactor to use primordials in lib/internal/cli\_table (Akhil Marsonya) [#38046](https://github.com/nodejs/node/pull/38046)
* [[`8d78d9ef27`](https://github.com/nodejs/node/commit/8d78d9ef27)] - **lib**: load v8\_prof\_processor dependencies as ESM (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`7b2bad4005`](https://github.com/nodejs/node/commit/7b2bad4005)] - **module**: clarify CJS global-like variables not defined error message (Antoine du Hamel) [#37852](https://github.com/nodejs/node/pull/37852)
* [[`7869761c2e`](https://github.com/nodejs/node/commit/7869761c2e)] - **net**: fix typo (Luigi Pinca) [#38127](https://github.com/nodejs/node/pull/38127)
* [[`4afcd55274`](https://github.com/nodejs/node/commit/4afcd55274)] - **node-api**: make reference weak parameter an indirect link to references (Chengzhong Wu) [#38000](https://github.com/nodejs/node/pull/38000)
* [[`e38d62a8c9`](https://github.com/nodejs/node/commit/e38d62a8c9)] - **path**: fix POSIX path.resolve() perf regression (Brian White) [#38064](https://github.com/nodejs/node/pull/38064)
* [[`b0d5e036d8`](https://github.com/nodejs/node/commit/b0d5e036d8)] - **path**: fix posix.relative() on Windows (Rich Trott) [#37747](https://github.com/nodejs/node/pull/37747)
* [[`548cbf0625`](https://github.com/nodejs/node/commit/548cbf0625)] - **perf_hooks**: fix loop delay resolution validation (Antoine du Hamel) [#38166](https://github.com/nodejs/node/pull/38166)
* [[`13c931a9dc`](https://github.com/nodejs/node/commit/13c931a9dc)] - **process**: add range validation to debugPort (Colin Ihrig) [#38205](https://github.com/nodejs/node/pull/38205)
* [[`8dd5dd8a4b`](https://github.com/nodejs/node/commit/8dd5dd8a4b)] - **process**: do not lazily load AsyncResource (Michaël Zasso) [#38041](https://github.com/nodejs/node/pull/38041)
* [[`4e833b6059`](https://github.com/nodejs/node/commit/4e833b6059)] - **process,doc**: add missing deprecation code (Colin Ihrig) [#37091](https://github.com/nodejs/node/pull/37091)
* [[`d6669645c0`](https://github.com/nodejs/node/commit/d6669645c0)] - **repl**: fix declaring a variable with the name `util` (eladkeyshawn) [#38141](https://github.com/nodejs/node/pull/38141)
* [[`e7391967c2`](https://github.com/nodejs/node/commit/e7391967c2)] - **repl**: fix error message printing (Anna Henningsen) [#38209](https://github.com/nodejs/node/pull/38209)
* [[`4e9212bb7b`](https://github.com/nodejs/node/commit/4e9212bb7b)] - **src**: cache some context in locals (Khaidi Chu) [#37473](https://github.com/nodejs/node/pull/37473)
* [[`fc20e833ca`](https://github.com/nodejs/node/commit/fc20e833ca)] - **src**: fix finalization crash (James M Snell) [#38250](https://github.com/nodejs/node/pull/38250)
* [[`6c9b19a7af`](https://github.com/nodejs/node/commit/6c9b19a7af)] - **src**: refactor SecureContext Initialization (James M Snell) [#38116](https://github.com/nodejs/node/pull/38116)
* [[`8d63aa828e`](https://github.com/nodejs/node/commit/8d63aa828e)] - **src**: fix typo for initialization (Yash Ladha) [#37974](https://github.com/nodejs/node/pull/37974)
* [[`66c8f76c2c`](https://github.com/nodejs/node/commit/66c8f76c2c)] - **src**: remove KeyObjectData::CreateSecret overload (Tobias Nießen) [#38067](https://github.com/nodejs/node/pull/38067)
* [[`87dc152229`](https://github.com/nodejs/node/commit/87dc152229)] - **src**: fix node version (Richard Lau) [#36460](https://github.com/nodejs/node/pull/36460)
* [[`e929d1f2c8`](https://github.com/nodejs/node/commit/e929d1f2c8)] - **src**: fix node version (Brian White) [#36385](https://github.com/nodejs/node/pull/36385)
* [[`8e8dea36cc`](https://github.com/nodejs/node/commit/8e8dea36cc)] - **src**: use non-deprecated GetCreationContext from V8 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`b1c1c4695c`](https://github.com/nodejs/node/commit/b1c1c4695c)] - **src**: remove V8\_FT\_ADAPTOR for V8 update (Colin Ihrig) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`8f5cce6862`](https://github.com/nodejs/node/commit/8f5cce6862)] - **src**: use non-deprecated V8 module APIs (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`497f6ca5b4`](https://github.com/nodejs/node/commit/497f6ca5b4)] - **src**: update NODE\_MODULE\_VERSION to 93 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`001dc16cf1`](https://github.com/nodejs/node/commit/001dc16cf1)] - **src**: use non-deprecated V8 module and script APIs (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`47a90d9f37`](https://github.com/nodejs/node/commit/47a90d9f37)] - **src**: update NODE\_MODULE\_VERSION to 92 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`5259d17309`](https://github.com/nodejs/node/commit/5259d17309)] - **src**: update NODE\_MODULE\_VERSION to 91 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`6f9cbcf6a6`](https://github.com/nodejs/node/commit/6f9cbcf6a6)] - **src**: fix v8 api deprecation (Jiawen Geng) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`9d4d55bd94`](https://github.com/nodejs/node/commit/9d4d55bd94)] - **src**: update NODE\_MODULE\_VERSION to 90 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`369f239503`](https://github.com/nodejs/node/commit/369f239503)] - **stream**: fix multiple Writable.destroy() calls (Robert Nagy) [#38221](https://github.com/nodejs/node/pull/38221)
* [[`4ad46e2fef`](https://github.com/nodejs/node/commit/4ad46e2fef)] - **stream**: refactor to avoid unsafe array iteration (Antoine du Hamel) [#37126](https://github.com/nodejs/node/pull/37126)
* [[`419686cdfb`](https://github.com/nodejs/node/commit/419686cdfb)] - **stream**: refactor to use more primordials (Antoine du Hamel) [#36346](https://github.com/nodejs/node/pull/36346)
* [[`c704faa0f9`](https://github.com/nodejs/node/commit/c704faa0f9)] - **test**: fix flaky test-dns and test-dns-lookup (Rich Trott) [#38282](https://github.com/nodejs/node/pull/38282)
* [[`5e588c1c7c`](https://github.com/nodejs/node/commit/5e588c1c7c)] - **test**: fixup failing test/internet/test-dns.js (James M Snell) [#38241](https://github.com/nodejs/node/pull/38241)
* [[`18c9913ce1`](https://github.com/nodejs/node/commit/18c9913ce1)] - **test**: add tests for missing https agent options (Rich Trott) [#38202](https://github.com/nodejs/node/pull/38202)
* [[`4ad8e83a3d`](https://github.com/nodejs/node/commit/4ad8e83a3d)] - **test**: fix test-https-agent-additional-options.js (Rich Trott) [#38202](https://github.com/nodejs/node/pull/38202)
* [[`05df701e70`](https://github.com/nodejs/node/commit/05df701e70)] - **test**: remove common.disableCrashOnUnhandledRejection (Michaël Zasso) [#38210](https://github.com/nodejs/node/pull/38210)
* [[`8f4850d5c7`](https://github.com/nodejs/node/commit/8f4850d5c7)] - **test**: fix typo in comment in binding.c (Tobias Nießen) [#38220](https://github.com/nodejs/node/pull/38220)
* [[`9498e97015`](https://github.com/nodejs/node/commit/9498e97015)] - **test**: fix typo in gtest-all.cc (Ikko Ashimine) [#38224](https://github.com/nodejs/node/pull/38224)
* [[`c8bbd83ab2`](https://github.com/nodejs/node/commit/c8bbd83ab2)] - **test**: add undefined fatalException exit code test (Nitzan Uziely) [#38119](https://github.com/nodejs/node/pull/38119)
* [[`db9cf52dcf`](https://github.com/nodejs/node/commit/db9cf52dcf)] - **test**: check the different error code on IBM i (Xu Meng) [#38159](https://github.com/nodejs/node/pull/38159)
* [[`95ca351fd8`](https://github.com/nodejs/node/commit/95ca351fd8)] - **test**: skip fs.watch() test on IBMi (Rich Trott) [#38192](https://github.com/nodejs/node/pull/38192)
* [[`8cee28465c`](https://github.com/nodejs/node/commit/8cee28465c)] - **test**: fix test-dh-regr for OpenSSL 3 (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`213ae4f4c6`](https://github.com/nodejs/node/commit/213ae4f4c6)] - **test**: skip test-vm-memleak in ASAN (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`50208915a0`](https://github.com/nodejs/node/commit/50208915a0)] - **test**: skip test-hash-seed on armv6 and armv7 (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`7216eb67df`](https://github.com/nodejs/node/commit/7216eb67df)] - **test**: update OpenSSL 3.x expected error message (Daniel Bevenius) [#38164](https://github.com/nodejs/node/pull/38164)
* [[`7e516aaac0`](https://github.com/nodejs/node/commit/7e516aaac0)] - **test**: remove unneeded m flag on regular expressions (Rich Trott) [#38124](https://github.com/nodejs/node/pull/38124)
* [[`269f5132cc`](https://github.com/nodejs/node/commit/269f5132cc)] - **test**: skip different params test for OpenSSL 3.x (Daniel Bevenius) [#38165](https://github.com/nodejs/node/pull/38165)
* [[`f96dffb7ae`](https://github.com/nodejs/node/commit/f96dffb7ae)] - **test**: fix flaky test-zlib-unused-weak.js (Ouyang Yadong) [#38149](https://github.com/nodejs/node/pull/38149)
* [[`e96773b94b`](https://github.com/nodejs/node/commit/e96773b94b)] - **test**: add regression test for serdes readDouble() (Colin Ihrig) [#38121](https://github.com/nodejs/node/pull/38121)
* [[`cc4ee6cba8`](https://github.com/nodejs/node/commit/cc4ee6cba8)] - **test**: deflake test-http-many-ended-pipelines (Luigi Pinca) [#38018](https://github.com/nodejs/node/pull/38018)
* [[`098a4d6551`](https://github.com/nodejs/node/commit/098a4d6551)] - **test**: skip test-crypto-dh-keys on armv6 and armv7 (Rich Trott) [#38076](https://github.com/nodejs/node/pull/38076)
* [[`f9b63b8530`](https://github.com/nodejs/node/commit/f9b63b8530)] - **test**: update parallel/test-crypto-keygen for OpenSSL 3 (Richard Lau) [#38136](https://github.com/nodejs/node/pull/38136)
* [[`6a6cdfad03`](https://github.com/nodejs/node/commit/6a6cdfad03)] - **test**: fix skip message for test-macos-app-sandbox (Tobias Nießen) [#38114](https://github.com/nodejs/node/pull/38114)
* [[`e155b1f2f7`](https://github.com/nodejs/node/commit/e155b1f2f7)] - **test**: correct test comment (Evan Lucas) [#38095](https://github.com/nodejs/node/pull/38095)
* [[`d61977f03e`](https://github.com/nodejs/node/commit/d61977f03e)] - **test**: remove dead code (Luigi Pinca) [#38016](https://github.com/nodejs/node/pull/38016)
* [[`8b05e32519`](https://github.com/nodejs/node/commit/8b05e32519)] - **test**: fix flaky test-net-timeout (Rich Trott) [#38060](https://github.com/nodejs/node/pull/38060)
* [[`a0492ba391`](https://github.com/nodejs/node/commit/a0492ba391)] - **test**: fix test-vm-memleak for high baseline platforms (Rich Trott) [#38062](https://github.com/nodejs/node/pull/38062)
* [[`30d7f05fef`](https://github.com/nodejs/node/commit/30d7f05fef)] - **test**: improve code coverage in webcrypto API (Juan José Arboleda) [#38052](https://github.com/nodejs/node/pull/38052)
* [[`d75543d8b5`](https://github.com/nodejs/node/commit/d75543d8b5)] - **test**: fix flaky timeout-delayed-body and headers tests (Nitzan Uziely) [#38045](https://github.com/nodejs/node/pull/38045)
* [[`4f387c25cb`](https://github.com/nodejs/node/commit/4f387c25cb)] - **test**: fix flaky test-vm-memleak (Rich Trott) [#38054](https://github.com/nodejs/node/pull/38054)
* [[`330f25ef82`](https://github.com/nodejs/node/commit/330f25ef82)] - **test**: prepare for consistent comma-dangle lint rule (Rich Trott) [#37930](https://github.com/nodejs/node/pull/37930)
* [[`31fe3b215f`](https://github.com/nodejs/node/commit/31fe3b215f)] - **test**: make sure http pipelining does not emit a warning (Matteo Collina) [#37964](https://github.com/nodejs/node/pull/37964)
* [[`978bbf987c`](https://github.com/nodejs/node/commit/978bbf987c)] - **test**: fix flaky test-http2-pack-end-stream-flag (James M Snell) [#37814](https://github.com/nodejs/node/pull/37814)
* [[`ecc584251e`](https://github.com/nodejs/node/commit/ecc584251e)] - **test**: fixup flaky test-performance-function-async test (James M Snell) [#37493](https://github.com/nodejs/node/pull/37493)
* [[`32482a828b`](https://github.com/nodejs/node/commit/32482a828b)] - **test**: remove FLAKY for test-domain-error-types (Rich Trott) [#37458](https://github.com/nodejs/node/pull/37458)
* [[`501ae0e6e3`](https://github.com/nodejs/node/commit/501ae0e6e3)] - **test**: remove outdated V8 flag (Michaël Zasso) [#37151](https://github.com/nodejs/node/pull/37151)
* [[`fa3997d75a`](https://github.com/nodejs/node/commit/fa3997d75a)] - **test**: mark test-return-on-exit as flaky (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`896ae96a15`](https://github.com/nodejs/node/commit/896ae96a15)] - **test**: mark WASI's test-return-on-exit as flaky (Colin Ihrig) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`0da7a11e54`](https://github.com/nodejs/node/commit/0da7a11e54)] - **test,http**: check that http server is robust from handler abuse (Rich Trott) [#37958](https://github.com/nodejs/node/pull/37958)
* [[`a0261d231c`](https://github.com/nodejs/node/commit/a0261d231c)] - ***Revert*** "**timers**: refactor to use optional chaining" (Matteo Collina) [#38245](https://github.com/nodejs/node/pull/38245)
* [[`3da003cc1c`](https://github.com/nodejs/node/commit/3da003cc1c)] - **tls**: fix session and keylog add listener segfault (Nitzan Uziely) [#38180](https://github.com/nodejs/node/pull/38180)
* [[`eb20447407`](https://github.com/nodejs/node/commit/eb20447407)] - **tls**: extract out SecureContext configuration (James M Snell) [#38116](https://github.com/nodejs/node/pull/38116)
* [[`b16e79e05b`](https://github.com/nodejs/node/commit/b16e79e05b)] - **tls**: fix typo (Arkerone) [#38129](https://github.com/nodejs/node/pull/38129)
* [[`d4f33f109e`](https://github.com/nodejs/node/commit/d4f33f109e)] - **tools**: skip macOS GitHub Actions test on doc-only changes (Rich Trott) [#38296](https://github.com/nodejs/node/pull/38296)
* [[`13d0de5954`](https://github.com/nodejs/node/commit/13d0de5954)] - **tools**: set arch in Distribution.xml (Ash Cripps) [#38261](https://github.com/nodejs/node/pull/38261)
* [[`28bca33f28`](https://github.com/nodejs/node/commit/28bca33f28)] - **tools**: update ESLint to 7.24.0 (Colin Ihrig) [#38179](https://github.com/nodejs/node/pull/38179)
* [[`038608d401`](https://github.com/nodejs/node/commit/038608d401)] - **tools**: relax max-len lint rule for template strings (Rich Trott) [#38097](https://github.com/nodejs/node/pull/38097)
* [[`e67fb569f4`](https://github.com/nodejs/node/commit/e67fb569f4)] - **tools**: apply consistent comma-dangle lint rule (Rich Trott) [#37930](https://github.com/nodejs/node/pull/37930)
* [[`9843361c07`](https://github.com/nodejs/node/commit/9843361c07)] - **tools**: update V8 gypfiles for 9.0 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`017661768a`](https://github.com/nodejs/node/commit/017661768a)] - **tools**: update V8 gypfiles for 8.9 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`79da253473`](https://github.com/nodejs/node/commit/79da253473)] - **tools**: update V8 gypfiles for 8.8 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`770d9e2542`](https://github.com/nodejs/node/commit/770d9e2542)] - **tools**: update V8 gypfiles for 8.7 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`b87f1be92d`](https://github.com/nodejs/node/commit/b87f1be92d)] - **typings**: add types for "http\_parser" and "options" bindings (Michaël Zasso) [#38239](https://github.com/nodejs/node/pull/38239)
* [[`1c8b2956d1`](https://github.com/nodejs/node/commit/1c8b2956d1)] - **typings**: add types for internalBinding('serdes') (Michaël Zasso) [#38204](https://github.com/nodejs/node/pull/38204)
* [[`d97787fccc`](https://github.com/nodejs/node/commit/d97787fccc)] - **typings**: add JSDoc to os module functions (David Brownman) [#38197](https://github.com/nodejs/node/pull/38197)
* [[`8acfe5c2a4`](https://github.com/nodejs/node/commit/8acfe5c2a4)] - **typings**: add JSDoc Types to lib/querystring (Simon Knott) [#38185](https://github.com/nodejs/node/pull/38185)
* [[`d3162da8dd`](https://github.com/nodejs/node/commit/d3162da8dd)] - **typings**: add JSDoc typings for http (Voltrex) [#38191](https://github.com/nodejs/node/pull/38191)
* [[`82d59882b1`](https://github.com/nodejs/node/commit/82d59882b1)] - **typings**: add JSDoc typings for assert (Voltrex) [#38188](https://github.com/nodejs/node/pull/38188)
* [[`f1a21e5c91`](https://github.com/nodejs/node/commit/f1a21e5c91)] - **typings**: add JSDoc types to lib/path (Simon Knott) [#38186](https://github.com/nodejs/node/pull/38186)
* [[`3377eb9641`](https://github.com/nodejs/node/commit/3377eb9641)] - **typings**: add types for internalBinding('util') (Michaël Zasso) [#38200](https://github.com/nodejs/node/pull/38200)
* [[`cb2bdc632a`](https://github.com/nodejs/node/commit/cb2bdc632a)] - **typings**: add types for internalBinding('fs') (Michaël Zasso) [#38198](https://github.com/nodejs/node/pull/38198)
* [[`26eed3e0ed`](https://github.com/nodejs/node/commit/26eed3e0ed)] - **vm**: add import assertion support (Gus Caplan) [#37176](https://github.com/nodejs/node/pull/37176)
* [[`6986fa07eb`](https://github.com/nodejs/node/commit/6986fa07eb)] - **worker**: fix exit code for error thrown in handler (Nitzan Uziely) [#38012](https://github.com/nodejs/node/pull/38012)
