/* unit test for filesystem-bzip2.c */

#define INPUTBUFFERSIZE 128
#define OUTPUTBUFFERSIZE 64

#include "filesystem-bzip2.c"
#include "filesystem-dir-mem.h"
#include "filesystem-file-mem.h"
#include <unistd.h>

#define ANSI_COLOR_RED     "\x1b[31m"
#define ANSI_COLOR_GREEN   "\x1b[32m"
#define ANSI_COLOR_YELLOW  "\x1b[33m"
#define ANSI_COLOR_BLUE    "\x1b[34m"
#define ANSI_COLOR_MAGENTA "\x1b[35m"
#define ANSI_COLOR_CYAN    "\x1b[36m"
#define ANSI_COLOR_RESET   "\x1b[0m"

void preemptive_framelock (void)
{
}

uint32_t dirdbRef (uint32_t ref, enum dirdb_use use)
{
	return ref;
}

void dirdbUnref (uint32_t ref, enum dirdb_use use)
{
}

void dirdbGetName_internalstr (uint32_t ref, const char **retval)
{
	*retval = 0;
	if (ref == 1) *retval = "test1.txt.bz2";
	if (ref == 2) *retval = "test1.txt";
	if (ref == 3) *retval = "test2.txt.bz2";
	if (ref == 4) *retval = "test2.txt";
	if (ref == 5) *retval = "test3.txt.bz2";
	if (ref == 6) *retval = "test3.txt";
	if (ref == 7) *retval = "test4.txt.bz2";
	if (ref == 8) *retval = "test4.txt";
	if (ref == 9) *retval = "test5.txt.bz2.bz2";
	if (ref == 10) *retval = "test5.txt.bz2";
	if (ref == 11) *retval = "test5.txt";

}

void dirdbGetName_malloc (uint32_t ref, char **retval)
{
	const char *temp = 0;
	dirdbGetName_internalstr (ref, &temp);
	if (!temp)
	{
		*retval = 0;
		return;
	}
	*retval = strdup (temp);
}

uint32_t dirdbFindAndRef (uint32_t parent, const char *name, enum dirdb_use use)
{
	if ((parent == 1) && (!strcmp (name, "test1.txt"))) return 2;
	return 0;
}

struct ocpdir_t *ocpdir_t_fill_default_readdir_dir  (struct ocpdir_t *_self, uint32_t dirdb_ref)
{
	fprintf (stderr, "Dummy symbol ocpdir_t_fill_default_readdir_dir called?\n");
	_exit(1);
}

struct ocpfile_t *ocpdir_t_fill_default_readdir_file (struct ocpdir_t *_self, uint32_t dirdb_ref)
{
	fprintf (stderr, "Dummy symbol ocpdir_t_fill_default_readdir_file called?\n");
	_exit(1);
}

const char *ocpfile_t_fill_default_filename_override (struct ocpfile_t *file)
{
	return 0;
}

int ocpfilehandle_t_fill_default_ioctl (struct ocpfilehandle_t *s, const char *cmd, void *ptr)
{
	return -1;
}

const char *ocpfilehandle_t_fill_default_filename_override (struct ocpfilehandle_t *fh)
{
	return 0;
}

void register_dirdecompressor (const struct ocpdirdecompressor_t *ofd)
{
}

int adbMetaAdd (const char *filename, const size_t filesize, const char *SIG, const unsigned char  *data, const size_t  datasize)
{
	return 0;
}

int adbMetaGet (const char *filename, const size_t filesize, const char *SIG,       unsigned char **data,       size_t *datasize)
{
	return -1;
}

int bzip2_test1 (void)
{
	const uint8_t src[] =
	{
		0x42, 0x5a, 0x68, 0x39, 0x31, 0x41, 0x59, 0x26, 0x53, 0x59, 0x23, 0x54, 0x76, 0x1f, 0x00, 0x00,
		0x1d, 0xd5, 0x80, 0x00, 0x10, 0x40, 0x01, 0x00, 0x40, 0x06, 0x04, 0x94, 0xc0, 0x20, 0x00, 0x50,
		0x81, 0xa0, 0x68, 0x15, 0xfe, 0xaa, 0x01, 0x93, 0x49, 0x10, 0x38, 0x32, 0x20, 0x74, 0x48, 0x91,
		0x9b, 0x0f, 0x0e, 0x8a, 0x14, 0x28, 0x50, 0xf8, 0xbb, 0x92, 0x29, 0xc2, 0x84, 0x81, 0x1a, 0xa3,
		0xb0, 0xf8
	};
	char dst[1024];
	const uint8_t verify[] = {
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
		'H', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd', '.', 't', 'x', 't', '\n',
	};
	char *dsrc = malloc (sizeof (src));
	int fill;
	int retval = 0;
	struct ocpdir_t *test_dir; // the top-level container-directory
	struct ocpfile_t *osrc;   // the bzip2 source file
	struct ocpdir_t *oddst;
	struct ocpfile_t *odst; // the bzip2'd decompressed virtual file
	struct ocpfilehandle_t *hdst; // the handle for bzip2'd decompressed file

	printf ("Testing simple small linear compression:  ");

	memcpy (dsrc, src, sizeof (src));
	test_dir = ocpdir_mem_getdir_t(ocpdir_mem_alloc (0, "test:"));
	osrc = mem_file_open (test_dir, /* dirdb_ref */ 1, dsrc, sizeof (src));
	test_dir->unref (test_dir); test_dir = 0;

	oddst = bzip2_check_steal (osrc, 2);
	odst = oddst->readdir_file(oddst, 2);
	hdst = odst->open (odst);
	oddst->unref (oddst); oddst = 0;
	odst->unref (odst); odst = 0;
	osrc->unref (osrc); osrc = 0;

	fill = hdst->read (hdst, dst, sizeof (dst));
	hdst->unref (hdst); hdst = 0;

	if (fill != sizeof (verify))
	{
		printf (ANSI_COLOR_RED " size missmatch" ANSI_COLOR_RESET "\n");
		retval |= 1;
	} else if (memcmp (verify, dst, fill))
	{
		printf (ANSI_COLOR_RED " data missmatch" ANSI_COLOR_RESET "\n");
		retval |= 2;
	} else {
		printf (ANSI_COLOR_GREEN " OK" ANSI_COLOR_RESET "\n");
	}

	return retval;
}

int bzip2_test3 (void)
{
	const uint8_t src[] =
	{
		0x42, 0x5a, 0x68, 0x39, 0x31, 0x41, 0x59, 0x26, 0x53, 0x59, 0x23, 0x54, 0x76, 0x1f, 0x00, 0x00,
		0x1d, 0xd5, 0x80, 0x00, 0x10, 0x40, 0x01, 0x00, 0x40, 0x06, 0x04, 0x94, 0xc0, 0x20, 0x00, 0x50,
		0x81, 0xa0, 0x68, 0x15, 0xfe, 0xaa, 0x01, 0x93, 0x49, 0x10, 0x38, 0x32, 0x20, 0x74, 0x48, 0x91,
		0x9b, 0x0f, 0x0e, 0x8a, 0x14, 0x28, 0x50, 0xf8, 0xbb, 0x92, 0x29, 0xc2, 0x84, 0x81, 0x1a, 0xa3,
		0xb0, 0xf8
	};
	char *dsrc = malloc (sizeof (src));
	int retval = 0;
	struct ocpdir_t *test_dir; // the top-level container-directory
	struct ocpfile_t *osrc;   // the bzip2 source file
	struct ocpdir_t *oddst;
	struct ocpfile_t *odst; // the bzip2'd decompressed virtual file
	struct ocpfilehandle_t *hdst; // the handle for bzip2'd decompressed file

	printf ("Testing filehandle size (does not do prediction):  ");

	memcpy (dsrc, src, sizeof (src));
	test_dir = ocpdir_mem_getdir_t(ocpdir_mem_alloc (0, "test:"));
	osrc = mem_file_open (test_dir, /* dirdb_ref */ 5, dsrc, sizeof (src));
	test_dir->unref (test_dir); test_dir = 0;

	oddst = bzip2_check_steal (osrc, 6);
	odst = oddst->readdir_file(oddst, 6);
	hdst = odst->open (odst);
	oddst->unref (oddst); oddst = 0;
	odst->unref (odst); odst = 0;
	osrc->unref (osrc); osrc = 0;

	if (hdst->filesize (hdst) != 240)
	{
		printf (ANSI_COLOR_RED " size missmatch" ANSI_COLOR_RESET "\n");
		retval |= 1;
	} else {
		printf (ANSI_COLOR_GREEN " OK" ANSI_COLOR_RESET "\n");
	}

	hdst->unref (hdst); hdst = 0;

	return retval;
}

int bzip_test4 (void)
{
	const uint8_t src[] =
	{
		0x42, 0x5a, 0x68, 0x39, 0x31, 0x41, 0x59, 0x26, 0x53, 0x59, 0xa2, 0x40, 0x59, 0x35, 0x00, 0x01,
		0x11, 0x49, 0x00, 0x00, 0x10, 0x7f, 0xe0, 0x3f, 0x00, 0x50, 0x04, 0x58, 0x00, 0xf2, 0x92, 0x44,
		0x91, 0x21, 0x43, 0x4d, 0x30, 0x00, 0x50, 0xd3, 0x4c, 0x00, 0x15, 0x54, 0xff, 0xfd, 0x52, 0xa8,
		0x06, 0x27, 0xfb, 0xfd, 0x4a, 0xaa, 0x14, 0x34, 0xd3, 0x00, 0x03, 0x55, 0x4f, 0xff, 0xd5, 0x2a,
		0x80, 0x06, 0xff, 0xd5, 0x54, 0x6e, 0xfd, 0xff, 0x1f, 0x9f, 0xd7, 0xef, 0xf9, 0xfd, 0xf8, 0xf9,
		0xfa, 0xff, 0x79, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x3d, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf0, 0x00, 0x00, 0xdc, 0xe7, 0x37,
		0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77,
		0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d,
		0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0x6d, 0xb7, 0x77, 0xbc, 0xe7, 0x39, 0xde, 0xed,
		0xb6, 0xdb, 0x6d, 0xb6, 0xc0, 0x00, 0x06, 0xe7, 0x39, 0xce, 0xf7, 0xbc, 0xe6, 0xdd, 0xdd, 0xb6,
		0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd,
		0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd,
		0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xdd, 0xb6, 0xdd, 0xee, 0xdb, 0x6d, 0xb6, 0xdb, 0x6c, 0x00, 0x00,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
		0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40, 0x00, 0x00, 0x00, 0x15, 0x54, 0x00, 0x00,
		0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x00, 0x00, 0x05, 0x55, 0x55,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x55, 0x55,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00, 0x00, 0x00, 0x05, 0x50, 0x00, 0x00, 0x00, 0x55, 0x55,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
		0x55, 0x55, 0x00, 0x00, 0x00, 0x15, 0x54, 0x00, 0x00, 0x00, 0x01, 0x55, 0x55, 0x55, 0x55, 0x55,
		0x55, 0x55, 0x54, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0xdd, 0xd5, 0x55, 0x55, 0x55,
		0x55, 0x55, 0x55, 0x57, 0x8f, 0x00, 0x00, 0x00, 0x01, 0x9f, 0xe2, 0xee, 0x48, 0xa7, 0x0a, 0x12,
		0x14, 0x48, 0x0b, 0x26, 0xa0
	};
	const struct test4_subtest
	{
		uint32_t offset, count;
		const char *data;
	} subtests[] =
	{
		{0x000*4, 4, "000\n"},
		{0x143*4, 4, "143\n"},
		{0x0f0*4, 4, "0f0\n"},
		{0x1ff*4, 4, "1ff\n"},
		{0x001*4, 4, "001\n"},
		{0x1fd*4, 4, "1fd\n"},
	};
	char *dsrc = malloc (sizeof (src));
	int retval = 0;
	struct ocpdir_t *test_dir; // the top-level container-directory
	struct ocpfile_t *osrc;   // the bzip2 source file
	struct ocpdir_t *oddst;
	struct ocpfile_t *odst; // the bzip2'd decompressed virtual file
	struct ocpfilehandle_t *hdst; // the handle for bzip2'd decompressed file
	int i;
	char *dst = malloc (4);

	printf ("Testing seek and reads (no cache):  ");

	memcpy (dsrc, src, sizeof (src));
	test_dir = ocpdir_mem_getdir_t(ocpdir_mem_alloc (0, "test:"));
	osrc = mem_file_open (test_dir, /* dirdb_ref */ 7, dsrc, sizeof (src));
	test_dir->unref (test_dir); test_dir = 0;

	oddst = bzip2_check_steal (osrc, 8);
	odst = oddst->readdir_file(oddst, 8);
	hdst = odst->open (odst);
	oddst->unref (oddst); oddst = 0;
	odst->unref (odst); odst = 0;
	osrc->unref (osrc); osrc = 0;

	for (i=0; i < 5; i++)
	{
		if (hdst->seek_set (hdst, subtests[i].offset))
		{
			printf ("s");
			retval |= 1;
		} else if (hdst->read (hdst, dst, subtests[i].count) != 4)
		{
			printf ("r");
			retval |= 2;
		} else if (memcmp (dst, subtests[i].data, subtests[i].count))
		{
			printf ("d");
			retval |= 4;
		} else {
			printf ("%d", i+1);
		}
	}
	if (retval)
	{
		printf (ANSI_COLOR_RED " Failed" ANSI_COLOR_RESET "\n");
	} else {
		printf (ANSI_COLOR_GREEN " OK" ANSI_COLOR_RESET "\n");
	}

	hdst->unref (hdst); hdst = 0;
	free (dst);

	return retval;
}

int bzip2_test5 (void)
{
	const uint8_t src[] =
	{
		0x42, 0x5a, 0x68, 0x39, 0x31, 0x41, 0x59, 0x26, 0x53, 0x59, 0xfc, 0x35, 0x3a, 0x09, 0x00, 0x00,
		0x40, 0x7f, 0xff, 0xff, 0x18, 0x76, 0x00, 0xa1, 0x90, 0x66, 0xa2, 0xfc, 0x76, 0xde, 0xf0, 0x00,
		0x47, 0x00, 0xa8, 0xc0, 0x00, 0xb0, 0x00, 0xd0, 0xd0, 0x01, 0x86, 0x40, 0x01, 0x0a, 0x8f, 0x51,
		0x83, 0xd0, 0xfa, 0xb0, 0x00, 0xdb, 0x30, 0x42, 0xa6, 0x8d, 0x00, 0x00, 0x68, 0x00, 0x01, 0xa0,
		0x00, 0x34, 0x1a, 0x1a, 0x68, 0x34, 0xd0, 0x0d, 0x0d, 0x33, 0x50, 0xd0, 0x6a, 0x6a, 0x26, 0x80,
		0xd0, 0x00, 0x00, 0x00, 0x01, 0xa6, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x0a, 0x68, 0x00,
		0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x31, 0xec, 0x1c, 0x65, 0xd9,
		0x56, 0x73, 0xa4, 0x90, 0x14, 0x13, 0x20, 0x10, 0x63, 0x00, 0x82, 0x64, 0x21, 0x4c, 0x80, 0x3b,
		0x40, 0x30, 0x06, 0x92, 0x00, 0xd0, 0x43, 0x30, 0x85, 0x38, 0x47, 0x03, 0x28, 0x40, 0x26, 0x44,
		0x01, 0x11, 0x82, 0x27, 0x00, 0xe7, 0x19, 0xce, 0x31, 0xd2, 0x3d, 0xdb, 0xec, 0x90, 0xd5, 0x01,
		0xfb, 0x0d, 0x98, 0x91, 0x35, 0xd6, 0x4a, 0x52, 0xbe, 0x97, 0x58, 0x1c, 0x10, 0xe4, 0xe7, 0x42,
		0x7a, 0x12, 0xce, 0x8f, 0x64, 0xbf, 0x49, 0xb9, 0x15, 0x11, 0x49, 0xa9, 0x10, 0x57, 0x56, 0xa2,
		0x04, 0xec, 0x96, 0x03, 0x03, 0xc8, 0x03, 0x03, 0xcf, 0x58, 0x21, 0xad, 0x30, 0x51, 0x3b, 0x6a,
		0x20, 0x7a, 0x3d, 0xc7, 0x78, 0x08, 0x9d, 0xa7, 0x98, 0x08, 0x9a, 0xb0, 0x1e, 0x9a, 0x09, 0x6d,
		0x5d, 0x13, 0x25, 0x59, 0xc3, 0xc1, 0x24, 0xc1, 0x75, 0x40, 0x44, 0xa0, 0x11, 0x21, 0x8c, 0x94,
		0xbf, 0xc9, 0x08, 0xa0, 0xdd, 0x46, 0xa1, 0x6e, 0x9b, 0x40, 0x11, 0x82, 0x42, 0xc0, 0x45, 0xca,
		0x81, 0xe1, 0xc7, 0x95, 0xb4, 0x94, 0xb9, 0x1d, 0xac, 0xa9, 0x0b, 0x7e, 0x42, 0x8e, 0xf8, 0x6f,
		0xd2, 0x31, 0x1d, 0x9f, 0xe6, 0xcc, 0x31, 0x0a, 0xf7, 0xf1, 0x77, 0x24, 0x53, 0x85, 0x09, 0x0f,
		0xc3, 0x53, 0xa0, 0x90
	};
	const struct test5_subtest
	{
		uint32_t offset, count;
		const char *data;
	} subtests[] =
	{
		{0x000*4, 4, "000\n"},
		{0x143*4, 4, "143\n"},
		{0x0f0*4, 4, "0f0\n"},
		{0x1ff*4, 4, "1ff\n"},
		{0x001*4, 4, "001\n"},
		{0x1fd*4, 4, "1fd\n"},
	};
	char *dsrc = malloc (sizeof (src));
	int retval = 0;
	struct ocpdir_t *test_dir;
	struct ocpfile_t *osrc;
	struct ocpdir_t *oddst;
	struct ocpfile_t *odst;
	struct ocpdir_t *oddst2;
	struct ocpfile_t *odst2;
	struct ocpfilehandle_t *hdst2;
	int i;
	char *dst = malloc (4);

	printf ("Testing seek and reads (no cache, recursive compression):  ");

	memcpy (dsrc, src, sizeof (src));
	test_dir = ocpdir_mem_getdir_t(ocpdir_mem_alloc (0, "test:"));
	osrc = mem_file_open (test_dir, /* dirdb_ref */ 9, dsrc, sizeof (src));
	test_dir->unref (test_dir); test_dir = 0;

	oddst = bzip2_check_steal (osrc, 10);
	odst = oddst->readdir_file(oddst, 10);
	oddst2 = bzip2_check_steal (odst, 11);
	odst2 = oddst2->readdir_file(oddst2, 11);
	hdst2 = odst->open (odst2);
	oddst2->unref (oddst2); oddst2 = 0;
	odst2->unref (odst2); odst2 = 0;
	oddst->unref (oddst); oddst = 0;
	odst->unref (odst); odst  = 0;
	osrc->unref (osrc); osrc  = 0;

	for (i=0; i < 5; i++)
	{
		if (hdst2->seek_set (hdst2, subtests[i].offset))
		{
			printf ("s");
			retval |= 1;
		} else if (hdst2->read (hdst2, dst, subtests[i].count) != 4)
		{
			printf ("r");
			retval |= 2;
		} else if (memcmp (dst, subtests[i].data, subtests[i].count))
		{
			printf ("d");
			retval |= 4;
		} else {
			printf ("%d", i+1);
		}
	}
	if (retval)
	{
		printf (ANSI_COLOR_RED " Failed" ANSI_COLOR_RESET "\n");
	} else {
		printf (ANSI_COLOR_GREEN " OK" ANSI_COLOR_RESET "\n");
	}

	hdst2->unref (hdst2); hdst2 = 0;
	free (dst);

	return retval;
}

int main(int argc, char *argv[])
{
	int retval = 0;

	printf ( ANSI_COLOR_CYAN "Testing BZIP2" ANSI_COLOR_RESET "\n");
	retval |= bzip2_test1 ();
	retval |= bzip2_test3 ();
	retval |= bzip2_test5 ();
	printf ("\n");

	return retval;
}
