<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/datastore/datastore_v4.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/datastore/entity_v4_pb.php';
}
namespace google\appengine\datastore\v4\Error {
  class ErrorCode {
    const BAD_REQUEST = 1;
    const CONCURRENT_TRANSACTION = 2;
    const INTERNAL_ERROR = 3;
    const NEED_INDEX = 4;
    const TIMEOUT = 5;
    const PERMISSION_DENIED = 6;
    const BIGTABLE_ERROR = 7;
    const COMMITTED_BUT_STILL_APPLYING = 8;
    const CAPABILITY_DISABLED = 9;
    const TRY_ALTERNATE_BACKEND = 10;
    const SAFE_TIME_TOO_OLD = 11;
  }
}
namespace google\appengine\datastore\v4 {
  class Error extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\EntityResult {
  class ResultType {
    const FULL = 1;
    const PROJECTION = 2;
    const KEY_ONLY = 3;
  }
}
namespace google\appengine\datastore\v4 {
  class EntityResult extends \google\net\ProtocolMessage {
    public function getEntity() {
      if (!isset($this->entity)) {
        return new \google\appengine\datastore\v4\Entity();
      }
      return $this->entity;
    }
    public function mutableEntity() {
      if (!isset($this->entity)) {
        $res = new \google\appengine\datastore\v4\Entity();
        $this->entity = $res;
        return $res;
      }
      return $this->entity;
    }
    public function clearEntity() {
      if (isset($this->entity)) {
        unset($this->entity);
      }
    }
    public function hasEntity() {
      return isset($this->entity);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return "0";
      }
      return $this->version;
    }
    public function setVersion($val) {
      if (is_double($val)) {
        $this->version = sprintf('%0.0F', $val);
      } else {
        $this->version = $val;
      }
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function getCursor() {
      if (!isset($this->cursor)) {
        return '';
      }
      return $this->cursor;
    }
    public function setCursor($val) {
      $this->cursor = $val;
      return $this;
    }
    public function clearCursor() {
      unset($this->cursor);
      return $this;
    }
    public function hasCursor() {
      return isset($this->cursor);
    }
    public function clear() {
      $this->clearEntity();
      $this->clearVersion();
      $this->clearCursor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->entity)) {
        $res += 1;
        $res += $this->lengthString($this->entity->byteSizePartial());
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->version);
      }
      if (isset($this->cursor)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->cursor));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->entity)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->entity->byteSizePartial());
        $this->entity->outputPartial($out);
      }
      if (isset($this->version)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->version);
      }
      if (isset($this->cursor)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->cursor);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntity()->tryMerge($tmp);
            break;
          case 16:
            $this->setVersion($d->getVarInt64());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setCursor(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->entity)) || (!$this->entity->isInitialized())) return 'entity';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasEntity()) {
        $this->mutableEntity()->mergeFrom($x->getEntity());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
      if ($x->hasCursor()) {
        $this->setCursor($x->getCursor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->entity) !== isset($x->entity)) return false;
      if (isset($this->entity) && !$this->entity->equals($x->entity)) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && !$this->integerEquals($this->version, $x->version)) return false;
      if (isset($this->cursor) !== isset($x->cursor)) return false;
      if (isset($this->cursor) && $this->cursor !== $x->cursor) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->entity)) {
        $res .= $prefix . "entity <\n" . $this->entity->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatInt64($this->version) . "\n";
      }
      if (isset($this->cursor)) {
        $res .= $prefix . "cursor: " . $this->debugFormatString($this->cursor) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class Query extends \google\net\ProtocolMessage {
    private $projection = array();
    private $kind = array();
    private $order = array();
    private $group_by = array();
    public function getProjectionSize() {
      return sizeof($this->projection);
    }
    public function getProjectionList() {
      return $this->projection;
    }
    public function mutableProjection($idx) {
      if (!isset($this->projection[$idx])) {
        $val = new \google\appengine\datastore\v4\PropertyExpression();
        $this->projection[$idx] = $val;
        return $val;
      }
      return $this->projection[$idx];
    }
    public function getProjection($idx) {
      if (isset($this->projection[$idx])) {
        return $this->projection[$idx];
      }
      if ($idx >= end(array_keys($this->projection))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\PropertyExpression();
    }
    public function addProjection() {
      $val = new \google\appengine\datastore\v4\PropertyExpression();
      $this->projection[] = $val;
      return $val;
    }
    public function clearProjection() {
      $this->projection = array();
    }
    public function getKindSize() {
      return sizeof($this->kind);
    }
    public function getKindList() {
      return $this->kind;
    }
    public function mutableKind($idx) {
      if (!isset($this->kind[$idx])) {
        $val = new \google\appengine\datastore\v4\KindExpression();
        $this->kind[$idx] = $val;
        return $val;
      }
      return $this->kind[$idx];
    }
    public function getKind($idx) {
      if (isset($this->kind[$idx])) {
        return $this->kind[$idx];
      }
      if ($idx >= end(array_keys($this->kind))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\KindExpression();
    }
    public function addKind() {
      $val = new \google\appengine\datastore\v4\KindExpression();
      $this->kind[] = $val;
      return $val;
    }
    public function clearKind() {
      $this->kind = array();
    }
    public function getFilter() {
      if (!isset($this->filter)) {
        return new \google\appengine\datastore\v4\Filter();
      }
      return $this->filter;
    }
    public function mutableFilter() {
      if (!isset($this->filter)) {
        $res = new \google\appengine\datastore\v4\Filter();
        $this->filter = $res;
        return $res;
      }
      return $this->filter;
    }
    public function clearFilter() {
      if (isset($this->filter)) {
        unset($this->filter);
      }
    }
    public function hasFilter() {
      return isset($this->filter);
    }
    public function getOrderSize() {
      return sizeof($this->order);
    }
    public function getOrderList() {
      return $this->order;
    }
    public function mutableOrder($idx) {
      if (!isset($this->order[$idx])) {
        $val = new \google\appengine\datastore\v4\PropertyOrder();
        $this->order[$idx] = $val;
        return $val;
      }
      return $this->order[$idx];
    }
    public function getOrder($idx) {
      if (isset($this->order[$idx])) {
        return $this->order[$idx];
      }
      if ($idx >= end(array_keys($this->order))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\PropertyOrder();
    }
    public function addOrder() {
      $val = new \google\appengine\datastore\v4\PropertyOrder();
      $this->order[] = $val;
      return $val;
    }
    public function clearOrder() {
      $this->order = array();
    }
    public function getGroupBySize() {
      return sizeof($this->group_by);
    }
    public function getGroupByList() {
      return $this->group_by;
    }
    public function mutableGroupBy($idx) {
      if (!isset($this->group_by[$idx])) {
        $val = new \google\appengine\datastore\v4\PropertyReference();
        $this->group_by[$idx] = $val;
        return $val;
      }
      return $this->group_by[$idx];
    }
    public function getGroupBy($idx) {
      if (isset($this->group_by[$idx])) {
        return $this->group_by[$idx];
      }
      if ($idx >= end(array_keys($this->group_by))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\PropertyReference();
    }
    public function addGroupBy() {
      $val = new \google\appengine\datastore\v4\PropertyReference();
      $this->group_by[] = $val;
      return $val;
    }
    public function clearGroupBy() {
      $this->group_by = array();
    }
    public function getStartCursor() {
      if (!isset($this->start_cursor)) {
        return '';
      }
      return $this->start_cursor;
    }
    public function setStartCursor($val) {
      $this->start_cursor = $val;
      return $this;
    }
    public function clearStartCursor() {
      unset($this->start_cursor);
      return $this;
    }
    public function hasStartCursor() {
      return isset($this->start_cursor);
    }
    public function getEndCursor() {
      if (!isset($this->end_cursor)) {
        return '';
      }
      return $this->end_cursor;
    }
    public function setEndCursor($val) {
      $this->end_cursor = $val;
      return $this;
    }
    public function clearEndCursor() {
      unset($this->end_cursor);
      return $this;
    }
    public function hasEndCursor() {
      return isset($this->end_cursor);
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return 0;
      }
      return $this->offset;
    }
    public function setOffset($val) {
      $this->offset = $val;
      return $this;
    }
    public function clearOffset() {
      unset($this->offset);
      return $this;
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getLimit() {
      if (!isset($this->limit)) {
        return 0;
      }
      return $this->limit;
    }
    public function setLimit($val) {
      $this->limit = $val;
      return $this;
    }
    public function clearLimit() {
      unset($this->limit);
      return $this;
    }
    public function hasLimit() {
      return isset($this->limit);
    }
    public function clear() {
      $this->clearProjection();
      $this->clearKind();
      $this->clearFilter();
      $this->clearOrder();
      $this->clearGroupBy();
      $this->clearStartCursor();
      $this->clearEndCursor();
      $this->clearOffset();
      $this->clearLimit();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->projection);
      $res += 1 * sizeof($this->projection);
      foreach ($this->projection as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->kind);
      $res += 1 * sizeof($this->kind);
      foreach ($this->kind as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->filter)) {
        $res += 1;
        $res += $this->lengthString($this->filter->byteSizePartial());
      }
      $this->checkProtoArray($this->order);
      $res += 1 * sizeof($this->order);
      foreach ($this->order as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->group_by);
      $res += 1 * sizeof($this->group_by);
      foreach ($this->group_by as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->start_cursor)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->start_cursor));
      }
      if (isset($this->end_cursor)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->end_cursor));
      }
      if (isset($this->offset)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->offset);
      }
      if (isset($this->limit)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->limit);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->projection);
      foreach ($this->projection as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->kind);
      foreach ($this->kind as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->filter)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->filter->byteSizePartial());
        $this->filter->outputPartial($out);
      }
      $this->checkProtoArray($this->order);
      foreach ($this->order as $value) {
        $out->putVarInt32(42);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->group_by);
      foreach ($this->group_by as $value) {
        $out->putVarInt32(50);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->start_cursor)) {
        $out->putVarInt32(58);
        $out->putPrefixedString($this->start_cursor);
      }
      if (isset($this->end_cursor)) {
        $out->putVarInt32(66);
        $out->putPrefixedString($this->end_cursor);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(80);
        $out->putVarInt32($this->offset);
      }
      if (isset($this->limit)) {
        $out->putVarInt32(88);
        $out->putVarInt32($this->limit);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addProjection()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addKind()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableFilter()->tryMerge($tmp);
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addOrder()->tryMerge($tmp);
            break;
          case 50:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addGroupBy()->tryMerge($tmp);
            break;
          case 58:
            $length = $d->getVarInt32();
            $this->setStartCursor(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 66:
            $length = $d->getVarInt32();
            $this->setEndCursor(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 80:
            $this->setOffset($d->getVarInt32());
            break;
          case 88:
            $this->setLimit($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->projection as $value) {
        if (!$value->isInitialized()) return 'projection';
      }
      foreach ($this->kind as $value) {
        if (!$value->isInitialized()) return 'kind';
      }
      if (isset($this->filter) && (!$this->filter->isInitialized())) return 'filter';
      foreach ($this->order as $value) {
        if (!$value->isInitialized()) return 'order';
      }
      foreach ($this->group_by as $value) {
        if (!$value->isInitialized()) return 'group_by';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getProjectionList() as $v) {
        $this->addProjection()->copyFrom($v);
      }
      foreach ($x->getKindList() as $v) {
        $this->addKind()->copyFrom($v);
      }
      if ($x->hasFilter()) {
        $this->mutableFilter()->mergeFrom($x->getFilter());
      }
      foreach ($x->getOrderList() as $v) {
        $this->addOrder()->copyFrom($v);
      }
      foreach ($x->getGroupByList() as $v) {
        $this->addGroupBy()->copyFrom($v);
      }
      if ($x->hasStartCursor()) {
        $this->setStartCursor($x->getStartCursor());
      }
      if ($x->hasEndCursor()) {
        $this->setEndCursor($x->getEndCursor());
      }
      if ($x->hasOffset()) {
        $this->setOffset($x->getOffset());
      }
      if ($x->hasLimit()) {
        $this->setLimit($x->getLimit());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->projection) !== sizeof($x->projection)) return false;
      foreach (array_map(null, $this->projection, $x->projection) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->kind) !== sizeof($x->kind)) return false;
      foreach (array_map(null, $this->kind, $x->kind) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->filter) !== isset($x->filter)) return false;
      if (isset($this->filter) && !$this->filter->equals($x->filter)) return false;
      if (sizeof($this->order) !== sizeof($x->order)) return false;
      foreach (array_map(null, $this->order, $x->order) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->group_by) !== sizeof($x->group_by)) return false;
      foreach (array_map(null, $this->group_by, $x->group_by) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->start_cursor) !== isset($x->start_cursor)) return false;
      if (isset($this->start_cursor) && $this->start_cursor !== $x->start_cursor) return false;
      if (isset($this->end_cursor) !== isset($x->end_cursor)) return false;
      if (isset($this->end_cursor) && $this->end_cursor !== $x->end_cursor) return false;
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->integerEquals($this->offset, $x->offset)) return false;
      if (isset($this->limit) !== isset($x->limit)) return false;
      if (isset($this->limit) && !$this->integerEquals($this->limit, $x->limit)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->projection as $value) {
        $res .= $prefix . "projection <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->kind as $value) {
        $res .= $prefix . "kind <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->filter)) {
        $res .= $prefix . "filter <\n" . $this->filter->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->order as $value) {
        $res .= $prefix . "order <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->group_by as $value) {
        $res .= $prefix . "group_by <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->start_cursor)) {
        $res .= $prefix . "start_cursor: " . $this->debugFormatString($this->start_cursor) . "\n";
      }
      if (isset($this->end_cursor)) {
        $res .= $prefix . "end_cursor: " . $this->debugFormatString($this->end_cursor) . "\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset: " . $this->debugFormatInt32($this->offset) . "\n";
      }
      if (isset($this->limit)) {
        $res .= $prefix . "limit: " . $this->debugFormatInt32($this->limit) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class KindExpression extends \google\net\ProtocolMessage {
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function clear() {
      $this->clearName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->name)) return 'name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class PropertyReference extends \google\net\ProtocolMessage {
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function clear() {
      $this->clearName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 18:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->name)) return 'name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\PropertyExpression {
  class AggregationFunction {
    const FIRST = 1;
  }
}
namespace google\appengine\datastore\v4 {
  class PropertyExpression extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return new \google\appengine\datastore\v4\PropertyReference();
      }
      return $this->property;
    }
    public function mutableProperty() {
      if (!isset($this->property)) {
        $res = new \google\appengine\datastore\v4\PropertyReference();
        $this->property = $res;
        return $res;
      }
      return $this->property;
    }
    public function clearProperty() {
      if (isset($this->property)) {
        unset($this->property);
      }
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getAggregationFunction() {
      if (!isset($this->aggregation_function)) {
        return 1;
      }
      return $this->aggregation_function;
    }
    public function setAggregationFunction($val) {
      $this->aggregation_function = $val;
      return $this;
    }
    public function clearAggregationFunction() {
      unset($this->aggregation_function);
      return $this;
    }
    public function hasAggregationFunction() {
      return isset($this->aggregation_function);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearAggregationFunction();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 1;
        $res += $this->lengthString($this->property->byteSizePartial());
      }
      if (isset($this->aggregation_function)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->aggregation_function);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->property->byteSizePartial());
        $this->property->outputPartial($out);
      }
      if (isset($this->aggregation_function)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->aggregation_function);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableProperty()->tryMerge($tmp);
            break;
          case 16:
            $this->setAggregationFunction($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->property)) || (!$this->property->isInitialized())) return 'property';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->mutableProperty()->mergeFrom($x->getProperty());
      }
      if ($x->hasAggregationFunction()) {
        $this->setAggregationFunction($x->getAggregationFunction());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && !$this->property->equals($x->property)) return false;
      if (isset($this->aggregation_function) !== isset($x->aggregation_function)) return false;
      if (isset($this->aggregation_function) && $this->aggregation_function !== $x->aggregation_function) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property <\n" . $this->property->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->aggregation_function)) {
        $res .= $prefix . "aggregation_function: " . ($this->aggregation_function) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\PropertyOrder {
  class Direction {
    const ASCENDING = 1;
    const DESCENDING = 2;
  }
}
namespace google\appengine\datastore\v4 {
  class PropertyOrder extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return new \google\appengine\datastore\v4\PropertyReference();
      }
      return $this->property;
    }
    public function mutableProperty() {
      if (!isset($this->property)) {
        $res = new \google\appengine\datastore\v4\PropertyReference();
        $this->property = $res;
        return $res;
      }
      return $this->property;
    }
    public function clearProperty() {
      if (isset($this->property)) {
        unset($this->property);
      }
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getDirection() {
      if (!isset($this->direction)) {
        return 1;
      }
      return $this->direction;
    }
    public function setDirection($val) {
      $this->direction = $val;
      return $this;
    }
    public function clearDirection() {
      unset($this->direction);
      return $this;
    }
    public function hasDirection() {
      return isset($this->direction);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearDirection();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 1;
        $res += $this->lengthString($this->property->byteSizePartial());
      }
      if (isset($this->direction)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->direction);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->property->byteSizePartial());
        $this->property->outputPartial($out);
      }
      if (isset($this->direction)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->direction);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableProperty()->tryMerge($tmp);
            break;
          case 16:
            $this->setDirection($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->property)) || (!$this->property->isInitialized())) return 'property';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->mutableProperty()->mergeFrom($x->getProperty());
      }
      if ($x->hasDirection()) {
        $this->setDirection($x->getDirection());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && !$this->property->equals($x->property)) return false;
      if (isset($this->direction) !== isset($x->direction)) return false;
      if (isset($this->direction) && $this->direction !== $x->direction) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property <\n" . $this->property->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->direction)) {
        $res .= $prefix . "direction: " . ($this->direction) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class Filter extends \google\net\ProtocolMessage {
    public function getCompositeFilter() {
      if (!isset($this->composite_filter)) {
        return new \google\appengine\datastore\v4\CompositeFilter();
      }
      return $this->composite_filter;
    }
    public function mutableCompositeFilter() {
      if (!isset($this->composite_filter)) {
        $res = new \google\appengine\datastore\v4\CompositeFilter();
        $this->composite_filter = $res;
        return $res;
      }
      return $this->composite_filter;
    }
    public function clearCompositeFilter() {
      if (isset($this->composite_filter)) {
        unset($this->composite_filter);
      }
    }
    public function hasCompositeFilter() {
      return isset($this->composite_filter);
    }
    public function getPropertyFilter() {
      if (!isset($this->property_filter)) {
        return new \google\appengine\datastore\v4\PropertyFilter();
      }
      return $this->property_filter;
    }
    public function mutablePropertyFilter() {
      if (!isset($this->property_filter)) {
        $res = new \google\appengine\datastore\v4\PropertyFilter();
        $this->property_filter = $res;
        return $res;
      }
      return $this->property_filter;
    }
    public function clearPropertyFilter() {
      if (isset($this->property_filter)) {
        unset($this->property_filter);
      }
    }
    public function hasPropertyFilter() {
      return isset($this->property_filter);
    }
    public function getBoundingCircleFilter() {
      if (!isset($this->bounding_circle_filter)) {
        return new \google\appengine\datastore\v4\BoundingCircleFilter();
      }
      return $this->bounding_circle_filter;
    }
    public function mutableBoundingCircleFilter() {
      if (!isset($this->bounding_circle_filter)) {
        $res = new \google\appengine\datastore\v4\BoundingCircleFilter();
        $this->bounding_circle_filter = $res;
        return $res;
      }
      return $this->bounding_circle_filter;
    }
    public function clearBoundingCircleFilter() {
      if (isset($this->bounding_circle_filter)) {
        unset($this->bounding_circle_filter);
      }
    }
    public function hasBoundingCircleFilter() {
      return isset($this->bounding_circle_filter);
    }
    public function getBoundingBoxFilter() {
      if (!isset($this->bounding_box_filter)) {
        return new \google\appengine\datastore\v4\BoundingBoxFilter();
      }
      return $this->bounding_box_filter;
    }
    public function mutableBoundingBoxFilter() {
      if (!isset($this->bounding_box_filter)) {
        $res = new \google\appengine\datastore\v4\BoundingBoxFilter();
        $this->bounding_box_filter = $res;
        return $res;
      }
      return $this->bounding_box_filter;
    }
    public function clearBoundingBoxFilter() {
      if (isset($this->bounding_box_filter)) {
        unset($this->bounding_box_filter);
      }
    }
    public function hasBoundingBoxFilter() {
      return isset($this->bounding_box_filter);
    }
    public function clear() {
      $this->clearCompositeFilter();
      $this->clearPropertyFilter();
      $this->clearBoundingCircleFilter();
      $this->clearBoundingBoxFilter();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->composite_filter)) {
        $res += 1;
        $res += $this->lengthString($this->composite_filter->byteSizePartial());
      }
      if (isset($this->property_filter)) {
        $res += 1;
        $res += $this->lengthString($this->property_filter->byteSizePartial());
      }
      if (isset($this->bounding_circle_filter)) {
        $res += 1;
        $res += $this->lengthString($this->bounding_circle_filter->byteSizePartial());
      }
      if (isset($this->bounding_box_filter)) {
        $res += 1;
        $res += $this->lengthString($this->bounding_box_filter->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->composite_filter)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->composite_filter->byteSizePartial());
        $this->composite_filter->outputPartial($out);
      }
      if (isset($this->property_filter)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->property_filter->byteSizePartial());
        $this->property_filter->outputPartial($out);
      }
      if (isset($this->bounding_circle_filter)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->bounding_circle_filter->byteSizePartial());
        $this->bounding_circle_filter->outputPartial($out);
      }
      if (isset($this->bounding_box_filter)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->bounding_box_filter->byteSizePartial());
        $this->bounding_box_filter->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCompositeFilter()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePropertyFilter()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableBoundingCircleFilter()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableBoundingBoxFilter()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->composite_filter) && (!$this->composite_filter->isInitialized())) return 'composite_filter';
      if (isset($this->property_filter) && (!$this->property_filter->isInitialized())) return 'property_filter';
      if (isset($this->bounding_circle_filter) && (!$this->bounding_circle_filter->isInitialized())) return 'bounding_circle_filter';
      if (isset($this->bounding_box_filter) && (!$this->bounding_box_filter->isInitialized())) return 'bounding_box_filter';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCompositeFilter()) {
        $this->mutableCompositeFilter()->mergeFrom($x->getCompositeFilter());
      }
      if ($x->hasPropertyFilter()) {
        $this->mutablePropertyFilter()->mergeFrom($x->getPropertyFilter());
      }
      if ($x->hasBoundingCircleFilter()) {
        $this->mutableBoundingCircleFilter()->mergeFrom($x->getBoundingCircleFilter());
      }
      if ($x->hasBoundingBoxFilter()) {
        $this->mutableBoundingBoxFilter()->mergeFrom($x->getBoundingBoxFilter());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->composite_filter) !== isset($x->composite_filter)) return false;
      if (isset($this->composite_filter) && !$this->composite_filter->equals($x->composite_filter)) return false;
      if (isset($this->property_filter) !== isset($x->property_filter)) return false;
      if (isset($this->property_filter) && !$this->property_filter->equals($x->property_filter)) return false;
      if (isset($this->bounding_circle_filter) !== isset($x->bounding_circle_filter)) return false;
      if (isset($this->bounding_circle_filter) && !$this->bounding_circle_filter->equals($x->bounding_circle_filter)) return false;
      if (isset($this->bounding_box_filter) !== isset($x->bounding_box_filter)) return false;
      if (isset($this->bounding_box_filter) && !$this->bounding_box_filter->equals($x->bounding_box_filter)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->composite_filter)) {
        $res .= $prefix . "composite_filter <\n" . $this->composite_filter->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->property_filter)) {
        $res .= $prefix . "property_filter <\n" . $this->property_filter->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->bounding_circle_filter)) {
        $res .= $prefix . "bounding_circle_filter <\n" . $this->bounding_circle_filter->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->bounding_box_filter)) {
        $res .= $prefix . "bounding_box_filter <\n" . $this->bounding_box_filter->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\CompositeFilter {
  class Operator {
    const AND_ = 1;
  }
}
namespace google\appengine\datastore\v4 {
  class CompositeFilter extends \google\net\ProtocolMessage {
    private $filter = array();
    public function getOperator() {
      if (!isset($this->operator)) {
        return 1;
      }
      return $this->operator;
    }
    public function setOperator($val) {
      $this->operator = $val;
      return $this;
    }
    public function clearOperator() {
      unset($this->operator);
      return $this;
    }
    public function hasOperator() {
      return isset($this->operator);
    }
    public function getFilterSize() {
      return sizeof($this->filter);
    }
    public function getFilterList() {
      return $this->filter;
    }
    public function mutableFilter($idx) {
      if (!isset($this->filter[$idx])) {
        $val = new \google\appengine\datastore\v4\Filter();
        $this->filter[$idx] = $val;
        return $val;
      }
      return $this->filter[$idx];
    }
    public function getFilter($idx) {
      if (isset($this->filter[$idx])) {
        return $this->filter[$idx];
      }
      if ($idx >= end(array_keys($this->filter))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Filter();
    }
    public function addFilter() {
      $val = new \google\appengine\datastore\v4\Filter();
      $this->filter[] = $val;
      return $val;
    }
    public function clearFilter() {
      $this->filter = array();
    }
    public function clear() {
      $this->clearOperator();
      $this->clearFilter();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->operator)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->operator);
      }
      $this->checkProtoArray($this->filter);
      $res += 1 * sizeof($this->filter);
      foreach ($this->filter as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->operator)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->operator);
      }
      $this->checkProtoArray($this->filter);
      foreach ($this->filter as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setOperator($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addFilter()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->operator)) return 'operator';
      foreach ($this->filter as $value) {
        if (!$value->isInitialized()) return 'filter';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasOperator()) {
        $this->setOperator($x->getOperator());
      }
      foreach ($x->getFilterList() as $v) {
        $this->addFilter()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->operator) !== isset($x->operator)) return false;
      if (isset($this->operator) && $this->operator !== $x->operator) return false;
      if (sizeof($this->filter) !== sizeof($x->filter)) return false;
      foreach (array_map(null, $this->filter, $x->filter) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->operator)) {
        $res .= $prefix . "operator: " . ($this->operator) . "\n";
      }
      foreach ($this->filter as $value) {
        $res .= $prefix . "filter <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\PropertyFilter {
  class Operator {
    const LESS_THAN = 1;
    const LESS_THAN_OR_EQUAL = 2;
    const GREATER_THAN = 3;
    const GREATER_THAN_OR_EQUAL = 4;
    const EQUAL = 5;
    const HAS_ANCESTOR = 11;
  }
}
namespace google\appengine\datastore\v4 {
  class PropertyFilter extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return new \google\appengine\datastore\v4\PropertyReference();
      }
      return $this->property;
    }
    public function mutableProperty() {
      if (!isset($this->property)) {
        $res = new \google\appengine\datastore\v4\PropertyReference();
        $this->property = $res;
        return $res;
      }
      return $this->property;
    }
    public function clearProperty() {
      if (isset($this->property)) {
        unset($this->property);
      }
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getOperator() {
      if (!isset($this->operator)) {
        return 1;
      }
      return $this->operator;
    }
    public function setOperator($val) {
      $this->operator = $val;
      return $this;
    }
    public function clearOperator() {
      unset($this->operator);
      return $this;
    }
    public function hasOperator() {
      return isset($this->operator);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return new \google\appengine\datastore\v4\Value();
      }
      return $this->value;
    }
    public function mutableValue() {
      if (!isset($this->value)) {
        $res = new \google\appengine\datastore\v4\Value();
        $this->value = $res;
        return $res;
      }
      return $this->value;
    }
    public function clearValue() {
      if (isset($this->value)) {
        unset($this->value);
      }
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearOperator();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 1;
        $res += $this->lengthString($this->property->byteSizePartial());
      }
      if (isset($this->operator)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->operator);
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString($this->value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->property->byteSizePartial());
        $this->property->outputPartial($out);
      }
      if (isset($this->operator)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->operator);
      }
      if (isset($this->value)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->value->byteSizePartial());
        $this->value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableProperty()->tryMerge($tmp);
            break;
          case 16:
            $this->setOperator($d->getVarInt32());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableValue()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->property)) || (!$this->property->isInitialized())) return 'property';
      if (!isset($this->operator)) return 'operator';
      if ((!isset($this->value)) || (!$this->value->isInitialized())) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->mutableProperty()->mergeFrom($x->getProperty());
      }
      if ($x->hasOperator()) {
        $this->setOperator($x->getOperator());
      }
      if ($x->hasValue()) {
        $this->mutableValue()->mergeFrom($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && !$this->property->equals($x->property)) return false;
      if (isset($this->operator) !== isset($x->operator)) return false;
      if (isset($this->operator) && $this->operator !== $x->operator) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && !$this->value->equals($x->value)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property <\n" . $this->property->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->operator)) {
        $res .= $prefix . "operator: " . ($this->operator) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value <\n" . $this->value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class BoundingCircleFilter extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return new \google\appengine\datastore\v4\PropertyReference();
      }
      return $this->property;
    }
    public function mutableProperty() {
      if (!isset($this->property)) {
        $res = new \google\appengine\datastore\v4\PropertyReference();
        $this->property = $res;
        return $res;
      }
      return $this->property;
    }
    public function clearProperty() {
      if (isset($this->property)) {
        unset($this->property);
      }
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getCenter() {
      if (!isset($this->center)) {
        return new \google\appengine\datastore\v4\GeoPoint();
      }
      return $this->center;
    }
    public function mutableCenter() {
      if (!isset($this->center)) {
        $res = new \google\appengine\datastore\v4\GeoPoint();
        $this->center = $res;
        return $res;
      }
      return $this->center;
    }
    public function clearCenter() {
      if (isset($this->center)) {
        unset($this->center);
      }
    }
    public function hasCenter() {
      return isset($this->center);
    }
    public function getRadiusMeters() {
      if (!isset($this->radius_meters)) {
        return 0.0;
      }
      return $this->radius_meters;
    }
    public function setRadiusMeters($val) {
      $this->radius_meters = $val;
      return $this;
    }
    public function clearRadiusMeters() {
      unset($this->radius_meters);
      return $this;
    }
    public function hasRadiusMeters() {
      return isset($this->radius_meters);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearCenter();
      $this->clearRadiusMeters();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 1;
        $res += $this->lengthString($this->property->byteSizePartial());
      }
      if (isset($this->center)) {
        $res += 1;
        $res += $this->lengthString($this->center->byteSizePartial());
      }
      if (isset($this->radius_meters)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->property->byteSizePartial());
        $this->property->outputPartial($out);
      }
      if (isset($this->center)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->center->byteSizePartial());
        $this->center->outputPartial($out);
      }
      if (isset($this->radius_meters)) {
        $out->putVarInt32(25);
        $out->putDouble($this->radius_meters);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableProperty()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCenter()->tryMerge($tmp);
            break;
          case 25:
            $this->setRadiusMeters($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->property)) || (!$this->property->isInitialized())) return 'property';
      if ((!isset($this->center)) || (!$this->center->isInitialized())) return 'center';
      if (!isset($this->radius_meters)) return 'radius_meters';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->mutableProperty()->mergeFrom($x->getProperty());
      }
      if ($x->hasCenter()) {
        $this->mutableCenter()->mergeFrom($x->getCenter());
      }
      if ($x->hasRadiusMeters()) {
        $this->setRadiusMeters($x->getRadiusMeters());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && !$this->property->equals($x->property)) return false;
      if (isset($this->center) !== isset($x->center)) return false;
      if (isset($this->center) && !$this->center->equals($x->center)) return false;
      if (isset($this->radius_meters) !== isset($x->radius_meters)) return false;
      if (isset($this->radius_meters) && $this->radius_meters !== $x->radius_meters) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property <\n" . $this->property->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->center)) {
        $res .= $prefix . "center <\n" . $this->center->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->radius_meters)) {
        $res .= $prefix . "radius_meters: " . $this->debugFormatDouble($this->radius_meters) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class BoundingBoxFilter extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return new \google\appengine\datastore\v4\PropertyReference();
      }
      return $this->property;
    }
    public function mutableProperty() {
      if (!isset($this->property)) {
        $res = new \google\appengine\datastore\v4\PropertyReference();
        $this->property = $res;
        return $res;
      }
      return $this->property;
    }
    public function clearProperty() {
      if (isset($this->property)) {
        unset($this->property);
      }
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getSouthwest() {
      if (!isset($this->southwest)) {
        return new \google\appengine\datastore\v4\GeoPoint();
      }
      return $this->southwest;
    }
    public function mutableSouthwest() {
      if (!isset($this->southwest)) {
        $res = new \google\appengine\datastore\v4\GeoPoint();
        $this->southwest = $res;
        return $res;
      }
      return $this->southwest;
    }
    public function clearSouthwest() {
      if (isset($this->southwest)) {
        unset($this->southwest);
      }
    }
    public function hasSouthwest() {
      return isset($this->southwest);
    }
    public function getNortheast() {
      if (!isset($this->northeast)) {
        return new \google\appengine\datastore\v4\GeoPoint();
      }
      return $this->northeast;
    }
    public function mutableNortheast() {
      if (!isset($this->northeast)) {
        $res = new \google\appengine\datastore\v4\GeoPoint();
        $this->northeast = $res;
        return $res;
      }
      return $this->northeast;
    }
    public function clearNortheast() {
      if (isset($this->northeast)) {
        unset($this->northeast);
      }
    }
    public function hasNortheast() {
      return isset($this->northeast);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearSouthwest();
      $this->clearNortheast();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 1;
        $res += $this->lengthString($this->property->byteSizePartial());
      }
      if (isset($this->southwest)) {
        $res += 1;
        $res += $this->lengthString($this->southwest->byteSizePartial());
      }
      if (isset($this->northeast)) {
        $res += 1;
        $res += $this->lengthString($this->northeast->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->property->byteSizePartial());
        $this->property->outputPartial($out);
      }
      if (isset($this->southwest)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->southwest->byteSizePartial());
        $this->southwest->outputPartial($out);
      }
      if (isset($this->northeast)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->northeast->byteSizePartial());
        $this->northeast->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableProperty()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableSouthwest()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableNortheast()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->property)) || (!$this->property->isInitialized())) return 'property';
      if ((!isset($this->southwest)) || (!$this->southwest->isInitialized())) return 'southwest';
      if ((!isset($this->northeast)) || (!$this->northeast->isInitialized())) return 'northeast';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->mutableProperty()->mergeFrom($x->getProperty());
      }
      if ($x->hasSouthwest()) {
        $this->mutableSouthwest()->mergeFrom($x->getSouthwest());
      }
      if ($x->hasNortheast()) {
        $this->mutableNortheast()->mergeFrom($x->getNortheast());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && !$this->property->equals($x->property)) return false;
      if (isset($this->southwest) !== isset($x->southwest)) return false;
      if (isset($this->southwest) && !$this->southwest->equals($x->southwest)) return false;
      if (isset($this->northeast) !== isset($x->northeast)) return false;
      if (isset($this->northeast) && !$this->northeast->equals($x->northeast)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property <\n" . $this->property->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->southwest)) {
        $res .= $prefix . "southwest <\n" . $this->southwest->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->northeast)) {
        $res .= $prefix . "northeast <\n" . $this->northeast->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class GqlQuery extends \google\net\ProtocolMessage {
    private $name_arg = array();
    private $number_arg = array();
    public function getQueryString() {
      if (!isset($this->query_string)) {
        return '';
      }
      return $this->query_string;
    }
    public function setQueryString($val) {
      $this->query_string = $val;
      return $this;
    }
    public function clearQueryString() {
      unset($this->query_string);
      return $this;
    }
    public function hasQueryString() {
      return isset($this->query_string);
    }
    public function getAllowLiteral() {
      if (!isset($this->allow_literal)) {
        return false;
      }
      return $this->allow_literal;
    }
    public function setAllowLiteral($val) {
      $this->allow_literal = $val;
      return $this;
    }
    public function clearAllowLiteral() {
      unset($this->allow_literal);
      return $this;
    }
    public function hasAllowLiteral() {
      return isset($this->allow_literal);
    }
    public function getNameArgSize() {
      return sizeof($this->name_arg);
    }
    public function getNameArgList() {
      return $this->name_arg;
    }
    public function mutableNameArg($idx) {
      if (!isset($this->name_arg[$idx])) {
        $val = new \google\appengine\datastore\v4\GqlQueryArg();
        $this->name_arg[$idx] = $val;
        return $val;
      }
      return $this->name_arg[$idx];
    }
    public function getNameArg($idx) {
      if (isset($this->name_arg[$idx])) {
        return $this->name_arg[$idx];
      }
      if ($idx >= end(array_keys($this->name_arg))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\GqlQueryArg();
    }
    public function addNameArg() {
      $val = new \google\appengine\datastore\v4\GqlQueryArg();
      $this->name_arg[] = $val;
      return $val;
    }
    public function clearNameArg() {
      $this->name_arg = array();
    }
    public function getNumberArgSize() {
      return sizeof($this->number_arg);
    }
    public function getNumberArgList() {
      return $this->number_arg;
    }
    public function mutableNumberArg($idx) {
      if (!isset($this->number_arg[$idx])) {
        $val = new \google\appengine\datastore\v4\GqlQueryArg();
        $this->number_arg[$idx] = $val;
        return $val;
      }
      return $this->number_arg[$idx];
    }
    public function getNumberArg($idx) {
      if (isset($this->number_arg[$idx])) {
        return $this->number_arg[$idx];
      }
      if ($idx >= end(array_keys($this->number_arg))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\GqlQueryArg();
    }
    public function addNumberArg() {
      $val = new \google\appengine\datastore\v4\GqlQueryArg();
      $this->number_arg[] = $val;
      return $val;
    }
    public function clearNumberArg() {
      $this->number_arg = array();
    }
    public function clear() {
      $this->clearQueryString();
      $this->clearAllowLiteral();
      $this->clearNameArg();
      $this->clearNumberArg();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->query_string)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->query_string));
      }
      if (isset($this->allow_literal)) {
        $res += 2;
      }
      $this->checkProtoArray($this->name_arg);
      $res += 1 * sizeof($this->name_arg);
      foreach ($this->name_arg as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->number_arg);
      $res += 1 * sizeof($this->number_arg);
      foreach ($this->number_arg as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->query_string)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->query_string);
      }
      if (isset($this->allow_literal)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->allow_literal);
      }
      $this->checkProtoArray($this->name_arg);
      foreach ($this->name_arg as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->number_arg);
      foreach ($this->number_arg as $value) {
        $out->putVarInt32(34);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setQueryString(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setAllowLiteral($d->getBoolean());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addNameArg()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addNumberArg()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->query_string)) return 'query_string';
      foreach ($this->name_arg as $value) {
        if (!$value->isInitialized()) return 'name_arg';
      }
      foreach ($this->number_arg as $value) {
        if (!$value->isInitialized()) return 'number_arg';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueryString()) {
        $this->setQueryString($x->getQueryString());
      }
      if ($x->hasAllowLiteral()) {
        $this->setAllowLiteral($x->getAllowLiteral());
      }
      foreach ($x->getNameArgList() as $v) {
        $this->addNameArg()->copyFrom($v);
      }
      foreach ($x->getNumberArgList() as $v) {
        $this->addNumberArg()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->query_string) !== isset($x->query_string)) return false;
      if (isset($this->query_string) && $this->query_string !== $x->query_string) return false;
      if (isset($this->allow_literal) !== isset($x->allow_literal)) return false;
      if (isset($this->allow_literal) && $this->allow_literal !== $x->allow_literal) return false;
      if (sizeof($this->name_arg) !== sizeof($x->name_arg)) return false;
      foreach (array_map(null, $this->name_arg, $x->name_arg) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->number_arg) !== sizeof($x->number_arg)) return false;
      foreach (array_map(null, $this->number_arg, $x->number_arg) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->query_string)) {
        $res .= $prefix . "query_string: " . $this->debugFormatString($this->query_string) . "\n";
      }
      if (isset($this->allow_literal)) {
        $res .= $prefix . "allow_literal: " . $this->debugFormatBool($this->allow_literal) . "\n";
      }
      foreach ($this->name_arg as $value) {
        $res .= $prefix . "name_arg <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->number_arg as $value) {
        $res .= $prefix . "number_arg <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class GqlQueryArg extends \google\net\ProtocolMessage {
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return new \google\appengine\datastore\v4\Value();
      }
      return $this->value;
    }
    public function mutableValue() {
      if (!isset($this->value)) {
        $res = new \google\appengine\datastore\v4\Value();
        $this->value = $res;
        return $res;
      }
      return $this->value;
    }
    public function clearValue() {
      if (isset($this->value)) {
        unset($this->value);
      }
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function getCursor() {
      if (!isset($this->cursor)) {
        return '';
      }
      return $this->cursor;
    }
    public function setCursor($val) {
      $this->cursor = $val;
      return $this;
    }
    public function clearCursor() {
      unset($this->cursor);
      return $this;
    }
    public function hasCursor() {
      return isset($this->cursor);
    }
    public function clear() {
      $this->clearName();
      $this->clearValue();
      $this->clearCursor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString($this->value->byteSizePartial());
      }
      if (isset($this->cursor)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->cursor));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->name);
      }
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->value->byteSizePartial());
        $this->value->outputPartial($out);
      }
      if (isset($this->cursor)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->cursor);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableValue()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setCursor(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->value) && (!$this->value->isInitialized())) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
      if ($x->hasValue()) {
        $this->mutableValue()->mergeFrom($x->getValue());
      }
      if ($x->hasCursor()) {
        $this->setCursor($x->getCursor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && !$this->value->equals($x->value)) return false;
      if (isset($this->cursor) !== isset($x->cursor)) return false;
      if (isset($this->cursor) && $this->cursor !== $x->cursor) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value <\n" . $this->value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->cursor)) {
        $res .= $prefix . "cursor: " . $this->debugFormatString($this->cursor) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\QueryResultBatch {
  class MoreResultsType {
    const NOT_FINISHED = 1;
    const MORE_RESULTS_AFTER_LIMIT = 2;
    const NO_MORE_RESULTS = 3;
  }
}
namespace google\appengine\datastore\v4 {
  class QueryResultBatch extends \google\net\ProtocolMessage {
    private $entity_result = array();
    public function getEntityResultType() {
      if (!isset($this->entity_result_type)) {
        return 1;
      }
      return $this->entity_result_type;
    }
    public function setEntityResultType($val) {
      $this->entity_result_type = $val;
      return $this;
    }
    public function clearEntityResultType() {
      unset($this->entity_result_type);
      return $this;
    }
    public function hasEntityResultType() {
      return isset($this->entity_result_type);
    }
    public function getEntityResultSize() {
      return sizeof($this->entity_result);
    }
    public function getEntityResultList() {
      return $this->entity_result;
    }
    public function mutableEntityResult($idx) {
      if (!isset($this->entity_result[$idx])) {
        $val = new \google\appengine\datastore\v4\EntityResult();
        $this->entity_result[$idx] = $val;
        return $val;
      }
      return $this->entity_result[$idx];
    }
    public function getEntityResult($idx) {
      if (isset($this->entity_result[$idx])) {
        return $this->entity_result[$idx];
      }
      if ($idx >= end(array_keys($this->entity_result))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\EntityResult();
    }
    public function addEntityResult() {
      $val = new \google\appengine\datastore\v4\EntityResult();
      $this->entity_result[] = $val;
      return $val;
    }
    public function clearEntityResult() {
      $this->entity_result = array();
    }
    public function getSkippedCursor() {
      if (!isset($this->skipped_cursor)) {
        return '';
      }
      return $this->skipped_cursor;
    }
    public function setSkippedCursor($val) {
      $this->skipped_cursor = $val;
      return $this;
    }
    public function clearSkippedCursor() {
      unset($this->skipped_cursor);
      return $this;
    }
    public function hasSkippedCursor() {
      return isset($this->skipped_cursor);
    }
    public function getEndCursor() {
      if (!isset($this->end_cursor)) {
        return '';
      }
      return $this->end_cursor;
    }
    public function setEndCursor($val) {
      $this->end_cursor = $val;
      return $this;
    }
    public function clearEndCursor() {
      unset($this->end_cursor);
      return $this;
    }
    public function hasEndCursor() {
      return isset($this->end_cursor);
    }
    public function getMoreResults() {
      if (!isset($this->more_results)) {
        return 1;
      }
      return $this->more_results;
    }
    public function setMoreResults($val) {
      $this->more_results = $val;
      return $this;
    }
    public function clearMoreResults() {
      unset($this->more_results);
      return $this;
    }
    public function hasMoreResults() {
      return isset($this->more_results);
    }
    public function getSkippedResults() {
      if (!isset($this->skipped_results)) {
        return 0;
      }
      return $this->skipped_results;
    }
    public function setSkippedResults($val) {
      $this->skipped_results = $val;
      return $this;
    }
    public function clearSkippedResults() {
      unset($this->skipped_results);
      return $this;
    }
    public function hasSkippedResults() {
      return isset($this->skipped_results);
    }
    public function getSnapshotVersion() {
      if (!isset($this->snapshot_version)) {
        return "0";
      }
      return $this->snapshot_version;
    }
    public function setSnapshotVersion($val) {
      if (is_double($val)) {
        $this->snapshot_version = sprintf('%0.0F', $val);
      } else {
        $this->snapshot_version = $val;
      }
      return $this;
    }
    public function clearSnapshotVersion() {
      unset($this->snapshot_version);
      return $this;
    }
    public function hasSnapshotVersion() {
      return isset($this->snapshot_version);
    }
    public function clear() {
      $this->clearEntityResultType();
      $this->clearEntityResult();
      $this->clearSkippedCursor();
      $this->clearEndCursor();
      $this->clearMoreResults();
      $this->clearSkippedResults();
      $this->clearSnapshotVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->entity_result_type)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->entity_result_type);
      }
      $this->checkProtoArray($this->entity_result);
      $res += 1 * sizeof($this->entity_result);
      foreach ($this->entity_result as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->skipped_cursor)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->skipped_cursor));
      }
      if (isset($this->end_cursor)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->end_cursor));
      }
      if (isset($this->more_results)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->more_results);
      }
      if (isset($this->skipped_results)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->skipped_results);
      }
      if (isset($this->snapshot_version)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->snapshot_version);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->entity_result_type)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->entity_result_type);
      }
      $this->checkProtoArray($this->entity_result);
      foreach ($this->entity_result as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->skipped_cursor)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->skipped_cursor);
      }
      if (isset($this->end_cursor)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->end_cursor);
      }
      if (isset($this->more_results)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->more_results);
      }
      if (isset($this->skipped_results)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->skipped_results);
      }
      if (isset($this->snapshot_version)) {
        $out->putVarInt32(56);
        $out->putVarInt64($this->snapshot_version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setEntityResultType($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addEntityResult()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setSkippedCursor(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setEndCursor(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 40:
            $this->setMoreResults($d->getVarInt32());
            break;
          case 48:
            $this->setSkippedResults($d->getVarInt32());
            break;
          case 56:
            $this->setSnapshotVersion($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->entity_result_type)) return 'entity_result_type';
      foreach ($this->entity_result as $value) {
        if (!$value->isInitialized()) return 'entity_result';
      }
      if (!isset($this->more_results)) return 'more_results';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasEntityResultType()) {
        $this->setEntityResultType($x->getEntityResultType());
      }
      foreach ($x->getEntityResultList() as $v) {
        $this->addEntityResult()->copyFrom($v);
      }
      if ($x->hasSkippedCursor()) {
        $this->setSkippedCursor($x->getSkippedCursor());
      }
      if ($x->hasEndCursor()) {
        $this->setEndCursor($x->getEndCursor());
      }
      if ($x->hasMoreResults()) {
        $this->setMoreResults($x->getMoreResults());
      }
      if ($x->hasSkippedResults()) {
        $this->setSkippedResults($x->getSkippedResults());
      }
      if ($x->hasSnapshotVersion()) {
        $this->setSnapshotVersion($x->getSnapshotVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->entity_result_type) !== isset($x->entity_result_type)) return false;
      if (isset($this->entity_result_type) && $this->entity_result_type !== $x->entity_result_type) return false;
      if (sizeof($this->entity_result) !== sizeof($x->entity_result)) return false;
      foreach (array_map(null, $this->entity_result, $x->entity_result) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->skipped_cursor) !== isset($x->skipped_cursor)) return false;
      if (isset($this->skipped_cursor) && $this->skipped_cursor !== $x->skipped_cursor) return false;
      if (isset($this->end_cursor) !== isset($x->end_cursor)) return false;
      if (isset($this->end_cursor) && $this->end_cursor !== $x->end_cursor) return false;
      if (isset($this->more_results) !== isset($x->more_results)) return false;
      if (isset($this->more_results) && $this->more_results !== $x->more_results) return false;
      if (isset($this->skipped_results) !== isset($x->skipped_results)) return false;
      if (isset($this->skipped_results) && !$this->integerEquals($this->skipped_results, $x->skipped_results)) return false;
      if (isset($this->snapshot_version) !== isset($x->snapshot_version)) return false;
      if (isset($this->snapshot_version) && !$this->integerEquals($this->snapshot_version, $x->snapshot_version)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->entity_result_type)) {
        $res .= $prefix . "entity_result_type: " . ($this->entity_result_type) . "\n";
      }
      foreach ($this->entity_result as $value) {
        $res .= $prefix . "entity_result <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->skipped_cursor)) {
        $res .= $prefix . "skipped_cursor: " . $this->debugFormatString($this->skipped_cursor) . "\n";
      }
      if (isset($this->end_cursor)) {
        $res .= $prefix . "end_cursor: " . $this->debugFormatString($this->end_cursor) . "\n";
      }
      if (isset($this->more_results)) {
        $res .= $prefix . "more_results: " . ($this->more_results) . "\n";
      }
      if (isset($this->skipped_results)) {
        $res .= $prefix . "skipped_results: " . $this->debugFormatInt32($this->skipped_results) . "\n";
      }
      if (isset($this->snapshot_version)) {
        $res .= $prefix . "snapshot_version: " . $this->debugFormatInt64($this->snapshot_version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\Mutation {
  class Operation {
    const UNKNOWN = 0;
    const INSERT = 1;
    const UPDATE = 2;
    const UPSERT = 3;
    const DELETE = 4;
  }
}
namespace google\appengine\datastore\v4 {
  class Mutation extends \google\net\ProtocolMessage {
    public function getOp() {
      if (!isset($this->op)) {
        return 0;
      }
      return $this->op;
    }
    public function setOp($val) {
      $this->op = $val;
      return $this;
    }
    public function clearOp() {
      unset($this->op);
      return $this;
    }
    public function hasOp() {
      return isset($this->op);
    }
    public function getKey() {
      if (!isset($this->key)) {
        return new \google\appengine\datastore\v4\Key();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \google\appengine\datastore\v4\Key();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getEntity() {
      if (!isset($this->entity)) {
        return new \google\appengine\datastore\v4\Entity();
      }
      return $this->entity;
    }
    public function mutableEntity() {
      if (!isset($this->entity)) {
        $res = new \google\appengine\datastore\v4\Entity();
        $this->entity = $res;
        return $res;
      }
      return $this->entity;
    }
    public function clearEntity() {
      if (isset($this->entity)) {
        unset($this->entity);
      }
    }
    public function hasEntity() {
      return isset($this->entity);
    }
    public function clear() {
      $this->clearOp();
      $this->clearKey();
      $this->clearEntity();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->op)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->op);
      }
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      if (isset($this->entity)) {
        $res += 1;
        $res += $this->lengthString($this->entity->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->op)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->op);
      }
      if (isset($this->key)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      if (isset($this->entity)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->entity->byteSizePartial());
        $this->entity->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setOp($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntity()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->key) && (!$this->key->isInitialized())) return 'key';
      if (isset($this->entity) && (!$this->entity->isInitialized())) return 'entity';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasOp()) {
        $this->setOp($x->getOp());
      }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      if ($x->hasEntity()) {
        $this->mutableEntity()->mergeFrom($x->getEntity());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->op) !== isset($x->op)) return false;
      if (isset($this->op) && $this->op !== $x->op) return false;
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (isset($this->entity) !== isset($x->entity)) return false;
      if (isset($this->entity) && !$this->entity->equals($x->entity)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->op)) {
        $res .= $prefix . "op: " . ($this->op) . "\n";
      }
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->entity)) {
        $res .= $prefix . "entity <\n" . $this->entity->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class MutationResult extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return new \google\appengine\datastore\v4\Key();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \google\appengine\datastore\v4\Key();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getNewVersion() {
      if (!isset($this->new_version)) {
        return '0';
      }
      return $this->new_version;
    }
    public function setNewVersion($val) {
      if (is_double($val)) {
        $this->new_version = sprintf('%0.0F', $val);
      } else {
        $this->new_version = $val;
      }
      return $this;
    }
    public function clearNewVersion() {
      unset($this->new_version);
      return $this;
    }
    public function hasNewVersion() {
      return isset($this->new_version);
    }
    public function clear() {
      $this->clearKey();
      $this->clearNewVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      if (isset($this->new_version)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->new_version);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      if (isset($this->new_version)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->new_version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 32:
            $this->setNewVersion($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->key) && (!$this->key->isInitialized())) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      if ($x->hasNewVersion()) {
        $this->setNewVersion($x->getNewVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (isset($this->new_version) !== isset($x->new_version)) return false;
      if (isset($this->new_version) && !$this->integerEquals($this->new_version, $x->new_version)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->new_version)) {
        $res .= $prefix . "new_version: " . $this->debugFormatInt64($this->new_version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class DeprecatedMutation extends \google\net\ProtocolMessage {
    private $upsert = array();
    private $update = array();
    private $insert = array();
    private $insert_auto_id = array();
    private $delete = array();
    public function getUpsertSize() {
      return sizeof($this->upsert);
    }
    public function getUpsertList() {
      return $this->upsert;
    }
    public function mutableUpsert($idx) {
      if (!isset($this->upsert[$idx])) {
        $val = new \google\appengine\datastore\v4\Entity();
        $this->upsert[$idx] = $val;
        return $val;
      }
      return $this->upsert[$idx];
    }
    public function getUpsert($idx) {
      if (isset($this->upsert[$idx])) {
        return $this->upsert[$idx];
      }
      if ($idx >= end(array_keys($this->upsert))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Entity();
    }
    public function addUpsert() {
      $val = new \google\appengine\datastore\v4\Entity();
      $this->upsert[] = $val;
      return $val;
    }
    public function clearUpsert() {
      $this->upsert = array();
    }
    public function getUpdateSize() {
      return sizeof($this->update);
    }
    public function getUpdateList() {
      return $this->update;
    }
    public function mutableUpdate($idx) {
      if (!isset($this->update[$idx])) {
        $val = new \google\appengine\datastore\v4\Entity();
        $this->update[$idx] = $val;
        return $val;
      }
      return $this->update[$idx];
    }
    public function getUpdate($idx) {
      if (isset($this->update[$idx])) {
        return $this->update[$idx];
      }
      if ($idx >= end(array_keys($this->update))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Entity();
    }
    public function addUpdate() {
      $val = new \google\appengine\datastore\v4\Entity();
      $this->update[] = $val;
      return $val;
    }
    public function clearUpdate() {
      $this->update = array();
    }
    public function getInsertSize() {
      return sizeof($this->insert);
    }
    public function getInsertList() {
      return $this->insert;
    }
    public function mutableInsert($idx) {
      if (!isset($this->insert[$idx])) {
        $val = new \google\appengine\datastore\v4\Entity();
        $this->insert[$idx] = $val;
        return $val;
      }
      return $this->insert[$idx];
    }
    public function getInsert($idx) {
      if (isset($this->insert[$idx])) {
        return $this->insert[$idx];
      }
      if ($idx >= end(array_keys($this->insert))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Entity();
    }
    public function addInsert() {
      $val = new \google\appengine\datastore\v4\Entity();
      $this->insert[] = $val;
      return $val;
    }
    public function clearInsert() {
      $this->insert = array();
    }
    public function getInsertAutoIdSize() {
      return sizeof($this->insert_auto_id);
    }
    public function getInsertAutoIdList() {
      return $this->insert_auto_id;
    }
    public function mutableInsertAutoId($idx) {
      if (!isset($this->insert_auto_id[$idx])) {
        $val = new \google\appengine\datastore\v4\Entity();
        $this->insert_auto_id[$idx] = $val;
        return $val;
      }
      return $this->insert_auto_id[$idx];
    }
    public function getInsertAutoId($idx) {
      if (isset($this->insert_auto_id[$idx])) {
        return $this->insert_auto_id[$idx];
      }
      if ($idx >= end(array_keys($this->insert_auto_id))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Entity();
    }
    public function addInsertAutoId() {
      $val = new \google\appengine\datastore\v4\Entity();
      $this->insert_auto_id[] = $val;
      return $val;
    }
    public function clearInsertAutoId() {
      $this->insert_auto_id = array();
    }
    public function getDeleteSize() {
      return sizeof($this->delete);
    }
    public function getDeleteList() {
      return $this->delete;
    }
    public function mutableDelete($idx) {
      if (!isset($this->delete[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->delete[$idx] = $val;
        return $val;
      }
      return $this->delete[$idx];
    }
    public function getDelete($idx) {
      if (isset($this->delete[$idx])) {
        return $this->delete[$idx];
      }
      if ($idx >= end(array_keys($this->delete))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addDelete() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->delete[] = $val;
      return $val;
    }
    public function clearDelete() {
      $this->delete = array();
    }
    public function getForce() {
      if (!isset($this->force)) {
        return false;
      }
      return $this->force;
    }
    public function setForce($val) {
      $this->force = $val;
      return $this;
    }
    public function clearForce() {
      unset($this->force);
      return $this;
    }
    public function hasForce() {
      return isset($this->force);
    }
    public function clear() {
      $this->clearUpsert();
      $this->clearUpdate();
      $this->clearInsert();
      $this->clearInsertAutoId();
      $this->clearDelete();
      $this->clearForce();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->upsert);
      $res += 1 * sizeof($this->upsert);
      foreach ($this->upsert as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->update);
      $res += 1 * sizeof($this->update);
      foreach ($this->update as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->insert);
      $res += 1 * sizeof($this->insert);
      foreach ($this->insert as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->insert_auto_id);
      $res += 1 * sizeof($this->insert_auto_id);
      foreach ($this->insert_auto_id as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->delete);
      $res += 1 * sizeof($this->delete);
      foreach ($this->delete as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->force)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->upsert);
      foreach ($this->upsert as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->update);
      foreach ($this->update as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->insert);
      foreach ($this->insert as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->insert_auto_id);
      foreach ($this->insert_auto_id as $value) {
        $out->putVarInt32(34);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->delete);
      foreach ($this->delete as $value) {
        $out->putVarInt32(42);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->force)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->force);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addUpsert()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addUpdate()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addInsert()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addInsertAutoId()->tryMerge($tmp);
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addDelete()->tryMerge($tmp);
            break;
          case 48:
            $this->setForce($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->upsert as $value) {
        if (!$value->isInitialized()) return 'upsert';
      }
      foreach ($this->update as $value) {
        if (!$value->isInitialized()) return 'update';
      }
      foreach ($this->insert as $value) {
        if (!$value->isInitialized()) return 'insert';
      }
      foreach ($this->insert_auto_id as $value) {
        if (!$value->isInitialized()) return 'insert_auto_id';
      }
      foreach ($this->delete as $value) {
        if (!$value->isInitialized()) return 'delete';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getUpsertList() as $v) {
        $this->addUpsert()->copyFrom($v);
      }
      foreach ($x->getUpdateList() as $v) {
        $this->addUpdate()->copyFrom($v);
      }
      foreach ($x->getInsertList() as $v) {
        $this->addInsert()->copyFrom($v);
      }
      foreach ($x->getInsertAutoIdList() as $v) {
        $this->addInsertAutoId()->copyFrom($v);
      }
      foreach ($x->getDeleteList() as $v) {
        $this->addDelete()->copyFrom($v);
      }
      if ($x->hasForce()) {
        $this->setForce($x->getForce());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->upsert) !== sizeof($x->upsert)) return false;
      foreach (array_map(null, $this->upsert, $x->upsert) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->update) !== sizeof($x->update)) return false;
      foreach (array_map(null, $this->update, $x->update) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->insert) !== sizeof($x->insert)) return false;
      foreach (array_map(null, $this->insert, $x->insert) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->insert_auto_id) !== sizeof($x->insert_auto_id)) return false;
      foreach (array_map(null, $this->insert_auto_id, $x->insert_auto_id) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->delete) !== sizeof($x->delete)) return false;
      foreach (array_map(null, $this->delete, $x->delete) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->force) !== isset($x->force)) return false;
      if (isset($this->force) && $this->force !== $x->force) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->upsert as $value) {
        $res .= $prefix . "upsert <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->update as $value) {
        $res .= $prefix . "update <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->insert as $value) {
        $res .= $prefix . "insert <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->insert_auto_id as $value) {
        $res .= $prefix . "insert_auto_id <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->delete as $value) {
        $res .= $prefix . "delete <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->force)) {
        $res .= $prefix . "force: " . $this->debugFormatBool($this->force) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class DeprecatedMutationResult extends \google\net\ProtocolMessage {
    private $insert_auto_id_key = array();
    private $upsert_version = array();
    private $update_version = array();
    private $insert_version = array();
    private $insert_auto_id_version = array();
    private $delete_version = array();
    public function getIndexUpdates() {
      if (!isset($this->index_updates)) {
        return 0;
      }
      return $this->index_updates;
    }
    public function setIndexUpdates($val) {
      $this->index_updates = $val;
      return $this;
    }
    public function clearIndexUpdates() {
      unset($this->index_updates);
      return $this;
    }
    public function hasIndexUpdates() {
      return isset($this->index_updates);
    }
    public function getInsertAutoIdKeySize() {
      return sizeof($this->insert_auto_id_key);
    }
    public function getInsertAutoIdKeyList() {
      return $this->insert_auto_id_key;
    }
    public function mutableInsertAutoIdKey($idx) {
      if (!isset($this->insert_auto_id_key[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->insert_auto_id_key[$idx] = $val;
        return $val;
      }
      return $this->insert_auto_id_key[$idx];
    }
    public function getInsertAutoIdKey($idx) {
      if (isset($this->insert_auto_id_key[$idx])) {
        return $this->insert_auto_id_key[$idx];
      }
      if ($idx >= end(array_keys($this->insert_auto_id_key))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addInsertAutoIdKey() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->insert_auto_id_key[] = $val;
      return $val;
    }
    public function clearInsertAutoIdKey() {
      $this->insert_auto_id_key = array();
    }
    public function getUpsertVersionSize() {
      return sizeof($this->upsert_version);
    }
    public function getUpsertVersionList() {
      return $this->upsert_version;
    }
    public function getUpsertVersion($idx) {
      return $this->upsert_version[$idx];
    }
    public function setUpsertVersion($idx, $val) {
      if (is_double($val)) {
        $this->upsert_version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->upsert_version[$idx] = $val;
      }
      return $this;
    }
    public function addUpsertVersion($val) {
      if (is_double($val)) {
        $this->upsert_version[] = sprintf('%0.0F', $val);
      } else {
        $this->upsert_version[] = $val;
      }
      return $this;
    }
    public function clearUpsertVersion() {
      $this->upsert_version = array();
    }
    public function getUpdateVersionSize() {
      return sizeof($this->update_version);
    }
    public function getUpdateVersionList() {
      return $this->update_version;
    }
    public function getUpdateVersion($idx) {
      return $this->update_version[$idx];
    }
    public function setUpdateVersion($idx, $val) {
      if (is_double($val)) {
        $this->update_version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->update_version[$idx] = $val;
      }
      return $this;
    }
    public function addUpdateVersion($val) {
      if (is_double($val)) {
        $this->update_version[] = sprintf('%0.0F', $val);
      } else {
        $this->update_version[] = $val;
      }
      return $this;
    }
    public function clearUpdateVersion() {
      $this->update_version = array();
    }
    public function getInsertVersionSize() {
      return sizeof($this->insert_version);
    }
    public function getInsertVersionList() {
      return $this->insert_version;
    }
    public function getInsertVersion($idx) {
      return $this->insert_version[$idx];
    }
    public function setInsertVersion($idx, $val) {
      if (is_double($val)) {
        $this->insert_version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->insert_version[$idx] = $val;
      }
      return $this;
    }
    public function addInsertVersion($val) {
      if (is_double($val)) {
        $this->insert_version[] = sprintf('%0.0F', $val);
      } else {
        $this->insert_version[] = $val;
      }
      return $this;
    }
    public function clearInsertVersion() {
      $this->insert_version = array();
    }
    public function getInsertAutoIdVersionSize() {
      return sizeof($this->insert_auto_id_version);
    }
    public function getInsertAutoIdVersionList() {
      return $this->insert_auto_id_version;
    }
    public function getInsertAutoIdVersion($idx) {
      return $this->insert_auto_id_version[$idx];
    }
    public function setInsertAutoIdVersion($idx, $val) {
      if (is_double($val)) {
        $this->insert_auto_id_version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->insert_auto_id_version[$idx] = $val;
      }
      return $this;
    }
    public function addInsertAutoIdVersion($val) {
      if (is_double($val)) {
        $this->insert_auto_id_version[] = sprintf('%0.0F', $val);
      } else {
        $this->insert_auto_id_version[] = $val;
      }
      return $this;
    }
    public function clearInsertAutoIdVersion() {
      $this->insert_auto_id_version = array();
    }
    public function getDeleteVersionSize() {
      return sizeof($this->delete_version);
    }
    public function getDeleteVersionList() {
      return $this->delete_version;
    }
    public function getDeleteVersion($idx) {
      return $this->delete_version[$idx];
    }
    public function setDeleteVersion($idx, $val) {
      if (is_double($val)) {
        $this->delete_version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->delete_version[$idx] = $val;
      }
      return $this;
    }
    public function addDeleteVersion($val) {
      if (is_double($val)) {
        $this->delete_version[] = sprintf('%0.0F', $val);
      } else {
        $this->delete_version[] = $val;
      }
      return $this;
    }
    public function clearDeleteVersion() {
      $this->delete_version = array();
    }
    public function clear() {
      $this->clearIndexUpdates();
      $this->clearInsertAutoIdKey();
      $this->clearUpsertVersion();
      $this->clearUpdateVersion();
      $this->clearInsertVersion();
      $this->clearInsertAutoIdVersion();
      $this->clearDeleteVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_updates)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_updates);
      }
      $this->checkProtoArray($this->insert_auto_id_key);
      $res += 1 * sizeof($this->insert_auto_id_key);
      foreach ($this->insert_auto_id_key as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->upsert_version);
      $res += 1 * sizeof($this->upsert_version);
      foreach ($this->upsert_version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->update_version);
      $res += 1 * sizeof($this->update_version);
      foreach ($this->update_version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->insert_version);
      $res += 1 * sizeof($this->insert_version);
      foreach ($this->insert_version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->insert_auto_id_version);
      $res += 1 * sizeof($this->insert_auto_id_version);
      foreach ($this->insert_auto_id_version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->delete_version);
      $res += 1 * sizeof($this->delete_version);
      foreach ($this->delete_version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_updates)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->index_updates);
      }
      $this->checkProtoArray($this->insert_auto_id_key);
      foreach ($this->insert_auto_id_key as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->upsert_version);
      foreach ($this->upsert_version as $value) {
        $out->putVarInt32(24);
        $out->putVarInt64($value);
      }
      $this->checkProtoArray($this->update_version);
      foreach ($this->update_version as $value) {
        $out->putVarInt32(32);
        $out->putVarInt64($value);
      }
      $this->checkProtoArray($this->insert_version);
      foreach ($this->insert_version as $value) {
        $out->putVarInt32(40);
        $out->putVarInt64($value);
      }
      $this->checkProtoArray($this->insert_auto_id_version);
      foreach ($this->insert_auto_id_version as $value) {
        $out->putVarInt32(48);
        $out->putVarInt64($value);
      }
      $this->checkProtoArray($this->delete_version);
      foreach ($this->delete_version as $value) {
        $out->putVarInt32(56);
        $out->putVarInt64($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setIndexUpdates($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addInsertAutoIdKey()->tryMerge($tmp);
            break;
          case 24:
            $this->addUpsertVersion($d->getVarInt64());
            break;
          case 32:
            $this->addUpdateVersion($d->getVarInt64());
            break;
          case 40:
            $this->addInsertVersion($d->getVarInt64());
            break;
          case 48:
            $this->addInsertAutoIdVersion($d->getVarInt64());
            break;
          case 56:
            $this->addDeleteVersion($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->index_updates)) return 'index_updates';
      foreach ($this->insert_auto_id_key as $value) {
        if (!$value->isInitialized()) return 'insert_auto_id_key';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexUpdates()) {
        $this->setIndexUpdates($x->getIndexUpdates());
      }
      foreach ($x->getInsertAutoIdKeyList() as $v) {
        $this->addInsertAutoIdKey()->copyFrom($v);
      }
      foreach ($x->getUpsertVersionList() as $v) {
        $this->addUpsertVersion($v);
      }
      foreach ($x->getUpdateVersionList() as $v) {
        $this->addUpdateVersion($v);
      }
      foreach ($x->getInsertVersionList() as $v) {
        $this->addInsertVersion($v);
      }
      foreach ($x->getInsertAutoIdVersionList() as $v) {
        $this->addInsertAutoIdVersion($v);
      }
      foreach ($x->getDeleteVersionList() as $v) {
        $this->addDeleteVersion($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_updates) !== isset($x->index_updates)) return false;
      if (isset($this->index_updates) && !$this->integerEquals($this->index_updates, $x->index_updates)) return false;
      if (sizeof($this->insert_auto_id_key) !== sizeof($x->insert_auto_id_key)) return false;
      foreach (array_map(null, $this->insert_auto_id_key, $x->insert_auto_id_key) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->upsert_version) !== sizeof($x->upsert_version)) return false;
      foreach (array_map(null, $this->upsert_version, $x->upsert_version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->update_version) !== sizeof($x->update_version)) return false;
      foreach (array_map(null, $this->update_version, $x->update_version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->insert_version) !== sizeof($x->insert_version)) return false;
      foreach (array_map(null, $this->insert_version, $x->insert_version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->insert_auto_id_version) !== sizeof($x->insert_auto_id_version)) return false;
      foreach (array_map(null, $this->insert_auto_id_version, $x->insert_auto_id_version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->delete_version) !== sizeof($x->delete_version)) return false;
      foreach (array_map(null, $this->delete_version, $x->delete_version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_updates)) {
        $res .= $prefix . "index_updates: " . $this->debugFormatInt32($this->index_updates) . "\n";
      }
      foreach ($this->insert_auto_id_key as $value) {
        $res .= $prefix . "insert_auto_id_key <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->upsert_version as $value) {
        $res .= $prefix . "upsert_version: " . $this->debugFormatInt64($value) . "\n";
      }
      foreach ($this->update_version as $value) {
        $res .= $prefix . "update_version: " . $this->debugFormatInt64($value) . "\n";
      }
      foreach ($this->insert_version as $value) {
        $res .= $prefix . "insert_version: " . $this->debugFormatInt64($value) . "\n";
      }
      foreach ($this->insert_auto_id_version as $value) {
        $res .= $prefix . "insert_auto_id_version: " . $this->debugFormatInt64($value) . "\n";
      }
      foreach ($this->delete_version as $value) {
        $res .= $prefix . "delete_version: " . $this->debugFormatInt64($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\ReadOptions {
  class ReadConsistency {
    const DEFAULT_ = 0;
    const STRONG = 1;
    const EVENTUAL = 2;
  }
}
namespace google\appengine\datastore\v4 {
  class ReadOptions extends \google\net\ProtocolMessage {
    public function getReadConsistency() {
      if (!isset($this->read_consistency)) {
        return 0;
      }
      return $this->read_consistency;
    }
    public function setReadConsistency($val) {
      $this->read_consistency = $val;
      return $this;
    }
    public function clearReadConsistency() {
      unset($this->read_consistency);
      return $this;
    }
    public function hasReadConsistency() {
      return isset($this->read_consistency);
    }
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return '';
      }
      return $this->transaction;
    }
    public function setTransaction($val) {
      $this->transaction = $val;
      return $this;
    }
    public function clearTransaction() {
      unset($this->transaction);
      return $this;
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function clear() {
      $this->clearReadConsistency();
      $this->clearTransaction();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->read_consistency)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->read_consistency);
      }
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->transaction));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->read_consistency)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->read_consistency);
      }
      if (isset($this->transaction)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->transaction);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setReadConsistency($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setTransaction(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasReadConsistency()) {
        $this->setReadConsistency($x->getReadConsistency());
      }
      if ($x->hasTransaction()) {
        $this->setTransaction($x->getTransaction());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->read_consistency) !== isset($x->read_consistency)) return false;
      if (isset($this->read_consistency) && $this->read_consistency !== $x->read_consistency) return false;
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && $this->transaction !== $x->transaction) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->read_consistency)) {
        $res .= $prefix . "read_consistency: " . ($this->read_consistency) . "\n";
      }
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction: " . $this->debugFormatString($this->transaction) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class LookupRequest extends \google\net\ProtocolMessage {
    private $key = array();
    public function getReadOptions() {
      if (!isset($this->read_options)) {
        return new \google\appengine\datastore\v4\ReadOptions();
      }
      return $this->read_options;
    }
    public function mutableReadOptions() {
      if (!isset($this->read_options)) {
        $res = new \google\appengine\datastore\v4\ReadOptions();
        $this->read_options = $res;
        return $res;
      }
      return $this->read_options;
    }
    public function clearReadOptions() {
      if (isset($this->read_options)) {
        unset($this->read_options);
      }
    }
    public function hasReadOptions() {
      return isset($this->read_options);
    }
    public function getKeySize() {
      return sizeof($this->key);
    }
    public function getKeyList() {
      return $this->key;
    }
    public function mutableKey($idx) {
      if (!isset($this->key[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->key[$idx] = $val;
        return $val;
      }
      return $this->key[$idx];
    }
    public function getKey($idx) {
      if (isset($this->key[$idx])) {
        return $this->key[$idx];
      }
      if ($idx >= end(array_keys($this->key))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addKey() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->key[] = $val;
      return $val;
    }
    public function clearKey() {
      $this->key = array();
    }
    public function clear() {
      $this->clearReadOptions();
      $this->clearKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->read_options)) {
        $res += 1;
        $res += $this->lengthString($this->read_options->byteSizePartial());
      }
      $this->checkProtoArray($this->key);
      $res += 1 * sizeof($this->key);
      foreach ($this->key as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->read_options)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->read_options->byteSizePartial());
        $this->read_options->outputPartial($out);
      }
      $this->checkProtoArray($this->key);
      foreach ($this->key as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableReadOptions()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addKey()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->read_options) && (!$this->read_options->isInitialized())) return 'read_options';
      foreach ($this->key as $value) {
        if (!$value->isInitialized()) return 'key';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasReadOptions()) {
        $this->mutableReadOptions()->mergeFrom($x->getReadOptions());
      }
      foreach ($x->getKeyList() as $v) {
        $this->addKey()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->read_options) !== isset($x->read_options)) return false;
      if (isset($this->read_options) && !$this->read_options->equals($x->read_options)) return false;
      if (sizeof($this->key) !== sizeof($x->key)) return false;
      foreach (array_map(null, $this->key, $x->key) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->read_options)) {
        $res .= $prefix . "read_options <\n" . $this->read_options->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->key as $value) {
        $res .= $prefix . "key <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class LookupResponse extends \google\net\ProtocolMessage {
    private $found = array();
    private $missing = array();
    private $deferred = array();
    public function getFoundSize() {
      return sizeof($this->found);
    }
    public function getFoundList() {
      return $this->found;
    }
    public function mutableFound($idx) {
      if (!isset($this->found[$idx])) {
        $val = new \google\appengine\datastore\v4\EntityResult();
        $this->found[$idx] = $val;
        return $val;
      }
      return $this->found[$idx];
    }
    public function getFound($idx) {
      if (isset($this->found[$idx])) {
        return $this->found[$idx];
      }
      if ($idx >= end(array_keys($this->found))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\EntityResult();
    }
    public function addFound() {
      $val = new \google\appengine\datastore\v4\EntityResult();
      $this->found[] = $val;
      return $val;
    }
    public function clearFound() {
      $this->found = array();
    }
    public function getMissingSize() {
      return sizeof($this->missing);
    }
    public function getMissingList() {
      return $this->missing;
    }
    public function mutableMissing($idx) {
      if (!isset($this->missing[$idx])) {
        $val = new \google\appengine\datastore\v4\EntityResult();
        $this->missing[$idx] = $val;
        return $val;
      }
      return $this->missing[$idx];
    }
    public function getMissing($idx) {
      if (isset($this->missing[$idx])) {
        return $this->missing[$idx];
      }
      if ($idx >= end(array_keys($this->missing))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\EntityResult();
    }
    public function addMissing() {
      $val = new \google\appengine\datastore\v4\EntityResult();
      $this->missing[] = $val;
      return $val;
    }
    public function clearMissing() {
      $this->missing = array();
    }
    public function getDeferredSize() {
      return sizeof($this->deferred);
    }
    public function getDeferredList() {
      return $this->deferred;
    }
    public function mutableDeferred($idx) {
      if (!isset($this->deferred[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->deferred[$idx] = $val;
        return $val;
      }
      return $this->deferred[$idx];
    }
    public function getDeferred($idx) {
      if (isset($this->deferred[$idx])) {
        return $this->deferred[$idx];
      }
      if ($idx >= end(array_keys($this->deferred))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addDeferred() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->deferred[] = $val;
      return $val;
    }
    public function clearDeferred() {
      $this->deferred = array();
    }
    public function clear() {
      $this->clearFound();
      $this->clearMissing();
      $this->clearDeferred();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->found);
      $res += 1 * sizeof($this->found);
      foreach ($this->found as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->missing);
      $res += 1 * sizeof($this->missing);
      foreach ($this->missing as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->deferred);
      $res += 1 * sizeof($this->deferred);
      foreach ($this->deferred as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->found);
      foreach ($this->found as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->missing);
      foreach ($this->missing as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->deferred);
      foreach ($this->deferred as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addFound()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addMissing()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addDeferred()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->found as $value) {
        if (!$value->isInitialized()) return 'found';
      }
      foreach ($this->missing as $value) {
        if (!$value->isInitialized()) return 'missing';
      }
      foreach ($this->deferred as $value) {
        if (!$value->isInitialized()) return 'deferred';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getFoundList() as $v) {
        $this->addFound()->copyFrom($v);
      }
      foreach ($x->getMissingList() as $v) {
        $this->addMissing()->copyFrom($v);
      }
      foreach ($x->getDeferredList() as $v) {
        $this->addDeferred()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->found) !== sizeof($x->found)) return false;
      foreach (array_map(null, $this->found, $x->found) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->missing) !== sizeof($x->missing)) return false;
      foreach (array_map(null, $this->missing, $x->missing) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->deferred) !== sizeof($x->deferred)) return false;
      foreach (array_map(null, $this->deferred, $x->deferred) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->found as $value) {
        $res .= $prefix . "found <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->missing as $value) {
        $res .= $prefix . "missing <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->deferred as $value) {
        $res .= $prefix . "deferred <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class RunQueryRequest extends \google\net\ProtocolMessage {
    public function getReadOptions() {
      if (!isset($this->read_options)) {
        return new \google\appengine\datastore\v4\ReadOptions();
      }
      return $this->read_options;
    }
    public function mutableReadOptions() {
      if (!isset($this->read_options)) {
        $res = new \google\appengine\datastore\v4\ReadOptions();
        $this->read_options = $res;
        return $res;
      }
      return $this->read_options;
    }
    public function clearReadOptions() {
      if (isset($this->read_options)) {
        unset($this->read_options);
      }
    }
    public function hasReadOptions() {
      return isset($this->read_options);
    }
    public function getPartitionId() {
      if (!isset($this->partition_id)) {
        return new \google\appengine\datastore\v4\PartitionId();
      }
      return $this->partition_id;
    }
    public function mutablePartitionId() {
      if (!isset($this->partition_id)) {
        $res = new \google\appengine\datastore\v4\PartitionId();
        $this->partition_id = $res;
        return $res;
      }
      return $this->partition_id;
    }
    public function clearPartitionId() {
      if (isset($this->partition_id)) {
        unset($this->partition_id);
      }
    }
    public function hasPartitionId() {
      return isset($this->partition_id);
    }
    public function getQuery() {
      if (!isset($this->query)) {
        return new \google\appengine\datastore\v4\Query();
      }
      return $this->query;
    }
    public function mutableQuery() {
      if (!isset($this->query)) {
        $res = new \google\appengine\datastore\v4\Query();
        $this->query = $res;
        return $res;
      }
      return $this->query;
    }
    public function clearQuery() {
      if (isset($this->query)) {
        unset($this->query);
      }
    }
    public function hasQuery() {
      return isset($this->query);
    }
    public function getMinSafeTimeSeconds() {
      if (!isset($this->min_safe_time_seconds)) {
        return "0";
      }
      return $this->min_safe_time_seconds;
    }
    public function setMinSafeTimeSeconds($val) {
      if (is_double($val)) {
        $this->min_safe_time_seconds = sprintf('%0.0F', $val);
      } else {
        $this->min_safe_time_seconds = $val;
      }
      return $this;
    }
    public function clearMinSafeTimeSeconds() {
      unset($this->min_safe_time_seconds);
      return $this;
    }
    public function hasMinSafeTimeSeconds() {
      return isset($this->min_safe_time_seconds);
    }
    public function getSuggestedBatchSize() {
      if (!isset($this->suggested_batch_size)) {
        return 0;
      }
      return $this->suggested_batch_size;
    }
    public function setSuggestedBatchSize($val) {
      $this->suggested_batch_size = $val;
      return $this;
    }
    public function clearSuggestedBatchSize() {
      unset($this->suggested_batch_size);
      return $this;
    }
    public function hasSuggestedBatchSize() {
      return isset($this->suggested_batch_size);
    }
    public function getGqlQuery() {
      if (!isset($this->gql_query)) {
        return new \google\appengine\datastore\v4\GqlQuery();
      }
      return $this->gql_query;
    }
    public function mutableGqlQuery() {
      if (!isset($this->gql_query)) {
        $res = new \google\appengine\datastore\v4\GqlQuery();
        $this->gql_query = $res;
        return $res;
      }
      return $this->gql_query;
    }
    public function clearGqlQuery() {
      if (isset($this->gql_query)) {
        unset($this->gql_query);
      }
    }
    public function hasGqlQuery() {
      return isset($this->gql_query);
    }
    public function clear() {
      $this->clearReadOptions();
      $this->clearPartitionId();
      $this->clearQuery();
      $this->clearMinSafeTimeSeconds();
      $this->clearSuggestedBatchSize();
      $this->clearGqlQuery();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->read_options)) {
        $res += 1;
        $res += $this->lengthString($this->read_options->byteSizePartial());
      }
      if (isset($this->partition_id)) {
        $res += 1;
        $res += $this->lengthString($this->partition_id->byteSizePartial());
      }
      if (isset($this->query)) {
        $res += 1;
        $res += $this->lengthString($this->query->byteSizePartial());
      }
      if (isset($this->min_safe_time_seconds)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->min_safe_time_seconds);
      }
      if (isset($this->suggested_batch_size)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->suggested_batch_size);
      }
      if (isset($this->gql_query)) {
        $res += 1;
        $res += $this->lengthString($this->gql_query->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->read_options)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->read_options->byteSizePartial());
        $this->read_options->outputPartial($out);
      }
      if (isset($this->partition_id)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->partition_id->byteSizePartial());
        $this->partition_id->outputPartial($out);
      }
      if (isset($this->query)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->query->byteSizePartial());
        $this->query->outputPartial($out);
      }
      if (isset($this->min_safe_time_seconds)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->min_safe_time_seconds);
      }
      if (isset($this->suggested_batch_size)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->suggested_batch_size);
      }
      if (isset($this->gql_query)) {
        $out->putVarInt32(58);
        $out->putVarInt32($this->gql_query->byteSizePartial());
        $this->gql_query->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableReadOptions()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePartitionId()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableQuery()->tryMerge($tmp);
            break;
          case 32:
            $this->setMinSafeTimeSeconds($d->getVarInt64());
            break;
          case 40:
            $this->setSuggestedBatchSize($d->getVarInt32());
            break;
          case 58:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableGqlQuery()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->read_options) && (!$this->read_options->isInitialized())) return 'read_options';
      if (isset($this->partition_id) && (!$this->partition_id->isInitialized())) return 'partition_id';
      if (isset($this->query) && (!$this->query->isInitialized())) return 'query';
      if (isset($this->gql_query) && (!$this->gql_query->isInitialized())) return 'gql_query';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasReadOptions()) {
        $this->mutableReadOptions()->mergeFrom($x->getReadOptions());
      }
      if ($x->hasPartitionId()) {
        $this->mutablePartitionId()->mergeFrom($x->getPartitionId());
      }
      if ($x->hasQuery()) {
        $this->mutableQuery()->mergeFrom($x->getQuery());
      }
      if ($x->hasMinSafeTimeSeconds()) {
        $this->setMinSafeTimeSeconds($x->getMinSafeTimeSeconds());
      }
      if ($x->hasSuggestedBatchSize()) {
        $this->setSuggestedBatchSize($x->getSuggestedBatchSize());
      }
      if ($x->hasGqlQuery()) {
        $this->mutableGqlQuery()->mergeFrom($x->getGqlQuery());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->read_options) !== isset($x->read_options)) return false;
      if (isset($this->read_options) && !$this->read_options->equals($x->read_options)) return false;
      if (isset($this->partition_id) !== isset($x->partition_id)) return false;
      if (isset($this->partition_id) && !$this->partition_id->equals($x->partition_id)) return false;
      if (isset($this->query) !== isset($x->query)) return false;
      if (isset($this->query) && !$this->query->equals($x->query)) return false;
      if (isset($this->min_safe_time_seconds) !== isset($x->min_safe_time_seconds)) return false;
      if (isset($this->min_safe_time_seconds) && !$this->integerEquals($this->min_safe_time_seconds, $x->min_safe_time_seconds)) return false;
      if (isset($this->suggested_batch_size) !== isset($x->suggested_batch_size)) return false;
      if (isset($this->suggested_batch_size) && !$this->integerEquals($this->suggested_batch_size, $x->suggested_batch_size)) return false;
      if (isset($this->gql_query) !== isset($x->gql_query)) return false;
      if (isset($this->gql_query) && !$this->gql_query->equals($x->gql_query)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->read_options)) {
        $res .= $prefix . "read_options <\n" . $this->read_options->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->partition_id)) {
        $res .= $prefix . "partition_id <\n" . $this->partition_id->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->query)) {
        $res .= $prefix . "query <\n" . $this->query->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->min_safe_time_seconds)) {
        $res .= $prefix . "min_safe_time_seconds: " . $this->debugFormatInt64($this->min_safe_time_seconds) . "\n";
      }
      if (isset($this->suggested_batch_size)) {
        $res .= $prefix . "suggested_batch_size: " . $this->debugFormatInt32($this->suggested_batch_size) . "\n";
      }
      if (isset($this->gql_query)) {
        $res .= $prefix . "gql_query <\n" . $this->gql_query->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class RunQueryResponse extends \google\net\ProtocolMessage {
    public function getBatch() {
      if (!isset($this->batch)) {
        return new \google\appengine\datastore\v4\QueryResultBatch();
      }
      return $this->batch;
    }
    public function mutableBatch() {
      if (!isset($this->batch)) {
        $res = new \google\appengine\datastore\v4\QueryResultBatch();
        $this->batch = $res;
        return $res;
      }
      return $this->batch;
    }
    public function clearBatch() {
      if (isset($this->batch)) {
        unset($this->batch);
      }
    }
    public function hasBatch() {
      return isset($this->batch);
    }
    public function getQueryHandle() {
      if (!isset($this->query_handle)) {
        return '';
      }
      return $this->query_handle;
    }
    public function setQueryHandle($val) {
      $this->query_handle = $val;
      return $this;
    }
    public function clearQueryHandle() {
      unset($this->query_handle);
      return $this;
    }
    public function hasQueryHandle() {
      return isset($this->query_handle);
    }
    public function clear() {
      $this->clearBatch();
      $this->clearQueryHandle();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->batch)) {
        $res += 1;
        $res += $this->lengthString($this->batch->byteSizePartial());
      }
      if (isset($this->query_handle)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->query_handle));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->batch)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->batch->byteSizePartial());
        $this->batch->outputPartial($out);
      }
      if (isset($this->query_handle)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->query_handle);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableBatch()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueryHandle(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->batch)) || (!$this->batch->isInitialized())) return 'batch';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBatch()) {
        $this->mutableBatch()->mergeFrom($x->getBatch());
      }
      if ($x->hasQueryHandle()) {
        $this->setQueryHandle($x->getQueryHandle());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->batch) !== isset($x->batch)) return false;
      if (isset($this->batch) && !$this->batch->equals($x->batch)) return false;
      if (isset($this->query_handle) !== isset($x->query_handle)) return false;
      if (isset($this->query_handle) && $this->query_handle !== $x->query_handle) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->batch)) {
        $res .= $prefix . "batch <\n" . $this->batch->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->query_handle)) {
        $res .= $prefix . "query_handle: " . $this->debugFormatString($this->query_handle) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class ContinueQueryRequest extends \google\net\ProtocolMessage {
    public function getQueryHandle() {
      if (!isset($this->query_handle)) {
        return '';
      }
      return $this->query_handle;
    }
    public function setQueryHandle($val) {
      $this->query_handle = $val;
      return $this;
    }
    public function clearQueryHandle() {
      unset($this->query_handle);
      return $this;
    }
    public function hasQueryHandle() {
      return isset($this->query_handle);
    }
    public function clear() {
      $this->clearQueryHandle();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->query_handle)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->query_handle));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->query_handle)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->query_handle);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setQueryHandle(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->query_handle)) return 'query_handle';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueryHandle()) {
        $this->setQueryHandle($x->getQueryHandle());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->query_handle) !== isset($x->query_handle)) return false;
      if (isset($this->query_handle) && $this->query_handle !== $x->query_handle) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->query_handle)) {
        $res .= $prefix . "query_handle: " . $this->debugFormatString($this->query_handle) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class ContinueQueryResponse extends \google\net\ProtocolMessage {
    public function getBatch() {
      if (!isset($this->batch)) {
        return new \google\appengine\datastore\v4\QueryResultBatch();
      }
      return $this->batch;
    }
    public function mutableBatch() {
      if (!isset($this->batch)) {
        $res = new \google\appengine\datastore\v4\QueryResultBatch();
        $this->batch = $res;
        return $res;
      }
      return $this->batch;
    }
    public function clearBatch() {
      if (isset($this->batch)) {
        unset($this->batch);
      }
    }
    public function hasBatch() {
      return isset($this->batch);
    }
    public function clear() {
      $this->clearBatch();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->batch)) {
        $res += 1;
        $res += $this->lengthString($this->batch->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->batch)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->batch->byteSizePartial());
        $this->batch->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableBatch()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->batch)) || (!$this->batch->isInitialized())) return 'batch';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBatch()) {
        $this->mutableBatch()->mergeFrom($x->getBatch());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->batch) !== isset($x->batch)) return false;
      if (isset($this->batch) && !$this->batch->equals($x->batch)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->batch)) {
        $res .= $prefix . "batch <\n" . $this->batch->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class BeginTransactionRequest extends \google\net\ProtocolMessage {
    public function getCrossGroup() {
      if (!isset($this->cross_group)) {
        return false;
      }
      return $this->cross_group;
    }
    public function setCrossGroup($val) {
      $this->cross_group = $val;
      return $this;
    }
    public function clearCrossGroup() {
      unset($this->cross_group);
      return $this;
    }
    public function hasCrossGroup() {
      return isset($this->cross_group);
    }
    public function getCrossRequest() {
      if (!isset($this->cross_request)) {
        return false;
      }
      return $this->cross_request;
    }
    public function setCrossRequest($val) {
      $this->cross_request = $val;
      return $this;
    }
    public function clearCrossRequest() {
      unset($this->cross_request);
      return $this;
    }
    public function hasCrossRequest() {
      return isset($this->cross_request);
    }
    public function clear() {
      $this->clearCrossGroup();
      $this->clearCrossRequest();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cross_group)) {
        $res += 2;
      }
      if (isset($this->cross_request)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cross_group)) {
        $out->putVarInt32(8);
        $out->putBoolean($this->cross_group);
      }
      if (isset($this->cross_request)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->cross_request);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setCrossGroup($d->getBoolean());
            break;
          case 16:
            $this->setCrossRequest($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCrossGroup()) {
        $this->setCrossGroup($x->getCrossGroup());
      }
      if ($x->hasCrossRequest()) {
        $this->setCrossRequest($x->getCrossRequest());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cross_group) !== isset($x->cross_group)) return false;
      if (isset($this->cross_group) && $this->cross_group !== $x->cross_group) return false;
      if (isset($this->cross_request) !== isset($x->cross_request)) return false;
      if (isset($this->cross_request) && $this->cross_request !== $x->cross_request) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cross_group)) {
        $res .= $prefix . "cross_group: " . $this->debugFormatBool($this->cross_group) . "\n";
      }
      if (isset($this->cross_request)) {
        $res .= $prefix . "cross_request: " . $this->debugFormatBool($this->cross_request) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class BeginTransactionResponse extends \google\net\ProtocolMessage {
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return '';
      }
      return $this->transaction;
    }
    public function setTransaction($val) {
      $this->transaction = $val;
      return $this;
    }
    public function clearTransaction() {
      unset($this->transaction);
      return $this;
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function clear() {
      $this->clearTransaction();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->transaction));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->transaction)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->transaction);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setTransaction(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->transaction)) return 'transaction';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTransaction()) {
        $this->setTransaction($x->getTransaction());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && $this->transaction !== $x->transaction) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction: " . $this->debugFormatString($this->transaction) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class RollbackRequest extends \google\net\ProtocolMessage {
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return '';
      }
      return $this->transaction;
    }
    public function setTransaction($val) {
      $this->transaction = $val;
      return $this;
    }
    public function clearTransaction() {
      unset($this->transaction);
      return $this;
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function clear() {
      $this->clearTransaction();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->transaction));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->transaction)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->transaction);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setTransaction(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->transaction)) return 'transaction';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTransaction()) {
        $this->setTransaction($x->getTransaction());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && $this->transaction !== $x->transaction) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction: " . $this->debugFormatString($this->transaction) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class RollbackResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\CommitRequest {
  class Mode {
    const TRANSACTIONAL = 1;
    const NON_TRANSACTIONAL = 2;
  }
}
namespace google\appengine\datastore\v4 {
  class CommitRequest extends \google\net\ProtocolMessage {
    private $mutation = array();
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return '';
      }
      return $this->transaction;
    }
    public function setTransaction($val) {
      $this->transaction = $val;
      return $this;
    }
    public function clearTransaction() {
      unset($this->transaction);
      return $this;
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getDeprecatedMutation() {
      if (!isset($this->deprecated_mutation)) {
        return new \google\appengine\datastore\v4\DeprecatedMutation();
      }
      return $this->deprecated_mutation;
    }
    public function mutableDeprecatedMutation() {
      if (!isset($this->deprecated_mutation)) {
        $res = new \google\appengine\datastore\v4\DeprecatedMutation();
        $this->deprecated_mutation = $res;
        return $res;
      }
      return $this->deprecated_mutation;
    }
    public function clearDeprecatedMutation() {
      if (isset($this->deprecated_mutation)) {
        unset($this->deprecated_mutation);
      }
    }
    public function hasDeprecatedMutation() {
      return isset($this->deprecated_mutation);
    }
    public function getMode() {
      if (!isset($this->mode)) {
        return 1;
      }
      return $this->mode;
    }
    public function setMode($val) {
      $this->mode = $val;
      return $this;
    }
    public function clearMode() {
      unset($this->mode);
      return $this;
    }
    public function hasMode() {
      return isset($this->mode);
    }
    public function getMutationSize() {
      return sizeof($this->mutation);
    }
    public function getMutationList() {
      return $this->mutation;
    }
    public function mutableMutation($idx) {
      if (!isset($this->mutation[$idx])) {
        $val = new \google\appengine\datastore\v4\Mutation();
        $this->mutation[$idx] = $val;
        return $val;
      }
      return $this->mutation[$idx];
    }
    public function getMutation($idx) {
      if (isset($this->mutation[$idx])) {
        return $this->mutation[$idx];
      }
      if ($idx >= end(array_keys($this->mutation))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Mutation();
    }
    public function addMutation() {
      $val = new \google\appengine\datastore\v4\Mutation();
      $this->mutation[] = $val;
      return $val;
    }
    public function clearMutation() {
      $this->mutation = array();
    }
    public function getIgnoreReadOnly() {
      if (!isset($this->ignore_read_only)) {
        return false;
      }
      return $this->ignore_read_only;
    }
    public function setIgnoreReadOnly($val) {
      $this->ignore_read_only = $val;
      return $this;
    }
    public function clearIgnoreReadOnly() {
      unset($this->ignore_read_only);
      return $this;
    }
    public function hasIgnoreReadOnly() {
      return isset($this->ignore_read_only);
    }
    public function clear() {
      $this->clearTransaction();
      $this->clearDeprecatedMutation();
      $this->clearMode();
      $this->clearMutation();
      $this->clearIgnoreReadOnly();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->transaction));
      }
      if (isset($this->deprecated_mutation)) {
        $res += 1;
        $res += $this->lengthString($this->deprecated_mutation->byteSizePartial());
      }
      if (isset($this->mode)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mode);
      }
      $this->checkProtoArray($this->mutation);
      $res += 1 * sizeof($this->mutation);
      foreach ($this->mutation as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->ignore_read_only)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->transaction)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->transaction);
      }
      if (isset($this->deprecated_mutation)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->deprecated_mutation->byteSizePartial());
        $this->deprecated_mutation->outputPartial($out);
      }
      if (isset($this->mode)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->mode);
      }
      $this->checkProtoArray($this->mutation);
      foreach ($this->mutation as $value) {
        $out->putVarInt32(42);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->ignore_read_only)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->ignore_read_only);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setTransaction(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableDeprecatedMutation()->tryMerge($tmp);
            break;
          case 32:
            $this->setMode($d->getVarInt32());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addMutation()->tryMerge($tmp);
            break;
          case 48:
            $this->setIgnoreReadOnly($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->deprecated_mutation) && (!$this->deprecated_mutation->isInitialized())) return 'deprecated_mutation';
      foreach ($this->mutation as $value) {
        if (!$value->isInitialized()) return 'mutation';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTransaction()) {
        $this->setTransaction($x->getTransaction());
      }
      if ($x->hasDeprecatedMutation()) {
        $this->mutableDeprecatedMutation()->mergeFrom($x->getDeprecatedMutation());
      }
      if ($x->hasMode()) {
        $this->setMode($x->getMode());
      }
      foreach ($x->getMutationList() as $v) {
        $this->addMutation()->copyFrom($v);
      }
      if ($x->hasIgnoreReadOnly()) {
        $this->setIgnoreReadOnly($x->getIgnoreReadOnly());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && $this->transaction !== $x->transaction) return false;
      if (isset($this->deprecated_mutation) !== isset($x->deprecated_mutation)) return false;
      if (isset($this->deprecated_mutation) && !$this->deprecated_mutation->equals($x->deprecated_mutation)) return false;
      if (isset($this->mode) !== isset($x->mode)) return false;
      if (isset($this->mode) && $this->mode !== $x->mode) return false;
      if (sizeof($this->mutation) !== sizeof($x->mutation)) return false;
      foreach (array_map(null, $this->mutation, $x->mutation) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->ignore_read_only) !== isset($x->ignore_read_only)) return false;
      if (isset($this->ignore_read_only) && $this->ignore_read_only !== $x->ignore_read_only) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction: " . $this->debugFormatString($this->transaction) . "\n";
      }
      if (isset($this->deprecated_mutation)) {
        $res .= $prefix . "deprecated_mutation <\n" . $this->deprecated_mutation->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->mode)) {
        $res .= $prefix . "mode: " . ($this->mode) . "\n";
      }
      foreach ($this->mutation as $value) {
        $res .= $prefix . "mutation <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->ignore_read_only)) {
        $res .= $prefix . "ignore_read_only: " . $this->debugFormatBool($this->ignore_read_only) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class CommitResponse extends \google\net\ProtocolMessage {
    private $mutation_result = array();
    public function getDeprecatedMutationResult() {
      if (!isset($this->deprecated_mutation_result)) {
        return new \google\appengine\datastore\v4\DeprecatedMutationResult();
      }
      return $this->deprecated_mutation_result;
    }
    public function mutableDeprecatedMutationResult() {
      if (!isset($this->deprecated_mutation_result)) {
        $res = new \google\appengine\datastore\v4\DeprecatedMutationResult();
        $this->deprecated_mutation_result = $res;
        return $res;
      }
      return $this->deprecated_mutation_result;
    }
    public function clearDeprecatedMutationResult() {
      if (isset($this->deprecated_mutation_result)) {
        unset($this->deprecated_mutation_result);
      }
    }
    public function hasDeprecatedMutationResult() {
      return isset($this->deprecated_mutation_result);
    }
    public function getMutationResultSize() {
      return sizeof($this->mutation_result);
    }
    public function getMutationResultList() {
      return $this->mutation_result;
    }
    public function mutableMutationResult($idx) {
      if (!isset($this->mutation_result[$idx])) {
        $val = new \google\appengine\datastore\v4\MutationResult();
        $this->mutation_result[$idx] = $val;
        return $val;
      }
      return $this->mutation_result[$idx];
    }
    public function getMutationResult($idx) {
      if (isset($this->mutation_result[$idx])) {
        return $this->mutation_result[$idx];
      }
      if ($idx >= end(array_keys($this->mutation_result))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\MutationResult();
    }
    public function addMutationResult() {
      $val = new \google\appengine\datastore\v4\MutationResult();
      $this->mutation_result[] = $val;
      return $val;
    }
    public function clearMutationResult() {
      $this->mutation_result = array();
    }
    public function getIndexUpdates() {
      if (!isset($this->index_updates)) {
        return 0;
      }
      return $this->index_updates;
    }
    public function setIndexUpdates($val) {
      $this->index_updates = $val;
      return $this;
    }
    public function clearIndexUpdates() {
      unset($this->index_updates);
      return $this;
    }
    public function hasIndexUpdates() {
      return isset($this->index_updates);
    }
    public function clear() {
      $this->clearDeprecatedMutationResult();
      $this->clearMutationResult();
      $this->clearIndexUpdates();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->deprecated_mutation_result)) {
        $res += 1;
        $res += $this->lengthString($this->deprecated_mutation_result->byteSizePartial());
      }
      $this->checkProtoArray($this->mutation_result);
      $res += 1 * sizeof($this->mutation_result);
      foreach ($this->mutation_result as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->index_updates)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_updates);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->deprecated_mutation_result)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->deprecated_mutation_result->byteSizePartial());
        $this->deprecated_mutation_result->outputPartial($out);
      }
      $this->checkProtoArray($this->mutation_result);
      foreach ($this->mutation_result as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->index_updates)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->index_updates);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableDeprecatedMutationResult()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addMutationResult()->tryMerge($tmp);
            break;
          case 32:
            $this->setIndexUpdates($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->deprecated_mutation_result) && (!$this->deprecated_mutation_result->isInitialized())) return 'deprecated_mutation_result';
      foreach ($this->mutation_result as $value) {
        if (!$value->isInitialized()) return 'mutation_result';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasDeprecatedMutationResult()) {
        $this->mutableDeprecatedMutationResult()->mergeFrom($x->getDeprecatedMutationResult());
      }
      foreach ($x->getMutationResultList() as $v) {
        $this->addMutationResult()->copyFrom($v);
      }
      if ($x->hasIndexUpdates()) {
        $this->setIndexUpdates($x->getIndexUpdates());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->deprecated_mutation_result) !== isset($x->deprecated_mutation_result)) return false;
      if (isset($this->deprecated_mutation_result) && !$this->deprecated_mutation_result->equals($x->deprecated_mutation_result)) return false;
      if (sizeof($this->mutation_result) !== sizeof($x->mutation_result)) return false;
      foreach (array_map(null, $this->mutation_result, $x->mutation_result) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->index_updates) !== isset($x->index_updates)) return false;
      if (isset($this->index_updates) && !$this->integerEquals($this->index_updates, $x->index_updates)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->deprecated_mutation_result)) {
        $res .= $prefix . "deprecated_mutation_result <\n" . $this->deprecated_mutation_result->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->mutation_result as $value) {
        $res .= $prefix . "mutation_result <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->index_updates)) {
        $res .= $prefix . "index_updates: " . $this->debugFormatInt32($this->index_updates) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class AllocateIdsRequest extends \google\net\ProtocolMessage {
    private $allocate = array();
    private $reserve = array();
    public function getAllocateSize() {
      return sizeof($this->allocate);
    }
    public function getAllocateList() {
      return $this->allocate;
    }
    public function mutableAllocate($idx) {
      if (!isset($this->allocate[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->allocate[$idx] = $val;
        return $val;
      }
      return $this->allocate[$idx];
    }
    public function getAllocate($idx) {
      if (isset($this->allocate[$idx])) {
        return $this->allocate[$idx];
      }
      if ($idx >= end(array_keys($this->allocate))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addAllocate() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->allocate[] = $val;
      return $val;
    }
    public function clearAllocate() {
      $this->allocate = array();
    }
    public function getReserveSize() {
      return sizeof($this->reserve);
    }
    public function getReserveList() {
      return $this->reserve;
    }
    public function mutableReserve($idx) {
      if (!isset($this->reserve[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->reserve[$idx] = $val;
        return $val;
      }
      return $this->reserve[$idx];
    }
    public function getReserve($idx) {
      if (isset($this->reserve[$idx])) {
        return $this->reserve[$idx];
      }
      if ($idx >= end(array_keys($this->reserve))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addReserve() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->reserve[] = $val;
      return $val;
    }
    public function clearReserve() {
      $this->reserve = array();
    }
    public function clear() {
      $this->clearAllocate();
      $this->clearReserve();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->allocate);
      $res += 1 * sizeof($this->allocate);
      foreach ($this->allocate as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->reserve);
      $res += 1 * sizeof($this->reserve);
      foreach ($this->reserve as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->allocate);
      foreach ($this->allocate as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->reserve);
      foreach ($this->reserve as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addAllocate()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addReserve()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->allocate as $value) {
        if (!$value->isInitialized()) return 'allocate';
      }
      foreach ($this->reserve as $value) {
        if (!$value->isInitialized()) return 'reserve';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getAllocateList() as $v) {
        $this->addAllocate()->copyFrom($v);
      }
      foreach ($x->getReserveList() as $v) {
        $this->addReserve()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->allocate) !== sizeof($x->allocate)) return false;
      foreach (array_map(null, $this->allocate, $x->allocate) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->reserve) !== sizeof($x->reserve)) return false;
      foreach (array_map(null, $this->reserve, $x->reserve) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->allocate as $value) {
        $res .= $prefix . "allocate <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->reserve as $value) {
        $res .= $prefix . "reserve <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class AllocateIdsResponse extends \google\net\ProtocolMessage {
    private $allocated = array();
    public function getAllocatedSize() {
      return sizeof($this->allocated);
    }
    public function getAllocatedList() {
      return $this->allocated;
    }
    public function mutableAllocated($idx) {
      if (!isset($this->allocated[$idx])) {
        $val = new \google\appengine\datastore\v4\Key();
        $this->allocated[$idx] = $val;
        return $val;
      }
      return $this->allocated[$idx];
    }
    public function getAllocated($idx) {
      if (isset($this->allocated[$idx])) {
        return $this->allocated[$idx];
      }
      if ($idx >= end(array_keys($this->allocated))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key();
    }
    public function addAllocated() {
      $val = new \google\appengine\datastore\v4\Key();
      $this->allocated[] = $val;
      return $val;
    }
    public function clearAllocated() {
      $this->allocated = array();
    }
    public function clear() {
      $this->clearAllocated();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->allocated);
      $res += 1 * sizeof($this->allocated);
      foreach ($this->allocated as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->allocated);
      foreach ($this->allocated as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addAllocated()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->allocated as $value) {
        if (!$value->isInitialized()) return 'allocated';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getAllocatedList() as $v) {
        $this->addAllocated()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->allocated) !== sizeof($x->allocated)) return false;
      foreach (array_map(null, $this->allocated, $x->allocated) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->allocated as $value) {
        $res .= $prefix . "allocated <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class WriteRequest extends \google\net\ProtocolMessage {
    public function getDeprecatedMutation() {
      if (!isset($this->deprecated_mutation)) {
        return new \google\appengine\datastore\v4\DeprecatedMutation();
      }
      return $this->deprecated_mutation;
    }
    public function mutableDeprecatedMutation() {
      if (!isset($this->deprecated_mutation)) {
        $res = new \google\appengine\datastore\v4\DeprecatedMutation();
        $this->deprecated_mutation = $res;
        return $res;
      }
      return $this->deprecated_mutation;
    }
    public function clearDeprecatedMutation() {
      if (isset($this->deprecated_mutation)) {
        unset($this->deprecated_mutation);
      }
    }
    public function hasDeprecatedMutation() {
      return isset($this->deprecated_mutation);
    }
    public function clear() {
      $this->clearDeprecatedMutation();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->deprecated_mutation)) {
        $res += 1;
        $res += $this->lengthString($this->deprecated_mutation->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->deprecated_mutation)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->deprecated_mutation->byteSizePartial());
        $this->deprecated_mutation->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableDeprecatedMutation()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->deprecated_mutation)) || (!$this->deprecated_mutation->isInitialized())) return 'deprecated_mutation';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasDeprecatedMutation()) {
        $this->mutableDeprecatedMutation()->mergeFrom($x->getDeprecatedMutation());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->deprecated_mutation) !== isset($x->deprecated_mutation)) return false;
      if (isset($this->deprecated_mutation) && !$this->deprecated_mutation->equals($x->deprecated_mutation)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->deprecated_mutation)) {
        $res .= $prefix . "deprecated_mutation <\n" . $this->deprecated_mutation->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
