/*******************************************************************************
* Copyright 1999-2021 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL) interface for LAPACK routines
!******************************************************************************/

#ifndef _MKL_LAPACK_H_
#define _MKL_LAPACK_H_

#include "mkl_types.h"

#ifdef __cplusplus
extern "C" {
#if __cplusplus > 199711L
#define NOTHROW noexcept
#else
#define NOTHROW throw()
#endif
#else
#define NOTHROW
#endif /* __cplusplus */

/* LAPACK specific types */

typedef MKL_INT (*MKL_C_SELECT_FUNCTION_1) ( const MKL_Complex8* );
typedef MKL_INT (*MKL_C_SELECT_FUNCTION_2) ( const MKL_Complex8*, const MKL_Complex8* );
typedef MKL_INT (*MKL_D_SELECT_FUNCTION_2) ( const double*, const double* );
typedef MKL_INT (*MKL_D_SELECT_FUNCTION_3) ( const double*, const double*, const double* );
typedef MKL_INT (*MKL_S_SELECT_FUNCTION_2) ( const float*, const float* );
typedef MKL_INT (*MKL_S_SELECT_FUNCTION_3) ( const float*, const float*, const float* );
typedef MKL_INT (*MKL_Z_SELECT_FUNCTION_1) ( const MKL_Complex16* );
typedef MKL_INT (*MKL_Z_SELECT_FUNCTION_2) ( const MKL_Complex16*, const MKL_Complex16* );

#if defined(_WIN32) && defined(MKL_STDCALL) && !defined(__MIC__) && !defined(__TARGET_ARCH_MIC)
#include "mkl_lapack_stdcall.h"
#else

void CGESVDQ( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void CGESVDQ_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void cgesvdq( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void cgesvdq_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex8* cwork, MKL_INT* lcwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void DGESVDQ( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void DGESVDQ_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void dgesvdq( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void dgesvdq_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, double* work, MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void SGESVDQ( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void SGESVDQ_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void sgesvdq( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void sgesvdq_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* s, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, float* work, MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void ZGESVDQ( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void ZGESVDQ_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void zgesvdq( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void zgesvdq_( const char* joba, const char* jobp, const char* jobr, const char* jobu, const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_INT* numrank, MKL_INT* iwork, const MKL_INT* liwork, MKL_Complex16* cwork, MKL_INT* lcwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void CLAUNHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void CLAUNHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void claunhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void claunhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );

void CLAUNHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void CLAUNHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void claunhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );
void claunhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, MKL_INT* info );

void DLAORHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void DLAORHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void dlaorhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void dlaorhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );

void DLAORHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void DLAORHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void dlaorhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );
void dlaorhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda, double* d, MKL_INT* info );

void SLAORHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void SLAORHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void slaorhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void slaorhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );

void SLAORHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void SLAORHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void slaorhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );
void slaorhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, float* d, MKL_INT* info );

void ZLAUNHR_COL_GETRFNP2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void ZLAUNHR_COL_GETRFNP2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void zlaunhr_col_getrfnp2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void zlaunhr_col_getrfnp2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );

void ZLAUNHR_COL_GETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void ZLAUNHR_COL_GETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void zlaunhr_col_getrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );
void zlaunhr_col_getrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, MKL_INT* info );

void CUNGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );
void CUNHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );
void cunhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );
void cunhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* d, MKL_INT* info );

void DORGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );
void DORGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );
void dorgtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );
void dorgtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, double* a, const MKL_INT* lda, const double* t, const MKL_INT* ldt, double* work, const MKL_INT* lwork, MKL_INT* info );

void DORHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );
void DORHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );
void dorhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );
void dorhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a, const MKL_INT* lda, double* t, const MKL_INT* ldt, double* d, MKL_INT* info );

void SORGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );
void SORGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );
void sorgtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );
void sorgtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t, const MKL_INT* ldt, float* work, const MKL_INT* lwork, MKL_INT* info );

void SORHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );
void SORHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );
void sorhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );
void sorhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, float* a, const MKL_INT* lda, float* t, const MKL_INT* ldt, float* d, MKL_INT* info );

void ZUNGTSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZUNGTSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zungtsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zungtsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZUNHR_COL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );
void ZUNHR_COL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );
void zunhr_col( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );
void zunhr_col_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* d, MKL_INT* info );

void CGELQ( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGELQ_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgelq( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgelq_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGELQT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void CGELQT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;
void cgelqt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void cgelqt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;

void CGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex8* v, const MKL_INT* ldv, const MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex8* v, const MKL_INT* ldv, const MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGEQR( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEQR_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqr( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqr_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void CLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void clamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void clamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void CLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void CLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void clamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void clamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void CLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void claswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void claswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void clatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void clatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void ctplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void ctplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void CTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;
void ctplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void ctplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;

void CTPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CTPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void ctpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void ctpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DGELQ( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGELQ_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelq( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelq_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
             const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info ) NOTHROW;
void DGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info ) NOTHROW;
void dgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
             const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info ) NOTHROW;
void dgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info ) NOTHROW;

void DGELQT3( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void DGELQT3_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;
void dgelqt3( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void dgelqt3_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;

void DGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* lda,
             const double* t, const MKL_INT* tsize, double* c,
             const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void DGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* lda,
             const double* t, const MKL_INT* tsize, double* c,
             const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void dgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const double* v, const MKL_INT* ldv, const double* t,
              const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
              MKL_INT* info ) NOTHROW;
void DGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const double* v, const MKL_INT* ldv, const double* t,
               const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
               MKL_INT* info ) NOTHROW;
void dgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const double* v, const MKL_INT* ldv, const double* t,
              const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
              MKL_INT* info ) NOTHROW;
void dgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const double* v, const MKL_INT* ldv, const double* t,
               const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
               MKL_INT* info ) NOTHROW;

void DGEQR( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEQR_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqr( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqr_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void DLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void dlamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dlamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void DLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void DLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void dlamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dlamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void DLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void DLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dlaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dlaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void DLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void DLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dlatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dlatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void DTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info ) NOTHROW;
void DTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info ) NOTHROW;
void dtplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info ) NOTHROW;
void dtplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info ) NOTHROW;

void DTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
              const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void DTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
               const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void dtplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
              const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void dtplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
               const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void DTPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
              MKL_INT* info ) NOTHROW;
void DTPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
               MKL_INT* info ) NOTHROW;
void dtpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
              MKL_INT* info ) NOTHROW;
void dtpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
               MKL_INT* info ) NOTHROW;

void SGELQ( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SGELQ_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgelq( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgelq_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void DGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void SGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
             const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info ) NOTHROW;
void SGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
              const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info ) NOTHROW;
void sgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
             const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info ) NOTHROW;
void sgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
              const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info ) NOTHROW;

void SGELQT3( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void SGELQT3_( const MKL_INT* m, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;
void sgelqt3( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void sgelqt3_( const MKL_INT* m, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;

void SGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info ) NOTHROW;
void SGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info ) NOTHROW;
void sgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info ) NOTHROW;
void sgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info ) NOTHROW;

void SGEQR( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SGEQR_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgeqr( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgeqr_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void SGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void sgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void sgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void SLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void slamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void slamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void SLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void SLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void slaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void slaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void STPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
             const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info ) NOTHROW;
void STPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info ) NOTHROW;
void stplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
             const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info ) NOTHROW;
void stplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info ) NOTHROW;

void STPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* work, MKL_INT* info ) NOTHROW;
void STPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* work,
               MKL_INT* info ) NOTHROW;
void stpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* work, MKL_INT* info ) NOTHROW;
void stpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* work,
               MKL_INT* info ) NOTHROW;

void ZGELQ( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGELQ_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgelq( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgelq_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
             const float* t, const MKL_INT* tsize, float* c,
             const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void SGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
              const float* t, const MKL_INT* tsize, float* c,
              const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void sgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
             const float* t, const MKL_INT* tsize, float* c,
             const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void sgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
              const float* t, const MKL_INT* tsize, float* c,
              const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void SLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void slamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void slamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void SLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void SLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void slatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void slatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void STPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
              const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void STPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
               const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void stplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
              const MKL_INT* ldt, MKL_INT* info ) NOTHROW;
void stplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
               const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ZGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZGELQT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void ZGELQT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;
void zgelqt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void zgelqt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;

void ZGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZGEQR( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGEQR_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgeqr( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgeqr_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void ZLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void zlamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void zlamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void ZLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void ZLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void zlamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void zlamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void ZLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zlaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zlaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zlatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zlatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ztplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ztplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void ZTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;
void ztplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info ) NOTHROW;
void ztplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info ) NOTHROW;

void ZTPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZTPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ztpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ztpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void CHESV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHESV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;
void chetrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;

void CLAHEF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CLAHEF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void clahef_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void clahef_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work,
                MKL_INT* info ) NOTHROW;
void DLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, double* a, const MKL_INT* lda,
                 MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work,
                 MKL_INT* info ) NOTHROW;
void dlasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work,
                MKL_INT* info ) NOTHROW;
void dlasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, double* a, const MKL_INT* lda,
                 MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work,
                 MKL_INT* info ) NOTHROW;

void DSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void DSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void dsysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dsysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void DSYTRF_AA( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRF_AA_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_aa( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_aa_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 double* b, const MKL_INT* ldb, double* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 double* b, const MKL_INT* ldb, double* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                float* h, const MKL_INT* ldh, float* work, MKL_INT* info ) NOTHROW;
void SLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, float* a, const MKL_INT* lda,
                 MKL_INT* ipiv, float* h, const MKL_INT* ldh, float* work,
                 MKL_INT* info ) NOTHROW;
void slasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                float* h, const MKL_INT* ldh, float* work, MKL_INT* info ) NOTHROW;
void slasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, float* a, const MKL_INT* lda,
                 MKL_INT* ipiv, float* h, const MKL_INT* ldh, float* work,
                 MKL_INT* info ) NOTHROW;

void SSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void SSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
                const MKL_INT* ldb, float* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void ssysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void ssysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
                const MKL_INT* ldb, float* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void SSYTRF_AA( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRF_AA_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_aa( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_aa_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 float* b, const MKL_INT* ldb, float* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 float* b, const MKL_INT* ldb, float* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHESV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHESV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhesv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhesv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void ZHETRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;
void zhetrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void zhetrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;

void ZLAHEF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZLAHEF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zlahef_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zlahef_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void CGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a,
             const MKL_INT* lda, const double* t, const MKL_INT* tsize,
             double* c, const MKL_INT* ldc, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a,
             const MKL_INT* lda, const double* t, const MKL_INT* tsize,
             double* c, const MKL_INT* ldc, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a,
             const MKL_INT* lda, const float* t, const MKL_INT* tsize,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void SGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a,
              const MKL_INT* lda, const float* t, const MKL_INT* tsize,
              float* c, const MKL_INT* ldc, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a,
             const MKL_INT* lda, const float* t, const MKL_INT* tsize,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void sgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a,
              const MKL_INT* lda, const float* t, const MKL_INT* tsize,
              float* c, const MKL_INT* ldc, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHECON_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void CHECON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info ) NOTHROW;
void checon_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void checon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info ) NOTHROW;

void CHESV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHESV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void CHETF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;
void chetf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void chetf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;

void CHETRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRI_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetri_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetri_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void CHETRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;
void chetri_3x( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void chetri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;

void CHETRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHETRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CLAHEF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void CLAHEF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clahef_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clahef_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void CLARFY( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
             const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void CLARFY_( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
              const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void clarfy( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
             const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void clarfy_( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
              const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;

void CLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void clasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void clasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void CLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void CSYCON_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void CSYCON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info ) NOTHROW;
void csycon_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void csycon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info ) NOTHROW;

void CSYCONVF( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CSYCONVF_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csyconvf( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csyconvf_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void CSYTF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;
void csytf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void csytf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;

void CSYTRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRI_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytri_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytri_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void CSYTRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;
void csytri_3x( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void csytri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;

void CSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;
void csytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;

void DLARFY( const char* uplo, const MKL_INT* n, const double* v,
             const MKL_INT* incv, const double* tau, double* c,
             const MKL_INT* ldc, double* work ) NOTHROW;
void DLARFY_( const char* uplo, const MKL_INT* n, const double* v,
              const MKL_INT* incv, const double* tau, double* c,
              const MKL_INT* ldc, double* work ) NOTHROW;
void dlarfy( const char* uplo, const MKL_INT* n, const double* v,
             const MKL_INT* incv, const double* tau, double* c,
             const MKL_INT* ldc, double* work ) NOTHROW;
void dlarfy_( const char* uplo, const MKL_INT* n, const double* v,
              const MKL_INT* incv, const double* tau, double* c,
              const MKL_INT* ldc, double* work ) NOTHROW;

void DLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void DLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                 MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void dlasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void dlasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                 MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void DSYCON_3( const char* uplo, const MKL_INT* n, const double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, double* work,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DSYCON_3_( const char* uplo, const MKL_INT* n, const double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                const double* anorm, double* rcond, double* work,
                MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dsycon_3( const char* uplo, const MKL_INT* n, const double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, double* work,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dsycon_3_( const char* uplo, const MKL_INT* n, const double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                const double* anorm, double* rcond, double* work,
                MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DSYCONVF( const char* uplo, const char* way, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DSYCONVF_( const char* uplo, const char* way, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsyconvf( const char* uplo, const char* way, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsyconvf_( const char* uplo, const char* way, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
               double* b, const MKL_INT* ldb, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
               double* b, const MKL_INT* ldb, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTF2_RK( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DSYTF2_RK_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsytf2_rk( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsytf2_rk_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DSYTRF_RK( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRF_RK_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_rk( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_rk_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRI_3( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRI_3_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytri_3( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytri_3_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRI_3X( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void DSYTRI_3X_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                 double* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void dsytri_3x( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void dsytri_3x_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                 double* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;

void DSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const double* a, const MKL_INT* lda, const double* e,
               const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
               MKL_INT* info ) NOTHROW;
void DSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const double* e,
                const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                MKL_INT* info ) NOTHROW;
void dsytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const double* a, const MKL_INT* lda, const double* e,
               const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
               MKL_INT* info ) NOTHROW;
void dsytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const double* e,
                const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                MKL_INT* info ) NOTHROW;

void SLARFY( const char* uplo, const MKL_INT* n, const float* v,
             const MKL_INT* incv, const float* tau, float* c,
             const MKL_INT* ldc, float* work ) NOTHROW;
void SLARFY_( const char* uplo, const MKL_INT* n, const float* v,
              const MKL_INT* incv, const float* tau, float* c,
              const MKL_INT* ldc, float* work ) NOTHROW;
void slarfy( const char* uplo, const MKL_INT* n, const float* v,
             const MKL_INT* incv, const float* tau, float* c,
             const MKL_INT* ldc, float* work ) NOTHROW;
void slarfy_( const char* uplo, const MKL_INT* n, const float* v,
              const MKL_INT* incv, const float* tau, float* c,
              const MKL_INT* ldc, float* work ) NOTHROW;

void SLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void SLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                 MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void slasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void slasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                 MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void SSYCON_3( const char* uplo, const MKL_INT* n, const float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, float* work, MKL_INT* iwork,
               MKL_INT* info ) NOTHROW;
void SSYCON_3_( const char* uplo, const MKL_INT* n, const float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, float* work, MKL_INT* iwork,
                MKL_INT* info ) NOTHROW;
void ssycon_3( const char* uplo, const MKL_INT* n, const float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, float* work, MKL_INT* iwork,
               MKL_INT* info ) NOTHROW;
void ssycon_3_( const char* uplo, const MKL_INT* n, const float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, float* work, MKL_INT* iwork,
                MKL_INT* info ) NOTHROW;

void SSYCONVF( const char* uplo, const char* way, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void SSYCONVF_( const char* uplo, const char* way, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssyconvf( const char* uplo, const char* way, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssyconvf_( const char* uplo, const char* way, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void SSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void SSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void SSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void SSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void ssysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTF2_RK( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void SSYTF2_RK_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssytf2_rk( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssytf2_rk_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void SSYTRF_RK( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRF_RK_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_rk( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_rk_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRI_3( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRI_3_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytri_3( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytri_3_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRI_3X( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void SSYTRI_3X_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                 float* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void ssytri_3x( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void ssytri_3x_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                 float* work, const MKL_INT* nb, MKL_INT* info ) NOTHROW;

void SSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const float* a, const MKL_INT* lda, const float* e,
               const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
               MKL_INT* info ) NOTHROW;
void SSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const float* e,
                const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                MKL_INT* info ) NOTHROW;
void ssytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const float* a, const MKL_INT* lda, const float* e,
               const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
               MKL_INT* info ) NOTHROW;
void ssytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const float* e,
                const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                MKL_INT* info ) NOTHROW;

void ZHECON_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info ) NOTHROW;
void ZHECON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zhecon_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info ) NOTHROW;
void zhecon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZHESV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHESV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhesv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhesv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void ZHETF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;
void zhetf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void zhetf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;

void ZHETRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETRI_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void zhetri_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetri_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void ZHETRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info ) NOTHROW;
void ZHETRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;
void zhetri_3x( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info ) NOTHROW;
void zhetri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;

void ZHETRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ZHETRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zhetrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zhetrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void ZLAHEF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void ZLAHEF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlahef_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlahef_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void ZLARFY( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
             const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
             const MKL_INT* ldc, MKL_Complex16* work ) NOTHROW;
void ZLARFY_( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
              const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work ) NOTHROW;
void zlarfy( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
             const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
             const MKL_INT* ldc, MKL_Complex16* work ) NOTHROW;
void zlarfy_( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
              const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work ) NOTHROW;

void ZLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zlasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zlasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void ZLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void ZSYCON_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info ) NOTHROW;
void ZSYCON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zsycon_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info ) NOTHROW;
void zsycon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZSYCONVF( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ZSYCONVF_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zsyconvf( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zsyconvf_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void ZSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ZSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zsyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                    const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zsyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                     const MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void ZSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYTF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void ZSYTF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;
void zsytf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info ) NOTHROW;
void zsytf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info ) NOTHROW;

void ZSYTRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYTRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYTRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYTRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYTRI_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYTRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void zsytri_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytri_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;

void ZSYTRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info ) NOTHROW;
void ZSYTRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;
void zsytri_3x( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info ) NOTHROW;
void zsytri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info ) NOTHROW;

void ZSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ZSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zsytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zsytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void ZSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void ZSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;
void zsytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info ) NOTHROW;
void zsytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info ) NOTHROW;

void CHB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex8* a,
                     const MKL_INT* lda, MKL_Complex8* v, MKL_Complex8* tau,
                     const MKL_INT* ldvt, MKL_Complex8* work ) NOTHROW;
void CHB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* v,
                      MKL_Complex8* tau, const MKL_INT* ldvt,
                      MKL_Complex8* work ) NOTHROW;
void chb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex8* a,
                     const MKL_INT* lda, MKL_Complex8* v, MKL_Complex8* tau,
                     const MKL_INT* ldvt, MKL_Complex8* work ) NOTHROW;
void chb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* v,
                      MKL_Complex8* tau, const MKL_INT* ldvt,
                      MKL_Complex8* work ) NOTHROW;

void CHBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                   float* w, MKL_Complex8* z, const MKL_INT* ldz,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info ) NOTHROW;
void CHBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info ) NOTHROW;
void chbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                   float* w, MKL_Complex8* z, const MKL_INT* ldz,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info ) NOTHROW;
void chbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info ) NOTHROW;

void CHBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CHBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                     const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                     const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHEEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex8* a, const MKL_INT* lda, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info ) NOTHROW;
void CHEEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info ) NOTHROW;
void cheev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex8* a, const MKL_INT* lda, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info ) NOTHROW;
void cheev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info ) NOTHROW;

void CHEEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHEEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* w,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cheevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cheevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* w,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CHEEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                    float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHEEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                     float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cheevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                    float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cheevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                     float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CHEEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHEEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void cheevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void cheevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHEGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* b, const MKL_INT* ldb, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info ) NOTHROW;
void CHEGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* b, const MKL_INT* ldb, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info ) NOTHROW;
void chegv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* b, const MKL_INT* ldb, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info ) NOTHROW;
void chegv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* b, const MKL_INT* ldb, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info ) NOTHROW;

void CHETRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                    MKL_Complex8* tau, MKL_Complex8* hous2,
                    const MKL_INT* lhous2, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                     MKL_Complex8* tau, MKL_Complex8* hous2,
                     const MKL_INT* lhous2, MKL_Complex8* work,
                     const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                    MKL_Complex8* tau, MKL_Complex8* hous2,
                    const MKL_INT* lhous2, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                     MKL_Complex8* tau, MKL_Complex8* hous2,
                     const MKL_INT* lhous2, MKL_Complex8* work,
                     const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRD_HB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                   const MKL_INT* ldab, float* d, float* e, MKL_Complex8* hous,
                   const MKL_INT* lhous, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRD_HB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, float* d, float* e,
                    MKL_Complex8* hous, const MKL_INT* lhous,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_hb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                   const MKL_INT* ldab, float* d, float* e, MKL_Complex8* hous,
                   const MKL_INT* lhous, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_hb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, float* d, float* e,
                    MKL_Complex8* hous, const MKL_INT* lhous,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRD_HE2HB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                   const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRD_HE2HB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_he2hb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                   const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_he2hb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, double* a,
                     const MKL_INT* lda, double* v, double* tau,
                     const MKL_INT* ldvt, double* work ) NOTHROW;
void DSB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      double* a, const MKL_INT* lda, double* v, double* tau,
                      const MKL_INT* ldvt, double* work ) NOTHROW;
void dsb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, double* a,
                     const MKL_INT* lda, double* v, double* tau,
                     const MKL_INT* ldvt, double* work ) NOTHROW;
void dsb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      double* a, const MKL_INT* lda, double* v, double* tau,
                      const MKL_INT* ldvt, double* work ) NOTHROW;

void DSBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                   double* w, double* z, const MKL_INT* ldz, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                   double* w, double* z, const MKL_INT* ldz, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void DSBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void dsbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void dsbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void DSBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void DSBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, double* ab,
                     const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;
void dsbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void dsbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, double* ab,
                     const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;

void DSYEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   double* a, const MKL_INT* lda, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsyev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   double* a, const MKL_INT* lda, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsyev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void DSYEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* w, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void dsyevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void dsyevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* w, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void DSYEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    double* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void DSYEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     double* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void dsyevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    double* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void dsyevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     double* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void DSYEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void DSYEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;
void dsyevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void dsyevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;

void DSYGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                   const MKL_INT* ldb, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                    const MKL_INT* ldb, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsygv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                   const MKL_INT* ldb, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsygv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                    const MKL_INT* ldb, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* d, double* e,
                    double* tau, double* hous2, const MKL_INT* lhous2,
                    double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* d, double* e,
                     double* tau, double* hous2, const MKL_INT* lhous2,
                     double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* d, double* e,
                    double* tau, double* hous2, const MKL_INT* lhous2,
                    double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* d, double* e,
                     double* tau, double* hous2, const MKL_INT* lhous2,
                     double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRD_SB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, double* ab,
                   const MKL_INT* ldab, double* d, double* e, double* hous,
                   const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                   MKL_INT* info ) NOTHROW;
void DSYTRD_SB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* d, double* e, double* hous,
                    const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                    MKL_INT* info ) NOTHROW;
void dsytrd_sb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, double* ab,
                   const MKL_INT* ldab, double* d, double* e, double* hous,
                   const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                   MKL_INT* info ) NOTHROW;
void dsytrd_sb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* d, double* e, double* hous,
                    const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                    MKL_INT* info ) NOTHROW;

void DSYTRD_SY2SB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   double* a, const MKL_INT* lda, double* ab,
                   const MKL_INT* ldab, double* tau, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRD_SY2SB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    double* a, const MKL_INT* lda, double* ab,
                    const MKL_INT* ldab, double* tau, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrd_sy2sb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   double* a, const MKL_INT* lda, double* ab,
                   const MKL_INT* ldab, double* tau, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrd_sy2sb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    double* a, const MKL_INT* lda, double* ab,
                    const MKL_INT* ldab, double* tau, double* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

MKL_INT IPARAM2STAGE( const MKL_INT* ispec, const char* name, const char* opts,
                      const MKL_INT* ni, const MKL_INT* nbi,
                      const MKL_INT* ibi, const MKL_INT* nxi ) NOTHROW;
MKL_INT IPARAM2STAGE_( const MKL_INT* ispec, const char* name,
                       const char* opts, const MKL_INT* ni, const MKL_INT* nbi,
                       const MKL_INT* ibi, const MKL_INT* nxi ) NOTHROW;
MKL_INT iparam2stage( const MKL_INT* ispec, const char* name, const char* opts,
                      const MKL_INT* ni, const MKL_INT* nbi,
                      const MKL_INT* ibi, const MKL_INT* nxi ) NOTHROW;
MKL_INT iparam2stage_( const MKL_INT* ispec, const char* name,
                       const char* opts, const MKL_INT* ni, const MKL_INT* nbi,
                       const MKL_INT* ibi, const MKL_INT* nxi ) NOTHROW;

void SSB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, float* a,
                     const MKL_INT* lda, float* v, float* tau,
                     const MKL_INT* ldvt, float* work ) NOTHROW;
void SSB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      float* a, const MKL_INT* lda, float* v, float* tau,
                      const MKL_INT* ldvt, float* work ) NOTHROW;
void ssb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, float* a,
                     const MKL_INT* lda, float* v, float* tau,
                     const MKL_INT* ldvt, float* work ) NOTHROW;
void ssb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      float* a, const MKL_INT* lda, float* v, float* tau,
                      const MKL_INT* ldvt, float* work ) NOTHROW;

void SSBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, float* ab, const MKL_INT* ldab, float* w,
                   float* z, const MKL_INT* ldz, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, float* ab, const MKL_INT* ldab, float* w,
                   float* z, const MKL_INT* ldz, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void SSBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ssbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ssbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void SSBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void SSBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, float* ab,
                     const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;
void ssbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void ssbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, float* ab,
                     const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;

void SSYEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   float* a, const MKL_INT* lda, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssyev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   float* a, const MKL_INT* lda, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssyev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void SSYEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* w, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ssyevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ssyevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* w, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void SSYEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    float* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void SSYEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     float* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ssyevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    float* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ssyevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     float* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void SSYEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void SSYEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;
void ssyevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info ) NOTHROW;
void ssyevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info ) NOTHROW;

void SSYGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                   const MKL_INT* ldb, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                    const MKL_INT* ldb, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssygv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                   const MKL_INT* ldb, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssygv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                    const MKL_INT* ldb, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* d, float* e,
                    float* tau, float* hous2, const MKL_INT* lhous2,
                    float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* d, float* e,
                     float* tau, float* hous2, const MKL_INT* lhous2,
                     float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* d, float* e,
                    float* tau, float* hous2, const MKL_INT* lhous2,
                    float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* d, float* e,
                     float* tau, float* hous2, const MKL_INT* lhous2,
                     float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRD_SB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, float* ab,
                   const MKL_INT* ldab, float* d, float* e, float* hous,
                   const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                   MKL_INT* info ) NOTHROW;
void SSYTRD_SB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* d, float* e, float* hous,
                    const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                    MKL_INT* info ) NOTHROW;
void ssytrd_sb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, float* ab,
                   const MKL_INT* ldab, float* d, float* e, float* hous,
                   const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                   MKL_INT* info ) NOTHROW;
void ssytrd_sb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* d, float* e, float* hous,
                    const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                    MKL_INT* info ) NOTHROW;

void SSYTRD_SY2SB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   float* a, const MKL_INT* lda, float* ab,
                   const MKL_INT* ldab, float* tau, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRD_SY2SB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    float* a, const MKL_INT* lda, float* ab,
                    const MKL_INT* ldab, float* tau, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrd_sy2sb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   float* a, const MKL_INT* lda, float* ab,
                   const MKL_INT* ldab, float* tau, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrd_sy2sb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    float* a, const MKL_INT* lda, float* ab,
                    const MKL_INT* ldab, float* tau, float* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex16* a,
                     const MKL_INT* lda, MKL_Complex16* v, MKL_Complex16* tau,
                     const MKL_INT* ldvt, MKL_Complex16* work ) NOTHROW;
void ZHB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* v,
                      MKL_Complex16* tau, const MKL_INT* ldvt,
                      MKL_Complex16* work ) NOTHROW;
void zhb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex16* a,
                     const MKL_INT* lda, MKL_Complex16* v, MKL_Complex16* tau,
                     const MKL_INT* ldvt, MKL_Complex16* work ) NOTHROW;
void zhb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* v,
                      MKL_Complex16* tau, const MKL_INT* ldvt,
                      MKL_Complex16* work ) NOTHROW;

void ZHBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                   double* w, MKL_Complex16* z, const MKL_INT* ldz,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info ) NOTHROW;
void ZHBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info ) NOTHROW;
void zhbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                   double* w, MKL_Complex16* z, const MKL_INT* ldz,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info ) NOTHROW;
void zhbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info ) NOTHROW;

void ZHBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ZHBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void zhbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void zhbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void ZHBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void ZHBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                     const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void zhbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void zhbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                     const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void ZHEEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex16* a, const MKL_INT* lda, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info ) NOTHROW;
void ZHEEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info ) NOTHROW;
void zheev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex16* a, const MKL_INT* lda, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info ) NOTHROW;
void zheev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info ) NOTHROW;

void ZHEEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ZHEEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* w,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void zheevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void zheevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* w,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void ZHEEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex16* work, const MKL_INT* lwork,
                    double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void ZHEEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex16* work,
                     const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void zheevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex16* work, const MKL_INT* lwork,
                    double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void zheevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex16* work,
                     const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void ZHEEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void ZHEEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void zheevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void zheevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void ZHEGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* b, const MKL_INT* ldb, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info ) NOTHROW;
void ZHEGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* b, const MKL_INT* ldb, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info ) NOTHROW;
void zhegv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* b, const MKL_INT* ldb, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info ) NOTHROW;
void zhegv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* b, const MKL_INT* ldb, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info ) NOTHROW;

void ZHETRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* d, double* e,
                    MKL_Complex16* tau, MKL_Complex16* hous2,
                    const MKL_INT* lhous2, MKL_Complex16* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* d,
                     double* e, MKL_Complex16* tau, MKL_Complex16* hous2,
                     const MKL_INT* lhous2, MKL_Complex16* work,
                     const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* d, double* e,
                    MKL_Complex16* tau, MKL_Complex16* hous2,
                    const MKL_INT* lhous2, MKL_Complex16* work,
                    const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* d,
                     double* e, MKL_Complex16* tau, MKL_Complex16* hous2,
                     const MKL_INT* lhous2, MKL_Complex16* work,
                     const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETRD_HB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                   const MKL_INT* ldab, double* d, double* e,
                   MKL_Complex16* hous, const MKL_INT* lhous,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRD_HB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, double* d, double* e,
                    MKL_Complex16* hous, const MKL_INT* lhous,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrd_hb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                   const MKL_INT* ldab, double* d, double* e,
                   MKL_Complex16* hous, const MKL_INT* lhous,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrd_hb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, double* d, double* e,
                    MKL_Complex16* hous, const MKL_INT* lhous,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETRD_HE2HB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                   const MKL_INT* ldab, MKL_Complex16* tau,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRD_HE2HB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* tau,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrd_he2hb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                   const MKL_INT* ldab, MKL_Complex16* tau,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrd_he2hb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* tau,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void MKL_CGETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void MKL_CGETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_cgetrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_cgetrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void MKL_DGETRFNP( const MKL_INT* m, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void MKL_DGETRFNP_( const MKL_INT* m, const MKL_INT* n, double* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_dgetrfnp( const MKL_INT* m, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_dgetrfnp_( const MKL_INT* m, const MKL_INT* n, double* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void MKL_SGETRFNP( const MKL_INT* m, const MKL_INT* n, float* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void MKL_SGETRFNP_( const MKL_INT* m, const MKL_INT* n, float* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_sgetrfnp( const MKL_INT* m, const MKL_INT* n, float* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_sgetrfnp_( const MKL_INT* m, const MKL_INT* n, float* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void MKL_ZGETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void MKL_ZGETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_zgetrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_zgetrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                    const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void MKL_CGETRINP( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void MKL_CGETRINP_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_cgetrinp( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_cgetrinp_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void MKL_DGETRINP( const MKL_INT* n, double* a, const MKL_INT* lda,
                   double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void MKL_DGETRINP_( const MKL_INT* n, double* a, const MKL_INT* lda,
                    double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_dgetrinp( const MKL_INT* n, double* a, const MKL_INT* lda,
                   double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_dgetrinp_( const MKL_INT* n, double* a, const MKL_INT* lda,
                    double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void MKL_SGETRINP( const MKL_INT* n, float* a, const MKL_INT* lda, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void MKL_SGETRINP_( const MKL_INT* n, float* a, const MKL_INT* lda,
                    float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_sgetrinp( const MKL_INT* n, float* a, const MKL_INT* lda, float* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_sgetrinp_( const MKL_INT* n, float* a, const MKL_INT* lda,
                    float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void MKL_ZGETRINP( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void MKL_ZGETRINP_( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_zgetrinp( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void mkl_zgetrinp_( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                        const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_aa_2stage( const char* uplo, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_aa_2stage_( const char* uplo, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                        const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHESV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHESV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void CHETRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;
void chetrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void chetrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;

void CHETRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHETRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void CSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;
void csytrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void csytrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;

void CSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void ZHESV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info ) NOTHROW;
void ZHESV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void zhesv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info ) NOTHROW;
void zhesv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;

void ZHETRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void ZHETRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;
void zhetrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void zhetrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;

void ZHETRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ZHETRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zhetrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zhetrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void ZSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info ) NOTHROW;
void ZSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void zsysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info ) NOTHROW;
void zsysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;

void ZSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void ZSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;
void zsytrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info ) NOTHROW;
void zsytrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info ) NOTHROW;

void ZSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ZSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zsytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zsytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void DSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                       MKL_INT* info ) NOTHROW;
void DSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, double* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dsytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                       MKL_INT* info ) NOTHROW;
void dsytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, double* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void DSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      double* a, const MKL_INT* lda, double* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      double* b, const MKL_INT* ldb, double* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       double* b, const MKL_INT* ldb, double* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      double* a, const MKL_INT* lda, double* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      double* b, const MKL_INT* ldb, double* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       double* b, const MKL_INT* ldb, double* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      float* a, const MKL_INT* lda, float* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      float* b, const MKL_INT* ldb, float* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       float* b, const MKL_INT* ldb, float* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      float* a, const MKL_INT* lda, float* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      float* b, const MKL_INT* ldb, float* work,
                      const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       float* b, const MKL_INT* ldb, float* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                       MKL_INT* info ) NOTHROW;
void SSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, float* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ssytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                       MKL_INT* info ) NOTHROW;
void ssytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, float* b,
                        const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void SSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                        const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_aa_2stage( const char* uplo, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                       const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_aa_2stage_( const char* uplo, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                        const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DTREVC3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const double* t, const MKL_INT* ldt,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DTREVC3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const double* t, const MKL_INT* ldt,
               double* vl, const MKL_INT* ldvl, double* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dtrevc3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const double* t, const MKL_INT* ldt,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dtrevc3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const double* t, const MKL_INT* ldt,
               double* vl, const MKL_INT* ldvl, double* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void STREVC3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
              const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void STREVC3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
               const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
               const MKL_INT* mm, MKL_INT* m, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void strevc3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
              const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void strevc3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
               const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
               const MKL_INT* mm, MKL_INT* m, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CTREVC3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void CTREVC3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
               const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void ctrevc3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void ctrevc3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
               const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void ZTREVC3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void ZTREVC3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
               const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void ztrevc3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void ztrevc3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
               const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void SGETRF_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n, float* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void SGETRF_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n, float* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrf_batch_strided( const MKL_INT* m, const MKL_INT* n, float* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrf_batch_strided_( const MKL_INT* m, const MKL_INT* n, float* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void DGETRF_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n, double* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void DGETRF_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n, double* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrf_batch_strided( const MKL_INT* m, const MKL_INT* n, double* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrf_batch_strided_( const MKL_INT* m, const MKL_INT* n, double* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void CGETRF_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void CGETRF_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n,
                            MKL_Complex8* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void cgetrf_batch_strided( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void cgetrf_batch_strided_( const MKL_INT* m, const MKL_INT* n,
                            MKL_Complex8* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void ZGETRF_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           const MKL_INT* stride_a, MKL_INT* ipiv,
                           const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void ZGETRF_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n,
                            MKL_Complex16* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void zgetrf_batch_strided( const MKL_INT* m, const MKL_INT* n,
                           MKL_Complex16* a, const MKL_INT* lda,
                           const MKL_INT* stride_a, MKL_INT* ipiv,
                           const MKL_INT* stride_ipiv,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void zgetrf_batch_strided_( const MKL_INT* m, const MKL_INT* n,
                            MKL_Complex16* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void SGETRS_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                           const MKL_INT* stride_a, const MKL_INT* ipiv,
                           const MKL_INT* stride_ipiv, float* b,
                           const MKL_INT* ldb, const MKL_INT* stride_b,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void SGETRS_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, const MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv, float* b,
                            const MKL_INT* ldb, const MKL_INT* stride_b,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrs_batch_strided( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                           const MKL_INT* stride_a, const MKL_INT* ipiv,
                           const MKL_INT* stride_ipiv, float* b,
                           const MKL_INT* ldb, const MKL_INT* stride_b,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrs_batch_strided_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, const MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv, float* b,
                            const MKL_INT* ldb, const MKL_INT* stride_b,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void DGETRS_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                           const MKL_INT* stride_a, const MKL_INT* ipiv,
                           const MKL_INT* stride_ipiv, double* b,
                           const MKL_INT* ldb, const MKL_INT* stride_b,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void DGETRS_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, const MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv, double* b,
                            const MKL_INT* ldb, const MKL_INT* stride_b,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrs_batch_strided( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                           const MKL_INT* stride_a, const MKL_INT* ipiv,
                           const MKL_INT* stride_ipiv, double* b,
                           const MKL_INT* ldb, const MKL_INT* stride_b,
                           const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrs_batch_strided_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                            const MKL_INT* stride_a, const MKL_INT* ipiv,
                            const MKL_INT* stride_ipiv, double* b,
                            const MKL_INT* ldb, const MKL_INT* stride_b,
                            const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void CGETRS_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb,
                           const MKL_INT* stride_b, const MKL_INT* batch_size,
                           MKL_INT* info ) NOTHROW;
void CGETRS_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb,
                            const MKL_INT* stride_b, const MKL_INT* batch_size,
                            MKL_INT* info ) NOTHROW;
void cgetrs_batch_strided( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex8* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           MKL_Complex8* b, const MKL_INT* ldb,
                           const MKL_INT* stride_b, const MKL_INT* batch_size,
                           MKL_INT* info ) NOTHROW;
void cgetrs_batch_strided_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const MKL_Complex8* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            MKL_Complex8* b, const MKL_INT* ldb,
                            const MKL_INT* stride_b, const MKL_INT* batch_size,
                            MKL_INT* info ) NOTHROW;

void ZGETRS_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex16* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb,
                           const MKL_INT* stride_b, const MKL_INT* batch_size,
                           MKL_INT* info ) NOTHROW;
void ZGETRS_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb,
                            const MKL_INT* stride_b, const MKL_INT* batch_size,
                            MKL_INT* info ) NOTHROW;
void zgetrs_batch_strided( const char* trans, const MKL_INT* n,
                           const MKL_INT* nrhs, const MKL_Complex16* a,
                           const MKL_INT* lda, const MKL_INT* stride_a,
                           const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                           MKL_Complex16* b, const MKL_INT* ldb,
                           const MKL_INT* stride_b, const MKL_INT* batch_size,
                           MKL_INT* info ) NOTHROW;
void zgetrs_batch_strided_( const char* trans, const MKL_INT* n,
                            const MKL_INT* nrhs, const MKL_Complex16* a,
                            const MKL_INT* lda, const MKL_INT* stride_a,
                            const MKL_INT* ipiv, const MKL_INT* stride_ipiv,
                            MKL_Complex16* b, const MKL_INT* ldb,
                            const MKL_INT* stride_b, const MKL_INT* batch_size,
                            MKL_INT* info ) NOTHROW;

void SGETRFNP_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n, float* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void SGETRFNP_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n, float* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrfnp_batch_strided( const MKL_INT* m, const MKL_INT* n, float* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrfnp_batch_strided_( const MKL_INT* m, const MKL_INT* n, float* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void DGETRFNP_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n, double* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void DGETRFNP_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n, double* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrfnp_batch_strided( const MKL_INT* m, const MKL_INT* n, double* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrfnp_batch_strided_( const MKL_INT* m, const MKL_INT* n, double* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void CGETRFNP_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void CGETRFNP_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n,
                              MKL_Complex8* a, const MKL_INT* lda,
                              const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void cgetrfnp_batch_strided( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void cgetrfnp_batch_strided_( const MKL_INT* m, const MKL_INT* n,
                              MKL_Complex8* a, const MKL_INT* lda,
                              const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void ZGETRFNP_BATCH_STRIDED( const MKL_INT* m, const MKL_INT* n,
                             MKL_Complex16* a, const MKL_INT* lda,
                             const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void ZGETRFNP_BATCH_STRIDED_( const MKL_INT* m, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void zgetrfnp_batch_strided( const MKL_INT* m, const MKL_INT* n,
                             MKL_Complex16* a, const MKL_INT* lda,
                             const MKL_INT* stride_a,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void zgetrfnp_batch_strided_( const MKL_INT* m, const MKL_INT* n,
                              MKL_Complex16* a, const MKL_INT* lda,
                              const MKL_INT* stride_a,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void SGETRSNP_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                             const MKL_INT* stride_a, float* b,
                             const MKL_INT* ldb, const MKL_INT* stride_b,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void SGETRSNP_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                              const MKL_INT* stride_a, float* b,
                              const MKL_INT* ldb, const MKL_INT* stride_b,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrsnp_batch_strided( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                             const MKL_INT* stride_a, float* b,
                             const MKL_INT* ldb, const MKL_INT* stride_b,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void sgetrsnp_batch_strided_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const float* a, const MKL_INT* lda,
                              const MKL_INT* stride_a, float* b,
                              const MKL_INT* ldb, const MKL_INT* stride_b,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void DGETRSNP_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                             const MKL_INT* stride_a, double* b,
                             const MKL_INT* ldb, const MKL_INT* stride_b,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void DGETRSNP_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                              const MKL_INT* stride_a, double* b,
                              const MKL_INT* ldb, const MKL_INT* stride_b,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrsnp_batch_strided( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                             const MKL_INT* stride_a, double* b,
                             const MKL_INT* ldb, const MKL_INT* stride_b,
                             const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void dgetrsnp_batch_strided_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
                              const MKL_INT* stride_a, double* b,
                              const MKL_INT* ldb, const MKL_INT* stride_b,
                              const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void CGETRSNP_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             MKL_Complex8* b, const MKL_INT* ldb,
                             const MKL_INT* stride_b, const MKL_INT* batch_size,
                             MKL_INT* info ) NOTHROW;
void CGETRSNP_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const MKL_Complex8* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              MKL_Complex8* b, const MKL_INT* ldb,
                              const MKL_INT* stride_b, const MKL_INT* batch_size,
                              MKL_INT* info ) NOTHROW;
void cgetrsnp_batch_strided( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const MKL_Complex8* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             MKL_Complex8* b, const MKL_INT* ldb,
                             const MKL_INT* stride_b, const MKL_INT* batch_size,
                             MKL_INT* info ) NOTHROW;
void cgetrsnp_batch_strided_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const MKL_Complex8* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              MKL_Complex8* b, const MKL_INT* ldb,
                              const MKL_INT* stride_b, const MKL_INT* batch_size,
                              MKL_INT* info ) NOTHROW;

void ZGETRSNP_BATCH_STRIDED( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             MKL_Complex16* b, const MKL_INT* ldb,
                             const MKL_INT* stride_b, const MKL_INT* batch_size,
                             MKL_INT* info ) NOTHROW;
void ZGETRSNP_BATCH_STRIDED_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const MKL_Complex16* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              MKL_Complex16* b, const MKL_INT* ldb,
                              const MKL_INT* stride_b, const MKL_INT* batch_size,
                              MKL_INT* info ) NOTHROW;
void zgetrsnp_batch_strided( const char* trans, const MKL_INT* n,
                             const MKL_INT* nrhs, const MKL_Complex16* a,
                             const MKL_INT* lda, const MKL_INT* stride_a,
                             MKL_Complex16* b, const MKL_INT* ldb,
                             const MKL_INT* stride_b, const MKL_INT* batch_size,
                             MKL_INT* info ) NOTHROW;
void zgetrsnp_batch_strided_( const char* trans, const MKL_INT* n,
                              const MKL_INT* nrhs, const MKL_Complex16* a,
                              const MKL_INT* lda, const MKL_INT* stride_a,
                              MKL_Complex16* b, const MKL_INT* ldb,
                              const MKL_INT* stride_b, const MKL_INT* batch_size,
                              MKL_INT* info ) NOTHROW;

void DGETRF_BATCH( const MKL_INT* m, const MKL_INT* n, double** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void DGETRF_BATCH_( const MKL_INT* m, const MKL_INT* n, double** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;
void dgetrf_batch( const MKL_INT* m, const MKL_INT* n, double** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void dgetrf_batch_( const MKL_INT* m, const MKL_INT* n, double** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;

void SGETRF_BATCH( const MKL_INT* m, const MKL_INT* n, float** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void SGETRF_BATCH_( const MKL_INT* m, const MKL_INT* n, float** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;
void sgetrf_batch( const MKL_INT* m, const MKL_INT* n, float** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void sgetrf_batch_( const MKL_INT* m, const MKL_INT* n, float** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;

void CGETRF_BATCH( const MKL_INT* m, const MKL_INT* n, MKL_Complex8** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void CGETRF_BATCH_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;
void cgetrf_batch( const MKL_INT* m, const MKL_INT* n, MKL_Complex8** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void cgetrf_batch_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;

void ZGETRF_BATCH( const MKL_INT* m, const MKL_INT* n, MKL_Complex16** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void ZGETRF_BATCH_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;
void zgetrf_batch( const MKL_INT* m, const MKL_INT* n, MKL_Complex16** a,
                   const MKL_INT* lda, MKL_INT** ipiv,
                   const MKL_INT* group_count, const MKL_INT* group_size,
                   MKL_INT* info ) NOTHROW;
void zgetrf_batch_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16** a,
                    const MKL_INT* lda, MKL_INT** ipiv,
                    const MKL_INT* group_count, const MKL_INT* group_size,
                    MKL_INT* info ) NOTHROW;

void SGETRI_OOP_BATCH_STRIDED( const MKL_INT* n, const float* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, float* ainv, const MKL_INT* ldainv,
                               const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                               MKL_INT* info ) NOTHROW;
void SGETRI_OOP_BATCH_STRIDED_( const MKL_INT* n, const float* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, float* ainv, const MKL_INT* ldainv,
                                const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                                MKL_INT* info ) NOTHROW;
void sgetri_oop_batch_strided( const MKL_INT* n, const float* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, float* ainv, const MKL_INT* ldainv,
                               const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                               MKL_INT* info ) NOTHROW;
void sgetri_oop_batch_strided_( const MKL_INT* n, const float* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, float* ainv, const MKL_INT* ldainv,
                                const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                                MKL_INT* info ) NOTHROW;

void DGETRI_OOP_BATCH_STRIDED( const MKL_INT* n, const double* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, double* ainv, const MKL_INT* ldainv,
                               const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                               MKL_INT* info ) NOTHROW;
void DGETRI_OOP_BATCH_STRIDED_( const MKL_INT* n, const double* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, double* ainv, const MKL_INT* ldainv,
                                const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                                MKL_INT* info ) NOTHROW;
void dgetri_oop_batch_strided( const MKL_INT* n, const double* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, double* ainv, const MKL_INT* ldainv,
                               const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                               MKL_INT* info ) NOTHROW;
void dgetri_oop_batch_strided_( const MKL_INT* n, const double* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, double* ainv, const MKL_INT* ldainv,
                                const MKL_INT* stride_ainv, const MKL_INT* batch_size,
                                MKL_INT* info ) NOTHROW;

void CGETRI_OOP_BATCH_STRIDED( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, MKL_Complex8* ainv,
                               const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                               const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void CGETRI_OOP_BATCH_STRIDED_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, MKL_Complex8* ainv,
                                const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                                const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void cgetri_oop_batch_strided( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, MKL_Complex8* ainv,
                               const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                               const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void cgetri_oop_batch_strided_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, MKL_Complex8* ainv,
                                const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                                const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void ZGETRI_OOP_BATCH_STRIDED( const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, MKL_Complex16* ainv,
                               const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                               const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void ZGETRI_OOP_BATCH_STRIDED_( const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, MKL_Complex16* ainv,
                                const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                                const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void zgetri_oop_batch_strided( const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* lda,
                               const MKL_INT* stridea, const MKL_INT* ipiv,
                               const MKL_INT* stride_ipiv, MKL_Complex16* ainv,
                               const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                               const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;
void zgetri_oop_batch_strided_( const MKL_INT* n, const MKL_Complex16* a, const MKL_INT* lda,
                                const MKL_INT* stridea, const MKL_INT* ipiv,
                                const MKL_INT* stride_ipiv, MKL_Complex16* ainv,
                                const MKL_INT* ldainv, const MKL_INT* stride_ainv,
                                const MKL_INT* batch_size, MKL_INT* info ) NOTHROW;

void SGETRI_OOP_BATCH( const MKL_INT* n, const float** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, float** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void SGETRI_OOP_BATCH_( const MKL_INT* n, const float** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, float** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;
void sgetri_oop_batch( const MKL_INT* n, const float** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, float** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void sgetri_oop_batch_( const MKL_INT* n, const float** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, float** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;

void DGETRI_OOP_BATCH( const MKL_INT* n, const double** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, double** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void DGETRI_OOP_BATCH_( const MKL_INT* n, const double** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, double** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;
void dgetri_oop_batch( const MKL_INT* n, const double** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, double** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void dgetri_oop_batch_( const MKL_INT* n, const double** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, double** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;

void CGETRI_OOP_BATCH( const MKL_INT* n, const MKL_Complex8** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, MKL_Complex8** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void CGETRI_OOP_BATCH_( const MKL_INT* n, const MKL_Complex8** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, MKL_Complex8** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;
void cgetri_oop_batch( const MKL_INT* n, const MKL_Complex8** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, MKL_Complex8** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void cgetri_oop_batch_( const MKL_INT* n, const MKL_Complex8** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, MKL_Complex8** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;

void ZGETRI_OOP_BATCH( const MKL_INT* n, const MKL_Complex16** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, MKL_Complex16** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void ZGETRI_OOP_BATCH_( const MKL_INT* n, const MKL_Complex16** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, MKL_Complex16** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;
void zgetri_oop_batch( const MKL_INT* n, const MKL_Complex16** a, const MKL_INT* lda, 
                       const MKL_INT** ipiv, MKL_Complex16** ainv, const MKL_INT* ldainv,
                       const MKL_INT* group_count, const MKL_INT* group_size,
                       MKL_INT* info ) NOTHROW;
void zgetri_oop_batch_( const MKL_INT* n, const MKL_Complex16** a, const MKL_INT* lda, 
                        const MKL_INT** ipiv, MKL_Complex16** ainv, const MKL_INT* ldainv,
                        const MKL_INT* group_count, const MKL_INT* group_size,
                        MKL_INT* info ) NOTHROW;

/* LAPACK 3.6.0 routines */

void CGEJSV( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
             float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CGEJSV_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
              float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cgejsv( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
             float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cgejsv_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
              float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void ZGEJSV( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
             const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void ZGEJSV_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
              const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void zgejsv( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
             const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void zgejsv_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
              const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;

void DGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
               double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
               double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void SGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
              float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void SGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
               float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
               const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void sgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
              float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void sgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
               float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
               const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void CGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
               const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
               MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
               MKL_INT* info ) NOTHROW;
void cgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void cgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
               const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
               MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
               MKL_INT* info ) NOTHROW;

void ZGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
              const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ZGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
               const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void zgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
              const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void zgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
               const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CGESVJ( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
             const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void CGESVJ_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
              const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void cgesvj( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
             const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void cgesvj_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
              const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void ZGESVJ( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void ZGESVJ_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void zgesvj( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;
void zgesvj_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void DGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
              double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
              double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
               double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
               double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
              double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
              double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
               double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
               double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void SGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
              float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
              const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void SGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
               float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
               const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
               MKL_INT* info ) NOTHROW;
void sggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
              float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
              const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void sggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
               float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
               const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
               MKL_INT* info ) NOTHROW;

void CGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
              float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
               float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
               const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
              float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
               float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
               const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void ZGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
              double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ZGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
               double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
               const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void zggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
              double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void zggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
               double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
               const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
              const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
               const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
              const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
               const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
              float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
               float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
              float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
               float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
              float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void CGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
               float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void cggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
              float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
               float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void ZGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void ZGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void zggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void zggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void CGSVJ0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CGSVJ0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cgsvj0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cgsvj0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void ZGSVJ0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
             MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
             const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void ZGSVJ0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
              MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
              const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void zgsvj0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
             MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
             const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void zgsvj0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
              MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
              const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CGSVJ1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CGSVJ1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cgsvj1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cgsvj1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void ZGSVJ1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
             const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGSVJ1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
              const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgsvj1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
             const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgsvj1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
              const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CPOTRF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void CPOTRF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* info ) NOTHROW;
void cpotrf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void cpotrf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* info ) NOTHROW;

void DPOTRF2( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void DPOTRF2_( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* info ) NOTHROW;
void dpotrf2( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void dpotrf2_( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* info ) NOTHROW;

void SPOTRF2( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void SPOTRF2_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void spotrf2( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void spotrf2_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void ZPOTRF2( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void ZPOTRF2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* info ) NOTHROW;
void zpotrf2( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void zpotrf2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* info ) NOTHROW;

void DBDSVDX( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const double* d, const double* e, const double* vl, const double* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
              const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DBDSVDX_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const double* d, const double* e, const double* vl, const double* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
               const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dbdsvdx( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const double* d, const double* e, const double* vl, const double* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
              const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dbdsvdx_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const double* d, const double* e, const double* vl, const double* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
               const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void SBDSVDX( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const float* d, const float* e, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
              const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void SBDSVDX_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const float* d, const float* e, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
               const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void sbdsvdx( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const float* d, const float* e, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
              const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void sbdsvdx_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const float* d, const float* e, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
               const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CGETRF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CGETRF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgetrf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgetrf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DGETRF2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DGETRF2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgetrf2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgetrf2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void SGETRF2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* info ) NOTHROW;
void SGETRF2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_INT* info ) NOTHROW;
void sgetrf2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* info ) NOTHROW;
void sgetrf2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_INT* info ) NOTHROW;

void ZGETRF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ZGETRF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zgetrf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zgetrf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
             MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void CGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
              MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;
void cggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
             MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void cggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
              MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;

void ZGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
             MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
             const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
             MKL_INT* info ) NOTHROW;
void ZGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
              MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              MKL_INT* info ) NOTHROW;
void zggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
             MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
             const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
             MKL_INT* info ) NOTHROW;
void zggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
              MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              MKL_INT* info ) NOTHROW;

void DGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
             double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
             double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
             float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
              float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
             float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
              float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cunm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void ZUNM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
             MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void ZUNM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
              MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void zunm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
             MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void zunm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
              MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
             const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
              const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
             const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
              const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info ) NOTHROW;
void CGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
              MKL_INT* info ) NOTHROW;
void cgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info ) NOTHROW;
void cgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
              MKL_INT* info ) NOTHROW;

void ZGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
             MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
             MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
             MKL_INT* info ) NOTHROW;
void ZGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
              MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
              MKL_INT* info ) NOTHROW;
void zgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
             MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
             MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
             MKL_INT* info ) NOTHROW;
void zgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
              MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
              MKL_INT* info ) NOTHROW;

void DGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void DGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
              const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void dgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void dgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
              const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void SGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
             const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void SGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
              const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void sgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
             const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void sgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
              const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void DORM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
             double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void DORM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
              double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dorm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
             double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void dorm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
              double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void SORM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void SORM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
              float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void sorm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void sorm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
              float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;


/* LAPACK 3.5.0 routines */

void CHECON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CHECON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void checon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void checon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CHESV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHESV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CHETF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void chetf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void chetf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CHETRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info ) NOTHROW;
void CHETRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info ) NOTHROW;
void chetri_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info ) NOTHROW;
void chetri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info ) NOTHROW;

void CHETRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHETRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                    const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                    MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                    const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                    MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CLAHEF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void CLAHEF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clahef_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clahef_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void CLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void CLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void CSYCON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CSYCON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csycon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csycon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CSYTF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csytf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csytf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CSYTRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info ) NOTHROW;
void CSYTRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info ) NOTHROW;
void csytri_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info ) NOTHROW;
void csytri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info ) NOTHROW;

void CSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void DLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                  double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void DLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                   double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void dlasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                  double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void dlasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                   double* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void DSYCON_ROOK( const char* uplo, const MKL_INT* n, const double* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DSYCON_ROOK_( const char* uplo, const MKL_INT* n, const double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dsycon_rook( const char* uplo, const MKL_INT* n, const double* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dsycon_rook_( const char* uplo, const MKL_INT* n, const double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                 double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                  const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                  MKL_INT* info ) NOTHROW;
void dsysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                 double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                  const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                  MKL_INT* info ) NOTHROW;

void DSYTF2_ROOK( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DSYTF2_ROOK_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsytf2_rook( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dsytf2_rook_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DSYTRF_ROOK( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                  MKL_INT* info ) NOTHROW;
void DSYTRF_ROOK_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* ipiv, double* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytrf_rook( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                  MKL_INT* info ) NOTHROW;
void dsytrf_rook_( const char* uplo, const MKL_INT* n, double* a,
                  const MKL_INT* lda, MKL_INT* ipiv, double* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRI_ROOK( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, double* work, MKL_INT* info ) NOTHROW;
void DSYTRI_ROOK_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                   MKL_INT* info ) NOTHROW;
void dsytri_rook( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, double* work, MKL_INT* info ) NOTHROW;
void dsytri_rook_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                   MKL_INT* info ) NOTHROW;

void DSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void DSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dsytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dsytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void SLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                  float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void SLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                   float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void slasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                  float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void slasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                   float* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void SSYCON_ROOK( const char* uplo, const MKL_INT* n, const float* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void SSYCON_ROOK_( const char* uplo, const MKL_INT* n, const float* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ssycon_rook( const char* uplo, const MKL_INT* n, const float* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ssycon_rook_( const char* uplo, const MKL_INT* n, const float* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void SSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                 float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                  const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                  float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                 float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                  const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                  float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTF2_ROOK( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void SSYTF2_ROOK_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssytf2_rook( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ssytf2_rook_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void SSYTRF_ROOK( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                 MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRF_ROOK_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                   MKL_INT* info ) NOTHROW;
void ssytrf_rook( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytrf_rook_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                   MKL_INT* info ) NOTHROW;

void SSYTRI_ROOK( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, float* work, MKL_INT* info ) NOTHROW;
void SSYTRI_ROOK_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   const MKL_INT* ipiv, float* work, MKL_INT* info ) NOTHROW;
void ssytri_rook( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, float* work, MKL_INT* info ) NOTHROW;
void ssytri_rook_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   const MKL_INT* ipiv, float* work, MKL_INT* info ) NOTHROW;

void SSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const float* a, const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                  const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void SSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   float* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ssytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const float* a, const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                  const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ssytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   float* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void ZHECON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZHECON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zhecon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zhecon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZHESV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHESV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhesv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhesv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ZHETF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zhetf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zhetf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void ZHETRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZHETRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zhetrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZHETRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info ) NOTHROW;
void ZHETRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info ) NOTHROW;
void zhetri_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info ) NOTHROW;
void zhetri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info ) NOTHROW;

void ZHETRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ZHETRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zhetrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zhetrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void ZLAHEF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void ZLAHEF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlahef_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlahef_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void ZLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void ZLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void zlasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void ZSYCON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZSYCON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zsycon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zsycon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYTF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void ZSYTF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zsytf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void zsytf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void ZSYTRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYTRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYTRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info ) NOTHROW;
void ZSYTRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info ) NOTHROW;
void zsytri_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info ) NOTHROW;
void zsytri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info ) NOTHROW;

void ZSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ZSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zsytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void zsytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CUNBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void CUNBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void cunbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void CUNBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                 const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                 const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                 MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                 const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CUNCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                  const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                  const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                  MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                  const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cuncsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                 const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                 const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                 MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                 const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cuncsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                  const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                  const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                  MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                  const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DORBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DORBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DORBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DORBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DORBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DORBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DORBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* phantom, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void DORBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* phantom, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void dorbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* phantom, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dorbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* phantom, double* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void DORBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DORBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DORBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DORBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dorbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DORCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 double* x11, const MKL_INT* ldx11, double* x21,
                 const MKL_INT* ldx21, double* theta, double* u1,
                 const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                 double* v1t, const MKL_INT* ldv1t, double* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DORCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  double* x11, const MKL_INT* ldx11, double* x21,
                  const MKL_INT* ldx21, double* theta, double* u1,
                  const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                  double* v1t, const MKL_INT* ldv1t, double* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dorcsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 double* x11, const MKL_INT* ldx11, double* x21,
                 const MKL_INT* ldx21, double* theta, double* u1,
                 const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                 double* v1t, const MKL_INT* ldv1t, double* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dorcsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  double* x11, const MKL_INT* ldx11, double* x21,
                  const MKL_INT* ldx21, double* theta, double* u1,
                  const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                  double* v1t, const MKL_INT* ldv1t, double* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void SORBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SORBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SORBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SORBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SORBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SORBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SORBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* phantom, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void SORBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* phantom, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void sorbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* phantom, float* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void sorbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* phantom, float* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void SORBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SORBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SORBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SORBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void sorbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SORCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 float* x11, const MKL_INT* ldx11, float* x21,
                 const MKL_INT* ldx21, float* theta, float* u1,
                 const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                 float* v1t, const MKL_INT* ldv1t, float* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void SORCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  float* x11, const MKL_INT* ldx11, float* x21,
                  const MKL_INT* ldx21, float* theta, float* u1,
                  const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                  float* v1t, const MKL_INT* ldv1t, float* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void sorcsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 float* x11, const MKL_INT* ldx11, float* x21,
                 const MKL_INT* ldx21, float* theta, float* u1,
                 const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                 float* v1t, const MKL_INT* ldv1t, float* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void sorcsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  float* x11, const MKL_INT* ldx11, float* x21,
                  const MKL_INT* ldx21, float* theta, float* u1,
                  const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                  float* v1t, const MKL_INT* ldv1t, float* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void ZUNBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZUNBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZUNBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZUNBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZUNBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZUNBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZUNBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void ZUNBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;
void zunbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void zunbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info ) NOTHROW;

void ZUNBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZUNBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZUNBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZUNBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zunbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZUNCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                 const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                 const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                 MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                 const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ZUNCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                  const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                  const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                  MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                  const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void zuncsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                 const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                 const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                 MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                 const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void zuncsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                  const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                  const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                  MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                  const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info ) NOTHROW;

/* LAPACK 3.4.0 routines */

void CGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* c, const MKL_INT* ldc,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* c, const MKL_INT* ldc,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void DGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void dgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void dgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;

void SGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info ) NOTHROW;
void SGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info ) NOTHROW;
void sgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info ) NOTHROW;
void sgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info ) NOTHROW;

void ZGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* c, const MKL_INT* ldc,
               MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* c, const MKL_INT* ldc,
               MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void CGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void cgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void cgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info ) NOTHROW;

void DGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info ) NOTHROW;

void dgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info ) NOTHROW;

void dgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info ) NOTHROW;

void SGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info ) NOTHROW;

void SGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info ) NOTHROW;

void sgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info ) NOTHROW;

void sgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info ) NOTHROW;

void ZGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void zgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void zgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void CGEQRT3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void CGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void cgeqrt3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void cgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void DGEQRT3( const MKL_INT* m, const MKL_INT* n,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void DGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               double* a, const MKL_INT* lda,
               double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void dgeqrt3( const MKL_INT* m, const MKL_INT* n,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void dgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               double* a, const MKL_INT* lda,
               double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void SGEQRT3( const MKL_INT* m, const MKL_INT* n,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void SGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               float* a, const MKL_INT* lda,
               float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void sgeqrt3( const MKL_INT* m, const MKL_INT* n,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void sgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               float* a, const MKL_INT* lda,
               float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ZGEQRT3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ZGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void zgeqrt3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void zgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void CTPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CTPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void ctpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void ctpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DTPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* work, MKL_INT* info ) NOTHROW;

void DTPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* work, MKL_INT* info ) NOTHROW;

void dtpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* work, MKL_INT* info ) NOTHROW;

void dtpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* work, MKL_INT* info ) NOTHROW;

void STPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* work, MKL_INT* info ) NOTHROW;

void STPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* work, MKL_INT* info ) NOTHROW;

void stpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* work, MKL_INT* info ) NOTHROW;

void stpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* work, MKL_INT* info ) NOTHROW;

void ZTPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZTPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ztpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ztpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void CTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void ctpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void ctpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info ) NOTHROW;

void DTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info ) NOTHROW;

void dtpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info ) NOTHROW;

void dtpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info ) NOTHROW;

void STPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info ) NOTHROW;

void STPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info ) NOTHROW;

void stpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info ) NOTHROW;

void stpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info ) NOTHROW;

void ZTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ZTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ztpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void ztpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void CTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void CTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ctpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ctpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void DTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void DTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void dtpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void dtpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void STPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void STPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void stpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void stpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ZTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ZTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ztpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

void ztpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info ) NOTHROW;

/* LAPACK 3.3.0 routines */

void CBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void CBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void cbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void cbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void ZBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void ZBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void zbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void zbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void SBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void SBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void sbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void sbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void DBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void DBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void dbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void dbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info ) NOTHROW;

void CUNBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
             const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
             MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
             const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
             MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void CUNBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
              const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
              MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
              const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
              MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void cunbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
             const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
             MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
             const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
             MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void cunbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
              const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
              MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
              const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
              MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void ZUNBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
             const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
             MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
             const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
             MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void ZUNBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
              const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
              MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
              const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
              MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void zunbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
             const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
             MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
             const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
             MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void zunbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
              const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
              MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
              const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
              MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void SORBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* x11,
             const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
             float* x21, const MKL_INT* ldx21, float* x22,
             const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
             float* taup2, float* tauq1, float* tauq2,
             float* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void SORBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* x11,
              const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
              float* x21, const MKL_INT* ldx21, float* x22,
              const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
              float* taup2, float* tauq1, float* tauq2,
              float* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void sorbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* x11,
             const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
             float* x21, const MKL_INT* ldx21, float* x22,
             const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
             float* taup2, float* tauq1, float* tauq2,
             float* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void sorbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* x11,
              const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
              float* x21, const MKL_INT* ldx21, float* x22,
              const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
              float* taup2, float* tauq1, float* tauq2,
              float* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void DORBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* x11,
             const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
             double* x21, const MKL_INT* ldx21, double* x22,
             const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
             double* taup2, double* tauq1, double* tauq2,
             double* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void DORBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* x11,
              const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
              double* x21, const MKL_INT* ldx21, double* x22,
              const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
              double* taup2, double* tauq1, double* tauq2,
              double* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void dorbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* x11,
             const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
             double* x21, const MKL_INT* ldx21, double* x22,
             const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
             double* taup2, double* tauq1, double* tauq2,
             double* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void dorbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* x11,
              const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
              double* x21, const MKL_INT* ldx21, double* x22,
              const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
              double* taup2, double* tauq1, double* tauq2,
              double* work, const MKL_INT* lwork, MKL_INT* info) NOTHROW;

void CUNCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
             const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
             MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info) NOTHROW;

void CUNCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
              const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
              MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info) NOTHROW;

void cuncsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
             const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
             MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info) NOTHROW;

void cuncsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
              const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
              MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info) NOTHROW;

void ZUNCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
             const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
             MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info) NOTHROW;

void ZUNCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
              const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
              MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info) NOTHROW;

void zuncsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
             const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
             MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info) NOTHROW;

void zuncsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
              const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
              MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info) NOTHROW;

void SORCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             float* x11, const MKL_INT* ldx11, float* x12,
             const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
             float* x22, const MKL_INT* ldx22, float* theta,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void SORCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              float* x11, const MKL_INT* ldx11, float* x12,
              const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
              float* x22, const MKL_INT* ldx22, float* theta,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void sorcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             float* x11, const MKL_INT* ldx11, float* x12,
             const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
             float* x22, const MKL_INT* ldx22, float* theta,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void sorcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              float* x11, const MKL_INT* ldx11, float* x12,
              const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
              float* x22, const MKL_INT* ldx22, float* theta,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void DORCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             double* x11, const MKL_INT* ldx11, double* x12,
             const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
             double* x22, const MKL_INT* ldx22, double* theta,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void DORCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              double* x11, const MKL_INT* ldx11, double* x12,
              const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
              double* x22, const MKL_INT* ldx22, double* theta,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void dorcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             double* x11, const MKL_INT* ldx11, double* x12,
             const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
             double* x22, const MKL_INT* ldx22, double* theta,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;

void dorcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              double* x11, const MKL_INT* ldx11, double* x12,
              const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
              double* x22, const MKL_INT* ldx22, double* theta,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info) NOTHROW;


void CLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void CLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void clapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void clapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;

void DLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             double* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void DLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              double* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void dlapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             double* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void dlapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              double* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;

void ZLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void ZLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void zlapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void zlapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;

void SLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             float* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void SLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              float* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void slapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             float* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void slapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              float* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;

void CSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info ) NOTHROW;
void CSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info ) NOTHROW;
void csyconv( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info ) NOTHROW;
void csyconv_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info ) NOTHROW;

void ZSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info ) NOTHROW;
void ZSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info ) NOTHROW;
void zsyconv( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info ) NOTHROW;
void zsyconv_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info ) NOTHROW;

void SSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info ) NOTHROW;
void SSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info ) NOTHROW;
void ssyconv( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info ) NOTHROW;
void ssyconv_( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info ) NOTHROW;

void DSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info ) NOTHROW;
void DSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info ) NOTHROW;
void dsyconv( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info ) NOTHROW;
void dsyconv_( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info ) NOTHROW;

void CSYSWAPR( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void CSYSWAPR_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void csyswapr( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void csyswapr_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;

void ZSYSWAPR( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void ZSYSWAPR_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void zsyswapr( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void zsyswapr_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;

void SSYSWAPR( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void SSYSWAPR_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void ssyswapr( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void ssyswapr_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;

void DSYSWAPR( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void DSYSWAPR_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void dsyswapr( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;
void dsyswapr_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 ) NOTHROW;

void CSYTRI2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRI2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytri2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytri2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void ZSYTRI2( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ZSYTRI2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytri2( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void zsytri2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void SSYTRI2( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void SSYTRI2_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytri2( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ssytri2_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DSYTRI2( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DSYTRI2_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytri2( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dsytri2_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRI2X( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void CSYTRI2X_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void csytri2x( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void csytri2x_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;

void ZSYTRI2X( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void ZSYTRI2X_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void zsytri2x( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void zsytri2x_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;

void SSYTRI2X( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void SSYTRI2X_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void ssytri2x( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void ssytri2x_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;

void DSYTRI2X( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void DSYTRI2X_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void dsytri2x( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              const MKL_INT* nb, MKL_INT* info ) NOTHROW;
void dsytri2x_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               const MKL_INT* nb, MKL_INT* info ) NOTHROW;

void SLARTGP( const float* f, const float* g, float* cs, float* sn, float* r ) NOTHROW;
void SLARTGP_( const float* f, const float* g, float* cs, float* sn, float* r ) NOTHROW;
void slartgp( const float* f, const float* g, float* cs, float* sn, float* r ) NOTHROW;
void slartgp_( const float* f, const float* g, float* cs, float* sn, float* r ) NOTHROW;

void DLARTGP( const double* f, const double* g, double* cs, double* sn, double* r ) NOTHROW;
void DLARTGP_( const double* f, const double* g, double* cs, double* sn, double* r ) NOTHROW;
void dlartgp( const double* f, const double* g, double* cs, double* sn, double* r ) NOTHROW;
void dlartgp_( const double* f, const double* g, double* cs, double* sn, double* r ) NOTHROW;

void SLARTGS( const float* x, const float* y, const float* sigma, float* cs, float* sn ) NOTHROW;
void SLARTGS_( const float* x, const float* y, const float* sigma, float* cs, float* sn ) NOTHROW;
void slartgs( const float* x, const float* y, const float* sigma, float* cs, float* sn ) NOTHROW;
void slartgs_( const float* x, const float* y, const float* sigma, float* cs, float* sn ) NOTHROW;

void DLARTGS( const double* x, const double* y, const double* sigma, double* cs, double* sn ) NOTHROW;
void DLARTGS_( const double* x, const double* y, const double* sigma, double* cs, double* sn ) NOTHROW;
void dlartgs( const double* x, const double* y, const double* sigma, double* cs, double* sn ) NOTHROW;
void dlartgs_( const double* x, const double* y, const double* sigma, double* cs, double* sn ) NOTHROW;

void CSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void ZSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zsytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zsytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

void SSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info ) NOTHROW;
void SSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info ) NOTHROW;
void ssytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info ) NOTHROW;
void ssytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info ) NOTHROW;

void DSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info ) NOTHROW;
void DSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info ) NOTHROW;
void dsytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info ) NOTHROW;
void dsytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info ) NOTHROW;

void CHETRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void CHETRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void chetrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void chetrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;

void ZHETRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void ZHETRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zhetrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;
void zhetrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info ) NOTHROW;

/* LAPACK 3.2 routines */

void CBDSQR( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
             MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
             float* rwork, MKL_INT* info ) NOTHROW;
void CBDSQR_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
              MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
              float* rwork, MKL_INT* info ) NOTHROW;
void cbdsqr( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
             MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
             float* rwork, MKL_INT* info ) NOTHROW;
void cbdsqr_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
              MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
              float* rwork, MKL_INT* info ) NOTHROW;

void CGBBRD( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
             const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGBBRD_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
              const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbbrd( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
             const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbbrd_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
              const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGBCON( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGBCON_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbcon( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbcon_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGBEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info ) NOTHROW;
void CGBEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* r, float* c, float* rowcnd, float* colcnd, float* amax,
               MKL_INT* info ) NOTHROW;
void cgbequb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info ) NOTHROW;
void cgbequb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* r, float* c, float* rowcnd, float* colcnd, float* amax,
               MKL_INT* info ) NOTHROW;

void CGBEQU( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             float* r, float* c, float* rowcnd, float* colcnd, float* amax,
             MKL_INT* info ) NOTHROW;
void CGBEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info ) NOTHROW;
void cgbequ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             float* r, float* c, float* rowcnd, float* colcnd, float* amax,
             MKL_INT* info ) NOTHROW;
void cgbequ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info ) NOTHROW;

void CGBRFS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* afb,
             const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void CGBRFS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info ) NOTHROW;
void cgbrfs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* afb,
             const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void cgbrfs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info ) NOTHROW;

void CGBRFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, float* r, float* c,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGBRFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const MKL_Complex8* ab, const MKL_INT* ldab,
               const MKL_Complex8* afb, const MKL_INT* ldafb,
               const MKL_INT* ipiv, float* r, float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbrfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, float* r, float* c,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbrfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const MKL_Complex8* ab, const MKL_INT* ldab,
               const MKL_Complex8* afb, const MKL_INT* ldafb,
               const MKL_INT* ipiv, float* r, float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGBSV( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info ) NOTHROW;
void CGBSV_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void cgbsv( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info ) NOTHROW;
void cgbsv_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;

void CGBSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
             float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGBSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
             float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGBSVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGBSVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
               float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbsvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgbsvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
               float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGBTF2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CGBTF2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgbtf2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgbtf2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CGBTRF( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CGBTRF_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgbtrf( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgbtrf_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CGBTRS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CGBTRS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgbtrs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgbtrs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CGEBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
             const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_INT* info ) NOTHROW;
void CGEBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
              const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_INT* info ) NOTHROW;
void cgebak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
             const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_INT* info ) NOTHROW;
void cgebak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
              const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_INT* info ) NOTHROW;

void CGEBAL( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
             MKL_INT* info ) NOTHROW;
void CGEBAL_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
              MKL_INT* info ) NOTHROW;
void cgebal( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
             MKL_INT* info ) NOTHROW;
void cgebal_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
              MKL_INT* info ) NOTHROW;

void CGEBD2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGEBD2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgebd2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgebd2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGEBRD( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CGEBRD_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cgebrd( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cgebrd_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CGECON( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGECON_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgecon( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgecon_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGEEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info ) NOTHROW;
void CGEEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* r, float* c, float* rowcnd,
               float* colcnd, float* amax, MKL_INT* info ) NOTHROW;
void cgeequb( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info ) NOTHROW;
void cgeequb_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* r, float* c, float* rowcnd,
               float* colcnd, float* amax, MKL_INT* info ) NOTHROW;

void CGEEQU( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, float* r, float* c, float* rowcnd,
             float* colcnd, float* amax, MKL_INT* info ) NOTHROW;
void CGEEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info ) NOTHROW;
void cgeequ( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, float* r, float* c, float* rowcnd,
             float* colcnd, float* amax, MKL_INT* info ) NOTHROW;
void cgeequ_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info ) NOTHROW;

void CGEES( const char* jobvs, const char* sort,
            MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
            MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
            MKL_INT* info ) NOTHROW;
void CGEES_( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
             MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info ) NOTHROW;
void cgees( const char* jobvs, const char* sort,
            MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
            MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
            MKL_INT* info ) NOTHROW;
void cgees_( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
             MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info ) NOTHROW;

void CGEESX( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
             const MKL_INT* ldvs, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void CGEESX_( const char* jobvs, const char* sort,
              MKL_C_SELECT_FUNCTION_1 select, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
              const MKL_INT* ldvs, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cgeesx( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
             const MKL_INT* ldvs, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cgeesx_( const char* jobvs, const char* sort,
              MKL_C_SELECT_FUNCTION_1 select, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
              const MKL_INT* ldvs, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void CGEEV( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void CGEEV_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void cgeev( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void cgeev_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;

void CGEEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void CGEEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void cgeevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void cgeevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;

void CGEGS( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void CGEGS_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void cgegs( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void cgegs_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;

void CGEGV( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void CGEGV_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void cgegv( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void cgegv_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;

void CGEHD2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGEHD2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgehd2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgehd2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGEHRD( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEHRD_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgehrd( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgehrd_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGELQ2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void CGELQ2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void cgelq2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void cgelq2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;

void CGELQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGELQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgelqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgelqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGELSD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CGELSD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cgelsd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cgelsd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CGELS( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGELS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgels( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgels_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGELSS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void CGELSS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;
void cgelss( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void cgelss_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;

void CGELSX( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGELSX_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgelsx( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgelsx_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGELSY( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void CGELSY_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info ) NOTHROW;
void cgelsy( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void cgelsy_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info ) NOTHROW;

void CGEQL2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void CGEQL2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void cgeql2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void cgeql2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;

void CGEQLF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEQLF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqlf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqlf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGEQP3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void CGEQP3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;
void cgeqp3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void cgeqp3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;

void CGEQPF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGEQPF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgeqpf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgeqpf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGEQR2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void CGEQR2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void cgeqr2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void cgeqr2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;

void CGEQR2P( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void CGEQR2P_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;
void cgeqr2p( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void cgeqr2p_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               MKL_INT* info ) NOTHROW;

void CGEQRF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEQRF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqrf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqrf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGEQRFP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGEQRFP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqrfp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgeqrfp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGERFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void CGERFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cgerfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void cgerfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CGERFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* r, const float* c, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* berr, const MKL_INT* n_err_bnds,
              float* err_bnds_norm, float* err_bnds_comp,
              const MKL_INT* nparams, float* params, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void CGERFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* r, const float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgerfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* r, const float* c, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* berr, const MKL_INT* n_err_bnds,
              float* err_bnds_norm, float* err_bnds_comp,
              const MKL_INT* nparams, float* params, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cgerfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* r, const float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGERQ2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void CGERQ2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void cgerq2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void cgerq2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;

void CGERQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGERQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgerqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cgerqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGESC2( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             float* scale ) NOTHROW;
void CGESC2_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              float* scale ) NOTHROW;
void cgesc2( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             float* scale ) NOTHROW;
void cgesc2_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              float* scale ) NOTHROW;

void CGESDD( const char* jobz, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CGESDD_( const char* jobz, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cgesdd( const char* jobz, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cgesdd_( const char* jobz, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CGESVD( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
             const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void CGESVD_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
              const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info ) NOTHROW;
void cgesvd( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
             const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void cgesvd_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
              const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info ) NOTHROW;

void CGESV( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CGESV_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgesv( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgesv_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CGESVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv, char* equed,
             float* r, float* c, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGESVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cgesvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv, char* equed,
             float* r, float* c, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgesvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CGESVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGESVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* r, float* c, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgesvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgesvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* r, float* c, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGETC2( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info ) NOTHROW;
void CGETC2_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info ) NOTHROW;
void cgetc2( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info ) NOTHROW;
void cgetc2_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info ) NOTHROW;

void CGETF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CGETF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgetf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgetf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CGETRF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CGETRF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgetrf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void cgetrf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void MKL_CGETRFNPI( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void MKL_CGETRFNPI_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_cgetrfnpi( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_cgetrfnpi_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CGETRI( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CGETRI_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cgetri( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cgetri_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CGETRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CGETRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgetrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgetrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CGGBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
             const float* rscale, const MKL_INT* m, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void CGGBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
              const float* rscale, const MKL_INT* m, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void cggbak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
             const float* rscale, const MKL_INT* m, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void cggbak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
              const float* rscale, const MKL_INT* m, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_INT* info ) NOTHROW;

void CGGBAL( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* work, MKL_INT* info ) NOTHROW;
void CGGBAL_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* work, MKL_INT* info ) NOTHROW;
void cggbal( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* work, MKL_INT* info ) NOTHROW;
void cggbal_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* work, MKL_INT* info ) NOTHROW;

void CGGES( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void CGGES_( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cgges( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cgges_( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void CGGESX( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
             const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void CGGESX_( const char* jobvsl, const char* jobvsr, const char* sort,
              MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
              const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cggesx( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
             const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cggesx_( const char* jobvsl, const char* jobvsr, const char* sort,
              MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
              const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void CGGEV( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void CGGEV_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void cggev( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info ) NOTHROW;
void cggev_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;

void CGGEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* abnrm, float* bbnrm, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void CGGEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* abnrm, float* bbnrm, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cggevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* abnrm, float* bbnrm, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void cggevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* abnrm, float* bbnrm, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void CGGGLM( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
             MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CGGGLM_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
              MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cggglm( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
             MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cggglm_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
              MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CGGHRD( const char* compq, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_INT* info ) NOTHROW;
void CGGHRD_( const char* compq, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_INT* info ) NOTHROW;
void cgghrd( const char* compq, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_INT* info ) NOTHROW;
void cgghrd_( const char* compq, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_INT* info ) NOTHROW;

void CGGLSE( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
             MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CGGLSE_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
              MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cgglse( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
             MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cgglse_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
              MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CGGQRF( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGGQRF_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cggqrf( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cggqrf_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGGRQF( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CGGRQF_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cggrqf( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cggrqf_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CGGSVD( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
             MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CGGSVD_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
              MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cggsvd( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
             MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void cggsvd_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
              MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CGGSVP( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, const float* tola, const float* tolb,
             MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
             MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGGSVP_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
              MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cggsvp( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, const float* tola, const float* tolb,
             MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
             MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cggsvp_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
              MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGTCON( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du,
             const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CGTCON_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgtcon( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du,
             const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cgtcon_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CGTRFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* dlf,
             const MKL_Complex8* df, const MKL_Complex8* duf,
             const MKL_Complex8* du2, const MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CGTRFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* dlf,
              const MKL_Complex8* df, const MKL_Complex8* duf,
              const MKL_Complex8* du2, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cgtrfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* dlf,
             const MKL_Complex8* df, const MKL_Complex8* duf,
             const MKL_Complex8* du2, const MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void cgtrfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* dlf,
              const MKL_Complex8* df, const MKL_Complex8* duf,
              const MKL_Complex8* du2, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CGTSV( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
            MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CGTSV_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
             MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgtsv( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
            MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cgtsv_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
             MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CGTSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
             MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CGTSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
              MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgtsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
             MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cgtsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
              MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CGTTRF( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
             MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
             MKL_INT* info ) NOTHROW;
void CGTTRF_( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
              MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
              MKL_INT* info ) NOTHROW;
void cgttrf( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
             MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
             MKL_INT* info ) NOTHROW;
void cgttrf_( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
              MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
              MKL_INT* info ) NOTHROW;

void CGTTRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void CGTTRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info ) NOTHROW;
void cgttrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void cgttrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info ) NOTHROW;

void CGTTS2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void CGTTS2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void cgtts2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void cgtts2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;

void CHBEVD( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHBEVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void chbevd( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chbevd_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CHBEV( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info ) NOTHROW;
void CHBEV_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void chbev( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info ) NOTHROW;
void chbev_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;

void CHBEVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHBEVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chbevx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chbevx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHBGST( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CHBGST_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void chbgst( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void chbgst_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CHBGVD( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHBGVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void chbgvd( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chbgvd_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CHBGV( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
            const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
            float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info ) NOTHROW;
void CHBGV_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void chbgv( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
            const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
            float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info ) NOTHROW;
void chbgv_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;

void CHBGVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
             const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHBGVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
              const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chbgvx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
             const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chbgvx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
              const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHBTRD( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CHBTRD_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void chbtrd( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void chbtrd_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CHECON( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CHECON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void checon( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void checon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CHEEQUB( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CHEEQUB_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cheequb( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cheequb_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CHEEVD( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHEEVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void cheevd( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cheevd_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CHEEV( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void CHEEV_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void cheev( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void cheev_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;

void CHEEVR( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void CHEEVR_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void cheevr( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void cheevr_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CHEEVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHEEVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void cheevx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void cheevx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHEGS2( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHEGS2_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chegs2( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chegs2_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CHEGST( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHEGST_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chegst( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chegst_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CHEGVD( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHEGVD_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void chegvd( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chegvd_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CHEGV( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void CHEGV_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void chegv( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;
void chegv_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info ) NOTHROW;

void CHEGVX( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHEGVX_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chegvx( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chegvx_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHERFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void CHERFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cherfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void cherfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CHERFSX( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CHERFSX_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;
void cherfsx( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cherfsx_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;

void CHESV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHESV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chesv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHESVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void CHESVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;
void chesvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void chesvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;

void CHESVXX( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CHESVXX_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;
void chesvxx( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chesvxx_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;

void CHETD2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_INT* info ) NOTHROW;
void CHETD2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_INT* info ) NOTHROW;
void chetd2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_INT* info ) NOTHROW;
void chetd2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_INT* info ) NOTHROW;

void CHETF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CHETF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void chetf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void chetf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CHETRD( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRD_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrd_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CHETRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void chetrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CHETRI( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void CHETRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void chetri( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void chetri_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;

void CHETRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHETRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chetrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CHFRK( const char* transr, const char* uplo, const char* trans,
            const MKL_INT* n, const MKL_INT* k, const float* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
            MKL_Complex8* c ) NOTHROW;
void CHFRK_( const char* transr, const char* uplo, const char* trans,
             const MKL_INT* n, const MKL_INT* k, const float* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
             MKL_Complex8* c ) NOTHROW;
void chfrk( const char* transr, const char* uplo, const char* trans,
            const MKL_INT* n, const MKL_INT* k, const float* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
            MKL_Complex8* c ) NOTHROW;
void chfrk_( const char* transr, const char* uplo, const char* trans,
             const MKL_INT* n, const MKL_INT* k, const float* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
             MKL_Complex8* c ) NOTHROW;

void CHGEQZ( const char* job, const char* compq, const char* compz,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void CHGEQZ_( const char* job, const char* compq, const char* compz,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info ) NOTHROW;
void chgeqz( const char* job, const char* compq, const char* compz,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info ) NOTHROW;
void chgeqz_( const char* job, const char* compq, const char* compz,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info ) NOTHROW;

void CHLA_TRANSTYPE( char* ret_val, int ret_val_len, const MKL_INT* trans ) NOTHROW;
void CHLA_TRANSTYPE_( char* ret_val, int ret_val_len, const MKL_INT* trans ) NOTHROW;
void chla_transtype( char* ret_val, int ret_val_len, const MKL_INT* trans ) NOTHROW;
void chla_transtype_( char* ret_val, int ret_val_len, const MKL_INT* trans ) NOTHROW;

void CHPCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CHPCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void chpcon( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void chpcon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CHPEVD( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void CHPEVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void chpevd( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void chpevd_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CHPEV( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
            MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CHPEV_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chpev( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
            MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chpev_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CHPEVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, const float* vl,
             const float* vu, const MKL_INT* il, const MKL_INT* iu,
             const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CHPEVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu,
              const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chpevx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, const float* vl,
             const float* vu, const MKL_INT* il, const MKL_INT* iu,
             const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void chpevx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu,
              const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CHPGST( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info ) NOTHROW;
void CHPGST_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info ) NOTHROW;
void chpgst( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info ) NOTHROW;
void chpgst_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info ) NOTHROW;

void CHPGVD( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CHPGVD_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chpgvd( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void chpgvd_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CHPGV( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info ) NOTHROW;
void CHPGV_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void chpgv( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info ) NOTHROW;
void chpgv_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;

void CHPGVX( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_Complex8* bp, const float* vl, const float* vu,
             const MKL_INT* il, const MKL_INT* iu, const float* abstol,
             MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
             MKL_INT* info ) NOTHROW;
void CHPGVX_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_Complex8* bp, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, const float* abstol,
              MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
              MKL_INT* info ) NOTHROW;
void chpgvx( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_Complex8* bp, const float* vl, const float* vu,
             const MKL_INT* il, const MKL_INT* iu, const float* abstol,
             MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
             MKL_INT* info ) NOTHROW;
void chpgvx_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_Complex8* bp, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, const float* abstol,
              MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
              MKL_INT* info ) NOTHROW;

void CHPRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CHPRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chprfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chprfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CHPSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHPSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chpsv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chpsv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CHPSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CHPSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chpsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void chpsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CHPTRD( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
             float* e, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;
void CHPTRD_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
              float* e, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;
void chptrd( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
             float* e, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;
void chptrd_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
              float* e, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;

void CHPTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CHPTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void chptrf( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void chptrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CHPTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CHPTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void chptri( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void chptri_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CHPTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CHPTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chptrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void chptrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CHSEIN( const char* side, const char* eigsrc, const char* initv,
             const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info ) NOTHROW;
void CHSEIN_( const char* side, const char* eigsrc, const char* initv,
              const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info ) NOTHROW;
void chsein( const char* side, const char* eigsrc, const char* initv,
             const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info ) NOTHROW;
void chsein_( const char* side, const char* eigsrc, const char* initv,
              const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info ) NOTHROW;

void CHSEQR( const char* job, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CHSEQR_( const char* job, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void chseqr( const char* job, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void chseqr_( const char* job, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CLABRD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
             MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
             const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy ) NOTHROW;
void CLABRD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
              MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
              const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy ) NOTHROW;
void clabrd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
             MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
             const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy ) NOTHROW;
void clabrd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
              MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
              const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy ) NOTHROW;

void CLACGV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx ) NOTHROW;
void CLACGV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx ) NOTHROW;
void clacgv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx ) NOTHROW;
void clacgv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx ) NOTHROW;

void CLACN2( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase, MKL_INT* isave ) NOTHROW;
void CLACN2_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase, MKL_INT* isave ) NOTHROW;
void clacn2( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase, MKL_INT* isave ) NOTHROW;
void clacn2_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase, MKL_INT* isave ) NOTHROW;

void CLACON( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase ) NOTHROW;
void CLACON_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase ) NOTHROW;
void clacon( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase ) NOTHROW;
void clacon_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase ) NOTHROW;

void CLACP2( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const float* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb ) NOTHROW;
void CLACP2_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const float* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb ) NOTHROW;
void clacp2( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const float* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb ) NOTHROW;
void clacp2_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const float* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb ) NOTHROW;

void CLACPY( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb ) NOTHROW;
void CLACPY_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb ) NOTHROW;
void clacpy( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb ) NOTHROW;
void clacpy_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb ) NOTHROW;

void CLACRM( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;
void CLACRM_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;
void clacrm( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;
void clacrm_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;

void CLACRT( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
             MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
             const MKL_Complex8* s ) NOTHROW;
void CLACRT_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
              MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
              const MKL_Complex8* s ) NOTHROW;
void clacrt( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
             MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
             const MKL_Complex8* s ) NOTHROW;
void clacrt_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
              MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
              const MKL_Complex8* s ) NOTHROW;

void CLADIV( MKL_Complex8* ret_value, const MKL_Complex8* x,
             const MKL_Complex8* y ) NOTHROW;
void CLADIV_( MKL_Complex8* ret_value, const MKL_Complex8* x,
              const MKL_Complex8* y ) NOTHROW;
void cladiv( MKL_Complex8* ret_value, const MKL_Complex8* x,
             const MKL_Complex8* y ) NOTHROW;
void cladiv_( MKL_Complex8* ret_value, const MKL_Complex8* x,
              const MKL_Complex8* y ) NOTHROW;

void CLAED0( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
             const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void CLAED0_( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
              const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void claed0( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
             const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void claed0_( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
              const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;

void CLAED7( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
             const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, float* d, MKL_Complex8* q,
             const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
             float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const float* givnum, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CLAED7_( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
              const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, float* d, MKL_Complex8* q,
              const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
              float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const float* givnum, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void claed7( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
             const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, float* d, MKL_Complex8* q,
             const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
             float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const float* givnum, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void claed7_( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
              const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, float* d, MKL_Complex8* q,
              const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
              float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const float* givnum, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CLAED8( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
             MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
             const MKL_INT* cutpnt, const float* z, float* dlamda,
             MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
             MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
             MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info ) NOTHROW;
void CLAED8_( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
              MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
              const MKL_INT* cutpnt, const float* z, float* dlamda,
              MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
              MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
              MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info ) NOTHROW;
void claed8( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
             MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
             const MKL_INT* cutpnt, const float* z, float* dlamda,
             MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
             MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
             MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info ) NOTHROW;
void claed8_( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
              MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
              const MKL_INT* cutpnt, const float* z, float* dlamda,
              MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
              MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
              MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info ) NOTHROW;

void CLAEIN( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
             const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
             MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
             float* rwork, const float* eps3, const float* smlnum,
             MKL_INT* info ) NOTHROW;
void CLAEIN_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
              const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
              MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
              float* rwork, const float* eps3, const float* smlnum,
              MKL_INT* info ) NOTHROW;
void claein( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
             const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
             MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
             float* rwork, const float* eps3, const float* smlnum,
             MKL_INT* info ) NOTHROW;
void claein_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
              const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
              MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
              float* rwork, const float* eps3, const float* smlnum,
              MKL_INT* info ) NOTHROW;

void CLAESY( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
             MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 ) NOTHROW;
void CLAESY_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
              MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 ) NOTHROW;
void claesy( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
             MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 ) NOTHROW;
void claesy_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
              MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 ) NOTHROW;

void CLAEV2( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
             MKL_Complex8* sn1 ) NOTHROW;
void CLAEV2_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
              MKL_Complex8* sn1 ) NOTHROW;
void claev2( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
             MKL_Complex8* sn1 ) NOTHROW;
void claev2_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
              MKL_Complex8* sn1 ) NOTHROW;

void CLAG2Z( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
             const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
             MKL_INT* info ) NOTHROW;
void CLAG2Z_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
              const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void clag2z( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
             const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
             MKL_INT* info ) NOTHROW;
void clag2z_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
              const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;

void CLAGS2( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
             const float* a3, const float* b1, const MKL_Complex8* b2,
             const float* b3, float* csu, MKL_Complex8* snu, float* csv,
             MKL_Complex8* snv, float* csq, MKL_Complex8* snq ) NOTHROW;
void CLAGS2_( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
              const float* a3, const float* b1, const MKL_Complex8* b2,
              const float* b3, float* csu, MKL_Complex8* snu, float* csv,
              MKL_Complex8* snv, float* csq, MKL_Complex8* snq ) NOTHROW;
void clags2( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
             const float* a3, const float* b1, const MKL_Complex8* b2,
             const float* b3, float* csu, MKL_Complex8* snu, float* csv,
             MKL_Complex8* snv, float* csq, MKL_Complex8* snq ) NOTHROW;
void clags2_( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
              const float* a3, const float* b1, const MKL_Complex8* b2,
              const float* b3, float* csu, MKL_Complex8* snu, float* csv,
              MKL_Complex8* snv, float* csq, MKL_Complex8* snq ) NOTHROW;

void CLAGTM( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const float* alpha, const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* x, const MKL_INT* ldx,
             const float* beta, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void CLAGTM_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const float* alpha, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* x, const MKL_INT* ldx, const float* beta,
              MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void clagtm( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const float* alpha, const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* x, const MKL_INT* ldx,
             const float* beta, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void clagtm_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const float* alpha, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* x, const MKL_INT* ldx, const float* beta,
              MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;

void CLAHEF( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void CLAHEF_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clahef( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clahef_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void CLAHQR( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* info ) NOTHROW;
void CLAHQR_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* info ) NOTHROW;
void clahqr( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* info ) NOTHROW;
void clahqr_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* info ) NOTHROW;

void CLAHR2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy ) NOTHROW;
void CLAHR2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy ) NOTHROW;
void clahr2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy ) NOTHROW;
void clahr2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy ) NOTHROW;

void CLAHRD( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy ) NOTHROW;
void CLAHRD_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy ) NOTHROW;
void clahrd( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy ) NOTHROW;
void clahrd_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy ) NOTHROW;

void CLAIC1( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
             const float* sest, const MKL_Complex8* w,
             const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
             MKL_Complex8* c ) NOTHROW;
void CLAIC1_( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
              const float* sest, const MKL_Complex8* w,
              const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
              MKL_Complex8* c ) NOTHROW;
void claic1( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
             const float* sest, const MKL_Complex8* w,
             const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
             MKL_Complex8* c ) NOTHROW;
void claic1_( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
              const float* sest, const MKL_Complex8* w,
              const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
              MKL_Complex8* c ) NOTHROW;

void CLALS0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
             const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const float* givnum, const MKL_INT* ldgnum,
             const float* poles, const float* difl, const float* difr,
             const float* z, const MKL_INT* k, const float* c, const float* s,
             float* rwork, MKL_INT* info ) NOTHROW;
void CLALS0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
              const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const MKL_INT* ldgcol,
              const float* givnum, const MKL_INT* ldgnum, const float* poles,
              const float* difl, const float* difr, const float* z,
              const MKL_INT* k, const float* c, const float* s, float* rwork,
              MKL_INT* info ) NOTHROW;
void clals0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
             const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const float* givnum, const MKL_INT* ldgnum,
             const float* poles, const float* difl, const float* difr,
             const float* z, const MKL_INT* k, const float* c, const float* s,
             float* rwork, MKL_INT* info ) NOTHROW;
void clals0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
              const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const MKL_INT* ldgcol,
              const float* givnum, const MKL_INT* ldgnum, const float* poles,
              const float* difl, const float* difr, const float* z,
              const MKL_INT* k, const float* c, const float* s, float* rwork,
              MKL_INT* info ) NOTHROW;

void CLALSA( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
             const MKL_INT* ldu, const float* vt, const MKL_INT* k,
             const float* difl, const float* difr, const float* z,
             const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
             const float* c, const float* s, float* rwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void CLALSA_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
              const MKL_INT* ldu, const float* vt, const MKL_INT* k,
              const float* difl, const float* difr, const float* z,
              const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
              const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
              const float* c, const float* s, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void clalsa( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
             const MKL_INT* ldu, const float* vt, const MKL_INT* k,
             const float* difl, const float* difr, const float* z,
             const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
             const float* c, const float* s, float* rwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void clalsa_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
              const MKL_INT* ldu, const float* vt, const MKL_INT* k,
              const float* difl, const float* difr, const float* z,
              const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
              const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
              const float* c, const float* s, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;

void CLALSD( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
             const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CLALSD_( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
              const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;
void clalsd( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
             const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void clalsd_( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
              const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork,
              MKL_INT* info ) NOTHROW;

float CLANGB( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work ) NOTHROW;
float CLANGB_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work ) NOTHROW;
float clangb( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work ) NOTHROW;
float clangb_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work ) NOTHROW;

float CLANGE( const char* norm, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float CLANGE_( const char* norm, const MKL_INT* m, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float clange( const char* norm, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float clange_( const char* norm, const MKL_INT* m, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;

float CLANGT( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du ) NOTHROW;
float CLANGT_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
               const MKL_Complex8* d, const MKL_Complex8* du ) NOTHROW;
float clangt( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du ) NOTHROW;
float clangt_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
               const MKL_Complex8* d, const MKL_Complex8* du ) NOTHROW;

float CLANHB( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work ) NOTHROW;
float CLANHB_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work ) NOTHROW;
float clanhb( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work ) NOTHROW;
float clanhb_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work ) NOTHROW;

float CLANHE( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float CLANHE_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float clanhe( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float clanhe_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;

float CLANHF( const char* norm, const char* transr, const char* uplo,
              const MKL_INT* n, const MKL_Complex8* a, float* work ) NOTHROW;
float CLANHF_( const char* norm, const char* transr, const char* uplo,
               const MKL_INT* n, const MKL_Complex8* a, float* work ) NOTHROW;
float clanhf( const char* norm, const char* transr, const char* uplo,
              const MKL_INT* n, const MKL_Complex8* a, float* work ) NOTHROW;
float clanhf_( const char* norm, const char* transr, const char* uplo,
               const MKL_INT* n, const MKL_Complex8* a, float* work ) NOTHROW;

float CLANHP( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work ) NOTHROW;
float CLANHP_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work ) NOTHROW;
float clanhp( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work ) NOTHROW;
float clanhp_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work ) NOTHROW;

float CLANHS( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work ) NOTHROW;
float CLANHS_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work ) NOTHROW;
float clanhs( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work ) NOTHROW;
float clanhs_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work ) NOTHROW;

float CLANHT( const char* norm, const MKL_INT* n, const float* d,
              const MKL_Complex8* e ) NOTHROW;
float CLANHT_( const char* norm, const MKL_INT* n, const float* d,
               const MKL_Complex8* e ) NOTHROW;
float clanht( const char* norm, const MKL_INT* n, const float* d,
              const MKL_Complex8* e ) NOTHROW;
float clanht_( const char* norm, const MKL_INT* n, const float* d,
               const MKL_Complex8* e ) NOTHROW;

float CLANSB( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work ) NOTHROW;
float CLANSB_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work ) NOTHROW;
float clansb( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work ) NOTHROW;
float clansb_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work ) NOTHROW;

float CLANSP( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work ) NOTHROW;
float CLANSP_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work ) NOTHROW;
float clansp( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work ) NOTHROW;
float clansp_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work ) NOTHROW;

float CLANSY( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float CLANSY_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float clansy( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;
float clansy_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work ) NOTHROW;

float CLANTB( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* work ) NOTHROW;
float CLANTB_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
               const MKL_INT* ldab, float* work ) NOTHROW;
float clantb( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* work ) NOTHROW;
float clantb_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
               const MKL_INT* ldab, float* work ) NOTHROW;

float CLANTP( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* work ) NOTHROW;
float CLANTP_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_Complex8* ap, float* work ) NOTHROW;
float clantp( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* work ) NOTHROW;
float clantp_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_Complex8* ap, float* work ) NOTHROW;

float CLANTR( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work ) NOTHROW;
float CLANTR_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work ) NOTHROW;
float clantr( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work ) NOTHROW;
float clantr_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work ) NOTHROW;

void CLAPLL( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* ssmin ) NOTHROW;
void CLAPLL_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* ssmin ) NOTHROW;
void clapll( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* ssmin ) NOTHROW;
void clapll_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* ssmin ) NOTHROW;

void CLAPMT( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void CLAPMT_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void clapmt( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;
void clapmt_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k ) NOTHROW;

void CLAQGB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             const float* r, const float* c, const float* rowcnd,
             const float* colcnd, const float* amax, char* equed ) NOTHROW;
void CLAQGB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              const float* r, const float* c, const float* rowcnd,
              const float* colcnd, const float* amax, char* equed ) NOTHROW;
void claqgb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             const float* r, const float* c, const float* rowcnd,
             const float* colcnd, const float* amax, char* equed ) NOTHROW;
void claqgb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              const float* r, const float* c, const float* rowcnd,
              const float* colcnd, const float* amax, char* equed ) NOTHROW;

void CLAQGE( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* r, const float* c,
             const float* rowcnd, const float* colcnd, const float* amax,
             char* equed ) NOTHROW;
void CLAQGE_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* r, const float* c,
              const float* rowcnd, const float* colcnd, const float* amax,
              char* equed ) NOTHROW;
void claqge( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* r, const float* c,
             const float* rowcnd, const float* colcnd, const float* amax,
             char* equed ) NOTHROW;
void claqge_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* r, const float* c,
              const float* rowcnd, const float* colcnd, const float* amax,
              char* equed ) NOTHROW;

void CLAQHB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             const float* scond, const float* amax, char* equed ) NOTHROW;
void CLAQHB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              const float* scond, const float* amax, char* equed ) NOTHROW;
void claqhb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             const float* scond, const float* amax, char* equed ) NOTHROW;
void claqhb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              const float* scond, const float* amax, char* equed ) NOTHROW;

void CLAQHE( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed ) NOTHROW;
void CLAQHE_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed ) NOTHROW;
void claqhe( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed ) NOTHROW;
void claqhe_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed ) NOTHROW;

void CLAQHP( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed ) NOTHROW;
void CLAQHP_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed ) NOTHROW;
void claqhp( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed ) NOTHROW;
void claqhp_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed ) NOTHROW;

void CLAQP2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
             MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work ) NOTHROW;
void CLAQP2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
              MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work ) NOTHROW;
void claqp2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
             MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work ) NOTHROW;
void claqp2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
              MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work ) NOTHROW;

void CLAQPS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
             float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
             const MKL_INT* ldf ) NOTHROW;
void CLAQPS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
              float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
              const MKL_INT* ldf ) NOTHROW;
void claqps( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
             float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
             const MKL_INT* ldf ) NOTHROW;
void claqps_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
              float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
              const MKL_INT* ldf ) NOTHROW;

void CLAQR0( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CLAQR0_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void claqr0( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void claqr0_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CLAQR1( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
             const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v ) NOTHROW;
void CLAQR1_( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
              const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v ) NOTHROW;
void claqr1( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
             const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v ) NOTHROW;
void claqr1_( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
              const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v ) NOTHROW;

void CLAQR2( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;
void CLAQR2_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;
void claqr2( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;
void claqr2_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;

void CLAQR3( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;
void CLAQR3_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;
void claqr3( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;
void claqr3_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork ) NOTHROW;

void CLAQR4( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CLAQR4_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void claqr4( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void claqr4_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CLAQR5( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22,
             const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot,
             const MKL_INT* nshfts, MKL_Complex8* s, MKL_Complex8* h,
             const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* u, const MKL_INT* ldu,
             const MKL_INT* nv, MKL_Complex8* wv, const MKL_INT* ldwv,
             const MKL_INT* nh, MKL_Complex8* wh, const MKL_INT* ldwh ) NOTHROW;
void CLAQR5_( const MKL_INT* wantt, const MKL_INT* wantz,
              const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop,
              const MKL_INT* kbot, const MKL_INT* nshfts, MKL_Complex8* s,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* u,
              const MKL_INT* ldu, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, const MKL_INT* nh, MKL_Complex8* wh,
              const MKL_INT* ldwh ) NOTHROW;
void claqr5( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22,
             const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot,
             const MKL_INT* nshfts, MKL_Complex8* s, MKL_Complex8* h,
             const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* u, const MKL_INT* ldu,
             const MKL_INT* nv, MKL_Complex8* wv, const MKL_INT* ldwv,
             const MKL_INT* nh, MKL_Complex8* wh, const MKL_INT* ldwh ) NOTHROW;
void claqr5_( const MKL_INT* wantt, const MKL_INT* wantz,
              const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop,
              const MKL_INT* kbot, const MKL_INT* nshfts, MKL_Complex8* s,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* u,
              const MKL_INT* ldu, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, const MKL_INT* nh, MKL_Complex8* wh,
              const MKL_INT* ldwh ) NOTHROW;

void CLAQSB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
             const float* scond, const float* amax, char* equed ) NOTHROW;
void CLAQSB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
              const float* scond, const float* amax, char* equed ) NOTHROW;
void claqsb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
             const float* scond, const float* amax, char* equed ) NOTHROW;
void claqsb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
              const float* scond, const float* amax, char* equed ) NOTHROW;

void CLAQSP( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed ) NOTHROW;
void CLAQSP_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed ) NOTHROW;
void claqsp( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed ) NOTHROW;
void claqsp_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed ) NOTHROW;

void CLAQSY( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed ) NOTHROW;
void CLAQSY_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed ) NOTHROW;
void claqsy( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed ) NOTHROW;
void claqsy_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed ) NOTHROW;

void CLAR1V( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
             const float* lambda, const float* d, const float* l,
             const float* ld, const float* lld, const float* pivmin,
             const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
             MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
             MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
             float* work ) NOTHROW;
void CLAR1V_( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
              const float* lambda, const float* d, const float* l,
              const float* ld, const float* lld, const float* pivmin,
              const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
              MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
              MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
              float* work ) NOTHROW;
void clar1v( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
             const float* lambda, const float* d, const float* l,
             const float* ld, const float* lld, const float* pivmin,
             const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
             MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
             MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
             float* work ) NOTHROW;
void clar1v_( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
              const float* lambda, const float* d, const float* l,
              const float* ld, const float* lld, const float* pivmin,
              const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
              MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
              MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
              float* work ) NOTHROW;

void CLAR2V( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
             MKL_Complex8* z, const MKL_INT* incx, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;
void CLAR2V_( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
              MKL_Complex8* z, const MKL_INT* incx, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;
void clar2v( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
             MKL_Complex8* z, const MKL_INT* incx, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;
void clar2v_( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
              MKL_Complex8* z, const MKL_INT* incx, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;

void CLARCM( const MKL_INT* m, const MKL_INT* n, const float* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;
void CLARCM_( const MKL_INT* m, const MKL_INT* n, const float* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;
void clarcm( const MKL_INT* m, const MKL_INT* n, const float* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;
void clarcm_( const MKL_INT* m, const MKL_INT* n, const float* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork ) NOTHROW;

void CLARFB( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork ) NOTHROW;
void CLARFB_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork ) NOTHROW;
void clarfb( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork ) NOTHROW;
void clarfb_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork ) NOTHROW;

void CLARF( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work ) NOTHROW;
void CLARF_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work ) NOTHROW;
void clarf( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work ) NOTHROW;
void clarf_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work ) NOTHROW;

void CLARFG( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void CLARFG_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void clarfg( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void clarfg_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;

void CLARFGP( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void CLARFGP_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
               const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void clarfgp( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void clarfgp_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
               const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;

void CLARFP( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void CLARFP_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void clarfp( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;
void clarfp_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau ) NOTHROW;

void CLARFT( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;
void CLARFT_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;
void clarft( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;
void clarft_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;

void CLARFX( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void CLARFX_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void clarfx( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void clarfx_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;

void CLARGV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* c,
             const MKL_INT* incc ) NOTHROW;
void CLARGV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* c,
              const MKL_INT* incc ) NOTHROW;
void clargv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* c,
             const MKL_INT* incc ) NOTHROW;
void clargv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* c,
              const MKL_INT* incc ) NOTHROW;

void CLARNV( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
             MKL_Complex8* x ) NOTHROW;
void CLARNV_( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
              MKL_Complex8* x ) NOTHROW;
void clarnv( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
             MKL_Complex8* x ) NOTHROW;
void clarnv_( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
              MKL_Complex8* x ) NOTHROW;

void CLARRV( const MKL_INT* n, const float* vl, const float* vu, float* d,
             float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
             const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
             const float* rtol1, const float* rtol2, float* w, float* werr,
             float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
             const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CLARRV_( const MKL_INT* n, const float* vl, const float* vu, float* d,
              float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
              const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
              const float* rtol1, const float* rtol2, float* w, float* werr,
              float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
              const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void clarrv( const MKL_INT* n, const float* vl, const float* vu, float* d,
             float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
             const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
             const float* rtol1, const float* rtol2, float* w, float* werr,
             float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
             const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void clarrv_( const MKL_INT* n, const float* vl, const float* vu, float* d,
              float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
              const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
              const float* rtol1, const float* rtol2, float* w, float* werr,
              float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
              const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CLARSCL2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx ) NOTHROW;
void CLARSCL2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
                const MKL_INT* ldx ) NOTHROW;
void clarscl2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx ) NOTHROW;
void clarscl2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx ) NOTHROW;

void CLARTG( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
             MKL_Complex8* sn, MKL_Complex8* r ) NOTHROW;
void CLARTG_( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
              MKL_Complex8* sn, MKL_Complex8* r ) NOTHROW;
void clartg( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
             MKL_Complex8* sn, MKL_Complex8* r ) NOTHROW;
void clartg_( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
              MKL_Complex8* sn, MKL_Complex8* r ) NOTHROW;

void CLARTV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;
void CLARTV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;
void clartv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;
void clartv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc ) NOTHROW;

void CLARZB( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
             const MKL_INT* ldwork ) NOTHROW;
void CLARZB_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
              const MKL_INT* ldwork ) NOTHROW;
void clarzb( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
             const MKL_INT* ldwork ) NOTHROW;
void clarzb_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
              const MKL_INT* ldwork ) NOTHROW;

void CLARZ( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work ) NOTHROW;
void CLARZ_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work ) NOTHROW;
void clarz( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work ) NOTHROW;
void clarz_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work ) NOTHROW;

void CLARZT( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;
void CLARZT_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;
void clarzt( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;
void clarzt_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt ) NOTHROW;

void CLASCL( const char* type, const MKL_INT* kl, const MKL_INT* ku,
             const float* cfrom, const float* cto, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info ) NOTHROW;
void CLASCL_( const char* type, const MKL_INT* kl, const MKL_INT* ku,
              const float* cfrom, const float* cto, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void clascl( const char* type, const MKL_INT* kl, const MKL_INT* ku,
             const float* cfrom, const float* cto, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info ) NOTHROW;
void clascl_( const char* type, const MKL_INT* kl, const MKL_INT* ku,
              const float* cfrom, const float* cto, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;

void CLASCL2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
              const MKL_INT* ldx ) NOTHROW;
void CLASCL2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx ) NOTHROW;
void clascl2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
              const MKL_INT* ldx ) NOTHROW;
void clascl2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx ) NOTHROW;

void CLASET( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* alpha, const MKL_Complex8* beta,
             MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;
void CLASET_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* alpha, const MKL_Complex8* beta,
              MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;
void claset( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* alpha, const MKL_Complex8* beta,
             MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;
void claset_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* alpha, const MKL_Complex8* beta,
              MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;

void CLASR( const char* side, const char* pivot, const char* direct,
            const MKL_INT* m, const MKL_INT* n, const float* c, const float* s,
            MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;
void CLASR_( const char* side, const char* pivot, const char* direct,
             const MKL_INT* m, const MKL_INT* n, const float* c,
             const float* s, MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;
void clasr( const char* side, const char* pivot, const char* direct,
            const MKL_INT* m, const MKL_INT* n, const float* c, const float* s,
            MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;
void clasr_( const char* side, const char* pivot, const char* direct,
             const MKL_INT* m, const MKL_INT* n, const float* c,
             const float* s, MKL_Complex8* a, const MKL_INT* lda ) NOTHROW;

void CLASSQ( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
             float* scale, float* sumsq ) NOTHROW;
void CLASSQ_( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
              float* scale, float* sumsq ) NOTHROW;
void classq( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
             float* scale, float* sumsq ) NOTHROW;
void classq_( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
              float* scale, float* sumsq ) NOTHROW;

void CLASWP( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
             const MKL_INT* incx ) NOTHROW;
void CLASWP_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
              const MKL_INT* incx ) NOTHROW;
void claswp( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
             const MKL_INT* incx ) NOTHROW;
void claswp_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
              const MKL_INT* incx ) NOTHROW;

void CLASYF( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void CLASYF_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clasyf( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;
void clasyf_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info ) NOTHROW;

void CLATBS( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
             float* scale, float* cnorm, MKL_INT* info ) NOTHROW;
void CLATBS_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
              float* scale, float* cnorm, MKL_INT* info ) NOTHROW;
void clatbs( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
             float* scale, float* cnorm, MKL_INT* info ) NOTHROW;
void clatbs_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
              float* scale, float* cnorm, MKL_INT* info ) NOTHROW;

void CLATDF( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
             float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv ) NOTHROW;
void CLATDF_( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
              float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv ) NOTHROW;
void clatdf( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
             float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv ) NOTHROW;
void clatdf_( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
              float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv ) NOTHROW;

void CLATPS( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info ) NOTHROW;
void CLATPS_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info ) NOTHROW;
void clatps( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info ) NOTHROW;
void clatps_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info ) NOTHROW;

void CLATRD( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
             MKL_Complex8* w, const MKL_INT* ldw ) NOTHROW;
void CLATRD_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
              MKL_Complex8* w, const MKL_INT* ldw ) NOTHROW;
void clatrd( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
             MKL_Complex8* w, const MKL_INT* ldw ) NOTHROW;
void clatrd_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
              MKL_Complex8* w, const MKL_INT* ldw ) NOTHROW;

void CLATRS( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
             MKL_INT* info ) NOTHROW;
void CLATRS_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
              MKL_INT* info ) NOTHROW;
void clatrs( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
             MKL_INT* info ) NOTHROW;
void clatrs_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
              MKL_INT* info ) NOTHROW;

void CLATRZ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work ) NOTHROW;
void CLATRZ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work ) NOTHROW;
void clatrz( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work ) NOTHROW;
void clatrz_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work ) NOTHROW;

void CLATZM( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
             const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void CLATZM_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_INT* incv,
              const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
              const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void clatzm( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
             const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;
void clatzm_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_INT* incv,
              const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
              const MKL_INT* ldc, MKL_Complex8* work ) NOTHROW;

void CLAUU2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CLAUU2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void clauu2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void clauu2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CLAUUM( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CLAUUM_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void clauum( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void clauum_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CPBCON( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPBCON_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cpbcon( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cpbcon_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPBEQU( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             float* scond, float* amax, MKL_INT* info ) NOTHROW;
void CPBEQU_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cpbequ( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cpbequ_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              float* scond, float* amax, MKL_INT* info ) NOTHROW;

void CPBRFS( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* afb, const MKL_INT* ldafb,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CPBRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cpbrfs( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* afb, const MKL_INT* ldafb,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void cpbrfs_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CPBSTF( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void CPBSTF_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void cpbstf( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void cpbstf_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;

void CPBSV( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPBSV_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpbsv( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpbsv_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPBSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPBSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cpbsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cpbsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPBTF2( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void CPBTF2_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void cpbtf2( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void cpbtf2_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;

void CPBTRF( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void CPBTRF_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void cpbtrf( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;
void cpbtrf_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info ) NOTHROW;

void CPBTRS( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPBTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpbtrs( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpbtrs_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPFTRF( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void CPFTRF_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void cpftrf( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void cpftrf_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info ) NOTHROW;

void CPFTRI( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void CPFTRI_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void cpftri( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void cpftri_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info ) NOTHROW;

void CPFTRS( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPFTRS_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpftrs( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpftrs_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPOCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPOCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cpocon( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cpocon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPOEQUB( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void CPOEQUB_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
               float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cpoequb( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cpoequb_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
               float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;

void CPOEQU( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void CPOEQU_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cpoequ( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cpoequ_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;

void CPORFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPORFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cporfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cporfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CPORFSX( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, float* s,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPORFSX_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf, float* s,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cporfsx( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, float* s,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cporfsx_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf, float* s,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPOSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPOSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cposv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cposv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPOSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPOSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cposvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cposvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPOSVXX( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPOSVXX_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cposvxx( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cposvxx_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPOTF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CPOTF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void cpotf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void cpotf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CPOTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CPOTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void cpotrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void cpotrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CPOTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CPOTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void cpotri( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void cpotri_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CPOTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPOTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpotrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpotrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPPCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const float* anorm, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CPPCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const float* anorm, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cppcon( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const float* anorm, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void cppcon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const float* anorm, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CPPEQU( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void CPPEQU_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cppequ( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;
void cppequ_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              float* s, float* scond, float* amax, MKL_INT* info ) NOTHROW;

void CPPRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CPPRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void cpprfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void cpprfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CPPSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info ) NOTHROW;
void CPPSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void cppsv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info ) NOTHROW;
void cppsv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;

void CPPSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPPSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cppsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cppsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPPTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info ) NOTHROW;
void CPPTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info ) NOTHROW;
void cpptrf( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info ) NOTHROW;
void cpptrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info ) NOTHROW;

void CPPTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info ) NOTHROW;
void CPPTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info ) NOTHROW;
void cpptri( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info ) NOTHROW;
void cpptri_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info ) NOTHROW;

void CPPTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void CPPTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info ) NOTHROW;
void cpptrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void cpptrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info ) NOTHROW;

void CPSTF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info ) NOTHROW;
void CPSTF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info ) NOTHROW;
void cpstf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info ) NOTHROW;
void cpstf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info ) NOTHROW;

void CPSTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info ) NOTHROW;
void CPSTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info ) NOTHROW;
void cpstrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info ) NOTHROW;
void cpstrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info ) NOTHROW;

void CPTCON( const MKL_INT* n, const float* d, const MKL_Complex8* e,
             const float* anorm, float* rcond, float* rwork, MKL_INT* info ) NOTHROW;
void CPTCON_( const MKL_INT* n, const float* d, const MKL_Complex8* e,
              const float* anorm, float* rcond, float* rwork, MKL_INT* info ) NOTHROW;
void cptcon( const MKL_INT* n, const float* d, const MKL_Complex8* e,
             const float* anorm, float* rcond, float* rwork, MKL_INT* info ) NOTHROW;
void cptcon_( const MKL_INT* n, const float* d, const MKL_Complex8* e,
              const float* anorm, float* rcond, float* rwork, MKL_INT* info ) NOTHROW;

void CPTEQR( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info ) NOTHROW;
void CPTEQR_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info ) NOTHROW;
void cpteqr( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info ) NOTHROW;
void cpteqr_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info ) NOTHROW;

void CPTRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, const float* df,
             const MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPTRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, const float* df,
              const MKL_Complex8* ef, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info ) NOTHROW;
void cptrfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, const float* df,
             const MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cptrfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, const float* df,
              const MKL_Complex8* ef, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info ) NOTHROW;

void CPTSV( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPTSV_( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cptsv( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cptsv_( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPTSVX( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, float* df,
             MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CPTSVX_( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, float* df,
              MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cptsvx( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, float* df,
             MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cptsvx_( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, float* df,
              MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CPTTRF( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info ) NOTHROW;
void CPTTRF_( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info ) NOTHROW;
void cpttrf( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info ) NOTHROW;
void cpttrf_( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info ) NOTHROW;

void CPTTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CPTTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpttrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cpttrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CPTTS2( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb ) NOTHROW;
void CPTTS2_( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb ) NOTHROW;
void cptts2( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb ) NOTHROW;
void cptts2_( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb ) NOTHROW;

void CROT( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
           MKL_Complex8* cy, const MKL_INT* incy, const float* c,
           const MKL_Complex8* s ) NOTHROW;
void CROT_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
            MKL_Complex8* cy, const MKL_INT* incy, const float* c,
            const MKL_Complex8* s ) NOTHROW;
void crot( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
           MKL_Complex8* cy, const MKL_INT* incy, const float* c,
           const MKL_Complex8* s ) NOTHROW;
void crot_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
            MKL_Complex8* cy, const MKL_INT* incy, const float* c,
            const MKL_Complex8* s ) NOTHROW;

void CSPCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CSPCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cspcon( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cspcon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CSPMV( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* ap, const MKL_Complex8* x, const MKL_INT* incx,
            const MKL_Complex8* beta, MKL_Complex8* y, const MKL_INT* incy ) NOTHROW;
void CSPMV_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* ap, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy ) NOTHROW;
void cspmv( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* ap, const MKL_Complex8* x, const MKL_INT* incx,
            const MKL_Complex8* beta, MKL_Complex8* y, const MKL_INT* incy ) NOTHROW;
void cspmv_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* ap, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy ) NOTHROW;

void CSPR( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap ) NOTHROW;
void CSPR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap ) NOTHROW;
void cspr( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap ) NOTHROW;
void cspr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap ) NOTHROW;

void CSPRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CSPRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void csprfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void csprfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CSPSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CSPSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cspsv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void cspsv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CSPSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CSPSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cspsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void cspsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CSPTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CSPTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csptrf( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csptrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CSPTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CSPTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csptri( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csptri_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CSPTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CSPTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csptrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csptrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CSRSCL( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
             const MKL_INT* incx ) NOTHROW;
void CSRSCL_( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
              const MKL_INT* incx ) NOTHROW;
void csrscl( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
             const MKL_INT* incx ) NOTHROW;
void csrscl_( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
              const MKL_INT* incx ) NOTHROW;

void CSTEDC( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CSTEDC_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cstedc( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cstedc_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CSTEGR( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void CSTEGR_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              float* work, const MKL_INT* lwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cstegr( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void cstegr_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              float* work, const MKL_INT* lwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CSTEIN( const MKL_INT* n, const float* d, const float* e,
             const MKL_INT* m, const float* w, const MKL_INT* iblock,
             const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
             float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void CSTEIN_( const MKL_INT* n, const float* d, const float* e,
              const MKL_INT* m, const float* w, const MKL_INT* iblock,
              const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
              float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void cstein( const MKL_INT* n, const float* d, const float* e,
             const MKL_INT* m, const float* w, const MKL_INT* iblock,
             const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
             float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;
void cstein_( const MKL_INT* n, const float* d, const float* e,
              const MKL_INT* m, const float* w, const MKL_INT* iblock,
              const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
              float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info ) NOTHROW;

void CSTEMR( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
             MKL_INT* tryrac, float* work, const MKL_INT* lwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void CSTEMR_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
              MKL_INT* tryrac, float* work, const MKL_INT* lwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cstemr( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
             MKL_INT* tryrac, float* work, const MKL_INT* lwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;
void cstemr_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
              MKL_INT* tryrac, float* work, const MKL_INT* lwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info ) NOTHROW;

void CSTEQR( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info ) NOTHROW;
void CSTEQR_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info ) NOTHROW;
void csteqr( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info ) NOTHROW;
void csteqr_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info ) NOTHROW;

void CSYCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CSYCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csycon( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csycon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CSYEQUB( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CSYEQUB_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csyequb( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void csyequb_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CSYMV( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
            const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
            const MKL_INT* incy ) NOTHROW;
void CSYMV_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy ) NOTHROW;
void csymv( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
            const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
            const MKL_INT* incy ) NOTHROW;
void csymv_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy ) NOTHROW;

void CSYR( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
           const MKL_INT* lda ) NOTHROW;
void CSYR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
            const MKL_INT* lda ) NOTHROW;
void csyr( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
           const MKL_INT* lda ) NOTHROW;
void csyr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
            const MKL_INT* lda ) NOTHROW;

void CSYRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void CSYRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void csyrfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void csyrfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CSYRFSX( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CSYRFSX_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;
void csyrfsx( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void csyrfsx_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;

void CSYSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csysv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void CSYSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;
void csysvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info ) NOTHROW;
void csysvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info ) NOTHROW;

void CSYSVXX( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CSYSVXX_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;
void csysvxx( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void csysvxx_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info ) NOTHROW;

void CSYTF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void CSYTF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csytf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void csytf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void CSYTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CSYTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void csytrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CSYTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void CSYTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;
void csytri( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info ) NOTHROW;
void csytri_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info ) NOTHROW;

void CSYTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CSYTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void csytrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CTBCON( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
             const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CTBCON_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void ctbcon( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
             const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void ctbcon_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CTBRFS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CTBRFS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void ctbrfs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void ctbrfs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CTBTRS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CTBTRS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ctbtrs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ctbtrs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CTFSM( const char* transr, const char* side, const char* uplo,
            const char* trans, const char* diag, const MKL_INT* m,
            const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* a,
            MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void CTFSM_( const char* transr, const char* side, const char* uplo,
             const char* trans, const char* diag, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void ctfsm( const char* transr, const char* side, const char* uplo,
            const char* trans, const char* diag, const MKL_INT* m,
            const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* a,
            MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;
void ctfsm_( const char* transr, const char* side, const char* uplo,
             const char* trans, const char* diag, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, MKL_Complex8* b, const MKL_INT* ldb ) NOTHROW;

void CTFTRI( const char* transr, const char* uplo, const char* diag,
             const MKL_INT* n, MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void CTFTRI_( const char* transr, const char* uplo, const char* diag,
              const MKL_INT* n, MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void ctftri( const char* transr, const char* uplo, const char* diag,
             const MKL_INT* n, MKL_Complex8* a, MKL_INT* info ) NOTHROW;
void ctftri_( const char* transr, const char* uplo, const char* diag,
              const MKL_INT* n, MKL_Complex8* a, MKL_INT* info ) NOTHROW;

void CTFTTP( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void CTFTTP_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void ctfttp( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void ctfttp_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;

void CTFTTR( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info ) NOTHROW;
void CTFTTR_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;
void ctfttr( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info ) NOTHROW;
void ctfttr_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info ) NOTHROW;

void CTGEVC( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
             const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void CTGEVC_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
              const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* info ) NOTHROW;
void ctgevc( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
             const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* info ) NOTHROW;
void ctgevc_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
              const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* info ) NOTHROW;

void CTGEX2( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
             MKL_INT* info ) NOTHROW;
void CTGEX2_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
              MKL_INT* info ) NOTHROW;
void ctgex2( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
             MKL_INT* info ) NOTHROW;
void ctgex2_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
              MKL_INT* info ) NOTHROW;

void CTGEXC( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
             MKL_INT* ilst, MKL_INT* info ) NOTHROW;
void CTGEXC_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
              MKL_INT* ilst, MKL_INT* info ) NOTHROW;
void ctgexc( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
             MKL_INT* ilst, MKL_INT* info ) NOTHROW;
void ctgexc_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
              MKL_INT* ilst, MKL_INT* info ) NOTHROW;

void CTGSEN( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
             const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void CTGSEN_( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
              const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;
void ctgsen( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
             const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info ) NOTHROW;
void ctgsen_( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
              const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info ) NOTHROW;

void CTGSJA( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* tola, const float* tolb, float* alpha, float* beta,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info ) NOTHROW;
void CTGSJA_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* tola, const float* tolb, float* alpha, float* beta,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info ) NOTHROW;
void ctgsja( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* tola, const float* tolb, float* alpha, float* beta,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info ) NOTHROW;
void ctgsja_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* tola, const float* tolb, float* alpha, float* beta,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info ) NOTHROW;

void CTGSNA( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* vl,
             const MKL_INT* ldvl, const MKL_Complex8* vr, const MKL_INT* ldvr,
             float* s, float* dif, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void CTGSNA_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* dif, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ctgsna( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* vl,
             const MKL_INT* ldvl, const MKL_Complex8* vr, const MKL_INT* ldvr,
             float* s, float* dif, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void ctgsna_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* dif, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CTGSY2( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
             MKL_INT* info ) NOTHROW;
void CTGSY2_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
              MKL_INT* info ) NOTHROW;
void ctgsy2( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
             MKL_INT* info ) NOTHROW;
void ctgsy2_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
              MKL_INT* info ) NOTHROW;

void CTGSYL( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void CTGSYL_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ctgsyl( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void ctgsyl_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void CTPCON( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CTPCON_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctpcon( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctpcon_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CTPRFS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void CTPRFS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;
void ctprfs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info ) NOTHROW;
void ctprfs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info ) NOTHROW;

void CTPTRI( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void CTPTRI_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void ctptri( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void ctptri_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* ap, MKL_INT* info ) NOTHROW;

void CTPTRS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void CTPTRS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ctptrs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void ctptrs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void CTPTTF( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info ) NOTHROW;
void CTPTTF_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info ) NOTHROW;
void ctpttf( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info ) NOTHROW;
void ctpttf_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info ) NOTHROW;

void CTPTTR( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CTPTTR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void ctpttr( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void ctpttr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CTRCON( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CTRCON_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctrcon( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctrcon_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CTREVC( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CTREVC_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctrevc( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctrevc_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CTREXC( const char* compq, const MKL_INT* n, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
             const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info ) NOTHROW;
void CTREXC_( const char* compq, const MKL_INT* n, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
              const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info ) NOTHROW;
void ctrexc( const char* compq, const MKL_INT* n, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
             const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info ) NOTHROW;
void ctrexc_( const char* compq, const MKL_INT* n, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
              const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info ) NOTHROW;

void CTRRFS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void CTRRFS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctrrfs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;
void ctrrfs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info ) NOTHROW;

void CTRSEN( const char* job, const char* compq, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
             float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CTRSEN_( const char* job, const char* compq, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
              float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void ctrsen( const char* job, const char* compq, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
             float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void ctrsen_( const char* job, const char* compq, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
              float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CTRSNA( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
             const MKL_Complex8* vl, const MKL_INT* ldvl,
             const MKL_Complex8* vr, const MKL_INT* ldvr, float* s, float* sep,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
             const MKL_INT* ldwork, float* rwork, MKL_INT* info ) NOTHROW;
void CTRSNA_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* sep, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* ldwork, float* rwork, MKL_INT* info ) NOTHROW;
void ctrsna( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
             const MKL_Complex8* vl, const MKL_INT* ldvl,
             const MKL_Complex8* vr, const MKL_INT* ldvr, float* s, float* sep,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
             const MKL_INT* ldwork, float* rwork, MKL_INT* info ) NOTHROW;
void ctrsna_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* sep, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* ldwork, float* rwork, MKL_INT* info ) NOTHROW;

void CTRSYL( const char* trana, const char* tranb, const MKL_INT* isgn,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* scale,
             MKL_INT* info ) NOTHROW;
void CTRSYL_( const char* trana, const char* tranb, const MKL_INT* isgn,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* scale,
              MKL_INT* info ) NOTHROW;
void ctrsyl( const char* trana, const char* tranb, const MKL_INT* isgn,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* scale,
             MKL_INT* info ) NOTHROW;
void ctrsyl_( const char* trana, const char* tranb, const MKL_INT* isgn,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* scale,
              MKL_INT* info ) NOTHROW;

void CTRTI2( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CTRTI2_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void ctrti2( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void ctrti2_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CTRTRI( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void CTRTRI_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void ctrtri( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void ctrtri_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void CTRTRS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void CTRTRS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info ) NOTHROW;
void ctrtrs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void ctrtrs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info ) NOTHROW;

void CTRTTF( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
             MKL_INT* info ) NOTHROW;
void CTRTTF_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
              MKL_INT* info ) NOTHROW;
void ctrttf( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
             MKL_INT* info ) NOTHROW;
void ctrttf_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
              MKL_INT* info ) NOTHROW;

void CTRTTP( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void CTRTTP_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void ctrttp( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;
void ctrttp_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info ) NOTHROW;

void CTZRQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;
void CTZRQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;
void ctzrqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;
void ctzrqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info ) NOTHROW;

void CTZRZF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CTZRZF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ctzrzf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void ctzrzf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNG2L( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNG2L_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cung2l( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cung2l_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNG2R( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNG2R_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cung2r( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cung2r_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNGBR( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNGBR_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungbr( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cungbr_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNGHR( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNGHR_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunghr( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunghr_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNGL2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNGL2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cungl2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cungl2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNGLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNGLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunglq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunglq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNGQL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNGQL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungql( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungql_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNGQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNGQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNGR2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNGR2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cungr2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cungr2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNGRQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNGRQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungrq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungrq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNGTR( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNGTR_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungtr( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cungtr_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNM2L( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNM2L_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunm2l( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunm2l_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNM2R( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNM2R_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunm2r( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunm2r_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNMBR( const char* vect, const char* side, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNMBR_( const char* vect, const char* side, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunmbr( const char* vect, const char* side, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunmbr_( const char* vect, const char* side, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNMHR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNMHR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunmhr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunmhr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNML2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNML2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunml2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunml2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunmlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cunmlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CUNMQL( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNMQL_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunmql( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cunmql_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CUNMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunmqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cunmqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CUNMR2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNMR2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunmr2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunmr2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNMR3( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUNMR3_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunmr3( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cunmr3_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUNMRQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNMRQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunmrq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cunmrq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CUNMRZ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void CUNMRZ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunmrz( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void cunmrz_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void CUNMTR( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void CUNMTR_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void cunmtr( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void cunmtr_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void CUPGTR( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUPGTR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cupgtr( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cupgtr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void CUPMTR( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void CUPMTR_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cupmtr( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info ) NOTHROW;
void cupmtr_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info ) NOTHROW;

void DBDSDC( const char* uplo, const char* compq, const MKL_INT* n, double* d,
             double* e, double* u, const MKL_INT* ldu, double* vt,
             const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DBDSDC_( const char* uplo, const char* compq, const MKL_INT* n, double* d,
              double* e, double* u, const MKL_INT* ldu, double* vt,
              const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dbdsdc( const char* uplo, const char* compq, const MKL_INT* n, double* d,
             double* e, double* u, const MKL_INT* ldu, double* vt,
             const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dbdsdc_( const char* uplo, const char* compq, const MKL_INT* n, double* d,
              double* e, double* u, const MKL_INT* ldu, double* vt,
              const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DBDSQR( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
             double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
             double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void DBDSQR_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
              double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void dbdsqr( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
             double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
             double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void dbdsqr_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
              double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;

void DDISNA( const char* job, const MKL_INT* m, const MKL_INT* n,
             const double* d, double* sep, MKL_INT* info ) NOTHROW;
void DDISNA_( const char* job, const MKL_INT* m, const MKL_INT* n,
              const double* d, double* sep, MKL_INT* info ) NOTHROW;
void ddisna( const char* job, const MKL_INT* m, const MKL_INT* n,
             const double* d, double* sep, MKL_INT* info ) NOTHROW;
void ddisna_( const char* job, const MKL_INT* m, const MKL_INT* n,
              const double* d, double* sep, MKL_INT* info ) NOTHROW;

void DGBBRD( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
             const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
             const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void DGBBRD_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
              const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
              const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void dgbbrd( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
             const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
             const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;
void dgbbrd_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
              const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
              const MKL_INT* ldc, double* work, MKL_INT* info ) NOTHROW;

void DGBCON( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGBCON_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbcon( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbcon_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGBEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info ) NOTHROW;
void DGBEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
               double* r, double* c, double* rowcnd, double* colcnd,
               double* amax, MKL_INT* info ) NOTHROW;
void dgbequb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info ) NOTHROW;
void dgbequb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
               double* r, double* c, double* rowcnd, double* colcnd,
               double* amax, MKL_INT* info ) NOTHROW;

void DGBEQU( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             double* r, double* c, double* rowcnd, double* colcnd,
             double* amax, MKL_INT* info ) NOTHROW;
void DGBEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info ) NOTHROW;
void dgbequ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             double* r, double* c, double* rowcnd, double* colcnd,
             double* amax, MKL_INT* info ) NOTHROW;
void dgbequ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info ) NOTHROW;

void DGBRFS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
             const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
             double* x, const MKL_INT* ldx, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGBRFS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
              double* x, const MKL_INT* ldx, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbrfs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
             const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
             double* x, const MKL_INT* ldx, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbrfs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
              double* x, const MKL_INT* ldx, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGBRFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const double* ab, const MKL_INT* ldab, const double* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, double* r,
              double* c, const double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGBRFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const double* ab, const MKL_INT* ldab, const double* afb,
               const MKL_INT* ldafb, const MKL_INT* ipiv, double* r,
               double* c, const double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbrfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const double* ab, const MKL_INT* ldab, const double* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, double* r,
              double* c, const double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbrfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const double* ab, const MKL_INT* ldab, const double* afb,
               const MKL_INT* ldafb, const MKL_INT* ipiv, double* r,
               double* c, const double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGBSV( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void DGBSV_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dgbsv( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dgbsv_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void DGBSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             double* ab, const MKL_INT* ldab, double* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGBSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             double* ab, const MKL_INT* ldab, double* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGBSVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGBSVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               double* ab, const MKL_INT* ldab, double* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbsvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgbsvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               double* ab, const MKL_INT* ldab, double* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGBTF2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info ) NOTHROW;
void DGBTF2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgbtf2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info ) NOTHROW;
void dgbtf2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DGBTRF( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info ) NOTHROW;
void DGBTRF_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgbtrf( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info ) NOTHROW;
void dgbtrf_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DGBTRS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void DGBTRS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dgbtrs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dgbtrs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void DGEBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
             const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void DGEBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
              const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void dgebak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
             const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void dgebak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
              const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info ) NOTHROW;

void DGEBAL( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info ) NOTHROW;
void DGEBAL_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info ) NOTHROW;
void dgebal( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info ) NOTHROW;
void dgebal_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info ) NOTHROW;

void DGEBD2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             MKL_INT* info ) NOTHROW;
void DGEBD2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, MKL_INT* info ) NOTHROW;
void dgebd2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             MKL_INT* info ) NOTHROW;
void dgebd2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, MKL_INT* info ) NOTHROW;

void DGEBRD( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEBRD_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dgebrd( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgebrd_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void DGECON( const char* norm, const MKL_INT* n, const double* a,
             const MKL_INT* lda, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGECON_( const char* norm, const MKL_INT* n, const double* a,
              const MKL_INT* lda, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgecon( const char* norm, const MKL_INT* n, const double* a,
             const MKL_INT* lda, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgecon_( const char* norm, const MKL_INT* n, const double* a,
              const MKL_INT* lda, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGEEQUB( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info ) NOTHROW;
void DGEEQUB_( const MKL_INT* m, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* r, double* c, double* rowcnd,
               double* colcnd, double* amax, MKL_INT* info ) NOTHROW;
void dgeequb( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info ) NOTHROW;
void dgeequb_( const MKL_INT* m, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* r, double* c, double* rowcnd,
               double* colcnd, double* amax, MKL_INT* info ) NOTHROW;

void DGEEQU( const MKL_INT* m, const MKL_INT* n, const double* a,
             const MKL_INT* lda, double* r, double* c, double* rowcnd,
             double* colcnd, double* amax, MKL_INT* info ) NOTHROW;
void DGEEQU_( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info ) NOTHROW;
void dgeequ( const MKL_INT* m, const MKL_INT* n, const double* a,
             const MKL_INT* lda, double* r, double* c, double* rowcnd,
             double* colcnd, double* amax, MKL_INT* info ) NOTHROW;
void dgeequ_( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info ) NOTHROW;

void DGEES( const char* jobvs, const char* sort,
            MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
            const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
            double* vs, const MKL_INT* ldvs, double* work,
            const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void DGEES_( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
             const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
             double* vs, const MKL_INT* ldvs, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void dgees( const char* jobvs, const char* sort,
            MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
            const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
            double* vs, const MKL_INT* ldvs, double* work,
            const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void dgees_( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
             const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
             double* vs, const MKL_INT* ldvs, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void DGEESX( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const char* sense,
             const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
             double* wr, double* wi, double* vs, const MKL_INT* ldvs,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void DGEESX_( const char* jobvs, const char* sort,
              MKL_D_SELECT_FUNCTION_2 select, const char* sense,
              const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
              double* wr, double* wi, double* vs, const MKL_INT* ldvs,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void dgeesx( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const char* sense,
             const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
             double* wr, double* wi, double* vs, const MKL_INT* ldvs,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* bwork, MKL_INT* info ) NOTHROW;
void dgeesx_( const char* jobvs, const char* sort,
              MKL_D_SELECT_FUNCTION_2 select, const char* sense,
              const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
              double* wr, double* wi, double* vs, const MKL_INT* ldvs,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* bwork, MKL_INT* info ) NOTHROW;

void DGEEV( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* wr, double* wi, double* vl,
            const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEEV_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeev( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* wr, double* wi, double* vl,
            const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeev_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGEEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* wr, double* wi, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgeevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgeevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* wr, double* wi, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGEGS( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
            double* alphar, double* alphai, double* beta, double* vsl,
            const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
            double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEGS_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgegs( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
            double* alphar, double* alphai, double* beta, double* vsl,
            const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
            double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgegs_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEGV( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
            double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
            double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEGV_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgegv( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
            double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
            double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgegv_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEHD2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             MKL_INT* info ) NOTHROW;
void DGEHD2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              MKL_INT* info ) NOTHROW;
void dgehd2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             MKL_INT* info ) NOTHROW;
void dgehd2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              MKL_INT* info ) NOTHROW;

void DGEHRD( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEHRD_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgehrd( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgehrd_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEJSV( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
             const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
             double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGEJSV_( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
              const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
              double* v, const MKL_INT* ldv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgejsv( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
             const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
             double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork,
             MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgejsv_( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
              const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
              double* v, const MKL_INT* ldv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGELQ2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void DGELQ2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgelq2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgelq2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;

void DGELQF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGELQF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelqf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelqf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGELSD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* s, const double* rcond, MKL_INT* rank,
             double* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void DGELSD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* s, const double* rcond,
              MKL_INT* rank, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgelsd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* s, const double* rcond, MKL_INT* rank,
             double* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info ) NOTHROW;
void dgelsd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* s, const double* rcond,
              MKL_INT* rank, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGELS( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
            const MKL_INT* ldb, double* work, const MKL_INT* lwork,
            MKL_INT* info ) NOTHROW;
void DGELS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void dgels( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
            const MKL_INT* ldb, double* work, const MKL_INT* lwork,
            MKL_INT* info ) NOTHROW;
void dgels_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;

void DGELSS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* s, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGELSS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* s, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelss( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* s, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelss_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* s, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGELSX( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             MKL_INT* info ) NOTHROW;
void DGELSX_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              MKL_INT* info ) NOTHROW;
void dgelsx( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             MKL_INT* info ) NOTHROW;
void dgelsx_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              MKL_INT* info ) NOTHROW;

void DGELSY( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGELSY_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelsy( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgelsy_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEQL2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void DGEQL2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeql2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeql2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;

void DGEQLF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEQLF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqlf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqlf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEQP3( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void DGEQP3_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqp3( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void dgeqp3_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEQPF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, MKL_INT* info ) NOTHROW;
void DGEQPF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              MKL_INT* info ) NOTHROW;
void dgeqpf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeqpf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              MKL_INT* info ) NOTHROW;

void DGEQR2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void DGEQR2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeqr2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeqr2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;

void DGEQR2P( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, MKL_INT* info ) NOTHROW;
void DGEQR2P_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeqr2p( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgeqr2p_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;

void DGEQRF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEQRF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqrf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqrf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGEQRFP( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGEQRFP_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqrfp( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgeqrfp_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work,
               const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGERFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const double* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
             const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGERFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const double* af,
              const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgerfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const double* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
             const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgerfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const double* af,
              const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGERFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
              const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const double* r, const double* c, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* rcond,
              double* berr, const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGERFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
               const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
               const double* r, const double* c, const double* b,
               const MKL_INT* ldb, double* x, const MKL_INT* ldx,
               double* rcond, double* berr, const MKL_INT* n_err_bnds,
               double* err_bnds_norm, double* err_bnds_comp,
               const MKL_INT* nparams, double* params, double* work,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgerfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
              const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const double* r, const double* c, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* rcond,
              double* berr, const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgerfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
               const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
               const double* r, const double* c, const double* b,
               const MKL_INT* ldb, double* x, const MKL_INT* ldx,
               double* rcond, double* berr, const MKL_INT* n_err_bnds,
               double* err_bnds_norm, double* err_bnds_comp,
               const MKL_INT* nparams, double* params, double* work,
               MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGERQ2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void DGERQ2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgerq2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info ) NOTHROW;
void dgerq2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info ) NOTHROW;

void DGERQF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGERQF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgerqf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgerqf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGESC2( const MKL_INT* n, const double* a, const MKL_INT* lda,
             double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             double* scale ) NOTHROW;
void DGESC2_( const MKL_INT* n, const double* a, const MKL_INT* lda,
              double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              double* scale ) NOTHROW;
void dgesc2( const MKL_INT* n, const double* a, const MKL_INT* lda,
             double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             double* scale ) NOTHROW;
void dgesc2_( const MKL_INT* n, const double* a, const MKL_INT* lda,
              double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              double* scale ) NOTHROW;

void DGESDD( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
             double* vt, const MKL_INT* ldvt, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGESDD_( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
              double* vt, const MKL_INT* ldvt, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesdd( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
             double* vt, const MKL_INT* ldvt, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesdd_( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
              double* vt, const MKL_INT* ldvt, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGESVD( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
             double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGESVD_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
              double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgesvd( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
             double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgesvd_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
              double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;

void DGESV( const MKL_INT* n, const MKL_INT* nrhs, double* a,
            const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
            MKL_INT* info ) NOTHROW;
void DGESV_( const MKL_INT* n, const MKL_INT* nrhs, double* a,
             const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;
void dgesv( const MKL_INT* n, const MKL_INT* nrhs, double* a,
            const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
            MKL_INT* info ) NOTHROW;
void dgesv_( const MKL_INT* n, const MKL_INT* nrhs, double* a,
             const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
             MKL_INT* info ) NOTHROW;

void DGESVJ( const char* joba, const char* jobu, const char* jobv,
             const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void DGESVJ_( const char* joba, const char* jobu, const char* jobv,
              const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, const MKL_INT* mv, double* v,
              const MKL_INT* ldv, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dgesvj( const char* joba, const char* jobu, const char* jobv,
             const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
             double* work, const MKL_INT* lwork, MKL_INT* info ) NOTHROW;
void dgesvj_( const char* joba, const char* jobu, const char* jobv,
              const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, const MKL_INT* mv, double* v,
              const MKL_INT* ldv, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void DGESVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
             const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGESVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
             const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGESVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void DGESVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
               const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;
void dgesvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
               const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info ) NOTHROW;

void DGETC2( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_INT* jpiv, MKL_INT* info ) NOTHROW;
void DGETC2_( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* jpiv, MKL_INT* info ) NOTHROW;
void dgetc2( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_INT* jpiv, MKL_INT* info ) NOTHROW;
void dgetc2_( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* jpiv, MKL_INT* info ) NOTHROW;

void DGETF2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DGETF2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgetf2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgetf2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void DGETRF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void DGETRF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgetrf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info ) NOTHROW;
void dgetrf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info ) NOTHROW;

void MKL_DGETRFNPI( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    double* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void MKL_DGETRFNPI_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     double* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_dgetrfnpi( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    double* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;
void mkl_dgetrfnpi_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     double* a, const MKL_INT* lda, MKL_INT* info ) NOTHROW;

void DGETRI( const MKL_INT* n, double* a, const MKL_INT* lda,
             const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void DGETRI_( const MKL_INT* n, double* a, const MKL_INT* lda,
              const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;
void dgetri( const MKL_INT* n, double* a, const MKL_INT* lda,
             const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
             MKL_INT* info ) NOTHROW;
void dgetri_( const MKL_INT* n, double* a, const MKL_INT* lda,
              const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
              MKL_INT* info ) NOTHROW;

void DGETRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void DGETRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
              double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dgetrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;
void dgetrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
              double* b, const MKL_INT* ldb, MKL_INT* info ) NOTHROW;

void DGGBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
             const double* rscale, const MKL_INT* m, double* v,
             const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void DGGBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
              const double* rscale, const MKL_INT* m, double* v,
              const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void dggbak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
             const double* rscale, const MKL_INT* m, double* v,
             const MKL_INT* ldv, MKL_INT* info ) NOTHROW;
void dggbak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
              const double* rscale, const MKL_INT* m, double* v,
              const MKL_INT* ldv, MKL_INT* info ) NOTHROW;

void DGGBAL( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
             double* lscale, double* rscale, double* work, MKL_INT* info ) NOTHROW;
void DGGBAL_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
              double* lscale, double* rscale, double* work, MKL_INT* info ) NOTHROW;
void dggbal( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
             double* lscale, double* rscale, double* work, MKL_INT* info ) NOTHROW;
void dggbal_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
              double* lscale, double* rscale, double* work, MKL_INT* info ) NOTHROW;

void DGGES( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_D_SELECT_FUNCTION_3 s